//
// Copyright 2016 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//

#include "pxr/pxr.h"

#include "pxr/base/tf/wrapTypeHelpers.h"

#include <boost/python/extract.hpp>
#include <boost/python/object.hpp>
#include <boost/python/detail/api_placeholder.hpp>      // for len()

using namespace std;
using namespace boost::python;

PXR_NAMESPACE_OPEN_SCOPE

TfType
TfType_DefinePythonTypeAndBases( const boost::python::object & classObj )
{
    string moduleName = extract<string>(classObj.attr("__module__"));
    string className = extract<string>(classObj.attr("__name__"));
    string typeName = moduleName + "." + className;

    // Extract the bases, and declare them if they have not yet been declared.
    object basesObj = classObj.attr("__bases__");
    vector<TfType> baseTypes;
    for (boost::python::ssize_t i=0; i < boost::python::len(basesObj); ++i)
    {
        boost::python::object baseClass = basesObj[i];

        TfType baseType = TfType::FindByPythonClass(baseClass);

        if (baseType.IsUnknown())
            baseType = TfType_DefinePythonTypeAndBases(baseClass);

        baseTypes.push_back( baseType );
    }

    // Declare the new type w/ bases
    TfType newType = TfType::Declare( typeName, baseTypes );

    newType.DefinePythonClass( classObj );

    return newType;
}

PXR_NAMESPACE_CLOSE_SCOPE
