/* i386-dos32.djgpp2.h
   created from i386-dos32.djgpp2.bin, 21808 (0x5530) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2023 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2023 Laszlo Molnar
   Copyright (C) 2000-2023 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_I386_DOS32_DJGPP2_SIZE    21808
#define STUB_I386_DOS32_DJGPP2_ADLER32 0xe2575c37
#define STUB_I386_DOS32_DJGPP2_CRC32   0xbb35e98b

unsigned char stub_i386_dos32_djgpp2[21808] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  20, 30,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0, 30,  7,190,  0,  0,  0,  0,191,  0,  0,  0,  0,
/* 0x0040 */  87,131,205,255, 49,192,140, 16,137, 96,  4,140,216,142,208,188,
/* 0x0050 */   0,  0,  0,  0,235,  3,164,235,  3,138,  6, 70,136,  7, 71,  1,
/* 0x0060 */ 219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192, 64,138,
/* 0x0070 */   7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,
/* 0x0080 */ 252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x0090 */ 115,255,  1,219,115,255,117,  9,139, 30,131,238,252, 17,219,115,
/* 0x00a0 */ 255, 49,201,131,232,  3,114, 13,193,224,  8,138,  6, 70,131,240,
/* 0x00b0 */ 255,116,255,137,197,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x00c0 */  17,201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,117,
/* 0x00d0 */ 255, 65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,
/* 0x00e0 */ 219,117,  7,139, 30,131,238,252, 17,219,115, 48,  1,219,115, 48,
/* 0x00f0 */ 117,  9,139, 30,131,238,252, 17,219,115, 48, 65, 65,131,193,  2,
/* 0x0100 */ 129,253,  0,243,255,255,131,209,  1, 86,141, 52, 47,243,164, 94,
/* 0x0110 */ 233,252,255,255,255,141, 20, 47,131,253,252,138,  4, 15,118,255,
/* 0x0120 */ 138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,139,  2,
/* 0x0130 */ 131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,
/* 0x0140 */ 252,255,255,255,235,  3,164,235,  3,138,  6, 70,136,  7, 71,  1,
/* 0x0150 */ 219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192, 64,138,
/* 0x0160 */   7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,
/* 0x0170 */ 252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x0180 */ 114, 15,  1,219,115, 11,117, 15,139, 30,131,238,252, 17,219,114,
/* 0x0190 */  15, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,235,
/* 0x01a0 */ 255, 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,240,
/* 0x01b0 */ 255,116,255,209,248,137,197,235, 11,  1,219,117,  7,139, 30,131,
/* 0x01c0 */ 238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x01d0 */ 219, 17,201,117,255, 65,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x01e0 */ 219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115, 68,
/* 0x01f0 */   1,219,115, 68,117,  9,139, 30,131,238,252, 17,219,115, 68, 65,
/* 0x0200 */  65,131,193,  2,129,253,  0,251,255,255,131,209,  1, 86,141, 52,
/* 0x0210 */  47,243,164, 94,233,252,255,255,255,141, 20, 47,131,253,252,138,
/* 0x0220 */   4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,
/* 0x0230 */ 255,255,139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,
/* 0x0240 */ 241,  1,207,233,252,255,255,255,235,  3,164,235,  3,138,  6, 70,
/* 0x0250 */ 136,  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1,
/* 0x0260 */  49,192, 64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,
/* 0x0270 */ 139, 30,131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,
/* 0x0280 */ 238,252, 17,219,114, 30,  1,219,115, 11,117, 30,139, 30,131,238,
/* 0x0290 */ 252, 17,219,114, 30, 72,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x02a0 */ 219, 17,192,235,255,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x02b0 */  17,201,235,255, 49,201,131,232,  3,114, 17,193,224,  8,138,  6,
/* 0x02c0 */  70,131,240,255,116,255,209,248,137,197,235, 11,  1,219,117,  7,
/* 0x02d0 */ 139, 30,131,238,252, 17,219,114,204, 65,  1,219,117,  7,139, 30,
/* 0x02e0 */ 131,238,252, 17,219,114,190,  1,219,117,  7,139, 30,131,238,252,
/* 0x02f0 */  17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115,
/* 0x0300 */  81,  1,219,115, 81,117,  9,139, 30,131,238,252, 17,219,115, 81,
/* 0x0310 */  65, 65,131,193,  2,129,253,  0,251,255,255,131,209,  2, 86,141,
/* 0x0320 */  52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,131,253,252,
/* 0x0330 */ 138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,
/* 0x0340 */ 255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,
/* 0x0350 */ 119,241,  1,207,233,252,255,255,255,137,229,141,156, 36,  0,  0,
/* 0x0360 */   0,  0, 49,192, 80, 57,220,117,251, 70, 70, 83,104,  0,  0,  0,
/* 0x0370 */   0, 87,131,195,  4, 83,104,  0,  0,  0,  0, 86,131,195,  4, 83,
/* 0x0380 */  80,199,  3,  0,  0,  0,  0,137,229,139, 85,  0,172, 74,136,193,
/* 0x0390 */  36,  7,192,233,  3,187,  0,253,255,255,211,227,141,164, 92,144,
/* 0x03a0 */ 241,255,255,131,228,224,106,  0,106,  0,137,227, 83,131,195,  4,
/* 0x03b0 */ 139, 77,  0,255, 49, 87, 83,131,195,  4,136, 67,  2,172, 74,136,
/* 0x03c0 */ 193, 36, 15,136,  3,192,233,  4,136, 75,  1, 82, 86, 83, 80, 85,
/* 0x03d0 */  87, 86, 83,131,236,124,139,148, 36,144,  0,  0,  0,199, 68, 36,
/* 0x03e0 */ 116,  0,  0,  0,  0,198, 68, 36,115,  0,139,172, 36,156,  0,  0,
/* 0x03f0 */   0,141, 66,  4,137, 68, 36,120,184,  1,  0,  0,  0, 15,182, 74,
/* 0x0400 */   2,137,195,211,227,137,217, 73,137, 76, 36,108, 15,182, 74,  1,
/* 0x0410 */ 211,224, 72,137, 68, 36,104,139,132, 36,168,  0,  0,  0, 15,182,
/* 0x0420 */  50,199, 69,  0,  0,  0,  0,  0,199, 68, 36, 96,  0,  0,  0,  0,
/* 0x0430 */ 199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,137,116, 36,100,199,
/* 0x0440 */  68, 36, 92,  1,  0,  0,  0,199, 68, 36, 88,  1,  0,  0,  0,199,
/* 0x0450 */  68, 36, 84,  1,  0,  0,  0,199, 68, 36, 80,  1,  0,  0,  0, 15,
/* 0x0460 */ 182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,  0, 57, 76, 36,
/* 0x0470 */ 116,115, 14,139, 68, 36,120,102,199,  0,  0,  4,131,192,  2,226,
/* 0x0480 */ 246,139,156, 36,148,  0,  0,  0, 49,255,199, 68, 36, 72,255,255,
/* 0x0490 */ 255,255,137,218,  3,148, 36,152,  0,  0,  0,137, 84, 36, 76, 49,
/* 0x04a0 */ 210, 59, 92, 36, 76, 15,132,124,  9,  0,  0, 15,182,  3,193,231,
/* 0x04b0 */   8, 66, 67,  9,199,131,250,  4,126,231,139,140, 36,164,  0,  0,
/* 0x04c0 */   0, 57, 76, 36,116, 15,131,100,  9,  0,  0,139,116, 36,116, 35,
/* 0x04d0 */ 116, 36,108,139, 68, 36, 96,139, 84, 36,120,193,224,  4,137,116,
/* 0x04e0 */  36, 68,  1,240,129,124, 36, 72,255,255,255,  0,141, 44, 66,119,
/* 0x04f0 */  24, 59, 92, 36, 76, 15,132, 44,  9,  0,  0,193,100, 36, 72,  8,
/* 0x0500 */  15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,
/* 0x0510 */   0,193,232, 11, 15,183,202, 15,175,193, 57,199, 15,131,221,  1,
/* 0x0520 */   0,  0,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,138, 76, 36,
/* 0x0530 */ 100,193,248,  5,190,  1,  0,  0,  0,141,  4,  2, 15,182, 84, 36,
/* 0x0540 */ 115,102,137, 69,  0,139, 68, 36,116, 35, 68, 36,104,139,108, 36,
/* 0x0550 */ 120,211,224,185,  8,  0,  0,  0, 43, 76, 36,100,211,250,  1,208,
/* 0x0560 */ 105,192,  0,  6,  0,  0,131,124, 36, 96,  6,141,132,  5,108, 14,
/* 0x0570 */   0,  0,137, 68, 36, 20, 15,142,202,  0,  0,  0,139, 68, 36,116,
/* 0x0580 */  43, 68, 36, 92,139,148, 36,160,  0,  0,  0, 15,182,  4,  2,137,
/* 0x0590 */  68, 36, 64,209,100, 36, 64,139, 76, 36, 64,141, 20, 54,139,108,
/* 0x05a0 */  36, 20,129,225,  0,  1,  0,  0,129,124, 36, 72,255,255,255,  0,
/* 0x05b0 */ 141, 68, 77,  0,137, 76, 36, 60,141, 44, 16,119, 24, 59, 92, 36,
/* 0x05c0 */  76, 15,132, 96,  8,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,
/* 0x05d0 */ 231,  8, 67,  9,199,139, 68, 36, 72,102,139,141,  0,  2,  0,  0,
/* 0x05e0 */ 193,232, 11, 15,183,241, 15,175,198, 57,199,115, 35,137, 68, 36,
/* 0x05f0 */  72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,131,124, 36,
/* 0x0600 */  60,  0,141,  4,  1,102,137,133,  0,  2,  0,  0,116, 34,235, 46,
/* 0x0610 */  41, 68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,  5,102,
/* 0x0620 */  41,193,131,124, 36, 60,  0,102,137,141,  0,  2,  0,  0,116, 14,
/* 0x0630 */ 129,254,255,  0,  0,  0, 15,142, 87,255,255,255,235,121,129,254,
/* 0x0640 */ 255,  0,  0,  0,127,113,141, 20, 54,139,108, 36, 20,  1,213,129,
/* 0x0650 */ 124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,196,
/* 0x0660 */   7,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,
/* 0x0670 */ 199,139, 68, 36, 72,102,139, 77,  0,193,232, 11, 15,183,241, 15,
/* 0x0680 */ 175,198, 57,199,115, 25,137, 68, 36, 72,184,  0,  8,  0,  0, 41,
/* 0x0690 */ 240,137,214,193,248,  5,141,  4,  1,102,137, 69,  0,235,159, 41,
/* 0x06a0 */  68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,  5,102, 41,
/* 0x06b0 */ 193,102,137, 77,  0,235,135,139, 84, 36,116,137,240,139,140, 36,
/* 0x06c0 */ 160,  0,  0,  0,136, 68, 36,115,136,  4, 10, 66,131,124, 36, 96,
/* 0x06d0 */   3,137, 84, 36,116,127, 13,199, 68, 36, 96,  0,  0,  0,  0,233,
/* 0x06e0 */  27,  7,  0,  0,131,124, 36, 96,  9,127, 10,131,108, 36, 96,  3,
/* 0x06f0 */ 233, 10,  7,  0,  0,131,108, 36, 96,  6,233,  0,  7,  0,  0,139,
/* 0x0700 */  76, 36, 72, 41,199,139,116, 36, 96, 41,193,137,208,102,193,232,
/* 0x0710 */   5,102, 41,194,129,249,255,255,255,  0,102,137, 85,  0,139,108,
/* 0x0720 */  36,120,141,116,117,  0,137,116, 36, 56,119, 22, 59, 92, 36, 76,
/* 0x0730 */  15,132,241,  6,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,
/* 0x0740 */   9,199,139,108, 36, 56,137,200,193,232, 11,102,139,149,128,  1,
/* 0x0750 */   0,  0, 15,183,234, 15,175,197, 57,199,115, 82,137,198,184,  0,
/* 0x0760 */   8,  0,  0, 41,232,139,108, 36, 88,193,248,  5,139, 76, 36, 84,
/* 0x0770 */ 141,  4,  2,139, 84, 36, 56,137, 76, 36, 80,139, 76, 36,120,102,
/* 0x0780 */ 137,130,128,  1,  0,  0,139, 68, 36, 92,137,108, 36, 84,137, 68,
/* 0x0790 */  36, 88, 49,192,131,124, 36, 96,  6, 15,159,192,129,193,100,  6,
/* 0x07a0 */   0,  0,141,  4, 64,137, 68, 36, 96,233,116,  2,  0,  0,137,206,
/* 0x07b0 */  41,199, 41,198,137,208,102,193,232,  5,139, 76, 36, 56,102, 41,
/* 0x07c0 */ 194,129,254,255,255,255,  0,102,137,145,128,  1,  0,  0,119, 22,
/* 0x07d0 */  59, 92, 36, 76, 15,132, 77,  6,  0,  0, 15,182,  3,193,231,  8,
/* 0x07e0 */ 193,230,  8, 67,  9,199,139,108, 36, 56,137,242,193,234, 11,102,
/* 0x07f0 */ 139,141,152,  1,  0,  0, 15,183,193, 15,175,208, 57,215, 15,131,
/* 0x0800 */ 227,  0,  0,  0,189,  0,  8,  0,  0,137,214, 41,197,199, 68, 36,
/* 0x0810 */  52,  0,  8,  0,  0,137,232,193,248,  5,141,  4,  1,139, 76, 36,
/* 0x0820 */  56,102,137,129,152,  1,  0,  0,139, 68, 36, 96,139, 76, 36, 68,
/* 0x0830 */ 193,224,  5,  3, 68, 36,120,129,250,255,255,255,  0,141, 44, 72,
/* 0x0840 */ 119, 22, 59, 92, 36, 76, 15,132,219,  5,  0,  0, 15,182,  3,193,
/* 0x0850 */ 231,  8,193,230,  8, 67,  9,199,102,139,149,224,  1,  0,  0,137,
/* 0x0860 */ 240,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 96, 41, 76,
/* 0x0870 */  36, 52,193,124, 36, 52,  5,139,116, 36, 52,137, 68, 36, 72,131,
/* 0x0880 */ 124, 36,116,  0,141,  4, 50,102,137,133,224,  1,  0,  0, 15,132,
/* 0x0890 */ 147,  5,  0,  0, 49,192,131,124, 36, 96,  6,139,172, 36,160,  0,
/* 0x08a0 */   0,  0,139, 84, 36,116, 15,159,192,141, 68,  0,  9,137, 68, 36,
/* 0x08b0 */  96,139, 68, 36,116, 43, 68, 36, 92,138, 68,  5,  0,136, 68, 36,
/* 0x08c0 */ 115,136,  4, 42, 66,137, 84, 36,116,233, 49,  5,  0,  0, 41,198,
/* 0x08d0 */  41,199,137,208,102,193,232,  5,102, 41,194,102,137,149,224,  1,
/* 0x08e0 */   0,  0,233, 31,  1,  0,  0,137,200, 41,214,102,193,232,  5,139,
/* 0x08f0 */ 108, 36, 56,102, 41,193, 41,215,129,254,255,255,255,  0,102,137,
/* 0x0900 */ 141,152,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 22,  5,  0,
/* 0x0910 */   0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139, 76, 36,
/* 0x0920 */  56,137,240,193,232, 11,102,139,145,176,  1,  0,  0, 15,183,202,
/* 0x0930 */  15,175,193, 57,199,115, 35,137,198,184,  0,  8,  0,  0, 41,200,
/* 0x0940 */ 139,108, 36, 56,193,248,  5,141,  4,  2,102,137,133,176,  1,  0,
/* 0x0950 */   0,139, 68, 36, 88,233,160,  0,  0,  0,137,241, 41,199, 41,193,
/* 0x0960 */ 137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,129,249,255,
/* 0x0970 */ 255,255,  0,102,137,144,176,  1,  0,  0,119, 22, 59, 92, 36, 76,
/* 0x0980 */  15,132,161,  4,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,
/* 0x0990 */   9,199,139,116, 36, 56,137,200,193,232, 11,102,139,150,200,  1,
/* 0x09a0 */   0,  0, 15,183,234, 15,175,197, 57,199,115, 32,137,198,184,  0,
/* 0x09b0 */   8,  0,  0, 41,232,139,108, 36, 56,193,248,  5,141,  4,  2,102,
/* 0x09c0 */ 137,133,200,  1,  0,  0,139, 68, 36, 84,235, 38,137,206, 41,199,
/* 0x09d0 */  41,198,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,102,
/* 0x09e0 */ 137,144,200,  1,  0,  0,139, 84, 36, 84,139, 68, 36, 80,137, 84,
/* 0x09f0 */  36, 80,139, 76, 36, 88,137, 76, 36, 84,139,108, 36, 92,137, 68,
/* 0x0a00 */  36, 92,137,108, 36, 88, 49,192,131,124, 36, 96,  6,139, 76, 36,
/* 0x0a10 */ 120, 15,159,192,129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68,
/* 0x0a20 */  36, 96,129,254,255,255,255,  0,119, 22, 59, 92, 36, 76, 15,132,
/* 0x0a30 */ 243,  3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,
/* 0x0a40 */ 102,139, 17,137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,
/* 0x0a50 */ 115, 47,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36,
/* 0x0a60 */  68,  4,193,248,  5,199, 68, 36, 44,  0,  0,  0,  0,141,  4,  2,
/* 0x0a70 */ 102,137,  1,139, 68, 36, 68,141, 76,  1,  4,137, 76, 36, 16,235,
/* 0x0a80 */ 114, 41,198, 41,199,137,208,102,193,232,  5,102, 41,194,129,254,
/* 0x0a90 */ 255,255,255,  0,102,137, 17,119, 22, 59, 92, 36, 76, 15,132,132,
/* 0x0aa0 */   3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,
/* 0x0ab0 */ 139, 81,  2,137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,
/* 0x0ac0 */ 115, 59,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36,
/* 0x0ad0 */  68,  4,193,248,  5,199, 68, 36, 44,  8,  0,  0,  0,141,  4,  2,
/* 0x0ae0 */ 139, 84, 36, 68,102,137, 65,  2,141,140, 17,  4,  1,  0,  0,137,
/* 0x0af0 */  76, 36, 16,199, 68, 36, 48,  3,  0,  0,  0,235, 47, 41,198, 41,
/* 0x0b00 */ 199,137,208,137,116, 36, 72,102,193,232,  5,199, 68, 36, 44, 16,
/* 0x0b10 */   0,  0,  0,102, 41,194,199, 68, 36, 48,  8,  0,  0,  0,102,137,
/* 0x0b20 */  81,  2,129,193,  4,  2,  0,  0,137, 76, 36, 16,139, 76, 36, 48,
/* 0x0b30 */ 186,  1,  0,  0,  0,137, 76, 36, 40,141, 44, 18,139,116, 36, 16,
/* 0x0b40 */   1,238,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76,
/* 0x0b50 */  15,132,209,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,
/* 0x0b60 */   8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,
/* 0x0b70 */ 202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,
/* 0x0b80 */   0, 41,200,193,248,  5,141,  4,  2,137,234,102,137,  6,235, 21,
/* 0x0b90 */  41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,102,
/* 0x0ba0 */ 137, 22,141, 85,  1,139,116, 36, 40, 78,137,116, 36, 40,117,137,
/* 0x0bb0 */ 138, 76, 36, 48,184,  1,  0,  0,  0,211,224, 41,194,  3, 84, 36,
/* 0x0bc0 */  44,131,124, 36, 96,  3,137, 84, 36, 12, 15,143,231,  1,  0,  0,
/* 0x0bd0 */ 131, 68, 36, 96,  7,131,250,  3,137,208,126,  5,184,  3,  0,  0,
/* 0x0be0 */   0,139,116, 36,120,193,224,  7,199, 68, 36, 36,  6,  0,  0,  0,
/* 0x0bf0 */ 141,132,  6, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,
/* 0x0c00 */ 141, 44,  0,139,116, 36,  8,  1,238,129,124, 36, 72,255,255,255,
/* 0x0c10 */   0,119, 24, 59, 92, 36, 76, 15,132, 10,  2,  0,  0,193,100, 36,
/* 0x0c20 */  72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,
/* 0x0c30 */ 139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 24,137,
/* 0x0c40 */  68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,
/* 0x0c50 */ 102,137,  6,137,232,235, 21, 41, 68, 36, 72, 41,199,137,208,102,
/* 0x0c60 */ 193,232,  5,102, 41,194,141, 69,  1,102,137, 22,139,108, 36, 36,
/* 0x0c70 */  77,137,108, 36, 36,117,137,141, 80,192,131,250,  3,137, 20, 36,
/* 0x0c80 */  15,142, 39,  1,  0,  0,137,208,137,214,209,248,131,230,  1,141,
/* 0x0c90 */  72,255,131,206,  2,131,250, 13,137, 76, 36, 32,127, 28,139,108,
/* 0x0ca0 */  36,120,211,230,  1,210,137, 52, 36,141, 68,117,  0, 41,208,  5,
/* 0x0cb0 */  94,  5,  0,  0,137, 68, 36,  4,235, 86,141, 80,251,129,124, 36,
/* 0x0cc0 */  72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 86,  1,  0,
/* 0x0cd0 */   0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,209,
/* 0x0ce0 */ 108, 36, 72,  1,246, 59,124, 36, 72,114,  7, 43,124, 36, 72,131,
/* 0x0cf0 */ 206,  1, 74,117,200,139, 68, 36,120,193,230,  4,137, 52, 36,  5,
/* 0x0d00 */  68,  6,  0,  0,199, 68, 36, 32,  4,  0,  0,  0,137, 68, 36,  4,
/* 0x0d10 */ 199, 68, 36, 28,  1,  0,  0,  0,184,  1,  0,  0,  0,139,108, 36,
/* 0x0d20 */   4,  1,192,137, 68, 36, 24,  1,197,129,124, 36, 72,255,255,255,
/* 0x0d30 */   0,119, 24, 59, 92, 36, 76, 15,132,234,  0,  0,  0,193,100, 36,
/* 0x0d40 */  72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,
/* 0x0d50 */ 139, 85,  0,193,232, 11, 15,183,242, 15,175,198, 57,199,115, 27,
/* 0x0d60 */ 137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,193,248,  5,141,  4,
/* 0x0d70 */   2,102,137, 69,  0,139, 68, 36, 24,235, 31, 41, 68, 36, 72, 41,
/* 0x0d80 */ 199,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 24,102,137,
/* 0x0d90 */  85,  0,139, 84, 36, 28, 64,  9, 20, 36,139, 76, 36, 32,209,100,
/* 0x0da0 */  36, 28, 73,137, 76, 36, 32, 15,133,112,255,255,255,139, 52, 36,
/* 0x0db0 */  70,137,116, 36, 92,116, 89,139, 76, 36, 12,139,108, 36,116,131,
/* 0x0dc0 */ 193,  2, 57,108, 36, 92,119, 95,139,132, 36,160,  0,  0,  0,137,
/* 0x0dd0 */ 234, 43, 68, 36, 92,  3,148, 36,160,  0,  0,  0,141, 52, 40,138,
/* 0x0de0 */   6, 70,136, 68, 36,115,136,  2, 66,255, 68, 36,116, 73,116, 15,
/* 0x0df0 */ 139,172, 36,164,  0,  0,  0, 57,108, 36,116,114,226,235, 17,139,
/* 0x0e00 */ 132, 36,164,  0,  0,  0, 57, 68, 36,116, 15,130,187,246,255,255,
/* 0x0e10 */ 129,124, 36, 72,255,255,255,  0,119, 21, 59, 92, 36, 76,184,  1,
/* 0x0e20 */   0,  0,  0,116, 41,235,  7,184,  1,  0,  0,  0,235, 32, 67, 43,
/* 0x0e30 */ 156, 36,148,  0,  0,  0, 49,192,139,148, 36,156,  0,  0,  0,139,
/* 0x0e40 */  76, 36,116,137, 26,139,156, 36,168,  0,  0,  0,137, 11,131,196,
/* 0x0e50 */ 124, 91, 94, 95, 93, 85, 87, 86, 83,131,236,124,139,148, 36,144,
/* 0x0e60 */   0,  0,  0,199, 68, 36,116,  0,  0,  0,  0,198, 68, 36,115,  0,
/* 0x0e70 */ 139,172, 36,156,  0,  0,  0,141, 66,  4,137, 68, 36,120,184,  1,
/* 0x0e80 */   0,  0,  0, 15,182, 74,  2,137,195,211,227,137,217, 73,137, 76,
/* 0x0e90 */  36,108, 15,182, 74,  1,211,224, 72,137, 68, 36,104,139,132, 36,
/* 0x0ea0 */ 168,  0,  0,  0, 15,182, 50,199, 69,  0,  0,  0,  0,  0,199, 68,
/* 0x0eb0 */  36, 96,  0,  0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,
/* 0x0ec0 */   0,137,116, 36,100,199, 68, 36, 92,  1,  0,  0,  0,199, 68, 36,
/* 0x0ed0 */  88,  1,  0,  0,  0,199, 68, 36, 84,  1,  0,  0,  0,199, 68, 36,
/* 0x0ee0 */  80,  1,  0,  0,  0, 15,182, 74,  1,  1,241,211,224,141,136, 54,
/* 0x0ef0 */   7,  0,  0, 57, 76, 36,116,115, 14,139, 68, 36,120,102,199,  0,
/* 0x0f00 */   0,  4,131,192,  2,226,246,139,156, 36,148,  0,  0,  0, 49,255,
/* 0x0f10 */ 199, 68, 36, 72,255,255,255,255,137,218,  3,148, 36,152,  0,  0,
/* 0x0f20 */   0,137, 84, 36, 76, 49,210, 59, 92, 36, 76, 15,132,124,  9,  0,
/* 0x0f30 */   0, 15,182,  3,193,231,  8, 66, 67,  9,199,131,250,  4,126,231,
/* 0x0f40 */ 139,140, 36,164,  0,  0,  0, 57, 76, 36,116, 15,131,100,  9,  0,
/* 0x0f50 */   0,139,116, 36,116, 35,116, 36,108,139, 68, 36, 96,139, 84, 36,
/* 0x0f60 */ 120,193,224,  4,137,116, 36, 68,  1,240,129,124, 36, 72,255,255,
/* 0x0f70 */ 255,  0,141, 44, 66,119, 24, 59, 92, 36, 76, 15,132, 44,  9,  0,
/* 0x0f80 */   0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139,
/* 0x0f90 */  68, 36, 72,102,139, 85,  0,193,232, 11, 15,183,202, 15,175,193,
/* 0x0fa0 */  57,199, 15,131,221,  1,  0,  0,137, 68, 36, 72,184,  0,  8,  0,
/* 0x0fb0 */   0, 41,200,138, 76, 36,100,193,248,  5,190,  1,  0,  0,  0,141,
/* 0x0fc0 */   4,  2, 15,182, 84, 36,115,102,137, 69,  0,139, 68, 36,116, 35,
/* 0x0fd0 */  68, 36,104,139,108, 36,120,211,224,185,  8,  0,  0,  0, 43, 76,
/* 0x0fe0 */  36,100,211,250,  1,208,105,192,  0,  6,  0,  0,131,124, 36, 96,
/* 0x0ff0 */   6,141,132,  5,108, 14,  0,  0,137, 68, 36, 20, 15,142,202,  0,
/* 0x1000 */   0,  0,139, 68, 36,116, 43, 68, 36, 92,139,148, 36,160,  0,  0,
/* 0x1010 */   0, 15,182,  4,  2,137, 68, 36, 64,209,100, 36, 64,139, 76, 36,
/* 0x1020 */  64,141, 20, 54,139,108, 36, 20,129,225,  0,  1,  0,  0,129,124,
/* 0x1030 */  36, 72,255,255,255,  0,141, 68, 77,  0,137, 76, 36, 60,141, 44,
/* 0x1040 */  16,119, 24, 59, 92, 36, 76, 15,132, 96,  8,  0,  0,193,100, 36,
/* 0x1050 */  72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,
/* 0x1060 */ 139,141,  0,  2,  0,  0,193,232, 11, 15,183,241, 15,175,198, 57,
/* 0x1070 */ 199,115, 35,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,
/* 0x1080 */ 193,248,  5,131,124, 36, 60,  0,141,  4,  1,102,137,133,  0,  2,
/* 0x1090 */   0,  0,116, 34,235, 46, 41, 68, 36, 72, 41,199,137,200,141,114,
/* 0x10a0 */   1,102,193,232,  5,102, 41,193,131,124, 36, 60,  0,102,137,141,
/* 0x10b0 */   0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,142, 87,255,
/* 0x10c0 */ 255,255,235,121,129,254,255,  0,  0,  0,127,113,141, 20, 54,139,
/* 0x10d0 */ 108, 36, 20,  1,213,129,124, 36, 72,255,255,255,  0,119, 24, 59,
/* 0x10e0 */  92, 36, 76, 15,132,196,  7,  0,  0,193,100, 36, 72,  8, 15,182,
/* 0x10f0 */   3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 77,  0,193,
/* 0x1100 */ 232, 11, 15,183,241, 15,175,198, 57,199,115, 25,137, 68, 36, 72,
/* 0x1110 */ 184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,141,  4,  1,102,
/* 0x1120 */ 137, 69,  0,235,159, 41, 68, 36, 72, 41,199,137,200,141,114,  1,
/* 0x1130 */ 102,193,232,  5,102, 41,193,102,137, 77,  0,235,135,139, 84, 36,
/* 0x1140 */ 116,137,240,139,140, 36,160,  0,  0,  0,136, 68, 36,115,136,  4,
/* 0x1150 */  10, 66,131,124, 36, 96,  3,137, 84, 36,116,127, 13,199, 68, 36,
/* 0x1160 */  96,  0,  0,  0,  0,233, 27,  7,  0,  0,131,124, 36, 96,  9,127,
/* 0x1170 */  10,131,108, 36, 96,  3,233, 10,  7,  0,  0,131,108, 36, 96,  6,
/* 0x1180 */ 233,  0,  7,  0,  0,139, 76, 36, 72, 41,199,139,116, 36, 96, 41,
/* 0x1190 */ 193,137,208,102,193,232,  5,102, 41,194,129,249,255,255,255,  0,
/* 0x11a0 */ 102,137, 85,  0,139,108, 36,120,141,116,117,  0,137,116, 36, 56,
/* 0x11b0 */ 119, 22, 59, 92, 36, 76, 15,132,241,  6,  0,  0, 15,182,  3,193,
/* 0x11c0 */ 231,  8,193,225,  8, 67,  9,199,139,108, 36, 56,137,200,193,232,
/* 0x11d0 */  11,102,139,149,128,  1,  0,  0, 15,183,234, 15,175,197, 57,199,
/* 0x11e0 */ 115, 82,137,198,184,  0,  8,  0,  0, 41,232,139,108, 36, 88,193,
/* 0x11f0 */ 248,  5,139, 76, 36, 84,141,  4,  2,139, 84, 36, 56,137, 76, 36,
/* 0x1200 */  80,139, 76, 36,120,102,137,130,128,  1,  0,  0,139, 68, 36, 92,
/* 0x1210 */ 137,108, 36, 84,137, 68, 36, 88, 49,192,131,124, 36, 96,  6, 15,
/* 0x1220 */ 159,192,129,193,100,  6,  0,  0,141,  4, 64,137, 68, 36, 96,233,
/* 0x1230 */ 116,  2,  0,  0,137,206, 41,199, 41,198,137,208,102,193,232,  5,
/* 0x1240 */ 139, 76, 36, 56,102, 41,194,129,254,255,255,255,  0,102,137,145,
/* 0x1250 */ 128,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 77,  6,  0,  0,
/* 0x1260 */  15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139,108, 36, 56,
/* 0x1270 */ 137,242,193,234, 11,102,139,141,152,  1,  0,  0, 15,183,193, 15,
/* 0x1280 */ 175,208, 57,215, 15,131,227,  0,  0,  0,189,  0,  8,  0,  0,137,
/* 0x1290 */ 214, 41,197,199, 68, 36, 52,  0,  8,  0,  0,137,232,193,248,  5,
/* 0x12a0 */ 141,  4,  1,139, 76, 36, 56,102,137,129,152,  1,  0,  0,139, 68,
/* 0x12b0 */  36, 96,139, 76, 36, 68,193,224,  5,  3, 68, 36,120,129,250,255,
/* 0x12c0 */ 255,255,  0,141, 44, 72,119, 22, 59, 92, 36, 76, 15,132,219,  5,
/* 0x12d0 */   0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139,
/* 0x12e0 */ 149,224,  1,  0,  0,137,240,193,232, 11, 15,183,202, 15,175,193,
/* 0x12f0 */  57,199,115, 96, 41, 76, 36, 52,193,124, 36, 52,  5,139,116, 36,
/* 0x1300 */  52,137, 68, 36, 72,131,124, 36,116,  0,141,  4, 50,102,137,133,
/* 0x1310 */ 224,  1,  0,  0, 15,132,147,  5,  0,  0, 49,192,131,124, 36, 96,
/* 0x1320 */   6,139,172, 36,160,  0,  0,  0,139, 84, 36,116, 15,159,192,141,
/* 0x1330 */  68,  0,  9,137, 68, 36, 96,139, 68, 36,116, 43, 68, 36, 92,138,
/* 0x1340 */  68,  5,  0,136, 68, 36,115,136,  4, 42, 66,137, 84, 36,116,233,
/* 0x1350 */  49,  5,  0,  0, 41,198, 41,199,137,208,102,193,232,  5,102, 41,
/* 0x1360 */ 194,102,137,149,224,  1,  0,  0,233, 31,  1,  0,  0,137,200, 41,
/* 0x1370 */ 214,102,193,232,  5,139,108, 36, 56,102, 41,193, 41,215,129,254,
/* 0x1380 */ 255,255,255,  0,102,137,141,152,  1,  0,  0,119, 22, 59, 92, 36,
/* 0x1390 */  76, 15,132, 22,  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8,
/* 0x13a0 */  67,  9,199,139, 76, 36, 56,137,240,193,232, 11,102,139,145,176,
/* 0x13b0 */   1,  0,  0, 15,183,202, 15,175,193, 57,199,115, 35,137,198,184,
/* 0x13c0 */   0,  8,  0,  0, 41,200,139,108, 36, 56,193,248,  5,141,  4,  2,
/* 0x13d0 */ 102,137,133,176,  1,  0,  0,139, 68, 36, 88,233,160,  0,  0,  0,
/* 0x13e0 */ 137,241, 41,199, 41,193,137,208,102,193,232,  5,102, 41,194,139,
/* 0x13f0 */  68, 36, 56,129,249,255,255,255,  0,102,137,144,176,  1,  0,  0,
/* 0x1400 */ 119, 22, 59, 92, 36, 76, 15,132,161,  4,  0,  0, 15,182,  3,193,
/* 0x1410 */ 231,  8,193,225,  8, 67,  9,199,139,116, 36, 56,137,200,193,232,
/* 0x1420 */  11,102,139,150,200,  1,  0,  0, 15,183,234, 15,175,197, 57,199,
/* 0x1430 */ 115, 32,137,198,184,  0,  8,  0,  0, 41,232,139,108, 36, 56,193,
/* 0x1440 */ 248,  5,141,  4,  2,102,137,133,200,  1,  0,  0,139, 68, 36, 84,
/* 0x1450 */ 235, 38,137,206, 41,199, 41,198,137,208,102,193,232,  5,102, 41,
/* 0x1460 */ 194,139, 68, 36, 56,102,137,144,200,  1,  0,  0,139, 84, 36, 84,
/* 0x1470 */ 139, 68, 36, 80,137, 84, 36, 80,139, 76, 36, 88,137, 76, 36, 84,
/* 0x1480 */ 139,108, 36, 92,137, 68, 36, 92,137,108, 36, 88, 49,192,131,124,
/* 0x1490 */  36, 96,  6,139, 76, 36,120, 15,159,192,129,193,104, 10,  0,  0,
/* 0x14a0 */ 141, 68, 64,  8,137, 68, 36, 96,129,254,255,255,255,  0,119, 22,
/* 0x14b0 */  59, 92, 36, 76, 15,132,243,  3,  0,  0, 15,182,  3,193,231,  8,
/* 0x14c0 */ 193,230,  8, 67,  9,199,102,139, 17,137,240,193,232, 11, 15,183,
/* 0x14d0 */ 234, 15,175,197, 57,199,115, 47,137, 68, 36, 72,184,  0,  8,  0,
/* 0x14e0 */   0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  0,
/* 0x14f0 */   0,  0,  0,141,  4,  2,102,137,  1,139, 68, 36, 68,141, 76,  1,
/* 0x1500 */   4,137, 76, 36, 16,235,114, 41,198, 41,199,137,208,102,193,232,
/* 0x1510 */   5,102, 41,194,129,254,255,255,255,  0,102,137, 17,119, 22, 59,
/* 0x1520 */  92, 36, 76, 15,132,132,  3,  0,  0, 15,182,  3,193,231,  8,193,
/* 0x1530 */ 230,  8, 67,  9,199,102,139, 81,  2,137,240,193,232, 11, 15,183,
/* 0x1540 */ 234, 15,175,197, 57,199,115, 59,137, 68, 36, 72,184,  0,  8,  0,
/* 0x1550 */   0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68, 36, 44,  8,
/* 0x1560 */   0,  0,  0,141,  4,  2,139, 84, 36, 68,102,137, 65,  2,141,140,
/* 0x1570 */  17,  4,  1,  0,  0,137, 76, 36, 16,199, 68, 36, 48,  3,  0,  0,
/* 0x1580 */   0,235, 47, 41,198, 41,199,137,208,137,116, 36, 72,102,193,232,
/* 0x1590 */   5,199, 68, 36, 44, 16,  0,  0,  0,102, 41,194,199, 68, 36, 48,
/* 0x15a0 */   8,  0,  0,  0,102,137, 81,  2,129,193,  4,  2,  0,  0,137, 76,
/* 0x15b0 */  36, 16,139, 76, 36, 48,186,  1,  0,  0,  0,137, 76, 36, 40,141,
/* 0x15c0 */  44, 18,139,116, 36, 16,  1,238,129,124, 36, 72,255,255,255,  0,
/* 0x15d0 */ 119, 24, 59, 92, 36, 76, 15,132,209,  2,  0,  0,193,100, 36, 72,
/* 0x15e0 */   8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,
/* 0x15f0 */  22,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 24,137, 68,
/* 0x1600 */  36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,137,
/* 0x1610 */ 234,102,137,  6,235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,
/* 0x1620 */ 232,  5,102, 41,194,102,137, 22,141, 85,  1,139,116, 36, 40, 78,
/* 0x1630 */ 137,116, 36, 40,117,137,138, 76, 36, 48,184,  1,  0,  0,  0,211,
/* 0x1640 */ 224, 41,194,  3, 84, 36, 44,131,124, 36, 96,  3,137, 84, 36, 12,
/* 0x1650 */  15,143,231,  1,  0,  0,131, 68, 36, 96,  7,131,250,  3,137,208,
/* 0x1660 */ 126,  5,184,  3,  0,  0,  0,139,116, 36,120,193,224,  7,199, 68,
/* 0x1670 */  36, 36,  6,  0,  0,  0,141,132,  6, 96,  3,  0,  0,137, 68, 36,
/* 0x1680 */   8,184,  1,  0,  0,  0,141, 44,  0,139,116, 36,  8,  1,238,129,
/* 0x1690 */ 124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 10,
/* 0x16a0 */   2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,
/* 0x16b0 */ 199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,202, 15,175,
/* 0x16c0 */ 193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,
/* 0x16d0 */ 193,248,  5,141,  4,  2,102,137,  6,137,232,235, 21, 41, 68, 36,
/* 0x16e0 */  72, 41,199,137,208,102,193,232,  5,102, 41,194,141, 69,  1,102,
/* 0x16f0 */ 137, 22,139,108, 36, 36, 77,137,108, 36, 36,117,137,141, 80,192,
/* 0x1700 */ 131,250,  3,137, 20, 36, 15,142, 39,  1,  0,  0,137,208,137,214,
/* 0x1710 */ 209,248,131,230,  1,141, 72,255,131,206,  2,131,250, 13,137, 76,
/* 0x1720 */  36, 32,127, 28,139,108, 36,120,211,230,  1,210,137, 52, 36,141,
/* 0x1730 */  68,117,  0, 41,208,  5, 94,  5,  0,  0,137, 68, 36,  4,235, 86,
/* 0x1740 */ 141, 80,251,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36,
/* 0x1750 */  76, 15,132, 86,  1,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,
/* 0x1760 */ 231,  8, 67,  9,199,209,108, 36, 72,  1,246, 59,124, 36, 72,114,
/* 0x1770 */   7, 43,124, 36, 72,131,206,  1, 74,117,200,139, 68, 36,120,193,
/* 0x1780 */ 230,  4,137, 52, 36,  5, 68,  6,  0,  0,199, 68, 36, 32,  4,  0,
/* 0x1790 */   0,  0,137, 68, 36,  4,199, 68, 36, 28,  1,  0,  0,  0,184,  1,
/* 0x17a0 */   0,  0,  0,139,108, 36,  4,  1,192,137, 68, 36, 24,  1,197,129,
/* 0x17b0 */ 124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,234,
/* 0x17c0 */   0,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,
/* 0x17d0 */ 199,139, 68, 36, 72,102,139, 85,  0,193,232, 11, 15,183,242, 15,
/* 0x17e0 */ 175,198, 57,199,115, 27,137, 68, 36, 72,184,  0,  8,  0,  0, 41,
/* 0x17f0 */ 240,193,248,  5,141,  4,  2,102,137, 69,  0,139, 68, 36, 24,235,
/* 0x1800 */  31, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,
/* 0x1810 */ 139, 68, 36, 24,102,137, 85,  0,139, 84, 36, 28, 64,  9, 20, 36,
/* 0x1820 */ 139, 76, 36, 32,209,100, 36, 28, 73,137, 76, 36, 32, 15,133,112,
/* 0x1830 */ 255,255,255,139, 52, 36, 70,137,116, 36, 92,116, 89,139, 76, 36,
/* 0x1840 */  12,139,108, 36,116,131,193,  2, 57,108, 36, 92,119, 95,139,132,
/* 0x1850 */  36,160,  0,  0,  0,137,234, 43, 68, 36, 92,  3,148, 36,160,  0,
/* 0x1860 */   0,  0,141, 52, 40,138,  6, 70,136, 68, 36,115,136,  2, 66,255,
/* 0x1870 */  68, 36,116, 73,116, 15,139,172, 36,164,  0,  0,  0, 57,108, 36,
/* 0x1880 */ 116,114,226,235, 17,139,132, 36,164,  0,  0,  0, 57, 68, 36,116,
/* 0x1890 */  15,130,187,246,255,255,129,124, 36, 72,255,255,255,  0,119, 21,
/* 0x18a0 */  59, 92, 36, 76,184,  1,  0,  0,  0,116, 41,235,  7,184,  1,  0,
/* 0x18b0 */   0,  0,235, 32, 67, 43,156, 36,148,  0,  0,  0, 49,192,139,148,
/* 0x18c0 */  36,156,  0,  0,  0,139, 76, 36,116,137, 26,139,156, 36,168,  0,
/* 0x18d0 */   0,  0,137, 11,131,196,124, 91, 94, 95, 93,  3,115,252,  3,123,
/* 0x18e0 */ 248, 49,192,141,140, 36,  0,255,255,255,137,236, 80, 57,204,117,
/* 0x18f0 */ 251,137,236, 49,201,142, 16,139, 96,  4,185,  0,  0,  0,  0,243,
/* 0x1900 */ 171, 95,185,  0,  0,  0,  0,138,  7, 71, 44,232, 60,  1,119,247,
/* 0x1910 */ 128, 63,  0,117,  4,139,  7,138, 95,  4,102,193,232,  8,134,196,
/* 0x1920 */ 193,192, 16,134,196, 41,248,128,235,232,137,  7,131,199,  5,136,
/* 0x1930 */ 216,226,  9,185,  0,  0,  0,  0,176,232,176,233,242,174,117,  4,
/* 0x1940 */ 128, 63,  0,117,255,139,  7,102,193,232,  8,134,196,193,192, 16,
/* 0x1950 */ 134,196, 41,248,171,235,  4,185,  0,  0,  0,  0,235, 29,138,  7,
/* 0x1960 */  71, 60,128,114, 10, 60,143,119,  6,128,127,254, 15,116,  5, 44,
/* 0x1970 */ 232, 60,  1,119,255,131,249,  4,114,  4,139,  7, 44,  0,117,255,
/* 0x1980 */ 134,196,193,192, 16,134,196, 41,248,131,233,  4,171,131,233,  1,
/* 0x1990 */ 114,  4,138,  7, 71,235, 13,131,233,  1,115,  6,233,252,255,255,
/* 0x19a0 */ 255, 85, 80, 88, 33,161,216,208,213,  0,  0,  0,  0,  0,  0,  0,
/* 0x19b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x19c0 */  45,102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102,
/* 0x19d0 */  51, 50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,105,111,110,
/* 0x19e0 */ 115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32,
/* 0x19f0 */  32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86,
/* 0x1a00 */  77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32,
/* 0x1a10 */  32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,
/* 0x1a20 */ 110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 68, 74, 50,
/* 0x1a30 */  77, 65, 73, 78, 49, 32, 32, 32, 32, 32, 32, 48, 99, 32, 32, 48,
/* 0x1a40 */  32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1a50 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 68, 74, 67,
/* 0x1a60 */  65, 76, 76, 84, 49, 32, 32, 32, 32, 32, 32, 48, 49, 32, 32, 48,
/* 0x1a70 */  32, 32, 48, 32, 32, 48, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1a80 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 68, 74, 50,
/* 0x1a90 */  77, 65, 73, 78, 50, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48,
/* 0x1aa0 */  32, 32, 48, 32, 32, 48, 52, 49, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1ab0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 76, 90, 77,
/* 0x1ac0 */  65, 95, 73, 78, 73, 84, 95, 83, 84, 65, 67, 75, 32, 48, 49, 48,
/* 0x1ad0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 52, 32, 32, 50, 42, 42,
/* 0x1ae0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32,
/* 0x1af0 */  78, 50, 66, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x1b00 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 52, 32, 32, 50, 42, 42,
/* 0x1b10 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32,
/* 0x1b20 */  78, 50, 66, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x1b30 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 55, 32, 32, 50, 42, 42,
/* 0x1b40 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 54, 32,
/* 0x1b50 */  78, 50, 66, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 54,
/* 0x1b60 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 57, 32, 32, 50, 42, 42,
/* 0x1b70 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32,
/* 0x1b80 */  78, 50, 66, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 98,
/* 0x1b90 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 53,102, 32, 32, 50, 42, 42,
/* 0x1ba0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32,
/* 0x1bb0 */  78, 50, 66, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x1bc0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 54, 97, 32, 32, 50, 42, 42,
/* 0x1bd0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32,
/* 0x1be0 */  78, 50, 66, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 57,
/* 0x1bf0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 54,102, 32, 32, 50, 42, 42,
/* 0x1c00 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32,
/* 0x1c10 */  78, 50, 66, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48,100,
/* 0x1c20 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 55, 56, 32, 32, 50, 42, 42,
/* 0x1c30 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 49, 32,
/* 0x1c40 */  78, 50, 66, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48,100,
/* 0x1c50 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 56, 53, 32, 32, 50, 42, 42,
/* 0x1c60 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 50, 32,
/* 0x1c70 */  78, 50, 66, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48,102,
/* 0x1c80 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 50, 32, 32, 50, 42, 42,
/* 0x1c90 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 51, 32,
/* 0x1ca0 */  78, 50, 66, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x1cb0 */ 101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 97, 49, 32, 32, 50, 42,
/* 0x1cc0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 52,
/* 0x1cd0 */  32, 78, 50, 66, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x1ce0 */ 100, 32, 32, 48, 32, 32, 48, 32, 32, 48,100,102, 32, 32, 50, 42,
/* 0x1cf0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 53,
/* 0x1d00 */  32, 78, 50, 66, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x1d10 */ 102, 32, 32, 48, 32, 32, 48, 32, 32, 48,101, 99, 32, 32, 50, 42,
/* 0x1d20 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 54,
/* 0x1d30 */  32, 78, 50, 66, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x1d40 */  50, 32, 32, 48, 32, 32, 48, 32, 32, 48,102, 98, 32, 32, 50, 42,
/* 0x1d50 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 55,
/* 0x1d60 */  32, 78, 50, 66, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x1d70 */  51, 32, 32, 48, 32, 32, 48, 32, 32, 48,102,100, 32, 32, 50, 42,
/* 0x1d80 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 56,
/* 0x1d90 */  32, 78, 50, 66, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x1da0 */  57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 48, 48, 32, 32, 50,
/* 0x1db0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49,
/* 0x1dc0 */  57, 32, 78, 50, 66, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32,
/* 0x1dd0 */  48, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 48, 57, 32, 32,
/* 0x1de0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1df0 */  50, 48, 32, 78, 50, 66, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32,
/* 0x1e00 */  32, 48, 49, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 49, 53,
/* 0x1e10 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1e20 */  10, 32, 50, 49, 32, 78, 50, 66, 70, 65, 83, 54, 49, 32, 32, 32,
/* 0x1e30 */  32, 32, 32, 48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x1e40 */  50,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1e50 */  84, 83, 10, 32, 50, 50, 32, 78, 50, 66, 68, 69, 67, 54, 48, 32,
/* 0x1e60 */  32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x1e70 */  52, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1e80 */  84, 83, 10, 32, 50, 51, 32, 78, 50, 68, 83, 77, 65, 49, 48, 32,
/* 0x1e90 */  32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1ea0 */  49, 52, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1eb0 */  78, 84, 83, 10, 32, 50, 52, 32, 78, 50, 68, 70, 65, 83, 49, 48,
/* 0x1ec0 */  32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x1ed0 */  48, 49, 52, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1ee0 */  69, 78, 84, 83, 10, 32, 50, 53, 32, 78, 50, 68, 70, 65, 83, 49,
/* 0x1ef0 */  49, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32,
/* 0x1f00 */  32, 48, 49, 52, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1f10 */  84, 69, 78, 84, 83, 10, 32, 50, 54, 32, 78, 50, 68, 68, 69, 67,
/* 0x1f20 */  49, 48, 32, 32, 32, 32, 32, 32, 48, 98, 32, 32, 48, 32, 32, 48,
/* 0x1f30 */  32, 32, 48, 49, 52,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1f40 */  78, 84, 69, 78, 84, 83, 10, 32, 50, 55, 32, 78, 50, 68, 83, 77,
/* 0x1f50 */  65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32,
/* 0x1f60 */  48, 32, 32, 48, 49, 53, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1f70 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 56, 32, 78, 50, 68, 70,
/* 0x1f80 */  65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32,
/* 0x1f90 */  32, 48, 32, 32, 48, 49, 53,102, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1fa0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 57, 32, 78, 50, 68,
/* 0x1fb0 */  68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48,
/* 0x1fc0 */  32, 32, 48, 32, 32, 48, 49, 54, 56, 32, 32, 50, 42, 42, 48, 32,
/* 0x1fd0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 48, 32, 78, 50,
/* 0x1fe0 */  68, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32,
/* 0x1ff0 */  48, 32, 32, 48, 32, 32, 48, 49, 55, 53, 32, 32, 50, 42, 42, 48,
/* 0x2000 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 49, 32, 78,
/* 0x2010 */  50, 68, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48,102, 32,
/* 0x2020 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 56, 50, 32, 32, 50, 42, 42,
/* 0x2030 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 50, 32,
/* 0x2040 */  78, 50, 68, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x2050 */  50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 49, 32, 32, 50,
/* 0x2060 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51,
/* 0x2070 */  51, 32, 78, 50, 68, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32,
/* 0x2080 */  48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,101, 51, 32, 32,
/* 0x2090 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x20a0 */  51, 52, 32, 78, 50, 68, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32,
/* 0x20b0 */  32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,102, 48, 32,
/* 0x20c0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x20d0 */  32, 51, 53, 32, 78, 50, 68, 83, 77, 65, 53, 48, 32, 32, 32, 32,
/* 0x20e0 */  32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,102,102,
/* 0x20f0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2100 */  10, 32, 51, 54, 32, 78, 50, 68, 70, 65, 83, 53, 48, 32, 32, 32,
/* 0x2110 */  32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 48,
/* 0x2120 */  49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2130 */  83, 10, 32, 51, 55, 32, 78, 50, 68, 68, 69, 67, 53, 48, 32, 32,
/* 0x2140 */  32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,
/* 0x2150 */  48, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2160 */  84, 83, 10, 32, 51, 56, 32, 78, 50, 68, 83, 77, 65, 54, 48, 32,
/* 0x2170 */  32, 32, 32, 32, 32, 48, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2180 */  50, 48,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2190 */  78, 84, 83, 10, 32, 51, 57, 32, 78, 50, 68, 70, 65, 83, 54, 48,
/* 0x21a0 */  32, 32, 32, 32, 32, 32, 48, 49, 57, 32, 32, 48, 32, 32, 48, 32,
/* 0x21b0 */  32, 48, 50, 49, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x21c0 */  84, 69, 78, 84, 83, 10, 32, 52, 48, 32, 78, 50, 68, 70, 65, 83,
/* 0x21d0 */  54, 49, 32, 32, 32, 32, 32, 32, 48, 49, 54, 32, 32, 48, 32, 32,
/* 0x21e0 */  48, 32, 32, 48, 50, 51, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x21f0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 49, 32, 78, 50, 68, 68,
/* 0x2200 */  69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2210 */  48, 32, 32, 48, 50, 52, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2220 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 50, 32, 78, 50, 69, 83,
/* 0x2230 */  77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32,
/* 0x2240 */  32, 48, 32, 32, 48, 50, 52, 56, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2250 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 51, 32, 78, 50, 69,
/* 0x2260 */  70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48,
/* 0x2270 */  32, 32, 48, 32, 32, 48, 50, 52, 98, 32, 32, 50, 42, 42, 48, 32,
/* 0x2280 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 52, 32, 78, 50,
/* 0x2290 */  69, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32,
/* 0x22a0 */  48, 32, 32, 48, 32, 32, 48, 50, 52,100, 32, 32, 50, 42, 42, 48,
/* 0x22b0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 53, 32, 78,
/* 0x22c0 */  50, 69, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 98, 32,
/* 0x22d0 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 53, 51, 32, 32, 50, 42, 42,
/* 0x22e0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 54, 32,
/* 0x22f0 */  78, 50, 69, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x2300 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 53,101, 32, 32, 50, 42,
/* 0x2310 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 55,
/* 0x2320 */  32, 78, 50, 69, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2330 */  57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 54, 51, 32, 32, 50,
/* 0x2340 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52,
/* 0x2350 */  56, 32, 78, 50, 69, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32,
/* 0x2360 */  48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 54, 99, 32, 32,
/* 0x2370 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2380 */  52, 57, 32, 78, 50, 69, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32,
/* 0x2390 */  32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 55, 57, 32,
/* 0x23a0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x23b0 */  32, 53, 48, 32, 78, 50, 69, 70, 65, 83, 51, 48, 32, 32, 32, 32,
/* 0x23c0 */  32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 56, 54,
/* 0x23d0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x23e0 */  10, 32, 53, 49, 32, 78, 50, 69, 68, 69, 67, 51, 48, 32, 32, 32,
/* 0x23f0 */  32, 32, 32, 48, 53,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,
/* 0x2400 */  57, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2410 */  84, 83, 10, 32, 53, 50, 32, 78, 50, 69, 83, 77, 65, 52, 48, 32,
/* 0x2420 */  32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2430 */  50,102, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2440 */  78, 84, 83, 10, 32, 53, 51, 32, 78, 50, 69, 70, 65, 83, 52, 48,
/* 0x2450 */  32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2460 */  48, 51, 48, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2470 */  69, 78, 84, 83, 10, 32, 53, 52, 32, 78, 50, 69, 83, 77, 65, 53,
/* 0x2480 */  48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32,
/* 0x2490 */  32, 48, 51, 49, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x24a0 */  84, 69, 78, 84, 83, 10, 32, 53, 53, 32, 78, 50, 69, 70, 65, 83,
/* 0x24b0 */  53, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48,
/* 0x24c0 */  32, 32, 48, 51, 49, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x24d0 */  78, 84, 69, 78, 84, 83, 10, 32, 53, 54, 32, 78, 50, 69, 68, 69,
/* 0x24e0 */  67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32,
/* 0x24f0 */  48, 32, 32, 48, 51, 49, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2500 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 55, 32, 78, 50, 69, 83,
/* 0x2510 */  77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 99, 32, 32, 48, 32,
/* 0x2520 */  32, 48, 32, 32, 48, 51, 49,101, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2530 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 56, 32, 78, 50, 69,
/* 0x2540 */  70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 49, 57, 32, 32,
/* 0x2550 */  48, 32, 32, 48, 32, 32, 48, 51, 50, 97, 32, 32, 50, 42, 42, 48,
/* 0x2560 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 57, 32, 78,
/* 0x2570 */  50, 69, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 49, 54,
/* 0x2580 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 51, 32, 32, 50, 42,
/* 0x2590 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 48,
/* 0x25a0 */  32, 78, 50, 69, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x25b0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 53, 57, 32, 32, 50, 42,
/* 0x25c0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 49,
/* 0x25d0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 32, 32, 32, 32, 48,
/* 0x25e0 */  50,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 53, 57, 32, 32,
/* 0x25f0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2600 */  54, 50, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32,
/* 0x2610 */  32, 48, 52, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 56, 55,
/* 0x2620 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2630 */  10, 32, 54, 51, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32,
/* 0x2640 */  32, 32, 32, 48, 97, 56, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2650 */  51, 99,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2660 */  78, 84, 83, 10, 32, 54, 52, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2670 */  50, 48, 32, 32, 32, 32, 48, 97, 56, 54, 32, 32, 48, 32, 32, 48,
/* 0x2680 */  32, 32, 48,101, 53, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2690 */  78, 84, 69, 78, 84, 83, 10, 32, 54, 53, 32, 76, 90, 77, 65, 95,
/* 0x26a0 */  68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 49, 97, 32, 32, 48, 32,
/* 0x26b0 */  32, 48, 32, 32, 48, 49, 56,100, 98, 32, 32, 50, 42, 42, 48, 32,
/* 0x26c0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 54, 32, 76, 90,
/* 0x26d0 */  77, 65, 95, 68, 79, 78, 69, 95, 83, 84, 65, 67, 75, 32, 48, 53,
/* 0x26e0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 56,102, 53, 32, 32, 50,
/* 0x26f0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54,
/* 0x2700 */  55, 32, 68, 74, 50, 66, 83, 83, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x2710 */  48, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 56,102, 97, 32,
/* 0x2720 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2730 */  32, 54, 56, 32, 68, 74, 67, 65, 76, 76, 84, 50, 32, 32, 32, 32,
/* 0x2740 */  32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 48,
/* 0x2750 */  49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2760 */  83, 10, 32, 54, 57, 32, 67, 65, 76, 76, 84, 82, 48, 48, 32, 32,
/* 0x2770 */  32, 32, 32, 32, 48,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2780 */  57, 48, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2790 */  78, 84, 83, 10, 32, 55, 48, 32, 67, 84, 67, 76, 69, 86, 69, 49,
/* 0x27a0 */  32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x27b0 */  48, 49, 57, 49, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x27c0 */  84, 69, 78, 84, 83, 10, 32, 55, 49, 32, 67, 65, 76, 76, 84, 82,
/* 0x27d0 */  48, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48,
/* 0x27e0 */  32, 32, 48, 49, 57, 49, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x27f0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 50, 32, 67, 84, 66, 83,
/* 0x2800 */  72, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32,
/* 0x2810 */  32, 48, 32, 32, 48, 49, 57, 49, 97, 32, 32, 50, 42, 42, 48, 32,
/* 0x2820 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 51, 32, 67, 84,
/* 0x2830 */  66, 82, 79, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32,
/* 0x2840 */  48, 32, 32, 48, 32, 32, 48, 49, 57, 49,101, 32, 32, 50, 42, 42,
/* 0x2850 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 52, 32,
/* 0x2860 */  67, 84, 66, 83, 87, 65, 48, 49, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x2870 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 50, 48, 32, 32, 50,
/* 0x2880 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55,
/* 0x2890 */  53, 32, 67, 65, 76, 76, 84, 82, 48, 50, 32, 32, 32, 32, 32, 32,
/* 0x28a0 */  48,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 50, 53, 32,
/* 0x28b0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x28c0 */  32, 55, 54, 32, 67, 65, 76, 76, 84, 82, 49, 48, 32, 32, 32, 32,
/* 0x28d0 */  32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 51,
/* 0x28e0 */  51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x28f0 */  83, 10, 32, 55, 55, 32, 67, 65, 76, 76, 84, 82, 69, 56, 32, 32,
/* 0x2900 */  32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2910 */  57, 51, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2920 */  78, 84, 83, 10, 32, 55, 56, 32, 67, 65, 76, 76, 84, 82, 69, 57,
/* 0x2930 */  32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2940 */  48, 49, 57, 51, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2950 */  84, 69, 78, 84, 83, 10, 32, 55, 57, 32, 67, 65, 76, 76, 84, 82,
/* 0x2960 */  49, 49, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32, 48,
/* 0x2970 */  32, 32, 48, 49, 57, 51, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2980 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 48, 32, 67, 84, 67, 76,
/* 0x2990 */  69, 86, 69, 50, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32,
/* 0x29a0 */  32, 48, 32, 32, 48, 49, 57, 52, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x29b0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 49, 32, 67, 65,
/* 0x29c0 */  76, 76, 84, 82, 49, 50, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32,
/* 0x29d0 */  48, 32, 32, 48, 32, 32, 48, 49, 57, 52, 53, 32, 32, 50, 42, 42,
/* 0x29e0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 50, 32,
/* 0x29f0 */  67, 84, 66, 83, 72, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 52,
/* 0x2a00 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 52, 55, 32, 32, 50,
/* 0x2a10 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56,
/* 0x2a20 */  51, 32, 67, 84, 66, 82, 79, 82, 49, 49, 32, 32, 32, 32, 32, 32,
/* 0x2a30 */  48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 52, 98, 32,
/* 0x2a40 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2a50 */  32, 56, 52, 32, 67, 84, 66, 83, 87, 65, 49, 49, 32, 32, 32, 32,
/* 0x2a60 */  32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 52,
/* 0x2a70 */ 100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2a80 */  83, 10, 32, 56, 53, 32, 67, 65, 76, 76, 84, 82, 49, 51, 32, 32,
/* 0x2a90 */  32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2aa0 */  57, 53, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2ab0 */  78, 84, 83, 10, 32, 56, 54, 32, 99,116,111,107, 51, 50, 46, 48,
/* 0x2ac0 */  48, 32, 32, 32, 32, 32, 48, 97, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2ad0 */  48, 49, 57, 53, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2ae0 */  84, 69, 78, 84, 83, 10, 32, 56, 55, 32, 99,116,111,107, 51, 50,
/* 0x2af0 */  46, 49, 48, 32, 32, 32, 32, 32, 48,101, 32, 32, 48, 32, 32, 48,
/* 0x2b00 */  32, 32, 48, 49, 57, 54, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2b10 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 56, 32, 99,116,111,107,
/* 0x2b20 */  51, 50, 46, 50, 48, 32, 32, 32, 32, 32, 48, 49,101, 32, 32, 48,
/* 0x2b30 */  32, 32, 48, 32, 32, 48, 49, 57, 54,102, 32, 32, 50, 42, 42, 48,
/* 0x2b40 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 57, 32, 99,
/* 0x2b50 */ 116,111,107, 51, 50, 46, 51, 48, 32, 32, 32, 32, 32, 48, 97, 32,
/* 0x2b60 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 56,100, 32, 32, 50, 42,
/* 0x2b70 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 48,
/* 0x2b80 */  32, 99,116,111,107, 51, 50, 46, 52, 48, 32, 32, 32, 32, 32, 48,
/* 0x2b90 */  53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 57, 55, 32, 32,
/* 0x2ba0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2bb0 */  57, 49, 32, 68, 74, 82, 69, 84, 85, 82, 78, 32, 32, 32, 32, 32,
/* 0x2bc0 */  32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 57, 99,
/* 0x2bd0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2be0 */  10, 32, 57, 50, 32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 32, 32,
/* 0x2bf0 */  32, 32, 32, 48, 50, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2c00 */  57, 97, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2c10 */  78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69,
/* 0x2c20 */  58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x2c30 */ 100, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48, 32, 48, 32, 78, 50,
/* 0x2c40 */  66, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2c50 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 49, 49,
/* 0x2c60 */  32, 48, 32, 78, 50, 66, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48,
/* 0x2c70 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x2c80 */  68, 69, 67, 49, 48, 32, 48, 32, 78, 50, 66, 68, 69, 67, 49, 48,
/* 0x2c90 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x2ca0 */  32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 32, 48, 32, 78, 50, 66,
/* 0x2cb0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x2cc0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 32,
/* 0x2cd0 */  48, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x2ce0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68,
/* 0x2cf0 */  69, 67, 53, 48, 32, 48, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10,
/* 0x2d00 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2d10 */  32, 78, 50, 66, 70, 65, 83, 54, 49, 32, 48, 32, 78, 50, 66, 70,
/* 0x2d20 */  65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x2d30 */  32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 54, 48, 32, 48,
/* 0x2d40 */  32, 78, 50, 66, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x2d50 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77,
/* 0x2d60 */  65, 49, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 48,
/* 0x2d70 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x2d80 */  78, 50, 68, 70, 65, 83, 49, 49, 32, 48, 32, 78, 50, 68, 70, 65,
/* 0x2d90 */  83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x2da0 */  32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 32, 48, 32,
/* 0x2db0 */  78, 50, 68, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2dc0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67,
/* 0x2dd0 */  50, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2de0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x2df0 */  50, 68, 68, 69, 67, 51, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67,
/* 0x2e00 */  51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2e10 */  32,100, 32, 32, 78, 50, 68, 68, 69, 67, 53, 48, 32, 48, 32, 78,
/* 0x2e20 */  50, 68, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e30 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 54,
/* 0x2e40 */  49, 32, 48, 32, 78, 50, 68, 70, 65, 83, 54, 49, 10, 48, 48, 48,
/* 0x2e50 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x2e60 */  68, 68, 69, 67, 54, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 54,
/* 0x2e70 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x2e80 */ 100, 32, 32, 78, 50, 69, 83, 77, 65, 49, 48, 32, 48, 32, 78, 50,
/* 0x2e90 */  69, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2ea0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 49,
/* 0x2eb0 */  32, 48, 32, 78, 50, 69, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48,
/* 0x2ec0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x2ed0 */  68, 69, 67, 49, 48, 32, 48, 32, 78, 50, 69, 68, 69, 67, 49, 48,
/* 0x2ee0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x2ef0 */  32, 32, 78, 50, 69, 68, 69, 67, 50, 48, 32, 48, 32, 78, 50, 69,
/* 0x2f00 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x2f10 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 32,
/* 0x2f20 */  48, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x2f30 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68,
/* 0x2f40 */  69, 67, 53, 48, 32, 48, 32, 78, 50, 69, 68, 69, 67, 53, 48, 10,
/* 0x2f50 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2f60 */  32, 78, 50, 69, 70, 65, 83, 54, 49, 32, 48, 32, 78, 50, 69, 70,
/* 0x2f70 */  65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x2f80 */  32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 54, 48, 32, 48,
/* 0x2f90 */  32, 78, 50, 69, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x2fa0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,
/* 0x2fb0 */  82, 48, 48, 32, 48, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 48,
/* 0x2fc0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x2fd0 */  67, 65, 76, 76, 84, 82, 49, 48, 32, 48, 32, 67, 65, 76, 76, 84,
/* 0x2fe0 */  82, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x2ff0 */  32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 49, 32, 48, 32,
/* 0x3000 */  67, 65, 76, 76, 84, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3010 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x3020 */  49, 51, 32, 48, 32, 67, 65, 76, 76, 84, 82, 49, 51, 10, 48, 48,
/* 0x3030 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,
/* 0x3040 */ 116,111,107, 51, 50, 46, 48, 48, 32, 48, 32, 99,116,111,107, 51,
/* 0x3050 */  50, 46, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3060 */  32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 49, 48, 32,
/* 0x3070 */  48, 32, 99,116,111,107, 51, 50, 46, 49, 48, 10, 48, 48, 48, 48,
/* 0x3080 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,
/* 0x3090 */ 107, 51, 50, 46, 50, 48, 32, 48, 32, 99,116,111,107, 51, 50, 46,
/* 0x30a0 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x30b0 */  32,100, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 32, 48, 32,
/* 0x30c0 */  99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x30d0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 68, 74, 50, 77, 65,
/* 0x30e0 */  73, 78, 49, 32, 48, 32, 68, 74, 50, 77, 65, 73, 78, 49, 10, 48,
/* 0x30f0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3100 */  68, 74, 67, 65, 76, 76, 84, 49, 32, 48, 32, 68, 74, 67, 65, 76,
/* 0x3110 */  76, 84, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3120 */  32, 32,100, 32, 32, 68, 74, 50, 77, 65, 73, 78, 50, 32, 48, 32,
/* 0x3130 */  68, 74, 50, 77, 65, 73, 78, 50, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3140 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 73,
/* 0x3150 */  78, 73, 84, 95, 83, 84, 65, 67, 75, 32, 48, 32, 76, 90, 77, 65,
/* 0x3160 */  95, 73, 78, 73, 84, 95, 83, 84, 65, 67, 75, 10, 48, 48, 48, 48,
/* 0x3170 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x3180 */  70, 65, 83, 49, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 49, 48,
/* 0x3190 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x31a0 */  32, 32, 78, 50, 66, 83, 77, 65, 50, 48, 32, 48, 32, 78, 50, 66,
/* 0x31b0 */  83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x31c0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 50, 48, 32,
/* 0x31d0 */  48, 32, 78, 50, 66, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x31e0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83,
/* 0x31f0 */  77, 65, 51, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 51, 48, 10,
/* 0x3200 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3210 */  32, 78, 50, 66, 70, 65, 83, 51, 48, 32, 48, 32, 78, 50, 66, 70,
/* 0x3220 */  65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3230 */  32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 52, 48, 32, 48,
/* 0x3240 */  32, 78, 50, 66, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3250 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65,
/* 0x3260 */  83, 52, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 52, 48, 10, 48,
/* 0x3270 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3280 */  78, 50, 66, 83, 77, 65, 53, 48, 32, 48, 32, 78, 50, 66, 83, 77,
/* 0x3290 */  65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x32a0 */  32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 53, 48, 32, 48, 32,
/* 0x32b0 */  78, 50, 66, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x32c0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65,
/* 0x32d0 */  54, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 54, 48, 10, 48, 48,
/* 0x32e0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x32f0 */  50, 66, 70, 65, 83, 54, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83,
/* 0x3300 */  54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3310 */  32,100, 32, 32, 78, 50, 68, 70, 65, 83, 49, 48, 32, 48, 32, 78,
/* 0x3320 */  50, 68, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3330 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 50,
/* 0x3340 */  48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 50, 48, 10, 48, 48, 48,
/* 0x3350 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3360 */  68, 70, 65, 83, 50, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 50,
/* 0x3370 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3380 */ 100, 32, 32, 78, 50, 68, 83, 77, 65, 51, 48, 32, 48, 32, 78, 50,
/* 0x3390 */  68, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x33a0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 51, 48,
/* 0x33b0 */  32, 48, 32, 78, 50, 68, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48,
/* 0x33c0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x33d0 */  83, 77, 65, 52, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 52, 48,
/* 0x33e0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x33f0 */  32, 32, 78, 50, 68, 70, 65, 83, 52, 48, 32, 48, 32, 78, 50, 68,
/* 0x3400 */  70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3410 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 53, 48, 32,
/* 0x3420 */  48, 32, 78, 50, 68, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48,
/* 0x3430 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70,
/* 0x3440 */  65, 83, 53, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 53, 48, 10,
/* 0x3450 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3460 */  32, 78, 50, 68, 83, 77, 65, 54, 48, 32, 48, 32, 78, 50, 68, 83,
/* 0x3470 */  77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3480 */  32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 48, 32, 48,
/* 0x3490 */  32, 78, 50, 68, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x34a0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65,
/* 0x34b0 */  83, 49, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 49, 48, 10, 48,
/* 0x34c0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x34d0 */  78, 50, 69, 83, 77, 65, 50, 48, 32, 48, 32, 78, 50, 69, 83, 77,
/* 0x34e0 */  65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x34f0 */  32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 50, 48, 32, 48, 32,
/* 0x3500 */  78, 50, 69, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3510 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65,
/* 0x3520 */  51, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 51, 48, 10, 48, 48,
/* 0x3530 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x3540 */  50, 69, 70, 65, 83, 51, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83,
/* 0x3550 */  51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3560 */  32,100, 32, 32, 78, 50, 69, 83, 77, 65, 52, 48, 32, 48, 32, 78,
/* 0x3570 */  50, 69, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3580 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 52,
/* 0x3590 */  48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 52, 48, 10, 48, 48, 48,
/* 0x35a0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x35b0 */  69, 83, 77, 65, 53, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 53,
/* 0x35c0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x35d0 */ 100, 32, 32, 78, 50, 69, 70, 65, 83, 53, 48, 32, 48, 32, 78, 50,
/* 0x35e0 */  69, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x35f0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 54, 48,
/* 0x3600 */  32, 48, 32, 78, 50, 69, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48,
/* 0x3610 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x3620 */  70, 65, 83, 54, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 54, 48,
/* 0x3630 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3640 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 32, 48, 32, 76,
/* 0x3650 */  90, 77, 65, 95, 68, 69, 67, 48, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3660 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,
/* 0x3670 */  69, 76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x3680 */  48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3690 */  32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48,
/* 0x36a0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x36b0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x36c0 */  65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x36d0 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x36e0 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x36f0 */  32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48,
/* 0x3700 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x3710 */  90, 77, 65, 95, 68, 79, 78, 69, 95, 83, 84, 65, 67, 75, 32, 48,
/* 0x3720 */  32, 76, 90, 77, 65, 95, 68, 79, 78, 69, 95, 83, 84, 65, 67, 75,
/* 0x3730 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3740 */  32, 32, 68, 74, 50, 66, 83, 83, 48, 48, 32, 48, 32, 68, 74, 50,
/* 0x3750 */  66, 83, 83, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3760 */  32, 32, 32, 32,100, 32, 32, 68, 74, 67, 65, 76, 76, 84, 50, 32,
/* 0x3770 */  48, 32, 68, 74, 67, 65, 76, 76, 84, 50, 10, 48, 48, 48, 48, 48,
/* 0x3780 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 67, 76,
/* 0x3790 */  69, 86, 69, 49, 32, 48, 32, 67, 84, 67, 76, 69, 86, 69, 49, 10,
/* 0x37a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x37b0 */  32, 67, 65, 76, 76, 84, 82, 48, 49, 32, 48, 32, 67, 65, 76, 76,
/* 0x37c0 */  84, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x37d0 */  32, 32, 32,100, 32, 32, 67, 84, 66, 83, 72, 82, 48, 49, 32, 48,
/* 0x37e0 */  32, 67, 84, 66, 83, 72, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x37f0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 82, 79,
/* 0x3800 */  82, 48, 49, 32, 48, 32, 67, 84, 66, 82, 79, 82, 48, 49, 10, 48,
/* 0x3810 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3820 */  67, 84, 66, 83, 87, 65, 48, 49, 32, 48, 32, 67, 84, 66, 83, 87,
/* 0x3830 */  65, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3840 */  32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 50, 32, 48, 32,
/* 0x3850 */  67, 65, 76, 76, 84, 82, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3860 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x3870 */  69, 56, 32, 48, 32, 67, 65, 76, 76, 84, 82, 69, 56, 10, 48, 48,
/* 0x3880 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x3890 */  65, 76, 76, 84, 82, 69, 57, 32, 48, 32, 67, 65, 76, 76, 84, 82,
/* 0x38a0 */  69, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x38b0 */  32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 50, 32, 48, 32, 67,
/* 0x38c0 */  84, 67, 76, 69, 86, 69, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x38d0 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49,
/* 0x38e0 */  50, 32, 48, 32, 67, 65, 76, 76, 84, 82, 49, 50, 10, 48, 48, 48,
/* 0x38f0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,
/* 0x3900 */  66, 83, 72, 82, 49, 49, 32, 48, 32, 67, 84, 66, 83, 72, 82, 49,
/* 0x3910 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3920 */ 100, 32, 32, 67, 84, 66, 82, 79, 82, 49, 49, 32, 48, 32, 67, 84,
/* 0x3930 */  66, 82, 79, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3940 */ 108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65, 49, 49,
/* 0x3950 */  32, 48, 32, 67, 84, 66, 83, 87, 65, 49, 49, 10, 48, 48, 48, 48,
/* 0x3960 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,
/* 0x3970 */ 107, 51, 50, 46, 51, 48, 32, 48, 32, 99,116,111,107, 51, 50, 46,
/* 0x3980 */  51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3990 */  32,100, 32, 32, 68, 74, 82, 69, 84, 85, 82, 78, 32, 48, 32, 68,
/* 0x39a0 */  74, 82, 69, 84, 85, 82, 78, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x39b0 */  32,108, 32, 32, 32, 32,100, 32, 32, 85, 80, 88, 49, 72, 69, 65,
/* 0x39c0 */  68, 32, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 10, 48, 48, 48,
/* 0x39d0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x39e0 */  78, 68, 42, 32, 48, 32,115,116, 97,114,116, 95,111,102, 95, 99,
/* 0x39f0 */ 111,109,112,114,101,115,115,101,100, 10, 48, 48, 48, 48, 48, 48,
/* 0x3a00 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x3a10 */  32, 48, 32,115,116, 97,114,116, 95,111,102, 95,117,110, 99,111,
/* 0x3a20 */ 109,112,114,101,115,115,101,100, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a30 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x3a40 */  48, 32,115,116, 97, 99,107, 95,102,111,114, 95,108,122,109, 97,
/* 0x3a50 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x3a60 */  32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95,115,
/* 0x3a70 */ 116, 97, 99,107, 95, 97,100,106,117,115,116, 10, 48, 48, 48, 48,
/* 0x3a80 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x3a90 */  68, 42, 32, 48, 32,108,122,109, 97, 95,117, 95,108,101,110, 10,
/* 0x3aa0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3ab0 */  32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95, 99, 95,
/* 0x3ac0 */ 108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x3ad0 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,109,
/* 0x3ae0 */  97, 95,112,114,111,112,101,114,116,105,101,115, 10, 48, 48, 48,
/* 0x3af0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x3b00 */  78, 68, 42, 32, 48, 32,108,101,110,103,116,104, 95,111,102, 95,
/* 0x3b10 */  98,115,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x3b20 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,102,105,108,
/* 0x3b30 */ 116,101,114, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48,
/* 0x3b40 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x3b50 */  42, 32, 48, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48,
/* 0x3b60 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3b70 */  42, 85, 78, 68, 42, 32, 48, 32,111,114,105,103,105,110, 97,108,
/* 0x3b80 */  95,101,110,116,114,121, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x3b90 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x3ba0 */  68, 74, 50, 77, 65, 73, 78, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x3bb0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3bc0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x3bd0 */  48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,
/* 0x3be0 */  32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,102, 95,
/* 0x3bf0 */  99,111,109,112,114,101,115,115,101,100, 10, 48, 48, 48, 48, 48,
/* 0x3c00 */  48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x3c10 */  32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,102, 95,117,
/* 0x3c20 */ 110, 99,111,109,112,114,101,115,115,101,100, 10, 10, 82, 69, 76,
/* 0x3c30 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x3c40 */  70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 73, 78, 73, 84, 95, 83,
/* 0x3c50 */  84, 65, 67, 75, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x3c60 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3c70 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x3c80 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x3c90 */  32, 32, 32,115,116, 97, 99,107, 95,102,111,114, 95,108,122,109,
/* 0x3ca0 */  97, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x3cb0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77,
/* 0x3cc0 */  65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x3cd0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3ce0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x3cf0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x3d00 */  32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x3d10 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x3d20 */  79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 49, 48, 93, 58, 10, 79,
/* 0x3d30 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x3d40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x3d50 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x3d60 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,
/* 0x3d70 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x3d80 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66,
/* 0x3d90 */  83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x3da0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3db0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3dc0 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x3dd0 */  32, 32, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 10, 82, 69,
/* 0x3de0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x3df0 */  32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 50, 48, 93, 58,
/* 0x3e00 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x3e10 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x3e20 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54,
/* 0x3e30 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66,
/* 0x3e40 */  70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x3e50 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x3e60 */  50, 66, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x3e70 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3e80 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x3e90 */  48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x3ea0 */  32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 10,
/* 0x3eb0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x3ec0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 51, 48,
/* 0x3ed0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x3ee0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x3ef0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x3f00 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x3f10 */  50, 66, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,101,
/* 0x3f20 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x3f30 */  32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 10, 82, 69, 76,
/* 0x3f40 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x3f50 */  70, 79, 82, 32, 91, 78, 50, 66, 68, 69, 67, 51, 48, 93, 58, 10,
/* 0x3f60 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x3f70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x3f80 */  10, 48, 48, 48, 48, 48, 48, 49, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x3f90 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x3fa0 */  69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 50,102, 32, 82, 95,
/* 0x3fb0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3fc0 */  78, 50, 66, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x3fd0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x3fe0 */  32, 91, 78, 50, 66, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70,
/* 0x3ff0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4000 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4010 */  48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x4020 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51,
/* 0x4030 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x4040 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65,
/* 0x4050 */  83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x4060 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4070 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32,
/* 0x4080 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x4090 */  32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x40a0 */  48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x40b0 */  32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 10,
/* 0x40c0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x40d0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 54, 48,
/* 0x40e0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x40f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4100 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51,
/* 0x4110 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x4120 */  50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4130 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4140 */  91, 78, 50, 66, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x4150 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4160 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4170 */  48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4180 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 70, 65, 83, 54, 49,
/* 0x4190 */  10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95,
/* 0x41a0 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x41b0 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x41c0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x41d0 */  66, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x41e0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x41f0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4200 */  49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x4210 */  32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x4220 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x4230 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 49, 48, 93,
/* 0x4240 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4250 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4260 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,
/* 0x4270 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x4280 */  68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x4290 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x42a0 */  78, 50, 68, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x42b0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x42c0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x42d0 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x42e0 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10,
/* 0x42f0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x4300 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 50,
/* 0x4310 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x4320 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x4330 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x4340 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4350 */  78, 50, 68, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x4360 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4370 */  32, 91, 78, 50, 68, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70,
/* 0x4380 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4390 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x43a0 */  48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x43b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65, 83, 49,
/* 0x43c0 */  49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x43d0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77,
/* 0x43e0 */  65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x43f0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4400 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32,
/* 0x4410 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x4420 */  32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79,
/* 0x4430 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x4440 */  79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 51, 48, 93, 58, 10, 79,
/* 0x4450 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x4460 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x4470 */  48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x4480 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,
/* 0x4490 */  67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51,
/* 0x44a0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x44b0 */  50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x44c0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x44d0 */  91, 78, 50, 68, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x44e0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x44f0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4500 */  48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4510 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48,
/* 0x4520 */  10, 48, 48, 48, 48, 48, 48, 50, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x4530 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,
/* 0x4540 */  69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 52, 51, 32, 82, 95,
/* 0x4550 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4560 */  78, 50, 68, 68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x4570 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4580 */  32, 91, 78, 50, 68, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70,
/* 0x4590 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x45a0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x45b0 */  48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x45c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51,
/* 0x45d0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x45e0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65,
/* 0x45f0 */  83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x4600 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4610 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32,
/* 0x4620 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x4630 */  32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x4640 */  48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x4650 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10,
/* 0x4660 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4670 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 54, 48,
/* 0x4680 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x4690 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x46a0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51,
/* 0x46b0 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x46c0 */  50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x46d0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x46e0 */  91, 78, 50, 68, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x46f0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4700 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4710 */  48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4720 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65, 83, 54, 49,
/* 0x4730 */  10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95,
/* 0x4740 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,
/* 0x4750 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4760 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x4770 */  68, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4780 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4790 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x47a0 */  49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x47b0 */  32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x47c0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x47d0 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 49, 48, 93,
/* 0x47e0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x47f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4800 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,
/* 0x4810 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x4820 */  69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x4830 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x4840 */  78, 50, 69, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x4850 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4860 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x4870 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x4880 */  32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10,
/* 0x4890 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x48a0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 50,
/* 0x48b0 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x48c0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x48d0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x48e0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x48f0 */  78, 50, 69, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x4900 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4910 */  32, 91, 78, 50, 69, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70,
/* 0x4920 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4930 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4940 */  48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x4950 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65, 83, 49,
/* 0x4960 */  49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x4970 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77,
/* 0x4980 */  65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x4990 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x49a0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32,
/* 0x49b0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x49c0 */  32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79,
/* 0x49d0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x49e0 */  79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 51, 48, 93, 58, 10, 79,
/* 0x49f0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x4a00 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x4a10 */  48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x4a20 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,
/* 0x4a30 */  67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51,
/* 0x4a40 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x4a50 */  50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4a60 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4a70 */  91, 78, 50, 69, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x4a80 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4a90 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4aa0 */  48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4ab0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 50, 48,
/* 0x4ac0 */  10, 48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x4ad0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,
/* 0x4ae0 */  69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95,
/* 0x4af0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4b00 */  78, 50, 69, 68, 69, 67, 54, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x4b10 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4b20 */  32, 91, 78, 50, 69, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70,
/* 0x4b30 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4b40 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4b50 */  48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x4b60 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51,
/* 0x4b70 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x4b80 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65,
/* 0x4b90 */  83, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x4ba0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4bb0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32,
/* 0x4bc0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x4bd0 */  32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x4be0 */  48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x4bf0 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10,
/* 0x4c00 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4c10 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 54, 48,
/* 0x4c20 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x4c30 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4c40 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51,
/* 0x4c50 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x4c60 */  50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4c70 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4c80 */  91, 78, 50, 69, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x4c90 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ca0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4cb0 */  48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4cc0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65, 83, 54, 49,
/* 0x4cd0 */  10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95,
/* 0x4ce0 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,
/* 0x4cf0 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4d00 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x4d10 */  69, 70, 65, 83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4d20 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4d30 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4d40 */  49, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x4d50 */  32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x4d60 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x4d70 */  83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 48,
/* 0x4d80 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x4d90 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x4da0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95,
/* 0x4db0 */  51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4dc0 */ 108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,
/* 0x4dd0 */ 116, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95, 51, 56, 54,
/* 0x4de0 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109,
/* 0x4df0 */  97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 49,101,
/* 0x4e00 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x4e10 */  32, 32, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48,
/* 0x4e20 */  48, 48, 48, 48, 50, 97, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x4e30 */  32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,112,114,
/* 0x4e40 */ 111,112,101,114,116,105,101,115, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x4e50 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4e60 */  32, 91, 68, 74, 50, 66, 83, 83, 48, 48, 93, 58, 10, 79, 70, 70,
/* 0x4e70 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4e80 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4e90 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x4ea0 */  32, 32, 32, 32, 32, 32, 32, 32, 32,108,101,110,103,116,104, 95,
/* 0x4eb0 */ 111,102, 95, 98,115,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x4ec0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x4ed0 */  67, 65, 76, 76, 84, 82, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x4ee0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ef0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x4f00 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,
/* 0x4f10 */  32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,108,101,
/* 0x4f20 */ 110,103,116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4f30 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84,
/* 0x4f40 */  67, 76, 69, 86, 69, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4f50 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4f60 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4f70 */  48, 50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32,
/* 0x4f80 */  32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10,
/* 0x4f90 */  48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x4fa0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84,
/* 0x4fb0 */  82, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4fc0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76,
/* 0x4fd0 */  76, 84, 82, 48, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x4fe0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ff0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5000 */ 100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x5010 */  32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82, 69,
/* 0x5020 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5030 */  32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 48, 93, 58,
/* 0x5040 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5050 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5060 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x5070 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,
/* 0x5080 */ 116,101,114, 95,108,101,110,103,116,104, 10, 10, 82, 69, 76, 79,
/* 0x5090 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x50a0 */  79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 49, 93, 58, 10, 79,
/* 0x50b0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x50c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x50d0 */  48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x50e0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84,
/* 0x50f0 */  82, 49, 51, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5100 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 67,
/* 0x5110 */  76, 69, 86, 69, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x5120 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5130 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5140 */  50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5150 */  32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48,
/* 0x5160 */  48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x5170 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x5180 */  49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x5190 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76,
/* 0x51a0 */  84, 82, 49, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x51b0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x51c0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x51d0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x51e0 */  32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10, 10, 82, 69, 76,
/* 0x51f0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5200 */  70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 48, 48, 93, 58,
/* 0x5210 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5220 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5230 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x5240 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,
/* 0x5250 */ 116,101,114, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48,
/* 0x5260 */  48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5270 */  32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10,
/* 0x5280 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x5290 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46,
/* 0x52a0 */  49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x52b0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x52c0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,100, 32, 82,
/* 0x52d0 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x52e0 */  32, 99,116,111,107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76, 79,
/* 0x52f0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x5300 */  79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 50, 48, 93, 58, 10,
/* 0x5310 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x5320 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x5330 */  10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95,
/* 0x5340 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107,
/* 0x5350 */  51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82,
/* 0x5360 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5370 */  32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48,
/* 0x5380 */  48, 48,101, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32,
/* 0x5390 */  32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111,
/* 0x53a0 */  10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 51, 56, 54, 95,
/* 0x53b0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107,
/* 0x53c0 */  51, 50, 46, 52, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x53d0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,
/* 0x53e0 */ 116,111,107, 51, 50, 46, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x53f0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5400 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x5410 */  48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x5420 */  32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48,
/* 0x5430 */  10, 48, 48, 48, 48, 48, 48, 48, 57, 32, 82, 95, 51, 56, 54, 95,
/* 0x5440 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107,
/* 0x5450 */  51, 50, 46, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x5460 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,
/* 0x5470 */ 116,111,107, 51, 50, 46, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x5480 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5490 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x54a0 */  48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x54b0 */  32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 48, 48,
/* 0x54c0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x54d0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 68, 74, 82, 69, 84, 85,
/* 0x54e0 */  82, 78, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x54f0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5500 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,
/* 0x5510 */  95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x5520 */  32,111,114,105,103,105,110, 97,108, 95,101,110,116,114,121, 10
};
