/*
	Copyright (C) 2009 -=[dxp]=-

	This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/resource.h>
#include <inttypes.h>
#include <signal.h>
#include <fcntl.h>
#include <termios.h>

#define MAX_WORD_SIZE 32	// Maximum length of string to brute
#define MAX_HASH_LEN 40		// Maximum length of hash in ascii format
#define LINE_BUF_LEN 64		// Maximum length of line to read from file

enum {
	MODE_SINGLE=1,
	MODE_FILE
};

enum {
	HASH_MD5=1,
	HASH_SHA1
};

struct node {
	uint8_t digest[20];
	struct node * next;
};

uint32_t		dig_off;			// Offset within a digest for comparisons.
uint32_t		err;				// Return value after comparing digests.
uint32_t		word_rf_len;		// Length of generated ascii word to brute.
uint32_t		pd_len = 0;			// Length of password_digest.
uint32_t		wlen = 1;
uint64_t		cnt_words = 0;		// passwords
uint64_t		cnt_chars = 0;		// characters
uint8_t			word_rf[128];		// Generated password.
unsigned char *	password_digest;	// Binary version of unknown password's hash.
char			password_hash[128];	// Hash of the unknown password, user supplied.
//uint8_t			sha1_digest[21];
//uint8_t			md5_digest[16];
uint8_t			ssl_digest[21];

const char   	fasthex[] = "0123456789abcdef\0";
struct rusage	usage;
struct termios	tio_isaved, tio_osaved, tio_set;
FILE *			fd;
uint32_t		input_mode = MODE_SINGLE;	// Source of input (argument or file)
char *			line_buf;			// Dynamically allocated buffer to hold a line from file
size_t			line_len;			// Length of line
typedef struct node NODE_T;
NODE_T *		list = NULL;		// Start of linked list, digests converted from strings in the input file
NODE_T *		list_pvt = NULL;	// Current pointer to a node within a list
NODE_T *		list_tmp = NULL;	// Temporary pointer to a node within a list
uint32_t		hash_mode;			// Type of HASH given

/* Alphabet sets, the lower the set number the faster result will be computed. */
char				alphabet[128];
const char			set_1[] = "0123456789\0";
const char			set_2[] = "0123456789abcdef\0";
const char			set_3[] = "0123456789ABCDEF\0";
const char			set_4[] = "abcdefghijklmnopqrstuvwxyz\0";
const char			set_5[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\0";
const char			set_6[] = "abcdefghijklmnopqrstuvwxyz0123456789\0";
const char			set_7[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789\0";
const char			set_8[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\0";
//const char			set_9[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789\0";
/* English language frequency analysis */
const char			set_9[] = "etaoinshrdlcumwfgypbvkjxqzETAOINSHRDLCUMWFGYPBVKJXQZ0123456789\0";
char				set_10[128];

#include "functions.h"

/*****************************************************************************/
int
main (int argc, char *argv[])
{
	int			word_size, set;
	//int			flags;				// stdio fd flags
	uint16_t	x, i = 0;

	if (argc != 4)
		{
			printf (VERSION);
			printf ("Usage: unhash SIZE SET HASH\n");
			printf ("Performs a brute-force attack on the given HASH.\n");
			printf ("Only MD5 and SHA1 hashes! (for now)\n");
			printf ("\n");
			printf ("SIZE\tMinimum amount of letters to start with.\n");
			printf ("\n");
			printf ("SET \tNumber of the alphabet set to acquire letters from.\n");
			printf ("    \t1. Numeric only\n");
			printf ("    \t2. Hexadecimal in lowercase\n");
			printf ("    \t3. HEXadecimal in uppercase\n");
			printf ("    \t4. alpha only in lowercase\n");
			printf ("    \t5. ALPHA only in uppercase\n");
			printf ("    \t6. alphanumeric in lowercase\n");
			printf ("    \t7. ALPHANUMERIC in uppercase\n");
			printf ("    \t8. All alpha only, both uppercase and lowercase\n");
			printf ("    \t9. Alpha-Numeric, both uppercase and lowercase\n");
			printf ("    \t10. All printable ascii characters\n");
			printf ("\n");
			printf ("HASH\tHash string to attack or filename with a list of hashes (one per line).\n");

			exit (EXIT_SUCCESS);
		}

	/* structures and buffers init */
	memset (alphabet, '\0', sizeof (alphabet) );
	memset (password_hash, '\0', sizeof (password_hash) );
	line_buf = malloc(LINE_BUF_LEN);
	memset(line_buf, '\0', LINE_BUF_LEN);

	/* Read arguments */
	sscanf(argv[1], "%i", &word_size);
	sscanf(argv[2], "%i", &set);
	
	/* file input mode if 3rd argument is a file */
	fd = fopen(argv[3], "r");
	if (fd) {		
		input_mode = MODE_FILE;
	
		while ( (line_buf = fgets(line_buf, LINE_BUF_LEN, fd)) ) {
			line_len = strnlen(line_buf, LINE_BUF_LEN);
			
			if (line_len >= 33 || line_len <= 42) {
				(line_buf[line_len - 2] == '\r') ? (line_buf[line_len - 2] = '\0') : (line_buf[line_len - 1] = '\0');
				
				if ( password_hash[0] != '\0' && hashtype(password_hash) != hashtype(line_buf) ) {
					fprintf(stderr, "[i]... Current line's hash type (%s) did not match first type (%s), ignoring!\n", \
						(hash_mode == HASH_MD5) ? ("SHA1") : ("MD5"), (hash_mode == HASH_MD5) ? ("MD5") : ("SHA1"));
					continue;
				}
				
				/* convert to digest and add to list */
				password_digest = hash2digest(line_buf);
				list_tmp = malloc(sizeof(NODE_T));
				memcpy(list_tmp->digest, password_digest, pd_len + 1);
				list_tmp->next = NULL;
				
				if ( list_findnode(&list, list_tmp) ) {
					fprintf(stderr, "[i]... Duplicate entry (%s) ignoring!\n", line_buf);
					free(list_tmp);
					continue;
				}
				
				if ( ! list_addnode(&list, list_tmp) )
					Error (1, 21, "Failed to add node");

				memcpy(password_hash, line_buf, strnlen(line_buf, line_len));
				hash_mode = hashtype(password_hash);
			}
		}
		fclose (fd);
		if ( list_countnodes(list) == 1)
			fprintf (stderr, "[i]... Total of 1 entry\n");
		else
			fprintf ( stderr, "[i]... Total of %i entries\n", list_countnodes(list) );
	}
			
	if (input_mode == MODE_SINGLE) {
		list_pvt = malloc (sizeof(NODE_T));
		list_pvt->next = NULL;
		
		snprintf(password_hash, sizeof(password_hash), "%s", argv[3]);
		password_digest = hash2digest(password_hash);
		memcpy(list_pvt->digest, password_digest, pd_len + 1);
		
		if ( ! list_addnode(&list, list_pvt) )
			Error (1, 11, "Failed to add node");
	}
	
	switch ( strlen(password_hash) )
	{
		case 32:	calculation = md5crack;
					fprintf(stderr, "*** Computing MD5 ***\n");
					hash_mode = HASH_MD5;
					break;
		case 40:	calculation = sha1crack;
					fprintf(stderr, "*** Computing SHA1 ***\n");
					hash_mode = HASH_SHA1;
					break;
		default:	Error(1, 0, "Incorrect HASH");	break;
	}
	
	/* configure alphabet */
	switch (set)
	{
		case 1:		strncpy (alphabet, set_1, strlen (set_1) );	break;
		case 2:		strncpy (alphabet, set_2, strlen (set_2) );	break;
		case 3:		strncpy (alphabet, set_3, strlen (set_3) );	break;
		case 4:		strncpy (alphabet, set_4, strlen (set_4) );	break;
		case 5:		strncpy (alphabet, set_5, strlen (set_5) );	break;
		case 6:		strncpy (alphabet, set_6, strlen (set_6) );	break;
		case 7:		strncpy (alphabet, set_7, strlen (set_7) );	break;
		case 8:		strncpy (alphabet, set_8, strlen (set_8) );	break;
		case 9:		strncpy (alphabet, set_9, strlen (set_9) );	break;
		case 10:
					for (x = 33; x < 127; x++)
						set_10[i++] = x;
					set_10[i] = '\0';
					strncpy (alphabet, set_10, strlen (set_10) );
					break;				
		default:	Error (1, 0, "Unknow alphabet set"); break;
	}

	if (word_size > MAX_WORD_SIZE)
		Error(1, 0, "Number is too big");
	else {
		/* Setup standard input to deliver asynchronous I/O signals. */
		/*
		fcntl(STDIN_FILENO, F_SETOWN, getpid());
		flags = fcntl(STDIN_FILENO, F_GETFL);
		
		if (flags != -1) {
			flags |= O_ASYNC;
			fcntl(STDIN_FILENO, F_SETFL, flags);
		}
		*/
		
		/* Configure terminal's standard input to deliver data regardless if enter was pressed. */
		if ( isatty(STDIN_FILENO) ) {
			
			tcdrain(STDIN_FILENO);
			tcdrain(STDOUT_FILENO);
			tcgetattr(STDIN_FILENO, &tio_isaved);
			tcgetattr(STDOUT_FILENO, &tio_osaved);
			
			x = tcgetattr(STDIN_FILENO, &tio_set);
			if (x)
				Error(1, 0, "Error obtaining terminal attributes");
			
			/* configure the structure */
			tio_set.c_lflag &= ~ECHO;	// do not echo chars back to user
			tio_set.c_iflag &= ICRNL;	// convert CR to NL
			//tio_set.c_cc[VMIN] = 0;
			//tio_set.c_cc[VTIME] = 0;
			
			/* apply new attributes */
			x = tcsetattr(STDIN_FILENO, TCSANOW, &tio_set);
			if (x)
				Error(1, 0, "Error setting terminal attributes");
			
			/* handle aborts and key presses */
			signal(SIGIO, signal_handler);
			signal(SIGINT, signal_handler);
			
			/* clean up on exit */
			if ( atexit(bye) )
				Error(1, 1, "Error setting exit handler");
		}
		
		(word_size > 0) ? (wlen = word_size) : (wlen = 1);
		brute2();
	}
	
return 0;
}
