#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2795
#define LARGE_STATE_COUNT 189
#define SYMBOL_COUNT 273
#define ALIAS_COUNT 2
#define TOKEN_COUNT 108
#define EXTERNAL_TOKEN_COUNT 12
#define FIELD_COUNT 32
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 138

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_SEMI = 2,
  anon_sym_import = 3,
  anon_sym_DOT = 4,
  anon_sym_from = 5,
  anon_sym___future__ = 6,
  anon_sym_LPAREN = 7,
  anon_sym_RPAREN = 8,
  anon_sym_COMMA = 9,
  anon_sym_as = 10,
  anon_sym_STAR = 11,
  anon_sym_print = 12,
  anon_sym_GT_GT = 13,
  anon_sym_assert = 14,
  anon_sym_COLON_EQ = 15,
  anon_sym_return = 16,
  anon_sym_del = 17,
  anon_sym_raise = 18,
  anon_sym_pass = 19,
  anon_sym_break = 20,
  anon_sym_continue = 21,
  anon_sym_if = 22,
  anon_sym_COLON = 23,
  anon_sym_elif = 24,
  anon_sym_else = 25,
  anon_sym_match = 26,
  anon_sym_case = 27,
  anon_sym_async = 28,
  anon_sym_for = 29,
  anon_sym_in = 30,
  anon_sym_while = 31,
  anon_sym_try = 32,
  anon_sym_except = 33,
  anon_sym_except_STAR = 34,
  anon_sym_finally = 35,
  anon_sym_with = 36,
  anon_sym_def = 37,
  anon_sym_DASH_GT = 38,
  anon_sym_STAR_STAR = 39,
  anon_sym_global = 40,
  anon_sym_nonlocal = 41,
  anon_sym_exec = 42,
  anon_sym_type = 43,
  anon_sym_EQ = 44,
  anon_sym_class = 45,
  anon_sym_LBRACK = 46,
  anon_sym_RBRACK = 47,
  anon_sym_AT = 48,
  anon_sym_DASH = 49,
  anon_sym__ = 50,
  anon_sym_PIPE = 51,
  anon_sym_LBRACE = 52,
  anon_sym_RBRACE = 53,
  anon_sym_PLUS = 54,
  anon_sym_not = 55,
  anon_sym_and = 56,
  anon_sym_or = 57,
  anon_sym_SLASH = 58,
  anon_sym_PERCENT = 59,
  anon_sym_SLASH_SLASH = 60,
  anon_sym_AMP = 61,
  anon_sym_CARET = 62,
  anon_sym_LT_LT = 63,
  anon_sym_TILDE = 64,
  anon_sym_is = 65,
  anon_sym_LT = 66,
  anon_sym_LT_EQ = 67,
  anon_sym_EQ_EQ = 68,
  anon_sym_BANG_EQ = 69,
  anon_sym_GT_EQ = 70,
  anon_sym_GT = 71,
  anon_sym_LT_GT = 72,
  anon_sym_lambda = 73,
  anon_sym_PLUS_EQ = 74,
  anon_sym_DASH_EQ = 75,
  anon_sym_STAR_EQ = 76,
  anon_sym_SLASH_EQ = 77,
  anon_sym_AT_EQ = 78,
  anon_sym_SLASH_SLASH_EQ = 79,
  anon_sym_PERCENT_EQ = 80,
  anon_sym_STAR_STAR_EQ = 81,
  anon_sym_GT_GT_EQ = 82,
  anon_sym_LT_LT_EQ = 83,
  anon_sym_AMP_EQ = 84,
  anon_sym_CARET_EQ = 85,
  anon_sym_PIPE_EQ = 86,
  anon_sym_yield = 87,
  sym_ellipsis = 88,
  sym_escape_sequence = 89,
  anon_sym_BSLASH = 90,
  aux_sym_format_specifier_token1 = 91,
  sym_type_conversion = 92,
  sym_integer = 93,
  sym_float = 94,
  anon_sym_await = 95,
  sym_true = 96,
  sym_false = 97,
  sym_none = 98,
  sym_comment = 99,
  sym_line_continuation = 100,
  sym__newline = 101,
  sym__indent = 102,
  sym__dedent = 103,
  sym_string_start = 104,
  sym__string_content = 105,
  sym_escape_interpolation = 106,
  sym_string_end = 107,
  sym_module = 108,
  sym__statement = 109,
  sym__simple_statements = 110,
  sym_import_statement = 111,
  sym_import_prefix = 112,
  sym_relative_import = 113,
  sym_future_import_statement = 114,
  sym_import_from_statement = 115,
  sym__import_list = 116,
  sym_aliased_import = 117,
  sym_wildcard_import = 118,
  sym_print_statement = 119,
  sym_chevron = 120,
  sym_assert_statement = 121,
  sym_expression_statement = 122,
  sym_named_expression = 123,
  sym__named_expression_lhs = 124,
  sym_return_statement = 125,
  sym_delete_statement = 126,
  sym_raise_statement = 127,
  sym_pass_statement = 128,
  sym_break_statement = 129,
  sym_continue_statement = 130,
  sym_if_statement = 131,
  sym_elif_clause = 132,
  sym_else_clause = 133,
  sym_match_statement = 134,
  sym__match_block = 135,
  sym_case_clause = 136,
  sym_for_statement = 137,
  sym_while_statement = 138,
  sym_try_statement = 139,
  sym_except_clause = 140,
  sym_except_group_clause = 141,
  sym_finally_clause = 142,
  sym_with_statement = 143,
  sym_with_clause = 144,
  sym_with_item = 145,
  sym_function_definition = 146,
  sym_parameters = 147,
  sym_lambda_parameters = 148,
  sym_list_splat = 149,
  sym_dictionary_splat = 150,
  sym_global_statement = 151,
  sym_nonlocal_statement = 152,
  sym_exec_statement = 153,
  sym_type_alias_statement = 154,
  sym_class_definition = 155,
  sym_type_parameter = 156,
  sym_parenthesized_list_splat = 157,
  sym_argument_list = 158,
  sym_decorated_definition = 159,
  sym_decorator = 160,
  sym_block = 161,
  sym_expression_list = 162,
  sym_dotted_name = 163,
  sym_case_pattern = 164,
  sym__simple_pattern = 165,
  sym__as_pattern = 166,
  sym_union_pattern = 167,
  sym__list_pattern = 168,
  sym__tuple_pattern = 169,
  sym_dict_pattern = 170,
  sym__key_value_pattern = 171,
  sym_keyword_pattern = 172,
  sym_splat_pattern = 173,
  sym_class_pattern = 174,
  sym_complex_pattern = 175,
  sym__parameters = 176,
  sym__patterns = 177,
  sym_parameter = 178,
  sym_pattern = 179,
  sym_tuple_pattern = 180,
  sym_list_pattern = 181,
  sym_default_parameter = 182,
  sym_typed_default_parameter = 183,
  sym_list_splat_pattern = 184,
  sym_dictionary_splat_pattern = 185,
  sym_as_pattern = 186,
  sym__expression_within_for_in_clause = 187,
  sym_expression = 188,
  sym_primary_expression = 189,
  sym_not_operator = 190,
  sym_boolean_operator = 191,
  sym_binary_operator = 192,
  sym_unary_operator = 193,
  sym__not_in = 194,
  sym__is_not = 195,
  sym_comparison_operator = 196,
  sym_lambda = 197,
  sym_lambda_within_for_in_clause = 198,
  sym_assignment = 199,
  sym_augmented_assignment = 200,
  sym_pattern_list = 201,
  sym__right_hand_side = 202,
  sym_yield = 203,
  sym_attribute = 204,
  sym_subscript = 205,
  sym_slice = 206,
  sym_call = 207,
  sym_typed_parameter = 208,
  sym_type = 209,
  sym_splat_type = 210,
  sym_generic_type = 211,
  sym_union_type = 212,
  sym_constrained_type = 213,
  sym_member_type = 214,
  sym_keyword_argument = 215,
  sym_list = 216,
  sym_set = 217,
  sym_tuple = 218,
  sym_dictionary = 219,
  sym_pair = 220,
  sym_list_comprehension = 221,
  sym_dictionary_comprehension = 222,
  sym_set_comprehension = 223,
  sym_generator_expression = 224,
  sym__comprehension_clauses = 225,
  sym_parenthesized_expression = 226,
  sym__collection_elements = 227,
  sym_for_in_clause = 228,
  sym_if_clause = 229,
  sym_conditional_expression = 230,
  sym_concatenated_string = 231,
  sym_string = 232,
  sym_string_content = 233,
  sym_interpolation = 234,
  sym__f_expression = 235,
  sym__not_escape_sequence = 236,
  sym_format_specifier = 237,
  sym_await = 238,
  sym_positional_separator = 239,
  sym_keyword_separator = 240,
  aux_sym_module_repeat1 = 241,
  aux_sym__simple_statements_repeat1 = 242,
  aux_sym_import_prefix_repeat1 = 243,
  aux_sym__import_list_repeat1 = 244,
  aux_sym_print_statement_repeat1 = 245,
  aux_sym_assert_statement_repeat1 = 246,
  aux_sym_if_statement_repeat1 = 247,
  aux_sym_match_statement_repeat1 = 248,
  aux_sym__match_block_repeat1 = 249,
  aux_sym_case_clause_repeat1 = 250,
  aux_sym_try_statement_repeat1 = 251,
  aux_sym_try_statement_repeat2 = 252,
  aux_sym_with_clause_repeat1 = 253,
  aux_sym_global_statement_repeat1 = 254,
  aux_sym_type_parameter_repeat1 = 255,
  aux_sym_argument_list_repeat1 = 256,
  aux_sym_decorated_definition_repeat1 = 257,
  aux_sym_dotted_name_repeat1 = 258,
  aux_sym_union_pattern_repeat1 = 259,
  aux_sym_dict_pattern_repeat1 = 260,
  aux_sym__parameters_repeat1 = 261,
  aux_sym__patterns_repeat1 = 262,
  aux_sym_comparison_operator_repeat1 = 263,
  aux_sym_subscript_repeat1 = 264,
  aux_sym_dictionary_repeat1 = 265,
  aux_sym__comprehension_clauses_repeat1 = 266,
  aux_sym__collection_elements_repeat1 = 267,
  aux_sym_for_in_clause_repeat1 = 268,
  aux_sym_concatenated_string_repeat1 = 269,
  aux_sym_string_repeat1 = 270,
  aux_sym_string_content_repeat1 = 271,
  aux_sym_format_specifier_repeat1 = 272,
  alias_sym_as_pattern_target = 273,
  alias_sym_format_expression = 274,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_SEMI] = ";",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_from] = "from",
  [anon_sym___future__] = "__future__",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [anon_sym_as] = "as",
  [anon_sym_STAR] = "*",
  [anon_sym_print] = "print",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_assert] = "assert",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_return] = "return",
  [anon_sym_del] = "del",
  [anon_sym_raise] = "raise",
  [anon_sym_pass] = "pass",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_if] = "if",
  [anon_sym_COLON] = ":",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_match] = "match",
  [anon_sym_case] = "case",
  [anon_sym_async] = "async",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_try] = "try",
  [anon_sym_except] = "except",
  [anon_sym_except_STAR] = "except*",
  [anon_sym_finally] = "finally",
  [anon_sym_with] = "with",
  [anon_sym_def] = "def",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_global] = "global",
  [anon_sym_nonlocal] = "nonlocal",
  [anon_sym_exec] = "exec",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_class] = "class",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_AT] = "@",
  [anon_sym_DASH] = "-",
  [anon_sym__] = "_",
  [anon_sym_PIPE] = "|",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_PLUS] = "+",
  [anon_sym_not] = "not",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_TILDE] = "~",
  [anon_sym_is] = "is",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_lambda] = "lambda",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AT_EQ] = "@=",
  [anon_sym_SLASH_SLASH_EQ] = "//=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_yield] = "yield",
  [sym_ellipsis] = "ellipsis",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_BSLASH] = "\\",
  [aux_sym_format_specifier_token1] = "format_specifier_token1",
  [sym_type_conversion] = "type_conversion",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_await] = "await",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_none] = "none",
  [sym_comment] = "comment",
  [sym_line_continuation] = "line_continuation",
  [sym__newline] = "_newline",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym_string_start] = "string_start",
  [sym__string_content] = "_string_content",
  [sym_escape_interpolation] = "escape_interpolation",
  [sym_string_end] = "string_end",
  [sym_module] = "module",
  [sym__statement] = "_statement",
  [sym__simple_statements] = "_simple_statements",
  [sym_import_statement] = "import_statement",
  [sym_import_prefix] = "import_prefix",
  [sym_relative_import] = "relative_import",
  [sym_future_import_statement] = "future_import_statement",
  [sym_import_from_statement] = "import_from_statement",
  [sym__import_list] = "_import_list",
  [sym_aliased_import] = "aliased_import",
  [sym_wildcard_import] = "wildcard_import",
  [sym_print_statement] = "print_statement",
  [sym_chevron] = "chevron",
  [sym_assert_statement] = "assert_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_named_expression] = "named_expression",
  [sym__named_expression_lhs] = "_named_expression_lhs",
  [sym_return_statement] = "return_statement",
  [sym_delete_statement] = "delete_statement",
  [sym_raise_statement] = "raise_statement",
  [sym_pass_statement] = "pass_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_match_statement] = "match_statement",
  [sym__match_block] = "block",
  [sym_case_clause] = "case_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_try_statement] = "try_statement",
  [sym_except_clause] = "except_clause",
  [sym_except_group_clause] = "except_group_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_with_statement] = "with_statement",
  [sym_with_clause] = "with_clause",
  [sym_with_item] = "with_item",
  [sym_function_definition] = "function_definition",
  [sym_parameters] = "parameters",
  [sym_lambda_parameters] = "lambda_parameters",
  [sym_list_splat] = "list_splat",
  [sym_dictionary_splat] = "dictionary_splat",
  [sym_global_statement] = "global_statement",
  [sym_nonlocal_statement] = "nonlocal_statement",
  [sym_exec_statement] = "exec_statement",
  [sym_type_alias_statement] = "type_alias_statement",
  [sym_class_definition] = "class_definition",
  [sym_type_parameter] = "type_parameter",
  [sym_parenthesized_list_splat] = "parenthesized_list_splat",
  [sym_argument_list] = "argument_list",
  [sym_decorated_definition] = "decorated_definition",
  [sym_decorator] = "decorator",
  [sym_block] = "block",
  [sym_expression_list] = "expression_list",
  [sym_dotted_name] = "dotted_name",
  [sym_case_pattern] = "case_pattern",
  [sym__simple_pattern] = "_simple_pattern",
  [sym__as_pattern] = "as_pattern",
  [sym_union_pattern] = "union_pattern",
  [sym__list_pattern] = "list_pattern",
  [sym__tuple_pattern] = "tuple_pattern",
  [sym_dict_pattern] = "dict_pattern",
  [sym__key_value_pattern] = "_key_value_pattern",
  [sym_keyword_pattern] = "keyword_pattern",
  [sym_splat_pattern] = "splat_pattern",
  [sym_class_pattern] = "class_pattern",
  [sym_complex_pattern] = "complex_pattern",
  [sym__parameters] = "_parameters",
  [sym__patterns] = "_patterns",
  [sym_parameter] = "parameter",
  [sym_pattern] = "pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym_default_parameter] = "default_parameter",
  [sym_typed_default_parameter] = "typed_default_parameter",
  [sym_list_splat_pattern] = "list_splat_pattern",
  [sym_dictionary_splat_pattern] = "dictionary_splat_pattern",
  [sym_as_pattern] = "as_pattern",
  [sym__expression_within_for_in_clause] = "_expression_within_for_in_clause",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_not_operator] = "not_operator",
  [sym_boolean_operator] = "boolean_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym__not_in] = "not in",
  [sym__is_not] = "is not",
  [sym_comparison_operator] = "comparison_operator",
  [sym_lambda] = "lambda",
  [sym_lambda_within_for_in_clause] = "lambda",
  [sym_assignment] = "assignment",
  [sym_augmented_assignment] = "augmented_assignment",
  [sym_pattern_list] = "pattern_list",
  [sym__right_hand_side] = "_right_hand_side",
  [sym_yield] = "yield",
  [sym_attribute] = "attribute",
  [sym_subscript] = "subscript",
  [sym_slice] = "slice",
  [sym_call] = "call",
  [sym_typed_parameter] = "typed_parameter",
  [sym_type] = "type",
  [sym_splat_type] = "splat_type",
  [sym_generic_type] = "generic_type",
  [sym_union_type] = "union_type",
  [sym_constrained_type] = "constrained_type",
  [sym_member_type] = "member_type",
  [sym_keyword_argument] = "keyword_argument",
  [sym_list] = "list",
  [sym_set] = "set",
  [sym_tuple] = "tuple",
  [sym_dictionary] = "dictionary",
  [sym_pair] = "pair",
  [sym_list_comprehension] = "list_comprehension",
  [sym_dictionary_comprehension] = "dictionary_comprehension",
  [sym_set_comprehension] = "set_comprehension",
  [sym_generator_expression] = "generator_expression",
  [sym__comprehension_clauses] = "_comprehension_clauses",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__collection_elements] = "_collection_elements",
  [sym_for_in_clause] = "for_in_clause",
  [sym_if_clause] = "if_clause",
  [sym_conditional_expression] = "conditional_expression",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string] = "string",
  [sym_string_content] = "string_content",
  [sym_interpolation] = "interpolation",
  [sym__f_expression] = "_f_expression",
  [sym__not_escape_sequence] = "_not_escape_sequence",
  [sym_format_specifier] = "format_specifier",
  [sym_await] = "await",
  [sym_positional_separator] = "positional_separator",
  [sym_keyword_separator] = "keyword_separator",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym__simple_statements_repeat1] = "_simple_statements_repeat1",
  [aux_sym_import_prefix_repeat1] = "import_prefix_repeat1",
  [aux_sym__import_list_repeat1] = "_import_list_repeat1",
  [aux_sym_print_statement_repeat1] = "print_statement_repeat1",
  [aux_sym_assert_statement_repeat1] = "assert_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_match_statement_repeat1] = "match_statement_repeat1",
  [aux_sym__match_block_repeat1] = "_match_block_repeat1",
  [aux_sym_case_clause_repeat1] = "case_clause_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_try_statement_repeat2] = "try_statement_repeat2",
  [aux_sym_with_clause_repeat1] = "with_clause_repeat1",
  [aux_sym_global_statement_repeat1] = "global_statement_repeat1",
  [aux_sym_type_parameter_repeat1] = "type_parameter_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_decorated_definition_repeat1] = "decorated_definition_repeat1",
  [aux_sym_dotted_name_repeat1] = "dotted_name_repeat1",
  [aux_sym_union_pattern_repeat1] = "union_pattern_repeat1",
  [aux_sym_dict_pattern_repeat1] = "dict_pattern_repeat1",
  [aux_sym__parameters_repeat1] = "_parameters_repeat1",
  [aux_sym__patterns_repeat1] = "_patterns_repeat1",
  [aux_sym_comparison_operator_repeat1] = "comparison_operator_repeat1",
  [aux_sym_subscript_repeat1] = "subscript_repeat1",
  [aux_sym_dictionary_repeat1] = "dictionary_repeat1",
  [aux_sym__comprehension_clauses_repeat1] = "_comprehension_clauses_repeat1",
  [aux_sym__collection_elements_repeat1] = "_collection_elements_repeat1",
  [aux_sym_for_in_clause_repeat1] = "for_in_clause_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_content_repeat1] = "string_content_repeat1",
  [aux_sym_format_specifier_repeat1] = "format_specifier_repeat1",
  [alias_sym_as_pattern_target] = "as_pattern_target",
  [alias_sym_format_expression] = "format_expression",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_from] = anon_sym_from,
  [anon_sym___future__] = anon_sym___future__,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_del] = anon_sym_del,
  [anon_sym_raise] = anon_sym_raise,
  [anon_sym_pass] = anon_sym_pass,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_except] = anon_sym_except,
  [anon_sym_except_STAR] = anon_sym_except_STAR,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_nonlocal] = anon_sym_nonlocal,
  [anon_sym_exec] = anon_sym_exec,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym__] = anon_sym__,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_lambda] = anon_sym_lambda,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AT_EQ] = anon_sym_AT_EQ,
  [anon_sym_SLASH_SLASH_EQ] = anon_sym_SLASH_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_yield] = anon_sym_yield,
  [sym_ellipsis] = sym_ellipsis,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [aux_sym_format_specifier_token1] = aux_sym_format_specifier_token1,
  [sym_type_conversion] = sym_type_conversion,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_await] = anon_sym_await,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_none] = sym_none,
  [sym_comment] = sym_comment,
  [sym_line_continuation] = sym_line_continuation,
  [sym__newline] = sym__newline,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym_string_start] = sym_string_start,
  [sym__string_content] = sym__string_content,
  [sym_escape_interpolation] = sym_escape_interpolation,
  [sym_string_end] = sym_string_end,
  [sym_module] = sym_module,
  [sym__statement] = sym__statement,
  [sym__simple_statements] = sym__simple_statements,
  [sym_import_statement] = sym_import_statement,
  [sym_import_prefix] = sym_import_prefix,
  [sym_relative_import] = sym_relative_import,
  [sym_future_import_statement] = sym_future_import_statement,
  [sym_import_from_statement] = sym_import_from_statement,
  [sym__import_list] = sym__import_list,
  [sym_aliased_import] = sym_aliased_import,
  [sym_wildcard_import] = sym_wildcard_import,
  [sym_print_statement] = sym_print_statement,
  [sym_chevron] = sym_chevron,
  [sym_assert_statement] = sym_assert_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_named_expression] = sym_named_expression,
  [sym__named_expression_lhs] = sym__named_expression_lhs,
  [sym_return_statement] = sym_return_statement,
  [sym_delete_statement] = sym_delete_statement,
  [sym_raise_statement] = sym_raise_statement,
  [sym_pass_statement] = sym_pass_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_match_statement] = sym_match_statement,
  [sym__match_block] = sym_block,
  [sym_case_clause] = sym_case_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_except_clause] = sym_except_clause,
  [sym_except_group_clause] = sym_except_group_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_with_statement] = sym_with_statement,
  [sym_with_clause] = sym_with_clause,
  [sym_with_item] = sym_with_item,
  [sym_function_definition] = sym_function_definition,
  [sym_parameters] = sym_parameters,
  [sym_lambda_parameters] = sym_lambda_parameters,
  [sym_list_splat] = sym_list_splat,
  [sym_dictionary_splat] = sym_dictionary_splat,
  [sym_global_statement] = sym_global_statement,
  [sym_nonlocal_statement] = sym_nonlocal_statement,
  [sym_exec_statement] = sym_exec_statement,
  [sym_type_alias_statement] = sym_type_alias_statement,
  [sym_class_definition] = sym_class_definition,
  [sym_type_parameter] = sym_type_parameter,
  [sym_parenthesized_list_splat] = sym_parenthesized_list_splat,
  [sym_argument_list] = sym_argument_list,
  [sym_decorated_definition] = sym_decorated_definition,
  [sym_decorator] = sym_decorator,
  [sym_block] = sym_block,
  [sym_expression_list] = sym_expression_list,
  [sym_dotted_name] = sym_dotted_name,
  [sym_case_pattern] = sym_case_pattern,
  [sym__simple_pattern] = sym__simple_pattern,
  [sym__as_pattern] = sym_as_pattern,
  [sym_union_pattern] = sym_union_pattern,
  [sym__list_pattern] = sym_list_pattern,
  [sym__tuple_pattern] = sym_tuple_pattern,
  [sym_dict_pattern] = sym_dict_pattern,
  [sym__key_value_pattern] = sym__key_value_pattern,
  [sym_keyword_pattern] = sym_keyword_pattern,
  [sym_splat_pattern] = sym_splat_pattern,
  [sym_class_pattern] = sym_class_pattern,
  [sym_complex_pattern] = sym_complex_pattern,
  [sym__parameters] = sym__parameters,
  [sym__patterns] = sym__patterns,
  [sym_parameter] = sym_parameter,
  [sym_pattern] = sym_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym_default_parameter] = sym_default_parameter,
  [sym_typed_default_parameter] = sym_typed_default_parameter,
  [sym_list_splat_pattern] = sym_list_splat_pattern,
  [sym_dictionary_splat_pattern] = sym_dictionary_splat_pattern,
  [sym_as_pattern] = sym_as_pattern,
  [sym__expression_within_for_in_clause] = sym__expression_within_for_in_clause,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_not_operator] = sym_not_operator,
  [sym_boolean_operator] = sym_boolean_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym__not_in] = sym__not_in,
  [sym__is_not] = sym__is_not,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_lambda] = sym_lambda,
  [sym_lambda_within_for_in_clause] = sym_lambda,
  [sym_assignment] = sym_assignment,
  [sym_augmented_assignment] = sym_augmented_assignment,
  [sym_pattern_list] = sym_pattern_list,
  [sym__right_hand_side] = sym__right_hand_side,
  [sym_yield] = sym_yield,
  [sym_attribute] = sym_attribute,
  [sym_subscript] = sym_subscript,
  [sym_slice] = sym_slice,
  [sym_call] = sym_call,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_type] = sym_type,
  [sym_splat_type] = sym_splat_type,
  [sym_generic_type] = sym_generic_type,
  [sym_union_type] = sym_union_type,
  [sym_constrained_type] = sym_constrained_type,
  [sym_member_type] = sym_member_type,
  [sym_keyword_argument] = sym_keyword_argument,
  [sym_list] = sym_list,
  [sym_set] = sym_set,
  [sym_tuple] = sym_tuple,
  [sym_dictionary] = sym_dictionary,
  [sym_pair] = sym_pair,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_dictionary_comprehension] = sym_dictionary_comprehension,
  [sym_set_comprehension] = sym_set_comprehension,
  [sym_generator_expression] = sym_generator_expression,
  [sym__comprehension_clauses] = sym__comprehension_clauses,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__collection_elements] = sym__collection_elements,
  [sym_for_in_clause] = sym_for_in_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string] = sym_string,
  [sym_string_content] = sym_string_content,
  [sym_interpolation] = sym_interpolation,
  [sym__f_expression] = sym__f_expression,
  [sym__not_escape_sequence] = sym__not_escape_sequence,
  [sym_format_specifier] = sym_format_specifier,
  [sym_await] = sym_await,
  [sym_positional_separator] = sym_positional_separator,
  [sym_keyword_separator] = sym_keyword_separator,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym__simple_statements_repeat1] = aux_sym__simple_statements_repeat1,
  [aux_sym_import_prefix_repeat1] = aux_sym_import_prefix_repeat1,
  [aux_sym__import_list_repeat1] = aux_sym__import_list_repeat1,
  [aux_sym_print_statement_repeat1] = aux_sym_print_statement_repeat1,
  [aux_sym_assert_statement_repeat1] = aux_sym_assert_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_match_statement_repeat1] = aux_sym_match_statement_repeat1,
  [aux_sym__match_block_repeat1] = aux_sym__match_block_repeat1,
  [aux_sym_case_clause_repeat1] = aux_sym_case_clause_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_try_statement_repeat2] = aux_sym_try_statement_repeat2,
  [aux_sym_with_clause_repeat1] = aux_sym_with_clause_repeat1,
  [aux_sym_global_statement_repeat1] = aux_sym_global_statement_repeat1,
  [aux_sym_type_parameter_repeat1] = aux_sym_type_parameter_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_decorated_definition_repeat1] = aux_sym_decorated_definition_repeat1,
  [aux_sym_dotted_name_repeat1] = aux_sym_dotted_name_repeat1,
  [aux_sym_union_pattern_repeat1] = aux_sym_union_pattern_repeat1,
  [aux_sym_dict_pattern_repeat1] = aux_sym_dict_pattern_repeat1,
  [aux_sym__parameters_repeat1] = aux_sym__parameters_repeat1,
  [aux_sym__patterns_repeat1] = aux_sym__patterns_repeat1,
  [aux_sym_comparison_operator_repeat1] = aux_sym_comparison_operator_repeat1,
  [aux_sym_subscript_repeat1] = aux_sym_subscript_repeat1,
  [aux_sym_dictionary_repeat1] = aux_sym_dictionary_repeat1,
  [aux_sym__comprehension_clauses_repeat1] = aux_sym__comprehension_clauses_repeat1,
  [aux_sym__collection_elements_repeat1] = aux_sym__collection_elements_repeat1,
  [aux_sym_for_in_clause_repeat1] = aux_sym_for_in_clause_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_content_repeat1] = aux_sym_string_content_repeat1,
  [aux_sym_format_specifier_repeat1] = aux_sym_format_specifier_repeat1,
  [alias_sym_as_pattern_target] = alias_sym_as_pattern_target,
  [alias_sym_format_expression] = alias_sym_format_expression,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___future__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_del] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonlocal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lambda] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [sym_ellipsis] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_format_specifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_type_conversion] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_none] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_continuation] = {
    .visible = true,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym_string_start] = {
    .visible = true,
    .named = true,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_string_end] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_statements] = {
    .visible = false,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_relative_import] = {
    .visible = true,
    .named = true,
  },
  [sym_future_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_from_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__import_list] = {
    .visible = false,
    .named = true,
  },
  [sym_aliased_import] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard_import] = {
    .visible = true,
    .named = true,
  },
  [sym_print_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_chevron] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_named_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__named_expression_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_raise_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_match_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__match_block] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_except_group_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_global_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_nonlocal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_decorated_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_name] = {
    .visible = true,
    .named = true,
  },
  [sym_case_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_union_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dict_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__key_value_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_class_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_complex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__patterns] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_within_for_in_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_not_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__not_in] = {
    .visible = true,
    .named = false,
  },
  [sym__is_not] = {
    .visible = true,
    .named = false,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_within_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_list] = {
    .visible = true,
    .named = true,
  },
  [sym__right_hand_side] = {
    .visible = false,
    .named = true,
  },
  [sym_yield] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_slice] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_splat_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constrained_type] = {
    .visible = true,
    .named = true,
  },
  [sym_member_type] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_set_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__comprehension_clauses] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__collection_elements] = {
    .visible = false,
    .named = true,
  },
  [sym_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__f_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__not_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_format_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_await] = {
    .visible = true,
    .named = true,
  },
  [sym_positional_separator] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_separator] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__import_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_print_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assert_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__match_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decorated_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dotted_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dict_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comparison_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comprehension_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__collection_elements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_in_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_as_pattern_target] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_format_expression] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_cause = 7,
  field_code = 8,
  field_condition = 9,
  field_consequence = 10,
  field_definition = 11,
  field_expression = 12,
  field_format_specifier = 13,
  field_function = 14,
  field_guard = 15,
  field_key = 16,
  field_left = 17,
  field_module_name = 18,
  field_name = 19,
  field_object = 20,
  field_operator = 21,
  field_operators = 22,
  field_parameters = 23,
  field_return_type = 24,
  field_right = 25,
  field_subject = 26,
  field_subscript = 27,
  field_superclasses = 28,
  field_type = 29,
  field_type_conversion = 30,
  field_type_parameters = 31,
  field_value = 32,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_cause] = "cause",
  [field_code] = "code",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_definition] = "definition",
  [field_expression] = "expression",
  [field_format_specifier] = "format_specifier",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_key] = "key",
  [field_left] = "left",
  [field_module_name] = "module_name",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_operators] = "operators",
  [field_parameters] = "parameters",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_subject] = "subject",
  [field_subscript] = "subscript",
  [field_superclasses] = "superclasses",
  [field_type] = "type",
  [field_type_conversion] = "type_conversion",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [6] = {.index = 2, .length = 1},
  [7] = {.index = 3, .length = 1},
  [8] = {.index = 4, .length = 1},
  [9] = {.index = 5, .length = 2},
  [10] = {.index = 7, .length = 2},
  [11] = {.index = 9, .length = 1},
  [12] = {.index = 10, .length = 1},
  [13] = {.index = 11, .length = 2},
  [14] = {.index = 13, .length = 1},
  [15] = {.index = 14, .length = 2},
  [16] = {.index = 16, .length = 1},
  [17] = {.index = 17, .length = 1},
  [18] = {.index = 18, .length = 2},
  [19] = {.index = 20, .length = 2},
  [20] = {.index = 22, .length = 2},
  [21] = {.index = 24, .length = 3},
  [22] = {.index = 27, .length = 1},
  [23] = {.index = 28, .length = 2},
  [24] = {.index = 30, .length = 1},
  [25] = {.index = 31, .length = 2},
  [26] = {.index = 33, .length = 1},
  [27] = {.index = 34, .length = 1},
  [28] = {.index = 35, .length = 2},
  [29] = {.index = 37, .length = 2},
  [30] = {.index = 39, .length = 1},
  [31] = {.index = 40, .length = 2},
  [32] = {.index = 42, .length = 1},
  [34] = {.index = 43, .length = 1},
  [35] = {.index = 44, .length = 2},
  [36] = {.index = 46, .length = 1},
  [37] = {.index = 47, .length = 2},
  [38] = {.index = 49, .length = 1},
  [39] = {.index = 50, .length = 3},
  [40] = {.index = 53, .length = 2},
  [41] = {.index = 55, .length = 2},
  [42] = {.index = 17, .length = 1},
  [43] = {.index = 57, .length = 1},
  [44] = {.index = 58, .length = 2},
  [45] = {.index = 60, .length = 2},
  [46] = {.index = 62, .length = 1},
  [47] = {.index = 63, .length = 2},
  [48] = {.index = 65, .length = 2},
  [50] = {.index = 67, .length = 2},
  [51] = {.index = 69, .length = 2},
  [52] = {.index = 71, .length = 1},
  [53] = {.index = 72, .length = 3},
  [54] = {.index = 75, .length = 3},
  [55] = {.index = 78, .length = 3},
  [56] = {.index = 81, .length = 3},
  [57] = {.index = 84, .length = 4},
  [58] = {.index = 88, .length = 1},
  [59] = {.index = 89, .length = 3},
  [60] = {.index = 92, .length = 3},
  [61] = {.index = 95, .length = 2},
  [62] = {.index = 97, .length = 2},
  [63] = {.index = 99, .length = 3},
  [64] = {.index = 102, .length = 3},
  [65] = {.index = 105, .length = 3},
  [66] = {.index = 108, .length = 3},
  [67] = {.index = 111, .length = 3},
  [68] = {.index = 18, .length = 2},
  [69] = {.index = 114, .length = 1},
  [70] = {.index = 115, .length = 3},
  [71] = {.index = 118, .length = 2},
  [72] = {.index = 120, .length = 2},
  [73] = {.index = 122, .length = 2},
  [74] = {.index = 124, .length = 3},
  [75] = {.index = 127, .length = 1},
  [76] = {.index = 128, .length = 2},
  [77] = {.index = 130, .length = 2},
  [78] = {.index = 132, .length = 4},
  [79] = {.index = 136, .length = 2},
  [80] = {.index = 138, .length = 4},
  [81] = {.index = 142, .length = 4},
  [82] = {.index = 146, .length = 1},
  [83] = {.index = 147, .length = 4},
  [84] = {.index = 151, .length = 2},
  [85] = {.index = 153, .length = 3},
  [86] = {.index = 156, .length = 3},
  [87] = {.index = 159, .length = 4},
  [89] = {.index = 163, .length = 4},
  [90] = {.index = 167, .length = 4},
  [91] = {.index = 171, .length = 4},
  [92] = {.index = 175, .length = 4},
  [93] = {.index = 179, .length = 4},
  [94] = {.index = 183, .length = 3},
  [95] = {.index = 186, .length = 3},
  [96] = {.index = 189, .length = 2},
  [97] = {.index = 191, .length = 3},
  [98] = {.index = 194, .length = 5},
  [99] = {.index = 199, .length = 3},
  [100] = {.index = 202, .length = 4},
  [101] = {.index = 206, .length = 4},
  [102] = {.index = 210, .length = 4},
  [103] = {.index = 214, .length = 4},
  [105] = {.index = 218, .length = 4},
  [106] = {.index = 222, .length = 5},
  [107] = {.index = 227, .length = 5},
  [108] = {.index = 232, .length = 3},
  [109] = {.index = 235, .length = 2},
  [110] = {.index = 237, .length = 1},
  [111] = {.index = 238, .length = 4},
  [112] = {.index = 242, .length = 4},
  [113] = {.index = 246, .length = 4},
  [114] = {.index = 250, .length = 5},
  [115] = {.index = 255, .length = 5},
  [116] = {.index = 260, .length = 5},
  [117] = {.index = 265, .length = 5},
  [118] = {.index = 270, .length = 4},
  [119] = {.index = 274, .length = 4},
  [120] = {.index = 278, .length = 2},
  [121] = {.index = 280, .length = 1},
  [122] = {.index = 281, .length = 2},
  [123] = {.index = 283, .length = 2},
  [124] = {.index = 285, .length = 5},
  [125] = {.index = 290, .length = 5},
  [126] = {.index = 295, .length = 5},
  [128] = {.index = 300, .length = 6},
  [129] = {.index = 306, .length = 2},
  [130] = {.index = 308, .length = 2},
  [131] = {.index = 310, .length = 3},
  [132] = {.index = 313, .length = 1},
  [133] = {.index = 314, .length = 6},
  [134] = {.index = 320, .length = 3},
  [135] = {.index = 323, .length = 2},
  [136] = {.index = 325, .length = 2},
  [137] = {.index = 327, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1, .inherited = true},
  [1] =
    {field_name, 0},
  [2] =
    {field_argument, 1},
  [3] =
    {field_value, 0},
  [4] =
    {field_code, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_operators, 1, .inherited = true},
  [10] =
    {field_definition, 1},
  [11] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [13] =
    {field_argument, 2, .inherited = true},
  [14] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
  [16] =
    {field_cause, 2},
  [17] =
    {field_body, 2},
  [18] =
    {field_name, 0},
    {field_value, 2},
  [20] =
    {field_left, 0},
    {field_type, 2},
  [22] =
    {field_left, 0},
    {field_right, 2},
  [24] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [27] =
    {field_alias, 2},
  [28] =
    {field_attribute, 2},
    {field_object, 0},
  [30] =
    {field_operators, 0},
  [31] =
    {field_operators, 0, .inherited = true},
    {field_operators, 1, .inherited = true},
  [33] =
    {field_expression, 1},
  [34] =
    {field_name, 1},
  [35] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [37] =
    {field_alias, 2},
    {field_name, 0},
  [39] =
    {field_name, 3, .inherited = true},
  [40] =
    {field_module_name, 1},
    {field_name, 3, .inherited = true},
  [42] =
    {field_module_name, 1},
  [43] =
    {field_body, 1},
  [44] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [46] =
    {field_cause, 3},
  [47] =
    {field_condition, 1},
    {field_consequence, 3},
  [49] =
    {field_subject, 1},
  [50] =
    {field_alternative, 3, .inherited = true},
    {field_body, 3},
    {field_subject, 1},
  [53] =
    {field_subject, 0, .inherited = true},
    {field_subject, 1, .inherited = true},
  [55] =
    {field_body, 3},
    {field_condition, 1},
  [57] =
    {field_body, 3},
  [58] =
    {field_body, 3},
    {field_name, 1},
  [60] =
    {field_key, 0},
    {field_value, 2},
  [62] =
    {field_type, 2},
  [63] =
    {field_body, 3},
    {field_parameters, 1},
  [65] =
    {field_subscript, 2},
    {field_value, 0},
  [67] =
    {field_expression, 1},
    {field_type_conversion, 2},
  [69] =
    {field_expression, 1},
    {field_format_specifier, 2},
  [71] =
    {field_alternative, 0},
  [72] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [75] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [78] =
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [81] =
    {field_alternative, 4, .inherited = true},
    {field_body, 4},
    {field_subject, 1},
  [84] =
    {field_alternative, 4, .inherited = true},
    {field_body, 4},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [88] =
    {field_body, 4},
  [89] =
    {field_alternative, 4},
    {field_body, 3},
    {field_condition, 1},
  [92] =
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [95] =
    {field_body, 2},
    {field_body, 3},
  [97] =
    {field_body, 3},
    {field_body, 4},
  [99] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [102] =
    {field_body, 3},
    {field_body, 4},
    {field_name, 1},
  [105] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [108] =
    {field_body, 4},
    {field_name, 1},
    {field_superclasses, 2},
  [111] =
    {field_left, 0},
    {field_right, 4},
    {field_type, 2},
  [114] =
    {field_subscript, 1},
  [115] =
    {field_subscript, 2},
    {field_subscript, 3, .inherited = true},
    {field_value, 0},
  [118] =
    {field_subscript, 0, .inherited = true},
    {field_subscript, 1, .inherited = true},
  [120] =
    {field_expression, 1},
    {field_type_conversion, 3},
  [122] =
    {field_expression, 1},
    {field_format_specifier, 3},
  [124] =
    {field_expression, 1},
    {field_format_specifier, 3},
    {field_type_conversion, 2},
  [127] =
    {field_name, 4, .inherited = true},
  [128] =
    {field_module_name, 1},
    {field_name, 4, .inherited = true},
  [130] =
    {field_left, 1},
    {field_right, 3},
  [132] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [136] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [138] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [142] =
    {field_alternative, 5, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [146] =
    {field_alternative, 1, .inherited = true},
  [147] =
    {field_alternative, 5, .inherited = true},
    {field_body, 5},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [151] =
    {field_body, 4},
    {field_body, 5},
  [153] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [156] =
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [159] =
    {field_alternative, 5},
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [163] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
  [167] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [171] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_type_parameters, 2},
  [175] =
    {field_body, 5},
    {field_name, 1},
    {field_superclasses, 3},
    {field_type_parameters, 2},
  [179] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_superclasses, 2},
  [183] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 4},
  [186] =
    {field_expression, 1},
    {field_format_specifier, 4},
    {field_type_conversion, 3},
  [189] =
    {field_left, 2},
    {field_right, 4},
  [191] =
    {field_left, 1},
    {field_right, 3},
    {field_right, 4},
  [194] =
    {field_alternative, 5, .inherited = true},
    {field_alternative, 6},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [199] =
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [202] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
  [206] =
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [210] =
    {field_alternative, 6},
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [214] =
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [218] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [222] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [227] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 1},
    {field_superclasses, 3},
    {field_type_parameters, 2},
  [232] =
    {field_left, 2},
    {field_right, 4},
    {field_right, 5},
  [235] =
    {field_key, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [237] =
    {field_consequence, 3},
  [238] =
    {field_alternative, 7},
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [242] =
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [246] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [250] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [255] =
    {field_alternative, 7},
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [260] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [265] =
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [270] =
    {field_key, 1, .inherited = true},
    {field_key, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [274] =
    {field_key, 0, .inherited = true},
    {field_key, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [278] =
    {field_key, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [280] =
    {field_consequence, 4},
  [281] =
    {field_consequence, 3},
    {field_consequence, 4},
  [283] =
    {field_consequence, 4},
    {field_guard, 2},
  [285] =
    {field_alternative, 8},
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [290] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [295] =
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [300] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [306] =
    {field_consequence, 4},
    {field_consequence, 5},
  [308] =
    {field_consequence, 5},
    {field_guard, 3},
  [310] =
    {field_consequence, 4},
    {field_consequence, 5},
    {field_guard, 2},
  [313] =
    {field_consequence, 5},
  [314] =
    {field_body, 8},
    {field_body, 9},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [320] =
    {field_consequence, 5},
    {field_consequence, 6},
    {field_guard, 3},
  [323] =
    {field_consequence, 5},
    {field_consequence, 6},
  [325] =
    {field_consequence, 6},
    {field_guard, 4},
  [327] =
    {field_consequence, 6},
    {field_consequence, 7},
    {field_guard, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [2] = {
    [0] = sym_list_splat,
  },
  [5] = {
    [1] = sym_identifier,
  },
  [22] = {
    [2] = alias_sym_as_pattern_target,
  },
  [33] = {
    [1] = sym_parenthesized_expression,
  },
  [37] = {
    [3] = sym_block,
  },
  [41] = {
    [3] = sym_block,
  },
  [42] = {
    [2] = sym_block,
  },
  [43] = {
    [3] = sym_block,
  },
  [44] = {
    [3] = sym_block,
  },
  [49] = {
    [0] = alias_sym_format_expression,
  },
  [53] = {
    [3] = sym_block,
  },
  [54] = {
    [3] = sym_block,
  },
  [58] = {
    [4] = sym_block,
  },
  [59] = {
    [3] = sym_block,
  },
  [63] = {
    [4] = sym_block,
  },
  [65] = {
    [4] = sym_block,
  },
  [66] = {
    [4] = sym_block,
  },
  [68] = {
    [0] = sym_identifier,
  },
  [78] = {
    [3] = sym_block,
  },
  [85] = {
    [5] = sym_block,
  },
  [86] = {
    [5] = sym_block,
  },
  [88] = {
    [2] = sym_block,
  },
  [90] = {
    [5] = sym_block,
  },
  [92] = {
    [5] = sym_block,
  },
  [99] = {
    [6] = sym_block,
  },
  [101] = {
    [6] = sym_block,
  },
  [102] = {
    [5] = sym_block,
  },
  [104] = {
    [3] = sym_block,
  },
  [105] = {
    [6] = sym_block,
  },
  [110] = {
    [3] = sym_block,
  },
  [111] = {
    [6] = sym_block,
  },
  [113] = {
    [7] = sym_block,
  },
  [117] = {
    [7] = sym_block,
  },
  [121] = {
    [4] = sym_block,
  },
  [123] = {
    [4] = sym_block,
  },
  [126] = {
    [8] = sym_block,
  },
  [127] = {
    [5] = sym_block,
  },
  [130] = {
    [5] = sym_block,
  },
  [132] = {
    [5] = sym_block,
  },
  [136] = {
    [6] = sym_block,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__simple_statements, 2,
    sym__simple_statements,
    sym_block,
  sym_parenthesized_list_splat, 2,
    sym_parenthesized_list_splat,
    sym_parenthesized_expression,
  sym_list_splat_pattern, 2,
    sym_list_splat_pattern,
    sym_list_splat,
  sym_expression, 2,
    sym_expression,
    alias_sym_as_pattern_target,
  sym_interpolation, 2,
    sym_interpolation,
    alias_sym_format_expression,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 10,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 8,
  [18] = 13,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 7,
  [25] = 3,
  [26] = 26,
  [27] = 22,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 21,
  [32] = 23,
  [33] = 33,
  [34] = 9,
  [35] = 35,
  [36] = 36,
  [37] = 16,
  [38] = 28,
  [39] = 39,
  [40] = 39,
  [41] = 41,
  [42] = 42,
  [43] = 33,
  [44] = 44,
  [45] = 44,
  [46] = 15,
  [47] = 36,
  [48] = 29,
  [49] = 42,
  [50] = 12,
  [51] = 2,
  [52] = 20,
  [53] = 53,
  [54] = 54,
  [55] = 41,
  [56] = 14,
  [57] = 19,
  [58] = 4,
  [59] = 59,
  [60] = 26,
  [61] = 6,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 63,
  [66] = 63,
  [67] = 64,
  [68] = 63,
  [69] = 63,
  [70] = 63,
  [71] = 63,
  [72] = 63,
  [73] = 73,
  [74] = 73,
  [75] = 75,
  [76] = 76,
  [77] = 75,
  [78] = 78,
  [79] = 79,
  [80] = 76,
  [81] = 79,
  [82] = 78,
  [83] = 83,
  [84] = 83,
  [85] = 85,
  [86] = 85,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 87,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 89,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 93,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 88,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 100,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 112,
  [116] = 116,
  [117] = 117,
  [118] = 103,
  [119] = 101,
  [120] = 120,
  [121] = 117,
  [122] = 107,
  [123] = 97,
  [124] = 105,
  [125] = 125,
  [126] = 114,
  [127] = 109,
  [128] = 108,
  [129] = 129,
  [130] = 96,
  [131] = 113,
  [132] = 99,
  [133] = 111,
  [134] = 91,
  [135] = 95,
  [136] = 104,
  [137] = 137,
  [138] = 138,
  [139] = 138,
  [140] = 138,
  [141] = 138,
  [142] = 137,
  [143] = 137,
  [144] = 138,
  [145] = 138,
  [146] = 137,
  [147] = 138,
  [148] = 137,
  [149] = 137,
  [150] = 137,
  [151] = 137,
  [152] = 138,
  [153] = 153,
  [154] = 154,
  [155] = 154,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 157,
  [160] = 154,
  [161] = 156,
  [162] = 156,
  [163] = 157,
  [164] = 164,
  [165] = 157,
  [166] = 166,
  [167] = 158,
  [168] = 157,
  [169] = 156,
  [170] = 154,
  [171] = 156,
  [172] = 156,
  [173] = 158,
  [174] = 164,
  [175] = 166,
  [176] = 157,
  [177] = 158,
  [178] = 178,
  [179] = 157,
  [180] = 158,
  [181] = 157,
  [182] = 164,
  [183] = 154,
  [184] = 158,
  [185] = 158,
  [186] = 158,
  [187] = 156,
  [188] = 178,
  [189] = 189,
  [190] = 190,
  [191] = 190,
  [192] = 189,
  [193] = 193,
  [194] = 193,
  [195] = 189,
  [196] = 190,
  [197] = 190,
  [198] = 198,
  [199] = 189,
  [200] = 200,
  [201] = 201,
  [202] = 193,
  [203] = 190,
  [204] = 189,
  [205] = 189,
  [206] = 189,
  [207] = 193,
  [208] = 189,
  [209] = 189,
  [210] = 193,
  [211] = 190,
  [212] = 198,
  [213] = 189,
  [214] = 193,
  [215] = 190,
  [216] = 190,
  [217] = 193,
  [218] = 189,
  [219] = 193,
  [220] = 193,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 224,
  [226] = 226,
  [227] = 224,
  [228] = 228,
  [229] = 226,
  [230] = 224,
  [231] = 226,
  [232] = 226,
  [233] = 228,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 234,
  [238] = 234,
  [239] = 239,
  [240] = 240,
  [241] = 240,
  [242] = 242,
  [243] = 235,
  [244] = 235,
  [245] = 235,
  [246] = 246,
  [247] = 247,
  [248] = 223,
  [249] = 235,
  [250] = 250,
  [251] = 251,
  [252] = 235,
  [253] = 240,
  [254] = 235,
  [255] = 255,
  [256] = 236,
  [257] = 240,
  [258] = 258,
  [259] = 242,
  [260] = 236,
  [261] = 250,
  [262] = 262,
  [263] = 263,
  [264] = 246,
  [265] = 222,
  [266] = 236,
  [267] = 267,
  [268] = 239,
  [269] = 269,
  [270] = 235,
  [271] = 234,
  [272] = 272,
  [273] = 273,
  [274] = 272,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 276,
  [279] = 279,
  [280] = 275,
  [281] = 281,
  [282] = 273,
  [283] = 276,
  [284] = 277,
  [285] = 279,
  [286] = 276,
  [287] = 273,
  [288] = 272,
  [289] = 277,
  [290] = 272,
  [291] = 273,
  [292] = 279,
  [293] = 276,
  [294] = 279,
  [295] = 277,
  [296] = 273,
  [297] = 273,
  [298] = 272,
  [299] = 272,
  [300] = 281,
  [301] = 273,
  [302] = 277,
  [303] = 276,
  [304] = 276,
  [305] = 275,
  [306] = 277,
  [307] = 281,
  [308] = 275,
  [309] = 272,
  [310] = 281,
  [311] = 273,
  [312] = 275,
  [313] = 276,
  [314] = 279,
  [315] = 277,
  [316] = 275,
  [317] = 281,
  [318] = 277,
  [319] = 275,
  [320] = 279,
  [321] = 281,
  [322] = 275,
  [323] = 281,
  [324] = 272,
  [325] = 281,
  [326] = 326,
  [327] = 326,
  [328] = 328,
  [329] = 329,
  [330] = 178,
  [331] = 331,
  [332] = 332,
  [333] = 331,
  [334] = 329,
  [335] = 335,
  [336] = 331,
  [337] = 332,
  [338] = 335,
  [339] = 339,
  [340] = 326,
  [341] = 339,
  [342] = 335,
  [343] = 332,
  [344] = 344,
  [345] = 345,
  [346] = 339,
  [347] = 329,
  [348] = 348,
  [349] = 255,
  [350] = 350,
  [351] = 351,
  [352] = 350,
  [353] = 351,
  [354] = 350,
  [355] = 351,
  [356] = 348,
  [357] = 255,
  [358] = 350,
  [359] = 351,
  [360] = 350,
  [361] = 350,
  [362] = 362,
  [363] = 350,
  [364] = 348,
  [365] = 351,
  [366] = 351,
  [367] = 351,
  [368] = 350,
  [369] = 255,
  [370] = 351,
  [371] = 371,
  [372] = 371,
  [373] = 373,
  [374] = 374,
  [375] = 374,
  [376] = 373,
  [377] = 371,
  [378] = 328,
  [379] = 374,
  [380] = 373,
  [381] = 381,
  [382] = 382,
  [383] = 344,
  [384] = 374,
  [385] = 156,
  [386] = 374,
  [387] = 373,
  [388] = 374,
  [389] = 374,
  [390] = 371,
  [391] = 371,
  [392] = 392,
  [393] = 374,
  [394] = 371,
  [395] = 373,
  [396] = 371,
  [397] = 374,
  [398] = 398,
  [399] = 374,
  [400] = 373,
  [401] = 401,
  [402] = 373,
  [403] = 371,
  [404] = 371,
  [405] = 371,
  [406] = 373,
  [407] = 373,
  [408] = 373,
  [409] = 409,
  [410] = 409,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 409,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 416,
  [420] = 344,
  [421] = 409,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 401,
  [426] = 426,
  [427] = 423,
  [428] = 156,
  [429] = 178,
  [430] = 418,
  [431] = 178,
  [432] = 415,
  [433] = 422,
  [434] = 409,
  [435] = 435,
  [436] = 409,
  [437] = 437,
  [438] = 438,
  [439] = 409,
  [440] = 418,
  [441] = 441,
  [442] = 442,
  [443] = 412,
  [444] = 328,
  [445] = 412,
  [446] = 328,
  [447] = 447,
  [448] = 409,
  [449] = 449,
  [450] = 409,
  [451] = 344,
  [452] = 409,
  [453] = 415,
  [454] = 454,
  [455] = 411,
  [456] = 456,
  [457] = 457,
  [458] = 423,
  [459] = 422,
  [460] = 178,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 461,
  [465] = 463,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 466,
  [471] = 462,
  [472] = 467,
  [473] = 473,
  [474] = 474,
  [475] = 474,
  [476] = 344,
  [477] = 468,
  [478] = 473,
  [479] = 328,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 486,
  [490] = 480,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 484,
  [498] = 483,
  [499] = 483,
  [500] = 482,
  [501] = 482,
  [502] = 493,
  [503] = 494,
  [504] = 487,
  [505] = 505,
  [506] = 506,
  [507] = 506,
  [508] = 486,
  [509] = 487,
  [510] = 483,
  [511] = 482,
  [512] = 485,
  [513] = 487,
  [514] = 514,
  [515] = 506,
  [516] = 482,
  [517] = 493,
  [518] = 506,
  [519] = 483,
  [520] = 494,
  [521] = 486,
  [522] = 506,
  [523] = 487,
  [524] = 514,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 494,
  [529] = 494,
  [530] = 485,
  [531] = 484,
  [532] = 486,
  [533] = 495,
  [534] = 485,
  [535] = 535,
  [536] = 493,
  [537] = 493,
  [538] = 506,
  [539] = 487,
  [540] = 482,
  [541] = 485,
  [542] = 483,
  [543] = 486,
  [544] = 494,
  [545] = 506,
  [546] = 493,
  [547] = 547,
  [548] = 487,
  [549] = 483,
  [550] = 547,
  [551] = 482,
  [552] = 482,
  [553] = 483,
  [554] = 486,
  [555] = 485,
  [556] = 556,
  [557] = 494,
  [558] = 506,
  [559] = 487,
  [560] = 493,
  [561] = 495,
  [562] = 480,
  [563] = 563,
  [564] = 480,
  [565] = 565,
  [566] = 485,
  [567] = 493,
  [568] = 568,
  [569] = 569,
  [570] = 568,
  [571] = 571,
  [572] = 568,
  [573] = 485,
  [574] = 568,
  [575] = 480,
  [576] = 494,
  [577] = 568,
  [578] = 481,
  [579] = 579,
  [580] = 580,
  [581] = 580,
  [582] = 582,
  [583] = 525,
  [584] = 584,
  [585] = 571,
  [586] = 556,
  [587] = 565,
  [588] = 480,
  [589] = 495,
  [590] = 563,
  [591] = 526,
  [592] = 480,
  [593] = 593,
  [594] = 514,
  [595] = 568,
  [596] = 484,
  [597] = 514,
  [598] = 593,
  [599] = 484,
  [600] = 492,
  [601] = 601,
  [602] = 602,
  [603] = 584,
  [604] = 604,
  [605] = 486,
  [606] = 480,
  [607] = 607,
  [608] = 601,
  [609] = 609,
  [610] = 610,
  [611] = 610,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 617,
  [618] = 617,
  [619] = 615,
  [620] = 616,
  [621] = 612,
  [622] = 613,
  [623] = 623,
  [624] = 624,
  [625] = 623,
  [626] = 614,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 630,
  [635] = 635,
  [636] = 632,
  [637] = 628,
  [638] = 633,
  [639] = 639,
  [640] = 640,
  [641] = 635,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 648,
  [651] = 223,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 648,
  [657] = 657,
  [658] = 658,
  [659] = 658,
  [660] = 660,
  [661] = 222,
  [662] = 658,
  [663] = 660,
  [664] = 652,
  [665] = 657,
  [666] = 666,
  [667] = 667,
  [668] = 660,
  [669] = 648,
  [670] = 660,
  [671] = 660,
  [672] = 657,
  [673] = 649,
  [674] = 674,
  [675] = 652,
  [676] = 676,
  [677] = 652,
  [678] = 666,
  [679] = 657,
  [680] = 652,
  [681] = 648,
  [682] = 667,
  [683] = 652,
  [684] = 658,
  [685] = 685,
  [686] = 685,
  [687] = 687,
  [688] = 657,
  [689] = 687,
  [690] = 674,
  [691] = 653,
  [692] = 676,
  [693] = 658,
  [694] = 654,
  [695] = 660,
  [696] = 657,
  [697] = 655,
  [698] = 648,
  [699] = 658,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 710,
  [711] = 702,
  [712] = 709,
  [713] = 708,
  [714] = 706,
  [715] = 704,
  [716] = 700,
  [717] = 703,
  [718] = 705,
  [719] = 701,
  [720] = 707,
  [721] = 710,
  [722] = 722,
  [723] = 722,
  [724] = 724,
  [725] = 724,
  [726] = 726,
  [727] = 726,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 739,
  [740] = 740,
  [741] = 741,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 747,
  [748] = 747,
  [749] = 746,
  [750] = 222,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 745,
  [755] = 729,
  [756] = 756,
  [757] = 757,
  [758] = 744,
  [759] = 759,
  [760] = 760,
  [761] = 761,
  [762] = 762,
  [763] = 763,
  [764] = 764,
  [765] = 739,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 756,
  [775] = 775,
  [776] = 760,
  [777] = 777,
  [778] = 778,
  [779] = 742,
  [780] = 780,
  [781] = 741,
  [782] = 770,
  [783] = 783,
  [784] = 762,
  [785] = 761,
  [786] = 223,
  [787] = 787,
  [788] = 757,
  [789] = 764,
  [790] = 753,
  [791] = 791,
  [792] = 751,
  [793] = 793,
  [794] = 794,
  [795] = 777,
  [796] = 773,
  [797] = 772,
  [798] = 771,
  [799] = 799,
  [800] = 800,
  [801] = 801,
  [802] = 775,
  [803] = 783,
  [804] = 767,
  [805] = 805,
  [806] = 793,
  [807] = 799,
  [808] = 743,
  [809] = 800,
  [810] = 805,
  [811] = 801,
  [812] = 812,
  [813] = 813,
  [814] = 733,
  [815] = 815,
  [816] = 816,
  [817] = 740,
  [818] = 738,
  [819] = 763,
  [820] = 812,
  [821] = 734,
  [822] = 731,
  [823] = 813,
  [824] = 752,
  [825] = 825,
  [826] = 737,
  [827] = 815,
  [828] = 735,
  [829] = 736,
  [830] = 730,
  [831] = 831,
  [832] = 832,
  [833] = 831,
  [834] = 832,
  [835] = 816,
  [836] = 825,
  [837] = 759,
  [838] = 732,
  [839] = 768,
  [840] = 778,
  [841] = 801,
  [842] = 780,
  [843] = 728,
  [844] = 844,
  [845] = 775,
  [846] = 844,
  [847] = 766,
  [848] = 787,
  [849] = 791,
  [850] = 794,
  [851] = 769,
  [852] = 852,
  [853] = 852,
  [854] = 852,
  [855] = 852,
  [856] = 852,
  [857] = 852,
  [858] = 858,
  [859] = 858,
  [860] = 860,
  [861] = 861,
  [862] = 861,
  [863] = 861,
  [864] = 861,
  [865] = 861,
  [866] = 861,
  [867] = 861,
  [868] = 861,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 869,
  [873] = 870,
  [874] = 869,
  [875] = 875,
  [876] = 870,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 875,
  [884] = 871,
  [885] = 869,
  [886] = 869,
  [887] = 869,
  [888] = 871,
  [889] = 869,
  [890] = 869,
  [891] = 891,
  [892] = 869,
  [893] = 875,
  [894] = 870,
  [895] = 869,
  [896] = 875,
  [897] = 870,
  [898] = 877,
  [899] = 878,
  [900] = 879,
  [901] = 880,
  [902] = 881,
  [903] = 882,
  [904] = 860,
  [905] = 877,
  [906] = 878,
  [907] = 879,
  [908] = 871,
  [909] = 882,
  [910] = 880,
  [911] = 881,
  [912] = 882,
  [913] = 871,
  [914] = 879,
  [915] = 881,
  [916] = 880,
  [917] = 879,
  [918] = 878,
  [919] = 878,
  [920] = 869,
  [921] = 877,
  [922] = 870,
  [923] = 875,
  [924] = 875,
  [925] = 891,
  [926] = 880,
  [927] = 871,
  [928] = 882,
  [929] = 881,
  [930] = 878,
  [931] = 881,
  [932] = 882,
  [933] = 879,
  [934] = 881,
  [935] = 880,
  [936] = 880,
  [937] = 881,
  [938] = 879,
  [939] = 878,
  [940] = 877,
  [941] = 870,
  [942] = 882,
  [943] = 875,
  [944] = 870,
  [945] = 880,
  [946] = 860,
  [947] = 891,
  [948] = 877,
  [949] = 869,
  [950] = 871,
  [951] = 891,
  [952] = 952,
  [953] = 869,
  [954] = 952,
  [955] = 877,
  [956] = 878,
  [957] = 871,
  [958] = 891,
  [959] = 879,
  [960] = 875,
  [961] = 877,
  [962] = 882,
  [963] = 860,
  [964] = 860,
  [965] = 860,
  [966] = 966,
  [967] = 967,
  [968] = 860,
  [969] = 969,
  [970] = 860,
  [971] = 971,
  [972] = 972,
  [973] = 966,
  [974] = 974,
  [975] = 975,
  [976] = 976,
  [977] = 977,
  [978] = 978,
  [979] = 860,
  [980] = 969,
  [981] = 967,
  [982] = 967,
  [983] = 966,
  [984] = 984,
  [985] = 985,
  [986] = 969,
  [987] = 987,
  [988] = 966,
  [989] = 987,
  [990] = 977,
  [991] = 860,
  [992] = 646,
  [993] = 978,
  [994] = 644,
  [995] = 966,
  [996] = 984,
  [997] = 974,
  [998] = 975,
  [999] = 627,
  [1000] = 976,
  [1001] = 985,
  [1002] = 639,
  [1003] = 967,
  [1004] = 1004,
  [1005] = 643,
  [1006] = 1006,
  [1007] = 969,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 640,
  [1011] = 966,
  [1012] = 969,
  [1013] = 985,
  [1014] = 976,
  [1015] = 975,
  [1016] = 974,
  [1017] = 984,
  [1018] = 972,
  [1019] = 977,
  [1020] = 978,
  [1021] = 647,
  [1022] = 967,
  [1023] = 860,
  [1024] = 969,
  [1025] = 967,
  [1026] = 966,
  [1027] = 1027,
  [1028] = 860,
  [1029] = 972,
  [1030] = 987,
  [1031] = 969,
  [1032] = 971,
  [1033] = 967,
  [1034] = 971,
  [1035] = 647,
  [1036] = 987,
  [1037] = 984,
  [1038] = 974,
  [1039] = 975,
  [1040] = 1009,
  [1041] = 1008,
  [1042] = 1006,
  [1043] = 976,
  [1044] = 985,
  [1045] = 645,
  [1046] = 1046,
  [1047] = 1047,
  [1048] = 642,
  [1049] = 612,
  [1050] = 1004,
  [1051] = 615,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 966,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 640,
  [1058] = 643,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 639,
  [1062] = 627,
  [1063] = 1063,
  [1064] = 1009,
  [1065] = 644,
  [1066] = 646,
  [1067] = 1008,
  [1068] = 1006,
  [1069] = 967,
  [1070] = 1070,
  [1071] = 1071,
  [1072] = 977,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 978,
  [1076] = 1027,
  [1077] = 624,
  [1078] = 1078,
  [1079] = 985,
  [1080] = 976,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 972,
  [1085] = 1085,
  [1086] = 975,
  [1087] = 974,
  [1088] = 978,
  [1089] = 984,
  [1090] = 977,
  [1091] = 972,
  [1092] = 984,
  [1093] = 974,
  [1094] = 975,
  [1095] = 971,
  [1096] = 971,
  [1097] = 1097,
  [1098] = 976,
  [1099] = 972,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 977,
  [1103] = 978,
  [1104] = 1104,
  [1105] = 1027,
  [1106] = 629,
  [1107] = 987,
  [1108] = 985,
  [1109] = 976,
  [1110] = 1100,
  [1111] = 971,
  [1112] = 975,
  [1113] = 974,
  [1114] = 984,
  [1115] = 972,
  [1116] = 977,
  [1117] = 978,
  [1118] = 1118,
  [1119] = 969,
  [1120] = 1120,
  [1121] = 987,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 985,
  [1125] = 987,
  [1126] = 971,
  [1127] = 1004,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1132,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1056,
  [1136] = 1071,
  [1137] = 1104,
  [1138] = 624,
  [1139] = 1120,
  [1140] = 1004,
  [1141] = 1097,
  [1142] = 1046,
  [1143] = 1123,
  [1144] = 615,
  [1145] = 612,
  [1146] = 640,
  [1147] = 1053,
  [1148] = 1070,
  [1149] = 1134,
  [1150] = 1006,
  [1151] = 1009,
  [1152] = 1008,
  [1153] = 1006,
  [1154] = 1008,
  [1155] = 1009,
  [1156] = 647,
  [1157] = 646,
  [1158] = 644,
  [1159] = 1132,
  [1160] = 1131,
  [1161] = 1073,
  [1162] = 1053,
  [1163] = 1074,
  [1164] = 1082,
  [1165] = 1085,
  [1166] = 1101,
  [1167] = 1081,
  [1168] = 1122,
  [1169] = 1133,
  [1170] = 1083,
  [1171] = 1130,
  [1172] = 1129,
  [1173] = 632,
  [1174] = 643,
  [1175] = 639,
  [1176] = 627,
  [1177] = 644,
  [1178] = 646,
  [1179] = 635,
  [1180] = 1047,
  [1181] = 1004,
  [1182] = 629,
  [1183] = 1118,
  [1184] = 1133,
  [1185] = 627,
  [1186] = 639,
  [1187] = 643,
  [1188] = 1004,
  [1189] = 630,
  [1190] = 971,
  [1191] = 1122,
  [1192] = 1081,
  [1193] = 642,
  [1194] = 624,
  [1195] = 987,
  [1196] = 1063,
  [1197] = 645,
  [1198] = 1006,
  [1199] = 1055,
  [1200] = 1009,
  [1201] = 1008,
  [1202] = 1004,
  [1203] = 1009,
  [1204] = 1008,
  [1205] = 1006,
  [1206] = 629,
  [1207] = 1027,
  [1208] = 1130,
  [1209] = 1071,
  [1210] = 1097,
  [1211] = 633,
  [1212] = 1118,
  [1213] = 1055,
  [1214] = 1104,
  [1215] = 1120,
  [1216] = 1056,
  [1217] = 1123,
  [1218] = 1063,
  [1219] = 1047,
  [1220] = 1100,
  [1221] = 640,
  [1222] = 1046,
  [1223] = 647,
  [1224] = 1070,
  [1225] = 1134,
  [1226] = 1060,
  [1227] = 1132,
  [1228] = 1059,
  [1229] = 978,
  [1230] = 977,
  [1231] = 972,
  [1232] = 984,
  [1233] = 1129,
  [1234] = 974,
  [1235] = 975,
  [1236] = 976,
  [1237] = 985,
  [1238] = 1027,
  [1239] = 1083,
  [1240] = 642,
  [1241] = 645,
  [1242] = 1100,
  [1243] = 629,
  [1244] = 1101,
  [1245] = 1131,
  [1246] = 1085,
  [1247] = 612,
  [1248] = 615,
  [1249] = 1082,
  [1250] = 1073,
  [1251] = 1060,
  [1252] = 1074,
  [1253] = 1027,
  [1254] = 1059,
  [1255] = 1027,
  [1256] = 1134,
  [1257] = 1101,
  [1258] = 1063,
  [1259] = 631,
  [1260] = 1132,
  [1261] = 1059,
  [1262] = 1047,
  [1263] = 1060,
  [1264] = 1118,
  [1265] = 1129,
  [1266] = 1131,
  [1267] = 629,
  [1268] = 1123,
  [1269] = 1118,
  [1270] = 1070,
  [1271] = 1083,
  [1272] = 1120,
  [1273] = 1101,
  [1274] = 1104,
  [1275] = 647,
  [1276] = 1073,
  [1277] = 1128,
  [1278] = 1078,
  [1279] = 1052,
  [1280] = 1085,
  [1281] = 1082,
  [1282] = 1074,
  [1283] = 629,
  [1284] = 1053,
  [1285] = 640,
  [1286] = 1097,
  [1287] = 643,
  [1288] = 639,
  [1289] = 627,
  [1290] = 644,
  [1291] = 646,
  [1292] = 644,
  [1293] = 1055,
  [1294] = 1053,
  [1295] = 1071,
  [1296] = 1097,
  [1297] = 646,
  [1298] = 633,
  [1299] = 642,
  [1300] = 1060,
  [1301] = 629,
  [1302] = 630,
  [1303] = 645,
  [1304] = 629,
  [1305] = 635,
  [1306] = 632,
  [1307] = 1118,
  [1308] = 627,
  [1309] = 639,
  [1310] = 643,
  [1311] = 1104,
  [1312] = 1120,
  [1313] = 1073,
  [1314] = 1123,
  [1315] = 1027,
  [1316] = 1074,
  [1317] = 629,
  [1318] = 645,
  [1319] = 642,
  [1320] = 1131,
  [1321] = 1132,
  [1322] = 1134,
  [1323] = 1070,
  [1324] = 1071,
  [1325] = 1004,
  [1326] = 1326,
  [1327] = 1046,
  [1328] = 1047,
  [1329] = 640,
  [1330] = 646,
  [1331] = 644,
  [1332] = 1047,
  [1333] = 1046,
  [1334] = 1123,
  [1335] = 627,
  [1336] = 1120,
  [1337] = 1104,
  [1338] = 639,
  [1339] = 1130,
  [1340] = 643,
  [1341] = 1059,
  [1342] = 1342,
  [1343] = 1070,
  [1344] = 640,
  [1345] = 1134,
  [1346] = 1132,
  [1347] = 1131,
  [1348] = 1082,
  [1349] = 1085,
  [1350] = 1097,
  [1351] = 1071,
  [1352] = 1101,
  [1353] = 1083,
  [1354] = 1073,
  [1355] = 1129,
  [1356] = 1053,
  [1357] = 647,
  [1358] = 1060,
  [1359] = 1059,
  [1360] = 647,
  [1361] = 1063,
  [1362] = 1056,
  [1363] = 1055,
  [1364] = 633,
  [1365] = 1074,
  [1366] = 1082,
  [1367] = 1085,
  [1368] = 629,
  [1369] = 645,
  [1370] = 642,
  [1371] = 631,
  [1372] = 630,
  [1373] = 1059,
  [1374] = 1060,
  [1375] = 1101,
  [1376] = 1083,
  [1377] = 635,
  [1378] = 632,
  [1379] = 1129,
  [1380] = 1130,
  [1381] = 1130,
  [1382] = 642,
  [1383] = 1056,
  [1384] = 645,
  [1385] = 1071,
  [1386] = 1097,
  [1387] = 1006,
  [1388] = 1104,
  [1389] = 1120,
  [1390] = 1123,
  [1391] = 1047,
  [1392] = 1008,
  [1393] = 1046,
  [1394] = 1070,
  [1395] = 1134,
  [1396] = 1009,
  [1397] = 1132,
  [1398] = 1055,
  [1399] = 1056,
  [1400] = 1063,
  [1401] = 1056,
  [1402] = 1055,
  [1403] = 633,
  [1404] = 1130,
  [1405] = 1063,
  [1406] = 1131,
  [1407] = 1129,
  [1408] = 1073,
  [1409] = 632,
  [1410] = 1083,
  [1411] = 635,
  [1412] = 1046,
  [1413] = 1118,
  [1414] = 1053,
  [1415] = 630,
  [1416] = 1085,
  [1417] = 1074,
  [1418] = 1082,
  [1419] = 1134,
  [1420] = 629,
  [1421] = 1060,
  [1422] = 1081,
  [1423] = 1122,
  [1424] = 1133,
  [1425] = 1081,
  [1426] = 631,
  [1427] = 1122,
  [1428] = 1133,
  [1429] = 1074,
  [1430] = 1082,
  [1431] = 1070,
  [1432] = 1085,
  [1433] = 1101,
  [1434] = 1083,
  [1435] = 1053,
  [1436] = 631,
  [1437] = 1073,
  [1438] = 1129,
  [1439] = 1131,
  [1440] = 1132,
  [1441] = 1059,
  [1442] = 1123,
  [1443] = 639,
  [1444] = 1047,
  [1445] = 646,
  [1446] = 644,
  [1447] = 1118,
  [1448] = 1130,
  [1449] = 627,
  [1450] = 1046,
  [1451] = 643,
  [1452] = 640,
  [1453] = 1063,
  [1454] = 1056,
  [1455] = 647,
  [1456] = 642,
  [1457] = 1071,
  [1458] = 645,
  [1459] = 1097,
  [1460] = 1104,
  [1461] = 1055,
  [1462] = 1120,
  [1463] = 1133,
  [1464] = 1122,
  [1465] = 1081,
  [1466] = 644,
  [1467] = 632,
  [1468] = 635,
  [1469] = 630,
  [1470] = 1326,
  [1471] = 1342,
  [1472] = 633,
  [1473] = 647,
  [1474] = 640,
  [1475] = 643,
  [1476] = 639,
  [1477] = 627,
  [1478] = 646,
  [1479] = 642,
  [1480] = 645,
  [1481] = 629,
  [1482] = 629,
  [1483] = 629,
  [1484] = 629,
  [1485] = 1485,
  [1486] = 1486,
  [1487] = 1487,
  [1488] = 1488,
  [1489] = 1489,
  [1490] = 1490,
  [1491] = 1491,
  [1492] = 1492,
  [1493] = 1491,
  [1494] = 1490,
  [1495] = 1495,
  [1496] = 1495,
  [1497] = 1487,
  [1498] = 1498,
  [1499] = 1498,
  [1500] = 1500,
  [1501] = 1487,
  [1502] = 1500,
  [1503] = 1492,
  [1504] = 1489,
  [1505] = 1489,
  [1506] = 1491,
  [1507] = 1495,
  [1508] = 1488,
  [1509] = 1490,
  [1510] = 1500,
  [1511] = 1498,
  [1512] = 1491,
  [1513] = 1492,
  [1514] = 1498,
  [1515] = 1500,
  [1516] = 1488,
  [1517] = 1488,
  [1518] = 1490,
  [1519] = 1495,
  [1520] = 1492,
  [1521] = 1489,
  [1522] = 1487,
  [1523] = 1523,
  [1524] = 1524,
  [1525] = 1523,
  [1526] = 1523,
  [1527] = 1527,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1529,
  [1531] = 1531,
  [1532] = 1531,
  [1533] = 1533,
  [1534] = 1529,
  [1535] = 1533,
  [1536] = 1531,
  [1537] = 1537,
  [1538] = 1528,
  [1539] = 1531,
  [1540] = 1529,
  [1541] = 1528,
  [1542] = 1533,
  [1543] = 1533,
  [1544] = 1537,
  [1545] = 1537,
  [1546] = 1528,
  [1547] = 1537,
  [1548] = 1548,
  [1549] = 1549,
  [1550] = 1550,
  [1551] = 1549,
  [1552] = 1550,
  [1553] = 1553,
  [1554] = 1554,
  [1555] = 1549,
  [1556] = 1550,
  [1557] = 1550,
  [1558] = 1549,
  [1559] = 1553,
  [1560] = 1554,
  [1561] = 1553,
  [1562] = 1554,
  [1563] = 1554,
  [1564] = 1554,
  [1565] = 1553,
  [1566] = 1553,
  [1567] = 1554,
  [1568] = 1553,
  [1569] = 1554,
  [1570] = 1554,
  [1571] = 1571,
  [1572] = 633,
  [1573] = 630,
  [1574] = 635,
  [1575] = 1326,
  [1576] = 1342,
  [1577] = 632,
  [1578] = 1578,
  [1579] = 1553,
  [1580] = 1553,
  [1581] = 642,
  [1582] = 645,
  [1583] = 1583,
  [1584] = 629,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1587,
  [1588] = 1588,
  [1589] = 635,
  [1590] = 632,
  [1591] = 1342,
  [1592] = 645,
  [1593] = 642,
  [1594] = 1594,
  [1595] = 1594,
  [1596] = 629,
  [1597] = 1587,
  [1598] = 1586,
  [1599] = 1585,
  [1600] = 1326,
  [1601] = 1342,
  [1602] = 1602,
  [1603] = 630,
  [1604] = 1594,
  [1605] = 633,
  [1606] = 1594,
  [1607] = 1326,
  [1608] = 633,
  [1609] = 632,
  [1610] = 630,
  [1611] = 1594,
  [1612] = 635,
  [1613] = 635,
  [1614] = 632,
  [1615] = 630,
  [1616] = 633,
  [1617] = 1594,
  [1618] = 1618,
  [1619] = 1594,
  [1620] = 1620,
  [1621] = 1594,
  [1622] = 1342,
  [1623] = 1326,
  [1624] = 1624,
  [1625] = 1594,
  [1626] = 1594,
  [1627] = 1588,
  [1628] = 1628,
  [1629] = 1620,
  [1630] = 1628,
  [1631] = 1628,
  [1632] = 1628,
  [1633] = 1633,
  [1634] = 1624,
  [1635] = 1635,
  [1636] = 1583,
  [1637] = 1637,
  [1638] = 1633,
  [1639] = 1635,
  [1640] = 1633,
  [1641] = 1628,
  [1642] = 1628,
  [1643] = 1618,
  [1644] = 1602,
  [1645] = 1628,
  [1646] = 1628,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1649,
  [1651] = 1651,
  [1652] = 1648,
  [1653] = 1653,
  [1654] = 1653,
  [1655] = 1655,
  [1656] = 1656,
  [1657] = 1656,
  [1658] = 1656,
  [1659] = 1659,
  [1660] = 1660,
  [1661] = 1656,
  [1662] = 1662,
  [1663] = 1656,
  [1664] = 1656,
  [1665] = 1665,
  [1666] = 1656,
  [1667] = 1667,
  [1668] = 1668,
  [1669] = 1669,
  [1670] = 1670,
  [1671] = 1656,
  [1672] = 1672,
  [1673] = 1673,
  [1674] = 1674,
  [1675] = 1674,
  [1676] = 1672,
  [1677] = 1674,
  [1678] = 1673,
  [1679] = 1673,
  [1680] = 1674,
  [1681] = 1672,
  [1682] = 1673,
  [1683] = 1674,
  [1684] = 1673,
  [1685] = 1685,
  [1686] = 1672,
  [1687] = 1687,
  [1688] = 1672,
  [1689] = 1689,
  [1690] = 1672,
  [1691] = 1689,
  [1692] = 1685,
  [1693] = 1673,
  [1694] = 1689,
  [1695] = 1685,
  [1696] = 1674,
  [1697] = 1689,
  [1698] = 1698,
  [1699] = 1672,
  [1700] = 1685,
  [1701] = 1673,
  [1702] = 1673,
  [1703] = 1685,
  [1704] = 1685,
  [1705] = 1689,
  [1706] = 1674,
  [1707] = 1685,
  [1708] = 1673,
  [1709] = 1674,
  [1710] = 1710,
  [1711] = 1689,
  [1712] = 1674,
  [1713] = 1685,
  [1714] = 1672,
  [1715] = 1689,
  [1716] = 1689,
  [1717] = 1670,
  [1718] = 1668,
  [1719] = 1669,
  [1720] = 1659,
  [1721] = 1668,
  [1722] = 1660,
  [1723] = 1659,
  [1724] = 1669,
  [1725] = 1667,
  [1726] = 1726,
  [1727] = 1662,
  [1728] = 1728,
  [1729] = 1665,
  [1730] = 1662,
  [1731] = 1731,
  [1732] = 1670,
  [1733] = 1665,
  [1734] = 1667,
  [1735] = 1655,
  [1736] = 1655,
  [1737] = 1726,
  [1738] = 1660,
  [1739] = 1667,
  [1740] = 1668,
  [1741] = 1662,
  [1742] = 1665,
  [1743] = 1670,
  [1744] = 1655,
  [1745] = 1662,
  [1746] = 1660,
  [1747] = 1665,
  [1748] = 1748,
  [1749] = 1749,
  [1750] = 1670,
  [1751] = 1669,
  [1752] = 1726,
  [1753] = 1668,
  [1754] = 1754,
  [1755] = 1660,
  [1756] = 1667,
  [1757] = 1726,
  [1758] = 1655,
  [1759] = 1670,
  [1760] = 1665,
  [1761] = 1662,
  [1762] = 1659,
  [1763] = 1660,
  [1764] = 1655,
  [1765] = 1765,
  [1766] = 1668,
  [1767] = 1659,
  [1768] = 1659,
  [1769] = 1769,
  [1770] = 1667,
  [1771] = 1669,
  [1772] = 1772,
  [1773] = 1773,
  [1774] = 1669,
  [1775] = 1775,
  [1776] = 1659,
  [1777] = 1667,
  [1778] = 1655,
  [1779] = 1779,
  [1780] = 1780,
  [1781] = 1754,
  [1782] = 1782,
  [1783] = 1660,
  [1784] = 1728,
  [1785] = 1785,
  [1786] = 1669,
  [1787] = 1769,
  [1788] = 1788,
  [1789] = 1789,
  [1790] = 1668,
  [1791] = 1660,
  [1792] = 1780,
  [1793] = 1779,
  [1794] = 1769,
  [1795] = 1769,
  [1796] = 1659,
  [1797] = 1779,
  [1798] = 1798,
  [1799] = 1668,
  [1800] = 1779,
  [1801] = 1788,
  [1802] = 1785,
  [1803] = 1788,
  [1804] = 1789,
  [1805] = 1780,
  [1806] = 1779,
  [1807] = 1807,
  [1808] = 1808,
  [1809] = 1779,
  [1810] = 1670,
  [1811] = 1811,
  [1812] = 1779,
  [1813] = 1813,
  [1814] = 1779,
  [1815] = 1655,
  [1816] = 1816,
  [1817] = 1665,
  [1818] = 1670,
  [1819] = 1665,
  [1820] = 1667,
  [1821] = 1662,
  [1822] = 1662,
  [1823] = 1789,
  [1824] = 1779,
  [1825] = 1825,
  [1826] = 1782,
  [1827] = 1827,
  [1828] = 1828,
  [1829] = 1669,
  [1830] = 1830,
  [1831] = 1831,
  [1832] = 1832,
  [1833] = 1807,
  [1834] = 1779,
  [1835] = 1835,
  [1836] = 1835,
  [1837] = 1835,
  [1838] = 1838,
  [1839] = 1839,
  [1840] = 1840,
  [1841] = 1841,
  [1842] = 1842,
  [1843] = 1748,
  [1844] = 1844,
  [1845] = 1845,
  [1846] = 1830,
  [1847] = 1728,
  [1848] = 1773,
  [1849] = 1849,
  [1850] = 1850,
  [1851] = 1851,
  [1852] = 1765,
  [1853] = 1850,
  [1854] = 1835,
  [1855] = 1841,
  [1856] = 1842,
  [1857] = 1857,
  [1858] = 1835,
  [1859] = 1859,
  [1860] = 1860,
  [1861] = 1861,
  [1862] = 1748,
  [1863] = 1863,
  [1864] = 1765,
  [1865] = 1748,
  [1866] = 1866,
  [1867] = 1835,
  [1868] = 1839,
  [1869] = 1857,
  [1870] = 1835,
  [1871] = 1851,
  [1872] = 1842,
  [1873] = 1765,
  [1874] = 1841,
  [1875] = 1728,
  [1876] = 1876,
  [1877] = 1830,
  [1878] = 1850,
  [1879] = 1839,
  [1880] = 1830,
  [1881] = 1863,
  [1882] = 1773,
  [1883] = 1835,
  [1884] = 1773,
  [1885] = 1885,
  [1886] = 1886,
  [1887] = 1887,
  [1888] = 1888,
  [1889] = 1808,
  [1890] = 1890,
  [1891] = 1891,
  [1892] = 1892,
  [1893] = 1893,
  [1894] = 1894,
  [1895] = 1895,
  [1896] = 1896,
  [1897] = 1897,
  [1898] = 1898,
  [1899] = 1899,
  [1900] = 1900,
  [1901] = 1901,
  [1902] = 1902,
  [1903] = 1903,
  [1904] = 1754,
  [1905] = 1905,
  [1906] = 1906,
  [1907] = 1907,
  [1908] = 1908,
  [1909] = 1894,
  [1910] = 1583,
  [1911] = 1902,
  [1912] = 1885,
  [1913] = 1754,
  [1914] = 1914,
  [1915] = 1901,
  [1916] = 1916,
  [1917] = 1917,
  [1918] = 1907,
  [1919] = 1919,
  [1920] = 1920,
  [1921] = 1906,
  [1922] = 1588,
  [1923] = 1923,
  [1924] = 1773,
  [1925] = 1844,
  [1926] = 1926,
  [1927] = 1927,
  [1928] = 1906,
  [1929] = 1929,
  [1930] = 1908,
  [1931] = 1931,
  [1932] = 1825,
  [1933] = 1933,
  [1934] = 1934,
  [1935] = 1825,
  [1936] = 1772,
  [1937] = 1772,
  [1938] = 1890,
  [1939] = 1939,
  [1940] = 1923,
  [1941] = 1754,
  [1942] = 1942,
  [1943] = 1943,
  [1944] = 1907,
  [1945] = 1945,
  [1946] = 1923,
  [1947] = 1886,
  [1948] = 1765,
  [1949] = 1949,
  [1950] = 1844,
  [1951] = 1898,
  [1952] = 1952,
  [1953] = 1953,
  [1954] = 1899,
  [1955] = 1897,
  [1956] = 1956,
  [1957] = 1957,
  [1958] = 1886,
  [1959] = 1927,
  [1960] = 1960,
  [1961] = 1961,
  [1962] = 1943,
  [1963] = 1888,
  [1964] = 1916,
  [1965] = 1890,
  [1966] = 1866,
  [1967] = 1892,
  [1968] = 1923,
  [1969] = 1969,
  [1970] = 1772,
  [1971] = 1971,
  [1972] = 1972,
  [1973] = 1973,
  [1974] = 1917,
  [1975] = 1825,
  [1976] = 1866,
  [1977] = 1901,
  [1978] = 1916,
  [1979] = 1979,
  [1980] = 1844,
  [1981] = 1939,
  [1982] = 1866,
  [1983] = 1983,
  [1984] = 1927,
  [1985] = 1748,
  [1986] = 1896,
  [1987] = 1939,
  [1988] = 1957,
  [1989] = 1989,
  [1990] = 1943,
  [1991] = 1902,
  [1992] = 1618,
  [1993] = 1898,
  [1994] = 1994,
  [1995] = 1960,
  [1996] = 1971,
  [1997] = 1896,
  [1998] = 1998,
  [1999] = 1897,
  [2000] = 1952,
  [2001] = 1901,
  [2002] = 1939,
  [2003] = 2003,
  [2004] = 2004,
  [2005] = 1841,
  [2006] = 1960,
  [2007] = 1825,
  [2008] = 1971,
  [2009] = 2009,
  [2010] = 2010,
  [2011] = 1899,
  [2012] = 1934,
  [2013] = 2013,
  [2014] = 2014,
  [2015] = 1994,
  [2016] = 1899,
  [2017] = 2017,
  [2018] = 2018,
  [2019] = 2019,
  [2020] = 1934,
  [2021] = 1994,
  [2022] = 1933,
  [2023] = 1890,
  [2024] = 2024,
  [2025] = 1994,
  [2026] = 1920,
  [2027] = 2027,
  [2028] = 2028,
  [2029] = 1994,
  [2030] = 1919,
  [2031] = 1892,
  [2032] = 2018,
  [2033] = 2033,
  [2034] = 2027,
  [2035] = 1903,
  [2036] = 2036,
  [2037] = 2037,
  [2038] = 2038,
  [2039] = 1933,
  [2040] = 1888,
  [2041] = 1961,
  [2042] = 2042,
  [2043] = 2043,
  [2044] = 2043,
  [2045] = 2045,
  [2046] = 2046,
  [2047] = 2010,
  [2048] = 1994,
  [2049] = 2049,
  [2050] = 2050,
  [2051] = 1920,
  [2052] = 1919,
  [2053] = 2053,
  [2054] = 1620,
  [2055] = 2055,
  [2056] = 2056,
  [2057] = 2042,
  [2058] = 2036,
  [2059] = 2059,
  [2060] = 1624,
  [2061] = 2061,
  [2062] = 2062,
  [2063] = 2063,
  [2064] = 2027,
  [2065] = 1896,
  [2066] = 2061,
  [2067] = 2067,
  [2068] = 2068,
  [2069] = 2069,
  [2070] = 2070,
  [2071] = 1994,
  [2072] = 1897,
  [2073] = 2073,
  [2074] = 2018,
  [2075] = 1994,
  [2076] = 1602,
  [2077] = 2077,
  [2078] = 2078,
  [2079] = 2079,
  [2080] = 1898,
  [2081] = 2055,
  [2082] = 2082,
  [2083] = 1933,
  [2084] = 2084,
  [2085] = 2085,
  [2086] = 2086,
  [2087] = 2042,
  [2088] = 2038,
  [2089] = 2089,
  [2090] = 1888,
  [2091] = 2091,
  [2092] = 2092,
  [2093] = 2038,
  [2094] = 1934,
  [2095] = 2070,
  [2096] = 2037,
  [2097] = 2038,
  [2098] = 1960,
  [2099] = 2099,
  [2100] = 1919,
  [2101] = 2101,
  [2102] = 1998,
  [2103] = 2103,
  [2104] = 1920,
  [2105] = 1892,
  [2106] = 1971,
  [2107] = 2107,
  [2108] = 2108,
  [2109] = 2109,
  [2110] = 2078,
  [2111] = 2103,
  [2112] = 2112,
  [2113] = 2113,
  [2114] = 2114,
  [2115] = 2115,
  [2116] = 2116,
  [2117] = 2115,
  [2118] = 2118,
  [2119] = 2119,
  [2120] = 2120,
  [2121] = 2121,
  [2122] = 2122,
  [2123] = 2123,
  [2124] = 2124,
  [2125] = 2125,
  [2126] = 2126,
  [2127] = 2127,
  [2128] = 2128,
  [2129] = 2114,
  [2130] = 2130,
  [2131] = 2131,
  [2132] = 2132,
  [2133] = 2133,
  [2134] = 2134,
  [2135] = 2135,
  [2136] = 2136,
  [2137] = 2137,
  [2138] = 2138,
  [2139] = 2139,
  [2140] = 2140,
  [2141] = 2063,
  [2142] = 2142,
  [2143] = 2132,
  [2144] = 2134,
  [2145] = 2145,
  [2146] = 2146,
  [2147] = 2147,
  [2148] = 2148,
  [2149] = 2142,
  [2150] = 2150,
  [2151] = 2151,
  [2152] = 2152,
  [2153] = 2153,
  [2154] = 2154,
  [2155] = 2155,
  [2156] = 2082,
  [2157] = 2151,
  [2158] = 2158,
  [2159] = 2150,
  [2160] = 2148,
  [2161] = 2003,
  [2162] = 2004,
  [2163] = 2059,
  [2164] = 2103,
  [2165] = 1998,
  [2166] = 2101,
  [2167] = 2099,
  [2168] = 2089,
  [2169] = 2049,
  [2170] = 2014,
  [2171] = 2109,
  [2172] = 2108,
  [2173] = 2107,
  [2174] = 2078,
  [2175] = 2077,
  [2176] = 2148,
  [2177] = 2150,
  [2178] = 2013,
  [2179] = 2073,
  [2180] = 2017,
  [2181] = 2062,
  [2182] = 2151,
  [2183] = 2056,
  [2184] = 2053,
  [2185] = 2050,
  [2186] = 2045,
  [2187] = 2019,
  [2188] = 2033,
  [2189] = 2028,
  [2190] = 2024,
  [2191] = 2019,
  [2192] = 2017,
  [2193] = 2024,
  [2194] = 2013,
  [2195] = 2028,
  [2196] = 2033,
  [2197] = 2099,
  [2198] = 2150,
  [2199] = 2101,
  [2200] = 2148,
  [2201] = 2151,
  [2202] = 2103,
  [2203] = 2050,
  [2204] = 2053,
  [2205] = 2056,
  [2206] = 2062,
  [2207] = 2073,
  [2208] = 2089,
  [2209] = 2049,
  [2210] = 2014,
  [2211] = 2109,
  [2212] = 2077,
  [2213] = 2108,
  [2214] = 2107,
  [2215] = 2077,
  [2216] = 2073,
  [2217] = 2062,
  [2218] = 2056,
  [2219] = 2053,
  [2220] = 2050,
  [2221] = 2045,
  [2222] = 2078,
  [2223] = 2107,
  [2224] = 2108,
  [2225] = 2033,
  [2226] = 2028,
  [2227] = 2024,
  [2228] = 2109,
  [2229] = 2045,
  [2230] = 2019,
  [2231] = 2017,
  [2232] = 2049,
  [2233] = 2013,
  [2234] = 2089,
  [2235] = 2014,
  [2236] = 2099,
  [2237] = 2101,
  [2238] = 1998,
  [2239] = 2239,
  [2240] = 2240,
  [2241] = 2241,
  [2242] = 2242,
  [2243] = 2243,
  [2244] = 2244,
  [2245] = 2146,
  [2246] = 2246,
  [2247] = 2247,
  [2248] = 2248,
  [2249] = 2249,
  [2250] = 2250,
  [2251] = 2251,
  [2252] = 2252,
  [2253] = 2253,
  [2254] = 2254,
  [2255] = 2242,
  [2256] = 2256,
  [2257] = 2249,
  [2258] = 2258,
  [2259] = 2258,
  [2260] = 1588,
  [2261] = 2261,
  [2262] = 2244,
  [2263] = 1952,
  [2264] = 2158,
  [2265] = 2265,
  [2266] = 2239,
  [2267] = 1583,
  [2268] = 2268,
  [2269] = 2269,
  [2270] = 2270,
  [2271] = 1961,
  [2272] = 2249,
  [2273] = 2273,
  [2274] = 2274,
  [2275] = 2247,
  [2276] = 2274,
  [2277] = 2277,
  [2278] = 2278,
  [2279] = 2279,
  [2280] = 2280,
  [2281] = 2281,
  [2282] = 2251,
  [2283] = 2278,
  [2284] = 2244,
  [2285] = 2285,
  [2286] = 2243,
  [2287] = 2152,
  [2288] = 2153,
  [2289] = 2154,
  [2290] = 2290,
  [2291] = 2253,
  [2292] = 2292,
  [2293] = 1027,
  [2294] = 2294,
  [2295] = 1961,
  [2296] = 1952,
  [2297] = 1969,
  [2298] = 1004,
  [2299] = 2299,
  [2300] = 2300,
  [2301] = 2154,
  [2302] = 2302,
  [2303] = 2153,
  [2304] = 2254,
  [2305] = 2152,
  [2306] = 2306,
  [2307] = 2307,
  [2308] = 2273,
  [2309] = 2309,
  [2310] = 2310,
  [2311] = 2309,
  [2312] = 2306,
  [2313] = 2307,
  [2314] = 2299,
  [2315] = 2153,
  [2316] = 2316,
  [2317] = 2277,
  [2318] = 2300,
  [2319] = 1961,
  [2320] = 1952,
  [2321] = 2146,
  [2322] = 2290,
  [2323] = 1972,
  [2324] = 2146,
  [2325] = 1905,
  [2326] = 1891,
  [2327] = 1887,
  [2328] = 2328,
  [2329] = 2329,
  [2330] = 1949,
  [2331] = 1956,
  [2332] = 2280,
  [2333] = 657,
  [2334] = 2243,
  [2335] = 2281,
  [2336] = 2336,
  [2337] = 2279,
  [2338] = 2338,
  [2339] = 2339,
  [2340] = 2251,
  [2341] = 2341,
  [2342] = 2342,
  [2343] = 2343,
  [2344] = 2248,
  [2345] = 2345,
  [2346] = 2241,
  [2347] = 2347,
  [2348] = 2348,
  [2349] = 2338,
  [2350] = 2244,
  [2351] = 2281,
  [2352] = 2280,
  [2353] = 2269,
  [2354] = 2258,
  [2355] = 2249,
  [2356] = 2356,
  [2357] = 2281,
  [2358] = 2280,
  [2359] = 2269,
  [2360] = 2360,
  [2361] = 2265,
  [2362] = 2239,
  [2363] = 2258,
  [2364] = 2269,
  [2365] = 2365,
  [2366] = 2135,
  [2367] = 2281,
  [2368] = 2280,
  [2369] = 2265,
  [2370] = 2239,
  [2371] = 2133,
  [2372] = 2372,
  [2373] = 2269,
  [2374] = 1929,
  [2375] = 1583,
  [2376] = 2278,
  [2377] = 658,
  [2378] = 2356,
  [2379] = 2240,
  [2380] = 2274,
  [2381] = 2274,
  [2382] = 2278,
  [2383] = 2316,
  [2384] = 2280,
  [2385] = 2281,
  [2386] = 1624,
  [2387] = 2285,
  [2388] = 2273,
  [2389] = 2124,
  [2390] = 2123,
  [2391] = 2247,
  [2392] = 652,
  [2393] = 2393,
  [2394] = 2265,
  [2395] = 2269,
  [2396] = 2396,
  [2397] = 2239,
  [2398] = 2345,
  [2399] = 2265,
  [2400] = 2300,
  [2401] = 2270,
  [2402] = 2258,
  [2403] = 2268,
  [2404] = 2249,
  [2405] = 2244,
  [2406] = 2307,
  [2407] = 2248,
  [2408] = 2309,
  [2409] = 2279,
  [2410] = 2250,
  [2411] = 2306,
  [2412] = 2412,
  [2413] = 2299,
  [2414] = 2251,
  [2415] = 2243,
  [2416] = 2112,
  [2417] = 2417,
  [2418] = 2253,
  [2419] = 2343,
  [2420] = 2290,
  [2421] = 2421,
  [2422] = 660,
  [2423] = 2423,
  [2424] = 2281,
  [2425] = 2280,
  [2426] = 2339,
  [2427] = 2278,
  [2428] = 2274,
  [2429] = 2429,
  [2430] = 2243,
  [2431] = 2269,
  [2432] = 2269,
  [2433] = 2290,
  [2434] = 2239,
  [2435] = 2435,
  [2436] = 2251,
  [2437] = 2265,
  [2438] = 2438,
  [2439] = 2258,
  [2440] = 2336,
  [2441] = 2249,
  [2442] = 2285,
  [2443] = 2274,
  [2444] = 2244,
  [2445] = 2243,
  [2446] = 2244,
  [2447] = 2278,
  [2448] = 2280,
  [2449] = 2249,
  [2450] = 2251,
  [2451] = 2281,
  [2452] = 2452,
  [2453] = 2243,
  [2454] = 2341,
  [2455] = 2329,
  [2456] = 2258,
  [2457] = 2365,
  [2458] = 2277,
  [2459] = 1583,
  [2460] = 2251,
  [2461] = 2328,
  [2462] = 2265,
  [2463] = 2239,
  [2464] = 2299,
  [2465] = 2306,
  [2466] = 2269,
  [2467] = 2281,
  [2468] = 2309,
  [2469] = 2307,
  [2470] = 2292,
  [2471] = 2274,
  [2472] = 2280,
  [2473] = 2278,
  [2474] = 2278,
  [2475] = 2280,
  [2476] = 2281,
  [2477] = 2274,
  [2478] = 2300,
  [2479] = 2479,
  [2480] = 2342,
  [2481] = 2269,
  [2482] = 648,
  [2483] = 2294,
  [2484] = 2484,
  [2485] = 2285,
  [2486] = 2302,
  [2487] = 2417,
  [2488] = 2310,
  [2489] = 2243,
  [2490] = 2239,
  [2491] = 2265,
  [2492] = 2254,
  [2493] = 2258,
  [2494] = 2251,
  [2495] = 2249,
  [2496] = 2496,
  [2497] = 2244,
  [2498] = 2498,
  [2499] = 2499,
  [2500] = 2500,
  [2501] = 2501,
  [2502] = 2502,
  [2503] = 2503,
  [2504] = 2504,
  [2505] = 2505,
  [2506] = 2506,
  [2507] = 2507,
  [2508] = 2508,
  [2509] = 2509,
  [2510] = 2510,
  [2511] = 2511,
  [2512] = 2512,
  [2513] = 2513,
  [2514] = 2514,
  [2515] = 2515,
  [2516] = 2516,
  [2517] = 2517,
  [2518] = 2518,
  [2519] = 2519,
  [2520] = 2520,
  [2521] = 648,
  [2522] = 1620,
  [2523] = 2523,
  [2524] = 2524,
  [2525] = 2396,
  [2526] = 2526,
  [2527] = 2527,
  [2528] = 2085,
  [2529] = 1624,
  [2530] = 2085,
  [2531] = 2531,
  [2532] = 1602,
  [2533] = 2533,
  [2534] = 2534,
  [2535] = 1618,
  [2536] = 2516,
  [2537] = 2518,
  [2538] = 2526,
  [2539] = 2531,
  [2540] = 2531,
  [2541] = 2527,
  [2542] = 2526,
  [2543] = 2543,
  [2544] = 658,
  [2545] = 2545,
  [2546] = 2546,
  [2547] = 2547,
  [2548] = 2548,
  [2549] = 2510,
  [2550] = 2550,
  [2551] = 2509,
  [2552] = 2547,
  [2553] = 2517,
  [2554] = 2519,
  [2555] = 660,
  [2556] = 2556,
  [2557] = 2557,
  [2558] = 2558,
  [2559] = 2393,
  [2560] = 657,
  [2561] = 2372,
  [2562] = 1618,
  [2563] = 1620,
  [2564] = 2546,
  [2565] = 2565,
  [2566] = 2516,
  [2567] = 2085,
  [2568] = 2518,
  [2569] = 2569,
  [2570] = 2519,
  [2571] = 2571,
  [2572] = 2531,
  [2573] = 2520,
  [2574] = 2574,
  [2575] = 2524,
  [2576] = 2576,
  [2577] = 2543,
  [2578] = 2578,
  [2579] = 2579,
  [2580] = 2580,
  [2581] = 2518,
  [2582] = 2582,
  [2583] = 2583,
  [2584] = 2584,
  [2585] = 2548,
  [2586] = 2586,
  [2587] = 2510,
  [2588] = 2588,
  [2589] = 2526,
  [2590] = 652,
  [2591] = 2507,
  [2592] = 2545,
  [2593] = 2593,
  [2594] = 2594,
  [2595] = 2595,
  [2596] = 1602,
  [2597] = 2516,
  [2598] = 2517,
  [2599] = 2599,
  [2600] = 2600,
  [2601] = 2601,
  [2602] = 2602,
  [2603] = 2603,
  [2604] = 2604,
  [2605] = 2605,
  [2606] = 2606,
  [2607] = 2607,
  [2608] = 2608,
  [2609] = 2609,
  [2610] = 2610,
  [2611] = 2605,
  [2612] = 2612,
  [2613] = 2613,
  [2614] = 2605,
  [2615] = 2602,
  [2616] = 2616,
  [2617] = 2617,
  [2618] = 2618,
  [2619] = 2619,
  [2620] = 2620,
  [2621] = 2600,
  [2622] = 2622,
  [2623] = 2623,
  [2624] = 2624,
  [2625] = 2625,
  [2626] = 2626,
  [2627] = 2627,
  [2628] = 2617,
  [2629] = 2603,
  [2630] = 2625,
  [2631] = 2631,
  [2632] = 2624,
  [2633] = 2626,
  [2634] = 2623,
  [2635] = 2622,
  [2636] = 2626,
  [2637] = 2637,
  [2638] = 2627,
  [2639] = 2625,
  [2640] = 2616,
  [2641] = 2624,
  [2642] = 2600,
  [2643] = 2623,
  [2644] = 2626,
  [2645] = 2616,
  [2646] = 2646,
  [2647] = 2616,
  [2648] = 2648,
  [2649] = 2622,
  [2650] = 2619,
  [2651] = 2631,
  [2652] = 2618,
  [2653] = 2600,
  [2654] = 2637,
  [2655] = 2625,
  [2656] = 2624,
  [2657] = 2600,
  [2658] = 2617,
  [2659] = 2619,
  [2660] = 2660,
  [2661] = 2618,
  [2662] = 2618,
  [2663] = 2623,
  [2664] = 2664,
  [2665] = 2617,
  [2666] = 2648,
  [2667] = 2617,
  [2668] = 2668,
  [2669] = 2669,
  [2670] = 2616,
  [2671] = 2617,
  [2672] = 2619,
  [2673] = 2673,
  [2674] = 2616,
  [2675] = 2675,
  [2676] = 2676,
  [2677] = 2677,
  [2678] = 2637,
  [2679] = 2660,
  [2680] = 2676,
  [2681] = 2602,
  [2682] = 2602,
  [2683] = 2600,
  [2684] = 2603,
  [2685] = 2664,
  [2686] = 2602,
  [2687] = 2613,
  [2688] = 2631,
  [2689] = 2610,
  [2690] = 2605,
  [2691] = 2605,
  [2692] = 2609,
  [2693] = 2622,
  [2694] = 2604,
  [2695] = 2623,
  [2696] = 2696,
  [2697] = 2626,
  [2698] = 2698,
  [2699] = 2622,
  [2700] = 2675,
  [2701] = 2701,
  [2702] = 2620,
  [2703] = 2668,
  [2704] = 2704,
  [2705] = 2620,
  [2706] = 2624,
  [2707] = 2707,
  [2708] = 2646,
  [2709] = 2625,
  [2710] = 2696,
  [2711] = 2605,
  [2712] = 2712,
  [2713] = 2603,
  [2714] = 2612,
  [2715] = 2600,
  [2716] = 2631,
  [2717] = 2601,
  [2718] = 2718,
  [2719] = 2719,
  [2720] = 2602,
  [2721] = 2613,
  [2722] = 2722,
  [2723] = 2696,
  [2724] = 2600,
  [2725] = 2646,
  [2726] = 2626,
  [2727] = 2727,
  [2728] = 2698,
  [2729] = 2620,
  [2730] = 2730,
  [2731] = 2731,
  [2732] = 2618,
  [2733] = 2733,
  [2734] = 2619,
  [2735] = 2626,
  [2736] = 2736,
  [2737] = 2618,
  [2738] = 2622,
  [2739] = 2625,
  [2740] = 2616,
  [2741] = 2637,
  [2742] = 2624,
  [2743] = 2660,
  [2744] = 2625,
  [2745] = 2624,
  [2746] = 2605,
  [2747] = 2623,
  [2748] = 2648,
  [2749] = 2673,
  [2750] = 2750,
  [2751] = 2622,
  [2752] = 2752,
  [2753] = 2631,
  [2754] = 2626,
  [2755] = 2625,
  [2756] = 2623,
  [2757] = 2602,
  [2758] = 2624,
  [2759] = 2759,
  [2760] = 2600,
  [2761] = 2761,
  [2762] = 2603,
  [2763] = 2637,
  [2764] = 2619,
  [2765] = 2648,
  [2766] = 2619,
  [2767] = 2623,
  [2768] = 2768,
  [2769] = 2618,
  [2770] = 2622,
  [2771] = 2771,
  [2772] = 2617,
  [2773] = 2600,
  [2774] = 2602,
  [2775] = 2605,
  [2776] = 2617,
  [2777] = 2777,
  [2778] = 2761,
  [2779] = 2779,
  [2780] = 2780,
  [2781] = 2781,
  [2782] = 2759,
  [2783] = 2619,
  [2784] = 2781,
  [2785] = 2752,
  [2786] = 2660,
  [2787] = 2750,
  [2788] = 2718,
  [2789] = 2701,
  [2790] = 2616,
  [2791] = 2677,
  [2792] = 2701,
  [2793] = 2618,
  [2794] = 2722,
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6},
  {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f}, {0x671, 0x6d3},
  {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f}, {0x74d, 0x7a5},
  {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824}, {0x828, 0x828},
  {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950},
  {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10},
  {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa72, 0xa74},
  {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0},
  {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95},
  {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0}, {0xc05, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61}, {0xc80, 0xc80},
  {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde}, {0xce0, 0xce1},
  {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd5f, 0xd61},
  {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30}, {0xe32, 0xe32},
  {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb2},
  {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c}, {0xf88, 0xf8c},
  {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081},
  {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd},
  {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751},
  {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x18a8}, {0x18aa, 0x18aa},
  {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54},
  {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f},
  {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa},
  {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x2102, 0x2102},
  {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25},
  {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6},
  {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029}, {0x3031, 0x3035},
  {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e},
  {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9},
  {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb},
  {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef},
  {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1},
  {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06},
  {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xd7a3},
  {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28},
  {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d},
  {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf},
  {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d},
  {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d},
  {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
  {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808},
  {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5},
  {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27},
  {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11075, 0x11075}, {0x11083, 0x110af},
  {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176}, {0x11183, 0x111b2}, {0x111c1, 0x111c4},
  {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d},
  {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333},
  {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x11461}, {0x11480, 0x114af},
  {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644}, {0x11680, 0x116aa}, {0x116b8, 0x116b8},
  {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916},
  {0x11918, 0x1192f}, {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1}, {0x119e3, 0x119e3}, {0x11a00, 0x11a00},
  {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e},
  {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68},
  {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11f02, 0x11f02}, {0x11f04, 0x11f10}, {0x11f12, 0x11f33}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399},
  {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e},
  {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a},
  {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3},
  {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb},
  {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2},
  {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514},
  {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0},
  {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8},
  {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e},
  {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, {0x1e4d0, 0x1e4eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4},
  {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32},
  {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f},
  {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62},
  {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b},
  {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0},
  {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xb7, 0xb7}, {0xba, 0xba},
  {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x300, 0x374},
  {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481},
  {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd}, {0x5bf, 0x5bf}, {0x5c1, 0x5c2},
  {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669}, {0x66e, 0x6d3}, {0x6d5, 0x6dc},
  {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5}, {0x7fa, 0x7fa}, {0x7fd, 0x7fd},
  {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1}, {0x8e3, 0x963}, {0x966, 0x96f},
  {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bc, 0x9c4},
  {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1}, {0x9fc, 0x9fc}, {0x9fe, 0x9fe},
  {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39},
  {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa66, 0xa75},
  {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabc, 0xac5},
  {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff}, {0xb01, 0xb03}, {0xb05, 0xb0c},
  {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44}, {0xb47, 0xb48}, {0xb4b, 0xb4d},
  {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90},
  {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbbe, 0xbc2},
  {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28},
  {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc63},
  {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbc, 0xcc4},
  {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef}, {0xcf1, 0xcf3}, {0xd00, 0xd0c},
  {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63}, {0xd66, 0xd6f}, {0xd7a, 0xd7f},
  {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xdca, 0xdca}, {0xdcf, 0xdd4},
  {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e}, {0xe50, 0xe59}, {0xe81, 0xe82},
  {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xec8, 0xece},
  {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35}, {0xf37, 0xf37}, {0xf39, 0xf39},
  {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6}, {0x1000, 0x1049}, {0x1050, 0x109d},
  {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258},
  {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5},
  {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371}, {0x1380, 0x138f}, {0x13a0, 0x13f5},
  {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1715}, {0x171f, 0x1734},
  {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dd}, {0x17e0, 0x17e9},
  {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b},
  {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c},
  {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c}, {0x1b50, 0x1b59}, {0x1b6b, 0x1b73},
  {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2},
  {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200c, 0x200d}, {0x203f, 0x2040}, {0x2054, 0x2054}, {0x2071, 0x2071},
  {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113},
  {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149},
  {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67},
  {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce},
  {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096},
  {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x4dbf},
  {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1}, {0xa717, 0xa71f},
  {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827}, {0xa82c, 0xa82c}, {0xa840, 0xa873},
  {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c}, {0xa980, 0xa9c0},
  {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2}, {0xaadb, 0xaadd},
  {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a},
  {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d},
  {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41},
  {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f},
  {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a}, {0xff65, 0xffbe}, {0xffc2, 0xffc7},
  {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d},
  {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102e0}, {0x10300, 0x1031f},
  {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9},
  {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595},
  {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785},
  {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855},
  {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf},
  {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a3f}, {0x10a60, 0x10a7c},
  {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48},
  {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1}, {0x10efd, 0x10f1c},
  {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075}, {0x1107f, 0x110ba},
  {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, {0x11150, 0x11173}, {0x11176, 0x11176},
  {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x11241}, {0x11280, 0x11286},
  {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c},
  {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d},
  {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, {0x11450, 0x11459}, {0x1145e, 0x11461},
  {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640}, {0x11644, 0x11644},
  {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11740, 0x11746}, {0x11800, 0x1183a},
  {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938}, {0x1193b, 0x11943},
  {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a47, 0x11a47}, {0x11a50, 0x11a99},
  {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7},
  {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, {0x11d50, 0x11d59},
  {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6}, {0x11f00, 0x11f10},
  {0x11f12, 0x11f3a}, {0x11f3e, 0x11f42}, {0x11f50, 0x11f59}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0},
  {0x13000, 0x1342f}, {0x13440, 0x13455}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe}, {0x16ac0, 0x16ac9},
  {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f},
  {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1}, {0x17000, 0x187f7}, {0x18800, 0x18cd5},
  {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155},
  {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d},
  {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1d400, 0x1d454},
  {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3},
  {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546},
  {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e},
  {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c},
  {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018},
  {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, {0x1e08f, 0x1e08f}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149},
  {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe},
  {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24},
  {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49},
  {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d},
  {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e},
  {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739},
  {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af}, {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(55);
      if (lookahead == '\r') SKIP(51);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(99);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(58);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(70);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(105);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(113);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(133);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(101);
      if (lookahead == 'e') ADVANCE(163);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(87);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(51);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(168);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(130);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(3);
      if (lookahead == '\r') ADVANCE(135);
      if (lookahead == '#') ADVANCE(136);
      if (lookahead == '\\') ADVANCE(134);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '}') ADVANCE(89);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(135);
      if (lookahead != 0) ADVANCE(136);
      END_STATE();
    case 4:
      if (lookahead == '\r') SKIP(4);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(99);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(84);
      if (lookahead == '.') ADVANCE(58);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(70);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(105);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(113);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '^') ADVANCE(101);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(87);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 5:
      if (lookahead == '\r') SKIP(5);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(94);
      if (lookahead == '&') ADVANCE(98);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(58);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(70);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(106);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(114);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(100);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(86);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(5);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 6:
      if (lookahead == '\r') SKIP(6);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(21);
      if (lookahead == '&') ADVANCE(22);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == '-') ADVANCE(84);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(18);
      if (lookahead == '=') ADVANCE(77);
      if (lookahead == '>') ADVANCE(31);
      if (lookahead == '@') ADVANCE(23);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '^') ADVANCE(24);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(25);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(6);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 7:
      if (lookahead == '\r') SKIP(7);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(99);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(84);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == ':') ADVANCE(70);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(105);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(113);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(101);
      if (lookahead == '|') ADVANCE(87);
      if (lookahead == '}') ADVANCE(89);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(7);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 8:
      if (lookahead == '\r') SKIP(8);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(99);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(84);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(105);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(113);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(101);
      if (lookahead == '|') ADVANCE(87);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(8);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 9:
      if (lookahead == '\r') SKIP(9);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '-') ADVANCE(30);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == 'e') ADVANCE(163);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(9);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 10:
      if (lookahead == '\r') ADVANCE(1);
      if ((!eof && lookahead == 00) ||
          lookahead == '\n') ADVANCE(168);
      END_STATE();
    case 11:
      if (lookahead == '\r') SKIP(11);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(99);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(84);
      if (lookahead == '.') ADVANCE(58);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(105);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(113);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '^') ADVANCE(101);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(87);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(11);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 12:
      if (lookahead == '\r') SKIP(12);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(94);
      if (lookahead == '&') ADVANCE(98);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(58);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(106);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(114);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(100);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(86);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(12);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 13:
      if (lookahead == '\r') SKIP(13);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(94);
      if (lookahead == '&') ADVANCE(98);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(106);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(114);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(100);
      if (lookahead == '|') ADVANCE(86);
      if (lookahead == '}') ADVANCE(89);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(13);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 14:
      if (lookahead == '\r') SKIP(14);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(94);
      if (lookahead == '&') ADVANCE(98);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == ':') ADVANCE(70);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(106);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(114);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(100);
      if (lookahead == '|') ADVANCE(86);
      if (lookahead == '}') ADVANCE(89);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(14);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(129);
      END_STATE();
    case 17:
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 18:
      if (lookahead == '<') ADVANCE(28);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(110);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(110);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 21:
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 22:
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 25:
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 26:
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 27:
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 28:
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 29:
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 30:
      if (lookahead == '>') ADVANCE(74);
      END_STATE();
    case 31:
      if (lookahead == '>') ADVANCE(29);
      END_STATE();
    case 32:
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(142);
      END_STATE();
    case 33:
      if (lookahead == '_') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(143);
      END_STATE();
    case 34:
      if (lookahead == '_') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(144);
      END_STATE();
    case 35:
      if (lookahead == '{') ADVANCE(50);
      END_STATE();
    case 36:
      if (lookahead == '}') ADVANCE(130);
      if (lookahead != 0) ADVANCE(36);
      END_STATE();
    case 37:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 38:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(142);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(143);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(130);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(144);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(41);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 50:
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(36);
      END_STATE();
    case 51:
      if (eof) ADVANCE(55);
      if (lookahead == '\r') SKIP(51);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(99);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(58);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(70);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(105);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(113);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '^') ADVANCE(101);
      if (lookahead == 'e') ADVANCE(163);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(87);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(51);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 52:
      if (eof) ADVANCE(55);
      if (lookahead == '\r') SKIP(52);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == ',') ADVANCE(61);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == ':') ADVANCE(69);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(107);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(112);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(80);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(86);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(52);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 53:
      if (eof) ADVANCE(55);
      if (lookahead == '\r') SKIP(53);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == 'e') ADVANCE(164);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(53);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 54:
      if (eof) ADVANCE(55);
      if (lookahead == '\r') SKIP(54);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '0') ADVANCE(139);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == '[') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '~') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(54);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(166);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(16);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(75);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(26);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(68);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_except);
      if (lookahead == '*') ADVANCE(73);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_except);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_except_STAR);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(117);
      if (lookahead == '>') ADVANCE(74);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(97);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(96);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(103);
      if (lookahead == '=') ADVANCE(108);
      if (lookahead == '>') ADVANCE(115);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(102);
      if (lookahead == '=') ADVANCE(108);
      if (lookahead == '>') ADVANCE(115);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(108);
      if (lookahead == '>') ADVANCE(115);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(111);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(67);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(66);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_AT_EQ);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_EQ);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_ellipsis);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(130);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(131);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      ADVANCE_MAP(
        0, 168,
        '\n', 130,
        '\r', 2,
        'N', 35,
        'U', 49,
        'u', 45,
        'x', 43,
        '"', 130,
        '\'', 130,
        '\\', 130,
        'a', 130,
        'b', 130,
        'f', 130,
        'n', 130,
        'r', 130,
        't', 130,
        'v', 130,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(132);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if ((!eof && lookahead == 00)) ADVANCE(136);
      if (lookahead == '\r') ADVANCE(136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(136);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      ADVANCE_MAP(
        '\r', 135,
        '#', 136,
        '\\', 134,
        '\t', 135,
        0x0b, 135,
        '\f', 135,
        ' ', 135,
        0x200b, 135,
        0x2060, 135,
        0xfeff, 135,
      );
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(136);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(136);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_type_conversion);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_integer);
      ADVANCE_MAP(
        '.', 148,
        '_', 141,
        'B', 32,
        'b', 32,
        'E', 37,
        'e', 37,
        'O', 33,
        'o', 33,
        'X', 34,
        'x', 34,
        'J', 138,
        'L', 138,
        'j', 138,
        'l', 138,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_integer);
      ADVANCE_MAP(
        '.', 148,
        '_', 141,
        'E', 37,
        'e', 37,
        'J', 138,
        'L', 138,
        'j', 138,
        'l', 138,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(138);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(142);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(42);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(144);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_float);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(148);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(149);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '*') ADVANCE(73);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(154);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(155);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(156);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(157);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(158);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(159);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(160);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(161);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(162);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(71);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(72);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(150);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(151);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(152);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(153);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_identifier);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(167);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_line_continuation);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\r') SKIP(0);
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '_') ADVANCE(4);
      if (lookahead == 'a') ADVANCE(5);
      if (lookahead == 'b') ADVANCE(6);
      if (lookahead == 'c') ADVANCE(7);
      if (lookahead == 'd') ADVANCE(8);
      if (lookahead == 'e') ADVANCE(9);
      if (lookahead == 'f') ADVANCE(10);
      if (lookahead == 'g') ADVANCE(11);
      if (lookahead == 'i') ADVANCE(12);
      if (lookahead == 'l') ADVANCE(13);
      if (lookahead == 'm') ADVANCE(14);
      if (lookahead == 'n') ADVANCE(15);
      if (lookahead == 'o') ADVANCE(16);
      if (lookahead == 'p') ADVANCE(17);
      if (lookahead == 'r') ADVANCE(18);
      if (lookahead == 't') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'a') ADVANCE(22);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 4:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '_') ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == 'n') ADVANCE(26);
      if (lookahead == 's') ADVANCE(27);
      if (lookahead == 'w') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(30);
      if (lookahead == 'l') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 9:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 10:
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(38);
      END_STATE();
    case 11:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 12:
      if (lookahead == 'f') ADVANCE(40);
      if (lookahead == 'm') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(42);
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(44);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 15:
      if (lookahead == 'o') ADVANCE(46);
      END_STATE();
    case 16:
      if (lookahead == 'r') ADVANCE(47);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 19:
      if (lookahead == 'r') ADVANCE(52);
      if (lookahead == 'y') ADVANCE(53);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(54);
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(56);
      END_STATE();
    case 22:
      if (lookahead == 'l') ADVANCE(57);
      END_STATE();
    case 23:
      if (lookahead == 'n') ADVANCE(58);
      END_STATE();
    case 24:
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 25:
      if (lookahead == 'f') ADVANCE(60);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(61);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(62);
      if (lookahead == 'y') ADVANCE(63);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 30:
      if (lookahead == 's') ADVANCE(66);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(67);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(68);
      END_STATE();
    case 33:
      if (lookahead == 'f') ADVANCE(69);
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(71);
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(73);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(76);
      END_STATE();
    case 39:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 41:
      if (lookahead == 'p') ADVANCE(78);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 44:
      if (lookahead == 'm') ADVANCE(79);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 46:
      if (lookahead == 'n') ADVANCE(81);
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 48:
      if (lookahead == 's') ADVANCE(83);
      END_STATE();
    case 49:
      if (lookahead == 'i') ADVANCE(84);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(86);
      END_STATE();
    case 52:
      if (lookahead == 'y') ADVANCE(87);
      END_STATE();
    case 53:
      if (lookahead == 'p') ADVANCE(88);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(89);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(90);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(91);
      END_STATE();
    case 57:
      if (lookahead == 's') ADVANCE(92);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(93);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 60:
      if (lookahead == 'u') ADVANCE(95);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 63:
      if (lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 64:
      if (lookahead == 'i') ADVANCE(98);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(99);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 67:
      if (lookahead == 's') ADVANCE(101);
      END_STATE();
    case 68:
      if (lookahead == 't') ADVANCE(102);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_del);
      END_STATE();
    case 71:
      if (lookahead == 'f') ADVANCE(103);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 73:
      if (lookahead == 'c') ADVANCE(105);
      END_STATE();
    case 74:
      if (lookahead == 'a') ADVANCE(106);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 76:
      if (lookahead == 'm') ADVANCE(107);
      END_STATE();
    case 77:
      if (lookahead == 'b') ADVANCE(108);
      END_STATE();
    case 78:
      if (lookahead == 'o') ADVANCE(109);
      END_STATE();
    case 79:
      if (lookahead == 'b') ADVANCE(110);
      END_STATE();
    case 80:
      if (lookahead == 'c') ADVANCE(111);
      END_STATE();
    case 81:
      if (lookahead == 'l') ADVANCE(112);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 83:
      if (lookahead == 's') ADVANCE(113);
      END_STATE();
    case 84:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 85:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 86:
      if (lookahead == 'u') ADVANCE(116);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(117);
      END_STATE();
    case 89:
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 90:
      if (lookahead == 'h') ADVANCE(119);
      END_STATE();
    case 91:
      if (lookahead == 'l') ADVANCE(120);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_none);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 95:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 96:
      if (lookahead == 'r') ADVANCE(123);
      END_STATE();
    case 97:
      if (lookahead == 'c') ADVANCE(124);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 99:
      if (lookahead == 'k') ADVANCE(126);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 101:
      if (lookahead == 's') ADVANCE(127);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(128);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_exec);
      END_STATE();
    case 106:
      if (lookahead == 'l') ADVANCE(129);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 108:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 109:
      if (lookahead == 'r') ADVANCE(131);
      END_STATE();
    case 110:
      if (lookahead == 'd') ADVANCE(132);
      END_STATE();
    case 111:
      if (lookahead == 'h') ADVANCE(133);
      END_STATE();
    case 112:
      if (lookahead == 'o') ADVANCE(134);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_pass);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(135);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(136);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(137);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(138);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 120:
      if (lookahead == 'd') ADVANCE(139);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 122:
      if (lookahead == 'u') ADVANCE(140);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(141);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 128:
      if (lookahead == 'n') ADVANCE(142);
      END_STATE();
    case 129:
      if (lookahead == 'l') ADVANCE(143);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(144);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(145);
      END_STATE();
    case 132:
      if (lookahead == 'a') ADVANCE(146);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 134:
      if (lookahead == 'c') ADVANCE(147);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_print);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_raise);
      END_STATE();
    case 137:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 140:
      if (lookahead == 'r') ADVANCE(149);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 142:
      if (lookahead == 'u') ADVANCE(150);
      END_STATE();
    case 143:
      if (lookahead == 'y') ADVANCE(151);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_lambda);
      END_STATE();
    case 147:
      if (lookahead == 'a') ADVANCE(152);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 149:
      if (lookahead == 'e') ADVANCE(153);
      END_STATE();
    case 150:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 152:
      if (lookahead == 'l') ADVANCE(155);
      END_STATE();
    case 153:
      if (lookahead == '_') ADVANCE(156);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_nonlocal);
      END_STATE();
    case 156:
      if (lookahead == '_') ADVANCE(157);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym___future__);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 52, .external_lex_state = 2},
  [2] = {.lex_state = 52, .external_lex_state = 3},
  [3] = {.lex_state = 52, .external_lex_state = 3},
  [4] = {.lex_state = 52, .external_lex_state = 3},
  [5] = {.lex_state = 52, .external_lex_state = 3},
  [6] = {.lex_state = 52, .external_lex_state = 3},
  [7] = {.lex_state = 52, .external_lex_state = 3},
  [8] = {.lex_state = 52, .external_lex_state = 3},
  [9] = {.lex_state = 52, .external_lex_state = 3},
  [10] = {.lex_state = 52, .external_lex_state = 3},
  [11] = {.lex_state = 52, .external_lex_state = 3},
  [12] = {.lex_state = 52, .external_lex_state = 3},
  [13] = {.lex_state = 52, .external_lex_state = 3},
  [14] = {.lex_state = 52, .external_lex_state = 3},
  [15] = {.lex_state = 52, .external_lex_state = 3},
  [16] = {.lex_state = 52, .external_lex_state = 3},
  [17] = {.lex_state = 52, .external_lex_state = 3},
  [18] = {.lex_state = 52, .external_lex_state = 3},
  [19] = {.lex_state = 52, .external_lex_state = 3},
  [20] = {.lex_state = 52, .external_lex_state = 3},
  [21] = {.lex_state = 52, .external_lex_state = 3},
  [22] = {.lex_state = 52, .external_lex_state = 3},
  [23] = {.lex_state = 52, .external_lex_state = 3},
  [24] = {.lex_state = 52, .external_lex_state = 3},
  [25] = {.lex_state = 52, .external_lex_state = 3},
  [26] = {.lex_state = 52, .external_lex_state = 3},
  [27] = {.lex_state = 52, .external_lex_state = 3},
  [28] = {.lex_state = 52, .external_lex_state = 3},
  [29] = {.lex_state = 52, .external_lex_state = 3},
  [30] = {.lex_state = 52, .external_lex_state = 3},
  [31] = {.lex_state = 52, .external_lex_state = 3},
  [32] = {.lex_state = 52, .external_lex_state = 3},
  [33] = {.lex_state = 52, .external_lex_state = 3},
  [34] = {.lex_state = 52, .external_lex_state = 3},
  [35] = {.lex_state = 52, .external_lex_state = 3},
  [36] = {.lex_state = 52, .external_lex_state = 3},
  [37] = {.lex_state = 52, .external_lex_state = 3},
  [38] = {.lex_state = 52, .external_lex_state = 3},
  [39] = {.lex_state = 52, .external_lex_state = 3},
  [40] = {.lex_state = 52, .external_lex_state = 3},
  [41] = {.lex_state = 52, .external_lex_state = 3},
  [42] = {.lex_state = 52, .external_lex_state = 3},
  [43] = {.lex_state = 52, .external_lex_state = 3},
  [44] = {.lex_state = 52, .external_lex_state = 3},
  [45] = {.lex_state = 52, .external_lex_state = 3},
  [46] = {.lex_state = 52, .external_lex_state = 3},
  [47] = {.lex_state = 52, .external_lex_state = 3},
  [48] = {.lex_state = 52, .external_lex_state = 3},
  [49] = {.lex_state = 52, .external_lex_state = 3},
  [50] = {.lex_state = 52, .external_lex_state = 3},
  [51] = {.lex_state = 52, .external_lex_state = 3},
  [52] = {.lex_state = 52, .external_lex_state = 3},
  [53] = {.lex_state = 52, .external_lex_state = 3},
  [54] = {.lex_state = 52, .external_lex_state = 3},
  [55] = {.lex_state = 52, .external_lex_state = 3},
  [56] = {.lex_state = 52, .external_lex_state = 3},
  [57] = {.lex_state = 52, .external_lex_state = 3},
  [58] = {.lex_state = 52, .external_lex_state = 3},
  [59] = {.lex_state = 52, .external_lex_state = 3},
  [60] = {.lex_state = 52, .external_lex_state = 3},
  [61] = {.lex_state = 52, .external_lex_state = 3},
  [62] = {.lex_state = 52, .external_lex_state = 2},
  [63] = {.lex_state = 52, .external_lex_state = 3},
  [64] = {.lex_state = 52, .external_lex_state = 3},
  [65] = {.lex_state = 52, .external_lex_state = 3},
  [66] = {.lex_state = 52, .external_lex_state = 3},
  [67] = {.lex_state = 52, .external_lex_state = 2},
  [68] = {.lex_state = 52, .external_lex_state = 3},
  [69] = {.lex_state = 52, .external_lex_state = 3},
  [70] = {.lex_state = 52, .external_lex_state = 3},
  [71] = {.lex_state = 52, .external_lex_state = 3},
  [72] = {.lex_state = 52, .external_lex_state = 3},
  [73] = {.lex_state = 4, .external_lex_state = 4},
  [74] = {.lex_state = 4, .external_lex_state = 4},
  [75] = {.lex_state = 5, .external_lex_state = 5},
  [76] = {.lex_state = 5, .external_lex_state = 5},
  [77] = {.lex_state = 5, .external_lex_state = 5},
  [78] = {.lex_state = 5, .external_lex_state = 5},
  [79] = {.lex_state = 5, .external_lex_state = 5},
  [80] = {.lex_state = 5, .external_lex_state = 5},
  [81] = {.lex_state = 5, .external_lex_state = 5},
  [82] = {.lex_state = 5, .external_lex_state = 5},
  [83] = {.lex_state = 4, .external_lex_state = 4},
  [84] = {.lex_state = 4, .external_lex_state = 4},
  [85] = {.lex_state = 4, .external_lex_state = 4},
  [86] = {.lex_state = 4, .external_lex_state = 4},
  [87] = {.lex_state = 52, .external_lex_state = 5},
  [88] = {.lex_state = 52, .external_lex_state = 5},
  [89] = {.lex_state = 52, .external_lex_state = 5},
  [90] = {.lex_state = 52, .external_lex_state = 5},
  [91] = {.lex_state = 52, .external_lex_state = 5},
  [92] = {.lex_state = 52, .external_lex_state = 5},
  [93] = {.lex_state = 52, .external_lex_state = 5},
  [94] = {.lex_state = 52, .external_lex_state = 5},
  [95] = {.lex_state = 52, .external_lex_state = 5},
  [96] = {.lex_state = 52, .external_lex_state = 5},
  [97] = {.lex_state = 52, .external_lex_state = 5},
  [98] = {.lex_state = 52, .external_lex_state = 5},
  [99] = {.lex_state = 52, .external_lex_state = 5},
  [100] = {.lex_state = 52, .external_lex_state = 5},
  [101] = {.lex_state = 52, .external_lex_state = 5},
  [102] = {.lex_state = 52, .external_lex_state = 5},
  [103] = {.lex_state = 52, .external_lex_state = 5},
  [104] = {.lex_state = 52, .external_lex_state = 5},
  [105] = {.lex_state = 52, .external_lex_state = 5},
  [106] = {.lex_state = 52, .external_lex_state = 5},
  [107] = {.lex_state = 52, .external_lex_state = 5},
  [108] = {.lex_state = 52, .external_lex_state = 5},
  [109] = {.lex_state = 52, .external_lex_state = 5},
  [110] = {.lex_state = 52, .external_lex_state = 5},
  [111] = {.lex_state = 52, .external_lex_state = 5},
  [112] = {.lex_state = 52, .external_lex_state = 5},
  [113] = {.lex_state = 52, .external_lex_state = 5},
  [114] = {.lex_state = 52, .external_lex_state = 5},
  [115] = {.lex_state = 52, .external_lex_state = 5},
  [116] = {.lex_state = 52, .external_lex_state = 5},
  [117] = {.lex_state = 52, .external_lex_state = 5},
  [118] = {.lex_state = 52, .external_lex_state = 5},
  [119] = {.lex_state = 52, .external_lex_state = 5},
  [120] = {.lex_state = 52, .external_lex_state = 5},
  [121] = {.lex_state = 52, .external_lex_state = 5},
  [122] = {.lex_state = 52, .external_lex_state = 5},
  [123] = {.lex_state = 52, .external_lex_state = 5},
  [124] = {.lex_state = 52, .external_lex_state = 5},
  [125] = {.lex_state = 52, .external_lex_state = 5},
  [126] = {.lex_state = 52, .external_lex_state = 5},
  [127] = {.lex_state = 52, .external_lex_state = 5},
  [128] = {.lex_state = 52, .external_lex_state = 5},
  [129] = {.lex_state = 52, .external_lex_state = 5},
  [130] = {.lex_state = 52, .external_lex_state = 5},
  [131] = {.lex_state = 52, .external_lex_state = 5},
  [132] = {.lex_state = 52, .external_lex_state = 5},
  [133] = {.lex_state = 52, .external_lex_state = 5},
  [134] = {.lex_state = 52, .external_lex_state = 5},
  [135] = {.lex_state = 52, .external_lex_state = 5},
  [136] = {.lex_state = 52, .external_lex_state = 5},
  [137] = {.lex_state = 52, .external_lex_state = 4},
  [138] = {.lex_state = 52, .external_lex_state = 4},
  [139] = {.lex_state = 52, .external_lex_state = 4},
  [140] = {.lex_state = 52, .external_lex_state = 4},
  [141] = {.lex_state = 52, .external_lex_state = 4},
  [142] = {.lex_state = 52, .external_lex_state = 4},
  [143] = {.lex_state = 52, .external_lex_state = 4},
  [144] = {.lex_state = 52, .external_lex_state = 4},
  [145] = {.lex_state = 52, .external_lex_state = 4},
  [146] = {.lex_state = 52, .external_lex_state = 4},
  [147] = {.lex_state = 52, .external_lex_state = 4},
  [148] = {.lex_state = 52, .external_lex_state = 4},
  [149] = {.lex_state = 52, .external_lex_state = 4},
  [150] = {.lex_state = 52, .external_lex_state = 4},
  [151] = {.lex_state = 52, .external_lex_state = 4},
  [152] = {.lex_state = 52, .external_lex_state = 4},
  [153] = {.lex_state = 52, .external_lex_state = 2},
  [154] = {.lex_state = 4, .external_lex_state = 4},
  [155] = {.lex_state = 4, .external_lex_state = 4},
  [156] = {.lex_state = 11, .external_lex_state = 4},
  [157] = {.lex_state = 5, .external_lex_state = 4},
  [158] = {.lex_state = 12, .external_lex_state = 4},
  [159] = {.lex_state = 5, .external_lex_state = 6},
  [160] = {.lex_state = 5, .external_lex_state = 6},
  [161] = {.lex_state = 12, .external_lex_state = 4},
  [162] = {.lex_state = 12, .external_lex_state = 6},
  [163] = {.lex_state = 5, .external_lex_state = 2},
  [164] = {.lex_state = 5, .external_lex_state = 6},
  [165] = {.lex_state = 5, .external_lex_state = 6},
  [166] = {.lex_state = 5, .external_lex_state = 7},
  [167] = {.lex_state = 12, .external_lex_state = 6},
  [168] = {.lex_state = 5, .external_lex_state = 7},
  [169] = {.lex_state = 12, .external_lex_state = 7},
  [170] = {.lex_state = 5, .external_lex_state = 7},
  [171] = {.lex_state = 12, .external_lex_state = 2},
  [172] = {.lex_state = 12, .external_lex_state = 8},
  [173] = {.lex_state = 12, .external_lex_state = 2},
  [174] = {.lex_state = 5, .external_lex_state = 7},
  [175] = {.lex_state = 5, .external_lex_state = 7},
  [176] = {.lex_state = 5, .external_lex_state = 8},
  [177] = {.lex_state = 12, .external_lex_state = 7},
  [178] = {.lex_state = 11, .external_lex_state = 4},
  [179] = {.lex_state = 5, .external_lex_state = 8},
  [180] = {.lex_state = 12, .external_lex_state = 6},
  [181] = {.lex_state = 5, .external_lex_state = 7},
  [182] = {.lex_state = 5, .external_lex_state = 8},
  [183] = {.lex_state = 5, .external_lex_state = 8},
  [184] = {.lex_state = 5, .external_lex_state = 7},
  [185] = {.lex_state = 5, .external_lex_state = 8},
  [186] = {.lex_state = 12, .external_lex_state = 8},
  [187] = {.lex_state = 11, .external_lex_state = 2},
  [188] = {.lex_state = 11, .external_lex_state = 2},
  [189] = {.lex_state = 52, .external_lex_state = 8},
  [190] = {.lex_state = 5, .external_lex_state = 6},
  [191] = {.lex_state = 5, .external_lex_state = 6},
  [192] = {.lex_state = 52, .external_lex_state = 8},
  [193] = {.lex_state = 52, .external_lex_state = 7},
  [194] = {.lex_state = 52, .external_lex_state = 7},
  [195] = {.lex_state = 52, .external_lex_state = 8},
  [196] = {.lex_state = 5, .external_lex_state = 6},
  [197] = {.lex_state = 5, .external_lex_state = 6},
  [198] = {.lex_state = 52, .external_lex_state = 7},
  [199] = {.lex_state = 52, .external_lex_state = 8},
  [200] = {.lex_state = 52, .external_lex_state = 2},
  [201] = {.lex_state = 52, .external_lex_state = 2},
  [202] = {.lex_state = 52, .external_lex_state = 7},
  [203] = {.lex_state = 5, .external_lex_state = 6},
  [204] = {.lex_state = 52, .external_lex_state = 8},
  [205] = {.lex_state = 52, .external_lex_state = 8},
  [206] = {.lex_state = 52, .external_lex_state = 8},
  [207] = {.lex_state = 52, .external_lex_state = 7},
  [208] = {.lex_state = 52, .external_lex_state = 8},
  [209] = {.lex_state = 52, .external_lex_state = 8},
  [210] = {.lex_state = 52, .external_lex_state = 7},
  [211] = {.lex_state = 5, .external_lex_state = 6},
  [212] = {.lex_state = 52, .external_lex_state = 7},
  [213] = {.lex_state = 52, .external_lex_state = 8},
  [214] = {.lex_state = 52, .external_lex_state = 7},
  [215] = {.lex_state = 5, .external_lex_state = 6},
  [216] = {.lex_state = 5, .external_lex_state = 6},
  [217] = {.lex_state = 52, .external_lex_state = 7},
  [218] = {.lex_state = 52, .external_lex_state = 8},
  [219] = {.lex_state = 52, .external_lex_state = 7},
  [220] = {.lex_state = 52, .external_lex_state = 7},
  [221] = {.lex_state = 52, .external_lex_state = 2},
  [222] = {.lex_state = 6, .external_lex_state = 4},
  [223] = {.lex_state = 6, .external_lex_state = 4},
  [224] = {.lex_state = 5, .external_lex_state = 8},
  [225] = {.lex_state = 5, .external_lex_state = 8},
  [226] = {.lex_state = 5, .external_lex_state = 8},
  [227] = {.lex_state = 5, .external_lex_state = 8},
  [228] = {.lex_state = 52, .external_lex_state = 2},
  [229] = {.lex_state = 5, .external_lex_state = 8},
  [230] = {.lex_state = 5, .external_lex_state = 8},
  [231] = {.lex_state = 5, .external_lex_state = 8},
  [232] = {.lex_state = 5, .external_lex_state = 8},
  [233] = {.lex_state = 52, .external_lex_state = 2},
  [234] = {.lex_state = 5, .external_lex_state = 2},
  [235] = {.lex_state = 5, .external_lex_state = 7},
  [236] = {.lex_state = 5, .external_lex_state = 2},
  [237] = {.lex_state = 5, .external_lex_state = 2},
  [238] = {.lex_state = 5, .external_lex_state = 2},
  [239] = {.lex_state = 5, .external_lex_state = 2},
  [240] = {.lex_state = 5, .external_lex_state = 2},
  [241] = {.lex_state = 5, .external_lex_state = 2},
  [242] = {.lex_state = 5, .external_lex_state = 2},
  [243] = {.lex_state = 5, .external_lex_state = 7},
  [244] = {.lex_state = 5, .external_lex_state = 7},
  [245] = {.lex_state = 5, .external_lex_state = 7},
  [246] = {.lex_state = 5, .external_lex_state = 2},
  [247] = {.lex_state = 5, .external_lex_state = 2},
  [248] = {.lex_state = 6, .external_lex_state = 2},
  [249] = {.lex_state = 5, .external_lex_state = 7},
  [250] = {.lex_state = 5, .external_lex_state = 2},
  [251] = {.lex_state = 5, .external_lex_state = 2},
  [252] = {.lex_state = 5, .external_lex_state = 7},
  [253] = {.lex_state = 5, .external_lex_state = 2},
  [254] = {.lex_state = 5, .external_lex_state = 7},
  [255] = {.lex_state = 52, .external_lex_state = 6},
  [256] = {.lex_state = 5, .external_lex_state = 2},
  [257] = {.lex_state = 5, .external_lex_state = 2},
  [258] = {.lex_state = 5, .external_lex_state = 7},
  [259] = {.lex_state = 5, .external_lex_state = 2},
  [260] = {.lex_state = 5, .external_lex_state = 2},
  [261] = {.lex_state = 5, .external_lex_state = 2},
  [262] = {.lex_state = 5, .external_lex_state = 2},
  [263] = {.lex_state = 5, .external_lex_state = 2},
  [264] = {.lex_state = 5, .external_lex_state = 2},
  [265] = {.lex_state = 6, .external_lex_state = 2},
  [266] = {.lex_state = 5, .external_lex_state = 2},
  [267] = {.lex_state = 5, .external_lex_state = 2},
  [268] = {.lex_state = 5, .external_lex_state = 2},
  [269] = {.lex_state = 52, .external_lex_state = 7},
  [270] = {.lex_state = 5, .external_lex_state = 7},
  [271] = {.lex_state = 5, .external_lex_state = 2},
  [272] = {.lex_state = 52, .external_lex_state = 7},
  [273] = {.lex_state = 52, .external_lex_state = 8},
  [274] = {.lex_state = 52, .external_lex_state = 7},
  [275] = {.lex_state = 5, .external_lex_state = 7},
  [276] = {.lex_state = 5, .external_lex_state = 7},
  [277] = {.lex_state = 5, .external_lex_state = 7},
  [278] = {.lex_state = 5, .external_lex_state = 7},
  [279] = {.lex_state = 52, .external_lex_state = 7},
  [280] = {.lex_state = 5, .external_lex_state = 7},
  [281] = {.lex_state = 5, .external_lex_state = 7},
  [282] = {.lex_state = 52, .external_lex_state = 8},
  [283] = {.lex_state = 5, .external_lex_state = 7},
  [284] = {.lex_state = 5, .external_lex_state = 7},
  [285] = {.lex_state = 52, .external_lex_state = 7},
  [286] = {.lex_state = 5, .external_lex_state = 7},
  [287] = {.lex_state = 52, .external_lex_state = 8},
  [288] = {.lex_state = 52, .external_lex_state = 7},
  [289] = {.lex_state = 5, .external_lex_state = 7},
  [290] = {.lex_state = 52, .external_lex_state = 7},
  [291] = {.lex_state = 52, .external_lex_state = 8},
  [292] = {.lex_state = 52, .external_lex_state = 7},
  [293] = {.lex_state = 5, .external_lex_state = 7},
  [294] = {.lex_state = 52, .external_lex_state = 7},
  [295] = {.lex_state = 5, .external_lex_state = 7},
  [296] = {.lex_state = 52, .external_lex_state = 8},
  [297] = {.lex_state = 52, .external_lex_state = 8},
  [298] = {.lex_state = 52, .external_lex_state = 7},
  [299] = {.lex_state = 52, .external_lex_state = 7},
  [300] = {.lex_state = 5, .external_lex_state = 7},
  [301] = {.lex_state = 52, .external_lex_state = 8},
  [302] = {.lex_state = 5, .external_lex_state = 7},
  [303] = {.lex_state = 5, .external_lex_state = 7},
  [304] = {.lex_state = 5, .external_lex_state = 7},
  [305] = {.lex_state = 5, .external_lex_state = 7},
  [306] = {.lex_state = 5, .external_lex_state = 7},
  [307] = {.lex_state = 5, .external_lex_state = 7},
  [308] = {.lex_state = 5, .external_lex_state = 7},
  [309] = {.lex_state = 52, .external_lex_state = 7},
  [310] = {.lex_state = 5, .external_lex_state = 7},
  [311] = {.lex_state = 52, .external_lex_state = 8},
  [312] = {.lex_state = 5, .external_lex_state = 7},
  [313] = {.lex_state = 5, .external_lex_state = 7},
  [314] = {.lex_state = 52, .external_lex_state = 7},
  [315] = {.lex_state = 5, .external_lex_state = 7},
  [316] = {.lex_state = 5, .external_lex_state = 7},
  [317] = {.lex_state = 5, .external_lex_state = 7},
  [318] = {.lex_state = 5, .external_lex_state = 7},
  [319] = {.lex_state = 5, .external_lex_state = 7},
  [320] = {.lex_state = 52, .external_lex_state = 7},
  [321] = {.lex_state = 5, .external_lex_state = 7},
  [322] = {.lex_state = 5, .external_lex_state = 7},
  [323] = {.lex_state = 5, .external_lex_state = 7},
  [324] = {.lex_state = 52, .external_lex_state = 7},
  [325] = {.lex_state = 5, .external_lex_state = 7},
  [326] = {.lex_state = 52, .external_lex_state = 6},
  [327] = {.lex_state = 52, .external_lex_state = 8},
  [328] = {.lex_state = 52, .external_lex_state = 6},
  [329] = {.lex_state = 52, .external_lex_state = 8},
  [330] = {.lex_state = 12, .external_lex_state = 6},
  [331] = {.lex_state = 52, .external_lex_state = 6},
  [332] = {.lex_state = 52, .external_lex_state = 6},
  [333] = {.lex_state = 52, .external_lex_state = 8},
  [334] = {.lex_state = 52, .external_lex_state = 6},
  [335] = {.lex_state = 52, .external_lex_state = 7},
  [336] = {.lex_state = 52, .external_lex_state = 7},
  [337] = {.lex_state = 52, .external_lex_state = 7},
  [338] = {.lex_state = 52, .external_lex_state = 6},
  [339] = {.lex_state = 52, .external_lex_state = 8},
  [340] = {.lex_state = 52, .external_lex_state = 7},
  [341] = {.lex_state = 52, .external_lex_state = 6},
  [342] = {.lex_state = 52, .external_lex_state = 8},
  [343] = {.lex_state = 52, .external_lex_state = 8},
  [344] = {.lex_state = 52, .external_lex_state = 6},
  [345] = {.lex_state = 5, .external_lex_state = 2},
  [346] = {.lex_state = 52, .external_lex_state = 7},
  [347] = {.lex_state = 52, .external_lex_state = 7},
  [348] = {.lex_state = 52, .external_lex_state = 2},
  [349] = {.lex_state = 52, .external_lex_state = 7},
  [350] = {.lex_state = 5, .external_lex_state = 6},
  [351] = {.lex_state = 5, .external_lex_state = 6},
  [352] = {.lex_state = 5, .external_lex_state = 6},
  [353] = {.lex_state = 5, .external_lex_state = 6},
  [354] = {.lex_state = 5, .external_lex_state = 6},
  [355] = {.lex_state = 5, .external_lex_state = 6},
  [356] = {.lex_state = 52, .external_lex_state = 2},
  [357] = {.lex_state = 52, .external_lex_state = 4},
  [358] = {.lex_state = 5, .external_lex_state = 6},
  [359] = {.lex_state = 5, .external_lex_state = 6},
  [360] = {.lex_state = 5, .external_lex_state = 6},
  [361] = {.lex_state = 5, .external_lex_state = 6},
  [362] = {.lex_state = 52, .external_lex_state = 4},
  [363] = {.lex_state = 5, .external_lex_state = 6},
  [364] = {.lex_state = 52, .external_lex_state = 2},
  [365] = {.lex_state = 5, .external_lex_state = 6},
  [366] = {.lex_state = 5, .external_lex_state = 6},
  [367] = {.lex_state = 5, .external_lex_state = 6},
  [368] = {.lex_state = 5, .external_lex_state = 6},
  [369] = {.lex_state = 52, .external_lex_state = 8},
  [370] = {.lex_state = 5, .external_lex_state = 6},
  [371] = {.lex_state = 52, .external_lex_state = 8},
  [372] = {.lex_state = 52, .external_lex_state = 8},
  [373] = {.lex_state = 52, .external_lex_state = 8},
  [374] = {.lex_state = 52, .external_lex_state = 8},
  [375] = {.lex_state = 52, .external_lex_state = 8},
  [376] = {.lex_state = 52, .external_lex_state = 8},
  [377] = {.lex_state = 52, .external_lex_state = 8},
  [378] = {.lex_state = 52, .external_lex_state = 4},
  [379] = {.lex_state = 52, .external_lex_state = 8},
  [380] = {.lex_state = 52, .external_lex_state = 8},
  [381] = {.lex_state = 52, .external_lex_state = 8},
  [382] = {.lex_state = 5, .external_lex_state = 2},
  [383] = {.lex_state = 52, .external_lex_state = 4},
  [384] = {.lex_state = 52, .external_lex_state = 8},
  [385] = {.lex_state = 12, .external_lex_state = 7},
  [386] = {.lex_state = 52, .external_lex_state = 8},
  [387] = {.lex_state = 52, .external_lex_state = 8},
  [388] = {.lex_state = 52, .external_lex_state = 8},
  [389] = {.lex_state = 52, .external_lex_state = 8},
  [390] = {.lex_state = 52, .external_lex_state = 8},
  [391] = {.lex_state = 52, .external_lex_state = 8},
  [392] = {.lex_state = 52, .external_lex_state = 4},
  [393] = {.lex_state = 52, .external_lex_state = 8},
  [394] = {.lex_state = 52, .external_lex_state = 8},
  [395] = {.lex_state = 52, .external_lex_state = 8},
  [396] = {.lex_state = 52, .external_lex_state = 8},
  [397] = {.lex_state = 52, .external_lex_state = 8},
  [398] = {.lex_state = 52, .external_lex_state = 8},
  [399] = {.lex_state = 52, .external_lex_state = 8},
  [400] = {.lex_state = 52, .external_lex_state = 8},
  [401] = {.lex_state = 12, .external_lex_state = 7},
  [402] = {.lex_state = 52, .external_lex_state = 8},
  [403] = {.lex_state = 52, .external_lex_state = 8},
  [404] = {.lex_state = 52, .external_lex_state = 8},
  [405] = {.lex_state = 52, .external_lex_state = 8},
  [406] = {.lex_state = 52, .external_lex_state = 8},
  [407] = {.lex_state = 52, .external_lex_state = 8},
  [408] = {.lex_state = 52, .external_lex_state = 8},
  [409] = {.lex_state = 52, .external_lex_state = 2},
  [410] = {.lex_state = 52, .external_lex_state = 2},
  [411] = {.lex_state = 52, .external_lex_state = 2},
  [412] = {.lex_state = 52, .external_lex_state = 2},
  [413] = {.lex_state = 52, .external_lex_state = 7},
  [414] = {.lex_state = 52, .external_lex_state = 2},
  [415] = {.lex_state = 52, .external_lex_state = 2},
  [416] = {.lex_state = 52, .external_lex_state = 2},
  [417] = {.lex_state = 52, .external_lex_state = 2},
  [418] = {.lex_state = 52, .external_lex_state = 2},
  [419] = {.lex_state = 52, .external_lex_state = 2},
  [420] = {.lex_state = 52, .external_lex_state = 7},
  [421] = {.lex_state = 52, .external_lex_state = 2},
  [422] = {.lex_state = 52, .external_lex_state = 2},
  [423] = {.lex_state = 52, .external_lex_state = 2},
  [424] = {.lex_state = 52, .external_lex_state = 4},
  [425] = {.lex_state = 12, .external_lex_state = 2},
  [426] = {.lex_state = 52, .external_lex_state = 2},
  [427] = {.lex_state = 52, .external_lex_state = 2},
  [428] = {.lex_state = 12, .external_lex_state = 2},
  [429] = {.lex_state = 5, .external_lex_state = 8},
  [430] = {.lex_state = 52, .external_lex_state = 2},
  [431] = {.lex_state = 5, .external_lex_state = 2},
  [432] = {.lex_state = 52, .external_lex_state = 2},
  [433] = {.lex_state = 52, .external_lex_state = 2},
  [434] = {.lex_state = 52, .external_lex_state = 2},
  [435] = {.lex_state = 52, .external_lex_state = 8},
  [436] = {.lex_state = 52, .external_lex_state = 2},
  [437] = {.lex_state = 52, .external_lex_state = 4},
  [438] = {.lex_state = 52, .external_lex_state = 8},
  [439] = {.lex_state = 52, .external_lex_state = 2},
  [440] = {.lex_state = 52, .external_lex_state = 2},
  [441] = {.lex_state = 52, .external_lex_state = 2},
  [442] = {.lex_state = 52, .external_lex_state = 4},
  [443] = {.lex_state = 52, .external_lex_state = 2},
  [444] = {.lex_state = 52, .external_lex_state = 7},
  [445] = {.lex_state = 52, .external_lex_state = 2},
  [446] = {.lex_state = 52, .external_lex_state = 8},
  [447] = {.lex_state = 52, .external_lex_state = 8},
  [448] = {.lex_state = 52, .external_lex_state = 2},
  [449] = {.lex_state = 52, .external_lex_state = 4},
  [450] = {.lex_state = 52, .external_lex_state = 2},
  [451] = {.lex_state = 52, .external_lex_state = 8},
  [452] = {.lex_state = 52, .external_lex_state = 2},
  [453] = {.lex_state = 52, .external_lex_state = 2},
  [454] = {.lex_state = 52, .external_lex_state = 4},
  [455] = {.lex_state = 52, .external_lex_state = 2},
  [456] = {.lex_state = 52, .external_lex_state = 7},
  [457] = {.lex_state = 52, .external_lex_state = 4},
  [458] = {.lex_state = 52, .external_lex_state = 2},
  [459] = {.lex_state = 52, .external_lex_state = 2},
  [460] = {.lex_state = 5, .external_lex_state = 7},
  [461] = {.lex_state = 7, .external_lex_state = 9},
  [462] = {.lex_state = 52, .external_lex_state = 2},
  [463] = {.lex_state = 52, .external_lex_state = 2},
  [464] = {.lex_state = 7, .external_lex_state = 9},
  [465] = {.lex_state = 52, .external_lex_state = 2},
  [466] = {.lex_state = 52, .external_lex_state = 2},
  [467] = {.lex_state = 7, .external_lex_state = 4},
  [468] = {.lex_state = 52, .external_lex_state = 2},
  [469] = {.lex_state = 52, .external_lex_state = 2},
  [470] = {.lex_state = 52, .external_lex_state = 2},
  [471] = {.lex_state = 52, .external_lex_state = 2},
  [472] = {.lex_state = 7, .external_lex_state = 4},
  [473] = {.lex_state = 52, .external_lex_state = 2},
  [474] = {.lex_state = 52, .external_lex_state = 2},
  [475] = {.lex_state = 52, .external_lex_state = 2},
  [476] = {.lex_state = 52, .external_lex_state = 2},
  [477] = {.lex_state = 52, .external_lex_state = 2},
  [478] = {.lex_state = 52, .external_lex_state = 2},
  [479] = {.lex_state = 52, .external_lex_state = 2},
  [480] = {.lex_state = 52, .external_lex_state = 2},
  [481] = {.lex_state = 52, .external_lex_state = 2},
  [482] = {.lex_state = 52, .external_lex_state = 2},
  [483] = {.lex_state = 52, .external_lex_state = 2},
  [484] = {.lex_state = 52, .external_lex_state = 2},
  [485] = {.lex_state = 52, .external_lex_state = 2},
  [486] = {.lex_state = 52, .external_lex_state = 2},
  [487] = {.lex_state = 52, .external_lex_state = 2},
  [488] = {.lex_state = 52, .external_lex_state = 2},
  [489] = {.lex_state = 52, .external_lex_state = 2},
  [490] = {.lex_state = 52, .external_lex_state = 2},
  [491] = {.lex_state = 52, .external_lex_state = 2},
  [492] = {.lex_state = 52, .external_lex_state = 2},
  [493] = {.lex_state = 52, .external_lex_state = 2},
  [494] = {.lex_state = 52, .external_lex_state = 2},
  [495] = {.lex_state = 52, .external_lex_state = 2},
  [496] = {.lex_state = 52, .external_lex_state = 2},
  [497] = {.lex_state = 52, .external_lex_state = 2},
  [498] = {.lex_state = 52, .external_lex_state = 2},
  [499] = {.lex_state = 52, .external_lex_state = 2},
  [500] = {.lex_state = 52, .external_lex_state = 2},
  [501] = {.lex_state = 52, .external_lex_state = 2},
  [502] = {.lex_state = 52, .external_lex_state = 2},
  [503] = {.lex_state = 52, .external_lex_state = 2},
  [504] = {.lex_state = 52, .external_lex_state = 2},
  [505] = {.lex_state = 52, .external_lex_state = 2},
  [506] = {.lex_state = 52, .external_lex_state = 2},
  [507] = {.lex_state = 52, .external_lex_state = 2},
  [508] = {.lex_state = 52, .external_lex_state = 2},
  [509] = {.lex_state = 52, .external_lex_state = 2},
  [510] = {.lex_state = 52, .external_lex_state = 2},
  [511] = {.lex_state = 52, .external_lex_state = 2},
  [512] = {.lex_state = 52, .external_lex_state = 2},
  [513] = {.lex_state = 52, .external_lex_state = 2},
  [514] = {.lex_state = 52, .external_lex_state = 2},
  [515] = {.lex_state = 52, .external_lex_state = 2},
  [516] = {.lex_state = 52, .external_lex_state = 2},
  [517] = {.lex_state = 52, .external_lex_state = 2},
  [518] = {.lex_state = 52, .external_lex_state = 2},
  [519] = {.lex_state = 52, .external_lex_state = 2},
  [520] = {.lex_state = 52, .external_lex_state = 2},
  [521] = {.lex_state = 52, .external_lex_state = 2},
  [522] = {.lex_state = 52, .external_lex_state = 2},
  [523] = {.lex_state = 52, .external_lex_state = 2},
  [524] = {.lex_state = 52, .external_lex_state = 2},
  [525] = {.lex_state = 53, .external_lex_state = 10},
  [526] = {.lex_state = 54, .external_lex_state = 2},
  [527] = {.lex_state = 52, .external_lex_state = 2},
  [528] = {.lex_state = 52, .external_lex_state = 2},
  [529] = {.lex_state = 52, .external_lex_state = 2},
  [530] = {.lex_state = 52, .external_lex_state = 2},
  [531] = {.lex_state = 52, .external_lex_state = 2},
  [532] = {.lex_state = 52, .external_lex_state = 2},
  [533] = {.lex_state = 52, .external_lex_state = 2},
  [534] = {.lex_state = 52, .external_lex_state = 2},
  [535] = {.lex_state = 52, .external_lex_state = 2},
  [536] = {.lex_state = 52, .external_lex_state = 2},
  [537] = {.lex_state = 52, .external_lex_state = 2},
  [538] = {.lex_state = 52, .external_lex_state = 2},
  [539] = {.lex_state = 52, .external_lex_state = 2},
  [540] = {.lex_state = 52, .external_lex_state = 2},
  [541] = {.lex_state = 52, .external_lex_state = 2},
  [542] = {.lex_state = 52, .external_lex_state = 2},
  [543] = {.lex_state = 52, .external_lex_state = 2},
  [544] = {.lex_state = 52, .external_lex_state = 2},
  [545] = {.lex_state = 52, .external_lex_state = 2},
  [546] = {.lex_state = 52, .external_lex_state = 2},
  [547] = {.lex_state = 52, .external_lex_state = 2},
  [548] = {.lex_state = 52, .external_lex_state = 2},
  [549] = {.lex_state = 52, .external_lex_state = 2},
  [550] = {.lex_state = 52, .external_lex_state = 2},
  [551] = {.lex_state = 52, .external_lex_state = 2},
  [552] = {.lex_state = 52, .external_lex_state = 2},
  [553] = {.lex_state = 52, .external_lex_state = 2},
  [554] = {.lex_state = 52, .external_lex_state = 2},
  [555] = {.lex_state = 52, .external_lex_state = 2},
  [556] = {.lex_state = 52, .external_lex_state = 2},
  [557] = {.lex_state = 52, .external_lex_state = 2},
  [558] = {.lex_state = 52, .external_lex_state = 2},
  [559] = {.lex_state = 52, .external_lex_state = 2},
  [560] = {.lex_state = 52, .external_lex_state = 2},
  [561] = {.lex_state = 52, .external_lex_state = 2},
  [562] = {.lex_state = 52, .external_lex_state = 2},
  [563] = {.lex_state = 52, .external_lex_state = 2},
  [564] = {.lex_state = 52, .external_lex_state = 2},
  [565] = {.lex_state = 53, .external_lex_state = 11},
  [566] = {.lex_state = 52, .external_lex_state = 2},
  [567] = {.lex_state = 52, .external_lex_state = 2},
  [568] = {.lex_state = 52, .external_lex_state = 2},
  [569] = {.lex_state = 52, .external_lex_state = 2},
  [570] = {.lex_state = 52, .external_lex_state = 2},
  [571] = {.lex_state = 54, .external_lex_state = 3},
  [572] = {.lex_state = 52, .external_lex_state = 2},
  [573] = {.lex_state = 52, .external_lex_state = 2},
  [574] = {.lex_state = 52, .external_lex_state = 2},
  [575] = {.lex_state = 52, .external_lex_state = 2},
  [576] = {.lex_state = 52, .external_lex_state = 2},
  [577] = {.lex_state = 52, .external_lex_state = 2},
  [578] = {.lex_state = 52, .external_lex_state = 2},
  [579] = {.lex_state = 52, .external_lex_state = 2},
  [580] = {.lex_state = 52, .external_lex_state = 2},
  [581] = {.lex_state = 52, .external_lex_state = 2},
  [582] = {.lex_state = 52, .external_lex_state = 2},
  [583] = {.lex_state = 53, .external_lex_state = 11},
  [584] = {.lex_state = 52, .external_lex_state = 2},
  [585] = {.lex_state = 54, .external_lex_state = 2},
  [586] = {.lex_state = 52, .external_lex_state = 2},
  [587] = {.lex_state = 53, .external_lex_state = 10},
  [588] = {.lex_state = 52, .external_lex_state = 2},
  [589] = {.lex_state = 52, .external_lex_state = 2},
  [590] = {.lex_state = 52, .external_lex_state = 2},
  [591] = {.lex_state = 54, .external_lex_state = 3},
  [592] = {.lex_state = 52, .external_lex_state = 2},
  [593] = {.lex_state = 52, .external_lex_state = 2},
  [594] = {.lex_state = 52, .external_lex_state = 2},
  [595] = {.lex_state = 52, .external_lex_state = 2},
  [596] = {.lex_state = 52, .external_lex_state = 2},
  [597] = {.lex_state = 52, .external_lex_state = 2},
  [598] = {.lex_state = 52, .external_lex_state = 2},
  [599] = {.lex_state = 52, .external_lex_state = 2},
  [600] = {.lex_state = 52, .external_lex_state = 2},
  [601] = {.lex_state = 52, .external_lex_state = 2},
  [602] = {.lex_state = 52, .external_lex_state = 2},
  [603] = {.lex_state = 52, .external_lex_state = 2},
  [604] = {.lex_state = 52, .external_lex_state = 2},
  [605] = {.lex_state = 52, .external_lex_state = 2},
  [606] = {.lex_state = 52, .external_lex_state = 2},
  [607] = {.lex_state = 52, .external_lex_state = 2},
  [608] = {.lex_state = 52, .external_lex_state = 2},
  [609] = {.lex_state = 7, .external_lex_state = 9},
  [610] = {.lex_state = 53, .external_lex_state = 10},
  [611] = {.lex_state = 53, .external_lex_state = 11},
  [612] = {.lex_state = 7, .external_lex_state = 9},
  [613] = {.lex_state = 52, .external_lex_state = 2},
  [614] = {.lex_state = 52, .external_lex_state = 2},
  [615] = {.lex_state = 7, .external_lex_state = 9},
  [616] = {.lex_state = 54, .external_lex_state = 2},
  [617] = {.lex_state = 52, .external_lex_state = 3},
  [618] = {.lex_state = 52, .external_lex_state = 2},
  [619] = {.lex_state = 7, .external_lex_state = 9},
  [620] = {.lex_state = 54, .external_lex_state = 3},
  [621] = {.lex_state = 7, .external_lex_state = 9},
  [622] = {.lex_state = 52, .external_lex_state = 3},
  [623] = {.lex_state = 52, .external_lex_state = 3},
  [624] = {.lex_state = 7, .external_lex_state = 9},
  [625] = {.lex_state = 52, .external_lex_state = 2},
  [626] = {.lex_state = 52, .external_lex_state = 3},
  [627] = {.lex_state = 8, .external_lex_state = 9},
  [628] = {.lex_state = 52, .external_lex_state = 2},
  [629] = {.lex_state = 8, .external_lex_state = 9},
  [630] = {.lex_state = 8, .external_lex_state = 9},
  [631] = {.lex_state = 8, .external_lex_state = 9},
  [632] = {.lex_state = 8, .external_lex_state = 9},
  [633] = {.lex_state = 8, .external_lex_state = 9},
  [634] = {.lex_state = 8, .external_lex_state = 9},
  [635] = {.lex_state = 8, .external_lex_state = 9},
  [636] = {.lex_state = 8, .external_lex_state = 9},
  [637] = {.lex_state = 52, .external_lex_state = 3},
  [638] = {.lex_state = 8, .external_lex_state = 9},
  [639] = {.lex_state = 8, .external_lex_state = 9},
  [640] = {.lex_state = 8, .external_lex_state = 9},
  [641] = {.lex_state = 8, .external_lex_state = 9},
  [642] = {.lex_state = 8, .external_lex_state = 9},
  [643] = {.lex_state = 8, .external_lex_state = 9},
  [644] = {.lex_state = 8, .external_lex_state = 9},
  [645] = {.lex_state = 8, .external_lex_state = 9},
  [646] = {.lex_state = 8, .external_lex_state = 9},
  [647] = {.lex_state = 8, .external_lex_state = 9},
  [648] = {.lex_state = 52, .external_lex_state = 2},
  [649] = {.lex_state = 53, .external_lex_state = 10},
  [650] = {.lex_state = 53, .external_lex_state = 10},
  [651] = {.lex_state = 52, .external_lex_state = 6},
  [652] = {.lex_state = 52, .external_lex_state = 3},
  [653] = {.lex_state = 53, .external_lex_state = 11},
  [654] = {.lex_state = 53, .external_lex_state = 11},
  [655] = {.lex_state = 54, .external_lex_state = 3},
  [656] = {.lex_state = 54, .external_lex_state = 2},
  [657] = {.lex_state = 53, .external_lex_state = 10},
  [658] = {.lex_state = 54, .external_lex_state = 2},
  [659] = {.lex_state = 54, .external_lex_state = 3},
  [660] = {.lex_state = 54, .external_lex_state = 2},
  [661] = {.lex_state = 52, .external_lex_state = 6},
  [662] = {.lex_state = 52, .external_lex_state = 3},
  [663] = {.lex_state = 54, .external_lex_state = 3},
  [664] = {.lex_state = 53, .external_lex_state = 11},
  [665] = {.lex_state = 54, .external_lex_state = 3},
  [666] = {.lex_state = 54, .external_lex_state = 2},
  [667] = {.lex_state = 53, .external_lex_state = 10},
  [668] = {.lex_state = 52, .external_lex_state = 2},
  [669] = {.lex_state = 54, .external_lex_state = 3},
  [670] = {.lex_state = 52, .external_lex_state = 3},
  [671] = {.lex_state = 53, .external_lex_state = 10},
  [672] = {.lex_state = 52, .external_lex_state = 3},
  [673] = {.lex_state = 53, .external_lex_state = 11},
  [674] = {.lex_state = 54, .external_lex_state = 2},
  [675] = {.lex_state = 54, .external_lex_state = 3},
  [676] = {.lex_state = 53, .external_lex_state = 10},
  [677] = {.lex_state = 53, .external_lex_state = 10},
  [678] = {.lex_state = 54, .external_lex_state = 3},
  [679] = {.lex_state = 54, .external_lex_state = 2},
  [680] = {.lex_state = 54, .external_lex_state = 2},
  [681] = {.lex_state = 52, .external_lex_state = 3},
  [682] = {.lex_state = 53, .external_lex_state = 11},
  [683] = {.lex_state = 52, .external_lex_state = 2},
  [684] = {.lex_state = 53, .external_lex_state = 11},
  [685] = {.lex_state = 53, .external_lex_state = 10},
  [686] = {.lex_state = 53, .external_lex_state = 11},
  [687] = {.lex_state = 54, .external_lex_state = 2},
  [688] = {.lex_state = 52, .external_lex_state = 2},
  [689] = {.lex_state = 54, .external_lex_state = 3},
  [690] = {.lex_state = 54, .external_lex_state = 3},
  [691] = {.lex_state = 53, .external_lex_state = 10},
  [692] = {.lex_state = 53, .external_lex_state = 11},
  [693] = {.lex_state = 52, .external_lex_state = 2},
  [694] = {.lex_state = 53, .external_lex_state = 10},
  [695] = {.lex_state = 53, .external_lex_state = 11},
  [696] = {.lex_state = 53, .external_lex_state = 11},
  [697] = {.lex_state = 54, .external_lex_state = 2},
  [698] = {.lex_state = 53, .external_lex_state = 11},
  [699] = {.lex_state = 53, .external_lex_state = 10},
  [700] = {.lex_state = 52, .external_lex_state = 2},
  [701] = {.lex_state = 52, .external_lex_state = 3},
  [702] = {.lex_state = 52, .external_lex_state = 2},
  [703] = {.lex_state = 52, .external_lex_state = 3},
  [704] = {.lex_state = 52, .external_lex_state = 2},
  [705] = {.lex_state = 52, .external_lex_state = 2},
  [706] = {.lex_state = 52, .external_lex_state = 2},
  [707] = {.lex_state = 52, .external_lex_state = 2},
  [708] = {.lex_state = 52, .external_lex_state = 3},
  [709] = {.lex_state = 52, .external_lex_state = 2},
  [710] = {.lex_state = 52, .external_lex_state = 2},
  [711] = {.lex_state = 52, .external_lex_state = 3},
  [712] = {.lex_state = 52, .external_lex_state = 3},
  [713] = {.lex_state = 52, .external_lex_state = 2},
  [714] = {.lex_state = 52, .external_lex_state = 3},
  [715] = {.lex_state = 52, .external_lex_state = 3},
  [716] = {.lex_state = 52, .external_lex_state = 3},
  [717] = {.lex_state = 52, .external_lex_state = 2},
  [718] = {.lex_state = 52, .external_lex_state = 3},
  [719] = {.lex_state = 52, .external_lex_state = 2},
  [720] = {.lex_state = 52, .external_lex_state = 3},
  [721] = {.lex_state = 52, .external_lex_state = 3},
  [722] = {.lex_state = 52, .external_lex_state = 3},
  [723] = {.lex_state = 52, .external_lex_state = 2},
  [724] = {.lex_state = 52, .external_lex_state = 3},
  [725] = {.lex_state = 52, .external_lex_state = 2},
  [726] = {.lex_state = 52, .external_lex_state = 7},
  [727] = {.lex_state = 52, .external_lex_state = 7},
  [728] = {.lex_state = 52, .external_lex_state = 2},
  [729] = {.lex_state = 52, .external_lex_state = 3},
  [730] = {.lex_state = 52, .external_lex_state = 3},
  [731] = {.lex_state = 52, .external_lex_state = 3},
  [732] = {.lex_state = 52, .external_lex_state = 3},
  [733] = {.lex_state = 52, .external_lex_state = 2},
  [734] = {.lex_state = 52, .external_lex_state = 2},
  [735] = {.lex_state = 52, .external_lex_state = 3},
  [736] = {.lex_state = 52, .external_lex_state = 3},
  [737] = {.lex_state = 52, .external_lex_state = 3},
  [738] = {.lex_state = 52, .external_lex_state = 3},
  [739] = {.lex_state = 52, .external_lex_state = 8},
  [740] = {.lex_state = 52, .external_lex_state = 3},
  [741] = {.lex_state = 52, .external_lex_state = 2},
  [742] = {.lex_state = 52, .external_lex_state = 2},
  [743] = {.lex_state = 52, .external_lex_state = 3},
  [744] = {.lex_state = 52, .external_lex_state = 2},
  [745] = {.lex_state = 52, .external_lex_state = 2},
  [746] = {.lex_state = 52, .external_lex_state = 3},
  [747] = {.lex_state = 52, .external_lex_state = 3},
  [748] = {.lex_state = 52, .external_lex_state = 2},
  [749] = {.lex_state = 52, .external_lex_state = 2},
  [750] = {.lex_state = 52, .external_lex_state = 2},
  [751] = {.lex_state = 52, .external_lex_state = 2},
  [752] = {.lex_state = 52, .external_lex_state = 2},
  [753] = {.lex_state = 52, .external_lex_state = 2},
  [754] = {.lex_state = 52, .external_lex_state = 3},
  [755] = {.lex_state = 52, .external_lex_state = 2},
  [756] = {.lex_state = 52, .external_lex_state = 2},
  [757] = {.lex_state = 52, .external_lex_state = 2},
  [758] = {.lex_state = 52, .external_lex_state = 3},
  [759] = {.lex_state = 52, .external_lex_state = 2},
  [760] = {.lex_state = 52, .external_lex_state = 2},
  [761] = {.lex_state = 52, .external_lex_state = 2},
  [762] = {.lex_state = 52, .external_lex_state = 2},
  [763] = {.lex_state = 52, .external_lex_state = 3},
  [764] = {.lex_state = 52, .external_lex_state = 2},
  [765] = {.lex_state = 52, .external_lex_state = 7},
  [766] = {.lex_state = 52, .external_lex_state = 7},
  [767] = {.lex_state = 52, .external_lex_state = 3},
  [768] = {.lex_state = 52, .external_lex_state = 2},
  [769] = {.lex_state = 52, .external_lex_state = 2},
  [770] = {.lex_state = 52, .external_lex_state = 2},
  [771] = {.lex_state = 52, .external_lex_state = 3},
  [772] = {.lex_state = 52, .external_lex_state = 3},
  [773] = {.lex_state = 52, .external_lex_state = 3},
  [774] = {.lex_state = 52, .external_lex_state = 3},
  [775] = {.lex_state = 52, .external_lex_state = 2},
  [776] = {.lex_state = 52, .external_lex_state = 3},
  [777] = {.lex_state = 52, .external_lex_state = 2},
  [778] = {.lex_state = 52, .external_lex_state = 2},
  [779] = {.lex_state = 52, .external_lex_state = 3},
  [780] = {.lex_state = 52, .external_lex_state = 2},
  [781] = {.lex_state = 52, .external_lex_state = 3},
  [782] = {.lex_state = 52, .external_lex_state = 3},
  [783] = {.lex_state = 52, .external_lex_state = 2},
  [784] = {.lex_state = 52, .external_lex_state = 3},
  [785] = {.lex_state = 52, .external_lex_state = 3},
  [786] = {.lex_state = 52, .external_lex_state = 2},
  [787] = {.lex_state = 52, .external_lex_state = 2},
  [788] = {.lex_state = 52, .external_lex_state = 3},
  [789] = {.lex_state = 52, .external_lex_state = 3},
  [790] = {.lex_state = 52, .external_lex_state = 3},
  [791] = {.lex_state = 52, .external_lex_state = 2},
  [792] = {.lex_state = 52, .external_lex_state = 3},
  [793] = {.lex_state = 52, .external_lex_state = 2},
  [794] = {.lex_state = 52, .external_lex_state = 2},
  [795] = {.lex_state = 52, .external_lex_state = 3},
  [796] = {.lex_state = 52, .external_lex_state = 2},
  [797] = {.lex_state = 52, .external_lex_state = 2},
  [798] = {.lex_state = 52, .external_lex_state = 2},
  [799] = {.lex_state = 52, .external_lex_state = 2},
  [800] = {.lex_state = 52, .external_lex_state = 2},
  [801] = {.lex_state = 52, .external_lex_state = 2},
  [802] = {.lex_state = 52, .external_lex_state = 2},
  [803] = {.lex_state = 52, .external_lex_state = 3},
  [804] = {.lex_state = 52, .external_lex_state = 2},
  [805] = {.lex_state = 52, .external_lex_state = 3},
  [806] = {.lex_state = 52, .external_lex_state = 3},
  [807] = {.lex_state = 52, .external_lex_state = 3},
  [808] = {.lex_state = 52, .external_lex_state = 2},
  [809] = {.lex_state = 52, .external_lex_state = 3},
  [810] = {.lex_state = 52, .external_lex_state = 2},
  [811] = {.lex_state = 52, .external_lex_state = 2},
  [812] = {.lex_state = 52, .external_lex_state = 3},
  [813] = {.lex_state = 52, .external_lex_state = 3},
  [814] = {.lex_state = 52, .external_lex_state = 3},
  [815] = {.lex_state = 52, .external_lex_state = 3},
  [816] = {.lex_state = 52, .external_lex_state = 3},
  [817] = {.lex_state = 52, .external_lex_state = 2},
  [818] = {.lex_state = 52, .external_lex_state = 2},
  [819] = {.lex_state = 52, .external_lex_state = 2},
  [820] = {.lex_state = 52, .external_lex_state = 2},
  [821] = {.lex_state = 52, .external_lex_state = 3},
  [822] = {.lex_state = 52, .external_lex_state = 2},
  [823] = {.lex_state = 52, .external_lex_state = 2},
  [824] = {.lex_state = 52, .external_lex_state = 3},
  [825] = {.lex_state = 52, .external_lex_state = 3},
  [826] = {.lex_state = 52, .external_lex_state = 2},
  [827] = {.lex_state = 52, .external_lex_state = 2},
  [828] = {.lex_state = 52, .external_lex_state = 2},
  [829] = {.lex_state = 52, .external_lex_state = 2},
  [830] = {.lex_state = 52, .external_lex_state = 2},
  [831] = {.lex_state = 52, .external_lex_state = 2},
  [832] = {.lex_state = 52, .external_lex_state = 3},
  [833] = {.lex_state = 52, .external_lex_state = 3},
  [834] = {.lex_state = 52, .external_lex_state = 2},
  [835] = {.lex_state = 52, .external_lex_state = 2},
  [836] = {.lex_state = 52, .external_lex_state = 2},
  [837] = {.lex_state = 52, .external_lex_state = 3},
  [838] = {.lex_state = 52, .external_lex_state = 2},
  [839] = {.lex_state = 52, .external_lex_state = 3},
  [840] = {.lex_state = 52, .external_lex_state = 3},
  [841] = {.lex_state = 52, .external_lex_state = 2},
  [842] = {.lex_state = 52, .external_lex_state = 3},
  [843] = {.lex_state = 52, .external_lex_state = 3},
  [844] = {.lex_state = 52, .external_lex_state = 2},
  [845] = {.lex_state = 52, .external_lex_state = 2},
  [846] = {.lex_state = 52, .external_lex_state = 2},
  [847] = {.lex_state = 52, .external_lex_state = 8},
  [848] = {.lex_state = 52, .external_lex_state = 3},
  [849] = {.lex_state = 52, .external_lex_state = 3},
  [850] = {.lex_state = 52, .external_lex_state = 3},
  [851] = {.lex_state = 52, .external_lex_state = 2},
  [852] = {.lex_state = 52, .external_lex_state = 2},
  [853] = {.lex_state = 52, .external_lex_state = 2},
  [854] = {.lex_state = 52, .external_lex_state = 2},
  [855] = {.lex_state = 52, .external_lex_state = 2},
  [856] = {.lex_state = 52, .external_lex_state = 2},
  [857] = {.lex_state = 52, .external_lex_state = 2},
  [858] = {.lex_state = 52, .external_lex_state = 2},
  [859] = {.lex_state = 52, .external_lex_state = 7},
  [860] = {.lex_state = 13, .external_lex_state = 9},
  [861] = {.lex_state = 52, .external_lex_state = 2},
  [862] = {.lex_state = 52, .external_lex_state = 2},
  [863] = {.lex_state = 52, .external_lex_state = 2},
  [864] = {.lex_state = 52, .external_lex_state = 2},
  [865] = {.lex_state = 52, .external_lex_state = 2},
  [866] = {.lex_state = 52, .external_lex_state = 2},
  [867] = {.lex_state = 52, .external_lex_state = 2},
  [868] = {.lex_state = 52, .external_lex_state = 2},
  [869] = {.lex_state = 52, .external_lex_state = 2},
  [870] = {.lex_state = 52, .external_lex_state = 2},
  [871] = {.lex_state = 52, .external_lex_state = 2},
  [872] = {.lex_state = 52, .external_lex_state = 2},
  [873] = {.lex_state = 52, .external_lex_state = 2},
  [874] = {.lex_state = 52, .external_lex_state = 2},
  [875] = {.lex_state = 52, .external_lex_state = 2},
  [876] = {.lex_state = 52, .external_lex_state = 2},
  [877] = {.lex_state = 52, .external_lex_state = 2},
  [878] = {.lex_state = 52, .external_lex_state = 2},
  [879] = {.lex_state = 52, .external_lex_state = 2},
  [880] = {.lex_state = 52, .external_lex_state = 2},
  [881] = {.lex_state = 52, .external_lex_state = 2},
  [882] = {.lex_state = 52, .external_lex_state = 2},
  [883] = {.lex_state = 52, .external_lex_state = 2},
  [884] = {.lex_state = 52, .external_lex_state = 2},
  [885] = {.lex_state = 52, .external_lex_state = 2},
  [886] = {.lex_state = 52, .external_lex_state = 2},
  [887] = {.lex_state = 52, .external_lex_state = 2},
  [888] = {.lex_state = 52, .external_lex_state = 2},
  [889] = {.lex_state = 52, .external_lex_state = 2},
  [890] = {.lex_state = 52, .external_lex_state = 2},
  [891] = {.lex_state = 52, .external_lex_state = 2},
  [892] = {.lex_state = 52, .external_lex_state = 2},
  [893] = {.lex_state = 52, .external_lex_state = 2},
  [894] = {.lex_state = 52, .external_lex_state = 2},
  [895] = {.lex_state = 52, .external_lex_state = 2},
  [896] = {.lex_state = 52, .external_lex_state = 2},
  [897] = {.lex_state = 52, .external_lex_state = 2},
  [898] = {.lex_state = 52, .external_lex_state = 2},
  [899] = {.lex_state = 52, .external_lex_state = 2},
  [900] = {.lex_state = 52, .external_lex_state = 2},
  [901] = {.lex_state = 52, .external_lex_state = 2},
  [902] = {.lex_state = 52, .external_lex_state = 2},
  [903] = {.lex_state = 52, .external_lex_state = 2},
  [904] = {.lex_state = 13, .external_lex_state = 12},
  [905] = {.lex_state = 52, .external_lex_state = 2},
  [906] = {.lex_state = 52, .external_lex_state = 2},
  [907] = {.lex_state = 52, .external_lex_state = 2},
  [908] = {.lex_state = 52, .external_lex_state = 2},
  [909] = {.lex_state = 52, .external_lex_state = 2},
  [910] = {.lex_state = 52, .external_lex_state = 2},
  [911] = {.lex_state = 52, .external_lex_state = 2},
  [912] = {.lex_state = 52, .external_lex_state = 2},
  [913] = {.lex_state = 52, .external_lex_state = 2},
  [914] = {.lex_state = 52, .external_lex_state = 2},
  [915] = {.lex_state = 52, .external_lex_state = 2},
  [916] = {.lex_state = 52, .external_lex_state = 2},
  [917] = {.lex_state = 52, .external_lex_state = 2},
  [918] = {.lex_state = 52, .external_lex_state = 2},
  [919] = {.lex_state = 52, .external_lex_state = 2},
  [920] = {.lex_state = 52, .external_lex_state = 2},
  [921] = {.lex_state = 52, .external_lex_state = 2},
  [922] = {.lex_state = 52, .external_lex_state = 2},
  [923] = {.lex_state = 52, .external_lex_state = 2},
  [924] = {.lex_state = 52, .external_lex_state = 2},
  [925] = {.lex_state = 52, .external_lex_state = 2},
  [926] = {.lex_state = 52, .external_lex_state = 2},
  [927] = {.lex_state = 52, .external_lex_state = 2},
  [928] = {.lex_state = 52, .external_lex_state = 2},
  [929] = {.lex_state = 52, .external_lex_state = 2},
  [930] = {.lex_state = 52, .external_lex_state = 2},
  [931] = {.lex_state = 52, .external_lex_state = 2},
  [932] = {.lex_state = 52, .external_lex_state = 2},
  [933] = {.lex_state = 52, .external_lex_state = 2},
  [934] = {.lex_state = 52, .external_lex_state = 2},
  [935] = {.lex_state = 52, .external_lex_state = 2},
  [936] = {.lex_state = 52, .external_lex_state = 2},
  [937] = {.lex_state = 52, .external_lex_state = 2},
  [938] = {.lex_state = 52, .external_lex_state = 2},
  [939] = {.lex_state = 52, .external_lex_state = 2},
  [940] = {.lex_state = 52, .external_lex_state = 2},
  [941] = {.lex_state = 52, .external_lex_state = 2},
  [942] = {.lex_state = 52, .external_lex_state = 2},
  [943] = {.lex_state = 52, .external_lex_state = 2},
  [944] = {.lex_state = 52, .external_lex_state = 2},
  [945] = {.lex_state = 52, .external_lex_state = 2},
  [946] = {.lex_state = 13, .external_lex_state = 12},
  [947] = {.lex_state = 52, .external_lex_state = 2},
  [948] = {.lex_state = 52, .external_lex_state = 2},
  [949] = {.lex_state = 52, .external_lex_state = 2},
  [950] = {.lex_state = 52, .external_lex_state = 2},
  [951] = {.lex_state = 52, .external_lex_state = 2},
  [952] = {.lex_state = 52, .external_lex_state = 2},
  [953] = {.lex_state = 52, .external_lex_state = 2},
  [954] = {.lex_state = 52, .external_lex_state = 2},
  [955] = {.lex_state = 52, .external_lex_state = 2},
  [956] = {.lex_state = 52, .external_lex_state = 2},
  [957] = {.lex_state = 52, .external_lex_state = 2},
  [958] = {.lex_state = 52, .external_lex_state = 2},
  [959] = {.lex_state = 52, .external_lex_state = 2},
  [960] = {.lex_state = 52, .external_lex_state = 2},
  [961] = {.lex_state = 52, .external_lex_state = 2},
  [962] = {.lex_state = 52, .external_lex_state = 2},
  [963] = {.lex_state = 13, .external_lex_state = 13},
  [964] = {.lex_state = 13, .external_lex_state = 14},
  [965] = {.lex_state = 13, .external_lex_state = 13},
  [966] = {.lex_state = 13, .external_lex_state = 4},
  [967] = {.lex_state = 13, .external_lex_state = 4},
  [968] = {.lex_state = 13, .external_lex_state = 15},
  [969] = {.lex_state = 13, .external_lex_state = 4},
  [970] = {.lex_state = 13, .external_lex_state = 9},
  [971] = {.lex_state = 13, .external_lex_state = 9},
  [972] = {.lex_state = 13, .external_lex_state = 9},
  [973] = {.lex_state = 13, .external_lex_state = 6},
  [974] = {.lex_state = 13, .external_lex_state = 9},
  [975] = {.lex_state = 13, .external_lex_state = 9},
  [976] = {.lex_state = 13, .external_lex_state = 9},
  [977] = {.lex_state = 13, .external_lex_state = 9},
  [978] = {.lex_state = 13, .external_lex_state = 9},
  [979] = {.lex_state = 13, .external_lex_state = 14},
  [980] = {.lex_state = 13, .external_lex_state = 6},
  [981] = {.lex_state = 13, .external_lex_state = 6},
  [982] = {.lex_state = 13, .external_lex_state = 6},
  [983] = {.lex_state = 13, .external_lex_state = 6},
  [984] = {.lex_state = 13, .external_lex_state = 9},
  [985] = {.lex_state = 13, .external_lex_state = 9},
  [986] = {.lex_state = 13, .external_lex_state = 6},
  [987] = {.lex_state = 13, .external_lex_state = 9},
  [988] = {.lex_state = 13, .external_lex_state = 7},
  [989] = {.lex_state = 13, .external_lex_state = 12},
  [990] = {.lex_state = 13, .external_lex_state = 12},
  [991] = {.lex_state = 13, .external_lex_state = 13},
  [992] = {.lex_state = 13, .external_lex_state = 12},
  [993] = {.lex_state = 13, .external_lex_state = 12},
  [994] = {.lex_state = 13, .external_lex_state = 12},
  [995] = {.lex_state = 13, .external_lex_state = 2},
  [996] = {.lex_state = 13, .external_lex_state = 12},
  [997] = {.lex_state = 13, .external_lex_state = 12},
  [998] = {.lex_state = 13, .external_lex_state = 12},
  [999] = {.lex_state = 13, .external_lex_state = 12},
  [1000] = {.lex_state = 13, .external_lex_state = 12},
  [1001] = {.lex_state = 13, .external_lex_state = 12},
  [1002] = {.lex_state = 13, .external_lex_state = 12},
  [1003] = {.lex_state = 13, .external_lex_state = 7},
  [1004] = {.lex_state = 13, .external_lex_state = 4},
  [1005] = {.lex_state = 13, .external_lex_state = 12},
  [1006] = {.lex_state = 14, .external_lex_state = 9},
  [1007] = {.lex_state = 13, .external_lex_state = 7},
  [1008] = {.lex_state = 14, .external_lex_state = 9},
  [1009] = {.lex_state = 14, .external_lex_state = 9},
  [1010] = {.lex_state = 13, .external_lex_state = 12},
  [1011] = {.lex_state = 13, .external_lex_state = 8},
  [1012] = {.lex_state = 13, .external_lex_state = 8},
  [1013] = {.lex_state = 13, .external_lex_state = 12},
  [1014] = {.lex_state = 13, .external_lex_state = 12},
  [1015] = {.lex_state = 13, .external_lex_state = 12},
  [1016] = {.lex_state = 13, .external_lex_state = 12},
  [1017] = {.lex_state = 13, .external_lex_state = 12},
  [1018] = {.lex_state = 13, .external_lex_state = 12},
  [1019] = {.lex_state = 13, .external_lex_state = 12},
  [1020] = {.lex_state = 13, .external_lex_state = 12},
  [1021] = {.lex_state = 13, .external_lex_state = 12},
  [1022] = {.lex_state = 13, .external_lex_state = 8},
  [1023] = {.lex_state = 13, .external_lex_state = 12},
  [1024] = {.lex_state = 13, .external_lex_state = 7},
  [1025] = {.lex_state = 13, .external_lex_state = 7},
  [1026] = {.lex_state = 13, .external_lex_state = 7},
  [1027] = {.lex_state = 13, .external_lex_state = 4},
  [1028] = {.lex_state = 13, .external_lex_state = 14},
  [1029] = {.lex_state = 13, .external_lex_state = 12},
  [1030] = {.lex_state = 13, .external_lex_state = 12},
  [1031] = {.lex_state = 13, .external_lex_state = 2},
  [1032] = {.lex_state = 13, .external_lex_state = 12},
  [1033] = {.lex_state = 13, .external_lex_state = 2},
  [1034] = {.lex_state = 13, .external_lex_state = 12},
  [1035] = {.lex_state = 13, .external_lex_state = 9},
  [1036] = {.lex_state = 13, .external_lex_state = 13},
  [1037] = {.lex_state = 13, .external_lex_state = 15},
  [1038] = {.lex_state = 13, .external_lex_state = 15},
  [1039] = {.lex_state = 13, .external_lex_state = 15},
  [1040] = {.lex_state = 14, .external_lex_state = 12},
  [1041] = {.lex_state = 14, .external_lex_state = 12},
  [1042] = {.lex_state = 14, .external_lex_state = 12},
  [1043] = {.lex_state = 13, .external_lex_state = 15},
  [1044] = {.lex_state = 13, .external_lex_state = 15},
  [1045] = {.lex_state = 13, .external_lex_state = 9},
  [1046] = {.lex_state = 13, .external_lex_state = 9},
  [1047] = {.lex_state = 13, .external_lex_state = 9},
  [1048] = {.lex_state = 13, .external_lex_state = 9},
  [1049] = {.lex_state = 14, .external_lex_state = 12},
  [1050] = {.lex_state = 13, .external_lex_state = 6},
  [1051] = {.lex_state = 14, .external_lex_state = 12},
  [1052] = {.lex_state = 14, .external_lex_state = 13},
  [1053] = {.lex_state = 13, .external_lex_state = 9},
  [1054] = {.lex_state = 13, .external_lex_state = 8},
  [1055] = {.lex_state = 13, .external_lex_state = 9},
  [1056] = {.lex_state = 13, .external_lex_state = 9},
  [1057] = {.lex_state = 13, .external_lex_state = 9},
  [1058] = {.lex_state = 13, .external_lex_state = 9},
  [1059] = {.lex_state = 13, .external_lex_state = 9},
  [1060] = {.lex_state = 13, .external_lex_state = 9},
  [1061] = {.lex_state = 13, .external_lex_state = 9},
  [1062] = {.lex_state = 13, .external_lex_state = 9},
  [1063] = {.lex_state = 13, .external_lex_state = 9},
  [1064] = {.lex_state = 14, .external_lex_state = 12},
  [1065] = {.lex_state = 13, .external_lex_state = 9},
  [1066] = {.lex_state = 13, .external_lex_state = 9},
  [1067] = {.lex_state = 14, .external_lex_state = 12},
  [1068] = {.lex_state = 14, .external_lex_state = 12},
  [1069] = {.lex_state = 13, .external_lex_state = 8},
  [1070] = {.lex_state = 13, .external_lex_state = 9},
  [1071] = {.lex_state = 13, .external_lex_state = 9},
  [1072] = {.lex_state = 13, .external_lex_state = 15},
  [1073] = {.lex_state = 13, .external_lex_state = 9},
  [1074] = {.lex_state = 13, .external_lex_state = 9},
  [1075] = {.lex_state = 13, .external_lex_state = 15},
  [1076] = {.lex_state = 13, .external_lex_state = 6},
  [1077] = {.lex_state = 14, .external_lex_state = 12},
  [1078] = {.lex_state = 14, .external_lex_state = 13},
  [1079] = {.lex_state = 13, .external_lex_state = 13},
  [1080] = {.lex_state = 13, .external_lex_state = 13},
  [1081] = {.lex_state = 14, .external_lex_state = 12},
  [1082] = {.lex_state = 13, .external_lex_state = 9},
  [1083] = {.lex_state = 13, .external_lex_state = 9},
  [1084] = {.lex_state = 13, .external_lex_state = 15},
  [1085] = {.lex_state = 13, .external_lex_state = 9},
  [1086] = {.lex_state = 13, .external_lex_state = 13},
  [1087] = {.lex_state = 13, .external_lex_state = 13},
  [1088] = {.lex_state = 13, .external_lex_state = 13},
  [1089] = {.lex_state = 13, .external_lex_state = 13},
  [1090] = {.lex_state = 13, .external_lex_state = 13},
  [1091] = {.lex_state = 13, .external_lex_state = 13},
  [1092] = {.lex_state = 13, .external_lex_state = 13},
  [1093] = {.lex_state = 13, .external_lex_state = 13},
  [1094] = {.lex_state = 13, .external_lex_state = 13},
  [1095] = {.lex_state = 13, .external_lex_state = 13},
  [1096] = {.lex_state = 13, .external_lex_state = 15},
  [1097] = {.lex_state = 13, .external_lex_state = 9},
  [1098] = {.lex_state = 13, .external_lex_state = 13},
  [1099] = {.lex_state = 13, .external_lex_state = 13},
  [1100] = {.lex_state = 14, .external_lex_state = 9},
  [1101] = {.lex_state = 13, .external_lex_state = 9},
  [1102] = {.lex_state = 13, .external_lex_state = 13},
  [1103] = {.lex_state = 13, .external_lex_state = 13},
  [1104] = {.lex_state = 13, .external_lex_state = 9},
  [1105] = {.lex_state = 13, .external_lex_state = 6},
  [1106] = {.lex_state = 13, .external_lex_state = 9},
  [1107] = {.lex_state = 13, .external_lex_state = 15},
  [1108] = {.lex_state = 13, .external_lex_state = 14},
  [1109] = {.lex_state = 13, .external_lex_state = 14},
  [1110] = {.lex_state = 14, .external_lex_state = 13},
  [1111] = {.lex_state = 13, .external_lex_state = 14},
  [1112] = {.lex_state = 13, .external_lex_state = 14},
  [1113] = {.lex_state = 13, .external_lex_state = 14},
  [1114] = {.lex_state = 13, .external_lex_state = 14},
  [1115] = {.lex_state = 13, .external_lex_state = 14},
  [1116] = {.lex_state = 13, .external_lex_state = 14},
  [1117] = {.lex_state = 13, .external_lex_state = 14},
  [1118] = {.lex_state = 13, .external_lex_state = 9},
  [1119] = {.lex_state = 13, .external_lex_state = 8},
  [1120] = {.lex_state = 13, .external_lex_state = 9},
  [1121] = {.lex_state = 13, .external_lex_state = 14},
  [1122] = {.lex_state = 14, .external_lex_state = 12},
  [1123] = {.lex_state = 13, .external_lex_state = 9},
  [1124] = {.lex_state = 13, .external_lex_state = 13},
  [1125] = {.lex_state = 13, .external_lex_state = 13},
  [1126] = {.lex_state = 13, .external_lex_state = 13},
  [1127] = {.lex_state = 13, .external_lex_state = 6},
  [1128] = {.lex_state = 14, .external_lex_state = 13},
  [1129] = {.lex_state = 13, .external_lex_state = 9},
  [1130] = {.lex_state = 13, .external_lex_state = 9},
  [1131] = {.lex_state = 13, .external_lex_state = 9},
  [1132] = {.lex_state = 13, .external_lex_state = 9},
  [1133] = {.lex_state = 14, .external_lex_state = 12},
  [1134] = {.lex_state = 13, .external_lex_state = 9},
  [1135] = {.lex_state = 13, .external_lex_state = 12},
  [1136] = {.lex_state = 13, .external_lex_state = 12},
  [1137] = {.lex_state = 13, .external_lex_state = 12},
  [1138] = {.lex_state = 14, .external_lex_state = 13},
  [1139] = {.lex_state = 13, .external_lex_state = 12},
  [1140] = {.lex_state = 13, .external_lex_state = 7},
  [1141] = {.lex_state = 13, .external_lex_state = 12},
  [1142] = {.lex_state = 13, .external_lex_state = 12},
  [1143] = {.lex_state = 13, .external_lex_state = 12},
  [1144] = {.lex_state = 14, .external_lex_state = 14},
  [1145] = {.lex_state = 14, .external_lex_state = 14},
  [1146] = {.lex_state = 13, .external_lex_state = 12},
  [1147] = {.lex_state = 13, .external_lex_state = 12},
  [1148] = {.lex_state = 13, .external_lex_state = 12},
  [1149] = {.lex_state = 13, .external_lex_state = 12},
  [1150] = {.lex_state = 14, .external_lex_state = 15},
  [1151] = {.lex_state = 14, .external_lex_state = 13},
  [1152] = {.lex_state = 14, .external_lex_state = 13},
  [1153] = {.lex_state = 14, .external_lex_state = 13},
  [1154] = {.lex_state = 14, .external_lex_state = 15},
  [1155] = {.lex_state = 14, .external_lex_state = 15},
  [1156] = {.lex_state = 13, .external_lex_state = 12},
  [1157] = {.lex_state = 13, .external_lex_state = 13},
  [1158] = {.lex_state = 13, .external_lex_state = 13},
  [1159] = {.lex_state = 13, .external_lex_state = 12},
  [1160] = {.lex_state = 13, .external_lex_state = 12},
  [1161] = {.lex_state = 13, .external_lex_state = 12},
  [1162] = {.lex_state = 13, .external_lex_state = 12},
  [1163] = {.lex_state = 13, .external_lex_state = 12},
  [1164] = {.lex_state = 13, .external_lex_state = 12},
  [1165] = {.lex_state = 13, .external_lex_state = 12},
  [1166] = {.lex_state = 13, .external_lex_state = 12},
  [1167] = {.lex_state = 14, .external_lex_state = 13},
  [1168] = {.lex_state = 14, .external_lex_state = 13},
  [1169] = {.lex_state = 14, .external_lex_state = 13},
  [1170] = {.lex_state = 13, .external_lex_state = 12},
  [1171] = {.lex_state = 13, .external_lex_state = 12},
  [1172] = {.lex_state = 13, .external_lex_state = 12},
  [1173] = {.lex_state = 13, .external_lex_state = 12},
  [1174] = {.lex_state = 13, .external_lex_state = 12},
  [1175] = {.lex_state = 13, .external_lex_state = 12},
  [1176] = {.lex_state = 13, .external_lex_state = 12},
  [1177] = {.lex_state = 13, .external_lex_state = 12},
  [1178] = {.lex_state = 13, .external_lex_state = 12},
  [1179] = {.lex_state = 13, .external_lex_state = 12},
  [1180] = {.lex_state = 13, .external_lex_state = 12},
  [1181] = {.lex_state = 13, .external_lex_state = 7},
  [1182] = {.lex_state = 13, .external_lex_state = 12},
  [1183] = {.lex_state = 13, .external_lex_state = 12},
  [1184] = {.lex_state = 14, .external_lex_state = 14},
  [1185] = {.lex_state = 13, .external_lex_state = 13},
  [1186] = {.lex_state = 13, .external_lex_state = 13},
  [1187] = {.lex_state = 13, .external_lex_state = 13},
  [1188] = {.lex_state = 13, .external_lex_state = 8},
  [1189] = {.lex_state = 13, .external_lex_state = 12},
  [1190] = {.lex_state = 13, .external_lex_state = 14},
  [1191] = {.lex_state = 14, .external_lex_state = 14},
  [1192] = {.lex_state = 14, .external_lex_state = 14},
  [1193] = {.lex_state = 13, .external_lex_state = 12},
  [1194] = {.lex_state = 14, .external_lex_state = 14},
  [1195] = {.lex_state = 13, .external_lex_state = 14},
  [1196] = {.lex_state = 13, .external_lex_state = 12},
  [1197] = {.lex_state = 13, .external_lex_state = 12},
  [1198] = {.lex_state = 14, .external_lex_state = 13},
  [1199] = {.lex_state = 13, .external_lex_state = 12},
  [1200] = {.lex_state = 14, .external_lex_state = 14},
  [1201] = {.lex_state = 14, .external_lex_state = 13},
  [1202] = {.lex_state = 13, .external_lex_state = 2},
  [1203] = {.lex_state = 14, .external_lex_state = 13},
  [1204] = {.lex_state = 14, .external_lex_state = 14},
  [1205] = {.lex_state = 14, .external_lex_state = 14},
  [1206] = {.lex_state = 13, .external_lex_state = 12},
  [1207] = {.lex_state = 13, .external_lex_state = 7},
  [1208] = {.lex_state = 13, .external_lex_state = 12},
  [1209] = {.lex_state = 13, .external_lex_state = 12},
  [1210] = {.lex_state = 13, .external_lex_state = 12},
  [1211] = {.lex_state = 13, .external_lex_state = 12},
  [1212] = {.lex_state = 13, .external_lex_state = 12},
  [1213] = {.lex_state = 13, .external_lex_state = 12},
  [1214] = {.lex_state = 13, .external_lex_state = 12},
  [1215] = {.lex_state = 13, .external_lex_state = 12},
  [1216] = {.lex_state = 13, .external_lex_state = 12},
  [1217] = {.lex_state = 13, .external_lex_state = 12},
  [1218] = {.lex_state = 13, .external_lex_state = 12},
  [1219] = {.lex_state = 13, .external_lex_state = 12},
  [1220] = {.lex_state = 14, .external_lex_state = 14},
  [1221] = {.lex_state = 13, .external_lex_state = 13},
  [1222] = {.lex_state = 13, .external_lex_state = 12},
  [1223] = {.lex_state = 13, .external_lex_state = 13},
  [1224] = {.lex_state = 13, .external_lex_state = 12},
  [1225] = {.lex_state = 13, .external_lex_state = 12},
  [1226] = {.lex_state = 13, .external_lex_state = 12},
  [1227] = {.lex_state = 13, .external_lex_state = 12},
  [1228] = {.lex_state = 13, .external_lex_state = 12},
  [1229] = {.lex_state = 13, .external_lex_state = 14},
  [1230] = {.lex_state = 13, .external_lex_state = 14},
  [1231] = {.lex_state = 13, .external_lex_state = 14},
  [1232] = {.lex_state = 13, .external_lex_state = 14},
  [1233] = {.lex_state = 13, .external_lex_state = 12},
  [1234] = {.lex_state = 13, .external_lex_state = 14},
  [1235] = {.lex_state = 13, .external_lex_state = 14},
  [1236] = {.lex_state = 13, .external_lex_state = 14},
  [1237] = {.lex_state = 13, .external_lex_state = 14},
  [1238] = {.lex_state = 13, .external_lex_state = 8},
  [1239] = {.lex_state = 13, .external_lex_state = 12},
  [1240] = {.lex_state = 13, .external_lex_state = 12},
  [1241] = {.lex_state = 13, .external_lex_state = 12},
  [1242] = {.lex_state = 14, .external_lex_state = 15},
  [1243] = {.lex_state = 13, .external_lex_state = 12},
  [1244] = {.lex_state = 13, .external_lex_state = 12},
  [1245] = {.lex_state = 13, .external_lex_state = 12},
  [1246] = {.lex_state = 13, .external_lex_state = 12},
  [1247] = {.lex_state = 14, .external_lex_state = 13},
  [1248] = {.lex_state = 14, .external_lex_state = 13},
  [1249] = {.lex_state = 13, .external_lex_state = 12},
  [1250] = {.lex_state = 13, .external_lex_state = 12},
  [1251] = {.lex_state = 13, .external_lex_state = 12},
  [1252] = {.lex_state = 13, .external_lex_state = 12},
  [1253] = {.lex_state = 13, .external_lex_state = 2},
  [1254] = {.lex_state = 13, .external_lex_state = 12},
  [1255] = {.lex_state = 13, .external_lex_state = 7},
  [1256] = {.lex_state = 13, .external_lex_state = 13},
  [1257] = {.lex_state = 13, .external_lex_state = 13},
  [1258] = {.lex_state = 13, .external_lex_state = 15},
  [1259] = {.lex_state = 13, .external_lex_state = 9},
  [1260] = {.lex_state = 13, .external_lex_state = 13},
  [1261] = {.lex_state = 13, .external_lex_state = 13},
  [1262] = {.lex_state = 13, .external_lex_state = 13},
  [1263] = {.lex_state = 13, .external_lex_state = 13},
  [1264] = {.lex_state = 13, .external_lex_state = 13},
  [1265] = {.lex_state = 13, .external_lex_state = 15},
  [1266] = {.lex_state = 13, .external_lex_state = 13},
  [1267] = {.lex_state = 13, .external_lex_state = 14},
  [1268] = {.lex_state = 13, .external_lex_state = 13},
  [1269] = {.lex_state = 13, .external_lex_state = 15},
  [1270] = {.lex_state = 13, .external_lex_state = 13},
  [1271] = {.lex_state = 13, .external_lex_state = 15},
  [1272] = {.lex_state = 13, .external_lex_state = 13},
  [1273] = {.lex_state = 13, .external_lex_state = 15},
  [1274] = {.lex_state = 13, .external_lex_state = 13},
  [1275] = {.lex_state = 13, .external_lex_state = 14},
  [1276] = {.lex_state = 13, .external_lex_state = 13},
  [1277] = {.lex_state = 14, .external_lex_state = 13},
  [1278] = {.lex_state = 14, .external_lex_state = 13},
  [1279] = {.lex_state = 14, .external_lex_state = 13},
  [1280] = {.lex_state = 13, .external_lex_state = 15},
  [1281] = {.lex_state = 13, .external_lex_state = 15},
  [1282] = {.lex_state = 13, .external_lex_state = 15},
  [1283] = {.lex_state = 13, .external_lex_state = 14},
  [1284] = {.lex_state = 13, .external_lex_state = 13},
  [1285] = {.lex_state = 13, .external_lex_state = 14},
  [1286] = {.lex_state = 13, .external_lex_state = 13},
  [1287] = {.lex_state = 13, .external_lex_state = 14},
  [1288] = {.lex_state = 13, .external_lex_state = 14},
  [1289] = {.lex_state = 13, .external_lex_state = 14},
  [1290] = {.lex_state = 13, .external_lex_state = 14},
  [1291] = {.lex_state = 13, .external_lex_state = 15},
  [1292] = {.lex_state = 13, .external_lex_state = 15},
  [1293] = {.lex_state = 13, .external_lex_state = 15},
  [1294] = {.lex_state = 13, .external_lex_state = 15},
  [1295] = {.lex_state = 13, .external_lex_state = 14},
  [1296] = {.lex_state = 13, .external_lex_state = 14},
  [1297] = {.lex_state = 13, .external_lex_state = 14},
  [1298] = {.lex_state = 8, .external_lex_state = 9},
  [1299] = {.lex_state = 13, .external_lex_state = 13},
  [1300] = {.lex_state = 13, .external_lex_state = 15},
  [1301] = {.lex_state = 13, .external_lex_state = 13},
  [1302] = {.lex_state = 8, .external_lex_state = 9},
  [1303] = {.lex_state = 13, .external_lex_state = 13},
  [1304] = {.lex_state = 13, .external_lex_state = 15},
  [1305] = {.lex_state = 8, .external_lex_state = 9},
  [1306] = {.lex_state = 8, .external_lex_state = 9},
  [1307] = {.lex_state = 13, .external_lex_state = 14},
  [1308] = {.lex_state = 13, .external_lex_state = 15},
  [1309] = {.lex_state = 13, .external_lex_state = 15},
  [1310] = {.lex_state = 13, .external_lex_state = 15},
  [1311] = {.lex_state = 13, .external_lex_state = 14},
  [1312] = {.lex_state = 13, .external_lex_state = 14},
  [1313] = {.lex_state = 13, .external_lex_state = 15},
  [1314] = {.lex_state = 13, .external_lex_state = 14},
  [1315] = {.lex_state = 13, .external_lex_state = 8},
  [1316] = {.lex_state = 13, .external_lex_state = 13},
  [1317] = {.lex_state = 13, .external_lex_state = 13},
  [1318] = {.lex_state = 13, .external_lex_state = 14},
  [1319] = {.lex_state = 13, .external_lex_state = 14},
  [1320] = {.lex_state = 13, .external_lex_state = 15},
  [1321] = {.lex_state = 13, .external_lex_state = 15},
  [1322] = {.lex_state = 13, .external_lex_state = 15},
  [1323] = {.lex_state = 13, .external_lex_state = 15},
  [1324] = {.lex_state = 13, .external_lex_state = 13},
  [1325] = {.lex_state = 13, .external_lex_state = 8},
  [1326] = {.lex_state = 8, .external_lex_state = 9},
  [1327] = {.lex_state = 13, .external_lex_state = 15},
  [1328] = {.lex_state = 13, .external_lex_state = 15},
  [1329] = {.lex_state = 13, .external_lex_state = 15},
  [1330] = {.lex_state = 13, .external_lex_state = 13},
  [1331] = {.lex_state = 13, .external_lex_state = 13},
  [1332] = {.lex_state = 13, .external_lex_state = 14},
  [1333] = {.lex_state = 13, .external_lex_state = 14},
  [1334] = {.lex_state = 13, .external_lex_state = 15},
  [1335] = {.lex_state = 13, .external_lex_state = 13},
  [1336] = {.lex_state = 13, .external_lex_state = 15},
  [1337] = {.lex_state = 13, .external_lex_state = 15},
  [1338] = {.lex_state = 13, .external_lex_state = 13},
  [1339] = {.lex_state = 13, .external_lex_state = 15},
  [1340] = {.lex_state = 13, .external_lex_state = 13},
  [1341] = {.lex_state = 13, .external_lex_state = 15},
  [1342] = {.lex_state = 8, .external_lex_state = 9},
  [1343] = {.lex_state = 13, .external_lex_state = 14},
  [1344] = {.lex_state = 13, .external_lex_state = 13},
  [1345] = {.lex_state = 13, .external_lex_state = 14},
  [1346] = {.lex_state = 13, .external_lex_state = 14},
  [1347] = {.lex_state = 13, .external_lex_state = 14},
  [1348] = {.lex_state = 13, .external_lex_state = 13},
  [1349] = {.lex_state = 13, .external_lex_state = 13},
  [1350] = {.lex_state = 13, .external_lex_state = 15},
  [1351] = {.lex_state = 13, .external_lex_state = 15},
  [1352] = {.lex_state = 13, .external_lex_state = 13},
  [1353] = {.lex_state = 13, .external_lex_state = 13},
  [1354] = {.lex_state = 13, .external_lex_state = 14},
  [1355] = {.lex_state = 13, .external_lex_state = 13},
  [1356] = {.lex_state = 13, .external_lex_state = 14},
  [1357] = {.lex_state = 13, .external_lex_state = 15},
  [1358] = {.lex_state = 13, .external_lex_state = 14},
  [1359] = {.lex_state = 13, .external_lex_state = 14},
  [1360] = {.lex_state = 13, .external_lex_state = 13},
  [1361] = {.lex_state = 13, .external_lex_state = 13},
  [1362] = {.lex_state = 13, .external_lex_state = 13},
  [1363] = {.lex_state = 13, .external_lex_state = 13},
  [1364] = {.lex_state = 13, .external_lex_state = 13},
  [1365] = {.lex_state = 13, .external_lex_state = 14},
  [1366] = {.lex_state = 13, .external_lex_state = 14},
  [1367] = {.lex_state = 13, .external_lex_state = 14},
  [1368] = {.lex_state = 13, .external_lex_state = 13},
  [1369] = {.lex_state = 13, .external_lex_state = 15},
  [1370] = {.lex_state = 13, .external_lex_state = 15},
  [1371] = {.lex_state = 13, .external_lex_state = 13},
  [1372] = {.lex_state = 13, .external_lex_state = 13},
  [1373] = {.lex_state = 13, .external_lex_state = 13},
  [1374] = {.lex_state = 13, .external_lex_state = 13},
  [1375] = {.lex_state = 13, .external_lex_state = 14},
  [1376] = {.lex_state = 13, .external_lex_state = 14},
  [1377] = {.lex_state = 13, .external_lex_state = 13},
  [1378] = {.lex_state = 13, .external_lex_state = 13},
  [1379] = {.lex_state = 13, .external_lex_state = 14},
  [1380] = {.lex_state = 13, .external_lex_state = 13},
  [1381] = {.lex_state = 13, .external_lex_state = 13},
  [1382] = {.lex_state = 13, .external_lex_state = 13},
  [1383] = {.lex_state = 13, .external_lex_state = 15},
  [1384] = {.lex_state = 13, .external_lex_state = 13},
  [1385] = {.lex_state = 13, .external_lex_state = 13},
  [1386] = {.lex_state = 13, .external_lex_state = 13},
  [1387] = {.lex_state = 14, .external_lex_state = 14},
  [1388] = {.lex_state = 13, .external_lex_state = 13},
  [1389] = {.lex_state = 13, .external_lex_state = 13},
  [1390] = {.lex_state = 13, .external_lex_state = 13},
  [1391] = {.lex_state = 13, .external_lex_state = 13},
  [1392] = {.lex_state = 14, .external_lex_state = 14},
  [1393] = {.lex_state = 13, .external_lex_state = 13},
  [1394] = {.lex_state = 13, .external_lex_state = 13},
  [1395] = {.lex_state = 13, .external_lex_state = 13},
  [1396] = {.lex_state = 14, .external_lex_state = 14},
  [1397] = {.lex_state = 13, .external_lex_state = 13},
  [1398] = {.lex_state = 13, .external_lex_state = 13},
  [1399] = {.lex_state = 13, .external_lex_state = 13},
  [1400] = {.lex_state = 13, .external_lex_state = 14},
  [1401] = {.lex_state = 13, .external_lex_state = 14},
  [1402] = {.lex_state = 13, .external_lex_state = 14},
  [1403] = {.lex_state = 13, .external_lex_state = 14},
  [1404] = {.lex_state = 13, .external_lex_state = 14},
  [1405] = {.lex_state = 13, .external_lex_state = 13},
  [1406] = {.lex_state = 13, .external_lex_state = 13},
  [1407] = {.lex_state = 13, .external_lex_state = 13},
  [1408] = {.lex_state = 13, .external_lex_state = 13},
  [1409] = {.lex_state = 13, .external_lex_state = 14},
  [1410] = {.lex_state = 13, .external_lex_state = 13},
  [1411] = {.lex_state = 13, .external_lex_state = 14},
  [1412] = {.lex_state = 13, .external_lex_state = 13},
  [1413] = {.lex_state = 13, .external_lex_state = 13},
  [1414] = {.lex_state = 13, .external_lex_state = 13},
  [1415] = {.lex_state = 13, .external_lex_state = 14},
  [1416] = {.lex_state = 13, .external_lex_state = 13},
  [1417] = {.lex_state = 13, .external_lex_state = 13},
  [1418] = {.lex_state = 13, .external_lex_state = 13},
  [1419] = {.lex_state = 13, .external_lex_state = 14},
  [1420] = {.lex_state = 13, .external_lex_state = 14},
  [1421] = {.lex_state = 13, .external_lex_state = 14},
  [1422] = {.lex_state = 14, .external_lex_state = 14},
  [1423] = {.lex_state = 14, .external_lex_state = 14},
  [1424] = {.lex_state = 14, .external_lex_state = 14},
  [1425] = {.lex_state = 14, .external_lex_state = 12},
  [1426] = {.lex_state = 13, .external_lex_state = 14},
  [1427] = {.lex_state = 14, .external_lex_state = 12},
  [1428] = {.lex_state = 14, .external_lex_state = 12},
  [1429] = {.lex_state = 13, .external_lex_state = 14},
  [1430] = {.lex_state = 13, .external_lex_state = 14},
  [1431] = {.lex_state = 13, .external_lex_state = 14},
  [1432] = {.lex_state = 13, .external_lex_state = 14},
  [1433] = {.lex_state = 13, .external_lex_state = 14},
  [1434] = {.lex_state = 13, .external_lex_state = 14},
  [1435] = {.lex_state = 13, .external_lex_state = 14},
  [1436] = {.lex_state = 13, .external_lex_state = 15},
  [1437] = {.lex_state = 13, .external_lex_state = 14},
  [1438] = {.lex_state = 13, .external_lex_state = 14},
  [1439] = {.lex_state = 13, .external_lex_state = 14},
  [1440] = {.lex_state = 13, .external_lex_state = 14},
  [1441] = {.lex_state = 13, .external_lex_state = 14},
  [1442] = {.lex_state = 13, .external_lex_state = 14},
  [1443] = {.lex_state = 13, .external_lex_state = 14},
  [1444] = {.lex_state = 13, .external_lex_state = 14},
  [1445] = {.lex_state = 13, .external_lex_state = 14},
  [1446] = {.lex_state = 13, .external_lex_state = 14},
  [1447] = {.lex_state = 13, .external_lex_state = 14},
  [1448] = {.lex_state = 13, .external_lex_state = 14},
  [1449] = {.lex_state = 13, .external_lex_state = 14},
  [1450] = {.lex_state = 13, .external_lex_state = 14},
  [1451] = {.lex_state = 13, .external_lex_state = 14},
  [1452] = {.lex_state = 13, .external_lex_state = 14},
  [1453] = {.lex_state = 13, .external_lex_state = 14},
  [1454] = {.lex_state = 13, .external_lex_state = 14},
  [1455] = {.lex_state = 13, .external_lex_state = 14},
  [1456] = {.lex_state = 13, .external_lex_state = 14},
  [1457] = {.lex_state = 13, .external_lex_state = 14},
  [1458] = {.lex_state = 13, .external_lex_state = 14},
  [1459] = {.lex_state = 13, .external_lex_state = 14},
  [1460] = {.lex_state = 13, .external_lex_state = 14},
  [1461] = {.lex_state = 13, .external_lex_state = 14},
  [1462] = {.lex_state = 13, .external_lex_state = 14},
  [1463] = {.lex_state = 14, .external_lex_state = 13},
  [1464] = {.lex_state = 14, .external_lex_state = 13},
  [1465] = {.lex_state = 14, .external_lex_state = 13},
  [1466] = {.lex_state = 8, .external_lex_state = 15},
  [1467] = {.lex_state = 8, .external_lex_state = 15},
  [1468] = {.lex_state = 8, .external_lex_state = 15},
  [1469] = {.lex_state = 8, .external_lex_state = 15},
  [1470] = {.lex_state = 8, .external_lex_state = 15},
  [1471] = {.lex_state = 8, .external_lex_state = 15},
  [1472] = {.lex_state = 8, .external_lex_state = 15},
  [1473] = {.lex_state = 8, .external_lex_state = 15},
  [1474] = {.lex_state = 8, .external_lex_state = 15},
  [1475] = {.lex_state = 8, .external_lex_state = 15},
  [1476] = {.lex_state = 8, .external_lex_state = 15},
  [1477] = {.lex_state = 8, .external_lex_state = 15},
  [1478] = {.lex_state = 8, .external_lex_state = 15},
  [1479] = {.lex_state = 8, .external_lex_state = 15},
  [1480] = {.lex_state = 8, .external_lex_state = 15},
  [1481] = {.lex_state = 8, .external_lex_state = 15},
  [1482] = {.lex_state = 13, .external_lex_state = 13},
  [1483] = {.lex_state = 13, .external_lex_state = 14},
  [1484] = {.lex_state = 13, .external_lex_state = 12},
  [1485] = {.lex_state = 12, .external_lex_state = 2},
  [1486] = {.lex_state = 12, .external_lex_state = 2},
  [1487] = {.lex_state = 5, .external_lex_state = 7},
  [1488] = {.lex_state = 5, .external_lex_state = 7},
  [1489] = {.lex_state = 5, .external_lex_state = 7},
  [1490] = {.lex_state = 5, .external_lex_state = 8},
  [1491] = {.lex_state = 5, .external_lex_state = 7},
  [1492] = {.lex_state = 5, .external_lex_state = 7},
  [1493] = {.lex_state = 5, .external_lex_state = 7},
  [1494] = {.lex_state = 5, .external_lex_state = 8},
  [1495] = {.lex_state = 5, .external_lex_state = 7},
  [1496] = {.lex_state = 5, .external_lex_state = 7},
  [1497] = {.lex_state = 5, .external_lex_state = 7},
  [1498] = {.lex_state = 5, .external_lex_state = 8},
  [1499] = {.lex_state = 5, .external_lex_state = 8},
  [1500] = {.lex_state = 5, .external_lex_state = 8},
  [1501] = {.lex_state = 5, .external_lex_state = 7},
  [1502] = {.lex_state = 5, .external_lex_state = 8},
  [1503] = {.lex_state = 5, .external_lex_state = 7},
  [1504] = {.lex_state = 5, .external_lex_state = 7},
  [1505] = {.lex_state = 5, .external_lex_state = 7},
  [1506] = {.lex_state = 5, .external_lex_state = 7},
  [1507] = {.lex_state = 5, .external_lex_state = 7},
  [1508] = {.lex_state = 5, .external_lex_state = 7},
  [1509] = {.lex_state = 5, .external_lex_state = 8},
  [1510] = {.lex_state = 5, .external_lex_state = 8},
  [1511] = {.lex_state = 5, .external_lex_state = 8},
  [1512] = {.lex_state = 5, .external_lex_state = 7},
  [1513] = {.lex_state = 5, .external_lex_state = 7},
  [1514] = {.lex_state = 5, .external_lex_state = 8},
  [1515] = {.lex_state = 5, .external_lex_state = 8},
  [1516] = {.lex_state = 5, .external_lex_state = 7},
  [1517] = {.lex_state = 5, .external_lex_state = 7},
  [1518] = {.lex_state = 5, .external_lex_state = 8},
  [1519] = {.lex_state = 5, .external_lex_state = 7},
  [1520] = {.lex_state = 5, .external_lex_state = 7},
  [1521] = {.lex_state = 5, .external_lex_state = 7},
  [1522] = {.lex_state = 5, .external_lex_state = 7},
  [1523] = {.lex_state = 5, .external_lex_state = 2},
  [1524] = {.lex_state = 5, .external_lex_state = 2},
  [1525] = {.lex_state = 5, .external_lex_state = 2},
  [1526] = {.lex_state = 5, .external_lex_state = 2},
  [1527] = {.lex_state = 5, .external_lex_state = 2},
  [1528] = {.lex_state = 5, .external_lex_state = 6},
  [1529] = {.lex_state = 5, .external_lex_state = 6},
  [1530] = {.lex_state = 5, .external_lex_state = 6},
  [1531] = {.lex_state = 5, .external_lex_state = 6},
  [1532] = {.lex_state = 5, .external_lex_state = 6},
  [1533] = {.lex_state = 5, .external_lex_state = 6},
  [1534] = {.lex_state = 5, .external_lex_state = 6},
  [1535] = {.lex_state = 5, .external_lex_state = 6},
  [1536] = {.lex_state = 5, .external_lex_state = 6},
  [1537] = {.lex_state = 5, .external_lex_state = 6},
  [1538] = {.lex_state = 5, .external_lex_state = 6},
  [1539] = {.lex_state = 5, .external_lex_state = 6},
  [1540] = {.lex_state = 5, .external_lex_state = 6},
  [1541] = {.lex_state = 5, .external_lex_state = 6},
  [1542] = {.lex_state = 5, .external_lex_state = 6},
  [1543] = {.lex_state = 5, .external_lex_state = 6},
  [1544] = {.lex_state = 5, .external_lex_state = 6},
  [1545] = {.lex_state = 5, .external_lex_state = 6},
  [1546] = {.lex_state = 5, .external_lex_state = 6},
  [1547] = {.lex_state = 5, .external_lex_state = 6},
  [1548] = {.lex_state = 5, .external_lex_state = 2},
  [1549] = {.lex_state = 5, .external_lex_state = 2},
  [1550] = {.lex_state = 5, .external_lex_state = 2},
  [1551] = {.lex_state = 5, .external_lex_state = 2},
  [1552] = {.lex_state = 5, .external_lex_state = 2},
  [1553] = {.lex_state = 8, .external_lex_state = 9},
  [1554] = {.lex_state = 8, .external_lex_state = 9},
  [1555] = {.lex_state = 5, .external_lex_state = 2},
  [1556] = {.lex_state = 5, .external_lex_state = 2},
  [1557] = {.lex_state = 5, .external_lex_state = 2},
  [1558] = {.lex_state = 5, .external_lex_state = 2},
  [1559] = {.lex_state = 8, .external_lex_state = 13},
  [1560] = {.lex_state = 8, .external_lex_state = 15},
  [1561] = {.lex_state = 8, .external_lex_state = 15},
  [1562] = {.lex_state = 8, .external_lex_state = 13},
  [1563] = {.lex_state = 52, .external_lex_state = 12},
  [1564] = {.lex_state = 8, .external_lex_state = 14},
  [1565] = {.lex_state = 52, .external_lex_state = 12},
  [1566] = {.lex_state = 8, .external_lex_state = 14},
  [1567] = {.lex_state = 52, .external_lex_state = 12},
  [1568] = {.lex_state = 52, .external_lex_state = 12},
  [1569] = {.lex_state = 52, .external_lex_state = 13},
  [1570] = {.lex_state = 52, .external_lex_state = 14},
  [1571] = {.lex_state = 52, .external_lex_state = 2},
  [1572] = {.lex_state = 13, .external_lex_state = 12},
  [1573] = {.lex_state = 13, .external_lex_state = 12},
  [1574] = {.lex_state = 13, .external_lex_state = 12},
  [1575] = {.lex_state = 13, .external_lex_state = 12},
  [1576] = {.lex_state = 13, .external_lex_state = 12},
  [1577] = {.lex_state = 13, .external_lex_state = 12},
  [1578] = {.lex_state = 52, .external_lex_state = 2},
  [1579] = {.lex_state = 52, .external_lex_state = 14},
  [1580] = {.lex_state = 52, .external_lex_state = 13},
  [1581] = {.lex_state = 13, .external_lex_state = 13},
  [1582] = {.lex_state = 13, .external_lex_state = 13},
  [1583] = {.lex_state = 11, .external_lex_state = 9},
  [1584] = {.lex_state = 13, .external_lex_state = 13},
  [1585] = {.lex_state = 13, .external_lex_state = 13},
  [1586] = {.lex_state = 13, .external_lex_state = 13},
  [1587] = {.lex_state = 13, .external_lex_state = 13},
  [1588] = {.lex_state = 11, .external_lex_state = 9},
  [1589] = {.lex_state = 13, .external_lex_state = 14},
  [1590] = {.lex_state = 13, .external_lex_state = 14},
  [1591] = {.lex_state = 13, .external_lex_state = 14},
  [1592] = {.lex_state = 13, .external_lex_state = 15},
  [1593] = {.lex_state = 13, .external_lex_state = 15},
  [1594] = {.lex_state = 13, .external_lex_state = 15},
  [1595] = {.lex_state = 13, .external_lex_state = 15},
  [1596] = {.lex_state = 13, .external_lex_state = 15},
  [1597] = {.lex_state = 13, .external_lex_state = 15},
  [1598] = {.lex_state = 13, .external_lex_state = 15},
  [1599] = {.lex_state = 13, .external_lex_state = 15},
  [1600] = {.lex_state = 13, .external_lex_state = 13},
  [1601] = {.lex_state = 13, .external_lex_state = 13},
  [1602] = {.lex_state = 11, .external_lex_state = 9},
  [1603] = {.lex_state = 13, .external_lex_state = 14},
  [1604] = {.lex_state = 13, .external_lex_state = 15},
  [1605] = {.lex_state = 13, .external_lex_state = 14},
  [1606] = {.lex_state = 13, .external_lex_state = 15},
  [1607] = {.lex_state = 13, .external_lex_state = 14},
  [1608] = {.lex_state = 13, .external_lex_state = 13},
  [1609] = {.lex_state = 13, .external_lex_state = 15},
  [1610] = {.lex_state = 13, .external_lex_state = 13},
  [1611] = {.lex_state = 13, .external_lex_state = 15},
  [1612] = {.lex_state = 13, .external_lex_state = 13},
  [1613] = {.lex_state = 13, .external_lex_state = 15},
  [1614] = {.lex_state = 13, .external_lex_state = 13},
  [1615] = {.lex_state = 13, .external_lex_state = 15},
  [1616] = {.lex_state = 13, .external_lex_state = 15},
  [1617] = {.lex_state = 13, .external_lex_state = 15},
  [1618] = {.lex_state = 11, .external_lex_state = 9},
  [1619] = {.lex_state = 13, .external_lex_state = 15},
  [1620] = {.lex_state = 11, .external_lex_state = 9},
  [1621] = {.lex_state = 13, .external_lex_state = 15},
  [1622] = {.lex_state = 13, .external_lex_state = 15},
  [1623] = {.lex_state = 13, .external_lex_state = 15},
  [1624] = {.lex_state = 11, .external_lex_state = 9},
  [1625] = {.lex_state = 13, .external_lex_state = 15},
  [1626] = {.lex_state = 13, .external_lex_state = 15},
  [1627] = {.lex_state = 11, .external_lex_state = 15},
  [1628] = {.lex_state = 12, .external_lex_state = 15},
  [1629] = {.lex_state = 11, .external_lex_state = 15},
  [1630] = {.lex_state = 12, .external_lex_state = 15},
  [1631] = {.lex_state = 12, .external_lex_state = 15},
  [1632] = {.lex_state = 12, .external_lex_state = 15},
  [1633] = {.lex_state = 12, .external_lex_state = 15},
  [1634] = {.lex_state = 11, .external_lex_state = 15},
  [1635] = {.lex_state = 11, .external_lex_state = 15},
  [1636] = {.lex_state = 11, .external_lex_state = 15},
  [1637] = {.lex_state = 11, .external_lex_state = 9},
  [1638] = {.lex_state = 12, .external_lex_state = 15},
  [1639] = {.lex_state = 11, .external_lex_state = 15},
  [1640] = {.lex_state = 12, .external_lex_state = 15},
  [1641] = {.lex_state = 12, .external_lex_state = 15},
  [1642] = {.lex_state = 12, .external_lex_state = 15},
  [1643] = {.lex_state = 11, .external_lex_state = 15},
  [1644] = {.lex_state = 11, .external_lex_state = 15},
  [1645] = {.lex_state = 12, .external_lex_state = 15},
  [1646] = {.lex_state = 12, .external_lex_state = 15},
  [1647] = {.lex_state = 5, .external_lex_state = 13},
  [1648] = {.lex_state = 5, .external_lex_state = 13},
  [1649] = {.lex_state = 5, .external_lex_state = 13},
  [1650] = {.lex_state = 12, .external_lex_state = 15},
  [1651] = {.lex_state = 11, .external_lex_state = 15},
  [1652] = {.lex_state = 12, .external_lex_state = 15},
  [1653] = {.lex_state = 5, .external_lex_state = 15},
  [1654] = {.lex_state = 5, .external_lex_state = 15},
  [1655] = {.lex_state = 8, .external_lex_state = 9},
  [1656] = {.lex_state = 52, .external_lex_state = 12},
  [1657] = {.lex_state = 52, .external_lex_state = 12},
  [1658] = {.lex_state = 52, .external_lex_state = 12},
  [1659] = {.lex_state = 8, .external_lex_state = 9},
  [1660] = {.lex_state = 8, .external_lex_state = 9},
  [1661] = {.lex_state = 52, .external_lex_state = 12},
  [1662] = {.lex_state = 8, .external_lex_state = 9},
  [1663] = {.lex_state = 52, .external_lex_state = 12},
  [1664] = {.lex_state = 52, .external_lex_state = 12},
  [1665] = {.lex_state = 8, .external_lex_state = 9},
  [1666] = {.lex_state = 52, .external_lex_state = 12},
  [1667] = {.lex_state = 8, .external_lex_state = 9},
  [1668] = {.lex_state = 8, .external_lex_state = 9},
  [1669] = {.lex_state = 8, .external_lex_state = 9},
  [1670] = {.lex_state = 8, .external_lex_state = 9},
  [1671] = {.lex_state = 52, .external_lex_state = 12},
  [1672] = {.lex_state = 52, .external_lex_state = 13},
  [1673] = {.lex_state = 0, .external_lex_state = 16},
  [1674] = {.lex_state = 0, .external_lex_state = 16},
  [1675] = {.lex_state = 0, .external_lex_state = 16},
  [1676] = {.lex_state = 52, .external_lex_state = 13},
  [1677] = {.lex_state = 0, .external_lex_state = 16},
  [1678] = {.lex_state = 0, .external_lex_state = 16},
  [1679] = {.lex_state = 0, .external_lex_state = 16},
  [1680] = {.lex_state = 0, .external_lex_state = 16},
  [1681] = {.lex_state = 52, .external_lex_state = 13},
  [1682] = {.lex_state = 0, .external_lex_state = 16},
  [1683] = {.lex_state = 0, .external_lex_state = 16},
  [1684] = {.lex_state = 0, .external_lex_state = 16},
  [1685] = {.lex_state = 52, .external_lex_state = 13},
  [1686] = {.lex_state = 52, .external_lex_state = 13},
  [1687] = {.lex_state = 0, .external_lex_state = 16},
  [1688] = {.lex_state = 52, .external_lex_state = 13},
  [1689] = {.lex_state = 52, .external_lex_state = 14},
  [1690] = {.lex_state = 52, .external_lex_state = 13},
  [1691] = {.lex_state = 52, .external_lex_state = 14},
  [1692] = {.lex_state = 52, .external_lex_state = 13},
  [1693] = {.lex_state = 0, .external_lex_state = 16},
  [1694] = {.lex_state = 52, .external_lex_state = 14},
  [1695] = {.lex_state = 52, .external_lex_state = 13},
  [1696] = {.lex_state = 0, .external_lex_state = 16},
  [1697] = {.lex_state = 52, .external_lex_state = 14},
  [1698] = {.lex_state = 8, .external_lex_state = 9},
  [1699] = {.lex_state = 52, .external_lex_state = 13},
  [1700] = {.lex_state = 52, .external_lex_state = 13},
  [1701] = {.lex_state = 0, .external_lex_state = 16},
  [1702] = {.lex_state = 0, .external_lex_state = 16},
  [1703] = {.lex_state = 52, .external_lex_state = 13},
  [1704] = {.lex_state = 52, .external_lex_state = 13},
  [1705] = {.lex_state = 52, .external_lex_state = 14},
  [1706] = {.lex_state = 0, .external_lex_state = 16},
  [1707] = {.lex_state = 52, .external_lex_state = 13},
  [1708] = {.lex_state = 0, .external_lex_state = 16},
  [1709] = {.lex_state = 0, .external_lex_state = 16},
  [1710] = {.lex_state = 52, .external_lex_state = 13},
  [1711] = {.lex_state = 52, .external_lex_state = 14},
  [1712] = {.lex_state = 0, .external_lex_state = 16},
  [1713] = {.lex_state = 52, .external_lex_state = 13},
  [1714] = {.lex_state = 52, .external_lex_state = 13},
  [1715] = {.lex_state = 52, .external_lex_state = 14},
  [1716] = {.lex_state = 52, .external_lex_state = 14},
  [1717] = {.lex_state = 8, .external_lex_state = 15},
  [1718] = {.lex_state = 8, .external_lex_state = 15},
  [1719] = {.lex_state = 8, .external_lex_state = 15},
  [1720] = {.lex_state = 8, .external_lex_state = 15},
  [1721] = {.lex_state = 8, .external_lex_state = 13},
  [1722] = {.lex_state = 8, .external_lex_state = 15},
  [1723] = {.lex_state = 8, .external_lex_state = 13},
  [1724] = {.lex_state = 8, .external_lex_state = 13},
  [1725] = {.lex_state = 8, .external_lex_state = 15},
  [1726] = {.lex_state = 8, .external_lex_state = 9},
  [1727] = {.lex_state = 8, .external_lex_state = 13},
  [1728] = {.lex_state = 52, .external_lex_state = 12},
  [1729] = {.lex_state = 8, .external_lex_state = 13},
  [1730] = {.lex_state = 8, .external_lex_state = 15},
  [1731] = {.lex_state = 52, .external_lex_state = 12},
  [1732] = {.lex_state = 8, .external_lex_state = 13},
  [1733] = {.lex_state = 8, .external_lex_state = 15},
  [1734] = {.lex_state = 8, .external_lex_state = 13},
  [1735] = {.lex_state = 8, .external_lex_state = 15},
  [1736] = {.lex_state = 8, .external_lex_state = 13},
  [1737] = {.lex_state = 8, .external_lex_state = 13},
  [1738] = {.lex_state = 8, .external_lex_state = 13},
  [1739] = {.lex_state = 8, .external_lex_state = 14},
  [1740] = {.lex_state = 8, .external_lex_state = 14},
  [1741] = {.lex_state = 8, .external_lex_state = 14},
  [1742] = {.lex_state = 8, .external_lex_state = 14},
  [1743] = {.lex_state = 8, .external_lex_state = 14},
  [1744] = {.lex_state = 8, .external_lex_state = 14},
  [1745] = {.lex_state = 52, .external_lex_state = 12},
  [1746] = {.lex_state = 8, .external_lex_state = 14},
  [1747] = {.lex_state = 52, .external_lex_state = 12},
  [1748] = {.lex_state = 8, .external_lex_state = 15},
  [1749] = {.lex_state = 52, .external_lex_state = 9},
  [1750] = {.lex_state = 52, .external_lex_state = 12},
  [1751] = {.lex_state = 52, .external_lex_state = 12},
  [1752] = {.lex_state = 8, .external_lex_state = 15},
  [1753] = {.lex_state = 52, .external_lex_state = 12},
  [1754] = {.lex_state = 52, .external_lex_state = 12},
  [1755] = {.lex_state = 52, .external_lex_state = 12},
  [1756] = {.lex_state = 52, .external_lex_state = 12},
  [1757] = {.lex_state = 8, .external_lex_state = 14},
  [1758] = {.lex_state = 52, .external_lex_state = 12},
  [1759] = {.lex_state = 52, .external_lex_state = 12},
  [1760] = {.lex_state = 52, .external_lex_state = 12},
  [1761] = {.lex_state = 52, .external_lex_state = 12},
  [1762] = {.lex_state = 52, .external_lex_state = 12},
  [1763] = {.lex_state = 52, .external_lex_state = 12},
  [1764] = {.lex_state = 52, .external_lex_state = 12},
  [1765] = {.lex_state = 8, .external_lex_state = 15},
  [1766] = {.lex_state = 52, .external_lex_state = 12},
  [1767] = {.lex_state = 8, .external_lex_state = 14},
  [1768] = {.lex_state = 52, .external_lex_state = 12},
  [1769] = {.lex_state = 8, .external_lex_state = 15},
  [1770] = {.lex_state = 52, .external_lex_state = 12},
  [1771] = {.lex_state = 8, .external_lex_state = 14},
  [1772] = {.lex_state = 52, .external_lex_state = 12},
  [1773] = {.lex_state = 8, .external_lex_state = 15},
  [1774] = {.lex_state = 52, .external_lex_state = 12},
  [1775] = {.lex_state = 52, .external_lex_state = 9},
  [1776] = {.lex_state = 52, .external_lex_state = 14},
  [1777] = {.lex_state = 52, .external_lex_state = 13},
  [1778] = {.lex_state = 52, .external_lex_state = 14},
  [1779] = {.lex_state = 52, .external_lex_state = 14},
  [1780] = {.lex_state = 52, .external_lex_state = 12},
  [1781] = {.lex_state = 52, .external_lex_state = 9},
  [1782] = {.lex_state = 52, .external_lex_state = 15},
  [1783] = {.lex_state = 52, .external_lex_state = 14},
  [1784] = {.lex_state = 52, .external_lex_state = 9},
  [1785] = {.lex_state = 9, .external_lex_state = 17},
  [1786] = {.lex_state = 52, .external_lex_state = 14},
  [1787] = {.lex_state = 7, .external_lex_state = 14},
  [1788] = {.lex_state = 52, .external_lex_state = 12},
  [1789] = {.lex_state = 52, .external_lex_state = 12},
  [1790] = {.lex_state = 52, .external_lex_state = 14},
  [1791] = {.lex_state = 52, .external_lex_state = 13},
  [1792] = {.lex_state = 52, .external_lex_state = 13},
  [1793] = {.lex_state = 52, .external_lex_state = 14},
  [1794] = {.lex_state = 7, .external_lex_state = 12},
  [1795] = {.lex_state = 7, .external_lex_state = 13},
  [1796] = {.lex_state = 52, .external_lex_state = 13},
  [1797] = {.lex_state = 52, .external_lex_state = 14},
  [1798] = {.lex_state = 52, .external_lex_state = 9},
  [1799] = {.lex_state = 52, .external_lex_state = 13},
  [1800] = {.lex_state = 52, .external_lex_state = 14},
  [1801] = {.lex_state = 52, .external_lex_state = 14},
  [1802] = {.lex_state = 9, .external_lex_state = 17},
  [1803] = {.lex_state = 52, .external_lex_state = 13},
  [1804] = {.lex_state = 52, .external_lex_state = 14},
  [1805] = {.lex_state = 52, .external_lex_state = 14},
  [1806] = {.lex_state = 52, .external_lex_state = 14},
  [1807] = {.lex_state = 9, .external_lex_state = 17},
  [1808] = {.lex_state = 52, .external_lex_state = 12},
  [1809] = {.lex_state = 52, .external_lex_state = 14},
  [1810] = {.lex_state = 52, .external_lex_state = 14},
  [1811] = {.lex_state = 0, .external_lex_state = 16},
  [1812] = {.lex_state = 52, .external_lex_state = 14},
  [1813] = {.lex_state = 52, .external_lex_state = 9},
  [1814] = {.lex_state = 52, .external_lex_state = 14},
  [1815] = {.lex_state = 52, .external_lex_state = 13},
  [1816] = {.lex_state = 0, .external_lex_state = 16},
  [1817] = {.lex_state = 52, .external_lex_state = 14},
  [1818] = {.lex_state = 52, .external_lex_state = 13},
  [1819] = {.lex_state = 52, .external_lex_state = 13},
  [1820] = {.lex_state = 52, .external_lex_state = 14},
  [1821] = {.lex_state = 52, .external_lex_state = 13},
  [1822] = {.lex_state = 52, .external_lex_state = 14},
  [1823] = {.lex_state = 52, .external_lex_state = 13},
  [1824] = {.lex_state = 52, .external_lex_state = 14},
  [1825] = {.lex_state = 8, .external_lex_state = 15},
  [1826] = {.lex_state = 52, .external_lex_state = 15},
  [1827] = {.lex_state = 52, .external_lex_state = 9},
  [1828] = {.lex_state = 52, .external_lex_state = 9},
  [1829] = {.lex_state = 52, .external_lex_state = 13},
  [1830] = {.lex_state = 52, .external_lex_state = 2},
  [1831] = {.lex_state = 52, .external_lex_state = 9},
  [1832] = {.lex_state = 52, .external_lex_state = 9},
  [1833] = {.lex_state = 9, .external_lex_state = 17},
  [1834] = {.lex_state = 52, .external_lex_state = 14},
  [1835] = {.lex_state = 52, .external_lex_state = 12},
  [1836] = {.lex_state = 52, .external_lex_state = 12},
  [1837] = {.lex_state = 52, .external_lex_state = 12},
  [1838] = {.lex_state = 7, .external_lex_state = 15},
  [1839] = {.lex_state = 52, .external_lex_state = 12},
  [1840] = {.lex_state = 52, .external_lex_state = 14},
  [1841] = {.lex_state = 52, .external_lex_state = 12},
  [1842] = {.lex_state = 52, .external_lex_state = 12},
  [1843] = {.lex_state = 7, .external_lex_state = 13},
  [1844] = {.lex_state = 52, .external_lex_state = 15},
  [1845] = {.lex_state = 52, .external_lex_state = 15},
  [1846] = {.lex_state = 52, .external_lex_state = 8},
  [1847] = {.lex_state = 52, .external_lex_state = 14},
  [1848] = {.lex_state = 7, .external_lex_state = 13},
  [1849] = {.lex_state = 52, .external_lex_state = 9},
  [1850] = {.lex_state = 52, .external_lex_state = 13},
  [1851] = {.lex_state = 52, .external_lex_state = 15},
  [1852] = {.lex_state = 7, .external_lex_state = 12},
  [1853] = {.lex_state = 52, .external_lex_state = 14},
  [1854] = {.lex_state = 52, .external_lex_state = 12},
  [1855] = {.lex_state = 52, .external_lex_state = 13},
  [1856] = {.lex_state = 52, .external_lex_state = 13},
  [1857] = {.lex_state = 52, .external_lex_state = 15},
  [1858] = {.lex_state = 52, .external_lex_state = 12},
  [1859] = {.lex_state = 52, .external_lex_state = 9},
  [1860] = {.lex_state = 52, .external_lex_state = 14},
  [1861] = {.lex_state = 52, .external_lex_state = 14},
  [1862] = {.lex_state = 7, .external_lex_state = 14},
  [1863] = {.lex_state = 52, .external_lex_state = 15},
  [1864] = {.lex_state = 7, .external_lex_state = 14},
  [1865] = {.lex_state = 7, .external_lex_state = 12},
  [1866] = {.lex_state = 52, .external_lex_state = 15},
  [1867] = {.lex_state = 52, .external_lex_state = 12},
  [1868] = {.lex_state = 52, .external_lex_state = 13},
  [1869] = {.lex_state = 52, .external_lex_state = 15},
  [1870] = {.lex_state = 52, .external_lex_state = 12},
  [1871] = {.lex_state = 52, .external_lex_state = 15},
  [1872] = {.lex_state = 52, .external_lex_state = 14},
  [1873] = {.lex_state = 7, .external_lex_state = 13},
  [1874] = {.lex_state = 52, .external_lex_state = 14},
  [1875] = {.lex_state = 52, .external_lex_state = 13},
  [1876] = {.lex_state = 52, .external_lex_state = 13},
  [1877] = {.lex_state = 52, .external_lex_state = 7},
  [1878] = {.lex_state = 52, .external_lex_state = 12},
  [1879] = {.lex_state = 52, .external_lex_state = 14},
  [1880] = {.lex_state = 52, .external_lex_state = 6},
  [1881] = {.lex_state = 52, .external_lex_state = 15},
  [1882] = {.lex_state = 7, .external_lex_state = 14},
  [1883] = {.lex_state = 52, .external_lex_state = 12},
  [1884] = {.lex_state = 7, .external_lex_state = 12},
  [1885] = {.lex_state = 52, .external_lex_state = 15},
  [1886] = {.lex_state = 52, .external_lex_state = 13},
  [1887] = {.lex_state = 0, .external_lex_state = 16},
  [1888] = {.lex_state = 8, .external_lex_state = 13},
  [1889] = {.lex_state = 52, .external_lex_state = 12},
  [1890] = {.lex_state = 8, .external_lex_state = 9},
  [1891] = {.lex_state = 0, .external_lex_state = 16},
  [1892] = {.lex_state = 8, .external_lex_state = 13},
  [1893] = {.lex_state = 52, .external_lex_state = 15},
  [1894] = {.lex_state = 52, .external_lex_state = 13},
  [1895] = {.lex_state = 52, .external_lex_state = 14},
  [1896] = {.lex_state = 8, .external_lex_state = 9},
  [1897] = {.lex_state = 8, .external_lex_state = 9},
  [1898] = {.lex_state = 8, .external_lex_state = 9},
  [1899] = {.lex_state = 8, .external_lex_state = 9},
  [1900] = {.lex_state = 52, .external_lex_state = 9},
  [1901] = {.lex_state = 8, .external_lex_state = 9},
  [1902] = {.lex_state = 52, .external_lex_state = 13},
  [1903] = {.lex_state = 8, .external_lex_state = 13},
  [1904] = {.lex_state = 52, .external_lex_state = 15},
  [1905] = {.lex_state = 0, .external_lex_state = 16},
  [1906] = {.lex_state = 52, .external_lex_state = 13},
  [1907] = {.lex_state = 52, .external_lex_state = 14},
  [1908] = {.lex_state = 52, .external_lex_state = 13},
  [1909] = {.lex_state = 52, .external_lex_state = 15},
  [1910] = {.lex_state = 52, .external_lex_state = 12},
  [1911] = {.lex_state = 52, .external_lex_state = 14},
  [1912] = {.lex_state = 52, .external_lex_state = 15},
  [1913] = {.lex_state = 52, .external_lex_state = 14},
  [1914] = {.lex_state = 52, .external_lex_state = 15},
  [1915] = {.lex_state = 8, .external_lex_state = 15},
  [1916] = {.lex_state = 52, .external_lex_state = 13},
  [1917] = {.lex_state = 52, .external_lex_state = 12},
  [1918] = {.lex_state = 52, .external_lex_state = 13},
  [1919] = {.lex_state = 52, .external_lex_state = 15},
  [1920] = {.lex_state = 52, .external_lex_state = 15},
  [1921] = {.lex_state = 52, .external_lex_state = 14},
  [1922] = {.lex_state = 52, .external_lex_state = 12},
  [1923] = {.lex_state = 8, .external_lex_state = 14},
  [1924] = {.lex_state = 7, .external_lex_state = 9},
  [1925] = {.lex_state = 52, .external_lex_state = 13},
  [1926] = {.lex_state = 8, .external_lex_state = 9},
  [1927] = {.lex_state = 52, .external_lex_state = 14},
  [1928] = {.lex_state = 52, .external_lex_state = 12},
  [1929] = {.lex_state = 0, .external_lex_state = 16},
  [1930] = {.lex_state = 52, .external_lex_state = 15},
  [1931] = {.lex_state = 52, .external_lex_state = 15},
  [1932] = {.lex_state = 7, .external_lex_state = 12},
  [1933] = {.lex_state = 52, .external_lex_state = 15},
  [1934] = {.lex_state = 52, .external_lex_state = 15},
  [1935] = {.lex_state = 7, .external_lex_state = 14},
  [1936] = {.lex_state = 52, .external_lex_state = 14},
  [1937] = {.lex_state = 52, .external_lex_state = 9},
  [1938] = {.lex_state = 8, .external_lex_state = 15},
  [1939] = {.lex_state = 8, .external_lex_state = 15},
  [1940] = {.lex_state = 8, .external_lex_state = 14},
  [1941] = {.lex_state = 52, .external_lex_state = 13},
  [1942] = {.lex_state = 52, .external_lex_state = 14},
  [1943] = {.lex_state = 52, .external_lex_state = 14},
  [1944] = {.lex_state = 52, .external_lex_state = 12},
  [1945] = {.lex_state = 52, .external_lex_state = 13},
  [1946] = {.lex_state = 8, .external_lex_state = 14},
  [1947] = {.lex_state = 52, .external_lex_state = 14},
  [1948] = {.lex_state = 7, .external_lex_state = 9},
  [1949] = {.lex_state = 0, .external_lex_state = 16},
  [1950] = {.lex_state = 52, .external_lex_state = 14},
  [1951] = {.lex_state = 8, .external_lex_state = 13},
  [1952] = {.lex_state = 52, .external_lex_state = 12},
  [1953] = {.lex_state = 52, .external_lex_state = 9},
  [1954] = {.lex_state = 8, .external_lex_state = 13},
  [1955] = {.lex_state = 8, .external_lex_state = 13},
  [1956] = {.lex_state = 0, .external_lex_state = 16},
  [1957] = {.lex_state = 52, .external_lex_state = 13},
  [1958] = {.lex_state = 52, .external_lex_state = 12},
  [1959] = {.lex_state = 52, .external_lex_state = 12},
  [1960] = {.lex_state = 52, .external_lex_state = 15},
  [1961] = {.lex_state = 52, .external_lex_state = 12},
  [1962] = {.lex_state = 52, .external_lex_state = 12},
  [1963] = {.lex_state = 8, .external_lex_state = 9},
  [1964] = {.lex_state = 52, .external_lex_state = 14},
  [1965] = {.lex_state = 8, .external_lex_state = 13},
  [1966] = {.lex_state = 52, .external_lex_state = 13},
  [1967] = {.lex_state = 8, .external_lex_state = 9},
  [1968] = {.lex_state = 8, .external_lex_state = 14},
  [1969] = {.lex_state = 0, .external_lex_state = 16},
  [1970] = {.lex_state = 52, .external_lex_state = 13},
  [1971] = {.lex_state = 52, .external_lex_state = 15},
  [1972] = {.lex_state = 0, .external_lex_state = 16},
  [1973] = {.lex_state = 52, .external_lex_state = 15},
  [1974] = {.lex_state = 52, .external_lex_state = 13},
  [1975] = {.lex_state = 7, .external_lex_state = 13},
  [1976] = {.lex_state = 52, .external_lex_state = 14},
  [1977] = {.lex_state = 8, .external_lex_state = 13},
  [1978] = {.lex_state = 52, .external_lex_state = 12},
  [1979] = {.lex_state = 52, .external_lex_state = 13},
  [1980] = {.lex_state = 52, .external_lex_state = 12},
  [1981] = {.lex_state = 8, .external_lex_state = 9},
  [1982] = {.lex_state = 52, .external_lex_state = 12},
  [1983] = {.lex_state = 52, .external_lex_state = 13},
  [1984] = {.lex_state = 52, .external_lex_state = 13},
  [1985] = {.lex_state = 7, .external_lex_state = 9},
  [1986] = {.lex_state = 8, .external_lex_state = 13},
  [1987] = {.lex_state = 8, .external_lex_state = 13},
  [1988] = {.lex_state = 52, .external_lex_state = 15},
  [1989] = {.lex_state = 52, .external_lex_state = 14},
  [1990] = {.lex_state = 52, .external_lex_state = 13},
  [1991] = {.lex_state = 52, .external_lex_state = 12},
  [1992] = {.lex_state = 52, .external_lex_state = 12},
  [1993] = {.lex_state = 8, .external_lex_state = 14},
  [1994] = {.lex_state = 52, .external_lex_state = 15},
  [1995] = {.lex_state = 52, .external_lex_state = 12},
  [1996] = {.lex_state = 52, .external_lex_state = 12},
  [1997] = {.lex_state = 8, .external_lex_state = 14},
  [1998] = {.lex_state = 52, .external_lex_state = 12},
  [1999] = {.lex_state = 8, .external_lex_state = 14},
  [2000] = {.lex_state = 52, .external_lex_state = 9},
  [2001] = {.lex_state = 8, .external_lex_state = 14},
  [2002] = {.lex_state = 8, .external_lex_state = 14},
  [2003] = {.lex_state = 52, .external_lex_state = 9},
  [2004] = {.lex_state = 52, .external_lex_state = 9},
  [2005] = {.lex_state = 52, .external_lex_state = 15},
  [2006] = {.lex_state = 52, .external_lex_state = 14},
  [2007] = {.lex_state = 7, .external_lex_state = 9},
  [2008] = {.lex_state = 52, .external_lex_state = 14},
  [2009] = {.lex_state = 3, .external_lex_state = 12},
  [2010] = {.lex_state = 52, .external_lex_state = 15},
  [2011] = {.lex_state = 8, .external_lex_state = 14},
  [2012] = {.lex_state = 52, .external_lex_state = 12},
  [2013] = {.lex_state = 52, .external_lex_state = 15},
  [2014] = {.lex_state = 52, .external_lex_state = 15},
  [2015] = {.lex_state = 52, .external_lex_state = 15},
  [2016] = {.lex_state = 8, .external_lex_state = 15},
  [2017] = {.lex_state = 52, .external_lex_state = 15},
  [2018] = {.lex_state = 52, .external_lex_state = 13},
  [2019] = {.lex_state = 52, .external_lex_state = 15},
  [2020] = {.lex_state = 52, .external_lex_state = 14},
  [2021] = {.lex_state = 52, .external_lex_state = 15},
  [2022] = {.lex_state = 52, .external_lex_state = 12},
  [2023] = {.lex_state = 8, .external_lex_state = 14},
  [2024] = {.lex_state = 52, .external_lex_state = 15},
  [2025] = {.lex_state = 52, .external_lex_state = 15},
  [2026] = {.lex_state = 52, .external_lex_state = 12},
  [2027] = {.lex_state = 52, .external_lex_state = 12},
  [2028] = {.lex_state = 52, .external_lex_state = 15},
  [2029] = {.lex_state = 52, .external_lex_state = 15},
  [2030] = {.lex_state = 52, .external_lex_state = 12},
  [2031] = {.lex_state = 8, .external_lex_state = 14},
  [2032] = {.lex_state = 52, .external_lex_state = 12},
  [2033] = {.lex_state = 52, .external_lex_state = 15},
  [2034] = {.lex_state = 52, .external_lex_state = 13},
  [2035] = {.lex_state = 8, .external_lex_state = 15},
  [2036] = {.lex_state = 52, .external_lex_state = 15},
  [2037] = {.lex_state = 52, .external_lex_state = 15},
  [2038] = {.lex_state = 52, .external_lex_state = 12},
  [2039] = {.lex_state = 52, .external_lex_state = 14},
  [2040] = {.lex_state = 8, .external_lex_state = 14},
  [2041] = {.lex_state = 52, .external_lex_state = 9},
  [2042] = {.lex_state = 52, .external_lex_state = 13},
  [2043] = {.lex_state = 52, .external_lex_state = 15},
  [2044] = {.lex_state = 52, .external_lex_state = 15},
  [2045] = {.lex_state = 52, .external_lex_state = 15},
  [2046] = {.lex_state = 52, .external_lex_state = 15},
  [2047] = {.lex_state = 52, .external_lex_state = 15},
  [2048] = {.lex_state = 52, .external_lex_state = 15},
  [2049] = {.lex_state = 52, .external_lex_state = 15},
  [2050] = {.lex_state = 52, .external_lex_state = 15},
  [2051] = {.lex_state = 52, .external_lex_state = 14},
  [2052] = {.lex_state = 52, .external_lex_state = 14},
  [2053] = {.lex_state = 52, .external_lex_state = 15},
  [2054] = {.lex_state = 52, .external_lex_state = 12},
  [2055] = {.lex_state = 52, .external_lex_state = 15},
  [2056] = {.lex_state = 52, .external_lex_state = 15},
  [2057] = {.lex_state = 52, .external_lex_state = 12},
  [2058] = {.lex_state = 52, .external_lex_state = 15},
  [2059] = {.lex_state = 52, .external_lex_state = 9},
  [2060] = {.lex_state = 52, .external_lex_state = 12},
  [2061] = {.lex_state = 52, .external_lex_state = 12},
  [2062] = {.lex_state = 52, .external_lex_state = 15},
  [2063] = {.lex_state = 8, .external_lex_state = 13},
  [2064] = {.lex_state = 52, .external_lex_state = 14},
  [2065] = {.lex_state = 8, .external_lex_state = 15},
  [2066] = {.lex_state = 52, .external_lex_state = 12},
  [2067] = {.lex_state = 8, .external_lex_state = 9},
  [2068] = {.lex_state = 52, .external_lex_state = 15},
  [2069] = {.lex_state = 52, .external_lex_state = 9},
  [2070] = {.lex_state = 52, .external_lex_state = 15},
  [2071] = {.lex_state = 52, .external_lex_state = 15},
  [2072] = {.lex_state = 8, .external_lex_state = 15},
  [2073] = {.lex_state = 52, .external_lex_state = 15},
  [2074] = {.lex_state = 52, .external_lex_state = 14},
  [2075] = {.lex_state = 52, .external_lex_state = 15},
  [2076] = {.lex_state = 52, .external_lex_state = 12},
  [2077] = {.lex_state = 52, .external_lex_state = 15},
  [2078] = {.lex_state = 52, .external_lex_state = 15},
  [2079] = {.lex_state = 52, .external_lex_state = 15},
  [2080] = {.lex_state = 8, .external_lex_state = 15},
  [2081] = {.lex_state = 52, .external_lex_state = 15},
  [2082] = {.lex_state = 52, .external_lex_state = 9},
  [2083] = {.lex_state = 52, .external_lex_state = 13},
  [2084] = {.lex_state = 3, .external_lex_state = 12},
  [2085] = {.lex_state = 52, .external_lex_state = 12},
  [2086] = {.lex_state = 3, .external_lex_state = 12},
  [2087] = {.lex_state = 52, .external_lex_state = 14},
  [2088] = {.lex_state = 52, .external_lex_state = 12},
  [2089] = {.lex_state = 52, .external_lex_state = 15},
  [2090] = {.lex_state = 8, .external_lex_state = 15},
  [2091] = {.lex_state = 52, .external_lex_state = 15},
  [2092] = {.lex_state = 8, .external_lex_state = 14},
  [2093] = {.lex_state = 52, .external_lex_state = 12},
  [2094] = {.lex_state = 52, .external_lex_state = 13},
  [2095] = {.lex_state = 52, .external_lex_state = 15},
  [2096] = {.lex_state = 52, .external_lex_state = 15},
  [2097] = {.lex_state = 52, .external_lex_state = 12},
  [2098] = {.lex_state = 52, .external_lex_state = 13},
  [2099] = {.lex_state = 52, .external_lex_state = 15},
  [2100] = {.lex_state = 52, .external_lex_state = 13},
  [2101] = {.lex_state = 52, .external_lex_state = 15},
  [2102] = {.lex_state = 52, .external_lex_state = 15},
  [2103] = {.lex_state = 52, .external_lex_state = 15},
  [2104] = {.lex_state = 52, .external_lex_state = 13},
  [2105] = {.lex_state = 8, .external_lex_state = 15},
  [2106] = {.lex_state = 52, .external_lex_state = 13},
  [2107] = {.lex_state = 52, .external_lex_state = 15},
  [2108] = {.lex_state = 52, .external_lex_state = 15},
  [2109] = {.lex_state = 52, .external_lex_state = 15},
  [2110] = {.lex_state = 52, .external_lex_state = 14},
  [2111] = {.lex_state = 52, .external_lex_state = 14},
  [2112] = {.lex_state = 52, .external_lex_state = 9},
  [2113] = {.lex_state = 7, .external_lex_state = 15},
  [2114] = {.lex_state = 52, .external_lex_state = 15},
  [2115] = {.lex_state = 52, .external_lex_state = 15},
  [2116] = {.lex_state = 52, .external_lex_state = 9},
  [2117] = {.lex_state = 52, .external_lex_state = 15},
  [2118] = {.lex_state = 52, .external_lex_state = 9},
  [2119] = {.lex_state = 52, .external_lex_state = 9},
  [2120] = {.lex_state = 8, .external_lex_state = 15},
  [2121] = {.lex_state = 52, .external_lex_state = 15},
  [2122] = {.lex_state = 52, .external_lex_state = 9},
  [2123] = {.lex_state = 52, .external_lex_state = 9},
  [2124] = {.lex_state = 52, .external_lex_state = 9},
  [2125] = {.lex_state = 7, .external_lex_state = 15},
  [2126] = {.lex_state = 52, .external_lex_state = 9},
  [2127] = {.lex_state = 52, .external_lex_state = 9},
  [2128] = {.lex_state = 52, .external_lex_state = 9},
  [2129] = {.lex_state = 52, .external_lex_state = 15},
  [2130] = {.lex_state = 52, .external_lex_state = 9},
  [2131] = {.lex_state = 52, .external_lex_state = 15},
  [2132] = {.lex_state = 52, .external_lex_state = 12},
  [2133] = {.lex_state = 52, .external_lex_state = 9},
  [2134] = {.lex_state = 52, .external_lex_state = 18},
  [2135] = {.lex_state = 52, .external_lex_state = 9},
  [2136] = {.lex_state = 52, .external_lex_state = 15},
  [2137] = {.lex_state = 52, .external_lex_state = 15},
  [2138] = {.lex_state = 52, .external_lex_state = 9},
  [2139] = {.lex_state = 52, .external_lex_state = 9},
  [2140] = {.lex_state = 52, .external_lex_state = 9},
  [2141] = {.lex_state = 8, .external_lex_state = 15},
  [2142] = {.lex_state = 52, .external_lex_state = 18},
  [2143] = {.lex_state = 52, .external_lex_state = 12},
  [2144] = {.lex_state = 52, .external_lex_state = 18},
  [2145] = {.lex_state = 52, .external_lex_state = 9},
  [2146] = {.lex_state = 52, .external_lex_state = 15},
  [2147] = {.lex_state = 52, .external_lex_state = 18},
  [2148] = {.lex_state = 52, .external_lex_state = 13},
  [2149] = {.lex_state = 52, .external_lex_state = 18},
  [2150] = {.lex_state = 52, .external_lex_state = 14},
  [2151] = {.lex_state = 52, .external_lex_state = 13},
  [2152] = {.lex_state = 52, .external_lex_state = 15},
  [2153] = {.lex_state = 52, .external_lex_state = 15},
  [2154] = {.lex_state = 52, .external_lex_state = 15},
  [2155] = {.lex_state = 52, .external_lex_state = 12},
  [2156] = {.lex_state = 52, .external_lex_state = 13},
  [2157] = {.lex_state = 52, .external_lex_state = 13},
  [2158] = {.lex_state = 52, .external_lex_state = 13},
  [2159] = {.lex_state = 52, .external_lex_state = 14},
  [2160] = {.lex_state = 52, .external_lex_state = 13},
  [2161] = {.lex_state = 52, .external_lex_state = 13},
  [2162] = {.lex_state = 52, .external_lex_state = 13},
  [2163] = {.lex_state = 52, .external_lex_state = 13},
  [2164] = {.lex_state = 52, .external_lex_state = 13},
  [2165] = {.lex_state = 52, .external_lex_state = 13},
  [2166] = {.lex_state = 52, .external_lex_state = 13},
  [2167] = {.lex_state = 52, .external_lex_state = 13},
  [2168] = {.lex_state = 52, .external_lex_state = 12},
  [2169] = {.lex_state = 52, .external_lex_state = 12},
  [2170] = {.lex_state = 52, .external_lex_state = 12},
  [2171] = {.lex_state = 52, .external_lex_state = 12},
  [2172] = {.lex_state = 52, .external_lex_state = 12},
  [2173] = {.lex_state = 52, .external_lex_state = 12},
  [2174] = {.lex_state = 52, .external_lex_state = 12},
  [2175] = {.lex_state = 52, .external_lex_state = 12},
  [2176] = {.lex_state = 52, .external_lex_state = 13},
  [2177] = {.lex_state = 52, .external_lex_state = 14},
  [2178] = {.lex_state = 52, .external_lex_state = 13},
  [2179] = {.lex_state = 52, .external_lex_state = 12},
  [2180] = {.lex_state = 52, .external_lex_state = 13},
  [2181] = {.lex_state = 52, .external_lex_state = 12},
  [2182] = {.lex_state = 52, .external_lex_state = 13},
  [2183] = {.lex_state = 52, .external_lex_state = 12},
  [2184] = {.lex_state = 52, .external_lex_state = 12},
  [2185] = {.lex_state = 52, .external_lex_state = 12},
  [2186] = {.lex_state = 52, .external_lex_state = 12},
  [2187] = {.lex_state = 52, .external_lex_state = 13},
  [2188] = {.lex_state = 52, .external_lex_state = 12},
  [2189] = {.lex_state = 52, .external_lex_state = 12},
  [2190] = {.lex_state = 52, .external_lex_state = 12},
  [2191] = {.lex_state = 52, .external_lex_state = 12},
  [2192] = {.lex_state = 52, .external_lex_state = 12},
  [2193] = {.lex_state = 52, .external_lex_state = 13},
  [2194] = {.lex_state = 52, .external_lex_state = 12},
  [2195] = {.lex_state = 52, .external_lex_state = 13},
  [2196] = {.lex_state = 52, .external_lex_state = 13},
  [2197] = {.lex_state = 52, .external_lex_state = 12},
  [2198] = {.lex_state = 52, .external_lex_state = 14},
  [2199] = {.lex_state = 52, .external_lex_state = 12},
  [2200] = {.lex_state = 52, .external_lex_state = 13},
  [2201] = {.lex_state = 52, .external_lex_state = 13},
  [2202] = {.lex_state = 52, .external_lex_state = 12},
  [2203] = {.lex_state = 52, .external_lex_state = 13},
  [2204] = {.lex_state = 52, .external_lex_state = 13},
  [2205] = {.lex_state = 52, .external_lex_state = 13},
  [2206] = {.lex_state = 52, .external_lex_state = 13},
  [2207] = {.lex_state = 52, .external_lex_state = 13},
  [2208] = {.lex_state = 52, .external_lex_state = 14},
  [2209] = {.lex_state = 52, .external_lex_state = 14},
  [2210] = {.lex_state = 52, .external_lex_state = 14},
  [2211] = {.lex_state = 52, .external_lex_state = 14},
  [2212] = {.lex_state = 52, .external_lex_state = 13},
  [2213] = {.lex_state = 52, .external_lex_state = 14},
  [2214] = {.lex_state = 52, .external_lex_state = 14},
  [2215] = {.lex_state = 52, .external_lex_state = 14},
  [2216] = {.lex_state = 52, .external_lex_state = 14},
  [2217] = {.lex_state = 52, .external_lex_state = 14},
  [2218] = {.lex_state = 52, .external_lex_state = 14},
  [2219] = {.lex_state = 52, .external_lex_state = 14},
  [2220] = {.lex_state = 52, .external_lex_state = 14},
  [2221] = {.lex_state = 52, .external_lex_state = 14},
  [2222] = {.lex_state = 52, .external_lex_state = 13},
  [2223] = {.lex_state = 52, .external_lex_state = 13},
  [2224] = {.lex_state = 52, .external_lex_state = 13},
  [2225] = {.lex_state = 52, .external_lex_state = 14},
  [2226] = {.lex_state = 52, .external_lex_state = 14},
  [2227] = {.lex_state = 52, .external_lex_state = 14},
  [2228] = {.lex_state = 52, .external_lex_state = 13},
  [2229] = {.lex_state = 52, .external_lex_state = 13},
  [2230] = {.lex_state = 52, .external_lex_state = 14},
  [2231] = {.lex_state = 52, .external_lex_state = 14},
  [2232] = {.lex_state = 52, .external_lex_state = 13},
  [2233] = {.lex_state = 52, .external_lex_state = 14},
  [2234] = {.lex_state = 52, .external_lex_state = 13},
  [2235] = {.lex_state = 52, .external_lex_state = 13},
  [2236] = {.lex_state = 52, .external_lex_state = 14},
  [2237] = {.lex_state = 52, .external_lex_state = 14},
  [2238] = {.lex_state = 52, .external_lex_state = 14},
  [2239] = {.lex_state = 52, .external_lex_state = 13},
  [2240] = {.lex_state = 52, .external_lex_state = 15},
  [2241] = {.lex_state = 52, .external_lex_state = 15},
  [2242] = {.lex_state = 52, .external_lex_state = 15},
  [2243] = {.lex_state = 52, .external_lex_state = 9},
  [2244] = {.lex_state = 52, .external_lex_state = 12},
  [2245] = {.lex_state = 52, .external_lex_state = 14},
  [2246] = {.lex_state = 52, .external_lex_state = 15},
  [2247] = {.lex_state = 52, .external_lex_state = 13},
  [2248] = {.lex_state = 52, .external_lex_state = 12},
  [2249] = {.lex_state = 52, .external_lex_state = 9},
  [2250] = {.lex_state = 52, .external_lex_state = 13},
  [2251] = {.lex_state = 52, .external_lex_state = 13},
  [2252] = {.lex_state = 52, .external_lex_state = 9},
  [2253] = {.lex_state = 52, .external_lex_state = 13},
  [2254] = {.lex_state = 52, .external_lex_state = 13},
  [2255] = {.lex_state = 52, .external_lex_state = 15},
  [2256] = {.lex_state = 52, .external_lex_state = 15},
  [2257] = {.lex_state = 52, .external_lex_state = 9},
  [2258] = {.lex_state = 52, .external_lex_state = 12},
  [2259] = {.lex_state = 52, .external_lex_state = 12},
  [2260] = {.lex_state = 52, .external_lex_state = 15},
  [2261] = {.lex_state = 52, .external_lex_state = 9},
  [2262] = {.lex_state = 52, .external_lex_state = 12},
  [2263] = {.lex_state = 52, .external_lex_state = 13},
  [2264] = {.lex_state = 52, .external_lex_state = 15},
  [2265] = {.lex_state = 52, .external_lex_state = 13},
  [2266] = {.lex_state = 52, .external_lex_state = 13},
  [2267] = {.lex_state = 52, .external_lex_state = 14},
  [2268] = {.lex_state = 52, .external_lex_state = 15},
  [2269] = {.lex_state = 52, .external_lex_state = 14},
  [2270] = {.lex_state = 52, .external_lex_state = 15},
  [2271] = {.lex_state = 52, .external_lex_state = 13},
  [2272] = {.lex_state = 52, .external_lex_state = 9},
  [2273] = {.lex_state = 52, .external_lex_state = 12},
  [2274] = {.lex_state = 52, .external_lex_state = 13},
  [2275] = {.lex_state = 52, .external_lex_state = 12},
  [2276] = {.lex_state = 52, .external_lex_state = 13},
  [2277] = {.lex_state = 52, .external_lex_state = 15},
  [2278] = {.lex_state = 52, .external_lex_state = 13},
  [2279] = {.lex_state = 52, .external_lex_state = 15},
  [2280] = {.lex_state = 52, .external_lex_state = 14},
  [2281] = {.lex_state = 52, .external_lex_state = 14},
  [2282] = {.lex_state = 52, .external_lex_state = 13},
  [2283] = {.lex_state = 52, .external_lex_state = 13},
  [2284] = {.lex_state = 52, .external_lex_state = 12},
  [2285] = {.lex_state = 52, .external_lex_state = 14},
  [2286] = {.lex_state = 52, .external_lex_state = 9},
  [2287] = {.lex_state = 52, .external_lex_state = 14},
  [2288] = {.lex_state = 52, .external_lex_state = 14},
  [2289] = {.lex_state = 52, .external_lex_state = 14},
  [2290] = {.lex_state = 52, .external_lex_state = 13},
  [2291] = {.lex_state = 52, .external_lex_state = 13},
  [2292] = {.lex_state = 8, .external_lex_state = 15},
  [2293] = {.lex_state = 52, .external_lex_state = 9},
  [2294] = {.lex_state = 8, .external_lex_state = 15},
  [2295] = {.lex_state = 52, .external_lex_state = 14},
  [2296] = {.lex_state = 52, .external_lex_state = 14},
  [2297] = {.lex_state = 3, .external_lex_state = 12},
  [2298] = {.lex_state = 52, .external_lex_state = 9},
  [2299] = {.lex_state = 52, .external_lex_state = 12},
  [2300] = {.lex_state = 52, .external_lex_state = 12},
  [2301] = {.lex_state = 52, .external_lex_state = 13},
  [2302] = {.lex_state = 8, .external_lex_state = 15},
  [2303] = {.lex_state = 52, .external_lex_state = 13},
  [2304] = {.lex_state = 52, .external_lex_state = 13},
  [2305] = {.lex_state = 52, .external_lex_state = 13},
  [2306] = {.lex_state = 52, .external_lex_state = 12},
  [2307] = {.lex_state = 52, .external_lex_state = 13},
  [2308] = {.lex_state = 52, .external_lex_state = 13},
  [2309] = {.lex_state = 52, .external_lex_state = 14},
  [2310] = {.lex_state = 8, .external_lex_state = 15},
  [2311] = {.lex_state = 52, .external_lex_state = 14},
  [2312] = {.lex_state = 52, .external_lex_state = 12},
  [2313] = {.lex_state = 52, .external_lex_state = 13},
  [2314] = {.lex_state = 52, .external_lex_state = 12},
  [2315] = {.lex_state = 52, .external_lex_state = 12},
  [2316] = {.lex_state = 52, .external_lex_state = 13},
  [2317] = {.lex_state = 52, .external_lex_state = 15},
  [2318] = {.lex_state = 52, .external_lex_state = 12},
  [2319] = {.lex_state = 52, .external_lex_state = 15},
  [2320] = {.lex_state = 52, .external_lex_state = 15},
  [2321] = {.lex_state = 52, .external_lex_state = 12},
  [2322] = {.lex_state = 52, .external_lex_state = 13},
  [2323] = {.lex_state = 3, .external_lex_state = 12},
  [2324] = {.lex_state = 52, .external_lex_state = 13},
  [2325] = {.lex_state = 3, .external_lex_state = 12},
  [2326] = {.lex_state = 3, .external_lex_state = 12},
  [2327] = {.lex_state = 3, .external_lex_state = 12},
  [2328] = {.lex_state = 52, .external_lex_state = 19},
  [2329] = {.lex_state = 52, .external_lex_state = 15},
  [2330] = {.lex_state = 3, .external_lex_state = 12},
  [2331] = {.lex_state = 3, .external_lex_state = 12},
  [2332] = {.lex_state = 52, .external_lex_state = 14},
  [2333] = {.lex_state = 9, .external_lex_state = 17},
  [2334] = {.lex_state = 52, .external_lex_state = 9},
  [2335] = {.lex_state = 52, .external_lex_state = 14},
  [2336] = {.lex_state = 52, .external_lex_state = 13},
  [2337] = {.lex_state = 52, .external_lex_state = 15},
  [2338] = {.lex_state = 52, .external_lex_state = 15},
  [2339] = {.lex_state = 52, .external_lex_state = 13},
  [2340] = {.lex_state = 52, .external_lex_state = 13},
  [2341] = {.lex_state = 52, .external_lex_state = 12},
  [2342] = {.lex_state = 52, .external_lex_state = 19},
  [2343] = {.lex_state = 52, .external_lex_state = 19},
  [2344] = {.lex_state = 52, .external_lex_state = 14},
  [2345] = {.lex_state = 52, .external_lex_state = 15},
  [2346] = {.lex_state = 52, .external_lex_state = 15},
  [2347] = {.lex_state = 52, .external_lex_state = 13},
  [2348] = {.lex_state = 52, .external_lex_state = 15},
  [2349] = {.lex_state = 52, .external_lex_state = 15},
  [2350] = {.lex_state = 52, .external_lex_state = 12},
  [2351] = {.lex_state = 52, .external_lex_state = 14},
  [2352] = {.lex_state = 52, .external_lex_state = 14},
  [2353] = {.lex_state = 52, .external_lex_state = 14},
  [2354] = {.lex_state = 52, .external_lex_state = 12},
  [2355] = {.lex_state = 52, .external_lex_state = 9},
  [2356] = {.lex_state = 52, .external_lex_state = 15},
  [2357] = {.lex_state = 52, .external_lex_state = 14},
  [2358] = {.lex_state = 52, .external_lex_state = 14},
  [2359] = {.lex_state = 52, .external_lex_state = 14},
  [2360] = {.lex_state = 52, .external_lex_state = 9},
  [2361] = {.lex_state = 52, .external_lex_state = 13},
  [2362] = {.lex_state = 52, .external_lex_state = 13},
  [2363] = {.lex_state = 52, .external_lex_state = 12},
  [2364] = {.lex_state = 52, .external_lex_state = 14},
  [2365] = {.lex_state = 52, .external_lex_state = 12},
  [2366] = {.lex_state = 52, .external_lex_state = 13},
  [2367] = {.lex_state = 52, .external_lex_state = 14},
  [2368] = {.lex_state = 52, .external_lex_state = 14},
  [2369] = {.lex_state = 52, .external_lex_state = 13},
  [2370] = {.lex_state = 52, .external_lex_state = 13},
  [2371] = {.lex_state = 52, .external_lex_state = 13},
  [2372] = {.lex_state = 52, .external_lex_state = 9},
  [2373] = {.lex_state = 52, .external_lex_state = 14},
  [2374] = {.lex_state = 3, .external_lex_state = 12},
  [2375] = {.lex_state = 52, .external_lex_state = 13},
  [2376] = {.lex_state = 52, .external_lex_state = 13},
  [2377] = {.lex_state = 9, .external_lex_state = 17},
  [2378] = {.lex_state = 52, .external_lex_state = 13},
  [2379] = {.lex_state = 52, .external_lex_state = 13},
  [2380] = {.lex_state = 52, .external_lex_state = 13},
  [2381] = {.lex_state = 52, .external_lex_state = 13},
  [2382] = {.lex_state = 52, .external_lex_state = 13},
  [2383] = {.lex_state = 52, .external_lex_state = 14},
  [2384] = {.lex_state = 52, .external_lex_state = 14},
  [2385] = {.lex_state = 52, .external_lex_state = 14},
  [2386] = {.lex_state = 52, .external_lex_state = 13},
  [2387] = {.lex_state = 52, .external_lex_state = 14},
  [2388] = {.lex_state = 52, .external_lex_state = 14},
  [2389] = {.lex_state = 52, .external_lex_state = 13},
  [2390] = {.lex_state = 52, .external_lex_state = 13},
  [2391] = {.lex_state = 52, .external_lex_state = 14},
  [2392] = {.lex_state = 9, .external_lex_state = 17},
  [2393] = {.lex_state = 52, .external_lex_state = 9},
  [2394] = {.lex_state = 52, .external_lex_state = 13},
  [2395] = {.lex_state = 52, .external_lex_state = 14},
  [2396] = {.lex_state = 52, .external_lex_state = 13},
  [2397] = {.lex_state = 52, .external_lex_state = 13},
  [2398] = {.lex_state = 52, .external_lex_state = 15},
  [2399] = {.lex_state = 52, .external_lex_state = 13},
  [2400] = {.lex_state = 52, .external_lex_state = 12},
  [2401] = {.lex_state = 52, .external_lex_state = 13},
  [2402] = {.lex_state = 52, .external_lex_state = 12},
  [2403] = {.lex_state = 52, .external_lex_state = 13},
  [2404] = {.lex_state = 52, .external_lex_state = 9},
  [2405] = {.lex_state = 52, .external_lex_state = 12},
  [2406] = {.lex_state = 52, .external_lex_state = 13},
  [2407] = {.lex_state = 52, .external_lex_state = 13},
  [2408] = {.lex_state = 52, .external_lex_state = 14},
  [2409] = {.lex_state = 52, .external_lex_state = 15},
  [2410] = {.lex_state = 52, .external_lex_state = 14},
  [2411] = {.lex_state = 52, .external_lex_state = 12},
  [2412] = {.lex_state = 52, .external_lex_state = 12},
  [2413] = {.lex_state = 52, .external_lex_state = 12},
  [2414] = {.lex_state = 52, .external_lex_state = 13},
  [2415] = {.lex_state = 52, .external_lex_state = 9},
  [2416] = {.lex_state = 52, .external_lex_state = 13},
  [2417] = {.lex_state = 52, .external_lex_state = 19},
  [2418] = {.lex_state = 52, .external_lex_state = 13},
  [2419] = {.lex_state = 52, .external_lex_state = 19},
  [2420] = {.lex_state = 52, .external_lex_state = 13},
  [2421] = {.lex_state = 52, .external_lex_state = 15},
  [2422] = {.lex_state = 9, .external_lex_state = 17},
  [2423] = {.lex_state = 52, .external_lex_state = 13},
  [2424] = {.lex_state = 52, .external_lex_state = 14},
  [2425] = {.lex_state = 52, .external_lex_state = 14},
  [2426] = {.lex_state = 52, .external_lex_state = 15},
  [2427] = {.lex_state = 52, .external_lex_state = 13},
  [2428] = {.lex_state = 52, .external_lex_state = 13},
  [2429] = {.lex_state = 52, .external_lex_state = 9},
  [2430] = {.lex_state = 52, .external_lex_state = 9},
  [2431] = {.lex_state = 52, .external_lex_state = 14},
  [2432] = {.lex_state = 52, .external_lex_state = 14},
  [2433] = {.lex_state = 52, .external_lex_state = 13},
  [2434] = {.lex_state = 52, .external_lex_state = 13},
  [2435] = {.lex_state = 52, .external_lex_state = 12},
  [2436] = {.lex_state = 52, .external_lex_state = 13},
  [2437] = {.lex_state = 52, .external_lex_state = 13},
  [2438] = {.lex_state = 52, .external_lex_state = 12},
  [2439] = {.lex_state = 52, .external_lex_state = 12},
  [2440] = {.lex_state = 52, .external_lex_state = 15},
  [2441] = {.lex_state = 52, .external_lex_state = 9},
  [2442] = {.lex_state = 52, .external_lex_state = 14},
  [2443] = {.lex_state = 52, .external_lex_state = 13},
  [2444] = {.lex_state = 52, .external_lex_state = 12},
  [2445] = {.lex_state = 52, .external_lex_state = 9},
  [2446] = {.lex_state = 52, .external_lex_state = 12},
  [2447] = {.lex_state = 52, .external_lex_state = 13},
  [2448] = {.lex_state = 52, .external_lex_state = 14},
  [2449] = {.lex_state = 52, .external_lex_state = 9},
  [2450] = {.lex_state = 52, .external_lex_state = 13},
  [2451] = {.lex_state = 52, .external_lex_state = 14},
  [2452] = {.lex_state = 3, .external_lex_state = 12},
  [2453] = {.lex_state = 52, .external_lex_state = 9},
  [2454] = {.lex_state = 52, .external_lex_state = 12},
  [2455] = {.lex_state = 52, .external_lex_state = 15},
  [2456] = {.lex_state = 52, .external_lex_state = 12},
  [2457] = {.lex_state = 52, .external_lex_state = 12},
  [2458] = {.lex_state = 52, .external_lex_state = 15},
  [2459] = {.lex_state = 52, .external_lex_state = 15},
  [2460] = {.lex_state = 52, .external_lex_state = 13},
  [2461] = {.lex_state = 52, .external_lex_state = 19},
  [2462] = {.lex_state = 52, .external_lex_state = 13},
  [2463] = {.lex_state = 52, .external_lex_state = 13},
  [2464] = {.lex_state = 52, .external_lex_state = 12},
  [2465] = {.lex_state = 52, .external_lex_state = 12},
  [2466] = {.lex_state = 52, .external_lex_state = 14},
  [2467] = {.lex_state = 52, .external_lex_state = 14},
  [2468] = {.lex_state = 52, .external_lex_state = 14},
  [2469] = {.lex_state = 52, .external_lex_state = 13},
  [2470] = {.lex_state = 8, .external_lex_state = 15},
  [2471] = {.lex_state = 52, .external_lex_state = 13},
  [2472] = {.lex_state = 52, .external_lex_state = 14},
  [2473] = {.lex_state = 52, .external_lex_state = 13},
  [2474] = {.lex_state = 52, .external_lex_state = 13},
  [2475] = {.lex_state = 52, .external_lex_state = 14},
  [2476] = {.lex_state = 52, .external_lex_state = 14},
  [2477] = {.lex_state = 52, .external_lex_state = 13},
  [2478] = {.lex_state = 52, .external_lex_state = 12},
  [2479] = {.lex_state = 52, .external_lex_state = 15},
  [2480] = {.lex_state = 52, .external_lex_state = 19},
  [2481] = {.lex_state = 52, .external_lex_state = 14},
  [2482] = {.lex_state = 9, .external_lex_state = 17},
  [2483] = {.lex_state = 8, .external_lex_state = 15},
  [2484] = {.lex_state = 52, .external_lex_state = 14},
  [2485] = {.lex_state = 52, .external_lex_state = 14},
  [2486] = {.lex_state = 8, .external_lex_state = 15},
  [2487] = {.lex_state = 52, .external_lex_state = 19},
  [2488] = {.lex_state = 8, .external_lex_state = 15},
  [2489] = {.lex_state = 52, .external_lex_state = 9},
  [2490] = {.lex_state = 52, .external_lex_state = 13},
  [2491] = {.lex_state = 52, .external_lex_state = 13},
  [2492] = {.lex_state = 52, .external_lex_state = 13},
  [2493] = {.lex_state = 52, .external_lex_state = 12},
  [2494] = {.lex_state = 52, .external_lex_state = 13},
  [2495] = {.lex_state = 52, .external_lex_state = 9},
  [2496] = {.lex_state = 52, .external_lex_state = 13},
  [2497] = {.lex_state = 52, .external_lex_state = 12},
  [2498] = {.lex_state = 52, .external_lex_state = 14},
  [2499] = {.lex_state = 52, .external_lex_state = 9},
  [2500] = {.lex_state = 52, .external_lex_state = 9},
  [2501] = {.lex_state = 52, .external_lex_state = 9},
  [2502] = {.lex_state = 52, .external_lex_state = 14},
  [2503] = {.lex_state = 52, .external_lex_state = 9},
  [2504] = {.lex_state = 52, .external_lex_state = 9},
  [2505] = {.lex_state = 52, .external_lex_state = 9},
  [2506] = {.lex_state = 52, .external_lex_state = 9},
  [2507] = {.lex_state = 52, .external_lex_state = 15},
  [2508] = {.lex_state = 52, .external_lex_state = 13},
  [2509] = {.lex_state = 52, .external_lex_state = 15},
  [2510] = {.lex_state = 52, .external_lex_state = 12},
  [2511] = {.lex_state = 52, .external_lex_state = 13},
  [2512] = {.lex_state = 52, .external_lex_state = 9},
  [2513] = {.lex_state = 52, .external_lex_state = 9},
  [2514] = {.lex_state = 52, .external_lex_state = 9},
  [2515] = {.lex_state = 52, .external_lex_state = 9},
  [2516] = {.lex_state = 52, .external_lex_state = 15},
  [2517] = {.lex_state = 52, .external_lex_state = 12},
  [2518] = {.lex_state = 52, .external_lex_state = 15},
  [2519] = {.lex_state = 52, .external_lex_state = 12},
  [2520] = {.lex_state = 52, .external_lex_state = 15},
  [2521] = {.lex_state = 52, .external_lex_state = 18},
  [2522] = {.lex_state = 52, .external_lex_state = 14},
  [2523] = {.lex_state = 9, .external_lex_state = 15},
  [2524] = {.lex_state = 52, .external_lex_state = 15},
  [2525] = {.lex_state = 52, .external_lex_state = 15},
  [2526] = {.lex_state = 52, .external_lex_state = 15},
  [2527] = {.lex_state = 9, .external_lex_state = 15},
  [2528] = {.lex_state = 52, .external_lex_state = 9},
  [2529] = {.lex_state = 52, .external_lex_state = 14},
  [2530] = {.lex_state = 52, .external_lex_state = 14},
  [2531] = {.lex_state = 52, .external_lex_state = 15},
  [2532] = {.lex_state = 52, .external_lex_state = 14},
  [2533] = {.lex_state = 52, .external_lex_state = 15},
  [2534] = {.lex_state = 52, .external_lex_state = 18},
  [2535] = {.lex_state = 52, .external_lex_state = 14},
  [2536] = {.lex_state = 52, .external_lex_state = 15},
  [2537] = {.lex_state = 52, .external_lex_state = 15},
  [2538] = {.lex_state = 52, .external_lex_state = 15},
  [2539] = {.lex_state = 52, .external_lex_state = 15},
  [2540] = {.lex_state = 52, .external_lex_state = 15},
  [2541] = {.lex_state = 9, .external_lex_state = 15},
  [2542] = {.lex_state = 52, .external_lex_state = 15},
  [2543] = {.lex_state = 9, .external_lex_state = 15},
  [2544] = {.lex_state = 52, .external_lex_state = 18},
  [2545] = {.lex_state = 9, .external_lex_state = 15},
  [2546] = {.lex_state = 52, .external_lex_state = 13},
  [2547] = {.lex_state = 9, .external_lex_state = 15},
  [2548] = {.lex_state = 52, .external_lex_state = 13},
  [2549] = {.lex_state = 52, .external_lex_state = 14},
  [2550] = {.lex_state = 52, .external_lex_state = 18},
  [2551] = {.lex_state = 52, .external_lex_state = 15},
  [2552] = {.lex_state = 9, .external_lex_state = 15},
  [2553] = {.lex_state = 52, .external_lex_state = 14},
  [2554] = {.lex_state = 52, .external_lex_state = 14},
  [2555] = {.lex_state = 52, .external_lex_state = 18},
  [2556] = {.lex_state = 52, .external_lex_state = 9},
  [2557] = {.lex_state = 52, .external_lex_state = 9},
  [2558] = {.lex_state = 52, .external_lex_state = 9},
  [2559] = {.lex_state = 52, .external_lex_state = 13},
  [2560] = {.lex_state = 52, .external_lex_state = 18},
  [2561] = {.lex_state = 52, .external_lex_state = 13},
  [2562] = {.lex_state = 52, .external_lex_state = 13},
  [2563] = {.lex_state = 52, .external_lex_state = 13},
  [2564] = {.lex_state = 52, .external_lex_state = 15},
  [2565] = {.lex_state = 52, .external_lex_state = 12},
  [2566] = {.lex_state = 52, .external_lex_state = 15},
  [2567] = {.lex_state = 52, .external_lex_state = 13},
  [2568] = {.lex_state = 52, .external_lex_state = 15},
  [2569] = {.lex_state = 52, .external_lex_state = 12},
  [2570] = {.lex_state = 52, .external_lex_state = 13},
  [2571] = {.lex_state = 52, .external_lex_state = 9},
  [2572] = {.lex_state = 52, .external_lex_state = 15},
  [2573] = {.lex_state = 52, .external_lex_state = 13},
  [2574] = {.lex_state = 52, .external_lex_state = 18},
  [2575] = {.lex_state = 52, .external_lex_state = 13},
  [2576] = {.lex_state = 52, .external_lex_state = 18},
  [2577] = {.lex_state = 9, .external_lex_state = 15},
  [2578] = {.lex_state = 52, .external_lex_state = 9},
  [2579] = {.lex_state = 52, .external_lex_state = 18},
  [2580] = {.lex_state = 9, .external_lex_state = 15},
  [2581] = {.lex_state = 52, .external_lex_state = 15},
  [2582] = {.lex_state = 52, .external_lex_state = 18},
  [2583] = {.lex_state = 52, .external_lex_state = 18},
  [2584] = {.lex_state = 52, .external_lex_state = 18},
  [2585] = {.lex_state = 52, .external_lex_state = 15},
  [2586] = {.lex_state = 52, .external_lex_state = 18},
  [2587] = {.lex_state = 52, .external_lex_state = 13},
  [2588] = {.lex_state = 52, .external_lex_state = 18},
  [2589] = {.lex_state = 52, .external_lex_state = 15},
  [2590] = {.lex_state = 52, .external_lex_state = 18},
  [2591] = {.lex_state = 52, .external_lex_state = 15},
  [2592] = {.lex_state = 9, .external_lex_state = 15},
  [2593] = {.lex_state = 52, .external_lex_state = 18},
  [2594] = {.lex_state = 52, .external_lex_state = 18},
  [2595] = {.lex_state = 52, .external_lex_state = 18},
  [2596] = {.lex_state = 52, .external_lex_state = 13},
  [2597] = {.lex_state = 52, .external_lex_state = 15},
  [2598] = {.lex_state = 52, .external_lex_state = 13},
  [2599] = {.lex_state = 52, .external_lex_state = 9},
  [2600] = {.lex_state = 52, .external_lex_state = 15},
  [2601] = {.lex_state = 52, .external_lex_state = 15},
  [2602] = {.lex_state = 52, .external_lex_state = 13},
  [2603] = {.lex_state = 52, .external_lex_state = 13},
  [2604] = {.lex_state = 52, .external_lex_state = 15},
  [2605] = {.lex_state = 4, .external_lex_state = 15},
  [2606] = {.lex_state = 52, .external_lex_state = 13},
  [2607] = {.lex_state = 52, .external_lex_state = 15},
  [2608] = {.lex_state = 52, .external_lex_state = 15},
  [2609] = {.lex_state = 52, .external_lex_state = 15},
  [2610] = {.lex_state = 52, .external_lex_state = 15},
  [2611] = {.lex_state = 4, .external_lex_state = 15},
  [2612] = {.lex_state = 52, .external_lex_state = 15},
  [2613] = {.lex_state = 52, .external_lex_state = 15},
  [2614] = {.lex_state = 4, .external_lex_state = 15},
  [2615] = {.lex_state = 52, .external_lex_state = 13},
  [2616] = {.lex_state = 52, .external_lex_state = 14},
  [2617] = {.lex_state = 52, .external_lex_state = 12},
  [2618] = {.lex_state = 52, .external_lex_state = 12},
  [2619] = {.lex_state = 52, .external_lex_state = 15},
  [2620] = {.lex_state = 52, .external_lex_state = 15},
  [2621] = {.lex_state = 52, .external_lex_state = 15},
  [2622] = {.lex_state = 52, .external_lex_state = 13},
  [2623] = {.lex_state = 52, .external_lex_state = 14},
  [2624] = {.lex_state = 52, .external_lex_state = 12},
  [2625] = {.lex_state = 52, .external_lex_state = 12},
  [2626] = {.lex_state = 52, .external_lex_state = 13},
  [2627] = {.lex_state = 52, .external_lex_state = 12},
  [2628] = {.lex_state = 52, .external_lex_state = 12},
  [2629] = {.lex_state = 52, .external_lex_state = 13},
  [2630] = {.lex_state = 52, .external_lex_state = 12},
  [2631] = {.lex_state = 52, .external_lex_state = 15},
  [2632] = {.lex_state = 52, .external_lex_state = 12},
  [2633] = {.lex_state = 52, .external_lex_state = 13},
  [2634] = {.lex_state = 52, .external_lex_state = 14},
  [2635] = {.lex_state = 52, .external_lex_state = 13},
  [2636] = {.lex_state = 52, .external_lex_state = 13},
  [2637] = {.lex_state = 52, .external_lex_state = 14},
  [2638] = {.lex_state = 52, .external_lex_state = 12},
  [2639] = {.lex_state = 52, .external_lex_state = 12},
  [2640] = {.lex_state = 52, .external_lex_state = 14},
  [2641] = {.lex_state = 52, .external_lex_state = 12},
  [2642] = {.lex_state = 52, .external_lex_state = 15},
  [2643] = {.lex_state = 52, .external_lex_state = 14},
  [2644] = {.lex_state = 52, .external_lex_state = 13},
  [2645] = {.lex_state = 52, .external_lex_state = 14},
  [2646] = {.lex_state = 52, .external_lex_state = 15},
  [2647] = {.lex_state = 52, .external_lex_state = 14},
  [2648] = {.lex_state = 52, .external_lex_state = 15},
  [2649] = {.lex_state = 52, .external_lex_state = 13},
  [2650] = {.lex_state = 52, .external_lex_state = 15},
  [2651] = {.lex_state = 52, .external_lex_state = 15},
  [2652] = {.lex_state = 52, .external_lex_state = 12},
  [2653] = {.lex_state = 52, .external_lex_state = 15},
  [2654] = {.lex_state = 52, .external_lex_state = 14},
  [2655] = {.lex_state = 52, .external_lex_state = 12},
  [2656] = {.lex_state = 52, .external_lex_state = 12},
  [2657] = {.lex_state = 52, .external_lex_state = 15},
  [2658] = {.lex_state = 52, .external_lex_state = 12},
  [2659] = {.lex_state = 52, .external_lex_state = 15},
  [2660] = {.lex_state = 52, .external_lex_state = 15},
  [2661] = {.lex_state = 52, .external_lex_state = 12},
  [2662] = {.lex_state = 52, .external_lex_state = 12},
  [2663] = {.lex_state = 52, .external_lex_state = 14},
  [2664] = {.lex_state = 52, .external_lex_state = 15},
  [2665] = {.lex_state = 52, .external_lex_state = 12},
  [2666] = {.lex_state = 52, .external_lex_state = 15},
  [2667] = {.lex_state = 52, .external_lex_state = 12},
  [2668] = {.lex_state = 52, .external_lex_state = 12},
  [2669] = {.lex_state = 52, .external_lex_state = 15},
  [2670] = {.lex_state = 52, .external_lex_state = 14},
  [2671] = {.lex_state = 52, .external_lex_state = 12},
  [2672] = {.lex_state = 52, .external_lex_state = 15},
  [2673] = {.lex_state = 52, .external_lex_state = 15},
  [2674] = {.lex_state = 52, .external_lex_state = 14},
  [2675] = {.lex_state = 52, .external_lex_state = 12},
  [2676] = {.lex_state = 52, .external_lex_state = 15},
  [2677] = {.lex_state = 52, .external_lex_state = 15},
  [2678] = {.lex_state = 52, .external_lex_state = 14},
  [2679] = {.lex_state = 52, .external_lex_state = 15},
  [2680] = {.lex_state = 52, .external_lex_state = 15},
  [2681] = {.lex_state = 52, .external_lex_state = 13},
  [2682] = {.lex_state = 52, .external_lex_state = 13},
  [2683] = {.lex_state = 52, .external_lex_state = 15},
  [2684] = {.lex_state = 52, .external_lex_state = 13},
  [2685] = {.lex_state = 52, .external_lex_state = 15},
  [2686] = {.lex_state = 52, .external_lex_state = 13},
  [2687] = {.lex_state = 52, .external_lex_state = 15},
  [2688] = {.lex_state = 52, .external_lex_state = 15},
  [2689] = {.lex_state = 52, .external_lex_state = 15},
  [2690] = {.lex_state = 4, .external_lex_state = 15},
  [2691] = {.lex_state = 4, .external_lex_state = 15},
  [2692] = {.lex_state = 52, .external_lex_state = 15},
  [2693] = {.lex_state = 52, .external_lex_state = 13},
  [2694] = {.lex_state = 52, .external_lex_state = 15},
  [2695] = {.lex_state = 52, .external_lex_state = 14},
  [2696] = {.lex_state = 52, .external_lex_state = 15},
  [2697] = {.lex_state = 52, .external_lex_state = 13},
  [2698] = {.lex_state = 52, .external_lex_state = 15},
  [2699] = {.lex_state = 52, .external_lex_state = 13},
  [2700] = {.lex_state = 52, .external_lex_state = 12},
  [2701] = {.lex_state = 52, .external_lex_state = 15},
  [2702] = {.lex_state = 52, .external_lex_state = 15},
  [2703] = {.lex_state = 52, .external_lex_state = 12},
  [2704] = {.lex_state = 52, .external_lex_state = 15},
  [2705] = {.lex_state = 52, .external_lex_state = 15},
  [2706] = {.lex_state = 52, .external_lex_state = 12},
  [2707] = {.lex_state = 52, .external_lex_state = 13},
  [2708] = {.lex_state = 52, .external_lex_state = 15},
  [2709] = {.lex_state = 52, .external_lex_state = 12},
  [2710] = {.lex_state = 52, .external_lex_state = 15},
  [2711] = {.lex_state = 4, .external_lex_state = 15},
  [2712] = {.lex_state = 52, .external_lex_state = 15},
  [2713] = {.lex_state = 52, .external_lex_state = 13},
  [2714] = {.lex_state = 52, .external_lex_state = 15},
  [2715] = {.lex_state = 52, .external_lex_state = 15},
  [2716] = {.lex_state = 52, .external_lex_state = 15},
  [2717] = {.lex_state = 52, .external_lex_state = 15},
  [2718] = {.lex_state = 52, .external_lex_state = 15},
  [2719] = {.lex_state = 52, .external_lex_state = 15},
  [2720] = {.lex_state = 52, .external_lex_state = 13},
  [2721] = {.lex_state = 52, .external_lex_state = 15},
  [2722] = {.lex_state = 52, .external_lex_state = 12},
  [2723] = {.lex_state = 52, .external_lex_state = 15},
  [2724] = {.lex_state = 52, .external_lex_state = 15},
  [2725] = {.lex_state = 52, .external_lex_state = 15},
  [2726] = {.lex_state = 52, .external_lex_state = 13},
  [2727] = {.lex_state = 52, .external_lex_state = 15},
  [2728] = {.lex_state = 52, .external_lex_state = 15},
  [2729] = {.lex_state = 52, .external_lex_state = 15},
  [2730] = {.lex_state = 52, .external_lex_state = 13},
  [2731] = {.lex_state = 52, .external_lex_state = 15},
  [2732] = {.lex_state = 52, .external_lex_state = 12},
  [2733] = {.lex_state = 52, .external_lex_state = 15},
  [2734] = {.lex_state = 52, .external_lex_state = 15},
  [2735] = {.lex_state = 52, .external_lex_state = 13},
  [2736] = {.lex_state = 52, .external_lex_state = 15},
  [2737] = {.lex_state = 52, .external_lex_state = 12},
  [2738] = {.lex_state = 52, .external_lex_state = 13},
  [2739] = {.lex_state = 52, .external_lex_state = 12},
  [2740] = {.lex_state = 52, .external_lex_state = 14},
  [2741] = {.lex_state = 52, .external_lex_state = 14},
  [2742] = {.lex_state = 52, .external_lex_state = 12},
  [2743] = {.lex_state = 52, .external_lex_state = 15},
  [2744] = {.lex_state = 52, .external_lex_state = 12},
  [2745] = {.lex_state = 52, .external_lex_state = 12},
  [2746] = {.lex_state = 4, .external_lex_state = 15},
  [2747] = {.lex_state = 52, .external_lex_state = 14},
  [2748] = {.lex_state = 52, .external_lex_state = 15},
  [2749] = {.lex_state = 52, .external_lex_state = 15},
  [2750] = {.lex_state = 52, .external_lex_state = 15},
  [2751] = {.lex_state = 52, .external_lex_state = 13},
  [2752] = {.lex_state = 52, .external_lex_state = 15},
  [2753] = {.lex_state = 52, .external_lex_state = 15},
  [2754] = {.lex_state = 52, .external_lex_state = 13},
  [2755] = {.lex_state = 52, .external_lex_state = 12},
  [2756] = {.lex_state = 52, .external_lex_state = 14},
  [2757] = {.lex_state = 52, .external_lex_state = 13},
  [2758] = {.lex_state = 52, .external_lex_state = 12},
  [2759] = {.lex_state = 52, .external_lex_state = 15},
  [2760] = {.lex_state = 52, .external_lex_state = 15},
  [2761] = {.lex_state = 52, .external_lex_state = 15},
  [2762] = {.lex_state = 52, .external_lex_state = 13},
  [2763] = {.lex_state = 52, .external_lex_state = 14},
  [2764] = {.lex_state = 52, .external_lex_state = 15},
  [2765] = {.lex_state = 52, .external_lex_state = 15},
  [2766] = {.lex_state = 52, .external_lex_state = 15},
  [2767] = {.lex_state = 52, .external_lex_state = 14},
  [2768] = {.lex_state = 52, .external_lex_state = 15},
  [2769] = {.lex_state = 52, .external_lex_state = 12},
  [2770] = {.lex_state = 52, .external_lex_state = 13},
  [2771] = {.lex_state = 52, .external_lex_state = 15},
  [2772] = {.lex_state = 52, .external_lex_state = 12},
  [2773] = {.lex_state = 52, .external_lex_state = 15},
  [2774] = {.lex_state = 52, .external_lex_state = 13},
  [2775] = {.lex_state = 4, .external_lex_state = 15},
  [2776] = {.lex_state = 52, .external_lex_state = 12},
  [2777] = {.lex_state = 52, .external_lex_state = 15},
  [2778] = {.lex_state = 52, .external_lex_state = 15},
  [2779] = {.lex_state = 52, .external_lex_state = 15},
  [2780] = {.lex_state = 52, .external_lex_state = 15},
  [2781] = {.lex_state = 52, .external_lex_state = 15},
  [2782] = {.lex_state = 52, .external_lex_state = 15},
  [2783] = {.lex_state = 52, .external_lex_state = 15},
  [2784] = {.lex_state = 52, .external_lex_state = 15},
  [2785] = {.lex_state = 52, .external_lex_state = 15},
  [2786] = {.lex_state = 52, .external_lex_state = 15},
  [2787] = {.lex_state = 52, .external_lex_state = 15},
  [2788] = {.lex_state = 52, .external_lex_state = 15},
  [2789] = {.lex_state = 52, .external_lex_state = 15},
  [2790] = {.lex_state = 52, .external_lex_state = 14},
  [2791] = {.lex_state = 52, .external_lex_state = 15},
  [2792] = {.lex_state = 52, .external_lex_state = 15},
  [2793] = {.lex_state = 52, .external_lex_state = 12},
  [2794] = {.lex_state = 52, .external_lex_state = 12},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym___future__] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_del] = ACTIONS(1),
    [anon_sym_raise] = ACTIONS(1),
    [anon_sym_pass] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_except] = ACTIONS(1),
    [anon_sym_except_STAR] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_nonlocal] = ACTIONS(1),
    [anon_sym_exec] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_lambda] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AT_EQ] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [sym_ellipsis] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [sym_type_conversion] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_none] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(5),
    [sym__newline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym_string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym_escape_interpolation] = ACTIONS(1),
    [sym_string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_module] = STATE(2777),
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1782),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1782),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_match] = ACTIONS(37),
    [anon_sym_async] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_def] = ACTIONS(49),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(81),
  },
  [2] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(850),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [3] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(755),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [4] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(824),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [5] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(2576),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [6] = {
    [sym__statement] = STATE(72),
    [sym__simple_statements] = STATE(72),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(72),
    [sym_match_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_try_statement] = STATE(72),
    [sym_with_statement] = STATE(72),
    [sym_function_definition] = STATE(72),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(72),
    [sym_decorated_definition] = STATE(72),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(689),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(72),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [7] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(797),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [8] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(759),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [9] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(708),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [10] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(723),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [11] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(722),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [12] = {
    [sym__statement] = STATE(72),
    [sym__simple_statements] = STATE(72),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(72),
    [sym_match_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_try_statement] = STATE(72),
    [sym_with_statement] = STATE(72),
    [sym_function_definition] = STATE(72),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(72),
    [sym_decorated_definition] = STATE(72),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(678),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(72),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [13] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(768),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [14] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(815),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [15] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(763),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [16] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(804),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [17] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(837),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [18] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(839),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [19] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(828),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [20] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(812),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [21] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(614),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [22] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(714),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [23] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(843),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [24] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(772),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [25] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(729),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [26] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(704),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [27] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(706),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [28] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(1785),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [29] = {
    [sym__statement] = STATE(70),
    [sym__simple_statements] = STATE(70),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(70),
    [sym_match_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_try_statement] = STATE(70),
    [sym_with_statement] = STATE(70),
    [sym_function_definition] = STATE(70),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(70),
    [sym_decorated_definition] = STATE(70),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(682),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(70),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(81),
  },
  [30] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(2582),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [31] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(626),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [32] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(728),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [33] = {
    [sym__statement] = STATE(70),
    [sym__simple_statements] = STATE(70),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(70),
    [sym_match_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_try_statement] = STATE(70),
    [sym_with_statement] = STATE(70),
    [sym_function_definition] = STATE(70),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(70),
    [sym_decorated_definition] = STATE(70),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(653),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(70),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(81),
  },
  [34] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(713),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [35] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(2584),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [36] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(718),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [37] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(767),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [38] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(1802),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [39] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(770),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [40] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(782),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [41] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(826),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [42] = {
    [sym__statement] = STATE(70),
    [sym__simple_statements] = STATE(70),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(70),
    [sym_match_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_try_statement] = STATE(70),
    [sym_with_statement] = STATE(70),
    [sym_function_definition] = STATE(70),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(70),
    [sym_decorated_definition] = STATE(70),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(686),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(70),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(81),
  },
  [43] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(691),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(113),
    [sym_string_start] = ACTIONS(81),
  },
  [44] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(785),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [45] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(761),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [46] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(819),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [47] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(705),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [48] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(667),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(113),
    [sym_string_start] = ACTIONS(81),
  },
  [49] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(685),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(113),
    [sym_string_start] = ACTIONS(81),
  },
  [50] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(666),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(115),
    [sym_string_start] = ACTIONS(81),
  },
  [51] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(794),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [52] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(820),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [53] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(2595),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [54] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(2593),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [55] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(737),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [56] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(827),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [57] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(735),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [58] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(752),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [59] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(2588),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [60] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(715),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [61] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1826),
    [sym_block] = STATE(687),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(115),
    [sym_string_start] = ACTIONS(81),
  },
  [62] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1782),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1782),
    [ts_builtin_sym_end] = ACTIONS(117),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_match] = ACTIONS(37),
    [anon_sym_async] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_def] = ACTIONS(49),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(81),
  },
  [63] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1826),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(119),
    [sym_string_start] = ACTIONS(81),
  },
  [64] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1826),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(121),
    [anon_sym_import] = ACTIONS(124),
    [anon_sym_from] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_STAR] = ACTIONS(133),
    [anon_sym_print] = ACTIONS(136),
    [anon_sym_assert] = ACTIONS(139),
    [anon_sym_return] = ACTIONS(142),
    [anon_sym_del] = ACTIONS(145),
    [anon_sym_raise] = ACTIONS(148),
    [anon_sym_pass] = ACTIONS(151),
    [anon_sym_break] = ACTIONS(154),
    [anon_sym_continue] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(160),
    [anon_sym_match] = ACTIONS(163),
    [anon_sym_async] = ACTIONS(166),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(172),
    [anon_sym_try] = ACTIONS(175),
    [anon_sym_with] = ACTIONS(178),
    [anon_sym_def] = ACTIONS(181),
    [anon_sym_global] = ACTIONS(184),
    [anon_sym_nonlocal] = ACTIONS(187),
    [anon_sym_exec] = ACTIONS(190),
    [anon_sym_type] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(196),
    [anon_sym_LBRACK] = ACTIONS(199),
    [anon_sym_AT] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACE] = ACTIONS(208),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_not] = ACTIONS(211),
    [anon_sym_TILDE] = ACTIONS(205),
    [anon_sym_lambda] = ACTIONS(214),
    [anon_sym_yield] = ACTIONS(217),
    [sym_ellipsis] = ACTIONS(220),
    [sym_integer] = ACTIONS(223),
    [sym_float] = ACTIONS(220),
    [anon_sym_await] = ACTIONS(226),
    [sym_true] = ACTIONS(223),
    [sym_false] = ACTIONS(223),
    [sym_none] = ACTIONS(223),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(229),
    [sym_string_start] = ACTIONS(231),
  },
  [65] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1826),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(234),
    [sym_string_start] = ACTIONS(81),
  },
  [66] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1826),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(236),
    [sym_string_start] = ACTIONS(81),
  },
  [67] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1782),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1782),
    [ts_builtin_sym_end] = ACTIONS(229),
    [sym_identifier] = ACTIONS(121),
    [anon_sym_import] = ACTIONS(124),
    [anon_sym_from] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_STAR] = ACTIONS(133),
    [anon_sym_print] = ACTIONS(136),
    [anon_sym_assert] = ACTIONS(139),
    [anon_sym_return] = ACTIONS(142),
    [anon_sym_del] = ACTIONS(145),
    [anon_sym_raise] = ACTIONS(148),
    [anon_sym_pass] = ACTIONS(151),
    [anon_sym_break] = ACTIONS(154),
    [anon_sym_continue] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_match] = ACTIONS(241),
    [anon_sym_async] = ACTIONS(244),
    [anon_sym_for] = ACTIONS(247),
    [anon_sym_while] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(253),
    [anon_sym_with] = ACTIONS(256),
    [anon_sym_def] = ACTIONS(259),
    [anon_sym_global] = ACTIONS(184),
    [anon_sym_nonlocal] = ACTIONS(187),
    [anon_sym_exec] = ACTIONS(190),
    [anon_sym_type] = ACTIONS(193),
    [anon_sym_class] = ACTIONS(262),
    [anon_sym_LBRACK] = ACTIONS(199),
    [anon_sym_AT] = ACTIONS(202),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_LBRACE] = ACTIONS(208),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_not] = ACTIONS(211),
    [anon_sym_TILDE] = ACTIONS(205),
    [anon_sym_lambda] = ACTIONS(214),
    [anon_sym_yield] = ACTIONS(217),
    [sym_ellipsis] = ACTIONS(220),
    [sym_integer] = ACTIONS(223),
    [sym_float] = ACTIONS(220),
    [anon_sym_await] = ACTIONS(226),
    [sym_true] = ACTIONS(223),
    [sym_false] = ACTIONS(223),
    [sym_none] = ACTIONS(223),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(231),
  },
  [68] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1826),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(265),
    [sym_string_start] = ACTIONS(81),
  },
  [69] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1826),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(267),
    [sym_string_start] = ACTIONS(81),
  },
  [70] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1826),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(269),
    [sym_string_start] = ACTIONS(81),
  },
  [71] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1826),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(271),
    [sym_string_start] = ACTIONS(81),
  },
  [72] = {
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1826),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1826),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(273),
    [sym_string_start] = ACTIONS(81),
  },
  [73] = {
    [sym_named_expression] = STATE(1720),
    [sym__named_expression_lhs] = STATE(2711),
    [sym_list_splat_pattern] = STATE(1269),
    [sym_as_pattern] = STATE(1720),
    [sym_expression] = STATE(1752),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1720),
    [sym_boolean_operator] = STATE(1720),
    [sym_binary_operator] = STATE(1339),
    [sym_unary_operator] = STATE(1339),
    [sym_comparison_operator] = STATE(1720),
    [sym_lambda] = STATE(1720),
    [sym_attribute] = STATE(1339),
    [sym_subscript] = STATE(1339),
    [sym_call] = STATE(1339),
    [sym_type] = STATE(2120),
    [sym_splat_type] = STATE(2016),
    [sym_generic_type] = STATE(2016),
    [sym_union_type] = STATE(2016),
    [sym_constrained_type] = STATE(2016),
    [sym_member_type] = STATE(2016),
    [sym_list] = STATE(1339),
    [sym_set] = STATE(1339),
    [sym_tuple] = STATE(1339),
    [sym_dictionary] = STATE(1339),
    [sym_list_comprehension] = STATE(1339),
    [sym_dictionary_comprehension] = STATE(1339),
    [sym_set_comprehension] = STATE(1339),
    [sym_generator_expression] = STATE(1339),
    [sym_parenthesized_expression] = STATE(1339),
    [sym_conditional_expression] = STATE(1720),
    [sym_concatenated_string] = STATE(1339),
    [sym_string] = STATE(1033),
    [sym_await] = STATE(1339),
    [sym_identifier] = ACTIONS(275),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(287),
    [anon_sym_print] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(294),
    [anon_sym_match] = ACTIONS(296),
    [anon_sym_async] = ACTIONS(290),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(298),
    [anon_sym_exec] = ACTIONS(290),
    [anon_sym_type] = ACTIONS(296),
    [anon_sym_EQ] = ACTIONS(294),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(307),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_not] = ACTIONS(309),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(312),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_lambda] = ACTIONS(314),
    [anon_sym_PLUS_EQ] = ACTIONS(316),
    [anon_sym_DASH_EQ] = ACTIONS(316),
    [anon_sym_STAR_EQ] = ACTIONS(316),
    [anon_sym_SLASH_EQ] = ACTIONS(316),
    [anon_sym_AT_EQ] = ACTIONS(316),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(316),
    [anon_sym_PERCENT_EQ] = ACTIONS(316),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(316),
    [anon_sym_GT_GT_EQ] = ACTIONS(316),
    [anon_sym_LT_LT_EQ] = ACTIONS(316),
    [anon_sym_AMP_EQ] = ACTIONS(316),
    [anon_sym_CARET_EQ] = ACTIONS(316),
    [anon_sym_PIPE_EQ] = ACTIONS(316),
    [sym_ellipsis] = ACTIONS(318),
    [sym_integer] = ACTIONS(320),
    [sym_float] = ACTIONS(318),
    [anon_sym_await] = ACTIONS(322),
    [sym_true] = ACTIONS(320),
    [sym_false] = ACTIONS(320),
    [sym_none] = ACTIONS(320),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(324),
  },
  [74] = {
    [sym_named_expression] = STATE(1720),
    [sym__named_expression_lhs] = STATE(2711),
    [sym_list_splat_pattern] = STATE(1269),
    [sym_as_pattern] = STATE(1720),
    [sym_expression] = STATE(1752),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1720),
    [sym_boolean_operator] = STATE(1720),
    [sym_binary_operator] = STATE(1339),
    [sym_unary_operator] = STATE(1339),
    [sym_comparison_operator] = STATE(1720),
    [sym_lambda] = STATE(1720),
    [sym_attribute] = STATE(1339),
    [sym_subscript] = STATE(1339),
    [sym_call] = STATE(1339),
    [sym_type] = STATE(2120),
    [sym_splat_type] = STATE(2016),
    [sym_generic_type] = STATE(2016),
    [sym_union_type] = STATE(2016),
    [sym_constrained_type] = STATE(2016),
    [sym_member_type] = STATE(2016),
    [sym_list] = STATE(1339),
    [sym_set] = STATE(1339),
    [sym_tuple] = STATE(1339),
    [sym_dictionary] = STATE(1339),
    [sym_list_comprehension] = STATE(1339),
    [sym_dictionary_comprehension] = STATE(1339),
    [sym_set_comprehension] = STATE(1339),
    [sym_generator_expression] = STATE(1339),
    [sym_parenthesized_expression] = STATE(1339),
    [sym_conditional_expression] = STATE(1720),
    [sym_concatenated_string] = STATE(1339),
    [sym_string] = STATE(1033),
    [sym_await] = STATE(1339),
    [sym_identifier] = ACTIONS(275),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(287),
    [anon_sym_print] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(326),
    [anon_sym_match] = ACTIONS(296),
    [anon_sym_async] = ACTIONS(290),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(298),
    [anon_sym_exec] = ACTIONS(290),
    [anon_sym_type] = ACTIONS(296),
    [anon_sym_EQ] = ACTIONS(294),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(307),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_not] = ACTIONS(309),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(312),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_lambda] = ACTIONS(314),
    [anon_sym_PLUS_EQ] = ACTIONS(316),
    [anon_sym_DASH_EQ] = ACTIONS(316),
    [anon_sym_STAR_EQ] = ACTIONS(316),
    [anon_sym_SLASH_EQ] = ACTIONS(316),
    [anon_sym_AT_EQ] = ACTIONS(316),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(316),
    [anon_sym_PERCENT_EQ] = ACTIONS(316),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(316),
    [anon_sym_GT_GT_EQ] = ACTIONS(316),
    [anon_sym_LT_LT_EQ] = ACTIONS(316),
    [anon_sym_AMP_EQ] = ACTIONS(316),
    [anon_sym_CARET_EQ] = ACTIONS(316),
    [anon_sym_PIPE_EQ] = ACTIONS(316),
    [sym_ellipsis] = ACTIONS(318),
    [sym_integer] = ACTIONS(320),
    [sym_float] = ACTIONS(318),
    [anon_sym_await] = ACTIONS(322),
    [sym_true] = ACTIONS(320),
    [sym_false] = ACTIONS(320),
    [sym_none] = ACTIONS(320),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(324),
  },
  [75] = {
    [sym__simple_statements] = STATE(784),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(636),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1698),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(635),
    [sym_subscript] = STATE(635),
    [sym_call] = STATE(1130),
    [sym_type] = STATE(2072),
    [sym_splat_type] = STATE(2016),
    [sym_generic_type] = STATE(2016),
    [sym_union_type] = STATE(2016),
    [sym_constrained_type] = STATE(2016),
    [sym_member_type] = STATE(2016),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(339),
    [anon_sym_STAR_STAR] = ACTIONS(341),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(343),
    [anon_sym_type] = ACTIONS(345),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(349),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(351),
    [sym__indent] = ACTIONS(353),
    [sym_string_start] = ACTIONS(81),
  },
  [76] = {
    [sym__simple_statements] = STATE(840),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(636),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1698),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(635),
    [sym_subscript] = STATE(635),
    [sym_call] = STATE(1130),
    [sym_type] = STATE(2072),
    [sym_splat_type] = STATE(2016),
    [sym_generic_type] = STATE(2016),
    [sym_union_type] = STATE(2016),
    [sym_constrained_type] = STATE(2016),
    [sym_member_type] = STATE(2016),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(339),
    [anon_sym_STAR_STAR] = ACTIONS(341),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(343),
    [anon_sym_type] = ACTIONS(345),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(349),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(355),
    [sym__indent] = ACTIONS(357),
    [sym_string_start] = ACTIONS(81),
  },
  [77] = {
    [sym__simple_statements] = STATE(762),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(636),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1698),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(635),
    [sym_subscript] = STATE(635),
    [sym_call] = STATE(1130),
    [sym_type] = STATE(2072),
    [sym_splat_type] = STATE(2016),
    [sym_generic_type] = STATE(2016),
    [sym_union_type] = STATE(2016),
    [sym_constrained_type] = STATE(2016),
    [sym_member_type] = STATE(2016),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(339),
    [anon_sym_STAR_STAR] = ACTIONS(341),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(343),
    [anon_sym_type] = ACTIONS(345),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(349),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(359),
    [sym__indent] = ACTIONS(361),
    [sym_string_start] = ACTIONS(81),
  },
  [78] = {
    [sym__simple_statements] = STATE(771),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(636),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1698),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(635),
    [sym_subscript] = STATE(635),
    [sym_call] = STATE(1130),
    [sym_type] = STATE(2072),
    [sym_splat_type] = STATE(2016),
    [sym_generic_type] = STATE(2016),
    [sym_union_type] = STATE(2016),
    [sym_constrained_type] = STATE(2016),
    [sym_member_type] = STATE(2016),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(339),
    [anon_sym_STAR_STAR] = ACTIONS(341),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(343),
    [anon_sym_type] = ACTIONS(345),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(349),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(363),
    [sym__indent] = ACTIONS(365),
    [sym_string_start] = ACTIONS(81),
  },
  [79] = {
    [sym__simple_statements] = STATE(753),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(636),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1698),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(635),
    [sym_subscript] = STATE(635),
    [sym_call] = STATE(1130),
    [sym_type] = STATE(2072),
    [sym_splat_type] = STATE(2016),
    [sym_generic_type] = STATE(2016),
    [sym_union_type] = STATE(2016),
    [sym_constrained_type] = STATE(2016),
    [sym_member_type] = STATE(2016),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(339),
    [anon_sym_STAR_STAR] = ACTIONS(341),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(343),
    [anon_sym_type] = ACTIONS(345),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(349),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(367),
    [sym__indent] = ACTIONS(369),
    [sym_string_start] = ACTIONS(81),
  },
  [80] = {
    [sym__simple_statements] = STATE(778),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(636),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1698),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(635),
    [sym_subscript] = STATE(635),
    [sym_call] = STATE(1130),
    [sym_type] = STATE(2072),
    [sym_splat_type] = STATE(2016),
    [sym_generic_type] = STATE(2016),
    [sym_union_type] = STATE(2016),
    [sym_constrained_type] = STATE(2016),
    [sym_member_type] = STATE(2016),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(339),
    [anon_sym_STAR_STAR] = ACTIONS(341),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(343),
    [anon_sym_type] = ACTIONS(345),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(349),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__indent] = ACTIONS(373),
    [sym_string_start] = ACTIONS(81),
  },
  [81] = {
    [sym__simple_statements] = STATE(790),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(636),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1698),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(635),
    [sym_subscript] = STATE(635),
    [sym_call] = STATE(1130),
    [sym_type] = STATE(2072),
    [sym_splat_type] = STATE(2016),
    [sym_generic_type] = STATE(2016),
    [sym_union_type] = STATE(2016),
    [sym_constrained_type] = STATE(2016),
    [sym_member_type] = STATE(2016),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(339),
    [anon_sym_STAR_STAR] = ACTIONS(341),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(343),
    [anon_sym_type] = ACTIONS(345),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(349),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(375),
    [sym__indent] = ACTIONS(377),
    [sym_string_start] = ACTIONS(81),
  },
  [82] = {
    [sym__simple_statements] = STATE(798),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(636),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1698),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(635),
    [sym_subscript] = STATE(635),
    [sym_call] = STATE(1130),
    [sym_type] = STATE(2072),
    [sym_splat_type] = STATE(2016),
    [sym_generic_type] = STATE(2016),
    [sym_union_type] = STATE(2016),
    [sym_constrained_type] = STATE(2016),
    [sym_member_type] = STATE(2016),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(339),
    [anon_sym_STAR_STAR] = ACTIONS(341),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(343),
    [anon_sym_type] = ACTIONS(345),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(349),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(379),
    [sym__indent] = ACTIONS(381),
    [sym_string_start] = ACTIONS(81),
  },
  [83] = {
    [sym_chevron] = STATE(2116),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_list_splat_pattern] = STATE(1118),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1813),
    [sym_primary_expression] = STATE(860),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_attribute] = STATE(1130),
    [sym_subscript] = STATE(1130),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(385),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(388),
    [anon_sym_print] = ACTIONS(391),
    [anon_sym_GT_GT] = ACTIONS(393),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(326),
    [anon_sym_match] = ACTIONS(395),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(391),
    [anon_sym_type] = ACTIONS(395),
    [anon_sym_EQ] = ACTIONS(294),
    [anon_sym_LBRACK] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(400),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(400),
    [anon_sym_not] = ACTIONS(403),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_PLUS_EQ] = ACTIONS(316),
    [anon_sym_DASH_EQ] = ACTIONS(316),
    [anon_sym_STAR_EQ] = ACTIONS(316),
    [anon_sym_SLASH_EQ] = ACTIONS(316),
    [anon_sym_AT_EQ] = ACTIONS(316),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(316),
    [anon_sym_PERCENT_EQ] = ACTIONS(316),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(316),
    [anon_sym_GT_GT_EQ] = ACTIONS(316),
    [anon_sym_LT_LT_EQ] = ACTIONS(316),
    [anon_sym_AMP_EQ] = ACTIONS(316),
    [anon_sym_CARET_EQ] = ACTIONS(316),
    [anon_sym_PIPE_EQ] = ACTIONS(316),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(406),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(81),
  },
  [84] = {
    [sym_chevron] = STATE(2116),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_list_splat_pattern] = STATE(1118),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1813),
    [sym_primary_expression] = STATE(860),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_attribute] = STATE(1130),
    [sym_subscript] = STATE(1130),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(385),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(388),
    [anon_sym_print] = ACTIONS(391),
    [anon_sym_GT_GT] = ACTIONS(393),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(294),
    [anon_sym_match] = ACTIONS(395),
    [anon_sym_async] = ACTIONS(391),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(391),
    [anon_sym_type] = ACTIONS(395),
    [anon_sym_EQ] = ACTIONS(294),
    [anon_sym_LBRACK] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(400),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(400),
    [anon_sym_not] = ACTIONS(403),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_PLUS_EQ] = ACTIONS(316),
    [anon_sym_DASH_EQ] = ACTIONS(316),
    [anon_sym_STAR_EQ] = ACTIONS(316),
    [anon_sym_SLASH_EQ] = ACTIONS(316),
    [anon_sym_AT_EQ] = ACTIONS(316),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(316),
    [anon_sym_PERCENT_EQ] = ACTIONS(316),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(316),
    [anon_sym_GT_GT_EQ] = ACTIONS(316),
    [anon_sym_LT_LT_EQ] = ACTIONS(316),
    [anon_sym_AMP_EQ] = ACTIONS(316),
    [anon_sym_CARET_EQ] = ACTIONS(316),
    [anon_sym_PIPE_EQ] = ACTIONS(316),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(406),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(81),
  },
  [85] = {
    [sym_named_expression] = STATE(1720),
    [sym__named_expression_lhs] = STATE(2711),
    [sym_list_splat_pattern] = STATE(1269),
    [sym_as_pattern] = STATE(1720),
    [sym_expression] = STATE(1881),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1720),
    [sym_boolean_operator] = STATE(1720),
    [sym_binary_operator] = STATE(1339),
    [sym_unary_operator] = STATE(1339),
    [sym_comparison_operator] = STATE(1720),
    [sym_lambda] = STATE(1720),
    [sym_attribute] = STATE(1339),
    [sym_subscript] = STATE(1339),
    [sym_call] = STATE(1339),
    [sym_list] = STATE(1339),
    [sym_set] = STATE(1339),
    [sym_tuple] = STATE(1339),
    [sym_dictionary] = STATE(1339),
    [sym_list_comprehension] = STATE(1339),
    [sym_dictionary_comprehension] = STATE(1339),
    [sym_set_comprehension] = STATE(1339),
    [sym_generator_expression] = STATE(1339),
    [sym_parenthesized_expression] = STATE(1339),
    [sym_conditional_expression] = STATE(1720),
    [sym_concatenated_string] = STATE(1339),
    [sym_string] = STATE(1033),
    [sym_await] = STATE(1339),
    [sym_identifier] = ACTIONS(408),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(410),
    [anon_sym_print] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(294),
    [anon_sym_match] = ACTIONS(296),
    [anon_sym_async] = ACTIONS(290),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(290),
    [anon_sym_type] = ACTIONS(296),
    [anon_sym_EQ] = ACTIONS(294),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(307),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_not] = ACTIONS(309),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(312),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_lambda] = ACTIONS(314),
    [anon_sym_PLUS_EQ] = ACTIONS(316),
    [anon_sym_DASH_EQ] = ACTIONS(316),
    [anon_sym_STAR_EQ] = ACTIONS(316),
    [anon_sym_SLASH_EQ] = ACTIONS(316),
    [anon_sym_AT_EQ] = ACTIONS(316),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(316),
    [anon_sym_PERCENT_EQ] = ACTIONS(316),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(316),
    [anon_sym_GT_GT_EQ] = ACTIONS(316),
    [anon_sym_LT_LT_EQ] = ACTIONS(316),
    [anon_sym_AMP_EQ] = ACTIONS(316),
    [anon_sym_CARET_EQ] = ACTIONS(316),
    [anon_sym_PIPE_EQ] = ACTIONS(316),
    [sym_ellipsis] = ACTIONS(318),
    [sym_integer] = ACTIONS(320),
    [sym_float] = ACTIONS(318),
    [anon_sym_await] = ACTIONS(322),
    [sym_true] = ACTIONS(320),
    [sym_false] = ACTIONS(320),
    [sym_none] = ACTIONS(320),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(324),
  },
  [86] = {
    [sym_named_expression] = STATE(1720),
    [sym__named_expression_lhs] = STATE(2711),
    [sym_list_splat_pattern] = STATE(1269),
    [sym_as_pattern] = STATE(1720),
    [sym_expression] = STATE(1863),
    [sym_primary_expression] = STATE(968),
    [sym_not_operator] = STATE(1720),
    [sym_boolean_operator] = STATE(1720),
    [sym_binary_operator] = STATE(1339),
    [sym_unary_operator] = STATE(1339),
    [sym_comparison_operator] = STATE(1720),
    [sym_lambda] = STATE(1720),
    [sym_attribute] = STATE(1339),
    [sym_subscript] = STATE(1339),
    [sym_call] = STATE(1339),
    [sym_list] = STATE(1339),
    [sym_set] = STATE(1339),
    [sym_tuple] = STATE(1339),
    [sym_dictionary] = STATE(1339),
    [sym_list_comprehension] = STATE(1339),
    [sym_dictionary_comprehension] = STATE(1339),
    [sym_set_comprehension] = STATE(1339),
    [sym_generator_expression] = STATE(1339),
    [sym_parenthesized_expression] = STATE(1339),
    [sym_conditional_expression] = STATE(1720),
    [sym_concatenated_string] = STATE(1339),
    [sym_string] = STATE(1033),
    [sym_await] = STATE(1339),
    [sym_identifier] = ACTIONS(408),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(410),
    [anon_sym_print] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(294),
    [anon_sym_match] = ACTIONS(296),
    [anon_sym_async] = ACTIONS(290),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(290),
    [anon_sym_type] = ACTIONS(296),
    [anon_sym_EQ] = ACTIONS(294),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(304),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(307),
    [anon_sym_PLUS] = ACTIONS(304),
    [anon_sym_not] = ACTIONS(309),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(312),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_lambda] = ACTIONS(314),
    [anon_sym_PLUS_EQ] = ACTIONS(316),
    [anon_sym_DASH_EQ] = ACTIONS(316),
    [anon_sym_STAR_EQ] = ACTIONS(316),
    [anon_sym_SLASH_EQ] = ACTIONS(316),
    [anon_sym_AT_EQ] = ACTIONS(316),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(316),
    [anon_sym_PERCENT_EQ] = ACTIONS(316),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(316),
    [anon_sym_GT_GT_EQ] = ACTIONS(316),
    [anon_sym_LT_LT_EQ] = ACTIONS(316),
    [anon_sym_AMP_EQ] = ACTIONS(316),
    [anon_sym_CARET_EQ] = ACTIONS(316),
    [anon_sym_PIPE_EQ] = ACTIONS(316),
    [sym_ellipsis] = ACTIONS(318),
    [sym_integer] = ACTIONS(320),
    [sym_float] = ACTIONS(318),
    [anon_sym_await] = ACTIONS(322),
    [sym_true] = ACTIONS(320),
    [sym_false] = ACTIONS(320),
    [sym_none] = ACTIONS(320),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(324),
  },
  [87] = {
    [sym__simple_statements] = STATE(1807),
    [sym_import_statement] = STATE(2445),
    [sym_future_import_statement] = STATE(2445),
    [sym_import_from_statement] = STATE(2445),
    [sym_print_statement] = STATE(2445),
    [sym_assert_statement] = STATE(2445),
    [sym_expression_statement] = STATE(2445),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2445),
    [sym_delete_statement] = STATE(2445),
    [sym_raise_statement] = STATE(2445),
    [sym_pass_statement] = STATE(2445),
    [sym_break_statement] = STATE(2445),
    [sym_continue_statement] = STATE(2445),
    [sym_global_statement] = STATE(2445),
    [sym_nonlocal_statement] = STATE(2445),
    [sym_exec_statement] = STATE(2445),
    [sym_type_alias_statement] = STATE(2445),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(417),
    [sym__indent] = ACTIONS(419),
    [sym_string_start] = ACTIONS(81),
  },
  [88] = {
    [sym__simple_statements] = STATE(654),
    [sym_import_statement] = STATE(2453),
    [sym_future_import_statement] = STATE(2453),
    [sym_import_from_statement] = STATE(2453),
    [sym_print_statement] = STATE(2453),
    [sym_assert_statement] = STATE(2453),
    [sym_expression_statement] = STATE(2453),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2453),
    [sym_delete_statement] = STATE(2453),
    [sym_raise_statement] = STATE(2453),
    [sym_pass_statement] = STATE(2453),
    [sym_break_statement] = STATE(2453),
    [sym_continue_statement] = STATE(2453),
    [sym_global_statement] = STATE(2453),
    [sym_nonlocal_statement] = STATE(2453),
    [sym_exec_statement] = STATE(2453),
    [sym_type_alias_statement] = STATE(2453),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(421),
    [sym__indent] = ACTIONS(423),
    [sym_string_start] = ACTIONS(81),
  },
  [89] = {
    [sym__simple_statements] = STATE(719),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(425),
    [sym__indent] = ACTIONS(427),
    [sym_string_start] = ACTIONS(81),
  },
  [90] = {
    [sym__simple_statements] = STATE(1833),
    [sym_import_statement] = STATE(2445),
    [sym_future_import_statement] = STATE(2445),
    [sym_import_from_statement] = STATE(2445),
    [sym_print_statement] = STATE(2445),
    [sym_assert_statement] = STATE(2445),
    [sym_expression_statement] = STATE(2445),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2445),
    [sym_delete_statement] = STATE(2445),
    [sym_raise_statement] = STATE(2445),
    [sym_pass_statement] = STATE(2445),
    [sym_break_statement] = STATE(2445),
    [sym_continue_statement] = STATE(2445),
    [sym_global_statement] = STATE(2445),
    [sym_nonlocal_statement] = STATE(2445),
    [sym_exec_statement] = STATE(2445),
    [sym_type_alias_statement] = STATE(2445),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(429),
    [sym__indent] = ACTIONS(431),
    [sym_string_start] = ACTIONS(81),
  },
  [91] = {
    [sym__simple_statements] = STATE(816),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(433),
    [sym__indent] = ACTIONS(435),
    [sym_string_start] = ACTIONS(81),
  },
  [92] = {
    [sym__simple_statements] = STATE(2574),
    [sym_import_statement] = STATE(2489),
    [sym_future_import_statement] = STATE(2489),
    [sym_import_from_statement] = STATE(2489),
    [sym_print_statement] = STATE(2489),
    [sym_assert_statement] = STATE(2489),
    [sym_expression_statement] = STATE(2489),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2489),
    [sym_delete_statement] = STATE(2489),
    [sym_raise_statement] = STATE(2489),
    [sym_pass_statement] = STATE(2489),
    [sym_break_statement] = STATE(2489),
    [sym_continue_statement] = STATE(2489),
    [sym_global_statement] = STATE(2489),
    [sym_nonlocal_statement] = STATE(2489),
    [sym_exec_statement] = STATE(2489),
    [sym_type_alias_statement] = STATE(2489),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(437),
    [sym__indent] = ACTIONS(439),
    [sym_string_start] = ACTIONS(81),
  },
  [93] = {
    [sym__simple_statements] = STATE(733),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(441),
    [sym__indent] = ACTIONS(443),
    [sym_string_start] = ACTIONS(81),
  },
  [94] = {
    [sym__simple_statements] = STATE(701),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(445),
    [sym__indent] = ACTIONS(447),
    [sym_string_start] = ACTIONS(81),
  },
  [95] = {
    [sym__simple_statements] = STATE(777),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(449),
    [sym__indent] = ACTIONS(451),
    [sym_string_start] = ACTIONS(81),
  },
  [96] = {
    [sym__simple_statements] = STATE(764),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(453),
    [sym__indent] = ACTIONS(455),
    [sym_string_start] = ACTIONS(81),
  },
  [97] = {
    [sym__simple_statements] = STATE(817),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(457),
    [sym__indent] = ACTIONS(459),
    [sym_string_start] = ACTIONS(81),
  },
  [98] = {
    [sym__simple_statements] = STATE(2579),
    [sym_import_statement] = STATE(2489),
    [sym_future_import_statement] = STATE(2489),
    [sym_import_from_statement] = STATE(2489),
    [sym_print_statement] = STATE(2489),
    [sym_assert_statement] = STATE(2489),
    [sym_expression_statement] = STATE(2489),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2489),
    [sym_delete_statement] = STATE(2489),
    [sym_raise_statement] = STATE(2489),
    [sym_pass_statement] = STATE(2489),
    [sym_break_statement] = STATE(2489),
    [sym_continue_statement] = STATE(2489),
    [sym_global_statement] = STATE(2489),
    [sym_nonlocal_statement] = STATE(2489),
    [sym_exec_statement] = STATE(2489),
    [sym_type_alias_statement] = STATE(2489),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(461),
    [sym__indent] = ACTIONS(463),
    [sym_string_start] = ACTIONS(81),
  },
  [99] = {
    [sym__simple_statements] = STATE(702),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(465),
    [sym__indent] = ACTIONS(467),
    [sym_string_start] = ACTIONS(81),
  },
  [100] = {
    [sym__simple_statements] = STATE(725),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(469),
    [sym__indent] = ACTIONS(471),
    [sym_string_start] = ACTIONS(81),
  },
  [101] = {
    [sym__simple_statements] = STATE(805),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(473),
    [sym__indent] = ACTIONS(475),
    [sym_string_start] = ACTIONS(81),
  },
  [102] = {
    [sym__simple_statements] = STATE(814),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(477),
    [sym__indent] = ACTIONS(479),
    [sym_string_start] = ACTIONS(81),
  },
  [103] = {
    [sym__simple_statements] = STATE(720),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(481),
    [sym__indent] = ACTIONS(483),
    [sym_string_start] = ACTIONS(81),
  },
  [104] = {
    [sym__simple_statements] = STATE(617),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(485),
    [sym__indent] = ACTIONS(487),
    [sym_string_start] = ACTIONS(81),
  },
  [105] = {
    [sym__simple_statements] = STATE(818),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(489),
    [sym__indent] = ACTIONS(491),
    [sym_string_start] = ACTIONS(81),
  },
  [106] = {
    [sym__simple_statements] = STATE(694),
    [sym_import_statement] = STATE(2334),
    [sym_future_import_statement] = STATE(2334),
    [sym_import_from_statement] = STATE(2334),
    [sym_print_statement] = STATE(2334),
    [sym_assert_statement] = STATE(2334),
    [sym_expression_statement] = STATE(2334),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2334),
    [sym_delete_statement] = STATE(2334),
    [sym_raise_statement] = STATE(2334),
    [sym_pass_statement] = STATE(2334),
    [sym_break_statement] = STATE(2334),
    [sym_continue_statement] = STATE(2334),
    [sym_global_statement] = STATE(2334),
    [sym_nonlocal_statement] = STATE(2334),
    [sym_exec_statement] = STATE(2334),
    [sym_type_alias_statement] = STATE(2334),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(493),
    [sym__indent] = ACTIONS(495),
    [sym_string_start] = ACTIONS(81),
  },
  [107] = {
    [sym__simple_statements] = STATE(676),
    [sym_import_statement] = STATE(2334),
    [sym_future_import_statement] = STATE(2334),
    [sym_import_from_statement] = STATE(2334),
    [sym_print_statement] = STATE(2334),
    [sym_assert_statement] = STATE(2334),
    [sym_expression_statement] = STATE(2334),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2334),
    [sym_delete_statement] = STATE(2334),
    [sym_raise_statement] = STATE(2334),
    [sym_pass_statement] = STATE(2334),
    [sym_break_statement] = STATE(2334),
    [sym_continue_statement] = STATE(2334),
    [sym_global_statement] = STATE(2334),
    [sym_nonlocal_statement] = STATE(2334),
    [sym_exec_statement] = STATE(2334),
    [sym_type_alias_statement] = STATE(2334),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(497),
    [sym__indent] = ACTIONS(499),
    [sym_string_start] = ACTIONS(81),
  },
  [108] = {
    [sym__simple_statements] = STATE(813),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(501),
    [sym__indent] = ACTIONS(503),
    [sym_string_start] = ACTIONS(81),
  },
  [109] = {
    [sym__simple_statements] = STATE(649),
    [sym_import_statement] = STATE(2334),
    [sym_future_import_statement] = STATE(2334),
    [sym_import_from_statement] = STATE(2334),
    [sym_print_statement] = STATE(2334),
    [sym_assert_statement] = STATE(2334),
    [sym_expression_statement] = STATE(2334),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2334),
    [sym_delete_statement] = STATE(2334),
    [sym_raise_statement] = STATE(2334),
    [sym_pass_statement] = STATE(2334),
    [sym_break_statement] = STATE(2334),
    [sym_continue_statement] = STATE(2334),
    [sym_global_statement] = STATE(2334),
    [sym_nonlocal_statement] = STATE(2334),
    [sym_exec_statement] = STATE(2334),
    [sym_type_alias_statement] = STATE(2334),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(505),
    [sym__indent] = ACTIONS(507),
    [sym_string_start] = ACTIONS(81),
  },
  [110] = {
    [sym__simple_statements] = STATE(724),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(509),
    [sym__indent] = ACTIONS(511),
    [sym_string_start] = ACTIONS(81),
  },
  [111] = {
    [sym__simple_statements] = STATE(829),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(513),
    [sym__indent] = ACTIONS(515),
    [sym_string_start] = ACTIONS(81),
  },
  [112] = {
    [sym__simple_statements] = STATE(793),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(517),
    [sym__indent] = ACTIONS(519),
    [sym_string_start] = ACTIONS(81),
  },
  [113] = {
    [sym__simple_statements] = STATE(849),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(521),
    [sym__indent] = ACTIONS(523),
    [sym_string_start] = ACTIONS(81),
  },
  [114] = {
    [sym__simple_statements] = STATE(712),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(525),
    [sym__indent] = ACTIONS(527),
    [sym_string_start] = ACTIONS(81),
  },
  [115] = {
    [sym__simple_statements] = STATE(806),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(529),
    [sym__indent] = ACTIONS(531),
    [sym_string_start] = ACTIONS(81),
  },
  [116] = {
    [sym__simple_statements] = STATE(2583),
    [sym_import_statement] = STATE(2489),
    [sym_future_import_statement] = STATE(2489),
    [sym_import_from_statement] = STATE(2489),
    [sym_print_statement] = STATE(2489),
    [sym_assert_statement] = STATE(2489),
    [sym_expression_statement] = STATE(2489),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2489),
    [sym_delete_statement] = STATE(2489),
    [sym_raise_statement] = STATE(2489),
    [sym_pass_statement] = STATE(2489),
    [sym_break_statement] = STATE(2489),
    [sym_continue_statement] = STATE(2489),
    [sym_global_statement] = STATE(2489),
    [sym_nonlocal_statement] = STATE(2489),
    [sym_exec_statement] = STATE(2489),
    [sym_type_alias_statement] = STATE(2489),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(533),
    [sym__indent] = ACTIONS(535),
    [sym_string_start] = ACTIONS(81),
  },
  [117] = {
    [sym__simple_statements] = STATE(655),
    [sym_import_statement] = STATE(2415),
    [sym_future_import_statement] = STATE(2415),
    [sym_import_from_statement] = STATE(2415),
    [sym_print_statement] = STATE(2415),
    [sym_assert_statement] = STATE(2415),
    [sym_expression_statement] = STATE(2415),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2415),
    [sym_delete_statement] = STATE(2415),
    [sym_raise_statement] = STATE(2415),
    [sym_pass_statement] = STATE(2415),
    [sym_break_statement] = STATE(2415),
    [sym_continue_statement] = STATE(2415),
    [sym_global_statement] = STATE(2415),
    [sym_nonlocal_statement] = STATE(2415),
    [sym_exec_statement] = STATE(2415),
    [sym_type_alias_statement] = STATE(2415),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(537),
    [sym__indent] = ACTIONS(539),
    [sym_string_start] = ACTIONS(81),
  },
  [118] = {
    [sym__simple_statements] = STATE(707),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(541),
    [sym__indent] = ACTIONS(543),
    [sym_string_start] = ACTIONS(81),
  },
  [119] = {
    [sym__simple_statements] = STATE(810),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(545),
    [sym__indent] = ACTIONS(547),
    [sym_string_start] = ACTIONS(81),
  },
  [120] = {
    [sym__simple_statements] = STATE(2550),
    [sym_import_statement] = STATE(2489),
    [sym_future_import_statement] = STATE(2489),
    [sym_import_from_statement] = STATE(2489),
    [sym_print_statement] = STATE(2489),
    [sym_assert_statement] = STATE(2489),
    [sym_expression_statement] = STATE(2489),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2489),
    [sym_delete_statement] = STATE(2489),
    [sym_raise_statement] = STATE(2489),
    [sym_pass_statement] = STATE(2489),
    [sym_break_statement] = STATE(2489),
    [sym_continue_statement] = STATE(2489),
    [sym_global_statement] = STATE(2489),
    [sym_nonlocal_statement] = STATE(2489),
    [sym_exec_statement] = STATE(2489),
    [sym_type_alias_statement] = STATE(2489),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(549),
    [sym__indent] = ACTIONS(551),
    [sym_string_start] = ACTIONS(81),
  },
  [121] = {
    [sym__simple_statements] = STATE(697),
    [sym_import_statement] = STATE(2430),
    [sym_future_import_statement] = STATE(2430),
    [sym_import_from_statement] = STATE(2430),
    [sym_print_statement] = STATE(2430),
    [sym_assert_statement] = STATE(2430),
    [sym_expression_statement] = STATE(2430),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2430),
    [sym_delete_statement] = STATE(2430),
    [sym_raise_statement] = STATE(2430),
    [sym_pass_statement] = STATE(2430),
    [sym_break_statement] = STATE(2430),
    [sym_continue_statement] = STATE(2430),
    [sym_global_statement] = STATE(2430),
    [sym_nonlocal_statement] = STATE(2430),
    [sym_exec_statement] = STATE(2430),
    [sym_type_alias_statement] = STATE(2430),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(553),
    [sym__indent] = ACTIONS(555),
    [sym_string_start] = ACTIONS(81),
  },
  [122] = {
    [sym__simple_statements] = STATE(692),
    [sym_import_statement] = STATE(2453),
    [sym_future_import_statement] = STATE(2453),
    [sym_import_from_statement] = STATE(2453),
    [sym_print_statement] = STATE(2453),
    [sym_assert_statement] = STATE(2453),
    [sym_expression_statement] = STATE(2453),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2453),
    [sym_delete_statement] = STATE(2453),
    [sym_raise_statement] = STATE(2453),
    [sym_pass_statement] = STATE(2453),
    [sym_break_statement] = STATE(2453),
    [sym_continue_statement] = STATE(2453),
    [sym_global_statement] = STATE(2453),
    [sym_nonlocal_statement] = STATE(2453),
    [sym_exec_statement] = STATE(2453),
    [sym_type_alias_statement] = STATE(2453),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(557),
    [sym__indent] = ACTIONS(559),
    [sym_string_start] = ACTIONS(81),
  },
  [123] = {
    [sym__simple_statements] = STATE(740),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(561),
    [sym__indent] = ACTIONS(563),
    [sym_string_start] = ACTIONS(81),
  },
  [124] = {
    [sym__simple_statements] = STATE(738),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(565),
    [sym__indent] = ACTIONS(567),
    [sym_string_start] = ACTIONS(81),
  },
  [125] = {
    [sym__simple_statements] = STATE(2586),
    [sym_import_statement] = STATE(2489),
    [sym_future_import_statement] = STATE(2489),
    [sym_import_from_statement] = STATE(2489),
    [sym_print_statement] = STATE(2489),
    [sym_assert_statement] = STATE(2489),
    [sym_expression_statement] = STATE(2489),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2489),
    [sym_delete_statement] = STATE(2489),
    [sym_raise_statement] = STATE(2489),
    [sym_pass_statement] = STATE(2489),
    [sym_break_statement] = STATE(2489),
    [sym_continue_statement] = STATE(2489),
    [sym_global_statement] = STATE(2489),
    [sym_nonlocal_statement] = STATE(2489),
    [sym_exec_statement] = STATE(2489),
    [sym_type_alias_statement] = STATE(2489),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(569),
    [sym__indent] = ACTIONS(571),
    [sym_string_start] = ACTIONS(81),
  },
  [126] = {
    [sym__simple_statements] = STATE(709),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(573),
    [sym__indent] = ACTIONS(575),
    [sym_string_start] = ACTIONS(81),
  },
  [127] = {
    [sym__simple_statements] = STATE(673),
    [sym_import_statement] = STATE(2453),
    [sym_future_import_statement] = STATE(2453),
    [sym_import_from_statement] = STATE(2453),
    [sym_print_statement] = STATE(2453),
    [sym_assert_statement] = STATE(2453),
    [sym_expression_statement] = STATE(2453),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2453),
    [sym_delete_statement] = STATE(2453),
    [sym_raise_statement] = STATE(2453),
    [sym_pass_statement] = STATE(2453),
    [sym_break_statement] = STATE(2453),
    [sym_continue_statement] = STATE(2453),
    [sym_global_statement] = STATE(2453),
    [sym_nonlocal_statement] = STATE(2453),
    [sym_exec_statement] = STATE(2453),
    [sym_type_alias_statement] = STATE(2453),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(577),
    [sym__indent] = ACTIONS(579),
    [sym_string_start] = ACTIONS(81),
  },
  [128] = {
    [sym__simple_statements] = STATE(823),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(581),
    [sym__indent] = ACTIONS(583),
    [sym_string_start] = ACTIONS(81),
  },
  [129] = {
    [sym__simple_statements] = STATE(2594),
    [sym_import_statement] = STATE(2489),
    [sym_future_import_statement] = STATE(2489),
    [sym_import_from_statement] = STATE(2489),
    [sym_print_statement] = STATE(2489),
    [sym_assert_statement] = STATE(2489),
    [sym_expression_statement] = STATE(2489),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2489),
    [sym_delete_statement] = STATE(2489),
    [sym_raise_statement] = STATE(2489),
    [sym_pass_statement] = STATE(2489),
    [sym_break_statement] = STATE(2489),
    [sym_continue_statement] = STATE(2489),
    [sym_global_statement] = STATE(2489),
    [sym_nonlocal_statement] = STATE(2489),
    [sym_exec_statement] = STATE(2489),
    [sym_type_alias_statement] = STATE(2489),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(585),
    [sym__indent] = ACTIONS(587),
    [sym_string_start] = ACTIONS(81),
  },
  [130] = {
    [sym__simple_statements] = STATE(789),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(589),
    [sym__indent] = ACTIONS(591),
    [sym_string_start] = ACTIONS(81),
  },
  [131] = {
    [sym__simple_statements] = STATE(791),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(593),
    [sym__indent] = ACTIONS(595),
    [sym_string_start] = ACTIONS(81),
  },
  [132] = {
    [sym__simple_statements] = STATE(711),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(597),
    [sym__indent] = ACTIONS(599),
    [sym_string_start] = ACTIONS(81),
  },
  [133] = {
    [sym__simple_statements] = STATE(736),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(601),
    [sym__indent] = ACTIONS(603),
    [sym_string_start] = ACTIONS(81),
  },
  [134] = {
    [sym__simple_statements] = STATE(835),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(605),
    [sym__indent] = ACTIONS(607),
    [sym_string_start] = ACTIONS(81),
  },
  [135] = {
    [sym__simple_statements] = STATE(795),
    [sym_import_statement] = STATE(2286),
    [sym_future_import_statement] = STATE(2286),
    [sym_import_from_statement] = STATE(2286),
    [sym_print_statement] = STATE(2286),
    [sym_assert_statement] = STATE(2286),
    [sym_expression_statement] = STATE(2286),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2286),
    [sym_delete_statement] = STATE(2286),
    [sym_raise_statement] = STATE(2286),
    [sym_pass_statement] = STATE(2286),
    [sym_break_statement] = STATE(2286),
    [sym_continue_statement] = STATE(2286),
    [sym_global_statement] = STATE(2286),
    [sym_nonlocal_statement] = STATE(2286),
    [sym_exec_statement] = STATE(2286),
    [sym_type_alias_statement] = STATE(2286),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(609),
    [sym__indent] = ACTIONS(611),
    [sym_string_start] = ACTIONS(81),
  },
  [136] = {
    [sym__simple_statements] = STATE(618),
    [sym_import_statement] = STATE(2243),
    [sym_future_import_statement] = STATE(2243),
    [sym_import_from_statement] = STATE(2243),
    [sym_print_statement] = STATE(2243),
    [sym_assert_statement] = STATE(2243),
    [sym_expression_statement] = STATE(2243),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2243),
    [sym_delete_statement] = STATE(2243),
    [sym_raise_statement] = STATE(2243),
    [sym_pass_statement] = STATE(2243),
    [sym_break_statement] = STATE(2243),
    [sym_continue_statement] = STATE(2243),
    [sym_global_statement] = STATE(2243),
    [sym_nonlocal_statement] = STATE(2243),
    [sym_exec_statement] = STATE(2243),
    [sym_type_alias_statement] = STATE(2243),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(613),
    [sym__indent] = ACTIONS(615),
    [sym_string_start] = ACTIONS(81),
  },
  [137] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(617),
    [sym_string_start] = ACTIONS(81),
  },
  [138] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(619),
    [sym_string_start] = ACTIONS(81),
  },
  [139] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(621),
    [sym_string_start] = ACTIONS(81),
  },
  [140] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(623),
    [sym_string_start] = ACTIONS(81),
  },
  [141] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(625),
    [sym_string_start] = ACTIONS(81),
  },
  [142] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(627),
    [sym_string_start] = ACTIONS(81),
  },
  [143] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(629),
    [sym_string_start] = ACTIONS(81),
  },
  [144] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(631),
    [sym_string_start] = ACTIONS(81),
  },
  [145] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(633),
    [sym_string_start] = ACTIONS(81),
  },
  [146] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(635),
    [sym_string_start] = ACTIONS(81),
  },
  [147] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(637),
    [sym_string_start] = ACTIONS(81),
  },
  [148] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(639),
    [sym_string_start] = ACTIONS(81),
  },
  [149] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(641),
    [sym_string_start] = ACTIONS(81),
  },
  [150] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(643),
    [sym_string_start] = ACTIONS(81),
  },
  [151] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(645),
    [sym_string_start] = ACTIONS(81),
  },
  [152] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(647),
    [sym_string_start] = ACTIONS(81),
  },
  [153] = {
    [sym_import_statement] = STATE(2556),
    [sym_future_import_statement] = STATE(2556),
    [sym_import_from_statement] = STATE(2556),
    [sym_print_statement] = STATE(2556),
    [sym_assert_statement] = STATE(2556),
    [sym_expression_statement] = STATE(2556),
    [sym_named_expression] = STATE(1659),
    [sym__named_expression_lhs] = STATE(2775),
    [sym_return_statement] = STATE(2556),
    [sym_delete_statement] = STATE(2556),
    [sym_raise_statement] = STATE(2556),
    [sym_pass_statement] = STATE(2556),
    [sym_break_statement] = STATE(2556),
    [sym_continue_statement] = STATE(2556),
    [sym_global_statement] = STATE(2556),
    [sym_nonlocal_statement] = STATE(2556),
    [sym_exec_statement] = STATE(2556),
    [sym_type_alias_statement] = STATE(2556),
    [sym_pattern] = STATE(1639),
    [sym_tuple_pattern] = STATE(1644),
    [sym_list_pattern] = STATE(1644),
    [sym_list_splat_pattern] = STATE(632),
    [sym_as_pattern] = STATE(1659),
    [sym_expression] = STATE(1798),
    [sym_primary_expression] = STATE(970),
    [sym_not_operator] = STATE(1659),
    [sym_boolean_operator] = STATE(1659),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_comparison_operator] = STATE(1659),
    [sym_lambda] = STATE(1659),
    [sym_assignment] = STATE(2504),
    [sym_augmented_assignment] = STATE(2504),
    [sym_pattern_list] = STATE(1651),
    [sym_yield] = STATE(2504),
    [sym_attribute] = STATE(641),
    [sym_subscript] = STATE(641),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_conditional_expression] = STATE(1659),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(413),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(81),
  },
  [154] = {
    [sym_list_splat_pattern] = STATE(1118),
    [sym_primary_expression] = STATE(987),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_attribute] = STATE(1130),
    [sym_subscript] = STATE(1130),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(651),
    [anon_sym_print] = ACTIONS(653),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(294),
    [anon_sym_match] = ACTIONS(655),
    [anon_sym_async] = ACTIONS(653),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(653),
    [anon_sym_type] = ACTIONS(655),
    [anon_sym_EQ] = ACTIONS(294),
    [anon_sym_LBRACK] = ACTIONS(657),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(659),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(659),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_PLUS_EQ] = ACTIONS(316),
    [anon_sym_DASH_EQ] = ACTIONS(316),
    [anon_sym_STAR_EQ] = ACTIONS(316),
    [anon_sym_SLASH_EQ] = ACTIONS(316),
    [anon_sym_AT_EQ] = ACTIONS(316),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(316),
    [anon_sym_PERCENT_EQ] = ACTIONS(316),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(316),
    [anon_sym_GT_GT_EQ] = ACTIONS(316),
    [anon_sym_LT_LT_EQ] = ACTIONS(316),
    [anon_sym_AMP_EQ] = ACTIONS(316),
    [anon_sym_CARET_EQ] = ACTIONS(316),
    [anon_sym_PIPE_EQ] = ACTIONS(316),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(661),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(81),
  },
  [155] = {
    [sym_list_splat_pattern] = STATE(1118),
    [sym_primary_expression] = STATE(987),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_attribute] = STATE(1130),
    [sym_subscript] = STATE(1130),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(651),
    [anon_sym_print] = ACTIONS(653),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(326),
    [anon_sym_match] = ACTIONS(655),
    [anon_sym_async] = ACTIONS(653),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(653),
    [anon_sym_type] = ACTIONS(655),
    [anon_sym_EQ] = ACTIONS(294),
    [anon_sym_LBRACK] = ACTIONS(657),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(659),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(659),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_PLUS_EQ] = ACTIONS(316),
    [anon_sym_DASH_EQ] = ACTIONS(316),
    [anon_sym_STAR_EQ] = ACTIONS(316),
    [anon_sym_SLASH_EQ] = ACTIONS(316),
    [anon_sym_AT_EQ] = ACTIONS(316),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(316),
    [anon_sym_PERCENT_EQ] = ACTIONS(316),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(316),
    [anon_sym_GT_GT_EQ] = ACTIONS(316),
    [anon_sym_LT_LT_EQ] = ACTIONS(316),
    [anon_sym_AMP_EQ] = ACTIONS(316),
    [anon_sym_CARET_EQ] = ACTIONS(316),
    [anon_sym_PIPE_EQ] = ACTIONS(316),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(661),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(81),
  },
  [156] = {
    [sym_list_splat_pattern] = STATE(1269),
    [sym_primary_expression] = STATE(1107),
    [sym_binary_operator] = STATE(1339),
    [sym_unary_operator] = STATE(1339),
    [sym_attribute] = STATE(1339),
    [sym_subscript] = STATE(1339),
    [sym_call] = STATE(1339),
    [sym_list] = STATE(1339),
    [sym_set] = STATE(1339),
    [sym_tuple] = STATE(1339),
    [sym_dictionary] = STATE(1339),
    [sym_list_comprehension] = STATE(1339),
    [sym_dictionary_comprehension] = STATE(1339),
    [sym_set_comprehension] = STATE(1339),
    [sym_generator_expression] = STATE(1339),
    [sym_parenthesized_expression] = STATE(1339),
    [sym_concatenated_string] = STATE(1339),
    [sym_string] = STATE(1033),
    [sym_await] = STATE(1339),
    [sym_identifier] = ACTIONS(320),
    [anon_sym_SEMI] = ACTIONS(663),
    [anon_sym_DOT] = ACTIONS(665),
    [anon_sym_LPAREN] = ACTIONS(668),
    [anon_sym_COMMA] = ACTIONS(663),
    [anon_sym_as] = ACTIONS(670),
    [anon_sym_STAR] = ACTIONS(672),
    [anon_sym_print] = ACTIONS(674),
    [anon_sym_GT_GT] = ACTIONS(665),
    [anon_sym_if] = ACTIONS(670),
    [anon_sym_COLON] = ACTIONS(663),
    [anon_sym_match] = ACTIONS(676),
    [anon_sym_async] = ACTIONS(674),
    [anon_sym_in] = ACTIONS(670),
    [anon_sym_STAR_STAR] = ACTIONS(665),
    [anon_sym_exec] = ACTIONS(674),
    [anon_sym_type] = ACTIONS(676),
    [anon_sym_EQ] = ACTIONS(670),
    [anon_sym_LBRACK] = ACTIONS(678),
    [anon_sym_AT] = ACTIONS(665),
    [anon_sym_DASH] = ACTIONS(680),
    [anon_sym_PIPE] = ACTIONS(665),
    [anon_sym_LBRACE] = ACTIONS(307),
    [anon_sym_PLUS] = ACTIONS(680),
    [anon_sym_not] = ACTIONS(670),
    [anon_sym_and] = ACTIONS(670),
    [anon_sym_or] = ACTIONS(670),
    [anon_sym_SLASH] = ACTIONS(665),
    [anon_sym_PERCENT] = ACTIONS(665),
    [anon_sym_SLASH_SLASH] = ACTIONS(665),
    [anon_sym_AMP] = ACTIONS(665),
    [anon_sym_CARET] = ACTIONS(665),
    [anon_sym_LT_LT] = ACTIONS(665),
    [anon_sym_TILDE] = ACTIONS(312),
    [anon_sym_is] = ACTIONS(670),
    [anon_sym_LT] = ACTIONS(670),
    [anon_sym_LT_EQ] = ACTIONS(663),
    [anon_sym_EQ_EQ] = ACTIONS(663),
    [anon_sym_BANG_EQ] = ACTIONS(663),
    [anon_sym_GT_EQ] = ACTIONS(663),
    [anon_sym_GT] = ACTIONS(670),
    [anon_sym_LT_GT] = ACTIONS(663),
    [anon_sym_PLUS_EQ] = ACTIONS(663),
    [anon_sym_DASH_EQ] = ACTIONS(663),
    [anon_sym_STAR_EQ] = ACTIONS(663),
    [anon_sym_SLASH_EQ] = ACTIONS(663),
    [anon_sym_AT_EQ] = ACTIONS(663),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(663),
    [anon_sym_PERCENT_EQ] = ACTIONS(663),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(663),
    [anon_sym_GT_GT_EQ] = ACTIONS(663),
    [anon_sym_LT_LT_EQ] = ACTIONS(663),
    [anon_sym_AMP_EQ] = ACTIONS(663),
    [anon_sym_CARET_EQ] = ACTIONS(663),
    [anon_sym_PIPE_EQ] = ACTIONS(663),
    [sym_ellipsis] = ACTIONS(318),
    [sym_integer] = ACTIONS(320),
    [sym_float] = ACTIONS(318),
    [anon_sym_await] = ACTIONS(682),
    [sym_true] = ACTIONS(320),
    [sym_false] = ACTIONS(320),
    [sym_none] = ACTIONS(320),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(663),
    [sym_string_start] = ACTIONS(324),
  },
  [157] = {
    [sym_list_splat_pattern] = STATE(1118),
    [sym_primary_expression] = STATE(987),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_attribute] = STATE(1130),
    [sym_subscript] = STATE(1130),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_from] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(651),
    [anon_sym_print] = ACTIONS(653),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(655),
    [anon_sym_async] = ACTIONS(653),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(653),
    [anon_sym_type] = ACTIONS(655),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_LBRACK] = ACTIONS(657),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(661),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(81),
  },
  [158] = {
    [sym_list_splat_pattern] = STATE(1118),
    [sym_primary_expression] = STATE(987),
    [sym_binary_operator] = STATE(1130),
    [sym_unary_operator] = STATE(1130),
    [sym_attribute] = STATE(1130),
    [sym_subscript] = STATE(1130),
    [sym_call] = STATE(1130),
    [sym_list] = STATE(1130),
    [sym_set] = STATE(1130),
    [sym_tuple] = STATE(1130),
    [sym_dictionary] = STATE(1130),
    [sym_list_comprehension] = STATE(1130),
    [sym_dictionary_comprehension] = STATE(1130),
    [sym_set_comprehension] = STATE(1130),
    [sym_generator_expression] = STATE(1130),
    [sym_parenthesized_expression] = STATE(1130),
    [sym_concatenated_string] = STATE(1130),
    [sym_string] = STATE(967),
    [sym_await] = STATE(1130),
    [sym_identifier] = ACTIONS(77),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_from] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(651),
    [anon_sym_print] = ACTIONS(653),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(277),
    [anon_sym_match] = ACTIONS(655),
    [anon_sym_async] = ACTIONS(653),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(653),
    [anon_sym_type] = ACTIONS(655),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_LBRACK] = ACTIONS(657),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(661),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(81),
  },
  [159] = {
    [sym_list_splat_pattern] = STATE(1183),
    [sym_primary_expression] = STATE(989),
    [sym_binary_operator] = STATE(1208),
    [sym_unary_operator] = STATE(1208),
    [sym_attribute] = STATE(1208),
    [sym_subscript] = STATE(1208),
    [sym_call] = STATE(1208),
    [sym_list] = STATE(1208),
    [sym_set] = STATE(1208),
    [sym_tuple] = STATE(1208),
    [sym_dictionary] = STATE(1208),
    [sym_list_comprehension] = STATE(1208),
    [sym_dictionary_comprehension] = STATE(1208),
    [sym_set_comprehension] = STATE(1208),
    [sym_generator_expression] = STATE(1208),
    [sym_parenthesized_expression] = STATE(1208),
    [sym_concatenated_string] = STATE(1208),
    [sym_string] = STATE(981),
    [sym_await] = STATE(1208),
    [sym_identifier] = ACTIONS(684),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(686),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(688),
    [anon_sym_print] = ACTIONS(690),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(692),
    [anon_sym_async] = ACTIONS(690),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(690),
    [anon_sym_type] = ACTIONS(692),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_LBRACK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(698),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(700),
    [sym_type_conversion] = ACTIONS(277),
    [sym_integer] = ACTIONS(684),
    [sym_float] = ACTIONS(700),
    [anon_sym_await] = ACTIONS(702),
    [sym_true] = ACTIONS(684),
    [sym_false] = ACTIONS(684),
    [sym_none] = ACTIONS(684),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(704),
  },
  [160] = {
    [sym_list_splat_pattern] = STATE(1183),
    [sym_primary_expression] = STATE(989),
    [sym_binary_operator] = STATE(1208),
    [sym_unary_operator] = STATE(1208),
    [sym_attribute] = STATE(1208),
    [sym_subscript] = STATE(1208),
    [sym_call] = STATE(1208),
    [sym_list] = STATE(1208),
    [sym_set] = STATE(1208),
    [sym_tuple] = STATE(1208),
    [sym_dictionary] = STATE(1208),
    [sym_list_comprehension] = STATE(1208),
    [sym_dictionary_comprehension] = STATE(1208),
    [sym_set_comprehension] = STATE(1208),
    [sym_generator_expression] = STATE(1208),
    [sym_parenthesized_expression] = STATE(1208),
    [sym_concatenated_string] = STATE(1208),
    [sym_string] = STATE(981),
    [sym_await] = STATE(1208),
    [sym_identifier] = ACTIONS(684),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(686),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(688),
    [anon_sym_print] = ACTIONS(690),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(692),
    [anon_sym_async] = ACTIONS(690),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(690),
    [anon_sym_type] = ACTIONS(692),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_LBRACK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(698),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(700),
    [sym_type_conversion] = ACTIONS(277),
    [sym_integer] = ACTIONS(684),
    [sym_float] = ACTIONS(700),
    [anon_sym_await] = ACTIONS(702),
    [sym_true] = ACTIONS(684),
    [sym_false] = ACTIONS(684),
    [sym_none] = ACTIONS(684),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(704),
  },
  [161] = {
    [sym_list_splat_pattern] = STATE(1269),
    [sym_primary_expression] = STATE(1107),
    [sym_binary_operator] = STATE(1339),
    [sym_unary_operator] = STATE(1339),
    [sym_attribute] = STATE(1339),
    [sym_subscript] = STATE(1339),
    [sym_call] = STATE(1339),
    [sym_list] = STATE(1339),
    [sym_set] = STATE(1339),
    [sym_tuple] = STATE(1339),
    [sym_dictionary] = STATE(1339),
    [sym_list_comprehension] = STATE(1339),
    [sym_dictionary_comprehension] = STATE(1339),
    [sym_set_comprehension] = STATE(1339),
    [sym_generator_expression] = STATE(1339),
    [sym_parenthesized_expression] = STATE(1339),
    [sym_concatenated_string] = STATE(1339),
    [sym_string] = STATE(1033),
    [sym_await] = STATE(1339),
    [sym_identifier] = ACTIONS(320),
    [anon_sym_SEMI] = ACTIONS(663),
    [anon_sym_DOT] = ACTIONS(665),
    [anon_sym_from] = ACTIONS(670),
    [anon_sym_LPAREN] = ACTIONS(668),
    [anon_sym_COMMA] = ACTIONS(663),
    [anon_sym_as] = ACTIONS(670),
    [anon_sym_STAR] = ACTIONS(672),
    [anon_sym_print] = ACTIONS(674),
    [anon_sym_GT_GT] = ACTIONS(706),
    [anon_sym_if] = ACTIONS(670),
    [anon_sym_COLON] = ACTIONS(663),
    [anon_sym_match] = ACTIONS(676),
    [anon_sym_async] = ACTIONS(674),
    [anon_sym_in] = ACTIONS(670),
    [anon_sym_STAR_STAR] = ACTIONS(706),
    [anon_sym_exec] = ACTIONS(674),
    [anon_sym_type] = ACTIONS(676),
    [anon_sym_EQ] = ACTIONS(670),
    [anon_sym_LBRACK] = ACTIONS(678),
    [anon_sym_AT] = ACTIONS(706),
    [anon_sym_DASH] = ACTIONS(312),
    [anon_sym_PIPE] = ACTIONS(706),
    [anon_sym_LBRACE] = ACTIONS(307),
    [anon_sym_PLUS] = ACTIONS(312),
    [anon_sym_not] = ACTIONS(670),
    [anon_sym_and] = ACTIONS(670),
    [anon_sym_or] = ACTIONS(670),
    [anon_sym_SLASH] = ACTIONS(665),
    [anon_sym_PERCENT] = ACTIONS(706),
    [anon_sym_SLASH_SLASH] = ACTIONS(706),
    [anon_sym_AMP] = ACTIONS(706),
    [anon_sym_CARET] = ACTIONS(706),
    [anon_sym_LT_LT] = ACTIONS(706),
    [anon_sym_TILDE] = ACTIONS(312),
    [anon_sym_is] = ACTIONS(670),
    [anon_sym_LT] = ACTIONS(670),
    [anon_sym_LT_EQ] = ACTIONS(663),
    [anon_sym_EQ_EQ] = ACTIONS(663),
    [anon_sym_BANG_EQ] = ACTIONS(663),
    [anon_sym_GT_EQ] = ACTIONS(663),
    [anon_sym_GT] = ACTIONS(670),
    [anon_sym_LT_GT] = ACTIONS(663),
    [sym_ellipsis] = ACTIONS(318),
    [sym_integer] = ACTIONS(320),
    [sym_float] = ACTIONS(318),
    [anon_sym_await] = ACTIONS(682),
    [sym_true] = ACTIONS(320),
    [sym_false] = ACTIONS(320),
    [sym_none] = ACTIONS(320),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(663),
    [sym_string_start] = ACTIONS(324),
  },
  [162] = {
    [sym_list_splat_pattern] = STATE(1269),
    [sym_primary_expression] = STATE(1107),
    [sym_binary_operator] = STATE(1339),
    [sym_unary_operator] = STATE(1339),
    [sym_attribute] = STATE(1339),
    [sym_subscript] = STATE(1339),
    [sym_call] = STATE(1339),
    [sym_list] = STATE(1339),
    [sym_set] = STATE(1339),
    [sym_tuple] = STATE(1339),
    [sym_dictionary] = STATE(1339),
    [sym_list_comprehension] = STATE(1339),
    [sym_dictionary_comprehension] = STATE(1339),
    [sym_set_comprehension] = STATE(1339),
    [sym_generator_expression] = STATE(1339),
    [sym_parenthesized_expression] = STATE(1339),
    [sym_concatenated_string] = STATE(1339),
    [sym_string] = STATE(1033),
    [sym_await] = STATE(1339),
    [sym_identifier] = ACTIONS(320),
    [anon_sym_DOT] = ACTIONS(665),
    [anon_sym_LPAREN] = ACTIONS(668),
    [anon_sym_COMMA] = ACTIONS(663),
    [anon_sym_as] = ACTIONS(670),
    [anon_sym_STAR] = ACTIONS(672),
    [anon_sym_print] = ACTIONS(674),
    [anon_sym_GT_GT] = ACTIONS(706),
    [anon_sym_if] = ACTIONS(670),
    [anon_sym_COLON] = ACTIONS(663),
    [anon_sym_match] = ACTIONS(676),
    [anon_sym_async] = ACTIONS(674),
    [anon_sym_for] = ACTIONS(670),
    [anon_sym_in] = ACTIONS(670),
    [anon_sym_STAR_STAR] = ACTIONS(706),
    [anon_sym_exec] = ACTIONS(674),
    [anon_sym_type] = ACTIONS(676),
    [anon_sym_EQ] = ACTIONS(670),
    [anon_sym_LBRACK] = ACTIONS(678),
    [anon_sym_AT] = ACTIONS(706),
    [anon_sym_DASH] = ACTIONS(312),
    [anon_sym_PIPE] = ACTIONS(706),
    [anon_sym_LBRACE] = ACTIONS(307),
    [anon_sym_RBRACE] = ACTIONS(663),
    [anon_sym_PLUS] = ACTIONS(312),
    [anon_sym_not] = ACTIONS(670),
    [anon_sym_and] = ACTIONS(670),
    [anon_sym_or] = ACTIONS(670),
    [anon_sym_SLASH] = ACTIONS(665),
    [anon_sym_PERCENT] = ACTIONS(706),
    [anon_sym_SLASH_SLASH] = ACTIONS(706),
    [anon_sym_AMP] = ACTIONS(706),
    [anon_sym_CARET] = ACTIONS(706),
    [anon_sym_LT_LT] = ACTIONS(706),
    [anon_sym_TILDE] = ACTIONS(312),
    [anon_sym_is] = ACTIONS(670),
    [anon_sym_LT] = ACTIONS(670),
    [anon_sym_LT_EQ] = ACTIONS(663),
    [anon_sym_EQ_EQ] = ACTIONS(663),
    [anon_sym_BANG_EQ] = ACTIONS(663),
    [anon_sym_GT_EQ] = ACTIONS(663),
    [anon_sym_GT] = ACTIONS(670),
    [anon_sym_LT_GT] = ACTIONS(663),
    [sym_ellipsis] = ACTIONS(318),
    [sym_type_conversion] = ACTIONS(663),
    [sym_integer] = ACTIONS(320),
    [sym_float] = ACTIONS(318),
    [anon_sym_await] = ACTIONS(682),
    [sym_true] = ACTIONS(320),
    [sym_false] = ACTIONS(320),
    [sym_none] = ACTIONS(320),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(324),
  },
  [163] = {
    [sym_list_splat_pattern] = STATE(1269),
    [sym_primary_expression] = STATE(1107),
    [sym_binary_operator] = STATE(1339),
    [sym_unary_operator] = STATE(1339),
    [sym_attribute] = STATE(1339),
    [sym_subscript] = STATE(1339),
    [sym_call] = STATE(1339),
    [sym_list] = STATE(1339),
    [sym_set] = STATE(1339),
    [sym_tuple] = STATE(1339),
    [sym_dictionary] = STATE(1339),
    [sym_list_comprehension] = STATE(1339),
    [sym_dictionary_comprehension] = STATE(1339),
    [sym_set_comprehension] = STATE(1339),
    [sym_generator_expression] = STATE(1339),
    [sym_parenthesized_expression] = STATE(1339),
    [sym_concatenated_string] = STATE(1339),
    [sym_string] = STATE(1033),
    [sym_await] = STATE(1339),
    [sym_identifier] = ACTIONS(320),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(668),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(672),
    [anon_sym_print] = ACTIONS(674),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_else] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(676),
    [anon_sym_async] = ACTIONS(674),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(674),
    [anon_sym_type] = ACTIONS(676),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_LBRACK] = ACTIONS(678),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(312),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(307),
    [anon_sym_PLUS] = ACTIONS(312),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(312),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(318),
    [sym_integer] = ACTIONS(320),
    [sym_float] = ACTIONS(318),
    [anon_sym_await] = ACTIONS(682),
    [sym_true] = ACTIONS(320),
    [sym_false] = ACTIONS(320),
    [sym_none] = ACTIONS(320),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(324),
  },
  [164] = {
    [sym_list_splat_pattern] = STATE(1183),
    [sym_primary_expression] = STATE(989),
    [sym_binary_operator] = STATE(1208),
    [sym_unary_operator] = STATE(1208),
    [sym_attribute] = STATE(1208),
    [sym_subscript] = STATE(1208),
    [sym_call] = STATE(1208),
    [sym_list] = STATE(1208),
    [sym_set] = STATE(1208),
    [sym_tuple] = STATE(1208),
    [sym_dictionary] = STATE(1208),
    [sym_list_comprehension] = STATE(1208),
    [sym_dictionary_comprehension] = STATE(1208),
    [sym_set_comprehension] = STATE(1208),
    [sym_generator_expression] = STATE(1208),
    [sym_parenthesized_expression] = STATE(1208),
    [sym_concatenated_string] = STATE(1208),
    [sym_string] = STATE(981),
    [sym_await] = STATE(1208),
    [sym_identifier] = ACTIONS(684),
    [anon_sym_DOT] = ACTIONS(665),
    [anon_sym_LPAREN] = ACTIONS(686),
    [anon_sym_COMMA] = ACTIONS(706),
    [anon_sym_as] = ACTIONS(665),
    [anon_sym_STAR] = ACTIONS(688),
    [anon_sym_print] = ACTIONS(690),
    [anon_sym_GT_GT] = ACTIONS(706),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(665),
    [anon_sym_COLON] = ACTIONS(670),
    [anon_sym_match] = ACTIONS(692),
    [anon_sym_async] = ACTIONS(690),
    [anon_sym_for] = ACTIONS(670),
    [anon_sym_in] = ACTIONS(665),
    [anon_sym_STAR_STAR] = ACTIONS(706),
    [anon_sym_exec] = ACTIONS(690),
    [anon_sym_type] = ACTIONS(692),
    [anon_sym_LBRACK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(706),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(706),
    [anon_sym_LBRACE] = ACTIONS(698),
    [anon_sym_RBRACE] = ACTIONS(706),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_not] = ACTIONS(665),
    [anon_sym_and] = ACTIONS(665),
    [anon_sym_or] = ACTIONS(665),
    [anon_sym_SLASH] = ACTIONS(665),
    [anon_sym_PERCENT] = ACTIONS(706),
    [anon_sym_SLASH_SLASH] = ACTIONS(706),
    [anon_sym_AMP] = ACTIONS(706),
    [anon_sym_CARET] = ACTIONS(706),
    [anon_sym_LT_LT] = ACTIONS(706),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_is] = ACTIONS(665),
    [anon_sym_LT] = ACTIONS(665),
    [anon_sym_LT_EQ] = ACTIONS(706),
    [anon_sym_EQ_EQ] = ACTIONS(706),
    [anon_sym_BANG_EQ] = ACTIONS(706),
    [anon_sym_GT_EQ] = ACTIONS(706),
    [anon_sym_GT] = ACTIONS(665),
    [anon_sym_LT_GT] = ACTIONS(706),
    [sym_ellipsis] = ACTIONS(700),
    [sym_integer] = ACTIONS(684),
    [sym_float] = ACTIONS(700),
    [anon_sym_await] = ACTIONS(702),
    [sym_true] = ACTIONS(684),
    [sym_false] = ACTIONS(684),
    [sym_none] = ACTIONS(684),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(704),
  },
  [165] = {
    [sym_list_splat_pattern] = STATE(1212),
    [sym_primary_expression] = STATE(1030),
    [sym_binary_operator] = STATE(1171),
    [sym_unary_operator] = STATE(1171),
    [sym_attribute] = STATE(1171),
    [sym_subscript] = STATE(1171),
    [sym_call] = STATE(1171),
    [sym_list] = STATE(1171),
    [sym_set] = STATE(1171),
    [sym_tuple] = STATE(1171),
    [sym_dictionary] = STATE(1171),
    [sym_list_comprehension] = STATE(1171),
    [sym_dictionary_comprehension] = STATE(1171),
    [sym_set_comprehension] = STATE(1171),
    [sym_generator_expression] = STATE(1171),
    [sym_parenthesized_expression] = STATE(1171),
    [sym_concatenated_string] = STATE(1171),
    [sym_string] = STATE(982),
    [sym_await] = STATE(1171),
    [sym_identifier] = ACTIONS(709),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(711),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(713),
    [anon_sym_print] = ACTIONS(715),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(717),
    [anon_sym_async] = ACTIONS(715),
    [anon_sym_for] = ACTIONS(279),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(715),
    [anon_sym_type] = ACTIONS(717),
    [anon_sym_LBRACK] = ACTIONS(719),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(721),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(723),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_PLUS] = ACTIONS(721),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(721),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(725),
    [sym_integer] = ACTIONS(709),
    [sym_float] = ACTIONS(725),
    [anon_sym_await] = ACTIONS(727),
    [sym_true] = ACTIONS(709),
    [sym_false] = ACTIONS(709),
    [sym_none] = ACTIONS(709),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(729),
  },
  [166] = {
    [sym_list_splat_pattern] = STATE(1264),
    [sym_primary_expression] = STATE(1036),
    [sym_binary_operator] = STATE(1381),
    [sym_unary_operator] = STATE(1381),
    [sym_attribute] = STATE(1381),
    [sym_subscript] = STATE(1381),
    [sym_call] = STATE(1381),
    [sym_list] = STATE(1381),
    [sym_set] = STATE(1381),
    [sym_tuple] = STATE(1381),
    [sym_dictionary] = STATE(1381),
    [sym_list_comprehension] = STATE(1381),
    [sym_dictionary_comprehension] = STATE(1381),
    [sym_set_comprehension] = STATE(1381),
    [sym_generator_expression] = STATE(1381),
    [sym_parenthesized_expression] = STATE(1381),
    [sym_concatenated_string] = STATE(1381),
    [sym_string] = STATE(1003),
    [sym_await] = STATE(1381),
    [sym_identifier] = ACTIONS(731),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(733),
    [anon_sym_RPAREN] = ACTIONS(277),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(735),
    [anon_sym_print] = ACTIONS(737),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(739),
    [anon_sym_async] = ACTIONS(737),
    [anon_sym_for] = ACTIONS(279),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(737),
    [anon_sym_type] = ACTIONS(739),
    [anon_sym_EQ] = ACTIONS(741),
    [anon_sym_LBRACK] = ACTIONS(743),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(745),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(747),
    [anon_sym_PLUS] = ACTIONS(745),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(745),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(749),
    [sym_integer] = ACTIONS(731),
    [sym_float] = ACTIONS(749),
    [anon_sym_await] = ACTIONS(751),
    [sym_true] = ACTIONS(731),
    [sym_false] = ACTIONS(731),
    [sym_none] = ACTIONS(731),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(753),
  },
  [167] = {
    [sym_list_splat_pattern] = STATE(1183),
    [sym_primary_expression] = STATE(989),
    [sym_binary_operator] = STATE(1208),
    [sym_unary_operator] = STATE(1208),
    [sym_attribute] = STATE(1208),
    [sym_subscript] = STATE(1208),
    [sym_call] = STATE(1208),
    [sym_list] = STATE(1208),
    [sym_set] = STATE(1208),
    [sym_tuple] = STATE(1208),
    [sym_dictionary] = STATE(1208),
    [sym_list_comprehension] = STATE(1208),
    [sym_dictionary_comprehension] = STATE(1208),
    [sym_set_comprehension] = STATE(1208),
    [sym_generator_expression] = STATE(1208),
    [sym_parenthesized_expression] = STATE(1208),
    [sym_concatenated_string] = STATE(1208),
    [sym_string] = STATE(981),
    [sym_await] = STATE(1208),
    [sym_identifier] = ACTIONS(684),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(686),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(688),
    [anon_sym_print] = ACTIONS(690),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(277),
    [anon_sym_match] = ACTIONS(692),
    [anon_sym_async] = ACTIONS(690),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(690),
    [anon_sym_type] = ACTIONS(692),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_LBRACK] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(698),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(700),
    [sym_type_conversion] = ACTIONS(277),
    [sym_integer] = ACTIONS(684),
    [sym_float] = ACTIONS(700),
    [anon_sym_await] = ACTIONS(702),
    [sym_true] = ACTIONS(684),
    [sym_false] = ACTIONS(684),
    [sym_none] = ACTIONS(684),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(704),
  },
  [168] = {
    [sym_list_splat_pattern] = STATE(1413),
    [sym_primary_expression] = STATE(1125),
    [sym_binary_operator] = STATE(1380),
    [sym_unary_operator] = STATE(1380),
    [sym_attribute] = STATE(1380),
    [sym_subscript] = STATE(1380),
    [sym_call] = STATE(1380),
    [sym_list] = STATE(1380),
    [sym_set] = STATE(1380),
    [sym_tuple] = STATE(1380),
    [sym_dictionary] = STATE(1380),
    [sym_list_comprehension] = STATE(1380),
    [sym_dictionary_comprehension] = STATE(1380),
    [sym_set_comprehension] = STATE(1380),
    [sym_generator_expression] = STATE(1380),
    [sym_parenthesized_expression] = STATE(1380),
    [sym_concatenated_string] = STATE(1380),
    [sym_string] = STATE(1025),
    [sym_await] = STATE(1380),
    [sym_identifier] = ACTIONS(755),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(757),
    [anon_sym_RPAREN] = ACTIONS(277),
    [anon_sym_COMMA] = ACTIONS(277),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(759),
    [anon_sym_print] = ACTIONS(761),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(763),
    [anon_sym_async] = ACTIONS(761),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(761),
    [anon_sym_type] = ACTIONS(763),
    [anon_sym_EQ] = ACTIONS(279),
    [anon_sym_LBRACK] = ACTIONS(765),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(767),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(769),
    [anon_sym_PLUS] = ACTIONS(767),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(767),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(771),
    [sym_integer] = ACTIONS(755),
    [sym_float] = ACTIONS(771),
    [anon_sym_await] = ACTIONS(773),
    [sym_true] = ACTIONS(755),
    [sym_false] = ACTIONS(755),
    [sym_none] = ACTIONS(755),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(775),
  },
  [169] = {
    [sym_list_splat_pattern] = STATE(1269),
    [sym_primary_expression] = STATE(1107),
    [sym_binary_operator] = STATE(1339),
    [sym_unary_operator] = STATE(1339),
    [sym_attribute] = STATE(1339),
    [sym_subscript] = STATE(1339),
    [sym_call] = STATE(1339),
    [sym_list] = STATE(1339),
    [sym_set] = STATE(1339),
    [sym_tuple] = STATE(1339),
    [sym_dictionary] = STATE(1339),
    [sym_list_comprehension] = STATE(1339),
    [sym_dictionary_comprehension] = STATE(1339),
    [sym_set_comprehension] = STATE(1339),
    [sym_generator_expression] = STATE(1339),
    [sym_parenthesized_expression] = STATE(1339),
    [sym_concatenated_string] = STATE(1339),
    [sym_string] = STATE(1033),
    [sym_await] = STATE(1339),
    [sym_identifier] = ACTIONS(320),
    [anon_sym_DOT] = ACTIONS(665),
    [anon_sym_LPAREN] = ACTIONS(668),
    [anon_sym_RPAREN] = ACTIONS(663),
    [anon_sym_COMMA] = ACTIONS(663),
    [anon_sym_as] = ACTIONS(670),
    [anon_sym_STAR] = ACTIONS(672),
    [anon_sym_print] = ACTIONS(674),
    [anon_sym_GT_GT] = ACTIONS(706),
    [anon_sym_if] = ACTIONS(670),
    [anon_sym_COLON] = ACTIONS(663),
    [anon_sym_match] = ACTIONS(676),
    [anon_sym_async] = ACTIONS(674),
    [anon_sym_for] = ACTIONS(670),
    [anon_sym_in] = ACTIONS(670),
    [anon_sym_STAR_STAR] = ACTIONS(706),
    [anon_sym_exec] = ACTIONS(674),
    [anon_sym_type] = ACTIONS(676),
    [anon_sym_EQ] = ACTIONS(670),
    [anon_sym_LBRACK] = ACTIONS(678),
    [anon_sym_AT] = ACTIONS(706),
    [anon_sym_DASH] = ACTIONS(312),
    [anon_sym_PIPE] = ACTIONS(706),
    [anon_sym_LBRACE] = ACTIONS(307),
    [anon_sym_PLUS] = ACTIONS(312),
    [anon_sym_not] = ACTIONS(670),
    [anon_sym_and] = ACTIONS(670),
    [anon_sym_or] = ACTIONS(670),
    [anon_sym_SLASH] = ACTIONS(665),
    [anon_sym_PERCENT] = ACTIONS(706),
    [anon_sym_SLASH_SLASH] = ACTIONS(706),
    [anon_sym_AMP] = ACTIONS(706),
    [anon_sym_CARET] = ACTIONS(706),
    [anon_sym_LT_LT] = ACTIONS(706),
    [anon_sym_TILDE] = ACTIONS(312),
    [anon_sym_is] = ACTIONS(670),
    [anon_sym_LT] = ACTIONS(670),
    [anon_sym_LT_EQ] = ACTIONS(663),
    [anon_sym_EQ_EQ] = ACTIONS(663),
    [anon_sym_BANG_EQ] = ACTIONS(663),
    [anon_sym_GT_EQ] = ACTIONS(663),
    [anon_sym_GT] = ACTIONS(670),
    [anon_sym_LT_GT] = ACTIONS(663),
    [sym_ellipsis] = ACTIONS(318),
    [sym_integer] = ACTIONS(320),
    [sym_float] = ACTIONS(318),
    [anon_sym_await] = ACTIONS(682),
    [sym_true] = ACTIONS(320),
    [sym_false] = ACTIONS(320),
    [sym_none] = ACTIONS(320),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(324),
  },
  [170] = {
    [sym_list_splat_pattern] = STATE(1264),
    [sym_primary_expression] = STATE(1036),
    [sym_binary_operator] = STATE(1381),
    [sym_unary_operator] = STATE(1381),
    [sym_attribute] = STATE(1381),
    [sym_subscript] = STATE(1381),
    [sym_call] = STATE(1381),
    [sym_list] = STATE(1381),
    [sym_set] = STATE(1381),
    [sym_tuple] = STATE(1381),
    [sym_dictionary] = STATE(1381),
    [sym_list_comprehension] = STATE(1381),
    [sym_dictionary_comprehension] = STATE(1381),
    [sym_set_comprehension] = STATE(1381),
    [sym_generator_expression] = STATE(1381),
    [sym_parenthesized_expression] = STATE(1381),
    [sym_concatenated_string] = STATE(1381),
    [sym_string] = STATE(1003),
    [sym_await] = STATE(1381),
    [sym_identifier] = ACTIONS(731),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(733),
    [anon_sym_RPAREN] = ACTIONS(284),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(735),
    [anon_sym_print] = ACTIONS(737),
    [anon_sym_GT_GT] = ACTIONS(277),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_match] = ACTIONS(739),
    [anon_sym_async] = ACTIONS(737),
    [anon_sym_for] = ACTIONS(279),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(277),
    [anon_sym_exec] = ACTIONS(737),
    [anon_sym_type] = ACTIONS(739),
    [anon_sym_LBRACK] = ACTIONS(743),
    [anon_sym_AT] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(745),
    [anon_sym_PIPE] = ACTIONS(277),
    [anon_sym_LBRACE] = ACTIONS(747),
    [anon_sym_PLUS] = ACTIONS(745),
    [anon_sym_not] = ACTIONS(279),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(277),
    [anon_sym_SLASH_SLASH] = ACTIONS(277),
    [anon_sym_AMP] = ACTIONS(277),
    [anon_sym_CARET] = ACTIONS(277),
    [anon_sym_LT_LT] = ACTIONS(277),
    [anon_sym_TILDE] = ACTIONS(745),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [sym_ellipsis] = ACTIONS(749),
    [sym_integer] = ACTIONS(731),
    [sym_float] = ACTIONS(749),
    [anon_sym_await] = ACTIONS(751),
    [sym_true] = ACTIONS(731),
    [sym_false] = ACTIONS(731),
    [sym_none] = ACTIONS(731),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(753),
  },
  [171] = {
    [sym_list_splat_pattern] = STATE(1269),
    [sym_primary_expression] = STATE(1107),
    [sym_binary_operator] = STATE(1339),
    [sym_unary_operator] = STATE(1339),
    [sym_attribute] = STATE(1339),
    [sym_subscript] = STATE(1339),
    [sym_call] = STATE(1339),
    [sym_list] = STATE(1339),
    [sym_set] = STATE(1339),
    [sym_tuple] = STATE(1339),
    [sym_dictionary] = STATE(1339),
    [sym_list_comprehension] = STATE(1339),
    [sym_dictionary_comprehension] = STATE(1339),
    [sym_set_comprehension] = STATE(1339),
    [sym_generator_expression] = STATE(1339),
    [sym_parenthesized_expression] = STATE(1339),
    [sym_concatenated_string] = STATE(1339),
    [sym_string] = STATE(1033),
    [sym_await] = STATE(1339),
    [sym_identifier] = ACTIONS(320),
    [anon_sym_DOT] = ACTIONS(665),
    [anon_sym_LPAREN] = ACTIONS(668),
    [anon_sym_COMMA] = ACTIONS(663),
    [anon_sym_as] = ACTIONS(670),
    [anon_sym_STAR] = ACTIONS(672),
    [anon_sym_print] = ACTIONS(674),
    [anon_sym_GT_GT] = ACTIONS(706),
    [anon_sym_if] = ACTIONS(670),
    [anon_sym_COLON] = ACTIONS(663),
    [anon_sym_else] = ACTIONS(670),
    [anon_sym_match] = ACTIONS(676),
    [anon_sym_async] = ACTIONS(674),
    [anon_sym_in] = ACTIONS(670),
    [anon_sym_STAR_STAR] = ACTIONS(706),
    [anon_sym_exec] = ACTIONS(674),
    [anon_sym_type] = ACTIONS(676),
    [anon_sym_EQ] = ACTIONS(670),
    [anon_sym_LBRACK] = ACTIONS(678),
    [anon_sym_AT] = ACTIONS(706),
    [anon_sym_DASH] = ACTIONS(312),
    [anon_sym_PIPE] = ACTIONS(706),
    [anon_sym_LBRACE] = ACTIONS(307),
    [anon_sym_PLUS] = ACTIONS(312),
    [anon_sym_not] = ACTIONS(670),
    [anon_sym_and] = ACTIONS(670),
    [anon_sym_or] = ACTIONS(670),
    [anon_sym_SLASH] = ACTIONS(665),
    [anon_sym_PERCENT] = ACTIONS(706),
    [anon_sym_SLASH_SLASH] = ACTIONS(706),
    [anon_sym_AMP] = ACTIONS(706),
    [anon_sym_CARET] = ACTIONS(706),
    [anon_sym_LT_LT] = ACTIONS(706),
    [anon_sym_TILDE] = ACTIONS(312),
    [anon_sym_is] = ACTIONS(670),
    [anon_sym_LT] = ACTIONS(670),
    [anon_sym_LT_EQ] = ACTIONS(663),
    [anon_sym_EQ_EQ] = ACTIONS(663),
    [anon_sym_BANG_EQ] = ACTIONS(663),
    [anon_sym_GT_EQ] = ACTIONS(663),
    [anon_sym_GT] = ACTIONS(670),
    [anon_sym_LT_GT] = ACTIONS(663),
    [sym_ellipsis] = ACTIONS(318),
    [sym_integer] = ACTIONS(320),
    [sym_float] = ACTIONS(318),
    [anon_sym_await] = ACTIONS(682),
    [sym_true] = ACTIONS(320),
    [sym_false] = ACTIONS(320),
    [sym_none] = ACTIONS(320),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(324),
  },
  [172] = {
    [sym_list_splat_pattern] = STATE(1269),
    [sym_primary_expression] = STATE(1107),
    [sym_binary_operator] = STATE(1339),
    [sym_unary_operator] = STATE(1339),
    [sym_attribute] = STATE(1339),
    [sym_subscript] = STATE(1339),
    [sym_call] = STATE(1339),
    [sym_list] = STATE(1339),
    [sym_set] = STATE(1339),
    [sym_tuple] = STATE(1339),
    [sym_dictionary] = STATE(1339),
    [sym_list_comprehension] = STATE(1339),
    [sym_dictionary_comprehension] = STATE(1339),
    [sym_set_comprehension] = STATE(1339),
    [sym_generator_expression] = STATE(1339),
    [sym_parenthesized_expression] = STATE(1339),
    [sym_concatenated_string] = STATE(1339),
    [sym_string] = STATE(1033),
    [sym_await] = STATE(1339),
    [sym_identifier] = ACTIONS(320),
    [anon_sym_DOT] = ACTIONS(665),
    [anon_sym_LPAREN] = ACTIONS(668),
    [anon_sym_COMMA] = ACTIONS(663),
    [anon_sym_as] = ACTIONS(670),
    [anon_sym_STAR] = ACTIONS(672),
    [anon_sym_print] = ACTIONS(674),
    [anon_sym_GT_GT] = ACTIONS(706),
    [anon_sym_if] = ACTIONS(670),
    [anon_sym_COLON] = ACTIONS(663),
    [anon_sym_match] = ACTIONS(676),
    [anon_sym_async] = ACTIONS(674),
    [anon_sym_for] = ACTIONS(670),
    [anon_sym_in] = ACTIONS(670),
    [anon_sym_STAR_STAR] = ACTIONS(706),
    [anon_sym_exec] = ACTIONS(674),
    [anon_sym_type] = ACTIONS(676),
    [anon_sym_LBRACK] = ACTIONS(678),
    [anon_sym_RBRACK] = ACTIONS(663),
    [anon_sym_AT] = ACTIONS(706),
    [anon_sym_DASH] = ACTIONS(312),
    [anon_sym_PIPE] = ACTIONS(706),
    [anon_sym_LBRACE] = ACTIONS(307),
    [anon_sym_PLUS] = ACTIONS(312),
    [anon_sym_not] = ACTIONS(670),
    [anon_sym_and] = ACTIONS(670),
    [anon_sym_or] = ACTIONS(670),
    [anon_sym_SLASH] = ACTIONS(665),
    [anon_sym_PERCENT] = ACTIONS(706),
    [anon_sym_SLASH_SLASH] = ACTIONS(706),
    [anon_sym_AMP] = ACTIONS(706),
    [anon_sym_CARET] = ACTIONS(706),
    [anon_sym_LT_LT] = ACTIONS(706),
    [anon_sym_TILDE] = ACTIONS(312),
    [anon_sym_is] = ACTIONS(670),
    [anon_sym_LT] = ACTIONS(670),
    [anon_sym_LT_EQ] = ACTIONS(663),
    [anon_sym_EQ_EQ] = ACTIONS(663),
    [anon_sym_BANG_EQ] = ACTIONS(663),
    [anon_sym_GT_EQ] = ACTIONS(663),
    [anon_sym_GT] = ACTIONS(670),
    [anon_sym_LT_GT] = ACTIONS(663),
    [sym_ellipsis] = ACTIONS(318),
    [sym_integer] = ACTIONS(320),
    [sym_float] = ACTIONS(318),
    [anon_sym_await] = ACTIONS(682),
    [sym_true] = ACTIONS(320),
    [sym_false] = ACTIONS(320),
    [sym_none] = ACTIONS(320),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(324),
  },
  [173] = {
    [sym_list_splat_pattern] = STATE(1269),
    [sym_primary_expression] = STATE(1107),
    [sym_binary_operator] = STATE(1339),
    [sym_unary_operator] = STATE(1339),
    [sym_attribute] = STATE(1339),
    [sym_subscript] = STATE(1339),
    [sym_call] = STATE(1339),
    [sym_list] = STATE(1339),
    [sym_set] = STATE(1339),
    [sym_tuple] = STATE(1339),
    [sym_dictionary] = STATE(1339),
    [sym_list_comprehension] = STATE(1339),
    [sym_dictionary_comprehension] = STATE(1339),
    [sym_set_comprehension] = STATE(1339),
    [sym_generator_expression] = STATE(1339),
    [sym_parenthesized_expression] = STATE(1339),
    [sym_concatenated_string] = STATE(1339),
    [sym_string] = STATE(1033),
    [sym_await] = STATE(1339),
    [sym_identifier] = ACTIONS(320),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(668)