#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2831
#define LARGE_STATE_COUNT 189
#define SYMBOL_COUNT 270
#define ALIAS_COUNT 4
#define TOKEN_COUNT 108
#define EXTERNAL_TOKEN_COUNT 12
#define FIELD_COUNT 32
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 140

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_SEMI = 2,
  anon_sym_import = 3,
  anon_sym_DOT = 4,
  anon_sym_from = 5,
  anon_sym___future__ = 6,
  anon_sym_LPAREN = 7,
  anon_sym_RPAREN = 8,
  anon_sym_COMMA = 9,
  anon_sym_as = 10,
  anon_sym_STAR = 11,
  anon_sym_print = 12,
  anon_sym_GT_GT = 13,
  anon_sym_assert = 14,
  anon_sym_COLON_EQ = 15,
  anon_sym_return = 16,
  anon_sym_del = 17,
  anon_sym_raise = 18,
  anon_sym_pass = 19,
  anon_sym_break = 20,
  anon_sym_continue = 21,
  anon_sym_if = 22,
  anon_sym_COLON = 23,
  anon_sym_elif = 24,
  anon_sym_else = 25,
  anon_sym_match = 26,
  anon_sym_case = 27,
  anon_sym_async = 28,
  anon_sym_for = 29,
  anon_sym_in = 30,
  anon_sym_while = 31,
  anon_sym_try = 32,
  anon_sym_except = 33,
  anon_sym_except_STAR = 34,
  anon_sym_finally = 35,
  anon_sym_with = 36,
  anon_sym_def = 37,
  anon_sym_DASH_GT = 38,
  anon_sym_STAR_STAR = 39,
  anon_sym_global = 40,
  anon_sym_nonlocal = 41,
  anon_sym_exec = 42,
  anon_sym_type = 43,
  anon_sym_EQ = 44,
  anon_sym_class = 45,
  anon_sym_LBRACK = 46,
  anon_sym_RBRACK = 47,
  anon_sym_AT = 48,
  anon_sym_DASH = 49,
  anon_sym__ = 50,
  anon_sym_PIPE = 51,
  anon_sym_LBRACE = 52,
  anon_sym_RBRACE = 53,
  anon_sym_PLUS = 54,
  anon_sym_not = 55,
  anon_sym_and = 56,
  anon_sym_or = 57,
  anon_sym_SLASH = 58,
  anon_sym_PERCENT = 59,
  anon_sym_SLASH_SLASH = 60,
  anon_sym_AMP = 61,
  anon_sym_CARET = 62,
  anon_sym_LT_LT = 63,
  anon_sym_TILDE = 64,
  anon_sym_LT = 65,
  anon_sym_LT_EQ = 66,
  anon_sym_EQ_EQ = 67,
  anon_sym_BANG_EQ = 68,
  anon_sym_GT_EQ = 69,
  anon_sym_GT = 70,
  anon_sym_LT_GT = 71,
  anon_sym_is = 72,
  anon_sym_lambda = 73,
  anon_sym_PLUS_EQ = 74,
  anon_sym_DASH_EQ = 75,
  anon_sym_STAR_EQ = 76,
  anon_sym_SLASH_EQ = 77,
  anon_sym_AT_EQ = 78,
  anon_sym_SLASH_SLASH_EQ = 79,
  anon_sym_PERCENT_EQ = 80,
  anon_sym_STAR_STAR_EQ = 81,
  anon_sym_GT_GT_EQ = 82,
  anon_sym_LT_LT_EQ = 83,
  anon_sym_AMP_EQ = 84,
  anon_sym_CARET_EQ = 85,
  anon_sym_PIPE_EQ = 86,
  anon_sym_yield = 87,
  sym_ellipsis = 88,
  sym_escape_sequence = 89,
  sym__not_escape_sequence = 90,
  aux_sym_format_specifier_token1 = 91,
  sym_type_conversion = 92,
  sym_integer = 93,
  sym_float = 94,
  anon_sym_await = 95,
  sym_true = 96,
  sym_false = 97,
  sym_none = 98,
  sym_comment = 99,
  sym_line_continuation = 100,
  sym__newline = 101,
  sym__indent = 102,
  sym__dedent = 103,
  sym_string_start = 104,
  sym__string_content = 105,
  sym_escape_interpolation = 106,
  sym_string_end = 107,
  sym_module = 108,
  sym__statement = 109,
  sym__simple_statements = 110,
  sym_import_statement = 111,
  sym_import_prefix = 112,
  sym_relative_import = 113,
  sym_future_import_statement = 114,
  sym_import_from_statement = 115,
  sym__import_list = 116,
  sym_aliased_import = 117,
  sym_wildcard_import = 118,
  sym_print_statement = 119,
  sym_chevron = 120,
  sym_assert_statement = 121,
  sym_expression_statement = 122,
  sym_named_expression = 123,
  sym__named_expression_lhs = 124,
  sym_return_statement = 125,
  sym_delete_statement = 126,
  sym_raise_statement = 127,
  sym_pass_statement = 128,
  sym_break_statement = 129,
  sym_continue_statement = 130,
  sym_if_statement = 131,
  sym_elif_clause = 132,
  sym_else_clause = 133,
  sym_match_statement = 134,
  sym__match_block = 135,
  sym_case_clause = 136,
  sym_for_statement = 137,
  sym_while_statement = 138,
  sym_try_statement = 139,
  sym_except_clause = 140,
  sym_except_group_clause = 141,
  sym_finally_clause = 142,
  sym_with_statement = 143,
  sym_with_clause = 144,
  sym_with_item = 145,
  sym_function_definition = 146,
  sym_parameters = 147,
  sym_lambda_parameters = 148,
  sym_list_splat = 149,
  sym_dictionary_splat = 150,
  sym_global_statement = 151,
  sym_nonlocal_statement = 152,
  sym_exec_statement = 153,
  sym_type_alias_statement = 154,
  sym_class_definition = 155,
  sym_type_parameter = 156,
  sym_parenthesized_list_splat = 157,
  sym_argument_list = 158,
  sym_decorated_definition = 159,
  sym_decorator = 160,
  sym_block = 161,
  sym_expression_list = 162,
  sym_dotted_name = 163,
  sym_case_pattern = 164,
  sym__simple_pattern = 165,
  sym__as_pattern = 166,
  sym_union_pattern = 167,
  sym__list_pattern = 168,
  sym__tuple_pattern = 169,
  sym_dict_pattern = 170,
  sym__key_value_pattern = 171,
  sym_keyword_pattern = 172,
  sym_splat_pattern = 173,
  sym_class_pattern = 174,
  sym_complex_pattern = 175,
  sym__parameters = 176,
  sym__patterns = 177,
  sym_parameter = 178,
  sym_pattern = 179,
  sym_tuple_pattern = 180,
  sym_list_pattern = 181,
  sym_default_parameter = 182,
  sym_typed_default_parameter = 183,
  sym_list_splat_pattern = 184,
  sym_dictionary_splat_pattern = 185,
  sym_as_pattern = 186,
  sym__expression_within_for_in_clause = 187,
  sym_expression = 188,
  sym_primary_expression = 189,
  sym_not_operator = 190,
  sym_boolean_operator = 191,
  sym_binary_operator = 192,
  sym_unary_operator = 193,
  sym_comparison_operator = 194,
  sym_lambda = 195,
  sym_lambda_within_for_in_clause = 196,
  sym_assignment = 197,
  sym_augmented_assignment = 198,
  sym_pattern_list = 199,
  sym__right_hand_side = 200,
  sym_yield = 201,
  sym_attribute = 202,
  sym_subscript = 203,
  sym_slice = 204,
  sym_call = 205,
  sym_typed_parameter = 206,
  sym_type = 207,
  sym_splat_type = 208,
  sym_generic_type = 209,
  sym_union_type = 210,
  sym_constrained_type = 211,
  sym_member_type = 212,
  sym_keyword_argument = 213,
  sym_list = 214,
  sym_set = 215,
  sym_tuple = 216,
  sym_dictionary = 217,
  sym_pair = 218,
  sym_list_comprehension = 219,
  sym_dictionary_comprehension = 220,
  sym_set_comprehension = 221,
  sym_generator_expression = 222,
  sym__comprehension_clauses = 223,
  sym_parenthesized_expression = 224,
  sym__collection_elements = 225,
  sym_for_in_clause = 226,
  sym_if_clause = 227,
  sym_conditional_expression = 228,
  sym_concatenated_string = 229,
  sym_string = 230,
  sym_string_content = 231,
  sym_interpolation = 232,
  sym__f_expression = 233,
  sym_format_specifier = 234,
  sym_await = 235,
  sym_positional_separator = 236,
  sym_keyword_separator = 237,
  aux_sym_module_repeat1 = 238,
  aux_sym__simple_statements_repeat1 = 239,
  aux_sym_import_prefix_repeat1 = 240,
  aux_sym__import_list_repeat1 = 241,
  aux_sym_print_statement_repeat1 = 242,
  aux_sym_assert_statement_repeat1 = 243,
  aux_sym_if_statement_repeat1 = 244,
  aux_sym_match_statement_repeat1 = 245,
  aux_sym__match_block_repeat1 = 246,
  aux_sym_case_clause_repeat1 = 247,
  aux_sym_try_statement_repeat1 = 248,
  aux_sym_try_statement_repeat2 = 249,
  aux_sym_with_clause_repeat1 = 250,
  aux_sym_global_statement_repeat1 = 251,
  aux_sym_type_parameter_repeat1 = 252,
  aux_sym_argument_list_repeat1 = 253,
  aux_sym_decorated_definition_repeat1 = 254,
  aux_sym_dotted_name_repeat1 = 255,
  aux_sym_union_pattern_repeat1 = 256,
  aux_sym_dict_pattern_repeat1 = 257,
  aux_sym__parameters_repeat1 = 258,
  aux_sym__patterns_repeat1 = 259,
  aux_sym_comparison_operator_repeat1 = 260,
  aux_sym_subscript_repeat1 = 261,
  aux_sym_dictionary_repeat1 = 262,
  aux_sym__comprehension_clauses_repeat1 = 263,
  aux_sym__collection_elements_repeat1 = 264,
  aux_sym_for_in_clause_repeat1 = 265,
  aux_sym_concatenated_string_repeat1 = 266,
  aux_sym_string_repeat1 = 267,
  aux_sym_string_content_repeat1 = 268,
  aux_sym_format_specifier_repeat1 = 269,
  alias_sym_as_pattern_target = 270,
  alias_sym_format_expression = 271,
  anon_alias_sym_isnot = 272,
  anon_alias_sym_notin = 273,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_SEMI] = ";",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_from] = "from",
  [anon_sym___future__] = "__future__",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [anon_sym_as] = "as",
  [anon_sym_STAR] = "*",
  [anon_sym_print] = "print",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_assert] = "assert",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_return] = "return",
  [anon_sym_del] = "del",
  [anon_sym_raise] = "raise",
  [anon_sym_pass] = "pass",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_if] = "if",
  [anon_sym_COLON] = ":",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_match] = "match",
  [anon_sym_case] = "case",
  [anon_sym_async] = "async",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_try] = "try",
  [anon_sym_except] = "except",
  [anon_sym_except_STAR] = "except*",
  [anon_sym_finally] = "finally",
  [anon_sym_with] = "with",
  [anon_sym_def] = "def",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_global] = "global",
  [anon_sym_nonlocal] = "nonlocal",
  [anon_sym_exec] = "exec",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_class] = "class",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_AT] = "@",
  [anon_sym_DASH] = "-",
  [anon_sym__] = "_",
  [anon_sym_PIPE] = "|",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_PLUS] = "+",
  [anon_sym_not] = "not",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_TILDE] = "~",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_is] = "is",
  [anon_sym_lambda] = "lambda",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AT_EQ] = "@=",
  [anon_sym_SLASH_SLASH_EQ] = "//=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_yield] = "yield",
  [sym_ellipsis] = "ellipsis",
  [sym_escape_sequence] = "escape_sequence",
  [sym__not_escape_sequence] = "_not_escape_sequence",
  [aux_sym_format_specifier_token1] = "format_specifier_token1",
  [sym_type_conversion] = "type_conversion",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_await] = "await",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_none] = "none",
  [sym_comment] = "comment",
  [sym_line_continuation] = "line_continuation",
  [sym__newline] = "_newline",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym_string_start] = "string_start",
  [sym__string_content] = "_string_content",
  [sym_escape_interpolation] = "escape_interpolation",
  [sym_string_end] = "string_end",
  [sym_module] = "module",
  [sym__statement] = "_statement",
  [sym__simple_statements] = "_simple_statements",
  [sym_import_statement] = "import_statement",
  [sym_import_prefix] = "import_prefix",
  [sym_relative_import] = "relative_import",
  [sym_future_import_statement] = "future_import_statement",
  [sym_import_from_statement] = "import_from_statement",
  [sym__import_list] = "_import_list",
  [sym_aliased_import] = "aliased_import",
  [sym_wildcard_import] = "wildcard_import",
  [sym_print_statement] = "print_statement",
  [sym_chevron] = "chevron",
  [sym_assert_statement] = "assert_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_named_expression] = "named_expression",
  [sym__named_expression_lhs] = "_named_expression_lhs",
  [sym_return_statement] = "return_statement",
  [sym_delete_statement] = "delete_statement",
  [sym_raise_statement] = "raise_statement",
  [sym_pass_statement] = "pass_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_match_statement] = "match_statement",
  [sym__match_block] = "block",
  [sym_case_clause] = "case_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_try_statement] = "try_statement",
  [sym_except_clause] = "except_clause",
  [sym_except_group_clause] = "except_group_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_with_statement] = "with_statement",
  [sym_with_clause] = "with_clause",
  [sym_with_item] = "with_item",
  [sym_function_definition] = "function_definition",
  [sym_parameters] = "parameters",
  [sym_lambda_parameters] = "lambda_parameters",
  [sym_list_splat] = "list_splat",
  [sym_dictionary_splat] = "dictionary_splat",
  [sym_global_statement] = "global_statement",
  [sym_nonlocal_statement] = "nonlocal_statement",
  [sym_exec_statement] = "exec_statement",
  [sym_type_alias_statement] = "type_alias_statement",
  [sym_class_definition] = "class_definition",
  [sym_type_parameter] = "type_parameter",
  [sym_parenthesized_list_splat] = "parenthesized_list_splat",
  [sym_argument_list] = "argument_list",
  [sym_decorated_definition] = "decorated_definition",
  [sym_decorator] = "decorator",
  [sym_block] = "block",
  [sym_expression_list] = "expression_list",
  [sym_dotted_name] = "dotted_name",
  [sym_case_pattern] = "case_pattern",
  [sym__simple_pattern] = "_simple_pattern",
  [sym__as_pattern] = "as_pattern",
  [sym_union_pattern] = "union_pattern",
  [sym__list_pattern] = "list_pattern",
  [sym__tuple_pattern] = "tuple_pattern",
  [sym_dict_pattern] = "dict_pattern",
  [sym__key_value_pattern] = "_key_value_pattern",
  [sym_keyword_pattern] = "keyword_pattern",
  [sym_splat_pattern] = "splat_pattern",
  [sym_class_pattern] = "class_pattern",
  [sym_complex_pattern] = "complex_pattern",
  [sym__parameters] = "_parameters",
  [sym__patterns] = "_patterns",
  [sym_parameter] = "parameter",
  [sym_pattern] = "pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym_default_parameter] = "default_parameter",
  [sym_typed_default_parameter] = "typed_default_parameter",
  [sym_list_splat_pattern] = "list_splat_pattern",
  [sym_dictionary_splat_pattern] = "dictionary_splat_pattern",
  [sym_as_pattern] = "as_pattern",
  [sym__expression_within_for_in_clause] = "_expression_within_for_in_clause",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_not_operator] = "not_operator",
  [sym_boolean_operator] = "boolean_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_lambda] = "lambda",
  [sym_lambda_within_for_in_clause] = "lambda",
  [sym_assignment] = "assignment",
  [sym_augmented_assignment] = "augmented_assignment",
  [sym_pattern_list] = "pattern_list",
  [sym__right_hand_side] = "_right_hand_side",
  [sym_yield] = "yield",
  [sym_attribute] = "attribute",
  [sym_subscript] = "subscript",
  [sym_slice] = "slice",
  [sym_call] = "call",
  [sym_typed_parameter] = "typed_parameter",
  [sym_type] = "type",
  [sym_splat_type] = "splat_type",
  [sym_generic_type] = "generic_type",
  [sym_union_type] = "union_type",
  [sym_constrained_type] = "constrained_type",
  [sym_member_type] = "member_type",
  [sym_keyword_argument] = "keyword_argument",
  [sym_list] = "list",
  [sym_set] = "set",
  [sym_tuple] = "tuple",
  [sym_dictionary] = "dictionary",
  [sym_pair] = "pair",
  [sym_list_comprehension] = "list_comprehension",
  [sym_dictionary_comprehension] = "dictionary_comprehension",
  [sym_set_comprehension] = "set_comprehension",
  [sym_generator_expression] = "generator_expression",
  [sym__comprehension_clauses] = "_comprehension_clauses",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__collection_elements] = "_collection_elements",
  [sym_for_in_clause] = "for_in_clause",
  [sym_if_clause] = "if_clause",
  [sym_conditional_expression] = "conditional_expression",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string] = "string",
  [sym_string_content] = "string_content",
  [sym_interpolation] = "interpolation",
  [sym__f_expression] = "_f_expression",
  [sym_format_specifier] = "format_specifier",
  [sym_await] = "await",
  [sym_positional_separator] = "positional_separator",
  [sym_keyword_separator] = "keyword_separator",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym__simple_statements_repeat1] = "_simple_statements_repeat1",
  [aux_sym_import_prefix_repeat1] = "import_prefix_repeat1",
  [aux_sym__import_list_repeat1] = "_import_list_repeat1",
  [aux_sym_print_statement_repeat1] = "print_statement_repeat1",
  [aux_sym_assert_statement_repeat1] = "assert_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_match_statement_repeat1] = "match_statement_repeat1",
  [aux_sym__match_block_repeat1] = "_match_block_repeat1",
  [aux_sym_case_clause_repeat1] = "case_clause_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_try_statement_repeat2] = "try_statement_repeat2",
  [aux_sym_with_clause_repeat1] = "with_clause_repeat1",
  [aux_sym_global_statement_repeat1] = "global_statement_repeat1",
  [aux_sym_type_parameter_repeat1] = "type_parameter_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_decorated_definition_repeat1] = "decorated_definition_repeat1",
  [aux_sym_dotted_name_repeat1] = "dotted_name_repeat1",
  [aux_sym_union_pattern_repeat1] = "union_pattern_repeat1",
  [aux_sym_dict_pattern_repeat1] = "dict_pattern_repeat1",
  [aux_sym__parameters_repeat1] = "_parameters_repeat1",
  [aux_sym__patterns_repeat1] = "_patterns_repeat1",
  [aux_sym_comparison_operator_repeat1] = "comparison_operator_repeat1",
  [aux_sym_subscript_repeat1] = "subscript_repeat1",
  [aux_sym_dictionary_repeat1] = "dictionary_repeat1",
  [aux_sym__comprehension_clauses_repeat1] = "_comprehension_clauses_repeat1",
  [aux_sym__collection_elements_repeat1] = "_collection_elements_repeat1",
  [aux_sym_for_in_clause_repeat1] = "for_in_clause_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_content_repeat1] = "string_content_repeat1",
  [aux_sym_format_specifier_repeat1] = "format_specifier_repeat1",
  [alias_sym_as_pattern_target] = "as_pattern_target",
  [alias_sym_format_expression] = "format_expression",
  [anon_alias_sym_isnot] = "is not",
  [anon_alias_sym_notin] = "not in",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_from] = anon_sym_from,
  [anon_sym___future__] = anon_sym___future__,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_del] = anon_sym_del,
  [anon_sym_raise] = anon_sym_raise,
  [anon_sym_pass] = anon_sym_pass,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_except] = anon_sym_except,
  [anon_sym_except_STAR] = anon_sym_except_STAR,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_nonlocal] = anon_sym_nonlocal,
  [anon_sym_exec] = anon_sym_exec,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym__] = anon_sym__,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_lambda] = anon_sym_lambda,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AT_EQ] = anon_sym_AT_EQ,
  [anon_sym_SLASH_SLASH_EQ] = anon_sym_SLASH_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_yield] = anon_sym_yield,
  [sym_ellipsis] = sym_ellipsis,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__not_escape_sequence] = sym__not_escape_sequence,
  [aux_sym_format_specifier_token1] = aux_sym_format_specifier_token1,
  [sym_type_conversion] = sym_type_conversion,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_await] = anon_sym_await,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_none] = sym_none,
  [sym_comment] = sym_comment,
  [sym_line_continuation] = sym_line_continuation,
  [sym__newline] = sym__newline,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym_string_start] = sym_string_start,
  [sym__string_content] = sym__string_content,
  [sym_escape_interpolation] = sym_escape_interpolation,
  [sym_string_end] = sym_string_end,
  [sym_module] = sym_module,
  [sym__statement] = sym__statement,
  [sym__simple_statements] = sym__simple_statements,
  [sym_import_statement] = sym_import_statement,
  [sym_import_prefix] = sym_import_prefix,
  [sym_relative_import] = sym_relative_import,
  [sym_future_import_statement] = sym_future_import_statement,
  [sym_import_from_statement] = sym_import_from_statement,
  [sym__import_list] = sym__import_list,
  [sym_aliased_import] = sym_aliased_import,
  [sym_wildcard_import] = sym_wildcard_import,
  [sym_print_statement] = sym_print_statement,
  [sym_chevron] = sym_chevron,
  [sym_assert_statement] = sym_assert_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_named_expression] = sym_named_expression,
  [sym__named_expression_lhs] = sym__named_expression_lhs,
  [sym_return_statement] = sym_return_statement,
  [sym_delete_statement] = sym_delete_statement,
  [sym_raise_statement] = sym_raise_statement,
  [sym_pass_statement] = sym_pass_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_match_statement] = sym_match_statement,
  [sym__match_block] = sym_block,
  [sym_case_clause] = sym_case_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_except_clause] = sym_except_clause,
  [sym_except_group_clause] = sym_except_group_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_with_statement] = sym_with_statement,
  [sym_with_clause] = sym_with_clause,
  [sym_with_item] = sym_with_item,
  [sym_function_definition] = sym_function_definition,
  [sym_parameters] = sym_parameters,
  [sym_lambda_parameters] = sym_lambda_parameters,
  [sym_list_splat] = sym_list_splat,
  [sym_dictionary_splat] = sym_dictionary_splat,
  [sym_global_statement] = sym_global_statement,
  [sym_nonlocal_statement] = sym_nonlocal_statement,
  [sym_exec_statement] = sym_exec_statement,
  [sym_type_alias_statement] = sym_type_alias_statement,
  [sym_class_definition] = sym_class_definition,
  [sym_type_parameter] = sym_type_parameter,
  [sym_parenthesized_list_splat] = sym_parenthesized_list_splat,
  [sym_argument_list] = sym_argument_list,
  [sym_decorated_definition] = sym_decorated_definition,
  [sym_decorator] = sym_decorator,
  [sym_block] = sym_block,
  [sym_expression_list] = sym_expression_list,
  [sym_dotted_name] = sym_dotted_name,
  [sym_case_pattern] = sym_case_pattern,
  [sym__simple_pattern] = sym__simple_pattern,
  [sym__as_pattern] = sym_as_pattern,
  [sym_union_pattern] = sym_union_pattern,
  [sym__list_pattern] = sym_list_pattern,
  [sym__tuple_pattern] = sym_tuple_pattern,
  [sym_dict_pattern] = sym_dict_pattern,
  [sym__key_value_pattern] = sym__key_value_pattern,
  [sym_keyword_pattern] = sym_keyword_pattern,
  [sym_splat_pattern] = sym_splat_pattern,
  [sym_class_pattern] = sym_class_pattern,
  [sym_complex_pattern] = sym_complex_pattern,
  [sym__parameters] = sym__parameters,
  [sym__patterns] = sym__patterns,
  [sym_parameter] = sym_parameter,
  [sym_pattern] = sym_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym_default_parameter] = sym_default_parameter,
  [sym_typed_default_parameter] = sym_typed_default_parameter,
  [sym_list_splat_pattern] = sym_list_splat_pattern,
  [sym_dictionary_splat_pattern] = sym_dictionary_splat_pattern,
  [sym_as_pattern] = sym_as_pattern,
  [sym__expression_within_for_in_clause] = sym__expression_within_for_in_clause,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_not_operator] = sym_not_operator,
  [sym_boolean_operator] = sym_boolean_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_lambda] = sym_lambda,
  [sym_lambda_within_for_in_clause] = sym_lambda,
  [sym_assignment] = sym_assignment,
  [sym_augmented_assignment] = sym_augmented_assignment,
  [sym_pattern_list] = sym_pattern_list,
  [sym__right_hand_side] = sym__right_hand_side,
  [sym_yield] = sym_yield,
  [sym_attribute] = sym_attribute,
  [sym_subscript] = sym_subscript,
  [sym_slice] = sym_slice,
  [sym_call] = sym_call,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_type] = sym_type,
  [sym_splat_type] = sym_splat_type,
  [sym_generic_type] = sym_generic_type,
  [sym_union_type] = sym_union_type,
  [sym_constrained_type] = sym_constrained_type,
  [sym_member_type] = sym_member_type,
  [sym_keyword_argument] = sym_keyword_argument,
  [sym_list] = sym_list,
  [sym_set] = sym_set,
  [sym_tuple] = sym_tuple,
  [sym_dictionary] = sym_dictionary,
  [sym_pair] = sym_pair,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_dictionary_comprehension] = sym_dictionary_comprehension,
  [sym_set_comprehension] = sym_set_comprehension,
  [sym_generator_expression] = sym_generator_expression,
  [sym__comprehension_clauses] = sym__comprehension_clauses,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__collection_elements] = sym__collection_elements,
  [sym_for_in_clause] = sym_for_in_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string] = sym_string,
  [sym_string_content] = sym_string_content,
  [sym_interpolation] = sym_interpolation,
  [sym__f_expression] = sym__f_expression,
  [sym_format_specifier] = sym_format_specifier,
  [sym_await] = sym_await,
  [sym_positional_separator] = sym_positional_separator,
  [sym_keyword_separator] = sym_keyword_separator,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym__simple_statements_repeat1] = aux_sym__simple_statements_repeat1,
  [aux_sym_import_prefix_repeat1] = aux_sym_import_prefix_repeat1,
  [aux_sym__import_list_repeat1] = aux_sym__import_list_repeat1,
  [aux_sym_print_statement_repeat1] = aux_sym_print_statement_repeat1,
  [aux_sym_assert_statement_repeat1] = aux_sym_assert_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_match_statement_repeat1] = aux_sym_match_statement_repeat1,
  [aux_sym__match_block_repeat1] = aux_sym__match_block_repeat1,
  [aux_sym_case_clause_repeat1] = aux_sym_case_clause_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_try_statement_repeat2] = aux_sym_try_statement_repeat2,
  [aux_sym_with_clause_repeat1] = aux_sym_with_clause_repeat1,
  [aux_sym_global_statement_repeat1] = aux_sym_global_statement_repeat1,
  [aux_sym_type_parameter_repeat1] = aux_sym_type_parameter_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_decorated_definition_repeat1] = aux_sym_decorated_definition_repeat1,
  [aux_sym_dotted_name_repeat1] = aux_sym_dotted_name_repeat1,
  [aux_sym_union_pattern_repeat1] = aux_sym_union_pattern_repeat1,
  [aux_sym_dict_pattern_repeat1] = aux_sym_dict_pattern_repeat1,
  [aux_sym__parameters_repeat1] = aux_sym__parameters_repeat1,
  [aux_sym__patterns_repeat1] = aux_sym__patterns_repeat1,
  [aux_sym_comparison_operator_repeat1] = aux_sym_comparison_operator_repeat1,
  [aux_sym_subscript_repeat1] = aux_sym_subscript_repeat1,
  [aux_sym_dictionary_repeat1] = aux_sym_dictionary_repeat1,
  [aux_sym__comprehension_clauses_repeat1] = aux_sym__comprehension_clauses_repeat1,
  [aux_sym__collection_elements_repeat1] = aux_sym__collection_elements_repeat1,
  [aux_sym_for_in_clause_repeat1] = aux_sym_for_in_clause_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_content_repeat1] = aux_sym_string_content_repeat1,
  [aux_sym_format_specifier_repeat1] = aux_sym_format_specifier_repeat1,
  [alias_sym_as_pattern_target] = alias_sym_as_pattern_target,
  [alias_sym_format_expression] = alias_sym_format_expression,
  [anon_alias_sym_isnot] = anon_alias_sym_isnot,
  [anon_alias_sym_notin] = anon_alias_sym_notin,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___future__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_del] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonlocal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lambda] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [sym_ellipsis] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__not_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_format_specifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_type_conversion] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_none] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_continuation] = {
    .visible = true,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym_string_start] = {
    .visible = true,
    .named = true,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_string_end] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_statements] = {
    .visible = false,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_relative_import] = {
    .visible = true,
    .named = true,
  },
  [sym_future_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_from_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__import_list] = {
    .visible = false,
    .named = true,
  },
  [sym_aliased_import] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard_import] = {
    .visible = true,
    .named = true,
  },
  [sym_print_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_chevron] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_named_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__named_expression_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_raise_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_match_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__match_block] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_except_group_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_global_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_nonlocal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_decorated_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_name] = {
    .visible = true,
    .named = true,
  },
  [sym_case_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_union_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dict_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__key_value_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_class_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_complex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__patterns] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_within_for_in_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_not_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_within_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_list] = {
    .visible = true,
    .named = true,
  },
  [sym__right_hand_side] = {
    .visible = false,
    .named = true,
  },
  [sym_yield] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_slice] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_splat_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constrained_type] = {
    .visible = true,
    .named = true,
  },
  [sym_member_type] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_set_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__comprehension_clauses] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__collection_elements] = {
    .visible = false,
    .named = true,
  },
  [sym_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__f_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_format_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_await] = {
    .visible = true,
    .named = true,
  },
  [sym_positional_separator] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_separator] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__import_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_print_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assert_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__match_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decorated_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dotted_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dict_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comparison_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comprehension_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__collection_elements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_in_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_as_pattern_target] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_format_expression] = {
    .visible = true,
    .named = true,
  },
  [anon_alias_sym_isnot] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_notin] = {
    .visible = true,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_cause = 7,
  field_code = 8,
  field_condition = 9,
  field_consequence = 10,
  field_definition = 11,
  field_expression = 12,
  field_format_specifier = 13,
  field_function = 14,
  field_guard = 15,
  field_key = 16,
  field_left = 17,
  field_module_name = 18,
  field_name = 19,
  field_object = 20,
  field_operator = 21,
  field_operators = 22,
  field_parameters = 23,
  field_return_type = 24,
  field_right = 25,
  field_subject = 26,
  field_subscript = 27,
  field_superclasses = 28,
  field_type = 29,
  field_type_conversion = 30,
  field_type_parameters = 31,
  field_value = 32,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_cause] = "cause",
  [field_code] = "code",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_definition] = "definition",
  [field_expression] = "expression",
  [field_format_specifier] = "format_specifier",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_key] = "key",
  [field_left] = "left",
  [field_module_name] = "module_name",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_operators] = "operators",
  [field_parameters] = "parameters",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_subject] = "subject",
  [field_subscript] = "subscript",
  [field_superclasses] = "superclasses",
  [field_type] = "type",
  [field_type_conversion] = "type_conversion",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [6] = {.index = 2, .length = 1},
  [7] = {.index = 3, .length = 1},
  [8] = {.index = 4, .length = 1},
  [9] = {.index = 5, .length = 2},
  [10] = {.index = 7, .length = 2},
  [11] = {.index = 9, .length = 1},
  [12] = {.index = 10, .length = 1},
  [13] = {.index = 11, .length = 2},
  [14] = {.index = 13, .length = 1},
  [15] = {.index = 14, .length = 2},
  [16] = {.index = 16, .length = 1},
  [17] = {.index = 17, .length = 1},
  [18] = {.index = 18, .length = 2},
  [19] = {.index = 20, .length = 2},
  [20] = {.index = 22, .length = 2},
  [21] = {.index = 24, .length = 3},
  [22] = {.index = 27, .length = 1},
  [23] = {.index = 28, .length = 2},
  [24] = {.index = 30, .length = 1},
  [25] = {.index = 31, .length = 2},
  [26] = {.index = 33, .length = 1},
  [27] = {.index = 34, .length = 1},
  [28] = {.index = 35, .length = 2},
  [29] = {.index = 37, .length = 2},
  [30] = {.index = 39, .length = 1},
  [31] = {.index = 40, .length = 2},
  [32] = {.index = 42, .length = 1},
  [34] = {.index = 43, .length = 1},
  [35] = {.index = 44, .length = 2},
  [36] = {.index = 46, .length = 1},
  [37] = {.index = 47, .length = 2},
  [38] = {.index = 49, .length = 1},
  [39] = {.index = 50, .length = 3},
  [40] = {.index = 53, .length = 2},
  [41] = {.index = 55, .length = 2},
  [42] = {.index = 17, .length = 1},
  [43] = {.index = 57, .length = 1},
  [44] = {.index = 58, .length = 2},
  [45] = {.index = 60, .length = 2},
  [46] = {.index = 62, .length = 1},
  [47] = {.index = 63, .length = 2},
  [48] = {.index = 65, .length = 2},
  [49] = {.index = 67, .length = 2},
  [50] = {.index = 67, .length = 2},
  [52] = {.index = 69, .length = 2},
  [53] = {.index = 71, .length = 2},
  [54] = {.index = 73, .length = 1},
  [55] = {.index = 74, .length = 3},
  [56] = {.index = 77, .length = 3},
  [57] = {.index = 80, .length = 3},
  [58] = {.index = 83, .length = 3},
  [59] = {.index = 86, .length = 4},
  [60] = {.index = 90, .length = 1},
  [61] = {.index = 91, .length = 3},
  [62] = {.index = 94, .length = 3},
  [63] = {.index = 97, .length = 2},
  [64] = {.index = 99, .length = 2},
  [65] = {.index = 101, .length = 3},
  [66] = {.index = 104, .length = 3},
  [67] = {.index = 107, .length = 3},
  [68] = {.index = 110, .length = 3},
  [69] = {.index = 113, .length = 3},
  [70] = {.index = 18, .length = 2},
  [71] = {.index = 116, .length = 1},
  [72] = {.index = 117, .length = 3},
  [73] = {.index = 120, .length = 2},
  [74] = {.index = 122, .length = 2},
  [75] = {.index = 124, .length = 2},
  [76] = {.index = 126, .length = 3},
  [77] = {.index = 129, .length = 1},
  [78] = {.index = 130, .length = 2},
  [79] = {.index = 132, .length = 2},
  [80] = {.index = 134, .length = 4},
  [81] = {.index = 138, .length = 2},
  [82] = {.index = 140, .length = 4},
  [83] = {.index = 144, .length = 4},
  [84] = {.index = 148, .length = 1},
  [85] = {.index = 149, .length = 4},
  [86] = {.index = 153, .length = 2},
  [87] = {.index = 155, .length = 3},
  [88] = {.index = 158, .length = 3},
  [89] = {.index = 161, .length = 4},
  [91] = {.index = 165, .length = 4},
  [92] = {.index = 169, .length = 4},
  [93] = {.index = 173, .length = 4},
  [94] = {.index = 177, .length = 4},
  [95] = {.index = 181, .length = 4},
  [96] = {.index = 185, .length = 3},
  [97] = {.index = 188, .length = 3},
  [98] = {.index = 191, .length = 2},
  [99] = {.index = 193, .length = 3},
  [100] = {.index = 196, .length = 5},
  [101] = {.index = 201, .length = 3},
  [102] = {.index = 204, .length = 4},
  [103] = {.index = 208, .length = 4},
  [104] = {.index = 212, .length = 4},
  [105] = {.index = 216, .length = 4},
  [107] = {.index = 220, .length = 4},
  [108] = {.index = 224, .length = 5},
  [109] = {.index = 229, .length = 5},
  [110] = {.index = 234, .length = 3},
  [111] = {.index = 237, .length = 2},
  [112] = {.index = 239, .length = 1},
  [113] = {.index = 240, .length = 4},
  [114] = {.index = 244, .length = 4},
  [115] = {.index = 248, .length = 4},
  [116] = {.index = 252, .length = 5},
  [117] = {.index = 257, .length = 5},
  [118] = {.index = 262, .length = 5},
  [119] = {.index = 267, .length = 5},
  [120] = {.index = 272, .length = 4},
  [121] = {.index = 276, .length = 4},
  [122] = {.index = 280, .length = 2},
  [123] = {.index = 282, .length = 1},
  [124] = {.index = 283, .length = 2},
  [125] = {.index = 285, .length = 2},
  [126] = {.index = 287, .length = 5},
  [127] = {.index = 292, .length = 5},
  [128] = {.index = 297, .length = 5},
  [130] = {.index = 302, .length = 6},
  [131] = {.index = 308, .length = 2},
  [132] = {.index = 310, .length = 2},
  [133] = {.index = 312, .length = 3},
  [134] = {.index = 315, .length = 1},
  [135] = {.index = 316, .length = 6},
  [136] = {.index = 322, .length = 3},
  [137] = {.index = 325, .length = 2},
  [138] = {.index = 327, .length = 2},
  [139] = {.index = 329, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1, .inherited = true},
  [1] =
    {field_name, 0},
  [2] =
    {field_argument, 1},
  [3] =
    {field_value, 0},
  [4] =
    {field_code, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_operators, 1, .inherited = true},
  [10] =
    {field_definition, 1},
  [11] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [13] =
    {field_argument, 2, .inherited = true},
  [14] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
  [16] =
    {field_cause, 2},
  [17] =
    {field_body, 2},
  [18] =
    {field_name, 0},
    {field_value, 2},
  [20] =
    {field_left, 0},
    {field_type, 2},
  [22] =
    {field_left, 0},
    {field_right, 2},
  [24] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [27] =
    {field_alias, 2},
  [28] =
    {field_attribute, 2},
    {field_object, 0},
  [30] =
    {field_operators, 0},
  [31] =
    {field_operators, 0, .inherited = true},
    {field_operators, 1, .inherited = true},
  [33] =
    {field_expression, 1},
  [34] =
    {field_name, 1},
  [35] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [37] =
    {field_alias, 2},
    {field_name, 0},
  [39] =
    {field_name, 3, .inherited = true},
  [40] =
    {field_module_name, 1},
    {field_name, 3, .inherited = true},
  [42] =
    {field_module_name, 1},
  [43] =
    {field_body, 1},
  [44] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [46] =
    {field_cause, 3},
  [47] =
    {field_condition, 1},
    {field_consequence, 3},
  [49] =
    {field_subject, 1},
  [50] =
    {field_alternative, 3, .inherited = true},
    {field_body, 3},
    {field_subject, 1},
  [53] =
    {field_subject, 0, .inherited = true},
    {field_subject, 1, .inherited = true},
  [55] =
    {field_body, 3},
    {field_condition, 1},
  [57] =
    {field_body, 3},
  [58] =
    {field_body, 3},
    {field_name, 1},
  [60] =
    {field_key, 0},
    {field_value, 2},
  [62] =
    {field_type, 2},
  [63] =
    {field_body, 3},
    {field_parameters, 1},
  [65] =
    {field_subscript, 2},
    {field_value, 0},
  [67] =
    {field_operators, 0},
    {field_operators, 1},
  [69] =
    {field_expression, 1},
    {field_type_conversion, 2},
  [71] =
    {field_expression, 1},
    {field_format_specifier, 2},
  [73] =
    {field_alternative, 0},
  [74] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [77] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [80] =
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [83] =
    {field_alternative, 4, .inherited = true},
    {field_body, 4},
    {field_subject, 1},
  [86] =
    {field_alternative, 4, .inherited = true},
    {field_body, 4},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [90] =
    {field_body, 4},
  [91] =
    {field_alternative, 4},
    {field_body, 3},
    {field_condition, 1},
  [94] =
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [97] =
    {field_body, 2},
    {field_body, 3},
  [99] =
    {field_body, 3},
    {field_body, 4},
  [101] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [104] =
    {field_body, 3},
    {field_body, 4},
    {field_name, 1},
  [107] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [110] =
    {field_body, 4},
    {field_name, 1},
    {field_superclasses, 2},
  [113] =
    {field_left, 0},
    {field_right, 4},
    {field_type, 2},
  [116] =
    {field_subscript, 1},
  [117] =
    {field_subscript, 2},
    {field_subscript, 3, .inherited = true},
    {field_value, 0},
  [120] =
    {field_subscript, 0, .inherited = true},
    {field_subscript, 1, .inherited = true},
  [122] =
    {field_expression, 1},
    {field_type_conversion, 3},
  [124] =
    {field_expression, 1},
    {field_format_specifier, 3},
  [126] =
    {field_expression, 1},
    {field_format_specifier, 3},
    {field_type_conversion, 2},
  [129] =
    {field_name, 4, .inherited = true},
  [130] =
    {field_module_name, 1},
    {field_name, 4, .inherited = true},
  [132] =
    {field_left, 1},
    {field_right, 3},
  [134] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [138] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [140] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [144] =
    {field_alternative, 5, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [148] =
    {field_alternative, 1, .inherited = true},
  [149] =
    {field_alternative, 5, .inherited = true},
    {field_body, 5},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [153] =
    {field_body, 4},
    {field_body, 5},
  [155] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [158] =
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [161] =
    {field_alternative, 5},
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [165] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
  [169] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [173] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_type_parameters, 2},
  [177] =
    {field_body, 5},
    {field_name, 1},
    {field_superclasses, 3},
    {field_type_parameters, 2},
  [181] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_superclasses, 2},
  [185] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 4},
  [188] =
    {field_expression, 1},
    {field_format_specifier, 4},
    {field_type_conversion, 3},
  [191] =
    {field_left, 2},
    {field_right, 4},
  [193] =
    {field_left, 1},
    {field_right, 3},
    {field_right, 4},
  [196] =
    {field_alternative, 5, .inherited = true},
    {field_alternative, 6},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [201] =
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [204] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
  [208] =
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [212] =
    {field_alternative, 6},
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [216] =
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [220] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [224] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [229] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 1},
    {field_superclasses, 3},
    {field_type_parameters, 2},
  [234] =
    {field_left, 2},
    {field_right, 4},
    {field_right, 5},
  [237] =
    {field_key, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [239] =
    {field_consequence, 3},
  [240] =
    {field_alternative, 7},
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [244] =
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [248] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [252] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [257] =
    {field_alternative, 7},
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [262] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [267] =
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [272] =
    {field_key, 1, .inherited = true},
    {field_key, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [276] =
    {field_key, 0, .inherited = true},
    {field_key, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [280] =
    {field_key, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [282] =
    {field_consequence, 4},
  [283] =
    {field_consequence, 3},
    {field_consequence, 4},
  [285] =
    {field_consequence, 4},
    {field_guard, 2},
  [287] =
    {field_alternative, 8},
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [292] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [297] =
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [302] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [308] =
    {field_consequence, 4},
    {field_consequence, 5},
  [310] =
    {field_consequence, 5},
    {field_guard, 3},
  [312] =
    {field_consequence, 4},
    {field_consequence, 5},
    {field_guard, 2},
  [315] =
    {field_consequence, 5},
  [316] =
    {field_body, 8},
    {field_body, 9},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [322] =
    {field_consequence, 5},
    {field_consequence, 6},
    {field_guard, 3},
  [325] =
    {field_consequence, 5},
    {field_consequence, 6},
  [327] =
    {field_consequence, 6},
    {field_guard, 4},
  [329] =
    {field_consequence, 6},
    {field_consequence, 7},
    {field_guard, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [2] = {
    [0] = sym_list_splat,
  },
  [5] = {
    [1] = sym_identifier,
  },
  [22] = {
    [2] = alias_sym_as_pattern_target,
  },
  [33] = {
    [1] = sym_parenthesized_expression,
  },
  [37] = {
    [3] = sym_block,
  },
  [41] = {
    [3] = sym_block,
  },
  [42] = {
    [2] = sym_block,
  },
  [43] = {
    [3] = sym_block,
  },
  [44] = {
    [3] = sym_block,
  },
  [49] = {
    [0] = anon_alias_sym_notin,
    [1] = anon_alias_sym_notin,
  },
  [50] = {
    [0] = anon_alias_sym_isnot,
    [1] = anon_alias_sym_isnot,
  },
  [51] = {
    [0] = alias_sym_format_expression,
  },
  [55] = {
    [3] = sym_block,
  },
  [56] = {
    [3] = sym_block,
  },
  [60] = {
    [4] = sym_block,
  },
  [61] = {
    [3] = sym_block,
  },
  [65] = {
    [4] = sym_block,
  },
  [67] = {
    [4] = sym_block,
  },
  [68] = {
    [4] = sym_block,
  },
  [70] = {
    [0] = sym_identifier,
  },
  [80] = {
    [3] = sym_block,
  },
  [87] = {
    [5] = sym_block,
  },
  [88] = {
    [5] = sym_block,
  },
  [90] = {
    [2] = sym_block,
  },
  [92] = {
    [5] = sym_block,
  },
  [94] = {
    [5] = sym_block,
  },
  [101] = {
    [6] = sym_block,
  },
  [103] = {
    [6] = sym_block,
  },
  [104] = {
    [5] = sym_block,
  },
  [106] = {
    [3] = sym_block,
  },
  [107] = {
    [6] = sym_block,
  },
  [112] = {
    [3] = sym_block,
  },
  [113] = {
    [6] = sym_block,
  },
  [115] = {
    [7] = sym_block,
  },
  [119] = {
    [7] = sym_block,
  },
  [123] = {
    [4] = sym_block,
  },
  [125] = {
    [4] = sym_block,
  },
  [128] = {
    [8] = sym_block,
  },
  [129] = {
    [5] = sym_block,
  },
  [132] = {
    [5] = sym_block,
  },
  [134] = {
    [5] = sym_block,
  },
  [138] = {
    [6] = sym_block,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__simple_statements, 2,
    sym__simple_statements,
    sym_block,
  sym_parenthesized_list_splat, 2,
    sym_parenthesized_list_splat,
    sym_parenthesized_expression,
  sym_list_splat_pattern, 2,
    sym_list_splat_pattern,
    sym_list_splat,
  sym_expression, 2,
    sym_expression,
    alias_sym_as_pattern_target,
  sym_interpolation, 2,
    sym_interpolation,
    alias_sym_format_expression,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 11,
  [16] = 16,
  [17] = 16,
  [18] = 6,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 2,
  [24] = 24,
  [25] = 25,
  [26] = 20,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 4,
  [34] = 32,
  [35] = 5,
  [36] = 13,
  [37] = 22,
  [38] = 7,
  [39] = 9,
  [40] = 24,
  [41] = 41,
  [42] = 42,
  [43] = 12,
  [44] = 44,
  [45] = 19,
  [46] = 46,
  [47] = 28,
  [48] = 48,
  [49] = 44,
  [50] = 25,
  [51] = 30,
  [52] = 52,
  [53] = 14,
  [54] = 54,
  [55] = 29,
  [56] = 54,
  [57] = 31,
  [58] = 46,
  [59] = 3,
  [60] = 10,
  [61] = 27,
  [62] = 62,
  [63] = 62,
  [64] = 64,
  [65] = 62,
  [66] = 66,
  [67] = 62,
  [68] = 62,
  [69] = 62,
  [70] = 66,
  [71] = 62,
  [72] = 62,
  [73] = 73,
  [74] = 73,
  [75] = 75,
  [76] = 75,
  [77] = 77,
  [78] = 78,
  [79] = 78,
  [80] = 80,
  [81] = 77,
  [82] = 80,
  [83] = 83,
  [84] = 83,
  [85] = 85,
  [86] = 85,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 87,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 101,
  [103] = 91,
  [104] = 89,
  [105] = 92,
  [106] = 96,
  [107] = 107,
  [108] = 108,
  [109] = 98,
  [110] = 107,
  [111] = 111,
  [112] = 112,
  [113] = 99,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 112,
  [124] = 100,
  [125] = 122,
  [126] = 117,
  [127] = 127,
  [128] = 94,
  [129] = 108,
  [130] = 114,
  [131] = 95,
  [132] = 111,
  [133] = 93,
  [134] = 88,
  [135] = 118,
  [136] = 121,
  [137] = 137,
  [138] = 137,
  [139] = 139,
  [140] = 137,
  [141] = 139,
  [142] = 137,
  [143] = 137,
  [144] = 139,
  [145] = 139,
  [146] = 139,
  [147] = 137,
  [148] = 137,
  [149] = 139,
  [150] = 139,
  [151] = 137,
  [152] = 139,
  [153] = 153,
  [154] = 154,
  [155] = 154,
  [156] = 156,
  [157] = 157,
  [158] = 156,
  [159] = 154,
  [160] = 157,
  [161] = 161,
  [162] = 156,
  [163] = 163,
  [164] = 156,
  [165] = 157,
  [166] = 166,
  [167] = 157,
  [168] = 161,
  [169] = 157,
  [170] = 163,
  [171] = 163,
  [172] = 154,
  [173] = 157,
  [174] = 157,
  [175] = 161,
  [176] = 176,
  [177] = 161,
  [178] = 161,
  [179] = 157,
  [180] = 156,
  [181] = 156,
  [182] = 154,
  [183] = 166,
  [184] = 161,
  [185] = 161,
  [186] = 161,
  [187] = 176,
  [188] = 156,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 191,
  [194] = 189,
  [195] = 195,
  [196] = 189,
  [197] = 195,
  [198] = 195,
  [199] = 189,
  [200] = 195,
  [201] = 190,
  [202] = 189,
  [203] = 189,
  [204] = 195,
  [205] = 195,
  [206] = 189,
  [207] = 191,
  [208] = 191,
  [209] = 189,
  [210] = 191,
  [211] = 189,
  [212] = 195,
  [213] = 191,
  [214] = 189,
  [215] = 191,
  [216] = 216,
  [217] = 191,
  [218] = 195,
  [219] = 189,
  [220] = 191,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 224,
  [226] = 224,
  [227] = 227,
  [228] = 227,
  [229] = 229,
  [230] = 229,
  [231] = 229,
  [232] = 224,
  [233] = 229,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 235,
  [238] = 236,
  [239] = 239,
  [240] = 236,
  [241] = 234,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 236,
  [248] = 236,
  [249] = 236,
  [250] = 236,
  [251] = 223,
  [252] = 252,
  [253] = 253,
  [254] = 222,
  [255] = 235,
  [256] = 256,
  [257] = 236,
  [258] = 258,
  [259] = 235,
  [260] = 234,
  [261] = 261,
  [262] = 242,
  [263] = 239,
  [264] = 252,
  [265] = 261,
  [266] = 245,
  [267] = 261,
  [268] = 234,
  [269] = 269,
  [270] = 261,
  [271] = 271,
  [272] = 272,
  [273] = 272,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 278,
  [280] = 278,
  [281] = 272,
  [282] = 276,
  [283] = 274,
  [284] = 275,
  [285] = 275,
  [286] = 277,
  [287] = 274,
  [288] = 288,
  [289] = 272,
  [290] = 277,
  [291] = 276,
  [292] = 278,
  [293] = 288,
  [294] = 277,
  [295] = 272,
  [296] = 288,
  [297] = 276,
  [298] = 288,
  [299] = 277,
  [300] = 278,
  [301] = 274,
  [302] = 275,
  [303] = 272,
  [304] = 276,
  [305] = 274,
  [306] = 275,
  [307] = 288,
  [308] = 276,
  [309] = 275,
  [310] = 272,
  [311] = 274,
  [312] = 275,
  [313] = 288,
  [314] = 274,
  [315] = 275,
  [316] = 288,
  [317] = 277,
  [318] = 277,
  [319] = 274,
  [320] = 277,
  [321] = 276,
  [322] = 272,
  [323] = 288,
  [324] = 278,
  [325] = 276,
  [326] = 326,
  [327] = 327,
  [328] = 176,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 327,
  [334] = 332,
  [335] = 331,
  [336] = 330,
  [337] = 337,
  [338] = 326,
  [339] = 337,
  [340] = 327,
  [341] = 332,
  [342] = 326,
  [343] = 343,
  [344] = 331,
  [345] = 330,
  [346] = 346,
  [347] = 337,
  [348] = 348,
  [349] = 348,
  [350] = 350,
  [351] = 253,
  [352] = 348,
  [353] = 253,
  [354] = 348,
  [355] = 355,
  [356] = 356,
  [357] = 355,
  [358] = 355,
  [359] = 348,
  [360] = 355,
  [361] = 348,
  [362] = 348,
  [363] = 355,
  [364] = 356,
  [365] = 356,
  [366] = 348,
  [367] = 355,
  [368] = 253,
  [369] = 355,
  [370] = 355,
  [371] = 156,
  [372] = 372,
  [373] = 372,
  [374] = 374,
  [375] = 375,
  [376] = 372,
  [377] = 377,
  [378] = 378,
  [379] = 343,
  [380] = 372,
  [381] = 374,
  [382] = 346,
  [383] = 378,
  [384] = 378,
  [385] = 385,
  [386] = 372,
  [387] = 387,
  [388] = 374,
  [389] = 378,
  [390] = 374,
  [391] = 374,
  [392] = 372,
  [393] = 372,
  [394] = 374,
  [395] = 378,
  [396] = 374,
  [397] = 372,
  [398] = 378,
  [399] = 378,
  [400] = 374,
  [401] = 401,
  [402] = 378,
  [403] = 372,
  [404] = 372,
  [405] = 374,
  [406] = 378,
  [407] = 374,
  [408] = 378,
  [409] = 176,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 176,
  [414] = 410,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 411,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 415,
  [427] = 419,
  [428] = 346,
  [429] = 416,
  [430] = 430,
  [431] = 343,
  [432] = 410,
  [433] = 343,
  [434] = 410,
  [435] = 410,
  [436] = 424,
  [437] = 416,
  [438] = 438,
  [439] = 410,
  [440] = 440,
  [441] = 410,
  [442] = 424,
  [443] = 410,
  [444] = 423,
  [445] = 176,
  [446] = 411,
  [447] = 156,
  [448] = 448,
  [449] = 410,
  [450] = 450,
  [451] = 430,
  [452] = 452,
  [453] = 410,
  [454] = 454,
  [455] = 455,
  [456] = 401,
  [457] = 346,
  [458] = 430,
  [459] = 459,
  [460] = 423,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 462,
  [468] = 468,
  [469] = 461,
  [470] = 463,
  [471] = 468,
  [472] = 346,
  [473] = 466,
  [474] = 474,
  [475] = 465,
  [476] = 474,
  [477] = 464,
  [478] = 478,
  [479] = 343,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 483,
  [487] = 482,
  [488] = 488,
  [489] = 484,
  [490] = 485,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 480,
  [497] = 497,
  [498] = 498,
  [499] = 480,
  [500] = 481,
  [501] = 501,
  [502] = 491,
  [503] = 501,
  [504] = 481,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 510,
  [512] = 485,
  [513] = 513,
  [514] = 501,
  [515] = 481,
  [516] = 485,
  [517] = 484,
  [518] = 501,
  [519] = 488,
  [520] = 482,
  [521] = 508,
  [522] = 522,
  [523] = 483,
  [524] = 524,
  [525] = 484,
  [526] = 522,
  [527] = 493,
  [528] = 492,
  [529] = 485,
  [530] = 491,
  [531] = 485,
  [532] = 508,
  [533] = 510,
  [534] = 484,
  [535] = 501,
  [536] = 488,
  [537] = 491,
  [538] = 482,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 510,
  [543] = 491,
  [544] = 509,
  [545] = 488,
  [546] = 546,
  [547] = 483,
  [548] = 548,
  [549] = 548,
  [550] = 480,
  [551] = 508,
  [552] = 540,
  [553] = 488,
  [554] = 480,
  [555] = 548,
  [556] = 491,
  [557] = 485,
  [558] = 481,
  [559] = 548,
  [560] = 484,
  [561] = 548,
  [562] = 506,
  [563] = 488,
  [564] = 548,
  [565] = 565,
  [566] = 483,
  [567] = 482,
  [568] = 548,
  [569] = 482,
  [570] = 488,
  [571] = 484,
  [572] = 482,
  [573] = 501,
  [574] = 548,
  [575] = 508,
  [576] = 485,
  [577] = 483,
  [578] = 505,
  [579] = 522,
  [580] = 580,
  [581] = 501,
  [582] = 582,
  [583] = 583,
  [584] = 480,
  [585] = 491,
  [586] = 491,
  [587] = 480,
  [588] = 522,
  [589] = 481,
  [590] = 501,
  [591] = 483,
  [592] = 497,
  [593] = 498,
  [594] = 480,
  [595] = 595,
  [596] = 483,
  [597] = 583,
  [598] = 546,
  [599] = 482,
  [600] = 580,
  [601] = 495,
  [602] = 488,
  [603] = 484,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 606,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 614,
  [616] = 613,
  [617] = 610,
  [618] = 612,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 621,
  [624] = 611,
  [625] = 620,
  [626] = 626,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 628,
  [632] = 632,
  [633] = 633,
  [634] = 634,
  [635] = 629,
  [636] = 636,
  [637] = 630,
  [638] = 638,
  [639] = 639,
  [640] = 640,
  [641] = 641,
  [642] = 642,
  [643] = 643,
  [644] = 634,
  [645] = 645,
  [646] = 632,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 647,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 653,
  [657] = 647,
  [658] = 658,
  [659] = 654,
  [660] = 653,
  [661] = 661,
  [662] = 662,
  [663] = 663,
  [664] = 655,
  [665] = 652,
  [666] = 647,
  [667] = 652,
  [668] = 651,
  [669] = 649,
  [670] = 658,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 672,
  [675] = 671,
  [676] = 658,
  [677] = 223,
  [678] = 655,
  [679] = 222,
  [680] = 653,
  [681] = 655,
  [682] = 658,
  [683] = 652,
  [684] = 655,
  [685] = 658,
  [686] = 648,
  [687] = 673,
  [688] = 647,
  [689] = 653,
  [690] = 655,
  [691] = 652,
  [692] = 658,
  [693] = 661,
  [694] = 647,
  [695] = 653,
  [696] = 662,
  [697] = 652,
  [698] = 663,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 700,
  [703] = 703,
  [704] = 703,
  [705] = 705,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 710,
  [711] = 711,
  [712] = 707,
  [713] = 705,
  [714] = 708,
  [715] = 699,
  [716] = 701,
  [717] = 711,
  [718] = 709,
  [719] = 710,
  [720] = 706,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 722,
  [725] = 723,
  [726] = 721,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 739,
  [740] = 727,
  [741] = 741,
  [742] = 742,
  [743] = 738,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 757,
  [758] = 758,
  [759] = 759,
  [760] = 760,
  [761] = 761,
  [762] = 762,
  [763] = 763,
  [764] = 764,
  [765] = 756,
  [766] = 766,
  [767] = 755,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 734,
  [774] = 774,
  [775] = 742,
  [776] = 735,
  [777] = 746,
  [778] = 760,
  [779] = 770,
  [780] = 780,
  [781] = 744,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 729,
  [786] = 786,
  [787] = 774,
  [788] = 788,
  [789] = 741,
  [790] = 736,
  [791] = 791,
  [792] = 763,
  [793] = 784,
  [794] = 794,
  [795] = 795,
  [796] = 753,
  [797] = 752,
  [798] = 798,
  [799] = 799,
  [800] = 800,
  [801] = 801,
  [802] = 791,
  [803] = 731,
  [804] = 732,
  [805] = 751,
  [806] = 786,
  [807] = 761,
  [808] = 762,
  [809] = 764,
  [810] = 766,
  [811] = 768,
  [812] = 769,
  [813] = 798,
  [814] = 814,
  [815] = 800,
  [816] = 750,
  [817] = 817,
  [818] = 818,
  [819] = 749,
  [820] = 222,
  [821] = 818,
  [822] = 801,
  [823] = 799,
  [824] = 771,
  [825] = 742,
  [826] = 754,
  [827] = 783,
  [828] = 739,
  [829] = 738,
  [830] = 748,
  [831] = 728,
  [832] = 730,
  [833] = 737,
  [834] = 772,
  [835] = 788,
  [836] = 747,
  [837] = 837,
  [838] = 794,
  [839] = 223,
  [840] = 795,
  [841] = 758,
  [842] = 733,
  [843] = 780,
  [844] = 837,
  [845] = 782,
  [846] = 759,
  [847] = 757,
  [848] = 745,
  [849] = 814,
  [850] = 817,
  [851] = 851,
  [852] = 851,
  [853] = 851,
  [854] = 851,
  [855] = 851,
  [856] = 851,
  [857] = 857,
  [858] = 857,
  [859] = 859,
  [860] = 859,
  [861] = 859,
  [862] = 859,
  [863] = 859,
  [864] = 859,
  [865] = 859,
  [866] = 859,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 868,
  [871] = 871,
  [872] = 872,
  [873] = 869,
  [874] = 872,
  [875] = 868,
  [876] = 876,
  [877] = 877,
  [878] = 878,
  [879] = 869,
  [880] = 880,
  [881] = 871,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 886,
  [887] = 876,
  [888] = 877,
  [889] = 872,
  [890] = 868,
  [891] = 869,
  [892] = 868,
  [893] = 868,
  [894] = 876,
  [895] = 883,
  [896] = 886,
  [897] = 878,
  [898] = 880,
  [899] = 885,
  [900] = 868,
  [901] = 886,
  [902] = 885,
  [903] = 884,
  [904] = 882,
  [905] = 871,
  [906] = 880,
  [907] = 878,
  [908] = 877,
  [909] = 877,
  [910] = 876,
  [911] = 878,
  [912] = 883,
  [913] = 884,
  [914] = 882,
  [915] = 871,
  [916] = 880,
  [917] = 877,
  [918] = 878,
  [919] = 880,
  [920] = 871,
  [921] = 882,
  [922] = 882,
  [923] = 880,
  [924] = 884,
  [925] = 885,
  [926] = 878,
  [927] = 886,
  [928] = 871,
  [929] = 877,
  [930] = 882,
  [931] = 884,
  [932] = 884,
  [933] = 885,
  [934] = 886,
  [935] = 885,
  [936] = 886,
  [937] = 876,
  [938] = 876,
  [939] = 883,
  [940] = 883,
  [941] = 872,
  [942] = 883,
  [943] = 877,
  [944] = 877,
  [945] = 878,
  [946] = 880,
  [947] = 871,
  [948] = 882,
  [949] = 884,
  [950] = 885,
  [951] = 886,
  [952] = 868,
  [953] = 878,
  [954] = 868,
  [955] = 880,
  [956] = 868,
  [957] = 871,
  [958] = 882,
  [959] = 868,
  [960] = 867,
  [961] = 884,
  [962] = 885,
  [963] = 868,
  [964] = 869,
  [965] = 886,
  [966] = 883,
  [967] = 869,
  [968] = 872,
  [969] = 876,
  [970] = 876,
  [971] = 869,
  [972] = 868,
  [973] = 869,
  [974] = 883,
  [975] = 975,
  [976] = 976,
  [977] = 977,
  [978] = 978,
  [979] = 975,
  [980] = 976,
  [981] = 981,
  [982] = 982,
  [983] = 983,
  [984] = 984,
  [985] = 985,
  [986] = 986,
  [987] = 987,
  [988] = 976,
  [989] = 989,
  [990] = 990,
  [991] = 978,
  [992] = 992,
  [993] = 975,
  [994] = 977,
  [995] = 995,
  [996] = 977,
  [997] = 978,
  [998] = 998,
  [999] = 986,
  [1000] = 638,
  [1001] = 985,
  [1002] = 977,
  [1003] = 983,
  [1004] = 975,
  [1005] = 982,
  [1006] = 976,
  [1007] = 986,
  [1008] = 977,
  [1009] = 976,
  [1010] = 981,
  [1011] = 640,
  [1012] = 1012,
  [1013] = 977,
  [1014] = 978,
  [1015] = 987,
  [1016] = 977,
  [1017] = 975,
  [1018] = 978,
  [1019] = 976,
  [1020] = 1020,
  [1021] = 976,
  [1022] = 978,
  [1023] = 989,
  [1024] = 977,
  [1025] = 985,
  [1026] = 987,
  [1027] = 995,
  [1028] = 992,
  [1029] = 990,
  [1030] = 975,
  [1031] = 995,
  [1032] = 975,
  [1033] = 641,
  [1034] = 992,
  [1035] = 639,
  [1036] = 633,
  [1037] = 1037,
  [1038] = 998,
  [1039] = 636,
  [1040] = 989,
  [1041] = 626,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 984,
  [1045] = 978,
  [1046] = 998,
  [1047] = 981,
  [1048] = 982,
  [1049] = 990,
  [1050] = 983,
  [1051] = 984,
  [1052] = 1020,
  [1053] = 982,
  [1054] = 986,
  [1055] = 985,
  [1056] = 984,
  [1057] = 1057,
  [1058] = 983,
  [1059] = 982,
  [1060] = 981,
  [1061] = 990,
  [1062] = 640,
  [1063] = 989,
  [1064] = 998,
  [1065] = 987,
  [1066] = 1066,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 638,
  [1072] = 987,
  [1073] = 998,
  [1074] = 626,
  [1075] = 636,
  [1076] = 1020,
  [1077] = 633,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1042,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 992,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 639,
  [1090] = 995,
  [1091] = 641,
  [1092] = 619,
  [1093] = 1093,
  [1094] = 645,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 995,
  [1098] = 1098,
  [1099] = 977,
  [1100] = 992,
  [1101] = 995,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 992,
  [1105] = 978,
  [1106] = 1043,
  [1107] = 1042,
  [1108] = 1012,
  [1109] = 1037,
  [1110] = 643,
  [1111] = 1111,
  [1112] = 642,
  [1113] = 1113,
  [1114] = 622,
  [1115] = 621,
  [1116] = 981,
  [1117] = 1117,
  [1118] = 982,
  [1119] = 983,
  [1120] = 1096,
  [1121] = 984,
  [1122] = 1122,
  [1123] = 985,
  [1124] = 986,
  [1125] = 989,
  [1126] = 990,
  [1127] = 1127,
  [1128] = 984,
  [1129] = 987,
  [1130] = 998,
  [1131] = 976,
  [1132] = 992,
  [1133] = 1133,
  [1134] = 981,
  [1135] = 982,
  [1136] = 983,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 984,
  [1140] = 985,
  [1141] = 1043,
  [1142] = 986,
  [1143] = 1143,
  [1144] = 989,
  [1145] = 1145,
  [1146] = 1146,
  [1147] = 990,
  [1148] = 1012,
  [1149] = 1037,
  [1150] = 975,
  [1151] = 981,
  [1152] = 998,
  [1153] = 987,
  [1154] = 1154,
  [1155] = 983,
  [1156] = 990,
  [1157] = 995,
  [1158] = 989,
  [1159] = 986,
  [1160] = 985,
  [1161] = 641,
  [1162] = 989,
  [1163] = 642,
  [1164] = 628,
  [1165] = 1020,
  [1166] = 630,
  [1167] = 629,
  [1168] = 638,
  [1169] = 1057,
  [1170] = 1154,
  [1171] = 1037,
  [1172] = 1012,
  [1173] = 1043,
  [1174] = 626,
  [1175] = 636,
  [1176] = 633,
  [1177] = 639,
  [1178] = 641,
  [1179] = 977,
  [1180] = 632,
  [1181] = 1020,
  [1182] = 645,
  [1183] = 1117,
  [1184] = 1143,
  [1185] = 1145,
  [1186] = 1146,
  [1187] = 640,
  [1188] = 992,
  [1189] = 995,
  [1190] = 622,
  [1191] = 1096,
  [1192] = 640,
  [1193] = 1127,
  [1194] = 1042,
  [1195] = 1085,
  [1196] = 1042,
  [1197] = 1111,
  [1198] = 1093,
  [1199] = 1084,
  [1200] = 619,
  [1201] = 1066,
  [1202] = 1042,
  [1203] = 1067,
  [1204] = 1069,
  [1205] = 1043,
  [1206] = 1078,
  [1207] = 1012,
  [1208] = 1020,
  [1209] = 1037,
  [1210] = 981,
  [1211] = 1122,
  [1212] = 1103,
  [1213] = 982,
  [1214] = 621,
  [1215] = 1102,
  [1216] = 983,
  [1217] = 984,
  [1218] = 1117,
  [1219] = 639,
  [1220] = 1098,
  [1221] = 1095,
  [1222] = 985,
  [1223] = 986,
  [1224] = 643,
  [1225] = 990,
  [1226] = 1096,
  [1227] = 1070,
  [1228] = 1083,
  [1229] = 1081,
  [1230] = 1080,
  [1231] = 987,
  [1232] = 998,
  [1233] = 1154,
  [1234] = 622,
  [1235] = 977,
  [1236] = 1068,
  [1237] = 1138,
  [1238] = 1133,
  [1239] = 1137,
  [1240] = 1113,
  [1241] = 1057,
  [1242] = 1043,
  [1243] = 1012,
  [1244] = 1083,
  [1245] = 1037,
  [1246] = 621,
  [1247] = 645,
  [1248] = 1081,
  [1249] = 1037,
  [1250] = 642,
  [1251] = 1080,
  [1252] = 643,
  [1253] = 645,
  [1254] = 1012,
  [1255] = 1043,
  [1256] = 1143,
  [1257] = 1145,
  [1258] = 1146,
  [1259] = 1042,
  [1260] = 1020,
  [1261] = 619,
  [1262] = 1127,
  [1263] = 1085,
  [1264] = 1084,
  [1265] = 1066,
  [1266] = 1067,
  [1267] = 1069,
  [1268] = 1078,
  [1269] = 633,
  [1270] = 636,
  [1271] = 626,
  [1272] = 1111,
  [1273] = 1093,
  [1274] = 977,
  [1275] = 1113,
  [1276] = 1137,
  [1277] = 1133,
  [1278] = 638,
  [1279] = 1122,
  [1280] = 1138,
  [1281] = 1103,
  [1282] = 1102,
  [1283] = 1098,
  [1284] = 1095,
  [1285] = 1068,
  [1286] = 1070,
  [1287] = 1095,
  [1288] = 1085,
  [1289] = 1068,
  [1290] = 1117,
  [1291] = 645,
  [1292] = 1070,
  [1293] = 1066,
  [1294] = 1067,
  [1295] = 1069,
  [1296] = 1138,
  [1297] = 1154,
  [1298] = 1066,
  [1299] = 1068,
  [1300] = 1133,
  [1301] = 1138,
  [1302] = 1067,
  [1303] = 1133,
  [1304] = 1137,
  [1305] = 1113,
  [1306] = 1057,
  [1307] = 1088,
  [1308] = 1087,
  [1309] = 1078,
  [1310] = 1079,
  [1311] = 1078,
  [1312] = 641,
  [1313] = 1154,
  [1314] = 639,
  [1315] = 1113,
  [1316] = 1137,
  [1317] = 1093,
  [1318] = 1111,
  [1319] = 1070,
  [1320] = 633,
  [1321] = 1122,
  [1322] = 636,
  [1323] = 1069,
  [1324] = 626,
  [1325] = 1133,
  [1326] = 1138,
  [1327] = 1068,
  [1328] = 1103,
  [1329] = 1102,
  [1330] = 1098,
  [1331] = 1095,
  [1332] = 642,
  [1333] = 643,
  [1334] = 627,
  [1335] = 1070,
  [1336] = 1154,
  [1337] = 1057,
  [1338] = 1084,
  [1339] = 638,
  [1340] = 1037,
  [1341] = 629,
  [1342] = 630,
  [1343] = 1012,
  [1344] = 1068,
  [1345] = 1043,
  [1346] = 1138,
  [1347] = 1133,
  [1348] = 1085,
  [1349] = 1154,
  [1350] = 1143,
  [1351] = 1093,
  [1352] = 1145,
  [1353] = 1111,
  [1354] = 1146,
  [1355] = 1355,
  [1356] = 1070,
  [1357] = 1095,
  [1358] = 1098,
  [1359] = 1102,
  [1360] = 1137,
  [1361] = 1113,
  [1362] = 1127,
  [1363] = 1363,
  [1364] = 1103,
  [1365] = 1057,
  [1366] = 1127,
  [1367] = 1117,
  [1368] = 1122,
  [1369] = 643,
  [1370] = 642,
  [1371] = 1098,
  [1372] = 1102,
  [1373] = 1103,
  [1374] = 628,
  [1375] = 1122,
  [1376] = 1078,
  [1377] = 1095,
  [1378] = 1146,
  [1379] = 1145,
  [1380] = 641,
  [1381] = 645,
  [1382] = 639,
  [1383] = 1098,
  [1384] = 1143,
  [1385] = 632,
  [1386] = 1111,
  [1387] = 1078,
  [1388] = 640,
  [1389] = 1093,
  [1390] = 1122,
  [1391] = 640,
  [1392] = 645,
  [1393] = 640,
  [1394] = 632,
  [1395] = 1102,
  [1396] = 645,
  [1397] = 633,
  [1398] = 636,
  [1399] = 628,
  [1400] = 630,
  [1401] = 629,
  [1402] = 1069,
  [1403] = 1067,
  [1404] = 1066,
  [1405] = 1069,
  [1406] = 1067,
  [1407] = 627,
  [1408] = 1093,
  [1409] = 1111,
  [1410] = 1042,
  [1411] = 626,
  [1412] = 645,
  [1413] = 643,
  [1414] = 1057,
  [1415] = 1084,
  [1416] = 1085,
  [1417] = 642,
  [1418] = 1103,
  [1419] = 629,
  [1420] = 1020,
  [1421] = 630,
  [1422] = 1066,
  [1423] = 1127,
  [1424] = 638,
  [1425] = 628,
  [1426] = 641,
  [1427] = 1084,
  [1428] = 1137,
  [1429] = 642,
  [1430] = 1127,
  [1431] = 639,
  [1432] = 1117,
  [1433] = 1117,
  [1434] = 1143,
  [1435] = 1113,
  [1436] = 1145,
  [1437] = 643,
  [1438] = 638,
  [1439] = 1146,
  [1440] = 1085,
  [1441] = 1084,
  [1442] = 645,
  [1443] = 632,
  [1444] = 1143,
  [1445] = 1145,
  [1446] = 626,
  [1447] = 636,
  [1448] = 1146,
  [1449] = 633,
  [1450] = 1057,
  [1451] = 1081,
  [1452] = 1111,
  [1453] = 627,
  [1454] = 1133,
  [1455] = 1138,
  [1456] = 1137,
  [1457] = 1068,
  [1458] = 1143,
  [1459] = 1093,
  [1460] = 627,
  [1461] = 1145,
  [1462] = 1146,
  [1463] = 1080,
  [1464] = 1154,
  [1465] = 1113,
  [1466] = 1081,
  [1467] = 1083,
  [1468] = 1070,
  [1469] = 1127,
  [1470] = 1117,
  [1471] = 1078,
  [1472] = 1095,
  [1473] = 1098,
  [1474] = 1083,
  [1475] = 1085,
  [1476] = 1080,
  [1477] = 1102,
  [1478] = 1084,
  [1479] = 1066,
  [1480] = 640,
  [1481] = 638,
  [1482] = 1103,
  [1483] = 1122,
  [1484] = 626,
  [1485] = 1067,
  [1486] = 1069,
  [1487] = 643,
  [1488] = 636,
  [1489] = 642,
  [1490] = 645,
  [1491] = 639,
  [1492] = 641,
  [1493] = 1083,
  [1494] = 1081,
  [1495] = 1080,
  [1496] = 633,
  [1497] = 641,
  [1498] = 630,
  [1499] = 638,
  [1500] = 628,
  [1501] = 632,
  [1502] = 629,
  [1503] = 636,
  [1504] = 633,
  [1505] = 639,
  [1506] = 642,
  [1507] = 640,
  [1508] = 1363,
  [1509] = 1355,
  [1510] = 643,
  [1511] = 626,
  [1512] = 645,
  [1513] = 645,
  [1514] = 645,
  [1515] = 645,
  [1516] = 1516,
  [1517] = 1517,
  [1518] = 1518,
  [1519] = 1519,
  [1520] = 1518,
  [1521] = 1521,
  [1522] = 1518,
  [1523] = 1523,
  [1524] = 1524,
  [1525] = 1525,
  [1526] = 1521,
  [1527] = 1527,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1524,
  [1531] = 1524,
  [1532] = 1519,
  [1533] = 1527,
  [1534] = 1519,
  [1535] = 1523,
  [1536] = 1527,
  [1537] = 1519,
  [1538] = 1527,
  [1539] = 1518,
  [1540] = 1528,
  [1541] = 1529,
  [1542] = 1523,
  [1543] = 1524,
  [1544] = 1528,
  [1545] = 1525,
  [1546] = 1521,
  [1547] = 1529,
  [1548] = 1525,
  [1549] = 1525,
  [1550] = 1523,
  [1551] = 1528,
  [1552] = 1521,
  [1553] = 1529,
  [1554] = 1554,
  [1555] = 1555,
  [1556] = 1556,
  [1557] = 1554,
  [1558] = 1554,
  [1559] = 1559,
  [1560] = 1560,
  [1561] = 1561,
  [1562] = 1562,
  [1563] = 1563,
  [1564] = 1562,
  [1565] = 1563,
  [1566] = 1559,
  [1567] = 1563,
  [1568] = 1561,
  [1569] = 1559,
  [1570] = 1561,
  [1571] = 1560,
  [1572] = 1563,
  [1573] = 1560,
  [1574] = 1560,
  [1575] = 1562,
  [1576] = 1561,
  [1577] = 1559,
  [1578] = 1562,
  [1579] = 1579,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 1581,
  [1583] = 1581,
  [1584] = 1580,
  [1585] = 1581,
  [1586] = 1580,
  [1587] = 1580,
  [1588] = 1588,
  [1589] = 1589,
  [1590] = 628,
  [1591] = 632,
  [1592] = 1355,
  [1593] = 1588,
  [1594] = 1363,
  [1595] = 1589,
  [1596] = 1588,
  [1597] = 1589,
  [1598] = 629,
  [1599] = 630,
  [1600] = 1588,
  [1601] = 1588,
  [1602] = 1589,
  [1603] = 1588,
  [1604] = 1589,
  [1605] = 1589,
  [1606] = 643,
  [1607] = 642,
  [1608] = 1608,
  [1609] = 1609,
  [1610] = 1588,
  [1611] = 1611,
  [1612] = 645,
  [1613] = 1589,
  [1614] = 1589,
  [1615] = 1615,
  [1616] = 1616,
  [1617] = 1588,
  [1618] = 643,
  [1619] = 1619,
  [1620] = 1619,
  [1621] = 1619,
  [1622] = 630,
  [1623] = 1619,
  [1624] = 1619,
  [1625] = 642,
  [1626] = 1363,
  [1627] = 1355,
  [1628] = 1628,
  [1629] = 1355,
  [1630] = 629,
  [1631] = 1619,
  [1632] = 1363,
  [1633] = 1619,
  [1634] = 628,
  [1635] = 1635,
  [1636] = 1616,
  [1637] = 1609,
  [1638] = 629,
  [1639] = 1608,
  [1640] = 632,
  [1641] = 1619,
  [1642] = 630,
  [1643] = 632,
  [1644] = 645,
  [1645] = 628,
  [1646] = 1355,
  [1647] = 629,
  [1648] = 1363,
  [1649] = 1649,
  [1650] = 1619,
  [1651] = 630,
  [1652] = 628,
  [1653] = 1653,
  [1654] = 1619,
  [1655] = 632,
  [1656] = 1656,
  [1657] = 1656,
  [1658] = 1658,
  [1659] = 1656,
  [1660] = 1656,
  [1661] = 1615,
  [1662] = 1656,
  [1663] = 1656,
  [1664] = 1635,
  [1665] = 1656,
  [1666] = 1666,
  [1667] = 1658,
  [1668] = 1628,
  [1669] = 1656,
  [1670] = 1670,
  [1671] = 1670,
  [1672] = 1653,
  [1673] = 1649,
  [1674] = 1658,
  [1675] = 1611,
  [1676] = 1676,
  [1677] = 1677,
  [1678] = 1678,
  [1679] = 1679,
  [1680] = 1678,
  [1681] = 1677,
  [1682] = 1682,
  [1683] = 1682,
  [1684] = 1684,
  [1685] = 1685,
  [1686] = 1684,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1684,
  [1691] = 1684,
  [1692] = 1692,
  [1693] = 1693,
  [1694] = 1684,
  [1695] = 1684,
  [1696] = 1696,
  [1697] = 1697,
  [1698] = 1684,
  [1699] = 1699,
  [1700] = 1684,
  [1701] = 1701,
  [1702] = 1701,
  [1703] = 1701,
  [1704] = 1704,
  [1705] = 1704,
  [1706] = 1706,
  [1707] = 1706,
  [1708] = 1706,
  [1709] = 1709,
  [1710] = 1701,
  [1711] = 1704,
  [1712] = 1706,
  [1713] = 1706,
  [1714] = 1701,
  [1715] = 1701,
  [1716] = 1704,
  [1717] = 1717,
  [1718] = 1706,
  [1719] = 1706,
  [1720] = 1704,
  [1721] = 1704,
  [1722] = 1706,
  [1723] = 1701,
  [1724] = 1704,
  [1725] = 1701,
  [1726] = 1704,
  [1727] = 1727,
  [1728] = 1728,
  [1729] = 1693,
  [1730] = 1727,
  [1731] = 1728,
  [1732] = 1732,
  [1733] = 1728,
  [1734] = 1697,
  [1735] = 1685,
  [1736] = 1727,
  [1737] = 1692,
  [1738] = 1689,
  [1739] = 1728,
  [1740] = 1692,
  [1741] = 1699,
  [1742] = 1727,
  [1743] = 1728,
  [1744] = 1697,
  [1745] = 1699,
  [1746] = 1685,
  [1747] = 1728,
  [1748] = 1693,
  [1749] = 1689,
  [1750] = 1688,
  [1751] = 1687,
  [1752] = 1752,
  [1753] = 1753,
  [1754] = 1688,
  [1755] = 1753,
  [1756] = 1728,
  [1757] = 1727,
  [1758] = 1687,
  [1759] = 1727,
  [1760] = 1696,
  [1761] = 1761,
  [1762] = 1696,
  [1763] = 1728,
  [1764] = 1727,
  [1765] = 1728,
  [1766] = 1727,
  [1767] = 1727,
  [1768] = 1687,
  [1769] = 1697,
  [1770] = 1696,
  [1771] = 1688,
  [1772] = 1699,
  [1773] = 1693,
  [1774] = 1689,
  [1775] = 1697,
  [1776] = 1685,
  [1777] = 1689,
  [1778] = 1688,
  [1779] = 1779,
  [1780] = 1685,
  [1781] = 1781,
  [1782] = 1693,
  [1783] = 1687,
  [1784] = 1688,
  [1785] = 1697,
  [1786] = 1753,
  [1787] = 1692,
  [1788] = 1692,
  [1789] = 1692,
  [1790] = 1790,
  [1791] = 1699,
  [1792] = 1792,
  [1793] = 1687,
  [1794] = 1685,
  [1795] = 1696,
  [1796] = 1753,
  [1797] = 1797,
  [1798] = 1798,
  [1799] = 1696,
  [1800] = 1693,
  [1801] = 1699,
  [1802] = 1689,
  [1803] = 1803,
  [1804] = 1697,
  [1805] = 1805,
  [1806] = 1806,
  [1807] = 1807,
  [1808] = 1808,
  [1809] = 1687,
  [1810] = 1697,
  [1811] = 1699,
  [1812] = 1812,
  [1813] = 1813,
  [1814] = 1685,
  [1815] = 1807,
  [1816] = 1693,
  [1817] = 1817,
  [1818] = 1805,
  [1819] = 1692,
  [1820] = 1820,
  [1821] = 1803,
  [1822] = 1689,
  [1823] = 1696,
  [1824] = 1824,
  [1825] = 1825,
  [1826] = 1688,
  [1827] = 1806,
  [1828] = 1824,
  [1829] = 1752,
  [1830] = 1830,
  [1831] = 1807,
  [1832] = 1687,
  [1833] = 1813,
  [1834] = 1807,
  [1835] = 1807,
  [1836] = 1836,
  [1837] = 1817,
  [1838] = 1807,
  [1839] = 1817,
  [1840] = 1803,
  [1841] = 1830,
  [1842] = 1803,
  [1843] = 1692,
  [1844] = 1806,
  [1845] = 1805,
  [1846] = 1699,
  [1847] = 1807,
  [1848] = 1693,
  [1849] = 1849,
  [1850] = 1781,
  [1851] = 1696,
  [1852] = 1807,
  [1853] = 1853,
  [1854] = 1807,
  [1855] = 1685,
  [1856] = 1689,
  [1857] = 1688,
  [1858] = 1858,
  [1859] = 1859,
  [1860] = 1807,
  [1861] = 1861,
  [1862] = 1862,
  [1863] = 1798,
  [1864] = 1864,
  [1865] = 1779,
  [1866] = 1779,
  [1867] = 1867,
  [1868] = 1868,
  [1869] = 1867,
  [1870] = 1867,
  [1871] = 1871,
  [1872] = 1872,
  [1873] = 1864,
  [1874] = 1874,
  [1875] = 1864,
  [1876] = 1862,
  [1877] = 1798,
  [1878] = 1871,
  [1879] = 1879,
  [1880] = 1880,
  [1881] = 1881,
  [1882] = 1882,
  [1883] = 1883,
  [1884] = 1879,
  [1885] = 1885,
  [1886] = 1862,
  [1887] = 1812,
  [1888] = 1779,
  [1889] = 1798,
  [1890] = 1862,
  [1891] = 1891,
  [1892] = 1862,
  [1893] = 1893,
  [1894] = 1752,
  [1895] = 1812,
  [1896] = 1862,
  [1897] = 1891,
  [1898] = 1812,
  [1899] = 1899,
  [1900] = 1790,
  [1901] = 1790,
  [1902] = 1868,
  [1903] = 1903,
  [1904] = 1891,
  [1905] = 1862,
  [1906] = 1906,
  [1907] = 1885,
  [1908] = 1908,
  [1909] = 1862,
  [1910] = 1910,
  [1911] = 1752,
  [1912] = 1868,
  [1913] = 1790,
  [1914] = 1798,
  [1915] = 1915,
  [1916] = 1916,
  [1917] = 1917,
  [1918] = 1918,
  [1919] = 1919,
  [1920] = 1797,
  [1921] = 1921,
  [1922] = 1922,
  [1923] = 1923,
  [1924] = 1924,
  [1925] = 1925,
  [1926] = 1926,
  [1927] = 1927,
  [1928] = 1925,
  [1929] = 1927,
  [1930] = 1922,
  [1931] = 1931,
  [1932] = 1881,
  [1933] = 1933,
  [1934] = 1934,
  [1935] = 1935,
  [1936] = 1936,
  [1937] = 1937,
  [1938] = 1938,
  [1939] = 1925,
  [1940] = 1940,
  [1941] = 1941,
  [1942] = 1926,
  [1943] = 1797,
  [1944] = 1944,
  [1945] = 1945,
  [1946] = 1781,
  [1947] = 1947,
  [1948] = 1927,
  [1949] = 1836,
  [1950] = 1950,
  [1951] = 1945,
  [1952] = 1952,
  [1953] = 1944,
  [1954] = 1908,
  [1955] = 1955,
  [1956] = 1934,
  [1957] = 1957,
  [1958] = 1781,
  [1959] = 1959,
  [1960] = 1797,
  [1961] = 1961,
  [1962] = 1950,
  [1963] = 1963,
  [1964] = 1964,
  [1965] = 1965,
  [1966] = 1941,
  [1967] = 1944,
  [1968] = 1968,
  [1969] = 1969,
  [1970] = 1836,
  [1971] = 1971,
  [1972] = 1836,
  [1973] = 1881,
  [1974] = 1974,
  [1975] = 1947,
  [1976] = 1781,
  [1977] = 1615,
  [1978] = 1978,
  [1979] = 1979,
  [1980] = 1974,
  [1981] = 1981,
  [1982] = 1940,
  [1983] = 1983,
  [1984] = 1984,
  [1985] = 1985,
  [1986] = 1908,
  [1987] = 1959,
  [1988] = 1968,
  [1989] = 1989,
  [1990] = 1990,
  [1991] = 1790,
  [1992] = 1925,
  [1993] = 1961,
  [1994] = 1994,
  [1995] = 1965,
  [1996] = 1947,
  [1997] = 1964,
  [1998] = 1974,
  [1999] = 1922,
  [2000] = 2000,
  [2001] = 1963,
  [2002] = 1779,
  [2003] = 1957,
  [2004] = 1937,
  [2005] = 1881,
  [2006] = 1825,
  [2007] = 2007,
  [2008] = 2008,
  [2009] = 2009,
  [2010] = 1990,
  [2011] = 1908,
  [2012] = 1926,
  [2013] = 2009,
  [2014] = 1611,
  [2015] = 1940,
  [2016] = 1957,
  [2017] = 1937,
  [2018] = 1941,
  [2019] = 2019,
  [2020] = 2020,
  [2021] = 2021,
  [2022] = 2022,
  [2023] = 2007,
  [2024] = 1628,
  [2025] = 2025,
  [2026] = 2026,
  [2027] = 1955,
  [2028] = 1969,
  [2029] = 1981,
  [2030] = 2030,
  [2031] = 2031,
  [2032] = 2019,
  [2033] = 2033,
  [2034] = 1917,
  [2035] = 2035,
  [2036] = 2008,
  [2037] = 2037,
  [2038] = 1968,
  [2039] = 1959,
  [2040] = 2040,
  [2041] = 2041,
  [2042] = 1969,
  [2043] = 1955,
  [2044] = 1934,
  [2045] = 2045,
  [2046] = 2046,
  [2047] = 2026,
  [2048] = 2008,
  [2049] = 2049,
  [2050] = 2050,
  [2051] = 1968,
  [2052] = 1959,
  [2053] = 2053,
  [2054] = 2031,
  [2055] = 2040,
  [2056] = 2056,
  [2057] = 2057,
  [2058] = 2035,
  [2059] = 2059,
  [2060] = 2060,
  [2061] = 1927,
  [2062] = 1965,
  [2063] = 1964,
  [2064] = 2064,
  [2065] = 2065,
  [2066] = 2066,
  [2067] = 1864,
  [2068] = 1965,
  [2069] = 2069,
  [2070] = 2040,
  [2071] = 2071,
  [2072] = 2072,
  [2073] = 1964,
  [2074] = 2074,
  [2075] = 1917,
  [2076] = 2019,
  [2077] = 1963,
  [2078] = 2078,
  [2079] = 2057,
  [2080] = 2080,
  [2081] = 2081,
  [2082] = 2082,
  [2083] = 2083,
  [2084] = 2064,
  [2085] = 1635,
  [2086] = 2086,
  [2087] = 2087,
  [2088] = 2088,
  [2089] = 2089,
  [2090] = 2090,
  [2091] = 2091,
  [2092] = 1963,
  [2093] = 2093,
  [2094] = 2094,
  [2095] = 2095,
  [2096] = 2031,
  [2097] = 1957,
  [2098] = 1649,
  [2099] = 1836,
  [2100] = 2100,
  [2101] = 2053,
  [2102] = 1921,
  [2103] = 2083,
  [2104] = 2104,
  [2105] = 2105,
  [2106] = 2026,
  [2107] = 2031,
  [2108] = 2108,
  [2109] = 1938,
  [2110] = 1955,
  [2111] = 1969,
  [2112] = 1938,
  [2113] = 2113,
  [2114] = 2031,
  [2115] = 1938,
  [2116] = 2116,
  [2117] = 2117,
  [2118] = 2008,
  [2119] = 2033,
  [2120] = 2090,
  [2121] = 2121,
  [2122] = 1917,
  [2123] = 2089,
  [2124] = 2031,
  [2125] = 2031,
  [2126] = 2126,
  [2127] = 2040,
  [2128] = 2128,
  [2129] = 2019,
  [2130] = 1653,
  [2131] = 2059,
  [2132] = 2031,
  [2133] = 2035,
  [2134] = 2134,
  [2135] = 2059,
  [2136] = 1937,
  [2137] = 1934,
  [2138] = 2088,
  [2139] = 2139,
  [2140] = 2140,
  [2141] = 2141,
  [2142] = 2142,
  [2143] = 2143,
  [2144] = 2081,
  [2145] = 2128,
  [2146] = 2146,
  [2147] = 2022,
  [2148] = 2126,
  [2149] = 2149,
  [2150] = 2093,
  [2151] = 2151,
  [2152] = 2082,
  [2153] = 2153,
  [2154] = 2074,
  [2155] = 2104,
  [2156] = 2030,
  [2157] = 2157,
  [2158] = 2143,
  [2159] = 2159,
  [2160] = 2160,
  [2161] = 2139,
  [2162] = 2162,
  [2163] = 2021,
  [2164] = 2164,
  [2165] = 2050,
  [2166] = 2037,
  [2167] = 2121,
  [2168] = 2033,
  [2169] = 2087,
  [2170] = 2104,
  [2171] = 2171,
  [2172] = 2172,
  [2173] = 2173,
  [2174] = 2174,
  [2175] = 2025,
  [2176] = 2060,
  [2177] = 2177,
  [2178] = 2178,
  [2179] = 2117,
  [2180] = 2105,
  [2181] = 2100,
  [2182] = 2095,
  [2183] = 2183,
  [2184] = 2094,
  [2185] = 2113,
  [2186] = 2033,
  [2187] = 2091,
  [2188] = 2121,
  [2189] = 2134,
  [2190] = 2045,
  [2191] = 2104,
  [2192] = 2192,
  [2193] = 2021,
  [2194] = 2194,
  [2195] = 2172,
  [2196] = 2157,
  [2197] = 2197,
  [2198] = 2066,
  [2199] = 2078,
  [2200] = 2153,
  [2201] = 2201,
  [2202] = 2071,
  [2203] = 2071,
  [2204] = 2128,
  [2205] = 2205,
  [2206] = 2157,
  [2207] = 2172,
  [2208] = 2066,
  [2209] = 2022,
  [2210] = 2045,
  [2211] = 2134,
  [2212] = 2091,
  [2213] = 2113,
  [2214] = 2183,
  [2215] = 2126,
  [2216] = 2094,
  [2217] = 2095,
  [2218] = 2100,
  [2219] = 2093,
  [2220] = 2082,
  [2221] = 2105,
  [2222] = 2164,
  [2223] = 2223,
  [2224] = 2117,
  [2225] = 2225,
  [2226] = 2226,
  [2227] = 2030,
  [2228] = 2228,
  [2229] = 2229,
  [2230] = 2060,
  [2231] = 2183,
  [2232] = 2232,
  [2233] = 2233,
  [2234] = 2025,
  [2235] = 2037,
  [2236] = 2236,
  [2237] = 2237,
  [2238] = 2183,
  [2239] = 2037,
  [2240] = 2025,
  [2241] = 2060,
  [2242] = 2117,
  [2243] = 2172,
  [2244] = 2157,
  [2245] = 2105,
  [2246] = 2100,
  [2247] = 2030,
  [2248] = 2095,
  [2249] = 2226,
  [2250] = 2094,
  [2251] = 2093,
  [2252] = 2113,
  [2253] = 2126,
  [2254] = 2091,
  [2255] = 2022,
  [2256] = 2128,
  [2257] = 2134,
  [2258] = 2021,
  [2259] = 2121,
  [2260] = 2045,
  [2261] = 2066,
  [2262] = 2082,
  [2263] = 2263,
  [2264] = 2264,
  [2265] = 2071,
  [2266] = 2266,
  [2267] = 2267,
  [2268] = 2268,
  [2269] = 2269,
  [2270] = 2270,
  [2271] = 2236,
  [2272] = 2272,
  [2273] = 653,
  [2274] = 2274,
  [2275] = 2275,
  [2276] = 2276,
  [2277] = 2171,
  [2278] = 2159,
  [2279] = 2279,
  [2280] = 2223,
  [2281] = 2281,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 2284,
  [2285] = 2285,
  [2286] = 2286,
  [2287] = 2287,
  [2288] = 1915,
  [2289] = 2287,
  [2290] = 2290,
  [2291] = 1916,
  [2292] = 1918,
  [2293] = 2293,
  [2294] = 1919,
  [2295] = 1931,
  [2296] = 2296,
  [2297] = 2297,
  [2298] = 2298,
  [2299] = 2299,
  [2300] = 2300,
  [2301] = 1933,
  [2302] = 2302,
  [2303] = 2287,
  [2304] = 655,
  [2305] = 2305,
  [2306] = 2306,
  [2307] = 2307,
  [2308] = 2308,
  [2309] = 2309,
  [2310] = 2310,
  [2311] = 2305,
  [2312] = 2298,
  [2313] = 2313,
  [2314] = 2314,
  [2315] = 2270,
  [2316] = 2316,
  [2317] = 2317,
  [2318] = 2293,
  [2319] = 2319,
  [2320] = 2236,
  [2321] = 2321,
  [2322] = 2322,
  [2323] = 2282,
  [2324] = 1981,
  [2325] = 2325,
  [2326] = 647,
  [2327] = 2327,
  [2328] = 2285,
  [2329] = 2329,
  [2330] = 2286,
  [2331] = 2331,
  [2332] = 2309,
  [2333] = 2333,
  [2334] = 2334,
  [2335] = 2335,
  [2336] = 2284,
  [2337] = 2159,
  [2338] = 2338,
  [2339] = 2316,
  [2340] = 2340,
  [2341] = 2341,
  [2342] = 2342,
  [2343] = 2343,
  [2344] = 2321,
  [2345] = 2345,
  [2346] = 2283,
  [2347] = 2347,
  [2348] = 2335,
  [2349] = 2349,
  [2350] = 2325,
  [2351] = 2351,
  [2352] = 2333,
  [2353] = 2334,
  [2354] = 2333,
  [2355] = 2355,
  [2356] = 2356,
  [2357] = 1978,
  [2358] = 2345,
  [2359] = 2276,
  [2360] = 1615,
  [2361] = 2343,
  [2362] = 2177,
  [2363] = 2363,
  [2364] = 2269,
  [2365] = 2287,
  [2366] = 2345,
  [2367] = 2340,
  [2368] = 1921,
  [2369] = 1020,
  [2370] = 1615,
  [2371] = 2317,
  [2372] = 2298,
  [2373] = 2338,
  [2374] = 2305,
  [2375] = 2274,
  [2376] = 2334,
  [2377] = 2300,
  [2378] = 2314,
  [2379] = 2317,
  [2380] = 2298,
  [2381] = 2276,
  [2382] = 2355,
  [2383] = 2305,
  [2384] = 2384,
  [2385] = 2300,
  [2386] = 2279,
  [2387] = 2279,
  [2388] = 2341,
  [2389] = 1611,
  [2390] = 2317,
  [2391] = 2391,
  [2392] = 2298,
  [2393] = 2305,
  [2394] = 2309,
  [2395] = 2290,
  [2396] = 2307,
  [2397] = 2284,
  [2398] = 2398,
  [2399] = 2269,
  [2400] = 2285,
  [2401] = 2296,
  [2402] = 2297,
  [2403] = 2300,
  [2404] = 2297,
  [2405] = 2300,
  [2406] = 2296,
  [2407] = 2299,
  [2408] = 2281,
  [2409] = 2290,
  [2410] = 2384,
  [2411] = 2411,
  [2412] = 2307,
  [2413] = 2331,
  [2414] = 2309,
  [2415] = 2279,
  [2416] = 2305,
  [2417] = 2298,
  [2418] = 2418,
  [2419] = 2316,
  [2420] = 658,
  [2421] = 2290,
  [2422] = 1653,
  [2423] = 2276,
  [2424] = 2317,
  [2425] = 2287,
  [2426] = 652,
  [2427] = 1921,
  [2428] = 2290,
  [2429] = 2342,
  [2430] = 2302,
  [2431] = 2307,
  [2432] = 2331,
  [2433] = 2286,
  [2434] = 2293,
  [2435] = 2322,
  [2436] = 2343,
  [2437] = 2296,
  [2438] = 2338,
  [2439] = 2298,
  [2440] = 2340,
  [2441] = 2305,
  [2442] = 1615,
  [2443] = 2343,
  [2444] = 2309,
  [2445] = 2345,
  [2446] = 2272,
  [2447] = 2174,
  [2448] = 2307,
  [2449] = 2449,
  [2450] = 2300,
  [2451] = 2451,
  [2452] = 2334,
  [2453] = 1921,
  [2454] = 1981,
  [2455] = 2297,
  [2456] = 2398,
  [2457] = 2296,
  [2458] = 2316,
  [2459] = 2459,
  [2460] = 2296,
  [2461] = 2461,
  [2462] = 2287,
  [2463] = 2290,
  [2464] = 2000,
  [2465] = 2465,
  [2466] = 2297,
  [2467] = 1981,
  [2468] = 2317,
  [2469] = 2279,
  [2470] = 2276,
  [2471] = 2228,
  [2472] = 2472,
  [2473] = 2317,
  [2474] = 2178,
  [2475] = 2300,
  [2476] = 2276,
  [2477] = 2287,
  [2478] = 2411,
  [2479] = 2479,
  [2480] = 2279,
  [2481] = 2279,
  [2482] = 2225,
  [2483] = 2275,
  [2484] = 2340,
  [2485] = 2298,
  [2486] = 2305,
  [2487] = 2309,
  [2488] = 2488,
  [2489] = 2290,
  [2490] = 2307,
  [2491] = 2491,
  [2492] = 2300,
  [2493] = 2349,
  [2494] = 2325,
  [2495] = 2296,
  [2496] = 2297,
  [2497] = 2171,
  [2498] = 2298,
  [2499] = 2300,
  [2500] = 2297,
  [2501] = 2296,
  [2502] = 1042,
  [2503] = 2351,
  [2504] = 2307,
  [2505] = 2459,
  [2506] = 2309,
  [2507] = 2479,
  [2508] = 2305,
  [2509] = 2298,
  [2510] = 2290,
  [2511] = 2331,
  [2512] = 2146,
  [2513] = 2279,
  [2514] = 2159,
  [2515] = 2223,
  [2516] = 2305,
  [2517] = 2276,
  [2518] = 2276,
  [2519] = 2309,
  [2520] = 2307,
  [2521] = 2300,
  [2522] = 2287,
  [2523] = 2338,
  [2524] = 2297,
  [2525] = 2525,
  [2526] = 2236,
  [2527] = 2317,
  [2528] = 2528,
  [2529] = 2529,
  [2530] = 2530,
  [2531] = 652,
  [2532] = 2532,
  [2533] = 2533,
  [2534] = 655,
  [2535] = 2535,
  [2536] = 653,
  [2537] = 2537,
  [2538] = 2538,
  [2539] = 2539,
  [2540] = 2540,
  [2541] = 2541,
  [2542] = 2542,
  [2543] = 2543,
  [2544] = 2544,
  [2545] = 2545,
  [2546] = 1653,
  [2547] = 2547,
  [2548] = 2548,
  [2549] = 2549,
  [2550] = 2550,
  [2551] = 2551,
  [2552] = 2525,
  [2553] = 2065,
  [2554] = 1649,
  [2555] = 2555,
  [2556] = 2065,
  [2557] = 2557,
  [2558] = 2558,
  [2559] = 2559,
  [2560] = 2560,
  [2561] = 2561,
  [2562] = 2562,
  [2563] = 2563,
  [2564] = 2564,
  [2565] = 2530,
  [2566] = 2532,
  [2567] = 647,
  [2568] = 2568,
  [2569] = 2569,
  [2570] = 2549,
  [2571] = 1649,
  [2572] = 2572,
  [2573] = 2356,
  [2574] = 1628,
  [2575] = 2568,
  [2576] = 1635,
  [2577] = 2564,
  [2578] = 2578,
  [2579] = 2579,
  [2580] = 2065,
  [2581] = 2581,
  [2582] = 2582,
  [2583] = 2542,
  [2584] = 2584,
  [2585] = 1635,
  [2586] = 2586,
  [2587] = 2581,
  [2588] = 2543,
  [2589] = 2539,
  [2590] = 2586,
  [2591] = 658,
  [2592] = 2592,
  [2593] = 2593,
  [2594] = 2594,
  [2595] = 2595,
  [2596] = 2596,
  [2597] = 2568,
  [2598] = 2598,
  [2599] = 2561,
  [2600] = 1628,
  [2601] = 2563,
  [2602] = 2602,
  [2603] = 2603,
  [2604] = 2584,
  [2605] = 2605,
  [2606] = 2606,
  [2607] = 2607,
  [2608] = 2310,
  [2609] = 2609,
  [2610] = 2582,
  [2611] = 2611,
  [2612] = 2612,
  [2613] = 2532,
  [2614] = 2579,
  [2615] = 2615,
  [2616] = 2612,
  [2617] = 2563,
  [2618] = 2568,
  [2619] = 2530,
  [2620] = 2612,
  [2621] = 2621,
  [2622] = 2622,
  [2623] = 2563,
  [2624] = 2579,
  [2625] = 2532,
  [2626] = 2530,
  [2627] = 2578,
  [2628] = 2578,
  [2629] = 2629,
  [2630] = 2630,
  [2631] = 2631,
  [2632] = 2632,
  [2633] = 2629,
  [2634] = 2634,
  [2635] = 2635,
  [2636] = 2636,
  [2637] = 2637,
  [2638] = 2638,
  [2639] = 2639,
  [2640] = 2640,
  [2641] = 2641,
  [2642] = 2642,
  [2643] = 2643,
  [2644] = 2644,
  [2645] = 2645,
  [2646] = 2646,
  [2647] = 2647,
  [2648] = 2648,
  [2649] = 2649,
  [2650] = 2642,
  [2651] = 2630,
  [2652] = 2634,
  [2653] = 2653,
  [2654] = 2654,
  [2655] = 2643,
  [2656] = 2631,
  [2657] = 2638,
  [2658] = 2658,
  [2659] = 2654,
  [2660] = 2648,
  [2661] = 2634,
  [2662] = 2662,
  [2663] = 2630,
  [2664] = 2664,
  [2665] = 2654,
  [2666] = 2631,
  [2667] = 2631,
  [2668] = 2643,
  [2669] = 2643,
  [2670] = 2670,
  [2671] = 2671,
  [2672] = 2634,
  [2673] = 2635,
  [2674] = 2630,
  [2675] = 2675,
  [2676] = 2676,
  [2677] = 2637,
  [2678] = 2678,
  [2679] = 2641,
  [2680] = 2654,
  [2681] = 2642,
  [2682] = 2647,
  [2683] = 2648,
  [2684] = 2648,
  [2685] = 2629,
  [2686] = 2645,
  [2687] = 2644,
  [2688] = 2641,
  [2689] = 2689,
  [2690] = 2635,
  [2691] = 2640,
  [2692] = 2654,
  [2693] = 2648,
  [2694] = 2694,
  [2695] = 2695,
  [2696] = 2696,
  [2697] = 2676,
  [2698] = 2637,
  [2699] = 2634,
  [2700] = 2689,
  [2701] = 2642,
  [2702] = 2629,
  [2703] = 2630,
  [2704] = 2694,
  [2705] = 2644,
  [2706] = 2671,
  [2707] = 2689,
  [2708] = 2708,
  [2709] = 2658,
  [2710] = 2648,
  [2711] = 2711,
  [2712] = 2637,
  [2713] = 2713,
  [2714] = 2676,
  [2715] = 2715,
  [2716] = 2716,
  [2717] = 2717,
  [2718] = 2645,
  [2719] = 2644,
  [2720] = 2648,
  [2721] = 2670,
  [2722] = 2722,
  [2723] = 2636,
  [2724] = 2641,
  [2725] = 2717,
  [2726] = 2640,
  [2727] = 2722,
  [2728] = 2642,
  [2729] = 2716,
  [2730] = 2631,
  [2731] = 2731,
  [2732] = 2732,
  [2733] = 2733,
  [2734] = 2715,
  [2735] = 2637,
  [2736] = 2640,
  [2737] = 2737,
  [2738] = 2640,
  [2739] = 2641,
  [2740] = 2695,
  [2741] = 2695,
  [2742] = 2742,
  [2743] = 2644,
  [2744] = 2675,
  [2745] = 2645,
  [2746] = 2696,
  [2747] = 2696,
  [2748] = 2662,
  [2749] = 2648,
  [2750] = 2732,
  [2751] = 2751,
  [2752] = 2638,
  [2753] = 2642,
  [2754] = 2637,
  [2755] = 2644,
  [2756] = 2645,
  [2757] = 2636,
  [2758] = 2676,
  [2759] = 2732,
  [2760] = 2630,
  [2761] = 2675,
  [2762] = 2695,
  [2763] = 2637,
  [2764] = 2634,
  [2765] = 2643,
  [2766] = 2643,
  [2767] = 2640,
  [2768] = 2768,
  [2769] = 2689,
  [2770] = 2631,
  [2771] = 2654,
  [2772] = 2772,
  [2773] = 2630,
  [2774] = 2654,
  [2775] = 2775,
  [2776] = 2776,
  [2777] = 2638,
  [2778] = 2778,
  [2779] = 2629,
  [2780] = 2654,
  [2781] = 2689,
  [2782] = 2629,
  [2783] = 2631,
  [2784] = 2631,
  [2785] = 2643,
  [2786] = 2643,
  [2787] = 2787,
  [2788] = 2634,
  [2789] = 2789,
  [2790] = 2645,
  [2791] = 2635,
  [2792] = 2733,
  [2793] = 2630,
  [2794] = 2794,
  [2795] = 2795,
  [2796] = 2796,
  [2797] = 2796,
  [2798] = 2737,
  [2799] = 2634,
  [2800] = 2676,
  [2801] = 2642,
  [2802] = 2802,
  [2803] = 2629,
  [2804] = 2804,
  [2805] = 2805,
  [2806] = 2642,
  [2807] = 2795,
  [2808] = 2648,
  [2809] = 2641,
  [2810] = 2648,
  [2811] = 2645,
  [2812] = 2645,
  [2813] = 2644,
  [2814] = 2644,
  [2815] = 2776,
  [2816] = 2641,
  [2817] = 2640,
  [2818] = 2695,
  [2819] = 2641,
  [2820] = 2805,
  [2821] = 2646,
  [2822] = 2696,
  [2823] = 2653,
  [2824] = 2649,
  [2825] = 2772,
  [2826] = 2637,
  [2827] = 2768,
  [2828] = 2772,
  [2829] = 2640,
  [2830] = 2629,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < 'a'
                    ? (c >= 'A' && c <= '_')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 910
            ? (c < 736
              ? (c < 186
                ? (c < 'a'
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')
                  : (c <= 'z' || (c < 181
                    ? c == 170
                    : c <= 181)))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))))
              : (c <= 740 || (c < 891
                ? (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || c == 908))))))
            : (c <= 929 || (c < 1649
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2748
        ? (c < 2045
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)))))))))
          : (c <= 2045 || (c < 2558
            ? (c < 2451
              ? (c < 2200
                ? (c < 2144
                  ? (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))
                : (c <= 2273 || (c < 2417
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)
                  : (c <= 2435 || (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)))))
              : (c <= 2472 || (c < 2507
                ? (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)))
                : (c <= 2510 || (c < 2527
                  ? (c < 2524
                    ? c == 2519
                    : c <= 2525)
                  : (c <= 2531 || (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)))))))
            : (c <= 2558 || (c < 2635
              ? (c < 2610
                ? (c < 2575
                  ? (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)
                  : (c <= 2576 || (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)))
                : (c <= 2611 || (c < 2620
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)
                  : (c <= 2620 || (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)))))
              : (c <= 2637 || (c < 2693
                ? (c < 2654
                  ? (c < 2649
                    ? c == 2641
                    : c <= 2652)
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)))))))))))
        : (c <= 2757 || (c < 3168
          ? (c < 2958
            ? (c < 2866
              ? (c < 2809
                ? (c < 2768
                  ? (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)
                  : (c <= 2768 || (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)))
                : (c <= 2815 || (c < 2831
                  ? (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))))
              : (c <= 2867 || (c < 2908
                ? (c < 2887
                  ? (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)
                  : (c <= 2888 || (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)))
                : (c <= 2909 || (c < 2929
                  ? (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)
                  : (c <= 2929 || (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)))))))
            : (c <= 2960 || (c < 3031
              ? (c < 2984
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))
                : (c <= 2986 || (c < 3014
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)
                  : (c <= 3016 || (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)))))
              : (c <= 3031 || (c < 3132
                ? (c < 3086
                  ? (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)
                  : (c <= 3088 || (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)))
                : (c <= 3140 || (c < 3157
                  ? (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)
                  : (c <= 3158 || (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)))))))))
          : (c <= 3171 || (c < 3450
            ? (c < 3293
              ? (c < 3242
                ? (c < 3205
                  ? (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)
                  : (c <= 3212 || (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)))
                : (c <= 3251 || (c < 3270
                  ? (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)
                  : (c <= 3272 || (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)))))
              : (c <= 3294 || (c < 3346
                ? (c < 3313
                  ? (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3396 || (c < 3412
                  ? (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))
            : (c <= 3455 || (c < 3570
              ? (c < 3520
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)
                  : (c <= 3505 || (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)))
                : (c <= 3526 || (c < 3542
                  ? (c < 3535
                    ? c == 3530
                    : c <= 3540)
                  : (c <= 3542 || (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)))))
              : (c <= 3571 || (c < 3718
                ? (c < 3664
                  ? (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)
                  : (c <= 3673 || (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(57);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(53)
      if (lookahead == '\r') SKIP(53)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(97);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(93);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(87);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(58);
      if (lookahead == '<') ADVANCE(107);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(133);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '^') ADVANCE(103);
      if (lookahead == 'e') ADVANCE(163);
      if (lookahead == '{') ADVANCE(90);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '}') ADVANCE(91);
      if (lookahead == '~') ADVANCE(106);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(166);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(168);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(132);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(3)
      if (lookahead == '\r') ADVANCE(135);
      if (lookahead == '#') ADVANCE(136);
      if (lookahead == '\\') ADVANCE(134);
      if (lookahead == '{') ADVANCE(90);
      if (lookahead == '}') ADVANCE(91);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(135);
      if (lookahead != 0) ADVANCE(136);
      END_STATE();
    case 4:
      if (lookahead == '.') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 5:
      if (lookahead == '.') ADVANCE(131);
      END_STATE();
    case 6:
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 7:
      if (lookahead == '<') ADVANCE(17);
      END_STATE();
    case 8:
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 9:
      if (lookahead == '=') ADVANCE(112);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 10:
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 11:
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 12:
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 13:
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 14:
      if (lookahead == '=') ADVANCE(130);
      END_STATE();
    case 15:
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 16:
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 17:
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 18:
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 19:
      if (lookahead == '>') ADVANCE(76);
      END_STATE();
    case 20:
      if (lookahead == '>') ADVANCE(18);
      END_STATE();
    case 21:
      if (lookahead == '_') ADVANCE(28);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(142);
      END_STATE();
    case 22:
      if (lookahead == '_') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(143);
      END_STATE();
    case 23:
      if (lookahead == '_') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(144);
      END_STATE();
    case 24:
      if (lookahead == '{') ADVANCE(52);
      END_STATE();
    case 25:
      if (lookahead == '}') ADVANCE(132);
      if (lookahead != 0) ADVANCE(25);
      END_STATE();
    case 26:
      if (!eof && (lookahead == 0 ||
          lookahead == '\n')) ADVANCE(168);
      if (lookahead == '\r') ADVANCE(1);
      END_STATE();
    case 27:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 28:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(142);
      END_STATE();
    case 29:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(29)
      if (lookahead == '\r') SKIP(29)
      if (lookahead == '!') ADVANCE(8);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(97);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(93);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(58);
      if (lookahead == '<') ADVANCE(107);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == '^') ADVANCE(103);
      if (lookahead == '{') ADVANCE(90);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '~') ADVANCE(106);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(166);
      END_STATE();
    case 30:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(30)
      if (lookahead == '\r') SKIP(30)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(96);
      if (lookahead == '&') ADVANCE(100);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '*') ADVANCE(66);
      if (lookahead == '+') ADVANCE(92);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(58);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '^') ADVANCE(102);
      if (lookahead == '{') ADVANCE(90);
      if (lookahead == '|') ADVANCE(88);
      if (lookahead == '}') ADVANCE(91);
      if (lookahead == '~') ADVANCE(106);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(166);
      END_STATE();
    case 31:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(31)
      if (lookahead == '\r') SKIP(31)
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(10);
      if (lookahead == '&') ADVANCE(11);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(93);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(4);
      if (lookahead == '/') ADVANCE(6);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ':') ADVANCE(71);
      if (lookahead == ';') ADVANCE(58);
      if (lookahead == '<') ADVANCE(7);
      if (lookahead == '=') ADVANCE(79);
      if (lookahead == '>') ADVANCE(20);
      if (lookahead == '@') ADVANCE(12);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == '^') ADVANCE(13);
      if (lookahead == '{') ADVANCE(90);
      if (lookahead == '|') ADVANCE(14);
      if (lookahead == '~') ADVANCE(106);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(166);
      END_STATE();
    case 32:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(32)
      if (lookahead == '\r') SKIP(32)
      if (lookahead == '!') ADVANCE(8);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(97);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(93);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(59);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(58);
      if (lookahead == '<') ADVANCE(107);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '^') ADVANCE(103);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '}') ADVANCE(91);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(166);
      END_STATE();
    case 33:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(33)
      if (lookahead == '\r') SKIP(33)
      if (lookahead == '!') ADVANCE(8);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(97);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(93);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(59);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == ':') ADVANCE(71);
      if (lookahead == ';') ADVANCE(58);
      if (lookahead == '<') ADVANCE(107);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '^') ADVANCE(103);
      if (lookahead == '|') ADVANCE(89);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(166);
      END_STATE();
    case 34:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(34)
      if (lookahead == '\r') SKIP(34)
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '-') ADVANCE(19);
      if (lookahead == ':') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == 'e') ADVANCE(163);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(166);
      END_STATE();
    case 35:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(35)
      if (lookahead == '\r') SKIP(35)
      if (lookahead == '!') ADVANCE(8);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(97);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(93);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(86);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ':') ADVANCE(71);
      if (lookahead == ';') ADVANCE(58);
      if (lookahead == '<') ADVANCE(107);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == '^') ADVANCE(103);
      if (lookahead == '{') ADVANCE(90);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '~') ADVANCE(106);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(166);
      END_STATE();
    case 36:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(36)
      if (lookahead == '\r') SKIP(36)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(96);
      if (lookahead == '&') ADVANCE(100);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '*') ADVANCE(66);
      if (lookahead == '+') ADVANCE(92);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ':') ADVANCE(71);
      if (lookahead == ';') ADVANCE(58);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '^') ADVANCE(102);
      if (lookahead == '{') ADVANCE(90);
      if (lookahead == '|') ADVANCE(88);
      if (lookahead == '}') ADVANCE(91);
      if (lookahead == '~') ADVANCE(106);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(166);
      END_STATE();
    case 37:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(37)
      if (lookahead == '\r') SKIP(37)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(96);
      if (lookahead == '&') ADVANCE(100);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '*') ADVANCE(66);
      if (lookahead == '+') ADVANCE(92);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(59);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == ':') ADVANCE(71);
      if (lookahead == ';') ADVANCE(58);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '^') ADVANCE(102);
      if (lookahead == '|') ADVANCE(88);
      if (lookahead == '}') ADVANCE(91);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(166);
      END_STATE();
    case 38:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(38)
      if (lookahead == '\r') SKIP(38)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(96);
      if (lookahead == '&') ADVANCE(100);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '*') ADVANCE(66);
      if (lookahead == '+') ADVANCE(92);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(59);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(58);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '^') ADVANCE(102);
      if (lookahead == '|') ADVANCE(88);
      if (lookahead == '}') ADVANCE(91);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(166);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(143);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(132);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(132);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(144);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 52:
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(25);
      END_STATE();
    case 53:
      if (eof) ADVANCE(57);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(53)
      if (lookahead == '\r') SKIP(53)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '%') ADVANCE(97);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(93);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(87);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(58);
      if (lookahead == '<') ADVANCE(107);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '@') ADVANCE(84);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '^') ADVANCE(103);
      if (lookahead == 'e') ADVANCE(163);
      if (lookahead == '{') ADVANCE(90);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '}') ADVANCE(91);
      if (lookahead == '~') ADVANCE(106);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(166);
      END_STATE();
    case 54:
      if (eof) ADVANCE(57);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(54)
      if (lookahead == '\r') SKIP(54)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == ')') ADVANCE(62);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(92);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(4);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == ':') ADVANCE(71);
      if (lookahead == ';') ADVANCE(58);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(114);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == ']') ADVANCE(82);
      if (lookahead == '{') ADVANCE(90);
      if (lookahead == '|') ADVANCE(88);
      if (lookahead == '}') ADVANCE(91);
      if (lookahead == '~') ADVANCE(106);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(166);
      END_STATE();
    case 55:
      if (eof) ADVANCE(57);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(55)
      if (lookahead == '\r') SKIP(55)
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(92);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(4);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == 'e') ADVANCE(164);
      if (lookahead == '{') ADVANCE(90);
      if (lookahead == '~') ADVANCE(106);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(166);
      END_STATE();
    case 56:
      if (eof) ADVANCE(57);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(56)
      if (lookahead == '\r') SKIP(56)
      if (lookahead == '#') ADVANCE(167);
      if (lookahead == '(') ADVANCE(61);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(92);
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(4);
      if (lookahead == '0') ADVANCE(140);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == '{') ADVANCE(90);
      if (lookahead == '~') ADVANCE(106);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(166);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(78);
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(77);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(15);
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(70);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_except);
      if (lookahead == '*') ADVANCE(75);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_except);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_except_STAR);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(111);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(119);
      if (lookahead == '>') ADVANCE(76);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(130);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(98);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(105);
      if (lookahead == '=') ADVANCE(110);
      if (lookahead == '>') ADVANCE(117);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(104);
      if (lookahead == '=') ADVANCE(110);
      if (lookahead == '>') ADVANCE(117);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(110);
      if (lookahead == '>') ADVANCE(117);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(113);
      if (lookahead == '>') ADVANCE(69);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(113);
      if (lookahead == '>') ADVANCE(68);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_AT_EQ);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_EQ);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_ellipsis);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym__not_escape_sequence);
      if (!eof && (lookahead == 0)) ADVANCE(168);
      if (lookahead == '\n') ADVANCE(132);
      if (lookahead == '\r') ADVANCE(2);
      if (lookahead == 'N') ADVANCE(24);
      if (lookahead == 'U') ADVANCE(51);
      if (lookahead == 'u') ADVANCE(47);
      if (lookahead == 'x') ADVANCE(45);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          ('t' <= lookahead && lookahead <= 'v')) ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (!eof && (lookahead == 0)) ADVANCE(136);
      if (lookahead == '\r') ADVANCE(136);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(136);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == '\r') ADVANCE(135);
      if (lookahead == '#') ADVANCE(136);
      if (lookahead == '\\') ADVANCE(134);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(135);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(136);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(136);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_type_conversion);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '_') ADVANCE(141);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(139);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(21);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(22);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(23);
      if (lookahead == '_') ADVANCE(141);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(139);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(139);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(28);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(138);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(142);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(44);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(144);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_float);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(148);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(149);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(147);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '*') ADVANCE(75);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(154);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(155);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(156);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(157);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(158);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(159);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(160);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(161);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(162);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(73);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(150);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(74);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(151);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(152);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(153);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(167);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_line_continuation);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      if (lookahead == '\r') SKIP(0)
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '_') ADVANCE(4);
      if (lookahead == 'a') ADVANCE(5);
      if (lookahead == 'b') ADVANCE(6);
      if (lookahead == 'c') ADVANCE(7);
      if (lookahead == 'd') ADVANCE(8);
      if (lookahead == 'e') ADVANCE(9);
      if (lookahead == 'f') ADVANCE(10);
      if (lookahead == 'g') ADVANCE(11);
      if (lookahead == 'i') ADVANCE(12);
      if (lookahead == 'l') ADVANCE(13);
      if (lookahead == 'm') ADVANCE(14);
      if (lookahead == 'n') ADVANCE(15);
      if (lookahead == 'o') ADVANCE(16);
      if (lookahead == 'p') ADVANCE(17);
      if (lookahead == 'r') ADVANCE(18);
      if (lookahead == 't') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      END_STATE();
    case 1:
      if (lookahead == 'a') ADVANCE(22);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 4:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '_') ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == 'n') ADVANCE(26);
      if (lookahead == 's') ADVANCE(27);
      if (lookahead == 'w') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(30);
      if (lookahead == 'l') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 9:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 10:
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(38);
      END_STATE();
    case 11:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 12:
      if (lookahead == 'f') ADVANCE(40);
      if (lookahead == 'm') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(42);
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(44);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 15:
      if (lookahead == 'o') ADVANCE(46);
      END_STATE();
    case 16:
      if (lookahead == 'r') ADVANCE(47);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 19:
      if (lookahead == 'r') ADVANCE(52);
      if (lookahead == 'y') ADVANCE(53);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(54);
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(56);
      END_STATE();
    case 22:
      if (lookahead == 'l') ADVANCE(57);
      END_STATE();
    case 23:
      if (lookahead == 'n') ADVANCE(58);
      END_STATE();
    case 24:
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 25:
      if (lookahead == 'f') ADVANCE(60);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(61);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(62);
      if (lookahead == 'y') ADVANCE(63);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 30:
      if (lookahead == 's') ADVANCE(66);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(67);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(68);
      END_STATE();
    case 33:
      if (lookahead == 'f') ADVANCE(69);
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(71);
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(73);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(76);
      END_STATE();
    case 39:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 41:
      if (lookahead == 'p') ADVANCE(78);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 44:
      if (lookahead == 'm') ADVANCE(79);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 46:
      if (lookahead == 'n') ADVANCE(81);
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 48:
      if (lookahead == 's') ADVANCE(83);
      END_STATE();
    case 49:
      if (lookahead == 'i') ADVANCE(84);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(86);
      END_STATE();
    case 52:
      if (lookahead == 'y') ADVANCE(87);
      END_STATE();
    case 53:
      if (lookahead == 'p') ADVANCE(88);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(89);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(90);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(91);
      END_STATE();
    case 57:
      if (lookahead == 's') ADVANCE(92);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(93);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 60:
      if (lookahead == 'u') ADVANCE(95);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 63:
      if (lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 64:
      if (lookahead == 'i') ADVANCE(98);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(99);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 67:
      if (lookahead == 's') ADVANCE(101);
      END_STATE();
    case 68:
      if (lookahead == 't') ADVANCE(102);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_del);
      END_STATE();
    case 71:
      if (lookahead == 'f') ADVANCE(103);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 73:
      if (lookahead == 'c') ADVANCE(105);
      END_STATE();
    case 74:
      if (lookahead == 'a') ADVANCE(106);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 76:
      if (lookahead == 'm') ADVANCE(107);
      END_STATE();
    case 77:
      if (lookahead == 'b') ADVANCE(108);
      END_STATE();
    case 78:
      if (lookahead == 'o') ADVANCE(109);
      END_STATE();
    case 79:
      if (lookahead == 'b') ADVANCE(110);
      END_STATE();
    case 80:
      if (lookahead == 'c') ADVANCE(111);
      END_STATE();
    case 81:
      if (lookahead == 'l') ADVANCE(112);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 83:
      if (lookahead == 's') ADVANCE(113);
      END_STATE();
    case 84:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 85:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 86:
      if (lookahead == 'u') ADVANCE(116);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(117);
      END_STATE();
    case 89:
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 90:
      if (lookahead == 'h') ADVANCE(119);
      END_STATE();
    case 91:
      if (lookahead == 'l') ADVANCE(120);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_none);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 95:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 96:
      if (lookahead == 'r') ADVANCE(123);
      END_STATE();
    case 97:
      if (lookahead == 'c') ADVANCE(124);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 99:
      if (lookahead == 'k') ADVANCE(126);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 101:
      if (lookahead == 's') ADVANCE(127);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(128);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_exec);
      END_STATE();
    case 106:
      if (lookahead == 'l') ADVANCE(129);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 108:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 109:
      if (lookahead == 'r') ADVANCE(131);
      END_STATE();
    case 110:
      if (lookahead == 'd') ADVANCE(132);
      END_STATE();
    case 111:
      if (lookahead == 'h') ADVANCE(133);
      END_STATE();
    case 112:
      if (lookahead == 'o') ADVANCE(134);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_pass);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(135);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(136);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(137);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(138);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 120:
      if (lookahead == 'd') ADVANCE(139);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 122:
      if (lookahead == 'u') ADVANCE(140);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(141);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 128:
      if (lookahead == 'n') ADVANCE(142);
      END_STATE();
    case 129:
      if (lookahead == 'l') ADVANCE(143);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(144);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(145);
      END_STATE();
    case 132:
      if (lookahead == 'a') ADVANCE(146);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 134:
      if (lookahead == 'c') ADVANCE(147);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_print);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_raise);
      END_STATE();
    case 137:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 140:
      if (lookahead == 'r') ADVANCE(149);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 142:
      if (lookahead == 'u') ADVANCE(150);
      END_STATE();
    case 143:
      if (lookahead == 'y') ADVANCE(151);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_lambda);
      END_STATE();
    case 147:
      if (lookahead == 'a') ADVANCE(152);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 149:
      if (lookahead == 'e') ADVANCE(153);
      END_STATE();
    case 150:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 152:
      if (lookahead == 'l') ADVANCE(155);
      END_STATE();
    case 153:
      if (lookahead == '_') ADVANCE(156);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_nonlocal);
      END_STATE();
    case 156:
      if (lookahead == '_') ADVANCE(157);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym___future__);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 54, .external_lex_state = 2},
  [2] = {.lex_state = 54, .external_lex_state = 3},
  [3] = {.lex_state = 54, .external_lex_state = 3},
  [4] = {.lex_state = 54, .external_lex_state = 3},
  [5] = {.lex_state = 54, .external_lex_state = 3},
  [6] = {.lex_state = 54, .external_lex_state = 3},
  [7] = {.lex_state = 54, .external_lex_state = 3},
  [8] = {.lex_state = 54, .external_lex_state = 3},
  [9] = {.lex_state = 54, .external_lex_state = 3},
  [10] = {.lex_state = 54, .external_lex_state = 3},
  [11] = {.lex_state = 54, .external_lex_state = 3},
  [12] = {.lex_state = 54, .external_lex_state = 3},
  [13] = {.lex_state = 54, .external_lex_state = 3},
  [14] = {.lex_state = 54, .external_lex_state = 3},
  [15] = {.lex_state = 54, .external_lex_state = 3},
  [16] = {.lex_state = 54, .external_lex_state = 3},
  [17] = {.lex_state = 54, .external_lex_state = 3},
  [18] = {.lex_state = 54, .external_lex_state = 3},
  [19] = {.lex_state = 54, .external_lex_state = 3},
  [20] = {.lex_state = 54, .external_lex_state = 3},
  [21] = {.lex_state = 54, .external_lex_state = 3},
  [22] = {.lex_state = 54, .external_lex_state = 3},
  [23] = {.lex_state = 54, .external_lex_state = 3},
  [24] = {.lex_state = 54, .external_lex_state = 3},
  [25] = {.lex_state = 54, .external_lex_state = 3},
  [26] = {.lex_state = 54, .external_lex_state = 3},
  [27] = {.lex_state = 54, .external_lex_state = 3},
  [28] = {.lex_state = 54, .external_lex_state = 3},
  [29] = {.lex_state = 54, .external_lex_state = 3},
  [30] = {.lex_state = 54, .external_lex_state = 3},
  [31] = {.lex_state = 54, .external_lex_state = 3},
  [32] = {.lex_state = 54, .external_lex_state = 3},
  [33] = {.lex_state = 54, .external_lex_state = 3},
  [34] = {.lex_state = 54, .external_lex_state = 3},
  [35] = {.lex_state = 54, .external_lex_state = 3},
  [36] = {.lex_state = 54, .external_lex_state = 3},
  [37] = {.lex_state = 54, .external_lex_state = 3},
  [38] = {.lex_state = 54, .external_lex_state = 3},
  [39] = {.lex_state = 54, .external_lex_state = 3},
  [40] = {.lex_state = 54, .external_lex_state = 3},
  [41] = {.lex_state = 54, .external_lex_state = 3},
  [42] = {.lex_state = 54, .external_lex_state = 3},
  [43] = {.lex_state = 54, .external_lex_state = 3},
  [44] = {.lex_state = 54, .external_lex_state = 3},
  [45] = {.lex_state = 54, .external_lex_state = 3},
  [46] = {.lex_state = 54, .external_lex_state = 3},
  [47] = {.lex_state = 54, .external_lex_state = 3},
  [48] = {.lex_state = 54, .external_lex_state = 3},
  [49] = {.lex_state = 54, .external_lex_state = 3},
  [50] = {.lex_state = 54, .external_lex_state = 3},
  [51] = {.lex_state = 54, .external_lex_state = 3},
  [52] = {.lex_state = 54, .external_lex_state = 3},
  [53] = {.lex_state = 54, .external_lex_state = 3},
  [54] = {.lex_state = 54, .external_lex_state = 3},
  [55] = {.lex_state = 54, .external_lex_state = 3},
  [56] = {.lex_state = 54, .external_lex_state = 3},
  [57] = {.lex_state = 54, .external_lex_state = 3},
  [58] = {.lex_state = 54, .external_lex_state = 3},
  [59] = {.lex_state = 54, .external_lex_state = 3},
  [60] = {.lex_state = 54, .external_lex_state = 3},
  [61] = {.lex_state = 54, .external_lex_state = 3},
  [62] = {.lex_state = 54, .external_lex_state = 3},
  [63] = {.lex_state = 54, .external_lex_state = 3},
  [64] = {.lex_state = 54, .external_lex_state = 2},
  [65] = {.lex_state = 54, .external_lex_state = 3},
  [66] = {.lex_state = 54, .external_lex_state = 3},
  [67] = {.lex_state = 54, .external_lex_state = 3},
  [68] = {.lex_state = 54, .external_lex_state = 3},
  [69] = {.lex_state = 54, .external_lex_state = 3},
  [70] = {.lex_state = 54, .external_lex_state = 2},
  [71] = {.lex_state = 54, .external_lex_state = 3},
  [72] = {.lex_state = 54, .external_lex_state = 3},
  [73] = {.lex_state = 29, .external_lex_state = 4},
  [74] = {.lex_state = 29, .external_lex_state = 4},
  [75] = {.lex_state = 30, .external_lex_state = 5},
  [76] = {.lex_state = 30, .external_lex_state = 5},
  [77] = {.lex_state = 30, .external_lex_state = 5},
  [78] = {.lex_state = 30, .external_lex_state = 5},
  [79] = {.lex_state = 30, .external_lex_state = 5},
  [80] = {.lex_state = 30, .external_lex_state = 5},
  [81] = {.lex_state = 30, .external_lex_state = 5},
  [82] = {.lex_state = 30, .external_lex_state = 5},
  [83] = {.lex_state = 29, .external_lex_state = 4},
  [84] = {.lex_state = 29, .external_lex_state = 4},
  [85] = {.lex_state = 29, .external_lex_state = 4},
  [86] = {.lex_state = 29, .external_lex_state = 4},
  [87] = {.lex_state = 54, .external_lex_state = 5},
  [88] = {.lex_state = 54, .external_lex_state = 5},
  [89] = {.lex_state = 54, .external_lex_state = 5},
  [90] = {.lex_state = 54, .external_lex_state = 5},
  [91] = {.lex_state = 54, .external_lex_state = 5},
  [92] = {.lex_state = 54, .external_lex_state = 5},
  [93] = {.lex_state = 54, .external_lex_state = 5},
  [94] = {.lex_state = 54, .external_lex_state = 5},
  [95] = {.lex_state = 54, .external_lex_state = 5},
  [96] = {.lex_state = 54, .external_lex_state = 5},
  [97] = {.lex_state = 54, .external_lex_state = 5},
  [98] = {.lex_state = 54, .external_lex_state = 5},
  [99] = {.lex_state = 54, .external_lex_state = 5},
  [100] = {.lex_state = 54, .external_lex_state = 5},
  [101] = {.lex_state = 54, .external_lex_state = 5},
  [102] = {.lex_state = 54, .external_lex_state = 5},
  [103] = {.lex_state = 54, .external_lex_state = 5},
  [104] = {.lex_state = 54, .external_lex_state = 5},
  [105] = {.lex_state = 54, .external_lex_state = 5},
  [106] = {.lex_state = 54, .external_lex_state = 5},
  [107] = {.lex_state = 54, .external_lex_state = 5},
  [108] = {.lex_state = 54, .external_lex_state = 5},
  [109] = {.lex_state = 54, .external_lex_state = 5},
  [110] = {.lex_state = 54, .external_lex_state = 5},
  [111] = {.lex_state = 54, .external_lex_state = 5},
  [112] = {.lex_state = 54, .external_lex_state = 5},
  [113] = {.lex_state = 54, .external_lex_state = 5},
  [114] = {.lex_state = 54, .external_lex_state = 5},
  [115] = {.lex_state = 54, .external_lex_state = 5},
  [116] = {.lex_state = 54, .external_lex_state = 5},
  [117] = {.lex_state = 54, .external_lex_state = 5},
  [118] = {.lex_state = 54, .external_lex_state = 5},
  [119] = {.lex_state = 54, .external_lex_state = 5},
  [120] = {.lex_state = 54, .external_lex_state = 5},
  [121] = {.lex_state = 54, .external_lex_state = 5},
  [122] = {.lex_state = 54, .external_lex_state = 5},
  [123] = {.lex_state = 54, .external_lex_state = 5},
  [124] = {.lex_state = 54, .external_lex_state = 5},
  [125] = {.lex_state = 54, .external_lex_state = 5},
  [126] = {.lex_state = 54, .external_lex_state = 5},
  [127] = {.lex_state = 54, .external_lex_state = 5},
  [128] = {.lex_state = 54, .external_lex_state = 5},
  [129] = {.lex_state = 54, .external_lex_state = 5},
  [130] = {.lex_state = 54, .external_lex_state = 5},
  [131] = {.lex_state = 54, .external_lex_state = 5},
  [132] = {.lex_state = 54, .external_lex_state = 5},
  [133] = {.lex_state = 54, .external_lex_state = 5},
  [134] = {.lex_state = 54, .external_lex_state = 5},
  [135] = {.lex_state = 54, .external_lex_state = 5},
  [136] = {.lex_state = 54, .external_lex_state = 5},
  [137] = {.lex_state = 54, .external_lex_state = 4},
  [138] = {.lex_state = 54, .external_lex_state = 4},
  [139] = {.lex_state = 54, .external_lex_state = 4},
  [140] = {.lex_state = 54, .external_lex_state = 4},
  [141] = {.lex_state = 54, .external_lex_state = 4},
  [142] = {.lex_state = 54, .external_lex_state = 4},
  [143] = {.lex_state = 54, .external_lex_state = 4},
  [144] = {.lex_state = 54, .external_lex_state = 4},
  [145] = {.lex_state = 54, .external_lex_state = 4},
  [146] = {.lex_state = 54, .external_lex_state = 4},
  [147] = {.lex_state = 54, .external_lex_state = 4},
  [148] = {.lex_state = 54, .external_lex_state = 4},
  [149] = {.lex_state = 54, .external_lex_state = 4},
  [150] = {.lex_state = 54, .external_lex_state = 4},
  [151] = {.lex_state = 54, .external_lex_state = 4},
  [152] = {.lex_state = 54, .external_lex_state = 4},
  [153] = {.lex_state = 54, .external_lex_state = 2},
  [154] = {.lex_state = 29, .external_lex_state = 4},
  [155] = {.lex_state = 29, .external_lex_state = 4},
  [156] = {.lex_state = 35, .external_lex_state = 4},
  [157] = {.lex_state = 30, .external_lex_state = 4},
  [158] = {.lex_state = 36, .external_lex_state = 4},
  [159] = {.lex_state = 30, .external_lex_state = 6},
  [160] = {.lex_state = 30, .external_lex_state = 6},
  [161] = {.lex_state = 36, .external_lex_state = 4},
  [162] = {.lex_state = 36, .external_lex_state = 6},
  [163] = {.lex_state = 30, .external_lex_state = 6},
  [164] = {.lex_state = 36, .external_lex_state = 7},
  [165] = {.lex_state = 30, .external_lex_state = 6},
  [166] = {.lex_state = 30, .external_lex_state = 7},
  [167] = {.lex_state = 30, .external_lex_state = 2},
  [168] = {.lex_state = 36, .external_lex_state = 6},
  [169] = {.lex_state = 30, .external_lex_state = 7},
  [170] = {.lex_state = 30, .external_lex_state = 8},
  [171] = {.lex_state = 30, .external_lex_state = 7},
  [172] = {.lex_state = 30, .external_lex_state = 8},
  [173] = {.lex_state = 30, .external_lex_state = 8},
  [174] = {.lex_state = 30, .external_lex_state = 7},
  [175] = {.lex_state = 36, .external_lex_state = 7},
  [176] = {.lex_state = 35, .external_lex_state = 4},
  [177] = {.lex_state = 36, .external_lex_state = 2},
  [178] = {.lex_state = 36, .external_lex_state = 6},
  [179] = {.lex_state = 30, .external_lex_state = 8},
  [180] = {.lex_state = 36, .external_lex_state = 8},
  [181] = {.lex_state = 36, .external_lex_state = 2},
  [182] = {.lex_state = 30, .external_lex_state = 7},
  [183] = {.lex_state = 30, .external_lex_state = 7},
  [184] = {.lex_state = 36, .external_lex_state = 8},
  [185] = {.lex_state = 30, .external_lex_state = 7},
  [186] = {.lex_state = 30, .external_lex_state = 8},
  [187] = {.lex_state = 35, .external_lex_state = 2},
  [188] = {.lex_state = 35, .external_lex_state = 2},
  [189] = {.lex_state = 54, .external_lex_state = 8},
  [190] = {.lex_state = 54, .external_lex_state = 7},
  [191] = {.lex_state = 54, .external_lex_state = 7},
  [192] = {.lex_state = 54, .external_lex_state = 2},
  [193] = {.lex_state = 54, .external_lex_state = 7},
  [194] = {.lex_state = 54, .external_lex_state = 8},
  [195] = {.lex_state = 30, .external_lex_state = 6},
  [196] = {.lex_state = 54, .external_lex_state = 8},
  [197] = {.lex_state = 30, .external_lex_state = 6},
  [198] = {.lex_state = 30, .external_lex_state = 6},
  [199] = {.lex_state = 54, .external_lex_state = 8},
  [200] = {.lex_state = 30, .external_lex_state = 6},
  [201] = {.lex_state = 54, .external_lex_state = 7},
  [202] = {.lex_state = 54, .external_lex_state = 8},
  [203] = {.lex_state = 54, .external_lex_state = 8},
  [204] = {.lex_state = 30, .external_lex_state = 6},
  [205] = {.lex_state = 30, .external_lex_state = 6},
  [206] = {.lex_state = 54, .external_lex_state = 8},
  [207] = {.lex_state = 54, .external_lex_state = 7},
  [208] = {.lex_state = 54, .external_lex_state = 7},
  [209] = {.lex_state = 54, .external_lex_state = 8},
  [210] = {.lex_state = 54, .external_lex_state = 7},
  [211] = {.lex_state = 54, .external_lex_state = 8},
  [212] = {.lex_state = 30, .external_lex_state = 6},
  [213] = {.lex_state = 54, .external_lex_state = 7},
  [214] = {.lex_state = 54, .external_lex_state = 8},
  [215] = {.lex_state = 54, .external_lex_state = 7},
  [216] = {.lex_state = 54, .external_lex_state = 2},
  [217] = {.lex_state = 54, .external_lex_state = 7},
  [218] = {.lex_state = 30, .external_lex_state = 6},
  [219] = {.lex_state = 54, .external_lex_state = 8},
  [220] = {.lex_state = 54, .external_lex_state = 7},
  [221] = {.lex_state = 54, .external_lex_state = 2},
  [222] = {.lex_state = 31, .external_lex_state = 4},
  [223] = {.lex_state = 31, .external_lex_state = 4},
  [224] = {.lex_state = 30, .external_lex_state = 8},
  [225] = {.lex_state = 30, .external_lex_state = 8},
  [226] = {.lex_state = 30, .external_lex_state = 8},
  [227] = {.lex_state = 54, .external_lex_state = 2},
  [228] = {.lex_state = 54, .external_lex_state = 2},
  [229] = {.lex_state = 30, .external_lex_state = 8},
  [230] = {.lex_state = 30, .external_lex_state = 8},
  [231] = {.lex_state = 30, .external_lex_state = 8},
  [232] = {.lex_state = 30, .external_lex_state = 8},
  [233] = {.lex_state = 30, .external_lex_state = 8},
  [234] = {.lex_state = 30, .external_lex_state = 2},
  [235] = {.lex_state = 30, .external_lex_state = 2},
  [236] = {.lex_state = 30, .external_lex_state = 7},
  [237] = {.lex_state = 30, .external_lex_state = 2},
  [238] = {.lex_state = 30, .external_lex_state = 7},
  [239] = {.lex_state = 30, .external_lex_state = 2},
  [240] = {.lex_state = 30, .external_lex_state = 7},
  [241] = {.lex_state = 30, .external_lex_state = 2},
  [242] = {.lex_state = 30, .external_lex_state = 2},
  [243] = {.lex_state = 30, .external_lex_state = 2},
  [244] = {.lex_state = 30, .external_lex_state = 2},
  [245] = {.lex_state = 30, .external_lex_state = 2},
  [246] = {.lex_state = 30, .external_lex_state = 2},
  [247] = {.lex_state = 30, .external_lex_state = 7},
  [248] = {.lex_state = 30, .external_lex_state = 7},
  [249] = {.lex_state = 30, .external_lex_state = 7},
  [250] = {.lex_state = 30, .external_lex_state = 7},
  [251] = {.lex_state = 31, .external_lex_state = 2},
  [252] = {.lex_state = 30, .external_lex_state = 2},
  [253] = {.lex_state = 54, .external_lex_state = 6},
  [254] = {.lex_state = 31, .external_lex_state = 2},
  [255] = {.lex_state = 30, .external_lex_state = 2},
  [256] = {.lex_state = 54, .external_lex_state = 7},
  [257] = {.lex_state = 30, .external_lex_state = 7},
  [258] = {.lex_state = 30, .external_lex_state = 2},
  [259] = {.lex_state = 30, .external_lex_state = 2},
  [260] = {.lex_state = 30, .external_lex_state = 2},
  [261] = {.lex_state = 30, .external_lex_state = 2},
  [262] = {.lex_state = 30, .external_lex_state = 2},
  [263] = {.lex_state = 30, .external_lex_state = 2},
  [264] = {.lex_state = 30, .external_lex_state = 2},
  [265] = {.lex_state = 30, .external_lex_state = 2},
  [266] = {.lex_state = 30, .external_lex_state = 2},
  [267] = {.lex_state = 30, .external_lex_state = 2},
  [268] = {.lex_state = 30, .external_lex_state = 2},
  [269] = {.lex_state = 30, .external_lex_state = 2},
  [270] = {.lex_state = 30, .external_lex_state = 2},
  [271] = {.lex_state = 30, .external_lex_state = 7},
  [272] = {.lex_state = 30, .external_lex_state = 7},
  [273] = {.lex_state = 30, .external_lex_state = 7},
  [274] = {.lex_state = 30, .external_lex_state = 7},
  [275] = {.lex_state = 30, .external_lex_state = 7},
  [276] = {.lex_state = 30, .external_lex_state = 7},
  [277] = {.lex_state = 54, .external_lex_state = 8},
  [278] = {.lex_state = 54, .external_lex_state = 7},
  [279] = {.lex_state = 54, .external_lex_state = 7},
  [280] = {.lex_state = 54, .external_lex_state = 7},
  [281] = {.lex_state = 30, .external_lex_state = 7},
  [282] = {.lex_state = 30, .external_lex_state = 7},
  [283] = {.lex_state = 30, .external_lex_state = 7},
  [284] = {.lex_state = 30, .external_lex_state = 7},
  [285] = {.lex_state = 30, .external_lex_state = 7},
  [286] = {.lex_state = 54, .external_lex_state = 8},
  [287] = {.lex_state = 30, .external_lex_state = 7},
  [288] = {.lex_state = 54, .external_lex_state = 7},
  [289] = {.lex_state = 30, .external_lex_state = 7},
  [290] = {.lex_state = 54, .external_lex_state = 8},
  [291] = {.lex_state = 30, .external_lex_state = 7},
  [292] = {.lex_state = 54, .external_lex_state = 7},
  [293] = {.lex_state = 54, .external_lex_state = 7},
  [294] = {.lex_state = 54, .external_lex_state = 8},
  [295] = {.lex_state = 30, .external_lex_state = 7},
  [296] = {.lex_state = 54, .external_lex_state = 7},
  [297] = {.lex_state = 30, .external_lex_state = 7},
  [298] = {.lex_state = 54, .external_lex_state = 7},
  [299] = {.lex_state = 54, .external_lex_state = 8},
  [300] = {.lex_state = 54, .external_lex_state = 7},
  [301] = {.lex_state = 30, .external_lex_state = 7},
  [302] = {.lex_state = 30, .external_lex_state = 7},
  [303] = {.lex_state = 30, .external_lex_state = 7},
  [304] = {.lex_state = 30, .external_lex_state = 7},
  [305] = {.lex_state = 30, .external_lex_state = 7},
  [306] = {.lex_state = 30, .external_lex_state = 7},
  [307] = {.lex_state = 54, .external_lex_state = 7},
  [308] = {.lex_state = 30, .external_lex_state = 7},
  [309] = {.lex_state = 30, .external_lex_state = 7},
  [310] = {.lex_state = 30, .external_lex_state = 7},
  [311] = {.lex_state = 30, .external_lex_state = 7},
  [312] = {.lex_state = 30, .external_lex_state = 7},
  [313] = {.lex_state = 54, .external_lex_state = 7},
  [314] = {.lex_state = 30, .external_lex_state = 7},
  [315] = {.lex_state = 30, .external_lex_state = 7},
  [316] = {.lex_state = 54, .external_lex_state = 7},
  [317] = {.lex_state = 54, .external_lex_state = 8},
  [318] = {.lex_state = 54, .external_lex_state = 8},
  [319] = {.lex_state = 30, .external_lex_state = 7},
  [320] = {.lex_state = 54, .external_lex_state = 8},
  [321] = {.lex_state = 30, .external_lex_state = 7},
  [322] = {.lex_state = 30, .external_lex_state = 7},
  [323] = {.lex_state = 54, .external_lex_state = 7},
  [324] = {.lex_state = 54, .external_lex_state = 7},
  [325] = {.lex_state = 30, .external_lex_state = 7},
  [326] = {.lex_state = 54, .external_lex_state = 8},
  [327] = {.lex_state = 54, .external_lex_state = 6},
  [328] = {.lex_state = 36, .external_lex_state = 6},
  [329] = {.lex_state = 30, .external_lex_state = 2},
  [330] = {.lex_state = 54, .external_lex_state = 7},
  [331] = {.lex_state = 54, .external_lex_state = 7},
  [332] = {.lex_state = 54, .external_lex_state = 7},
  [333] = {.lex_state = 54, .external_lex_state = 7},
  [334] = {.lex_state = 54, .external_lex_state = 6},
  [335] = {.lex_state = 54, .external_lex_state = 6},
  [336] = {.lex_state = 54, .external_lex_state = 6},
  [337] = {.lex_state = 54, .external_lex_state = 6},
  [338] = {.lex_state = 54, .external_lex_state = 6},
  [339] = {.lex_state = 54, .external_lex_state = 7},
  [340] = {.lex_state = 54, .external_lex_state = 8},
  [341] = {.lex_state = 54, .external_lex_state = 8},
  [342] = {.lex_state = 54, .external_lex_state = 7},
  [343] = {.lex_state = 54, .external_lex_state = 6},
  [344] = {.lex_state = 54, .external_lex_state = 8},
  [345] = {.lex_state = 54, .external_lex_state = 8},
  [346] = {.lex_state = 54, .external_lex_state = 6},
  [347] = {.lex_state = 54, .external_lex_state = 8},
  [348] = {.lex_state = 30, .external_lex_state = 6},
  [349] = {.lex_state = 30, .external_lex_state = 6},
  [350] = {.lex_state = 54, .external_lex_state = 4},
  [351] = {.lex_state = 54, .external_lex_state = 7},
  [352] = {.lex_state = 30, .external_lex_state = 6},
  [353] = {.lex_state = 54, .external_lex_state = 4},
  [354] = {.lex_state = 30, .external_lex_state = 6},
  [355] = {.lex_state = 30, .external_lex_state = 6},
  [356] = {.lex_state = 54, .external_lex_state = 2},
  [357] = {.lex_state = 30, .external_lex_state = 6},
  [358] = {.lex_state = 30, .external_lex_state = 6},
  [359] = {.lex_state = 30, .external_lex_state = 6},
  [360] = {.lex_state = 30, .external_lex_state = 6},
  [361] = {.lex_state = 30, .external_lex_state = 6},
  [362] = {.lex_state = 30, .external_lex_state = 6},
  [363] = {.lex_state = 30, .external_lex_state = 6},
  [364] = {.lex_state = 54, .external_lex_state = 2},
  [365] = {.lex_state = 54, .external_lex_state = 2},
  [366] = {.lex_state = 30, .external_lex_state = 6},
  [367] = {.lex_state = 30, .external_lex_state = 6},
  [368] = {.lex_state = 54, .external_lex_state = 8},
  [369] = {.lex_state = 30, .external_lex_state = 6},
  [370] = {.lex_state = 30, .external_lex_state = 6},
  [371] = {.lex_state = 36, .external_lex_state = 7},
  [372] = {.lex_state = 54, .external_lex_state = 8},
  [373] = {.lex_state = 54, .external_lex_state = 8},
  [374] = {.lex_state = 54, .external_lex_state = 8},
  [375] = {.lex_state = 54, .external_lex_state = 8},
  [376] = {.lex_state = 54, .external_lex_state = 8},
  [377] = {.lex_state = 54, .external_lex_state = 8},
  [378] = {.lex_state = 54, .external_lex_state = 8},
  [379] = {.lex_state = 54, .external_lex_state = 4},
  [380] = {.lex_state = 54, .external_lex_state = 8},
  [381] = {.lex_state = 54, .external_lex_state = 8},
  [382] = {.lex_state = 54, .external_lex_state = 4},
  [383] = {.lex_state = 54, .external_lex_state = 8},
  [384] = {.lex_state = 54, .external_lex_state = 8},
  [385] = {.lex_state = 54, .external_lex_state = 4},
  [386] = {.lex_state = 54, .external_lex_state = 8},
  [387] = {.lex_state = 30, .external_lex_state = 2},
  [388] = {.lex_state = 54, .external_lex_state = 8},
  [389] = {.lex_state = 54, .external_lex_state = 8},
  [390] = {.lex_state = 54, .external_lex_state = 8},
  [391] = {.lex_state = 54, .external_lex_state = 8},
  [392] = {.lex_state = 54, .external_lex_state = 8},
  [393] = {.lex_state = 54, .external_lex_state = 8},
  [394] = {.lex_state = 54, .external_lex_state = 8},
  [395] = {.lex_state = 54, .external_lex_state = 8},
  [396] = {.lex_state = 54, .external_lex_state = 8},
  [397] = {.lex_state = 54, .external_lex_state = 8},
  [398] = {.lex_state = 54, .external_lex_state = 8},
  [399] = {.lex_state = 54, .external_lex_state = 8},
  [400] = {.lex_state = 54, .external_lex_state = 8},
  [401] = {.lex_state = 36, .external_lex_state = 7},
  [402] = {.lex_state = 54, .external_lex_state = 8},
  [403] = {.lex_state = 54, .external_lex_state = 8},
  [404] = {.lex_state = 54, .external_lex_state = 8},
  [405] = {.lex_state = 54, .external_lex_state = 8},
  [406] = {.lex_state = 54, .external_lex_state = 8},
  [407] = {.lex_state = 54, .external_lex_state = 8},
  [408] = {.lex_state = 54, .external_lex_state = 8},
  [409] = {.lex_state = 30, .external_lex_state = 7},
  [410] = {.lex_state = 54, .external_lex_state = 2},
  [411] = {.lex_state = 54, .external_lex_state = 2},
  [412] = {.lex_state = 54, .external_lex_state = 7},
  [413] = {.lex_state = 30, .external_lex_state = 2},
  [414] = {.lex_state = 54, .external_lex_state = 2},
  [415] = {.lex_state = 54, .external_lex_state = 2},
  [416] = {.lex_state = 54, .external_lex_state = 2},
  [417] = {.lex_state = 54, .external_lex_state = 2},
  [418] = {.lex_state = 54, .external_lex_state = 2},
  [419] = {.lex_state = 54, .external_lex_state = 2},
  [420] = {.lex_state = 54, .external_lex_state = 2},
  [421] = {.lex_state = 54, .external_lex_state = 8},
  [422] = {.lex_state = 54, .external_lex_state = 2},
  [423] = {.lex_state = 54, .external_lex_state = 2},
  [424] = {.lex_state = 54, .external_lex_state = 2},
  [425] = {.lex_state = 54, .external_lex_state = 7},
  [426] = {.lex_state = 54, .external_lex_state = 2},
  [427] = {.lex_state = 54, .external_lex_state = 2},
  [428] = {.lex_state = 54, .external_lex_state = 8},
  [429] = {.lex_state = 54, .external_lex_state = 2},
  [430] = {.lex_state = 54, .external_lex_state = 2},
  [431] = {.lex_state = 54, .external_lex_state = 7},
  [432] = {.lex_state = 54, .external_lex_state = 2},
  [433] = {.lex_state = 54, .external_lex_state = 8},
  [434] = {.lex_state = 54, .external_lex_state = 2},
  [435] = {.lex_state = 54, .external_lex_state = 2},
  [436] = {.lex_state = 54, .external_lex_state = 2},
  [437] = {.lex_state = 54, .external_lex_state = 2},
  [438] = {.lex_state = 54, .external_lex_state = 8},
  [439] = {.lex_state = 54, .external_lex_state = 2},
  [440] = {.lex_state = 54, .external_lex_state = 8},
  [441] = {.lex_state = 54, .external_lex_state = 2},
  [442] = {.lex_state = 54, .external_lex_state = 2},
  [443] = {.lex_state = 54, .external_lex_state = 2},
  [444] = {.lex_state = 54, .external_lex_state = 2},
  [445] = {.lex_state = 30, .external_lex_state = 8},
  [446] = {.lex_state = 54, .external_lex_state = 2},
  [447] = {.lex_state = 36, .external_lex_state = 2},
  [448] = {.lex_state = 54, .external_lex_state = 4},
  [449] = {.lex_state = 54, .external_lex_state = 2},
  [450] = {.lex_state = 54, .external_lex_state = 4},
  [451] = {.lex_state = 54, .external_lex_state = 2},
  [452] = {.lex_state = 54, .external_lex_state = 4},
  [453] = {.lex_state = 54, .external_lex_state = 2},
  [454] = {.lex_state = 54, .external_lex_state = 4},
  [455] = {.lex_state = 54, .external_lex_state = 4},
  [456] = {.lex_state = 36, .external_lex_state = 2},
  [457] = {.lex_state = 54, .external_lex_state = 7},
  [458] = {.lex_state = 54, .external_lex_state = 2},
  [459] = {.lex_state = 54, .external_lex_state = 4},
  [460] = {.lex_state = 54, .external_lex_state = 2},
  [461] = {.lex_state = 54, .external_lex_state = 2},
  [462] = {.lex_state = 54, .external_lex_state = 2},
  [463] = {.lex_state = 32, .external_lex_state = 4},
  [464] = {.lex_state = 54, .external_lex_state = 2},
  [465] = {.lex_state = 54, .external_lex_state = 2},
  [466] = {.lex_state = 54, .external_lex_state = 2},
  [467] = {.lex_state = 54, .external_lex_state = 2},
  [468] = {.lex_state = 54, .external_lex_state = 2},
  [469] = {.lex_state = 54, .external_lex_state = 2},
  [470] = {.lex_state = 32, .external_lex_state = 4},
  [471] = {.lex_state = 54, .external_lex_state = 2},
  [472] = {.lex_state = 54, .external_lex_state = 2},
  [473] = {.lex_state = 54, .external_lex_state = 2},
  [474] = {.lex_state = 32, .external_lex_state = 9},
  [475] = {.lex_state = 54, .external_lex_state = 2},
  [476] = {.lex_state = 32, .external_lex_state = 9},
  [477] = {.lex_state = 54, .external_lex_state = 2},
  [478] = {.lex_state = 54, .external_lex_state = 2},
  [479] = {.lex_state = 54, .external_lex_state = 2},
  [480] = {.lex_state = 54, .external_lex_state = 2},
  [481] = {.lex_state = 54, .external_lex_state = 2},
  [482] = {.lex_state = 54, .external_lex_state = 2},
  [483] = {.lex_state = 54, .external_lex_state = 2},
  [484] = {.lex_state = 54, .external_lex_state = 2},
  [485] = {.lex_state = 54, .external_lex_state = 2},
  [486] = {.lex_state = 54, .external_lex_state = 2},
  [487] = {.lex_state = 54, .external_lex_state = 2},
  [488] = {.lex_state = 54, .external_lex_state = 2},
  [489] = {.lex_state = 54, .external_lex_state = 2},
  [490] = {.lex_state = 54, .external_lex_state = 2},
  [491] = {.lex_state = 54, .external_lex_state = 2},
  [492] = {.lex_state = 55, .external_lex_state = 3},
  [493] = {.lex_state = 56, .external_lex_state = 10},
  [494] = {.lex_state = 54, .external_lex_state = 2},
  [495] = {.lex_state = 54, .external_lex_state = 2},
  [496] = {.lex_state = 54, .external_lex_state = 2},
  [497] = {.lex_state = 55, .external_lex_state = 3},
  [498] = {.lex_state = 56, .external_lex_state = 10},
  [499] = {.lex_state = 54, .external_lex_state = 2},
  [500] = {.lex_state = 54, .external_lex_state = 2},
  [501] = {.lex_state = 54, .external_lex_state = 2},
  [502] = {.lex_state = 54, .external_lex_state = 2},
  [503] = {.lex_state = 54, .external_lex_state = 2},
  [504] = {.lex_state = 54, .external_lex_state = 2},
  [505] = {.lex_state = 54, .external_lex_state = 2},
  [506] = {.lex_state = 54, .external_lex_state = 2},
  [507] = {.lex_state = 54, .external_lex_state = 2},
  [508] = {.lex_state = 54, .external_lex_state = 2},
  [509] = {.lex_state = 54, .external_lex_state = 2},
  [510] = {.lex_state = 54, .external_lex_state = 2},
  [511] = {.lex_state = 54, .external_lex_state = 2},
  [512] = {.lex_state = 54, .external_lex_state = 2},
  [513] = {.lex_state = 54, .external_lex_state = 2},
  [514] = {.lex_state = 54, .external_lex_state = 2},
  [515] = {.lex_state = 54, .external_lex_state = 2},
  [516] = {.lex_state = 54, .external_lex_state = 2},
  [517] = {.lex_state = 54, .external_lex_state = 2},
  [518] = {.lex_state = 54, .external_lex_state = 2},
  [519] = {.lex_state = 54, .external_lex_state = 2},
  [520] = {.lex_state = 54, .external_lex_state = 2},
  [521] = {.lex_state = 54, .external_lex_state = 2},
  [522] = {.lex_state = 54, .external_lex_state = 2},
  [523] = {.lex_state = 54, .external_lex_state = 2},
  [524] = {.lex_state = 54, .external_lex_state = 2},
  [525] = {.lex_state = 54, .external_lex_state = 2},
  [526] = {.lex_state = 54, .external_lex_state = 2},
  [527] = {.lex_state = 56, .external_lex_state = 11},
  [528] = {.lex_state = 55, .external_lex_state = 2},
  [529] = {.lex_state = 54, .external_lex_state = 2},
  [530] = {.lex_state = 54, .external_lex_state = 2},
  [531] = {.lex_state = 54, .external_lex_state = 2},
  [532] = {.lex_state = 54, .external_lex_state = 2},
  [533] = {.lex_state = 54, .external_lex_state = 2},
  [534] = {.lex_state = 54, .external_lex_state = 2},
  [535] = {.lex_state = 54, .external_lex_state = 2},
  [536] = {.lex_state = 54, .external_lex_state = 2},
  [537] = {.lex_state = 54, .external_lex_state = 2},
  [538] = {.lex_state = 54, .external_lex_state = 2},
  [539] = {.lex_state = 54, .external_lex_state = 2},
  [540] = {.lex_state = 54, .external_lex_state = 2},
  [541] = {.lex_state = 54, .external_lex_state = 2},
  [542] = {.lex_state = 54, .external_lex_state = 2},
  [543] = {.lex_state = 54, .external_lex_state = 2},
  [544] = {.lex_state = 54, .external_lex_state = 2},
  [545] = {.lex_state = 54, .external_lex_state = 2},
  [546] = {.lex_state = 54, .external_lex_state = 2},
  [547] = {.lex_state = 54, .external_lex_state = 2},
  [548] = {.lex_state = 54, .external_lex_state = 2},
  [549] = {.lex_state = 54, .external_lex_state = 2},
  [550] = {.lex_state = 54, .external_lex_state = 2},
  [551] = {.lex_state = 54, .external_lex_state = 2},
  [552] = {.lex_state = 54, .external_lex_state = 2},
  [553] = {.lex_state = 54, .external_lex_state = 2},
  [554] = {.lex_state = 54, .external_lex_state = 2},
  [555] = {.lex_state = 54, .external_lex_state = 2},
  [556] = {.lex_state = 54, .external_lex_state = 2},
  [557] = {.lex_state = 54, .external_lex_state = 2},
  [558] = {.lex_state = 54, .external_lex_state = 2},
  [559] = {.lex_state = 54, .external_lex_state = 2},
  [560] = {.lex_state = 54, .external_lex_state = 2},
  [561] = {.lex_state = 54, .external_lex_state = 2},
  [562] = {.lex_state = 54, .external_lex_state = 2},
  [563] = {.lex_state = 54, .external_lex_state = 2},
  [564] = {.lex_state = 54, .external_lex_state = 2},
  [565] = {.lex_state = 54, .external_lex_state = 2},
  [566] = {.lex_state = 54, .external_lex_state = 2},
  [567] = {.lex_state = 54, .external_lex_state = 2},
  [568] = {.lex_state = 54, .external_lex_state = 2},
  [569] = {.lex_state = 54, .external_lex_state = 2},
  [570] = {.lex_state = 54, .external_lex_state = 2},
  [571] = {.lex_state = 54, .external_lex_state = 2},
  [572] = {.lex_state = 54, .external_lex_state = 2},
  [573] = {.lex_state = 54, .external_lex_state = 2},
  [574] = {.lex_state = 54, .external_lex_state = 2},
  [575] = {.lex_state = 54, .external_lex_state = 2},
  [576] = {.lex_state = 54, .external_lex_state = 2},
  [577] = {.lex_state = 54, .external_lex_state = 2},
  [578] = {.lex_state = 54, .external_lex_state = 2},
  [579] = {.lex_state = 54, .external_lex_state = 2},
  [580] = {.lex_state = 54, .external_lex_state = 2},
  [581] = {.lex_state = 54, .external_lex_state = 2},
  [582] = {.lex_state = 54, .external_lex_state = 2},
  [583] = {.lex_state = 54, .external_lex_state = 2},
  [584] = {.lex_state = 54, .external_lex_state = 2},
  [585] = {.lex_state = 54, .external_lex_state = 2},
  [586] = {.lex_state = 54, .external_lex_state = 2},
  [587] = {.lex_state = 54, .external_lex_state = 2},
  [588] = {.lex_state = 54, .external_lex_state = 2},
  [589] = {.lex_state = 54, .external_lex_state = 2},
  [590] = {.lex_state = 54, .external_lex_state = 2},
  [591] = {.lex_state = 54, .external_lex_state = 2},
  [592] = {.lex_state = 55, .external_lex_state = 2},
  [593] = {.lex_state = 56, .external_lex_state = 11},
  [594] = {.lex_state = 54, .external_lex_state = 2},
  [595] = {.lex_state = 54, .external_lex_state = 2},
  [596] = {.lex_state = 54, .external_lex_state = 2},
  [597] = {.lex_state = 54, .external_lex_state = 2},
  [598] = {.lex_state = 54, .external_lex_state = 2},
  [599] = {.lex_state = 54, .external_lex_state = 2},
  [600] = {.lex_state = 54, .external_lex_state = 2},
  [601] = {.lex_state = 54, .external_lex_state = 2},
  [602] = {.lex_state = 54, .external_lex_state = 2},
  [603] = {.lex_state = 54, .external_lex_state = 2},
  [604] = {.lex_state = 54, .external_lex_state = 2},
  [605] = {.lex_state = 54, .external_lex_state = 2},
  [606] = {.lex_state = 54, .external_lex_state = 2},
  [607] = {.lex_state = 54, .external_lex_state = 2},
  [608] = {.lex_state = 54, .external_lex_state = 2},
  [609] = {.lex_state = 32, .external_lex_state = 9},
  [610] = {.lex_state = 54, .external_lex_state = 2},
  [611] = {.lex_state = 56, .external_lex_state = 10},
  [612] = {.lex_state = 54, .external_lex_state = 3},
  [613] = {.lex_state = 54, .external_lex_state = 3},
  [614] = {.lex_state = 54, .external_lex_state = 2},
  [615] = {.lex_state = 54, .external_lex_state = 3},
  [616] = {.lex_state = 54, .external_lex_state = 2},
  [617] = {.lex_state = 54, .external_lex_state = 3},
  [618] = {.lex_state = 54, .external_lex_state = 2},
  [619] = {.lex_state = 32, .external_lex_state = 9},
  [620] = {.lex_state = 55, .external_lex_state = 3},
  [621] = {.lex_state = 32, .external_lex_state = 9},
  [622] = {.lex_state = 32, .external_lex_state = 9},
  [623] = {.lex_state = 32, .external_lex_state = 9},
  [624] = {.lex_state = 56, .external_lex_state = 11},
  [625] = {.lex_state = 55, .external_lex_state = 2},
  [626] = {.lex_state = 33, .external_lex_state = 9},
  [627] = {.lex_state = 33, .external_lex_state = 9},
  [628] = {.lex_state = 33, .external_lex_state = 9},
  [629] = {.lex_state = 33, .external_lex_state = 9},
  [630] = {.lex_state = 33, .external_lex_state = 9},
  [631] = {.lex_state = 33, .external_lex_state = 9},
  [632] = {.lex_state = 33, .external_lex_state = 9},
  [633] = {.lex_state = 33, .external_lex_state = 9},
  [634] = {.lex_state = 54, .external_lex_state = 3},
  [635] = {.lex_state = 33, .external_lex_state = 9},
  [636] = {.lex_state = 33, .external_lex_state = 9},
  [637] = {.lex_state = 33, .external_lex_state = 9},
  [638] = {.lex_state = 33, .external_lex_state = 9},
  [639] = {.lex_state = 33, .external_lex_state = 9},
  [640] = {.lex_state = 33, .external_lex_state = 9},
  [641] = {.lex_state = 33, .external_lex_state = 9},
  [642] = {.lex_state = 33, .external_lex_state = 9},
  [643] = {.lex_state = 33, .external_lex_state = 9},
  [644] = {.lex_state = 54, .external_lex_state = 2},
  [645] = {.lex_state = 33, .external_lex_state = 9},
  [646] = {.lex_state = 33, .external_lex_state = 9},
  [647] = {.lex_state = 54, .external_lex_state = 3},
  [648] = {.lex_state = 55, .external_lex_state = 3},
  [649] = {.lex_state = 55, .external_lex_state = 2},
  [650] = {.lex_state = 54, .external_lex_state = 2},
  [651] = {.lex_state = 56, .external_lex_state = 11},
  [652] = {.lex_state = 54, .external_lex_state = 2},
  [653] = {.lex_state = 56, .external_lex_state = 10},
  [654] = {.lex_state = 56, .external_lex_state = 10},
  [655] = {.lex_state = 56, .external_lex_state = 10},
  [656] = {.lex_state = 54, .external_lex_state = 2},
  [657] = {.lex_state = 55, .external_lex_state = 3},
  [658] = {.lex_state = 55, .external_lex_state = 3},
  [659] = {.lex_state = 56, .external_lex_state = 11},
  [660] = {.lex_state = 55, .external_lex_state = 3},
  [661] = {.lex_state = 56, .external_lex_state = 10},
  [662] = {.lex_state = 56, .external_lex_state = 10},
  [663] = {.lex_state = 55, .external_lex_state = 3},
  [664] = {.lex_state = 55, .external_lex_state = 3},
  [665] = {.lex_state = 55, .external_lex_state = 3},
  [666] = {.lex_state = 56, .external_lex_state = 10},
  [667] = {.lex_state = 56, .external_lex_state = 10},
  [668] = {.lex_state = 56, .external_lex_state = 10},
  [669] = {.lex_state = 55, .external_lex_state = 3},
  [670] = {.lex_state = 56, .external_lex_state = 10},
  [671] = {.lex_state = 56, .external_lex_state = 10},
  [672] = {.lex_state = 55, .external_lex_state = 2},
  [673] = {.lex_state = 56, .external_lex_state = 10},
  [674] = {.lex_state = 55, .external_lex_state = 3},
  [675] = {.lex_state = 56, .external_lex_state = 11},
  [676] = {.lex_state = 54, .external_lex_state = 3},
  [677] = {.lex_state = 54, .external_lex_state = 6},
  [678] = {.lex_state = 55, .external_lex_state = 2},
  [679] = {.lex_state = 54, .external_lex_state = 6},
  [680] = {.lex_state = 56, .external_lex_state = 11},
  [681] = {.lex_state = 54, .external_lex_state = 3},
  [682] = {.lex_state = 54, .external_lex_state = 2},
  [683] = {.lex_state = 56, .external_lex_state = 11},
  [684] = {.lex_state = 54, .external_lex_state = 2},
  [685] = {.lex_state = 56, .external_lex_state = 11},
  [686] = {.lex_state = 55, .external_lex_state = 2},
  [687] = {.lex_state = 56, .external_lex_state = 11},
  [688] = {.lex_state = 56, .external_lex_state = 11},
  [689] = {.lex_state = 55, .external_lex_state = 2},
  [690] = {.lex_state = 56, .external_lex_state = 11},
  [691] = {.lex_state = 55, .external_lex_state = 2},
  [692] = {.lex_state = 55, .external_lex_state = 2},
  [693] = {.lex_state = 56, .external_lex_state = 11},
  [694] = {.lex_state = 55, .external_lex_state = 2},
  [695] = {.lex_state = 54, .external_lex_state = 3},
  [696] = {.lex_state = 56, .external_lex_state = 11},
  [697] = {.lex_state = 54, .external_lex_state = 3},
  [698] = {.lex_state = 55, .external_lex_state = 2},
  [699] = {.lex_state = 54, .external_lex_state = 3},
  [700] = {.lex_state = 54, .external_lex_state = 3},
  [701] = {.lex_state = 54, .external_lex_state = 2},
  [702] = {.lex_state = 54, .external_lex_state = 2},
  [703] = {.lex_state = 54, .external_lex_state = 2},
  [704] = {.lex_state = 54, .external_lex_state = 3},
  [705] = {.lex_state = 54, .external_lex_state = 2},
  [706] = {.lex_state = 54, .external_lex_state = 2},
  [707] = {.lex_state = 54, .external_lex_state = 3},
  [708] = {.lex_state = 54, .external_lex_state = 3},
  [709] = {.lex_state = 54, .external_lex_state = 2},
  [710] = {.lex_state = 54, .external_lex_state = 2},
  [711] = {.lex_state = 54, .external_lex_state = 3},
  [712] = {.lex_state = 54, .external_lex_state = 2},
  [713] = {.lex_state = 54, .external_lex_state = 3},
  [714] = {.lex_state = 54, .external_lex_state = 2},
  [715] = {.lex_state = 54, .external_lex_state = 2},
  [716] = {.lex_state = 54, .external_lex_state = 3},
  [717] = {.lex_state = 54, .external_lex_state = 2},
  [718] = {.lex_state = 54, .external_lex_state = 3},
  [719] = {.lex_state = 54, .external_lex_state = 3},
  [720] = {.lex_state = 54, .external_lex_state = 3},
  [721] = {.lex_state = 54, .external_lex_state = 7},
  [722] = {.lex_state = 54, .external_lex_state = 3},
  [723] = {.lex_state = 54, .external_lex_state = 2},
  [724] = {.lex_state = 54, .external_lex_state = 2},
  [725] = {.lex_state = 54, .external_lex_state = 3},
  [726] = {.lex_state = 54, .external_lex_state = 7},
  [727] = {.lex_state = 54, .external_lex_state = 2},
  [728] = {.lex_state = 54, .external_lex_state = 2},
  [729] = {.lex_state = 54, .external_lex_state = 2},
  [730] = {.lex_state = 54, .external_lex_state = 7},
  [731] = {.lex_state = 54, .external_lex_state = 2},
  [732] = {.lex_state = 54, .external_lex_state = 2},
  [733] = {.lex_state = 54, .external_lex_state = 3},
  [734] = {.lex_state = 54, .external_lex_state = 2},
  [735] = {.lex_state = 54, .external_lex_state = 2},
  [736] = {.lex_state = 54, .external_lex_state = 3},
  [737] = {.lex_state = 54, .external_lex_state = 3},
  [738] = {.lex_state = 54, .external_lex_state = 2},
  [739] = {.lex_state = 54, .external_lex_state = 3},
  [740] = {.lex_state = 54, .external_lex_state = 3},
  [741] = {.lex_state = 54, .external_lex_state = 3},
  [742] = {.lex_state = 54, .external_lex_state = 2},
  [743] = {.lex_state = 54, .external_lex_state = 2},
  [744] = {.lex_state = 54, .external_lex_state = 3},
  [745] = {.lex_state = 54, .external_lex_state = 3},
  [746] = {.lex_state = 54, .external_lex_state = 2},
  [747] = {.lex_state = 54, .external_lex_state = 3},
  [748] = {.lex_state = 54, .external_lex_state = 3},
  [749] = {.lex_state = 54, .external_lex_state = 3},
  [750] = {.lex_state = 54, .external_lex_state = 3},
  [751] = {.lex_state = 54, .external_lex_state = 3},
  [752] = {.lex_state = 54, .external_lex_state = 3},
  [753] = {.lex_state = 54, .external_lex_state = 3},
  [754] = {.lex_state = 54, .external_lex_state = 3},
  [755] = {.lex_state = 54, .external_lex_state = 2},
  [756] = {.lex_state = 54, .external_lex_state = 2},
  [757] = {.lex_state = 54, .external_lex_state = 3},
  [758] = {.lex_state = 54, .external_lex_state = 3},
  [759] = {.lex_state = 54, .external_lex_state = 3},
  [760] = {.lex_state = 54, .external_lex_state = 2},
  [761] = {.lex_state = 54, .external_lex_state = 2},
  [762] = {.lex_state = 54, .external_lex_state = 2},
  [763] = {.lex_state = 54, .external_lex_state = 3},
  [764] = {.lex_state = 54, .external_lex_state = 2},
  [765] = {.lex_state = 54, .external_lex_state = 3},
  [766] = {.lex_state = 54, .external_lex_state = 2},
  [767] = {.lex_state = 54, .external_lex_state = 3},
  [768] = {.lex_state = 54, .external_lex_state = 2},
  [769] = {.lex_state = 54, .external_lex_state = 2},
  [770] = {.lex_state = 54, .external_lex_state = 2},
  [771] = {.lex_state = 54, .external_lex_state = 3},
  [772] = {.lex_state = 54, .external_lex_state = 3},
  [773] = {.lex_state = 54, .external_lex_state = 3},
  [774] = {.lex_state = 54, .external_lex_state = 7},
  [775] = {.lex_state = 54, .external_lex_state = 2},
  [776] = {.lex_state = 54, .external_lex_state = 3},
  [777] = {.lex_state = 54, .external_lex_state = 3},
  [778] = {.lex_state = 54, .external_lex_state = 3},
  [779] = {.lex_state = 54, .external_lex_state = 3},
  [780] = {.lex_state = 54, .external_lex_state = 3},
  [781] = {.lex_state = 54, .external_lex_state = 2},
  [782] = {.lex_state = 54, .external_lex_state = 3},
  [783] = {.lex_state = 54, .external_lex_state = 3},
  [784] = {.lex_state = 54, .external_lex_state = 3},
  [785] = {.lex_state = 54, .external_lex_state = 2},
  [786] = {.lex_state = 54, .external_lex_state = 3},
  [787] = {.lex_state = 54, .external_lex_state = 8},
  [788] = {.lex_state = 54, .external_lex_state = 3},
  [789] = {.lex_state = 54, .external_lex_state = 2},
  [790] = {.lex_state = 54, .external_lex_state = 2},
  [791] = {.lex_state = 54, .external_lex_state = 2},
  [792] = {.lex_state = 54, .external_lex_state = 2},
  [793] = {.lex_state = 54, .external_lex_state = 2},
  [794] = {.lex_state = 54, .external_lex_state = 3},
  [795] = {.lex_state = 54, .external_lex_state = 3},
  [796] = {.lex_state = 54, .external_lex_state = 2},
  [797] = {.lex_state = 54, .external_lex_state = 2},
  [798] = {.lex_state = 54, .external_lex_state = 2},
  [799] = {.lex_state = 54, .external_lex_state = 3},
  [800] = {.lex_state = 54, .external_lex_state = 2},
  [801] = {.lex_state = 54, .external_lex_state = 3},
  [802] = {.lex_state = 54, .external_lex_state = 3},
  [803] = {.lex_state = 54, .external_lex_state = 3},
  [804] = {.lex_state = 54, .external_lex_state = 3},
  [805] = {.lex_state = 54, .external_lex_state = 2},
  [806] = {.lex_state = 54, .external_lex_state = 2},
  [807] = {.lex_state = 54, .external_lex_state = 3},
  [808] = {.lex_state = 54, .external_lex_state = 3},
  [809] = {.lex_state = 54, .external_lex_state = 3},
  [810] = {.lex_state = 54, .external_lex_state = 3},
  [811] = {.lex_state = 54, .external_lex_state = 3},
  [812] = {.lex_state = 54, .external_lex_state = 3},
  [813] = {.lex_state = 54, .external_lex_state = 3},
  [814] = {.lex_state = 54, .external_lex_state = 3},
  [815] = {.lex_state = 54, .external_lex_state = 3},
  [816] = {.lex_state = 54, .external_lex_state = 2},
  [817] = {.lex_state = 54, .external_lex_state = 3},
  [818] = {.lex_state = 54, .external_lex_state = 3},
  [819] = {.lex_state = 54, .external_lex_state = 2},
  [820] = {.lex_state = 54, .external_lex_state = 2},
  [821] = {.lex_state = 54, .external_lex_state = 2},
  [822] = {.lex_state = 54, .external_lex_state = 2},
  [823] = {.lex_state = 54, .external_lex_state = 2},
  [824] = {.lex_state = 54, .external_lex_state = 2},
  [825] = {.lex_state = 54, .external_lex_state = 2},
  [826] = {.lex_state = 54, .external_lex_state = 2},
  [827] = {.lex_state = 54, .external_lex_state = 2},
  [828] = {.lex_state = 54, .external_lex_state = 2},
  [829] = {.lex_state = 54, .external_lex_state = 2},
  [830] = {.lex_state = 54, .external_lex_state = 2},
  [831] = {.lex_state = 54, .external_lex_state = 2},
  [832] = {.lex_state = 54, .external_lex_state = 8},
  [833] = {.lex_state = 54, .external_lex_state = 2},
  [834] = {.lex_state = 54, .external_lex_state = 2},
  [835] = {.lex_state = 54, .external_lex_state = 2},
  [836] = {.lex_state = 54, .external_lex_state = 2},
  [837] = {.lex_state = 54, .external_lex_state = 3},
  [838] = {.lex_state = 54, .external_lex_state = 2},
  [839] = {.lex_state = 54, .external_lex_state = 2},
  [840] = {.lex_state = 54, .external_lex_state = 2},
  [841] = {.lex_state = 54, .external_lex_state = 2},
  [842] = {.lex_state = 54, .external_lex_state = 2},
  [843] = {.lex_state = 54, .external_lex_state = 2},
  [844] = {.lex_state = 54, .external_lex_state = 2},
  [845] = {.lex_state = 54, .external_lex_state = 2},
  [846] = {.lex_state = 54, .external_lex_state = 2},
  [847] = {.lex_state = 54, .external_lex_state = 2},
  [848] = {.lex_state = 54, .external_lex_state = 2},
  [849] = {.lex_state = 54, .external_lex_state = 2},
  [850] = {.lex_state = 54, .external_lex_state = 2},
  [851] = {.lex_state = 54, .external_lex_state = 2},
  [852] = {.lex_state = 54, .external_lex_state = 2},
  [853] = {.lex_state = 54, .external_lex_state = 2},
  [854] = {.lex_state = 54, .external_lex_state = 2},
  [855] = {.lex_state = 54, .external_lex_state = 2},
  [856] = {.lex_state = 54, .external_lex_state = 2},
  [857] = {.lex_state = 54, .external_lex_state = 2},
  [858] = {.lex_state = 54, .external_lex_state = 7},
  [859] = {.lex_state = 54, .external_lex_state = 2},
  [860] = {.lex_state = 54, .external_lex_state = 2},
  [861] = {.lex_state = 54, .external_lex_state = 2},
  [862] = {.lex_state = 54, .external_lex_state = 2},
  [863] = {.lex_state = 54, .external_lex_state = 2},
  [864] = {.lex_state = 54, .external_lex_state = 2},
  [865] = {.lex_state = 54, .external_lex_state = 2},
  [866] = {.lex_state = 54, .external_lex_state = 2},
  [867] = {.lex_state = 54, .external_lex_state = 2},
  [868] = {.lex_state = 54, .external_lex_state = 2},
  [869] = {.lex_state = 54, .external_lex_state = 2},
  [870] = {.lex_state = 54, .external_lex_state = 2},
  [871] = {.lex_state = 54, .external_lex_state = 2},
  [872] = {.lex_state = 54, .external_lex_state = 2},
  [873] = {.lex_state = 54, .external_lex_state = 2},
  [874] = {.lex_state = 54, .external_lex_state = 2},
  [875] = {.lex_state = 54, .external_lex_state = 2},
  [876] = {.lex_state = 54, .external_lex_state = 2},
  [877] = {.lex_state = 54, .external_lex_state = 2},
  [878] = {.lex_state = 54, .external_lex_state = 2},
  [879] = {.lex_state = 54, .external_lex_state = 2},
  [880] = {.lex_state = 54, .external_lex_state = 2},
  [881] = {.lex_state = 54, .external_lex_state = 2},
  [882] = {.lex_state = 54, .external_lex_state = 2},
  [883] = {.lex_state = 54, .external_lex_state = 2},
  [884] = {.lex_state = 54, .external_lex_state = 2},
  [885] = {.lex_state = 54, .external_lex_state = 2},
  [886] = {.lex_state = 54, .external_lex_state = 2},
  [887] = {.lex_state = 54, .external_lex_state = 2},
  [888] = {.lex_state = 54, .external_lex_state = 2},
  [889] = {.lex_state = 54, .external_lex_state = 2},
  [890] = {.lex_state = 54, .external_lex_state = 2},
  [891] = {.lex_state = 54, .external_lex_state = 2},
  [892] = {.lex_state = 54, .external_lex_state = 2},
  [893] = {.lex_state = 54, .external_lex_state = 2},
  [894] = {.lex_state = 54, .external_lex_state = 2},
  [895] = {.lex_state = 54, .external_lex_state = 2},
  [896] = {.lex_state = 54, .external_lex_state = 2},
  [897] = {.lex_state = 54, .external_lex_state = 2},
  [898] = {.lex_state = 54, .external_lex_state = 2},
  [899] = {.lex_state = 54, .external_lex_state = 2},
  [900] = {.lex_state = 54, .external_lex_state = 2},
  [901] = {.lex_state = 54, .external_lex_state = 2},
  [902] = {.lex_state = 54, .external_lex_state = 2},
  [903] = {.lex_state = 54, .external_lex_state = 2},
  [904] = {.lex_state = 54, .external_lex_state = 2},
  [905] = {.lex_state = 54, .external_lex_state = 2},
  [906] = {.lex_state = 54, .external_lex_state = 2},
  [907] = {.lex_state = 54, .external_lex_state = 2},
  [908] = {.lex_state = 54, .external_lex_state = 2},
  [909] = {.lex_state = 54, .external_lex_state = 2},
  [910] = {.lex_state = 54, .external_lex_state = 2},
  [911] = {.lex_state = 54, .external_lex_state = 2},
  [912] = {.lex_state = 54, .external_lex_state = 2},
  [913] = {.lex_state = 54, .external_lex_state = 2},
  [914] = {.lex_state = 54, .external_lex_state = 2},
  [915] = {.lex_state = 54, .external_lex_state = 2},
  [916] = {.lex_state = 54, .external_lex_state = 2},
  [917] = {.lex_state = 54, .external_lex_state = 2},
  [918] = {.lex_state = 54, .external_lex_state = 2},
  [919] = {.lex_state = 54, .external_lex_state = 2},
  [920] = {.lex_state = 54, .external_lex_state = 2},
  [921] = {.lex_state = 54, .external_lex_state = 2},
  [922] = {.lex_state = 54, .external_lex_state = 2},
  [923] = {.lex_state = 54, .external_lex_state = 2},
  [924] = {.lex_state = 54, .external_lex_state = 2},
  [925] = {.lex_state = 54, .external_lex_state = 2},
  [926] = {.lex_state = 54, .external_lex_state = 2},
  [927] = {.lex_state = 54, .external_lex_state = 2},
  [928] = {.lex_state = 54, .external_lex_state = 2},
  [929] = {.lex_state = 54, .external_lex_state = 2},
  [930] = {.lex_state = 54, .external_lex_state = 2},
  [931] = {.lex_state = 54, .external_lex_state = 2},
  [932] = {.lex_state = 54, .external_lex_state = 2},
  [933] = {.lex_state = 54, .external_lex_state = 2},
  [934] = {.lex_state = 54, .external_lex_state = 2},
  [935] = {.lex_state = 54, .external_lex_state = 2},
  [936] = {.lex_state = 54, .external_lex_state = 2},
  [937] = {.lex_state = 54, .external_lex_state = 2},
  [938] = {.lex_state = 54, .external_lex_state = 2},
  [939] = {.lex_state = 54, .external_lex_state = 2},
  [940] = {.lex_state = 54, .external_lex_state = 2},
  [941] = {.lex_state = 54, .external_lex_state = 2},
  [942] = {.lex_state = 54, .external_lex_state = 2},
  [943] = {.lex_state = 54, .external_lex_state = 2},
  [944] = {.lex_state = 54, .external_lex_state = 2},
  [945] = {.lex_state = 54, .external_lex_state = 2},
  [946] = {.lex_state = 54, .external_lex_state = 2},
  [947] = {.lex_state = 54, .external_lex_state = 2},
  [948] = {.lex_state = 54, .external_lex_state = 2},
  [949] = {.lex_state = 54, .external_lex_state = 2},
  [950] = {.lex_state = 54, .external_lex_state = 2},
  [951] = {.lex_state = 54, .external_lex_state = 2},
  [952] = {.lex_state = 54, .external_lex_state = 2},
  [953] = {.lex_state = 54, .external_lex_state = 2},
  [954] = {.lex_state = 54, .external_lex_state = 2},
  [955] = {.lex_state = 54, .external_lex_state = 2},
  [956] = {.lex_state = 54, .external_lex_state = 2},
  [957] = {.lex_state = 54, .external_lex_state = 2},
  [958] = {.lex_state = 54, .external_lex_state = 2},
  [959] = {.lex_state = 54, .external_lex_state = 2},
  [960] = {.lex_state = 54, .external_lex_state = 2},
  [961] = {.lex_state = 54, .external_lex_state = 2},
  [962] = {.lex_state = 54, .external_lex_state = 2},
  [963] = {.lex_state = 54, .external_lex_state = 2},
  [964] = {.lex_state = 54, .external_lex_state = 2},
  [965] = {.lex_state = 54, .external_lex_state = 2},
  [966] = {.lex_state = 54, .external_lex_state = 2},
  [967] = {.lex_state = 54, .external_lex_state = 2},
  [968] = {.lex_state = 54, .external_lex_state = 2},
  [969] = {.lex_state = 54, .external_lex_state = 2},
  [970] = {.lex_state = 54, .external_lex_state = 2},
  [971] = {.lex_state = 54, .external_lex_state = 2},
  [972] = {.lex_state = 54, .external_lex_state = 2},
  [973] = {.lex_state = 54, .external_lex_state = 2},
  [974] = {.lex_state = 54, .external_lex_state = 2},
  [975] = {.lex_state = 37, .external_lex_state = 4},
  [976] = {.lex_state = 37, .external_lex_state = 4},
  [977] = {.lex_state = 37, .external_lex_state = 9},
  [978] = {.lex_state = 37, .external_lex_state = 4},
  [979] = {.lex_state = 37, .external_lex_state = 6},
  [980] = {.lex_state = 37, .external_lex_state = 6},
  [981] = {.lex_state = 37, .external_lex_state = 9},
  [982] = {.lex_state = 37, .external_lex_state = 9},
  [983] = {.lex_state = 37, .external_lex_state = 9},
  [984] = {.lex_state = 37, .external_lex_state = 9},
  [985] = {.lex_state = 37, .external_lex_state = 9},
  [986] = {.lex_state = 37, .external_lex_state = 9},
  [987] = {.lex_state = 37, .external_lex_state = 9},
  [988] = {.lex_state = 37, .external_lex_state = 6},
  [989] = {.lex_state = 37, .external_lex_state = 9},
  [990] = {.lex_state = 37, .external_lex_state = 9},
  [991] = {.lex_state = 37, .external_lex_state = 6},
  [992] = {.lex_state = 37, .external_lex_state = 9},
  [993] = {.lex_state = 37, .external_lex_state = 6},
  [994] = {.lex_state = 37, .external_lex_state = 12},
  [995] = {.lex_state = 37, .external_lex_state = 9},
  [996] = {.lex_state = 37, .external_lex_state = 12},
  [997] = {.lex_state = 37, .external_lex_state = 6},
  [998] = {.lex_state = 37, .external_lex_state = 9},
  [999] = {.lex_state = 37, .external_lex_state = 12},
  [1000] = {.lex_state = 37, .external_lex_state = 12},
  [1001] = {.lex_state = 37, .external_lex_state = 12},
  [1002] = {.lex_state = 37, .external_lex_state = 13},
  [1003] = {.lex_state = 37, .external_lex_state = 12},
  [1004] = {.lex_state = 37, .external_lex_state = 2},
  [1005] = {.lex_state = 37, .external_lex_state = 12},
  [1006] = {.lex_state = 37, .external_lex_state = 2},
  [1007] = {.lex_state = 37, .external_lex_state = 12},
  [1008] = {.lex_state = 37, .external_lex_state = 14},
  [1009] = {.lex_state = 37, .external_lex_state = 7},
  [1010] = {.lex_state = 37, .external_lex_state = 12},
  [1011] = {.lex_state = 37, .external_lex_state = 12},
  [1012] = {.lex_state = 38, .external_lex_state = 9},
  [1013] = {.lex_state = 37, .external_lex_state = 9},
  [1014] = {.lex_state = 37, .external_lex_state = 7},
  [1015] = {.lex_state = 37, .external_lex_state = 12},
  [1016] = {.lex_state = 37, .external_lex_state = 15},
  [1017] = {.lex_state = 37, .external_lex_state = 8},
  [1018] = {.lex_state = 37, .external_lex_state = 7},
  [1019] = {.lex_state = 37, .external_lex_state = 8},
  [1020] = {.lex_state = 37, .external_lex_state = 4},
  [1021] = {.lex_state = 37, .external_lex_state = 7},
  [1022] = {.lex_state = 37, .external_lex_state = 8},
  [1023] = {.lex_state = 37, .external_lex_state = 12},
  [1024] = {.lex_state = 37, .external_lex_state = 14},
  [1025] = {.lex_state = 37, .external_lex_state = 12},
  [1026] = {.lex_state = 37, .external_lex_state = 12},
  [1027] = {.lex_state = 37, .external_lex_state = 12},
  [1028] = {.lex_state = 37, .external_lex_state = 12},
  [1029] = {.lex_state = 37, .external_lex_state = 12},
  [1030] = {.lex_state = 37, .external_lex_state = 7},
  [1031] = {.lex_state = 37, .external_lex_state = 12},
  [1032] = {.lex_state = 37, .external_lex_state = 7},
  [1033] = {.lex_state = 37, .external_lex_state = 12},
  [1034] = {.lex_state = 37, .external_lex_state = 12},
  [1035] = {.lex_state = 37, .external_lex_state = 12},
  [1036] = {.lex_state = 37, .external_lex_state = 12},
  [1037] = {.lex_state = 38, .external_lex_state = 9},
  [1038] = {.lex_state = 37, .external_lex_state = 12},
  [1039] = {.lex_state = 37, .external_lex_state = 12},
  [1040] = {.lex_state = 37, .external_lex_state = 12},
  [1041] = {.lex_state = 37, .external_lex_state = 12},
  [1042] = {.lex_state = 37, .external_lex_state = 4},
  [1043] = {.lex_state = 38, .external_lex_state = 9},
  [1044] = {.lex_state = 37, .external_lex_state = 12},
  [1045] = {.lex_state = 37, .external_lex_state = 2},
  [1046] = {.lex_state = 37, .external_lex_state = 12},
  [1047] = {.lex_state = 37, .external_lex_state = 12},
  [1048] = {.lex_state = 37, .external_lex_state = 12},
  [1049] = {.lex_state = 37, .external_lex_state = 12},
  [1050] = {.lex_state = 37, .external_lex_state = 12},
  [1051] = {.lex_state = 37, .external_lex_state = 12},
  [1052] = {.lex_state = 37, .external_lex_state = 6},
  [1053] = {.lex_state = 37, .external_lex_state = 14},
  [1054] = {.lex_state = 37, .external_lex_state = 13},
  [1055] = {.lex_state = 37, .external_lex_state = 13},
  [1056] = {.lex_state = 37, .external_lex_state = 13},
  [1057] = {.lex_state = 37, .external_lex_state = 9},
  [1058] = {.lex_state = 37, .external_lex_state = 13},
  [1059] = {.lex_state = 37, .external_lex_state = 13},
  [1060] = {.lex_state = 37, .external_lex_state = 13},
  [1061] = {.lex_state = 37, .external_lex_state = 13},
  [1062] = {.lex_state = 37, .external_lex_state = 9},
  [1063] = {.lex_state = 37, .external_lex_state = 13},
  [1064] = {.lex_state = 37, .external_lex_state = 14},
  [1065] = {.lex_state = 37, .external_lex_state = 14},
  [1066] = {.lex_state = 37, .external_lex_state = 9},
  [1067] = {.lex_state = 37, .external_lex_state = 9},
  [1068] = {.lex_state = 37, .external_lex_state = 9},
  [1069] = {.lex_state = 37, .external_lex_state = 9},
  [1070] = {.lex_state = 37, .external_lex_state = 9},
  [1071] = {.lex_state = 37, .external_lex_state = 9},
  [1072] = {.lex_state = 37, .external_lex_state = 13},
  [1073] = {.lex_state = 37, .external_lex_state = 13},
  [1074] = {.lex_state = 37, .external_lex_state = 9},
  [1075] = {.lex_state = 37, .external_lex_state = 9},
  [1076] = {.lex_state = 37, .external_lex_state = 6},
  [1077] = {.lex_state = 37, .external_lex_state = 9},
  [1078] = {.lex_state = 37, .external_lex_state = 9},
  [1079] = {.lex_state = 38, .external_lex_state = 14},
  [1080] = {.lex_state = 38, .external_lex_state = 12},
  [1081] = {.lex_state = 38, .external_lex_state = 12},
  [1082] = {.lex_state = 37, .external_lex_state = 6},
  [1083] = {.lex_state = 38, .external_lex_state = 12},
  [1084] = {.lex_state = 37, .external_lex_state = 9},
  [1085] = {.lex_state = 37, .external_lex_state = 9},
  [1086] = {.lex_state = 37, .external_lex_state = 14},
  [1087] = {.lex_state = 38, .external_lex_state = 14},
  [1088] = {.lex_state = 38, .external_lex_state = 14},
  [1089] = {.lex_state = 37, .external_lex_state = 9},
  [1090] = {.lex_state = 37, .external_lex_state = 14},
  [1091] = {.lex_state = 37, .external_lex_state = 9},
  [1092] = {.lex_state = 38, .external_lex_state = 12},
  [1093] = {.lex_state = 37, .external_lex_state = 9},
  [1094] = {.lex_state = 37, .external_lex_state = 9},
  [1095] = {.lex_state = 37, .external_lex_state = 9},
  [1096] = {.lex_state = 38, .external_lex_state = 14},
  [1097] = {.lex_state = 37, .external_lex_state = 13},
  [1098] = {.lex_state = 37, .external_lex_state = 9},
  [1099] = {.lex_state = 37, .external_lex_state = 15},
  [1100] = {.lex_state = 37, .external_lex_state = 15},
  [1101] = {.lex_state = 37, .external_lex_state = 15},
  [1102] = {.lex_state = 37, .external_lex_state = 9},
  [1103] = {.lex_state = 37, .external_lex_state = 9},
  [1104] = {.lex_state = 37, .external_lex_state = 13},
  [1105] = {.lex_state = 37, .external_lex_state = 8},
  [1106] = {.lex_state = 38, .external_lex_state = 12},
  [1107] = {.lex_state = 37, .external_lex_state = 6},
  [1108] = {.lex_state = 38, .external_lex_state = 12},
  [1109] = {.lex_state = 38, .external_lex_state = 12},
  [1110] = {.lex_state = 37, .external_lex_state = 9},
  [1111] = {.lex_state = 37, .external_lex_state = 9},
  [1112] = {.lex_state = 37, .external_lex_state = 9},
  [1113] = {.lex_state = 37, .external_lex_state = 9},
  [1114] = {.lex_state = 38, .external_lex_state = 12},
  [1115] = {.lex_state = 38, .external_lex_state = 12},
  [1116] = {.lex_state = 37, .external_lex_state = 15},
  [1117] = {.lex_state = 37, .external_lex_state = 9},
  [1118] = {.lex_state = 37, .external_lex_state = 15},
  [1119] = {.lex_state = 37, .external_lex_state = 15},
  [1120] = {.lex_state = 38, .external_lex_state = 9},
  [1121] = {.lex_state = 37, .external_lex_state = 15},
  [1122] = {.lex_state = 37, .external_lex_state = 9},
  [1123] = {.lex_state = 37, .external_lex_state = 15},
  [1124] = {.lex_state = 37, .external_lex_state = 15},
  [1125] = {.lex_state = 37, .external_lex_state = 15},
  [1126] = {.lex_state = 37, .external_lex_state = 15},
  [1127] = {.lex_state = 37, .external_lex_state = 9},
  [1128] = {.lex_state = 37, .external_lex_state = 14},
  [1129] = {.lex_state = 37, .external_lex_state = 15},
  [1130] = {.lex_state = 37, .external_lex_state = 15},
  [1131] = {.lex_state = 37, .external_lex_state = 8},
  [1132] = {.lex_state = 37, .external_lex_state = 14},
  [1133] = {.lex_state = 37, .external_lex_state = 9},
  [1134] = {.lex_state = 37, .external_lex_state = 14},
  [1135] = {.lex_state = 37, .external_lex_state = 14},
  [1136] = {.lex_state = 37, .external_lex_state = 14},
  [1137] = {.lex_state = 37, .external_lex_state = 9},
  [1138] = {.lex_state = 37, .external_lex_state = 9},
  [1139] = {.lex_state = 37, .external_lex_state = 14},
  [1140] = {.lex_state = 37, .external_lex_state = 14},
  [1141] = {.lex_state = 38, .external_lex_state = 12},
  [1142] = {.lex_state = 37, .external_lex_state = 14},
  [1143] = {.lex_state = 37, .external_lex_state = 9},
  [1144] = {.lex_state = 37, .external_lex_state = 14},
  [1145] = {.lex_state = 37, .external_lex_state = 9},
  [1146] = {.lex_state = 37, .external_lex_state = 9},
  [1147] = {.lex_state = 37, .external_lex_state = 14},
  [1148] = {.lex_state = 38, .external_lex_state = 12},
  [1149] = {.lex_state = 38, .external_lex_state = 12},
  [1150] = {.lex_state = 37, .external_lex_state = 8},
  [1151] = {.lex_state = 37, .external_lex_state = 14},
  [1152] = {.lex_state = 37, .external_lex_state = 14},
  [1153] = {.lex_state = 37, .external_lex_state = 14},
  [1154] = {.lex_state = 37, .external_lex_state = 9},
  [1155] = {.lex_state = 37, .external_lex_state = 14},
  [1156] = {.lex_state = 37, .external_lex_state = 14},
  [1157] = {.lex_state = 37, .external_lex_state = 14},
  [1158] = {.lex_state = 37, .external_lex_state = 14},
  [1159] = {.lex_state = 37, .external_lex_state = 14},
  [1160] = {.lex_state = 37, .external_lex_state = 14},
  [1161] = {.lex_state = 37, .external_lex_state = 14},
  [1162] = {.lex_state = 37, .external_lex_state = 15},
  [1163] = {.lex_state = 37, .external_lex_state = 12},
  [1164] = {.lex_state = 37, .external_lex_state = 12},
  [1165] = {.lex_state = 37, .external_lex_state = 8},
  [1166] = {.lex_state = 37, .external_lex_state = 12},
  [1167] = {.lex_state = 37, .external_lex_state = 12},
  [1168] = {.lex_state = 37, .external_lex_state = 12},
  [1169] = {.lex_state = 37, .external_lex_state = 12},
  [1170] = {.lex_state = 37, .external_lex_state = 12},
  [1171] = {.lex_state = 38, .external_lex_state = 14},
  [1172] = {.lex_state = 38, .external_lex_state = 14},
  [1173] = {.lex_state = 38, .external_lex_state = 14},
  [1174] = {.lex_state = 37, .external_lex_state = 12},
  [1175] = {.lex_state = 37, .external_lex_state = 12},
  [1176] = {.lex_state = 37, .external_lex_state = 12},
  [1177] = {.lex_state = 37, .external_lex_state = 12},
  [1178] = {.lex_state = 37, .external_lex_state = 12},
  [1179] = {.lex_state = 37, .external_lex_state = 15},
  [1180] = {.lex_state = 37, .external_lex_state = 12},
  [1181] = {.lex_state = 37, .external_lex_state = 7},
  [1182] = {.lex_state = 37, .external_lex_state = 12},
  [1183] = {.lex_state = 37, .external_lex_state = 12},
  [1184] = {.lex_state = 37, .external_lex_state = 12},
  [1185] = {.lex_state = 37, .external_lex_state = 12},
  [1186] = {.lex_state = 37, .external_lex_state = 12},
  [1187] = {.lex_state = 37, .external_lex_state = 14},
  [1188] = {.lex_state = 37, .external_lex_state = 15},
  [1189] = {.lex_state = 37, .external_lex_state = 15},
  [1190] = {.lex_state = 38, .external_lex_state = 14},
  [1191] = {.lex_state = 38, .external_lex_state = 13},
  [1192] = {.lex_state = 37, .external_lex_state = 12},
  [1193] = {.lex_state = 37, .external_lex_state = 12},
  [1194] = {.lex_state = 37, .external_lex_state = 8},
  [1195] = {.lex_state = 37, .external_lex_state = 12},
  [1196] = {.lex_state = 37, .external_lex_state = 7},
  [1197] = {.lex_state = 37, .external_lex_state = 12},
  [1198] = {.lex_state = 37, .external_lex_state = 12},
  [1199] = {.lex_state = 37, .external_lex_state = 12},
  [1200] = {.lex_state = 38, .external_lex_state = 15},
  [1201] = {.lex_state = 37, .external_lex_state = 12},
  [1202] = {.lex_state = 37, .external_lex_state = 7},
  [1203] = {.lex_state = 37, .external_lex_state = 12},
  [1204] = {.lex_state = 37, .external_lex_state = 12},
  [1205] = {.lex_state = 38, .external_lex_state = 13},
  [1206] = {.lex_state = 37, .external_lex_state = 12},
  [1207] = {.lex_state = 38, .external_lex_state = 13},
  [1208] = {.lex_state = 37, .external_lex_state = 2},
  [1209] = {.lex_state = 38, .external_lex_state = 13},
  [1210] = {.lex_state = 37, .external_lex_state = 15},
  [1211] = {.lex_state = 37, .external_lex_state = 12},
  [1212] = {.lex_state = 37, .external_lex_state = 12},
  [1213] = {.lex_state = 37, .external_lex_state = 15},
  [1214] = {.lex_state = 38, .external_lex_state = 14},
  [1215] = {.lex_state = 37, .external_lex_state = 12},
  [1216] = {.lex_state = 37, .external_lex_state = 15},
  [1217] = {.lex_state = 37, .external_lex_state = 15},
  [1218] = {.lex_state = 37, .external_lex_state = 12},
  [1219] = {.lex_state = 37, .external_lex_state = 14},
  [1220] = {.lex_state = 37, .external_lex_state = 12},
  [1221] = {.lex_state = 37, .external_lex_state = 12},
  [1222] = {.lex_state = 37, .external_lex_state = 15},
  [1223] = {.lex_state = 37, .external_lex_state = 15},
  [1224] = {.lex_state = 37, .external_lex_state = 12},
  [1225] = {.lex_state = 37, .external_lex_state = 15},
  [1226] = {.lex_state = 38, .external_lex_state = 15},
  [1227] = {.lex_state = 37, .external_lex_state = 12},
  [1228] = {.lex_state = 38, .external_lex_state = 15},
  [1229] = {.lex_state = 38, .external_lex_state = 15},
  [1230] = {.lex_state = 38, .external_lex_state = 15},
  [1231] = {.lex_state = 37, .external_lex_state = 15},
  [1232] = {.lex_state = 37, .external_lex_state = 15},
  [1233] = {.lex_state = 37, .external_lex_state = 12},
  [1234] = {.lex_state = 38, .external_lex_state = 15},
  [1235] = {.lex_state = 37, .external_lex_state = 12},
  [1236] = {.lex_state = 37, .external_lex_state = 12},
  [1237] = {.lex_state = 37, .external_lex_state = 12},
  [1238] = {.lex_state = 37, .external_lex_state = 12},
  [1239] = {.lex_state = 37, .external_lex_state = 12},
  [1240] = {.lex_state = 37, .external_lex_state = 12},
  [1241] = {.lex_state = 37, .external_lex_state = 12},
  [1242] = {.lex_state = 38, .external_lex_state = 14},
  [1243] = {.lex_state = 38, .external_lex_state = 14},
  [1244] = {.lex_state = 38, .external_lex_state = 14},
  [1245] = {.lex_state = 38, .external_lex_state = 14},
  [1246] = {.lex_state = 38, .external_lex_state = 15},
  [1247] = {.lex_state = 37, .external_lex_state = 12},
  [1248] = {.lex_state = 38, .external_lex_state = 14},
  [1249] = {.lex_state = 38, .external_lex_state = 15},
  [1250] = {.lex_state = 37, .external_lex_state = 12},
  [1251] = {.lex_state = 38, .external_lex_state = 14},
  [1252] = {.lex_state = 37, .external_lex_state = 12},
  [1253] = {.lex_state = 37, .external_lex_state = 12},
  [1254] = {.lex_state = 38, .external_lex_state = 15},
  [1255] = {.lex_state = 38, .external_lex_state = 15},
  [1256] = {.lex_state = 37, .external_lex_state = 12},
  [1257] = {.lex_state = 37, .external_lex_state = 12},
  [1258] = {.lex_state = 37, .external_lex_state = 12},
  [1259] = {.lex_state = 37, .external_lex_state = 2},
  [1260] = {.lex_state = 37, .external_lex_state = 7},
  [1261] = {.lex_state = 38, .external_lex_state = 14},
  [1262] = {.lex_state = 37, .external_lex_state = 12},
  [1263] = {.lex_state = 37, .external_lex_state = 12},
  [1264] = {.lex_state = 37, .external_lex_state = 12},
  [1265] = {.lex_state = 37, .external_lex_state = 12},
  [1266] = {.lex_state = 37, .external_lex_state = 12},
  [1267] = {.lex_state = 37, .external_lex_state = 12},
  [1268] = {.lex_state = 37, .external_lex_state = 12},
  [1269] = {.lex_state = 37, .external_lex_state = 14},
  [1270] = {.lex_state = 37, .external_lex_state = 14},
  [1271] = {.lex_state = 37, .external_lex_state = 14},
  [1272] = {.lex_state = 37, .external_lex_state = 12},
  [1273] = {.lex_state = 37, .external_lex_state = 12},
  [1274] = {.lex_state = 37, .external_lex_state = 14},
  [1275] = {.lex_state = 37, .external_lex_state = 12},
  [1276] = {.lex_state = 37, .external_lex_state = 12},
  [1277] = {.lex_state = 37, .external_lex_state = 12},
  [1278] = {.lex_state = 37, .external_lex_state = 14},
  [1279] = {.lex_state = 37, .external_lex_state = 12},
  [1280] = {.lex_state = 37, .external_lex_state = 12},
  [1281] = {.lex_state = 37, .external_lex_state = 12},
  [1282] = {.lex_state = 37, .external_lex_state = 12},
  [1283] = {.lex_state = 37, .external_lex_state = 12},
  [1284] = {.lex_state = 37, .external_lex_state = 12},
  [1285] = {.lex_state = 37, .external_lex_state = 12},
  [1286] = {.lex_state = 37, .external_lex_state = 12},
  [1287] = {.lex_state = 37, .external_lex_state = 14},
  [1288] = {.lex_state = 37, .external_lex_state = 14},
  [1289] = {.lex_state = 37, .external_lex_state = 14},
  [1290] = {.lex_state = 37, .external_lex_state = 14},
  [1291] = {.lex_state = 37, .external_lex_state = 15},
  [1292] = {.lex_state = 37, .external_lex_state = 14},
  [1293] = {.lex_state = 37, .external_lex_state = 13},
  [1294] = {.lex_state = 37, .external_lex_state = 13},
  [1295] = {.lex_state = 37, .external_lex_state = 13},
  [1296] = {.lex_state = 37, .external_lex_state = 14},
  [1297] = {.lex_state = 37, .external_lex_state = 14},
  [1298] = {.lex_state = 37, .external_lex_state = 14},
  [1299] = {.lex_state = 37, .external_lex_state = 14},
  [1300] = {.lex_state = 37, .external_lex_state = 14},
  [1301] = {.lex_state = 37, .external_lex_state = 14},
  [1302] = {.lex_state = 37, .external_lex_state = 14},
  [1303] = {.lex_state = 37, .external_lex_state = 14},
  [1304] = {.lex_state = 37, .external_lex_state = 14},
  [1305] = {.lex_state = 37, .external_lex_state = 14},
  [1306] = {.lex_state = 37, .external_lex_state = 14},
  [1307] = {.lex_state = 38, .external_lex_state = 14},
  [1308] = {.lex_state = 38, .external_lex_state = 14},
  [1309] = {.lex_state = 37, .external_lex_state = 13},
  [1310] = {.lex_state = 38, .external_lex_state = 14},
  [1311] = {.lex_state = 37, .external_lex_state = 14},
  [1312] = {.lex_state = 37, .external_lex_state = 13},
  [1313] = {.lex_state = 37, .external_lex_state = 14},
  [1314] = {.lex_state = 37, .external_lex_state = 13},
  [1315] = {.lex_state = 37, .external_lex_state = 15},
  [1316] = {.lex_state = 37, .external_lex_state = 15},
  [1317] = {.lex_state = 37, .external_lex_state = 15},
  [1318] = {.lex_state = 37, .external_lex_state = 15},
  [1319] = {.lex_state = 37, .external_lex_state = 14},
  [1320] = {.lex_state = 37, .external_lex_state = 13},
  [1321] = {.lex_state = 37, .external_lex_state = 13},
  [1322] = {.lex_state = 37, .external_lex_state = 13},
  [1323] = {.lex_state = 37, .external_lex_state = 14},
  [1324] = {.lex_state = 37, .external_lex_state = 13},
  [1325] = {.lex_state = 37, .external_lex_state = 15},
  [1326] = {.lex_state = 37, .external_lex_state = 15},
  [1327] = {.lex_state = 37, .external_lex_state = 15},
  [1328] = {.lex_state = 37, .external_lex_state = 13},
  [1329] = {.lex_state = 37, .external_lex_state = 13},
  [1330] = {.lex_state = 37, .external_lex_state = 13},
  [1331] = {.lex_state = 37, .external_lex_state = 13},
  [1332] = {.lex_state = 37, .external_lex_state = 14},
  [1333] = {.lex_state = 37, .external_lex_state = 14},
  [1334] = {.lex_state = 37, .external_lex_state = 9},
  [1335] = {.lex_state = 37, .external_lex_state = 13},
  [1336] = {.lex_state = 37, .external_lex_state = 13},
  [1337] = {.lex_state = 37, .external_lex_state = 14},
  [1338] = {.lex_state = 37, .external_lex_state = 13},
  [1339] = {.lex_state = 37, .external_lex_state = 13},
  [1340] = {.lex_state = 38, .external_lex_state = 15},
  [1341] = {.lex_state = 37, .external_lex_state = 14},
  [1342] = {.lex_state = 37, .external_lex_state = 14},
  [1343] = {.lex_state = 38, .external_lex_state = 15},
  [1344] = {.lex_state = 37, .external_lex_state = 13},
  [1345] = {.lex_state = 38, .external_lex_state = 15},
  [1346] = {.lex_state = 37, .external_lex_state = 13},
  [1347] = {.lex_state = 37, .external_lex_state = 13},
  [1348] = {.lex_state = 37, .external_lex_state = 13},
  [1349] = {.lex_state = 37, .external_lex_state = 15},
  [1350] = {.lex_state = 37, .external_lex_state = 14},
  [1351] = {.lex_state = 37, .external_lex_state = 13},
  [1352] = {.lex_state = 37, .external_lex_state = 14},
  [1353] = {.lex_state = 37, .external_lex_state = 13},
  [1354] = {.lex_state = 37, .external_lex_state = 14},
  [1355] = {.lex_state = 33, .external_lex_state = 9},
  [1356] = {.lex_state = 37, .external_lex_state = 15},
  [1357] = {.lex_state = 37, .external_lex_state = 15},
  [1358] = {.lex_state = 37, .external_lex_state = 15},
  [1359] = {.lex_state = 37, .external_lex_state = 15},
  [1360] = {.lex_state = 37, .external_lex_state = 13},
  [1361] = {.lex_state = 37, .external_lex_state = 13},
  [1362] = {.lex_state = 37, .external_lex_state = 13},
  [1363] = {.lex_state = 33, .external_lex_state = 9},
  [1364] = {.lex_state = 37, .external_lex_state = 15},
  [1365] = {.lex_state = 37, .external_lex_state = 13},
  [1366] = {.lex_state = 37, .external_lex_state = 14},
  [1367] = {.lex_state = 37, .external_lex_state = 15},
  [1368] = {.lex_state = 37, .external_lex_state = 15},
  [1369] = {.lex_state = 37, .external_lex_state = 14},
  [1370] = {.lex_state = 37, .external_lex_state = 14},
  [1371] = {.lex_state = 37, .external_lex_state = 14},
  [1372] = {.lex_state = 37, .external_lex_state = 14},
  [1373] = {.lex_state = 37, .external_lex_state = 14},
  [1374] = {.lex_state = 37, .external_lex_state = 14},
  [1375] = {.lex_state = 37, .external_lex_state = 14},
  [1376] = {.lex_state = 37, .external_lex_state = 14},
  [1377] = {.lex_state = 37, .external_lex_state = 14},
  [1378] = {.lex_state = 37, .external_lex_state = 14},
  [1379] = {.lex_state = 37, .external_lex_state = 14},
  [1380] = {.lex_state = 37, .external_lex_state = 15},
  [1381] = {.lex_state = 37, .external_lex_state = 15},
  [1382] = {.lex_state = 37, .external_lex_state = 15},
  [1383] = {.lex_state = 37, .external_lex_state = 14},
  [1384] = {.lex_state = 37, .external_lex_state = 14},
  [1385] = {.lex_state = 37, .external_lex_state = 14},
  [1386] = {.lex_state = 37, .external_lex_state = 14},
  [1387] = {.lex_state = 37, .external_lex_state = 15},
  [1388] = {.lex_state = 37, .external_lex_state = 13},
  [1389] = {.lex_state = 37, .external_lex_state = 14},
  [1390] = {.lex_state = 37, .external_lex_state = 14},
  [1391] = {.lex_state = 37, .external_lex_state = 14},
  [1392] = {.lex_state = 37, .external_lex_state = 13},
  [1393] = {.lex_state = 37, .external_lex_state = 15},
  [1394] = {.lex_state = 33, .external_lex_state = 9},
  [1395] = {.lex_state = 37, .external_lex_state = 14},
  [1396] = {.lex_state = 37, .external_lex_state = 14},
  [1397] = {.lex_state = 37, .external_lex_state = 15},
  [1398] = {.lex_state = 37, .external_lex_state = 15},
  [1399] = {.lex_state = 33, .external_lex_state = 9},
  [1400] = {.lex_state = 33, .external_lex_state = 9},
  [1401] = {.lex_state = 33, .external_lex_state = 9},
  [1402] = {.lex_state = 37, .external_lex_state = 15},
  [1403] = {.lex_state = 37, .external_lex_state = 15},
  [1404] = {.lex_state = 37, .external_lex_state = 15},
  [1405] = {.lex_state = 37, .external_lex_state = 14},
  [1406] = {.lex_state = 37, .external_lex_state = 14},
  [1407] = {.lex_state = 37, .external_lex_state = 14},
  [1408] = {.lex_state = 37, .external_lex_state = 14},
  [1409] = {.lex_state = 37, .external_lex_state = 14},
  [1410] = {.lex_state = 37, .external_lex_state = 8},
  [1411] = {.lex_state = 37, .external_lex_state = 15},
  [1412] = {.lex_state = 37, .external_lex_state = 14},
  [1413] = {.lex_state = 37, .external_lex_state = 15},
  [1414] = {.lex_state = 37, .external_lex_state = 15},
  [1415] = {.lex_state = 37, .external_lex_state = 15},
  [1416] = {.lex_state = 37, .external_lex_state = 15},
  [1417] = {.lex_state = 37, .external_lex_state = 15},
  [1418] = {.lex_state = 37, .external_lex_state = 14},
  [1419] = {.lex_state = 37, .external_lex_state = 15},
  [1420] = {.lex_state = 37, .external_lex_state = 8},
  [1421] = {.lex_state = 37, .external_lex_state = 15},
  [1422] = {.lex_state = 37, .external_lex_state = 14},
  [1423] = {.lex_state = 37, .external_lex_state = 14},
  [1424] = {.lex_state = 37, .external_lex_state = 15},
  [1425] = {.lex_state = 37, .external_lex_state = 15},
  [1426] = {.lex_state = 37, .external_lex_state = 14},
  [1427] = {.lex_state = 37, .external_lex_state = 14},
  [1428] = {.lex_state = 37, .external_lex_state = 14},
  [1429] = {.lex_state = 37, .external_lex_state = 13},
  [1430] = {.lex_state = 37, .external_lex_state = 15},
  [1431] = {.lex_state = 37, .external_lex_state = 14},
  [1432] = {.lex_state = 37, .external_lex_state = 14},
  [1433] = {.lex_state = 37, .external_lex_state = 13},
  [1434] = {.lex_state = 37, .external_lex_state = 13},
  [1435] = {.lex_state = 37, .external_lex_state = 14},
  [1436] = {.lex_state = 37, .external_lex_state = 13},
  [1437] = {.lex_state = 37, .external_lex_state = 13},
  [1438] = {.lex_state = 37, .external_lex_state = 14},
  [1439] = {.lex_state = 37, .external_lex_state = 13},
  [1440] = {.lex_state = 37, .external_lex_state = 14},
  [1441] = {.lex_state = 37, .external_lex_state = 14},
  [1442] = {.lex_state = 37, .external_lex_state = 14},
  [1443] = {.lex_state = 37, .external_lex_state = 15},
  [1444] = {.lex_state = 37, .external_lex_state = 15},
  [1445] = {.lex_state = 37, .external_lex_state = 15},
  [1446] = {.lex_state = 37, .external_lex_state = 14},
  [1447] = {.lex_state = 37, .external_lex_state = 14},
  [1448] = {.lex_state = 37, .external_lex_state = 15},
  [1449] = {.lex_state = 37, .external_lex_state = 14},
  [1450] = {.lex_state = 37, .external_lex_state = 15},
  [1451] = {.lex_state = 38, .external_lex_state = 14},
  [1452] = {.lex_state = 37, .external_lex_state = 15},
  [1453] = {.lex_state = 37, .external_lex_state = 13},
  [1454] = {.lex_state = 37, .external_lex_state = 15},
  [1455] = {.lex_state = 37, .external_lex_state = 15},
  [1456] = {.lex_state = 37, .external_lex_state = 15},
  [1457] = {.lex_state = 37, .external_lex_state = 15},
  [1458] = {.lex_state = 37, .external_lex_state = 15},
  [1459] = {.lex_state = 37, .external_lex_state = 15},
  [1460] = {.lex_state = 37, .external_lex_state = 15},
  [1461] = {.lex_state = 37, .external_lex_state = 15},
  [1462] = {.lex_state = 37, .external_lex_state = 15},
  [1463] = {.lex_state = 38, .external_lex_state = 12},
  [1464] = {.lex_state = 37, .external_lex_state = 15},
  [1465] = {.lex_state = 37, .external_lex_state = 15},
  [1466] = {.lex_state = 38, .external_lex_state = 12},
  [1467] = {.lex_state = 38, .external_lex_state = 12},
  [1468] = {.lex_state = 37, .external_lex_state = 15},
  [1469] = {.lex_state = 37, .external_lex_state = 15},
  [1470] = {.lex_state = 37, .external_lex_state = 15},
  [1471] = {.lex_state = 37, .external_lex_state = 15},
  [1472] = {.lex_state = 37, .external_lex_state = 15},
  [1473] = {.lex_state = 37, .external_lex_state = 15},
  [1474] = {.lex_state = 38, .external_lex_state = 14},
  [1475] = {.lex_state = 37, .external_lex_state = 15},
  [1476] = {.lex_state = 38, .external_lex_state = 14},
  [1477] = {.lex_state = 37, .external_lex_state = 15},
  [1478] = {.lex_state = 37, .external_lex_state = 15},
  [1479] = {.lex_state = 37, .external_lex_state = 15},
  [1480] = {.lex_state = 37, .external_lex_state = 15},
  [1481] = {.lex_state = 37, .external_lex_state = 15},
  [1482] = {.lex_state = 37, .external_lex_state = 15},
  [1483] = {.lex_state = 37, .external_lex_state = 15},
  [1484] = {.lex_state = 37, .external_lex_state = 15},
  [1485] = {.lex_state = 37, .external_lex_state = 15},
  [1486] = {.lex_state = 37, .external_lex_state = 15},
  [1487] = {.lex_state = 37, .external_lex_state = 15},
  [1488] = {.lex_state = 37, .external_lex_state = 15},
  [1489] = {.lex_state = 37, .external_lex_state = 15},
  [1490] = {.lex_state = 37, .external_lex_state = 15},
  [1491] = {.lex_state = 37, .external_lex_state = 15},
  [1492] = {.lex_state = 37, .external_lex_state = 15},
  [1493] = {.lex_state = 38, .external_lex_state = 15},
  [1494] = {.lex_state = 38, .external_lex_state = 15},
  [1495] = {.lex_state = 38, .external_lex_state = 15},
  [1496] = {.lex_state = 37, .external_lex_state = 15},
  [1497] = {.lex_state = 33, .external_lex_state = 13},
  [1498] = {.lex_state = 33, .external_lex_state = 13},
  [1499] = {.lex_state = 33, .external_lex_state = 13},
  [1500] = {.lex_state = 33, .external_lex_state = 13},
  [1501] = {.lex_state = 33, .external_lex_state = 13},
  [1502] = {.lex_state = 33, .external_lex_state = 13},
  [1503] = {.lex_state = 33, .external_lex_state = 13},
  [1504] = {.lex_state = 33, .external_lex_state = 13},
  [1505] = {.lex_state = 33, .external_lex_state = 13},
  [1506] = {.lex_state = 33, .external_lex_state = 13},
  [1507] = {.lex_state = 33, .external_lex_state = 13},
  [1508] = {.lex_state = 33, .external_lex_state = 13},
  [1509] = {.lex_state = 33, .external_lex_state = 13},
  [1510] = {.lex_state = 33, .external_lex_state = 13},
  [1511] = {.lex_state = 33, .external_lex_state = 13},
  [1512] = {.lex_state = 33, .external_lex_state = 13},
  [1513] = {.lex_state = 37, .external_lex_state = 14},
  [1514] = {.lex_state = 37, .external_lex_state = 15},
  [1515] = {.lex_state = 37, .external_lex_state = 12},
  [1516] = {.lex_state = 36, .external_lex_state = 2},
  [1517] = {.lex_state = 36, .external_lex_state = 2},
  [1518] = {.lex_state = 30, .external_lex_state = 7},
  [1519] = {.lex_state = 30, .external_lex_state = 7},
  [1520] = {.lex_state = 30, .external_lex_state = 7},
  [1521] = {.lex_state = 30, .external_lex_state = 7},
  [1522] = {.lex_state = 30, .external_lex_state = 7},
  [1523] = {.lex_state = 30, .external_lex_state = 7},
  [1524] = {.lex_state = 30, .external_lex_state = 8},
  [1525] = {.lex_state = 30, .external_lex_state = 7},
  [1526] = {.lex_state = 30, .external_lex_state = 7},
  [1527] = {.lex_state = 30, .external_lex_state = 8},
  [1528] = {.lex_state = 30, .external_lex_state = 8},
  [1529] = {.lex_state = 30, .external_lex_state = 7},
  [1530] = {.lex_state = 30, .external_lex_state = 8},
  [1531] = {.lex_state = 30, .external_lex_state = 8},
  [1532] = {.lex_state = 30, .external_lex_state = 7},
  [1533] = {.lex_state = 30, .external_lex_state = 8},
  [1534] = {.lex_state = 30, .external_lex_state = 7},
  [1535] = {.lex_state = 30, .external_lex_state = 7},
  [1536] = {.lex_state = 30, .external_lex_state = 8},
  [1537] = {.lex_state = 30, .external_lex_state = 7},
  [1538] = {.lex_state = 30, .external_lex_state = 8},
  [1539] = {.lex_state = 30, .external_lex_state = 7},
  [1540] = {.lex_state = 30, .external_lex_state = 8},
  [1541] = {.lex_state = 30, .external_lex_state = 7},
  [1542] = {.lex_state = 30, .external_lex_state = 7},
  [1543] = {.lex_state = 30, .external_lex_state = 8},
  [1544] = {.lex_state = 30, .external_lex_state = 8},
  [1545] = {.lex_state = 30, .external_lex_state = 7},
  [1546] = {.lex_state = 30, .external_lex_state = 7},
  [1547] = {.lex_state = 30, .external_lex_state = 7},
  [1548] = {.lex_state = 30, .external_lex_state = 7},
  [1549] = {.lex_state = 30, .external_lex_state = 7},
  [1550] = {.lex_state = 30, .external_lex_state = 7},
  [1551] = {.lex_state = 30, .external_lex_state = 8},
  [1552] = {.lex_state = 30, .external_lex_state = 7},
  [1553] = {.lex_state = 30, .external_lex_state = 7},
  [1554] = {.lex_state = 30, .external_lex_state = 2},
  [1555] = {.lex_state = 30, .external_lex_state = 2},
  [1556] = {.lex_state = 30, .external_lex_state = 2},
  [1557] = {.lex_state = 30, .external_lex_state = 2},
  [1558] = {.lex_state = 30, .external_lex_state = 2},
  [1559] = {.lex_state = 30, .external_lex_state = 6},
  [1560] = {.lex_state = 30, .external_lex_state = 6},
  [1561] = {.lex_state = 30, .external_lex_state = 6},
  [1562] = {.lex_state = 30, .external_lex_state = 6},
  [1563] = {.lex_state = 30, .external_lex_state = 6},
  [1564] = {.lex_state = 30, .external_lex_state = 6},
  [1565] = {.lex_state = 30, .external_lex_state = 6},
  [1566] = {.lex_state = 30, .external_lex_state = 6},
  [1567] = {.lex_state = 30, .external_lex_state = 6},
  [1568] = {.lex_state = 30, .external_lex_state = 6},
  [1569] = {.lex_state = 30, .external_lex_state = 6},
  [1570] = {.lex_state = 30, .external_lex_state = 6},
  [1571] = {.lex_state = 30, .external_lex_state = 6},
  [1572] = {.lex_state = 30, .external_lex_state = 6},
  [1573] = {.lex_state = 30, .external_lex_state = 6},
  [1574] = {.lex_state = 30, .external_lex_state = 6},
  [1575] = {.lex_state = 30, .external_lex_state = 6},
  [1576] = {.lex_state = 30, .external_lex_state = 6},
  [1577] = {.lex_state = 30, .external_lex_state = 6},
  [1578] = {.lex_state = 30, .external_lex_state = 6},
  [1579] = {.lex_state = 30, .external_lex_state = 2},
  [1580] = {.lex_state = 30, .external_lex_state = 2},
  [1581] = {.lex_state = 30, .external_lex_state = 2},
  [1582] = {.lex_state = 30, .external_lex_state = 2},
  [1583] = {.lex_state = 30, .external_lex_state = 2},
  [1584] = {.lex_state = 30, .external_lex_state = 2},
  [1585] = {.lex_state = 30, .external_lex_state = 2},
  [1586] = {.lex_state = 30, .external_lex_state = 2},
  [1587] = {.lex_state = 30, .external_lex_state = 2},
  [1588] = {.lex_state = 33, .external_lex_state = 9},
  [1589] = {.lex_state = 33, .external_lex_state = 9},
  [1590] = {.lex_state = 37, .external_lex_state = 12},
  [1591] = {.lex_state = 37, .external_lex_state = 12},
  [1592] = {.lex_state = 37, .external_lex_state = 12},
  [1593] = {.lex_state = 33, .external_lex_state = 13},
  [1594] = {.lex_state = 37, .external_lex_state = 12},
  [1595] = {.lex_state = 33, .external_lex_state = 13},
  [1596] = {.lex_state = 33, .external_lex_state = 14},
  [1597] = {.lex_state = 33, .external_lex_state = 14},
  [1598] = {.lex_state = 37, .external_lex_state = 12},
  [1599] = {.lex_state = 37, .external_lex_state = 12},
  [1600] = {.lex_state = 33, .external_lex_state = 15},
  [1601] = {.lex_state = 54, .external_lex_state = 12},
  [1602] = {.lex_state = 54, .external_lex_state = 12},
  [1603] = {.lex_state = 54, .external_lex_state = 12},
  [1604] = {.lex_state = 33, .external_lex_state = 15},
  [1605] = {.lex_state = 54, .external_lex_state = 12},
  [1606] = {.lex_state = 37, .external_lex_state = 14},
  [1607] = {.lex_state = 37, .external_lex_state = 14},
  [1608] = {.lex_state = 37, .external_lex_state = 14},
  [1609] = {.lex_state = 37, .external_lex_state = 14},
  [1610] = {.lex_state = 54, .external_lex_state = 14},
  [1611] = {.lex_state = 35, .external_lex_state = 9},
  [1612] = {.lex_state = 37, .external_lex_state = 14},
  [1613] = {.lex_state = 54, .external_lex_state = 14},
  [1614] = {.lex_state = 54, .external_lex_state = 15},
  [1615] = {.lex_state = 35, .external_lex_state = 9},
  [1616] = {.lex_state = 37, .external_lex_state = 14},
  [1617] = {.lex_state = 54, .external_lex_state = 15},
  [1618] = {.lex_state = 37, .external_lex_state = 13},
  [1619] = {.lex_state = 37, .external_lex_state = 13},
  [1620] = {.lex_state = 37, .external_lex_state = 13},
  [1621] = {.lex_state = 37, .external_lex_state = 13},
  [1622] = {.lex_state = 37, .external_lex_state = 15},
  [1623] = {.lex_state = 37, .external_lex_state = 13},
  [1624] = {.lex_state = 37, .external_lex_state = 13},
  [1625] = {.lex_state = 37, .external_lex_state = 13},
  [1626] = {.lex_state = 37, .external_lex_state = 14},
  [1627] = {.lex_state = 37, .external_lex_state = 14},
  [1628] = {.lex_state = 35, .external_lex_state = 9},
  [1629] = {.lex_state = 37, .external_lex_state = 15},
  [1630] = {.lex_state = 37, .external_lex_state = 15},
  [1631] = {.lex_state = 37, .external_lex_state = 13},
  [1632] = {.lex_state = 37, .external_lex_state = 15},
  [1633] = {.lex_state = 37, .external_lex_state = 13},
  [1634] = {.lex_state = 37, .external_lex_state = 15},
  [1635] = {.lex_state = 35, .external_lex_state = 9},
  [1636] = {.lex_state = 37, .external_lex_state = 13},
  [1637] = {.lex_state = 37, .external_lex_state = 13},
  [1638] = {.lex_state = 37, .external_lex_state = 14},
  [1639] = {.lex_state = 37, .external_lex_state = 13},
  [1640] = {.lex_state = 37, .external_lex_state = 13},
  [1641] = {.lex_state = 37, .external_lex_state = 13},
  [1642] = {.lex_state = 37, .external_lex_state = 14},
  [1643] = {.lex_state = 37, .external_lex_state = 15},
  [1644] = {.lex_state = 37, .external_lex_state = 13},
  [1645] = {.lex_state = 37, .external_lex_state = 14},
  [1646] = {.lex_state = 37, .external_lex_state = 13},
  [1647] = {.lex_state = 37, .external_lex_state = 13},
  [1648] = {.lex_state = 37, .external_lex_state = 13},
  [1649] = {.lex_state = 35, .external_lex_state = 9},
  [1650] = {.lex_state = 37, .external_lex_state = 13},
  [1651] = {.lex_state = 37, .external_lex_state = 13},
  [1652] = {.lex_state = 37, .external_lex_state = 13},
  [1653] = {.lex_state = 35, .external_lex_state = 9},
  [1654] = {.lex_state = 37, .external_lex_state = 13},
  [1655] = {.lex_state = 37, .external_lex_state = 14},
  [1656] = {.lex_state = 36, .external_lex_state = 13},
  [1657] = {.lex_state = 36, .external_lex_state = 13},
  [1658] = {.lex_state = 36, .external_lex_state = 13},
  [1659] = {.lex_state = 36, .external_lex_state = 13},
  [1660] = {.lex_state = 36, .external_lex_state = 13},
  [1661] = {.lex_state = 35, .external_lex_state = 13},
  [1662] = {.lex_state = 36, .external_lex_state = 13},
  [1663] = {.lex_state = 36, .external_lex_state = 13},
  [1664] = {.lex_state = 35, .external_lex_state = 13},
  [1665] = {.lex_state = 36, .external_lex_state = 13},
  [1666] = {.lex_state = 35, .external_lex_state = 9},
  [1667] = {.lex_state = 36, .external_lex_state = 13},
  [1668] = {.lex_state = 35, .external_lex_state = 13},
  [1669] = {.lex_state = 36, .external_lex_state = 13},
  [1670] = {.lex_state = 35, .external_lex_state = 13},
  [1671] = {.lex_state = 35, .external_lex_state = 13},
  [1672] = {.lex_state = 35, .external_lex_state = 13},
  [1673] = {.lex_state = 35, .external_lex_state = 13},
  [1674] = {.lex_state = 36, .external_lex_state = 13},
  [1675] = {.lex_state = 35, .external_lex_state = 13},
  [1676] = {.lex_state = 30, .external_lex_state = 14},
  [1677] = {.lex_state = 36, .external_lex_state = 13},
  [1678] = {.lex_state = 30, .external_lex_state = 14},
  [1679] = {.lex_state = 35, .external_lex_state = 13},
  [1680] = {.lex_state = 36, .external_lex_state = 13},
  [1681] = {.lex_state = 30, .external_lex_state = 14},
  [1682] = {.lex_state = 30, .external_lex_state = 13},
  [1683] = {.lex_state = 30, .external_lex_state = 13},
  [1684] = {.lex_state = 54, .external_lex_state = 12},
  [1685] = {.lex_state = 33, .external_lex_state = 9},
  [1686] = {.lex_state = 54, .external_lex_state = 12},
  [1687] = {.lex_state = 33, .external_lex_state = 9},
  [1688] = {.lex_state = 33, .external_lex_state = 9},
  [1689] = {.lex_state = 33, .external_lex_state = 9},
  [1690] = {.lex_state = 54, .external_lex_state = 12},
  [1691] = {.lex_state = 54, .external_lex_state = 12},
  [1692] = {.lex_state = 33, .external_lex_state = 9},
  [1693] = {.lex_state = 33, .external_lex_state = 9},
  [1694] = {.lex_state = 54, .external_lex_state = 12},
  [1695] = {.lex_state = 54, .external_lex_state = 12},
  [1696] = {.lex_state = 33, .external_lex_state = 9},
  [1697] = {.lex_state = 33, .external_lex_state = 9},
  [1698] = {.lex_state = 54, .external_lex_state = 12},
  [1699] = {.lex_state = 33, .external_lex_state = 9},
  [1700] = {.lex_state = 54, .external_lex_state = 12},
  [1701] = {.lex_state = 54, .external_lex_state = 15},
  [1702] = {.lex_state = 54, .external_lex_state = 15},
  [1703] = {.lex_state = 54, .external_lex_state = 15},
  [1704] = {.lex_state = 54, .external_lex_state = 14},
  [1705] = {.lex_state = 54, .external_lex_state = 14},
  [1706] = {.lex_state = 54, .external_lex_state = 14},
  [1707] = {.lex_state = 54, .external_lex_state = 14},
  [1708] = {.lex_state = 54, .external_lex_state = 14},
  [1709] = {.lex_state = 33, .external_lex_state = 9},
  [1710] = {.lex_state = 54, .external_lex_state = 15},
  [1711] = {.lex_state = 54, .external_lex_state = 14},
  [1712] = {.lex_state = 54, .external_lex_state = 14},
  [1713] = {.lex_state = 54, .external_lex_state = 14},
  [1714] = {.lex_state = 54, .external_lex_state = 15},
  [1715] = {.lex_state = 54, .external_lex_state = 15},
  [1716] = {.lex_state = 54, .external_lex_state = 14},
  [1717] = {.lex_state = 54, .external_lex_state = 14},
  [1718] = {.lex_state = 54, .external_lex_state = 14},
  [1719] = {.lex_state = 54, .external_lex_state = 14},
  [1720] = {.lex_state = 54, .external_lex_state = 14},
  [1721] = {.lex_state = 54, .external_lex_state = 14},
  [1722] = {.lex_state = 54, .external_lex_state = 14},
  [1723] = {.lex_state = 54, .external_lex_state = 15},
  [1724] = {.lex_state = 54, .external_lex_state = 14},
  [1725] = {.lex_state = 54, .external_lex_state = 15},
  [1726] = {.lex_state = 54, .external_lex_state = 14},
  [1727] = {.lex_state = 0, .external_lex_state = 16},
  [1728] = {.lex_state = 0, .external_lex_state = 16},
  [1729] = {.lex_state = 33, .external_lex_state = 14},
  [1730] = {.lex_state = 0, .external_lex_state = 16},
  [1731] = {.lex_state = 0, .external_lex_state = 16},
  [1732] = {.lex_state = 54, .external_lex_state = 12},
  [1733] = {.lex_state = 0, .external_lex_state = 16},
  [1734] = {.lex_state = 33, .external_lex_state = 14},
  [1735] = {.lex_state = 33, .external_lex_state = 14},
  [1736] = {.lex_state = 0, .external_lex_state = 16},
  [1737] = {.lex_state = 33, .external_lex_state = 14},
  [1738] = {.lex_state = 33, .external_lex_state = 14},
  [1739] = {.lex_state = 0, .external_lex_state = 16},
  [1740] = {.lex_state = 33, .external_lex_state = 13},
  [1741] = {.lex_state = 33, .external_lex_state = 13},
  [1742] = {.lex_state = 0, .external_lex_state = 16},
  [1743] = {.lex_state = 0, .external_lex_state = 16},
  [1744] = {.lex_state = 33, .external_lex_state = 13},
  [1745] = {.lex_state = 33, .external_lex_state = 14},
  [1746] = {.lex_state = 33, .external_lex_state = 13},
  [1747] = {.lex_state = 0, .external_lex_state = 16},
  [1748] = {.lex_state = 33, .external_lex_state = 13},
  [1749] = {.lex_state = 33, .external_lex_state = 13},
  [1750] = {.lex_state = 33, .external_lex_state = 13},
  [1751] = {.lex_state = 33, .external_lex_state = 14},
  [1752] = {.lex_state = 54, .external_lex_state = 12},
  [1753] = {.lex_state = 33, .external_lex_state = 9},
  [1754] = {.lex_state = 33, .external_lex_state = 14},
  [1755] = {.lex_state = 33, .external_lex_state = 14},
  [1756] = {.lex_state = 0, .external_lex_state = 16},
  [1757] = {.lex_state = 0, .external_lex_state = 16},
  [1758] = {.lex_state = 33, .external_lex_state = 13},
  [1759] = {.lex_state = 0, .external_lex_state = 16},
  [1760] = {.lex_state = 33, .external_lex_state = 14},
  [1761] = {.lex_state = 0, .external_lex_state = 16},
  [1762] = {.lex_state = 33, .external_lex_state = 13},
  [1763] = {.lex_state = 0, .external_lex_state = 16},
  [1764] = {.lex_state = 0, .external_lex_state = 16},
  [1765] = {.lex_state = 0, .external_lex_state = 16},
  [1766] = {.lex_state = 0, .external_lex_state = 16},
  [1767] = {.lex_state = 0, .external_lex_state = 16},
  [1768] = {.lex_state = 54, .external_lex_state = 12},
  [1769] = {.lex_state = 33, .external_lex_state = 15},
  [1770] = {.lex_state = 54, .external_lex_state = 12},
  [1771] = {.lex_state = 54, .external_lex_state = 12},
  [1772] = {.lex_state = 54, .external_lex_state = 12},
  [1773] = {.lex_state = 54, .external_lex_state = 12},
  [1774] = {.lex_state = 54, .external_lex_state = 12},
  [1775] = {.lex_state = 54, .external_lex_state = 12},
  [1776] = {.lex_state = 54, .external_lex_state = 12},
  [1777] = {.lex_state = 54, .external_lex_state = 12},
  [1778] = {.lex_state = 54, .external_lex_state = 12},
  [1779] = {.lex_state = 33, .external_lex_state = 13},
  [1780] = {.lex_state = 54, .external_lex_state = 12},
  [1781] = {.lex_state = 54, .external_lex_state = 12},
  [1782] = {.lex_state = 33, .external_lex_state = 15},
  [1783] = {.lex_state = 54, .external_lex_state = 12},
  [1784] = {.lex_state = 33, .external_lex_state = 15},
  [1785] = {.lex_state = 54, .external_lex_state = 12},
  [1786] = {.lex_state = 33, .external_lex_state = 15},
  [1787] = {.lex_state = 33, .external_lex_state = 15},
  [1788] = {.lex_state = 54, .external_lex_state = 12},
  [1789] = {.lex_state = 54, .external_lex_state = 12},
  [1790] = {.lex_state = 33, .external_lex_state = 13},
  [1791] = {.lex_state = 33, .external_lex_state = 15},
  [1792] = {.lex_state = 54, .external_lex_state = 9},
  [1793] = {.lex_state = 33, .external_lex_state = 15},
  [1794] = {.lex_state = 33, .external_lex_state = 15},
  [1795] = {.lex_state = 33, .external_lex_state = 15},
  [1796] = {.lex_state = 33, .external_lex_state = 13},
  [1797] = {.lex_state = 54, .external_lex_state = 12},
  [1798] = {.lex_state = 33, .external_lex_state = 13},
  [1799] = {.lex_state = 54, .external_lex_state = 12},
  [1800] = {.lex_state = 54, .external_lex_state = 12},
  [1801] = {.lex_state = 54, .external_lex_state = 12},
  [1802] = {.lex_state = 33, .external_lex_state = 15},
  [1803] = {.lex_state = 33, .external_lex_state = 13},
  [1804] = {.lex_state = 54, .external_lex_state = 15},
  [1805] = {.lex_state = 54, .external_lex_state = 14},
  [1806] = {.lex_state = 54, .external_lex_state = 12},
  [1807] = {.lex_state = 54, .external_lex_state = 15},
  [1808] = {.lex_state = 54, .external_lex_state = 9},
  [1809] = {.lex_state = 54, .external_lex_state = 15},
  [1810] = {.lex_state = 54, .external_lex_state = 14},
  [1811] = {.lex_state = 54, .external_lex_state = 14},
  [1812] = {.lex_state = 54, .external_lex_state = 2},
  [1813] = {.lex_state = 34, .external_lex_state = 17},
  [1814] = {.lex_state = 54, .external_lex_state = 14},
  [1815] = {.lex_state = 54, .external_lex_state = 15},
  [1816] = {.lex_state = 54, .external_lex_state = 14},
  [1817] = {.lex_state = 54, .external_lex_state = 12},
  [1818] = {.lex_state = 54, .external_lex_state = 15},
  [1819] = {.lex_state = 54, .external_lex_state = 15},
  [1820] = {.lex_state = 54, .external_lex_state = 9},
  [1821] = {.lex_state = 32, .external_lex_state = 14},
  [1822] = {.lex_state = 54, .external_lex_state = 14},
  [1823] = {.lex_state = 54, .external_lex_state = 14},
  [1824] = {.lex_state = 54, .external_lex_state = 13},
  [1825] = {.lex_state = 54, .external_lex_state = 12},
  [1826] = {.lex_state = 54, .external_lex_state = 14},
  [1827] = {.lex_state = 54, .external_lex_state = 15},
  [1828] = {.lex_state = 54, .external_lex_state = 13},
  [1829] = {.lex_state = 54, .external_lex_state = 9},
  [1830] = {.lex_state = 34, .external_lex_state = 17},
  [1831] = {.lex_state = 54, .external_lex_state = 15},
  [1832] = {.lex_state = 54, .external_lex_state = 14},
  [1833] = {.lex_state = 34, .external_lex_state = 17},
  [1834] = {.lex_state = 54, .external_lex_state = 15},
  [1835] = {.lex_state = 54, .external_lex_state = 15},
  [1836] = {.lex_state = 33, .external_lex_state = 13},
  [1837] = {.lex_state = 54, .external_lex_state = 14},
  [1838] = {.lex_state = 54, .external_lex_state = 15},
  [1839] = {.lex_state = 54, .external_lex_state = 15},
  [1840] = {.lex_state = 32, .external_lex_state = 15},
  [1841] = {.lex_state = 34, .external_lex_state = 17},
  [1842] = {.lex_state = 32, .external_lex_state = 12},
  [1843] = {.lex_state = 54, .external_lex_state = 14},
  [1844] = {.lex_state = 54, .external_lex_state = 14},
  [1845] = {.lex_state = 54, .external_lex_state = 12},
  [1846] = {.lex_state = 54, .external_lex_state = 15},
  [1847] = {.lex_state = 54, .external_lex_state = 15},
  [1848] = {.lex_state = 54, .external_lex_state = 15},
  [1849] = {.lex_state = 54, .external_lex_state = 9},
  [1850] = {.lex_state = 54, .external_lex_state = 9},
  [1851] = {.lex_state = 54, .external_lex_state = 15},
  [1852] = {.lex_state = 54, .external_lex_state = 15},
  [1853] = {.lex_state = 54, .external_lex_state = 9},
  [1854] = {.lex_state = 54, .external_lex_state = 15},
  [1855] = {.lex_state = 54, .external_lex_state = 15},
  [1856] = {.lex_state = 54, .external_lex_state = 15},
  [1857] = {.lex_state = 54, .external_lex_state = 15},
  [1858] = {.lex_state = 54, .external_lex_state = 9},
  [1859] = {.lex_state = 54, .external_lex_state = 9},
  [1860] = {.lex_state = 54, .external_lex_state = 15},
  [1861] = {.lex_state = 54, .external_lex_state = 9},
  [1862] = {.lex_state = 54, .external_lex_state = 12},
  [1863] = {.lex_state = 32, .external_lex_state = 14},
  [1864] = {.lex_state = 54, .external_lex_state = 12},
  [1865] = {.lex_state = 32, .external_lex_state = 12},
  [1866] = {.lex_state = 32, .external_lex_state = 15},
  [1867] = {.lex_state = 54, .external_lex_state = 15},
  [1868] = {.lex_state = 54, .external_lex_state = 12},
  [1869] = {.lex_state = 54, .external_lex_state = 14},
  [1870] = {.lex_state = 54, .external_lex_state = 12},
  [1871] = {.lex_state = 54, .external_lex_state = 13},
  [1872] = {.lex_state = 54, .external_lex_state = 9},
  [1873] = {.lex_state = 54, .external_lex_state = 14},
  [1874] = {.lex_state = 54, .external_lex_state = 13},
  [1875] = {.lex_state = 54, .external_lex_state = 15},
  [1876] = {.lex_state = 54, .external_lex_state = 12},
  [1877] = {.lex_state = 32, .external_lex_state = 12},
  [1878] = {.lex_state = 54, .external_lex_state = 13},
  [1879] = {.lex_state = 54, .external_lex_state = 13},
  [1880] = {.lex_state = 54, .external_lex_state = 15},
  [1881] = {.lex_state = 54, .external_lex_state = 13},
  [1882] = {.lex_state = 54, .external_lex_state = 14},
  [1883] = {.lex_state = 0, .external_lex_state = 16},
  [1884] = {.lex_state = 54, .external_lex_state = 13},
  [1885] = {.lex_state = 54, .external_lex_state = 13},
  [1886] = {.lex_state = 54, .external_lex_state = 12},
  [1887] = {.lex_state = 54, .external_lex_state = 8},
  [1888] = {.lex_state = 32, .external_lex_state = 14},
  [1889] = {.lex_state = 32, .external_lex_state = 15},
  [1890] = {.lex_state = 54, .external_lex_state = 12},
  [1891] = {.lex_state = 54, .external_lex_state = 12},
  [1892] = {.lex_state = 54, .external_lex_state = 12},
  [1893] = {.lex_state = 54, .external_lex_state = 15},
  [1894] = {.lex_state = 54, .external_lex_state = 14},
  [1895] = {.lex_state = 54, .external_lex_state = 6},
  [1896] = {.lex_state = 54, .external_lex_state = 12},
  [1897] = {.lex_state = 54, .external_lex_state = 15},
  [1898] = {.lex_state = 54, .external_lex_state = 7},
  [1899] = {.lex_state = 54, .external_lex_state = 9},
  [1900] = {.lex_state = 32, .external_lex_state = 15},
  [1901] = {.lex_state = 32, .external_lex_state = 12},
  [1902] = {.lex_state = 54, .external_lex_state = 14},
  [1903] = {.lex_state = 54, .external_lex_state = 15},
  [1904] = {.lex_state = 54, .external_lex_state = 14},
  [1905] = {.lex_state = 54, .external_lex_state = 12},
  [1906] = {.lex_state = 32, .external_lex_state = 13},
  [1907] = {.lex_state = 54, .external_lex_state = 13},
  [1908] = {.lex_state = 54, .external_lex_state = 13},
  [1909] = {.lex_state = 54, .external_lex_state = 12},
  [1910] = {.lex_state = 0, .external_lex_state = 16},
  [1911] = {.lex_state = 54, .external_lex_state = 15},
  [1912] = {.lex_state = 54, .external_lex_state = 15},
  [1913] = {.lex_state = 32, .external_lex_state = 14},
  [1914] = {.lex_state = 32, .external_lex_state = 9},
  [1915] = {.lex_state = 0, .external_lex_state = 16},
  [1916] = {.lex_state = 0, .external_lex_state = 16},
  [1917] = {.lex_state = 54, .external_lex_state = 13},
  [1918] = {.lex_state = 0, .external_lex_state = 16},
  [1919] = {.lex_state = 0, .external_lex_state = 16},
  [1920] = {.lex_state = 54, .external_lex_state = 14},
  [1921] = {.lex_state = 54, .external_lex_state = 12},
  [1922] = {.lex_state = 54, .external_lex_state = 14},
  [1923] = {.lex_state = 54, .external_lex_state = 13},
  [1924] = {.lex_state = 54, .external_lex_state = 15},
  [1925] = {.lex_state = 33, .external_lex_state = 15},
  [1926] = {.lex_state = 54, .external_lex_state = 14},
  [1927] = {.lex_state = 33, .external_lex_state = 13},
  [1928] = {.lex_state = 33, .external_lex_state = 15},
  [1929] = {.lex_state = 33, .external_lex_state = 14},
  [1930] = {.lex_state = 54, .external_lex_state = 12},
  [1931] = {.lex_state = 0, .external_lex_state = 16},
  [1932] = {.lex_state = 54, .external_lex_state = 12},
  [1933] = {.lex_state = 0, .external_lex_state = 16},
  [1934] = {.lex_state = 33, .external_lex_state = 14},
  [1935] = {.lex_state = 54, .external_lex_state = 13},
  [1936] = {.lex_state = 54, .external_lex_state = 9},
  [1937] = {.lex_state = 33, .external_lex_state = 14},
  [1938] = {.lex_state = 54, .external_lex_state = 13},
  [1939] = {.lex_state = 33, .external_lex_state = 15},
  [1940] = {.lex_state = 54, .external_lex_state = 14},
  [1941] = {.lex_state = 54, .external_lex_state = 15},
  [1942] = {.lex_state = 54, .external_lex_state = 15},
  [1943] = {.lex_state = 54, .external_lex_state = 15},
  [1944] = {.lex_state = 54, .external_lex_state = 14},
  [1945] = {.lex_state = 54, .external_lex_state = 14},
  [1946] = {.lex_state = 54, .external_lex_state = 14},
  [1947] = {.lex_state = 54, .external_lex_state = 15},
  [1948] = {.lex_state = 33, .external_lex_state = 9},
  [1949] = {.lex_state = 32, .external_lex_state = 14},
  [1950] = {.lex_state = 54, .external_lex_state = 13},
  [1951] = {.lex_state = 54, .external_lex_state = 12},
  [1952] = {.lex_state = 54, .external_lex_state = 14},
  [1953] = {.lex_state = 54, .external_lex_state = 12},
  [1954] = {.lex_state = 54, .external_lex_state = 12},
  [1955] = {.lex_state = 54, .external_lex_state = 13},
  [1956] = {.lex_state = 33, .external_lex_state = 9},
  [1957] = {.lex_state = 33, .external_lex_state = 14},
  [1958] = {.lex_state = 54, .external_lex_state = 13},
  [1959] = {.lex_state = 33, .external_lex_state = 9},
  [1960] = {.lex_state = 54, .external_lex_state = 9},
  [1961] = {.lex_state = 54, .external_lex_state = 13},
  [1962] = {.lex_state = 54, .external_lex_state = 14},
  [1963] = {.lex_state = 33, .external_lex_state = 14},
  [1964] = {.lex_state = 33, .external_lex_state = 14},
  [1965] = {.lex_state = 33, .external_lex_state = 14},
  [1966] = {.lex_state = 54, .external_lex_state = 14},
  [1967] = {.lex_state = 54, .external_lex_state = 15},
  [1968] = {.lex_state = 33, .external_lex_state = 9},
  [1969] = {.lex_state = 54, .external_lex_state = 13},
  [1970] = {.lex_state = 32, .external_lex_state = 15},
  [1971] = {.lex_state = 33, .external_lex_state = 9},
  [1972] = {.lex_state = 32, .external_lex_state = 12},
  [1973] = {.lex_state = 54, .external_lex_state = 14},
  [1974] = {.lex_state = 54, .external_lex_state = 14},
  [1975] = {.lex_state = 54, .external_lex_state = 14},
  [1976] = {.lex_state = 54, .external_lex_state = 15},
  [1977] = {.lex_state = 54, .external_lex_state = 12},
  [1978] = {.lex_state = 0, .external_lex_state = 16},
  [1979] = {.lex_state = 54, .external_lex_state = 15},
  [1980] = {.lex_state = 54, .external_lex_state = 15},
  [1981] = {.lex_state = 54, .external_lex_state = 12},
  [1982] = {.lex_state = 54, .external_lex_state = 12},
  [1983] = {.lex_state = 54, .external_lex_state = 14},
  [1984] = {.lex_state = 54, .external_lex_state = 9},
  [1985] = {.lex_state = 54, .external_lex_state = 14},
  [1986] = {.lex_state = 54, .external_lex_state = 15},
  [1987] = {.lex_state = 33, .external_lex_state = 14},
  [1988] = {.lex_state = 33, .external_lex_state = 14},
  [1989] = {.lex_state = 54, .external_lex_state = 15},
  [1990] = {.lex_state = 54, .external_lex_state = 14},
  [1991] = {.lex_state = 32, .external_lex_state = 9},
  [1992] = {.lex_state = 33, .external_lex_state = 15},
  [1993] = {.lex_state = 54, .external_lex_state = 13},
  [1994] = {.lex_state = 54, .external_lex_state = 13},
  [1995] = {.lex_state = 33, .external_lex_state = 9},
  [1996] = {.lex_state = 54, .external_lex_state = 12},
  [1997] = {.lex_state = 33, .external_lex_state = 9},
  [1998] = {.lex_state = 54, .external_lex_state = 12},
  [1999] = {.lex_state = 54, .external_lex_state = 15},
  [2000] = {.lex_state = 0, .external_lex_state = 16},
  [2001] = {.lex_state = 33, .external_lex_state = 9},
  [2002] = {.lex_state = 32, .external_lex_state = 9},
  [2003] = {.lex_state = 33, .external_lex_state = 13},
  [2004] = {.lex_state = 33, .external_lex_state = 9},
  [2005] = {.lex_state = 54, .external_lex_state = 15},
  [2006] = {.lex_state = 54, .external_lex_state = 12},
  [2007] = {.lex_state = 33, .external_lex_state = 14},
  [2008] = {.lex_state = 54, .external_lex_state = 13},
  [2009] = {.lex_state = 54, .external_lex_state = 14},
  [2010] = {.lex_state = 54, .external_lex_state = 13},
  [2011] = {.lex_state = 54, .external_lex_state = 14},
  [2012] = {.lex_state = 54, .external_lex_state = 12},
  [2013] = {.lex_state = 54, .external_lex_state = 13},
  [2014] = {.lex_state = 54, .external_lex_state = 12},
  [2015] = {.lex_state = 54, .external_lex_state = 15},
  [2016] = {.lex_state = 33, .external_lex_state = 9},
  [2017] = {.lex_state = 33, .external_lex_state = 13},
  [2018] = {.lex_state = 54, .external_lex_state = 12},
  [2019] = {.lex_state = 54, .external_lex_state = 13},
  [2020] = {.lex_state = 54, .external_lex_state = 13},
  [2021] = {.lex_state = 54, .external_lex_state = 13},
  [2022] = {.lex_state = 54, .external_lex_state = 13},
  [2023] = {.lex_state = 33, .external_lex_state = 13},
  [2024] = {.lex_state = 54, .external_lex_state = 12},
  [2025] = {.lex_state = 54, .external_lex_state = 13},
  [2026] = {.lex_state = 54, .external_lex_state = 12},
  [2027] = {.lex_state = 54, .external_lex_state = 15},
  [2028] = {.lex_state = 54, .external_lex_state = 15},
  [2029] = {.lex_state = 54, .external_lex_state = 9},
  [2030] = {.lex_state = 54, .external_lex_state = 13},
  [2031] = {.lex_state = 54, .external_lex_state = 13},
  [2032] = {.lex_state = 54, .external_lex_state = 12},
  [2033] = {.lex_state = 54, .external_lex_state = 12},
  [2034] = {.lex_state = 54, .external_lex_state = 12},
  [2035] = {.lex_state = 54, .external_lex_state = 14},
  [2036] = {.lex_state = 54, .external_lex_state = 12},
  [2037] = {.lex_state = 54, .external_lex_state = 13},
  [2038] = {.lex_state = 33, .external_lex_state = 15},
  [2039] = {.lex_state = 33, .external_lex_state = 15},
  [2040] = {.lex_state = 54, .external_lex_state = 12},
  [2041] = {.lex_state = 3, .external_lex_state = 12},
  [2042] = {.lex_state = 54, .external_lex_state = 12},
  [2043] = {.lex_state = 54, .external_lex_state = 12},
  [2044] = {.lex_state = 33, .external_lex_state = 15},
  [2045] = {.lex_state = 54, .external_lex_state = 13},
  [2046] = {.lex_state = 54, .external_lex_state = 13},
  [2047] = {.lex_state = 54, .external_lex_state = 14},
  [2048] = {.lex_state = 54, .external_lex_state = 15},
  [2049] = {.lex_state = 3, .external_lex_state = 12},
  [2050] = {.lex_state = 54, .external_lex_state = 9},
  [2051] = {.lex_state = 33, .external_lex_state = 13},
  [2052] = {.lex_state = 33, .external_lex_state = 13},
  [2053] = {.lex_state = 54, .external_lex_state = 12},
  [2054] = {.lex_state = 54, .external_lex_state = 13},
  [2055] = {.lex_state = 54, .external_lex_state = 12},
  [2056] = {.lex_state = 54, .external_lex_state = 13},
  [2057] = {.lex_state = 54, .external_lex_state = 13},
  [2058] = {.lex_state = 54, .external_lex_state = 12},
  [2059] = {.lex_state = 54, .external_lex_state = 12},
  [2060] = {.lex_state = 54, .external_lex_state = 13},
  [2061] = {.lex_state = 33, .external_lex_state = 15},
  [2062] = {.lex_state = 33, .external_lex_state = 15},
  [2063] = {.lex_state = 33, .external_lex_state = 13},
  [2064] = {.lex_state = 54, .external_lex_state = 13},
  [2065] = {.lex_state = 54, .external_lex_state = 12},
  [2066] = {.lex_state = 54, .external_lex_state = 13},
  [2067] = {.lex_state = 54, .external_lex_state = 13},
  [2068] = {.lex_state = 33, .external_lex_state = 13},
  [2069] = {.lex_state = 33, .external_lex_state = 15},
  [2070] = {.lex_state = 54, .external_lex_state = 12},
  [2071] = {.lex_state = 54, .external_lex_state = 13},
  [2072] = {.lex_state = 54, .external_lex_state = 13},
  [2073] = {.lex_state = 33, .external_lex_state = 15},
  [2074] = {.lex_state = 54, .external_lex_state = 9},
  [2075] = {.lex_state = 54, .external_lex_state = 14},
  [2076] = {.lex_state = 54, .external_lex_state = 14},
  [2077] = {.lex_state = 33, .external_lex_state = 15},
  [2078] = {.lex_state = 33, .external_lex_state = 14},
  [2079] = {.lex_state = 54, .external_lex_state = 13},
  [2080] = {.lex_state = 33, .external_lex_state = 9},
  [2081] = {.lex_state = 54, .external_lex_state = 9},
  [2082] = {.lex_state = 54, .external_lex_state = 13},
  [2083] = {.lex_state = 54, .external_lex_state = 13},
  [2084] = {.lex_state = 54, .external_lex_state = 13},
  [2085] = {.lex_state = 54, .external_lex_state = 12},
  [2086] = {.lex_state = 54, .external_lex_state = 9},
  [2087] = {.lex_state = 54, .external_lex_state = 9},
  [2088] = {.lex_state = 54, .external_lex_state = 13},
  [2089] = {.lex_state = 54, .external_lex_state = 13},
  [2090] = {.lex_state = 54, .external_lex_state = 13},
  [2091] = {.lex_state = 54, .external_lex_state = 13},
  [2092] = {.lex_state = 33, .external_lex_state = 13},
  [2093] = {.lex_state = 54, .external_lex_state = 13},
  [2094] = {.lex_state = 54, .external_lex_state = 13},
  [2095] = {.lex_state = 54, .external_lex_state = 13},
  [2096] = {.lex_state = 54, .external_lex_state = 13},
  [2097] = {.lex_state = 33, .external_lex_state = 15},
  [2098] = {.lex_state = 54, .external_lex_state = 12},
  [2099] = {.lex_state = 32, .external_lex_state = 9},
  [2100] = {.lex_state = 54, .external_lex_state = 13},
  [2101] = {.lex_state = 54, .external_lex_state = 12},
  [2102] = {.lex_state = 54, .external_lex_state = 9},
  [2103] = {.lex_state = 54, .external_lex_state = 13},
  [2104] = {.lex_state = 54, .external_lex_state = 13},
  [2105] = {.lex_state = 54, .external_lex_state = 13},
  [2106] = {.lex_state = 54, .external_lex_state = 15},
  [2107] = {.lex_state = 54, .external_lex_state = 13},
  [2108] = {.lex_state = 54, .external_lex_state = 13},
  [2109] = {.lex_state = 54, .external_lex_state = 12},
  [2110] = {.lex_state = 54, .external_lex_state = 14},
  [2111] = {.lex_state = 54, .external_lex_state = 14},
  [2112] = {.lex_state = 54, .external_lex_state = 14},
  [2113] = {.lex_state = 54, .external_lex_state = 13},
  [2114] = {.lex_state = 54, .external_lex_state = 13},
  [2115] = {.lex_state = 54, .external_lex_state = 15},
  [2116] = {.lex_state = 3, .external_lex_state = 12},
  [2117] = {.lex_state = 54, .external_lex_state = 13},
  [2118] = {.lex_state = 54, .external_lex_state = 14},
  [2119] = {.lex_state = 54, .external_lex_state = 13},
  [2120] = {.lex_state = 54, .external_lex_state = 13},
  [2121] = {.lex_state = 54, .external_lex_state = 13},
  [2122] = {.lex_state = 54, .external_lex_state = 15},
  [2123] = {.lex_state = 54, .external_lex_state = 13},
  [2124] = {.lex_state = 54, .external_lex_state = 13},
  [2125] = {.lex_state = 54, .external_lex_state = 13},
  [2126] = {.lex_state = 54, .external_lex_state = 13},
  [2127] = {.lex_state = 54, .external_lex_state = 12},
  [2128] = {.lex_state = 54, .external_lex_state = 13},
  [2129] = {.lex_state = 54, .external_lex_state = 15},
  [2130] = {.lex_state = 54, .external_lex_state = 12},
  [2131] = {.lex_state = 54, .external_lex_state = 14},
  [2132] = {.lex_state = 54, .external_lex_state = 13},
  [2133] = {.lex_state = 54, .external_lex_state = 15},
  [2134] = {.lex_state = 54, .external_lex_state = 13},
  [2135] = {.lex_state = 54, .external_lex_state = 15},
  [2136] = {.lex_state = 33, .external_lex_state = 15},
  [2137] = {.lex_state = 33, .external_lex_state = 13},
  [2138] = {.lex_state = 54, .external_lex_state = 13},
  [2139] = {.lex_state = 54, .external_lex_state = 18},
  [2140] = {.lex_state = 33, .external_lex_state = 13},
  [2141] = {.lex_state = 54, .external_lex_state = 9},
  [2142] = {.lex_state = 54, .external_lex_state = 12},
  [2143] = {.lex_state = 54, .external_lex_state = 12},
  [2144] = {.lex_state = 54, .external_lex_state = 14},
  [2145] = {.lex_state = 54, .external_lex_state = 14},
  [2146] = {.lex_state = 54, .external_lex_state = 14},
  [2147] = {.lex_state = 54, .external_lex_state = 14},
  [2148] = {.lex_state = 54, .external_lex_state = 14},
  [2149] = {.lex_state = 54, .external_lex_state = 9},
  [2150] = {.lex_state = 54, .external_lex_state = 14},
  [2151] = {.lex_state = 54, .external_lex_state = 9},
  [2152] = {.lex_state = 54, .external_lex_state = 14},
  [2153] = {.lex_state = 54, .external_lex_state = 13},
  [2154] = {.lex_state = 54, .external_lex_state = 14},
  [2155] = {.lex_state = 54, .external_lex_state = 15},
  [2156] = {.lex_state = 54, .external_lex_state = 14},
  [2157] = {.lex_state = 54, .external_lex_state = 14},
  [2158] = {.lex_state = 54, .external_lex_state = 12},
  [2159] = {.lex_state = 54, .external_lex_state = 13},
  [2160] = {.lex_state = 54, .external_lex_state = 9},
  [2161] = {.lex_state = 54, .external_lex_state = 18},
  [2162] = {.lex_state = 54, .external_lex_state = 9},
  [2163] = {.lex_state = 54, .external_lex_state = 14},
  [2164] = {.lex_state = 54, .external_lex_state = 18},
  [2165] = {.lex_state = 54, .external_lex_state = 14},
  [2166] = {.lex_state = 54, .external_lex_state = 14},
  [2167] = {.lex_state = 54, .external_lex_state = 14},
  [2168] = {.lex_state = 54, .external_lex_state = 14},
  [2169] = {.lex_state = 54, .external_lex_state = 14},
  [2170] = {.lex_state = 54, .external_lex_state = 14},
  [2171] = {.lex_state = 54, .external_lex_state = 13},
  [2172] = {.lex_state = 54, .external_lex_state = 15},
  [2173] = {.lex_state = 32, .external_lex_state = 13},
  [2174] = {.lex_state = 54, .external_lex_state = 9},
  [2175] = {.lex_state = 54, .external_lex_state = 14},
  [2176] = {.lex_state = 54, .external_lex_state = 14},
  [2177] = {.lex_state = 54, .external_lex_state = 9},
  [2178] = {.lex_state = 54, .external_lex_state = 9},
  [2179] = {.lex_state = 54, .external_lex_state = 14},
  [2180] = {.lex_state = 54, .external_lex_state = 14},
  [2181] = {.lex_state = 54, .external_lex_state = 14},
  [2182] = {.lex_state = 54, .external_lex_state = 14},
  [2183] = {.lex_state = 54, .external_lex_state = 14},
  [2184] = {.lex_state = 54, .external_lex_state = 14},
  [2185] = {.lex_state = 54, .external_lex_state = 14},
  [2186] = {.lex_state = 54, .external_lex_state = 15},
  [2187] = {.lex_state = 54, .external_lex_state = 14},
  [2188] = {.lex_state = 54, .external_lex_state = 15},
  [2189] = {.lex_state = 54, .external_lex_state = 14},
  [2190] = {.lex_state = 54, .external_lex_state = 14},
  [2191] = {.lex_state = 54, .external_lex_state = 12},
  [2192] = {.lex_state = 54, .external_lex_state = 9},
  [2193] = {.lex_state = 54, .external_lex_state = 15},
  [2194] = {.lex_state = 54, .external_lex_state = 13},
  [2195] = {.lex_state = 54, .external_lex_state = 15},
  [2196] = {.lex_state = 54, .external_lex_state = 14},
  [2197] = {.lex_state = 54, .external_lex_state = 13},
  [2198] = {.lex_state = 54, .external_lex_state = 14},
  [2199] = {.lex_state = 33, .external_lex_state = 13},
  [2200] = {.lex_state = 54, .external_lex_state = 13},
  [2201] = {.lex_state = 54, .external_lex_state = 9},
  [2202] = {.lex_state = 54, .external_lex_state = 12},
  [2203] = {.lex_state = 54, .external_lex_state = 14},
  [2204] = {.lex_state = 54, .external_lex_state = 15},
  [2205] = {.lex_state = 54, .external_lex_state = 13},
  [2206] = {.lex_state = 54, .external_lex_state = 14},
  [2207] = {.lex_state = 54, .external_lex_state = 15},
  [2208] = {.lex_state = 54, .external_lex_state = 12},
  [2209] = {.lex_state = 54, .external_lex_state = 15},
  [2210] = {.lex_state = 54, .external_lex_state = 12},
  [2211] = {.lex_state = 54, .external_lex_state = 12},
  [2212] = {.lex_state = 54, .external_lex_state = 12},
  [2213] = {.lex_state = 54, .external_lex_state = 12},
  [2214] = {.lex_state = 54, .external_lex_state = 14},
  [2215] = {.lex_state = 54, .external_lex_state = 15},
  [2216] = {.lex_state = 54, .external_lex_state = 12},
  [2217] = {.lex_state = 54, .external_lex_state = 12},
  [2218] = {.lex_state = 54, .external_lex_state = 12},
  [2219] = {.lex_state = 54, .external_lex_state = 15},
  [2220] = {.lex_state = 54, .external_lex_state = 15},
  [2221] = {.lex_state = 54, .external_lex_state = 12},
  [2222] = {.lex_state = 54, .external_lex_state = 18},
  [2223] = {.lex_state = 54, .external_lex_state = 13},
  [2224] = {.lex_state = 54, .external_lex_state = 12},
  [2225] = {.lex_state = 54, .external_lex_state = 9},
  [2226] = {.lex_state = 54, .external_lex_state = 13},
  [2227] = {.lex_state = 54, .external_lex_state = 15},
  [2228] = {.lex_state = 54, .external_lex_state = 9},
  [2229] = {.lex_state = 54, .external_lex_state = 18},
  [2230] = {.lex_state = 54, .external_lex_state = 12},
  [2231] = {.lex_state = 54, .external_lex_state = 14},
  [2232] = {.lex_state = 54, .external_lex_state = 9},
  [2233] = {.lex_state = 54, .external_lex_state = 9},
  [2234] = {.lex_state = 54, .external_lex_state = 12},
  [2235] = {.lex_state = 54, .external_lex_state = 12},
  [2236] = {.lex_state = 54, .external_lex_state = 13},
  [2237] = {.lex_state = 32, .external_lex_state = 13},
  [2238] = {.lex_state = 54, .external_lex_state = 14},
  [2239] = {.lex_state = 54, .external_lex_state = 15},
  [2240] = {.lex_state = 54, .external_lex_state = 15},
  [2241] = {.lex_state = 54, .external_lex_state = 15},
  [2242] = {.lex_state = 54, .external_lex_state = 15},
  [2243] = {.lex_state = 54, .external_lex_state = 15},
  [2244] = {.lex_state = 54, .external_lex_state = 14},
  [2245] = {.lex_state = 54, .external_lex_state = 15},
  [2246] = {.lex_state = 54, .external_lex_state = 15},
  [2247] = {.lex_state = 54, .external_lex_state = 12},
  [2248] = {.lex_state = 54, .external_lex_state = 15},
  [2249] = {.lex_state = 54, .external_lex_state = 13},
  [2250] = {.lex_state = 54, .external_lex_state = 15},
  [2251] = {.lex_state = 54, .external_lex_state = 12},
  [2252] = {.lex_state = 54, .external_lex_state = 15},
  [2253] = {.lex_state = 54, .external_lex_state = 12},
  [2254] = {.lex_state = 54, .external_lex_state = 15},
  [2255] = {.lex_state = 54, .external_lex_state = 12},
  [2256] = {.lex_state = 54, .external_lex_state = 12},
  [2257] = {.lex_state = 54, .external_lex_state = 15},
  [2258] = {.lex_state = 54, .external_lex_state = 12},
  [2259] = {.lex_state = 54, .external_lex_state = 12},
  [2260] = {.lex_state = 54, .external_lex_state = 15},
  [2261] = {.lex_state = 54, .external_lex_state = 15},
  [2262] = {.lex_state = 54, .external_lex_state = 12},
  [2263] = {.lex_state = 54, .external_lex_state = 9},
  [2264] = {.lex_state = 54, .external_lex_state = 9},
  [2265] = {.lex_state = 54, .external_lex_state = 15},
  [2266] = {.lex_state = 54, .external_lex_state = 9},
  [2267] = {.lex_state = 54, .external_lex_state = 13},
  [2268] = {.lex_state = 54, .external_lex_state = 9},
  [2269] = {.lex_state = 54, .external_lex_state = 14},
  [2270] = {.lex_state = 54, .external_lex_state = 13},
  [2271] = {.lex_state = 54, .external_lex_state = 12},
  [2272] = {.lex_state = 54, .external_lex_state = 13},
  [2273] = {.lex_state = 34, .external_lex_state = 17},
  [2274] = {.lex_state = 54, .external_lex_state = 19},
  [2275] = {.lex_state = 54, .external_lex_state = 19},
  [2276] = {.lex_state = 54, .external_lex_state = 12},
  [2277] = {.lex_state = 54, .external_lex_state = 15},
  [2278] = {.lex_state = 54, .external_lex_state = 15},
  [2279] = {.lex_state = 54, .external_lex_state = 9},
  [2280] = {.lex_state = 54, .external_lex_state = 15},
  [2281] = {.lex_state = 54, .external_lex_state = 13},
  [2282] = {.lex_state = 54, .external_lex_state = 13},
  [2283] = {.lex_state = 33, .external_lex_state = 13},
  [2284] = {.lex_state = 54, .external_lex_state = 14},
  [2285] = {.lex_state = 54, .external_lex_state = 14},
  [2286] = {.lex_state = 54, .external_lex_state = 15},
  [2287] = {.lex_state = 54, .external_lex_state = 9},
  [2288] = {.lex_state = 3, .external_lex_state = 12},
  [2289] = {.lex_state = 54, .external_lex_state = 9},
  [2290] = {.lex_state = 54, .external_lex_state = 12},
  [2291] = {.lex_state = 3, .external_lex_state = 12},
  [2292] = {.lex_state = 3, .external_lex_state = 12},
  [2293] = {.lex_state = 54, .external_lex_state = 12},
  [2294] = {.lex_state = 3, .external_lex_state = 12},
  [2295] = {.lex_state = 3, .external_lex_state = 12},
  [2296] = {.lex_state = 54, .external_lex_state = 14},
  [2297] = {.lex_state = 54, .external_lex_state = 14},
  [2298] = {.lex_state = 54, .external_lex_state = 15},
  [2299] = {.lex_state = 54, .external_lex_state = 19},
  [2300] = {.lex_state = 54, .external_lex_state = 15},
  [2301] = {.lex_state = 3, .external_lex_state = 12},
  [2302] = {.lex_state = 54, .external_lex_state = 14},
  [2303] = {.lex_state = 54, .external_lex_state = 9},
  [2304] = {.lex_state = 34, .external_lex_state = 17},
  [2305] = {.lex_state = 54, .external_lex_state = 15},
  [2306] = {.lex_state = 54, .external_lex_state = 12},
  [2307] = {.lex_state = 54, .external_lex_state = 14},
  [2308] = {.lex_state = 54, .external_lex_state = 15},
  [2309] = {.lex_state = 54, .external_lex_state = 14},
  [2310] = {.lex_state = 54, .external_lex_state = 9},
  [2311] = {.lex_state = 54, .external_lex_state = 15},
  [2312] = {.lex_state = 54, .external_lex_state = 15},
  [2313] = {.lex_state = 54, .external_lex_state = 15},
  [2314] = {.lex_state = 54, .external_lex_state = 14},
  [2315] = {.lex_state = 54, .external_lex_state = 13},
  [2316] = {.lex_state = 54, .external_lex_state = 15},
  [2317] = {.lex_state = 54, .external_lex_state = 14},
  [2318] = {.lex_state = 54, .external_lex_state = 14},
  [2319] = {.lex_state = 54, .external_lex_state = 9},
  [2320] = {.lex_state = 54, .external_lex_state = 14},
  [2321] = {.lex_state = 33, .external_lex_state = 13},
  [2322] = {.lex_state = 54, .external_lex_state = 14},
  [2323] = {.lex_state = 54, .external_lex_state = 14},
  [2324] = {.lex_state = 54, .external_lex_state = 14},
  [2325] = {.lex_state = 54, .external_lex_state = 13},
  [2326] = {.lex_state = 34, .external_lex_state = 17},
  [2327] = {.lex_state = 3, .external_lex_state = 12},
  [2328] = {.lex_state = 54, .external_lex_state = 14},
  [2329] = {.lex_state = 54, .external_lex_state = 14},
  [2330] = {.lex_state = 54, .external_lex_state = 14},
  [2331] = {.lex_state = 54, .external_lex_state = 12},
  [2332] = {.lex_state = 54, .external_lex_state = 14},
  [2333] = {.lex_state = 54, .external_lex_state = 13},
  [2334] = {.lex_state = 54, .external_lex_state = 14},
  [2335] = {.lex_state = 33, .external_lex_state = 13},
  [2336] = {.lex_state = 54, .external_lex_state = 14},
  [2337] = {.lex_state = 54, .external_lex_state = 12},
  [2338] = {.lex_state = 54, .external_lex_state = 14},
  [2339] = {.lex_state = 54, .external_lex_state = 15},
  [2340] = {.lex_state = 54, .external_lex_state = 15},
  [2341] = {.lex_state = 54, .external_lex_state = 19},
  [2342] = {.lex_state = 33, .external_lex_state = 13},
  [2343] = {.lex_state = 54, .external_lex_state = 12},
  [2344] = {.lex_state = 33, .external_lex_state = 13},
  [2345] = {.lex_state = 54, .external_lex_state = 12},
  [2346] = {.lex_state = 33, .external_lex_state = 13},
  [2347] = {.lex_state = 54, .external_lex_state = 13},
  [2348] = {.lex_state = 33, .external_lex_state = 13},
  [2349] = {.lex_state = 54, .external_lex_state = 12},
  [2350] = {.lex_state = 54, .external_lex_state = 13},
  [2351] = {.lex_state = 54, .external_lex_state = 14},
  [2352] = {.lex_state = 54, .external_lex_state = 13},
  [2353] = {.lex_state = 54, .external_lex_state = 14},
  [2354] = {.lex_state = 54, .external_lex_state = 13},
  [2355] = {.lex_state = 54, .external_lex_state = 13},
  [2356] = {.lex_state = 54, .external_lex_state = 9},
  [2357] = {.lex_state = 3, .external_lex_state = 12},
  [2358] = {.lex_state = 54, .external_lex_state = 12},
  [2359] = {.lex_state = 54, .external_lex_state = 12},
  [2360] = {.lex_state = 54, .external_lex_state = 15},
  [2361] = {.lex_state = 54, .external_lex_state = 12},
  [2362] = {.lex_state = 54, .external_lex_state = 14},
  [2363] = {.lex_state = 54, .external_lex_state = 13},
  [2364] = {.lex_state = 54, .external_lex_state = 12},
  [2365] = {.lex_state = 54, .external_lex_state = 9},
  [2366] = {.lex_state = 54, .external_lex_state = 12},
  [2367] = {.lex_state = 54, .external_lex_state = 15},
  [2368] = {.lex_state = 54, .external_lex_state = 14},
  [2369] = {.lex_state = 54, .external_lex_state = 9},
  [2370] = {.lex_state = 54, .external_lex_state = 14},
  [2371] = {.lex_state = 54, .external_lex_state = 14},
  [2372] = {.lex_state = 54, .external_lex_state = 15},
  [2373] = {.lex_state = 54, .external_lex_state = 14},
  [2374] = {.lex_state = 54, .external_lex_state = 15},
  [2375] = {.lex_state = 54, .external_lex_state = 19},
  [2376] = {.lex_state = 54, .external_lex_state = 14},
  [2377] = {.lex_state = 54, .external_lex_state = 15},
  [2378] = {.lex_state = 54, .external_lex_state = 15},
  [2379] = {.lex_state = 54, .external_lex_state = 14},
  [2380] = {.lex_state = 54, .external_lex_state = 15},
  [2381] = {.lex_state = 54, .external_lex_state = 12},
  [2382] = {.lex_state = 54, .external_lex_state = 13},
  [2383] = {.lex_state = 54, .external_lex_state = 15},
  [2384] = {.lex_state = 54, .external_lex_state = 14},
  [2385] = {.lex_state = 54, .external_lex_state = 15},
  [2386] = {.lex_state = 54, .external_lex_state = 9},
  [2387] = {.lex_state = 54, .external_lex_state = 9},
  [2388] = {.lex_state = 54, .external_lex_state = 19},
  [2389] = {.lex_state = 54, .external_lex_state = 13},
  [2390] = {.lex_state = 54, .external_lex_state = 14},
  [2391] = {.lex_state = 54, .external_lex_state = 12},
  [2392] = {.lex_state = 54, .external_lex_state = 15},
  [2393] = {.lex_state = 54, .external_lex_state = 15},
  [2394] = {.lex_state = 54, .external_lex_state = 14},
  [2395] = {.lex_state = 54, .external_lex_state = 12},
  [2396] = {.lex_state = 54, .external_lex_state = 14},
  [2397] = {.lex_state = 54, .external_lex_state = 14},
  [2398] = {.lex_state = 54, .external_lex_state = 13},
  [2399] = {.lex_state = 54, .external_lex_state = 15},
  [2400] = {.lex_state = 54, .external_lex_state = 14},
  [2401] = {.lex_state = 54, .external_lex_state = 14},
  [2402] = {.lex_state = 54, .external_lex_state = 14},
  [2403] = {.lex_state = 54, .external_lex_state = 15},
  [2404] = {.lex_state = 54, .external_lex_state = 14},
  [2405] = {.lex_state = 54, .external_lex_state = 15},
  [2406] = {.lex_state = 54, .external_lex_state = 14},
  [2407] = {.lex_state = 54, .external_lex_state = 19},
  [2408] = {.lex_state = 54, .external_lex_state = 13},
  [2409] = {.lex_state = 54, .external_lex_state = 12},
  [2410] = {.lex_state = 54, .external_lex_state = 15},
  [2411] = {.lex_state = 54, .external_lex_state = 12},
  [2412] = {.lex_state = 54, .external_lex_state = 14},
  [2413] = {.lex_state = 54, .external_lex_state = 12},
  [2414] = {.lex_state = 54, .external_lex_state = 14},
  [2415] = {.lex_state = 54, .external_lex_state = 9},
  [2416] = {.lex_state = 54, .external_lex_state = 15},
  [2417] = {.lex_state = 54, .external_lex_state = 15},
  [2418] = {.lex_state = 54, .external_lex_state = 14},
  [2419] = {.lex_state = 54, .external_lex_state = 15},
  [2420] = {.lex_state = 34, .external_lex_state = 17},
  [2421] = {.lex_state = 54, .external_lex_state = 12},
  [2422] = {.lex_state = 54, .external_lex_state = 14},
  [2423] = {.lex_state = 54, .external_lex_state = 12},
  [2424] = {.lex_state = 54, .external_lex_state = 14},
  [2425] = {.lex_state = 54, .external_lex_state = 9},
  [2426] = {.lex_state = 34, .external_lex_state = 17},
  [2427] = {.lex_state = 54, .external_lex_state = 13},
  [2428] = {.lex_state = 54, .external_lex_state = 12},
  [2429] = {.lex_state = 33, .external_lex_state = 13},
  [2430] = {.lex_state = 54, .external_lex_state = 13},
  [2431] = {.lex_state = 54, .external_lex_state = 14},
  [2432] = {.lex_state = 54, .external_lex_state = 12},
  [2433] = {.lex_state = 54, .external_lex_state = 12},
  [2434] = {.lex_state = 54, .external_lex_state = 15},
  [2435] = {.lex_state = 54, .external_lex_state = 13},
  [2436] = {.lex_state = 54, .external_lex_state = 12},
  [2437] = {.lex_state = 54, .external_lex_state = 14},
  [2438] = {.lex_state = 54, .external_lex_state = 14},
  [2439] = {.lex_state = 54, .external_lex_state = 15},
  [2440] = {.lex_state = 54, .external_lex_state = 15},
  [2441] = {.lex_state = 54, .external_lex_state = 15},
  [2442] = {.lex_state = 54, .external_lex_state = 13},
  [2443] = {.lex_state = 54, .external_lex_state = 12},
  [2444] = {.lex_state = 54, .external_lex_state = 14},
  [2445] = {.lex_state = 54, .external_lex_state = 12},
  [2446] = {.lex_state = 54, .external_lex_state = 13},
  [2447] = {.lex_state = 54, .external_lex_state = 14},
  [2448] = {.lex_state = 54, .external_lex_state = 14},
  [2449] = {.lex_state = 54, .external_lex_state = 9},
  [2450] = {.lex_state = 54, .external_lex_state = 15},
  [2451] = {.lex_state = 54, .external_lex_state = 13},
  [2452] = {.lex_state = 54, .external_lex_state = 14},
  [2453] = {.lex_state = 54, .external_lex_state = 15},
  [2454] = {.lex_state = 54, .external_lex_state = 13},
  [2455] = {.lex_state = 54, .external_lex_state = 14},
  [2456] = {.lex_state = 54, .external_lex_state = 13},
  [2457] = {.lex_state = 54, .external_lex_state = 14},
  [2458] = {.lex_state = 54, .external_lex_state = 15},
  [2459] = {.lex_state = 54, .external_lex_state = 14},
  [2460] = {.lex_state = 54, .external_lex_state = 14},
  [2461] = {.lex_state = 54, .external_lex_state = 13},
  [2462] = {.lex_state = 54, .external_lex_state = 9},
  [2463] = {.lex_state = 54, .external_lex_state = 12},
  [2464] = {.lex_state = 3, .external_lex_state = 12},
  [2465] = {.lex_state = 54, .external_lex_state = 14},
  [2466] = {.lex_state = 54, .external_lex_state = 14},
  [2467] = {.lex_state = 54, .external_lex_state = 15},
  [2468] = {.lex_state = 54, .external_lex_state = 14},
  [2469] = {.lex_state = 54, .external_lex_state = 9},
  [2470] = {.lex_state = 54, .external_lex_state = 12},
  [2471] = {.lex_state = 54, .external_lex_state = 14},
  [2472] = {.lex_state = 54, .external_lex_state = 9},
  [2473] = {.lex_state = 54, .external_lex_state = 14},
  [2474] = {.lex_state = 54, .external_lex_state = 14},
  [2475] = {.lex_state = 54, .external_lex_state = 15},
  [2476] = {.lex_state = 54, .external_lex_state = 12},
  [2477] = {.lex_state = 54, .external_lex_state = 9},
  [2478] = {.lex_state = 54, .external_lex_state = 12},
  [2479] = {.lex_state = 54, .external_lex_state = 14},
  [2480] = {.lex_state = 54, .external_lex_state = 9},
  [2481] = {.lex_state = 54, .external_lex_state = 9},
  [2482] = {.lex_state = 54, .external_lex_state = 14},
  [2483] = {.lex_state = 54, .external_lex_state = 19},
  [2484] = {.lex_state = 54, .external_lex_state = 15},
  [2485] = {.lex_state = 54, .external_lex_state = 15},
  [2486] = {.lex_state = 54, .external_lex_state = 15},
  [2487] = {.lex_state = 54, .external_lex_state = 14},
  [2488] = {.lex_state = 54, .external_lex_state = 12},
  [2489] = {.lex_state = 54, .external_lex_state = 12},
  [2490] = {.lex_state = 54, .external_lex_state = 14},
  [2491] = {.lex_state = 54, .external_lex_state = 13},
  [2492] = {.lex_state = 54, .external_lex_state = 15},
  [2493] = {.lex_state = 54, .external_lex_state = 12},
  [2494] = {.lex_state = 54, .external_lex_state = 13},
  [2495] = {.lex_state = 54, .external_lex_state = 14},
  [2496] = {.lex_state = 54, .external_lex_state = 14},
  [2497] = {.lex_state = 54, .external_lex_state = 14},
  [2498] = {.lex_state = 54, .external_lex_state = 15},
  [2499] = {.lex_state = 54, .external_lex_state = 15},
  [2500] = {.lex_state = 54, .external_lex_state = 14},
  [2501] = {.lex_state = 54, .external_lex_state = 14},
  [2502] = {.lex_state = 54, .external_lex_state = 9},
  [2503] = {.lex_state = 54, .external_lex_state = 13},
  [2504] = {.lex_state = 54, .external_lex_state = 14},
  [2505] = {.lex_state = 54, .external_lex_state = 13},
  [2506] = {.lex_state = 54, .external_lex_state = 14},
  [2507] = {.lex_state = 54, .external_lex_state = 13},
  [2508] = {.lex_state = 54, .external_lex_state = 15},
  [2509] = {.lex_state = 54, .external_lex_state = 15},
  [2510] = {.lex_state = 54, .external_lex_state = 12},
  [2511] = {.lex_state = 54, .external_lex_state = 12},
  [2512] = {.lex_state = 54, .external_lex_state = 13},
  [2513] = {.lex_state = 54, .external_lex_state = 9},
  [2514] = {.lex_state = 54, .external_lex_state = 14},
  [2515] = {.lex_state = 54, .external_lex_state = 14},
  [2516] = {.lex_state = 54, .external_lex_state = 15},
  [2517] = {.lex_state = 54, .external_lex_state = 12},
  [2518] = {.lex_state = 54, .external_lex_state = 12},
  [2519] = {.lex_state = 54, .external_lex_state = 14},
  [2520] = {.lex_state = 54, .external_lex_state = 14},
  [2521] = {.lex_state = 54, .external_lex_state = 15},
  [2522] = {.lex_state = 54, .external_lex_state = 9},
  [2523] = {.lex_state = 54, .external_lex_state = 14},
  [2524] = {.lex_state = 54, .external_lex_state = 14},
  [2525] = {.lex_state = 54, .external_lex_state = 14},
  [2526] = {.lex_state = 54, .external_lex_state = 15},
  [2527] = {.lex_state = 54, .external_lex_state = 14},
  [2528] = {.lex_state = 54, .external_lex_state = 18},
  [2529] = {.lex_state = 54, .external_lex_state = 9},
  [2530] = {.lex_state = 54, .external_lex_state = 13},
  [2531] = {.lex_state = 54, .external_lex_state = 18},
  [2532] = {.lex_state = 54, .external_lex_state = 13},
  [2533] = {.lex_state = 54, .external_lex_state = 9},
  [2534] = {.lex_state = 54, .external_lex_state = 18},
  [2535] = {.lex_state = 54, .external_lex_state = 12},
  [2536] = {.lex_state = 54, .external_lex_state = 18},
  [2537] = {.lex_state = 54, .external_lex_state = 9},
  [2538] = {.lex_state = 34, .external_lex_state = 13},
  [2539] = {.lex_state = 54, .external_lex_state = 13},
  [2540] = {.lex_state = 54, .external_lex_state = 9},
  [2541] = {.lex_state = 54, .external_lex_state = 9},
  [2542] = {.lex_state = 54, .external_lex_state = 13},
  [2543] = {.lex_state = 54, .external_lex_state = 13},
  [2544] = {.lex_state = 54, .external_lex_state = 9},
  [2545] = {.lex_state = 54, .external_lex_state = 18},
  [2546] = {.lex_state = 54, .external_lex_state = 15},
  [2547] = {.lex_state = 54, .external_lex_state = 18},
  [2548] = {.lex_state = 54, .external_lex_state = 18},
  [2549] = {.lex_state = 54, .external_lex_state = 13},
  [2550] = {.lex_state = 54, .external_lex_state = 18},
  [2551] = {.lex_state = 54, .external_lex_state = 9},
  [2552] = {.lex_state = 54, .external_lex_state = 13},
  [2553] = {.lex_state = 54, .external_lex_state = 9},
  [2554] = {.lex_state = 54, .external_lex_state = 14},
  [2555] = {.lex_state = 54, .external_lex_state = 18},
  [2556] = {.lex_state = 54, .external_lex_state = 14},
  [2557] = {.lex_state = 54, .external_lex_state = 9},
  [2558] = {.lex_state = 54, .external_lex_state = 18},
  [2559] = {.lex_state = 54, .external_lex_state = 9},
  [2560] = {.lex_state = 54, .external_lex_state = 18},
  [2561] = {.lex_state = 54, .external_lex_state = 13},
  [2562] = {.lex_state = 54, .external_lex_state = 18},
  [2563] = {.lex_state = 54, .external_lex_state = 13},
  [2564] = {.lex_state = 54, .external_lex_state = 14},
  [2565] = {.lex_state = 54, .external_lex_state = 13},
  [2566] = {.lex_state = 54, .external_lex_state = 13},
  [2567] = {.lex_state = 54, .external_lex_state = 18},
  [2568] = {.lex_state = 54, .external_lex_state = 13},
  [2569] = {.lex_state = 54, .external_lex_state = 18},
  [2570] = {.lex_state = 54, .external_lex_state = 14},
  [2571] = {.lex_state = 54, .external_lex_state = 15},
  [2572] = {.lex_state = 34, .external_lex_state = 13},
  [2573] = {.lex_state = 54, .external_lex_state = 14},
  [2574] = {.lex_state = 54, .external_lex_state = 14},
  [2575] = {.lex_state = 54, .external_lex_state = 13},
  [2576] = {.lex_state = 54, .external_lex_state = 14},
  [2577] = {.lex_state = 54, .external_lex_state = 13},
  [2578] = {.lex_state = 54, .external_lex_state = 14},
  [2579] = {.lex_state = 54, .external_lex_state = 14},
  [2580] = {.lex_state = 54, .external_lex_state = 15},
  [2581] = {.lex_state = 34, .external_lex_state = 13},
  [2582] = {.lex_state = 34, .external_lex_state = 13},
  [2583] = {.lex_state = 54, .external_lex_state = 13},
  [2584] = {.lex_state = 34, .external_lex_state = 13},
  [2585] = {.lex_state = 54, .external_lex_state = 15},
  [2586] = {.lex_state = 34, .external_lex_state = 13},
  [2587] = {.lex_state = 34, .external_lex_state = 13},
  [2588] = {.lex_state = 54, .external_lex_state = 13},
  [2589] = {.lex_state = 54, .external_lex_state = 14},
  [2590] = {.lex_state = 34, .external_lex_state = 13},
  [2591] = {.lex_state = 54, .external_lex_state = 18},
  [2592] = {.lex_state = 54, .external_lex_state = 9},
  [2593] = {.lex_state = 54, .external_lex_state = 18},
  [2594] = {.lex_state = 54, .external_lex_state = 9},
  [2595] = {.lex_state = 54, .external_lex_state = 12},
  [2596] = {.lex_state = 54, .external_lex_state = 18},
  [2597] = {.lex_state = 54, .external_lex_state = 13},
  [2598] = {.lex_state = 54, .external_lex_state = 18},
  [2599] = {.lex_state = 54, .external_lex_state = 14},
  [2600] = {.lex_state = 54, .external_lex_state = 15},
  [2601] = {.lex_state = 54, .external_lex_state = 13},
  [2602] = {.lex_state = 54, .external_lex_state = 14},
  [2603] = {.lex_state = 54, .external_lex_state = 15},
  [2604] = {.lex_state = 34, .external_lex_state = 13},
  [2605] = {.lex_state = 54, .external_lex_state = 13},
  [2606] = {.lex_state = 54, .external_lex_state = 9},
  [2607] = {.lex_state = 54, .external_lex_state = 9},
  [2608] = {.lex_state = 54, .external_lex_state = 14},
  [2609] = {.lex_state = 54, .external_lex_state = 9},
  [2610] = {.lex_state = 34, .external_lex_state = 13},
  [2611] = {.lex_state = 54, .external_lex_state = 14},
  [2612] = {.lex_state = 54, .external_lex_state = 12},
  [2613] = {.lex_state = 54, .external_lex_state = 13},
  [2614] = {.lex_state = 54, .external_lex_state = 12},
  [2615] = {.lex_state = 54, .external_lex_state = 9},
  [2616] = {.lex_state = 54, .external_lex_state = 14},
  [2617] = {.lex_state = 54, .external_lex_state = 13},
  [2618] = {.lex_state = 54, .external_lex_state = 13},
  [2619] = {.lex_state = 54, .external_lex_state = 13},
  [2620] = {.lex_state = 54, .external_lex_state = 15},
  [2621] = {.lex_state = 54, .external_lex_state = 9},
  [2622] = {.lex_state = 54, .external_lex_state = 9},
  [2623] = {.lex_state = 54, .external_lex_state = 13},
  [2624] = {.lex_state = 54, .external_lex_state = 15},
  [2625] = {.lex_state = 54, .external_lex_state = 13},
  [2626] = {.lex_state = 54, .external_lex_state = 13},
  [2627] = {.lex_state = 54, .external_lex_state = 15},
  [2628] = {.lex_state = 54, .external_lex_state = 12},
  [2629] = {.lex_state = 29, .external_lex_state = 13},
  [2630] = {.lex_state = 54, .external_lex_state = 14},
  [2631] = {.lex_state = 54, .external_lex_state = 12},
  [2632] = {.lex_state = 54, .external_lex_state = 13},
  [2633] = {.lex_state = 29, .external_lex_state = 13},
  [2634] = {.lex_state = 54, .external_lex_state = 15},
  [2635] = {.lex_state = 54, .external_lex_state = 13},
  [2636] = {.lex_state = 54, .external_lex_state = 13},
  [2637] = {.lex_state = 54, .external_lex_state = 14},
  [2638] = {.lex_state = 54, .external_lex_state = 13},
  [2639] = {.lex_state = 54, .external_lex_state = 13},
  [2640] = {.lex_state = 54, .external_lex_state = 15},
  [2641] = {.lex_state = 54, .external_lex_state = 12},
  [2642] = {.lex_state = 54, .external_lex_state = 13},
  [2643] = {.lex_state = 54, .external_lex_state = 12},
  [2644] = {.lex_state = 54, .external_lex_state = 12},
  [2645] = {.lex_state = 54, .external_lex_state = 13},
  [2646] = {.lex_state = 54, .external_lex_state = 13},
  [2647] = {.lex_state = 54, .external_lex_state = 12},
  [2648] = {.lex_state = 54, .external_lex_state = 13},
  [2649] = {.lex_state = 54, .external_lex_state = 13},
  [2650] = {.lex_state = 54, .external_lex_state = 13},
  [2651] = {.lex_state = 54, .external_lex_state = 14},
  [2652] = {.lex_state = 54, .external_lex_state = 15},
  [2653] = {.lex_state = 54, .external_lex_state = 13},
  [2654] = {.lex_state = 54, .external_lex_state = 14},
  [2655] = {.lex_state = 54, .external_lex_state = 12},
  [2656] = {.lex_state = 54, .external_lex_state = 12},
  [2657] = {.lex_state = 54, .external_lex_state = 13},
  [2658] = {.lex_state = 54, .external_lex_state = 13},
  [2659] = {.lex_state = 54, .external_lex_state = 14},
  [2660] = {.lex_state = 54, .external_lex_state = 13},
  [2661] = {.lex_state = 54, .external_lex_state = 15},
  [2662] = {.lex_state = 54, .external_lex_state = 12},
  [2663] = {.lex_state = 54, .external_lex_state = 14},
  [2664] = {.lex_state = 54, .external_lex_state = 14},
  [2665] = {.lex_state = 54, .external_lex_state = 14},
  [2666] = {.lex_state = 54, .external_lex_state = 12},
  [2667] = {.lex_state = 54, .external_lex_state = 12},
  [2668] = {.lex_state = 54, .external_lex_state = 12},
  [2669] = {.lex_state = 54, .external_lex_state = 12},
  [2670] = {.lex_state = 54, .external_lex_state = 13},
  [2671] = {.lex_state = 54, .external_lex_state = 13},
  [2672] = {.lex_state = 54, .external_lex_state = 15},
  [2673] = {.lex_state = 54, .external_lex_state = 13},
  [2674] = {.lex_state = 54, .external_lex_state = 14},
  [2675] = {.lex_state = 54, .external_lex_state = 13},
  [2676] = {.lex_state = 54, .external_lex_state = 13},
  [2677] = {.lex_state = 54, .external_lex_state = 14},
  [2678] = {.lex_state = 54, .external_lex_state = 13},
  [2679] = {.lex_state = 54, .external_lex_state = 12},
  [2680] = {.lex_state = 54, .external_lex_state = 14},
  [2681] = {.lex_state = 54, .external_lex_state = 13},
  [2682] = {.lex_state = 54, .external_lex_state = 12},
  [2683] = {.lex_state = 54, .external_lex_state = 13},
  [2684] = {.lex_state = 54, .external_lex_state = 13},
  [2685] = {.lex_state = 29, .external_lex_state = 13},
  [2686] = {.lex_state = 54, .external_lex_state = 13},
  [2687] = {.lex_state = 54, .external_lex_state = 12},
  [2688] = {.lex_state = 54, .external_lex_state = 12},
  [2689] = {.lex_state = 54, .external_lex_state = 14},
  [2690] = {.lex_state = 54, .external_lex_state = 13},
  [2691] = {.lex_state = 54, .external_lex_state = 15},
  [2692] = {.lex_state = 54, .external_lex_state = 14},
  [2693] = {.lex_state = 54, .external_lex_state = 13},
  [2694] = {.lex_state = 54, .external_lex_state = 13},
  [2695] = {.lex_state = 54, .external_lex_state = 15},
  [2696] = {.lex_state = 54, .external_lex_state = 13},
  [2697] = {.lex_state = 54, .external_lex_state = 13},
  [2698] = {.lex_state = 54, .external_lex_state = 14},
  [2699] = {.lex_state = 54, .external_lex_state = 15},
  [2700] = {.lex_state = 54, .external_lex_state = 14},
  [2701] = {.lex_state = 54, .external_lex_state = 13},
  [2702] = {.lex_state = 29, .external_lex_state = 13},
  [2703] = {.lex_state = 54, .external_lex_state = 14},
  [2704] = {.lex_state = 54, .external_lex_state = 13},
  [2705] = {.lex_state = 54, .external_lex_state = 12},
  [2706] = {.lex_state = 54, .external_lex_state = 13},
  [2707] = {.lex_state = 54, .external_lex_state = 14},
  [2708] = {.lex_state = 54, .external_lex_state = 13},
  [2709] = {.lex_state = 54, .external_lex_state = 13},
  [2710] = {.lex_state = 54, .external_lex_state = 13},
  [2711] = {.lex_state = 54, .external_lex_state = 13},
  [2712] = {.lex_state = 54, .external_lex_state = 14},
  [2713] = {.lex_state = 54, .external_lex_state = 13},
  [2714] = {.lex_state = 54, .external_lex_state = 13},
  [2715] = {.lex_state = 54, .external_lex_state = 13},
  [2716] = {.lex_state = 54, .external_lex_state = 13},
  [2717] = {.lex_state = 54, .external_lex_state = 13},
  [2718] = {.lex_state = 54, .external_lex_state = 13},
  [2719] = {.lex_state = 54, .external_lex_state = 12},
  [2720] = {.lex_state = 54, .external_lex_state = 13},
  [2721] = {.lex_state = 54, .external_lex_state = 13},
  [2722] = {.lex_state = 54, .external_lex_state = 12},
  [2723] = {.lex_state = 54, .external_lex_state = 13},
  [2724] = {.lex_state = 54, .external_lex_state = 12},
  [2725] = {.lex_state = 54, .external_lex_state = 13},
  [2726] = {.lex_state = 54, .external_lex_state = 15},
  [2727] = {.lex_state = 54, .external_lex_state = 12},
  [2728] = {.lex_state = 54, .external_lex_state = 13},
  [2729] = {.lex_state = 54, .external_lex_state = 13},
  [2730] = {.lex_state = 54, .external_lex_state = 12},
  [2731] = {.lex_state = 54, .external_lex_state = 13},
  [2732] = {.lex_state = 54, .external_lex_state = 13},
  [2733] = {.lex_state = 54, .external_lex_state = 13},
  [2734] = {.lex_state = 54, .external_lex_state = 13},
  [2735] = {.lex_state = 54, .external_lex_state = 14},
  [2736] = {.lex_state = 54, .external_lex_state = 15},
  [2737] = {.lex_state = 54, .external_lex_state = 12},
  [2738] = {.lex_state = 54, .external_lex_state = 15},
  [2739] = {.lex_state = 54, .external_lex_state = 12},
  [2740] = {.lex_state = 54, .external_lex_state = 15},
  [2741] = {.lex_state = 54, .external_lex_state = 15},
  [2742] = {.lex_state = 54, .external_lex_state = 14},
  [2743] = {.lex_state = 54, .external_lex_state = 12},
  [2744] = {.lex_state = 54, .external_lex_state = 13},
  [2745] = {.lex_state = 54, .external_lex_state = 13},
  [2746] = {.lex_state = 54, .external_lex_state = 13},
  [2747] = {.lex_state = 54, .external_lex_state = 13},
  [2748] = {.lex_state = 54, .external_lex_state = 12},
  [2749] = {.lex_state = 54, .external_lex_state = 13},
  [2750] = {.lex_state = 54, .external_lex_state = 13},
  [2751] = {.lex_state = 54, .external_lex_state = 13},
  [2752] = {.lex_state = 54, .external_lex_state = 13},
  [2753] = {.lex_state = 54, .external_lex_state = 13},
  [2754] = {.lex_state = 54, .external_lex_state = 14},
  [2755] = {.lex_state = 54, .external_lex_state = 12},
  [2756] = {.lex_state = 54, .external_lex_state = 13},
  [2757] = {.lex_state = 54, .external_lex_state = 13},
  [2758] = {.lex_state = 54, .external_lex_state = 13},
  [2759] = {.lex_state = 54, .external_lex_state = 13},
  [2760] = {.lex_state = 54, .external_lex_state = 14},
  [2761] = {.lex_state = 54, .external_lex_state = 13},
  [2762] = {.lex_state = 54, .external_lex_state = 15},
  [2763] = {.lex_state = 54, .external_lex_state = 14},
  [2764] = {.lex_state = 54, .external_lex_state = 15},
  [2765] = {.lex_state = 54, .external_lex_state = 12},
  [2766] = {.lex_state = 54, .external_lex_state = 12},
  [2767] = {.lex_state = 54, .external_lex_state = 15},
  [2768] = {.lex_state = 54, .external_lex_state = 13},
  [2769] = {.lex_state = 54, .external_lex_state = 14},
  [2770] = {.lex_state = 54, .external_lex_state = 12},
  [2771] = {.lex_state = 54, .external_lex_state = 14},
  [2772] = {.lex_state = 54, .external_lex_state = 13},
  [2773] = {.lex_state = 54, .external_lex_state = 14},
  [2774] = {.lex_state = 54, .external_lex_state = 14},
  [2775] = {.lex_state = 54, .external_lex_state = 14},
  [2776] = {.lex_state = 54, .external_lex_state = 13},
  [2777] = {.lex_state = 54, .external_lex_state = 13},
  [2778] = {.lex_state = 54, .external_lex_state = 13},
  [2779] = {.lex_state = 29, .external_lex_state = 13},
  [2780] = {.lex_state = 54, .external_lex_state = 14},
  [2781] = {.lex_state = 54, .external_lex_state = 14},
  [2782] = {.lex_state = 29, .external_lex_state = 13},
  [2783] = {.lex_state = 54, .external_lex_state = 12},
  [2784] = {.lex_state = 54, .external_lex_state = 12},
  [2785] = {.lex_state = 54, .external_lex_state = 12},
  [2786] = {.lex_state = 54, .external_lex_state = 12},
  [2787] = {.lex_state = 54, .external_lex_state = 13},
  [2788] = {.lex_state = 54, .external_lex_state = 15},
  [2789] = {.lex_state = 54, .external_lex_state = 13},
  [2790] = {.lex_state = 54, .external_lex_state = 13},
  [2791] = {.lex_state = 54, .external_lex_state = 13},
  [2792] = {.lex_state = 54, .external_lex_state = 13},
  [2793] = {.lex_state = 54, .external_lex_state = 14},
  [2794] = {.lex_state = 54, .external_lex_state = 13},
  [2795] = {.lex_state = 54, .external_lex_state = 13},
  [2796] = {.lex_state = 54, .external_lex_state = 13},
  [2797] = {.lex_state = 54, .external_lex_state = 13},
  [2798] = {.lex_state = 54, .external_lex_state = 12},
  [2799] = {.lex_state = 54, .external_lex_state = 15},
  [2800] = {.lex_state = 54, .external_lex_state = 13},
  [2801] = {.lex_state = 54, .external_lex_state = 13},
  [2802] = {.lex_state = 54, .external_lex_state = 13},
  [2803] = {.lex_state = 29, .external_lex_state = 13},
  [2804] = {.lex_state = 54, .external_lex_state = 13},
  [2805] = {.lex_state = 54, .external_lex_state = 13},
  [2806] = {.lex_state = 54, .external_lex_state = 13},
  [2807] = {.lex_state = 54, .external_lex_state = 13},
  [2808] = {.lex_state = 54, .external_lex_state = 13},
  [2809] = {.lex_state = 54, .external_lex_state = 12},
  [2810] = {.lex_state = 54, .external_lex_state = 13},
  [2811] = {.lex_state = 54, .external_lex_state = 13},
  [2812] = {.lex_state = 54, .external_lex_state = 13},
  [2813] = {.lex_state = 54, .external_lex_state = 12},
  [2814] = {.lex_state = 54, .external_lex_state = 12},
  [2815] = {.lex_state = 54, .external_lex_state = 13},
  [2816] = {.lex_state = 54, .external_lex_state = 12},
  [2817] = {.lex_state = 54, .external_lex_state = 15},
  [2818] = {.lex_state = 54, .external_lex_state = 15},
  [2819] = {.lex_state = 54, .external_lex_state = 12},
  [2820] = {.lex_state = 54, .external_lex_state = 13},
  [2821] = {.lex_state = 54, .external_lex_state = 13},
  [2822] = {.lex_state = 54, .external_lex_state = 13},
  [2823] = {.lex_state = 54, .external_lex_state = 13},
  [2824] = {.lex_state = 54, .external_lex_state = 13},
  [2825] = {.lex_state = 54, .external_lex_state = 13},
  [2826] = {.lex_state = 54, .external_lex_state = 14},
  [2827] = {.lex_state = 54, .external_lex_state = 13},
  [2828] = {.lex_state = 54, .external_lex_state = 13},
  [2829] = {.lex_state = 54, .external_lex_state = 15},
  [2830] = {.lex_state = 29, .external_lex_state = 13},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym___future__] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_del] = ACTIONS(1),
    [anon_sym_raise] = ACTIONS(1),
    [anon_sym_pass] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_except] = ACTIONS(1),
    [anon_sym_except_STAR] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_nonlocal] = ACTIONS(1),
    [anon_sym_exec] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_lambda] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AT_EQ] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [sym_ellipsis] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym__not_escape_sequence] = ACTIONS(1),
    [sym_type_conversion] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_none] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(5),
    [sym__newline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym_string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym_escape_interpolation] = ACTIONS(1),
    [sym_string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_module] = STATE(2789),
    [sym__statement] = STATE(64),
    [sym__simple_statements] = STATE(64),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_if_statement] = STATE(64),
    [sym_match_statement] = STATE(64),
    [sym_for_statement] = STATE(64),
    [sym_while_statement] = STATE(64),
    [sym_try_statement] = STATE(64),
    [sym_with_statement] = STATE(64),
    [sym_function_definition] = STATE(64),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_class_definition] = STATE(64),
    [sym_decorated_definition] = STATE(64),
    [sym_decorator] = STATE(1824),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(64),
    [aux_sym_decorated_definition_repeat1] = STATE(1824),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_match] = ACTIONS(37),
    [anon_sym_async] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_def] = ACTIONS(49),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(81),
  },
  [2] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(725),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [3] = {
    [sym__statement] = STATE(72),
    [sym__simple_statements] = STATE(72),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(72),
    [sym_match_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_try_statement] = STATE(72),
    [sym_with_statement] = STATE(72),
    [sym_function_definition] = STATE(72),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(72),
    [sym_decorated_definition] = STATE(72),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(673),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(72),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [4] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(669),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [5] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(811),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [6] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(788),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [7] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(700),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [8] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(2562),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [9] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(708),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [10] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(819),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [11] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(823),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [12] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(814),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [13] = {
    [sym__statement] = STATE(72),
    [sym__simple_statements] = STATE(72),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(72),
    [sym_match_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_try_statement] = STATE(72),
    [sym_with_statement] = STATE(72),
    [sym_function_definition] = STATE(72),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(72),
    [sym_decorated_definition] = STATE(72),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(661),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(72),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [14] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(836),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [15] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(799),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [16] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(803),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [17] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(731),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [18] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(835),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [19] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(712),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [20] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(732),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [21] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(2569),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [22] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(734),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [23] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(723),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [24] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(618),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [25] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(715),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [26] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(804),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [27] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(841),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [28] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(817),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [29] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(764),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [30] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(777),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [31] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(818),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [32] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(651),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(81),
  },
  [33] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(649),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(113),
    [sym_string_start] = ACTIONS(81),
  },
  [34] = {
    [sym__statement] = STATE(72),
    [sym__simple_statements] = STATE(72),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(72),
    [sym_match_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_try_statement] = STATE(72),
    [sym_with_statement] = STATE(72),
    [sym_function_definition] = STATE(72),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(72),
    [sym_decorated_definition] = STATE(72),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(668),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(72),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(81),
  },
  [35] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(768),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [36] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(693),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(81),
  },
  [37] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(773),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [38] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(702),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [39] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(714),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [40] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(612),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [41] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(2596),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [42] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(2558),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [43] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(849),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [44] = {
    [sym__statement] = STATE(67),
    [sym__simple_statements] = STATE(67),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(67),
    [sym_match_statement] = STATE(67),
    [sym_for_statement] = STATE(67),
    [sym_while_statement] = STATE(67),
    [sym_try_statement] = STATE(67),
    [sym_with_statement] = STATE(67),
    [sym_function_definition] = STATE(67),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(67),
    [sym_decorated_definition] = STATE(67),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(672),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(67),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(113),
    [sym_string_start] = ACTIONS(81),
  },
  [45] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(707),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [46] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(779),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [47] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(850),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [48] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(2545),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [49] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(674),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(81),
  },
  [50] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(699),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [51] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(746),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [52] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(2548),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(81),
  },
  [53] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(747),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [54] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(1813),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(115),
    [sym_string_start] = ACTIONS(81),
  },
  [55] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(809),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [56] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(1833),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(115),
    [sym_string_start] = ACTIONS(81),
  },
  [57] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(821),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [58] = {
    [sym__statement] = STATE(65),
    [sym__simple_statements] = STATE(65),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(65),
    [sym_match_statement] = STATE(65),
    [sym_for_statement] = STATE(65),
    [sym_while_statement] = STATE(65),
    [sym_try_statement] = STATE(65),
    [sym_with_statement] = STATE(65),
    [sym_function_definition] = STATE(65),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(65),
    [sym_decorated_definition] = STATE(65),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(770),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(65),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(81),
  },
  [59] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(687),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(81),
  },
  [60] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(749),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [61] = {
    [sym__statement] = STATE(63),
    [sym__simple_statements] = STATE(63),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(63),
    [sym_match_statement] = STATE(63),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_try_statement] = STATE(63),
    [sym_with_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(63),
    [sym_decorated_definition] = STATE(63),
    [sym_decorator] = STATE(1828),
    [sym_block] = STATE(758),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(63),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(81),
  },
  [62] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1828),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(117),
    [sym_string_start] = ACTIONS(81),
  },
  [63] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1828),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(119),
    [sym_string_start] = ACTIONS(81),
  },
  [64] = {
    [sym__statement] = STATE(70),
    [sym__simple_statements] = STATE(70),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_if_statement] = STATE(70),
    [sym_match_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_try_statement] = STATE(70),
    [sym_with_statement] = STATE(70),
    [sym_function_definition] = STATE(70),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_class_definition] = STATE(70),
    [sym_decorated_definition] = STATE(70),
    [sym_decorator] = STATE(1824),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(70),
    [aux_sym_decorated_definition_repeat1] = STATE(1824),
    [ts_builtin_sym_end] = ACTIONS(121),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_match] = ACTIONS(37),
    [anon_sym_async] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_def] = ACTIONS(49),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(81),
  },
  [65] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1828),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(123),
    [sym_string_start] = ACTIONS(81),
  },
  [66] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1828),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(125),
    [anon_sym_import] = ACTIONS(128),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(134),
    [anon_sym_STAR] = ACTIONS(137),
    [anon_sym_print] = ACTIONS(140),
    [anon_sym_assert] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(146),
    [anon_sym_del] = ACTIONS(149),
    [anon_sym_raise] = ACTIONS(152),
    [anon_sym_pass] = ACTIONS(155),
    [anon_sym_break] = ACTIONS(158),
    [anon_sym_continue] = ACTIONS(161),
    [anon_sym_if] = ACTIONS(164),
    [anon_sym_match] = ACTIONS(167),
    [anon_sym_async] = ACTIONS(170),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_while] = ACTIONS(176),
    [anon_sym_try] = ACTIONS(179),
    [anon_sym_with] = ACTIONS(182),
    [anon_sym_def] = ACTIONS(185),
    [anon_sym_global] = ACTIONS(188),
    [anon_sym_nonlocal] = ACTIONS(191),
    [anon_sym_exec] = ACTIONS(194),
    [anon_sym_type] = ACTIONS(197),
    [anon_sym_class] = ACTIONS(200),
    [anon_sym_LBRACK] = ACTIONS(203),
    [anon_sym_AT] = ACTIONS(206),
    [anon_sym_DASH] = ACTIONS(209),
    [anon_sym_LBRACE] = ACTIONS(212),
    [anon_sym_PLUS] = ACTIONS(209),
    [anon_sym_not] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(209),
    [anon_sym_lambda] = ACTIONS(218),
    [anon_sym_yield] = ACTIONS(221),
    [sym_ellipsis] = ACTIONS(224),
    [sym_integer] = ACTIONS(227),
    [sym_float] = ACTIONS(224),
    [anon_sym_await] = ACTIONS(230),
    [sym_true] = ACTIONS(227),
    [sym_false] = ACTIONS(227),
    [sym_none] = ACTIONS(227),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(233),
    [sym_string_start] = ACTIONS(235),
  },
  [67] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1828),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(238),
    [sym_string_start] = ACTIONS(81),
  },
  [68] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1828),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(240),
    [sym_string_start] = ACTIONS(81),
  },
  [69] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1828),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(242),
    [sym_string_start] = ACTIONS(81),
  },
  [70] = {
    [sym__statement] = STATE(70),
    [sym__simple_statements] = STATE(70),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_if_statement] = STATE(70),
    [sym_match_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_try_statement] = STATE(70),
    [sym_with_statement] = STATE(70),
    [sym_function_definition] = STATE(70),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_class_definition] = STATE(70),
    [sym_decorated_definition] = STATE(70),
    [sym_decorator] = STATE(1824),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(70),
    [aux_sym_decorated_definition_repeat1] = STATE(1824),
    [ts_builtin_sym_end] = ACTIONS(233),
    [sym_identifier] = ACTIONS(125),
    [anon_sym_import] = ACTIONS(128),
    [anon_sym_from] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(134),
    [anon_sym_STAR] = ACTIONS(137),
    [anon_sym_print] = ACTIONS(140),
    [anon_sym_assert] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(146),
    [anon_sym_del] = ACTIONS(149),
    [anon_sym_raise] = ACTIONS(152),
    [anon_sym_pass] = ACTIONS(155),
    [anon_sym_break] = ACTIONS(158),
    [anon_sym_continue] = ACTIONS(161),
    [anon_sym_if] = ACTIONS(244),
    [anon_sym_match] = ACTIONS(247),
    [anon_sym_async] = ACTIONS(250),
    [anon_sym_for] = ACTIONS(253),
    [anon_sym_while] = ACTIONS(256),
    [anon_sym_try] = ACTIONS(259),
    [anon_sym_with] = ACTIONS(262),
    [anon_sym_def] = ACTIONS(265),
    [anon_sym_global] = ACTIONS(188),
    [anon_sym_nonlocal] = ACTIONS(191),
    [anon_sym_exec] = ACTIONS(194),
    [anon_sym_type] = ACTIONS(197),
    [anon_sym_class] = ACTIONS(268),
    [anon_sym_LBRACK] = ACTIONS(203),
    [anon_sym_AT] = ACTIONS(206),
    [anon_sym_DASH] = ACTIONS(209),
    [anon_sym_LBRACE] = ACTIONS(212),
    [anon_sym_PLUS] = ACTIONS(209),
    [anon_sym_not] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(209),
    [anon_sym_lambda] = ACTIONS(218),
    [anon_sym_yield] = ACTIONS(221),
    [sym_ellipsis] = ACTIONS(224),
    [sym_integer] = ACTIONS(227),
    [sym_float] = ACTIONS(224),
    [anon_sym_await] = ACTIONS(230),
    [sym_true] = ACTIONS(227),
    [sym_false] = ACTIONS(227),
    [sym_none] = ACTIONS(227),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(235),
  },
  [71] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1828),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(271),
    [sym_string_start] = ACTIONS(81),
  },
  [72] = {
    [sym__statement] = STATE(66),
    [sym__simple_statements] = STATE(66),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_if_statement] = STATE(66),
    [sym_match_statement] = STATE(66),
    [sym_for_statement] = STATE(66),
    [sym_while_statement] = STATE(66),
    [sym_try_statement] = STATE(66),
    [sym_with_statement] = STATE(66),
    [sym_function_definition] = STATE(66),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_class_definition] = STATE(66),
    [sym_decorated_definition] = STATE(66),
    [sym_decorator] = STATE(1828),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [aux_sym_module_repeat1] = STATE(66),
    [aux_sym_decorated_definition_repeat1] = STATE(1828),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_match] = ACTIONS(85),
    [anon_sym_async] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(89),
    [anon_sym_while] = ACTIONS(91),
    [anon_sym_try] = ACTIONS(93),
    [anon_sym_with] = ACTIONS(95),
    [anon_sym_def] = ACTIONS(97),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_AT] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(273),
    [sym_string_start] = ACTIONS(81),
  },
  [73] = {
    [sym_named_expression] = STATE(1758),
    [sym__named_expression_lhs] = STATE(2779),
    [sym_list_splat_pattern] = STATE(1433),
    [sym_as_pattern] = STATE(1758),
    [sym_expression] = STATE(1796),
    [sym_primary_expression] = STATE(1002),
    [sym_not_operator] = STATE(1758),
    [sym_boolean_operator] = STATE(1758),
    [sym_binary_operator] = STATE(1365),
    [sym_unary_operator] = STATE(1365),
    [sym_comparison_operator] = STATE(1758),
    [sym_lambda] = STATE(1758),
    [sym_attribute] = STATE(1365),
    [sym_subscript] = STATE(1365),
    [sym_call] = STATE(1365),
    [sym_type] = STATE(2140),
    [sym_splat_type] = STATE(2137),
    [sym_generic_type] = STATE(2137),
    [sym_union_type] = STATE(2137),
    [sym_constrained_type] = STATE(2137),
    [sym_member_type] = STATE(2137),
    [sym_list] = STATE(1365),
    [sym_set] = STATE(1365),
    [sym_tuple] = STATE(1365),
    [sym_dictionary] = STATE(1365),
    [sym_list_comprehension] = STATE(1365),
    [sym_dictionary_comprehension] = STATE(1365),
    [sym_set_comprehension] = STATE(1365),
    [sym_generator_expression] = STATE(1365),
    [sym_parenthesized_expression] = STATE(1365),
    [sym_conditional_expression] = STATE(1758),
    [sym_concatenated_string] = STATE(1365),
    [sym_string] = STATE(1004),
    [sym_await] = STATE(1365),
    [sym_identifier] = ACTIONS(275),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(287),
    [anon_sym_print] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(294),
    [anon_sym_match] = ACTIONS(290),
    [anon_sym_async] = ACTIONS(290),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(297),
    [anon_sym_exec] = ACTIONS(290),
    [anon_sym_type] = ACTIONS(300),
    [anon_sym_EQ] = ACTIONS(302),
    [anon_sym_LBRACK] = ACTIONS(304),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(307),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_PLUS] = ACTIONS(307),
    [anon_sym_not] = ACTIONS(312),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(315),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_lambda] = ACTIONS(317),
    [anon_sym_PLUS_EQ] = ACTIONS(319),
    [anon_sym_DASH_EQ] = ACTIONS(319),
    [anon_sym_STAR_EQ] = ACTIONS(319),
    [anon_sym_SLASH_EQ] = ACTIONS(319),
    [anon_sym_AT_EQ] = ACTIONS(319),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(319),
    [anon_sym_PERCENT_EQ] = ACTIONS(319),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(319),
    [anon_sym_GT_GT_EQ] = ACTIONS(319),
    [anon_sym_LT_LT_EQ] = ACTIONS(319),
    [anon_sym_AMP_EQ] = ACTIONS(319),
    [anon_sym_CARET_EQ] = ACTIONS(319),
    [anon_sym_PIPE_EQ] = ACTIONS(319),
    [sym_ellipsis] = ACTIONS(321),
    [sym_integer] = ACTIONS(323),
    [sym_float] = ACTIONS(321),
    [anon_sym_await] = ACTIONS(325),
    [sym_true] = ACTIONS(323),
    [sym_false] = ACTIONS(323),
    [sym_none] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(327),
  },
  [74] = {
    [sym_named_expression] = STATE(1758),
    [sym__named_expression_lhs] = STATE(2779),
    [sym_list_splat_pattern] = STATE(1433),
    [sym_as_pattern] = STATE(1758),
    [sym_expression] = STATE(1796),
    [sym_primary_expression] = STATE(1002),
    [sym_not_operator] = STATE(1758),
    [sym_boolean_operator] = STATE(1758),
    [sym_binary_operator] = STATE(1365),
    [sym_unary_operator] = STATE(1365),
    [sym_comparison_operator] = STATE(1758),
    [sym_lambda] = STATE(1758),
    [sym_attribute] = STATE(1365),
    [sym_subscript] = STATE(1365),
    [sym_call] = STATE(1365),
    [sym_type] = STATE(2140),
    [sym_splat_type] = STATE(2137),
    [sym_generic_type] = STATE(2137),
    [sym_union_type] = STATE(2137),
    [sym_constrained_type] = STATE(2137),
    [sym_member_type] = STATE(2137),
    [sym_list] = STATE(1365),
    [sym_set] = STATE(1365),
    [sym_tuple] = STATE(1365),
    [sym_dictionary] = STATE(1365),
    [sym_list_comprehension] = STATE(1365),
    [sym_dictionary_comprehension] = STATE(1365),
    [sym_set_comprehension] = STATE(1365),
    [sym_generator_expression] = STATE(1365),
    [sym_parenthesized_expression] = STATE(1365),
    [sym_conditional_expression] = STATE(1758),
    [sym_concatenated_string] = STATE(1365),
    [sym_string] = STATE(1004),
    [sym_await] = STATE(1365),
    [sym_identifier] = ACTIONS(275),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(287),
    [anon_sym_print] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(302),
    [anon_sym_match] = ACTIONS(290),
    [anon_sym_async] = ACTIONS(290),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(297),
    [anon_sym_exec] = ACTIONS(290),
    [anon_sym_type] = ACTIONS(300),
    [anon_sym_EQ] = ACTIONS(302),
    [anon_sym_LBRACK] = ACTIONS(304),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(307),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_PLUS] = ACTIONS(307),
    [anon_sym_not] = ACTIONS(312),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(315),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_lambda] = ACTIONS(317),
    [anon_sym_PLUS_EQ] = ACTIONS(319),
    [anon_sym_DASH_EQ] = ACTIONS(319),
    [anon_sym_STAR_EQ] = ACTIONS(319),
    [anon_sym_SLASH_EQ] = ACTIONS(319),
    [anon_sym_AT_EQ] = ACTIONS(319),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(319),
    [anon_sym_PERCENT_EQ] = ACTIONS(319),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(319),
    [anon_sym_GT_GT_EQ] = ACTIONS(319),
    [anon_sym_LT_LT_EQ] = ACTIONS(319),
    [anon_sym_AMP_EQ] = ACTIONS(319),
    [anon_sym_CARET_EQ] = ACTIONS(319),
    [anon_sym_PIPE_EQ] = ACTIONS(319),
    [sym_ellipsis] = ACTIONS(321),
    [sym_integer] = ACTIONS(323),
    [sym_float] = ACTIONS(321),
    [anon_sym_await] = ACTIONS(325),
    [sym_true] = ACTIONS(323),
    [sym_false] = ACTIONS(323),
    [sym_none] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(327),
  },
  [75] = {
    [sym__simple_statements] = STATE(815),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(629),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1709),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(630),
    [sym_subscript] = STATE(630),
    [sym_call] = STATE(1057),
    [sym_type] = STATE(2063),
    [sym_splat_type] = STATE(2137),
    [sym_generic_type] = STATE(2137),
    [sym_union_type] = STATE(2137),
    [sym_constrained_type] = STATE(2137),
    [sym_member_type] = STATE(2137),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(337),
    [anon_sym_STAR_STAR] = ACTIONS(339),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(341),
    [anon_sym_type] = ACTIONS(343),
    [anon_sym_LBRACK] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(347),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(349),
    [sym__indent] = ACTIONS(351),
    [sym_string_start] = ACTIONS(81),
  },
  [76] = {
    [sym__simple_statements] = STATE(800),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(629),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1709),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(630),
    [sym_subscript] = STATE(630),
    [sym_call] = STATE(1057),
    [sym_type] = STATE(2063),
    [sym_splat_type] = STATE(2137),
    [sym_generic_type] = STATE(2137),
    [sym_union_type] = STATE(2137),
    [sym_constrained_type] = STATE(2137),
    [sym_member_type] = STATE(2137),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(337),
    [anon_sym_STAR_STAR] = ACTIONS(339),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(341),
    [anon_sym_type] = ACTIONS(343),
    [anon_sym_LBRACK] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(347),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(353),
    [sym__indent] = ACTIONS(355),
    [sym_string_start] = ACTIONS(81),
  },
  [77] = {
    [sym__simple_statements] = STATE(802),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(629),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1709),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(630),
    [sym_subscript] = STATE(630),
    [sym_call] = STATE(1057),
    [sym_type] = STATE(2063),
    [sym_splat_type] = STATE(2137),
    [sym_generic_type] = STATE(2137),
    [sym_union_type] = STATE(2137),
    [sym_constrained_type] = STATE(2137),
    [sym_member_type] = STATE(2137),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(337),
    [anon_sym_STAR_STAR] = ACTIONS(339),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(341),
    [anon_sym_type] = ACTIONS(343),
    [anon_sym_LBRACK] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(347),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(357),
    [sym__indent] = ACTIONS(359),
    [sym_string_start] = ACTIONS(81),
  },
  [78] = {
    [sym__simple_statements] = STATE(808),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(629),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1709),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(630),
    [sym_subscript] = STATE(630),
    [sym_call] = STATE(1057),
    [sym_type] = STATE(2063),
    [sym_splat_type] = STATE(2137),
    [sym_generic_type] = STATE(2137),
    [sym_union_type] = STATE(2137),
    [sym_constrained_type] = STATE(2137),
    [sym_member_type] = STATE(2137),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(337),
    [anon_sym_STAR_STAR] = ACTIONS(339),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(341),
    [anon_sym_type] = ACTIONS(343),
    [anon_sym_LBRACK] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(347),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(361),
    [sym__indent] = ACTIONS(363),
    [sym_string_start] = ACTIONS(81),
  },
  [79] = {
    [sym__simple_statements] = STATE(762),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(629),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1709),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(630),
    [sym_subscript] = STATE(630),
    [sym_call] = STATE(1057),
    [sym_type] = STATE(2063),
    [sym_splat_type] = STATE(2137),
    [sym_generic_type] = STATE(2137),
    [sym_union_type] = STATE(2137),
    [sym_constrained_type] = STATE(2137),
    [sym_member_type] = STATE(2137),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(337),
    [anon_sym_STAR_STAR] = ACTIONS(339),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(341),
    [anon_sym_type] = ACTIONS(343),
    [anon_sym_LBRACK] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(347),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(365),
    [sym__indent] = ACTIONS(367),
    [sym_string_start] = ACTIONS(81),
  },
  [80] = {
    [sym__simple_statements] = STATE(812),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(629),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1709),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(630),
    [sym_subscript] = STATE(630),
    [sym_call] = STATE(1057),
    [sym_type] = STATE(2063),
    [sym_splat_type] = STATE(2137),
    [sym_generic_type] = STATE(2137),
    [sym_union_type] = STATE(2137),
    [sym_constrained_type] = STATE(2137),
    [sym_member_type] = STATE(2137),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(337),
    [anon_sym_STAR_STAR] = ACTIONS(339),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(341),
    [anon_sym_type] = ACTIONS(343),
    [anon_sym_LBRACK] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(347),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(369),
    [sym__indent] = ACTIONS(371),
    [sym_string_start] = ACTIONS(81),
  },
  [81] = {
    [sym__simple_statements] = STATE(791),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(629),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1709),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(630),
    [sym_subscript] = STATE(630),
    [sym_call] = STATE(1057),
    [sym_type] = STATE(2063),
    [sym_splat_type] = STATE(2137),
    [sym_generic_type] = STATE(2137),
    [sym_union_type] = STATE(2137),
    [sym_constrained_type] = STATE(2137),
    [sym_member_type] = STATE(2137),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(337),
    [anon_sym_STAR_STAR] = ACTIONS(339),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(341),
    [anon_sym_type] = ACTIONS(343),
    [anon_sym_LBRACK] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(347),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(373),
    [sym__indent] = ACTIONS(375),
    [sym_string_start] = ACTIONS(81),
  },
  [82] = {
    [sym__simple_statements] = STATE(769),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(629),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1709),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(630),
    [sym_subscript] = STATE(630),
    [sym_call] = STATE(1057),
    [sym_type] = STATE(2063),
    [sym_splat_type] = STATE(2137),
    [sym_generic_type] = STATE(2137),
    [sym_union_type] = STATE(2137),
    [sym_constrained_type] = STATE(2137),
    [sym_member_type] = STATE(2137),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_print] = ACTIONS(335),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(337),
    [anon_sym_async] = ACTIONS(337),
    [anon_sym_STAR_STAR] = ACTIONS(339),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(341),
    [anon_sym_type] = ACTIONS(343),
    [anon_sym_LBRACK] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(347),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(377),
    [sym__indent] = ACTIONS(379),
    [sym_string_start] = ACTIONS(81),
  },
  [83] = {
    [sym_chevron] = STATE(2162),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_list_splat_pattern] = STATE(1117),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(977),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_attribute] = STATE(1057),
    [sym_subscript] = STATE(1057),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(383),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(386),
    [anon_sym_print] = ACTIONS(389),
    [anon_sym_GT_GT] = ACTIONS(391),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(302),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(389),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(389),
    [anon_sym_type] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(302),
    [anon_sym_LBRACK] = ACTIONS(395),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(398),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(398),
    [anon_sym_not] = ACTIONS(401),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_PLUS_EQ] = ACTIONS(319),
    [anon_sym_DASH_EQ] = ACTIONS(319),
    [anon_sym_STAR_EQ] = ACTIONS(319),
    [anon_sym_SLASH_EQ] = ACTIONS(319),
    [anon_sym_AT_EQ] = ACTIONS(319),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(319),
    [anon_sym_PERCENT_EQ] = ACTIONS(319),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(319),
    [anon_sym_GT_GT_EQ] = ACTIONS(319),
    [anon_sym_LT_LT_EQ] = ACTIONS(319),
    [anon_sym_AMP_EQ] = ACTIONS(319),
    [anon_sym_CARET_EQ] = ACTIONS(319),
    [anon_sym_PIPE_EQ] = ACTIONS(319),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(404),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(81),
  },
  [84] = {
    [sym_chevron] = STATE(2162),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_list_splat_pattern] = STATE(1117),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1861),
    [sym_primary_expression] = STATE(977),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_attribute] = STATE(1057),
    [sym_subscript] = STATE(1057),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(383),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(386),
    [anon_sym_print] = ACTIONS(389),
    [anon_sym_GT_GT] = ACTIONS(391),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(294),
    [anon_sym_match] = ACTIONS(389),
    [anon_sym_async] = ACTIONS(389),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(389),
    [anon_sym_type] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(302),
    [anon_sym_LBRACK] = ACTIONS(395),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(398),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(398),
    [anon_sym_not] = ACTIONS(401),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_PLUS_EQ] = ACTIONS(319),
    [anon_sym_DASH_EQ] = ACTIONS(319),
    [anon_sym_STAR_EQ] = ACTIONS(319),
    [anon_sym_SLASH_EQ] = ACTIONS(319),
    [anon_sym_AT_EQ] = ACTIONS(319),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(319),
    [anon_sym_PERCENT_EQ] = ACTIONS(319),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(319),
    [anon_sym_GT_GT_EQ] = ACTIONS(319),
    [anon_sym_LT_LT_EQ] = ACTIONS(319),
    [anon_sym_AMP_EQ] = ACTIONS(319),
    [anon_sym_CARET_EQ] = ACTIONS(319),
    [anon_sym_PIPE_EQ] = ACTIONS(319),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(404),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(81),
  },
  [85] = {
    [sym_named_expression] = STATE(1758),
    [sym__named_expression_lhs] = STATE(2779),
    [sym_list_splat_pattern] = STATE(1433),
    [sym_as_pattern] = STATE(1758),
    [sym_expression] = STATE(1871),
    [sym_primary_expression] = STATE(1002),
    [sym_not_operator] = STATE(1758),
    [sym_boolean_operator] = STATE(1758),
    [sym_binary_operator] = STATE(1365),
    [sym_unary_operator] = STATE(1365),
    [sym_comparison_operator] = STATE(1758),
    [sym_lambda] = STATE(1758),
    [sym_attribute] = STATE(1365),
    [sym_subscript] = STATE(1365),
    [sym_call] = STATE(1365),
    [sym_list] = STATE(1365),
    [sym_set] = STATE(1365),
    [sym_tuple] = STATE(1365),
    [sym_dictionary] = STATE(1365),
    [sym_list_comprehension] = STATE(1365),
    [sym_dictionary_comprehension] = STATE(1365),
    [sym_set_comprehension] = STATE(1365),
    [sym_generator_expression] = STATE(1365),
    [sym_parenthesized_expression] = STATE(1365),
    [sym_conditional_expression] = STATE(1758),
    [sym_concatenated_string] = STATE(1365),
    [sym_string] = STATE(1004),
    [sym_await] = STATE(1365),
    [sym_identifier] = ACTIONS(406),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(408),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(410),
    [anon_sym_print] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(302),
    [anon_sym_match] = ACTIONS(290),
    [anon_sym_async] = ACTIONS(290),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(290),
    [anon_sym_type] = ACTIONS(300),
    [anon_sym_EQ] = ACTIONS(302),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_not] = ACTIONS(416),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(315),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_lambda] = ACTIONS(317),
    [anon_sym_PLUS_EQ] = ACTIONS(319),
    [anon_sym_DASH_EQ] = ACTIONS(319),
    [anon_sym_STAR_EQ] = ACTIONS(319),
    [anon_sym_SLASH_EQ] = ACTIONS(319),
    [anon_sym_AT_EQ] = ACTIONS(319),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(319),
    [anon_sym_PERCENT_EQ] = ACTIONS(319),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(319),
    [anon_sym_GT_GT_EQ] = ACTIONS(319),
    [anon_sym_LT_LT_EQ] = ACTIONS(319),
    [anon_sym_AMP_EQ] = ACTIONS(319),
    [anon_sym_CARET_EQ] = ACTIONS(319),
    [anon_sym_PIPE_EQ] = ACTIONS(319),
    [sym_ellipsis] = ACTIONS(321),
    [sym_integer] = ACTIONS(323),
    [sym_float] = ACTIONS(321),
    [anon_sym_await] = ACTIONS(325),
    [sym_true] = ACTIONS(323),
    [sym_false] = ACTIONS(323),
    [sym_none] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(327),
  },
  [86] = {
    [sym_named_expression] = STATE(1758),
    [sym__named_expression_lhs] = STATE(2779),
    [sym_list_splat_pattern] = STATE(1433),
    [sym_as_pattern] = STATE(1758),
    [sym_expression] = STATE(1878),
    [sym_primary_expression] = STATE(1002),
    [sym_not_operator] = STATE(1758),
    [sym_boolean_operator] = STATE(1758),
    [sym_binary_operator] = STATE(1365),
    [sym_unary_operator] = STATE(1365),
    [sym_comparison_operator] = STATE(1758),
    [sym_lambda] = STATE(1758),
    [sym_attribute] = STATE(1365),
    [sym_subscript] = STATE(1365),
    [sym_call] = STATE(1365),
    [sym_list] = STATE(1365),
    [sym_set] = STATE(1365),
    [sym_tuple] = STATE(1365),
    [sym_dictionary] = STATE(1365),
    [sym_list_comprehension] = STATE(1365),
    [sym_dictionary_comprehension] = STATE(1365),
    [sym_set_comprehension] = STATE(1365),
    [sym_generator_expression] = STATE(1365),
    [sym_parenthesized_expression] = STATE(1365),
    [sym_conditional_expression] = STATE(1758),
    [sym_concatenated_string] = STATE(1365),
    [sym_string] = STATE(1004),
    [sym_await] = STATE(1365),
    [sym_identifier] = ACTIONS(406),
    [anon_sym_SEMI] = ACTIONS(277),
    [anon_sym_DOT] = ACTIONS(279),
    [anon_sym_LPAREN] = ACTIONS(408),
    [anon_sym_COMMA] = ACTIONS(284),
    [anon_sym_as] = ACTIONS(279),
    [anon_sym_STAR] = ACTIONS(410),
    [anon_sym_print] = ACTIONS(290),
    [anon_sym_GT_GT] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(292),
    [anon_sym_if] = ACTIONS(279),
    [anon_sym_COLON] = ACTIONS(302),
    [anon_sym_match] = ACTIONS(290),
    [anon_sym_async] = ACTIONS(290),
    [anon_sym_in] = ACTIONS(279),
    [anon_sym_STAR_STAR] = ACTIONS(279),
    [anon_sym_exec] = ACTIONS(290),
    [anon_sym_type] = ACTIONS(300),
    [anon_sym_EQ] = ACTIONS(302),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_AT] = ACTIONS(279),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_PIPE] = ACTIONS(279),
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_not] = ACTIONS(416),
    [anon_sym_and] = ACTIONS(279),
    [anon_sym_or] = ACTIONS(279),
    [anon_sym_SLASH] = ACTIONS(279),
    [anon_sym_PERCENT] = ACTIONS(279),
    [anon_sym_SLASH_SLASH] = ACTIONS(279),
    [anon_sym_AMP] = ACTIONS(279),
    [anon_sym_CARET] = ACTIONS(279),
    [anon_sym_LT_LT] = ACTIONS(279),
    [anon_sym_TILDE] = ACTIONS(315),
    [anon_sym_LT] = ACTIONS(279),
    [anon_sym_LT_EQ] = ACTIONS(277),
    [anon_sym_EQ_EQ] = ACTIONS(277),
    [anon_sym_BANG_EQ] = ACTIONS(277),
    [anon_sym_GT_EQ] = ACTIONS(277),
    [anon_sym_GT] = ACTIONS(279),
    [anon_sym_LT_GT] = ACTIONS(277),
    [anon_sym_is] = ACTIONS(279),
    [anon_sym_lambda] = ACTIONS(317),
    [anon_sym_PLUS_EQ] = ACTIONS(319),
    [anon_sym_DASH_EQ] = ACTIONS(319),
    [anon_sym_STAR_EQ] = ACTIONS(319),
    [anon_sym_SLASH_EQ] = ACTIONS(319),
    [anon_sym_AT_EQ] = ACTIONS(319),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(319),
    [anon_sym_PERCENT_EQ] = ACTIONS(319),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(319),
    [anon_sym_GT_GT_EQ] = ACTIONS(319),
    [anon_sym_LT_LT_EQ] = ACTIONS(319),
    [anon_sym_AMP_EQ] = ACTIONS(319),
    [anon_sym_CARET_EQ] = ACTIONS(319),
    [anon_sym_PIPE_EQ] = ACTIONS(319),
    [sym_ellipsis] = ACTIONS(321),
    [sym_integer] = ACTIONS(323),
    [sym_float] = ACTIONS(321),
    [anon_sym_await] = ACTIONS(325),
    [sym_true] = ACTIONS(323),
    [sym_false] = ACTIONS(323),
    [sym_none] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(277),
    [sym_string_start] = ACTIONS(327),
  },
  [87] = {
    [sym__simple_statements] = STATE(696),
    [sym_import_statement] = STATE(2365),
    [sym_future_import_statement] = STATE(2365),
    [sym_import_from_statement] = STATE(2365),
    [sym_print_statement] = STATE(2365),
    [sym_assert_statement] = STATE(2365),
    [sym_expression_statement] = STATE(2365),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2365),
    [sym_delete_statement] = STATE(2365),
    [sym_raise_statement] = STATE(2365),
    [sym_pass_statement] = STATE(2365),
    [sym_break_statement] = STATE(2365),
    [sym_continue_statement] = STATE(2365),
    [sym_global_statement] = STATE(2365),
    [sym_nonlocal_statement] = STATE(2365),
    [sym_exec_statement] = STATE(2365),
    [sym_type_alias_statement] = STATE(2365),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(420),
    [sym__indent] = ACTIONS(422),
    [sym_string_start] = ACTIONS(81),
  },
  [88] = {
    [sym__simple_statements] = STATE(794),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(424),
    [sym__indent] = ACTIONS(426),
    [sym_string_start] = ACTIONS(81),
  },
  [89] = {
    [sym__simple_statements] = STATE(659),
    [sym_import_statement] = STATE(2365),
    [sym_future_import_statement] = STATE(2365),
    [sym_import_from_statement] = STATE(2365),
    [sym_print_statement] = STATE(2365),
    [sym_assert_statement] = STATE(2365),
    [sym_expression_statement] = STATE(2365),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2365),
    [sym_delete_statement] = STATE(2365),
    [sym_raise_statement] = STATE(2365),
    [sym_pass_statement] = STATE(2365),
    [sym_break_statement] = STATE(2365),
    [sym_continue_statement] = STATE(2365),
    [sym_global_statement] = STATE(2365),
    [sym_nonlocal_statement] = STATE(2365),
    [sym_exec_statement] = STATE(2365),
    [sym_type_alias_statement] = STATE(2365),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(428),
    [sym__indent] = ACTIONS(430),
    [sym_string_start] = ACTIONS(81),
  },
  [90] = {
    [sym__simple_statements] = STATE(2528),
    [sym_import_statement] = STATE(2522),
    [sym_future_import_statement] = STATE(2522),
    [sym_import_from_statement] = STATE(2522),
    [sym_print_statement] = STATE(2522),
    [sym_assert_statement] = STATE(2522),
    [sym_expression_statement] = STATE(2522),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2522),
    [sym_delete_statement] = STATE(2522),
    [sym_raise_statement] = STATE(2522),
    [sym_pass_statement] = STATE(2522),
    [sym_break_statement] = STATE(2522),
    [sym_continue_statement] = STATE(2522),
    [sym_global_statement] = STATE(2522),
    [sym_nonlocal_statement] = STATE(2522),
    [sym_exec_statement] = STATE(2522),
    [sym_type_alias_statement] = STATE(2522),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(432),
    [sym__indent] = ACTIONS(434),
    [sym_string_start] = ACTIONS(81),
  },
  [91] = {
    [sym__simple_statements] = STATE(756),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(436),
    [sym__indent] = ACTIONS(438),
    [sym_string_start] = ACTIONS(81),
  },
  [92] = {
    [sym__simple_statements] = STATE(710),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(440),
    [sym__indent] = ACTIONS(442),
    [sym_string_start] = ACTIONS(81),
  },
  [93] = {
    [sym__simple_statements] = STATE(663),
    [sym_import_statement] = STATE(2425),
    [sym_future_import_statement] = STATE(2425),
    [sym_import_from_statement] = STATE(2425),
    [sym_print_statement] = STATE(2425),
    [sym_assert_statement] = STATE(2425),
    [sym_expression_statement] = STATE(2425),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2425),
    [sym_delete_statement] = STATE(2425),
    [sym_raise_statement] = STATE(2425),
    [sym_pass_statement] = STATE(2425),
    [sym_break_statement] = STATE(2425),
    [sym_continue_statement] = STATE(2425),
    [sym_global_statement] = STATE(2425),
    [sym_nonlocal_statement] = STATE(2425),
    [sym_exec_statement] = STATE(2425),
    [sym_type_alias_statement] = STATE(2425),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(444),
    [sym__indent] = ACTIONS(446),
    [sym_string_start] = ACTIONS(81),
  },
  [94] = {
    [sym__simple_statements] = STATE(713),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(448),
    [sym__indent] = ACTIONS(450),
    [sym_string_start] = ACTIONS(81),
  },
  [95] = {
    [sym__simple_statements] = STATE(722),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(452),
    [sym__indent] = ACTIONS(454),
    [sym_string_start] = ACTIONS(81),
  },
  [96] = {
    [sym__simple_statements] = STATE(846),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(456),
    [sym__indent] = ACTIONS(458),
    [sym_string_start] = ACTIONS(81),
  },
  [97] = {
    [sym__simple_statements] = STATE(662),
    [sym_import_statement] = STATE(2477),
    [sym_future_import_statement] = STATE(2477),
    [sym_import_from_statement] = STATE(2477),
    [sym_print_statement] = STATE(2477),
    [sym_assert_statement] = STATE(2477),
    [sym_expression_statement] = STATE(2477),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2477),
    [sym_delete_statement] = STATE(2477),
    [sym_raise_statement] = STATE(2477),
    [sym_pass_statement] = STATE(2477),
    [sym_break_statement] = STATE(2477),
    [sym_continue_statement] = STATE(2477),
    [sym_global_statement] = STATE(2477),
    [sym_nonlocal_statement] = STATE(2477),
    [sym_exec_statement] = STATE(2477),
    [sym_type_alias_statement] = STATE(2477),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(460),
    [sym__indent] = ACTIONS(462),
    [sym_string_start] = ACTIONS(81),
  },
  [98] = {
    [sym__simple_statements] = STATE(778),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(464),
    [sym__indent] = ACTIONS(466),
    [sym_string_start] = ACTIONS(81),
  },
  [99] = {
    [sym__simple_statements] = STATE(830),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(468),
    [sym__indent] = ACTIONS(470),
    [sym_string_start] = ACTIONS(81),
  },
  [100] = {
    [sym__simple_statements] = STATE(610),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(472),
    [sym__indent] = ACTIONS(474),
    [sym_string_start] = ACTIONS(81),
  },
  [101] = {
    [sym__simple_statements] = STATE(776),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(476),
    [sym__indent] = ACTIONS(478),
    [sym_string_start] = ACTIONS(81),
  },
  [102] = {
    [sym__simple_statements] = STATE(735),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(480),
    [sym__indent] = ACTIONS(482),
    [sym_string_start] = ACTIONS(81),
  },
  [103] = {
    [sym__simple_statements] = STATE(765),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(484),
    [sym__indent] = ACTIONS(486),
    [sym_string_start] = ACTIONS(81),
  },
  [104] = {
    [sym__simple_statements] = STATE(654),
    [sym_import_statement] = STATE(2477),
    [sym_future_import_statement] = STATE(2477),
    [sym_import_from_statement] = STATE(2477),
    [sym_print_statement] = STATE(2477),
    [sym_assert_statement] = STATE(2477),
    [sym_expression_statement] = STATE(2477),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2477),
    [sym_delete_statement] = STATE(2477),
    [sym_raise_statement] = STATE(2477),
    [sym_pass_statement] = STATE(2477),
    [sym_break_statement] = STATE(2477),
    [sym_continue_statement] = STATE(2477),
    [sym_global_statement] = STATE(2477),
    [sym_nonlocal_statement] = STATE(2477),
    [sym_exec_statement] = STATE(2477),
    [sym_type_alias_statement] = STATE(2477),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(488),
    [sym__indent] = ACTIONS(490),
    [sym_string_start] = ACTIONS(81),
  },
  [105] = {
    [sym__simple_statements] = STATE(719),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(492),
    [sym__indent] = ACTIONS(494),
    [sym_string_start] = ACTIONS(81),
  },
  [106] = {
    [sym__simple_statements] = STATE(759),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(496),
    [sym__indent] = ACTIONS(498),
    [sym_string_start] = ACTIONS(81),
  },
  [107] = {
    [sym__simple_statements] = STATE(1830),
    [sym_import_statement] = STATE(2287),
    [sym_future_import_statement] = STATE(2287),
    [sym_import_from_statement] = STATE(2287),
    [sym_print_statement] = STATE(2287),
    [sym_assert_statement] = STATE(2287),
    [sym_expression_statement] = STATE(2287),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2287),
    [sym_delete_statement] = STATE(2287),
    [sym_raise_statement] = STATE(2287),
    [sym_pass_statement] = STATE(2287),
    [sym_break_statement] = STATE(2287),
    [sym_continue_statement] = STATE(2287),
    [sym_global_statement] = STATE(2287),
    [sym_nonlocal_statement] = STATE(2287),
    [sym_exec_statement] = STATE(2287),
    [sym_type_alias_statement] = STATE(2287),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(500),
    [sym__indent] = ACTIONS(502),
    [sym_string_start] = ACTIONS(81),
  },
  [108] = {
    [sym__simple_statements] = STATE(751),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(504),
    [sym__indent] = ACTIONS(506),
    [sym_string_start] = ACTIONS(81),
  },
  [109] = {
    [sym__simple_statements] = STATE(760),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(508),
    [sym__indent] = ACTIONS(510),
    [sym_string_start] = ACTIONS(81),
  },
  [110] = {
    [sym__simple_statements] = STATE(1841),
    [sym_import_statement] = STATE(2287),
    [sym_future_import_statement] = STATE(2287),
    [sym_import_from_statement] = STATE(2287),
    [sym_print_statement] = STATE(2287),
    [sym_assert_statement] = STATE(2287),
    [sym_expression_statement] = STATE(2287),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2287),
    [sym_delete_statement] = STATE(2287),
    [sym_raise_statement] = STATE(2287),
    [sym_pass_statement] = STATE(2287),
    [sym_break_statement] = STATE(2287),
    [sym_continue_statement] = STATE(2287),
    [sym_global_statement] = STATE(2287),
    [sym_nonlocal_statement] = STATE(2287),
    [sym_exec_statement] = STATE(2287),
    [sym_type_alias_statement] = STATE(2287),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(512),
    [sym__indent] = ACTIONS(514),
    [sym_string_start] = ACTIONS(81),
  },
  [111] = {
    [sym__simple_statements] = STATE(750),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(516),
    [sym__indent] = ACTIONS(518),
    [sym_string_start] = ACTIONS(81),
  },
  [112] = {
    [sym__simple_statements] = STATE(701),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(520),
    [sym__indent] = ACTIONS(522),
    [sym_string_start] = ACTIONS(81),
  },
  [113] = {
    [sym__simple_statements] = STATE(748),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(524),
    [sym__indent] = ACTIONS(526),
    [sym_string_start] = ACTIONS(81),
  },
  [114] = {
    [sym__simple_statements] = STATE(711),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(528),
    [sym__indent] = ACTIONS(530),
    [sym_string_start] = ACTIONS(81),
  },
  [115] = {
    [sym__simple_statements] = STATE(2550),
    [sym_import_statement] = STATE(2522),
    [sym_future_import_statement] = STATE(2522),
    [sym_import_from_statement] = STATE(2522),
    [sym_print_statement] = STATE(2522),
    [sym_assert_statement] = STATE(2522),
    [sym_expression_statement] = STATE(2522),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2522),
    [sym_delete_statement] = STATE(2522),
    [sym_raise_statement] = STATE(2522),
    [sym_pass_statement] = STATE(2522),
    [sym_break_statement] = STATE(2522),
    [sym_continue_statement] = STATE(2522),
    [sym_global_statement] = STATE(2522),
    [sym_nonlocal_statement] = STATE(2522),
    [sym_exec_statement] = STATE(2522),
    [sym_type_alias_statement] = STATE(2522),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(532),
    [sym__indent] = ACTIONS(534),
    [sym_string_start] = ACTIONS(81),
  },
  [116] = {
    [sym__simple_statements] = STATE(2547),
    [sym_import_statement] = STATE(2522),
    [sym_future_import_statement] = STATE(2522),
    [sym_import_from_statement] = STATE(2522),
    [sym_print_statement] = STATE(2522),
    [sym_assert_statement] = STATE(2522),
    [sym_expression_statement] = STATE(2522),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2522),
    [sym_delete_statement] = STATE(2522),
    [sym_raise_statement] = STATE(2522),
    [sym_pass_statement] = STATE(2522),
    [sym_break_statement] = STATE(2522),
    [sym_continue_statement] = STATE(2522),
    [sym_global_statement] = STATE(2522),
    [sym_nonlocal_statement] = STATE(2522),
    [sym_exec_statement] = STATE(2522),
    [sym_type_alias_statement] = STATE(2522),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(536),
    [sym__indent] = ACTIONS(538),
    [sym_string_start] = ACTIONS(81),
  },
  [117] = {
    [sym__simple_statements] = STATE(737),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(540),
    [sym__indent] = ACTIONS(542),
    [sym_string_start] = ACTIONS(81),
  },
  [118] = {
    [sym__simple_statements] = STATE(675),
    [sym_import_statement] = STATE(2365),
    [sym_future_import_statement] = STATE(2365),
    [sym_import_from_statement] = STATE(2365),
    [sym_print_statement] = STATE(2365),
    [sym_assert_statement] = STATE(2365),
    [sym_expression_statement] = STATE(2365),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2365),
    [sym_delete_statement] = STATE(2365),
    [sym_raise_statement] = STATE(2365),
    [sym_pass_statement] = STATE(2365),
    [sym_break_statement] = STATE(2365),
    [sym_continue_statement] = STATE(2365),
    [sym_global_statement] = STATE(2365),
    [sym_nonlocal_statement] = STATE(2365),
    [sym_exec_statement] = STATE(2365),
    [sym_type_alias_statement] = STATE(2365),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(544),
    [sym__indent] = ACTIONS(546),
    [sym_string_start] = ACTIONS(81),
  },
  [119] = {
    [sym__simple_statements] = STATE(2593),
    [sym_import_statement] = STATE(2522),
    [sym_future_import_statement] = STATE(2522),
    [sym_import_from_statement] = STATE(2522),
    [sym_print_statement] = STATE(2522),
    [sym_assert_statement] = STATE(2522),
    [sym_expression_statement] = STATE(2522),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2522),
    [sym_delete_statement] = STATE(2522),
    [sym_raise_statement] = STATE(2522),
    [sym_pass_statement] = STATE(2522),
    [sym_break_statement] = STATE(2522),
    [sym_continue_statement] = STATE(2522),
    [sym_global_statement] = STATE(2522),
    [sym_nonlocal_statement] = STATE(2522),
    [sym_exec_statement] = STATE(2522),
    [sym_type_alias_statement] = STATE(2522),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(548),
    [sym__indent] = ACTIONS(550),
    [sym_string_start] = ACTIONS(81),
  },
  [120] = {
    [sym__simple_statements] = STATE(2598),
    [sym_import_statement] = STATE(2522),
    [sym_future_import_statement] = STATE(2522),
    [sym_import_from_statement] = STATE(2522),
    [sym_print_statement] = STATE(2522),
    [sym_assert_statement] = STATE(2522),
    [sym_expression_statement] = STATE(2522),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2522),
    [sym_delete_statement] = STATE(2522),
    [sym_raise_statement] = STATE(2522),
    [sym_pass_statement] = STATE(2522),
    [sym_break_statement] = STATE(2522),
    [sym_continue_statement] = STATE(2522),
    [sym_global_statement] = STATE(2522),
    [sym_nonlocal_statement] = STATE(2522),
    [sym_exec_statement] = STATE(2522),
    [sym_type_alias_statement] = STATE(2522),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(552),
    [sym__indent] = ACTIONS(554),
    [sym_string_start] = ACTIONS(81),
  },
  [121] = {
    [sym__simple_statements] = STATE(772),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(556),
    [sym__indent] = ACTIONS(558),
    [sym_string_start] = ACTIONS(81),
  },
  [122] = {
    [sym__simple_statements] = STATE(780),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(560),
    [sym__indent] = ACTIONS(562),
    [sym_string_start] = ACTIONS(81),
  },
  [123] = {
    [sym__simple_statements] = STATE(716),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(564),
    [sym__indent] = ACTIONS(566),
    [sym_string_start] = ACTIONS(81),
  },
  [124] = {
    [sym__simple_statements] = STATE(617),
    [sym_import_statement] = STATE(2303),
    [sym_future_import_statement] = STATE(2303),
    [sym_import_from_statement] = STATE(2303),
    [sym_print_statement] = STATE(2303),
    [sym_assert_statement] = STATE(2303),
    [sym_expression_statement] = STATE(2303),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2303),
    [sym_delete_statement] = STATE(2303),
    [sym_raise_statement] = STATE(2303),
    [sym_pass_statement] = STATE(2303),
    [sym_break_statement] = STATE(2303),
    [sym_continue_statement] = STATE(2303),
    [sym_global_statement] = STATE(2303),
    [sym_nonlocal_statement] = STATE(2303),
    [sym_exec_statement] = STATE(2303),
    [sym_type_alias_statement] = STATE(2303),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(568),
    [sym__indent] = ACTIONS(570),
    [sym_string_start] = ACTIONS(81),
  },
  [125] = {
    [sym__simple_statements] = STATE(843),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(572),
    [sym__indent] = ACTIONS(574),
    [sym_string_start] = ACTIONS(81),
  },
  [126] = {
    [sym__simple_statements] = STATE(833),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(576),
    [sym__indent] = ACTIONS(578),
    [sym_string_start] = ACTIONS(81),
  },
  [127] = {
    [sym__simple_statements] = STATE(2555),
    [sym_import_statement] = STATE(2522),
    [sym_future_import_statement] = STATE(2522),
    [sym_import_from_statement] = STATE(2522),
    [sym_print_statement] = STATE(2522),
    [sym_assert_statement] = STATE(2522),
    [sym_expression_statement] = STATE(2522),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2522),
    [sym_delete_statement] = STATE(2522),
    [sym_raise_statement] = STATE(2522),
    [sym_pass_statement] = STATE(2522),
    [sym_break_statement] = STATE(2522),
    [sym_continue_statement] = STATE(2522),
    [sym_global_statement] = STATE(2522),
    [sym_nonlocal_statement] = STATE(2522),
    [sym_exec_statement] = STATE(2522),
    [sym_type_alias_statement] = STATE(2522),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(580),
    [sym__indent] = ACTIONS(582),
    [sym_string_start] = ACTIONS(81),
  },
  [128] = {
    [sym__simple_statements] = STATE(705),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(584),
    [sym__indent] = ACTIONS(586),
    [sym_string_start] = ACTIONS(81),
  },
  [129] = {
    [sym__simple_statements] = STATE(805),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(588),
    [sym__indent] = ACTIONS(590),
    [sym_string_start] = ACTIONS(81),
  },
  [130] = {
    [sym__simple_statements] = STATE(717),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(592),
    [sym__indent] = ACTIONS(594),
    [sym_string_start] = ACTIONS(81),
  },
  [131] = {
    [sym__simple_statements] = STATE(724),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(596),
    [sym__indent] = ACTIONS(598),
    [sym_string_start] = ACTIONS(81),
  },
  [132] = {
    [sym__simple_statements] = STATE(816),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(600),
    [sym__indent] = ACTIONS(602),
    [sym_string_start] = ACTIONS(81),
  },
  [133] = {
    [sym__simple_statements] = STATE(698),
    [sym_import_statement] = STATE(2462),
    [sym_future_import_statement] = STATE(2462),
    [sym_import_from_statement] = STATE(2462),
    [sym_print_statement] = STATE(2462),
    [sym_assert_statement] = STATE(2462),
    [sym_expression_statement] = STATE(2462),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2462),
    [sym_delete_statement] = STATE(2462),
    [sym_raise_statement] = STATE(2462),
    [sym_pass_statement] = STATE(2462),
    [sym_break_statement] = STATE(2462),
    [sym_continue_statement] = STATE(2462),
    [sym_global_statement] = STATE(2462),
    [sym_nonlocal_statement] = STATE(2462),
    [sym_exec_statement] = STATE(2462),
    [sym_type_alias_statement] = STATE(2462),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(604),
    [sym__indent] = ACTIONS(606),
    [sym_string_start] = ACTIONS(81),
  },
  [134] = {
    [sym__simple_statements] = STATE(838),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(608),
    [sym__indent] = ACTIONS(610),
    [sym_string_start] = ACTIONS(81),
  },
  [135] = {
    [sym__simple_statements] = STATE(671),
    [sym_import_statement] = STATE(2477),
    [sym_future_import_statement] = STATE(2477),
    [sym_import_from_statement] = STATE(2477),
    [sym_print_statement] = STATE(2477),
    [sym_assert_statement] = STATE(2477),
    [sym_expression_statement] = STATE(2477),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2477),
    [sym_delete_statement] = STATE(2477),
    [sym_raise_statement] = STATE(2477),
    [sym_pass_statement] = STATE(2477),
    [sym_break_statement] = STATE(2477),
    [sym_continue_statement] = STATE(2477),
    [sym_global_statement] = STATE(2477),
    [sym_nonlocal_statement] = STATE(2477),
    [sym_exec_statement] = STATE(2477),
    [sym_type_alias_statement] = STATE(2477),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(612),
    [sym__indent] = ACTIONS(614),
    [sym_string_start] = ACTIONS(81),
  },
  [136] = {
    [sym__simple_statements] = STATE(834),
    [sym_import_statement] = STATE(2289),
    [sym_future_import_statement] = STATE(2289),
    [sym_import_from_statement] = STATE(2289),
    [sym_print_statement] = STATE(2289),
    [sym_assert_statement] = STATE(2289),
    [sym_expression_statement] = STATE(2289),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2289),
    [sym_delete_statement] = STATE(2289),
    [sym_raise_statement] = STATE(2289),
    [sym_pass_statement] = STATE(2289),
    [sym_break_statement] = STATE(2289),
    [sym_continue_statement] = STATE(2289),
    [sym_global_statement] = STATE(2289),
    [sym_nonlocal_statement] = STATE(2289),
    [sym_exec_statement] = STATE(2289),
    [sym_type_alias_statement] = STATE(2289),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(616),
    [sym__indent] = ACTIONS(618),
    [sym_string_start] = ACTIONS(81),
  },
  [137] = {
    [sym_import_statement] = STATE(2615),
    [sym_future_import_statement] = STATE(2615),
    [sym_import_from_statement] = STATE(2615),
    [sym_print_statement] = STATE(2615),
    [sym_assert_statement] = STATE(2615),
    [sym_expression_statement] = STATE(2615),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2615),
    [sym_delete_statement] = STATE(2615),
    [sym_raise_statement] = STATE(2615),
    [sym_pass_statement] = STATE(2615),
    [sym_break_statement] = STATE(2615),
    [sym_continue_statement] = STATE(2615),
    [sym_global_statement] = STATE(2615),
    [sym_nonlocal_statement] = STATE(2615),
    [sym_exec_statement] = STATE(2615),
    [sym_type_alias_statement] = STATE(2615),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(620),
    [sym_string_start] = ACTIONS(81),
  },
  [138] = {
    [sym_import_statement] = STATE(2615),
    [sym_future_import_statement] = STATE(2615),
    [sym_import_from_statement] = STATE(2615),
    [sym_print_statement] = STATE(2615),
    [sym_assert_statement] = STATE(2615),
    [sym_expression_statement] = STATE(2615),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2615),
    [sym_delete_statement] = STATE(2615),
    [sym_raise_statement] = STATE(2615),
    [sym_pass_statement] = STATE(2615),
    [sym_break_statement] = STATE(2615),
    [sym_continue_statement] = STATE(2615),
    [sym_global_statement] = STATE(2615),
    [sym_nonlocal_statement] = STATE(2615),
    [sym_exec_statement] = STATE(2615),
    [sym_type_alias_statement] = STATE(2615),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(622),
    [sym_string_start] = ACTIONS(81),
  },
  [139] = {
    [sym_import_statement] = STATE(2615),
    [sym_future_import_statement] = STATE(2615),
    [sym_import_from_statement] = STATE(2615),
    [sym_print_statement] = STATE(2615),
    [sym_assert_statement] = STATE(2615),
    [sym_expression_statement] = STATE(2615),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2615),
    [sym_delete_statement] = STATE(2615),
    [sym_raise_statement] = STATE(2615),
    [sym_pass_statement] = STATE(2615),
    [sym_break_statement] = STATE(2615),
    [sym_continue_statement] = STATE(2615),
    [sym_global_statement] = STATE(2615),
    [sym_nonlocal_statement] = STATE(2615),
    [sym_exec_statement] = STATE(2615),
    [sym_type_alias_statement] = STATE(2615),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(624),
    [sym_string_start] = ACTIONS(81),
  },
  [140] = {
    [sym_import_statement] = STATE(2615),
    [sym_future_import_statement] = STATE(2615),
    [sym_import_from_statement] = STATE(2615),
    [sym_print_statement] = STATE(2615),
    [sym_assert_statement] = STATE(2615),
    [sym_expression_statement] = STATE(2615),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2615),
    [sym_delete_statement] = STATE(2615),
    [sym_raise_statement] = STATE(2615),
    [sym_pass_statement] = STATE(2615),
    [sym_break_statement] = STATE(2615),
    [sym_continue_statement] = STATE(2615),
    [sym_global_statement] = STATE(2615),
    [sym_nonlocal_statement] = STATE(2615),
    [sym_exec_statement] = STATE(2615),
    [sym_type_alias_statement] = STATE(2615),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(626),
    [sym_string_start] = ACTIONS(81),
  },
  [141] = {
    [sym_import_statement] = STATE(2615),
    [sym_future_import_statement] = STATE(2615),
    [sym_import_from_statement] = STATE(2615),
    [sym_print_statement] = STATE(2615),
    [sym_assert_statement] = STATE(2615),
    [sym_expression_statement] = STATE(2615),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2615),
    [sym_delete_statement] = STATE(2615),
    [sym_raise_statement] = STATE(2615),
    [sym_pass_statement] = STATE(2615),
    [sym_break_statement] = STATE(2615),
    [sym_continue_statement] = STATE(2615),
    [sym_global_statement] = STATE(2615),
    [sym_nonlocal_statement] = STATE(2615),
    [sym_exec_statement] = STATE(2615),
    [sym_type_alias_statement] = STATE(2615),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(628),
    [sym_string_start] = ACTIONS(81),
  },
  [142] = {
    [sym_import_statement] = STATE(2615),
    [sym_future_import_statement] = STATE(2615),
    [sym_import_from_statement] = STATE(2615),
    [sym_print_statement] = STATE(2615),
    [sym_assert_statement] = STATE(2615),
    [sym_expression_statement] = STATE(2615),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2615),
    [sym_delete_statement] = STATE(2615),
    [sym_raise_statement] = STATE(2615),
    [sym_pass_statement] = STATE(2615),
    [sym_break_statement] = STATE(2615),
    [sym_continue_statement] = STATE(2615),
    [sym_global_statement] = STATE(2615),
    [sym_nonlocal_statement] = STATE(2615),
    [sym_exec_statement] = STATE(2615),
    [sym_type_alias_statement] = STATE(2615),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(630),
    [sym_string_start] = ACTIONS(81),
  },
  [143] = {
    [sym_import_statement] = STATE(2615),
    [sym_future_import_statement] = STATE(2615),
    [sym_import_from_statement] = STATE(2615),
    [sym_print_statement] = STATE(2615),
    [sym_assert_statement] = STATE(2615),
    [sym_expression_statement] = STATE(2615),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2615),
    [sym_delete_statement] = STATE(2615),
    [sym_raise_statement] = STATE(2615),
    [sym_pass_statement] = STATE(2615),
    [sym_break_statement] = STATE(2615),
    [sym_continue_statement] = STATE(2615),
    [sym_global_statement] = STATE(2615),
    [sym_nonlocal_statement] = STATE(2615),
    [sym_exec_statement] = STATE(2615),
    [sym_type_alias_statement] = STATE(2615),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(632),
    [sym_string_start] = ACTIONS(81),
  },
  [144] = {
    [sym_import_statement] = STATE(2615),
    [sym_future_import_statement] = STATE(2615),
    [sym_import_from_statement] = STATE(2615),
    [sym_print_statement] = STATE(2615),
    [sym_assert_statement] = STATE(2615),
    [sym_expression_statement] = STATE(2615),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2615),
    [sym_delete_statement] = STATE(2615),
    [sym_raise_statement] = STATE(2615),
    [sym_pass_statement] = STATE(2615),
    [sym_break_statement] = STATE(2615),
    [sym_continue_statement] = STATE(2615),
    [sym_global_statement] = STATE(2615),
    [sym_nonlocal_statement] = STATE(2615),
    [sym_exec_statement] = STATE(2615),
    [sym_type_alias_statement] = STATE(2615),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(634),
    [sym_string_start] = ACTIONS(81),
  },
  [145] = {
    [sym_import_statement] = STATE(2615),
    [sym_future_import_statement] = STATE(2615),
    [sym_import_from_statement] = STATE(2615),
    [sym_print_statement] = STATE(2615),
    [sym_assert_statement] = STATE(2615),
    [sym_expression_statement] = STATE(2615),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2615),
    [sym_delete_statement] = STATE(2615),
    [sym_raise_statement] = STATE(2615),
    [sym_pass_statement] = STATE(2615),
    [sym_break_statement] = STATE(2615),
    [sym_continue_statement] = STATE(2615),
    [sym_global_statement] = STATE(2615),
    [sym_nonlocal_statement] = STATE(2615),
    [sym_exec_statement] = STATE(2615),
    [sym_type_alias_statement] = STATE(2615),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(1687),
    [sym_assignment] = STATE(2559),
    [sym_augmented_assignment] = STATE(2559),
    [sym_pattern_list] = STATE(1679),
    [sym_yield] = STATE(2559),
    [sym_attribute] = STATE(637),
    [sym_subscript] = STATE(637),
    [sym_call] = STATE(1057),
    [sym_list] = STATE(1057),
    [sym_set] = STATE(1057),
    [sym_tuple] = STATE(1057),
    [sym_dictionary] = STATE(1057),
    [sym_list_comprehension] = STATE(1057),
    [sym_dictionary_comprehension] = STATE(1057),
    [sym_set_comprehension] = STATE(1057),
    [sym_generator_expression] = STATE(1057),
    [sym_parenthesized_expression] = STATE(1057),
    [sym_conditional_expression] = STATE(1687),
    [sym_concatenated_string] = STATE(1057),
    [sym_string] = STATE(975),
    [sym_await] = STATE(1057),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(418),
    [anon_sym_async] = ACTIONS(418),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_LBRACE] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_not] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [sym_ellipsis] = ACTIONS(75),
    [sym_integer] = ACTIONS(77),
    [sym_float] = ACTIONS(75),
    [anon_sym_await] = ACTIONS(79),
    [sym_true] = ACTIONS(77),
    [sym_false] = ACTIONS(77),
    [sym_none] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(636),
    [sym_string_start] = ACTIONS(81),
  },
  [146] = {
    [sym_import_statement] = STATE(2615),
    [sym_future_import_statement] = STATE(2615),
    [sym_import_from_statement] = STATE(2615),
    [sym_print_statement] = STATE(2615),
    [sym_assert_statement] = STATE(2615),
    [sym_expression_statement] = STATE(2615),
    [sym_named_expression] = STATE(1687),
    [sym__named_expression_lhs] = STATE(2782),
    [sym_return_statement] = STATE(2615),
    [sym_delete_statement] = STATE(2615),
    [sym_raise_statement] = STATE(2615),
    [sym_pass_statement] = STATE(2615),
    [sym_break_statement] = STATE(2615),
    [sym_continue_statement] = STATE(2615),
    [sym_global_statement] = STATE(2615),
    [sym_nonlocal_statement] = STATE(2615),
    [sym_exec_statement] = STATE(2615),
    [sym_type_alias_statement] = STATE(2615),
    [sym_pattern] = STATE(1671),
    [sym_tuple_pattern] = STATE(1668),
    [sym_list_pattern] = STATE(1668),
    [sym_list_splat_pattern] = STATE(635),
    [sym_as_pattern] = STATE(1687),
    [sym_expression] = STATE(1820),
    [sym_primary_expression] = STATE(1013),
    [sym_not_operator] = STATE(1687),
    [sym_boolean_operator] = STATE(1687),
    [sym_binary_operator] = STATE(1057),
    [sym_unary_operator] = STATE(1057),
    [sym_comparison_operator] = STATE(1687),
    [sym_lambda] = STATE(168