#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 152
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 50
#define ALIAS_COUNT 0
#define TOKEN_COUNT 22
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 1
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 2

enum {
  sym_raw_string_literal = 1,
  anon_sym_DQUOTE = 2,
  aux_sym_interpreted_string_literal_token1 = 3,
  sym_escape_sequence = 4,
  sym__identifier = 5,
  anon_sym_module = 6,
  anon_sym_LPAREN = 7,
  anon_sym_LF = 8,
  anon_sym_RPAREN = 9,
  anon_sym_go = 10,
  anon_sym_toolchain = 11,
  anon_sym_require = 12,
  anon_sym_exclude = 13,
  anon_sym_replace = 14,
  anon_sym_EQ_GT = 15,
  anon_sym_retract = 16,
  anon_sym_LBRACK = 17,
  anon_sym_COMMA = 18,
  anon_sym_RBRACK = 19,
  anon_sym_SLASH_SLASH = 20,
  aux_sym_comment_token1 = 21,
  sym_source_file = 22,
  sym__directive = 23,
  sym__string_literal = 24,
  sym_interpreted_string_literal = 25,
  sym__string_or_ident = 26,
  sym_module_path = 27,
  sym_go_version = 28,
  sym_version = 29,
  sym_module_directive = 30,
  sym_go_directive = 31,
  sym_toolchain_directive = 32,
  sym_toolchain_name = 33,
  sym_require_directive = 34,
  sym_require_spec = 35,
  sym_exclude_directive = 36,
  sym_exclude_spec = 37,
  sym_replace_directive = 38,
  sym_replace_spec = 39,
  sym_file_path = 40,
  sym_retract_directive = 41,
  sym_retract_spec = 42,
  sym_comment = 43,
  aux_sym_source_file_repeat1 = 44,
  aux_sym_interpreted_string_literal_repeat1 = 45,
  aux_sym_require_directive_repeat1 = 46,
  aux_sym_exclude_directive_repeat1 = 47,
  aux_sym_replace_directive_repeat1 = 48,
  aux_sym_retract_directive_repeat1 = 49,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_raw_string_literal] = "raw_string_literal",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_interpreted_string_literal_token1] = "interpreted_string_literal_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym__identifier] = "_identifier",
  [anon_sym_module] = "module",
  [anon_sym_LPAREN] = "(",
  [anon_sym_LF] = "\n",
  [anon_sym_RPAREN] = ")",
  [anon_sym_go] = "go",
  [anon_sym_toolchain] = "toolchain",
  [anon_sym_require] = "require",
  [anon_sym_exclude] = "exclude",
  [anon_sym_replace] = "replace",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_retract] = "retract",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACK] = "]",
  [anon_sym_SLASH_SLASH] = "//",
  [aux_sym_comment_token1] = "comment_token1",
  [sym_source_file] = "source_file",
  [sym__directive] = "_directive",
  [sym__string_literal] = "_string_literal",
  [sym_interpreted_string_literal] = "interpreted_string_literal",
  [sym__string_or_ident] = "_string_or_ident",
  [sym_module_path] = "module_path",
  [sym_go_version] = "go_version",
  [sym_version] = "version",
  [sym_module_directive] = "module_directive",
  [sym_go_directive] = "go_directive",
  [sym_toolchain_directive] = "toolchain_directive",
  [sym_toolchain_name] = "toolchain_name",
  [sym_require_directive] = "require_directive",
  [sym_require_spec] = "require_spec",
  [sym_exclude_directive] = "exclude_directive",
  [sym_exclude_spec] = "exclude_spec",
  [sym_replace_directive] = "replace_directive",
  [sym_replace_spec] = "replace_spec",
  [sym_file_path] = "file_path",
  [sym_retract_directive] = "retract_directive",
  [sym_retract_spec] = "retract_spec",
  [sym_comment] = "comment",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_interpreted_string_literal_repeat1] = "interpreted_string_literal_repeat1",
  [aux_sym_require_directive_repeat1] = "require_directive_repeat1",
  [aux_sym_exclude_directive_repeat1] = "exclude_directive_repeat1",
  [aux_sym_replace_directive_repeat1] = "replace_directive_repeat1",
  [aux_sym_retract_directive_repeat1] = "retract_directive_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_raw_string_literal] = sym_raw_string_literal,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_interpreted_string_literal_token1] = aux_sym_interpreted_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__identifier] = sym__identifier,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_go] = anon_sym_go,
  [anon_sym_toolchain] = anon_sym_toolchain,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_exclude] = anon_sym_exclude,
  [anon_sym_replace] = anon_sym_replace,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_retract] = anon_sym_retract,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [sym_source_file] = sym_source_file,
  [sym__directive] = sym__directive,
  [sym__string_literal] = sym__string_literal,
  [sym_interpreted_string_literal] = sym_interpreted_string_literal,
  [sym__string_or_ident] = sym__string_or_ident,
  [sym_module_path] = sym_module_path,
  [sym_go_version] = sym_go_version,
  [sym_version] = sym_version,
  [sym_module_directive] = sym_module_directive,
  [sym_go_directive] = sym_go_directive,
  [sym_toolchain_directive] = sym_toolchain_directive,
  [sym_toolchain_name] = sym_toolchain_name,
  [sym_require_directive] = sym_require_directive,
  [sym_require_spec] = sym_require_spec,
  [sym_exclude_directive] = sym_exclude_directive,
  [sym_exclude_spec] = sym_exclude_spec,
  [sym_replace_directive] = sym_replace_directive,
  [sym_replace_spec] = sym_replace_spec,
  [sym_file_path] = sym_file_path,
  [sym_retract_directive] = sym_retract_directive,
  [sym_retract_spec] = sym_retract_spec,
  [sym_comment] = sym_comment,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_interpreted_string_literal_repeat1] = aux_sym_interpreted_string_literal_repeat1,
  [aux_sym_require_directive_repeat1] = aux_sym_require_directive_repeat1,
  [aux_sym_exclude_directive_repeat1] = aux_sym_exclude_directive_repeat1,
  [aux_sym_replace_directive_repeat1] = aux_sym_replace_directive_repeat1,
  [aux_sym_retract_directive_repeat1] = aux_sym_retract_directive_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_string_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_go] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_toolchain] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exclude] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_replace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_retract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__directive] = {
    .visible = false,
    .named = true,
  },
  [sym__string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_interpreted_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__string_or_ident] = {
    .visible = false,
    .named = true,
  },
  [sym_module_path] = {
    .visible = true,
    .named = true,
  },
  [sym_go_version] = {
    .visible = true,
    .named = true,
  },
  [sym_version] = {
    .visible = true,
    .named = true,
  },
  [sym_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_go_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_toolchain_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_toolchain_name] = {
    .visible = true,
    .named = true,
  },
  [sym_require_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_require_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_exclude_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_exclude_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_replace_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_replace_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_file_path] = {
    .visible = true,
    .named = true,
  },
  [sym_retract_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_retract_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_require_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_exclude_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_replace_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_retract_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_name = 1,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_name] = "name",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 24,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 46,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 52,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 58,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 63,
  [69] = 66,
  [70] = 67,
  [71] = 65,
  [72] = 60,
  [73] = 54,
  [74] = 56,
  [75] = 75,
  [76] = 76,
  [77] = 47,
  [78] = 78,
  [79] = 79,
  [80] = 78,
  [81] = 81,
  [82] = 78,
  [83] = 79,
  [84] = 5,
  [85] = 8,
  [86] = 86,
  [87] = 10,
  [88] = 4,
  [89] = 78,
  [90] = 53,
  [91] = 79,
  [92] = 48,
  [93] = 42,
  [94] = 40,
  [95] = 95,
  [96] = 36,
  [97] = 97,
  [98] = 79,
  [99] = 4,
  [100] = 10,
  [101] = 42,
  [102] = 8,
  [103] = 5,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 8,
  [109] = 10,
  [110] = 5,
  [111] = 4,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 42,
  [125] = 125,
  [126] = 126,
  [127] = 105,
  [128] = 107,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 125,
  [134] = 115,
  [135] = 113,
  [136] = 131,
  [137] = 137,
  [138] = 138,
  [139] = 130,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 132,
  [144] = 144,
  [145] = 145,
  [146] = 120,
  [147] = 147,
  [148] = 129,
  [149] = 149,
  [150] = 112,
  [151] = 151,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(56);
      if (lookahead == '"') ADVANCE(59);
      if (lookahead == '(') ADVANCE(72);
      if (lookahead == ')') ADVANCE(75);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == ']') ADVANCE(87);
      if (lookahead == '`') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(46);
      if (lookahead == 'g') ADVANCE(35);
      if (lookahead == 'm') ADVANCE(36);
      if (lookahead == 'r') ADVANCE(22);
      if (lookahead == 't') ADVANCE(38);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(55)
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(74);
      if (lookahead == '"') ADVANCE(60);
      if (lookahead == '/') ADVANCE(67);
      if (lookahead == '`') ADVANCE(69);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(70);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(74);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(4)
      if (lookahead == '"') ADVANCE(59);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == '\\') ADVANCE(11);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(61);
      if (lookahead != 0) ADVANCE(63);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(59);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(60);
      if (lookahead == '(') ADVANCE(73);
      if (lookahead == '/') ADVANCE(67);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '`') ADVANCE(69);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != ']') ADVANCE(70);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(60);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '/') ADVANCE(67);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '`') ADVANCE(69);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != ']') ADVANCE(70);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(60);
      if (lookahead == '/') ADVANCE(67);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '`') ADVANCE(69);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(70);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(60);
      if (lookahead == '/') ADVANCE(67);
      if (lookahead == '`') ADVANCE(69);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(70);
      END_STATE();
    case 9:
      if (lookahead == '/') ADVANCE(88);
      END_STATE();
    case 10:
      if (lookahead == '>') ADVANCE(82);
      END_STATE();
    case 11:
      if (lookahead == 'U') ADVANCE(54);
      if (lookahead == 'u') ADVANCE(50);
      if (lookahead == 'x') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (lookahead != 0) ADVANCE(64);
      END_STATE();
    case 12:
      if (lookahead == '`') ADVANCE(57);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(28);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(19);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(18);
      END_STATE();
    case 16:
      if (lookahead == 'c') ADVANCE(33);
      END_STATE();
    case 17:
      if (lookahead == 'c') ADVANCE(27);
      END_STATE();
    case 18:
      if (lookahead == 'c') ADVANCE(42);
      END_STATE();
    case 19:
      if (lookahead == 'c') ADVANCE(25);
      END_STATE();
    case 20:
      if (lookahead == 'd') ADVANCE(45);
      END_STATE();
    case 21:
      if (lookahead == 'd') ADVANCE(24);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(71);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 25:
      if (lookahead == 'e') ADVANCE(81);
      END_STATE();
    case 26:
      if (lookahead == 'e') ADVANCE(79);
      END_STATE();
    case 27:
      if (lookahead == 'h') ADVANCE(13);
      END_STATE();
    case 28:
      if (lookahead == 'i') ADVANCE(34);
      END_STATE();
    case 29:
      if (lookahead == 'i') ADVANCE(40);
      END_STATE();
    case 30:
      if (lookahead == 'l') ADVANCE(14);
      END_STATE();
    case 31:
      if (lookahead == 'l') ADVANCE(23);
      END_STATE();
    case 32:
      if (lookahead == 'l') ADVANCE(17);
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(78);
      END_STATE();
    case 35:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 36:
      if (lookahead == 'o') ADVANCE(20);
      END_STATE();
    case 37:
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 39:
      if (lookahead == 'p') ADVANCE(30);
      if (lookahead == 'q') ADVANCE(43);
      if (lookahead == 't') ADVANCE(41);
      END_STATE();
    case 40:
      if (lookahead == 'r') ADVANCE(26);
      END_STATE();
    case 41:
      if (lookahead == 'r') ADVANCE(15);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(84);
      END_STATE();
    case 43:
      if (lookahead == 'u') ADVANCE(29);
      END_STATE();
    case 44:
      if (lookahead == 'u') ADVANCE(21);
      END_STATE();
    case 45:
      if (lookahead == 'u') ADVANCE(31);
      END_STATE();
    case 46:
      if (lookahead == 'x') ADVANCE(16);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(64);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 55:
      if (eof) ADVANCE(56);
      if (lookahead == '"') ADVANCE(59);
      if (lookahead == '(') ADVANCE(72);
      if (lookahead == ')') ADVANCE(75);
      if (lookahead == ',') ADVANCE(86);
      if (lookahead == '/') ADVANCE(9);
      if (lookahead == '=') ADVANCE(10);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == ']') ADVANCE(87);
      if (lookahead == '`') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(46);
      if (lookahead == 'g') ADVANCE(35);
      if (lookahead == 'm') ADVANCE(36);
      if (lookahead == 'r') ADVANCE(22);
      if (lookahead == 't') ADVANCE(38);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(55)
      END_STATE();
    case 56:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_raw_string_literal);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_raw_string_literal);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(70);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(70);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(61);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(63);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '/') ADVANCE(63);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(63);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(63);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(70);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(70);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '`') ADVANCE(58);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == ',' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(12);
      if (lookahead != 0) ADVANCE(69);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(70);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(74);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(70);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_go);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_toolchain);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_require);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_exclude);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_replace);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(70);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_retract);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(70);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(93);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(91);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(93);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(93);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(93);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 6},
  [7] = {.lex_state = 6},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 6},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 6},
  [12] = {.lex_state = 6},
  [13] = {.lex_state = 5},
  [14] = {.lex_state = 6},
  [15] = {.lex_state = 6},
  [16] = {.lex_state = 6},
  [17] = {.lex_state = 6},
  [18] = {.lex_state = 6},
  [19] = {.lex_state = 6},
  [20] = {.lex_state = 6},
  [21] = {.lex_state = 5},
  [22] = {.lex_state = 5},
  [23] = {.lex_state = 5},
  [24] = {.lex_state = 7},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 7},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 0},
  [46] = {.lex_state = 8},
  [47] = {.lex_state = 0},
  [48] = {.lex_state = 0},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 8},
  [51] = {.lex_state = 0},
  [52] = {.lex_state = 8},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 0},
  [55] = {.lex_state = 5},
  [56] = {.lex_state = 0},
  [57] = {.lex_state = 8},
  [58] = {.lex_state = 8},
  [59] = {.lex_state = 8},
  [60] = {.lex_state = 8},
  [61] = {.lex_state = 8},
  [62] = {.lex_state = 8},
  [63] = {.lex_state = 8},
  [64] = {.lex_state = 8},
  [65] = {.lex_state = 8},
  [66] = {.lex_state = 8},
  [67] = {.lex_state = 8},
  [68] = {.lex_state = 8},
  [69] = {.lex_state = 8},
  [70] = {.lex_state = 8},
  [71] = {.lex_state = 8},
  [72] = {.lex_state = 8},
  [73] = {.lex_state = 6},
  [74] = {.lex_state = 6},
  [75] = {.lex_state = 6},
  [76] = {.lex_state = 1},
  [77] = {.lex_state = 6},
  [78] = {.lex_state = 3},
  [79] = {.lex_state = 3},
  [80] = {.lex_state = 3},
  [81] = {.lex_state = 6},
  [82] = {.lex_state = 3},
  [83] = {.lex_state = 3},
  [84] = {.lex_state = 7},
  [85] = {.lex_state = 7},
  [86] = {.lex_state = 3},
  [87] = {.lex_state = 7},
  [88] = {.lex_state = 7},
  [89] = {.lex_state = 3},
  [90] = {.lex_state = 6},
  [91] = {.lex_state = 3},
  [92] = {.lex_state = 6},
  [93] = {.lex_state = 7},
  [94] = {.lex_state = 6},
  [95] = {.lex_state = 6},
  [96] = {.lex_state = 6},
  [97] = {.lex_state = 6},
  [98] = {.lex_state = 3},
  [99] = {.lex_state = 8},
  [100] = {.lex_state = 8},
  [101] = {.lex_state = 8},
  [102] = {.lex_state = 8},
  [103] = {.lex_state = 8},
  [104] = {.lex_state = 3},
  [105] = {.lex_state = 0},
  [106] = {.lex_state = 2},
  [107] = {.lex_state = 2},
  [108] = {.lex_state = 2},
  [109] = {.lex_state = 2},
  [110] = {.lex_state = 2},
  [111] = {.lex_state = 2},
  [112] = {.lex_state = 0},
  [113] = {.lex_state = 2},
  [114] = {.lex_state = 2},
  [115] = {.lex_state = 2},
  [116] = {.lex_state = 2},
  [117] = {.lex_state = 2},
  [118] = {.lex_state = 2},
  [119] = {.lex_state = 2},
  [120] = {.lex_state = 0},
  [121] = {.lex_state = 2},
  [122] = {.lex_state = 2},
  [123] = {.lex_state = 2},
  [124] = {.lex_state = 2},
  [125] = {.lex_state = 2},
  [126] = {.lex_state = 2},
  [127] = {.lex_state = 2},
  [128] = {.lex_state = 2},
  [129] = {.lex_state = 0},
  [130] = {.lex_state = 2},
  [131] = {.lex_state = 2},
  [132] = {.lex_state = 2},
  [133] = {.lex_state = 2},
  [134] = {.lex_state = 2},
  [135] = {.lex_state = 2},
  [136] = {.lex_state = 2},
  [137] = {.lex_state = 2},
  [138] = {.lex_state = 0},
  [139] = {.lex_state = 2},
  [140] = {.lex_state = 91},
  [141] = {.lex_state = 2},
  [142] = {.lex_state = 0},
  [143] = {.lex_state = 2},
  [144] = {.lex_state = 2},
  [145] = {.lex_state = 2},
  [146] = {.lex_state = 0},
  [147] = {.lex_state = 2},
  [148] = {.lex_state = 0},
  [149] = {.lex_state = 2},
  [150] = {.lex_state = 0},
  [151] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_raw_string_literal] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_go] = ACTIONS(1),
    [anon_sym_toolchain] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_exclude] = ACTIONS(1),
    [anon_sym_replace] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_retract] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(142),
    [sym__directive] = STATE(51),
    [sym_module_directive] = STATE(49),
    [sym_go_directive] = STATE(49),
    [sym_toolchain_directive] = STATE(49),
    [sym_require_directive] = STATE(49),
    [sym_exclude_directive] = STATE(49),
    [sym_replace_directive] = STATE(49),
    [sym_retract_directive] = STATE(49),
    [sym_comment] = STATE(1),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(7),
    [anon_sym_go] = ACTIONS(9),
    [anon_sym_toolchain] = ACTIONS(11),
    [anon_sym_require] = ACTIONS(13),
    [anon_sym_exclude] = ACTIONS(15),
    [anon_sym_replace] = ACTIONS(17),
    [anon_sym_retract] = ACTIONS(19),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 12,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(21), 1,
      ts_builtin_sym_end,
    ACTIONS(23), 1,
      anon_sym_module,
    ACTIONS(26), 1,
      anon_sym_go,
    ACTIONS(29), 1,
      anon_sym_toolchain,
    ACTIONS(32), 1,
      anon_sym_require,
    ACTIONS(35), 1,
      anon_sym_exclude,
    ACTIONS(38), 1,
      anon_sym_replace,
    ACTIONS(41), 1,
      anon_sym_retract,
    STATE(51), 1,
      sym__directive,
    STATE(2), 2,
      sym_comment,
      aux_sym_source_file_repeat1,
    STATE(49), 7,
      sym_module_directive,
      sym_go_directive,
      sym_toolchain_directive,
      sym_require_directive,
      sym_exclude_directive,
      sym_replace_directive,
      sym_retract_directive,
  [44] = 13,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(7), 1,
      anon_sym_module,
    ACTIONS(9), 1,
      anon_sym_go,
    ACTIONS(11), 1,
      anon_sym_toolchain,
    ACTIONS(13), 1,
      anon_sym_require,
    ACTIONS(15), 1,
      anon_sym_exclude,
    ACTIONS(17), 1,
      anon_sym_replace,
    ACTIONS(19), 1,
      anon_sym_retract,
    ACTIONS(44), 1,
      ts_builtin_sym_end,
    STATE(2), 1,
      aux_sym_source_file_repeat1,
    STATE(3), 1,
      sym_comment,
    STATE(51), 1,
      sym__directive,
    STATE(49), 7,
      sym_module_directive,
      sym_go_directive,
      sym_toolchain_directive,
      sym_require_directive,
      sym_exclude_directive,
      sym_replace_directive,
      sym_retract_directive,
  [90] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(4), 1,
      sym_comment,
    ACTIONS(46), 11,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_EQ_GT,
      anon_sym_retract,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [110] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(5), 1,
      sym_comment,
    ACTIONS(48), 11,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_EQ_GT,
      anon_sym_retract,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [130] = 13,
    ACTIONS(50), 1,
      sym_raw_string_literal,
    ACTIONS(52), 1,
      anon_sym_DQUOTE,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(56), 1,
      anon_sym_RPAREN,
    ACTIONS(58), 1,
      anon_sym_LBRACK,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(6), 1,
      sym_comment,
    STATE(7), 1,
      aux_sym_retract_directive_repeat1,
    STATE(75), 1,
      sym_retract_spec,
    STATE(109), 1,
      sym__string_literal,
    STATE(111), 1,
      sym_interpreted_string_literal,
    STATE(127), 1,
      sym__string_or_ident,
    STATE(128), 1,
      sym_version,
  [170] = 13,
    ACTIONS(50), 1,
      sym_raw_string_literal,
    ACTIONS(52), 1,
      anon_sym_DQUOTE,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(58), 1,
      anon_sym_LBRACK,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(62), 1,
      anon_sym_RPAREN,
    STATE(7), 1,
      sym_comment,
    STATE(9), 1,
      aux_sym_retract_directive_repeat1,
    STATE(75), 1,
      sym_retract_spec,
    STATE(109), 1,
      sym__string_literal,
    STATE(111), 1,
      sym_interpreted_string_literal,
    STATE(127), 1,
      sym__string_or_ident,
    STATE(128), 1,
      sym_version,
  [210] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(8), 1,
      sym_comment,
    ACTIONS(64), 11,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_EQ_GT,
      anon_sym_retract,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [230] = 12,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(66), 1,
      sym_raw_string_literal,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(72), 1,
      sym__identifier,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
    ACTIONS(77), 1,
      anon_sym_LBRACK,
    STATE(75), 1,
      sym_retract_spec,
    STATE(109), 1,
      sym__string_literal,
    STATE(111), 1,
      sym_interpreted_string_literal,
    STATE(127), 1,
      sym__string_or_ident,
    STATE(128), 1,
      sym_version,
    STATE(9), 2,
      sym_comment,
      aux_sym_retract_directive_repeat1,
  [268] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(10), 1,
      sym_comment,
    ACTIONS(80), 11,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_EQ_GT,
      anon_sym_retract,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [288] = 11,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(82), 1,
      sym_raw_string_literal,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(88), 1,
      sym__identifier,
    ACTIONS(91), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      sym_module_path,
    STATE(81), 1,
      sym_require_spec,
    STATE(99), 1,
      sym_interpreted_string_literal,
    STATE(100), 1,
      sym__string_literal,
    STATE(101), 1,
      sym__string_or_ident,
    STATE(11), 2,
      sym_comment,
      aux_sym_require_directive_repeat1,
  [323] = 12,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      sym_raw_string_literal,
    ACTIONS(95), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__identifier,
    ACTIONS(99), 1,
      anon_sym_RPAREN,
    STATE(12), 1,
      sym_comment,
    STATE(15), 1,
      aux_sym_require_directive_repeat1,
    STATE(71), 1,
      sym_module_path,
    STATE(81), 1,
      sym_require_spec,
    STATE(99), 1,
      sym_interpreted_string_literal,
    STATE(100), 1,
      sym__string_literal,
    STATE(101), 1,
      sym__string_or_ident,
  [360] = 12,
    ACTIONS(50), 1,
      sym_raw_string_literal,
    ACTIONS(52), 1,
      anon_sym_DQUOTE,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(101), 1,
      anon_sym_LPAREN,
    ACTIONS(103), 1,
      anon_sym_LBRACK,
    STATE(13), 1,
      sym_comment,
    STATE(38), 1,
      sym_retract_spec,
    STATE(107), 1,
      sym_version,
    STATE(109), 1,
      sym__string_literal,
    STATE(111), 1,
      sym_interpreted_string_literal,
    STATE(127), 1,
      sym__string_or_ident,
  [397] = 12,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(105), 1,
      sym_raw_string_literal,
    ACTIONS(107), 1,
      anon_sym_DQUOTE,
    ACTIONS(109), 1,
      sym__identifier,
    ACTIONS(111), 1,
      anon_sym_RPAREN,
    STATE(14), 1,
      sym_comment,
    STATE(20), 1,
      aux_sym_replace_directive_repeat1,
    STATE(24), 1,
      sym_module_path,
    STATE(87), 1,
      sym__string_literal,
    STATE(88), 1,
      sym_interpreted_string_literal,
    STATE(93), 1,
      sym__string_or_ident,
    STATE(95), 1,
      sym_replace_spec,
  [434] = 12,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      sym_raw_string_literal,
    ACTIONS(95), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__identifier,
    ACTIONS(113), 1,
      anon_sym_RPAREN,
    STATE(11), 1,
      aux_sym_require_directive_repeat1,
    STATE(15), 1,
      sym_comment,
    STATE(71), 1,
      sym_module_path,
    STATE(81), 1,
      sym_require_spec,
    STATE(99), 1,
      sym_interpreted_string_literal,
    STATE(100), 1,
      sym__string_literal,
    STATE(101), 1,
      sym__string_or_ident,
  [471] = 12,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(105), 1,
      sym_raw_string_literal,
    ACTIONS(107), 1,
      anon_sym_DQUOTE,
    ACTIONS(109), 1,
      sym__identifier,
    ACTIONS(115), 1,
      anon_sym_RPAREN,
    STATE(14), 1,
      aux_sym_replace_directive_repeat1,
    STATE(16), 1,
      sym_comment,
    STATE(24), 1,
      sym_module_path,
    STATE(87), 1,
      sym__string_literal,
    STATE(88), 1,
      sym_interpreted_string_literal,
    STATE(93), 1,
      sym__string_or_ident,
    STATE(95), 1,
      sym_replace_spec,
  [508] = 12,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      sym_raw_string_literal,
    ACTIONS(95), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__identifier,
    ACTIONS(117), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      sym_comment,
    STATE(18), 1,
      aux_sym_exclude_directive_repeat1,
    STATE(70), 1,
      sym_module_path,
    STATE(97), 1,
      sym_exclude_spec,
    STATE(99), 1,
      sym_interpreted_string_literal,
    STATE(100), 1,
      sym__string_literal,
    STATE(101), 1,
      sym__string_or_ident,
  [545] = 12,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      sym_raw_string_literal,
    ACTIONS(95), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__identifier,
    ACTIONS(119), 1,
      anon_sym_RPAREN,
    STATE(18), 1,
      sym_comment,
    STATE(19), 1,
      aux_sym_exclude_directive_repeat1,
    STATE(70), 1,
      sym_module_path,
    STATE(97), 1,
      sym_exclude_spec,
    STATE(99), 1,
      sym_interpreted_string_literal,
    STATE(100), 1,
      sym__string_literal,
    STATE(101), 1,
      sym__string_or_ident,
  [582] = 11,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(121), 1,
      sym_raw_string_literal,
    ACTIONS(124), 1,
      anon_sym_DQUOTE,
    ACTIONS(127), 1,
      sym__identifier,
    ACTIONS(130), 1,
      anon_sym_RPAREN,
    STATE(70), 1,
      sym_module_path,
    STATE(97), 1,
      sym_exclude_spec,
    STATE(99), 1,
      sym_interpreted_string_literal,
    STATE(100), 1,
      sym__string_literal,
    STATE(101), 1,
      sym__string_or_ident,
    STATE(19), 2,
      sym_comment,
      aux_sym_exclude_directive_repeat1,
  [617] = 11,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(132), 1,
      sym_raw_string_literal,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(138), 1,
      sym__identifier,
    ACTIONS(141), 1,
      anon_sym_RPAREN,
    STATE(24), 1,
      sym_module_path,
    STATE(87), 1,
      sym__string_literal,
    STATE(88), 1,
      sym_interpreted_string_literal,
    STATE(93), 1,
      sym__string_or_ident,
    STATE(95), 1,
      sym_replace_spec,
    STATE(20), 2,
      sym_comment,
      aux_sym_replace_directive_repeat1,
  [652] = 11,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      sym_raw_string_literal,
    ACTIONS(95), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__identifier,
    ACTIONS(143), 1,
      anon_sym_LPAREN,
    STATE(21), 1,
      sym_comment,
    STATE(30), 1,
      sym_exclude_spec,
    STATE(67), 1,
      sym_module_path,
    STATE(99), 1,
      sym_interpreted_string_literal,
    STATE(100), 1,
      sym__string_literal,
    STATE(101), 1,
      sym__string_or_ident,
  [686] = 11,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(105), 1,
      sym_raw_string_literal,
    ACTIONS(107), 1,
      anon_sym_DQUOTE,
    ACTIONS(109), 1,
      sym__identifier,
    ACTIONS(145), 1,
      anon_sym_LPAREN,
    STATE(22), 1,
      sym_comment,
    STATE(32), 1,
      sym_module_path,
    STATE(33), 1,
      sym_replace_spec,
    STATE(87), 1,
      sym__string_literal,
    STATE(88), 1,
      sym_interpreted_string_literal,
    STATE(93), 1,
      sym__string_or_ident,
  [720] = 11,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      sym_raw_string_literal,
    ACTIONS(95), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym__identifier,
    ACTIONS(147), 1,
      anon_sym_LPAREN,
    STATE(23), 1,
      sym_comment,
    STATE(28), 1,
      sym_require_spec,
    STATE(65), 1,
      sym_module_path,
    STATE(99), 1,
      sym_interpreted_string_literal,
    STATE(100), 1,
      sym__string_literal,
    STATE(101), 1,
      sym__string_or_ident,
  [754] = 10,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(149), 1,
      sym_raw_string_literal,
    ACTIONS(151), 1,
      anon_sym_DQUOTE,
    ACTIONS(153), 1,
      sym__identifier,
    ACTIONS(155), 1,
      anon_sym_EQ_GT,
    STATE(4), 1,
      sym_interpreted_string_literal,
    STATE(10), 1,
      sym__string_literal,
    STATE(24), 1,
      sym_comment,
    STATE(105), 1,
      sym__string_or_ident,
    STATE(148), 1,
      sym_version,
  [785] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(25), 1,
      sym_comment,
    ACTIONS(157), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [802] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(26), 1,
      sym_comment,
    ACTIONS(159), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [819] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(27), 1,
      sym_comment,
    ACTIONS(161), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [836] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(28), 1,
      sym_comment,
    ACTIONS(163), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [853] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(29), 1,
      sym_comment,
    ACTIONS(165), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [870] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(30), 1,
      sym_comment,
    ACTIONS(167), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [887] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(31), 1,
      sym_comment,
    ACTIONS(169), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [904] = 10,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(149), 1,
      sym_raw_string_literal,
    ACTIONS(151), 1,
      anon_sym_DQUOTE,
    ACTIONS(153), 1,
      sym__identifier,
    ACTIONS(171), 1,
      anon_sym_EQ_GT,
    STATE(4), 1,
      sym_interpreted_string_literal,
    STATE(10), 1,
      sym__string_literal,
    STATE(32), 1,
      sym_comment,
    STATE(105), 1,
      sym__string_or_ident,
    STATE(129), 1,
      sym_version,
  [935] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(33), 1,
      sym_comment,
    ACTIONS(173), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [952] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(34), 1,
      sym_comment,
    ACTIONS(175), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [969] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(35), 1,
      sym_comment,
    ACTIONS(177), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [986] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(36), 1,
      sym_comment,
    ACTIONS(179), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1003] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(37), 1,
      sym_comment,
    ACTIONS(181), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1020] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(38), 1,
      sym_comment,
    ACTIONS(183), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1037] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(39), 1,
      sym_comment,
    ACTIONS(185), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1054] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(40), 1,
      sym_comment,
    ACTIONS(187), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1071] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(41), 1,
      sym_comment,
    ACTIONS(189), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1088] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(42), 1,
      sym_comment,
    ACTIONS(191), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1105] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(43), 1,
      sym_comment,
    ACTIONS(193), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1122] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(44), 1,
      sym_comment,
    ACTIONS(195), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1139] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(45), 1,
      sym_comment,
    ACTIONS(197), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1156] = 10,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      sym_raw_string_literal,
    ACTIONS(95), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym__identifier,
    STATE(46), 1,
      sym_comment,
    STATE(66), 1,
      sym_module_path,
    STATE(99), 1,
      sym_interpreted_string_literal,
    STATE(100), 1,
      sym__string_literal,
    STATE(101), 1,
      sym__string_or_ident,
    STATE(132), 1,
      sym_file_path,
  [1187] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(47), 1,
      sym_comment,
    ACTIONS(201), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1204] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(48), 1,
      sym_comment,
    ACTIONS(203), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1221] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(49), 1,
      sym_comment,
    ACTIONS(205), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1238] = 10,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      sym_raw_string_literal,
    ACTIONS(95), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym__identifier,
    STATE(50), 1,
      sym_comment,
    STATE(69), 1,
      sym_module_path,
    STATE(99), 1,
      sym_interpreted_string_literal,
    STATE(100), 1,
      sym__string_literal,
    STATE(101), 1,
      sym__string_or_ident,
    STATE(143), 1,
      sym_file_path,
  [1269] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(51), 1,
      sym_comment,
    ACTIONS(207), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1286] = 10,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      sym_raw_string_literal,
    ACTIONS(95), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym__identifier,
    STATE(52), 1,
      sym_comment,
    STATE(63), 1,
      sym_module_path,
    STATE(99), 1,
      sym_interpreted_string_literal,
    STATE(100), 1,
      sym__string_literal,
    STATE(101), 1,
      sym__string_or_ident,
    STATE(133), 1,
      sym_file_path,
  [1317] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(53), 1,
      sym_comment,
    ACTIONS(209), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1334] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(54), 1,
      sym_comment,
    ACTIONS(211), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1351] = 10,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(149), 1,
      sym_raw_string_literal,
    ACTIONS(151), 1,
      anon_sym_DQUOTE,
    ACTIONS(153), 1,
      sym__identifier,
    ACTIONS(213), 1,
      anon_sym_LPAREN,
    STATE(4), 1,
      sym_interpreted_string_literal,
    STATE(10), 1,
      sym__string_literal,
    STATE(39), 1,
      sym_module_path,
    STATE(42), 1,
      sym__string_or_ident,
    STATE(55), 1,
      sym_comment,
  [1382] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(56), 1,
      sym_comment,
    ACTIONS(215), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1399] = 10,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(93), 1,
      sym_raw_string_literal,
    ACTIONS(95), 1,
      anon_sym_DQUOTE,
    ACTIONS(199), 1,
      sym__identifier,
    STATE(57), 1,
      sym_comment,
    STATE(68), 1,
      sym_module_path,
    STATE(99), 1,
      sym_interpreted_string_literal,
    STATE(100), 1,
      sym__string_literal,
    STATE(101), 1,
      sym__string_or_ident,
    STATE(125), 1,
      sym_file_path,
  [1430] = 9,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(149), 1,
      sym_raw_string_literal,
    ACTIONS(151), 1,
      anon_sym_DQUOTE,
    ACTIONS(153), 1,
      sym__identifier,
    STATE(4), 1,
      sym_interpreted_string_literal,
    STATE(10), 1,
      sym__string_literal,
    STATE(58), 1,
      sym_comment,
    STATE(105), 1,
      sym__string_or_ident,
    STATE(120), 1,
      sym_version,
  [1458] = 9,
    ACTIONS(50), 1,
      sym_raw_string_literal,
    ACTIONS(52), 1,
      anon_sym_DQUOTE,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(59), 1,
      sym_comment,
    STATE(109), 1,
      sym__string_literal,
    STATE(111), 1,
      sym_interpreted_string_literal,
    STATE(124), 1,
      sym__string_or_ident,
    STATE(149), 1,
      sym_module_path,
  [1486] = 9,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(149), 1,
      sym_raw_string_literal,
    ACTIONS(151), 1,
      anon_sym_DQUOTE,
    ACTIONS(153), 1,
      sym__identifier,
    STATE(4), 1,
      sym_interpreted_string_literal,
    STATE(10), 1,
      sym__string_literal,
    STATE(60), 1,
      sym_comment,
    STATE(105), 1,
      sym__string_or_ident,
    STATE(150), 1,
      sym_version,
  [1514] = 9,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(149), 1,
      sym_raw_string_literal,
    ACTIONS(151), 1,
      anon_sym_DQUOTE,
    ACTIONS(153), 1,
      sym__identifier,
    STATE(4), 1,
      sym_interpreted_string_literal,
    STATE(10), 1,
      sym__string_literal,
    STATE(61), 1,
      sym_comment,
    STATE(105), 1,
      sym__string_or_ident,
    STATE(146), 1,
      sym_version,
  [1542] = 9,
    ACTIONS(50), 1,
      sym_raw_string_literal,
    ACTIONS(52), 1,
      anon_sym_DQUOTE,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(62), 1,
      sym_comment,
    STATE(109), 1,
      sym__string_literal,
    STATE(111), 1,
      sym_interpreted_string_literal,
    STATE(116), 1,
      sym__string_or_ident,
    STATE(117), 1,
      sym_go_version,
  [1570] = 9,
    ACTIONS(50), 1,
      sym_raw_string_literal,
    ACTIONS(52), 1,
      anon_sym_DQUOTE,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(63), 1,
      sym_comment,
    STATE(109), 1,
      sym__string_literal,
    STATE(111), 1,
      sym_interpreted_string_literal,
    STATE(127), 1,
      sym__string_or_ident,
    STATE(134), 1,
      sym_version,
  [1598] = 9,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(149), 1,
      sym_raw_string_literal,
    ACTIONS(151), 1,
      anon_sym_DQUOTE,
    ACTIONS(153), 1,
      sym__identifier,
    STATE(4), 1,
      sym_interpreted_string_literal,
    STATE(10), 1,
      sym__string_literal,
    STATE(25), 1,
      sym__string_or_ident,
    STATE(41), 1,
      sym_toolchain_name,
    STATE(64), 1,
      sym_comment,
  [1626] = 9,
    ACTIONS(50), 1,
      sym_raw_string_literal,
    ACTIONS(52), 1,
      anon_sym_DQUOTE,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(65), 1,
      sym_comment,
    STATE(109), 1,
      sym__string_literal,
    STATE(111), 1,
      sym_interpreted_string_literal,
    STATE(127), 1,
      sym__string_or_ident,
    STATE(139), 1,
      sym_version,
  [1654] = 9,
    ACTIONS(50), 1,
      sym_raw_string_literal,
    ACTIONS(52), 1,
      anon_sym_DQUOTE,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(66), 1,
      sym_comment,
    STATE(109), 1,
      sym__string_literal,
    STATE(111), 1,
      sym_interpreted_string_literal,
    STATE(127), 1,
      sym__string_or_ident,
    STATE(133), 1,
      sym_version,
  [1682] = 9,
    ACTIONS(50), 1,
      sym_raw_string_literal,
    ACTIONS(52), 1,
      anon_sym_DQUOTE,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(67), 1,
      sym_comment,
    STATE(109), 1,
      sym__string_literal,
    STATE(111), 1,
      sym_interpreted_string_literal,
    STATE(127), 1,
      sym__string_or_ident,
    STATE(136), 1,
      sym_version,
  [1710] = 9,
    ACTIONS(50), 1,
      sym_raw_string_literal,
    ACTIONS(52), 1,
      anon_sym_DQUOTE,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(68), 1,
      sym_comment,
    STATE(109), 1,
      sym__string_literal,
    STATE(111), 1,
      sym_interpreted_string_literal,
    STATE(115), 1,
      sym_version,
    STATE(127), 1,
      sym__string_or_ident,
  [1738] = 9,
    ACTIONS(50), 1,
      sym_raw_string_literal,
    ACTIONS(52), 1,
      anon_sym_DQUOTE,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(69), 1,
      sym_comment,
    STATE(109), 1,
      sym__string_literal,
    STATE(111), 1,
      sym_interpreted_string_literal,
    STATE(125), 1,
      sym_version,
    STATE(127), 1,
      sym__string_or_ident,
  [1766] = 9,
    ACTIONS(50), 1,
      sym_raw_string_literal,
    ACTIONS(52), 1,
      anon_sym_DQUOTE,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(70), 1,
      sym_comment,
    STATE(109), 1,
      sym__string_literal,
    STATE(111), 1,
      sym_interpreted_string_literal,
    STATE(127), 1,
      sym__string_or_ident,
    STATE(131), 1,
      sym_version,
  [1794] = 9,
    ACTIONS(50), 1,
      sym_raw_string_literal,
    ACTIONS(52), 1,
      anon_sym_DQUOTE,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(71), 1,
      sym_comment,
    STATE(109), 1,
      sym__string_literal,
    STATE(111), 1,
      sym_interpreted_string_literal,
    STATE(127), 1,
      sym__string_or_ident,
    STATE(130), 1,
      sym_version,
  [1822] = 9,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(149), 1,
      sym_raw_string_literal,
    ACTIONS(151), 1,
      anon_sym_DQUOTE,
    ACTIONS(153), 1,
      sym__identifier,
    STATE(4), 1,
      sym_interpreted_string_literal,
    STATE(10), 1,
      sym__string_literal,
    STATE(72), 1,
      sym_comment,
    STATE(105), 1,
      sym__string_or_ident,
    STATE(112), 1,
      sym_version,
  [1850] = 4,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(211), 1,
      anon_sym_LBRACK,
    STATE(73), 1,
      sym_comment,
    ACTIONS(217), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [1866] = 4,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(215), 1,
      anon_sym_LBRACK,
    STATE(74), 1,
      sym_comment,
    ACTIONS(219), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [1882] = 4,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(223), 1,
      anon_sym_LBRACK,
    STATE(75), 1,
      sym_comment,
    ACTIONS(221), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [1898] = 4,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(227), 1,
      anon_sym_LF,
    STATE(76), 1,
      sym_comment,
    ACTIONS(225), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [1913] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(77), 1,
      sym_comment,
    ACTIONS(229), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [1926] = 5,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(231), 1,
      anon_sym_DQUOTE,
    STATE(78), 1,
      sym_comment,
    STATE(86), 1,
      aux_sym_interpreted_string_literal_repeat1,
    ACTIONS(233), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [1943] = 5,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(235), 1,
      anon_sym_DQUOTE,
    STATE(78), 1,
      aux_sym_interpreted_string_literal_repeat1,
    STATE(79), 1,
      sym_comment,
    ACTIONS(233), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [1960] = 5,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(237), 1,
      anon_sym_DQUOTE,
    STATE(80), 1,
      sym_comment,
    STATE(86), 1,
      aux_sym_interpreted_string_literal_repeat1,
    ACTIONS(233), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [1977] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(81), 1,
      sym_comment,
    ACTIONS(239), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [1990] = 5,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(241), 1,
      anon_sym_DQUOTE,
    STATE(82), 1,
      sym_comment,
    STATE(86), 1,
      aux_sym_interpreted_string_literal_repeat1,
    ACTIONS(233), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2007] = 5,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(243), 1,
      anon_sym_DQUOTE,
    STATE(82), 1,
      aux_sym_interpreted_string_literal_repeat1,
    STATE(83), 1,
      sym_comment,
    ACTIONS(233), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2024] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(84), 1,
      sym_comment,
    ACTIONS(245), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_EQ_GT,
  [2037] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(85), 1,
      sym_comment,
    ACTIONS(247), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_EQ_GT,
  [2050] = 4,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(249), 1,
      anon_sym_DQUOTE,
    ACTIONS(251), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
    STATE(86), 2,
      sym_comment,
      aux_sym_interpreted_string_literal_repeat1,
  [2065] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(87), 1,
      sym_comment,
    ACTIONS(225), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_EQ_GT,
  [2078] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(88), 1,
      sym_comment,
    ACTIONS(254), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_EQ_GT,
  [2091] = 5,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(256), 1,
      anon_sym_DQUOTE,
    STATE(86), 1,
      aux_sym_interpreted_string_literal_repeat1,
    STATE(89), 1,
      sym_comment,
    ACTIONS(233), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2108] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(90), 1,
      sym_comment,
    ACTIONS(258), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2121] = 5,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(260), 1,
      anon_sym_DQUOTE,
    STATE(80), 1,
      aux_sym_interpreted_string_literal_repeat1,
    STATE(91), 1,
      sym_comment,
    ACTIONS(233), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2138] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(92), 1,
      sym_comment,
    ACTIONS(262), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2151] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(93), 1,
      sym_comment,
    ACTIONS(264), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_EQ_GT,
  [2164] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(94), 1,
      sym_comment,
    ACTIONS(266), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2177] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(95), 1,
      sym_comment,
    ACTIONS(268), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2190] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(96), 1,
      sym_comment,
    ACTIONS(270), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2203] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(97), 1,
      sym_comment,
    ACTIONS(272), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2216] = 5,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(274), 1,
      anon_sym_DQUOTE,
    STATE(89), 1,
      aux_sym_interpreted_string_literal_repeat1,
    STATE(98), 1,
      sym_comment,
    ACTIONS(233), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2233] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(99), 1,
      sym_comment,
    ACTIONS(254), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2245] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(100), 1,
      sym_comment,
    ACTIONS(225), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2257] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(101), 1,
      sym_comment,
    ACTIONS(264), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2269] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(102), 1,
      sym_comment,
    ACTIONS(247), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2281] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(103), 1,
      sym_comment,
    ACTIONS(245), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2293] = 4,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(276), 1,
      anon_sym_DQUOTE,
    STATE(104), 1,
      sym_comment,
    ACTIONS(278), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2307] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(105), 1,
      sym_comment,
    ACTIONS(280), 3,
      anon_sym_EQ_GT,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [2319] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(282), 1,
      anon_sym_LF,
    STATE(106), 1,
      sym_comment,
  [2329] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(284), 1,
      anon_sym_LF,
    STATE(107), 1,
      sym_comment,
  [2339] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(64), 1,
      anon_sym_LF,
    STATE(108), 1,
      sym_comment,
  [2349] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(80), 1,
      anon_sym_LF,
    STATE(109), 1,
      sym_comment,
  [2359] = 3,
    ACTIONS(48), 1,
      anon_sym_LF,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(110), 1,
      sym_comment,
  [2369] = 3,
    ACTIONS(46), 1,
      anon_sym_LF,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    STATE(111), 1,
      sym_comment,
  [2379] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(286), 1,
      anon_sym_COMMA,
    STATE(112), 1,
      sym_comment,
  [2389] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(288), 1,
      anon_sym_LF,
    STATE(113), 1,
      sym_comment,
  [2399] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(290), 1,
      anon_sym_LF,
    STATE(114), 1,
      sym_comment,
  [2409] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(292), 1,
      anon_sym_LF,
    STATE(115), 1,
      sym_comment,
  [2419] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(294), 1,
      anon_sym_LF,
    STATE(116), 1,
      sym_comment,
  [2429] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(296), 1,
      anon_sym_LF,
    STATE(117), 1,
      sym_comment,
  [2439] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(298), 1,
      anon_sym_LF,
    STATE(118), 1,
      sym_comment,
  [2449] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(300), 1,
      anon_sym_LF,
    STATE(119), 1,
      sym_comment,
  [2459] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(302), 1,
      anon_sym_RBRACK,
    STATE(120), 1,
      sym_comment,
  [2469] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(304), 1,
      anon_sym_LF,
    STATE(121), 1,
      sym_comment,
  [2479] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(306), 1,
      anon_sym_LF,
    STATE(122), 1,
      sym_comment,
  [2489] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(308), 1,
      anon_sym_LF,
    STATE(123), 1,
      sym_comment,
  [2499] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(191), 1,
      anon_sym_LF,
    STATE(124), 1,
      sym_comment,
  [2509] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(310), 1,
      anon_sym_LF,
    STATE(125), 1,
      sym_comment,
  [2519] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(312), 1,
      anon_sym_LF,
    STATE(126), 1,
      sym_comment,
  [2529] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(280), 1,
      anon_sym_LF,
    STATE(127), 1,
      sym_comment,
  [2539] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(314), 1,
      anon_sym_LF,
    STATE(128), 1,
      sym_comment,
  [2549] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(316), 1,
      anon_sym_EQ_GT,
    STATE(129), 1,
      sym_comment,
  [2559] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(318), 1,
      anon_sym_LF,
    STATE(130), 1,
      sym_comment,
  [2569] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(320), 1,
      anon_sym_LF,
    STATE(131), 1,
      sym_comment,
  [2579] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(322), 1,
      anon_sym_LF,
    STATE(132), 1,
      sym_comment,
  [2589] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(324), 1,
      anon_sym_LF,
    STATE(133), 1,
      sym_comment,
  [2599] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(326), 1,
      anon_sym_LF,
    STATE(134), 1,
      sym_comment,
  [2609] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(328), 1,
      anon_sym_LF,
    STATE(135), 1,
      sym_comment,
  [2619] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(330), 1,
      anon_sym_LF,
    STATE(136), 1,
      sym_comment,
  [2629] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(332), 1,
      anon_sym_LF,
    STATE(137), 1,
      sym_comment,
  [2639] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(334), 1,
      anon_sym_RPAREN,
    STATE(138), 1,
      sym_comment,
  [2649] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(336), 1,
      anon_sym_LF,
    STATE(139), 1,
      sym_comment,
  [2659] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(338), 1,
      aux_sym_comment_token1,
    STATE(140), 1,
      sym_comment,
  [2669] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(340), 1,
      anon_sym_LF,
    STATE(141), 1,
      sym_comment,
  [2679] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(342), 1,
      ts_builtin_sym_end,
    STATE(142), 1,
      sym_comment,
  [2689] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(344), 1,
      anon_sym_LF,
    STATE(143), 1,
      sym_comment,
  [2699] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(346), 1,
      anon_sym_LF,
    STATE(144), 1,
      sym_comment,
  [2709] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(348), 1,
      anon_sym_LF,
    STATE(145), 1,
      sym_comment,
  [2719] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(350), 1,
      anon_sym_RBRACK,
    STATE(146), 1,
      sym_comment,
  [2729] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(352), 1,
      anon_sym_LF,
    STATE(147), 1,
      sym_comment,
  [2739] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(354), 1,
      anon_sym_EQ_GT,
    STATE(148), 1,
      sym_comment,
  [2749] = 3,
    ACTIONS(60), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(356), 1,
      anon_sym_LF,
    STATE(149), 1,
      sym_comment,
  [2759] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(358), 1,
      anon_sym_COMMA,
    STATE(150), 1,
      sym_comment,
  [2769] = 1,
    ACTIONS(360), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 44,
  [SMALL_STATE(4)] = 90,
  [SMALL_STATE(5)] = 110,
  [SMALL_STATE(6)] = 130,
  [SMALL_STATE(7)] = 170,
  [SMALL_STATE(8)] = 210,
  [SMALL_STATE(9)] = 230,
  [SMALL_STATE(10)] = 268,
  [SMALL_STATE(11)] = 288,
  [SMALL_STATE(12)] = 323,
  [SMALL_STATE(13)] = 360,
  [SMALL_STATE(14)] = 397,
  [SMALL_STATE(15)] = 434,
  [SMALL_STATE(16)] = 471,
  [SMALL_STATE(17)] = 508,
  [SMALL_STATE(18)] = 545,
  [SMALL_STATE(19)] = 582,
  [SMALL_STATE(20)] = 617,
  [SMALL_STATE(21)] = 652,
  [SMALL_STATE(22)] = 686,
  [SMALL_STATE(23)] = 720,
  [SMALL_STATE(24)] = 754,
  [SMALL_STATE(25)] = 785,
  [SMALL_STATE(26)] = 802,
  [SMALL_STATE(27)] = 819,
  [SMALL_STATE(28)] = 836,
  [SMALL_STATE(29)] = 853,
  [SMALL_STATE(30)] = 870,
  [SMALL_STATE(31)] = 887,
  [SMALL_STATE(32)] = 904,
  [SMALL_STATE(33)] = 935,
  [SMALL_STATE(34)] = 952,
  [SMALL_STATE(35)] = 969,
  [SMALL_STATE(36)] = 986,
  [SMALL_STATE(37)] = 1003,
  [SMALL_STATE(38)] = 1020,
  [SMALL_STATE(39)] = 1037,
  [SMALL_STATE(40)] = 1054,
  [SMALL_STATE(41)] = 1071,
  [SMALL_STATE(42)] = 1088,
  [SMALL_STATE(43)] = 1105,
  [SMALL_STATE(44)] = 1122,
  [SMALL_STATE(45)] = 1139,
  [SMALL_STATE(46)] = 1156,
  [SMALL_STATE(47)] = 1187,
  [SMALL_STATE(48)] = 1204,
  [SMALL_STATE(49)] = 1221,
  [SMALL_STATE(50)] = 1238,
  [SMALL_STATE(51)] = 1269,
  [SMALL_STATE(52)] = 1286,
  [SMALL_STATE(53)] = 1317,
  [SMALL_STATE(54)] = 1334,
  [SMALL_STATE(55)] = 1351,
  [SMALL_STATE(56)] = 1382,
  [SMALL_STATE(57)] = 1399,
  [SMALL_STATE(58)] = 1430,
  [SMALL_STATE(59)] = 1458,
  [SMALL_STATE(60)] = 1486,
  [SMALL_STATE(61)] = 1514,
  [SMALL_STATE(62)] = 1542,
  [SMALL_STATE(63)] = 1570,
  [SMALL_STATE(64)] = 1598,
  [SMALL_STATE(65)] = 1626,
  [SMALL_STATE(66)] = 1654,
  [SMALL_STATE(67)] = 1682,
  [SMALL_STATE(68)] = 1710,
  [SMALL_STATE(69)] = 1738,
  [SMALL_STATE(70)] = 1766,
  [SMALL_STATE(71)] = 1794,
  [SMALL_STATE(72)] = 1822,
  [SMALL_STATE(73)] = 1850,
  [SMALL_STATE(74)] = 1866,
  [SMALL_STATE(75)] = 1882,
  [SMALL_STATE(76)] = 1898,
  [SMALL_STATE(77)] = 1913,
  [SMALL_STATE(78)] = 1926,
  [SMALL_STATE(79)] = 1943,
  [SMALL_STATE(80)] = 1960,
  [SMALL_STATE(81)] = 1977,
  [SMALL_STATE(82)] = 1990,
  [SMALL_STATE(83)] = 2007,
  [SMALL_STATE(84)] = 2024,
  [SMALL_STATE(85)] = 2037,
  [SMALL_STATE(86)] = 2050,
  [SMALL_STATE(87)] = 2065,
  [SMALL_STATE(88)] = 2078,
  [SMALL_STATE(89)] = 2091,
  [SMALL_STATE(90)] = 2108,
  [SMALL_STATE(91)] = 2121,
  [SMALL_STATE(92)] = 2138,
  [SMALL_STATE(93)] = 2151,
  [SMALL_STATE(94)] = 2164,
  [SMALL_STATE(95)] = 2177,
  [SMALL_STATE(96)] = 2190,
  [SMALL_STATE(97)] = 2203,
  [SMALL_STATE(98)] = 2216,
  [SMALL_STATE(99)] = 2233,
  [SMALL_STATE(100)] = 2245,
  [SMALL_STATE(101)] = 2257,
  [SMALL_STATE(102)] = 2269,
  [SMALL_STATE(103)] = 2281,
  [SMALL_STATE(104)] = 2293,
  [SMALL_STATE(105)] = 2307,
  [SMALL_STATE(106)] = 2319,
  [SMALL_STATE(107)] = 2329,
  [SMALL_STATE(108)] = 2339,
  [SMALL_STATE(109)] = 2349,
  [SMALL_STATE(110)] = 2359,
  [SMALL_STATE(111)] = 2369,
  [SMALL_STATE(112)] = 2379,
  [SMALL_STATE(113)] = 2389,
  [SMALL_STATE(114)] = 2399,
  [SMALL_STATE(115)] = 2409,
  [SMALL_STATE(116)] = 2419,
  [SMALL_STATE(117)] = 2429,
  [SMALL_STATE(118)] = 2439,
  [SMALL_STATE(119)] = 2449,
  [SMALL_STATE(120)] = 2459,
  [SMALL_STATE(121)] = 2469,
  [SMALL_STATE(122)] = 2479,
  [SMALL_STATE(123)] = 2489,
  [SMALL_STATE(124)] = 2499,
  [SMALL_STATE(125)] = 2509,
  [SMALL_STATE(126)] = 2519,
  [SMALL_STATE(127)] = 2529,
  [SMALL_STATE(128)] = 2539,
  [SMALL_STATE(129)] = 2549,
  [SMALL_STATE(130)] = 2559,
  [SMALL_STATE(131)] = 2569,
  [SMALL_STATE(132)] = 2579,
  [SMALL_STATE(133)] = 2589,
  [SMALL_STATE(134)] = 2599,
  [SMALL_STATE(135)] = 2609,
  [SMALL_STATE(136)] = 2619,
  [SMALL_STATE(137)] = 2629,
  [SMALL_STATE(138)] = 2639,
  [SMALL_STATE(139)] = 2649,
  [SMALL_STATE(140)] = 2659,
  [SMALL_STATE(141)] = 2669,
  [SMALL_STATE(142)] = 2679,
  [SMALL_STATE(143)] = 2689,
  [SMALL_STATE(144)] = 2699,
  [SMALL_STATE(145)] = 2709,
  [SMALL_STATE(146)] = 2719,
  [SMALL_STATE(147)] = 2729,
  [SMALL_STATE(148)] = 2739,
  [SMALL_STATE(149)] = 2749,
  [SMALL_STATE(150)] = 2759,
  [SMALL_STATE(151)] = 2769,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [21] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [23] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(55),
  [26] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(62),
  [29] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(64),
  [32] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(23),
  [35] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(21),
  [38] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(22),
  [41] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(13),
  [44] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [46] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string_literal, 1),
  [48] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpreted_string_literal, 3),
  [50] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [52] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [54] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [56] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [58] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [60] = {.entry = {.count = 1, .reusable = false}}, SHIFT(140),
  [62] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [64] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpreted_string_literal, 2),
  [66] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_retract_directive_repeat1, 2), SHIFT_REPEAT(111),
  [69] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_retract_directive_repeat1, 2), SHIFT_REPEAT(83),
  [72] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_retract_directive_repeat1, 2), SHIFT_REPEAT(109),
  [75] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_retract_directive_repeat1, 2),
  [77] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_retract_directive_repeat1, 2), SHIFT_REPEAT(60),
  [80] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string_or_ident, 1),
  [82] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_require_directive_repeat1, 2), SHIFT_REPEAT(99),
  [85] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_require_directive_repeat1, 2), SHIFT_REPEAT(79),
  [88] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_require_directive_repeat1, 2), SHIFT_REPEAT(100),
  [91] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_require_directive_repeat1, 2),
  [93] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [95] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [97] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [99] = {.entry = {.count = 1, .reusable = false}}, SHIFT(147),
  [101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [105] = {.entry = {.count = 1, .reusable = false}}, SHIFT(88),
  [107] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [109] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [111] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [113] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(144),
  [117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [121] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_exclude_directive_repeat1, 2), SHIFT_REPEAT(99),
  [124] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_exclude_directive_repeat1, 2), SHIFT_REPEAT(79),
  [127] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_exclude_directive_repeat1, 2), SHIFT_REPEAT(100),
  [130] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_exclude_directive_repeat1, 2),
  [132] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_replace_directive_repeat1, 2), SHIFT_REPEAT(88),
  [135] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_replace_directive_repeat1, 2), SHIFT_REPEAT(98),
  [138] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_replace_directive_repeat1, 2), SHIFT_REPEAT(87),
  [141] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_replace_directive_repeat1, 2),
  [143] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [145] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [147] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [149] = {.entry = {.count = 1, .reusable = false}}, SHIFT(4),
  [151] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [155] = {.entry = {.count = 1, .reusable = false}}, SHIFT(46),
  [157] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_toolchain_name, 1),
  [159] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_require_directive, 6),
  [161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_directive, 6),
  [163] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_require_directive, 2),
  [165] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_retract_directive, 5),
  [167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclude_directive, 2),
  [169] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_directive, 6),
  [171] = {.entry = {.count = 1, .reusable = false}}, SHIFT(50),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_directive, 2),
  [175] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_require_directive, 5),
  [177] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_directive, 5),
  [179] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_spec, 5),
  [181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclude_directive, 5),
  [183] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_retract_directive, 2),
  [185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_directive, 2),
  [187] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_spec, 4),
  [189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_toolchain_directive, 2, .production_id = 1),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_path, 1),
  [193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_retract_directive, 6),
  [195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_go_directive, 3),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclude_directive, 6),
  [199] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_spec, 6),
  [203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclude_spec, 3),
  [205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive, 1),
  [207] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 1),
  [209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_require_spec, 3),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_retract_spec, 2),
  [213] = {.entry = {.count = 1, .reusable = false}}, SHIFT(114),
  [215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_retract_spec, 6),
  [217] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_retract_spec, 2),
  [219] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_retract_spec, 6),
  [221] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_retract_directive_repeat1, 1),
  [223] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_retract_directive_repeat1, 1),
  [225] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string_or_ident, 1),
  [227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file_path, 1),
  [229] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_replace_spec, 6),
  [231] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [235] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [237] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [239] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_require_directive_repeat1, 1),
  [241] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [243] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [245] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpreted_string_literal, 3),
  [247] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpreted_string_literal, 2),
  [249] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_interpreted_string_literal_repeat1, 2),
  [251] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interpreted_string_literal_repeat1, 2), SHIFT_REPEAT(104),
  [254] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string_literal, 1),
  [256] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [258] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_require_spec, 3),
  [260] = {.entry = {.count = 1, .reusable = false}}, SHIFT(8),
  [262] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_exclude_spec, 3),
  [264] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_path, 1),
  [266] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_replace_spec, 4),
  [268] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_replace_directive_repeat1, 1),
  [270] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_replace_spec, 5),
  [272] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_exclude_directive_repeat1, 1),
  [274] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [276] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_interpreted_string_literal_repeat1, 1),
  [278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_interpreted_string_literal_repeat1, 1),
  [280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_version, 1),
  [282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_go_version, 1),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [338] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [342] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [360] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_gomod(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
