/* tracker-resources.c generated by valac 0.38.1, the Vala compiler
 * generated from tracker-resources.vala, do not modify */

/*
 * Copyright (C) 2006, Jamie McCracken <jamiemcc@gnome.org>
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "tracker-store/tracker-config.h"
#include <stdlib.h>
#include <string.h>
#include "libtracker-common/tracker-common.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-data/tracker-class.h"
#include "tracker-store/tracker-events.h"
#include "tracker-store/tracker-writeback.h"


#define TRACKER_TYPE_RESOURCES (tracker_resources_get_type ())
#define TRACKER_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESOURCES, TrackerResources))
#define TRACKER_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))
#define TRACKER_IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESOURCES))
#define TRACKER_IS_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESOURCES))
#define TRACKER_RESOURCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))

typedef struct _TrackerResources TrackerResources;
typedef struct _TrackerResourcesClass TrackerResourcesClass;
typedef struct _TrackerResourcesPrivate TrackerResourcesPrivate;
enum  {
	TRACKER_RESOURCES_DUMMY_PROPERTY,
	TRACKER_RESOURCES_LAST_PROPERTY
};
static GParamSpec* tracker_resources_properties[TRACKER_RESOURCES_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerResourcesLoadData TrackerResourcesLoadData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define TRACKER_STORE_TYPE_PRIORITY (tracker_store_priority_get_type ())
typedef struct _TrackerResourcesSparqlQueryData TrackerResourcesSparqlQueryData;
typedef struct _TrackerResourcesSparqlUpdateData TrackerResourcesSparqlUpdateData;
typedef struct _TrackerResourcesSparqlUpdateBlankData TrackerResourcesSparqlUpdateBlankData;
typedef struct _TrackerResourcesBatchSparqlUpdateData TrackerResourcesBatchSparqlUpdateData;
typedef struct _Block4Data Block4Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
enum  {
	TRACKER_RESOURCES_WRITEBACK_SIGNAL,
	TRACKER_RESOURCES_GRAPH_UPDATED_SIGNAL,
	TRACKER_RESOURCES_LAST_SIGNAL
};
static guint tracker_resources_signals[TRACKER_RESOURCES_LAST_SIGNAL] = {0};

struct _TrackerResources {
	GObject parent_instance;
	TrackerResourcesPrivate * priv;
};

struct _TrackerResourcesClass {
	GObjectClass parent_class;
};

struct _TrackerResourcesPrivate {
	GDBusConnection* connection;
	guint signal_timeout;
	gboolean regular_commit_pending;
	TrackerConfig* config;
};

struct _TrackerResourcesLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* uri;
	TrackerDBusRequest* request;
	const char* _tmp0_;
	const gchar* _tmp1_;
	TrackerDBusRequest* _tmp2_;
	GFile* file;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	const char* _tmp5_;
	GError* ie;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	GError* e;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	GError * _inner_error_;
};

struct _Block3Data {
	int _ref_count_;
	TrackerResources* self;
	GVariantBuilder* builder;
};

typedef enum  {
	TRACKER_STORE_PRIORITY_HIGH,
	TRACKER_STORE_PRIORITY_LOW,
	TRACKER_STORE_PRIORITY_TURTLE,
	TRACKER_STORE_PRIORITY_N_PRIORITIES
} TrackerStorePriority;

typedef void (*TrackerStoreSparqlQueryInThread) (TrackerDBCursor* cursor, void* user_data, GError** error);
struct _TrackerResourcesSparqlQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* query;
	GVariant* result;
	TrackerDBusRequest* request;
	const char* _tmp0_;
	TrackerDBusRequest* _tmp1_;
	TrackerDBusRequest* _tmp2_;
	const gchar* _tmp3_;
	Block3Data* _data3_;
	GVariantBuilder* _tmp4_;
	const gchar* _tmp5_;
	const char* _tmp6_;
	GVariant* _result_;
	GVariantBuilder* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	gsize _tmp10_;
	GError* _tmp11_;
	TrackerDBusRequest* _tmp12_;
	GError* e;
	TrackerDBusRequest* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	GError * _inner_error_;
};

struct _TrackerResourcesSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* update;
	TrackerDBusRequest* request;
	const char* _tmp0_;
	TrackerDBusRequest* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const char* _tmp4_;
	GError* ie;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	GError* e;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	GError * _inner_error_;
};

struct _TrackerResourcesSparqlUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* update;
	GVariant* result;
	TrackerDBusRequest* request;
	const char* _tmp0_;
	TrackerDBusRequest* _tmp1_;
	TrackerDBusRequest* _tmp2_;
	const gchar* _tmp3_;
	GVariant* variant;
	const gchar* _tmp4_;
	const char* _tmp5_;
	GVariant* _tmp6_;
	TrackerDBusRequest* _tmp7_;
	GError* ie;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	GError* e;
	TrackerDBusRequest* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	GError * _inner_error_;
};

struct _TrackerResourcesBatchSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* update;
	TrackerDBusRequest* request;
	const char* _tmp0_;
	TrackerDBusRequest* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const char* _tmp4_;
	GError* ie;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	GError* e;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	GError * _inner_error_;
};

struct _Block4Data {
	int _ref_count_;
	TrackerResources* self;
	GVariantBuilder* builder;
};


static gpointer tracker_resources_parent_class = NULL;

GType tracker_resources_get_type (void) G_GNUC_CONST;
guint tracker_resources_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define TRACKER_RESOURCES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_RESOURCES, TrackerResourcesPrivate))
void tracker_resources_disable_signals (TrackerResources* self);
#define TRACKER_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
#define TRACKER_RESOURCES_GRAPH_UPDATED_IMMEDIATE_EMIT_AT 50000
#define TRACKER_RESOURCES_DBUS_ARBITRARY_MAX_MSG_SIZE 10000000
TrackerResources* tracker_resources_new (GDBusConnection* connection, TrackerConfig* config_p);
TrackerResources* tracker_resources_construct (GType object_type, GDBusConnection* connection, TrackerConfig* config_p);
static void tracker_resources_load_data_free (gpointer _data);
void tracker_resources_load (TrackerResources* self, const char* sender, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_resources_load_finish (TrackerResources* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_resources_load_co (TrackerResourcesLoadData* _data_);
void tracker_store_queue_turtle_import (GFile* file, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_, GError** error);
static void tracker_resources_load_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_resources_sparql_query_data_free (gpointer _data);
void tracker_resources_sparql_query (TrackerResources* self, const char* sender, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_resources_sparql_query_finish (TrackerResources* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_resources_sparql_query_co (TrackerResourcesSparqlQueryData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
GType tracker_store_priority_get_type (void) G_GNUC_CONST;
void tracker_store_sparql_query (const gchar* sparql, TrackerStorePriority priority, TrackerStoreSparqlQueryInThread in_thread, void* in_thread_target, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_query_finish (GAsyncResult* _res_, GError** error);
static void ___lambda6_ (Block3Data* _data3_, TrackerDBCursor* cursor, GError** error);
static void ____lambda6__tracker_store_sparql_query_in_thread (TrackerDBCursor* cursor, gpointer self, GError** error);
static void tracker_resources_sparql_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_resources_sparql_update_data_free (gpointer _data);
void tracker_resources_sparql_update (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_resources_sparql_update_finish (TrackerResources* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_resources_sparql_update_co (TrackerResourcesSparqlUpdateData* _data_);
void tracker_store_sparql_update (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_update_finish (GAsyncResult* _res_, GError** error);
static void tracker_resources_sparql_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_resources_sparql_update_blank_data_free (gpointer _data);
void tracker_resources_sparql_update_blank (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_resources_sparql_update_blank_finish (TrackerResources* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_resources_sparql_update_blank_co (TrackerResourcesSparqlUpdateBlankData* _data_);
void tracker_store_sparql_update_blank (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_, GError** error);
static void tracker_resources_sparql_update_blank_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_resources_sync (TrackerResources* self, const char* sender);
void tracker_store_wal_checkpoint (void);
static void tracker_resources_batch_sparql_update_data_free (gpointer _data);
void tracker_resources_batch_sparql_update (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_resources_batch_sparql_update_finish (TrackerResources* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_resources_batch_sparql_update_co (TrackerResourcesBatchSparqlUpdateData* _data_);
static void tracker_resources_batch_sparql_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_resources_batch_commit (TrackerResources* self);
static gboolean tracker_resources_emit_graph_updated (TrackerResources* self, TrackerClass* cl);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ___lambda7_ (Block4Data* _data4_, gint graph_id, gint subject_id, gint pred_id, gint object_id);
static void ____lambda7__tracker_events_foreach (gint graph_id, gint subject_id, gint pred_id, gint object_id, gpointer self);
static void ___lambda8_ (Block4Data* _data4_, gint graph_id, gint subject_id, gint pred_id, gint object_id);
static void ____lambda8__tracker_events_foreach (gint graph_id, gint subject_id, gint pred_id, gint object_id, gpointer self);
static gboolean tracker_resources_on_emit_signals (TrackerResources* self);
static void tracker_resources_on_statements_committed (TrackerResources* self, TrackerDataCommitType commit_type);
static gboolean _tracker_resources_on_emit_signals_gsource_func (gpointer self);
static void tracker_resources_on_statements_rolled_back (TrackerResources* self, TrackerDataCommitType commit_type);
static void tracker_resources_check_graph_updated_signal (TrackerResources* self);
static void tracker_resources_on_statement_inserted (TrackerResources* self, gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint pred_id, gint object_id, const gchar* object, GPtrArray* rdf_types);
static void tracker_resources_on_statement_deleted (TrackerResources* self, gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint pred_id, gint object_id, const gchar* object, GPtrArray* rdf_types);
void tracker_resources_enable_signals (TrackerResources* self);
static void _tracker_resources_on_statement_inserted_tracker_statement_callback (gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint predicate_id, gint object_id, const gchar* object, GPtrArray* rdf_types, gpointer self);
static void _tracker_resources_on_statement_deleted_tracker_statement_callback (gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint predicate_id, gint object_id, const gchar* object, GPtrArray* rdf_types, gpointer self);
static void _tracker_resources_on_statements_committed_tracker_commit_callback (TrackerDataCommitType commit_type, gpointer self);
static void _tracker_resources_on_statements_rolled_back_tracker_commit_callback (TrackerDataCommitType commit_type, gpointer self);
void tracker_resources_unreg_batches (TrackerResources* self, const gchar* old_owner);
void tracker_store_unreg_batches (const gchar* client_id);
static void g_cclosure_user_marshal_VOID__STRING_VARIANT_VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void tracker_resources_finalize (GObject * obj);
static void _dbus_tracker_resources_load (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_load_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_resources_sparql_query (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_sparql_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_resources_sparql_update (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_sparql_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_resources_sparql_update_blank (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_sparql_update_blank_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_resources_sync (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_batch_sparql_update (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_batch_sparql_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_resources_batch_commit (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void tracker_resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* tracker_resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean tracker_resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_tracker_resources_writeback (GObject* _sender, GVariant* subjects, gpointer* _data);
static void _dbus_tracker_resources_graph_updated (GObject* _sender, const gchar* classname, GVariant* deletes, GVariant* inserts, gpointer* _data);
static void _tracker_resources_unregister_object (gpointer user_data);

static const GDBusArgInfo _tracker_resources_dbus_arg_info_load_uri = {-1, "uri", "s"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_load_in[] = {&_tracker_resources_dbus_arg_info_load_uri, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_load_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_load = {-1, "Load", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_load_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_load_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_query_query = {-1, "query", "s"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_query_result = {-1, "result", "aas"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_query_in[] = {&_tracker_resources_dbus_arg_info_sparql_query_query, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_query_out[] = {&_tracker_resources_dbus_arg_info_sparql_query_result, NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sparql_query = {-1, "SparqlQuery", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_query_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_query_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_update_update = {-1, "update", "s"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_in[] = {&_tracker_resources_dbus_arg_info_sparql_update_update, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sparql_update = {-1, "SparqlUpdate", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_update_blank_update = {-1, "update", "s"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_update_blank_result = {-1, "result", "aaa{ss}"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_blank_in[] = {&_tracker_resources_dbus_arg_info_sparql_update_blank_update, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_blank_out[] = {&_tracker_resources_dbus_arg_info_sparql_update_blank_result, NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sparql_update_blank = {-1, "SparqlUpdateBlank", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_blank_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_blank_out)};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sync_in[] = {NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sync_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sync = {-1, "Sync", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sync_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sync_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_batch_sparql_update_update = {-1, "update", "s"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_sparql_update_in[] = {&_tracker_resources_dbus_arg_info_batch_sparql_update_update, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_sparql_update_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_batch_sparql_update = {-1, "BatchSparqlUpdate", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_sparql_update_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_sparql_update_out)};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_commit_in[] = {NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_commit_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_batch_commit = {-1, "BatchCommit", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_commit_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_commit_out)};
static const GDBusMethodInfo * const _tracker_resources_dbus_method_info[] = {&_tracker_resources_dbus_method_info_load, &_tracker_resources_dbus_method_info_sparql_query, &_tracker_resources_dbus_method_info_sparql_update, &_tracker_resources_dbus_method_info_sparql_update_blank, &_tracker_resources_dbus_method_info_sync, &_tracker_resources_dbus_method_info_batch_sparql_update, &_tracker_resources_dbus_method_info_batch_commit, NULL};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_writeback_subjects = {-1, "subjects", "a{iai}"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_writeback[] = {&_tracker_resources_dbus_arg_info_writeback_subjects, NULL};
static const GDBusSignalInfo _tracker_resources_dbus_signal_info_writeback = {-1, "Writeback", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_writeback)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_graph_updated_classname = {-1, "classname", "s"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_graph_updated_deletes = {-1, "deletes", "a(iiii)"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_graph_updated_inserts = {-1, "inserts", "a(iiii)"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_graph_updated[] = {&_tracker_resources_dbus_arg_info_graph_updated_classname, &_tracker_resources_dbus_arg_info_graph_updated_deletes, &_tracker_resources_dbus_arg_info_graph_updated_inserts, NULL};
static const GDBusSignalInfo _tracker_resources_dbus_signal_info_graph_updated = {-1, "GraphUpdated", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_graph_updated)};
static const GDBusSignalInfo * const _tracker_resources_dbus_signal_info[] = {&_tracker_resources_dbus_signal_info_writeback, &_tracker_resources_dbus_signal_info_graph_updated, NULL};
static const GDBusPropertyInfo * const _tracker_resources_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _tracker_resources_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Resources", (GDBusMethodInfo **) (&_tracker_resources_dbus_method_info), (GDBusSignalInfo **) (&_tracker_resources_dbus_signal_info), (GDBusPropertyInfo **) (&_tracker_resources_dbus_property_info)};
static const GDBusInterfaceVTable _tracker_resources_dbus_interface_vtable = {tracker_resources_dbus_interface_method_call, tracker_resources_dbus_interface_get_property, tracker_resources_dbus_interface_set_property};

static gpointer _g_object_ref0 (gpointer self) {
#line 61 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return self ? g_object_ref (self) : NULL;
#line 416 "tracker-resources.c"
}


TrackerResources* tracker_resources_construct (GType object_type, GDBusConnection* connection, TrackerConfig* config_p) {
	TrackerResources * self = NULL;
	GDBusConnection* _tmp0_;
	GDBusConnection* _tmp1_;
	TrackerConfig* _tmp2_;
	TrackerConfig* _tmp3_;
#line 60 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_val_if_fail (connection != NULL, NULL);
#line 60 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_val_if_fail (config_p != NULL, NULL);
#line 60 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	self = (TrackerResources*) g_object_new (object_type, NULL);
#line 61 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp0_ = connection;
#line 61 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 61 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (self->priv->connection);
#line 61 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	self->priv->connection = _tmp1_;
#line 62 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp2_ = config_p;
#line 62 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 62 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (self->priv->config);
#line 62 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	self->priv->config = _tmp3_;
#line 60 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return self;
#line 450 "tracker-resources.c"
}


TrackerResources* tracker_resources_new (GDBusConnection* connection, TrackerConfig* config_p) {
#line 60 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return tracker_resources_construct (TRACKER_TYPE_RESOURCES, connection, config_p);
#line 457 "tracker-resources.c"
}


static void tracker_resources_load_data_free (gpointer _data) {
	TrackerResourcesLoadData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->uri);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_slice_free (TrackerResourcesLoadData, _data_);
#line 472 "tracker-resources.c"
}


void tracker_resources_load (TrackerResources* self, const char* sender, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResourcesLoadData* _data_;
	TrackerResources* _tmp0_;
	const char* _tmp1_;
	char* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_ = g_slice_new0 (TrackerResourcesLoadData);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_resources_load_data_free);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->self = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp1_ = sender;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->sender = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp3_ = uri;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->uri);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->uri = _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_load_co (_data_);
#line 511 "tracker-resources.c"
}


void tracker_resources_load_finish (TrackerResources* self, GAsyncResult* _res_, GError** error) {
	TrackerResourcesLoadData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return;
#line 523 "tracker-resources.c"
	}
}


static void tracker_resources_load_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResourcesLoadData* _data_;
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_ = _user_data_;
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_source_object_ = source_object;
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_res_ = _res_;
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_load_co (_data_);
#line 538 "tracker-resources.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 78 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return self ? g_error_copy (self) : NULL;
#line 545 "tracker-resources.c"
}


static gboolean tracker_resources_load_co (TrackerResourcesLoadData* _data_) {
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	switch (_data_->_state_) {
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		case 0:
#line 554 "tracker-resources.c"
		goto _state_0;
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		case 1:
#line 558 "tracker-resources.c"
		goto _state_1;
		default:
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_assert_not_reached ();
#line 563 "tracker-resources.c"
	}
	_state_0:
#line 66 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = _data_->sender;
#line 66 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = _data_->uri;
#line 66 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp2_ = tracker_dbus_request_begin ((const gchar*) _data_->_tmp0_, "Resources.Load (uri: '%s')", _data_->_tmp1_, NULL);
#line 66 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->request = _data_->_tmp2_;
#line 574 "tracker-resources.c"
	{
#line 68 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp3_ = _data_->uri;
#line 68 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = g_file_new_for_uri (_data_->_tmp3_);
#line 68 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->file = _data_->_tmp4_;
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = _data_->sender;
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_state_ = 1;
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_store_queue_turtle_import (_data_->file, (const gchar*) _data_->_tmp5_, tracker_resources_load_ready, _data_);
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 590 "tracker-resources.c"
		_state_1:
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_store_queue_turtle_import_finish (_data_->_res_, &_data_->_inner_error_);
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_g_object_unref0 (_data_->file);
#line 70 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			if (g_error_matches (_data_->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
#line 600 "tracker-resources.c"
				goto __catch8_tracker_db_no_space;
			}
			goto __catch8_g_error;
		}
#line 72 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, NULL);
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_object_unref0 (_data_->file);
#line 609 "tracker-resources.c"
	}
	goto __finally8;
	__catch8_tracker_db_no_space:
	{
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->ie = _data_->_inner_error_;
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 74 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = _data_->ie;
#line 74 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = _data_->_tmp6_->message;
#line 74 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp7_);
#line 74 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = _data_->_tmp8_;
#line 74 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->ie);
#line 628 "tracker-resources.c"
		goto __finally8;
	}
	goto __finally8;
	__catch8_g_error:
	{
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->e = _data_->_inner_error_;
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 76 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = _data_->e;
#line 76 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, _data_->_tmp9_);
#line 77 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp10_ = _data_->e;
#line 77 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp10_->domain == TRACKER_SPARQL_ERROR) {
#line 78 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp11_ = _data_->e;
#line 78 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp12_ = _g_error_copy0 (_data_->_tmp11_);
#line 78 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp12_;
#line 78 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 654 "tracker-resources.c"
			goto __finally8;
		} else {
#line 80 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp13_ = _data_->e;
#line 80 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp14_ = _data_->_tmp13_->message;
#line 80 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp15_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp14_);
#line 80 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp15_;
#line 80 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 667 "tracker-resources.c"
			goto __finally8;
		}
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->e);
#line 672 "tracker-resources.c"
	}
	__finally8:
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_object_unref (_data_->_async_result);
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 683 "tracker-resources.c"
	}
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (_data_->_state_ != 0) {
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 693 "tracker-resources.c"
		}
	}
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 700 "tracker-resources.c"
}


static void tracker_resources_sparql_query_data_free (gpointer _data) {
	TrackerResourcesSparqlQueryData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->query);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_variant_unref0 (_data_->result);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_slice_free (TrackerResourcesSparqlQueryData, _data_);
#line 717 "tracker-resources.c"
}


void tracker_resources_sparql_query (TrackerResources* self, const char* sender, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResourcesSparqlQueryData* _data_;
	TrackerResources* _tmp0_;
	const char* _tmp1_;
	char* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_ = g_slice_new0 (TrackerResourcesSparqlQueryData);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_resources_sparql_query_data_free);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->self = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp1_ = sender;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->sender = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp3_ = query;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->query);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->query = _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_query_co (_data_);
#line 756 "tracker-resources.c"
}


GVariant* tracker_resources_sparql_query_finish (TrackerResources* self, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerResourcesSparqlQueryData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return NULL;
#line 769 "tracker-resources.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	result = _data_->result;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->result = NULL;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return result;
#line 777 "tracker-resources.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return _data3_;
#line 786 "tracker-resources.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 795 "tracker-resources.c"
		TrackerResources* self;
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		self = _data3_->self;
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_variant_builder_unref0 (_data3_->builder);
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_object_unref0 (self);
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_slice_free (Block3Data, _data3_);
#line 805 "tracker-resources.c"
	}
}


static void ___lambda6_ (Block3Data* _data3_, TrackerDBCursor* cursor, GError** error) {
	TrackerResources* self;
	GError * _inner_error_ = NULL;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	self = _data3_->self;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (cursor != NULL);
#line 93 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	while (TRUE) {
#line 819 "tracker-resources.c"
		gboolean _tmp0_ = FALSE;
		TrackerDBCursor* _tmp1_;
		gboolean _tmp2_;
		GVariantBuilder* _tmp3_;
		GVariantBuilder* _tmp16_;
#line 93 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp1_ = cursor;
#line 93 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp2_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _tmp1_, NULL, &_inner_error_);
#line 93 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp0_ = _tmp2_;
#line 93 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 93 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			g_propagate_error (error, _inner_error_);
#line 93 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			return;
#line 837 "tracker-resources.c"
		}
#line 93 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (!_tmp0_) {
#line 93 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			break;
#line 843 "tracker-resources.c"
		}
#line 94 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp3_ = _data3_->builder;
#line 94 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_variant_builder_open (_tmp3_, (const GVariantType*) "as");
#line 849 "tracker-resources.c"
		{
			gint i = 0;
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			i = 0;
#line 854 "tracker-resources.c"
			{
				gboolean _tmp4_ = FALSE;
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
				_tmp4_ = TRUE;
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
				while (TRUE) {
#line 861 "tracker-resources.c"
					gint _tmp6_;
					TrackerDBCursor* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					const gchar* str = NULL;
					TrackerDBCursor* _tmp10_;
					gint _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					GVariantBuilder* _tmp14_;
					const gchar* _tmp15_;
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					if (!_tmp4_) {
#line 875 "tracker-resources.c"
						gint _tmp5_;
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
						_tmp5_ = i;
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
						i = _tmp5_ + 1;
#line 881 "tracker-resources.c"
					}
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					_tmp4_ = FALSE;
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					_tmp6_ = i;
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					_tmp7_ = cursor;
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					_tmp8_ = tracker_sparql_cursor_get_n_columns ((TrackerSparqlCursor*) _tmp7_);
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					_tmp9_ = _tmp8_;
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					if (!(_tmp6_ < _tmp9_)) {
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
						break;
#line 897 "tracker-resources.c"
					}
#line 97 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					_tmp10_ = cursor;
#line 97 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					_tmp11_ = i;
#line 97 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					_tmp12_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) _tmp10_, _tmp11_, NULL);
#line 97 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					str = _tmp12_;
#line 99 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					_tmp13_ = str;
#line 99 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					if (_tmp13_ == NULL) {
#line 100 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
						str = "";
#line 913 "tracker-resources.c"
					}
#line 103 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					_tmp14_ = _data3_->builder;
#line 103 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					_tmp15_ = str;
#line 103 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					g_variant_builder_add (_tmp14_, "s", _tmp15_, NULL);
#line 921 "tracker-resources.c"
				}
			}
		}
#line 106 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp16_ = _data3_->builder;
#line 106 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_variant_builder_close (_tmp16_);
#line 929 "tracker-resources.c"
	}
}


static void ____lambda6__tracker_store_sparql_query_in_thread (TrackerDBCursor* cursor, gpointer self, GError** error) {
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	___lambda6_ (self, cursor, error);
#line 937 "tracker-resources.c"
}


static void tracker_resources_sparql_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResourcesSparqlQueryData* _data_;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_ = _user_data_;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_source_object_ = source_object;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_res_ = _res_;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_query_co (_data_);
#line 951 "tracker-resources.c"
}


static gboolean tracker_resources_sparql_query_co (TrackerResourcesSparqlQueryData* _data_) {
#line 86 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	switch (_data_->_state_) {
#line 86 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		case 0:
#line 960 "tracker-resources.c"
		goto _state_0;
#line 86 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		case 1:
#line 964 "tracker-resources.c"
		goto _state_1;
		default:
#line 86 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_assert_not_reached ();
#line 969 "tracker-resources.c"
	}
	_state_0:
#line 87 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = _data_->sender;
#line 87 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = tracker_dbus_request_begin ((const gchar*) _data_->_tmp0_, "Resources.SparqlQuery", NULL);
#line 87 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->request = _data_->_tmp1_;
#line 88 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp2_ = _data_->request;
#line 88 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp3_ = _data_->query;
#line 88 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_dbus_request_debug (_data_->_tmp2_, "query: %s", _data_->_tmp3_, NULL);
#line 984 "tracker-resources.c"
	{
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_data3_ = g_slice_new0 (Block3Data);
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_data3_->_ref_count_ = 1;
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_data3_->self = g_object_ref (_data_->self);
#line 90 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = g_variant_builder_new ((const GVariantType*) "aas");
#line 90 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_data3_->builder = _data_->_tmp4_;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = _data_->query;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = _data_->sender;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_state_ = 1;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_query (_data_->_tmp5_, TRACKER_STORE_PRIORITY_HIGH, ____lambda6__tracker_store_sparql_query_in_thread, _data_->_data3_, (const gchar*) _data_->_tmp6_, tracker_resources_sparql_query_ready, _data_);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1006 "tracker-resources.c"
		_state_1:
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_query_finish (_data_->_res_, &_data_->_inner_error_);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			block3_data_unref (_data_->_data3_);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_data3_ = NULL;
#line 1016 "tracker-resources.c"
			goto __catch9_g_error;
		}
#line 110 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = _data_->_data3_->builder;
#line 110 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = g_variant_builder_end (_data_->_tmp7_);
#line 110 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_variant_ref_sink (_data_->_tmp8_);
#line 110 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_result_ = _data_->_tmp8_;
#line 111 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = _data_->_result_;
#line 111 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp10_ = g_variant_get_size (_data_->_tmp9_);
#line 111 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp10_ > ((gsize) TRACKER_RESOURCES_DBUS_ARBITRARY_MAX_MSG_SIZE)) {
#line 112 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp11_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "result set of the query is too large");
#line 112 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp11_;
#line 112 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_g_variant_unref0 (_data_->_result_);
#line 112 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			block3_data_unref (_data_->_data3_);
#line 112 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_data3_ = NULL;
#line 1043 "tracker-resources.c"
			goto __catch9_g_error;
		}
#line 115 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp12_ = _data_->request;
#line 115 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->_tmp12_, NULL);
#line 117 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->result = _data_->_result_;
#line 117 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		block3_data_unref (_data_->_data3_);
#line 117 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_data3_ = NULL;
#line 117 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 117 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (_data_->_state_ != 0) {
#line 117 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 117 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1064 "tracker-resources.c"
			}
		}
#line 117 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_object_unref (_data_->_async_result);
#line 117 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1071 "tracker-resources.c"
	}
	goto __finally9;
	__catch9_g_error:
	{
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->e = _data_->_inner_error_;
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 119 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp13_ = _data_->request;
#line 119 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp14_ = _data_->e;
#line 119 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->_tmp13_, _data_->_tmp14_);
#line 120 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp15_ = _data_->e;
#line 120 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp15_->domain == TRACKER_SPARQL_ERROR) {
#line 121 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp16_ = _data_->e;
#line 121 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp17_ = _g_error_copy0 (_data_->_tmp16_);
#line 121 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp17_;
#line 121 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1098 "tracker-resources.c"
			goto __finally9;
		} else {
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp18_ = _data_->e;
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp19_ = _data_->_tmp18_->message;
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp20_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp19_);
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp20_;
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1111 "tracker-resources.c"
			goto __finally9;
		}
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->e);
#line 1116 "tracker-resources.c"
	}
	__finally9:
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 89 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 1125 "tracker-resources.c"
}


static void tracker_resources_sparql_update_data_free (gpointer _data) {
	TrackerResourcesSparqlUpdateData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_slice_free (TrackerResourcesSparqlUpdateData, _data_);
#line 1140 "tracker-resources.c"
}


void tracker_resources_sparql_update (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResourcesSparqlUpdateData* _data_;
	TrackerResources* _tmp0_;
	const char* _tmp1_;
	char* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_ = g_slice_new0 (TrackerResourcesSparqlUpdateData);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_resources_sparql_update_data_free);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->self = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp1_ = sender;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->sender = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp3_ = update;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->update = _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_update_co (_data_);
#line 1179 "tracker-resources.c"
}


void tracker_resources_sparql_update_finish (TrackerResources* self, GAsyncResult* _res_, GError** error) {
	TrackerResourcesSparqlUpdateData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return;
#line 1191 "tracker-resources.c"
	}
}


static void tracker_resources_sparql_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResourcesSparqlUpdateData* _data_;
#line 132 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_ = _user_data_;
#line 132 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_source_object_ = source_object;
#line 132 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_res_ = _res_;
#line 132 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_update_co (_data_);
#line 1206 "tracker-resources.c"
}


static gboolean tracker_resources_sparql_update_co (TrackerResourcesSparqlUpdateData* _data_) {
#line 128 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	switch (_data_->_state_) {
#line 128 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		case 0:
#line 1215 "tracker-resources.c"
		goto _state_0;
#line 128 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		case 1:
#line 1219 "tracker-resources.c"
		goto _state_1;
		default:
#line 128 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_assert_not_reached ();
#line 1224 "tracker-resources.c"
	}
	_state_0:
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = _data_->sender;
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = tracker_dbus_request_begin ((const gchar*) _data_->_tmp0_, "Resources.SparqlUpdate", NULL);
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->request = _data_->_tmp1_;
#line 130 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp2_ = _data_->update;
#line 130 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_dbus_request_debug (_data_->request, "query: %s", _data_->_tmp2_, NULL);
#line 1237 "tracker-resources.c"
	{
#line 132 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp3_ = _data_->update;
#line 132 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = _data_->sender;
#line 132 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_state_ = 1;
#line 132 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_update (_data_->_tmp3_, TRACKER_STORE_PRIORITY_HIGH, (const gchar*) _data_->_tmp4_, tracker_resources_sparql_update_ready, _data_);
#line 132 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1249 "tracker-resources.c"
		_state_1:
#line 132 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_update_finish (_data_->_res_, &_data_->_inner_error_);
#line 132 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 132 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			if (g_error_matches (_data_->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
#line 1257 "tracker-resources.c"
				goto __catch10_tracker_db_no_space;
			}
			goto __catch10_g_error;
		}
#line 134 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, NULL);
#line 1264 "tracker-resources.c"
	}
	goto __finally10;
	__catch10_tracker_db_no_space:
	{
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->ie = _data_->_inner_error_;
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 136 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = _data_->ie;
#line 136 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = _data_->_tmp5_->message;
#line 136 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp6_);
#line 136 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = _data_->_tmp7_;
#line 136 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->ie);
#line 1283 "tracker-resources.c"
		goto __finally10;
	}
	goto __finally10;
	__catch10_g_error:
	{
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->e = _data_->_inner_error_;
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 138 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = _data_->e;
#line 138 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, _data_->_tmp8_);
#line 139 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = _data_->e;
#line 139 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp9_->domain == TRACKER_SPARQL_ERROR) {
#line 140 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp10_ = _data_->e;
#line 140 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp11_ = _g_error_copy0 (_data_->_tmp10_);
#line 140 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp11_;
#line 140 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1309 "tracker-resources.c"
			goto __finally10;
		} else {
#line 142 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp12_ = _data_->e;
#line 142 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp13_ = _data_->_tmp12_->message;
#line 142 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp14_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp13_);
#line 142 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp14_;
#line 142 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1322 "tracker-resources.c"
			goto __finally10;
		}
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->e);
#line 1327 "tracker-resources.c"
	}
	__finally10:
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_object_unref (_data_->_async_result);
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1338 "tracker-resources.c"
	}
#line 128 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 128 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (_data_->_state_ != 0) {
#line 128 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 128 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1348 "tracker-resources.c"
		}
	}
#line 128 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 128 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 1355 "tracker-resources.c"
}


static void tracker_resources_sparql_update_blank_data_free (gpointer _data) {
	TrackerResourcesSparqlUpdateBlankData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_variant_unref0 (_data_->result);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_slice_free (TrackerResourcesSparqlUpdateBlankData, _data_);
#line 1372 "tracker-resources.c"
}


void tracker_resources_sparql_update_blank (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResourcesSparqlUpdateBlankData* _data_;
	TrackerResources* _tmp0_;
	const char* _tmp1_;
	char* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_ = g_slice_new0 (TrackerResourcesSparqlUpdateBlankData);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_resources_sparql_update_blank_data_free);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->self = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp1_ = sender;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->sender = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp3_ = update;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->update = _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_update_blank_co (_data_);
#line 1411 "tracker-resources.c"
}


GVariant* tracker_resources_sparql_update_blank_finish (TrackerResources* self, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerResourcesSparqlUpdateBlankData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return NULL;
#line 1424 "tracker-resources.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	result = _data_->result;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->result = NULL;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return result;
#line 1432 "tracker-resources.c"
}


static void tracker_resources_sparql_update_blank_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResourcesSparqlUpdateBlankData* _data_;
#line 152 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_ = _user_data_;
#line 152 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_source_object_ = source_object;
#line 152 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_res_ = _res_;
#line 152 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_update_blank_co (_data_);
#line 1446 "tracker-resources.c"
}


static gboolean tracker_resources_sparql_update_blank_co (TrackerResourcesSparqlUpdateBlankData* _data_) {
#line 148 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	switch (_data_->_state_) {
#line 148 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		case 0:
#line 1455 "tracker-resources.c"
		goto _state_0;
#line 148 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		case 1:
#line 1459 "tracker-resources.c"
		goto _state_1;
		default:
#line 148 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_assert_not_reached ();
#line 1464 "tracker-resources.c"
	}
	_state_0:
#line 149 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = _data_->sender;
#line 149 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = tracker_dbus_request_begin ((const gchar*) _data_->_tmp0_, "Resources.SparqlUpdateBlank", NULL);
#line 149 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->request = _data_->_tmp1_;
#line 150 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp2_ = _data_->request;
#line 150 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp3_ = _data_->update;
#line 150 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_dbus_request_debug (_data_->_tmp2_, "query: %s", _data_->_tmp3_, NULL);
#line 1479 "tracker-resources.c"
	{
#line 152 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = _data_->update;
#line 152 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = _data_->sender;
#line 152 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_state_ = 1;
#line 152 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_update_blank (_data_->_tmp4_, TRACKER_STORE_PRIORITY_HIGH, (const gchar*) _data_->_tmp5_, tracker_resources_sparql_update_blank_ready, _data_);
#line 152 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1491 "tracker-resources.c"
		_state_1:
#line 152 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = tracker_store_sparql_update_blank_finish (_data_->_res_, &_data_->_inner_error_);
#line 152 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->variant = _data_->_tmp6_;
#line 152 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 152 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			if (g_error_matches (_data_->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
#line 1501 "tracker-resources.c"
				goto __catch11_tracker_db_no_space;
			}
			goto __catch11_g_error;
		}
#line 154 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = _data_->request;
#line 154 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->_tmp7_, NULL);
#line 156 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->result = _data_->variant;
#line 156 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 156 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (_data_->_state_ != 0) {
#line 156 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 156 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1520 "tracker-resources.c"
			}
		}
#line 156 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_object_unref (_data_->_async_result);
#line 156 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1527 "tracker-resources.c"
	}
	goto __finally11;
	__catch11_tracker_db_no_space:
	{
#line 151 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->ie = _data_->_inner_error_;
#line 151 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 158 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = _data_->ie;
#line 158 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = _data_->_tmp8_->message;
#line 158 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp10_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp9_);
#line 158 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = _data_->_tmp10_;
#line 158 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->ie);
#line 1546 "tracker-resources.c"
		goto __finally11;
	}
	goto __finally11;
	__catch11_g_error:
	{
#line 151 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->e = _data_->_inner_error_;
#line 151 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 160 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp11_ = _data_->request;
#line 160 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp12_ = _data_->e;
#line 160 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->_tmp11_, _data_->_tmp12_);
#line 161 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp13_ = _data_->e;
#line 161 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp13_->domain == TRACKER_SPARQL_ERROR) {
#line 162 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp14_ = _data_->e;
#line 162 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp15_ = _g_error_copy0 (_data_->_tmp14_);
#line 162 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp15_;
#line 162 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1574 "tracker-resources.c"
			goto __finally11;
		} else {
#line 164 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp16_ = _data_->e;
#line 164 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp17_ = _data_->_tmp16_->message;
#line 164 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp18_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp17_);
#line 164 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp18_;
#line 164 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1587 "tracker-resources.c"
			goto __finally11;
		}
#line 151 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->e);
#line 1592 "tracker-resources.c"
	}
	__finally11:
#line 151 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 151 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 151 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 1601 "tracker-resources.c"
}


void tracker_resources_sync (TrackerResources* self, const char* sender) {
	TrackerDBusRequest* request = NULL;
	const char* _tmp0_;
	TrackerDBusRequest* _tmp1_;
#line 169 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 169 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (sender != NULL);
#line 170 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp0_ = sender;
#line 170 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp1_ = tracker_dbus_request_begin ((const gchar*) _tmp0_, "Resources.Sync", NULL);
#line 170 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	request = _tmp1_;
#line 173 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_store_wal_checkpoint ();
#line 175 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_data_sync ();
#line 177 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_dbus_request_end (request, NULL);
#line 1625 "tracker-resources.c"
}


static void tracker_resources_batch_sparql_update_data_free (gpointer _data) {
	TrackerResourcesBatchSparqlUpdateData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_slice_free (TrackerResourcesBatchSparqlUpdateData, _data_);
#line 1640 "tracker-resources.c"
}


void tracker_resources_batch_sparql_update (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResourcesBatchSparqlUpdateData* _data_;
	TrackerResources* _tmp0_;
	const char* _tmp1_;
	char* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_ = g_slice_new0 (TrackerResourcesBatchSparqlUpdateData);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_resources_batch_sparql_update_data_free);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->self = _tmp0_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp1_ = sender;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->sender = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp3_ = update;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->update = _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_batch_sparql_update_co (_data_);
#line 1679 "tracker-resources.c"
}


void tracker_resources_batch_sparql_update_finish (TrackerResources* self, GAsyncResult* _res_, GError** error) {
	TrackerResourcesBatchSparqlUpdateData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (NULL == _data_) {
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return;
#line 1691 "tracker-resources.c"
	}
}


static void tracker_resources_batch_sparql_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResourcesBatchSparqlUpdateData* _data_;
#line 184 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_ = _user_data_;
#line 184 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_source_object_ = source_object;
#line 184 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_res_ = _res_;
#line 184 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_batch_sparql_update_co (_data_);
#line 1706 "tracker-resources.c"
}


static gboolean tracker_resources_batch_sparql_update_co (TrackerResourcesBatchSparqlUpdateData* _data_) {
#line 180 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	switch (_data_->_state_) {
#line 180 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		case 0:
#line 1715 "tracker-resources.c"
		goto _state_0;
#line 180 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		case 1:
#line 1719 "tracker-resources.c"
		goto _state_1;
		default:
#line 180 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_assert_not_reached ();
#line 1724 "tracker-resources.c"
	}
	_state_0:
#line 181 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = _data_->sender;
#line 181 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = tracker_dbus_request_begin ((const gchar*) _data_->_tmp0_, "Resources.BatchSparqlUpdate", NULL);
#line 181 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->request = _data_->_tmp1_;
#line 182 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_data_->_tmp2_ = _data_->update;
#line 182 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_dbus_request_debug (_data_->request, "query: %s", _data_->_tmp2_, NULL);
#line 1737 "tracker-resources.c"
	{
#line 184 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp3_ = _data_->update;
#line 184 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = _data_->sender;
#line 184 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_state_ = 1;
#line 184 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_update (_data_->_tmp3_, TRACKER_STORE_PRIORITY_LOW, (const gchar*) _data_->_tmp4_, tracker_resources_batch_sparql_update_ready, _data_);
#line 184 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1749 "tracker-resources.c"
		_state_1:
#line 184 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_update_finish (_data_->_res_, &_data_->_inner_error_);
#line 184 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 184 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			if (g_error_matches (_data_->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
#line 1757 "tracker-resources.c"
				goto __catch12_tracker_db_no_space;
			}
			goto __catch12_g_error;
		}
#line 186 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, NULL);
#line 1764 "tracker-resources.c"
	}
	goto __finally12;
	__catch12_tracker_db_no_space:
	{
#line 183 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->ie = _data_->_inner_error_;
#line 183 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 188 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = _data_->ie;
#line 188 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = _data_->_tmp5_->message;
#line 188 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp6_);
#line 188 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = _data_->_tmp7_;
#line 188 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->ie);
#line 1783 "tracker-resources.c"
		goto __finally12;
	}
	goto __finally12;
	__catch12_g_error:
	{
#line 183 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->e = _data_->_inner_error_;
#line 183 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 190 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = _data_->e;
#line 190 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, _data_->_tmp8_);
#line 191 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = _data_->e;
#line 191 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp9_->domain == TRACKER_SPARQL_ERROR) {
#line 192 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp10_ = _data_->e;
#line 192 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp11_ = _g_error_copy0 (_data_->_tmp10_);
#line 192 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp11_;
#line 192 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1809 "tracker-resources.c"
			goto __finally12;
		} else {
#line 194 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp12_ = _data_->e;
#line 194 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp13_ = _data_->_tmp12_->message;
#line 194 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_tmp14_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp13_);
#line 194 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp14_;
#line 194 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1822 "tracker-resources.c"
			goto __finally12;
		}
#line 183 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->e);
#line 1827 "tracker-resources.c"
	}
	__finally12:
#line 183 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 183 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 183 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_object_unref (_data_->_async_result);
#line 183 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1838 "tracker-resources.c"
	}
#line 180 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 180 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (_data_->_state_ != 0) {
#line 180 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 180 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1848 "tracker-resources.c"
		}
	}
#line 180 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 180 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 1855 "tracker-resources.c"
}


void tracker_resources_batch_commit (TrackerResources* self) {
#line 199 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 1862 "tracker-resources.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return _data4_;
#line 1871 "tracker-resources.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 1880 "tracker-resources.c"
		TrackerResources* self;
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		self = _data4_->self;
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_variant_builder_unref0 (_data4_->builder);
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_object_unref0 (self);
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_slice_free (Block4Data, _data4_);
#line 1890 "tracker-resources.c"
	}
}


static void ___lambda7_ (Block4Data* _data4_, gint graph_id, gint subject_id, gint pred_id, gint object_id) {
	TrackerResources* self;
	GVariantBuilder* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
#line 206 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	self = _data4_->self;
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _data4_->builder;
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp1_ = graph_id;
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp2_ = subject_id;
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp3_ = pred_id;
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp4_ = object_id;
#line 207 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_variant_builder_add (_tmp0_, "(iiii)", _tmp1_, _tmp2_, _tmp3_, _tmp4_, NULL);
#line 1916 "tracker-resources.c"
}


static void ____lambda7__tracker_events_foreach (gint graph_id, gint subject_id, gint pred_id, gint object_id, gpointer self) {
#line 206 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	___lambda7_ (self, graph_id, subject_id, pred_id, object_id);
#line 1923 "tracker-resources.c"
}


static void ___lambda8_ (Block4Data* _data4_, gint graph_id, gint subject_id, gint pred_id, gint object_id) {
	TrackerResources* self;
	GVariantBuilder* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
#line 212 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	self = _data4_->self;
#line 213 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _data4_->builder;
#line 213 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp1_ = graph_id;
#line 213 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp2_ = subject_id;
#line 213 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp3_ = pred_id;
#line 213 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp4_ = object_id;
#line 213 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_variant_builder_add (_tmp0_, "(iiii)", _tmp1_, _tmp2_, _tmp3_, _tmp4_, NULL);
#line 1948 "tracker-resources.c"
}


static void ____lambda8__tracker_events_foreach (gint graph_id, gint subject_id, gint pred_id, gint object_id, gpointer self) {
#line 212 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	___lambda8_ (self, graph_id, subject_id, pred_id, object_id);
#line 1955 "tracker-resources.c"
}


static gboolean tracker_resources_emit_graph_updated (TrackerResources* self, TrackerClass* cl) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerClass* _tmp1_;
	gboolean _tmp2_;
#line 203 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 203 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_val_if_fail (cl != NULL, FALSE);
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp1_ = cl;
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp2_ = tracker_class_has_insert_events (_tmp1_);
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (_tmp2_) {
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp0_ = TRUE;
#line 1976 "tracker-resources.c"
	} else {
		TrackerClass* _tmp3_;
		gboolean _tmp4_;
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp3_ = cl;
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp4_ = tracker_class_has_delete_events (_tmp3_);
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp0_ = _tmp4_;
#line 1986 "tracker-resources.c"
	}
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (_tmp0_) {
#line 1990 "tracker-resources.c"
		Block4Data* _data4_;
		GVariantBuilder* _tmp5_;
		TrackerClass* _tmp6_;
		GVariant* deletes = NULL;
		GVariantBuilder* _tmp7_;
		GVariant* _tmp8_;
		GVariantBuilder* _tmp9_;
		TrackerClass* _tmp10_;
		GVariant* inserts = NULL;
		GVariantBuilder* _tmp11_;
		GVariant* _tmp12_;
		TrackerClass* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		GVariant* _tmp16_;
		GVariant* _tmp17_;
		TrackerClass* _tmp18_;
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data4_ = g_slice_new0 (Block4Data);
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data4_->_ref_count_ = 1;
#line 204 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data4_->self = g_object_ref (self);
#line 205 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp5_ = g_variant_builder_new ((const GVariantType*) "a(iiii)");
#line 205 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data4_->builder = _tmp5_;
#line 206 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp6_ = cl;
#line 206 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_class_foreach_delete_event (_tmp6_, ____lambda7__tracker_events_foreach, _data4_);
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp7_ = _data4_->builder;
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp8_ = g_variant_builder_end (_tmp7_);
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_variant_ref_sink (_tmp8_);
#line 209 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		deletes = _tmp8_;
#line 211 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp9_ = g_variant_builder_new ((const GVariantType*) "a(iiii)");
#line 211 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_variant_builder_unref0 (_data4_->builder);
#line 211 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data4_->builder = _tmp9_;
#line 212 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp10_ = cl;
#line 212 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_class_foreach_insert_event (_tmp10_, ____lambda8__tracker_events_foreach, _data4_);
#line 215 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp11_ = _data4_->builder;
#line 215 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp12_ = g_variant_builder_end (_tmp11_);
#line 215 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_variant_ref_sink (_tmp12_);
#line 215 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		inserts = _tmp12_;
#line 217 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp13_ = cl;
#line 217 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp14_ = tracker_class_get_uri (_tmp13_);
#line 217 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp15_ = _tmp14_;
#line 217 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp16_ = deletes;
#line 217 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp17_ = inserts;
#line 217 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_signal_emit (self, tracker_resources_signals[TRACKER_RESOURCES_GRAPH_UPDATED_SIGNAL], 0, _tmp15_, _tmp16_, _tmp17_);
#line 219 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp18_ = cl;
#line 219 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_class_reset_ready_events (_tmp18_);
#line 221 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		result = TRUE;
#line 221 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_variant_unref0 (inserts);
#line 221 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_variant_unref0 (deletes);
#line 221 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		block4_data_unref (_data4_);
#line 221 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_data4_ = NULL;
#line 221 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		return result;
#line 2076 "tracker-resources.c"
	}
#line 223 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	result = FALSE;
#line 223 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return result;
#line 2082 "tracker-resources.c"
}


static gpointer _g_hash_table_ref0 (gpointer self) {
#line 235 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return self ? g_hash_table_ref (self) : NULL;
#line 2089 "tracker-resources.c"
}


static gboolean tracker_resources_on_emit_signals (TrackerResources* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	TrackerClass** _tmp1_;
	GHashTable* writebacks = NULL;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
#line 226 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 227 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp1_ = tracker_events_get_classes (&_tmp0_);
#line 2105 "tracker-resources.c"
	{
		TrackerClass** cl_collection = NULL;
		gint cl_collection_length1 = 0;
		gint _cl_collection_size_ = 0;
		gint cl_it = 0;
#line 227 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		cl_collection = _tmp1_;
#line 227 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		cl_collection_length1 = _tmp0_;
#line 227 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		for (cl_it = 0; cl_it < _tmp0_; cl_it = cl_it + 1) {
#line 2117 "tracker-resources.c"
			TrackerClass* _tmp2_;
			TrackerClass* cl = NULL;
#line 227 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_tmp2_ = _g_object_ref0 (cl_collection[cl_it]);
#line 227 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			cl = _tmp2_;
#line 2124 "tracker-resources.c"
			{
				TrackerClass* _tmp3_;
#line 228 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
				_tmp3_ = cl;
#line 228 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
				tracker_resources_emit_graph_updated (self, _tmp3_);
#line 227 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
				_g_object_unref0 (cl);
#line 2133 "tracker-resources.c"
			}
		}
	}
#line 232 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_events_get_total (TRUE);
#line 235 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp4_ = tracker_writeback_get_ready ();
#line 235 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp5_ = _g_hash_table_ref0 (_tmp4_);
#line 235 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	writebacks = _tmp5_;
#line 237 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp6_ = writebacks;
#line 237 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (_tmp6_ != NULL) {
#line 2149 "tracker-resources.c"
		GVariantBuilder* builder = NULL;
		GVariantBuilder* _tmp7_;
		GHashTableIter wb_iter = {0};
		GHashTable* _tmp8_;
		gint subject_id = 0;
		GArray* types = NULL;
		GVariantBuilder* _tmp27_;
		GVariant* _tmp28_;
		GVariant* _tmp29_;
#line 238 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp7_ = g_variant_builder_new ((const GVariantType*) "a{iai}");
#line 238 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		builder = _tmp7_;
#line 240 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp8_ = writebacks;
#line 240 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_hash_table_iter_init (&wb_iter, _tmp8_);
#line 244 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		while (TRUE) {
#line 2169 "tracker-resources.c"
			gconstpointer _tmp9_ = NULL;
			gconstpointer _tmp10_ = NULL;
			gboolean _tmp11_;
			GVariantBuilder* _tmp12_;
			GVariantBuilder* _tmp13_;
			gint _tmp14_;
			GVariantBuilder* _tmp15_;
			GVariantBuilder* _tmp25_;
			GVariantBuilder* _tmp26_;
#line 244 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_tmp11_ = g_hash_table_iter_next (&wb_iter, (gpointer*) (&_tmp9_), (gpointer*) (&_tmp10_));
#line 244 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			subject_id = _tmp9_;
#line 244 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			types = _tmp10_;
#line 244 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			if (!_tmp11_) {
#line 244 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
				break;
#line 2189 "tracker-resources.c"
			}
#line 245 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_tmp12_ = builder;
#line 245 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			g_variant_builder_open (_tmp12_, (const GVariantType*) "{iai}");
#line 247 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_tmp13_ = builder;
#line 247 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_tmp14_ = subject_id;
#line 247 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			g_variant_builder_add (_tmp13_, "i", _tmp14_, NULL);
#line 249 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_tmp15_ = builder;
#line 249 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			g_variant_builder_open (_tmp15_, (const GVariantType*) "ai");
#line 2205 "tracker-resources.c"
			{
				gint i = 0;
#line 250 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
				i = 0;
#line 2210 "tracker-resources.c"
				{
					gboolean _tmp16_ = FALSE;
#line 250 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					_tmp16_ = TRUE;
#line 250 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
					while (TRUE) {
#line 2217 "tracker-resources.c"
						gint _tmp18_;
						GArray* _tmp19_;
						guint _tmp20_;
						GVariantBuilder* _tmp21_;
						GArray* _tmp22_;
						gint _tmp23_;
						gint _tmp24_;
#line 250 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
						if (!_tmp16_) {
#line 2227 "tracker-resources.c"
							gint _tmp17_;
#line 250 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
							_tmp17_ = i;
#line 250 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
							i = _tmp17_ + 1;
#line 2233 "tracker-resources.c"
						}
#line 250 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
						_tmp16_ = FALSE;
#line 250 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
						_tmp18_ = i;
#line 250 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
						_tmp19_ = types;
#line 250 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
						_tmp20_ = _tmp19_->len;
#line 250 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
						if (!(((guint) _tmp18_) < _tmp20_)) {
#line 250 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
							break;
#line 2247 "tracker-resources.c"
						}
#line 251 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
						_tmp21_ = builder;
#line 251 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
						_tmp22_ = types;
#line 251 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
						_tmp23_ = i;
#line 251 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
						_tmp24_ = g_array_index (_tmp22_, gint, (guint) _tmp23_);
#line 251 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
						g_variant_builder_add (_tmp21_, "i", _tmp24_, NULL);
#line 2259 "tracker-resources.c"
					}
				}
			}
#line 253 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_tmp25_ = builder;
#line 253 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			g_variant_builder_close (_tmp25_);
#line 255 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_tmp26_ = builder;
#line 255 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			g_variant_builder_close (_tmp26_);
#line 2271 "tracker-resources.c"
		}
#line 258 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp27_ = builder;
#line 258 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp28_ = g_variant_builder_end (_tmp27_);
#line 258 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_variant_ref_sink (_tmp28_);
#line 258 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp29_ = _tmp28_;
#line 258 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_signal_emit (self, tracker_resources_signals[TRACKER_RESOURCES_WRITEBACK_SIGNAL], 0, _tmp29_);
#line 258 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_variant_unref0 (_tmp29_);
#line 237 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_g_variant_builder_unref0 (builder);
#line 2287 "tracker-resources.c"
	}
#line 261 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_writeback_reset_ready ();
#line 263 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	self->priv->regular_commit_pending = FALSE;
#line 264 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	self->priv->signal_timeout = (guint) 0;
#line 265 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	result = FALSE;
#line 265 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_hash_table_unref0 (writebacks);
#line 265 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return result;
#line 2301 "tracker-resources.c"
}


static gboolean _tracker_resources_on_emit_signals_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_resources_on_emit_signals ((TrackerResources*) self);
#line 297 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	return result;
#line 2310 "tracker-resources.c"
}


static void tracker_resources_on_statements_committed (TrackerResources* self, TrackerDataCommitType commit_type) {
	gint _tmp0_;
	TrackerClass** _tmp1_;
	gboolean _tmp4_;
	TrackerDataCommitType _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_;
#line 268 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 271 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp1_ = tracker_events_get_classes (&_tmp0_);
#line 2325 "tracker-resources.c"
	{
		TrackerClass** cl_collection = NULL;
		gint cl_collection_length1 = 0;
		gint _cl_collection_size_ = 0;
		gint cl_it = 0;
#line 271 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		cl_collection = _tmp1_;
#line 271 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		cl_collection_length1 = _tmp0_;
#line 271 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		for (cl_it = 0; cl_it < _tmp0_; cl_it = cl_it + 1) {
#line 2337 "tracker-resources.c"
			TrackerClass* _tmp2_;
			TrackerClass* cl = NULL;
#line 271 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_tmp2_ = _g_object_ref0 (cl_collection[cl_it]);
#line 271 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			cl = _tmp2_;
#line 2344 "tracker-resources.c"
			{
				TrackerClass* _tmp3_;
#line 272 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
				_tmp3_ = cl;
#line 272 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
				tracker_class_transact_events (_tmp3_);
#line 271 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
				_g_object_unref0 (cl);
#line 2353 "tracker-resources.c"
			}
		}
	}
#line 275 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp4_ = self->priv->regular_commit_pending;
#line 275 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (!_tmp4_) {
#line 2361 "tracker-resources.c"
		guint _tmp5_;
#line 284 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp5_ = self->priv->signal_timeout;
#line 284 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (_tmp5_ != ((guint) 0)) {
#line 2367 "tracker-resources.c"
			guint _tmp6_;
#line 285 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_tmp6_ = self->priv->signal_timeout;
#line 285 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			g_source_remove (_tmp6_);
#line 286 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			self->priv->signal_timeout = (guint) 0;
#line 2375 "tracker-resources.c"
		}
	}
#line 290 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp7_ = commit_type;
#line 290 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (_tmp7_ == TRACKER_DATA_COMMIT_REGULAR) {
#line 291 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		self->priv->regular_commit_pending = TRUE;
#line 2384 "tracker-resources.c"
	}
#line 294 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp9_ = self->priv->regular_commit_pending;
#line 294 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (_tmp9_) {
#line 294 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp8_ = TRUE;
#line 2392 "tracker-resources.c"
	} else {
		TrackerDataCommitType _tmp10_;
#line 294 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp10_ = commit_type;
#line 294 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp8_ = _tmp10_ == TRACKER_DATA_COMMIT_BATCH_LAST;
#line 2399 "tracker-resources.c"
	}
#line 294 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (_tmp8_) {
#line 2403 "tracker-resources.c"
		guint _tmp11_;
#line 296 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp11_ = self->priv->signal_timeout;
#line 296 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (_tmp11_ == ((guint) 0)) {
#line 2409 "tracker-resources.c"
			TrackerConfig* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			guint _tmp15_;
#line 297 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_tmp12_ = self->priv->config;
#line 297 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_tmp13_ = tracker_config_get_graphupdated_delay (_tmp12_);
#line 297 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_tmp14_ = _tmp13_;
#line 297 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_tmp15_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp14_, _tracker_resources_on_emit_signals_gsource_func, g_object_ref (self), g_object_unref);
#line 297 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			self->priv->signal_timeout = _tmp15_;
#line 2424 "tracker-resources.c"
		}
	}
#line 302 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_writeback_transact ();
#line 2429 "tracker-resources.c"
}


static void tracker_resources_on_statements_rolled_back (TrackerResources* self, TrackerDataCommitType commit_type) {
#line 305 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 306 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_events_reset_pending ();
#line 307 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_writeback_reset_pending ();
#line 2440 "tracker-resources.c"
}


static void tracker_resources_check_graph_updated_signal (TrackerResources* self) {
	guint _tmp0_;
#line 310 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 312 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp0_ = tracker_events_get_total (FALSE);
#line 312 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (_tmp0_ > ((guint) TRACKER_RESOURCES_GRAPH_UPDATED_IMMEDIATE_EMIT_AT)) {
#line 2452 "tracker-resources.c"
		guint _tmp1_;
#line 316 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp1_ = self->priv->signal_timeout;
#line 316 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		if (_tmp1_ != ((guint) 0)) {
#line 2458 "tracker-resources.c"
			guint _tmp2_;
#line 317 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			_tmp2_ = self->priv->signal_timeout;
#line 317 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			g_source_remove (_tmp2_);
#line 318 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
			self->priv->signal_timeout = (guint) 0;
#line 2466 "tracker-resources.c"
		}
#line 322 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		tracker_resources_on_emit_signals (self);
#line 2470 "tracker-resources.c"
	}
}


static void tracker_resources_on_statement_inserted (TrackerResources* self, gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint pred_id, gint object_id, const gchar* object, GPtrArray* rdf_types) {
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	GPtrArray* _tmp6_;
	gint _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	const gchar* _tmp13_;
	GPtrArray* _tmp14_;
#line 326 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 326 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (subject != NULL);
#line 326 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (rdf_types != NULL);
#line 327 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp0_ = graph_id;
#line 327 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp1_ = subject_id;
#line 327 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp2_ = subject;
#line 327 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp3_ = pred_id;
#line 327 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp4_ = object_id;
#line 327 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp5_ = object;
#line 327 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp6_ = rdf_types;
#line 327 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_events_add_insert (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
#line 328 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp7_ = graph_id;
#line 328 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp8_ = graph;
#line 328 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp9_ = subject_id;
#line 328 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp10_ = subject;
#line 328 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp11_ = pred_id;
#line 328 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp12_ = object_id;
#line 328 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp13_ = object;
#line 328 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp14_ = rdf_types;
#line 328 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_writeback_check (_tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_);
#line 329 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_check_graph_updated_signal (self);
#line 2533 "tracker-resources.c"
}


static void tracker_resources_on_statement_deleted (TrackerResources* self, gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint pred_id, gint object_id, const gchar* object, GPtrArray* rdf_types) {
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	GPtrArray* _tmp6_;
	gint _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	const gchar* _tmp13_;
	GPtrArray* _tmp14_;
#line 332 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 332 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (subject != NULL);
#line 332 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (rdf_types != NULL);
#line 333 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp0_ = graph_id;
#line 333 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp1_ = subject_id;
#line 333 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp2_ = subject;
#line 333 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp3_ = pred_id;
#line 333 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp4_ = object_id;
#line 333 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp5_ = object;
#line 333 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp6_ = rdf_types;
#line 333 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_events_add_delete (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
#line 334 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp7_ = graph_id;
#line 334 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp8_ = graph;
#line 334 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp9_ = subject_id;
#line 334 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp10_ = subject;
#line 334 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp11_ = pred_id;
#line 334 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp12_ = object_id;
#line 334 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp13_ = object;
#line 334 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp14_ = rdf_types;
#line 334 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_writeback_check (_tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_);
#line 335 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_check_graph_updated_signal (self);
#line 2595 "tracker-resources.c"
}


static void _tracker_resources_on_statement_inserted_tracker_statement_callback (gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint predicate_id, gint object_id, const gchar* object, GPtrArray* rdf_types, gpointer self) {
#line 340 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_on_statement_inserted ((TrackerResources*) self, graph_id, graph, subject_id, subject, predicate_id, object_id, object, rdf_types);
#line 2602 "tracker-resources.c"
}


static void _tracker_resources_on_statement_deleted_tracker_statement_callback (gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint predicate_id, gint object_id, const gchar* object, GPtrArray* rdf_types, gpointer self) {
#line 341 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_on_statement_deleted ((TrackerResources*) self, graph_id, graph, subject_id, subject, predicate_id, object_id, object, rdf_types);
#line 2609 "tracker-resources.c"
}


static void _tracker_resources_on_statements_committed_tracker_commit_callback (TrackerDataCommitType commit_type, gpointer self) {
#line 342 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_on_statements_committed ((TrackerResources*) self, commit_type);
#line 2616 "tracker-resources.c"
}


static void _tracker_resources_on_statements_rolled_back_tracker_commit_callback (TrackerDataCommitType commit_type, gpointer self) {
#line 343 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_on_statements_rolled_back ((TrackerResources*) self, commit_type);
#line 2623 "tracker-resources.c"
}


void tracker_resources_enable_signals (TrackerResources* self) {
#line 339 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 340 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_data_add_insert_statement_callback (_tracker_resources_on_statement_inserted_tracker_statement_callback, self);
#line 341 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_data_add_delete_statement_callback (_tracker_resources_on_statement_deleted_tracker_statement_callback, self);
#line 342 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_data_add_commit_statement_callback (_tracker_resources_on_statements_committed_tracker_commit_callback, self);
#line 343 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_data_add_rollback_statement_callback (_tracker_resources_on_statements_rolled_back_tracker_commit_callback, self);
#line 2638 "tracker-resources.c"
}


void tracker_resources_disable_signals (TrackerResources* self) {
	guint _tmp0_;
#line 347 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 348 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_data_remove_insert_statement_callback (_tracker_resources_on_statement_inserted_tracker_statement_callback, self);
#line 349 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_data_remove_delete_statement_callback (_tracker_resources_on_statement_deleted_tracker_statement_callback, self);
#line 350 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_data_remove_commit_statement_callback (_tracker_resources_on_statements_committed_tracker_commit_callback, self);
#line 351 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_data_remove_rollback_statement_callback (_tracker_resources_on_statements_rolled_back_tracker_commit_callback, self);
#line 353 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp0_ = self->priv->signal_timeout;
#line 353 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 2658 "tracker-resources.c"
		guint _tmp1_;
#line 354 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		_tmp1_ = self->priv->signal_timeout;
#line 354 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		g_source_remove (_tmp1_);
#line 355 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		self->priv->signal_timeout = (guint) 0;
#line 2666 "tracker-resources.c"
	}
}


void tracker_resources_unreg_batches (TrackerResources* self, const gchar* old_owner) {
	const gchar* _tmp0_;
#line 364 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 364 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (old_owner != NULL);
#line 365 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_tmp0_ = old_owner;
#line 365 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_store_unreg_batches (_tmp0_);
#line 2681 "tracker-resources.c"
}


static void g_cclosure_user_marshal_VOID__STRING_VARIANT_VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_VARIANT_VARIANT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_VARIANT_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (n_param_values == 4);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		data1 = closure->data;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		data2 = param_values->data[0].v_pointer;
#line 2700 "tracker-resources.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		data1 = param_values->data[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
		data2 = closure->data;
#line 2706 "tracker-resources.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	callback = (GMarshalFunc_VOID__STRING_VARIANT_VARIANT) (marshal_data ? marshal_data : cc->callback);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_variant (param_values + 2), g_value_get_variant (param_values + 3), data2);
#line 2712 "tracker-resources.c"
}


static void tracker_resources_class_init (TrackerResourcesClass * klass) {
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	g_type_class_add_private (klass, sizeof (TrackerResourcesPrivate));
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_resources_finalize;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_signals[TRACKER_RESOURCES_WRITEBACK_SIGNAL] = g_signal_new ("writeback", TRACKER_TYPE_RESOURCES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VARIANT, G_TYPE_NONE, 1, G_TYPE_VARIANT);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_signals[TRACKER_RESOURCES_GRAPH_UPDATED_SIGNAL] = g_signal_new ("graph-updated", TRACKER_TYPE_RESOURCES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_VARIANT_VARIANT, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);
#line 2727 "tracker-resources.c"
}


static void tracker_resources_instance_init (TrackerResources * self) {
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	self->priv = TRACKER_RESOURCES_GET_PRIVATE (self);
#line 2734 "tracker-resources.c"
}


static void tracker_resources_finalize (GObject * obj) {
	TrackerResources * self;
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_RESOURCES, TrackerResources);
#line 360 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	tracker_resources_disable_signals (self);
#line 52 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (self->priv->connection);
#line 55 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (self->priv->config);
#line 22 "/home/carlos/Source/gnome/tracker-1.12/src/tracker-store/tracker-resources.vala"
	G_OBJECT_CLASS (tracker_resources_parent_class)->finalize (obj);
#line 2750 "tracker-resources.c"
}


GType tracker_resources_get_type (void) {
	static volatile gsize tracker_resources_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_resources_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerResourcesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_resources_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerResources), 0, (GInstanceInitFunc) tracker_resources_instance_init, NULL };
		GType tracker_resources_type_id;
		tracker_resources_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerResources", &g_define_type_info, 0);
		g_type_set_qdata (tracker_resources_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) tracker_resources_register_object);
		g_once_init_leave (&tracker_resources_type_id__volatile, tracker_resources_type_id);
	}
	return tracker_resources_type_id__volatile;
}


static void _dbus_tracker_resources_load (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp2_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	tracker_resources_load (self, g_dbus_method_invocation_get_sender (invocation), uri, (GAsyncReadyCallback) _dbus_tracker_resources_load_ready, invocation);
	_g_free0 (uri);
}


static void _dbus_tracker_resources_load_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_resources_load_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_sparql_query (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* query = NULL;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	query = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	tracker_resources_sparql_query (self, g_dbus_method_invocation_get_sender (invocation), query, (GAsyncReadyCallback) _dbus_tracker_resources_sparql_query_ready, invocation);
	_g_free0 (query);
}


static void _dbus_tracker_resources_sparql_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	invocation = _user_data_;
	result = tracker_resources_sparql_query_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_sparql_update (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* update = NULL;
	GVariant* _tmp4_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	update = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	tracker_resources_sparql_update (self, g_dbus_method_invocation_get_sender (invocation), update, (GAsyncReadyCallback) _dbus_tracker_resources_sparql_update_ready, invocation);
	_g_free0 (update);
}


static void _dbus_tracker_resources_sparql_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_resources_sparql_update_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_sparql_update_blank (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* update = NULL;
	GVariant* _tmp5_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	update = g_variant_dup_string (_tmp5_, NULL);
	g_variant_unref (_tmp5_);
	tracker_resources_sparql_update_blank (self, g_dbus_method_invocation_get_sender (invocation), update, (GAsyncReadyCallback) _dbus_tracker_resources_sparql_update_blank_ready, invocation);
	_g_free0 (update);
}


static void _dbus_tracker_resources_sparql_update_blank_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	invocation = _user_data_;
	result = tracker_resources_sparql_update_blank_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_sync (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	tracker_resources_sync (self, g_dbus_method_invocation_get_sender (invocation));
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_batch_sparql_update (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* update = NULL;
	GVariant* _tmp6_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	update = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	tracker_resources_batch_sparql_update (self, g_dbus_method_invocation_get_sender (invocation), update, (GAsyncReadyCallback) _dbus_tracker_resources_batch_sparql_update_ready, invocation);
	_g_free0 (update);
}


static void _dbus_tracker_resources_batch_sparql_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_resources_batch_sparql_update_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_batch_commit (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	tracker_resources_batch_commit (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void tracker_resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Load") == 0) {
		_dbus_tracker_resources_load (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlQuery") == 0) {
		_dbus_tracker_resources_sparql_query (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlUpdate") == 0) {
		_dbus_tracker_resources_sparql_update (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlUpdateBlank") == 0) {
		_dbus_tracker_resources_sparql_update_blank (object, parameters, invocation);
	} else if (strcmp (method_name, "Sync") == 0) {
		_dbus_tracker_resources_sync (object, parameters, invocation);
	} else if (strcmp (method_name, "BatchSparqlUpdate") == 0) {
		_dbus_tracker_resources_batch_sparql_update (object, parameters, invocation);
	} else if (strcmp (method_name, "BatchCommit") == 0) {
		_dbus_tracker_resources_batch_commit (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* tracker_resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean tracker_resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_tracker_resources_writeback (GObject* _sender, GVariant* subjects, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, subjects);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Tracker1.Resources", "Writeback", _arguments, NULL);
}


static void _dbus_tracker_resources_graph_updated (GObject* _sender, const gchar* classname, GVariant* deletes, GVariant* inserts, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (classname));
	g_variant_builder_add_value (&_arguments_builder, deletes);
	g_variant_builder_add_value (&_arguments_builder, inserts);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Tracker1.Resources", "GraphUpdated", _arguments, NULL);
}


guint tracker_resources_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_tracker_resources_dbus_interface_info), &_tracker_resources_dbus_interface_vtable, data, _tracker_resources_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "writeback", (GCallback) _dbus_tracker_resources_writeback, data);
	g_signal_connect (object, "graph-updated", (GCallback) _dbus_tracker_resources_graph_updated, data);
	return result;
}


static void _tracker_resources_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_tracker_resources_writeback, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_tracker_resources_graph_updated, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



