/* tracker-direct.c generated by valac 0.38.1, the Vala compiler
 * generated from tracker-direct.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "libtracker-sparql/tracker-sparql.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "libtracker-data/tracker-data-manager.h"
#include "libtracker-common/tracker-locale.h"
#include "libtracker-data/tracker-db-manager.h"
#include "libtracker-data/tracker-sparql-query.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-common/tracker-date-time.h"


#define TRACKER_DIRECT_TYPE_CONNECTION (tracker_direct_connection_get_type ())
#define TRACKER_DIRECT_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnection))
#define TRACKER_DIRECT_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnectionClass))
#define TRACKER_DIRECT_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_DIRECT_TYPE_CONNECTION))
#define TRACKER_DIRECT_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_DIRECT_TYPE_CONNECTION))
#define TRACKER_DIRECT_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnectionClass))

typedef struct _TrackerDirectConnection TrackerDirectConnection;
typedef struct _TrackerDirectConnectionClass TrackerDirectConnectionClass;
typedef struct _TrackerDirectConnectionPrivate TrackerDirectConnectionPrivate;
enum  {
	TRACKER_DIRECT_CONNECTION_DUMMY_PROPERTY,
	TRACKER_DIRECT_CONNECTION_LAST_PROPERTY
};
static GParamSpec* tracker_direct_connection_properties[TRACKER_DIRECT_CONNECTION_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
typedef struct _TrackerDirectConnectionQueryAsyncData TrackerDirectConnectionQueryAsyncData;

struct _TrackerDirectConnection {
	TrackerSparqlConnection parent_instance;
	TrackerDirectConnectionPrivate * priv;
};

struct _TrackerDirectConnectionClass {
	TrackerSparqlConnectionClass parent_class;
};

struct _TrackerDirectConnectionPrivate {
	gboolean initialized;
	GMutex mutex;
};

struct _Block1Data {
	int _ref_count_;
	TrackerDirectConnection* self;
	GError* sparql_error;
	GError* io_error;
	GError* dbus_error;
	TrackerSparqlCursor* _result_;
	GMainContext* context;
	gchar* sparql;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _TrackerDirectConnectionQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	Block1Data* _data1_;
	const gchar* _tmp0_;
	GCancellable* _tmp1_;
	GMainContext* _tmp2_;
	GMainContext* _tmp3_;
	GCancellable* _tmp4_;
	gboolean _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	gboolean _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	GError* _tmp18_;
	TrackerSparqlCursor* _tmp19_;
	TrackerSparqlCursor* _tmp20_;
	GError * _inner_error_;
};


static gpointer tracker_direct_connection_parent_class = NULL;
static gint tracker_direct_connection_use_count;
static gint tracker_direct_connection_use_count = 0;

GType tracker_direct_connection_get_type (void) G_GNUC_CONST;
#define TRACKER_DIRECT_CONNECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnectionPrivate))
TrackerDirectConnection* tracker_direct_connection_new (GError** error);
TrackerDirectConnection* tracker_direct_connection_construct (GType object_type, GError** error);
static TrackerSparqlCursor* tracker_direct_connection_query_unlocked (TrackerDirectConnection* self, const gchar* sparql, GError** error);
static TrackerSparqlCursor* tracker_direct_connection_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error);
static void tracker_direct_connection_real_query_async_data_free (gpointer _data);
static void tracker_direct_connection_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_direct_connection_real_query_async_co (TrackerDirectConnectionQueryAsyncData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda4_ (Block1Data* _data1_, GIOSchedulerJob* job);
static gboolean __lambda5_ (Block1Data* _data1_);
static gboolean ___lambda5__gsource_func (gpointer self);
static gboolean ___lambda4__gio_scheduler_job_func (GIOSchedulerJob* job, GCancellable* cancellable, gpointer self);
static void tracker_direct_connection_finalize (GObject * obj);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);


TrackerDirectConnection* tracker_direct_connection_construct (GType object_type, GError** error) {
	TrackerDirectConnection * self = NULL;
	GError * _inner_error_ = NULL;
#line 25 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) tracker_sparql_connection_construct (object_type);
#line 154 "tracker-direct.c"
	{
		gint _tmp0_;
		gint _tmp7_;
#line 27 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = tracker_direct_connection_use_count;
#line 27 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		if (_tmp0_ == 0) {
#line 162 "tracker-direct.c"
			guint select_cache_size = 0U;
			gchar* env_cache_size = NULL;
			const gchar* _tmp1_;
			gchar* _tmp2_;
			const gchar* _tmp3_;
			guint _tmp6_;
#line 30 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			tracker_locale_init ();
#line 31 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			tracker_db_manager_locale_changed (&_inner_error_);
#line 31 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 175 "tracker-direct.c"
				goto __catch0_g_error;
			}
#line 33 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			select_cache_size = (guint) 100;
#line 34 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			_tmp1_ = g_getenv ("TRACKER_SPARQL_CACHE_SIZE");
#line 34 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			_tmp2_ = g_strdup (_tmp1_);
#line 34 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			env_cache_size = _tmp2_;
#line 36 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			_tmp3_ = env_cache_size;
#line 36 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			if (_tmp3_ != NULL) {
#line 190 "tracker-direct.c"
				const gchar* _tmp4_;
				gint _tmp5_;
#line 37 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				_tmp4_ = env_cache_size;
#line 37 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				_tmp5_ = atoi (_tmp4_);
#line 37 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				select_cache_size = (guint) _tmp5_;
#line 199 "tracker-direct.c"
			}
#line 40 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			_tmp6_ = select_cache_size;
#line 40 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			tracker_data_manager_init (TRACKER_DB_MANAGER_READONLY | TRACKER_DB_MANAGER_ENABLE_MUTEXES, NULL, NULL, FALSE, FALSE, _tmp6_, (guint) 0, NULL, NULL, NULL, &_inner_error_);
#line 40 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 40 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				_g_free0 (env_cache_size);
#line 209 "tracker-direct.c"
				goto __catch0_g_error;
			}
#line 27 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			_g_free0 (env_cache_size);
#line 214 "tracker-direct.c"
		}
#line 43 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp7_ = tracker_direct_connection_use_count;
#line 43 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		tracker_direct_connection_use_count = _tmp7_ + 1;
#line 44 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		self->priv->initialized = TRUE;
#line 222 "tracker-direct.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GError* _tmp10_;
#line 26 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		e = _inner_error_;
#line 26 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 46 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp8_ = e;
#line 46 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp9_ = _tmp8_->message;
#line 46 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp10_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp9_);
#line 46 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = _tmp10_;
#line 46 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e);
#line 245 "tracker-direct.c"
		goto __finally0;
	}
	__finally0:
#line 26 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 26 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 26 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			g_propagate_error (error, _inner_error_);
#line 26 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			_g_object_unref0 (self);
#line 26 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			return NULL;
#line 259 "tracker-direct.c"
		} else {
#line 26 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 26 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			g_clear_error (&_inner_error_);
#line 26 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			return NULL;
#line 267 "tracker-direct.c"
		}
	}
#line 25 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	return self;
#line 272 "tracker-direct.c"
}


TrackerDirectConnection* tracker_direct_connection_new (GError** error) {
#line 25 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	return tracker_direct_connection_construct (TRACKER_DIRECT_TYPE_CONNECTION, error);
#line 279 "tracker-direct.c"
}


static TrackerSparqlCursor* tracker_direct_connection_query_unlocked (TrackerDirectConnection* self, const gchar* sparql, GError** error) {
	TrackerSparqlCursor* result = NULL;
	GError * _inner_error_ = NULL;
#line 64 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 290 "tracker-direct.c"
	{
		TrackerSparqlQuery* query_object = NULL;
		const gchar* _tmp0_;
		TrackerSparqlQuery* _tmp1_;
		TrackerDBCursor* cursor = NULL;
		TrackerSparqlQuery* _tmp2_;
		TrackerDBCursor* _tmp3_;
		TrackerDBCursor* _tmp4_;
#line 66 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = sparql;
#line 66 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp1_ = tracker_sparql_query_new (_tmp0_);
#line 66 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		query_object = _tmp1_;
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = query_object;
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = tracker_sparql_query_execute_cursor (_tmp2_, &_inner_error_);
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		cursor = _tmp3_;
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			_g_object_unref0 (query_object);
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 317 "tracker-direct.c"
				goto __catch1_tracker_db_interface_error;
			}
#line 67 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_->domain == TRACKER_DATE_ERROR) {
#line 322 "tracker-direct.c"
				goto __catch1_tracker_date_error;
			}
			goto __finally1;
		}
#line 68 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp4_ = cursor;
#line 68 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		tracker_sparql_cursor_set_connection ((TrackerSparqlCursor*) _tmp4_, (TrackerSparqlConnection*) self);
#line 69 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		result = (TrackerSparqlCursor*) cursor;
#line 69 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (query_object);
#line 69 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		return result;
#line 337 "tracker-direct.c"
	}
	goto __finally1;
	__catch1_tracker_db_interface_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		e = _inner_error_;
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 71 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp5_ = e;
#line 71 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp6_ = _tmp5_->message;
#line 71 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp7_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp6_);
#line 71 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = _tmp7_;
#line 71 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e);
#line 360 "tracker-direct.c"
		goto __finally1;
	}
	goto __finally1;
	__catch1_tracker_date_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GError* _tmp10_;
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		e = _inner_error_;
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 73 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp8_ = e;
#line 73 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp9_ = _tmp8_->message;
#line 73 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp10_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, _tmp9_);
#line 73 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = _tmp10_;
#line 73 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e);
#line 384 "tracker-direct.c"
		goto __finally1;
	}
	__finally1:
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		g_propagate_error (error, _inner_error_);
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 394 "tracker-direct.c"
	} else {
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		g_clear_error (&_inner_error_);
#line 65 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 402 "tracker-direct.c"
	}
}


static TrackerSparqlCursor* tracker_direct_connection_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error) {
	TrackerDirectConnection * self;
	TrackerSparqlCursor* result = NULL;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_;
	GError * _inner_error_ = NULL;
#line 77 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 77 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 80 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = cancellable;
#line 80 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	if (_tmp1_ != NULL) {
#line 421 "tracker-direct.c"
		GCancellable* _tmp2_;
		gboolean _tmp3_;
#line 80 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = cancellable;
#line 80 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 80 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = _tmp3_;
#line 430 "tracker-direct.c"
	} else {
#line 80 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = FALSE;
#line 434 "tracker-direct.c"
	}
#line 80 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	if (_tmp0_) {
#line 438 "tracker-direct.c"
		GError* _tmp4_;
#line 81 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp4_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 81 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = _tmp4_;
#line 81 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 81 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			g_propagate_error (error, _inner_error_);
#line 81 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			return NULL;
#line 450 "tracker-direct.c"
		} else {
#line 81 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 81 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			g_clear_error (&_inner_error_);
#line 81 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			return NULL;
#line 458 "tracker-direct.c"
		}
	}
#line 84 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	g_mutex_lock (&self->priv->mutex);
#line 463 "tracker-direct.c"
	{
		TrackerSparqlCursor* _tmp5_ = NULL;
		const gchar* _tmp6_;
		TrackerSparqlCursor* _tmp7_;
		TrackerSparqlCursor* _tmp8_;
#line 86 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp6_ = sparql;
#line 86 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp7_ = tracker_direct_connection_query_unlocked (self, _tmp6_, &_inner_error_);
#line 86 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp5_ = _tmp7_;
#line 86 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 477 "tracker-direct.c"
			goto __finally2;
		}
#line 86 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp8_ = _tmp5_;
#line 86 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp5_ = NULL;
#line 86 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		result = _tmp8_;
#line 86 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (_tmp5_);
#line 488 "tracker-direct.c"
		{
#line 88 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			g_mutex_unlock (&self->priv->mutex);
#line 492 "tracker-direct.c"
		}
#line 86 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		return result;
#line 496 "tracker-direct.c"
	}
	__finally2:
	{
#line 88 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		g_mutex_unlock (&self->priv->mutex);
#line 502 "tracker-direct.c"
	}
#line 85 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 85 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		g_propagate_error (error, _inner_error_);
#line 85 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 510 "tracker-direct.c"
	} else {
#line 85 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 85 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		g_clear_error (&_inner_error_);
#line 85 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 518 "tracker-direct.c"
	}
}


static void tracker_direct_connection_real_query_async_data_free (gpointer _data) {
	TrackerDirectConnectionQueryAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->result);
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->self);
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	g_slice_free (TrackerDirectConnectionQueryAsyncData, _data_);
#line 532 "tracker-direct.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	return self ? g_object_ref (self) : NULL;
#line 539 "tracker-direct.c"
}


static void tracker_direct_connection_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerDirectConnection * self;
	TrackerDirectConnectionQueryAsyncData* _data_;
	TrackerDirectConnection* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_ = g_slice_new0 (TrackerDirectConnectionQueryAsyncData);
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_direct_connection_real_query_async_data_free);
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->self = _tmp0_;
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = sparql;
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_g_free0 (_data_->sparql);
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->sparql = _tmp2_;
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_tmp3_ = cancellable;
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->cancellable = _tmp4_;
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_real_query_async_co (_data_);
#line 581 "tracker-direct.c"
}


static TrackerSparqlCursor* tracker_direct_connection_real_query_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerDirectConnectionQueryAsyncData* _data_;
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	if (NULL == _data_) {
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 594 "tracker-direct.c"
	}
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	result = _data_->result;
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->result = NULL;
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 602 "tracker-direct.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	return _data1_;
#line 611 "tracker-direct.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 620 "tracker-direct.c"
		TrackerDirectConnection* self;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		self = _data1_->self;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_main_context_unref0 (_data1_->context);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (_data1_->_result_);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data1_->dbus_error);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data1_->io_error);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data1_->sparql_error);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_free0 (_data1_->sparql);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (_data1_->cancellable);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (self);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		g_slice_free (Block1Data, _data1_);
#line 642 "tracker-direct.c"
	}
}


static gpointer _g_main_context_ref0 (gpointer self) {
#line 98 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	return self ? g_main_context_ref (self) : NULL;
#line 650 "tracker-direct.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 104 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	return self ? g_error_copy (self) : NULL;
#line 657 "tracker-direct.c"
}


static gboolean __lambda5_ (Block1Data* _data1_) {
	TrackerDirectConnection* self;
	gboolean result = FALSE;
#line 112 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	self = _data1_->self;
#line 113 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_real_query_async_co (_data1_->_async_data_);
#line 114 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	result = FALSE;
#line 114 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 672 "tracker-direct.c"
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ (self);
#line 112 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 681 "tracker-direct.c"
}


static gboolean __lambda4_ (Block1Data* _data1_, GIOSchedulerJob* job) {
	TrackerDirectConnection* self;
	gboolean result = FALSE;
	GSource* source = NULL;
	GSource* _tmp12_;
	GSource* _tmp13_;
	GSource* _tmp14_;
	GMainContext* _tmp15_;
	GError * _inner_error_ = NULL;
#line 100 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	self = _data1_->self;
#line 100 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (job != NULL, FALSE);
#line 698 "tracker-direct.c"
	{
		TrackerSparqlCursor* _tmp0_ = NULL;
		const gchar* _tmp1_;
		GCancellable* _tmp2_;
		TrackerSparqlCursor* _tmp3_;
		TrackerSparqlCursor* _tmp4_;
#line 102 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp1_ = _data1_->sparql;
#line 102 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = _data1_->cancellable;
#line 102 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = tracker_sparql_connection_query ((TrackerSparqlConnection*) self, _tmp1_, _tmp2_, &_inner_error_);
#line 102 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = _tmp3_;
#line 102 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 102 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 717 "tracker-direct.c"
				goto __catch3_g_io_error;
			}
#line 102 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 722 "tracker-direct.c"
				goto __catch3_tracker_sparql_error;
			}
#line 102 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_->domain == G_DBUS_ERROR) {
#line 727 "tracker-direct.c"
				goto __catch3_g_dbus_error;
			}
			goto __finally3;
		}
#line 102 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp4_ = _tmp0_;
#line 102 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = NULL;
#line 102 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (_data1_->_result_);
#line 102 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_data1_->_result_ = _tmp4_;
#line 101 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (_tmp0_);
#line 742 "tracker-direct.c"
	}
	goto __finally3;
	__catch3_g_io_error:
	{
		GError* e_io = NULL;
		GError* _tmp5_;
		GError* _tmp6_;
#line 101 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		e_io = _inner_error_;
#line 101 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 104 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp5_ = e_io;
#line 104 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp6_ = _g_error_copy0 (_tmp5_);
#line 104 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data1_->io_error);
#line 104 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_data1_->io_error = _tmp6_;
#line 101 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e_io);
#line 764 "tracker-direct.c"
	}
	goto __finally3;
	__catch3_tracker_sparql_error:
	{
		GError* e_spql = NULL;
		GError* _tmp7_;
		GError* _tmp8_;
#line 101 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		e_spql = _inner_error_;
#line 101 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 106 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp7_ = e_spql;
#line 106 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp8_ = _g_error_copy0 (_tmp7_);
#line 106 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data1_->sparql_error);
#line 106 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_data1_->sparql_error = _tmp8_;
#line 101 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e_spql);
#line 786 "tracker-direct.c"
	}
	goto __finally3;
	__catch3_g_dbus_error:
	{
		GError* e_dbus = NULL;
		GError* _tmp9_;
		GError* _tmp10_;
#line 101 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		e_dbus = _inner_error_;
#line 101 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 108 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp9_ = e_dbus;
#line 108 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_tmp10_ = _g_error_copy0 (_tmp9_);
#line 108 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data1_->dbus_error);
#line 108 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_data1_->dbus_error = _tmp10_;
#line 101 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e_dbus);
#line 808 "tracker-direct.c"
	}
	__finally3:
#line 101 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 813 "tracker-direct.c"
		gboolean _tmp11_ = FALSE;
#line 101 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 101 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		g_clear_error (&_inner_error_);
#line 101 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		return _tmp11_;
#line 821 "tracker-direct.c"
	}
#line 111 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_tmp12_ = g_idle_source_new ();
#line 111 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	source = _tmp12_;
#line 112 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_tmp13_ = source;
#line 112 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	g_source_set_callback (_tmp13_, ___lambda5__gsource_func, block1_data_ref (_data1_), block1_data_unref);
#line 116 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_tmp14_ = source;
#line 116 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_tmp15_ = _data1_->context;
#line 116 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	g_source_attach (_tmp14_, _tmp15_);
#line 118 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	result = FALSE;
#line 118 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_g_source_unref0 (source);
#line 118 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 843 "tracker-direct.c"
}


static gboolean ___lambda4__gio_scheduler_job_func (GIOSchedulerJob* job, GCancellable* cancellable, gpointer self) {
	gboolean result;
	result = __lambda4_ (self, job);
#line 100 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 852 "tracker-direct.c"
}


static gboolean tracker_direct_connection_real_query_async_co (TrackerDirectConnectionQueryAsyncData* _data_) {
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	switch (_data_->_state_) {
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		case 0:
#line 861 "tracker-direct.c"
		goto _state_0;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		case 1:
#line 865 "tracker-direct.c"
		goto _state_1;
		default:
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		g_assert_not_reached ();
#line 870 "tracker-direct.c"
	}
	_state_0:
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp0_ = _data_->sparql;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_g_free0 (_data_->_data1_->sparql);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_->sparql = _data_->_tmp0_;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp1_ = _data_->cancellable;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->_data1_->cancellable);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_->cancellable = _data_->_tmp1_;
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 94 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_->sparql_error = NULL;
#line 95 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_->io_error = NULL;
#line 96 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_->dbus_error = NULL;
#line 97 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_->_result_ = NULL;
#line 98 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp2_ = g_main_context_get_thread_default ();
#line 98 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp3_ = _g_main_context_ref0 (_data_->_tmp2_);
#line 98 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_->context = _data_->_tmp3_;
#line 100 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp4_ = _data_->_data1_->cancellable;
#line 100 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	g_io_scheduler_push_job (___lambda4__gio_scheduler_job_func, block1_data_ref (_data_->_data1_), block1_data_unref, G_PRIORITY_DEFAULT, _data_->_tmp4_);
#line 120 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_state_ = 1;
#line 120 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	return FALSE;
#line 915 "tracker-direct.c"
	_state_1:
	;
#line 122 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp6_ = _data_->_data1_->cancellable;
#line 122 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	if (_data_->_tmp6_ != NULL) {
#line 122 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp7_ = _data_->_data1_->cancellable;
#line 122 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp8_ = g_cancellable_is_cancelled (_data_->_tmp7_);
#line 122 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp5_ = _data_->_tmp8_;
#line 928 "tracker-direct.c"
	} else {
#line 122 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp5_ = FALSE;
#line 932 "tracker-direct.c"
	}
#line 122 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	if (_data_->_tmp5_) {
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp9_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_data_->_inner_error_ = _data_->_tmp9_;
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			block1_data_unref (_data_->_data1_);
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			_data_->_data1_ = NULL;
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			g_object_unref (_data_->_async_result);
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			return FALSE;
#line 952 "tracker-direct.c"
		} else {
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			block1_data_unref (_data_->_data1_);
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			_data_->_data1_ = NULL;
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			g_clear_error (&_data_->_inner_error_);
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			g_object_unref (_data_->_async_result);
#line 123 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			return FALSE;
#line 966 "tracker-direct.c"
		}
	} else {
#line 124 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp10_ = _data_->_data1_->sparql_error;
#line 124 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		if (_data_->_tmp10_ != NULL) {
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			_data_->_tmp11_ = _data_->_data1_->sparql_error;
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			_data_->_tmp12_ = _g_error_copy0 (_data_->_tmp11_);
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			_data_->_inner_error_ = _data_->_tmp12_;
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				block1_data_unref (_data_->_data1_);
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				_data_->_data1_ = NULL;
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				g_object_unref (_data_->_async_result);
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				return FALSE;
#line 991 "tracker-direct.c"
			} else {
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				block1_data_unref (_data_->_data1_);
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				_data_->_data1_ = NULL;
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				g_clear_error (&_data_->_inner_error_);
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				g_object_unref (_data_->_async_result);
#line 125 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				return FALSE;
#line 1005 "tracker-direct.c"
			}
		} else {
#line 126 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			_data_->_tmp13_ = _data_->_data1_->io_error;
#line 126 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
			if (_data_->_tmp13_ != NULL) {
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				_data_->_tmp14_ = _data_->_data1_->io_error;
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				_data_->_tmp15_ = _g_error_copy0 (_data_->_tmp14_);
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				_data_->_inner_error_ = _data_->_tmp15_;
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					block1_data_unref (_data_->_data1_);
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					_data_->_data1_ = NULL;
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					g_object_unref (_data_->_async_result);
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					return FALSE;
#line 1030 "tracker-direct.c"
				} else {
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					block1_data_unref (_data_->_data1_);
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					_data_->_data1_ = NULL;
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					g_clear_error (&_data_->_inner_error_);
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					g_object_unref (_data_->_async_result);
#line 127 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					return FALSE;
#line 1044 "tracker-direct.c"
				}
			} else {
#line 128 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				_data_->_tmp16_ = _data_->_data1_->dbus_error;
#line 128 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
				if (_data_->_tmp16_ != NULL) {
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					_data_->_tmp17_ = _data_->_data1_->dbus_error;
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					_data_->_tmp18_ = _g_error_copy0 (_data_->_tmp17_);
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					_data_->_inner_error_ = _data_->_tmp18_;
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
						block1_data_unref (_data_->_data1_);
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
						_data_->_data1_ = NULL;
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
						g_object_unref (_data_->_async_result);
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
						return FALSE;
#line 1069 "tracker-direct.c"
					} else {
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
						block1_data_unref (_data_->_data1_);
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
						_data_->_data1_ = NULL;
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
						g_clear_error (&_data_->_inner_error_);
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
						g_object_unref (_data_->_async_result);
#line 129 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
						return FALSE;
#line 1083 "tracker-direct.c"
					}
				} else {
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					_data_->_tmp19_ = _data_->_data1_->_result_;
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					_data_->_tmp20_ = _g_object_ref0 (_data_->_tmp19_);
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					_data_->result = _data_->_tmp20_;
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					block1_data_unref (_data_->_data1_);
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					_data_->_data1_ = NULL;
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					if (_data_->_state_ != 0) {
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
						while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1104 "tracker-direct.c"
						}
					}
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					g_object_unref (_data_->_async_result);
#line 131 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
					return FALSE;
#line 1111 "tracker-direct.c"
				}
			}
		}
	}
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	block1_data_unref (_data_->_data1_);
#line 92 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_ = NULL;
#line 1120 "tracker-direct.c"
}


static void tracker_direct_connection_class_init (TrackerDirectConnectionClass * klass) {
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	g_type_class_add_private (klass, sizeof (TrackerDirectConnectionPrivate));
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->query = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, const gchar*, GCancellable*, GError**)) tracker_direct_connection_real_query;
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->query_async = (void (*) (TrackerSparqlConnection *, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_direct_connection_real_query_async;
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->query_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_direct_connection_real_query_finish;
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_direct_connection_finalize;
#line 1137 "tracker-direct.c"
}


static void tracker_direct_connection_instance_init (TrackerDirectConnection * self) {
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	self->priv = TRACKER_DIRECT_CONNECTION_GET_PRIVATE (self);
#line 23 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	g_mutex_init (&self->priv->mutex);
#line 1146 "tracker-direct.c"
}


static void tracker_direct_connection_finalize (GObject * obj) {
	TrackerDirectConnection * self;
	gboolean _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnection);
#line 51 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = self->priv->initialized;
#line 51 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	if (!_tmp0_) {
#line 1161 "tracker-direct.c"
		goto _return;
	}
#line 57 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = tracker_direct_connection_use_count;
#line 57 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_use_count = _tmp1_ - 1;
#line 59 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_tmp2_ = tracker_direct_connection_use_count;
#line 59 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	if (_tmp2_ == 0) {
#line 60 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
		tracker_data_manager_shutdown ();
#line 1174 "tracker-direct.c"
	}
	_return:
#line 23 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	_vala_clear_GMutex (&self->priv->mutex);
#line 20 "/home/carlos/Source/gnome/tracker-1.12/src/libtracker-direct/tracker-direct.vala"
	G_OBJECT_CLASS (tracker_direct_connection_parent_class)->finalize (obj);
#line 1181 "tracker-direct.c"
}


GType tracker_direct_connection_get_type (void) {
	static volatile gsize tracker_direct_connection_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_direct_connection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerDirectConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_direct_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerDirectConnection), 0, (GInstanceInitFunc) tracker_direct_connection_instance_init, NULL };
		GType tracker_direct_connection_type_id;
		tracker_direct_connection_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerDirectConnection", &g_define_type_info, 0);
		g_once_init_leave (&tracker_direct_connection_type_id__volatile, tracker_direct_connection_type_id);
	}
	return tracker_direct_connection_type_id__volatile;
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



