/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.finder.impl;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.MatchResult;
import com.sun.xacml.Policy;
import com.sun.xacml.PolicySet;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.PolicyFinderResult;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FilePolicyModule
extends PolicyFinderModule
implements ErrorHandler {
    public static final String POLICY_SCHEMA_PROPERTY = "com.sun.xacml.PolicySchema";
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private PolicyFinder finder;
    private File schemaFile;
    private Set fileNames = new HashSet();
    private Set policies = new HashSet();
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$finder$impl$FilePolicyModule == null ? (class$com$sun$xacml$finder$impl$FilePolicyModule = FilePolicyModule.class$("com.sun.xacml.finder.impl.FilePolicyModule")) : class$com$sun$xacml$finder$impl$FilePolicyModule).getName());
    static /* synthetic */ Class class$com$sun$xacml$finder$impl$FilePolicyModule;

    public FilePolicyModule() {
        String string = System.getProperty(POLICY_SCHEMA_PROPERTY);
        this.schemaFile = string == null ? null : new File(string);
    }

    public FilePolicyModule(File file) {
        this.schemaFile = file;
    }

    public FilePolicyModule(List list) {
        this();
        if (list != null) {
            this.fileNames.addAll(list);
        }
    }

    public boolean isRequestSupported() {
        return true;
    }

    public void init(PolicyFinder policyFinder) {
        this.finder = policyFinder;
        Iterator iterator = this.fileNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AbstractPolicy abstractPolicy = FilePolicyModule.loadPolicy(string, policyFinder, this.schemaFile, this);
            if (abstractPolicy == null) continue;
            this.policies.add(abstractPolicy);
        }
    }

    public boolean addPolicy(String string) {
        return this.fileNames.add(string);
    }

    public static AbstractPolicy loadPolicy(String string, PolicyFinder policyFinder) {
        return FilePolicyModule.loadPolicy(string, policyFinder, null, null);
    }

    public static AbstractPolicy loadPolicy(String string, PolicyFinder policyFinder, File file, ErrorHandler errorHandler) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            DocumentBuilder documentBuilder = null;
            documentBuilderFactory.setNamespaceAware(true);
            if (file == null) {
                documentBuilderFactory.setValidating(false);
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            } else {
                documentBuilderFactory.setValidating(true);
                documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, file);
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
                documentBuilder.setErrorHandler(errorHandler);
            }
            Document document = documentBuilder.parse(new FileInputStream(string));
            Element element = document.getDocumentElement();
            String string2 = element.getTagName();
            if (string2.equals("Policy")) {
                return Policy.getInstance(element);
            }
            if (string2.equals("PolicySet")) {
                return PolicySet.getInstance(element, policyFinder);
            }
            throw new Exception("Unknown root document type: " + string2);
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Error reading policy from file " + string, exception);
            }
            return null;
        }
    }

    public PolicyFinderResult findPolicy(EvaluationCtx evaluationCtx) {
        AbstractPolicy abstractPolicy = null;
        Iterator iterator = this.policies.iterator();
        while (iterator.hasNext()) {
            AbstractPolicy abstractPolicy2 = (AbstractPolicy)iterator.next();
            MatchResult matchResult = abstractPolicy2.match(evaluationCtx);
            int n = matchResult.getResult();
            if (n == 2) {
                return new PolicyFinderResult(matchResult.getStatus());
            }
            if (n != 0) continue;
            if (abstractPolicy != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(arrayList, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            abstractPolicy = abstractPolicy2;
        }
        if (abstractPolicy != null) {
            return new PolicyFinderResult(abstractPolicy);
        }
        return new PolicyFinderResult();
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Warning on line " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Error on line " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage() + " ... " + "Policy will not be available");
        }
        throw new SAXException("error parsing policy");
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Fatal error on line " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage() + " ... " + "Policy will not be available");
        }
        throw new SAXException("fatal error parsing policy");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

