/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.finder.impl;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.DateAttribute;
import com.sun.xacml.attr.DateTimeAttribute;
import com.sun.xacml.attr.TimeAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.AttributeFinderModule;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class CurrentEnvModule
extends AttributeFinderModule {
    public static final String ENVIRONMENT_CURRENT_TIME = "urn:oasis:names:tc:xacml:1.0:environment:current-time";
    public static final String ENVIRONMENT_CURRENT_DATE = "urn:oasis:names:tc:xacml:1.0:environment:current-date";
    public static final String ENVIRONMENT_CURRENT_DATETIME = "urn:oasis:names:tc:xacml:1.0:environment:current-dateTime";

    public boolean isDesignatorSupported() {
        return true;
    }

    public Set getSupportedDesignatorTypes() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(new Integer(3));
        return hashSet;
    }

    public EvaluationResult findAttribute(URI uRI, URI uRI2, URI uRI3, URI uRI4, EvaluationCtx evaluationCtx, int n) {
        if (n != 3) {
            return new EvaluationResult(BagAttribute.createEmptyBag(uRI));
        }
        String string = uRI2.toString();
        if (string.equals(ENVIRONMENT_CURRENT_TIME)) {
            return this.handleTime(uRI, uRI3, evaluationCtx);
        }
        if (string.equals(ENVIRONMENT_CURRENT_DATE)) {
            return this.handleDate(uRI, uRI3, evaluationCtx);
        }
        if (string.equals(ENVIRONMENT_CURRENT_DATETIME)) {
            return this.handleDateTime(uRI, uRI3, evaluationCtx);
        }
        return new EvaluationResult(BagAttribute.createEmptyBag(uRI));
    }

    private EvaluationResult handleTime(URI uRI, URI uRI2, EvaluationCtx evaluationCtx) {
        if (!uRI.toString().equals("http://www.w3.org/2001/XMLSchema#time")) {
            return new EvaluationResult(BagAttribute.createEmptyBag(uRI));
        }
        TimeAttribute timeAttribute = evaluationCtx.getCurrentTime();
        if (timeAttribute == null) {
            timeAttribute = new TimeAttribute();
            evaluationCtx.setCurrentTime(timeAttribute);
        }
        return this.makeBag(timeAttribute);
    }

    private EvaluationResult handleDate(URI uRI, URI uRI2, EvaluationCtx evaluationCtx) {
        if (!uRI.toString().equals("http://www.w3.org/2001/XMLSchema#date")) {
            return new EvaluationResult(BagAttribute.createEmptyBag(uRI));
        }
        DateAttribute dateAttribute = evaluationCtx.getCurrentDate();
        if (dateAttribute == null) {
            dateAttribute = new DateAttribute();
            evaluationCtx.setCurrentDate(dateAttribute);
        }
        return this.makeBag(dateAttribute);
    }

    private EvaluationResult handleDateTime(URI uRI, URI uRI2, EvaluationCtx evaluationCtx) {
        if (!uRI.toString().equals("http://www.w3.org/2001/XMLSchema#dateTime")) {
            return new EvaluationResult(BagAttribute.createEmptyBag(uRI));
        }
        DateTimeAttribute dateTimeAttribute = evaluationCtx.getCurrentDateTime();
        if (dateTimeAttribute == null) {
            dateTimeAttribute = new DateTimeAttribute();
            evaluationCtx.setCurrentDateTime(dateTimeAttribute);
        }
        return this.makeBag(dateTimeAttribute);
    }

    private EvaluationResult makeProcessingError(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
        return new EvaluationResult(new Status(arrayList, string));
    }

    private EvaluationResult makeBag(AttributeValue attributeValue) {
        HashSet<AttributeValue> hashSet = new HashSet<AttributeValue>();
        hashSet.add(attributeValue);
        BagAttribute bagAttribute = new BagAttribute(attributeValue.getType(), hashSet);
        return new EvaluationResult(bagAttribute);
    }
}

