/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.finder;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.PolicyFinderResult;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PolicyFinder {
    private Set allModules;
    private Set requestModules;
    private Set referenceModules;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$finder$PolicyFinder == null ? (class$com$sun$xacml$finder$PolicyFinder = PolicyFinder.class$("com.sun.xacml.finder.PolicyFinder")) : class$com$sun$xacml$finder$PolicyFinder).getName());
    static /* synthetic */ Class class$com$sun$xacml$finder$PolicyFinder;

    public Set getModules() {
        return new HashSet(this.allModules);
    }

    public void setModules(Set set) {
        Iterator iterator = set.iterator();
        this.allModules = new HashSet(set);
        this.requestModules = new HashSet();
        this.referenceModules = new HashSet();
        while (iterator.hasNext()) {
            PolicyFinderModule policyFinderModule = (PolicyFinderModule)iterator.next();
            if (policyFinderModule.isRequestSupported()) {
                this.requestModules.add(policyFinderModule);
            }
            if (!policyFinderModule.isIdReferenceSupported()) continue;
            this.referenceModules.add(policyFinderModule);
        }
    }

    public void init() {
        logger.finer("Initializing PolicyFinder");
        Iterator iterator = this.allModules.iterator();
        while (iterator.hasNext()) {
            PolicyFinderModule policyFinderModule = (PolicyFinderModule)iterator.next();
            policyFinderModule.init(this);
        }
    }

    public PolicyFinderResult findPolicy(EvaluationCtx evaluationCtx) {
        PolicyFinderResult policyFinderResult = null;
        Iterator iterator = this.requestModules.iterator();
        while (iterator.hasNext()) {
            PolicyFinderModule policyFinderModule = (PolicyFinderModule)iterator.next();
            PolicyFinderResult policyFinderResult2 = policyFinderModule.findPolicy(evaluationCtx);
            if (policyFinderResult2.indeterminate()) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("An error occured while trying to find a single applicable policy for a request: " + policyFinderResult2.getStatus().getMessage());
                }
                return policyFinderResult2;
            }
            if (policyFinderResult2.notApplicable()) continue;
            if (policyFinderResult != null) {
                logger.info("More than one top-level applicable policy for the request");
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(arrayList, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            policyFinderResult = policyFinderResult2;
        }
        if (policyFinderResult != null) {
            return policyFinderResult;
        }
        logger.info("No applicable policies were found for the request");
        return new PolicyFinderResult();
    }

    public PolicyFinderResult findPolicy(URI uRI, int n) throws IllegalArgumentException {
        PolicyFinderResult policyFinderResult = null;
        Iterator iterator = this.referenceModules.iterator();
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Unknown reference type");
        }
        while (iterator.hasNext()) {
            PolicyFinderModule policyFinderModule = (PolicyFinderModule)iterator.next();
            PolicyFinderResult policyFinderResult2 = policyFinderModule.findPolicy(uRI, n);
            if (policyFinderResult2.indeterminate()) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("An error occured while trying to find the referenced policy " + uRI.toString() + ": " + policyFinderResult2.getStatus().getMessage());
                }
                return policyFinderResult2;
            }
            if (policyFinderResult2.notApplicable()) continue;
            if (policyFinderResult != null) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("More than one policy applies for the reference: " + uRI.toString());
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(arrayList, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            policyFinderResult = policyFinderResult2;
        }
        if (policyFinderResult != null) {
            return policyFinderResult;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("No policies were resolved for the reference: " + uRI.toString());
        }
        return new PolicyFinderResult();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

