/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.ctx;

import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.ctx.StatusDetail;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Status {
    public static final String STATUS_OK = "urn:oasis:names:tc:xacml:1.0:status:ok";
    public static final String STATUS_MISSING_ATTRIBUTE = "urn:oasis:names:tc:xacml:1.0:status:missing-attribute";
    public static final String STATUS_SYNTAX_ERROR = "urn:oasis:names:tc:xacml:1.0:status:syntax-error";
    public static final String STATUS_PROCESSING_ERROR = "urn:oasis:names:tc:xacml:1.0:status:processing-error";
    private List code;
    private String message;
    private StatusDetail detail;
    private static Status okStatus;

    public Status(List list) {
        this(list, null, null);
    }

    public Status(List list, String string) {
        this(list, string, null);
    }

    public Status(List list, String string, StatusDetail statusDetail) throws IllegalArgumentException {
        String string2;
        if (statusDetail != null && ((string2 = (String)list.iterator().next()).equals(STATUS_OK) || string2.equals(STATUS_SYNTAX_ERROR) || string2.equals(STATUS_PROCESSING_ERROR))) {
            throw new IllegalArgumentException("status detail cannot be included with " + string2);
        }
        this.code = Collections.unmodifiableList(new ArrayList(list));
        this.message = string;
        this.detail = statusDetail;
    }

    public List getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public StatusDetail getDetail() {
        return this.detail;
    }

    public static Status getOkInstance() {
        return okStatus;
    }

    public static Status getInstance(Node node) throws ParsingException {
        List list = null;
        String string = null;
        StatusDetail statusDetail = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            if (string2.equals("StatusCode")) {
                list = Status.parseStatusCode(node2);
                continue;
            }
            if (string2.equals("StatusMessage")) {
                string = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (!string2.equals("StatusDetail")) continue;
            statusDetail = StatusDetail.getInstance(node2);
        }
        return new Status(list, string, statusDetail);
    }

    private static List parseStatusCode(Node node) {
        String string = node.getAttributes().getNamedItem("Value").getNodeValue();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        NodeList nodeList = ((Element)node).getElementsByTagName("StatusCode");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            arrayList.add(node2.getAttributes().getNamedItem("Value").getNodeValue());
        }
        return arrayList;
    }

    public void encode(OutputStream outputStream) {
        this.encode(outputStream, new Indenter(0));
    }

    public void encode(OutputStream outputStream, Indenter indenter) {
        PrintStream printStream = new PrintStream(outputStream);
        String string = indenter.makeString();
        printStream.println(string + "<Status>");
        indenter.in();
        this.encodeStatusCode(printStream, indenter, this.code.iterator());
        if (this.message != null) {
            printStream.println(indenter.makeString() + "<StatusMessage>" + this.message + "</StatusMessage>");
        }
        if (this.detail != null) {
            printStream.println(this.detail.getEncoded());
        }
        indenter.out();
        printStream.println(string + "</Status>");
    }

    private void encodeStatusCode(PrintStream printStream, Indenter indenter, Iterator iterator) {
        String string = indenter.makeString();
        String string2 = (String)iterator.next();
        if (iterator.hasNext()) {
            indenter.in();
            printStream.println(string + "<StatusCode Value=\"" + string2 + "\">");
            this.encodeStatusCode(printStream, indenter, iterator);
            printStream.println(string + "</StatusCode>");
            indenter.out();
        } else {
            printStream.println(string + "<StatusCode Value=\"" + string2 + "\"/>");
        }
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(STATUS_OK);
        okStatus = new Status(arrayList);
    }
}

