/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.ctx;

import com.sun.xacml.Indenter;
import com.sun.xacml.Obligation;
import com.sun.xacml.ParsingException;
import com.sun.xacml.ctx.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Result {
    public static final int DECISION_PERMIT = 0;
    public static final int DECISION_DENY = 1;
    public static final int DECISION_INDETERMINATE = 2;
    public static final int DECISION_NOT_APPLICABLE = 3;
    public static final String[] DECISIONS = new String[]{"Permit", "Deny", "Indeterminate", "NotApplicable"};
    private int decision = -1;
    private Status status = null;
    private String resource = null;
    private Set obligations;

    public Result(int n) throws IllegalArgumentException {
        this(n, null, null, null);
    }

    public Result(int n, Set set) throws IllegalArgumentException {
        this(n, null, null, set);
    }

    public Result(int n, Status status) throws IllegalArgumentException {
        this(n, status, null, null);
    }

    public Result(int n, Status status, Set set) throws IllegalArgumentException {
        this(n, status, null, set);
    }

    public Result(int n, String string) throws IllegalArgumentException {
        this(n, null, string, null);
    }

    public Result(int n, String string, Set set) throws IllegalArgumentException {
        this(n, null, string, set);
    }

    public Result(int n, Status status, String string) throws IllegalArgumentException {
        this(n, status, string, null);
    }

    public Result(int n, Status status, String string, Set set) throws IllegalArgumentException {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("invalid decision value");
        }
        this.decision = n;
        this.resource = string;
        this.status = status == null ? Status.getOkInstance() : status;
        this.obligations = set == null ? new HashSet() : set;
    }

    public static Result getInstance(Node node) throws ParsingException {
        int n = -1;
        Status status = null;
        String string = null;
        Set set = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("ResourceId");
        if (node2 != null) {
            string = node2.getNodeValue();
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            String string2 = node3.getNodeName();
            if (string2.equals("Decision")) {
                String string3 = node3.getFirstChild().getNodeValue();
                for (int j = 0; j < DECISIONS.length; ++j) {
                    if (!DECISIONS[j].equals(string3)) continue;
                    n = j;
                    break;
                }
                if (n != -1) continue;
                throw new ParsingException("Unknown Decision: " + string3);
            }
            if (string2.equals("Status")) {
                status = Status.getInstance(node3);
                continue;
            }
            if (!string2.equals("Obligations")) continue;
            set = Result.parseObligations(node3);
        }
        return new Result(n, status, string, set);
    }

    private static Set parseObligations(Node node) throws ParsingException {
        HashSet<Obligation> hashSet = new HashSet<Obligation>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("Obligation")) continue;
            hashSet.add(Obligation.getInstance(node2));
        }
        if (hashSet.size() == 0) {
            throw new ParsingException("ObligationsType must not be empty");
        }
        return hashSet;
    }

    public int getDecision() {
        return this.decision;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getResource() {
        return this.resource;
    }

    public boolean setResource(String string) {
        if (this.resource != null) {
            return false;
        }
        this.resource = string;
        return true;
    }

    public Set getObligations() {
        return this.obligations;
    }

    public void addObligation(Obligation obligation) {
        if (obligation != null) {
            this.obligations.add(obligation);
        }
    }

    public void encode(OutputStream outputStream) {
        this.encode(outputStream, new Indenter(0));
    }

    public void encode(OutputStream outputStream, Indenter indenter) {
        PrintStream printStream = new PrintStream(outputStream);
        String string = indenter.makeString();
        indenter.in();
        String string2 = indenter.makeString();
        if (this.resource == null) {
            printStream.println(string + "<Result>");
        } else {
            printStream.println(string + "<Result ResourceID=\"" + this.resource + "\">");
        }
        printStream.println(string2 + "<Decision>" + DECISIONS[this.decision] + "</Decision>");
        if (this.status != null) {
            this.status.encode(outputStream, indenter);
        }
        if (this.obligations.size() != 0) {
            printStream.println(string2 + "<Obligations>");
            Iterator iterator = this.obligations.iterator();
            indenter.in();
            while (iterator.hasNext()) {
                Obligation obligation = (Obligation)iterator.next();
                obligation.encode(outputStream, indenter);
            }
            indenter.out();
            printStream.println(string2 + "</Obligations>");
        }
        indenter.out();
        printStream.println(string + "</Result>");
    }
}

