/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.ctx;

import com.sun.xacml.ParsingException;
import java.io.File;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class InputParser
implements ErrorHandler {
    private File schemaFile;
    private static InputParser ipReference = null;
    private static final String CONTEXT_SCHEMA_PROPERTY = "com.sun.xacml.ContextSchema";
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$ctx$InputParser == null ? (class$com$sun$xacml$ctx$InputParser = InputParser.class$("com.sun.xacml.ctx.InputParser")) : class$com$sun$xacml$ctx$InputParser).getName());
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    static /* synthetic */ Class class$com$sun$xacml$ctx$InputParser;

    private InputParser(File file) {
        this.schemaFile = file;
    }

    static Node parseInput(InputStream inputStream, String string) throws ParsingException {
        NodeList nodeList = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            DocumentBuilder documentBuilder = null;
            documentBuilderFactory.setNamespaceAware(true);
            if (ipReference == null) {
                documentBuilderFactory.setValidating(false);
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            } else {
                documentBuilderFactory.setValidating(true);
                documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, InputParser.ipReference.schemaFile);
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
                documentBuilder.setErrorHandler(ipReference);
            }
            Document document = documentBuilder.parse(inputStream);
            nodeList = document.getElementsByTagName(string);
        }
        catch (Exception exception) {
            throw new ParsingException("Error tring to parse " + string + "Type", exception);
        }
        if (nodeList.getLength() != 1) {
            throw new ParsingException("Only one " + string + "Type allowed " + "at the root of a Context doc");
        }
        return nodeList.item(0);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Warning on line " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Error on line " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
        }
        throw new SAXException("invalid context document");
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("FatalError on line " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
        }
        throw new SAXException("invalid context document");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = System.getProperty(CONTEXT_SCHEMA_PROPERTY);
        if (string != null) {
            ipReference = new InputParser(new File(string));
        }
    }
}

