/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.ctx;

import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DateTimeAttribute;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Attribute {
    private URI id;
    private URI type;
    private String issuer = null;
    private DateTimeAttribute issueInstant = null;
    private AttributeValue value;

    public Attribute(URI uRI, String string, DateTimeAttribute dateTimeAttribute, AttributeValue attributeValue) {
        this(uRI, attributeValue.getType(), string, dateTimeAttribute, attributeValue);
    }

    public Attribute(URI uRI, URI uRI2, String string, DateTimeAttribute dateTimeAttribute, AttributeValue attributeValue) {
        this.id = uRI;
        this.type = uRI2;
        this.issuer = string;
        this.issueInstant = dateTimeAttribute;
        this.value = attributeValue;
    }

    public static Attribute getInstance(Node node) throws ParsingException {
        Object object;
        URI uRI = null;
        URI uRI2 = null;
        String string = null;
        DateTimeAttribute dateTimeAttribute = null;
        AttributeValue attributeValue = null;
        AttributeFactory attributeFactory = AttributeFactory.getInstance();
        if (!node.getNodeName().equals("Attribute")) {
            throw new ParsingException("Attribute object cannot be created with root node of type: " + node.getNodeName());
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            uRI = new URI(namedNodeMap.getNamedItem("AttributeId").getNodeValue());
        }
        catch (Exception exception) {
            throw new ParsingException("Error parsing required attribute AttributeId in AttributeType", exception);
        }
        try {
            uRI2 = new URI(namedNodeMap.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception exception) {
            throw new ParsingException("Error parsing required attribute DataType in AttributeType", exception);
        }
        try {
            Node node2;
            object = namedNodeMap.getNamedItem("Issuer");
            if (object != null) {
                string = object.getNodeValue();
            }
            if ((node2 = namedNodeMap.getNamedItem("IssueInstant")) != null) {
                dateTimeAttribute = DateTimeAttribute.getInstance(node2.getNodeValue());
            }
        }
        catch (Exception exception) {
            throw new ParsingException("Error parsing optional AttributeType attribute", exception);
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node3 = object.item(i);
            if (!node3.getNodeName().equals("AttributeValue")) continue;
            if (attributeValue != null) {
                throw new ParsingException("Too many values in Attribute");
            }
            try {
                attributeValue = attributeFactory.createValue(node3, uRI2);
                continue;
            }
            catch (UnknownIdentifierException unknownIdentifierException) {
                throw new ParsingException("Unknown AttributeId", unknownIdentifierException);
            }
        }
        if (attributeValue == null) {
            throw new ParsingException("Attribute must contain a value");
        }
        return new Attribute(uRI, uRI2, string, dateTimeAttribute, attributeValue);
    }

    public URI getId() {
        return this.id;
    }

    public URI getType() {
        return this.type;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public DateTimeAttribute getIssueInstant() {
        return this.issueInstant;
    }

    public AttributeValue getValue() {
        return this.value;
    }

    public void encode(OutputStream outputStream) {
        this.encode(outputStream, new Indenter(0));
    }

    public void encode(OutputStream outputStream, Indenter indenter) {
        String string = indenter.makeString();
        PrintStream printStream = new PrintStream(outputStream);
        printStream.println(string + this.encode());
    }

    public String encode() {
        String string = "<Attribute AttributeId=\"" + this.id.toString() + "\" " + "DataType=\"" + this.type.toString() + "\"";
        if (this.issuer != null) {
            string = string + " Issuer=\"" + this.issuer + "\"";
        }
        if (this.issueInstant != null) {
            string = string + " IssueInstant=\"" + this.issueInstant.encode() + "\"";
        }
        string = string + ">" + this.value.encodeWithTags(false) + "</Attribute>";
        return string;
    }
}

