/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.cond.BaseFunctionFactory;
import com.sun.xacml.cond.BasicFunctionFactoryProxy;
import com.sun.xacml.cond.Function;
import com.sun.xacml.cond.FunctionFactoryProxy;
import com.sun.xacml.cond.FunctionProxy;
import com.sun.xacml.cond.MapFunctionProxy;
import com.sun.xacml.cond.cluster.AbsFunctionCluster;
import com.sun.xacml.cond.cluster.AddFunctionCluster;
import com.sun.xacml.cond.cluster.ComparisonFunctionCluster;
import com.sun.xacml.cond.cluster.ConditionBagFunctionCluster;
import com.sun.xacml.cond.cluster.ConditionSetFunctionCluster;
import com.sun.xacml.cond.cluster.DateMathFunctionCluster;
import com.sun.xacml.cond.cluster.DivideFunctionCluster;
import com.sun.xacml.cond.cluster.EqualFunctionCluster;
import com.sun.xacml.cond.cluster.FloorFunctionCluster;
import com.sun.xacml.cond.cluster.GeneralBagFunctionCluster;
import com.sun.xacml.cond.cluster.GeneralSetFunctionCluster;
import com.sun.xacml.cond.cluster.HigherOrderFunctionCluster;
import com.sun.xacml.cond.cluster.LogicalFunctionCluster;
import com.sun.xacml.cond.cluster.MatchFunctionCluster;
import com.sun.xacml.cond.cluster.ModFunctionCluster;
import com.sun.xacml.cond.cluster.MultiplyFunctionCluster;
import com.sun.xacml.cond.cluster.NOfFunctionCluster;
import com.sun.xacml.cond.cluster.NotFunctionCluster;
import com.sun.xacml.cond.cluster.NumericConvertFunctionCluster;
import com.sun.xacml.cond.cluster.RoundFunctionCluster;
import com.sun.xacml.cond.cluster.StringNormalizeFunctionCluster;
import com.sun.xacml.cond.cluster.SubtractFunctionCluster;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class StandardFunctionFactory
extends BaseFunctionFactory {
    private static StandardFunctionFactory targetFactory = null;
    private static StandardFunctionFactory conditionFactory = null;
    private static StandardFunctionFactory generalFactory = null;
    private static Set targetFunctions = null;
    private static Set conditionFunctions = null;
    private static Set generalFunctions = null;
    private static Map targetAbstractFunctions = null;
    private static Map conditionAbstractFunctions = null;
    private static Map generalAbstractFunctions = null;
    private Set supportedFunctions = null;
    private Map supportedAbstractFunctions = null;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$cond$StandardFunctionFactory == null ? (class$com$sun$xacml$cond$StandardFunctionFactory = StandardFunctionFactory.class$("com.sun.xacml.cond.StandardFunctionFactory")) : class$com$sun$xacml$cond$StandardFunctionFactory).getName());
    static /* synthetic */ Class class$com$sun$xacml$cond$StandardFunctionFactory;

    private StandardFunctionFactory(Set set, Map map) {
        super(set, map);
        this.supportedFunctions = set;
        this.supportedAbstractFunctions = map;
    }

    private static void initTargetFunctions() {
        logger.config("Initializing standard Target functions");
        targetFunctions = new HashSet();
        targetFunctions.addAll(new EqualFunctionCluster().getSupportedFunctions());
        targetFunctions.addAll(new LogicalFunctionCluster().getSupportedFunctions());
        targetFunctions.addAll(new NOfFunctionCluster().getSupportedFunctions());
        targetFunctions.addAll(new NotFunctionCluster().getSupportedFunctions());
        targetFunctions.addAll(new ComparisonFunctionCluster().getSupportedFunctions());
        targetFunctions.addAll(new MatchFunctionCluster().getSupportedFunctions());
        targetAbstractFunctions = new HashMap();
    }

    private static void initConditionFunctions() {
        logger.config("Initializing standard Condition functions");
        if (targetFunctions == null) {
            StandardFunctionFactory.initTargetFunctions();
        }
        conditionFunctions = new HashSet(targetFunctions);
        conditionFunctions.addAll(new ConditionBagFunctionCluster().getSupportedFunctions());
        conditionFunctions.addAll(new ConditionSetFunctionCluster().getSupportedFunctions());
        conditionFunctions.addAll(new HigherOrderFunctionCluster().getSupportedFunctions());
        conditionAbstractFunctions = new HashMap(targetAbstractFunctions);
    }

    private static void initGeneralFunctions() {
        logger.config("Initializing standard General functions");
        if (conditionFunctions == null) {
            StandardFunctionFactory.initConditionFunctions();
        }
        generalFunctions = new HashSet(conditionFunctions);
        generalFunctions.addAll(new AddFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new SubtractFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new MultiplyFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new DivideFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new ModFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new AbsFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new RoundFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new FloorFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new DateMathFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new GeneralBagFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new NumericConvertFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new StringNormalizeFunctionCluster().getSupportedFunctions());
        generalFunctions.addAll(new GeneralSetFunctionCluster().getSupportedFunctions());
        generalAbstractFunctions = new HashMap(conditionAbstractFunctions);
        try {
            generalAbstractFunctions.put(new URI("urn:oasis:names:tc:xacml:1.0:function:map"), new MapFunctionProxy());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("invalid function name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StandardFunctionFactory getTargetFactory() {
        if (targetFactory == null) {
            Class clazz = class$com$sun$xacml$cond$StandardFunctionFactory == null ? (class$com$sun$xacml$cond$StandardFunctionFactory = StandardFunctionFactory.class$("com.sun.xacml.cond.StandardFunctionFactory")) : class$com$sun$xacml$cond$StandardFunctionFactory;
            synchronized (clazz) {
                if (targetFunctions == null) {
                    StandardFunctionFactory.initTargetFunctions();
                }
                if (targetFactory == null) {
                    targetFactory = new StandardFunctionFactory(targetFunctions, targetAbstractFunctions);
                }
            }
        }
        return targetFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StandardFunctionFactory getConditionFactory() {
        if (conditionFactory == null) {
            Class clazz = class$com$sun$xacml$cond$StandardFunctionFactory == null ? (class$com$sun$xacml$cond$StandardFunctionFactory = StandardFunctionFactory.class$("com.sun.xacml.cond.StandardFunctionFactory")) : class$com$sun$xacml$cond$StandardFunctionFactory;
            synchronized (clazz) {
                if (conditionFunctions == null) {
                    StandardFunctionFactory.initConditionFunctions();
                }
                if (conditionFactory == null) {
                    conditionFactory = new StandardFunctionFactory(conditionFunctions, conditionAbstractFunctions);
                }
            }
        }
        return conditionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StandardFunctionFactory getGeneralFactory() {
        if (generalFactory == null) {
            Class clazz = class$com$sun$xacml$cond$StandardFunctionFactory == null ? (class$com$sun$xacml$cond$StandardFunctionFactory = StandardFunctionFactory.class$("com.sun.xacml.cond.StandardFunctionFactory")) : class$com$sun$xacml$cond$StandardFunctionFactory;
            synchronized (clazz) {
                if (generalFunctions == null) {
                    StandardFunctionFactory.initGeneralFunctions();
                    generalFactory = new StandardFunctionFactory(generalFunctions, generalAbstractFunctions);
                }
            }
        }
        return generalFactory;
    }

    public Set getStandardFunctions() {
        return Collections.unmodifiableSet(this.supportedFunctions);
    }

    public Map getStandardAbstractFunctions() {
        return Collections.unmodifiableMap(this.supportedAbstractFunctions);
    }

    public static FunctionFactoryProxy getNewFactoryProxy() {
        StandardFunctionFactory standardFunctionFactory = StandardFunctionFactory.getGeneralFactory();
        BaseFunctionFactory baseFunctionFactory = new BaseFunctionFactory(standardFunctionFactory.getStandardFunctions(), standardFunctionFactory.getStandardAbstractFunctions());
        StandardFunctionFactory standardFunctionFactory2 = StandardFunctionFactory.getConditionFactory();
        BaseFunctionFactory baseFunctionFactory2 = new BaseFunctionFactory(baseFunctionFactory, standardFunctionFactory2.getStandardFunctions(), standardFunctionFactory2.getStandardAbstractFunctions());
        StandardFunctionFactory standardFunctionFactory3 = StandardFunctionFactory.getTargetFactory();
        BaseFunctionFactory baseFunctionFactory3 = new BaseFunctionFactory(baseFunctionFactory2, standardFunctionFactory3.getStandardFunctions(), standardFunctionFactory3.getStandardAbstractFunctions());
        return new BasicFunctionFactoryProxy(baseFunctionFactory3, baseFunctionFactory2, baseFunctionFactory);
    }

    public void addFunction(Function function) throws IllegalArgumentException {
        throw new UnsupportedOperationException("a standard factory cannot support new functions");
    }

    public void addAbstractFunction(FunctionProxy functionProxy, URI uRI) throws IllegalArgumentException {
        throw new UnsupportedOperationException("a standard factory cannot support new functions");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

