/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.RFC822NameAttribute;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.attr.X500NameAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;

public class MatchFunction
extends FunctionBase {
    public static final String NAME_REGEXP_STRING_MATCH = "urn:oasis:names:tc:xacml:1.0:function:regexp-string-match";
    public static final String NAME_X500NAME_MATCH = "urn:oasis:names:tc:xacml:1.0:function:x500Name-match";
    public static final String NAME_RFC822NAME_MATCH = "urn:oasis:names:tc:xacml:1.0:function:rfc822Name-match";
    private static final int ID_REGEXP_STRING_MATCH = 0;
    private static final int ID_X500NAME_MATCH = 1;
    private static final int ID_RFC822NAME_MATCH = 2;
    private static final String[] regexpParams = new String[]{"http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#string"};
    private static final String[] x500Params = new String[]{"urn:oasis:names:tc:xacml:1.0:data-type:x500Name", "urn:oasis:names:tc:xacml:1.0:data-type:x500Name"};
    private static final String[] rfc822Params = new String[]{"http://www.w3.org/2001/XMLSchema#string", "urn:oasis:names:tc:xacml:1.0:data-type:rfc822Name"};
    private static final boolean[] bagParams = new boolean[]{false, false};

    public MatchFunction(String string) {
        super(string, MatchFunction.getId(string), MatchFunction.getArgumentTypes(string), bagParams, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    private static int getId(String string) {
        if (string.equals(NAME_REGEXP_STRING_MATCH)) {
            return 0;
        }
        if (string.equals(NAME_X500NAME_MATCH)) {
            return 1;
        }
        if (string.equals(NAME_RFC822NAME_MATCH)) {
            return 2;
        }
        throw new IllegalArgumentException("unknown match function: " + string);
    }

    private static String[] getArgumentTypes(String string) {
        if (string.equals(NAME_REGEXP_STRING_MATCH)) {
            return regexpParams;
        }
        if (string.equals(NAME_X500NAME_MATCH)) {
            return x500Params;
        }
        return rfc822Params;
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(NAME_REGEXP_STRING_MATCH);
        hashSet.add(NAME_X500NAME_MATCH);
        hashSet.add(NAME_RFC822NAME_MATCH);
        return hashSet;
    }

    public EvaluationResult evaluate(List list, EvaluationCtx evaluationCtx) {
        AttributeValue[] attributeValueArray = new AttributeValue[list.size()];
        EvaluationResult evaluationResult = this.evalArgs(list, evaluationCtx, attributeValueArray);
        if (evaluationResult != null) {
            return evaluationResult;
        }
        boolean bl = false;
        switch (this.getFunctionId()) {
            case 0: {
                String string = ((StringAttribute)attributeValueArray[0]).getValue();
                String string2 = ((StringAttribute)attributeValueArray[1]).getValue();
                StringBuffer stringBuffer = new StringBuffer(string);
                if (string.charAt(0) != '^') {
                    stringBuffer = stringBuffer.insert(0, ".*");
                }
                if (string.charAt(string.length() - 1) != '$') {
                    stringBuffer = stringBuffer.insert(stringBuffer.length(), ".*");
                }
                int n = -1;
                n = stringBuffer.indexOf("\\p{Is", 0);
                while (n != -1) {
                    stringBuffer = stringBuffer.replace(n, n + 5, "\\p{In");
                    n = stringBuffer.indexOf("\\p{Is", n);
                }
                n = -1;
                n = stringBuffer.indexOf("\\P{Is", 0);
                while (n != -1) {
                    stringBuffer = stringBuffer.replace(n, n + 5, "\\P{In");
                    n = stringBuffer.indexOf("\\P{Is", n);
                }
                n = -1;
                n = stringBuffer.indexOf("-[", 0);
                while (n != -1) {
                    stringBuffer = stringBuffer.replace(n, n + 2, "&&[^");
                    n = stringBuffer.indexOf("-[", n);
                }
                string = stringBuffer.toString();
                bl = Pattern.matches(string, string2);
                break;
            }
            case 1: {
                X500Principal x500Principal = ((X500NameAttribute)attributeValueArray[0]).getValue();
                X500Principal x500Principal2 = ((X500NameAttribute)attributeValueArray[1]).getValue();
                bl = x500Principal2.getName("CANONICAL").endsWith(x500Principal.getName("CANONICAL"));
                break;
            }
            case 2: {
                String string = ((StringAttribute)attributeValueArray[0]).getValue();
                String string3 = ((RFC822NameAttribute)attributeValueArray[1]).getValue();
                if (string.indexOf(64) != -1) {
                    String string4 = new RFC822NameAttribute(string).getValue();
                    bl = string4.equals(string3);
                    break;
                }
                if (string.charAt(0) == '.') {
                    bl = string3.endsWith(string.toLowerCase());
                    break;
                }
                String string5 = string3.substring(string3.indexOf(64) + 1);
                bl = string.toLowerCase().equals(string5);
            }
        }
        return EvaluationResult.getInstance(bl);
    }
}

