/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DoubleAttribute;
import com.sun.xacml.attr.IntegerAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DivideFunction
extends FunctionBase {
    public static final String NAME_INTEGER_DIVIDE = "urn:oasis:names:tc:xacml:1.0:function:integer-divide";
    public static final String NAME_DOUBLE_DIVIDE = "urn:oasis:names:tc:xacml:1.0:function:double-divide";
    private static final int ID_INTEGER_DIVIDE = 0;
    private static final int ID_DOUBLE_DIVIDE = 1;

    public DivideFunction(String string) {
        super(string, DivideFunction.getId(string), DivideFunction.getArgumentType(string), false, 2, DivideFunction.getArgumentType(string), false);
    }

    private static int getId(String string) {
        if (string.equals(NAME_INTEGER_DIVIDE)) {
            return 0;
        }
        if (string.equals(NAME_DOUBLE_DIVIDE)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown divide function " + string);
    }

    private static String getArgumentType(String string) {
        if (string.equals(NAME_INTEGER_DIVIDE)) {
            return "http://www.w3.org/2001/XMLSchema#integer";
        }
        return "http://www.w3.org/2001/XMLSchema#double";
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(NAME_INTEGER_DIVIDE);
        hashSet.add(NAME_DOUBLE_DIVIDE);
        return hashSet;
    }

    public EvaluationResult evaluate(List list, EvaluationCtx evaluationCtx) {
        AttributeValue[] attributeValueArray = new AttributeValue[list.size()];
        EvaluationResult evaluationResult = this.evalArgs(list, evaluationCtx, attributeValueArray);
        if (evaluationResult != null) {
            return evaluationResult;
        }
        switch (this.getFunctionId()) {
            case 0: {
                long l = ((IntegerAttribute)attributeValueArray[0]).getValue();
                long l2 = ((IntegerAttribute)attributeValueArray[1]).getValue();
                if (l2 == 0L) {
                    evaluationResult = DivideFunction.makeProcessingError("divide by zero");
                    break;
                }
                long l3 = l / l2;
                evaluationResult = new EvaluationResult(new IntegerAttribute(l3));
                break;
            }
            case 1: {
                double d = ((DoubleAttribute)attributeValueArray[0]).getValue();
                double d2 = ((DoubleAttribute)attributeValueArray[1]).getValue();
                if (d2 == 0.0) {
                    evaluationResult = DivideFunction.makeProcessingError("divide by zero");
                    break;
                }
                double d3 = d / d2;
                evaluationResult = new EvaluationResult(new DoubleAttribute(d3));
            }
        }
        return evaluationResult;
    }
}

