/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.cond.Function;
import com.sun.xacml.cond.FunctionFactory;
import com.sun.xacml.cond.FunctionProxy;
import com.sun.xacml.cond.FunctionTypeException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class BaseFunctionFactory
extends FunctionFactory {
    private HashMap functionMap = new HashMap();
    private FunctionFactory superset = null;

    public BaseFunctionFactory() {
        this(null);
    }

    public BaseFunctionFactory(FunctionFactory functionFactory) {
        this.superset = functionFactory;
    }

    public BaseFunctionFactory(Set set, Map map) {
        this(null, set, map);
    }

    public BaseFunctionFactory(FunctionFactory functionFactory, Set set, Map map) {
        this(functionFactory);
        Object object;
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (Function)iterator.next();
            this.functionMap.put(object.getIdentifier().toString(), object);
        }
        iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = (URI)iterator.next();
            FunctionProxy functionProxy = (FunctionProxy)map.get(object);
            this.functionMap.put(((URI)object).toString(), functionProxy);
        }
    }

    public void addFunction(Function function) throws IllegalArgumentException {
        String string = function.getIdentifier().toString();
        if (this.functionMap.containsKey(string)) {
            throw new IllegalArgumentException("function already exists");
        }
        if (this.superset != null) {
            this.superset.addFunction(function);
        }
        this.functionMap.put(string, function);
    }

    public void addAbstractFunction(FunctionProxy functionProxy, URI uRI) throws IllegalArgumentException {
        String string = uRI.toString();
        if (this.functionMap.containsKey(string)) {
            throw new IllegalArgumentException("function already exists");
        }
        if (this.superset != null) {
            this.superset.addAbstractFunction(functionProxy, uRI);
        }
        this.functionMap.put(string, functionProxy);
    }

    public Set getSupportedFunctions() {
        HashSet hashSet = new HashSet(this.functionMap.keySet());
        if (this.superset != null) {
            hashSet.addAll(this.superset.getSupportedFunctions());
        }
        return hashSet;
    }

    public Function createFunction(URI uRI) throws UnknownIdentifierException, FunctionTypeException {
        return this.createFunction(uRI.toString());
    }

    public Function createFunction(String string) throws UnknownIdentifierException, FunctionTypeException {
        Object v = this.functionMap.get(string);
        if (v != null) {
            if (v instanceof Function) {
                return (Function)v;
            }
            throw new FunctionTypeException("function is abstract");
        }
        throw new UnknownIdentifierException("functions of type " + string + " are not " + "supported by this factory");
    }

    public Function createAbstractFunction(URI uRI, Node node) throws UnknownIdentifierException, ParsingException, FunctionTypeException {
        return this.createAbstractFunction(uRI.toString(), node, null);
    }

    public Function createAbstractFunction(URI uRI, Node node, String string) throws UnknownIdentifierException, ParsingException, FunctionTypeException {
        return this.createAbstractFunction(uRI.toString(), node, string);
    }

    public Function createAbstractFunction(String string, Node node) throws UnknownIdentifierException, ParsingException, FunctionTypeException {
        return this.createAbstractFunction(string, node, null);
    }

    public Function createAbstractFunction(String string, Node node, String string2) throws UnknownIdentifierException, ParsingException, FunctionTypeException {
        Object v = this.functionMap.get(string);
        if (v != null) {
            if (v instanceof FunctionProxy) {
                try {
                    return ((FunctionProxy)v).getInstance(node, string2);
                }
                catch (Exception exception) {
                    throw new ParsingException("couldn't create abstract function " + string, exception);
                }
            }
            throw new FunctionTypeException("function is concrete");
        }
        throw new UnknownIdentifierException("abstract functions of type " + string + " are not supported by " + "this factory");
    }
}

