/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DoubleAttribute;
import com.sun.xacml.attr.IntegerAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AbsFunction
extends FunctionBase {
    public static final String NAME_INTEGER_ABS = "urn:oasis:names:tc:xacml:1.0:function:integer-abs";
    public static final String NAME_DOUBLE_ABS = "urn:oasis:names:tc:xacml:1.0:function:double-abs";
    private static final int ID_INTEGER_ABS = 0;
    private static final int ID_DOUBLE_ABS = 1;

    public AbsFunction(String string) {
        super(string, AbsFunction.getId(string), AbsFunction.getArgumentType(string), false, 1, AbsFunction.getArgumentType(string), false);
    }

    private static int getId(String string) {
        if (string.equals(NAME_INTEGER_ABS)) {
            return 0;
        }
        if (string.equals(NAME_DOUBLE_ABS)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown abs function " + string);
    }

    private static String getArgumentType(String string) {
        if (string.equals(NAME_INTEGER_ABS)) {
            return "http://www.w3.org/2001/XMLSchema#integer";
        }
        return "http://www.w3.org/2001/XMLSchema#double";
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(NAME_INTEGER_ABS);
        hashSet.add(NAME_DOUBLE_ABS);
        return hashSet;
    }

    public EvaluationResult evaluate(List list, EvaluationCtx evaluationCtx) {
        AttributeValue[] attributeValueArray = new AttributeValue[list.size()];
        EvaluationResult evaluationResult = this.evalArgs(list, evaluationCtx, attributeValueArray);
        if (evaluationResult != null) {
            return evaluationResult;
        }
        switch (this.getFunctionId()) {
            case 0: {
                long l = ((IntegerAttribute)attributeValueArray[0]).getValue();
                long l2 = Math.abs(l);
                evaluationResult = new EvaluationResult(new IntegerAttribute(l2));
                break;
            }
            case 1: {
                double d = ((DoubleAttribute)attributeValueArray[0]).getValue();
                double d2 = Math.abs(d);
                evaluationResult = new EvaluationResult(new DoubleAttribute(d2));
            }
        }
        return evaluationResult;
    }
}

