/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.ParsingException;
import com.sun.xacml.ProcessingException;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DateAttribute;
import com.sun.xacml.attr.DateTimeAttribute;
import java.net.URI;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.w3c.dom.Node;

public class TimeAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#time";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    public static final int TZ_UNSPECIFIED = -1000000;
    private long timeGMT;
    private int nanoseconds;
    private int timeZone;
    private int defaultedTimeZone;
    private String encodedValue = null;

    public TimeAttribute() {
        super(identifierURI);
        Date date = new Date();
        int n = DateTimeAttribute.getDefaultTZOffset(date);
        this.init(date, 0, n, n);
    }

    public TimeAttribute(Date date, int n, int n2, int n3) {
        super(identifierURI);
        if (n2 == -1000000 && n3 == -1000000) {
            throw new ProcessingException("default timezone must be specified");
        }
        this.init(date, n, n2, n3);
    }

    private void init(Date date, int n, int n2, int n3) {
        if (earlyException != null) {
            throw earlyException;
        }
        Date date2 = (Date)date.clone();
        this.nanoseconds = DateTimeAttribute.combineNanos(date2, n);
        this.timeGMT = date2.getTime();
        this.timeZone = n2;
        this.defaultedTimeZone = n3;
        if (this.timeGMT >= 86400000L || this.timeGMT < 0L) {
            this.timeGMT %= 86400000L;
            if (this.timeGMT < 0L) {
                this.timeGMT += 86400000L;
            }
        }
    }

    public static TimeAttribute getInstance(Node node) throws ParsingException, NumberFormatException, ParseException {
        return TimeAttribute.getInstance(node.getFirstChild().getNodeValue());
    }

    public static TimeAttribute getInstance(String string) throws ParsingException, NumberFormatException, ParseException {
        string = "1970-01-01T" + string;
        DateTimeAttribute dateTimeAttribute = DateTimeAttribute.getInstance(string);
        Date date = dateTimeAttribute.getValue();
        int n = dateTimeAttribute.getDefaultedTimeZone();
        if (dateTimeAttribute.getTimeZone() == -1000000) {
            TimeZone timeZone = TimeZone.getDefault();
            int n2 = DateTimeAttribute.getDefaultTZOffset(new Date());
            date = new Date(date.getTime() - (long)((n2 - n) * 60000));
            n = n2;
        }
        return new TimeAttribute(date, dateTimeAttribute.getNanoseconds(), dateTimeAttribute.getTimeZone(), n);
    }

    public Date getValue() {
        return new Date(this.timeGMT);
    }

    public long getMilliseconds() {
        return this.timeGMT;
    }

    public int getNanoseconds() {
        return this.nanoseconds;
    }

    public int getTimeZone() {
        return this.timeZone;
    }

    public int getDefaultedTimeZone() {
        return this.defaultedTimeZone;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TimeAttribute)) {
            return false;
        }
        TimeAttribute timeAttribute = (TimeAttribute)object;
        return this.timeGMT == timeAttribute.timeGMT && this.nanoseconds == timeAttribute.nanoseconds;
    }

    public int hashCode() {
        int n = (int)(this.timeGMT ^ this.timeGMT >>> 32);
        n = 31 * n + this.nanoseconds;
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TimeAttribute: [\n");
        long l = this.timeGMT / 1000L;
        long l2 = l / 60L;
        long l3 = l2 / 60L;
        String string = l3 < 10L ? "0" + l3 : "" + l3;
        String string2 = l2 < 10L ? "0" + l2 : "" + (l2 %= 60L);
        String string3 = l < 10L ? "0" + l : "" + (l %= 60L);
        stringBuffer.append("  Time GMT: " + string + ":" + string2 + ":" + string3);
        stringBuffer.append("  Nanoseconds: " + this.nanoseconds);
        stringBuffer.append("  TimeZone: " + this.timeZone);
        stringBuffer.append("  Defaulted TimeZone: " + this.defaultedTimeZone);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String encode() {
        if (this.encodedValue != null) {
            return this.encodedValue;
        }
        StringBuffer stringBuffer = new StringBuffer(27);
        int n = (int)this.timeGMT;
        n = this.timeZone == -1000000 ? (n += this.defaultedTimeZone * 60000) : (n += this.timeZone * 60000);
        if (n < 0) {
            n = (int)((long)n + 86400000L);
        } else if ((long)n >= 86400000L) {
            n = (int)((long)n - 86400000L);
        }
        int n2 = n / 3600000;
        stringBuffer.append(DateAttribute.zeroPadInt(n2, 2));
        stringBuffer.append(':');
        int n3 = (n %= 3600000) / 60000;
        stringBuffer.append(DateAttribute.zeroPadInt(n3, 2));
        stringBuffer.append(':');
        int n4 = (n %= 60000) / 1000;
        stringBuffer.append(DateAttribute.zeroPadInt(n4, 2));
        if (this.nanoseconds != 0) {
            stringBuffer.append('.');
            stringBuffer.append(DateAttribute.zeroPadInt(this.nanoseconds, 9));
        }
        if (this.timeZone != -1000000) {
            int n5 = this.timeZone;
            if (this.timeZone < 0) {
                n5 = -n5;
                stringBuffer.append('-');
            } else {
                stringBuffer.append('+');
            }
            int n6 = n5 / 60;
            stringBuffer.append(DateAttribute.zeroPadInt(n6, 2));
            stringBuffer.append(':');
            int n7 = n5 % 60;
            stringBuffer.append(DateAttribute.zeroPadInt(n7, 2));
        }
        this.encodedValue = stringBuffer.toString();
        return this.encodedValue;
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
    }
}

