/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import org.w3c.dom.Node;

public class IntegerAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#integer";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private long value;

    public IntegerAttribute(long l) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = l;
    }

    public static IntegerAttribute getInstance(Node node) throws NumberFormatException {
        return IntegerAttribute.getInstance(node.getFirstChild().getNodeValue());
    }

    public static IntegerAttribute getInstance(String string) throws NumberFormatException {
        if (string.length() >= 1 && string.charAt(0) == '+') {
            string = string.substring(1);
        }
        return new IntegerAttribute(Long.parseLong(string));
    }

    public long getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntegerAttribute)) {
            return false;
        }
        IntegerAttribute integerAttribute = (IntegerAttribute)object;
        return this.value == integerAttribute.value;
    }

    public int hashCode() {
        return (int)this.value;
    }

    public String encode() {
        return String.valueOf(this.value);
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
    }
}

