/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DateAttribute;
import java.io.Serializable;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.Node;

public class DateTimeAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#dateTime";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private static DateFormat simpleParser;
    private static DateFormat zoneParser;
    private static Calendar gmtCalendar;
    public static final int TZ_UNSPECIFIED = -1000000;
    private Date value;
    private int nanoseconds;
    private int timeZone;
    private int defaultedTimeZone;
    private String encodedValue = null;

    public DateTimeAttribute() {
        super(identifierURI);
        Date date = new Date();
        int n = DateTimeAttribute.getDefaultTZOffset(date);
        this.init(date, 0, n, n);
    }

    public DateTimeAttribute(Date date, int n, int n2, int n3) {
        super(identifierURI);
        this.init(date, n, n2, n3);
    }

    private void init(Date date, int n, int n2, int n3) {
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = (Date)date.clone();
        this.nanoseconds = DateTimeAttribute.combineNanos(this.value, n);
        this.timeZone = n2;
        this.defaultedTimeZone = n3;
    }

    public static DateTimeAttribute getInstance(Node node) throws ParsingException, NumberFormatException, ParseException {
        return DateTimeAttribute.getInstance(node.getFirstChild().getNodeValue());
    }

    public static DateTimeAttribute getInstance(String string) throws ParsingException, NumberFormatException, ParseException {
        int n;
        int n2;
        Object object;
        int n3;
        Date date = null;
        int n4 = 0;
        DateTimeAttribute.initParsers();
        if (string.endsWith("Z")) {
            string = string.substring(0, string.length() - 1) + "+00:00";
        }
        boolean bl = string.charAt((n3 = string.length()) - 3) == ':' && (string.charAt(n3 - 6) == '-' || string.charAt(n3 - 6) == '+');
        int n5 = string.indexOf(46);
        if (n5 != -1) {
            int n6 = string.length();
            if (bl) {
                n6 -= 6;
            }
            String string2 = string.substring(n5 + 1, n6);
            for (int i = string2.length() - 1; i >= 0; --i) {
                char c = string2.charAt(i);
                if (c >= '0' && c <= '9') continue;
                throw new ParsingException("non-ascii digit found");
            }
            while (string2.length() < 9) {
                string2 = string2 + "0";
            }
            if (string2.length() > 9) {
                string2 = string2.substring(0, 9);
            }
            n4 = Integer.parseInt(string2);
            string = string.substring(0, n5) + string.substring(n6, string.length());
        }
        if (bl) {
            n3 = string.length();
            object = DateTimeAttribute.strictParse(zoneParser, string.substring(0, n3 - 6) + "+0000");
            string = string.substring(0, n3 - 3) + string.substring(n3 - 2, n3);
            date = DateTimeAttribute.strictParse(zoneParser, string);
            n2 = (int)(((Date)object).getTime() - date.getTime());
            n = n2 /= 60000;
        } else {
            date = DateTimeAttribute.strictParse(simpleParser, string);
            n2 = -1000000;
            object = DateTimeAttribute.strictParse(zoneParser, string + "+0000");
            n = (int)(((Date)object).getTime() - date.getTime());
            n /= 60000;
        }
        object = new DateTimeAttribute(date, n4, n2, n);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date strictParse(DateFormat dateFormat, String string) throws ParseException {
        Date date;
        ParsePosition parsePosition = new ParsePosition(0);
        DateFormat dateFormat2 = dateFormat;
        synchronized (dateFormat2) {
            date = dateFormat.parse(string, parsePosition);
        }
        if (parsePosition.getIndex() != string.length()) {
            throw new ParseException("", 0);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initParsers() {
        if (simpleParser != null) {
            return;
        }
        if (earlyException != null) {
            throw earlyException;
        }
        URI uRI = identifierURI;
        synchronized (uRI) {
            simpleParser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            simpleParser.setLenient(false);
            zoneParser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            zoneParser.setLenient(false);
        }
    }

    public Date getValue() {
        return (Date)this.value.clone();
    }

    public int getNanoseconds() {
        return this.nanoseconds;
    }

    public int getTimeZone() {
        return this.timeZone;
    }

    public int getDefaultedTimeZone() {
        return this.defaultedTimeZone;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateTimeAttribute)) {
            return false;
        }
        DateTimeAttribute dateTimeAttribute = (DateTimeAttribute)object;
        return this.value.equals(dateTimeAttribute.value) && this.nanoseconds == dateTimeAttribute.nanoseconds;
    }

    public int hashCode() {
        int n = this.value.hashCode();
        n = 31 * n + this.nanoseconds;
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DateTimeAttribute: [\n");
        stringBuffer.append("  Date: " + this.value + " local time");
        stringBuffer.append("  Nanoseconds: " + this.nanoseconds);
        stringBuffer.append("  TimeZone: " + this.timeZone);
        stringBuffer.append("  Defaulted TimeZone: " + this.defaultedTimeZone);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode() {
        if (this.encodedValue != null) {
            return this.encodedValue;
        }
        if (this.timeZone == -1000000) {
            DateTimeAttribute.initParsers();
            DateFormat dateFormat = simpleParser;
            synchronized (dateFormat) {
                this.encodedValue = simpleParser.format(this.value);
            }
            if (this.nanoseconds != 0) {
                this.encodedValue = this.encodedValue + "." + DateAttribute.zeroPadInt(this.nanoseconds, 9);
            }
        } else {
            this.encodedValue = this.formatDateTimeWithTZ();
        }
        return this.encodedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatDateTimeWithTZ() {
        int n;
        int n2;
        Serializable serializable;
        if (gmtCalendar == null) {
            serializable = TimeZone.getTimeZone("GMT");
            gmtCalendar = Calendar.getInstance((TimeZone)serializable, Locale.US);
        }
        serializable = new StringBuffer(35);
        Calendar calendar = gmtCalendar;
        synchronized (calendar) {
            gmtCalendar.setTime(this.value);
            gmtCalendar.add(12, this.timeZone);
            n2 = gmtCalendar.get(1);
            ((StringBuffer)serializable).append(DateAttribute.zeroPadInt(n2, 4));
            ((StringBuffer)serializable).append('-');
            n = gmtCalendar.get(2) + 1;
            ((StringBuffer)serializable).append(DateAttribute.zeroPadInt(n, 2));
            ((StringBuffer)serializable).append('-');
            int n3 = gmtCalendar.get(5);
            ((StringBuffer)serializable).append(DateAttribute.zeroPadInt(n3, 2));
            ((StringBuffer)serializable).append('T');
            int n4 = gmtCalendar.get(11);
            ((StringBuffer)serializable).append(DateAttribute.zeroPadInt(n4, 2));
            ((StringBuffer)serializable).append(':');
            int n5 = gmtCalendar.get(12);
            ((StringBuffer)serializable).append(DateAttribute.zeroPadInt(n5, 2));
            ((StringBuffer)serializable).append(':');
            int n6 = gmtCalendar.get(13);
            ((StringBuffer)serializable).append(DateAttribute.zeroPadInt(n6, 2));
        }
        if (this.nanoseconds != 0) {
            ((StringBuffer)serializable).append('.');
            ((StringBuffer)serializable).append(DateAttribute.zeroPadInt(this.nanoseconds, 9));
        }
        int n7 = this.timeZone;
        if (this.timeZone < 0) {
            n7 = -n7;
            ((StringBuffer)serializable).append('-');
        } else {
            ((StringBuffer)serializable).append('+');
        }
        n2 = n7 / 60;
        ((StringBuffer)serializable).append(DateAttribute.zeroPadInt(n2, 2));
        ((StringBuffer)serializable).append(':');
        n = n7 % 60;
        ((StringBuffer)serializable).append(DateAttribute.zeroPadInt(n, 2));
        return ((StringBuffer)serializable).toString();
    }

    static int getDefaultTZOffset(Date date) {
        int n = TimeZone.getDefault().getOffset(date.getTime());
        return n /= 60000;
    }

    static int combineNanos(Date date, int n) {
        long l = date.getTime();
        int n2 = (int)(l % 1000L);
        if (n2 == 0 && n > 0 && n < 1000000000) {
            return n;
        }
        l -= (long)n2;
        long l2 = n;
        int n3 = (int)((l2 += (long)(n2 * 1000000)) % 1000000000L);
        date.setTime(l += (l2 -= (long)n3) / 1000000L);
        return n3;
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
    }
}

