/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DateTimeAttribute;
import java.io.Serializable;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.Node;

public class DateAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#date";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private static DateFormat simpleParser;
    private static DateFormat zoneParser;
    private static Calendar gmtCalendar;
    static final int NANOS_PER_MILLI = 1000000;
    static final int MILLIS_PER_SECOND = 1000;
    static final int SECONDS_PER_MINUTE = 60;
    static final int MINUTES_PER_HOUR = 60;
    static final int HOURS_PER_DAY = 24;
    static final int NANOS_PER_SECOND = 1000000000;
    static final int MILLIS_PER_MINUTE = 60000;
    static final int MILLIS_PER_HOUR = 3600000;
    static final long MILLIS_PER_DAY = 86400000L;
    public static final int TZ_UNSPECIFIED = -1000000;
    private Date value;
    private int timeZone;
    private int defaultedTimeZone;
    private String encodedValue = null;

    public DateAttribute() {
        super(identifierURI);
        Date date = new Date();
        int n = DateTimeAttribute.getDefaultTZOffset(date);
        long l = date.getTime();
        l += (long)(n * 60000);
        l -= l % 86400000L;
        date.setTime(l -= (long)(n * 60000));
        this.init(date, n, n);
    }

    public DateAttribute(Date date, int n, int n2) {
        super(identifierURI);
        this.init(date, n, n2);
    }

    private void init(Date date, int n, int n2) {
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = (Date)date.clone();
        this.timeZone = n;
        this.defaultedTimeZone = n2;
    }

    public static DateAttribute getInstance(Node node) throws ParseException {
        return DateAttribute.getInstance(node.getFirstChild().getNodeValue());
    }

    public static DateAttribute getInstance(String string) throws ParseException {
        int n;
        int n2;
        Date date = null;
        if (simpleParser == null) {
            DateAttribute.initParsers();
        }
        if (string.endsWith("Z")) {
            string = string.substring(0, string.length() - 1) + "+0000";
            date = DateAttribute.strictParse(zoneParser, string);
            n2 = 0;
            n = 0;
        } else {
            int n3 = string.length();
            if (n3 > 6 && string.charAt(n3 - 3) == ':') {
                Date date2 = DateAttribute.strictParse(zoneParser, string.substring(0, n3 - 6) + "+0000");
                string = string.substring(0, n3 - 3) + string.substring(n3 - 2, n3);
                date = DateAttribute.strictParse(zoneParser, string);
                n2 = (int)(date2.getTime() - date.getTime());
                n = n2 /= 60000;
            } else {
                date = DateAttribute.strictParse(simpleParser, string);
                n2 = -1000000;
                Date date3 = DateAttribute.strictParse(zoneParser, string + "+0000");
                n = (int)(date3.getTime() - date.getTime());
                n /= 60000;
            }
        }
        DateAttribute dateAttribute = new DateAttribute(date, n2, n);
        return dateAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date strictParse(DateFormat dateFormat, String string) throws ParseException {
        Date date;
        ParsePosition parsePosition = new ParsePosition(0);
        DateFormat dateFormat2 = dateFormat;
        synchronized (dateFormat2) {
            date = dateFormat.parse(string, parsePosition);
        }
        if (parsePosition.getIndex() != string.length()) {
            throw new ParseException("", 0);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initParsers() {
        if (simpleParser != null) {
            return;
        }
        if (earlyException != null) {
            throw earlyException;
        }
        URI uRI = identifierURI;
        synchronized (uRI) {
            simpleParser = new SimpleDateFormat("yyyy-MM-dd");
            simpleParser.setLenient(false);
            zoneParser = new SimpleDateFormat("yyyy-MM-ddZ");
            zoneParser.setLenient(false);
        }
    }

    public Date getValue() {
        return (Date)this.value.clone();
    }

    public int getTimeZone() {
        return this.timeZone;
    }

    public int getDefaultedTimeZone() {
        return this.defaultedTimeZone;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateAttribute)) {
            return false;
        }
        DateAttribute dateAttribute = (DateAttribute)object;
        return this.value.equals(dateAttribute.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DateAttribute: [\n");
        stringBuffer.append("  Date: " + this.value + " local time");
        stringBuffer.append("  TimeZone: " + this.timeZone);
        stringBuffer.append("  Defaulted TimeZone: " + this.defaultedTimeZone);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode() {
        if (this.encodedValue != null) {
            return this.encodedValue;
        }
        if (this.timeZone == -1000000) {
            DateAttribute.initParsers();
            DateFormat dateFormat = simpleParser;
            synchronized (dateFormat) {
                this.encodedValue = simpleParser.format(this.value);
            }
        } else {
            this.encodedValue = this.formatDateWithTZ();
        }
        return this.encodedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatDateWithTZ() {
        int n;
        int n2;
        Serializable serializable;
        if (gmtCalendar == null) {
            serializable = TimeZone.getTimeZone("GMT");
            gmtCalendar = Calendar.getInstance((TimeZone)serializable, Locale.US);
        }
        serializable = new StringBuffer(16);
        Calendar calendar = gmtCalendar;
        synchronized (calendar) {
            gmtCalendar.setTime(this.value);
            gmtCalendar.add(12, this.timeZone);
            n2 = gmtCalendar.get(1);
            ((StringBuffer)serializable).append(DateAttribute.zeroPadInt(n2, 4));
            ((StringBuffer)serializable).append('-');
            n = gmtCalendar.get(2) + 1;
            ((StringBuffer)serializable).append(DateAttribute.zeroPadInt(n, 2));
            ((StringBuffer)serializable).append('-');
            int n3 = gmtCalendar.get(5);
            ((StringBuffer)serializable).append(DateAttribute.zeroPadInt(n3, 2));
        }
        int n4 = this.timeZone;
        if (this.timeZone < 0) {
            n4 = -n4;
            ((StringBuffer)serializable).append('-');
        } else {
            ((StringBuffer)serializable).append('+');
        }
        n2 = n4 / 60;
        ((StringBuffer)serializable).append(DateAttribute.zeroPadInt(n2, 2));
        ((StringBuffer)serializable).append(':');
        n = n4 % 60;
        ((StringBuffer)serializable).append(DateAttribute.zeroPadInt(n, 2));
        return ((StringBuffer)serializable).toString();
    }

    static String zeroPadIntString(String string, int n) {
        int n2 = string.length();
        char c = string.charAt(0);
        if (c != '-' && c != '+') {
            c = '\u0000';
        }
        int n3 = n;
        if (c != '\u0000') {
            ++n3;
        }
        if (n2 >= n3) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (c != '\u0000') {
            stringBuffer.append(c);
        }
        int n4 = n3 - n2;
        while (n4-- != 0) {
            stringBuffer.append('0');
        }
        if (c != '\u0000') {
            stringBuffer.append(string.substring(1, n2));
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    static String zeroPadInt(int n, int n2) {
        return DateAttribute.zeroPadIntString(Integer.toString(n), n2);
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
    }
}

