/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.Base64;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import org.w3c.dom.Node;

public class Base64BinaryAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#base64Binary";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private byte[] value;
    private String strValue;

    public Base64BinaryAttribute(byte[] byArray) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = (byte[])byArray.clone();
    }

    public static Base64BinaryAttribute getInstance(Node node) throws ParsingException {
        return Base64BinaryAttribute.getInstance(node.getFirstChild().getNodeValue());
    }

    public static Base64BinaryAttribute getInstance(String string) throws ParsingException {
        byte[] byArray = null;
        try {
            byArray = Base64.decode(string, false);
        }
        catch (IOException iOException) {
            throw new ParsingException("Couldn't parse purported Base64 string: " + string, iOException);
        }
        return new Base64BinaryAttribute(byArray);
    }

    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Base64BinaryAttribute)) {
            return false;
        }
        Base64BinaryAttribute base64BinaryAttribute = (Base64BinaryAttribute)object;
        return Arrays.equals(this.value, base64BinaryAttribute.value);
    }

    public int hashCode() {
        int n = this.value[0];
        for (int i = 1; i < this.value.length; ++i) {
            n *= 31;
            n += this.value[i];
        }
        return n;
    }

    private String makeStringRep() {
        return Base64.encode(this.value);
    }

    public String toString() {
        if (this.strValue == null) {
            this.strValue = this.makeStringRep();
        }
        return "Base64BinaryAttribute: [\n" + this.strValue + "]\n";
    }

    public String encode() {
        if (this.strValue == null) {
            this.strValue = this.makeStringRep();
        }
        return this.strValue;
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
    }
}

