/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BagAttribute
extends AttributeValue {
    private Collection bag;

    public BagAttribute(URI uRI, Collection collection) {
        super(uRI);
        if (uRI == null) {
            throw new IllegalArgumentException("Bags require a non-null type be provided");
        }
        if (collection == null || collection.size() == 0) {
            this.bag = new ArrayList();
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                AttributeValue attributeValue = (AttributeValue)iterator.next();
                if (attributeValue.isBag()) {
                    throw new IllegalArgumentException("bags cannot contain other bags");
                }
                if (uRI.equals(attributeValue.getType())) continue;
                throw new IllegalArgumentException("Bag items must all be of the same type");
            }
            this.bag = collection;
        }
    }

    public boolean isBag() {
        return true;
    }

    public static BagAttribute createEmptyBag(URI uRI) {
        return new BagAttribute(uRI, null);
    }

    public boolean isEmpty() {
        return this.bag.size() == 0;
    }

    public int size() {
        return this.bag.size();
    }

    public boolean contains(AttributeValue attributeValue) {
        return this.bag.contains(attributeValue);
    }

    public boolean containsAll(BagAttribute bagAttribute) {
        return this.bag.containsAll(bagAttribute.bag);
    }

    public Iterator iterator() {
        return new ImmutableIterator(this.bag.iterator());
    }

    public String encode() {
        throw new UnsupportedOperationException("Bags cannot be encoded");
    }

    private class ImmutableIterator
    implements Iterator {
        private Iterator iterator;

        public ImmutableIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() throws NoSuchElementException {
            return this.iterator.next();
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

