/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.MatchResult;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeDesignator;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeSelector;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.BooleanAttribute;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.Function;
import com.sun.xacml.cond.FunctionFactory;
import com.sun.xacml.cond.FunctionTypeException;
import com.sun.xacml.ctx.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

public class TargetMatch {
    public static final int SUBJECT = 0;
    public static final int RESOURCE = 1;
    public static final int ACTION = 2;
    private int type;
    private Function function;
    private Evaluatable eval;
    private AttributeValue attrValue;

    public TargetMatch(int n, Function function, Evaluatable evaluatable, AttributeValue attributeValue) throws IllegalArgumentException {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Unknown TargetMatch type");
        }
        this.type = n;
        this.function = function;
        this.eval = evaluatable;
        this.attrValue = attributeValue;
    }

    public static TargetMatch getInstance(Node node, String string, String string2) throws ParsingException, IllegalArgumentException {
        Function function;
        Object object;
        int n;
        Evaluatable evaluatable = null;
        AttributeValue attributeValue = null;
        AttributeFactory attributeFactory = AttributeFactory.getInstance();
        if (string.equals("Subject")) {
            n = 0;
        } else if (string.equals("Resource")) {
            n = 1;
        } else if (string.equals("Action")) {
            n = 2;
        } else {
            throw new IllegalArgumentException("Unknown TargetMatch type");
        }
        String string3 = node.getAttributes().getNamedItem("MatchId").getNodeValue();
        FunctionFactory functionFactory = FunctionFactory.getTargetInstance();
        try {
            object = new URI(string3);
            function = functionFactory.createFunction((URI)object);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParsingException("Error parsing TargetMatch", uRISyntaxException);
        }
        catch (UnknownIdentifierException unknownIdentifierException) {
            throw new ParsingException("Unknown MatchId", unknownIdentifierException);
        }
        catch (FunctionTypeException functionTypeException) {
            try {
                URI uRI = new URI(string3);
                function = functionFactory.createAbstractFunction(uRI, node);
            }
            catch (Exception exception) {
                throw new ParsingException("invalid abstract function", exception);
            }
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node2 = object.item(i);
            String string4 = node2.getNodeName();
            if (string4.equals(string + "AttributeDesignator")) {
                evaluatable = AttributeDesignator.getInstance(node2, n);
                continue;
            }
            if (string4.equals("AttributeSelector")) {
                evaluatable = AttributeSelector.getInstance(node2, string2);
                continue;
            }
            if (!string4.equals("AttributeValue")) continue;
            try {
                attributeValue = attributeFactory.createValue(node2);
                continue;
            }
            catch (UnknownIdentifierException unknownIdentifierException) {
                throw new ParsingException("Unknown Attribute Type", unknownIdentifierException);
            }
        }
        ArrayList<Evaluatable> arrayList = new ArrayList<Evaluatable>();
        arrayList.add(attributeValue);
        arrayList.add(evaluatable);
        function.checkInputsNoBag(arrayList);
        return new TargetMatch(n, function, evaluatable, attributeValue);
    }

    public int getType() {
        return this.type;
    }

    public Function getMatchFunction() {
        return this.function;
    }

    public AttributeValue getMatchValue() {
        return this.attrValue;
    }

    public Evaluatable getMatchEvaluatable() {
        return this.eval;
    }

    public MatchResult match(EvaluationCtx evaluationCtx) {
        EvaluationResult evaluationResult = this.eval.evaluate(evaluationCtx);
        if (evaluationResult.indeterminate()) {
            return new MatchResult(2, evaluationResult.getStatus());
        }
        BagAttribute bagAttribute = (BagAttribute)evaluationResult.getAttributeValue();
        if (!bagAttribute.isEmpty()) {
            Iterator iterator = bagAttribute.iterator();
            boolean bl = false;
            Status status = null;
            while (iterator.hasNext()) {
                ArrayList<AttributeValue> arrayList = new ArrayList<AttributeValue>();
                arrayList.add(this.attrValue);
                arrayList.add((AttributeValue)iterator.next());
                MatchResult matchResult = this.evaluateMatch(arrayList, evaluationCtx);
                if (matchResult.getResult() == 0) {
                    return matchResult;
                }
                if (matchResult.getResult() != 2) continue;
                bl = true;
                if (status != null) continue;
                status = matchResult.getStatus();
            }
            if (bl) {
                return new MatchResult(2, status);
            }
            return new MatchResult(1);
        }
        return new MatchResult(1);
    }

    private MatchResult evaluateMatch(List list, EvaluationCtx evaluationCtx) {
        EvaluationResult evaluationResult = this.function.evaluate(list, evaluationCtx);
        if (evaluationResult.indeterminate()) {
            return new MatchResult(2, evaluationResult.getStatus());
        }
        BooleanAttribute booleanAttribute = (BooleanAttribute)evaluationResult.getAttributeValue();
        if (booleanAttribute.getValue()) {
            return new MatchResult(0);
        }
        return new MatchResult(1);
    }

    public void encode(OutputStream outputStream) {
        this.encode(outputStream, new Indenter(0));
    }

    public void encode(OutputStream outputStream, Indenter indenter) {
        PrintStream printStream = new PrintStream(outputStream);
        String string = indenter.makeString();
        String string2 = null;
        switch (this.type) {
            case 0: {
                string2 = "SubjectMatch";
                break;
            }
            case 1: {
                string2 = "ResourceMatch";
                break;
            }
            case 2: {
                string2 = "ActionMatch";
            }
        }
        printStream.println(string + "<" + string2 + " MatchId=\"" + this.function.getIdentifier().toString() + "\">");
        indenter.in();
        this.attrValue.encode(outputStream, indenter);
        this.eval.encode(outputStream, indenter);
        indenter.out();
        printStream.println(string + "</" + string2 + ">");
    }
}

