/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.MatchResult;
import com.sun.xacml.ParsingException;
import com.sun.xacml.PolicyTreeElement;
import com.sun.xacml.Target;
import com.sun.xacml.attr.BooleanAttribute;
import com.sun.xacml.cond.Apply;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rule
implements PolicyTreeElement {
    private URI idAttr;
    private int effectAttr;
    private String description = null;
    private Target target = null;
    private Apply condition = null;

    public Rule(URI uRI, int n, String string, Target target, Apply apply) {
        this.idAttr = uRI;
        this.effectAttr = n;
        this.description = string;
        this.target = target;
        this.condition = apply;
    }

    public static Rule getInstance(Node node, String string) throws ParsingException {
        URI uRI = null;
        Object var3_3 = null;
        int n = 0;
        String string2 = null;
        Target target = null;
        Apply apply = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            uRI = new URI(namedNodeMap.getNamedItem("RuleId").getNodeValue());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParsingException("Error parsing required attribute RuleId", uRISyntaxException);
        }
        String string3 = namedNodeMap.getNamedItem("Effect").getNodeValue();
        if (string3.equals("Permit")) {
            n = 0;
        } else if (string3.equals("Deny")) {
            n = 1;
        } else {
            throw new ParsingException("Invalid Effect: " + n);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string4 = node2.getNodeName();
            if (string4.equals("Description")) {
                string2 = node2.getFirstChild().getNodeValue();
                continue;
            }
            if (string4.equals("Target")) {
                target = Target.getInstance(node2, string);
                continue;
            }
            if (!string4.equals("Condition")) continue;
            apply = Apply.getConditionInstance(node2, string);
        }
        return new Rule(uRI, n, string2, target, apply);
    }

    public int getEffect() {
        return this.effectAttr;
    }

    public URI getId() {
        return this.idAttr;
    }

    public String getDescription() {
        return this.description;
    }

    public Target getTarget() {
        return this.target;
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public Apply getCondition() {
        return this.condition;
    }

    public MatchResult match(EvaluationCtx evaluationCtx) {
        if (this.target == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
            Status status = new Status(arrayList, "no target available for matching a rule");
            return new MatchResult(2, status);
        }
        return this.target.match(evaluationCtx);
    }

    public Result evaluate(EvaluationCtx evaluationCtx) {
        Object object;
        if (this.target != null) {
            object = this.target.match(evaluationCtx);
            int n = ((MatchResult)object).getResult();
            if (n == 1) {
                return new Result(3, evaluationCtx.getResourceId().encode());
            }
            if (n == 2) {
                return new Result(2, ((MatchResult)object).getStatus(), evaluationCtx.getResourceId().encode());
            }
        }
        if (this.condition == null) {
            return new Result(this.effectAttr, evaluationCtx.getResourceId().encode());
        }
        object = this.condition.evaluate(evaluationCtx);
        if (((EvaluationResult)object).indeterminate()) {
            return new Result(2, ((EvaluationResult)object).getStatus(), evaluationCtx.getResourceId().encode());
        }
        BooleanAttribute booleanAttribute = (BooleanAttribute)((EvaluationResult)object).getAttributeValue();
        if (booleanAttribute.getValue()) {
            return new Result(this.effectAttr, evaluationCtx.getResourceId().encode());
        }
        return new Result(3, evaluationCtx.getResourceId().encode());
    }

    public void encode(OutputStream outputStream) {
        this.encode(outputStream, new Indenter(0));
    }

    public void encode(OutputStream outputStream, Indenter indenter) {
        PrintStream printStream = new PrintStream(outputStream);
        String string = indenter.makeString();
        printStream.print(string + "<Rule RuleId=\"" + this.idAttr.toString() + "\" Effect=\"" + Result.DECISIONS[this.effectAttr] + "\"");
        if (this.description != null || this.target != null || this.condition != null) {
            printStream.println(">");
            indenter.in();
            String string2 = indenter.makeString();
            if (this.description != null) {
                printStream.println(string2 + "<Description>" + this.description + "</Description>");
            }
            if (this.target != null) {
                this.target.encode(outputStream, indenter);
            }
            if (this.condition != null) {
                this.condition.encode(outputStream, indenter);
            }
            indenter.out();
            printStream.println(string + "</Rule>");
        } else {
            printStream.println("/>");
        }
    }
}

