/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.BasicEvaluationCtx;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.PDPConfig;
import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.AttributeFinder;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderResult;
import com.sun.xacml.finder.ResourceFinder;
import com.sun.xacml.finder.ResourceFinderResult;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PDP {
    private AttributeFinder attributeFinder;
    private PolicyFinder policyFinder;
    private ResourceFinder resourceFinder;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$PDP == null ? (class$com$sun$xacml$PDP = PDP.class$("com.sun.xacml.PDP")) : class$com$sun$xacml$PDP).getName());
    static /* synthetic */ Class class$com$sun$xacml$PDP;

    public PDP(PDPConfig pDPConfig) {
        logger.fine("creating a PDP");
        this.attributeFinder = pDPConfig.getAttributeFinder();
        this.policyFinder = pDPConfig.getPolicyFinder();
        this.policyFinder.init();
        this.resourceFinder = pDPConfig.getResourceFinder();
    }

    public ResponseCtx evaluate(RequestCtx requestCtx) {
        try {
            return this.evaluate(new BasicEvaluationCtx(requestCtx, this.attributeFinder));
        }
        catch (ParsingException parsingException) {
            logger.log(Level.INFO, "the PDP receieved an invalid request", parsingException);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("urn:oasis:names:tc:xacml:1.0:status:syntax-error");
            Status status = new Status(arrayList, parsingException.getMessage());
            return new ResponseCtx(new Result(2, status));
        }
    }

    public ResponseCtx evaluate(EvaluationCtx evaluationCtx) {
        if (evaluationCtx.getScope() != 0) {
            Object object;
            Object object2;
            AttributeValue attributeValue = evaluationCtx.getResourceId();
            ResourceFinderResult resourceFinderResult = null;
            resourceFinderResult = evaluationCtx.getScope() == 1 ? this.resourceFinder.findChildResources(attributeValue, evaluationCtx) : this.resourceFinder.findDescendantResources(attributeValue, evaluationCtx);
            if (resourceFinderResult.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                String string = "Couldn't find any resources to work on.";
                return new ResponseCtx(new Result(2, new Status(arrayList, string), evaluationCtx.getResourceId().encode()));
            }
            HashSet<Object> hashSet = new HashSet<Object>();
            Iterator<Object> iterator = resourceFinderResult.getResources().iterator();
            while (iterator.hasNext()) {
                object2 = (AttributeValue)iterator.next();
                evaluationCtx.setResourceId((AttributeValue)object2);
                object = this.evaluateContext(evaluationCtx);
                ((Result)object).setResource(((AttributeValue)object2).encode());
                hashSet.add(object);
            }
            object2 = resourceFinderResult.getFailures();
            iterator = object2.keySet().iterator();
            while (iterator.hasNext()) {
                object = (AttributeValue)iterator.next();
                Status status = (Status)object2.get(object);
                hashSet.add(new Result(2, status, ((AttributeValue)object).encode()));
            }
            return new ResponseCtx(hashSet);
        }
        return new ResponseCtx(this.evaluateContext(evaluationCtx));
    }

    private Result evaluateContext(EvaluationCtx evaluationCtx) {
        PolicyFinderResult policyFinderResult = this.policyFinder.findPolicy(evaluationCtx);
        if (policyFinderResult.notApplicable()) {
            return new Result(3, evaluationCtx.getResourceId().encode());
        }
        if (policyFinderResult.indeterminate()) {
            return new Result(2, policyFinderResult.getStatus(), evaluationCtx.getResourceId().encode());
        }
        return policyFinderResult.getPolicy().evaluate(evaluationCtx);
    }

    public OutputStream evaluate(InputStream inputStream) {
        RequestCtx requestCtx = null;
        ResponseCtx responseCtx = null;
        try {
            requestCtx = RequestCtx.getInstance(inputStream);
        }
        catch (Exception exception) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("urn:oasis:names:tc:xacml:1.0:status:syntax-error");
            Status status = new Status(arrayList, "invalid request: " + exception.getMessage());
            responseCtx = new ResponseCtx(new Result(2, status));
        }
        if (responseCtx == null) {
            responseCtx = this.evaluate(requestCtx);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        responseCtx.encode(byteArrayOutputStream, new Indenter());
        return byteArrayOutputStream;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

