/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import java.io.IOException;
import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.codegen.Target;
import org.antlr.misc.Utils;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.tool.Grammar;

public class ObjCTarget
extends Target {
    protected void genRecognizerHeaderFile(Tool tool, CodeGenerator codeGenerator, Grammar grammar, StringTemplate stringTemplate) throws IOException {
        codeGenerator.write(stringTemplate, grammar.name + Grammar.grammarTypeToFileNameSuffix[grammar.type] + ".h");
    }

    public String getTargetCharLiteralFromANTLRCharLiteral(CodeGenerator codeGenerator, String string) {
        if (string.startsWith("'\\u")) {
            string = "0x" + string.substring(3, 7);
        } else {
            char c = string.charAt(1);
            if (c < ' ' || c > '\u007f') {
                string = "0x" + Integer.toHexString(c);
            }
        }
        return string;
    }

    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator codeGenerator, String string) {
        string = Utils.replace(string, "\"", "\\\"");
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, '\"');
        stringBuffer.setCharAt(string.length() - 1, '\"');
        stringBuffer.insert(0, '@');
        return stringBuffer.toString();
    }

    public String getTokenTypeAsTargetLabel(CodeGenerator codeGenerator, int n) {
        String string = codeGenerator.grammar.getTokenDisplayName(n);
        if (string.charAt(0) == '\'') {
            return String.valueOf(n);
        }
        return codeGenerator.grammar.name + Grammar.grammarTypeToFileNameSuffix[codeGenerator.grammar.type] + "_" + string;
    }

    public String getTokenTextAndTypeAsTargetLabel(CodeGenerator codeGenerator, String string, int n) {
        String string2;
        String string3 = codeGenerator.grammar.getTokenDisplayName(n);
        if (string3.charAt(0) == '\'') {
            return String.valueOf(n);
        }
        String string4 = string2 = string == null ? string3 : string;
        if (string2.charAt(0) >= '0' && string2.charAt(0) <= '9') {
            return string2;
        }
        return codeGenerator.grammar.name + Grammar.grammarTypeToFileNameSuffix[codeGenerator.grammar.type] + "_" + string2;
    }
}

