/*
 * Decompiled with CFR 0.152.
 */
package tom.gom.adt.gom.types.option;

import aterm.ATerm;
import aterm.ATermAppl;
import tom.gom.adt.gom.types.Option;
import tom.gom.adt.gom.types.option.ConsOptionList;
import tom.gom.adt.gom.types.option.EmptyOptionList;

public abstract class OptionList
extends Option {
    public int length() {
        if (this instanceof ConsOptionList) {
            Option tl = ((ConsOptionList)this).getTailOptionList();
            if (tl instanceof OptionList) {
                return 1 + ((OptionList)tl).length();
            }
            return 2;
        }
        return 0;
    }

    public Option[] toArray() {
        Option[] array;
        if (this instanceof ConsOptionList) {
            Option h = ((ConsOptionList)this).getHeadOptionList();
            Option tl = ((ConsOptionList)this).getTailOptionList();
            if (tl instanceof OptionList) {
                Option[] tailArray = ((OptionList)tl).toArray();
                array = new Option[1 + tailArray.length];
                array[0] = h;
                for (int i = 0; i < tailArray.length; ++i) {
                    array[i + 1] = tailArray[i];
                }
            } else {
                array = new Option[]{h};
            }
        } else {
            array = new Option[]{};
        }
        return array;
    }

    public static Option fromArray(Option[] array) {
        Option res = EmptyOptionList.make();
        int i = array.length;
        while (i > 0) {
            res = ConsOptionList.make(array[--i], res);
        }
        return res;
    }

    public Option reverse() {
        if (this instanceof ConsOptionList) {
            Option cur = this;
            Option rev = EmptyOptionList.make();
            while (cur instanceof ConsOptionList) {
                rev = ConsOptionList.make(((ConsOptionList)cur).getHeadOptionList(), rev);
                cur = ((ConsOptionList)cur).getTailOptionList();
            }
            return rev;
        }
        return this;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("OptionList(");
        if (this instanceof ConsOptionList) {
            Option cur = this;
            while (cur instanceof ConsOptionList) {
                Option elem = ((ConsOptionList)cur).getHeadOptionList();
                cur = ((ConsOptionList)cur).getTailOptionList();
                elem.toStringBuffer(buffer);
                if (!(cur instanceof ConsOptionList)) continue;
                buffer.append(",");
            }
            if (!(cur instanceof EmptyOptionList)) {
                buffer.append(",");
                cur.toStringBuffer(buffer);
            }
        }
        buffer.append(")");
    }

    public static Option fromTerm(ATerm trm) {
        ATermAppl appl;
        if (trm instanceof ATermAppl && "OptionList".equals((appl = (ATermAppl)trm).getName())) {
            Option res = EmptyOptionList.make();
            ATerm[] array = appl.getArgumentArray();
            for (int i = array.length - 1; i >= 0; --i) {
                Option elem = Option.fromTerm(array[i]);
                res = ConsOptionList.make(elem, res);
            }
            return res;
        }
        return null;
    }
}

