/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import java.util.List;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAOptimizer;
import org.antlr.codegen.CodeGenerator;
import org.antlr.test.BaseTest;
import org.antlr.test.ErrorQueue;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.FASerializer;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarUnreachableAltsMessage;
import org.antlr.tool.Message;

public class TestCharDFAConversion
extends BaseTest {
    public void testSimpleRangeVersusChar() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a'..'z' '@' | 'k' '$' ;");
        grammar.createLookaheadDFAs();
        String string = ".s0-'k'->.s1\n.s0-{'a'..'j', 'l'..'z'}->:s3=>1\n.s1-'$'->:s2=>2\n.s1-'@'->:s3=>1\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void testRangeWithDisjointSet() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a'..'z' '@'\n  | ('k'|'9'|'p') '$'\n  ;\n");
        grammar.createLookaheadDFAs();
        String string = ".s0-'9'->:s2=>2\n.s0-{'a'..'j', 'l'..'o', 'q'..'z'}->:s3=>1\n.s0-{'k', 'p'}->.s1\n.s1-'$'->:s2=>2\n.s1-'@'->:s3=>1\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void testDisjointSetCollidingWithTwoRanges() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : ('a'..'z'|'0'..'9') '@'\n  | ('k'|'9'|'p') '$'\n  ;\n");
        grammar.createLookaheadDFAs();
        String string = ".s0-{'0'..'8', 'a'..'j', 'l'..'o', 'q'..'z'}->:s3=>1\n.s0-{'9', 'k', 'p'}->.s1\n.s1-'$'->:s2=>2\n.s1-'@'->:s3=>1\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void testDisjointSetCollidingWithTwoRangesCharsFirst() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : ('k'|'9'|'p') '$'\n  | ('a'..'z'|'0'..'9') '@'\n  ;\n");
        grammar.createLookaheadDFAs();
        String string = ".s0-{'0'..'8', 'a'..'j', 'l'..'o', 'q'..'z'}->:s2=>2\n.s0-{'9', 'k', 'p'}->.s1\n.s1-'$'->:s3=>1\n.s1-'@'->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void testDisjointSetCollidingWithTwoRangesAsSeparateAlts() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a'..'z' '@'\n  | 'k' '$'\n  | '9' '$'\n  | 'p' '$'\n  | '0'..'9' '@'\n  ;\n");
        grammar.createLookaheadDFAs();
        String string = ".s0-'0'..'8'->:s8=>5\n.s0-'9'->.s6\n.s0-'k'->.s1\n.s0-'p'->.s4\n.s0-{'a'..'j', 'l'..'o', 'q'..'z'}->:s3=>1\n.s1-'$'->:s2=>2\n.s1-'@'->:s3=>1\n.s4-'$'->:s5=>4\n.s4-'@'->:s3=>1\n.s6-'$'->:s7=>3\n.s6-'@'->:s8=>5\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void testKeywordVersusID() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nIF : 'if' ;\nID : ('a'..'z')+ ;\n");
        String string = ".s0-'a'..'z'->:s2=>1\n.s0-<EOT>->:s1=>2\n";
        this.checkDecision(grammar, 1, string, null);
        string = ".s0-'i'->.s1\n.s0-{'a'..'h', 'j'..'z'}->:s4=>2\n.s1-'f'->.s2\n.s1-<EOT>->:s4=>2\n.s2-'a'..'z'->:s4=>2\n.s2-<EOT>->:s3=>1\n";
        this.checkDecision(grammar, 2, string, null);
    }

    public void testIdenticalRules() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a' ;\nB : 'a' ;\n");
        String string = ".s0-'a'->.s1\n.s1-<EOT>->:s2=>1\n";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        this.checkDecision(grammar, 1, string, new int[]{2});
        TestCharDFAConversion.assertEquals((String)"unexpected number of expected problems", (int)1, (int)errorQueue.size());
        Message message = (Message)errorQueue.warnings.get(0);
        TestCharDFAConversion.assertTrue((String)"warning must be an unreachable alt", (boolean)(message instanceof GrammarUnreachableAltsMessage));
        GrammarUnreachableAltsMessage grammarUnreachableAltsMessage = (GrammarUnreachableAltsMessage)message;
        TestCharDFAConversion.assertEquals((String)"[2]", (String)grammarUnreachableAltsMessage.alts.toString());
    }

    public void testAdjacentNotCharLoops() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : (~'r')+ ;\nB : (~'s')+ ;\n");
        String string = ".s0-'r'->:s3=>2\n.s0-'s'->:s2=>1\n.s0-{'\\u0000'..'q', 't'..'\\uFFFE'}->.s1\n.s1-'r'->:s3=>2\n.s1-<EOT>->:s2=>1\n.s1-{'\\u0000'..'q', 't'..'\\uFFFE'}->.s1\n";
        this.checkDecision(grammar, 3, string, null);
    }

    public void testNonAdjacentNotCharLoops() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : (~'r')+ ;\nB : (~'t')+ ;\n");
        String string = ".s0-'r'->:s3=>2\n.s0-'t'->:s2=>1\n.s0-{'\\u0000'..'q', 's', 'u'..'\\uFFFE'}->.s1\n.s1-'r'->:s3=>2\n.s1-<EOT>->:s2=>1\n.s1-{'\\u0000'..'q', 's', 'u'..'\\uFFFE'}->.s1\n";
        this.checkDecision(grammar, 3, string, null);
    }

    public void testLoopsWithOptimizedOutExitBranches() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'x'* ~'x'+ ;\n");
        String string = ".s0-'x'->:s2=>1\n.s0-{'\\u0000'..'w', 'y'..'\\uFFFE'}->:s1=>2\n";
        this.checkDecision(grammar, 1, string, null);
        DFAOptimizer dFAOptimizer = new DFAOptimizer(grammar);
        dFAOptimizer.optimize();
        FASerializer fASerializer = new FASerializer(grammar);
        DFA dFA = grammar.getLookaheadDFA(1);
        String string2 = fASerializer.serialize(dFA.startState);
        string = ".s0-'x'->:s1=>1\n";
        TestCharDFAConversion.assertEquals((String)string, (String)string2);
    }

    public void testNonGreedy() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nCMT : '/*' ( options {greedy=false;} : . )* '*/' ;");
        String string = ".s0-'*'->.s1\n.s0-{'\\u0000'..')', '+'..'\\uFFFE'}->:s3=>1\n.s1-'/'->:s2=>2\n.s1-{'\\u0000'..'.', '0'..'\\uFFFE'}->:s3=>1\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void testNonGreedyWildcardStar() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nSLCMT : '//' ( options {greedy=false;} : . )* '\n' ;");
        String string = ".s0-'\\n'->:s1=>2\n.s0-{'\\u0000'..'\\t', '\\u000B'..'\\uFFFE'}->:s2=>1\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void testNonGreedyByDefaultWildcardStar() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nSLCMT : '//' .* '\n' ;");
        String string = ".s0-'\\n'->:s1=>2\n.s0-{'\\u0000'..'\\t', '\\u000B'..'\\uFFFE'}->:s2=>1\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void testNonGreedyWildcardPlus() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nSLCMT : '//' ( options {greedy=false;} : . )+ '\n' ;");
        String string = ".s0-'\\n'->:s1=>2\n.s0-{'\\u0000'..'\\t', '\\u000B'..'\\uFFFE'}->:s2=>1\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void testNonGreedyByDefaultWildcardPlus() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nSLCMT : '//' .+ '\n' ;");
        String string = ".s0-'\\n'->:s1=>2\n.s0-{'\\u0000'..'\\t', '\\u000B'..'\\uFFFE'}->:s2=>1\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void testNonGreedyByDefaultWildcardPlusWithParens() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nSLCMT : '//' (.)+ '\n' ;");
        String string = ".s0-'\\n'->:s1=>2\n.s0-{'\\u0000'..'\\t', '\\u000B'..'\\uFFFE'}->:s2=>1\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void testNonWildcardNonGreedy() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nDUH : (options {greedy=false;}:'x'|'y')* 'xy' ;");
        String string = ".s0-'x'->.s1\n.s0-'y'->:s4=>2\n.s1-'x'->:s3=>1\n.s1-'y'->:s2=>3\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void testNonWildcardEOTMakesItWorkWithoutNonGreedyOption() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nDUH : ('x'|'y')* 'xy' ;");
        String string = ".s0-'x'->.s1\n.s0-'y'->:s3=>1\n.s1-'x'->:s3=>1\n.s1-'y'->.s2\n.s2-'x'..'y'->:s3=>1\n.s2-<EOT>->:s4=>2\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void testAltConflictsWithLoopThenExit() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nSTRING : '\"' (options {greedy=false;}: '\\\\\"' | .)* '\"' ;\n");
        String string = ".s0-'\"'->:s1=>3\n.s0-'\\\\'->.s2\n.s0-{'\\u0000'..'!', '#'..'[', ']'..'\\uFFFE'}->:s4=>2\n.s2-'\"'->:s3=>1\n.s2-{'\\u0000'..'!', '#'..'\\uFFFE'}->:s4=>2\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void testNonGreedyLoopThatNeverLoops() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nDUH : (options {greedy=false;}:'x')+ ;");
        String string = ":s0=>2\n";
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        this.checkDecision(grammar, 1, string, new int[]{1});
        TestCharDFAConversion.assertEquals((String)"unexpected number of expected problems", (int)1, (int)errorQueue.size());
        Message message = (Message)errorQueue.warnings.get(0);
        TestCharDFAConversion.assertTrue((String)"warning must be an unreachable alt", (boolean)(message instanceof GrammarUnreachableAltsMessage));
        GrammarUnreachableAltsMessage grammarUnreachableAltsMessage = (GrammarUnreachableAltsMessage)message;
        TestCharDFAConversion.assertEquals((String)"[1]", (String)grammarUnreachableAltsMessage.alts.toString());
    }

    public void testRecursive() throws Exception {
        Grammar grammar = new Grammar("lexer grammar duh;\nSUBTEMPLATE\n        :       '{'\n                ( SUBTEMPLATE\n                | ESC\n                | ~('}'|'\\\\'|'{')\n                )*\n                '}'\n        ;\nfragment\nESC     :       '\\\\' . ;");
        grammar.createLookaheadDFAs();
        String string = ".s0-'\\\\'->:s3=>2\n.s0-'{'->:s2=>1\n.s0-'}'->:s1=>4\n.s0-{'\\u0000'..'[', ']'..'z', '|', '~'..'\\uFFFE'}->:s4=>3\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void testRecursive2() throws Exception {
        Grammar grammar = new Grammar("lexer grammar duh;\nSUBTEMPLATE\n        :       '{'\n                ( SUBTEMPLATE\n                | ESC\n                | ~('}'|'{')\n                )*\n                '}'\n        ;\nfragment\nESC     :       '\\\\' . ;");
        grammar.createLookaheadDFAs();
        String string = ".s0-'\\\\'->.s3\n.s0-'{'->:s2=>1\n.s0-'}'->:s1=>4\n.s0-{'\\u0000'..'[', ']'..'z', '|', '~'..'\\uFFFE'}->:s5=>3\n.s3-'\\\\'->:s8=>2\n.s3-'{'->:s7=>2\n.s3-'}'->.s4\n.s3-{'\\u0000'..'[', ']'..'z', '|', '~'..'\\uFFFE'}->:s6=>2\n.s4-'\\u0000'..'\\uFFFE'->:s6=>2\n.s4-<EOT>->:s5=>3\n";
        this.checkDecision(grammar, 1, string, null);
    }

    public void _template() throws Exception {
        Grammar grammar = new Grammar("grammar t;\na : A | B;");
        grammar.createLookaheadDFAs();
        String string = "\n";
        this.checkDecision(grammar, 1, string, null);
    }

    protected void checkDecision(Grammar grammar, int n, String string, int[] nArray) throws Exception {
        Object object;
        if (grammar.getCodeGenerator() == null) {
            object = new CodeGenerator(null, grammar, "Java");
            grammar.setCodeGenerator((CodeGenerator)object);
            grammar.createNFAs();
            grammar.createLookaheadDFAs();
        }
        object = grammar.getLookaheadDFA(n);
        TestCharDFAConversion.assertNotNull((String)("unknown decision #" + n), (Object)object);
        FASerializer fASerializer = new FASerializer(grammar);
        String string2 = fASerializer.serialize(((DFA)object).startState);
        List list = ((DFA)object).getUnreachableAlts();
        if (nArray == null) {
            TestCharDFAConversion.assertEquals((String)"unreachable alts mismatch", (int)0, (int)list.size());
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                TestCharDFAConversion.assertTrue((String)"unreachable alts mismatch", (boolean)list.contains(new Integer(nArray[i])));
            }
        }
        TestCharDFAConversion.assertEquals((String)string, (String)string2);
    }
}

