/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.ttrycatchblocklist;

import aterm.ATerm;
import aterm.ATermAppl;
import tom.library.adt.bytecode.types.TTryCatchBlock;
import tom.library.adt.bytecode.types.TTryCatchBlockList;
import tom.library.adt.bytecode.types.ttrycatchblocklist.ConsTryCatchBlockList;
import tom.library.adt.bytecode.types.ttrycatchblocklist.EmptyTryCatchBlockList;

public abstract class TryCatchBlockList
extends TTryCatchBlockList {
    public int length() {
        if (this instanceof ConsTryCatchBlockList) {
            TTryCatchBlockList tl = ((ConsTryCatchBlockList)this).getTailTryCatchBlockList();
            if (tl instanceof TryCatchBlockList) {
                return 1 + ((TryCatchBlockList)tl).length();
            }
            return 2;
        }
        return 0;
    }

    public TTryCatchBlock[] toArray() {
        TTryCatchBlock[] array;
        if (this instanceof ConsTryCatchBlockList) {
            TTryCatchBlock h = ((ConsTryCatchBlockList)this).getHeadTryCatchBlockList();
            TTryCatchBlockList tl = ((ConsTryCatchBlockList)this).getTailTryCatchBlockList();
            if (tl instanceof TryCatchBlockList) {
                TTryCatchBlock[] tailArray = ((TryCatchBlockList)tl).toArray();
                array = new TTryCatchBlock[1 + tailArray.length];
                array[0] = h;
                for (int i = 0; i < tailArray.length; ++i) {
                    array[i + 1] = tailArray[i];
                }
            } else {
                array = new TTryCatchBlock[]{h};
            }
        } else {
            array = new TTryCatchBlock[]{};
        }
        return array;
    }

    public static TTryCatchBlockList fromArray(TTryCatchBlock[] array) {
        TryCatchBlockList res = EmptyTryCatchBlockList.make();
        int i = array.length;
        while (i > 0) {
            res = ConsTryCatchBlockList.make(array[--i], res);
        }
        return res;
    }

    public TTryCatchBlockList reverse() {
        if (this instanceof ConsTryCatchBlockList) {
            TTryCatchBlockList cur = this;
            TryCatchBlockList rev = EmptyTryCatchBlockList.make();
            while (cur instanceof ConsTryCatchBlockList) {
                rev = ConsTryCatchBlockList.make(((ConsTryCatchBlockList)cur).getHeadTryCatchBlockList(), rev);
                cur = ((ConsTryCatchBlockList)cur).getTailTryCatchBlockList();
            }
            return rev;
        }
        return this;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("TryCatchBlockList(");
        if (this instanceof ConsTryCatchBlockList) {
            TTryCatchBlockList cur = this;
            while (cur instanceof ConsTryCatchBlockList) {
                TTryCatchBlock elem = ((ConsTryCatchBlockList)cur).getHeadTryCatchBlockList();
                cur = ((ConsTryCatchBlockList)cur).getTailTryCatchBlockList();
                elem.toStringBuffer(buffer);
                if (!(cur instanceof ConsTryCatchBlockList)) continue;
                buffer.append(",");
            }
            if (!(cur instanceof EmptyTryCatchBlockList)) {
                buffer.append(",");
                cur.toStringBuffer(buffer);
            }
        }
        buffer.append(")");
    }

    public static TTryCatchBlockList fromTerm(ATerm trm) {
        ATermAppl appl;
        if (trm instanceof ATermAppl && "TryCatchBlockList".equals((appl = (ATermAppl)trm).getName())) {
            TryCatchBlockList res = EmptyTryCatchBlockList.make();
            ATerm[] array = appl.getArgumentArray();
            for (int i = array.length - 1; i >= 0; --i) {
                TTryCatchBlock elem = TTryCatchBlock.fromTerm(array[i]);
                res = ConsTryCatchBlockList.make(elem, res);
            }
            return res;
        }
        return null;
    }
}

