/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.touterclassinfo;

import aterm.ATerm;
import aterm.ATermAppl;
import shared.HashFunctions;
import shared.SharedObject;
import tom.library.adt.bytecode.BytecodeAbstractType;
import tom.library.adt.bytecode.types.TMethodDescriptor;
import tom.library.adt.bytecode.types.TOuterClassInfo;
import tom.library.sl.Visitable;

public final class OuterClassInfo
extends TOuterClassInfo
implements Visitable {
    private int hashCode;
    private static OuterClassInfo proto = new OuterClassInfo();
    private String _owner;
    private String _name;
    private TMethodDescriptor _desc;

    private OuterClassInfo() {
    }

    public static OuterClassInfo make(String _owner, String _name, TMethodDescriptor _desc) {
        proto.initHashCode(_owner, _name, _desc);
        return (OuterClassInfo)factory.build((SharedObject)proto);
    }

    private void init(String _owner, String _name, TMethodDescriptor _desc, int hashCode) {
        this._owner = _owner.intern();
        this._name = _name.intern();
        this._desc = _desc;
        this.hashCode = hashCode;
    }

    private void initHashCode(String _owner, String _name, TMethodDescriptor _desc) {
        this._owner = _owner.intern();
        this._name = _name.intern();
        this._desc = _desc;
        this.hashCode = this.hashFunction();
    }

    public String symbolName() {
        return "OuterClassInfo";
    }

    private int getArity() {
        return 3;
    }

    public SharedObject duplicate() {
        OuterClassInfo clone = new OuterClassInfo();
        clone.init(this._owner, this._name, this._desc, this.hashCode);
        return clone;
    }

    public void toStringBuffer(StringBuffer buffer) {
        char c;
        int i;
        buffer.append("OuterClassInfo(");
        buffer.append('\"');
        block22: for (i = 0; i < this._owner.length(); ++i) {
            c = this._owner.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block22;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block22;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block22;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block22;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block22;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block22;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block22;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block22;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block22;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block22;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        buffer.append('\"');
        block23: for (i = 0; i < this._name.length(); ++i) {
            c = this._name.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block23;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block23;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block23;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block23;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block23;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block23;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block23;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block23;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block23;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block23;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        this._desc.toStringBuffer(buffer);
        buffer.append(")");
    }

    public int compareToLPO(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        OuterClassInfo tco = (OuterClassInfo)ao;
        int _ownerCmp = this._owner.compareTo(tco._owner);
        if (_ownerCmp != 0) {
            return _ownerCmp;
        }
        int _nameCmp = this._name.compareTo(tco._name);
        if (_nameCmp != 0) {
            return _nameCmp;
        }
        int _descCmp = this._desc.compareToLPO(tco._desc);
        if (_descCmp != 0) {
            return _descCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public int compareTo(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        if (this.hashCode != ao.hashCode()) {
            return this.hashCode < ao.hashCode() ? -1 : 1;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        OuterClassInfo tco = (OuterClassInfo)ao;
        int _ownerCmp = this._owner.compareTo(tco._owner);
        if (_ownerCmp != 0) {
            return _ownerCmp;
        }
        int _nameCmp = this._name.compareTo(tco._name);
        if (_nameCmp != 0) {
            return _nameCmp;
        }
        int _descCmp = this._desc.compareTo(tco._desc);
        if (_descCmp != 0) {
            return _descCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equivalent(SharedObject obj) {
        if (obj instanceof OuterClassInfo) {
            OuterClassInfo peer = (OuterClassInfo)obj;
            return this._owner == peer._owner && this._name == peer._name && this._desc == peer._desc;
        }
        return false;
    }

    public boolean isOuterClassInfo() {
        return true;
    }

    public String getowner() {
        return this._owner;
    }

    public TOuterClassInfo setowner(String set_arg) {
        return OuterClassInfo.make(set_arg, this._name, this._desc);
    }

    public String getname() {
        return this._name;
    }

    public TOuterClassInfo setname(String set_arg) {
        return OuterClassInfo.make(this._owner, set_arg, this._desc);
    }

    public TMethodDescriptor getdesc() {
        return this._desc;
    }

    public TOuterClassInfo setdesc(TMethodDescriptor set_arg) {
        return OuterClassInfo.make(this._owner, this._name, set_arg);
    }

    public ATerm toATerm() {
        return atermFactory.makeAppl(atermFactory.makeAFun(this.symbolName(), this.getArity(), false), new ATerm[]{atermFactory.makeAppl(atermFactory.makeAFun(this.getowner(), 0, true)), atermFactory.makeAppl(atermFactory.makeAFun(this.getname(), 0, true)), this.getdesc().toATerm()});
    }

    public static TOuterClassInfo fromTerm(ATerm trm) {
        if (trm instanceof ATermAppl) {
            ATermAppl appl = (ATermAppl)trm;
            if (proto.symbolName().equals(appl.getName())) {
                return OuterClassInfo.make(((ATermAppl)appl.getArgument(0)).getAFun().getName(), ((ATermAppl)appl.getArgument(1)).getAFun().getName(), TMethodDescriptor.fromTerm(appl.getArgument(2)));
            }
        }
        return null;
    }

    public int getChildCount() {
        return 1;
    }

    public Visitable getChildAt(int index) {
        switch (index) {
            case 0: {
                return this._desc;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildAt(int index, Visitable v) {
        switch (index) {
            case 0: {
                return OuterClassInfo.make(this.getowner(), this.getname(), (TMethodDescriptor)v);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildren(Visitable[] childs) {
        if (childs.length == 1) {
            return OuterClassInfo.make(this.getowner(), this.getname(), (TMethodDescriptor)childs[0]);
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable[] getChildren() {
        return new Visitable[]{this._desc};
    }

    protected int hashFunction() {
        int a = -1640531527;
        int b = 164536832;
        int c = this.getArity();
        a += HashFunctions.stringHashFunction((String)this._owner, (int)2) << 16;
        a += HashFunctions.stringHashFunction((String)this._name, (int)1) << 8;
        a += this._desc.hashCode();
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

