/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.tfieldlist;

import aterm.ATerm;
import aterm.ATermAppl;
import tom.library.adt.bytecode.types.TField;
import tom.library.adt.bytecode.types.TFieldList;
import tom.library.adt.bytecode.types.tfieldlist.ConsFieldList;
import tom.library.adt.bytecode.types.tfieldlist.EmptyFieldList;

public abstract class FieldList
extends TFieldList {
    public int length() {
        if (this instanceof ConsFieldList) {
            TFieldList tl = ((ConsFieldList)this).getTailFieldList();
            if (tl instanceof FieldList) {
                return 1 + ((FieldList)tl).length();
            }
            return 2;
        }
        return 0;
    }

    public TField[] toArray() {
        TField[] array;
        if (this instanceof ConsFieldList) {
            TField h = ((ConsFieldList)this).getHeadFieldList();
            TFieldList tl = ((ConsFieldList)this).getTailFieldList();
            if (tl instanceof FieldList) {
                TField[] tailArray = ((FieldList)tl).toArray();
                array = new TField[1 + tailArray.length];
                array[0] = h;
                for (int i = 0; i < tailArray.length; ++i) {
                    array[i + 1] = tailArray[i];
                }
            } else {
                array = new TField[]{h};
            }
        } else {
            array = new TField[]{};
        }
        return array;
    }

    public static TFieldList fromArray(TField[] array) {
        FieldList res = EmptyFieldList.make();
        int i = array.length;
        while (i > 0) {
            res = ConsFieldList.make(array[--i], res);
        }
        return res;
    }

    public TFieldList reverse() {
        if (this instanceof ConsFieldList) {
            TFieldList cur = this;
            FieldList rev = EmptyFieldList.make();
            while (cur instanceof ConsFieldList) {
                rev = ConsFieldList.make(((ConsFieldList)cur).getHeadFieldList(), rev);
                cur = ((ConsFieldList)cur).getTailFieldList();
            }
            return rev;
        }
        return this;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("FieldList(");
        if (this instanceof ConsFieldList) {
            TFieldList cur = this;
            while (cur instanceof ConsFieldList) {
                TField elem = ((ConsFieldList)cur).getHeadFieldList();
                cur = ((ConsFieldList)cur).getTailFieldList();
                elem.toStringBuffer(buffer);
                if (!(cur instanceof ConsFieldList)) continue;
                buffer.append(",");
            }
            if (!(cur instanceof EmptyFieldList)) {
                buffer.append(",");
                cur.toStringBuffer(buffer);
            }
        }
        buffer.append(")");
    }

    public static TFieldList fromTerm(ATerm trm) {
        ATermAppl appl;
        if (trm instanceof ATermAppl && "FieldList".equals((appl = (ATermAppl)trm).getName())) {
            FieldList res = EmptyFieldList.make();
            ATerm[] array = appl.getArgumentArray();
            for (int i = array.length - 1; i >= 0; --i) {
                TField elem = TField.fromTerm(array[i]);
                res = ConsFieldList.make(elem, res);
            }
            return res;
        }
        return null;
    }
}

