/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.tclassinfo;

import aterm.ATerm;
import aterm.ATermAppl;
import shared.HashFunctions;
import shared.SharedObject;
import tom.library.adt.bytecode.BytecodeAbstractType;
import tom.library.adt.bytecode.types.TAccessList;
import tom.library.adt.bytecode.types.TClassInfo;
import tom.library.adt.bytecode.types.TInnerClassInfoList;
import tom.library.adt.bytecode.types.TOuterClassInfo;
import tom.library.adt.bytecode.types.TSignature;
import tom.library.adt.bytecode.types.TStringList;
import tom.library.sl.Visitable;

public final class ClassInfo
extends TClassInfo
implements Visitable {
    private int hashCode;
    private static ClassInfo proto = new ClassInfo();
    private String _name;
    private TSignature _signature;
    private TAccessList _access;
    private String _superName;
    private TStringList _interfaces;
    private TInnerClassInfoList _innerClasses;
    private TOuterClassInfo _outerClass;

    private ClassInfo() {
    }

    public static ClassInfo make(String _name, TSignature _signature, TAccessList _access, String _superName, TStringList _interfaces, TInnerClassInfoList _innerClasses, TOuterClassInfo _outerClass) {
        proto.initHashCode(_name, _signature, _access, _superName, _interfaces, _innerClasses, _outerClass);
        return (ClassInfo)factory.build((SharedObject)proto);
    }

    private void init(String _name, TSignature _signature, TAccessList _access, String _superName, TStringList _interfaces, TInnerClassInfoList _innerClasses, TOuterClassInfo _outerClass, int hashCode) {
        this._name = _name.intern();
        this._signature = _signature;
        this._access = _access;
        this._superName = _superName.intern();
        this._interfaces = _interfaces;
        this._innerClasses = _innerClasses;
        this._outerClass = _outerClass;
        this.hashCode = hashCode;
    }

    private void initHashCode(String _name, TSignature _signature, TAccessList _access, String _superName, TStringList _interfaces, TInnerClassInfoList _innerClasses, TOuterClassInfo _outerClass) {
        this._name = _name.intern();
        this._signature = _signature;
        this._access = _access;
        this._superName = _superName.intern();
        this._interfaces = _interfaces;
        this._innerClasses = _innerClasses;
        this._outerClass = _outerClass;
        this.hashCode = this.hashFunction();
    }

    public String symbolName() {
        return "ClassInfo";
    }

    private int getArity() {
        return 7;
    }

    public SharedObject duplicate() {
        ClassInfo clone = new ClassInfo();
        clone.init(this._name, this._signature, this._access, this._superName, this._interfaces, this._innerClasses, this._outerClass, this.hashCode);
        return clone;
    }

    public void toStringBuffer(StringBuffer buffer) {
        char c;
        int i;
        buffer.append("ClassInfo(");
        buffer.append('\"');
        block22: for (i = 0; i < this._name.length(); ++i) {
            c = this._name.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block22;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block22;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block22;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block22;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block22;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block22;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block22;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block22;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block22;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block22;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        this._signature.toStringBuffer(buffer);
        buffer.append(",");
        this._access.toStringBuffer(buffer);
        buffer.append(",");
        buffer.append('\"');
        block23: for (i = 0; i < this._superName.length(); ++i) {
            c = this._superName.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block23;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block23;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block23;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block23;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block23;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block23;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block23;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block23;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block23;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block23;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        this._interfaces.toStringBuffer(buffer);
        buffer.append(",");
        this._innerClasses.toStringBuffer(buffer);
        buffer.append(",");
        this._outerClass.toStringBuffer(buffer);
        buffer.append(")");
    }

    public int compareToLPO(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        ClassInfo tco = (ClassInfo)ao;
        int _nameCmp = this._name.compareTo(tco._name);
        if (_nameCmp != 0) {
            return _nameCmp;
        }
        int _signatureCmp = this._signature.compareToLPO(tco._signature);
        if (_signatureCmp != 0) {
            return _signatureCmp;
        }
        int _accessCmp = this._access.compareToLPO(tco._access);
        if (_accessCmp != 0) {
            return _accessCmp;
        }
        int _superNameCmp = this._superName.compareTo(tco._superName);
        if (_superNameCmp != 0) {
            return _superNameCmp;
        }
        int _interfacesCmp = this._interfaces.compareToLPO(tco._interfaces);
        if (_interfacesCmp != 0) {
            return _interfacesCmp;
        }
        int _innerClassesCmp = this._innerClasses.compareToLPO(tco._innerClasses);
        if (_innerClassesCmp != 0) {
            return _innerClassesCmp;
        }
        int _outerClassCmp = this._outerClass.compareToLPO(tco._outerClass);
        if (_outerClassCmp != 0) {
            return _outerClassCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public int compareTo(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        if (this.hashCode != ao.hashCode()) {
            return this.hashCode < ao.hashCode() ? -1 : 1;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        ClassInfo tco = (ClassInfo)ao;
        int _nameCmp = this._name.compareTo(tco._name);
        if (_nameCmp != 0) {
            return _nameCmp;
        }
        int _signatureCmp = this._signature.compareTo(tco._signature);
        if (_signatureCmp != 0) {
            return _signatureCmp;
        }
        int _accessCmp = this._access.compareTo(tco._access);
        if (_accessCmp != 0) {
            return _accessCmp;
        }
        int _superNameCmp = this._superName.compareTo(tco._superName);
        if (_superNameCmp != 0) {
            return _superNameCmp;
        }
        int _interfacesCmp = this._interfaces.compareTo(tco._interfaces);
        if (_interfacesCmp != 0) {
            return _interfacesCmp;
        }
        int _innerClassesCmp = this._innerClasses.compareTo(tco._innerClasses);
        if (_innerClassesCmp != 0) {
            return _innerClassesCmp;
        }
        int _outerClassCmp = this._outerClass.compareTo(tco._outerClass);
        if (_outerClassCmp != 0) {
            return _outerClassCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equivalent(SharedObject obj) {
        if (obj instanceof ClassInfo) {
            ClassInfo peer = (ClassInfo)obj;
            return this._name == peer._name && this._signature == peer._signature && this._access == peer._access && this._superName == peer._superName && this._interfaces == peer._interfaces && this._innerClasses == peer._innerClasses && this._outerClass == peer._outerClass;
        }
        return false;
    }

    public boolean isClassInfo() {
        return true;
    }

    public String getname() {
        return this._name;
    }

    public TClassInfo setname(String set_arg) {
        return ClassInfo.make(set_arg, this._signature, this._access, this._superName, this._interfaces, this._innerClasses, this._outerClass);
    }

    public TSignature getsignature() {
        return this._signature;
    }

    public TClassInfo setsignature(TSignature set_arg) {
        return ClassInfo.make(this._name, set_arg, this._access, this._superName, this._interfaces, this._innerClasses, this._outerClass);
    }

    public TAccessList getaccess() {
        return this._access;
    }

    public TClassInfo setaccess(TAccessList set_arg) {
        return ClassInfo.make(this._name, this._signature, set_arg, this._superName, this._interfaces, this._innerClasses, this._outerClass);
    }

    public String getsuperName() {
        return this._superName;
    }

    public TClassInfo setsuperName(String set_arg) {
        return ClassInfo.make(this._name, this._signature, this._access, set_arg, this._interfaces, this._innerClasses, this._outerClass);
    }

    public TStringList getinterfaces() {
        return this._interfaces;
    }

    public TClassInfo setinterfaces(TStringList set_arg) {
        return ClassInfo.make(this._name, this._signature, this._access, this._superName, set_arg, this._innerClasses, this._outerClass);
    }

    public TInnerClassInfoList getinnerClasses() {
        return this._innerClasses;
    }

    public TClassInfo setinnerClasses(TInnerClassInfoList set_arg) {
        return ClassInfo.make(this._name, this._signature, this._access, this._superName, this._interfaces, set_arg, this._outerClass);
    }

    public TOuterClassInfo getouterClass() {
        return this._outerClass;
    }

    public TClassInfo setouterClass(TOuterClassInfo set_arg) {
        return ClassInfo.make(this._name, this._signature, this._access, this._superName, this._interfaces, this._innerClasses, set_arg);
    }

    public ATerm toATerm() {
        return atermFactory.makeAppl(atermFactory.makeAFun(this.symbolName(), this.getArity(), false), new ATerm[]{atermFactory.makeAppl(atermFactory.makeAFun(this.getname(), 0, true)), this.getsignature().toATerm(), this.getaccess().toATerm(), atermFactory.makeAppl(atermFactory.makeAFun(this.getsuperName(), 0, true)), this.getinterfaces().toATerm(), this.getinnerClasses().toATerm(), this.getouterClass().toATerm()});
    }

    public static TClassInfo fromTerm(ATerm trm) {
        if (trm instanceof ATermAppl) {
            ATermAppl appl = (ATermAppl)trm;
            if (proto.symbolName().equals(appl.getName())) {
                return ClassInfo.make(((ATermAppl)appl.getArgument(0)).getAFun().getName(), TSignature.fromTerm(appl.getArgument(1)), TAccessList.fromTerm(appl.getArgument(2)), ((ATermAppl)appl.getArgument(3)).getAFun().getName(), TStringList.fromTerm(appl.getArgument(4)), TInnerClassInfoList.fromTerm(appl.getArgument(5)), TOuterClassInfo.fromTerm(appl.getArgument(6)));
            }
        }
        return null;
    }

    public int getChildCount() {
        return 5;
    }

    public Visitable getChildAt(int index) {
        switch (index) {
            case 0: {
                return this._signature;
            }
            case 1: {
                return this._access;
            }
            case 2: {
                return this._interfaces;
            }
            case 3: {
                return this._innerClasses;
            }
            case 4: {
                return this._outerClass;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildAt(int index, Visitable v) {
        switch (index) {
            case 0: {
                return ClassInfo.make(this.getname(), (TSignature)v, this._access, this.getsuperName(), this._interfaces, this._innerClasses, this._outerClass);
            }
            case 1: {
                return ClassInfo.make(this.getname(), this._signature, (TAccessList)v, this.getsuperName(), this._interfaces, this._innerClasses, this._outerClass);
            }
            case 2: {
                return ClassInfo.make(this.getname(), this._signature, this._access, this.getsuperName(), (TStringList)v, this._innerClasses, this._outerClass);
            }
            case 3: {
                return ClassInfo.make(this.getname(), this._signature, this._access, this.getsuperName(), this._interfaces, (TInnerClassInfoList)v, this._outerClass);
            }
            case 4: {
                return ClassInfo.make(this.getname(), this._signature, this._access, this.getsuperName(), this._interfaces, this._innerClasses, (TOuterClassInfo)v);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildren(Visitable[] childs) {
        if (childs.length == 5) {
            return ClassInfo.make(this.getname(), (TSignature)childs[0], (TAccessList)childs[1], this.getsuperName(), (TStringList)childs[2], (TInnerClassInfoList)childs[3], (TOuterClassInfo)childs[4]);
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable[] getChildren() {
        return new Visitable[]{this._signature, this._access, this._interfaces, this._innerClasses, this._outerClass};
    }

    protected int hashFunction() {
        int a = -1640531527;
        int b = 665901824;
        int c = this.getArity();
        b += HashFunctions.stringHashFunction((String)this._name, (int)6) << 16;
        b += this._signature.hashCode() << 8;
        a += HashFunctions.stringHashFunction((String)this._superName, (int)3) << 24;
        a += this._interfaces.hashCode() << 16;
        a += this._innerClasses.hashCode() << 8;
        a += this._outerClass.hashCode();
        a -= (b += this._access.hashCode());
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

