/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.tclass;

import aterm.ATerm;
import aterm.ATermAppl;
import shared.SharedObject;
import tom.library.adt.bytecode.BytecodeAbstractType;
import tom.library.adt.bytecode.types.TClass;
import tom.library.adt.bytecode.types.TClassInfo;
import tom.library.adt.bytecode.types.TFieldList;
import tom.library.adt.bytecode.types.TMethodList;
import tom.library.sl.Visitable;

public final class Class
extends TClass
implements Visitable {
    private int hashCode;
    private static Class proto = new Class();
    private TClassInfo _info;
    private TFieldList _fields;
    private TMethodList _methods;

    private Class() {
    }

    public static Class make(TClassInfo _info, TFieldList _fields, TMethodList _methods) {
        proto.initHashCode(_info, _fields, _methods);
        return (Class)factory.build((SharedObject)proto);
    }

    private void init(TClassInfo _info, TFieldList _fields, TMethodList _methods, int hashCode) {
        this._info = _info;
        this._fields = _fields;
        this._methods = _methods;
        this.hashCode = hashCode;
    }

    private void initHashCode(TClassInfo _info, TFieldList _fields, TMethodList _methods) {
        this._info = _info;
        this._fields = _fields;
        this._methods = _methods;
        this.hashCode = this.hashFunction();
    }

    public String symbolName() {
        return "Class";
    }

    private int getArity() {
        return 3;
    }

    public SharedObject duplicate() {
        Class clone = new Class();
        clone.init(this._info, this._fields, this._methods, this.hashCode);
        return clone;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("Class(");
        this._info.toStringBuffer(buffer);
        buffer.append(",");
        this._fields.toStringBuffer(buffer);
        buffer.append(",");
        this._methods.toStringBuffer(buffer);
        buffer.append(")");
    }

    public int compareToLPO(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        Class tco = (Class)ao;
        int _infoCmp = this._info.compareToLPO(tco._info);
        if (_infoCmp != 0) {
            return _infoCmp;
        }
        int _fieldsCmp = this._fields.compareToLPO(tco._fields);
        if (_fieldsCmp != 0) {
            return _fieldsCmp;
        }
        int _methodsCmp = this._methods.compareToLPO(tco._methods);
        if (_methodsCmp != 0) {
            return _methodsCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public int compareTo(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        if (this.hashCode != ao.hashCode()) {
            return this.hashCode < ao.hashCode() ? -1 : 1;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        Class tco = (Class)ao;
        int _infoCmp = this._info.compareTo(tco._info);
        if (_infoCmp != 0) {
            return _infoCmp;
        }
        int _fieldsCmp = this._fields.compareTo(tco._fields);
        if (_fieldsCmp != 0) {
            return _fieldsCmp;
        }
        int _methodsCmp = this._methods.compareTo(tco._methods);
        if (_methodsCmp != 0) {
            return _methodsCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equivalent(SharedObject obj) {
        if (obj instanceof Class) {
            Class peer = (Class)obj;
            return this._info == peer._info && this._fields == peer._fields && this._methods == peer._methods;
        }
        return false;
    }

    public boolean isClass() {
        return true;
    }

    public TClassInfo getinfo() {
        return this._info;
    }

    public TClass setinfo(TClassInfo set_arg) {
        return Class.make(set_arg, this._fields, this._methods);
    }

    public TFieldList getfields() {
        return this._fields;
    }

    public TClass setfields(TFieldList set_arg) {
        return Class.make(this._info, set_arg, this._methods);
    }

    public TMethodList getmethods() {
        return this._methods;
    }

    public TClass setmethods(TMethodList set_arg) {
        return Class.make(this._info, this._fields, set_arg);
    }

    public ATerm toATerm() {
        return atermFactory.makeAppl(atermFactory.makeAFun(this.symbolName(), this.getArity(), false), new ATerm[]{this.getinfo().toATerm(), this.getfields().toATerm(), this.getmethods().toATerm()});
    }

    public static TClass fromTerm(ATerm trm) {
        if (trm instanceof ATermAppl) {
            ATermAppl appl = (ATermAppl)trm;
            if (proto.symbolName().equals(appl.getName())) {
                return Class.make(TClassInfo.fromTerm(appl.getArgument(0)), TFieldList.fromTerm(appl.getArgument(1)), TMethodList.fromTerm(appl.getArgument(2)));
            }
        }
        return null;
    }

    public int getChildCount() {
        return 3;
    }

    public Visitable getChildAt(int index) {
        switch (index) {
            case 0: {
                return this._info;
            }
            case 1: {
                return this._fields;
            }
            case 2: {
                return this._methods;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildAt(int index, Visitable v) {
        switch (index) {
            case 0: {
                return Class.make((TClassInfo)v, this._fields, this._methods);
            }
            case 1: {
                return Class.make(this._info, (TFieldList)v, this._methods);
            }
            case 2: {
                return Class.make(this._info, this._fields, (TMethodList)v);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildren(Visitable[] childs) {
        if (childs.length == 3) {
            return Class.make((TClassInfo)childs[0], (TFieldList)childs[1], (TMethodList)childs[2]);
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable[] getChildren() {
        return new Visitable[]{this._info, this._fields, this._methods};
    }

    protected int hashFunction() {
        int a = -1640531527;
        int b = 434347008;
        int c = this.getArity();
        a += this._info.hashCode() << 16;
        a += this._fields.hashCode() << 8;
        a += this._methods.hashCode();
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

