/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.taccesslist;

import aterm.ATerm;
import aterm.ATermAppl;
import tom.library.adt.bytecode.types.TAccess;
import tom.library.adt.bytecode.types.TAccessList;
import tom.library.adt.bytecode.types.taccesslist.ConsAccessList;
import tom.library.adt.bytecode.types.taccesslist.EmptyAccessList;

public abstract class AccessList
extends TAccessList {
    public int length() {
        if (this instanceof ConsAccessList) {
            TAccessList tl = ((ConsAccessList)this).getTailAccessList();
            if (tl instanceof AccessList) {
                return 1 + ((AccessList)tl).length();
            }
            return 2;
        }
        return 0;
    }

    public TAccess[] toArray() {
        TAccess[] array;
        if (this instanceof ConsAccessList) {
            TAccess h = ((ConsAccessList)this).getHeadAccessList();
            TAccessList tl = ((ConsAccessList)this).getTailAccessList();
            if (tl instanceof AccessList) {
                TAccess[] tailArray = ((AccessList)tl).toArray();
                array = new TAccess[1 + tailArray.length];
                array[0] = h;
                for (int i = 0; i < tailArray.length; ++i) {
                    array[i + 1] = tailArray[i];
                }
            } else {
                array = new TAccess[]{h};
            }
        } else {
            array = new TAccess[]{};
        }
        return array;
    }

    public static TAccessList fromArray(TAccess[] array) {
        AccessList res = EmptyAccessList.make();
        int i = array.length;
        while (i > 0) {
            res = ConsAccessList.make(array[--i], res);
        }
        return res;
    }

    public TAccessList reverse() {
        if (this instanceof ConsAccessList) {
            TAccessList cur = this;
            AccessList rev = EmptyAccessList.make();
            while (cur instanceof ConsAccessList) {
                rev = ConsAccessList.make(((ConsAccessList)cur).getHeadAccessList(), rev);
                cur = ((ConsAccessList)cur).getTailAccessList();
            }
            return rev;
        }
        return this;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("AccessList(");
        if (this instanceof ConsAccessList) {
            TAccessList cur = this;
            while (cur instanceof ConsAccessList) {
                TAccess elem = ((ConsAccessList)cur).getHeadAccessList();
                cur = ((ConsAccessList)cur).getTailAccessList();
                elem.toStringBuffer(buffer);
                if (!(cur instanceof ConsAccessList)) continue;
                buffer.append(",");
            }
            if (!(cur instanceof EmptyAccessList)) {
                buffer.append(",");
                cur.toStringBuffer(buffer);
            }
        }
        buffer.append(")");
    }

    public static TAccessList fromTerm(ATerm trm) {
        ATermAppl appl;
        if (trm instanceof ATermAppl && "AccessList".equals((appl = (ATermAppl)trm).getName())) {
            AccessList res = EmptyAccessList.make();
            ATerm[] array = appl.getArgumentArray();
            for (int i = array.length - 1; i >= 0; --i) {
                TAccess elem = TAccess.fromTerm(array[i]);
                res = ConsAccessList.make(elem, res);
            }
            return res;
        }
        return null;
    }
}

