/*
 * Decompiled with CFR 0.152.
 */
package tom.engine.adt.tomconstraint.types.constraint;

import aterm.ATerm;
import aterm.ATermAppl;
import tom.engine.adt.tomconstraint.types.Constraint;
import tom.engine.adt.tomconstraint.types.constraint.ConsOrConstraintDisjunction;
import tom.engine.adt.tomconstraint.types.constraint.EmptyOrConstraintDisjunction;

public abstract class OrConstraintDisjunction
extends Constraint {
    public int length() {
        if (this instanceof ConsOrConstraintDisjunction) {
            Constraint tl = ((ConsOrConstraintDisjunction)this).getTailOrConstraintDisjunction();
            if (tl instanceof OrConstraintDisjunction) {
                return 1 + ((OrConstraintDisjunction)tl).length();
            }
            return 2;
        }
        return 0;
    }

    public Constraint[] toArray() {
        Constraint[] array;
        if (this instanceof ConsOrConstraintDisjunction) {
            Constraint h = ((ConsOrConstraintDisjunction)this).getHeadOrConstraintDisjunction();
            Constraint tl = ((ConsOrConstraintDisjunction)this).getTailOrConstraintDisjunction();
            if (tl instanceof OrConstraintDisjunction) {
                Constraint[] tailArray = ((OrConstraintDisjunction)tl).toArray();
                array = new Constraint[1 + tailArray.length];
                array[0] = h;
                for (int i = 0; i < tailArray.length; ++i) {
                    array[i + 1] = tailArray[i];
                }
            } else {
                array = new Constraint[]{h};
            }
        } else {
            array = new Constraint[]{};
        }
        return array;
    }

    public static Constraint fromArray(Constraint[] array) {
        Constraint res = EmptyOrConstraintDisjunction.make();
        int i = array.length;
        while (i > 0) {
            res = ConsOrConstraintDisjunction.make(array[--i], res);
        }
        return res;
    }

    public Constraint reverse() {
        if (this instanceof ConsOrConstraintDisjunction) {
            Constraint cur = this;
            Constraint rev = EmptyOrConstraintDisjunction.make();
            while (cur instanceof ConsOrConstraintDisjunction) {
                rev = ConsOrConstraintDisjunction.make(((ConsOrConstraintDisjunction)cur).getHeadOrConstraintDisjunction(), rev);
                cur = ((ConsOrConstraintDisjunction)cur).getTailOrConstraintDisjunction();
            }
            return rev;
        }
        return this;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("OrConstraintDisjunction(");
        if (this instanceof ConsOrConstraintDisjunction) {
            Constraint cur = this;
            while (cur instanceof ConsOrConstraintDisjunction) {
                Constraint elem = ((ConsOrConstraintDisjunction)cur).getHeadOrConstraintDisjunction();
                cur = ((ConsOrConstraintDisjunction)cur).getTailOrConstraintDisjunction();
                elem.toStringBuffer(buffer);
                if (!(cur instanceof ConsOrConstraintDisjunction)) continue;
                buffer.append(",");
            }
            if (!(cur instanceof EmptyOrConstraintDisjunction)) {
                buffer.append(",");
                cur.toStringBuffer(buffer);
            }
        }
        buffer.append(")");
    }

    public static Constraint fromTerm(ATerm trm) {
        ATermAppl appl;
        if (trm instanceof ATermAppl && "OrConstraintDisjunction".equals((appl = (ATermAppl)trm).getName())) {
            Constraint res = EmptyOrConstraintDisjunction.make();
            ATerm[] array = appl.getArgumentArray();
            for (int i = array.length - 1; i >= 0; --i) {
                Constraint elem = Constraint.fromTerm(array[i]);
                res = ConsOrConstraintDisjunction.make(elem, res);
            }
            return res;
        }
        return null;
    }
}

