/*
 * Decompiled with CFR 0.152.
 */
package tom.engine.adt.tomconstraint.types.constraint;

import aterm.ATerm;
import aterm.ATermAppl;
import tom.engine.adt.tomconstraint.types.Constraint;
import tom.engine.adt.tomconstraint.types.constraint.ConsOrConstraint;
import tom.engine.adt.tomconstraint.types.constraint.EmptyOrConstraint;

public abstract class OrConstraint
extends Constraint {
    public int length() {
        if (this instanceof ConsOrConstraint) {
            Constraint tl = ((ConsOrConstraint)this).getTailOrConstraint();
            if (tl instanceof OrConstraint) {
                return 1 + ((OrConstraint)tl).length();
            }
            return 2;
        }
        return 0;
    }

    public Constraint[] toArray() {
        Constraint[] array;
        if (this instanceof ConsOrConstraint) {
            Constraint h = ((ConsOrConstraint)this).getHeadOrConstraint();
            Constraint tl = ((ConsOrConstraint)this).getTailOrConstraint();
            if (tl instanceof OrConstraint) {
                Constraint[] tailArray = ((OrConstraint)tl).toArray();
                array = new Constraint[1 + tailArray.length];
                array[0] = h;
                for (int i = 0; i < tailArray.length; ++i) {
                    array[i + 1] = tailArray[i];
                }
            } else {
                array = new Constraint[]{h};
            }
        } else {
            array = new Constraint[]{};
        }
        return array;
    }

    public static Constraint fromArray(Constraint[] array) {
        Constraint res = EmptyOrConstraint.make();
        int i = array.length;
        while (i > 0) {
            res = ConsOrConstraint.make(array[--i], res);
        }
        return res;
    }

    public Constraint reverse() {
        if (this instanceof ConsOrConstraint) {
            Constraint cur = this;
            Constraint rev = EmptyOrConstraint.make();
            while (cur instanceof ConsOrConstraint) {
                rev = ConsOrConstraint.make(((ConsOrConstraint)cur).getHeadOrConstraint(), rev);
                cur = ((ConsOrConstraint)cur).getTailOrConstraint();
            }
            return rev;
        }
        return this;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("OrConstraint(");
        if (this instanceof ConsOrConstraint) {
            Constraint cur = this;
            while (cur instanceof ConsOrConstraint) {
                Constraint elem = ((ConsOrConstraint)cur).getHeadOrConstraint();
                cur = ((ConsOrConstraint)cur).getTailOrConstraint();
                elem.toStringBuffer(buffer);
                if (!(cur instanceof ConsOrConstraint)) continue;
                buffer.append(",");
            }
            if (!(cur instanceof EmptyOrConstraint)) {
                buffer.append(",");
                cur.toStringBuffer(buffer);
            }
        }
        buffer.append(")");
    }

    public static Constraint fromTerm(ATerm trm) {
        ATermAppl appl;
        if (trm instanceof ATermAppl && "OrConstraint".equals((appl = (ATermAppl)trm).getName())) {
            Constraint res = EmptyOrConstraint.make();
            ATerm[] array = appl.getArgumentArray();
            for (int i = array.length - 1; i >= 0; --i) {
                Constraint elem = Constraint.fromTerm(array[i]);
                res = ConsOrConstraint.make(elem, res);
            }
            return res;
        }
        return null;
    }
}

