/*
 *  This file is part of timespan.
 *
 *  Timespan is the legal property of its authors.  Refer to the file
 *  AUTHORS in the top-level directory of the source distribution for
 *  details.
 *  
 *  Timespan is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Timespan is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with timespan; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "timespan.hpp"

void usage()
{ //display proper usage of the program

	//no need for multiple calls to cout when one will do
	cout << "\nUsage: " << progname
		<< " [Output Options] [Answer Options] [Operation]\n"
		<< "\nOutput Options:\n"
		<< "-H,  --help		 Show this message and exit\n"
		<< "-v,  --version	 Show version information and exit\n"
		<< "-ee, --nous		 Input and output dates in non-US format\n"
		<< "-ei, --nousin	  Input dates in non-US format\n"
		<< "-eo, --nousout	 Output dates in non-US format\n"
		<< "-l,  --long		 When outputting dates, use words for months\n"
		<< "-e,  --extraline  Output blank line at the end of each operation\n"
		<< "\nAnswer Options:\n"
		<< "-a,  --all		  Enable all Answer Options\n"
		<< "-t,  --date		 Resulting date (epoch and now Operations only)\n"
		<< "-d,  --days		 Resulting number of days\n"
		<< "-h,  --hours		Resulting number of hours\n"
		<< "-m,  --minutes	 Resulting number of minutes\n"
		<< "-s,  --seconds	 Resulting number of seconds\n"
		<< "\nOperations:\n"
		<< "epoch [+ # {days|hours|minutes|seconds}]\n"
		<< "	 Add # days, hours, minutes, or seconds to the epoch (defined\n"
		<< "	 as January 1, 1970 (1 January 1970)).  The date of the epoch\n"
		<< "	 is not counted in these calculations.  When no additional\n"
		<< "	 arguments are given, displays the epoch's date.  Requires\n"
		<< "	 either exactly zero arguments or exactly three arguments.\n"
		<< "now [{+|-} # {days|hours|minutes|seconds}]\n"
		<< "	 Add or subtract # days, hours, minutes, or seconds to/from\n"
		<< "	 today's date.  When no additional arguments are given, this\n"
		<< "	 displays today's date.  Requires exactly zero arguments or\n"
		<< "	 exactly three arguments.\n"
		<< "between [date 1] and [date 2]\n"
		<< "	 Determine the time between two specified dates.  Dates must\n"
		<< "	 be entered with spaces between their components.  See the\n"
		<< "	 included documentation for specific details.  Requires\n"
		<< "	 exactly three arguments for [date 1] and exactly three\n"
		<< "	 arguments for [date 2].\n"
		<< "\nThis help output is in no way comprehensive.  Refer to the\n"
		<< "included documentation for further details on usage, including\n"
		<< "examples detailing each operation.\n"
		<< endl;

	exit(0); //stop here and indicate successful exit
}

void version()
{ //show version
	
	//display version and author information
	cout << "timespan version " << PACKAGE_VERSION << "\n"
		<< "Originally written by Brandon McCombs, ported to C++ with code\n"
		<< "cleanup (indention and much-needed functions) by John Bailey\n\n"
		<< "timespan has undergone continuous improvements and is the legal\n"
		<< "property of its authors.  Refer to the file AUTHORS, distributed\n"
		<< "with the timespan source code, for further information.\n"
		<< "\ntimespan is free software distributed under the terms of the\n"
		<< "General Public License (GPL) version 2.  A copy of the GPL is\n"
		<< "included in the source distribution.\n\n"
		<< endl;

	exit(0); //stop here and indicate successful exit
}

