/*
 *  This file is part of timespan.
 *  
 *  Timespan is the legal property of its authors.  Refer to the file
 *  AUTHORS in the top-level directory of the source distribution for
 *  details.
 *  
 *  Timespan is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Timespan is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with timespan; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This file holds constants that are used everywhere else. */

//normal month names starting with capital letters
const char * const months[12] =
	{ "January", "February", "March", "April", "May", "June", "July",
		"August", "September", "October", "November", "December" };

//normal month names starting with lowercase letters
const char * const lmonths[12] =
	{ "january", "february", "march", "april", "may", "june", "july",
		"august", "september", "october", "november", "december" };

//abbreviations for month names starting with lowercase letters
const char * const lsmonths[12] =
	{ "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug",
		"sep", "oct", "nov", "dec" };

//days in months in a normal year
const unsigned int monthlength[12] =
				  { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
				  //Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec

//days in months in a leap year
const unsigned int monthlengthleap[12] =
				  { 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
				  //Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec

//constants needed for converting units--try to reduce "magic numbers"
const unsigned int hours_in_day = 24,
				 minutes_in_hour = 60,
				 minutes_in_day = minutes_in_hour * hours_in_day,
				 seconds_in_minute = 60,
				 seconds_in_hour = seconds_in_minute * minutes_in_hour,
				 seconds_in_day = seconds_in_hour * hours_in_day;

