<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only translates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release


// ### Note for translators about translation of text ending with punctuation
// ###
// ### The current list of concerned punctuation can be found in 'lib/init/tra.php'
// ### On 2009-03-02, it is: (':', '!', ';', '.', ',', '?')
// ### For clarity, we explain here only for colons: ':' but it is the same for the rest
// ###
// ### Short version: it is not a problem that string "Login:" has no translation. Only "Login" needs to be translated.
// ###
// ### Technical justification:
// ### If a string ending with colon needs translating (like "{tr}Login:{/tr}")
// ### then TikiWiki tries to translate 'Login' and ':' separately.
// ### This allows to have only one translation for "{tr}Login{/tr}" and "{tr}Login:{/tr}"
// ### and it still allows to translate ":" as "&nbsp;:" for languages that
// ### need it (like french)

$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"Links/Commands" => "連結/命令",
"Create a tag for the current wiki" => "為目前的 wiki 產生一個標籤",
"create tag" => "產生 tag",
"Restore the wiki" => "回復此 wiki",
"Anonymous users can edit pages" => "允許匿名使用者編輯頁面",
"Wiki_Tiki_Title" => "Wiki_Tiki_Title",
"Ranking" => "排名",
"Like pages" => "相似頁面",
"User versions" => "使用者版本",
"change" => "更改",
"assign" => "指定",
"save" => "儲存",
"TextFormattingRules" => "文字格式化原則",
"Emphasis" => "字型樣式",
"italics" => "斜體",
"both" => "粗斜體",
"References" => "參考",
"JoinCapitalizedWords" => "連在一起的大寫字",
"or use square brackets for an" => "或使用方括號表示",
"link_description" => "連結描述",
"make_headings" => "建立標題",
"Title_bar" => "標題列",
"img" => "img",
"printable" => "友善列印",
"remove page" => "移除頁面",
"unlock" => "解除鎖定",
"lock" => "鎖定",
"permissions" => "權限",
"history" => "歷程記錄",
"backlinks" => "反向連結",
"History of" => "歷程紀錄",
"Actual_version" => "實際版本",
"current_version" => "目前版本",
"all" => "全部",
"All pages" => "所有頁面",
"version" => "版本",
"Rollback_page" => "復原頁面",
"register" => "註冊",
"last_login" => "上次登入",
"delete" => "刪除",
"assign group" => "指定群組",
"Create or edit a gallery using this form" => "使用此表單產生或編輯一個圖庫",
"edit/create" => "編輯/產生",
"versions" => "版本",
"Current permissions for this page" => "本頁面權限設定",
"Perm" => "權限",
"No individual permissions global permissions to all pages apply" => "不採用個別頁面權限,套用全體權限至所有頁面",
"Assign permissions to thispage" => "指定此頁面的權限",
"last changes" => "最近變動",
"ranking" => "排名",
"list_pages" => "列出頁面",
"my galleries" => "我的圖庫",
"upload image" => "上傳影像",
"admin" => "管理者",
"groups" => "群組",
"cache" => "快取",
"upload" => "上傳",
"You can include the image in an HTML/Tiki page using" => "你可以將此影像包含在HTML/Tiki的頁面中使用",
"edit gallery" => "編輯圖庫",
"rebuild thumbnails" => "重建縮圖",
"list gallery" => "列出圖庫",
"return to gallery" => "返回圖庫",
"move" => "移動",
"You can include the image in an HTML or Tiki page using" => "你可以包含影像在HTML或Tiki頁面中使用",
"assign module" => "指定模組",
"left modules" => "左模組",
"right modules" => "右模組",
"clear cache" => "清除快取",
"order" => "順序",
"down" => "下",
"up" => "上",
"create/edit" => "建立/編輯",
"url" => "url",
"browse gallery" => "瀏覽圖庫",
"search" => "搜尋",
"modules" => "模組",
"links" => "連結",
"system gallery" => "系統圖庫",
"The passwords dont match" => "密碼錯誤",
"Anonymous users cannot edit pages" => "匿名使用者無法編輯頁面",
"Unexistant version" => "不存在版本",
"Unexistant user" => "不存在的使用者",
"Permission denied you cannot assign permissions for this page" => "權限不足, 你無法指定此頁面的權限",
"Permission denied you cannot browse this gallery" => "你沒有瀏覽這個圖庫的權限",
"view info" => "檢視資訊",
"reads" => "閱讀",
"HasImg" => "有影像",
"UseImg" => "使用影像",
"posts" => "佈告數",
"visits" => "瀏覽數",
"User preferences screen" => "使用者偏好畫面",
"create" => "建立",
"The SandBox is a page where you can practice your editing skills, use the preview feature\n\nto preview the appearance of the page, no versions are stored for this page." => "沙池是一個用來讓你練習編輯技巧的頁面, 使用預覽功能\n\n可以觀看頁面的外觀, 但是不會儲存任何版本變動.",
"HomePage" => "首頁",
"set" => "設定",
"Configure this page" => "設定本頁面",
"hotwords" => "熱門單字",
"list pages" => "列出頁面",
"user preferences" => "使用者偏好",
"You cannot edit this page because it is a user personal page" => "你無法編輯此頁面, 因為這是使用者個人頁面",
"cannot process upload" => "無法進行上傳",
"You have to provide a name to the image" => "你必須為此影像取個名字",
"No image uploaded" => "沒有上傳影像",
"The passwords didn't match" => "密碼不符",
"galleries" => "圖庫",
"images" => "影像",
"blog posts" => "blog 佈告",
"articles" => "文章",
"create new block" => "建立新區塊",
"Current version" => "目前版本",
"Next version" => "下一個版本",
"Programmed versions" => "計劃的版本",
"Old versions" => "舊版本",
"Edit desc" => "編輯描述",
"Index page" => "索引頁面",
"Set prefs" => "設定偏好",
"create zone" => "建立區域",
"save the banner" => "儲存大標題",
">Remove Zones (you lose entered info for the banner)" => ">移除區域 (會失去此標題的資訊)",
">Block description: " => ">區塊描述: ",
"Admin content" => "管理內容",
"go" => "衝",
"You do not have permission to write the template" => "權限不足, 你無法寫入模板",
"position" => "位置",
"files" => "檔案",
"Wiki comments settings" => "Wiki 評論設定",
"Warn on edit" => "編輯警告",
"Show comments" => "顯示評論",
"Hide comments" => "隱藏評論",
"post" => "發表",
"reply to this" => "回覆這篇",
"Comments below your current threshold" => "目前起算點以下的評論",
"Create or edit a file gallery using this form" => "使用此表單建立或編輯一個檔案庫",
"upload file" => "上傳檔案",
"Top Files" => "最熱門檔案",
"Unexistant link" => "不存在的連結",
"Cannot get file from URL" => "無法由URL取得檔案",
"Unexistant gallery" => "檔案庫不存在",
"You cant download files" => "你無法下傳檔案",
"No file" => "沒有檔案",
"Create/edit Forums" => "建立/編輯論壇",
"Moderator" => "板主",
"topics" => "主題",
"coms" => "coms",
"age" => "年齡",
"ppd" => "每日發表數",
"last post" => "最近發表佈告",
"perms" => "權限",
"Comm" => "Comm",
"Cms" => "Cms",
"Assign user" => "指定使用者",
"prev image" => "前一個影像",
"next image" => "下一個影像",
"There are inddividual permissions set for this gallery" => "此圖庫有獨立的權限設定",
" modified" => " 變更",
"permission" => "權限",
"Assign permissions to this page" => "指定權限給此頁面",
"Show Post Form" => "顯示發表表單",
"Hide Post Form" => "隱藏發表表單",
"smileys" => "表情符號",
"score" => "分數",
"author" => "作者",
"Simple box" => "簡單方塊",
"site" => "網站",
"path" => "路徑",
"send" => "發送",
"clear" => "清除",
"Edit received page" => "編輯收到的頁面",
"accept" => "接受",
"Edit or add category" => "編輯或增加分類",
"add" => "增加",
"sub categories" => "子類別",
"There are inddividual permissions set for this blog" => "這個 blog 有獨立的權限設定",
"Layout options" => "版面配置選項",
"polls" => "投票",
"features" => "功能",
"cms" => "cms",
"CMS settings" => "CMS設定",
"Poll settings" => "投票設定",
"image galleries" => "影像圖庫",
"Blog settings" => "Blog設定",
"general" => "一般",
"Set home forum" => "設定首頁論壇",
"file galleries" => "檔案總覽",
"rss" => "rss",
"Set feeds" => "設定 feeds",
"use poll" => "使用投票",
"use dynamic  content" => "使用動態內容",
"use rss module" => "使用 rss 模組",
"use banner zone" => "使用大標題區域",
"There are inddividual permissions set for this file gallery" => "這個檔案庫有獨立權限設定",
"half a second" => "半秒",
"refresh" => "更新",
"Create/edit RSS module" => "建立/編輯 RSS 模組",
"Create/edit Menus" => "建立/編輯 選單",
"options" => "選項",
"section" => "區段",
"back" => "返回",
"Admin chat" => "管理閒談",
"Permission denied you cant view this section" => "權限不足, 你無法觀看這個區段",
"File gals" => "檔案庫",
"Image gals" => "圖庫",
"Comparing versions" => "比較版本",
"Quicklinks" => "快速連結",
"use square brackets for an" => "使用方括號表示",
"Will display using the indicated HTML color" => "會使用指定的 HTML 色彩顯示",
"Will display the text centered" => "會置中顯示文字",
"add article" => "加入文章",
"deep" => "deep",
"Allowed HTML:" => "允許 HTML:",
"undo" => "回復",
"Remind passwords by email" => "用email提示密碼",
"FAQs settings" => "FAQs 設定",
"FAQ comments" => "FAQ 評論",
"Configure modules" => "設定模組",
"to insert a random tagline" => "插入隨機的tagline",
"Use (:name:) for smileys" => "使用 (:名稱:) 表示表情符號",
"Restoring a backup" => "回存一個備份",
"Warning!" => "警告!",
"Restoring a backup destoys all the data in your Tiki database.\n\nAll your tables will be replaced with the information in the backup." => "回存備份將會毀掉現有 Tiki 資料庫的全部資料.\n\n所有表格中的資料都會被備份中的資料取代",
"Click here to confirm restoring" => "點選這裡以確定回存",
"Create new backup" => "建立新備份",
"Creating backups may take a long time. If the process is not completed you will\n\nsee a blank screen. If so you need to increment the maximum script execution time\n\nfrom your php.ini file" => "建立備份可能花費許多時間。如果備份程序未完成，會出現空白\n\n頁面。你必須從 php.ini 中調整最大命令執行時間以避免發生此現象。\n\n",
"Click here to create a new backup" => "點選這裡以建立新備份",
"Upload a backup" => "上傳一個備份",
"Upload backup" => "上傳備份",
"Flash binary (.sqf or .dcr)" => "Flash 檔案(.sqf 或 .dcr)",
"Create/edit Faq" => "建立/增加 FAQ",
"questions" => "問題",
"new question" => "新問題",
"use" => "使用",
"FAQ Questions" => "FAQ 問題",
"FAQ Answers" => "FAQ 答案",
"print" => "列印",
">I forgot my password" => ">忘記密碼",
"send me my password" => "寄給我密碼",
"column" => "行",
"Show chart for the last " => "顯示排行榜於最近 ",
"days (0=all)" => "天 (0=全部)",
"dispay" => "dispay",
"user bookmarks" => "使用者書籤",
"stats" => "統計",
"Admin Cookies" => "管理 Cookies",
"No attachments for this page" => "此頁面無附檔",
"Entire site" => "整個網站",
"content templates" => "內容模板",
"shoutbox" => "shoutbox",
"drawings" => "繪圖",
"assigned" => "指定",
"edit image" => "編輯影像",
"Hotwords in new window" => "熱門字眼於新視窗中",
"Allow smileys" => "允許表情符號",
"use gallery" => "使用圖庫",
"use menu" => "使用選單",
"cancel edit" => "取消編輯",
"list quizzes" => "列出測驗",
"quiz stats" => "測驗統計",
"admin quizzes" => "管理測驗",
"results" => "結果",
"edit this quiz" => "編輯這個測驗",
"Reuse question" => "重覆使用問題",
"send answers" => "送出答案",
"clear stats" => "清除統計",
"time" => "時間",
"result" => "結果",
"suggested" => "建議",
"wiki link" => "wiki 連結",
"heading2" => "標題2",
"heading3" => "標題3",
"approve" => "核准",
"Show suggested questions/suggest a question" => "顯示建議的問題/建議一個問題",
"Hide suggested questions" => "隱藏建議的問題",
"Create/edit templates" => "建立/編輯模板",
"use in cms" => "使用於 cms",
"use in wiki" => "使用於 wiki",
"use in HTML pages" => "使用於 HTML 頁面",
"last modif" => "最近修改",
"sections" => "區段",
"use admin email" => "使用管理者電子郵件",
"event" => "事件",
"categorize" => "類別",
"show categories" => "顯示類別",
"underlines text" => "文字加底線",
"Create/edit HTML pages" => "建立/編輯 HTML 頁面",
"Admin HTML page dynamic zones" => "管理 HTML 頁面動態區域",
"Edit this HTML page" => "編輯此 HTML 頁面",
"searched" => "搜尋",
"last" => "最近",
"Quiz time limit excedeed quiz cannot be computed" => "測驗時間限制已超過,測驗不列入計算",
"You do not have permission to edit messages" => "你沒有編輯訊息的權限",
"feat" => "feat",
"Full Text Search" => "全文搜尋",
"Server name (for absolute URIs)" => "伺服器名稱 (絕對 URI 使用)",
"Server time zone" => "伺服器時區",
"Require HTTP Basic authentication" => "需要 HTTP 基本認證",
"HTTP server name" => "HTTP 伺服器名稱",
"HTTP URL prefix" => "HTTP URL 前置",
"HTTPS server name" => "HTTPS 伺服器名稱",
"HTTPS URL prefix" => "HTTPS URL 前置",
"Wiki Page Names" => "Wiki 頁面名稱",
"full" => "完整",
"strict" => "嚴謹",
"gral" => "gral",
"file gls" => "檔案總覽",
"trckrs" => "trckrs",
"frms" => "frms",
"img gls" => "img gls",
"webmail" => "webmail",
"Allow viwing HTML mails?" => "允許觀看 HTML 郵件?",
"use in newsletters" => "使用於電子報",
"list newsletters" => "列出電子報",
"admin newsletters" => "管理電子報",
"send newsletters" => "寄送電子報",
"Add all your site users to this newsletter (broadcast)" => "加入你所有的使用者至此電子報 (廣播)",
"Add users" => "增加使用者",
"Users can subscribe any email addresss" => "允許使用者以任何 email 訂閱",
"editions" => "版本",
"last sent" => "上次寄出",
"survey stats" => "調查結果",
"edit this survey" => "編輯這個調查",
"admin surveys" => "管理調查",
"list surveys" => "列出調查",
"Create/edit surveys" => "建立/編輯 調查",
"Options (separated by commas used in dropdowns only)" => "選項 (僅用於下拉選單, 使用逗號分開)",
"There are inddividual permissions set for this tracker" => "這個追蹤有獨立權限設定",
"Show status when listing tracker items?" => "當列出追蹤項目時顯示狀態?",
"items" => "項目",
"search category" => "搜尋類別",
"Prevents parsing data" => "防止分析資料",
"b" => "b",
"i" => "i",
"ul" => "ul",
"tbl" => "tbl",
"a" => "a",
"h1" => "h1",
"h2" => "h2",
"h3" => "h3",
"dcs" => "dcs",
"center" => "center",
"img nc" => "img nc",
"chars" => "chars",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appeareance of the page, no versions are stored for this page." => "沙池是一個用來讓你練習編輯技巧的頁面, 使用預覽功能可以觀看頁面的外觀, 但是不會儲存任何版本變動.",
"Import pages from a PHPWiki Dump" => "由 PHPWiki 傾印來匯入頁面",
"Path to where the dumped files are" => "傾印檔案的路徑",
"ver" => "版本",
"Thanks for your subscription. You will receive an email soon to confirm your subscription.\n\nNo newsletters will be sent to you until the subscription is confirmed." => "感謝你的訂閱. 你會收到一封信件以確認你的訂閱.\n\n在訂閱確認前不會收到電子報.",
"similar" => "相似",
"slides" => "幻燈片",
"export" => "匯出",
"cancel" => "取消",
"Average posts pero weblog" => "每 weblog 平均佈告數",
"view comments" => "觀看評論",
"checked" => "勾選的",
"unchecked" => "未勾選的",
"Editing tracker item" => "編輯追蹤項目",
"Mark as Flagged" => "設為已標記",
"ok" => "ok",
"add contacts" => "增加到通訊錄",
"Wiki Import dump" => "Wiki 匯入傾印",
"standard" => "標準",
"secure" => "安全",
"stay in ssl mode" => "保留在 ssl 模式",
"Bookmakrs" => "書籤",
"You cant use the same password again" => "你不能再次使用相同的密碼",
"You have to provide a name to the file" => "你必須為這個檔案取一個名稱",
"parent" => "parent",
"userfiles" => "使用者檔案",
"Only for users" => "僅用於使用者",
"Users and admins" => "使用者與管理者",
"Cache wiki pages" => "快取 wiki 頁面",
"Users can save pages to notepad" => "允許使用者儲存頁面至記事本",
"\n for rows" => "\n 表示一列",
"Forum settings" => "論壇設定",
"Allow wiki markup" => "允許 wiki 標記語言",
"Describe topics in listing" => "描述主題於列表",
"Allow viewing HTML mails" => "允許觀看 HTML 郵件",
"subs" => "subs",
"objs" => "objs",
"Admin content templates" => "管理內容模版",
"Edit drawings &amp; pictures" => "編輯繪圖和圖片",
"\n\n<b>Note 1</b>: if you allow your users to configure modules then assigned\n\nmodules won't be reflected in the screen until you configure them\n\nfrom MyTiki->modules.<br/>\n\n<b>Note 2</b>: If you assign modules to groups make sure that you\n\nhave turned off the option 'display modules to all groups always'\n\nfrom Admin->General\n\n" => "\n\n<b>注意事項 1</b>: 如果你允許使用者自行調整模組的設定, 設定的模組\n\n將不會反應到畫面上, 必須到 我的Tiki->模組 中設定.<br/>\n\n<b>注意事項 2</b>: 如果你指定模組至群組中, 請確定你有到 管理->一般選項 中把\n\n「所有的模組都顯示群組」選項給關閉",
"left" => "左",
"right" => "右",
"Edit/Create user module" => "編輯/建立 使用者模組",
"assign_perms" => "指定權限",
"update" => "更新",
"assgn" => "指定",
"List of available backups" => "列出現有的備份",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "回復備份會摧毀你所有tiki資料庫的資料, 全部的表格將會被備份中的資料所取代",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "建立新的備份需要蠻長的時間,如果你未執行完畢, 請增加你php.ini檔中最大執行時間的設定",
"view blog" => "觀看 blog",
"list blogs" => "列出 blogs",
"original size" => "原始大小",
"rotate left" => "向左旋轉",
"Klick to enlarge" => "點擊放大",
"smaller" => "縮小",
"bigger" => "放大",
"browse" => "瀏覽",
"related" => "相關",
"validate" => "確認",
"Add or edit a category" => "增加或編輯一個分類",
"list articles" => "列出文章",
"view articles" => "顯示文章",
"In parent page" => "在父頁面中",
"create page" => "建立頁面",
"list submissions" => "列出submission",
"Add scaled images size X x Y" => "增加影像尺度大小 X x Y",
"Path to where the dumped files are (relative to tiki basedir with trailing slash ex: dump/)" => "傾印檔案所在的路徑 (tiki目錄的相對路徑加上斜線 例如: dump/)",
"edit new article" => "編輯新文章",
"edit blog" => "編輯 blog",
"edit new submission" => "建立新的意見",
"rename" => "更名",
"Diff to version" => "Diff 至版本",
"source" => "來源",
"Assign permissions to page" => "指定權限到頁面",
"Send email notifications when this page changes to" => "頁面變動時寄出 email 提醒",
"add email" => "增加email",
"Notifications" => "提醒",
"wiki pages" => "wiki 頁面",
"display" => "顯示",
"use filename" => "使用檔案名稱",
"unassign" => "未指定",
"Use dbl click to edit pages" => "雙按滑鼠編輯頁面",
"replies" => "回答",
"All tasks" => "所有任務",
"mark as done" => "標記為已完成",
"open tasks" => "開啟任務",
"Add or edit a task" => "建立或編輯一個任務",
"add a site" => "增加一個站臺",
"Mailin accounts" => "Mailin 帳號",
"Return to messages" => "返回訊息列表",
"Unflagg" => "解除標記",
"Newss from" => "News 來自",
"Control by Object" => "由物件控制",
"Admin ephemerides" => "管理日曆",
"All ephemerides" => "所有日曆",
"Control by category" => "由分類控制",
"add topic" => "增加主題",
"topic" => "主題",
"Create/edit extwiki" => "建立/編輯 外部wiki",
"extwiki" => "外部wiki",
"dsn" => "dsn",
"Admin (click!)" => "管理 (點擊!)",
"new message" => "件新訊息",
"Mus enter a name to add a site" => "增加站臺時必須輸入名稱",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory" => "無法存取 URL, URL 錯誤或站臺不存在, 無法加入目錄",
"The user has choosen to make his information private" => "此用戶選擇保密個人資訊",
"Users can vote only one item from this chart per period" => "使用者每一單位時間只能從這個排行榜中票選一項",
"Prevent users from voting same item more than one time" => "防止使用者票選相同項目一次以上",
"You will receive an email with your password soon" => "你很快就會收到含有密碼的 email",
"Displays a snippet of code.\n\nSet optional paramater -+ln+- to 1 if you need line numbering feature." => "顯示一段程式碼.\n\n如果需要行號功能, 請設定選擇性參數 -+ln+- 為 1.",
"Renders a graph" => "產生圖",
"PluginsHelp" => "Plugins說明",
"Wiki quick help" => "Wiki 快速說明",
"create new empty structure" => "建立新的空結構",
"Create structure from tree" => "由樹系建立結構",
"tree" => "樹系",
"Admin structures" => "管理結構",
"Click twice if once is not enough !" => "如果一次不夠, 請點擊兩次!",
"Toggle display of comment zone" => "開關註解區域的顯示",
"In blog listing show user as" => "在 blog 列表中顯示使用者為",
"creation date" => "建立日期",
"last modification time" => "最後修改時間",
"Articles listing configuration" => "文章列表設定",
"Edit css" => "編輯 css",
"Use PHPOpenTracker" => "使用 PHPOpenTracker",
"User watches" => "自訂監視",
"LDAP Group Atribute" => "LDAP 群組屬性",
"PDF Export" => "輸出為 PDF",
"Wiki page list configuration" => "Wiki 頁面列表設定",
"Enable Feature" => "啟用功能",
"loc" => "位置",
"cat" => "類別",
"lang" => "語系",
"prio" => "重要性",
"edit chart" => "編輯排行榜",
"Edit drawings" => "編輯繪圖",
"Threads can be voted" => "討論串可投票",
"Forward messages to this forum to this email" => "轉發此論壇的訊息至此 email",
"flag" => "國旗",
"user level" => "使用者等級",
"online" => "線上",
"Directory (include trailing slash)" => "目錄 (包含結尾的/)",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "使用 {literal}{{/literal}ed id=name} 或 {literal}{{/literal}ted id=name}以加入動態區域",
"export pages" => "匯出頁面",
"dump tree" => "傾印樹系",
"stat" => "狀態",
"Added users" => "加入的使用者",
"ExtWikis" => "外部 Wiki",
"save and exit" => "儲存並離開",
"popup window" => "蹦現視窗",
"Calendars Panel" => "行事曆控制面板",
"Navigation Panel" => "導覽面板",
"Hide Panels" => "隱藏面板",
"hide from display" => "不顯示",
"Tiki Calendars" => "Tiki 行事曆",
"today" => "今日",
"+1d" => "+1天",
"+7d" => "+7天",
"+1m" => "+1月",
"browse by" => "瀏覽單位",
"If you change the calendar selection, please refresh to get the appropriated list in Category, Location and people (if applicable to the calendar you choose)." => "如果你更改了行事曆選項, 請重新整理以取得正確的類別, 地點, 以及人名列表(如果適用於你所選的行事曆類型)",
"or create a new category" => "或建立新類別",
"or create a new location" => "或建立新地點",
"comma separated usernames" => "以逗點分隔的用戶名稱",
"from the list" => "從列表",
"choose" => "選擇",
"comma separated username:role" => "以逗點分隔的 用戶名稱:角色",
"Chair" => "席位",
"Optional" => "非必須",
"with roles" => "附帶角色",
"You should first ask that a calendar is created, so you can create events attached to it." => "你必須在建立行事曆時先詢問, 以便建立要附加上去的事件",
"Textheight" => "文字高度",
"Height of top Heading" => "最上層標題大小",
"Height of mid Heading" => "中層標題大小",
"Height of inner Heading" => "內層標題大小",
"tbheight" => "表格大小",
"imagescale" => "影像比率",
"save a custom copy" => "另存自訂備份",
"try" => "測試",
"use ...page... to separate pages" => "使用 ...頁面... 分隔頁面",
"heading" => "標題",
"horizontal ruler" => "水平尺標",
"create new gallery" => "建立新圖庫",
"configure listing" => "設定列表",
"save and approve" => "儲存並核可",
"new topic" => "新主題",
"reject" => "駁回",
"adm" => "adm",
"switch" => "轉換",
"add new" => "新增加",
"add role" => "增加角色",
"new minor" => "new minor",
"new major" => "new major",
"Swicth construct" => "Swicth construct",
"admin processes" => "admin processes",
"admin activities" => "admin activities",
"admin roles" => "admin roles",
"edit this process" => "edit this process",
"monitor" => "monitor",
"act status" => "act status",
"running" => "running",
"Activs" => "Activs",
"Ins" => "Ins",
"stop" => "stop",
"send instance" => "send instance",
"create new blog" => "建立新 blog",
"Edit a file using this form" => "使用此表單編輯檔案",
"delete selected files" => "刪除選擇的檔案",
"set as operator" => "設為服務員",
"op" => "op",
"wiki create" => "wiki 建立",
"wiki overwrite" => "wiki 覆寫",
"discuss" => "討論",
"attachments" => "附件",
"create pdf" => "建立 pdf",
"monitor this page" => "監視此頁面",
"stop monitoring this page" => "停止監控此頁面",
"last modification" => "最後修改",
"click here" => "點擊此處",
"move to right column" => "移至右行",
"move to left column" => "移至左行",
"remove folder" => "移除資料夾",
"remove bookmark" => "移除書籤",
"refresh cache" => "重新整理快取",
"stop monitoring this blog" => "停止監控此 blog",
"edit items" => "編輯項目",
"list charts" => "列出排行榜",
"last chart" => "最末張排行榜",
"perm" => "權限",
"item" => "項目",
"Tiki forums" => "Tiki 論壇",
"monitor this forum" => "監控此論壇",
"stop monitoring this forum" => "停止監控此論壇",
"delete selected topics" => "刪除選擇的主題",
"mot" => "mot",
"stop monitoring this topic" => "停止監控此主題",
"send email to user" => "發送 email 至使用者",
"delete selected" => "刪除選擇項目",
"this post was reported" => "本文章已被回報",
"report this post" => "回報此文章",
"someone from" => "某人來自",
"requested a reminder of the password for the" => "要求寄送密碼提示",
"since this is your registered email address we inform that the" => "由於這是你的註冊 email 地址, 我們就寄送至此",
"password for this account is" => "此帳號的密碼是",
"If you want to be a registered user in this site you will have to use" => "如果你想成為本站的註冊使用者, 你必須使用",
"the following link to login for the first time" => "以下的連結來進行第一次登入",
"new messages" => "新訊息",
"More info about" => "更多資訊:",
"idle" => "發呆",
"MyTiki (click!)" => "我的Tiki (點擊!)",
"You do not have permission to use this feature." => "你沒有權限使用此功能.",
"blog_ranking_top_blogs" => "blog_ranking_top_blogs",
"blog_ranking_last_posts" => "blog_ranking_last_posts",
"blog_ranking_top_active_blogs" => "blog_ranking_top_active_blogs",
"filegal_ranking_top_galleries" => "filegal_ranking_top_galleries",
"filegal_ranking_top_files" => "filegal_ranking_top_files",
"filegal_ranking_last_files" => "filegal_ranking_last_files",
"gal_ranking_top_galleries" => "gal_ranking_top_galleries",
"gal_ranking_top_images" => "gal_ranking_top_images",
"gal_ranking_last_images" => "gal_ranking_last_images",
"updated by the phpwiki import process" => "由 phpwiki 匯入程序所更新",
"created from phpwiki import" => "由 phpwiki 匯入所建立",
"Wiki page" => "Wiki 頁面",
"Your Tiki account information for" => "你的 Tiki 帳號資訊",
"A password reminder email has been sent " => "已寄出密碼提示信件 ",
"A new password has been sent " => "新密碼已經寄出 ",
"Permission denied you cannot upload files" => "權限不足, 你無法上傳檔案",
"Cannot read file" => "無法讀取檔案",
" new topic:" => " 新主題:",
"topic:" => "主題:",
"forum topic" => "論壇主題",
"Your email address has been removed from the list of addresses monitoring this tracker" => "你的 email 地址已經從監控此追蹤的列表中移除",
"Your email address has been added to the list of addresses monitoring this tracker" => "你的 email 地址已經加入監控此追蹤的列表",
"Cancel monitoring" => "取消監控",
"Your email address has been removed from the list of addresses monitoring this item" => "你的 email 地址已經從監控此項目的列表中移除",
"Your email address has been added to the list of addresses monitoring this item" => "你的 email 地址已經加入監控此項目的列表",
"Current page:" => "目前頁面:",
"version %s" => "版本 %s",
"last modified on %s" => "最後修改於 %s",
"by %s" => "由 %s",
"Archived page:" => "儲存的頁面:",
"Diff of %s." => "%s 的差異.",
"no description" => "無描述",
" tags. Example: {tr}The newsletter was sent to {\$sent} email addresses" => " 標籤. 範例: {tr}本電子報寄送至 {\$sent} email 地址",
"New article submitted at " => "新文章發表於 ",
"uploaded by" => "上傳自",
"not specified" => "未指定",
"Welcome to " => "歡迎來到 ",
" at " => " 在 ",
"Bye bye from " => "Bye bye from ",
"There is an error in the plugin data" => "外掛模組資料發生錯誤",
"Posted comments" => "已發表評論",
"PHPOpenTracker" => "PHPOpenTracker",
"User can Configure Modules" => "允許使用者設定模組",
"Time Zone" => "時區",
"Time Zone Map" => "時區對應",
"Enable watch by default for author" => "作者預設啟動監視",
"Enable watches when I am the editor" => "當我是編輯者時啟動監視",
"create new" => "建立新的",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br/>\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>注意事項 1</b>: 如果你允許使用者自行調整模組的設定, 設定的模組\n將不會反應到畫面上, 必須到 我的Tiki->模組 中設定.<br/>\n<b>注意事項 2</b>: 如果你指定模組至群組中, 請確定你有到 管理->一般選項 中把\n「所有的模組都顯示群組」選項給關閉",
"Create New Survey:" => "建立新調查:",
"Add New Group" => "建立新群組",
"Edit this group:" => "編輯此群組:",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor" => "注意: 如果你要使用影像請先儲存文章之後\n才能編輯/發表影像。在文字區域中使用\n&lt;img&gt; 片段表示上傳的影像。或使\n用 WYSIWYG 編輯器插入影像 URL。 ",
"with role" => "以角色",
"wiki help" => "wiki 說明",
"add comment" => "增加評論",
"attach file" => "附加檔案",
"The cord" => "The cord",
"Change your email" => "更改你的 email",
"change email" => "更改 email",
"Information:" => "資訊:",
"New blog post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "新 blog 佈告: {\$mail_title} 由 {\$mail_user} 發表於 {\$mail_date|tiki_short_datetime}",
"You can edit the page following this link:" => "你可以使用此連結編輯頁面:",
"Diff:" => "差異:",
"The new page content is:" => "新的頁面內容:",
"cached" => "已快取",
"back to homepage" => "回到首頁",
"Please" => "請",
"log in" => "登入",
"to access full functionalities" => "以使用完整功能",
"xx" => "xx",
"xxx" => "xxx",
"pageviews" => "瀏覽數",
"Upload was not successful (maybe a duplicate file)" => "上傳不成功 (可能是檔案重複)",
"Invalid password.  You current password is required to change your email address." => "密碼錯誤. 請輸入正確的密碼才能更改你的 email 地址.",
"New message arrived from " => "收到新訊息: ",
"with checked" => "with checked",
"pdf" => "pdf",
"at tracker" => "at tracker",
"UTC" => "UTC",
"<b>Feed</b>" => "<b>Feed</b>",
"Feed for Articles" => "Feed for Articles",
"Feed for Weblogs" => "Feed for Weblogs",
"Feed for the Wiki" => "Feed for the Wiki",
"activate" => "activate",
"graph" => "graph",
"active process" => "active process",
"invalid" => "invalid",
"invalid process" => "invalid process",
"valid process" => "valid process",
"activities" => "activities",
"aborted" => "aborted",
"value" => "value",
"proc" => "proc",
"exceptions" => "exceptions",
"Com" => "Com",
"pre" => "pre",
"pop" => "pop",
"new image uploaded by" => "新影像上傳自",
"new subscriptions" => "新訂閱",
"new item in tracker" => "追蹤系統中有新項目",
"message" => "訊息",
"filter" => "過濾器",
"no such file" => "無此檔案",
"downloads" => "下傳數",
"attach" => "附檔",
"monitor this blog" => "監控此 blog",
"hide categories" => "隱藏類別",
"Admin categories" => "管理類別",
"reply" => "回覆",
"monitor this topic" => "監控此主題",
"Dls" => "下傳數",
"move selected files" => "移動選擇的檔案",
"Thank you for you registration. You may log in now." => "感謝你的註冊. 你現在可以登入了.",
"compare" => "比較",
"diff" => "比對差異",
"del" => "清除",
"Create pdf" => "建立 pdf",
"1 file attached" => "1 個附加檔案",
"categories" => "分類",
"check / uncheck all" => "全選/全取消",
"Tiki sections and features" => "Tiki 區段與功能",
"please read" => "請閱讀",
"yes" => "是",
"Local" => "本地",
"private" => "私人",
"<b>enable/disable</b>" => "<b>開啟/關閉</b>",
"<b>Max number of items</b>" => "<b>最大項目數</b>",
"Feed for Image Galleries" => "Feed for 影像圖庫",
"Feed for File Galleries" => "Feed for 檔案庫",
"Feed for individual Image Galleries" => "Feed for 獨立的影像圖庫",
"Feed for individual File Galleries" => "Feed for 獨立的檔案庫",
"Feed for individual weblogs" => "Feed for 獨立的 weblogs",
"Feed for individual forums" => "Feed for 獨立論壇",
"PDF generation" => "產生 PDF",
"Use in CMS" => "使用於 cms",
"Use in Wiki" => "使用於 wiki",
"Use in newsletters" => "使用於電子報",
"Use in HTML pages" => "使用於 HTML 頁面",
"Refresh rate (if dynamic) [secs]" => "更新頻率 (如果為動態) [秒]",
"Create/edit newsletters" => "建立/編輯電子報",
"subscriptions" => "訂閱",
"Use Admin Email" => "使用管理者電子郵件",
"Edit or add poll options" => "編輯或加入投票選項",
"Create/edit Polls" => "建立/編輯 投票",
"Rss channels" => "Rss頻道",
"Admin tracker" => "管理追蹤",
"Edit this tracker" => "編輯此追蹤",
"View this tracker items" => "瀏覽此追蹤項目",
"Edit tracker fields" => "編輯追蹤欄位",
"fields" => "欄位",
"Create/edit trackers" => "建立/編輯追蹤",
"Add a new group" => "增加新群組",
"Edit item" => "編輯項目",
"Add a new user" => "增加使用者",
"Popup Window" => "蹦現視窗",
"details" => "細節",
"No individual permissions global permissions apply" => "不採用單獨的權限設定,採用全體權限設定",
"Welcome to the Tiki Chat Rooms" => "歡迎來到 Tiki 聊天室",
"Please select a chat channel" => "請選擇一個聊天頻道",
"enter chat room" => "進入聊天室",
"Chatroom" => "聊天室",
"Active Channels" => "活動中頻道",
"Users in this channel" => "頻道中的使用者",
"Channel Information" => "頻道資訊",
"Channel" => "頻道",
"Ratio" => "比率",
"Use :nickname:message for private messages" => "用 :暱稱:訊息 來發送個人訊息",
"Use [URL|description] or [URL] for links" => "使用 [URL|描述] 或 [URL] 表示連結",
"Create PDF" => "建立 PDF",
"PDF Settings" => "PDF 設定",
"Select Wiki Pages" => "選擇 Wiki 頁面",
"Remove Page" => "移除頁面",
"Add or edit a site" => "增加或編輯站臺",
"sites" => "站臺",
"cool sites" => "酷站臺",
"Use ...page... to separate pages in a multi-page article" => "使用 ...頁面... 將頁面分隔為多重頁面",
"Create Zone" => "建立區域",
"translate" => "翻譯",
"Create or edit content" => "建立或編輯內容",
"this quiz stats" => "這個測驗的統計",
"answer" => "答案",
"Edit FAQ questions" => "編輯 FAQ 問題",
"Edit this file gallery:" => "編輯此檔案庫:",
"icon" => "圖示",
"Other users can upload files to this gallery" => "允許其他使用者上傳檔案到此檔案庫",
"Available File Galleries" => "現有檔案庫",
"start" => "開始",
"end" => "結束",
"roles" => "角色",
"Add role" => "增加角色",
"rollback" => "回復",
"Create or edit content block" => "建立或編輯內容區塊",
"Listing Gallery" => "列出檔案庫",
"Gallery Files" => "檔案庫檔案",
"Last ver" => "最近版本",
"Vers" => "版本",
"Subscribe to newsletter" => "訂閱電子報",
"Add or edit a news server" => "增加或編輯 news 伺服器",
"Print Wiki Pages" => "列印 Wiki 頁面",
"add page" => "增加頁面",
"Total threads" => "總討論串數",
"Average threads per topic" => "主題平均討論串數",
"You can include the file in an HTML/Tiki page using" => "你可以包含這個檔案在一個 HTML/Tiki 頁面中使用",
"Now enter the file URL" => "輸入這個檔案的 URL",
" or upload a local file from your disk" => "或由你的磁碟上傳一個本地的檔案",
"Add or edit folder" => "增加或編輯資料夾",
"Add or edit a URL" => "增加或編輯一個URL",
"priority" => "重要性",
"previous chart" => "前一排行榜",
"next chart" => "下一張排行榜",
"pos" => "排名",
"avg" => "平均",
"post new comment" => "發表新評論",
"Post New Comment" => "發表新評論",
"HTML tags are not allowed inside comments" => "不允許評論中使用 HTML 標籤",
"moderator actions" => "板主命令",
"move selected topics" => "移動選擇的主題",
"unlock selected topics" => "解鎖選擇的主題",
"lock selected topics" => "鎖定選擇的主題",
"merge" => "合併",
"merge selected topics" => "合併選擇的主題",
"reported messages:" => "回報的訊息:",
"queued messages:" => "佇列中訊息:",
"View item" => "觀看項目",
"Add a comment" => "增加一個評論",
"account" => "帳號",
"Group doesnt exist" => "群組不存在",
"User doesnt exist" => "使用者不存在",
"Event without Name" => "無名事件",
"Invalid old password" => "舊密碼錯誤",
"No channel indicated" => "未指定頻道",
"No nickname indicated" => "未指定暱稱",
"Permision denied" => "權限不足",
"cc" => "cc",
"sender" => "寄件者",
"subject" => "主題",
"date" => "日期",
"flagged" => "已標記",
"mark" => "標計",
"replied" => "已回覆",
"posted by" => "發表自",
"email this post" => "email 此文章",
"Use page description" => "使用頁面描述",
"Show page title" => "顯示頁面標題",
"Users can lock pages (if perm)" => "允許使用者鎖定頁面 (如果有權限)",
"Use WikiWords" => "使用 WikiWords",
"Maximum number of versions for history" => "歷程記錄中版本最大數目",
"Never delete versions younger than days" => "永不刪除少於幾天的版本",
"Old vers" => "舊版本",
"Add or edit event" => "建立或編輯事件",
"merge selected notes into" => "合併選擇的記事至",
"Faq Stats" => "Faq 統計",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "你的訊息已排入等待核可, 板主核可之後\n就會發佈.",
"settings" => "設定",
"mailbox" => "郵件夾",
"compose" => "新郵件",
"contacts" => "通訊錄",
"clip" => "迴紋針",
"back to mailbox" => "返回郵件夾",
"full headers" => "完整標頭",
"normal headers" => "一般標頭",
"reply all" => "全部回覆",
"forward" => "轉寄",
"select from address book" => "由通訊錄中選擇",
"new sites" => "新站臺",
"{\$atts_cnt} files attached" => "{\$atts_cnt} 個附加檔案",
"pass" => "密碼",
"Page generated in" => "本頁面產生花費",
"sent" => "送出",
"Favorites" => "我的最愛",
"Back to Homepage" => "回到首頁",
"Minor" => "次要",
"Content Features" => "內容功能",
"Prevent automatic/robot registration" => "防止自動/機器人註冊",
"Create/edit Calendars" => "建立/編輯行事曆",
"charts" => "排行榜",
"Chat Administration" => "閒談管理",
"Create/edit channel" => "建立/編輯 頻道",
"second" => "秒",
"Chat channels" => "聊天頻道",
"Assign Module" => "指定模組",
"Edit/Create" => "編輯/產生",
"subscribed" => "訂閱",
"Edit survey questions" => "編輯調查問題",
"Admin Tracker" => "管理追蹤",
"Again" => "再次輸入",
"Assign permissions to group" => "指定權限給群組",
"Browsing Gallery" => "瀏覽圖庫",
"Show Plugins Help" => "顯示外掛模組說明",
"Show Text Formatting Rules" => "顯示文字排版規則",
"Program dynamic content for block" => "設計區塊的動態內容",
"Admin quizzes" => "管理測驗",
"Message queue for" => "訊息佇列",
"back to forum" => "回到論壇",
"Reported messages for" => "回報訊息",
"hist" => "歷史記錄",
"back to admin" => "回到管理介面",
"Subscribe to This Newsletter" => "訂閱",
"Stats for quiz" => "測驗統計",
"Received Articles" => "已接收文章",
"Rename page" => "頁面更名",
"to_version" => "至版本",
"Stats for survey" => "調查結果",
"Theme Control Center: categories" => "佈景主題控制臺: 分類",
"Theme Control Center: sections" => "佈景主題控制臺: 區塊",
"File Title" => "檔案標題",
"IRC log" => "IRC 紀錄",
"Add new mail account" => "增加新的郵件帳號",
"User accounts" => "使用者帳號",
"View All" => "觀看全部",
"Msg" => "訊息",
"Permission denied you cannot remove pages" => "權限不足, 你無法移除頁面",
"Send trackback pings to:" => "Send trackback pings to:",
"(comma separated list of URIs)" => "(comma separated list of URIs)",
"LDAP Member Is DN" => "LDAP Member Is DN",
"Cannot write to this file" => "無法寫入此檔案",
"Missing title or body when trying to post a comment" => "發表評論沒有標題或內文",
"Newsletter subscription information at " => "電子報註冊資訊在 ",
"categorize this object" => "分類這個物件",
"Syntax highlighting" => "語法強調",
"My Files" => "我的檔案",
"Mini calendar" => "迷你月曆",
"Received pages" => "已接收頁面",
"Admin Posts" => "管理佈告",
"Submit a New Link" => "送出新連結",
"Admin Directory" => "管理目錄",
"List trackers" => "列出追蹤",
"I forgot my pass" => "忘記密碼",
"This is" => "這是",
"by the" => "由",
"Use URI as Home Page" => "使用 URI 當首頁",
"OS" => "作業系統",
"Use cache for external images" => "快取外部影像",
"Use gzipped output" => "使用 gzipp 壓縮輸出",
"Sender Email" => "發送者 Email",
"contact feature disabled" => "聯絡功能已關閉",
"User registration and login" => "使用者註冊與登入",
"Use WebServer authentication for Tiki" => "使用網站伺服器為 Tiki 認證",
"Request passcode to register" => "須用 passcode 才能註冊",
"Validate users by email" => "用email確認使用者",
"Store plaintext passwords" => "儲存明文密碼",
"Reg users can change language" => "允許註冊使用者更改語言",
"Force to use chars and nums in passwords" => "強制在密碼中使用字元和數字",
"Minimum password length" => "最小密碼長度",
"Password invalid after days" => "密碼在幾天後到期",
"Remember me feature" => "記憶登入功能",
"Duration:" => "持續時間:",
"Create user if not in Tiki?" => "如果 Tiki 中無使用者則建立帳號?",
"Create user if not in Auth?" => "如果 Auth 中無使用者則建立帳號?",
"Just use Tiki auth for admin?" => "僅 admin 帳號使用 Tiki 認證?",
"LDAP Host" => "LDAP 主機",
"LDAP Port" => "LDAP 連接埠",
"LDAP Scope" => "LDAP 領域",
"LDAP Base DN" => "LDAP 主 DN",
"LDAP User DN" => "LDAP 使用者 DN",
"LDAP User Attribute" => "LDAP 使用者屬性",
"LDAP User OC" => "LDAP 使用者 OC",
"LDAP Group DN" => "LDAP 群組 DN",
"LDAP Group OC" => "LDAP 群組 OC",
"LDAP Member Attribute" => "LDAP 成員屬性",
"LDAP Admin User" => "LDAP 管理者",
"LDAP Admin Pwd" => "LDAP 管理者密碼",
"Allow Smileys" => "允許表情符號",
"Hotwords in New Windows" => "以新視窗顯示熱門單字",
"restore" => "回復",
"Wiki Home Page" => "Wiki 首頁",
"Wiki Discussion" => "Wiki 討論",
"Wiki Features" => "Wiki 功能",
"Wiki History" => "Wiki 歷史",
"Wiki Watch" => "Wiki 監視",
"Admin Charts" => "管理排行榜",
"Edit this RSS module:" => "編輯此 RSS 模組:",
"Create new RSS module" => "建立新 RSS 模組",
"Create/edit questions for survey" => "建立/編輯 調查的問題",
"Active?" => "啟用中?",
"Create/Edit Trackers" => "建立/編輯追蹤",
"Browse gallery" => "瀏覽圖庫",
"Upload from disk" => "由磁碟上傳",
"Browsing Image" => "瀏覽影像",
"Again please" => "請再輸入一次",
"Admin category relationships" => "管理類別關係",
"Validate links" => "確認連結",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "檔名有附加 -{\$user} 可以修改, 其他只能做為樣本複製",
"Im- Export Languages" => "匯入- 匯出語言",
"Create a file gallery" => "建立檔案庫",
"Support tickets" => "支援標籤",
"Return to HomePage" => "回首頁",
"Stats for this survey Questions " => "這次調查問題的結果",
"Batch upload" => "批次上傳",
"Minor Edit" => "次要",
"You can not download files" => "你無法下傳檔案",
"Please wait 2 minutes between posts" => "請間隔兩分鐘再發表佈告",
"Blog level comments" => "Blog level comments",
"Post level comments" => "Post level comments",
"SearchStats" => "SearchStats",
"hr" => "hr",
"Show Categories" => "顯示類別",
"Hide Categories" => "隱藏類別",
"Blog features" => "Blog 功能",
"Spellchecking" => "拼字檢查",
"Default ordering for blog listing" => "blog列表預設順序",
"Blog listing configuration (when listing available blogs)" => "Blog 列表設定 (列出現有 blog時)",
"Blog comments settings" => "Blog評論設定",
"Show Category Path" => "顯示類別路徑",
"Show Category Objects" => "顯示類別物件",
"CMS features" => "CMS 功能",
"Use templates" => "使用模板",
"Maximum number of articles in home" => "首頁最大文章數",
"Article comments settings" => "文章評論設定",
"Copyright Management" => "版權管理",
"License Page" => "授權頁面",
"Submit Notice" => "發送時提示",
"Uploaded filenames must match regex" => "上傳檔案名稱必須符合正規表示式",
"Uploaded filenames cannot match regex" => "上傳檔案名稱不得符合正規表示式",
"File galleries comments settings" => "檔案總覽評論設定",
"Forum quick jumps" => "論壇快速跳躍",
"Ordering for forums in the forum listing" => "在論壇列表中論壇的順序",
"Forum listing configuration" => "論壇列表設定",
"this survey stats" => "這次調查結果",
"bold" => "粗體",
"italic" => "斜體",
"underline" => "底線",
"theme" => "佈景主題",
"unread private messages" => "未讀的私人訊息",
"MyMenu" => "MyMenu",
"WfMenu" => "WfMenu",
"WikiMenu" => "WikiMenu",
"GalMenu" => "GalMenu",
"ForMenu" => "ForMenu",
"DirMenu" => "DirMenu",
"FileGalMenu" => "FileGalMenu",
"QuizMenu" => "QuizMenu",
"TrkMenu" => "TrkMenu",
"SrvMenu" => "SrvMenu",
"EphMenu" => "EphMenu",
"ChartMenu" => "ChartMenu",
"AdmMenu" => "AdmMenu",
"UsrMenu" => "UsrMenu",
"you or someone registered this email address at" => "你或是某位註冊此 email 地址的人",
"Your Tiki information registration" => "你的 Tiki 資訊登記",
"home" => "首頁",
"chat" => "閒談",
"contact us" => "連絡我們",
"debugger console" => "除錯器控制臺",
"User menu" => "使用者選單",
"dump" => "傾印",
"rankings" => "排名",
"orphan pages" => "孤立頁面",
"sandbox" => "沙池",
"received pages" => "已接收頁面",
"structures" => "結構",
"Articles Home" => "文章首頁",
"Send articles" => "發送文章",
"Create/Edit Blog" => "建立/編輯 Blog",
"Browse Directory" => "瀏覽目錄",
"Admin FAQs" => "管理 FAQs",
"Admin quiz" => "管理測驗",
"Admin trackers" => "管理追蹤",
"Send newsletters" => "寄出電子報",
"Ephemerides" => "日曆",
"Backups" => "備份",
"Edit languages" => "編輯語言",
"External wikis" => "外部 wikis",
"Click here to manage your personal menu" => "點擊此處可管理你的個人選單",
"Quick edit a Wiki page" => "快速編輯 Wiki 頁面",
"Sort posts by:" => "排序佈告依據:",
"read more" => "詳細閱讀",
"Pass" => "密碼",
"some text" => "某些文字",
"Creates a box with the data" => "根據資料建立方塊",
"creates a title bar" => "產生標題列",
"creates a table" => "產生表格",
"makes a horizontal rule" => "表示水平線",
"page|desc" => "頁面|描述",
"displays an image" => "顯示影像",
"Non cacheable images" => "無可快取的影像",
"height width desc link and align are optional" => "height width desc link and align可有可無",
"displays rss feed with id=n maximum=m items" => "顯示 id=n 最大值=m 的 rss feed",
"Will be replaced by the actual value of the dynamic content block with id=n" => "將會用 id=n 的動態內容區塊實際值來取代",
"Misc" => "其它",
"Tiki Shoutbox" => "Tiki Shoutbox",
"Tiki email notification" => "Tiki email 通知",
"Reg users can change theme" => "允許註冊使用者更改佈景",
"Create/Edit Newsletters" => "建立/編輯電子報",
"Allow sites in this category" => "在這個分類允許的站臺數",
"Show number of sites in this category" => "在這個分類裡展示站臺數",
"Subcategories" => "子分類",
"Admin related categories" => "管理相關分類",
"in current category" => "在目前分類",
"Total categories" => "所有分類",
"Days online" => "上線天數",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "Cookies must be allowed to vote" => "Cookies must be allowed to vote",
// "This forum is flat and doesn't allow replies to other replies" => "This forum is flat and doesn't allow replies to other replies",
// "This script cannot be called directly" => "This script cannot be called directly",
// "Copyright management" => "Copyright management",
// "Tiki is unable to connect to the database " => "Tiki is unable to connect to the database ",
// "Tiki was unable to retrieve login data from the database " => "Tiki was unable to retrieve login data from the database ",
// "The following error message was returned" => "The following error message was returned",
// "Things to check" => "Things to check",
// "Is your database up and running" => "Is your database up and running",
// "Are your database login credentials correct" => "Are your database login credentials correct",
// "Did you complete the <a href='tiki-install.php' >Tiki Installer" => "Did you complete the <a href='tiki-install.php' >Tiki Installer",
// "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information" => "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information",
// "This feature is for admins only" => "This feature is for admins only",
// "Uploaded" => "Uploaded",
// "Last editor" => "Last editor",
// "Explorer" => "Explorer",
// "Slideshow" => "Slideshow",
// "Default View" => "Default View",
// "Afghanistan" => "Afghanistan",
// "Aland Islands" => "Aland Islands",
// "Aland_Islands" => "Aland_Islands",
// "Albania" => "Albania",
// "Algeria" => "Algeria",
// "American Samoa" => "American Samoa",
// "American_Samoa" => "American_Samoa",
// "Andorra" => "Andorra",
// "Angola" => "Angola",
// "Anguilla" => "Anguilla",
// "Antigua" => "Antigua",
// "Argentina" => "Argentina",
// "Armenia" => "Armenia",
// "Aruba" => "Aruba",
// "Australia" => "Australia",
// "Austria" => "Austria",
// "Azerbaijan" => "Azerbaijan",
// "Bahamas" => "Bahamas",
// "Bahrain" => "Bahrain",
// "Bangladesh" => "Bangladesh",
// "Barbados" => "Barbados",
// "Belarus" => "Belarus",
// "Belgium" => "Belgium",
// "Belize" => "Belize",
// "Benin" => "Benin",
// "Bermuda" => "Bermuda",
// "Bhutan" => "Bhutan",
// "Bolivia" => "Bolivia",
// "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
// "Bosnia_and_Herzegovina" => "Bosnia_and_Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "Bouvet_Island" => "Bouvet_Island",
// "Brazil" => "Brazil",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "British_Indian_Ocean_Territory" => "British_Indian_Ocean_Territory",
// "British_Virgin_Islands" => "British_Virgin_Islands",
// "Brunei" => "Brunei",
// "Bulgaria" => "Bulgaria",
// "Burkina Faso" => "Burkina Faso",
// "Burkina_Faso" => "Burkina_Faso",
// "Burundi" => "Burundi",
// "Cambodia" => "Cambodia",
// "Cameroon" => "Cameroon",
// "Canada" => "Canada",
// "Cape Verde" => "Cape Verde",
// "Cape_Verde" => "Cape_Verde",
// "Catalan Countries" => "Catalan Countries",
// "Catalan_Countries" => "Catalan_Countries",
// "Cayman Islands" => "Cayman Islands",
// "Cayman_Islands" => "Cayman_Islands",
// "Central African Republic" => "Central African Republic",
// "Central_African_Republic" => "Central_African_Republic",
// "Chad" => "Chad",
// "Chile" => "Chile",
// "China" => "China",
// "Christmas Island" => "Christmas Island",
// "Christmas_Island" => "Christmas_Island",
// "Cocos Islands" => "Cocos Islands",
// "Cocos_Islands" => "Cocos_Islands",
// "Colombia" => "Colombia",
// "Comoros" => "Comoros",
// "Congo Democratic" => "Congo Democratic",
// "Congo" => "Congo",
// "Congo_Democratic" => "Congo_Democratic",
// "Cook Islands" => "Cook Islands",
// "Cook_Islands" => "Cook_Islands",
// "Costa Rica" => "Costa Rica",
// "Costa_Rica" => "Costa_Rica",
// "Croatia" => "Croatia",
// "Cuba" => "Cuba",
// "Cyprus" => "Cyprus",
// "Czech Republic" => "Czech Republic",
// "Czech_Republic" => "Czech_Republic",
// "Denmark" => "Denmark",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Dominican Republic" => "Dominican Republic",
// "Dominican_Republic" => "Dominican_Republic",
// "Ecuador" => "Ecuador",
// "Egypt" => "Egypt",
// "El Salvador" => "El Salvador",
// "El_Salvador" => "El_Salvador",
// "Equatorial Guinea" => "Equatorial Guinea",
// "Equatorial_Guinea" => "Equatorial_Guinea",
// "Eritrea" => "Eritrea",
// "Estonia" => "Estonia",
// "Ethiopia" => "Ethiopia",
// "Europe" => "Europe",
// "Falkland Islands" => "Falkland Islands",
// "Falkland_Islands" => "Falkland_Islands",
// "Faroe Islands" => "Faroe Islands",
// "Faroe_Islands" => "Faroe_Islands",
// "Federated States of Micronesia" => "Federated States of Micronesia",
// "Federated_States_of_Micronesia" => "Federated_States_of_Micronesia",
// "Fiji" => "Fiji",
// "Finland" => "Finland",
// "France" => "France",
// "French Guiana" => "French Guiana",
// "French Polynesia" => "French Polynesia",
// "French Southern Territories" => "French Southern Territories",
// "French_Guiana" => "French_Guiana",
// "French_Polynesia" => "French_Polynesia",
// "French_Southern_Territories" => "French_Southern_Territories",
// "Gabon" => "Gabon",
// "Gambia" => "Gambia",
// "Georgia" => "Georgia",
// "Germany" => "Germany",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greece" => "Greece",
// "Greenland" => "Greenland",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guam" => "Guam",
// "Guatemala" => "Guatemala",
// "Guernsey" => "Guernsey",
// "Guinea Bissau" => "Guinea Bissau",
// "Guinea" => "Guinea",
// "Guinea_Bissau" => "Guinea_Bissau",
// "Guyana" => "Guyana",
// "Haiti" => "Haiti",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Heard_Island_and_McDonald_Islands" => "Heard_Island_and_McDonald_Islands",
// "Honduras" => "Honduras",
// "Hong Kong" => "Hong Kong",
// "Hong_Kong" => "Hong_Kong",
// "Hungary" => "Hungary",
// "Iceland" => "Iceland",
// "India" => "India",
// "Indonesia" => "Indonesia",
// "Iran" => "Iran",
// "Iraq" => "Iraq",
// "Ireland" => "Ireland",
// "Isle of Man" => "Isle of Man",
// "Israel" => "Israel",
// "Italy" => "Italy",
// "Ivory Coast" => "Ivory Coast",
// "Ivory_Coast" => "Ivory_Coast",
// "Jamaica" => "Jamaica",
// "Japan" => "Japan",
// "Jersey" => "Jersey",
// "Jordan" => "Jordan",
// "Kazakstan" => "Kazakstan",
// "Kenya" => "Kenya",
// "Kiribati" => "Kiribati",
// "Kuwait" => "Kuwait",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Latvia" => "Latvia",
// "Lebanon" => "Lebanon",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Lithuania" => "Lithuania",
// "Luxemburg" => "Luxemburg",
// "Macao" => "Macao",
// "Macedonia" => "Macedonia",
// "Madagascar" => "Madagascar",
// "Malawi" => "Malawi",
// "Malaysia" => "Malaysia",
// "Maldives" => "Maldives",
// "Mali" => "Mali",
// "Malta" => "Malta",
// "Marshall Islands" => "Marshall Islands",
// "Marshall_Islands" => "Marshall_Islands",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mauritius" => "Mauritius",
// "Mayotte" => "Mayotte",
// "Mexico" => "Mexico",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Morocco" => "Morocco",
// "Mozambique" => "Mozambique",
// "Myanmar" => "Myanmar",
// "Namibia" => "Namibia",
// "Nauru" => "Nauru",
// "Nepal" => "Nepal",
// "Netherlands Antilles" => "Netherlands Antilles",
// "Netherlands" => "Netherlands",
// "Netherlands_Antilles" => "Netherlands_Antilles",
// "New Caledonia" => "New Caledonia",
// "New Zealand" => "New Zealand",
// "New_Caledonia" => "New_Caledonia",
// "New_Zealand" => "New_Zealand",
// "Nicaragua" => "Nicaragua",
// "Niger" => "Niger",
// "Nigeria" => "Nigeria",
// "Niue" => "Niue",
// "Norfolk Island" => "Norfolk Island",
// "Norfolk_Island" => "Norfolk_Island",
// "North Korea" => "North Korea",
// "North_Korea" => "North_Korea",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "Northern_Mariana_Islands" => "Northern_Mariana_Islands",
// "Norway" => "Norway",
// "Oman" => "Oman",
// "Other" => "Other",
// "Pakistan" => "Pakistan",
// "Palau" => "Palau",
// "Palestine" => "Palestine",
// "Panama" => "Panama",
// "Papua New Guinea" => "Papua New Guinea",
// "Papua_New_Guinea" => "Papua_New_Guinea",
// "Paraguay" => "Paraguay",
// "Peru" => "Peru",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Poland" => "Poland",
// "Portugal" => "Portugal",
// "Puerto Rico" => "Puerto Rico",
// "Puerto_Rico" => "Puerto_Rico",
// "Quatar" => "Quatar",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Republic_of_Macedonia" => "Republic_of_Macedonia",
// "Reunion" => "Reunion",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Russian Federation" => "Russian Federation",
// "Russian_Federation" => "Russian_Federation",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "Saint_Helena" => "Saint_Helena",
// "Saint_Kitts_and_Nevis" => "Saint_Kitts_and_Nevis",
// "Saint_Lucia" => "Saint_Lucia",
// "Saint_Pierre_and_Miquelon" => "Saint_Pierre_and_Miquelon",
// "Samoa" => "Samoa",
// "San Marino" => "San Marino",
// "San_Marino" => "San_Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Sao_Tome_and_Principe" => "Sao_Tome_and_Principe",
// "Saudi Arabia" => "Saudi Arabia",
// "Saudi_Arabia" => "Saudi_Arabia",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "Sierra_Leone" => "Sierra_Leone",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon Islands" => "Solomon Islands",
// "Solomon_Islands" => "Solomon_Islands",
// "Somalia" => "Somalia",
// "South Africa" => "South Africa",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "South Korea" => "South Korea",
// "South_Africa" => "South_Africa",
// "South_Georgia_and_South_Sandwich_Islands" => "South_Georgia_and_South_Sandwich_Islands",
// "South_Korea" => "South_Korea",
// "Spain" => "Spain",
// "Sri Lanka" => "Sri Lanka",
// "Sri_Lanka" => "Sri_Lanka",
// "St Vincent Grenadines" => "St Vincent Grenadines",
// "St_Vincent_Grenadines" => "St_Vincent_Grenadines",
// "Sudan" => "Sudan",
// "Surinam" => "Surinam",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Svalbard_and_Jan_Mayen" => "Svalbard_and_Jan_Mayen",
// "Swaziland" => "Swaziland",
// "Sweden" => "Sweden",
// "Switzerland" => "Switzerland",
// "Syria" => "Syria",
// "Taiwan" => "Taiwan",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Thailand" => "Thailand",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Tonga" => "Tonga",
// "Trinidad Tobago" => "Trinidad Tobago",
// "Trinidad_Tobago" => "Trinidad_Tobago",
// "Tunisia" => "Tunisia",
// "Turkey" => "Turkey",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Turks_and_Caicos_Islands" => "Turks_and_Caicos_Islands",
// "Tuvalu" => "Tuvalu",
// "US Virgin Islands" => "US Virgin Islands",
// "US_Virgin_Islands" => "US_Virgin_Islands",
// "Uganda" => "Uganda",
// "Ukraine" => "Ukraine",
// "United Arab Emirates" => "United Arab Emirates",
// "United Kingdom" => "United Kingdom",
// "United Nations Organization" => "United Nations Organization",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "United States" => "United States",
// "United_Arab_Emirates" => "United_Arab_Emirates",
// "United_Kingdom" => "United_Kingdom",
// "United_Kingdom_-_England_and_Wales" => "United_Kingdom_-_England_and_Wales",
// "United_Kingdom_-_Northern_Ireland" => "United_Kingdom_-_Northern_Ireland",
// "United_Kingdom_-_Scotland" => "United_Kingdom_-_Scotland",
// "United_Nations_Organization" => "United_Nations_Organization",
// "United_States" => "United_States",
// "United_States_Minor_Outlying_Islands" => "United_States_Minor_Outlying_Islands",
// "Uruguay" => "Uruguay",
// "Uzbekistan" => "Uzbekistan",
// "Vanuatu" => "Vanuatu",
// "Vatican" => "Vatican",
// "Venezuela" => "Venezuela",
// "Viet Nam" => "Viet Nam",
// "Viet_Nam" => "Viet_Nam",
// "Wales" => "Wales",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Wallis_and_Futuna" => "Wallis_and_Futuna",
// "Western Sahara" => "Western Sahara",
// "Western_Sahara" => "Western_Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
// "the former Yugoslav Republic of Macedonia" => "the former Yugoslav Republic of Macedonia",
// "the_former_Yugoslav_Republic_of_Macedonia" => "the_former_Yugoslav_Republic_of_Macedonia",
// "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter" => "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter",
// "MySQL Improved (mysqli). Requires MySQL 4.1+" => "MySQL Improved (mysqli). Requires MySQL 4.1+",
// "MySQL classic (mysql)" => "MySQL classic (mysql)",
// "PostgeSQL 7.2+" => "PostgeSQL 7.2+",
// "Oracle" => "Oracle",
// "Sybase" => "Sybase",
// "SQLLite" => "SQLLite",
// "MSSQL" => "MSSQL",
// "Email address not valid, test mail not sent" => "Email address not valid, test mail not sent",
// "Email address empty and \"copy\" checkbox not set, test mail not sent" => "Email address empty and \"copy\" checkbox not set, test mail not sent",
// "Test mail from Tiki installer " => "Test mail from Tiki installer ",
// "Tiki version" => "Tiki version",
// "PHP version" => "PHP version",
// "Server" => "Server",
// "Sent" => "Sent",
// "Congratulations!\n\nYour server can send emails.\n\n" => "Congratulations!\n\nYour server can send emails.\n\n",
// "Slovene" => "Slovene",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "Simplified Chinese" => "Simplified Chinese",
// "Chinese" => "Chinese",
// "Czech" => "Czech",
// "Danish" => "Danish",
// "German" => "German",
// "English" => "English",
// "English British" => "English British",
// "Spanish" => "Spanish",
// "Greek" => "Greek",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Fijian" => "Fijian",
// "French" => "French",
// "Galician" => "Galician",
// "Hebrew" => "Hebrew",
// "Croatian" => "Croatian",
// "Italian" => "Italian",
// "Japanese" => "Japanese",
// "Korean" => "Korean",
// "Hungarian" => "Hungarian",
// "Dutch" => "Dutch",
// "Norwegian" => "Norwegian",
// "Polish" => "Polish",
// "Português" => "Português",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Russian" => "Russian",
// "Pijin Solomon" => "Pijin Solomon",
// "Slovak" => "Slovak",
// "Serbian" => "Serbian",
// "Serbian Latin" => "Serbian Latin",
// "Swedish" => "Swedish",
// "Tuvaluan" => "Tuvaluan",
// "Traditional Chinese" => "Traditional Chinese",
// "Ukrainian" => "Ukrainian",
// "This instance of activity is already complete" => "This instance of activity is already complete",
// "Fatal error: cannot execute automatic activity \$activityId" => "Fatal error: cannot execute automatic activity \$activityId",
// "Fatal error: setting next activity to an unexisting activity" => "Fatal error: setting next activity to an unexisting activity",
// "Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Fatal error: nextActivity does not match any candidate in autorouting switch activity",
// "Fatal error: non-deterministic decision for autorouting activity" => "Fatal error: non-deterministic decision for autorouting activity",
// "Fatal error: trying to send an instance to an activity but no transition found" => "Fatal error: trying to send an instance to an activity but no transition found",
// "Cannot add transition only split activities can have more than one outbound transition" => "Cannot add transition only split activities can have more than one outbound transition",
// "Circular reference found some activity has a transition leading to itself" => "Circular reference found some activity has a transition leading to itself",
// "Process does not have a start activity" => "Process does not have a start activity",
// "Process does not have exactly one end activity" => "Process does not have exactly one end activity",
// "End activity is not reachable from start activity" => "End activity is not reachable from start activity",
// "is interactive but has no role assigned" => "is interactive but has no role assigned",
// "is non-interactive and non-autorouted but has no role assigned" => "is non-interactive and non-autorouted but has no role assigned",
// "is standalone but has transitions" => "is standalone but has transitions",
// "is not mapped" => "is not mapped",
// "Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Activity '.\$res['name'].' is standalone and is using the \$instance object",
// "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method",
// "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method",
// "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method",
// "Process %d has been activated" => "Process %d has been activated",
// "Process %d has been deactivated" => "Process %d has been deactivated",
// "Process %s %s imported" => "Process %s %s imported",
// "Process %s removed" => "Process %s removed",
// "Process %s has been updated" => "Process %s has been updated",
// "Process %s has been created" => "Process %s has been created",
// "newest" => "newest",
// "oldest" => "oldest",
// "on left side" => "on left side",
// "on center" => "on center",
// "on right side" => "on right side",
// "as Creator &amp; Last Editor" => "as Creator &amp; Last Editor",
// "Business style" => "Business style",
// "Collaborative style" => "Collaborative style",
// "Page last modified on" => "Page last modified on",
// "no (disabled)" => "no (disabled)",
// "Only with last version" => "Only with last version",
// "Any 2 versions" => "Any 2 versions",
// "complete" => "complete",
// "latin" => "latin",
// "english" => "english",
// "Day" => "Day",
// "Quarter" => "Quarter",
// "Semester" => "Semester",
// "Depends user language" => "Depends user language",
// "No error reporting" => "No error reporting",
// "Report all PHP errors" => "Report all PHP errors",
// "Report all errors except notices" => "Report all errors except notices",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
// "Each day" => "Each day",
// "Each week" => "Each week",
// "Each month" => "Each month",
// "utf-8" => "utf-8",
// "iso-8859-1" => "iso-8859-1",
// "CRLF (standard)" => "CRLF (standard)",
// "LF (some Unix MTA)" => "LF (some Unix MTA)",
// "15 minutes" => "15 minutes",
// "30 minutes" => "30 minutes",
// "1 hour" => "1 hour",
// "2 hours" => "2 hours",
// "10 hours" => "10 hours",
// "20 hours" => "20 hours",
// "1 year" => "1 year",
// "Encourage secure (https) login" => "Encourage secure (https) login",
// "Consider we are always in HTTPS, but do not check" => "Consider we are always in HTTPS, but do not check",
// "crypt-md5" => "crypt-md5",
// "crypt-des" => "crypt-des",
// "tikihash (old)" => "tikihash (old)",
// "Tiki and PAM" => "Tiki and PAM",
// "CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
// "Shibboleth" => "Shibboleth",
// "OpenID and Tiki" => "OpenID and Tiki",
// "choose a group .." => "choose a group ..",
// "Registered" => "Registered",
// "Admins" => "Admins",
// "Never use transition css" => "Never use transition css",
// "Use @version:x.x specified in theme css or none if not specified" => "Use @version:x.x specified in theme css or none if not specified",
// "Use @version:x.x specified in theme css or 1.9 if not specified" => "Use @version:x.x specified in theme css or 1.9 if not specified",
// "Use @version:x.x specified in theme css or 2.0 if not specified" => "Use @version:x.x specified in theme css or 2.0 if not specified",
// "LastModif" => "LastModif",
// "Ascending" => "Ascending",
// "Descending" => "Descending",
// "No forums" => "No forums",
// "%s enabled" => "%s enabled",
// "\$feature is turned on" => "\$feature is turned on",
// "%s disabled" => "%s disabled",
// "\$feature is turned off" => "\$feature is turned off",
// "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing" => "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing",
// "\$feature set to nothing" => "\$feature set to nothing",
// "Template %s not registered" => "Template %s not registered",
// "Error line: %d" => "Error line: %d",
// "All Day" => "All Day",
// "tracker" => "tracker",
// "file gallery" => "file gallery",
// "image gallery" => "image gallery",
// "newsletter" => "newsletter",
// "survey" => "survey",
// "wiki page" => "wiki page",
// "(not registered)" => "(not registered)",
// "You have mistyped the anti-bot verification code; please try again" => "You have mistyped the anti-bot verification code; please try again",
// "Please wait %d secondes between posts" => "Please wait %d secondes between posts",
// "A contribution is mandatory" => "A contribution is mandatory",
// "Invalid Email" => "Invalid Email",
// "Your message has been queued for approval, the message will be posted after a moderator approves it" => "Your message has been queued for approval, the message will be posted after a moderator approves it",
// "This forum is locked" => "This forum is locked",
// "This thread is locked" => "This thread is locked",
// "Those comments are locked" => "Those comments are locked",
// "Foo" => "Foo",
// "Sample plugin" => "Sample plugin",
// "Face" => "Face",
// "Font family to use" => "Font family to use",
// "As defined by CSS" => "As defined by CSS",
// "Line" => "Line",
// "Lines" => "Lines",
// "Newsletter subscription information at" => "Newsletter subscription information at",
// "Tiki Link - Insert internal link" => "Tiki Link - Insert internal link",
// "Select a Wiki page to link to" => "Select a Wiki page to link to",
// "Link" => "Link",
// "Cannot open this file" => "Cannot open this file",
// "This is an approximation based on your server memory limit" => "This is an approximation based on your server memory limit",
// "This is the value of your server's PHP '%s' setting" => "This is the value of your server's PHP '%s' setting",
// "You are alerted by the server " => "You are alerted by the server ",
// "You can check the modifications at : " => "You can check the modifications at : ",
// "You are alerted of a change on " => "You are alerted of a change on ",
// "Continue" => "Continue",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "Contributions" => "Contributions",
// "Query point" => "Query point",
// "layer" => "layer",
// "Record" => "Record",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
// "User Map Generated in" => "User Map Generated in",
// "Image Map Generated in" => "Image Map Generated in",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it" => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it",
// "menu" => "menu",
// "File %s not found" => "File %s not found",
// "File %s is not a valid archive" => "File %s is not a valid archive",
// "Impossible to open %s : %s" => "Impossible to open %s : %s",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "section edit" => "section edit",
// "This poll is closed" => "This poll is closed",
// "Created by profile installer" => "Created by profile installer",
// "Page updated by profile installer" => "Page updated by profile installer",
// "Forums last posts" => "Forums last posts",
// "The passwords do not match" => "The passwords do not match",
// "The registration mail can't be sent. Contact the administrator" => "The registration mail can't be sent. Contact the administrator",
// "Feed provided by %s. Click to visit" => "Feed provided by %s. Click to visit",
// "See other user's profile" => "See other user's profile",
// "Have your profile seen" => "Have your profile seen",
// "Make friends" => "Make friends",
// "Receive message" => "Receive message",
// "Read an article" => "Read an article",
// "Publish an article" => "Publish an article",
// "Have your article read" => "Have your article read",
// "Create new file gallery" => "Create new file gallery",
// "Upload new file to gallery" => "Upload new file to gallery",
// "Download other user's file" => "Download other user's file",
// "Have your file downloaded" => "Have your file downloaded",
// "Create a new image gallery" => "Create a new image gallery",
// "Upload new image to gallery" => "Upload new image to gallery",
// "See other user's gallery" => "See other user's gallery",
// "See other user's image" => "See other user's image",
// "Have your gallery seen by other user" => "Have your gallery seen by other user",
// "Have your image seen" => "Have your image seen",
// "Create new blog" => "Create new blog",
// "Post in a blog" => "Post in a blog",
// "Read other user's blog" => "Read other user's blog",
// "Have your blog read" => "Have your blog read",
// "Create a new wiki page" => "Create a new wiki page",
// "Edit an existing page" => "Edit an existing page",
// "Unknown" => "Unknown",
// "Trackeritem" => "Trackeritem",
// "Directory category" => "Directory category",
// "Wiki Comment" => "Wiki Comment",
// "Calendar item" => "Calendar item",
// "Tracker item" => "Tracker item",
// "Simple" => "Simple",
// "Advanced" => "Advanced",
// "_HOMEPAGE_CONTENT_" => "_HOMEPAGE_CONTENT_",
// "<!-- jq smarty plugin inactive: feature_jquery off -->" => "<!-- jq smarty plugin inactive: feature_jquery off -->",
// "Fast Next" => "Fast Next",
// "Fast Prev" => "Fast Prev",
// "First {\$params['itemname']}" => "First {\$params['itemname']}",
// "Last {\$params['itemname']}" => "Last {\$params['itemname']}",
// "Next {\$params['itemname']}" => "Next {\$params['itemname']}",
// "Prev {\$params['itemname']}" => "Prev {\$params['itemname']}",
// "You need either JQuery or MooTools enabled for this feature" => "You need either JQuery or MooTools enabled for this feature",
// "Help page" => "Help page",
// "View tpl" => "View tpl",
// "Edit Template" => "Edit Template",
// "Admin Feature" => "Admin Feature",
// "Hide" => "Hide",
// "The text is" => "The text is",
// "character(s) too long - please edit it" => "character(s) too long - please edit it",
// "Date Selector" => "Date Selector",
// "phplayers are not available on this site" => "phplayers are not available on this site",
// "Select All" => "Select All",
// "Invert Sort" => "Invert Sort",
// "sec" => "sec",
// "Text cut here" => "Text cut here",
// "Task" => "Task",
// "End date" => "End date",
// "Gender" => "Gender",
// "User information - Click for more info" => "User information - Click for more info",
// "Friend" => "Friend",
// "km" => "km",
// "Last seen on" => "Last seen on",
// "(idle for %s seconds)" => "(idle for %s seconds)",
// "More info about \$other_user" => "More info about \$other_user",
// "(idle for \$idletime seconds)" => "(idle for \$idletime seconds)",
// "No pageviews yet" => "No pageviews yet",
// "n/a" => "n/a",
// "Use this tree to copy the structure" => "Use this tree to copy the structure",
// "created from structure" => "created from structure",
// "Table of contents" => "Table of contents",
// "You have to make %d choice(s) for the question" => "You have to make %d choice(s) for the question",
// "You have to make at least %d choice(s) for the question" => "You have to make at least %d choice(s) for the question",
// "You have to make less than %d choice(s) for the question" => "You have to make less than %d choice(s) for the question",
// "You have to choose at least %d choice(s) for the question" => "You have to choose at least %d choice(s) for the question",
// "unknown error" => "unknown error",
// "Page '%0' cannot be found" => "Page '%0' cannot be found",
// "For the security of your password direct access to the feed is only available via https" => "For the security of your password direct access to the feed is only available via https",
// "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors" => "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors",
// "An error occured in a database query" => "An error occured in a database query",
// "Help link" => "Help link",
// "img-g" => "img-g",
// "file-g" => "file-g",
// "arts" => "arts",
// "Edit Plugin" => "Edit Plugin",
// "Click to edit dynamic variable" => "Click to edit dynamic variable",
// "Update variables" => "Update variables",
// "Edit Section" => "Edit Section",
// "index" => "index",
// "Show" => "Show",
// "You are not allowed to upload this type of file" => "You are not allowed to upload this type of file",
// "The file you are trying upload was only partially uploaded" => "The file you are trying upload was only partially uploaded",
// "You must select a file" => "You must select a file",
// "Flash player not available" => "Flash player not available",
// "Altering database table failed" => "Altering database table failed",
// "%d points" => "%d points",
// "Removed" => "Removed",
// "__WARNING__: Plugin disabled \$plugin" => "__WARNING__: Plugin disabled \$plugin",
// "__WARNING__: No such module \$plugin" => "__WARNING__: No such module \$plugin",
// "Create page" => "Create page",
// "Unknown language" => "Unknown language",
// "Click here to confirm your action" => "Click here to confirm your action",
// "Sea Surfing (CSRF) detected. Operation blocked" => "Sea Surfing (CSRF) detected. Operation blocked",
// "Upload was not successful. Duplicate file content " => "Upload was not successful. Duplicate file content ",
// "Item Modification" => "Item Modification",
// "Item creation" => "Item creation",
// "View the tracker item at" => "View the tracker item at",
// "Field is not numeric" => "Field is not numeric",
// "Field is not a link to mp3 in the gallery" => "Field is not a link to mp3 in the gallery",
// "Field is not a link to FLV in the gallery" => "Field is not a link to FLV in the gallery",
// "Field is not a link to FLV or MP3 in the gallery" => "Field is not a link to FLV or MP3 in the gallery",
// "half column" => "half column",
// "prepend" => "prepend",
// "append" => "append",
// "max" => "max",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>",
// "numeric field" => "numeric field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "drop down with other textfield" => "drop down with other textfield",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "radio buttons" => "radio buttons",
// "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>",
// "ip selector" => "ip selector",
// "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>",
// "page selector" => "page selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "country selector" => "country selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>",
// "jscalendar" => "jscalendar",
// "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "header" => "header",
// "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>",
// "static text" => "static text",
// "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "item link" => "item link",
// "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "items list" => "items list",
// "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "dynamic items list" => "dynamic items list",
// "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "multimedia" => "multimedia",
// "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>",
// "auto-increment" => "auto-increment",
// "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "user subscription" => "user subscription",
// "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>",
// "Google Maps" => "Google Maps",
// "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>",
// "system" => "system",
// "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>",
// "computed field" => "computed field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>",
// "user preference" => "user preference",
// "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "pending" => "pending",
// "No extra information for that attached file. " => "No extra information for that attached file. ",
// "The administrator has not yet validated your account. Please wait" => "The administrator has not yet validated your account. Please wait",
// "You must validate your account first. An email has been sent to you" => "You must validate your account first. An email has been sent to you",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "The user email confirmation can't be sent. Contact the administrator" => "The user email confirmation can't be sent. Contact the administrator",
// "Personal Phone" => "Personal Phone",
// "Personal Mobile" => "Personal Mobile",
// "Personal Fax" => "Personal Fax",
// "Work Phone" => "Work Phone",
// "Work Mobile" => "Work Mobile",
// "Work Fax" => "Work Fax",
// "Company" => "Company",
// "Organization" => "Organization",
// "Department" => "Department",
// "Division" => "Division",
// "Job Title" => "Job Title",
// "Street Address" => "Street Address",
// "City" => "City",
// "State" => "State",
// "Zip Code" => "Zip Code",
// "User-Agent Info" => "User-Agent Info",
// "Displays various information about the client" => "Displays various information about the client",
// "Info" => "Info",
// "Info required - IP|SVRSW|BROWSER" => "Info required - IP|SVRSW|BROWSER",
// "Displays browser client info" => "Displays browser client info",
// "Anchor Link" => "Anchor Link",
// "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin" => "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin",
// "Anchor link label" => "Anchor link label",
// "The anchor name as defined in the ANAME plugin" => "The anchor name as defined in the ANAME plugin",
// "The name of the wiki page containing the anchor" => "The name of the wiki page containing the anchor",
// "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor",
// "linktext" => "linktext",
// "Anchor Name" => "Anchor Name",
// "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin" => "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin",
// "The name of the anchor" => "The name of the anchor",
// "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor",
// "Image Annotation" => "Image Annotation",
// "Autogenerated content. Leave blank initially" => "Autogenerated content. Leave blank initially",
// "Absolute URL to the image or relative path from tikiwiki root" => "Absolute URL to the image or relative path from tikiwiki root",
// "Width" => "Width",
// "Image width" => "Image width",
// "Height" => "Height",
// "Image height" => "Image height",
// "Alignment" => "Alignment",
// "Image alignment. Possible values: left, right, center" => "Image alignment. Possible values: left, right, center",
// "Save changes to annotations" => "Save changes to annotations",
// "Image annotations changed" => "Image annotations changed",
// "Creates an annotation block for an image" => "Creates an annotation block for an image",
// "Displays an image and allow the users to define zones to highlight information on the image" => "Displays an image and allow the users to define zones to highlight information on the image",
// "Includes an article\\'s content within the page" => "Includes an article\\'s content within the page",
// "Field" => "Field",
// "The article field to display. Default field is Heading" => "The article field to display. Default field is Heading",
// "Article ID" => "Article ID",
// "The article to display. If no value is provided, most recent article will be used" => "The article to display. If no value is provided, most recent article will be used",
// "Includes an article" => "Includes an article",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading" => "Id is optional. If not given, last article is used. Default field is heading",
// "Article List" => "Article List",
// "Includes a list of articles within the page" => "Includes a list of articles within the page",
// "Articles displayed" => "Articles displayed",
// "The amount of articles to display in the list" => "The amount of articles to display in the list",
// "Topics expression" => "Topics expression",
// "Topic ID expression" => "Topic ID expression",
// "Type expression" => "Type expression",
// "Category ID" => "Category ID",
// "The ID of the category to list from" => "The ID of the category to list from",
// "The article language to list" => "The article language to list",
// "Sort order" => "Sort order",
// "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")" => "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")",
// "Quiet" => "Quiet",
// "Whether to not report when there are no articles" => "Whether to not report when there are no articles",
// "Title only" => "Title only",
// "Whether to only show the title of the articles" => "Whether to only show the title of the articles",
// "Show body" => "Show body",
// "Whether to only show the body of the articles or just the heading" => "Whether to only show the body of the articles or just the heading",
// "Starting article" => "Starting article",
// "The article number that the list should start with" => "The article number that the list should start with",
// "Earliest date to select articles from" => "Earliest date to select articles from",
// "Latest date to select articles from" => "Latest date to select articles from",
// "Override Dates" => "Override Dates",
// "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings" => "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings",
// "Container class" => "Container class",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~",
// "Bullets" => "Bullets",
// "Inline" => "Inline",
// "Number" => "Number",
// "Show icon" => "Show icon",
// "No such attachment on this page" => "No such attachment on this page",
// "Displays an attachment or a list of them" => "Displays an attachment or a list of them",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Same as name" => "Same as name",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description" => "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "Shows a file icon" => "Shows a file icon",
// "The wiki page the avatar will link to" => "The wiki page the avatar will link to",
// "Float" => "Float",
// "left|right" => "left|right",
// "Displays a link that allows to go back in the browser history" => "Displays a link that allows to go back in the browser history",
// "Insert back link on wiki page" => "Insert back link on wiki page",
// "List all pages linking to the specified page" => "List all pages linking to the specified page",
// "The page links will point to. Default value is the current page" => "The page links will point to. Default value is the current page",
// "Displayed information" => "Displayed information",
// "Pipe separated list of fields to display. ex: hits|user" => "Pipe separated list of fields to display. ex: hits|user",
// "Excluded pages" => "Excluded pages",
// "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox" => "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox",
// "Include Self" => "Include Self",
// "1|0" => "1|0",
// "No Header" => "No Header",
// "List all pages which link to specific pages" => "List all pages which link to specific pages",
// "No pages links to" => "No pages links to",
// "One page links to" => "One page links to",
// "pages link to" => "pages link to",
// "Banner" => "Banner",
// "Insert a banner" => "Insert a banner",
// "Target" => "Target",
// "missing parameter" => "missing parameter",
// "Blog List" => "Blog List",
// "Use BLOGLIST to include posts from a blog" => "Use BLOGLIST to include posts from a blog",
// "Blog ID" => "Blog ID",
// "Numeric value" => "Numeric value",
// "Maximum number of entries to list" => "Maximum number of entries to list",
// "Simple list" => "Simple list",
// "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)" => "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)",
// "Earliest date to select posts from" => "Earliest date to select posts from",
// "Latest date to select posts from" => "Latest date to select posts from",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")",
// "Use BLOGLIST to include posts from a blog. Syntax is" => "Use BLOGLIST to include posts from a blog. Syntax is",
// "where Id is the blog Id and Items is the max number of posts to display" => "where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Box" => "Box",
// "Box title" => "Box title",
// "Displayed above the content" => "Displayed above the content",
// "Background color" => "Background color",
// "As defined by CSS, name or Hex code" => "As defined by CSS, name or Hex code",
// "Box width" => "Box width",
// "In pixels or percentage. Default value is 100%" => "In pixels or percentage. Default value is 100%",
// "Text Alignment" => "Text Alignment",
// "Float Position" => "Float Position",
// "for box with width lesser than 100%, make text wrap around the box" => "for box with width lesser than 100%, make text wrap around the box",
// "CSS Class" => "CSS Class",
// "Apply custom CSS class to the box" => "Apply custom CSS class to the box",
// "Category IDs" => "Category IDs",
// "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page" => "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page",
// "Types" => "Types",
// "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img" => "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img",
// "Sort Order" => "Sort Order",
// "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle" => "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle",
// "Split" => "Split",
// "And" => "And",
// "Category Orphans" => "Category Orphans",
// "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker" => "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker",
// "Category Path" => "Category Path",
// "Separator" => "Separator",
// "String used to separate the categories in the path. Default character is >" => "String used to separate the categories in the path. Default character is >",
// "Display top category" => "Display top category",
// "yes|no, default to no" => "yes|no, default to no",
// "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool" => "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool",
// "Chart caption" => "Chart caption",
// "Sheet ID" => "Sheet ID",
// "Data sheet ID" => "Data sheet ID",
// "Chart Type" => "Chart Type",
// "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic" => "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic",
// "Chart Width" => "Chart Width",
// "Width in pixels" => "Width in pixels",
// "Chart Height" => "Chart Height",
// "Height in pixels" => "Height in pixels",
// "Value series" => "Value series",
// "Required for pie charts" => "Required for pie charts",
// "Independant series" => "Independant series",
// "Required for types other than pie chart" => "Required for types other than pie chart",
// "Dependant series" => "Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors" => "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors",
// "List of colors to use" => "List of colors to use",
// "Styles" => "Styles",
// "List of styles to use" => "List of styles to use",
// "Labels" => "Labels",
// "Labels for the series or values in the legend" => "Labels for the series or values in the legend",
// "Chart as PDF" => "Chart as PDF",
// "Chart as PostScript" => "Chart as PostScript",
// "Displays a snippet of code" => "Displays a snippet of code",
// "Caption" => "Caption",
// "Code snippet label" => "Code snippet label",
// "Word Wrap" => "Word Wrap",
// "0|1, Enable word wrapping on the code to avoid breaking the layout" => "0|1, Enable word wrapping on the code to avoid breaking the layout",
// "Colors" => "Colors",
// "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, .." => "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, ..",
// "Line numbers" => "Line numbers",
// "0|1, may not be used with colors" => "0|1, may not be used with colors",
// "Wiki syntax" => "Wiki syntax",
// "0|1, parse wiki syntax within the code snippet" => "0|1, parse wiki syntax within the code snippet",
// "Right to left" => "Right to left",
// "0|1, switch the text display from left to right to right to left" => "0|1, switch the text display from left to right to right to left",
// "Content is HTML" => "Content is HTML",
// "0|1, display the content as is instead of escaping HTML special chars" => "0|1, display the content as is instead of escaping HTML special chars",
// "note: colors and ln are exclusive" => "note: colors and ln are exclusive",
// "Includes content from the dynamic content system" => "Includes content from the dynamic content system",
// "Content ID" => "Content ID",
// "Also known as Fortune cookies or Taglines" => "Also known as Fortune cookies or Taglines",
// "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~" => "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~",
// "Countdown" => "Countdown",
// "Displays a countdown from now until the specified date" => "Displays a countdown from now until the specified date",
// "Text to append to the countdown" => "Text to append to the countdown",
// "Target date. Multiple formats accepted" => "Target date. Multiple formats accepted",
// "Locate Time" => "Locate Time",
// "on|off" => "on|off",
// "and" => "and",
// "DBReport" => "DBReport",
// "Run a database report" => "Run a database report",
// "report definition" => "report definition",
// "Full DSN" => "Full DSN",
// "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database" => "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database",
// "Wiki DSN name" => "Wiki DSN name",
// "The name of a DSN connection defined by the Wiki administrator" => "The name of a DSN connection defined by the Wiki administrator",
// "0|1, parse wiki syntax within the report" => "0|1, parse wiki syntax within the report",
// "Debug" => "Debug",
// "0|1, display the parsed report definition" => "0|1, display the parsed report definition",
// "Missing db or dsn parameter" => "Missing db or dsn parameter",
// "You do not have permission to use this DSN" => "You do not have permission to use this DSN",
// "No DSN connection string found" => "No DSN connection string found",
// "Div" => "Div",
// "div|span|pre|b|i|tt|p|blockquote" => "div|span|pre|b|i|tt|p|blockquote",
// "left|right|center|justify" => "left|right|center|justify",
// "left|right, for box with width lesser than 100%, make text wrap around the box" => "left|right, for box with width lesser than 100%, make text wrap around the box",
// "Apply custom CSS class to the div" => "Apply custom CSS class to the div",
// "HTML id" => "HTML id",
// "Sets the div\\'s id attribute, as defined by HTML" => "Sets the div\\'s id attribute, as defined by HTML",
// "Insert a division block on wiki page" => "Insert a division block on wiki page",
// "Definition List" => "Definition List",
// "One entry per line. Each line is in \"Term: Definition\" format" => "One entry per line. Each line is in \"Term: Definition\" format",
// "Creates a definition list" => "Creates a definition list",
// "one definition per line" => "one definition per line",
// "Draw" => "Draw",
// "Displays drawings in the wiki page" => "Displays drawings in the wiki page",
// "Name of the drawing to display" => "Name of the drawing to display",
// "Name parameter missing" => "Name parameter missing",
// "Equation" => "Equation",
// "Renders an equation written in LaTeX syntax as an image" => "Renders an equation written in LaTeX syntax as an image",
// "equation" => "equation",
// "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large" => "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "Events" => "Events",
// "Includes the list of events from a calendar in the page" => "Includes the list of events from a calendar in the page",
// "Calendar ID" => "Calendar ID",
// "Numeric" => "Numeric",
// "Maximum days" => "Maximum days",
// "Maximum Rows" => "Maximum Rows",
// "Datetime" => "Datetime",
// "0|1" => "0|1",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "Fade" => "Fade",
// "Displays a label. On click, the block of content will fade in and fade out" => "Displays a label. On click, the block of content will fade in and fade out",
// "Wiki syntax containing the text to display" => "Wiki syntax containing the text to display",
// "Label" => "Label",
// "Label to display on first display" => "Label to display on first display",
// "Unspecified label" => "Unspecified label",
// "Fancy List" => "Fancy List",
// "One item per line starting with anything followed by \")\"" => "One item per line starting with anything followed by \")\"",
// "Use div" => "Use div",
// "Use div instead of ol" => "Use div instead of ol",
// "Class" => "Class",
// "CSS class of the fancylist" => "CSS class of the fancylist",
// "Creates a fancy looking list" => "Creates a fancy looking list",
// "num" => "num",
// "item text" => "item text",
// "one item per line" => "one item per line",
// "Fancy Table" => "Fancy Table",
// "One row per line, cells separated by ~|~" => "One row per line, cells separated by ~|~",
// "Heading row" => "Heading row",
// "Heading row of the table, same format as the body section" => "Heading row of the table, same format as the body section",
// "Heading CSS Class" => "Heading CSS Class",
// "CSS Class to apply on the heading row" => "CSS Class to apply on the heading row",
// "cells" => "cells",
// "heads and cells separated by ~|~" => "heads and cells separated by ~|~",
// "Displays a link to an attachment to a wiki page and can display an image attachment. " => "Displays a link to an attachment to a wiki page and can display an image attachment. ",
// "Gallery ID" => "Gallery ID",
// "name_asc" => "name_asc",
// "Shows ID" => "Shows ID",
// "Shows Icon" => "Shows Icon",
// "Shows Name" => "Shows Name",
// "Shows Filename" => "Shows Filename",
// "Shows Size" => "Shows Size",
// "Shows Description" => "Shows Description",
// "Shows Creation Date" => "Shows Creation Date",
// "Shows Hits" => "Shows Hits",
// "Shows Locked by" => "Shows Locked by",
// "Shows Modification Date" => "Shows Modification Date",
// "Shows Author" => "Shows Author",
// "Shows Creator" => "Shows Creator",
// "Shows Parent Gallery Name" => "Shows Parent Gallery Name",
// "Shows Number of Files" => "Shows Number of Files",
// "Shows the slideshow of a gallery" => "Shows the slideshow of a gallery",
// "List files in a file gallery (with a category) or in a category or a file gallery od this category" => "List files in a file gallery (with a category) or in a category or a file gallery od this category",
// "Displays a list of files from the File Gallery" => "Displays a list of files from the File Gallery",
// "Flash video" => "Flash video",
// "Displays a SWF on the wiki page" => "Displays a SWF on the wiki page",
// "Movie URL" => "Movie URL",
// "Complete URL to the movie to include" => "Complete URL to the movie to include",
// "Default width: 425" => "Default width: 425",
// "Default height: 350" => "Default height: 350",
// "Quality" => "Quality",
// "Flash video quality. Default value: high" => "Flash video quality. Default value: high",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Footnote" => "Footnote",
// "Inserts a superscripted footnote number next to text and takes in footnote as parameter" => "Inserts a superscripted footnote number next to text and takes in footnote as parameter",
// "The footnote" => "The footnote",
// "Sameas" => "Sameas",
// "Tag to existing footnote" => "Tag to existing footnote",
// "CheckDuplicate" => "CheckDuplicate",
// "check for duplcate footnotes" => "check for duplcate footnotes",
// "Footnotearea" => "Footnotearea",
// "Inserts a section for collected footnotes within the wiki page" => "Inserts a section for collected footnotes within the wiki page",
// "Download box for a file on ftp server" => "Download box for a file on ftp server",
// "ftp" => "ftp",
// "file name" => "file name",
// "Ftp Server Name" => "Ftp Server Name",
// "Ftp User name" => "Ftp User name",
// "Ftp password" => "Ftp password",
// "Download button label" => "Download button label",
// "missing parameters" => "missing parameters",
// "Connection failed" => "Connection failed",
// "Incorrect param" => "Incorrect param",
// "failed" => "failed",
// "Gauge" => "Gauge",
// "Displays a graphical gauge" => "Displays a graphical gauge",
// "current value (REQUIRED)" => "current value (REQUIRED)",
// "Maximum Value" => "Maximum Value",
// "Maximum possible value. Default: 100" => "Maximum possible value. Default: 100",
// "Label displayed on the left side of the gauge" => "Label displayed on the left side of the gauge",
// "Color" => "Color",
// "Background Color" => "Background Color",
// "Bar width in pixels" => "Bar width in pixels",
// "Label Width" => "Label Width",
// "Width in pixels allocated to the label" => "Width in pixels allocated to the label",
// "Display Percentage" => "Display Percentage",
// "true|false, if true then a percentage of the maximum is displayed" => "true|false, if true then a percentage of the maximum is displayed",
// "Display Value" => "Display Value",
// "true|false, if the numeric value is displayed" => "true|false, if the numeric value is displayed",
// "Bar height in pixels" => "Bar height in pixels",
// "Google Analytics" => "Google Analytics",
// "Add the tracking code for Google Analytics" => "Add the tracking code for Google Analytics",
// "Account number" => "Account number",
// "The account number for the site" => "The account number for the site",
// "Missing parameter" => "Missing parameter",
// "googledoc" => "googledoc",
// "Leave this empty" => "Leave this empty",
// "Type of Google document" => "Type of Google document",
// "key" => "key",
// "Google doc key - for example pXsHENf1bGGY92X1iEeJJI" => "Google doc key - for example pXsHENf1bGGY92X1iEeJJI",
// "Name of iframe" => "Name of iframe",
// "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large" => "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large",
// "Pixels or %" => "Pixels or %",
// "Margin Height" => "Margin Height",
// "Pixels" => "Pixels",
// "Margin Width" => "Margin Width",
// "Scrolling" => "Scrolling",
// "editLink" => "editLink",
// "Required parameter \"type\" missing" => "Required parameter \"type\" missing",
// "Required parameter \"key\" missing" => "Required parameter \"key\" missing",
// "Displays a Google document" => "Displays a Google document",
// "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition" => "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition",
// "Allowed Groups" => "Allowed Groups",
// "Pipe separated list of groups allowed to view the block. ex: Admins|Developers" => "Pipe separated list of groups allowed to view the block. ex: Admins|Developers",
// "Denied Groups" => "Denied Groups",
// "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers" => "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "HTML" => "HTML",
// "Include literal HTML in a Wiki page" => "Include literal HTML in a Wiki page",
// "0|1, parse wiki syntax within the html code" => "0|1, parse wiki syntax within the html code",
// "Include literal HTML" => "Include literal HTML",
// "Iframe" => "Iframe",
// "Frame title" => "Frame title",
// "iframe" => "iframe",
// "Displays an iframe" => "Displays an iframe",
// " (experimental - possible successor to img in 4.0)" => " (experimental - possible successor to img in 4.0)",
// "File ID" => "File ID",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Image Source" => "Image Source",
// "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required" => "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required",
// "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded" => "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded",
// "Alias: lnk. Location the image should point to" => "Alias: lnk. Location the image should point to",
// "Link Relation" => "Link Relation",
// "\"rel\" attribute to add to the link" => "\"rel\" attribute to add to the link",
// "Link title" => "Link title",
// "Title text" => "Title text",
// "Image alt text" => "Image alt text",
// "Alternate text to display if impossible to load the image" => "Alternate text to display if impossible to load the image",
// "Alias:imalign. Image alignment in the page. (left, right)" => "Alias:imalign. Image alignment in the page. (left, right)",
// "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)" => "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)",
// "Image description to display on the page" => "Image description to display on the page",
// "Image Map" => "Image Map",
// "Name of the image map to use for the image" => "Name of the image map to use for the image",
// "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)" => "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)",
// "CSS Style" => "CSS Style",
// "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)" => "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)",
// "Border options" => "Border options",
// "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options" => "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options",
// "Description options" => "Description options",
// "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)" => "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)",
// "Default configuration" => "Default configuration",
// "Default configuration definitions. (Usually used in configuration rather than on individual images.)" => "Default configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Mandatory configuration" => "Mandatory configuration",
// "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)" => "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content" => "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content",
// "Display an image" => "Display an image",
// "Displays an image" => "Displays an image",
// "Full URL to the image to display" => "Full URL to the image to display",
// "Alternate Text" => "Alternate Text",
// "Height of the image to display" => "Height of the image to display",
// "Width of the image to display" => "Width of the image to display",
// "Link Title" => "Link Title",
// "Image alignment in the page. (left, right, center) Uses HTML IMG tag" => "Image alignment in the page. (left, right, center) Uses HTML IMG tag",
// "Float Alignment" => "Float Alignment",
// "Image alignment in the flow of the document. (left, right, none) Uses CSS float property" => "Image alignment in the flow of the document. (left, right, none) Uses CSS float property",
// "Style to apply to the image" => "Style to apply to the image",
// "Include a page\\'s content" => "Include a page\\'s content",
// "Page Name" => "Page Name",
// "Wiki page name to include" => "Wiki page name to include",
// "When only a portion of the page should be included, specify the marker from which inclusion should start" => "When only a portion of the page should be included, specify the marker from which inclusion should start",
// "When only a portion of the page should be included, specify the marker at which inclusion should end" => "When only a portion of the page should be included, specify the marker at which inclusion should end",
// "Include a page" => "Include a page",
// "Jabber" => "Jabber",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Applet height in pixels" => "Applet height in pixels",
// "'),\n\t\t\t\t'description' => tra('Applet width in pixels" => "'),\n\t\t\t\t'description' => tra('Applet width in pixels",
// "'),\n\t\t\t\t'description' => tra('jabber.org" => "'),\n\t\t\t\t'description' => tra('jabber.org",
// "Default Color" => "Default Color",
// "255,255,255" => "255,255,255",
// "JQuery" => "JQuery",
// "Insert JQuery javascript code. Requires feature_jquery" => "Insert JQuery javascript code. Requires feature_jquery",
// " (experimental - may change in future versions)" => " (experimental - may change in future versions)",
// "JQuery Code" => "JQuery Code",
// "NotOnReady" => "NotOnReady",
// "NoJQuery" => "NoJQuery",
// "Optional markup for when feature_jquery is off" => "Optional markup for when feature_jquery is off",
// "Insert JQuery javascript code" => "Insert JQuery javascript code",
// "jquery code e.g. \$jq(\"img\\" => "jquery code e.g. \$jq(\"img\\",
// "Do not execute on document ready (execute inline)" => "Do not execute on document ready (execute inline)",
// "Javascript" => "Javascript",
// "Insert a javascript file or/and some javascript code" => "Insert a javascript file or/and some javascript code",
// "javascript code" => "javascript code",
// "Javascript filename" => "Javascript filename",
// "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Not Language" => "Not Language",
// "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Displays the text only if the language matchs" => "Displays the text only if the language matchs",
// "Page name to display information of. Default value is current page" => "Page name to display information of. Default value is current page",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "List wiki pages" => "List wiki pages",
// "Result Offset" => "Result Offset",
// "Result number at which the listing should start" => "Result number at which the listing should start",
// "Result Count" => "Result Count",
// "Amount of results displayed in the list" => "Amount of results displayed in the list",
// "Initial" => "Initial",
// "txt" => "txt",
// "Show Name Only" => "Show Name Only",
// "Structure Head" => "Structure Head",
// "Show Page Alias" => "Show Page Alias",
// "Two letter language code to filter pages listed" => "Two letter language code to filter pages listed",
// "Orphan Language" => "Orphan Language",
// "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed" => "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed",
// "Load Translations" => "Load Translations",
// "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter" => "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter",
// "Exact Match" => "Exact Match",
// "Related to Find" => "Related to Find",
// "Only Orphan Pages" => "Only Orphan Pages",
// "For List Pages" => "For List Pages",
// "List Directory" => "List Directory",
// "Lists files in a directory" => "Lists files in a directory",
// "Full path to the server-local directory" => "Full path to the server-local directory",
// "URL Prefix" => "URL Prefix",
// ".ext" => ".ext",
// "Limit" => "Limit",
// "Maximum amount of files to display" => "Maximum amount of files to display",
// "could not be opened because it doesn't exist or permission was denied" => "could not be opened because it doesn't exist or permission was denied",
// "Displays a map" => "Displays a map",
// "Map File" => "Map File",
// "Extents" => "Extents",
// "Inline Flash mp3 and flv Player" => "Inline Flash mp3 and flv Player",
// "Mediaplayer" => "Mediaplayer",
// "MP3 URL" => "MP3 URL",
// "Complete URL to the mp3 to include" => "Complete URL to the mp3 to include",
// "FLV URL" => "FLV URL",
// "Complete URL to the flv to include" => "Complete URL to the flv to include",
// "Style" => "Style",
// "One of" => "One of",
// "Mini Quiz" => "Mini Quiz",
// "Displays a miniquiz" => "Displays a miniquiz",
// "Instructions::Feedback" => "Instructions::Feedback",
// "Tracker ID" => "Tracker ID",
// "Insert Module" => "Insert Module",
// "Module name as known in Tikiwiki" => "Module name as known in Tikiwiki",
// "Decoration" => "Decoration",
// "Flip" => "Flip",
// "Max" => "Max",
// "np" => "np",
// "notitle" => "notitle",
// "Displays a module inlined in page. More parameters can be added, not supported by UI" => "Displays a module inlined in page. More parameters can be added, not supported by UI",
// "Monospace" => "Monospace",
// "Font name as known in browsers" => "Font name as known in browsers",
// "Mouse Over" => "Mouse Over",
// "Create a mouseover feature on some text" => "Create a mouseover feature on some text",
// "Mouseover text if param label exists. Page text if text param exists" => "Mouseover text if param label exists. Page text if text param exists",
// "Text displayed on the page. The body is the mouseover content" => "Text displayed on the page. The body is the mouseover content",
// "Destination link when moused-over text is clicked. Use http:// for external links" => "Destination link when moused-over text is clicked. Use http:// for external links",
// "DEPRECATED" => "DEPRECATED",
// "Text displayed on the mouseover. The body contains the text of the page" => "Text displayed on the mouseover. The body contains the text of the page",
// "Mouse over box width. Default: 400px" => "Mouse over box width. Default: 400px",
// "Mouse over box height. Default: 200px" => "Mouse over box height. Default: 200px",
// "Offset X" => "Offset X",
// "Shifts the overlay to the right by the specified amount of pixels in relation to the cursor. Default: 5px" => "Shifts the overlay to the right by the specified amount of pixels in relation to the cursor. Default: 5px",
// "Offset Y" => "Offset Y",
// "Shifts the overlay to the bottom by the specified amount of pixels in relation to the cursor. Default: 0px" => "Shifts the overlay to the bottom by the specified amount of pixels in relation to the cursor. Default: 0px",
// "Parse Body" => "Parse Body",
// "y|n, parse the body of the plugin as wiki content. (Default to y)" => "y|n, parse the body of the plugin as wiki content. (Default to y)",
// "Color of the inside popup" => "Color of the inside popup",
// "Default: #F5F5F5" => "Default: #F5F5F5",
// "Text popup color" => "Text popup color",
// "#FFFFFF" => "#FFFFFF",
// "Padding" => "Padding",
// "No label specified" => "No label specified",
// "MWTable" => "MWTable",
// "fancy" => "fancy",
// "true|false" => "true|false",
// "wiki_classes" => "wiki_classes",
// "Displays the data using (sort of) MediaWiki syntax" => "Displays the data using (sort of) MediaWiki syntax",
// "Displays a table using MediaWiki syntax" => "Displays a table using MediaWiki syntax",
// "MySpace" => "MySpace",
// "MySpace Page" => "MySpace Page",
// "Displays a SWF myspace mp3 playlist on the wiki page" => "Displays a SWF myspace mp3 playlist on the wiki page",
// "Object Hits" => "Object Hits",
// "Object ID" => "Object ID",
// "Object Type" => "Object Type",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "Picture" => "Picture",
// "Search for images uploaded by users" => "Search for images uploaded by users",
// " (deprecated - scheduled to be removed or changed significantly)" => " (deprecated - scheduled to be removed or changed significantly)",
// "Filename or full path to file" => "Filename or full path to file",
// "Plugin Manager" => "Plugin Manager",
// "Information" => "Information",
// "Multiple values separated with | can be used" => "Multiple values separated with | can be used",
// "Provides a list of plugins on this wiki" => "Provides a list of plugins on this wiki",
// "No arguments indicated" => "No arguments indicated",
// "Poll ID" => "Poll ID",
// "Displays the output of a poll, fields are indicated with numeric ids" => "Displays the output of a poll, fields are indicated with numeric ids",
// "missing poll ID for plugin POLL" => "missing poll ID for plugin POLL",
// "Profile Installer" => "Profile Installer",
// "Adds controls required to install a profile" => "Adds controls required to install a profile",
// "Domain" => "Domain",
// "Profile repository domain. Default value is profiles.tikiwiki.org" => "Profile repository domain. Default value is profiles.tikiwiki.org",
// "Profile Name" => "Profile Name",
// "Name of the profile" => "Name of the profile",
// "Profile plugin only available to administrators" => "Profile plugin only available to administrators",
// "Profile %0/%1 not found" => "Profile %0/%1 not found",
// "Proposal" => "Proposal",
// "Provides a widget for users to vote on a proposal and view the current decision" => "Provides a widget for users to vote on a proposal and view the current decision",
// "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username" => "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username",
// "Accept proposal" => "Accept proposal",
// "Still undecided" => "Still undecided",
// "Reject proposal" => "Reject proposal",
// "Displays a proposal acceptance widget" => "Displays a proposal acceptance widget",
// "Short description of the proposal to vote on. Will be displayed above the result table" => "Short description of the proposal to vote on. Will be displayed above the result table",
// "Quote" => "Quote",
// "Quoted text" => "Quoted text",
// "Reply to" => "Reply to",
// "Name of the quoted person" => "Name of the quoted person",
// "wrote" => "wrote",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "Random Dynamic Content" => "Random Dynamic Content",
// "Includes random content from the dynamic content system" => "Includes random content from the dynamic content system",
// "Redirect" => "Redirect",
// "Redirect the user to a wiki page or generic URL" => "Redirect the user to a wiki page or generic URL",
// "Wiki page name to redirect to" => "Wiki page name to redirect to",
// "Complete URL, internal or external" => "Complete URL, internal or external",
// "Redirects you to another wiki page" => "Redirects you to another wiki page",
// "Regular Expression" => "Regular Expression",
// "Takes regex expressions and parses the content between REGEX tags and replaces the text" => "Takes regex expressions and parses the content between REGEX tags and replaces the text",
// "one data per line" => "one data per line",
// "Page name containing the regular expression" => "Page name containing the regular expression",
// "Takes regex expressions and parses the content between the REGEX tags and replaces the text" => "Takes regex expressions and parses the content between the REGEX tags and replaces the text",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "Remarks Box" => "Remarks Box",
// "Label displayed above the remark" => "Label displayed above the remark",
// "Highlight" => "Highlight",
// "Icon" => "Icon",
// "Icon ID" => "Icon ID",
// "RSS Feed" => "RSS Feed",
// "Inserts an RSS feed output" => "Inserts an RSS feed output",
// "IDs" => "IDs",
// "List of feed IDs separated by colons. ex: feedId:feedId2" => "List of feed IDs separated by colons. ex: feedId:feedId2",
// "Amount of results displayed" => "Amount of results displayed",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect" => "RSS Id incorrect",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "SourceForge" => "SourceForge",
// "aid?" => "aid?",
// "adit?" => "adit?",
// "groupid?" => "groupid?",
// "Automatically creates a link to the appropriate SourceForge object" => "Automatically creates a link to the appropriate SourceForge object",
// "Insert a ShareThis button from www.sharethis.com" => "Insert a ShareThis button from www.sharethis.com",
// "sharethis" => "sharethis",
// "Display a social networking tool" => "Display a social networking tool",
// "Send services" => "Send services",
// "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services" => "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services",
// "First post services shown" => "First post services shown",
// "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget" => "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget",
// "Rotate image" => "Rotate image",
// "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping" => "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping",
// "Button text" => "Button text",
// "Custom link text for the button" => "Custom link text for the button",
// "Header title" => "Header title",
// "Optional header title text for the widget" => "Optional header title text for the widget",
// "Header background" => "Header background",
// "HTML color code (not color name) for the background color for the header if an optional header title is used" => "HTML color code (not color name) for the background color for the header if an optional header title is used",
// "Header text color" => "Header text color",
// "HTML color code (not color name) for the header text if an optional header title is used" => "HTML color code (not color name) for the header text if an optional header title is used",
// "Link text color for services" => "Link text color for services",
// "HTML color code (not color name) for the link text for all send and post services shown in the widget" => "HTML color code (not color name) for the link text for all send and post services shown in the widget",
// "Pop-up" => "Pop-up",
// "A value of true will cause the widget to show in a pop-up window" => "A value of true will cause the widget to show in a pop-up window",
// "Embedded elements" => "Embedded elements",
// "A value of true will allow embedded elements (like flash) to be seen while iframe is loading" => "A value of true will allow embedded elements (like flash) to be seen while iframe is loading",
// "Sheet" => "Sheet",
// "Displays the content of a spreadsheet in the page" => "Displays the content of a spreadsheet in the page",
// "Sheet Heading" => "Sheet Heading",
// "Internal ID of the TikiSheet" => "Internal ID of the TikiSheet",
// "New sheet in page: " => "New sheet in page: ",
// "Incomplete call to plugin: No target sheet" => "Incomplete call to plugin: No target sheet",
// "Create new sheet" => "Create new sheet",
// "TikiSheet" => "TikiSheet",
// "Edit Sheet" => "Edit Sheet",
// "Show Pages" => "Show Pages",
// "Search criteria" => "Search criteria",
// "Maximum amount of results displayed" => "Maximum amount of results displayed",
// "name|desc" => "name|desc",
// "Last modified by" => "Last modified by",
// "Skype" => "Skype",
// "Clickable Skype link" => "Clickable Skype link",
// "Name or number to call or chat with" => "Name or number to call or chat with",
// "Snarf" => "Snarf",
// "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified" => "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified",
// "Full URL to the page to include" => "Full URL to the page to include",
// "PCRE compliant regular expression" => "PCRE compliant regular expression",
// "Regular Expression Part" => "Regular Expression Part",
// "ex: \$1" => "ex: \$1",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace" => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace",
// "This data is put in a CODE caption" => "This data is put in a CODE caption",
// "Missing url parameter for SNARF plugin" => "Missing url parameter for SNARF plugin",
// "Data to sort, one entry per line" => "Data to sort, one entry per line",
// "asc|desc|shuffle" => "asc|desc|shuffle",
// "Split a page into rows and columns" => "Split a page into rows and columns",
// "Join Columns" => "Join Columns",
// "Generate the colspan attribute if columns are missing" => "Generate the colspan attribute if columns are missing",
// "Fixed Size" => "Fixed Size",
// "Generate the width attribute on the columns" => "Generate the width attribute on the columns",
// "Column Size" => "Column Size",
// "Editable" => "Editable",
// "Display edit icon for each section" => "Display edit icon for each section",
// "Custom class" => "Custom class",
// "add a class to customize the design" => "add a class to customize the design",
// "row1col1" => "row1col1",
// "row1col2" => "row1col2",
// "row2col1" => "row2col1",
// "row2col2" => "row2col2",
// "SQL" => "SQL",
// "Run a sql query" => "Run a sql query",
// "sql query" => "sql query",
// "DNS Name" => "DNS Name",
// "ADODB DNS" => "ADODB DNS",
// "Subscript" => "Subscript",
// "Displays text in subscript" => "Displays text in subscript",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Subscribe Group" => "Subscribe Group",
// "Group Name" => "Group Name",
// "As known in Tikiwiki" => "As known in Tikiwiki",
// "Subscribe Text" => "Subscribe Text",
// "Subscribe text, containing %s as the placeholder for the group name" => "Subscribe text, containing %s as the placeholder for the group name",
// "Unsubscribe Text" => "Unsubscribe Text",
// "Unsubscribe text, containing %s as the placeholder for the group name" => "Unsubscribe text, containing %s as the placeholder for the group name",
// "Subscribe Action" => "Subscribe Action",
// "Subscribe button label, containing %s as the placeholder for the group name" => "Subscribe button label, containing %s as the placeholder for the group name",
// "Unsubscribe Action" => "Unsubscribe Action",
// "Unsubscribe button label, containing %s as the placeholder for the group name" => "Unsubscribe button label, containing %s as the placeholder for the group name",
// "Subscribe Groups" => "Subscribe Groups",
// "Colon separated list of groups" => "Colon separated list of groups",
// "Superscript" => "Superscript",
// "Displays text in superscript (exponent)" => "Displays text in superscript (exponent)",
// "Displays text in superscript" => "Displays text in superscript",
// "Wiki Page to redirect the user after his vote" => "Wiki Page to redirect the user after his vote",
// "Displays a survey" => "Displays a survey",
// "Tag" => "Tag",
// "Displays the text between an html tag" => "Displays the text between an html tag",
// "Any valid HTML tag, span by default" => "Any valid HTML tag, span by default",
// "Equivalent of the style attribute on the HTML tag" => "Equivalent of the style attribute on the HTML tag",
// "Displays text between an html tag" => "Displays text between an html tag",
// "Displays the thumbnail for an image" => "Displays the thumbnail for an image",
// "File ID from the file gallery" => "File ID from the file gallery",
// "Image ID from the image gallery" => "Image ID from the image gallery",
// "URL to the image" => "URL to the image",
// "Maximum Size" => "Maximum Size",
// "Maximum width or height for the image" => "Maximum width or height for the image",
// "Floating" => "Floating",
// "Link target of the image" => "Link target of the image",
// "File not found" => "File not found",
// "File is not an image" => "File is not an image",
// "Server does not support image manipulation" => "Server does not support image manipulation",
// "No image specified" => "No image specified",
// "Title Search" => "Title Search",
// "Search wiki page titles" => "Search wiki page titles",
// "Search Criteria" => "Search Criteria",
// "Portion of a page name" => "Portion of a page name",
// "hits|user" => "hits|user",
// "Exclude" => "Exclude",
// "Pipe separated list of page names to exclude from results" => "Pipe separated list of page names to exclude from results",
// "Search the titles of all pages in this wiki" => "Search the titles of all pages in this wiki",
// "No pages found for title search" => "No pages found for title search",
// "One page found for title search" => "One page found for title search",
// "pages found for title search" => "pages found for title search",
// "Table of Contents (Structure)" => "Table of Contents (Structure)",
// "Displays the table of contents for the current structure\\'s subtree as part of the page content" => "Displays the table of contents for the current structure\\'s subtree as part of the page content",
// "Maximum Depth" => "Maximum Depth",
// "Maximum amount of levels to display. On very large structures, this should be limited" => "Maximum amount of levels to display. On very large structures, this should be limited",
// "Structure ID" => "Structure ID",
// "By default, structure for the current page will be displayed. Alternate structure may be provided" => "By default, structure for the current page will be displayed. Alternate structure may be provided",
// "asc|desc" => "asc|desc",
// "Show Description" => "Show Description",
// "0|1, show the page description instead of the page name" => "0|1, show the page description instead of the page name",
// "Show Numbering" => "Show Numbering",
// "0|1, display the section numbers or not" => "0|1, display the section numbers or not",
// "plain|fancy" => "plain|fancy",
// "Top Friends" => "Top Friends",
// "List top scoring users" => "List top scoring users",
// "Maximum result count" => "Maximum result count",
// "Translate a string using Tikiwiki translation table" => "Translate a string using Tikiwiki translation table",
// "string" => "string",
// "Translate a string" => "Translate a string",
// "Confirmation message after posting form" => "Confirmation message after posting form",
// "Colon-separated list of field IDs to be displayed. Example: 2:4:5" => "Colon-separated list of field IDs to be displayed. Example: 2:4:5",
// "Label on the submit button" => "Label on the submit button",
// "Show Title" => "Show Title",
// "Show Mandatory" => "Show Mandatory",
// "Embedded" => "Embedded",
// "Url used for the field links" => "Url used for the field links",
// "Values" => "Values",
// "Colon-separated list of values" => "Colon-separated list of values",
// "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or " => "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or ",
// "user|page" => "user|page",
// "itemId" => "itemId",
// "itemId if you want to edit an item" => "itemId if you want to edit an item",
// "Template File" => "Template File",
// "Name of the template used to display the tracker items" => "Name of the template used to display the tracker items",
// "Name of the wiki page containing the template to display the tracker items" => "Name of the wiki page containing the template to display the tracker items",
// "New Status" => "New Status",
// "Default status applied to newly created items" => "Default status applied to newly created items",
// "Width of first column " => "Width of first column ",
// "Specify the width in pixels or percentage of the first column in the tracker form" => "Specify the width in pixels or percentage of the first column in the tracker form",
// "Incorrect fieldId" => "Incorrect fieldId",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Following fields are incorrect" => "Following fields are incorrect",
// "Displays an input form for tracker submit" => "Displays an input form for tracker submit",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Fields marked with a * are mandatory" => "Fields marked with a * are mandatory",
// "Display List" => "Display List",
// "Tracker Filter" => "Tracker Filter",
// "notice" => "notice",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Filters the items of a tracker, fields are indicated with numeric ids" => "Filters the items of a tracker, fields are indicated with numeric ids",
// "Wiki text" => "Wiki text",
// "Tracker Item Field" => "Tracker Item Field",
// "Wiki text containing an {ELSE} marker" => "Wiki text containing an {ELSE} marker",
// "Item ID" => "Item ID",
// "Field ID" => "Field ID",
// "Colon separated list of field IDs" => "Colon separated list of field IDs",
// "o|p|c|op|oc|pc|opc" => "o|p|c|op|oc|pc|opc",
// "Test" => "Test",
// "Value to compare against" => "Value to compare against",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)" => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)",
// "Tracker List" => "Tracker List",
// "Displays the output of a tracker content, fields are indicated with numeric ids" => "Displays the output of a tracker content, fields are indicated with numeric ids",
// "Notice" => "Notice",
// "Popup" => "Popup",
// "Colon-separated list of fields to display on click. Example: 6:7" => "Colon-separated list of fields to display on click. Example: 6:7",
// "Sticky Popup" => "Sticky Popup",
// "Show Links" => "Show Links",
// "shownbitems" => "shownbitems",
// "Show Initials" => "Show Initials",
// "Show Status" => "Show Status",
// "Show Creation Date" => "Show Creation Date",
// "Show Last Modification" => "Show Last Modification",
// "Show Field Name" => "Show Field Name",
// "Status Filter" => "Status Filter",
// "Which item status to list. o = open, p = pending, c = closed" => "Which item status to list. o = open, p = pending, c = closed",
// "Sort Mode" => "Sort Mode",
// "Filter Field" => "Filter Field",
// "Colon separated list of fields to allow filtering on" => "Colon separated list of fields to allow filtering on",
// "Filter Value" => "Filter Value",
// "Exact Value" => "Exact Value",
// "Checkbox" => "Checkbox",
// "goIfOne" => "goIfOne",
// "More" => "More",
// "More URL" => "More URL",
// "Select automatically the item of the current user or the page" => "Select automatically the item of the current user or the page",
// "View User" => "View User",
// "Item ID separated with " => "Item ID separated with ",
// "List of items Ids" => "List of items Ids",
// "link url" => "link url",
// "Left Deliminator" => "Left Deliminator",
// "Right Deliminator" => "Right Deliminator",
// "If y, value will be truncated" => "If y, value will be truncated",
// "Export Button" => "Export Button",
// "Compute" => "Compute",
// "Sum or average all the values of a field  and displays it at the bottom of the table" => "Sum or average all the values of a field  and displays it at the bottom of the table",
// "fieldId" => "fieldId",
// "incorrect filterfield" => "incorrect filterfield",
// "Error in tracker ID" => "Error in tracker ID",
// "No field indicated" => "No field indicated",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields" => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields",
// "Tracker Prefill" => "Tracker Prefill",
// "Tracker page name" => "Tracker page name",
// "Button label" => "Button label",
// "Field 1" => "Field 1",
// "Value 1" => "Value 1",
// "Content of the field" => "Content of the field",
// "Field 2" => "Field 2",
// "Value 2" => "Value 2",
// "Field 3" => "Field 3",
// "Value 3" => "Value 3",
// "Field 4" => "Field 4",
// "Value 4" => "Value 4",
// "Field 5" => "Field 5",
// "Value 5" => "Value 5",
// "Tracker Stats" => "Tracker Stats",
// "Show Percentage" => "Show Percentage",
// "Show Bar" => "Show Bar",
// "Show link to tiki-view_tracker" => "Show link to tiki-view_tracker",
// "Displays some stat of a tracker content, fields are indicated with numeric ids" => "Displays some stat of a tracker content, fields are indicated with numeric ids",
// "incorrect fieldId" => "incorrect fieldId",
// "Tracker Timeline" => "Tracker Timeline",
// "Timeline view of a tracker, can be used to display event schedules or gantt charts" => "Timeline view of a tracker, can be used to display event schedules or gantt charts",
// "Title Field" => "Title Field",
// "Tracker Field ID containing the item title" => "Tracker Field ID containing the item title",
// "Summary Field" => "Summary Field",
// "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused" => "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused",
// "Start Date" => "Start Date",
// "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field",
// "End Date" => "End Date",
// "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field",
// "Element Group" => "Element Group",
// "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row" => "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row",
// "Lower Bound" => "Lower Bound",
// "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Upper Bound" => "Upper Bound",
// "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Primary Scale Unit" => "Primary Scale Unit",
// "hour, day, week, month or year (default to hour)" => "hour, day, week, month or year (default to hour)",
// "Secondary Scale Unit" => "Secondary Scale Unit",
// "hour, day, week, month, year or empty (default to empty)" => "hour, day, week, month, year or empty (default to empty)",
// "Link Group Name" => "Link Group Name",
// "Convert the group name to a link. (y|n)" => "Convert the group name to a link. (y|n)",
// "Page Link Field" => "Page Link Field",
// "Tracker Field ID containing the page name for item details" => "Tracker Field ID containing the page name for item details",
// "Missing parameter: %0" => "Missing parameter: %0",
// "Start date after end date" => "Start date after end date",
// "Translated" => "Translated",
// "Links to a translated content" => "Links to a translated content",
// "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)" => "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)",
// "Two letter language code of the language, ex: fr" => "Two letter language code of the language, ex: fr",
// "Country name, ex: France" => "Country name, ex: France",
// "User Count" => "User Count",
// "Displays the number of registered users" => "Displays the number of registered users",
// "Group name" => "Group name",
// "User List" => "User List",
// "Displays a list of registered users" => "Displays a list of registered users",
// "Login Filter" => "Login Filter",
// "String to use between elements of the list" => "String to use between elements of the list",
// "Maximum" => "Maximum",
// "Result limit" => "Result limit",
// "Layout" => "Layout",
// "Split the text in parts visible only under some conditions" => "Split the text in parts visible only under some conditions",
// "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default" => "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default",
// "Navigation" => "Navigation",
// "Displays a navigation box that allows users to select a specific version to display" => "Displays a navigation box that allows users to select a specific version to display",
// "Display the current version name as the title. Note: Do not work when nav=>y" => "Display the current version name as the title. Note: Do not work when nav=>y",
// "Default" => "Default",
// "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'" => "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Show Stats" => "Show Stats",
// "Show Stats After" => "Show Stats After",
// "Show Creator" => "Show Creator",
// "Wanted Pages" => "Wanted Pages",
// "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)" => "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)",
// "Ignore" => "Ignore",
// "Split By" => "Split By",
// "Skip Extension" => "Skip Extension",
// "Collect" => "Collect",
// "Table" => "Table",
// "Level" => "Level",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored" => "A wildcard pattern of originating pages to be ignored",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated" => "The character, by which ignored patterns are separated",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list" => "Whether to include external wikis in the list",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column" => "Collect either originating or wanted pages in a cell and display them in the second column",
// "Switch-on debug output with details about the items" => "Switch-on debug output with details about the items",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex",
// "A custom filter for wanted pages to be listed (only used when level=>custom)" => "A custom filter for wanted pages to be listed (only used when level=>custom)",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "Lists ''wanted'' wiki pages" => "Lists ''wanted'' wiki pages",
// "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)" => "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)",
// "The character, by which ignored patterns are separated. possible values: characters" => "The character, by which ignored patterns are separated. possible values: characters",
// "Whether to include external wikis in the list. possible values" => "Whether to include external wikis in the list. possible values",
// "Collect either originating or wanted pages in a cell and display them in the second column. possible values" => "Collect either originating or wanted pages in a cell and display them in the second column. possible values",
// "Switch-on debug output with details about the items. possible values" => "Switch-on debug output with details about the items. possible values",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "External Wiki" => "External Wiki",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output" => "End of debug output",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Web Service" => "Web Service",
// "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface" => "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface",
// "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter" => "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter",
// "Complete service URL" => "Complete service URL",
// "Service Name" => "Service Name",
// "Registered service name" => "Registered service name",
// "Template Name" => "Template Name",
// "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided" => "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided",
// "Body as Parameter" => "Body as Parameter",
// "Name of the argument to send the body as for services with complex input. Named service required for this to be useful" => "Name of the argument to send the body as for services with complex input. Named service required for this to be useful",
// "Unknown Template" => "Unknown Template",
// "Unknown Service" => "Unknown Service",
// "Missing parameters" => "Missing parameters",
// "Youtube" => "Youtube",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "URL to the Youtube video" => "URL to the Youtube video",
// "width" => "width",
// "height" => "height",
// "quality" => "quality",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Removed version \$version" => "Removed version \$version",
// "rollback version " => "rollback version ",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Plugin " => "Plugin ",
// "Semantic token already exists" => "Semantic token already exists",
// "Invalid semantic token name" => "Invalid semantic token name",
// "Semantic token not found" => "Semantic token not found",
// "Page locked" => "Page locked",
// "Page unlocked" => "Page unlocked",
// "Removed last version" => "Removed last version",
// "Sent box is full. Archive or delete some sent messages first if you want to send more messages" => "Sent box is full. Archive or delete some sent messages first if you want to send more messages",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "User %s can not receive messages, mailbox is full" => "User %s can not receive messages, mailbox is full",
// "User %s can not receive messages" => "User %s can not receive messages",
// "Invalid user: %s" => "Invalid user: %s",
// "Archive is full. Delete some messages from archive first" => "Archive is full. Delete some messages from archive first",
// "Tiki Calendar" => "Tiki Calendar",
// "list topics with links to the articles" => "list topics with links to the articles",
// "Article Topics" => "Article Topics",
// "Categorize %s in %s" => "Categorize %s in %s",
// "Please provide an Id" => "Please provide an Id",
// "no object here yet" => "no object here yet",
// "List by month" => "List by month",
// "Please wait.." => "Please wait..",
// "Changes since" => "Changes since",
// "Since your last visit.." => "Since your last visit..",
// "new posts" => "new posts",
// "new articles" => "new articles",
// "new FAQs" => "new FAQs",
// "new blogs" => "new blogs",
// "new blog posts" => "new blog posts",
// "new image galleries" => "new image galleries",
// "new file galleries" => "new file galleries",
// "new polls" => "new polls",
// "new tracker items" => "new tracker items",
// "updated tracker items" => "updated tracker items",
// "The task title must have at least 3 characters" => "The task title must have at least 3 characters",
// "Invalid server key" => "Invalid server key",
// "Cookie not found" => "Cookie not found",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can browse the calendar" => "Can browse the calendar",
// "Can view events details" => "Can view events details",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Can admin categories" => "Can admin categories",
// "Can edit items in categories" => "Can edit items in categories",
// "Can view categories" => "Can view categories",
// "Can view categorized items" => "Can view categorized items",
// "Can search on objects of this category" => "Can search on objects of this category",
// "Can admin charts" => "Can admin charts",
// "Autovalidate suggestions" => "Autovalidate suggestions",
// "Can suggest items" => "Can suggest items",
// "Can view charts" => "Can view charts",
// "Can vote" => "Can vote",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Can use the chat system" => "Can use the chat system",
// "Can admin the cms" => "Can admin the cms",
// "Can approve submissions" => "Can approve submissions",
// "Can admin article topics" => "Can admin article topics",
// "Can admin article types" => "Can admin article types",
// "Can read article headings" => "Can read article headings",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Can edit articles" => "Can edit articles",
// "Can edit submissions" => "Can edit submissions",
// "Can read articles" => "Can read articles",
// "Can remove articles" => "Can remove articles",
// "Can remove submissions" => "Can remove submissions",
// "Can submit articles" => "Can submit articles",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can admin contributions" => "Can admin contributions",
// "Can admin the directory" => "Can admin the directory",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Submited links are valid" => "Submited links are valid",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can validate submited links" => "Can validate submited links",
// "Can use the directory" => "Can use the directory",
// "Can admin drawings" => "Can admin drawings",
// "Can edit drawings" => "Can edit drawings",
// "Can admin faqs" => "Can admin faqs",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can view faqs" => "Can view faqs",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Can admin users" => "Can admin users",
// "Can access site when closed" => "Can access site when closed",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Can ban users or ips" => "Can ban users or ips",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can edit object permissions" => "Can edit object permissions",
// "Can admin rss modules" => "Can admin rss modules",
// "Can clean cache" => "Can clean cache",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can admin cookies" => "Can admin cookies",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit site templates" => "Can edit site templates",
// "Can search" => "Can search",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view referer stats" => "Can view referer stats",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can admin blogs" => "Can admin blogs",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can post to a blog" => "Can post to a blog",
// "Can create a blog" => "Can create a blog",
// "Can read blogs" => "Can read blogs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can create file galleries" => "Can create file galleries",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can list file galleries" => "Can list file galleries",
// "Can upload files" => "Can upload files",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view file galleries" => "Can view file galleries",
// "Can admin forums" => "Can admin forums",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can post in forums" => "Can post in forums",
// "Can start threads in forums" => "Can start threads in forums",
// "Can read forums" => "Can read forums",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can create image galleries" => "Can create image galleries",
// "Can tag objects" => "Can tag objects",
// "Can list image galleries" => "Can list image galleries",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload images" => "Can upload images",
// "Can browse freetags" => "Can browse freetags",
// "Can view image galleries" => "Can view image galleries",
// "Can admin games" => "Can admin games",
// "Can play games" => "Can play games",
// "Can admin newsletters" => "Can admin newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can send newsletters" => "Can send newsletters",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can admin polls" => "Can admin polls",
// "Can view poll results" => "Can view poll results",
// "Can vote polls" => "Can vote polls",
// "Can view poll voters" => "Can view poll voters",
// "Can admin quicktags" => "Can admin quicktags",
// "Can admin quizzes" => "Can admin quizzes",
// "Can take quizzes" => "Can take quizzes",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view user quiz results" => "Can view user quiz results",
// "Can admin sheet" => "Can admin sheet",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can view shoutbox" => "Can view shoutbox",
// "Can admin surveys" => "Can admin surveys",
// "Can take surveys" => "Can take surveys",
// "Can view survey stats" => "Can view survey stats",
// "Can admin trackers" => "Can admin trackers",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can view tracker items comments" => "Can view tracker items comments",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can list trackers" => "Can list trackers",
// "Can change tracker items" => "Can change tracker items",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can watch tracker" => "Can watch tracker",
// "Can export tracker items" => "Can export tracker items",
// "Can admin the wiki" => "Can admin the wiki",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can edit pages" => "Can edit pages",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can create and edit structures" => "Can create and edit structures",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can lock pages" => "Can lock pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can remove" => "Can remove",
// "Can rename pages" => "Can rename pages",
// "Can rollback pages" => "Can rollback pages",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can view page/pages" => "Can view page/pages",
// "Can watch structure" => "Can watch structure",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can view similar wiki pages" => "Can view similar wiki pages",
// "Can admin workflow processes" => "Can admin workflow processes",
// "Can abort a process instance" => "Can abort a process instance",
// "Can declare an instance as exception" => "Can declare an instance as exception",
// "Can send instances after completion" => "Can send instances after completion",
// "Can execute workflow activities" => "Can execute workflow activities",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can configure modules" => "Can configure modules",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the newsreader" => "Can use the newsreader",
// "Can use the notepad" => "Can use the notepad",
// "Can admin public tasks" => "Can admin public tasks",
// "Can use tasks" => "Can use tasks",
// "Can receive tasks from other users" => "Can receive tasks from other users",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can upload personal files" => "Can upload personal files",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can use the messaging system" => "Can use the messaging system",
// "Can admin comments" => "Can admin comments",
// "Can edit all comments" => "Can edit all comments",
// "Can post new comments" => "Can post new comments",
// "Can read comments" => "Can read comments",
// "Can delete comments" => "Can delete comments",
// "Can vote comments" => "Can vote comments",
// "Can admin content templates" => "Can admin content templates",
// "Can edit content templates" => "Can edit content templates",
// "Can use content templates" => "Can use content templates",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can view HTML pages" => "Can view HTML pages",
// "Can list registered users" => "Can list registered users",
// "Admin live support system" => "Admin live support system",
// "Can use live support system" => "Can use live support system",
// "Can create new mapfile" => "Can create new mapfile",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can use webmail" => "Can use webmail",
// "Can use group webmail" => "Can use group webmail",
// "Can administrate group webmail accounts" => "Can administrate group webmail accounts",
// "Can use personal webmail accounts" => "Can use personal webmail accounts",
// "Can administrate personal webmail accounts" => "Can administrate personal webmail accounts",
// "Can view unapproved plugin details" => "Can view unapproved plugin details",
// "Can execute unapproved plugin" => "Can execute unapproved plugin",
// "Can approve plugin execution" => "Can approve plugin execution",
// "Trust all user inputs (no security checks)" => "Trust all user inputs (no security checks)",
// "View page backlinks" => "View page backlinks",
// "Can admin mail notifications" => "Can admin mail notifications",
// "tiki release" => "tiki release",
// "feature version checks" => "feature version checks",
// "tiki needs upgrade" => "tiki needs upgrade",
// "tiki version last check" => "tiki version last check",
// "tiki version check frequency" => "tiki version check frequency",
// "lastUpdatePrefs" => "lastUpdatePrefs",
// "feature print indexed" => "feature print indexed",
// "feature wiki" => "feature wiki",
// "default wiki diff style" => "default wiki diff style",
// "feature backlinks" => "feature backlinks",
// "feature dump" => "feature dump",
// "feature history" => "feature history",
// "feature lastChanges" => "feature lastChanges",
// "feature likePages" => "feature likePages",
// "feature listPages" => "feature listPages",
// "feature listorphanPages" => "feature listorphanPages",
// "feature page title" => "feature page title",
// "feature sandbox" => "feature sandbox",
// "feature warn on edit" => "feature warn on edit",
// "feature wiki 1like redirection" => "feature wiki 1like redirection",
// "feature wiki allowhtml" => "feature wiki allowhtml",
// "feature wiki argvariable" => "feature wiki argvariable",
// "feature wiki attachments" => "feature wiki attachments",
// "feature wiki comments" => "feature wiki comments",
// "feature wiki description" => "feature wiki description",
// "feature wiki discuss" => "feature wiki discuss",
// "feature wiki export" => "feature wiki export",
// "feature wiki structure" => "feature wiki structure",
// "feature wiki import page" => "feature wiki import page",
// "feature wiki footnotes" => "feature wiki footnotes",
// "feature wiki icache" => "feature wiki icache",
// "feature wiki import html" => "feature wiki import html",
// "feature wiki mindmap" => "feature wiki mindmap",
// "feature wiki monosp" => "feature wiki monosp",
// "feature wiki multiprint" => "feature wiki multiprint",
// "feature wiki notepad" => "feature wiki notepad",
// "feature wiki make structure" => "feature wiki make structure",
// "feature wiki open as structure" => "feature wiki open as structure",
// "feature wiki pageid" => "feature wiki pageid",
// "feature wiki paragraph formatting" => "feature wiki paragraph formatting",
// "feature wiki paragraph formatting add br" => "feature wiki paragraph formatting add br",
// "feature wiki pictures" => "feature wiki pictures",
// "feature wiki plurals" => "feature wiki plurals",
// "feature wiki print" => "feature wiki print",
// "feature wiki protect email" => "feature wiki protect email",
// "feature wiki rankings" => "feature wiki rankings",
// "feature wiki ratings" => "feature wiki ratings",
// "feature wiki replace" => "feature wiki replace",
// "feature wiki show hide before" => "feature wiki show hide before",
// "feature wiki tables" => "feature wiki tables",
// "feature wiki templates" => "feature wiki templates",
// "feature wiki undo" => "feature wiki undo",
// "feature wiki userpage" => "feature wiki userpage",
// "feature wiki userpage prefix" => "feature wiki userpage prefix",
// "feature wiki usrlock" => "feature wiki usrlock",
// "feature wiki feedback polls" => "feature wiki feedback polls",
// "feature wiki save draft" => "feature wiki save draft",
// "feature wikiwords" => "feature wikiwords",
// "feature wikiwords usedash" => "feature wikiwords usedash",
// "feature wiki pagealias" => "feature wiki pagealias",
// "mailin autocheck" => "mailin autocheck",
// "mailin autocheckFreq" => "mailin autocheckFreq",
// "mailin autocheckLast" => "mailin autocheckLast",
// "page bar position" => "page bar position",
// "warn on edit time" => "warn on edit time",
// "wikiHomePage" => "wikiHomePage",
// "wikiLicensePage" => "wikiLicensePage",
// "wikiSubmitNotice" => "wikiSubmitNotice",
// "wiki authors style" => "wiki authors style",
// "wiki authors style by page" => "wiki authors style by page",
// "wiki show version" => "wiki show version",
// "wiki bot bar" => "wiki bot bar",
// "wiki cache" => "wiki cache",
// "wiki comments default ordering" => "wiki comments default ordering",
// "wiki comments displayed default" => "wiki comments displayed default",
// "wiki comments per page" => "wiki comments per page",
// "wiki creator admin" => "wiki creator admin",
// "wiki feature copyrights" => "wiki feature copyrights",
// "wiki forum id" => "wiki forum id",
// "wiki left column" => "wiki left column",
// "wiki list backlinks" => "wiki list backlinks",
// "wiki list comment" => "wiki list comment",
// "wiki list comment len" => "wiki list comment len",
// "wiki list description" => "wiki list description",
// "wiki list description len" => "wiki list description len",
// "wiki list creator" => "wiki list creator",
// "wiki list hits" => "wiki list hits",
// "wiki list lastmodif" => "wiki list lastmodif",
// "wiki list lastver" => "wiki list lastver",
// "wiki list links" => "wiki list links",
// "wiki list name" => "wiki list name",
// "wiki list name len" => "wiki list name len",
// "wiki list size" => "wiki list size",
// "wiki list status" => "wiki list status",
// "wiki list user" => "wiki list user",
// "wiki list versions" => "wiki list versions",
// "wiki list language" => "wiki list language",
// "wiki list categories" => "wiki list categories",
// "wiki list categories path" => "wiki list categories path",
// "wiki list id" => "wiki list id",
// "wiki list sortorder" => "wiki list sortorder",
// "wiki list sortdirection" => "wiki list sortdirection",
// "wiki pagealias tokens" => "wiki pagealias tokens",
// "wiki page regex" => "wiki page regex",
// "wiki page separator" => "wiki page separator",
// "wiki page navigation bar" => "wiki page navigation bar",
// "wiki actions bar" => "wiki actions bar",
// "wiki pagename strip" => "wiki pagename strip",
// "wiki right column" => "wiki right column",
// "wiki top bar" => "wiki top bar",
// "wiki topline position" => "wiki topline position",
// "wiki uses slides" => "wiki uses slides",
// "wiki watch author" => "wiki watch author",
// "wiki watch comments" => "wiki watch comments",
// "wiki watch editor" => "wiki watch editor",
// "wiki watch minor" => "wiki watch minor",
// "feature wiki history full" => "feature wiki history full",
// "feature wiki categorize structure" => "feature wiki categorize structure",
// "feature wiki watch structure" => "feature wiki watch structure",
// "feature wikiapproval" => "feature wikiapproval",
// "wikiapproval prefix" => "wikiapproval prefix",
// "wikiapproval hideprefix" => "wikiapproval hideprefix",
// "wikiapproval delete staging" => "wikiapproval delete staging",
// "wikiapproval master group" => "wikiapproval master group",
// "wikiapproval staging category" => "wikiapproval staging category",
// "wikiapproval approved category" => "wikiapproval approved category",
// "wikiapproval outofsync category" => "wikiapproval outofsync category",
// "wikiapproval block editapproved" => "wikiapproval block editapproved",
// "wikiapproval sync categories" => "wikiapproval sync categories",
// "wikiapproval update freetags" => "wikiapproval update freetags",
// "wikiapproval combine freetags" => "wikiapproval combine freetags",
// "wiki edit section" => "wiki edit section",
// "wiki edit section level" => "wiki edit section level",
// "wiki edit plugin" => "wiki edit plugin",
// "wiki validate plugin" => "wiki validate plugin",
// "wiki edit minor" => "wiki edit minor",
// "wikiplugin agentinfo" => "wikiplugin agentinfo",
// "wikiplugin alink" => "wikiplugin alink",
// "wikiplugin aname" => "wikiplugin aname",
// "wikiplugin annotation" => "wikiplugin annotation",
// "wikiplugin article" => "wikiplugin article",
// "wikiplugin articles" => "wikiplugin articles",
// "wikiplugin attach" => "wikiplugin attach",
// "wikiplugin avatar" => "wikiplugin avatar",
// "wikiplugin back" => "wikiplugin back",
// "wikiplugin backlinks" => "wikiplugin backlinks",
// "wikiplugin banner" => "wikiplugin banner",
// "wikiplugin bloglist" => "wikiplugin bloglist",
// "wikiplugin box" => "wikiplugin box",
// "wikiplugin category" => "wikiplugin category",
// "wikiplugin catorphans" => "wikiplugin catorphans",
// "wikiplugin catpath" => "wikiplugin catpath",
// "wikiplugin center" => "wikiplugin center",
// "wikiplugin chart" => "wikiplugin chart",
// "wikiplugin code" => "wikiplugin code",
// "wikiplugin content" => "wikiplugin content",
// "wikiplugin cookie" => "wikiplugin cookie",
// "wikiplugin copyright" => "wikiplugin copyright",
// "wikiplugin countdown" => "wikiplugin countdown",
// "wikiplugin dbreport" => "wikiplugin dbreport",
// "wikiplugin div" => "wikiplugin div",
// "wikiplugin dl" => "wikiplugin dl",
// "wikiplugin draw" => "wikiplugin draw",
// "wikiplugin equation" => "wikiplugin equation",
// "wikiplugin events" => "wikiplugin events",
// "wikiplugin fade" => "wikiplugin fade",
// "wikiplugin fancylist" => "wikiplugin fancylist",
// "wikiplugin fancytable" => "wikiplugin fancytable",
// "wikiplugin file" => "wikiplugin file",
// "wikiplugin files" => "wikiplugin files",
// "wikiplugin flash" => "wikiplugin flash",
// "wikiplugin footnote" => "wikiplugin footnote",
// "wikiplugin footnotearea" => "wikiplugin footnotearea",
// "wikiplugin ftp" => "wikiplugin ftp",
// "wikiplugin gauge" => "wikiplugin gauge",
// "wikiplugin googleanalytics" => "wikiplugin googleanalytics",
// "wikiplugin googledoc" => "wikiplugin googledoc",
// "wikiplugin group" => "wikiplugin group",
// "wikiplugin html" => "wikiplugin html",
// "wikiplugin iframe" => "wikiplugin iframe",
// "wikiplugin img" => "wikiplugin img",
// "wikiplugin image" => "wikiplugin image",
// "wikiplugin include" => "wikiplugin include",
// "wikiplugin jabber" => "wikiplugin jabber",
// "wikiplugin js" => "wikiplugin js",
// "wikiplugin jq" => "wikiplugin jq",
// "wikiplugin lang" => "wikiplugin lang",
// "wikiplugin lastmod" => "wikiplugin lastmod",
// "wikiplugin listpages" => "wikiplugin listpages",
// "wikiplugin lsdir" => "wikiplugin lsdir",
// "wikiplugin map" => "wikiplugin map",
// "wikiplugin mediaplayer" => "wikiplugin mediaplayer",
// "wikiplugin miniquiz" => "wikiplugin miniquiz",
// "wikiplugin module" => "wikiplugin module",
// "wikiplugin mono" => "wikiplugin mono",
// "wikiplugin mouseover" => "wikiplugin mouseover",
// "wikiplugin mwtable" => "wikiplugin mwtable",
// "wikiplugin myspace" => "wikiplugin myspace",
// "wikiplugin objecthits" => "wikiplugin objecthits",
// "wikiplugin picture" => "wikiplugin picture",
// "wikiplugin pluginmanager" => "wikiplugin pluginmanager",
// "wikiplugin poll" => "wikiplugin poll",
// "wikiplugin profile" => "wikiplugin profile",
// "wikiplugin proposal" => "wikiplugin proposal",
// "wikiplugin quote" => "wikiplugin quote",
// "wikiplugin rcontent" => "wikiplugin rcontent",
// "wikiplugin redirect" => "wikiplugin redirect",
// "wikiplugin regex" => "wikiplugin regex",
// "wikiplugin remarksbox" => "wikiplugin remarksbox",
// "wikiplugin rss" => "wikiplugin rss",
// "wikiplugin sf" => "wikiplugin sf",
// "wikiplugin share" => "wikiplugin share",
// "wikiplugin sharethis" => "wikiplugin sharethis",
// "wikiplugin sheet" => "wikiplugin sheet",
// "wikiplugin showpages" => "wikiplugin showpages",
// "wikiplugin skype" => "wikiplugin skype",
// "wikiplugin snarf" => "wikiplugin snarf",
// "wikiplugin sort" => "wikiplugin sort",
// "wikiplugin split" => "wikiplugin split",
// "wikiplugin sql" => "wikiplugin sql",
// "wikiplugin sub" => "wikiplugin sub",
// "wikiplugin subscribegroup" => "wikiplugin subscribegroup",
// "wikiplugin subscribegroups" => "wikiplugin subscribegroups",
// "wikiplugin sup" => "wikiplugin sup",
// "wikiplugin survey" => "wikiplugin survey",
// "wikiplugin tag" => "wikiplugin tag",
// "wikiplugin thumb" => "wikiplugin thumb",
// "wikiplugin titlesearch" => "wikiplugin titlesearch",
// "wikiplugin toc" => "wikiplugin toc",
// "wikiplugin topfriends" => "wikiplugin topfriends",
// "wikiplugin trackerfilter" => "wikiplugin trackerfilter",
// "wikiplugin trackeritemfield" => "wikiplugin trackeritemfield",
// "wikiplugin trackerlist" => "wikiplugin trackerlist",
// "wikiplugin trackertimeline" => "wikiplugin trackertimeline",
// "wikiplugin tracker" => "wikiplugin tracker",
// "wikiplugin trackerprefill" => "wikiplugin trackerprefill",
// "wikiplugin trackerstat" => "wikiplugin trackerstat",
// "wikiplugin translated" => "wikiplugin translated",
// "wikiplugin tr" => "wikiplugin tr",
// "wikiplugin usercount" => "wikiplugin usercount",
// "wikiplugin userlist" => "wikiplugin userlist",
// "wikiplugin versions" => "wikiplugin versions",
// "wikiplugin vote" => "wikiplugin vote",
// "wikiplugin wantedpages" => "wikiplugin wantedpages",
// "wikiplugin webservice" => "wikiplugin webservice",
// "wikiplugin youtube" => "wikiplugin youtube",
// "wikiplugininline agentinfo" => "wikiplugininline agentinfo",
// "wikiplugininline alink" => "wikiplugininline alink",
// "wikiplugininline aname" => "wikiplugininline aname",
// "wikiplugininline annotation" => "wikiplugininline annotation",
// "wikiplugininline article" => "wikiplugininline article",
// "wikiplugininline articles" => "wikiplugininline articles",
// "wikiplugininline attach" => "wikiplugininline attach",
// "wikiplugininline avatar" => "wikiplugininline avatar",
// "wikiplugininline back" => "wikiplugininline back",
// "wikiplugininline backlinks" => "wikiplugininline backlinks",
// "wikiplugininline banner" => "wikiplugininline banner",
// "wikiplugininline bloglist" => "wikiplugininline bloglist",
// "wikiplugininline box" => "wikiplugininline box",
// "wikiplugininline category" => "wikiplugininline category",
// "wikiplugininline catorphans" => "wikiplugininline catorphans",
// "wikiplugininline catpath" => "wikiplugininline catpath",
// "wikiplugininline center" => "wikiplugininline center",
// "wikiplugininline chart" => "wikiplugininline chart",
// "wikiplugininline code" => "wikiplugininline code",
// "wikiplugininline content" => "wikiplugininline content",
// "wikiplugininline cookie" => "wikiplugininline cookie",
// "wikiplugininline copyright" => "wikiplugininline copyright",
// "wikiplugininline countdown" => "wikiplugininline countdown",
// "wikiplugininline dbreport" => "wikiplugininline dbreport",
// "wikiplugininline div" => "wikiplugininline div",
// "wikiplugininline dl" => "wikiplugininline dl",
// "wikiplugininline draw" => "wikiplugininline draw",
// "wikiplugininline equation" => "wikiplugininline equation",
// "wikiplugininline events" => "wikiplugininline events",
// "wikiplugininline fade" => "wikiplugininline fade",
// "wikiplugininline fancylist" => "wikiplugininline fancylist",
// "wikiplugininline fancytable" => "wikiplugininline fancytable",
// "wikiplugininline file" => "wikiplugininline file",
// "wikiplugininline files" => "wikiplugininline files",
// "wikiplugininline flash" => "wikiplugininline flash",
// "wikiplugininline footnote" => "wikiplugininline footnote",
// "wikiplugininline footnotearea" => "wikiplugininline footnotearea",
// "wikiplugininline ftp" => "wikiplugininline ftp",
// "wikiplugininline gauge" => "wikiplugininline gauge",
// "wikiplugininline googleanalytics" => "wikiplugininline googleanalytics",
// "wikiplugininline googledoc" => "wikiplugininline googledoc",
// "wikiplugininline group" => "wikiplugininline group",
// "wikiplugininline html" => "wikiplugininline html",
// "wikiplugininline iframe" => "wikiplugininline iframe",
// "wikiplugininline img" => "wikiplugininline img",
// "wikiplugininline image" => "wikiplugininline image",
// "wikiplugininline include" => "wikiplugininline include",
// "wikiplugininline jabber" => "wikiplugininline jabber",
// "wikiplugininline js" => "wikiplugininline js",
// "wikiplugininline jq" => "wikiplugininline jq",
// "wikiplugininline lang" => "wikiplugininline lang",
// "wikiplugininline lastmod" => "wikiplugininline lastmod",
// "wikiplugininline listpages" => "wikiplugininline listpages",
// "wikiplugininline lsdir" => "wikiplugininline lsdir",
// "wikiplugininline map" => "wikiplugininline map",
// "wikiplugininline mediaplayer" => "wikiplugininline mediaplayer",
// "wikiplugininline miniquiz" => "wikiplugininline miniquiz",
// "wikiplugininline module" => "wikiplugininline module",
// "wikiplugininline mono" => "wikiplugininline mono",
// "wikiplugininline mouseover" => "wikiplugininline mouseover",
// "wikiplugininline mwtable" => "wikiplugininline mwtable",
// "wikiplugininline myspace" => "wikiplugininline myspace",
// "wikiplugininline objecthits" => "wikiplugininline objecthits",
// "wikiplugininline picture" => "wikiplugininline picture",
// "wikiplugininline pluginmanager" => "wikiplugininline pluginmanager",
// "wikiplugininline poll" => "wikiplugininline poll",
// "wikiplugininline profile" => "wikiplugininline profile",
// "wikiplugininline proposal" => "wikiplugininline proposal",
// "wikiplugininline quote" => "wikiplugininline quote",
// "wikiplugininline rcontent" => "wikiplugininline rcontent",
// "wikiplugininline redirect" => "wikiplugininline redirect",
// "wikiplugininline regex" => "wikiplugininline regex",
// "wikiplugininline remarksbox" => "wikiplugininline remarksbox",
// "wikiplugininline rss" => "wikiplugininline rss",
// "wikiplugininline sf" => "wikiplugininline sf",
// "wikiplugininline share" => "wikiplugininline share",
// "wikiplugininline sharethis" => "wikiplugininline sharethis",
// "wikiplugininline sheet" => "wikiplugininline sheet",
// "wikiplugininline showpages" => "wikiplugininline showpages",
// "wikiplugininline skype" => "wikiplugininline skype",
// "wikiplugininline snarf" => "wikiplugininline snarf",
// "wikiplugininline sort" => "wikiplugininline sort",
// "wikiplugininline split" => "wikiplugininline split",
// "wikiplugininline sql" => "wikiplugininline sql",
// "wikiplugininline sub" => "wikiplugininline sub",
// "wikiplugininline subscribegroup" => "wikiplugininline subscribegroup",
// "wikiplugininline subscribegroups" => "wikiplugininline subscribegroups",
// "wikiplugininline sup" => "wikiplugininline sup",
// "wikiplugininline survey" => "wikiplugininline survey",
// "wikiplugininline tag" => "wikiplugininline tag",
// "wikiplugininline thumb" => "wikiplugininline thumb",
// "wikiplugininline titlesearch" => "wikiplugininline titlesearch",
// "wikiplugininline toc" => "wikiplugininline toc",
// "wikiplugininline topfriends" => "wikiplugininline topfriends",
// "wikiplugininline trackerfilter" => "wikiplugininline trackerfilter",
// "wikiplugininline trackeritemfield" => "wikiplugininline trackeritemfield",
// "wikiplugininline trackerlist" => "wikiplugininline trackerlist",
// "wikiplugininline trackertimeline" => "wikiplugininline trackertimeline",
// "wikiplugininline tracker" => "wikiplugininline tracker",
// "wikiplugininline trackerprefill" => "wikiplugininline trackerprefill",
// "wikiplugininline trackerstat" => "wikiplugininline trackerstat",
// "wikiplugininline translated" => "wikiplugininline translated",
// "wikiplugininline tr" => "wikiplugininline tr",
// "wikiplugininline usercount" => "wikiplugininline usercount",
// "wikiplugininline userlist" => "wikiplugininline userlist",
// "wikiplugininline versions" => "wikiplugininline versions",
// "wikiplugininline vote" => "wikiplugininline vote",
// "wikiplugininline wantedpages" => "wikiplugininline wantedpages",
// "wikiplugininline webservice" => "wikiplugininline webservice",
// "wikiplugininline youtube" => "wikiplugininline youtube",
// "webservice consume defaultcache" => "webservice consume defaultcache",
// "feature wysiwyg" => "feature wysiwyg",
// "wysiwyg optional" => "wysiwyg optional",
// "wysiwyg default" => "wysiwyg default",
// "wysiwyg memo" => "wysiwyg memo",
// "wysiwyg wiki parsed" => "wysiwyg wiki parsed",
// "wysiwyg wiki semi parsed" => "wysiwyg wiki semi parsed",
// "wysiwyg toolbar skin" => "wysiwyg toolbar skin",
// "wysiwyg toolbar" => "wysiwyg toolbar",
// "wiki feature 3d" => "wiki feature 3d",
// "wiki 3d width" => "wiki 3d width",
// "wiki 3d height" => "wiki 3d height",
// "wiki 3d navigation depth" => "wiki 3d navigation depth",
// "wiki 3d feed animation interval" => "wiki 3d feed animation interval",
// "wiki 3d existing page color" => "wiki 3d existing page color",
// "wiki 3d missing page color" => "wiki 3d missing page color",
// "feature blogs" => "feature blogs",
// "blog list order" => "blog list order",
// "home blog" => "home blog",
// "feature blog rankings" => "feature blog rankings",
// "feature blog comments" => "feature blog comments",
// "blog comments default ordering" => "blog comments default ordering",
// "blog comments per page" => "blog comments per page",
// "feature blogposts comments" => "feature blogposts comments",
// "blog list user" => "blog list user",
// "blog list title" => "blog list title",
// "blog list title len" => "blog list title len",
// "blog list description" => "blog list description",
// "blog list created" => "blog list created",
// "blog list lastmodif" => "blog list lastmodif",
// "blog list posts" => "blog list posts",
// "blog list visits" => "blog list visits",
// "blog list activity" => "blog list activity",
// "feature blog mandatory category" => "feature blog mandatory category",
// "feature blog heading" => "feature blog heading",
// "feature file galleries" => "feature file galleries",
// "home file gallery" => "home file gallery",
// "fgal use db" => "fgal use db",
// "fgal batch dir" => "fgal batch dir",
// "fgal match regex" => "fgal match regex",
// "fgal nmatch regex" => "fgal nmatch regex",
// "fgal use dir" => "fgal use dir",
// "fgal podcast dir" => "fgal podcast dir",
// "feature file galleries comments" => "feature file galleries comments",
// "file galleries comments default ordering" => "file galleries comments default ordering",
// "file galleries comments per page" => "file galleries comments per page",
// "feature file galleries batch" => "feature file galleries batch",
// "feature file galleries rankings" => "feature file galleries rankings",
// "fgal enable auto indexing" => "fgal enable auto indexing",
// "fgal asynchronous indexing" => "fgal asynchronous indexing",
// "fgal allow duplicates" => "fgal allow duplicates",
// "fgal sort mode" => "fgal sort mode",
// "feature file galleries author" => "feature file galleries author",
// "fgal list id" => "fgal list id",
// "fgal list type" => "fgal list type",
// "fgal list name" => "fgal list name",
// "fgal list description" => "fgal list description",
// "fgal list size" => "fgal list size",
// "fgal list created" => "fgal list created",
// "fgal list lastmodif" => "fgal list lastmodif",
// "fgal list creator" => "fgal list creator",
// "fgal list author" => "fgal list author",
// "fgal list last user" => "fgal list last user",
// "fgal list comment" => "fgal list comment",
// "fgal list files" => "fgal list files",
// "fgal list hits" => "fgal list hits",
// "fgal list lockedby" => "fgal list lockedby",
// "fgal show path" => "fgal show path",
// "fgal show explorer" => "fgal show explorer",
// "fgal show slideshow" => "fgal show slideshow",
// "fgal default view" => "fgal default view",
// "fgal limit hits per file" => "fgal limit hits per file",
// "fgal prevent negative score" => "fgal prevent negative score",
// "feature galleries" => "feature galleries",
// "feature gal batch" => "feature gal batch",
// "feature gal slideshow" => "feature gal slideshow",
// "home gallery" => "home gallery",
// "gal use db" => "gal use db",
// "gal use lib" => "gal use lib",
// "gal match regex" => "gal match regex",
// "gal nmatch regex" => "gal nmatch regex",
// "gal use dir" => "gal use dir",
// "gal batch dir" => "gal batch dir",
// "feature gal rankings" => "feature gal rankings",
// "feature image galleries comments" => "feature image galleries comments",
// "image galleries comments default order" => "image galleries comments default order",
// "image galleries comments per page" => "image galleries comments per page",
// "gal list name" => "gal list name",
// "gal list parent" => "gal list parent",
// "gal list description" => "gal list description",
// "gal list created" => "gal list created",
// "gal list lastmodif" => "gal list lastmodif",
// "gal list user" => "gal list user",
// "gal list imgs" => "gal list imgs",
// "gal list visits" => "gal list visits",
// "feature image gallery mandatory category" => "feature image gallery mandatory category",
// "preset galleries info" => "preset galleries info",
// "gal image mouseover" => "gal image mouseover",
// "ProgressBarPlay" => "ProgressBarPlay",
// "ProgressBarLoad" => "ProgressBarLoad",
// "ProgressBarButton" => "ProgressBarButton",
// "ProgressBar" => "ProgressBar",
// "VolumeOn" => "VolumeOn",
// "VolumeOff" => "VolumeOff",
// "VolumeButton" => "VolumeButton",
// "Button" => "Button",
// "ButtonPressed" => "ButtonPressed",
// "ButtonOver" => "ButtonOver",
// "ButtonInfo" => "ButtonInfo",
// "ButtonInfoPressed" => "ButtonInfoPressed",
// "ButtonInfoOver" => "ButtonInfoOver",
// "ButtonInfoText" => "ButtonInfoText",
// "ID3" => "ID3",
// "PlayTime" => "PlayTime",
// "TotalTime" => "TotalTime",
// "PanelDisplay" => "PanelDisplay",
// "AlertMesg" => "AlertMesg",
// "PreloadDelay" => "PreloadDelay",
// "VideoHeight" => "VideoHeight",
// "VideoLength" => "VideoLength",
// "URLAppend" => "URLAppend",
// "LimitedMsg" => "LimitedMsg",
// "MaxPlay" => "MaxPlay",
// "MultimediaGalerie" => "MultimediaGalerie",
// "MultimediaDefaultLength" => "MultimediaDefaultLength",
// "MultimediaDefaultHeight" => "MultimediaDefaultHeight",
// "feature forums" => "feature forums",
// "home forum" => "home forum",
// "feature forum rankings" => "feature forum rankings",
// "feature forum parse" => "feature forum parse",
// "feature forum topics archiving" => "feature forum topics archiving",
// "feature forum replyempty" => "feature forum replyempty",
// "feature forum quickjump" => "feature forum quickjump",
// "feature forums allow thread titles" => "feature forums allow thread titles",
// "feature forum content search" => "feature forum content search",
// "feature forums name search" => "feature forums name search",
// "forums ordering" => "forums ordering",
// "forum list topics" => "forum list topics",
// "forum list posts" => "forum list posts",
// "forum list ppd" => "forum list ppd",
// "forum list lastpost" => "forum list lastpost",
// "forum list visits" => "forum list visits",
// "forum list desc" => "forum list desc",
// "forum list description len" => "forum list description len",
// "feature forum local search" => "feature forum local search",
// "feature forum local tiki search" => "feature forum local tiki search",
// "forum thread defaults by forum" => "forum thread defaults by forum",
// "forum thread user settings" => "forum thread user settings",
// "forum thread user settings keep" => "forum thread user settings keep",
// "forum comments per page" => "forum comments per page",
// "forum comments no title prefix" => "forum comments no title prefix",
// "forum thread style" => "forum thread style",
// "forum thread sort mode" => "forum thread sort mode",
// "forum match regex" => "forum match regex",
// "feature articles" => "feature articles",
// "feature submissions" => "feature submissions",
// "feature cms rankings" => "feature cms rankings",
// "feature cms print" => "feature cms print",
// "feature cms emails" => "feature cms emails",
// "art list title" => "art list title",
// "art list title len" => "art list title len",
// "art list topic" => "art list topic",
// "art list date" => "art list date",
// "art list author" => "art list author",
// "art list reads" => "art list reads",
// "art list size" => "art list size",
// "art list expire" => "art list expire",
// "art list img" => "art list img",
// "art list type" => "art list type",
// "art list visible" => "art list visible",
// "art view type" => "art view type",
// "art view title" => "art view title",
// "art view topic" => "art view topic",
// "art view date" => "art view date",
// "art view author" => "art view author",
// "art view reads" => "art view reads",
// "art view size" => "art view size",
// "art view img" => "art view img",
// "art list lang" => "art list lang",
// "feature article comments" => "feature article comments",
// "article comments default ordering" => "article comments default ordering",
// "article comments per page" => "article comments per page",
// "article image size x" => "article image size x",
// "article image size y" => "article image size y",
// "feature cms templates" => "feature cms templates",
// "cms bot bar" => "cms bot bar",
// "cms left column" => "cms left column",
// "cms right column" => "cms right column",
// "cms top bar" => "cms top bar",
// "cms spellcheck" => "cms spellcheck",
// "art home title" => "art home title",
// "feature trackers" => "feature trackers",
// "t use db" => "t use db",
// "t use dir" => "t use dir",
// "groupTracker" => "groupTracker",
// "userTracker" => "userTracker",
// "trk with mirror tables" => "trk with mirror tables",
// "feature userlevels" => "feature userlevels",
// "userlevels" => "userlevels",
// "userbreadCrumb" => "userbreadCrumb",
// "user assigned modules" => "user assigned modules",
// "user flip modules" => "user flip modules",
// "user show realnames" => "user show realnames",
// "feature mytiki" => "feature mytiki",
// "feature userPreferences" => "feature userPreferences",
// "feature user bookmarks" => "feature user bookmarks",
// "feature tasks" => "feature tasks",
// "w use db" => "w use db",
// "w use dir" => "w use dir",
// "w displayed default" => "w displayed default",
// "uf use db" => "uf use db",
// "uf use dir" => "uf use dir",
// "userfiles quota" => "userfiles quota",
// "feature usermenu" => "feature usermenu",
// "feature minical" => "feature minical",
// "feature notepad" => "feature notepad",
// "feature userfiles" => "feature userfiles",
// "feature community gender" => "feature community gender",
// "feature community mouseover" => "feature community mouseover",
// "feature community mouseover name" => "feature community mouseover name",
// "feature community mouseover gender" => "feature community mouseover gender",
// "feature community mouseover picture" => "feature community mouseover picture",
// "feature community mouseover friends" => "feature community mouseover friends",
// "feature community mouseover score" => "feature community mouseover score",
// "feature community mouseover country" => "feature community mouseover country",
// "feature community mouseover email" => "feature community mouseover email",
// "feature community mouseover lastlogin" => "feature community mouseover lastlogin",
// "feature community mouseover distance" => "feature community mouseover distance",
// "feature community list name" => "feature community list name",
// "feature community list score" => "feature community list score",
// "feature community list country" => "feature community list country",
// "feature community list distance" => "feature community list distance",
// "feature community friends permission" => "feature community friends permission",
// "feature community friends permission dep" => "feature community friends permission dep",
// "change language" => "change language",
// "change theme" => "change theme",
// "login is email" => "login is email",
// "validateUsers" => "validateUsers",
// "validateEmail" => "validateEmail",
// "forgotPass" => "forgotPass",
// "available languages" => "available languages",
// "available styles" => "available styles",
// "lowercase username" => "lowercase username",
// "username pattern" => "username pattern",
// "max username length" => "max username length",
// "min username length" => "min username length",
// "users prefs allowMsgs" => "users prefs allowMsgs",
// "users prefs country" => "users prefs country",
// "users prefs diff versions" => "users prefs diff versions",
// "users prefs display timezone" => "users prefs display timezone",
// "users prefs email is public" => "users prefs email is public",
// "users prefs homePage" => "users prefs homePage",
// "users prefs lat" => "users prefs lat",
// "users prefs lon" => "users prefs lon",
// "users prefs mess archiveAfter" => "users prefs mess archiveAfter",
// "users prefs mess maxRecords" => "users prefs mess maxRecords",
// "users prefs mess sendReadStatus" => "users prefs mess sendReadStatus",
// "users prefs minPrio" => "users prefs minPrio",
// "users prefs mytiki blogs" => "users prefs mytiki blogs",
// "users prefs mytiki articles" => "users prefs mytiki articles",
// "users prefs mytiki gals" => "users prefs mytiki gals",
// "users prefs mytiki items" => "users prefs mytiki items",
// "users prefs mytiki msgs" => "users prefs mytiki msgs",
// "users prefs mytiki pages" => "users prefs mytiki pages",
// "users prefs mytiki tasks" => "users prefs mytiki tasks",
// "users prefs mytiki workflow" => "users prefs mytiki workflow",
// "users prefs mytiki forum topics" => "users prefs mytiki forum topics",
// "users prefs mytiki forum replies" => "users prefs mytiki forum replies",
// "users prefs realName" => "users prefs realName",
// "users prefs gender" => "users prefs gender",
// "users prefs show mouseover user info" => "users prefs show mouseover user info",
// "users prefs tasks maxRecords" => "users prefs tasks maxRecords",
// "users prefs user dbl" => "users prefs user dbl",
// "users prefs user information" => "users prefs user information",
// "users prefs userbreadCrumb" => "users prefs userbreadCrumb",
// "users prefs mailCharset" => "users prefs mailCharset",
// "validateRegistration" => "validateRegistration",
// "feature messages" => "feature messages",
// "messu mailbox size" => "messu mailbox size",
// "messu archive size" => "messu archive size",
// "messu sent size" => "messu sent size",
// "allowmsg by default" => "allowmsg by default",
// "allowmsg is optional" => "allowmsg is optional",
// "feature newsreader" => "feature newsreader",
// "feature freetags" => "feature freetags",
// "freetags browse show cloud" => "freetags browse show cloud",
// "freetags cloud colors" => "freetags cloud colors",
// "freetags preload random search" => "freetags preload random search",
// "freetags browse amount tags in cloud" => "freetags browse amount tags in cloud",
// "freetags browse amount tags suggestion" => "freetags browse amount tags suggestion",
// "freetags normalized valid chars" => "freetags normalized valid chars",
// "freetags lowercase only" => "freetags lowercase only",
// "freetags feature 3d" => "freetags feature 3d",
// "freetags 3d width" => "freetags 3d width",
// "freetags 3d height" => "freetags 3d height",
// "freetags 3d navigation depth" => "freetags 3d navigation depth",
// "freetags 3d feed animation interval" => "freetags 3d feed animation interval",
// "freetags 3d existing page color" => "freetags 3d existing page color",
// "freetags 3d missing page color" => "freetags 3d missing page color",
// "freetags 3d autoload" => "freetags 3d autoload",
// "freetags 3d camera distance" => "freetags 3d camera distance",
// "freetags 3d elastic constant" => "freetags 3d elastic constant",
// "freetags 3d eletrostatic constant" => "freetags 3d eletrostatic constant",
// "freetags 3d fov" => "freetags 3d fov",
// "freetags 3d friction constant" => "freetags 3d friction constant",
// "freetags 3d node charge" => "freetags 3d node charge",
// "freetags 3d node mass" => "freetags 3d node mass",
// "freetags 3d node size" => "freetags 3d node size",
// "freetags 3d spring size" => "freetags 3d spring size",
// "freetags 3d text size" => "freetags 3d text size",
// "freetags 3d adjust camera" => "freetags 3d adjust camera",
// "freetags multilingual" => "freetags multilingual",
// "morelikethis algorithm" => "morelikethis algorithm",
// "morelikethis basic mincommon" => "morelikethis basic mincommon",
// "freetags show middle" => "freetags show middle",
// "feature search stats" => "feature search stats",
// "feature search" => "feature search",
// "feature search fulltext" => "feature search fulltext",
// "feature search show forbidden obj" => "feature search show forbidden obj",
// "feature search show forbidden cat" => "feature search show forbidden cat",
// "feature search show object filter" => "feature search show object filter",
// "feature search show search box" => "feature search show search box",
// "feature search show visit count" => "feature search show visit count",
// "feature search show pertinence" => "feature search show pertinence",
// "feature search show object type" => "feature search show object type",
// "feature search show last modification" => "feature search show last modification",
// "search refresh index mode" => "search refresh index mode",
// "search parsed snippet" => "search parsed snippet",
// "feature webmail" => "feature webmail",
// "webmail max attachment" => "webmail max attachment",
// "webmail view html" => "webmail view html",
// "feature contacts" => "feature contacts",
// "feature faqs" => "feature faqs",
// "feature faq comments" => "feature faq comments",
// "faq comments per page" => "faq comments per page",
// "faq comments default ordering" => "faq comments default ordering",
// "faq prefix" => "faq prefix",
// "feature quizzes" => "feature quizzes",
// "feature polls" => "feature polls",
// "feature poll comments" => "feature poll comments",
// "feature poll anonymous" => "feature poll anonymous",
// "poll comments default ordering" => "poll comments default ordering",
// "poll comments per page" => "poll comments per page",
// "poll list categories" => "poll list categories",
// "poll list objects" => "poll list objects",
// "feature poll revote" => "feature poll revote",
// "feature surveys" => "feature surveys",
// "feature featuredLinks" => "feature featuredLinks",
// "feature directory" => "feature directory",
// "directory columns" => "directory columns",
// "directory links per page" => "directory links per page",
// "directory open links" => "directory open links",
// "directory validate urls" => "directory validate urls",
// "directory cool sites" => "directory cool sites",
// "directory country flag" => "directory country flag",
// "feature calendar" => "feature calendar",
// "feature default calendars" => "feature default calendars",
// "calendar sticky popup" => "calendar sticky popup",
// "default calendars" => "default calendars",
// "calendar view mode" => "calendar view mode",
// "calendar view tab" => "calendar view tab",
// "calendar firstDayofWeek" => "calendar firstDayofWeek",
// "calendar timespan" => "calendar timespan",
// "feature jscalendar" => "feature jscalendar",
// "feature action calendar" => "feature action calendar",
// "calendar start year" => "calendar start year",
// "calendar end year" => "calendar end year",
// "calendar list begins focus" => "calendar list begins focus",
// "server timezone" => "server timezone",
// "long date format" => "long date format",
// "long time format" => "long time format",
// "short date format" => "short date format",
// "short time format" => "short time format",
// "display field order" => "display field order",
// "feature charts" => "feature charts",
// "rss forums" => "rss forums",
// "rss forum" => "rss forum",
// "rss directories" => "rss directories",
// "rss articles" => "rss articles",
// "rss blogs" => "rss blogs",
// "rss image galleries" => "rss image galleries",
// "rss file galleries" => "rss file galleries",
// "rss wiki" => "rss wiki",
// "rss image gallery" => "rss image gallery",
// "rss file gallery" => "rss file gallery",
// "rss blog" => "rss blog",
// "rss tracker" => "rss tracker",
// "rss trackers" => "rss trackers",
// "rss calendar" => "rss calendar",
// "rss mapfiles" => "rss mapfiles",
// "rss cache time" => "rss cache time",
// "max rss forums" => "max rss forums",
// "max rss forum" => "max rss forum",
// "max rss directories" => "max rss directories",
// "max rss articles" => "max rss articles",
// "max rss blogs" => "max rss blogs",
// "max rss image galleries" => "max rss image galleries",
// "max rss file galleries" => "max rss file galleries",
// "max rss wiki" => "max rss wiki",
// "max rss image gallery" => "max rss image gallery",
// "max rss file gallery" => "max rss file gallery",
// "max rss blog" => "max rss blog",
// "max rss mapfiles" => "max rss mapfiles",
// "max rss tracker" => "max rss tracker",
// "max rss trackers" => "max rss trackers",
// "max rss calendar" => "max rss calendar",
// "summary rss blogs" => "summary rss blogs",
// "rssfeed default version" => "rssfeed default version",
// "rssfeed language" => "rssfeed language",
// "rssfeed editor" => "rssfeed editor",
// "rssfeed webmaster" => "rssfeed webmaster",
// "rssfeed creator" => "rssfeed creator",
// "rssfeed css" => "rssfeed css",
// "rssfeed publisher" => "rssfeed publisher",
// "rssfeed img" => "rssfeed img",
// "rss basic auth" => "rss basic auth",
// "feature maps" => "feature maps",
// "map path" => "map path",
// "default map" => "default map",
// "map help" => "map help",
// "map comments" => "map comments",
// "gdaltindex" => "gdaltindex",
// "ogr2ogr" => "ogr2ogr",
// "mapzone" => "mapzone",
// "feature gmap" => "feature gmap",
// "gmap defaultx" => "gmap defaultx",
// "gmap defaulty" => "gmap defaulty",
// "gmap defaultz" => "gmap defaultz",
// "gmap key" => "gmap key",
// "allowRegister" => "allowRegister",
// "eponymousGroups" => "eponymousGroups",
// "useRegisterPasscode" => "useRegisterPasscode",
// "registerPasscode" => "registerPasscode",
// "rememberme" => "rememberme",
// "remembertime" => "remembertime",
// "feature clear passwords" => "feature clear passwords",
// "feature crypt passwords" => "feature crypt passwords",
// "feature challenge" => "feature challenge",
// "min user length" => "min user length",
// "min pass length" => "min pass length",
// "pass chr num" => "pass chr num",
// "pass due" => "pass due",
// "email due" => "email due",
// "unsuccessful logins" => "unsuccessful logins",
// "rnd num reg" => "rnd num reg",
// "generate password" => "generate password",
// "auth method" => "auth method",
// "auth pear" => "auth pear",
// "auth create user tiki" => "auth create user tiki",
// "auth create user auth" => "auth create user auth",
// "auth skip admin" => "auth skip admin",
// "auth ldap url" => "auth ldap url",
// "auth pear host" => "auth pear host",
// "auth pear port" => "auth pear port",
// "auth ldap scope" => "auth ldap scope",
// "auth ldap basedn" => "auth ldap basedn",
// "auth ldap userdn" => "auth ldap userdn",
// "auth ldap userattr" => "auth ldap userattr",
// "auth ldap useroc" => "auth ldap useroc",
// "auth ldap groupdn" => "auth ldap groupdn",
// "auth ldap groupattr" => "auth ldap groupattr",
// "auth ldap groupoc" => "auth ldap groupoc",
// "auth ldap memberattr" => "auth ldap memberattr",
// "auth ldap memberisdn" => "auth ldap memberisdn",
// "auth ldap adminuser" => "auth ldap adminuser",
// "auth ldap adminpass" => "auth ldap adminpass",
// "auth ldap version" => "auth ldap version",
// "auth ldap nameattr" => "auth ldap nameattr",
// "auth ldap countryattr" => "auth ldap countryattr",
// "auth ldap emailattr" => "auth ldap emailattr",
// "https login" => "https login",
// "feature show stay in ssl mode" => "feature show stay in ssl mode",
// "feature switch ssl mode" => "feature switch ssl mode",
// "https port" => "https port",
// "http port" => "http port",
// "login url" => "login url",
// "login scr" => "login scr",
// "register url" => "register url",
// "error url" => "error url",
// "highlight group" => "highlight group",
// "cookie path" => "cookie path",
// "cookie domain" => "cookie domain",
// "cookie name" => "cookie name",
// "user tracker infos" => "user tracker infos",
// "desactive login autocomplete" => "desactive login autocomplete",
// "permission denied login box" => "permission denied login box",
// "permission denied url" => "permission denied url",
// "feature intertiki" => "feature intertiki",
// "feature intertiki server" => "feature intertiki server",
// "feature intertiki slavemode" => "feature intertiki slavemode",
// "interlist" => "interlist",
// "feature intertiki mymaster" => "feature intertiki mymaster",
// "feature intertiki import preferences" => "feature intertiki import preferences",
// "feature intertiki import groups" => "feature intertiki import groups",
// "known hosts" => "known hosts",
// "tiki key" => "tiki key",
// "intertiki logfile" => "intertiki logfile",
// "intertiki errfile" => "intertiki errfile",
// "feature intertiki sharedcookie" => "feature intertiki sharedcookie",
// "search lru length" => "search lru length",
// "search lru purge rate" => "search lru purge rate",
// "search max syllwords" => "search max syllwords",
// "search min wordlength" => "search min wordlength",
// "search refresh rate" => "search refresh rate",
// "search syll age" => "search syll age",
// "feature categories" => "feature categories",
// "feature categoryobjects" => "feature categoryobjects",
// "feature categorypath" => "feature categorypath",
// "feature category reinforce" => "feature category reinforce",
// "feature category use phplayers" => "feature category use phplayers",
// "categorypath excluded" => "categorypath excluded",
// "categories used in tpl" => "categories used in tpl",
// "feature games" => "feature games",
// "feature html pages" => "feature html pages",
// "feature filegals manager" => "feature filegals manager",
// "feature contact" => "feature contact",
// "contact user" => "contact user",
// "contact anon" => "contact anon",
// "mail crlf" => "mail crlf",
// "feature detect language" => "feature detect language",
// "feature homePage if bl missing" => "feature homePage if bl missing",
// "record untranslated" => "record untranslated",
// "feature best language" => "feature best language",
// "feature translation" => "feature translation",
// "feature urgent translation" => "feature urgent translation",
// "lang use db" => "lang use db",
// "language" => "language",
// "feature babelfish" => "feature babelfish",
// "feature babelfish logo" => "feature babelfish logo",
// "quantify changes" => "quantify changes",
// "feature sync language" => "feature sync language",
// "show available translations" => "show available translations",
// "metatag keywords" => "metatag keywords",
// "metatag threadtitle" => "metatag threadtitle",
// "metatag imagetitle" => "metatag imagetitle",
// "metatag freetags" => "metatag freetags",
// "metatag description" => "metatag description",
// "metatag author" => "metatag author",
// "metatag geoposition" => "metatag geoposition",
// "metatag georegion" => "metatag georegion",
// "metatag geoplacename" => "metatag geoplacename",
// "metatag robots" => "metatag robots",
// "metatag revisitafter" => "metatag revisitafter",
// "head extra js" => "head extra js",
// "keep versions" => "keep versions",
// "feature custom home" => "feature custom home",
// "site crumb seper" => "site crumb seper",
// "site nav seper" => "site nav seper",
// "feature sitemycode" => "feature sitemycode",
// "sitemycode" => "sitemycode",
// "sitemycode publish" => "sitemycode publish",
// "feature sitelogo" => "feature sitelogo",
// "sitelogo bgcolor" => "sitelogo bgcolor",
// "sitelogo bgstyle" => "sitelogo bgstyle",
// "sitelogo align" => "sitelogo align",
// "sitelogo title" => "sitelogo title",
// "sitelogo src" => "sitelogo src",
// "sitelogo alt" => "sitelogo alt",
// "feature siteloc" => "feature siteloc",
// "feature sitenav" => "feature sitenav",
// "sitenav" => "sitenav",
// "feature sitead" => "feature sitead",
// "sitead" => "sitead",
// "sitead publish" => "sitead publish",
// "feature breadcrumbs" => "feature breadcrumbs",
// "feature siteloclabel" => "feature siteloclabel",
// "feature sitesearch" => "feature sitesearch",
// "feature site login" => "feature site login",
// "feature sitemenu" => "feature sitemenu",
// "feature topbar version" => "feature topbar version",
// "feature topbar debug" => "feature topbar debug",
// "feature topbar id menu" => "feature topbar id menu",
// "feature topbar custom code" => "feature topbar custom code",
// "feature sitetitle" => "feature sitetitle",
// "feature sitedesc" => "feature sitedesc",
// "feature bot logo" => "feature bot logo",
// "feature endbody code" => "feature endbody code",
// "feature left column" => "feature left column",
// "feature right column" => "feature right column",
// "feature top bar" => "feature top bar",
// "feature bot bar" => "feature bot bar",
// "feature bot bar icons" => "feature bot bar icons",
// "feature bot bar debug" => "feature bot bar debug",
// "feature bot bar rss" => "feature bot bar rss",
// "feature bot bar power by tw" => "feature bot bar power by tw",
// "maxRecords" => "maxRecords",
// "maxArticles" => "maxArticles",
// "maxVersions" => "maxVersions",
// "feature view tpl" => "feature view tpl",
// "slide style" => "slide style",
// "site favicon" => "site favicon",
// "site favicon type" => "site favicon type",
// "style" => "style",
// "style option" => "style option",
// "site style" => "site style",
// "site style option" => "site style option",
// "use context menu icon" => "use context menu icon",
// "use context menu text" => "use context menu text",
// "feature site report" => "feature site report",
// "feature site send link" => "feature site send link",
// "feature layoutshadows" => "feature layoutshadows",
// "main shadow start" => "main shadow start",
// "main shadow end" => "main shadow end",
// "header shadow start" => "header shadow start",
// "header shadow end" => "header shadow end",
// "middle shadow start" => "middle shadow start",
// "middle shadow end" => "middle shadow end",
// "center shadow start" => "center shadow start",
// "center shadow end" => "center shadow end",
// "footer shadow start" => "footer shadow start",
// "footer shadow end" => "footer shadow end",
// "feature mods provider" => "feature mods provider",
// "mods dir" => "mods dir",
// "mods server" => "mods server",
// "feature experimental" => "feature experimental",
// "feature actionlog" => "feature actionlog",
// "feature actionlog bytes" => "feature actionlog bytes",
// "browsertitle" => "browsertitle",
// "tmpDir" => "tmpDir",
// "feature tell a friend" => "feature tell a friend",
// "feature copyright" => "feature copyright",
// "feature multimedia" => "feature multimedia",
// "feature swfobj" => "feature swfobj",
// "feature smileys" => "feature smileys",
// "popupLinks" => "popupLinks",
// "feature autolinks" => "feature autolinks",
// "quicktags over textarea" => "quicktags over textarea",
// "default rows textarea wiki" => "default rows textarea wiki",
// "default rows textarea comment" => "default rows textarea comment",
// "default rows textarea forum" => "default rows textarea forum",
// "default rows textarea forumthread" => "default rows textarea forumthread",
// "feature floating help" => "feature floating help",
// "direct pagination" => "direct pagination",
// "nextprev pagination" => "nextprev pagination",
// "pagination firstlast" => "pagination firstlast",
// "pagination hide if one page" => "pagination hide if one page",
// "pagination icons" => "pagination icons",
// "pagination fastmove links" => "pagination fastmove links",
// "direct pagination max middle links" => "direct pagination max middle links",
// "direct pagination max ending links" => "direct pagination max ending links",
// "anonCanEdit" => "anonCanEdit",
// "cacheimages" => "cacheimages",
// "cachepages" => "cachepages",
// "count admin pvs" => "count admin pvs",
// "default mail charset" => "default mail charset",
// "error reporting adminonly" => "error reporting adminonly",
// "error reporting level" => "error reporting level",
// "smarty notice reporting" => "smarty notice reporting",
// "smarty security" => "smarty security",
// "feature ajax" => "feature ajax",
// "feature ajax autosave" => "feature ajax autosave",
// "feature antibot" => "feature antibot",
// "feature banners" => "feature banners",
// "feature banning" => "feature banning",
// "feature comm" => "feature comm",
// "feature contribution" => "feature contribution",
// "feature contribution display in comment" => "feature contribution display in comment",
// "feature contribution mandatory" => "feature contribution mandatory",
// "feature contribution mandatory blog" => "feature contribution mandatory blog",
// "feature contribution mandatory comment" => "feature contribution mandatory comment",
// "feature contribution mandatory forum" => "feature contribution mandatory forum",
// "feature debug console" => "feature debug console",
// "feature debugger console" => "feature debugger console",
// "feature display my to others" => "feature display my to others",
// "feature drawings" => "feature drawings",
// "feature dynamic content" => "feature dynamic content",
// "feature edit templates" => "feature edit templates",
// "feature editcss" => "feature editcss",
// "feature events" => "feature events",
// "feature friends" => "feature friends",
// "feature fullscreen" => "feature fullscreen",
// "feature help" => "feature help",
// "feature hotwords" => "feature hotwords",
// "feature hotwords nw" => "feature hotwords nw",
// "feature integrator" => "feature integrator",
// "feature live support" => "feature live support",
// "feature mailin" => "feature mailin",
// "feature menusfolderstyle" => "feature menusfolderstyle",
// "feature mobile" => "feature mobile",
// "feature modulecontrols" => "feature modulecontrols",
// "feature morcego" => "feature morcego",
// "feature multilingual" => "feature multilingual",
// "feature multilingual one page" => "feature multilingual one page",
// "feature multilingual structures" => "feature multilingual structures",
// "feature newsletters" => "feature newsletters",
// "feature obzip" => "feature obzip",
// "feature phplayers" => "feature phplayers",
// "feature cssmenus" => "feature cssmenus",
// "feature projects" => "feature projects",
// "feature ranking" => "feature ranking",
// "feature redirect on error" => "feature redirect on error",
// "feature referer highlight" => "feature referer highlight",
// "feature referer stats" => "feature referer stats",
// "feature score" => "feature score",
// "feature sheet" => "feature sheet",
// "feature shoutbox" => "feature shoutbox",
// "feature source" => "feature source",
// "feature stats" => "feature stats",
// "feature tabs" => "feature tabs",
// "feature theme control" => "feature theme control",
// "feature ticketlib" => "feature ticketlib",
// "feature ticketlib2" => "feature ticketlib2",
// "feature top banner" => "feature top banner",
// "feature usability" => "feature usability",
// "feature use quoteplugin" => "feature use quoteplugin",
// "feature user watches" => "feature user watches",
// "feature group watches" => "feature group watches",
// "feature user watches translations" => "feature user watches translations",
// "feature workflow" => "feature workflow",
// "feature xmlrpc" => "feature xmlrpc",
// "helpurl" => "helpurl",
// "layout section" => "layout section",
// "limitedGoGroupHome" => "limitedGoGroupHome",
// "minical reminders" => "minical reminders",
// "modallgroups" => "modallgroups",
// "modseparateanon" => "modseparateanon",
// "php docroot" => "php docroot",
// "proxy host" => "proxy host",
// "proxy port" => "proxy port",
// "ip can be checked" => "ip can be checked",
// "sender email" => "sender email",
// "feature site report email" => "feature site report email",
// "session db" => "session db",
// "session lifetime" => "session lifetime",
// "shoutbox autolink" => "shoutbox autolink",
// "show comzone" => "show comzone",
// "system os" => "system os",
// "tikiIndex" => "tikiIndex",
// "urlIndex" => "urlIndex",
// "useGroupHome" => "useGroupHome",
// "useGroupTheme" => "useGroupTheme",
// "useUrlIndex" => "useUrlIndex",
// "use proxy" => "use proxy",
// "user list order" => "user list order",
// "webserverauth" => "webserverauth",
// "feature purifier" => "feature purifier",
// "feature shadowbox" => "feature shadowbox",
// "log sql" => "log sql",
// "log sql perf min" => "log sql perf min",
// "log mail" => "log mail",
// "log tpl" => "log tpl",
// "case patched" => "case patched",
// "site closed" => "site closed",
// "site closed msg" => "site closed msg",
// "use load threshold" => "use load threshold",
// "load threshold" => "load threshold",
// "site busy msg" => "site busy msg",
// "bot logo code" => "bot logo code",
// "feature blogposts pings" => "feature blogposts pings",
// "feature create webhelp" => "feature create webhelp",
// "feature forums search" => "feature forums search",
// "feature trackbackpings" => "feature trackbackpings",
// "feature wiki ext icon" => "feature wiki ext icon",
// "feature wiki mandatory category" => "feature wiki mandatory category",
// "feature intertiki imported groups" => "feature intertiki imported groups",
// "feature wiki history ip" => "feature wiki history ip",
// "pam create user tiki" => "pam create user tiki",
// "pam service" => "pam service",
// "pam skip admin" => "pam skip admin",
// "shib affiliation" => "shib affiliation",
// "shib create user tiki" => "shib create user tiki",
// "shib group" => "shib group",
// "shib skip admin" => "shib skip admin",
// "shib usegroup" => "shib usegroup",
// "wiki 3d camera distance" => "wiki 3d camera distance",
// "wiki 3d elastic constant" => "wiki 3d elastic constant",
// "wiki 3d eletrostatic constant" => "wiki 3d eletrostatic constant",
// "wiki 3d fov" => "wiki 3d fov",
// "wiki 3d friction constant" => "wiki 3d friction constant",
// "wiki 3d node charge" => "wiki 3d node charge",
// "wiki 3d node mass" => "wiki 3d node mass",
// "wiki 3d node size" => "wiki 3d node size",
// "wiki 3d spring size" => "wiki 3d spring size",
// "wiki 3d text size" => "wiki 3d text size",
// "articles feature copyrights" => "articles feature copyrights",
// "blogues feature copyrights" => "blogues feature copyrights",
// "faqs feature copyrights" => "faqs feature copyrights",
// "feature contributor wiki" => "feature contributor wiki",
// "https login required" => "https login required",
// "maxRowsGalleries" => "maxRowsGalleries",
// "replimaster" => "replimaster",
// "rowImagesGalleries" => "rowImagesGalleries",
// "scaleSizeGalleries" => "scaleSizeGalleries",
// "thumbSizeXGalleries" => "thumbSizeXGalleries",
// "thumbSizeYGalleries" => "thumbSizeYGalleries",
// "wiki 3d adjust camera" => "wiki 3d adjust camera",
// "wiki 3d autoload" => "wiki 3d autoload",
// "feature mootools" => "feature mootools",
// "javascript enabled" => "javascript enabled",
// "feature comments post as anonymous" => "feature comments post as anonymous",
// "feature comments moderation" => "feature comments moderation",
// "feature comments locking" => "feature comments locking",
// "feature template zoom" => "feature template zoom",
// "feature iepngfix" => "feature iepngfix",
// "iepngfix selectors" => "iepngfix selectors",
// "iepngfix elements" => "iepngfix elements",
// "use minified scripts" => "use minified scripts",
// "valid email regex" => "valid email regex",
// "feature jquery" => "feature jquery",
// "jquery effect" => "jquery effect",
// "jquery effect direction" => "jquery effect direction",
// "jquery effect speed" => "jquery effect speed",
// "jquery effect tabs" => "jquery effect tabs",
// "jquery effect tabs direction" => "jquery effect tabs direction",
// "jquery effect tabs speed" => "jquery effect tabs speed",
// "feature jquery ui" => "feature jquery ui",
// "feature jquery tooltips" => "feature jquery tooltips",
// "feature jquery autocomplete" => "feature jquery autocomplete",
// "feature jquery superfish" => "feature jquery superfish",
// "feature jquery reflection" => "feature jquery reflection",
// "feature jquery sheet" => "feature jquery sheet",
// "feature jquery tablesorter" => "feature jquery tablesorter",
// "feature jquery cycle" => "feature jquery cycle",
// "feature sefurl" => "feature sefurl",
// "feature sefurl filter" => "feature sefurl filter",
// "feature sefurl paths" => "feature sefurl paths",
// "feature sefurl title article" => "feature sefurl title article",
// "feature sefurl title blog" => "feature sefurl title blog",
// "feature tikitests" => "feature tikitests",
// "feature magic" => "feature magic",
// "profile sources" => "profile sources",
// "profile channels" => "profile channels",
// "feature minichat" => "feature minichat",
// "feature pear date" => "feature pear date",
// "feature bidi" => "feature bidi",
// "feature lastup" => "feature lastup",
// "transition style ver" => "transition style ver",
// "magic last load" => "magic last load",
// "feature groupalert" => "feature groupalert",
// "lib spellcheck" => "lib spellcheck",
// "wiki spellcheck" => "wiki spellcheck",
// "blog spellcheck" => "blog spellcheck",
// "allowMsgs" => "allowMsgs",
// "diff versions" => "diff versions",
// "display timezone" => "display timezone",
// "email is public" => "email is public",
// "homePage" => "homePage",
// "lat" => "lat",
// "lon" => "lon",
// "mess archiveAfter" => "mess archiveAfter",
// "mess maxRecords" => "mess maxRecords",
// "mess sendReadStatus" => "mess sendReadStatus",
// "minPrio" => "minPrio",
// "mytiki blogs" => "mytiki blogs",
// "mytiki articles" => "mytiki articles",
// "mytiki gals" => "mytiki gals",
// "mytiki items" => "mytiki items",
// "mytiki msgs" => "mytiki msgs",
// "mytiki pages" => "mytiki pages",
// "mytiki tasks" => "mytiki tasks",
// "mytiki workflow" => "mytiki workflow",
// "mytiki forum topics" => "mytiki forum topics",
// "mytiki forum replies" => "mytiki forum replies",
// "realName" => "realName",
// "gender" => "gender",
// "show mouseover user info" => "show mouseover user info",
// "tasks maxRecords" => "tasks maxRecords",
// "user dbl" => "user dbl",
// "user information" => "user information",
// "mailCharset" => "mailCharset",
// "Anti-Bot verification code" => "Anti-Bot verification code",
// "Enter the code you see above" => "Enter the code you see above",
// "Download" => "Download",
// "more info" => "more info",
// "Group Monitor" => "Group Monitor",
// "Watched by categories" => "Watched by categories",
// "Categorize" => "Categorize",
// "Select Categories" => "Select Categories",
// "Admin Categories" => "Admin Categories",
// "Select/deselect all categories" => "Select/deselect all categories",
// "Browse Category" => "Browse Category",
// "top of page" => "top of page",
// "Reply" => "Reply",
// "Report this post" => "Report this post",
// "Errors" => "Errors",
// "Comments Locked" => "Comments Locked",
// "Plain" => "Plain",
// "Threaded" => "Threaded",
// "Headers Only" => "Headers Only",
// "Newest first" => "Newest first",
// "Oldest first" => "Oldest first",
// "below your current threshold" => "below your current threshold",
// "Comments are locked" => "Comments are locked",
// "Note" => "Note",
// "New Reply" => "New Reply",
// "Editing reply" => "Editing reply",
// "Reply to the selected post" => "Reply to the selected post",
// "Post new message" => "Post new message",
// "Comment on the selected post" => "Comment on the selected post",
// "required" => "required",
// "Quicktags" => "Quicktags",
// "Maximum size" => "Maximum size",
// "Enter your name" => "Enter your name",
// "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address" => "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address",
// "Reply to parent post" => "Reply to parent post",
// "Post new reply" => "Post new reply",
// "Please note that the preview does not keep the attached file which you will have to choose before posting" => "Please note that the preview does not keep the attached file which you will have to choose before posting",
// "Post as Anonymous" => "Post as Anonymous",
// "Your comment will have to be approved by the moderator before it is displayed" => "Your comment will have to be approved by the moderator before it is displayed",
// "Posting replies" => "Posting replies",
// "HTML tags are not allowed inside posts" => "HTML tags are not allowed inside posts",
// "Type of contribution" => "Type of contribution",
// "Contributors" => "Contributors",
// "Duplicate File Gallery" => "Duplicate File Gallery",
// "Duplicate categories" => "Duplicate categories",
// "Duplicate perms" => "Duplicate perms",
// "View inserted gallery" => "View inserted gallery",
// "Display Properties" => "Display Properties",
// "required field for podcasts" => "required field for podcasts",
// "any file" => "any file",
// "podcast (audio)" => "podcast (audio)",
// "podcast (video)" => "podcast (video)",
// "This Gallery is Public" => "This Gallery is Public",
// "Users with perms and not only the owner of the gallery can upload in it" => "Users with perms and not only the owner of the gallery can upload in it",
// "The files can be locked at download" => "The files can be locked at download",
// "Maximum number of archives for each file" => "Maximum number of archives for each file",
// "unlimited" => "unlimited",
// "Parent gallery" => "Parent gallery",
// "Owner of the gallery" => "Owner of the gallery",
// "Group of users alerted when file gallery is modified" => "Group of users alerted when file gallery is modified",
// "Allows to select each user for small groups" => "Allows to select each user for small groups",
// "Default sort order" => "Default sort order",
// "descending" => "descending",
// "ascending" => "ascending",
// "Please login" => "Please login",
// "Perhaps you were looking for" => "Perhaps you were looking for",
// "There are no wiki pages similar to '{\$page}'" => "There are no wiki pages similar to '{\$page}'",
// "Go to Login Page" => "Go to Login Page",
// "Create this page" => "Create this page",
// "(page will be orphaned)" => "(page will be orphaned)",
// "Close Window" => "Close Window",
// "Go to" => "Go to",
// "Private Gallery" => "Private Gallery",
// "Active Perms" => "Active Perms",
// "Archives" => "Archives",
// "Upload New Version" => "Upload New Version",
// "Replace" => "Replace",
// "Download and lock" => "Download and lock",
// "Show as a column" => "Show as a column",
// "Show in popup box" => "Show in popup box",
// "Both" => "Both",
// "Show an icon in a column" => "Show an icon in a column",
// "Exact&nbsp;match" => "Exact&nbsp;match",
// "any type" => "any type",
// "all topic" => "all topic",
// "any language" => "any language",
// "not in" => "not in",
// "any category" => "any category",
// "Clear Filter" => "Clear Filter",
// "Show php error messages" => "Show php error messages",
// "Folksonomy Tags" => "Folksonomy Tags",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together" => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together",
// "Tags" => "Tags",
// "Translate tags" => "Translate tags",
// "Images Galleries" => "Images Galleries",
// "RSS Wiki" => "RSS Wiki",
// "RSS Blogs" => "RSS Blogs",
// "RSS Articles" => "RSS Articles",
// "RSS Image Galleries" => "RSS Image Galleries",
// "RSS File Galleries" => "RSS File Galleries",
// "RSS Forums" => "RSS Forums",
// "RSS Maps" => "RSS Maps",
// "RSS Directories" => "RSS Directories",
// "RSS Calendars" => "RSS Calendars",
// "You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page" => "You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page",
// "Loading" => "Loading",
// "\\074span class=\"shortcut\"\\076C\\074/span\\076lose" => "\\074span class=\"shortcut\"\\076C\\074/span\\076lose",
// "\\074span class=\"shortcut\"\\076N\\074/span\\076ext" => "\\074span class=\"shortcut\"\\076N\\074/span\\076ext",
// "\\074span class=\"shortcut\"\\076P\\074/span\\076revious" => "\\074span class=\"shortcut\"\\076P\\074/span\\076revious",
// "Show Tree" => "Show Tree",
// "Hide Tree" => "Hide Tree",
// "Perform action with checked" => "Perform action with checked",
// "Are you sure you want to delete the selected files" => "Are you sure you want to delete the selected files",
// "Download the zip" => "Download the zip",
// "Assign Permissions" => "Assign Permissions",
// "Other Sorts" => "Other Sorts",
// "No Additionnal Sort" => "No Additionnal Sort",
// "No information" => "No information",
// "To validate your account and login to the site, please click on the following link" => "To validate your account and login to the site, please click on the following link",
// "The administrator approved your account" => "The administrator approved your account",
// "Confirm your email at %s" => "Confirm your email at %s",
// "New topic" => "New topic",
// "Contribution" => "Contribution",
// "You sent a request with the subject" => "You sent a request with the subject",
// "Use the subject to indicate the operation to apply" => "Use the subject to indicate the operation to apply",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "Page not found" => "Page not found",
// "New message arrived from %s" => "New message arrived from %s",
// "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now" => "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now",
// "To login with your username and password, please follow this link" => "To login with your username and password, please follow this link",
// "User Account Activated" => "User Account Activated",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "has requested an account on" => "has requested an account on",
// "To validate that account, please follow the link" => "To validate that account, please follow the link",
// "best regards" => "best regards",
// "your Tikiwiki" => "your Tikiwiki",
// "User Tracker" => "User Tracker",
// "User Registration Request" => "User Registration Request",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "You're invited to join my network of friends" => "You're invited to join my network of friends",
// "Bye bye from %s at %s" => "Bye bye from %s at %s",
// "Welcome to %s at %s" => "Welcome to %s at %s",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else" => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above" => "Important: The old password remains active if you don't click the link above",
// "Your account information for %s" => "Your account information for %s",
// "New article submitted at %s" => "New article submitted at %s",
// "Look at this link" => "Look at this link",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}" => "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}",
// "Download the file at" => "Download the file at",
// "Tracker was modified at" => "Tracker was modified at",
// "Please visit this link before login again" => "Please visit this link before login again",
// "Last attempt" => "Last attempt",
// "IP" => "IP",
// "Confirm your account at %s" => "Confirm your account at %s",
// "An administrator of the site below has added you as a new user" => "An administrator of the site below has added you as a new user",
// "If you want to confirm your membership in this site, click on the following link to login for the first time" => "If you want to confirm your membership in this site, click on the following link to login for the first time",
// "Your authentication credentials are" => "Your authentication credentials are",
// "Welcome on the site" => "Welcome on the site",
// "Your personal access to" => "Your personal access to",
// "Your account request has been stored and will be activated by the admin as soon as possible" => "Your account request has been stored and will be activated by the admin as soon as possible",
// "You'll receive email notification once your account is activated" => "You'll receive email notification once your account is activated",
// "Please do not attempt to login until you receive the email notification" => "Please do not attempt to login until you receive the email notification",
// "{\$mail_action} article post" => "{\$mail_action} article post",
// "{\$mail_title} by {\$mail_user} at" => "{\$mail_title} by {\$mail_user} at",
// "New article post" => "New article post",
// "Edited article post" => "Edited article post",
// "Deleted article post" => "Deleted article post",
// "View the article at" => "View the article at",
// "{\$mail_action} article post at" => "{\$mail_action} article post at",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}",
// "New blog post at %s" => "New blog post at %s",
// "View item calendar at" => "View item calendar at",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "A new category was created in" => "A new category was created in",
// "A category was removed in" => "A category was removed in",
// "Removed by" => "Removed by",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Updated by" => "Updated by",
// "Old" => "Old",
// "updated" => "updated",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "File Name" => "File Name",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "Posted by" => "Posted by",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "You can view the updated map following this link" => "You can view the updated map following this link",
// "You can edit the map following this link" => "You can edit the map following this link",
// "An object was added to category" => "An object was added to category",
// "Added by" => "Added by",
// "Object type" => "Object type",
// "An object was removed from category" => "An object was removed from category",
// "A page has been added to your watched sub-structure" => "A page has been added to your watched sub-structure",
// "A page has been removed from your watched sub-structure" => "A page has been removed from your watched sub-structure",
// "A page has been promoted out your watched sub-structure" => "A page has been promoted out your watched sub-structure",
// "A page has been demoted to your watched structure" => "A page has been demoted to your watched structure",
// "Structure modified" => "Structure modified",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted but used to be here" => "The page {\$mail_page} was deleted but used to be here",
// "You can view the page by following this link" => "You can view the page by following this link",
// "You can view a diff back to the previous version by following this link" => "You can view a diff back to the previous version by following this link",
// "The changes in this version follow below, followed after by the current full page text" => "The changes in this version follow below, followed after by the current full page text",
// "-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lines: {\$oldd} changed to +Lines: {\$newd}",
// "The old page content follows below" => "The old page content follows below",
// "The new page content follows below" => "The new page content follows below",
// "Wiki page %s created by {\$mail_user}" => "Wiki page %s created by {\$mail_user}",
// "Wiki page %s deleted by {\$mail_user}" => "Wiki page %s deleted by {\$mail_user}",
// "Wiki page %s changed by {\$mail_user}" => "Wiki page %s changed by {\$mail_user}",
// "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "Wiki page %s was commented on by" => "Wiki page %s was commented on by",
// "an anonymous user" => "an anonymous user",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "Thank you for your registration. You may log in now" => "Thank you for your registration. You may log in now",
// "click on the map to zoom or pan, do not drag" => "click on the map to zoom or pan, do not drag",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Scale" => "Scale",
// "Zoom out" => "Zoom out",
// "Query" => "Query",
// "Pan" => "Pan",
// "Zoom in" => "Zoom in",
// "Redraw" => "Redraw",
// "select zoom/pan/query and image size" => "select zoom/pan/query and image size",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Click on the map or click redraw" => "Click on the map or click redraw",
// "Overview" => "Overview",
// "Legend" => "Legend",
// "Layer Manager" => "Layer Manager",
// "Layer" => "Layer",
// "On" => "On",
// "Download Layer" => "Download Layer",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "you have requested to download the layer" => "you have requested to download the layer",
// "from the mapfile" => "from the mapfile",
// "Here are the files to download, do not forget to rename them" => "Here are the files to download, do not forget to rename them",
// "Mapfiles" => "Mapfiles",
// "Mapfile" => "Mapfile",
// "Available mapfiles" => "Available mapfiles",
// "hits last 7 days" => "hits last 7 days",
// "monitor this map" => "monitor this map",
// "Stop Monitoring this Map" => "Stop Monitoring this Map",
// "Create a new mapfile" => "Create a new mapfile",
// "Mapfile listing" => "Mapfile listing",
// "Reload" => "Reload",
// "You can view this map in your browser using" => "You can view this map in your browser using",
// "Zoom out x2" => "Zoom out x2",
// "Zoom in x2" => "Zoom in x2",
// "Mapfile History" => "Mapfile History",
// "Comparing version {\$old.version} with version {\$new.version}" => "Comparing version {\$old.version} with version {\$new.version}",
// "v=view" => "v=view",
// "c=compare" => "c=compare",
// "d=diff" => "d=diff",
// "Full side-by-side diff" => "Full side-by-side diff",
// "Unified diff" => "Unified diff",
// "Side-by-side view" => "Side-by-side view",
// "Older Version" => "Older Version",
// "Directories" => "Directories",
// "back to" => "back to",
// "Upload Files" => "Upload Files",
// "Bytes maximum" => "Bytes maximum",
// "Create Directory" => "Create Directory",
// "index file (.shp)" => "index file (.shp)",
// "files to index (regexp)" => "files to index (regexp)",
// "Message Archive" => "Message Archive",
// "messages" => "messages",
// "Archive is full" => "Archive is full",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences" => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences",
// "ERROR" => "ERROR",
// "No messages to download" => "No messages to download",
// "Mailbox is full! Delete or archive some messages if you want to receive more messages" => "Mailbox is full! Delete or archive some messages if you want to receive more messages",
// "is reply to" => "is reply to",
// "Find replied message" => "Find replied message",
// "Archive" => "Archive",
// "Auto-archive age for read messages" => "Auto-archive age for read messages",
// "Return to mailbox" => "Return to mailbox",
// "Unflag" => "Unflag",
// "Return to archive" => "Return to archive",
// "Return to outbox" => "Return to outbox",
// "Sent Messages" => "Sent Messages",
// "Replied" => "Replied",
// "Not replied" => "Not replied",
// "move to archive" => "move to archive",
// "receiver" => "receiver",
// "'name' parameter for tikimodule missed" => "'name' parameter for tikimodule missed",
// "Move module up" => "Move module up",
// "Move module down" => "Move module down",
// "Move module to opposite side" => "Move module to opposite side",
// "opp side" => "opp side",
// "Unassign this module" => "Unassign this module",
// "Are you sure you want to unassign this module" => "Are you sure you want to unassign this module",
// "Toggle module contents" => "Toggle module contents",
// "toggle" => "toggle",
// "\$tpl_module_title" => "\$tpl_module_title",
// "Search Stats" => "Search Stats",
// "QuickTags" => "QuickTags",
// "Admin Drawings" => "Admin Drawings",
// "Shoutbox Words" => "Shoutbox Words",
// "Import PHPWiki Dump" => "Import PHPWiki Dump",
// "External Wikis" => "External Wikis",
// "Tiki Cache/Sys Admin" => "Tiki Cache/Sys Admin",
// "Security Admin" => "Security Admin",
// "Syntax Highlighting" => "Syntax Highlighting",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number " => "You forgot your Google ad_client number ",
// "\$module_title" => "\$module_title",
// "More.." => "More..",
// "Tikiwiki Assistant" => "Tikiwiki Assistant",
// "Thank you for installing Tikiwiki" => "Thank you for installing Tikiwiki",
// "To configure your Tiki" => "To configure your Tiki",
// "Admin Home" => "Admin Home",
// "from the menu" => "from the menu",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "as the Admin" => "as the Admin",
// "The Tikiwiki Community" => "The Tikiwiki Community",
// "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "Last `\$module_rows` blog comments" => "Last `\$module_rows` blog comments",
// "Last blog comments" => "Last blog comments",
// "on blogpost" => "on blogpost",
// "Add event" => "Add event",
// "\$modcattitle" => "\$modcattitle",
// "Last `\$module_rows` Sites" => "Last `\$module_rows` Sites",
// "Top \$module_rows Sites" => "Top \$module_rows Sites",
// "Current events" => "Current events",
// "Top `\$module_rows` topics" => "Top `\$module_rows` topics",
// "Last `\$module_rows` forum posts" => "Last `\$module_rows` forum posts",
// "Last forum posts" => "Last forum posts",
// "Last `\$module_rows` forum topics" => "Last `\$module_rows` forum topics",
// "Folksonomy" => "Folksonomy",
// "Tags This Page Has" => "Tags This Page Has",
// "Add tags" => "Add tags",
// "More Like This" => "More Like This",
// "Most popular tags" => "Most popular tags",
// "List everything tagged" => "List everything tagged",
// "My prefered tags" => "My prefered tags",
// "Last `\$module_rows` actions" => "Last `\$module_rows` actions",
// "Last actions" => "Last actions",
// "Last `\$module_rows` articles" => "Last `\$module_rows` articles",
// "Last articles" => "Last articles",
// "Last `\$module_rows` blog posts" => "Last `\$module_rows` blog posts",
// "\$type" => "\$type",
// "Last `\$module_rows` Created blogs" => "Last `\$module_rows` Created blogs",
// "Last `\$module_rows` Created FAQs" => "Last `\$module_rows` Created FAQs",
// "Last `\$module_rows` Created Quizzes" => "Last `\$module_rows` Created Quizzes",
// "Last `\$module_rows` modified file galleries" => "Last `\$module_rows` modified file galleries",
// "Last `\$module_rows` Files" => "Last `\$module_rows` Files",
// "Last `\$module_rows` galleries" => "Last `\$module_rows` galleries",
// "Last `\$module_rows` Images" => "Last `\$module_rows` Images",
// "Last Images" => "Last Images",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "Last `\$module_rows` modified events" => "Last `\$module_rows` modified events",
// "Last modifed events" => "Last modifed events",
// "Last `\$module_rows` changes" => "Last `\$module_rows` changes",
// "more" => "more",
// "Last `\$module_rows` Modified Items" => "Last `\$module_rows` Modified Items",
// "Last `\$module_rows` Modified blogs" => "Last `\$module_rows` Modified blogs",
// "Last `\$module_rows` submissions" => "Last `\$module_rows` submissions",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "Last `\$module_rows` Items" => "Last `\$module_rows` Items",
// "Last `\$module_rows` visitors" => "Last `\$module_rows` visitors",
// "Last Visitors" => "Last Visitors",
// "No avatar" => "No avatar",
// "You" => "You",
// "Logged in as" => "Logged in as",
// "Switch User" => "Switch User",
// "Switch user" => "Switch user",
// "Login through CAS" => "Login through CAS",
// "Login as admin" => "Login as admin",
// "Login through Shibboleth" => "Login through Shibboleth",
// "Login as" => "Login as",
// "CapsLock is on" => "CapsLock is on",
// "year" => "year",
// "Click here to register" => "Click here to register",
// "Click here if you've forgotten your password" => "Click here if you've forgotten your password",
// "Click here to login using the default security protocol" => "Click here to login using the default security protocol",
// "Click here to login using a secure protocol" => "Click here to login using a secure protocol",
// "local account" => "local account",
// "OpenID Login" => "OpenID Login",
// "What is OpenID" => "What is OpenID",
// "Send a message" => "Send a message",
// "Random Images" => "Random Images",
// "RSS Feeds" => "RSS Feeds",
// "Wiki RSS" => "Wiki RSS",
// "Blogs RSS" => "Blogs RSS",
// "Articles RSS" => "Articles RSS",
// "Image Galleries RSS" => "Image Galleries RSS",
// "File Galleries RSS" => "File Galleries RSS",
// "Forums RSS" => "Forums RSS",
// "Maps RSS" => "Maps RSS",
// "Maps" => "Maps",
// "Calendars" => "Calendars",
// "A leading plus sign indicates that this word must be present in every object returned" => "A leading plus sign indicates that this word must be present in every object returned",
// "A leading minus sign indicates that this word must not be present in any row returned" => "A leading minus sign indicates that this word must not be present in any row returned",
// "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher" => "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher",
// "These two operators are used to change a word's contribution to the relevance value that is assigned to a row" => "These two operators are used to change a word's contribution to the relevance value that is assigned to a row",
// "Parentheses are used to group words into subexpressions" => "Parentheses are used to group words into subexpressions",
// "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator" => "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator",
// "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended" => "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended",
// "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed" => "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed",
// "Advanced search" => "Advanced search",
// "Advanced Search Help" => "Advanced Search Help",
// "Page Relations" => "Page Relations",
// "Are you sure you want to delete this shout" => "Are you sure you want to delete this shout",
// "Delete this shout" => "Delete this shout",
// "Edit this shout" => "Edit this shout",
// "New Tracker Items" => "New Tracker Items",
// "New Calendar Events" => "New Calendar Events",
// "Nothing has changed" => "Nothing has changed",
// "`\$module_params.prefix`" => "`\$module_params.prefix`",
// "Site Language" => "Site Language",
// "Site default" => "Site default",
// "TikiTests Menu" => "TikiTests Menu",
// "List Tests" => "List Tests",
// "Create Test" => "Create Test",
// "Top `\$module_rows` articles" => "Top `\$module_rows` articles",
// "Top `\$module_rows` File Galleries" => "Top `\$module_rows` File Galleries",
// "Top `\$module_rows` files" => "Top `\$module_rows` files",
// "Top files" => "Top files",
// "Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Forum Posters",
// "Top Forum Posters" => "Top Forum Posters",
// "Top `\$module_rows` games" => "Top `\$module_rows` games",
// "Top `\$module_rows` galleries" => "Top `\$module_rows` galleries",
// "Top `\$module_rows` Images" => "Top `\$module_rows` Images",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Top `\$module_rows` Pages" => "Top `\$module_rows` Pages",
// "Top `\$module_rows` Quizzes" => "Top `\$module_rows` Quizzes",
// "Most `\$module_rows` visited blogs" => "Most `\$module_rows` visited blogs",
// "Top `\$module_rows` Visited FAQs" => "Top `\$module_rows` Visited FAQs",
// "Page translation" => "Page translation",
// "There are no translations of this page" => "There are no translations of this page",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "None match your" => "None match your",
// "Set your preferred languages" => "Set your preferred languages",
// "preferred languages" => "preferred languages",
// "Equivalent translations" => "Equivalent translations",
// "Translations that need improvement" => "Translations that need improvement",
// "update it" => "update it",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "The Next Event" => "The Next Event",
// "No Upcoming Events" => "No Upcoming Events",
// "click to view" => "click to view",
// "Public tasks" => "Public tasks",
// "select" => "select",
// "User informations" => "User informations",
// "Group informations" => "Group informations",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Top users" => "Top users",
// "Whats related" => "Whats related",
// "on host" => "on host",
// "Last `\$module_rows` wiki comments" => "Last `\$module_rows` wiki comments",
// "Last wiki comments" => "Last wiki comments",
// "on page" => "on page",
// "Videos on YouTube" => "Videos on YouTube",
// "More Videos" => "More Videos",
// "Changes that need to be reproduced are highlighted below" => "Changes that need to be reproduced are highlighted below",
// "[-]" => "[-]",
// "Send Newsletter" => "Send Newsletter",
// "Insert/Edit an internal wiki link" => "Insert/Edit an internal wiki link",
// "Wiki Link insert" => "Wiki Link insert",
// "Please make a selection of text in order to create a link" => "Please make a selection of text in order to create a link",
// "Insert an image" => "Insert an image",
// "Tiki Image - Insert an image" => "Tiki Image - Insert an image",
// "show structures" => "show structures",
// "hide structures" => "hide structures",
// "Manage structures" => "Manage structures",
// "By" => "By",
// "Location : " => "Location : ",
// "Read more" => "Read more",
// "Enlarge area height" => "Enlarge area height",
// "Reduce area height" => "Reduce area height",
// "Do not group by item" => "Do not group by item",
// "Group by item" => "Group by item",
// "Calendar View" => "Calendar View",
// "List View" => "List View",
// "Tiki Action Calendar" => "Tiki Action Calendar",
// "Tip" => "Tip",
// "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones" => "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones",
// "Site Ads and Banners" => "Site Ads and Banners",
// "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users" => "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users",
// "Profiles" => "Profiles",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Look &amp; Feel" => "Look &amp; Feel",
// "i18n" => "i18n",
// "Editing and Plugins" => "Editing and Plugins",
// "Text area" => "Text area",
// "Meta Tags" => "Meta Tags",
// "Community" => "Community",
// "Freetags" => "Freetags",
// "Multimedia" => "Multimedia",
// "Wysiwyg editor" => "Wysiwyg editor",
// "Intertiki" => "Intertiki",
// "InterTiki" => "InterTiki",
// "Semantic wiki links" => "Semantic wiki links",
// "Semantic links" => "Semantic links",
// "Webservices" => "Webservices",
// "Sef URL" => "Sef URL",
// "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or",
// "Blogs Listing" => "Blogs Listing",
// "Create a blog" => "Create a blog",
// "Not Installed" => "Not Installed",
// "Spell checking" => "Spell checking",
// "Requires a separate download" => "Requires a separate download",
// "Custom blog headings" => "Custom blog headings",
// "Blog-level" => "Blog-level",
// "Post-level" => "Post-level",
// "Default number per page" => "Default number per page",
// "Default ordering" => "Default ordering",
// "Blogs Listings" => "Blogs Listings",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Select which items to display when listing blogs" => "Select which items to display when listing blogs",
// "Title length" => "Title length",
// "Creation date" => "Creation date",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "Change settings" => "Change settings",
// "General settings" => "General settings",
// "Default calendars to display" => "Default calendars to display",
// "All calendars" => "All calendars",
// "A subset of available calendars" => "A subset of available calendars",
// "Create calendar" => "Create calendar",
// "Default view mode" => "Default view mode",
// "View list begins" => "View list begins",
// "Focus Date" => "Focus Date",
// "Period beginning" => "Period beginning",
// "First day of the week" => "First day of the week",
// "Split hours in periods of" => "Split hours in periods of",
// "1 minute" => "1 minute",
// "10 minutes" => "10 minutes",
// "Manual selection of time/date" => "Manual selection of time/date",
// "JS calendar" => "JS calendar",
// "Year selection is valid when the JS Calendar <strong>is not</strong> enabled" => "Year selection is valid when the JS Calendar <strong>is not</strong> enabled",
// "First year in the dropdown" => "First year in the dropdown",
// "Enter a year or use +/- N to specify a year relative to the current\n\tyear" => "Enter a year or use +/- N to specify a year relative to the current\n\tyear",
// "Last year in the dropdown" => "Last year in the dropdown",
// "Group calendars" => "Group calendars",
// "Sticky popup" => "Sticky popup",
// "Item view tab" => "Item view tab",
// "Browse categories" => "Browse categories",
// "Administer categories" => "Administer categories",
// "Category path" => "Category path",
// "Exclude these categories" => "Exclude these categories",
// "Separate category IDs with a comma (,)" => "Separate category IDs with a comma (,)",
// "Show category objects" => "Show category objects",
// "Use PHPLayers for category browser" => "Use PHPLayers for category browser",
// "PHPLayers is disabled" => "PHPLayers is disabled",
// "Enable now" => "Enable now",
// "Categories used in templates (TPL)" => "Categories used in templates (TPL)",
// "Ignore category viewing restrictions" => "Ignore category viewing restrictions",
// "Will improve performance, but may show forbidden results" => "Will improve performance, but may show forbidden results",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Look under \"Articles\" on the application menu for links to" => "Look under \"Articles\" on the application menu for links to",
// "Admin topics" => "Admin topics",
// "Admin types" => "Admin types",
// "Articles Listing" => "Articles Listing",
// "Title of articles home page" => "Title of articles home page",
// "Maximum number of articles on articles home page" => "Maximum number of articles on articles home page",
// "Article properties" => "Article properties",
// "Give only one value (width or height) to keep the image proportions" => "Give only one value (width or height) to keep the image proportions",
// "Specify notification emails when creating articles" => "Specify notification emails when creating articles",
// "Default article image width" => "Default article image width",
// "Default article image height" => "Default article image height",
// "File format: title,authorName,heading,body,lang,user" => "File format: title,authorName,heading,body,lang,user",
// "Select which items to display when listing articles" => "Select which items to display when listing articles",
// "Publication date" => "Publication date",
// "Expiration date" => "Expiration date",
// "Visible" => "Visible",
// "Users Listing" => "Users Listing",
// "Users can choose to show their gender" => "Users can choose to show their gender",
// "Requires User Preferences feature" => "Requires User Preferences feature",
// "Show user's information on mouseover" => "Show user's information on mouseover",
// "Requires user's information to be public" => "Requires user's information to be public",
// "Real name" => "Real name",
// "Number of friends" => "Number of friends",
// "Feature is disabled" => "Feature is disabled",
// "E-mail" => "E-mail",
// "Distance" => "Distance",
// "Default user preferences" => "Default user preferences",
// "Users Default Preferences" => "Users Default Preferences",
// "Character set for mail" => "Character set for mail",
// "default" => "default",
// "Detect user timezone if browser allows, otherwise site default" => "Detect user timezone if browser allows, otherwise site default",
// "Use double-click to edit pages" => "Use double-click to edit pages",
// "Show user's info on mouseover" => "Show user's info on mouseover",
// "User messages" => "User messages",
// "Notify sender when reading mail" => "Notify sender when reading mail",
// "Auto-archive read messages after x days" => "Auto-archive read messages after x days",
// "never" => "never",
// "My forum topics" => "My forum topics",
// "My forum replies" => "My forum replies",
// "My workflow" => "My workflow",
// "Select which items to display when listing users" => "Select which items to display when listing users",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "License page" => "License page",
// "Submit notice" => "Submit notice",
// "Enable copyright management for" => "Enable copyright management for",
// "Feature" => "Feature",
// "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or",
// "enable cool sites" => "enable cool sites",
// "Show Country Flag" => "Show Country Flag",
// "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site",
// "No tabs" => "No tabs",
// "Apply" => "Apply",
// "Reset" => "Reset",
// "Main" => "Main",
// "Global Features" => "Global Features",
// "More Functionality" => "More Functionality",
// "UI Enhancements" => "UI Enhancements",
// "Experimental" => "Experimental",
// "Programmer" => "Programmer",
// "Main Features" => "Main Features",
// "Site Global Features" => "Site Global Features",
// "Action Log" => "Action Log",
// "Action log setting" => "Action log setting",
// "Internationalization" => "Internationalization",
// "Multilingual" => "Multilingual",
// "Additional Features" => "Additional Features",
// "Copyright System" => "Copyright System",
// "Copyright system" => "Copyright system",
// "Tell a Friend" => "Tell a Friend",
// "HTML pages" => "HTML pages",
// "Minichat" => "Minichat",
// "Comments Moderation" => "Comments Moderation",
// "Comments Locking" => "Comments Locking",
// "User interface enhancement features" => "User interface enhancement features",
// "JsCalendar" => "JsCalendar",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "PHPLayers" => "PHPLayers",
// "PhpLayers Dynamic menus" => "PhpLayers Dynamic menus",
// "Fullscreen" => "Fullscreen",
// "Allow users to activate fullscreen mode" => "Allow users to activate fullscreen mode",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
// "Mootools or JQuery" => "Mootools or JQuery",
// "Mootools" => "Mootools",
// "Floating help aka the Big Blue Help Icon" => "Floating help aka the Big Blue Help Icon",
// "Experimental Features" => "Experimental Features",
// "Seem ok" => "Seem ok",
// "Features that may change or might be re-worked in the future" => "Features that may change or might be re-worked in the future",
// "Ajax" => "Ajax",
// "HTML Purifier" => "HTML Purifier",
// "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)" => "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)",
// "JQuery: JavaScript UI effects" => "JQuery: JavaScript UI effects",
// "Mobile" => "Mobile",
// "Morcego 3D browser" => "Morcego 3D browser",
// "Need polish" => "Need polish",
// "Features that need admin help and user patience to work well" => "Features that need admin help and user patience to work well",
// "Mindmap" => "Mindmap",
// "Print Indexed" => "Print Indexed",
// "SEFURL" => "SEFURL",
// "Search engine friendly url" => "Search engine friendly url",
// "Spreadsheet" => "Spreadsheet",
// "Tiki Sheet" => "Tiki Sheet",
// "Ajax auto-save" => "Ajax auto-save",
// "Malfunctioning" => "Malfunctioning",
// "These features have critical faults - not recommended" => "These features have critical faults - not recommended",
// "Magic Admin Panel" => "Magic Admin Panel",
// "Neglected" => "Neglected",
// "Old features no longer maintained" => "Old features no longer maintained",
// "Friendship" => "Friendship",
// "Friendship Network" => "Friendship Network",
// "SWFObject" => "SWFObject",
// "SwfObject" => "SwfObject",
// "Used to embed Flash content in wiki pages, banners etc" => "Used to embed Flash content in wiki pages, banners etc",
// "Action Calendar" => "Action Calendar",
// "Tiki action calendar" => "Tiki action calendar",
// "Redirect On Error" => "Redirect On Error",
// "Display 'MyTiki' in the application menu" => "Display 'MyTiki' in the application menu",
// "User Contacts" => "User Contacts",
// "Group Watches" => "Group Watches",
// "User Watches Translations" => "User Watches Translations",
// "User Levels" => "User Levels",
// "Group Alert" => "Group Alert",
// "Programmer Features" => "Programmer Features",
// "Integrator" => "Integrator",
// "TikiTests" => "TikiTests",
// "requires PHP5 or more" => "requires PHP5 or more",
// "Use Minified Scripts" => "Use Minified Scripts",
// "To create or remove file galleries, select" => "To create or remove file galleries, select",
// "from the application menu" => "from the application menu",
// "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory" => "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
// "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/",
// "Gallery Listing" => "Gallery Listing",
// "Search Indexing" => "Search Indexing",
// "Create a Gallery" => "Create a Gallery",
// "Store in database" => "Store in database",
// "Store in directory" => "Store in directory",
// "The server must be able to read/write the directory" => "The server must be able to read/write the directory",
// "The directory can be outside the web space" => "The directory can be outside the web space",
// "Podcast directory" => "Podcast directory",
// "Required for podcasts" => "Required for podcasts",
// "Default Ordering" => "Default Ordering",
// "Allow download limit per file" => "Allow download limit per file",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "Score is disabled" => "Score is disabled",
// "Allow same file to be uploaded more than once" => "Allow same file to be uploaded more than once",
// "Yes, even in the same gallery" => "Yes, even in the same gallery",
// "Only in different galleries" => "Only in different galleries",
// "Batch uploading" => "Batch uploading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "The server must be able to read the directory" => "The server must be able to read the directory",
// "Require file author's name for anonymous uploads" => "Require file author's name for anonymous uploads",
// "Upload Regex" => "Upload Regex",
// "Must match" => "Must match",
// "Cannot match" => "Cannot match",
// "Gallery Listings" => "Gallery Listings",
// "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries" => "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries",
// "Select which items to display when listing galleries: " => "Select which items to display when listing galleries: ",
// "Automatically index files on upload or change" => "Automatically index files on upload or change",
// "Handlers" => "Handlers",
// "Add custom handlers to make your files &quot;searchable&quot; content" => "Add custom handlers to make your files &quot;searchable&quot; content",
// "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command" => "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command",
// "To delete a handler, leave the <strong>System Command</strong> field blank" => "To delete a handler, leave the <strong>System Command</strong> field blank",
// "MIME Type" => "MIME Type",
// "System Command" => "System Command",
// "Reindex all files for search" => "Reindex all files for search",
// "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or",
// "Forums Listing" => "Forums Listing",
// "Create a forum" => "Create a forum",
// "Topic archiving" => "Topic archiving",
// "Quick jumps" => "Quick jumps",
// "Replies are empty" => "Replies are empty",
// "If disabled, replies will quote the original post" => "If disabled, replies will quote the original post",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "First post of a thread can have an empty body" => "First post of a thread can have an empty body",
// "Will be a thread title" => "Will be a thread title",
// "Threads" => "Threads",
// "Manage thread defaults per-forum" => "Manage thread defaults per-forum",
// "Display thread configuration bar" => "Display thread configuration bar",
// "Allows users to override the defaults" => "Allows users to override the defaults",
// "Keep settings for all forums during the user session" => "Keep settings for all forums during the user session",
// "Default style" => "Default style",
// "Default sort mode" => "Default sort mode",
// "Forum name search" => "Forum name search",
// "When listing forums" => "When listing forums",
// "Forum content search" => "Forum content search",
// "Topic content search" => "Topic content search",
// "Search is disabled" => "Search is disabled",
// "Use Tiki (database-independent) search" => "Use Tiki (database-independent) search",
// "Use database (full-text) search" => "Use database (full-text) search",
// "Select which items to display when listing forums" => "Select which items to display when listing forums",
// "Description length" => "Description length",
// "3D Tag Browser" => "3D Tag Browser",
// "Show tag cloud" => "Show tag cloud",
// "Maximum number of tags in cloud" => "Maximum number of tags in cloud",
// "Show freetags in middle column" => "Show freetags in middle column",
// "Preload freetag random tag" => "Preload freetag random tag",
// "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>" => "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>",
// "Random tag cloud colors" => "Random tag cloud colors",
// "Separate colors with a comma (,)" => "Separate colors with a comma (,)",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Alphanumeric ASCII characters only" => "Alphanumeric ASCII characters only",
// "No accents or special characters" => "No accents or special characters",
// "Accept all charactrs" => "Accept all charactrs",
// "Lowercase tags only" => "Lowercase tags only",
// "Multilingual freetags" => "Multilingual freetags",
// "Multiligual disabled" => "Multiligual disabled",
// "&quot;More Like This&quot; algorithm" => "&quot;More Like This&quot; algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Minimum amount of tags in common" => "Minimum amount of tags in common",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "Morcego 3D browser disabled" => "Morcego 3D browser disabled",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Browser width" => "Browser width",
// "Browser height" => "Browser height",
// "Graph appearance" => "Graph appearance",
// "Navigation depth" => "Navigation depth",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Spring (connection) size" => "Spring (connection) size",
// "Node color" => "Node color",
// "Camera settinsg" => "Camera settinsg",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Camera distance" => "Camera distance",
// "Field of view" => "Field of view",
// "Feed animation interval (milisecs)" => "Feed animation interval (milisecs)",
// "Physics engine" => "Physics engine",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or",
// "You can upload images of a size of " => "You can upload images of a size of ",
// "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value",
// "Home Gallery" => "Home Gallery",
// "Uses Slideshow" => "Uses Slideshow",
// "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below" => "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below",
// "Directory Batch Loading" => "Directory Batch Loading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols",
// "Enable directory batch loading" => "Enable directory batch loading",
// "Batch loading directory" => "Batch loading directory",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Pixels Default" => "Pixels Default",
// "Default scale size" => "Default scale size",
// "pixels" => "pixels",
// "Exterminator" => "Exterminator",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Change configuration" => "Change configuration",
// "Admin Password" => "Admin Password",
// "Release Check" => "Release Check",
// "Reset or upgrade your database" => "Reset or upgrade your database",
// "Check for updates automatically" => "Check for updates automatically",
// "Check frequency" => "Check frequency",
// "TikiWiki will check for updates when you access the main Administration page" => "TikiWiki will check for updates when you access the main Administration page",
// "Check for updates now" => "Check for updates now",
// "Site Identity" => "Site Identity",
// "Sender email" => "Sender email",
// "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look &amp; Feel</strong></a> section for additional site related customization preferences" => "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look &amp; Feel</strong></a> section for additional site related customization preferences",
// "Use group homepages" => "Use group homepages",
// "Go to group homepage only if login from default homepage" => "Go to group homepage only if login from default homepage",
// "Use TikiWiki feature as homepage" => "Use TikiWiki feature as homepage",
// "Use different URL as home page" => "Use different URL as home page",
// "Miscellaneous" => "Miscellaneous",
// "Server OS" => "Server OS",
// "Smarty Security" => "Smarty Security",
// "Do not allow php code in smarty templates" => "Do not allow php code in smarty templates",
// "Use PEAR::Date library" => "Use PEAR::Date library",
// "Default charset for sending mail" => "Default charset for sending mail",
// "Mail end of line" => "Mail end of line",
// "(standard)" => "(standard)",
// "(some Unix MTA)" => "(some Unix MTA)",
// "Logging and Reporting" => "Logging and Reporting",
// "PHP error reporting level" => "PHP error reporting level",
// "Report all PHP errors except strict" => "Report all PHP errors except strict",
// "Visible to Admin only" => "Visible to Admin only",
// "Include Smarty notices" => "Include Smarty notices",
// "Log mail in Tiki logs" => "Log mail in Tiki logs",
// "Log SQL" => "Log SQL",
// "Log queries using more than" => "Log queries using more than",
// "This may impact performance" => "This may impact performance",
// "Add HTML comment at start and end of each Smarty template (TPL)" => "Add HTML comment at start and end of each Smarty template (TPL)",
// "CSRF Security" => "CSRF Security",
// "Use these options to protect against cross-site request forgeries (CSRF)" => "Use these options to protect against cross-site request forgeries (CSRF)",
// "Require confirmation if possible CSRF detected" => "Require confirmation if possible CSRF detected",
// "Protect against CSRF with a ticket" => "Protect against CSRF with a ticket",
// "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings" => "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings",
// "Site Access" => "Site Access",
// "Close site (except for those with permission)" => "Close site (except for those with permission)",
// "Message to display" => "Message to display",
// "Close site when server load is above the threshold  (except for those with permission)" => "Close site when server load is above the threshold  (except for those with permission)",
// "Maximum average server load threshold in the last minute" => "Maximum average server load threshold in the last minute",
// "Use proxy" => "Use proxy",
// "Host" => "Host",
// "On permission denied, display login module (for Anonymous)" => "On permission denied, display login module (for Anonymous)",
// "Send to URL" => "Send to URL",
// "Performance" => "Performance",
// "Cache external pages" => "Cache external pages",
// "Cache external images" => "Cache external images",
// "GZip output" => "GZip output",
// "Output compression is active" => "Output compression is active",
// "Compression is handled by" => "Compression is handled by",
// "Session" => "Session",
// "Advanced configuration warning" => "Advanced configuration warning",
// "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects" => "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects",
// "Enabling this feature will immediately log you out when you save this preference" => "Enabling this feature will immediately log you out when you save this preference",
// "Store session data in database" => "Store session data in database",
// "Session lifetime" => "Session lifetime",
// "The \"Contact Us\" feature is disabled" => "The \"Contact Us\" feature is disabled",
// "Allow anonymous visitors to use the \"Contact Us\"" => "Allow anonymous visitors to use the \"Contact Us\"",
// "Help System" => "Help System",
// "Help URL" => "Help URL",
// "The default help system may not be complete" => "The default help system may not be complete",
// "You can help with the TikiWiki documentation" => "You can help with the TikiWiki documentation",
// "Show user's real name instead of login (when possible)" => "Show user's real name instead of login (when possible)",
// "Highlight group" => "Highlight group",
// "Show user's contribution on the user information page" => "Show user's contribution on the user information page",
// "Display UserTracker information on the user information page" => "Display UserTracker information on the user information page",
// "Use the format: trackerId, fieldId1, fieldId2, .." => "Use the format: trackerId, fieldId1, fieldId2, ..",
// "Separators" => "Separators",
// "Locations (breadcrumbs)" => "Locations (breadcrumbs)",
// "Examples" => "Examples",
// "Choices" => "Choices",
// "Default timezone" => "Default timezone",
// "Use site default to show times" => "Use site default to show times",
// "Detect user timezone (if browser allows). Otherwise use site default" => "Detect user timezone (if browser allows). Otherwise use site default",
// "Sample" => "Sample",
// "Fields display order" => "Fields display order",
// "Change the <strong>Admin</strong> password" => "Change the <strong>Admin</strong> password",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at " => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at ",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Babelfish links" => "Babelfish links",
// "Customized String Translation" => "Customized String Translation",
// "Default language" => "Default language",
// "Detect browser language" => "Detect browser language",
// "Show pages in user's preferred language" => "Show pages in user's preferred language",
// "User preferences are disabled" => "User preferences are disabled",
// "Users can change site language" => "Users can change site language",
// "Restrict supported languages" => "Restrict supported languages",
// "Available languages" => "Available languages",
// "Use Ctrl+Click to select multiple languages" => "Use Ctrl+Click to select multiple languages",
// "Display available translations" => "Display available translations",
// "Changing page language will also change the site language" => "Changing page language will also change the site language",
// "Translation assistant" => "Translation assistant",
// "Urgent translation notifications" => "Urgent translation notifications",
// "Quantify change size" => "Quantify change size",
// "Multilingual structures" => "Multilingual structures",
// "Structures are disabled" => "Structures are disabled",
// "Multilingual One Page feature" => "Multilingual One Page feature",
// "Syntax error" => "Syntax error",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// "as master" => "as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "Enable/disable Tiki features in " => "Enable/disable Tiki features in ",
// ", but configure them elsewhere" => ", but configure them elsewhere",
// "Look and Feel" => "Look and Feel",
// "Text Area" => "Text Area",
// "Wysiwyg" => "Wysiwyg",
// "Semantic" => "Semantic",
// "Webservices management" => "Webservices management",
// "Admin Groups" => "Admin Groups",
// "Admin Users" => "Admin Users",
// "PAM" => "PAM",
// "CAS" => "CAS",
// "Tiki" => "Tiki",
// "Tiki and OpenID" => "Tiki and OpenID",
// "Registration" => "Registration",
// "Validate by email" => "Validate by email",
// "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>",
// "Validate user's email server" => "Validate user's email server",
// "Require validation by Admin" => "Require validation by Admin",
// "Require passcode to register" => "Require passcode to register",
// "Passcode" => "Passcode",
// "Users must enter this code to register" => "Users must enter this code to register",
// "Use CAPTCHA to prevent automatic/robot registrations" => "Use CAPTCHA to prevent automatic/robot registrations",
// "Requires PHP GD library" => "Requires PHP GD library",
// "Include &quot;Generate Password&quot; option on registration form" => "Include &quot;Generate Password&quot; option on registration form",
// "Use tracker to collect more user information" => "Use tracker to collect more user information",
// "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display" => "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display",
// "Use tracker to collect more group information" => "Use tracker to collect more group information",
// "Users can select a group to join at registration" => "Users can select a group to join at registration",
// "By default, new users automatically join the Registered group" => "By default, new users automatically join the Registered group",
// "Re-validate user by email after" => "Re-validate user by email after",
// "Use <strong>-1</strong> for never" => "Use <strong>-1</strong> for never",
// "unsuccessful login attempts" => "unsuccessful login attempts",
// "Create a new group for each user" => "Create a new group for each user",
// "The group will be named identical to the user's username" => "The group will be named identical to the user's username",
// "Disable browser's autocomplete feature for username and password fields" => "Disable browser's autocomplete feature for username and password fields",
// "Confirm that the Admin account has a valid email address or you will not be permitted to login" => "Confirm that the Admin account has a valid email address or you will not be permitted to login",
// "Use HTTPS login" => "Use HTTPS login",
// "Users can choose to stay in SSL mode after an HTTPS login" => "Users can choose to stay in SSL mode after an HTTPS login",
// "Users can switch between secured or standard mode at login" => "Users can switch between secured or standard mode at login",
// "User's choice" => "User's choice",
// "Always" => "Always",
// "Cookie name" => "Cookie name",
// "Use email as username" => "Use email as username",
// "Minimum length" => "Minimum length",
// "Maximum length" => "Maximum length",
// "Force lowercase" => "Force lowercase",
// "Username pattern" => "Username pattern",
// "Store password as plain text" => "Store password as plain text",
// "Store passwords in plain text is activated. You should never set this unless you know what you are doing" => "Store passwords in plain text is activated. You should never set this unless you know what you are doing",
// "Remind/forgot password" => "Remind/forgot password",
// "If passwords </em>are stored<em> as plain text, the password will be emailed to the user" => "If passwords </em>are stored<em> as plain text, the password will be emailed to the user",
// "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user" => "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user",
// "Encryption method" => "Encryption method",
// "Users can change their password" => "Users can change their password",
// "Require characters and numerals" => "Require characters and numerals",
// "Password expires after" => "Password expires after",
// "You must change the Authentication Method to PEAR::Auth for these changes to take effect" => "You must change the Authentication Method to PEAR::Auth for these changes to take effect",
// "Create user if not in Tiki" => "Create user if not in Tiki",
// "Create user if not in Auth" => "Create user if not in Auth",
// "Use Tiki authentication for Admin login" => "Use Tiki authentication for Admin login",
// "LDAP" => "LDAP",
// "Will override the Host and Port settings" => "Will override the Host and Port settings",
// "Search scope" => "Search scope",
// "Subtree" => "Subtree",
// "One level" => "One level",
// "Base object" => "Base object",
// "LDAP version" => "LDAP version",
// "Realname attribute" => "Realname attribute",
// "Country attribute" => "Country attribute",
// "E-mail attribute" => "E-mail attribute",
// "Base DN" => "Base DN",
// "LDAP User" => "LDAP User",
// "User DN" => "User DN",
// "User attribute" => "User attribute",
// "User OC" => "User OC",
// "LDAP Group" => "LDAP Group",
// "Group DN" => "Group DN",
// "Group attribute" => "Group attribute",
// "Group OC" => "Group OC",
// "LDAP Member" => "LDAP Member",
// "Member attribute" => "Member attribute",
// "Member is DN" => "Member is DN",
// "LDAP Admin" => "LDAP Admin",
// "Admin user" => "Admin user",
// "Admin password" => "Admin password",
// "You must change the Authentication Method to PAM for these changes to take effect" => "You must change the Authentication Method to PAM for these changes to take effect",
// "PAM service" => "PAM service",
// "Currently unused" => "Currently unused",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
// "You must change the Authentication Method to Shibboleth for these changes to take effect" => "You must change the Authentication Method to Shibboleth for these changes to take effect",
// "Valid affiliations" => "Valid affiliations",
// "Separate multiple affiliations with commas" => "Separate multiple affiliations with commas",
// "Create with default group" => "Create with default group",
// "Default group" => "Default group",
// "You must change the Authentication Method to CAS for these changes to take effect" => "You must change the Authentication Method to CAS for these changes to take effect",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/" => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/",
// "CAS server version" => "CAS server version",
// "Version 1.0" => "Version 1.0",
// "Version 2.0" => "Version 2.0",
// "CAS Server" => "CAS Server",
// "Hostname" => "Hostname",
// "You must enable PHP CAS first" => "You must enable PHP CAS first",
// "General Layout" => "General Layout",
// "UI Effects" => "UI Effects",
// "The \"users can change theme\" feature will override the theme displayed" => "The \"users can change theme\" feature will override the theme displayed",
// "Theme not saved yet - click \"Apply\"" => "Theme not saved yet - click \"Apply\"",
// "Theme options" => "Theme options",
// "Restrict available themes" => "Restrict available themes",
// "Available styles" => "Available styles",
// "Each group can have its theme" => "Each group can have its theme",
// "Use transition style sheet from version" => "Use transition style sheet from version",
// "Template Viewing" => "Template Viewing",
// "Tiki Template Viewing" => "Tiki Template Viewing",
// "View Templates" => "View Templates",
// "Shadow layer" => "Shadow layer",
// "Enable additional general layout layers for shadows, rounded corners or other decorative styling" => "Enable additional general layout layers for shadows, rounded corners or other decorative styling",
// "Main shadow start" => "Main shadow start",
// "Main shadow end" => "Main shadow end",
// "Header shadow start" => "Header shadow start",
// "Header shadow end" => "Header shadow end",
// "Middle shadow start" => "Middle shadow start",
// "Middle shadow end" => "Middle shadow end",
// "Center shadow start" => "Center shadow start",
// "Center shadow end" => "Center shadow end",
// "Footer shadow start" => "Footer shadow start",
// "Footer shadow end" => "Footer shadow end",
// "Custom Site Header" => "Custom Site Header",
// "Activate will only show content for admin. Check Publish to use content for all users" => "Activate will only show content for admin. Check Publish to use content for all users",
// "Site Logo and Title" => "Site Logo and Title",
// "Site logo source (image path)" => "Site logo source (image path)",
// "Site logo background color" => "Site logo background color",
// "Site logo background style" => "Site logo background style",
// "Site logo alignment" => "Site logo alignment",
// "Site logo title (on mouse over)" => "Site logo title (on mouse over)",
// "Alt. description (e.g. for text browsers)" => "Alt. description (e.g. for text browsers)",
// "Site title" => "Site title",
// "Site subtitle" => "Site subtitle",
// "Site Search Bar" => "Site Search Bar",
// "Site Login Bar" => "Site Login Bar",
// "Top Bar" => "Top Bar",
// "Site menu bar" => "Site menu bar",
// "Note: Needs feature PHPLayers on(default), or feature CSS Menu on  " => "Note: Needs feature PHPLayers on(default), or feature CSS Menu on  ",
// "Menu ID" => "Menu ID",
// "Current Version" => "Current Version",
// "Custom code" => "Custom code",
// "Users can Flip Columns" => "Users can Flip Columns",
// "always" => "always",
// "user decides" => "user decides",
// "Site Breadcrumbs" => "Site Breadcrumbs",
// "Site location bar" => "Site location bar",
// "at top of page" => "at top of page",
// "at top of center column" => "at top of center column",
// "Prefix breadcrumbs with 'Location : '" => "Prefix breadcrumbs with 'Location : '",
// "Larger font for" => "Larger font for",
// "entire location" => "entire location",
// "page name" => "page name",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Left blank to use the default sender email" => "Left blank to use the default sender email",
// "Email this page" => "Email this page",
// "Custom Site Footer" => "Custom Site Footer",
// "Custom End of <body> Code" => "Custom End of <body> Code",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "Bottom bar (RSS)" => "Bottom bar (RSS)",
// "Power by" => "Power by",
// "Pagination links" => "Pagination links",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Max. number of links around the current item" => "Max. number of links around the current item",
// "Max. number of links after the first or before the last item" => "Max. number of links after the first or before the last item",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Hide pagination when there is only one page" => "Hide pagination when there is only one page",
// "Use Icons" => "Use Icons",
// "JQuery plugins and add-ons" => "JQuery plugins and add-ons",
// "Requires jquery feature" => "Requires jquery feature",
// "JQuery Tooltips" => "JQuery Tooltips",
// "JQuery Tooltips: Customisable help tips" => "JQuery Tooltips: Customisable help tips",
// "JQuery Autocomplete" => "JQuery Autocomplete",
// "JQuery Superfish" => "JQuery Superfish",
// "JQuery Superfish (effects on CSS menus)" => "JQuery Superfish (effects on CSS menus)",
// "JQuery Reflection" => "JQuery Reflection",
// "JQuery Reflection (reflection effect on images)" => "JQuery Reflection (reflection effect on images)",
// "JQuery Cycle (slideshow)" => "JQuery Cycle (slideshow)",
// "For future use" => "For future use",
// "JQuery UI" => "JQuery UI",
// "JQuery UI: More JQuery functionality" => "JQuery UI: More JQuery functionality",
// "JQuery Sheet" => "JQuery Sheet",
// "JQuery Spreadsheet" => "JQuery Spreadsheet",
// "JQuery Sortable Tables" => "JQuery Sortable Tables",
// "Standard UI effects" => "Standard UI effects",
// "Effect for modules etc" => "Effect for modules etc",
// "Main JQuery effect" => "Main JQuery effect",
// "Slide" => "Slide",
// "Blind (UI)" => "Blind (UI)",
// "Clip (UI)" => "Clip (UI)",
// "Drop (UI)" => "Drop (UI)",
// "Explode (UI)" => "Explode (UI)",
// "Fold (UI)" => "Fold (UI)",
// "Puff (UI)" => "Puff (UI)",
// "Slide (UI)" => "Slide (UI)",
// "Effect speed" => "Effect speed",
// "Fast" => "Fast",
// "Slow" => "Slow",
// "Effect direction" => "Effect direction",
// "Vertical" => "Vertical",
// "Horizontal" => "Horizontal",
// "Tab UI effects" => "Tab UI effects",
// "Effect for tabs" => "Effect for tabs",
// "JQuery effect for tabs" => "JQuery effect for tabs",
// "Effect speed for tabs" => "Effect speed for tabs",
// "Effect direction for tabs" => "Effect direction for tabs",
// "Other options" => "Other options",
// "Use Tabs" => "Use Tabs",
// "Favicon icon file name" => "Favicon icon file name",
// "Favicon icon MIME type" => "Favicon icon MIME type",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "Correct PNG images alpha transparency in IE6 (experimental)" => "Correct PNG images alpha transparency in IE6 (experimental)",
// "List of CSS selectors to be fixed, each selector separated by comma" => "List of CSS selectors to be fixed, each selector separated by comma",
// "List of HTMLDomElements to be fixed, each element separated by comma" => "List of HTMLDomElements to be fixed, each element separated by comma",
// "Context Menus (only in file galleries so far)" => "Context Menus (only in file galleries so far)",
// "Use context menus for actions (icons)" => "Use context menus for actions (icons)",
// "Use context menus for actions (text)" => "Use context menus for actions (text)",
// "full path to mapfiles" => "full path to mapfiles",
// "default mapfile" => "default mapfile",
// "Wiki Page for Help" => "Wiki Page for Help",
// "Wiki Page for Comments" => "Wiki Page for Comments",
// "Full path to gdaltindex" => "Full path to gdaltindex",
// "Full path to ogr2ogr" => "Full path to ogr2ogr",
// "Map Zone" => "Map Zone",
// "Generate User Map" => "Generate User Map",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Maximum mailbox size (messages, 0=unlimited)" => "Maximum mailbox size (messages, 0=unlimited)",
// "Maximum mail archive size (messages, 0=unlimited)" => "Maximum mail archive size (messages, 0=unlimited)",
// "Maximum sent box size (messages, 0=unlimited)" => "Maximum sent box size (messages, 0=unlimited)",
// "Change Preferences" => "Change Preferences",
// "Meta tags" => "Meta tags",
// "Keywords" => "Keywords",
// "Include freetags" => "Include freetags",
// "Use thread title instead" => "Use thread title instead",
// "Use image title instead" => "Use image title instead",
// "Geo URL" => "Geo URL",
// "geo.position" => "geo.position",
// "geo.region" => "geo.region",
// "geo.placename" => "geo.placename",
// "Robots" => "Robots",
// "Meta robots" => "Meta robots",
// "Revisit after" => "Revisit after",
// "&quot;Modules&quot; are the boxes of content in the right &amp; left columns" => "&quot;Modules&quot; are the boxes of content in the right &amp; left columns",
// "Admin &gt; Modules" => "Admin &gt; Modules",
// "from the menu to create and edit modules" => "from the menu to create and edit modules",
// "Show module controls" => "Show module controls",
// "Users can shade modules" => "Users can shade modules",
// "Module decides" => "Module decides",
// "Hide anonymous-only modules from registered users" => "Hide anonymous-only modules from registered users",
// "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item" => "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Length" => "Flash Length",
// "Flash Heigth" => "Flash Heigth",
// "Video Length" => "Video Length",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or",
// "Anonymous voting" => "Anonymous voting",
// "Allow re-voting" => "Allow re-voting",
// "Show categories" => "Show categories",
// "Categories disabled" => "Categories disabled",
// "Show objects" => "Show objects",
// "Are you sure you want to install the profile" => "Are you sure you want to install the profile",
// "TikiWiki Profiles" => "TikiWiki Profiles",
// "Profile repository" => "Profile repository",
// "Filter the list of profiles" => "Filter the list of profiles",
// "Profile" => "Profile",
// "Repository" => "Repository",
// "installed" => "installed",
// "Repositories" => "Repositories",
// "Repository URLs" => "Repository URLs",
// "Enter multiple repository URLs, one per line" => "Enter multiple repository URLs, one per line",
// "Data Channels" => "Data Channels",
// "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. " => "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. ",
// "More information" => "More information",
// "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS Modules</strong> menu option, or" => "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS Modules</strong> menu option, or",
// "Feed for articles" => "Feed for articles",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Show Author" => "Show Author",
// "Homepage URL" => "Homepage URL",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Feed for image galleries" => "Feed for image galleries",
// "Individual image galleries" => "Individual image galleries",
// "Feed for file galleries" => "Feed for file galleries",
// "Individual file galleries" => "Individual file galleries",
// "Feed for wiki" => "Feed for wiki",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "Calendar events" => "Calendar events",
// "Feed for directory" => "Feed for directory",
// "Map files" => "Map files",
// "Feed for maps" => "Feed for maps",
// "Defaults" => "Defaults",
// "Default RDF version" => "Default RDF version",
// "Specification" => "Specification",
// "Documentation" => "Documentation",
// "Editor" => "Editor",
// "Webmaster" => "Webmaster",
// "Image Path" => "Image Path",
// "Caching time" => "Caching time",
// "Use <strong>0</strong> for no caching" => "Use <strong>0</strong> for no caching",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public" => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public",
// "You can see users rank by score in the module users_rank, for that go to" => "You can see users rank by score in the module users_rank, for that go to",
// "Admin modules" => "Admin modules",
// "Expiration" => "Expiration",
// "can be seen on page" => "can be seen on page",
// "in Admin menu" => "in Admin menu",
// "Search Results" => "Search Results",
// "Search type" => "Search type",
// "Database search" => "Database search",
// "This search uses the MySQL Full-Text feature" => "This search uses the MySQL Full-Text feature",
// "Tiki search" => "Tiki search",
// "This database-independent search is always enabled" => "This database-independent search is always enabled",
// "Specify the Tiki search settings" => "Specify the Tiki search settings",
// "Refresh mode" => "Refresh mode",
// "Use <strong>0</strong> for no refresh" => "Use <strong>0</strong> for no refresh",
// "Minimum length of search word" => "Minimum length of search word",
// "Max. number of words containing a syllable" => "Max. number of words containing a syllable",
// "Max. age in hours of syllable search cache" => "Max. age in hours of syllable search cache",
// "LRU list purging rate" => "LRU list purging rate",
// "LRU list length" => "LRU list length",
// "When the Database search is enabled, you must manually refresh the Tiki search indexes" => "When the Database search is enabled, you must manually refresh the Tiki search indexes",
// "Refresh all search index now" => "Refresh all search index now",
// "Refresh wiki search index now" => "Refresh wiki search index now",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "Referer Search Highlighting" => "Referer Search Highlighting",
// "Parse the results" => "Parse the results",
// "May impact performance" => "May impact performance",
// "Enabling these options will improve performance, but may show forbidden results" => "Enabling these options will improve performance, but may show forbidden results",
// "Ignore individual object permissions" => "Ignore individual object permissions",
// "Select the items to display on the search results page" => "Select the items to display on the search results page",
// "Object filter" => "Object filter",
// "Search box" => "Search box",
// "Select the information to display for each result" => "Select the information to display for each result",
// "Pertinence" => "Pertinence",
// "Last modified date" => "Last modified date",
// "Search engine friendly url Postfilter" => "Search engine friendly url Postfilter",
// "List of Url Parameters that should go in the path" => "List of Url Parameters that should go in the path",
// "Display article title in the sefurl" => "Display article title in the sefurl",
// "Display blog title in the sefurl" => "Display blog title in the sefurl",
// "Known Types" => "Known Types",
// "Token" => "Token",
// "Invert" => "Invert",
// "Show Usage" => "Show Usage",
// "Delete &amp; Unreference" => "Delete &amp; Unreference",
// "Invert Relation" => "Invert Relation",
// "Self" => "Self",
// "New Types" => "New Types",
// "Fix" => "Fix",
// "No occurences found" => "No occurences found",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "Plugins" => "Plugins",
// "Plugin Aliases" => "Plugin Aliases",
// "Anonymous editors must enter anti-bot code (CAPTCHA)" => "Anonymous editors must enter anti-bot code (CAPTCHA)",
// "Protect email against spam" => "Protect email against spam",
// "External link icon" => "External link icon",
// "External links will be identified with" => "External links will be identified with",
// "Use File Galleries to store pictures " => "Use File Galleries to store pictures ",
// "Allow to post comments as Anonymous" => "Allow to post comments as Anonymous",
// "Wiki paragraph formatting" => "Wiki paragraph formatting",
// "...but still create line breaks within paragraphs" => "...but still create line breaks within paragraphs",
// "&lt;return&gt; for rows" => "&lt;return&gt; for rows",
// "AutoLinks" => "AutoLinks",
// "Show quicktags above textareas" => "Show quicktags above textareas",
// "If disabled, quicktags will be shown to the left of textareas" => "If disabled, quicktags will be shown to the left of textareas",
// "Open Hotwords in new window" => "Open Hotwords in new window",
// "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting",
// "Plugin disabled" => "Plugin disabled",
// "Default size" => "Default size",
// "Comments " => "Comments ",
// "Forum reply" => "Forum reply",
// "About plugins" => "About plugins",
// "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below" => "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below",
// "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>" => "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>",
// "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below" => "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below",
// "Edit plugin icons" => "Edit plugin icons",
// "Enable edit plugin icons" => "Enable edit plugin icons",
// "(experimental - not comprehensively tested and requires new JQuery feature)" => "(experimental - not comprehensively tested and requires new JQuery feature)",
// "Enable" => "Enable",
// "Disable edit plugin icon (make plugin inline)" => "Disable edit plugin icon (make plugin inline)",
// "About plugin aliases" => "About plugin aliases",
// "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}" => "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}",
// "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}" => "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}",
// "Available Alias" => "Available Alias",
// "Enable Plugins" => "Enable Plugins",
// "General Information" => "General Information",
// "Plugin Name" => "Plugin Name",
// "Base Plugin" => "Base Plugin",
// "Body Label" => "Body Label",
// "Dependencies" => "Dependencies",
// "Validation" => "Validation",
// "Inline (No Plugin Edit UI)" => "Inline (No Plugin Edit UI)",
// "Simple Plugin Arguments" => "Simple Plugin Arguments",
// "Argument" => "Argument",
// "New Argument" => "New Argument",
// "Plugin Parameter Documentation" => "Plugin Parameter Documentation",
// "Safe" => "Safe",
// "Plugin Body" => "Plugin Body",
// "Ignore User Input" => "Ignore User Input",
// "Default Content" => "Default Content",
// "Encoding" => "Encoding",
// "Argument Source (if different)" => "Argument Source (if different)",
// "Default Value" => "Default Value",
// "Composed Plugin Arguments" => "Composed Plugin Arguments",
// "Pattern" => "Pattern",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "Tracker attachment preferences" => "Tracker attachment preferences",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "Validate choice" => "Validate choice",
// "Tracker attachments" => "Tracker attachments",
// "Storage" => "Storage",
// "No records" => "No records",
// "Change all to db" => "Change all to db",
// "Change all to file" => "Change all to file",
// "Include a flag by each e-mail to quickly flag/un-flag them" => "Include a flag by each e-mail to quickly flag/un-flag them",
// "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used" => "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used",
// "Lookup" => "Lookup",
// "Test Input" => "Test Input",
// "Response Information" => "Response Information",
// "OIntegrate Version" => "OIntegrate Version",
// "Not supported" => "Not supported",
// "Schema Version" => "Schema Version",
// "Schema Documentation" => "Schema Documentation",
// "Available" => "Available",
// "Not specified, default used" => "Not specified, default used",
// "Content Type" => "Content Type",
// "Not specified" => "Not specified",
// "Returned Data" => "Returned Data",
// "Proposed Templates" => "Proposed Templates",
// "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters" => "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters",
// "Register Service" => "Register Service",
// "Registered Templates" => "Registered Templates",
// "Engine" => "Engine",
// "Output" => "Output",
// "Register Template" => "Register Template",
// "Use the 'Quick Edit' module to easily create or edit wiki pages" => "Use the 'Quick Edit' module to easily create or edit wiki pages",
// "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules" => "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules",
// "Staging &amp; Approval" => "Staging &amp; Approval",
// "Page Listings" => "Page Listings",
// "If the page does not exist, it will be created" => "If the page does not exist, it will be created",
// "Wiki link format" => "Wiki link format",
// "Latin" => "Latin",
// "Select the characters that can be used with Wiki link syntax: ((page name))" => "Select the characters that can be used with Wiki link syntax: ((page name))",
// "Page display" => "Page display",
// "Page ID" => "Page ID",
// "Page version" => "Page version",
// "Page name display stripper" => "Page name display stripper",
// "Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>" => "Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>",
// "Allow override per page" => "Allow override per page",
// "Display show/hide icon displayed before headings" => "Display show/hide icon displayed before headings",
// "Wiki action bar" => "Wiki action bar",
// "Buttons: Save, Preview, Cancel, .." => "Buttons: Save, Preview, Cancel, ..",
// "Page navigation bar location" => "Page navigation bar location",
// "When using the ...page... page break wiki syntax" => "When using the ...page... page break wiki syntax",
// "Wiki top line" => "Wiki top line",
// "Neither" => "Neither",
// "Page description, icons, backlinks, .." => "Page description, icons, backlinks, ..",
// "Wiki buttons" => "Wiki buttons",
// "Buttons: Edit, Source, Remove, .." => "Buttons: Edit, Source, Remove, ..",
// "Cache wiki pages (global)" => "Cache wiki pages (global)",
// "Individual cache" => "Individual cache",
// "Warn on edit conflict" => "Warn on edit conflict",
// "Edit idle timeout" => "Edit idle timeout",
// "Save draft" => "Save draft",
// "Requires AJAX" => "Requires AJAX",
// "experimental" => "experimental",
// "Edit section" => "Edit section",
// "Edit section level" => "Edit section level",
// "Allow minor edits" => "Allow minor edits",
// "Minor edits do not flag new content for translation and do not send watch notifications" => "Minor edits do not flag new content for translation and do not send watch notifications",
// "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled" => "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled",
// "Regex search and replace" => "Regex search and replace",
// "Log bytes changes (+/-) in action logs" => "Log bytes changes (+/-) in action logs",
// "Display by default" => "Display by default",
// "Manage attachments" => "Manage attachments",
// "Tag for current wiki" => "Tag for current wiki",
// "Restore wiki to tag" => "Restore wiki to tag",
// "Restore" => "Restore",
// "WikiWords" => "WikiWords",
// "Accept dashes and underscores in WikiWords" => "Accept dashes and underscores in WikiWords",
// "Link plural WikiWords to their singular forms" => "Link plural WikiWords to their singular forms",
// "Maximum number of versions" => "Maximum number of versions",
// "Never delete versions younger than" => "Never delete versions younger than",
// "Display IP address" => "Display IP address",
// "Default diff style" => "Default diff style",
// "HTML diff" => "HTML diff",
// "Side-by-side diff" => "Side-by-side diff",
// "Side-by-side diff by characters" => "Side-by-side diff by characters",
// "Inline diff" => "Inline diff",
// "Inline diff by characters" => "Inline diff by characters",
// "Full side-by-side diff by characters" => "Full side-by-side diff by characters",
// "Full inline diff" => "Full inline diff",
// "Full inline diff by characters" => "Full inline diff by characters",
// "History includes only page data, description, and change comment" => "History includes only page data, description, and change comment",
// "Forums are disabled" => "Forums are disabled",
// "Forum for discussion" => "Forum for discussion",
// "View source" => "View source",
// "Polls are disabled" => "Polls are disabled",
// "Open page as structure" => "Open page as structure",
// "Make structure from page" => "Make structure from page",
// "Categorize structure pages together" => "Categorize structure pages together",
// "Create webhelp from structure" => "Create webhelp from structure",
// "Import HTML" => "Import HTML",
// "Import pages" => "Import pages",
// "Slideshows" => "Slideshows",
// "User's page" => "User's page",
// "UserPage prefix" => "UserPage prefix",
// "Users can lock pages" => "Users can lock pages",
// "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page" => "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page",
// "Wiki watch" => "Wiki watch",
// "Create watch for author on page creation" => "Create watch for author on page creation",
// "Enable watch events when I am the editor" => "Enable watch events when I am the editor",
// "Watch minor edits" => "Watch minor edits",
// "Use wiki page staging and approval" => "Use wiki page staging and approval",
// "Force bounce of editing of approved pages to staging" => "Force bounce of editing of approved pages to staging",
// "Delete staging pages at approval" => "Delete staging pages at approval",
// "If not in the group, edit is always redirected to the staging page edit" => "If not in the group, edit is always redirected to the staging page edit",
// "Unique page name prefix to indicate staging copy" => "Unique page name prefix to indicate staging copy",
// "Hide page name prefix" => "Hide page name prefix",
// "Staging" => "Staging",
// "Approved" => "Approved",
// "(mandatory for feature to work)" => "(mandatory for feature to work)",
// "Out-of-sync" => "Out-of-sync",
// "Categorize approved pages with categories of staging copy on approval" => "Categorize approved pages with categories of staging copy on approval",
// "Freetags are disabled" => "Freetags are disabled",
// "Replace freetags with that of staging pages, on approval" => "Replace freetags with that of staging pages, on approval",
// "Add new freetags of approved copy (into tags field) when editing staging pages" => "Add new freetags of approved copy (into tags field) when editing staging pages",
// "Orphan page" => "Orphan page",
// "Configuration" => "Configuration",
// "Select which items to display when listing pages" => "Select which items to display when listing pages",
// "Name length" => "Name length",
// "Edit comments" => "Edit comments",
// "Edit Comments length" => "Edit Comments length",
// "Categories path" => "Categories path",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "Wysiwyg Editor is optional" => "Wysiwyg Editor is optional",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Toolbar content" => "Toolbar content",
// "Database Version Problem" => "Database Version Problem",
// "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>" => "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>",
// "The following list of changes has been applied" => "The following list of changes has been applied",
// "disabled" => "disabled",
// "enabled" => "enabled",
// "information" => "information",
// "preference" => "preference",
// "preference name" => "preference name",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Administration features" => "Administration features",
// "Security" => "Security",
// "TikiCache/System" => "TikiCache/System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Edit Languages" => "Edit Languages",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "Look &amp; feel" => "Look &amp; feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "Stats &amp; banners" => "Stats &amp; banners",
// "Report" => "Report",
// "Setting" => "Setting",
// "Please select some actions to view" => "Please select some actions to view",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot" => "Group Bar Plot",
// "Accumulated Bar Plot" => "Accumulated Bar Plot",
// "Legend background color" => "Legend background color",
// "Save graphs to image gallery" => "Save graphs to image gallery",
// "contribution" => "contribution",
// "contributor" => "contributor",
// "Edit Action" => "Edit Action",
// "Save Action" => "Save Action",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "recorded" => "recorded",
// "Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki page actions except viewed will always be recorded but can be not reported",
// "Configure" => "Configure",
// "Create Calendar" => "Create Calendar",
// "View Calendars" => "View Calendars",
// "Edit Calendar" => "Edit Calendar",
// "Subscription" => "Subscription",
// "Perso" => "Perso",
// "View Calendar" => "View Calendar",
// "Add Event" => "Add Event",
// "Create/Edit Calendars" => "Create/Edit Calendars",
// "Custom Participants" => "Custom Participants",
// "Custom URL" => "Custom URL",
// "Custom Subscription List" => "Custom Subscription List",
// "Personal Calendar" => "Personal Calendar",
// "Start of day" => "Start of day",
// "End of day" => "End of day",
// "Standard Colors" => "Standard Colors",
// "Green" => "Green",
// "Blue" => "Blue",
// "Purple" => "Purple",
// "Red" => "Red",
// "Orange" => "Orange",
// "Yellow" => "Yellow",
// "Let me select my own colors" => "Let me select my own colors",
// "Custom foreground color" => "Custom foreground color",
// "Ex" => "Ex",
// "Custom background color" => "Custom background color",
// "Default event status" => "Default event status",
// "Show in calendar view" => "Show in calendar view",
// "Group of users alerted when calendar event is modified" => "Group of users alerted when calendar event is modified",
// "Delete events older than" => "Delete events older than",
// "Browse the category system" => "Browse the category system",
// "Current Category ID" => "Current Category ID",
// "Edit permissions for this category" => "Edit permissions for this category",
// "Perms inherited from closest parent if possible or from global perms" => "Perms inherited from closest parent if possible or from global perms",
// "Assign permissions automatically" => "Assign permissions automatically",
// "recommended for best performance" => "recommended for best performance",
// "Remove from this Category" => "Remove from this Category",
// "Admin charts" => "Admin charts",
// "Users can vote for only one item from this chart per period" => "Users can vote for only one item from this chart per period",
// "Prevent users from voting for the same item more than once" => "Prevent users from voting for the same item more than once",
// "Use in" => "Use in",
// "No features are configured to use templates" => "No features are configured to use templates",
// "Visible in no sections" => "Visible in no sections",
// "Remove section" => "Remove section",
// "Admin Contributions" => "Admin Contributions",
// "Edit the contribution" => "Edit the contribution",
// "Contributions are mandatory in wiki pages" => "Contributions are mandatory in wiki pages",
// "Contributions are mandatory in forums" => "Contributions are mandatory in forums",
// "Contributions are mandatory in comments" => "Contributions are mandatory in comments",
// "Contributions are mandatory in blogs" => "Contributions are mandatory in blogs",
// "Contributions are displayed in the comment/post" => "Contributions are displayed in the comment/post",
// "Create a new contribution" => "Create a new contribution",
// "List of contributions" => "List of contributions",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}" => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link" => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link",
// "Use Admin DSN to define the database to be used by the SQL plugin" => "Use Admin DSN to define the database to be used by the SQL plugin",
// "Admin External Wikis" => "Admin External Wikis",
// "View template" => "View template",
// "tiki admin external wikis template" => "tiki admin external wikis template",
// "Edit template" => "Edit template",
// "Create/Edit External Wiki" => "Create/Edit External Wiki",
// "Enable Features" => "Enable Features",
// "Create new forum" => "Create new forum",
// "Duplicate forum" => "Duplicate forum",
// "View this forum" => "View this forum",
// "Import forums" => "Import forums",
// "Only allow replies to the first message (flat forum)" => "Only allow replies to the first message (flat forum)",
// "Posts can be rated" => "Posts can be rated",
// "Display last post titles" => "Display last post titles",
// "no display" => "no display",
// "Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address",
// "Send mails even when the post is generated by inbound mail" => "Send mails even when the post is generated by inbound mail",
// "Append a reply link to outbound mails" => "Append a reply link to outbound mails",
// "Originating e-mail address for mails from this forum" => "Originating e-mail address for mails from this forum",
// "Set topics preferences" => "Set topics preferences",
// "Show topics preferences" => "Show topics preferences",
// "hide topics preferences" => "hide topics preferences",
// "Set thread preferences" => "Set thread preferences",
// "Show threads preferences" => "Show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default style for threads" => "Default style for threads",
// "Duplicate Forum" => "Duplicate Forum",
// "Duplicate" => "Duplicate",
// "List Forums" => "List Forums",
// ".." => "..",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature" => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature",
// "Edit Repository" => "Edit Repository",
// "Create New Repository" => "Create New Repository",
// "List Repositories" => "List Repositories",
// "New Repository" => "New Repository",
// "View Repository" => "View Repository",
// "Human readable repository name" => "Human readable repository name",
// "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')",
// "File name of start page" => "File name of start page",
// "Start page" => "Start page",
// "CSS file to load when browse this repository" => "CSS file to load when browse this repository",
// "CSS file" => "CSS file",
// "Is repository visible to users" => "Is repository visible to users",
// "Can files from repository be cached" => "Can files from repository be cached",
// "Cacheable" => "Cacheable",
// "Are files from repository can be cached" => "Are files from repository can be cached",
// "Clear all cached pages of this repository" => "Clear all cached pages of this repository",
// "Clear cache" => "Clear cache",
// "Seconds count 'till cached page will be expired" => "Seconds count 'till cached page will be expired",
// "Cache expiration" => "Cache expiration",
// "Human readable text description of repository" => "Human readable text description of repository",
// "Available Repositories" => "Available Repositories",
// "CSS File" => "CSS File",
// "Edit rules" => "Edit rules",
// "Edit Rules for Repository" => "Edit Rules for Repository",
// "Configure Repositories" => "Configure Repositories",
// "Configure this Repository" => "Configure this Repository",
// "View this Repository" => "View this Repository",
// "New Rule" => "New Rule",
// "Copy Rules" => "Copy Rules",
// "view/hide copy rules dialog" => "view/hide copy rules dialog",
// "Source repository" => "Source repository",
// "Copy" => "Copy",
// "According this order rules will be applied ('0' or empty = auto)" => "According this order rules will be applied ('0' or empty = auto)",
// "Rule order" => "Rule order",
// "Text to search for" => "Text to search for",
// "Text to replace" => "Text to replace",
// "Is this regular expression or simple search/replacer" => "Is this regular expression or simple search/replacer",
// "Regex" => "Regex",
// "Is case sensitive (for simple replacer)" => "Is case sensitive (for simple replacer)",
// "Case sensitive" => "Case sensitive",
// "subset of chars: imsxeADSXUu, which is regex modifiers" => "subset of chars: imsxeADSXUu, which is regex modifiers",
// "Regex modifiers" => "Regex modifiers",
// "Human readable text description of rule" => "Human readable text description of rule",
// "Check to enable this rule" => "Check to enable this rule",
// "Enabled" => "Enabled",
// "Preview options" => "Preview options",
// "Apply all rules or just this to generate preview" => "Apply all rules or just this to generate preview",
// "Apply all rules" => "Apply all rules",
// "View source code after rules applied" => "View source code after rules applied",
// "Code preview" => "Code preview",
// "Generate HTML preview" => "Generate HTML preview",
// "HTML preview" => "HTML preview",
// "Test file from repository to generate preview for (empty = configured start page)" => "Test file from repository to generate preview for (empty = configured start page)",
// "Preview Results" => "Preview Results",
// "Rules List" => "Rules List",
// "Case" => "Case",
// "Configure/Options" => "Configure/Options",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>" => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>",
// "Mail-in accounts" => "Mail-in accounts",
// "Account" => "Account",
// "Add new Mail-in account" => "Add new Mail-in account",
// "Edit Mail-in account" => "Edit Mail-in account",
// "article-put" => "article-put",
// "Article Topic" => "Article Topic",
// "Article Type" => "Article Type",
// "Admin Types" => "Admin Types",
// "Allow anonymous acces" => "Allow anonymous acces",
// "Allow attachments" => "Allow attachments",
// "Discard to the end from" => "Discard to the end from",
// "Check Mail-in accounts" => "Check Mail-in accounts",
// "Check automatically" => "Check automatically",
// "mn" => "mn",
// "Show Quick Urls" => "Show Quick Urls",
// "Hide Quick Urls" => "Hide Quick Urls",
// "For wiki page, use ((PageName))" => "For wiki page, use ((PageName))",
// "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Use Ctrl+Click to select multiple groups" => "Use Ctrl+Click to select multiple groups",
// "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each" => "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each",
// "section level 0" => "section level 0",
// "section level 1" => "section level 1",
// "section level 2" => "section level 2",
// "section level 3" => "section level 3",
// "sorted section level 0" => "sorted section level 0",
// "separator" => "separator",
// "Choose" => "Choose",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'" => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu" => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format" => "To use a menu in a tiki format",
// "To use menu in a css/suckerfish format" => "To use menu in a css/suckerfish format",
// "To customize the menu's CSS id (#)" => "To customize the menu's CSS id (#)",
// "Folder Icon" => "Folder Icon",
// "Path and filename of closed folder icon" => "Path and filename of closed folder icon",
// "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder" => "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder",
// "In the same directory, include an icon for the opened folder" => "In the same directory, include an icon for the opened folder",
// "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>" => "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>",
// "For example, the default icon is: pics/icons/folder.png" => "For example, the default icon is: pics/icons/folder.png",
// "The name of the \"open folder\" icon is: pics/icons/ofolder.png" => "The name of the \"open folder\" icon is: pics/icons/ofolder.png",
// "Active Permissions" => "Active Permissions",
// "Assign/Edit modules" => "Assign/Edit modules",
// "Move Up" => "Move Up",
// "Move Down" => "Move Down",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y" => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y",
// "The" => "The",
// "Display Modules to All Groups" => "Display Modules to All Groups",
// "setting will override your selection of specific groups" => "setting will override your selection of specific groups",
// "Visibility" => "Visibility",
// "Displayed now for all eligible users even with personal assigned modules" => "Displayed now for all eligible users even with personal assigned modules",
// "Displayed for the eligible users with no personal assigned modules" => "Displayed for the eligible users with no personal assigned modules",
// "Displayed now, can't be unassigned" => "Displayed now, can't be unassigned",
// "Not displayed until a user chooses it" => "Not displayed until a user chooses it",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules" => "to make sure users will notice any newly assigned modules",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site" => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site",
// "Must be wiki parsed" => "Must be wiki parsed",
// "Random active poll" => "Random active poll",
// "Random current poll" => "Random current poll",
// "phpLayersMenus" => "phpLayersMenus",
// "Use phplayermenu" => "Use phplayermenu",
// "Use Wiki Structure" => "Use Wiki Structure",
// "Edit Newsletter" => "Edit Newsletter",
// "You can add several email addresses by separating them with commas" => "You can add several email addresses by separating them with commas",
// "Add email" => "Add email",
// "Add user" => "Add user",
// "Group users" => "Group users",
// "Group subscription also subscribes included groups" => "Group subscription also subscribes included groups",
// "Don't send confirmation mail" => "Don't send confirmation mail",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Subscribe group" => "Subscribe group",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Create Newsletter" => "Create Newsletter",
// "Users can subscribe/unsubscribe to this list" => "Users can subscribe/unsubscribe to this list",
// "Users can subscribe any email address" => "Users can subscribe any email address",
// "Add unsubscribe instructions to each newsletter" => "Add unsubscribe instructions to each newsletter",
// "Validate email addresses" => "Validate email addresses",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Drafts" => "Drafts",
// "Mail notifications" => "Mail notifications",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications",
// "Alert" => "Alert",
// "A user edits an article" => "A user edits an article",
// "A user deletes an article" => "A user deletes an article",
// "Any wiki page is changed" => "Any wiki page is changed",
// "Any wiki page is changed, even minor changes" => "Any wiki page is changed, even minor changes",
// "A comment in a wiki page is posted or edited" => "A comment in a wiki page is posted or edited",
// "PHP error" => "PHP error",
// "Preload Admin Account" => "Preload Admin Account",
// "User / Group" => "User / Group",
// "Multiple" => "Multiple",
// "Trackers Outbound Emails" => "Trackers Outbound Emails",
// "Forums Outbound Emails" => "Forums Outbound Emails",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "Toggle Quick Options" => "Toggle Quick Options",
// "Add Option" => "Add Option",
// "Leave box empty for deleting an option" => "Leave box empty for deleting an option",
// "Votes older than these days are no more considered" => "Votes older than these days are no more considered",
// "0 for no limit" => "0 for no limit",
// "Span" => "Span",
// "Add poll to pages" => "Add poll to pages",
// "Wiki pages" => "Wiki pages",
// "Use Ctrl+Click to select multiple pages" => "Use Ctrl+Click to select multiple pages",
// "Lock the pages" => "Lock the pages",
// "Admin Quicktags" => "Admin Quicktags",
// "Create/Edit QuickTags" => "Create/Edit QuickTags",
// "Quicktags category filter" => "Quicktags category filter",
// "Insert (use 'text' for figuring the selection)" => "Insert (use 'text' for figuring the selection)",
// "Path to the tag icon" => "Path to the tag icon",
// "Tips" => "Tips",
// "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed" => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed",
// "Edit this RSS Module" => "Edit this RSS Module",
// "Create new RSS Module" => "Create new RSS Module",
// "show feed title" => "show feed title",
// "show publish date" => "show publish date",
// "RSS channels" => "RSS channels",
// "Show Date" => "Show Date",
// "View feed" => "View feed",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>" => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>",
// "PHP settings" => "PHP settings",
// "PHP variable" => "PHP variable",
// "Risk Factor" => "Risk Factor",
// "Explanation" => "Explanation",
// "TikiWiki settings" => "TikiWiki settings",
// "Tiki variable" => "Tiki variable",
// "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors" => "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors",
// "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)" => "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)",
// "Security checks" => "Security checks",
// "Check all tiki files" => "Check all tiki files",
// "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini" => "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini",
// "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database" => "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database",
// "File checks" => "File checks",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments" => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments",
// "See end of table for detailed explanations" => "See end of table for detailed explanations",
// "owner" => "owner",
// "special" => "special",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "r" => "r",
// "w" => "w",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results" => "What to do with these check results",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"" => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content" => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information" => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes" => "Inodes that are not files or directories are not part of tiki. Review these Inodes",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod" => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod",
// "Admin Shoutbox Words" => "Admin Shoutbox Words",
// "Add Banned Word" => "Add Banned Word",
// "Are you sure you want to delete this word" => "Are you sure you want to delete this word",
// "The structure" => "The structure",
// "has just been created" => "has just been created",
// "You will remove structure" => "You will remove structure",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict",
// "The following pages have automatically been categorized with the same categories as the structure" => "The following pages have automatically been categorized with the same categories as the structure",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent",
// "Edit structure" => "Edit structure",
// "View structure" => "View structure",
// "PDF" => "PDF",
// "Create WebHelp" => "Create WebHelp",
// "View WebHelp" => "View WebHelp",
// "Xml Zip" => "Xml Zip",
// "Alias" => "Alias",
// "Create New Structure" => "Create New Structure",
// "Add a New Question" => "Add a New Question",
// "This survey stats" => "This survey stats",
// "Edit Survey Question" => "Edit Survey Question",
// "Add a New Question to this survey" => "Add a New Question to this survey",
// "Multiple choices of thumbnails from a file gallery" => "Multiple choices of thumbnails from a file gallery",
// "Wiki textarea" => "Wiki textarea",
// "Rate" => "Rate",
// "Answer is mandatory" => "Answer is mandatory",
// "Number of required answers (for multiple choices)" => "Number of required answers (for multiple choices)",
// "Min" => "Min",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value" => "For a rate, you can give the maximum value",
// "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4" => "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4",
// "Create New Survey" => "Create New Survey",
// "Tiki Cache/System Admin" => "Tiki Cache/System Admin",
// "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)" => "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)",
// "Exterminator of cached content" => "Exterminator of cached content",
// "Directory to exterminate" => "Directory to exterminate",
// "Clear all Tiki caches" => "Clear all Tiki caches",
// "Empty" => "Empty",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save" => "Directories to save",
// "Full Path to the Zip File" => "Full Path to the Zip File",
// "Generate a zip of those directories" => "Generate a zip of those directories",
// "A zip has been written to {\$zipPath}" => "A zip has been written to {\$zipPath}",
// "Directory is not writeable" => "Directory is not writeable",
// "Templates compiler" => "Templates compiler",
// "Compile" => "Compile",
// "Advanced feature" => "Advanced feature",
// "Fix UTF-8 Errors in Tables" => "Fix UTF-8 Errors in Tables",
// "Warning: Make a backup of your Database before using this function" => "Warning: Make a backup of your Database before using this function",
// "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini" => "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini",
// "This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "This function converts ISO-8859-1 encoded strings in your tables to UTF-8",
// "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1",
// "UTF-8 Errors fixed" => "UTF-8 Errors fixed",
// "Investigate" => "Investigate",
// "Fix it" => "Fix it",
// "Inactive - Click to Activate" => "Inactive - Click to Activate",
// "Active - Click to Deactivate" => "Active - Click to Deactivate",
// "Remove with articles" => "Remove with articles",
// "New tracker field" => "New tracker field",
// "Select list items that will be displayed" => "Select list items that will be displayed",
// "Multilingual content" => "Multilingual content",
// "Column is searchable" => "Column is searchable",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "Field is hidden" => "Field is hidden",
// "not hidden" => "not hidden",
// "visible to admin only" => "visible to admin only",
// "editable by admin only" => "editable by admin only",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by" => "Visible by",
// "Editable by" => "Editable by",
// "Field is mandatory" => "Field is mandatory",
// "Description text is wiki-parsed" => "Description text is wiki-parsed",
// "Error message" => "Error message",
// "Searchable" => "Searchable",
// "Hidden" => "Hidden",
// "Mandatory" => "Mandatory",
// "Import/Export Trackers Fields" => "Import/Export Trackers Fields",
// "Export fieldId also" => "Export fieldId also",
// "Check the box to re-import in this tracker and change the fields" => "Check the box to re-import in this tracker and change the fields",
// "Uncheck the box to import in another database" => "Uncheck the box to import in another database",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "Edit Tracker" => "Edit Tracker",
// "Import/Export" => "Import/Export",
// "Create Tracker" => "Create Tracker",
// "Duplicate Tracker" => "Duplicate Tracker",
// "with" => "with",
// "Create/Edit Tracker" => "Create/Edit Tracker",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Create a group for each item" => "Create a group for each item",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL",
// "Show status" => "Show status",
// "Default status displayed in list mode" => "Default status displayed in list mode",
// "Show status to tracker admin only" => "Show status to tracker admin only",
// "Send copies of all activity in this tracker to this e-mail address" => "Send copies of all activity in this tracker to this e-mail address",
// "Use simplified e-mail format" => "Use simplified e-mail format",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "New items are created with status" => "New items are created with status",
// "Authoritative status for modified items" => "Authoritative status for modified items",
// "No change" => "No change",
// "Item creator can modify his items" => "Item creator can modify his items",
// "The tracker needs a user field with the option 1" => "The tracker needs a user field with the option 1",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Member of the default group of creator can modify items" => "Member of the default group of creator can modify items",
// "The tracker needs a group field with the option 1" => "The tracker needs a group field with the option 1",
// "Format if not the default short one" => "Format if not the default short one",
// "Show creation date when viewing tracker item" => "Show creation date when viewing tracker item",
// "Show lastModif date when viewing tracker item" => "Show lastModif date when viewing tracker item",
// "What field is used for default sort" => "What field is used for default sort",
// "ItemId" => "ItemId",
// "What is default sort order in list" => "What is default sort order in list",
// "Tracker items allow ratings" => "Tracker items allow ratings",
// "with values" => "with values",
// "and display rating results in listing" => "and display rating results in listing",
// "and display comments in listing" => "and display comments in listing",
// "and display last comment user/date" => "and display last comment user/date",
// "and display attachments in listing" => "and display attachments in listing",
// "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)",
// "Filetype" => "Filetype",
// "LongDesc" => "LongDesc",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "After" => "After",
// "Before" => "Before",
// "Do not show empty fields in item view" => "Do not show empty fields in item view",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items",
// "Group of users alerted when tracker is modified" => "Group of users alerted when tracker is modified",
// "Import/export trackers" => "Import/export trackers",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "Edit group" => "Edit group",
// "Members" => "Members",
// "User Choice" => "User Choice",
// "Only directly included" => "Only directly included",
// "will have all the permissions of the included groups" => "will have all the permissions of the included groups",
// "Group Homepage" => "Group Homepage",
// "Use wiki page name or full URL" => "Use wiki page name or full URL",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)" => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a group tracker .." => "choose a group tracker ..",
// "choose a field .." => "choose a field ..",
// "Users Information Tracker" => "Users Information Tracker",
// "choose a users tracker .." => "choose a users tracker ..",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Group tracker item not found" => "Group tracker item not found",
// "Create Item" => "Create Item",
// "Choose a field .." => "Choose a field ..",
// "Members List" => "Members List",
// "Remove from Group" => "Remove from Group",
// "users in group" => "users in group",
// "Add to group" => "Add to group",
// "Download CSV export" => "Download CSV export",
// "Assign users to group" => "Assign users to group",
// "Each user in the file must already exist" => "Each user in the file must already exist",
// "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>" => "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>",
// "CSV File" => "CSV File",
// "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login" => "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login",
// "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login" => "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login",
// "Updated users" => "Updated users",
// "Edit user" => "Edit user",
// "More Criteria" => "More Criteria",
// "Group (direct)" => "Group (direct)",
// "Edit Account Settings" => "Edit Account Settings",
// "ago" => "ago",
// "Need to validate email" => "Need to validate email",
// "Assign to group" => "Assign to group",
// "Edit Included Group" => "Edit Included Group",
// "Edit Group" => "Edit Group",
// "Change user preferences" => "Change user preferences",
// "Validate user" => "Validate user",
// "Remove Users and their Userpages" => "Remove Users and their Userpages",
// "Manage Group Assignments" => "Manage Group Assignments",
// "Set Default Groups" => "Set Default Groups",
// "Send a wiki page by Email" => "Send a wiki page by Email",
// "Assign selected to" => "Assign selected to",
// "Remove selected from" => "Remove selected from",
// "the following groups" => "the following groups",
// "Tip: Hold down CTRL to select multiple" => "Tip: Hold down CTRL to select multiple",
// "Set the default group of the selected users to" => "Set the default group of the selected users to",
// "Template wiki page" => "Template wiki page",
// "Assign user to Groups" => "Assign user to Groups",
// "Use the email as username" => "Use the email as username",
// "Lowercase only" => "Lowercase only",
// "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)" => "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)",
// "Warning: it will mess with slave intertiki sites that use this one as master" => "Warning: it will mess with slave intertiki sites that use this one as master",
// "No password is required" => "No password is required",
// "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth" => "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth",
// "Repeat Password" => "Repeat Password",
// "User must change password at first login" => "User must change password at first login",
// "Send an email to the user in order to allow him to validate his account" => "Send an email to the user in order to allow him to validate his account",
// "Last Login" => "Last Login",
// "User tracker item : {\$usersitemid}" => "User tracker item : {\$usersitemid}",
// "You do not have permission to edit this user" => "You do not have permission to edit this user",
// "Overwrite but keep the previous login if the login exists in another case" => "Overwrite but keep the previous login if the login exists in another case",
// "Don't overwrite" => "Don't overwrite",
// "Overwrite groups" => "Overwrite groups",
// "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>" => "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>",
// "Loading.." => "Loading..",
// "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences" => "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "New attachments" => "New attachments",
// "Old attachments" => "Old attachments",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Admin Article Types" => "Admin Article Types",
// "List of types" => "List of types",
// "Show Help" => "Show Help",
// "Article type" => "Article type",
// "Shows up in the drop down list of article types" => "Shows up in the drop down list of article types",
// "Allow ratings by the author" => "Allow ratings by the author",
// "Show before publish date" => "Show before publish date",
// "non-admins can view before the publish date" => "non-admins can view before the publish date",
// "Show after expire date" => "Show after expire date",
// "non-admins can view after the expire date" => "non-admins can view after the expire date",
// "Heading only" => "Heading only",
// "No article body, heading only" => "No article body, heading only",
// "Allow comments for this type" => "Allow comments for this type",
// "Comment Can Rate Article" => "Comment Can Rate Article",
// "Allow comments to include a rating value" => "Allow comments to include a rating value",
// "Show image" => "Show image",
// "Show topic or own image" => "Show topic or own image",
// "Show avatar" => "Show avatar",
// "Show author's avatar" => "Show author's avatar",
// "Show author" => "Show author",
// "Show author name" => "Show author name",
// "Show publish date" => "Show publish date",
// "Show expire date" => "Show expire date",
// "Show reads" => "Show reads",
// "Show the number of times the article was read" => "Show the number of times the article was read",
// "Show size" => "Show size",
// "Show the size of the article" => "Show the size of the article",
// "Show topline" => "Show topline",
// "Show a small title over the title" => "Show a small title over the title",
// "Show subtitle" => "Show subtitle",
// "Show the subtitle" => "Show the subtitle",
// "Show source" => "Show source",
// "Show link to source after article body" => "Show link to source after article body",
// "Show Image Caption" => "Show Image Caption",
// "Show a legend under the image" => "Show a legend under the image",
// "Show Language" => "Show Language",
// "Show the language" => "Show the language",
// "Creator can edit" => "Creator can edit",
// "The person who submits an article of this type can edit it" => "The person who submits an article of this type can edit it",
// "Actions on this article type" => "Actions on this article type",
// "Show lang" => "Show lang",
// "Classified" => "Classified",
// "Create a new type" => "Create a new type",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Level configuration" => "Level configuration",
// "Assign User {\$assign_user} to Groups" => "Assign User {\$assign_user} to Groups",
// "Default Group" => "Default Group",
// "Assign Perms to this Group" => "Assign Perms to this Group",
// "Assign User to Group" => "Assign User to Group",
// "Directory batch upload" => "Directory batch upload",
// "available images" => "available images",
// "Remove File Extension from Image Name" => "Remove File Extension from Image Name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "Convert the last sub directory to a sub gallery" => "Convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Select a Gallery" => "Select a Gallery",
// "Browse File Gallery" => "Browse File Gallery",
// "Please do not use this feature to upload data into the database" => "Please do not use this feature to upload data into the database",
// "available files" => "available files",
// "Select a File Gallery" => "Select a File Gallery",
// "Process files" => "Process files",
// "Use Wysiwyg Editor" => "Use Wysiwyg Editor",
// "Use Normal Editor" => "Use Normal Editor",
// "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. ",
// "Mark entry as private" => "Mark entry as private",
// "Report to Webmaster" => "Report to Webmaster",
// "Powered by" => "Powered by",
// "Made with" => "Made with",
// "powered by" => "powered by",
// "The TikiWiki Community" => "The TikiWiki Community",
// "TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
// "Execution time" => "Execution time",
// "Memory usage" => "Memory usage",
// "database queries used in " => "database queries used in ",
// "Server load" => "Server load",
// "Last update from SVN" => "Last update from SVN",
// "Watch Only This Category" => "Watch Only This Category",
// "Watch This Category and Their Descendants" => "Watch This Category and Their Descendants",
// "Stop Watching Only This Category" => "Stop Watching Only This Category",
// "Stop Watching This Category and Their Descendants" => "Stop Watching This Category and Their Descendants",
// "Admin Category" => "Admin Category",
// "Admin the Category System" => "Admin the Category System",
// "Browse in" => "Browse in",
// "Trackers Items" => "Trackers Items",
// "Sheets" => "Sheets",
// "in the current category - and its subcategories: " => "in the current category - and its subcategories: ",
// "Hide subcategories objects" => "Hide subcategories objects",
// "Show subcategories objects" => "Show subcategories objects",
// "Upper level" => "Upper level",
// "Browse related tags" => "Browse related tags",
// "Network of Tags related to" => "Network of Tags related to",
// "With all selected tags" => "With all selected tags",
// "With one selected tag" => "With one selected tag",
// "With last selected tag" => "With last selected tag",
// "More Popular Tags" => "More Popular Tags",
// "Alphabetically" => "Alphabetically",
// "By Size" => "By Size",
// "Cloud" => "Cloud",
// "\$feature_label" => "\$feature_label",
// "results found" => "results found",
// "List Galleries" => "List Galleries",
// "Directory Batch" => "Directory Batch",
// "All Images" => "All Images",
// "Monitor this Gallery" => "Monitor this Gallery",
// "Stop Monitoring this Gallery" => "Stop Monitoring this Gallery",
// "subgallery" => "subgallery",
// "Subgallery" => "Subgallery",
// "Hit" => "Hit",
// "Details" => "Details",
// "You can view this gallery's configured image (first, random, etc.) in your browser using" => "You can view this gallery's configured image (first, random, etc.) in your browser using",
// "You can include the gallery's image in an HTML page using one of these lines" => "You can include the gallery's image in an HTML page using one of these lines",
// "You can include the image in a tiki page using one of these lines" => "You can include the image in a tiki page using one of these lines",
// "Slideshow Forward" => "Slideshow Forward",
// "Cyclic" => "Cyclic",
// "Direction" => "Direction",
// "Click to zoom" => "Click to zoom",
// "Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/decimal degrees)",
// "Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/decimal degrees)",
// "You can include the image in an HTML page using one of these lines" => "You can include the image in an HTML page using one of these lines",
// "Admin Calendar" => "Admin Calendar",
// "Export Calendars" => "Export Calendars",
// "Click to export calendars" => "Click to export calendars",
// "Visible Calendars" => "Visible Calendars",
// "Click to select visible calendars" => "Click to select visible calendars",
// "Export calendars" => "Export calendars",
// "advanced parameters" => "advanced parameters",
// "Edit event" => "Edit event",
// "Delete event" => "Delete event",
// "View event" => "View event",
// "All-Day" => "All-Day",
// "Website" => "Website",
// "View this Week" => "View this Week",
// "Change Focus" => "Change Focus",
// "View this Day" => "View this Day",
// "o" => "o",
// "Calendar Item" => "Calendar Item",
// "New event" => "New event",
// "New Calendar Item" => "New Calendar Item",
// "Recurrence" => "Recurrence",
// "This event depends on a recurrence rule" => "This event depends on a recurrence rule",
// "This event is not recurrent" => "This event is not recurrent",
// "On a weekly basis" => "On a weekly basis",
// "Each" => "Each",
// "of the week" => "of the week",
// "On a monthly basis" => "On a monthly basis",
// "of the month" => "of the month",
// "On a yearly basis" => "On a yearly basis",
// "There's no such date as" => "There's no such date as",
// "Starting on" => "Starting on",
// "ending by" => "ending by",
// "ending after" => "ending after",
// "events" => "events",
// "Start period" => "Start period",
// "End after" => "End after",
// "occurrences" => "occurrences",
// "End before" => "End before",
// "Event is repeated" => "Event is repeated",
// "every" => "every",
// "of every month" => "of every month",
// "on each" => "on each",
// "Date and time of end" => "Date and time of end",
// "Events cannot end before they start" => "Events cannot end before they start",
// "or new" => "or new",
// "Choose users to alert" => "Choose users to alert",
// "chair" => "chair",
// "default role" => "default role",
// "required participant" => "required participant",
// "optional participant" => "optional participant",
// "non participant" => "non participant",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"" => "If no role is provided, default role will be \"Chair participant\"",
// "Update this event only" => "Update this event only",
// "Update every unchanged events of this recurrence rule" => "Update every unchanged events of this recurrence rule",
// "Update every events of this recurrence rule" => "Update every events of this recurrence rule",
// "Delete Recurrent events" => "Delete Recurrent events",
// "Calendar import" => "Calendar import",
// "Calendar has been updated" => "Calendar has been updated",
// "%m/%d" => "%m/%d",
// "Avanced parameters for iCal export" => "Avanced parameters for iCal export",
// "Calendars to be exported" => "Calendars to be exported",
// "Assign permissions to category" => "Assign permissions to category",
// "Categories checking is not done in the database search" => "Categories checking is not done in the database search",
// "Current permissions for this category" => "Current permissions for this category",
// "Remove from this Category Only" => "Remove from this Category Only",
// "Remove from this Category &amp; all its Children" => "Remove from this Category &amp; all its Children",
// "Assign permissions" => "Assign permissions",
// "this category &amp; all its children" => "this category &amp; all its children",
// "this category only" => "this category only",
// "Assigning permissions for <b>all children</b> is recommended for best performance" => "Assigning permissions for <b>all children</b> is recommended for best performance",
// "Your account has been validated" => "Your account has been validated",
// "You have to choose a password to use this account" => "You have to choose a password to use this account",
// "Click here to send us an email" => "Click here to send us an email",
// "Send another message" => "Send another message",
// "Group View" => "Group View",
// "Publish this contact to groups" => "Publish this contact to groups",
// "You can browse the generated WebHelp here" => "You can browse the generated WebHelp here",
// "Top page" => "Top page",
// "You cannot add sites until Directory Categories are setup" => "You cannot add sites until Directory Categories are setup",
// "Please contact the Site Administrator" => "Please contact the Site Administrator",
// "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>" => "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>",
// "The following site was added, but may require validation by the admin before appearing on the lists" => "The following site was added, but may require validation by the admin before appearing on the lists",
// "Edit a site" => "Edit a site",
// "Add a site" => "Add a site",
// "Directory Categories" => "Directory Categories",
// "Use Ctrl+Click to select multiple directory categories" => "Use Ctrl+Click to select multiple directory categories",
// "Parent directory category" => "Parent directory category",
// "Allow sites in this directory category" => "Allow sites in this directory category",
// "Show number of sites in this directory category" => "Show number of sites in this directory category",
// "Directory Subcategories" => "Directory Subcategories",
// "Admin related directory categories" => "Admin related directory categories",
// "Directory Category" => "Directory Category",
// "Use Ctrl+Click to select multiple categories" => "Use Ctrl+Click to select multiple categories",
// "Perform action with selected" => "Perform action with selected",
// "Add a Directory Category" => "Add a Directory Category",
// "in current directory category" => "in current directory category",
// "Related directory categories" => "Related directory categories",
// "Total directory categories" => "Total directory categories",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "Topline" => "Topline",
// "Subtitle" => "Subtitle",
// "Image caption" => "Image caption",
// "Expiration Date" => "Expiration Date",
// "Emails to be notified (separated with commas)" => "Emails to be notified (separated with commas)",
// "-1 for unlimited" => "-1 for unlimited",
// "Max clicks" => "Max clicks",
// "Or, create a new zone" => "Or, create a new zone",
// "Use Flash" => "Use Flash",
// "Movie Size" => "Movie Size",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "Remove Zones (you lose entered info for the banner)" => "Remove Zones (you lose entered info for the banner)",
// "Create Blog" => "Create Blog",
// "A category is mandatory" => "A category is mandatory",
// "Show user avatar" => "Show user avatar",
// "The file will be saved in" => "The file will be saved in",
// "For more information, please see <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki Page Editor" => "For more information, please see <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki Page Editor",
// "More help on editing wiki pages" => "More help on editing wiki pages",
// "Wiki Syntax" => "Wiki Syntax",
// "The syntax system used for creating pages in TikiWiki" => "The syntax system used for creating pages in TikiWiki",
// "Bold text" => "Bold text",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Underlined text" => "Underlined text",
// "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background" => "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background",
// "Deleted text" => "Deleted text",
// "2 dashes" => "2 dashes",
// "Headings" => "Headings",
// "Show/Hide" => "Show/Hide",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "Autonumbered Headings" => "Autonumbered Headings",
// "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Horizontal rule" => "Horizontal rule",
// "Text box" => "Text box",
// "Centered text" => "Centered text",
// "Dynamic variables" => "Dynamic variables",
// "Inserts an editable variable" => "Inserts an editable variable",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)" => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)",
// "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))",
// "Square Brackets" => "Square Brackets",
// "Use [[foo] to show [foo]" => "Use [[foo] to show [foo]",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus (useful in list to continue at the same level)" => "Creates an indentation for each plus (useful in list to continue at the same level)",
// "row" => "row",
// "Monospace font" => "Monospace font",
// "Code sample" => "Code sample",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "to separate pages" => "to separate pages",
// "Prevents wiki parsing of the enclosed data" => "Prevents wiki parsing of the enclosed data",
// "Preformated sections" => "Preformated sections",
// "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text" => "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text",
// "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar" => "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar",
// "Block Preformatting" => "Block Preformatting",
// "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that" => "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew" => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew",
// "Special characters" => "Special characters",
// "hard space" => "hard space",
// "numeric between ~ for html numeric characters entity" => "numeric between ~ for html numeric characters entity",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines" => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line" => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line",
// "Wiki plugins extend the function of wiki syntax with more specialized commands" => "Wiki plugins extend the function of wiki syntax with more specialized commands",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt",
// "text, bold" => "text, bold",
// "text, italic" => "text, italic",
// "text, underline" => "text, underline",
// "table new" => "table new",
// "wiki link'" => "wiki link'",
// "horizontal rule" => "horizontal rule",
// "dynamic variable" => "dynamic variable",
// "New wms Metadata" => "New wms Metadata",
// "New Class" => "New Class",
// "New Projection" => "New Projection",
// "New Query" => "New Query",
// "New Scalebar" => "New Scalebar",
// "New Layer" => "New Layer",
// "New Label" => "New Label",
// "New Reference" => "New Reference",
// "New Legend" => "New Legend",
// "New Web" => "New Web",
// "New Outputformat" => "New Outputformat",
// "New Mapfile" => "New Mapfile",
// "Add image from File Gallery" => "Add image from File Gallery",
// "flash" => "flash",
// "{\$label}" => "{\$label}",
// "Add Image from File Gallery" => "Add Image from File Gallery",
// "Leave Fullscreen Edit" => "Leave Fullscreen Edit",
// "Fullscreen Edit" => "Fullscreen Edit",
// "Browse Images" => "Browse Images",
// "Upload from disk to change the image" => "Upload from disk to change the image",
// "Save and Go Next" => "Save and Go Next",
// "Im-Export Languages" => "Im-Export Languages",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Immediate feedback" => "Immediate feedback",
// "Show correct answers" => "Show correct answers",
// "Shuffle questions" => "Shuffle questions",
// "Shuffle answers" => "Shuffle answers",
// "Passing Percentage" => "Passing Percentage",
// "%" => "%",
// "Question Type" => "Question Type",
// "Import questions from text" => "Import questions from text",
// "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character" => "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character",
// "Input" => "Input",
// "Edit quiz results" => "Edit quiz results",
// "Modify Structure" => "Modify Structure",
// "and its subpages from the structure" => "and its subpages from the structure",
// "The page already exists. The page that has been added to the structure is the existing one" => "The page already exists. The page that has been added to the structure is the existing one",
// "The following pages added have automatically been categorized with the same categories as the structure" => "The following pages added have automatically been categorized with the same categories as the structure",
// "Structure Layout" => "Structure Layout",
// "Monitor the Sub-Structure" => "Monitor the Sub-Structure",
// "Stop Monitoring the Sub-Structure" => "Stop Monitoring the Sub-Structure",
// "Promote" => "Promote",
// "Demote" => "Demote",
// "Current Node" => "Current Node",
// "Move in this structure" => "Move in this structure",
// "Move to another structure" => "Move to another structure",
// "at the beginning" => "at the beginning",
// "at the end" => "at the end",
// "Add pages to current node" => "Add pages to current node",
// "Categorize all pages in structure together" => "Categorize all pages in structure together",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "<b>*</b>=optional" => "<b>*</b>=optional",
// "<b>Topline</b>=small line above Title" => "<b>Topline</b>=small line above Title",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "<b>Source</b>=URL to article source" => "<b>Source</b>=URL to article source",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering" => "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering",
// "This would cause you problems (e.g. menus can stop collapsing/expanding)" => "This would cause you problems (e.g. menus can stop collapsing/expanding)",
// "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)" => "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)",
// "Maybe You just want to modify the top of your Tiki site" => "Maybe You just want to modify the top of your Tiki site",
// "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface" => "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface",
// "Save Only in the Theme" => "Save Only in the Theme",
// "Delete the copy in the theme" => "Delete the copy in the theme",
// "Edit a topic" => "Edit a topic",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "View Page" => "View Page",
// "View Article" => "View Article",
// "You must specify the object language" => "You must specify the object language",
// "The object doesn't exist" => "The object doesn't exist",
// "The object doesn't have a language" => "The object doesn't have a language",
// "The object has already a translation for this language" => "The object has already a translation for this language",
// "The object is already in the set of translations" => "The object is already in the set of translations",
// "Language of newly translated page" => "Language of newly translated page",
// "Unspecified" => "Unspecified",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"" => "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "detach" => "detach",
// "Change language for this page" => "Change language for this page",
// "Select from available options.." => "Select from available options..",
// "Change Language" => "Change Language",
// "No language is assigned to this page" => "No language is assigned to this page",
// "Please select a language before performing translation" => "Please select a language before performing translation",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Your edit session will expire in" => "Your edit session will expire in",
// "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits" => "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits",
// "Update '{\$page}'" => "Update '{\$page}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval" => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval",
// "This is a new staging page that has not been approved before" => "This is a new staging page that has not been approved before",
// "The current staging copy may contain changes that have yet to be approved" => "The current staging copy may contain changes that have yet to be approved",
// "View changes since last approval" => "View changes since last approval",
// "You are editing the approved copy of this page" => "You are editing the approved copy of this page",
// "There are currently changes in the staging copy that have yet to be approved" => "There are currently changes in the staging copy that have yet to be approved",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead" => "instead",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page" => "The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page",
// "Perhaps you are looking for" => "Perhaps you are looking for",
// "Change the style used to display differences to be translated" => "Change the style used to display differences to be translated",
// "Change diff styles" => "Change diff styles",
// "This edit session will expire in {\$edittimeout} minutes" => "This edit session will expire in {\$edittimeout} minutes",
// "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer" => "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer",
// "Switch to WYSIWYG editor" => "Switch to WYSIWYG editor",
// "Switch to normal (wiki) editor" => "Switch to normal (wiki) editor",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Admin Content Templates" => "Admin Content Templates",
// "Use rating" => "Use rating",
// "Disable" => "Disable",
// "There is no available poll template" => "There is no available poll template",
// "You should ask an admin to create them" => "You should ask an admin to create them",
// "or use" => "or use",
// "an existing poll" => "an existing poll",
// "AutoSave" => "AutoSave",
// "If you want the saved version instead of the autosaved one" => "If you want the saved version instead of the autosaved one",
// "Regex search " => "Regex search ",
// "Replace to" => "Replace to",
// "Case Insensitivity" => "Case Insensitivity",
// "My Footnotes" => "My Footnotes",
// "Translation request" => "Translation request",
// "Send urgent translation request" => "Send urgent translation request",
// "Edit Comment" => "Edit Comment",
// "Monitor this page" => "Monitor this page",
// "Try to convert HTML to wiki" => "Try to convert HTML to wiki",
// "Add another image" => "Add another image",
// "Lock this page" => "Lock this page",
// "List Sheets" => "List Sheets",
// "Graph" => "Graph",
// "Export to file" => "Export to file",
// "Format" => "Format",
// "Autodetect" => "Autodetect",
// "Export Tracker Items" => "Export Tracker Items",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse as Wiki Text" => "Parse as Wiki Text",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "All fields" => "All fields",
// "These fields" => "These fields",
// "Use Ctrl+Click to select multiple fields" => "Use Ctrl+Click to select multiple fields",
// "Dump All Tracker Items" => "Dump All Tracker Items",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "File Archive" => "File Archive",
// "File Galleries tpl" => "File Galleries tpl",
// "Be careful to set the right permissions on the files you link to" => "Be careful to set the right permissions on the files you link to",
// "Create New File Gallery" => "Create New File Gallery",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Import from a Local SQL File" => "Import from a Local SQL File",
// "Forum Type" => "Forum Type",
// "DB Prefix" => "DB Prefix",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>" => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred" => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into" => "Which Forum Do You Wish to Import this Into",
// "Message queue for forum" => "Message queue for forum",
// "Back to forum" => "Back to forum",
// "Search by name" => "Search by name",
// "Search in content" => "Search in content",
// "Configure Forum" => "Configure Forum",
// "Reported messages for forum" => "Reported messages for forum",
// "No records to display" => "No records to display",
// "Perfom action with checked" => "Perfom action with checked",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag" => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag",
// "Until then, they cannot be translated" => "Until then, they cannot be translated",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "Pending requests" => "Pending requests",
// "Request Time" => "Request Time",
// "Refuse" => "Refuse",
// "Waiting requests" => "Waiting requests",
// "Cancel friendship request" => "Cancel friendship request",
// "Your friends" => "Your friends",
// "break friendship" => "break friendship",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "Expiration Time" => "Expiration Time",
// "Years" => "Years",
// "Months" => "Months",
// "Minutes" => "Minutes",
// "Process Graph" => "Process Graph",
// "Galaxia Admin Graph" => "Galaxia Admin Graph",
// "Galaxia Admin Graph tpl" => "Galaxia Admin Graph tpl",
// "Edit Tpl" => "Edit Tpl",
// "Process Graph for" => "Process Graph for",
// "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed" => "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed",
// "Ended" => "Ended",
// "Not Defined" => "Not Defined",
// "Not Interactive" => "Not Interactive",
// "Not Ended" => "Not Ended",
// "Executed" => "Executed",
// "erase" => "erase",
// "Galaxia Admin Processes" => "Galaxia Admin Processes",
// "Galaxia Admin Processes tpl" => "Galaxia Admin Processes tpl",
// "Galaxia Monitor Activities" => "Galaxia Monitor Activities",
// "Galaxia Monitor Activities tpl" => "Galaxia Monitor Activities tpl",
// "Enter the name of this instance" => "Enter the name of this instance",
// "The name is not valid. Please, enter the name again" => "The name is not valid. Please, enter the name again",
// "Galaxia Monitor Instances" => "Galaxia Monitor Instances",
// "Galaxia Monitor Instances tpl" => "Galaxia Monitor Instances tpl",
// "Not ended" => "Not ended",
// "Galaxia Monitor Processes" => "Galaxia Monitor Processes",
// "Galaxia Monitor Processes tpl" => "Galaxia Monitor Processes tpl",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "My activities" => "My activities",
// "Current Activity" => "Current Activity",
// "Assigned To" => "Assigned To",
// "No activities found" => "No activities found",
// "My instances" => "My instances",
// "No instances found" => "No instances found",
// "Galaxia User Activities" => "Galaxia User Activities",
// "Galaxia User Activities tpl" => "Galaxia User Activities tpl",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "Galaxia User Instances" => "Galaxia User Instances",
// "Galaxia User Instances tpl" => "Galaxia User Instances tpl",
// "Not defined" => "Not defined",
// "Galaxia User Processes" => "Galaxia User Processes",
// "Galaxia User Processes tpl" => "Galaxia User Processes tpl",
// "Geographic" => "Geographic",
// "Fields to show during browsing the gallery" => "Fields to show during browsing the gallery",
// "Creation Date" => "Creation Date",
// "XY-Size" => "XY-Size",
// "Gallery Image" => "Gallery Image",
// "Global default" => "Global default",
// "Bounding box" => "Bounding box",
// "default scale" => "default scale",
// "Original image is default scale" => "Original image is default scale",
// "Add scaled images with bounding box of square size" => "Add scaled images with bounding box of square size",
// "Choose a filter" => "Choose a filter",
// "Make Map" => "Make Map",
// "Google Map Locator" => "Google Map Locator",
// "Save clicked point" => "Save clicked point",
// "Reset view to default" => "Reset view to default",
// "Save current view as default" => "Save current view as default",
// "Center map to saved point" => "Center map to saved point",
// "Reset view to site default" => "Reset view to site default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal Scale" => "Horizontal Scale",
// "Bottom" => "Bottom",
// "Vertical Scale" => "Vertical Scale",
// "Series" => "Series",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "Import From File" => "Import From File",
// "Grab Wiki Tables" => "Grab Wiki Tables",
// "Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
// "Name of the dump file (it has to be in dump/)" => "Name of the dump file (it has to be in dump/)",
// "body" => "body",
// "XML Zip" => "XML Zip",
// "Tiki installer" => "Tiki installer",
// "Welcome" => "Welcome",
// "Welcome to the Tiki installation and upgrade script" => "Welcome to the Tiki installation and upgrade script",
// "Use this script to install a new Tiki database or upgrade your existing database to release" => "Use this script to install a new Tiki database or upgrade your existing database to release",
// "For the latest information about this release, please read the" => "For the latest information about this release, please read the",
// "Release Notes" => "Release Notes",
// "For complete documentation, please visit" => "For complete documentation, please visit",
// "For more information about Tiki, please visit" => "For more information about Tiki, please visit",
// "Select your language" => "Select your language",
// "Read the License" => "Read the License",
// "Tiki is software distributed under the LGPL license" => "Tiki is software distributed under the LGPL license",
// " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>" => " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>",
// "Review the System Requirements" => "Review the System Requirements",
// "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements",
// "This installer will perform some basic checks automatically" => "This installer will perform some basic checks automatically",
// "Memory" => "Memory",
// "Success" => "Success",
// "Tiki has not detected your PHP memory_limit" => "Tiki has not detected your PHP memory_limit",
// "This probably means you have no set limit (all is well)" => "This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution" => "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution",
// "Allocating too little memory will cause Tiki to display blank pages" => "Allocating too little memory will cause Tiki to display blank pages",
// "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver" => "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Mail" => "Mail",
// "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages" => "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages",
// "To test your system configuration, Tiki will attempt to send a test message to you" => "To test your system configuration, Tiki will attempt to send a test message to you",
// "Test email" => "Test email",
// "Email address to send test to" => "Email address to send test to",
// "Copy test mail to " => "Copy test mail to ",
// "Send Test Message" => "Send Test Message",
// "Tiki was able to send a test message to" => "Tiki was able to send a test message to",
// "Tiki was not able to send a test message" => "Tiki was not able to send a test message",
// "Review your mail log for details" => "Review your mail log for details",
// "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)" => "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)",
// "If your host requires SMTP authentication, additional configuration may be necessary" => "If your host requires SMTP authentication, additional configuration may be necessary",
// "Image Processing" => "Image Processing",
// "Tiki detected" => "Tiki detected",
// "Tiki was not able to detect the GD library" => "Tiki was not able to detect the GD library",
// "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support" => "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support",
// "Set the Database Connection" => "Set the Database Connection",
// "Tiki requires an active database connection" => "Tiki requires an active database connection",
// "You must create the database and user <em>before</em> completing this page" => "You must create the database and user <em>before</em> completing this page",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "This is normal for a new installation" => "This is normal for a new installation",
// "Tiki found an existing database connection in your local.php file" => "Tiki found an existing database connection in your local.php file",
// "Use Existing Connection" => "Use Existing Connection",
// "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>" => "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>",
// "Database information" => "Database information",
// "Enter your database connection information" => "Enter your database connection information",
// "Database type" => "Database type",
// "Select the type of database to use with Tiki" => "Select the type of database to use with Tiki",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension" => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension",
// "Host name" => "Host name",
// "Enter the host name or IP for your database" => "Enter the host name or IP for your database",
// "Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "For SQLite, enter the path and filename to your database file" => "For SQLite, enter the path and filename to your database file",
// "Database name" => "Database name",
// "Enter the name of the database that Tiki will use" => "Enter the name of the database that Tiki will use",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names",
// "For Oracle" => "For Oracle",
// "Enter your TNS Name here and leave Host empty" => "Enter your TNS Name here and leave Host empty",
// "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field" => "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field",
// "Database user" => "Database user",
// "Enter a database user with administrator permission for the Database" => "Enter a database user with administrator permission for the Database",
// "User name" => "User name",
// "Install &amp; Update Profile" => "Install &amp; Update Profile",
// "Install Profile" => "Install Profile",
// "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page" => "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page",
// "Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database" => "Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database",
// "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>" => "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>",
// "Select the installation profile to use. This profile will populate the database" => "Select the installation profile to use. This profile will populate the database",
// "Profiles can be used to pre-configure your site with specific features and settings" => "Profiles can be used to pre-configure your site with specific features and settings",
// "Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information" => "Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information",
// "Install" => "Install",
// "Reinstall the database" => "Reinstall the database",
// "This will destroy your current database" => "This will destroy your current database",
// "Create a new database (clean install) with profile" => "Create a new database (clean install) with profile",
// "Bare-bones default install" => "Bare-bones default install",
// "Personal Blog and Profile" => "Personal Blog and Profile",
// "Small Organization Web Presence" => "Small Organization Web Presence",
// "Company Intranet" => "Company Intranet",
// "Collaborative community" => "Collaborative community",
// "See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles" => "See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles",
// "The installer could not connect to the Profiles repository" => "The installer could not connect to the Profiles repository",
// "The default installation profile will be used" => "The default installation profile will be used",
// "Upgrade" => "Upgrade",
// "Automatically upgrade your existing database to v" => "Automatically upgrade your existing database to v",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Review the Upgrade" => "Review the Upgrade",
// "Review the Installation" => "Review the Installation",
// "Upgrade complete" => "Upgrade complete",
// "Installation complete" => "Installation complete",
// "Your database has been configured and Tiki is ready to run" => "Your database has been configured and Tiki is ready to run",
// "If this is your first install, your admin password is <strong>admin</strong>" => "If this is your first install, your admin password is <strong>admin</strong>",
// "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application" => "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application",
// "Upgrade operations executed successfully" => "Upgrade operations executed successfully",
// "Installation operations executed successfully" => "Installation operations executed successfully",
// "SQL queries" => "SQL queries",
// "Database was left unchanged" => "Database was left unchanged",
// "Failed" => "Failed",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages" => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages",
// ".htaccess File" => ".htaccess File",
// "We recommend enabling the <strong>.htaccess</strong> file for your Tiki" => "We recommend enabling the <strong>.htaccess</strong> file for your Tiki",
// "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security" => "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security",
// "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>" => "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>",
// "Complete these fields to configure common, general settings for your site" => "Complete these fields to configure common, general settings for your site",
// "The information you enter here can be changed later" => "The information you enter here can be changed later",
// "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings" => "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings",
// "This will appear in the browser title bar" => "This will appear in the browser title bar",
// "Email sent by your site will use this address" => "Email sent by your site will use this address",
// "Secure Login" => "Secure Login",
// "HTTPS login" => "HTTPS login",
// "Administrator" => "Administrator",
// "Admin email" => "Admin email",
// "This is the email address for your administrator account" => "This is the email address for your administrator account",
// "Enter Your Tiki" => "Enter Your Tiki",
// "The installation is complete" => "The installation is complete",
// "Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>" => "Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>",
// "Installation" => "Installation",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu" => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu",
// "Enter Tiki and Lock Installer" => "Enter Tiki and Lock Installer",
// "Recommended" => "Recommended",
// "Enter Tiki Without Locking Installer" => "Enter Tiki Without Locking Installer",
// "MultiTiki Setup" => "MultiTiki Setup",
// "Default Installation" => "Default Installation",
// "DB OK" => "DB OK",
// "No DB" => "No DB",
// "Adding a new host" => "Adding a new host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Are you upgrading an existing Tiki site" => "Are you upgrading an existing Tiki site",
// "Go directly to the <strong>Install/Upgrade</strong> step" => "Go directly to the <strong>Install/Upgrade</strong> step",
// "Install/Upgrade" => "Install/Upgrade",
// "Restart the installer" => "Restart the installer",
// "Database Connection" => "Database Connection",
// "Reset the Database Connection" => "Reset the Database Connection",
// "Configure the General Settings" => "Configure the General Settings",
// "Tiki Icon" => "Tiki Icon",
// "TikiWiki Project Web Site" => "TikiWiki Project Web Site",
// "Support Forums" => "Support Forums",
// "TikiWiki CMS/Groupware Project" => "TikiWiki CMS/Groupware Project",
// "Powered by TikiWiki" => "Powered by TikiWiki",
// "Clear cached version and refresh cache" => "Clear cached version and refresh cache",
// "configure rules" => "configure rules",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Go Back" => "Go Back",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "Last 2 days" => "Last 2 days",
// "Last 3 days" => "Last 3 days",
// "Last 5 days" => "Last 5 days",
// "Last week" => "Last week",
// "Last 2 weeks" => "Last 2 weeks",
// "Last month" => "Last month",
// "v" => "v",
// "ExpireDate" => "ExpireDate",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone" => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone",
// "Max Clicks" => "Max Clicks",
// "The cache is used by" => "The cache is used by",
// "Approval" => "Approval",
// "Rejected" => "Rejected",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block" => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block" => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "Future vers" => "Future vers",
// "Create new FAQ" => "Create new FAQ",
// "SlideShow" => "SlideShow",
// "Keep gallery window open" => "Keep gallery window open",
// "Your comment" => "Your comment",
// "optional" => "optional",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "/" => "/",
// "Flash binary (.swf or .dcr)" => "Flash binary (.swf or .dcr)",
// "Take Survey" => "Take Survey",
// "users registered" => "users registered",
// "Distance (km)" => "Distance (km)",
// "List Movies" => "List Movies",
// "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on" => "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on",
// "Choose a movie" => "Choose a movie",
// "Last modification" => "Last modification",
// "Page creator" => "Page creator",
// "Status of the page" => "Status of the page",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl" => "Backl",
// "Page size" => "Page size",
// " {if \$find ne ''}and {/if}starting with" => " {if \$find ne ''}and {/if}starting with",
// "offline" => "offline",
// "Back to admin" => "Back to admin",
// "operator" => "operator",
// "For security purposes we must periodically validate your email address to allow continued access to this site" => "For security purposes we must periodically validate your email address to allow continued access to this site",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site" => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site",
// "Thank you" => "Thank you",
// "This is an experimental feature" => "This is an experimental feature",
// "Requires" => "Requires",
// "Not Enabled" => "Not Enabled",
// "Mail-in feature" => "Mail-in feature",
// "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/" => "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/",
// "Tikiwiki Mods" => "Tikiwiki Mods",
// "Mods Configuration" => "Mods Configuration",
// "Update remote index" => "Update remote index",
// "Rebuild local list" => "Rebuild local list",
// "Republish all" => "Republish all",
// "Publish all" => "Publish all",
// "Unpublish all" => "Unpublish all",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>" => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>",
// "Tiki \"mods\" are undergoing refurbishment" => "Tiki \"mods\" are undergoing refurbishment",
// "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification" => "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification",
// "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more" => "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more",
// "Attention" => "Attention",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)" => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")" => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")",
// "all types" => "all types",
// "for version" => "for version",
// "all versions" => "all versions",
// "or later" => "or later",
// "No mods found" => "No mods found",
// "Display only this type" => "Display only this type",
// "Unpublish" => "Unpublish",
// "Republish" => "Republish",
// "licence" => "licence",
// "Tikiwiki Mods Configuration" => "Tikiwiki Mods Configuration",
// "Mods Install/uninstall" => "Mods Install/uninstall",
// "Enable Mods providing" => "Enable Mods providing",
// "Mods local directory" => "Mods local directory",
// "Mods remote server" => "Mods remote server",
// "Package Config" => "Package Config",
// "y" => "y",
// "My Articles" => "My Articles",
// "User Articles" => "User Articles",
// "My User Items" => "My User Items",
// "User Items" => "User Items",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "To display the objects you participate" => "To display the objects you participate",
// "My Infos" => "My Infos",
// "Contacts Preferences" => "Contacts Preferences",
// "My Contacts" => "My Contacts",
// "My Wiki Pages" => "My Wiki Pages",
// "My Galleries" => "My Galleries",
// "My Tracker Items" => "My Tracker Items",
// "My Messages" => "My Messages",
// "My Tasks" => "My Tasks",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Delete errors" => "Delete errors",
// "Not sent" => "Not sent",
// "Removal of your email address failed" => "Removal of your email address failed",
// "Subscription failed" => "Subscription failed",
// "Available Newsletters" => "Available Newsletters",
// "News from" => "News from",
// "Configure Newsreader" => "Configure Newsreader",
// "configure newsreader server tpl" => "configure newsreader server tpl",
// "Read the news" => "Read the news",
// "Add a news server" => "Add a news server",
// "Edit news server" => "Edit news server",
// "Object Watches" => "Object Watches",
// "Watching Groups" => "Watching Groups",
// "View Permissions" => "View Permissions",
// "Edit Permissions" => "Edit Permissions",
// "These permissions override any global permissions or category permissions affecting this object" => "These permissions override any global permissions or category permissions affecting this object",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>" => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>",
// "No individual permissions, category permissions apply" => "No individual permissions, category permissions apply",
// "Current permissions for categories that this object belongs to" => "Current permissions for categories that this object belongs to",
// "These permissions do not apply. Special permissions apply" => "These permissions do not apply. Special permissions apply",
// "No category permissions; global permissions apply" => "No category permissions; global permissions apply",
// "No category permissions; special permissions apply" => "No category permissions; special permissions apply",
// "and also to all pages of the sub-structure" => "and also to all pages of the sub-structure",
// "Perms Help" => "Perms Help",
// "Your OpenID identity is valid" => "Your OpenID identity is valid",
// "However, no account is associated to the OpenID identifier" => "However, no account is associated to the OpenID identifier",
// "Create a new Tikiwiki account from OpenID" => "Create a new Tikiwiki account from OpenID",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts" => "Your identity gives you access to multiple user accounts",
// "Select account" => "Select account",
// "Make Structure" => "Make Structure",
// "{\$atts|@count} files attached" => "{\$atts|@count} files attached",
// "Preview of version" => "Preview of version",
// "(current)" => "(current)",
// "Rollback to this version" => "Rollback to this version",
// "Source of version" => "Source of version",
// "s=source" => "s=source",
// "b=rollback" => "b=rollback",
// "Updated from" => "Updated from",
// "Used to update" => "Used to update",
// "Update Translation" => "Update Translation",
// "Hide translation history" => "Hide translation history",
// "Show translation history" => "Show translation history",
// "no avatar" => "no avatar",
// "icons" => "icons",
// "File (only .gif, .jpg and .png images approximately 45px × 45px)" => "File (only .gif, .jpg and .png images approximately 45px × 45px)",
// "Plugin execution was denied" => "Plugin execution was denied",
// "Plugin execution pending approval" => "Plugin execution pending approval",
// "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected" => "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected",
// "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible" => "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible",
// "You are allowed to" => "You are allowed to",
// "View arguments" => "View arguments",
// "Execute the plugin in preview mode (may be dangerous)" => "Execute the plugin in preview mode (may be dangerous)",
// "Approve the plugin for public execution" => "Approve the plugin for public execution",
// "View Details" => "View Details",
// "This plugin does not contain any arguments" => "This plugin does not contain any arguments",
// "This plugin's body is empty" => "This plugin's body is empty",
// "Insert" => "Insert",
// "Any" => "Any",
// "Items found" => "Items found",
// "atts" => "atts",
// "List Attachments" => "List Attachments",
// "Sum" => "Sum",
// "Plugin Approval" => "Plugin Approval",
// "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups" => "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups",
// "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins" => "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins",
// "This page lists the plugins that require validation, the first time they are encountered" => "This page lists the plugins that require validation, the first time they are encountered",
// "Each plugin contains a unique <em>signature</em> that is preserved" => "Each plugin contains a unique <em>signature</em> that is preserved",
// "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list" => "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list",
// "The plugin will automatically be added if it is encountered" => "The plugin will automatically be added if it is encountered",
// "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin" => "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin",
// "For security, you should review each plugin to ensure it is safe to approve" => "For security, you should review each plugin to ensure it is safe to approve",
// "Plugin" => "Plugin",
// "Added By" => "Added By",
// "Signature" => "Signature",
// "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "Approve all pending plugins" => "Approve all pending plugins",
// "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins" => "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins",
// "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe" => "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe",
// "No plugins pending approval" => "No plugins pending approval",
// "View Results" => "View Results",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Edit Poll" => "Edit Poll",
// "Find the poll" => "Find the poll",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Vote range displayed" => "Vote range displayed",
// "All votes with no span consideration" => "All votes with no span consideration",
// "All votes with span consideration" => "All votes with span consideration",
// "All votes" => "All votes",
// "List Votes" => "List Votes",
// "Note: Remember that this is only a preview, and has not yet been saved" => "Note: Remember that this is only a preview, and has not yet been saved",
// "Permission denied. You do not have permission to read complete articles" => "Permission denied. You do not have permission to read complete articles",
// "Selected Structures" => "Selected Structures",
// "Add Structure" => "Add Structure",
// "No structures" => "No structures",
// "Add Pages" => "Add Pages",
// "No pages" => "No pages",
// "Add Pages from Structures" => "Add Pages from Structures",
// "Add Structure Pages" => "Add Structure Pages",
// "Selected Pages" => "Selected Pages",
// "No pages selected" => "No pages selected",
// "Edit quiz" => "Edit quiz",
// "General Options" => "General Options",
// "Publication Date" => "Publication Date",
// "at " => "at ",
// "Use " => "Use ",
// "randomly selected questions" => "randomly selected questions",
// "Test-time Options" => "Test-time Options",
// "Limit questions displayed per page to " => "Limit questions displayed per page to ",
// "&nbsp question(s)" => "&nbsp question(s)",
// "Impose a time limit of " => "Impose a time limit of ",
// "Allow students to store partial results and return to quiz" => "Allow students to store partial results and return to quiz",
// "Allow students to retake this quiz " => "Allow students to retake this quiz ",
// "Grading and Feedback" => "Grading and Feedback",
// "Grading method " => "Grading method ",
// "Show students their score " => "Show students their score ",
// "Show students the correct answers " => "Show students the correct answers ",
// "Publish statistics " => "Publish statistics ",
// "Extra Options" => "Extra Options",
// "Solicit additional questions from students" => "Solicit additional questions from students",
// "Link quiz to forum named: " => "Link quiz to forum named: ",
// "Prologue" => "Prologue",
// "Epilogue" => "Epilogue",
// "time taken" => "time taken",
// "P/F" => "P/F",
// "Passed" => "Passed",
// "Rank" => "Rank",
// "star" => "star",
// "half star" => "half star",
// "Send a link" => "Send a link",
// "List all articles of this same topic" => "List all articles of this same topic",
// "Received Pages" => "Received Pages",
// "Edit Received Page" => "Edit Received Page",
// "The highlight pages already exist" => "The highlight pages already exist",
// "Please, change the name if you want the page to be uploaded" => "Please, change the name if you want the page to be uploaded",
// "Received Structures" => "Received Structures",
// "Prefix the checked" => "Prefix the checked",
// "Postfix the checked" => "Postfix the checked",
// "Use your email as login" => "Use your email as login",
// "Minimum {\$prefs.min_username_length} characters long" => "Minimum {\$prefs.min_username_length} characters long",
// "Passcode to register" => "Passcode to register",
// "Not your password" => "Not your password",
// "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}" => "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}",
// "Generate a\tpassword" => "Generate a\tpassword",
// "A valid email is mandatory to register" => "A valid email is mandatory to register",
// "Select your group" => "Select your group",
// "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter" => "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter",
// "Tiki site registered" => "Tiki site registered",
// "You don't have permission to use this feature" => "You don't have permission to use this feature",
// "Please register" => "Please register",
// "Register this site at tikiwiki.org" => "Register this site at tikiwiki.org",
// "Read this first" => "Read this first",
// "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites" => "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites",
// "Registering is voluntary" => "Registering is voluntary",
// "Registering does not give you any benefits except one more link to your site" => "Registering does not give you any benefits except one more link to your site",
// "You don't get any emails, we don't sell the data about your site" => "You don't get any emails, we don't sell the data about your site",
// "Registering is just for us to get an overview of Tiki's usage" => "Registering is just for us to get an overview of Tiki's usage",
// "If your site is private or inside your intranet, you should not register" => "If your site is private or inside your intranet, you should not register",
// "tikiwiki.org" => "tikiwiki.org",
// "Information about your site" => "Information about your site",
// "Enter your username or email" => "Enter your username or email",
// "Enter your email" => "Enter your email",
// "Request Password Reset" => "Request Password Reset",
// "Last Version" => "Last Version",
// "Back to page" => "Back to page",
// "Replicate" => "Replicate",
// "Slave" => "Slave",
// "Master" => "Master",
// "Operations" => "Operations",
// "Operations Log" => "Operations Log",
// "to version" => "to version",
// "\$name" => "\$name",
// "Faqs" => "Faqs",
// "Simple search" => "Simple search",
// "Blogs Post" => "Blogs Post",
// "Date Search" => "Date Search",
// "All dates" => "All dates",
// "Calendar Items" => "Calendar Items",
// "Please Confirm" => "Please Confirm",
// "octets" => "octets",
// "Apply content template" => "Apply content template",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "Attached Files" => "Attached Files",
// "To add a file, click here" => "To add a file, click here",
// "Save as Draft" => "Save as Draft",
// "Send a structure" => "Send a structure",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "Create a sheet" => "Create a sheet",
// "Edit this sheet" => "Edit this sheet",
// "Create New Sheet" => "Create New Sheet",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
// "Header Rows" => "Header Rows",
// "Footer Rows" => "Footer Rows",
// "Create new Sheet" => "Create new Sheet",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Available Sheets" => "Available Sheets",
// "Change shoutbox general settings" => "Change shoutbox general settings",
// "auto-link urls" => "auto-link urls",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page" => "the approved version of this page",
// "Viewing of changes since last approval is possible only after first approval" => "Viewing of changes since last approval is possible only after first approval",
// "Approve changes" => "Approve changes",
// "Latest changes will be synchronized after approval" => "Latest changes will be synchronized after approval",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time" => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time",
// "Content may be out of date" => "Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages",
// "Parent page" => "Parent page",
// "TOC" => "TOC",
// "Child" => "Child",
// "page: %0/%1" => "page: %0/%1",
// "Last edited by" => "Last edited by",
// "based on work by" => "based on work by",
// "Contributors to this page" => "Contributors to this page",
// "Page last modified on %0 by %1" => "Page last modified on %0 by %1",
// "Created by %0" => "Created by %0",
// "Last Modification: %0 by %1" => "Last Modification: %0 by %1",
// "big grin" => "big grin",
// "confused" => "confused",
// "cry" => "cry",
// "eek" => "eek",
// "evil" => "evil",
// "lol" => "lol",
// "mr green" => "mr green",
// "razz" => "razz",
// "redface" => "redface",
// "rolleyes" => "rolleyes",
// "smile" => "smile",
// "surprised" => "surprised",
// "twisted" => "twisted",
// "arrow" => "arrow",
// "santa" => "santa",
// "You will not see the latest queries" => "You will not see the latest queries",
// "Clean" => "Clean",
// "Params" => "Params",
// "Most viewed objects" => "Most viewed objects",
// "Most viewed objects in the last 7 days" => "Most viewed objects in the last 7 days",
// "Date of first pageview" => "Date of first pageview",
// "Days since first pageview" => "Days since first pageview",
// "Total replies" => "Total replies",
// "Average number of replies per topic" => "Average number of replies per topic",
// "FAQ Stats" => "FAQ Stats",
// "Daily Usage" => "Daily Usage",
// "Tiki Logs" => "Tiki Logs",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "Thank you for your submission" => "Thank you for your submission",
// "Send a link to a friend" => "Send a link to a friend",
// "The link was sent to the following addresses" => "The link was sent to the following addresses",
// "Friend's email" => "Friend's email",
// "Separate multiple email addresses with a comma" => "Separate multiple email addresses with a comma",
// "Your name" => "Your name",
// "Your email" => "Your email",
// "I found an interesting page that I thought you would like" => "I found an interesting page that I thought you would like",
// "TikiTests Edit" => "TikiTests Edit",
// "Summary mode" => "Summary mode",
// "Show Page Differences" => "Show Page Differences",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Request" => "Request",
// "Element to compare (Xpath expression)" => "Element to compare (Xpath expression)",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "TikiTests List" => "TikiTests List",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "PECL HTTP extension present" => "PECL HTTP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible" => "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "TikiTests Record Configuration" => "TikiTests Record Configuration",
// "Start Recording Test" => "Start Recording Test",
// "TikiTests Replay Configuration" => "TikiTests Replay Configuration",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "Theme Control Center: Categories" => "Theme Control Center: Categories",
// "Control by Objects" => "Control by Objects",
// "Theme Control Center: Sections" => "Theme Control Center: Sections",
// "Edit File" => "Edit File",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "Additional Info" => "Additional Info",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "You locked the file" => "You locked the file",
// "The file is locked by {\$fileInfo.lockedby}" => "The file is locked by {\$fileInfo.lockedby}",
// "Unzip zip files" => "Unzip zip files",
// "Author if not the file creator" => "Author if not the file creator",
// "Maximum amount of downloads" => "Maximum amount of downloads",
// "Add File" => "Add File",
// "Maximum file size is limited to" => "Maximum file size is limited to",
// "No gallery available" => "No gallery available",
// "Uploading file.." => "Uploading file..",
// "No File to Upload.." => "No File to Upload..",
// "You can include the image in an Wiki page using" => "You can include the image in an Wiki page using",
// "or use filename" => "or use filename",
// "Note: Maximum image size is limited to" => "Note: Maximum image size is limited to",
// "The column is disabled" => "The column is disabled",
// "a folder" => "a folder",
// "a URL" => "a URL",
// "User Contacts Preferences" => "User Contacts Preferences",
// "Manage Fields" => "Manage Fields",
// "Default view" => "Default view",
// "Assign Group" => "Assign Group",
// "(non public)" => "(non public)",
// "Homepage" => "Homepage",
// "Users HomePage" => "Users HomePage",
// "Personal Wiki Page" => "Personal Wiki Page",
// "System" => "System",
// "This user is your friend" => "This user is your friend",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Request friendship from this user" => "Request friendship from this user",
// "Forum comments" => "Forum comments",
// "Toggle options" => "Toggle options",
// "Toggle" => "Toggle",
// "Personal Information" => "Personal Information",
// "Male" => "Male",
// "Female" => "Female",
// "Use Google Map locator" => "Use Google Map locator",
// "Your personal tracker information" => "Your personal tracker information",
// "View extra information" => "View extra information",
// "Unavailable - please set your e-mail below" => "Unavailable - please set your e-mail below",
// "Does your mail reader need a special charset" => "Does your mail reader need a special charset",
// "Your preferred language" => "Your preferred language",
// "Can you read more languages" => "Can you read more languages",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
// "Select language.." => "Select language..",
// "Displays users' info tooltip on mouseover for every user who allows his information to be public" => "Displays users' info tooltip on mouseover for every user who allows his information to be public",
// "Note author when reading his mail" => "Note author when reading his mail",
// "My user items" => "My user items",
// "My level" => "My level",
// "Account Information" => "Account Information",
// "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password",
// "Email address" => "Email address",
// "Confirm new password" => "Confirm new password",
// "Current password (required)" => "Current password (required)",
// "Change administrative info" => "Change administrative info",
// "New task" => "New task",
// "Task list" => "Task list",
// "Admin mode off" => "Admin mode off",
// "Admin mode on" => "Admin mode on",
// "Task help" => "Task help",
// "Empty Trash" => "Empty Trash",
// "Received task" => "Received task",
// "You received this task, please read and execute it" => "You received this task, please read and execute it",
// "Send task" => "Send task",
// "You send this task to a other user" => "You send this task to a other user",
// "Shared task" => "Shared task",
// "This task is public to a special group" => "This task is public to a special group",
// "Accepted by Task User and Creator" => "Accepted by Task User and Creator",
// "Accepted User and Creator" => "Accepted User and Creator",
// "Task is accepted by user and creator" => "Task is accepted by user and creator",
// "Not Accepted by One User" => "Not Accepted by One User",
// "Not Accepted User" => "Not Accepted User",
// "Task is rejected by one user" => "Task is rejected by one user",
// "Waiting for Me" => "Waiting for Me",
// "Task is not accepted by you, read the task and accept or reject it" => "Task is not accepted by you, read the task and accept or reject it",
// "Waiting for Other User" => "Waiting for Other User",
// "Task is not accepted/rejected by other user" => "Task is not accepted/rejected by other user",
// "Admin Mode" => "Admin Mode",
// "Edit task" => "Edit task",
// "NOT accept" => "NOT accept",
// "Remove from Trash" => "Remove from Trash",
// "Move into Trash" => "Move into Trash",
// "Task saved" => "Task saved",
// "Edit Task" => "Edit Task",
// "View Task" => "View Task",
// "Open a new task" => "Open a new task",
// "taskId" => "taskId",
// "Task user" => "Task user",
// "Only the creator can delete this task" => "Only the creator can delete this task",
// "Use start date and time" => "Use start date and time",
// "Use end date and time" => "Use end date and time",
// "Open / In Process" => "Open / In Process",
// "Waiting / Not Started" => "Waiting / Not Started",
// "Waiting" => "Waiting",
// "Shared for Group" => "Shared for Group",
// "Accepted by User" => "Accepted by User",
// "No / Rejected" => "No / Rejected",
// "Accepted by Creator" => "Accepted by Creator",
// "This message will be send to users if you are makeing changes of assigned tasks" => "This message will be send to users if you are makeing changes of assigned tasks",
// "Send message with changes" => "Send message with changes",
// "Modified by" => "Modified by",
// "Marked as deleted" => "Marked as deleted",
// "Inform task user by email" => "Inform task user by email",
// "You can only view this task" => "You can only view this task",
// "%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
// "Select One" => "Select One",
// "Undo Trash" => "Undo Trash",
// "Received" => "Received",
// "Submitted" => "Submitted",
// "Shared" => "Shared",
// "All Shared Tasks" => "All Shared Tasks",
// "completed (100%)" => "completed (100%)",
// "Public for group" => "Public for group",
// "You are not allowed to remove this notification " => "You are not allowed to remove this notification ",
// "Use \"watches\" to monitor wiki pages or other objects" => "Use \"watches\" to monitor wiki pages or other objects",
// "Watch new items by clicking the {icon _id=eye} button on specific pages" => "Watch new items by clicking the {icon _id=eye} button on specific pages",
// "Add Watch" => "Add Watch",
// "Select event type" => "Select event type",
// "All watched events" => "All watched events",
// "A user edited an article" => "A user edited an article",
// "A user deleted an article" => "A user deleted an article",
// "A user submits a blog post" => "A user submits a blog post",
// "A user posts a forum thread" => "A user posts a forum thread",
// "A user posts a forum topic" => "A user posts a forum topic",
// "A user edited a wiki page" => "A user edited a wiki page",
// "A user created a wiki page in a language" => "A user created a wiki page in a language",
// "Used space" => "Used space",
// "up to" => "up to",
// "no limit for admin" => "no limit for admin",
// "Insert Row" => "Insert Row",
// "Insert Column" => "Insert Column",
// "Remove Row" => "Remove Row",
// "Remove Column" => "Remove Column",
// "Merge Cells" => "Merge Cells",
// "Restore Cells" => "Restore Cells",
// "Copy Calculation" => "Copy Calculation",
// "Format Cell" => "Format Cell",
// "expires" => "expires",
// "No articles yet" => "No articles yet",
// "Add an article" => "Add an article",
// "There are no questions in this FAQ" => "There are no questions in this FAQ",
// "Answers" => "Answers",
// "Add Suggestion" => "Add Suggestion",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "Group Monitor Topics of this Forum" => "Group Monitor Topics of this Forum",
// "Group Monitor Topics and Threads of this Forum" => "Group Monitor Topics and Threads of this Forum",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Editing posts" => "Editing posts",
// "Emot" => "Emot",
// "Forum Lock" => "Forum Lock",
// "Unarchive" => "Unarchive",
// "posts in this forum" => "posts in this forum",
// "Filter Posts" => "Filter Posts",
// "Posts Filtering" => "Posts Filtering",
// "Last post date" => "Last post date",
// "Show archived posts" => "Show archived posts",
// "Containing posts by" => "Containing posts by",
// "Me" => "Me",
// "Posts with no replies" => "Posts with no replies",
// "Archived" => "Archived",
// "Topic List" => "Topic List",
// "The post has been reported and will be reviewed by a moderator" => "The post has been reported and will be reviewed by a moderator",
// "Print this page only" => "Print this page only",
// "Print all pages" => "Print all pages",
// "Stop Monitor" => "Stop Monitor",
// "Edit Fields" => "Edit Fields",
// "Pending" => "Pending",
// "View inserted item" => "View inserted item",
// "Tracker Item" => "Tracker Item",
// "Edit/Delete" => "Edit/Delete",
// "Filter Tracker Items" => "Filter Tracker Items",
// "Items list" => "Items list",
// "Special Operations" => "Special Operations",
// "close" => "close",
// "There was an error connecting to your e-mail account" => "There was an error connecting to your e-mail account",
// "Add a new" => "Add a new",
// "Edit this" => "Edit this",
// " mail account" => " mail account",
// "Group (shared mail inbox) or private" => "Group (shared mail inbox) or private",
// "This will be a group mail account" => "This will be a group mail account",
// "This will be a personal mail account" => "This will be a personal mail account",
// "Auto-refresh page time" => "Auto-refresh page time",
// "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission" => "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission",
// "Personal e-mail accounts" => "Personal e-mail accounts",
// "Click to activate" => "Click to activate",
// "This is the active account" => "This is the active account",
// "Group e-mail accounts" => "Group e-mail accounts",
// "Show All" => "Show All",
// "Show Unread" => "Show Unread",
// "Show Flagged" => "Show Flagged",
// "Refresh now" => "Refresh now",
// "Group messages" => "Group messages",
// "unFlagged" => "unFlagged",
// "page id" => "page id",
// "3d browser" => "3d browser",
// "Group Monitor on Structure" => "Group Monitor on Structure",
// "Jump to Content" => "Jump to Content",
// "Cancel Fullscreen" => "Cancel Fullscreen",
// "Show/Hide Left Menus" => "Show/Hide Left Menus",
// "Show/Hide Right Menus" => "Show/Hide Right Menus",
// "Latitude" => "Latitude",
// "Longitude" => "Longitude",
// "Remove Image" => "Remove Image",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Word Count" => "Word Count",
// "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator" => "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator",
// "Number of voices" => "Number of voices",
// "Your vote" => "Your vote",
// "Click to vote for this value" => "Click to vote for this value",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled" => "Google Maps is not enabled",
// "The main text of this page is available in the following languages" => "The main text of this page is available in the following languages",
// "Use this thread to discuss the page" => "Use this thread to discuss the page",
// "Missing or incorrect trackerId parameter for the plugin" => "Missing or incorrect trackerId parameter for the plugin",
// "list" => "list",
// "Reinstall" => "Reinstall",
// "Undecided" => "Undecided",
// "Subscribe to a group" => "Subscribe to a group",
// "Toggle display" => "Toggle display",
// "List authors" => "List authors",
// "Preview your changes" => "Preview your changes",
// "Save the page as a partial translation" => "Save the page as a partial translation",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation" => "Save the page as a completed translation",
// "Complete Translation" => "Complete Translation",
// "Save the page, but do not send notifications and do not count it as new content to be translated" => "Save the page, but do not send notifications and do not count it as new content to be translated",
// "Save the page" => "Save the page",
// "Save the page as a draft" => "Save the page as a draft",
// "Save Draft" => "Save Draft",
// "Cancel the edit, you will lose your changes" => "Cancel the edit, you will lose your changes",
// "Compose Message" => "Compose Message",
// "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>",
// "Separate multiple usernames with a comma (&nbsp;,&nbsp;)" => "Separate multiple usernames with a comma (&nbsp;,&nbsp;)",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "%s set" => "%s set",
// "%s unset" => "%s unset",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Enable/disable Tiki features here, but configure them elsewhere" => "Enable/disable Tiki features here, but configure them elsewhere",
// "User registration, login and authentication" => "User registration, login and authentication",
// "Wiki Attachments" => "Wiki Attachments",
// "Article/CMS settings" => "Article/CMS settings",
// "Configuration options for all blogs on your site" => "Configuration options for all blogs on your site",
// "FAQ comments settings" => "FAQ comments settings",
// "Trackers settings" => "Trackers settings",
// "RSS settings" => "RSS settings",
// "Directory settings" => "Directory settings",
// "Maps configuration" => "Maps configuration",
// "Meta Tags settings" => "Meta Tags settings",
// "Search settings" => "Search settings",
// "Score settings" => "Score settings",
// "Community settings" => "Community settings",
// "Calendar settings" => "Calendar settings",
// "Intertiki settings" => "Intertiki settings",
// "Freetags settings" => "Freetags settings",
// "Look & Feel" => "Look & Feel",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Current version is up to date : <b>%s</b>" => "Current version is up to date : <b>%s</b>",
// "A new %s  major release branch is available" => "A new %s  major release branch is available",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "Click here to delete the category" => "Click here to delete the category",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header" => "The file does not have the required header",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "You have to provide a hotword and a URL" => "You have to provide a hotword and a URL",
// "moved %d images, %d errors occured" => "moved %d images, %d errors occured",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Detected, Version" => "Detected, Version",
// "Test Image" => "Test Image",
// "Not detected" => "Not detected",
// "Your admin password has been changed" => "Your admin password has been changed",
// "You cannot have a blank password" => "You cannot have a blank password",
// "All Fields except gdaltindex must be filled" => "All Fields except gdaltindex must be filled",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
// "If you use apache, you need a .htaccess file to have this feature working" => "If you use apache, you need a .htaccess file to have this feature working",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Repository name can't be an empty" => "Repository name can't be an empty",
// "Requested action is not supported on repository" => "Requested action is not supported on repository",
// "No repository" => "No repository",
// "Search is mandatory field" => "Search is mandatory field",
// "File not found " => "File not found ",
// "Requested action in not supported on repository" => "Requested action in not supported on repository",
// "Non-existent link" => "Non-existent link",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
// "Frequency should be a positive integer" => "Frequency should be a positive integer",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
// "Unassign module" => "Unassign module",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Error opening uploaded file" => "Error opening uploaded file",
// "Invalid email" => "Invalid email",
// "You need to provide a username or an email" => "You need to provide a username or an email",
// "unsafe" => "unsafe",
// "register_globals should be off by default. See the php manual for details" => "register_globals should be off by default. See the php manual for details",
// "safe" => "safe",
// "session.use_trans_sid should be off by default. See the php manual for details" => "session.use_trans_sid should be off by default. See the php manual for details",
// "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser",
// "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config" => "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config",
// "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them",
// "risky" => "risky",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off" => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off",
// "The Path to store files in the filegallery should be outside the tiki root directory" => "The Path to store files in the filegallery should be outside the tiki root directory",
// "The Path to store files in the imagegallery should be outside the tiki root directory" => "The Path to store files in the imagegallery should be outside the tiki root directory",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code" => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code",
// "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html" => "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html",
// "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement" => "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement",
// "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory" => "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory",
// "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts" => "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts",
// "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)" => "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)",
// "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users" => "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users",
// "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users" => "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users",
// "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands" => "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "File is not readable. Unable to check" => "File is not readable. Unable to check",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous" => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous",
// "This is a modified File. Cannot check version. Check if it is dangerous" => "This is a modified File. Cannot check version. Check if it is dangerous",
// "This file is from another Tikiwiki version: " => "This file is from another Tikiwiki version: ",
// "You have to provide a word" => "You have to provide a word",
// "You must specify a page name, it will be created if it doesn't exist" => "You must specify a page name, it will be created if it doesn't exist",
// "No Errors detected" => "No Errors detected",
// "Are you sure you want to remove this topic" => "Are you sure you want to remove this topic",
// "Are you sure you want to remove this topic AND all the articles related" => "Are you sure you want to remove this topic AND all the articles related",
// "Tracker does not allow attachments" => "Tracker does not allow attachments",
// "Remove group: " => "Remove group: ",
// "Remove permission: %s on %s" => "Remove permission: %s on %s",
// "The description is mandatory as it is used as mail subject" => "The description is mandatory as it is used as mail subject",
// "Invalid or unknown email" => "Invalid or unknown email",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "Created account %s <%s>" => "Created account %s <%s>",
// "Assigned %s in group %s" => "Assigned %s in group %s",
// "User %s already exists" => "User %s already exists",
// "User login contains invalid characters" => "User login contains invalid characters",
// "New %s created with %s %s" => "New %s created with %s %s",
// "Impossible to create new %s with %s %s" => "Impossible to create new %s with %s %s",
// "%s %s successfully deleted" => "%s %s successfully deleted",
// "Deleted account %s" => "Deleted account %s",
// "%s %s removed from %s %s" => "%s %s removed from %s %s",
// "%s <b>%s</b> successfully deleted" => "%s <b>%s</b> successfully deleted",
// "%s <b>%s</b> assigned to %s <b>%s</b>" => "%s <b>%s</b> assigned to %s <b>%s</b>",
// "%s <b>%s</b> removed from %s <b>%s</b>" => "%s <b>%s</b> removed from %s <b>%s</b>",
// "group <b>%s</b> set as the default group of user <b>%s</b>" => "group <b>%s</b> set as the default group of user <b>%s</b>",
// "Login contains invalid characters" => "Login contains invalid characters",
// "%s changed from %s to %s" => "%s changed from %s to %s",
// "Impossible to change %s from %s to %s" => "Impossible to change %s from %s to %s",
// "%s modified successfully" => "%s modified successfully",
// "%s modification failed" => "%s modification failed",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "rss feed disabled" => "rss feed disabled",
// "Tiki RSS feed for articles" => "Tiki RSS feed for articles",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "You have to indicate a group" => "You have to indicate a group",
// "This group is invalid" => "This group is invalid",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s" => "Could not read image %s",
// "Image %s upload failed" => "Image %s upload failed",
// "Image %s uploaded successfully" => "Image %s uploaded successfully",
// "Image %s removed from Batch directory" => "Image %s removed from Batch directory",
// "Impossible to remove image %s from Batch directory" => "Impossible to remove image %s from Batch directory",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images" => "Incorrect directory chosen for batch upload of images",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator" => "Please contact the website administrator",
// "Invalid directory name" => "Invalid directory name",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s" => "Could not read file %s",
// "Could not write to file %s" => "Could not write to file %s",
// "File %s upload failed" => "File %s upload failed",
// "Upload was successful" => "Upload was successful",
// "File %s removed from Batch directory" => "File %s removed from Batch directory",
// "Impossible to remove file %s from Batch directory" => "Impossible to remove file %s from Batch directory",
// "Incorrect directory chosen for batch upload of files" => "Incorrect directory chosen for batch upload of files",
// "Tiki RSS feed for blog: " => "Tiki RSS feed for blog: ",
// "Last modifications to the blog" => "Last modifications to the blog",
// "No blogId specified" => "No blogId specified",
// "Tiki RSS feed for weblogs" => "Tiki RSS feed for weblogs",
// "Last posts to weblogs" => "Last posts to weblogs",
// "Nothing tagged yet" => "Nothing tagged yet",
// "You must clear your browser cache" => "You must clear your browser cache",
// "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>" => "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "Access Denied" => "Access Denied",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string",
// "%H:%M %Z" => "%H:%M %Z",
// "Mo" => "Mo",
// "Tu" => "Tu",
// "We" => "We",
// "Th" => "Th",
// "Fr" => "Fr",
// "Sa" => "Sa",
// "Su" => "Su",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "No category indicated" => "No category indicated",
// "Permission denied; you cannot assign permissions for this category" => "Permission denied; you cannot assign permissions for this category",
// "Invalid username or activation code. Maybe this code has already been used" => "Invalid username or activation code. Maybe this code has already been used",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "Invalid request. Expecting channels array" => "Invalid request. Expecting channels array",
// "Missing channel name" => "Missing channel name",
// "Authentication required" => "Authentication required",
// "One of the requested channels cannot be requested. It does not exist or permission is denied" => "One of the requested channels cannot be requested. It does not exist or permission is denied",
// "One of the install profiles could not be obtained" => "One of the install profiles could not be obtained",
// "Account validated successfully" => "Account validated successfully",
// "Problem. Try to log in again to receive new confirmation instructions" => "Problem. Try to log in again to receive new confirmation instructions",
// "ERROR: you must include a subject or a message at least" => "ERROR: you must include a subject or a message at least",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
// "Tiki RSS feed for directory sites" => "Tiki RSS feed for directory sites",
// "Last sites" => "Last sites",
// "Must enter a name to add a site. " => "Must enter a name to add a site. ",
// "Must enter a url to add a site. " => "Must enter a url to add a site. ",
// "URL already added to the directory. Duplicate site? " => "URL already added to the directory. Duplicate site? ",
// "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. ",
// "Must select a category. " => "Must select a category. ",
// "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory",
// "No parent specified" => "No parent specified",
// "Last sites of directory \".\$rc[\"name\"].\" " => "Last sites of directory \".\$rc[\"name\"].\" ",
// "You cannot download this file right now. Your score is low or file limit was reached" => "You cannot download this file right now. Your score is low or file limit was reached",
// "Error : The file %s doesn't exist" => "Error : The file %s doesn't exist",
// "The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
// "Invalid structure_id or page_ref_id" => "Invalid structure_id or page_ref_id",
// "No topic id specified" => "No topic id specified",
// "Invalid topic id specified" => "Invalid topic id specified",
// "Translation in progress" => "Translation in progress",
// "No object indicated" => "No object indicated",
// "Page is a staging copy. Translation must begin from the approved copy" => "Page is a staging copy. Translation must begin from the approved copy",
// "No type indicated" => "No type indicated",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "Can't parse HTML data - no grammar file" => "Can't parse HTML data - no grammar file",
// "Can't import remote HTML page" => "Can't import remote HTML page",
// "Page already exists. Go back and choose a different name" => "Page already exists. Go back and choose a different name",
// "The translation set already contains a page in this language" => "The translation set already contains a page in this language",
// "No questions group indicated" => "No questions group indicated",
// "Remove archive: " => "Remove archive: ",
// "Remove file gallery: " => "Remove file gallery: ",
// "Tiki RSS feed for file galleries" => "Tiki RSS feed for file galleries",
// "Last files uploaded to the file galleries" => "Last files uploaded to the file galleries",
// "No galleryId specified" => "No galleryId specified",
// "Tiki RSS feed for the file gallery: " => "Tiki RSS feed for the file gallery: ",
// "Form error - no import method selected for some reason" => "Form error - no import method selected for some reason",
// "Form error - no server-side filename entered for selected import method" => "Form error - no server-side filename entered for selected import method",
// "Last replied forum topics" => "Last replied forum topics",
// "No forumId specified" => "No forumId specified",
// "Tiki RSS feed for forum: " => "Tiki RSS feed for forum: ",
// "Tiki RSS feed for forums" => "Tiki RSS feed for forums",
// "Last topics in forums" => "Last topics in forums",
// "Not supported yet" => "Not supported yet",
// "Accepted friendship request from %s" => "Accepted friendship request from %s",
// "Refused friendship request from %s" => "Refused friendship request from %s",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "Broke friendship with %s" => "Broke friendship with %s",
// "I have broken our friendship" => "I have broken our friendship",
// "You must be logged in to use this feature" => "You must be logged in to use this feature",
// "Friendship request sent to %s" => "Friendship request sent to %s",
// "You're already friend of %s" => "You're already friend of %s",
// "I have accepted your friendship request" => "I have accepted your friendship request",
// "I have refused your friendship request" => "I have refused your friendship request",
// "I have canceled my friendship request" => "I have canceled my friendship request",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "Invalid source path" => "Invalid source path",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "You couldn't abort a instance" => "You couldn't abort a instance",
// "You couldn't exception a instance" => "You couldn't exception a instance",
// "No title indicated" => "No title indicated",
// "No comment indicated" => "No comment indicated",
// "No date indicated" => "No date indicated",
// "first uploaded image" => "first uploaded image",
// "last uploaded image" => "last uploaded image",
// "random image" => "random image",
// "Permission denied you cannot make the map of this gallery" => "Permission denied you cannot make the map of this gallery",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "No valid renderer found. GD or PDFLib required" => "No valid renderer found. GD or PDFLib required",
// "No sheet specified" => "No sheet specified",
// "You must select a renderer" => "You must select a renderer",
// "Invalid Series for current graphic" => "Invalid Series for current graphic",
// "Tiki RSS feed for image galleries" => "Tiki RSS feed for image galleries",
// "Last images uploaded to the image galleries" => "Last images uploaded to the image galleries",
// "Tiki RSS feed for the image gallery: " => "Tiki RSS feed for the image gallery: ",
// "Only the administrator can upload language files" => "Only the administrator can upload language files",
// "updated from structured text import" => "updated from structured text import",
// "created from structured text import" => "created from structured text import",
// "Operations executed successfully" => "Operations executed successfully",
// "Page saved (version %d)" => "Page saved (version %d)",
// "No repository given" => "No repository given",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "Delete comments" => "Delete comments",
// "Approved Status" => "Approved Status",
// "Queued" => "Queued",
// "Non-existent gallery" => "Non-existent gallery",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Remove file: " => "Remove file: ",
// "Warning: Empty file" => "Warning: Empty file",
// "Please re-upload your file" => "Please re-upload your file",
// "Could not upload the file" => "Could not upload the file",
// "Could not find the file requested" => "Could not find the file requested",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Cannot read the file" => "Cannot read the file",
// "Upload was not successful. Duplicate file content" => "Upload was not successful. Duplicate file content",
// "File update was successful" => "File update was successful",
// "This gallery does not exist" => "This gallery does not exist",
// "The game file must have .swf or .dcr extension" => "The game file must have .swf or .dcr extension",
// "Please supply both files" => "Please supply both files",
// "You have to enable cookies to be able to login to this site" => "You have to enable cookies to be able to login to this site",
// "Unable to contact remote server" => "Unable to contact remote server",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Unable to create login" => "Unable to create login",
// "More than %d unsuccessful login attempts have been made" => "More than %d unsuccessful login attempts have been made",
// "An email has been sent to you with the instructions to follow" => "An email has been sent to you with the instructions to follow",
// "Your default nickname is already in use. A new one has to be selected" => "Your default nickname is already in use. A new one has to be selected",
// "The selected account is not associated with your identity" => "The selected account is not associated with your identity",
// "unknown action" => "unknown action",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "Invalid password" => "Invalid password",
// "Account disabled" => "Account disabled",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "Sorry, you can't use this feature" => "Sorry, you can't use this feature",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile" => "An error as occured with the mapfile",
// "Please create a directory named '.\$prefs['map_path'].' to hold your map files" => "Please create a directory named '.\$prefs['map_path'].' to hold your map files",
// "You do not have permissions to view the maps" => "You do not have permissions to view the maps",
// "Maps feature is not correctly setup : Maps path is missing" => "Maps feature is not correctly setup : Maps path is missing",
// "mapfile name incorrect" => "mapfile name incorrect",
// "This mapfile already exists" => "This mapfile already exists",
// "You do not have permission to write to the mapfile" => "You do not have permission to write to the mapfile",
// "You do not have permission to delete the mapfile" => "You do not have permission to delete the mapfile",
// "I could not make a copy" => "I could not make a copy",
// "You do not have permission to read the mapfile" => "You do not have permission to read the mapfile",
// "map edit" => "map edit",
// "You dont have permission to do that" => "You dont have permission to do that",
// "Tiki RSS feed for maps" => "Tiki RSS feed for maps",
// "List of maps available" => "List of maps available",
// "You do not have permissions to view the layers" => "You do not have permissions to view the layers",
// "You do not have permissions to delete a file" => "You do not have permissions to delete a file",
// "You do not have permissions to create a directory" => "You do not have permissions to create a directory",
// "The Directory is not empty" => "The Directory is not empty",
// "You do not have permissions to delete a directory" => "You do not have permissions to delete a directory",
// "You do not have permissions to create an index file" => "You do not have permissions to create an index file",
// "Invalid file name" => "Invalid file name",
// "Invalid files to index" => "Invalid files to index",
// "I do not know where is gdaltindex. Set correctly the Map feature" => "I do not know where is gdaltindex. Set correctly the Map feature",
// "I could not create the index file" => "I could not create the index file",
// "No page provided" => "No page provided",
// "Page \"%0\" does not exist" => "Page \"%0\" does not exist",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
// "Your PHP installation does not have zlib enabled" => "Your PHP installation does not have zlib enabled",
// "Are you sure you want to delete this note" => "Are you sure you want to delete this note",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "Missing object list type argument" => "Missing object list type argument",
// "Index" => "Index",
// "Index (' . \$code . " => "Index (' . \$code . ",
// "Pageviews" => "Pageviews",
// "You don't have permission to edit quizzes" => "You don't have permission to edit quizzes",
// "You must choose a group" => "You must choose a group",
// "Username cannot contain uppercase letters" => "Username cannot contain uppercase letters",
// "Username must be at least" => "Username must be at least",
// "Username cannot contain more than" => "Username cannot contain more than",
// "characters" => "characters",
// "Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Please enter a valid %s.  No spaces, more than %d characters and contain %s",
// "This is not a valid mail adress" => "This is not a valid mail adress",
// "mail adress" => "mail adress",
// "empty" => "empty",
// "Unable to send mail. User has not configured email" => "Unable to send mail. User has not configured email",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password" => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password",
// "The mail can't be sent. Contact the administrator" => "The mail can't be sent. Contact the administrator",
// "A password and your IP address reminder email has been sent " => "A password and your IP address reminder email has been sent ",
// "An email with a link to reset your password has been sent " => "An email with a link to reset your password has been sent ",
// "to the email" => "to the email",
// "last version" => "last version",
// "You cannot rename staging pages. Please rename the approved page instead" => "You cannot rename staging pages. Please rename the approved page instead",
// "Permission denied you cannot rename this page" => "Permission denied you cannot rename this page",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "changed '%s' from '%s' to '%s'" => "changed '%s' from '%s' to '%s'",
// "Non-existent version" => "Non-existent version",
// "Error Message" => "Error Message",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "No newsletters available" => "No newsletters available",
// "invalid email" => "invalid email",
// "Error: " => "Error: ",
// "Notice: this variable may not be empty" => "Notice: this variable may not be empty",
// "Notice: invalid variable value" => "Notice: invalid variable value",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Clean the sql logs" => "Clean the sql logs",
// "Quiz time limit exceeded quiz cannot be computed" => "Quiz time limit exceeded quiz cannot be computed",
// "Report to the webmaster" => "Report to the webmaster",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Batch file processed" => "Batch file processed",
// "The uploaded file ist not recognized as a image" => "The uploaded file ist not recognized as a image",
// "That is not an image (or you have php < 4.0.5)" => "That is not an image (or you have php < 4.0.5)",
// "Usage" => "Usage",
// "The user has chosen to make his information private" => "The user has chosen to make his information private",
// "Password has been changed" => "Password has been changed",
// "Invalid password. Your current password is required to change administrative information" => "Invalid password. Your current password is required to change administrative information",
// "Email is set to %s" => "Email is set to %s",
// "The passwords did not match" => "The passwords did not match",
// "unicode" => "unicode",
// "was moved into trash" => "was moved into trash",
// "trashed by" => "trashed by",
// "open / in process" => "open / in process",
// "Rights by creator" => "Rights by creator",
// "END" => "END",
// "Percentage" => "Percentage",
// "Task accepted by creator" => "Task accepted by creator",
// "Task accepted by task user" => "Task accepted by task user",
// "Task NOT accepted by creator" => "Task NOT accepted by creator",
// "Task NOT accepted by task user" => "Task NOT accepted by task user",
// "Sorry this task does not exist or you have no rights to view this task" => "Sorry this task does not exist or you have no rights to view this task",
// "Task entries" => "Task entries",
// "Changes" => "Changes",
// "Info message" => "Info message",
// "NEW Task" => "NEW Task",
// "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks" => "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks",
// "Changes on Task" => "Changes on Task",
// "You received a new task" => "You received a new task",
// "The priority is" => "The priority is",
// "very low" => "very low",
// "low" => "low",
// "high" => "high",
// "very high" => "very high",
// "You've to start your work at least on" => "You've to start your work at least on",
// "You've to finish your work on" => "You've to finish your work on",
// "Login and click the link below" => "Login and click the link below",
// "Please read the task and work on it" => "Please read the task and work on it",
// "Sorry, there was an error while trying to write data into the database" => "Sorry, there was an error while trying to write data into the database",
// "A new page is created in a language" => "A new page is created in a language",
// "Language watch" => "Language watch",
// "Non-existent user" => "Non-existent user",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again" => "You must suggest a question; please try again",
// "You are not permitted to remove someone else\\'s post" => "You are not permitted to remove someone else\\'s post",
// "Incorrect thread" => "Incorrect thread",
// "A SheetId is required" => "A SheetId is required",
// "That tracker don't use extras" => "That tracker don't use extras",
// " The connection failed, so check the server names" => " The connection failed, so check the server names",
// "The connection was OK" => "The connection was OK",
// " But the login failed, so check the Username and Password" => " But the login failed, so check the Username and Password",
// "Tiki RSS feed for the wiki pages" => "Tiki RSS feed for the wiki pages",
// "Last modifications to the Wiki" => "Last modifications to the Wiki",
// "Plugin modified by editor" => "Plugin modified by editor",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "The TikiTests Replay File has an error" => "The TikiTests Replay File has an error",
// "You are about to delete a TikiTest file, do you want to continue " => "You are about to delete a TikiTest file, do you want to continue ",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// "The page is empty" => "The page is empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Re:" => "Re:",
"ID" => "ID",
"Role" => "Role",
"Anonymous" => "Anonymous",
"Wiki" => "Wiki",
"Blogs" => "Blogs",
"FAQs" => "FAQs",
"blog" => "blog",
"faq" => "faq",
"WikiDiff Okay: LCS = %s" => "WikiDiff Okay: LCS = %s",
"Blog" => "Blog",
"By:" => "By:",
"FAQ" => "FAQ",
"pvs" => "pvs",
"wiki" => "wiki",
"faqs" => "faqs",
"blogs" => "blogs",
"(AT)" => "(AT)",
"(DOT)" => "(DOT)",
"Cookie" => "Cookie",
"Value" => "Value",
"URL" => "URL",
"Id" => "Id",
"Top" => "Top",
"on" => "on",
"RSS feed" => "RSS feed",
"Properties" => "Properties",
"Hi," => "Hi,",
"Hi" => "Hi",
"Bye bye!" => "Bye bye!",
"of" => "of",
"Ip" => "Ip",
"Invalid" => "Invalid",
"CC" => "CC",
"BCC" => "BCC",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"Cc" => "Cc",
"Cookies" => "Cookies",
"Mail-in" => "Mail-in",
"Shoutbox" => "Shoutbox",
"phpinfo" => "phpinfo",
"Trackback pings" => "Trackback pings",
"URI" => "URI",
"RSS" => "RSS",
"Webmail" => "Webmail",
"XMLRPC API" => "XMLRPC API",
"Unix" => "Unix",
"Windows" => "Windows",
"PEAR::Auth" => "PEAR::Auth",
"Warning" => "Warning",
"Complete" => "Complete",
"DSN" => "DSN",
"x" => "x",
"Url" => "Url",
"h" => "h",
"CMS" => "CMS",
"cookie" => "cookie",
"wiki-get" => "wiki-get",
"wiki-put" => "wiki-put",
"wiki-append" => "wiki-append",
"Valid" => "Valid",
"Email:" => "Email:",
"isMain" => "isMain",
"Tbl vis" => "Tbl vis",
"bcc" => "bcc",
"+" => "+",
"Roles" => "Roles",
"cType" => "cType",
"Own Image" => "Own Image",
"Use own image" => "Use own image",
"Own image size x" => "Own image size x",
"Own image size y" => "Own image size y",
"col" => "col",
"rss feed" => "rss feed",
"tagline" => "tagline",
"quote" => "quote",
"Int" => "Int",
"#" => "#",
"inter" => "inter",
"This process is invalid" => "This process is invalid",
"List of processes" => "List of processes",
"Inactive" => "Inactive",
"act" => "act",
"val" => "val",
"Activities" => "Activities",
"No processes defined yet" => "No processes defined yet",
"Process:" => "Process:",
"exception" => "exception",
"Owner" => "Owner",
"Send all to" => "Send all to",
"Don't move" => "Don't move",
"Act status" => "Act status",
"Property" => "Property",
"Add property" => "Add property",
"run instance" => "run instance",
"Admin processes" => "Admin processes",
"Add or edit a process" => "Add or edit a process",
"Process Name" => "Process Name",
"ver:" => "ver:",
"is active?" => "is active?",
"Or upload a process using this form" => "Or upload a process using this form",
"Admin process roles" => "Admin process roles",
"Add or edit a role" => "Add or edit a role",
"Process roles" => "Process roles",
"No roles defined yet" => "No roles defined yet",
"Map users to roles" => "Map users to roles",
"map" => "map",
"Map groups to roles" => "Map groups to roles",
"Operation" => "Operation",
"No roles are defined yet so no roles can be mapped" => "No roles are defined yet so no roles can be mapped",
"List of mappings" => "List of mappings",
"No mappings defined yet" => "No mappings defined yet",
"Admin process sources" => "Admin process sources",
"select source" => "select source",
"Shared code" => "Shared code",
"Set next user" => "Set next user",
"Get property" => "Get property",
"Set property" => "Set property",
"Process form" => "Process form",
"Set Next act" => "Set Next act",
"If:SetNextact" => "If:SetNextact",
"Switch construct" => "Switch construct",
"Map process roles" => "Map process roles",
"Monitor Activities" => "Monitor Activities",
"List of activities" => "List of activities",
"auto" => "auto",
"int" => "int",
"routing" => "routing",
"Instances" => "Instances",
"run" => "run",
"run activity" => "run activity",
"monitor processes" => "monitor processes",
"monitor activities" => "monitor activities",
"monitor instances" => "monitor instances",
"monitor workitems" => "monitor workitems",
"Monitor Instances" => "Monitor Instances",
"List of instances" => "List of instances",
"No instances created yet" => "No instances created yet",
"Monitor Processes" => "Monitor Processes",
"processes" => "processes",
"being run" => "being run",
"Monitor workitems" => "Monitor workitems",
"List of workitems" => "List of workitems",
"instance" => "instance",
"exception instance" => "exception instance",
"exceptions instance" => "exceptions instance",
"abort instance" => "abort instance",
"grab instance" => "grab instance",
"release instance" => "release instance",
"process" => "process",
"user processes" => "user processes",
"user activities" => "user activities",
"user instances" => "user instances",
"User Instances" => "User Instances",
"Inst Status" => "Inst Status",
"No instances defined yet" => "No instances defined yet",
"User Processes" => "User Processes",
"Browsing Workitem" => "Browsing Workitem",
"Workitem information" => "Workitem information",
"on:" => "on:",
"Mb" => "Mb",
"Weblogs" => "Weblogs",
"top" => "top",
"Pos" => "Pos",
"User_versions_for" => "User_versions_for",
"Q" => "Q",
"A" => "A",
"pts" => "pts",
"RSS feeds" => "RSS feeds",
"TOP" => "TOP",
"Activity name already exists" => "Activity name already exists",
"indicates if the process is active. Invalid processes cant be active" => "indicates if the process is active. Invalid processes cant be active",
"No instance indicated" => "No instance indicated",
"No activity indicated" => "No activity indicated",
"The process name already exists" => "The process name already exists",
"Process already exists" => "Process already exists",
"You cant execute this activity" => "You cant execute this activity",
"tiki-mobile.php" => "tiki-mobile.php",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "這個功能已經關閉",
"Permission denied you cannot view pages" => "你沒有觀看頁面的權限",
"The copyright management feature is not enabled." => "版權管理功能並未啟動.",
"No page indicated" => "沒有指定頁面",
"You must supply all the information, including title and year." => "你必須提供所有資訊, 包含標題與年份.",
"You do not have permission to use this feature" => "你沒有使用此功能的權限",
"Type" => "類型",
"Name" => "名稱",
"Description" => "描述",
"Size" => "大小",
"Created" => "產生",
"Last Modified" => "最近修改",
"Creator" => "建立者",
"Author" => "作者",
"Comment" => "評論",
"Files" => "檔案",
"Hits" => "點擊數",
"Locked by" => "由鎖定",
"Path" => "路徑",
"None" => "無",
"Activity" => "活動力",
"points" => "分",
"Disabled" => "關閉",
"Plain text" => "純文字",
"Link to user information" => "連結至使用者資訊",
"User avatar" => "使用者頭像",
"Creation date (desc)" => "建立日期 (降冪)",
"Last modification date (desc)" => "最近修改日期 (降冪)",
"Blog title (asc)" => "Blog 標題 (升冪)",
"Number of posts (desc)" => "佈告數 (降冪)",
"Visits (desc)" => "拜訪數 (降冪)",
"Activity (desc)" => "活動力 (降冪)",
"Top bar" => "最上列",
"Bottom bar" => "最下列",
"no cache" => "無快取",
"minute" => "分",
"minutes" => "分",
"hour" => "小時",
"hours" => "小時",
"|| for rows" => "|| 表示一列",
"<return> for rows" => "\n 表示一列",
"Week" => "週",
"Month" => "月",
"Year" => "年",
"Saturday" => "星期六",
"Sunday" => "星期日",
"Monday" => "星期一",
"Creation Date (desc)" => "建立日期 (降冪)",
"Topics (desc)" => "主題 (降冪)",
"Threads (desc)" => "討論串 (降冪)",
"Last post (desc)" => "最近發表佈告 (降冪)",
"Name (desc)" => "名稱 (降冪)",
"Name (asc)" => "名稱 (升冪)",
"replace current window" => "取代目前視窗",
"new window" => "新的視窗",
"inline frame" => "行內頁框",
"5 minutes" => "5 分鐘",
"1 day" => "1 天",
"1 week" => "1 週",
"1 month" => "1 個月",
"Allow secure (https) login" => "允許安全 (https) 登入",
"Require secure (https) login" => "需要安全 (https) 登入",
"Just Tiki" => "僅 Tiki",
"Web Server" => "網站伺服器",
"Tiki and PEAR::Auth" => "Tiki 與 PEAR::Auth",
"Use database to store files" => "使用資料庫來儲存檔案",
"Use a directory to store files" => "使用資料夾來儲存檔案",
"Permission denied" => "權限不足",
"The file is not a CSV file or has not a correct syntax" => "檔案不是 CSV 檔, 或是語法錯誤",
"locked" => "鎖定",
"locked by" => "由鎖定",
"in" => "於",
"continued" => "待續",
"New Image Uploaded by" => "新影像上傳自",
"New Subscriptions" => "新訂閱",
"New Item in Tracker" => "追蹤系統中有新項目",
"by" => "由",
"Image Gallery" => "影像圖庫",
"Articles" => "文章",
"Forums" => "論壇",
"Directory" => "目錄",
"File Gallery" => "檔案庫",
"Quizzes" => "測驗",
"Trackers" => "追蹤系統",
"Survey" => "調查",
"Newsletter" => "電子報",
"Charts" => "排行榜",
"article" => "文章",
"directory" => "目錄",
"forum" => "論壇",
"poll" => "投票",
"quiz" => "測驗",
"image" => "影像",
"calendar" => "行事曆",
"Invalid filename (using filters for filenames)" => "不合法檔名 (使用檔名過濾器)",
"Cannot upload this file maximum upload size exceeded" => "無法上傳檔案, 超過最大檔案大小限制",
"Wrong password. Cannot post comment" => "密碼錯誤. 無法發表評論",
"You have to enter a title and text" => "請輸入標題與內容",
"text" => "文字",
"WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::apply: 行數不符: %s != %s",
"WikiDiff::_check: failed" => "WikiDiff::_check: 失敗",
"WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_check: 編輯序列並非最佳",
"Find" => "尋找",
"find" => "尋找",
"prev" => "前一個",
"Page" => "頁面",
"next" => "後一個",
"Page name" => "頁面名稱",
"Wiki Home" => "Wiki 首頁",
"Home" => "首頁",
"previous page" => "前一頁",
"next page" => "下一頁",
"posted on" => "發表於",
"Read" => "閱讀",
"List articles" => "列出文章",
"Last post" => "最新發表",
"Invalid imagename (using filters for filenames)" => "影像名稱不合法 (使用檔名過濾器)",
"Errors detected" => "偵測到錯誤",
"Upload was not successful" => "上傳失敗",
"No image yet, sorry." => "尚無影像, 抱歉.",
"unknown" => "不明",
"NONE" => "無",
"Wiki top pages" => "Wiki 首頁",
"Most relevant pages" => "最相關頁面",
"Relevance" => "相當",
"Wiki last pages" => "Wiki 末頁",
"Modified" => "已變更",
"Forums last topics" => "論壇最新話題",
"Topic date" => "主題日期",
"Forums most read topics" => "論壇最熱門話題",
"Reads" => "閱讀",
"Forums best topics" => "論壇最佳話題",
"Score" => "分數",
"Forums most visited forums" => "最熱門論壇",
"Visits" => "瀏覽數",
"Forums with most posts" => "最多文章論壇",
"Posts" => "佈告數",
"Wiki top galleries" => "Wiki 最熱門圖庫",
"Wiki top file galleries" => "Wiki 最熱門檔案庫",
"Wiki top images" => "Wiki 最熱門影像",
"Wiki top files" => "Wiki 最熱門檔案",
"Downloads" => "下傳數",
"Wiki last images" => "Wiki 最新影像",
"Upload date" => "上傳日期",
"Wiki last files" => "Wiki 最新檔案",
"Wiki top articles" => "Wiki 最熱門文章",
"Most visited blogs" => "最常被瀏覽 blogs",
"Most active blogs" => "最活躍 blog",
"Blogs last posts" => "Blogs 最新文章",
"Post date" => "發表日期",
"Wiki top authors" => "Wiki 最佳作者",
"Pages" => "頁面",
"Top article authors" => "文章最多作者",
"User already exists" => "使用者已經存在",
"Wrong registration code" => "註冊碼錯誤",
"Invalid username" => "不合法的使用者名稱",
"Username is too long" => "使用者名稱過長",
"Username cannot contain whitespace" => "使用者名稱不可含有空白",
"Wrong passcode you need to know the passcode to register in this site" => "passcode 錯誤, 你必須有 passcode 才能在本站註冊",
"Invalid email address. You must enter a valid email address" => "不正確的 email. 請輸入正確的 email 地址",
"Login" => "登入",
"Send message" => "發送訊息",
"Attach file" => "附加檔案",
"Tracker" => "追蹤",
"Image" => "影像",
"Article" => "文章",
"Forum" => "論壇",
"Gallery" => "圖庫",
"Blog post" => "Blog 佈告",
"Prev" => "前一個",
"Next" => "下一個",
"help" => "說明",
"All" => "全部",
"days" => "日",
"day" => "日",
"mins" => "分",
"min" => "分",
"secs" => "秒",
"done" => "完成",
"from" => "由",
"for" => "表示",
"Priority" => "重要性",
"Yes" => "是",
"No" => "否",
"You are not logged in" => "你尚未登入",
"Page cannot be found" => "找不到頁面",
"Permission denied you cannot view this section" => "權限不足, 你無法觀看這個區段",
"Help" => "說明",
"You are banned from" => "你被禁止使用",
"quizzes" => "測驗",
"forums" => "論壇",
"games" => "遊戲",
"at" => "於",
"new" => "增加",
"Rating" => "評等",
"Item" => "項目",
"Subject" => "主題",
"Tracker was modified at " => "追蹤修改於 ",
"text field" => "文字欄",
"size" => "大小",
"textarea" => "文字區",
"checkbox" => "核取盒",
"drop down" => "下拉選單",
"user selector" => "使用者選擇器",
"group selector" => "群組選擇器",
"date and time" => "日期和時間",
"action" => "動作",
"category" => "分類",
"email" => "電子郵件",
"attachment" => "附件",
"open" => "開放",
"closed" => "關閉",
"Message" => "訊息",
"child categories" => "子類別",
"objects in category" => "類別中的物件",
"Password should be at least" => "密碼應至少有",
"characters long" => "字元長",
"Password must contain both letters and numbers" => "密碼必須含有字母及數字",
"Country" => "國家",
"Location" => "地點",
"Language" => "語言",
"Start date" => "開始日期",
"Attachment" => "附件",
"File" => "檔案",
"Show description" => "顯示描述",
"Avatar" => "頭像",
"Displays the user Avatar" => "顯示使用者頭像",
"username" => "使用者名稱",
"Back" => "返回",
"Backlinks" => "反向連結",
"Zone" => "區域",
"Items" => "項目",
"Insert theme styled box on wiki page" => "wiki 頁面上插入採用主題樣式的方塊",
"Category" => "分類",
"Insert list of items for the current/given category into wiki page" => "插入目前/指定類別的項目列表至 wiki 頁面",
"Categories are disabled" => "類別功能已關閉",
"Display Tiki objects that have not been categorized" => "顯示尚未分類的 Tiki 物件",
"Objects" => "物件",
"Insert the full category path for each category that this wiki page belongs to" => "插入此 wiki 頁面所屬的所有類別完整路徑",
"Center" => "置中",
"Centers the plugin content in the wiki page" => "plugin 內容置中於 wiki 頁面",
"Chart" => "排行榜",
"title" => "標題",
"Code" => "碼",
"code" => "碼",
"Dynamic Content" => "動態內容",
"Copyright" => "版權所有",
"Insert copyright notices" => "插入版權宣告",
"Example" => "範例",
"seconds" => "秒",
"term" => "名詞",
"definition" => "定義",
"drawing not found" => "找不到繪圖",
"Desc" => "描述",
"Upcoming events" => "近期事件",
"Displays the data using the Tikiwiki odd/even table style" => "使用 Tikiwiki 「奇/偶」表格樣式顯示資料",
"Title" => "標題",
"sort" => "排序",
"description" => "描述",
"Displays a graphical GAUGE" => "顯示圖型化錶計",
"type" => "類型",
"Group" => "群組",
"HTML code" => "HTML碼",
"name" => "名稱",
"Image ID" => "影像 ID",
"Image size" => "影像大小",
"Img" => "影像",
"Include" => "包含",
"Start" => "開始",
"Stop" => "stop",
"Last Modification" => "最後修改",
"List Pages" => "列出頁面",
"Sort" => "排序",
"or" => "或",
"Filter" => "過濾器",
"Map" => "地圖",
"Feature disabled" => "功能已關閉",
"Module Name" => "模組名稱",
"Please choose a module" => "請選擇模組",
"to be used as argument" => "用為參數",
"Displays a module inlined in page" => "以 inline 方式在頁面上顯示模組",
"Sorry no such module" => "抱歉, 沒有這個模組",
"Font" => "字型",
"Displays the data using a monospace font" => "以定寬字顯示資料",
"Text" => "文字",
"Sticky" => "置頂",
"data" => "資料",
"Object" => "物件",
"Days" => "數日",
"picture not found" => "找不到圖片",
"No version indicated" => "未指定版本",
"Poll" => "投票",
"Search" => "搜尋",
"Date" => "日期",
"Display" => "顯示",
"Action" => "動作",
"Sorts the plugin content in the wiki page" => "在 wiki 頁面中排序外掛模組內容",
"Order" => "順序",
"First" => "第一個",
"Edit" => "編輯",
"Missing db param" => "缺少資料庫參數",
"Subscribe" => "訂閱",
"Groups" => "群組",
"Tag Name" => "標籤名稱",
"Thumbnail" => "縮圖",
"Original" => "原始",
"Public" => "公開",
"Translate" => "翻譯",
"Fields" => "欄位",
"Preview" => "預覽",
"preview" => "預覽",
"View" => "觀看",
"Error" => "錯誤",
"Filters" => "過濾器",
"Status" => "狀態",
"Template" => "模板",
"Mode" => "模式",
"Flag" => "國旗",
"users" => "使用者",
"Preferences" => "使用偏好",
"User Information" => "使用者資訊",
"Versions" => "版本",
"Vote" => "投票",
"valid" => "確認",
"ERROR: Either the subject or body must be non-empty" => "錯誤: 標題或內文不可以為空",
"ERROR: No valid users to send the message" => "錯誤: 沒有可發送訊息的合法使用者",
"Invalid user" => "不合法的使用者",
"Message sent to" => "訊息發送至",
"Message will be sent to: " => "訊息將發送至: ",
"No more messages" => "沒有訊息了",
"Calendar" => "行事曆",
"Create/Edit" => "建立/編輯",
"Quick Edit a Wiki Page" => "快速編輯 Wiki 頁面",
"Post" => "發表佈告",
"new comments" => "新評論",
"wiki pages changed" => "wiki 頁面已變動",
"new images" => "新影像",
"new files" => "新檔案",
"new users" => "新使用者",
"Invalid username or password" => "使用者名稱或密碼錯誤",
"change password" => "更改密碼",
"country" => "國家",
"Random Image" => "隨機影像",
"List of attached files" => "附檔列表",
"id" => "編號",
"desc" => "描述",
"uploaded" => "已上傳",
"Delete" => "刪除",
"Remove" => "移除",
"Upload file" => "上傳檔案",
"Attach" => "附檔",
"Attach a file to this item" => "夾帶一個檔案至此項目",
"Version" => "版本",
"Attachments" => "附件",
"No attachments for this item" => "此項目無附件",
"debug" => "除錯",
"Fatal error" => "內部錯誤",
"Created by" => "產生自 ",
"Edit blog" => "編輯 blog",
"Monitor this Blog" => "監控此 blog",
"Stop Monitoring this Blog" => "停止監控此 blog",
"Activity=" => "活動力=",
"Actions" => "行動",
"No records found" => "查無記錄",
"No categories defined" => "尚未定義類別",
"stars" => "星",
"User Level" => "使用者等級",
"private message" => "私人訊息",
"Send eMail to User" => "發送 email 至使用者",
"user online" => "使用者在線上",
"user offline" => "使用者已離線",
"Approve" => "同意",
"Reject" => "駁回",
"Save to notepad" => "儲存到筆記本",
"Monitor this Topic" => "監控此主題",
"Stop Monitoring this Topic" => "停止監控此主題",
"Moderator actions" => "板主命令",
"reported:" => "已回報項目:",
"queued:" => "佇列中:",
"Move to topic:" => "移動至主題:",
"Move" => "移動",
"Delete Selected" => "刪除選擇項目",
"Unlock" => "解除鎖定",
"Lock" => "鎖定",
"Messages" => "訊息",
"Title (desc)" => "標題 (降冪)",
"Title (asc)" => "標題 (升冪)",
"Threshold" => "起算點",
"Set" => "設定",
"Replies" => "回覆數",
"Editing comment" => "編輯評論",
"Post new comment" => "發表新評論",
"Smileys" => "表情符號",
"Cancel" => "取消",
"Posting comments" => "發表評論",
"Use" => "使用",
"for links" => "表示連結",
"Add Comment" => "增加評論",
"1 comment" => "1 篇評論",
"Comments" => "評論",
"Go back" => "回上頁",
"Return to home page" => "返回首頁",
"Copyrights" => "版權所有",
"Authors" => "作者",
"Add" => "加入",
"Syntax" => "語法",
"Page generation debugging log" => "頁面生成除錯用紀錄",
"Features state" => "功能狀態",
"Total" => "全部",
"features matched" => "符合的功能",
"Watchlist" => "監視列表",
"duplicate" => "重複",
"There are individual permissions set for this file gallery" => "這個檔案庫有獨立的權限設定",
"Save" => "儲存",
"Gallery is visible to non-admin users?" => "允許非管理者用戶看到?",
"none" => "無",
"Max description display size" => "最大描述顯示大小",
"Max Rows per page" => "每頁最大列數",
"Listing configuration" => "列表設定",
"Perms" => "權限",
"List" => "列表",
"Browse" => "瀏覽",
"Name-filename" => "名稱-檔名",
"Filename only" => "僅檔名",
"Close" => "關閉",
"Number of displayed rows" => "顯示的列數",
"Go" => "衝",
"in:" => "於:",
"Move Selected Files" => "移動選擇的檔案",
"Move to" => "移動至",
"Assign" => "指定",
"Filename" => "檔案",
"Hi {\$mail_user} has sent you this link:" => "Hi {\$mail_user} 寄給你這個連結:",
"Blog post:" => "Blog 佈告:",
"at:" => "於:",
"Somebody or you tried to subscribe this email address at our site:" => "某人或是你試圖以此 email 地址訂閱本站的電子報:",
"To the newsletter:" => "訂閱的電子報:",
"Description:" => "描述:",
"In order to confirm your subscription you must access the following URL:" => "你必須連接至以下的 URL 以確認訂閱:",
"A new message was posted to forum" => "新訊息發表於論壇",
"Tiki mail-in instructions" => "Tiki mail-in 說明",
"A new message was posted to you at {\$mail_machine}" => "有新訊息於 {\$mail_machine} 發表給你",
"From" => "由",
"Enjoy the site!" => "好好享受本站的資源!",
"The user" => "使用者",
"registered at your site" => "在你的站臺註冊",
"New user registration" => "新使用者註冊",
"This email address has been removed to the list of subscriptors of:" => "此 email 地址已被移出訂閱列表:",
"Newsletter:" => "電子報:",
"You can unsubscribe from this newsletter following this link" => "你可以使用以下的連結停止訂閱本電子報",
"Welcome to our newsletter!" => "歡迎加入我們的電子報!",
"This email address has been added to the list of subscriptors of:" => "此 email 地址已被加入訂閱列表:",
"You can always cancel your subscription using:" => "你可以這樣取消你的訂閱:",
"Email notification" => "Tiki email 通知",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "{\$mail_user} 傳送新文章至 {\$mail_site} 於 {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "你可以使用此連結修改送出的資料:",
"Title:" => "標題:",
"Heading:" => "標題:",
"Body:" => "本文:",
"User:" => "使用者:",
"You or someone registered this email address at" => "你或是某位註冊此 email 地址的人",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "如果你要成為本站的註冊使用者, 必須使用以下連結進行第一次登入:",
"Your registration confirmation" => "你的 Tiki 資訊登記",
"You will receive an email with information to login for the first time into this site" => "你將會收到 email 說明初次登入本站的資訊",
"If you don't want to receive these notifications follow this link:" => "如果你不想再收到這些通知請使用此連結:",
"View the blog at:" => "檢視此 blog 於:",
"changed" => "更改",
"created" => "建立",
"New" => "增加",
"File Description" => "檔案描述",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "此頁面 {\$mail_page} 由 {\$mail_user} 更改於 {\$mail_date|tiki_short_datetime}",
"Comment:" => "評論:",
"New name" => "新名稱",
"Last modification date" => "上次修改日期",
"Create" => "建立",
"History" => "歷史紀錄",
"Compare" => "比較",
"Current" => "目前",
"Versions are identical" => "版本相同",
"User" => "使用者",
"Diff" => "比對差異",
"Unread" => "未閱讀",
"Flagged" => "標記",
"Unflagged" => "已解除標記",
"Containing" => "包含",
"Sender" => "寄件者",
"No messages to display" => "沒有訊息可顯示",
"Broadcast message" => "廣播訊息",
"OK" => "ok",
"All users" => "所有使用者",
"Lowest" => "最低",
"Low" => "低",
"Normal" => "正常",
"High" => "高",
"Very High" => "非常高",
"Send" => "發送",
"Compose message" => "撰寫訊息",
"To" => "至",
"Mark as read" => "設為閱讀",
"Mark as unread" => "設為未讀",
"Mark as flagged" => "設為已標記",
"Mark as unflagged" => "設為未標記",
"Mark" => "標計",
"Mailbox" => "信件匣",
"Compose" => "編寫",
"Broadcast" => "廣播",
"Read message" => "閱讀訊息",
"replyall" => "回覆全部",
"Flag this message" => "標記此訊息",
"Up" => "上",
"Down" => "下",
"Admin Menu" => "管理選單",
"Live Support" => "線上支援",
"Banning" => "禁用",
"Users" => "使用者",
"Cache" => "快取",
"Modules" => "模組",
"Links" => "連結",
"Hotwords" => "熱門單字",
"RSS Modules" => "RSS 模組",
"Menus" => "選單",
"Polls" => "測驗紀錄",
"Mail Notifications" => "郵件通知",
"Chat" => "閒談",
"Categories" => "分類",
"Banners" => "大標題",
"Edit Templates" => "編輯模板",
"Content Templates" => "內容模版",
"HTML Pages" => "HTML 頁面",
"Referer Stats" => "參照頁統計",
"Admin dsn" => "管理 dsn",
"Select" => "選擇",
"Admin" => "管理",
"Admin Modules" => "管理模組",
"Admin Menus" => "管理選單",
"login" => "登入",
"Recently visited pages" => "最近拜訪頁面",
"January" => "一月",
"February" => "二月",
"March" => "三月",
"April" => "四月",
"May" => "五月",
"June" => "六月",
"July" => "七月",
"August" => "八月",
"September" => "九月",
"October" => "十月",
"November" => "十一月",
"December" => "十二月",
"Tuesday" => "星期二",
"Wednesday" => "星期三",
"Thursday" => "星期四",
"Friday" => "星期五",
"Today" => "今天",
"Received objects" => "接收的物件",
"Pages:" => "頁面:",
"Last Sites" => "最新站臺",
"Directory Stats" => "目錄狀態",
"Sites" => "站臺",
"Sites to validate" => "待確認的站臺",
"Searches" => "搜尋",
"Visited links" => "已拜訪連結",
"Top Sites" => "熱門站臺",
"Featured links" => "主打連結",
"Top topics" => "最熱門主題",
"Last forum topics" => "最新論壇主題",
"Most commented forums" => "最多評論論壇",
"Most read topics" => "最多閱讀主題",
"Most visited forums" => "最多訪客論壇",
"Google Search" => "Google 搜尋",
"Last blog posts" => "最新 blog 佈告",
"Last" => "最近",
"Last Created blogs" => "最近建立 blogs",
"Last Created FAQs" => "最近建立 FAQS",
"Last Created Quizzes" => "最近建立的測驗",
"Last modified file galleries" => "最近更新的檔案庫",
"Last Files" => "最近檔案",
"Last galleries" => "最新圖庫",
"Last changes" => "最近變動",
"Last Modified Items" => "上一個修改項目",
"Last Modified blogs" => "最近修改 blogs",
"Last submissions" => "最近送交文章",
"Last Items" => "上一個項目",
"Register" => "註冊",
"Live support" => "線上支援",
"Open operator console" => "開啟服務員介面",
"Online users" => "線上使用者",
"We have" => "我們有",
"online users" => "線上使用者",
"Logout" => "登出",
"Switch" => "轉換",
"Email" => "電子郵件",
"eMail" => "電子郵件",
"Password" => "密碼",
"Remember me" => "記住我的身份",
"week" => "週",
"month" => "月",
"I forgot my password" => "忘記密碼",
"Standard" => "標準",
"Secure" => "安全",
"Stay in ssl Mode" => "保留在 ssl 模式",
"Tiki Logo" => "Tiki 圖示",
"Menu" => "選單",
"You have" => "你有",
"New Messages" => "新訊息",
"New Message" => "件新訊息",
"You have 0 new messages" => "你有 0 封新訊息",
"Waiting Submissions" => "等待送交文章",
"submissions waiting to be examined" => "等待檢查的文章",
"Old articles" => "舊文章",
"Send a message to" => "發送訊息至",
"Random Pages" => "隨機頁面",
"Register as a new user" => "註冊新使用者",
"Your email could not be validated; make sure you email is correct and click register below." => "你的 email 無法確認; 請確認你的 email 輸入正確並按下註冊鍵.",
"Your registration code:" => "你的註冊碼:",
"Username" => "使用者名稱",
"Passcode to register (not your user password)" => "註冊用 Passcode (並非你的使用者密碼)",
"Registration code" => "註冊碼",
"Repeat password" => "再次輸入密碼",
"Generate a password" => "產生一個密碼",
"Image Galleries" => "影像圖庫",
"File Galleries" => "檔案庫",
"Entire Site" => "整個網站",
"Wiki Pages" => "Wiki 頁面",
"Image Gals" => "影像圖庫",
"Images" => "影像",
"Blog Posts" => "Blog 佈告",
"Search Wiki PageName" => "搜尋 Wiki 頁面名稱",
"Read More" => "繼續閱讀",
"Since your last visit" => "自從你上次拜訪",
"Since your last visit on" => "自從你上次拜訪由",
"New Images" => "新影像",
"Wiki Pages Changed" => "wiki 頁面已變動",
"New Files" => "新檔案",
"New Comments" => "新評論",
"New Users" => "新使用者",
"click to edit" => "點擊可編輯",
"Theme" => "佈景主題",
"Most Active blogs" => "最活躍 blogs",
"Top articles" => "最熱門文章",
"Top File Galleries" => "最熱門檔案庫",
"Top games" => "最熱門遊戲",
"Top galleries" => "最熱門圖庫",
"Top Images" => "最熱門影像",
"Top Pages" => "最熱門頁面",
"Top Quizzes" => "最熱門測驗",
"Top Visited FAQs" => "最熱門 FAQs",
"view" => "觀看",
"My blogs" => "我的 blogs",
"Bookmarks" => "書籤",
"My galleries" => "我的圖庫",
"My Pages" => "我的頁面",
"User tasks" => "使用者任務",
"Done" => "完成",
"Del" => "清除",
"online user" => "線上使用者",
"Real Name" => "真實姓名",
"vote" => "投票",
"Find:" => "尋找:",
"pages" => "頁面",
"To edit the copyright notices" => "要編輯版權宣告",
"Click Here" => "點擊此處",
"The content on this page is licensed under the terms of the" => "本頁面的內容根據以下條文授權",
"Print" => "列印",
"Email This Post" => "email 此文章",
"Permalink" => "固定連結",
"comment" => "評論",
"comments" => "評論",
"First page" => "首頁",
"Previous page" => "前一頁",
"page" => "頁面",
"Next page" => "後一頁",
"Last page" => "末頁",
"referenced by" => "參考自",
"references" => "參考",
"View Comments" => "觀看評論",
"Blog name" => "Blog 名稱",
"Tools Calendars" => "工具行事曆",
"Check / Uncheck All" => "全選/全取消",
"Refresh" => "重新整理",
"Cancel Edit" => "取消編輯",
"Change preferences" => "更改偏好",
"Content" => "內容",
"Activate" => "啟動",
"Publish" => "發表",
"General" => "一般",
"Features" => "功能",
"Module" => "模組",
"User files" => "使用者檔案",
"General Settings" => "一般設定",
"Home Blog (main blog)" => "首頁 Blog (主要 blog)",
"Rankings" => "排名",
"Points" => "分數",
"Last modified" => "最近改變",
"Permissions" => "權限",
"Topic" => "主題",
"Submissions" => "提交",
"Import CSV file" => "匯入 CSV 檔案",
"Batch upload (CSV file)" => "批次上傳 (CSV 檔案)",
"Import" => "匯入",
"avatar" => "頭像",
"Last login" => "最近登入",
"Number of visited pages to remember" => "拜訪過頁面保留筆數",
"Displayed time zone" => "顯示時區",
"User information" => "使用者資訊",
"Private" => "私人",
"public" => "公開",
"Tasks per page" => "每頁工作數",
"Messages per page" => "每頁訊息數",
"Allow messages from other users" => "允許其他使用者的訊息",
"Send me an email for messages with priority equal or greater than" => "發送 email 通知, 當訊息重要性大於等於",
"My Tiki" => "我的 Tiki",
"My pages" => "我的頁面",
"My messages" => "我的訊息",
"My tasks" => "我的工作",
"My items" => "我的事項",
"Number of columns per page when listing categories" => "當列出分類時每頁欄位數",
"Links per page" => "每頁連結數",
"Validate URLs" => "確認 URLs",
"Method to open directory links" => "打開目錄連結的方法",
"New Window" => "新的視窗",
"Default number of comments per page" => "預設每頁評論數目",
"Comments default ordering" => "預設評論排序",
"Newsletters" => "電子報",
"Surveys" => "調查",
"Featured Help" => "主打說明",
"Live support system" => "線上支援系統",
"Contact Us" => "連絡我們",
"Drawings" => "繪圖",
"Games" => "遊戲",
"Administration Features" => "管理功能",
"Banning System" => "禁用系統",
"Banning system" => "禁用系統",
"Stats" => "狀態",
"Communications (send/receive objects)" => "通訊 (發送/接受 物件)",
"Custom Home" => "自訂首頁",
"User Features" => "使用者功能",
"Mini Calendar" => "迷你月曆",
"User Preferences Screen" => "使用者偏好畫面",
"User Notepad" => "使用者記事本",
"User Bookmarks" => "使用者書籤",
"User Watches" => "使用者監視",
"User Menu" => "使用者選單",
"User Tasks" => "使用者工作",
"User Messages" => "使用者訊息",
"User Files" => "使用者檔案",
"Newsreader" => "News閱讀器",
"Debugger Console" => "除錯器控制臺",
"Workflow" => "工作流程",
"Workflow engine" => "工作流程引擎",
"Home Gallery (main gallery)" => "首頁圖庫 (主圖庫)",
"Never" => "從不",
"Home Forum (main forum)" => "首頁論壇 (主論壇)",
"Accept wiki syntax" => "接受 wiki 語法",
"Topics" => "主題",
"Posts per day" => "每日發表數",
"Galleries features" => "圖庫功能",
"Use database to store images" => "使用資料庫來儲存影像",
"Use a directory to store images" => "使用資料夾來儲存影像",
"Directory path" => "資料夾路徑",
"Library to use for processing images" => "用於處理影像的程式庫",
"Uploaded image names must match regex" => "上傳影像名稱必須符合正規表示式",
"Uploaded image names cannot match regex" => "上傳影像名稱不得符合正規表示式",
"Images per row" => "每列影像數",
"Thumbnails size X" => "縮圖大小 X",
"Thumbnails size Y" => "縮圖大小 Y",
"Set features" => "設定功能",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "移除系統圖庫中沒有用於 Wiki 頁面, 文章或 blog 佈告的影像",
"All galleries" => "所有的圖庫",
"System Gallery" => "系統圖庫",
"Gallery listing configuration" => "圖庫列表設定",
"Parent" => "父系",
"Image galleries comments settings" => "影像圖庫評論設定",
"General Preferences" => "一般偏好",
"Date and Time Formats" => "日期與時間格式",
"Browser title" => "瀏覽器標題",
"Home Page" => "首頁",
"Custom home" => "自訂首頁",
"Unknown/Other" => "未知/其他",
"Port" => "埠",
"Tikiwiki.org help" => "Tikiwiki.org 說明",
"Contact" => "聯絡",
"Contact user" => "聯絡使用者",
"Count admin pageviews" => "計算管理頁面瀏覽數",
"Temporary directory" => "暫存目錄",
"Long date format" => "長日期格式",
"Short date format" => "短日期格式",
"Long time format" => "長時間格式",
"Short time format" => "短時間格式",
"Date and Time Format Help" => "日期與時間格式說明",
"Change admin password" => "更改管理者密碼",
"New password" => "新密碼",
"Change password" => "更改密碼",
"Use database for translation" => "使用資料庫存放翻譯",
"Edit or ex/import Languages" => "編輯或  匯出/匯入語言",
"Record untranslated" => "記錄未翻譯項目",
"port" => "連接埠",
"Authentication method" => "認證方式",
"Tiki and HTTP Auth" => "Tiki 與 HTTP Auth",
"Users can register" => "允許使用者註冊",
"Use challenge/response authentication" => "使用安全回應認證",
"HTTP port" => "HTTP 埠",
"HTTPS port" => "HTTPS 埠",
"Duration" => "期間",
"Users can change theme" => "允許註冊使用者更改佈景",
"Slideshows theme" => "幻燈片主題",
"Edit CSS" => "編輯 CSS",
"Theme Control" => "佈景主題控制",
"General Layout options" => "一般版面配置選項",
"logged as" => "登入為",
"Left column" => "左欄",
"Right column" => "右欄",
"Maximum number of records in listings" => "列表中版本最大數目",
"Use direct pagination links" => "使用直接頁數連結",
"Left" => "左",
"Right" => "右",
"Display menus as folders" => "用資料夾方式顯示選單",
"Layout per section" => "每區段版面配置",
"Admin layout per section" => "管理每區段的版面配置",
"Users can configure modules" => "允許使用者設定模組",
"Display modules to all groups always" => "所有的群組都顯示模組",
"Last update" => "最近更新",
"Image galleries" => "圖庫",
"Feed for forums" => "Feed for 論壇",
"Search stats" => "搜尋統計",
"random" => "隨機",
"Refresh rate" => "更新率",
"hits" => "點擊數",
"Open external links in new window" => "於新視窗開啟外部連結",
"Dynamic Content System" => "動態內容系統",
"Automonospaced text" => "自動使用固定寬度文字",
"Tables syntax" => "表格語法",
"rows" => "列",
"Required" => "必須",
"Parameters" => "參數",
"dls" => "下傳數",
"Change" => "更改",
"Quota (Mb)" => "配額 (Mb)",
"Use database to store userfiles" => "使用資料庫儲存使用者檔案",
"Use a directory to store userfiles" => "使用目錄儲存使用者檔案",
"Allow viewing HTML mails?" => "允許閱讀 HTML 郵件?",
"Maximum size for each attachment" => "每個附件的最大大小",
"Unlimited" => "未限制",
"Create New" => "建立新的",
"Home page" => "首頁",
"Content templates" => "內容模板",
"Undo" => "回復",
"Footnotes" => "註腳",
"Permission" => "權限",
"Allow HTML" => "允許 HTML",
"Sandbox" => "沙池",
"Dumps" => "傾印",
"Remove a tag" => "移除一個標記",
"Generate dump" => "產生傾印",
"Download last dump" => "下傳最新的傾印",
"Pictures" => "圖片",
"Remove unused pictures" => "移除未使用的圖片",
"Export" => "匯出",
"Export Wiki Pages" => "匯出 Wiki 頁面",
"Discuss pages on forums" => "在論壇上討論頁面",
"Similar" => "相似",
"like pages" => "相似頁面",
"Structures" => "結構",
"Page creators are admin of their pages" => "頁面建立者也是頁面管理者",
"MultiPrint" => "多重列印",
"Enable watches on comments" => "啟動對評論的監視",
"List pages" => "列出頁面",
"Wiki attachments" => "Wiki 附件",
"Restore defaults" => "回復預設值",
"Contact us" => "聯絡我們",
"bytes" => "位元組",
"Statistics" => "統計",
"Weeks" => "數週",
"viewed" => "被瀏覽",
"Add or edit a rule" => "增加或編輯規則",
"Rule title" => "規則名稱",
"Username regex matching" => "使用者名稱符合正規表示式",
"IP regex matching" => "IP 符合正規表示式",
"Banned from sections" => "禁用下列區段",
"Rule activated by dates" => "規則依日期啟用",
"Rule active from" => "規則起始日期",
"Rule active until" => "規則結束日期",
"Custom message to the user" => "給使用者的自訂訊息",
"Rules" => "規則",
"User/IP" => "使用者/IP",
"Sections" => "區段",
"Admin Calendars" => "管理行事曆",
"List of Calendars" => "行事曆列表",
"Loc" => "位置",
"Participants" => "參與者",
"Cat" => "類別",
"Lang" => "語系",
"Prio" => "重要性",
"Custom Locations" => "自訂位置",
"Custom Categories" => "自訂類別",
"Custom Languages" => "自訂語系",
"Custom Priorities" => "自訂重要性",
"Current category" => "目前分類",
"Child categories" => "子類別",
"Edit this category:" => "編輯此類別:",
"Add new category" => "加入新類別",
"Objects in category" => "分類中的物件",
"Add objects to category" => "增加物件到分類中",
"image gal" => "圖庫",
"file gal" => "檔案庫",
"Admin chart items" => "管理排行榜項目",
"Edit Chart" => "編輯排行榜",
"Add or edit an item" => "增加或編輯一個項目",
"Update" => "更新",
"Chart items" => "排行榜項目",
"No items defined yet" => "尚未定義項目",
"Add or edit a chart" => "增加或編輯排行榜",
"Active" => "啟動",
"Users can suggest new items" => "使用者可以建議新選項",
"Auto validate user suggestions" => "自動確認使用者的建議",
"Ranking shows" => "顯示排行榜",
"All items" => "所有項目",
"Top 10 items" => "前 10 項",
"Top 20 items" => "前 20 項",
"Top 40 items" => "前 40 項",
"Top 50 items" => "前 50 項",
"Top 100 items" => "前 100 項",
"Top 250 items" => "前 250 項",
"Voting system" => "投票系統",
"Vote items" => "票選項目",
"Rank 1..5" => "排名 1..5",
"Rank 1..10" => "排名 1..10",
"Ranking frequency" => "排行榜頻率",
"Realtime" => "即時",
"Each 5 minutes" => "每 5 分鐘",
"Daily" => "每日",
"Weekly" => "每週",
"Monthly" => "每月",
"Show Average" => "顯示平均",
"Show Votes" => "顯示票數",
"Use Cookies for unregistered users" => "未註冊使用者使用 cookies",
"Users can vote again after" => "允許再次投票於",
"Anytime" => "隨時",
"Ranks" => "排名",
"No charts defined yet" => "尚未定義排行榜",
"Admin templates" => "管理模板",
"Edit this template:" => "編輯此模板:",
"Create new template" => "產生新模板",
"Use wysiwyg editor" => "使用所見即所得編輯器",
"Use normal editor" => "使用一般編輯器",
"Templates" => "模板",
"Settings" => "設定",
"Admin cookies" => "管理 cookies",
"Create/edit cookies" => "建立/編輯 cookies",
"Upload Cookies from textfile" => "由文字檔上傳 Cookies",
"Upload from disk:" => "由磁碟上傳: ",
"Upload" => "上傳",
"Remove all cookies" => "移除所有cookies",
"Admin drawings" => "管理繪圖",
"Available drawings" => "現存繪圖",
"Ver" => "版本",
"Create/edit dsn" => "建立/編輯 dsn",
"Admin external wikis" => "管理外部 wiki",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (在URL中使用 \$page 來取代 page, 例如: http://www.example.com/tiki-index.php?page=\$page)",
"ExtWiki" => "外部wiki",
"Admin Forums" => "管理論壇",
"List forums" => "列出論壇",
"Edit this Forum:" => "編輯此論壇:",
"Create New Forum" => "建立新論壇",
"There are individual permissions set for this forum" => "這個論壇有獨立權限設定",
"Prevent flooding" => "防止灌水",
"Minimum time between posts" => "發表佈告的最小間隔時間",
"Section" => "區段",
"Create new" => "建立新的",
"Moderator user" => "管理者帳號",
"Moderator group" => "管理者群組",
"Password protected" => "受密碼保護",
"Topics only" => "僅主題",
"All posts" => "全部文章",
"Forum password" => "論壇密碼",
"Send this forums posts to this email" => "寄送此論壇文章到這個電子郵件",
"Prune unreplied messages after" => "刪去未回覆的訊息於",
"Prune old messages after" => "刪去舊訊息於",
"Topic list configuration" => "主題列表設定",
"Add messages from this email to the forum" => "將來自此 email 的訊息增加至論壇",
"POP3 server" => "POP3 伺服器",
"Use topic smileys" => "主題可使用表情符號",
"Show topic summary" => "顯示主題統計",
"User information display" => "顯示使用者資料",
"Online" => "線上",
"Approval type" => "核可方式",
"All posted" => "所有文章",
"Queue anonymous posts" => "保留匿名文章",
"Queue all posts" => "保留所有文章",
"No attachments" => "禁止附件",
"Everybody can attach" => "允許任何人附件",
"Only users with attach permission" => "只允許有附件權限的使用者",
"Moderators and admin can attach" => "只允許板主與管理者",
"Store attachments in:" => "儲存附件於:",
"Database" => "資料庫",
"Max attachment size (bytes)" => "最大附件大小 (bytes)",
"Default ordering for topics" => "預設主題排列順序",
"Date (desc)" => "日期 (降冪)",
"Date (asc)" => "日期 (升冪)",
"Score (desc)" => "分數 (降冪)",
"Replies (desc)" => "回覆 (降冪)",
"Reads (desc)" => "閱讀 (降冪)",
"Topics per page" => "每頁主題數",
"Default ordering for threads" => "預設討論串排列順序",
"Coms" => "coms",
"Age" => "年齡",
"PPD" => "每日發表數",
"Admin Hotwords" => "管理熱門單字",
"Add Hotword" => "加入熱門字眼",
"Word" => "單字",
"Admin HTML pages" => "管理 HTML 頁面",
"Edit this page" => "編輯此頁面",
"View page" => "觀看頁面",
"Edit zone" => "編輯區域",
"Dynamic zones" => "動態區域",
"zone" => "區域",
"content" => "內容",
"Mass update" => "大量更新",
"Create new HTML page" => "建立新 HTML 頁面",
"Edit this HTML page:" => "編輯此 HTML 頁面:",
"Apply template" => "套用模板",
"Dynamic" => "動態",
"Static" => "靜態",
"Last Modif" => "最近修改",
"Admin layout" => "管理版面配置",
"Theme control" => "佈景控制",
"layout options" => "版面配置選項",
"Generate positions by hits" => "由點擊數產生位置",
"List of featured links" => "列出主打連結",
"Position" => "位置",
"Add Featured Link" => "加入主打連結",
"Edit this Featured Link:" => "編輯此主打連結:",
"Create new Featured Link" => "建立新主打連結",
"disables the link" => "關閉此連結",
"Link type" => "連結類型",
"replace current page" => "取代目前頁面",
"framed" => "頁框",
"open new window" => "開啟新視窗",
"Account name" => "帳號名稱",
"POP server" => "POP 伺服器",
"SMTP server" => "SMTP 伺服器",
"SMTP requires authentication" => "SMTP 需要認證",
"Admin Topics" => "管理主題",
"Frequency" => "頻率",
"List menus" => "列出選單",
"Edit this menu" => "編輯此選單",
"Edit menu options" => "編輯選單項目",
"Some useful URLs" => "一些有用的 URL 們",
"option" => "選項",
"Home Blog" => "主 Blog",
"Home Image Gal" => "主影像圖庫",
"Home Image Gallery" => "主影像圖庫",
"Home File Gal" => "主檔案庫",
"Home File Gallery" => "主檔案庫",
"User preferences" => "使用者偏好",
"User prefs" => "使用者偏好",
"List galleries" => "列出檔案庫",
"List image galleries" => "列出圖庫",
"Upload image" => "上傳影像",
"Gallery Rankings" => "圖庫排名",
"Browse a gallery" => "瀏覽圖庫",
"Articles home" => "文章首頁",
"All articles" => "所有文章",
"Submit" => "送出",
"List Blogs" => "列出 Blogs",
"Create blog" => "建立 blog",
"File galleries" => "檔案總覽",
"View a forum" => "進入論壇",
"View a thread" => "檢視討論串",
"View a FAQ" => "觀看 FAQ",
"Take a quiz" => "參加測驗",
"Quiz stats" => "測驗統計",
"Stats for a Quiz" => "測驗統計",
"Preview menu" => "預覽選單",
"Menu options" => "選單項目",
"Edit this Menu:" => "編輯此選單:",
"Create new Menu" => "建立新選單",
"dynamic collapsed" => "動態展開",
"dynamic extended" => "動態延伸",
"fixed" => "固定",
"Options" => "選項",
"Clear Cache" => "清除快取",
"User Modules" => "使用者模組",
"Assigned Modules" => "指定模組",
"Left Modules" => "左方模組",
"Rows" => "列",
"Move to Right Column" => "移至右行",
"Unassign" => "未指定",
"Right Modules" => "右方模組",
"Move to Left Column" => "移至左行",
"Assign new module" => "指定新模組",
"Edit this assigned module:" => "編輯指定的模組:",
"Cache Time" => "快取時間",
"Create new user module" => "建立新的使用者模組",
"Edit this user module:" => "編輯此使用者模組:",
"Objects that can be included" => "允許包含的物件",
"Available polls" => "現有的投票",
"Use Poll" => "使用投票",
"Random image from" => "隨機影像 由",
"Use Gallery" => "使用圖庫",
"Dynamic content blocks" => "動態內容區塊",
"Use Dynamic Content" => "使用動態內容",
"Use RSS Module" => "使用 rss 模組",
"Use Menu" => "使用選單",
"Banner zones" => "大標題區域",
"Use Banner Zone" => "使用大標題區域",
"Data" => "資料",
"Admin newsletter subscriptions" => "管理電子報訂閱",
"List Newsletters" => "列出電子報",
"Admin Newsletters" => "管理電子報",
"Send Newsletters" => "送出電子報",
"Add a subscription newsletters" => "增加訂閱電子報",
"Subscriptions" => "訂閱",
"Subscribed" => "訂閱",
"Admin newsletters" => "管理電子報",
"There are individual permissions set for this newsletter" => "此電子報有獨立的權限設定",
"Editions" => "版本",
"Last Sent" => "上次寄出",
"Add notification" => "增加通知",
"Event" => "事件",
"A user registers" => "有使用者註冊",
"A user submits an article" => "有使用者發送文章",
"List polls" => "列出投票",
"Edit this poll" => "編輯這個投票",
"Preview poll" => "閱覽這個投票",
"Option" => "選項",
"Poll options" => "投票選項",
"Votes" => "投票",
"Admin Polls" => "管理投票",
"Set last poll as current" => "設定最後一個投票為目前的投票",
"Close all polls but last" => "關閉所有投票除了最後一個",
"Activate all polls" => "啟動所有投票",
"active" => "啟動",
"current" => "目前",
"template" => "模板",
"object" => "物件",
"PublishDate" => "發表日期",
"Results" => "結果",
"Admin RSS Modules" => "管理 RSS 模組",
"Content for the feed" => "Feed 的內容",
"user" => "使用者",
"group" => "群組",
"sticky" => "置頂",
"Destroy the structure leaving the wiki pages" => "刪除結構, 保留 wiki 頁面",
"Destroy the structure and remove the pages" => "刪除結構與頁面",
"Export Pages" => "匯出頁面",
"Dump Tree" => "傾印樹系",
"Create new structure" => "建立新的結構",
"Tree" => "樹系",
"Use single spaces to indent structure levels" => "使用單一空格縮排結構層級",
"List surveys" => "列出調查",
"Survey Stats" => "調查結果",
"Edit this Survey" => "編輯這個調查",
"Admin Surveys" => "管理調查",
"Question" => "問題",
"One choice" => "單一選擇",
"Multiple choices" => "多重選擇",
"Short text" => "簡短文字",
"Rate (1..5)" => "評比 (1..5)",
"Rate (1..10)" => "評比 (1..10)",
"Options (if apply)" => "選項 (如果有)",
"Questions" => "問題",
"Admin surveys" => "管理調查",
"List Surveys" => "列出調查",
"Edit this Survey:" => "編輯此調查:",
"There are individual permissions set for this survey" => "此調查有獨立的權限設定",
"Open" => "開放",
"Create a new topic" => "建立新主題",
"Topic Name" => "主題名稱",
"Upload Image" => "上傳影像",
"List of topics" => "主題列表",
"Articles (subs)" => "文章 (回應數)",
"topic image" => "主題影像",
"Deactivate" => "停止",
"List Trackers" => "列出追蹤項目",
"Admin Trackers" => "管理追蹤",
"Edit This Tracker" => "編輯此追蹤",
"View This Tracker's Items" => "瀏覽此追蹤項目",
"Edit tracker field" => "編輯追蹤欄位",
"Is column visible when listing tracker items?" => "當列出追蹤項目時可否看見欄位?",
"Column links to edit/view item?" => "欄位是否連結到 編輯/觀看 項目?",
"Tracker fields" => "追蹤欄位",
"Found" => "找到",
"trackers" => "追蹤系統",
"There are individual permissions set for this tracker" => "這個追蹤項目有獨立的權限設定",
"No individual permissions. Global permissions apply." => "不採用單獨的權限設定,採用全體權限設定",
"Show creation date when listing tracker items?" => "當列出追蹤項目時追蹤建立日期?",
"Show lastModif date when listing tracker items?" => "當列出追蹤項目時顯示上次修改日期?",
"Tracker items allow comments?" => "允許對追蹤項目發表評論?",
"Tracker items allow attachments?" => "允許追蹤項目包含附件?",
"Filesize" => "檔案大小",
"Admin groups" => "管理者群組",
"Admin users" => "管理者",
"Add new group" => "增加新群組",
"Add a New Group" => "增加新群組",
"List of existing groups" => "現存群組列表",
"Includes" => "包含",
"Edit Item" => "編輯項目",
"Add a New User" => "增加使用者",
"Rejected users" => "駁回的使用者",
"Reason" => "原因",
"to groups" => "給群組",
"Overwrite" => "覆蓋",
"Source" => "來源",
"Review" => "評論",
"Group Information" => "群組資訊",
"level" => "層級",
"Create level" => "建立等級",
"all permissions in level" => "本層級所有權限",
"backlinks to" => "反向連結至",
"No backlinks to this page" => "此頁面並無反向連結",
"Browse Gallery" => "瀏覽圖庫",
"Upload From Disk" => "由磁碟上傳",
"Process" => "程序",
"Edit Post" => "編輯文章",
"View Blog" => "觀看 blog",
"Use ...page... to separate pages in a multi-page post" => "使用 ...頁面... 將頁面分隔為多重頁面",
"Upload image for this post" => "上傳影像至此文章",
"Trash" => "垃圾桶",
"Spellcheck" => "拼字檢查 ",
"Save and Exit" => "儲存並離開",
"Clear" => "清除",
"Edit Gallery" => "編輯圖庫",
"Rebuild Thumbnails" => "重建縮圖",
"List Gallery" => "列出圖庫",
"Sort Images by" => "排列影像順序",
"Original Size" => "原始大小",
"rotate right" => "向右旋轉",
"rotate" => "旋轉",
"popup" => "蹦現",
"Return to Gallery" => "返回圖庫",
"Edit Image" => "編輯影像",
"First Image" => "第一張影像",
"Prev Image" => "前一個影像",
"Smaller" => "縮小",
"Bigger" => "放大",
"Popup window" => "蹦現視窗",
"Next Image" => "下一個影像",
"Last Image" => "最末張影像",
"Image Name" => "影像名稱",
"Image Scale" => "影像比率",
"Move image" => "移動影像",
"You can view this image in your browser using" => "你可以觀看此影像在你的瀏覽器中使用",
"Stop Monitoring this Page" => "停止監控此頁面",
"Monitor this Page" => "監視此頁面",
"Group Calendars" => "群組行事曆",
"Organized by" => "組織方式",
"Tentative" => "暫定",
"Confirmed" => "已確認",
"Cancelled" => "取消",
"Edit Calendar Item" => "編輯行事曆項目",
"times" => "次",
"End" => "結束",
"import" => "匯入",
"Previous" => "先前排名",
"to group" => "給群組",
"Change password enforced" => "強制更改密碼",
"Change your password" => "更改你的密碼",
"Old password" => "舊密碼",
"Send a message to us" => "發送訊息給我們",
"Contact us by email" => "使用email與我們聯絡",
"Contacts" => "通訊錄",
"Create/edit contacts" => "建立/編輯 通訊錄",
"First Name" => "名",
"Last Name" => "姓",
"Nickname" => "暱稱",
"Structure" => "結構",
"Tiki Debugger Console" => "Tiki 除錯器控制臺",
"Current URL" => "目前的 URL",
"Command" => "命令",
"exec" => "執行",
"Type <code>help</code> to get list of available commands" => "輸入 <code>help</code> 可取得完整指令列表",
"Add a new site" => "增加新的站臺",
"Site added" => "增加的站臺",
"Directory Administration" => "目錄管理",
"There are" => "有",
"invalid sites" => "不正確的站臺",
"valid sites" => "正確的站臺",
"Users have visited" => "使用者已拜訪",
"sites from the directory" => "個站臺由這個目錄",
"Users have searched" => "使用者已搜尋",
"times from the directory" => "次由這個目錄",
"Related" => "相關",
"Validate" => "確認",
"Admin directory categories" => "管理目錄分類",
"Add a directory category" => "增加目錄類別",
"Edit this directory category" => "編輯目錄類別",
"Children type" => "子型別",
"Most visited sub-categories" => "最常被拜訪的子分類",
"Category description" => "分類描述",
"Random sub-categories" => "隨機子分類",
"Maximum number of children to show" => "最大展示的分類數目",
"Editor group" => "編輯者群組",
"allow" => "允許",
"count" => "次",
"editor" => "編輯",
"relate" => "相關",
"Parent category" => "父分類",
"Add a related category" => "加入相關類別",
"Mutual" => "共同",
"Related categories" => "相關分類",
"Admin sites" => "管理站臺",
"Is valid" => "是正確的",
"New Sites" => "新站臺",
"Cool Sites" => "酷站臺",
"Add a Site" => "增加一個站臺",
"any" => "任何",
"in entire directory" => "在整個目錄中",
"Sort by" => "排序依據",
"name (desc)" => "名稱 (降冪)",
"name (asc)" => "名稱 (升冪)",
"hits (desc)" => "點擊數 (降冪)",
"hits (asc)" => "點擊數 (升冪)",
"creation date (desc)" => "建立日期 (降冪)",
"creation date (asc)" => "建立日期 (升冪)",
"last updated (desc)" => "最後更新 (降冪)",
"last updated (asc)" => "最後更新 (升冪)",
"Added" => "增加",
"Last updated" => "最近修改",
"Total links" => "全部連結",
"Links to validate" => "待確認連結",
"Searches performed" => "搜尋已執行",
"Total links visited" => "全部被拜訪連結",
"Directory ranking" => "目錄排名",
"Search results" => "搜尋結果",
"Validate sites" => "確認站臺",
"Edit article" => "編輯文章",
"List Articles" => "列出文章",
"View Articles" => "顯示文章",
"Author Name" => "作者",
"Article image" => "文章圖片",
"Float text around image" => "文繞圖",
"Heading" => "標題",
"Body" => "內容",
"Publish Date" => "發表日期",
"From:" => "自:",
"Edit or create banners" => "編輯或建立大標題",
"List banners" => "列出大標題",
"URL to link the banner" => "連結此標題的 URL",
"Client" => "用戶",
"Max impressions" => "最大次數",
"Show the banner only between these dates" => "只在這些日期顯示大標題",
"From date" => "開始日期",
"To date" => "結束日期",
"Use dates" => "使用日期",
"Show the banner only in this hours" => "只在這些時間顯示大標題",
"to" => "到",
"Show the banner only on" => "顯示大標題的日子",
"Mon" => "一",
"Tue" => "二",
"Wed" => "三",
"Thu" => "四",
"Fri" => "五",
"Sat" => "六",
"Sun" => "日",
"Select ONE method for the banner" => "選擇大標題的方式",
"Use HTML" => "使用 HTML",
"Use image" => "使用影像",
"Image:" => "影像:",
"Current Image" => "目前影像",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "使用由URL產生的影像 (影像每次都會從URL索取)",
"Use text" => "使用文字",
"Save the Banner" => "儲存大標題",
"Current heading" => "目前標題",
"There are individual permissions set for this blog" => "這個 blog 有獨立的權限設定",
"Number of posts to show" => "顯示的佈告數",
"Allow other user to post in this blog" => "允許其他使用者發表於這個 blog",
"Use titles in blog posts" => "使用 blog 文章標題",
"Allow search" => "允許搜尋",
"Allow comments" => "允許評論",
"Blog heading" => "Blog 標題",
"Edit Style Sheet" => "編輯樣式表",
"Style Sheet" => "樣式表",
"choose a stylesheet" => "選擇樣式表",
"Try" => "測試",
"Wiki Help" => "wiki 說明",
"Colored text" => "著色文字",
"Box content" => "方塊內容",
"External links" => "外部連結",
"Wiki References" => "Wiki 參考",
"JoinCapitalizedWords or use" => "連在一起的大寫字或使用",
"page|description" => "頁面|描述",
"for wiki references" => "表示 wiki 參考",
"SomeName" => "某個名稱",
"prevents referencing" => "表示不參考",
"Lists" => "項目",
"for bullet lists" => "表示無序列表",
"for numbered lists" => "表示有序列表",
"for definiton lists" => "表示定義列表",
"Tables" => "表格",
"Title bar" => "標題列",
"creates the editable drawing foo" => "建立可編輯的暫時影像",
"Multi-page pages" => "多頁式頁面",
"Non parsed sections" => "不分析的區段",
"No description available" => "沒有描述",
"table" => "表格",
"external link" => "外部連結",
"heading1" => "標題1",
"title bar" => "標題列",
"box" => "盒",
"dynamic content" => "動態內容",
"center text" => "置中文字",
"colored text" => "上色文字",
"special chars" => "特殊字元",
"special characters" => "特殊字元",
"Edit successful!" => "編輯成功!",
"The following image was successfully edited" => "下列影像已成功編輯",
"Image Description" => "影像描述",
"Edit and create Languages" => "編輯或建立語言",
"Edit and create languages" => "編輯或建立語言",
"Create Language" => "建立語言",
"Shortname" => "簡稱",
"like" => "如同",
"Longname" => "完整名稱",
"Select the language to edit" => "選擇要編輯的語言",
"Add a translation" => "增加一個翻譯",
"Edit translations" => "編輯一個翻譯",
"Translate recorded" => "已記錄翻譯",
"Translation" => "翻譯",
"reset table" => "重設表格",
"Create New Block" => "建立新區塊",
"Return to block listing" => "返回區塊列表",
"Block description: " => "區塊描述: ",
"You are editing block:" => "你正在編輯區塊:",
"Publishing date" => "發表日期",
"Publishing Date" => "發表日期",
"Edit question options" => "編輯問題選項",
"List Quizzes" => "列出測驗",
"Quiz Stats" => "測驗統計",
"This Quiz Stats" => "這個測驗的統計",
"Edit this Quiz" => "編輯這個測驗",
"Admin Quizzes" => "管理測驗",
"Create/edit options for question" => "建立/編輯 問題的選項",
"Create/edit quizzes" => "增加/編輯 測驗",
"There are individual permissions set for this quiz" => "這個測驗有單獨權限設定",
"Quiz can be repeated" => "可以重覆參加測驗",
"Store quiz results" => "儲存測驗結果",
"Questions per page" => "每頁問題數",
"Quiz is time limited" => "測驗有時間限制",
"Maximum time" => "最大時間",
"Quiz" => "測驗",
"canRepeat" => "允許重覆",
"timeLimit" => "時間限制",
"Edit quiz questions" => "編輯測驗問題",
"Create/edit questions for quiz" => "建立/編輯 測驗的選項",
"maxScore" => "最高分數",
"From Points" => "從分數",
"To Points" => "至分數",
"Answer" => "回答",
"You will remove" => "將會移除",
"and its subpages from the structure, now you have two options:" => "以及結構中的子頁面, 你有兩個選擇:",
"Remove only from structure" => "僅由結構移除",
"Remove from structure and remove page too" => "由結構移除並也移除頁面",
"Page alias" => "頁面別名",
"After page" => "在頁面後",
"Create Page" => "建立頁面",
"Use pre-existing page" => "使用已存在的頁面",
"Submit article" => "傳送文章",
"List Submissions" => "列出submission",
"Edit templates" => "編輯模板",
"Template listing" => "Template列表",
"Available templates" => "現有模板",
"votes" => "票",
"Year:" => "年:",
"Authors:" => "作者:",
"Import page" => "匯入頁面 ",
"export all versions" => "匯出所有版本",
"Upload picture" => "上傳圖片",
"License" => "授權",
"Important" => "重要",
"status" => "狀態",
"lastModif" => "上次修改",
"Dump" => "傾印",
"Admin FAQ" => "管理 FAQ",
"List FAQs" => "列出 FAQs",
"View FAQ" => "觀看 FAQ",
"Edit this FAQ" => "編輯這個 FAQ",
"New Question" => "新問題",
"Use a question from another FAQ" => "使用來自其它 FAQ 的問題",
"FAQ questions" => "FAQ 問題",
"Suggested questions" => "建議問題",
"No suggested questions" => "無建議的問題",
"Upload File" => "上傳檔案",
"You can access the file gallery using the following URL" => "你可以由下列URL進入這個檔案庫",
"Admin forums" => "管理論壇",
"Edit queued message" => "編輯佇列中訊息",
"make this a thread of" => "設為討論串",
"None, this is a thread message" => "不, 這不是討論串",
"summary" => "總結",
"normal" => "正常",
"announce" => "公佈",
"hot" => "熱門",
"no feeling" => "沒感覺",
"frown" => "皺眉",
"exclaim" => "驚叫",
"idea" => "點子",
"mad" => "瘋狂",
"neutral" => "中立",
"question" => "問題",
"sad" => "難過",
"happy" => "快樂",
"wink" => "眨眼",
"Save and Approve" => "儲存並核可",
"convert to topic" => "轉換至主題",
"List of messages" => "訊息列表",
"New Topic" => "新主題",
"no summary" => "無總結",
"No messages queued yet" => "尚無訊息佇列",
"Last Post" => "最近發表佈告",
"Reported by" => "回報自",
"Accept" => "接受",
"Activity completed" => "活動完畢",
"Admin process activities" => "管理程序活動",
"Add or edit an activity" => "增加或編輯活動",
"activity" => "活動力",
"split" => "分割",
"join" => "加入",
"standalone" => "獨立",
"interactive" => "互動式",
"auto routed" => "自動建立路徑",
"Hours" => "小時",
"Add transitions" => "建立變遷",
"Add transition from:" => "建立變遷自:",
"Add transition to:" => "建立變遷至:",
"No roles associated to this activity" => "沒有與此活動相關的角色",
"Add Role" => "增加角色",
"Add New" => "新增加",
"Process activities" => "程序的活動",
"Routing" => "建立路徑",
"Interactive" => "互動式",
"Automatic" => "自動",
"Auto routed" => "自動建立路徑",
"Manual" => "人動",
"route" => "路徑",
"(no roles)" => "(無角色)",
"No activities defined yet" => "尚未定義活動",
"Process Transitions" => "程序的變遷",
"List of transitions" => "變遷列表",
"Origin" => "原始",
"No transitions defined yet" => "尚未定義變遷",
"Add a transition" => "增加變遷",
"Active Process" => "active process",
"Invalid Process" => "invalid process",
"Valid Process" => "valid process",
"New Minor" => "new minor",
"New Major" => "new major",
"Admin instance" => "管理實體",
"Instance" => "實體",
"Workitems" => "工作項目",
"completed" => "已完成",
"Aborted" => "aborted",
"Started" => "開始",
"Admin Processes" => "admin processes",
"Admin Activities" => "admin activities",
"Admin Roles" => "admin roles",
"Edit this Process" => "edit this process",
"Proc" => "proc",
"Monitor" => "監控",
"Completed" => "完成",
"Exceptions" => "exceptions",
"Send Instance" => "send instance",
"User Activities" => "使用者行動",
"Galleries" => "圖庫",
"Create New Gallery" => "建立新圖庫",
"Create a gallery" => "建立圖庫",
"Edit this gallery:" => "編輯此圖庫:",
"There are individual permissions set for this gallery" => "這個圖庫有獨立的權限設定",
"Available scales" => "現有的比率",
"No scales available" => "沒有可用的比率",
"Other users can upload images to this gallery" => "允許其它使用者上傳影像至此圖庫",
"You can access the gallery using the following URL" => "你可以經由下列的URL進入此圖庫",
"Available Galleries" => "目前所有的圖庫",
"Imgs" => "影像",
"Im- Export languages" => "匯入-匯出語言",
"Select the language to Import" => "選擇要匯入的語言",
"Select the language to Export" => "選擇要匯出的語言",
"Overwrite existing pages if the name is the same" => "當名稱一樣時覆寫已存在的頁面",
"Previously remove existing page versions" => "事先移除已存在的頁面版本",
"excerpt" => "引用",
"Result" => "結果",
"Locked" => "鎖定",
"Configure General Settings" => "一般設定",
"Last Changes" => "最新變動",
"Search by Date" => "以日期搜尋",
"LastChanges" => "最近變動",
"Rollback" => "回復",
"Pages like" => "相似頁面",
"No pages found" => "找不到頁面",
"Edit New Article" => "編輯新文章",
"View Submissions" => "檢視意見",
"AuthorName" => "作者名稱",
"Create banner" => "建立大標題",
"Method" => "方法",
"Use Dates?" => "使用日期?",
"Max Impressions" => "最大次數",
"Impressions" => "次數",
"Clicks" => "點擊",
"Create New Blog" => "建立新 blog",
"Use cache for external pages" => "快取外部頁面",
"Dynamic content system" => "動態內容系統",
"Available content blocks" => "現有的內容區塊",
"Current ver" => "目前版本",
"Next ver" => "下一個版本",
"Program" => "方案",
"Edit this FAQ:" => "編輯此 FAQ:",
"Create New FAQ:" => "建立新 FAQ:",
"Users can suggest questions" => "允許使用者建議問題",
"Available FAQs" => "現有的 FAQs",
"Create a File Gallery" => "建立檔案庫",
"Gallery Images" => "圖庫影像",
"All games are from" => "所有遊戲來自",
"visit the site for more games and fun" => "拜訪這個網站以取得更多遊戲",
"Upload a game" => "上傳一個遊戲",
"Upload a new game" => "上傳一個新遊戲",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "縮圖 (如果game的名稱為foo.swf 則縮圖必須命名為 foo.swf.gif 或 foo.swf.png 或 foo.swf.jpg)",
"Edit game" => "編輯遊戲",
"Played" => "已玩",
"If you can't see the game then you need a flash plugin for your browser" => "如果你無法看到遊戲那麼你必須在你的瀏覽器中加入 flash 外掛模組",
"Edit Blog" => "編輯 Blog",
"Blog Title" => "Blog 標題",
"Edit New Submission" => "建立新的意見",
"Survey stats" => "調查結果",
"Last mod" => "最近修改",
"Last author" => "最近作者",
"Last version" => "最近版本",
"unlocked" => "解鎖",
"Open client window" => "開啟客戶端視窗",
"Generate HTML" => "產生 HTML",
"Transcripts" => "紀錄",
"Online operators" => "線上服務員",
"Operator" => "服務員",
"Accepted requests" => "已接受要求",
"since" => "自",
"transcripts" => "紀錄",
"Offline operators" => "離線服務員",
"Add an operator to the system" => "增加系統服務員",
"Operators must be tiki users" => "服務員必須是 tiki 使用者",
"Set as Operator" => "設為服務員",
"Chat started" => "對談已開始",
"Operator:" => "服務員:",
"Live support:User window" => "線上支援:使用者視窗",
"Request live support" => "要求線上支援",
"Request support" => "要求支援",
"Open a support ticket instead" => "改為開啟要求標籤",
"Your request is being processed" => "你的要求正在處理",
"cancel request and exit" => "取消要求並離開",
"cancel request and leave a message" => "取消要求並留言",
"Live support:Console" => "線上支援:操作臺",
"be online" => "正在線上",
"be offline" => "正離線中",
"Support requests" => "支援要求",
"Requested" => "已要求",
"Join" => "加入",
"Support chat transcripts" => "支援交談紀錄",
"started" => "已開始",
"reason" => "原因",
"msgs" => "訊息",
"Transcript" => "紀錄",
"Prefs" => "個人偏好",
"Remove old events" => "移除舊事件",
"duration" => "期間",
"Mini Calendar: Preferences" => "迷你月曆: 個人偏好",
"Calendar Interval in daily view" => "每日檢視中的行事曆週期",
"Start hour for days" => "每天開始時間",
"End hour for days" => "每天結束時間",
"Reminders" => "提醒",
"no reminders" => "沒有提醒",
"Or enter path or URL" => "或 輸入路徑 或 URL",
"Add Topic" => "增加主題",
"User Pages" => "使用者頁面",
"User Galleries" => "使用者列表",
"Unread Messages" => "未讀訊息",
"Tasks" => "任務",
"User Blogs" => "使用者 Blogs",
"MyTiki" => "我的Tiki",
"Notepad" => "筆記本",
"MyFiles" => "我的檔案",
"My Watches" => "我的監視",
"Assigned items" => "指定項目",
"Sent editions" => "送出版本",
"The newsletter was sent to {\$sent} email addresses" => "電子報已發送至 {\$sent} email 地址",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "感謝你的訂閱. 你會收到一封信件以確認你的訂閱. 在訂閱確認前不會收到電子報.",
"Your email address was removed from the list of subscriptors." => "你的email地址已從訂閱者名單中移除",
"Subscription confirmed!" => "訂閱已確認!",
"Subscribe to Newsletter" => "訂閱電子報",
"Subscribe to this Newsletter" => "訂閱",
"Select news group" => "選擇 news 討論群",
"Back to servers" => "返回伺服器列表",
"Msgs" => "訊息",
"Back to groups" => "回到討論群",
"Save position" => "儲存位置",
"Reading article from" => "閱讀文章由",
"Back to list of articles" => "返回文章列表",
"Newsgroup" => "討論群",
"Configure news servers" => "設定 news 伺服器",
"Select a news server to browse" => "選擇要瀏覽的 news 伺服器",
"server" => "伺服器",
"News server" => "News 伺服器",
"Notes" => "備忘錄",
"Write a note" => "寫個備忘錄",
"quota" => "配額",
"No notes yet" => "尚無記事",
"Merge selected notes into" => "合併選擇的記事至",
"Reading note:" => "閱讀備忘錄:",
"List notes" => "列出備忘錄",
"Write note" => "寫備忘錄",
"Wiki Create" => "wiki 建立",
"Wiki Overwrite" => "wiki 覆寫",
"Assign permissions to " => "指定權限給",
"Current permissions for this object" => "此物件目前的權限",
"Assign permissions to this object" => "指定此物件的權限",
"Published" => "發表",
"Orphan Pages" => "孤兒頁面",
"Browser not supported" => "瀏覽器不支援",
"Rename" => "更名",
"Slides" => "幻燈片",
"Discuss" => "討論",
"Attach File" => "附加檔案",
"1 File Attached" => "1 個附加檔案",
"Pick your avatar" => "選擇你的頭像",
"User Preferences" => "使用者偏好",
"Your current avatar" => "你目前的頭像",
"reset" => "重新設定",
"Pick avatar from the library" => "從內建頭像中選取",
"Pick user Avatar" => "選擇使用者的頭像",
"Hide all" => "隱藏全部",
"Show all" => "顯示全部",
"Avatar Image" => "個人頭像",
"Upload your own avatar" => "上傳你自己的頭像",
"Average" => "平均",
"Vote poll" => "投票",
"Other Polls" => "其他投票",
"Topic image" => "主題影像",
"Viewing blog post" => "觀看 blog 佈告",
"Return to blog" => "返回 blog",
"The original document is available at" => "原始文件位於",
"Print multiple pages" => "列印多重頁面",
"Add Page" => "增加頁面",
"Quiz result stats" => "測驗結果統計",
"Time" => "時間",
"User answers" => "使用者答案",
"Stats for quizzes" => "測驗統計",
"taken" => "參加過",
"Av score" => "平均分數",
"Av time" => "平均時間",
"Clear Stats" => "清除統計",
"Stats for this quiz Questions " => "此測驗問題統計資料 ",
"Top 10" => "前 10",
"Top 20" => "前 20",
"Top 50" => "前 50",
"Top 100" => "前 100",
"Received articles" => "已接收文章",
"Edit received article" => "編輯接收的文章",
"Use Image" => "使用影像",
"Image x size" => "影像 x 大小",
"Image y size" => "影像 y 大小",
"Image name" => "影像名稱",
"Accept Article" => "接受文章",
"Site" => "網站",
"Referer stats" => "參照頁面統計",
"The following site was added and validation by admin may be needed before appearing on the lists" => "已加入以下站臺, 需等待管理者確認後才會顯示在列表上",
"Send me my Password" => "寄給我密碼",
"Remove page" => "移除頁面",
"You are about to remove the page" => "你即將刪除此頁面",
"permanently" => "永久地",
"Remove all versions of this page" => "移除這個頁面的所有版本",
"Rollback page" => "回復頁面",
"Searched" => "搜尋",
"Search in" => "搜尋於",
"No pages matched the search criteria" => "找不到符合條件的頁面",
"Send blog post" => "發送 blog 佈告",
"A link to this post was sent to the following addresses:" => "已經發送一個至此佈告的連結至下列位址:",
"Send post to this addresses" => "發送佈告至此位址",
"List of email addresses separated by commas" => "email 地址列表, 由逗點分隔",
"This newsletter will be sent to {\$subscribers} email addresses." => "電子報已發送至 {\$subscribers} email 地址.",
"Prepare a newsletter to be sent" => "準備將要送出的電子報",
"remove" => "移除",
"Send objects" => "發送物件",
"Transmission results" => "傳送結果",
"Send Wiki Pages" => "發送 Wiki 頁面",
"Send Articles" => "發送文章",
"Add Article" => "加入文章",
"Send objects to this site" => "發送物件到這個網站",
"Post or edit a message" => "發表或編輯訊息",
"cool" => "酷",
"Site Stats" => "網站統計",
"Total pageviews" => "全部頁面瀏覽數",
"Average pageviews per day" => "每天平均頁面瀏覽數",
"Best day" => "最好的一天",
"Worst day" => "最差的一天",
"Wiki Stats" => "Wiki 統計",
"Size of Wiki Pages" => "Wiki 頁面大小",
"Average page length" => "平均頁面長度",
"Average versions per page" => "平均每頁版本數",
"Visits to wiki pages" => "wiki 頁面拜訪數",
"Orphan pages" => "孤立頁面",
"Average links per page" => "平均每頁連結數",
"Image galleries Stats" => "影像圖庫統計",
"Average images per gallery" => "平均圖庫影像數",
"Total size of images" => "所有影像大小",
"Average image size" => "平均影像大小",
"Visits to image galleries" => "影像庫拜訪數",
"File galleries Stats" => "檔案庫統計",
"Average files per gallery" => "檔案庫平均檔案數",
"Total size of files" => "全部檔案的總大小",
"Average file size" => "平均檔案大小",
"Visits to file galleries" => "檔案庫拜訪數",
"CMS Stats" => "CMS 統計",
"Total reads" => "全部閱讀數",
"Average reads per article" => "文章平均閱讀數",
"Total articles size" => "全部文章大小",
"Average article size" => "平均文章大小",
"Forum Stats" => "論壇統計",
"Total topics" => "全部主題",
"Average topics per forums" => "論壇平均主題數",
"Visits to forums" => "論壇拜訪數",
"Blog Stats" => "Blog 統計",
"Total posts" => "總發表佈告數",
"Average posts per weblog" => "weblog 平均發表數",
"Total size of blog posts" => "blog 佈告的總大小",
"Average posts size" => "平均佈告大小",
"Visits to weblogs" => "weblogs 拜訪數",
"Poll Stats" => "投票統計",
"Total votes" => "總票數",
"Average votes per poll" => "投票平均票數",
"Total questions" => "全部問題數",
"Average questions per FAQ" => "FAQ 平均問題數",
"User Stats" => "使用者統計",
"User bookmarks" => "使用者書籤",
"Average bookmarks per user" => "使用者平均書籤數",
"Average questions per quiz" => "每測驗平均問題數",
"Quizzes taken" => "已參加過的測驗",
"Average quiz score" => "平均測驗分數",
"Average time per quiz" => "每測驗平均回答時間",
"Usage chart" => "使用排行榜",
"Usage chart image" => "使用紀錄圖表",
"Stats for surveys" => "調查結果",
"Last taken" => "最近參加的調查",
"Time Left" => "剩餘時間",
"Send Answers" => "送出答案",
"Your email was sent" => "email 已寄出",
"Theme is selected as follows" => "佈景主題選擇如下",
"If a theme is assigned to the individual object that theme is used." => "如果指定單獨物件的佈景主題,則使用該主題.",
"If not then if a theme is assigned to the object's category that theme is used" => "如不成立, 那麼如果指定物件分類的佈景主題, 則使用該主題",
"If not then a theme for the section is used" => "如不成立, 則使用區塊的佈景主題",
"If none of the above was selected the user theme is used" => "如果以上都沒有設定, 則採用使用者的佈景主題",
"Finally if the user didn't select a theme the default theme is used" => "最後, 如果使用者沒有設定佈景主題, 則使用預設的佈景主題",
"Control by Sections" => "由區塊控制",
"Assign themes to categories" => "指定分類的佈景主題",
"Assigned categories" => "已指定的分類",
"Theme Control Center: Objects" => "佈景主題控制臺: 物件",
"Control by Categories" => "由分類控制",
"Assign themes to objects" => "指定物件的佈景主題",
"Assigned objects" => "指定物件",
"Assign themes to sections" => "指定區塊的佈景主題",
"Assigned sections" => "指定區塊",
"The following file was successfully uploaded" => "下列的檔案已成功上傳",
"You can download this file using" => "你可以下傳這個檔案使用",
"You have to create a gallery first!" => "你必須先建立圖庫!",
"Batch Upload Results" => "批次上傳結果",
"Upload successful!" => "上傳成功!",
"The following image was successfully uploaded" => "下列影像已成功上傳",
"Image ID thumb" => "影像 ID 縮圖",
"Now enter the image URL" => "輸入影像的 URL",
"or upload a local image from your disk" => "或從你的磁碟上傳影像",
"Batch Upload" => "批次上傳",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "縮圖 (選擇性, 覆蓋自動縮圖產生)",
"User assigned modules" => "使用者指定模組",
"Assign module" => "指定模組",
"Column" => "行",
"Current folder" => "目標資料夾",
"Folders" => "資料夾",
"Folder in" => "資料夾於",
"Remove Folder" => "移除資料夾",
"Refresh Cache" => "重新整理快取",
"Admin folders and bookmarks" => "管理資料夾與書籤",
"Send me a message" => "發送訊息給我",
"Your personal Wiki Page" => "你的個人 Wiki 頁面",
"Is email public? (uses scrambling to prevent spam)" => "公開 email? (使用擾亂法以避免spam)",
"Percentage completed" => "完成百分比",
"No tasks entered" => "尚未輸入工作",
"Watches" => "監視",
"May need to refresh twice to see changes" => "可能需要更新兩次才看得到變動",
"Add top level bookmarks to menu" => "增加最高一層的書籤至選單",
"replace window" => "取代視窗",
"This page is being edited by" => "此頁面被編輯中:",
"Proceed at your own peril" => "請自己小心",
"Banner stats" => "大標題統計",
"Create new banner" => "建立新標題",
"Banner Information" => "大標題資訊",
"Click ratio" => "點擊率",
"Weekdays" => "工作日",
"mon" => "一",
"tue" => "二",
"wed" => "三",
"thu" => "四",
"fri" => "五",
"sat" => "六",
"sun" => "日",
"Banner raw data" => "大標題原始資料",
"Cached" => "已快取",
"This is a cached version of the page." => "這是本頁面的快取版本",
"Click here to view the Google cache of the page instead." => "點擊這裡瀏覽 Google 頁面存檔.",
"Edit Items" => "編輯項目",
"List Charts" => "列出排行榜",
"Last Chart" => "最末張排行榜",
"Previous Chart" => "前一排行榜",
"Chart created" => "排行榜已建立",
"Next Chart" => "下一張排行榜",
"Pre" => "pre",
"Permanency" => "耐久度",
"chg" => "異動",
"Avg" => "平均",
"info/vote" => "資訊/投票",
"Next chart will be generated on" => "下一排行榜將產生於",
"View or vote items not listed in the chart" => "檢視或投票項目不列在排行榜中",
"Select something to vote on" => "選擇要投的項目",
"Item information" => "項目資訊",
"Dif" => "差異",
"Best Position" => "最佳排名",
"Vote this item" => "票選此項目",
"Highest" => "最高",
"Forum List" => "論壇列表",
"Edit Forum" => "編輯論壇",
"Summary" => "總計",
"Moderator Actions" => "板主命令",
"Move Selected Topics" => "移動選擇的主題",
"Unlock Selected Topics" => "解鎖選擇的主題",
"Lock Selected Topics" => "鎖定選擇的主題",
"Delete Selected Topics" => "刪除選擇的主題",
"Merge" => "合併",
"Merge Selected Topics" => "合併選擇的主題",
"Reported Messages:" => "回報的訊息:",
"Queued Messages:" => "佇列中訊息:",
"Merge into topic" => "合併至主題",
"Announce" => "公佈",
"Hot" => "熱門",
"No topics yet" => "尚無主題",
"Jump to forum" => "跳躍至論壇",
"Last hour" => "前 1 小時",
"Last 24 hours" => "前 24 小時",
"Last 48 hours" => "前 48 小時",
"prev topic" => "前一主題",
"next topic" => "後一主題",
"Show posts" => "顯示發表數",
"Insert New Item" => "插入新項目",
"Tracker Items" => "追蹤項目",
"Insert new item" => "插入新項目",
"View Item" => "觀看項目",
"Add a Comment" => "增加一個評論",
"Clip" => "迴紋針",
"Back To Mailbox" => "返回郵件夾",
"Full Headers" => "完整標頭",
"Normal Headers" => "一般標頭",
"Reply To All" => "全部回覆",
"Forward" => "轉寄",
"Select from address book" => "由通訊錄中選擇",
"Use HTML mail" => "使用 HTML 郵件",
"The following addresses are not in your address book" => "下列地址不在你的通訊錄中",
"Add Contacts" => "增加到通訊錄",
"Attachment 1" => "附件 1",
"Attachment 2" => "附件 2",
"Attachment 3" => "附件 3",
"Address book" => "通訊錄",
"Save Minor Edit" => "次要",
"Administration" => "系統管理",
"General preferences and settings" => "一般偏好設定",
"Wiki settings" => "Wiki 設定",
"Poll comments settings" => "投票評論設定",
"Forums settings" => "論壇設定",
"No chart indicated" => "未指定排行榜",
"Upload failed" => "上傳失敗",
"Tag already exists" => "標籤已經存在",
"Tag not found" => "找不到標籤",
"No menu indicated" => "未指定選單",
"No newsletter indicated" => "未指定電子報",
"No poll indicated" => "未指定投票",
"Permission denied you cannot view this page" => "權限不足, 你無法觀看此頁面",
"Permission denied you cannot edit this page" => "權限不足, 你無法編輯此頁面",
"page not added (Exists)" => "未加入頁面 (已存在)",
"No survey indicated" => "未指定調查",
"No tracker indicated" => "未指定追蹤",
"Group already exists" => "群組已經存在",
"User doesn't exist" => "使用者不存在",
"No records were found. Check the file please!" => "找不到紀錄, 請檢查檔案!",
"User login is required" => "需要使用者登入",
"Password is required" => "需要密碼",
"Email is required" => "需要 email",
"User is duplicated" => "使用者重複",
"password" => "密碼",
"Unknown group" => "不明群組",
"Group doesn't exist" => "群組不存在",
"Permission denied you cannot view backlinks for this page" => "權限不足, 你無法觀看此頁面的反向連結",
"The page cannot be found" => "找不到頁面",
"You can't post in any blog maybe you have to create a blog first" => "你無法在任何 blog 中發表佈告, 請先建立一個 blog",
"Permission denied you cannot post" => "權限不足, 你無法發表佈告",
"Permission denied you cannot edit this post" => "權限不足, 你無法編輯此佈告",
"Top visited blogs" => "最熱門 blog",
"Last posts" => "最新發表",
"Top active blogs" => "最活躍 blog",
"Permission denied you cannot access this gallery" => "你沒有存取這個圖庫的權限",
"No gallery indicated" => "未指定圖庫",
"Permission denied you can not view this section" => "權限不足, 你無法瀏覽這個區塊",
"Permission denied you cannot remove images from this gallery" => "你沒有刪除本圖庫中影像的權限",
"Permission denied you cannot rebuild thumbnails in this gallery" => "權限不足, 你無法建立此圖庫的縮圖",
"Permission denied you cannot rotate images in this gallery" => "權限不足, 你無法旋轉此圖庫中的影像",
"No image indicated" => "未指定影像",
"Permission denied you cannot move images from this gallery" => "你沒有移動本圖庫中檔案的權限",
"Permission denied you cannot view the calendar" => "權限不足, 你無法使用行事曆",
"event without name" => "無名事件",
"You can not use the same password again" => "請勿再使用相同的密碼",
"Top authors" => "最多產作者",
"This feature has been disabled" => "這個功能已被關閉",
"Must enter a name to add a site" => "增加站臺時必須輸入名稱",
"Must enter a url to add a site" => "增加站臺時必須輸入 URL",
"URL already added to the directory. Duplicate site?" => "已經加入過此URL了. 是否為重複站臺?",
"Must select a category" => "請選擇一個分類",
"No site indicated" => "未指定站臺",
"Article not found" => "找不到文章",
"Permission denied you cannot edit this article" => "你沒有權限編輯此文章",
"You do not have permissions to edit banners" => "權限不足, 你無法編輯blog",
"Banner not found" => "找不到大標題",
"You do not have permission to edit this banner" => "權限不足, 你無法編輯此blog",
"Permission denied you cannot create or edit blogs" => "權限不足, 你無法建立或編輯blog",
"Permission denied you cannot edit this blog" => "權限不足, 你無法編輯此 blog",
"You do not have permission to write the style sheet" => "你沒有權限寫入樣式表",
"Invalid request to edit an image" => "不正確的編輯影像請求",
"Permission denied you cannot edit images" => "權限不足, 你無法編輯影像",
"Permission denied you can edit images but not in this gallery" => "權限不足, 你可以編輯影像, 但不得編輯此圖庫",
"Failed to edit the image" => "編輯影像失敗",
"Permission denied to use this feature" => "權限不足, 無法使用本功能",
"Shortname must be 2 Characters" => "縮寫必須是兩個字元",
"You must provide a longname" => "必須提供完整名稱",
"Language created" => "語言已建立",
"No content id indicated" => "未指定內容編號",
"No question indicated" => "未指定問題",
"No quiz indicated" => "未指定測驗",
"No structure indicated" => "未指定結構",
"Permission denied you cannot send submissions" => "權限不足, 你無法送出意見",
"Permission denied you cannot edit submissions" => "權限不足, 你無法編輯意見",
"You have to create a topic first" => "你必須先建立主題",
"You do not have permission to do that" => "你沒有權限",
"You do not have permission to read the template" => "權限不足, 你無法讀取模板",
"page imported" => "匯入的頁面",
"created from import" => "從匯入建立",
"The SandBox is disabled" => "沙池功能已關閉",
"Cannot edit page because it is locked" => "無法編輯頁面, 它正被鎖定中",
"Permission denied you cannot edit this file" => "權限不足, 你無法編輯此檔案",
"Permission denied you cannot remove files from this gallery" => "權限不足, 你無法移除此檔案庫中的檔案",
"Top visited file galleries" => "最常被瀏覽圖庫",
"Most downloaded files" => "最多下傳檔案",
"Last files" => "最新檔案",
"No forum indicated" => "未指定論壇",
"Forum posts" => "論壇文章數",
"No process indicated" => "未指定程序",
"No user indicated" => "未指定使用者",
"No item indicated" => "未指定項目",
"first image" => "第一張影像",
"last image" => "最末張影像",
"Permission denied you cannot create galleries and so you cant edit them" => "權限不足, 你無法建立和編輯檔案庫",
"Permission denied you cannot edit this gallery" => "權限不足, 你無法編輯此檔案庫",
"Permission denied you cannot remove this gallery" => "權限不足, 你無法移除此檔案庫",
"Top images" => "最熱門影像",
"Last images" => "最新影像",
"overwriting old page" => "覆寫舊頁面",
"page created" => "頁面已建立",
"No name indicated for wiki page" => "尚未指定 wiki 頁面名稱",
"Permission denied you cannot view pages like this page" => "權限不足, 你無法觀看此頁面的相似頁面",
"Permission denied you cannot remove articles" => "你沒有權限刪除文章",
"Permission denied you cannot remove banners" => "權限不足, 你無法移除大標題",
"Permission denied you cannot remove this blog" => "權限不足, 你無法移除此 blog",
"Permission denied you can upload files but not to this file gallery" => "權限不足, 你可以上傳檔案, 但不能上傳至此檔案庫",
"Permission denied you can't upload files so you can't edit them" => "權限不足, 你無法上傳檔案也無法編輯",
"The thumbnail name must be" => "縮圖的名稱必須是",
"You cannot admin blogs" => "你無法管理 blogs",
"Permission denied you cannot remove submissions" => "權限不足, 你無法移除意見",
"Permission denied you cannot approve submissions" => "權限不足, 你無法審核意見",
"edit" => "編輯",
"Must be logged to use this feature" => "必須登入才能使用此功能",
"Welcome at Hawiki" => "歡迎來到 Hawiki",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "本 Tikiwiki 站臺是為了各種移動裝置設計, 例如 WAP 手機, PDA, i-mode 裝置等等.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "你可以使用移動裝置連接至以下的 URL 來瀏覽本站:",
"About" => "關於",
"You must log in to use this feature" => "你必須登入才能使用此功能",
"You do not have permission to view other users data" => "你沒有權限觀看其他使用者的資料",
"You must be logged in to subscribe to newsletters" => "你必須登入才能訂閱電子報",
"No server indicated" => "未指定伺服器",
"Cannot connect to" => "無法連接至 ",
"Missing information to read news (server,port,username,password,group) required" => "缺少讀取news所需資訊(伺服器,連接埠,使用者名稱,密碼,群組)",
"Cannot get messages" => "無法取得訊息",
"No note indicated" => "未指定備忘錄",
"merged note:" => "合併記事:",
"File is too big" => "檔案過大",
"created from notepad" => "由記事本建立",
"Page already exists" => "頁面已存在",
"Not enough information to display this page" => "沒有足夠資訊顯示此頁面",
"Permission denied you cannot browse this page history" => "你沒有觀看本頁歷程的權限",
"No article indicated" => "未指定文章",
"Article is not published yet" => "文章尚未被發表",
"No post indicated" => "未指定佈告",
"Blog not found" => "找不到 Blog",
"No pages indicated" => "未指定頁面",
"No result indicated" => "未指定結果",
"The passwords don't match" => "密碼錯誤",
"Invalid or unknown username" => "使用者名稱錯誤",
"to the registered email address for" => "至註冊的 email 地址:",
"Permission denied you cannot remove versions from this page" => "你沒有移除本頁版本的權限",
"Cannot rename page maybe new page already exists" => "無法更名頁面, 也許已存在同名頁面",
"Permission denied you cannot rollback this page" => "你無法回復這個頁面",
"Post recommendation at" => "發表建議於",
"successfully sent" => "成功寄送",
"not sent" => "未寄送",
"Page must be defined inside a structure to use this feature" => "頁面必須定義在結構中才能使用此功能",
"You cannot take this quiz twice" => "你不能重複參加這個測驗",
"You cannot take this survey twice" => "你不能重複參加這個調查",
"Please create a category first" => "請先建立一個類別",
"No permission to upload zipped file packages" => "沒有權限上傳 zip 壓縮的檔案包",
"Error processing zipped image package" => "處理 zip 壓縮的影像包時發生錯誤",
"No permission to upload zipped image packages" => "沒有權限上傳 zip 壓縮的影像包",
"Permission denied you cannot upload images" => "你沒有上傳影像的權限",
"Permission denied you can upload images but not to this gallery" => "你無法在此圖庫中上傳影像",
"Cannot get image from URL" => "無法由URL取得影像",
"No url indicated" => "未指定url",
"Unknown user" => "不明使用者",
"You are not logged in and no user indicated" => "你尚未登入及指定使用者",
"no" => "否",
"Cannot upload this file not enough quota" => "無法上傳檔案, 磁碟配額不足",
"No banner indicated" => "未指定大標題",
"No blog indicated" => "未指定 blog",
"Permission denied you cannot remove the post" => "權限不足, 你無法移除此佈告",
"No cache information available" => "無快取資訊",
"No faq indicated" => "未指定faq",
"No thread indicated" => "未指定討論串",
"No subject" => "無標題",
"Top pages" => "最熱門頁面",
"Last pages" => "最新頁面",
"###end###"=>"###end###");
?>
