<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only translates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release


// ### Note for translators about translation of text ending with punctuation
// ###
// ### The current list of concerned punctuation can be found in 'lib/init/tra.php'
// ### On 2009-03-02, it is: (':', '!', ';', '.', ',', '?')
// ### For clarity, we explain here only for colons: ':' but it is the same for the rest
// ###
// ### Short version: it is not a problem that string "Login:" has no translation. Only "Login" needs to be translated.
// ###
// ### Technical justification:
// ### If a string ending with colon needs translating (like "{tr}Login:{/tr}")
// ### then TikiWiki tries to translate 'Login' and ':' separately.
// ### This allows to have only one translation for "{tr}Login{/tr}" and "{tr}Login:{/tr}"
// ### and it still allows to translate ":" as "&nbsp;:" for languages that
// ### need it (like french)

$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"Security check failed!" => "Sigurnosna provera nije uspela!",
"You are not permitted to edit someone else\\'s post!" => "Nije vam dozvoljeno da menjate tuđe poruke!",
"Only an admin can remove a thread." => "Samo administrator može da ukloni temu.",
"note: those parameters are exclusive" => "napomena: sledeću parametri su ekskluzivni",
"Reply to parent comment" => "Odgovori na komentare roditelja",
"compose message tpl" => "Sastavi šablon poruke",
"messages tpl" => "šabloni poruka",
"Reduce area width" => "Smanji širinu prostora",
"Enlarge area width" => "Povećaj širinu prostora",
"Email Encoding" => "Kodna strana za e-mail",
"Meta Tag Settings" => "Podešavanja Meta taga",
"Strict allows page names with only letters, numbers, underscore, dash, period and semicolon (dash, period and semicolon not allowed at the beginning and the end)." => "Striktno dozvoljava imena samo sa slovima, brojevima donjom crtom, crtom, tačkom i dvotačkom (crta, tačka i dvotačka nisu dozvoljeni na početku ili kraju).",
"Full adds accented characters." => "Potpuno dodaje akcentovane karaktere.",
"Complete allows <em>anything at all</em>.  I (<a\n    href=\"http://tikiwiki.org/tiki-index.php?page=UserPagerlpowell\">rlpowell</a>)\n    cannot guarantee that it is bug-free or secure." => "Kompletno dozvoljava <em>bilo šta</em> u njima.  Ja (<a\n    href=\"http://tikiwiki.org/tiki-index.php?page=UserPagerlpowell\">rlpowell</a>)\n    ne mogu da garantujem da je to sigurno ili bez bagova.",
"Note that this does not affect WikiWord recognition, only page names surrounded by (( and ))." => "Primetite da ovo ne utiče na WikiWord prepoznavanje, samo na nazive okružene sa (( i )).",
"admin charts tpl" => "admin grafici tpl",
"ChatAdmin tpl" => "ChatAdmin tpl",
"admin content templates tpl" => "admin šablona sadržaja tpl",
"tiki admin external wikis tpl" => "tiki admin eksterni wiki tpl",
"admin forums tpl" => "admin forumi tpl",
"admin hotwords tpl" => "admin aktivne reči tpl",
"admin HtmlPages tpl" => "admin HtmlPages tpl",
"Is this regular expression or simpel search/replacer" => "Da li je ovo regularan izraz (regex) ili jednostavna pretraga/zamena",
"<span title=\"{tr}subset of chars: imsxeADSXUu, which is regex modifiers" => "<span title=\"{tr}podskup karaktera: imsxeADSXUu, koji su regex modifikatori",
"admin featured links tpl" => "admin prikazujemo vam sajtove tpl",
"admin mailin tpl" => "admin mailin tpl",
"Edit tpl" => "Izmeni tpl",
"admin modules tpl" => "admin moduli tpl",
"admin newsletters tpl" => "admin novine tpl",
"admin notifications tpl" => "admin notifikacije tpl",
"admin polls tpl" => "admin polls tpl",
"tiki admin quicktags tpl" => "tiki admin quicktags tpl",
"admin RSSmodules tpl" => "admin RSSmoduli tpl",
"admin structures tpl" => "admin strukture tpl",
"admin surveys tpl" => "admin surveys tpl",
"admin topics tpl" => "admin teme tpl",
"(Dropdown options : list of items separated with commas)" => "(Opcije u padajućoj listi : lista opcija razdvojenih zarezom)",
"(Image options : xSize,ySize indicated in pixels)" => "(Opcije slika : xVeličina,yVeličina u pikselima)",
"admin groups tpl" => "admin grupe tpl",
"admin users tpl" => "admin korisnici tpl",
"Events Panel" => "Panel događaja",
"For more information, please see <a\nhref=\"http://www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\non <a href=\"http://www.tikiwiki.org\">Tikiwiki.org</a>." => "Za više informacija vidite <a\nhref=\"http://www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\nna <a href=\"http://www.tikiwiki.org\">Tikiwiki.org</a>.",
"file galleries tpl" => "fajl galerije tpl",
"MyTikiDoc" => "MojTikiDoc",
"Attachements" => "Dodaci",
"Webmail Doc tpl" => "Webmail Doc tpl",
"Are you sure you want to delete this directory?" => "Da li ste sigurni da želite da obrišete ovaj direktorijum?",
"Are you sure you want to delete this file?" => "Da li ste sigurni da želite da obrišete ovaj fajl?",
"Top `\$module_rws` topics" => "Naj `\$module_rws` tema",
"Skip to Content" => "Preskoči na sadržaj",
"PHPOpenTracker" => "PHPOpenTracker",
"Comm" => "Comm",
"-1m" => "-1m",
"-7d" => "-7d",
"-1d" => "-1d",
"+1d" => "+1d",
"+7d" => "+7d",
"+1m" => "+1m",
"op" => "op",
"The cord" => "The cord",
"Mus enter a name to add a site" => "Morate uneti naziv za unos sajta",
"updated by the phpwiki import process" => "obnovio phpwiki uvozni proces",
"created from phpwiki import" => "napravljeno iz phpwiki uvoza",
"Wiki page" => "Wiki strane",
"pageviews" => "pogleda strana",
"Your Tiki account information for" => "Vaše informacije o Tiki nalogu za",
"A password reminder email has been sent " => "Email za podsećanje lozinke vam je poslat",
"A new password has been sent " => "Nova lozinka je poslata",
"Upload was not successful (maybe a duplicate file)" => "Upload nije uspešan (možda već postoji fajl sa istim imenom)",
"Invalid password.  You current password is required to change your email address." => "Pogrešna lozinka. Vaša trenutna lozinka je potrebna da bi promenili vašu email adresu.",
" new topic:" => " nova tema:",
"topic:" => "tema:",
"forum topic" => "tema na forumu",
"New article submitted at " => "Novi članak objavljen na ",
"New message arrived from " => "Nova poruka je stigla od ",
"Welcome to " => "Dobrodošli na ",
"Bye bye from " => "Zdravo od ",
" at " => " na ",
"Posted comments" => "Napisani komentari",
"reply to this" => "odgovori na ovo",
"parent" => "roditelj",
"Return to messages" => "Vrati se na poruke",
"Unflagg" => "Odmarkiraj",
"Admin structures" => "Administriraj uloge",
"In blog listing show user as" => "U blog listi pokaži korisnika kao",
"creation date" => "datum pravljenja",
"last modification time" => "vreme zadnje izmene",
"CMS settings" => "CMS podešavanja",
"Time Zone" => "Vremenske zone",
"Server time zone" => "Vremenska zona na serveru",
"Time Zone Map" => "Mapa vremenskih zona",
"Wiki Page Names" => "Wiki Nazivi Stranica",
"strict" => "striktni",
"Ranking" => "Rangiranje",
"Warn on edit" => "Upozori o izmeni",
"Enable watch by default for author" => "Omogući podrazumevano nadgledanje za autore",
"Enable watches when I am the editor" => "Omogući nadgledanje kada sam ja editor",
"Users can vote only one item from this chart per period" => "Korisnici mogu da glasaju samo za jednu stvar na ovom grafiku u toku jednog perioda",
"Prevent users from voting same item more than one time" => "Spreči korisnike da ne glasaju za istu stvar više od jednom",
"ChatAdmin" => "Chat Administracija",
"half a second" => "pola sekunde",
"AdminDSN" => "Administriraj DSN",
"admin ExternalWiki" => "administriraj eksterni Wiki",
"Threads can be voted" => "Niti mogu da budu izglasavane",
"Directory (include trailing slash)" => "Direktorijum (sa pratećom kosom crtom)",
"admin HtmlPages" => "administriraj HTML strane",
"WebMail accounts" => "Webmail nalozi",
"Add all your site users to this newsletter (broadcast)" => "Dodaj sve korisnike sajta ovim novinama (globalno)",
"Add users" => "Dodaj korisnike",
"Create New Survey:" => "Napravi novu anketu:",
"stat" => "stat.",
"Show status when listing tracker items?" => "Prikaži status na spisku zapisa trakera?",
"Add New Group" => "Dodaj novu grupu",
"Edit this group:" => "Izmeni ovu grupu:",
"assign_perms" => "dodeli_dozvole",
"assign group" => "dodeli grupu",
"view info" => "vidi informacije",
"File gals" => "Galerije fajlova",
"Image gals" => "Galerije slika",
"Cms" => "CMS",
"ExtWikis" => "ExtWiki",
"assgn" => "dodeli",
"Klick to enlarge" => "Klikni da povećaš",
"You can include the image in an HTML or Tiki page using" => "Možete da uključite sliku u HTML ili Tiki koristeći",
"Calendars Panel" => "Kalendari",
"today" => "danas",
"save a custom copy" => "snimi promenjenu kopiju",
"use square brackets for an" => "koristi uglaste zagrade za",
"link_description" => "opis_linka",
"Prevents parsing data" => "Sprečava parsiranje podataka",
"Reuse question" => "Koristi stara pitanja",
"act status" => "status uloge",
"running" => "pokretanje",
"Add scaled images size X x Y" => "Dodaj skalirane slike veličine X x Y",
"Import pages from a PHPWiki Dump" => "Uvezi strane iz PHPWiki ostave",
"Path to where the dumped files are (relative to tiki basedir with trailing slash ex: dump/)" => "Put do mesta gde je skladište fajlova (relativno u odnosu na tiki osnovni direktorijum sa pratećom kosom crtom mpr: dump/)",
"ver" => "verzija",
"Newss from" => "Novosti sa",
"Send Objects" => "Pošalji objekte",
"Show chart for the last " => "Pokaži grafik za zadnjih ",
"days (0=all)" => "dana (0=svi)",
"Control by Object" => "Kontrola po objektima",
"Control by category" => "Kontrola po kategoriji",
"use filename" => "koristi ime fajla",
"remove bookmark" => "obriši omiljenu stranu",
"Use dbl click to edit pages" => "Koristi dupli klik za menjanje strana",
"Change your email" => "Promeni email",
"change email" => "promeni email",
"Configure this page" => "Promeni ovu stranu",
"All tasks" => "Svi poslovi",
"mark as done" => "označi kao urađeno",
"open tasks" => "otvori poslove",
"Add or edit a task" => "Dodaj ili promeni posao",
"FAQ Questions" => "FAQ pitanja",
"FAQ Answers" => "FAQ odgovori",
"Show suggested questions/suggest a question" => "Prikaži predložena pitanja/predloži pitanje",
"Hide suggested questions" => "Sakrij predložena pitanja",
"Tiki forums" => "Tiki forumi",
"this post was reported" => "ova poruka je prijavljena",
"report this post" => "prijavi ovu poruku",
"checked" => "uključen",
"unchecked" => "isključen",
"Mark as Flagged" => "Označi",
"someone from" => "neko sa",
"You can edit the page following this link:" => "Možete izmeniti stranicu koristeći sledeći link:",
"Diff:" => "Razlika:",
"The new page content is:" => "Novi sadržaj strane je:",
"MyTiki (click!)" => "MojTiki",
"Admin (click!)" => "Administracija",
"More info about" => "Više informacija o",
"idle" => "pauziran",
"You do not have permission to use this feature." => "Nemate dozvolu da koristite ovu mogućnost",
"no description" => "nema opisa",
"requested a reminder of the password for the" => "zahtevao podsećanje lozinke za",
"since this is your registered email address we inform that the" => "pošto je ovo vaša registrovana email adresa obaveštavamo vas da",
"password for this account is" => "lozinka za ovaj nalog je",
"Information:" => "Informacije:",
"New blog post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Nova blog poruka {\$mail_title} od {\$mail_user} dana {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was changed by {\$mail_user} at\n{\$mail_date|tiki_short_datetime}" => "Stranu {\$mail_page} je promenio {\$mail_user} dana\n{\$mail_date|tiki_short_datetime}",
"You can view the page by following this link:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}" => "Stranu možete videti ako pratite sledeći link:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}",
"You can edit the page by following this link:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}" => "Stranu možete izmeniti ako odete na sledeći link:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}",
"You can view a diff back to the previous version by following\nthis link:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}" => "Razliku u odnosu na prošlu verziju možete videti na\novom linku:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}",
"Please" => "Molimo",
"log in" => "login",
"to access full functionalities" => "da bi iskoristili sve mogućnosti",
"Blog settings" => "Podešavanja blogova",
"FAQs settings" => "Podešavanja FAQ",
"FAQ comments" => "FAQ komentari",
"Create a group for each user <br />(with the same\nname as the user)" => "Napravi grupu za svakog korisnika <br />(sa istim\nimenom kao korisnik)",
"Remind passwords by email" => "Šalji zaboravljenu lozinku email-om",
"Poll settings" => "Podešavanja upitnika",
"Append CSS file to feed urls" => "Dodaj CSS fajl izvornim URL",
"Publisher" => "Objavio",
"Create a tag for the current wiki" => "Napravi tag za trenutni wiki",
"Restore the wiki" => "Vrati wiki u prošlo stanje",
"Wiki comments settings" => "Wiki podešavanja komentara",
"Wiki page list configuration" => "Podešavanje liste Wiki strana",
"Like pages" => "Slične strane",
"List Calendars" => "Lista kalendara",
"admin Drawings" => "administriraj crteže",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "Koristite {literal}{{/literal}ed id=name} ili {literal}{{/literal}ted id=name} da bi ubacili dinamičke zone",
"Added users" => "Dodati korisnici",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor" => "Napomena: ako želite da koristite slike molimo vas da prvo snimite poruku a posle\nmožete dodate/izmenite slike. Koristite &lt;img&gt; snipet da bi iskoristili uploadovane slike u textarea editoru ili koristite URL slike\nda bi dodali slike koristeći WYSIWYG editor.",
"search category" => "kategorija pretrage",
"deep" => "duboko",
"Add Calendar Item" => "Dodaj u kalendar",
"Textheight" => "VisinaTeksta",
"Height of top Heading" => "Visina gornjeg zaglavlja",
"Height of mid Heading" => "Visina srednjeg zaglavlja",
"Height of inner Heading" => "Visina unutrašnjeg zaglavlja",
"tbheight" => "tbvisina",
"Automatic Page Breaks" => "Automatsko prelamanje stranica",
"Emphasis" => "Naglasak",
"italics" => "italik",
"both" => "oba",
"use ...page... to separate pages" => "koristite ...page... da bi razdvojili strane",
"make_headings" => "napravi_zaglavlje",
"underlines text" => "podvlači tekst",
"Simple box" => "Jednostavan okvir",
"Will display using the indicated HTML color" => "Biće prikazan koristeći odabranu HTML boju",
"Will display the text centered" => "Prikazaće tekst centrirano",
"Edit Submissions" => "Izmeni priloge",
"Activs" => "Aktivn.",
"Ins" => "Ubaci",
"time" => "vreme",
"Wiki quick help" => "Wiki brza pomoć",
"Quicklinks" => "Brzi linkovi",
"Comparing versions" => "Upoređivanje verzija",
"Actual_version" => "Stvarna_verzija",
"Diff to version" => "Razlike u odnosu na verziju",
"admin DynamicContent" => "administriraj Dinamički sadržaj",
"perm" => "dozvola",
"topics in this forum" => "tema u ovom forumu",
"Editing tracker item" => "Menjanje zapisa trakera",
"The passwords dont match" => "Lozinke nisu iste",
"You do not have permission to write the template" => "Nemate dozvolu da pravite šablone",
"You have to type a searchword" => "Morate da napišete reč za pretraživanje",
"You have to provide a name to the image" => "Morate napisati ime slike",
"%H:%M:%S %Z" => "%H:%M:%S %Z",
"HomePage" => "HomePage",
"ok" => "ok",
"loc" => "loc",
"prio" => "prio",
"admin FortuneCookie tpl" => "admin FortuneCookie tpl",
"upload" => "upload",
"dsn" => "dsn",
"coms" => "coms",
"url" => "url",
"admin" => "admin",
"admin admin tpl" => "admin admin tpl",
"stop" => "stop",
"admin Ephemerides tpl" => "admin Ephemerides tpl",
"list faqs tpl" => "list faqs tpl",
"adm" => "adm",
"admin Tiki Shoutbox tpl" => "admin Tiki Shoutbox tpl",
"uploaded by" => "uploadovao",
"not specified" => "nije odabrano",
"%A %d of %B, %Y" => "%A %d %B, %Y",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d %B, %Y[%H:%M:%S %Z]",
"%a %d of %b, %Y" => "%a %d %b, %Y",
"%a %d of %b, %Y[%H:%M %Z]" => "%a %d %b, %Y[%H:%M %Z]",
"delete" => "obriši",
"post" => "poalji",
"stop monitoring this blog" => "prestani sa nadgledanjem ovog bloga",
"posts" => "poruka",
"visits" => "poseta",
"show categories" => "prikaži kategorije",
"author" => "autor",
"user level" => "Korisnički nivo",
"send email to user" => "pošalji email korisniku",
"score" => "ocena",
"delete selected" => "obriši odabrano",
"move" => "pomeri",
"set" => "postavi",
"replies" => "odgovora",
"new reply" => "nov odgovor",
"cancel" => "obustavi",
"up" => "gore",
"down" => "dole",
"add" => "dodaj",
"stop monitoring this map" => "prekini praćenje ove mape",
"create" => "napravi",
"save" => "snimi",
"send" => "pošalji",
"register" => "Registruj se",
"standard" => "standardan",
"secure" => "siguran",
"stay in ssl mode" => "ostani u ssl modu",
"new messages" => "novih poruka",
"new message" => "novu poruku",
"go" => "idi",
"cache" => "skladište",
"use" => "koristi",
"cached" => "uskladišteno",
"refresh" => "osvežavanje",
"print" => "štampaj",
"create pdf" => "napravi PDF",
"monitor this page" => "nadgledaj ovu stranu",
"stop monitoring this page" => "prestani sa nadgledanjem ove strane",
"backlinks" => "rekurzivni linkovi",
"click here" => "klikni ovde",
"rename" => "promeni ime",
"unlock" => "otključaj",
"lock" => "zaključaj",
"perms" => "dozvole",
"history" => "istorija",
"similar" => "slično",
"undo" => "vrati",
"slides" => "slajdovi",
"export" => "izvoz",
"discuss" => "diskutuj",
"add comment" => "dodaj komentar",
"attach file" => "dodaj fajl",
"last modification" => "zadnja izmena",
"attachments" => "prilog",
"stats" => "Statistike",
"last changes" => "zadnje izmene",
"list pages" => "lista strana",
"back to homepage" => "nazad na glavnu stranu",
"cancel edit" => "odustani od izmene",
"No attachments for this page" => "Nema priloga za ovu stranu",
"switch" => "Prekidač",
"view blog" => "vidi blog",
"list blogs" => "lista blogova",
"save and exit" => "snimi i izađi",
"reads" => "čitanja",
"view comments" => "vidi komentare",
"wiki help" => "wiki pomoć",
"flag" => "zastava",
"images" => "slike",
"Server name (for absolute URIs)" => "Naziv servera (za apsolutne URL)",
"Wiki_Tiki_Title" => "Wiki_Tiki_Naslov",
"path" => "put",
"groups" => "grupe",
"Require HTTP Basic authentication" => "Zahtevaj HTTP Basic autentikaciju",
"HTTP server name" => "HTTP naziv servera",
"HTTP URL prefix" => "HTTP URL prefiks",
"HTTPS server name" => "HTTPS naziv servera",
"HTTPS URL prefix" => "HTTPS URL prefiks",
"Only for users" => "Samo za korisnike",
"Users and admins" => "Korisnike i administratore",
"Full Text Search" => "Pretraga po celokupnom tekstu",
"change" => "promeni",
"full" => "puni",
"Enable Feature" => "Omogući osobenost",
"admin banning tpl" => "admin izbacivanje tpl",
"cat" => "katalog",
"lang" => "jezik",
"permissions" => "dozvole",
"admin categories" => "administracija kategorija",
"admin categories tpl" => "admin kategorija tpl",
"create new" => "napravi novo",
"edit chart" => "izmeni grafik",
"update" => "obnovi",
"admin content templates" => "administriraj šablone sadržaja",
"use in cms" => "koristi u CMS",
"use in wiki" => "koristi u Wiki",
"use in newsletters" => "koristi u novinama",
"use in HTML pages" => "koristi u HTML stranama",
"last modif" => "zadnja izmena",
"sections" => "sekcije",
"admin FortuneCookie" => "administriraj Srećne Kolačiće",
"admin Drawings tpl" => "admin crteži tpl",
"extwiki" => "spoljni tiki",
"online" => "uključen",
"topics" => "teme",
"age" => "godine",
"ppd" => "pnd",
"last post" => "zadnja poruka",
"admin hotwords" => "administriraj aktivne reči",
"admin HTML page dynamic zones" => "admin dinamičke zone HTML strana",
"list repositories" => "lista repozitorija",
"new repository" => "nova repozitorija",
"view repository" => "vidi repozitorije",
"view this repository" => "vidi ovu repozitoriju",
"new rule" => "novo pravilo",
"admin featured links" => "administriraj prikazane sajtove",
"position" => "pozicija",
"admin Webmail" => "administriraj Webmail",
"section" => "sekcije",
"admin menu builder" => "administriraj pravljenje menija",
"options" => "opcije",
"admin modules" => "administracija modula",
"assign module" => "dodeli modul",
"left modules" => "levi moduli",
"right modules" => "desni moduli",
"edit/create" => "izmeni/napravi",
"clear cache" => "obriši skladište",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Napomena 1</b>: ako dozvolite korisnicima da pode avaju module onda dodeljeni module neće raditi dok ih ne podesite iz MyTiki->moduli.<br />\n<b>Napomena 2</b>: Ako dodelite module grupe, budite sigurni da ste isključili opciju 'prikaži sve module svim grupama' iz Admin->Generalno\n",
"assign" => "dodeli",
"left" => "levo",
"right" => "desno",
"order" => "redosled",
"create/edit" => "napravi/izmeni",
"use poll" => "koristi upitnik",
"use gallery" => "koristi galeriju",
"use dynamic  content" => "koristi dinamički sadržaj",
"use rss module" => "koristi rss module",
"use menu" => "koristi meni",
"use banner zone" => "koristi zone oglasa",
"list newsletters" => "lista novina",
"admin newsletters" => "administriraj novine",
"send newsletters" => "pošalji novine",
"editions" => "izdanja",
"last sent" => "zadnje poslate",
"admin Email Notifications" => "administriraj E-Mail obaveštenja",
"use admin email" => "koristi administratorski email",
"event" => "slučaj",
"admin polls" => "administriraj upitnike",
"admin QuickTags" => "administriraj QuickTags",
"label" => "naslov",
"admin RSS Modules" => "administracija RSS modula",
"export pages" => "izvezi strane",
"dump tree" => "prebaci na ostavu drvo",
"create webhelp" => "napravi webpomoć",
"view webhelp" => "vidi webpomoć",
"tree" => "drvo",
"create new structure" => "napravi novu strukturu",
"survey stats" => "Statistike anketa",
"edit this survey" => "izmeni ovu anketu",
"admin surveys" => "administracija anketa",
"list surveys" => "lista anketa",
"questions" => "pitanja",
"files" => "fajlova",
"admin Trackers tpl" => "admin trakeri tpl",
"items" => "zapisa",
"version" => "verzija",
"admin groups" => "administriraj grupe",
"admin users" => "administriraj korisnike",
"edit article tpl" => "izmeni šablon članka",
"all" => "sve",
"Assign user" => "Dodeli korisnika",
"admin backups" => "administriraj bekape",
"List of available backups" => "Lista raspoloživih bekapa",
"Restoring a backup" => "Povraćaj bekapa",
"Warning!" => "Upozorenje!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Povraćaj bekapa uništava svepodatke u vašoj Tiki bazi podatraka. Sve vaše tabele će biti zamenjene informacijama u bekapu.",
"Click here to confirm restoring" => "Kliknite ovde da bi potvrdili povraćaj",
"Create new backup" => "Napravi novi bekap",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Pravljenje bekapa može da potraje dosta vremena. Ako se proces ne završi videćete prazan ekran. Ako se to desi, potrebno je da povećate maksimalno vreme izvršavanja skripta u php.ini fajlu",
"Upload a backup" => "Uploaduj bekap",
"Upload backup" => "Uploaduj bekap",
"edit gallery" => "izmeni galeriju",
"rebuild thumbnails" => "ponovo napravi smanjene slike",
"upload image" => "dodaj sliku",
"list gallery" => "lista galerija",
"original size" => "orginalna veličina",
"return to gallery" => "vrati se na galeriju",
"edit image" => "izmeni slike",
"smaller" => "manje",
"bigger" => "veće",
"prev image" => "prošla slika",
"popup window" => "popup prozor",
"next image" => "sledeća slika",
"imagescale" => "skalaslike",
"or create a new category" => "ili napravite novu kategoriju",
"or create a new location" => "ili napravite novu lokaciju",
"comma separated usernames" => " razmacima razdvojeni korisnička imena",
"comma separated username:role" => "razmacima razdvojeni korisničko ime:uloga",
"with roles" => "sa ulogama",
"Chair" => "Vođa",
"Optional" => "Opciono",
"permission" => "dozvola",
"remove page" => "obriši stranu",
"admin directory tpl" => "admin direktorijumi tpl",
"browse" => "gledaj",
"related" => "povezani",
"validate" => "proveri",
"admin directory categories tpl" => "admin kategorije direktorijuma tpl",
"add a site" => "dodaj sajt",
"search" => "pretraga",
"edit template" => "izmeni šablon",
"list articles" => "lista članaka",
"view articles" => "vidi članke",
"create zone" => "napravi zonu",
"save the banner" => "snimi oglas",
"edit blog tpl" => "izmeni blog tpl",
"try" => "pokušaj",
"display" => "prikaz",
"create new block" => "napravi novi blok",
"list quizzes" => "lista kvizova",
"quiz stats" => "Statistike kvizova",
"edit this quiz" => "izmeni ovaj kviz",
"admin quizzes" => "administracija kvizova",
"admin quizzes tpl" => "admin kvizove tpl",
"results" => "rezultati",
"create page" => "napravi stranu",
"edit submissions tpl" => "izmeni priloge tpl",
"list submissions" => "lista predloga",
"Admin ephemerides" => "Administriraj efemeride",
"All ephemerides" => "Sve efemeride",
"new question" => "novo pitanje",
"approve" => "dozvoli",
"configure listing" => "konfiguriši_listing",
"topic" => "tema",
"save and approve" => "snimi i dozvoli",
"new topic" => "nova tema",
"reject" => "odbij",
"accept" => "prihvati",
"add new" => "dodaj novo",
"add role" => "dodaj ulogu",
"new minor" => "nova manja",
"new major" => "nova glavna",
"admin processes" => "administriraj procese",
"admin activities" => "admin aktivnosti",
"admin roles" => "aministriraj uloge",
"edit this process" => "izmeni ovaj proces",
"monitor" => "nadgledaj",
"send instance" => "pošalji instancu",
"create new gallery" => "napravi novu galeriju",
"result" => "rezultat",
"edit repository" => "promeni repozitoriju",
"source" => "izvor",
"list articles tpl" => "lista članak tpl",
"edit new article" => "izmeni novi članak",
"admin Banners" => "administriraj oglase",
"admin Banners tpl" => "admin banere tpl",
"create new blog" => "napravi novi blog",
"admin cache" => "administriraj skladište",
"admin cache tpl" => "admin skladište tpl",
"admin DynamicContent tpl" => "admin Dinamički Sadržaj tpl",
"upload file" => "dodaj fajl",
"Edit a file using this form" => "Izmeni fajl koristeći ovu formu",
"delete selected files" => "obriši odabrane fajlove",
"browse gallery" => "gledaj galeriju",
"Flash binary (.sqf or .dcr)" => "Flash binarni fajlovi (.sqf or .dcr)",
"list posts tpl" => "list poruke tpl",
"edit blog" => "izmeni Blog",
"edit new submission" => "izmeni nove priloge",
"admin live support tpl" => "admin podrška uživo tpl",
"set as operator" => "postavi kao operatora",
"add topic" => "dodaj temu",
"wiki create" => "wiki napravi",
"wiki overwrite" => "Wiki prebriši",
"back" => "nazad",
"Assign permissions to page" => "Dodeli dozvole strani",
"Current permissions for this page" => "Trenutne dozvole za ovu stranu",
"remove from this page" => "ukloni sa ove strane",
"remove from this structure" => "ukloni iz ove strukture",
"this page" => "ova strana",
"Send email notifications when this page changes to" => "Pošalji email obaveštenje kada se ova poruka promeni na",
"add email" => "dodaj email",
"Notifications" => "Obaveštenja",
"clear stats" => "briši statistike",
"Edit received page" => "Izmenbu primljenu stranu",
"admin Referer stats" => "administriraj statistike referenata",
"admin Referer stats tpl" => "admin referer statistike tpl",
"last" => "zadnji",
"send me my password" => "pošalji mi moju lozinku",
"searched" => "pretraženo",
"galleries" => "galerije",
"blog posts" => "blog poruke",
"articles" => "članci",
"admin send objects tpl" => "admin pošalji objekte tpl",
"site" => "sajt",
"clear" => "obriši",
"add article" => "dodaj članak",
"admin Tiki Shoutbox" => "administriraj Tiki ShoutBox",
"send answers" => "pošalji odgovore",
"move to right column" => "pomeri u desnu kolonu",
"unassign" => "oduzmi",
"move to left column" => "pomeri u levu kolonu",
"remove folder" => "obriši direktorijum",
"refresh cache" => "osveži skladište",
"no comments" => "nema komentara",
"edit items" => "izmeni zapise",
"list charts" => "Lista grafika",
"last chart" => "zadnji grafik",
"item" => "zapis",
"view faq" => "vidi faq",
"view faq tpl" => "vidi faq tpl",
"admin menus tpl" => "admin meniji tpl",
"monitor this forum" => "nadgledaj ovaj forum",
"stop monitoring this forum" => "prestani sa nadgledanjem ovog foruma",
"delete selected topics" => "obriši odabrane teme",
"stop monitoring this topic" => "prestani sa nadgledanjem ove teme",
"Comments below your current threshold" => "Komentara ispod vaše trenutne granice",
"add contacts" => "Dodaj kontakte",
"DATE-of" => "od",
"You cannot edit this page because it is a user personal page" => "Ne možete promeniti ovu stranu jer je ona korisnička strana",
"Permission denied you cannot assign permissions for this page" => "Nemate dozvolu da dodeljujete dozvole za ovu stranu",
"You do not have permission to edit messages" => "Nemate dozvolu da menjate poruke",
"Cannot read file" => "ne mogu da pročitam fajl",
"Permission denied you cannot upload files" => "Nemate dozvolu da uploadujete fajlove",
"cannot process upload" => "ne može da se završi upload",
"Your email address has been removed from the list of addresses monitoring this tracker" => "Vaša email adresa je uklonjena sa liste adresa koje nadgledaju ovaj traker",
"Your email address has been added to the list of addresses monitoring this tracker" => "Vaša email adresa je dodata listi adresa koje nadgledaju ovaj traker",
"Cancel monitoring" => "Prekini nadgledanje",
"Your email address has been removed from the list of addresses monitoring this item" => "Vaša email adresa je uklonjena sa liste adresa koje nadgledaju ovu stvar",
"Your email address has been added to the list of addresses monitoring this item" => "Vaša email adresa je dodata listi adresa koje nadgledaju ovu stvar",
"filter" => "filter",
"pdf" => "pdf",
"UTC" => "UTC",
"proc" => "proc",
"Com" => "Com",
"pos" => "pos",
"pre" => "pre",
"emot" => "emot",
"pop" => "pop",
"new image uploaded by" => "novu sliku je dodao",
"new subscriptions" => "nove pretplate",
"new item in tracker" => "nov zapis u trakeru",
"message" => "poruka",
"Include an article" => "Dodaj članak",
"no such file" => "nema takvog fajla",
"downloads" => "preuzeto puta",
"attach" => "priloži",
"monitor this blog" => "nadgledaj ovaj blog",
"hide categories" => "sakrij kategorije",
"Admin categories" => "Administriraj kategorije",
"reply" => "odgovori",
"monitor this topic" => "nadgledaj ovu temu",
"with checked" => "sa označenim",
"Dls" => "Skidanja",
"move selected files" => "pomeri odabrane fajlove",
"Thank you for you registration. You may log in now." => "Hvala vam na vašoj registraciji. Sada možete da se loginujete",
"from\nthe mapfile:" => "iz\nmap fajla:",
"compare" => "uporedi",
"diff" => "razlika",
"del" => "obriši",
"Create pdf" => "Napravi PDF",
"1 file attached" => "1 fajl prikačen",
"categories" => "kategorije",
"List pages where I am a creator" => "Izlistaj strane gde sam ja kreator",
"by creator" => "po kreatoru",
"List pages where I am a modificator" => "Izlistaj strane koje sam ja promenio",
"by modificator" => "po osobi koja je menjala",
"at tracker" => "na trakeru",
"check / uncheck all" => "markiraj / odmarkiraj sve",
"Tiki sections and features" => "Tiki sekcije i osobine",
"please read" => "molimo vas da pročitate",
"yes" => "da",
"Click here for more details." => "Klikni ovde za detalje.",
"Local" => "Lokalno",
"private" => "privatno",
"<b>Feed</b>" => "<b>Izvor</b>",
"<b>enable/disable</b>" => "<b>ukljiči/isključi</b>",
"<b>Max number of items</b>" => "<b>Maksimalan broj stvari</b>",
"Feed for Articles" => "Izvor za članke",
"Feed for Weblogs" => "Izvor za Weblogove",
"Feed for Image Galleries" => "Izvor za galerije slika",
"Feed for File Galleries" => "Izvor za galerije fajlova",
"Feed for the Wiki" => "Izvor za Wiki",
"Feed for individual Image Galleries" => "Izvor za pojedinačne galerije slika",
"Feed for individual File Galleries" => "Izvor za pojedinačne galerije fajlova",
"Feed for individual weblogs" => "Izvor za pojedinačne weblogove",
"Feed for individual forums" => "Izvor za pojedinačne forume",
"Feed for mapfiles" => "Izvor za mapfajlove",
"PDF generation" => "PDF generisanje",
"Use in CMS" => "Koristi u CMS",
"Use in Wiki" => "Koristi u Wiki",
"Use in newsletters" => "Koristi u novinama",
"Use in HTML pages" => "Koristi u HTML stranama",
"Refresh rate (if dynamic) [secs]" => "Vreme osvežavanja (ako je dinamička) [sekundi]",
"configure repositories" => "podesi repozitorije",
"configure this repository" => "podesi ovu repozitoriju",
"copy rules" => "kopiraj pravila",
"Create/edit newsletters" => "Napravi/izmeni novine",
"subscriptions" => "pretplate",
"Use Admin Email" => "Koristi administratorski email",
"Edit or add poll options" => "Izmeni ili dodaj opcije upitnika",
"Create/edit Polls" => "Napravi/izmeni upitnik",
"Rss channels" => "RSS kanali",
"show pubdate" => "prikaži datum objavljivanja",
"activate" => "aktiviraj",
"Admin tracker" => "Administracija trakera",
"Edit this tracker" => "Izmeni ovaj traker",
"View this tracker items" => "Vidi zapise ovog trakera",
"Edit tracker fields" => "Izmeni polja u trakeru",
"fields" => "polja",
"Create/edit trackers" => "Napravi/izmeni traker",
"Edit item" => "Izmeni zapis",
"Add a new user" => "Dodaj novog korisnika",
"Popup Window" => "Popup prozor",
"details" => "detalji",
"No individual permissions global permissions apply" => "Nema individualnih dozvola. Koriste se globalne dozvole.",
"Welcome to the Tiki Chat Rooms" => "Dobrodošli u Tiki Chat",
"Please select a chat channel" => "Molimo odaberite kanala za chat",
"enter chat room" => "uđi u pričaonicu",
"Chatroom" => "Pričaonica",
"Active Channels" => "Aktivni kanali",
"Users in this channel" => "Korisnici u ovom kanalu",
"Channel Information" => "Informacije o kanalu",
"Channel" => "Kanal",
"Ratio" => "Odnos",
"Use :nickname:message for private messages" => "Koristite :nadimak:poruka za privatne poruke",
"Use [URL|description] or [URL] for links" => "Koristite [URL|opis] ili [URL] za linkove",
"Use (:smileyname:) for smileys" => "Koristi (:imesmajlija:) za smajlije",
"Create PDF" => "Napravi PDF",
"PDF Settings" => "PDF podešavanja",
"Select Wiki Pages" => "Odaberi Wiki stranu",
"Remove Page" => "Obriši stranu",
"Add or edit a site" => "Dodaj ili izmeni sajt",
"sites" => "sajtovi",
"cool sites" => "cool sajtovi",
"Use ...page... to separate pages in a multi-page article" => "koristite ...page... da bi razdvojili strane u višestranom članku",
"Create Zone" => "Napravi zonu",
"translate" => "prevedi",
"Create or edit content" => "Napravi ili izmeni sadržaj",
"this quiz stats" => "Statistike ovog kviza",
"answer" => "odgovor",
"graph" => "grafik",
"Edit FAQ questions" => "Izmeni FAQ pitanja",
"Edit this file gallery:" => "Izmeni ovu galeriju fajlova:",
"icon" => "ikona",
"Other users can upload files to this gallery" => "Ostali korisnici mogu da šalju fajlove na ovu galeriju",
"Available File Galleries" => "Slobodne galerije fajlova",
"start" => "počni",
"end" => "kraj",
"roles" => "uloge",
"Add role" => "Dodaj ulogu",
"active process" => "aktivni procesi",
"invalid" => "neispravan",
"invalid process" => "neispravan proces",
"valid process" => "ispravni proves",
"activities" => "aktivnosti",
"aborted" => "prekinut",
"value" => "vrednost",
"exceptions" => "izuzetci",
"rollback" => "vrati",
"Create or edit content block" => "Napravi ili izmeni blok sa sadržajem",
"Listing Gallery" => "Listanje galerija",
"Gallery Files" => "Fajlovi u galeriji",
"Last ver" => "Zadnja verzija",
"Vers" => "Verzija",
"Subscribe to newsletter" => "Upišite se na novine",
"Add or edit a news server" => "Dodaj ili izmeni server novosti",
"Print Wiki Pages" => "Štampaj Wiki strane",
"add page" => "dodaj stranu",
"click to navigate" => "klikni za navigaciju",
"Total threads" => "Ukupno poruka",
"Average threads per topic" => "Prosečno poruka po temi",
"You can include the file in an HTML/Tiki page using" => "Ovaj fajl možete da uključite u vašoj HTML/Tiki strani koristeći",
"Now enter the file URL" => "Sada upišite pun URL",
" or upload a local file from your disk" => " ili odaberite fajl sa vašeg hard diska za uploadovanje",
"Add or edit folder" => "Dodaj ili izmeni direktorijum",
"Add or edit a URL" => "Dodaj ili izmeni URL",
"priority" => "prioritet",
"previous chart" => "prošli grafik",
"next chart" => "sledeći grafik",
"avg" => "prosek",
"post new comment" => "napiši novi komentar",
"Post New Comment" => "Napiši novi komentar",
"HTML tags are not allowed inside comments" => "HTML nisu dozvoljeni unutar komentara",
"moderator actions" => "moderatorske akcije",
"move selected topics" => "pomeri odabrane teme",
"unlock selected topics" => "odključaj odabrane teme",
"lock selected topics" => "zaključaj odabrane teme",
"merge" => "spoj",
"merge selected topics" => "spoj odabrane teme",
"reported messages:" => "prijavljene poruke:",
"queued messages:" => "poruke na listi čekanja:",
"View item" => "Vidi zapis",
"Add a comment" => "Dodaj komentar",
"account" => "nalog",
"Group doesnt exist" => "Grupa ne postoji",
"User doesnt exist" => "Korisnik ne postoji",
"Event without Name" => "Događaj bez imena",
"Invalid old password" => "Neispravna stara lozinka",
"No channel indicated" => "Kanal nije odabran",
"No nickname indicated" => "Nadimak nije odabran",
"Permision denied" => "Zabranjeno",
"cc" => "cc",
"sender" => "pošiljaoc",
"subject" => "naslov",
"date" => "datum",
"flagged" => "označeno",
"mark" => "obeleži",
"replied" => "odgovoreno",
"Click" => "Klikni",
"posted by" => "napisao",
"email this post" => "email-uj ovu poruku",
"Use page description" => "Koristi opise strana",
"Show page title" => "Prikaži naziv strane",
"Cache wiki pages (global)" => "Skladišti wiki strane (globalno)",
"Users can lock pages (if perm)" => "Korisnici mogu da zaključavaju strane (ako imaju dozvolu)",
"Use WikiWords" => "Koristi WikiReči",
"Maximum number of versions for history" => "Maksimalan broj verzija za istoriju",
"Never delete versions younger than days" => "Ne briši verzije mlađe od ovoliko dana",
"Old vers" => "Stare verzije",
"Add or edit event" => "Dodaj ili izmeni događaj",
"merge selected notes into" => "spoj odabrane note u",
"Faq Stats" => "FAQ statistike",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Vaša poruka je stavljena na listu za čekanje potvrde, a biće objavljena\nnakon što je moderator odobri",
"Webmail Doc" => "Webmail dokumentacija",
"settings" => "podešavanja",
"mailbox" => "poštansko sanduče",
"compose" => "napiši",
"contacts" => "kontakti",
"clip" => "klip",
"back to mailbox" => "nazad na sanduče",
"full headers" => "sva zaglavlja",
"normal headers" => "normalna zaglavlja",
"reply all" => "odgovori svima",
"forward" => "prosledi",
"select from address book" => "odaberi iz adresara",
"tiki-admin_dsn tpl" => "tiki-admin_dsn tpl",
"tiki-import_phpwiki tpl" => "tiki-import_phpwiki tpl",
"IRC log" => "IRC log",
"new sites" => "novi sajtovi",
"Message Broadcast" => "Pošalji svima poruku",
"database queries used" => "upita baze podataka",
"{\$atts_cnt} files attached" => "{\$atts_cnt} fajlova prikačeno",
"pass" => "lozinka",
"Page generated in" => "Strana generisana za",
"sent" => "poslato",
"Favorites" => "Omiljene stranice",
"Back to Homepage" => "Nazad na glavnu stranu",
"Minor" => "Manji",
"Content Features" => "Osobenosti sadržaja",
"Prevent automatic/robot registration" => "Spreči automatsku/robotsku registraciju",
"Admin banning tpl" => "Admin izbacivanje tpl",
"Create/edit Calendars" => "Napravi/izmeni kalendare",
"Admin Categories tpl" => "Admin kategorija tpl",
"charts" => "grafikoni",
"Chat Administration" => "Administracija Chat-a",
"Create/edit channel" => "Napravi/izmeni kanal",
"second" => "sekunda",
"Chat channels" => "Chat kanali",
"Admin Featured Links" => "Administriraj prikazane sajtove",
"Admin Webmail" => "Administriraj Webmail",
"Admin Menu Builder" => "Administriraj pravljenje menija",
"Assign Module" => "Dodeli modul",
"subscribed" => "pretplaćen",
"Edit survey questions" => "Izmeni pitanja ankete",
"Admin Tracker" => "Administracija trakera",
"Again" => "Ponovo",
"Article Types tpl" => "Tipovi članak tpl",
"Assign permissions to group" => "Dodeli dozvole grupi",
"Edit Article Tpl" => "Izmeni šablon članka",
"Browsing Gallery" => "Pregledanje galerije",
"Admin Directory tpl" => "Admin direktorijumi tpl",
"Admin Directory Categories tpl" => "Admin kategorije direktorijuma tpl",
"Admin Directory Related" => "Administriraj srodne direktorijume",
"directory admin related tpl" => "direktorijum admin povezanih tpl",
"Admin Directory Sites" => "Administriraj sajtove u direktorijumu",
"Admin Directory Sites tpl" => "Administriraj sajtove u direktorijumu tpl",
"Validate Sites" => "Proveri sajtove",
"directory validate sites tpl" => "direktorijum proveri sajtove tpl",
"Edit Article" => "Izmeni članak",
"Edit Blog Tpl" => "Izmeni blog tpl",
"Show Plugins Help" => "Prikaži pomoć za pluginove",
"Show Text Formatting Rules" => "Prikaži pravila za formatiranje teksta",
"Program dynamic content for block" => "Programiraj dinamički sadržaj za ovaj blok",
"Admin quizzes" => "Administriraj kvizove",
"Admin Quizzes tpl" => "Admin kvizove tpl",
"Edit Submissions Tpl" => "Izmeni priloge tpl",
"EditTemplates" => "Izmeni šablone",
"EditTemplates tpl" => "Izmeni Šablone tpl",
"Message queue for" => "Lista čekanja poruka za",
"back to forum" => "nazad na forum",
"Reported messages for" => "Prijavljene poruke za",
"galleries tpl" => "galerije tpl",
"ImportingPagesPhpWikiPageAdmin" => "Importovanje strana PHP Wiki administracija strana",
"hist" => "istorija",
"List Articles Tpl" => "Lista članak tpl",
"Admin Cache" => "Administriraj skladište",
"Admin Cache tpl" => "Admin skladište tpl",
"List FAQs Tpl" => "List faqs tpl",
"List Posts Tpl" => "List poruke tpl",
"Admin Live Support tpl" => "Admin podrška uživo tpl",
"back to admin" => "nazad na administraciju",
"my tiki tpl" => "moj tiki tpl",
"Subscribe to This Newsletter" => "Upis",
"Stats for quiz" => "Statistike za kviz",
"Received Articles" => "Primljeni članci",
"received articles tpl" => "primljeni članci tpl",
"received pages tpl" => "primljene strane tpl",
"Rename page" => "Promeni naziv strane",
"to_version" => "na_verziju",
"search stats tpl" => "pretraga statistika tpl",
"Admin Send Objects tpl" => "Admin pošalji objekte tpl",
"Stats for survey" => "Statistike anketa",
"Theme Control Center: categories" => "Kontrolni centar tema: kategorije",
"ThemeControl" => "Kontrola Tema",
"ThemeControl tpl" => "Kontrola tema tpl",
"ThemeControl Objects" => "ThemeControl objekti",
"theme control objects tpl" => "Kontrola tema objekti tpl",
"Theme Control Center: sections" => "Controlni centar tema: sekcije",
"theme control sections tpl" => "Kontrola tema sekcije tpl",
"File Title" => "Naslov fajla",
"Image Gallery tpl" => "Galerija slika tpl",
"User Assigned Modules" => "Korisnički dodeljeni moduli",
"User Assigned Modules tpl" => "Korisnički dodati moduli tpl",
"User Bookmarks tpl" => "Korisničke omiljene strane tpl",
"UserPreferences tpl" => "Korisnička podešavanja tpl",
"User Tasks tpl" => "Korisnički zadaci tpl",
"View FAQ Tpl" => "Vidi faq tpl",
"Admin Menus tpl" => "Admin meniji tpl",
"Add new mail account" => "Dodaj novi email nalog",
"User accounts" => "Korisnički nalozi",
"View All" => "Vidi sve",
"Msg" => "Poruka",
"Can't parse remote HTML page" => "Udaljena HTML strana ne može da se parsira",
"Permission denied you cannot remove pages" => "Nemate dozvolu da obrišete strane",
"OS" => "OS",
"Proxy Host" => "Proxy Host",
"Proxy port" => "Proxy port",
"LDAP Host" => "LDAP Host",
"LDAP Port" => "LDAP Port",
"Cannot write to this file" => "Ne mogu da pišem u ovaj fajl",
"Missing title or body when trying to post a comment" => "Fali naslov ili tekst poruke pri pisanju komentara",
"\\n for rows" => "\\n za redova",
"Newsletter subscription information at " => "Informacije o pretplatama na novine na ",
"categorize this object" => "kategorizuj ovaj objekat",
"Syntax highlighting" => "Obeležavanje sintakse",
"My Files" => "Moji fajlovi",
"Mini calendar" => "Mini kalendar",
"Send Pages" => "Pošalji strane",
"Received pages" => "Primljene strane",
"Admin Posts" => "Administriraj poruke",
"Submit a New Link" => "Predloži novi link",
"Browse directory" => "Pregledaj direktorijum",
"Admin Directory" => "Administriraj direktorijum",
"Layer Management" => "Menadžment slojeva",
"List quizzes" => "Lista kvizova",
"List trackers" => "Lista trakera",
"Debugger console" => "Debager konzola",
"I forgot my pass" => "Zaboravio sam svoju lozinku",
"Send trackback pings to:" => "Pošalji trackback pingove na:",
"(comma separated list of URIs)" => "(lista URLova razdvojenih zarezom)",
"This is" => "Ovo je",
"by the" => "od",
"Tiki community" => "Tiki društvo",
"Use URI as Home Page" => "Koristi URL kao glavnu stranu",
"Disallow access to the site (except for those with permission)" => "Zabrani pristup sajtu (osim onima koji imaju dozvolu)",
"Message to display when site is closed" => "Poruka za prikaz kada je sajt zatvoren",
"Disallow access when load is above the threshold (except for those with permission)" => "Zabrani pristup sajtu kada je opterećenje iznad odabranog (osim onima koji imaju dozvolu)",
"Max average server load threshold in the last minute" => "Maksimalno prosečno opterećenje servera u prošlom minutu",
"Message to display when server is too busy" => "Poruka za prikaz kada je server previše opterećen",
"Use cache for external images" => "Koristi skladište za spoljne slike",
"Use gzipped output" => "Koristi gzipovan izlaz",
"Sender Email" => "Email pošiljaoca",
"contact feature disabled" => "kontaktiranje je onemogućeno",
"Session lifetime in minutes" => "Trajanje sesija u minutima",
"User registration and login" => "Korisnička registracija i login",
"Use WebServer authentication for Tiki" => "Koristi WebServer autentikaciju za Tiki",
"Request passcode to register" => "Zahtevaj šifru za registraciju",
"Validate users by email" => "Potvrdite korisnike preko email-a",
"Store plaintext passwords" => "Snimi lozinke kao običan tekst",
"Reg users can change language" => "Registrovani korisnici mogu da menjaju jezik",
"Force to use chars and nums in passwords" => "Forsiraj korišćenje karaktera i brojeva u lozinkama",
"Minimum password length" => "Minimalna dužina lozinke",
"Password invalid after days" => "Lozinka ne važi nakon koliko dana",
"Remember me feature" => "Zapamti me osobenost",
"Duration:" => "Trajanje:",
"Remember me domain" => "Domen za Zapamti me",
"Remember me path" => "URL za Zapamti me",
"Create user if not in Tiki?" => "Napravi korisnika ako nije u Tikiju?",
"Create user if not in Auth?" => "Napravi korisnika ako nije u Auth?",
"Just use Tiki auth for admin?" => "Koristi samo Tiki auth za administraciju?",
"LDAP Scope" => "LDAP Okvir",
"LDAP Base DN" => "LDAP Bazni DN",
"LDAP User DN" => "LDAP Korisnički DN",
"LDAP User Attribute" => "LDAP Korisnički atributi",
"LDAP User OC" => "LDAP Korisnički OC",
"LDAP Group DN" => "LDAP Grupni DN",
"LDAP Group Attribute" => "LDAP Grupni atributi",
"LDAP Group OC" => "LDAP Grupni OC",
"LDAP Member Attribute" => "LDAP Atribut člana",
"LDAP Member Is DN" => "LDAP Član je DN",
"LDAP Admin User" => "LDAP Administracija korisnika",
"LDAP Admin Pwd" => "LDAP Administracija lozinki",
"Allow Smileys" => "Omogući smajlije",
"Hotwords in New Windows" => "Aktivne reči u novom prozoru",
"restore" => "vrati",
"Wiki Home Page" => "Wiki Glavna Strana",
"Wiki Discussion" => "Wiki diskusija",
"Wiki Features" => "Wiki osobine",
"Wiki History" => "Wiki istorija",
"Wiki Watch" => "Wiki Nadgledanje",
"Admin Charts" => "Admnistriraj grafik",
"Add new rule" => "Dodaj novo pravilo",
"EMail notifications" => "E-Mail obaveštenja",
"Edit this RSS module:" => "Izmeni ovaj RSS modul:",
"Create new RSS module" => "Napravi novi RSS modul",
"Create/edit questions for survey" => "Napravi/izmeni pitanja u anketi",
"Active?" => "Aktivna?",
"Create/Edit Trackers" => "Napravi/izmeni traker",
"Browse gallery" => "Gledaj galeriju",
"Upload from disk" => "Dodaj sa hard diska",
"Browsing Image" => "Gledanje slika",
"Again please" => "Još jednom",
"Admin category relationships" => "Administriraj odnose između kategorija",
"Validate links" => "Proveri linkove",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "Fajlovi sa imenima koja se završavaju sa -{\$user} se mogu menjati, a ostali se mogu samo kopirati i koristiti kao model.",
"Im- Export Languages" => "Uvezi/Izvezi jezike",
"Create a file gallery" => "Napravi galeriju fajlova",
"Support tickets" => "Linije za podršku",
"Return to HomePage" => "Vrati se na GlavnuStranu",
"Stats for this survey Questions " => "Statistike ovog pitanja ankete",
"Batch upload" => "Grupni upload",
"Minor Edit" => "Manji",
"You can not download files" => "Ne možete da preuzimate fajlove",
"Please wait 2 minutes between posts" => "Sačekajte 2 minuta između poruka",
"Show Categories" => "Prikaži kategorije",
"Hide Categories" => "Sakrij kategorije",
"Blog features" => "Osobine bloga",
"Blog level comments" => "Komentari na nivou bloga",
"Post level comments" => "Komentari na nivou poruke",
"Spellchecking" => "Provera pravopisa",
"Default ordering for blog listing" => "Podrazumevano sortiranje za listu blogova",
"Blog listing configuration (when listing available blogs)" => "Konfiguracija listanja bloga (kada se listaju mogući blogovi)",
"Blog comments settings" => "Podešavanja komentara blogova",
"Show Category Path" => "Prikaži put do kategorije",
"Show Category Objects" => "Prikaži objekte u kategoriji",
"CMS features" => "CMS osobine",
"Use templates" => "Koristi šablone",
"Maximum number of articles in home" => "Maksimalan broj artikala na glavnoj strani",
"Article comments settings" => "Podešavanja komentara članaka",
"Fields to display on page" => "Polja za prikaz na strani",
"Expire Date" => "Datum isticanja",
"Copyright Management" => "Menadžment autorskih prava",
"License Page" => "Strana za licencama",
"Submit Notice" => "Obaveštenje o predlogu",
"Uploaded filenames must match regex" => "Imena uploadovanih fajlova moraju da odgovaraju regex-u",
"Uploaded filenames cannot match regex" => "Imena uploadovanih fajlova moraju da odgovaraju regex-u",
"File galleries comments settings" => "Podešavanja komentara galerija fajlova",
"Forum quick jumps" => "Brzi skokovi na forumu",
"Ordering for forums in the forum listing" => "Sortiranje foruma u spisku foruma",
"Forum listing configuration" => "Konfiguracija liste foruma",
"Show Babelfish Translation URLs" => "Prikaži Babelfish URL za prevođenje",
"Show Babelfish Translation Logo" => "Prikaži Babelfish Logo za prevođenje",
"Show Module Controls" => "Prikaži kontrole modula",
"Users can Configure Modules" => "Korisnici mogu da podešavaju module",
"SearchStats" => "Statistike pretrage",
"this survey stats" => "Statistike ove ankete",
"bold" => "zatamnjena",
"theme" => "teme",
"unread private messages" => "neproitanih privatnih poruka",
"chat" => "chat",
"you or someone registered this email address at" => "vi ili neko drugi je registrovao ovu email adresu na",
"Your Tiki information registration" => "Registracija vaših Tiki informacija",
"left/right" => "levo/desno ",
"Unassign module" => "Nedodeljen modul",
"home" => "glavna strana",
"contact us" => "Kontaktirajte nas",
"debugger console" => "debager konzola",
"MyMenu" => "MojMeni",
"User menu" => "Korisnički meni",
"WfMenu" => "WfMeni",
"WikiMenu" => "WikiMeni",
"dump" => "ostava",
"rankings" => "rangiranja",
"orphan pages" => "strane bez roditelja",
"sandbox" => "igraonica",
"received pages" => "primljene strane",
"structures" => "strukture",
"GalMenu" => "GalMeni",
"Articles Home" => "Početna strana Članaka",
"Send articles" => "Pošalji članke",
"Create/Edit Blog" => "Napravi/Izmeni Blog",
"ForMenu" => "ForMeni",
"DirMenu" => "DirMeni",
"Browse Directory" => "Gledaj direktorijum",
"FileGalMenu" => "FileGalMeni",
"Admin FAQs" => "Admin FAQ",
"Edit mapfiles" => "Izmeni map fajlove",
"QuizMenu" => "QuizMeni",
"Admin quiz" => "Administriraj kviz",
"TrkMenu" => "TrkMeni",
"Admin trackers" => "Administracija trakera",
"SrvMenu" => "SrvMeni",
"Send newsletters" => "Pošalji novine",
"EphMenu" => "EphMeni",
"Ephemerides" => "Efemeride",
"ChartMenu" => "ChartMeni",
"AdmMenu" => "AdmMeni",
"Backups" => "Bekapovi",
"Edit languages" => "Izmeni jezike",
"External wikis" => "Spoljni Wiki",
"UsrMenu" => "UsrMeni",
"Click here to manage your personal menu" => "Klikni ovde da izmeniš svoj meni",
"Quick edit a Wiki page" => "Brzo izmeni Wiki stranu",
"Language: " => "Jezik: ",
"Sort posts by:" => "Sortiraj poruke po:",
"read more" => "čitaj još",
"Pass" => "Propusti",
"some text" => "neki tekst",
"Creates a box with the data" => "Pravi okvir sa podacima",
"creates a title bar" => "pravi naslovnu liniju",
"creates a table" => "pravi tabelu",
"makes a horizontal rule" => "napravi horizontalnu liniju",
"page|desc" => "strana|opis",
"displays an image" => "prikazuje sliku",
"Non cacheable images" => "Slike koje se ne skladište",
"height width desc link and align are optional" => "visina širina opis link i poravnjanje su opcioni",
"displays rss feed with id=n maximum=m items" => "prikazuje rss izvore sa id=n maksimalno=m stvari",
"Will be replaced by the actual value of the dynamic content block with id=n" => "Biće zamenjeno stvarnim sadržajem dinamičkog bloka sa id=n",
"Misc" => "Ostalo",
"Click to Navigate" => "Klikni za navigaciju",
"Tiki Shoutbox" => "Tiki Shoutbox",
"Tiki email notification" => "Tiki email obaveštenja",
"Reg users can change theme" => "Registrovani korisnici mogu da menjaju teme",
"Create/Edit Newsletters" => "Napravi/izmeni novine",
"Allow sites in this category" => "Dozvoli sajtove u ovoj kategoriji",
"Show number of sites in this category" => "Prikaži broj sajtova u ovoj kategoriji",
"Subcategories" => "Podkategorije",
"Admin related categories" => "Administriraj srodne kategorije",
"in current category" => "u trenuntoj kategoriji",
"Total categories" => "Ukupno kategorija",
"Days online" => "Dana onlajn",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "Cookies must be allowed to vote" => "Cookies must be allowed to vote",
// "This forum is flat and doesn't allow replies to other replies" => "This forum is flat and doesn't allow replies to other replies",
// "This script cannot be called directly" => "This script cannot be called directly",
// "Copyright management" => "Copyright management",
// "Tiki is unable to connect to the database " => "Tiki is unable to connect to the database ",
// "Tiki was unable to retrieve login data from the database " => "Tiki was unable to retrieve login data from the database ",
// "The following error message was returned" => "The following error message was returned",
// "Things to check" => "Things to check",
// "Is your database up and running" => "Is your database up and running",
// "Are your database login credentials correct" => "Are your database login credentials correct",
// "Did you complete the <a href='tiki-install.php' >Tiki Installer" => "Did you complete the <a href='tiki-install.php' >Tiki Installer",
// "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information" => "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information",
// "This feature is for admins only" => "This feature is for admins only",
// "Uploaded" => "Uploaded",
// "Last editor" => "Last editor",
// "Explorer" => "Explorer",
// "Slideshow" => "Slideshow",
// "Default View" => "Default View",
// "Afghanistan" => "Afghanistan",
// "Aland Islands" => "Aland Islands",
// "Aland_Islands" => "Aland_Islands",
// "Albania" => "Albania",
// "Algeria" => "Algeria",
// "American Samoa" => "American Samoa",
// "American_Samoa" => "American_Samoa",
// "Andorra" => "Andorra",
// "Angola" => "Angola",
// "Anguilla" => "Anguilla",
// "Antigua" => "Antigua",
// "Argentina" => "Argentina",
// "Armenia" => "Armenia",
// "Aruba" => "Aruba",
// "Australia" => "Australia",
// "Austria" => "Austria",
// "Azerbaijan" => "Azerbaijan",
// "Bahamas" => "Bahamas",
// "Bahrain" => "Bahrain",
// "Bangladesh" => "Bangladesh",
// "Barbados" => "Barbados",
// "Belarus" => "Belarus",
// "Belgium" => "Belgium",
// "Belize" => "Belize",
// "Benin" => "Benin",
// "Bermuda" => "Bermuda",
// "Bhutan" => "Bhutan",
// "Bolivia" => "Bolivia",
// "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
// "Bosnia_and_Herzegovina" => "Bosnia_and_Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "Bouvet_Island" => "Bouvet_Island",
// "Brazil" => "Brazil",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "British_Indian_Ocean_Territory" => "British_Indian_Ocean_Territory",
// "British_Virgin_Islands" => "British_Virgin_Islands",
// "Brunei" => "Brunei",
// "Bulgaria" => "Bulgaria",
// "Burkina Faso" => "Burkina Faso",
// "Burkina_Faso" => "Burkina_Faso",
// "Burundi" => "Burundi",
// "Cambodia" => "Cambodia",
// "Cameroon" => "Cameroon",
// "Canada" => "Canada",
// "Cape Verde" => "Cape Verde",
// "Cape_Verde" => "Cape_Verde",
// "Catalan Countries" => "Catalan Countries",
// "Catalan_Countries" => "Catalan_Countries",
// "Cayman Islands" => "Cayman Islands",
// "Cayman_Islands" => "Cayman_Islands",
// "Central African Republic" => "Central African Republic",
// "Central_African_Republic" => "Central_African_Republic",
// "Chad" => "Chad",
// "Chile" => "Chile",
// "China" => "China",
// "Christmas Island" => "Christmas Island",
// "Christmas_Island" => "Christmas_Island",
// "Cocos Islands" => "Cocos Islands",
// "Cocos_Islands" => "Cocos_Islands",
// "Colombia" => "Colombia",
// "Comoros" => "Comoros",
// "Congo Democratic" => "Congo Democratic",
// "Congo" => "Congo",
// "Congo_Democratic" => "Congo_Democratic",
// "Cook Islands" => "Cook Islands",
// "Cook_Islands" => "Cook_Islands",
// "Costa Rica" => "Costa Rica",
// "Costa_Rica" => "Costa_Rica",
// "Croatia" => "Croatia",
// "Cuba" => "Cuba",
// "Cyprus" => "Cyprus",
// "Czech Republic" => "Czech Republic",
// "Czech_Republic" => "Czech_Republic",
// "Denmark" => "Denmark",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Dominican Republic" => "Dominican Republic",
// "Dominican_Republic" => "Dominican_Republic",
// "Ecuador" => "Ecuador",
// "Egypt" => "Egypt",
// "El Salvador" => "El Salvador",
// "El_Salvador" => "El_Salvador",
// "Equatorial Guinea" => "Equatorial Guinea",
// "Equatorial_Guinea" => "Equatorial_Guinea",
// "Eritrea" => "Eritrea",
// "Estonia" => "Estonia",
// "Ethiopia" => "Ethiopia",
// "Europe" => "Europe",
// "Falkland Islands" => "Falkland Islands",
// "Falkland_Islands" => "Falkland_Islands",
// "Faroe Islands" => "Faroe Islands",
// "Faroe_Islands" => "Faroe_Islands",
// "Federated States of Micronesia" => "Federated States of Micronesia",
// "Federated_States_of_Micronesia" => "Federated_States_of_Micronesia",
// "Fiji" => "Fiji",
// "Finland" => "Finland",
// "France" => "France",
// "French Guiana" => "French Guiana",
// "French Polynesia" => "French Polynesia",
// "French Southern Territories" => "French Southern Territories",
// "French_Guiana" => "French_Guiana",
// "French_Polynesia" => "French_Polynesia",
// "French_Southern_Territories" => "French_Southern_Territories",
// "Gabon" => "Gabon",
// "Gambia" => "Gambia",
// "Georgia" => "Georgia",
// "Germany" => "Germany",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greece" => "Greece",
// "Greenland" => "Greenland",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guam" => "Guam",
// "Guatemala" => "Guatemala",
// "Guernsey" => "Guernsey",
// "Guinea Bissau" => "Guinea Bissau",
// "Guinea" => "Guinea",
// "Guinea_Bissau" => "Guinea_Bissau",
// "Guyana" => "Guyana",
// "Haiti" => "Haiti",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Heard_Island_and_McDonald_Islands" => "Heard_Island_and_McDonald_Islands",
// "Honduras" => "Honduras",
// "Hong Kong" => "Hong Kong",
// "Hong_Kong" => "Hong_Kong",
// "Hungary" => "Hungary",
// "Iceland" => "Iceland",
// "India" => "India",
// "Indonesia" => "Indonesia",
// "Iran" => "Iran",
// "Iraq" => "Iraq",
// "Ireland" => "Ireland",
// "Isle of Man" => "Isle of Man",
// "Israel" => "Israel",
// "Italy" => "Italy",
// "Ivory Coast" => "Ivory Coast",
// "Ivory_Coast" => "Ivory_Coast",
// "Jamaica" => "Jamaica",
// "Japan" => "Japan",
// "Jersey" => "Jersey",
// "Jordan" => "Jordan",
// "Kazakstan" => "Kazakstan",
// "Kenya" => "Kenya",
// "Kiribati" => "Kiribati",
// "Kuwait" => "Kuwait",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Latvia" => "Latvia",
// "Lebanon" => "Lebanon",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Lithuania" => "Lithuania",
// "Luxemburg" => "Luxemburg",
// "Macao" => "Macao",
// "Macedonia" => "Macedonia",
// "Madagascar" => "Madagascar",
// "Malawi" => "Malawi",
// "Malaysia" => "Malaysia",
// "Maldives" => "Maldives",
// "Mali" => "Mali",
// "Malta" => "Malta",
// "Marshall Islands" => "Marshall Islands",
// "Marshall_Islands" => "Marshall_Islands",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mauritius" => "Mauritius",
// "Mayotte" => "Mayotte",
// "Mexico" => "Mexico",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Morocco" => "Morocco",
// "Mozambique" => "Mozambique",
// "Myanmar" => "Myanmar",
// "Namibia" => "Namibia",
// "Nauru" => "Nauru",
// "Nepal" => "Nepal",
// "Netherlands Antilles" => "Netherlands Antilles",
// "Netherlands" => "Netherlands",
// "Netherlands_Antilles" => "Netherlands_Antilles",
// "New Caledonia" => "New Caledonia",
// "New Zealand" => "New Zealand",
// "New_Caledonia" => "New_Caledonia",
// "New_Zealand" => "New_Zealand",
// "Nicaragua" => "Nicaragua",
// "Niger" => "Niger",
// "Nigeria" => "Nigeria",
// "Niue" => "Niue",
// "Norfolk Island" => "Norfolk Island",
// "Norfolk_Island" => "Norfolk_Island",
// "North Korea" => "North Korea",
// "North_Korea" => "North_Korea",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "Northern_Mariana_Islands" => "Northern_Mariana_Islands",
// "Norway" => "Norway",
// "Oman" => "Oman",
// "Other" => "Other",
// "Pakistan" => "Pakistan",
// "Palau" => "Palau",
// "Palestine" => "Palestine",
// "Panama" => "Panama",
// "Papua New Guinea" => "Papua New Guinea",
// "Papua_New_Guinea" => "Papua_New_Guinea",
// "Paraguay" => "Paraguay",
// "Peru" => "Peru",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Poland" => "Poland",
// "Portugal" => "Portugal",
// "Puerto Rico" => "Puerto Rico",
// "Puerto_Rico" => "Puerto_Rico",
// "Quatar" => "Quatar",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Republic_of_Macedonia" => "Republic_of_Macedonia",
// "Reunion" => "Reunion",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Russian Federation" => "Russian Federation",
// "Russian_Federation" => "Russian_Federation",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "Saint_Helena" => "Saint_Helena",
// "Saint_Kitts_and_Nevis" => "Saint_Kitts_and_Nevis",
// "Saint_Lucia" => "Saint_Lucia",
// "Saint_Pierre_and_Miquelon" => "Saint_Pierre_and_Miquelon",
// "Samoa" => "Samoa",
// "San Marino" => "San Marino",
// "San_Marino" => "San_Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Sao_Tome_and_Principe" => "Sao_Tome_and_Principe",
// "Saudi Arabia" => "Saudi Arabia",
// "Saudi_Arabia" => "Saudi_Arabia",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "Sierra_Leone" => "Sierra_Leone",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon Islands" => "Solomon Islands",
// "Solomon_Islands" => "Solomon_Islands",
// "Somalia" => "Somalia",
// "South Africa" => "South Africa",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "South Korea" => "South Korea",
// "South_Africa" => "South_Africa",
// "South_Georgia_and_South_Sandwich_Islands" => "South_Georgia_and_South_Sandwich_Islands",
// "South_Korea" => "South_Korea",
// "Spain" => "Spain",
// "Sri Lanka" => "Sri Lanka",
// "Sri_Lanka" => "Sri_Lanka",
// "St Vincent Grenadines" => "St Vincent Grenadines",
// "St_Vincent_Grenadines" => "St_Vincent_Grenadines",
// "Sudan" => "Sudan",
// "Surinam" => "Surinam",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Svalbard_and_Jan_Mayen" => "Svalbard_and_Jan_Mayen",
// "Swaziland" => "Swaziland",
// "Sweden" => "Sweden",
// "Switzerland" => "Switzerland",
// "Syria" => "Syria",
// "Taiwan" => "Taiwan",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Thailand" => "Thailand",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Tonga" => "Tonga",
// "Trinidad Tobago" => "Trinidad Tobago",
// "Trinidad_Tobago" => "Trinidad_Tobago",
// "Tunisia" => "Tunisia",
// "Turkey" => "Turkey",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Turks_and_Caicos_Islands" => "Turks_and_Caicos_Islands",
// "Tuvalu" => "Tuvalu",
// "US Virgin Islands" => "US Virgin Islands",
// "US_Virgin_Islands" => "US_Virgin_Islands",
// "Uganda" => "Uganda",
// "Ukraine" => "Ukraine",
// "United Arab Emirates" => "United Arab Emirates",
// "United Kingdom" => "United Kingdom",
// "United Nations Organization" => "United Nations Organization",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "United States" => "United States",
// "United_Arab_Emirates" => "United_Arab_Emirates",
// "United_Kingdom" => "United_Kingdom",
// "United_Kingdom_-_England_and_Wales" => "United_Kingdom_-_England_and_Wales",
// "United_Kingdom_-_Northern_Ireland" => "United_Kingdom_-_Northern_Ireland",
// "United_Kingdom_-_Scotland" => "United_Kingdom_-_Scotland",
// "United_Nations_Organization" => "United_Nations_Organization",
// "United_States" => "United_States",
// "United_States_Minor_Outlying_Islands" => "United_States_Minor_Outlying_Islands",
// "Uruguay" => "Uruguay",
// "Uzbekistan" => "Uzbekistan",
// "Vanuatu" => "Vanuatu",
// "Vatican" => "Vatican",
// "Venezuela" => "Venezuela",
// "Viet Nam" => "Viet Nam",
// "Viet_Nam" => "Viet_Nam",
// "Wales" => "Wales",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Wallis_and_Futuna" => "Wallis_and_Futuna",
// "Western Sahara" => "Western Sahara",
// "Western_Sahara" => "Western_Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
// "the former Yugoslav Republic of Macedonia" => "the former Yugoslav Republic of Macedonia",
// "the_former_Yugoslav_Republic_of_Macedonia" => "the_former_Yugoslav_Republic_of_Macedonia",
// "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter" => "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter",
// "MySQL Improved (mysqli). Requires MySQL 4.1+" => "MySQL Improved (mysqli). Requires MySQL 4.1+",
// "MySQL classic (mysql)" => "MySQL classic (mysql)",
// "PostgeSQL 7.2+" => "PostgeSQL 7.2+",
// "Oracle" => "Oracle",
// "Sybase" => "Sybase",
// "SQLLite" => "SQLLite",
// "MSSQL" => "MSSQL",
// "Email address not valid, test mail not sent" => "Email address not valid, test mail not sent",
// "Email address empty and \"copy\" checkbox not set, test mail not sent" => "Email address empty and \"copy\" checkbox not set, test mail not sent",
// "Test mail from Tiki installer " => "Test mail from Tiki installer ",
// "Tiki version" => "Tiki version",
// "PHP version" => "PHP version",
// "Server" => "Server",
// "Sent" => "Sent",
// "Congratulations!\n\nYour server can send emails.\n\n" => "Congratulations!\n\nYour server can send emails.\n\n",
// "Slovene" => "Slovene",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "Simplified Chinese" => "Simplified Chinese",
// "Chinese" => "Chinese",
// "Czech" => "Czech",
// "Danish" => "Danish",
// "German" => "German",
// "English" => "English",
// "English British" => "English British",
// "Spanish" => "Spanish",
// "Greek" => "Greek",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Fijian" => "Fijian",
// "French" => "French",
// "Galician" => "Galician",
// "Hebrew" => "Hebrew",
// "Croatian" => "Croatian",
// "Italian" => "Italian",
// "Japanese" => "Japanese",
// "Korean" => "Korean",
// "Hungarian" => "Hungarian",
// "Dutch" => "Dutch",
// "Norwegian" => "Norwegian",
// "Polish" => "Polish",
// "Português" => "Português",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Russian" => "Russian",
// "Pijin Solomon" => "Pijin Solomon",
// "Slovak" => "Slovak",
// "Serbian" => "Serbian",
// "Serbian Latin" => "Serbian Latin",
// "Swedish" => "Swedish",
// "Tuvaluan" => "Tuvaluan",
// "Traditional Chinese" => "Traditional Chinese",
// "Ukrainian" => "Ukrainian",
// "This instance of activity is already complete" => "This instance of activity is already complete",
// "newest" => "newest",
// "oldest" => "oldest",
// "on left side" => "on left side",
// "on center" => "on center",
// "on right side" => "on right side",
// "as Creator &amp; Last Editor" => "as Creator &amp; Last Editor",
// "Business style" => "Business style",
// "Collaborative style" => "Collaborative style",
// "Page last modified on" => "Page last modified on",
// "no (disabled)" => "no (disabled)",
// "Only with last version" => "Only with last version",
// "Any 2 versions" => "Any 2 versions",
// "latin" => "latin",
// "english" => "english",
// "Day" => "Day",
// "Week" => "Week",
// "Month" => "Month",
// "Quarter" => "Quarter",
// "Semester" => "Semester",
// "Depends user language" => "Depends user language",
// "No error reporting" => "No error reporting",
// "Report all PHP errors" => "Report all PHP errors",
// "Report all errors except notices" => "Report all errors except notices",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
// "Each day" => "Each day",
// "Each week" => "Each week",
// "Each month" => "Each month",
// "utf-8" => "utf-8",
// "iso-8859-1" => "iso-8859-1",
// "CRLF (standard)" => "CRLF (standard)",
// "LF (some Unix MTA)" => "LF (some Unix MTA)",
// "15 minutes" => "15 minutes",
// "30 minutes" => "30 minutes",
// "1 hour" => "1 hour",
// "2 hours" => "2 hours",
// "10 hours" => "10 hours",
// "20 hours" => "20 hours",
// "1 year" => "1 year",
// "Encourage secure (https) login" => "Encourage secure (https) login",
// "Consider we are always in HTTPS, but do not check" => "Consider we are always in HTTPS, but do not check",
// "crypt-md5" => "crypt-md5",
// "crypt-des" => "crypt-des",
// "tikihash (old)" => "tikihash (old)",
// "Tiki and PAM" => "Tiki and PAM",
// "CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
// "Shibboleth" => "Shibboleth",
// "OpenID and Tiki" => "OpenID and Tiki",
// "choose a group .." => "choose a group ..",
// "Registered" => "Registered",
// "Admins" => "Admins",
// "Never use transition css" => "Never use transition css",
// "Use @version:x.x specified in theme css or none if not specified" => "Use @version:x.x specified in theme css or none if not specified",
// "Use @version:x.x specified in theme css or 1.9 if not specified" => "Use @version:x.x specified in theme css or 1.9 if not specified",
// "Use @version:x.x specified in theme css or 2.0 if not specified" => "Use @version:x.x specified in theme css or 2.0 if not specified",
// "LastModif" => "LastModif",
// "Ascending" => "Ascending",
// "Descending" => "Descending",
// "No forums" => "No forums",
// "%s enabled" => "%s enabled",
// "\$feature is turned on" => "\$feature is turned on",
// "%s disabled" => "%s disabled",
// "\$feature is turned off" => "\$feature is turned off",
// "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing" => "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing",
// "\$feature set to nothing" => "\$feature set to nothing",
// "Template %s not registered" => "Template %s not registered",
// "Error line: %d" => "Error line: %d",
// "All Day" => "All Day",
// "file gallery" => "file gallery",
// "image gallery" => "image gallery",
// "newsletter" => "newsletter",
// "survey" => "survey",
// "wiki page" => "wiki page",
// "(not registered)" => "(not registered)",
// "You have mistyped the anti-bot verification code; please try again" => "You have mistyped the anti-bot verification code; please try again",
// "Please wait %d secondes between posts" => "Please wait %d secondes between posts",
// "A contribution is mandatory" => "A contribution is mandatory",
// "Invalid Email" => "Invalid Email",
// "Your message has been queued for approval, the message will be posted after a moderator approves it" => "Your message has been queued for approval, the message will be posted after a moderator approves it",
// "This forum is locked" => "This forum is locked",
// "This thread is locked" => "This thread is locked",
// "Those comments are locked" => "Those comments are locked",
// "Foo" => "Foo",
// "Sample plugin" => "Sample plugin",
// "Face" => "Face",
// "Font family to use" => "Font family to use",
// "As defined by CSS" => "As defined by CSS",
// "Line" => "Line",
// "Lines" => "Lines",
// "Newsletter subscription information at" => "Newsletter subscription information at",
// "Tiki Link - Insert internal link" => "Tiki Link - Insert internal link",
// "Select a Wiki page to link to" => "Select a Wiki page to link to",
// "Cannot open this file" => "Cannot open this file",
// "This is an approximation based on your server memory limit" => "This is an approximation based on your server memory limit",
// "This is the value of your server's PHP '%s' setting" => "This is the value of your server's PHP '%s' setting",
// "You are alerted by the server " => "You are alerted by the server ",
// "You can check the modifications at : " => "You can check the modifications at : ",
// "You are alerted of a change on " => "You are alerted of a change on ",
// "Continue" => "Continue",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "Contributions" => "Contributions",
// "Query point" => "Query point",
// "layer" => "layer",
// "Record" => "Record",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
// "User Map Generated in" => "User Map Generated in",
// "Image Map Generated in" => "Image Map Generated in",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it" => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it",
// "menu" => "menu",
// "File %s not found" => "File %s not found",
// "File %s is not a valid archive" => "File %s is not a valid archive",
// "Impossible to open %s : %s" => "Impossible to open %s : %s",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "section edit" => "section edit",
// "This poll is closed" => "This poll is closed",
// "Created by profile installer" => "Created by profile installer",
// "Page updated by profile installer" => "Page updated by profile installer",
// "Forums last posts" => "Forums last posts",
// "The passwords do not match" => "The passwords do not match",
// "The registration mail can't be sent. Contact the administrator" => "The registration mail can't be sent. Contact the administrator",
// "Feed provided by %s. Click to visit" => "Feed provided by %s. Click to visit",
// "See other user's profile" => "See other user's profile",
// "Have your profile seen" => "Have your profile seen",
// "Make friends" => "Make friends",
// "Receive message" => "Receive message",
// "Read an article" => "Read an article",
// "Publish an article" => "Publish an article",
// "Have your article read" => "Have your article read",
// "Create new file gallery" => "Create new file gallery",
// "Upload new file to gallery" => "Upload new file to gallery",
// "Download other user's file" => "Download other user's file",
// "Have your file downloaded" => "Have your file downloaded",
// "Create a new image gallery" => "Create a new image gallery",
// "Upload new image to gallery" => "Upload new image to gallery",
// "See other user's gallery" => "See other user's gallery",
// "See other user's image" => "See other user's image",
// "Have your gallery seen by other user" => "Have your gallery seen by other user",
// "Have your image seen" => "Have your image seen",
// "Create new blog" => "Create new blog",
// "Post in a blog" => "Post in a blog",
// "Read other user's blog" => "Read other user's blog",
// "Have your blog read" => "Have your blog read",
// "Create a new wiki page" => "Create a new wiki page",
// "Edit an existing page" => "Edit an existing page",
// "Trackeritem" => "Trackeritem",
// "Wiki Comment" => "Wiki Comment",
// "Calendar item" => "Calendar item",
// "Tracker item" => "Tracker item",
// "Simple" => "Simple",
// "Advanced" => "Advanced",
// "_HOMEPAGE_CONTENT_" => "_HOMEPAGE_CONTENT_",
// "<!-- jq smarty plugin inactive: feature_jquery off -->" => "<!-- jq smarty plugin inactive: feature_jquery off -->",
// "Fast Next" => "Fast Next",
// "Fast Prev" => "Fast Prev",
// "First {\$params['itemname']}" => "First {\$params['itemname']}",
// "Last {\$params['itemname']}" => "Last {\$params['itemname']}",
// "Next {\$params['itemname']}" => "Next {\$params['itemname']}",
// "Prev {\$params['itemname']}" => "Prev {\$params['itemname']}",
// "You need either JQuery or MooTools enabled for this feature" => "You need either JQuery or MooTools enabled for this feature",
// "Help page" => "Help page",
// "Admin Feature" => "Admin Feature",
// "The text is" => "The text is",
// "character(s) too long - please edit it" => "character(s) too long - please edit it",
// "phplayers are not available on this site" => "phplayers are not available on this site",
// "Select All" => "Select All",
// "Invert Sort" => "Invert Sort",
// "sec" => "sec",
// "Text cut here" => "Text cut here",
// "Task" => "Task",
// "End date" => "End date",
// "Gender" => "Gender",
// "User information - Click for more info" => "User information - Click for more info",
// "Friend" => "Friend",
// "km" => "km",
// "Last seen on" => "Last seen on",
// "(idle for %s seconds)" => "(idle for %s seconds)",
// "More info about \$other_user" => "More info about \$other_user",
// "(idle for \$idletime seconds)" => "(idle for \$idletime seconds)",
// "No pageviews yet" => "No pageviews yet",
// "n/a" => "n/a",
// "Use this tree to copy the structure" => "Use this tree to copy the structure",
// "Table of contents" => "Table of contents",
// "You have to make %d choice(s) for the question" => "You have to make %d choice(s) for the question",
// "You have to make at least %d choice(s) for the question" => "You have to make at least %d choice(s) for the question",
// "You have to make less than %d choice(s) for the question" => "You have to make less than %d choice(s) for the question",
// "You have to choose at least %d choice(s) for the question" => "You have to choose at least %d choice(s) for the question",
// "unknown error" => "unknown error",
// "Page '%0' cannot be found" => "Page '%0' cannot be found",
// "For the security of your password direct access to the feed is only available via https" => "For the security of your password direct access to the feed is only available via https",
// "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors" => "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors",
// "An error occured in a database query" => "An error occured in a database query",
// "Help link" => "Help link",
// "img-g" => "img-g",
// "file-g" => "file-g",
// "arts" => "arts",
// "Edit Plugin" => "Edit Plugin",
// "Edit Section" => "Edit Section",
// "index" => "index",
// "Show" => "Show",
// "You are not allowed to upload this type of file" => "You are not allowed to upload this type of file",
// "The file you are trying upload was only partially uploaded" => "The file you are trying upload was only partially uploaded",
// "You must select a file" => "You must select a file",
// "Flash player not available" => "Flash player not available",
// "Altering database table failed" => "Altering database table failed",
// "%d points" => "%d points",
// "Removed" => "Removed",
// "__WARNING__: Plugin disabled \$plugin" => "__WARNING__: Plugin disabled \$plugin",
// "__WARNING__: No such module \$plugin" => "__WARNING__: No such module \$plugin",
// "Create page" => "Create page",
// "Click here to confirm your action" => "Click here to confirm your action",
// "Sea Surfing (CSRF) detected. Operation blocked" => "Sea Surfing (CSRF) detected. Operation blocked",
// "Upload was not successful. Duplicate file content " => "Upload was not successful. Duplicate file content ",
// "Item Modification" => "Item Modification",
// "Item creation" => "Item creation",
// "View the tracker item at" => "View the tracker item at",
// "Field is not numeric" => "Field is not numeric",
// "Field is not a link to mp3 in the gallery" => "Field is not a link to mp3 in the gallery",
// "Field is not a link to FLV in the gallery" => "Field is not a link to FLV in the gallery",
// "Field is not a link to FLV or MP3 in the gallery" => "Field is not a link to FLV or MP3 in the gallery",
// "half column" => "half column",
// "prepend" => "prepend",
// "append" => "append",
// "max" => "max",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>",
// "numeric field" => "numeric field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "drop down with other textfield" => "drop down with other textfield",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "radio buttons" => "radio buttons",
// "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>",
// "ip selector" => "ip selector",
// "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>",
// "page selector" => "page selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "country selector" => "country selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>",
// "jscalendar" => "jscalendar",
// "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "header" => "header",
// "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>",
// "static text" => "static text",
// "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "item link" => "item link",
// "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "items list" => "items list",
// "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "dynamic items list" => "dynamic items list",
// "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "multimedia" => "multimedia",
// "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>",
// "auto-increment" => "auto-increment",
// "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "user subscription" => "user subscription",
// "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>",
// "Google Maps" => "Google Maps",
// "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>",
// "system" => "system",
// "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>",
// "computed field" => "computed field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>",
// "user preference" => "user preference",
// "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "pending" => "pending",
// "No extra information for that attached file. " => "No extra information for that attached file. ",
// "The administrator has not yet validated your account. Please wait" => "The administrator has not yet validated your account. Please wait",
// "You must validate your account first. An email has been sent to you" => "You must validate your account first. An email has been sent to you",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "The user email confirmation can't be sent. Contact the administrator" => "The user email confirmation can't be sent. Contact the administrator",
// "Personal Phone" => "Personal Phone",
// "Personal Mobile" => "Personal Mobile",
// "Personal Fax" => "Personal Fax",
// "Work Phone" => "Work Phone",
// "Work Mobile" => "Work Mobile",
// "Work Fax" => "Work Fax",
// "Company" => "Company",
// "Organization" => "Organization",
// "Department" => "Department",
// "Division" => "Division",
// "Job Title" => "Job Title",
// "Street Address" => "Street Address",
// "City" => "City",
// "State" => "State",
// "Zip Code" => "Zip Code",
// "User-Agent Info" => "User-Agent Info",
// "Displays various information about the client" => "Displays various information about the client",
// "Info" => "Info",
// "Info required - IP|SVRSW|BROWSER" => "Info required - IP|SVRSW|BROWSER",
// "Displays browser client info" => "Displays browser client info",
// "Anchor Link" => "Anchor Link",
// "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin" => "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin",
// "Anchor link label" => "Anchor link label",
// "The anchor name as defined in the ANAME plugin" => "The anchor name as defined in the ANAME plugin",
// "The name of the wiki page containing the anchor" => "The name of the wiki page containing the anchor",
// "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor",
// "linktext" => "linktext",
// "Anchor Name" => "Anchor Name",
// "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin" => "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin",
// "The name of the anchor" => "The name of the anchor",
// "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor",
// "Image Annotation" => "Image Annotation",
// "Autogenerated content. Leave blank initially" => "Autogenerated content. Leave blank initially",
// "Absolute URL to the image or relative path from tikiwiki root" => "Absolute URL to the image or relative path from tikiwiki root",
// "Width" => "Width",
// "Image width" => "Image width",
// "Height" => "Height",
// "Image height" => "Image height",
// "Alignment" => "Alignment",
// "Image alignment. Possible values: left, right, center" => "Image alignment. Possible values: left, right, center",
// "Save changes to annotations" => "Save changes to annotations",
// "Image annotations changed" => "Image annotations changed",
// "Creates an annotation block for an image" => "Creates an annotation block for an image",
// "Displays an image and allow the users to define zones to highlight information on the image" => "Displays an image and allow the users to define zones to highlight information on the image",
// "Includes an article\\'s content within the page" => "Includes an article\\'s content within the page",
// "Field" => "Field",
// "The article field to display. Default field is Heading" => "The article field to display. Default field is Heading",
// "Article ID" => "Article ID",
// "The article to display. If no value is provided, most recent article will be used" => "The article to display. If no value is provided, most recent article will be used",
// "Includes an article" => "Includes an article",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading" => "Id is optional. If not given, last article is used. Default field is heading",
// "Article List" => "Article List",
// "Includes a list of articles within the page" => "Includes a list of articles within the page",
// "Articles displayed" => "Articles displayed",
// "The amount of articles to display in the list" => "The amount of articles to display in the list",
// "Topics expression" => "Topics expression",
// "Topic ID expression" => "Topic ID expression",
// "Type expression" => "Type expression",
// "Category ID" => "Category ID",
// "The ID of the category to list from" => "The ID of the category to list from",
// "The article language to list" => "The article language to list",
// "Sort order" => "Sort order",
// "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")" => "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")",
// "Quiet" => "Quiet",
// "Whether to not report when there are no articles" => "Whether to not report when there are no articles",
// "Title only" => "Title only",
// "Whether to only show the title of the articles" => "Whether to only show the title of the articles",
// "Show body" => "Show body",
// "Whether to only show the body of the articles or just the heading" => "Whether to only show the body of the articles or just the heading",
// "Starting article" => "Starting article",
// "The article number that the list should start with" => "The article number that the list should start with",
// "Earliest date to select articles from" => "Earliest date to select articles from",
// "Latest date to select articles from" => "Latest date to select articles from",
// "Override Dates" => "Override Dates",
// "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings" => "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings",
// "Container class" => "Container class",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~",
// "Bullets" => "Bullets",
// "Inline" => "Inline",
// "Number" => "Number",
// "Show icon" => "Show icon",
// "No such attachment on this page" => "No such attachment on this page",
// "Displays an attachment or a list of them" => "Displays an attachment or a list of them",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Same as name" => "Same as name",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description" => "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "Shows a file icon" => "Shows a file icon",
// "The wiki page the avatar will link to" => "The wiki page the avatar will link to",
// "Float" => "Float",
// "left|right" => "left|right",
// "Displays a link that allows to go back in the browser history" => "Displays a link that allows to go back in the browser history",
// "Insert back link on wiki page" => "Insert back link on wiki page",
// "List all pages linking to the specified page" => "List all pages linking to the specified page",
// "The page links will point to. Default value is the current page" => "The page links will point to. Default value is the current page",
// "Displayed information" => "Displayed information",
// "Pipe separated list of fields to display. ex: hits|user" => "Pipe separated list of fields to display. ex: hits|user",
// "Excluded pages" => "Excluded pages",
// "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox" => "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox",
// "Include Self" => "Include Self",
// "1|0" => "1|0",
// "No Header" => "No Header",
// "Banner" => "Banner",
// "Insert a banner" => "Insert a banner",
// "Target" => "Target",
// "missing parameter" => "missing parameter",
// "Blog List" => "Blog List",
// "Use BLOGLIST to include posts from a blog" => "Use BLOGLIST to include posts from a blog",
// "Blog ID" => "Blog ID",
// "Numeric value" => "Numeric value",
// "Maximum number of entries to list" => "Maximum number of entries to list",
// "Simple list" => "Simple list",
// "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)" => "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)",
// "Earliest date to select posts from" => "Earliest date to select posts from",
// "Latest date to select posts from" => "Latest date to select posts from",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")",
// "Use BLOGLIST to include posts from a blog. Syntax is" => "Use BLOGLIST to include posts from a blog. Syntax is",
// "where Id is the blog Id and Items is the max number of posts to display" => "where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Box" => "Box",
// "Box title" => "Box title",
// "Displayed above the content" => "Displayed above the content",
// "Background color" => "Background color",
// "As defined by CSS, name or Hex code" => "As defined by CSS, name or Hex code",
// "Box width" => "Box width",
// "In pixels or percentage. Default value is 100%" => "In pixels or percentage. Default value is 100%",
// "Text Alignment" => "Text Alignment",
// "Float Position" => "Float Position",
// "for box with width lesser than 100%, make text wrap around the box" => "for box with width lesser than 100%, make text wrap around the box",
// "CSS Class" => "CSS Class",
// "Apply custom CSS class to the box" => "Apply custom CSS class to the box",
// "Category IDs" => "Category IDs",
// "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page" => "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page",
// "Types" => "Types",
// "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img" => "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img",
// "Sort Order" => "Sort Order",
// "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle" => "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle",
// "Split" => "Split",
// "And" => "And",
// "Category Orphans" => "Category Orphans",
// "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker" => "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker",
// "Category Path" => "Category Path",
// "Separator" => "Separator",
// "String used to separate the categories in the path. Default character is >" => "String used to separate the categories in the path. Default character is >",
// "Display top category" => "Display top category",
// "yes|no, default to no" => "yes|no, default to no",
// "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool" => "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool",
// "Chart caption" => "Chart caption",
// "Sheet ID" => "Sheet ID",
// "Data sheet ID" => "Data sheet ID",
// "Chart Type" => "Chart Type",
// "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic" => "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic",
// "Chart Width" => "Chart Width",
// "Width in pixels" => "Width in pixels",
// "Chart Height" => "Chart Height",
// "Height in pixels" => "Height in pixels",
// "Value series" => "Value series",
// "Required for pie charts" => "Required for pie charts",
// "Independant series" => "Independant series",
// "Required for types other than pie chart" => "Required for types other than pie chart",
// "Dependant series" => "Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors" => "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors",
// "List of colors to use" => "List of colors to use",
// "Styles" => "Styles",
// "List of styles to use" => "List of styles to use",
// "Labels" => "Labels",
// "Labels for the series or values in the legend" => "Labels for the series or values in the legend",
// "Chart as PDF" => "Chart as PDF",
// "Chart as PostScript" => "Chart as PostScript",
// "Caption" => "Caption",
// "Code snippet label" => "Code snippet label",
// "Word Wrap" => "Word Wrap",
// "0|1, Enable word wrapping on the code to avoid breaking the layout" => "0|1, Enable word wrapping on the code to avoid breaking the layout",
// "Colors" => "Colors",
// "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, .." => "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, ..",
// "Line numbers" => "Line numbers",
// "0|1, may not be used with colors" => "0|1, may not be used with colors",
// "Wiki syntax" => "Wiki syntax",
// "0|1, parse wiki syntax within the code snippet" => "0|1, parse wiki syntax within the code snippet",
// "Right to left" => "Right to left",
// "0|1, switch the text display from left to right to right to left" => "0|1, switch the text display from left to right to right to left",
// "Content is HTML" => "Content is HTML",
// "0|1, display the content as is instead of escaping HTML special chars" => "0|1, display the content as is instead of escaping HTML special chars",
// "note: colors and ln are exclusive" => "note: colors and ln are exclusive",
// "Includes content from the dynamic content system" => "Includes content from the dynamic content system",
// "Content ID" => "Content ID",
// "Also known as Fortune cookies or Taglines" => "Also known as Fortune cookies or Taglines",
// "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~" => "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~",
// "Countdown" => "Countdown",
// "Displays a countdown from now until the specified date" => "Displays a countdown from now until the specified date",
// "Text to append to the countdown" => "Text to append to the countdown",
// "Target date. Multiple formats accepted" => "Target date. Multiple formats accepted",
// "Locate Time" => "Locate Time",
// "on|off" => "on|off",
// "and" => "and",
// "DBReport" => "DBReport",
// "Run a database report" => "Run a database report",
// "report definition" => "report definition",
// "Full DSN" => "Full DSN",
// "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database" => "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database",
// "Wiki DSN name" => "Wiki DSN name",
// "The name of a DSN connection defined by the Wiki administrator" => "The name of a DSN connection defined by the Wiki administrator",
// "0|1, parse wiki syntax within the report" => "0|1, parse wiki syntax within the report",
// "Debug" => "Debug",
// "0|1, display the parsed report definition" => "0|1, display the parsed report definition",
// "Missing db or dsn parameter" => "Missing db or dsn parameter",
// "You do not have permission to use this DSN" => "You do not have permission to use this DSN",
// "No DSN connection string found" => "No DSN connection string found",
// "Div" => "Div",
// "div|span|pre|b|i|tt|p|blockquote" => "div|span|pre|b|i|tt|p|blockquote",
// "left|right|center|justify" => "left|right|center|justify",
// "left|right, for box with width lesser than 100%, make text wrap around the box" => "left|right, for box with width lesser than 100%, make text wrap around the box",
// "Apply custom CSS class to the div" => "Apply custom CSS class to the div",
// "HTML id" => "HTML id",
// "Sets the div\\'s id attribute, as defined by HTML" => "Sets the div\\'s id attribute, as defined by HTML",
// "Insert a division block on wiki page" => "Insert a division block on wiki page",
// "Definition List" => "Definition List",
// "One entry per line. Each line is in \"Term: Definition\" format" => "One entry per line. Each line is in \"Term: Definition\" format",
// "Draw" => "Draw",
// "Displays drawings in the wiki page" => "Displays drawings in the wiki page",
// "Name of the drawing to display" => "Name of the drawing to display",
// "Name parameter missing" => "Name parameter missing",
// "Equation" => "Equation",
// "Renders an equation written in LaTeX syntax as an image" => "Renders an equation written in LaTeX syntax as an image",
// "equation" => "equation",
// "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large" => "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "Includes the list of events from a calendar in the page" => "Includes the list of events from a calendar in the page",
// "Calendar ID" => "Calendar ID",
// "Numeric" => "Numeric",
// "Maximum days" => "Maximum days",
// "Maximum Rows" => "Maximum Rows",
// "Datetime" => "Datetime",
// "0|1" => "0|1",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "Fade" => "Fade",
// "Displays a label. On click, the block of content will fade in and fade out" => "Displays a label. On click, the block of content will fade in and fade out",
// "Wiki syntax containing the text to display" => "Wiki syntax containing the text to display",
// "Label to display on first display" => "Label to display on first display",
// "Unspecified label" => "Unspecified label",
// "Fancy List" => "Fancy List",
// "One item per line starting with anything followed by \")\"" => "One item per line starting with anything followed by \")\"",
// "Use div" => "Use div",
// "Use div instead of ol" => "Use div instead of ol",
// "Class" => "Class",
// "CSS class of the fancylist" => "CSS class of the fancylist",
// "Creates a fancy looking list" => "Creates a fancy looking list",
// "num" => "num",
// "item text" => "item text",
// "one item per line" => "one item per line",
// "Fancy Table" => "Fancy Table",
// "One row per line, cells separated by ~|~" => "One row per line, cells separated by ~|~",
// "Heading row" => "Heading row",
// "Heading row of the table, same format as the body section" => "Heading row of the table, same format as the body section",
// "Heading CSS Class" => "Heading CSS Class",
// "CSS Class to apply on the heading row" => "CSS Class to apply on the heading row",
// "Displays a link to an attachment to a wiki page and can display an image attachment. " => "Displays a link to an attachment to a wiki page and can display an image attachment. ",
// "Gallery ID" => "Gallery ID",
// "name_asc" => "name_asc",
// "Shows ID" => "Shows ID",
// "Shows Icon" => "Shows Icon",
// "Shows Name" => "Shows Name",
// "Shows Filename" => "Shows Filename",
// "Shows Size" => "Shows Size",
// "Shows Description" => "Shows Description",
// "Shows Creation Date" => "Shows Creation Date",
// "Shows Hits" => "Shows Hits",
// "Shows Locked by" => "Shows Locked by",
// "Shows Modification Date" => "Shows Modification Date",
// "Shows Author" => "Shows Author",
// "Shows Creator" => "Shows Creator",
// "Shows Parent Gallery Name" => "Shows Parent Gallery Name",
// "Shows Number of Files" => "Shows Number of Files",
// "Shows the slideshow of a gallery" => "Shows the slideshow of a gallery",
// "List files in a file gallery (with a category) or in a category or a file gallery od this category" => "List files in a file gallery (with a category) or in a category or a file gallery od this category",
// "Displays a list of files from the File Gallery" => "Displays a list of files from the File Gallery",
// "Flash video" => "Flash video",
// "Displays a SWF on the wiki page" => "Displays a SWF on the wiki page",
// "Movie URL" => "Movie URL",
// "Complete URL to the movie to include" => "Complete URL to the movie to include",
// "Default width: 425" => "Default width: 425",
// "Default height: 350" => "Default height: 350",
// "Quality" => "Quality",
// "Flash video quality. Default value: high" => "Flash video quality. Default value: high",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Footnote" => "Footnote",
// "Inserts a superscripted footnote number next to text and takes in footnote as parameter" => "Inserts a superscripted footnote number next to text and takes in footnote as parameter",
// "The footnote" => "The footnote",
// "Sameas" => "Sameas",
// "Tag to existing footnote" => "Tag to existing footnote",
// "CheckDuplicate" => "CheckDuplicate",
// "check for duplcate footnotes" => "check for duplcate footnotes",
// "Footnotearea" => "Footnotearea",
// "Inserts a section for collected footnotes within the wiki page" => "Inserts a section for collected footnotes within the wiki page",
// "Download box for a file on ftp server" => "Download box for a file on ftp server",
// "ftp" => "ftp",
// "file name" => "file name",
// "Ftp Server Name" => "Ftp Server Name",
// "Ftp User name" => "Ftp User name",
// "Ftp password" => "Ftp password",
// "Download button label" => "Download button label",
// "missing parameters" => "missing parameters",
// "Connection failed" => "Connection failed",
// "Incorrect param" => "Incorrect param",
// "Gauge" => "Gauge",
// "Displays a graphical gauge" => "Displays a graphical gauge",
// "current value (REQUIRED)" => "current value (REQUIRED)",
// "Maximum Value" => "Maximum Value",
// "Maximum possible value. Default: 100" => "Maximum possible value. Default: 100",
// "Label displayed on the left side of the gauge" => "Label displayed on the left side of the gauge",
// "Color" => "Color",
// "Background Color" => "Background Color",
// "Bar width in pixels" => "Bar width in pixels",
// "Label Width" => "Label Width",
// "Width in pixels allocated to the label" => "Width in pixels allocated to the label",
// "Display Percentage" => "Display Percentage",
// "true|false, if true then a percentage of the maximum is displayed" => "true|false, if true then a percentage of the maximum is displayed",
// "Display Value" => "Display Value",
// "true|false, if the numeric value is displayed" => "true|false, if the numeric value is displayed",
// "Bar height in pixels" => "Bar height in pixels",
// "Google Analytics" => "Google Analytics",
// "Add the tracking code for Google Analytics" => "Add the tracking code for Google Analytics",
// "Account number" => "Account number",
// "The account number for the site" => "The account number for the site",
// "Missing parameter" => "Missing parameter",
// "googledoc" => "googledoc",
// "Leave this empty" => "Leave this empty",
// "Type of Google document" => "Type of Google document",
// "key" => "key",
// "Google doc key - for example pXsHENf1bGGY92X1iEeJJI" => "Google doc key - for example pXsHENf1bGGY92X1iEeJJI",
// "Name of iframe" => "Name of iframe",
// "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large" => "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large",
// "Pixels or %" => "Pixels or %",
// "Margin Height" => "Margin Height",
// "Pixels" => "Pixels",
// "Margin Width" => "Margin Width",
// "Scrolling" => "Scrolling",
// "editLink" => "editLink",
// "Required parameter \"type\" missing" => "Required parameter \"type\" missing",
// "Required parameter \"key\" missing" => "Required parameter \"key\" missing",
// "Displays a Google document" => "Displays a Google document",
// "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition" => "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition",
// "Allowed Groups" => "Allowed Groups",
// "Pipe separated list of groups allowed to view the block. ex: Admins|Developers" => "Pipe separated list of groups allowed to view the block. ex: Admins|Developers",
// "Denied Groups" => "Denied Groups",
// "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers" => "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "HTML" => "HTML",
// "Include literal HTML in a Wiki page" => "Include literal HTML in a Wiki page",
// "0|1, parse wiki syntax within the html code" => "0|1, parse wiki syntax within the html code",
// "Include literal HTML" => "Include literal HTML",
// "Iframe" => "Iframe",
// "Frame title" => "Frame title",
// "iframe" => "iframe",
// "Displays an iframe" => "Displays an iframe",
// " (experimental - possible successor to img in 4.0)" => " (experimental - possible successor to img in 4.0)",
// "File ID" => "File ID",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Image Source" => "Image Source",
// "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required" => "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required",
// "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded" => "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded",
// "Alias: lnk. Location the image should point to" => "Alias: lnk. Location the image should point to",
// "Link Relation" => "Link Relation",
// "\"rel\" attribute to add to the link" => "\"rel\" attribute to add to the link",
// "Link title" => "Link title",
// "Title text" => "Title text",
// "Image alt text" => "Image alt text",
// "Alternate text to display if impossible to load the image" => "Alternate text to display if impossible to load the image",
// "Alias:imalign. Image alignment in the page. (left, right)" => "Alias:imalign. Image alignment in the page. (left, right)",
// "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)" => "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)",
// "Image description to display on the page" => "Image description to display on the page",
// "Image Map" => "Image Map",
// "Name of the image map to use for the image" => "Name of the image map to use for the image",
// "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)" => "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)",
// "CSS Style" => "CSS Style",
// "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)" => "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)",
// "Border options" => "Border options",
// "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options" => "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options",
// "Description options" => "Description options",
// "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)" => "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)",
// "Default configuration" => "Default configuration",
// "Default configuration definitions. (Usually used in configuration rather than on individual images.)" => "Default configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Mandatory configuration" => "Mandatory configuration",
// "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)" => "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content" => "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content",
// "Display an image" => "Display an image",
// "Displays an image" => "Displays an image",
// "Full URL to the image to display" => "Full URL to the image to display",
// "Alternate Text" => "Alternate Text",
// "Height of the image to display" => "Height of the image to display",
// "Width of the image to display" => "Width of the image to display",
// "Link Title" => "Link Title",
// "Image alignment in the page. (left, right, center) Uses HTML IMG tag" => "Image alignment in the page. (left, right, center) Uses HTML IMG tag",
// "Float Alignment" => "Float Alignment",
// "Image alignment in the flow of the document. (left, right, none) Uses CSS float property" => "Image alignment in the flow of the document. (left, right, none) Uses CSS float property",
// "Style to apply to the image" => "Style to apply to the image",
// "Include a page\\'s content" => "Include a page\\'s content",
// "Page Name" => "Page Name",
// "Wiki page name to include" => "Wiki page name to include",
// "When only a portion of the page should be included, specify the marker from which inclusion should start" => "When only a portion of the page should be included, specify the marker from which inclusion should start",
// "When only a portion of the page should be included, specify the marker at which inclusion should end" => "When only a portion of the page should be included, specify the marker at which inclusion should end",
// "Jabber" => "Jabber",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Applet height in pixels" => "Applet height in pixels",
// "'),\n\t\t\t\t'description' => tra('Applet width in pixels" => "'),\n\t\t\t\t'description' => tra('Applet width in pixels",
// "'),\n\t\t\t\t'description' => tra('jabber.org" => "'),\n\t\t\t\t'description' => tra('jabber.org",
// "Default Color" => "Default Color",
// "255,255,255" => "255,255,255",
// "JQuery" => "JQuery",
// "Insert JQuery javascript code. Requires feature_jquery" => "Insert JQuery javascript code. Requires feature_jquery",
// " (experimental - may change in future versions)" => " (experimental - may change in future versions)",
// "JQuery Code" => "JQuery Code",
// "NotOnReady" => "NotOnReady",
// "NoJQuery" => "NoJQuery",
// "Optional markup for when feature_jquery is off" => "Optional markup for when feature_jquery is off",
// "Insert JQuery javascript code" => "Insert JQuery javascript code",
// "jquery code e.g. \$jq(\"img\\" => "jquery code e.g. \$jq(\"img\\",
// "Do not execute on document ready (execute inline)" => "Do not execute on document ready (execute inline)",
// "Javascript" => "Javascript",
// "Insert a javascript file or/and some javascript code" => "Insert a javascript file or/and some javascript code",
// "javascript code" => "javascript code",
// "Javascript filename" => "Javascript filename",
// "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Not Language" => "Not Language",
// "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Page name to display information of. Default value is current page" => "Page name to display information of. Default value is current page",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "List wiki pages" => "List wiki pages",
// "Result Offset" => "Result Offset",
// "Result number at which the listing should start" => "Result number at which the listing should start",
// "Result Count" => "Result Count",
// "Amount of results displayed in the list" => "Amount of results displayed in the list",
// "Initial" => "Initial",
// "txt" => "txt",
// "Show Name Only" => "Show Name Only",
// "Structure Head" => "Structure Head",
// "Show Page Alias" => "Show Page Alias",
// "Two letter language code to filter pages listed" => "Two letter language code to filter pages listed",
// "Orphan Language" => "Orphan Language",
// "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed" => "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed",
// "Load Translations" => "Load Translations",
// "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter" => "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter",
// "Exact Match" => "Exact Match",
// "Related to Find" => "Related to Find",
// "Only Orphan Pages" => "Only Orphan Pages",
// "For List Pages" => "For List Pages",
// "List Directory" => "List Directory",
// "Lists files in a directory" => "Lists files in a directory",
// "Full path to the server-local directory" => "Full path to the server-local directory",
// "URL Prefix" => "URL Prefix",
// ".ext" => ".ext",
// "Limit" => "Limit",
// "Maximum amount of files to display" => "Maximum amount of files to display",
// "could not be opened because it doesn't exist or permission was denied" => "could not be opened because it doesn't exist or permission was denied",
// "Displays a map" => "Displays a map",
// "Map File" => "Map File",
// "Extents" => "Extents",
// "Inline Flash mp3 and flv Player" => "Inline Flash mp3 and flv Player",
// "Mediaplayer" => "Mediaplayer",
// "MP3 URL" => "MP3 URL",
// "Complete URL to the mp3 to include" => "Complete URL to the mp3 to include",
// "FLV URL" => "FLV URL",
// "Complete URL to the flv to include" => "Complete URL to the flv to include",
// "One of" => "One of",
// "Mini Quiz" => "Mini Quiz",
// "Displays a miniquiz" => "Displays a miniquiz",
// "Instructions::Feedback" => "Instructions::Feedback",
// "Tracker ID" => "Tracker ID",
// "Insert Module" => "Insert Module",
// "Module name as known in Tikiwiki" => "Module name as known in Tikiwiki",
// "Decoration" => "Decoration",
// "Flip" => "Flip",
// "Max" => "Max",
// "np" => "np",
// "notitle" => "notitle",
// "Displays a module inlined in page. More parameters can be added, not supported by UI" => "Displays a module inlined in page. More parameters can be added, not supported by UI",
// "Monospace" => "Monospace",
// "Font name as known in browsers" => "Font name as known in browsers",
// "Mouse Over" => "Mouse Over",
// "Create a mouseover feature on some text" => "Create a mouseover feature on some text",
// "Mouseover text if param label exists. Page text if text param exists" => "Mouseover text if param label exists. Page text if text param exists",
// "Text displayed on the page. The body is the mouseover content" => "Text displayed on the page. The body is the mouseover content",
// "Destination link when moused-over text is clicked. Use http:// for external links" => "Destination link when moused-over text is clicked. Use http:// for external links",
// "DEPRECATED" => "DEPRECATED",
// "Text displayed on the mouseover. The body contains the text of the page" => "Text displayed on the mouseover. The body contains the text of the page",
// "Mouse over box width. Default: 400px" => "Mouse over box width. Default: 400px",
// "Mouse over box height. Default: 200px" => "Mouse over box height. Default: 200px",
// "Offset X" => "Offset X",
// "Shifts the overlay to the right by the specified amount of pixels in relation to the cursor. Default: 5px" => "Shifts the overlay to the right by the specified amount of pixels in relation to the cursor. Default: 5px",
// "Offset Y" => "Offset Y",
// "Shifts the overlay to the bottom by the specified amount of pixels in relation to the cursor. Default: 0px" => "Shifts the overlay to the bottom by the specified amount of pixels in relation to the cursor. Default: 0px",
// "Parse Body" => "Parse Body",
// "y|n, parse the body of the plugin as wiki content. (Default to y)" => "y|n, parse the body of the plugin as wiki content. (Default to y)",
// "Color of the inside popup" => "Color of the inside popup",
// "Default: #F5F5F5" => "Default: #F5F5F5",
// "Text popup color" => "Text popup color",
// "#FFFFFF" => "#FFFFFF",
// "Padding" => "Padding",
// "No label specified" => "No label specified",
// "MWTable" => "MWTable",
// "fancy" => "fancy",
// "true|false" => "true|false",
// "wiki_classes" => "wiki_classes",
// "Displays the data using (sort of) MediaWiki syntax" => "Displays the data using (sort of) MediaWiki syntax",
// "Displays a table using MediaWiki syntax" => "Displays a table using MediaWiki syntax",
// "MySpace" => "MySpace",
// "MySpace Page" => "MySpace Page",
// "Displays a SWF myspace mp3 playlist on the wiki page" => "Displays a SWF myspace mp3 playlist on the wiki page",
// "Object Hits" => "Object Hits",
// "Object ID" => "Object ID",
// "Object Type" => "Object Type",
// "Days" => "Days",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "Picture" => "Picture",
// "Search for images uploaded by users" => "Search for images uploaded by users",
// " (deprecated - scheduled to be removed or changed significantly)" => " (deprecated - scheduled to be removed or changed significantly)",
// "Filename or full path to file" => "Filename or full path to file",
// "Plugin Manager" => "Plugin Manager",
// "Information" => "Information",
// "Multiple values separated with | can be used" => "Multiple values separated with | can be used",
// "Poll ID" => "Poll ID",
// "Displays the output of a poll, fields are indicated with numeric ids" => "Displays the output of a poll, fields are indicated with numeric ids",
// "missing poll ID for plugin POLL" => "missing poll ID for plugin POLL",
// "Profile Installer" => "Profile Installer",
// "Adds controls required to install a profile" => "Adds controls required to install a profile",
// "Domain" => "Domain",
// "Profile repository domain. Default value is profiles.tikiwiki.org" => "Profile repository domain. Default value is profiles.tikiwiki.org",
// "Profile Name" => "Profile Name",
// "Name of the profile" => "Name of the profile",
// "Profile plugin only available to administrators" => "Profile plugin only available to administrators",
// "Profile %0/%1 not found" => "Profile %0/%1 not found",
// "Proposal" => "Proposal",
// "Provides a widget for users to vote on a proposal and view the current decision" => "Provides a widget for users to vote on a proposal and view the current decision",
// "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username" => "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username",
// "Accept proposal" => "Accept proposal",
// "Still undecided" => "Still undecided",
// "Reject proposal" => "Reject proposal",
// "Displays a proposal acceptance widget" => "Displays a proposal acceptance widget",
// "Short description of the proposal to vote on. Will be displayed above the result table" => "Short description of the proposal to vote on. Will be displayed above the result table",
// "Quote" => "Quote",
// "Quoted text" => "Quoted text",
// "Reply to" => "Reply to",
// "Name of the quoted person" => "Name of the quoted person",
// "wrote" => "wrote",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "Random Dynamic Content" => "Random Dynamic Content",
// "Includes random content from the dynamic content system" => "Includes random content from the dynamic content system",
// "Redirect" => "Redirect",
// "Redirect the user to a wiki page or generic URL" => "Redirect the user to a wiki page or generic URL",
// "Wiki page name to redirect to" => "Wiki page name to redirect to",
// "Complete URL, internal or external" => "Complete URL, internal or external",
// "Redirects you to another wiki page" => "Redirects you to another wiki page",
// "Regular Expression" => "Regular Expression",
// "Takes regex expressions and parses the content between REGEX tags and replaces the text" => "Takes regex expressions and parses the content between REGEX tags and replaces the text",
// "Page name containing the regular expression" => "Page name containing the regular expression",
// "Takes regex expressions and parses the content between the REGEX tags and replaces the text" => "Takes regex expressions and parses the content between the REGEX tags and replaces the text",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "Remarks Box" => "Remarks Box",
// "Label displayed above the remark" => "Label displayed above the remark",
// "Highlight" => "Highlight",
// "Icon ID" => "Icon ID",
// "RSS Feed" => "RSS Feed",
// "Inserts an RSS feed output" => "Inserts an RSS feed output",
// "IDs" => "IDs",
// "List of feed IDs separated by colons. ex: feedId:feedId2" => "List of feed IDs separated by colons. ex: feedId:feedId2",
// "Amount of results displayed" => "Amount of results displayed",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect" => "RSS Id incorrect",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "SourceForge" => "SourceForge",
// "aid?" => "aid?",
// "adit?" => "adit?",
// "groupid?" => "groupid?",
// "Insert a ShareThis button from www.sharethis.com" => "Insert a ShareThis button from www.sharethis.com",
// "sharethis" => "sharethis",
// "Display a social networking tool" => "Display a social networking tool",
// "Send services" => "Send services",
// "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services" => "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services",
// "First post services shown" => "First post services shown",
// "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget" => "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget",
// "Rotate image" => "Rotate image",
// "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping" => "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping",
// "Button text" => "Button text",
// "Custom link text for the button" => "Custom link text for the button",
// "Header title" => "Header title",
// "Optional header title text for the widget" => "Optional header title text for the widget",
// "Header background" => "Header background",
// "HTML color code (not color name) for the background color for the header if an optional header title is used" => "HTML color code (not color name) for the background color for the header if an optional header title is used",
// "Header text color" => "Header text color",
// "HTML color code (not color name) for the header text if an optional header title is used" => "HTML color code (not color name) for the header text if an optional header title is used",
// "Link text color for services" => "Link text color for services",
// "HTML color code (not color name) for the link text for all send and post services shown in the widget" => "HTML color code (not color name) for the link text for all send and post services shown in the widget",
// "Pop-up" => "Pop-up",
// "A value of true will cause the widget to show in a pop-up window" => "A value of true will cause the widget to show in a pop-up window",
// "Embedded elements" => "Embedded elements",
// "A value of true will allow embedded elements (like flash) to be seen while iframe is loading" => "A value of true will allow embedded elements (like flash) to be seen while iframe is loading",
// "Sheet" => "Sheet",
// "Displays the content of a spreadsheet in the page" => "Displays the content of a spreadsheet in the page",
// "Sheet Heading" => "Sheet Heading",
// "Internal ID of the TikiSheet" => "Internal ID of the TikiSheet",
// "New sheet in page: " => "New sheet in page: ",
// "Incomplete call to plugin: No target sheet" => "Incomplete call to plugin: No target sheet",
// "Create new sheet" => "Create new sheet",
// "TikiSheet" => "TikiSheet",
// "Edit Sheet" => "Edit Sheet",
// "Show Pages" => "Show Pages",
// "Search criteria" => "Search criteria",
// "Maximum amount of results displayed" => "Maximum amount of results displayed",
// "name|desc" => "name|desc",
// "Last modified by" => "Last modified by",
// "Skype" => "Skype",
// "Clickable Skype link" => "Clickable Skype link",
// "Name or number to call or chat with" => "Name or number to call or chat with",
// "Snarf" => "Snarf",
// "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified" => "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified",
// "Full URL to the page to include" => "Full URL to the page to include",
// "PCRE compliant regular expression" => "PCRE compliant regular expression",
// "Regular Expression Part" => "Regular Expression Part",
// "ex: \$1" => "ex: \$1",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace" => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace",
// "This data is put in a CODE caption" => "This data is put in a CODE caption",
// "Missing url parameter for SNARF plugin" => "Missing url parameter for SNARF plugin",
// "Data to sort, one entry per line" => "Data to sort, one entry per line",
// "asc|desc|shuffle" => "asc|desc|shuffle",
// "Join Columns" => "Join Columns",
// "Generate the colspan attribute if columns are missing" => "Generate the colspan attribute if columns are missing",
// "Fixed Size" => "Fixed Size",
// "Generate the width attribute on the columns" => "Generate the width attribute on the columns",
// "Column Size" => "Column Size",
// "Editable" => "Editable",
// "Display edit icon for each section" => "Display edit icon for each section",
// "Custom class" => "Custom class",
// "add a class to customize the design" => "add a class to customize the design",
// "SQL" => "SQL",
// "DNS Name" => "DNS Name",
// "ADODB DNS" => "ADODB DNS",
// "Subscript" => "Subscript",
// "Displays text in subscript" => "Displays text in subscript",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Subscribe Group" => "Subscribe Group",
// "Group Name" => "Group Name",
// "As known in Tikiwiki" => "As known in Tikiwiki",
// "Subscribe Text" => "Subscribe Text",
// "Subscribe text, containing %s as the placeholder for the group name" => "Subscribe text, containing %s as the placeholder for the group name",
// "Unsubscribe Text" => "Unsubscribe Text",
// "Unsubscribe text, containing %s as the placeholder for the group name" => "Unsubscribe text, containing %s as the placeholder for the group name",
// "Subscribe Action" => "Subscribe Action",
// "Subscribe button label, containing %s as the placeholder for the group name" => "Subscribe button label, containing %s as the placeholder for the group name",
// "Unsubscribe Action" => "Unsubscribe Action",
// "Unsubscribe button label, containing %s as the placeholder for the group name" => "Unsubscribe button label, containing %s as the placeholder for the group name",
// "Subscribe Groups" => "Subscribe Groups",
// "Colon separated list of groups" => "Colon separated list of groups",
// "Superscript" => "Superscript",
// "Displays text in superscript (exponent)" => "Displays text in superscript (exponent)",
// "Displays text in superscript" => "Displays text in superscript",
// "Wiki Page to redirect the user after his vote" => "Wiki Page to redirect the user after his vote",
// "Displays a survey" => "Displays a survey",
// "Tag" => "Tag",
// "Displays the text between an html tag" => "Displays the text between an html tag",
// "Any valid HTML tag, span by default" => "Any valid HTML tag, span by default",
// "Equivalent of the style attribute on the HTML tag" => "Equivalent of the style attribute on the HTML tag",
// "Displays text between an html tag" => "Displays text between an html tag",
// "Displays the thumbnail for an image" => "Displays the thumbnail for an image",
// "File ID from the file gallery" => "File ID from the file gallery",
// "Image ID from the image gallery" => "Image ID from the image gallery",
// "URL to the image" => "URL to the image",
// "Maximum Size" => "Maximum Size",
// "Maximum width or height for the image" => "Maximum width or height for the image",
// "Floating" => "Floating",
// "Link target of the image" => "Link target of the image",
// "File is not an image" => "File is not an image",
// "Server does not support image manipulation" => "Server does not support image manipulation",
// "No image specified" => "No image specified",
// "Title Search" => "Title Search",
// "Search wiki page titles" => "Search wiki page titles",
// "Search Criteria" => "Search Criteria",
// "Portion of a page name" => "Portion of a page name",
// "hits|user" => "hits|user",
// "Exclude" => "Exclude",
// "Pipe separated list of page names to exclude from results" => "Pipe separated list of page names to exclude from results",
// "Table of Contents (Structure)" => "Table of Contents (Structure)",
// "Displays the table of contents for the current structure\\'s subtree as part of the page content" => "Displays the table of contents for the current structure\\'s subtree as part of the page content",
// "Maximum Depth" => "Maximum Depth",
// "Maximum amount of levels to display. On very large structures, this should be limited" => "Maximum amount of levels to display. On very large structures, this should be limited",
// "By default, structure for the current page will be displayed. Alternate structure may be provided" => "By default, structure for the current page will be displayed. Alternate structure may be provided",
// "asc|desc" => "asc|desc",
// "Show Description" => "Show Description",
// "0|1, show the page description instead of the page name" => "0|1, show the page description instead of the page name",
// "Show Numbering" => "Show Numbering",
// "0|1, display the section numbers or not" => "0|1, display the section numbers or not",
// "plain|fancy" => "plain|fancy",
// "Top Friends" => "Top Friends",
// "List top scoring users" => "List top scoring users",
// "Maximum result count" => "Maximum result count",
// "Public" => "Public",
// "Translate a string using Tikiwiki translation table" => "Translate a string using Tikiwiki translation table",
// "string" => "string",
// "Translate a string" => "Translate a string",
// "Confirmation message after posting form" => "Confirmation message after posting form",
// "Colon-separated list of field IDs to be displayed. Example: 2:4:5" => "Colon-separated list of field IDs to be displayed. Example: 2:4:5",
// "Label on the submit button" => "Label on the submit button",
// "Show Title" => "Show Title",
// "Show Mandatory" => "Show Mandatory",
// "Embedded" => "Embedded",
// "Url used for the field links" => "Url used for the field links",
// "Values" => "Values",
// "Colon-separated list of values" => "Colon-separated list of values",
// "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or " => "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or ",
// "user|page" => "user|page",
// "itemId" => "itemId",
// "itemId if you want to edit an item" => "itemId if you want to edit an item",
// "Template File" => "Template File",
// "Name of the template used to display the tracker items" => "Name of the template used to display the tracker items",
// "Name of the wiki page containing the template to display the tracker items" => "Name of the wiki page containing the template to display the tracker items",
// "New Status" => "New Status",
// "Default status applied to newly created items" => "Default status applied to newly created items",
// "Width of first column " => "Width of first column ",
// "Specify the width in pixels or percentage of the first column in the tracker form" => "Specify the width in pixels or percentage of the first column in the tracker form",
// "Incorrect fieldId" => "Incorrect fieldId",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Following fields are incorrect" => "Following fields are incorrect",
// "Displays an input form for tracker submit" => "Displays an input form for tracker submit",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Fields marked with a * are mandatory" => "Fields marked with a * are mandatory",
// "Display List" => "Display List",
// "Tracker Filter" => "Tracker Filter",
// "notice" => "notice",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Filters the items of a tracker, fields are indicated with numeric ids" => "Filters the items of a tracker, fields are indicated with numeric ids",
// "Wiki text" => "Wiki text",
// "Tracker Item Field" => "Tracker Item Field",
// "Wiki text containing an {ELSE} marker" => "Wiki text containing an {ELSE} marker",
// "Item ID" => "Item ID",
// "Field ID" => "Field ID",
// "Colon separated list of field IDs" => "Colon separated list of field IDs",
// "o|p|c|op|oc|pc|opc" => "o|p|c|op|oc|pc|opc",
// "Test" => "Test",
// "Value to compare against" => "Value to compare against",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)" => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)",
// "Tracker List" => "Tracker List",
// "Displays the output of a tracker content, fields are indicated with numeric ids" => "Displays the output of a tracker content, fields are indicated with numeric ids",
// "Notice" => "Notice",
// "Popup" => "Popup",
// "Colon-separated list of fields to display on click. Example: 6:7" => "Colon-separated list of fields to display on click. Example: 6:7",
// "Sticky Popup" => "Sticky Popup",
// "Show Links" => "Show Links",
// "shownbitems" => "shownbitems",
// "Show Initials" => "Show Initials",
// "Show Status" => "Show Status",
// "Show Creation Date" => "Show Creation Date",
// "Show Last Modification" => "Show Last Modification",
// "Show Field Name" => "Show Field Name",
// "Status Filter" => "Status Filter",
// "Which item status to list. o = open, p = pending, c = closed" => "Which item status to list. o = open, p = pending, c = closed",
// "Sort Mode" => "Sort Mode",
// "Filter Field" => "Filter Field",
// "Colon separated list of fields to allow filtering on" => "Colon separated list of fields to allow filtering on",
// "Filter Value" => "Filter Value",
// "Exact Value" => "Exact Value",
// "Checkbox" => "Checkbox",
// "goIfOne" => "goIfOne",
// "More" => "More",
// "More URL" => "More URL",
// "Select automatically the item of the current user or the page" => "Select automatically the item of the current user or the page",
// "View User" => "View User",
// "Item ID separated with " => "Item ID separated with ",
// "List of items Ids" => "List of items Ids",
// "link url" => "link url",
// "Left Deliminator" => "Left Deliminator",
// "Right Deliminator" => "Right Deliminator",
// "If y, value will be truncated" => "If y, value will be truncated",
// "Export Button" => "Export Button",
// "Compute" => "Compute",
// "Sum or average all the values of a field  and displays it at the bottom of the table" => "Sum or average all the values of a field  and displays it at the bottom of the table",
// "fieldId" => "fieldId",
// "incorrect filterfield" => "incorrect filterfield",
// "Error in tracker ID" => "Error in tracker ID",
// "No field indicated" => "No field indicated",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields" => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields",
// "Tracker Prefill" => "Tracker Prefill",
// "Tracker page name" => "Tracker page name",
// "Button label" => "Button label",
// "Field 1" => "Field 1",
// "Value 1" => "Value 1",
// "Content of the field" => "Content of the field",
// "Field 2" => "Field 2",
// "Value 2" => "Value 2",
// "Field 3" => "Field 3",
// "Value 3" => "Value 3",
// "Field 4" => "Field 4",
// "Value 4" => "Value 4",
// "Field 5" => "Field 5",
// "Value 5" => "Value 5",
// "Tracker Stats" => "Tracker Stats",
// "Show Percentage" => "Show Percentage",
// "Show Bar" => "Show Bar",
// "Show link to tiki-view_tracker" => "Show link to tiki-view_tracker",
// "Displays some stat of a tracker content, fields are indicated with numeric ids" => "Displays some stat of a tracker content, fields are indicated with numeric ids",
// "incorrect fieldId" => "incorrect fieldId",
// "Tracker Timeline" => "Tracker Timeline",
// "Timeline view of a tracker, can be used to display event schedules or gantt charts" => "Timeline view of a tracker, can be used to display event schedules or gantt charts",
// "Title Field" => "Title Field",
// "Tracker Field ID containing the item title" => "Tracker Field ID containing the item title",
// "Summary Field" => "Summary Field",
// "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused" => "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused",
// "Start Date" => "Start Date",
// "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field",
// "End Date" => "End Date",
// "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field",
// "Element Group" => "Element Group",
// "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row" => "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row",
// "Lower Bound" => "Lower Bound",
// "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Upper Bound" => "Upper Bound",
// "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Primary Scale Unit" => "Primary Scale Unit",
// "hour, day, week, month or year (default to hour)" => "hour, day, week, month or year (default to hour)",
// "Secondary Scale Unit" => "Secondary Scale Unit",
// "hour, day, week, month, year or empty (default to empty)" => "hour, day, week, month, year or empty (default to empty)",
// "Link Group Name" => "Link Group Name",
// "Convert the group name to a link. (y|n)" => "Convert the group name to a link. (y|n)",
// "Page Link Field" => "Page Link Field",
// "Tracker Field ID containing the page name for item details" => "Tracker Field ID containing the page name for item details",
// "Missing parameter: %0" => "Missing parameter: %0",
// "Start date after end date" => "Start date after end date",
// "Translated" => "Translated",
// "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)" => "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)",
// "Two letter language code of the language, ex: fr" => "Two letter language code of the language, ex: fr",
// "Country name, ex: France" => "Country name, ex: France",
// "User Count" => "User Count",
// "Displays the number of registered users" => "Displays the number of registered users",
// "Group name" => "Group name",
// "User List" => "User List",
// "Displays a list of registered users" => "Displays a list of registered users",
// "Login Filter" => "Login Filter",
// "String to use between elements of the list" => "String to use between elements of the list",
// "Maximum" => "Maximum",
// "Result limit" => "Result limit",
// "Layout" => "Layout",
// "Split the text in parts visible only under some conditions" => "Split the text in parts visible only under some conditions",
// "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default" => "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default",
// "Navigation" => "Navigation",
// "Displays a navigation box that allows users to select a specific version to display" => "Displays a navigation box that allows users to select a specific version to display",
// "Display the current version name as the title. Note: Do not work when nav=>y" => "Display the current version name as the title. Note: Do not work when nav=>y",
// "Default" => "Default",
// "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'" => "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Show Stats" => "Show Stats",
// "Show Stats After" => "Show Stats After",
// "Show Creator" => "Show Creator",
// "Wanted Pages" => "Wanted Pages",
// "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)" => "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)",
// "Ignore" => "Ignore",
// "Split By" => "Split By",
// "Skip Extension" => "Skip Extension",
// "Collect" => "Collect",
// "Table" => "Table",
// "Level" => "Level",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored" => "A wildcard pattern of originating pages to be ignored",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated" => "The character, by which ignored patterns are separated",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list" => "Whether to include external wikis in the list",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column" => "Collect either originating or wanted pages in a cell and display them in the second column",
// "Switch-on debug output with details about the items" => "Switch-on debug output with details about the items",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex",
// "A custom filter for wanted pages to be listed (only used when level=>custom)" => "A custom filter for wanted pages to be listed (only used when level=>custom)",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "Lists ''wanted'' wiki pages" => "Lists ''wanted'' wiki pages",
// "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)" => "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)",
// "The character, by which ignored patterns are separated. possible values: characters" => "The character, by which ignored patterns are separated. possible values: characters",
// "Whether to include external wikis in the list. possible values" => "Whether to include external wikis in the list. possible values",
// "Collect either originating or wanted pages in a cell and display them in the second column. possible values" => "Collect either originating or wanted pages in a cell and display them in the second column. possible values",
// "Switch-on debug output with details about the items. possible values" => "Switch-on debug output with details about the items. possible values",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output" => "End of debug output",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Web Service" => "Web Service",
// "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface" => "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface",
// "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter" => "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter",
// "Complete service URL" => "Complete service URL",
// "Service Name" => "Service Name",
// "Registered service name" => "Registered service name",
// "Template Name" => "Template Name",
// "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided" => "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided",
// "Body as Parameter" => "Body as Parameter",
// "Name of the argument to send the body as for services with complex input. Named service required for this to be useful" => "Name of the argument to send the body as for services with complex input. Named service required for this to be useful",
// "Unknown Template" => "Unknown Template",
// "Unknown Service" => "Unknown Service",
// "Missing parameters" => "Missing parameters",
// "Youtube" => "Youtube",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "URL to the Youtube video" => "URL to the Youtube video",
// "width" => "width",
// "height" => "height",
// "quality" => "quality",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Removed version \$version" => "Removed version \$version",
// "rollback version " => "rollback version ",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Plugin " => "Plugin ",
// "Semantic token already exists" => "Semantic token already exists",
// "Invalid semantic token name" => "Invalid semantic token name",
// "Semantic token not found" => "Semantic token not found",
// "Page locked" => "Page locked",
// "Page unlocked" => "Page unlocked",
// "Removed last version" => "Removed last version",
// "Sent box is full. Archive or delete some sent messages first if you want to send more messages" => "Sent box is full. Archive or delete some sent messages first if you want to send more messages",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "User %s can not receive messages, mailbox is full" => "User %s can not receive messages, mailbox is full",
// "User %s can not receive messages" => "User %s can not receive messages",
// "Invalid user: %s" => "Invalid user: %s",
// "Archive is full. Delete some messages from archive first" => "Archive is full. Delete some messages from archive first",
// "list topics with links to the articles" => "list topics with links to the articles",
// "Article Topics" => "Article Topics",
// "Categorize %s in %s" => "Categorize %s in %s",
// "Please provide an Id" => "Please provide an Id",
// "no object here yet" => "no object here yet",
// "List by month" => "List by month",
// "Please wait.." => "Please wait..",
// "Changes since" => "Changes since",
// "Since your last visit.." => "Since your last visit..",
// "new posts" => "new posts",
// "new articles" => "new articles",
// "new FAQs" => "new FAQs",
// "new blogs" => "new blogs",
// "new blog posts" => "new blog posts",
// "new image galleries" => "new image galleries",
// "new file galleries" => "new file galleries",
// "new polls" => "new polls",
// "new tracker items" => "new tracker items",
// "updated tracker items" => "updated tracker items",
// "The task title must have at least 3 characters" => "The task title must have at least 3 characters",
// "Invalid server key" => "Invalid server key",
// "Cookie not found" => "Cookie not found",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can browse the calendar" => "Can browse the calendar",
// "Can view events details" => "Can view events details",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Can admin categories" => "Can admin categories",
// "Can edit items in categories" => "Can edit items in categories",
// "Can view categories" => "Can view categories",
// "Can view categorized items" => "Can view categorized items",
// "Can search on objects of this category" => "Can search on objects of this category",
// "Can admin charts" => "Can admin charts",
// "Autovalidate suggestions" => "Autovalidate suggestions",
// "Can suggest items" => "Can suggest items",
// "Can view charts" => "Can view charts",
// "Can vote" => "Can vote",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Can use the chat system" => "Can use the chat system",
// "Can admin the cms" => "Can admin the cms",
// "Can approve submissions" => "Can approve submissions",
// "Can admin article topics" => "Can admin article topics",
// "Can admin article types" => "Can admin article types",
// "Can read article headings" => "Can read article headings",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Can edit articles" => "Can edit articles",
// "Can edit submissions" => "Can edit submissions",
// "Can read articles" => "Can read articles",
// "Can remove articles" => "Can remove articles",
// "Can remove submissions" => "Can remove submissions",
// "Can submit articles" => "Can submit articles",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can admin contributions" => "Can admin contributions",
// "Can admin the directory" => "Can admin the directory",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Submited links are valid" => "Submited links are valid",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can validate submited links" => "Can validate submited links",
// "Can use the directory" => "Can use the directory",
// "Can admin drawings" => "Can admin drawings",
// "Can edit drawings" => "Can edit drawings",
// "Can admin faqs" => "Can admin faqs",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can view faqs" => "Can view faqs",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Can admin users" => "Can admin users",
// "Can access site when closed" => "Can access site when closed",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Can ban users or ips" => "Can ban users or ips",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can edit object permissions" => "Can edit object permissions",
// "Can admin rss modules" => "Can admin rss modules",
// "Can clean cache" => "Can clean cache",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can admin cookies" => "Can admin cookies",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit site templates" => "Can edit site templates",
// "Can search" => "Can search",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view referer stats" => "Can view referer stats",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can admin blogs" => "Can admin blogs",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can post to a blog" => "Can post to a blog",
// "Can create a blog" => "Can create a blog",
// "Can read blogs" => "Can read blogs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can create file galleries" => "Can create file galleries",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can list file galleries" => "Can list file galleries",
// "Can upload files" => "Can upload files",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view file galleries" => "Can view file galleries",
// "Can admin forums" => "Can admin forums",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can post in forums" => "Can post in forums",
// "Can start threads in forums" => "Can start threads in forums",
// "Can read forums" => "Can read forums",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can create image galleries" => "Can create image galleries",
// "Can tag objects" => "Can tag objects",
// "Can list image galleries" => "Can list image galleries",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload images" => "Can upload images",
// "Can browse freetags" => "Can browse freetags",
// "Can view image galleries" => "Can view image galleries",
// "Can admin games" => "Can admin games",
// "Can play games" => "Can play games",
// "Can admin newsletters" => "Can admin newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can send newsletters" => "Can send newsletters",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can admin polls" => "Can admin polls",
// "Can view poll results" => "Can view poll results",
// "Can vote polls" => "Can vote polls",
// "Can view poll voters" => "Can view poll voters",
// "Can admin quicktags" => "Can admin quicktags",
// "Can admin quizzes" => "Can admin quizzes",
// "Can take quizzes" => "Can take quizzes",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view user quiz results" => "Can view user quiz results",
// "Can admin sheet" => "Can admin sheet",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can view shoutbox" => "Can view shoutbox",
// "Can admin surveys" => "Can admin surveys",
// "Can take surveys" => "Can take surveys",
// "Can view survey stats" => "Can view survey stats",
// "Can admin trackers" => "Can admin trackers",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can view tracker items comments" => "Can view tracker items comments",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can list trackers" => "Can list trackers",
// "Can change tracker items" => "Can change tracker items",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can watch tracker" => "Can watch tracker",
// "Can export tracker items" => "Can export tracker items",
// "Can admin the wiki" => "Can admin the wiki",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can edit pages" => "Can edit pages",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can create and edit structures" => "Can create and edit structures",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can lock pages" => "Can lock pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can remove" => "Can remove",
// "Can rename pages" => "Can rename pages",
// "Can rollback pages" => "Can rollback pages",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can view page/pages" => "Can view page/pages",
// "Can watch structure" => "Can watch structure",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can view similar wiki pages" => "Can view similar wiki pages",
// "Can admin workflow processes" => "Can admin workflow processes",
// "Can abort a process instance" => "Can abort a process instance",
// "Can declare an instance as exception" => "Can declare an instance as exception",
// "Can send instances after completion" => "Can send instances after completion",
// "Can execute workflow activities" => "Can execute workflow activities",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can configure modules" => "Can configure modules",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the newsreader" => "Can use the newsreader",
// "Can use the notepad" => "Can use the notepad",
// "Can admin public tasks" => "Can admin public tasks",
// "Can use tasks" => "Can use tasks",
// "Can receive tasks from other users" => "Can receive tasks from other users",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can upload personal files" => "Can upload personal files",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can use the messaging system" => "Can use the messaging system",
// "Can admin comments" => "Can admin comments",
// "Can edit all comments" => "Can edit all comments",
// "Can post new comments" => "Can post new comments",
// "Can read comments" => "Can read comments",
// "Can delete comments" => "Can delete comments",
// "Can vote comments" => "Can vote comments",
// "Can admin content templates" => "Can admin content templates",
// "Can edit content templates" => "Can edit content templates",
// "Can use content templates" => "Can use content templates",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can view HTML pages" => "Can view HTML pages",
// "Can list registered users" => "Can list registered users",
// "Admin live support system" => "Admin live support system",
// "Can use live support system" => "Can use live support system",
// "Can create new mapfile" => "Can create new mapfile",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can use webmail" => "Can use webmail",
// "Can use group webmail" => "Can use group webmail",
// "Can administrate group webmail accounts" => "Can administrate group webmail accounts",
// "Can use personal webmail accounts" => "Can use personal webmail accounts",
// "Can administrate personal webmail accounts" => "Can administrate personal webmail accounts",
// "Can view unapproved plugin details" => "Can view unapproved plugin details",
// "Can execute unapproved plugin" => "Can execute unapproved plugin",
// "Can approve plugin execution" => "Can approve plugin execution",
// "Trust all user inputs (no security checks)" => "Trust all user inputs (no security checks)",
// "View page backlinks" => "View page backlinks",
// "Can admin mail notifications" => "Can admin mail notifications",
// "tiki release" => "tiki release",
// "feature version checks" => "feature version checks",
// "tiki needs upgrade" => "tiki needs upgrade",
// "tiki version last check" => "tiki version last check",
// "tiki version check frequency" => "tiki version check frequency",
// "lastUpdatePrefs" => "lastUpdatePrefs",
// "feature print indexed" => "feature print indexed",
// "feature wiki" => "feature wiki",
// "default wiki diff style" => "default wiki diff style",
// "feature backlinks" => "feature backlinks",
// "feature dump" => "feature dump",
// "feature history" => "feature history",
// "feature lastChanges" => "feature lastChanges",
// "feature likePages" => "feature likePages",
// "feature listPages" => "feature listPages",
// "feature listorphanPages" => "feature listorphanPages",
// "feature page title" => "feature page title",
// "feature sandbox" => "feature sandbox",
// "feature warn on edit" => "feature warn on edit",
// "feature wiki 1like redirection" => "feature wiki 1like redirection",
// "feature wiki allowhtml" => "feature wiki allowhtml",
// "feature wiki argvariable" => "feature wiki argvariable",
// "feature wiki attachments" => "feature wiki attachments",
// "feature wiki comments" => "feature wiki comments",
// "feature wiki description" => "feature wiki description",
// "feature wiki discuss" => "feature wiki discuss",
// "feature wiki export" => "feature wiki export",
// "feature wiki structure" => "feature wiki structure",
// "feature wiki import page" => "feature wiki import page",
// "feature wiki footnotes" => "feature wiki footnotes",
// "feature wiki icache" => "feature wiki icache",
// "feature wiki import html" => "feature wiki import html",
// "feature wiki mindmap" => "feature wiki mindmap",
// "feature wiki monosp" => "feature wiki monosp",
// "feature wiki multiprint" => "feature wiki multiprint",
// "feature wiki notepad" => "feature wiki notepad",
// "feature wiki make structure" => "feature wiki make structure",
// "feature wiki open as structure" => "feature wiki open as structure",
// "feature wiki pageid" => "feature wiki pageid",
// "feature wiki paragraph formatting" => "feature wiki paragraph formatting",
// "feature wiki paragraph formatting add br" => "feature wiki paragraph formatting add br",
// "feature wiki pictures" => "feature wiki pictures",
// "feature wiki plurals" => "feature wiki plurals",
// "feature wiki print" => "feature wiki print",
// "feature wiki protect email" => "feature wiki protect email",
// "feature wiki rankings" => "feature wiki rankings",
// "feature wiki ratings" => "feature wiki ratings",
// "feature wiki replace" => "feature wiki replace",
// "feature wiki show hide before" => "feature wiki show hide before",
// "feature wiki tables" => "feature wiki tables",
// "feature wiki templates" => "feature wiki templates",
// "feature wiki undo" => "feature wiki undo",
// "feature wiki userpage" => "feature wiki userpage",
// "feature wiki userpage prefix" => "feature wiki userpage prefix",
// "feature wiki usrlock" => "feature wiki usrlock",
// "feature wiki feedback polls" => "feature wiki feedback polls",
// "feature wiki save draft" => "feature wiki save draft",
// "feature wikiwords" => "feature wikiwords",
// "feature wikiwords usedash" => "feature wikiwords usedash",
// "feature wiki pagealias" => "feature wiki pagealias",
// "mailin autocheck" => "mailin autocheck",
// "mailin autocheckFreq" => "mailin autocheckFreq",
// "mailin autocheckLast" => "mailin autocheckLast",
// "page bar position" => "page bar position",
// "warn on edit time" => "warn on edit time",
// "wikiHomePage" => "wikiHomePage",
// "wikiLicensePage" => "wikiLicensePage",
// "wikiSubmitNotice" => "wikiSubmitNotice",
// "wiki authors style" => "wiki authors style",
// "wiki authors style by page" => "wiki authors style by page",
// "wiki show version" => "wiki show version",
// "wiki bot bar" => "wiki bot bar",
// "wiki cache" => "wiki cache",
// "wiki comments default ordering" => "wiki comments default ordering",
// "wiki comments displayed default" => "wiki comments displayed default",
// "wiki comments per page" => "wiki comments per page",
// "wiki creator admin" => "wiki creator admin",
// "wiki feature copyrights" => "wiki feature copyrights",
// "wiki forum id" => "wiki forum id",
// "wiki left column" => "wiki left column",
// "wiki list backlinks" => "wiki list backlinks",
// "wiki list comment" => "wiki list comment",
// "wiki list comment len" => "wiki list comment len",
// "wiki list description" => "wiki list description",
// "wiki list description len" => "wiki list description len",
// "wiki list creator" => "wiki list creator",
// "wiki list hits" => "wiki list hits",
// "wiki list lastmodif" => "wiki list lastmodif",
// "wiki list lastver" => "wiki list lastver",
// "wiki list links" => "wiki list links",
// "wiki list name" => "wiki list name",
// "wiki list name len" => "wiki list name len",
// "wiki list size" => "wiki list size",
// "wiki list status" => "wiki list status",
// "wiki list user" => "wiki list user",
// "wiki list versions" => "wiki list versions",
// "wiki list language" => "wiki list language",
// "wiki list categories" => "wiki list categories",
// "wiki list categories path" => "wiki list categories path",
// "wiki list id" => "wiki list id",
// "wiki list sortorder" => "wiki list sortorder",
// "wiki list sortdirection" => "wiki list sortdirection",
// "wiki pagealias tokens" => "wiki pagealias tokens",
// "wiki page regex" => "wiki page regex",
// "wiki page separator" => "wiki page separator",
// "wiki page navigation bar" => "wiki page navigation bar",
// "wiki actions bar" => "wiki actions bar",
// "wiki pagename strip" => "wiki pagename strip",
// "wiki right column" => "wiki right column",
// "wiki top bar" => "wiki top bar",
// "wiki topline position" => "wiki topline position",
// "wiki uses slides" => "wiki uses slides",
// "wiki watch author" => "wiki watch author",
// "wiki watch comments" => "wiki watch comments",
// "wiki watch editor" => "wiki watch editor",
// "wiki watch minor" => "wiki watch minor",
// "feature wiki history full" => "feature wiki history full",
// "feature wiki categorize structure" => "feature wiki categorize structure",
// "feature wiki watch structure" => "feature wiki watch structure",
// "feature wikiapproval" => "feature wikiapproval",
// "wikiapproval prefix" => "wikiapproval prefix",
// "wikiapproval hideprefix" => "wikiapproval hideprefix",
// "wikiapproval delete staging" => "wikiapproval delete staging",
// "wikiapproval master group" => "wikiapproval master group",
// "wikiapproval staging category" => "wikiapproval staging category",
// "wikiapproval approved category" => "wikiapproval approved category",
// "wikiapproval outofsync category" => "wikiapproval outofsync category",
// "wikiapproval block editapproved" => "wikiapproval block editapproved",
// "wikiapproval sync categories" => "wikiapproval sync categories",
// "wikiapproval update freetags" => "wikiapproval update freetags",
// "wikiapproval combine freetags" => "wikiapproval combine freetags",
// "wiki edit section" => "wiki edit section",
// "wiki edit section level" => "wiki edit section level",
// "wiki edit plugin" => "wiki edit plugin",
// "wiki validate plugin" => "wiki validate plugin",
// "wiki edit minor" => "wiki edit minor",
// "wikiplugin agentinfo" => "wikiplugin agentinfo",
// "wikiplugin alink" => "wikiplugin alink",
// "wikiplugin aname" => "wikiplugin aname",
// "wikiplugin annotation" => "wikiplugin annotation",
// "wikiplugin article" => "wikiplugin article",
// "wikiplugin articles" => "wikiplugin articles",
// "wikiplugin attach" => "wikiplugin attach",
// "wikiplugin avatar" => "wikiplugin avatar",
// "wikiplugin back" => "wikiplugin back",
// "wikiplugin backlinks" => "wikiplugin backlinks",
// "wikiplugin banner" => "wikiplugin banner",
// "wikiplugin bloglist" => "wikiplugin bloglist",
// "wikiplugin box" => "wikiplugin box",
// "wikiplugin category" => "wikiplugin category",
// "wikiplugin catorphans" => "wikiplugin catorphans",
// "wikiplugin catpath" => "wikiplugin catpath",
// "wikiplugin center" => "wikiplugin center",
// "wikiplugin chart" => "wikiplugin chart",
// "wikiplugin code" => "wikiplugin code",
// "wikiplugin content" => "wikiplugin content",
// "wikiplugin cookie" => "wikiplugin cookie",
// "wikiplugin copyright" => "wikiplugin copyright",
// "wikiplugin countdown" => "wikiplugin countdown",
// "wikiplugin dbreport" => "wikiplugin dbreport",
// "wikiplugin div" => "wikiplugin div",
// "wikiplugin dl" => "wikiplugin dl",
// "wikiplugin draw" => "wikiplugin draw",
// "wikiplugin equation" => "wikiplugin equation",
// "wikiplugin events" => "wikiplugin events",
// "wikiplugin fade" => "wikiplugin fade",
// "wikiplugin fancylist" => "wikiplugin fancylist",
// "wikiplugin fancytable" => "wikiplugin fancytable",
// "wikiplugin file" => "wikiplugin file",
// "wikiplugin files" => "wikiplugin files",
// "wikiplugin flash" => "wikiplugin flash",
// "wikiplugin footnote" => "wikiplugin footnote",
// "wikiplugin footnotearea" => "wikiplugin footnotearea",
// "wikiplugin ftp" => "wikiplugin ftp",
// "wikiplugin gauge" => "wikiplugin gauge",
// "wikiplugin googleanalytics" => "wikiplugin googleanalytics",
// "wikiplugin googledoc" => "wikiplugin googledoc",
// "wikiplugin group" => "wikiplugin group",
// "wikiplugin html" => "wikiplugin html",
// "wikiplugin iframe" => "wikiplugin iframe",
// "wikiplugin img" => "wikiplugin img",
// "wikiplugin image" => "wikiplugin image",
// "wikiplugin include" => "wikiplugin include",
// "wikiplugin jabber" => "wikiplugin jabber",
// "wikiplugin js" => "wikiplugin js",
// "wikiplugin jq" => "wikiplugin jq",
// "wikiplugin lang" => "wikiplugin lang",
// "wikiplugin lastmod" => "wikiplugin lastmod",
// "wikiplugin listpages" => "wikiplugin listpages",
// "wikiplugin lsdir" => "wikiplugin lsdir",
// "wikiplugin map" => "wikiplugin map",
// "wikiplugin mediaplayer" => "wikiplugin mediaplayer",
// "wikiplugin miniquiz" => "wikiplugin miniquiz",
// "wikiplugin module" => "wikiplugin module",
// "wikiplugin mono" => "wikiplugin mono",
// "wikiplugin mouseover" => "wikiplugin mouseover",
// "wikiplugin mwtable" => "wikiplugin mwtable",
// "wikiplugin myspace" => "wikiplugin myspace",
// "wikiplugin objecthits" => "wikiplugin objecthits",
// "wikiplugin picture" => "wikiplugin picture",
// "wikiplugin pluginmanager" => "wikiplugin pluginmanager",
// "wikiplugin poll" => "wikiplugin poll",
// "wikiplugin profile" => "wikiplugin profile",
// "wikiplugin proposal" => "wikiplugin proposal",
// "wikiplugin quote" => "wikiplugin quote",
// "wikiplugin rcontent" => "wikiplugin rcontent",
// "wikiplugin redirect" => "wikiplugin redirect",
// "wikiplugin regex" => "wikiplugin regex",
// "wikiplugin remarksbox" => "wikiplugin remarksbox",
// "wikiplugin rss" => "wikiplugin rss",
// "wikiplugin sf" => "wikiplugin sf",
// "wikiplugin share" => "wikiplugin share",
// "wikiplugin sharethis" => "wikiplugin sharethis",
// "wikiplugin sheet" => "wikiplugin sheet",
// "wikiplugin showpages" => "wikiplugin showpages",
// "wikiplugin skype" => "wikiplugin skype",
// "wikiplugin snarf" => "wikiplugin snarf",
// "wikiplugin sort" => "wikiplugin sort",
// "wikiplugin split" => "wikiplugin split",
// "wikiplugin sql" => "wikiplugin sql",
// "wikiplugin sub" => "wikiplugin sub",
// "wikiplugin subscribegroup" => "wikiplugin subscribegroup",
// "wikiplugin subscribegroups" => "wikiplugin subscribegroups",
// "wikiplugin sup" => "wikiplugin sup",
// "wikiplugin survey" => "wikiplugin survey",
// "wikiplugin tag" => "wikiplugin tag",
// "wikiplugin thumb" => "wikiplugin thumb",
// "wikiplugin titlesearch" => "wikiplugin titlesearch",
// "wikiplugin toc" => "wikiplugin toc",
// "wikiplugin topfriends" => "wikiplugin topfriends",
// "wikiplugin trackerfilter" => "wikiplugin trackerfilter",
// "wikiplugin trackeritemfield" => "wikiplugin trackeritemfield",
// "wikiplugin trackerlist" => "wikiplugin trackerlist",
// "wikiplugin trackertimeline" => "wikiplugin trackertimeline",
// "wikiplugin tracker" => "wikiplugin tracker",
// "wikiplugin trackerprefill" => "wikiplugin trackerprefill",
// "wikiplugin trackerstat" => "wikiplugin trackerstat",
// "wikiplugin translated" => "wikiplugin translated",
// "wikiplugin tr" => "wikiplugin tr",
// "wikiplugin usercount" => "wikiplugin usercount",
// "wikiplugin userlist" => "wikiplugin userlist",
// "wikiplugin versions" => "wikiplugin versions",
// "wikiplugin vote" => "wikiplugin vote",
// "wikiplugin wantedpages" => "wikiplugin wantedpages",
// "wikiplugin webservice" => "wikiplugin webservice",
// "wikiplugin youtube" => "wikiplugin youtube",
// "wikiplugininline agentinfo" => "wikiplugininline agentinfo",
// "wikiplugininline alink" => "wikiplugininline alink",
// "wikiplugininline aname" => "wikiplugininline aname",
// "wikiplugininline annotation" => "wikiplugininline annotation",
// "wikiplugininline article" => "wikiplugininline article",
// "wikiplugininline articles" => "wikiplugininline articles",
// "wikiplugininline attach" => "wikiplugininline attach",
// "wikiplugininline avatar" => "wikiplugininline avatar",
// "wikiplugininline back" => "wikiplugininline back",
// "wikiplugininline backlinks" => "wikiplugininline backlinks",
// "wikiplugininline banner" => "wikiplugininline banner",
// "wikiplugininline bloglist" => "wikiplugininline bloglist",
// "wikiplugininline box" => "wikiplugininline box",
// "wikiplugininline category" => "wikiplugininline category",
// "wikiplugininline catorphans" => "wikiplugininline catorphans",
// "wikiplugininline catpath" => "wikiplugininline catpath",
// "wikiplugininline center" => "wikiplugininline center",
// "wikiplugininline chart" => "wikiplugininline chart",
// "wikiplugininline code" => "wikiplugininline code",
// "wikiplugininline content" => "wikiplugininline content",
// "wikiplugininline cookie" => "wikiplugininline cookie",
// "wikiplugininline copyright" => "wikiplugininline copyright",
// "wikiplugininline countdown" => "wikiplugininline countdown",
// "wikiplugininline dbreport" => "wikiplugininline dbreport",
// "wikiplugininline div" => "wikiplugininline div",
// "wikiplugininline dl" => "wikiplugininline dl",
// "wikiplugininline draw" => "wikiplugininline draw",
// "wikiplugininline equation" => "wikiplugininline equation",
// "wikiplugininline events" => "wikiplugininline events",
// "wikiplugininline fade" => "wikiplugininline fade",
// "wikiplugininline fancylist" => "wikiplugininline fancylist",
// "wikiplugininline fancytable" => "wikiplugininline fancytable",
// "wikiplugininline file" => "wikiplugininline file",
// "wikiplugininline files" => "wikiplugininline files",
// "wikiplugininline flash" => "wikiplugininline flash",
// "wikiplugininline footnote" => "wikiplugininline footnote",
// "wikiplugininline footnotearea" => "wikiplugininline footnotearea",
// "wikiplugininline ftp" => "wikiplugininline ftp",
// "wikiplugininline gauge" => "wikiplugininline gauge",
// "wikiplugininline googleanalytics" => "wikiplugininline googleanalytics",
// "wikiplugininline googledoc" => "wikiplugininline googledoc",
// "wikiplugininline group" => "wikiplugininline group",
// "wikiplugininline html" => "wikiplugininline html",
// "wikiplugininline iframe" => "wikiplugininline iframe",
// "wikiplugininline img" => "wikiplugininline img",
// "wikiplugininline image" => "wikiplugininline image",
// "wikiplugininline include" => "wikiplugininline include",
// "wikiplugininline jabber" => "wikiplugininline jabber",
// "wikiplugininline js" => "wikiplugininline js",
// "wikiplugininline jq" => "wikiplugininline jq",
// "wikiplugininline lang" => "wikiplugininline lang",
// "wikiplugininline lastmod" => "wikiplugininline lastmod",
// "wikiplugininline listpages" => "wikiplugininline listpages",
// "wikiplugininline lsdir" => "wikiplugininline lsdir",
// "wikiplugininline map" => "wikiplugininline map",
// "wikiplugininline mediaplayer" => "wikiplugininline mediaplayer",
// "wikiplugininline miniquiz" => "wikiplugininline miniquiz",
// "wikiplugininline module" => "wikiplugininline module",
// "wikiplugininline mono" => "wikiplugininline mono",
// "wikiplugininline mouseover" => "wikiplugininline mouseover",
// "wikiplugininline mwtable" => "wikiplugininline mwtable",
// "wikiplugininline myspace" => "wikiplugininline myspace",
// "wikiplugininline objecthits" => "wikiplugininline objecthits",
// "wikiplugininline picture" => "wikiplugininline picture",
// "wikiplugininline pluginmanager" => "wikiplugininline pluginmanager",
// "wikiplugininline poll" => "wikiplugininline poll",
// "wikiplugininline profile" => "wikiplugininline profile",
// "wikiplugininline proposal" => "wikiplugininline proposal",
// "wikiplugininline quote" => "wikiplugininline quote",
// "wikiplugininline rcontent" => "wikiplugininline rcontent",
// "wikiplugininline redirect" => "wikiplugininline redirect",
// "wikiplugininline regex" => "wikiplugininline regex",
// "wikiplugininline remarksbox" => "wikiplugininline remarksbox",
// "wikiplugininline rss" => "wikiplugininline rss",
// "wikiplugininline sf" => "wikiplugininline sf",
// "wikiplugininline share" => "wikiplugininline share",
// "wikiplugininline sharethis" => "wikiplugininline sharethis",
// "wikiplugininline sheet" => "wikiplugininline sheet",
// "wikiplugininline showpages" => "wikiplugininline showpages",
// "wikiplugininline skype" => "wikiplugininline skype",
// "wikiplugininline snarf" => "wikiplugininline snarf",
// "wikiplugininline sort" => "wikiplugininline sort",
// "wikiplugininline split" => "wikiplugininline split",
// "wikiplugininline sql" => "wikiplugininline sql",
// "wikiplugininline sub" => "wikiplugininline sub",
// "wikiplugininline subscribegroup" => "wikiplugininline subscribegroup",
// "wikiplugininline subscribegroups" => "wikiplugininline subscribegroups",
// "wikiplugininline sup" => "wikiplugininline sup",
// "wikiplugininline survey" => "wikiplugininline survey",
// "wikiplugininline tag" => "wikiplugininline tag",
// "wikiplugininline thumb" => "wikiplugininline thumb",
// "wikiplugininline titlesearch" => "wikiplugininline titlesearch",
// "wikiplugininline toc" => "wikiplugininline toc",
// "wikiplugininline topfriends" => "wikiplugininline topfriends",
// "wikiplugininline trackerfilter" => "wikiplugininline trackerfilter",
// "wikiplugininline trackeritemfield" => "wikiplugininline trackeritemfield",
// "wikiplugininline trackerlist" => "wikiplugininline trackerlist",
// "wikiplugininline trackertimeline" => "wikiplugininline trackertimeline",
// "wikiplugininline tracker" => "wikiplugininline tracker",
// "wikiplugininline trackerprefill" => "wikiplugininline trackerprefill",
// "wikiplugininline trackerstat" => "wikiplugininline trackerstat",
// "wikiplugininline translated" => "wikiplugininline translated",
// "wikiplugininline tr" => "wikiplugininline tr",
// "wikiplugininline usercount" => "wikiplugininline usercount",
// "wikiplugininline userlist" => "wikiplugininline userlist",
// "wikiplugininline versions" => "wikiplugininline versions",
// "wikiplugininline vote" => "wikiplugininline vote",
// "wikiplugininline wantedpages" => "wikiplugininline wantedpages",
// "wikiplugininline webservice" => "wikiplugininline webservice",
// "wikiplugininline youtube" => "wikiplugininline youtube",
// "webservice consume defaultcache" => "webservice consume defaultcache",
// "feature wysiwyg" => "feature wysiwyg",
// "wysiwyg optional" => "wysiwyg optional",
// "wysiwyg default" => "wysiwyg default",
// "wysiwyg memo" => "wysiwyg memo",
// "wysiwyg wiki parsed" => "wysiwyg wiki parsed",
// "wysiwyg wiki semi parsed" => "wysiwyg wiki semi parsed",
// "wysiwyg toolbar skin" => "wysiwyg toolbar skin",
// "wysiwyg toolbar" => "wysiwyg toolbar",
// "wiki feature 3d" => "wiki feature 3d",
// "wiki 3d width" => "wiki 3d width",
// "wiki 3d height" => "wiki 3d height",
// "wiki 3d navigation depth" => "wiki 3d navigation depth",
// "wiki 3d feed animation interval" => "wiki 3d feed animation interval",
// "wiki 3d existing page color" => "wiki 3d existing page color",
// "wiki 3d missing page color" => "wiki 3d missing page color",
// "feature blogs" => "feature blogs",
// "blog list order" => "blog list order",
// "home blog" => "home blog",
// "feature blog rankings" => "feature blog rankings",
// "feature blog comments" => "feature blog comments",
// "blog comments default ordering" => "blog comments default ordering",
// "blog comments per page" => "blog comments per page",
// "feature blogposts comments" => "feature blogposts comments",
// "blog list user" => "blog list user",
// "blog list title" => "blog list title",
// "blog list title len" => "blog list title len",
// "blog list description" => "blog list description",
// "blog list created" => "blog list created",
// "blog list lastmodif" => "blog list lastmodif",
// "blog list posts" => "blog list posts",
// "blog list visits" => "blog list visits",
// "blog list activity" => "blog list activity",
// "feature blog mandatory category" => "feature blog mandatory category",
// "feature blog heading" => "feature blog heading",
// "feature file galleries" => "feature file galleries",
// "home file gallery" => "home file gallery",
// "fgal use db" => "fgal use db",
// "fgal batch dir" => "fgal batch dir",
// "fgal match regex" => "fgal match regex",
// "fgal nmatch regex" => "fgal nmatch regex",
// "fgal use dir" => "fgal use dir",
// "fgal podcast dir" => "fgal podcast dir",
// "feature file galleries comments" => "feature file galleries comments",
// "file galleries comments default ordering" => "file galleries comments default ordering",
// "file galleries comments per page" => "file galleries comments per page",
// "feature file galleries batch" => "feature file galleries batch",
// "feature file galleries rankings" => "feature file galleries rankings",
// "fgal enable auto indexing" => "fgal enable auto indexing",
// "fgal asynchronous indexing" => "fgal asynchronous indexing",
// "fgal allow duplicates" => "fgal allow duplicates",
// "fgal sort mode" => "fgal sort mode",
// "feature file galleries author" => "feature file galleries author",
// "fgal list id" => "fgal list id",
// "fgal list type" => "fgal list type",
// "fgal list name" => "fgal list name",
// "fgal list description" => "fgal list description",
// "fgal list size" => "fgal list size",
// "fgal list created" => "fgal list created",
// "fgal list lastmodif" => "fgal list lastmodif",
// "fgal list creator" => "fgal list creator",
// "fgal list author" => "fgal list author",
// "fgal list last user" => "fgal list last user",
// "fgal list comment" => "fgal list comment",
// "fgal list files" => "fgal list files",
// "fgal list hits" => "fgal list hits",
// "fgal list lockedby" => "fgal list lockedby",
// "fgal show path" => "fgal show path",
// "fgal show explorer" => "fgal show explorer",
// "fgal show slideshow" => "fgal show slideshow",
// "fgal default view" => "fgal default view",
// "fgal limit hits per file" => "fgal limit hits per file",
// "fgal prevent negative score" => "fgal prevent negative score",
// "feature galleries" => "feature galleries",
// "feature gal batch" => "feature gal batch",
// "feature gal slideshow" => "feature gal slideshow",
// "home gallery" => "home gallery",
// "gal use db" => "gal use db",
// "gal use lib" => "gal use lib",
// "gal match regex" => "gal match regex",
// "gal nmatch regex" => "gal nmatch regex",
// "gal use dir" => "gal use dir",
// "gal batch dir" => "gal batch dir",
// "feature gal rankings" => "feature gal rankings",
// "feature image galleries comments" => "feature image galleries comments",
// "image galleries comments default order" => "image galleries comments default order",
// "image galleries comments per page" => "image galleries comments per page",
// "gal list name" => "gal list name",
// "gal list parent" => "gal list parent",
// "gal list description" => "gal list description",
// "gal list created" => "gal list created",
// "gal list lastmodif" => "gal list lastmodif",
// "gal list user" => "gal list user",
// "gal list imgs" => "gal list imgs",
// "gal list visits" => "gal list visits",
// "feature image gallery mandatory category" => "feature image gallery mandatory category",
// "preset galleries info" => "preset galleries info",
// "gal image mouseover" => "gal image mouseover",
// "ProgressBarPlay" => "ProgressBarPlay",
// "ProgressBarLoad" => "ProgressBarLoad",
// "ProgressBarButton" => "ProgressBarButton",
// "ProgressBar" => "ProgressBar",
// "VolumeOn" => "VolumeOn",
// "VolumeOff" => "VolumeOff",
// "VolumeButton" => "VolumeButton",
// "Button" => "Button",
// "ButtonPressed" => "ButtonPressed",
// "ButtonOver" => "ButtonOver",
// "ButtonInfo" => "ButtonInfo",
// "ButtonInfoPressed" => "ButtonInfoPressed",
// "ButtonInfoOver" => "ButtonInfoOver",
// "ButtonInfoText" => "ButtonInfoText",
// "ID3" => "ID3",
// "PlayTime" => "PlayTime",
// "TotalTime" => "TotalTime",
// "PanelDisplay" => "PanelDisplay",
// "AlertMesg" => "AlertMesg",
// "PreloadDelay" => "PreloadDelay",
// "VideoHeight" => "VideoHeight",
// "VideoLength" => "VideoLength",
// "URLAppend" => "URLAppend",
// "LimitedMsg" => "LimitedMsg",
// "MaxPlay" => "MaxPlay",
// "MultimediaGalerie" => "MultimediaGalerie",
// "MultimediaDefaultLength" => "MultimediaDefaultLength",
// "MultimediaDefaultHeight" => "MultimediaDefaultHeight",
// "feature forums" => "feature forums",
// "home forum" => "home forum",
// "feature forum rankings" => "feature forum rankings",
// "feature forum parse" => "feature forum parse",
// "feature forum topics archiving" => "feature forum topics archiving",
// "feature forum replyempty" => "feature forum replyempty",
// "feature forum quickjump" => "feature forum quickjump",
// "feature forums allow thread titles" => "feature forums allow thread titles",
// "feature forum content search" => "feature forum content search",
// "feature forums name search" => "feature forums name search",
// "forums ordering" => "forums ordering",
// "forum list topics" => "forum list topics",
// "forum list posts" => "forum list posts",
// "forum list ppd" => "forum list ppd",
// "forum list lastpost" => "forum list lastpost",
// "forum list visits" => "forum list visits",
// "forum list desc" => "forum list desc",
// "forum list description len" => "forum list description len",
// "feature forum local search" => "feature forum local search",
// "feature forum local tiki search" => "feature forum local tiki search",
// "forum thread defaults by forum" => "forum thread defaults by forum",
// "forum thread user settings" => "forum thread user settings",
// "forum thread user settings keep" => "forum thread user settings keep",
// "forum comments per page" => "forum comments per page",
// "forum comments no title prefix" => "forum comments no title prefix",
// "forum thread style" => "forum thread style",
// "forum thread sort mode" => "forum thread sort mode",
// "forum match regex" => "forum match regex",
// "feature articles" => "feature articles",
// "feature submissions" => "feature submissions",
// "feature cms rankings" => "feature cms rankings",
// "feature cms print" => "feature cms print",
// "feature cms emails" => "feature cms emails",
// "art list title" => "art list title",
// "art list title len" => "art list title len",
// "art list topic" => "art list topic",
// "art list date" => "art list date",
// "art list author" => "art list author",
// "art list reads" => "art list reads",
// "art list size" => "art list size",
// "art list expire" => "art list expire",
// "art list img" => "art list img",
// "art list type" => "art list type",
// "art list visible" => "art list visible",
// "art view type" => "art view type",
// "art view title" => "art view title",
// "art view topic" => "art view topic",
// "art view date" => "art view date",
// "art view author" => "art view author",
// "art view reads" => "art view reads",
// "art view size" => "art view size",
// "art view img" => "art view img",
// "art list lang" => "art list lang",
// "feature article comments" => "feature article comments",
// "article comments default ordering" => "article comments default ordering",
// "article comments per page" => "article comments per page",
// "article image size x" => "article image size x",
// "article image size y" => "article image size y",
// "feature cms templates" => "feature cms templates",
// "cms bot bar" => "cms bot bar",
// "cms left column" => "cms left column",
// "cms right column" => "cms right column",
// "cms top bar" => "cms top bar",
// "cms spellcheck" => "cms spellcheck",
// "art home title" => "art home title",
// "feature trackers" => "feature trackers",
// "t use db" => "t use db",
// "t use dir" => "t use dir",
// "groupTracker" => "groupTracker",
// "userTracker" => "userTracker",
// "trk with mirror tables" => "trk with mirror tables",
// "feature userlevels" => "feature userlevels",
// "userlevels" => "userlevels",
// "userbreadCrumb" => "userbreadCrumb",
// "user assigned modules" => "user assigned modules",
// "user flip modules" => "user flip modules",
// "user show realnames" => "user show realnames",
// "feature mytiki" => "feature mytiki",
// "feature userPreferences" => "feature userPreferences",
// "feature user bookmarks" => "feature user bookmarks",
// "feature tasks" => "feature tasks",
// "w use db" => "w use db",
// "w use dir" => "w use dir",
// "w displayed default" => "w displayed default",
// "uf use db" => "uf use db",
// "uf use dir" => "uf use dir",
// "userfiles quota" => "userfiles quota",
// "feature usermenu" => "feature usermenu",
// "feature minical" => "feature minical",
// "feature notepad" => "feature notepad",
// "feature userfiles" => "feature userfiles",
// "feature community gender" => "feature community gender",
// "feature community mouseover" => "feature community mouseover",
// "feature community mouseover name" => "feature community mouseover name",
// "feature community mouseover gender" => "feature community mouseover gender",
// "feature community mouseover picture" => "feature community mouseover picture",
// "feature community mouseover friends" => "feature community mouseover friends",
// "feature community mouseover score" => "feature community mouseover score",
// "feature community mouseover country" => "feature community mouseover country",
// "feature community mouseover email" => "feature community mouseover email",
// "feature community mouseover lastlogin" => "feature community mouseover lastlogin",
// "feature community mouseover distance" => "feature community mouseover distance",
// "feature community list name" => "feature community list name",
// "feature community list score" => "feature community list score",
// "feature community list country" => "feature community list country",
// "feature community list distance" => "feature community list distance",
// "feature community friends permission" => "feature community friends permission",
// "feature community friends permission dep" => "feature community friends permission dep",
// "change language" => "change language",
// "change theme" => "change theme",
// "login is email" => "login is email",
// "validateUsers" => "validateUsers",
// "validateEmail" => "validateEmail",
// "forgotPass" => "forgotPass",
// "available languages" => "available languages",
// "available styles" => "available styles",
// "lowercase username" => "lowercase username",
// "username pattern" => "username pattern",
// "max username length" => "max username length",
// "min username length" => "min username length",
// "users prefs allowMsgs" => "users prefs allowMsgs",
// "users prefs country" => "users prefs country",
// "users prefs diff versions" => "users prefs diff versions",
// "users prefs display timezone" => "users prefs display timezone",
// "users prefs email is public" => "users prefs email is public",
// "users prefs homePage" => "users prefs homePage",
// "users prefs lat" => "users prefs lat",
// "users prefs lon" => "users prefs lon",
// "users prefs mess archiveAfter" => "users prefs mess archiveAfter",
// "users prefs mess maxRecords" => "users prefs mess maxRecords",
// "users prefs mess sendReadStatus" => "users prefs mess sendReadStatus",
// "users prefs minPrio" => "users prefs minPrio",
// "users prefs mytiki blogs" => "users prefs mytiki blogs",
// "users prefs mytiki articles" => "users prefs mytiki articles",
// "users prefs mytiki gals" => "users prefs mytiki gals",
// "users prefs mytiki items" => "users prefs mytiki items",
// "users prefs mytiki msgs" => "users prefs mytiki msgs",
// "users prefs mytiki pages" => "users prefs mytiki pages",
// "users prefs mytiki tasks" => "users prefs mytiki tasks",
// "users prefs mytiki workflow" => "users prefs mytiki workflow",
// "users prefs mytiki forum topics" => "users prefs mytiki forum topics",
// "users prefs mytiki forum replies" => "users prefs mytiki forum replies",
// "users prefs realName" => "users prefs realName",
// "users prefs gender" => "users prefs gender",
// "users prefs show mouseover user info" => "users prefs show mouseover user info",
// "users prefs tasks maxRecords" => "users prefs tasks maxRecords",
// "users prefs user dbl" => "users prefs user dbl",
// "users prefs user information" => "users prefs user information",
// "users prefs userbreadCrumb" => "users prefs userbreadCrumb",
// "users prefs mailCharset" => "users prefs mailCharset",
// "validateRegistration" => "validateRegistration",
// "feature messages" => "feature messages",
// "messu mailbox size" => "messu mailbox size",
// "messu archive size" => "messu archive size",
// "messu sent size" => "messu sent size",
// "allowmsg by default" => "allowmsg by default",
// "allowmsg is optional" => "allowmsg is optional",
// "feature newsreader" => "feature newsreader",
// "feature freetags" => "feature freetags",
// "freetags browse show cloud" => "freetags browse show cloud",
// "freetags cloud colors" => "freetags cloud colors",
// "freetags preload random search" => "freetags preload random search",
// "freetags browse amount tags in cloud" => "freetags browse amount tags in cloud",
// "freetags browse amount tags suggestion" => "freetags browse amount tags suggestion",
// "freetags normalized valid chars" => "freetags normalized valid chars",
// "freetags lowercase only" => "freetags lowercase only",
// "freetags feature 3d" => "freetags feature 3d",
// "freetags 3d width" => "freetags 3d width",
// "freetags 3d height" => "freetags 3d height",
// "freetags 3d navigation depth" => "freetags 3d navigation depth",
// "freetags 3d feed animation interval" => "freetags 3d feed animation interval",
// "freetags 3d existing page color" => "freetags 3d existing page color",
// "freetags 3d missing page color" => "freetags 3d missing page color",
// "freetags 3d autoload" => "freetags 3d autoload",
// "freetags 3d camera distance" => "freetags 3d camera distance",
// "freetags 3d elastic constant" => "freetags 3d elastic constant",
// "freetags 3d eletrostatic constant" => "freetags 3d eletrostatic constant",
// "freetags 3d fov" => "freetags 3d fov",
// "freetags 3d friction constant" => "freetags 3d friction constant",
// "freetags 3d node charge" => "freetags 3d node charge",
// "freetags 3d node mass" => "freetags 3d node mass",
// "freetags 3d node size" => "freetags 3d node size",
// "freetags 3d spring size" => "freetags 3d spring size",
// "freetags 3d text size" => "freetags 3d text size",
// "freetags 3d adjust camera" => "freetags 3d adjust camera",
// "freetags multilingual" => "freetags multilingual",
// "morelikethis algorithm" => "morelikethis algorithm",
// "morelikethis basic mincommon" => "morelikethis basic mincommon",
// "freetags show middle" => "freetags show middle",
// "feature search stats" => "feature search stats",
// "feature search" => "feature search",
// "feature search fulltext" => "feature search fulltext",
// "feature search show forbidden obj" => "feature search show forbidden obj",
// "feature search show forbidden cat" => "feature search show forbidden cat",
// "feature search show object filter" => "feature search show object filter",
// "feature search show search box" => "feature search show search box",
// "feature search show visit count" => "feature search show visit count",
// "feature search show pertinence" => "feature search show pertinence",
// "feature search show object type" => "feature search show object type",
// "feature search show last modification" => "feature search show last modification",
// "search refresh index mode" => "search refresh index mode",
// "search parsed snippet" => "search parsed snippet",
// "feature webmail" => "feature webmail",
// "webmail max attachment" => "webmail max attachment",
// "webmail view html" => "webmail view html",
// "feature contacts" => "feature contacts",
// "feature faqs" => "feature faqs",
// "feature faq comments" => "feature faq comments",
// "faq comments per page" => "faq comments per page",
// "faq comments default ordering" => "faq comments default ordering",
// "faq prefix" => "faq prefix",
// "feature quizzes" => "feature quizzes",
// "feature polls" => "feature polls",
// "feature poll comments" => "feature poll comments",
// "feature poll anonymous" => "feature poll anonymous",
// "poll comments default ordering" => "poll comments default ordering",
// "poll comments per page" => "poll comments per page",
// "poll list categories" => "poll list categories",
// "poll list objects" => "poll list objects",
// "feature poll revote" => "feature poll revote",
// "feature surveys" => "feature surveys",
// "feature featuredLinks" => "feature featuredLinks",
// "feature directory" => "feature directory",
// "directory columns" => "directory columns",
// "directory links per page" => "directory links per page",
// "directory open links" => "directory open links",
// "directory validate urls" => "directory validate urls",
// "directory cool sites" => "directory cool sites",
// "directory country flag" => "directory country flag",
// "feature calendar" => "feature calendar",
// "feature default calendars" => "feature default calendars",
// "calendar sticky popup" => "calendar sticky popup",
// "default calendars" => "default calendars",
// "calendar view mode" => "calendar view mode",
// "calendar view tab" => "calendar view tab",
// "calendar firstDayofWeek" => "calendar firstDayofWeek",
// "calendar timespan" => "calendar timespan",
// "feature jscalendar" => "feature jscalendar",
// "feature action calendar" => "feature action calendar",
// "calendar start year" => "calendar start year",
// "calendar end year" => "calendar end year",
// "calendar list begins focus" => "calendar list begins focus",
// "server timezone" => "server timezone",
// "long date format" => "long date format",
// "long time format" => "long time format",
// "short date format" => "short date format",
// "short time format" => "short time format",
// "display field order" => "display field order",
// "feature charts" => "feature charts",
// "rss forums" => "rss forums",
// "rss forum" => "rss forum",
// "rss directories" => "rss directories",
// "rss articles" => "rss articles",
// "rss blogs" => "rss blogs",
// "rss image galleries" => "rss image galleries",
// "rss file galleries" => "rss file galleries",
// "rss wiki" => "rss wiki",
// "rss image gallery" => "rss image gallery",
// "rss file gallery" => "rss file gallery",
// "rss blog" => "rss blog",
// "rss tracker" => "rss tracker",
// "rss trackers" => "rss trackers",
// "rss calendar" => "rss calendar",
// "rss mapfiles" => "rss mapfiles",
// "rss cache time" => "rss cache time",
// "max rss forums" => "max rss forums",
// "max rss forum" => "max rss forum",
// "max rss directories" => "max rss directories",
// "max rss articles" => "max rss articles",
// "max rss blogs" => "max rss blogs",
// "max rss image galleries" => "max rss image galleries",
// "max rss file galleries" => "max rss file galleries",
// "max rss wiki" => "max rss wiki",
// "max rss image gallery" => "max rss image gallery",
// "max rss file gallery" => "max rss file gallery",
// "max rss blog" => "max rss blog",
// "max rss mapfiles" => "max rss mapfiles",
// "max rss tracker" => "max rss tracker",
// "max rss trackers" => "max rss trackers",
// "max rss calendar" => "max rss calendar",
// "summary rss blogs" => "summary rss blogs",
// "rssfeed default version" => "rssfeed default version",
// "rssfeed language" => "rssfeed language",
// "rssfeed editor" => "rssfeed editor",
// "rssfeed webmaster" => "rssfeed webmaster",
// "rssfeed creator" => "rssfeed creator",
// "rssfeed css" => "rssfeed css",
// "rssfeed publisher" => "rssfeed publisher",
// "rssfeed img" => "rssfeed img",
// "rss basic auth" => "rss basic auth",
// "feature maps" => "feature maps",
// "map path" => "map path",
// "default map" => "default map",
// "map help" => "map help",
// "map comments" => "map comments",
// "gdaltindex" => "gdaltindex",
// "ogr2ogr" => "ogr2ogr",
// "mapzone" => "mapzone",
// "feature gmap" => "feature gmap",
// "gmap defaultx" => "gmap defaultx",
// "gmap defaulty" => "gmap defaulty",
// "gmap defaultz" => "gmap defaultz",
// "gmap key" => "gmap key",
// "allowRegister" => "allowRegister",
// "eponymousGroups" => "eponymousGroups",
// "useRegisterPasscode" => "useRegisterPasscode",
// "registerPasscode" => "registerPasscode",
// "rememberme" => "rememberme",
// "remembertime" => "remembertime",
// "feature clear passwords" => "feature clear passwords",
// "feature crypt passwords" => "feature crypt passwords",
// "feature challenge" => "feature challenge",
// "min user length" => "min user length",
// "min pass length" => "min pass length",
// "pass chr num" => "pass chr num",
// "pass due" => "pass due",
// "email due" => "email due",
// "unsuccessful logins" => "unsuccessful logins",
// "rnd num reg" => "rnd num reg",
// "generate password" => "generate password",
// "auth method" => "auth method",
// "auth pear" => "auth pear",
// "auth create user tiki" => "auth create user tiki",
// "auth create user auth" => "auth create user auth",
// "auth skip admin" => "auth skip admin",
// "auth ldap url" => "auth ldap url",
// "auth pear host" => "auth pear host",
// "auth pear port" => "auth pear port",
// "auth ldap scope" => "auth ldap scope",
// "auth ldap basedn" => "auth ldap basedn",
// "auth ldap userdn" => "auth ldap userdn",
// "auth ldap userattr" => "auth ldap userattr",
// "auth ldap useroc" => "auth ldap useroc",
// "auth ldap groupdn" => "auth ldap groupdn",
// "auth ldap groupattr" => "auth ldap groupattr",
// "auth ldap groupoc" => "auth ldap groupoc",
// "auth ldap memberattr" => "auth ldap memberattr",
// "auth ldap memberisdn" => "auth ldap memberisdn",
// "auth ldap adminuser" => "auth ldap adminuser",
// "auth ldap adminpass" => "auth ldap adminpass",
// "auth ldap version" => "auth ldap version",
// "auth ldap nameattr" => "auth ldap nameattr",
// "auth ldap countryattr" => "auth ldap countryattr",
// "auth ldap emailattr" => "auth ldap emailattr",
// "https login" => "https login",
// "feature show stay in ssl mode" => "feature show stay in ssl mode",
// "feature switch ssl mode" => "feature switch ssl mode",
// "https port" => "https port",
// "http port" => "http port",
// "login url" => "login url",
// "login scr" => "login scr",
// "register url" => "register url",
// "error url" => "error url",
// "highlight group" => "highlight group",
// "cookie path" => "cookie path",
// "cookie domain" => "cookie domain",
// "cookie name" => "cookie name",
// "user tracker infos" => "user tracker infos",
// "desactive login autocomplete" => "desactive login autocomplete",
// "permission denied login box" => "permission denied login box",
// "permission denied url" => "permission denied url",
// "feature intertiki" => "feature intertiki",
// "feature intertiki server" => "feature intertiki server",
// "feature intertiki slavemode" => "feature intertiki slavemode",
// "interlist" => "interlist",
// "feature intertiki mymaster" => "feature intertiki mymaster",
// "feature intertiki import preferences" => "feature intertiki import preferences",
// "feature intertiki import groups" => "feature intertiki import groups",
// "known hosts" => "known hosts",
// "tiki key" => "tiki key",
// "intertiki logfile" => "intertiki logfile",
// "intertiki errfile" => "intertiki errfile",
// "feature intertiki sharedcookie" => "feature intertiki sharedcookie",
// "search lru length" => "search lru length",
// "search lru purge rate" => "search lru purge rate",
// "search max syllwords" => "search max syllwords",
// "search min wordlength" => "search min wordlength",
// "search refresh rate" => "search refresh rate",
// "search syll age" => "search syll age",
// "feature categories" => "feature categories",
// "feature categoryobjects" => "feature categoryobjects",
// "feature categorypath" => "feature categorypath",
// "feature category reinforce" => "feature category reinforce",
// "feature category use phplayers" => "feature category use phplayers",
// "categorypath excluded" => "categorypath excluded",
// "categories used in tpl" => "categories used in tpl",
// "feature games" => "feature games",
// "feature html pages" => "feature html pages",
// "feature filegals manager" => "feature filegals manager",
// "feature contact" => "feature contact",
// "contact user" => "contact user",
// "contact anon" => "contact anon",
// "mail crlf" => "mail crlf",
// "feature detect language" => "feature detect language",
// "feature homePage if bl missing" => "feature homePage if bl missing",
// "record untranslated" => "record untranslated",
// "feature best language" => "feature best language",
// "feature translation" => "feature translation",
// "feature urgent translation" => "feature urgent translation",
// "lang use db" => "lang use db",
// "language" => "language",
// "feature babelfish" => "feature babelfish",
// "feature babelfish logo" => "feature babelfish logo",
// "quantify changes" => "quantify changes",
// "feature sync language" => "feature sync language",
// "show available translations" => "show available translations",
// "metatag keywords" => "metatag keywords",
// "metatag threadtitle" => "metatag threadtitle",
// "metatag imagetitle" => "metatag imagetitle",
// "metatag freetags" => "metatag freetags",
// "metatag description" => "metatag description",
// "metatag author" => "metatag author",
// "metatag geoposition" => "metatag geoposition",
// "metatag georegion" => "metatag georegion",
// "metatag geoplacename" => "metatag geoplacename",
// "metatag robots" => "metatag robots",
// "metatag revisitafter" => "metatag revisitafter",
// "head extra js" => "head extra js",
// "keep versions" => "keep versions",
// "feature custom home" => "feature custom home",
// "site crumb seper" => "site crumb seper",
// "site nav seper" => "site nav seper",
// "feature sitemycode" => "feature sitemycode",
// "sitemycode" => "sitemycode",
// "sitemycode publish" => "sitemycode publish",
// "feature sitelogo" => "feature sitelogo",
// "sitelogo bgcolor" => "sitelogo bgcolor",
// "sitelogo bgstyle" => "sitelogo bgstyle",
// "sitelogo align" => "sitelogo align",
// "sitelogo title" => "sitelogo title",
// "sitelogo src" => "sitelogo src",
// "sitelogo alt" => "sitelogo alt",
// "feature siteloc" => "feature siteloc",
// "feature sitenav" => "feature sitenav",
// "sitenav" => "sitenav",
// "feature sitead" => "feature sitead",
// "sitead" => "sitead",
// "sitead publish" => "sitead publish",
// "feature breadcrumbs" => "feature breadcrumbs",
// "feature siteloclabel" => "feature siteloclabel",
// "feature sitesearch" => "feature sitesearch",
// "feature site login" => "feature site login",
// "feature sitemenu" => "feature sitemenu",
// "feature topbar version" => "feature topbar version",
// "feature topbar debug" => "feature topbar debug",
// "feature topbar id menu" => "feature topbar id menu",
// "feature topbar custom code" => "feature topbar custom code",
// "feature sitetitle" => "feature sitetitle",
// "feature sitedesc" => "feature sitedesc",
// "feature bot logo" => "feature bot logo",
// "feature endbody code" => "feature endbody code",
// "feature left column" => "feature left column",
// "feature right column" => "feature right column",
// "feature top bar" => "feature top bar",
// "feature bot bar" => "feature bot bar",
// "feature bot bar icons" => "feature bot bar icons",
// "feature bot bar debug" => "feature bot bar debug",
// "feature bot bar rss" => "feature bot bar rss",
// "feature bot bar power by tw" => "feature bot bar power by tw",
// "maxRecords" => "maxRecords",
// "maxArticles" => "maxArticles",
// "maxVersions" => "maxVersions",
// "feature view tpl" => "feature view tpl",
// "slide style" => "slide style",
// "site favicon" => "site favicon",
// "site favicon type" => "site favicon type",
// "style" => "style",
// "style option" => "style option",
// "site style" => "site style",
// "site style option" => "site style option",
// "use context menu icon" => "use context menu icon",
// "use context menu text" => "use context menu text",
// "feature site report" => "feature site report",
// "feature site send link" => "feature site send link",
// "feature layoutshadows" => "feature layoutshadows",
// "main shadow start" => "main shadow start",
// "main shadow end" => "main shadow end",
// "header shadow start" => "header shadow start",
// "header shadow end" => "header shadow end",
// "middle shadow start" => "middle shadow start",
// "middle shadow end" => "middle shadow end",
// "center shadow start" => "center shadow start",
// "center shadow end" => "center shadow end",
// "footer shadow start" => "footer shadow start",
// "footer shadow end" => "footer shadow end",
// "feature mods provider" => "feature mods provider",
// "mods dir" => "mods dir",
// "mods server" => "mods server",
// "feature experimental" => "feature experimental",
// "feature actionlog" => "feature actionlog",
// "feature actionlog bytes" => "feature actionlog bytes",
// "browsertitle" => "browsertitle",
// "tmpDir" => "tmpDir",
// "feature tell a friend" => "feature tell a friend",
// "feature copyright" => "feature copyright",
// "feature multimedia" => "feature multimedia",
// "feature swfobj" => "feature swfobj",
// "feature smileys" => "feature smileys",
// "popupLinks" => "popupLinks",
// "feature autolinks" => "feature autolinks",
// "quicktags over textarea" => "quicktags over textarea",
// "default rows textarea wiki" => "default rows textarea wiki",
// "default rows textarea comment" => "default rows textarea comment",
// "default rows textarea forum" => "default rows textarea forum",
// "default rows textarea forumthread" => "default rows textarea forumthread",
// "feature floating help" => "feature floating help",
// "direct pagination" => "direct pagination",
// "nextprev pagination" => "nextprev pagination",
// "pagination firstlast" => "pagination firstlast",
// "pagination hide if one page" => "pagination hide if one page",
// "pagination icons" => "pagination icons",
// "pagination fastmove links" => "pagination fastmove links",
// "direct pagination max middle links" => "direct pagination max middle links",
// "direct pagination max ending links" => "direct pagination max ending links",
// "anonCanEdit" => "anonCanEdit",
// "cacheimages" => "cacheimages",
// "cachepages" => "cachepages",
// "count admin pvs" => "count admin pvs",
// "default mail charset" => "default mail charset",
// "error reporting adminonly" => "error reporting adminonly",
// "error reporting level" => "error reporting level",
// "smarty notice reporting" => "smarty notice reporting",
// "smarty security" => "smarty security",
// "feature ajax" => "feature ajax",
// "feature ajax autosave" => "feature ajax autosave",
// "feature antibot" => "feature antibot",
// "feature banners" => "feature banners",
// "feature banning" => "feature banning",
// "feature comm" => "feature comm",
// "feature contribution" => "feature contribution",
// "feature contribution display in comment" => "feature contribution display in comment",
// "feature contribution mandatory" => "feature contribution mandatory",
// "feature contribution mandatory blog" => "feature contribution mandatory blog",
// "feature contribution mandatory comment" => "feature contribution mandatory comment",
// "feature contribution mandatory forum" => "feature contribution mandatory forum",
// "feature debug console" => "feature debug console",
// "feature debugger console" => "feature debugger console",
// "feature display my to others" => "feature display my to others",
// "feature drawings" => "feature drawings",
// "feature dynamic content" => "feature dynamic content",
// "feature edit templates" => "feature edit templates",
// "feature editcss" => "feature editcss",
// "feature events" => "feature events",
// "feature friends" => "feature friends",
// "feature fullscreen" => "feature fullscreen",
// "feature help" => "feature help",
// "feature hotwords" => "feature hotwords",
// "feature hotwords nw" => "feature hotwords nw",
// "feature integrator" => "feature integrator",
// "feature live support" => "feature live support",
// "feature mailin" => "feature mailin",
// "feature menusfolderstyle" => "feature menusfolderstyle",
// "feature mobile" => "feature mobile",
// "feature modulecontrols" => "feature modulecontrols",
// "feature morcego" => "feature morcego",
// "feature multilingual" => "feature multilingual",
// "feature multilingual one page" => "feature multilingual one page",
// "feature multilingual structures" => "feature multilingual structures",
// "feature newsletters" => "feature newsletters",
// "feature obzip" => "feature obzip",
// "feature phplayers" => "feature phplayers",
// "feature cssmenus" => "feature cssmenus",
// "feature projects" => "feature projects",
// "feature ranking" => "feature ranking",
// "feature redirect on error" => "feature redirect on error",
// "feature referer highlight" => "feature referer highlight",
// "feature referer stats" => "feature referer stats",
// "feature score" => "feature score",
// "feature sheet" => "feature sheet",
// "feature shoutbox" => "feature shoutbox",
// "feature source" => "feature source",
// "feature stats" => "feature stats",
// "feature tabs" => "feature tabs",
// "feature theme control" => "feature theme control",
// "feature ticketlib" => "feature ticketlib",
// "feature ticketlib2" => "feature ticketlib2",
// "feature top banner" => "feature top banner",
// "feature usability" => "feature usability",
// "feature use quoteplugin" => "feature use quoteplugin",
// "feature user watches" => "feature user watches",
// "feature group watches" => "feature group watches",
// "feature user watches translations" => "feature user watches translations",
// "feature workflow" => "feature workflow",
// "feature xmlrpc" => "feature xmlrpc",
// "helpurl" => "helpurl",
// "layout section" => "layout section",
// "limitedGoGroupHome" => "limitedGoGroupHome",
// "minical reminders" => "minical reminders",
// "modallgroups" => "modallgroups",
// "modseparateanon" => "modseparateanon",
// "php docroot" => "php docroot",
// "proxy host" => "proxy host",
// "proxy port" => "proxy port",
// "ip can be checked" => "ip can be checked",
// "sender email" => "sender email",
// "feature site report email" => "feature site report email",
// "session db" => "session db",
// "session lifetime" => "session lifetime",
// "shoutbox autolink" => "shoutbox autolink",
// "show comzone" => "show comzone",
// "system os" => "system os",
// "tikiIndex" => "tikiIndex",
// "urlIndex" => "urlIndex",
// "useGroupHome" => "useGroupHome",
// "useGroupTheme" => "useGroupTheme",
// "useUrlIndex" => "useUrlIndex",
// "use proxy" => "use proxy",
// "user list order" => "user list order",
// "webserverauth" => "webserverauth",
// "feature purifier" => "feature purifier",
// "feature shadowbox" => "feature shadowbox",
// "log sql" => "log sql",
// "log sql perf min" => "log sql perf min",
// "log mail" => "log mail",
// "log tpl" => "log tpl",
// "case patched" => "case patched",
// "site closed" => "site closed",
// "site closed msg" => "site closed msg",
// "use load threshold" => "use load threshold",
// "load threshold" => "load threshold",
// "site busy msg" => "site busy msg",
// "bot logo code" => "bot logo code",
// "feature blogposts pings" => "feature blogposts pings",
// "feature create webhelp" => "feature create webhelp",
// "feature forums search" => "feature forums search",
// "feature trackbackpings" => "feature trackbackpings",
// "feature wiki ext icon" => "feature wiki ext icon",
// "feature wiki mandatory category" => "feature wiki mandatory category",
// "feature intertiki imported groups" => "feature intertiki imported groups",
// "feature wiki history ip" => "feature wiki history ip",
// "pam create user tiki" => "pam create user tiki",
// "pam service" => "pam service",
// "pam skip admin" => "pam skip admin",
// "shib affiliation" => "shib affiliation",
// "shib create user tiki" => "shib create user tiki",
// "shib group" => "shib group",
// "shib skip admin" => "shib skip admin",
// "shib usegroup" => "shib usegroup",
// "wiki 3d camera distance" => "wiki 3d camera distance",
// "wiki 3d elastic constant" => "wiki 3d elastic constant",
// "wiki 3d eletrostatic constant" => "wiki 3d eletrostatic constant",
// "wiki 3d fov" => "wiki 3d fov",
// "wiki 3d friction constant" => "wiki 3d friction constant",
// "wiki 3d node charge" => "wiki 3d node charge",
// "wiki 3d node mass" => "wiki 3d node mass",
// "wiki 3d node size" => "wiki 3d node size",
// "wiki 3d spring size" => "wiki 3d spring size",
// "wiki 3d text size" => "wiki 3d text size",
// "articles feature copyrights" => "articles feature copyrights",
// "blogues feature copyrights" => "blogues feature copyrights",
// "faqs feature copyrights" => "faqs feature copyrights",
// "feature contributor wiki" => "feature contributor wiki",
// "https login required" => "https login required",
// "maxRowsGalleries" => "maxRowsGalleries",
// "replimaster" => "replimaster",
// "rowImagesGalleries" => "rowImagesGalleries",
// "scaleSizeGalleries" => "scaleSizeGalleries",
// "thumbSizeXGalleries" => "thumbSizeXGalleries",
// "thumbSizeYGalleries" => "thumbSizeYGalleries",
// "wiki 3d adjust camera" => "wiki 3d adjust camera",
// "wiki 3d autoload" => "wiki 3d autoload",
// "feature mootools" => "feature mootools",
// "javascript enabled" => "javascript enabled",
// "feature comments post as anonymous" => "feature comments post as anonymous",
// "feature comments moderation" => "feature comments moderation",
// "feature comments locking" => "feature comments locking",
// "feature template zoom" => "feature template zoom",
// "feature iepngfix" => "feature iepngfix",
// "iepngfix selectors" => "iepngfix selectors",
// "iepngfix elements" => "iepngfix elements",
// "use minified scripts" => "use minified scripts",
// "valid email regex" => "valid email regex",
// "feature jquery" => "feature jquery",
// "jquery effect" => "jquery effect",
// "jquery effect direction" => "jquery effect direction",
// "jquery effect speed" => "jquery effect speed",
// "jquery effect tabs" => "jquery effect tabs",
// "jquery effect tabs direction" => "jquery effect tabs direction",
// "jquery effect tabs speed" => "jquery effect tabs speed",
// "feature jquery ui" => "feature jquery ui",
// "feature jquery tooltips" => "feature jquery tooltips",
// "feature jquery autocomplete" => "feature jquery autocomplete",
// "feature jquery superfish" => "feature jquery superfish",
// "feature jquery reflection" => "feature jquery reflection",
// "feature jquery sheet" => "feature jquery sheet",
// "feature jquery tablesorter" => "feature jquery tablesorter",
// "feature jquery cycle" => "feature jquery cycle",
// "feature sefurl" => "feature sefurl",
// "feature sefurl filter" => "feature sefurl filter",
// "feature sefurl paths" => "feature sefurl paths",
// "feature sefurl title article" => "feature sefurl title article",
// "feature sefurl title blog" => "feature sefurl title blog",
// "feature tikitests" => "feature tikitests",
// "feature magic" => "feature magic",
// "profile sources" => "profile sources",
// "profile channels" => "profile channels",
// "feature minichat" => "feature minichat",
// "feature pear date" => "feature pear date",
// "feature bidi" => "feature bidi",
// "feature lastup" => "feature lastup",
// "transition style ver" => "transition style ver",
// "magic last load" => "magic last load",
// "feature groupalert" => "feature groupalert",
// "lib spellcheck" => "lib spellcheck",
// "wiki spellcheck" => "wiki spellcheck",
// "blog spellcheck" => "blog spellcheck",
// "allowMsgs" => "allowMsgs",
// "diff versions" => "diff versions",
// "display timezone" => "display timezone",
// "email is public" => "email is public",
// "homePage" => "homePage",
// "lat" => "lat",
// "lon" => "lon",
// "mess archiveAfter" => "mess archiveAfter",
// "mess maxRecords" => "mess maxRecords",
// "mess sendReadStatus" => "mess sendReadStatus",
// "minPrio" => "minPrio",
// "mytiki blogs" => "mytiki blogs",
// "mytiki articles" => "mytiki articles",
// "mytiki gals" => "mytiki gals",
// "mytiki items" => "mytiki items",
// "mytiki msgs" => "mytiki msgs",
// "mytiki pages" => "mytiki pages",
// "mytiki tasks" => "mytiki tasks",
// "mytiki workflow" => "mytiki workflow",
// "mytiki forum topics" => "mytiki forum topics",
// "mytiki forum replies" => "mytiki forum replies",
// "realName" => "realName",
// "gender" => "gender",
// "show mouseover user info" => "show mouseover user info",
// "tasks maxRecords" => "tasks maxRecords",
// "user dbl" => "user dbl",
// "user information" => "user information",
// "mailCharset" => "mailCharset",
// "Anti-Bot verification code" => "Anti-Bot verification code",
// "Enter the code you see above" => "Enter the code you see above",
// "more info" => "more info",
// "Group Monitor" => "Group Monitor",
// "Watched by categories" => "Watched by categories",
// "Select Categories" => "Select Categories",
// "Select/deselect all categories" => "Select/deselect all categories",
// "Browse Category" => "Browse Category",
// "top of page" => "top of page",
// "Reply" => "Reply",
// "Report this post" => "Report this post",
// "Errors" => "Errors",
// "Comments Locked" => "Comments Locked",
// "Plain" => "Plain",
// "Threaded" => "Threaded",
// "Headers Only" => "Headers Only",
// "below your current threshold" => "below your current threshold",
// "Comments are locked" => "Comments are locked",
// "Note" => "Note",
// "Editing reply" => "Editing reply",
// "Reply to the selected post" => "Reply to the selected post",
// "Post new message" => "Post new message",
// "Comment on the selected post" => "Comment on the selected post",
// "required" => "required",
// "Quicktags" => "Quicktags",
// "Maximum size" => "Maximum size",
// "Enter your name" => "Enter your name",
// "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address" => "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address",
// "Reply to parent post" => "Reply to parent post",
// "Post new reply" => "Post new reply",
// "Please note that the preview does not keep the attached file which you will have to choose before posting" => "Please note that the preview does not keep the attached file which you will have to choose before posting",
// "Post as Anonymous" => "Post as Anonymous",
// "Your comment will have to be approved by the moderator before it is displayed" => "Your comment will have to be approved by the moderator before it is displayed",
// "Posting replies" => "Posting replies",
// "HTML tags are not allowed inside posts" => "HTML tags are not allowed inside posts",
// "Type of contribution" => "Type of contribution",
// "Contributors" => "Contributors",
// "Duplicate File Gallery" => "Duplicate File Gallery",
// "Duplicate categories" => "Duplicate categories",
// "Duplicate perms" => "Duplicate perms",
// "View inserted gallery" => "View inserted gallery",
// "Display Properties" => "Display Properties",
// "required field for podcasts" => "required field for podcasts",
// "any file" => "any file",
// "podcast (audio)" => "podcast (audio)",
// "podcast (video)" => "podcast (video)",
// "This Gallery is Public" => "This Gallery is Public",
// "Users with perms and not only the owner of the gallery can upload in it" => "Users with perms and not only the owner of the gallery can upload in it",
// "The files can be locked at download" => "The files can be locked at download",
// "Maximum number of archives for each file" => "Maximum number of archives for each file",
// "unlimited" => "unlimited",
// "Parent gallery" => "Parent gallery",
// "Owner of the gallery" => "Owner of the gallery",
// "Group of users alerted when file gallery is modified" => "Group of users alerted when file gallery is modified",
// "Allows to select each user for small groups" => "Allows to select each user for small groups",
// "Default sort order" => "Default sort order",
// "descending" => "descending",
// "ascending" => "ascending",
// "Please login" => "Please login",
// "Perhaps you were looking for" => "Perhaps you were looking for",
// "There are no wiki pages similar to '{\$page}'" => "There are no wiki pages similar to '{\$page}'",
// "Go to Login Page" => "Go to Login Page",
// "(page will be orphaned)" => "(page will be orphaned)",
// "Close Window" => "Close Window",
// "Go to" => "Go to",
// "Private Gallery" => "Private Gallery",
// "Active Perms" => "Active Perms",
// "Archives" => "Archives",
// "Upload New Version" => "Upload New Version",
// "Download and lock" => "Download and lock",
// "Show as a column" => "Show as a column",
// "Show in popup box" => "Show in popup box",
// "Both" => "Both",
// "Show an icon in a column" => "Show an icon in a column",
// "Exact&nbsp;match" => "Exact&nbsp;match",
// "any type" => "any type",
// "all topic" => "all topic",
// "any language" => "any language",
// "not in" => "not in",
// "any category" => "any category",
// "Go" => "Go",
// "Clear Filter" => "Clear Filter",
// "Show php error messages" => "Show php error messages",
// "Folksonomy Tags" => "Folksonomy Tags",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together" => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together",
// "Tags" => "Tags",
// "Translate tags" => "Translate tags",
// "Images Galleries" => "Images Galleries",
// "RSS Wiki" => "RSS Wiki",
// "RSS Blogs" => "RSS Blogs",
// "RSS Articles" => "RSS Articles",
// "RSS Image Galleries" => "RSS Image Galleries",
// "RSS File Galleries" => "RSS File Galleries",
// "RSS Forums" => "RSS Forums",
// "RSS Maps" => "RSS Maps",
// "RSS Directories" => "RSS Directories",
// "RSS Calendars" => "RSS Calendars",
// "You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page" => "You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page",
// "Loading" => "Loading",
// "\\074span class=\"shortcut\"\\076C\\074/span\\076lose" => "\\074span class=\"shortcut\"\\076C\\074/span\\076lose",
// "\\074span class=\"shortcut\"\\076N\\074/span\\076ext" => "\\074span class=\"shortcut\"\\076N\\074/span\\076ext",
// "\\074span class=\"shortcut\"\\076P\\074/span\\076revious" => "\\074span class=\"shortcut\"\\076P\\074/span\\076revious",
// "Show Tree" => "Show Tree",
// "Hide Tree" => "Hide Tree",
// "Perform action with checked" => "Perform action with checked",
// "Are you sure you want to delete the selected files" => "Are you sure you want to delete the selected files",
// "Download the zip" => "Download the zip",
// "Assign Permissions" => "Assign Permissions",
// "Other Sorts" => "Other Sorts",
// "No Additionnal Sort" => "No Additionnal Sort",
// "No information" => "No information",
// "To validate your account and login to the site, please click on the following link" => "To validate your account and login to the site, please click on the following link",
// "The administrator approved your account" => "The administrator approved your account",
// "Confirm your email at %s" => "Confirm your email at %s",
// "New topic" => "New topic",
// "Contribution" => "Contribution",
// "You sent a request with the subject" => "You sent a request with the subject",
// "Use the subject to indicate the operation to apply" => "Use the subject to indicate the operation to apply",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "Page not found" => "Page not found",
// "New message arrived from %s" => "New message arrived from %s",
// "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now" => "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now",
// "To login with your username and password, please follow this link" => "To login with your username and password, please follow this link",
// "User Account Activated" => "User Account Activated",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "has requested an account on" => "has requested an account on",
// "To validate that account, please follow the link" => "To validate that account, please follow the link",
// "best regards" => "best regards",
// "your Tikiwiki" => "your Tikiwiki",
// "User Tracker" => "User Tracker",
// "User Registration Request" => "User Registration Request",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "You're invited to join my network of friends" => "You're invited to join my network of friends",
// "Bye bye from %s at %s" => "Bye bye from %s at %s",
// "Welcome to %s at %s" => "Welcome to %s at %s",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else" => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above" => "Important: The old password remains active if you don't click the link above",
// "Your account information for %s" => "Your account information for %s",
// "New article submitted at %s" => "New article submitted at %s",
// "Look at this link" => "Look at this link",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}" => "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}",
// "Download the file at" => "Download the file at",
// "Tracker was modified at" => "Tracker was modified at",
// "Please visit this link before login again" => "Please visit this link before login again",
// "Last attempt" => "Last attempt",
// "IP" => "IP",
// "Confirm your account at %s" => "Confirm your account at %s",
// "An administrator of the site below has added you as a new user" => "An administrator of the site below has added you as a new user",
// "If you want to confirm your membership in this site, click on the following link to login for the first time" => "If you want to confirm your membership in this site, click on the following link to login for the first time",
// "Your authentication credentials are" => "Your authentication credentials are",
// "Welcome on the site" => "Welcome on the site",
// "Your personal access to" => "Your personal access to",
// "Your account request has been stored and will be activated by the admin as soon as possible" => "Your account request has been stored and will be activated by the admin as soon as possible",
// "You'll receive email notification once your account is activated" => "You'll receive email notification once your account is activated",
// "Please do not attempt to login until you receive the email notification" => "Please do not attempt to login until you receive the email notification",
// "{\$mail_action} article post" => "{\$mail_action} article post",
// "{\$mail_title} by {\$mail_user} at" => "{\$mail_title} by {\$mail_user} at",
// "New article post" => "New article post",
// "Edited article post" => "Edited article post",
// "Deleted article post" => "Deleted article post",
// "View the article at" => "View the article at",
// "{\$mail_action} article post at" => "{\$mail_action} article post at",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}",
// "New blog post at %s" => "New blog post at %s",
// "View item calendar at" => "View item calendar at",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "A new category was created in" => "A new category was created in",
// "A category was removed in" => "A category was removed in",
// "Removed by" => "Removed by",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Updated by" => "Updated by",
// "Old" => "Old",
// "New" => "New",
// "updated" => "updated",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "File Name" => "File Name",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "Posted by" => "Posted by",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "An object was added to category" => "An object was added to category",
// "Added by" => "Added by",
// "Object type" => "Object type",
// "An object was removed from category" => "An object was removed from category",
// "A page has been added to your watched sub-structure" => "A page has been added to your watched sub-structure",
// "A page has been removed from your watched sub-structure" => "A page has been removed from your watched sub-structure",
// "A page has been promoted out your watched sub-structure" => "A page has been promoted out your watched sub-structure",
// "A page has been demoted to your watched structure" => "A page has been demoted to your watched structure",
// "Structure modified" => "Structure modified",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted but used to be here" => "The page {\$mail_page} was deleted but used to be here",
// "You can view the page by following this link" => "You can view the page by following this link",
// "You can view a diff back to the previous version by following this link" => "You can view a diff back to the previous version by following this link",
// "The changes in this version follow below, followed after by the current full page text" => "The changes in this version follow below, followed after by the current full page text",
// "-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lines: {\$oldd} changed to +Lines: {\$newd}",
// "The old page content follows below" => "The old page content follows below",
// "Wiki page %s created by {\$mail_user}" => "Wiki page %s created by {\$mail_user}",
// "Wiki page %s deleted by {\$mail_user}" => "Wiki page %s deleted by {\$mail_user}",
// "Wiki page %s changed by {\$mail_user}" => "Wiki page %s changed by {\$mail_user}",
// "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "Wiki page %s was commented on by" => "Wiki page %s was commented on by",
// "an anonymous user" => "an anonymous user",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "Thank you for your registration. You may log in now" => "Thank you for your registration. You may log in now",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Zoom out" => "Zoom out",
// "Pan" => "Pan",
// "Zoom in" => "Zoom in",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Layer" => "Layer",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "from the mapfile" => "from the mapfile",
// "hits last 7 days" => "hits last 7 days",
// "Reload" => "Reload",
// "Zoom out x2" => "Zoom out x2",
// "Zoom in x2" => "Zoom in x2",
// "Mapfile History" => "Mapfile History",
// "Comparing version {\$old.version} with version {\$new.version}" => "Comparing version {\$old.version} with version {\$new.version}",
// "v=view" => "v=view",
// "c=compare" => "c=compare",
// "d=diff" => "d=diff",
// "Full side-by-side diff" => "Full side-by-side diff",
// "Unified diff" => "Unified diff",
// "Side-by-side view" => "Side-by-side view",
// "Older Version" => "Older Version",
// "back to" => "back to",
// "Message Archive" => "Message Archive",
// "messages" => "messages",
// "Archive is full" => "Archive is full",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences" => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences",
// "ERROR" => "ERROR",
// "No messages to download" => "No messages to download",
// "Mailbox is full! Delete or archive some messages if you want to receive more messages" => "Mailbox is full! Delete or archive some messages if you want to receive more messages",
// "is reply to" => "is reply to",
// "Find replied message" => "Find replied message",
// "Archive" => "Archive",
// "Auto-archive age for read messages" => "Auto-archive age for read messages",
// "Return to mailbox" => "Return to mailbox",
// "Unflag" => "Unflag",
// "Return to archive" => "Return to archive",
// "Return to outbox" => "Return to outbox",
// "Sent Messages" => "Sent Messages",
// "Replied" => "Replied",
// "Not replied" => "Not replied",
// "move to archive" => "move to archive",
// "receiver" => "receiver",
// "opp side" => "opp side",
// "Unassign this module" => "Unassign this module",
// "Are you sure you want to unassign this module" => "Are you sure you want to unassign this module",
// "Toggle module contents" => "Toggle module contents",
// "toggle" => "toggle",
// "\$tpl_module_title" => "\$tpl_module_title",
// "Admin Drawings" => "Admin Drawings",
// "Shoutbox Words" => "Shoutbox Words",
// "External Wikis" => "External Wikis",
// "Tiki Cache/Sys Admin" => "Tiki Cache/Sys Admin",
// "Security Admin" => "Security Admin",
// "Syntax Highlighting" => "Syntax Highlighting",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number " => "You forgot your Google ad_client number ",
// "\$module_title" => "\$module_title",
// "More.." => "More..",
// "Tikiwiki Assistant" => "Tikiwiki Assistant",
// "Thank you for installing Tikiwiki" => "Thank you for installing Tikiwiki",
// "To configure your Tiki" => "To configure your Tiki",
// "Admin Home" => "Admin Home",
// "from the menu" => "from the menu",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "as the Admin" => "as the Admin",
// "The Tikiwiki Community" => "The Tikiwiki Community",
// "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "Last `\$module_rows` blog comments" => "Last `\$module_rows` blog comments",
// "Last blog comments" => "Last blog comments",
// "on blogpost" => "on blogpost",
// "January" => "January",
// "February" => "February",
// "March" => "March",
// "April" => "April",
// "May" => "May",
// "June" => "June",
// "July" => "July",
// "August" => "August",
// "September" => "September",
// "October" => "October",
// "November" => "November",
// "December" => "December",
// "Add event" => "Add event",
// "\$modcattitle" => "\$modcattitle",
// "Current events" => "Current events",
// "Top `\$module_rows` topics" => "Top `\$module_rows` topics",
// "Last `\$module_rows` forum posts" => "Last `\$module_rows` forum posts",
// "Last forum posts" => "Last forum posts",
// "Folksonomy" => "Folksonomy",
// "Tags This Page Has" => "Tags This Page Has",
// "Add tags" => "Add tags",
// "More Like This" => "More Like This",
// "Most popular tags" => "Most popular tags",
// "List everything tagged" => "List everything tagged",
// "My prefered tags" => "My prefered tags",
// "Last `\$module_rows` actions" => "Last `\$module_rows` actions",
// "Last actions" => "Last actions",
// "\$type" => "\$type",
// "Last `\$module_rows` Images" => "Last `\$module_rows` Images",
// "Last Images" => "Last Images",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "Last `\$module_rows` modified events" => "Last `\$module_rows` modified events",
// "Last modifed events" => "Last modifed events",
// "more" => "more",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "Last `\$module_rows` visitors" => "Last `\$module_rows` visitors",
// "Last Visitors" => "Last Visitors",
// "No avatar" => "No avatar",
// "You" => "You",
// "Logged in as" => "Logged in as",
// "Switch User" => "Switch User",
// "Switch user" => "Switch user",
// "Login through CAS" => "Login through CAS",
// "Login as admin" => "Login as admin",
// "Login through Shibboleth" => "Login through Shibboleth",
// "Login as" => "Login as",
// "CapsLock is on" => "CapsLock is on",
// "year" => "year",
// "Click here to register" => "Click here to register",
// "Click here if you've forgotten your password" => "Click here if you've forgotten your password",
// "Click here to login using the default security protocol" => "Click here to login using the default security protocol",
// "Click here to login using a secure protocol" => "Click here to login using a secure protocol",
// "local account" => "local account",
// "OpenID Login" => "OpenID Login",
// "What is OpenID" => "What is OpenID",
// "Send a message" => "Send a message",
// "Random Images" => "Random Images",
// "RSS Feeds" => "RSS Feeds",
// "Wiki RSS" => "Wiki RSS",
// "Blogs RSS" => "Blogs RSS",
// "Articles RSS" => "Articles RSS",
// "Image Galleries RSS" => "Image Galleries RSS",
// "File Galleries RSS" => "File Galleries RSS",
// "Forums RSS" => "Forums RSS",
// "Maps RSS" => "Maps RSS",
// "Calendars" => "Calendars",
// "A leading plus sign indicates that this word must be present in every object returned" => "A leading plus sign indicates that this word must be present in every object returned",
// "A leading minus sign indicates that this word must not be present in any row returned" => "A leading minus sign indicates that this word must not be present in any row returned",
// "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher" => "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher",
// "These two operators are used to change a word's contribution to the relevance value that is assigned to a row" => "These two operators are used to change a word's contribution to the relevance value that is assigned to a row",
// "Parentheses are used to group words into subexpressions" => "Parentheses are used to group words into subexpressions",
// "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator" => "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator",
// "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended" => "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended",
// "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed" => "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed",
// "Advanced search" => "Advanced search",
// "Advanced Search Help" => "Advanced Search Help",
// "Page Relations" => "Page Relations",
// "Are you sure you want to delete this shout" => "Are you sure you want to delete this shout",
// "Delete this shout" => "Delete this shout",
// "Edit this shout" => "Edit this shout",
// "New Tracker Items" => "New Tracker Items",
// "New Calendar Events" => "New Calendar Events",
// "Nothing has changed" => "Nothing has changed",
// "`\$module_params.prefix`" => "`\$module_params.prefix`",
// "Site Language" => "Site Language",
// "Site default" => "Site default",
// "TikiTests Menu" => "TikiTests Menu",
// "List Tests" => "List Tests",
// "Create Test" => "Create Test",
// "Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Forum Posters",
// "Top Forum Posters" => "Top Forum Posters",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Page translation" => "Page translation",
// "There are no translations of this page" => "There are no translations of this page",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "None match your" => "None match your",
// "Set your preferred languages" => "Set your preferred languages",
// "preferred languages" => "preferred languages",
// "Equivalent translations" => "Equivalent translations",
// "Translations that need improvement" => "Translations that need improvement",
// "update it" => "update it",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "The Next Event" => "The Next Event",
// "No Upcoming Events" => "No Upcoming Events",
// "click to view" => "click to view",
// "Public tasks" => "Public tasks",
// "select" => "select",
// "User informations" => "User informations",
// "Group informations" => "Group informations",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Top users" => "Top users",
// "on host" => "on host",
// "on page" => "on page",
// "Videos on YouTube" => "Videos on YouTube",
// "More Videos" => "More Videos",
// "Changes that need to be reproduced are highlighted below" => "Changes that need to be reproduced are highlighted below",
// "[-]" => "[-]",
// "Send Newsletter" => "Send Newsletter",
// "Insert/Edit an internal wiki link" => "Insert/Edit an internal wiki link",
// "Wiki Link insert" => "Wiki Link insert",
// "Please make a selection of text in order to create a link" => "Please make a selection of text in order to create a link",
// "Insert an image" => "Insert an image",
// "Tiki Image - Insert an image" => "Tiki Image - Insert an image",
// "Manage structures" => "Manage structures",
// "By" => "By",
// "Location : " => "Location : ",
// "Read more" => "Read more",
// "Do not group by item" => "Do not group by item",
// "Group by item" => "Group by item",
// "Calendar View" => "Calendar View",
// "List View" => "List View",
// "Tiki Action Calendar" => "Tiki Action Calendar",
// "Tip" => "Tip",
// "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones" => "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones",
// "Site Ads and Banners" => "Site Ads and Banners",
// "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users" => "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users",
// "Profiles" => "Profiles",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Look &amp; Feel" => "Look &amp; Feel",
// "i18n" => "i18n",
// "Editing and Plugins" => "Editing and Plugins",
// "Text area" => "Text area",
// "Meta Tags" => "Meta Tags",
// "Community" => "Community",
// "Freetags" => "Freetags",
// "Multimedia" => "Multimedia",
// "Wysiwyg editor" => "Wysiwyg editor",
// "Intertiki" => "Intertiki",
// "InterTiki" => "InterTiki",
// "Semantic wiki links" => "Semantic wiki links",
// "Semantic links" => "Semantic links",
// "Webservices" => "Webservices",
// "Sef URL" => "Sef URL",
// "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or",
// "Blogs Listing" => "Blogs Listing",
// "Create a blog" => "Create a blog",
// "Not Installed" => "Not Installed",
// "Spell checking" => "Spell checking",
// "Requires a separate download" => "Requires a separate download",
// "Custom blog headings" => "Custom blog headings",
// "Blog-level" => "Blog-level",
// "Post-level" => "Post-level",
// "Default number per page" => "Default number per page",
// "Default ordering" => "Default ordering",
// "Blogs Listings" => "Blogs Listings",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Select which items to display when listing blogs" => "Select which items to display when listing blogs",
// "Title length" => "Title length",
// "Creation date" => "Creation date",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "Change settings" => "Change settings",
// "General settings" => "General settings",
// "Default calendars to display" => "Default calendars to display",
// "All calendars" => "All calendars",
// "A subset of available calendars" => "A subset of available calendars",
// "Create calendar" => "Create calendar",
// "Default view mode" => "Default view mode",
// "View list begins" => "View list begins",
// "Focus Date" => "Focus Date",
// "Period beginning" => "Period beginning",
// "First day of the week" => "First day of the week",
// "Split hours in periods of" => "Split hours in periods of",
// "1 minute" => "1 minute",
// "10 minutes" => "10 minutes",
// "Manual selection of time/date" => "Manual selection of time/date",
// "JS calendar" => "JS calendar",
// "Year selection is valid when the JS Calendar <strong>is not</strong> enabled" => "Year selection is valid when the JS Calendar <strong>is not</strong> enabled",
// "First year in the dropdown" => "First year in the dropdown",
// "Enter a year or use +/- N to specify a year relative to the current\n\tyear" => "Enter a year or use +/- N to specify a year relative to the current\n\tyear",
// "Last year in the dropdown" => "Last year in the dropdown",
// "Group calendars" => "Group calendars",
// "Sticky popup" => "Sticky popup",
// "Item view tab" => "Item view tab",
// "Browse categories" => "Browse categories",
// "Administer categories" => "Administer categories",
// "Category path" => "Category path",
// "Exclude these categories" => "Exclude these categories",
// "Separate category IDs with a comma (,)" => "Separate category IDs with a comma (,)",
// "Show category objects" => "Show category objects",
// "Use PHPLayers for category browser" => "Use PHPLayers for category browser",
// "PHPLayers is disabled" => "PHPLayers is disabled",
// "Enable now" => "Enable now",
// "Categories used in templates (TPL)" => "Categories used in templates (TPL)",
// "Ignore category viewing restrictions" => "Ignore category viewing restrictions",
// "Will improve performance, but may show forbidden results" => "Will improve performance, but may show forbidden results",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Look under \"Articles\" on the application menu for links to" => "Look under \"Articles\" on the application menu for links to",
// "Admin topics" => "Admin topics",
// "Admin types" => "Admin types",
// "Articles Listing" => "Articles Listing",
// "Title of articles home page" => "Title of articles home page",
// "Maximum number of articles on articles home page" => "Maximum number of articles on articles home page",
// "Article properties" => "Article properties",
// "Give only one value (width or height) to keep the image proportions" => "Give only one value (width or height) to keep the image proportions",
// "Specify notification emails when creating articles" => "Specify notification emails when creating articles",
// "Default article image width" => "Default article image width",
// "Default article image height" => "Default article image height",
// "File format: title,authorName,heading,body,lang,user" => "File format: title,authorName,heading,body,lang,user",
// "Select which items to display when listing articles" => "Select which items to display when listing articles",
// "Publication date" => "Publication date",
// "Expiration date" => "Expiration date",
// "Users Listing" => "Users Listing",
// "Users can choose to show their gender" => "Users can choose to show their gender",
// "Requires User Preferences feature" => "Requires User Preferences feature",
// "Show user's information on mouseover" => "Show user's information on mouseover",
// "Requires user's information to be public" => "Requires user's information to be public",
// "Real name" => "Real name",
// "Number of friends" => "Number of friends",
// "Feature is disabled" => "Feature is disabled",
// "E-mail" => "E-mail",
// "Distance" => "Distance",
// "Default user preferences" => "Default user preferences",
// "Users Default Preferences" => "Users Default Preferences",
// "Character set for mail" => "Character set for mail",
// "default" => "default",
// "Detect user timezone if browser allows, otherwise site default" => "Detect user timezone if browser allows, otherwise site default",
// "Use double-click to edit pages" => "Use double-click to edit pages",
// "Show user's info on mouseover" => "Show user's info on mouseover",
// "User messages" => "User messages",
// "Notify sender when reading mail" => "Notify sender when reading mail",
// "Auto-archive read messages after x days" => "Auto-archive read messages after x days",
// "never" => "never",
// "My forum topics" => "My forum topics",
// "My forum replies" => "My forum replies",
// "My workflow" => "My workflow",
// "Select which items to display when listing users" => "Select which items to display when listing users",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "License page" => "License page",
// "Submit notice" => "Submit notice",
// "Enable copyright management for" => "Enable copyright management for",
// "Feature" => "Feature",
// "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or",
// "enable cool sites" => "enable cool sites",
// "Show Country Flag" => "Show Country Flag",
// "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site",
// "No tabs" => "No tabs",
// "Apply" => "Apply",
// "Reset" => "Reset",
// "Main" => "Main",
// "Global Features" => "Global Features",
// "More Functionality" => "More Functionality",
// "UI Enhancements" => "UI Enhancements",
// "Experimental" => "Experimental",
// "Programmer" => "Programmer",
// "Main Features" => "Main Features",
// "Site Global Features" => "Site Global Features",
// "Action Log" => "Action Log",
// "Action log setting" => "Action log setting",
// "Internationalization" => "Internationalization",
// "Multilingual" => "Multilingual",
// "Additional Features" => "Additional Features",
// "Copyright System" => "Copyright System",
// "Copyright system" => "Copyright system",
// "Tell a Friend" => "Tell a Friend",
// "HTML pages" => "HTML pages",
// "Minichat" => "Minichat",
// "Comments Moderation" => "Comments Moderation",
// "Comments Locking" => "Comments Locking",
// "User interface enhancement features" => "User interface enhancement features",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "PHPLayers" => "PHPLayers",
// "Fullscreen" => "Fullscreen",
// "Allow users to activate fullscreen mode" => "Allow users to activate fullscreen mode",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
// "Mootools or JQuery" => "Mootools or JQuery",
// "Mootools" => "Mootools",
// "Floating help aka the Big Blue Help Icon" => "Floating help aka the Big Blue Help Icon",
// "Experimental Features" => "Experimental Features",
// "Seem ok" => "Seem ok",
// "Features that may change or might be re-worked in the future" => "Features that may change or might be re-worked in the future",
// "Ajax" => "Ajax",
// "HTML Purifier" => "HTML Purifier",
// "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)" => "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)",
// "JQuery: JavaScript UI effects" => "JQuery: JavaScript UI effects",
// "Mobile" => "Mobile",
// "Morcego 3D browser" => "Morcego 3D browser",
// "Need polish" => "Need polish",
// "Features that need admin help and user patience to work well" => "Features that need admin help and user patience to work well",
// "Mindmap" => "Mindmap",
// "Print Indexed" => "Print Indexed",
// "SEFURL" => "SEFURL",
// "Search engine friendly url" => "Search engine friendly url",
// "Spreadsheet" => "Spreadsheet",
// "Tiki Sheet" => "Tiki Sheet",
// "Ajax auto-save" => "Ajax auto-save",
// "Malfunctioning" => "Malfunctioning",
// "These features have critical faults - not recommended" => "These features have critical faults - not recommended",
// "Magic Admin Panel" => "Magic Admin Panel",
// "Neglected" => "Neglected",
// "Old features no longer maintained" => "Old features no longer maintained",
// "Friendship" => "Friendship",
// "Friendship Network" => "Friendship Network",
// "SWFObject" => "SWFObject",
// "SwfObject" => "SwfObject",
// "Used to embed Flash content in wiki pages, banners etc" => "Used to embed Flash content in wiki pages, banners etc",
// "Action Calendar" => "Action Calendar",
// "Tiki action calendar" => "Tiki action calendar",
// "Redirect On Error" => "Redirect On Error",
// "Display 'MyTiki' in the application menu" => "Display 'MyTiki' in the application menu",
// "User Contacts" => "User Contacts",
// "Group Watches" => "Group Watches",
// "User Watches Translations" => "User Watches Translations",
// "User Levels" => "User Levels",
// "Group Alert" => "Group Alert",
// "Programmer Features" => "Programmer Features",
// "TikiTests" => "TikiTests",
// "requires PHP5 or more" => "requires PHP5 or more",
// "Use Minified Scripts" => "Use Minified Scripts",
// "To create or remove file galleries, select" => "To create or remove file galleries, select",
// "from the application menu" => "from the application menu",
// "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory" => "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
// "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/",
// "Gallery Listing" => "Gallery Listing",
// "Search Indexing" => "Search Indexing",
// "Create a Gallery" => "Create a Gallery",
// "Store in database" => "Store in database",
// "Store in directory" => "Store in directory",
// "The server must be able to read/write the directory" => "The server must be able to read/write the directory",
// "The directory can be outside the web space" => "The directory can be outside the web space",
// "Podcast directory" => "Podcast directory",
// "Required for podcasts" => "Required for podcasts",
// "Default Ordering" => "Default Ordering",
// "Allow download limit per file" => "Allow download limit per file",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "Score is disabled" => "Score is disabled",
// "Allow same file to be uploaded more than once" => "Allow same file to be uploaded more than once",
// "Yes, even in the same gallery" => "Yes, even in the same gallery",
// "Only in different galleries" => "Only in different galleries",
// "Batch uploading" => "Batch uploading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "The server must be able to read the directory" => "The server must be able to read the directory",
// "Require file author's name for anonymous uploads" => "Require file author's name for anonymous uploads",
// "Upload Regex" => "Upload Regex",
// "Must match" => "Must match",
// "Cannot match" => "Cannot match",
// "Gallery Listings" => "Gallery Listings",
// "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries" => "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries",
// "Select which items to display when listing galleries: " => "Select which items to display when listing galleries: ",
// "Automatically index files on upload or change" => "Automatically index files on upload or change",
// "Handlers" => "Handlers",
// "Add custom handlers to make your files &quot;searchable&quot; content" => "Add custom handlers to make your files &quot;searchable&quot; content",
// "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command" => "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command",
// "To delete a handler, leave the <strong>System Command</strong> field blank" => "To delete a handler, leave the <strong>System Command</strong> field blank",
// "MIME Type" => "MIME Type",
// "System Command" => "System Command",
// "Reindex all files for search" => "Reindex all files for search",
// "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or",
// "Forums Listing" => "Forums Listing",
// "Create a forum" => "Create a forum",
// "Topic archiving" => "Topic archiving",
// "Quick jumps" => "Quick jumps",
// "Replies are empty" => "Replies are empty",
// "If disabled, replies will quote the original post" => "If disabled, replies will quote the original post",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "First post of a thread can have an empty body" => "First post of a thread can have an empty body",
// "Will be a thread title" => "Will be a thread title",
// "Threads" => "Threads",
// "Manage thread defaults per-forum" => "Manage thread defaults per-forum",
// "Display thread configuration bar" => "Display thread configuration bar",
// "Allows users to override the defaults" => "Allows users to override the defaults",
// "Keep settings for all forums during the user session" => "Keep settings for all forums during the user session",
// "Default style" => "Default style",
// "Default sort mode" => "Default sort mode",
// "Forum name search" => "Forum name search",
// "When listing forums" => "When listing forums",
// "Forum content search" => "Forum content search",
// "Topic content search" => "Topic content search",
// "Search is disabled" => "Search is disabled",
// "Use Tiki (database-independent) search" => "Use Tiki (database-independent) search",
// "Use database (full-text) search" => "Use database (full-text) search",
// "Select which items to display when listing forums" => "Select which items to display when listing forums",
// "Description length" => "Description length",
// "3D Tag Browser" => "3D Tag Browser",
// "Show tag cloud" => "Show tag cloud",
// "Maximum number of tags in cloud" => "Maximum number of tags in cloud",
// "Show freetags in middle column" => "Show freetags in middle column",
// "Preload freetag random tag" => "Preload freetag random tag",
// "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>" => "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>",
// "Random tag cloud colors" => "Random tag cloud colors",
// "Separate colors with a comma (,)" => "Separate colors with a comma (,)",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Alphanumeric ASCII characters only" => "Alphanumeric ASCII characters only",
// "No accents or special characters" => "No accents or special characters",
// "Accept all charactrs" => "Accept all charactrs",
// "Lowercase tags only" => "Lowercase tags only",
// "Multilingual freetags" => "Multilingual freetags",
// "Multiligual disabled" => "Multiligual disabled",
// "&quot;More Like This&quot; algorithm" => "&quot;More Like This&quot; algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Minimum amount of tags in common" => "Minimum amount of tags in common",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "Morcego 3D browser disabled" => "Morcego 3D browser disabled",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Browser width" => "Browser width",
// "Browser height" => "Browser height",
// "Graph appearance" => "Graph appearance",
// "Navigation depth" => "Navigation depth",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Spring (connection) size" => "Spring (connection) size",
// "Node color" => "Node color",
// "Camera settinsg" => "Camera settinsg",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Camera distance" => "Camera distance",
// "Field of view" => "Field of view",
// "Feed animation interval (milisecs)" => "Feed animation interval (milisecs)",
// "Physics engine" => "Physics engine",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or",
// "You can upload images of a size of " => "You can upload images of a size of ",
// "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value",
// "Home Gallery" => "Home Gallery",
// "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below" => "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below",
// "Directory Batch Loading" => "Directory Batch Loading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols",
// "Enable directory batch loading" => "Enable directory batch loading",
// "Batch loading directory" => "Batch loading directory",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Pixels Default" => "Pixels Default",
// "Default scale size" => "Default scale size",
// "pixels" => "pixels",
// "Exterminator" => "Exterminator",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Change configuration" => "Change configuration",
// "Admin Password" => "Admin Password",
// "Release Check" => "Release Check",
// "Reset or upgrade your database" => "Reset or upgrade your database",
// "Check for updates automatically" => "Check for updates automatically",
// "Check frequency" => "Check frequency",
// "TikiWiki will check for updates when you access the main Administration page" => "TikiWiki will check for updates when you access the main Administration page",
// "Check for updates now" => "Check for updates now",
// "Site Identity" => "Site Identity",
// "Sender email" => "Sender email",
// "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look &amp; Feel</strong></a> section for additional site related customization preferences" => "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look &amp; Feel</strong></a> section for additional site related customization preferences",
// "Go to group homepage only if login from default homepage" => "Go to group homepage only if login from default homepage",
// "Use TikiWiki feature as homepage" => "Use TikiWiki feature as homepage",
// "Use different URL as home page" => "Use different URL as home page",
// "Miscellaneous" => "Miscellaneous",
// "Server OS" => "Server OS",
// "Smarty Security" => "Smarty Security",
// "Do not allow php code in smarty templates" => "Do not allow php code in smarty templates",
// "Use PEAR::Date library" => "Use PEAR::Date library",
// "Default charset for sending mail" => "Default charset for sending mail",
// "Mail end of line" => "Mail end of line",
// "(standard)" => "(standard)",
// "(some Unix MTA)" => "(some Unix MTA)",
// "Logging and Reporting" => "Logging and Reporting",
// "PHP error reporting level" => "PHP error reporting level",
// "Report all PHP errors except strict" => "Report all PHP errors except strict",
// "Visible to Admin only" => "Visible to Admin only",
// "Include Smarty notices" => "Include Smarty notices",
// "Log mail in Tiki logs" => "Log mail in Tiki logs",
// "Log SQL" => "Log SQL",
// "Log queries using more than" => "Log queries using more than",
// "This may impact performance" => "This may impact performance",
// "Add HTML comment at start and end of each Smarty template (TPL)" => "Add HTML comment at start and end of each Smarty template (TPL)",
// "CSRF Security" => "CSRF Security",
// "Use these options to protect against cross-site request forgeries (CSRF)" => "Use these options to protect against cross-site request forgeries (CSRF)",
// "Require confirmation if possible CSRF detected" => "Require confirmation if possible CSRF detected",
// "Protect against CSRF with a ticket" => "Protect against CSRF with a ticket",
// "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings" => "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings",
// "Site Access" => "Site Access",
// "Close site (except for those with permission)" => "Close site (except for those with permission)",
// "Message to display" => "Message to display",
// "Close site when server load is above the threshold  (except for those with permission)" => "Close site when server load is above the threshold  (except for those with permission)",
// "Maximum average server load threshold in the last minute" => "Maximum average server load threshold in the last minute",
// "Host" => "Host",
// "On permission denied, display login module (for Anonymous)" => "On permission denied, display login module (for Anonymous)",
// "Send to URL" => "Send to URL",
// "Performance" => "Performance",
// "Cache external pages" => "Cache external pages",
// "Cache external images" => "Cache external images",
// "GZip output" => "GZip output",
// "Output compression is active" => "Output compression is active",
// "Compression is handled by" => "Compression is handled by",
// "Session" => "Session",
// "Advanced configuration warning" => "Advanced configuration warning",
// "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects" => "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects",
// "Enabling this feature will immediately log you out when you save this preference" => "Enabling this feature will immediately log you out when you save this preference",
// "Session lifetime" => "Session lifetime",
// "The \"Contact Us\" feature is disabled" => "The \"Contact Us\" feature is disabled",
// "Allow anonymous visitors to use the \"Contact Us\"" => "Allow anonymous visitors to use the \"Contact Us\"",
// "Help URL" => "Help URL",
// "The default help system may not be complete" => "The default help system may not be complete",
// "You can help with the TikiWiki documentation" => "You can help with the TikiWiki documentation",
// "Show user's real name instead of login (when possible)" => "Show user's real name instead of login (when possible)",
// "Highlight group" => "Highlight group",
// "Show user's contribution on the user information page" => "Show user's contribution on the user information page",
// "Display UserTracker information on the user information page" => "Display UserTracker information on the user information page",
// "Use the format: trackerId, fieldId1, fieldId2, .." => "Use the format: trackerId, fieldId1, fieldId2, ..",
// "Separators" => "Separators",
// "Locations (breadcrumbs)" => "Locations (breadcrumbs)",
// "Examples" => "Examples",
// "Choices" => "Choices",
// "Default timezone" => "Default timezone",
// "Use site default to show times" => "Use site default to show times",
// "Detect user timezone (if browser allows). Otherwise use site default" => "Detect user timezone (if browser allows). Otherwise use site default",
// "Sample" => "Sample",
// "Fields display order" => "Fields display order",
// "Change the <strong>Admin</strong> password" => "Change the <strong>Admin</strong> password",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at " => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at ",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Babelfish links" => "Babelfish links",
// "Customized String Translation" => "Customized String Translation",
// "Default language" => "Default language",
// "Detect browser language" => "Detect browser language",
// "Show pages in user's preferred language" => "Show pages in user's preferred language",
// "User preferences are disabled" => "User preferences are disabled",
// "Users can change site language" => "Users can change site language",
// "Restrict supported languages" => "Restrict supported languages",
// "Available languages" => "Available languages",
// "Use Ctrl+Click to select multiple languages" => "Use Ctrl+Click to select multiple languages",
// "Display available translations" => "Display available translations",
// "Changing page language will also change the site language" => "Changing page language will also change the site language",
// "Translation assistant" => "Translation assistant",
// "Urgent translation notifications" => "Urgent translation notifications",
// "Quantify change size" => "Quantify change size",
// "Multilingual structures" => "Multilingual structures",
// "Structures are disabled" => "Structures are disabled",
// "Multilingual One Page feature" => "Multilingual One Page feature",
// "Syntax error" => "Syntax error",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// "as master" => "as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "Enable/disable Tiki features in " => "Enable/disable Tiki features in ",
// ", but configure them elsewhere" => ", but configure them elsewhere",
// "Look and Feel" => "Look and Feel",
// "Text Area" => "Text Area",
// "Wysiwyg" => "Wysiwyg",
// "Semantic" => "Semantic",
// "Webservices management" => "Webservices management",
// "PAM" => "PAM",
// "CAS" => "CAS",
// "Tiki" => "Tiki",
// "Tiki and OpenID" => "Tiki and OpenID",
// "Registration" => "Registration",
// "Validate by email" => "Validate by email",
// "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>",
// "Validate user's email server" => "Validate user's email server",
// "Require validation by Admin" => "Require validation by Admin",
// "Require passcode to register" => "Require passcode to register",
// "Passcode" => "Passcode",
// "Users must enter this code to register" => "Users must enter this code to register",
// "Use CAPTCHA to prevent automatic/robot registrations" => "Use CAPTCHA to prevent automatic/robot registrations",
// "Requires PHP GD library" => "Requires PHP GD library",
// "Include &quot;Generate Password&quot; option on registration form" => "Include &quot;Generate Password&quot; option on registration form",
// "Use tracker to collect more user information" => "Use tracker to collect more user information",
// "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display" => "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display",
// "Use tracker to collect more group information" => "Use tracker to collect more group information",
// "Users can select a group to join at registration" => "Users can select a group to join at registration",
// "By default, new users automatically join the Registered group" => "By default, new users automatically join the Registered group",
// "Re-validate user by email after" => "Re-validate user by email after",
// "Use <strong>-1</strong> for never" => "Use <strong>-1</strong> for never",
// "unsuccessful login attempts" => "unsuccessful login attempts",
// "Create a new group for each user" => "Create a new group for each user",
// "The group will be named identical to the user's username" => "The group will be named identical to the user's username",
// "Disable browser's autocomplete feature for username and password fields" => "Disable browser's autocomplete feature for username and password fields",
// "Confirm that the Admin account has a valid email address or you will not be permitted to login" => "Confirm that the Admin account has a valid email address or you will not be permitted to login",
// "Use HTTPS login" => "Use HTTPS login",
// "Users can choose to stay in SSL mode after an HTTPS login" => "Users can choose to stay in SSL mode after an HTTPS login",
// "Users can switch between secured or standard mode at login" => "Users can switch between secured or standard mode at login",
// "User's choice" => "User's choice",
// "Always" => "Always",
// "Cookie name" => "Cookie name",
// "Use email as username" => "Use email as username",
// "Minimum length" => "Minimum length",
// "Maximum length" => "Maximum length",
// "Force lowercase" => "Force lowercase",
// "Username pattern" => "Username pattern",
// "Store password as plain text" => "Store password as plain text",
// "Store passwords in plain text is activated. You should never set this unless you know what you are doing" => "Store passwords in plain text is activated. You should never set this unless you know what you are doing",
// "Remind/forgot password" => "Remind/forgot password",
// "If passwords </em>are stored<em> as plain text, the password will be emailed to the user" => "If passwords </em>are stored<em> as plain text, the password will be emailed to the user",
// "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user" => "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user",
// "Encryption method" => "Encryption method",
// "Users can change their password" => "Users can change their password",
// "Require characters and numerals" => "Require characters and numerals",
// "Password expires after" => "Password expires after",
// "You must change the Authentication Method to PEAR::Auth for these changes to take effect" => "You must change the Authentication Method to PEAR::Auth for these changes to take effect",
// "Create user if not in Tiki" => "Create user if not in Tiki",
// "Create user if not in Auth" => "Create user if not in Auth",
// "Use Tiki authentication for Admin login" => "Use Tiki authentication for Admin login",
// "LDAP" => "LDAP",
// "Will override the Host and Port settings" => "Will override the Host and Port settings",
// "Search scope" => "Search scope",
// "Subtree" => "Subtree",
// "One level" => "One level",
// "Base object" => "Base object",
// "LDAP version" => "LDAP version",
// "Realname attribute" => "Realname attribute",
// "Country attribute" => "Country attribute",
// "E-mail attribute" => "E-mail attribute",
// "Base DN" => "Base DN",
// "LDAP User" => "LDAP User",
// "User DN" => "User DN",
// "User attribute" => "User attribute",
// "User OC" => "User OC",
// "LDAP Group" => "LDAP Group",
// "Group DN" => "Group DN",
// "Group attribute" => "Group attribute",
// "Group OC" => "Group OC",
// "LDAP Member" => "LDAP Member",
// "Member attribute" => "Member attribute",
// "Member is DN" => "Member is DN",
// "LDAP Admin" => "LDAP Admin",
// "Admin user" => "Admin user",
// "Admin password" => "Admin password",
// "You must change the Authentication Method to PAM for these changes to take effect" => "You must change the Authentication Method to PAM for these changes to take effect",
// "PAM service" => "PAM service",
// "Currently unused" => "Currently unused",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
// "You must change the Authentication Method to Shibboleth for these changes to take effect" => "You must change the Authentication Method to Shibboleth for these changes to take effect",
// "Valid affiliations" => "Valid affiliations",
// "Separate multiple affiliations with commas" => "Separate multiple affiliations with commas",
// "Create with default group" => "Create with default group",
// "Default group" => "Default group",
// "You must change the Authentication Method to CAS for these changes to take effect" => "You must change the Authentication Method to CAS for these changes to take effect",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/" => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/",
// "CAS server version" => "CAS server version",
// "Version 1.0" => "Version 1.0",
// "Version 2.0" => "Version 2.0",
// "CAS Server" => "CAS Server",
// "Hostname" => "Hostname",
// "You must enable PHP CAS first" => "You must enable PHP CAS first",
// "General Layout" => "General Layout",
// "UI Effects" => "UI Effects",
// "The \"users can change theme\" feature will override the theme displayed" => "The \"users can change theme\" feature will override the theme displayed",
// "Theme not saved yet - click \"Apply\"" => "Theme not saved yet - click \"Apply\"",
// "Theme options" => "Theme options",
// "Restrict available themes" => "Restrict available themes",
// "Available styles" => "Available styles",
// "Each group can have its theme" => "Each group can have its theme",
// "Use transition style sheet from version" => "Use transition style sheet from version",
// "Template Viewing" => "Template Viewing",
// "View Templates" => "View Templates",
// "Shadow layer" => "Shadow layer",
// "Enable additional general layout layers for shadows, rounded corners or other decorative styling" => "Enable additional general layout layers for shadows, rounded corners or other decorative styling",
// "Main shadow start" => "Main shadow start",
// "Main shadow end" => "Main shadow end",
// "Header shadow start" => "Header shadow start",
// "Header shadow end" => "Header shadow end",
// "Middle shadow start" => "Middle shadow start",
// "Middle shadow end" => "Middle shadow end",
// "Center shadow start" => "Center shadow start",
// "Center shadow end" => "Center shadow end",
// "Footer shadow start" => "Footer shadow start",
// "Footer shadow end" => "Footer shadow end",
// "Custom Site Header" => "Custom Site Header",
// "Activate will only show content for admin. Check Publish to use content for all users" => "Activate will only show content for admin. Check Publish to use content for all users",
// "Site Logo and Title" => "Site Logo and Title",
// "Site logo source (image path)" => "Site logo source (image path)",
// "Site logo background color" => "Site logo background color",
// "Site logo background style" => "Site logo background style",
// "Site logo alignment" => "Site logo alignment",
// "Site logo title (on mouse over)" => "Site logo title (on mouse over)",
// "Alt. description (e.g. for text browsers)" => "Alt. description (e.g. for text browsers)",
// "Site title" => "Site title",
// "Site subtitle" => "Site subtitle",
// "Site Search Bar" => "Site Search Bar",
// "Site Login Bar" => "Site Login Bar",
// "Top Bar" => "Top Bar",
// "Site menu bar" => "Site menu bar",
// "Note: Needs feature PHPLayers on(default), or feature CSS Menu on  " => "Note: Needs feature PHPLayers on(default), or feature CSS Menu on  ",
// "Menu ID" => "Menu ID",
// "Current Version" => "Current Version",
// "Custom code" => "Custom code",
// "Users can Flip Columns" => "Users can Flip Columns",
// "always" => "always",
// "user decides" => "user decides",
// "Site Breadcrumbs" => "Site Breadcrumbs",
// "Site location bar" => "Site location bar",
// "at top of page" => "at top of page",
// "at top of center column" => "at top of center column",
// "Prefix breadcrumbs with 'Location : '" => "Prefix breadcrumbs with 'Location : '",
// "Larger font for" => "Larger font for",
// "entire location" => "entire location",
// "page name" => "page name",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Left blank to use the default sender email" => "Left blank to use the default sender email",
// "Email this page" => "Email this page",
// "Custom Site Footer" => "Custom Site Footer",
// "Custom End of <body> Code" => "Custom End of <body> Code",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "Bottom bar (RSS)" => "Bottom bar (RSS)",
// "Power by" => "Power by",
// "Pagination links" => "Pagination links",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Max. number of links around the current item" => "Max. number of links around the current item",
// "Max. number of links after the first or before the last item" => "Max. number of links after the first or before the last item",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Hide pagination when there is only one page" => "Hide pagination when there is only one page",
// "Use Icons" => "Use Icons",
// "JQuery plugins and add-ons" => "JQuery plugins and add-ons",
// "Requires jquery feature" => "Requires jquery feature",
// "JQuery Tooltips" => "JQuery Tooltips",
// "JQuery Tooltips: Customisable help tips" => "JQuery Tooltips: Customisable help tips",
// "JQuery Autocomplete" => "JQuery Autocomplete",
// "JQuery Superfish" => "JQuery Superfish",
// "JQuery Superfish (effects on CSS menus)" => "JQuery Superfish (effects on CSS menus)",
// "JQuery Reflection" => "JQuery Reflection",
// "JQuery Reflection (reflection effect on images)" => "JQuery Reflection (reflection effect on images)",
// "JQuery Cycle (slideshow)" => "JQuery Cycle (slideshow)",
// "For future use" => "For future use",
// "JQuery UI" => "JQuery UI",
// "JQuery UI: More JQuery functionality" => "JQuery UI: More JQuery functionality",
// "JQuery Sheet" => "JQuery Sheet",
// "JQuery Spreadsheet" => "JQuery Spreadsheet",
// "JQuery Sortable Tables" => "JQuery Sortable Tables",
// "Standard UI effects" => "Standard UI effects",
// "Effect for modules etc" => "Effect for modules etc",
// "Main JQuery effect" => "Main JQuery effect",
// "Slide" => "Slide",
// "Blind (UI)" => "Blind (UI)",
// "Clip (UI)" => "Clip (UI)",
// "Drop (UI)" => "Drop (UI)",
// "Explode (UI)" => "Explode (UI)",
// "Fold (UI)" => "Fold (UI)",
// "Puff (UI)" => "Puff (UI)",
// "Slide (UI)" => "Slide (UI)",
// "Effect speed" => "Effect speed",
// "Fast" => "Fast",
// "Slow" => "Slow",
// "Effect direction" => "Effect direction",
// "Vertical" => "Vertical",
// "Horizontal" => "Horizontal",
// "Left" => "Left",
// "Right" => "Right",
// "Tab UI effects" => "Tab UI effects",
// "Effect for tabs" => "Effect for tabs",
// "JQuery effect for tabs" => "JQuery effect for tabs",
// "Effect speed for tabs" => "Effect speed for tabs",
// "Effect direction for tabs" => "Effect direction for tabs",
// "Other options" => "Other options",
// "Use Tabs" => "Use Tabs",
// "Favicon icon file name" => "Favicon icon file name",
// "Favicon icon MIME type" => "Favicon icon MIME type",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "Correct PNG images alpha transparency in IE6 (experimental)" => "Correct PNG images alpha transparency in IE6 (experimental)",
// "List of CSS selectors to be fixed, each selector separated by comma" => "List of CSS selectors to be fixed, each selector separated by comma",
// "List of HTMLDomElements to be fixed, each element separated by comma" => "List of HTMLDomElements to be fixed, each element separated by comma",
// "Context Menus (only in file galleries so far)" => "Context Menus (only in file galleries so far)",
// "Use context menus for actions (icons)" => "Use context menus for actions (icons)",
// "Use context menus for actions (text)" => "Use context menus for actions (text)",
// "Full path to ogr2ogr" => "Full path to ogr2ogr",
// "Map Zone" => "Map Zone",
// "Generate User Map" => "Generate User Map",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Maximum mailbox size (messages, 0=unlimited)" => "Maximum mailbox size (messages, 0=unlimited)",
// "Maximum mail archive size (messages, 0=unlimited)" => "Maximum mail archive size (messages, 0=unlimited)",
// "Maximum sent box size (messages, 0=unlimited)" => "Maximum sent box size (messages, 0=unlimited)",
// "Change Preferences" => "Change Preferences",
// "Meta tags" => "Meta tags",
// "Keywords" => "Keywords",
// "Include freetags" => "Include freetags",
// "Use thread title instead" => "Use thread title instead",
// "Use image title instead" => "Use image title instead",
// "Geo URL" => "Geo URL",
// "geo.position" => "geo.position",
// "geo.region" => "geo.region",
// "geo.placename" => "geo.placename",
// "Robots" => "Robots",
// "Meta robots" => "Meta robots",
// "Revisit after" => "Revisit after",
// "&quot;Modules&quot; are the boxes of content in the right &amp; left columns" => "&quot;Modules&quot; are the boxes of content in the right &amp; left columns",
// "Admin &gt; Modules" => "Admin &gt; Modules",
// "from the menu to create and edit modules" => "from the menu to create and edit modules",
// "Show module controls" => "Show module controls",
// "Users can configure modules" => "Users can configure modules",
// "Users can shade modules" => "Users can shade modules",
// "Module decides" => "Module decides",
// "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item" => "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Length" => "Flash Length",
// "Flash Heigth" => "Flash Heigth",
// "Video Length" => "Video Length",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or",
// "Anonymous voting" => "Anonymous voting",
// "Allow re-voting" => "Allow re-voting",
// "Show categories" => "Show categories",
// "Categories disabled" => "Categories disabled",
// "Show objects" => "Show objects",
// "Are you sure you want to install the profile" => "Are you sure you want to install the profile",
// "TikiWiki Profiles" => "TikiWiki Profiles",
// "Profile repository" => "Profile repository",
// "Filter the list of profiles" => "Filter the list of profiles",
// "Profile" => "Profile",
// "Repository" => "Repository",
// "installed" => "installed",
// "Repositories" => "Repositories",
// "Repository URLs" => "Repository URLs",
// "Enter multiple repository URLs, one per line" => "Enter multiple repository URLs, one per line",
// "Data Channels" => "Data Channels",
// "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. " => "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. ",
// "More information" => "More information",
// "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS Modules</strong> menu option, or" => "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS Modules</strong> menu option, or",
// "Feed for articles" => "Feed for articles",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Show Author" => "Show Author",
// "Homepage URL" => "Homepage URL",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Feed for image galleries" => "Feed for image galleries",
// "Individual image galleries" => "Individual image galleries",
// "Feed for file galleries" => "Feed for file galleries",
// "Individual file galleries" => "Individual file galleries",
// "Feed for wiki" => "Feed for wiki",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "Calendar events" => "Calendar events",
// "Feed for directory" => "Feed for directory",
// "Map files" => "Map files",
// "Feed for maps" => "Feed for maps",
// "Defaults" => "Defaults",
// "Image Path" => "Image Path",
// "Caching time" => "Caching time",
// "Use <strong>0</strong> for no caching" => "Use <strong>0</strong> for no caching",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public" => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public",
// "You can see users rank by score in the module users_rank, for that go to" => "You can see users rank by score in the module users_rank, for that go to",
// "Admin modules" => "Admin modules",
// "Expiration" => "Expiration",
// "can be seen on page" => "can be seen on page",
// "in Admin menu" => "in Admin menu",
// "Search Results" => "Search Results",
// "Search type" => "Search type",
// "Database search" => "Database search",
// "This search uses the MySQL Full-Text feature" => "This search uses the MySQL Full-Text feature",
// "Tiki search" => "Tiki search",
// "This database-independent search is always enabled" => "This database-independent search is always enabled",
// "Specify the Tiki search settings" => "Specify the Tiki search settings",
// "Refresh mode" => "Refresh mode",
// "Use <strong>0</strong> for no refresh" => "Use <strong>0</strong> for no refresh",
// "Minimum length of search word" => "Minimum length of search word",
// "Max. number of words containing a syllable" => "Max. number of words containing a syllable",
// "Max. age in hours of syllable search cache" => "Max. age in hours of syllable search cache",
// "LRU list purging rate" => "LRU list purging rate",
// "LRU list length" => "LRU list length",
// "When the Database search is enabled, you must manually refresh the Tiki search indexes" => "When the Database search is enabled, you must manually refresh the Tiki search indexes",
// "Refresh all search index now" => "Refresh all search index now",
// "Refresh wiki search index now" => "Refresh wiki search index now",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "Referer Search Highlighting" => "Referer Search Highlighting",
// "Parse the results" => "Parse the results",
// "May impact performance" => "May impact performance",
// "Enabling these options will improve performance, but may show forbidden results" => "Enabling these options will improve performance, but may show forbidden results",
// "Ignore individual object permissions" => "Ignore individual object permissions",
// "Select the items to display on the search results page" => "Select the items to display on the search results page",
// "Object filter" => "Object filter",
// "Search box" => "Search box",
// "Select the information to display for each result" => "Select the information to display for each result",
// "Pertinence" => "Pertinence",
// "Last modified date" => "Last modified date",
// "Search engine friendly url Postfilter" => "Search engine friendly url Postfilter",
// "List of Url Parameters that should go in the path" => "List of Url Parameters that should go in the path",
// "Display article title in the sefurl" => "Display article title in the sefurl",
// "Display blog title in the sefurl" => "Display blog title in the sefurl",
// "Known Types" => "Known Types",
// "Token" => "Token",
// "Invert" => "Invert",
// "Show Usage" => "Show Usage",
// "Delete &amp; Unreference" => "Delete &amp; Unreference",
// "Invert Relation" => "Invert Relation",
// "Self" => "Self",
// "New Types" => "New Types",
// "Fix" => "Fix",
// "No occurences found" => "No occurences found",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "Plugins" => "Plugins",
// "Plugin Aliases" => "Plugin Aliases",
// "Anonymous editors must enter anti-bot code (CAPTCHA)" => "Anonymous editors must enter anti-bot code (CAPTCHA)",
// "Protect email against spam" => "Protect email against spam",
// "External link icon" => "External link icon",
// "External links will be identified with" => "External links will be identified with",
// "Use File Galleries to store pictures " => "Use File Galleries to store pictures ",
// "Allow to post comments as Anonymous" => "Allow to post comments as Anonymous",
// "Wiki paragraph formatting" => "Wiki paragraph formatting",
// "...but still create line breaks within paragraphs" => "...but still create line breaks within paragraphs",
// "&lt;return&gt; for rows" => "&lt;return&gt; for rows",
// "Show quicktags above textareas" => "Show quicktags above textareas",
// "If disabled, quicktags will be shown to the left of textareas" => "If disabled, quicktags will be shown to the left of textareas",
// "Open Hotwords in new window" => "Open Hotwords in new window",
// "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting",
// "Plugin disabled" => "Plugin disabled",
// "Default size" => "Default size",
// "Comments " => "Comments ",
// "Forum reply" => "Forum reply",
// "About plugins" => "About plugins",
// "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below" => "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below",
// "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>" => "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>",
// "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below" => "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below",
// "Edit plugin icons" => "Edit plugin icons",
// "Enable edit plugin icons" => "Enable edit plugin icons",
// "(experimental - not comprehensively tested and requires new JQuery feature)" => "(experimental - not comprehensively tested and requires new JQuery feature)",
// "Enable" => "Enable",
// "Disable edit plugin icon (make plugin inline)" => "Disable edit plugin icon (make plugin inline)",
// "About plugin aliases" => "About plugin aliases",
// "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}" => "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}",
// "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}" => "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}",
// "Available Alias" => "Available Alias",
// "Enable Plugins" => "Enable Plugins",
// "General Information" => "General Information",
// "Plugin Name" => "Plugin Name",
// "Base Plugin" => "Base Plugin",
// "Body Label" => "Body Label",
// "Dependencies" => "Dependencies",
// "Validation" => "Validation",
// "Inline (No Plugin Edit UI)" => "Inline (No Plugin Edit UI)",
// "Simple Plugin Arguments" => "Simple Plugin Arguments",
// "Argument" => "Argument",
// "New Argument" => "New Argument",
// "Plugin Parameter Documentation" => "Plugin Parameter Documentation",
// "Safe" => "Safe",
// "Plugin Body" => "Plugin Body",
// "Ignore User Input" => "Ignore User Input",
// "Default Content" => "Default Content",
// "Encoding" => "Encoding",
// "Argument Source (if different)" => "Argument Source (if different)",
// "Default Value" => "Default Value",
// "Composed Plugin Arguments" => "Composed Plugin Arguments",
// "Pattern" => "Pattern",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "Tracker attachment preferences" => "Tracker attachment preferences",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "Validate choice" => "Validate choice",
// "Tracker attachments" => "Tracker attachments",
// "Storage" => "Storage",
// "Change" => "Change",
// "No records" => "No records",
// "Change all to db" => "Change all to db",
// "Change all to file" => "Change all to file",
// "Unlimited" => "Unlimited",
// "Include a flag by each e-mail to quickly flag/un-flag them" => "Include a flag by each e-mail to quickly flag/un-flag them",
// "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used" => "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used",
// "Lookup" => "Lookup",
// "Test Input" => "Test Input",
// "Response Information" => "Response Information",
// "OIntegrate Version" => "OIntegrate Version",
// "Not supported" => "Not supported",
// "Schema Version" => "Schema Version",
// "Schema Documentation" => "Schema Documentation",
// "Available" => "Available",
// "Not specified, default used" => "Not specified, default used",
// "Content Type" => "Content Type",
// "Not specified" => "Not specified",
// "Returned Data" => "Returned Data",
// "Proposed Templates" => "Proposed Templates",
// "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters" => "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters",
// "Register Service" => "Register Service",
// "Registered Templates" => "Registered Templates",
// "Engine" => "Engine",
// "Output" => "Output",
// "Register Template" => "Register Template",
// "Use the 'Quick Edit' module to easily create or edit wiki pages" => "Use the 'Quick Edit' module to easily create or edit wiki pages",
// "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules" => "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules",
// "Staging &amp; Approval" => "Staging &amp; Approval",
// "Page Listings" => "Page Listings",
// "If the page does not exist, it will be created" => "If the page does not exist, it will be created",
// "Wiki link format" => "Wiki link format",
// "Latin" => "Latin",
// "Select the characters that can be used with Wiki link syntax: ((page name))" => "Select the characters that can be used with Wiki link syntax: ((page name))",
// "Page display" => "Page display",
// "Page ID" => "Page ID",
// "Page version" => "Page version",
// "Page name display stripper" => "Page name display stripper",
// "Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>" => "Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>",
// "Allow override per page" => "Allow override per page",
// "Display show/hide icon displayed before headings" => "Display show/hide icon displayed before headings",
// "Wiki action bar" => "Wiki action bar",
// "Buttons: Save, Preview, Cancel, .." => "Buttons: Save, Preview, Cancel, ..",
// "Page navigation bar location" => "Page navigation bar location",
// "When using the ...page... page break wiki syntax" => "When using the ...page... page break wiki syntax",
// "Wiki top line" => "Wiki top line",
// "Neither" => "Neither",
// "Page description, icons, backlinks, .." => "Page description, icons, backlinks, ..",
// "Wiki buttons" => "Wiki buttons",
// "Buttons: Edit, Source, Remove, .." => "Buttons: Edit, Source, Remove, ..",
// "Warn on edit conflict" => "Warn on edit conflict",
// "Edit idle timeout" => "Edit idle timeout",
// "Save draft" => "Save draft",
// "Requires AJAX" => "Requires AJAX",
// "experimental" => "experimental",
// "Edit section" => "Edit section",
// "Edit section level" => "Edit section level",
// "Allow minor edits" => "Allow minor edits",
// "Minor edits do not flag new content for translation and do not send watch notifications" => "Minor edits do not flag new content for translation and do not send watch notifications",
// "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled" => "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled",
// "Regex search and replace" => "Regex search and replace",
// "Log bytes changes (+/-) in action logs" => "Log bytes changes (+/-) in action logs",
// "Display by default" => "Display by default",
// "Manage attachments" => "Manage attachments",
// "Tag for current wiki" => "Tag for current wiki",
// "Restore wiki to tag" => "Restore wiki to tag",
// "Restore" => "Restore",
// "WikiWords" => "WikiWords",
// "Accept dashes and underscores in WikiWords" => "Accept dashes and underscores in WikiWords",
// "Maximum number of versions" => "Maximum number of versions",
// "Never delete versions younger than" => "Never delete versions younger than",
// "Display IP address" => "Display IP address",
// "Default diff style" => "Default diff style",
// "HTML diff" => "HTML diff",
// "Side-by-side diff" => "Side-by-side diff",
// "Side-by-side diff by characters" => "Side-by-side diff by characters",
// "Inline diff" => "Inline diff",
// "Inline diff by characters" => "Inline diff by characters",
// "Full side-by-side diff by characters" => "Full side-by-side diff by characters",
// "Full inline diff" => "Full inline diff",
// "Full inline diff by characters" => "Full inline diff by characters",
// "History includes only page data, description, and change comment" => "History includes only page data, description, and change comment",
// "Forums are disabled" => "Forums are disabled",
// "Forum for discussion" => "Forum for discussion",
// "View source" => "View source",
// "Polls are disabled" => "Polls are disabled",
// "Similar" => "Similar",
// "like pages" => "like pages",
// "Open page as structure" => "Open page as structure",
// "Make structure from page" => "Make structure from page",
// "Categorize structure pages together" => "Categorize structure pages together",
// "Create webhelp from structure" => "Create webhelp from structure",
// "Import pages" => "Import pages",
// "Slideshows" => "Slideshows",
// "User's page" => "User's page",
// "UserPage prefix" => "UserPage prefix",
// "Users can lock pages" => "Users can lock pages",
// "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page" => "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page",
// "Wiki watch" => "Wiki watch",
// "Create watch for author on page creation" => "Create watch for author on page creation",
// "Enable watch events when I am the editor" => "Enable watch events when I am the editor",
// "Watch minor edits" => "Watch minor edits",
// "Use wiki page staging and approval" => "Use wiki page staging and approval",
// "Force bounce of editing of approved pages to staging" => "Force bounce of editing of approved pages to staging",
// "Delete staging pages at approval" => "Delete staging pages at approval",
// "If not in the group, edit is always redirected to the staging page edit" => "If not in the group, edit is always redirected to the staging page edit",
// "Unique page name prefix to indicate staging copy" => "Unique page name prefix to indicate staging copy",
// "Hide page name prefix" => "Hide page name prefix",
// "Staging" => "Staging",
// "Approved" => "Approved",
// "(mandatory for feature to work)" => "(mandatory for feature to work)",
// "Out-of-sync" => "Out-of-sync",
// "Categorize approved pages with categories of staging copy on approval" => "Categorize approved pages with categories of staging copy on approval",
// "Freetags are disabled" => "Freetags are disabled",
// "Replace freetags with that of staging pages, on approval" => "Replace freetags with that of staging pages, on approval",
// "Add new freetags of approved copy (into tags field) when editing staging pages" => "Add new freetags of approved copy (into tags field) when editing staging pages",
// "Orphan page" => "Orphan page",
// "Configuration" => "Configuration",
// "Select which items to display when listing pages" => "Select which items to display when listing pages",
// "Name length" => "Name length",
// "Edit comments" => "Edit comments",
// "Edit Comments length" => "Edit Comments length",
// "Categories path" => "Categories path",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "Wysiwyg Editor is optional" => "Wysiwyg Editor is optional",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Toolbar content" => "Toolbar content",
// "Database Version Problem" => "Database Version Problem",
// "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>" => "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>",
// "The following list of changes has been applied" => "The following list of changes has been applied",
// "disabled" => "disabled",
// "enabled" => "enabled",
// "information" => "information",
// "preference" => "preference",
// "preference name" => "preference name",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Administration features" => "Administration features",
// "Security" => "Security",
// "TikiCache/System" => "TikiCache/System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Edit Languages" => "Edit Languages",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "Look &amp; feel" => "Look &amp; feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "Stats &amp; banners" => "Stats &amp; banners",
// "Report" => "Report",
// "Setting" => "Setting",
// "Please select some actions to view" => "Please select some actions to view",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot" => "Group Bar Plot",
// "Accumulated Bar Plot" => "Accumulated Bar Plot",
// "Legend background color" => "Legend background color",
// "Save graphs to image gallery" => "Save graphs to image gallery",
// "contribution" => "contribution",
// "contributor" => "contributor",
// "Edit Action" => "Edit Action",
// "Save Action" => "Save Action",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "recorded" => "recorded",
// "Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki page actions except viewed will always be recorded but can be not reported",
// "Configure" => "Configure",
// "Create Calendar" => "Create Calendar",
// "View Calendars" => "View Calendars",
// "Edit Calendar" => "Edit Calendar",
// "Subscription" => "Subscription",
// "Perso" => "Perso",
// "View Calendar" => "View Calendar",
// "Add Event" => "Add Event",
// "Create/Edit Calendars" => "Create/Edit Calendars",
// "Custom Participants" => "Custom Participants",
// "Custom URL" => "Custom URL",
// "Custom Subscription List" => "Custom Subscription List",
// "Personal Calendar" => "Personal Calendar",
// "Start of day" => "Start of day",
// "End of day" => "End of day",
// "Standard Colors" => "Standard Colors",
// "Green" => "Green",
// "Blue" => "Blue",
// "Purple" => "Purple",
// "Red" => "Red",
// "Orange" => "Orange",
// "Yellow" => "Yellow",
// "Let me select my own colors" => "Let me select my own colors",
// "Custom foreground color" => "Custom foreground color",
// "Ex" => "Ex",
// "Custom background color" => "Custom background color",
// "Default event status" => "Default event status",
// "Show in calendar view" => "Show in calendar view",
// "Group of users alerted when calendar event is modified" => "Group of users alerted when calendar event is modified",
// "Delete events older than" => "Delete events older than",
// "Browse the category system" => "Browse the category system",
// "Current Category ID" => "Current Category ID",
// "Edit permissions for this category" => "Edit permissions for this category",
// "Perms inherited from closest parent if possible or from global perms" => "Perms inherited from closest parent if possible or from global perms",
// "Assign permissions automatically" => "Assign permissions automatically",
// "recommended for best performance" => "recommended for best performance",
// "Remove from this Category" => "Remove from this Category",
// "Admin charts" => "Admin charts",
// "Users can vote for only one item from this chart per period" => "Users can vote for only one item from this chart per period",
// "Prevent users from voting for the same item more than once" => "Prevent users from voting for the same item more than once",
// "Use in" => "Use in",
// "No features are configured to use templates" => "No features are configured to use templates",
// "Visible in no sections" => "Visible in no sections",
// "Remove section" => "Remove section",
// "Admin Contributions" => "Admin Contributions",
// "Edit the contribution" => "Edit the contribution",
// "Contributions are mandatory in wiki pages" => "Contributions are mandatory in wiki pages",
// "Contributions are mandatory in forums" => "Contributions are mandatory in forums",
// "Contributions are mandatory in comments" => "Contributions are mandatory in comments",
// "Contributions are mandatory in blogs" => "Contributions are mandatory in blogs",
// "Contributions are displayed in the comment/post" => "Contributions are displayed in the comment/post",
// "Create a new contribution" => "Create a new contribution",
// "List of contributions" => "List of contributions",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}" => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link" => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link",
// "Use Admin DSN to define the database to be used by the SQL plugin" => "Use Admin DSN to define the database to be used by the SQL plugin",
// "Admin External Wikis" => "Admin External Wikis",
// "View template" => "View template",
// "tiki admin external wikis template" => "tiki admin external wikis template",
// "Edit template" => "Edit template",
// "Enable Features" => "Enable Features",
// "Duplicate forum" => "Duplicate forum",
// "View this forum" => "View this forum",
// "Import forums" => "Import forums",
// "Only allow replies to the first message (flat forum)" => "Only allow replies to the first message (flat forum)",
// "Posts can be rated" => "Posts can be rated",
// "Send mails even when the post is generated by inbound mail" => "Send mails even when the post is generated by inbound mail",
// "Append a reply link to outbound mails" => "Append a reply link to outbound mails",
// "Set topics preferences" => "Set topics preferences",
// "Show topics preferences" => "Show topics preferences",
// "hide topics preferences" => "hide topics preferences",
// "Set thread preferences" => "Set thread preferences",
// "Show threads preferences" => "Show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default style for threads" => "Default style for threads",
// "Duplicate Forum" => "Duplicate Forum",
// "Duplicate" => "Duplicate",
// "List Forums" => "List Forums",
// ".." => "..",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature" => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature",
// "Regex modifiers" => "Regex modifiers",
// "Configure/Options" => "Configure/Options",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>" => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>",
// "Mail-in accounts" => "Mail-in accounts",
// "Account" => "Account",
// "Add new Mail-in account" => "Add new Mail-in account",
// "Edit Mail-in account" => "Edit Mail-in account",
// "article-put" => "article-put",
// "Article Topic" => "Article Topic",
// "Article Type" => "Article Type",
// "Allow anonymous acces" => "Allow anonymous acces",
// "Allow attachments" => "Allow attachments",
// "Discard to the end from" => "Discard to the end from",
// "Check Mail-in accounts" => "Check Mail-in accounts",
// "Check automatically" => "Check automatically",
// "Frequency" => "Frequency",
// "mn" => "mn",
// "Show Quick Urls" => "Show Quick Urls",
// "Hide Quick Urls" => "Hide Quick Urls",
// "For wiki page, use ((PageName))" => "For wiki page, use ((PageName))",
// "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Use Ctrl+Click to select multiple groups" => "Use Ctrl+Click to select multiple groups",
// "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each" => "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each",
// "section level 0" => "section level 0",
// "section level 1" => "section level 1",
// "section level 2" => "section level 2",
// "section level 3" => "section level 3",
// "sorted section level 0" => "sorted section level 0",
// "separator" => "separator",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'" => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu" => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format" => "To use a menu in a tiki format",
// "To use menu in a css/suckerfish format" => "To use menu in a css/suckerfish format",
// "To customize the menu's CSS id (#)" => "To customize the menu's CSS id (#)",
// "Folder Icon" => "Folder Icon",
// "Path and filename of closed folder icon" => "Path and filename of closed folder icon",
// "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder" => "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder",
// "In the same directory, include an icon for the opened folder" => "In the same directory, include an icon for the opened folder",
// "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>" => "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>",
// "For example, the default icon is: pics/icons/folder.png" => "For example, the default icon is: pics/icons/folder.png",
// "The name of the \"open folder\" icon is: pics/icons/ofolder.png" => "The name of the \"open folder\" icon is: pics/icons/ofolder.png",
// "Active Permissions" => "Active Permissions",
// "Assign/Edit modules" => "Assign/Edit modules",
// "Move Up" => "Move Up",
// "Move Down" => "Move Down",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y" => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y",
// "The" => "The",
// "Display Modules to All Groups" => "Display Modules to All Groups",
// "setting will override your selection of specific groups" => "setting will override your selection of specific groups",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules" => "to make sure users will notice any newly assigned modules",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site" => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site",
// "Must be wiki parsed" => "Must be wiki parsed",
// "Random active poll" => "Random active poll",
// "Random current poll" => "Random current poll",
// "phpLayersMenus" => "phpLayersMenus",
// "Use phplayermenu" => "Use phplayermenu",
// "Use Wiki Structure" => "Use Wiki Structure",
// "Edit Newsletter" => "Edit Newsletter",
// "You can add several email addresses by separating them with commas" => "You can add several email addresses by separating them with commas",
// "Add email" => "Add email",
// "Add user" => "Add user",
// "Group users" => "Group users",
// "Group subscription also subscribes included groups" => "Group subscription also subscribes included groups",
// "Don't send confirmation mail" => "Don't send confirmation mail",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Subscribe group" => "Subscribe group",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Create Newsletter" => "Create Newsletter",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Drafts" => "Drafts",
// "Mail notifications" => "Mail notifications",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications",
// "Alert" => "Alert",
// "A user edits an article" => "A user edits an article",
// "A user deletes an article" => "A user deletes an article",
// "Any wiki page is changed, even minor changes" => "Any wiki page is changed, even minor changes",
// "A comment in a wiki page is posted or edited" => "A comment in a wiki page is posted or edited",
// "PHP error" => "PHP error",
// "Preload Admin Account" => "Preload Admin Account",
// "User / Group" => "User / Group",
// "Multiple" => "Multiple",
// "Trackers Outbound Emails" => "Trackers Outbound Emails",
// "Forums Outbound Emails" => "Forums Outbound Emails",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "Toggle Quick Options" => "Toggle Quick Options",
// "Add Option" => "Add Option",
// "Leave box empty for deleting an option" => "Leave box empty for deleting an option",
// "Votes older than these days are no more considered" => "Votes older than these days are no more considered",
// "0 for no limit" => "0 for no limit",
// "Span" => "Span",
// "Add poll to pages" => "Add poll to pages",
// "Wiki pages" => "Wiki pages",
// "Use Ctrl+Click to select multiple pages" => "Use Ctrl+Click to select multiple pages",
// "Lock the pages" => "Lock the pages",
// "Quicktags category filter" => "Quicktags category filter",
// "Tips" => "Tips",
// "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed" => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed",
// "Edit this RSS Module" => "Edit this RSS Module",
// "Create new RSS Module" => "Create new RSS Module",
// "RSS channels" => "RSS channels",
// "Show Date" => "Show Date",
// "View feed" => "View feed",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>" => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>",
// "PHP settings" => "PHP settings",
// "PHP variable" => "PHP variable",
// "Risk Factor" => "Risk Factor",
// "Explanation" => "Explanation",
// "TikiWiki settings" => "TikiWiki settings",
// "Tiki variable" => "Tiki variable",
// "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors" => "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors",
// "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)" => "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)",
// "Security checks" => "Security checks",
// "Check all tiki files" => "Check all tiki files",
// "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini" => "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini",
// "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database" => "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database",
// "File checks" => "File checks",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments" => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments",
// "See end of table for detailed explanations" => "See end of table for detailed explanations",
// "owner" => "owner",
// "special" => "special",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "r" => "r",
// "w" => "w",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results" => "What to do with these check results",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"" => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content" => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information" => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes" => "Inodes that are not files or directories are not part of tiki. Review these Inodes",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod" => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod",
// "Admin Shoutbox Words" => "Admin Shoutbox Words",
// "Add Banned Word" => "Add Banned Word",
// "Are you sure you want to delete this word" => "Are you sure you want to delete this word",
// "The structure" => "The structure",
// "has just been created" => "has just been created",
// "You will remove structure" => "You will remove structure",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict",
// "The following pages have automatically been categorized with the same categories as the structure" => "The following pages have automatically been categorized with the same categories as the structure",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent",
// "Edit structure" => "Edit structure",
// "View structure" => "View structure",
// "PDF" => "PDF",
// "Xml Zip" => "Xml Zip",
// "Add a New Question" => "Add a New Question",
// "This survey stats" => "This survey stats",
// "Edit Survey Question" => "Edit Survey Question",
// "Add a New Question to this survey" => "Add a New Question to this survey",
// "Multiple choices of thumbnails from a file gallery" => "Multiple choices of thumbnails from a file gallery",
// "Wiki textarea" => "Wiki textarea",
// "Answer is mandatory" => "Answer is mandatory",
// "Number of required answers (for multiple choices)" => "Number of required answers (for multiple choices)",
// "Min" => "Min",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value" => "For a rate, you can give the maximum value",
// "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4" => "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4",
// "Create New Survey" => "Create New Survey",
// "Tiki Cache/System Admin" => "Tiki Cache/System Admin",
// "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)" => "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)",
// "Exterminator of cached content" => "Exterminator of cached content",
// "Directory to exterminate" => "Directory to exterminate",
// "Clear all Tiki caches" => "Clear all Tiki caches",
// "Empty" => "Empty",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save" => "Directories to save",
// "Full Path to the Zip File" => "Full Path to the Zip File",
// "Generate a zip of those directories" => "Generate a zip of those directories",
// "A zip has been written to {\$zipPath}" => "A zip has been written to {\$zipPath}",
// "Directory is not writeable" => "Directory is not writeable",
// "Templates compiler" => "Templates compiler",
// "Compile" => "Compile",
// "Advanced feature" => "Advanced feature",
// "Fix UTF-8 Errors in Tables" => "Fix UTF-8 Errors in Tables",
// "Warning: Make a backup of your Database before using this function" => "Warning: Make a backup of your Database before using this function",
// "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini" => "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini",
// "This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "This function converts ISO-8859-1 encoded strings in your tables to UTF-8",
// "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1",
// "UTF-8 Errors fixed" => "UTF-8 Errors fixed",
// "Investigate" => "Investigate",
// "Fix it" => "Fix it",
// "Inactive - Click to Activate" => "Inactive - Click to Activate",
// "Active - Click to Deactivate" => "Active - Click to Deactivate",
// "Remove with articles" => "Remove with articles",
// "New tracker field" => "New tracker field",
// "Select list items that will be displayed" => "Select list items that will be displayed",
// "Multilingual content" => "Multilingual content",
// "Column is searchable" => "Column is searchable",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "Field is hidden" => "Field is hidden",
// "not hidden" => "not hidden",
// "visible to admin only" => "visible to admin only",
// "editable by admin only" => "editable by admin only",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by" => "Visible by",
// "Editable by" => "Editable by",
// "Field is mandatory" => "Field is mandatory",
// "Description text is wiki-parsed" => "Description text is wiki-parsed",
// "Error message" => "Error message",
// "Searchable" => "Searchable",
// "Hidden" => "Hidden",
// "Mandatory" => "Mandatory",
// "Import/Export Trackers Fields" => "Import/Export Trackers Fields",
// "Export fieldId also" => "Export fieldId also",
// "Check the box to re-import in this tracker and change the fields" => "Check the box to re-import in this tracker and change the fields",
// "Uncheck the box to import in another database" => "Uncheck the box to import in another database",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "Edit Tracker" => "Edit Tracker",
// "Import/Export" => "Import/Export",
// "Create Tracker" => "Create Tracker",
// "Duplicate Tracker" => "Duplicate Tracker",
// "with" => "with",
// "Create/Edit Tracker" => "Create/Edit Tracker",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Create a group for each item" => "Create a group for each item",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL",
// "Show status" => "Show status",
// "Default status displayed in list mode" => "Default status displayed in list mode",
// "Show status to tracker admin only" => "Show status to tracker admin only",
// "Send copies of all activity in this tracker to this e-mail address" => "Send copies of all activity in this tracker to this e-mail address",
// "Use simplified e-mail format" => "Use simplified e-mail format",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "New items are created with status" => "New items are created with status",
// "Authoritative status for modified items" => "Authoritative status for modified items",
// "No change" => "No change",
// "Item creator can modify his items" => "Item creator can modify his items",
// "The tracker needs a user field with the option 1" => "The tracker needs a user field with the option 1",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Member of the default group of creator can modify items" => "Member of the default group of creator can modify items",
// "The tracker needs a group field with the option 1" => "The tracker needs a group field with the option 1",
// "Format if not the default short one" => "Format if not the default short one",
// "Show creation date when viewing tracker item" => "Show creation date when viewing tracker item",
// "Show lastModif date when viewing tracker item" => "Show lastModif date when viewing tracker item",
// "What field is used for default sort" => "What field is used for default sort",
// "ItemId" => "ItemId",
// "What is default sort order in list" => "What is default sort order in list",
// "Tracker items allow ratings" => "Tracker items allow ratings",
// "with values" => "with values",
// "and display rating results in listing" => "and display rating results in listing",
// "and display comments in listing" => "and display comments in listing",
// "and display last comment user/date" => "and display last comment user/date",
// "and display attachments in listing" => "and display attachments in listing",
// "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)",
// "Filetype" => "Filetype",
// "LongDesc" => "LongDesc",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "After" => "After",
// "Before" => "Before",
// "Do not show empty fields in item view" => "Do not show empty fields in item view",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items",
// "Group of users alerted when tracker is modified" => "Group of users alerted when tracker is modified",
// "Import/export trackers" => "Import/export trackers",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "Edit group" => "Edit group",
// "Members" => "Members",
// "Add a New Group" => "Add a New Group",
// "User Choice" => "User Choice",
// "Only directly included" => "Only directly included",
// "will have all the permissions of the included groups" => "will have all the permissions of the included groups",
// "Group Homepage" => "Group Homepage",
// "Use wiki page name or full URL" => "Use wiki page name or full URL",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)" => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a group tracker .." => "choose a group tracker ..",
// "choose a field .." => "choose a field ..",
// "Users Information Tracker" => "Users Information Tracker",
// "choose a users tracker .." => "choose a users tracker ..",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Group tracker item not found" => "Group tracker item not found",
// "Create Item" => "Create Item",
// "Choose a field .." => "Choose a field ..",
// "Members List" => "Members List",
// "Remove from Group" => "Remove from Group",
// "users in group" => "users in group",
// "Add to group" => "Add to group",
// "Download CSV export" => "Download CSV export",
// "Assign users to group" => "Assign users to group",
// "Each user in the file must already exist" => "Each user in the file must already exist",
// "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>" => "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>",
// "CSV File" => "CSV File",
// "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login" => "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login",
// "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login" => "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login",
// "Updated users" => "Updated users",
// "Edit user" => "Edit user",
// "More Criteria" => "More Criteria",
// "Group (direct)" => "Group (direct)",
// "Edit Account Settings" => "Edit Account Settings",
// "ago" => "ago",
// "Need to validate email" => "Need to validate email",
// "Assign to group" => "Assign to group",
// "Edit Included Group" => "Edit Included Group",
// "Edit Group" => "Edit Group",
// "Change user preferences" => "Change user preferences",
// "Validate user" => "Validate user",
// "Remove Users and their Userpages" => "Remove Users and their Userpages",
// "Manage Group Assignments" => "Manage Group Assignments",
// "Set Default Groups" => "Set Default Groups",
// "Send a wiki page by Email" => "Send a wiki page by Email",
// "Assign selected to" => "Assign selected to",
// "Remove selected from" => "Remove selected from",
// "the following groups" => "the following groups",
// "Tip: Hold down CTRL to select multiple" => "Tip: Hold down CTRL to select multiple",
// "Set the default group of the selected users to" => "Set the default group of the selected users to",
// "Template wiki page" => "Template wiki page",
// "Assign user to Groups" => "Assign user to Groups",
// "Use the email as username" => "Use the email as username",
// "Lowercase only" => "Lowercase only",
// "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)" => "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)",
// "Warning: it will mess with slave intertiki sites that use this one as master" => "Warning: it will mess with slave intertiki sites that use this one as master",
// "No password is required" => "No password is required",
// "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth" => "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth",
// "Repeat Password" => "Repeat Password",
// "User must change password at first login" => "User must change password at first login",
// "Send an email to the user in order to allow him to validate his account" => "Send an email to the user in order to allow him to validate his account",
// "Last Login" => "Last Login",
// "User tracker item : {\$usersitemid}" => "User tracker item : {\$usersitemid}",
// "You do not have permission to edit this user" => "You do not have permission to edit this user",
// "Overwrite but keep the previous login if the login exists in another case" => "Overwrite but keep the previous login if the login exists in another case",
// "Don't overwrite" => "Don't overwrite",
// "Overwrite groups" => "Overwrite groups",
// "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>" => "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>",
// "Loading.." => "Loading..",
// "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences" => "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "New attachments" => "New attachments",
// "Old attachments" => "Old attachments",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Source" => "Source",
// "Show Help" => "Show Help",
// "Article type" => "Article type",
// "Shows up in the drop down list of article types" => "Shows up in the drop down list of article types",
// "Allow ratings by the author" => "Allow ratings by the author",
// "non-admins can view before the publish date" => "non-admins can view before the publish date",
// "non-admins can view after the expire date" => "non-admins can view after the expire date",
// "No article body, heading only" => "No article body, heading only",
// "Allow comments for this type" => "Allow comments for this type",
// "Allow comments to include a rating value" => "Allow comments to include a rating value",
// "Show topic or own image" => "Show topic or own image",
// "Show author's avatar" => "Show author's avatar",
// "Show author name" => "Show author name",
// "Show the number of times the article was read" => "Show the number of times the article was read",
// "Show the size of the article" => "Show the size of the article",
// "Show topline" => "Show topline",
// "Show a small title over the title" => "Show a small title over the title",
// "Show subtitle" => "Show subtitle",
// "Show the subtitle" => "Show the subtitle",
// "Show source" => "Show source",
// "Show link to source after article body" => "Show link to source after article body",
// "Show Image Caption" => "Show Image Caption",
// "Show a legend under the image" => "Show a legend under the image",
// "Show Language" => "Show Language",
// "Show the language" => "Show the language",
// "The person who submits an article of this type can edit it" => "The person who submits an article of this type can edit it",
// "Actions on this article type" => "Actions on this article type",
// "Show lang" => "Show lang",
// "Review" => "Review",
// "Classified" => "Classified",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Level configuration" => "Level configuration",
// "Assign User {\$assign_user} to Groups" => "Assign User {\$assign_user} to Groups",
// "Assign Perms to this Group" => "Assign Perms to this Group",
// "Assign User to Group" => "Assign User to Group",
// "Directory batch upload" => "Directory batch upload",
// "available images" => "available images",
// "Remove File Extension from Image Name" => "Remove File Extension from Image Name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "Convert the last sub directory to a sub gallery" => "Convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Select a Gallery" => "Select a Gallery",
// "Browse File Gallery" => "Browse File Gallery",
// "Please do not use this feature to upload data into the database" => "Please do not use this feature to upload data into the database",
// "available files" => "available files",
// "Select a File Gallery" => "Select a File Gallery",
// "Process files" => "Process files",
// "Use Wysiwyg Editor" => "Use Wysiwyg Editor",
// "Use Normal Editor" => "Use Normal Editor",
// "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. ",
// "Mark entry as private" => "Mark entry as private",
// "Report to Webmaster" => "Report to Webmaster",
// "Powered by" => "Powered by",
// "The TikiWiki Community" => "The TikiWiki Community",
// "TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
// "database queries used in " => "database queries used in ",
// "Last update from SVN" => "Last update from SVN",
// "Watch Only This Category" => "Watch Only This Category",
// "Watch This Category and Their Descendants" => "Watch This Category and Their Descendants",
// "Stop Watching Only This Category" => "Stop Watching Only This Category",
// "Stop Watching This Category and Their Descendants" => "Stop Watching This Category and Their Descendants",
// "Admin Category" => "Admin Category",
// "Admin the Category System" => "Admin the Category System",
// "Browse in" => "Browse in",
// "Trackers Items" => "Trackers Items",
// "Sheets" => "Sheets",
// "in the current category - and its subcategories: " => "in the current category - and its subcategories: ",
// "Hide subcategories objects" => "Hide subcategories objects",
// "Show subcategories objects" => "Show subcategories objects",
// "Upper level" => "Upper level",
// "Browse related tags" => "Browse related tags",
// "Network of Tags related to" => "Network of Tags related to",
// "With all selected tags" => "With all selected tags",
// "With one selected tag" => "With one selected tag",
// "With last selected tag" => "With last selected tag",
// "More Popular Tags" => "More Popular Tags",
// "Alphabetically" => "Alphabetically",
// "By Size" => "By Size",
// "Cloud" => "Cloud",
// "\$feature_label" => "\$feature_label",
// "results found" => "results found",
// "List Galleries" => "List Galleries",
// "Directory Batch" => "Directory Batch",
// "All Images" => "All Images",
// "Monitor this Gallery" => "Monitor this Gallery",
// "Stop Monitoring this Gallery" => "Stop Monitoring this Gallery",
// "subgallery" => "subgallery",
// "Subgallery" => "Subgallery",
// "Hit" => "Hit",
// "Details" => "Details",
// "You can view this gallery's configured image (first, random, etc.) in your browser using" => "You can view this gallery's configured image (first, random, etc.) in your browser using",
// "You can include the gallery's image in an HTML page using one of these lines" => "You can include the gallery's image in an HTML page using one of these lines",
// "You can include the image in a tiki page using one of these lines" => "You can include the image in a tiki page using one of these lines",
// "Slideshow Forward" => "Slideshow Forward",
// "Cyclic" => "Cyclic",
// "Direction" => "Direction",
// "Click to zoom" => "Click to zoom",
// "Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/decimal degrees)",
// "Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/decimal degrees)",
// "You can include the image in an HTML page using one of these lines" => "You can include the image in an HTML page using one of these lines",
// "Admin Calendar" => "Admin Calendar",
// "Export Calendars" => "Export Calendars",
// "Click to export calendars" => "Click to export calendars",
// "Visible Calendars" => "Visible Calendars",
// "Click to select visible calendars" => "Click to select visible calendars",
// "Export calendars" => "Export calendars",
// "advanced parameters" => "advanced parameters",
// "Edit event" => "Edit event",
// "Delete event" => "Delete event",
// "View event" => "View event",
// "All-Day" => "All-Day",
// "Website" => "Website",
// "View this Week" => "View this Week",
// "Change Focus" => "Change Focus",
// "View this Day" => "View this Day",
// "o" => "o",
// "Calendar Item" => "Calendar Item",
// "New event" => "New event",
// "Recurrence" => "Recurrence",
// "This event depends on a recurrence rule" => "This event depends on a recurrence rule",
// "This event is not recurrent" => "This event is not recurrent",
// "On a weekly basis" => "On a weekly basis",
// "Each" => "Each",
// "of the week" => "of the week",
// "On a monthly basis" => "On a monthly basis",
// "of the month" => "of the month",
// "On a yearly basis" => "On a yearly basis",
// "There's no such date as" => "There's no such date as",
// "Starting on" => "Starting on",
// "ending by" => "ending by",
// "ending after" => "ending after",
// "events" => "events",
// "Start period" => "Start period",
// "End after" => "End after",
// "occurrences" => "occurrences",
// "End before" => "End before",
// "Event is repeated" => "Event is repeated",
// "every" => "every",
// "of every month" => "of every month",
// "on each" => "on each",
// "Date and time of end" => "Date and time of end",
// "Events cannot end before they start" => "Events cannot end before they start",
// "or new" => "or new",
// "Choose users to alert" => "Choose users to alert",
// "chair" => "chair",
// "default role" => "default role",
// "required participant" => "required participant",
// "optional participant" => "optional participant",
// "non participant" => "non participant",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"" => "If no role is provided, default role will be \"Chair participant\"",
// "Update this event only" => "Update this event only",
// "Update every unchanged events of this recurrence rule" => "Update every unchanged events of this recurrence rule",
// "Update every events of this recurrence rule" => "Update every events of this recurrence rule",
// "Delete Recurrent events" => "Delete Recurrent events",
// "Calendar import" => "Calendar import",
// "Calendar has been updated" => "Calendar has been updated",
// "%m/%d" => "%m/%d",
// "Avanced parameters for iCal export" => "Avanced parameters for iCal export",
// "Calendars to be exported" => "Calendars to be exported",
// "Assign permissions to category" => "Assign permissions to category",
// "Categories checking is not done in the database search" => "Categories checking is not done in the database search",
// "Current permissions for this category" => "Current permissions for this category",
// "Remove from this Category Only" => "Remove from this Category Only",
// "Remove from this Category &amp; all its Children" => "Remove from this Category &amp; all its Children",
// "this category &amp; all its children" => "this category &amp; all its children",
// "this category only" => "this category only",
// "Assigning permissions for <b>all children</b> is recommended for best performance" => "Assigning permissions for <b>all children</b> is recommended for best performance",
// "Your account has been validated" => "Your account has been validated",
// "You have to choose a password to use this account" => "You have to choose a password to use this account",
// "Click here to send us an email" => "Click here to send us an email",
// "Send another message" => "Send another message",
// "Group View" => "Group View",
// "Publish this contact to groups" => "Publish this contact to groups",
// "You cannot add sites until Directory Categories are setup" => "You cannot add sites until Directory Categories are setup",
// "Please contact the Site Administrator" => "Please contact the Site Administrator",
// "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>" => "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>",
// "The following site was added, but may require validation by the admin before appearing on the lists" => "The following site was added, but may require validation by the admin before appearing on the lists",
// "Edit a site" => "Edit a site",
// "Add a site" => "Add a site",
// "Directory Categories" => "Directory Categories",
// "Use Ctrl+Click to select multiple directory categories" => "Use Ctrl+Click to select multiple directory categories",
// "Parent directory category" => "Parent directory category",
// "Allow sites in this directory category" => "Allow sites in this directory category",
// "Show number of sites in this directory category" => "Show number of sites in this directory category",
// "Directory Subcategories" => "Directory Subcategories",
// "Admin related directory categories" => "Admin related directory categories",
// "Directory Category" => "Directory Category",
// "Use Ctrl+Click to select multiple categories" => "Use Ctrl+Click to select multiple categories",
// "Perform action with selected" => "Perform action with selected",
// "Add a Directory Category" => "Add a Directory Category",
// "in current directory category" => "in current directory category",
// "Related directory categories" => "Related directory categories",
// "Total directory categories" => "Total directory categories",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "Topline" => "Topline",
// "Subtitle" => "Subtitle",
// "Image caption" => "Image caption",
// "Emails to be notified (separated with commas)" => "Emails to be notified (separated with commas)",
// "-1 for unlimited" => "-1 for unlimited",
// "Max clicks" => "Max clicks",
// "Or, create a new zone" => "Or, create a new zone",
// "Use Flash" => "Use Flash",
// "Movie Size" => "Movie Size",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "Create Blog" => "Create Blog",
// "A category is mandatory" => "A category is mandatory",
// "Show user avatar" => "Show user avatar",
// "The file will be saved in" => "The file will be saved in",
// "For more information, please see <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki Page Editor" => "For more information, please see <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki Page Editor",
// "More help on editing wiki pages" => "More help on editing wiki pages",
// "Wiki Syntax" => "Wiki Syntax",
// "The syntax system used for creating pages in TikiWiki" => "The syntax system used for creating pages in TikiWiki",
// "Bold text" => "Bold text",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Underlined text" => "Underlined text",
// "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background" => "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background",
// "Deleted text" => "Deleted text",
// "2 dashes" => "2 dashes",
// "Headings" => "Headings",
// "Show/Hide" => "Show/Hide",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "Autonumbered Headings" => "Autonumbered Headings",
// "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Horizontal rule" => "Horizontal rule",
// "Text box" => "Text box",
// "Centered text" => "Centered text",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)" => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)",
// "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))",
// "Square Brackets" => "Square Brackets",
// "Use [[foo] to show [foo]" => "Use [[foo] to show [foo]",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus (useful in list to continue at the same level)" => "Creates an indentation for each plus (useful in list to continue at the same level)",
// "row" => "row",
// "col" => "col",
// "Monospace font" => "Monospace font",
// "Code sample" => "Code sample",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "to separate pages" => "to separate pages",
// "Prevents wiki parsing of the enclosed data" => "Prevents wiki parsing of the enclosed data",
// "Preformated sections" => "Preformated sections",
// "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text" => "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text",
// "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar" => "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar",
// "Block Preformatting" => "Block Preformatting",
// "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that" => "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew" => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew",
// "Special characters" => "Special characters",
// "hard space" => "hard space",
// "numeric between ~ for html numeric characters entity" => "numeric between ~ for html numeric characters entity",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines" => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line" => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line",
// "Wiki plugins extend the function of wiki syntax with more specialized commands" => "Wiki plugins extend the function of wiki syntax with more specialized commands",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt",
// "text, bold" => "text, bold",
// "text, italic" => "text, italic",
// "text, underline" => "text, underline",
// "table" => "table",
// "table new" => "table new",
// "wiki link'" => "wiki link'",
// "heading1" => "heading1",
// "title bar" => "title bar",
// "box" => "box",
// "rss feed" => "rss feed",
// "dynamic content" => "dynamic content",
// "tagline" => "tagline",
// "horizontal rule" => "horizontal rule",
// "center text" => "center text",
// "colored text" => "colored text",
// "dynamic variable" => "dynamic variable",
// "New wms Metadata" => "New wms Metadata",
// "New Class" => "New Class",
// "New Projection" => "New Projection",
// "New Query" => "New Query",
// "New Scalebar" => "New Scalebar",
// "New Layer" => "New Layer",
// "New Label" => "New Label",
// "New Reference" => "New Reference",
// "New Legend" => "New Legend",
// "New Web" => "New Web",
// "New Outputformat" => "New Outputformat",
// "New Mapfile" => "New Mapfile",
// "Add image from File Gallery" => "Add image from File Gallery",
// "quote" => "quote",
// "flash" => "flash",
// "{\$label}" => "{\$label}",
// "Add Image from File Gallery" => "Add Image from File Gallery",
// "Leave Fullscreen Edit" => "Leave Fullscreen Edit",
// "Fullscreen Edit" => "Fullscreen Edit",
// "Browse Images" => "Browse Images",
// "Upload from disk to change the image" => "Upload from disk to change the image",
// "Save and Go Next" => "Save and Go Next",
// "Im-Export Languages" => "Im-Export Languages",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Immediate feedback" => "Immediate feedback",
// "Show correct answers" => "Show correct answers",
// "Shuffle questions" => "Shuffle questions",
// "Shuffle answers" => "Shuffle answers",
// "Passing Percentage" => "Passing Percentage",
// "%" => "%",
// "Question Type" => "Question Type",
// "Import questions from text" => "Import questions from text",
// "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character" => "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character",
// "Input" => "Input",
// "Edit quiz results" => "Edit quiz results",
// "and its subpages from the structure" => "and its subpages from the structure",
// "The page already exists. The page that has been added to the structure is the existing one" => "The page already exists. The page that has been added to the structure is the existing one",
// "The following pages added have automatically been categorized with the same categories as the structure" => "The following pages added have automatically been categorized with the same categories as the structure",
// "Monitor the Sub-Structure" => "Monitor the Sub-Structure",
// "Stop Monitoring the Sub-Structure" => "Stop Monitoring the Sub-Structure",
// "Move in this structure" => "Move in this structure",
// "Move to another structure" => "Move to another structure",
// "at the beginning" => "at the beginning",
// "at the end" => "at the end",
// "Categorize all pages in structure together" => "Categorize all pages in structure together",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "<b>*</b>=optional" => "<b>*</b>=optional",
// "<b>Topline</b>=small line above Title" => "<b>Topline</b>=small line above Title",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "<b>Source</b>=URL to article source" => "<b>Source</b>=URL to article source",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering" => "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering",
// "This would cause you problems (e.g. menus can stop collapsing/expanding)" => "This would cause you problems (e.g. menus can stop collapsing/expanding)",
// "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)" => "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)",
// "Maybe You just want to modify the top of your Tiki site" => "Maybe You just want to modify the top of your Tiki site",
// "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface" => "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface",
// "Save Only in the Theme" => "Save Only in the Theme",
// "Delete the copy in the theme" => "Delete the copy in the theme",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "View Page" => "View Page",
// "View Article" => "View Article",
// "You must specify the object language" => "You must specify the object language",
// "The object doesn't exist" => "The object doesn't exist",
// "The object doesn't have a language" => "The object doesn't have a language",
// "The object has already a translation for this language" => "The object has already a translation for this language",
// "The object is already in the set of translations" => "The object is already in the set of translations",
// "Language of newly translated page" => "Language of newly translated page",
// "Unspecified" => "Unspecified",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"" => "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "detach" => "detach",
// "Change language for this page" => "Change language for this page",
// "Select from available options.." => "Select from available options..",
// "Change Language" => "Change Language",
// "No language is assigned to this page" => "No language is assigned to this page",
// "Please select a language before performing translation" => "Please select a language before performing translation",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Your edit session will expire in" => "Your edit session will expire in",
// "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits" => "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits",
// "Update '{\$page}'" => "Update '{\$page}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval" => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval",
// "This is a new staging page that has not been approved before" => "This is a new staging page that has not been approved before",
// "The current staging copy may contain changes that have yet to be approved" => "The current staging copy may contain changes that have yet to be approved",
// "View changes since last approval" => "View changes since last approval",
// "You are editing the approved copy of this page" => "You are editing the approved copy of this page",
// "There are currently changes in the staging copy that have yet to be approved" => "There are currently changes in the staging copy that have yet to be approved",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead" => "instead",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Perhaps you are looking for" => "Perhaps you are looking for",
// "Change the style used to display differences to be translated" => "Change the style used to display differences to be translated",
// "Change diff styles" => "Change diff styles",
// "This edit session will expire in {\$edittimeout} minutes" => "This edit session will expire in {\$edittimeout} minutes",
// "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer" => "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer",
// "Switch to WYSIWYG editor" => "Switch to WYSIWYG editor",
// "Switch to normal (wiki) editor" => "Switch to normal (wiki) editor",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Use rating" => "Use rating",
// "Disable" => "Disable",
// "There is no available poll template" => "There is no available poll template",
// "You should ask an admin to create them" => "You should ask an admin to create them",
// "or use" => "or use",
// "an existing poll" => "an existing poll",
// "AutoSave" => "AutoSave",
// "If you want the saved version instead of the autosaved one" => "If you want the saved version instead of the autosaved one",
// "Regex search " => "Regex search ",
// "Replace to" => "Replace to",
// "Case Insensitivity" => "Case Insensitivity",
// "My Footnotes" => "My Footnotes",
// "Translation request" => "Translation request",
// "Send urgent translation request" => "Send urgent translation request",
// "Edit Comment" => "Edit Comment",
// "Monitor this page" => "Monitor this page",
// "Add another image" => "Add another image",
// "Lock this page" => "Lock this page",
// "List Sheets" => "List Sheets",
// "Graph" => "Graph",
// "Export to file" => "Export to file",
// "Format" => "Format",
// "Autodetect" => "Autodetect",
// "Export Tracker Items" => "Export Tracker Items",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse as Wiki Text" => "Parse as Wiki Text",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "All fields" => "All fields",
// "These fields" => "These fields",
// "Use Ctrl+Click to select multiple fields" => "Use Ctrl+Click to select multiple fields",
// "Dump All Tracker Items" => "Dump All Tracker Items",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "File Archive" => "File Archive",
// "File Galleries tpl" => "File Galleries tpl",
// "Be careful to set the right permissions on the files you link to" => "Be careful to set the right permissions on the files you link to",
// "Create New File Gallery" => "Create New File Gallery",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Import from a Local SQL File" => "Import from a Local SQL File",
// "Forum Type" => "Forum Type",
// "DB Prefix" => "DB Prefix",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>" => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred" => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into" => "Which Forum Do You Wish to Import this Into",
// "Message queue for forum" => "Message queue for forum",
// "Back to forum" => "Back to forum",
// "Search by name" => "Search by name",
// "Search in content" => "Search in content",
// "Configure Forum" => "Configure Forum",
// "Reported messages for forum" => "Reported messages for forum",
// "No records to display" => "No records to display",
// "Perfom action with checked" => "Perfom action with checked",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag" => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag",
// "Until then, they cannot be translated" => "Until then, they cannot be translated",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "Pending requests" => "Pending requests",
// "Request Time" => "Request Time",
// "Refuse" => "Refuse",
// "Waiting requests" => "Waiting requests",
// "Cancel friendship request" => "Cancel friendship request",
// "Your friends" => "Your friends",
// "break friendship" => "break friendship",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "Expiration Time" => "Expiration Time",
// "Years" => "Years",
// "Months" => "Months",
// "Minutes" => "Minutes",
// "Process Graph" => "Process Graph",
// "Galaxia Admin Graph" => "Galaxia Admin Graph",
// "Galaxia Admin Graph tpl" => "Galaxia Admin Graph tpl",
// "Edit Tpl" => "Edit Tpl",
// "Process Graph for" => "Process Graph for",
// "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed" => "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed",
// "Ended" => "Ended",
// "Not Defined" => "Not Defined",
// "Not Interactive" => "Not Interactive",
// "Not Ended" => "Not Ended",
// "Executed" => "Executed",
// "erase" => "erase",
// "Enter the name of this instance" => "Enter the name of this instance",
// "The name is not valid. Please, enter the name again" => "The name is not valid. Please, enter the name again",
// "Not ended" => "Not ended",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "My activities" => "My activities",
// "Current Activity" => "Current Activity",
// "Assigned To" => "Assigned To",
// "No activities found" => "No activities found",
// "My instances" => "My instances",
// "No instances found" => "No instances found",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "Not defined" => "Not defined",
// "Geographic" => "Geographic",
// "Fields to show during browsing the gallery" => "Fields to show during browsing the gallery",
// "Creation Date" => "Creation Date",
// "XY-Size" => "XY-Size",
// "Gallery Image" => "Gallery Image",
// "Global default" => "Global default",
// "Bounding box" => "Bounding box",
// "default scale" => "default scale",
// "Original image is default scale" => "Original image is default scale",
// "Add scaled images with bounding box of square size" => "Add scaled images with bounding box of square size",
// "Choose a filter" => "Choose a filter",
// "Make Map" => "Make Map",
// "Google Map Locator" => "Google Map Locator",
// "Save clicked point" => "Save clicked point",
// "Reset view to default" => "Reset view to default",
// "Save current view as default" => "Save current view as default",
// "Center map to saved point" => "Center map to saved point",
// "Reset view to site default" => "Reset view to site default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal Scale" => "Horizontal Scale",
// "Bottom" => "Bottom",
// "Vertical Scale" => "Vertical Scale",
// "Series" => "Series",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "Import From File" => "Import From File",
// "Grab Wiki Tables" => "Grab Wiki Tables",
// "Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
// "Name of the dump file (it has to be in dump/)" => "Name of the dump file (it has to be in dump/)",
// "body" => "body",
// "XML Zip" => "XML Zip",
// "Tiki installer" => "Tiki installer",
// "Welcome" => "Welcome",
// "Welcome to the Tiki installation and upgrade script" => "Welcome to the Tiki installation and upgrade script",
// "Use this script to install a new Tiki database or upgrade your existing database to release" => "Use this script to install a new Tiki database or upgrade your existing database to release",
// "For the latest information about this release, please read the" => "For the latest information about this release, please read the",
// "Release Notes" => "Release Notes",
// "For complete documentation, please visit" => "For complete documentation, please visit",
// "For more information about Tiki, please visit" => "For more information about Tiki, please visit",
// "Select your language" => "Select your language",
// "Read the License" => "Read the License",
// "Tiki is software distributed under the LGPL license" => "Tiki is software distributed under the LGPL license",
// " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>" => " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>",
// "Review the System Requirements" => "Review the System Requirements",
// "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements",
// "This installer will perform some basic checks automatically" => "This installer will perform some basic checks automatically",
// "Memory" => "Memory",
// "Success" => "Success",
// "Tiki has not detected your PHP memory_limit" => "Tiki has not detected your PHP memory_limit",
// "This probably means you have no set limit (all is well)" => "This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution" => "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution",
// "Allocating too little memory will cause Tiki to display blank pages" => "Allocating too little memory will cause Tiki to display blank pages",
// "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver" => "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Mail" => "Mail",
// "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages" => "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages",
// "To test your system configuration, Tiki will attempt to send a test message to you" => "To test your system configuration, Tiki will attempt to send a test message to you",
// "Test email" => "Test email",
// "Email address to send test to" => "Email address to send test to",
// "Copy test mail to " => "Copy test mail to ",
// "Send Test Message" => "Send Test Message",
// "Tiki was able to send a test message to" => "Tiki was able to send a test message to",
// "Tiki was not able to send a test message" => "Tiki was not able to send a test message",
// "Review your mail log for details" => "Review your mail log for details",
// "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)" => "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)",
// "If your host requires SMTP authentication, additional configuration may be necessary" => "If your host requires SMTP authentication, additional configuration may be necessary",
// "Image Processing" => "Image Processing",
// "Tiki detected" => "Tiki detected",
// "Tiki was not able to detect the GD library" => "Tiki was not able to detect the GD library",
// "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support" => "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support",
// "Set the Database Connection" => "Set the Database Connection",
// "Tiki requires an active database connection" => "Tiki requires an active database connection",
// "You must create the database and user <em>before</em> completing this page" => "You must create the database and user <em>before</em> completing this page",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "This is normal for a new installation" => "This is normal for a new installation",
// "Tiki found an existing database connection in your local.php file" => "Tiki found an existing database connection in your local.php file",
// "Use Existing Connection" => "Use Existing Connection",
// "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>" => "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>",
// "Database information" => "Database information",
// "Enter your database connection information" => "Enter your database connection information",
// "Database type" => "Database type",
// "Select the type of database to use with Tiki" => "Select the type of database to use with Tiki",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension" => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension",
// "Host name" => "Host name",
// "Enter the host name or IP for your database" => "Enter the host name or IP for your database",
// "Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "For SQLite, enter the path and filename to your database file" => "For SQLite, enter the path and filename to your database file",
// "Database name" => "Database name",
// "Enter the name of the database that Tiki will use" => "Enter the name of the database that Tiki will use",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names",
// "For Oracle" => "For Oracle",
// "Enter your TNS Name here and leave Host empty" => "Enter your TNS Name here and leave Host empty",
// "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field" => "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field",
// "Database user" => "Database user",
// "Enter a database user with administrator permission for the Database" => "Enter a database user with administrator permission for the Database",
// "User name" => "User name",
// "Install &amp; Update Profile" => "Install &amp; Update Profile",
// "Install Profile" => "Install Profile",
// "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page" => "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page",
// "Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database" => "Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database",
// "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>" => "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>",
// "Select the installation profile to use. This profile will populate the database" => "Select the installation profile to use. This profile will populate the database",
// "Profiles can be used to pre-configure your site with specific features and settings" => "Profiles can be used to pre-configure your site with specific features and settings",
// "Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information" => "Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information",
// "Install" => "Install",
// "Reinstall the database" => "Reinstall the database",
// "This will destroy your current database" => "This will destroy your current database",
// "Create a new database (clean install) with profile" => "Create a new database (clean install) with profile",
// "Bare-bones default install" => "Bare-bones default install",
// "Personal Blog and Profile" => "Personal Blog and Profile",
// "Small Organization Web Presence" => "Small Organization Web Presence",
// "Company Intranet" => "Company Intranet",
// "Collaborative community" => "Collaborative community",
// "See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles" => "See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles",
// "The installer could not connect to the Profiles repository" => "The installer could not connect to the Profiles repository",
// "The default installation profile will be used" => "The default installation profile will be used",
// "Upgrade" => "Upgrade",
// "Automatically upgrade your existing database to v" => "Automatically upgrade your existing database to v",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Review the Upgrade" => "Review the Upgrade",
// "Review the Installation" => "Review the Installation",
// "Upgrade complete" => "Upgrade complete",
// "Installation complete" => "Installation complete",
// "Your database has been configured and Tiki is ready to run" => "Your database has been configured and Tiki is ready to run",
// "If this is your first install, your admin password is <strong>admin</strong>" => "If this is your first install, your admin password is <strong>admin</strong>",
// "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application" => "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application",
// "Upgrade operations executed successfully" => "Upgrade operations executed successfully",
// "Installation operations executed successfully" => "Installation operations executed successfully",
// "SQL queries" => "SQL queries",
// "Database was left unchanged" => "Database was left unchanged",
// "Failed" => "Failed",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages" => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages",
// ".htaccess File" => ".htaccess File",
// "We recommend enabling the <strong>.htaccess</strong> file for your Tiki" => "We recommend enabling the <strong>.htaccess</strong> file for your Tiki",
// "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security" => "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security",
// "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>" => "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>",
// "Complete these fields to configure common, general settings for your site" => "Complete these fields to configure common, general settings for your site",
// "The information you enter here can be changed later" => "The information you enter here can be changed later",
// "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings" => "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings",
// "This will appear in the browser title bar" => "This will appear in the browser title bar",
// "Email sent by your site will use this address" => "Email sent by your site will use this address",
// "Secure Login" => "Secure Login",
// "HTTPS login" => "HTTPS login",
// "Administrator" => "Administrator",
// "Admin email" => "Admin email",
// "This is the email address for your administrator account" => "This is the email address for your administrator account",
// "Enter Your Tiki" => "Enter Your Tiki",
// "The installation is complete" => "The installation is complete",
// "Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>" => "Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>",
// "Installation" => "Installation",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu" => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu",
// "Enter Tiki and Lock Installer" => "Enter Tiki and Lock Installer",
// "Recommended" => "Recommended",
// "Enter Tiki Without Locking Installer" => "Enter Tiki Without Locking Installer",
// "MultiTiki Setup" => "MultiTiki Setup",
// "Default Installation" => "Default Installation",
// "DB OK" => "DB OK",
// "No DB" => "No DB",
// "Adding a new host" => "Adding a new host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Are you upgrading an existing Tiki site" => "Are you upgrading an existing Tiki site",
// "Go directly to the <strong>Install/Upgrade</strong> step" => "Go directly to the <strong>Install/Upgrade</strong> step",
// "Install/Upgrade" => "Install/Upgrade",
// "Restart the installer" => "Restart the installer",
// "Database Connection" => "Database Connection",
// "Reset the Database Connection" => "Reset the Database Connection",
// "Configure the General Settings" => "Configure the General Settings",
// "Tiki Icon" => "Tiki Icon",
// "TikiWiki Project Web Site" => "TikiWiki Project Web Site",
// "Support Forums" => "Support Forums",
// "TikiWiki CMS/Groupware Project" => "TikiWiki CMS/Groupware Project",
// "Powered by TikiWiki" => "Powered by TikiWiki",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Go Back" => "Go Back",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "Last 2 days" => "Last 2 days",
// "Last 3 days" => "Last 3 days",
// "Last 5 days" => "Last 5 days",
// "Last week" => "Last week",
// "Last 2 weeks" => "Last 2 weeks",
// "Last month" => "Last month",
// "v" => "v",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone" => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone",
// "Max Clicks" => "Max Clicks",
// "The cache is used by" => "The cache is used by",
// "Approval" => "Approval",
// "Rejected" => "Rejected",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block" => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block" => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "Future vers" => "Future vers",
// "SlideShow" => "SlideShow",
// "Keep gallery window open" => "Keep gallery window open",
// "Your comment" => "Your comment",
// "optional" => "optional",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "/" => "/",
// "Flash binary (.swf or .dcr)" => "Flash binary (.swf or .dcr)",
// "Take Survey" => "Take Survey",
// "users registered" => "users registered",
// "Distance (km)" => "Distance (km)",
// "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on" => "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on",
// "Last modification" => "Last modification",
// "Page creator" => "Page creator",
// "Status of the page" => "Status of the page",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl" => "Backl",
// "Page size" => "Page size",
// " {if \$find ne ''}and {/if}starting with" => " {if \$find ne ''}and {/if}starting with",
// "offline" => "offline",
// "Back to admin" => "Back to admin",
// "operator" => "operator",
// "For security purposes we must periodically validate your email address to allow continued access to this site" => "For security purposes we must periodically validate your email address to allow continued access to this site",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site" => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site",
// "Thank you" => "Thank you",
// "This is an experimental feature" => "This is an experimental feature",
// "Requires" => "Requires",
// "Not Enabled" => "Not Enabled",
// "Mail-in feature" => "Mail-in feature",
// "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/" => "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/",
// "Tikiwiki Mods" => "Tikiwiki Mods",
// "Mods Configuration" => "Mods Configuration",
// "Update remote index" => "Update remote index",
// "Rebuild local list" => "Rebuild local list",
// "Republish all" => "Republish all",
// "Publish all" => "Publish all",
// "Unpublish all" => "Unpublish all",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>" => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>",
// "Tiki \"mods\" are undergoing refurbishment" => "Tiki \"mods\" are undergoing refurbishment",
// "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification" => "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification",
// "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more" => "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more",
// "Attention" => "Attention",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)" => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")" => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")",
// "all types" => "all types",
// "for version" => "for version",
// "all versions" => "all versions",
// "or later" => "or later",
// "No mods found" => "No mods found",
// "Display only this type" => "Display only this type",
// "Unpublish" => "Unpublish",
// "Republish" => "Republish",
// "licence" => "licence",
// "Tikiwiki Mods Configuration" => "Tikiwiki Mods Configuration",
// "Mods Install/uninstall" => "Mods Install/uninstall",
// "Enable Mods providing" => "Enable Mods providing",
// "Mods local directory" => "Mods local directory",
// "Mods remote server" => "Mods remote server",
// "Package Config" => "Package Config",
// "y" => "y",
// "My Articles" => "My Articles",
// "User Articles" => "User Articles",
// "My User Items" => "My User Items",
// "User Items" => "User Items",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "To display the objects you participate" => "To display the objects you participate",
// "My Infos" => "My Infos",
// "Contacts Preferences" => "Contacts Preferences",
// "My Contacts" => "My Contacts",
// "My Wiki Pages" => "My Wiki Pages",
// "My Galleries" => "My Galleries",
// "My Tracker Items" => "My Tracker Items",
// "My Messages" => "My Messages",
// "My Tasks" => "My Tasks",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Delete errors" => "Delete errors",
// "Not sent" => "Not sent",
// "Removal of your email address failed" => "Removal of your email address failed",
// "Subscription failed" => "Subscription failed",
// "Available Newsletters" => "Available Newsletters",
// "News from" => "News from",
// "Read the news" => "Read the news",
// "Add a news server" => "Add a news server",
// "Edit news server" => "Edit news server",
// "Object Watches" => "Object Watches",
// "Watching Groups" => "Watching Groups",
// "View Permissions" => "View Permissions",
// "Edit Permissions" => "Edit Permissions",
// "These permissions override any global permissions or category permissions affecting this object" => "These permissions override any global permissions or category permissions affecting this object",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>" => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>",
// "No individual permissions, category permissions apply" => "No individual permissions, category permissions apply",
// "Current permissions for categories that this object belongs to" => "Current permissions for categories that this object belongs to",
// "These permissions do not apply. Special permissions apply" => "These permissions do not apply. Special permissions apply",
// "No category permissions; global permissions apply" => "No category permissions; global permissions apply",
// "No category permissions; special permissions apply" => "No category permissions; special permissions apply",
// "and also to all pages of the sub-structure" => "and also to all pages of the sub-structure",
// "Perms Help" => "Perms Help",
// "Your OpenID identity is valid" => "Your OpenID identity is valid",
// "However, no account is associated to the OpenID identifier" => "However, no account is associated to the OpenID identifier",
// "Create a new Tikiwiki account from OpenID" => "Create a new Tikiwiki account from OpenID",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts" => "Your identity gives you access to multiple user accounts",
// "Select account" => "Select account",
// "Make Structure" => "Make Structure",
// "{\$atts|@count} files attached" => "{\$atts|@count} files attached",
// "Preview of version" => "Preview of version",
// "(current)" => "(current)",
// "Rollback to this version" => "Rollback to this version",
// "Source of version" => "Source of version",
// "s=source" => "s=source",
// "b=rollback" => "b=rollback",
// "Updated from" => "Updated from",
// "Used to update" => "Used to update",
// "Update Translation" => "Update Translation",
// "Hide translation history" => "Hide translation history",
// "Show translation history" => "Show translation history",
// "no avatar" => "no avatar",
// "icons" => "icons",
// "File (only .gif, .jpg and .png images approximately 45px × 45px)" => "File (only .gif, .jpg and .png images approximately 45px × 45px)",
// "Plugin execution was denied" => "Plugin execution was denied",
// "Plugin execution pending approval" => "Plugin execution pending approval",
// "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected" => "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected",
// "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible" => "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible",
// "You are allowed to" => "You are allowed to",
// "View arguments" => "View arguments",
// "Execute the plugin in preview mode (may be dangerous)" => "Execute the plugin in preview mode (may be dangerous)",
// "Approve the plugin for public execution" => "Approve the plugin for public execution",
// "View Details" => "View Details",
// "This plugin does not contain any arguments" => "This plugin does not contain any arguments",
// "This plugin's body is empty" => "This plugin's body is empty",
// "Any" => "Any",
// "Items found" => "Items found",
// "atts" => "atts",
// "List Attachments" => "List Attachments",
// "Sum" => "Sum",
// "Plugin Approval" => "Plugin Approval",
// "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups" => "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups",
// "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins" => "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins",
// "This page lists the plugins that require validation, the first time they are encountered" => "This page lists the plugins that require validation, the first time they are encountered",
// "Each plugin contains a unique <em>signature</em> that is preserved" => "Each plugin contains a unique <em>signature</em> that is preserved",
// "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list" => "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list",
// "The plugin will automatically be added if it is encountered" => "The plugin will automatically be added if it is encountered",
// "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin" => "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin",
// "For security, you should review each plugin to ensure it is safe to approve" => "For security, you should review each plugin to ensure it is safe to approve",
// "Plugin" => "Plugin",
// "Added By" => "Added By",
// "Signature" => "Signature",
// "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "Approve all pending plugins" => "Approve all pending plugins",
// "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins" => "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins",
// "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe" => "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe",
// "No plugins pending approval" => "No plugins pending approval",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Edit Poll" => "Edit Poll",
// "Find the poll" => "Find the poll",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Vote range displayed" => "Vote range displayed",
// "All votes with no span consideration" => "All votes with no span consideration",
// "All votes with span consideration" => "All votes with span consideration",
// "All votes" => "All votes",
// "List Votes" => "List Votes",
// "Note: Remember that this is only a preview, and has not yet been saved" => "Note: Remember that this is only a preview, and has not yet been saved",
// "Permission denied. You do not have permission to read complete articles" => "Permission denied. You do not have permission to read complete articles",
// "Selected Structures" => "Selected Structures",
// "Add Structure" => "Add Structure",
// "No structures" => "No structures",
// "Add Pages" => "Add Pages",
// "No pages" => "No pages",
// "Add Page" => "Add Page",
// "Add Pages from Structures" => "Add Pages from Structures",
// "Add Structure Pages" => "Add Structure Pages",
// "Selected Pages" => "Selected Pages",
// "No pages selected" => "No pages selected",
// "Edit quiz" => "Edit quiz",
// "General Options" => "General Options",
// "Publication Date" => "Publication Date",
// "at " => "at ",
// "Use " => "Use ",
// "randomly selected questions" => "randomly selected questions",
// "Test-time Options" => "Test-time Options",
// "Limit questions displayed per page to " => "Limit questions displayed per page to ",
// "&nbsp question(s)" => "&nbsp question(s)",
// "Impose a time limit of " => "Impose a time limit of ",
// "Allow students to store partial results and return to quiz" => "Allow students to store partial results and return to quiz",
// "Allow students to retake this quiz " => "Allow students to retake this quiz ",
// "Grading and Feedback" => "Grading and Feedback",
// "Grading method " => "Grading method ",
// "Show students their score " => "Show students their score ",
// "Show students the correct answers " => "Show students the correct answers ",
// "Publish statistics " => "Publish statistics ",
// "Extra Options" => "Extra Options",
// "Solicit additional questions from students" => "Solicit additional questions from students",
// "Link quiz to forum named: " => "Link quiz to forum named: ",
// "Prologue" => "Prologue",
// "Epilogue" => "Epilogue",
// "time taken" => "time taken",
// "P/F" => "P/F",
// "Passed" => "Passed",
// "Rank" => "Rank",
// "star" => "star",
// "half star" => "half star",
// "Send a link" => "Send a link",
// "List all articles of this same topic" => "List all articles of this same topic",
// "Edit Received Page" => "Edit Received Page",
// "The highlight pages already exist" => "The highlight pages already exist",
// "Please, change the name if you want the page to be uploaded" => "Please, change the name if you want the page to be uploaded",
// "Received Structures" => "Received Structures",
// "Prefix the checked" => "Prefix the checked",
// "Postfix the checked" => "Postfix the checked",
// "Use your email as login" => "Use your email as login",
// "Minimum {\$prefs.min_username_length} characters long" => "Minimum {\$prefs.min_username_length} characters long",
// "Passcode to register" => "Passcode to register",
// "Not your password" => "Not your password",
// "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}" => "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}",
// "Generate a\tpassword" => "Generate a\tpassword",
// "A valid email is mandatory to register" => "A valid email is mandatory to register",
// "Select your group" => "Select your group",
// "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter" => "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter",
// "You don't have permission to use this feature" => "You don't have permission to use this feature",
// "Please register" => "Please register",
// "Enter your username or email" => "Enter your username or email",
// "Enter your email" => "Enter your email",
// "Request Password Reset" => "Request Password Reset",
// "Last Version" => "Last Version",
// "Back to page" => "Back to page",
// "Replicate" => "Replicate",
// "Slave" => "Slave",
// "Master" => "Master",
// "Operations" => "Operations",
// "Operations Log" => "Operations Log",
// "to version" => "to version",
// "\$name" => "\$name",
// "Faqs" => "Faqs",
// "Blogs Post" => "Blogs Post",
// "Date Search" => "Date Search",
// "All dates" => "All dates",
// "Calendar Items" => "Calendar Items",
// "Please Confirm" => "Please Confirm",
// "octets" => "octets",
// "Apply content template" => "Apply content template",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "Attached Files" => "Attached Files",
// "To add a file, click here" => "To add a file, click here",
// "Save as Draft" => "Save as Draft",
// "Send a structure" => "Send a structure",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "Create a sheet" => "Create a sheet",
// "Edit this sheet" => "Edit this sheet",
// "Create New Sheet" => "Create New Sheet",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
// "Header Rows" => "Header Rows",
// "Footer Rows" => "Footer Rows",
// "Create new Sheet" => "Create new Sheet",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Available Sheets" => "Available Sheets",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page" => "the approved version of this page",
// "Viewing of changes since last approval is possible only after first approval" => "Viewing of changes since last approval is possible only after first approval",
// "Approve changes" => "Approve changes",
// "Latest changes will be synchronized after approval" => "Latest changes will be synchronized after approval",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time" => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time",
// "Content may be out of date" => "Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages",
// "TOC" => "TOC",
// "Child" => "Child",
// "page: %0/%1" => "page: %0/%1",
// "Last edited by" => "Last edited by",
// "based on work by" => "based on work by",
// "Contributors to this page" => "Contributors to this page",
// "Page last modified on %0 by %1" => "Page last modified on %0 by %1",
// "Created by %0" => "Created by %0",
// "Last Modification: %0 by %1" => "Last Modification: %0 by %1",
// "santa" => "santa",
// "You will not see the latest queries" => "You will not see the latest queries",
// "Clean" => "Clean",
// "Params" => "Params",
// "Most viewed objects" => "Most viewed objects",
// "Most viewed objects in the last 7 days" => "Most viewed objects in the last 7 days",
// "Date of first pageview" => "Date of first pageview",
// "Days since first pageview" => "Days since first pageview",
// "Total replies" => "Total replies",
// "Average number of replies per topic" => "Average number of replies per topic",
// "FAQ Stats" => "FAQ Stats",
// "Daily Usage" => "Daily Usage",
// "Tiki Logs" => "Tiki Logs",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "Thank you for your submission" => "Thank you for your submission",
// "Send a link to a friend" => "Send a link to a friend",
// "The link was sent to the following addresses" => "The link was sent to the following addresses",
// "Friend's email" => "Friend's email",
// "Separate multiple email addresses with a comma" => "Separate multiple email addresses with a comma",
// "Your name" => "Your name",
// "Your email" => "Your email",
// "I found an interesting page that I thought you would like" => "I found an interesting page that I thought you would like",
// "TikiTests Edit" => "TikiTests Edit",
// "Summary mode" => "Summary mode",
// "Show Page Differences" => "Show Page Differences",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Request" => "Request",
// "Element to compare (Xpath expression)" => "Element to compare (Xpath expression)",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "TikiTests List" => "TikiTests List",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "PECL HTTP extension present" => "PECL HTTP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible" => "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "TikiTests Record Configuration" => "TikiTests Record Configuration",
// "Start Recording Test" => "Start Recording Test",
// "TikiTests Replay Configuration" => "TikiTests Replay Configuration",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "Theme Control Center: Categories" => "Theme Control Center: Categories",
// "Control by Objects" => "Control by Objects",
// "Theme Control Center: Sections" => "Theme Control Center: Sections",
// "Edit File" => "Edit File",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "Additional Info" => "Additional Info",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "You locked the file" => "You locked the file",
// "The file is locked by {\$fileInfo.lockedby}" => "The file is locked by {\$fileInfo.lockedby}",
// "Unzip zip files" => "Unzip zip files",
// "Author if not the file creator" => "Author if not the file creator",
// "Maximum amount of downloads" => "Maximum amount of downloads",
// "Add File" => "Add File",
// "Maximum file size is limited to" => "Maximum file size is limited to",
// "No gallery available" => "No gallery available",
// "Uploading file.." => "Uploading file..",
// "No File to Upload.." => "No File to Upload..",
// "or use filename" => "or use filename",
// "Note: Maximum image size is limited to" => "Note: Maximum image size is limited to",
// "The column is disabled" => "The column is disabled",
// "a folder" => "a folder",
// "a URL" => "a URL",
// "User Contacts Preferences" => "User Contacts Preferences",
// "Manage Fields" => "Manage Fields",
// "Default view" => "Default view",
// "Assign Group" => "Assign Group",
// "(non public)" => "(non public)",
// "Homepage" => "Homepage",
// "Users HomePage" => "Users HomePage",
// "System" => "System",
// "This user is your friend" => "This user is your friend",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Request friendship from this user" => "Request friendship from this user",
// "Forum comments" => "Forum comments",
// "Toggle options" => "Toggle options",
// "Toggle" => "Toggle",
// "Personal Information" => "Personal Information",
// "Male" => "Male",
// "Female" => "Female",
// "Use Google Map locator" => "Use Google Map locator",
// "Your personal tracker information" => "Your personal tracker information",
// "View extra information" => "View extra information",
// "Unavailable - please set your e-mail below" => "Unavailable - please set your e-mail below",
// "Does your mail reader need a special charset" => "Does your mail reader need a special charset",
// "Your preferred language" => "Your preferred language",
// "Can you read more languages" => "Can you read more languages",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
// "Select language.." => "Select language..",
// "Displays users' info tooltip on mouseover for every user who allows his information to be public" => "Displays users' info tooltip on mouseover for every user who allows his information to be public",
// "Note author when reading his mail" => "Note author when reading his mail",
// "My user items" => "My user items",
// "My level" => "My level",
// "Account Information" => "Account Information",
// "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password",
// "Email address" => "Email address",
// "Confirm new password" => "Confirm new password",
// "Current password (required)" => "Current password (required)",
// "Change administrative info" => "Change administrative info",
// "New task" => "New task",
// "Task list" => "Task list",
// "Admin mode off" => "Admin mode off",
// "Admin mode on" => "Admin mode on",
// "Task help" => "Task help",
// "Empty Trash" => "Empty Trash",
// "Received task" => "Received task",
// "You received this task, please read and execute it" => "You received this task, please read and execute it",
// "Send task" => "Send task",
// "You send this task to a other user" => "You send this task to a other user",
// "Shared task" => "Shared task",
// "This task is public to a special group" => "This task is public to a special group",
// "Accepted by Task User and Creator" => "Accepted by Task User and Creator",
// "Accepted User and Creator" => "Accepted User and Creator",
// "Task is accepted by user and creator" => "Task is accepted by user and creator",
// "Not Accepted by One User" => "Not Accepted by One User",
// "Not Accepted User" => "Not Accepted User",
// "Task is rejected by one user" => "Task is rejected by one user",
// "Waiting for Me" => "Waiting for Me",
// "Task is not accepted by you, read the task and accept or reject it" => "Task is not accepted by you, read the task and accept or reject it",
// "Waiting for Other User" => "Waiting for Other User",
// "Task is not accepted/rejected by other user" => "Task is not accepted/rejected by other user",
// "Admin Mode" => "Admin Mode",
// "Edit task" => "Edit task",
// "NOT accept" => "NOT accept",
// "Remove from Trash" => "Remove from Trash",
// "Move into Trash" => "Move into Trash",
// "Task saved" => "Task saved",
// "Edit Task" => "Edit Task",
// "View Task" => "View Task",
// "Open a new task" => "Open a new task",
// "taskId" => "taskId",
// "Task user" => "Task user",
// "Only the creator can delete this task" => "Only the creator can delete this task",
// "Use start date and time" => "Use start date and time",
// "Use end date and time" => "Use end date and time",
// "Open / In Process" => "Open / In Process",
// "Waiting / Not Started" => "Waiting / Not Started",
// "Waiting" => "Waiting",
// "Shared for Group" => "Shared for Group",
// "Accepted by User" => "Accepted by User",
// "No / Rejected" => "No / Rejected",
// "Accepted by Creator" => "Accepted by Creator",
// "This message will be send to users if you are makeing changes of assigned tasks" => "This message will be send to users if you are makeing changes of assigned tasks",
// "Send message with changes" => "Send message with changes",
// "Modified by" => "Modified by",
// "Marked as deleted" => "Marked as deleted",
// "Inform task user by email" => "Inform task user by email",
// "You can only view this task" => "You can only view this task",
// "%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
// "Select One" => "Select One",
// "Undo Trash" => "Undo Trash",
// "Received" => "Received",
// "Submitted" => "Submitted",
// "Shared" => "Shared",
// "All Shared Tasks" => "All Shared Tasks",
// "completed (100%)" => "completed (100%)",
// "Public for group" => "Public for group",
// "You are not allowed to remove this notification " => "You are not allowed to remove this notification ",
// "Use \"watches\" to monitor wiki pages or other objects" => "Use \"watches\" to monitor wiki pages or other objects",
// "Watch new items by clicking the {icon _id=eye} button on specific pages" => "Watch new items by clicking the {icon _id=eye} button on specific pages",
// "Add Watch" => "Add Watch",
// "Select event type" => "Select event type",
// "All watched events" => "All watched events",
// "A user edited an article" => "A user edited an article",
// "A user deleted an article" => "A user deleted an article",
// "A user submits a blog post" => "A user submits a blog post",
// "A user posts a forum thread" => "A user posts a forum thread",
// "A user posts a forum topic" => "A user posts a forum topic",
// "A user edited a wiki page" => "A user edited a wiki page",
// "A user created a wiki page in a language" => "A user created a wiki page in a language",
// "Used space" => "Used space",
// "up to" => "up to",
// "no limit for admin" => "no limit for admin",
// "Insert Row" => "Insert Row",
// "Insert Column" => "Insert Column",
// "Remove Row" => "Remove Row",
// "Remove Column" => "Remove Column",
// "Merge Cells" => "Merge Cells",
// "Restore Cells" => "Restore Cells",
// "Copy Calculation" => "Copy Calculation",
// "Format Cell" => "Format Cell",
// "No articles yet" => "No articles yet",
// "Add an article" => "Add an article",
// "There are no questions in this FAQ" => "There are no questions in this FAQ",
// "Answers" => "Answers",
// "Add Suggestion" => "Add Suggestion",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "Group Monitor Topics of this Forum" => "Group Monitor Topics of this Forum",
// "Group Monitor Topics and Threads of this Forum" => "Group Monitor Topics and Threads of this Forum",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Editing posts" => "Editing posts",
// "Forum Lock" => "Forum Lock",
// "Unarchive" => "Unarchive",
// "posts in this forum" => "posts in this forum",
// "Filter Posts" => "Filter Posts",
// "Posts Filtering" => "Posts Filtering",
// "Last post date" => "Last post date",
// "Show archived posts" => "Show archived posts",
// "Containing posts by" => "Containing posts by",
// "Me" => "Me",
// "Posts with no replies" => "Posts with no replies",
// "Archived" => "Archived",
// "Topic List" => "Topic List",
// "The post has been reported and will be reviewed by a moderator" => "The post has been reported and will be reviewed by a moderator",
// "Print this page only" => "Print this page only",
// "Print all pages" => "Print all pages",
// "Stop Monitor" => "Stop Monitor",
// "Edit Fields" => "Edit Fields",
// "Pending" => "Pending",
// "View inserted item" => "View inserted item",
// "Tracker Item" => "Tracker Item",
// "Edit/Delete" => "Edit/Delete",
// "Filter Tracker Items" => "Filter Tracker Items",
// "Items list" => "Items list",
// "Special Operations" => "Special Operations",
// "close" => "close",
// "There was an error connecting to your e-mail account" => "There was an error connecting to your e-mail account",
// "Add a new" => "Add a new",
// "Edit this" => "Edit this",
// " mail account" => " mail account",
// "Group (shared mail inbox) or private" => "Group (shared mail inbox) or private",
// "This will be a group mail account" => "This will be a group mail account",
// "This will be a personal mail account" => "This will be a personal mail account",
// "Auto-refresh page time" => "Auto-refresh page time",
// "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission" => "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission",
// "Personal e-mail accounts" => "Personal e-mail accounts",
// "Click to activate" => "Click to activate",
// "This is the active account" => "This is the active account",
// "Group e-mail accounts" => "Group e-mail accounts",
// "Show Unread" => "Show Unread",
// "Show Flagged" => "Show Flagged",
// "Refresh now" => "Refresh now",
// "Group messages" => "Group messages",
// "unFlagged" => "unFlagged",
// "page id" => "page id",
// "3d browser" => "3d browser",
// "Group Monitor on Structure" => "Group Monitor on Structure",
// "Jump to Content" => "Jump to Content",
// "Cancel Fullscreen" => "Cancel Fullscreen",
// "Show/Hide Left Menus" => "Show/Hide Left Menus",
// "Show/Hide Right Menus" => "Show/Hide Right Menus",
// "Latitude" => "Latitude",
// "Longitude" => "Longitude",
// "Remove Image" => "Remove Image",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Word Count" => "Word Count",
// "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator" => "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator",
// "Number of voices" => "Number of voices",
// "Your vote" => "Your vote",
// "Click to vote for this value" => "Click to vote for this value",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled" => "Google Maps is not enabled",
// "The main text of this page is available in the following languages" => "The main text of this page is available in the following languages",
// "Use this thread to discuss the page" => "Use this thread to discuss the page",
// "Missing or incorrect trackerId parameter for the plugin" => "Missing or incorrect trackerId parameter for the plugin",
// "list" => "list",
// "Reinstall" => "Reinstall",
// "Undecided" => "Undecided",
// "Subscribe to a group" => "Subscribe to a group",
// "Toggle display" => "Toggle display",
// "List authors" => "List authors",
// "Preview your changes" => "Preview your changes",
// "Save the page as a partial translation" => "Save the page as a partial translation",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation" => "Save the page as a completed translation",
// "Complete Translation" => "Complete Translation",
// "Save the page, but do not send notifications and do not count it as new content to be translated" => "Save the page, but do not send notifications and do not count it as new content to be translated",
// "Save the page" => "Save the page",
// "Save the page as a draft" => "Save the page as a draft",
// "Save Draft" => "Save Draft",
// "Cancel the edit, you will lose your changes" => "Cancel the edit, you will lose your changes",
// "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>",
// "Separate multiple usernames with a comma (&nbsp;,&nbsp;)" => "Separate multiple usernames with a comma (&nbsp;,&nbsp;)",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "%s set" => "%s set",
// "%s unset" => "%s unset",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Enable/disable Tiki features here, but configure them elsewhere" => "Enable/disable Tiki features here, but configure them elsewhere",
// "User registration, login and authentication" => "User registration, login and authentication",
// "Wiki Attachments" => "Wiki Attachments",
// "Article/CMS settings" => "Article/CMS settings",
// "Configuration options for all blogs on your site" => "Configuration options for all blogs on your site",
// "FAQ comments settings" => "FAQ comments settings",
// "Trackers settings" => "Trackers settings",
// "RSS settings" => "RSS settings",
// "Directory settings" => "Directory settings",
// "Maps configuration" => "Maps configuration",
// "Meta Tags settings" => "Meta Tags settings",
// "Search settings" => "Search settings",
// "Score settings" => "Score settings",
// "Community settings" => "Community settings",
// "Calendar settings" => "Calendar settings",
// "Intertiki settings" => "Intertiki settings",
// "Freetags settings" => "Freetags settings",
// "Look & Feel" => "Look & Feel",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Current version is up to date : <b>%s</b>" => "Current version is up to date : <b>%s</b>",
// "A new %s  major release branch is available" => "A new %s  major release branch is available",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "Click here to delete the category" => "Click here to delete the category",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header" => "The file does not have the required header",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "You have to provide a hotword and a URL" => "You have to provide a hotword and a URL",
// "moved %d images, %d errors occured" => "moved %d images, %d errors occured",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Detected, Version" => "Detected, Version",
// "Test Image" => "Test Image",
// "Not detected" => "Not detected",
// "You cannot have a blank password" => "You cannot have a blank password",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
// "If you use apache, you need a .htaccess file to have this feature working" => "If you use apache, you need a .htaccess file to have this feature working",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
// "Frequency should be a positive integer" => "Frequency should be a positive integer",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Error opening uploaded file" => "Error opening uploaded file",
// "Invalid email" => "Invalid email",
// "You need to provide a username or an email" => "You need to provide a username or an email",
// "unsafe" => "unsafe",
// "register_globals should be off by default. See the php manual for details" => "register_globals should be off by default. See the php manual for details",
// "safe" => "safe",
// "session.use_trans_sid should be off by default. See the php manual for details" => "session.use_trans_sid should be off by default. See the php manual for details",
// "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser",
// "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config" => "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config",
// "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them",
// "risky" => "risky",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off" => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off",
// "The Path to store files in the filegallery should be outside the tiki root directory" => "The Path to store files in the filegallery should be outside the tiki root directory",
// "The Path to store files in the imagegallery should be outside the tiki root directory" => "The Path to store files in the imagegallery should be outside the tiki root directory",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code" => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code",
// "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html" => "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html",
// "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement" => "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement",
// "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory" => "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory",
// "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts" => "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts",
// "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)" => "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)",
// "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users" => "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users",
// "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users" => "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users",
// "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands" => "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "File is not readable. Unable to check" => "File is not readable. Unable to check",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous" => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous",
// "This is a modified File. Cannot check version. Check if it is dangerous" => "This is a modified File. Cannot check version. Check if it is dangerous",
// "This file is from another Tikiwiki version: " => "This file is from another Tikiwiki version: ",
// "You have to provide a word" => "You have to provide a word",
// "No Errors detected" => "No Errors detected",
// "Are you sure you want to remove this topic" => "Are you sure you want to remove this topic",
// "Are you sure you want to remove this topic AND all the articles related" => "Are you sure you want to remove this topic AND all the articles related",
// "Tracker does not allow attachments" => "Tracker does not allow attachments",
// "Remove group: " => "Remove group: ",
// "Remove permission: %s on %s" => "Remove permission: %s on %s",
// "The description is mandatory as it is used as mail subject" => "The description is mandatory as it is used as mail subject",
// "Invalid or unknown email" => "Invalid or unknown email",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "Created account %s <%s>" => "Created account %s <%s>",
// "Assigned %s in group %s" => "Assigned %s in group %s",
// "User %s already exists" => "User %s already exists",
// "User login contains invalid characters" => "User login contains invalid characters",
// "New %s created with %s %s" => "New %s created with %s %s",
// "Impossible to create new %s with %s %s" => "Impossible to create new %s with %s %s",
// "%s %s successfully deleted" => "%s %s successfully deleted",
// "Deleted account %s" => "Deleted account %s",
// "%s %s removed from %s %s" => "%s %s removed from %s %s",
// "%s <b>%s</b> successfully deleted" => "%s <b>%s</b> successfully deleted",
// "%s <b>%s</b> assigned to %s <b>%s</b>" => "%s <b>%s</b> assigned to %s <b>%s</b>",
// "%s <b>%s</b> removed from %s <b>%s</b>" => "%s <b>%s</b> removed from %s <b>%s</b>",
// "group <b>%s</b> set as the default group of user <b>%s</b>" => "group <b>%s</b> set as the default group of user <b>%s</b>",
// "Login contains invalid characters" => "Login contains invalid characters",
// "%s changed from %s to %s" => "%s changed from %s to %s",
// "Impossible to change %s from %s to %s" => "Impossible to change %s from %s to %s",
// "%s modified successfully" => "%s modified successfully",
// "%s modification failed" => "%s modification failed",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "rss feed disabled" => "rss feed disabled",
// "Tiki RSS feed for articles" => "Tiki RSS feed for articles",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "You have to indicate a group" => "You have to indicate a group",
// "This group is invalid" => "This group is invalid",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s" => "Could not read image %s",
// "Image %s upload failed" => "Image %s upload failed",
// "Image %s uploaded successfully" => "Image %s uploaded successfully",
// "Image %s removed from Batch directory" => "Image %s removed from Batch directory",
// "Impossible to remove image %s from Batch directory" => "Impossible to remove image %s from Batch directory",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images" => "Incorrect directory chosen for batch upload of images",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator" => "Please contact the website administrator",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s" => "Could not read file %s",
// "Could not write to file %s" => "Could not write to file %s",
// "File %s upload failed" => "File %s upload failed",
// "Upload was successful" => "Upload was successful",
// "File %s removed from Batch directory" => "File %s removed from Batch directory",
// "Impossible to remove file %s from Batch directory" => "Impossible to remove file %s from Batch directory",
// "Incorrect directory chosen for batch upload of files" => "Incorrect directory chosen for batch upload of files",
// "Tiki RSS feed for blog: " => "Tiki RSS feed for blog: ",
// "Last modifications to the blog" => "Last modifications to the blog",
// "Tiki RSS feed for weblogs" => "Tiki RSS feed for weblogs",
// "Last posts to weblogs" => "Last posts to weblogs",
// "Nothing tagged yet" => "Nothing tagged yet",
// "You must clear your browser cache" => "You must clear your browser cache",
// "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>" => "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "Access Denied" => "Access Denied",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string",
// "Mo" => "Mo",
// "Tu" => "Tu",
// "We" => "We",
// "Th" => "Th",
// "Fr" => "Fr",
// "Sa" => "Sa",
// "Su" => "Su",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "No category indicated" => "No category indicated",
// "Permission denied; you cannot assign permissions for this category" => "Permission denied; you cannot assign permissions for this category",
// "Invalid username or activation code. Maybe this code has already been used" => "Invalid username or activation code. Maybe this code has already been used",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "Invalid request. Expecting channels array" => "Invalid request. Expecting channels array",
// "Missing channel name" => "Missing channel name",
// "Authentication required" => "Authentication required",
// "One of the requested channels cannot be requested. It does not exist or permission is denied" => "One of the requested channels cannot be requested. It does not exist or permission is denied",
// "One of the install profiles could not be obtained" => "One of the install profiles could not be obtained",
// "Account validated successfully" => "Account validated successfully",
// "Problem. Try to log in again to receive new confirmation instructions" => "Problem. Try to log in again to receive new confirmation instructions",
// "ERROR: you must include a subject or a message at least" => "ERROR: you must include a subject or a message at least",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
// "Tiki RSS feed for directory sites" => "Tiki RSS feed for directory sites",
// "Last sites" => "Last sites",
// "No parent specified" => "No parent specified",
// "Last sites of directory \".\$rc[\"name\"].\" " => "Last sites of directory \".\$rc[\"name\"].\" ",
// "You cannot download this file right now. Your score is low or file limit was reached" => "You cannot download this file right now. Your score is low or file limit was reached",
// "Error : The file %s doesn't exist" => "Error : The file %s doesn't exist",
// "The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
// "Translation in progress" => "Translation in progress",
// "No object indicated" => "No object indicated",
// "Page is a staging copy. Translation must begin from the approved copy" => "Page is a staging copy. Translation must begin from the approved copy",
// "No type indicated" => "No type indicated",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "Can't parse HTML data - no grammar file" => "Can't parse HTML data - no grammar file",
// "Page already exists. Go back and choose a different name" => "Page already exists. Go back and choose a different name",
// "The translation set already contains a page in this language" => "The translation set already contains a page in this language",
// "No questions group indicated" => "No questions group indicated",
// "Remove archive: " => "Remove archive: ",
// "Remove file gallery: " => "Remove file gallery: ",
// "Tiki RSS feed for file galleries" => "Tiki RSS feed for file galleries",
// "Last files uploaded to the file galleries" => "Last files uploaded to the file galleries",
// "Tiki RSS feed for the file gallery: " => "Tiki RSS feed for the file gallery: ",
// "Form error - no import method selected for some reason" => "Form error - no import method selected for some reason",
// "Form error - no server-side filename entered for selected import method" => "Form error - no server-side filename entered for selected import method",
// "Last replied forum topics" => "Last replied forum topics",
// "Tiki RSS feed for forum: " => "Tiki RSS feed for forum: ",
// "Tiki RSS feed for forums" => "Tiki RSS feed for forums",
// "Last topics in forums" => "Last topics in forums",
// "Not supported yet" => "Not supported yet",
// "Accepted friendship request from %s" => "Accepted friendship request from %s",
// "Refused friendship request from %s" => "Refused friendship request from %s",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "Broke friendship with %s" => "Broke friendship with %s",
// "I have broken our friendship" => "I have broken our friendship",
// "You must be logged in to use this feature" => "You must be logged in to use this feature",
// "Friendship request sent to %s" => "Friendship request sent to %s",
// "You're already friend of %s" => "You're already friend of %s",
// "I have accepted your friendship request" => "I have accepted your friendship request",
// "I have refused your friendship request" => "I have refused your friendship request",
// "I have canceled my friendship request" => "I have canceled my friendship request",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "Invalid source path" => "Invalid source path",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "You couldn't abort a instance" => "You couldn't abort a instance",
// "You couldn't exception a instance" => "You couldn't exception a instance",
// "No title indicated" => "No title indicated",
// "No comment indicated" => "No comment indicated",
// "No date indicated" => "No date indicated",
// "first uploaded image" => "first uploaded image",
// "last uploaded image" => "last uploaded image",
// "random image" => "random image",
// "Permission denied you cannot make the map of this gallery" => "Permission denied you cannot make the map of this gallery",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "No valid renderer found. GD or PDFLib required" => "No valid renderer found. GD or PDFLib required",
// "No sheet specified" => "No sheet specified",
// "You must select a renderer" => "You must select a renderer",
// "Invalid Series for current graphic" => "Invalid Series for current graphic",
// "Tiki RSS feed for image galleries" => "Tiki RSS feed for image galleries",
// "Last images uploaded to the image galleries" => "Last images uploaded to the image galleries",
// "Tiki RSS feed for the image gallery: " => "Tiki RSS feed for the image gallery: ",
// "Only the administrator can upload language files" => "Only the administrator can upload language files",
// "updated from structured text import" => "updated from structured text import",
// "created from structured text import" => "created from structured text import",
// "Operations executed successfully" => "Operations executed successfully",
// "Page saved (version %d)" => "Page saved (version %d)",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "Delete comments" => "Delete comments",
// "Approved Status" => "Approved Status",
// "Queued" => "Queued",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Remove file: " => "Remove file: ",
// "Warning: Empty file" => "Warning: Empty file",
// "Please re-upload your file" => "Please re-upload your file",
// "Could not find the file requested" => "Could not find the file requested",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Cannot read the file" => "Cannot read the file",
// "Upload was not successful. Duplicate file content" => "Upload was not successful. Duplicate file content",
// "File update was successful" => "File update was successful",
// "This gallery does not exist" => "This gallery does not exist",
// "The game file must have .swf or .dcr extension" => "The game file must have .swf or .dcr extension",
// "Please supply both files" => "Please supply both files",
// "You have to enable cookies to be able to login to this site" => "You have to enable cookies to be able to login to this site",
// "Unable to contact remote server" => "Unable to contact remote server",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Unable to create login" => "Unable to create login",
// "More than %d unsuccessful login attempts have been made" => "More than %d unsuccessful login attempts have been made",
// "An email has been sent to you with the instructions to follow" => "An email has been sent to you with the instructions to follow",
// "Your default nickname is already in use. A new one has to be selected" => "Your default nickname is already in use. A new one has to be selected",
// "The selected account is not associated with your identity" => "The selected account is not associated with your identity",
// "unknown action" => "unknown action",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "Invalid password" => "Invalid password",
// "Account disabled" => "Account disabled",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "Sorry, you can't use this feature" => "Sorry, you can't use this feature",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile" => "An error as occured with the mapfile",
// "Please create a directory named '.\$prefs['map_path'].' to hold your map files" => "Please create a directory named '.\$prefs['map_path'].' to hold your map files",
// "Maps feature is not correctly setup : Maps path is missing" => "Maps feature is not correctly setup : Maps path is missing",
// "I could not make a copy" => "I could not make a copy",
// "map edit" => "map edit",
// "You dont have permission to do that" => "You dont have permission to do that",
// "Tiki RSS feed for maps" => "Tiki RSS feed for maps",
// "List of maps available" => "List of maps available",
// "No page provided" => "No page provided",
// "Page \"%0\" does not exist" => "Page \"%0\" does not exist",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
// "Your PHP installation does not have zlib enabled" => "Your PHP installation does not have zlib enabled",
// "Are you sure you want to delete this note" => "Are you sure you want to delete this note",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "Missing object list type argument" => "Missing object list type argument",
// "Index" => "Index",
// "Index (' . \$code . " => "Index (' . \$code . ",
// "Pageviews" => "Pageviews",
// "You don't have permission to edit quizzes" => "You don't have permission to edit quizzes",
// "You must choose a group" => "You must choose a group",
// "Username cannot contain uppercase letters" => "Username cannot contain uppercase letters",
// "Username must be at least" => "Username must be at least",
// "Username cannot contain more than" => "Username cannot contain more than",
// "characters" => "characters",
// "Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Please enter a valid %s.  No spaces, more than %d characters and contain %s",
// "This is not a valid mail adress" => "This is not a valid mail adress",
// "mail adress" => "mail adress",
// "empty" => "empty",
// "Unable to send mail. User has not configured email" => "Unable to send mail. User has not configured email",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password" => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password",
// "The mail can't be sent. Contact the administrator" => "The mail can't be sent. Contact the administrator",
// "A password and your IP address reminder email has been sent " => "A password and your IP address reminder email has been sent ",
// "An email with a link to reset your password has been sent " => "An email with a link to reset your password has been sent ",
// "to the email" => "to the email",
// "last version" => "last version",
// "You cannot rename staging pages. Please rename the approved page instead" => "You cannot rename staging pages. Please rename the approved page instead",
// "Permission denied you cannot rename this page" => "Permission denied you cannot rename this page",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "changed '%s' from '%s' to '%s'" => "changed '%s' from '%s' to '%s'",
// "Error Message" => "Error Message",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "No newsletters available" => "No newsletters available",
// "invalid email" => "invalid email",
// "Error: " => "Error: ",
// "Notice: this variable may not be empty" => "Notice: this variable may not be empty",
// "Notice: invalid variable value" => "Notice: invalid variable value",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Clean the sql logs" => "Clean the sql logs",
// "Report to the webmaster" => "Report to the webmaster",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Batch file processed" => "Batch file processed",
// "The uploaded file ist not recognized as a image" => "The uploaded file ist not recognized as a image",
// "That is not an image (or you have php < 4.0.5)" => "That is not an image (or you have php < 4.0.5)",
// "Usage" => "Usage",
// "Password has been changed" => "Password has been changed",
// "Invalid password. Your current password is required to change administrative information" => "Invalid password. Your current password is required to change administrative information",
// "Email is set to %s" => "Email is set to %s",
// "was moved into trash" => "was moved into trash",
// "trashed by" => "trashed by",
// "open / in process" => "open / in process",
// "Rights by creator" => "Rights by creator",
// "END" => "END",
// "Percentage" => "Percentage",
// "Task accepted by creator" => "Task accepted by creator",
// "Task accepted by task user" => "Task accepted by task user",
// "Task NOT accepted by creator" => "Task NOT accepted by creator",
// "Task NOT accepted by task user" => "Task NOT accepted by task user",
// "Sorry this task does not exist or you have no rights to view this task" => "Sorry this task does not exist or you have no rights to view this task",
// "Task entries" => "Task entries",
// "Changes" => "Changes",
// "Info message" => "Info message",
// "NEW Task" => "NEW Task",
// "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks" => "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks",
// "Changes on Task" => "Changes on Task",
// "You received a new task" => "You received a new task",
// "The priority is" => "The priority is",
// "very low" => "very low",
// "low" => "low",
// "high" => "high",
// "very high" => "very high",
// "You've to start your work at least on" => "You've to start your work at least on",
// "You've to finish your work on" => "You've to finish your work on",
// "Login and click the link below" => "Login and click the link below",
// "Please read the task and work on it" => "Please read the task and work on it",
// "Sorry, there was an error while trying to write data into the database" => "Sorry, there was an error while trying to write data into the database",
// "A new page is created in a language" => "A new page is created in a language",
// "Language watch" => "Language watch",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again" => "You must suggest a question; please try again",
// "Incorrect thread" => "Incorrect thread",
// "A SheetId is required" => "A SheetId is required",
// "That tracker don't use extras" => "That tracker don't use extras",
// " The connection failed, so check the server names" => " The connection failed, so check the server names",
// "The connection was OK" => "The connection was OK",
// " But the login failed, so check the Username and Password" => " But the login failed, so check the Username and Password",
// "Tiki RSS feed for the wiki pages" => "Tiki RSS feed for the wiki pages",
// "Last modifications to the Wiki" => "Last modifications to the Wiki",
// "Plugin modified by editor" => "Plugin modified by editor",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "The TikiTests Replay File has an error" => "The TikiTests Replay File has an error",
// "You are about to delete a TikiTest file, do you want to continue " => "You are about to delete a TikiTest file, do you want to continue ",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// "The page is empty" => "The page is empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Re:" => "Re:",
"ID" => "ID",
"Web Server" => "Web Server",
"Wiki" => "Wiki",
"blog" => "blog",
"forum" => "forum",
"Link" => "Link",
"Blog" => "Blog",
"Login" => "Login",
"FAQ" => "FAQ",
"Forum" => "Forum",
"pvs" => "pvs",
"wiki" => "wiki",
"email" => "email",
"Avatar" => "Avatar",
"Zone" => "Zone",
"URL" => "URL",
"Stop" => "Stop",
"Filter" => "Filter",
"Font" => "Font",
"sql query" => "sql query",
"Id" => "Id",
"Original" => "Original",
"Status" => "Status",
"id" => "id",
"debug" => "debug",
"On" => "On",
"Ip" => "Ip",
"To" => "To",
"CC" => "CC",
"BCC" => "BCC",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"Cc" => "Cc",
"QuickTags" => "QuickTags",
"Chat" => "Chat",
"Mail-in" => "Mail-in",
"phpinfo" => "phpinfo",
"Admin" => "Admin",
"login" => "login",
"Logout" => "Logout",
"Email" => "Email",
"Tiki Logo" => "Tiki Logo",
"Permalink" => "Permalink",
"RSS" => "RSS",
"Webmail" => "Webmail",
"avatar" => "avatar",
"JsCalendar" => "JsCalendar",
"Integrator" => "Integrator",
"XMLRPC API" => "XMLRPC API",
"Unix" => "Unix",
"Windows" => "Windows",
"Port" => "Port",
"port" => "port",
"PEAR::Auth" => "PEAR::Auth",
"HTTP port" => "HTTP port",
"HTTPS port" => "HTTPS port",
"Editor" => "Editor",
"Webmaster" => "Webmaster",
"DSN" => "DSN",
"x" => "x",
"Loc" => "Loc",
"Prio" => "Prio",
"h" => "h",
"CMS" => "CMS",
"POP3 server" => "POP3 server",
"Coms" => "Coms",
"zone" => "zone",
"Regex" => "Regex",
"Case" => "Case",
"POP server" => "POP server",
"SMTP server" => "SMTP server",
"Email:" => "Email:",
"bcc" => "bcc",
"popup" => "popup",
"+" => "+",
"URL:" => "URL:",
"status" => "status",
"mad" => "mad",
"Int" => "Int",
"#" => "#",
"inter" => "inter",
"val" => "val",
"If:SetNextact" => "If:SetNextact",
"Proc" => "Proc",
"auto" => "auto",
"int" => "int",
"Program" => "Program",
"Operator" => "Operator",
"Operator:" => "Operator:",
"server" => "server",
"Top 10" => "Top 10",
"Top 20" => "Top 20",
"Top 50" => "Top 50",
"Top 100" => "Top 100",
"tikiwiki.org" => "tikiwiki.org",
"cool" => "cool",
"eek" => "eek",
"razz" => "razz",
"Mb" => "Mb",
"Pre" => "Pre",
"chg" => "chg",
"Q" => "Q",
"A" => "A",
"Emot" => "Emot",
"%H:%M %Z" => "%H:%M %Z",
"tiki-mobile.php" => "tiki-mobile.php",
"unicode" => "unicode",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "Ova osobina je isključena",
"Permission denied you cannot view pages" => "Nemate dozvolu da gledate strane",
"The copyright management feature is not enabled." => "Menadžment autorskih prava nije uključen",
"No page indicated" => "Strana nije odabrana",
"You must supply all the information, including title and year." => "Morate upisati sve podatke, uključujući naslov i godinu",
"You do not have permission to use this feature" => "Nemate dozvolu da koristite ovu osobinu",
"Type" => "Tip",
"Name" => "Ime",
"Description" => "Opis",
"Size" => "Veličina",
"Created" => "Napravljeno",
"Last Modified" => "Zadnji put menjano",
"Creator" => "Kreator",
"Author" => "Autor",
"Comment" => "Komentar",
"Files" => "Fajlovi",
"Hits" => "Pogodaka",
"Locked by" => "Zaključao",
"Path" => "Put",
"None" => "Nijedan",
"Fatal error: cannot execute automatic activity \$activityId" => "Fatalna greška: automatska aktivnost \$activityId ne može da se pokrene",
"Fatal error: setting next activity to an unexisting activity" => "Fatalna greška: podešavanje sledeće aktivnosti na nepostojeću aktivnost",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Fatalna greška: nextActivity ne odgovara nijednom kandidatu u autorouting preklopnoj aktivnosti",
"Fatal error: non-deterministic decision for autorouting activity" => "Fatalna greška: ne-deterministička odluka za autorouting aktivnost",
"Fatal error: trying to send an instance to an activity but no transition found" => "Fatalna greška: pokušavate da pošaljete instancu na aktivnost ali tranzicija nije pronađena",
"Cannot add transition only split activities can have more than one outbound transition" => "Nemožete dodati tranziciju, samo razdvojne aktivnosti mogu imati više od jedne izlatne tranzicije",
"Circular reference found some activity has a transition leading to itself" => "Circularna referenca pronađena, neka aktivnost ima tranziciju koja vodi samoj sebi",
"Process does not have a start activity" => "Proces nema početnu aktivnost",
"Process does not have exactly one end activity" => "Proces nema tačno jednu krajnju aktivnost",
"End activity is not reachable from start activity" => "Krajnja aktivnost ne može biti postignuta od startne aktivnosti",
"Activity" => "Aktivnost",
"is interactive but has no role assigned" => "je interaktivan ali nema dodeljene uloge",
"is non-interactive and non-autorouted but has no role assigned" => "je ne-interaktivan i ne-autorutiran ali nema dodeljenu ulogu",
"is standalone but has transitions" => "je samostojeći ali nema tranzicije",
"Role" => "Uloga",
"is not mapped" => "nije mapiran",
"Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Aktivnost '.\$res['name'].' je samostojeća i koristi \$instance objekat",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Aktivnost '.\$res['name'].' je interaktivna i zato mora koristiti \$instance->complete() metod",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Aktivnost '.\$res['name'].' je ne-interaktivna i zato ne sme da koristi \$instance->complete() metod",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Aktivnost '.\$res['name'].' je preklopnik i zato mora da koristi \$instance->setNextActivity(\$actname) metod",
"Process %d has been activated" => "Proces %d je uključen",
"Process %d has been deactivated" => "Proces %d je isključen",
"Process %s %s imported" => "Proces %s %s je uvežen",
"Process %s removed" => "Proces %s je obrišan",
"Process %s has been updated" => "Proces %s je obnovljen",
"Process %s has been created" => "Proces %s je napravljen",
"points" => "poena",
"Disabled" => "Onemogućeno",
"Plain text" => "Čist tekst",
"Link to user information" => "Link do korisničkih informacija",
"User avatar" => "Korisnički avatar",
"Creation date (desc)" => "Datum kreiranja (prvo najnoviji)",
"Last modification date (desc)" => "Datum izmene (prvo najnoviji)",
"Blog title (asc)" => "Naslov bloga (A-Z)",
"Number of posts (desc)" => "Broj poruka (prvo najviše)",
"Visits (desc)" => "Posete (prvo najviše)",
"Activity (desc)" => "Aktivnost (prvo najveća)",
"Top bar" => "Gornja linija",
"Bottom bar" => "Donja linija",
"no cache" => "nema skladišta",
"minute" => "minuta",
"minutes" => "minuta",
"hour" => "sat",
"hours" => "sati",
"|| for rows" => "|| za redove",
"<return> for rows" => "\\n za redova",
"complete" => "kompletno",
"Year" => "Godina",
"Saturday" => "Subota",
"Sunday" => "Nedelja",
"Monday" => "Ponedeljak",
"Creation Date (desc)" => "Datum pravljenja (prvo najnovije)",
"Topics (desc)" => "Poruke (prvo najviše)",
"Threads (desc)" => "Teme (prvo najviše)",
"Last post (desc)" => "Zadnje poruke (prvo najnovije)",
"Name (desc)" => "Ime (Z-A)",
"Name (asc)" => "Ime (A-Z)",
"replace current window" => "zameni trenutan prozor",
"new window" => "novi prozor",
"inline frame" => "unutrašnji frejm",
"5 minutes" => "5 minuta",
"1 day" => "1 dan",
"1 week" => "1 nedelja",
"1 month" => "1 mesec",
"Allow secure (https) login" => "Dozvoli siguran (https) login",
"Require secure (https) login" => "Zahtevaj siguran (https) login",
"Just Tiki" => "Samo Tiki",
"Tiki and PEAR::Auth" => "Tiki i PEAR::Auth",
"Anonymous" => "Anonimni",
"Use database to store files" => "Koristi bazu podataka za smeštanje fajlova",
"Use a directory to store files" => "Koristi direktorijum za skladištenje fajlova",
"Permission denied" => "Zabranjeno",
"The file is not a CSV file or has not a correct syntax" => "Fajl nije CSV fajl ili nema odgovarajuću sintaksu",
"locked" => "zaključano",
"locked by" => "zaključao",
"in" => "u",
"continued" => "nastavljen",
"New Image Uploaded by" => "Novu sliku je dodao",
"New Subscriptions" => "Nove pretplate",
"New Item in Tracker" => "Nov zapis u trakeru",
"tracker" => "traker",
"by" => "od",
"Image Gallery" => "Galerija slika",
"Articles" => "Članci",
"Blogs" => "Blogovi",
"Forums" => "Forumi",
"Directory" => "Direktorijum",
"File Gallery" => "Galerija fajlova",
"FAQs" => "FAQ",
"Quizzes" => "Kvizovi",
"Trackers" => "Trakeri",
"Survey" => "Anketa",
"Newsletter" => "Novine",
"Charts" => "Grafikoni",
"article" => "članak",
"directory" => "direktorijum",
"faq" => "FAQ",
"poll" => "upitnik",
"quiz" => "kviz",
"image" => "slika",
"calendar" => "Kalendar",
"Invalid filename (using filters for filenames)" => "Neispravno ime fajla (koriste se filteri za ime fajla)",
"Cannot upload this file maximum upload size exceeded" => "Fajl ne može da se prihvati jer je prevelik",
"Wrong password. Cannot post comment" => "Pogrešna lozinka",
"You have to enter a title and text" => "Morate upisati i naslov i tekst",
"text" => "tekst",
"WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::primeni: razlika u broju linija: %s != %s",
"WikiDiff::_check: failed" => "WikiDigg::_provera: neuspeo",
"WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_provera: sekvenca izmene nije optimalna",
"WikiDiff Okay: LCS = %s" => "WikiDiff u redu: LCS = %s",
"Find" => "Nađi",
"find" => "nađi",
"prev" => "prošli",
"Page" => "Strana",
"next" => "sledeći",
"Page name" => "Naziv strane",
"Wiki Home" => "Glavna Wiki strana",
"Home" => "Glavna strana",
"previous page" => "prošla strana",
"next page" => "sledeća strana",
"posted on" => "napisan",
"By:" => "Od:",
"Read" => "Čitaj",
"List articles" => "Lista članaka",
"Last post" => "zadnja poruka",
"Invalid imagename (using filters for filenames)" => "Neispravno ime slike (koristeći filtere za imena fajlova)",
"Errors detected" => "Nađene su greške",
"Upload was not successful" => "Upload nije uspešan",
"No image yet, sorry." => "Još nema slike.",
"unknown" => "nepoznato",
"NONE" => "NIŠTA",
"Wiki top pages" => "Wiki naj strane",
"Most relevant pages" => "Stranice koje najviše odgovaraju",
"Relevance" => "Važnost",
"Wiki last pages" => "Wiki zadnje strane",
"Modified" => "Promenjen",
"Forums last topics" => "Najnovije teme na forumima",
"Topic date" => "Datum teme",
"Forums most read topics" => "Najčitanije teme na forumima",
"Reads" => "Čitanja",
"Forums best topics" => "Naj teme na forumima",
"Score" => "Ocena",
"Forums most visited forums" => "Najposećeniji forumi",
"Visits" => "Posete",
"Forums with most posts" => "Forumi sa najviše tema",
"Posts" => "Poruka",
"Wiki top galleries" => "Wiki naj galerije",
"Wiki top file galleries" => "Wiki naj galerije fajlova",
"Wiki top images" => "Wiki naj slike",
"Wiki top files" => "Wiki naj fajlovi",
"Downloads" => "Preuzimanja",
"Wiki last images" => "Wiki zadnje slike",
"Upload date" => "Datum uploadovanja",
"Wiki last files" => "Wiki zadnji fajlovi",
"Wiki top articles" => "Wiki naj članci",
"Most visited blogs" => "Najposećeniji blogovi",
"Most active blogs" => "Najaktivniji blogovi",
"Blogs last posts" => "Blogovi: zadnje poruke",
"Post date" => "Datum pisanja",
"Wiki top authors" => "Wiki naj autori",
"Pages" => "Strana",
"Top article authors" => "Top autori članaka",
"User already exists" => "Korisnik već postoji",
"Wrong registration code" => "Pogrešan registracioni kod",
"Invalid username" => "Neispravno korisničko ime",
"Username is too long" => "Korisničko ime je predugačko",
"Username cannot contain whitespace" => "Korisničko ime ne može da sadrži razmak",
"Wrong passcode you need to know the passcode to register in this site" => "Pogrešna šifre. Morate znati odgovarajuću šifru da bi se registrovali na ovom sajtu.",
"Invalid email address. You must enter a valid email address" => "Neispravna email adresa. Morate uneti ispravnu email adresu",
"Send message" => "Pošalji poruku",
"Attach file" => "Dodaj fajl",
"Tracker" => "Traker",
"Unknown" => "Nepoznato",
"Image" => "Slika",
"Article" => "Članak",
"Directory category" => "Kategorija direktorijuma",
"Gallery" => "Galerija",
"Blog post" => "Blog poruka",
"Prev" => "Prošla",
"Next" => "Sledeća",
"Edit Template" => "Izmeni šablon",
"Hide" => "Sakrij",
"help" => "pomoć",
"All" => "Svi",
"Date Selector" => "Odabir datuma",
"days" => "dana",
"day" => "dan",
"mins" => "minuta",
"min" => "minuta",
"secs" => "sekundi",
"done" => "urađeno",
"from" => "od",
"for" => "za",
"Priority" => "Prioritet",
"Yes" => "Da",
"No" => "Ne",
"created from structure" => "napravljeno od strukture",
"You are not logged in" => "Niste loginovani",
"Page cannot be found" => "Strana ne može da se nađe",
"Permission denied you cannot view this section" => "Nemate dozvolu da gledate ovu sekciju",
"Help" => "Pomoć",
"You are banned from" => "Zabranjen vam je pristup",
"faqs" => "FAQ",
"quizzes" => "kvizovi",
"blogs" => "blogovi",
"forums" => "forumi",
"games" => "igre",
"Click to edit dynamic variable" => "Kliknite da bi izmenili dinamičke promenjive",
"Update variables" => "Obnovi promenjive",
"at" => "na",
"new" => "novo",
"Unknown language" => "Nepoznat jezik",
"Rating" => "Ocena",
"Item" => "Zapis",
"Subject" => "Naslov",
"Tracker was modified at " => "Traker je modifikovan dana ",
"text field" => "linija teksta",
"size" => "veličina",
"textarea" => "tekstualno polje",
"checkbox" => "polje za čekiranje",
"drop down" => "lista",
"user selector" => "odabir korisnika",
"group selector" => "odabir grupe",
"date and time" => "datum i vreme",
"action" => "akcija",
"category" => "kategorija",
"attachment" => "prikačeni fajl",
"open" => "otvorena",
"closed" => "zatvoren",
"Message" => "Poruka",
"child categories" => "podkategorije",
"objects in category" => "objekata u kategoriji",
"(AT)" => "(NA)",
"(DOT)" => "(TAČKA)",
"Password should be at least" => "Lozinka mora da bude bar",
"characters long" => "karaktera dugačka",
"Password must contain both letters and numbers" => "Lozinka mora da sadrži slova i brojeve",
"Country" => "Država",
"Location" => "Lokacija",
"Language" => "Jezik",
"Start date" => "Datum početka",
"Attachment" => "Prikačeni fajl",
"File" => "Fajl",
"Show description" => "Prikaži opis",
"Displays the user Avatar" => "Prikazuje korisnički avatar",
"username" => "korisničko ime",
"Back" => "Nazad",
"Backlinks" => "Rekurzivni linkovi",
"List all pages which link to specific pages" => "Izlistaj sve strane koje pokazuju na određenu stranu",
"No pages links to" => "Nijedna strana ne pokazuje na",
"One page links to" => "Jedna strana pokazuje na",
"pages link to" => "strana pokazuje na",
"Items" => "Stvari",
"Insert theme styled box on wiki page" => "Ubaci stilizovan okvir na wiki stranu",
"Category" => "Kategorija",
"Insert list of items for the current/given category into wiki page" => "Ubaci listu stvari za trenutnu/datu kategoriju u wiki stranu",
"Categories are disabled" => "Kategorije su isključene",
"Display Tiki objects that have not been categorized" => "Prikaži Tiki objekte koji nisu kategorisani",
"Objects" => "Objekti",
"Insert the full category path for each category that this wiki page belongs to" => "Upišite pun put do kategorije za svaku kategoriju kojoj ova strana pripada",
"Center" => "Centrirano",
"Centers the plugin content in the wiki page" => "Centrira sadržaj plugina u wiki strani",
"Chart" => "Grafik",
"title" => "naslov",
"Code" => "Kod",
"Displays a snippet of code" => "Prikaži isečak koda",
"code" => "kod",
"Dynamic Content" => "Dinamički sadržaj",
"Cookie" => "Kolačić",
"Copyright" => "Autorsko pravo",
"Insert copyright notices" => "Ubaci obaveštenje o autoskim pravima",
"Example" => "Primer",
"seconds" => "sekundi",
"Creates a definition list" => "Pravi listu definicija",
"term" => "termin",
"definition" => "definicija",
"one definition per line" => "jedna definicija po liniji",
"drawing not found" => "crtež nije nađen",
"Events" => "Događaji",
"Desc" => "Opis",
"Upcoming events" => "Dolazeći događaji",
"Label" => "Naslov",
"Displays the data using the Tikiwiki odd/even table style" => "Prikazuje podatke koristeći Tikiwiki par/nepar stil tabele",
"cells" => "ćelija",
"heads and cells separated by ~|~" => "glave i ćelije se odvajaju sa ~|~",
"Title" => "Naslov",
"sort" => "sortiranje",
"failed" => "neuspeo",
"description" => "opis",
"Value" => "Vrednost",
"Displays a graphical GAUGE" => "Prikaži grafički GAUGE",
"type" => "tip",
"Group" => "Grupa",
"HTML code" => "HTML kod",
"name" => "Naslov",
"Image ID" => "ID slike",
"Image size" => "Veličina slike",
"Img" => "Slika",
"Include" => "Uključi",
"Start" => "Početak",
"Include a page" => "Ubaci stranu",
"Displays the text only if the language matchs" => "Prikazuje tekst samo ako je odgovarajući jezik",
"Last Modification" => "Zadnja izmena",
"List Pages" => "Lista strana",
"Sort" => "Sortiraj",
"or" => "ili",
"Map" => "Mapa",
"Feature disabled" => "Osobina je isključena",
"Style" => "Stil",
"Module Name" => "Naziv modula",
"Please choose a module" => "Odaberite modul",
"to be used as argument" => "da bi se koristilo kao argument",
"Displays a module inlined in page" => "Prikaži modul ubačen u stranu",
"Sorry no such module" => "Žao nam je ali nema takvog modula",
"Displays the data using a monospace font" => "Prikazuje podatke koristeći font sa fiksnom širinom karaktera",
"Text" => "Tekst",
"Sticky" => "Važno",
"data" => "podaci",
"Object" => "Objekti",
"picture not found" => "slika nije nađena",
"Provides a list of plugins on this wiki." => "Prikazuje listu wiki plugin-ova.",
"No version indicated" => "Nema podataka o verziji",
"No arguments indicated" => "Argument nije odabran",
"Poll" => "Upitnik",
"one data per line" => "jedan podatak po liniji",
"Search" => "Pretraga",
"Icon" => "Ikonica",
"Date" => "Datum",
"Automatically creates a link to the appropriate SourceForge object" => "Automatski pravi link do odgovarajućeg SourceForge objekta",
"Display" => "Prikaži",
"Action" => "Akcija",
"Sorts the plugin content in the wiki page" => "Sortira sadržaj plugina u wiki strani",
"Order" => "Redosled",
"Split a page into rows and columns" => "Podeli stranu na redove i kolone",
"First" => "Prva",
"Edit" => "Izmeni",
"row1col1" => "red1kol1",
"row1col2" => "red1kol2",
"row2col1" => "red2kol1",
"row2col2" => "red2kol2",
"Run a sql query" => "Pokreni sql query",
"Missing db param" => "Fali db parametar",
"Subscribe" => "Upis",
"Groups" => "Grupe",
"Tag Name" => "Ime Taga",
"Thumbnail" => "Smanjena slika",
"Search the titles of all pages in this wiki" => "Pretraži naslove svih strana u ovom wikiju",
"No pages found for title search" => "Nijedna strana nije pronađena koja odgovara pretrazi naslova",
"One page found for title search" => "Jedna strana pronađena koja odgovara pretrazi naslova",
"pages found for title search" => "strana pronađeno koje odgovaraju pretrazi naslova",
"Structure ID" => "ID Strukture",
"Translate" => "Prevedi",
"Fields" => "Polja",
"Preview" => "Pregled",
"preview" => "pregled",
"View" => "Vidi",
"Error" => "Greška",
"Filters" => "Filteri",
"Template" => "Šablon",
"Mode" => "Mod",
"Links to a translated content" => "Linkovi do prevedenog sadržaja",
"Flag" => "Zastava",
"users" => "korisnici",
"Preferences" => "Podešavanja",
"User Information" => "Korisničke informacije",
"Versions" => "Verzije",
"Vote" => "Glasaj",
"External Wiki" => "Eksterni Wiki",
"valid" => "ispravan",
"Top" => "Početak",
"ERROR: Either the subject or body must be non-empty" => "GREŠKA: Morate upisati ili naslov ili poruku",
"ERROR: No valid users to send the message" => "GREŠKA: Nema ispravnih korisnika kojima bi poslali poruku",
"Invalid user" => "Neispravan korisnik",
"Message sent to" => "Poruke poslate na",
"Message will be sent to: " => "Poruke će biti poslate na:",
"No more messages" => "Nema više poruka",
"Tiki Calendar" => "Tiki Kalendar",
"Calendar" => "Kalendar",
"Create/Edit" => "Napravi/izmeni",
"Quick Edit a Wiki Page" => "Brzo izmeni Wiki stranu",
"Post" => "Poruke",
"new comments" => "novi komentari",
"wiki pages changed" => "promenjene wiki strane",
"new images" => "nove slike",
"new files" => "novi fajlovi",
"new users" => "novi korisnici",
"Invalid username or password" => "Pogrešno korisničko ime ili lozinka",
"change password" => "promeni lozinku",
"country" => "država",
"Random Image" => "Random slika",
"List of attached files" => "Lista prikačenih fajlova",
"desc" => "opis",
"uploaded" => "uploadovano",
"Download" => "Preuzimanja",
"Delete" => "Obriši",
"Remove" => "Izbaci",
"Upload file" => "Dodaj fajl",
"Attach" => "Priloži",
"Attach a file to this item" => "Priloži fajl ovom zapisu",
"Version" => "Verzije",
"Attachments" => "Prilozi",
"No attachments for this item" => "Nema priloga na ovom zapisu",
"Fatal error" => "Fatalna greška",
"Created by" => "Napravio",
"on" => "u",
"RSS feed" => "RSS izvor",
"Edit blog" => "Izmeni blog",
"Monitor this Blog" => "Nadgledaj ovaj blog",
"Stop Monitoring this Blog" => "Prestani sa nadgledanjem ovog bloga",
"Activity=" => "Aktivnost=",
"Actions" => "Akcije",
"Properties" => "Osobine",
"No records found" => "Nijedan zapis nije pronađen",
"Categorize" => "Kategorizuj",
"Admin Categories" => "Administracija kategorija",
"No categories defined" => "Kategorije nisu definisane",
"stars" => "zvezde",
"User Level" => "Korisnički nivo",
"private message" => "privatna poruka",
"Send eMail to User" => "Pošalji email korisniku",
"user online" => "korisnik je online",
"user offline" => "korisnik je offline",
"Approve" => "Odobri",
"Reject" => "Odbij",
"Save to notepad" => "Snimi u notes",
"Monitor this Topic" => "Nadgledaj ovu temu",
"Stop Monitoring this Topic" => "Prestani sa nadgledanjem ove teme",
"Moderator actions" => "Moderatorske akcije",
"reported:" => "prijavljeno:",
"queued:" => "na listi čekanja:",
"Move to topic:" => "Pomeri na temu:",
"Move" => "Pomeri",
"Delete Selected" => "Obriši odabrano",
"Unlock" => "Otključaj",
"Lock" => "Zaključaj",
"Messages" => "Poruke",
"Newest first" => "Prvo najnovije",
"Oldest first" => "Prvo najstarije",
"Title (desc)" => "Naslov (Z-A)",
"Title (asc)" => "Naslov (A-Z)",
"Threshold" => "Granica",
"Set" => "Podesi",
"Replies" => "Odgovora",
"New Reply" => "Nov odgovor",
"Editing comment" => "Menjanje komentara",
"Post new comment" => "Dodaj novi komentar",
"Smileys" => "Smajliji",
"Cancel" => "Obustavi",
"Posting comments" => "Slanje komentara",
"Use" => "Koristi",
"for links" => "za linkove",
"Add Comment" => "Dodaj komentar",
"1 comment" => "1 komentar",
"Comments" => "Komentari",
"Go back" => "Idi nazad",
"Return to home page" => "Povratak na glavnu stranu",
"Copyrights" => "Autorska prava",
"Authors" => "Autori",
"Add" => "Dodaj",
"Syntax" => "Sintaksa",
"Page generation debugging log" => "Debag log generisanja strane",
"Features state" => "Stanje osobine",
"Total" => "Ukupno",
"features matched" => "Osobine pronađene",
"Watchlist" => "Lista nadgledanja",
"duplicate" => "napravi kopiju",
"There are individual permissions set for this file gallery" => "Individualne dozvole su podešene za ovu galeriju fajlova",
"Save" => "Snimi",
"Gallery is visible to non-admin users?" => "Galerija je vidljiva ne admin korisnicima?",
"none" => "nijedan",
"Max description display size" => "Maksimalna veličina prikaza opisa",
"Max Rows per page" => "Maksimalno redova po strani",
"Listing configuration" => "Konfiguracija listinga",
"Create this page" => "Napravi ovu stranu",
"Perms" => "Dozvole",
"Replace" => "Zameni",
"List" => "Lista",
"Browse" => "Traži",
"Name-filename" => "Ime-Ime fajla",
"Filename only" => "Samo imena fajlova",
"Close" => "Zatvori",
"Number of displayed rows" => "Broj prikazanih redova",
"in:" => "u:",
"Move Selected Files" => "Pomeri odabrane fajlove",
"Move to" => "Pomeri",
"Assign" => "Dodeli",
"Filename" => "Naziv fajla",
"Hi {\$mail_user} has sent you this link:" => "Zdravo {\$mail_user} vam je poslao ovaj link",
"Blog post:" => "Blog poruka:",
"at:" => "na:",
"Somebody or you tried to subscribe this email address at our site:" => "Neko ili vi je pokušao da pretplati ovu email adresu na našem sajtu:",
"To the newsletter:" => "Na novine:",
"Description:" => "Opis:",
"In order to confirm your subscription you must access the following URL:" => "Da bi potvrdili vašu pretplatu morate pratiti sledeći URL:",
"A new message was posted to forum" => "Nova poruka je poslata na forum",
"Tiki mail-in instructions" => "Tiki instrukcije za mail-in",
"Hi," => "Zdravo,",
"A new message was posted to you at {\$mail_machine}" => "Nova poruka vam je poslata na {\$mail_machine}",
"From" => "Od",
"Hi" => "Zdravo",
"Enjoy the site!" => "Uživajte u sajtu!",
"The user" => "Korisnik",
"registered at your site" => "registrovan na tvom sajtu",
"New user registration" => "Registracija novog korisnika",
"Bye bye!" => "Zdravo!",
"This email address has been removed to the list of subscriptors of:" => " Ova email adresa je obrisana sa liste pretplatnika od:",
"Newsletter:" => "Novine:",
"You can unsubscribe from this newsletter following this link" => "Možete da prekinete vašu pretplatu na ove novine prateći ovaj link",
"Welcome to our newsletter!" => "Dobrodošli na naše novine!",
"This email address has been added to the list of subscriptors of:" => "Ova email adresa je dodata listi pretplatnika od:",
"You can always cancel your subscription using:" => "Uvek možete prekinuti vašu pretplatu koristeći:",
"Email notification" => "Tiki email obaveštenja",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Nov članak je poslao {\$mail_user} na {\$mail_site} dana {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "Možete izmeniti vaš predlog preko sledećeg linka:",
"Title:" => "Naslov:",
"Heading:" => "Zaglavlje:",
"Body:" => "Telo poruke:",
"User:" => "Korisnik:",
"You or someone registered this email address at" => "vi ili neko drugi je registrovao ovu email adresu na",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Ako želite da budete registrovani korisnik na ovom sajtu morate da koristite ovaj link da bi se loginovali po prvi put:",
"Your registration confirmation" => "Registracija vaših Tiki informacija",
"You will receive an email with information to login for the first time into this site" => "Primićete email sa informacijama za loginovanje po prvi put na ovaj sajt",
"If you don't want to receive these notifications follow this link:" => "Ako neželite da primate ova obaveštenja pratite ovaj link:",
"View the blog at:" => "Vidi blog na:",
"changed" => "promenjeno",
"created" => "napravljen",
"File Description" => "Opis fajla",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Mapu {\$mail_page} je promenio {\$mail_user} dana {\$mail_date|tiki_short_datetime}",
"You can view the updated map following this link:" => "Obnovljenu mapu možete videti ako pratite sledeći link:",
"You can edit the map following this link:" => "Mapu možete izmeniti ako pratite sledeći link:",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Strana {\$mail_page} je promenjena od strane korisnika {\$mail_user} dana {\$mail_date|tiki_short_datetime}",
"Comment:" => "Komentar:",
"The new page content follows below." => "Novi sadržaj stranice sledi.",
"New name" => "Novo ime",
"click on the map to zoom or pan, do not drag" => "kliknite na mapu da bi zumirali ili pomerali centar, nemojte da vučete",
"Scale" => "Skala",
"Query" => "Upit",
"Redraw" => "Ponovo iscrtaj",
"select zoom/pan/query and image size" => "odaberite zum/centriranje/upit i veličinu slike",
"Click on the map or click redraw" => "Kliknite na mapu ili kliknite na ponovo iscrtaj",
"Last modification date" => "Datum zadnje promene",
"Overview" => "Pregled",
"Legend" => "Legenda",
"Layer Manager" => "Menadžer slojeva",
"Download Layer" => "Sloj preuzimanja",
"you have requested to download the layer:" => "odabrali ste preuzimanje sloja:",
"Here are the files to download, do not forget to rename them:" => "Ovde se nalaze faljovi za preuzimanje, nemojte zaboraviti da im promenite imena:",
"Mapfiles" => "Map fajlovi",
"Mapfile" => "Map fajl",
"Available mapfiles" => "Raspoloživi map fajlovi",
"monitor this map" => "prati promene ove mape",
"Stop Monitoring this Map" => "Prekini praćenje ove mape",
"Create a new mapfile" => "Napravi novi fajl mape",
"Create" => "Napravi",
"Mapfile listing" => "Lista map fajlova",
"History" => "Istorija",
"You can view this map in your browser using" => "Ovu mapu možete videti u vašem browseru pomoću",
"of" => "od",
"Compare" => "Uporedi",
"Current" => "Trenutni",
"Versions are identical" => "Verzije su identične",
"User" => "Korisnik",
"Diff" => "Razlika",
"Directories" => "Direktorijumi",
"Upload From Disk:" => "Dodavanje sa diska:",
"Upload Files" => "Dodaj fajlove",
"Bytes maximum" => "Maksimum bajtova",
"Create Directory:" => "Napravi direktorijum:",
"index file (.shp):" => "indeksni fajl (.shp):",
"files to index (regexp):" => "fajlovi za indeksiranje (regexp):",
"Unread" => "Nepročitan",
"Flagged" => "Označen",
"Unflagged" => "Nemarkirana",
"Containing" => "Sadrži",
"Sender" => "pošiljaoc",
"No messages to display" => "Nema poruka za prikaz",
"Broadcast message" => "Pošalji svima poruku",
"OK" => "Ok",
"All users" => "Svi korisnici",
"Lowest" => "Najniži",
"Low" => "Nizak",
"Normal" => "Normalan",
"High" => "Visok",
"Very High" => "Vrlo visok",
"Send" => "Pošalji",
"Compose message" => "Sastavi email",
"Invalid" => "Neispravan",
"Mark as read" => "Obeleži kao pročitano",
"Mark as unread" => "Obeleži kao nepročitano",
"Mark as flagged" => "Markiraj",
"Mark as unflagged" => "Isključi oznaku",
"Mark" => "obeleži",
"Mailbox" => "Poštansko sanduče",
"Compose" => "Sastavi",
"Broadcast" => "Pošalji svima",
"Read message" => "Čitaj poruku",
"replyall" => "odgovori na sve",
"Flag this message" => "Markiraj ovu poruku",
"'name' parameter for tikimodule missed" => "'ime' parametar za tikimodule je promašen",
"Move module up" => "Pomeri modul gore",
"Up" => "Gore",
"Move module down" => "Pomeri modul dole",
"Down" => "Dole",
"Move module to opposite side" => "Pomeri modul na obrnutu stranu",
"Admin Menu" => "Administracioni meni",
"Live Support" => "Podrška uživo",
"Banning" => "Zabrana pristupa",
"Users" => "Korisnici",
"Cache" => "Skladište",
"Modules" => "Moduli",
"Links" => "Linkovi",
"Hotwords" => "Aktivne reči",
"RSS Modules" => "RSS moduli",
"Menus" => "Meniji",
"Polls" => "Upitnici",
"Mail Notifications" => "Obaveštenje email-om",
"Search Stats" => "Pretražuj statistike",
"Categories" => "Kategorije",
"Banners" => "Oglasi",
"Edit Templates" => "Izmeni šablone",
"Cookies" => "Kolačići",
"Content Templates" => "Šabloni sadržaja",
"HTML Pages" => "HTML Strane",
"Shoutbox" => "ShoutBox",
"Referer Stats" => "Statistike referenata",
"Import PHPWiki Dump" => "Uvezi PHPWiki ostavu",
"Admin dsn" => "Administracija dsn",
"Select" => "Odaberi",
"Admin Modules" => "Admin modula",
"Admin Menus" => "Administriraj menije",
"Recently visited pages" => "Skoro posećene stranice",
"Tuesday" => "Utorak",
"Wednesday" => "Sreda",
"Thursday" => "Četvrtak",
"Friday" => "Petak",
"Today" => "Danas",
"Received objects" => "Primljeni objekti",
"Pages:" => "Strana:",
"Last `\$module_rows` Sites" => "Zadnjih `\$module_rows` sajtova",
"Last Sites" => "Zadnji sajtovi",
"Directory Stats" => "Statistike direktorijuma",
"Sites" => "Sajtovi",
"Sites to validate" => "Sajtovi za proveru",
"Searches" => "Pretrage",
"Visited links" => "Posećeni linkovi",
"Top \$module_rows Sites" => "Naj \$module_rows sajtova",
"Top Sites" => "Top sajtovi",
"Featured links" => "Prikazujemo vam sajtove",
"Top topics" => "Top poruke",
"Last `\$module_rows` forum topics" => "Zadnjih `\$module_rows` tema u forumu",
"Last forum topics" => "Zadnje poruke na forumu",
"Most commented forums" => "Naj iskomentirani forumi",
"Most read topics" => "Najčitanije poruke",
"Most visited forums" => "Najposećeniji forumi",
"Google Search" => "pretraga na Google",
"Last `\$module_rows` articles" => "Zadnjih `\$module_rows` članaka",
"Last articles" => "Zadnjih članaka",
"Last `\$module_rows` blog posts" => "Zadnjih `\$module_rows` blog poruka",
"Last blog posts" => "Zadnje blog poruka",
"Last" => "Zadnjih",
"Last `\$module_rows` Created blogs" => "Zadnjih `\$module_rows` napravljenih blogova",
"Last Created blogs" => "Zadnji napravljeni blogovi",
"Last `\$module_rows` Created FAQs" => "Zadnjih `\$module_rows` napravljenih  FAQs",
"Last Created FAQs" => "Zadnji napravljeni FAQ-ovi",
"Last `\$module_rows` Created Quizzes" => "Zadnjih `\$module_rows` napravljenih kvizova",
"Last Created Quizzes" => "Zadnji napravljeni kvizovi",
"Last `\$module_rows` modified file galleries" => "Zadnjih `\$module_rows` promenjenih fajl galerija",
"Last modified file galleries" => "Zadnje promenjene galerije fajlova",
"Last `\$module_rows` Files" => "Zadnjih `\$module_rows` fajlova",
"Last Files" => "Zadnji fajlovi",
"Last `\$module_rows` galleries" => "Zadnjih `\$module_rows` galerija",
"Last galleries" => "Zadnje galerije",
"Last `\$module_rows` changes" => "Zadnjih `\$module_rows` izmena",
"Last changes" => "Zadnje promene",
"Last `\$module_rows` Modified Items" => "Zadnjih `\$module_rows` promenjenih stvari",
"Last Modified Items" => "Zadnje promenjene stvari",
"Last `\$module_rows` Modified blogs" => "Zadnjih `\$module_rows` promenjenih blogova",
"Last Modified blogs" => "Zadnji promenjeni blogovi",
"Last `\$module_rows` submissions" => "Zadnjih `\$module_rows` priloga",
"Last submissions" => "Zadnji prilozi",
"Last `\$module_rows` Items" => "Zadnjih `\$module_rows` stvari",
"Last Items" => "Zadnje stvari",
"Register" => "Registruj se",
"Live support" => "Podrška uživo",
"Open operator console" => "Otvori operatorsku konzolu",
"Online users" => "Onlajn korisnici",
"We have" => "Mi imamo",
"online users" => "onlajn korisnika",
"Switch" => "Prekidač",
"eMail" => "Email",
"Password" => "Lozinka",
"Remember me" => "Zapamti me",
"week" => "nedelja",
"month" => "mesec",
"I forgot my password" => "Zaboravio sam moju lozinku",
"Standard" => "Standardan",
"Secure" => "Siguran",
"Stay in ssl Mode" => "Ostani u ssl modu",
"Menu" => "Meni",
"You have" => "Imate",
"New Messages" => "Novih poruka",
"New Message" => "Novu poruku",
"You have 0 new messages" => "Imate 0 novih poruka",
"Waiting Submissions" => "Prilozi na čekanju",
"submissions waiting to be examined" => "priloga koji čekaju na pregled",
"Old articles" => "Stari članci",
"Send a message to" => "Pošalji poruku",
"Random Pages" => "Slučajne strane",
"Register as a new user" => "Registruj se kao novi korisnik",
"Your email could not be validated; make sure you email is correct and click register below." => "Vaš email nismo uspeli da overimo; proverite da li je vaš email u redu i kliknite na register ispod.",
"Your registration code:" => "Vaš registracioni kod:",
"Username" => "Korisničko ime",
"Passcode to register (not your user password)" => "Lozinka za registraciju (ne vaša korisnička lozinka)",
"Registration code" => "Registracioni kod",
"Repeat password" => "Ponovi lozinku",
"Generate a password" => "Generiši lozinku",
"Image Galleries" => "Galerije slika",
"File Galleries" => "Fajl galerije",
"Maps" => "Mape",
"Entire Site" => "Ceo sajt",
"Wiki Pages" => "Wiki strane",
"Image Gals" => "Galerije slika",
"Images" => "Slike",
"Blog Posts" => "Blog poruke",
"Search Wiki PageName" => "Pretražuj Wiki ImeStrane",
"Read More" => "Čitaj još",
"Since your last visit" => "Od vaše poslednje posete",
"Since your last visit on" => "Od vaše poslednje posete dana",
"New Images" => "Nove slike",
"Wiki Pages Changed" => "Promenjene wiki strane",
"New Files" => "Novi fajlovi",
"New Comments" => "Novi komentari",
"New Users" => "Novi korisnici",
"click to edit" => "Klikni za izmenu",
"Theme" => "Teme",
"Most Active blogs" => "Najaktivniji blogovi",
"Top `\$module_rows` articles" => "Naj `\$module_rows` članaka",
"Top articles" => "Top članci",
"Top `\$module_rows` File Galleries" => "Naj `\$module_rows` fajl galerija",
"Top File Galleries" => "Top galerije fajlova",
"Top `\$module_rows` files" => "Naj `\$module_rows` fajlova",
"Top files" => "Naj fajlovi",
"Top `\$module_rows` games" => "Naj `\$module_rows` igara",
"Top games" => "Top igre",
"Top `\$module_rows` galleries" => "Naj `\$module_rows` galerija",
"Top galleries" => "Glavne galerije",
"Top `\$module_rows` Images" => "Naj `\$module_rows` slika",
"Top Images" => "Naj Slike",
"Top `\$module_rows` Pages" => "Naj `\$module_rows` strana",
"Top Pages" => "Naj Stranice",
"Top `\$module_rows` Quizzes" => "Naj `\$module_rows` kvizova",
"Top Quizzes" => "Top kvizovi",
"Most `\$module_rows` visited blogs" => "Najposećenijih `\$module_rows` blogova",
"Top `\$module_rows` Visited FAQs" => "Najposećenijih `\$module_rows` FAQ",
"Top Visited FAQs" => "Najposećeniji FAQ-ovi",
"view" => "vidi",
"My blogs" => "Moji blogovi",
"Bookmarks" => "Omiljeni linkovi",
"My galleries" => "Moje galerije",
"My Pages" => "Moje strane",
"User tasks" => "Korisnički poslovi",
"Done" => "urađeno",
"Del" => "Obriši",
"Whats related" => "Šta je u vezi",
"online user" => "onlajn korisnik",
"Last `\$module_rows` wiki comments" => "Zadnjih `\$module_rows` wiki komentara",
"Last wiki comments" => "Zadnji wiki komentari",
"Real Name" => "Pravo ime",
"vote" => "glasaj",
"Structures:" => "Strukture:",
"show structures" => "prikaži strukture",
"hide structures" => "sakrij strukture",
"Find:" => "Nađi:",
"pages" => "strane",
"To edit the copyright notices" => "Da bi se izmenili podaci o autorskim pravima",
"Click Here" => "Klikni ovde",
"The content on this page is licensed under the terms of the" => "Sadržaj ove strane je licenciram po uslovima od",
"Print" => "Štampaj",
"Email This Post" => "email-uj ovu poruku",
"comment" => "komentar",
"comments" => "komentara",
"First page" => "Prva strana",
"Previous page" => "Prošla strana",
"page" => "strana",
"Next page" => "Sledeća strana",
"Last page" => "Zadnja strana",
"referenced by" => "refencirao",
"references" => "referense",
"View Comments" => "Vidi komentare",
"Trackback pings" => "Trekbek pingovi",
"URI" => "URL",
"Blog name" => "Naziv bloga",
"Enlarge area height" => "Povećaj visinu prostora",
"Reduce area height" => "Smanji visinu prostora",
"Tools Calendars" => "Kalendari alatki",
"Check / Uncheck All" => "Markiraj / odmarkiraj sve",
"Refresh" => "Osveži",
"Cancel Edit" => "Odustani od izmene",
"Change preferences" => "Promeni podešavanja",
"Content" => "Sadržaj",
"Activate" => "Aktiviraj",
"Publish" => "Objavi",
"General" => "Generalno",
"Features" => "Osobine",
"Module" => "Moduli",
"User files" => "Korisnički fajlovi",
"General Settings" => "Generalna podešavanja",
"Home Blog (main blog)" => "Glavni blog",
"Rankings" => "Rangiranja",
"Points" => "Poena",
"Last modified" => "Zadnji put promenjeno",
"Permissions" => "Dozvole",
"Topic" => "Tema",
"Submissions" => "Prilozi",
"Import CSV file" => "Uvezi CSV fajl",
"Batch upload (CSV file)" => "Grupni upload (CSV fajl)",
"Import" => "Uvezi",
"Visible" => "Vidljivo",
"Last login" => "Zadnje loginovanje",
"Number of visited pages to remember" => "Broj posećenih strana da se pamti",
"Displayed time zone" => "Prikazana vremenska zona",
"User information" => "Korisničke informacije",
"Private" => "Privatno",
"public" => "javno",
"Tasks per page" => "Poslova po strani",
"Messages per page" => "Poruka po strani",
"Allow messages from other users" => "Dozvoli poruke od drugih korisnika",
"Send me an email for messages with priority equal or greater than" => "Pošalji mi email za poruke sa prioritetom jednakim ili većim od",
"My Tiki" => "Moj Tiki",
"My pages" => "Moje strane",
"My messages" => "Moje poruke",
"My tasks" => "Moji poslovi",
"My items" => "Moje stvari",
"Number of columns per page when listing categories" => "Broj kolona po strani pri listanju kategorija",
"Links per page" => "Linkova po strani",
"Validate URLs" => "Proveri URLove",
"Method to open directory links" => "Metoda za otvaranje linkova u direktorijumu",
"New Window" => "Novi prozor",
"Default number of comments per page" => "Podrazumevani broj komentara po strani",
"Comments default ordering" => "Podrazumevani redosled sortiranja komentara",
"Newsletters" => "Novine",
"Surveys" => "Ankete",
"Featured Help" => "Pomoć u Fokusu",
"Live support system" => "Sistem podrške uživo",
"Contact Us" => "Kontaktirajte nas",
"PhpLayers Dynamic menus" => "PhpLayers dinamički meniji",
"Drawings" => "Crteži",
"Games" => "Igre",
"Administration Features" => "Administracione osobine",
"Banning System" => "Sistem zabrane pristupa",
"Banning system" => "Sistem za zabranu pristupa",
"Stats" => "Statistike",
"Communications (send/receive objects)" => "Komunikacija (slanje/primanje objekata)",
"Custom Home" => "Promenjiva glavna strana",
"User Features" => "Korisničke osobine",
"Mini Calendar" => "Mini Kalendar",
"User Preferences Screen" => "Ekran za korisnička podešavanja",
"User Notepad" => "Korisnički notes",
"User Bookmarks" => "Korisničke omiljene strane",
"User Watches" => "Korisnička nadgledanja",
"User Menu" => "Korisnički meni",
"User Tasks" => "Korisnički poslovi",
"User Messages" => "Korisničke poruke",
"User Files" => "Korisnički fajlovi",
"Newsreader" => "Čitač novina",
"Debugger Console" => "Debugger konzola",
"Workflow" => "",
"Workflow engine" => "",
"Home Gallery (main gallery)" => "Glavna galerija",
"Never" => "Nikada",
"Home Forum (main forum)" => "Glavni forum",
"Accept wiki syntax" => "Prihvati wiki sintaksu",
"Topics" => "Teme",
"Posts per day" => "Poruka na dan",
"Galleries features" => "Osobine galerije",
"Uses Slideshow" => "Koristi prezentaciju (Slideshow)",
"Use database to store images" => "Koristi bazu podataka za skladištenje slika",
"Use a directory to store images" => "Koristi direktorijum za skladištenje slika",
"Directory path" => "Direktorijum",
"Library to use for processing images" => "Biblioteka koja se koristi za procesiranje slika",
"Uploaded image names must match regex" => "Imena uploadovanih slika moraju da odgovaraju regex-u",
"Uploaded image names cannot match regex" => "Imena uploadovanih slika nesmeju da odgovaraju regex-u",
"Images per row" => "Slika po redu",
"Thumbnails size X" => "Širina smanjene slike",
"Thumbnails size Y" => "Visina smanjene slike",
"Set features" => "Podesi osobine",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Ukloni slike u sistemskoj galeriji koje se ne koriste u Wiki stranama, člancima ili blog porukama",
"All galleries" => "Sve galerije",
"System Gallery" => "Sistemska galerija",
"Gallery listing configuration" => "Konfiguracija liste galerija",
"Parent" => "Roditelj",
"Image galleries comments settings" => "Podešavanja komentara galerija slika",
"General Preferences" => "Generalna podešavanja",
"Date and Time Formats" => "Format datuma i vremena",
"Browser title" => "Naslov u browseru",
"Home Page" => "Glavna strana",
"Use group homepages" => "Koristi grupne glavne strane",
"Custom home" => "Custom glavna strana",
"Unknown/Other" => "Nepoznato/Ostalo",
"Use proxy" => "Koristi proxy",
"Tikiwiki.org help" => "Tikiwiki.org pomoć",
"Store session data in database" => "Sačuvaj podatke o sesijama u bazi podataka",
"Contact" => "Kontakt",
"Contact user" => "Kontaktiraj korisnika",
"Count admin pageviews" => "Broj poglede strana administratora",
"Temporary directory" => "Privremeni direktorijum",
"Help System" => "Sistem pomoći",
"Long date format" => "Dugačak format datuma",
"Short date format" => "Kratak format datuma",
"Long time format" => "Dugačak format vremena",
"Short time format" => "Kratak format vremena",
"Date and Time Format Help" => "Pomoć za format datuma i vremena",
"Change admin password" => "Promeni administratorsku šifru",
"New password" => "Nova lozinka",
"Change password" => "Promeni lozinku",
"Use database for translation" => "Koristi bazu podataka za prevođenje",
"Edit or ex/import Languages" => "Izmeni ili izvezi/uvezi jezike",
"Record untranslated" => "Zapisa neprevedeno",
"Admin Groups" => "Administriraj grupe",
"Admin Users" => "Administriraj korisnike",
"Authentication method" => "Metod autentikacije",
"Tiki and HTTP Auth" => "Tiki i HTTP Auth",
"Users can register" => "Korisnici mogu da se registruju",
"Use challenge/response authentication" => "Koristi challenge/response autentikaciju",
"Duration" => "Trajanje",
"Users can change theme" => "Registrovani korisnici mogu da menjaju teme",
"Slideshows theme" => "Slajdšov teme",
"Edit CSS" => "Izmeni CSS",
"Theme Control" => "Kontrola tema",
"Tiki Template Viewing" => "Tiki gledanje šablona",
"General Layout options" => "Generalne opcije izgleda",
"logged as" => "Ulogovan kao",
"Left column" => "Leva kolona",
"Right column" => "Desna kolona",
"Maximum number of records in listings" => "Maksimalan broj zapisa u listinzima",
"Use direct pagination links" => "Koristi linkove sa direktnom paginacijom",
"Warning" => "Upozorenje",
"Display menus as folders" => "Prikaži menije kao direktorijume",
"Layout per section" => "Raspored po sekciji",
"Admin layout per section" => "Administriraj raspored po sekcijama",
"full path to mapfiles" => "puna adresa do map fajlova",
"default mapfile" => "podrazumevani map fajl",
"Wiki Page for Help" => "Wiki strana za pomoć",
"Wiki Page for Comments" => "Wiki strana za komentare",
"Full path to gdaltindex" => "Puna adresa do gdaltindex",
"Display modules to all groups always" => "Uvek prikaži module svim grupama",
"Hide anonymous-only modules from registered users" => "Sakrij module koji su samo za anonimne korisnike od regostrovanih korisnika",
"Last update" => "Zadnja promena",
"Image galleries" => "Galerije slike",
"Feed for forums" => "Izvor za forume",
"Default RDF version" => "Podrazumevana RDF verzija",
"Specification" => "Specifikacija",
"Documentation" => "Dokumentacija",
"Search stats" => "Pretražuj statistike",
"random" => "slučajni",
"Refresh rate" => "Vreme osvežavanja",
"hits" => "pogodaka",
"Open external links in new window" => "Otvori eksterne linkove u posebnom prozoru",
"Dynamic Content System" => "Dinamički sistem sadržaja",
"Automonospaced text" => "Automonorazmaknut tekst",
"Tables syntax" => "Sintaksa tabela",
"AutoLinks" => "AutoLinkovi",
"rows" => "redova",
"Required" => "Obavezno",
"Parameters" => "Parametri",
"dls" => "preuzimanja",
"Quota (Mb)" => "Kvota (Mb)",
"Use database to store userfiles" => "Koristi bazu podataka za skladištenje korisničkih fajlova",
"Use a directory to store userfiles" => "Koristi direktorijum za skladištenje korisničkih fajlova",
"Allow viewing HTML mails?" => "Dozvoli gledanje HTML emailova",
"Maximum size for each attachment" => "Maksimalna veličina svakog priloga",
"Create New" => "Napravi novo",
"Home page" => "Glavna strana",
"Complete" => "Završeno",
"Individual cache" => "Individualno skladište",
"Content templates" => "Šabloni sadržaja",
"Undo" => "Vrati",
"Footnotes" => "donje zaglavlje",
"Permission" => "Dozvola",
"Allow HTML" => "Dozvoli HTML",
"Sandbox" => "Igraonica",
"Dumps" => "Ostave",
"Remove a tag" => "Ukloni tag",
"Generate dump" => "Napravi ostavu",
"Download last dump" => "Preuzmi najnoviju ostavu",
"Pictures" => "Slike",
"Remove unused pictures" => "Ukloni nekorišćene slike",
"Export" => "Izvoz",
"Export Wiki Pages" => "Izvoz Wiki strana",
"Link plural WikiWords to their singular forms" => "Linkuj WikiWord u množini sa njihovim formama u jednini",
"Discuss pages on forums" => "Diskutuj o stranama na forumu",
"Structures" => "Strukture",
"Import HTML" => "Uvezi HTML",
"Page creators are admin of their pages" => "Kreatori stranica su administratori tih stranica",
"MultiPrint" => "MultiŠtampa",
"Enable watches on comments" => "Omogući nadgledanje komentara",
"List pages" => "Lista stranica",
"Wiki attachments" => "Wiki prilozi",
"Restore defaults" => "Vrati na podrazumevane vrednosti",
"Contact us" => "Kontaktirajte nas",
"bytes" => "bajtova",
"Statistics" => "Statistike",
"Weeks" => "Nedelja",
"viewed" => "pogledano",
"Add or edit a rule" => "Dodaj ili izmeni pravilo",
"Rule title" => "Naslov pravila",
"Username regex matching" => "Poklapanje sa regexom korisničkih imena",
"IP regex matching" => "IP regex poređenje",
"Banned from sections" => "Zabrana pristupu sekciji",
"Rule activated by dates" => "Pravila aktivirana po datumu",
"Rule active from" => "Pravilo aktivno od",
"Rule active until" => "Pravilo aktivno do",
"Custom message to the user" => "Promenjiva poruka korisniku",
"Rules" => "Pravila",
"User/IP" => "Korisnik/IP",
"Sections" => "Sekcije",
"Admin Calendars" => "Administriraj kalendare",
"List of Calendars" => "Lista kalendara",
"Participants" => "Učesnici",
"Cat" => "Katalog",
"Lang" => "Jezik",
"Url" => "URL",
"Custom Locations" => "Promenjive lokacije",
"Custom Categories" => "Promenjive kategorije",
"Custom Languages" => "Promenjivi jezici",
"Custom Priorities" => "Promenjivi prioriteti",
"Current category" => "Trenutne kategorije",
"Child categories" => "Podkategorije",
"Edit this category:" => "Izmeni ovu kategoriju:",
"Add new category" => "Dodaj novu kategoriju",
"Objects in category" => "Objekti u kategoriji",
"Add objects to category" => "Dodaj objekte kategoriji",
"image gal" => "galerija slika",
"file gal" => "galerija fajlova",
"Admin chart items" => "Administriraj jedinke grafika",
"Edit Chart" => "Izmeni grafik",
"Add or edit an item" => "Dodaj ili promeni stvar",
"Update" => "Obnovi",
"Chart items" => "Stavke u grafiku",
"No items defined yet" => "Zapisi nisu još definisani",
"Add or edit a chart" => "Dodaj ili izmeni grafik",
"Active" => "Aktivan",
"Users can suggest new items" => "Korisnici mogu da predlažu nove stvari",
"Auto validate user suggestions" => "Automatski odobri korisničke predloge",
"Ranking shows" => "Prikazi ocena",
"All items" => "Sve stvari",
"Top 10 items" => "Top 10 stvari",
"Top 20 items" => "Top 20 stvari",
"Top 40 items" => "Top 40 stvari",
"Top 50 items" => "Top 50 stvari",
"Top 100 items" => "Top 100 stvari",
"Top 250 items" => "Top 250 stvari",
"Voting system" => "sistem glasanja",
"Vote items" => "Glasaj za stvar",
"Rank 1..5" => "Ocena 1..5",
"Rank 1..10" => "Ocena 1..10",
"Ranking frequency" => "Učestalost ocenjivanja",
"Realtime" => "Realno vreme",
"Each 5 minutes" => "Svakih 5 minuta",
"Daily" => "Dnevno",
"Weekly" => "Nedeljno",
"Monthly" => "Mesečno",
"Show Average" => "Prikaži prosek",
"Show Votes" => "Prikaži glasove",
"Use Cookies for unregistered users" => "Koristite kolačiće za neregistrovane korisnike",
"Users can vote again after" => "Korisnici mogu ponovo da glasaju nakon",
"Anytime" => "Bilo kada",
"Ranks" => "Ocene",
"No charts defined yet" => "Nijedan grafik nije definisan",
"Admin templates" => "Administriraj šablone",
"Edit this template:" => "Izmeni ovaj šablon:",
"Create new template" => "Napravi novi šablon",
"Use wysiwyg editor" => "Koristi wysiwyg editor",
"Use normal editor" => "Koristi normalan editor",
"Templates" => "Šabloni",
"Settings" => "Podešavanja",
"Admin cookies" => "Admin kolačiće",
"Create/edit cookies" => "Napravi/izmeni kolačiće",
"Upload Cookies from textfile" => "Dodaj kolačiće iz tekstualnog fajla",
"Upload from disk:" => "Upload sa diska:",
"Upload" => "Uploaduj",
"Remove all cookies" => "Ukloni sve kolačiće",
"cookie" => "kolačić",
"Admin drawings" => "Administriraj crteže",
"Available drawings" => "Raspoloživi crteži",
"Ver" => "Ver.",
"Create/edit dsn" => "Napravi/izmeni dsn",
"Admin external wikis" => "Administriraj spoljni Wiki",
"Create/Edit External Wiki" => "Napravi/Izmeni eksterni Wiki",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (koristite \$page da se zameni sa nazivom stranice u URL primeru: http://www.example.com/tiki-index.php?page=\$page)",
"ExtWiki" => "Spoljni tiki",
"Admin Forums" => "Administracija foruma",
"Create new forum" => "Napravi novi forum",
"List forums" => "Lista foruma",
"Edit this Forum:" => "Izmeni ovaj forum:",
"Create New Forum" => "Napravi novi forum",
"There are individual permissions set for this forum" => "Individualne dozvole su podešene za ovaj forum",
"Prevent flooding" => "Spreči poplave poruka",
"Minimum time between posts" => "Minimalno vreme između poruka",
"Section" => "Sekcija",
"Create new" => "Napravi novi",
"Moderator user" => "Moderator",
"Moderator group" => "Moderatorska grupa",
"Password protected" => "Zaštićeno lozinkom",
"Topics only" => "Samo teme",
"All posts" => "Sve poruke",
"Forum password" => "Šifra foruma",
"Send this forums posts to this email" => "Pošalji ovu poruku sa foruma na ovu email adresu",
"Prune unreplied messages after" => "Briši neodgovorene poruke nakon",
"Prune old messages after" => "Briši stare poruke nakon",
"Topic list configuration" => "Podešavanje liste tema",
"Display last post titles" => "Prikaži naslove zadnjih poruka",
"no display" => "nema prikaza",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Prosledi poruke na ovom forumu na ovu e-mail adresu, u formatu koji može da se koristi za slanje nazad na prihvatnu e-mail adresu ovog foruma",
"Originating e-mail address for mails from this forum" => "Izvorna e-mail adresa za poruke sa ovog foruma",
"Add messages from this email to the forum" => "Dodaj poruke iz ovog emaila forumu",
"Use topic smileys" => "Koristi smajlije za teme",
"Show topic summary" => "Prikaži siže teme",
"User information display" => "Prikaz korisničkih informacija",
"Online" => "Uključen",
"Approval type" => "Tip dozvole",
"All posted" => "Sve napisano",
"Queue anonymous posts" => "Stavi na listu čekanja anonimne poruke",
"Queue all posts" => "Stavi sve poruke na list čekanja",
"No attachments" => "Nema priloga",
"Everybody can attach" => "Svi mogu da dodaju fajlove",
"Only users with attach permission" => "Samo korisnici sa attach dozvolom",
"Moderators and admin can attach" => "Moderatori i administratori mogu da dodaju fajlove",
"Store attachments in:" => "Snimi priloge u:",
"Database" => "Baza podataka",
"Max attachment size (bytes)" => "Maksimalna veličina fajlova za dodavanje (bajtovi)",
"Default ordering for topics" => "Podrazumevano sortiranje za poruke",
"Date (desc)" => "Datum (prvo najnovije)",
"Date (asc)" => "Datum (prvo stariji)",
"Score (desc)" => "Ocena (prvo najveće)",
"Replies (desc)" => "Odgovora (prvo najviše)",
"Reads (desc)" => "Čitanja (prvo najviše)",
"Topics per page" => "Poruka po strani",
"Default ordering for threads" => "Podrazumevano sortiranje za teme",
"Age" => "Godine",
"PPD" => "Pnd",
"Admin Hotwords" => "Administriraj aktivne reči",
"Add Hotword" => "Dodaj aktivnu reč",
"Word" => "Reč",
"Admin HTML pages" => "Administracija HTML strana",
"Edit this page" => "Izmeni ovu stranu",
"View page" => "Vidi stranu",
"Edit zone" => "Izmeni zone",
"Dynamic zones" => "Dinamičke zone",
"content" => "sadržaj",
"Mass update" => "Masovna obnova",
"Create new HTML page" => "Napravi novu HTML stranu",
"Edit this HTML page:" => "Izmeni ovu HTML stranu:",
"Apply template" => "Primeni šablon",
"Dynamic" => "Dinamička",
"Static" => "Statička",
"Last Modif" => "Zadnja izmena",
"Edit Repository:" => "Izmeni repozitoriju:",
"Create New Repository" => "Napravi novu repozitoriju",
"List Repositories" => "Lista repozitorija",
"New Repository" => "Nova repozitorija",
"View Repository" => "Vidi repozitorije",
"Human readable repository name" => "Ime repozitorije čitljivo za ljude",
"Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Adresa repozitorije (lokalni fajlsistem: relativni/apsolutni web root, udaljena: sa 'http://' prefiksom)",
"File name of start page" => "Ime fajla početne strane",
"Start page" => "Početna strana",
"CSS file to load when browse this repository" => "CSS fajl za gledanje ove repozitorije",
"CSS file" => "CSS fajl",
"Is repository visible to users" => "Da li je repozitorija vidljiva korisnicima",
"Can files from repository be cached" => "Da li fajlovi iz repozitorije mogu da budu skladišteni",
"Cacheable" => "Skladišteni",
"Are files from repository can be cached" => "Da li fajlovi iz repozitorije mogu da budu skladišteni",
"Clear all cached pages of this repository" => "Obriši sve uskladištene fajlove u ovoj repozitoriji",
"Clear cache" => "Obriši skladište",
"Seconds count 'till cached page will be expired" => "Sekundi do isticanja uskladištene strane",
"Cache expiration" => "Isticanje skladišta",
"Human readable text description of repository" => "Opis repozitorije čitljiv za ljude",
"Available Repositories" => "Slobodne repozitorije",
"CSS File" => "CSS Fajl",
"Edit rules" => "Izmeni pravila",
"Edit Rules for Repository:" => "Izmeni pravila za repozitoriju:",
"Configure Repositories" => "Podesi repozitorije",
"Configure this Repository" => "Podesi ovu repozitoriju",
"View this Repository" => "Vidi ovu repozitoriju",
"New Rule" => "Novo pravilo",
"Copy Rules" => "Kopiraj pravila",
"view/hide copy rules dialog" => "vidi/sakrij dijalog za kopiranje pravila",
"Source repository" => "Izvorna repozitorija",
"Copy" => "Kopiraj",
"According this order rules will be applied ('0' or empty = auto)" => "Pravila će biti primenjena u skladu sa ovim redosledom ('0' ili prazno = automatski)",
"Rule order" => "Redosled pravila",
"Text to search for" => "Tekst za pretragu",
"Text to replace" => "Tekst za zamenu",
"Is this regular expression or simple search/replacer" => "Da li je ovo regularan izraz (regex) ili jednostavna pretraga/zamena",
"Is case sensitive (for simple replacer)" => "Da li zavisi od velikih/malih slova (za jednostavnu pretragu/zamenu)",
"Case sensitive" => "Zavisi od malih/velikih slova",
"subset of chars: imsxeADSXUu, which is regex modifiers" => " podskup karaktera: imsxeADSXUu, koji su regex modifikatori",
"Human readable text description of rule" => "Tekstualni opis pravila pogodan za čitanje",
"Check to enable this rule" => "Overi da bi omogućio ovo pravilo",
"Enabled" => "Omogućeno",
"Preview options" => "Vidi opcije",
"Apply all rules or just this to generate preview" => "Primeni sva pravila ili samo ovo da bi generisao pregled",
"Apply all rules" => "Primeni sva pravila",
"View source code after rules applied" => "Vidi izvorni kod nakon primene pravila",
"Code preview" => "Pregled koda",
"Generate HTML preview" => "Generiši HTML pregled",
"HTML preview" => "HTML pregled",
"Test file from repository to generate preview for (empty = configured start page)" => "Test fajl iz repozitorije za koji se generiše pregled (prazno = startna strana)",
"Preview Results" => "Rezultati pregleda",
"Rules List" => "Lista pravila",
"Admin layout" => "Administriraj raspored",
"Theme control" => "Kontrola tema",
"layout options" => "opcije šablona",
"Generate positions by hits" => "Generiši poziciju po hitovima",
"List of featured links" => "Lista sajtova na prikazu",
"Position" => "Pozicija",
"Add Featured Link" => "Dodaj sajt za prikaz",
"Edit this Featured Link:" => "Izmeni ovaj sajt za prikaz:",
"Create new Featured Link" => "Napravi novi link za sajta za pikaz",
"disables the link" => "menja link",
"Link type" => "Tip linka",
"replace current page" => "zameni trenutnu stranu",
"framed" => "frejmovano",
"open new window" => "otvori u novom prozoru",
"Account name" => "Naziv naloga",
"SMTP requires authentication" => "SMTP zahteva autentikaciju",
"wiki-get" => "wiki-uzmi",
"wiki-put" => "wiki-stavi",
"wiki-append" => "wiki-dodaj",
"Admin Topics" => "Admin Teme",
"Admin Types" => "Administriraj tipove",
"List menus" => "Listaj menije",
"Edit this menu" => "Promeni ovaj meni",
"Edit menu options" => "Izmeni opcije menija",
"Some useful URLs" => "Neki korisni linkovi",
"option" => "opcije",
"Choose" => "Odaberi",
"Home Blog" => "Glavni blog",
"Home Image Gal" => "Glavna galerija slika",
"Home Image Gallery" => "Glavna galerija slika",
"Home File Gal" => "Glavna galerija fajlova",
"Home File Gallery" => "Glavna galerija fajlova",
"User preferences" => "Korisnička podešavanja",
"User prefs" => "Korisnička podešavanja",
"List galleries" => "Lista galerija",
"List image galleries" => "Lista galerija slika",
"Upload image" => "Uploaduj sliku",
"Gallery Rankings" => "Rangiranje galerija",
"Browse a gallery" => "Razgledaj galeriju",
"Articles home" => "Glavna strana članaka",
"All articles" => "Svi članci",
"Submit" => "Pošalji",
"List Blogs" => "Listaj blogove",
"Create blog" => "Napravi blog",
"File galleries" => "Galerije fajlova",
"View a forum" => "Vidi forum",
"View a thread" => "Vidi temu",
"View a FAQ" => "Vidi FAQ",
"Take a quiz" => "Uzmi kviz",
"Quiz stats" => "Statistike kvizova",
"Stats for a Quiz" => "Statistike kviza",
"Preview menu" => "Pogledaj meni",
"Menu options" => "Opcije menija",
"Edit this Menu:" => "Izmeni ovaj meni:",
"Create new Menu" => "Napravi novi meni",
"dynamic collapsed" => "dinamički zatvoren",
"dynamic extended" => "dinamički otvoren",
"fixed" => "fiksiran",
"Options" => "Opcije",
"Clear Cache" => "Obriši skladište",
"User Modules" => "Korisnički moduli",
"Assigned Modules" => "Dodeljeni moduli",
"Left Modules" => "Levi moduli",
"Rows" => "Redova",
"Move to Right Column" => "Pomeri u desnu kolonu",
"Unassign" => "Oduzmi",
"Right Modules" => "desni moduli",
"Move to Left Column" => "Pomeri u levu kolonu",
"Assign new module" => "Dodeli novi modul",
"Edit this assigned module:" => "Izmeni ovaj dodeljeni modul:",
"Cache Time" => "Vreme keširanja",
"Visibility" => "Vidljivost",
"Displayed now for all eligible users even with personal assigned modules" => "Prikazano sada za sve odgovarajuće korisnike čak i ako imaju lično dodeljen module",
"Displayed for the eligible users with no personal assigned modules" => "Prikazano za odgovarajuće korisnike bez lično dodeljenih modula",
"Displayed now, can't be unassigned" => "Prikazano sada, ne može da se isključi",
"Not displayed until a user chooses it" => "Nije prikazano dok korisnik ne odabere da prikaže",
"Create new user module" => "Napravi novi",
"Edit this user module:" => "Izmeni ovaj korisnički modul:",
"Objects that can be included" => "Objekti koji mogu da se dodaju",
"Available polls" => "Raspoloživi upitnici",
"Use Poll" => "Koristi upitnik",
"Random image from" => "Slučajna slika iz",
"Use Gallery" => "Koristi galeriju",
"Dynamic content blocks" => "Blokovi sa dinamičkim sadržajem",
"Use Dynamic Content" => "Koristi dinamički sadržaj",
"Use RSS Module" => "Koristi rss module",
"Use Menu" => "Koristi meni",
"Banner zones" => "Zone oglasa",
"Use Banner Zone" => "Koristi zone oglasa",
"Data" => "Podaci",
"Admin newsletter subscriptions" => "Administriraj prijave novinama",
"List Newsletters" => "Lista novina",
"Admin Newsletters" => "Administriraj novine",
"Send Newsletters" => "Šalji novine",
"Add a subscription newsletters" => "Dodaj pretplatne novine",
"Subscriptions" => "Pretplate",
"Valid" => "Ispravan",
"Subscribed" => "pretplaćen",
"Admin newsletters" => "Administriraj novine",
"There are individual permissions set for this newsletter" => "Postoje individualne dozvole podešene za ove novine",
"Users can subscribe/unsubscribe to this list" => "Korisnici mogu da se pretplate/isključe sa ove liste",
"Users can subscribe any email address" => "Korisnici mogu da upišu bilo koju email adresu",
"Add unsubscribe instructions to each newsletter" => "Dodaj informacije o prekidanju pretplate u svake novine",
"Validate email addresses" => "Proveri email adrese",
"Editions" => "Izdanja",
"Last Sent" => "Zadnje poslate",
"Add notification" => "Dodaj obaveštenje",
"Event" => "Slučaj",
"A user registers" => "Korisnik se registruje",
"A user submits an article" => "Korisnik je predložio članak",
"Any wiki page is changed" => "Bilo koja strana je promenjena",
"List polls" => "Lista upitnika",
"Edit this poll" => "Izmeni ovaj upitnik",
"Preview poll" => "Pogledaj upitnik",
"Option" => "Opcije",
"Poll options" => "Opcije upitika",
"Votes" => "Glasova",
"Admin Polls" => "Administriraj upitnike",
"Set last poll as current" => "Postavi zadnji upitnik kao trenutni",
"Close all polls but last" => "Zatvori sve upitnike osim poslednje",
"Activate all polls" => "Aktiviraj sve upitnike",
"active" => "aktivan",
"current" => "trenutni",
"template" => "šablon",
"object" => "objekat",
"PublishDate" => "DatumObjavljivanja",
"Results" => "Rezultati",
"Admin Quicktags" => "Administriraj Quicktags",
"Create/Edit QuickTags" => "Napravi/Izmeni QuickTags",
"Insert (use 'text' for figuring the selection)" => "Ubaci (koristite 'text' da bi pronašli selekciju)",
"Path to the tag icon" => "Adresa do tag ikone",
"Admin RSS Modules" => "Administriraj RSS module",
"Content for the feed" => "Sadržaj izvora",
"show feed title" => "prikaži naslov izvora",
"show publish date" => "prikaži datum objavljivanja",
"user" => "Korisnik",
"group" => "grupa",
"sticky" => "važno",
"Destroy the structure leaving the wiki pages" => "Uništi strukturu ostavljajući strane",
"Destroy the structure and remove the pages" => "Uništi strukturu i ukloni strane",
"Export Pages" => "Izvezi strane",
"Dump Tree" => "Prebaci na ostavu drvo",
"Create WebHelp" => "Napravi WebPomoć",
"View WebHelp" => "Vidi webpomoć",
"Create new structure" => "Napravi nove strukture",
"Alias" => "Alijas",
"Tree" => "Drvo",
"Use single spaces to indent structure levels" => "Koristi jedan razmak za pravljenje podnivoa",
"Create New Structure" => "Napravi novu strukturu",
"List surveys" => "Lista anketa",
"Survey Stats" => "Statistike anketa",
"Edit this Survey" => "Izmeni ovu anketu",
"Admin Surveys" => "Administracija anketa",
"Question" => "Pitanje",
"One choice" => "Jedan izbor",
"Multiple choices" => "Višestruki izbor",
"Short text" => "Kratak tekst",
"Rate (1..5)" => "Ocena (1..5)",
"Rate (1..10)" => "Ocena (1..10)",
"Rate" => "Oceni",
"Options (if apply)" => "Opcije (ako odabere)",
"Questions" => "Pitanja",
"Admin surveys" => "Administriraj anketu",
"List Surveys" => "Lista anketa",
"Edit this Survey:" => "Izmeni ovu anketu:",
"There are individual permissions set for this survey" => "Individualne dozvole su podešene za ovu anketu",
"Open" => "Otvorena",
"Create a new topic" => "Napravi novu temu",
"Topic Name" => "Naslov teme",
"Upload Image" => "Dodaj sliku",
"List of topics" => "Lista tema",
"Articles (subs)" => "Članci (prilozi)",
"topic image" => "slika teme",
"Deactivate" => "Deaktiviraj",
"List Trackers" => "Lista trakera",
"Admin Trackers" => "Administracija trakera",
"Edit This Tracker" => "Izmeni ovaj traker",
"View This Tracker's Items" => "Vidi zapise ovog trakera",
"Edit tracker field" => "Izmeni polja u trakeru",
"Is column visible when listing tracker items?" => "Da li je kolona vidljiva na listi zapisa?",
"Column links to edit/view item?" => "Kolona vodi ka izmeni/pregledu zapisa?",
"Tracker fields" => "Polja trakera",
"isMain" => "je glavni",
"Tbl vis" => "Vidljiva",
"Found" => "Nađeno",
"trackers" => "trakeri",
"There are individual permissions set for this tracker" => "Individualne dozvole su podešene za ovaj traker",
"No individual permissions. Global permissions apply." => "Nema individualnih dozvola. Koriste se globalne dozvole.",
"Show creation date when listing tracker items?" => "Prikaži datum pravljenja na spisku zapisa trakera?",
"Show lastModif date when listing tracker items?" => "Prikaži zadnji datum menjanja na spisku zapisa trakera?",
"Tracker items allow comments?" => "Dozvoljeni komentari za zapise trakera?",
"Tracker items allow attachments?" => "Dozvoljeno prikačivanje fajlova za zapise trakera?",
"Filesize" => "Veličina fajla",
"Admin groups" => "Administriraj grupe",
"Admin users" => "Admin korisnika",
"Add new group" => "Dodaj novu grupu",
"List of existing groups" => "Lista postojećih grupa",
"Includes" => "Uključuju",
"Edit Item" => "Izmeni zapis",
"Add a New User" => "Dodaj novog korisnika",
"Rejected users" => "Odbijeni korisnici",
"Reason" => "Razlog",
"to groups" => "grupi",
"Overwrite" => "Prebrisavanje",
"Admin Article Types" => "Administriraj tipove članaka",
"List of types" => "Lista tipova",
"Show before publish date" => "Prikaži pre datuma objavljivanja",
"Show after expire date" => "Prikaži nakon datuma isticanja",
"Heading only" => "Samo zaglavlje",
"Comment Can Rate Article" => "Komentar može da oceni članak",
"Show image" => "Prikaži sliku",
"Show avatar" => "Prikaži avatara",
"Show author" => "Prikaži autora",
"Show publish date" => "Prikaži datum objavljivanja",
"Show expire date" => "Prikaži datum isticanja",
"Show reads" => "Prikaži broj čitanja",
"Show size" => "Prikaži veličinu",
"Creator can edit" => "Kreator može da menja",
"Create a new type" => "Napravi novi tip",
"Group Information" => "Informacije o grupi",
"level" => "nivo",
"Create level" => "Napravi nivo",
"all permissions in level" => "sve dozvole u nivou",
"Default Group" => "Podrazumevana grupa",
"backlinks to" => "rekurzivni linkovi na",
"No backlinks to this page" => "Nema rekurzivnih linkova do ove stranice",
"Browse Gallery" => "Gledaj galeriju",
"Upload From Disk" => "Dodaj sa hard diska",
"Process" => "Proces",
"Edit Post" => "Izmeni poruku",
"View Blog" => "Vidi blog",
"Use ...page... to separate pages in a multi-page post" => "koristite ...page... da bi razdvojili strane u višestranoj poruci",
"Upload image for this post" => "Uploaduj sliku za ovu poruku",
"Trash" => "Smeće",
"Spellcheck" => "Provera pravopisa",
"Save and Exit" => "Snimi i izađi",
"Made with" => "Napravljeno uz pomoć",
"powered by" => "osnaženo sa",
"Execution time" => "Vreme izvršavanja",
"Memory usage" => "Korišćena memorija",
"Server load" => "Opterećenje servera",
"Clear" => "Obriši",
"Edit Gallery" => "Izmeni galeriju",
"Rebuild Thumbnails" => "Ponovo napravi smanjene slike",
"List Gallery" => "Lista galerija",
"Sort Images by" => "Sortiraj slike po",
"Original Size" => "Orginalna veličina",
"rotate right" => "rotiraj udesno",
"rotate" => "rotiraj",
"Return to Gallery" => "Vrati se na galeriju",
"Edit Image" => "Izmeni sliku",
"First Image" => "Prva slika",
"Prev Image" => "Prošla slika",
"Smaller" => "Manje",
"Bigger" => "Veće",
"Popup window" => "Popup prozor",
"Next Image" => "Sledeća slika",
"Last Image" => "Zadnja slika",
"Image Name" => "Naziv Slike",
"Image Scale" => "Skalaslike",
"Move image" => "Pomeri slike",
"You can view this image in your browser using" => "Ovu sliku možete videti u vašem browseru koristeći",
"Stop Monitoring this Page" => "Prestani sa nadgledanjem ove strane",
"Monitor this Page" => "Nadgledaj ovu stranu",
"Group Calendars" => "Grupni kalendari",
"Organized by" => "Organizovano po",
"Tentative" => "Probni",
"Confirmed" => "Potvrđen",
"Cancelled" => "Prekinuto",
"Edit Calendar Item" => "Izmeni zapis u kalendaru",
"New Calendar Item" => "Novo u kalendaru",
"times" => "puta",
"End" => "Kraj",
"Roles" => "Uloge",
"import" => "uvezi",
"Previous" => "Prošli",
"Assign permissions" => "Dodeli dozvole",
"to group" => "grupi",
"Change password enforced" => "Forsirana promena lozinke",
"Change your password" => "Promeni lozinku",
"Old password" => "Stara lozinka",
"Send a message to us" => "Pošaljite nam poruku",
"Contact us by email" => "Kontaktirajte nas emailom",
"Contacts" => "Kontakti",
"Create/edit contacts" => "Napravi/izmeni kontakte",
"First Name" => "Ime",
"Last Name" => "Prezime",
"Nickname" => "Nadimak",
"You can browse the generated WebHelp here" => "Možete da pogledate generisanu WebPomoć ovde",
"Structure" => "Struktura",
"Top page" => "Gornja strana",
"Tiki Debugger Console" => "Tiki debuger konzola",
"Current URL" => "Trenutni URL:",
"Command" => "Komanda",
"exec" => "pokreni",
"Type <code>help</code> to get list of available commands" => "Kucajte <code>help</code> da bi dobili listu mogućih komandi",
"Add a new site" => "Dodaj novi sajt",
"Site added" => "Sajt dodat",
"Directory Administration" => "Administracija direktorijuma",
"There are" => "Ima",
"invalid sites" => "neispravni sajtovi",
"valid sites" => "ispravni sajtovi",
"Users have visited" => "Korisnici su posetili",
"sites from the directory" => "sajtovi iz direktorijuma",
"Users have searched" => "Korisnici su pretraživali",
"times from the directory" => "puta iz direktorijuma",
"Related" => "Povezani",
"Validate" => "Proveri",
"Admin directory categories" => "Administriraj kategorije direktorijuma",
"Add a directory category" => "Dodaj kategoriju direktorijuma",
"Edit this directory category" => "Izmeni ovu kategoriju direktorijuma",
"Children type" => "Tip dece",
"Most visited sub-categories" => "Najčešće posećivane pod kategorije",
"Category description" => "Opis kategorije",
"Random sub-categories" => "Slučajne podkategorije",
"Maximum number of children to show" => "Maksimalana broj dece za prikaz",
"Editor group" => "Grupa urednika",
"cType" => "cTip",
"allow" => "dozvoli",
"count" => "broj",
"editor" => "urednik",
"relate" => "srodi",
"Parent category" => "Kategorija roditelj",
"Add a related category" => "Dodaj srodnu kategoriju",
"Mutual" => "Zajednička",
"Related categories" => "Srodne kategorije",
"Admin sites" => "Administriraj sajtove",
"Is valid" => "je ispravna",
"New Sites" => "Novi sajtovi",
"Cool Sites" => "Cool sajtovi",
"Add a Site" => "Dodaj sajt",
"any" => "bilo koji",
"in entire directory" => "u celom direktorijumu",
"Sort by" => "Sortiraj po",
"name (desc)" => "ime (A-Z)",
"name (asc)" => "ime (Z-A)",
"hits (desc)" => "pogleda (prvo najviše)",
"hits (asc)" => "pogleda (prvo najmanje)",
"creation date (desc)" => "datum pravljenja (prvo najnovije)",
"creation date (asc)" => "datum pravljenja (prvo najstarije)",
"last updated (desc)" => "datum izmene (prvo najnovije)",
"last updated (asc)" => "datum izmene (prvo najstarije)",
"Added" => "Dodato",
"Last updated" => "Zadnji put obnovljeno",
"Total links" => "Ukupno linkova",
"Links to validate" => "Linkovi za proveru",
"Searches performed" => "Izvršeno pretraga",
"Total links visited" => "Ukupno linkova posećeno",
"Directory ranking" => "Rangiranje direktorijuma",
"Search results" => "Rezultati pretrage",
"Validate sites" => "Proveri sajtove",
"Edit article" => "Izmeni članak",
"List Articles" => "Lista članaka",
"View Articles" => "Vidi članke",
"Author Name" => "Ime autora",
"Own Image" => "Sopstvena slika",
"Article image" => "Slika članka",
"Use own image" => "Koristi sopstvenu slike",
"Float text around image" => "Tekst neka obilazi oko slike",
"Own image size x" => "Širina sopstvene slike",
"Own image size y" => "Visina sopstvene slike",
"Heading" => "Zaglavlje",
"Body" => "Telo",
"Publish Date" => "Datum objavljivanja",
"Expiration Date" => "Datum isticanja",
"From:" => "Od:",
"Edit or create banners" => "Izmeni ili napravi oglase",
"List banners" => "Lista oglasa",
"URL to link the banner" => "URL za oglas",
"Client" => "Klijenti",
"Max impressions" => "Maksimalno pogleda",
"Show the banner only between these dates" => "Prikaži baner samo između ovih datuma",
"From date" => "Od dana",
"To date" => "Do dana",
"Use dates" => "Koristi datume",
"Show the banner only in this hours" => "Prikaži baner samo u ovim satima",
"to" => "do",
"Show the banner only on" => "Prikaži oglas samo na",
"Mon" => "Pon",
"Tue" => "Uto",
"Wed" => "Sre",
"Thu" => "Čet",
"Fri" => "Pet",
"Sat" => "Sub",
"Sun" => "Ned",
"Select ONE method for the banner" => "Odaberi JEDAN od metoda za baner",
"Use HTML" => "Koristi HTML",
"Use image" => "Koristi sliku",
"Image:" => "Slika:",
"Current Image" => "Trenutna slika",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Koristi sliku koju generiše URL (sliku će generisati određeni URL za svaki pogled posebno)",
"Use text" => "Koristi tekst",
"Save the Banner" => "Snimi oglas",
"Remove Zones (you lose entered info for the banner)" => "Ukloni zone (gubiš podatke koje si uneo za baner)",
"Current heading" => "Trenutno zaglavlje",
"There are individual permissions set for this blog" => "Individualne dozvole su podešene za ovaj blog",
"Number of posts to show" => "Broj poruka za prikaz",
"Allow other user to post in this blog" => "Dozvoli ostalim korisnicima da pišu u ovom blogu",
"Use titles in blog posts" => "Koristi naslove u blog porukama",
"Allow search" => "Dozvoli pretragu",
"Allow comments" => "Dozvoli komentare",
"Blog heading" => "Zaglavlje bloga",
"Edit Style Sheet" => "Izmeni stranu sa stilovima",
"Style Sheet" => "Strana sa stilovima",
"choose a stylesheet" => "odaberi stranu sa stilovima",
"Try" => "Pokušaj",
"Wiki Help" => "Wiki pomoć",
"Colored text" => "Obojen tekst",
"Box content" => "Sadržaj okvira",
"Dynamic variables" => "Dinamičke varijable",
"Inserts an editable variable" => "Ubacuje promenjivu",
"External links" => "Externi linkovi",
"Wiki References" => "Wiki referense",
"JoinCapitalizedWords or use" => "SpojiteKapitalizovaneReči ili koristite",
"page|description" => "strana|opis",
"for wiki references" => "za wiki referense",
"SomeName" => "NekoIme",
"prevents referencing" => "isključi referense",
"Lists" => "Liste",
"for bullet lists" => "za obične liste",
"for numbered lists" => "za numerisane liste",
"for definiton lists" => "za liste definicija",
"Tables" => "Tabele",
"Title bar" => "Naslov",
"creates the editable drawing foo" => "pravi crtež pod imenom foo koji možete izmeniti",
"Multi-page pages" => "Više-strane strane",
"Non parsed sections" => "Sekcija koja se ne parsira",
"No description available" => "Nema opisa",
"external link" => "spoljni link",
"special chars" => "specijalni karakteri",
"special characters" => "specijalni karakteri",
"Edit successful!" => "Izmena uspešna",
"The following image was successfully edited" => "Sledeća slika je uspešno izmenjena",
"Image Description" => "Opis Slike",
"Edit and create Languages" => "Izmeni i napravi jezike",
"Edit and create languages" => "Izmeni i napravi jezike",
"Create Language" => "Napravi jezik",
"Shortname" => "Kratko ime",
"like" => "kao",
"Longname" => "Dugačko ime",
"Select the language to edit" => "Odaberite jezik za izmenu",
"Add a translation" => "Dodaj prevod",
"Edit translations" => "Izmeni prevod",
"Translate recorded" => "Prevedi snimljeno",
"Translation" => "Prevod",
"reset table" => "resetuj tabelu",
"Create New Block" => "Napravi novi blok",
"Return to block listing" => "Nazad na listu blokova",
"Block description: " => "Opis bloka: ",
"You are editing block:" => "Menjate blok:",
"Publishing date" => "Datum objavljivanja",
"Publishing Date" => "Datum objavljivanja",
"Edit question options" => "Izmeni opcije pitanja",
"List Quizzes" => "Lista kvizova",
"Quiz Stats" => "Statistike kviza",
"This Quiz Stats" => "Statistike ovog kviza",
"Edit this Quiz" => "Izmeni ovaj kviz",
"Admin Quizzes" => "Administracija kvizova",
"Create/edit options for question" => "Napravi/izmeni opcije za pitanja",
"Create/edit quizzes" => "Napravi/izmeni kvizove",
"There are individual permissions set for this quiz" => "Postoje individualne dozvole za ovaj kviz",
"Quiz can be repeated" => "Kviz može da se ponavlja",
"Store quiz results" => "Snimi rezultate kviza",
"Questions per page" => "Pitanja po strani",
"Quiz is time limited" => "Kviz je vremenski ograničen",
"Maximum time" => "Maksimalno vreme",
"Quiz" => "Kviz",
"canRepeat" => "može ponoviti",
"timeLimit" => "vremenski limit",
"Edit quiz questions" => "Izmeni pitanja u kvizu",
"Create/edit questions for quiz" => "Napravi/izmeni pitanja za kviz",
"maxScore" => "maksimalan broj poena",
"From Points" => "Od poena",
"To Points" => "Do poena",
"Answer" => "Odgovor",
"Modify Structure" => "Izmeni strukturu",
"You will remove" => "Obrisaćete",
"and its subpages from the structure, now you have two options:" => "i njene podstrane iz strukture, sada imate dve opcije:",
"Remove only from structure" => "Obrišite samo iz strukture",
"Remove from structure and remove page too" => "Obrišite iz strukture i uklonite stranu",
"Structure Layout" => "Izgled strukture",
"Promote" => "Unapredi",
"Demote" => "Demotiraj",
"Current Node" => "Trenutni nod",
"Page alias" => "Alijas strane",
"Add pages to current node" => "Dodaj strane u trenutni nod",
"After page" => "Nakon strane",
"Create Page" => "Napravi stranu",
"Use pre-existing page" => "Koristi postojeću stranu",
"Submit article" => "Priloži članak",
"List Submissions" => "Lista predloga",
"Edit templates" => "Izmeni šablone",
"Template listing" => "Lista šablona",
"Available templates" => "Šabloni na raspolaganju",
"Edit a topic" => "Izmeni temu",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "Igraonica je strana na kojoj možete da vežbate vašu umešnost u pravljenju strana i koristite pregled da bi videli krajnji izgled stranice, ali se ništa ne snima za kasnije.",
"Admin Content Templates" => "Administriraj šablone sadržaja",
"votes" => "glasova",
"Year:" => "Godina:",
"Authors:" => "Autori:",
"Try to convert HTML to wiki" => "Pokušaj da konvertuješ HTML u wiki",
"Import page" => "Uvezi stranu",
"export all versions" => "izvezi sve verzije",
"Upload picture" => "Upload slike",
"License" => "Licenca",
"Important" => "Važno",
"lastModif" => "zadnja promena",
"Dump" => "Ostava",
"Admin FAQ" => "Administriraj FAQ",
"List FAQs" => "Lista FAQ",
"View FAQ" => "Vidi FAQ",
"Edit this FAQ" => "Izmeni ovaj FAQ",
"New Question" => "Novo pitanje",
"Use a question from another FAQ" => "Koristi pitanje iz drugog FAQ",
"FAQ questions" => "FAQ pitanja",
"Suggested questions" => "Predložena pitanja",
"No suggested questions" => "Nema predloženog pitanja",
"Upload File" => "Dodaj fajl",
"View tpl" => "Vidi šablon",
"You can access the file gallery using the following URL" => "Fajl galeriji možete pristupiti preko sledećeg URL",
"Admin forums" => "Admin forume",
"Edit queued message" => "Izmene poruke na čekanju",
"make this a thread of" => "napravi nit od",
"None, this is a thread message" => "Nema, ovo je poruka u niti",
"summary" => "siže",
"normal" => "normalan",
"announce" => "proglas",
"hot" => "vrelo",
"no feeling" => "nema osećanja",
"frown" => "mrk pogled",
"exclaim" => "uzvikni",
"idea" => "ideja",
"neutral" => "neutralan",
"question" => "pitanje",
"sad" => "žalostan",
"happy" => "radosno",
"wink" => "namigni",
"Save and Approve" => "Snimi i dozvoli",
"convert to topic" => "pretvori u temu",
"List of messages" => "Lista poruka",
"New Topic" => "Nova tema",
"no summary" => "nema sižea",
"No messages queued yet" => "Nema poruka na čekanju",
"Last Post" => "Zadnja poruka",
"Reported by" => "Prijavio",
"Accept" => "Prihvati",
"Activity completed" => "Aktivnost završena",
"Admin process activities" => "Administriraj aktivnosti procesa",
"Add or edit an activity" => "Dodaj ili izmeni aktivnost",
"activity" => "aktivnost",
"split" => "razdvoj",
"join" => "pridruži se",
"standalone" => "samostalan",
"interactive" => "interaktivan",
"auto routed" => "autorutiran",
"Hours" => "Sati",
"Add transitions" => "Dodaj prelaze",
"Add transition from:" => "Dodaj prelaz iz:",
"Add transition to:" => "Dodaj prelaz na:",
"No roles associated to this activity" => "Uloge nisu dodeljene ovoj aktivnosti",
"Add Role" => "Dodaj ulogu",
"Add New" => "Dodaj novo",
"Process activities" => "Aktivnosti procesa",
"Routing" => "Rutiranje",
"Interactive" => "interaktivan",
"Automatic" => "Automatski",
"Auto routed" => "Autorutiran",
"Manual" => "Uputstvo",
"route" => "rutiraj",
"(no roles)" => "(nema uloga)",
"No activities defined yet" => "Još nisu definisane aktivnosti",
"Process Transitions" => "Tranzicije procesa",
"List of transitions" => "Lista prelaza",
"Origin" => "Poreklo",
"No transitions defined yet" => "Još nisu definisane tranzicije",
"Add a transition" => "Dodaj prelaz",
"This process is invalid" => "Ovaj proces je neispravan",
"List of processes" => "Lista procesa",
"Inactive" => "Neaktivan",
"act" => "uloga",
"Active Process" => "Aktivni procesi",
"Invalid Process" => "Neispravan proces",
"Valid Process" => "Ispravni proves",
"Activities" => "Aktivnosti",
"New Minor" => "Nova manja",
"New Major" => "Nova glavna",
"No processes defined yet" => "Procesi nisu još definisani",
"Admin instance" => "Administriraj instance",
"Process:" => "Proces:",
"Instance" => "Instanca",
"Workitems" => "Radne jedinice",
"exception" => "izuzetak",
"completed" => "završeno",
"Aborted" => "Prekinut",
"Owner" => "Vlasnik",
"Send all to" => "Pošalji sve",
"Don't move" => "Ne pomeraj",
"Started" => "Počeo",
"Act status" => "Status uloge",
"Property" => "Osobina",
"Add property" => "Dodaj osobinu",
"run instance" => "pokreni instancu",
"Admin processes" => "Administriraj procese",
"Galaxia Admin Processes" => "Galaxia administracija procesa",
"Galaxia Admin Processes tpl" => "Galaxia Administriraj procese tpl",
"Add or edit a process" => "Dodaj ili izmeni proces",
"Process Name" => "Ime procesa",
"ver:" => "verzija:",
"is active?" => "je aktivno?",
"Or upload a process using this form" => "Ili uploadujte proces koristeći ovu formu",
"Admin process roles" => "Administriraj uloge procesa",
"Add or edit a role" => "Dodaj ili izmeni ulogu",
"Process roles" => "Uloge procesa",
"No roles defined yet" => "Uloge nisu još definisane",
"Map users to roles" => "Mapiraj korisnike sa ulogama",
"map" => "mapa",
"Map groups to roles" => "Mapiraj grupe sa ulogama",
"Operation" => "Operacija",
"No roles are defined yet so no roles can be mapped" => "Nijedna uloga još nije definisana, i zato se uloge još ne mogu mapirati",
"List of mappings" => "Lista mapiranja",
"No mappings defined yet" => "Mapiranja nisu još definisana",
"Admin process sources" => "Administriraj izvore procesa",
"select source" => "odaberi izvor",
"Shared code" => "Deljeni kod",
"Set next user" => "Postavi sledećeg korisnika",
"Get property" => "Uzmi vrednost",
"Set property" => "Postavi osobinu",
"Process form" => "Forma procesa",
"Set Next act" => "Postavi sledeću ulogu",
"Switch construct" => "Switch konstrukt",
"Map process roles" => "Mapiraj uloge procesa",
"Admin Processes" => "Administriraj procese",
"Admin Activities" => "Admin aktivnosti",
"Admin Roles" => "Aministriraj uloge",
"Edit this Process" => "Izmeni ovaj proces",
"Monitor Activities" => "Nadgledaj aktivnosti",
"Galaxia Monitor Activities" => "Galaxia aktivnosti monitora",
"Galaxia Monitor Activities tpl" => "Galaxia prati aktivnosti tpl",
"List of activities" => "Lista aktivnosti",
"routing" => "rutiranje",
"Instances" => "instance",
"run" => "pokreni",
"run activity" => "pokreni aktivnost",
"Monitor" => "Nadgledaj ",
"monitor processes" => "nadgledaj procese",
"monitor activities" => "nadgledaj aktivnosti",
"monitor instances" => "nadgledaj instance",
"monitor workitems" => "nadgledaj radne jedinice",
"Monitor Instances" => "Nadgledaj instance",
"Galaxia Monitor Instances" => "Instance Galaksija Monitora",
"Galaxia Monitor Instances tpl" => "Galaxia prati instance tpl",
"List of instances" => "Lista instanci",
"No instances created yet" => "Instance nisu još napravljene",
"Monitor Processes" => "Nadgledaj procese",
"Galaxia Monitor Processes" => "Galaxia procesi monitora",
"Galaxia Monitor Processes tpl" => "Galaxia prati procese tpl",
"processes" => "procesi",
"being run" => "pokrenuto",
"Completed" => "Završeno",
"Exceptions" => "Izuzetci",
"Monitor workitems" => "Nadgledaj radne jedinice",
"List of workitems" => "Lista radnih jedinica",
"instance" => "instanca",
"exception instance" => "instanca izuzetka",
"exceptions instance" => "instanca izuzetka",
"Send Instance" => "Pošalji instancu",
"abort instance" => "prekini instancu",
"grab instance" => "uhvati instancu",
"release instance" => "objavi instancu",
"User Activities" => "Korisničke aktivnosti",
"Galaxia User Activities" => "Galaxia korisničke aktivnosti",
"Galaxia User Activities tpl" => "Galaxia korisničke aktivnosti tpl",
"process" => "proces",
"user processes" => "Korisnički procesi",
"user activities" => "korisničke aktivnosti",
"user instances" => "Korisničke instance",
"User Instances" => "Korisničke instance",
"Galaxia User Instances" => "Galaxia korisničke instance",
"Galaxia User Instances tpl" => "Galaxia korisničke instance tpl",
"Inst Status" => "Status instance",
"No instances defined yet" => "Instance nisu još definisane",
"User Processes" => "Korisnički procesi",
"Galaxia User Processes" => "Galaxia korisnički procesi",
"Galaxia User Processes tpl" => "Galaxia korisnički procesi tpl",
"Browsing Workitem" => "Gledanje poslovne jedinice",
"Workitem information" => "",
"Galleries" => "Galerije",
"Create New Gallery" => "Napravi novu galeriju",
"Create a gallery" => "Napravi galeriju",
"Edit this gallery:" => "Izmeni ovu galeriju:",
"There are individual permissions set for this gallery" => "Individualne dozvole su podešene za ovu galeriju",
"Available scales" => "Skale na raspolaganju",
"No scales available" => "Nema nijedna skala",
"Other users can upload images to this gallery" => "Ostali korisnici mogu da dodaju slike ovoj galeriji",
"You can access the gallery using the following URL" => "Možete da pristupite galeriji pomoću sledećeg URL",
"Available Galleries" => "Galerije",
"Imgs" => "Slika",
"Im- Export languages" => "Importuj/Eksportuj jezike",
"Select the language to Import" => "Odaberi jezik za importovanje",
"Select the language to Export" => "Odaberi jezik za eksportovanje",
"Overwrite existing pages if the name is the same" => "Prebriši postojeće strane ako strana sa istim imenom postoji",
"Previously remove existing page versions" => "Prvo ukloni postojeće verzije strana",
"excerpt" => "isečak",
"Result" => "Rezultati",
"Locked" => "Zaključano",
"Configure General Settings" => "Generalna podešavanja",
"Clear cached version and refresh cache" => "Obriši uskladištenu verziju i osveži skladište",
"configure rules" => "podesi pravila",
"Edit Repository" => "Promeni repozitoriju",
"Last Changes" => "Zadnje promene",
"Search by Date" => "Traži po datumu",
"LastChanges" => "ZadnjeIzmene",
"Rollback" => "Vrati",
"Pages like" => "Strane kao",
"No pages found" => "Nije pronađena nijedna strana",
"Edit New Article" => "Izmeni novi članak",
"View Submissions" => "Vidi priloge",
"ExpireDate" => "Datum isticanja",
"AuthorName" => "ImeAutora",
"Create banner" => "Napravi oglas",
"Method" => "Metode",
"Use Dates?" => "Koristi datume?",
"Max Impressions" => "Maskimalno prikaza",
"Impressions" => "Prikaza",
"Clicks" => "Klikova",
"Create New Blog" => "Napravi novi blog",
"Use cache for external pages" => "Koristi skladište za spoljne strane",
"Dynamic content system" => "Sistem dinamičkih sadržaja",
"Available content blocks" => "Raspoloživi blokovi sadržaja",
"Current ver" => "Trenutna verzija",
"Next ver" => "Sledeća verzija",
"Edit this FAQ:" => "Izmeni ovaj FAQ:",
"Create new FAQ" => "Napravi novi FAQ",
"Create New FAQ:" => "Napravi novi FAQ:",
"Users can suggest questions" => "Korisnici mogu da predlažu pitanja",
"Available FAQs" => "Raspoloživi FAQ",
"Create a File Gallery" => "Napravi galeriju fajlova",
"Gallery Images" => "Slike u galeriji",
"All games are from" => "Sve igre su iz",
"visit the site for more games and fun" => "posetite sajt za još igara i zabave",
"Upload a game" => "Uploaduj igru",
"Upload a new game" => "Uploaduj novu igru",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Smanjene slike (ako se igra zove foo.swf smanjena slika mora da se zove foo.swf.gif ili foo.swf.png ili foo.swf.jpg)",
"Edit game" => "Izmeni igru",
"Played" => "Odigrana",
"If you can't see the game then you need a flash plugin for your browser" => "Ako nemožete da vidite igru potreban vam je flash plugin za vaš browser",
"Edit Blog" => "Izmeni Blog",
"Blog Title" => "Naslov bloga",
"Edit New Submission" => "Izmeni nove priloge",
"Survey stats" => "Statistike anketa",
"List Movies" => "Izlistaj Filmove",
"Choose a movie" => "Izaberi film",
"Last mod" => "Zadnja izmena",
"Last author" => "Zadnji autor",
"Last version" => "Zadnja verzija",
"unlocked" => "odključan",
"Open client window" => "Otvori klijentski prozor",
"Generate HTML" => "Napravi HTML",
"Transcripts" => "Transkripti",
"Online operators" => "Uključeni operatori",
"Accepted requests" => "Prihvaćeni zahtevi",
"since" => "od",
"transcripts" => "Transkripti",
"Offline operators" => "Isključeni operatori",
"Add an operator to the system" => "Dodaj operatora sistemu",
"Operators must be tiki users" => "Operatori moraju biti tiki korisnici",
"Set as Operator" => "Postavi kao operatora",
"Chat started" => "Započet chat",
"Live support:User window" => "Podršak uživo: Korisnički prozor",
"Request live support" => "Zahtevaj podršku uživo",
"Request support" => "Zahtevaj podršku",
"Open a support ticket instead" => "Otvori tiket za podršku",
"Your request is being processed" => "Vaš zahtev se razmatra",
"cancel request and exit" => "prekini zahtev i izađi",
"cancel request and leave a message" => "prekini zahtev i ostavi poruku",
"Live support:Console" => "Podrška uživo: Konzola",
"be online" => "uključi se",
"be offline" => "isključi se",
"Support requests" => "Zahtevi za podrškom",
"Requested" => "Zahtevano",
"Join" => "Pridruži se",
"Support chat transcripts" => "Transkript chat-a podrške",
"started" => "započeto",
"reason" => "razlog",
"msgs" => "poruka",
"Transcript" => "Transkript",
"Prefs" => "Podešavanja",
"Remove old events" => "Obriši stare događaje",
"duration" => "trajanje",
"Mini Calendar: Preferences" => "Mini Kalendar: Podešavanja",
"Calendar Interval in daily view" => "Interval kalendara u dnevnom pogledu",
"Start hour for days" => "Početni sat za dane",
"End hour for days" => "Krajnji sat za dane",
"Reminders" => "Podsetnik",
"no reminders" => "nema podsetnika",
"Or enter path or URL" => "ili ukucajte URL ili lokaciju",
"Add Topic" => "Dodaj temu",
"User Pages" => "Korisničke strane",
"User Galleries" => "Korisničke galerije",
"Unread Messages" => "Neporčitane poruke",
"Tasks" => "Poslovi",
"User Blogs" => "Korisnički Blogovi",
"MyTiki" => "Moj Tiki",
"Notepad" => "Notes",
"MyFiles" => "Moji Fajlovi",
"My Watches" => "Moja nadgledanja",
"Assigned items" => "Dodeljene stvari",
"Sent editions" => "Poslata izdanja",
"The newsletter was sent to {\$sent} email addresses" => "Novine su poslate na {\$sent} email adrese",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Hvala vam na vašem upisivanju. Uskoro će te primiti email za potvrđivanje vašeg pristupa. Nijedne novine vam neće biti poslate dok se vaše upisivanje ne potvrdi.",
"Your email address was removed from the list of subscriptors." => "Vaša email adresa je uklonjena sa liste pretplatnika.",
"Subscription confirmed!" => "Upis potvrđen!",
"Subscribe to Newsletter" => "Upišite se na novine",
"Subscribe to this Newsletter" => "Upis",
"Select news group" => "Odaberite grupo novosti",
"Back to servers" => "Nazad na servere",
"Msgs" => "Poruka",
"Back to groups" => "Nazad na grupu",
"Save position" => "Snimi poziciju",
"Reading article from" => "Čitanje članka sa",
"Back to list of articles" => "Nazad na listu članaka",
"Newsgroup" => "Grupe novosti",
"Configure news servers" => "Podesi server novosti",
"Configure Newsreader" => "Podesi čitač novina",
"configure newsreader server tpl" => "podesi čitač novina server tpl",
"Select a news server to browse" => "Odaberi server novosti za gledanje",
"News server" => "Server novosti",
"Notes" => "Napomene",
"Write a note" => "Napiši napomenu",
"quota" => "kvota",
"No notes yet" => "Nema napomena",
"Merge selected notes into" => "spoj odabrane note u",
"Reading note:" => "Čitanje napomene:",
"List notes" => "Listaj napomene",
"Write note" => "Napiši napomenu",
"Wiki Create" => "Wiki napravi",
"Wiki Overwrite" => "Wiki prebriši",
"Assign permissions to " => "Dodeli dozvole ",
"Current permissions for this object" => "Trenutne dozvole za ovaj objekat",
"Assign permissions to this object" => "Dodeli dozvole ovom objektu",
"Published" => "Objavljeno",
"Orphan Pages" => "Strane bez roditelja",
"Browser not supported" => "Browser nije podržan",
"Rename" => "Promeni ime",
"Slides" => "Slajdovi",
"Discuss" => "Diskutuj",
"Attach File" => "Dodaj fajl",
"1 File Attached" => "1 fajl prikačen",
"Pick your avatar" => "Odaberite vaš avatar",
"User Preferences" => "Korisnička podešavanja",
"Your current avatar" => "Vaš trenutni avatar",
"reset" => "resetuj",
"Pick avatar from the library" => "Odaberi avatar iz biblioteke",
"Pick user Avatar" => "Odaberite vaš avatar",
"Hide all" => "Sakrij sve",
"Show all" => "Prikaži sve",
"Avatar Image" => "Slika avatara",
"Upload your own avatar" => "Uploadujte vaš sopstveni avatar",
"Insert" => "Ubaci",
"Average" => "Prosečno",
"View Results" => "Vidi rezultate",
"Vote poll" => "Glasaj za upitnik",
"Other Polls" => "Ostali upitnici",
"on:" => "u:",
"Topic image" => "Slika teme",
"Viewing blog post" => "Gledanje blog poruke",
"Return to blog" => "Nazad na blog",
"The original document is available at" => "Originalan dokumenat možete naći na",
"Print multiple pages" => "Štampaj više strana",
"Name:" => "Ime:",
"Quiz result stats" => "Statistike rezultata kviza",
"Time" => "Vreme",
"User answers" => "Korisničkih odgovora",
"Stats for quizzes" => "Statistike kvizova",
"taken" => "uzet",
"Av score" => "Prosečan rezultat",
"Av time" => "Prosečno vreme",
"Clear Stats" => "Briši statistike",
"Stats for this quiz Questions " => "Statistike za pitanja iz ovog kviza ",
"Received articles" => "Primljeni članci",
"Edit received article" => "Izmeni primljene članke",
"Use Image" => "Koristi sliku",
"Image x size" => "Širina slike (X)",
"Image y size" => "Visina slike (Y)",
"Image name" => "Naziv slike",
"Accept Article" => "Prihvati članak",
"Site" => "Sajt",
"Received Pages" => "Primljene strane",
"Referer stats" => "Statistike referenata",
"Tiki site registered" => "Tiki sajt registrovan",
"The following site was added and validation by admin may be needed before appearing on the lists" => "Sledeći sajt je dopdat i provera od strane administratora je potrebna pre nego što će se pojaviti na listi",
"Register this site at tikiwiki.org" => "Registruj ovaj sajt na tikiwiki.org",
"Read this first!" => "Prvo pročitajte ovo!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "Na ovoj strani možete da registrujete svoj sajt na tikiwiki.org. Tamo će biti izlistan na listi poznatih tiki sajtova.",
"Registering is voluntary." => "Registracija je dobrovoljna.",
"Registering does not give you any benefits except one more link to your site." => "Registracija vam ne daje nikakve dodatne prednosti osim još jednog linka do vašeg sajta.",
"You don't get any emails, we don't sell the data about your site." => "Ne dobijate nijedan email, i ne prodajemo informacije o vašem sajtu.",
"Registering is just for us to get an overview of Tiki's usage." => "Registracija služi samo nama da bi imali predleg korišćenja Tikija.",
"If your site is private or inside your intranet, you should not register!" => "Ako je vaš sajt privatan ili unutar intraneta, nemojte da se registrujete!",
"Information about your site" => "Informacije o vašem sajtu",
"Send me my Password" => "Pošalji mi moju lozinku",
"Remove page" => "Obriši stranu",
"You are about to remove the page" => "Želite da obrišete stranicu",
"permanently" => "za stalno",
"Remove all versions of this page" => "Obriši sve verzije ove stranice",
"Rollback page" => "Vrati nazad stranu",
"Searched" => "Pretraženo",
"Search in" => "Traži u",
"Simple search" => "Jednostavna pretraga",
"No pages matched the search criteria" => "Nijedna strana ne odgovara kriterijumima pretrage",
"Send blog post" => "Pošalji blog poruku",
"A link to this post was sent to the following addresses:" => "Link na ovu poruku je poslat na sledeće adrese:",
"Send post to this addresses" => "Pošalji poruku na ovu adresu",
"List of email addresses separated by commas" => "Lista email adresa odvojenih zarezom",
"This newsletter will be sent to {\$subscribers} email addresses." => "Ove novine će biti poslate na {\$subscribers} email adrese",
"Prepare a newsletter to be sent" => "Pripremi novine za slanje",
"remove" => "obriši",
"Send objects" => "Pošalji objekte",
"Transmission results" => "Rezultati prenosa",
"Send Wiki Pages" => "Pošalji Wiki strane",
"Send Articles" => "Pošalji članak",
"Add Article" => "Dodaj članak",
"Send objects to this site" => "Pošalji objekte ovom sajtu",
"Change shoutbox general settings" => "Izmeni shoutbox osnovna podešavanja",
"auto-link urls" => "auto-link URL-ovi",
"Post or edit a message" => "Napiši ili izmeni poruku",
"Parent page" => "Nadstrana",
"big grin" => "veliki kez",
"confused" => "zbunjen",
"cry" => "plač",
"evil" => "zao",
"lol" => "LOL",
"mr green" => "mali zeleni",
"redface" => "zacrveneo sam se",
"rolleyes" => "kolutanje",
"smile" => "osmeh",
"surprised" => "iznenađen",
"twisted" => "izopačen",
"arrow" => "strelica",
"Site Stats" => "Statistike sajta",
"Total pageviews" => "Ukupno pogleda strana",
"Average pageviews per day" => "Prosek pogleda na dan",
"Best day" => "Najbolji dan",
"Worst day" => "Najgori dan",
"Wiki Stats" => "Wiki statistike",
"Size of Wiki Pages" => "Veličina Wiki strana",
"Average page length" => "Porsečna dužina strana",
"Average versions per page" => "Prosečno verzija po strani",
"Visits to wiki pages" => "Poseta Wiki stranama",
"Orphan pages" => "Strane bez roditelja",
"Average links per page" => "Prosečno linkova po strani",
"Image galleries Stats" => "Statistike galerija slika",
"Average images per gallery" => "Prosečno slika po galeriji",
"Total size of images" => "Ukupna veličina svih slika",
"Average image size" => "Prosečna veličina slika",
"Visits to image galleries" => "Poseta galerijama slika",
"File galleries Stats" => "Statistike galerija fajlova",
"Average files per gallery" => "Prosečno fajlova po galeriji",
"Total size of files" => "Ukupna veličina svih fajlova",
"Average file size" => "Prosečna veličina fajla",
"Visits to file galleries" => "Poseta galerijama fajlova",
"CMS Stats" => "CMS Statistike",
"Total reads" => "Ukupno čitanja",
"Average reads per article" => "Prosečno čitanja po članku",
"Total articles size" => "Ukupna veličina svih članaka",
"Average article size" => "Prosečna veličina članka",
"Forum Stats" => "Statistike foruma",
"Total topics" => "Ukupno tema",
"Average topics per forums" => "Prosečno tema po forumu",
"Visits to forums" => "Poseta forumu",
"Blog Stats" => "Blog statistike",
"Weblogs" => "Weblogovi",
"Total posts" => "Ukupno poruka",
"Average posts per weblog" => "Prosečno poruka po blogu",
"Total size of blog posts" => "Ukupna veličina blog poruka",
"Average posts size" => "Prosečna veličina poruke",
"Visits to weblogs" => "Poseta blogovima",
"Poll Stats" => "Statistike upitnika",
"Total votes" => "Ukupno glasova",
"Average votes per poll" => "Prosečno glasova po upitniku",
"Total questions" => "Ukupno pitanja",
"Average questions per FAQ" => "Prosečno pitanja po FAQ",
"User Stats" => "Korisničke statistike",
"User bookmarks" => "Korisničke omiljene strane",
"Average bookmarks per user" => "Prosečno omiljenih linkova po korisniku",
"Average questions per quiz" => "Prosečno pitanja po kvizu",
"Quizzes taken" => "Urađenih kvizoa",
"Average quiz score" => "Prosečan rezultat na kvizu",
"Average time per quiz" => "Prosečno vreme po kvizu",
"Usage chart" => "grafik upotrebe",
"Usage chart image" => "Grafik korišćenja",
"Stats for surveys" => "Statistike za ankete",
"Last taken" => "Zadnji put urađena",
"Time Left" => "Ostalo vremena",
"Send Answers" => "Pošalji odgovore",
"Your email was sent" => "Vaš email je poslat",
"Theme is selected as follows" => "Tema je odabrana kao što sledi",
"If a theme is assigned to the individual object that theme is used." => "Ako je tema dodeljena individualnom objektu ta tema se koristi.",
"If not then if a theme is assigned to the object's category that theme is used" => "Ako nema toga, koristi se tema dodeljena kategoriji tog objekta",
"If not then a theme for the section is used" => "Ako nema toga koristi je tema sekcije",
"If none of the above was selected the user theme is used" => "Ako nijedno od gore navedenih stvari nije odabrano, korisnička tema se koristi",
"Finally if the user didn't select a theme the default theme is used" => "Na kraju, ako korisnik nije odabrao temu, koristi se podrazumevana tema",
"Control by Sections" => "Kontrola po sekcijama",
"Assign themes to categories" => "Dodeli teme kategorijama",
"Assigned categories" => "Dodeljne kategorije",
"Theme Control Center: Objects" => "Controlni centar tema: objekti",
"Control by Categories" => "Kontrola po kategorijama",
"Assign themes to objects" => "Dodeli teme objektima",
"Assigned objects" => "Dodeljeni objekti",
"Assign themes to sections" => "Dodeli teme sekcijama",
"Assigned sections" => "Dodeljene sekcije",
"The following file was successfully uploaded" => "Sledeći fajl je uspešno uploadovan",
"You can download this file using" => "Možete preuzeti ovaj fajl koristeći",
"You have to create a gallery first!" => "Prvo morate da napravite galeriju!",
"Batch Upload Results" => "Rezultati grupnog uploada",
"Upload successful!" => "Upload uspešan!",
"The following image was successfully uploaded" => "Sledeća slika je uspešno uploadovana",
"Image ID thumb" => "ID smanjene slike",
"You can include the image in an Wiki page using" => "Sliku možete da dodate u bilo koju stranu uz pomoć",
"Now enter the image URL" => "Sada ukucajte URL slike",
"or upload a local image from your disk" => "ili uploadujte sliku sa vašeg hard diska",
"Batch Upload" => "Grupni upload",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Smanjena slika (opciono, zamenjuje automatsko generisanje smanjenih slika)",
"User assigned modules" => "Korisnički moduli",
"Assign module" => "Dodeli module",
"Column" => "Kolona",
"top" => "vrh",
"Current folder" => "Trenutni direktorijum",
"Folders" => "Direktorijumi",
"Folder in" => "Folder u",
"Remove Folder" => "Obriši direktorijum",
"Refresh Cache" => "Osveži skladište",
"Admin folders and bookmarks" => "Administriraj direktorijume i omiljene strane",
"Send me a message" => "Pošalji mi poruku",
"Personal Wiki Page" => "Lična Wiki Strana",
"Your personal Wiki Page" => "Tvoja lična Wiki Strana",
"Is email public? (uses scrambling to prevent spam)" => "Email je javan? (koristi se prikrivanje za zaštitu od spama)",
"Percentage completed" => "Procenata završeno",
"No tasks entered" => "Zadaci nisu upisani",
"Watches" => "Nadgledanja",
"May need to refresh twice to see changes" => "Dva osveževanja mogu biti potrebna da bi se videle promene",
"Add top level bookmarks to menu" => "Dodaj omiljene stranice prvog nivoa meniju",
"replace window" => "zameni prozor",
"Pos" => "Pozicija",
"User_versions_for" => "Korisničke verzije za",
"This page is being edited by" => "Ovu stranu menja",
"Proceed at your own peril" => "Nastavite na vašu sopstvenu odgovornost",
"expires:" => "ističe:",
"Banner stats" => "Statistike oglasa",
"Create new banner" => "Napravi novi oglas",
"Banner Information" => "Informacije o oglasima",
"Click ratio" => "Odnos klikovi/pogledi",
"Weekdays" => "Radni dani",
"mon" => "pon",
"tue" => "uto",
"wed" => "sre",
"thu" => "čet",
"fri" => "pet",
"sat" => "sub",
"sun" => "ned",
"Banner raw data" => "Sirovi podaci o oglasima",
"Cached" => "Uskladišteno",
"This is a cached version of the page." => "Ovo je uskladištena verzija stranice.",
"Click here to view the Google cache of the page instead." => "Kliknite ovde da bi videli Google cache ove stranice.",
"Edit Items" => "Izmeni zapise",
"List Charts" => "Lista grafika",
"Last Chart" => "Zadnji grafik",
"Previous Chart" => "Prošli grafik",
"Chart created" => "Grafik napravljen",
"Next Chart" => "Sledeći grafik",
"Permanency" => "Stalnost",
"Avg" => "Prosek",
"info/vote" => "info/glasaj",
"Next chart will be generated on" => "Sledeći grafik će biti generisan dana",
"View or vote items not listed in the chart" => "Vidi ili glasaj za stvari koje nisu na grafiku",
"Select something to vote on" => "Odaberi za šta ćeš da glasaš",
"Item information" => "Informacije o zapisima",
"Dif" => "Razlika",
"Best Position" => "Najbolja pozicija",
"Vote this item" => "Glsaj za ovu stvar",
"Highest" => "Najviši",
"Forum List" => "Lista foruma",
"Edit Forum" => "Izmeni forum",
"Summary" => "Siže",
"Moderator Actions" => "Moderatorske akcije",
"Move Selected Topics" => "Pomeri odabrane teme",
"Unlock Selected Topics" => "Odključaj odabrane teme",
"Lock Selected Topics" => "Zaključaj odabrane teme",
"Delete Selected Topics" => "Obriši odabrane teme",
"Merge" => "Spoj",
"Merge Selected Topics" => "Spoj odabrane teme",
"Reported Messages:" => "Prijavljene poruke:",
"Queued Messages:" => "Poruke na listi čekanja:",
"Merge into topic" => "Spoj u temu",
"pts" => "poena",
"Announce" => "Proglas",
"Hot" => "Vrelo",
"No topics yet" => "Nema još tema",
"Jump to forum" => "Skoči na forum",
"Last hour" => "Zadnji sat",
"Last 24 hours" => "Zadnjih 24 sata",
"Last 48 hours" => "Zadnjih 48 sati",
"prev topic" => "prošla poruka",
"next topic" => "sledeća tema",
"Show posts" => "Prikaži poruke",
"Insert New Item" => "Ubaci nov zapis",
"Tracker Items" => "Zapisi trakera",
"Insert new item" => "Ubaci nov zapis",
"View Item" => "Vidi zapis",
"Add a Comment" => "Dodaj komentar",
"Show All" => "Prikaži sve",
"Clip" => "klip",
"Back To Mailbox" => "nazad na sanduče",
"Full Headers" => "sva zaglavlja",
"Normal Headers" => "normalna zaglavlja",
"Reply To All" => "odgovori svima",
"Forward" => "prosledi",
"Select from address book" => "odaberi iz adresara",
"Use HTML mail" => "Koristi HTML email",
"The following addresses are not in your address book" => "Sledeće adrese se ne nalaze u vašem adresaru",
"Add Contacts" => "Dodaj kontakte",
"Attachment 1" => "Prilog 1",
"Attachment 2" => "Prilog 2",
"Attachment 3" => "Prilog 3",
"Address book" => "Adresar",
"Categories:" => "Kategorije:",
"Save Minor Edit" => "Manji",
"Compose Message" => "Sastavi poruku",
"Administration" => "Administracija",
"General preferences and settings" => "Generalna podešavanja",
"Wiki settings" => "Wiki podešavanja",
"Poll comments settings" => "Podešavanja komentara upitnika",
"Forums settings" => "Podešavanja foruma",
"RSS feeds" => "RSS izvore",
"No chart indicated" => "Grafik nije odabran",
"Upload failed" => "Upload nije uspeo",
"Your admin password has been changed" => "Vaša administratorska lozinka je promenjena",
"All Fields except gdaltindex must be filled" => "Sva polja osim gdaltindex moraju biti popunjena",
"Tag already exists" => "Tag već postoji",
"Tag not found" => "Tag nije nađen",
"Repository name can't be an empty" => "Ime repozitorije ne može biti prazno",
"Requested action is not supported on repository" => "Zahtevana akcija nije podržana nad repozitorijom",
"No repository" => "Nema repozitorije",
"Search is mandatory field" => "Pretraga je obavezno polje",
"File not found " => "Fajl nije pronađen ",
"Requested action in not supported on repository" => "Zahtevana akcija nije podržana nad repozitorijom",
"Non-existent link" => "Nepostojeći link",
"No menu indicated" => "Meni nije odabran",
"No newsletter indicated" => "Nise odabrane novine",
"No poll indicated" => "Upitnik nije odabran",
"Permission denied you cannot view this page" => "Nemate dozvolu da vidite ovu stranu",
"Permission denied you cannot edit this page" => "Nemate dozvolu da menjate ovu stranu",
"You must specify a page name, it will be created if it doesn't exist." => "Morate napisati naziv strane, ako ne postoji ona će biti kreirana.",
"page not added (Exists)" => "strana nije dodata (Postoji)",
"No survey indicated" => "Nije odabrana anketa",
"No tracker indicated" => "Nije odabran traker",
"Group already exists" => "Grupa već postoji",
"User doesn't exist" => "Korisnik ne postoji",
"No records were found. Check the file please!" => "Nijedan zapis nije pronađen. Molimo vas da proverite fajl!",
"User login is required" => "Korisnički login se zahteva",
"Password is required" => "Lozinka je zahtevana",
"Email is required" => "Email je zahtevan",
"User is duplicated" => "Korisnik je dupliran",
"password" => "lozinka",
"Unknown group" => "Nepoznata grupa",
"Group doesn't exist" => "Grupa ne postoji",
"Permission denied you cannot view backlinks for this page" => "Nemate dozvolu da vidite rekurzivne linkove za ovu stranicu",
"The page cannot be found" => "Strana ne može da se nađe",
"Invalid directory name" => "Neispravno ime direktorijuma",
"You can't post in any blog maybe you have to create a blog first" => "Nemožete da pišete ni u jednom blogu. Možda prvo treba da napravite blog?",
"Permission denied you cannot post" => "Nemate dozvolu da pišete poruke",
"Permission denied you cannot edit this post" => "Nemate dozvolu da menjate ovu poruku",
"Top visited blogs" => "Najposećeniji blogovi",
"Last posts" => "Zadnje poruke",
"Top active blogs" => "Top aktivni blogovi",
"No blogId specified" => "blogId nije specifiran",
"TOP" => "VRH",
"Permission denied you cannot access this gallery" => "Nemate dozvolu da pristupate ovoj galeriji",
"No gallery indicated" => "Galerija nije odabrana",
"Permission denied you can not view this section" => "Nemate dozvolu da gledate ovu sekciju",
"Permission denied you cannot remove images from this gallery" => "Nemate dozvolu da uklanjate slike iz ove galerije",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Nemate dozvolu da ponovo generišete smanjen prikaz u ovoj galeriji",
"Permission denied you cannot rotate images in this gallery" => "Nemate dozvolu da rotirate slike u ovoj galeriji",
"No image indicated" => "Slika nije odabrana",
"Permission denied you cannot move images from this gallery" => "Nemate dozvolu da pomerate slike iz ove galerije",
"Permission denied you cannot view the calendar" => "Nemate dozvolu da gledate kalendar",
"event without name" => "događaj bez imena",
"You can not use the same password again" => "Nemožete dva puta da koristite istu lozinku",
"Top authors" => "Top autori",
"This feature has been disabled" => "Ova osobenost je isključena",
"Must enter a name to add a site. " => "Morate upisati ime da bi dodali sajt. ",
"Must enter a url to add a site. " => "Morate upisati url da bi dodali sajt. ",
"URL already added to the directory. Duplicate site? " => "URL je već dodat u direktorijum. Duplikat sajta? ",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "Ne može da se pristupi odabranom URL pogrešan URL ili je sajt offline i ne može da se doda u direktorijum. ",
"Must select a category. " => "Morate odabrati kategoriju. ",
"Must enter a name to add a site" => "Morate uneti naziv za unos sajta",
"Must enter a url to add a site" => "Morate uneti URL za unos sajta",
"URL already added to the directory. Duplicate site?" => "URL već postoji u direktorijumu. Napraviti duplikat?",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "Ne može da se pristupi odabranom URL: pogrešan URL ili je sajt offline i ne može da se doda u direktorijum. ",
"Must select a category" => "Morate odabrati kategoriju",
"No site indicated" => "Nije odabran sajt",
"Article not found" => "Članak nije pronađen",
"Permission denied you cannot edit this article" => "Nemate dozvolu da menjate ovaj članak",
"You do not have permissions to edit banners" => "Nemate dozvolu da menjate oglase",
"Banner not found" => "Oglas nije nađen",
"You do not have permission to edit this banner" => "Nemate dozvolu da menjate ovaj oglas",
"Permission denied you cannot create or edit blogs" => "Nemate dozvolu da pravite ili menjate blogove",
"Permission denied you cannot edit this blog" => "Nemate dozvolu da menjate ovaj blog",
"You do not have permission to write the style sheet" => "Nemate dozvolu da pravite stranu sa stilovima",
"Invalid request to edit an image" => "Neispravan zathev za izmenom slike",
"Permission denied you cannot edit images" => "Nemate dozvolu za menjanje slika",
"Permission denied you can edit images but not in this gallery" => "Nemate dozvolu da menjate slike u ovoj galeriji iako imate dozvolu u nekoj drugoj galeriji",
"Failed to edit the image" => "Neuspešna izmena slike",
"Permission denied to use this feature" => "Nemate dozvolu da koristite ovu mogućnost",
"Shortname must be 2 Characters" => "Kratko ime mora biti 2 karaktera dugačko",
"You must provide a longname" => "Morate upisati dugačko ime",
"Language created" => "Jezik je napravljen",
"No content id indicated" => "Niste odabrali id sadržaja",
"No question indicated" => "Pitanje nije odabrano",
"No quiz indicated" => "Nije odabran kviz",
"No structure indicated" => "Nije odabrana struktura",
"Invalid structure_id or page_ref_id" => "Neispravan structure_id ili  page_ref_id",
"Permission denied you cannot send submissions" => "Nemate dozvolu da šaljete priloge",
"Permission denied you cannot edit submissions" => "Nemate dozvolu da menjate priloge",
"You have to create a topic first" => "Prvo morate da napravite temu",
"You do not have permission to do that" => "NEmate dozvolu da to uradite",
"You do not have permission to read the template" => "Nemate dozvolu da čitate šablone",
"No topic id specified" => "topic_id nije određen",
"Invalid topic id specified" => "Neispravan topic_id",
"page imported" => "strana uvezena",
"created from import" => "napravljeno iz uvoza",
"Can't import remote HTML page" => "Udaljena HTML strana ne može da se uveze",
"The SandBox is disabled" => "Igraonica je isključena",
"Cannot edit page because it is locked" => "Ne može da se menja strana jer je zaključana",
"Permission denied you cannot edit this file" => "Nemate dozvolu da izmenite ovaj fajl",
"Permission denied you cannot remove files from this gallery" => "Nemate dozvolu da brišete fajlove iz ove galerije",
"Top visited file galleries" => "Najposećenije fajl galerije",
"Most downloaded files" => "Naj preuzimaniji fajlovi",
"Last files" => "Zadnji fajlovi",
"No galleryId specified" => "galleryId nije određen",
"No forum indicated" => "Forum nije odabran",
"Forum posts" => "Teme foruma",
"No forumId specified" => "forumId nije određen",
"No process indicated" => "Proces nije odabran",
"Activity name already exists" => "Naziv aktivnosti već postoji",
"indicates if the process is active. Invalid processes cant be active" => "označava da li je proces aktivan. Neispravni procesi ne mogu da se aktiviraju",
"No instance indicated" => "Instanca nije odabrana",
"No activity indicated" => "Aktivnosti nisu odabrane",
"The process name already exists" => "Ime procesa već postoji",
"Process already exists" => "Proces već postoji",
"You cant execute this activity" => "Ne možete da pokrenete ovu aktivnost",
"No user indicated" => "Korisnik nije odabran",
"No item indicated" => "Niste odabrali zapis",
"first image" => "prva slika",
"last image" => "zadnja slika",
"Permission denied you cannot create galleries and so you cant edit them" => "Nemate dozvolu da pravite galerije i zato ne možete ni da ih menjate",
"Permission denied you cannot edit this gallery" => "Nemate dozvolu da menjate ovu galeriju",
"Permission denied you cannot remove this gallery" => "Nemate dozvolu da obrišete ovu galeriju",
"Top images" => "Naj slike",
"Last images" => "Zadnje slike",
"overwriting old page" => "prebrisavanje starih strana",
"page created" => "strana napravljena",
"No name indicated for wiki page" => "Ime nije napisano za wiki stranu",
"No repository given" => "Repozitorija nije određena",
"Permission denied you cannot view pages like this page" => "Nemate dozvolu da vidite strane koje liče ovoj strani",
"Permission denied you cannot remove articles" => "Nemate dozvolu da brišete članke",
"Permission denied you cannot remove banners" => "Nemate dozvolu da uklanjate oglase",
"Permission denied you cannot remove this blog" => "Nemate dozvolu da obrišete ovaj blog",
"Non-existent gallery" => "Nepostojeća galerija",
"Permission denied you can upload files but not to this file gallery" => "Nemate dozvolu da dodate fajl ovoj galeriji fajlova, iako imate dozvolu za dodavanje fajlova drugim galerijama fajlova",
"Could not upload the file" => "Upload fajla nije uspeo",
"Permission denied you can't upload files so you can't edit them" => "Nemate dozvolu da uploadujete fajlove, i zato ne možete da ih menjate",
"The thumbnail name must be" => "Naziv smanjene slike mora biti",
"You cannot admin blogs" => "Ne možete da administrirate blogove",
"Permission denied you cannot remove submissions" => "Nemate dozvolu da brišete priloge",
"Permission denied you cannot approve submissions" => "Nemate dozvolu da dozvoljavate priloge",
"edit" => "izmeni",
"You do not have permissions to view the maps" => "Nemate dozbolu da gledate mape",
"mapfile name incorrect" => "pogrešan naziv map fajla",
"This mapfile already exists" => "Ovaj map fajl već postoji",
"You do not have permission to write to the mapfile" => "Nemate dozvolu da pišete u map fajl",
"You do not have permission to delete the mapfile" => "Nemate dozvolu da obrišete map fajl",
"You do not have permission to read the mapfile" => "Nemate dozvolu da čitate map fajl",
"You do not have permissions to view the layers" => "Nemate dozvolu da vidite slojeve",
"You do not have permissions to delete a file" => "Nemate dozvolu da obrišete fajl",
"File not found" => "Fajl nije pronađen",
"You do not have permissions to create a directory" => "Nemate dozvolu da napravite direktorijum",
"The Directory is not empty" => "Direktorijum nije prazan",
"You do not have permissions to delete a directory" => "Nemate dozvolu da obrišete direktorijum",
"You do not have permissions to create an index file" => "Nemate dozvolu da napravite indeksni fajl",
"Invalid file name" => "Neispravno ime fajla",
"Invalid files to index" => "Neispravni fajlovi za indeksiranje",
"I do not know where is gdaltindex. Set correctly the Map feature" => "Ne znam gde se nalazi gdaltindex. Ispravno podesite Map osobenost",
"I could not create the index file" => "Ne mogu da napravim indeksni fajl",
"Must be logged to use this feature" => "Morate biti loginovani da bi koristili ovu osobenost",
"Welcome at Hawiki" => "Dobrodošli u Hawiki",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "Ovaj Tikiwiki sajt je spreman za pristup sa velikog broja mobilnih uređaja, npr. WAP telefoni, PDA, i-mode uređaji i mnogi drugi.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "Možete da gledate ovaj sajt na vašem mobilnom uređaju tako što ćete browser na vašem uređaju uputiti na sledeći URL:",
"About" => "O Nama",
"You must log in to use this feature" => "Morate da se loginujete da bi koristili ovu mogućnost",
"You do not have permission to view other users data" => "Nemate dozvolu da vidite podatke o ostalim korisnicima",
"You must be logged in to subscribe to newsletters" => "Morate biti ulogovani da bi se pretplatili na novine",
"No server indicated" => "Server nije odabran",
"Cannot connect to" => "Ne može da se uspostavi veza do",
"Missing information to read news (server,port,username,password,group) required" => "Nedostaju informacije potrebne za čitanje novosti (server, port, korisničko ime, lozinka, grupa) su zahtevani",
"Cannot get messages" => "Ne može da se preuzme poruka",
"No note indicated" => "Nije odabran notes",
"merged note:" => "spojene note:",
"File is too big" => "Fajl je prevelik",
"created from notepad" => "napravljeno iz notesa",
"Page already exists" => "Strana već postoji",
"Not enough information to display this page" => "Nema dovoljno informacija za prikaz strane",
"Permission denied you cannot browse this page history" => "Nemate dozvolu da gledate istoriju ove strane",
"No article indicated" => "Niste odabrali članak",
"Article is not published yet" => "Članak još nije objavljen",
"No post indicated" => "Nije odabrana poruka",
"Blog not found" => "Blog nije nađen",
"No pages indicated" => "Strana nije odabrana",
"No result indicated" => "nema rezultata",
"The passwords don't match" => "Lozinke se ne podudaraju",
"Invalid or unknown username" => "Neispravno ili nepoznato korisničko ime",
"to the registered email address for" => "na registrovanu email adresu za",
"Permission denied you cannot remove versions from this page" => "Nemate dozvolu da uklanjate verzije ove stranice",
"Cannot rename page maybe new page already exists" => "ne mogu da promenim ime stranice. Možda ste upisali ime postojeće stranice?",
"Non-existent version" => "Nepostojeća verzija",
"Permission denied you cannot rollback this page" => "Nemate dozvolu da vršite povraćaj ove stranice",
"Post recommendation at" => "Preporuka poruke na",
"successfully sent" => "uspeno poslato",
"not sent" => "nije poslato",
"Page must be defined inside a structure to use this feature" => "Strana mora biti definisana van strukture da bi koristili ovu osobenost",
"You cannot take this quiz twice" => "Ne možete dva puta da uradite ovaj kviz",
"Quiz time limit exceeded quiz cannot be computed" => "Vreme za rađenje kviza je prekoračeno. Kviz ne može da bude izračunat",
"You cannot take this survey twice" => "Ne možete dva puta da radite istu anketu",
"Please create a category first" => "Prvo odaberite kategoriju",
"No permission to upload zipped file packages" => "Nemate dozvolu da uploadujete zipovan fajl paket",
"Error processing zipped image package" => "Greška pri procesiranju zipovanog paketa sa slikama",
"No permission to upload zipped image packages" => "Nemate dozvolu da uploadujete zipovan paket slika",
"Permission denied you cannot upload images" => "Nemate dozvolu da dodajete slike",
"Permission denied you can upload images but not to this gallery" => "Nemate dozvolu da dodajete slike ovoj galeriji, ali možete dodati sliku nekoj drugoj galeriji",
"Cannot get image from URL" => "Ne mogu da nađem sliku na datom URL",
"No url indicated" => "URL nije odabran",
"Unknown user" => "Nepoznat korisnik",
"You are not logged in and no user indicated" => "Niste looginovani i nijedan korisnik nije odabran",
"The user has chosen to make his information private" => "Korisnik je odabrao da sakrije svoje informacije",
"The passwords did not match" => "Lozinke se ne poklapaju",
"no" => "ne",
"Cannot upload this file not enough quota" => "Fajl ne može da se prihvati jer nije dovoljno velika kvota",
"Non-existent user" => "Nepostojeći korisnik",
"No banner indicated" => "Niste odabrali oglas",
"No blog indicated" => "Niste odabrali blog",
"Permission denied you cannot remove the post" => "Nemate dozvolu da obrišete poruku",
"No cache information available" => "Nema podataka o ovoj stranici u skladištu",
"No faq indicated" => "FAQ nije odabran",
"You are not permitted to remove someone else\\'s post!" => "Nije vam dozvoljeno da uklanjate tuđe poruke!",
"No thread indicated" => "Tema nije odabrana",
"No subject" => "Nema naslova",
"Top pages" => "Top strane",
"Last pages" => "Zadnje strane",
"###end###"=>"###end###");
?>
