<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only translates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release


// ### Note for translators about translation of text ending with punctuation
// ###
// ### The current list of concerned punctuation can be found in 'lib/init/tra.php'
// ### On 2009-03-02, it is: (':', '!', ';', '.', ',', '?')
// ### For clarity, we explain here only for colons: ':' but it is the same for the rest
// ###
// ### Short version: it is not a problem that string "Login:" has no translation. Only "Login" needs to be translated.
// ###
// ### Technical justification:
// ### If a string ending with colon needs translating (like "{tr}Login:{/tr}")
// ### then TikiWiki tries to translate 'Login' and ':' separately.
// ### This allows to have only one translation for "{tr}Login{/tr}" and "{tr}Login:{/tr}"
// ### and it still allows to translate ":" as "&nbsp;:" for languages that
// ### need it (like french)

$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"save_to" => "shrani_v",
"DATE-of" => "Date-of",
"Jan" => "Jan",
"Feb" => "Feb",
"Mar" => "Mar",
"Apr" => "Apr",
"Jun" => "Jun",
"Jul" => "Jul",
"Aug" => "Aug",
"Sep" => "Sep",
"Oct" => "Okt",
"Nov" => "Nov",
"Dec" => "Dec",
"Your post has not been posted" => "Prispevek ni bil poslan",
"Missing title or body when trying to post a comment" => "MManjka naslov in telo besedila ko si poskusil poslati komentar",
"The text in RED is" => "Besedilo v RED je",
"Cannot write to this file: " => "Ne morem zapisati v to datoteko: ",
"Newsletter subscription information at " => "Informacije za naročilo biltena pri ",
"Last seen on " => "Zadnjič videno na ",
"cannot be found" => "ne najdem",
"__WARNING__: No such module \$plugin! " => "__OPOZORILO__: Ni takega modula \$plugin! ",
"Status:" => "Status:",
"(unchanged)" => "(nespremenjeno)",
"Use Google Maps." => "Uporabi Google Maps.",
"Remaining:" => "Ostane:",
"Old:" => "Star",
"New:" => "Nov:",
"Changes" => "Spremembe",
"new submissions" => "Nove uklonitve",
"new sites" => "Nove strani",
"new calendar events" => "Novi dogodki v koledarju",
" on " => " na ",
"Show Categories" => "Pokaži kategorije",
"Hide Categories" => "Skrij kategorije",
"Hold down CTRL to select multiple categories" => "Za izbiro več kategorij pritisni in drži Ctrl.",
"categorize this object" => "Kategoriziraj ta objekt",
"Uncheck the above checkbox to uncategorize this page/object" => "Odstrani kljukico v zgornjem kvadratku za nekategorizacijo te strani/objekta",
"Tiki User Account Activated" => "Uporabniški račun je aktiviran.",
"Tiki User Registration Request" => "Zahteva Tiki uporabnika za registracijo",
"Tiki email notification" => "Tiki e-poštno obvestilo",
"you or someone registered this email address at" => "registrirali ste se (ali pa kdo drug v vašem imenu) s tem e-naslovom na",
"Your Tiki information registration" => "Vaša Tiki registracijska informacija",
"Wiki page %s changed" => "Wiki stran %s se je spremenila",
"RSS modules" => "RSS moduli",
"External wikis" => "Zunanji wikiji",
"MyMenu" => "Moj meni",
"MyTiki home" => "Moj Tiki dom",
"My files" => "Moje datoteke",
"User menu" => "Uporabniški meni",
"Mini calendar" => "Mini koledar",
"My watches" => "Moje opazovane strani",
"WfMenu" => "WfMenu",
"Monitor processes" => "Opazuj procese",
"Monitor activities" => "Opazuj aktivnosti",
"Monitor instances" => "Opazuj primere (instances)",
"User processes" => "User processes",
"User activities" => "Aktivnosti uporabnika",
"User instances" => "Uporabnikovi primeri (instances)",
"FriendsMenu" => "Meni prijateljev",
"User list" => "Seznam uporabnikov",
"WikiMenu" => "Wiki meni",
"Send pages" => "Pošlji strani",
"Received pages" => "Prejete strani",
"GalMenu" => "GalMeni",
"System gallery" => "Sistem galerij",
"View submissions" => "Poglej predložene članke",
"New article" => "Nov članek",
"Send articles" => "Pošlji članke",
"List blogs" => "Seznam blogov",
"Create/Edit blog" => "Ustvari/Uredi blog",
"Admin posts" => "Administriraj prispevke",
"ForMenu" => "ForMenu",
"DirMenu" => "DirMenu",
"Submit a new link" => "Predloži novo povezavo",
"Browse directory" => "Prebrskaj direktorij",
"Admin directory" => "Administriraj direktorij",
"FileGalMenu" => "FileGalMenu",
"Admin FAQs" => "Administriraj vprašanja in odgovore (FAQs)",
"Layer management" => "Upravljanje ravni (Layer management)",
"QuizMenu" => "Kviz meni",
"List quizzes" => "Seznam kvizov",
"Admin quiz" => "Administriraj kvize",
"ShtMenu" => "ShtMenu",
"TrkMenu" => "TrkMenu",
"List trackers" => "Seznam sledilnikov",
"Admin trackers" => "Administriraj sledilnike",
"SrvMenu" => "SrvMenu",
"Send newsletters" => "Pošlji biltene",
"Send events" => "Pošlji dogodke",
"Admin events" => "Administriraj dogodke",
"EphMenu" => "EphMeni",
"Ephemerides" => "Preglednice(Ephemerides)",
"Ephemerides Admin" => "Preglednice (Ephemerides) Admin",
"ChartMenu" => "Meni grafikona",
"Charts Admin" => "Grafikoni Admin",
"AdmMenu" => "AdmMeni",
"Admin home" => "Admin domov",
"Edit languages" => "Uredite jezike",
"Mods Admin" => "Mods Admin",
"UsrMenu" => "UsrMenu",
"Click here to manage your personal menu" => "Klikni tu za upravljanje osebnega menija",
" on blogpost " => " na blogih ",
"Paramaters" => "Parametri",
"applicable for this item" => "ki se nanašajo na to postavko",
"I forgot my pass" => "Pozabil sem geslo",
"click to show/hide" => "Klikni za: prikaz/skrivanje",
" on page " => " na strani ",
"Are you sure you want to remove this module?" => "Ste prepričani, da želite odstraniti ta modul?",
"Created by:" => "Ustvaril:",
"Last Modification:" => "Zadnja sprememba:",
"For" => "Za",
"Location: " => "Lokacija: ",
"{\$atts_cnt} files attached" => "{\$atts_cnt} pripetih datotek",
"pass" => "geslo",
"Page generated in" => "Stran vzpostavljena v",
"sent" => "pošlji",
"Homework" => "Domača naloga",
"Assignments" => "Dodelitve (Assignments)",
"Backups" => "Varnostne kopije",
"{|} Files Attached" => "{|} pripete datoteke",
"Favorites" => "Priljubljene",
"home" => "Domov",
"chat" => "Klepet",
"contact us" => "Pokliči nas",
"Member list" => "Seznam članov",
"dump" => "Odpad",
"rankings" => "Najboljši",
"orphan pages" => "Osirotele strani",
"sandbox" => "Peskovnik",
"received pages" => "Prejete strani",
"structures" => "Strukture",
"Articles Home" => "Članki domov",
"Create/Edit Blog" => "Ustvari/uredi blog",
"Browse Directory" => "Prebrskaj direktorij",
"Back to Homepage" => "Nazaj na domačo stran",
"Edit Summary" => "Uredi povzetek",
"Minor" => "Manjše",
"RSS Trackers" => "RSS sledilniki",
"left/right" => "levo/desno",
"Quick edit a Wiki page" => "Hitro urejanje wiki strani",
"Language: " => "Jezik: ",
"This is" => "To je",
"Tiki community" => "Tiki skupnost",
"Sort posts by:" => "Sortiraj prispevke po:",
"read more" => "preberi več",
"Show/Hide Left Modules" => "Pokaži/Skrij leve module",
"Show/Hide Right Modules" => "Pokaži/Skrij desne module",
"Last update from CVS" => "Zadnja posodobitev iz CVS",
"Translate in" => "Prevedi v",
"babelfish it" => "babelfish it",
"Welcome to" => "Dobrodošli v",
"Design by" => "Dizajniral",
"Last modification time" => "Čas zadnje spremembe",
"Calendar manual selection of time/date" => "Ročna izbira časa/datuma v koledarju",
"if no jscalendar" => "če ni jscalendar",
"Article comments settings" => "Nastavitve komentiranja člankov",
"Fields to display on page" => "Polja prikazana na strani",
"Expire Date" => "Končni datum",
"Minimum username length" => "Minimalna dolžina uporabniškega imena",
"Maximum username length" => "Maksimalna dolžina uporabniškega imena",
"Force lowercase username" => "Forsiraj malo pisavo za uporabniško ime",
"Minimum password length" => "Minimalna dolžina gesla",
"Password invalid after days" => "Geslo bo neveljavno po (dneh)",
"-1 for never" => "-1 za nikoli",
"Remember me feature" => "Zapomni se me značilnost",
"Duration:" => "Trajanje:",
"Remember me name" => "Zapomni si moje ime",
"Default group: " => "Default group: ",
"Site Logo" => "Logo strani",
"Allow Smileys" => "Dovoli smejkote",
"Show quicktags over textareas (instead on left side)" => "Pokaži hitre značke (quicktags) preko tekstovnega področja (namesto na levi strani)",
"Default number of rows (wiki)" => "Privzeto število vrstic (wiki)",
"Default number of rows (comments)" => "Privzeto število vrstic (komentarji)",
"Default number of rows (forum)" => "Privzeto število vrstic (forum)",
"Default number of rows (forum replies)" => "Privzeto število vrstic (odgovori v forumu)",
"Create a Tag for the Current Wiki" => "Ustvari značko za ta wiki",
"Tag name:" => "Ime značke:",
"Restore the Wiki" => "Obnovi wiki",
"restore" => "obnovi",
"Remove a Tag" => "Odstranite značko",
"Wiki Comments Settings" => "Nastavitve wiki komentarjev",
"Default number of comments per page:" => "Privzeto število komentarjev na stran:",
"List displayed by default" => "Privzeto prikazan seznam",
"Wiki attachments:" => "Wiki priponke:",
"Use database to store files:" => "Uporabi podatkovno bazo za shranjevanje datotek:",
"Use a directory to store files:" => "Uporabi direktorij za shranjevanje datotek:",
"Wiki Administration" => "Wiki Administration",
"Wiki Home Page" => "Wiki domača stran",
"Wiki Discussion" => "Wiki razprava",
"Wiki Link Format" => "Format wiki povezave",
"Comment length:" => "Dolžina komentarja:",
"Text size:" => "Velikost besedila:",
"Wiki Features" => "Wiki funkcije",
"Sandbox:" => "Peskovnik:",
"History:" => "Zgodovina:",
"View source:" => "Poglej vir:",
"List pages:" => "Seznam strani:",
"Backlinks:" => "Backlinks:",
"Similar:" => "Podobno:",
"Rankings:" => "Najboljši:",
"Undo:" => "Razveljavi:",
"Save Draft:" => "Shrani osnutek:",
"Comments:" => "Komentarji:",
"Use templates:" => "Uporabi predloge:",
"Footnotes:" => "Opombe v nogi:",
"Use WikiWords:" => "Uporabi wiki besede:",
"Open page as structure:" => "Odpri stran kot strukturo:",
"Make structure from page:" => "Naredi strukturo iz strani:",
"Categorize structure pages together:" => "Kategoriziraj strukturne strani skupaj:",
"User's Page:" => "Uporabnikova stran:",
"Edit section:" => "Uredite sekcijo:",
"Wiki History" => "Wiki zgodovina",
"Maximum number of versions for history:" => "Maksimalno število verzij za zgodovino:",
"Wiki Watch" => "Wiki opazovanje",
"More Links" => "Več povezav",
"Create/edit Calendars" => "Ustvari/uredi koledarje",
"Admin Categories tpl" => "Adminstriraj predloge kategorij",
"browse the category system" => "prebrskaj sistem kategorij",
"charts" => "diagrami",
"Admin Charts Template" => "Administriraj predloge diagramov",
"Admin Forums Template" => "Administriraj predloge forumov",
"Add new rule" => "Dodaj novo pravilo",
"Admin Modules Template" => "Administriraj predloge modulov",
"Assign Module" => "Določi modul",
"Edit/Create" => "Uredi/Ustvari",
"Admin structures template" => "Administratorjevi strukturne predloge",
"Edit survey questions" => "Uredite anketna vprašanja",
"this survey stats" => "statistika te ankete",
"Create/edit questions for survey" => "Ustvari/uredi vprašanja za anketo",
"Admin Topics Template" => "Administriraj predloge tem",
"Active?" => "Aktivne?",
"Create item" => "Ustvari postavko",
"User must already exist." => "Uporabnik mora že obstajati.",
"Admin Users Template" => "Adminisrtriraj uporabnikove predloge",
"Assign to Groups" => "Določi v skupine",
"Again" => "Ponovno",
"User must change his password at first login" => "Uporabnik mora spremeniti geslo pri prvi prijavi",
"Approve page changes in staging" => "Odobri nove strani v postavitvi",
"Assign permissions to group" => "Določi dovoljenja skupini",
"Help for Assigning Permissions" => "Pomoč za pripisovanje dovoljenj",
"Browse gallery" => "Prebrskaj galerijo",
"Upload from disk" => "Naloži z diska",
"Browse file gallery" => "Prebrskaj galerijo datotek",
"The TikiWiki community" => "Skupnost TikiWiki",
"Browsing Gallery" => "Brskanje po galeriji",
"Browsing Image" => "Brskaj po slikah",
"Zoom" => "Povečaj",
"Config Calendars" => "Konfigurirajte koledarje",
"Focus:" => "Fokus:",
"Edit Article" => "Uredi članek",
"creates a title bar" => "ustvari naslovno vrstico",
"Wiki File Attachments" => "Wiki priponke datotek",
"bold" => "bold",
"back to forum" => "nazaj na forum",
"galleries tpl" => "galerijski tpl",
"Tiki cannot find a database connection" => "Tiki ne more najti povezave do podatkovne baze",
"Database type" => "Tip podatkovne baze",
"Database name" => "Ime podatkovne baze",
"Create a file gallery" => "Ustvari podatkovno galerijo",
"User Calendar Doc" => "Uporabniški Calendar Doc",
"User Calendar Preferences Doc tpl" => "Uporabnikove koledarske izb. nastavitve Doc tpl",
"Received Articles" => "Prejeti članki",
"received articles tpl" => "prejeti članki tpl",
"Help on Communication Center" => "Pomoč o komunikacijskem centru",
"received pages tpl" => "prejete strani tpl",
"Return to HomePage" => "Nazaj na domačo stran",
"return to wikipage" => "Nazaj na wiki stran",
"Rename page" => "Preimenuj stran",
"to_version" => "na verzijo",
"theme" => "teme",
"Upload big files (e.g. PodCast files) here:" => "Naloži velike datoteke (npr. PodCast datoteke) tukaj:",
"File Title" => "Naslov datoteke",
"Batch upload" => "Paketno nalaganje",
"Unzip all zip files" => "Razširi (unzip) stisnjene datoteke",
"Maximum amount of downloads" => "Maksimalna količina naloženega",
"Author if not the file creator" => "Avtor, če ni ustvarjalec datoteke",
"Image Gallery tpl" => "Galerija slik tpl",
" or upload a local image from your disk" => " ali naloži lokalno sliko s tvojega diska",
"User Assigned Modules" => "Moduli, ki jih je določil uporabnik",
"User Assigned Modules tpl" => "Predloge, ki jih je določil uporabnik",
"Edit User Contacts Preferences" => "Uredi uporabnikove izbire za kontakte",
"watched events" => "opazovani dogodki",
"Watch language wiki page creations" => "Opazuj ustvarjanje jezikovnih wiki strani",
"Add watch" => "Dodaj opazovanje",
"No articles." => "Ni člankov.",
"View All" => "Poglej vse",
"Minor Edit" => "Manjše urejanje",
"You have mistyped the anti-bot verification code; please try again. " => "Narobe si vtipkal anti-bot verifikacijsko kodo. Prosim, poskusi še enkrat.",
"%s - Version %d of this page has been saved by %s." => "%s - Verzijo %d te strani je shranil %s.",
"Delete those pages:" => "Odstrani te strani:",
"to the email " => "na e-naslov ",
" successfully sent" => " uspešno poslano",
" not sent" => " ni poslano",
"Invalid password.  Your current password is required to change administrative information" => "Neveljavno geslo. V vašem trenutnem geslu je treba zamenjati administrativne informacije",
"Your account request have been stored and will be activated by the admin as soon as possible." => "Your account request has been stored and will be activated by the admin as soon as possible.",
"Days online" => "Dnevi online",
"Edit Section:" => "Uredi sekcijo:",
"View object" => "Poglej predmet (object)",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "This script cannot be called directly" => "This script cannot be called directly",
// "The copyright management feature is not enabled" => "The copyright management feature is not enabled",
// "Copyright management" => "Copyright management",
// "No page indicated" => "No page indicated",
// "You must supply all the information, including title and year" => "You must supply all the information, including title and year",
// "Tiki is unable to connect to the database " => "Tiki is unable to connect to the database ",
// "Tiki was unable to retrieve login data from the database " => "Tiki was unable to retrieve login data from the database ",
// "The following error message was returned" => "The following error message was returned",
// "Things to check" => "Things to check",
// "Is your database up and running" => "Is your database up and running",
// "Are your database login credentials correct" => "Are your database login credentials correct",
// "Did you complete the <a href='tiki-install.php' >Tiki Installer" => "Did you complete the <a href='tiki-install.php' >Tiki Installer",
// "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information" => "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information",
// "This feature is for admins only" => "This feature is for admins only",
// "Slideshow" => "Slideshow",
// "Default View" => "Default View",
// "Afghanistan" => "Afghanistan",
// "Aland Islands" => "Aland Islands",
// "Aland_Islands" => "Aland_Islands",
// "Albania" => "Albania",
// "Algeria" => "Algeria",
// "American Samoa" => "American Samoa",
// "American_Samoa" => "American_Samoa",
// "Andorra" => "Andorra",
// "Angola" => "Angola",
// "Anguilla" => "Anguilla",
// "Antigua" => "Antigua",
// "Argentina" => "Argentina",
// "Armenia" => "Armenia",
// "Aruba" => "Aruba",
// "Australia" => "Australia",
// "Austria" => "Austria",
// "Azerbaijan" => "Azerbaijan",
// "Bahamas" => "Bahamas",
// "Bahrain" => "Bahrain",
// "Bangladesh" => "Bangladesh",
// "Barbados" => "Barbados",
// "Belarus" => "Belarus",
// "Belgium" => "Belgium",
// "Belize" => "Belize",
// "Benin" => "Benin",
// "Bermuda" => "Bermuda",
// "Bhutan" => "Bhutan",
// "Bolivia" => "Bolivia",
// "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
// "Bosnia_and_Herzegovina" => "Bosnia_and_Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "Bouvet_Island" => "Bouvet_Island",
// "Brazil" => "Brazil",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "British_Indian_Ocean_Territory" => "British_Indian_Ocean_Territory",
// "British_Virgin_Islands" => "British_Virgin_Islands",
// "Brunei" => "Brunei",
// "Bulgaria" => "Bulgaria",
// "Burkina Faso" => "Burkina Faso",
// "Burkina_Faso" => "Burkina_Faso",
// "Burundi" => "Burundi",
// "Cambodia" => "Cambodia",
// "Cameroon" => "Cameroon",
// "Canada" => "Canada",
// "Cape Verde" => "Cape Verde",
// "Cape_Verde" => "Cape_Verde",
// "Catalan Countries" => "Catalan Countries",
// "Catalan_Countries" => "Catalan_Countries",
// "Cayman Islands" => "Cayman Islands",
// "Cayman_Islands" => "Cayman_Islands",
// "Central African Republic" => "Central African Republic",
// "Central_African_Republic" => "Central_African_Republic",
// "Chad" => "Chad",
// "Chile" => "Chile",
// "China" => "China",
// "Christmas Island" => "Christmas Island",
// "Christmas_Island" => "Christmas_Island",
// "Cocos Islands" => "Cocos Islands",
// "Cocos_Islands" => "Cocos_Islands",
// "Colombia" => "Colombia",
// "Comoros" => "Comoros",
// "Congo Democratic" => "Congo Democratic",
// "Congo" => "Congo",
// "Congo_Democratic" => "Congo_Democratic",
// "Cook Islands" => "Cook Islands",
// "Cook_Islands" => "Cook_Islands",
// "Costa Rica" => "Costa Rica",
// "Costa_Rica" => "Costa_Rica",
// "Croatia" => "Croatia",
// "Cuba" => "Cuba",
// "Cyprus" => "Cyprus",
// "Czech Republic" => "Czech Republic",
// "Czech_Republic" => "Czech_Republic",
// "Denmark" => "Denmark",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Dominican Republic" => "Dominican Republic",
// "Dominican_Republic" => "Dominican_Republic",
// "Ecuador" => "Ecuador",
// "Egypt" => "Egypt",
// "El Salvador" => "El Salvador",
// "El_Salvador" => "El_Salvador",
// "Equatorial Guinea" => "Equatorial Guinea",
// "Equatorial_Guinea" => "Equatorial_Guinea",
// "Eritrea" => "Eritrea",
// "Estonia" => "Estonia",
// "Ethiopia" => "Ethiopia",
// "Europe" => "Europe",
// "Falkland Islands" => "Falkland Islands",
// "Falkland_Islands" => "Falkland_Islands",
// "Faroe Islands" => "Faroe Islands",
// "Faroe_Islands" => "Faroe_Islands",
// "Federated States of Micronesia" => "Federated States of Micronesia",
// "Federated_States_of_Micronesia" => "Federated_States_of_Micronesia",
// "Fiji" => "Fiji",
// "Finland" => "Finland",
// "France" => "France",
// "French Guiana" => "French Guiana",
// "French Polynesia" => "French Polynesia",
// "French Southern Territories" => "French Southern Territories",
// "French_Guiana" => "French_Guiana",
// "French_Polynesia" => "French_Polynesia",
// "French_Southern_Territories" => "French_Southern_Territories",
// "Gabon" => "Gabon",
// "Gambia" => "Gambia",
// "Georgia" => "Georgia",
// "Germany" => "Germany",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greece" => "Greece",
// "Greenland" => "Greenland",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guam" => "Guam",
// "Guatemala" => "Guatemala",
// "Guernsey" => "Guernsey",
// "Guinea Bissau" => "Guinea Bissau",
// "Guinea" => "Guinea",
// "Guinea_Bissau" => "Guinea_Bissau",
// "Guyana" => "Guyana",
// "Haiti" => "Haiti",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Heard_Island_and_McDonald_Islands" => "Heard_Island_and_McDonald_Islands",
// "Honduras" => "Honduras",
// "Hong Kong" => "Hong Kong",
// "Hong_Kong" => "Hong_Kong",
// "Hungary" => "Hungary",
// "Iceland" => "Iceland",
// "India" => "India",
// "Indonesia" => "Indonesia",
// "Iran" => "Iran",
// "Iraq" => "Iraq",
// "Ireland" => "Ireland",
// "Isle of Man" => "Isle of Man",
// "Israel" => "Israel",
// "Italy" => "Italy",
// "Ivory Coast" => "Ivory Coast",
// "Ivory_Coast" => "Ivory_Coast",
// "Jamaica" => "Jamaica",
// "Japan" => "Japan",
// "Jersey" => "Jersey",
// "Jordan" => "Jordan",
// "Kazakstan" => "Kazakstan",
// "Kenya" => "Kenya",
// "Kiribati" => "Kiribati",
// "Kuwait" => "Kuwait",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Latvia" => "Latvia",
// "Lebanon" => "Lebanon",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Lithuania" => "Lithuania",
// "Luxemburg" => "Luxemburg",
// "Macao" => "Macao",
// "Macedonia" => "Macedonia",
// "Madagascar" => "Madagascar",
// "Malawi" => "Malawi",
// "Malaysia" => "Malaysia",
// "Maldives" => "Maldives",
// "Mali" => "Mali",
// "Malta" => "Malta",
// "Marshall Islands" => "Marshall Islands",
// "Marshall_Islands" => "Marshall_Islands",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mauritius" => "Mauritius",
// "Mayotte" => "Mayotte",
// "Mexico" => "Mexico",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Morocco" => "Morocco",
// "Mozambique" => "Mozambique",
// "Myanmar" => "Myanmar",
// "Namibia" => "Namibia",
// "Nauru" => "Nauru",
// "Nepal" => "Nepal",
// "Netherlands Antilles" => "Netherlands Antilles",
// "Netherlands" => "Netherlands",
// "Netherlands_Antilles" => "Netherlands_Antilles",
// "New Caledonia" => "New Caledonia",
// "New Zealand" => "New Zealand",
// "New_Caledonia" => "New_Caledonia",
// "New_Zealand" => "New_Zealand",
// "Nicaragua" => "Nicaragua",
// "Niger" => "Niger",
// "Nigeria" => "Nigeria",
// "Niue" => "Niue",
// "None" => "None",
// "Norfolk Island" => "Norfolk Island",
// "Norfolk_Island" => "Norfolk_Island",
// "North Korea" => "North Korea",
// "North_Korea" => "North_Korea",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "Northern_Mariana_Islands" => "Northern_Mariana_Islands",
// "Norway" => "Norway",
// "Oman" => "Oman",
// "Other" => "Other",
// "Pakistan" => "Pakistan",
// "Palau" => "Palau",
// "Palestine" => "Palestine",
// "Panama" => "Panama",
// "Papua New Guinea" => "Papua New Guinea",
// "Papua_New_Guinea" => "Papua_New_Guinea",
// "Paraguay" => "Paraguay",
// "Peru" => "Peru",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Poland" => "Poland",
// "Portugal" => "Portugal",
// "Puerto Rico" => "Puerto Rico",
// "Puerto_Rico" => "Puerto_Rico",
// "Quatar" => "Quatar",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Republic_of_Macedonia" => "Republic_of_Macedonia",
// "Reunion" => "Reunion",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Russian Federation" => "Russian Federation",
// "Russian_Federation" => "Russian_Federation",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "Saint_Helena" => "Saint_Helena",
// "Saint_Kitts_and_Nevis" => "Saint_Kitts_and_Nevis",
// "Saint_Lucia" => "Saint_Lucia",
// "Saint_Pierre_and_Miquelon" => "Saint_Pierre_and_Miquelon",
// "Samoa" => "Samoa",
// "San Marino" => "San Marino",
// "San_Marino" => "San_Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Sao_Tome_and_Principe" => "Sao_Tome_and_Principe",
// "Saudi Arabia" => "Saudi Arabia",
// "Saudi_Arabia" => "Saudi_Arabia",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "Sierra_Leone" => "Sierra_Leone",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon Islands" => "Solomon Islands",
// "Solomon_Islands" => "Solomon_Islands",
// "Somalia" => "Somalia",
// "South Africa" => "South Africa",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "South Korea" => "South Korea",
// "South_Africa" => "South_Africa",
// "South_Georgia_and_South_Sandwich_Islands" => "South_Georgia_and_South_Sandwich_Islands",
// "South_Korea" => "South_Korea",
// "Spain" => "Spain",
// "Sri Lanka" => "Sri Lanka",
// "Sri_Lanka" => "Sri_Lanka",
// "St Vincent Grenadines" => "St Vincent Grenadines",
// "St_Vincent_Grenadines" => "St_Vincent_Grenadines",
// "Sudan" => "Sudan",
// "Surinam" => "Surinam",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Svalbard_and_Jan_Mayen" => "Svalbard_and_Jan_Mayen",
// "Swaziland" => "Swaziland",
// "Sweden" => "Sweden",
// "Switzerland" => "Switzerland",
// "Syria" => "Syria",
// "Taiwan" => "Taiwan",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Thailand" => "Thailand",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Tonga" => "Tonga",
// "Trinidad Tobago" => "Trinidad Tobago",
// "Trinidad_Tobago" => "Trinidad_Tobago",
// "Tunisia" => "Tunisia",
// "Turkey" => "Turkey",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Turks_and_Caicos_Islands" => "Turks_and_Caicos_Islands",
// "Tuvalu" => "Tuvalu",
// "US Virgin Islands" => "US Virgin Islands",
// "US_Virgin_Islands" => "US_Virgin_Islands",
// "Uganda" => "Uganda",
// "Ukraine" => "Ukraine",
// "United Arab Emirates" => "United Arab Emirates",
// "United Kingdom" => "United Kingdom",
// "United Nations Organization" => "United Nations Organization",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "United States" => "United States",
// "United_Arab_Emirates" => "United_Arab_Emirates",
// "United_Kingdom" => "United_Kingdom",
// "United_Kingdom_-_England_and_Wales" => "United_Kingdom_-_England_and_Wales",
// "United_Kingdom_-_Northern_Ireland" => "United_Kingdom_-_Northern_Ireland",
// "United_Kingdom_-_Scotland" => "United_Kingdom_-_Scotland",
// "United_Nations_Organization" => "United_Nations_Organization",
// "United_States" => "United_States",
// "United_States_Minor_Outlying_Islands" => "United_States_Minor_Outlying_Islands",
// "Uruguay" => "Uruguay",
// "Uzbekistan" => "Uzbekistan",
// "Vanuatu" => "Vanuatu",
// "Vatican" => "Vatican",
// "Venezuela" => "Venezuela",
// "Viet Nam" => "Viet Nam",
// "Viet_Nam" => "Viet_Nam",
// "Wales" => "Wales",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Wallis_and_Futuna" => "Wallis_and_Futuna",
// "Western Sahara" => "Western Sahara",
// "Western_Sahara" => "Western_Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
// "the former Yugoslav Republic of Macedonia" => "the former Yugoslav Republic of Macedonia",
// "the_former_Yugoslav_Republic_of_Macedonia" => "the_former_Yugoslav_Republic_of_Macedonia",
// "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter" => "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter",
// "MySQL Improved (mysqli). Requires MySQL 4.1+" => "MySQL Improved (mysqli). Requires MySQL 4.1+",
// "MySQL classic (mysql)" => "MySQL classic (mysql)",
// "PostgeSQL 7.2+" => "PostgeSQL 7.2+",
// "Oracle" => "Oracle",
// "Sybase" => "Sybase",
// "SQLLite" => "SQLLite",
// "MSSQL" => "MSSQL",
// "Email address not valid, test mail not sent" => "Email address not valid, test mail not sent",
// "Email address empty and \"copy\" checkbox not set, test mail not sent" => "Email address empty and \"copy\" checkbox not set, test mail not sent",
// "Test mail from Tiki installer " => "Test mail from Tiki installer ",
// "Tiki version" => "Tiki version",
// "PHP version" => "PHP version",
// "Server" => "Server",
// "Congratulations!\n\nYour server can send emails.\n\n" => "Congratulations!\n\nYour server can send emails.\n\n",
// "Slovene" => "Slovene",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "Simplified Chinese" => "Simplified Chinese",
// "Chinese" => "Chinese",
// "Czech" => "Czech",
// "Danish" => "Danish",
// "German" => "German",
// "English" => "English",
// "English British" => "English British",
// "Spanish" => "Spanish",
// "Greek" => "Greek",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Fijian" => "Fijian",
// "French" => "French",
// "Galician" => "Galician",
// "Hebrew" => "Hebrew",
// "Croatian" => "Croatian",
// "Italian" => "Italian",
// "Japanese" => "Japanese",
// "Korean" => "Korean",
// "Hungarian" => "Hungarian",
// "Dutch" => "Dutch",
// "Norwegian" => "Norwegian",
// "Polish" => "Polish",
// "Português" => "Português",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Russian" => "Russian",
// "Pijin Solomon" => "Pijin Solomon",
// "Slovak" => "Slovak",
// "Serbian" => "Serbian",
// "Serbian Latin" => "Serbian Latin",
// "Swedish" => "Swedish",
// "Tuvaluan" => "Tuvaluan",
// "Traditional Chinese" => "Traditional Chinese",
// "Ukrainian" => "Ukrainian",
// "This instance of activity is already complete" => "This instance of activity is already complete",
// "Fatal error: cannot execute automatic activity \$activityId" => "Fatal error: cannot execute automatic activity \$activityId",
// "Fatal error: setting next activity to an unexisting activity" => "Fatal error: setting next activity to an unexisting activity",
// "Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Fatal error: nextActivity does not match any candidate in autorouting switch activity",
// "Fatal error: non-deterministic decision for autorouting activity" => "Fatal error: non-deterministic decision for autorouting activity",
// "Fatal error: trying to send an instance to an activity but no transition found" => "Fatal error: trying to send an instance to an activity but no transition found",
// "Cannot add transition only split activities can have more than one outbound transition" => "Cannot add transition only split activities can have more than one outbound transition",
// "Circular reference found some activity has a transition leading to itself" => "Circular reference found some activity has a transition leading to itself",
// "Process does not have a start activity" => "Process does not have a start activity",
// "Process does not have exactly one end activity" => "Process does not have exactly one end activity",
// "End activity is not reachable from start activity" => "End activity is not reachable from start activity",
// "is interactive but has no role assigned" => "is interactive but has no role assigned",
// "is non-interactive and non-autorouted but has no role assigned" => "is non-interactive and non-autorouted but has no role assigned",
// "is standalone but has transitions" => "is standalone but has transitions",
// "is not mapped" => "is not mapped",
// "Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Activity '.\$res['name'].' is standalone and is using the \$instance object",
// "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method",
// "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method",
// "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method",
// "points" => "points",
// "newest" => "newest",
// "oldest" => "oldest",
// "on left side" => "on left side",
// "on center" => "on center",
// "on right side" => "on right side",
// "Link to user information" => "Link to user information",
// "User avatar" => "User avatar",
// "Blog title (asc)" => "Blog title (asc)",
// "Number of posts (desc)" => "Number of posts (desc)",
// "Visits (desc)" => "Visits (desc)",
// "Activity (desc)" => "Activity (desc)",
// "Top bar" => "Top bar",
// "Bottom bar" => "Bottom bar",
// "as Creator &amp; Last Editor" => "as Creator &amp; Last Editor",
// "Business style" => "Business style",
// "Collaborative style" => "Collaborative style",
// "no (disabled)" => "no (disabled)",
// "|| for rows" => "|| for rows",
// "<return> for rows" => "<return> for rows",
// "Only with last version" => "Only with last version",
// "Any 2 versions" => "Any 2 versions",
// "No error reporting" => "No error reporting",
// "Report all PHP errors" => "Report all PHP errors",
// "Report all errors except notices" => "Report all errors except notices",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Creation Date (desc)" => "Creation Date (desc)",
// "Threads (desc)" => "Threads (desc)",
// "Last post (desc)" => "Last post (desc)",
// "Name (desc)" => "Name (desc)",
// "Name (asc)" => "Name (asc)",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "replace current window" => "replace current window",
// "new window" => "new window",
// "inline frame" => "inline frame",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
// "Each day" => "Each day",
// "Each week" => "Each week",
// "Each month" => "Each month",
// "utf-8" => "utf-8",
// "iso-8859-1" => "iso-8859-1",
// "CRLF (standard)" => "CRLF (standard)",
// "LF (some Unix MTA)" => "LF (some Unix MTA)",
// "1 hour" => "1 hour",
// "2 hours" => "2 hours",
// "10 hours" => "10 hours",
// "20 hours" => "20 hours",
// "1 day" => "1 day",
// "1 week" => "1 week",
// "1 month" => "1 month",
// "1 year" => "1 year",
// "Allow secure (https) login" => "Allow secure (https) login",
// "Encourage secure (https) login" => "Encourage secure (https) login",
// "Consider we are always in HTTPS, but do not check" => "Consider we are always in HTTPS, but do not check",
// "Require secure (https) login" => "Require secure (https) login",
// "crypt-md5" => "crypt-md5",
// "crypt-des" => "crypt-des",
// "tikihash (old)" => "tikihash (old)",
// "Just Tiki" => "Just Tiki",
// "Web Server" => "Web Server",
// "Tiki and PEAR::Auth" => "Tiki and PEAR::Auth",
// "Tiki and PAM" => "Tiki and PAM",
// "CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
// "Shibboleth" => "Shibboleth",
// "OpenID and Tiki" => "OpenID and Tiki",
// "choose a group .." => "choose a group ..",
// "Admins" => "Admins",
// "Never use transition css" => "Never use transition css",
// "Use @version:x.x specified in theme css or none if not specified" => "Use @version:x.x specified in theme css or none if not specified",
// "Use @version:x.x specified in theme css or 1.9 if not specified" => "Use @version:x.x specified in theme css or 1.9 if not specified",
// "Use @version:x.x specified in theme css or 2.0 if not specified" => "Use @version:x.x specified in theme css or 2.0 if not specified",
// "LastModif" => "LastModif",
// "Use database to store files" => "Use database to store files",
// "Use a directory to store files" => "Use a directory to store files",
// "Ascending" => "Ascending",
// "Descending" => "Descending",
// "%s enabled" => "%s enabled",
// "\$feature is turned on" => "\$feature is turned on",
// "%s disabled" => "%s disabled",
// "\$feature is turned off" => "\$feature is turned off",
// "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing" => "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing",
// "\$feature set to nothing" => "\$feature set to nothing",
// "All Day" => "All Day",
// "Invalid filename (using filters for filenames)" => "Invalid filename (using filters for filenames)",
// "Please wait %d secondes between posts" => "Please wait %d secondes between posts",
// "You have to enter a title and text" => "You have to enter a title and text",
// "Invalid Email" => "Invalid Email",
// "Your message has been queued for approval, the message will be posted after a moderator approves it" => "Your message has been queued for approval, the message will be posted after a moderator approves it",
// "This forum is locked" => "This forum is locked",
// "This thread is locked" => "This thread is locked",
// "Those comments are locked" => "Those comments are locked",
// "Foo" => "Foo",
// "Sample plugin" => "Sample plugin",
// "Face" => "Face",
// "Font family to use" => "Font family to use",
// "As defined by CSS" => "As defined by CSS",
// "WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::apply: line count mismatch: %s != %s",
// "WikiDiff::_check: failed" => "WikiDiff::_check: failed",
// "WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_check: edit sequence is non-optimal",
// "WikiDiff Okay: LCS = %s" => "WikiDiff Okay: LCS = %s",
// "Newsletter subscription information at" => "Newsletter subscription information at",
// "This is an approximation based on your server memory limit" => "This is an approximation based on your server memory limit",
// "This is the value of your server's PHP '%s' setting" => "This is the value of your server's PHP '%s' setting",
// "You are alerted by the server " => "You are alerted by the server ",
// "You can check the modifications at : " => "You can check the modifications at : ",
// "You are alerted of a change on " => "You are alerted of a change on ",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it" => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it",
// "File %s is not a valid archive" => "File %s is not a valid archive",
// "Impossible to open %s : %s" => "Impossible to open %s : %s",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "section edit" => "section edit",
// "Created by profile installer" => "Created by profile installer",
// "Page updated by profile installer" => "Page updated by profile installer",
// "Wiki Comment" => "Wiki Comment",
// "Calendar item" => "Calendar item",
// "_HOMEPAGE_CONTENT_" => "_HOMEPAGE_CONTENT_",
// "<!-- jq smarty plugin inactive: feature_jquery off -->" => "<!-- jq smarty plugin inactive: feature_jquery off -->",
// "You need either JQuery or MooTools enabled for this feature" => "You need either JQuery or MooTools enabled for this feature",
// "character(s) too long - please edit it" => "character(s) too long - please edit it",
// "Text cut here" => "Text cut here",
// "Last seen on" => "Last seen on",
// "Yes" => "Yes",
// "No pageviews yet" => "No pageviews yet",
// "n/a" => "n/a",
// "You have to make %d choice(s) for the question" => "You have to make %d choice(s) for the question",
// "You have to make at least %d choice(s) for the question" => "You have to make at least %d choice(s) for the question",
// "You have to make less than %d choice(s) for the question" => "You have to make less than %d choice(s) for the question",
// "You have to choose at least %d choice(s) for the question" => "You have to choose at least %d choice(s) for the question",
// "Page '%0' cannot be found" => "Page '%0' cannot be found",
// "Permission denied you cannot view this section" => "Permission denied you cannot view this section",
// "For the security of your password direct access to the feed is only available via https" => "For the security of your password direct access to the feed is only available via https",
// "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors" => "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors",
// "Help link" => "Help link",
// "Edit Plugin" => "Edit Plugin",
// "Flash player not available" => "Flash player not available",
// "__WARNING__: Plugin disabled \$plugin" => "__WARNING__: Plugin disabled \$plugin",
// "__WARNING__: No such module \$plugin" => "__WARNING__: No such module \$plugin",
// "Sea Surfing (CSRF) detected. Operation blocked" => "Sea Surfing (CSRF) detected. Operation blocked",
// "Rating" => "Rating",
// "View the tracker item at" => "View the tracker item at",
// "prepend" => "prepend",
// "append" => "append",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "drop down with other textfield" => "drop down with other textfield",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "radio buttons" => "radio buttons",
// "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>",
// "ip selector" => "ip selector",
// "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>",
// "page selector" => "page selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>",
// "jscalendar" => "jscalendar",
// "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "item link" => "item link",
// "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "items list" => "items list",
// "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "dynamic items list" => "dynamic items list",
// "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>",
// "auto-increment" => "auto-increment",
// "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "User-Agent Info" => "User-Agent Info",
// "Displays various information about the client" => "Displays various information about the client",
// "Info" => "Info",
// "Info required - IP|SVRSW|BROWSER" => "Info required - IP|SVRSW|BROWSER",
// "Anchor Link" => "Anchor Link",
// "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin" => "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin",
// "Anchor link label" => "Anchor link label",
// "The anchor name as defined in the ANAME plugin" => "The anchor name as defined in the ANAME plugin",
// "The name of the wiki page containing the anchor" => "The name of the wiki page containing the anchor",
// "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor",
// "Anchor Name" => "Anchor Name",
// "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin" => "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin",
// "The name of the anchor" => "The name of the anchor",
// "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor",
// "Image Annotation" => "Image Annotation",
// "Autogenerated content. Leave blank initially" => "Autogenerated content. Leave blank initially",
// "Absolute URL to the image or relative path from tikiwiki root" => "Absolute URL to the image or relative path from tikiwiki root",
// "Width" => "Width",
// "Image width" => "Image width",
// "Height" => "Height",
// "Image height" => "Image height",
// "Alignment" => "Alignment",
// "Image alignment. Possible values: left, right, center" => "Image alignment. Possible values: left, right, center",
// "Image annotations changed" => "Image annotations changed",
// "Displays an image and allow the users to define zones to highlight information on the image" => "Displays an image and allow the users to define zones to highlight information on the image",
// "Includes an article\\'s content within the page" => "Includes an article\\'s content within the page",
// "The article field to display. Default field is Heading" => "The article field to display. Default field is Heading",
// "Article ID" => "Article ID",
// "The article to display. If no value is provided, most recent article will be used" => "The article to display. If no value is provided, most recent article will be used",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading" => "Id is optional. If not given, last article is used. Default field is heading",
// "Article List" => "Article List",
// "Includes a list of articles within the page" => "Includes a list of articles within the page",
// "Articles displayed" => "Articles displayed",
// "The amount of articles to display in the list" => "The amount of articles to display in the list",
// "Topics expression" => "Topics expression",
// "Topic ID expression" => "Topic ID expression",
// "Type expression" => "Type expression",
// "Category ID" => "Category ID",
// "The ID of the category to list from" => "The ID of the category to list from",
// "The article language to list" => "The article language to list",
// "Sort order" => "Sort order",
// "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")" => "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")",
// "Quiet" => "Quiet",
// "Whether to not report when there are no articles" => "Whether to not report when there are no articles",
// "Title only" => "Title only",
// "Whether to only show the title of the articles" => "Whether to only show the title of the articles",
// "Show body" => "Show body",
// "Whether to only show the body of the articles or just the heading" => "Whether to only show the body of the articles or just the heading",
// "Starting article" => "Starting article",
// "The article number that the list should start with" => "The article number that the list should start with",
// "Start date" => "Start date",
// "Earliest date to select articles from" => "Earliest date to select articles from",
// "End date" => "End date",
// "Latest date to select articles from" => "Latest date to select articles from",
// "Override Dates" => "Override Dates",
// "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings" => "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings",
// "Container class" => "Container class",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~",
// "Bullets" => "Bullets",
// "Inline" => "Inline",
// "Number" => "Number",
// "Show icon" => "Show icon",
// "No such attachment on this page" => "No such attachment on this page",
// "Displays an attachment or a list of them" => "Displays an attachment or a list of them",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description" => "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "The wiki page the avatar will link to" => "The wiki page the avatar will link to",
// "Float" => "Float",
// "left|right" => "left|right",
// "Displays a link that allows to go back in the browser history" => "Displays a link that allows to go back in the browser history",
// "Insert back link on wiki page" => "Insert back link on wiki page",
// "List all pages linking to the specified page" => "List all pages linking to the specified page",
// "The page links will point to. Default value is the current page" => "The page links will point to. Default value is the current page",
// "Displayed information" => "Displayed information",
// "Pipe separated list of fields to display. ex: hits|user" => "Pipe separated list of fields to display. ex: hits|user",
// "Excluded pages" => "Excluded pages",
// "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox" => "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox",
// "Include Self" => "Include Self",
// "1|0" => "1|0",
// "No Header" => "No Header",
// "List all pages which link to specific pages" => "List all pages which link to specific pages",
// "Banner" => "Banner",
// "Insert a banner" => "Insert a banner",
// "Zone" => "Zone",
// "Target" => "Target",
// "missing parameter" => "missing parameter",
// "Blog List" => "Blog List",
// "Use BLOGLIST to include posts from a blog" => "Use BLOGLIST to include posts from a blog",
// "Blog ID" => "Blog ID",
// "Numeric value" => "Numeric value",
// "Items" => "Items",
// "Maximum number of entries to list" => "Maximum number of entries to list",
// "Simple list" => "Simple list",
// "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)" => "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)",
// "Earliest date to select posts from" => "Earliest date to select posts from",
// "Latest date to select posts from" => "Latest date to select posts from",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")",
// "where Id is the blog Id and Items is the max number of posts to display" => "where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Box" => "Box",
// "Insert theme styled box on wiki page" => "Insert theme styled box on wiki page",
// "Box title" => "Box title",
// "Displayed above the content" => "Displayed above the content",
// "Background color" => "Background color",
// "As defined by CSS, name or Hex code" => "As defined by CSS, name or Hex code",
// "Box width" => "Box width",
// "In pixels or percentage. Default value is 100%" => "In pixels or percentage. Default value is 100%",
// "Text Alignment" => "Text Alignment",
// "Float Position" => "Float Position",
// "for box with width lesser than 100%, make text wrap around the box" => "for box with width lesser than 100%, make text wrap around the box",
// "CSS Class" => "CSS Class",
// "Apply custom CSS class to the box" => "Apply custom CSS class to the box",
// "Category IDs" => "Category IDs",
// "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page" => "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page",
// "Types" => "Types",
// "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img" => "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img",
// "Sort Order" => "Sort Order",
// "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle" => "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle",
// "Split" => "Split",
// "And" => "And",
// "Insert list of items for the current/given category into wiki page" => "Insert list of items for the current/given category into wiki page",
// "Category Orphans" => "Category Orphans",
// "Display Tiki objects that have not been categorized" => "Display Tiki objects that have not been categorized",
// "Objects" => "Objects",
// "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker" => "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker",
// "Category Path" => "Category Path",
// "Separator" => "Separator",
// "String used to separate the categories in the path. Default character is >" => "String used to separate the categories in the path. Default character is >",
// "Display top category" => "Display top category",
// "yes|no, default to no" => "yes|no, default to no",
// "Insert the full category path for each category that this wiki page belongs to" => "Insert the full category path for each category that this wiki page belongs to",
// "Center" => "Center",
// "Centers the plugin content in the wiki page" => "Centers the plugin content in the wiki page",
// "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool" => "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool",
// "Chart caption" => "Chart caption",
// "Sheet ID" => "Sheet ID",
// "Data sheet ID" => "Data sheet ID",
// "Chart Type" => "Chart Type",
// "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic" => "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic",
// "Chart Width" => "Chart Width",
// "Width in pixels" => "Width in pixels",
// "Chart Height" => "Chart Height",
// "Height in pixels" => "Height in pixels",
// "Value series" => "Value series",
// "Required for pie charts" => "Required for pie charts",
// "Independant series" => "Independant series",
// "Required for types other than pie chart" => "Required for types other than pie chart",
// "Dependant series" => "Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors" => "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors",
// "List of colors to use" => "List of colors to use",
// "Styles" => "Styles",
// "List of styles to use" => "List of styles to use",
// "Labels" => "Labels",
// "Labels for the series or values in the legend" => "Labels for the series or values in the legend",
// "Chart as PostScript" => "Chart as PostScript",
// "Code" => "Code",
// "Displays a snippet of code" => "Displays a snippet of code",
// "Caption" => "Caption",
// "Code snippet label" => "Code snippet label",
// "Word Wrap" => "Word Wrap",
// "0|1, Enable word wrapping on the code to avoid breaking the layout" => "0|1, Enable word wrapping on the code to avoid breaking the layout",
// "Colors" => "Colors",
// "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, .." => "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, ..",
// "Line numbers" => "Line numbers",
// "0|1, may not be used with colors" => "0|1, may not be used with colors",
// "Wiki syntax" => "Wiki syntax",
// "0|1, parse wiki syntax within the code snippet" => "0|1, parse wiki syntax within the code snippet",
// "Right to left" => "Right to left",
// "0|1, switch the text display from left to right to right to left" => "0|1, switch the text display from left to right to right to left",
// "Content is HTML" => "Content is HTML",
// "0|1, display the content as is instead of escaping HTML special chars" => "0|1, display the content as is instead of escaping HTML special chars",
// "note: colors and ln are exclusive" => "note: colors and ln are exclusive",
// "Dynamic Content" => "Dynamic Content",
// "Includes content from the dynamic content system" => "Includes content from the dynamic content system",
// "Content ID" => "Content ID",
// "Also known as Fortune cookies or Taglines" => "Also known as Fortune cookies or Taglines",
// "Insert copyright notices" => "Insert copyright notices",
// "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~" => "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~",
// "Countdown" => "Countdown",
// "Displays a countdown from now until the specified date" => "Displays a countdown from now until the specified date",
// "Text to append to the countdown" => "Text to append to the countdown",
// "Target date. Multiple formats accepted" => "Target date. Multiple formats accepted",
// "Locate Time" => "Locate Time",
// "on|off" => "on|off",
// "DBReport" => "DBReport",
// "Run a database report" => "Run a database report",
// "report definition" => "report definition",
// "Full DSN" => "Full DSN",
// "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database" => "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database",
// "Wiki DSN name" => "Wiki DSN name",
// "The name of a DSN connection defined by the Wiki administrator" => "The name of a DSN connection defined by the Wiki administrator",
// "0|1, parse wiki syntax within the report" => "0|1, parse wiki syntax within the report",
// "Debug" => "Debug",
// "0|1, display the parsed report definition" => "0|1, display the parsed report definition",
// "Missing db or dsn parameter" => "Missing db or dsn parameter",
// "You do not have permission to use this DSN" => "You do not have permission to use this DSN",
// "No DSN connection string found" => "No DSN connection string found",
// "Div" => "Div",
// "div|span|pre|b|i|tt|p|blockquote" => "div|span|pre|b|i|tt|p|blockquote",
// "left|right|center|justify" => "left|right|center|justify",
// "left|right, for box with width lesser than 100%, make text wrap around the box" => "left|right, for box with width lesser than 100%, make text wrap around the box",
// "Apply custom CSS class to the div" => "Apply custom CSS class to the div",
// "HTML id" => "HTML id",
// "Sets the div\\'s id attribute, as defined by HTML" => "Sets the div\\'s id attribute, as defined by HTML",
// "Insert a division block on wiki page" => "Insert a division block on wiki page",
// "Definition List" => "Definition List",
// "One entry per line. Each line is in \"Term: Definition\" format" => "One entry per line. Each line is in \"Term: Definition\" format",
// "Creates a definition list" => "Creates a definition list",
// "term" => "term",
// "definition" => "definition",
// "one definition per line" => "one definition per line",
// "Draw" => "Draw",
// "Displays drawings in the wiki page" => "Displays drawings in the wiki page",
// "Name of the drawing to display" => "Name of the drawing to display",
// "Name parameter missing" => "Name parameter missing",
// "Equation" => "Equation",
// "Renders an equation written in LaTeX syntax as an image" => "Renders an equation written in LaTeX syntax as an image",
// "equation" => "equation",
// "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large" => "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "Includes the list of events from a calendar in the page" => "Includes the list of events from a calendar in the page",
// "Calendar ID" => "Calendar ID",
// "Numeric" => "Numeric",
// "Maximum days" => "Maximum days",
// "Maximum Rows" => "Maximum Rows",
// "Datetime" => "Datetime",
// "0|1" => "0|1",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "Upcoming events" => "Upcoming events",
// "Fade" => "Fade",
// "Displays a label. On click, the block of content will fade in and fade out" => "Displays a label. On click, the block of content will fade in and fade out",
// "Wiki syntax containing the text to display" => "Wiki syntax containing the text to display",
// "Label to display on first display" => "Label to display on first display",
// "Unspecified label" => "Unspecified label",
// "Fancy List" => "Fancy List",
// "One item per line starting with anything followed by \")\"" => "One item per line starting with anything followed by \")\"",
// "Use div" => "Use div",
// "Use div instead of ol" => "Use div instead of ol",
// "Class" => "Class",
// "CSS class of the fancylist" => "CSS class of the fancylist",
// "Creates a fancy looking list" => "Creates a fancy looking list",
// "num" => "num",
// "item text" => "item text",
// "one item per line" => "one item per line",
// "Fancy Table" => "Fancy Table",
// "One row per line, cells separated by ~|~" => "One row per line, cells separated by ~|~",
// "Heading row" => "Heading row",
// "Heading row of the table, same format as the body section" => "Heading row of the table, same format as the body section",
// "Heading CSS Class" => "Heading CSS Class",
// "CSS Class to apply on the heading row" => "CSS Class to apply on the heading row",
// "Displays the data using the Tikiwiki odd/even table style" => "Displays the data using the Tikiwiki odd/even table style",
// "cells" => "cells",
// "heads and cells separated by ~|~" => "heads and cells separated by ~|~",
// "Displays a link to an attachment to a wiki page and can display an image attachment. " => "Displays a link to an attachment to a wiki page and can display an image attachment. ",
// "Gallery ID" => "Gallery ID",
// "sort" => "sort",
// "name_asc" => "name_asc",
// "Shows ID" => "Shows ID",
// "Shows Icon" => "Shows Icon",
// "Shows Name" => "Shows Name",
// "Shows Filename" => "Shows Filename",
// "Shows Size" => "Shows Size",
// "Shows Description" => "Shows Description",
// "Shows Creation Date" => "Shows Creation Date",
// "Shows Hits" => "Shows Hits",
// "Shows Locked by" => "Shows Locked by",
// "Shows Modification Date" => "Shows Modification Date",
// "Shows Author" => "Shows Author",
// "Shows Creator" => "Shows Creator",
// "Shows Parent Gallery Name" => "Shows Parent Gallery Name",
// "Shows Number of Files" => "Shows Number of Files",
// "Shows the slideshow of a gallery" => "Shows the slideshow of a gallery",
// "List files in a file gallery (with a category) or in a category or a file gallery od this category" => "List files in a file gallery (with a category) or in a category or a file gallery od this category",
// "Displays a list of files from the File Gallery" => "Displays a list of files from the File Gallery",
// "Flash video" => "Flash video",
// "Displays a SWF on the wiki page" => "Displays a SWF on the wiki page",
// "Movie URL" => "Movie URL",
// "Complete URL to the movie to include" => "Complete URL to the movie to include",
// "Default width: 425" => "Default width: 425",
// "Default height: 350" => "Default height: 350",
// "Quality" => "Quality",
// "Flash video quality. Default value: high" => "Flash video quality. Default value: high",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Footnote" => "Footnote",
// "Inserts a superscripted footnote number next to text and takes in footnote as parameter" => "Inserts a superscripted footnote number next to text and takes in footnote as parameter",
// "The footnote" => "The footnote",
// "Sameas" => "Sameas",
// "Tag to existing footnote" => "Tag to existing footnote",
// "CheckDuplicate" => "CheckDuplicate",
// "check for duplcate footnotes" => "check for duplcate footnotes",
// "Footnotearea" => "Footnotearea",
// "Inserts a section for collected footnotes within the wiki page" => "Inserts a section for collected footnotes within the wiki page",
// "Download box for a file on ftp server" => "Download box for a file on ftp server",
// "ftp" => "ftp",
// "file name" => "file name",
// "Ftp Server Name" => "Ftp Server Name",
// "Ftp User name" => "Ftp User name",
// "Ftp password" => "Ftp password",
// "Download button label" => "Download button label",
// "Connection failed" => "Connection failed",
// "failed" => "failed",
// "Gauge" => "Gauge",
// "Displays a graphical gauge" => "Displays a graphical gauge",
// "description" => "description",
// "Value" => "Value",
// "current value (REQUIRED)" => "current value (REQUIRED)",
// "Maximum Value" => "Maximum Value",
// "Maximum possible value. Default: 100" => "Maximum possible value. Default: 100",
// "Label displayed on the left side of the gauge" => "Label displayed on the left side of the gauge",
// "Color" => "Color",
// "Background Color" => "Background Color",
// "Bar width in pixels" => "Bar width in pixels",
// "Label Width" => "Label Width",
// "Width in pixels allocated to the label" => "Width in pixels allocated to the label",
// "Display Percentage" => "Display Percentage",
// "true|false, if true then a percentage of the maximum is displayed" => "true|false, if true then a percentage of the maximum is displayed",
// "Display Value" => "Display Value",
// "true|false, if the numeric value is displayed" => "true|false, if the numeric value is displayed",
// "Bar height in pixels" => "Bar height in pixels",
// "Displays a graphical GAUGE" => "Displays a graphical GAUGE",
// "Google Analytics" => "Google Analytics",
// "Add the tracking code for Google Analytics" => "Add the tracking code for Google Analytics",
// "Account number" => "Account number",
// "The account number for the site" => "The account number for the site",
// "googledoc" => "googledoc",
// "Leave this empty" => "Leave this empty",
// "type" => "type",
// "Type of Google document" => "Type of Google document",
// "key" => "key",
// "Google doc key - for example pXsHENf1bGGY92X1iEeJJI" => "Google doc key - for example pXsHENf1bGGY92X1iEeJJI",
// "Name of iframe" => "Name of iframe",
// "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large" => "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large",
// "Pixels or %" => "Pixels or %",
// "Margin Height" => "Margin Height",
// "Pixels" => "Pixels",
// "Margin Width" => "Margin Width",
// "Scrolling" => "Scrolling",
// "editLink" => "editLink",
// "Required parameter \"type\" missing" => "Required parameter \"type\" missing",
// "Required parameter \"key\" missing" => "Required parameter \"key\" missing",
// "Displays a Google document" => "Displays a Google document",
// "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition" => "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition",
// "Allowed Groups" => "Allowed Groups",
// "Pipe separated list of groups allowed to view the block. ex: Admins|Developers" => "Pipe separated list of groups allowed to view the block. ex: Admins|Developers",
// "Denied Groups" => "Denied Groups",
// "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers" => "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "HTML" => "HTML",
// "Include literal HTML in a Wiki page" => "Include literal HTML in a Wiki page",
// "0|1, parse wiki syntax within the html code" => "0|1, parse wiki syntax within the html code",
// "Include literal HTML" => "Include literal HTML",
// "Iframe" => "Iframe",
// "name" => "name",
// "Frame title" => "Frame title",
// "iframe" => "iframe",
// "Displays an iframe" => "Displays an iframe",
// " (experimental - possible successor to img in 4.0)" => " (experimental - possible successor to img in 4.0)",
// "File ID" => "File ID",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Image Source" => "Image Source",
// "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required" => "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required",
// "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded" => "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded",
// "Alias: lnk. Location the image should point to" => "Alias: lnk. Location the image should point to",
// "Link Relation" => "Link Relation",
// "\"rel\" attribute to add to the link" => "\"rel\" attribute to add to the link",
// "Link title" => "Link title",
// "Title text" => "Title text",
// "Image alt text" => "Image alt text",
// "Alternate text to display if impossible to load the image" => "Alternate text to display if impossible to load the image",
// "Alias:imalign. Image alignment in the page. (left, right)" => "Alias:imalign. Image alignment in the page. (left, right)",
// "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)" => "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)",
// "Image description to display on the page" => "Image description to display on the page",
// "Image Map" => "Image Map",
// "Name of the image map to use for the image" => "Name of the image map to use for the image",
// "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)" => "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)",
// "CSS Style" => "CSS Style",
// "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)" => "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)",
// "Border options" => "Border options",
// "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options" => "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options",
// "Description options" => "Description options",
// "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)" => "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)",
// "Default configuration" => "Default configuration",
// "Default configuration definitions. (Usually used in configuration rather than on individual images.)" => "Default configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Mandatory configuration" => "Mandatory configuration",
// "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)" => "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content" => "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content",
// "Display an image" => "Display an image",
// "Displays an image" => "Displays an image",
// "Full URL to the image to display" => "Full URL to the image to display",
// "Alternate Text" => "Alternate Text",
// "Height of the image to display" => "Height of the image to display",
// "Width of the image to display" => "Width of the image to display",
// "Link Title" => "Link Title",
// "Image alignment in the page. (left, right, center) Uses HTML IMG tag" => "Image alignment in the page. (left, right, center) Uses HTML IMG tag",
// "Float Alignment" => "Float Alignment",
// "Image alignment in the flow of the document. (left, right, none) Uses CSS float property" => "Image alignment in the flow of the document. (left, right, none) Uses CSS float property",
// "Style to apply to the image" => "Style to apply to the image",
// "Include" => "Include",
// "Include a page\\'s content" => "Include a page\\'s content",
// "Page Name" => "Page Name",
// "Wiki page name to include" => "Wiki page name to include",
// "When only a portion of the page should be included, specify the marker from which inclusion should start" => "When only a portion of the page should be included, specify the marker from which inclusion should start",
// "When only a portion of the page should be included, specify the marker at which inclusion should end" => "When only a portion of the page should be included, specify the marker at which inclusion should end",
// "Include a page" => "Include a page",
// "Jabber" => "Jabber",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Applet height in pixels" => "Applet height in pixels",
// "'),\n\t\t\t\t'description' => tra('Applet width in pixels" => "'),\n\t\t\t\t'description' => tra('Applet width in pixels",
// "'),\n\t\t\t\t'description' => tra('jabber.org" => "'),\n\t\t\t\t'description' => tra('jabber.org",
// "Default Color" => "Default Color",
// "255,255,255" => "255,255,255",
// "JQuery" => "JQuery",
// "Insert JQuery javascript code. Requires feature_jquery" => "Insert JQuery javascript code. Requires feature_jquery",
// " (experimental - may change in future versions)" => " (experimental - may change in future versions)",
// "JQuery Code" => "JQuery Code",
// "NotOnReady" => "NotOnReady",
// "NoJQuery" => "NoJQuery",
// "Optional markup for when feature_jquery is off" => "Optional markup for when feature_jquery is off",
// "Insert JQuery javascript code" => "Insert JQuery javascript code",
// "jquery code e.g. \$jq(\"img\\" => "jquery code e.g. \$jq(\"img\\",
// "Do not execute on document ready (execute inline)" => "Do not execute on document ready (execute inline)",
// "Javascript" => "Javascript",
// "Insert a javascript file or/and some javascript code" => "Insert a javascript file or/and some javascript code",
// "javascript code" => "javascript code",
// "Javascript filename" => "Javascript filename",
// "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Not Language" => "Not Language",
// "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Displays the text only if the language matchs" => "Displays the text only if the language matchs",
// "Page name to display information of. Default value is current page" => "Page name to display information of. Default value is current page",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "Result Offset" => "Result Offset",
// "Result number at which the listing should start" => "Result number at which the listing should start",
// "Result Count" => "Result Count",
// "Amount of results displayed in the list" => "Amount of results displayed in the list",
// "Initial" => "Initial",
// "txt" => "txt",
// "Show Name Only" => "Show Name Only",
// "Structure Head" => "Structure Head",
// "Show Page Alias" => "Show Page Alias",
// "Two letter language code to filter pages listed" => "Two letter language code to filter pages listed",
// "Orphan Language" => "Orphan Language",
// "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed" => "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed",
// "Load Translations" => "Load Translations",
// "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter" => "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter",
// "Exact Match" => "Exact Match",
// "Related to Find" => "Related to Find",
// "Only Orphan Pages" => "Only Orphan Pages",
// "For List Pages" => "For List Pages",
// "List Directory" => "List Directory",
// "Full path to the server-local directory" => "Full path to the server-local directory",
// "URL Prefix" => "URL Prefix",
// ".ext" => ".ext",
// "Limit" => "Limit",
// "Maximum amount of files to display" => "Maximum amount of files to display",
// "Map" => "Map",
// "Displays a map" => "Displays a map",
// "Map File" => "Map File",
// "Extents" => "Extents",
// "Feature disabled" => "Feature disabled",
// "Inline Flash mp3 and flv Player" => "Inline Flash mp3 and flv Player",
// "Mediaplayer" => "Mediaplayer",
// "MP3 URL" => "MP3 URL",
// "Complete URL to the mp3 to include" => "Complete URL to the mp3 to include",
// "FLV URL" => "FLV URL",
// "Complete URL to the flv to include" => "Complete URL to the flv to include",
// "One of" => "One of",
// "Mini Quiz" => "Mini Quiz",
// "Displays a miniquiz" => "Displays a miniquiz",
// "Instructions::Feedback" => "Instructions::Feedback",
// "Tracker ID" => "Tracker ID",
// "Insert Module" => "Insert Module",
// "Module name as known in Tikiwiki" => "Module name as known in Tikiwiki",
// "Decoration" => "Decoration",
// "Flip" => "Flip",
// "Max" => "Max",
// "np" => "np",
// "notitle" => "notitle",
// "Please choose a module" => "Please choose a module",
// "to be used as argument" => "to be used as argument",
// "Displays a module inlined in page" => "Displays a module inlined in page",
// "Displays a module inlined in page. More parameters can be added, not supported by UI" => "Displays a module inlined in page. More parameters can be added, not supported by UI",
// "Sorry no such module" => "Sorry no such module",
// "Monospace" => "Monospace",
// "Font" => "Font",
// "Font name as known in browsers" => "Font name as known in browsers",
// "Displays the data using a monospace font" => "Displays the data using a monospace font",
// "Mouse Over" => "Mouse Over",
// "Create a mouseover feature on some text" => "Create a mouseover feature on some text",
// "Mouseover text if param label exists. Page text if text param exists" => "Mouseover text if param label exists. Page text if text param exists",
// "Text displayed on the page. The body is the mouseover content" => "Text displayed on the page. The body is the mouseover content",
// "Destination link when moused-over text is clicked. Use http:// for external links" => "Destination link when moused-over text is clicked. Use http:// for external links",
// "Text" => "Text",
// "DEPRECATED" => "DEPRECATED",
// "Text displayed on the mouseover. The body contains the text of the page" => "Text displayed on the mouseover. The body contains the text of the page",
// "Mouse over box width. Default: 400px" => "Mouse over box width. Default: 400px",
// "Mouse over box height. Default: 200px" => "Mouse over box height. Default: 200px",
// "Offset X" => "Offset X",
// "Shifts the overlay to the right by the specified amount of pixels in relation to the cursor. Default: 5px" => "Shifts the overlay to the right by the specified amount of pixels in relation to the cursor. Default: 5px",
// "Offset Y" => "Offset Y",
// "Shifts the overlay to the bottom by the specified amount of pixels in relation to the cursor. Default: 0px" => "Shifts the overlay to the bottom by the specified amount of pixels in relation to the cursor. Default: 0px",
// "Parse Body" => "Parse Body",
// "y|n, parse the body of the plugin as wiki content. (Default to y)" => "y|n, parse the body of the plugin as wiki content. (Default to y)",
// "Color of the inside popup" => "Color of the inside popup",
// "Default: #F5F5F5" => "Default: #F5F5F5",
// "Text popup color" => "Text popup color",
// "#FFFFFF" => "#FFFFFF",
// "Sticky" => "Sticky",
// "Padding" => "Padding",
// "No label specified" => "No label specified",
// "MWTable" => "MWTable",
// "fancy" => "fancy",
// "true|false" => "true|false",
// "wiki_classes" => "wiki_classes",
// "Displays the data using (sort of) MediaWiki syntax" => "Displays the data using (sort of) MediaWiki syntax",
// "Displays a table using MediaWiki syntax" => "Displays a table using MediaWiki syntax",
// "MySpace" => "MySpace",
// "MySpace Page" => "MySpace Page",
// "Displays a SWF myspace mp3 playlist on the wiki page" => "Displays a SWF myspace mp3 playlist on the wiki page",
// "Object Hits" => "Object Hits",
// "Object ID" => "Object ID",
// "Object Type" => "Object Type",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "Picture" => "Picture",
// "Search for images uploaded by users" => "Search for images uploaded by users",
// " (deprecated - scheduled to be removed or changed significantly)" => " (deprecated - scheduled to be removed or changed significantly)",
// "Filename or full path to file" => "Filename or full path to file",
// "Plugin Manager" => "Plugin Manager",
// "Multiple values separated with | can be used" => "Multiple values separated with | can be used",
// "Provides a list of plugins on this wiki" => "Provides a list of plugins on this wiki",
// "No version indicated" => "No version indicated",
// "No arguments indicated" => "No arguments indicated",
// "Poll ID" => "Poll ID",
// "Displays the output of a poll, fields are indicated with numeric ids" => "Displays the output of a poll, fields are indicated with numeric ids",
// "missing poll ID for plugin POLL" => "missing poll ID for plugin POLL",
// "Profile Installer" => "Profile Installer",
// "Adds controls required to install a profile" => "Adds controls required to install a profile",
// "Domain" => "Domain",
// "Profile repository domain. Default value is profiles.tikiwiki.org" => "Profile repository domain. Default value is profiles.tikiwiki.org",
// "Profile Name" => "Profile Name",
// "Name of the profile" => "Name of the profile",
// "Profile plugin only available to administrators" => "Profile plugin only available to administrators",
// "Profile %0/%1 not found" => "Profile %0/%1 not found",
// "Proposal" => "Proposal",
// "Provides a widget for users to vote on a proposal and view the current decision" => "Provides a widget for users to vote on a proposal and view the current decision",
// "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username" => "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username",
// "Accept proposal" => "Accept proposal",
// "Still undecided" => "Still undecided",
// "Reject proposal" => "Reject proposal",
// "Displays a proposal acceptance widget" => "Displays a proposal acceptance widget",
// "Short description of the proposal to vote on. Will be displayed above the result table" => "Short description of the proposal to vote on. Will be displayed above the result table",
// "Quote" => "Quote",
// "Quoted text" => "Quoted text",
// "Reply to" => "Reply to",
// "Name of the quoted person" => "Name of the quoted person",
// "wrote" => "wrote",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "Random Dynamic Content" => "Random Dynamic Content",
// "Includes random content from the dynamic content system" => "Includes random content from the dynamic content system",
// "Redirect" => "Redirect",
// "Redirect the user to a wiki page or generic URL" => "Redirect the user to a wiki page or generic URL",
// "Wiki page name to redirect to" => "Wiki page name to redirect to",
// "Complete URL, internal or external" => "Complete URL, internal or external",
// "Redirects you to another wiki page" => "Redirects you to another wiki page",
// "Regular Expression" => "Regular Expression",
// "Takes regex expressions and parses the content between REGEX tags and replaces the text" => "Takes regex expressions and parses the content between REGEX tags and replaces the text",
// "Page name containing the regular expression" => "Page name containing the regular expression",
// "Takes regex expressions and parses the content between the REGEX tags and replaces the text" => "Takes regex expressions and parses the content between the REGEX tags and replaces the text",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "Remarks Box" => "Remarks Box",
// "Label displayed above the remark" => "Label displayed above the remark",
// "Highlight" => "Highlight",
// "Icon ID" => "Icon ID",
// "RSS Feed" => "RSS Feed",
// "Inserts an RSS feed output" => "Inserts an RSS feed output",
// "IDs" => "IDs",
// "List of feed IDs separated by colons. ex: feedId:feedId2" => "List of feed IDs separated by colons. ex: feedId:feedId2",
// "Amount of results displayed" => "Amount of results displayed",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect" => "RSS Id incorrect",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "SourceForge" => "SourceForge",
// "aid?" => "aid?",
// "adit?" => "adit?",
// "groupid?" => "groupid?",
// "Automatically creates a link to the appropriate SourceForge object" => "Automatically creates a link to the appropriate SourceForge object",
// "Insert a ShareThis button from www.sharethis.com" => "Insert a ShareThis button from www.sharethis.com",
// "sharethis" => "sharethis",
// "Display a social networking tool" => "Display a social networking tool",
// "Send services" => "Send services",
// "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services" => "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services",
// "First post services shown" => "First post services shown",
// "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget" => "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget",
// "Rotate image" => "Rotate image",
// "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping" => "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping",
// "Button text" => "Button text",
// "Custom link text for the button" => "Custom link text for the button",
// "Header title" => "Header title",
// "Optional header title text for the widget" => "Optional header title text for the widget",
// "Header background" => "Header background",
// "HTML color code (not color name) for the background color for the header if an optional header title is used" => "HTML color code (not color name) for the background color for the header if an optional header title is used",
// "Header text color" => "Header text color",
// "HTML color code (not color name) for the header text if an optional header title is used" => "HTML color code (not color name) for the header text if an optional header title is used",
// "Link text color for services" => "Link text color for services",
// "HTML color code (not color name) for the link text for all send and post services shown in the widget" => "HTML color code (not color name) for the link text for all send and post services shown in the widget",
// "Pop-up" => "Pop-up",
// "A value of true will cause the widget to show in a pop-up window" => "A value of true will cause the widget to show in a pop-up window",
// "Embedded elements" => "Embedded elements",
// "A value of true will allow embedded elements (like flash) to be seen while iframe is loading" => "A value of true will allow embedded elements (like flash) to be seen while iframe is loading",
// "Sheet" => "Sheet",
// "Displays the content of a spreadsheet in the page" => "Displays the content of a spreadsheet in the page",
// "Sheet Heading" => "Sheet Heading",
// "Internal ID of the TikiSheet" => "Internal ID of the TikiSheet",
// "New sheet in page: " => "New sheet in page: ",
// "Incomplete call to plugin: No target sheet" => "Incomplete call to plugin: No target sheet",
// "Create new sheet" => "Create new sheet",
// "TikiSheet" => "TikiSheet",
// "Edit Sheet" => "Edit Sheet",
// "Show Pages" => "Show Pages",
// "Search criteria" => "Search criteria",
// "Maximum amount of results displayed" => "Maximum amount of results displayed",
// "name|desc" => "name|desc",
// "Skype" => "Skype",
// "Name or number to call or chat with" => "Name or number to call or chat with",
// "Snarf" => "Snarf",
// "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified" => "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified",
// "Full URL to the page to include" => "Full URL to the page to include",
// "PCRE compliant regular expression" => "PCRE compliant regular expression",
// "Regular Expression Part" => "Regular Expression Part",
// "ex: \$1" => "ex: \$1",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace" => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace",
// "This data is put in a CODE caption" => "This data is put in a CODE caption",
// "Missing url parameter for SNARF plugin" => "Missing url parameter for SNARF plugin",
// "Sorts the plugin content in the wiki page" => "Sorts the plugin content in the wiki page",
// "Data to sort, one entry per line" => "Data to sort, one entry per line",
// "asc|desc|shuffle" => "asc|desc|shuffle",
// "Split a page into rows and columns" => "Split a page into rows and columns",
// "Join Columns" => "Join Columns",
// "Generate the colspan attribute if columns are missing" => "Generate the colspan attribute if columns are missing",
// "Fixed Size" => "Fixed Size",
// "Generate the width attribute on the columns" => "Generate the width attribute on the columns",
// "Column Size" => "Column Size",
// "Editable" => "Editable",
// "Display edit icon for each section" => "Display edit icon for each section",
// "Custom class" => "Custom class",
// "add a class to customize the design" => "add a class to customize the design",
// "row1col1" => "row1col1",
// "row1col2" => "row1col2",
// "row2col1" => "row2col1",
// "row2col2" => "row2col2",
// "SQL" => "SQL",
// "Run a sql query" => "Run a sql query",
// "sql query" => "sql query",
// "DNS Name" => "DNS Name",
// "ADODB DNS" => "ADODB DNS",
// "Missing db param" => "Missing db param",
// "Subscript" => "Subscript",
// "Displays text in subscript" => "Displays text in subscript",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Subscribe Group" => "Subscribe Group",
// "Group Name" => "Group Name",
// "As known in Tikiwiki" => "As known in Tikiwiki",
// "Subscribe Text" => "Subscribe Text",
// "Subscribe text, containing %s as the placeholder for the group name" => "Subscribe text, containing %s as the placeholder for the group name",
// "Unsubscribe Text" => "Unsubscribe Text",
// "Unsubscribe text, containing %s as the placeholder for the group name" => "Unsubscribe text, containing %s as the placeholder for the group name",
// "Subscribe Action" => "Subscribe Action",
// "Subscribe button label, containing %s as the placeholder for the group name" => "Subscribe button label, containing %s as the placeholder for the group name",
// "Unsubscribe Action" => "Unsubscribe Action",
// "Unsubscribe button label, containing %s as the placeholder for the group name" => "Unsubscribe button label, containing %s as the placeholder for the group name",
// "Subscribe Groups" => "Subscribe Groups",
// "Colon separated list of groups" => "Colon separated list of groups",
// "Superscript" => "Superscript",
// "Displays text in superscript (exponent)" => "Displays text in superscript (exponent)",
// "Displays text in superscript" => "Displays text in superscript",
// "Wiki Page to redirect the user after his vote" => "Wiki Page to redirect the user after his vote",
// "Displays a survey" => "Displays a survey",
// "Tag" => "Tag",
// "Displays the text between an html tag" => "Displays the text between an html tag",
// "Tag Name" => "Tag Name",
// "Any valid HTML tag, span by default" => "Any valid HTML tag, span by default",
// "Equivalent of the style attribute on the HTML tag" => "Equivalent of the style attribute on the HTML tag",
// "Displays text between an html tag" => "Displays text between an html tag",
// "Displays the thumbnail for an image" => "Displays the thumbnail for an image",
// "File ID from the file gallery" => "File ID from the file gallery",
// "Image ID from the image gallery" => "Image ID from the image gallery",
// "URL to the image" => "URL to the image",
// "Maximum Size" => "Maximum Size",
// "Maximum width or height for the image" => "Maximum width or height for the image",
// "Floating" => "Floating",
// "Link target of the image" => "Link target of the image",
// "File not found" => "File not found",
// "File is not an image" => "File is not an image",
// "Server does not support image manipulation" => "Server does not support image manipulation",
// "No image specified" => "No image specified",
// "Title Search" => "Title Search",
// "Search wiki page titles" => "Search wiki page titles",
// "Search Criteria" => "Search Criteria",
// "Portion of a page name" => "Portion of a page name",
// "hits|user" => "hits|user",
// "Exclude" => "Exclude",
// "Pipe separated list of page names to exclude from results" => "Pipe separated list of page names to exclude from results",
// "Search the titles of all pages in this wiki" => "Search the titles of all pages in this wiki",
// "No pages found for title search" => "No pages found for title search",
// "One page found for title search" => "One page found for title search",
// "pages found for title search" => "pages found for title search",
// "Table of Contents (Structure)" => "Table of Contents (Structure)",
// "Displays the table of contents for the current structure\\'s subtree as part of the page content" => "Displays the table of contents for the current structure\\'s subtree as part of the page content",
// "Maximum Depth" => "Maximum Depth",
// "Maximum amount of levels to display. On very large structures, this should be limited" => "Maximum amount of levels to display. On very large structures, this should be limited",
// "By default, structure for the current page will be displayed. Alternate structure may be provided" => "By default, structure for the current page will be displayed. Alternate structure may be provided",
// "asc|desc" => "asc|desc",
// "Show Description" => "Show Description",
// "0|1, show the page description instead of the page name" => "0|1, show the page description instead of the page name",
// "Show Numbering" => "Show Numbering",
// "0|1, display the section numbers or not" => "0|1, display the section numbers or not",
// "plain|fancy" => "plain|fancy",
// "Top Friends" => "Top Friends",
// "List top scoring users" => "List top scoring users",
// "Maximum result count" => "Maximum result count",
// "Public" => "Public",
// "Translate a string using Tikiwiki translation table" => "Translate a string using Tikiwiki translation table",
// "string" => "string",
// "Translate a string" => "Translate a string",
// "Confirmation message after posting form" => "Confirmation message after posting form",
// "Fields" => "Fields",
// "Colon-separated list of field IDs to be displayed. Example: 2:4:5" => "Colon-separated list of field IDs to be displayed. Example: 2:4:5",
// "Label on the submit button" => "Label on the submit button",
// "Show Title" => "Show Title",
// "Show Mandatory" => "Show Mandatory",
// "Embedded" => "Embedded",
// "Url used for the field links" => "Url used for the field links",
// "Values" => "Values",
// "Colon-separated list of values" => "Colon-separated list of values",
// "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or " => "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or ",
// "preview" => "preview",
// "user|page" => "user|page",
// "itemId" => "itemId",
// "itemId if you want to edit an item" => "itemId if you want to edit an item",
// "Template File" => "Template File",
// "Name of the template used to display the tracker items" => "Name of the template used to display the tracker items",
// "Name of the wiki page containing the template to display the tracker items" => "Name of the wiki page containing the template to display the tracker items",
// "New Status" => "New Status",
// "Default status applied to newly created items" => "Default status applied to newly created items",
// "Width of first column " => "Width of first column ",
// "Specify the width in pixels or percentage of the first column in the tracker form" => "Specify the width in pixels or percentage of the first column in the tracker form",
// "Incorrect fieldId" => "Incorrect fieldId",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Following fields are incorrect" => "Following fields are incorrect",
// "Displays an input form for tracker submit" => "Displays an input form for tracker submit",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Fields marked with a * are mandatory" => "Fields marked with a * are mandatory",
// "Filters" => "Filters",
// "Display List" => "Display List",
// "Line" => "Line",
// "Tracker Filter" => "Tracker Filter",
// "notice" => "notice",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Filters the items of a tracker, fields are indicated with numeric ids" => "Filters the items of a tracker, fields are indicated with numeric ids",
// "Tracker Item Field" => "Tracker Item Field",
// "Wiki text containing an {ELSE} marker" => "Wiki text containing an {ELSE} marker",
// "Item ID" => "Item ID",
// "Field ID" => "Field ID",
// "Colon separated list of field IDs" => "Colon separated list of field IDs",
// "o|p|c|op|oc|pc|opc" => "o|p|c|op|oc|pc|opc",
// "Value to compare against" => "Value to compare against",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)" => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)",
// "Tracker List" => "Tracker List",
// "Displays the output of a tracker content, fields are indicated with numeric ids" => "Displays the output of a tracker content, fields are indicated with numeric ids",
// "Notice" => "Notice",
// "Popup" => "Popup",
// "Colon-separated list of fields to display on click. Example: 6:7" => "Colon-separated list of fields to display on click. Example: 6:7",
// "Sticky Popup" => "Sticky Popup",
// "Show Links" => "Show Links",
// "shownbitems" => "shownbitems",
// "Show Initials" => "Show Initials",
// "Show Status" => "Show Status",
// "Show Creation Date" => "Show Creation Date",
// "Show Last Modification" => "Show Last Modification",
// "Show Field Name" => "Show Field Name",
// "Status Filter" => "Status Filter",
// "Which item status to list. o = open, p = pending, c = closed" => "Which item status to list. o = open, p = pending, c = closed",
// "Sort Mode" => "Sort Mode",
// "Filter Field" => "Filter Field",
// "Colon separated list of fields to allow filtering on" => "Colon separated list of fields to allow filtering on",
// "Filter Value" => "Filter Value",
// "Exact Value" => "Exact Value",
// "Checkbox" => "Checkbox",
// "goIfOne" => "goIfOne",
// "More URL" => "More URL",
// "Select automatically the item of the current user or the page" => "Select automatically the item of the current user or the page",
// "View User" => "View User",
// "Item ID separated with " => "Item ID separated with ",
// "List of items Ids" => "List of items Ids",
// "link url" => "link url",
// "Left Deliminator" => "Left Deliminator",
// "Right Deliminator" => "Right Deliminator",
// "Mode" => "Mode",
// "If y, value will be truncated" => "If y, value will be truncated",
// "Export Button" => "Export Button",
// "Compute" => "Compute",
// "Sum or average all the values of a field  and displays it at the bottom of the table" => "Sum or average all the values of a field  and displays it at the bottom of the table",
// "fieldId" => "fieldId",
// "incorrect filterfield" => "incorrect filterfield",
// "Error in tracker ID" => "Error in tracker ID",
// "No field indicated" => "No field indicated",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields" => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields",
// "Tracker Prefill" => "Tracker Prefill",
// "Tracker page name" => "Tracker page name",
// "Button label" => "Button label",
// "Field 1" => "Field 1",
// "Value 1" => "Value 1",
// "Content of the field" => "Content of the field",
// "Field 2" => "Field 2",
// "Value 2" => "Value 2",
// "Field 3" => "Field 3",
// "Value 3" => "Value 3",
// "Field 4" => "Field 4",
// "Value 4" => "Value 4",
// "Field 5" => "Field 5",
// "Value 5" => "Value 5",
// "Tracker Stats" => "Tracker Stats",
// "Show Percentage" => "Show Percentage",
// "Show Bar" => "Show Bar",
// "Show link to tiki-view_tracker" => "Show link to tiki-view_tracker",
// "Displays some stat of a tracker content, fields are indicated with numeric ids" => "Displays some stat of a tracker content, fields are indicated with numeric ids",
// "incorrect fieldId" => "incorrect fieldId",
// "Tracker Timeline" => "Tracker Timeline",
// "Timeline view of a tracker, can be used to display event schedules or gantt charts" => "Timeline view of a tracker, can be used to display event schedules or gantt charts",
// "Title Field" => "Title Field",
// "Tracker Field ID containing the item title" => "Tracker Field ID containing the item title",
// "Summary Field" => "Summary Field",
// "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused" => "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused",
// "Start Date" => "Start Date",
// "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field",
// "End Date" => "End Date",
// "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field",
// "Element Group" => "Element Group",
// "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row" => "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row",
// "Lower Bound" => "Lower Bound",
// "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Upper Bound" => "Upper Bound",
// "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Primary Scale Unit" => "Primary Scale Unit",
// "hour, day, week, month or year (default to hour)" => "hour, day, week, month or year (default to hour)",
// "Secondary Scale Unit" => "Secondary Scale Unit",
// "hour, day, week, month, year or empty (default to empty)" => "hour, day, week, month, year or empty (default to empty)",
// "Link Group Name" => "Link Group Name",
// "Convert the group name to a link. (y|n)" => "Convert the group name to a link. (y|n)",
// "Page Link Field" => "Page Link Field",
// "Tracker Field ID containing the page name for item details" => "Tracker Field ID containing the page name for item details",
// "Missing parameter: %0" => "Missing parameter: %0",
// "Start date after end date" => "Start date after end date",
// "Translated" => "Translated",
// "Links to a translated content" => "Links to a translated content",
// "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)" => "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)",
// "Two letter language code of the language, ex: fr" => "Two letter language code of the language, ex: fr",
// "Country name, ex: France" => "Country name, ex: France",
// "User Count" => "User Count",
// "Displays the number of registered users" => "Displays the number of registered users",
// "Group name" => "Group name",
// "Login Filter" => "Login Filter",
// "String to use between elements of the list" => "String to use between elements of the list",
// "Maximum" => "Maximum",
// "Result limit" => "Result limit",
// "Layout" => "Layout",
// "Split the text in parts visible only under some conditions" => "Split the text in parts visible only under some conditions",
// "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default" => "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default",
// "Navigation" => "Navigation",
// "Displays a navigation box that allows users to select a specific version to display" => "Displays a navigation box that allows users to select a specific version to display",
// "Display the current version name as the title. Note: Do not work when nav=>y" => "Display the current version name as the title. Note: Do not work when nav=>y",
// "Default" => "Default",
// "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'" => "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Show Stats" => "Show Stats",
// "Show Stats After" => "Show Stats After",
// "Show Creator" => "Show Creator",
// "Wanted Pages" => "Wanted Pages",
// "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)" => "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)",
// "Ignore" => "Ignore",
// "Split By" => "Split By",
// "Skip Extension" => "Skip Extension",
// "Collect" => "Collect",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored" => "A wildcard pattern of originating pages to be ignored",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated" => "The character, by which ignored patterns are separated",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list" => "Whether to include external wikis in the list",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column" => "Collect either originating or wanted pages in a cell and display them in the second column",
// "Switch-on debug output with details about the items" => "Switch-on debug output with details about the items",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex",
// "A custom filter for wanted pages to be listed (only used when level=>custom)" => "A custom filter for wanted pages to be listed (only used when level=>custom)",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "Lists ''wanted'' wiki pages" => "Lists ''wanted'' wiki pages",
// "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)" => "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)",
// "The character, by which ignored patterns are separated. possible values: characters" => "The character, by which ignored patterns are separated. possible values: characters",
// "Whether to include external wikis in the list. possible values" => "Whether to include external wikis in the list. possible values",
// "Collect either originating or wanted pages in a cell and display them in the second column. possible values" => "Collect either originating or wanted pages in a cell and display them in the second column. possible values",
// "Switch-on debug output with details about the items. possible values" => "Switch-on debug output with details about the items. possible values",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output" => "End of debug output",
// "Referenced By Page" => "Referenced By Page",
// "Web Service" => "Web Service",
// "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface" => "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface",
// "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter" => "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter",
// "Complete service URL" => "Complete service URL",
// "Service Name" => "Service Name",
// "Registered service name" => "Registered service name",
// "Template Name" => "Template Name",
// "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided" => "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided",
// "Body as Parameter" => "Body as Parameter",
// "Name of the argument to send the body as for services with complex input. Named service required for this to be useful" => "Name of the argument to send the body as for services with complex input. Named service required for this to be useful",
// "Unknown Template" => "Unknown Template",
// "Unknown Service" => "Unknown Service",
// "Missing parameters" => "Missing parameters",
// "Youtube" => "Youtube",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "URL to the Youtube video" => "URL to the Youtube video",
// "quality" => "quality",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Removed version \$version" => "Removed version \$version",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Plugin " => "Plugin ",
// "Semantic token already exists" => "Semantic token already exists",
// "Invalid semantic token name" => "Invalid semantic token name",
// "Semantic token not found" => "Semantic token not found",
// "ERROR: Either the subject or body must be non-empty" => "ERROR: Either the subject or body must be non-empty",
// "ERROR: No valid users to send the message" => "ERROR: No valid users to send the message",
// "Sent box is full. Archive or delete some sent messages first if you want to send more messages" => "Sent box is full. Archive or delete some sent messages first if you want to send more messages",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "User %s can not receive messages, mailbox is full" => "User %s can not receive messages, mailbox is full",
// "User %s can not receive messages" => "User %s can not receive messages",
// "Invalid user: %s" => "Invalid user: %s",
// "Message will be sent to: " => "Message will be sent to: ",
// "Archive is full. Delete some messages from archive first" => "Archive is full. Delete some messages from archive first",
// "No more messages" => "No more messages",
// "Tiki Calendar" => "Tiki Calendar",
// "list topics with links to the articles" => "list topics with links to the articles",
// "Article Topics" => "Article Topics",
// "Please provide an Id" => "Please provide an Id",
// "no object here yet" => "no object here yet",
// "List by month" => "List by month",
// "Please wait.." => "Please wait..",
// "Since your last visit.." => "Since your last visit..",
// "updated tracker items" => "updated tracker items",
// "The task title must have at least 3 characters" => "The task title must have at least 3 characters",
// "Invalid server key" => "Invalid server key",
// "Cookie not found" => "Cookie not found",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can browse the calendar" => "Can browse the calendar",
// "Can view events details" => "Can view events details",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Can admin categories" => "Can admin categories",
// "Can edit items in categories" => "Can edit items in categories",
// "Can view categories" => "Can view categories",
// "Can view categorized items" => "Can view categorized items",
// "Can search on objects of this category" => "Can search on objects of this category",
// "Can admin charts" => "Can admin charts",
// "Autovalidate suggestions" => "Autovalidate suggestions",
// "Can suggest items" => "Can suggest items",
// "Can view charts" => "Can view charts",
// "Can vote" => "Can vote",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Can use the chat system" => "Can use the chat system",
// "Can admin the cms" => "Can admin the cms",
// "Can approve submissions" => "Can approve submissions",
// "Can admin article topics" => "Can admin article topics",
// "Can admin article types" => "Can admin article types",
// "Can read article headings" => "Can read article headings",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Can edit articles" => "Can edit articles",
// "Can edit submissions" => "Can edit submissions",
// "Can read articles" => "Can read articles",
// "Can remove articles" => "Can remove articles",
// "Can remove submissions" => "Can remove submissions",
// "Can submit articles" => "Can submit articles",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can admin contributions" => "Can admin contributions",
// "Can admin the directory" => "Can admin the directory",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Submited links are valid" => "Submited links are valid",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can validate submited links" => "Can validate submited links",
// "Can use the directory" => "Can use the directory",
// "Can admin drawings" => "Can admin drawings",
// "Can edit drawings" => "Can edit drawings",
// "Can admin faqs" => "Can admin faqs",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can view faqs" => "Can view faqs",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Can admin users" => "Can admin users",
// "Can access site when closed" => "Can access site when closed",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Can ban users or ips" => "Can ban users or ips",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can edit object permissions" => "Can edit object permissions",
// "Can admin rss modules" => "Can admin rss modules",
// "Can clean cache" => "Can clean cache",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can admin cookies" => "Can admin cookies",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit site templates" => "Can edit site templates",
// "Can search" => "Can search",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view referer stats" => "Can view referer stats",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can admin blogs" => "Can admin blogs",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can post to a blog" => "Can post to a blog",
// "Can create a blog" => "Can create a blog",
// "Can read blogs" => "Can read blogs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can create file galleries" => "Can create file galleries",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can list file galleries" => "Can list file galleries",
// "Can upload files" => "Can upload files",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view file galleries" => "Can view file galleries",
// "Can admin forums" => "Can admin forums",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can post in forums" => "Can post in forums",
// "Can start threads in forums" => "Can start threads in forums",
// "Can read forums" => "Can read forums",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can create image galleries" => "Can create image galleries",
// "Can tag objects" => "Can tag objects",
// "Can list image galleries" => "Can list image galleries",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload images" => "Can upload images",
// "Can browse freetags" => "Can browse freetags",
// "Can view image galleries" => "Can view image galleries",
// "Can admin games" => "Can admin games",
// "Can play games" => "Can play games",
// "Can admin newsletters" => "Can admin newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can send newsletters" => "Can send newsletters",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can admin polls" => "Can admin polls",
// "Can view poll results" => "Can view poll results",
// "Can vote polls" => "Can vote polls",
// "Can view poll voters" => "Can view poll voters",
// "Can admin quicktags" => "Can admin quicktags",
// "Can admin quizzes" => "Can admin quizzes",
// "Can take quizzes" => "Can take quizzes",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view user quiz results" => "Can view user quiz results",
// "Can admin sheet" => "Can admin sheet",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can view shoutbox" => "Can view shoutbox",
// "Can admin surveys" => "Can admin surveys",
// "Can take surveys" => "Can take surveys",
// "Can view survey stats" => "Can view survey stats",
// "Can admin trackers" => "Can admin trackers",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can view tracker items comments" => "Can view tracker items comments",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can list trackers" => "Can list trackers",
// "Can change tracker items" => "Can change tracker items",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can watch tracker" => "Can watch tracker",
// "Can export tracker items" => "Can export tracker items",
// "Can admin the wiki" => "Can admin the wiki",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can edit pages" => "Can edit pages",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can create and edit structures" => "Can create and edit structures",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can lock pages" => "Can lock pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can remove" => "Can remove",
// "Can rename pages" => "Can rename pages",
// "Can rollback pages" => "Can rollback pages",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can view page/pages" => "Can view page/pages",
// "Can watch structure" => "Can watch structure",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can view similar wiki pages" => "Can view similar wiki pages",
// "Can admin workflow processes" => "Can admin workflow processes",
// "Can abort a process instance" => "Can abort a process instance",
// "Can declare an instance as exception" => "Can declare an instance as exception",
// "Can send instances after completion" => "Can send instances after completion",
// "Can execute workflow activities" => "Can execute workflow activities",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can configure modules" => "Can configure modules",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the newsreader" => "Can use the newsreader",
// "Can use the notepad" => "Can use the notepad",
// "Can admin public tasks" => "Can admin public tasks",
// "Can use tasks" => "Can use tasks",
// "Can receive tasks from other users" => "Can receive tasks from other users",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can upload personal files" => "Can upload personal files",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can use the messaging system" => "Can use the messaging system",
// "Can admin comments" => "Can admin comments",
// "Can edit all comments" => "Can edit all comments",
// "Can post new comments" => "Can post new comments",
// "Can read comments" => "Can read comments",
// "Can delete comments" => "Can delete comments",
// "Can vote comments" => "Can vote comments",
// "Can admin content templates" => "Can admin content templates",
// "Can edit content templates" => "Can edit content templates",
// "Can use content templates" => "Can use content templates",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can view HTML pages" => "Can view HTML pages",
// "Can list registered users" => "Can list registered users",
// "Admin live support system" => "Admin live support system",
// "Can use live support system" => "Can use live support system",
// "Can create new mapfile" => "Can create new mapfile",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can use webmail" => "Can use webmail",
// "Can use group webmail" => "Can use group webmail",
// "Can administrate group webmail accounts" => "Can administrate group webmail accounts",
// "Can use personal webmail accounts" => "Can use personal webmail accounts",
// "Can administrate personal webmail accounts" => "Can administrate personal webmail accounts",
// "Can view unapproved plugin details" => "Can view unapproved plugin details",
// "Can execute unapproved plugin" => "Can execute unapproved plugin",
// "Can approve plugin execution" => "Can approve plugin execution",
// "Trust all user inputs (no security checks)" => "Trust all user inputs (no security checks)",
// "View page backlinks" => "View page backlinks",
// "Can admin mail notifications" => "Can admin mail notifications",
// "tiki release" => "tiki release",
// "feature version checks" => "feature version checks",
// "tiki needs upgrade" => "tiki needs upgrade",
// "tiki version last check" => "tiki version last check",
// "tiki version check frequency" => "tiki version check frequency",
// "lastUpdatePrefs" => "lastUpdatePrefs",
// "feature print indexed" => "feature print indexed",
// "feature wiki" => "feature wiki",
// "default wiki diff style" => "default wiki diff style",
// "feature backlinks" => "feature backlinks",
// "feature dump" => "feature dump",
// "feature history" => "feature history",
// "feature lastChanges" => "feature lastChanges",
// "feature likePages" => "feature likePages",
// "feature listPages" => "feature listPages",
// "feature listorphanPages" => "feature listorphanPages",
// "feature page title" => "feature page title",
// "feature sandbox" => "feature sandbox",
// "feature warn on edit" => "feature warn on edit",
// "feature wiki 1like redirection" => "feature wiki 1like redirection",
// "feature wiki allowhtml" => "feature wiki allowhtml",
// "feature wiki argvariable" => "feature wiki argvariable",
// "feature wiki attachments" => "feature wiki attachments",
// "feature wiki comments" => "feature wiki comments",
// "feature wiki description" => "feature wiki description",
// "feature wiki discuss" => "feature wiki discuss",
// "feature wiki export" => "feature wiki export",
// "feature wiki structure" => "feature wiki structure",
// "feature wiki import page" => "feature wiki import page",
// "feature wiki footnotes" => "feature wiki footnotes",
// "feature wiki icache" => "feature wiki icache",
// "feature wiki import html" => "feature wiki import html",
// "feature wiki mindmap" => "feature wiki mindmap",
// "feature wiki monosp" => "feature wiki monosp",
// "feature wiki multiprint" => "feature wiki multiprint",
// "feature wiki notepad" => "feature wiki notepad",
// "feature wiki make structure" => "feature wiki make structure",
// "feature wiki open as structure" => "feature wiki open as structure",
// "feature wiki pageid" => "feature wiki pageid",
// "feature wiki paragraph formatting" => "feature wiki paragraph formatting",
// "feature wiki paragraph formatting add br" => "feature wiki paragraph formatting add br",
// "feature wiki pictures" => "feature wiki pictures",
// "feature wiki plurals" => "feature wiki plurals",
// "feature wiki print" => "feature wiki print",
// "feature wiki protect email" => "feature wiki protect email",
// "feature wiki rankings" => "feature wiki rankings",
// "feature wiki ratings" => "feature wiki ratings",
// "feature wiki replace" => "feature wiki replace",
// "feature wiki show hide before" => "feature wiki show hide before",
// "feature wiki tables" => "feature wiki tables",
// "feature wiki templates" => "feature wiki templates",
// "feature wiki undo" => "feature wiki undo",
// "feature wiki userpage" => "feature wiki userpage",
// "feature wiki userpage prefix" => "feature wiki userpage prefix",
// "feature wiki usrlock" => "feature wiki usrlock",
// "feature wiki feedback polls" => "feature wiki feedback polls",
// "feature wiki save draft" => "feature wiki save draft",
// "feature wikiwords" => "feature wikiwords",
// "feature wikiwords usedash" => "feature wikiwords usedash",
// "feature wiki pagealias" => "feature wiki pagealias",
// "mailin autocheck" => "mailin autocheck",
// "mailin autocheckFreq" => "mailin autocheckFreq",
// "mailin autocheckLast" => "mailin autocheckLast",
// "page bar position" => "page bar position",
// "warn on edit time" => "warn on edit time",
// "wikiHomePage" => "wikiHomePage",
// "wikiLicensePage" => "wikiLicensePage",
// "wikiSubmitNotice" => "wikiSubmitNotice",
// "wiki authors style" => "wiki authors style",
// "wiki authors style by page" => "wiki authors style by page",
// "wiki show version" => "wiki show version",
// "wiki bot bar" => "wiki bot bar",
// "wiki cache" => "wiki cache",
// "wiki comments default ordering" => "wiki comments default ordering",
// "wiki comments displayed default" => "wiki comments displayed default",
// "wiki comments per page" => "wiki comments per page",
// "wiki creator admin" => "wiki creator admin",
// "wiki feature copyrights" => "wiki feature copyrights",
// "wiki forum id" => "wiki forum id",
// "wiki left column" => "wiki left column",
// "wiki list backlinks" => "wiki list backlinks",
// "wiki list comment" => "wiki list comment",
// "wiki list comment len" => "wiki list comment len",
// "wiki list description" => "wiki list description",
// "wiki list description len" => "wiki list description len",
// "wiki list creator" => "wiki list creator",
// "wiki list hits" => "wiki list hits",
// "wiki list lastmodif" => "wiki list lastmodif",
// "wiki list lastver" => "wiki list lastver",
// "wiki list links" => "wiki list links",
// "wiki list name" => "wiki list name",
// "wiki list name len" => "wiki list name len",
// "wiki list size" => "wiki list size",
// "wiki list status" => "wiki list status",
// "wiki list user" => "wiki list user",
// "wiki list versions" => "wiki list versions",
// "wiki list language" => "wiki list language",
// "wiki list categories" => "wiki list categories",
// "wiki list categories path" => "wiki list categories path",
// "wiki list id" => "wiki list id",
// "wiki list sortorder" => "wiki list sortorder",
// "wiki list sortdirection" => "wiki list sortdirection",
// "wiki pagealias tokens" => "wiki pagealias tokens",
// "wiki page regex" => "wiki page regex",
// "wiki page separator" => "wiki page separator",
// "wiki page navigation bar" => "wiki page navigation bar",
// "wiki actions bar" => "wiki actions bar",
// "wiki pagename strip" => "wiki pagename strip",
// "wiki right column" => "wiki right column",
// "wiki top bar" => "wiki top bar",
// "wiki topline position" => "wiki topline position",
// "wiki uses slides" => "wiki uses slides",
// "wiki watch author" => "wiki watch author",
// "wiki watch comments" => "wiki watch comments",
// "wiki watch editor" => "wiki watch editor",
// "wiki watch minor" => "wiki watch minor",
// "feature wiki history full" => "feature wiki history full",
// "feature wiki categorize structure" => "feature wiki categorize structure",
// "feature wiki watch structure" => "feature wiki watch structure",
// "feature wikiapproval" => "feature wikiapproval",
// "wikiapproval prefix" => "wikiapproval prefix",
// "wikiapproval hideprefix" => "wikiapproval hideprefix",
// "wikiapproval delete staging" => "wikiapproval delete staging",
// "wikiapproval master group" => "wikiapproval master group",
// "wikiapproval staging category" => "wikiapproval staging category",
// "wikiapproval approved category" => "wikiapproval approved category",
// "wikiapproval outofsync category" => "wikiapproval outofsync category",
// "wikiapproval block editapproved" => "wikiapproval block editapproved",
// "wikiapproval sync categories" => "wikiapproval sync categories",
// "wikiapproval update freetags" => "wikiapproval update freetags",
// "wikiapproval combine freetags" => "wikiapproval combine freetags",
// "wiki edit section" => "wiki edit section",
// "wiki edit section level" => "wiki edit section level",
// "wiki edit plugin" => "wiki edit plugin",
// "wiki validate plugin" => "wiki validate plugin",
// "wiki edit minor" => "wiki edit minor",
// "wikiplugin agentinfo" => "wikiplugin agentinfo",
// "wikiplugin alink" => "wikiplugin alink",
// "wikiplugin aname" => "wikiplugin aname",
// "wikiplugin annotation" => "wikiplugin annotation",
// "wikiplugin article" => "wikiplugin article",
// "wikiplugin articles" => "wikiplugin articles",
// "wikiplugin attach" => "wikiplugin attach",
// "wikiplugin avatar" => "wikiplugin avatar",
// "wikiplugin back" => "wikiplugin back",
// "wikiplugin backlinks" => "wikiplugin backlinks",
// "wikiplugin banner" => "wikiplugin banner",
// "wikiplugin bloglist" => "wikiplugin bloglist",
// "wikiplugin box" => "wikiplugin box",
// "wikiplugin category" => "wikiplugin category",
// "wikiplugin catorphans" => "wikiplugin catorphans",
// "wikiplugin catpath" => "wikiplugin catpath",
// "wikiplugin center" => "wikiplugin center",
// "wikiplugin chart" => "wikiplugin chart",
// "wikiplugin code" => "wikiplugin code",
// "wikiplugin content" => "wikiplugin content",
// "wikiplugin cookie" => "wikiplugin cookie",
// "wikiplugin copyright" => "wikiplugin copyright",
// "wikiplugin countdown" => "wikiplugin countdown",
// "wikiplugin dbreport" => "wikiplugin dbreport",
// "wikiplugin div" => "wikiplugin div",
// "wikiplugin dl" => "wikiplugin dl",
// "wikiplugin draw" => "wikiplugin draw",
// "wikiplugin equation" => "wikiplugin equation",
// "wikiplugin events" => "wikiplugin events",
// "wikiplugin fade" => "wikiplugin fade",
// "wikiplugin fancylist" => "wikiplugin fancylist",
// "wikiplugin fancytable" => "wikiplugin fancytable",
// "wikiplugin file" => "wikiplugin file",
// "wikiplugin files" => "wikiplugin files",
// "wikiplugin flash" => "wikiplugin flash",
// "wikiplugin footnote" => "wikiplugin footnote",
// "wikiplugin footnotearea" => "wikiplugin footnotearea",
// "wikiplugin ftp" => "wikiplugin ftp",
// "wikiplugin gauge" => "wikiplugin gauge",
// "wikiplugin googleanalytics" => "wikiplugin googleanalytics",
// "wikiplugin googledoc" => "wikiplugin googledoc",
// "wikiplugin group" => "wikiplugin group",
// "wikiplugin html" => "wikiplugin html",
// "wikiplugin iframe" => "wikiplugin iframe",
// "wikiplugin img" => "wikiplugin img",
// "wikiplugin image" => "wikiplugin image",
// "wikiplugin include" => "wikiplugin include",
// "wikiplugin jabber" => "wikiplugin jabber",
// "wikiplugin js" => "wikiplugin js",
// "wikiplugin jq" => "wikiplugin jq",
// "wikiplugin lang" => "wikiplugin lang",
// "wikiplugin lastmod" => "wikiplugin lastmod",
// "wikiplugin listpages" => "wikiplugin listpages",
// "wikiplugin lsdir" => "wikiplugin lsdir",
// "wikiplugin map" => "wikiplugin map",
// "wikiplugin mediaplayer" => "wikiplugin mediaplayer",
// "wikiplugin miniquiz" => "wikiplugin miniquiz",
// "wikiplugin module" => "wikiplugin module",
// "wikiplugin mono" => "wikiplugin mono",
// "wikiplugin mouseover" => "wikiplugin mouseover",
// "wikiplugin mwtable" => "wikiplugin mwtable",
// "wikiplugin myspace" => "wikiplugin myspace",
// "wikiplugin objecthits" => "wikiplugin objecthits",
// "wikiplugin picture" => "wikiplugin picture",
// "wikiplugin pluginmanager" => "wikiplugin pluginmanager",
// "wikiplugin poll" => "wikiplugin poll",
// "wikiplugin profile" => "wikiplugin profile",
// "wikiplugin proposal" => "wikiplugin proposal",
// "wikiplugin quote" => "wikiplugin quote",
// "wikiplugin rcontent" => "wikiplugin rcontent",
// "wikiplugin redirect" => "wikiplugin redirect",
// "wikiplugin regex" => "wikiplugin regex",
// "wikiplugin remarksbox" => "wikiplugin remarksbox",
// "wikiplugin rss" => "wikiplugin rss",
// "wikiplugin sf" => "wikiplugin sf",
// "wikiplugin share" => "wikiplugin share",
// "wikiplugin sharethis" => "wikiplugin sharethis",
// "wikiplugin sheet" => "wikiplugin sheet",
// "wikiplugin showpages" => "wikiplugin showpages",
// "wikiplugin skype" => "wikiplugin skype",
// "wikiplugin snarf" => "wikiplugin snarf",
// "wikiplugin sort" => "wikiplugin sort",
// "wikiplugin split" => "wikiplugin split",
// "wikiplugin sql" => "wikiplugin sql",
// "wikiplugin sub" => "wikiplugin sub",
// "wikiplugin subscribegroup" => "wikiplugin subscribegroup",
// "wikiplugin subscribegroups" => "wikiplugin subscribegroups",
// "wikiplugin sup" => "wikiplugin sup",
// "wikiplugin survey" => "wikiplugin survey",
// "wikiplugin tag" => "wikiplugin tag",
// "wikiplugin thumb" => "wikiplugin thumb",
// "wikiplugin titlesearch" => "wikiplugin titlesearch",
// "wikiplugin toc" => "wikiplugin toc",
// "wikiplugin topfriends" => "wikiplugin topfriends",
// "wikiplugin trackerfilter" => "wikiplugin trackerfilter",
// "wikiplugin trackeritemfield" => "wikiplugin trackeritemfield",
// "wikiplugin trackerlist" => "wikiplugin trackerlist",
// "wikiplugin trackertimeline" => "wikiplugin trackertimeline",
// "wikiplugin tracker" => "wikiplugin tracker",
// "wikiplugin trackerprefill" => "wikiplugin trackerprefill",
// "wikiplugin trackerstat" => "wikiplugin trackerstat",
// "wikiplugin translated" => "wikiplugin translated",
// "wikiplugin tr" => "wikiplugin tr",
// "wikiplugin usercount" => "wikiplugin usercount",
// "wikiplugin userlist" => "wikiplugin userlist",
// "wikiplugin versions" => "wikiplugin versions",
// "wikiplugin vote" => "wikiplugin vote",
// "wikiplugin wantedpages" => "wikiplugin wantedpages",
// "wikiplugin webservice" => "wikiplugin webservice",
// "wikiplugin youtube" => "wikiplugin youtube",
// "wikiplugininline agentinfo" => "wikiplugininline agentinfo",
// "wikiplugininline alink" => "wikiplugininline alink",
// "wikiplugininline aname" => "wikiplugininline aname",
// "wikiplugininline annotation" => "wikiplugininline annotation",
// "wikiplugininline article" => "wikiplugininline article",
// "wikiplugininline articles" => "wikiplugininline articles",
// "wikiplugininline attach" => "wikiplugininline attach",
// "wikiplugininline avatar" => "wikiplugininline avatar",
// "wikiplugininline back" => "wikiplugininline back",
// "wikiplugininline backlinks" => "wikiplugininline backlinks",
// "wikiplugininline banner" => "wikiplugininline banner",
// "wikiplugininline bloglist" => "wikiplugininline bloglist",
// "wikiplugininline box" => "wikiplugininline box",
// "wikiplugininline category" => "wikiplugininline category",
// "wikiplugininline catorphans" => "wikiplugininline catorphans",
// "wikiplugininline catpath" => "wikiplugininline catpath",
// "wikiplugininline center" => "wikiplugininline center",
// "wikiplugininline chart" => "wikiplugininline chart",
// "wikiplugininline code" => "wikiplugininline code",
// "wikiplugininline content" => "wikiplugininline content",
// "wikiplugininline cookie" => "wikiplugininline cookie",
// "wikiplugininline copyright" => "wikiplugininline copyright",
// "wikiplugininline countdown" => "wikiplugininline countdown",
// "wikiplugininline dbreport" => "wikiplugininline dbreport",
// "wikiplugininline div" => "wikiplugininline div",
// "wikiplugininline dl" => "wikiplugininline dl",
// "wikiplugininline draw" => "wikiplugininline draw",
// "wikiplugininline equation" => "wikiplugininline equation",
// "wikiplugininline events" => "wikiplugininline events",
// "wikiplugininline fade" => "wikiplugininline fade",
// "wikiplugininline fancylist" => "wikiplugininline fancylist",
// "wikiplugininline fancytable" => "wikiplugininline fancytable",
// "wikiplugininline file" => "wikiplugininline file",
// "wikiplugininline files" => "wikiplugininline files",
// "wikiplugininline flash" => "wikiplugininline flash",
// "wikiplugininline footnote" => "wikiplugininline footnote",
// "wikiplugininline footnotearea" => "wikiplugininline footnotearea",
// "wikiplugininline ftp" => "wikiplugininline ftp",
// "wikiplugininline gauge" => "wikiplugininline gauge",
// "wikiplugininline googleanalytics" => "wikiplugininline googleanalytics",
// "wikiplugininline googledoc" => "wikiplugininline googledoc",
// "wikiplugininline group" => "wikiplugininline group",
// "wikiplugininline html" => "wikiplugininline html",
// "wikiplugininline iframe" => "wikiplugininline iframe",
// "wikiplugininline img" => "wikiplugininline img",
// "wikiplugininline image" => "wikiplugininline image",
// "wikiplugininline include" => "wikiplugininline include",
// "wikiplugininline jabber" => "wikiplugininline jabber",
// "wikiplugininline js" => "wikiplugininline js",
// "wikiplugininline jq" => "wikiplugininline jq",
// "wikiplugininline lang" => "wikiplugininline lang",
// "wikiplugininline lastmod" => "wikiplugininline lastmod",
// "wikiplugininline listpages" => "wikiplugininline listpages",
// "wikiplugininline lsdir" => "wikiplugininline lsdir",
// "wikiplugininline map" => "wikiplugininline map",
// "wikiplugininline mediaplayer" => "wikiplugininline mediaplayer",
// "wikiplugininline miniquiz" => "wikiplugininline miniquiz",
// "wikiplugininline module" => "wikiplugininline module",
// "wikiplugininline mono" => "wikiplugininline mono",
// "wikiplugininline mouseover" => "wikiplugininline mouseover",
// "wikiplugininline mwtable" => "wikiplugininline mwtable",
// "wikiplugininline myspace" => "wikiplugininline myspace",
// "wikiplugininline objecthits" => "wikiplugininline objecthits",
// "wikiplugininline picture" => "wikiplugininline picture",
// "wikiplugininline pluginmanager" => "wikiplugininline pluginmanager",
// "wikiplugininline poll" => "wikiplugininline poll",
// "wikiplugininline profile" => "wikiplugininline profile",
// "wikiplugininline proposal" => "wikiplugininline proposal",
// "wikiplugininline quote" => "wikiplugininline quote",
// "wikiplugininline rcontent" => "wikiplugininline rcontent",
// "wikiplugininline redirect" => "wikiplugininline redirect",
// "wikiplugininline regex" => "wikiplugininline regex",
// "wikiplugininline remarksbox" => "wikiplugininline remarksbox",
// "wikiplugininline rss" => "wikiplugininline rss",
// "wikiplugininline sf" => "wikiplugininline sf",
// "wikiplugininline share" => "wikiplugininline share",
// "wikiplugininline sharethis" => "wikiplugininline sharethis",
// "wikiplugininline sheet" => "wikiplugininline sheet",
// "wikiplugininline showpages" => "wikiplugininline showpages",
// "wikiplugininline skype" => "wikiplugininline skype",
// "wikiplugininline snarf" => "wikiplugininline snarf",
// "wikiplugininline sort" => "wikiplugininline sort",
// "wikiplugininline split" => "wikiplugininline split",
// "wikiplugininline sql" => "wikiplugininline sql",
// "wikiplugininline sub" => "wikiplugininline sub",
// "wikiplugininline subscribegroup" => "wikiplugininline subscribegroup",
// "wikiplugininline subscribegroups" => "wikiplugininline subscribegroups",
// "wikiplugininline sup" => "wikiplugininline sup",
// "wikiplugininline survey" => "wikiplugininline survey",
// "wikiplugininline tag" => "wikiplugininline tag",
// "wikiplugininline thumb" => "wikiplugininline thumb",
// "wikiplugininline titlesearch" => "wikiplugininline titlesearch",
// "wikiplugininline toc" => "wikiplugininline toc",
// "wikiplugininline topfriends" => "wikiplugininline topfriends",
// "wikiplugininline trackerfilter" => "wikiplugininline trackerfilter",
// "wikiplugininline trackeritemfield" => "wikiplugininline trackeritemfield",
// "wikiplugininline trackerlist" => "wikiplugininline trackerlist",
// "wikiplugininline trackertimeline" => "wikiplugininline trackertimeline",
// "wikiplugininline tracker" => "wikiplugininline tracker",
// "wikiplugininline trackerprefill" => "wikiplugininline trackerprefill",
// "wikiplugininline trackerstat" => "wikiplugininline trackerstat",
// "wikiplugininline translated" => "wikiplugininline translated",
// "wikiplugininline tr" => "wikiplugininline tr",
// "wikiplugininline usercount" => "wikiplugininline usercount",
// "wikiplugininline userlist" => "wikiplugininline userlist",
// "wikiplugininline versions" => "wikiplugininline versions",
// "wikiplugininline vote" => "wikiplugininline vote",
// "wikiplugininline wantedpages" => "wikiplugininline wantedpages",
// "wikiplugininline webservice" => "wikiplugininline webservice",
// "wikiplugininline youtube" => "wikiplugininline youtube",
// "webservice consume defaultcache" => "webservice consume defaultcache",
// "feature wysiwyg" => "feature wysiwyg",
// "wysiwyg optional" => "wysiwyg optional",
// "wysiwyg default" => "wysiwyg default",
// "wysiwyg memo" => "wysiwyg memo",
// "wysiwyg wiki parsed" => "wysiwyg wiki parsed",
// "wysiwyg wiki semi parsed" => "wysiwyg wiki semi parsed",
// "wysiwyg toolbar skin" => "wysiwyg toolbar skin",
// "wysiwyg toolbar" => "wysiwyg toolbar",
// "wiki feature 3d" => "wiki feature 3d",
// "wiki 3d width" => "wiki 3d width",
// "wiki 3d height" => "wiki 3d height",
// "wiki 3d navigation depth" => "wiki 3d navigation depth",
// "wiki 3d feed animation interval" => "wiki 3d feed animation interval",
// "wiki 3d existing page color" => "wiki 3d existing page color",
// "wiki 3d missing page color" => "wiki 3d missing page color",
// "feature blogs" => "feature blogs",
// "blog list order" => "blog list order",
// "home blog" => "home blog",
// "feature blog rankings" => "feature blog rankings",
// "feature blog comments" => "feature blog comments",
// "blog comments default ordering" => "blog comments default ordering",
// "blog comments per page" => "blog comments per page",
// "feature blogposts comments" => "feature blogposts comments",
// "blog list user" => "blog list user",
// "blog list title" => "blog list title",
// "blog list title len" => "blog list title len",
// "blog list description" => "blog list description",
// "blog list created" => "blog list created",
// "blog list lastmodif" => "blog list lastmodif",
// "blog list posts" => "blog list posts",
// "blog list visits" => "blog list visits",
// "blog list activity" => "blog list activity",
// "feature blog mandatory category" => "feature blog mandatory category",
// "feature blog heading" => "feature blog heading",
// "feature file galleries" => "feature file galleries",
// "home file gallery" => "home file gallery",
// "fgal use db" => "fgal use db",
// "fgal batch dir" => "fgal batch dir",
// "fgal match regex" => "fgal match regex",
// "fgal nmatch regex" => "fgal nmatch regex",
// "fgal use dir" => "fgal use dir",
// "fgal podcast dir" => "fgal podcast dir",
// "feature file galleries comments" => "feature file galleries comments",
// "file galleries comments default ordering" => "file galleries comments default ordering",
// "file galleries comments per page" => "file galleries comments per page",
// "feature file galleries batch" => "feature file galleries batch",
// "feature file galleries rankings" => "feature file galleries rankings",
// "fgal enable auto indexing" => "fgal enable auto indexing",
// "fgal asynchronous indexing" => "fgal asynchronous indexing",
// "fgal allow duplicates" => "fgal allow duplicates",
// "fgal sort mode" => "fgal sort mode",
// "feature file galleries author" => "feature file galleries author",
// "fgal list id" => "fgal list id",
// "fgal list type" => "fgal list type",
// "fgal list name" => "fgal list name",
// "fgal list description" => "fgal list description",
// "fgal list size" => "fgal list size",
// "fgal list created" => "fgal list created",
// "fgal list lastmodif" => "fgal list lastmodif",
// "fgal list creator" => "fgal list creator",
// "fgal list author" => "fgal list author",
// "fgal list last user" => "fgal list last user",
// "fgal list comment" => "fgal list comment",
// "fgal list files" => "fgal list files",
// "fgal list hits" => "fgal list hits",
// "fgal list lockedby" => "fgal list lockedby",
// "fgal show path" => "fgal show path",
// "fgal show explorer" => "fgal show explorer",
// "fgal show slideshow" => "fgal show slideshow",
// "fgal default view" => "fgal default view",
// "fgal limit hits per file" => "fgal limit hits per file",
// "fgal prevent negative score" => "fgal prevent negative score",
// "feature galleries" => "feature galleries",
// "feature gal batch" => "feature gal batch",
// "feature gal slideshow" => "feature gal slideshow",
// "home gallery" => "home gallery",
// "gal use db" => "gal use db",
// "gal use lib" => "gal use lib",
// "gal match regex" => "gal match regex",
// "gal nmatch regex" => "gal nmatch regex",
// "gal use dir" => "gal use dir",
// "gal batch dir" => "gal batch dir",
// "feature gal rankings" => "feature gal rankings",
// "feature image galleries comments" => "feature image galleries comments",
// "image galleries comments default order" => "image galleries comments default order",
// "image galleries comments per page" => "image galleries comments per page",
// "gal list name" => "gal list name",
// "gal list parent" => "gal list parent",
// "gal list description" => "gal list description",
// "gal list created" => "gal list created",
// "gal list lastmodif" => "gal list lastmodif",
// "gal list user" => "gal list user",
// "gal list imgs" => "gal list imgs",
// "gal list visits" => "gal list visits",
// "feature image gallery mandatory category" => "feature image gallery mandatory category",
// "preset galleries info" => "preset galleries info",
// "gal image mouseover" => "gal image mouseover",
// "ProgressBarPlay" => "ProgressBarPlay",
// "ProgressBarLoad" => "ProgressBarLoad",
// "ProgressBarButton" => "ProgressBarButton",
// "ProgressBar" => "ProgressBar",
// "VolumeOn" => "VolumeOn",
// "VolumeOff" => "VolumeOff",
// "VolumeButton" => "VolumeButton",
// "Button" => "Button",
// "ButtonPressed" => "ButtonPressed",
// "ButtonOver" => "ButtonOver",
// "ButtonInfo" => "ButtonInfo",
// "ButtonInfoPressed" => "ButtonInfoPressed",
// "ButtonInfoOver" => "ButtonInfoOver",
// "ButtonInfoText" => "ButtonInfoText",
// "ID3" => "ID3",
// "PlayTime" => "PlayTime",
// "TotalTime" => "TotalTime",
// "PanelDisplay" => "PanelDisplay",
// "AlertMesg" => "AlertMesg",
// "PreloadDelay" => "PreloadDelay",
// "VideoHeight" => "VideoHeight",
// "VideoLength" => "VideoLength",
// "URLAppend" => "URLAppend",
// "LimitedMsg" => "LimitedMsg",
// "MaxPlay" => "MaxPlay",
// "MultimediaGalerie" => "MultimediaGalerie",
// "MultimediaDefaultLength" => "MultimediaDefaultLength",
// "MultimediaDefaultHeight" => "MultimediaDefaultHeight",
// "feature forums" => "feature forums",
// "home forum" => "home forum",
// "feature forum rankings" => "feature forum rankings",
// "feature forum parse" => "feature forum parse",
// "feature forum topics archiving" => "feature forum topics archiving",
// "feature forum replyempty" => "feature forum replyempty",
// "feature forum quickjump" => "feature forum quickjump",
// "feature forums allow thread titles" => "feature forums allow thread titles",
// "feature forum content search" => "feature forum content search",
// "feature forums name search" => "feature forums name search",
// "forums ordering" => "forums ordering",
// "forum list topics" => "forum list topics",
// "forum list posts" => "forum list posts",
// "forum list ppd" => "forum list ppd",
// "forum list lastpost" => "forum list lastpost",
// "forum list visits" => "forum list visits",
// "forum list desc" => "forum list desc",
// "forum list description len" => "forum list description len",
// "feature forum local search" => "feature forum local search",
// "feature forum local tiki search" => "feature forum local tiki search",
// "forum thread defaults by forum" => "forum thread defaults by forum",
// "forum thread user settings" => "forum thread user settings",
// "forum thread user settings keep" => "forum thread user settings keep",
// "forum comments per page" => "forum comments per page",
// "forum comments no title prefix" => "forum comments no title prefix",
// "forum thread style" => "forum thread style",
// "forum thread sort mode" => "forum thread sort mode",
// "forum match regex" => "forum match regex",
// "feature articles" => "feature articles",
// "feature submissions" => "feature submissions",
// "feature cms rankings" => "feature cms rankings",
// "feature cms print" => "feature cms print",
// "feature cms emails" => "feature cms emails",
// "art list title" => "art list title",
// "art list title len" => "art list title len",
// "art list topic" => "art list topic",
// "art list date" => "art list date",
// "art list author" => "art list author",
// "art list reads" => "art list reads",
// "art list size" => "art list size",
// "art list expire" => "art list expire",
// "art list img" => "art list img",
// "art list type" => "art list type",
// "art list visible" => "art list visible",
// "art view type" => "art view type",
// "art view title" => "art view title",
// "art view topic" => "art view topic",
// "art view date" => "art view date",
// "art view author" => "art view author",
// "art view reads" => "art view reads",
// "art view size" => "art view size",
// "art view img" => "art view img",
// "art list lang" => "art list lang",
// "feature article comments" => "feature article comments",
// "article comments default ordering" => "article comments default ordering",
// "article comments per page" => "article comments per page",
// "article image size x" => "article image size x",
// "article image size y" => "article image size y",
// "feature cms templates" => "feature cms templates",
// "cms bot bar" => "cms bot bar",
// "cms left column" => "cms left column",
// "cms right column" => "cms right column",
// "cms top bar" => "cms top bar",
// "cms spellcheck" => "cms spellcheck",
// "art home title" => "art home title",
// "feature trackers" => "feature trackers",
// "t use db" => "t use db",
// "t use dir" => "t use dir",
// "groupTracker" => "groupTracker",
// "userTracker" => "userTracker",
// "trk with mirror tables" => "trk with mirror tables",
// "feature userlevels" => "feature userlevels",
// "userlevels" => "userlevels",
// "userbreadCrumb" => "userbreadCrumb",
// "user assigned modules" => "user assigned modules",
// "user flip modules" => "user flip modules",
// "user show realnames" => "user show realnames",
// "feature mytiki" => "feature mytiki",
// "feature userPreferences" => "feature userPreferences",
// "feature user bookmarks" => "feature user bookmarks",
// "feature tasks" => "feature tasks",
// "w use db" => "w use db",
// "w use dir" => "w use dir",
// "w displayed default" => "w displayed default",
// "uf use db" => "uf use db",
// "uf use dir" => "uf use dir",
// "userfiles quota" => "userfiles quota",
// "feature usermenu" => "feature usermenu",
// "feature minical" => "feature minical",
// "feature notepad" => "feature notepad",
// "feature userfiles" => "feature userfiles",
// "feature community gender" => "feature community gender",
// "feature community mouseover" => "feature community mouseover",
// "feature community mouseover name" => "feature community mouseover name",
// "feature community mouseover gender" => "feature community mouseover gender",
// "feature community mouseover picture" => "feature community mouseover picture",
// "feature community mouseover friends" => "feature community mouseover friends",
// "feature community mouseover score" => "feature community mouseover score",
// "feature community mouseover country" => "feature community mouseover country",
// "feature community mouseover email" => "feature community mouseover email",
// "feature community mouseover lastlogin" => "feature community mouseover lastlogin",
// "feature community mouseover distance" => "feature community mouseover distance",
// "feature community list name" => "feature community list name",
// "feature community list score" => "feature community list score",
// "feature community list country" => "feature community list country",
// "feature community list distance" => "feature community list distance",
// "feature community friends permission" => "feature community friends permission",
// "feature community friends permission dep" => "feature community friends permission dep",
// "change language" => "change language",
// "change theme" => "change theme",
// "login is email" => "login is email",
// "validateUsers" => "validateUsers",
// "validateEmail" => "validateEmail",
// "forgotPass" => "forgotPass",
// "change password" => "change password",
// "available languages" => "available languages",
// "available styles" => "available styles",
// "lowercase username" => "lowercase username",
// "username pattern" => "username pattern",
// "max username length" => "max username length",
// "min username length" => "min username length",
// "users prefs allowMsgs" => "users prefs allowMsgs",
// "users prefs country" => "users prefs country",
// "users prefs diff versions" => "users prefs diff versions",
// "users prefs display timezone" => "users prefs display timezone",
// "users prefs email is public" => "users prefs email is public",
// "users prefs homePage" => "users prefs homePage",
// "users prefs lat" => "users prefs lat",
// "users prefs lon" => "users prefs lon",
// "users prefs mess archiveAfter" => "users prefs mess archiveAfter",
// "users prefs mess maxRecords" => "users prefs mess maxRecords",
// "users prefs mess sendReadStatus" => "users prefs mess sendReadStatus",
// "users prefs minPrio" => "users prefs minPrio",
// "users prefs mytiki blogs" => "users prefs mytiki blogs",
// "users prefs mytiki articles" => "users prefs mytiki articles",
// "users prefs mytiki gals" => "users prefs mytiki gals",
// "users prefs mytiki items" => "users prefs mytiki items",
// "users prefs mytiki msgs" => "users prefs mytiki msgs",
// "users prefs mytiki pages" => "users prefs mytiki pages",
// "users prefs mytiki tasks" => "users prefs mytiki tasks",
// "users prefs mytiki workflow" => "users prefs mytiki workflow",
// "users prefs mytiki forum topics" => "users prefs mytiki forum topics",
// "users prefs mytiki forum replies" => "users prefs mytiki forum replies",
// "users prefs realName" => "users prefs realName",
// "users prefs gender" => "users prefs gender",
// "users prefs show mouseover user info" => "users prefs show mouseover user info",
// "users prefs tasks maxRecords" => "users prefs tasks maxRecords",
// "users prefs user dbl" => "users prefs user dbl",
// "users prefs user information" => "users prefs user information",
// "users prefs userbreadCrumb" => "users prefs userbreadCrumb",
// "users prefs mailCharset" => "users prefs mailCharset",
// "validateRegistration" => "validateRegistration",
// "feature messages" => "feature messages",
// "messu mailbox size" => "messu mailbox size",
// "messu archive size" => "messu archive size",
// "messu sent size" => "messu sent size",
// "allowmsg by default" => "allowmsg by default",
// "allowmsg is optional" => "allowmsg is optional",
// "feature newsreader" => "feature newsreader",
// "feature freetags" => "feature freetags",
// "freetags browse show cloud" => "freetags browse show cloud",
// "freetags cloud colors" => "freetags cloud colors",
// "freetags preload random search" => "freetags preload random search",
// "freetags browse amount tags in cloud" => "freetags browse amount tags in cloud",
// "freetags browse amount tags suggestion" => "freetags browse amount tags suggestion",
// "freetags normalized valid chars" => "freetags normalized valid chars",
// "freetags lowercase only" => "freetags lowercase only",
// "freetags feature 3d" => "freetags feature 3d",
// "freetags 3d width" => "freetags 3d width",
// "freetags 3d height" => "freetags 3d height",
// "freetags 3d navigation depth" => "freetags 3d navigation depth",
// "freetags 3d feed animation interval" => "freetags 3d feed animation interval",
// "freetags 3d existing page color" => "freetags 3d existing page color",
// "freetags 3d missing page color" => "freetags 3d missing page color",
// "freetags 3d autoload" => "freetags 3d autoload",
// "freetags 3d camera distance" => "freetags 3d camera distance",
// "freetags 3d elastic constant" => "freetags 3d elastic constant",
// "freetags 3d eletrostatic constant" => "freetags 3d eletrostatic constant",
// "freetags 3d fov" => "freetags 3d fov",
// "freetags 3d friction constant" => "freetags 3d friction constant",
// "freetags 3d node charge" => "freetags 3d node charge",
// "freetags 3d node mass" => "freetags 3d node mass",
// "freetags 3d node size" => "freetags 3d node size",
// "freetags 3d spring size" => "freetags 3d spring size",
// "freetags 3d text size" => "freetags 3d text size",
// "freetags 3d adjust camera" => "freetags 3d adjust camera",
// "freetags multilingual" => "freetags multilingual",
// "morelikethis algorithm" => "morelikethis algorithm",
// "morelikethis basic mincommon" => "morelikethis basic mincommon",
// "freetags show middle" => "freetags show middle",
// "feature search stats" => "feature search stats",
// "feature search" => "feature search",
// "feature search fulltext" => "feature search fulltext",
// "feature search show forbidden obj" => "feature search show forbidden obj",
// "feature search show forbidden cat" => "feature search show forbidden cat",
// "feature search show object filter" => "feature search show object filter",
// "feature search show search box" => "feature search show search box",
// "feature search show visit count" => "feature search show visit count",
// "feature search show pertinence" => "feature search show pertinence",
// "feature search show object type" => "feature search show object type",
// "feature search show last modification" => "feature search show last modification",
// "search refresh index mode" => "search refresh index mode",
// "search parsed snippet" => "search parsed snippet",
// "feature webmail" => "feature webmail",
// "webmail max attachment" => "webmail max attachment",
// "webmail view html" => "webmail view html",
// "feature contacts" => "feature contacts",
// "feature faqs" => "feature faqs",
// "feature faq comments" => "feature faq comments",
// "faq comments per page" => "faq comments per page",
// "faq comments default ordering" => "faq comments default ordering",
// "faq prefix" => "faq prefix",
// "feature quizzes" => "feature quizzes",
// "feature polls" => "feature polls",
// "feature poll comments" => "feature poll comments",
// "feature poll anonymous" => "feature poll anonymous",
// "poll comments default ordering" => "poll comments default ordering",
// "poll comments per page" => "poll comments per page",
// "poll list categories" => "poll list categories",
// "poll list objects" => "poll list objects",
// "feature poll revote" => "feature poll revote",
// "feature surveys" => "feature surveys",
// "feature featuredLinks" => "feature featuredLinks",
// "feature directory" => "feature directory",
// "directory columns" => "directory columns",
// "directory links per page" => "directory links per page",
// "directory open links" => "directory open links",
// "directory validate urls" => "directory validate urls",
// "directory cool sites" => "directory cool sites",
// "directory country flag" => "directory country flag",
// "feature calendar" => "feature calendar",
// "feature default calendars" => "feature default calendars",
// "calendar sticky popup" => "calendar sticky popup",
// "default calendars" => "default calendars",
// "calendar view mode" => "calendar view mode",
// "calendar view tab" => "calendar view tab",
// "calendar firstDayofWeek" => "calendar firstDayofWeek",
// "calendar timespan" => "calendar timespan",
// "feature jscalendar" => "feature jscalendar",
// "feature action calendar" => "feature action calendar",
// "calendar start year" => "calendar start year",
// "calendar end year" => "calendar end year",
// "calendar list begins focus" => "calendar list begins focus",
// "server timezone" => "server timezone",
// "long date format" => "long date format",
// "long time format" => "long time format",
// "short date format" => "short date format",
// "short time format" => "short time format",
// "display field order" => "display field order",
// "feature charts" => "feature charts",
// "rss forums" => "rss forums",
// "rss forum" => "rss forum",
// "rss directories" => "rss directories",
// "rss articles" => "rss articles",
// "rss blogs" => "rss blogs",
// "rss image galleries" => "rss image galleries",
// "rss file galleries" => "rss file galleries",
// "rss wiki" => "rss wiki",
// "rss image gallery" => "rss image gallery",
// "rss file gallery" => "rss file gallery",
// "rss blog" => "rss blog",
// "rss tracker" => "rss tracker",
// "rss trackers" => "rss trackers",
// "rss calendar" => "rss calendar",
// "rss mapfiles" => "rss mapfiles",
// "rss cache time" => "rss cache time",
// "max rss forums" => "max rss forums",
// "max rss forum" => "max rss forum",
// "max rss directories" => "max rss directories",
// "max rss articles" => "max rss articles",
// "max rss blogs" => "max rss blogs",
// "max rss image galleries" => "max rss image galleries",
// "max rss file galleries" => "max rss file galleries",
// "max rss wiki" => "max rss wiki",
// "max rss image gallery" => "max rss image gallery",
// "max rss file gallery" => "max rss file gallery",
// "max rss blog" => "max rss blog",
// "max rss mapfiles" => "max rss mapfiles",
// "max rss tracker" => "max rss tracker",
// "max rss trackers" => "max rss trackers",
// "max rss calendar" => "max rss calendar",
// "summary rss blogs" => "summary rss blogs",
// "rssfeed default version" => "rssfeed default version",
// "rssfeed language" => "rssfeed language",
// "rssfeed editor" => "rssfeed editor",
// "rssfeed webmaster" => "rssfeed webmaster",
// "rssfeed creator" => "rssfeed creator",
// "rssfeed css" => "rssfeed css",
// "rssfeed publisher" => "rssfeed publisher",
// "rssfeed img" => "rssfeed img",
// "rss basic auth" => "rss basic auth",
// "feature maps" => "feature maps",
// "map path" => "map path",
// "default map" => "default map",
// "map help" => "map help",
// "map comments" => "map comments",
// "gdaltindex" => "gdaltindex",
// "ogr2ogr" => "ogr2ogr",
// "mapzone" => "mapzone",
// "feature gmap" => "feature gmap",
// "gmap defaultx" => "gmap defaultx",
// "gmap defaulty" => "gmap defaulty",
// "gmap defaultz" => "gmap defaultz",
// "gmap key" => "gmap key",
// "allowRegister" => "allowRegister",
// "eponymousGroups" => "eponymousGroups",
// "useRegisterPasscode" => "useRegisterPasscode",
// "registerPasscode" => "registerPasscode",
// "rememberme" => "rememberme",
// "remembertime" => "remembertime",
// "feature clear passwords" => "feature clear passwords",
// "feature crypt passwords" => "feature crypt passwords",
// "feature challenge" => "feature challenge",
// "min user length" => "min user length",
// "min pass length" => "min pass length",
// "pass chr num" => "pass chr num",
// "pass due" => "pass due",
// "email due" => "email due",
// "unsuccessful logins" => "unsuccessful logins",
// "rnd num reg" => "rnd num reg",
// "generate password" => "generate password",
// "auth method" => "auth method",
// "auth pear" => "auth pear",
// "auth create user tiki" => "auth create user tiki",
// "auth create user auth" => "auth create user auth",
// "auth skip admin" => "auth skip admin",
// "auth ldap url" => "auth ldap url",
// "auth pear host" => "auth pear host",
// "auth pear port" => "auth pear port",
// "auth ldap scope" => "auth ldap scope",
// "auth ldap basedn" => "auth ldap basedn",
// "auth ldap userdn" => "auth ldap userdn",
// "auth ldap userattr" => "auth ldap userattr",
// "auth ldap useroc" => "auth ldap useroc",
// "auth ldap groupdn" => "auth ldap groupdn",
// "auth ldap groupattr" => "auth ldap groupattr",
// "auth ldap groupoc" => "auth ldap groupoc",
// "auth ldap memberattr" => "auth ldap memberattr",
// "auth ldap memberisdn" => "auth ldap memberisdn",
// "auth ldap adminuser" => "auth ldap adminuser",
// "auth ldap adminpass" => "auth ldap adminpass",
// "auth ldap version" => "auth ldap version",
// "auth ldap nameattr" => "auth ldap nameattr",
// "auth ldap countryattr" => "auth ldap countryattr",
// "auth ldap emailattr" => "auth ldap emailattr",
// "https login" => "https login",
// "feature show stay in ssl mode" => "feature show stay in ssl mode",
// "feature switch ssl mode" => "feature switch ssl mode",
// "https port" => "https port",
// "http port" => "http port",
// "login url" => "login url",
// "login scr" => "login scr",
// "register url" => "register url",
// "error url" => "error url",
// "highlight group" => "highlight group",
// "cookie path" => "cookie path",
// "cookie domain" => "cookie domain",
// "cookie name" => "cookie name",
// "user tracker infos" => "user tracker infos",
// "desactive login autocomplete" => "desactive login autocomplete",
// "permission denied login box" => "permission denied login box",
// "permission denied url" => "permission denied url",
// "feature intertiki" => "feature intertiki",
// "feature intertiki server" => "feature intertiki server",
// "feature intertiki slavemode" => "feature intertiki slavemode",
// "interlist" => "interlist",
// "feature intertiki mymaster" => "feature intertiki mymaster",
// "feature intertiki import preferences" => "feature intertiki import preferences",
// "feature intertiki import groups" => "feature intertiki import groups",
// "known hosts" => "known hosts",
// "tiki key" => "tiki key",
// "intertiki logfile" => "intertiki logfile",
// "intertiki errfile" => "intertiki errfile",
// "feature intertiki sharedcookie" => "feature intertiki sharedcookie",
// "search lru length" => "search lru length",
// "search lru purge rate" => "search lru purge rate",
// "search max syllwords" => "search max syllwords",
// "search min wordlength" => "search min wordlength",
// "search refresh rate" => "search refresh rate",
// "search syll age" => "search syll age",
// "feature categories" => "feature categories",
// "feature categoryobjects" => "feature categoryobjects",
// "feature categorypath" => "feature categorypath",
// "feature category reinforce" => "feature category reinforce",
// "feature category use phplayers" => "feature category use phplayers",
// "categorypath excluded" => "categorypath excluded",
// "categories used in tpl" => "categories used in tpl",
// "feature games" => "feature games",
// "feature html pages" => "feature html pages",
// "feature filegals manager" => "feature filegals manager",
// "feature contact" => "feature contact",
// "contact user" => "contact user",
// "contact anon" => "contact anon",
// "mail crlf" => "mail crlf",
// "feature detect language" => "feature detect language",
// "feature homePage if bl missing" => "feature homePage if bl missing",
// "record untranslated" => "record untranslated",
// "feature best language" => "feature best language",
// "feature translation" => "feature translation",
// "feature urgent translation" => "feature urgent translation",
// "lang use db" => "lang use db",
// "language" => "language",
// "feature babelfish" => "feature babelfish",
// "feature babelfish logo" => "feature babelfish logo",
// "quantify changes" => "quantify changes",
// "feature sync language" => "feature sync language",
// "show available translations" => "show available translations",
// "metatag keywords" => "metatag keywords",
// "metatag threadtitle" => "metatag threadtitle",
// "metatag imagetitle" => "metatag imagetitle",
// "metatag freetags" => "metatag freetags",
// "metatag description" => "metatag description",
// "metatag author" => "metatag author",
// "metatag geoposition" => "metatag geoposition",
// "metatag georegion" => "metatag georegion",
// "metatag geoplacename" => "metatag geoplacename",
// "metatag robots" => "metatag robots",
// "metatag revisitafter" => "metatag revisitafter",
// "head extra js" => "head extra js",
// "keep versions" => "keep versions",
// "feature custom home" => "feature custom home",
// "site crumb seper" => "site crumb seper",
// "site nav seper" => "site nav seper",
// "feature sitemycode" => "feature sitemycode",
// "sitemycode" => "sitemycode",
// "sitemycode publish" => "sitemycode publish",
// "feature sitelogo" => "feature sitelogo",
// "sitelogo bgcolor" => "sitelogo bgcolor",
// "sitelogo bgstyle" => "sitelogo bgstyle",
// "sitelogo align" => "sitelogo align",
// "sitelogo title" => "sitelogo title",
// "sitelogo src" => "sitelogo src",
// "sitelogo alt" => "sitelogo alt",
// "feature siteloc" => "feature siteloc",
// "feature sitenav" => "feature sitenav",
// "sitenav" => "sitenav",
// "feature sitead" => "feature sitead",
// "sitead" => "sitead",
// "sitead publish" => "sitead publish",
// "feature breadcrumbs" => "feature breadcrumbs",
// "feature siteloclabel" => "feature siteloclabel",
// "feature sitesearch" => "feature sitesearch",
// "feature site login" => "feature site login",
// "feature sitemenu" => "feature sitemenu",
// "feature topbar version" => "feature topbar version",
// "feature topbar debug" => "feature topbar debug",
// "feature topbar id menu" => "feature topbar id menu",
// "feature topbar custom code" => "feature topbar custom code",
// "feature sitetitle" => "feature sitetitle",
// "feature sitedesc" => "feature sitedesc",
// "feature bot logo" => "feature bot logo",
// "feature endbody code" => "feature endbody code",
// "feature left column" => "feature left column",
// "feature right column" => "feature right column",
// "feature top bar" => "feature top bar",
// "feature bot bar" => "feature bot bar",
// "feature bot bar icons" => "feature bot bar icons",
// "feature bot bar debug" => "feature bot bar debug",
// "feature bot bar rss" => "feature bot bar rss",
// "feature bot bar power by tw" => "feature bot bar power by tw",
// "maxRecords" => "maxRecords",
// "maxArticles" => "maxArticles",
// "maxVersions" => "maxVersions",
// "feature view tpl" => "feature view tpl",
// "slide style" => "slide style",
// "site favicon" => "site favicon",
// "site favicon type" => "site favicon type",
// "style" => "style",
// "style option" => "style option",
// "site style" => "site style",
// "site style option" => "site style option",
// "use context menu icon" => "use context menu icon",
// "use context menu text" => "use context menu text",
// "feature site report" => "feature site report",
// "feature site send link" => "feature site send link",
// "feature layoutshadows" => "feature layoutshadows",
// "main shadow start" => "main shadow start",
// "main shadow end" => "main shadow end",
// "header shadow start" => "header shadow start",
// "header shadow end" => "header shadow end",
// "middle shadow start" => "middle shadow start",
// "middle shadow end" => "middle shadow end",
// "center shadow start" => "center shadow start",
// "center shadow end" => "center shadow end",
// "footer shadow start" => "footer shadow start",
// "footer shadow end" => "footer shadow end",
// "feature mods provider" => "feature mods provider",
// "mods dir" => "mods dir",
// "mods server" => "mods server",
// "feature experimental" => "feature experimental",
// "feature actionlog" => "feature actionlog",
// "feature actionlog bytes" => "feature actionlog bytes",
// "browsertitle" => "browsertitle",
// "tmpDir" => "tmpDir",
// "feature tell a friend" => "feature tell a friend",
// "feature copyright" => "feature copyright",
// "feature multimedia" => "feature multimedia",
// "feature swfobj" => "feature swfobj",
// "feature smileys" => "feature smileys",
// "popupLinks" => "popupLinks",
// "feature autolinks" => "feature autolinks",
// "quicktags over textarea" => "quicktags over textarea",
// "default rows textarea wiki" => "default rows textarea wiki",
// "default rows textarea comment" => "default rows textarea comment",
// "default rows textarea forum" => "default rows textarea forum",
// "default rows textarea forumthread" => "default rows textarea forumthread",
// "feature floating help" => "feature floating help",
// "direct pagination" => "direct pagination",
// "nextprev pagination" => "nextprev pagination",
// "pagination firstlast" => "pagination firstlast",
// "pagination hide if one page" => "pagination hide if one page",
// "pagination icons" => "pagination icons",
// "pagination fastmove links" => "pagination fastmove links",
// "direct pagination max middle links" => "direct pagination max middle links",
// "direct pagination max ending links" => "direct pagination max ending links",
// "anonCanEdit" => "anonCanEdit",
// "cacheimages" => "cacheimages",
// "cachepages" => "cachepages",
// "count admin pvs" => "count admin pvs",
// "default mail charset" => "default mail charset",
// "error reporting adminonly" => "error reporting adminonly",
// "error reporting level" => "error reporting level",
// "smarty notice reporting" => "smarty notice reporting",
// "smarty security" => "smarty security",
// "feature ajax" => "feature ajax",
// "feature ajax autosave" => "feature ajax autosave",
// "feature antibot" => "feature antibot",
// "feature banners" => "feature banners",
// "feature banning" => "feature banning",
// "feature comm" => "feature comm",
// "feature contribution" => "feature contribution",
// "feature contribution display in comment" => "feature contribution display in comment",
// "feature contribution mandatory" => "feature contribution mandatory",
// "feature contribution mandatory blog" => "feature contribution mandatory blog",
// "feature contribution mandatory comment" => "feature contribution mandatory comment",
// "feature contribution mandatory forum" => "feature contribution mandatory forum",
// "feature debug console" => "feature debug console",
// "feature debugger console" => "feature debugger console",
// "feature display my to others" => "feature display my to others",
// "feature drawings" => "feature drawings",
// "feature dynamic content" => "feature dynamic content",
// "feature edit templates" => "feature edit templates",
// "feature editcss" => "feature editcss",
// "feature events" => "feature events",
// "feature friends" => "feature friends",
// "feature fullscreen" => "feature fullscreen",
// "feature help" => "feature help",
// "feature hotwords" => "feature hotwords",
// "feature hotwords nw" => "feature hotwords nw",
// "feature integrator" => "feature integrator",
// "feature live support" => "feature live support",
// "feature mailin" => "feature mailin",
// "feature menusfolderstyle" => "feature menusfolderstyle",
// "feature mobile" => "feature mobile",
// "feature modulecontrols" => "feature modulecontrols",
// "feature morcego" => "feature morcego",
// "feature multilingual" => "feature multilingual",
// "feature multilingual one page" => "feature multilingual one page",
// "feature multilingual structures" => "feature multilingual structures",
// "feature newsletters" => "feature newsletters",
// "feature obzip" => "feature obzip",
// "feature phplayers" => "feature phplayers",
// "feature cssmenus" => "feature cssmenus",
// "feature projects" => "feature projects",
// "feature ranking" => "feature ranking",
// "feature redirect on error" => "feature redirect on error",
// "feature referer highlight" => "feature referer highlight",
// "feature referer stats" => "feature referer stats",
// "feature score" => "feature score",
// "feature sheet" => "feature sheet",
// "feature shoutbox" => "feature shoutbox",
// "feature source" => "feature source",
// "feature stats" => "feature stats",
// "feature tabs" => "feature tabs",
// "feature theme control" => "feature theme control",
// "feature ticketlib" => "feature ticketlib",
// "feature ticketlib2" => "feature ticketlib2",
// "feature top banner" => "feature top banner",
// "feature usability" => "feature usability",
// "feature use quoteplugin" => "feature use quoteplugin",
// "feature user watches" => "feature user watches",
// "feature group watches" => "feature group watches",
// "feature user watches translations" => "feature user watches translations",
// "feature workflow" => "feature workflow",
// "feature xmlrpc" => "feature xmlrpc",
// "helpurl" => "helpurl",
// "layout section" => "layout section",
// "limitedGoGroupHome" => "limitedGoGroupHome",
// "minical reminders" => "minical reminders",
// "modallgroups" => "modallgroups",
// "modseparateanon" => "modseparateanon",
// "php docroot" => "php docroot",
// "proxy host" => "proxy host",
// "proxy port" => "proxy port",
// "ip can be checked" => "ip can be checked",
// "sender email" => "sender email",
// "feature site report email" => "feature site report email",
// "session db" => "session db",
// "session lifetime" => "session lifetime",
// "shoutbox autolink" => "shoutbox autolink",
// "show comzone" => "show comzone",
// "system os" => "system os",
// "tikiIndex" => "tikiIndex",
// "urlIndex" => "urlIndex",
// "useGroupHome" => "useGroupHome",
// "useGroupTheme" => "useGroupTheme",
// "useUrlIndex" => "useUrlIndex",
// "use proxy" => "use proxy",
// "user list order" => "user list order",
// "webserverauth" => "webserverauth",
// "feature purifier" => "feature purifier",
// "feature shadowbox" => "feature shadowbox",
// "log sql" => "log sql",
// "log sql perf min" => "log sql perf min",
// "log mail" => "log mail",
// "log tpl" => "log tpl",
// "case patched" => "case patched",
// "site closed" => "site closed",
// "site closed msg" => "site closed msg",
// "use load threshold" => "use load threshold",
// "load threshold" => "load threshold",
// "site busy msg" => "site busy msg",
// "bot logo code" => "bot logo code",
// "feature blogposts pings" => "feature blogposts pings",
// "feature create webhelp" => "feature create webhelp",
// "feature forums search" => "feature forums search",
// "feature trackbackpings" => "feature trackbackpings",
// "feature wiki ext icon" => "feature wiki ext icon",
// "feature wiki mandatory category" => "feature wiki mandatory category",
// "feature intertiki imported groups" => "feature intertiki imported groups",
// "feature wiki history ip" => "feature wiki history ip",
// "pam create user tiki" => "pam create user tiki",
// "pam service" => "pam service",
// "pam skip admin" => "pam skip admin",
// "shib affiliation" => "shib affiliation",
// "shib create user tiki" => "shib create user tiki",
// "shib group" => "shib group",
// "shib skip admin" => "shib skip admin",
// "shib usegroup" => "shib usegroup",
// "wiki 3d camera distance" => "wiki 3d camera distance",
// "wiki 3d elastic constant" => "wiki 3d elastic constant",
// "wiki 3d eletrostatic constant" => "wiki 3d eletrostatic constant",
// "wiki 3d fov" => "wiki 3d fov",
// "wiki 3d friction constant" => "wiki 3d friction constant",
// "wiki 3d node charge" => "wiki 3d node charge",
// "wiki 3d node mass" => "wiki 3d node mass",
// "wiki 3d node size" => "wiki 3d node size",
// "wiki 3d spring size" => "wiki 3d spring size",
// "wiki 3d text size" => "wiki 3d text size",
// "articles feature copyrights" => "articles feature copyrights",
// "blogues feature copyrights" => "blogues feature copyrights",
// "faqs feature copyrights" => "faqs feature copyrights",
// "feature contributor wiki" => "feature contributor wiki",
// "https login required" => "https login required",
// "maxRowsGalleries" => "maxRowsGalleries",
// "replimaster" => "replimaster",
// "rowImagesGalleries" => "rowImagesGalleries",
// "scaleSizeGalleries" => "scaleSizeGalleries",
// "thumbSizeXGalleries" => "thumbSizeXGalleries",
// "thumbSizeYGalleries" => "thumbSizeYGalleries",
// "wiki 3d adjust camera" => "wiki 3d adjust camera",
// "wiki 3d autoload" => "wiki 3d autoload",
// "feature mootools" => "feature mootools",
// "javascript enabled" => "javascript enabled",
// "feature comments post as anonymous" => "feature comments post as anonymous",
// "feature comments moderation" => "feature comments moderation",
// "feature comments locking" => "feature comments locking",
// "feature template zoom" => "feature template zoom",
// "feature iepngfix" => "feature iepngfix",
// "iepngfix selectors" => "iepngfix selectors",
// "iepngfix elements" => "iepngfix elements",
// "use minified scripts" => "use minified scripts",
// "valid email regex" => "valid email regex",
// "feature jquery" => "feature jquery",
// "jquery effect" => "jquery effect",
// "jquery effect direction" => "jquery effect direction",
// "jquery effect speed" => "jquery effect speed",
// "jquery effect tabs" => "jquery effect tabs",
// "jquery effect tabs direction" => "jquery effect tabs direction",
// "jquery effect tabs speed" => "jquery effect tabs speed",
// "feature jquery ui" => "feature jquery ui",
// "feature jquery tooltips" => "feature jquery tooltips",
// "feature jquery autocomplete" => "feature jquery autocomplete",
// "feature jquery superfish" => "feature jquery superfish",
// "feature jquery reflection" => "feature jquery reflection",
// "feature jquery sheet" => "feature jquery sheet",
// "feature jquery tablesorter" => "feature jquery tablesorter",
// "feature jquery cycle" => "feature jquery cycle",
// "feature sefurl" => "feature sefurl",
// "feature sefurl filter" => "feature sefurl filter",
// "feature sefurl paths" => "feature sefurl paths",
// "feature sefurl title article" => "feature sefurl title article",
// "feature sefurl title blog" => "feature sefurl title blog",
// "feature tikitests" => "feature tikitests",
// "feature magic" => "feature magic",
// "profile sources" => "profile sources",
// "profile channels" => "profile channels",
// "feature minichat" => "feature minichat",
// "feature pear date" => "feature pear date",
// "feature bidi" => "feature bidi",
// "feature lastup" => "feature lastup",
// "transition style ver" => "transition style ver",
// "magic last load" => "magic last load",
// "feature groupalert" => "feature groupalert",
// "lib spellcheck" => "lib spellcheck",
// "wiki spellcheck" => "wiki spellcheck",
// "blog spellcheck" => "blog spellcheck",
// "allowMsgs" => "allowMsgs",
// "country" => "country",
// "diff versions" => "diff versions",
// "display timezone" => "display timezone",
// "email is public" => "email is public",
// "homePage" => "homePage",
// "lat" => "lat",
// "lon" => "lon",
// "mess archiveAfter" => "mess archiveAfter",
// "mess maxRecords" => "mess maxRecords",
// "mess sendReadStatus" => "mess sendReadStatus",
// "minPrio" => "minPrio",
// "mytiki blogs" => "mytiki blogs",
// "mytiki articles" => "mytiki articles",
// "mytiki gals" => "mytiki gals",
// "mytiki items" => "mytiki items",
// "mytiki msgs" => "mytiki msgs",
// "mytiki pages" => "mytiki pages",
// "mytiki tasks" => "mytiki tasks",
// "mytiki workflow" => "mytiki workflow",
// "mytiki forum topics" => "mytiki forum topics",
// "mytiki forum replies" => "mytiki forum replies",
// "realName" => "realName",
// "gender" => "gender",
// "show mouseover user info" => "show mouseover user info",
// "tasks maxRecords" => "tasks maxRecords",
// "user dbl" => "user dbl",
// "user information" => "user information",
// "mailCharset" => "mailCharset",
// "Group Monitor" => "Group Monitor",
// "Select Categories" => "Select Categories",
// "Select/deselect all categories" => "Select/deselect all categories",
// "Approve" => "Approve",
// "Reject" => "Reject",
// "Comments Locked" => "Comments Locked",
// "Comments are locked" => "Comments are locked",
// "Maximum size" => "Maximum size",
// "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address" => "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address",
// "Please note that the preview does not keep the attached file which you will have to choose before posting" => "Please note that the preview does not keep the attached file which you will have to choose before posting",
// "Your comment will have to be approved by the moderator before it is displayed" => "Your comment will have to be approved by the moderator before it is displayed",
// "Comments" => "Comments",
// "Page generation debugging log" => "Page generation debugging log",
// "Features state" => "Features state",
// "features matched" => "features matched",
// "There are individual permissions set for this file gallery" => "There are individual permissions set for this file gallery",
// "Users with perms and not only the owner of the gallery can upload in it" => "Users with perms and not only the owner of the gallery can upload in it",
// "Group of users alerted when file gallery is modified" => "Group of users alerted when file gallery is modified",
// "Allows to select each user for small groups" => "Allows to select each user for small groups",
// "Listing configuration" => "Listing configuration",
// "Please login" => "Please login",
// "Replace" => "Replace",
// "List" => "List",
// "not in" => "not in",
// "Clear Filter" => "Clear Filter",
// "You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page" => "You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page",
// "\\074span class=\"shortcut\"\\076C\\074/span\\076lose" => "\\074span class=\"shortcut\"\\076C\\074/span\\076lose",
// "\\074span class=\"shortcut\"\\076N\\074/span\\076ext" => "\\074span class=\"shortcut\"\\076N\\074/span\\076ext",
// "\\074span class=\"shortcut\"\\076P\\074/span\\076revious" => "\\074span class=\"shortcut\"\\076P\\074/span\\076revious",
// "Download the zip" => "Download the zip",
// "In order to confirm your subscription you must access the following URL" => "In order to confirm your subscription you must access the following URL",
// "To validate your account and login to the site, please click on the following link" => "To validate your account and login to the site, please click on the following link",
// "The administrator approved your account" => "The administrator approved your account",
// "Confirm your email at %s" => "Confirm your email at %s",
// "You sent a request with the subject" => "You sent a request with the subject",
// "Use the subject to indicate the operation to apply" => "Use the subject to indicate the operation to apply",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in instructions" => "Tiki mail-in instructions",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "has requested an account on" => "has requested an account on",
// "To validate that account, please follow the link" => "To validate that account, please follow the link",
// "User Tracker" => "User Tracker",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "Bye bye from %s at %s" => "Bye bye from %s at %s",
// "You can unsubscribe from this newsletter following this link" => "You can unsubscribe from this newsletter following this link",
// "This email address has been added to the list of subscriptors of" => "This email address has been added to the list of subscriptors of",
// "You can always cancel your subscription using" => "You can always cancel your subscription using",
// "Welcome to %s at %s" => "Welcome to %s at %s",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else" => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above" => "Important: The old password remains active if you don't click the link above",
// "Your account information for %s" => "Your account information for %s",
// "A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}",
// "You can edit the submission following this link" => "You can edit the submission following this link",
// "New article submitted at %s" => "New article submitted at %s",
// "Look at this link" => "Look at this link",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}" => "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}",
// "Download the file at" => "Download the file at",
// "Tracker was modified at" => "Tracker was modified at",
// "Last attempt" => "Last attempt",
// "IP" => "IP",
// "An administrator of the site below has added you as a new user" => "An administrator of the site below has added you as a new user",
// "If you want to confirm your membership in this site, click on the following link to login for the first time" => "If you want to confirm your membership in this site, click on the following link to login for the first time",
// "Your authentication credentials are" => "Your authentication credentials are",
// "Welcome on the site" => "Welcome on the site",
// "Your personal access to" => "Your personal access to",
// "You or someone registered this email address at" => "You or someone registered this email address at",
// "Your registration confirmation" => "Your registration confirmation",
// "Your account request has been stored and will be activated by the admin as soon as possible" => "Your account request has been stored and will be activated by the admin as soon as possible",
// "{\$mail_action} article post" => "{\$mail_action} article post",
// "{\$mail_title} by {\$mail_user} at" => "{\$mail_title} by {\$mail_user} at",
// "New article post" => "New article post",
// "Edited article post" => "Edited article post",
// "Deleted article post" => "Deleted article post",
// "{\$mail_action} article post at" => "{\$mail_action} article post at",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}",
// "View the blog at" => "View the blog at",
// "New blog post at %s" => "New blog post at %s",
// "View item calendar at" => "View item calendar at",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "changed" => "changed",
// "A new category was created in" => "A new category was created in",
// "created" => "created",
// "A category was removed in" => "A category was removed in",
// "Removed by" => "Removed by",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Updated by" => "Updated by",
// "updated" => "updated",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "File Name" => "File Name",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "Posted by" => "Posted by",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "You can view the updated map following this link" => "You can view the updated map following this link",
// "You can edit the map following this link" => "You can edit the map following this link",
// "An object was added to category" => "An object was added to category",
// "An object was removed from category" => "An object was removed from category",
// "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted but used to be here" => "The page {\$mail_page} was deleted but used to be here",
// "You can view a diff back to the previous version by following this link" => "You can view a diff back to the previous version by following this link",
// "The changes in this version follow below, followed after by the current full page text" => "The changes in this version follow below, followed after by the current full page text",
// "-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lines: {\$oldd} changed to +Lines: {\$newd}",
// "The old page content follows below" => "The old page content follows below",
// "The new page content follows below" => "The new page content follows below",
// "Wiki page %s created by {\$mail_user}" => "Wiki page %s created by {\$mail_user}",
// "Wiki page %s deleted by {\$mail_user}" => "Wiki page %s deleted by {\$mail_user}",
// "Wiki page %s changed by {\$mail_user}" => "Wiki page %s changed by {\$mail_user}",
// "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "click on the map to zoom or pan, do not drag" => "click on the map to zoom or pan, do not drag",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Scale" => "Scale",
// "Query" => "Query",
// "Pan" => "Pan",
// "Redraw" => "Redraw",
// "select zoom/pan/query and image size" => "select zoom/pan/query and image size",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Click on the map or click redraw" => "Click on the map or click redraw",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "you have requested to download the layer" => "you have requested to download the layer",
// "from the mapfile" => "from the mapfile",
// "Here are the files to download, do not forget to rename them" => "Here are the files to download, do not forget to rename them",
// "Mapfiles" => "Mapfiles",
// "Mapfile" => "Mapfile",
// "Available mapfiles" => "Available mapfiles",
// "monitor this map" => "monitor this map",
// "Stop Monitoring this Map" => "Stop Monitoring this Map",
// "Create a new mapfile" => "Create a new mapfile",
// "Mapfile listing" => "Mapfile listing",
// "You can view this map in your browser using" => "You can view this map in your browser using",
// "Mapfile History" => "Mapfile History",
// "Bytes maximum" => "Bytes maximum",
// "Create Directory" => "Create Directory",
// "index file (.shp)" => "index file (.shp)",
// "files to index (regexp)" => "files to index (regexp)",
// "Broadcast message" => "Broadcast message",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences" => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences",
// "'name' parameter for tikimodule missed" => "'name' parameter for tikimodule missed",
// "Unassign this module" => "Unassign this module",
// "Are you sure you want to unassign this module" => "Are you sure you want to unassign this module",
// "\$tpl_module_title" => "\$tpl_module_title",
// "Live Support" => "Live Support",
// "RSS Modules" => "RSS Modules",
// "Mail Notifications" => "Mail Notifications",
// "Banners" => "Banners",
// "Admin Drawings" => "Admin Drawings",
// "Content Templates" => "Content Templates",
// "HTML Pages" => "HTML Pages",
// "Referer Stats" => "Referer Stats",
// "Import PHPWiki Dump" => "Import PHPWiki Dump",
// "phpinfo" => "phpinfo",
// "Admin dsn" => "Admin dsn",
// "External Wikis" => "External Wikis",
// "Tiki Cache/Sys Admin" => "Tiki Cache/Sys Admin",
// "Security Admin" => "Security Admin",
// "Syntax Highlighting" => "Syntax Highlighting",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number " => "You forgot your Google ad_client number ",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "Admin Modules" => "Admin Modules",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "Admin Menus" => "Admin Menus",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "Last `\$module_rows` blog comments" => "Last `\$module_rows` blog comments",
// "Last blog comments" => "Last blog comments",
// "on blogpost" => "on blogpost",
// "Last `\$module_rows` Created Quizzes" => "Last `\$module_rows` Created Quizzes",
// "Last `\$module_rows` modified file galleries" => "Last `\$module_rows` modified file galleries",
// "Last modified file galleries" => "Last modified file galleries",
// "Last `\$module_rows` Files" => "Last `\$module_rows` Files",
// "Last `\$module_rows` galleries" => "Last `\$module_rows` galleries",
// "Last `\$module_rows` Images" => "Last `\$module_rows` Images",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "Last `\$module_rows` modified events" => "Last `\$module_rows` modified events",
// "Last modifed events" => "Last modifed events",
// "Last `\$module_rows` changes" => "Last `\$module_rows` changes",
// "Last `\$module_rows` Modified Items" => "Last `\$module_rows` Modified Items",
// "Last Modified Items" => "Last Modified Items",
// "Last `\$module_rows` Modified blogs" => "Last `\$module_rows` Modified blogs",
// "Last Modified blogs" => "Last Modified blogs",
// "Last `\$module_rows` submissions" => "Last `\$module_rows` submissions",
// "Last submissions" => "Last submissions",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "Last `\$module_rows` Items" => "Last `\$module_rows` Items",
// "Last `\$module_rows` visitors" => "Last `\$module_rows` visitors",
// "Open operator console" => "Open operator console",
// "Online users" => "Online users",
// "online users" => "online users",
// "CapsLock is on" => "CapsLock is on",
// "Waiting Submissions" => "Waiting Submissions",
// "submissions waiting to be examined" => "submissions waiting to be examined",
// "Random Images" => "Random Images",
// "Random Pages" => "Random Pages",
// "A leading plus sign indicates that this word must be present in every object returned" => "A leading plus sign indicates that this word must be present in every object returned",
// "A leading minus sign indicates that this word must not be present in any row returned" => "A leading minus sign indicates that this word must not be present in any row returned",
// "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher" => "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher",
// "These two operators are used to change a word's contribution to the relevance value that is assigned to a row" => "These two operators are used to change a word's contribution to the relevance value that is assigned to a row",
// "Parentheses are used to group words into subexpressions" => "Parentheses are used to group words into subexpressions",
// "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator" => "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator",
// "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended" => "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended",
// "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed" => "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed",
// "Advanced search" => "Advanced search",
// "Advanced Search Help" => "Advanced Search Help",
// "Page Relations" => "Page Relations",
// "Are you sure you want to delete this shout" => "Are you sure you want to delete this shout",
// "Delete this shout" => "Delete this shout",
// "Edit this shout" => "Edit this shout",
// "`\$module_params.prefix`" => "`\$module_params.prefix`",
// "Theme" => "Theme",
// "Top `\$module_rows` articles" => "Top `\$module_rows` articles",
// "Top articles" => "Top articles",
// "Top `\$module_rows` File Galleries" => "Top `\$module_rows` File Galleries",
// "Top `\$module_rows` files" => "Top `\$module_rows` files",
// "Top files" => "Top files",
// "Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Forum Posters",
// "Top Forum Posters" => "Top Forum Posters",
// "Top `\$module_rows` games" => "Top `\$module_rows` games",
// "Top games" => "Top games",
// "Top `\$module_rows` galleries" => "Top `\$module_rows` galleries",
// "Top `\$module_rows` Images" => "Top `\$module_rows` Images",
// "Top Images" => "Top Images",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Top `\$module_rows` Pages" => "Top `\$module_rows` Pages",
// "Top Pages" => "Top Pages",
// "Top `\$module_rows` Quizzes" => "Top `\$module_rows` Quizzes",
// "Top Quizzes" => "Top Quizzes",
// "Most `\$module_rows` visited blogs" => "Most `\$module_rows` visited blogs",
// "Top `\$module_rows` Visited FAQs" => "Top `\$module_rows` Visited FAQs",
// "Top Visited FAQs" => "Top Visited FAQs",
// "Page translation" => "Page translation",
// "There are no translations of this page" => "There are no translations of this page",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "view" => "view",
// "None match your" => "None match your",
// "Set your preferred languages" => "Set your preferred languages",
// "preferred languages" => "preferred languages",
// "Equivalent translations" => "Equivalent translations",
// "Translations that need improvement" => "Translations that need improvement",
// "update it" => "update it",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "on page" => "on page",
// "Videos on YouTube" => "Videos on YouTube",
// "More Videos" => "More Videos",
// "Changes that need to be reproduced are highlighted below" => "Changes that need to be reproduced are highlighted below",
// "Send Newsletter" => "Send Newsletter",
// "By" => "By",
// "Location : " => "Location : ",
// "Read more" => "Read more",
// "To edit the copyright notices" => "To edit the copyright notices",
// "The content on this page is licensed under the terms of the" => "The content on this page is licensed under the terms of the",
// "comment" => "comment",
// "referenced by" => "referenced by",
// "Trackback pings" => "Trackback pings",
// "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones" => "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones",
// "Change preferences" => "Change preferences",
// "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users" => "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users",
// "Profiles" => "Profiles",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Look &amp; Feel" => "Look &amp; Feel",
// "Editing and Plugins" => "Editing and Plugins",
// "Text area" => "Text area",
// "Multimedia" => "Multimedia",
// "Semantic wiki links" => "Semantic wiki links",
// "Semantic links" => "Semantic links",
// "Webservices" => "Webservices",
// "Sef URL" => "Sef URL",
// "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or",
// "General Settings" => "General Settings",
// "Blogs Listing" => "Blogs Listing",
// "Home Blog (main blog)" => "Home Blog (main blog)",
// "Create a blog" => "Create a blog",
// "Not Installed" => "Not Installed",
// "Spell checking" => "Spell checking",
// "Requires a separate download" => "Requires a separate download",
// "Custom blog headings" => "Custom blog headings",
// "Blog-level" => "Blog-level",
// "Post-level" => "Post-level",
// "Default number per page" => "Default number per page",
// "Default ordering" => "Default ordering",
// "Points" => "Points",
// "Blogs Listings" => "Blogs Listings",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Select which items to display when listing blogs" => "Select which items to display when listing blogs",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "General settings" => "General settings",
// "Default calendars to display" => "Default calendars to display",
// "All calendars" => "All calendars",
// "A subset of available calendars" => "A subset of available calendars",
// "Create calendar" => "Create calendar",
// "View list begins" => "View list begins",
// "Focus Date" => "Focus Date",
// "Period beginning" => "Period beginning",
// "Manual selection of time/date" => "Manual selection of time/date",
// "JS calendar" => "JS calendar",
// "Year selection is valid when the JS Calendar <strong>is not</strong> enabled" => "Year selection is valid when the JS Calendar <strong>is not</strong> enabled",
// "First year in the dropdown" => "First year in the dropdown",
// "Enter a year or use +/- N to specify a year relative to the current\n\tyear" => "Enter a year or use +/- N to specify a year relative to the current\n\tyear",
// "Last year in the dropdown" => "Last year in the dropdown",
// "Group calendars" => "Group calendars",
// "Sticky popup" => "Sticky popup",
// "Item view tab" => "Item view tab",
// "Administer categories" => "Administer categories",
// "Category path" => "Category path",
// "Exclude these categories" => "Exclude these categories",
// "Separate category IDs with a comma (,)" => "Separate category IDs with a comma (,)",
// "Show category objects" => "Show category objects",
// "Use PHPLayers for category browser" => "Use PHPLayers for category browser",
// "PHPLayers is disabled" => "PHPLayers is disabled",
// "Categories used in templates (TPL)" => "Categories used in templates (TPL)",
// "Ignore category viewing restrictions" => "Ignore category viewing restrictions",
// "Will improve performance, but may show forbidden results" => "Will improve performance, but may show forbidden results",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Look under \"Articles\" on the application menu for links to" => "Look under \"Articles\" on the application menu for links to",
// "Articles Listing" => "Articles Listing",
// "Title of articles home page" => "Title of articles home page",
// "Maximum number of articles on articles home page" => "Maximum number of articles on articles home page",
// "Submissions" => "Submissions",
// "Article properties" => "Article properties",
// "Give only one value (width or height) to keep the image proportions" => "Give only one value (width or height) to keep the image proportions",
// "Specify notification emails when creating articles" => "Specify notification emails when creating articles",
// "Default article image width" => "Default article image width",
// "Default article image height" => "Default article image height",
// "Batch upload (CSV file)" => "Batch upload (CSV file)",
// "File format: title,authorName,heading,body,lang,user" => "File format: title,authorName,heading,body,lang,user",
// "Select which items to display when listing articles" => "Select which items to display when listing articles",
// "Publication date" => "Publication date",
// "Expiration date" => "Expiration date",
// "Users Listing" => "Users Listing",
// "Users can choose to show their gender" => "Users can choose to show their gender",
// "Requires User Preferences feature" => "Requires User Preferences feature",
// "Show user's information on mouseover" => "Show user's information on mouseover",
// "Requires user's information to be public" => "Requires user's information to be public",
// "Real name" => "Real name",
// "avatar" => "avatar",
// "Number of friends" => "Number of friends",
// "Feature is disabled" => "Feature is disabled",
// "E-mail" => "E-mail",
// "Last login" => "Last login",
// "Distance" => "Distance",
// "Default user preferences" => "Default user preferences",
// "Users Default Preferences" => "Users Default Preferences",
// "Character set for mail" => "Character set for mail",
// "default" => "default",
// "Number of visited pages to remember" => "Number of visited pages to remember",
// "Displayed time zone" => "Displayed time zone",
// "Detect user timezone if browser allows, otherwise site default" => "Detect user timezone if browser allows, otherwise site default",
// "Show user's info on mouseover" => "Show user's info on mouseover",
// "Tasks per page" => "Tasks per page",
// "User messages" => "User messages",
// "Notify sender when reading mail" => "Notify sender when reading mail",
// "Send me an email for messages with priority equal or greater than" => "Send me an email for messages with priority equal or greater than",
// "Auto-archive read messages after x days" => "Auto-archive read messages after x days",
// "My Tiki" => "My Tiki",
// "My pages" => "My pages",
// "My messages" => "My messages",
// "My tasks" => "My tasks",
// "My forum topics" => "My forum topics",
// "My forum replies" => "My forum replies",
// "My items" => "My items",
// "My workflow" => "My workflow",
// "Select which items to display when listing users" => "Select which items to display when listing users",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "License page" => "License page",
// "Submit notice" => "Submit notice",
// "Enable copyright management for" => "Enable copyright management for",
// "Feature" => "Feature",
// "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or",
// "Number of columns per page when listing categories" => "Number of columns per page when listing categories",
// "Links per page" => "Links per page",
// "Validate URLs" => "Validate URLs",
// "enable cool sites" => "enable cool sites",
// "Show Country Flag" => "Show Country Flag",
// "Method to open directory links" => "Method to open directory links",
// "New Window" => "New Window",
// "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or",
// "Default number of comments per page" => "Default number of comments per page",
// "Comments default ordering" => "Comments default ordering",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site",
// "No tabs" => "No tabs",
// "Main" => "Main",
// "Global Features" => "Global Features",
// "More Functionality" => "More Functionality",
// "UI Enhancements" => "UI Enhancements",
// "Experimental" => "Experimental",
// "Programmer" => "Programmer",
// "Main Features" => "Main Features",
// "Site Global Features" => "Site Global Features",
// "Action Log" => "Action Log",
// "Action log setting" => "Action log setting",
// "Internationalization" => "Internationalization",
// "Multilingual" => "Multilingual",
// "Additional Features" => "Additional Features",
// "Featured Help" => "Featured Help",
// "Copyright System" => "Copyright System",
// "Copyright system" => "Copyright system",
// "Live support system" => "Live support system",
// "Tell a Friend" => "Tell a Friend",
// "Contact Us" => "Contact Us",
// "Minichat" => "Minichat",
// "Comments Moderation" => "Comments Moderation",
// "Comments Locking" => "Comments Locking",
// "User interface enhancement features" => "User interface enhancement features",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "PHPLayers" => "PHPLayers",
// "PhpLayers Dynamic menus" => "PhpLayers Dynamic menus",
// "Allow users to activate fullscreen mode" => "Allow users to activate fullscreen mode",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
// "Mootools or JQuery" => "Mootools or JQuery",
// "Mootools" => "Mootools",
// "Floating help aka the Big Blue Help Icon" => "Floating help aka the Big Blue Help Icon",
// "Experimental Features" => "Experimental Features",
// "Seem ok" => "Seem ok",
// "Features that may change or might be re-worked in the future" => "Features that may change or might be re-worked in the future",
// "Ajax" => "Ajax",
// "HTML Purifier" => "HTML Purifier",
// "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)" => "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)",
// "JQuery: JavaScript UI effects" => "JQuery: JavaScript UI effects",
// "Mobile" => "Mobile",
// "Morcego 3D browser" => "Morcego 3D browser",
// "Need polish" => "Need polish",
// "Features that need admin help and user patience to work well" => "Features that need admin help and user patience to work well",
// "Mindmap" => "Mindmap",
// "Print Indexed" => "Print Indexed",
// "SEFURL" => "SEFURL",
// "Search engine friendly url" => "Search engine friendly url",
// "Spreadsheet" => "Spreadsheet",
// "Tiki Sheet" => "Tiki Sheet",
// "Ajax auto-save" => "Ajax auto-save",
// "Malfunctioning" => "Malfunctioning",
// "These features have critical faults - not recommended" => "These features have critical faults - not recommended",
// "Magic Admin Panel" => "Magic Admin Panel",
// "Neglected" => "Neglected",
// "Old features no longer maintained" => "Old features no longer maintained",
// "Friendship" => "Friendship",
// "SWFObject" => "SWFObject",
// "SwfObject" => "SwfObject",
// "Used to embed Flash content in wiki pages, banners etc" => "Used to embed Flash content in wiki pages, banners etc",
// "Administration Features" => "Administration Features",
// "Banning System" => "Banning System",
// "Banning system" => "Banning system",
// "Action Calendar" => "Action Calendar",
// "Tiki action calendar" => "Tiki action calendar",
// "Redirect On Error" => "Redirect On Error",
// "Communications (send/receive objects)" => "Communications (send/receive objects)",
// "Custom Home" => "Custom Home",
// "User Features" => "User Features",
// "Display 'MyTiki' in the application menu" => "Display 'MyTiki' in the application menu",
// "User Preferences Screen" => "User Preferences Screen",
// "User Notepad" => "User Notepad",
// "User Bookmarks" => "User Bookmarks",
// "User Contacts" => "User Contacts",
// "Group Watches" => "Group Watches",
// "User Watches Translations" => "User Watches Translations",
// "User Tasks" => "User Tasks",
// "User Messages" => "User Messages",
// "User Levels" => "User Levels",
// "Group Alert" => "Group Alert",
// "Programmer Features" => "Programmer Features",
// "XMLRPC API" => "XMLRPC API",
// "Debugger Console" => "Debugger Console",
// "TikiTests" => "TikiTests",
// "requires PHP5 or more" => "requires PHP5 or more",
// "Workflow engine" => "Workflow engine",
// "Use Minified Scripts" => "Use Minified Scripts",
// "To create or remove file galleries, select" => "To create or remove file galleries, select",
// "from the application menu" => "from the application menu",
// "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory" => "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
// "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/",
// "Gallery Listing" => "Gallery Listing",
// "Search Indexing" => "Search Indexing",
// "Create a Gallery" => "Create a Gallery",
// "Store in database" => "Store in database",
// "Store in directory" => "Store in directory",
// "The server must be able to read/write the directory" => "The server must be able to read/write the directory",
// "The directory can be outside the web space" => "The directory can be outside the web space",
// "Podcast directory" => "Podcast directory",
// "Required for podcasts" => "Required for podcasts",
// "Default Ordering" => "Default Ordering",
// "Allow download limit per file" => "Allow download limit per file",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "Score is disabled" => "Score is disabled",
// "Allow same file to be uploaded more than once" => "Allow same file to be uploaded more than once",
// "Never" => "Never",
// "Batch uploading" => "Batch uploading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "The server must be able to read the directory" => "The server must be able to read the directory",
// "Require file author's name for anonymous uploads" => "Require file author's name for anonymous uploads",
// "Upload Regex" => "Upload Regex",
// "Must match" => "Must match",
// "Cannot match" => "Cannot match",
// "Gallery Listings" => "Gallery Listings",
// "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries" => "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries",
// "Select which items to display when listing galleries: " => "Select which items to display when listing galleries: ",
// "Automatically index files on upload or change" => "Automatically index files on upload or change",
// "Handlers" => "Handlers",
// "Add custom handlers to make your files &quot;searchable&quot; content" => "Add custom handlers to make your files &quot;searchable&quot; content",
// "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command" => "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command",
// "To delete a handler, leave the <strong>System Command</strong> field blank" => "To delete a handler, leave the <strong>System Command</strong> field blank",
// "MIME Type" => "MIME Type",
// "System Command" => "System Command",
// "Reindex all files for search" => "Reindex all files for search",
// "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or",
// "Forums Listing" => "Forums Listing",
// "Home Forum (main forum)" => "Home Forum (main forum)",
// "Create a forum" => "Create a forum",
// "Accept wiki syntax" => "Accept wiki syntax",
// "Topic archiving" => "Topic archiving",
// "Quick jumps" => "Quick jumps",
// "Replies are empty" => "Replies are empty",
// "If disabled, replies will quote the original post" => "If disabled, replies will quote the original post",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "First post of a thread can have an empty body" => "First post of a thread can have an empty body",
// "Will be a thread title" => "Will be a thread title",
// "Uploaded filenames must match regex" => "Uploaded filenames must match regex",
// "Threads" => "Threads",
// "Manage thread defaults per-forum" => "Manage thread defaults per-forum",
// "Display thread configuration bar" => "Display thread configuration bar",
// "Allows users to override the defaults" => "Allows users to override the defaults",
// "Keep settings for all forums during the user session" => "Keep settings for all forums during the user session",
// "Default style" => "Default style",
// "Default sort mode" => "Default sort mode",
// "Forum name search" => "Forum name search",
// "When listing forums" => "When listing forums",
// "Forum content search" => "Forum content search",
// "Topic content search" => "Topic content search",
// "Search is disabled" => "Search is disabled",
// "Use Tiki (database-independent) search" => "Use Tiki (database-independent) search",
// "Use database (full-text) search" => "Use database (full-text) search",
// "Select which items to display when listing forums" => "Select which items to display when listing forums",
// "Posts per day" => "Posts per day",
// "Description length" => "Description length",
// "3D Tag Browser" => "3D Tag Browser",
// "Show tag cloud" => "Show tag cloud",
// "Maximum number of tags in cloud" => "Maximum number of tags in cloud",
// "Show freetags in middle column" => "Show freetags in middle column",
// "Preload freetag random tag" => "Preload freetag random tag",
// "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>" => "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>",
// "Random tag cloud colors" => "Random tag cloud colors",
// "Separate colors with a comma (,)" => "Separate colors with a comma (,)",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Alphanumeric ASCII characters only" => "Alphanumeric ASCII characters only",
// "No accents or special characters" => "No accents or special characters",
// "Accept all charactrs" => "Accept all charactrs",
// "Lowercase tags only" => "Lowercase tags only",
// "Multilingual freetags" => "Multilingual freetags",
// "Multiligual disabled" => "Multiligual disabled",
// "&quot;More Like This&quot; algorithm" => "&quot;More Like This&quot; algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Minimum amount of tags in common" => "Minimum amount of tags in common",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "Morcego 3D browser disabled" => "Morcego 3D browser disabled",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Browser width" => "Browser width",
// "Browser height" => "Browser height",
// "Graph appearance" => "Graph appearance",
// "Navigation depth" => "Navigation depth",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Spring (connection) size" => "Spring (connection) size",
// "Node color" => "Node color",
// "Camera settinsg" => "Camera settinsg",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Camera distance" => "Camera distance",
// "Field of view" => "Field of view",
// "Feed animation interval (milisecs)" => "Feed animation interval (milisecs)",
// "Physics engine" => "Physics engine",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or",
// "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value",
// "Uses Slideshow" => "Uses Slideshow",
// "Use database to store images" => "Use database to store images",
// "Use a directory to store images" => "Use a directory to store images",
// "Directory path" => "Directory path",
// "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below" => "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below",
// "Library to use for processing images" => "Library to use for processing images",
// "Uploaded image names must match regex" => "Uploaded image names must match regex",
// "Uploaded image names cannot match regex" => "Uploaded image names cannot match regex",
// "Directory Batch Loading" => "Directory Batch Loading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols",
// "Enable directory batch loading" => "Enable directory batch loading",
// "Batch loading directory" => "Batch loading directory",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Images per row" => "Images per row",
// "Thumbnails size X" => "Thumbnails size X",
// "Pixels Default" => "Pixels Default",
// "Thumbnails size Y" => "Thumbnails size Y",
// "Default scale size" => "Default scale size",
// "pixels" => "pixels",
// "Set features" => "Set features",
// "Exterminator" => "Exterminator",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "System Gallery" => "System Gallery",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Gallery listing configuration" => "Gallery listing configuration",
// "Change configuration" => "Change configuration",
// "Image galleries comments settings" => "Image galleries comments settings",
// "General Preferences" => "General Preferences",
// "Date and Time Formats" => "Date and Time Formats",
// "Admin Password" => "Admin Password",
// "Release Check" => "Release Check",
// "Reset or upgrade your database" => "Reset or upgrade your database",
// "Check for updates automatically" => "Check for updates automatically",
// "Check frequency" => "Check frequency",
// "TikiWiki will check for updates when you access the main Administration page" => "TikiWiki will check for updates when you access the main Administration page",
// "Check for updates now" => "Check for updates now",
// "Site Identity" => "Site Identity",
// "Browser title" => "Browser title",
// "Sender email" => "Sender email",
// "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look &amp; Feel</strong></a> section for additional site related customization preferences" => "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look &amp; Feel</strong></a> section for additional site related customization preferences",
// "Use group homepages" => "Use group homepages",
// "Go to group homepage only if login from default homepage" => "Go to group homepage only if login from default homepage",
// "Use TikiWiki feature as homepage" => "Use TikiWiki feature as homepage",
// "Custom home" => "Custom home",
// "Use different URL as home page" => "Use different URL as home page",
// "Miscellaneous" => "Miscellaneous",
// "Server OS" => "Server OS",
// "Unix" => "Unix",
// "Windows" => "Windows",
// "Unknown/Other" => "Unknown/Other",
// "Smarty Security" => "Smarty Security",
// "Do not allow php code in smarty templates" => "Do not allow php code in smarty templates",
// "Use PEAR::Date library" => "Use PEAR::Date library",
// "Default charset for sending mail" => "Default charset for sending mail",
// "Mail end of line" => "Mail end of line",
// "(standard)" => "(standard)",
// "(some Unix MTA)" => "(some Unix MTA)",
// "Logging and Reporting" => "Logging and Reporting",
// "PHP error reporting level" => "PHP error reporting level",
// "Report all PHP errors except strict" => "Report all PHP errors except strict",
// "Visible to Admin only" => "Visible to Admin only",
// "Include Smarty notices" => "Include Smarty notices",
// "Log mail in Tiki logs" => "Log mail in Tiki logs",
// "Log SQL" => "Log SQL",
// "Log queries using more than" => "Log queries using more than",
// "This may impact performance" => "This may impact performance",
// "Add HTML comment at start and end of each Smarty template (TPL)" => "Add HTML comment at start and end of each Smarty template (TPL)",
// "CSRF Security" => "CSRF Security",
// "Use these options to protect against cross-site request forgeries (CSRF)" => "Use these options to protect against cross-site request forgeries (CSRF)",
// "Require confirmation if possible CSRF detected" => "Require confirmation if possible CSRF detected",
// "Protect against CSRF with a ticket" => "Protect against CSRF with a ticket",
// "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings" => "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings",
// "Site Access" => "Site Access",
// "Close site (except for those with permission)" => "Close site (except for those with permission)",
// "Message to display" => "Message to display",
// "Close site when server load is above the threshold  (except for those with permission)" => "Close site when server load is above the threshold  (except for those with permission)",
// "Maximum average server load threshold in the last minute" => "Maximum average server load threshold in the last minute",
// "Use proxy" => "Use proxy",
// "Host" => "Host",
// "Port" => "Port",
// "On permission denied, display login module (for Anonymous)" => "On permission denied, display login module (for Anonymous)",
// "Send to URL" => "Send to URL",
// "Performance" => "Performance",
// "Cache external pages" => "Cache external pages",
// "Cache external images" => "Cache external images",
// "GZip output" => "GZip output",
// "Tikiwiki.org help" => "Tikiwiki.org help",
// "Output compression is active" => "Output compression is active",
// "Compression is handled by" => "Compression is handled by",
// "Session" => "Session",
// "Advanced configuration warning" => "Advanced configuration warning",
// "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects" => "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects",
// "Enabling this feature will immediately log you out when you save this preference" => "Enabling this feature will immediately log you out when you save this preference",
// "Store session data in database" => "Store session data in database",
// "Session lifetime" => "Session lifetime",
// "Contact" => "Contact",
// "The \"Contact Us\" feature is disabled" => "The \"Contact Us\" feature is disabled",
// "Allow anonymous visitors to use the \"Contact Us\"" => "Allow anonymous visitors to use the \"Contact Us\"",
// "Contact user" => "Contact user",
// "Count admin pageviews" => "Count admin pageviews",
// "Temporary directory" => "Temporary directory",
// "Help System" => "Help System",
// "Help URL" => "Help URL",
// "The default help system may not be complete" => "The default help system may not be complete",
// "You can help with the TikiWiki documentation" => "You can help with the TikiWiki documentation",
// "Show user's real name instead of login (when possible)" => "Show user's real name instead of login (when possible)",
// "Highlight group" => "Highlight group",
// "Show user's contribution on the user information page" => "Show user's contribution on the user information page",
// "Display UserTracker information on the user information page" => "Display UserTracker information on the user information page",
// "Use the format: trackerId, fieldId1, fieldId2, .." => "Use the format: trackerId, fieldId1, fieldId2, ..",
// "Separators" => "Separators",
// "Locations (breadcrumbs)" => "Locations (breadcrumbs)",
// "Examples" => "Examples",
// "Choices" => "Choices",
// "Default timezone" => "Default timezone",
// "Use site default to show times" => "Use site default to show times",
// "Detect user timezone (if browser allows). Otherwise use site default" => "Detect user timezone (if browser allows). Otherwise use site default",
// "Long date format" => "Long date format",
// "Sample" => "Sample",
// "Short date format" => "Short date format",
// "Long time format" => "Long time format",
// "Short time format" => "Short time format",
// "Fields display order" => "Fields display order",
// "Date and Time Format Help" => "Date and Time Format Help",
// "Change admin password" => "Change admin password",
// "Change the <strong>Admin</strong> password" => "Change the <strong>Admin</strong> password",
// "New password" => "New password",
// "Change password" => "Change password",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at " => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at ",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Babelfish links" => "Babelfish links",
// "Customized String Translation" => "Customized String Translation",
// "Default language" => "Default language",
// "Detect browser language" => "Detect browser language",
// "Show pages in user's preferred language" => "Show pages in user's preferred language",
// "User preferences are disabled" => "User preferences are disabled",
// "Users can change site language" => "Users can change site language",
// "Restrict supported languages" => "Restrict supported languages",
// "Available languages" => "Available languages",
// "Use Ctrl+Click to select multiple languages" => "Use Ctrl+Click to select multiple languages",
// "Display available translations" => "Display available translations",
// "Changing page language will also change the site language" => "Changing page language will also change the site language",
// "Translation assistant" => "Translation assistant",
// "Urgent translation notifications" => "Urgent translation notifications",
// "Quantify change size" => "Quantify change size",
// "Structures are disabled" => "Structures are disabled",
// "Use database for translation" => "Use database for translation",
// "Edit or ex/import Languages" => "Edit or ex/import Languages",
// "Record untranslated" => "Record untranslated",
// "Multilingual One Page feature" => "Multilingual One Page feature",
// "Syntax error" => "Syntax error",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// "as master" => "as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "port" => "port",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "Enable/disable Tiki features in " => "Enable/disable Tiki features in ",
// ", but configure them elsewhere" => ", but configure them elsewhere",
// "Look and Feel" => "Look and Feel",
// "Text Area" => "Text Area",
// "Wysiwyg" => "Wysiwyg",
// "Semantic" => "Semantic",
// "Webservices management" => "Webservices management",
// "Admin Groups" => "Admin Groups",
// "Admin Users" => "Admin Users",
// "PEAR::Auth" => "PEAR::Auth",
// "PAM" => "PAM",
// "CAS" => "CAS",
// "Authentication method" => "Authentication method",
// "Tiki" => "Tiki",
// "Tiki and HTTP Auth" => "Tiki and HTTP Auth",
// "Tiki and OpenID" => "Tiki and OpenID",
// "Users can register" => "Users can register",
// "Validate by email" => "Validate by email",
// "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>",
// "Validate user's email server" => "Validate user's email server",
// "Require validation by Admin" => "Require validation by Admin",
// "Require passcode to register" => "Require passcode to register",
// "Passcode" => "Passcode",
// "Users must enter this code to register" => "Users must enter this code to register",
// "Use CAPTCHA to prevent automatic/robot registrations" => "Use CAPTCHA to prevent automatic/robot registrations",
// "Requires PHP GD library" => "Requires PHP GD library",
// "Include &quot;Generate Password&quot; option on registration form" => "Include &quot;Generate Password&quot; option on registration form",
// "Use tracker to collect more user information" => "Use tracker to collect more user information",
// "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display" => "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display",
// "Use tracker to collect more group information" => "Use tracker to collect more group information",
// "Users can select a group to join at registration" => "Users can select a group to join at registration",
// "By default, new users automatically join the Registered group" => "By default, new users automatically join the Registered group",
// "Re-validate user by email after" => "Re-validate user by email after",
// "Use <strong>-1</strong> for never" => "Use <strong>-1</strong> for never",
// "unsuccessful login attempts" => "unsuccessful login attempts",
// "Create a new group for each user" => "Create a new group for each user",
// "The group will be named identical to the user's username" => "The group will be named identical to the user's username",
// "Disable browser's autocomplete feature for username and password fields" => "Disable browser's autocomplete feature for username and password fields",
// "Use challenge/response authentication" => "Use challenge/response authentication",
// "Confirm that the Admin account has a valid email address or you will not be permitted to login" => "Confirm that the Admin account has a valid email address or you will not be permitted to login",
// "Use HTTPS login" => "Use HTTPS login",
// "Users can choose to stay in SSL mode after an HTTPS login" => "Users can choose to stay in SSL mode after an HTTPS login",
// "Users can switch between secured or standard mode at login" => "Users can switch between secured or standard mode at login",
// "HTTP port" => "HTTP port",
// "HTTPS port" => "HTTPS port",
// "Cookie name" => "Cookie name",
// "Use email as username" => "Use email as username",
// "Minimum length" => "Minimum length",
// "Maximum length" => "Maximum length",
// "Force lowercase" => "Force lowercase",
// "Username pattern" => "Username pattern",
// "Store password as plain text" => "Store password as plain text",
// "Store passwords in plain text is activated. You should never set this unless you know what you are doing" => "Store passwords in plain text is activated. You should never set this unless you know what you are doing",
// "Remind/forgot password" => "Remind/forgot password",
// "If passwords </em>are stored<em> as plain text, the password will be emailed to the user" => "If passwords </em>are stored<em> as plain text, the password will be emailed to the user",
// "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user" => "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user",
// "Encryption method" => "Encryption method",
// "Users can change their password" => "Users can change their password",
// "Require characters and numerals" => "Require characters and numerals",
// "Password expires after" => "Password expires after",
// "You must change the Authentication Method to PEAR::Auth for these changes to take effect" => "You must change the Authentication Method to PEAR::Auth for these changes to take effect",
// "Create user if not in Tiki" => "Create user if not in Tiki",
// "Create user if not in Auth" => "Create user if not in Auth",
// "Use Tiki authentication for Admin login" => "Use Tiki authentication for Admin login",
// "LDAP" => "LDAP",
// "Will override the Host and Port settings" => "Will override the Host and Port settings",
// "Search scope" => "Search scope",
// "Subtree" => "Subtree",
// "One level" => "One level",
// "Base object" => "Base object",
// "LDAP version" => "LDAP version",
// "Realname attribute" => "Realname attribute",
// "Country attribute" => "Country attribute",
// "E-mail attribute" => "E-mail attribute",
// "Base DN" => "Base DN",
// "LDAP User" => "LDAP User",
// "User DN" => "User DN",
// "User attribute" => "User attribute",
// "User OC" => "User OC",
// "LDAP Group" => "LDAP Group",
// "Group DN" => "Group DN",
// "Group attribute" => "Group attribute",
// "Group OC" => "Group OC",
// "LDAP Member" => "LDAP Member",
// "Member attribute" => "Member attribute",
// "Member is DN" => "Member is DN",
// "LDAP Admin" => "LDAP Admin",
// "Admin user" => "Admin user",
// "Admin password" => "Admin password",
// "You must change the Authentication Method to PAM for these changes to take effect" => "You must change the Authentication Method to PAM for these changes to take effect",
// "PAM service" => "PAM service",
// "Currently unused" => "Currently unused",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
// "You must change the Authentication Method to Shibboleth for these changes to take effect" => "You must change the Authentication Method to Shibboleth for these changes to take effect",
// "Valid affiliations" => "Valid affiliations",
// "Separate multiple affiliations with commas" => "Separate multiple affiliations with commas",
// "Create with default group" => "Create with default group",
// "Default group" => "Default group",
// "You must change the Authentication Method to CAS for these changes to take effect" => "You must change the Authentication Method to CAS for these changes to take effect",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/" => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/",
// "CAS server version" => "CAS server version",
// "Version 1.0" => "Version 1.0",
// "Version 2.0" => "Version 2.0",
// "CAS Server" => "CAS Server",
// "Hostname" => "Hostname",
// "You must enable PHP CAS first" => "You must enable PHP CAS first",
// "General Layout" => "General Layout",
// "UI Effects" => "UI Effects",
// "The \"users can change theme\" feature will override the theme displayed" => "The \"users can change theme\" feature will override the theme displayed",
// "Theme not saved yet - click \"Apply\"" => "Theme not saved yet - click \"Apply\"",
// "Theme options" => "Theme options",
// "Users can change theme" => "Users can change theme",
// "Restrict available themes" => "Restrict available themes",
// "Available styles" => "Available styles",
// "Each group can have its theme" => "Each group can have its theme",
// "Slideshows theme" => "Slideshows theme",
// "Use transition style sheet from version" => "Use transition style sheet from version",
// "Edit CSS" => "Edit CSS",
// "Tiki Template Viewing" => "Tiki Template Viewing",
// "View Templates" => "View Templates",
// "General Layout options" => "General Layout options",
// "Shadow layer" => "Shadow layer",
// "Enable additional general layout layers for shadows, rounded corners or other decorative styling" => "Enable additional general layout layers for shadows, rounded corners or other decorative styling",
// "Main shadow start" => "Main shadow start",
// "Main shadow end" => "Main shadow end",
// "Header shadow start" => "Header shadow start",
// "Header shadow end" => "Header shadow end",
// "Middle shadow start" => "Middle shadow start",
// "Middle shadow end" => "Middle shadow end",
// "Center shadow start" => "Center shadow start",
// "Center shadow end" => "Center shadow end",
// "Footer shadow start" => "Footer shadow start",
// "Footer shadow end" => "Footer shadow end",
// "Custom Site Header" => "Custom Site Header",
// "Activate will only show content for admin. Check Publish to use content for all users" => "Activate will only show content for admin. Check Publish to use content for all users",
// "Site Logo and Title" => "Site Logo and Title",
// "Site logo source (image path)" => "Site logo source (image path)",
// "Site logo background color" => "Site logo background color",
// "Site logo background style" => "Site logo background style",
// "Site logo alignment" => "Site logo alignment",
// "Site logo title (on mouse over)" => "Site logo title (on mouse over)",
// "Alt. description (e.g. for text browsers)" => "Alt. description (e.g. for text browsers)",
// "Site title" => "Site title",
// "Site subtitle" => "Site subtitle",
// "Site Search Bar" => "Site Search Bar",
// "Site Login Bar" => "Site Login Bar",
// "Top Bar" => "Top Bar",
// "Site menu bar" => "Site menu bar",
// "Note: Needs feature PHPLayers on(default), or feature CSS Menu on  " => "Note: Needs feature PHPLayers on(default), or feature CSS Menu on  ",
// "Current Version" => "Current Version",
// "Custom code" => "Custom code",
// "Users can Flip Columns" => "Users can Flip Columns",
// "Left column" => "Left column",
// "always" => "always",
// "user decides" => "user decides",
// "Site Breadcrumbs" => "Site Breadcrumbs",
// "Site location bar" => "Site location bar",
// "at top of page" => "at top of page",
// "at top of center column" => "at top of center column",
// "Prefix breadcrumbs with 'Location : '" => "Prefix breadcrumbs with 'Location : '",
// "Larger font for" => "Larger font for",
// "entire location" => "entire location",
// "page name" => "page name",
// "Use page description" => "Use page description",
// "Right column" => "Right column",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Left blank to use the default sender email" => "Left blank to use the default sender email",
// "Custom Site Footer" => "Custom Site Footer",
// "Custom End of <body> Code" => "Custom End of <body> Code",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "Bottom bar (RSS)" => "Bottom bar (RSS)",
// "Power by" => "Power by",
// "Pagination links" => "Pagination links",
// "Maximum number of records in listings" => "Maximum number of records in listings",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Use direct pagination links" => "Use direct pagination links",
// "Max. number of links around the current item" => "Max. number of links around the current item",
// "Max. number of links after the first or before the last item" => "Max. number of links after the first or before the last item",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Hide pagination when there is only one page" => "Hide pagination when there is only one page",
// "Use Icons" => "Use Icons",
// "JQuery plugins and add-ons" => "JQuery plugins and add-ons",
// "Warning" => "Warning",
// "Requires jquery feature" => "Requires jquery feature",
// "JQuery Tooltips" => "JQuery Tooltips",
// "JQuery Tooltips: Customisable help tips" => "JQuery Tooltips: Customisable help tips",
// "JQuery Autocomplete" => "JQuery Autocomplete",
// "JQuery Superfish" => "JQuery Superfish",
// "JQuery Superfish (effects on CSS menus)" => "JQuery Superfish (effects on CSS menus)",
// "JQuery Reflection" => "JQuery Reflection",
// "JQuery Reflection (reflection effect on images)" => "JQuery Reflection (reflection effect on images)",
// "JQuery Cycle (slideshow)" => "JQuery Cycle (slideshow)",
// "For future use" => "For future use",
// "JQuery UI" => "JQuery UI",
// "JQuery UI: More JQuery functionality" => "JQuery UI: More JQuery functionality",
// "JQuery Sheet" => "JQuery Sheet",
// "JQuery Spreadsheet" => "JQuery Spreadsheet",
// "JQuery Sortable Tables" => "JQuery Sortable Tables",
// "Standard UI effects" => "Standard UI effects",
// "Effect for modules etc" => "Effect for modules etc",
// "Main JQuery effect" => "Main JQuery effect",
// "Slide" => "Slide",
// "Blind (UI)" => "Blind (UI)",
// "Clip (UI)" => "Clip (UI)",
// "Drop (UI)" => "Drop (UI)",
// "Explode (UI)" => "Explode (UI)",
// "Fold (UI)" => "Fold (UI)",
// "Puff (UI)" => "Puff (UI)",
// "Slide (UI)" => "Slide (UI)",
// "Effect speed" => "Effect speed",
// "Fast" => "Fast",
// "Slow" => "Slow",
// "Effect direction" => "Effect direction",
// "Vertical" => "Vertical",
// "Horizontal" => "Horizontal",
// "Tab UI effects" => "Tab UI effects",
// "Effect for tabs" => "Effect for tabs",
// "JQuery effect for tabs" => "JQuery effect for tabs",
// "Effect speed for tabs" => "Effect speed for tabs",
// "Effect direction for tabs" => "Effect direction for tabs",
// "Other options" => "Other options",
// "Use Tabs" => "Use Tabs",
// "Display menus as folders" => "Display menus as folders",
// "Layout per section" => "Layout per section",
// "Admin layout per section" => "Admin layout per section",
// "Favicon icon file name" => "Favicon icon file name",
// "Favicon icon MIME type" => "Favicon icon MIME type",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "Correct PNG images alpha transparency in IE6 (experimental)" => "Correct PNG images alpha transparency in IE6 (experimental)",
// "List of CSS selectors to be fixed, each selector separated by comma" => "List of CSS selectors to be fixed, each selector separated by comma",
// "List of HTMLDomElements to be fixed, each element separated by comma" => "List of HTMLDomElements to be fixed, each element separated by comma",
// "Context Menus (only in file galleries so far)" => "Context Menus (only in file galleries so far)",
// "Use context menus for actions (icons)" => "Use context menus for actions (icons)",
// "Use context menus for actions (text)" => "Use context menus for actions (text)",
// "full path to mapfiles" => "full path to mapfiles",
// "default mapfile" => "default mapfile",
// "Wiki Page for Help" => "Wiki Page for Help",
// "Wiki Page for Comments" => "Wiki Page for Comments",
// "Full path to gdaltindex" => "Full path to gdaltindex",
// "Full path to ogr2ogr" => "Full path to ogr2ogr",
// "Map Zone" => "Map Zone",
// "Generate User Map" => "Generate User Map",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Maximum mailbox size (messages, 0=unlimited)" => "Maximum mailbox size (messages, 0=unlimited)",
// "Maximum mail archive size (messages, 0=unlimited)" => "Maximum mail archive size (messages, 0=unlimited)",
// "Maximum sent box size (messages, 0=unlimited)" => "Maximum sent box size (messages, 0=unlimited)",
// "Change Preferences" => "Change Preferences",
// "Meta tags" => "Meta tags",
// "Keywords" => "Keywords",
// "Include freetags" => "Include freetags",
// "Use thread title instead" => "Use thread title instead",
// "Use image title instead" => "Use image title instead",
// "Geo URL" => "Geo URL",
// "geo.position" => "geo.position",
// "geo.region" => "geo.region",
// "geo.placename" => "geo.placename",
// "Robots" => "Robots",
// "Meta robots" => "Meta robots",
// "Revisit after" => "Revisit after",
// "&quot;Modules&quot; are the boxes of content in the right &amp; left columns" => "&quot;Modules&quot; are the boxes of content in the right &amp; left columns",
// "Admin &gt; Modules" => "Admin &gt; Modules",
// "from the menu to create and edit modules" => "from the menu to create and edit modules",
// "Show module controls" => "Show module controls",
// "Users can configure modules" => "Users can configure modules",
// "Users can shade modules" => "Users can shade modules",
// "Module decides" => "Module decides",
// "Display modules to all groups always" => "Display modules to all groups always",
// "Hide anonymous-only modules from registered users" => "Hide anonymous-only modules from registered users",
// "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item" => "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Length" => "Flash Length",
// "Flash Heigth" => "Flash Heigth",
// "Video Length" => "Video Length",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or",
// "Anonymous voting" => "Anonymous voting",
// "Allow re-voting" => "Allow re-voting",
// "Categories disabled" => "Categories disabled",
// "Show objects" => "Show objects",
// "Are you sure you want to install the profile" => "Are you sure you want to install the profile",
// "TikiWiki Profiles" => "TikiWiki Profiles",
// "Profile repository" => "Profile repository",
// "Last update" => "Last update",
// "Filter the list of profiles" => "Filter the list of profiles",
// "Profile" => "Profile",
// "Repository" => "Repository",
// "installed" => "installed",
// "Repositories" => "Repositories",
// "Repository URLs" => "Repository URLs",
// "Enter multiple repository URLs, one per line" => "Enter multiple repository URLs, one per line",
// "Data Channels" => "Data Channels",
// "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. " => "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. ",
// "More information" => "More information",
// "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS Modules</strong> menu option, or" => "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS Modules</strong> menu option, or",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Show Author" => "Show Author",
// "Homepage URL" => "Homepage URL",
// "Map files" => "Map files",
// "Defaults" => "Defaults",
// "Default RDF version" => "Default RDF version",
// "Specification" => "Specification",
// "Documentation" => "Documentation",
// "Editor" => "Editor",
// "Webmaster" => "Webmaster",
// "Image Path" => "Image Path",
// "Caching time" => "Caching time",
// "Use <strong>0</strong> for no caching" => "Use <strong>0</strong> for no caching",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public" => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public",
// "You can see users rank by score in the module users_rank, for that go to" => "You can see users rank by score in the module users_rank, for that go to",
// "Admin modules" => "Admin modules",
// "Expiration" => "Expiration",
// "can be seen on page" => "can be seen on page",
// "in Admin menu" => "in Admin menu",
// "Search Results" => "Search Results",
// "Search type" => "Search type",
// "Database search" => "Database search",
// "This search uses the MySQL Full-Text feature" => "This search uses the MySQL Full-Text feature",
// "Tiki search" => "Tiki search",
// "This database-independent search is always enabled" => "This database-independent search is always enabled",
// "Specify the Tiki search settings" => "Specify the Tiki search settings",
// "Refresh mode" => "Refresh mode",
// "random" => "random",
// "Refresh rate" => "Refresh rate",
// "Use <strong>0</strong> for no refresh" => "Use <strong>0</strong> for no refresh",
// "Minimum length of search word" => "Minimum length of search word",
// "Max. number of words containing a syllable" => "Max. number of words containing a syllable",
// "Max. age in hours of syllable search cache" => "Max. age in hours of syllable search cache",
// "LRU list purging rate" => "LRU list purging rate",
// "LRU list length" => "LRU list length",
// "When the Database search is enabled, you must manually refresh the Tiki search indexes" => "When the Database search is enabled, you must manually refresh the Tiki search indexes",
// "Refresh all search index now" => "Refresh all search index now",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "Referer Search Highlighting" => "Referer Search Highlighting",
// "Parse the results" => "Parse the results",
// "May impact performance" => "May impact performance",
// "Enabling these options will improve performance, but may show forbidden results" => "Enabling these options will improve performance, but may show forbidden results",
// "Ignore individual object permissions" => "Ignore individual object permissions",
// "Select the items to display on the search results page" => "Select the items to display on the search results page",
// "Object filter" => "Object filter",
// "Search box" => "Search box",
// "Select the information to display for each result" => "Select the information to display for each result",
// "hits" => "hits",
// "Pertinence" => "Pertinence",
// "Last modified date" => "Last modified date",
// "Search engine friendly url Postfilter" => "Search engine friendly url Postfilter",
// "List of Url Parameters that should go in the path" => "List of Url Parameters that should go in the path",
// "Display article title in the sefurl" => "Display article title in the sefurl",
// "Display blog title in the sefurl" => "Display blog title in the sefurl",
// "Known Types" => "Known Types",
// "Token" => "Token",
// "Invert" => "Invert",
// "Show Usage" => "Show Usage",
// "Delete &amp; Unreference" => "Delete &amp; Unreference",
// "Invert Relation" => "Invert Relation",
// "Self" => "Self",
// "New Types" => "New Types",
// "Fix" => "Fix",
// "No occurences found" => "No occurences found",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "Plugins" => "Plugins",
// "Plugin Aliases" => "Plugin Aliases",
// "Anonymous editors must enter anti-bot code (CAPTCHA)" => "Anonymous editors must enter anti-bot code (CAPTCHA)",
// "Protect email against spam" => "Protect email against spam",
// "External link icon" => "External link icon",
// "External links will be identified with" => "External links will be identified with",
// "Use File Galleries to store pictures " => "Use File Galleries to store pictures ",
// "Dynamic Content System" => "Dynamic Content System",
// "Allow to post comments as Anonymous" => "Allow to post comments as Anonymous",
// "Wiki paragraph formatting" => "Wiki paragraph formatting",
// "...but still create line breaks within paragraphs" => "...but still create line breaks within paragraphs",
// "Automonospaced text" => "Automonospaced text",
// "Tables syntax" => "Tables syntax",
// "&lt;return&gt; for rows" => "&lt;return&gt; for rows",
// "Show quicktags above textareas" => "Show quicktags above textareas",
// "If disabled, quicktags will be shown to the left of textareas" => "If disabled, quicktags will be shown to the left of textareas",
// "Open Hotwords in new window" => "Open Hotwords in new window",
// "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting",
// "Plugin disabled" => "Plugin disabled",
// "Default size" => "Default size",
// "rows" => "rows",
// "Comments " => "Comments ",
// "Forum reply" => "Forum reply",
// "About plugins" => "About plugins",
// "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below" => "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below",
// "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>" => "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>",
// "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below" => "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below",
// "Edit plugin icons" => "Edit plugin icons",
// "Enable edit plugin icons" => "Enable edit plugin icons",
// "(experimental - not comprehensively tested and requires new JQuery feature)" => "(experimental - not comprehensively tested and requires new JQuery feature)",
// "Enable" => "Enable",
// "Disable edit plugin icon (make plugin inline)" => "Disable edit plugin icon (make plugin inline)",
// "About plugin aliases" => "About plugin aliases",
// "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}" => "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}",
// "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}" => "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}",
// "Available Alias" => "Available Alias",
// "Enable Plugins" => "Enable Plugins",
// "General Information" => "General Information",
// "Plugin Name" => "Plugin Name",
// "Base Plugin" => "Base Plugin",
// "Body Label" => "Body Label",
// "Dependencies" => "Dependencies",
// "Validation" => "Validation",
// "Inline (No Plugin Edit UI)" => "Inline (No Plugin Edit UI)",
// "Simple Plugin Arguments" => "Simple Plugin Arguments",
// "Argument" => "Argument",
// "New Argument" => "New Argument",
// "Plugin Parameter Documentation" => "Plugin Parameter Documentation",
// "Safe" => "Safe",
// "Plugin Body" => "Plugin Body",
// "Ignore User Input" => "Ignore User Input",
// "Default Content" => "Default Content",
// "Encoding" => "Encoding",
// "Argument Source (if different)" => "Argument Source (if different)",
// "Default Value" => "Default Value",
// "Composed Plugin Arguments" => "Composed Plugin Arguments",
// "Pattern" => "Pattern",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "Tracker attachment preferences" => "Tracker attachment preferences",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "Validate choice" => "Validate choice",
// "Tracker attachments" => "Tracker attachments",
// "dls" => "dls",
// "Use database to store userfiles" => "Use database to store userfiles",
// "Use a directory to store userfiles" => "Use a directory to store userfiles",
// "Allow viewing HTML mails" => "Allow viewing HTML mails",
// "Include a flag by each e-mail to quickly flag/un-flag them" => "Include a flag by each e-mail to quickly flag/un-flag them",
// "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used" => "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used",
// "Lookup" => "Lookup",
// "Test Input" => "Test Input",
// "Response Information" => "Response Information",
// "OIntegrate Version" => "OIntegrate Version",
// "Not supported" => "Not supported",
// "Schema Version" => "Schema Version",
// "Schema Documentation" => "Schema Documentation",
// "Available" => "Available",
// "Not specified, default used" => "Not specified, default used",
// "Content Type" => "Content Type",
// "Not specified" => "Not specified",
// "Returned Data" => "Returned Data",
// "Proposed Templates" => "Proposed Templates",
// "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters" => "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters",
// "Register Service" => "Register Service",
// "Registered Templates" => "Registered Templates",
// "Engine" => "Engine",
// "Output" => "Output",
// "Register Template" => "Register Template",
// "Use the 'Quick Edit' module to easily create or edit wiki pages" => "Use the 'Quick Edit' module to easily create or edit wiki pages",
// "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules" => "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules",
// "Staging &amp; Approval" => "Staging &amp; Approval",
// "Page Listings" => "Page Listings",
// "Home page" => "Home page",
// "If the page does not exist, it will be created" => "If the page does not exist, it will be created",
// "Wiki link format" => "Wiki link format",
// "Complete" => "Complete",
// "Latin" => "Latin",
// "Select the characters that can be used with Wiki link syntax: ((page name))" => "Select the characters that can be used with Wiki link syntax: ((page name))",
// "Page display" => "Page display",
// "Page ID" => "Page ID",
// "Page version" => "Page version",
// "Page name display stripper" => "Page name display stripper",
// "Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>" => "Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>",
// "Allow override per page" => "Allow override per page",
// "Display show/hide icon displayed before headings" => "Display show/hide icon displayed before headings",
// "Wiki action bar" => "Wiki action bar",
// "Buttons: Save, Preview, Cancel, .." => "Buttons: Save, Preview, Cancel, ..",
// "Page navigation bar location" => "Page navigation bar location",
// "When using the ...page... page break wiki syntax" => "When using the ...page... page break wiki syntax",
// "Wiki top line" => "Wiki top line",
// "Neither" => "Neither",
// "Page description, icons, backlinks, .." => "Page description, icons, backlinks, ..",
// "Wiki buttons" => "Wiki buttons",
// "Buttons: Edit, Source, Remove, .." => "Buttons: Edit, Source, Remove, ..",
// "Cache wiki pages (global)" => "Cache wiki pages (global)",
// "Individual cache" => "Individual cache",
// "Warn on edit conflict" => "Warn on edit conflict",
// "Edit idle timeout" => "Edit idle timeout",
// "Save draft" => "Save draft",
// "Requires AJAX" => "Requires AJAX",
// "experimental" => "experimental",
// "Footnotes" => "Footnotes",
// "Edit section" => "Edit section",
// "Edit section level" => "Edit section level",
// "Allow minor edits" => "Allow minor edits",
// "Minor edits do not flag new content for translation and do not send watch notifications" => "Minor edits do not flag new content for translation and do not send watch notifications",
// "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled" => "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled",
// "Regex search and replace" => "Regex search and replace",
// "Log bytes changes (+/-) in action logs" => "Log bytes changes (+/-) in action logs",
// "Display by default" => "Display by default",
// "Dumps" => "Dumps",
// "Tag for current wiki" => "Tag for current wiki",
// "Restore wiki to tag" => "Restore wiki to tag",
// "Restore" => "Restore",
// "Remove a tag" => "Remove a tag",
// "Generate dump" => "Generate dump",
// "Download last dump" => "Download last dump",
// "Pictures" => "Pictures",
// "WikiWords" => "WikiWords",
// "Accept dashes and underscores in WikiWords" => "Accept dashes and underscores in WikiWords",
// "Link plural WikiWords to their singular forms" => "Link plural WikiWords to their singular forms",
// "Maximum number of versions" => "Maximum number of versions",
// "Never delete versions younger than" => "Never delete versions younger than",
// "Display IP address" => "Display IP address",
// "Default diff style" => "Default diff style",
// "History includes only page data, description, and change comment" => "History includes only page data, description, and change comment",
// "View source" => "View source",
// "Polls are disabled" => "Polls are disabled",
// "like pages" => "like pages",
// "Open page as structure" => "Open page as structure",
// "Make structure from page" => "Make structure from page",
// "Categorize structure pages together" => "Categorize structure pages together",
// "Import HTML" => "Import HTML",
// "Import pages" => "Import pages",
// "Slideshows" => "Slideshows",
// "User's page" => "User's page",
// "UserPage prefix" => "UserPage prefix",
// "Users can lock pages" => "Users can lock pages",
// "Page creators are admin of their pages" => "Page creators are admin of their pages",
// "MultiPrint" => "MultiPrint",
// "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page" => "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page",
// "Wiki watch" => "Wiki watch",
// "Create watch for author on page creation" => "Create watch for author on page creation",
// "Enable watch events when I am the editor" => "Enable watch events when I am the editor",
// "Enable watches on comments" => "Enable watches on comments",
// "Watch minor edits" => "Watch minor edits",
// "Use wiki page staging and approval" => "Use wiki page staging and approval",
// "Force bounce of editing of approved pages to staging" => "Force bounce of editing of approved pages to staging",
// "Delete staging pages at approval" => "Delete staging pages at approval",
// "If not in the group, edit is always redirected to the staging page edit" => "If not in the group, edit is always redirected to the staging page edit",
// "Unique page name prefix to indicate staging copy" => "Unique page name prefix to indicate staging copy",
// "Hide page name prefix" => "Hide page name prefix",
// "Staging" => "Staging",
// "Approved" => "Approved",
// "(mandatory for feature to work)" => "(mandatory for feature to work)",
// "Out-of-sync" => "Out-of-sync",
// "Categorize approved pages with categories of staging copy on approval" => "Categorize approved pages with categories of staging copy on approval",
// "Freetags are disabled" => "Freetags are disabled",
// "Replace freetags with that of staging pages, on approval" => "Replace freetags with that of staging pages, on approval",
// "Add new freetags of approved copy (into tags field) when editing staging pages" => "Add new freetags of approved copy (into tags field) when editing staging pages",
// "Orphan page" => "Orphan page",
// "Configuration" => "Configuration",
// "Select which items to display when listing pages" => "Select which items to display when listing pages",
// "Edit comments" => "Edit comments",
// "Edit Comments length" => "Edit Comments length",
// "Categories path" => "Categories path",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Toolbar content" => "Toolbar content",
// "Restore defaults" => "Restore defaults",
// "Database Version Problem" => "Database Version Problem",
// "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>" => "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>",
// "The following list of changes has been applied" => "The following list of changes has been applied",
// "disabled" => "disabled",
// "enabled" => "enabled",
// "information" => "information",
// "preference" => "preference",
// "preference name" => "preference name",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Administration features" => "Administration features",
// "Security" => "Security",
// "TikiCache/System" => "TikiCache/System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Edit Languages" => "Edit Languages",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "Look &amp; feel" => "Look &amp; feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "Stats &amp; banners" => "Stats &amp; banners",
// "Report" => "Report",
// "Setting" => "Setting",
// "Please select some actions to view" => "Please select some actions to view",
// "bytes" => "bytes",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot" => "Group Bar Plot",
// "Accumulated Bar Plot" => "Accumulated Bar Plot",
// "Legend background color" => "Legend background color",
// "Save graphs to image gallery" => "Save graphs to image gallery",
// "contribution" => "contribution",
// "contributor" => "contributor",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "recorded" => "recorded",
// "viewed" => "viewed",
// "Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki page actions except viewed will always be recorded but can be not reported",
// "Add or edit a rule" => "Add or edit a rule",
// "Rule title" => "Rule title",
// "Username regex matching" => "Username regex matching",
// "IP regex matching" => "IP regex matching",
// "Banned from sections" => "Banned from sections",
// "Rule activated by dates" => "Rule activated by dates",
// "Rule active from" => "Rule active from",
// "Rule active until" => "Rule active until",
// "Custom message to the user" => "Custom message to the user",
// "x" => "x",
// "Configure" => "Configure",
// "Create Calendar" => "Create Calendar",
// "View Calendars" => "View Calendars",
// "Loc" => "Loc",
// "Cat" => "Cat",
// "Lang" => "Lang",
// "Url" => "Url",
// "Prio" => "Prio",
// "Subscription" => "Subscription",
// "Perso" => "Perso",
// "View Calendar" => "View Calendar",
// "Create/Edit Calendars" => "Create/Edit Calendars",
// "Custom Locations" => "Custom Locations",
// "Custom Participants" => "Custom Participants",
// "Custom Categories" => "Custom Categories",
// "Custom Languages" => "Custom Languages",
// "Custom URL" => "Custom URL",
// "Custom Subscription List" => "Custom Subscription List",
// "Custom Priorities" => "Custom Priorities",
// "Standard Colors" => "Standard Colors",
// "Green" => "Green",
// "Blue" => "Blue",
// "Purple" => "Purple",
// "Orange" => "Orange",
// "Yellow" => "Yellow",
// "Let me select my own colors" => "Let me select my own colors",
// "Ex" => "Ex",
// "Default event status" => "Default event status",
// "Show in calendar view" => "Show in calendar view",
// "Group of users alerted when calendar event is modified" => "Group of users alerted when calendar event is modified",
// "Browse the category system" => "Browse the category system",
// "Perms inherited from closest parent if possible or from global perms" => "Perms inherited from closest parent if possible or from global perms",
// "Users can vote for only one item from this chart per period" => "Users can vote for only one item from this chart per period",
// "Prevent users from voting for the same item more than once" => "Prevent users from voting for the same item more than once",
// "Users can suggest new items" => "Users can suggest new items",
// "Auto validate user suggestions" => "Auto validate user suggestions",
// "Ranking shows" => "Ranking shows",
// "Vote items" => "Vote items",
// "Rank 1..5" => "Rank 1..5",
// "Rank 1..10" => "Rank 1..10",
// "Ranking frequency" => "Ranking frequency",
// "Realtime" => "Realtime",
// "Each 5 minutes" => "Each 5 minutes",
// "Daily" => "Daily",
// "Weekly" => "Weekly",
// "Monthly" => "Monthly",
// "Show Average" => "Show Average",
// "Show Votes" => "Show Votes",
// "Use Cookies for unregistered users" => "Use Cookies for unregistered users",
// "Users can vote again after" => "Users can vote again after",
// "Anytime" => "Anytime",
// "Ranks" => "Ranks",
// "No charts defined yet" => "No charts defined yet",
// "CMS" => "CMS",
// "No features are configured to use templates" => "No features are configured to use templates",
// "Visible in no sections" => "Visible in no sections",
// "Remove section" => "Remove section",
// "Contributions are mandatory in wiki pages" => "Contributions are mandatory in wiki pages",
// "Contributions are mandatory in forums" => "Contributions are mandatory in forums",
// "Contributions are mandatory in comments" => "Contributions are mandatory in comments",
// "Contributions are mandatory in blogs" => "Contributions are mandatory in blogs",
// "Contributions are displayed in the comment/post" => "Contributions are displayed in the comment/post",
// "Create a new contribution" => "Create a new contribution",
// "List of contributions" => "List of contributions",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}" => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}",
// "Admin drawings" => "Admin drawings",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link" => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link",
// "Available drawings" => "Available drawings",
// "Ver" => "Ver",
// "Use Admin DSN to define the database to be used by the SQL plugin" => "Use Admin DSN to define the database to be used by the SQL plugin",
// "Create/edit dsn" => "Create/edit dsn",
// "Admin external wikis" => "Admin external wikis",
// "Admin External Wikis" => "Admin External Wikis",
// "tiki admin external wikis template" => "tiki admin external wikis template",
// "URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)",
// "Enable Features" => "Enable Features",
// "Originating e-mail address for mails from this forum" => "Originating e-mail address for mails from this forum",
// "Score (desc)" => "Score (desc)",
// "Replies (desc)" => "Replies (desc)",
// "Reads (desc)" => "Reads (desc)",
// "Set thread preferences" => "Set thread preferences",
// "Show threads preferences" => "Show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default ordering for threads" => "Default ordering for threads",
// "Default style for threads" => "Default style for threads",
// "Duplicate Forum" => "Duplicate Forum",
// "Duplicate" => "Duplicate",
// "List Forums" => "List Forums",
// "Coms" => "Coms",
// "Age" => "Age",
// "PPD" => "PPD",
// ".." => "..",
// "Admin Hotwords" => "Admin Hotwords",
// "Add Hotword" => "Add Hotword",
// "Word" => "Word",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Admin HTML pages" => "Admin HTML pages",
// "Edit zone" => "Edit zone",
// "Dynamic zones" => "Dynamic zones",
// "zone" => "zone",
// "content" => "content",
// "Mass update" => "Mass update",
// "Create new HTML page" => "Create new HTML page",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Edit this HTML page" => "Edit this HTML page",
// "Dynamic" => "Dynamic",
// "Static" => "Static",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature" => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature",
// "Edit Repository" => "Edit Repository",
// "Create New Repository" => "Create New Repository",
// "List Repositories" => "List Repositories",
// "New Repository" => "New Repository",
// "View Repository" => "View Repository",
// "Human readable repository name" => "Human readable repository name",
// "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')",
// "CSS file to load when browse this repository" => "CSS file to load when browse this repository",
// "CSS file" => "CSS file",
// "Is repository visible to users" => "Is repository visible to users",
// "Can files from repository be cached" => "Can files from repository be cached",
// "Cacheable" => "Cacheable",
// "Are files from repository can be cached" => "Are files from repository can be cached",
// "Clear all cached pages of this repository" => "Clear all cached pages of this repository",
// "Clear cache" => "Clear cache",
// "Seconds count 'till cached page will be expired" => "Seconds count 'till cached page will be expired",
// "Cache expiration" => "Cache expiration",
// "Human readable text description of repository" => "Human readable text description of repository",
// "Available Repositories" => "Available Repositories",
// "Edit Rules for Repository" => "Edit Rules for Repository",
// "Configure Repositories" => "Configure Repositories",
// "Configure this Repository" => "Configure this Repository",
// "View this Repository" => "View this Repository",
// "view/hide copy rules dialog" => "view/hide copy rules dialog",
// "Source repository" => "Source repository",
// "Copy" => "Copy",
// "According this order rules will be applied ('0' or empty = auto)" => "According this order rules will be applied ('0' or empty = auto)",
// "Rule order" => "Rule order",
// "Text to search for" => "Text to search for",
// "Text to replace" => "Text to replace",
// "Is this regular expression or simple search/replacer" => "Is this regular expression or simple search/replacer",
// "Regex" => "Regex",
// "Is case sensitive (for simple replacer)" => "Is case sensitive (for simple replacer)",
// "Case sensitive" => "Case sensitive",
// "subset of chars: imsxeADSXUu, which is regex modifiers" => "subset of chars: imsxeADSXUu, which is regex modifiers",
// "Regex modifiers" => "Regex modifiers",
// "Human readable text description of rule" => "Human readable text description of rule",
// "Check to enable this rule" => "Check to enable this rule",
// "Enabled" => "Enabled",
// "Preview options" => "Preview options",
// "Apply all rules or just this to generate preview" => "Apply all rules or just this to generate preview",
// "Apply all rules" => "Apply all rules",
// "View source code after rules applied" => "View source code after rules applied",
// "Code preview" => "Code preview",
// "Generate HTML preview" => "Generate HTML preview",
// "HTML preview" => "HTML preview",
// "Test file from repository to generate preview for (empty = configured start page)" => "Test file from repository to generate preview for (empty = configured start page)",
// "Preview Results" => "Preview Results",
// "Rules List" => "Rules List",
// "Case" => "Case",
// "Admin layout" => "Admin layout",
// "layout options" => "layout options",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>" => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>",
// "Generate positions by hits" => "Generate positions by hits",
// "List of featured links" => "List of featured links",
// "Position" => "Position",
// "Add Featured Link" => "Add Featured Link",
// "Edit this Featured Link" => "Edit this Featured Link",
// "Create new Featured Link" => "Create new Featured Link",
// "disables the link" => "disables the link",
// "Link type" => "Link type",
// "replace current page" => "replace current page",
// "framed" => "framed",
// "open new window" => "open new window",
// "Mail-in accounts" => "Mail-in accounts",
// "Account" => "Account",
// "Add new Mail-in account" => "Add new Mail-in account",
// "Edit Mail-in account" => "Edit Mail-in account",
// "Account name" => "Account name",
// "POP server" => "POP server",
// "SMTP server" => "SMTP server",
// "SMTP requires authentication" => "SMTP requires authentication",
// "article-put" => "article-put",
// "wiki-get" => "wiki-get",
// "wiki-put" => "wiki-put",
// "wiki-append" => "wiki-append",
// "Article Topic" => "Article Topic",
// "Article Type" => "Article Type",
// "Admin Types" => "Admin Types",
// "Allow anonymous acces" => "Allow anonymous acces",
// "Discard to the end from" => "Discard to the end from",
// "Check Mail-in accounts" => "Check Mail-in accounts",
// "Show Quick Urls" => "Show Quick Urls",
// "Some useful URLs" => "Some useful URLs",
// "Hide Quick Urls" => "Hide Quick Urls",
// "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each" => "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each",
// "Home Blog" => "Home Blog",
// "Take a quiz" => "Take a quiz",
// "Stats for a Quiz" => "Stats for a Quiz",
// "Preview menu" => "Preview menu",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'" => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu" => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format" => "To use a menu in a tiki format",
// "To use menu in a css/suckerfish format" => "To use menu in a css/suckerfish format",
// "To customize the menu's CSS id (#)" => "To customize the menu's CSS id (#)",
// "Folder Icon" => "Folder Icon",
// "Path and filename of closed folder icon" => "Path and filename of closed folder icon",
// "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder" => "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder",
// "In the same directory, include an icon for the opened folder" => "In the same directory, include an icon for the opened folder",
// "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>" => "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>",
// "For example, the default icon is: pics/icons/folder.png" => "For example, the default icon is: pics/icons/folder.png",
// "The name of the \"open folder\" icon is: pics/icons/ofolder.png" => "The name of the \"open folder\" icon is: pics/icons/ofolder.png",
// "Assign/Edit modules" => "Assign/Edit modules",
// "Assigned Modules" => "Assigned Modules",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y" => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y",
// "The" => "The",
// "setting will override your selection of specific groups" => "setting will override your selection of specific groups",
// "Visibility" => "Visibility",
// "Displayed now for all eligible users even with personal assigned modules" => "Displayed now for all eligible users even with personal assigned modules",
// "Displayed for the eligible users with no personal assigned modules" => "Displayed for the eligible users with no personal assigned modules",
// "Displayed now, can't be unassigned" => "Displayed now, can't be unassigned",
// "Not displayed until a user chooses it" => "Not displayed until a user chooses it",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules" => "to make sure users will notice any newly assigned modules",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site" => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site",
// "Must be wiki parsed" => "Must be wiki parsed",
// "Objects that can be included" => "Objects that can be included",
// "Available polls" => "Available polls",
// "Random active poll" => "Random active poll",
// "Random current poll" => "Random current poll",
// "Use Poll" => "Use Poll",
// "Random image from" => "Random image from",
// "Dynamic content blocks" => "Dynamic content blocks",
// "Use Dynamic Content" => "Use Dynamic Content",
// "Use RSS Module" => "Use RSS Module",
// "phpLayersMenus" => "phpLayersMenus",
// "Use phplayermenu" => "Use phplayermenu",
// "Banner zones" => "Banner zones",
// "Use Banner Zone" => "Use Banner Zone",
// "Admin newsletter subscriptions" => "Admin newsletter subscriptions",
// "List Newsletters" => "List Newsletters",
// "Edit Newsletter" => "Edit Newsletter",
// "Admin Newsletters" => "Admin Newsletters",
// "Add a subscription newsletters" => "Add a subscription newsletters",
// "You can add several email addresses by separating them with commas" => "You can add several email addresses by separating them with commas",
// "Group users" => "Group users",
// "Group subscription also subscribes included groups" => "Group subscription also subscribes included groups",
// "Don't send confirmation mail" => "Don't send confirmation mail",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Subscribe group" => "Subscribe group",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Subscriptions" => "Subscriptions",
// "Valid" => "Valid",
// "Subscribed" => "Subscribed",
// "Create Newsletter" => "Create Newsletter",
// "There are individual permissions set for this newsletter" => "There are individual permissions set for this newsletter",
// "Users can subscribe/unsubscribe to this list" => "Users can subscribe/unsubscribe to this list",
// "Users can subscribe any email address" => "Users can subscribe any email address",
// "Add unsubscribe instructions to each newsletter" => "Add unsubscribe instructions to each newsletter",
// "Validate email addresses" => "Validate email addresses",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Editions" => "Editions",
// "Drafts" => "Drafts",
// "Last Sent" => "Last Sent",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications",
// "Add notification" => "Add notification",
// "Alert" => "Alert",
// "Event" => "Event",
// "A user edits an article" => "A user edits an article",
// "A user deletes an article" => "A user deletes an article",
// "PHP error" => "PHP error",
// "Preload Admin Account" => "Preload Admin Account",
// "User / Group" => "User / Group",
// "Multiple" => "Multiple",
// "Trackers Outbound Emails" => "Trackers Outbound Emails",
// "Forums Outbound Emails" => "Forums Outbound Emails",
// "Admin Polls" => "Admin Polls",
// "List polls" => "List polls",
// "Edit this poll" => "Edit this poll",
// "Preview poll" => "Preview poll",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Option" => "Option",
// "Poll options" => "Poll options",
// "Votes" => "Votes",
// "Set last poll as current" => "Set last poll as current",
// "Close all polls but last" => "Close all polls but last",
// "Activate all polls" => "Activate all polls",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "active" => "active",
// "current" => "current",
// "template" => "template",
// "object" => "object",
// "Toggle Quick Options" => "Toggle Quick Options",
// "Add Option" => "Add Option",
// "Leave box empty for deleting an option" => "Leave box empty for deleting an option",
// "PublishDate" => "PublishDate",
// "Votes older than these days are no more considered" => "Votes older than these days are no more considered",
// "Span" => "Span",
// "Results" => "Results",
// "Add poll to pages" => "Add poll to pages",
// "Insert (use 'text' for figuring the selection)" => "Insert (use 'text' for figuring the selection)",
// "Admin RSS Modules" => "Admin RSS Modules",
// "Tips" => "Tips",
// "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed" => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed",
// "Content for the feed" => "Content for the feed",
// "Edit this RSS Module" => "Edit this RSS Module",
// "Create new RSS Module" => "Create new RSS Module",
// "show feed title" => "show feed title",
// "show publish date" => "show publish date",
// "RSS channels" => "RSS channels",
// "Show Date" => "Show Date",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>" => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>",
// "PHP settings" => "PHP settings",
// "PHP variable" => "PHP variable",
// "Risk Factor" => "Risk Factor",
// "Explanation" => "Explanation",
// "TikiWiki settings" => "TikiWiki settings",
// "Tiki variable" => "Tiki variable",
// "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors" => "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors",
// "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)" => "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)",
// "Security checks" => "Security checks",
// "Check all tiki files" => "Check all tiki files",
// "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini" => "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini",
// "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database" => "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database",
// "File checks" => "File checks",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments" => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments",
// "See end of table for detailed explanations" => "See end of table for detailed explanations",
// "owner" => "owner",
// "special" => "special",
// "user" => "user",
// "group" => "group",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "sticky" => "sticky",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results" => "What to do with these check results",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"" => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content" => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information" => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes" => "Inodes that are not files or directories are not part of tiki. Review these Inodes",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod" => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod",
// "Admin Shoutbox Words" => "Admin Shoutbox Words",
// "Add Banned Word" => "Add Banned Word",
// "has just been created" => "has just been created",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict",
// "The following pages have automatically been categorized with the same categories as the structure" => "The following pages have automatically been categorized with the same categories as the structure",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent",
// "View structure" => "View structure",
// "Xml Zip" => "Xml Zip",
// "Add a New Question" => "Add a New Question",
// "This survey stats" => "This survey stats",
// "Edit Survey Question" => "Edit Survey Question",
// "Add a New Question to this survey" => "Add a New Question to this survey",
// "Multiple choices of thumbnails from a file gallery" => "Multiple choices of thumbnails from a file gallery",
// "Wiki textarea" => "Wiki textarea",
// "Rate (1..5)" => "Rate (1..5)",
// "Rate (1..10)" => "Rate (1..10)",
// "Rate" => "Rate",
// "Answer is mandatory" => "Answer is mandatory",
// "Number of required answers (for multiple choices)" => "Number of required answers (for multiple choices)",
// "Min" => "Min",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value" => "For a rate, you can give the maximum value",
// "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4" => "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4",
// "Options (if apply)" => "Options (if apply)",
// "Questions" => "Questions",
// "Create New Survey" => "Create New Survey",
// "There are individual permissions set for this survey" => "There are individual permissions set for this survey",
// "Open" => "Open",
// "Tiki Cache/System Admin" => "Tiki Cache/System Admin",
// "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)" => "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)",
// "Exterminator of cached content" => "Exterminator of cached content",
// "Directory to exterminate" => "Directory to exterminate",
// "Clear all Tiki caches" => "Clear all Tiki caches",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save" => "Directories to save",
// "Full Path to the Zip File" => "Full Path to the Zip File",
// "Generate a zip of those directories" => "Generate a zip of those directories",
// "A zip has been written to {\$zipPath}" => "A zip has been written to {\$zipPath}",
// "Directory is not writeable" => "Directory is not writeable",
// "Templates compiler" => "Templates compiler",
// "Compile" => "Compile",
// "Advanced feature" => "Advanced feature",
// "Fix UTF-8 Errors in Tables" => "Fix UTF-8 Errors in Tables",
// "Warning: Make a backup of your Database before using this function" => "Warning: Make a backup of your Database before using this function",
// "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini" => "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini",
// "This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "This function converts ISO-8859-1 encoded strings in your tables to UTF-8",
// "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1",
// "UTF-8 Errors fixed" => "UTF-8 Errors fixed",
// "Admin Tracker" => "Admin Tracker",
// "Admin Trackers" => "Admin Trackers",
// "Edit This Tracker" => "Edit This Tracker",
// "View This Tracker's Items" => "View This Tracker's Items",
// "New tracker field" => "New tracker field",
// "Edit tracker field" => "Edit tracker field",
// "Select list items that will be displayed" => "Select list items that will be displayed",
// "Is column visible when listing tracker items" => "Is column visible when listing tracker items",
// "Column links to edit/view item" => "Column links to edit/view item",
// "Multilingual content" => "Multilingual content",
// "Column is searchable" => "Column is searchable",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "Field is hidden" => "Field is hidden",
// "not hidden" => "not hidden",
// "visible to admin only" => "visible to admin only",
// "editable by admin only" => "editable by admin only",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by" => "Visible by",
// "Editable by" => "Editable by",
// "Field is mandatory" => "Field is mandatory",
// "Description text is wiki-parsed" => "Description text is wiki-parsed",
// "Tracker fields" => "Tracker fields",
// "isMain" => "isMain",
// "Tbl vis" => "Tbl vis",
// "Searchable" => "Searchable",
// "Hidden" => "Hidden",
// "Mandatory" => "Mandatory",
// "Import/Export Trackers Fields" => "Import/Export Trackers Fields",
// "Export fieldId also" => "Export fieldId also",
// "Check the box to re-import in this tracker and change the fields" => "Check the box to re-import in this tracker and change the fields",
// "Uncheck the box to import in another database" => "Uncheck the box to import in another database",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "Edit Tracker" => "Edit Tracker",
// "Import/Export" => "Import/Export",
// "Create Tracker" => "Create Tracker",
// "Duplicate Tracker" => "Duplicate Tracker",
// "trackers" => "trackers",
// "with" => "with",
// "Create/Edit Tracker" => "Create/Edit Tracker",
// "There are individual permissions set for this tracker" => "There are individual permissions set for this tracker",
// "No individual permissions. Global permissions apply" => "No individual permissions. Global permissions apply",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Create a group for each item" => "Create a group for each item",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL",
// "Show status" => "Show status",
// "Default status displayed in list mode" => "Default status displayed in list mode",
// "Show status to tracker admin only" => "Show status to tracker admin only",
// "Send copies of all activity in this tracker to this e-mail address" => "Send copies of all activity in this tracker to this e-mail address",
// "Use simplified e-mail format" => "Use simplified e-mail format",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "New items are created with status" => "New items are created with status",
// "Authoritative status for modified items" => "Authoritative status for modified items",
// "No change" => "No change",
// "Item creator can modify his items" => "Item creator can modify his items",
// "The tracker needs a user field with the option 1" => "The tracker needs a user field with the option 1",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Member of the default group of creator can modify items" => "Member of the default group of creator can modify items",
// "The tracker needs a group field with the option 1" => "The tracker needs a group field with the option 1",
// "Show creation date when listing tracker items" => "Show creation date when listing tracker items",
// "Format if not the default short one" => "Format if not the default short one",
// "Show creation date when viewing tracker item" => "Show creation date when viewing tracker item",
// "Show lastModif date when listing tracker items" => "Show lastModif date when listing tracker items",
// "Show lastModif date when viewing tracker item" => "Show lastModif date when viewing tracker item",
// "What field is used for default sort" => "What field is used for default sort",
// "ItemId" => "ItemId",
// "What is default sort order in list" => "What is default sort order in list",
// "Tracker items allow ratings" => "Tracker items allow ratings",
// "with values" => "with values",
// "and display rating results in listing" => "and display rating results in listing",
// "Tracker items allow comments" => "Tracker items allow comments",
// "and display comments in listing" => "and display comments in listing",
// "and display last comment user/date" => "and display last comment user/date",
// "Tracker items allow attachments" => "Tracker items allow attachments",
// "and display attachments in listing" => "and display attachments in listing",
// "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)",
// "LongDesc" => "LongDesc",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "Do not show empty fields in item view" => "Do not show empty fields in item view",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items",
// "Group of users alerted when tracker is modified" => "Group of users alerted when tracker is modified",
// "Import/export trackers" => "Import/export trackers",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "Admin groups" => "Admin groups",
// "Admin users" => "Admin users",
// "Add new group" => "Add new group",
// "Members" => "Members",
// "Add a New Group" => "Add a New Group",
// "List of existing groups" => "List of existing groups",
// "Includes" => "Includes",
// "User Choice" => "User Choice",
// "Only directly included" => "Only directly included",
// "will have all the permissions of the included groups" => "will have all the permissions of the included groups",
// "Group Homepage" => "Group Homepage",
// "Use wiki page name or full URL" => "Use wiki page name or full URL",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)" => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a group tracker .." => "choose a group tracker ..",
// "choose a field .." => "choose a field ..",
// "Users Information Tracker" => "Users Information Tracker",
// "choose a users tracker .." => "choose a users tracker ..",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Edit Item" => "Edit Item",
// "Group tracker item not found" => "Group tracker item not found",
// "Create Item" => "Create Item",
// "Choose a field .." => "Choose a field ..",
// "Add to group" => "Add to group",
// "Each user in the file must already exist" => "Each user in the file must already exist",
// "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>" => "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>",
// "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login" => "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login",
// "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login" => "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login",
// "ago" => "ago",
// "Assign to group" => "Assign to group",
// "to groups" => "to groups",
// "Edit Included Group" => "Edit Included Group",
// "Edit Group" => "Edit Group",
// "Validate user" => "Validate user",
// "Remove Users and their Userpages" => "Remove Users and their Userpages",
// "Manage Group Assignments" => "Manage Group Assignments",
// "Set Default Groups" => "Set Default Groups",
// "Send a wiki page by Email" => "Send a wiki page by Email",
// "the following groups" => "the following groups",
// "Tip: Hold down CTRL to select multiple" => "Tip: Hold down CTRL to select multiple",
// "Set the default group of the selected users to" => "Set the default group of the selected users to",
// "Template wiki page" => "Template wiki page",
// "bcc" => "bcc",
// "Assign user to Groups" => "Assign user to Groups",
// "Lowercase only" => "Lowercase only",
// "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)" => "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)",
// "Warning: it will mess with slave intertiki sites that use this one as master" => "Warning: it will mess with slave intertiki sites that use this one as master",
// "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth" => "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth",
// "Repeat Password" => "Repeat Password",
// "User must change password at first login" => "User must change password at first login",
// "Send an email to the user in order to allow him to validate his account" => "Send an email to the user in order to allow him to validate his account",
// "Last Login" => "Last Login",
// "User tracker item : {\$usersitemid}" => "User tracker item : {\$usersitemid}",
// "You do not have permission to edit this user" => "You do not have permission to edit this user",
// "Overwrite but keep the previous login if the login exists in another case" => "Overwrite but keep the previous login if the login exists in another case",
// "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>" => "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>",
// "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences" => "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Admin Article Types" => "Admin Article Types",
// "List of types" => "List of types",
// "Show Help" => "Show Help",
// "Article type" => "Article type",
// "Shows up in the drop down list of article types" => "Shows up in the drop down list of article types",
// "Allow ratings by the author" => "Allow ratings by the author",
// "Show before publish date" => "Show before publish date",
// "non-admins can view before the publish date" => "non-admins can view before the publish date",
// "Show after expire date" => "Show after expire date",
// "non-admins can view after the expire date" => "non-admins can view after the expire date",
// "Heading only" => "Heading only",
// "No article body, heading only" => "No article body, heading only",
// "Allow comments for this type" => "Allow comments for this type",
// "Comment Can Rate Article" => "Comment Can Rate Article",
// "Allow comments to include a rating value" => "Allow comments to include a rating value",
// "Show image" => "Show image",
// "Show topic or own image" => "Show topic or own image",
// "Show avatar" => "Show avatar",
// "Show author's avatar" => "Show author's avatar",
// "Show author" => "Show author",
// "Show author name" => "Show author name",
// "Show publish date" => "Show publish date",
// "Show expire date" => "Show expire date",
// "Show reads" => "Show reads",
// "Show the number of times the article was read" => "Show the number of times the article was read",
// "Show size" => "Show size",
// "Show the size of the article" => "Show the size of the article",
// "Show topline" => "Show topline",
// "Show a small title over the title" => "Show a small title over the title",
// "Show subtitle" => "Show subtitle",
// "Show the subtitle" => "Show the subtitle",
// "Show source" => "Show source",
// "Show link to source after article body" => "Show link to source after article body",
// "Show Image Caption" => "Show Image Caption",
// "Show a legend under the image" => "Show a legend under the image",
// "Show Language" => "Show Language",
// "Show the language" => "Show the language",
// "Creator can edit" => "Creator can edit",
// "The person who submits an article of this type can edit it" => "The person who submits an article of this type can edit it",
// "Actions on this article type" => "Actions on this article type",
// "Show lang" => "Show lang",
// "Review" => "Review",
// "Classified" => "Classified",
// "Create a new type" => "Create a new type",
// "level" => "level",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Level configuration" => "Level configuration",
// "all permissions in level" => "all permissions in level",
// "Directory batch upload" => "Directory batch upload",
// "Upload From Disk" => "Upload From Disk",
// "Remove File Extension from Image Name" => "Remove File Extension from Image Name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "Convert the last sub directory to a sub gallery" => "Convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Process" => "Process",
// "Browse File Gallery" => "Browse File Gallery",
// "Please do not use this feature to upload data into the database" => "Please do not use this feature to upload data into the database",
// "available files" => "available files",
// "Process files" => "Process files",
// "Use Wysiwyg Editor" => "Use Wysiwyg Editor",
// "Use Normal Editor" => "Use Normal Editor",
// "The TikiWiki Community" => "The TikiWiki Community",
// "database queries used in " => "database queries used in ",
// "Sheets" => "Sheets",
// "\$feature_label" => "\$feature_label",
// "Directory Batch" => "Directory Batch",
// "You can view this gallery's configured image (first, random, etc.) in your browser using" => "You can view this gallery's configured image (first, random, etc.) in your browser using",
// "You can include the gallery's image in an HTML page using one of these lines" => "You can include the gallery's image in an HTML page using one of these lines",
// "Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/decimal degrees)",
// "Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/decimal degrees)",
// "Admin Calendar" => "Admin Calendar",
// "Export Calendars" => "Export Calendars",
// "Click to export calendars" => "Click to export calendars",
// "Export calendars" => "Export calendars",
// "advanced parameters" => "advanced parameters",
// "Delete event" => "Delete event",
// "All-Day" => "All-Day",
// "Website" => "Website",
// "View this Week" => "View this Week",
// "View this Day" => "View this Day",
// "o" => "o",
// "Recurrence" => "Recurrence",
// "This event depends on a recurrence rule" => "This event depends on a recurrence rule",
// "This event is not recurrent" => "This event is not recurrent",
// "On a weekly basis" => "On a weekly basis",
// "Each" => "Each",
// "of the week" => "of the week",
// "On a monthly basis" => "On a monthly basis",
// "of the month" => "of the month",
// "On a yearly basis" => "On a yearly basis",
// "There's no such date as" => "There's no such date as",
// "Starting on" => "Starting on",
// "ending by" => "ending by",
// "ending after" => "ending after",
// "events" => "events",
// "Start period" => "Start period",
// "End after" => "End after",
// "occurrences" => "occurrences",
// "End before" => "End before",
// "Event is repeated" => "Event is repeated",
// "times" => "times",
// "every" => "every",
// "of every month" => "of every month",
// "on each" => "on each",
// "Events cannot end before they start" => "Events cannot end before they start",
// "Choose users to alert" => "Choose users to alert",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"" => "If no role is provided, default role will be \"Chair participant\"",
// "Update this event only" => "Update this event only",
// "Update every unchanged events of this recurrence rule" => "Update every unchanged events of this recurrence rule",
// "Update every events of this recurrence rule" => "Update every events of this recurrence rule",
// "Delete Recurrent events" => "Delete Recurrent events",
// "import" => "import",
// "%m/%d" => "%m/%d",
// "Avanced parameters for iCal export" => "Avanced parameters for iCal export",
// "Calendars to be exported" => "Calendars to be exported",
// "Categories checking is not done in the database search" => "Categories checking is not done in the database search",
// "Current permissions for this category" => "Current permissions for this category",
// "this category &amp; all its children" => "this category &amp; all its children",
// "this category only" => "this category only",
// "Assigning permissions for <b>all children</b> is recommended for best performance" => "Assigning permissions for <b>all children</b> is recommended for best performance",
// "Your account has been validated" => "Your account has been validated",
// "You have to choose a password to use this account" => "You have to choose a password to use this account",
// "Change password enforced" => "Change password enforced",
// "Change your password" => "Change your password",
// "Old password" => "Old password",
// "Send a message to us" => "Send a message to us",
// "Contact us by email" => "Contact us by email",
// "Send another message" => "Send another message",
// "Group View" => "Group View",
// "You can browse the generated WebHelp here" => "You can browse the generated WebHelp here",
// "Tiki Debugger Console" => "Tiki Debugger Console",
// "Current URL" => "Current URL",
// "Command" => "Command",
// "exec" => "exec",
// "Type <code>help</code> to get list of available commands" => "Type <code>help</code> to get list of available commands",
// "Add a new site" => "Add a new site",
// "You cannot add sites until Directory Categories are setup" => "You cannot add sites until Directory Categories are setup",
// "Please contact the Site Administrator" => "Please contact the Site Administrator",
// "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>" => "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>",
// "Site added" => "Site added",
// "The following site was added, but may require validation by the admin before appearing on the lists" => "The following site was added, but may require validation by the admin before appearing on the lists",
// "Directory Categories" => "Directory Categories",
// "Use Ctrl+Click to select multiple directory categories" => "Use Ctrl+Click to select multiple directory categories",
// "Directory Administration" => "Directory Administration",
// "There are" => "There are",
// "invalid sites" => "invalid sites",
// "valid sites" => "valid sites",
// "Users have visited" => "Users have visited",
// "sites from the directory" => "sites from the directory",
// "Users have searched" => "Users have searched",
// "times from the directory" => "times from the directory",
// "Related" => "Related",
// "Admin directory categories" => "Admin directory categories",
// "Parent directory category" => "Parent directory category",
// "Add a directory category" => "Add a directory category",
// "Edit this directory category" => "Edit this directory category",
// "Children type" => "Children type",
// "Most visited sub-categories" => "Most visited sub-categories",
// "Category description" => "Category description",
// "Random sub-categories" => "Random sub-categories",
// "Maximum number of children to show" => "Maximum number of children to show",
// "Allow sites in this directory category" => "Allow sites in this directory category",
// "Show number of sites in this directory category" => "Show number of sites in this directory category",
// "Editor group" => "Editor group",
// "Directory Subcategories" => "Directory Subcategories",
// "cType" => "cType",
// "allow" => "allow",
// "count" => "count",
// "editor" => "editor",
// "relate" => "relate",
// "Admin related directory categories" => "Admin related directory categories",
// "Parent category" => "Parent category",
// "Add a related category" => "Add a related category",
// "Directory Category" => "Directory Category",
// "Mutual" => "Mutual",
// "Related categories" => "Related categories",
// "Admin sites" => "Admin sites",
// "Use Ctrl+Click to select multiple categories" => "Use Ctrl+Click to select multiple categories",
// "Is valid" => "Is valid",
// "Perform action with selected" => "Perform action with selected",
// "New Sites" => "New Sites",
// "Cool Sites" => "Cool Sites",
// "Add a Site" => "Add a Site",
// "Add a Directory Category" => "Add a Directory Category",
// "any" => "any",
// "in entire directory" => "in entire directory",
// "in current directory category" => "in current directory category",
// "Sort by" => "Sort by",
// "name (desc)" => "name (desc)",
// "name (asc)" => "name (asc)",
// "creation date (desc)" => "creation date (desc)",
// "creation date (asc)" => "creation date (asc)",
// "last updated (desc)" => "last updated (desc)",
// "last updated (asc)" => "last updated (asc)",
// "Last updated" => "Last updated",
// "Related directory categories" => "Related directory categories",
// "Total directory categories" => "Total directory categories",
// "Total links" => "Total links",
// "Links to validate" => "Links to validate",
// "Searches performed" => "Searches performed",
// "Total links visited" => "Total links visited",
// "Directory ranking" => "Directory ranking",
// "Validate sites" => "Validate sites",
// "Topline" => "Topline",
// "Edit or create banners" => "Edit or create banners",
// "List banners" => "List banners",
// "URL to link the banner" => "URL to link the banner",
// "Client" => "Client",
// "Max impressions" => "Max impressions",
// "-1 for unlimited" => "-1 for unlimited",
// "Max clicks" => "Max clicks",
// "Or, create a new zone" => "Or, create a new zone",
// "Show the banner only between these dates" => "Show the banner only between these dates",
// "Select ONE method for the banner" => "Select ONE method for the banner",
// "Use image generated by URL (the image will be requested at the URL for each impression)" => "Use image generated by URL (the image will be requested at the URL for each impression)",
// "Use Flash" => "Use Flash",
// "Movie Size" => "Movie Size",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "Use text" => "Use text",
// "Save the Banner" => "Save the Banner",
// "Remove Zones (you lose entered info for the banner)" => "Remove Zones (you lose entered info for the banner)",
// "A category is mandatory" => "A category is mandatory",
// "Current heading" => "Current heading",
// "There are individual permissions set for this blog" => "There are individual permissions set for this blog",
// "Number of posts to show" => "Number of posts to show",
// "Allow other user to post in this blog" => "Allow other user to post in this blog",
// "Use titles in blog posts" => "Use titles in blog posts",
// "Allow search" => "Allow search",
// "Allow comments" => "Allow comments",
// "Show user avatar" => "Show user avatar",
// "Blog heading" => "Blog heading",
// "Edit Style Sheet" => "Edit Style Sheet",
// "Style Sheet" => "Style Sheet",
// "The file will be saved in" => "The file will be saved in",
// "choose a stylesheet" => "choose a stylesheet",
// "Try" => "Try",
// "For more information, please see <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki Page Editor" => "For more information, please see <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki Page Editor",
// "More help on editing wiki pages" => "More help on editing wiki pages",
// "Wiki Syntax" => "Wiki Syntax",
// "The syntax system used for creating pages in TikiWiki" => "The syntax system used for creating pages in TikiWiki",
// "Bold text" => "Bold text",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Underlined text" => "Underlined text",
// "Colored text" => "Colored text",
// "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background" => "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background",
// "Deleted text" => "Deleted text",
// "2 dashes" => "2 dashes",
// "Headings" => "Headings",
// "Show/Hide" => "Show/Hide",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "Autonumbered Headings" => "Autonumbered Headings",
// "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Horizontal rule" => "Horizontal rule",
// "Text box" => "Text box",
// "Box content" => "Box content",
// "Centered text" => "Centered text",
// "Dynamic variables" => "Dynamic variables",
// "Inserts an editable variable" => "Inserts an editable variable",
// "External links" => "External links",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)" => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)",
// "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))",
// "Square Brackets" => "Square Brackets",
// "Use [[foo] to show [foo]" => "Use [[foo] to show [foo]",
// "Wiki References" => "Wiki References",
// "JoinCapitalizedWords or use" => "JoinCapitalizedWords or use",
// "page|description" => "page|description",
// "for wiki references" => "for wiki references",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "SomeName" => "SomeName",
// "prevents referencing" => "prevents referencing",
// "Lists" => "Lists",
// "for bullet lists" => "for bullet lists",
// "for numbered lists" => "for numbered lists",
// "for definiton lists" => "for definiton lists",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus (useful in list to continue at the same level)" => "Creates an indentation for each plus (useful in list to continue at the same level)",
// "Tables" => "Tables",
// "row" => "row",
// "col" => "col",
// "Monospace font" => "Monospace font",
// "Code sample" => "Code sample",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "creates the editable drawing foo" => "creates the editable drawing foo",
// "Multi-page pages" => "Multi-page pages",
// "to separate pages" => "to separate pages",
// "Non parsed sections" => "Non parsed sections",
// "Prevents wiki parsing of the enclosed data" => "Prevents wiki parsing of the enclosed data",
// "Preformated sections" => "Preformated sections",
// "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text" => "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text",
// "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar" => "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar",
// "Block Preformatting" => "Block Preformatting",
// "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that" => "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew" => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew",
// "Special characters" => "Special characters",
// "hard space" => "hard space",
// "numeric between ~ for html numeric characters entity" => "numeric between ~ for html numeric characters entity",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines" => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line" => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line",
// "Wiki plugins extend the function of wiki syntax with more specialized commands" => "Wiki plugins extend the function of wiki syntax with more specialized commands",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt",
// "text, bold" => "text, bold",
// "text, italic" => "text, italic",
// "text, underline" => "text, underline",
// "table" => "table",
// "table new" => "table new",
// "external link" => "external link",
// "heading1" => "heading1",
// "title bar" => "title bar",
// "box" => "box",
// "rss feed" => "rss feed",
// "dynamic content" => "dynamic content",
// "tagline" => "tagline",
// "horizontal rule" => "horizontal rule",
// "center text" => "center text",
// "colored text" => "colored text",
// "dynamic variable" => "dynamic variable",
// "New wms Metadata" => "New wms Metadata",
// "New Class" => "New Class",
// "New Projection" => "New Projection",
// "New Query" => "New Query",
// "New Scalebar" => "New Scalebar",
// "New Layer" => "New Layer",
// "New Label" => "New Label",
// "New Reference" => "New Reference",
// "New Legend" => "New Legend",
// "New Web" => "New Web",
// "New Outputformat" => "New Outputformat",
// "New Mapfile" => "New Mapfile",
// "Add image from File Gallery" => "Add image from File Gallery",
// "quote" => "quote",
// "flash" => "flash",
// "{\$label}" => "{\$label}",
// "Add Image from File Gallery" => "Add Image from File Gallery",
// "special chars" => "special chars",
// "special characters" => "special characters",
// "Leave Fullscreen Edit" => "Leave Fullscreen Edit",
// "Fullscreen Edit" => "Fullscreen Edit",
// "The following image was successfully edited" => "The following image was successfully edited",
// "Edit and create Languages" => "Edit and create Languages",
// "Im-Export Languages" => "Im-Export Languages",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Edit and create languages" => "Edit and create languages",
// "Create Language" => "Create Language",
// "Select the language to edit" => "Select the language to edit",
// "Edit translations" => "Edit translations",
// "Translate recorded" => "Translate recorded",
// "reset table" => "reset table",
// "Program dynamic content for block" => "Program dynamic content for block",
// "Create New Block" => "Create New Block",
// "Block description: " => "Block description: ",
// "You are editing block" => "You are editing block",
// "Publishing date" => "Publishing date",
// "Publishing Date" => "Publishing Date",
// "Edit question options" => "Edit question options",
// "Quiz Stats" => "Quiz Stats",
// "This Quiz Stats" => "This Quiz Stats",
// "Edit this Quiz" => "Edit this Quiz",
// "Admin Quizzes" => "Admin Quizzes",
// "Create/edit options for question" => "Create/edit options for question",
// "Create/edit quizzes" => "Create/edit quizzes",
// "There are individual permissions set for this quiz" => "There are individual permissions set for this quiz",
// "Quiz can be repeated" => "Quiz can be repeated",
// "Store quiz results" => "Store quiz results",
// "Immediate feedback" => "Immediate feedback",
// "Show correct answers" => "Show correct answers",
// "Shuffle questions" => "Shuffle questions",
// "Shuffle answers" => "Shuffle answers",
// "Questions per page" => "Questions per page",
// "Quiz is time limited" => "Quiz is time limited",
// "Passing Percentage" => "Passing Percentage",
// "Quiz" => "Quiz",
// "canRepeat" => "canRepeat",
// "timeLimit" => "timeLimit",
// "Edit quiz questions" => "Edit quiz questions",
// "Create/edit questions for quiz" => "Create/edit questions for quiz",
// "Question Type" => "Question Type",
// "Import questions from text" => "Import questions from text",
// "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character" => "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character",
// "Input" => "Input",
// "maxScore" => "maxScore",
// "Edit quiz results" => "Edit quiz results",
// "From Points" => "From Points",
// "To Points" => "To Points",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "List Submissions" => "List Submissions",
// "<b>Topline</b>=small line above Title" => "<b>Topline</b>=small line above Title",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "<b>Source</b>=URL to article source" => "<b>Source</b>=URL to article source",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "Template listing" => "Template listing",
// "Available templates" => "Available templates",
// "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering" => "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering",
// "This would cause you problems (e.g. menus can stop collapsing/expanding)" => "This would cause you problems (e.g. menus can stop collapsing/expanding)",
// "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)" => "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)",
// "Maybe You just want to modify the top of your Tiki site" => "Maybe You just want to modify the top of your Tiki site",
// "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface" => "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface",
// "Save Only in the Theme" => "Save Only in the Theme",
// "Delete the copy in the theme" => "Delete the copy in the theme",
// "Edit a topic" => "Edit a topic",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "View Page" => "View Page",
// "View Article" => "View Article",
// "You must specify the object language" => "You must specify the object language",
// "The object doesn't exist" => "The object doesn't exist",
// "The object doesn't have a language" => "The object doesn't have a language",
// "The object has already a translation for this language" => "The object has already a translation for this language",
// "The object is already in the set of translations" => "The object is already in the set of translations",
// "Language of newly translated page" => "Language of newly translated page",
// "Unspecified" => "Unspecified",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"" => "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "detach" => "detach",
// "Change language for this page" => "Change language for this page",
// "Select from available options.." => "Select from available options..",
// "Change Language" => "Change Language",
// "No language is assigned to this page" => "No language is assigned to this page",
// "Please select a language before performing translation" => "Please select a language before performing translation",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Update '{\$page}'" => "Update '{\$page}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval" => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval",
// "This is a new staging page that has not been approved before" => "This is a new staging page that has not been approved before",
// "The current staging copy may contain changes that have yet to be approved" => "The current staging copy may contain changes that have yet to be approved",
// "View changes since last approval" => "View changes since last approval",
// "You are editing the approved copy of this page" => "You are editing the approved copy of this page",
// "There are currently changes in the staging copy that have yet to be approved" => "There are currently changes in the staging copy that have yet to be approved",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead" => "instead",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Perhaps you are looking for" => "Perhaps you are looking for",
// "Change the style used to display differences to be translated" => "Change the style used to display differences to be translated",
// "Change diff styles" => "Change diff styles",
// "Switch to WYSIWYG editor" => "Switch to WYSIWYG editor",
// "Switch to normal (wiki) editor" => "Switch to normal (wiki) editor",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Use rating" => "Use rating",
// "Disable" => "Disable",
// "There is no available poll template" => "There is no available poll template",
// "You should ask an admin to create them" => "You should ask an admin to create them",
// "or use" => "or use",
// "an existing poll" => "an existing poll",
// "votes" => "votes",
// "AutoSave" => "AutoSave",
// "If you want the saved version instead of the autosaved one" => "If you want the saved version instead of the autosaved one",
// "Regex search " => "Regex search ",
// "Replace to" => "Replace to",
// "Case Insensitivity" => "Case Insensitivity",
// "Translation request" => "Translation request",
// "Send urgent translation request" => "Send urgent translation request",
// "Edit Comment" => "Edit Comment",
// "Monitor this page" => "Monitor this page",
// "Try to convert HTML to wiki" => "Try to convert HTML to wiki",
// "Add another image" => "Add another image",
// "List Sheets" => "List Sheets",
// "Graph" => "Graph",
// "Export to file" => "Export to file",
// "Format" => "Format",
// "Autodetect" => "Autodetect",
// "Export Tracker Items" => "Export Tracker Items",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse as Wiki Text" => "Parse as Wiki Text",
// "status" => "status",
// "lastModif" => "lastModif",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "These fields" => "These fields",
// "Use Ctrl+Click to select multiple fields" => "Use Ctrl+Click to select multiple fields",
// "Dump All Tracker Items" => "Dump All Tracker Items",
// "Admin FAQ" => "Admin FAQ",
// "View FAQ" => "View FAQ",
// "Edit this FAQ" => "Edit this FAQ",
// "New Question" => "New Question",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "Use a question from another FAQ" => "Use a question from another FAQ",
// "FAQ questions" => "FAQ questions",
// "Suggested questions" => "Suggested questions",
// "No suggested questions" => "No suggested questions",
// "File Archive" => "File Archive",
// "View tpl" => "View tpl",
// "File Galleries tpl" => "File Galleries tpl",
// "Be careful to set the right permissions on the files you link to" => "Be careful to set the right permissions on the files you link to",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>" => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred" => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into" => "Which Forum Do You Wish to Import this Into",
// "Message queue for forum" => "Message queue for forum",
// "Back to forum" => "Back to forum",
// "make this a thread of" => "make this a thread of",
// "None, this is a thread message" => "None, this is a thread message",
// "summary" => "summary",
// "normal" => "normal",
// "announce" => "announce",
// "hot" => "hot",
// "no feeling" => "no feeling",
// "frown" => "frown",
// "exclaim" => "exclaim",
// "idea" => "idea",
// "mad" => "mad",
// "neutral" => "neutral",
// "question" => "question",
// "sad" => "sad",
// "happy" => "happy",
// "wink" => "wink",
// "Save and Approve" => "Save and Approve",
// "convert to topic" => "convert to topic",
// "List of messages" => "List of messages",
// "New Topic" => "New Topic",
// "no summary" => "no summary",
// "No messages queued yet" => "No messages queued yet",
// "Search by name" => "Search by name",
// "Last Post" => "Last Post",
// "Configure Forum" => "Configure Forum",
// "Reported messages for forum" => "Reported messages for forum",
// "Reported by" => "Reported by",
// "No records to display" => "No records to display",
// "Perfom action with checked" => "Perfom action with checked",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag" => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag",
// "Until then, they cannot be translated" => "Until then, they cannot be translated",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "Pending requests" => "Pending requests",
// "Request Time" => "Request Time",
// "Accept" => "Accept",
// "Refuse" => "Refuse",
// "Waiting requests" => "Waiting requests",
// "Cancel friendship request" => "Cancel friendship request",
// "Your friends" => "Your friends",
// "break friendship" => "break friendship",
// "Activity completed" => "Activity completed",
// "Admin process activities" => "Admin process activities",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "Add or edit an activity" => "Add or edit an activity",
// "activity" => "activity",
// "split" => "split",
// "join" => "join",
// "standalone" => "standalone",
// "interactive" => "interactive",
// "auto routed" => "auto routed",
// "Expiration Time" => "Expiration Time",
// "Years" => "Years",
// "Months" => "Months",
// "Minutes" => "Minutes",
// "Add transitions" => "Add transitions",
// "Add transition from" => "Add transition from",
// "Add transition to" => "Add transition to",
// "No roles associated to this activity" => "No roles associated to this activity",
// "Add Role" => "Add Role",
// "Add New" => "Add New",
// "Process activities" => "Process activities",
// "Int" => "Int",
// "Routing" => "Routing",
// "Interactive" => "Interactive",
// "Automatic" => "Automatic",
// "Auto routed" => "Auto routed",
// "Manual" => "Manual",
// "#" => "#",
// "inter" => "inter",
// "route" => "route",
// "(no roles)" => "(no roles)",
// "No activities defined yet" => "No activities defined yet",
// "Process Transitions" => "Process Transitions",
// "List of transitions" => "List of transitions",
// "Origin" => "Origin",
// "No transitions defined yet" => "No transitions defined yet",
// "Add a transition" => "Add a transition",
// "Process Graph" => "Process Graph",
// "Galaxia Admin Graph" => "Galaxia Admin Graph",
// "Galaxia Admin Graph tpl" => "Galaxia Admin Graph tpl",
// "Edit Tpl" => "Edit Tpl",
// "This process is invalid" => "This process is invalid",
// "Process Graph for" => "Process Graph for",
// "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed" => "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed",
// "List of processes" => "List of processes",
// "Inactive" => "Inactive",
// "act" => "act",
// "val" => "val",
// "Active Process" => "Active Process",
// "Invalid Process" => "Invalid Process",
// "Valid Process" => "Valid Process",
// "Activities" => "Activities",
// "New Minor" => "New Minor",
// "New Major" => "New Major",
// "No processes defined yet" => "No processes defined yet",
// "Admin instance" => "Admin instance",
// "Instance" => "Instance",
// "Workitems" => "Workitems",
// "exception" => "exception",
// "completed" => "completed",
// "Aborted" => "Aborted",
// "Owner" => "Owner",
// "Send all to" => "Send all to",
// "Don't move" => "Don't move",
// "Act status" => "Act status",
// "Ended" => "Ended",
// "Not Defined" => "Not Defined",
// "Not Interactive" => "Not Interactive",
// "Not Ended" => "Not Ended",
// "Property" => "Property",
// "Add property" => "Add property",
// "run instance" => "run instance",
// "Executed" => "Executed",
// "erase" => "erase",
// "Galaxia Admin Processes" => "Galaxia Admin Processes",
// "Galaxia Admin Processes tpl" => "Galaxia Admin Processes tpl",
// "Add or edit a process" => "Add or edit a process",
// "Process Name" => "Process Name",
// "ver" => "ver",
// "is active" => "is active",
// "Or upload a process using this form" => "Or upload a process using this form",
// "Admin process roles" => "Admin process roles",
// "Add or edit a role" => "Add or edit a role",
// "Process roles" => "Process roles",
// "No roles defined yet" => "No roles defined yet",
// "Map users to roles" => "Map users to roles",
// "map" => "map",
// "Map groups to roles" => "Map groups to roles",
// "Operation" => "Operation",
// "No roles are defined yet so no roles can be mapped" => "No roles are defined yet so no roles can be mapped",
// "List of mappings" => "List of mappings",
// "No mappings defined yet" => "No mappings defined yet",
// "Admin process sources" => "Admin process sources",
// "select source" => "select source",
// "Shared code" => "Shared code",
// "Set next user" => "Set next user",
// "Get property" => "Get property",
// "Set property" => "Set property",
// "Process form" => "Process form",
// "Set Next act" => "Set Next act",
// "If:SetNextact" => "If:SetNextact",
// "Switch construct" => "Switch construct",
// "Map process roles" => "Map process roles",
// "Admin Processes" => "Admin Processes",
// "Admin Activities" => "Admin Activities",
// "Admin Roles" => "Admin Roles",
// "Edit this Process" => "Edit this Process",
// "Monitor Activities" => "Monitor Activities",
// "Galaxia Monitor Activities" => "Galaxia Monitor Activities",
// "Galaxia Monitor Activities tpl" => "Galaxia Monitor Activities tpl",
// "List of activities" => "List of activities",
// "Proc" => "Proc",
// "auto" => "auto",
// "int" => "int",
// "routing" => "routing",
// "Instances" => "Instances",
// "run" => "run",
// "run activity" => "run activity",
// "Enter the name of this instance" => "Enter the name of this instance",
// "The name is not valid. Please, enter the name again" => "The name is not valid. Please, enter the name again",
// "Monitor" => "Monitor",
// "monitor processes" => "monitor processes",
// "monitor activities" => "monitor activities",
// "monitor instances" => "monitor instances",
// "monitor workitems" => "monitor workitems",
// "Monitor Instances" => "Monitor Instances",
// "Galaxia Monitor Instances" => "Galaxia Monitor Instances",
// "Galaxia Monitor Instances tpl" => "Galaxia Monitor Instances tpl",
// "List of instances" => "List of instances",
// "Not ended" => "Not ended",
// "No instances created yet" => "No instances created yet",
// "Monitor Processes" => "Monitor Processes",
// "Galaxia Monitor Processes" => "Galaxia Monitor Processes",
// "Galaxia Monitor Processes tpl" => "Galaxia Monitor Processes tpl",
// "processes" => "processes",
// "being run" => "being run",
// "Completed" => "Completed",
// "Exceptions" => "Exceptions",
// "Monitor workitems" => "Monitor workitems",
// "List of workitems" => "List of workitems",
// "instance" => "instance",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "My activities" => "My activities",
// "Current Activity" => "Current Activity",
// "Assigned To" => "Assigned To",
// "exception instance" => "exception instance",
// "exceptions instance" => "exceptions instance",
// "Send Instance" => "Send Instance",
// "abort instance" => "abort instance",
// "grab instance" => "grab instance",
// "release instance" => "release instance",
// "No activities found" => "No activities found",
// "My instances" => "My instances",
// "No instances found" => "No instances found",
// "User Activities" => "User Activities",
// "Galaxia User Activities" => "Galaxia User Activities",
// "Galaxia User Activities tpl" => "Galaxia User Activities tpl",
// "process" => "process",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "user processes" => "user processes",
// "user activities" => "user activities",
// "user instances" => "user instances",
// "User Instances" => "User Instances",
// "Galaxia User Instances" => "Galaxia User Instances",
// "Galaxia User Instances tpl" => "Galaxia User Instances tpl",
// "Inst Status" => "Inst Status",
// "Not defined" => "Not defined",
// "No instances defined yet" => "No instances defined yet",
// "User Processes" => "User Processes",
// "Galaxia User Processes" => "Galaxia User Processes",
// "Galaxia User Processes tpl" => "Galaxia User Processes tpl",
// "Browsing Workitem" => "Browsing Workitem",
// "Workitem information" => "Workitem information",
// "Available scales" => "Available scales",
// "Global default" => "Global default",
// "Bounding box" => "Bounding box",
// "default scale" => "default scale",
// "No scales available" => "No scales available",
// "Original image is default scale" => "Original image is default scale",
// "Add scaled images with bounding box of square size" => "Add scaled images with bounding box of square size",
// "You can access the gallery using the following URL" => "You can access the gallery using the following URL",
// "Available Galleries" => "Available Galleries",
// "Choose a filter" => "Choose a filter",
// "Imgs" => "Imgs",
// "Make Map" => "Make Map",
// "Google Map Locator" => "Google Map Locator",
// "Save clicked point" => "Save clicked point",
// "Reset view to default" => "Reset view to default",
// "Save current view as default" => "Save current view as default",
// "Center map to saved point" => "Center map to saved point",
// "Reset view to site default" => "Reset view to site default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal Scale" => "Horizontal Scale",
// "Bottom" => "Bottom",
// "Vertical Scale" => "Vertical Scale",
// "Series" => "Series",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Im- Export languages" => "Im- Export languages",
// "Select the language to Import" => "Select the language to Import",
// "Select the language to Export" => "Select the language to Export",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "Import From File" => "Import From File",
// "Grab Wiki Tables" => "Grab Wiki Tables",
// "Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
// "Name of the dump file (it has to be in dump/)" => "Name of the dump file (it has to be in dump/)",
// "Overwrite existing pages if the name is the same" => "Overwrite existing pages if the name is the same",
// "Previously remove existing page versions" => "Previously remove existing page versions",
// "excerpt" => "excerpt",
// "Result" => "Result",
// "body" => "body",
// "XML Zip" => "XML Zip",
// "Tiki installer" => "Tiki installer",
// "Welcome" => "Welcome",
// "Welcome to the Tiki installation and upgrade script" => "Welcome to the Tiki installation and upgrade script",
// "Use this script to install a new Tiki database or upgrade your existing database to release" => "Use this script to install a new Tiki database or upgrade your existing database to release",
// "For the latest information about this release, please read the" => "For the latest information about this release, please read the",
// "Release Notes" => "Release Notes",
// "For complete documentation, please visit" => "For complete documentation, please visit",
// "For more information about Tiki, please visit" => "For more information about Tiki, please visit",
// "Select your language" => "Select your language",
// "Read the License" => "Read the License",
// "Tiki is software distributed under the LGPL license" => "Tiki is software distributed under the LGPL license",
// " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>" => " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>",
// "Review the System Requirements" => "Review the System Requirements",
// "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements",
// "This installer will perform some basic checks automatically" => "This installer will perform some basic checks automatically",
// "Memory" => "Memory",
// "Success" => "Success",
// "Tiki has not detected your PHP memory_limit" => "Tiki has not detected your PHP memory_limit",
// "This probably means you have no set limit (all is well)" => "This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution" => "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution",
// "Allocating too little memory will cause Tiki to display blank pages" => "Allocating too little memory will cause Tiki to display blank pages",
// "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver" => "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Mail" => "Mail",
// "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages" => "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages",
// "To test your system configuration, Tiki will attempt to send a test message to you" => "To test your system configuration, Tiki will attempt to send a test message to you",
// "Test email" => "Test email",
// "Email address to send test to" => "Email address to send test to",
// "Copy test mail to " => "Copy test mail to ",
// "Send Test Message" => "Send Test Message",
// "Tiki was able to send a test message to" => "Tiki was able to send a test message to",
// "Tiki was not able to send a test message" => "Tiki was not able to send a test message",
// "Review your mail log for details" => "Review your mail log for details",
// "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)" => "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)",
// "If your host requires SMTP authentication, additional configuration may be necessary" => "If your host requires SMTP authentication, additional configuration may be necessary",
// "Image Processing" => "Image Processing",
// "Tiki detected" => "Tiki detected",
// "Tiki was not able to detect the GD library" => "Tiki was not able to detect the GD library",
// "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support" => "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support",
// "Set the Database Connection" => "Set the Database Connection",
// "Tiki requires an active database connection" => "Tiki requires an active database connection",
// "You must create the database and user <em>before</em> completing this page" => "You must create the database and user <em>before</em> completing this page",
// "This is normal for a new installation" => "This is normal for a new installation",
// "Tiki found an existing database connection in your local.php file" => "Tiki found an existing database connection in your local.php file",
// "Use Existing Connection" => "Use Existing Connection",
// "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>" => "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>",
// "Database information" => "Database information",
// "Enter your database connection information" => "Enter your database connection information",
// "Select the type of database to use with Tiki" => "Select the type of database to use with Tiki",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension" => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension",
// "Host name" => "Host name",
// "Enter the host name or IP for your database" => "Enter the host name or IP for your database",
// "Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "For SQLite, enter the path and filename to your database file" => "For SQLite, enter the path and filename to your database file",
// "Enter the name of the database that Tiki will use" => "Enter the name of the database that Tiki will use",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names",
// "For Oracle" => "For Oracle",
// "Enter your TNS Name here and leave Host empty" => "Enter your TNS Name here and leave Host empty",
// "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field" => "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field",
// "Database user" => "Database user",
// "Enter a database user with administrator permission for the Database" => "Enter a database user with administrator permission for the Database",
// "User name" => "User name",
// "Install &amp; Update Profile" => "Install &amp; Update Profile",
// "Install Profile" => "Install Profile",
// "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page" => "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page",
// "Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database" => "Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database",
// "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>" => "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>",
// "Select the installation profile to use. This profile will populate the database" => "Select the installation profile to use. This profile will populate the database",
// "Profiles can be used to pre-configure your site with specific features and settings" => "Profiles can be used to pre-configure your site with specific features and settings",
// "Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information" => "Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information",
// "Install" => "Install",
// "Reinstall the database" => "Reinstall the database",
// "This will destroy your current database" => "This will destroy your current database",
// "Create a new database (clean install) with profile" => "Create a new database (clean install) with profile",
// "Bare-bones default install" => "Bare-bones default install",
// "Personal Blog and Profile" => "Personal Blog and Profile",
// "Small Organization Web Presence" => "Small Organization Web Presence",
// "Company Intranet" => "Company Intranet",
// "Collaborative community" => "Collaborative community",
// "See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles" => "See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles",
// "The installer could not connect to the Profiles repository" => "The installer could not connect to the Profiles repository",
// "The default installation profile will be used" => "The default installation profile will be used",
// "Upgrade" => "Upgrade",
// "Automatically upgrade your existing database to v" => "Automatically upgrade your existing database to v",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Pass" => "Pass",
// "Review the Upgrade" => "Review the Upgrade",
// "Review the Installation" => "Review the Installation",
// "Upgrade complete" => "Upgrade complete",
// "Installation complete" => "Installation complete",
// "Your database has been configured and Tiki is ready to run" => "Your database has been configured and Tiki is ready to run",
// "If this is your first install, your admin password is <strong>admin</strong>" => "If this is your first install, your admin password is <strong>admin</strong>",
// "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application" => "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application",
// "Upgrade operations executed successfully" => "Upgrade operations executed successfully",
// "Installation operations executed successfully" => "Installation operations executed successfully",
// "SQL queries" => "SQL queries",
// "Database was left unchanged" => "Database was left unchanged",
// "Failed" => "Failed",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages" => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages",
// ".htaccess File" => ".htaccess File",
// "We recommend enabling the <strong>.htaccess</strong> file for your Tiki" => "We recommend enabling the <strong>.htaccess</strong> file for your Tiki",
// "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security" => "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security",
// "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>" => "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>",
// "Configure General Settings" => "Configure General Settings",
// "Complete these fields to configure common, general settings for your site" => "Complete these fields to configure common, general settings for your site",
// "The information you enter here can be changed later" => "The information you enter here can be changed later",
// "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings" => "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings",
// "This will appear in the browser title bar" => "This will appear in the browser title bar",
// "Email sent by your site will use this address" => "Email sent by your site will use this address",
// "Secure Login" => "Secure Login",
// "HTTPS login" => "HTTPS login",
// "Administrator" => "Administrator",
// "Admin email" => "Admin email",
// "This is the email address for your administrator account" => "This is the email address for your administrator account",
// "Enter Your Tiki" => "Enter Your Tiki",
// "The installation is complete" => "The installation is complete",
// "Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>" => "Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>",
// "Installation" => "Installation",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu" => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu",
// "Enter Tiki and Lock Installer" => "Enter Tiki and Lock Installer",
// "Recommended" => "Recommended",
// "Enter Tiki Without Locking Installer" => "Enter Tiki Without Locking Installer",
// "MultiTiki Setup" => "MultiTiki Setup",
// "Default Installation" => "Default Installation",
// "DB OK" => "DB OK",
// "No DB" => "No DB",
// "Adding a new host" => "Adding a new host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Are you upgrading an existing Tiki site" => "Are you upgrading an existing Tiki site",
// "Go directly to the <strong>Install/Upgrade</strong> step" => "Go directly to the <strong>Install/Upgrade</strong> step",
// "Install/Upgrade" => "Install/Upgrade",
// "Restart the installer" => "Restart the installer",
// "Database Connection" => "Database Connection",
// "Reset the Database Connection" => "Reset the Database Connection",
// "Configure the General Settings" => "Configure the General Settings",
// "Tiki Icon" => "Tiki Icon",
// "TikiWiki Project Web Site" => "TikiWiki Project Web Site",
// "Support Forums" => "Support Forums",
// "TikiWiki CMS/Groupware Project" => "TikiWiki CMS/Groupware Project",
// "Powered by TikiWiki" => "Powered by TikiWiki",
// "Clear cached version and refresh cache" => "Clear cached version and refresh cache",
// "configure rules" => "configure rules",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "Last 2 days" => "Last 2 days",
// "Last 3 days" => "Last 3 days",
// "Last 5 days" => "Last 5 days",
// "Last week" => "Last week",
// "Last 2 weeks" => "Last 2 weeks",
// "Last month" => "Last month",
// "Search by Date" => "Search by Date",
// "LastChanges" => "LastChanges",
// "v" => "v",
// "View Submissions" => "View Submissions",
// "ExpireDate" => "ExpireDate",
// "AuthorName" => "AuthorName",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone" => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone",
// "Create banner" => "Create banner",
// "Method" => "Method",
// "Use Dates" => "Use Dates",
// "Max Impressions" => "Max Impressions",
// "Impressions" => "Impressions",
// "Max Clicks" => "Max Clicks",
// "Clicks" => "Clicks",
// "Create New Blog" => "Create New Blog",
// "The cache is used by" => "The cache is used by",
// "Use cache for external pages" => "Use cache for external pages",
// "Approval" => "Approval",
// "Rejected" => "Rejected",
// "Dynamic content system" => "Dynamic content system",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block" => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block" => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Available content blocks" => "Available content blocks",
// "Current Value" => "Current Value",
// "Current ver" => "Current ver",
// "Next ver" => "Next ver",
// "Future vers" => "Future vers",
// "Program" => "Program",
// "Create new FAQ" => "Create new FAQ",
// "Create New FAQ" => "Create New FAQ",
// "Users can suggest questions" => "Users can suggest questions",
// "Available FAQs" => "Available FAQs",
// "Create a File Gallery" => "Create a File Gallery",
// "SlideShow" => "SlideShow",
// "Keep gallery window open" => "Keep gallery window open",
// "optional" => "optional",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "Gallery Images" => "Gallery Images",
// "All games are from" => "All games are from",
// "visit the site for more games and fun" => "visit the site for more games and fun",
// "Flash binary (.swf or .dcr)" => "Flash binary (.swf or .dcr)",
// "Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)",
// "Played" => "Played",
// "If you can't see the game then you need a flash plugin for your browser" => "If you can't see the game then you need a flash plugin for your browser",
// "Edit New Submission" => "Edit New Submission",
// "Survey stats" => "Survey stats",
// "Take Survey" => "Take Survey",
// "users registered" => "users registered",
// "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on" => "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on",
// " {if \$find ne ''}and {/if}starting with" => " {if \$find ne ''}and {/if}starting with",
// "Transcripts" => "Transcripts",
// "Online operators" => "Online operators",
// "Accepted requests" => "Accepted requests",
// "transcripts" => "transcripts",
// "offline" => "offline",
// "Offline operators" => "Offline operators",
// "Add an operator to the system" => "Add an operator to the system",
// "Operators must be tiki users" => "Operators must be tiki users",
// "Set as Operator" => "Set as Operator",
// "Chat started" => "Chat started",
// "Live support:User window" => "Live support:User window",
// "Request live support" => "Request live support",
// "Request support" => "Request support",
// "Open a support ticket instead" => "Open a support ticket instead",
// "Your request is being processed" => "Your request is being processed",
// "cancel request and exit" => "cancel request and exit",
// "cancel request and leave a message" => "cancel request and leave a message",
// "Live support:Console" => "Live support:Console",
// "be online" => "be online",
// "be offline" => "be offline",
// "Support requests" => "Support requests",
// "Requested" => "Requested",
// "Join" => "Join",
// "Support chat transcripts" => "Support chat transcripts",
// "Back to admin" => "Back to admin",
// "operator" => "operator",
// "started" => "started",
// "reason" => "reason",
// "msgs" => "msgs",
// "Transcript" => "Transcript",
// "For security purposes we must periodically validate your email address to allow continued access to this site" => "For security purposes we must periodically validate your email address to allow continued access to this site",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site" => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site",
// "Thank you" => "Thank you",
// "This is an experimental feature" => "This is an experimental feature",
// "Requires" => "Requires",
// "Not Enabled" => "Not Enabled",
// "Mail-in feature" => "Mail-in feature",
// "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/" => "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/",
// "Prefs" => "Prefs",
// "Tikiwiki Mods" => "Tikiwiki Mods",
// "Mods Configuration" => "Mods Configuration",
// "Update remote index" => "Update remote index",
// "Rebuild local list" => "Rebuild local list",
// "Republish all" => "Republish all",
// "Publish all" => "Publish all",
// "Unpublish all" => "Unpublish all",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>" => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>",
// "Tiki \"mods\" are undergoing refurbishment" => "Tiki \"mods\" are undergoing refurbishment",
// "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification" => "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification",
// "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more" => "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more",
// "Attention" => "Attention",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)" => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")" => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")",
// "all types" => "all types",
// "for version" => "for version",
// "all versions" => "all versions",
// "or later" => "or later",
// "No mods found" => "No mods found",
// "Display only this type" => "Display only this type",
// "Unpublish" => "Unpublish",
// "Republish" => "Republish",
// "licence" => "licence",
// "Tikiwiki Mods Configuration" => "Tikiwiki Mods Configuration",
// "Mods Install/uninstall" => "Mods Install/uninstall",
// "Enable Mods providing" => "Enable Mods providing",
// "Mods local directory" => "Mods local directory",
// "Mods remote server" => "Mods remote server",
// "Package Config" => "Package Config",
// "y" => "y",
// "My Articles" => "My Articles",
// "User Articles" => "User Articles",
// "My User Items" => "My User Items",
// "User Items" => "User Items",
// "Unread Messages" => "Unread Messages",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "User Blogs" => "User Blogs",
// "To display the objects you participate" => "To display the objects you participate",
// "Contacts Preferences" => "Contacts Preferences",
// "My Watches" => "My Watches",
// "Assigned items" => "Assigned items",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed" => "Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed",
// "Your email address was removed from the list of subscriptors" => "Your email address was removed from the list of subscriptors",
// "Removal of your email address failed" => "Removal of your email address failed",
// "Subscription confirmed" => "Subscription confirmed",
// "Subscription failed" => "Subscription failed",
// "Subscribe to Newsletter" => "Subscribe to Newsletter",
// "Subscribe to this Newsletter" => "Subscribe to this Newsletter",
// "Select news group" => "Select news group",
// "Back to servers" => "Back to servers",
// "Msgs" => "Msgs",
// "News from" => "News from",
// "Back to groups" => "Back to groups",
// "Save position" => "Save position",
// "Reading article from" => "Reading article from",
// "Back to list of articles" => "Back to list of articles",
// "Newsgroup" => "Newsgroup",
// "Configure news servers" => "Configure news servers",
// "Configure Newsreader" => "Configure Newsreader",
// "configure newsreader server tpl" => "configure newsreader server tpl",
// "Select a news server to browse" => "Select a news server to browse",
// "server" => "server",
// "Read the news" => "Read the news",
// "Add a news server" => "Add a news server",
// "Edit news server" => "Edit news server",
// "News server" => "News server",
// "quota" => "quota",
// "No notes yet" => "No notes yet",
// "Merge selected notes into" => "Merge selected notes into",
// "Reading note" => "Reading note",
// "Object Watches" => "Object Watches",
// "Watching Groups" => "Watching Groups",
// "These permissions override any global permissions or category permissions affecting this object" => "These permissions override any global permissions or category permissions affecting this object",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>" => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>",
// "Current permissions for this object" => "Current permissions for this object",
// "No individual permissions, category permissions apply" => "No individual permissions, category permissions apply",
// "Current permissions for categories that this object belongs to" => "Current permissions for categories that this object belongs to",
// "These permissions do not apply. Special permissions apply" => "These permissions do not apply. Special permissions apply",
// "No category permissions; global permissions apply" => "No category permissions; global permissions apply",
// "No category permissions; special permissions apply" => "No category permissions; special permissions apply",
// "and also to all pages of the sub-structure" => "and also to all pages of the sub-structure",
// "However, no account is associated to the OpenID identifier" => "However, no account is associated to the OpenID identifier",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts" => "Your identity gives you access to multiple user accounts",
// "File (only .gif, .jpg and .png images approximately 45px × 45px)" => "File (only .gif, .jpg and .png images approximately 45px × 45px)",
// "Plugin execution was denied" => "Plugin execution was denied",
// "Plugin execution pending approval" => "Plugin execution pending approval",
// "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected" => "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected",
// "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible" => "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible",
// "You are allowed to" => "You are allowed to",
// "View arguments" => "View arguments",
// "Execute the plugin in preview mode (may be dangerous)" => "Execute the plugin in preview mode (may be dangerous)",
// "Approve the plugin for public execution" => "Approve the plugin for public execution",
// "View Details" => "View Details",
// "This plugin does not contain any arguments" => "This plugin does not contain any arguments",
// "This plugin's body is empty" => "This plugin's body is empty",
// "Any" => "Any",
// "Items found" => "Items found",
// "atts" => "atts",
// "List Attachments" => "List Attachments",
// "Sum" => "Sum",
// "Plugin Approval" => "Plugin Approval",
// "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups" => "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups",
// "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins" => "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins",
// "This page lists the plugins that require validation, the first time they are encountered" => "This page lists the plugins that require validation, the first time they are encountered",
// "Each plugin contains a unique <em>signature</em> that is preserved" => "Each plugin contains a unique <em>signature</em> that is preserved",
// "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list" => "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list",
// "The plugin will automatically be added if it is encountered" => "The plugin will automatically be added if it is encountered",
// "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin" => "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin",
// "For security, you should review each plugin to ensure it is safe to approve" => "For security, you should review each plugin to ensure it is safe to approve",
// "Added By" => "Added By",
// "Signature" => "Signature",
// "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "Approve all pending plugins" => "Approve all pending plugins",
// "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins" => "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins",
// "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe" => "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe",
// "No plugins pending approval" => "No plugins pending approval",
// "View Results" => "View Results",
// "Vote poll" => "Vote poll",
// "Other Polls" => "Other Polls",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Edit Poll" => "Edit Poll",
// "Find the poll" => "Find the poll",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Vote range displayed" => "Vote range displayed",
// "All votes with no span consideration" => "All votes with no span consideration",
// "All votes with span consideration" => "All votes with span consideration",
// "All votes" => "All votes",
// "List Votes" => "List Votes",
// "Permission denied. You do not have permission to read complete articles" => "Permission denied. You do not have permission to read complete articles",
// "The original document is available at" => "The original document is available at",
// "Print multiple pages" => "Print multiple pages",
// "randomly selected questions" => "randomly selected questions",
// "Test-time Options" => "Test-time Options",
// "Limit questions displayed per page to " => "Limit questions displayed per page to ",
// "&nbsp question(s)" => "&nbsp question(s)",
// "Impose a time limit of " => "Impose a time limit of ",
// "Allow students to store partial results and return to quiz" => "Allow students to store partial results and return to quiz",
// "Allow students to retake this quiz " => "Allow students to retake this quiz ",
// "Grading and Feedback" => "Grading and Feedback",
// "Grading method " => "Grading method ",
// "Show students their score " => "Show students their score ",
// "Show students the correct answers " => "Show students the correct answers ",
// "Publish statistics " => "Publish statistics ",
// "Extra Options" => "Extra Options",
// "Solicit additional questions from students" => "Solicit additional questions from students",
// "Link quiz to forum named: " => "Link quiz to forum named: ",
// "Prologue" => "Prologue",
// "Epilogue" => "Epilogue",
// "Quiz result stats" => "Quiz result stats",
// "Time" => "Time",
// "User answers" => "User answers",
// "Stats for quizzes" => "Stats for quizzes",
// "taken" => "taken",
// "Av score" => "Av score",
// "Av time" => "Av time",
// "Stats for quiz" => "Stats for quiz",
// "Clear Stats" => "Clear Stats",
// "time taken" => "time taken",
// "P/F" => "P/F",
// "Passed" => "Passed",
// "Stats for this quiz Questions " => "Stats for this quiz Questions ",
// "Rank" => "Rank",
// "List all articles of this same topic" => "List all articles of this same topic",
// "Prefix the checked" => "Prefix the checked",
// "Postfix the checked" => "Postfix the checked",
// "Referer stats" => "Referer stats",
// "Use your email as login" => "Use your email as login",
// "Minimum {\$prefs.min_username_length} characters long" => "Minimum {\$prefs.min_username_length} characters long",
// "Passcode to register" => "Passcode to register",
// "Not your password" => "Not your password",
// "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}" => "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}",
// "Generate a\tpassword" => "Generate a\tpassword",
// "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites" => "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites",
// "Registering does not give you any benefits except one more link to your site" => "Registering does not give you any benefits except one more link to your site",
// "You don't get any emails, we don't sell the data about your site" => "You don't get any emails, we don't sell the data about your site",
// "Registering is just for us to get an overview of Tiki's usage" => "Registering is just for us to get an overview of Tiki's usage",
// "Enter your email" => "Enter your email",
// "Back to page" => "Back to page",
// "Replicate" => "Replicate",
// "Slave" => "Slave",
// "Master" => "Master",
// "Operations" => "Operations",
// "Operations Log" => "Operations Log",
// "to version" => "to version",
// "\$name" => "\$name",
// "Blogs Post" => "Blogs Post",
// "Date Search" => "Date Search",
// "All dates" => "All dates",
// "Calendar Items" => "Calendar Items",
// "octets" => "octets",
// "Apply content template" => "Apply content template",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "Attached Files" => "Attached Files",
// "remove" => "remove",
// "To add a file, click here" => "To add a file, click here",
// "Transmission results" => "Transmission results",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "Create a sheet" => "Create a sheet",
// "Edit this sheet" => "Edit this sheet",
// "Create New Sheet" => "Create New Sheet",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
// "Header Rows" => "Header Rows",
// "Footer Rows" => "Footer Rows",
// "Create new Sheet" => "Create new Sheet",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Available Sheets" => "Available Sheets",
// "Change shoutbox general settings" => "Change shoutbox general settings",
// "auto-link urls" => "auto-link urls",
// "Post or edit a message" => "Post or edit a message",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page" => "the approved version of this page",
// "Viewing of changes since last approval is possible only after first approval" => "Viewing of changes since last approval is possible only after first approval",
// "Approve changes" => "Approve changes",
// "Latest changes will be synchronized after approval" => "Latest changes will be synchronized after approval",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time" => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time",
// "Content may be out of date" => "Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages",
// "TOC" => "TOC",
// "page: %0/%1" => "page: %0/%1",
// "Page last modified on %0 by %1" => "Page last modified on %0 by %1",
// "Created by %0" => "Created by %0",
// "Last Modification: %0 by %1" => "Last Modification: %0 by %1",
// "big grin" => "big grin",
// "confused" => "confused",
// "cool" => "cool",
// "cry" => "cry",
// "eek" => "eek",
// "evil" => "evil",
// "lol" => "lol",
// "mr green" => "mr green",
// "razz" => "razz",
// "redface" => "redface",
// "rolleyes" => "rolleyes",
// "smile" => "smile",
// "surprised" => "surprised",
// "twisted" => "twisted",
// "arrow" => "arrow",
// "santa" => "santa",
// "You will not see the latest queries" => "You will not see the latest queries",
// "Clean" => "Clean",
// "Params" => "Params",
// "Date of first pageview" => "Date of first pageview",
// "Days since first pageview" => "Days since first pageview",
// "Daily Usage" => "Daily Usage",
// "Stats for surveys" => "Stats for surveys",
// "Last taken" => "Last taken",
// "Stats for survey" => "Stats for survey",
// "Tiki Logs" => "Tiki Logs",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "Time Left" => "Time Left",
// "Send Answers" => "Send Answers",
// "Summary mode" => "Summary mode",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Recorded Links" => "Recorded Links",
// "Request" => "Request",
// "Element to compare (Xpath expression)" => "Element to compare (Xpath expression)",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "TikiTests List" => "TikiTests List",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "PECL HTTP extension present" => "PECL HTTP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible" => "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "TikiTests Record Configuration" => "TikiTests Record Configuration",
// "Start Recording Test" => "Start Recording Test",
// "TikiTests Replay Configuration" => "TikiTests Replay Configuration",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "Theme Control Center: Categories" => "Theme Control Center: Categories",
// "Theme is selected as follows" => "Theme is selected as follows",
// "If a theme is assigned to the individual object that theme is used" => "If a theme is assigned to the individual object that theme is used",
// "If not then if a theme is assigned to the object's category that theme is used" => "If not then if a theme is assigned to the object's category that theme is used",
// "If not then a theme for the section is used" => "If not then a theme for the section is used",
// "If none of the above was selected the user theme is used" => "If none of the above was selected the user theme is used",
// "Finally if the user didn't select a theme the default theme is used" => "Finally if the user didn't select a theme the default theme is used",
// "Control by Objects" => "Control by Objects",
// "Control by Sections" => "Control by Sections",
// "Theme Control Center: Objects" => "Theme Control Center: Objects",
// "Control by Categories" => "Control by Categories",
// "Theme Control Center: Sections" => "Theme Control Center: Sections",
// "The following file was successfully uploaded" => "The following file was successfully uploaded",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "Unzip zip files" => "Unzip zip files",
// "Add File" => "Add File",
// "Maximum file size is limited to" => "Maximum file size is limited to",
// "Uploading file.." => "Uploading file..",
// "No File to Upload.." => "No File to Upload..",
// "or upload a local image from your disk" => "or upload a local image from your disk",
// "Batch Upload" => "Batch Upload",
// "The column is disabled" => "The column is disabled",
// "(non public)" => "(non public)",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Request friendship from this user" => "Request friendship from this user",
// "Forum comments" => "Forum comments",
// "Toggle options" => "Toggle options",
// "Toggle" => "Toggle",
// "Personal Information" => "Personal Information",
// "Male" => "Male",
// "Female" => "Female",
// "Use Google Map locator" => "Use Google Map locator",
// "Your personal tracker information" => "Your personal tracker information",
// "View extra information" => "View extra information",
// "Is email public? (uses scrambling to prevent spam)" => "Is email public? (uses scrambling to prevent spam)",
// "Unavailable - please set your e-mail below" => "Unavailable - please set your e-mail below",
// "Does your mail reader need a special charset" => "Does your mail reader need a special charset",
// "Your preferred language" => "Your preferred language",
// "Can you read more languages" => "Can you read more languages",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
// "Select language.." => "Select language..",
// "Displays users' info tooltip on mouseover for every user who allows his information to be public" => "Displays users' info tooltip on mouseover for every user who allows his information to be public",
// "My user items" => "My user items",
// "My level" => "My level",
// "Account Information" => "Account Information",
// "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password",
// "Email address" => "Email address",
// "Confirm new password" => "Confirm new password",
// "Change administrative info" => "Change administrative info",
// "New task" => "New task",
// "Task list" => "Task list",
// "Admin mode off" => "Admin mode off",
// "Admin mode on" => "Admin mode on",
// "Task help" => "Task help",
// "Empty Trash" => "Empty Trash",
// "Received task" => "Received task",
// "You received this task, please read and execute it" => "You received this task, please read and execute it",
// "Send task" => "Send task",
// "You send this task to a other user" => "You send this task to a other user",
// "Shared task" => "Shared task",
// "This task is public to a special group" => "This task is public to a special group",
// "Accepted by Task User and Creator" => "Accepted by Task User and Creator",
// "Accepted User and Creator" => "Accepted User and Creator",
// "Task is accepted by user and creator" => "Task is accepted by user and creator",
// "Not Accepted by One User" => "Not Accepted by One User",
// "Not Accepted User" => "Not Accepted User",
// "Task is rejected by one user" => "Task is rejected by one user",
// "Waiting for Me" => "Waiting for Me",
// "Task is not accepted by you, read the task and accept or reject it" => "Task is not accepted by you, read the task and accept or reject it",
// "Waiting for Other User" => "Waiting for Other User",
// "Task is not accepted/rejected by other user" => "Task is not accepted/rejected by other user",
// "Admin Mode" => "Admin Mode",
// "Task saved" => "Task saved",
// "View Task" => "View Task",
// "Open a new task" => "Open a new task",
// "taskId" => "taskId",
// "Task user" => "Task user",
// "Only the creator can delete this task" => "Only the creator can delete this task",
// "Use start date and time" => "Use start date and time",
// "Use end date and time" => "Use end date and time",
// "Open / In Process" => "Open / In Process",
// "Waiting / Not Started" => "Waiting / Not Started",
// "Percentage completed" => "Percentage completed",
// "Waiting" => "Waiting",
// "Shared for Group" => "Shared for Group",
// "Accepted by User" => "Accepted by User",
// "No / Rejected" => "No / Rejected",
// "Accepted by Creator" => "Accepted by Creator",
// "This message will be send to users if you are makeing changes of assigned tasks" => "This message will be send to users if you are makeing changes of assigned tasks",
// "Send message with changes" => "Send message with changes",
// "Modified by" => "Modified by",
// "Marked as deleted" => "Marked as deleted",
// "Inform task user by email" => "Inform task user by email",
// "You can only view this task" => "You can only view this task",
// "%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
// "No tasks entered" => "No tasks entered",
// "Select One" => "Select One",
// "Undo Trash" => "Undo Trash",
// "Received" => "Received",
// "Submitted" => "Submitted",
// "Shared" => "Shared",
// "completed (100%)" => "completed (100%)",
// "Public for group" => "Public for group",
// "You are not allowed to remove this notification " => "You are not allowed to remove this notification ",
// "Select event type" => "Select event type",
// "All watched events" => "All watched events",
// "A user edited an article" => "A user edited an article",
// "A user deleted an article" => "A user deleted an article",
// "no limit for admin" => "no limit for admin",
// "May need to refresh twice to see changes" => "May need to refresh twice to see changes",
// "Add top level bookmarks to menu" => "Add top level bookmarks to menu",
// "replace window" => "replace window",
// "Pos" => "Pos",
// "User_versions_for" => "User_versions_for",
// "Insert Row" => "Insert Row",
// "Insert Column" => "Insert Column",
// "Merge Cells" => "Merge Cells",
// "Restore Cells" => "Restore Cells",
// "Copy Calculation" => "Copy Calculation",
// "Format Cell" => "Format Cell",
// "Before" => "Before",
// "After" => "After",
// "expires" => "expires",
// "No articles yet" => "No articles yet",
// "Add an article" => "Add an article",
// "Banner stats" => "Banner stats",
// "Create new banner" => "Create new banner",
// "Banner Information" => "Banner Information",
// "Click ratio" => "Click ratio",
// "Banner raw data" => "Banner raw data",
// "This is a cached version of the page" => "This is a cached version of the page",
// "Click here to view the Google cache of the page instead" => "Click here to view the Google cache of the page instead",
// "Edit Items" => "Edit Items",
// "List Charts" => "List Charts",
// "Last Chart" => "Last Chart",
// "Previous Chart" => "Previous Chart",
// "Chart created" => "Chart created",
// "Next Chart" => "Next Chart",
// "Pre" => "Pre",
// "Permanency" => "Permanency",
// "chg" => "chg",
// "Avg" => "Avg",
// "info/vote" => "info/vote",
// "Next chart will be generated on" => "Next chart will be generated on",
// "View or vote items not listed in the chart" => "View or vote items not listed in the chart",
// "Select something to vote on" => "Select something to vote on",
// "Item information" => "Item information",
// "Dif" => "Dif",
// "Best Position" => "Best Position",
// "Vote this item" => "Vote this item",
// "Highest" => "Highest",
// "There are no questions in this FAQ" => "There are no questions in this FAQ",
// "Answers" => "Answers",
// "Q" => "Q",
// "A" => "A",
// "Add Suggestion" => "Add Suggestion",
// "Forum List" => "Forum List",
// "Edit Forum" => "Edit Forum",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "Group Monitor Topics of this Forum" => "Group Monitor Topics of this Forum",
// "Group Monitor Topics and Threads of this Forum" => "Group Monitor Topics and Threads of this Forum",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Summary" => "Summary",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Moderator Actions" => "Moderator Actions",
// "Unlock Selected Topics" => "Unlock Selected Topics",
// "Delete Selected Topics" => "Delete Selected Topics",
// "Merge" => "Merge",
// "Merge Selected Topics" => "Merge Selected Topics",
// "Reported Messages" => "Reported Messages",
// "Queued Messages" => "Queued Messages",
// "Merge into topic" => "Merge into topic",
// "Emot" => "Emot",
// "pts" => "pts",
// "Announce" => "Announce",
// "Hot" => "Hot",
// "Forum Lock" => "Forum Lock",
// "Unarchive" => "Unarchive",
// "No topics yet" => "No topics yet",
// "Filter Posts" => "Filter Posts",
// "Jump to forum" => "Jump to forum",
// "Posts Filtering" => "Posts Filtering",
// "Last post date" => "Last post date",
// "Last hour" => "Last hour",
// "Last 24 hours" => "Last 24 hours",
// "Last 48 hours" => "Last 48 hours",
// "Show archived posts" => "Show archived posts",
// "Containing posts by" => "Containing posts by",
// "Me" => "Me",
// "Posts with no replies" => "Posts with no replies",
// "Archived" => "Archived",
// "Topic List" => "Topic List",
// "The post has been reported and will be reviewed by a moderator" => "The post has been reported and will be reviewed by a moderator",
// "prev topic" => "prev topic",
// "next topic" => "next topic",
// "Print this page only" => "Print this page only",
// "Print all pages" => "Print all pages",
// "Stop Monitor" => "Stop Monitor",
// "Insert New Item" => "Insert New Item",
// "Edit Fields" => "Edit Fields",
// "Tracker Items" => "Tracker Items",
// "Pending" => "Pending",
// "View inserted item" => "View inserted item",
// "Insert new item" => "Insert new item",
// "Tracker Item" => "Tracker Item",
// "View Item" => "View Item",
// "Filter Tracker Items" => "Filter Tracker Items",
// "Items list" => "Items list",
// "Special Operations" => "Special Operations",
// "There was an error connecting to your e-mail account" => "There was an error connecting to your e-mail account",
// "Add a new" => "Add a new",
// "Edit this" => "Edit this",
// " mail account" => " mail account",
// "Group (shared mail inbox) or private" => "Group (shared mail inbox) or private",
// "This will be a group mail account" => "This will be a group mail account",
// "This will be a personal mail account" => "This will be a personal mail account",
// "Auto-refresh page time" => "Auto-refresh page time",
// "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission" => "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission",
// "Personal e-mail accounts" => "Personal e-mail accounts",
// "Click to activate" => "Click to activate",
// "This is the active account" => "This is the active account",
// "Group e-mail accounts" => "Group e-mail accounts",
// "Show Unread" => "Show Unread",
// "Show Flagged" => "Show Flagged",
// "Refresh now" => "Refresh now",
// "Group messages" => "Group messages",
// "unFlagged" => "unFlagged",
// "Clip" => "Clip",
// "Back To Mailbox" => "Back To Mailbox",
// "Full Headers" => "Full Headers",
// "Normal Headers" => "Normal Headers",
// "Forward" => "Forward",
// "Select from address book" => "Select from address book",
// "Use HTML mail" => "Use HTML mail",
// "The following addresses are not in your address book" => "The following addresses are not in your address book",
// "Add Contacts" => "Add Contacts",
// "Attachment 1" => "Attachment 1",
// "Attachment 2" => "Attachment 2",
// "Attachment 3" => "Attachment 3",
// "Address book" => "Address book",
// "Group Monitor on Structure" => "Group Monitor on Structure",
// "Latitude" => "Latitude",
// "Longitude" => "Longitude",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Word Count" => "Word Count",
// "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator" => "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator",
// "Number of voices" => "Number of voices",
// "Your vote" => "Your vote",
// "Click to vote for this value" => "Click to vote for this value",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled" => "Google Maps is not enabled",
// "The main text of this page is available in the following languages" => "The main text of this page is available in the following languages",
// "Use this thread to discuss the page" => "Use this thread to discuss the page",
// "Missing or incorrect trackerId parameter for the plugin" => "Missing or incorrect trackerId parameter for the plugin",
// "list" => "list",
// "Reinstall" => "Reinstall",
// "Undecided" => "Undecided",
// "Subscribe to a group" => "Subscribe to a group",
// "Toggle display" => "Toggle display",
// "Save the page as a partial translation" => "Save the page as a partial translation",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation" => "Save the page as a completed translation",
// "Complete Translation" => "Complete Translation",
// "Save Minor Edit" => "Save Minor Edit",
// "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "%s set" => "%s set",
// "%s unset" => "%s unset",
// "Administration" => "Administration",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Enable/disable Tiki features here, but configure them elsewhere" => "Enable/disable Tiki features here, but configure them elsewhere",
// "General preferences and settings" => "General preferences and settings",
// "User registration, login and authentication" => "User registration, login and authentication",
// "Article/CMS settings" => "Article/CMS settings",
// "Poll comments settings" => "Poll comments settings",
// "Configuration options for all blogs on your site" => "Configuration options for all blogs on your site",
// "Forums settings" => "Forums settings",
// "FAQ comments settings" => "FAQ comments settings",
// "Trackers settings" => "Trackers settings",
// "RSS feeds" => "RSS feeds",
// "Directory settings" => "Directory settings",
// "Maps configuration" => "Maps configuration",
// "Meta Tags settings" => "Meta Tags settings",
// "Search settings" => "Search settings",
// "Score settings" => "Score settings",
// "Community settings" => "Community settings",
// "Calendar settings" => "Calendar settings",
// "Intertiki settings" => "Intertiki settings",
// "Look & Feel" => "Look & Feel",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Current version is up to date : <b>%s</b>" => "Current version is up to date : <b>%s</b>",
// "A new %s  major release branch is available" => "A new %s  major release branch is available",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header" => "The file does not have the required header",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "No chart indicated" => "No chart indicated",
// "You have to provide a hotword and a URL" => "You have to provide a hotword and a URL",
// "moved %d images, %d errors occured" => "moved %d images, %d errors occured",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Test Image" => "Test Image",
// "Your admin password has been changed" => "Your admin password has been changed",
// "You cannot have a blank password" => "You cannot have a blank password",
// "All Fields except gdaltindex must be filled" => "All Fields except gdaltindex must be filled",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
// "If you use apache, you need a .htaccess file to have this feature working" => "If you use apache, you need a .htaccess file to have this feature working",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Tag already exists" => "Tag already exists",
// "Tag not found" => "Tag not found",
// "Repository name can't be an empty" => "Repository name can't be an empty",
// "Requested action is not supported on repository" => "Requested action is not supported on repository",
// "No repository" => "No repository",
// "Search is mandatory field" => "Search is mandatory field",
// "File not found " => "File not found ",
// "Requested action in not supported on repository" => "Requested action in not supported on repository",
// "Non-existent link" => "Non-existent link",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
// "Frequency should be a positive integer" => "Frequency should be a positive integer",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
// "No menu indicated" => "No menu indicated",
// "Unassign module" => "Unassign module",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "No newsletter indicated" => "No newsletter indicated",
// "No poll indicated" => "No poll indicated",
// "register_globals should be off by default. See the php manual for details" => "register_globals should be off by default. See the php manual for details",
// "session.use_trans_sid should be off by default. See the php manual for details" => "session.use_trans_sid should be off by default. See the php manual for details",
// "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser",
// "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config" => "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config",
// "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them",
// "risky" => "risky",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off" => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off",
// "The Path to store files in the filegallery should be outside the tiki root directory" => "The Path to store files in the filegallery should be outside the tiki root directory",
// "The Path to store files in the imagegallery should be outside the tiki root directory" => "The Path to store files in the imagegallery should be outside the tiki root directory",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code" => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code",
// "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html" => "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html",
// "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement" => "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement",
// "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory" => "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory",
// "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts" => "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts",
// "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)" => "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)",
// "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users" => "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users",
// "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users" => "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users",
// "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands" => "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous" => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous",
// "This is a modified File. Cannot check version. Check if it is dangerous" => "This is a modified File. Cannot check version. Check if it is dangerous",
// "No survey indicated" => "No survey indicated",
// "You don't have permission to use this feature" => "You don't have permission to use this feature",
// "Are you sure you want to remove this topic" => "Are you sure you want to remove this topic",
// "Are you sure you want to remove this topic AND all the articles related" => "Are you sure you want to remove this topic AND all the articles related",
// "No tracker indicated" => "No tracker indicated",
// "Tracker does not allow attachments" => "Tracker does not allow attachments",
// "The description is mandatory as it is used as mail subject" => "The description is mandatory as it is used as mail subject",
// "No records were found. Check the file please" => "No records were found. Check the file please",
// "User does not exist on master" => "User does not exist on master",
// "Created account %s <%s>" => "Created account %s <%s>",
// "Assigned %s in group %s" => "Assigned %s in group %s",
// "User %s already exists" => "User %s already exists",
// "User login contains invalid characters" => "User login contains invalid characters",
// "New %s created with %s %s" => "New %s created with %s %s",
// "Impossible to create new %s with %s %s" => "Impossible to create new %s with %s %s",
// "%s %s successfully deleted" => "%s %s successfully deleted",
// "Deleted account %s" => "Deleted account %s",
// "%s %s removed from %s %s" => "%s %s removed from %s %s",
// "%s <b>%s</b> successfully deleted" => "%s <b>%s</b> successfully deleted",
// "%s <b>%s</b> assigned to %s <b>%s</b>" => "%s <b>%s</b> assigned to %s <b>%s</b>",
// "%s <b>%s</b> removed from %s <b>%s</b>" => "%s <b>%s</b> removed from %s <b>%s</b>",
// "group <b>%s</b> set as the default group of user <b>%s</b>" => "group <b>%s</b> set as the default group of user <b>%s</b>",
// "Login contains invalid characters" => "Login contains invalid characters",
// "%s changed from %s to %s" => "%s changed from %s to %s",
// "Impossible to change %s from %s to %s" => "Impossible to change %s from %s to %s",
// "%s modified successfully" => "%s modified successfully",
// "password" => "password",
// "%s modification failed" => "%s modification failed",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "rss feed disabled" => "rss feed disabled",
// "Tiki RSS feed for articles" => "Tiki RSS feed for articles",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "Unknown group" => "Unknown group",
// "Group doesn't exist" => "Group doesn't exist",
// "You have to indicate a group" => "You have to indicate a group",
// "This group is invalid" => "This group is invalid",
// "Permission denied you cannot view backlinks for this page" => "Permission denied you cannot view backlinks for this page",
// "The page cannot be found" => "The page cannot be found",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s" => "Could not read image %s",
// "Image %s upload failed" => "Image %s upload failed",
// "Image %s uploaded successfully" => "Image %s uploaded successfully",
// "Image %s removed from Batch directory" => "Image %s removed from Batch directory",
// "Impossible to remove image %s from Batch directory" => "Impossible to remove image %s from Batch directory",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images" => "Incorrect directory chosen for batch upload of images",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator" => "Please contact the website administrator",
// "Invalid directory name" => "Invalid directory name",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s" => "Could not read file %s",
// "Could not write to file %s" => "Could not write to file %s",
// "File %s upload failed" => "File %s upload failed",
// "File %s removed from Batch directory" => "File %s removed from Batch directory",
// "Impossible to remove file %s from Batch directory" => "Impossible to remove file %s from Batch directory",
// "Incorrect directory chosen for batch upload of files" => "Incorrect directory chosen for batch upload of files",
// "You can't post in any blog maybe you have to create a blog first" => "You can't post in any blog maybe you have to create a blog first",
// "Permission denied you cannot post" => "Permission denied you cannot post",
// "Permission denied you cannot edit this post" => "Permission denied you cannot edit this post",
// "No blogId specified" => "No blogId specified",
// "Tiki RSS feed for weblogs" => "Tiki RSS feed for weblogs",
// "Last posts to weblogs" => "Last posts to weblogs",
// "TOP" => "TOP",
// "You must clear your browser cache" => "You must clear your browser cache",
// "Permission denied you cannot access this gallery" => "Permission denied you cannot access this gallery",
// "No gallery indicated" => "No gallery indicated",
// "Permission denied you can not view this section" => "Permission denied you can not view this section",
// "Permission denied you cannot remove images from this gallery" => "Permission denied you cannot remove images from this gallery",
// "Permission denied you cannot rebuild thumbnails in this gallery" => "Permission denied you cannot rebuild thumbnails in this gallery",
// "Permission denied you cannot rotate images in this gallery" => "Permission denied you cannot rotate images in this gallery",
// "No image indicated" => "No image indicated",
// "Permission denied you cannot move images from this gallery" => "Permission denied you cannot move images from this gallery",
// "Permission denied you cannot view the calendar" => "Permission denied you cannot view the calendar",
// "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>" => "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>",
// "event without name" => "event without name",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string",
// "%H:%M %Z" => "%H:%M %Z",
// "Mo" => "Mo",
// "Tu" => "Tu",
// "We" => "We",
// "Th" => "Th",
// "Fr" => "Fr",
// "Sa" => "Sa",
// "Su" => "Su",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "No category indicated" => "No category indicated",
// "Permission denied; you cannot assign permissions for this category" => "Permission denied; you cannot assign permissions for this category",
// "Invalid request. Expecting channels array" => "Invalid request. Expecting channels array",
// "Missing channel name" => "Missing channel name",
// "Authentication required" => "Authentication required",
// "One of the requested channels cannot be requested. It does not exist or permission is denied" => "One of the requested channels cannot be requested. It does not exist or permission is denied",
// "One of the install profiles could not be obtained" => "One of the install profiles could not be obtained",
// "Problem. Try to log in again to receive new confirmation instructions" => "Problem. Try to log in again to receive new confirmation instructions",
// "ERROR: you must include a subject or a message at least" => "ERROR: you must include a subject or a message at least",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
// "Tiki RSS feed for directory sites" => "Tiki RSS feed for directory sites",
// "URL already added to the directory. Duplicate site? " => "URL already added to the directory. Duplicate site? ",
// "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. ",
// "Must select a category. " => "Must select a category. ",
// "Must enter a name to add a site" => "Must enter a name to add a site",
// "Must enter a url to add a site" => "Must enter a url to add a site",
// "URL already added to the directory. Duplicate site" => "URL already added to the directory. Duplicate site",
// "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory",
// "Must select a category" => "Must select a category",
// "No site indicated" => "No site indicated",
// "No parent specified" => "No parent specified",
// "Last sites of directory \".\$rc[\"name\"].\" " => "Last sites of directory \".\$rc[\"name\"].\" ",
// "You cannot download this file right now. Your score is low or file limit was reached" => "You cannot download this file right now. Your score is low or file limit was reached",
// "Error : The file %s doesn't exist" => "Error : The file %s doesn't exist",
// "The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
// "You do not have permissions to edit banners" => "You do not have permissions to edit banners",
// "Banner not found" => "Banner not found",
// "You do not have permission to edit this banner" => "You do not have permission to edit this banner",
// "Permission denied you cannot create or edit blogs" => "Permission denied you cannot create or edit blogs",
// "Permission denied you cannot edit this blog" => "Permission denied you cannot edit this blog",
// "You do not have permission to write the style sheet" => "You do not have permission to write the style sheet",
// "Invalid request to edit an image" => "Invalid request to edit an image",
// "Permission denied you cannot edit images" => "Permission denied you cannot edit images",
// "Permission denied you can edit images but not in this gallery" => "Permission denied you can edit images but not in this gallery",
// "Failed to edit the image" => "Failed to edit the image",
// "Permission denied to use this feature" => "Permission denied to use this feature",
// "Shortname must be 2 Characters" => "Shortname must be 2 Characters",
// "You must provide a longname" => "You must provide a longname",
// "Language created" => "Language created",
// "No content id indicated" => "No content id indicated",
// "No question indicated" => "No question indicated",
// "No quiz indicated" => "No quiz indicated",
// "No structure indicated" => "No structure indicated",
// "Invalid structure_id or page_ref_id" => "Invalid structure_id or page_ref_id",
// "Permission denied you cannot send submissions" => "Permission denied you cannot send submissions",
// "Permission denied you cannot edit submissions" => "Permission denied you cannot edit submissions",
// "You have to create a topic first" => "You have to create a topic first",
// "You do not have permission to do that" => "You do not have permission to do that",
// "You do not have permission to write the template" => "You do not have permission to write the template",
// "You do not have permission to read the template" => "You do not have permission to read the template",
// "No topic id specified" => "No topic id specified",
// "Invalid topic id specified" => "Invalid topic id specified",
// "Translation in progress" => "Translation in progress",
// "No object indicated" => "No object indicated",
// "Page is a staging copy. Translation must begin from the approved copy" => "Page is a staging copy. Translation must begin from the approved copy",
// "No type indicated" => "No type indicated",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "page imported" => "page imported",
// "created from import" => "created from import",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "Can't parse HTML data - no grammar file" => "Can't parse HTML data - no grammar file",
// "Can't import remote HTML page" => "Can't import remote HTML page",
// "The translation set already contains a page in this language" => "The translation set already contains a page in this language",
// "No questions group indicated" => "No questions group indicated",
// "Form error - no import method selected for some reason" => "Form error - no import method selected for some reason",
// "Form error - no server-side filename entered for selected import method" => "Form error - no server-side filename entered for selected import method",
// "No forum indicated" => "No forum indicated",
// "Last replied forum topics" => "Last replied forum topics",
// "No forumId specified" => "No forumId specified",
// "Tiki RSS feed for forum: " => "Tiki RSS feed for forum: ",
// "Tiki RSS feed for forums" => "Tiki RSS feed for forums",
// "Last topics in forums" => "Last topics in forums",
// "Not supported yet" => "Not supported yet",
// "Accepted friendship request from %s" => "Accepted friendship request from %s",
// "Refused friendship request from %s" => "Refused friendship request from %s",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "Broke friendship with %s" => "Broke friendship with %s",
// "I have broken our friendship" => "I have broken our friendship",
// "You must be logged in to use this feature" => "You must be logged in to use this feature",
// "Friendship request sent to %s" => "Friendship request sent to %s",
// "You're already friend of %s" => "You're already friend of %s",
// "I have accepted your friendship request" => "I have accepted your friendship request",
// "I have refused your friendship request" => "I have refused your friendship request",
// "I have canceled my friendship request" => "I have canceled my friendship request",
// "No process indicated" => "No process indicated",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "Activity name already exists" => "Activity name already exists",
// "indicates if the process is active. Invalid processes cant be active" => "indicates if the process is active. Invalid processes cant be active",
// "No instance indicated" => "No instance indicated",
// "No activity indicated" => "No activity indicated",
// "The process name already exists" => "The process name already exists",
// "Process already exists" => "Process already exists",
// "Invalid source path" => "Invalid source path",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "You cant execute this activity" => "You cant execute this activity",
// "You couldn't abort a instance" => "You couldn't abort a instance",
// "You couldn't exception a instance" => "You couldn't exception a instance",
// "No user indicated" => "No user indicated",
// "No title indicated" => "No title indicated",
// "No comment indicated" => "No comment indicated",
// "No date indicated" => "No date indicated",
// "No item indicated" => "No item indicated",
// "Permission denied you cannot create galleries and so you cant edit them" => "Permission denied you cannot create galleries and so you cant edit them",
// "Permission denied you cannot edit this gallery" => "Permission denied you cannot edit this gallery",
// "Permission denied you cannot remove this gallery" => "Permission denied you cannot remove this gallery",
// "Permission denied you cannot make the map of this gallery" => "Permission denied you cannot make the map of this gallery",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "No valid renderer found. GD or PDFLib required" => "No valid renderer found. GD or PDFLib required",
// "No sheet specified" => "No sheet specified",
// "You must select a renderer" => "You must select a renderer",
// "Invalid Series for current graphic" => "Invalid Series for current graphic",
// "Tiki RSS feed for image galleries" => "Tiki RSS feed for image galleries",
// "Last images uploaded to the image galleries" => "Last images uploaded to the image galleries",
// "Tiki RSS feed for the image gallery: " => "Tiki RSS feed for the image gallery: ",
// "Only the administrator can upload language files" => "Only the administrator can upload language files",
// "overwriting old page" => "overwriting old page",
// "updated from structured text import" => "updated from structured text import",
// "page created" => "page created",
// "created from structured text import" => "created from structured text import",
// "Operations executed successfully" => "Operations executed successfully",
// "No name indicated for wiki page" => "No name indicated for wiki page",
// "Page saved (version %d)" => "Page saved (version %d)",
// "No repository given" => "No repository given",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "Permission denied you cannot view pages like this page" => "Permission denied you cannot view pages like this page",
// "Permission denied you cannot remove articles" => "Permission denied you cannot remove articles",
// "Permission denied you cannot remove banners" => "Permission denied you cannot remove banners",
// "Permission denied you cannot remove this blog" => "Permission denied you cannot remove this blog",
// "Delete comments" => "Delete comments",
// "Approved Status" => "Approved Status",
// "Queued" => "Queued",
// "Non-existent gallery" => "Non-existent gallery",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Warning: Empty file" => "Warning: Empty file",
// "Please re-upload your file" => "Please re-upload your file",
// "Could not upload the file" => "Could not upload the file",
// "Could not find the file requested" => "Could not find the file requested",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "The game file must have .swf or .dcr extension" => "The game file must have .swf or .dcr extension",
// "The thumbnail name must be" => "The thumbnail name must be",
// "Please supply both files" => "Please supply both files",
// "You cannot admin blogs" => "You cannot admin blogs",
// "Permission denied you cannot remove submissions" => "Permission denied you cannot remove submissions",
// "Permission denied you cannot approve submissions" => "Permission denied you cannot approve submissions",
// "You have to enable cookies to be able to login to this site" => "You have to enable cookies to be able to login to this site",
// "Unable to contact remote server" => "Unable to contact remote server",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "More than %d unsuccessful login attempts have been made" => "More than %d unsuccessful login attempts have been made",
// "An email has been sent to you with the instructions to follow" => "An email has been sent to you with the instructions to follow",
// "Your default nickname is already in use. A new one has to be selected" => "Your default nickname is already in use. A new one has to be selected",
// "The selected account is not associated with your identity" => "The selected account is not associated with your identity",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "Sorry, you can't use this feature" => "Sorry, you can't use this feature",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile" => "An error as occured with the mapfile",
// "edit" => "edit",
// "Please create a directory named '.\$prefs['map_path'].' to hold your map files" => "Please create a directory named '.\$prefs['map_path'].' to hold your map files",
// "You do not have permissions to view the maps" => "You do not have permissions to view the maps",
// "Maps feature is not correctly setup : Maps path is missing" => "Maps feature is not correctly setup : Maps path is missing",
// "mapfile name incorrect" => "mapfile name incorrect",
// "This mapfile already exists" => "This mapfile already exists",
// "You do not have permission to write to the mapfile" => "You do not have permission to write to the mapfile",
// "You do not have permission to delete the mapfile" => "You do not have permission to delete the mapfile",
// "I could not make a copy" => "I could not make a copy",
// "You do not have permission to read the mapfile" => "You do not have permission to read the mapfile",
// "map edit" => "map edit",
// "You dont have permission to do that" => "You dont have permission to do that",
// "Tiki RSS feed for maps" => "Tiki RSS feed for maps",
// "List of maps available" => "List of maps available",
// "You do not have permissions to view the layers" => "You do not have permissions to view the layers",
// "You do not have permissions to delete a file" => "You do not have permissions to delete a file",
// "You do not have permissions to create a directory" => "You do not have permissions to create a directory",
// "The Directory is not empty" => "The Directory is not empty",
// "You do not have permissions to delete a directory" => "You do not have permissions to delete a directory",
// "You do not have permissions to create an index file" => "You do not have permissions to create an index file",
// "Invalid file name" => "Invalid file name",
// "Invalid files to index" => "Invalid files to index",
// "I do not know where is gdaltindex. Set correctly the Map feature" => "I do not know where is gdaltindex. Set correctly the Map feature",
// "I could not create the index file" => "I could not create the index file",
// "No page provided" => "No page provided",
// "Page \"%0\" does not exist" => "Page \"%0\" does not exist",
// "Must be logged to use this feature" => "Must be logged to use this feature",
// "Welcome at Hawiki" => "Welcome at Hawiki",
// "This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more" => "This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more",
// "You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site" => "You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site",
// "tiki-mobile.php" => "tiki-mobile.php",
// "About" => "About",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
// "Your PHP installation does not have zlib enabled" => "Your PHP installation does not have zlib enabled",
// "You must log in to use this feature" => "You must log in to use this feature",
// "You do not have permission to view other users data" => "You do not have permission to view other users data",
// "You must be logged in to subscribe to newsletters" => "You must be logged in to subscribe to newsletters",
// "No server indicated" => "No server indicated",
// "Cannot connect to" => "Cannot connect to",
// "Missing information to read news (server,port,username,password,group) required" => "Missing information to read news (server,port,username,password,group) required",
// "Cannot get messages" => "Cannot get messages",
// "No note indicated" => "No note indicated",
// "merged note" => "merged note",
// "File is too big" => "File is too big",
// "Are you sure you want to delete this note" => "Are you sure you want to delete this note",
// "created from notepad" => "created from notepad",
// "Page already exists" => "Page already exists",
// "Not enough information to display this page" => "Not enough information to display this page",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot browse this page history" => "Permission denied you cannot browse this page history",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "No post indicated" => "No post indicated",
// "Missing object list type argument" => "Missing object list type argument",
// "Index" => "Index",
// "Index (' . \$code . " => "Index (' . \$code . ",
// "No pages indicated" => "No pages indicated",
// "Pageviews" => "Pageviews",
// "No result indicated" => "No result indicated",
// "to the email" => "to the email",
// "You cannot rename staging pages. Please rename the approved page instead" => "You cannot rename staging pages. Please rename the approved page instead",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "changed '%s' from '%s' to '%s'" => "changed '%s' from '%s' to '%s'",
// "Permission denied you cannot rollback this page" => "Permission denied you cannot rollback this page",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "Post recommendation at" => "Post recommendation at",
// "invalid email" => "invalid email",
// "successfully sent" => "successfully sent",
// "not sent" => "not sent",
// "Notice: invalid variable value" => "Notice: invalid variable value",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Page must be defined inside a structure to use this feature" => "Page must be defined inside a structure to use this feature",
// "Clean the sql logs" => "Clean the sql logs",
// "You cannot take this quiz twice" => "You cannot take this quiz twice",
// "Quiz time limit exceeded quiz cannot be computed" => "Quiz time limit exceeded quiz cannot be computed",
// "You cannot take this survey twice" => "You cannot take this survey twice",
// "Report to the webmaster" => "Report to the webmaster",
// "Please create a category first" => "Please create a category first",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Batch file processed" => "Batch file processed",
// "No permission to upload zipped file packages" => "No permission to upload zipped file packages",
// "Error processing zipped image package" => "Error processing zipped image package",
// "No permission to upload zipped image packages" => "No permission to upload zipped image packages",
// "The uploaded file ist not recognized as a image" => "The uploaded file ist not recognized as a image",
// "That is not an image (or you have php < 4.0.5)" => "That is not an image (or you have php < 4.0.5)",
// "No url indicated" => "No url indicated",
// "Invalid password. Your current password is required to change administrative information" => "Invalid password. Your current password is required to change administrative information",
// "was moved into trash" => "was moved into trash",
// "trashed by" => "trashed by",
// "open / in process" => "open / in process",
// "Rights by creator" => "Rights by creator",
// "END" => "END",
// "Percentage" => "Percentage",
// "Task accepted by creator" => "Task accepted by creator",
// "Task accepted by task user" => "Task accepted by task user",
// "Task NOT accepted by creator" => "Task NOT accepted by creator",
// "Task NOT accepted by task user" => "Task NOT accepted by task user",
// "Sorry this task does not exist or you have no rights to view this task" => "Sorry this task does not exist or you have no rights to view this task",
// "Task entries" => "Task entries",
// "Info message" => "Info message",
// "NEW Task" => "NEW Task",
// "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks" => "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks",
// "Changes on Task" => "Changes on Task",
// "You received a new task" => "You received a new task",
// "The priority is" => "The priority is",
// "very low" => "very low",
// "low" => "low",
// "high" => "high",
// "very high" => "very high",
// "You've to start your work at least on" => "You've to start your work at least on",
// "You've to finish your work on" => "You've to finish your work on",
// "Please read the task and work on it" => "Please read the task and work on it",
// "Sorry, there was an error while trying to write data into the database" => "Sorry, there was an error while trying to write data into the database",
// "A new page is created in a language" => "A new page is created in a language",
// "Language watch" => "Language watch",
// "Cannot upload this file not enough quota" => "Cannot upload this file not enough quota",
// "No banner indicated" => "No banner indicated",
// "No blog indicated" => "No blog indicated",
// "Permission denied you cannot remove the post" => "Permission denied you cannot remove the post",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "No cache information available" => "No cache information available",
// "You must suggest a question; please try again" => "You must suggest a question; please try again",
// "No faq indicated" => "No faq indicated",
// "You are not permitted to remove someone else\\'s post" => "You are not permitted to remove someone else\\'s post",
// "No thread indicated" => "No thread indicated",
// "Incorrect thread" => "Incorrect thread",
// "A SheetId is required" => "A SheetId is required",
// "That tracker don't use extras" => "That tracker don't use extras",
// " The connection failed, so check the server names" => " The connection failed, so check the server names",
// "The connection was OK" => "The connection was OK",
// " But the login failed, so check the Username and Password" => " But the login failed, so check the Username and Password",
// "Plugin modified by editor" => "Plugin modified by editor",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "The TikiTests Replay File has an error" => "The TikiTests Replay File has an error",
// "You are about to delete a TikiTest file, do you want to continue " => "You are about to delete a TikiTest file, do you want to continue ",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Re:" => "Re:",
"ID" => "ID",
"no cache" => "no cache",
"Semester" => "Semester",
"Wiki" => "Wiki",
"blog" => "blog",
"forum" => "forum",
"Blog" => "Blog",
"Forum" => "Forum",
"km" => "km",
"pvs" => "pvs",
"wiki" => "wiki",
"img-g" => "img-g",
"file-g" => "file-g",
"arts" => "arts",
"textarea" => "textarea",
"category" => "category",
"Google Maps" => "Google Maps",
"user preference" => "user preference",
"(AT)" => "(AT)",
"(DOT)" => "(DOT)",
"characters long" => "characters long",
"HTML code" => "HTML code",
"URL" => "URL",
"Image ID" => "Image ID",
"Img" => "Img",
"Stop" => "Stop",
"Filter" => "Filter",
"Subscribe" => "Subscribe",
"Id" => "Id",
"Original" => "Original",
"Status" => "Status",
"Test" => "Test",
"^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
"id" => "id",
"Threaded" => "Threaded",
"podcast (audio)" => "podcast (audio)",
"podcast (video)" => "podcast (video)",
"Show Tree" => "Show Tree",
"New message arrived from %s" => "New message arrived from %s",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
"Ip" => "Ip",
"Diff" => "Diff",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"Read message" => "Read message",
"Banning" => "Banning",
"Cache" => "Cache",
"\$module_title" => "\$module_title",
"To configure your Tiki" => "To configure your Tiki",
"Admin" => "Admin",
"Recently visited pages" => "Recently visited pages",
"April" => "April",
"September" => "September",
"November" => "November",
"December" => "December",
"\$modcattitle" => "\$modcattitle",
"Sites" => "Sites",
"Featured links" => "Featured links",
"Top `\$module_rows` topics" => "Top `\$module_rows` topics",
"Top topics" => "Top topics",
"Standard" => "Standard",
"Tiki Logo" => "Tiki Logo",
"Wiki RSS" => "Wiki RSS",
"online user" => "online user",
"on host" => "on host",
"[-]" => "[-]",
"Permalink" => "Permalink",
"URI" => "URI",
"i18n" => "i18n",
"RSS" => "RSS",
"Intertiki" => "Intertiki",
"InterTiki" => "InterTiki",
"Reset" => "Reset",
"JsCalendar" => "JsCalendar",
"Integrator" => "Integrator",
"DSN" => "DSN",
"h" => "h",
"Red" => "Red",
"image gal" => "image gal",
"file gal" => "file gal",
"ExtWiki" => "ExtWiki",
"Topic list configuration" => "Topic list configuration",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address",
"mn" => "mn",
"List image galleries" => "List image galleries",
"dynamic collapsed" => "dynamic collapsed",
"dynamic extended" => "dynamic extended",
"fixed" => "fixed",
"r" => "r",
"w" => "w",
"PDF" => "PDF",
"Dump Tree" => "Dump Tree",
"TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
"Hit" => "Hit",
"+" => "+",
"Nickname" => "Nickname",
"URL:" => "URL:",
"to" => "to",
"Use HTML" => "Use HTML",
"Use image" => "Use image",
"Image:" => "Image:",
"Current Image" => "Current Image",
"%" => "%",
"DB Prefix" => "DB Prefix",
"Creation Date" => "Creation Date",
"XY-Size" => "XY-Size",
"Gallery Image" => "Gallery Image",
"/" => "/",
"Backl." => "Backl.",
"tikiwiki.org" => "tikiwiki.org",
"Mb" => "Mb",
"You can download this file using" => "You can download this file using",
"top" => "top",
"Default view" => "Default view",
"This page is being edited by" => "This page is being edited by",
"Cached" => "Cached",
"unicode" => "unicode",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "Ta možnost ni omogočena",
"Permission denied you cannot view pages" => "Nimate dovoljenja za ogled strani",
"Cookies must be allowed to vote" => "Dovoliti moraš piškotke za omogočanje volitev",
"This forum is flat and doesn't allow replies to other replies" => "ta forum je plosek in ne omogoča odgovarjanje na komentarje",
"You do not have permission to use this feature" => "Nimaš dovoljenja uporabljati to značilnost",
"Type" => "Tip",
"Name" => "Ime",
"Description" => "Opis",
"Size" => "Velikost",
"Created" => "Ustvaril",
"Uploaded" => "Naložil",
"Last Modified" => "Zadnji spremenil",
"Creator" => "Ustvaril",
"Author" => "Avtor",
"Last editor" => "Zadnji urednik",
"Comment" => "Komentar",
"Files" => "Datoteke",
"Hits" => "Zadetki",
"Locked by" => "Zaklenil",
"Explorer" => "Raziskovalec",
"Path" => "Pot",
"Activity" => "Aktivnost",
"Role" => "Vloga",
"Process %d has been activated" => "Proces %s je bil aktiviran",
"Process %d has been deactivated" => "Proces %s je bil deaktiviran",
"Process %s %s imported" => "Proces %s je bil uvožen",
"Process %s removed" => "Proces %s je bil odstranjen",
"Process %s has been updated" => "Proces %s je bil osvežen",
"Process %s has been created" => "Proces %s je bil ustvarjen",
"Disabled" => "Onemogočen",
"Plain text" => "Navadno besedilo",
"Creation date (desc)" => "Datum ustvarjanja (pad)",
"Last modification date (desc)" => "Datum zadnje spremebe (pad)",
"minute" => "minuta",
"minutes" => "minute",
"hour" => "ura",
"hours" => "ure",
"Page last modified on" => "Stran zadnjič spremenjena",
"complete" => "kompletno",
"latin" => "latinsko",
"english" => "angleško",
"Day" => "Dan",
"Week" => "Teden",
"Month" => "Mesec",
"Quarter" => "Četrtletje",
"Year" => "Leto",
"Saturday" => "Sobota",
"Sunday" => "Nedelja",
"Monday" => "Ponedeljek",
"Depends user language" => "Odvisno od jezika",
"Topics (desc)" => "Teme (pad)",
"5 minutes" => "5 minut",
"15 minutes" => "15 minute",
"30 minutes" => "30 minute",
"Registered" => "Registriran",
"Anonymous" => "Anonomni",
"No forums" => "Ni forumov",
"Permission denied" => "Nimate dovoljenja",
"Template %s not registered" => "Predloga %s ni registrirana",
"The file is not a CSV file or has not a correct syntax" => "Datoteka ni CSV datoteka ali ima napačno sintakso",
"Error line: %d" => "Napaka v liniji: %d",
"locked" => "zaklenjeno",
"locked by" => "Zaklenil",
"Administration:" => "Administracija:",
"in" => "v",
"continued" => "se nadaljuje",
"New Image Uploaded by" => "Novo sliko je naložil",
"New Subscriptions" => "Nove naročnine",
"New Item in Tracker" => "Nova postavka v sledilniku",
"tracker" => "sledilnik",
"by" => "",
"Image Gallery" => "Galerija slik",
"Articles" => "Članki",
"Blogs" => "Blogi",
"Forums" => "Forumi",
"Directory" => "Imenik",
"File Gallery" => "Galerija datotek",
"FAQs" => "Vprašanja in odgovoriF",
"Quizzes" => "Kvizi",
"Trackers" => "Sledilniki",
"Survey" => "Spletna anketa",
"Newsletter" => "Bilten",
"Charts" => "Grafikoni",
"article" => "članek",
"directory" => "direktorij",
"faq" => "vino",
"file gallery" => "galerija datotek",
"image gallery" => "galerija slik",
"newsletter" => "bilten",
"poll" => "anketa",
"quiz" => "kviz",
"survey" => "spletna anketa",
"wiki page" => "wiki stran",
"image" => "slika",
"calendar" => "koledar",
"Cannot upload this file maximum upload size exceeded" => "Ne moreš naložiti te datoteke, ker presega maksimalno velikost",
"Cannot write to this file:" => "Ne morete pisati v to datoteko:",
"(not registered)" => "(ni registriran)",
"You have mistyped the anti-bot verification code; please try again." => "Napačno si vtipkal anti-bot verifikacijsko kodo. Prosim, poskusi znova.",
"Wrong password. Cannot post comment" => "Napačno geslo. Ne morete komentirati.",
"A contribution is mandatory" => "Prispevanje je obvezno",
"text" => "tekst",
"Line:" => "Vrstica:",
"Lines:" => "Vrstice:",
"Tiki Link - Insert internal link" => "Tiki povezava - vstavi notranjo povezavo",
"Select a Wiki page to link to:" => "Izberi Wiki stran za povezavo na:",
"Find" => "Poišči",
"find" => "poišči",
"prev" => "prej",
"Page" => "Stran",
"next" => "naslednji",
"Link" => "Povezava",
"Page name" => "Ime strani",
"Cannot open this file:" => "Ne morem odpreti te datoteke:",
"Wiki Home" => "Wiki dom",
"Home" => "Domov",
"previous page" => "prejšnja stran",
"next page" => "naslednja stran",
"posted on" => "objavljeno v",
"Continue" => "Nadaljuj",
"By:" => "Od:",
"Read" => "Preberi",
"List articles" => "Seznam člankov",
"Last post" => "Zadnja objava",
"Invalid imagename (using filters for filenames)" => "Nepravilno ime slike(uporaba filtrov za imena datotek)",
"Errors detected" => "Najdene napake",
"Upload was not successful" => "Nalaganje ni uspelo",
"No image yet, sorry." => "Še ni slike, oprostite.",
"Contributions" => "Prispevki",
"Query point:" => "Točka poizvedbe:",
"layer:" => "raven:",
"Record:" => "Zapis:",
"unknown" => "neznan",
"User Map Generated in:" => "Zemljevid uporabnikov je bil narejen v:",
"Image Map Generated in:" => "Zemljevid slik je bil narejen v:",
"menu" => "meni",
"NONE" => "Nobeden",
"File %s not found" => "Datoteke % ne najdem",
"This poll is closed." => "Ta spletna anketa je zaprta.",
"Wiki top pages" => "Najbolj iskane wiki strani",
"Most relevant pages" => "Najbolj pomembne strani",
"Relevance" => "Pomembnost",
"Wiki last pages" => "Zadnje wiki strani",
"Modified" => "Spremenjeno",
"Forums last topics" => "Zadnji prispevki na forumu",
"Topic date" => "Datum teme",
"Forums last posts" => "Zadnji prispevki na forumu",
"Forums most read topics" => "Najbolj brani prispevki na forumu",
"Reads" => "Branja",
"Forums best topics" => "Najboljše teme na forumu",
"Score" => "Rezultat",
"Forums most visited forums" => "Najbolj brani forumi",
"Visits" => "Obiski",
"Forums with most posts" => "Forumi z največ prispevki",
"Posts" => "Prispevki",
"Wiki top galleries" => "Najboljše wiki galerije",
"Wiki top file galleries" => "Najboljše wiki galerije datotek",
"Wiki top images" => "Najboljše wiki galerije slik",
"Wiki top files" => "Najboljše wiki datoteke",
"Downloads" => "Snemanje",
"Wiki last images" => "Zadnje wiki slike",
"Upload date" => "Datum nalaganja",
"Wiki last files" => "Zadnje wiki datoteke",
"Wiki top articles" => "Najboljši članki v wikiju",
"Most visited blogs" => "Najbolj obiskani blogi",
"Most active blogs" => "Najbolj aktivni blogi",
"Blogs last posts" => "Zadnji prispevki v blogih",
"Post date" => "Datum pošiljanja",
"Wiki top authors" => "Najboljši wiki avtorji",
"Pages" => "Strani",
"Top article authors" => "Najboljši avtorji člankov",
"The passwords do not match" => "Gesli se ne ujemata",
"User already exists" => "Uporabnik že obstaja",
"Wrong registration code" => "Napačna registracijska koda",
"Invalid username" => "Neveljavno uporabniško ime",
"Username is too long" => "Uporabniško ime je predolgo",
"Username cannot contain whitespace" => "Uporabniško ime ne sme vsebovati presledka",
"Wrong passcode you need to know the passcode to register in this site" => "Napačna koda. Poznati morate kodo, da lahko registrirate na to stran",
"Invalid email address. You must enter a valid email address" => "Napačen e-naslov. Vpišite pravilen e-naslov.",
"The registration mail can't be sent. Contact the administrator" => "Registracijska e-pošta ne more biti poslana. Povežite se z administratorjem.",
"Feed provided by %s. Click to visit." => "Vir je priskrbel %s. Klikni za obisk.",
"Login" => "Prijava",
"See other user's profile" => "Poglej profil drugih uporabnikov",
"Have your profile seen" => "Omogoči vpogled v svoj profil",
"Make friends" => "Poišči prijatelje",
"Receive message" => "Dobi sporočilo",
"Send message" => "Poslano sporočilo",
"Read an article" => "Preberi članek",
"Publish an article" => "Objavi članek",
"Have your article read" => "Omogoči branje svojega članka",
"Create new file gallery" => "Ustvari nov galerijo datotek",
"Upload new file to gallery" => "Naloži novo datoteko v galerijo",
"Download other user's file" => "Naloži datoteko drugega uporabnika",
"Have your file downloaded" => "Omogoči nalaganje datoteke",
"Create a new image gallery" => "Ustvari novo galerijo slik",
"Upload new image to gallery" => "Naloži novo sliko v galerijo",
"See other user's gallery" => "Poglej galerijo drugih uporabnikov",
"See other user's image" => "Poglej slike drugih uporabnikov",
"Have your gallery seen by other user" => "Omogočite vpogled v tvojo galerijo drugim uporabnikom",
"Have your image seen" => "Omogoči vpogled v tvojo sliko",
"Create new blog" => "Ustvari nov blog",
"Post in a blog" => "Pošlji nov blog",
"Read other user's blog" => "Preberite blog drugih uporabnikov",
"Have your blog read" => "Omogočite branje tvojega bloga",
"Create a new wiki page" => "Ustvari novo wiki stran",
"Edit an existing page" => "Uredite obstoječo stran",
"Attach file" => "Pripni datoteko",
"Tracker" => "Sledilnik",
"Unknown" => "Neznan",
"Trackeritem" => "Ritem sledilnika",
"Image" => "Slika",
"Article" => "Članek",
"Directory category" => "Kategorija direktorija",
"FAQ" => "Vprašanja in odgovori",
"Gallery" => "Galerija",
"Blog post" => "Blogovski prispevek",
"Tracker item" => "Predmet sledilnika",
"Simple" => "Preprosto",
"Advanced" => "Napredno",
"Fast Next" => "Hitro naslednji",
"Fast Prev" => "Hitro prejšjni",
"Prev" => "Prej",
"Next" => "Nasl",
"First {\$params['itemname']}" => "Najprej {\$params['itemname']}",
"Last {\$params['itemname']}" => "Zadnji {\$params['itemname']}",
"Next {\$params['itemname']}" => "Naslednji {\$params['itemname']}",
"Prev {\$params['itemname']}" => "Prejšnji {\$params['itemname']}",
"Help page:" => "Stran pomoč:",
"View tpl:" => "Poglej predlogo:",
"Edit Template" => "Uredi predlogo",
"Admin Feature" => "Administriraj značilnost (Feature)",
"Hide" => "Skrij",
"help" => "pomoč",
"All" => "Vse",
"The text is" => "Tekst je",
"Date Selector" => "Izbira datuma",
"phplayers are not available on this site" => "phplayers niso na razpolago na tej strani",
"Select All" => "Izberi vse",
"Invert Sort" => "Zamenjaj razvrščanje",
"days" => "dni",
"day" => "dan",
"mins" => "minute",
"min" => "minuta",
"secs" => "sekunde",
"sec" => "sekunda",
"done" => "narejeno",
"Task" => "Opravilo",
"from" => "iz",
"for" => "za",
"Priority" => "Prioriteta",
"Start date:" => "Datum začetka:",
"End date:" => "Datum konca:",
"User information - Click for more info" => "Informacije o uporabniku - klikni za več informacij",
"Friend" => "Prijatelj",
"(idle for %s seconds)" => "(nedejavno %s sekund)",
"More info about \$other_user" => "Več informacij o \$other_user",
"(idle for \$idletime seconds)" => "(nedejavno \$idletime sekund)",
"No" => "Ne",
"Use this tree to copy the structure" => "Uporabi to drevo za kopiranje strukture",
"created from structure" => "ustvarjeno iz strukture",
"Table of contents" => "Tabela vsebin",
"unknown error" => "neznana napaka",
"You are not logged in" => "Nisi prijavljen",
"Page cannot be found" => "Ne najdem strani",
"An error occured in a database query!" => "Napaka se je pojavila pri poizvedbi podatkovne baze!",
"Help" => "Pomoč",
"You are banned from" => "Prepovedano ti je",
"faqs" => "Vprašanja in odgovori",
"quizzes" => "kvizi",
"blogs" => "blogi",
"forums" => "forumi",
"games" => "igre",
"Click to edit dynamic variable" => "Klikni za urejanje dinamične variable",
"Update variables" => "Posodobi variable",
"Edit Section" => "Uredi sekcijo",
"index" => "indeks",
"Show" => "Pokaži",
"You are not allowed to upload this type of file." => "Nimate dovoljenja naložiti ta tip datoteke.",
"The file you are trying upload was only partially uploaded." => "Datoteka, ki jo želite naložiti, je bila samo delno naložena.",
"You must select a file." => "Izbrati moraš datoteko.",
"Altering database table failed" => "Spreminjanje datoteke ni uspelo",
"%d points" => "%d točk",
"Removed" => "Odstranjeno",
"at" => "pri",
"new" => "novo",
"Create page:" => "Ustvari stran:",
"Unknown language" => "Neznan jezik",
"Click here to confirm your action" => "Klikni tu za potrditev",
"Upload was not successful. Duplicate file content ?" => "Nalaganje ni bilo uspešno. Podvajanje vsebine datoteke?",
"Item Modification" => "Modifikacija postavke",
"Item" => "Postavka",
"Item creation" => "Izvedba postavke",
"Subject" => "Predmet",
"Tracker was modified at " => "Sledilnik je bil spremenjen ob ",
"Field is not numeric" => "Polje ni numerično",
"Field is not a link to mp3 in the gallery" => "Polje ni povezava na mp3 v galeriji",
"Field is not a link to FLV in the gallery" => "Polje ni povezava na FLV v galeriji",
"Field is not a link to FLV or MP3 in the gallery" => "Polje ni povezava na mp3 ali FLV v galeriji",
"text field" => "tekstvono polje",
"half column" => "polkolona",
"size" => "velikost",
"max" => "maks",
"checkbox" => "potrditveno polje",
"numeric field" => "numerično polje",
"drop down" => "spustni",
"user selector" => "izbirnik uporabnikov",
"group selector" => "izbirnik skupin",
"country selector" => "izbirnik držav",
"date and time" => "datum in čas",
"action" => "akcija",
"header" => "glava",
"static text" => "statični tekst",
"email" => "e-pošta",
"multimedia" => "večpredstavnost",
"user subscription" => "naročnina uporabnika",
"system" => "sistem",
"computed field" => "izračunano polje",
"attachment" => "priponka",
"open" => "odpri",
"pending" => "nerešen",
"closed" => "zaprt",
"Message" => "Sporočilo",
"No extra information for that attached file. " => "Ni posebnih informacij za pripeto datoteko. ",
"child categories" => "otroška kategorija",
"objects in category" => "objekti v kategoriji",
"The administrator has not yet validated your account. Please wait." => "Administrator še ni potrdil vašega računa. Prosimo počakajte.",
"You must validate your account first. An email has been sent to you" => "Najprej morate potrditi vaš račun. Poslali smo vam e-pošto.",
"Password should be at least" => "Geslo mora biti dolgo vsaj ",
"Password must contain both letters and numbers" => "Geslo mora vsebovati oboje: črke in številke.",
"The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "Registracijske e-pošte nismo poslali, ker ni nastavljen e-naslov strežnika in ta značilnost je onemogočena.",
"The user email confirmation can't be sent. Contact the administrator" => "Potrditev e-pošte uporabnika ne moremo poslati. Pokličite administratorja.",
"Personal Phone" => "Osebni telefon",
"Personal Mobile" => "Osebni mobilni telefon",
"Personal Fax" => "Osebni faks",
"Work Phone" => "Službeni telefon",
"Work Mobile" => "Službeni mobilni telefon",
"Work Fax" => "Službeni faks",
"Company" => "Podjetje",
"Organization" => "Organizacija",
"Department" => "Oddelek",
"Division" => "Enota",
"Job Title" => "Naziv na delovnem mestu",
"Street Address" => "Ulica",
"City" => "Mesto",
"State" => "Država",
"Zip Code" => "Poštna številka",
"Country" => "Država",
"Displays browser client info" => "Prikaže informacije brskalniških odjemalcev",
"linktext" => "tekst povezave",
"Location" => "Lokacija",
"Save changes to annotations" => "Shrani spremembe v notacijo",
"Creates an annotation block for an image." => "Ustvari notacijski blok za sliko.",
"Field" => "polje",
"Includes an article" => "Vključi članek",
"Language" => "Jezik",
"Attachment" => "Priponka",
"File" => "Datoteka",
"Show description" => "Pokaži opis",
"Same as name" => "Enako kot ime",
"Shows a file icon" => "pokaži ikono datotek",
"Avatar" => "Avatarji",
"Displays the user Avatar" => "Prikaže uporabnikovega Avatarja",
"username" => "uporabniško ime",
"Back" => "Nazaj",
"Backlinks" => "Povezava nazaj",
"No pages links to" => "Nobena stran se ne povezuje na",
"One page links to" => "Ena stran se povezuje na",
"pages link to" => "strani se povezujejo na",
"Use BLOGLIST to include posts from a blog. Syntax is" => "Uporabi BLOGLIST za vključitev prispevkov z bloga. Sintaksa je",
"Category" => "Kategorija",
"Categories are disabled" => "Kategorije niso omogočene",
"Chart" => "Graf",
"title" => "naslov",
"Chart as PDF" => "Graf kot PDF",
"code" => "koda",
"Cookie" => "Piškotek",
"Copyright" => "Avtorske pravice",
"Example" => "Primer",
"and" => "in",
"seconds" => "sekunde",
"drawing not found" => "nisem našel risbe",
"Events" => "Dogodki",
"Desc" => "Pad",
"Label" => "Nalepka",
"Title" => "Naslov",
"missing parameters" => "manjkajoči parametri",
"Incorrect param" => "Nepravi param",
"Missing parameter" => "Manjkajoči parameter",
"Group" => "Skupina",
"Image size" => "Velikost slike",
"Start" => "Začetek",
"Last Modification" => "Zadnja sprememba",
"List Pages" => "Seznam strani",
"List wiki pages." => "Seznam viki strani.",
"Sort" => "Sortiraj",
"or" => "ali",
"Lists files in a directory" => "Seznami datotek v direktoriju",
"could not be opened because it doesn't exist or permission was denied" => "se ne da odpreti, ker ne obstoji ali nimate dovoljenja",
"Style" => "Stil",
"Module Name" => "Ime modula",
"data" => "podatek",
"Object" => "Objekt",
"Days" => "Dnevi",
"picture not found" => "nisem našel slike",
"Information" => "Informacije",
"Poll" => "Anketa",
"one data per line" => "en podatek v vrsto",
"Search" => "Išči",
"Icon" => "Ikona",
"Date" => "Datum",
"List wiki pages" => "Naredi seznam wiki strani",
"Display" => "Prikaži",
"Last modified by" => "Zadnji spremenil",
"Clickable Skype link" => "Klikabilna Skype povezava",
"Action" => "Akcija",
"Order" => "Vrstni red",
"First" => "Prvi",
"Edit" => "Uredi",
"Groups" => "Skupine",
"Thumbnail" => "Miniaturna sličica (Thumbnail)",
"Structure ID" => "ID strukture",
"Translate" => "Prevedi",
"Preview" => "Predogled",
"View" => "Pogled",
"Error" => "Napaka",
"Example:" => "Primer:",
"Wiki text" => "Wiki besedilo",
"More" => "Več",
"Template" => "Predloga",
"Flag" => "Označi (Flag)",
"User List" => "Seznam uporabnikov",
"Displays a list of registered users" => "Prikaže seznam registriranih uporabnikov",
"users" => "uporabniki",
"Preferences" => "Izbirne nastavitve",
"User Information" => "Uporabnikove informacije",
"Versions" => "Verzije",
"Vote" => "Glasuj",
"Table" => "Tabela",
"Level" => "Nivo",
"ignored" => "ignorirano",
"External Wiki" => "Zunanji wiki",
"valid" => "veljaven",
"Wanted Page" => "Željena stran",
"width" => "širina",
"height" => "višina",
"rollback version " => "povrnjena verzija",
"Top" => "Na vrh",
"Page locked" => "Zaklenjena stran",
"Page unlocked" => "Nezaklenjena stran",
"Removed last version" => "Odstranjena zadnja verzija",
"Invalid user" => "Neveljaven uporabnik",
"Message sent to" => "Stran poslana na",
"Calendar" => "Koledar",
"Categorize %s in %s" => "Kategoriziraj %s v %s",
"Create/Edit" => "Ustvari/Uredi",
"Quick Edit a Wiki Page" => "Hitro urejanje wiki strani",
"Post" => "Objavi",
"Changes since" => "Spremembe od",
"new comments" => "Novi komentarji",
"new posts" => "Novi prispevki",
"wiki pages changed" => "Spremenjene wiki strani",
"new articles" => "Novi članki",
"new FAQs" => "Nova vprašanja in odgovori",
"new blogs" => "Novi blogi",
"new blog posts" => "Novi blogovski prispevki",
"new image galleries" => "Nove galerije slik",
"new images" => "Nove slike",
"new file galleries" => "Nove galerije datotek",
"new files" => "Nove datoteke",
"new polls" => "Nove spletne ankete",
"new users" => "Novi uporabniki",
"new tracker items" => "Nove postavke sledilnika",
"Invalid username or password" => "Neveljavno uporabniško ime ali geslo",
"Anti-Bot verification code" => "Anti-Bot verifikacijska koda",
"Random Image" => "Naključna slika",
"Enter the code you see above" => "Vnesi kodo, ki jo vidiš zgoraj",
"List of attached files" => "Seznam pripetih datotek",
"desc" => "padajoče",
"uploaded" => "naloženo",
"Download" => "Naloži",
"Delete" => "Izbriši",
"Remove" => "Odstrani",
"Upload file" => "Naloži datoteko",
"Attach" => "Pripni",
"Attach a file to this item" => "Pripni datoteko tej postavki",
"Version" => "Verzija",
"Attachments" => "Priponka",
"more info" => "vač informacij",
"No attachments for this item" => "Ni priponk za to postavko",
"debug" => "popravi napako",
"Fatal error" => "Usodna napaka",
"Created by" => "Ustvaril",
"on" => "na",
"RSS feed" => "Vir RSS",
"Edit blog" => "Uredi blog",
"Monitor this Blog" => "Opazuj ta blog",
"Stop Monitoring this Blog" => "Prenehaj opazovati ta blog",
"Activity=" => "Aktivnost=",
"Watched by categories" => "Opazovano po kategorijah",
"Actions" => "Akcije",
"Properties" => "Lastnosti",
"No records found" => "Ni najdenih zapisov",
"Categorize" => "Kategoriziraj",
"Admin Categories" => "Administriraj kategorije",
"No categories defined" => "Ni definiranih kategorij",
"Browse Category" => "Prebrskaj kategorijo",
"posts:" => "zapisi:",
"stars" => "zvezde",
"User Level" => "Uporabniška stopnjaUser Level",
"private message" => "privatno sporočilo",
"Send eMail to User" => "Pošlji e-pošto uporabniku",
"user online" => "uporabnik priključen",
"user offline" => "uporabnik ni priključen",
"top of page" => "na vrh strani",
"Reply" => "Odgovori",
"Report this post" => "Poročaj o tem zapisu",
"Save to notepad" => "Shrani na ave to beležnico",
"Monitor this Topic" => "Opazuj to temo",
"Stop Monitoring this Topic" => "Prenehaj opazovati to temo",
"Errors" => "Napake",
"Moderator actions" => "Akcije moderatorja",
"reported:" => "poročano:",
"queued:" => "v vrsti:",
"Move to topic:" => "Prestavi v temo:",
"Move" => "Prestavi",
"Delete Selected" => "Izbriši izbrano",
"Unlock" => "Odkleni",
"Lock" => "Zakleni",
"Messages" => "Sporočila",
"Plain" => "Navaden",
"Headers Only" => "Samo glave",
"Newest first" => "Najnovejši najprej",
"Oldest first" => "Najstarejši najprej",
"Title (desc)" => "Naslov (pad)",
"Title (asc)" => "Naslovi (nar)",
"Threshold" => "Prag",
"Set" => "Nastavi",
"Replies" => "Odgovori",
"below your current threshold" => "pod vašim trenutnim pragom",
"Note" => "Opomba",
"New Reply" => "Nov odgovor",
"Editing reply" => "Urejanje odgovora",
"Reply to the selected post" => "Odgovori na izbrani prispevek",
"Post new message" => "napiši novo sporočilo",
"Editing comment" => "Urejanje komentarja",
"Comment on the selected post" => "Komentiraj izbrani prispevek",
"Post new comment" => "Prispevaj nov komentar",
"required" => "zahtevano",
"Smileys" => "Smejkoti",
"Quicktags" => "Hitre značke",
"Enter your name" => "Vpiši svoje ime",
"Reply to parent post" => "Odgovori na starševski prispevek",
"Post new reply" => "napiši nov odgovor",
"Post as Anonymous" => "Piši anonimno",
"Cancel" => "Prekliči",
"Posting replies" => "Pisanje odgovorov",
"Posting comments" => "Pisanje komentarjev",
"Use" => "Uporabi",
"for links" => "za povezave",
"HTML tags are not allowed inside posts" => "HTML značke niso dovoljene znotraj prispevkov",
"Add Comment" => "Dodaj komentar",
"1 comment" => "1 komentar",
"Go back" => "Pojdi nazaj",
"Return to home page" => "Nazaj na domačo stran",
"Type of contribution:" => "Tip prispevanja:",
"Contributors" => "Tisti, ki prispevajo",
"Copyrights" => "Avtorska pravica",
"Authors" => "Avtorji",
"Add" => "Dodaj",
"Syntax" => "Sintaksa",
"Total" => "Skupaj",
"Watchlist" => "Seznam opazovanj",
"Duplicate File Gallery" => "Dupliciraj galerijo datotek",
"Duplicate categories" => "Dupliciraj kategorijo",
"Duplicate perms" => "Dupliciraj dovoljenje",
"duplicate" => "Dupliciraj",
"Save" => "Shrani",
"View inserted gallery" => "Poglej vstavljeno galerijo",
"Display Properties" => "Prikaži lastnosti",
"required field for podcasts" => "zahtevana polja za podcaste",
"any file" => "katerakoli datoteka",
"Gallery is visible to non-admin users?" => "Galerija je vidna uporabnikom, ki niso administratorji?",
"This Gallery is Public" => "Ta galerija je javna",
"The files can be locked at download:" => "Datoteke lahko zaklenemo pri nalaganju:",
"Maximum number of archives for each file" => "Maksimalno število arhivov za vsako datoteko",
"unlimited" => "neomejeno",
"none" => "nobena",
"Parent gallery" => "Starševska galerija",
"Owner of the gallery" => "Lastnik galerije",
"Default sort order" => "Privzet vrstni red",
"descending" => "padajoč",
"ascending" => "naraščajoč",
"Max description display size" => "Maksimalna velikost prikaza za opis",
"Max Rows per page" => "maksimalno št. vrstic na stran",
"Perhaps you were looking for:" => "Verjetno iščete:",
"There are no wiki pages similar to '{\$page}'" => "Ni wiki strani, ki bi bile podobne '{\$page}'",
"You are not logged in." => "Nisi prijavljen.",
"Go to Login Page" => "Pojdi na stran za prijavo",
"Create this page" => "Ustvari to stran",
"(page will be orphaned)" => "(stran bo osirotela stran)",
"Close Window" => "Zapri okno",
"Go to" => "Pojdi na",
"Private Gallery" => "Privatna galerija",
"Active Perms" => "Aktivna dovoljenja",
"Perms" => "Dovoljenja",
"Archives" => "Arhivi",
"Upload New Version" => "Naloži novo verzijo",
"Download and lock" => "Naloži in zakleni",
"Browse" => "Brskaj",
"Name-filename" => "Ime-ime datoteke",
"Filename only" => "Samo ime datoteke",
"Show as a column" => "Prikaži kot kolono",
"Show in popup box" => "Prikaži v oknu",
"Both" => "Oboje",
"Show an icon in a column" => "Prikaži ikono v koloni",
"Close" => "Zapri",
"Exact&nbsp;match" => "Natančno&nbsp;ujemanje",
"any type" => "katerikoli tip",
"all topic" => "vse teme",
"any language" => "katerikoli jezik",
"any category" => "katerakoli kategorija",
"Number of displayed rows" => "Število prikazanih vrstic",
"Go" => "Pojdi",
"in:" => "v:",
"Show php error messages" => "Pokaži sporočila php napak",
"Folksonomy Tags" => "Značke:",
"Put tags separated by spaces. For tags with more than one word, use no spaces and put words together." => "Dodaj značke ločene s presledki. Za značke z več kot eno besedo, ne uporabi presledkov, pač pa besede združi kako drugače (npr: ključna_beseda).",
"Tags" => "Značke:",
"Translate tags" => "Prevedi značke",
"Images Galleries" => "Galerije slik",
"Edit this page!" => "Uredi so stran!",
"RSS Wiki" => "RSS wiki",
"RSS Blogs" => "RSS blogi",
"RSS Articles" => "RSS članki",
"RSS Image Galleries" => "RSS galerije slik",
"RSS File Galleries" => "RSS galerije datotek",
"RSS Forums" => "RSS Forumov",
"RSS Maps" => "RSS zemljevidi",
"RSS Directories" => "RSS imeniki",
"RSS Calendars" => "RSS koledarji",
"Loading" => "nalaganje",
"Hide Tree" => "Skrij drevo",
"Perform action with checked:" => "Izvedi akcijo z izbranimi:",
"Move Selected Files" => "Prestavi izbrane datoteke",
"Are you sure you want to delete the selected files?" => "Ali ste prepričani, da želite zbrisati izbrane datoteke?",
"Assign Permissions" => "Pripiši dovoljenja",
"Move to" => "Prestavi v",
"Assign" => "Določi",
"Filename" => "Ime datoteke",
"Other Sorts" => "Druga razvrščanja (Sorts)",
"No Additionnal Sort" => "Ni dodatnega razvrščanja (Sort)",
"No information" => "Ni informacij",
"Hi {\$mail_user} has sent you this link:" => "Pozdravljeni {\$mail_user} vam je poslal to povezavo:",
"Blog post:" => "Blogovski prispevek:",
"at:" => "pri:",
"Somebody or you tried to subscribe this email address at our site:" => "Nekdo ali pa vi se želi naročiti ta e-naslov na to stran:",
"To the newsletter:" => "Na bilten:",
"Description:" => "Opis:",
"Author:" => "Avtor:",
"A new message was posted to forum" => "Novo sporočilo je bilo poslano na ta forum",
"New topic:" => "Nova tema:",
"Topic:" => "Tema:",
"Contribution" => "Prispevanje",
"Page not found:" => "Stran ni najdena:",
"Hi," => "Pozdravljeni,",
"A new message was posted to you at {\$mail_machine}" => "Novo sporočilo vam je bilo poslano pri {\$mail_machine}",
"From" => "Od",
"Hi" => "Pozdravljeni",
"Your account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Vašo zahtevo za registracijo računa za {\$mail_site} je preveril administrator strani in vaš račun je sedaj aktiven.",
"To login with your username and password, please follow this link:" => "Za prijavo z uporabniškim imenom in geslom sledite tej povezavi:",
"Enjoy the site!" => "Uživajte na strani!",
"User Account Activated" => "Uporabniški račun je aktiviran.",
"best regards" => "pozdravi",
"your Tikiwiki" => "tvoj Tikiwiki",
"User Registration Request" => "Zahteva Tiki uporabnika za registracijo",
"You're invited to join my network of friends!" => "Povabljeni ste, da se pridružite moji mreži prijateljev!",
"The user" => "Uporabnik",
"registered at your site" => "registriran na vaši strani",
"New user registration" => "Registracija novega uporabnika",
"Bye bye!" => "Na svidenje!",
"This email address has been removed to the list of subscriptors of:" => "Ta e-naslov je bil odstranjen s seznama naročnikov:",
"Newsletter:" => "Bilten:",
"Welcome to our newsletter!" => "Dobrodošli v našem biltenu!",
"Email notification" => "Tiki e-poštno obvestilo",
"Title:" => "Naslov:",
"Please visit this link before login again:" => "Prosimo obiščite povezavo preden se ponovno prijavite:",
"User:" => "Uporabnik:",
"Confirm your account at %s" => "Potrdite vaš račun na %s",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Če želite biti registriran uporabnik na tej strani, morate uporabiti to povezavo, da bi se prvič prijavili.",
"You will receive an email with information to login for the first time into this site" => "Prejel boš e-pošto z informacijami za prvo prijavo na to stran",
"You'll receive email notification once your account is activated." => "Prejel boš e-poštno obvestilo ko bo račun aktiviran.",
"Please do not attempt to login until you receive the email notification." => "Prosim ne poskusi se prijaviti dokler ne dobiš obvestila po e-pošti.",
"View the article at:" => "Poglej si članek na:",
"If you don't want to receive these notifications follow this link:" => "Če ne želiš dobivati teh obvestil, sledi tej povezavi:",
"Old" => "Star",
"New" => "Nov",
"File Description" => "Opis datoteke",
"Added by" => "Dodal",
"Object type" => "Tip objekta",
"A page has been added to your watched sub-structure:" => "Stran je bila dodana k vaši opazovani pod-strukturi:",
"A page has been removed from your watched sub-structure:" => "Stran je bila odstranjena iz vaše opazovane pod-strukture:",
"A page has been promoted out your watched sub-structure:" => "Stran je bila povišana iz vaše opazovane pod-strukture:",
"A page has been demoted to your watched structure:" => "Stran je bila ponižana v vašo opazovano pod-strukturo:",
"Structure modified" => "Struktura je bila spremenjena",
"A new file have been attached to page" => "Nova datoteka je bila pripeta k strani",
"File name" => "Ime datoteke",
"New attachment on %s, page" => "Nova priponka na %s, strani",
"Comment:" => "Komentar:",
"You can view the page by following this link:" => "Lahko si obledate to stran, če sledite to povezavo:",
"Wiki page %s was commented on by" => "Wiki stran %s je komentiral",
"an anonymous user" => "anonimni uporabnik",
"Wiki page renamed" => "Wiki stran je preimenovana",
"Old name" => "Staro ime",
"New name" => "Novo ime",
"Thank you for your registration. You may log in now." => "Hval aza registracijo. Sedaj se lahko prijavite.",
"Zoom out" => "Povečaj",
"Zoom in" => "Zmanjšaj",
"Last modification date" => "Datum zadnje spremembe",
"Overview" => "Pregled",
"Legend" => "Legenda",
"Layer Manager" => "Upravlalec ravni (Layer Manager)",
"Layer" => "Raven(Layer)",
"On" => "Na",
"Download Layer" => "naloži plast (Layer)",
"hits last 7 days" => "zadetki zadnjih 7 dni",
"Create" => "Ustvari",
"Reload" => "Ponovno naloži",
"History" => "Zgodovina",
"Zoom out x2" => "Povečaj x2",
"Zoom in x2" => "Zmanjšaj x2",
"of" => "",
"Compare" => "Primerjaj",
"Comparing version {\$old.version} with version {\$new.version}" => "Primerjanje verzije {\$old.version} z verzijo {\$new.version}",
"Version:" => "Verzije:",
"Current" => "Trenutna",
"Versions are identical" => "Verzije so enake",
"Legend:" => "Legenda:",
"v=view" => "v=pogled",
"c=compare" => "c=primerjaj",
"d=diff" => "d=razlika",
"Full side-by-side diff" => "Polna side-by-side razlika",
"Unified diff" => "Unificirana razlika",
"Side-by-side view" => "Side-by-side pogled",
"User" => "Uporabnik",
"Older Version" => "Starejša verzija",
"Directories" => "Direktoriji",
"back to" => "nazaj na",
"Upload From Disk:" => "Naloži z diska:",
"Upload Files" => "Nalaganje podatkovnih datotek",
"Message Archive" => "Sporočilo arhiva",
"messages" => "sporočilo",
"Archive is full!" => "Arhiv je poln!",
"Unread" => "Neprebrano",
"Flagged" => "Označeno",
"Unflagged" => "Neoznačeno",
"Containing" => "Vsebuje",
"Sender" => "Pošiljatelj",
"No messages to display" => "Ni sporočil za prikaz",
"OK" => "V redu",
"All users" => "Vsi uporabniki",
"Lowest" => "Nižji",
"Low" => "Nizek",
"Normal" => "Normalen",
"High" => "Visok",
"Very High" => "Zelo visok",
"Send" => "Pošlji",
"Compose message" => "Sestavi sporočilo",
"ERROR" => "NAPAKA",
"Invalid" => "Neveljaven",
"To" => "Za",
"CC" => "Kp",
"BCC" => "Skp",
"No messages to download" => "Ni sporočil za naložiti",
"Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Poštni predal je poln! Izbrišite ali arhivirajte nekatera sporočila, če želite prejeti več sporočil.",
"is reply to" => "je odgovor na",
"Find replied message" => "Poišči sporočila (odgovorjena)",
"Archive" => "Arhiv",
"Mark as read" => "Označi kot prebrano",
"Mark as unread" => "Označi kot neprebrano",
"Mark as flagged" => "Označi kot zaznamovano (flagged)",
"Mark as unflagged" => "Označi kot nezaznamovano (unflagged)",
"Mark" => "Označi",
"Mailbox" => "Poštni predal",
"Compose" => "Sestavi",
"Broadcast" => "Oddaj(Broadcast)",
"Sent" => "Poslano",
"Auto-archive age for read messages:" => "Avto-arhiv čas za prebrana sporočila:",
"Return to mailbox" => "Nazaj na poštni predal",
"replyall" => "odgovori vsem",
"Unflag" => "Odznači (unflag)",
"Flag this message" => "Označi (flag) to sporočilo",
"Cc" => "Kp",
"Return to archive" => "Nazaj na arhiv",
"Return to outbox" => "Nazaj na odpremni predal (outbox)",
"Sent Messages" => "Poslana sporočila",
"Replied" => "Odgovorjeno",
"Not replied" => "Ne odgovorjeno",
"move to archive" => "premakni v arhiv",
"receiver" => "prejemnik",
"Move module up" => "Prestavi modul gor",
"Up" => "Gor",
"Move module down" => "Prestavi modul dol",
"Down" => "Dol",
"Move module to opposite side" => "Prestavi modul na nasprotno stran",
"opp side" => "nasp. str.",
"Toggle module contents" => "Preklopi na vsebino modula",
"toggle" => "preklopi",
"Admin Menu" => "Administratorski meni",
"Users" => "Uporabniki",
"Modules" => "Moduli",
"Links" => "Povezave",
"Hotwords" => "Vroče besede",
"Menus" => "Meniji",
"Polls" => "Spletne ankete",
"Search Stats" => "Iskalna statistika",
"QuickTags" => "Hitre značke",
"Chat" => "Klepet",
"Categories" => "Kategorije",
"Edit Templates" => "Uredite predloge",
"Cookies" => "Piškotki",
"Mail-in" => "Prispela pošta (Mail-in)",
"Shoutbox" => "Kričač (Shoutbox)",
"Shoutbox Words" => "Besede kričača (Shoutbox)",
"More..." => "Več...",
"Tikiwiki Assistant" => "Tikiwiki pomočnik",
"Thank you for installing Tikiwiki" => "Hvala za inštaliranje Tikiwikija",
"Select" => "iZBERI",
"Admin Home" => "Admin Domov",
"from the menu" => "iz menija",
"login" => "prijava",
"as the Admin" => "kot Admin",
"The Tikiwiki Community" => "Skupnost Tikiwiki",
"January" => "Januar",
"February" => "Februar",
"March" => "Marec",
"May" => "Maj",
"June" => "Junij",
"July" => "Julij",
"August" => "Avgust",
"October" => "Oktober",
"Tuesday" => "Torek",
"Wednesday" => "Sreda",
"Thursday" => "Četrtek",
"Friday" => "Petek",
"Today" => "Danes",
"Add event" => "Dodaj dogodek",
"Received objects" => "Prejeti objekti",
"Pages:" => "Strani:",
"Last `\$module_rows` Sites" => "Zadnji `\$module_rows` strani",
"Last Sites" => "Zadnje strani",
"Directory Stats" => "Statistika direktorija",
"Sites to validate" => "Strani za preverjanje veljavnosti",
"Searches" => "Iskanja",
"Visited links" => "Obiskane povezave",
"Top \$module_rows Sites" => "Najboljše \$module_rows strani",
"Top Sites" => "Najboljše strani",
"Current events" => "Trenutni dogodki",
"Last `\$module_rows` forum posts" => "Zadnji `\$module_rows` prispevki v forumu",
"Last forum posts" => "Zadnji prispevki v forumu",
"Last `\$module_rows` forum topics" => "Zadnje `\$module_rows` teme v forumu",
"Last forum topics" => "Zadnje teme v forumu",
"Most commented forums" => "Najbolj komentirani forumi",
"Most read topics" => "Najbolj brane teme",
"Most visited forums" => "Najbolj obiskani forumi",
"Folksonomy" => "Folksonomija",
"Tags This Page Has" => "Značke na tej strani",
"Add tags" => "Dodaj značke",
"More Like This" => "Več takih",
"Most popular tags" => "Najbolj priljubljene značke",
"List everything tagged" => "Seznam vsega kar vsebuje značke",
"My prefered tags" => "Moje prednostne značke",
"Google Search" => "Google iskanje",
"Last `\$module_rows` actions" => "Zadnji `\$module_rows` akcije",
"Last actions" => "Zadnje akcije",
"Last `\$module_rows` articles" => "Zadnji `\$module_rows` članki",
"Last articles" => "Zadnji članki",
"Last `\$module_rows` blog posts" => "Zadnji `\$module_rows` blogovski prispevki",
"Last blog posts" => "Zadnji prispevki na blogu",
"Last" => "Zadnji",
"\$type" => "\$tip",
"Last `\$module_rows` Created blogs" => "Zadnji `\$module_rows` ustvarjeni blogi",
"Last Created blogs" => "Zadnji ustvarjeni blogi",
"Last `\$module_rows` Created FAQs" => "Zadnja `\$module_rows` ustvarjena vprašanja in odgovori (FAQs)",
"Last Created FAQs" => "Zadnja ustvarjena vprašanja in odgovori (FAQs)",
"Last Created Quizzes" => "Zadnji ustvarjeni kvizi",
"Last Files" => "Zadnje datoteke",
"Last galleries" => "Zadnje galerije",
"Last Images" => "Zadnje slike",
"Last changes" => "Zadnje spremembe",
"more" => "več",
"Last Items" => "Zadnje postavke",
"Last Visitors" => "Zadnji obiskovalci",
"No avatar." => "Brez avatarja.",
"Register" => "Registriraj se",
"You" => "Vi",
"Live support" => "Živa podpora",
"We have" => "Mi imamo",
"Logged in as" => "Prijavljen kot",
"Logout" => "Odjava",
"Switch User" => "Preklopi na",
"Switch" => "Preklopi",
"Switch user" => "Preklopi uporabnika (Switch user)",
"Login through CAS" => "Prijava preko CAS",
"Login as admin" => "Prijava kot admin",
"Login through Shibboleth" => "Prijava preko Shibboleth",
"Login as" => "Prijavi se kot",
"Email" => "E-naslov",
"eMail" => "e-naslov",
"Password" => "Geslo",
"Remember me" => "Zapomni si me",
"week" => "teden",
"month" => "mesec",
"year" => "leto",
"Click here to register" => "Klikni tu za registracijo",
"Click here if you've forgotten your password" => "Klikni tu, če ste pozabili vaše geslo",
"I forgot my password" => "Pozabil sem geslo",
"Click here to login using the default security protocol" => "Klikni tu za prijavo z uporabo privzetega varnostnega protokola",
"Click here to login using a secure protocol" => "Klikni tukaj za prijavo s pomočjo varnostnega protokola",
"Secure" => "Varno",
"Stay in ssl Mode" => "Ostani v SSL načinu",
"local account" => "lokalni račun",
"OpenID Login" => "OpenID prijava",
"What is OpenID?" => "Kaj je OpenID?",
"Menu" => "Meni",
"You have" => "Vi imate",
"New Messages" => "Nova sporočila",
"New Message" => "Novo sporočilo",
"You have 0 new messages" => "Nimate novih sporočil",
"Old articles" => "Stari članki",
"Send a message to" => "Pošlji sporočilo na",
"Send a message" => "Pošlji sporočilo",
"Register as a new user" => "Registriraj se kot nov uporabnik",
"Your email could not be validated; make sure you email is correct and click register below." => "Ne morem preveriti veljavnosti vašega e-naslova; preverite pravilnost e-naslova in kliknite spodaj Registriraj.",
"Your registration code:" => "Vaša registracijska koda:",
"Username" => "Uporabniško ime",
"Passcode to register (not your user password)" => "Koda za registracijo (to ni vaše uporabniško geslo)",
"Registration code" => "Registracijska koda",
"Repeat password" => "Ponovi geslo",
"Generate a password" => "Generiraj geslo",
"RSS Feeds" => "RSS viri",
"Blogs RSS" => "Blog RSS",
"Articles RSS" => "Članki RSS",
"Image Galleries RSS" => "Galerije slik RSS",
"Image Galleries" => "Galerije slik",
"File Galleries RSS" => "Galerije datotek RSS",
"File Galleries" => "Galerije datotek",
"Forums RSS" => "Forumi RSS",
"Maps RSS" => "Zemljevidi RSS",
"Maps" => "Zemljevidi",
"Calendars" => "Koledarji",
"Entire Site" => "Celotni strani",
"Wiki Pages" => "Wiki strani",
"Image Gals" => "Galerije slik",
"Images" => "Slike",
"Blog Posts" => "Blogovski zapisi",
"Search Wiki PageName" => "Poišči ime wiki strani",
"Read More" => "Preberite več",
"Since your last visit" => "Od zadnjega obiska",
"Since your last visit on" => "Spremembe od zadnjega obiska na",
"New Images" => "Nove slike",
"Wiki Pages Changed" => "Wiki strani so se spremenile",
"New Files" => "Nove datoteke",
"New Comments" => "Novi komentarji",
"New Tracker Items" => "Nove postavke iskalnikov",
"New Calendar Events" => "Novi dogodki v koledarju",
"New Users" => "Novi uporabniki",
"click to edit" => "Klikni za urejanje",
"Nothing has changed" => "Nič se ni spremenilo",
"Site Language:" => "Jezik strani:",
"Site default" => "Privzeta stran",
"TikiTests Menu" => "Meni TikiTestov",
"List Tests" => "Seznam testov",
"Create Test" => "Ustvari test",
"Most Active blogs" => "najbolj aktivni blogi",
"Top File Galleries" => "Najboljše galerije datotek",
"Top galleries" => "Najboljše galerije",
"The Next Event" => "Naslednji dogodek",
"No Upcoming Events" => "Ni prihajajočih dogodkov",
"click to view" => "klokni za pogled",
"My blogs" => "Moji blogi",
"Bookmarks" => "Zaznamki",
"My galleries" => "Moje galerije",
"My Pages" => "Moje strani",
"User tasks" => "Uporabnikova opravila",
"Done" => "Narejeno",
"Del" => "Izbr",
"Public tasks" => "Javne naloge",
"select" => "izberite",
"User informations" => "Informacije uporabnika",
"Group informations" => "Intormacije skupine",
"You need to activate user and/or group trackers" => "Aktivirati morate uporabnikove in/ali skupinske sledilnike",
"Top users" => "Najbolj aktivni uporabniki",
"Whats related" => "Kaj se nanaša",
"Last `\$module_rows` wiki comments" => "Zadnji `\$module_rows` wiki komentarji",
"Last wiki comments" => "zadnji wiki komentarji",
"Real Name" => "Pravo ime",
"vote" => "glasuj",
"Insert/Edit an internal wiki link" => "Vstavite/Urejajte notranjo wiki povezavo",
"Wiki Link insert" => "Vrivalka wiki povezave",
"Please make a selection of text in order to create a link" => "Prosimo izberite besedilo, da bi lahko ustvaril povezavo",
"Insert an image" => "Vstavite sliko",
"Tiki Image - Insert an image" => "Tiki slika - vstavite sliko",
"Structures:" => "Strukture:",
"show structures" => "prikaži strukture",
"hide structures" => "skrij strukture",
"Manage structures" => "Upravljaj strukture",
"Find:" => "Poišči:",
"pages" => "strani",
"Click Here" => "Klikni tukaj",
"Print" => "Natisni",
"Email This Post" => "Pošlji e-pošto tega zapisa",
"comments" => "komentarj/a/i/ev",
"First page" => "Prva stran",
"Previous page" => "Prejšnja stran",
"page" => "stran",
"Next page" => "Naslednja stran",
"Last page" => "Zadnja stran",
"references" => "reference",
"View Comments" => "Poglej komentarje",
"Blog name" => "Ime bloga",
"Enlarge area height" => "Povečaj površino v višino",
"Reduce area height" => "Zmanjšaj površino v višino",
"Do not group by item" => "Ne grupiraj po postavkah",
"Group by item" => "Grupiraj po postavkah",
"Calendar View" => "Koled. pogled",
"List View" => "Seznam pogledov",
"Tiki Action Calendar" => "Tiki akcijski koledar",
"Tools Calendars" => "Orodja koledarja",
"Check / Uncheck All" => "Potrdi/Ne potrdi vseh",
"Refresh" => "Osveži",
"Tip" => "Namig",
"Cancel Edit" => "Prekliči urejanje",
"Site Ads and Banners" => "Reklame in pasice",
"Content" => "Vsebina",
"Activate" => "Aktiviraj",
"Publish" => "Objavi",
"General" => "Splošno",
"Features" => "Značilnosti",
"Module" => "Modul",
"Meta Tags" => "Meta značke",
"Community" => "Skupnost",
"Freetags" => "Značke",
"User files" => "Uporabnikove datoteke",
"Webmail" => "Spletna pošta",
"Wysiwyg editor" => "Urejevalnik WYSIWYG",
"Rankings" => "Najboljše",
"Title length" => "Dolžina naslova",
"Creation date" => "Datum ustvarjanja",
"Last modified" => "Zadnjič spremenjeno",
"Change settings" => "Spremeni nastavitve",
"Default view mode" => "Privzet pogled",
"First day of the week" => "Prvi dan v tednu",
"Split hours in periods of" => "Razdeli uro v enote po",
"1 minute" => "1 minuto",
"10 minutes" => "10 minute",
"Browse categories" => "Prebrskaj kategorije",
"Enable now" => "Omogoči sedaj",
"Permissions" => "Dovoljenja",
"Admin topics" => "Administriraj teme",
"Admin types" => "Administriraj tipe",
"Topic" => "tema",
"Import CSV file" => "Uvozi CSV datoteko",
"Import" => "Uvozi",
"Visible" => "Vidna",
"Gender" => "Spol",
"User information" => "Uporabnikove informacije",
"Private" => "Privatno",
"public" => "javno",
"Use double-click to edit pages" => "Dvoklikni za urejanje strani",
"Messages per page" => "Sporočil na stran",
"Allow messages from other users" => "Dovoli sporočila drugih uporabnikov",
"never" => "nikoli",
"Apply" => "Apliciraj",
"Newsletters" => "Bilteni",
"Surveys" => "Spletne ankete",
"HTML pages" => "HTML strani",
"Fullscreen" => "Celotni ekran",
"Drawings" => "Risbe",
"Friendship Network" => "Mreža prijateljev",
"Games" => "Igre",
"Stats" => "Statistika",
"Mini Calendar" => "Mini koledar",
"User Watches" => "Uporabnikova opazovanja",
"User Menu" => "Uporabniški meni",
"User Files" => "Uporabnikove datoteke",
"Newsreader" => "Bralnik novic",
"Workflow" => "Delovni tok",
"Home Gallery (main gallery)" => "Domača galerija (glavna galerija)",
"Yes, even in the same gallery" => "Da, celo v isti galeriji",
"Only in different galleries" => "Samo v različnih galerijah",
"Topics" => "Teme",
"You can upload images of a size of " => "Naložiš lahko sliko velikosti ",
"Home Gallery" => "Domača galerija",
"Galleries features" => "Značilnosti galerij",
"Default:" => "Privzeto:",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Odstrani slike v sistemski galeriji, ki se ne uporabljajo na wiki straneh, člankih ali blogih.",
"Mover" => "Prestavitelj",
"All galleries" => "Vse galerije",
"Moved" => "Prestavljeno",
"Parent" => "Starš",
"Home Page" => "Domača stran",
"Minimum {\$prefs.min_pass_length} characters long" => "Dolžina gesla je minimalno {\$prefs.min_pass_length} črk",
"Multilingual structures" => "Večjezikovne strukture",
"Registration" => "Registracija",
"User's choice" => "Uporabnikova izbira",
"Always" => "Vedno",
"Duration" => "Trajanje",
"Theme Control" => "Kontrola tem",
"Template Viewing" => "Pregled tem",
"logged as" => "prijavljen kot",
"Menu ID" => "ID meni",
"Email this page" => "Pošlji to stran po e-pošti",
"Left" => "Levo",
"Right" => "Desno",
"Show categories" => "Pokaži kategorije",
"Feed for articles" => "Vir za članke",
"Feature is disabled." => "Značilnost je onemogočena.",
"Feed for blogs" => "Vir za bloge",
"Individual blogs" => "Individualni blogi",
"Image galleries" => "Galerije slik",
"Feed for image galleries" => "Vir za galerije slik",
"Individual image galleries" => "Posamezne galerije slik",
"Feed for file galleries" => "Vir za galerije datotek",
"Individual file galleries" => "Posamezne galerije datotek",
"Feed for wiki" => "Vir za wikiF",
"Feed for forums" => "Vir za forume",
"Individual forums" => "Posamezni forumi",
"Individual trackers items" => "Posamezne postavke sledilnikov",
"Calendar events" => "Dogodki v koledarju",
"Feed for directory" => "Vir za direktorij",
"Feed for maps" => "Vir za zemljevide",
"Search stats" => "Iskalna statistika",
"Refresh wiki search index now" => "Osveži wiki iskalni indeks",
"Open external links in new window" => "Odpri zunanje povezave v novem oknu",
"AutoLinks" => "AvtoPovezave",
"Required" => "Zahtevano",
"Parameters" => "Parameteri",
"Storage" => "Shranjevanje",
"Change" => "Spremeni",
"No records" => "Ni zapisov",
"Change all to db" => "Spremeni vse v db",
"Change all to file" => "premeni vse v file",
"Quota (Mb)" => "Kvota (Mb)",
"Maximum size for each attachment" => "Maksimalna velikost za vsako priponko",
"Unlimited" => "Neomejeno",
"Create New" => "Ustvari novo",
"Content templates" => "Predloga vsebine",
"Undo" => "Razveljavi (undo)",
"Permission" => "Dovoljenje",
"Allow HTML" => "Dovoli HTML",
"Sandbox" => "Peskovnik",
"Path:" => "Pot:",
"Manage attachments" => "Upravljaj priponkeManage attachments",
"Remove unused pictures" => "Odstrani neuporabljane slike",
"Export" => "Izvozi",
"Export Wiki Pages" => "Izvozi wiki strani",
"HTML diff" => "HTML spr",
"Side-by-side diff" => "Side-by-side spr",
"Side-by-side diff by characters" => "Side-by-side spr po črkah",
"Inline diff" => "Inline spr",
"Inline diff by characters" => "Inline spr po črkah",
"Full side-by-side diff by characters" => "Polna side-by-side spr po črkah",
"Full inline diff" => "Full inline spr",
"Full inline diff by characters" => "Full inline spr po črkah",
"Discuss pages on forums" => "Razpravljaj strani na forumih",
"Forums are disabled." => "Forumi niso omogočeni.",
"Forum for discussion:" => "Forum za razpravo:",
"Similar" => "Podobno",
"Structures" => "Strukture",
"Create webhelp from structure:" => "Ustvari spletno pomoč iz strukture:",
"List pages" => "Seznam strani",
"Name length:" => "Dolžina imena:",
"Wiki attachments" => "Wiki priponke",
"Wysiwyg Editor is optional" => "WYSIWYG urejevalnik je opcija (optional)",
"Contact us" => "Stopi z nami v stik",
"Edit Action" => "Uredi akcijo",
"Save Action" => "Shrani akcijo",
"Statistics" => "Statistika",
"Weeks" => "Tedni",
"Rules" => "Pravila",
"User/IP" => "Uporabnik/IP",
"Sections" => "Sekcije",
"Admin Calendars" => "Admin koledarje",
"List of Calendars" => "Seznam koledarjev",
"Edit Calendar" => "Uredi koledar",
"Participants" => "Udeleženci",
"Add Event" => "Dodaj dogodek",
"Personal Calendar" => "Osebni koledar",
"Start of day" => "Začetek dneva",
"End of day" => "Konec dneva",
"Custom foreground color" => "Običajna osprednja barva",
"Custom background color" => "Običajan barva ozadja",
"Delete events older than:" => "Izbriši dogodke, ki so starejši kot:",
"Current category" => "Trenutna kategorija",
"Current Category ID:" => "ID trenutne kategorije:",
"Child categories" => "Otroška kategorija",
"Edit permissions for this category" => "Uredi dovoljenja za to kategorijo",
"Edit this category:" => "Uredite to kategorijo:",
"Add new category" => "Dodaj novo kategorijo",
"Assign permissions automatically" => "Določi dovoljenja avtomatično",
"recommended for best performance" => "priporočeno za najboljšo učinkovitost",
"Batch upload (CSV file):" => "Paketno nalaganje (CSV datoteka):",
"Objects in category" => "Predmeti v kategoriji",
"Remove from this Category" => "Odstrani iz te kategorije",
"No records found." => "Ni najdenih zapisov.",
"Add objects to category" => "Dodaj objekte v kategorijo",
"Admin chart items" => "Administriraj diagram postavke",
"Edit Chart" => "Uredi diagram (chart)",
"Add or edit an item" => "Dodaj ali uredi postavko",
"Update" => "Posodobi",
"Chart items" => "Predmeti diagrama",
"No items defined yet" => "Še ni definiranih predmetov",
"Admin charts" => "Administriraj diagrame charts",
"Add or edit a chart" => "Dodaj ali uredi diagram",
"Active" => "Aktiven",
"All items" => "Vse postavke (items)",
"Top 10 items" => "Najboljših 10 predmetov",
"Top 20 items" => "Najboljših 20 predmetov",
"Top 40 items" => "Najboljših 40 predmetov",
"Top 50 items" => "Najboljših 50 predmetov",
"Top 100 items" => "Najboljših 100 predmetov",
"Top 250 items" => "Najboljših 250 predmetov",
"Voting system" => "Volilni sistem",
"Admin templates" => "Administriraj predloge",
"Edit this template:" => "Uredite to predlogo:",
"Create new template" => "Ustvari novo predlogo",
"Use wysiwyg editor" => "Uporabi WYSIWYG urejevalnik",
"Use normal editor" => "Uporabi normalni urejevalnik",
"Use in" => "Uporabi v",
"Templates" => "Predloge",
"Admin Contributions" => "Administriraj prispevanja",
"Edit the contribution:" => "Uredi prispevanja:",
"Settings" => "Nastavitve",
"Admin cookies" => "Administriraj piškotke",
"Create/edit cookies" => "Ustvari/uredi piškotke",
"Upload Cookies from textfile" => "Naloži piškotke iz tekstovne datoteke",
"Upload from disk:" => "Naloži z diska:",
"Upload" => "Naloži",
"Remove all cookies" => "Odstrani vse piškotke",
"cookie" => "piškotki",
"View template" => "Poglej predlogo",
"Edit template" => "Uredite predlogo",
"Create/Edit External Wiki" => "Ustvari/uredi zunanji wiki",
"Admin Forums" => "Administriraj forume",
"Create new forum" => "Ustvari nov forum",
"Duplicate forum" => "Dupliciraj forum",
"View this forum" => "Poglej ta forum",
"Import forums" => "Uvozi forume",
"List forums" => "Seznam forumov",
"Edit this Forum:" => "Uredi ta forum:",
"Create New Forum" => "ustvari nov forum",
"There are individual permissions set for this forum" => "za ta forum so nastavljene osebna dovoljenja",
"Prevent flooding" => "Prepreči poplavo",
"Minimum time between posts" => "Minimalni čas med prispevki",
"Section" => "Sekcija",
"Create new" => "Ustvari novo",
"Moderator user" => "Moderator uporabnik",
"Moderator group" => "Moderator skupina",
"Password protected" => "Zaščiteno z geslom",
"Topics only" => "Samo teme",
"All posts" => "Vsi prispevki",
"Forum password" => "Geslo foruma",
"Only allow replies to the first message (flat forum)" => "Dovoli samo odgovore na prvo sporočilo (plosek forum)",
"Send this forums posts to this email" => "Pošlji prispevke s tega foruma na ta e-naslov",
"Prune unreplied messages after" => "Oklesti neodgovorjena sporočila po",
"Prune old messages after" => "Oklesti stara sporočila po",
"Posts can be rated" => "Prispevki se lahko ocenjuje",
"Display last post titles" => "Prikaži zadnje naslove prispevkov",
"no display" => "brez prikaza",
"Send mails even when the post is generated by inbound mail" => "Pošlji pošto celo ko je prispevek generiran z inbound pošto",
"Append a reply link to outbound mails" => "Pripni povezavo v odgovoru na outbound pošto",
"Add messages from this email to the forum" => "Dodaj sporočila s tega e-naslova za e-naslove s tega foruma",
"POP3 server" => "POP3 strežnik",
"Use topic smileys" => "Uporabi smejkote tem",
"Show topic summary" => "Pokaži povzetek teme",
"User information display" => "Prikaz uporabnikovih informacij",
"Online" => "Priključeni (Online)",
"Approval type" => "Tip potrditve",
"All posted" => "Vsi poslani (posted)",
"Queue anonymous posts" => "Postavi v vrsto anonimne prispevke",
"Queue all posts" => "Postavi v vrsto vse prispevke",
"No attachments" => "Brez priponk",
"Everybody can attach" => "Vsakdo lahko pripne",
"Only users with attach permission" => "Samo uporabniki s pripetim dovoljenjem",
"Moderators and admin can attach" => "Modratorji in administratorji lahko pripenjajo",
"Store attachments in:" => "Shrani priponke v:",
"Database" => "Podatkovna baza",
"Max attachment size (bytes)" => "maksimalna velikost priponk(bajti)",
"Max:" => "Maks:",
"Set topics preferences" => "Nastavi prednosti (preferences) tem",
"Show topics preferences" => "Pokaži prednosti (preferences) tem",
"hide topics preferences" => "skrij prednosti (preferences) tem",
"Default ordering for topics" => "Privzeta ureditev tem",
"Date (desc)" => "Datum (pad)",
"Date (asc)" => "Datum (nar)",
"Topics per page" => "Teme na stran",
"Edit this page" => "Uredi to stran",
"View page" => "Poglej stran",
"Apply template" => "Uporabi predlogo",
"Last Modif" => "Zadnja sprem.",
"File name of start page" => "Ime datoteke začetne strani",
"Start page" => "Začetna stran",
"CSS File" => "CSS datoteka",
"Edit rules" => "Uredi pravila",
"New Rule" => "Novo pravilo",
"Copy Rules" => "Kopiraj pravila",
"Configure/Options" => "Konfiguriraj/Opcije",
"Theme control" => "Kontrola tem",
"Admin Topics" => "Administriraj teme",
"Allow attachments" => "Dovoli priponke",
"Check automatically" => "Preveri avtomatično",
"Frequency" => "Frekvenca",
"List menus" => "Seznam menijev",
"Edit this menu" => "Uredite ta meni",
"Edit menu options" => "Uredi opcije menija",
"For wiki page, use ((PageName))." => "Za wiki stran uporabi((ime strani)).",
"Use Ctrl+Click to select multiple groups." => "Uporabi Ctrl+klik za izbiro več skupin.",
"option" => "opcija",
"section level 0" => "nivo sekcija 0",
"section level 1" => "nivo sekcija 1",
"section level 2" => "nivo sekcija 2",
"section level 3" => "nivo sekcija 3",
"sorted section level 0" => "sortirano po nivoju sekcije 0",
"separator" => "ločilnik",
"Choose" => "Izberi",
"Home Image Gal" => "Domača gal. slik",
"Home Image Gallery" => "Domača galerija slik",
"Home File Gal" => "Domača gal. datotek",
"Home File Gallery" => "Domača galerija datotek",
"User preferences" => "Uporabnikove izbirne nastavitve",
"User prefs" => "Uporabnikove izbir. nastavitve",
"List galleries" => "Seznam galerij",
"Upload image" => "Naloži sliko",
"Gallery Rankings" => "Najboljše galerije",
"Browse a gallery" => "Prebrskaj galerijo",
"Articles home" => "Članki dom",
"All articles" => "Vsi članki",
"Submit" => "Predloži",
"List Blogs" => "Seznam blogov",
"Create blog" => "Ustvari blog",
"File galleries" => "Galerije datotek",
"View a forum" => "Poglej forum",
"View a thread" => "Poglej nit(thread)",
"View a FAQ" => "Poglej vprašanja in odgovore",
"Quiz stats" => "Statistika kvizov",
"Menu options" => "Opcije menija",
"Edit this Menu:" => "Uredi ta meni:",
"Create new Menu" => "Ustvari ta meni",
"Options" => "Opcije",
"Active Permissions" => "Aktivna dovoljenja",
"Clear Cache" => "Počisti Cache",
"User Modules" => "Uporabnikovi moduli",
"Left Modules" => "Levi moduli",
"Rows" => "Vrstice",
"Move Up" => "Prestavi gor",
"Move Down" => "Prestavi dol",
"Move to Right Column" => "Prestavi v desno kolono",
"Unassign" => "Od-dodeli (Unassign)",
"Right Modules" => "Desni moduli",
"Move to Left Column" => "Prestavi v levo kolono",
"Assign new module" => "Določi nov modul",
"Edit this assigned module:" => "Uredi ta določen modul:",
"Cache Time" => "Čas za Cache",
"Display Modules to All Groups" => "Prikaži module vsem skupinam",
"Create new user module" => "Ustvari nov uporabniški modul",
"Edit this user module:" => "Uredi ta uporabniški modul:",
"Use Gallery" => "Uporabi galerijo",
"Use Menu" => "Uporabniški meni",
"Use Wiki Structure" => "Uporabi wiki strukturo",
"Data" => "Podatki",
"Send Newsletters" => "Pošlji biltene",
"Add email:" => "Dodajte e-naslov:",
"Add user:" => "Dodajte uporabnika:",
"Admin newsletters" => "Administrirajte biltene",
"Mail notifications" => "Poštne objave (notifications)",
"A user registers" => "Uporabnik se registrira",
"A user submits an article" => "Uporabnik pošlje članek",
"Any wiki page is changed" => "katerakoli wiki stran je spremnjena",
"Any wiki page is changed, even minor changes" => "Katerakoli wiki stran je spremenjena, tudi male spremembe",
"A comment in a wiki page is posted or edited" => "Komentar na wiki strani je dodan ali urejevan",
"0 for no limit" => "0 za brez omejitev",
"Wiki pages" => "Wiki strani",
"Lock the pages" => "Zaklenite strani",
"Admin Quicktags" => "Administracija hitrih značk (Quicktags)",
"Create/Edit QuickTags" => "Ustvari/Uredi hitre značke (QuickTags)",
"Quicktags category filter" => "Filter kategorij hitrih značk (QuickTags)",
"Path to the tag icon" => "Pot do ikone za značko",
"Show Title?" => "Prikaži naslov?",
"View feed" => "Poglej vir",
"Are you sure you want to delete this word?" => "Ste prepričani, da bi radi izbrisali to besedo?",
"The structure" => "Struktura",
"You will remove structure" => "Odstranil boš strukturo",
"Destroy the structure leaving the wiki pages" => "Uniči strukturo a pusti wiki strani",
"Destroy the structure and remove the pages" => "Uniči strukturo in odstrani wiki strani",
"Edit structure" => "Uredi strukturo",
"Export Pages" => "Izvozi strani",
"Create WebHelp" => "Ustvari spletno pomoč",
"View WebHelp" => "Poglej spletno pomoč",
"Create new structure" => "Ustvari novo strukturo",
"Alias" => "Vzdevek (alias)",
"Tree" => "Drevo",
"Use single spaces to indent structure levels" => "Uporabite posamezne presledke za zamikanje nivojev struktur",
"Create New Structure" => "Ustvari novo strukturo",
"List surveys" => "Seznam spletnih anket",
"Survey Stats" => "Statistika ankete",
"Edit this Survey" => "Uredite anketo",
"Admin Surveys" => "Administrirajte anketo",
"Question" => "Vprašanje",
"One choice" => "Ena izbira",
"Multiple choices" => "Mnogovrstna izbira (multiple)",
"Short text" => "Kratko besedilo",
"Admin surveys" => "Administriraj spletne anktete",
"List Surveys" => "Seznam domačih strani",
"Empty" => "Izprazni",
"Investigate" => "Preišči",
"Fix it" => "Popravi",
"Create a new topic" => "ustvari novo ",
"Topic Name" => "Ime teme",
"Upload Image" => "Naloži sliko",
"List of topics" => "Seznam tem",
"Articles (subs)" => "Članki (subs)",
"topic image" => "slika teme",
"Inactive - Click to Activate" => "Neaktiven - kliknite za aktivacijo",
"Deactivate" => "Deaktiviraj",
"Active - Click to Deactivate" => "Aktiven - kliknite za deaktivacijo",
"Remove with articles" => "Odstrani članke",
"List Trackers" => "Seznam sledilnikov",
"Error message:" => "Sporočilo napake:",
"Found" => "Najdeno",
"Filesize" => "Velikost datoteke",
"Filetype" => "Tip datoteke",
"After:" => "Po:",
"Before:" => "Pred:",
"Edit group" => "Uredite skupino",
"Members List" => "Seznam članov",
"Remove from Group" => "Odstrani iz skupine",
"users in group" => "uporabniki v skupini",
"Download CSV export" => "naloži CSV izvoz",
"Assign users to group:" => "Določi uporabnika v skupino:",
"CSV File" => "CSV datoteka",
"Add a New User" => "Dodajte novega uporabnika",
"Updated users" => "Posodobljeni uporabniki",
"Rejected users" => "Zavrnjeni uporabniki",
"Reason" => "Razlog",
"Edit user" => "Uredite uporabnika",
"More Criteria" => "Več kriterijev",
"Group (direct)" => "Skupina (direktno)",
"Edit Account Settings" => "Uredite nastavitve računa",
"Need to validate email" => "Mora preveriti veljavnost e-naslova",
"Change user preferences" => "Spremenite uporabnikove izbirne nastavitve",
"Assign selected to" => "Določi izbrane za",
"Remove selected from" => "Odstrani izbrano iz",
"Use the email as username" => "Uporabi e-naslov za uporabniško ime",
"No password is required" => "Ni zahtevano geslo",
"Overwrite" => "Prepiši",
"Don't overwrite" => "ne prepiši",
"Overwrite groups:" => "Prepiši skupine:",
"Loading..." => "nalaganje...",
"Page has been approved" => "Stran je odobrena",
"New attachments" => "Nove priponke",
"Old attachments" => "Stare priponke",
"Source" => "Vir",
"Group Information" => "Informacije za skupino",
"Create level" => "Ustvari stopnjo (level)",
"Assign User {\$assign_user} to Groups" => "Določi uporabnika {\$assign_user} v skupine",
"Default Group" => "Privzeta skupina",
"Assign Perms to this Group" => "Določi dovoljenja za to skupino",
"Assign User to Group" => "Določi uporabnika v skupino",
"backlinks to" => "povezovanje nazaj v",
"No backlinks to this page" => "Ni povezovanja nazaj na to stran",
"Browse Gallery" => "Prebrskaj galerijo",
"available images" => "razpoložljive slike",
"Select a Gallery" => "Izberi galerijo",
"Select a File Gallery" => "Izberi galerijo datotek",
"Edit Post" => "Uredi prispevek",
"View Blog" => "Poglej blog",
"If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "Če želiš uporabiti slike, prosim shrani prvo zapis in lahko boš urejal/pošiljal slike. Uporabi &lt;img&gt; delček (=majhen del kode HTML ali XML) (snippet) da bi vključil slike v besedilno področje z uporabo WYSIWYG urejevalnika.",
"Use ...page... to separate pages in a multi-page post" => "Uporabi ... stran... za ločevanje strani v večstranskih prispevkih",
"Upload image for this post" => "Naloži sliko za ta prispevek",
"Trash" => "Odpad",
"Mark entry as private:" => "Označi vnos kot privaten:",
"Spellcheck" => "Črkovalnik",
"Save and Exit" => "Shrani in izhod",
"Report to Webmaster" => "Poročajte skrbniku spletišča (Webmaster)",
"Powered by" => "Poganja",
"Made with" => "Narejeno z",
"powered by" => "poganja",
"Execution time" => "Čas izvršitve",
"Memory usage" => "Uporaba spomina",
"Server load" => "Obremenitev strežnika (Server Load)",
"Last update from SVN" => "Zadnja posodobitev iz SVN",
"Watch Only This Category" => "Opazuj samo to kategorijo",
"Watch This Category and Their Descendants" => "Opazuj to kategorijo in njene potomce ",
"Stop Watching Only This Category" => "Prenehaj opazovati to kategorijo",
"Stop Watching This Category and Their Descendants" => "Prenehaj opazovati to kategorijo in njene potomce",
"Admin Category" => "Administriraj kategorijo",
"Admin the Category System" => "Administriraj sistem kategorij",
"Browse in" => "Brskaj v",
"Trackers Items" => "Sledilne postavke",
"in the current category - and its subcategories: " => "v trenutni kategoriji in v njenih podkategorijah: ",
"Hide subcategories objects" => "Skrij objekte podkategorije",
"Show subcategories objects" => "Prikaži objekte podkategorije",
"Upper level" => "Zgornji nivo",
"Browse related tags" => "Brskaj po sorodnih značkah",
"Network of Tags related to" => "Mreža značk, ki so sorodne",
"Clear" => "Počisti",
"With all selected tags" => "Z vsemi izbranimi značkami",
"With one selected tag" => "Z eno izbrano značko",
"With last selected tag" => "Z zadnjo izbrano značko",
"More Popular Tags" => "Več priljubljenih značk",
"Sort:" => "Sortiraj:",
"Alphabetically" => "Po abecedi",
"By Size" => "Po velikosti",
"Cloud" => "Oblak",
"results found" => "najdeni rezultati",
"List Galleries" => "Seznam galerij",
"Edit Gallery" => "Uredi galerijo",
"Rebuild Thumbnails" => "Predelaj (Rebuild) miniaturne sličice (Thumbnails)",
"List Gallery" => "Navedi galerijo",
"All Images" => "Vse slike",
"Monitor this Gallery" => "Spremljaj to galerijo",
"Stop Monitoring this Gallery" => "Prenehaj spremljati to galerijo",
"Sort Images by" => "Sortiraj slike po",
"subgallery" => "podgalerija",
"Subgallery" => "Podgalerija",
"Original Size" => "Originalna velikost",
"rotate right" => "rotiraj desno",
"rotate" => "rotiraj",
"Details" => "Podrobnosti",
"popup" => "pojavno oknopup",
"You can include the image in a tiki page using one of these lines" => "Sliko lahko vključite v tiki stran z uporabo ene od teh vrstic",
"Return to Gallery" => "Nazaj na galerijo",
"Edit Image" => "Uredi sliko",
"First Image" => "Prva slika",
"Prev Image" => "Pred. slika",
"Smaller" => "Manjša",
"Bigger" => "Večja",
"Popup window" => "Pojavno (pop up) okno",
"Next Image" => "Naslednja slika",
"Slideshow Forward" => "Slideshow Naprej",
"Last Image" => "Zadnja slika",
"Cyclic" => "Ciklično",
"Direction" => "Smer",
"Click to zoom" => "Klikni za povečavo",
"Image Name" => "Ime slike",
"Image Scale" => "Skala slike",
"Move image" => "Prestavi sliko",
"You can view this image in your browser using" => "To sliko lahko vidite v vašem brskalniku z uporabo",
"You can include the image in an HTML page using one of these lines" => "Sliko lahko vključite v HTML stran z uporabo ene od teh vrstic",
"Stop Monitoring this Page" => "Prenehaj opazovati to stran",
"Monitor this Page" => "Opazuj to stran",
"Visible Calendars" => "Vidni koledarji",
"Click to select visible calendars" => "Klikni za izbiro vidnosti koledarjev",
"Group Calendars" => "Koledarji skupin",
"Edit event" => "Uredi dogodek",
"View event" => "Poglej dogodek",
"Organized by" => "Organizira",
"Tentative" => "Nameravan",
"Confirmed" => "Potrjen",
"Cancelled" => "Odpovedan",
"Change Focus" => "Spremeni fokus",
"Calendar Item" => "Postavka v koledarju",
"New event" => "Novi dogodek",
"Edit Calendar Item" => "Uredite postavko koledarja",
"New Calendar Item" => "Nova postavka v koledarju",
"End" => "Konec",
"Date and time of end" => "Datum in čas zaključka",
"or new" => "ali nov",
"Roles" => "Vloge",
"chair" => "predsednik",
"default role" => "privzeta vloga",
"required participant" => "zahtevan udeleženec",
"optional participant" => "opcijski udeleženec",
"non participant" => "ne udeleženec",
"Calendar import" => "Uvoz koledarja",
"Calendar has been updated" => "Koledar je bil posodobljen",
"Previous" => "Prejšnji",
"Assign permissions to category" => "Določi dovoljenja kategoriji",
"Remove from this Category Only" => "Odstrani samo iz te kategorije",
"Remove from this Category &amp; all its Children" => "Odstrani samo iz te kategorije &amp; in njenih otrok",
"Perform action with checked" => "Izvedi to akcijo ko označim",
"Assign permissions" => "Določi dovoljenja",
"to group" => "skupini",
"Click here to send us an email" => "Klikni tu za pošiljanje e-pošte",
"Contacts" => "Stiki",
"Create/edit contacts" => "Ustvari/uredi stike",
"First Name" => "Ime",
"Publish this contact to groups" => "Objavi ta stik v skupini",
"Last Name" => "Priimek",
"Structure" => "Struktura",
"Top page" => "Vrh strani",
"Edit a site" => "Uredi stran(site)",
"Add a site" => "Dodaj stran(site)",
"Validate" => "Preveri (Validate)",
"hits (desc)" => "zadetki (padajoče)",
"hits (asc)" => "zadetki (naraščajoče)",
"Added" => "Dodano",
"Search results" => "Rezultati iskanja",
"Edit article" => "Uredi članek",
"List Articles" => "Seznam člankov",
"View Articles" => "Poglej članke",
"One of the email addresses you typed is invalid" => "Eden od e-naslovov je neveljaven",
"Subtitle" => "Podnaslov",
"Author Name" => "Ime avtorja",
"Own Image" => "Lastna slika",
"Article image" => "Slika v članku",
"Use own image" => "Uporabi svojo sliko",
"Float text around image" => "Plavajoče besedilo okoli slike",
"Own image size x" => "Velikost lastne slike x",
"Own image size y" => "Velikost lastne slike y",
"Image caption" => "Napis pod sliko",
"Heading" => "Naslov",
"Body" => "Telo besedila",
"Publish Date" => "Datum objave",
"Expiration Date" => "Končni rok",
"Emails to be notified (separated with commas)" => "E-naslovi, ki bodo obveščeni (loči z vejivami)",
"From date" => "Od datuma",
"To date" => "Do datuma",
"Use dates" => "Uporabi datume",
"Show the banner only in this hours" => "Pokaži pasico samo v teh urah",
"Show the banner only on" => "Pokaži pasico samo v",
"Mon" => "Pon",
"Tue" => "Tor",
"Wed" => "Sre",
"Thu" => "Čet",
"Fri" => "Pet",
"Sat" => "Sob",
"Sun" => "ned",
"Create Blog" => "Ustvari blog",
"Wiki Help" => "Wiki pomoč",
"Title bar" => "Naslovna vrstica",
"No description available" => "Opis ni na voljo",
"wiki link'" => "wiki povezava'",
"Browse Images" => "Prebrskaj slike",
"Edit successful!" => "Uspešno urejanje!",
"Image Description" => "Opis slike",
"Upload from disk to change the image:" => "Naloži z diska, da bi spremenili sliko:",
"Save and Go Next" => "Shrani in pojdi naprej",
"Shortname" => "Kratko ime",
"like" => "kot",
"Longname" => "Dolgo ime",
"Add a translation" => "Dodaj prevod",
"Translation" => "Prevod",
"Return to block listing" => "Nazaj na blogovski izpis",
"List Quizzes" => "Seznam kvizov",
"Maximum time" => "Maksimalni čas",
"Answer" => "Odgovor",
"Modify Structure" => "Spremeni strukturo",
"You will remove" => "Odstranili boste",
"and its subpages from the structure, now you have two options:" => "in njene podstrani iz strukture, sedaj imete dve možnosti:",
"and its subpages from the structure" => "in njene podstrani iz strukture",
"Remove only from structure" => "Odstrani samo iz strukture",
"Remove from structure and remove page too" => "Odstrani iz strukture in tudi odstrani stran",
"The page already exists. The page that has been added to the structure is the existing one." => "Stran že obstaja. Stran, ki je bila dodana strukturi je obstoječa.",
"The following pages added have automatically been categorized with the same categories as the structure:" => "Naslednje strani, ki so bile dodane so avtomatsko kategorizirane z istimi kategorijami kot struktura:",
"Structure Layout" => "Razporeditev strukture",
"Monitor the Sub-Structure" => "Nadziraj podstrukturo",
"Stop Monitoring the Sub-Structure" => "Prenehaj nadzirati pod-strukturo",
"Promote" => "Povišaj",
"Demote" => "Ponižaj",
"Current Node" => "Sedanje vozlišče",
"Page alias" => "Vzdevek strani",
"Move in this structure" => "Prestavi v tej strukturi",
"Move to another structure" => "Prestavi v drugo strukturo",
"at the beginning" => "na začetku",
"at the end" => "na koncu",
"Add pages to current node" => "Dodaj strani na sedanje vozlišče",
"After page" => "Po strani",
"Create Page" => "Ustvari stran",
"Use pre-existing page" => "Uporabi pred-obstoječo stran",
"Categorize all pages in structure together" => "Kategoriziraj vse strani v strukturi",
"Submit article" => "Pošlji članek",
"<b>*</b>=optional" => "<b>*</b>=opcija",
"Edit templates" => "Uredite predloge",
"Your edit session will expire in" => "Urejanje bo poteklo v ",
"Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits." => "Urejanje bo poteklo v 1 minuti. Klikni <strong>Predogled</strong> ali <strong>Shrani</strong>, da bi spet pognal uro od začetka.",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "Peskovnik je stran kjer lahko vadiš urejanje (uporabiš lahko vse funkcije). Uporabi Predogled, da vidiš kako stran izgleda. Nobena verzija se ne shrani za to stran.",
"This edit session will expire in {\$edittimeout} minutes" => "Urejanje bo poteklo v {\$edittimeout} minutah",
"<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer." => "Klikni <strong>Predogled</strong> ali <strong>Shrani</strong> da bi spet pognal uro od začetka.",
"Admin Content Templates" => "Administratorjeve vsebinske predloge",
"My Footnotes" => "Opombe v nogi",
"Year:" => "Leto:",
"Authors:" => "Avtorji:",
"Import page" => "Uvozi stran",
"export all versions" => "Izvozi vse verzije",
"Upload picture" => "Naloži sliko",
"License" => "Licenca",
"Important" => "Pomembno",
"Lock this page" => "Zaklenite to stran",
"All fields" => "Vsa polja",
"Dump" => "Odlagališče",
"List FAQs" => "Seznam vprašanj in odgovorov (FAQs)",
"Upload File" => "Naloži datoteko",
"Create New File Gallery" => "Ustvari novo galerijo datotek",
"You can access the file gallery using the following URL" => "Lahko dostopš do galerije datotek z uporabo sledečega URL",
"Admin forums" => "Administriraj forume",
"Import from a Local SQL File" => "Uvozi iz lokalne SQL datoteke",
"Forum Type" => "Tip foruma",
"Edit queued message" => "Uredi sporočila v vrsti",
"Search in content" => "Iščite v vsebini",
"Hours" => "Ure",
"Started" => "Začetek",
"Admin processes" => "Proces administriranja",
"Galleries" => "Galerije",
"Create New Gallery" => "Ustvari novo galerijo",
"Create a gallery" => "Ustvari galerijo",
"Edit this gallery:" => "Uredi to galerijo:",
"There are individual permissions set for this gallery" => "Individualna dovoljenja, ki so nastavljena za to galerijo",
"Geographic" => "Geografsko",
"Fields to show during browsing the gallery" => "Polja, ki se pokažejo med brskanjem po galeriji",
"Other users can upload images to this gallery" => "Drugi uporabniki lahko nalagajo slike v to galerijo",
"Locked" => "Zaklenjeno",
"Go Back" => "Pojdi nazaj",
"Last Changes" => "Zadnje spremembe",
"Rollback" => "Povrni na to verzijo",
"Pages like" => "Strani kot",
"No pages found" => "Ni najdenih strani",
"Edit New Article" => "Uredi nov članek",
"Your comment" => "Vaš komentar",
"Upload a game" => "Naloži igro",
"Upload a new game" => "Naloži novo igro",
"Edit game" => "Uredi igro",
"Edit Blog" => "Uredite blog",
"Blog Title" => "Naslov bloga",
"Distance (km)" => "Razdalja (km)",
"List Movies" => "Seznam filmov",
"Choose a movie" => "Izberi film",
"Last mod" => "Zadnja sprememba",
"Last modification" => "Zadnja sprememba",
"Page creator" => "ustvarjalec strani",
"Last author" => "Zad. avtor",
"Last version" => "Zadnja verzija",
"Last ver." => "Zad.ver.",
"Status of the page" => "Status strani",
"Vers." => "Verz.",
"Links to other items in page" => "Povezave na druge postavke na strani",
"Links to this page in other pages" => "Povezave na to stran in druge strani",
"Page size" => "Velikost strani",
"unlocked" => "nezaklenjen",
"Open client window" => "Odpri okno klienta",
"Generate HTML" => "Generiraj HTML",
"Operator" => "Operater",
"since" => "od",
"Remove old events" => "Odstrani stare dogodke",
"duration" => "trajanje",
"Mini Calendar: Preferences" => "Mini koledar: izbirne nastavitve",
"Calendar Interval in daily view" => "Koledarski intervali v dnevnem pogledu",
"Start hour for days" => "Ure začetka dni",
"End hour for days" => "Ura konca dni",
"Reminders" => "Opomniki",
"no reminders" => "brez opomnikov",
"Or enter path or URL" => "Ali vnesi pot ali URL",
"Add Topic" => "Dodaj temo",
"User Pages" => "Uporabnikove strani",
"User Galleries" => "Uporabnikove galerije",
"Tasks" => "Opravila",
"MyTiki" => "Moj Tiki",
"My Infos" => "Moje informacije",
"Notepad" => "Beležnica",
"MyFiles" => "Moje datoteke",
"My Contacts" => "Moji stiki",
"My Wiki Pages" => "Moje wiki strani",
"My Galleries" => "Moje galerije",
"My Tracker Items" => "Moj postavke sledilnikov",
"My Messages" => "Moja sporočila",
"My Tasks" => "Mojzadolžitve",
"Sent editions" => "Pošlji izdaje (editions)",
"The newsletter was sent to {\$sent} email addresses" => "Bilten je bil poslan {\$sent} e-poštne naslove",
"Errors:" => "Napake:",
"Delete errors" => "Izbriši napake",
"Not sent" => "Ni poslano",
"Available Newsletters" => "Dostopni bilteni",
"Notes" => "Opomba",
"Write a note" => "Napiši opombo",
"List notes" => "Seznam opomb",
"Write note" => "Napiši opombo",
"Wiki Create" => "Wiki ustvari",
"Wiki Overwrite" => "Wiki prepiši",
"Added:" => "Dodan:",
"Removed:" => "Odstranjen:",
"Assign permissions to " => "Določi dovoljenja v ",
"View Permissions" => "Poglej dovoljenja",
"Edit Permissions" => "Uredi dovoljenja",
"Assign permissions to this object" => "Določi dovoljenja za ta objekt",
"Perms Help" => "Pomoč za dovoljenja",
"Published" => "Objavljeno",
"Your OpenID identity is valid" => "Tvoj OpenID identiteta je veljavna",
"Create a new Tikiwiki account from OpenID" => "Ustvari nov Tikiwiki račun iz OpenID",
"Select account" => "Izberi račun",
"Orphan Pages" => "Osirotele strani",
"Browser not supported" => "Brskalnik ni podprt",
"Rename" => "Preimenuj",
"Make Structure" => "Naredi strukturo",
"Slides" => "Diapozitivi (slides)",
"Discuss" => "Diskutiraj",
"Attach File" => "Pripni datoteko",
"1 File Attached" => "1 pripeta datoteka",
"{\$atts|@count} files attached" => "{\$atts|@count} pripete datoteke",
"Preview of version" => "Predogled verzije",
"(current)" => "(trenutna)",
"Rollback to this version" => "Povrni na to verzijo",
"Source of version" => "Vir verzije",
"s=source" => "s=vir",
"b=rollback" => "b=povrni",
"Updated from" => "Posodobljena iz",
"Used to update" => "Uporabljena za posodobitev",
"Update Translation" => "Posodobljen prevod",
"Hide translation history" => "Skrij zgodovino prevajanja",
"Show translation history" => "Pokaži zgodovino prevajanja",
"Avatar:" => "Podoba (avatar):",
"Pick your avatar" => "Izberi podobo (avatarja)",
"User Preferences" => "Uporabnikove izbirne nastavitve",
"Your current avatar" => "vaša trenutna podoba (avatar)",
"no avatar" => "brez podobe (avatarja)",
"reset" => "ponovno nastavi",
"Pick avatar from the library" => "Izberi podobo (avatarja) iz knjižnice",
"Pick user Avatar" => "Izberi uporabnikovo podobo(avatarja)",
"Hide all" => "Skrij vse",
"icons" => "ikone",
"Show all" => "Prikaži vse",
"Avatar Image" => "Slika podobe (Avatar Image)",
"Upload your own avatar" => "Naloži svojega avatarja",
"Insert" => "Vstavi",
"Average" => "Povprečje",
"Plugin" => "Vtičnik",
"Note: Remember that this is only a preview, and has not yet been saved!" => "Opozorilo: Vedi, da je to samo predogled in ni bil shranjen!",
"on:" => "na:",
"Topic image" => "Slika teme",
"Viewing blog post" => "Gledanje zapisa na blogu",
"Return to blog" => "Nazaj na blog",
"Selected Structures" => "Izbrane strukture",
"Add Structure" => "Dodaj strukture",
"No structures" => "Brez struktur",
"Add Pages" => "Dodaj strani",
"No pages" => "Brez strani",
"Use Ctrl+Click to select multiple pages" => "Uporabi Ctrl+Click za izbiro več strani",
"Add Page" => "Dodaj stran",
"Add Pages from Structures" => "Dodaj strani iz struktur",
"Add Structure Pages" => "Dodaj strukturne strani",
"Selected Pages" => "Izbrane strani",
"No pages selected." => "Ni izbranih strani.",
"Edit quiz" => "Uredi kviz",
"General Options" => "Splošne možnosti",
"Name:" => "Ime:",
"Publication Date" => "Datum objave",
"at " => "pri ",
"Use " => "Uporabi ",
"Question:" => "Vprašanje:",
"Top 10" => "Najboljših 10",
"Top 20" => "Najboljših 20",
"Top 50" => "Najboljših 50",
"Top 100" => "Najboljših 100",
"star" => "zvezda",
"half star" => "polzvezda",
"Send a link" => "Pošlji povezavo prijatelju",
"Received articles" => "Prejeti članki",
"Edit received article" => "Urejaj prejete članke",
"Use Image" => "Uporabi sliko",
"Image x size" => "Slika x velikost",
"Image y size" => "Slika y velikost",
"Image name" => "Ime slike",
"Accept Article" => "Sprejmi članek",
"Site" => "Stran",
"Received Pages" => "Prejete strani",
"Edit Received Page" => "Uredi prejeto stran",
"The highlight pages already exist." => "Označene strani že obstajajo.",
"Please, change the name if you want the page to be uploaded." => "Prosimo, zamenjajte ime, če želite, da se slika naloži.",
"Received Structures" => "Prejete strukture",
"A valid email is mandatory to register" => "Za registracijo je potreben veljaven e-naslov",
"Select your group" => "Izberi svojo skupino",
"NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter!" => "Vstavi svoj aktivni e-naslov.",
"Tiki site registered" => "Tiki stran registrirana",
"The following site was added and validation by admin may be needed before appearing on the lists" => "Ta stran je bila dodana in validacija administratorja je potrebna preden se pojavite na seznamih",
"You don't have permission to use this feature." => "Nimate dovoljenja uporabljati te značilnosti (feature).",
"Please register." => "Prosim registrirajte se.",
"Register this site at tikiwiki.org" => "Registriraj to stran pri tikiwiki.org",
"Read this first!" => "Najprej preberi tole!",
"Registering is voluntary." => "Registracija je prostovoljna.",
"If your site is private or inside your intranet, you should not register!" => "Če je to vaša privatna stran ali stran znotraj intraneta, se ne smete registrirati!",
"Information about your site" => "Informacije o vaši strani",
"Enter your username or email." => "Vnesi uporabniško ime ali e-naslov.",
"Send me my Password" => "Pošlji mi geslo",
"Request Password Reset" => "Zahtevaj ponovno nastavljanje gesla",
"Remove page" => "Odstrani stran",
"Last Version" => "Zadnja verzija",
"You are about to remove the page" => "Odstranili boste stran",
"permanently" => "za stalno",
"Remove all versions of this page" => "Odstranite vse verzije te strani",
"Rollback page" => "Stran povrni nazaj (Rollback)",
"Searched" => "Iskano",
"Search in" => "Išči v",
"Faqs" => "Vprašanja in odgovori (Faqs)",
"Simple search" => "Preprosto iskanje",
"No pages matched the search criteria" => "Nobena stran ne ustreza iskanim kriterijem",
"Send blog post" => "Pošlji blogovske prispevke",
"A link to this post was sent to the following addresses:" => "Povezava na prispevek je bila poslana na ta naslov:",
"Send post to this addresses" => "Pošlji prispevek na ta naslov",
"List of email addresses separated by commas" => "Seznam e-naslovov ločen z vejicami",
"Please Confirm" => "Prosim potrdi",
"This newsletter will be sent to {\$subscribers} email addresses." => "Ta bilten bo poslan na {\$subscribers} e-poštne naslove.",
"Prepare a newsletter to be sent" => "Pripravi bilten za pošiljanje",
"Save as Draft" => "Shranite kot osnutek",
"Send objects" => "Pošlji objekte",
"Send Wiki Pages" => "Pošlji wiki strani",
"Send a structure" => "Pošlji strukture",
"Send Articles" => "Pošlji članke",
"Add Article" => "Dodaj članek",
"Send objects to this site" => "Pošlji objekte na to stran",
"Parent page" => "Starševska stran",
"Child" => "Otrok",
"Last edited by" => "Zadnji urejal",
"based on work by" => "temelji na delu",
"Contributors to this page" => "Prispevali na to stran",
"Most viewed objects" => "Najbolj gledano",
"Most viewed objects in the last 7 days" => "Najbolj gledano v zadnjih 7 dneh",
"Site Stats" => "Statistika strani",
"Total pageviews" => "Skupno število ogledov strani",
"Average pageviews per day" => "Povprečno število pogledov na dan",
"Best day" => "Najboljši dan",
"Worst day" => "Najslabši dan",
"Wiki Stats" => "Wiki statistika",
"Size of Wiki Pages" => "Velikost wiki strani",
"Average page length" => "Povprečna dolžina strani",
"Average versions per page" => "Povprečno število verzij na stran",
"Visits to wiki pages" => "Obiski wiki strani",
"Orphan pages" => "Osirotele strani",
"Average links per page" => "Povprečno število povezav na stran",
"Image galleries Stats" => "Statistika galerij slik",
"Average images per gallery" => "Povprečje slik na galerijo",
"Total size of images" => "Skupna velikost slik",
"Average image size" => "Povprečna velikost slik",
"Visits to image galleries" => "Obiski galerij slik",
"File galleries Stats" => "Statistika galerij datotek",
"Average files per gallery" => "Povprečje datotek na galerijo",
"Total size of files" => "Skupna velikost datotek",
"Average file size" => "Povprečna velikost datoteke",
"Visits to file galleries" => "Obiski galerij datotek",
"CMS Stats" => "CMS statistika",
"Total reads" => "Skupno število obledov",
"Average reads per article" => "Poprečno število ogledov na članek",
"Total articles size" => "Skupna velikost člankov",
"Average article size" => "Povprečna velikost članka",
"Forum Stats" => "Statistika forumov",
"Total topics" => "Skupno število tem",
"Average topics per forums" => "Povprečje tem na forum",
"Total replies" => "Skupno število odgovorov",
"Average number of replies per topic" => "Povprečno število odgovorov na temo",
"Visits to forums" => "Število obiskov na forumih",
"Blog Stats" => "Statistika blogov",
"Weblogs" => "Blogi",
"Total posts" => "Skupno število prispevkov",
"Average posts per weblog" => "Povprečje število prispevkov na blog",
"Total size of blog posts" => "Skupna velikost prispevkov na blogih",
"Average posts size" => "Povprečna velikost prispevka",
"Visits to weblogs" => "Skupno število obiskov na blogih",
"Poll Stats" => "Statistika spletnih anket",
"Total votes" => "Skupno število glasov",
"Average votes per poll" => "Povprečno število glasov na spletno anketo",
"FAQ Stats" => "Statistika vprašanj in odgovorov (FAQ)",
"Total questions" => "Skupno število vprašanj",
"Average questions per FAQ" => "Povprečno število vprašanj na FAQ",
"User Stats" => "Statistika uporabnikov",
"User bookmarks" => "Zaznamki uporabnikov",
"Average bookmarks per user" => "Povprečje zaznamkov na uporabnika",
"Average questions per quiz" => "Povprečno število vprašanj na kviz",
"Quizzes taken" => "Odgovorjeni kvizi",
"Average quiz score" => "Povprečen rezultat v kvizu",
"Average time per quiz" => "Povprečen čas za kviz",
"Usage chart" => "Grafikoni uporabe",
"Usage chart image" => "Slika grafikonov uporabe",
"Thank you for your submission" => "Hvala za vašo predložitev",
"Send a link to a friend" => "Pošlji povezavo prijatelju",
"Your email was sent" => "Vaša e-pošta je bila poslana",
"The link was sent to the following addresses:" => "Povezava je bila poslana na te naslove:",
"Friend's email" => "E-naslov prijatelja",
"Separate multiple email addresses with a comma." => "Več naslovov ločite z vejico.",
"Your name" => "Vaše ime",
"Your email" => "Vaš e-naslov",
"I found an interesting page that I thought you would like." => "Našel sem zanimivo stran, za katero se mi zdi da bi te utegnila zanimati.",
"TikiTests Edit" => "Urejanje Tiki testa",
"Show Page Differences" => "Pokaži razlike strani",
"Use Current Session/Logout" => "Uporabi trenutno sejo/odjavo",
"Assign themes to categories" => "Določi teme za kategorije",
"Assigned categories" => "Določene kategorije",
"Assign themes to objects" => "Določi teme objektom",
"Assigned objects" => "Določeni objekti",
"Assign themes to sections" => "Določi teme v sekcije",
"Assigned sections" => "Določene sekcije",
"Edit File:" => "Uredite datoteko:",
"Additional Info" => "Dodatne informacije",
"You locked the file" => "Zaklenil si datoteko",
"The file is locked by {\$fileInfo.lockedby}" => "Datoteko je zaklenil {\$fileInfo.lockedby}",
"No gallery available." => "Ni galerije.",
"You have to create a gallery first!" => "Najprej moraš ustvariti galerijo!",
"Batch Upload Results" => "Rezultati paketnega (batch) nalaganja",
"Upload successful!" => "Nalaganje je bilo uspešno!",
"The following image was successfully uploaded" => "Slika je bila uspešno naložena",
"Image ID thumb" => "ID slike thumb",
"You can include the image in an Wiki page using" => "Lahko vključiš sliko v wiki stran s pomočjo",
"or use filename" => "ali uporabi ime datoteke",
"Now enter the image URL" => "Sedaj vnesi URL slike",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Miniaturna sličica (Thumbnail) (opcija, povozi avtomatsko generiranje miniaturne sličice (thumbnail))",
"Note: Maximum image size is limited to" => "Opomba: Maksimalna velikost slike je omejena na",
"User assigned modules" => "Moduli, ki jih je določil uporabnik",
"Assign module" => "Določi modul",
"Column" => "Kolona",
"Current folder" => "Trenutna mapa",
"Folders" => "Mape",
"Folder in" => "Mape v",
"Remove Folder" => "Odstrani mapo",
"Refresh Cache" => "Osveži Cache",
"Admin folders and bookmarks" => "Administriraj mape in zaznamke",
"a folder" => "mapa",
"a URL" => "URL",
"User Contacts Preferences" => "Uporabnikove izbire za kontakte",
"Manage Fields" => "Upravljaj polja",
"Send me a message" => "Pošlji sporočilo",
"Assign Group" => "Določi skupino",
"Homepage" => "Domača stran",
"Users HomePage" => "Domača stran uporabnika",
"Personal Wiki Page" => "Osebna wiki stran",
"Create page" => "Ustvari stran",
"System" => "Sistem",
"This user is your friend" => "Ta uporabnik je prijatelj",
"Your personal Wiki Page" => "Tvoja osebna wiki stran",
"Note author when reading his mail" => "Obvesti avtorja ko preberem njegovo e-pošto",
"Current password (required)" => "Trenutno geslo (zahtevano)",
"Edit task" => "Uredite nalogo(task)",
"NOT accept" => "NI sprejeto",
"Remove from Trash" => "Odstranite iz odpada",
"Move into Trash" => "Prestavite v odpad",
"Edit Task" => "Uredite nalogo(task)",
"All Shared Tasks" => "Vse skupne (shared) naloge",
"Use \"watches\" to monitor wiki pages or other objects." => "Uporabi \"Opazovanja\" za spremljanje wiki strani ali drugih objektov.",
"Watch new items by clicking the {icon _id=eye} button on specific pages." => "Opazuj novosti tako da kliknete {icon _id=eye} gumb na željenih straneh.",
"Add Watch" => "Dodaj opazovanje",
"Watches" => "Opazovanja",
"A user submits a blog post" => "Uporabnik predloži blogovski zapis",
"A user posts a forum thread" => "Uporabnik pošlje forum nit (thread)",
"A user posts a forum topic" => "Uporabnik pošlje temo na forum",
"A user edited a wiki page" => "Uporabnik je urejal wiki stran",
"A user created a wiki page in a language" => "Uporabnik je ustvaril wiki stran v jeziku",
"Used space:" => "Uporabljen prostor:",
"up to" => "do",
"Proceed at your own peril" => "Nadaljuj na svoj peril",
"Remove Row" => "Odstrani vrstico",
"Remove Column" => "Odstrani kolono",
"Weekdays" => "Dnevi v tednu",
"mon" => "pon",
"tue" => "tor",
"wed" => "sre",
"thu" => "čet",
"fri" => "pet",
"sat" => "sob",
"sun" => "ned",
"Editing posts" => "Urejanje prispevkov",
"Move Selected Topics" => "Prestavi izbrane teme",
"Lock Selected Topics" => "Zaklenite izbrane teme",
"posts in this forum" => "prispevkov v tem forumu",
"Show posts" => "Pokaži prospevke",
"Edit/Delete" => "Uredite/Izbrišite",
"Add a Comment" => "Dodajte komentar",
"close" => "zapri",
"Show All" => "Pokaži vse",
"Reply To All" => "Odgovori vsem",
"page id" => "stran id",
"3d browser" => "3d brskaljnik",
"Jump to Content" => "Skočite na vsebino",
"Cancel Fullscreen" => "Prekliči celotni ekran",
"Show/Hide Left Menus" => "Pokaži/Skrij levi meni",
"Show/Hide Right Menus" => "Pokaži/Skrij desni meni",
"Remove Image" => "Odstrani sliko",
"Other:" => "Drugo:",
"Categories:" => "Kategorije:",
"Start:" => "Začetek:",
"Close:" => "Zapri:",
"List authors:" => "Seznam avtorjev:",
"Preview your changes." => "Predogled sprememb.",
"Save the page, but do not send notifications and do not count it as new content to be translated." => "Shrani stran, toda ne pošlje obvestil in ne šteje kot novo vsebino, ki jo je treba prevesti.",
"Save the page." => "Shrani stran.",
"Save the page as a draft." => "Shranite stran kot osnutek.",
"Save Draft" => "Shrani osnutek",
"Cancel the edit, you will lose your changes." => "Preklic urejanja strani pomeni izgubo sprememb.",
"Compose Message" => "Sestavi sporočilo",
"Separate multiple usernames with a comma (&nbsp;,&nbsp;)." => "Loči uporabniška imena z vejicami (&nbsp;,&nbsp;).",
"Wiki settings" => "Wiki nastavitve",
"Wiki Attachments" => "Wiki priponke",
"RSS settings" => "RSS nastavitve",
"Freetags settings" => "Nastavitve značk",
"Click here to delete the category:" => "Klikni tu za brisanje kategorije:",
"Upload failed" => "Nalaganje ni bilo uspešno",
"Detected, Version:" => "Najdena, Verzija:",
"Not detected." => "Ni najdena.",
"Error opening uploaded file" => "Napaka pri odpiranju naložene podatkovne datoteke",
"Invalid email" => "Neveljaven e-naslov",
"You need to provide a username or an email" => "Morate priskrbeti uporabniško ime ali e-naslov.",
"unsafe" => "nevarno (unsafe)",
"safe" => "varno",
"File upload" => "Nalaganje datotek",
"File is not readable. Unable to check." => "Datoteke se ne da prebrati. Ne morem preveriti.",
"This file is from another Tikiwiki version: " => "Ta datoteka je iz druge Tikiwiki verzije: ",
"You have to provide a word" => "zagotoviti moraš besedo",
"Permission denied you cannot view this page" => "Nimate dovoljenja gledati te strani",
"Permission denied you cannot edit this page" => "Nimaš dovoljenja urejati te strani",
"You must specify a page name, it will be created if it doesn't exist." => "Napisati moraš ime strani. Bo ustvarjena, če še ne obstaja.",
"page not added (Exists)" => "stran ni dodana (že obstaja)",
"No Errors detected" => "Ni najdenih napak.",
"Group already exists" => "Skupina že obstaja",
"Remove group: " => "Odstrani skupino: ",
"Remove permission: %s on %s" => "Odstrani dovoljenje: %s na %s",
"User doesn't exist" => "Uporabnik ne obstaja",
"Invalid or unknown email" => "neveljaven ali nepoznan e-naslov",
"User login or email is required" => "Zahtevano je uporabniško ime ali e-naslove",
"User login is required" => "Zahtevana je prijava uporabnika",
"Password is required" => "Zahtevano je geslo",
"Email is required" => "Zahtevan je e-naslov.",
"User is duplicated" => "Uporabnik je podvojen",
"Upload was successful" => "Nalaganje je bilo uspešno",
"Top visited blogs" => "Najbolj obiskani blogi",
"Last posts" => "Zadnji prispevki",
"Top active blogs" => "Najbolj aktivni blogi",
"Tiki RSS feed for blog: " => "Tiki RSS vir za blog: ",
"Last modifications to the blog." => "Zadnje spremembe v blogu.",
"Nothing tagged yet" => "Nič še ni označkano",
"Access Denied" => "Dostop noi dovoljen",
"End:" => "Konec:",
"Invalid username or activation code. Maybe this code has already been used." => "Neveljavno uporabniško ime ali aktivacijska koda. Morda je bila ta koda že uporabljena.",
"You can not use the same password again" => "Ne smete ponovno uporabiti enakega gesla",
"Invalid old password or unknown user" => "Neveljavno staro geslo ali nepoznan uporabnik",
"Top authors" => "Najboljši avtorji",
"Account validated successfully." => "Uporabniški račun je uspešno preverjen.",
"This feature has been disabled" => "Ta lastnost (feature) je bila onemogočena.",
"Last sites." => "zadnje strani.",
"Must enter a name to add a site. " => "Morate vstaviti ime, da bi dodali stran. ",
"Must enter a url to add a site. " => "Morate dodati URL, da bi dodali stran. ",
"Article not found" => "Članek ni najden",
"Permission denied you cannot edit this article" => "Nimate dovoljenja za urejanje tega članka",
"The SandBox is disabled" => "Peskovnik je onemogočen",
"Cannot edit page because it is locked" => "Ne moreš urejati strani, ker je zaklenjena",
"Page already exists. Go back and choose a different name." => "Stran že obstaja. Pojdi nazaj in izberi drugo ime.",
"Remove archive: " => "Odstrani arhiv: ",
"Remove file gallery: " => "Odstrani galerijo podatkovnih datotek: ",
"Permission denied you cannot edit this file" => "Nimaš dovoljenja urejati te datoteke",
"Permission denied you cannot remove files from this gallery" => "Nimaš dovoljenja odstraniti datoteke iz te galerije",
"Top visited file galleries" => "Najbolj obiskane galerije",
"Most downloaded files" => "Najbolj nalagane datoteke",
"Last files" => "Zadnje datoteke",
"Tiki RSS feed for file galleries" => "Tiki RSS vir za galerija datotek",
"Last files uploaded to the file galleries." => "Zadnje naložene datoteke v galerije datotek.",
"No galleryId specified" => "Ni specifiziran Id galerije",
"Tiki RSS feed for the file gallery: " => "Tiki RSS vir za galerijo podatkovnih datotek: ",
"Forum posts" => "Prispevki na forumu",
"first uploaded image" => "prva naložena slika",
"last uploaded image" => "zadnja naložena slika",
"first image" => "prva slika",
"last image" => "zadnja slika",
"random image" => "naključna slika",
"Top images" => "Najboljše slike",
"Last images" => "Zadnje slike",
"Remove file: " => "Odstrani datoteko: ",
"Permission denied you can upload files but not to this file gallery" => "Nimate dovoljenja nalagati podatkovnih datotek v to galerijo",
"Cannot read file:" => "Ne morem brati datoteke:",
"Cannot read the file:" => "ne morem brati datoteke:",
"Upload was not successful. Duplicate file content" => "Nalaganje ni bilo uspešno. Podvojena vsebina datoteke.",
"File update was successful" => "Nalaganje datoteke je bilo uspešno",
"Permission denied you can't upload files so you can't edit them" => "Nimate dovoljeja nalagati podatkovnih datotek, zato jih tudi ne morete urejati",
"This gallery does not exist" => "Ta galerija ne obstaja",
"Unable to create login" => "Ni možno ustvariti prijave",
"unknown action" => "neznana akcija",
"Invalid password" => "Neveljavno geslo",
"Account disabled" => "Račun onemogočen",
"No article indicated" => "Ni naznačenih člankov",
"Article is not published yet" => "Članek še ni objavljen",
"Blog not found" => "ne najdem bloga",
"You don't have permission to edit quizzes." => "Nimaš dovoljenja za urejanje kvizov.",
"You must choose a group" => "Izbrati moraš skupino",
"The passwords don't match" => "Gesli se ne ujemata",
"Username cannot contain uppercase letters" => "Uporabniško ime ne sme vsebovati velikih črk",
"Username must be at least" => "Uporabniško ime mora biti najmanj",
"Username cannot contain more than" => "Uporabniško ime ne sme vsebovati več kot",
"characters" => "znakov",
"Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Prosim vstavi veljaven %s.  Brez presledkov, več kot %d črk in vsebuje %s",
"This is not a valid mail adress" => "To ni veljaven e.naslov",
"mail adress" => "e-naslov",
"empty" => "prazen",
"Invalid or unknown username" => "Neveljaven ali nepoznan uporabnik",
"Unable to send mail. User has not configured email" => "Ne morem poslati e-pošte. Uporabnik ni oblikoval e-naslova",
"Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password." => "Prosim stopi v stik z administratorjem, če ne moreš dobiti e-pošte ali če ne moreš ponovno nastaviti gesla.",
"The mail can't be sent. Contact the administrator" => "E-pošte ne morem poslati. Stopi v stik z administratorjem",
"A password and your IP address reminder email has been sent " => "E-pošta z geslom in namig za IP naslov sta bila poslana ",
"An email with a link to reset your password has been sent " => "E-pošta s povezavo za ponovno nastavitev gesla je bila poslana ",
"to the registered email address for" => "na registriran e-naslov za",
"last version" => "zadnja verzija",
"Permission denied you cannot remove versions from this page" => "Nimaš dovoljenja za odstranitev verzij te strani",
"Permission denied you cannot rename this page" => "Nimaš dovoljenja za preimenovanje te strani",
"Cannot rename page maybe new page already exists" => "Ne morem preimenovati strani. Mogoče nova stran že obstaja",
"Non-existent version" => "Neobstoječa verzija",
"Error Message" => "Sporočilo napake",
"No newsletters available." => "Ni biltena.",
"Error: " => "Napaka: ",
"Notice: this variable may not be empty:" => "Obvestilo: ta spremenljivka ne sme biti prazna:",
"Permission denied you cannot upload images" => "Nimate dovoljenja za nalaganje slik",
"Permission denied you can upload images but not to this gallery" => "Nimate dovoljenja nalagati slik v to galerijo (sicer lahko nalagate slike)",
"Cannot get image from URL" => "ne morem dobiti slike iz URL-ja",
"Usage" => "Uporaba",
"Unknown user" => "neznan uporabnik",
"You are not logged in and no user indicated" => "Nisi prijavljen in noben uporabnik ni naveden",
"The user has chosen to make his information private" => "Uporabnik je izbral, da bo obdržal svoje informacije kot privatne",
"Password has been changed" => "Geslo je bilo zamenjano",
"Email is set to %s" => "E-naslov je nastavljen na %s",
"The passwords did not match" => "Gesli se ne ujemata",
"no" => "ne",
"Login and click the link below" => "Prijavite se in kliknite spodnje povezavo",
"Non-existent user" => "Uporabnik ne obstaja",
"No subject" => "Ni zadeve",
"Top pages" => "Najbolj gledane strani",
"Last pages" => "Zadnje strani",
"Tiki RSS feed for the wiki pages" => "Tiki RSS vir za wiki strani",
"Last modifications to the Wiki." => "Zadnja sprememba v wikiju.",
"Error deleting the file" => "Napaka pri brisanju datoteke",
"TikiTest List" => "Timki testni seznam",
"TikiTest Record" => "zapis Tiki testa",
"The TikiTest Replay File is Empty" => "Ponovitven adatoteka Tiki testa je prazna",
"TikiTest Replay" => "Ponovitev Tiki testa",
"The page is empty" => "Stran je prazna",
"###end###"=>"###end###");
?>
