<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only translates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release


// ### Note for translators about translation of text ending with punctuation
// ###
// ### The current list of concerned punctuation can be found in 'lib/init/tra.php'
// ### On 2009-03-02, it is: (':', '!', ';', '.', ',', '?')
// ### For clarity, we explain here only for colons: ':' but it is the same for the rest
// ###
// ### Short version: it is not a problem that string "Login:" has no translation. Only "Login" needs to be translated.
// ###
// ### Technical justification:
// ### If a string ending with colon needs translating (like "{tr}Login:{/tr}")
// ### then TikiWiki tries to translate 'Login' and ':' separately.
// ### This allows to have only one translation for "{tr}Login{/tr}" and "{tr}Login:{/tr}"
// ### and it still allows to translate ":" as "&nbsp;:" for languages that
// ### need it (like french)

$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"Site search bar" => "Barra de busca do sitio",
"Site logo source" => "Orixe do logo do sitio",
"Site ads and banners" => "Publicidade e pancartas do sitio",
"Site Menu" => "Menú do sitio",
"Note: This feature also requires phplayers to be turned on in Admin->Features" => "Nota: esta característica tamén require que se active phplayers en Administrar->Características",
"HTML in Wiki Pages" => "HTML en páxinas wiki",
"Wiki syntax used when a page contains HTML" => "Sintaxe wiki usada cando unha páxina contén HTML",
"full" => "completa",
"partial" => "parcial",
"Wiki attachments preferences" => "Preferencias de ficheiros asociados a Wiki",
"participants" => "participantes",
"subscription" => "subscrición",
"perso" => "perso",
"admin categories tpl" => "Modelo de administrar categorías",
"use in events" => "usar en eventos",
"admin External Wikis" => "Administrar wikis externos",
"admin Html Pages" => "Administrar páxinas Html",
"admin Html Pages template" => "Modelo de administrar páxinas Html",
"send newsletter" => "enviar boletín",
"Edit fields for tracker" => "Editar campos para tracker",
"The tracker needs a text field named Subject" => "O tracker precisa un campo de texto chamado \"Subject\"",
"assign permissions" => "asignar permisos",
"assign to groups" => "asignar a grupos",
"Batch upload (CSV file<a {popup text='login,password,email'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Carga en lote (ficheiro CSV <a {popup text='login,password,email'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help",
"remove file extension from image name" => "borre a extensión do ficheiro do nome da imaxe",
"convert sub directories to sub galleries" => "converter subdirectorios en subgalerías",
"eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created" => "exemplo de \"misc/screenshots/digicam0001.jpg\" crearase unha galería chamada screenshots",
"use sub directory names as description" => "use nomes de subdirectorios como descrición",
"eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created" => "exemplo de \"misc/screenshots/digicam0001.jpg\" crearase unha descrición misc/screenshots",
"admin the category system" => "administrar o sistema de categorías",
"list galleries" => "listar galerías",
"slideshow_p" => "slideshow_p",
"slideshow backward" => "pase diapositivas atrás",
"slideshow_n" => "slideshow_n",
"slideshow forward" => "pase diapositivas adiante",
"add item" => "agregar ítem",
"list view" => "visualizar lista",
"Format: mm/dd/yyyy hh:mm<br />..." => "Formato: mm/dd/yyyy hh:mm<br />...",
"See strtotime php function" => "Ver función php strtotime",
"Format: mm/dd/yyy hh:mm<br />..." => "Formato: mm/dd/yyy hh:mm<br />...",
"Subscription List" => "Listaxe de subscricións",
"save_to" => "gardar en",
"add a category" => "agregar categoría",
"Creates a link to the named file. If page is not given, the file must be attached to the current page. If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Crea unha ligazón ao ficheiro nomeado. Se non se dá a páxina(atributo \"page\"), o ficheiro debe estar anexo á páxina actual. Se non se dá \"desc\" (descrición), o nome de ficheiro é usado para o texto da ligazón, a menos que \"showdesc\" sexa usado, o que fai que se use a descrición do ficheiro como texto da ligazón. Se se dá image=1, o anexo é tomado como unha imaxe e despregado directamente na páxina, non se xera ligazón.",
"Project Object Created Successfully" => "Obxecto de proxecto creado con éxito",
"Project Name:" => "Nome de proxecto:",
"Project Description:" => "Descrición do proxecto:",
"Project Active" => "Proxecto activo",
"Current Objects:" => "Obxectos actuais:",
"Add a File Gallery" => "Engadir unha galería de ficheiros",
"Project Admin" => "Administrador do proxecto",
"Project Members" => "Membros do proxecto",
"Not Set" => "Non configurado",
"rebuild cache" => "reconstruír caché",
"monitor this gallery" => "monitorizar esta galería",
"stop monitoring this gallery" => "deixar de monitorizar esta galería",
"Number Members" => "Número de membros",
"Number Admins" => "Número de Admins",
"No projects found" => "Non se atoparon proxectos",
"install" => "instalar",
"Project Created:" => "Proxecto creado:",
"Project Info" => "Proxecto Info",
"Project Admins:" => "Administradores do proxecto:",
"Project Members:" => "Membros do proxecto:",
"Edit Project" => "Editar proxecto",
"Add Blog" => "Engadir blog",
"Add Articles" => "Engadir artigos",
"Add Calendar" => "Engadir calendario",
"Add FAQ" => "Engadir PMF",
"Add File Gallery" => "Engadir galería de ficheiros",
"Add Forum" => "Engadir foro",
"Add Image Gallery" => "Engadir galería de imaxes",
"Add Newsletter" => "Engadir boletín",
"Add URL" => "Engadir URL",
"Project Registration" => "Rexistro de proxecto",
"Your project was successfully submitted.  It may be subject\nto approval. Once available, you can create/link your project objects\nto your project page." => "O seu proxecto foi enviado con éxito. Pode ser suxeito a aprobación.\n Unha vez dispoñible, pode crear/ligar os seus obxectos de proxecto\na súa páxina de proxecto.",
"List all projects" => "Listar todos os proxectos",
"Take care when you register your project, the project name\ncannot be changed afterwards. Please also provide an accurate \nproject description. If you havent worked out these details please\ndo so before your register the project." => "Teña coidado cando rexistre o seu proxecto: o nome do proxecto\n non se pode cambiar despois. Por favor, provea tamén unha descrición\n axustada. Se non ten traballados estes detalles, por favor fágao antes de rexistrar o proxecto",
"Please choose your project categories carefully. You can\nhowever change this later on your project admin panel." => "Por favor, elixa as categorías do seu proxecto con coidado. De todos modos\n pode cambiar isto máis tarde no seu panel de administración do proxecto.",
"All project names are converted to lowercase." => "Todos os nomes de proxecto son convertidos a minúsculas.",
"wiki pages" => "páxinas do wiki",
"first" => "primeiro",
"admin mode" => "modo administrador",
"trash" => "papeleira",
"empty trash" => "baleirar papeleira",
"remove from trash" => "sacar da papeleira",
"use start date and time" => "usar data e hora de inicio",
"use end date and time" => "usar data e hora de fin",
"reload" => "recargar",
"Not rated yet" => "Non cualificado aínda",
"Jukebox preference" => "Preferencias da gramola",
"This is not a Tikiwiki File. Check if this file was uploaded and if it is dangerous." => "Este non é un ficheiro de Tikiwiki. Comprobe se este ficheiro foi cargado e se é perigoso.",
"This file is modified." => "Este ficheiro foi modificado.",
"Removed %s from group %s" => "Borrado %s de grupo %s",
"The passwords didn't match" => "Os contrasinais non coinciden",
"Invalid username or activation code" => "Nome de usuario ou código de activacion incorrectos",
"Tiki RSS feed for the tracker: " => "Fonte RSS de Tiki para o tracker: ",
"Error: No" => "Erro: Non",
"%H:%M:%S %Z" => "%H:%M:%S %Z",
"post" => "publicar",
"HomeworkMenu" => "Menú de deberes ",
"standard" => "estándar",
"cache" => "caché",
"backlinks" => "retroligazóns",
"perms" => "permisos",
"similar" => "similar",
"undo" => "desfacer",
"slides" => "diapositivas",
"log in" => "inicie sesión",
"Jukebox" => "Gramola",
"ok" => "correcto",
"TikiTabs" => "lingüetas Tiki",
"admin banning tpl" => "Modelo para administrar expulsión",
"cat" => "cat",
"prio" => "prio ",
"admin FortuneCookie" => "administrar CuquidaSorte",
"admin FortuneCookie tpl" => "Modelo de administrar CuquidaSorte",
"dsn" => "dsn",
"extwiki" => "wikiext",
"flag" => "marca ",
"posts" => "artigos",
"coms" => "coms",
"ppd" => "ppd",
"url" => "url",
"admin Webmail" => "administrar correo web",
"admin QuickTags" => "administrar etiquetas rápidas",
"admin Trackers tpl" => "Modelo de administrar trackers",
"items" => "ítems",
"admin" => "administrar",
"admin admin tpl" => "Modelo de Administrar Copias de Seguridade",
"Chair" => "Cadeira",
"tbheight" => "altura da táboa",
"imagescale" => "escala da imaxe",
"creates an editable drawing named foo" => "crea un debuxo editable chamado foo",
"admin quicktags" => "administrar etiquetas rápidas",
"admin roles" => "administrar roles",
"monitor" => "monitor",
"Ins" => "Ins.",
"admin Banners" => "administrar pancartas",
"admin Banners tpl" => "Modelo de administrar pancartas",
"admin cache" => "administrar caché",
"admin cache tpl" => "Modelo de administrar caché",
"admin DynamicContent tpl" => "Modelo de administrar contido dinámico",
"adm" => "adm.",
"blog posts" => "artigos de blog",
"admin Tiki Shoutbox" => "administrar taboleiro de anuncios Tiki",
"admin Tiki Shoutbox tpl" => "Modelo de administrar taboleiro de anuncios Tiki",
"item" => "ítem",
"You do not have permission to use this feature." => "Non ten permiso para usar esta característica.",
"refresh" => "refresco",
"uploaded by" => "cargado por",
"not specified" => "non especificada",
"There was a problem with your upload." => "Houbo un problema coa súa carga.",
"The file you are trying to upload is too big." => "O ficheiro que intenta cargar é demasiado grande.",
"The file you are trying to upload was only partially uploaded." => "O ficheiro que intenta cargar foi só parcialmente cargado.",
"You must select a file for upload." => "Debe seleccionar un ficheiro para cargar.",
" line " => " liña ",
"permission." => "permiso",
"Error: Invalid" => "Erro: incorrecto ",
"Error: Call to hw_page_fetch_by_id failed!" => "Erro: fallou a chamada a hw_page_fetch_by_id!",
"%s is an empty archive file" => "%s é un ficheiro de arquivo baleiro",
"Invalid remote file on url %s" => "Ficheiro remoto incorrecto en %s",
"Project Group for " => "Grupo do proxecto para ",
"Project Admin Group for " => "Grupo administrador do proxecto para ",
"%A %d of %B, %Y" => "%A %d de %B de %Y",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d de %B de %Y[%H:%M:%S %Z]",
"%a %d of %b, %Y" => "%a %d de %b de %Y",
"%a %d of %b, %Y[%H:%M %Z]" => "%a %d de %b de %Y[%H:%M %Z]",
"no description" => "sen descrición",
"Updated" => "Actualizado",
"Textarea options: options,width,height,max with option is 1 or 0, rest is size indicated in chars and lines, max is the maximum number of characters that can be saved." => "Opcións de área de texto: opcións, anchura, alto, max. con opción 0 ou 1, o resto é tamaño indicado en caracteres e liñas, max. é o máximo número de caracteres que se gardará",
"User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "Selector do usuario: use opcións para a alimentación automática do campo: pode usar 1 para o nome (login) do autor e 2 para o nome (login) do modificador.",
"Image options: xSize,ySize indicated in pixels." => "Opcións de imaxe: Tamx,Tamy indicados en píxeles.",
"Category options: parentId" => "Opcións de categoría: Idpai",
"Item Link options: trackerId,fieldId links to item from trackerId which fieldId matches the content of that field." => "Opcións de ligazón a ítem: trackerId,campoId liga a ítem desde trackerId, onde campoId corresponde co contido dese campo.",
"Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere." => "Opcións da lista de ítems: Idtracker, CampoIdAlá, CampoIdAquí, MostrarCampoIdAlá amosa a lista de MostrarCampoIdAlá desde ítem no tracker Idtracker, onde CampoIdAlá corresponde con CampoIdAquí.",
"~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} insire artigos na páxina wiki",
"num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "num é opcional e é o número ordinal do anexo na lista. Se non se dá, despregarase unha lista de todos os anexos. Inline fai que o comentario sexa o texto da ligazón.",
"~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} inserir a saída dunha fonte rss nunha páxina wiki",
"You need to supply information for : " => "Debe fornecer a información para: ",
"missing tracker ID for plugin TRACKER" => "falta o ID de tracker para o plugin TRACKER",
"delete" => "eliminar",
"show categories" => "mostrar categorías",
"Tip: hold down CTRL to select multiple categories" => "Consello: manteña premido CTRL para elixir múltiples categorías",
"Tip: uncheck the above checkbox to uncategorize this page/object" => "Consello: deseleccione a cela de verificación de arriba para descategorizar esta páxina/obxecto",
"author" => "autor",
"user level" => "nivel de usuario",
"send email to user" => "enviar correo a usuario",
"score" => "puntos",
"delete selected" => "borrar seleccionados",
"move" => "mover",
"Posted messages" => "Mensaxes enviadas",
"set" => "poñer",
"replies" => "respostas",
"new reply" => "nova resposta",
"cancel" => "cancelar",
"add" => "engadir",
"someone coming from IP Address" => "alguén accedendo desde o enderezo IP",
"requested a reminder of the password for the" => "solicitou un recordatorio do contrasinal para o",
"requested a reset of the password for the" => "solicitou un reinicio da clave para o",
"The old password remains active until you activate the new one by following this link:" => "A clave antiga mantense activa ata que active a nova seguindo esta ligazón:",
"This is only a temporary password. After you logged in with it, you will get to the 'change password' dialog." => "Esta é só unha clave temporal. Logo de que entre con ela, obterá o diálogo de 'cambiar clave'.",
"Information:" => "Información:",
"New blog post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Novo artigo no blog: {\$mail_title} por {\$mail_user} en {\$mail_date|tiki_short_datetime}",
"stop monitoring this map" => "deixar de monitorizar este mapa",
"create" => "crear",
"save" => "gardar",
"edit template" => "editar modelo",
"send" => "enviar",
"If you people want to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "Se os seus coñecidos queren ser capaces de responderlle a vostede, ten que marcar <a href='tiki-user_preferences.php'>Permitir mensaxes desde outros usuarios</a>",
"reply to" => "responder a",
"up" => "subir",
"down" => "baixar",
"Hide module contents" => "Ocultar contidos do módulo",
"List Courses" => "Listar cursos",
"Last visitors" => "Últimos visitantes",
"register" => "rexistrarse",
"secure" => "seguro",
"stay in ssl mode" => "permanecer en modo ssl",
"new messages" => "novas mensaxes",
"new message" => "nova mensaxe",
"go" => "ir",
"use" => "usar",
"print" => "imprimir",
"create pdf" => "crear pdf",
"monitor this page" => "monitorizar esta páxina",
"stop monitoring this page" => "deixar de monitorizar esta páxina",
"last modification" => "última modificación",
"click here" => "faga clic aquí",
"rename" => "renomear",
"unlock" => "desbloquear",
"lock" => "bloquear",
"history" => "historial",
"export" => "exportar",
"discuss" => "discutir",
"add comment" => "engadir comentario",
"attach file" => "anexar ficheiro",
"translation" => "tradución",
"attachments" => "anexos",
"stats" => "estatísticas",
"last changes" => "cambios recentes",
"list pages" => "listar páxinas",
"back to homepage" => "volver ao inicio",
"Please" => "Por favor",
"to access full functionalities" => "para acceder a todas as funcionalidades",
"cancel edit" => "cancelar a edición",
"No attachments for this page" => "Non hai anexos para esta páxina",
"Skip to navigation" => "Saltar para a navegación",
"reads" => "lecturas",
"cached" => "cacheada",
"Click here to create it" => "Prema aquí para crealo",
"wiki help" => "axuda wiki",
"Site Calendar" => "Calendario do sitio",
"Friendship network" => "Círculo de Amizade",
"Allow permissions for friendship network" => "Permitir permisos para o círculo de amizade",
"Max friendship distance" => "Distancia máxima de amizade",
"Best language" => "Mellor lingua",
"Use Quote plugin for quoting" => "Usar o plugin QUOTE para citar",
"Enable cache images to all galleries" => "Activar cacheo de imaxes en todas as galerías",
"Images cache directory" => "Directorio de caché de imaxes",
"PHP error reporting level for non-admin:" => "Nivel de informe de erro de PHP para non admin:",
"Report PHP errors only for admin" => "Informar erros de PHP só para admin",
"Server name (for absolute URIs)" => "Nome do servidor (para URI absolutas)",
"HTTPS Server" => "Servidor HTTPS",
"Automatic (uses HTTPS variable)" => "Automático (usa variable HTTPS)",
"Wiki_Tiki_Title" => "Título do Wiki",
"Jukebox settings" => "Configuración da gramola",
"Jukebox tracks location" => "Localización das pistas da gramola",
"Jukebox features" => "Características da gramola",
"Default ordering for album listing" => "Orde por defecto para a listaxe de álbums",
"Album title (asc)" => "Título de álbum (asc)",
"Number of tracks (desc)" => "Número de pistas (desc)",
"In album listing show user as" => "Na listaxe de álbums, mostrar usuario como",
"Jukebox listing configuration (when listing available albums)" => "Configuración de listaxes da gramola (cando se listen álbums dispoñibles)",
"Tracks" => "Pistas",
"Genre" => "Xénero",
"Admin->Features" => "Administrar->Características",
"Hide disabled sections" => "Ocultar seccións desactivadas",
"Show disabled sections" => "Mostrar seccións desactivadas",
"Create a group for each user <br />(with the same\nname as the user)" => "Crear un grupo para cada usuario <br />(co mesmo\nnome có usuario)",
"Validate email address (may not work)" => "Validar enderezo de correo (pode non funcionar)",
"Remind passwords by email" => "Recordar contrasinais por correo",
"Require HTTP Basic authentication" => "Require autenticación HTTP",
"HTTP server name" => "Nome do servidor HTTP",
"HTTP URL prefix" => "Prefixo para as URL de HTTP",
"HTTPS server name" => "Servidor HTTP",
"HTTPS URL prefix" => "Prefixo para as URL de HTTP",
"Only for users" => "Só para usuarios",
"Users and admins" => "Usuarios e administradores",
"Users choose project categories" => "Os usuarios elixen as categorías de proxecto",
"Prefix for Project Admin groups" => "Prefixo para grupos de Admin de Proxecto",
"Prefix for Project groups" => "Prefixo para grupos de Proxecto",
"Prefix for Wiki project home page" => "Prefixo para a páxina inicio de proxecto Wiki",
"Prefix for File Galleries" => "Prefixo para a Galería de ficheiros",
"Project Admins group template" => "Modelo de grupo Admins de Proxecto",
"Create New Group" => "Crear novo grupo ",
"Project Members group template" => "Modelo de grupo de Membros de Proxecto",
"Full Text Search" => "Busca en todo o texto",
"Don't forget: to use feature you will need to enable it on" => "Non se esqueza: para usar esta característica deberá activala",
"Custom Code" => "Código Personalizable",
"Site breadcrumbs" => "ruta do acceso do sitio",
"Site logo" => "Logo do sitio",
"change" => "cambiar",
"Manage attachment preferences" => "Xestionar as preferencias dos anexos",
"Like pages" => "Páxinas similares",
"Enable Feature" => "Activar Función",
"loc" => "loc.",
"lang" => "lingua",
"permissions" => "permisos",
"admin categories" => "administrar categorías",
"create new" => "crear nova",
"edit chart" => "editar chart",
"update" => "actualizar",
"admin charts template" => "modelo de administrar charts",
"admin content templates" => "administrar modelos de contido",
"admin content templates template" => "modelo de administrar modelos de contido",
"use in cms" => "usar en cms",
"use in wiki" => "usar en wiki",
"use in newsletters" => "usar en boletíns",
"use in HTML pages" => "usar en páxinas HTML",
"last modif" => "última modificación",
"sections" => "seccións",
"upload" => "cargar",
"admin Drawings tpl" => "modelo de administrar ilustracións",
"admin forums template" => "modelo de administrar foros",
"Edit existing forums" => "Editar foros existentes",
"online" => "en liña",
"topics" => "temas",
"age" => "idade",
"last post" => "último artigo",
"Assign Permissions (Active)" => "Asignar permisos (activo)",
"Click here to delete this forum" => "Prema aquí para borrar este foro",
"admin hotwords" => "administrar palabras clave",
"admin hotwords template" => "modelo de administrar palabras clave",
"admin HTML page dynamic zones" => "administrar as zonas dinámicas de páxinas HTML",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "Use {literal}{{/literal}ed id=nome} ou {literal}{{/literal}ted id=nome} para inserir zonas dinámicas",
"list repositories" => "listar almacéns",
"new repository" => "novo almacén",
"view repository" => "ver almacén",
"view this repository" => "ver este almacén",
"new rule" => "nova regra",
"admin featured links" => "administrar ligazóns destacadas",
"admin featured links template" => "administrar modelo de ligazóns destacadas",
"position" => "posición",
"admin mailin template" => "modelo de administrar entrada de correo",
"section" => "sección",
"sorted section" => "sección ordenada",
"admin menu builder" => "administrar construtor de menús",
"admin menus template" => "modelo administrar menús",
"options" => "opcións",
"admin modules" => "administrar módulos",
"admin modules template" => "modelo de administrar módulos",
"assign module" => "asignar módulo",
"left modules" => "módulos da esquerda",
"right modules" => "módulos da dereita",
"edit/create" => "editar/crear",
"clear cache" => "limpar caché",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Nota 1</b>: se permite que os seus usuarios configuren módulos entón os módulos asignados\n non serán reflectidos na pantalla ata que os configure \ndesde OMeuTiki->Módulos.<br />\n<b>Nota 2</b>: Se asigna módulos a grupos asegúrese de que\n apagou a opción 'mostrar módulos a todos os grupos sempre'\nen Admin->Xeral\n",
"assign" => "asignar",
"left" => "esquerda",
"right" => "dereita",
"order" => "orde",
"groups" => "grupos",
"create/edit" => "crear/editar",
"use poll" => "usar votación",
"use gallery" => "usar galería",
"use dynamic content" => "usar contido dinámico",
"use rss module" => "usar módulo RSS",
"use menu" => "usar menú",
"use phplayermenu" => "usar menú phplayer",
"use banner zone" => "usar zona de pancartas",
"list newsletters" => "listar boletíns",
"admin newsletters" => "administrar boletíns",
"send newsletters" => "enviar boletíns",
"admin newsletters template" => "modelo de administrar boletíns",
"editions" => "edicións",
"last sent" => "última enviada",
"admin Email Notifications" => "administrar notificacións por correo-e",
"admin notifications template" => "modelo de administrar notificacións",
"use admin email" => "usar o correo-e do administrador",
"event" => "evento",
"admin polls" => "administrar votacións",
"admin polls template" => "modelo de administrar votacións",
"label" => "etiqueta",
"Category: wiki, trackers, etc." => "Categoría: wiki, trackers, etc.",
"admin RSS Modules" => "administrar módulos RSS",
"admin RSSmodules template" => "modelo de administración de módulos RSS",
"edit tpl" => "editar modelo",
"admin shoutbox words" => "administrar palabras do taboleiro de anuncios",
"admin shoutbox words template" => "modelo de administrar palabras do taboleiro de anuncios",
"admin structures template" => "modelo de administrar estruturas",
"export pages" => "exportar páxinas",
"dump tree" => "envorcar árbore",
"create webhelp" => "crear axuda web",
"view webhelp" => "ver axuda web",
"tree" => "árbore",
"create new structure" => "crear nova estrutura",
"survey stats" => "estatísticas da enquisa",
"edit this survey" => "editar enquisa",
"admin surveys" => "administrar enquisas",
"list surveys" => "listar enquisas",
"questions" => "preguntas",
"files" => "ficheiros",
"admin topics template" => "modelo para administrar temas",
"Field is public? (for use thru trackerlist plugin)" => "O campo é público? (para usar co plugin trackerlist)",
"Field is hidden? (visible by admin only)" => "O campo está oculto? (visible só para o administrador)",
"version" => "versión",
"admin groups" => "administrar grupos",
"admin groups template" => "modelo para administrar grupos",
"admin users" => "administrar usuarios",
"admin users template" => "modelo de administrar usuarios",
"edit account settings" => "editar opcións de conta",
"Added users" => "Usuarios engadidos",
"edit article tpl" => "modelo de editar artigo ",
"all" => "todos",
"Assign user" => "Asignar usuario",
"Available groups" => "Grupos dispoñibles",
"assign perms to this group" => "asignar permisos a este grupo",
"admin backups" => "administrar copias de seguridade",
"List of available backups" => "Lista de copias de seguridade dispoñibles",
"Restoring a backup" => "Recuperar unha copia de seguridade",
"Warning!" => "Coidado!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Ao restaurar unha copia de seguridade destrúe todos os datos da súa base Tiki. Todas as súas táboas serán substituídas coa información da copia de seguridade.",
"Click here to confirm restoring" => "Prema aquí para confirmar a restauración",
"Create new backup" => "Crear nova copia de seguridade",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Crear copias de seguridade pode levar moito tempo. Se o proceso non se completa vostede verá unha pantalla en branco. Se pasar iso necesita incrementar o tempo de execución máximo de scripts no seu ficheiro php.ini",
"Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "O seu almacenamento de galería de imaxes está configurado como \"{\$gal_use_dir}\", deberá facerlle a copia de seguridade usando FTP ou SCP.",
"Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "O seu almacenamento de galería de ficheiros está configurado como \"{\$fgal_use_dir}\", deberá facerlle a copia de seguridade usando FTP o SCP.",
"If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "Se algún dos seus foros ten anexos gardados no directorio deberá facerlle a copia de seguridade usando FTP o SCP.",
"Upload a backup" => "Cargar unha copia de seguridade",
"Upload backup" => "Cargar copia de seguridade",
"view blog" => "visualizar blog",
"list blogs" => "listar blogs",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor" => "Nota: se quere usar imaxes por favor garde o artigo primeiro e\npoderá editar/poñer imaxes. Use o código &lt;img&gt; para incluír imaxes cargadas no editor da área de texto\n ou use o URL da imaxe para incluíla usando o editor WYSIWYG",
"save and exit" => "gardar e saír",
"admin category" => "administrar categoría",
"search category" => "buscar categoría",
"deep" => "profundidade",
"edit gallery" => "editar galería",
"rebuild thumbnails" => "reconstruír miniaturas",
"upload image" => "cargar imaxe",
"list gallery" => "listar galería",
"hit" => "acceso",
"original size" => "tamaño orixinal",
"return to gallery" => "volver á galería",
"edit image" => "editar imaxe",
"smaller" => "menor",
"bigger" => "maior",
"prev image" => "imaxe previa",
"next image" => "seguinte imaxe ",
"popup window" => "fiestra emerxente",
"or create a new category" => "ou cree unha nova categoría",
"or create a new location" => "ou cree unha nova localización",
"comma separated usernames" => "nomes de usuarios separados por coma",
"comma separated username:role" => "usuario:rol separados por coma",
"with roles" => "con roles",
"Optional" => "Opcional",
"permission" => "permiso",
"remove from this category &amp; all its children" => "borrar desta categoría e de todos os seus fillos",
"remove from this category only" => "borrar só desta categoría",
"Textheight" => "Altura de texto",
"Height of top Heading" => "Altura do encabezado superior",
"Height of mid Heading" => "Altura do encabezado medio",
"Height of inner Heading" => "Altura do encabezado interno",
"Automatic Page Breaks" => "Saltos automáticos de páxina",
"remove page" => "eliminar páxina",
"admin directory tpl" => "modelo de administrar directorio",
"browse" => "navegar",
"related" => "relacionado",
"validate" => "validar",
"admin directory categories tpl" => "modelo de administrar categorías de directorio",
"add a site" => "engadir un sitio",
"search" => "buscar",
"list articles" => "listar artigos",
"view articles" => "visualizar artigos",
"create zone" => "crear zona",
"save the banner" => "gardar a pancarta",
"edit blog tpl" => "modelo de editar blog",
"try" => "probar",
"display" => "mostrar",
"For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "Para máis información, por favor vexa <a href=\"{\$helpurl}WikiSyntax\">SintaxeWiki</a>",
"Emphasis" => "Énfase",
"italics" => "cursivas",
"both" => "ambos",
"use ...page... to separate pages" => "use ...páxina... para separar páxinas",
"make_headings" => "fai encabezados",
"underlines text" => "subliña texto",
"Simple box" => "Caixa simple",
"Will display using the indicated HTML color" => "Mostrarase usando a cor HTML indicada",
"Will display the text centered" => "Mostra o texto centrado",
"Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "Motra código/texto preformatado; non e fai procesamento Wiki dentro desas seccións (como con np) e o espazado é fixo (non se fai axuste de palabras).",
"Insert Module Output" => "Insire a saída do módulo",
"{literal}{MODULE(module=>some_module)}text{MODULE}{/literal}  can be used to insert the output of module \"some_module\" into your Wiki page. See <a href=\"{\$helpurl}PluginModule\">PluginModule</a> for more information. " => "{literal}{MODULE(module=>algún_módulo)}text{MODULE}{/literal}  pode ser usado para inserir a saída do módulo \"algún_módulo\" dentro da súa páxina Wiki. Vexa <a href=\"{\$helpurl}PluginModule\">PluginModule</a> para máis información.",
"Rendering Program Code" => "Mostra o código de programa",
"{literal}{CODE()}some code{CODE} {/literal} will render \"some code\" as program code. This plugin has other options; see <a href=\"{\$helpurl}PluginCode\">PluginCode</a>." => "{literal}{CODE()}algún código{CODE} {/literal} vai mostrar \"algún código\" como código do programa. Este plugin ten outras opcións; vexa <a href=\"{\$helpurl}PluginCode\">PluginCode</a>.",
"create new block" => "crear novo bloque",
"list quizzes" => "listar cuestionarios",
"quiz stats" => "estatísticas de cuestionarios",
"edit this quiz" => "editar este cuestionario",
"admin quizzes" => "administrar cuestionarios",
"admin quizzes tpl" => "modelo de administrar cuestionarios",
"results" => "resultados",
"edit quiz questions" => "editar preguntas do cuestionario",
"edit quiz questions tpl" => "modelo de editar preguntas do cuestionario",
"create page" => "crear páxina",
"edit submissions tpl" => "modelo de editar colaboracións",
"list submissions" => "listar colaboracións",
"edit translations" => "editar traducións",
"edit translations template" => "modelo de editar traducións",
"add to the set" => "agregar ao conxunto",
"Admin ephemerides" => "Administrar efemérides",
"admin Ephemerides tpl" => "modelo de administrar efemérides",
"All ephemerides" => "Todas as efemérides",
"new question" => "nova pregunta",
"approve" => "aprobar",
"configure listing" => "configurar listaxe",
"create new gallery" => "crear nova galería",
"topic" => "tema",
"save and approve" => "garde e aprobe",
"new topic" => "novo tema",
"reject" => "rexeitar",
"visits" => "visitas",
"accept" => "aceptar",
"refuse" => "rexeitar",
"switch" => "cambiar",
"add new" => "engadir novo",
"add role" => "engadir rol",
"new minor" => "novo menor",
"new major" => "novo maior",
"admin processes" => "administrar procesos",
"admin activities" => "administrar actividades",
"edit this process" => "Editar este proceso",
"Activs" => "Activos",
"time" => "tempo",
"send instance" => "enviar exemplar",
"stop" => "deter",
"Wiki quick help" => "Axuda rápida Wiki",
"Quicklinks" => "Ligazóns rápidas",
"Last Edit:" => "Última edición:",
"Grade Paper" => "Traballo de Grao",
"Due Date:" => "Data de entrega:",
"Comparing versions" => "Comparando versións",
"Actual_version" => "Versión actual",
"Diff to version" => "Diferenzas coa versión",
"source" => "fonte",
"Assignments List" => "Lista de tarefas",
"My Work" => "O meu traballo",
"Assignment" => "Tarefa",
"Due Date" => "Data de entrega",
"Grading Queue " => "Cola de Graduación",
"paper" => "traballo",
"papers" => "traballos",
"Edit Assignment" => "Editar tarefa",
"list assignments" => "listar tarefas",
"Due" => "Vencemento",
"create assignment" => "crear asignación",
"result" => "resultado",
"edit repository" => "editar almacén",
"list articles tpl" => "modelo de listar artigos",
"edit new article" => "editar novo artigo",
"create new blog" => "crear novo blog",
"list faqs tpl" => "modelo de listar pmfs",
"upload file" => "cargar ficheiro",
"Edit a file using this form" => "Edite un ficheiro usando este formulario",
"delete selected files" => "borrar ficheiros seleccionados",
"browse gallery" => "explorar galería",
"Flash binary (.sqf or .dcr)" => "Arquivo Flash (.sqf ou .dcr)",
"list posts tpl" => "modelo para listar envíos",
"edit blog" => "editar blog",
"list quizzes tpl" => "modelo de listar cuestionarios",
"edit new submission" => "editar nova colaboración",
"edit quiz stats tpl" => "modelo de editar estatísticas do cuestionario",
"actions" => "accións",
"take survey" => "tomar enquisa",
"list trackers tpl" => "modelo de listar trackers",
"admin live support tpl" => "modelo de administrar asistencia en liña",
"set as operator" => "poñer como operador",
"add topic" => "engadir tema",
"wiki create" => "crear wiki",
"wiki overwrite" => "sobrescribir wiki",
"back" => "atrás",
"Assign permissions to page" => "Asignar permisos para a páxina",
"Current permissions for this page" => "Permisos actuais para esta páxina",
"remove from this page" => "borrar desta páxina",
"remove from this structure" => "borrar desta estrutura",
"No individual permissions; category or global permissions apply" => "Non se aplican permisos individuais, de categoría ou globais",
"this page" => "esta páxina",
"this structure" => "esta estrutura",
"Current permissions for categories that this page belongs to" => "Permisos actuais para as categorías ás que pertence esta páxina",
"Send email notifications when this page changes to" => "Enviar notificación de correo cando esta páxina cambie a",
"add email" => "engadir correo",
"Notifications" => "Notificacións",
"view comments" => "ver comentarios",
"clear" => "limpiar",
"clear stats" => "borrar estatísticas",
"Edit received page" => "Editar páxina recibida",
"admin Referer stats" => "administrar estatísticas de referenciantes",
"admin Referer stats tpl" => "modelo de administrar estatísticas de referenciantes",
"last" => "última",
"send me my password" => "enviar o meu contrasinal",
"searched" => "buscado",
"galleries" => "galerías",
"images" => "imaxes",
"articles" => "artigos",
"admin send objects tpl" => "modelo de administrar envío de obxectos",
"site" => "sitio",
"path" => "camiño",
"add article" => "engadir artigo",
"create new sheet" => "crear nova folla de cálculo",
"send answers" => "enviar respostas",
"move to right column" => "mover á columna dereita",
"unassign" => "inhabilitar",
"move to left column" => "mover á columna esquerda",
"remove folder" => "borrar carpeta",
"refresh cache" => "refrescar caché",
"General preferences" => "Preferencias xerais",
"Other preferences" => "Outras preferencias",
"HomePage" => "PáxinaInicio",
"Edit information" => "Editar a información",
"Change information" => "Cambiar información",
"edit user files" => "editar ficheiros de usuario",
"no comments" => "sen comentarios",
"stop monitoring this blog" => "deixar de monitorizar este blog",
"edit items" => "editar ítems",
"list charts" => "listar charts",
"last chart" => "último chart",
"view faq" => "ver pmf",
"view faq tpl" => "modelo de ver pmf",
"admin menus tpl" => "modelo de administrar menús",
"add suggestion" => "agregar suxestión",
"monitor this forum" => "monitorizar este foro",
"stop monitoring this forum" => "deixar de monitorizar este foro",
"delete selected topics" => "borrar temas seleccionados",
"topics in this forum" => "temas deste foro",
"stop monitoring this topic" => "deixar de monitorizar este tema",
"Comments below your current threshold" => "Comentarios por debaixo do seu límite actual",
"list attachments" => "listar anexos",
"add contacts" => "engadir contactos",
"DATE-of" => "de",
"The passwords dont match" => "Os contrasinais non coinciden",
"You do not have permission to write the template" => "Non ten permiso para escribir o modelo",
"You cannot edit this page because it is a user personal page" => "Non pode editar esta páxina porque é a páxina persoal dun usuario",
"Go to your <a href=\"tiki-friends.php\">friendship network</a> to accept or refuse this request" => "Vaia ao seu <a href=\"tiki-friends.php\">círculo de amizades</a> para aceptar ou rexeitar esta solicitude",
"You must be a student to edit homework pages." => "Debe ser estudante para editar páxinas de deberes.",
"No assignment indicated" => "Non se indicou a tarefa",
"Error: Invalid id for hw_pages table." => "Erro: id incorrecto para táboa hw_pages.",
"Error: This page is being edited by another user." => "Erro: Esta páxina está a editala outro usuario.",
"Permission denied: Students may only view or edit their own work." => "Permiso denegado: Os estudantes só poden ver ou editar o seu propio traballo.",
"Error: Assignment not found." => "Erro: Asignación de deberes non atopada.",
"Permission denied: Students may NOT edit their work after the due date." => "Permiso denegado: Os estudantes NON poden editar o seu traballo despois da data de entrega.",
"Permission denied: The teacher must wait until the due date to edit students' work." => "Permiso denegado: o profesor debe esperar ata a data de entrega para editar o traballo dos estudantes.",
"No entries available yet!" => "Aínda non hai entradas dispoñibles!",
"Permission denied: you must be a teacher to access this page." => "Permiso denegado: debe ser profesor para acceder a esta pácina.",
"Error: No assignment indicated." => "Erro: Non se indicou asignación de deberes.",
"Error: assignment not found." => "Error: asignación de deberes non atopada.",
"You must be a student to view this page." => "Debe ser estudante para ver esta páxina.",
" is not a student." => "non é un estudante.",
"specified." => "especificado.",
"Assignment not found" => "Asignación de deberes non atopada",
"Anonymous Grader" => "Cualificador anónimo",
"Anonymous Peer Reviewer" => "Revisión anónima por un igual",
"No homework page indicated!" => "Non se indicou a páxina de deberes!",
"Error: Could not fetch page" => "Erro: Non podo obter páxina",
"You must be a student to view this page!" => "Debe ser un estudante para visualizar esta páxina!",
"Students may only view their own work!" => "Os estudantes só poden visualizar o seu propio traballo!",
"This function is deprecated in favor of the improved quizzes outside of the Homework feature." => "Esta función está obsoleta en favor dos cuestionarios mellorados fóra da función de Deberes.",
"Permission denied: You cannot rollback this page." => "Permiso denegado: non pode volver atrás esta páxina.",
"No hw page indicated" => "Non se indicou páxina de deberes",
"Error: nonexistant version specified." => "Erro: versión especificada inexistente.",
"Error: Could not fetch assignment " => "Erro: non podo obter asignación de deberes",
"You must be a student to view homework assignments." => "Debe ser estudante para ver as asignacións de deberes.",
"Permission denied you must be a student to view assignments." => "Permiso denegado: debe ser un estudante para visualizar as asignacións de deberes.",
"You must be a teacher or grader to access this page." => "Debe ser un mestre ou un cualificador para acceder a esta páxina.",
"Permission denied: You must be a teacher to edit assignments." => "Permiso denegado: Debe ser un profesor para editar asignación de deberes.",
" error: Can not find assignment " => "erro: non podo atopar asignación de deberes",
"Permission denied you cannot assign permissions for this page" => "Non ten autorización para asignar permisos para esta páxina",
"A new password and your IP address has been sent " => "Enviáronselle unha nova clave e o seu enderezo IP",
"Invalid variable value : " => "Valor incorrecto de variable : ",
"You do not have permission to edit messages" => "Non ten permiso para editar mensaxes",
"Cannot read file" => "Non podo ler o ficheiro",
"Permission denied you cannot upload files" => "Permiso denegado: non pode cargar ficheiros",
"cannot process upload" => "non se puido procesar a carga",
"Your email address has been removed from the list of addresses monitoring this tracker" => "O seu enderezo de correo foi borrado da lista de enderezos monitorizando este tracker",
"Your email address has been added to the list of addresses monitoring this tracker" => "O seu enderezo de correo foi borrado da lista de enderezos monitorizando este tracker",
"Cancel monitoring" => "Cancelar monitor",
"Your email address has been removed from the list of addresses monitoring this item" => "O seu enderezo de correo foi borrado da lista de enderezos monitorizadores deste ítem",
"Your email address has been added to the list of addresses monitoring this item" => "O seu enderezo de correo foi engadido á lista de enderezos monitorizadores deste ítem",
"I did not understand what you said, please try again." => "Non comprendo o que di. Por favor, ténteo de novo.",
"Dls" => "Dls",
"diff" => "diff",
"pdf" => "pdf",
"UTC" => "UTC",
"Local" => "Local",
"zoom" => "zoom",
"roles" => "roles",
"P" => "P",
"F" => "F",
"pop" => "pop",
"new image uploaded by" => "nova imaxe cargada por",
"new subscriptions" => "nova subscrición",
"new item in tracker" => "novo ítem no tracker",
"tikiwiki logo" => "logo do tikiwiki",
"show" => "mostrar",
"hide" => "ocultar",
"message" => "mensaxe",
"Include all post in a blog" => "Incluír todos os artigos dun blog",
"Include an article" => "Inclúe un artigo",
"no such attachment on this page" => "non hai tal anexo nesta páxina",
"select all" => "elixir todo",
"filter" => "filtrar",
"missing fields list" => "lista de campos ausentes",
"move %s in %s" => "mover %s para %s",
"no such file" => "non existe este ficheiro",
"downloads" => "descargas",
"download" => "descargar",
"attach" => "anexar",
"monitor this blog" => "monitorizar este blog",
"hide categories" => "ocultar categorías",
"Admin categories" => "Administrar categorías",
"browse category" => "navegar na categoría",
"reply" => "responder",
"monitor this topic" => "monitorizar este tema",
"active perms" => "permisos activos",
"with checked" => "con marcados",
"move selected files" => "mover ficheiros seleccionados",
"Thank you for you registration. You may log in now." => "Grazas polo seu rexistro. Agora pode iniciar a sesión.",
"Zoom out x4" => "Reducir x4",
"Zoom out x3" => "Reducir x3",
"Zoom in x3" => "Ampliar x3",
"Zoom in x4" => "Ampliar x4",
"from\nthe mapfile:" => "desde\no ficheiro de mapa:",
"compare" => "comparar",
"older version" => "versión máis antiga",
"Click the :: options in the Menu for more options." => "Prema en :: opcións no menú para máis opcións.",
"Please, also see" => "Por favor, mire tamén",
"for more setup details." => "para máis detalles de configuración.",
"Note 1:" => "Nota 1:",
"You can remove this module in" => "Pode eliminar este módulo en",
"as well as assign or edit many others." => "como asignar ou editar moitos outros",
"Note 2:" => "Nota 2:",
"The menu module installed by default is named" => "O módulo de menú instalado por defecto chámase",
"it is a \"custom module\" which includes menu ID " => "é un \"módulo personalizado\" que inclúe ID do menú",
"That menu is stored in database and it can be edited from " => "Ese menú esta gardado na base de datos e pode editarse desde ",
"Do not mix this with the original <em>application_menu</em> module" => "Non mesture este co módulo orixinal <em>application_menu</em>",
"That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "Ese pode ser moi personalizado para facer corresponder co tema usado pero só se pode facer editando o ficheiro mod-application_menu.tpl \"manualmente\"",
"del" => "borrar",
"Create pdf" => "Crear pdf",
"1 file attached" => "1 ficheiro anexado",
"categories" => "categorías",
"List pages where I am a creator" => "Listar páxinas onde son modificador",
"by creator" => "por modificador",
"List pages where I am a modificator" => "Listar páxinas onde son o modificador",
"by modificator" => "por modificador",
"at tracker" => "en tracker",
"calendar view" => "vista de calendario",
"check / uncheck all" => "marcar / desmarcar todos",
"Tiki sections and features" => "Seccións e características do Tiki",
"tikiwiki.org help" => "Axuda tikiwiki.org",
"Site Logo and Identity" => "Logo e identidade do sitio ",
"Use Quote plugin rather than &ldquo;>&rdquo; for quoting" => "Use o plugin QUOTE no canto de &ldquo;>&rdquo; para citar",
"Storing files in a directory" => "Gardando ficheiros nun directorio",
"please read" => "por favor, lea",
"yes" => "si",
"Click here for more details." => "Prema aquí para máis detalles.",
"Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "As preferencias do Tiki na base de datos (bd) están configuradas para o máximo de 250 caracteres por defecto ata o de agora. Iso tamén serve para o contido do código personalizable. Marque este campo se quere actualizar as súas preferencias na táboa da base de datos para permitir máis de 250 caracteres (aínda que foi probado e funciona ben en mysql, recoméndase que faga unha copia de seguridade dos seus datos manualmente antes de calquera actualización da base de datos)",
"Users &amp; groups" => "Usuarios &amp; grupos",
"private" => "privado",
"<b>Item</b>" => "<b>ítem</b>",
"<b>Value</b>" => "<b>Valor</b>",
"This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS Modules\" on the application menu, or" => "Esta páxina é para configurar as opcións das fontes RSS xeradas/exportadas polo Tiki. Para ler/importar fontes RSS, busque en \"módulos RSS\" no menú de aplicación, ou",
"<b>Feed</b>" => "<b>Fonte</b>",
"<b>enable/disable</b>" => "<b>habilitar/deshabilitar</b>",
"<b>Max number of items</b>" => "<b>Cantidade máxima de ítems</b>",
"Feed for Articles" => "Fonte para artigos",
"Feed for Weblogs" => "Fonte para blogs",
"Feed for Image Galleries" => "Fonte para galerías de imaxes",
"Feed for File Galleries" => "Fonte para galerías de ficheiros",
"Feed for the Wiki" => "Fonte para o Wiki",
"Feed for individual Image Galleries" => "Fonte para galerías de imaxes individuais",
"Feed for individual File Galleries" => "Fonte para galerías de ficheiros individuais",
"Feed for individual weblogs" => "Fonte para un blog",
"Feed for individual forums" => "Fonte para foros individuais",
"Feed for mapfiles" => "Fonte para ficheiros de mapa",
"Feed for directories" => "Fonte para directorios",
"Feed for tracker items" => "Fonte para ítems de tracker",
"Prefix breadcrumbs with 'Location:' label?" => "Preceder a ruta de acceso coa etiqueta 'Location:'?",
"Site Search" => "Busca en sitio",
"Change style only" => "Cambiar só estilo",
"PDF generation" => "Xeración de PDF",
"Use in CMS" => "Usar en cms",
"Use in Wiki" => "Usar en wiki",
"Use in newsletters" => "Usar en boletíns",
"Use in events" => "Usar en eventos",
"Use in HTML pages" => "Usar en páxinas HTML",
"Edit Existing Forums" => "Editar foros existentes",
"Refresh rate (if dynamic) [secs]" => "Taxa de actualización(se é dinámica) [segs]",
"configure repositories" => "configurar almacéns",
"configure this repository" => "configurar este almacén",
"copy rules" => "copiar regras",
"Create/edit newsletters" => "Crear/editar boletíns",
"subscriptions" => "subscricións",
"archives" => "arquivos",
"Use Admin Email" => "Usar o correo-e do administrador",
"Edit or add poll options" => "Editar ou engadir opcións de votación",
"configure polls" => "configurar votacións",
"Create/edit Polls" => "Crear ou editar votacións",
"Rss channels" => "Canles rss",
"show pubdate" => "mostrar data de publicación",
"activate" => "activar",
"Admin tracker" => "Administrar tracker",
"Edit this tracker" => "Editar tracker ",
"View this tracker items" => "Ver elementos do tracker",
"Edit tracker fields" => "Editar campos do tracker",
"Import/export trackers fields" => "Importar/exportar campos de trackers ",
"Edit tracker" => "Editar tracker",
"Create trackers" => "Crear trackers ",
"Import/export" => "Importar/exportar",
"fields" => "campos",
"active permissions" => "activar permisos",
"Create/edit trackers" => "Crear/editar trackers",
"filename" => "nome de ficheiro",
"filesize" => "tamaño do ficheiro",
"filetype" => "tipo de ficheiro",
"longdesc" => "descrición longa",
"Add a new group" => "Engadir novo grupo",
"Edit item" => "Editar ítem",
"List all members" => "Listar todos os membros",
"Add a new user" => "Engadir un novo usuario",
"manage group assignments" => "xestionar as asignacións de grupo",
"set default groups" => "poñer grupos por defecto",
"Popup Window" => "Fiestra emerxente",
"details" => "detalles",
"change focus" => "cambiar foco",
"quater" => "trimestre",
"quarter" => "trimestre",
"semester" => "semestre",
"No individual permissions global permissions apply" => "Non hai permisos individuais, aplican os permisos globais",
"Welcome to the Tiki Chat Rooms" => "Benvido ás salas de charla do Tiki",
"Please select a chat channel" => "Elixa unha canle de charla",
"enter chat room" => "Entrar ao salón de charla",
"There are no channels setup, please contact a site admin" => "Non hai canles configuradas, por favor contacte co administrador do sitio",
"Chatroom" => "Salón de charla",
"Active Channels" => "Canles activas",
"Users in this channel" => "Usuarios nesta canle",
"Channel Information" => "Información da canle",
"Channel" => "Canle",
"Ratio" => "Razón",
"Use :nickname:message for private messages" => "Usar :alcume:mensaxe para mensaxes privadas",
"Use [URL|description] or [URL] for links" => "Usar [URL|descrición] ou [URL] para ligazóns",
"Use (:smileyname:) for smileys" => "Usar (:nomeemoticona:) para emoticonas",
"Create PDF" => "Crear PDF",
"PDF Settings" => "Configuración de PDF",
"Select Wiki Pages" => "Elixa páxinas wiki",
"Remove Page" => "Eliminar páxina",
"click here to send us an email" => "prema aquí para enviarnos un correo",
"Add or edit a site" => "Engadir ou editar un sitio",
"sites" => "sitios",
"cool sites" => "sitios con máis accesos",
"Use ...page... to separate pages in a multi-page article" => "Use ...páxina... para separar páxinas nun artigo de múltiples páxinas",
"Create Zone" => "Crear zona",
"use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "usar corchetes para unha ligazón externa: [URL] ou [URL| descrición_ligazón] ou [URL|descrición|nocaché] (esta última forma prevén que o wiki coloque esa páxina na cache; por favor, use esa forma para páxinas grandes!).",
"browse image" => "ver imaxe",
"translate" => "traducir",
"Create or edit content" => "Crear ou editar contido",
"this quiz stats" => "estatísticas deste cuestionario",
"answer" => "resposta",
"Edit Translation:" => "Editar tradución:",
"Use this section to set the language of the version you are currently working on." => "Use esta sección para poñer a lingua da versión na cal está a traballar.",
"Set of Translations" => "Conxunto de traducións",
"Select the article for which the current article is the translation." => "Escolla o artigo para o cal o artigo actual é a tradución.",
"Translation of:" => "Tradución de:",
"Enter the name of the page for which the current page is the translation." => "Introduza o nome da páxina para a cal a páxina actual é a tradución.",
"Add to the Set" => "Agregar ao conxunto",
"graph" => "graf",
"Edit FAQ questions" => "Editar preguntas do PMF",
"Edit this file gallery:" => "Editar esta galería de ficheiros:",
"icon" => "icona",
"Other users can upload files to this gallery" => "Outros usuarios poden cargar ficheiros a esta galería",
"Available File Galleries" => "Galerías de ficheiros dispoñibles",
"configure forum" => "configurar foro",
"start" => "comezar",
"end" => "fin",
"Add role" => "Engadir rol",
"active process" => "proceso activo",
"invalid" => "incorrecto",
"invalid process" => "proceso incorrecto",
"valid process" => "proceso válido",
"activities" => "actividades",
"aborted" => "abortada",
"value" => "valor",
"proc" => "proc.",
"exceptions" => "excepcións",
"rollback" => "reverter",
"Create or edit content block" => "Crear ou editar bloque de contido",
"Listing Gallery" => "Contido da galería",
"Gallery Files" => "Ficheiros de Galería",
"Last ver" => "Última  versión",
"Com" => "Com.",
"Vers" => "Vers.",
"subscribe" => "subscribir",
"Sent edition" => "Edición enviada",
"Subscribe to newsletter" => "Subscribirse ao boletín",
"Add or edit a news server" => "Engadir ou editar un servidor de grupos de novas",
"rollback to this version" => "reverter a esta versión",
"Print Wiki Pages" => "Imprimir páginas del Wiki",
"add page" => "engadir páxina",
"entire site" => "todo o sitio",
"click to navigate" => "Premer para navegar",
"Total threads" => "Total de fíos",
"Average threads per topic" => "Media de fíos por tema",
"You can include the file in an HTML/Tiki page using" => "Pode incluír unha ligazón a este ficheiro nunha HTML ou Tiki usando",
"Now enter the file URL" => "Introduza o URL do ficheiro",
" or upload a local file from your disk" => "ou cargue un ficheiro desde o seu disco local",
"Add or edit folder" => "Engadir ou editar carpeta",
"Add or edit a URL" => "Engadir ou editar un URL",
"received" => "recibido/a",
"submitted" => "enviado/a",
"shared" => "compartido/a",
"accepted by task user and creator" => "aceptada polo usuario de tarefa e o creador",
"accepted user and creator" => "aceptado (usuario e creador)",
"not accepted by one user" => "non aceptada por un usuario",
"not accepted user" => " non aceptado (usuario)",
"waiting for me" => "esperando por min",
"waiting for other user" => "esperando por outro usuario",
"red" => "vermello",
"move into trash" => "botar na papeleira",
"waiting / not started" => "esperando / non empezada",
"waiting" => "esperando",
"shared for group" => "compartida para grupo",
"accepted by user" => "aceptada por usuario",
"no / rejected" => "non / rexeitada",
"accepted by creator" => "aceptada polo creador",
"priority" => "prioridade",
"select one" => "seleccione unha",
"undo trash" => "desfacer papeleira",
"show:" => "mostrar:",
"all shared tasks" => "todas as tarefas compartidas",
"previous chart" => "chart anterior",
"next chart" => "seguinte chart",
"pos" => "pos.",
"pre" => "pre.",
"permanency" => "permanencia",
"avg" => "media",
"post new comment" => "enviar comentario",
"Post New Comment" => "Enviar comentario",
"HTML tags are not allowed inside comments" => "Non se admiten etiquetas HTML nos comentarios",
"moderator actions" => "accións de moderador",
"move selected topics" => "mover temas seleccionados",
"unlock selected topics" => "desbloquear temas seleccionados",
"lock selected topics" => "bloquear temas seleccionados",
"merge" => "combinar",
"merge selected topics" => "combinar temas seleccionados",
"reported messages:" => "mensaxes divulgadas:",
"queued messages:" => "mensaxes na cola:",
"emot" => "emot.",
"Edit fields" => "Editar campos",
"View item" => "Visualizar ítem",
"Add a comment" => "Engadir un comentario",
"account" => "conta",
"Projects" => "Proxectos",
"Projects configuration" => "Configuración de proxectos",
"Site Identity features" => "Características de identidade do sitio",
"Click here to delete this category" => "Prema aquí para borrar esta categoría",
"Group doesnt exist" => "O grupo non existe",
"User doesnt exist" => "O usuario non existe",
"Event without Name" => "Evento sen nome",
"Invalid old password" => "O contrasinal introducido é incorrecto",
"No channel indicated" => "Non se indica canle",
"No nickname indicated" => "Non se indica un alcume",
"No permission to view the page" => "Non ten permiso para ver a páxina",
"I have refused your friendship request!" => "Rexeitei a súa solicitude de amizade!",
"Please create a directory named \$map_path to hold your map files." => "Por favor, cree un directorio chamado \$map_path para gardar os seus ficheiros de mapa.",
"Permision denied" => "Permiso denegado",
"clip" => "clip",
"cc" => "cc",
"Phillippines" => "Filipinas",
"sender" => "remitente",
"subject" => "tema",
"date" => "data",
"flagged" => "marcado",
"mark" => "marcar",
"find replied message" => "buscar mensaxe respondida",
"replied" => "respondido",
"Click" => "Clic",
"posted by" => "posteado por",
"email this post" => "mandar mensaje con este post",
"Tag name" => "Nome da etiqueta",
"Enable wiki 3D browser" => "Activar navegador wiki 3D",
"Existing page node color" => "Cor de nodo dunha páxina existente",
"Missing page node color" => "Cor de nodo dunha páxina inexistente",
"Anonymous editors must input anti-bot code" => "Editores anónimos deben introducir un código anti-robot",
"Edit idle timeout" => "Tempo límite de espera para a edición",
"Use page description" => "Usar descrición da páxina",
"Show page title" => "Mostrar título da páxina",
"Show page ID" => "Mostrar ID da páxina",
"Cache wiki pages (global)" => "Cachear páxinas wiki (global)",
"Users can lock pages (if perm)" => "Usuarios con permiso poden bloquear páxinas",
"Use WikiWords" => "Use as PalabrasWiki ",
"Use Wiki paragraph formatting" => "Usar formato Wiki de parágrafos ",
"Use external link icons" => "Usar iconas para ligazóns externas",
"User's Page" => "Páxina de Usuario",
"UserPage prefix" => "Prefixo de Páxina de Usuario",
"List authors" => "Listar autores",
"Maximum number of versions for history" => "Cantidade máxima de versións no historial",
"Never delete versions younger than days" => "Non eliminar nunca versións con antigüidade inferior a (días)",
"Diff style" => "Estilo de Diff",
"Old vers" => "Versións antigas",
"Add or edit event" => "Engadir ou editar evento",
"merge selected notes into" => "combinar notas seleccionadas en",
"Faq Stats" => "Estatísticas de PMFs",
"Edit User Files" => "Editar ficheiros de usuario",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "A súa mensaxe quedou na fila para aprobación; a mensaxe será publicada despois de que\n un moderador a aprobe.",
"Webmail Doc" => "Documentación de Correo Web ",
"Webmail Doc template" => "Modelo de correo web",
"settings" => "configuración",
"mailbox" => "caixa de correo",
"compose" => "redactar",
"contacts" => "contactos",
"back to mailbox" => "volver á caixa do correo",
"full headers" => "ver cabeceiras",
"normal headers" => "cabeceiras normais",
"reply all" => "responder a todos",
"forward" => "reenviar",
"select from address book" => "elixir desde a axenda de enderezos",
"ImportingPagesPhpWikiPageAdmin" => "ImportingPagesPhpWikiPageAdmin",
"Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Opcións de texto: 1,tamaño, prefixar, sufixar, tamaño máximo en caracteres, prefixar será despregado antes do campo, sufixar será mostrado xusto despois, max. é o número máximo de caracteres que poden gardarse, e o 1 inicial para facer que o seguinte campo de texto ou cela de verificación estea na mesma fila. Se indica só 1, significa que o seguinte campo tamén estará na mesma fila.",
"Checkbox options: put 1 if you need that next field is on the same row." => "Opcións de cela de verificación: poña 1 se precisa que o seguinte campo estea na mesma fila.",
"Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Opcións numéricas: 1,tamaño,prefixar,sufixar. Con tamaño en caracteres, prefixar despregarase antes do campo, sufixar despregarase xusto despois, e o 1 inicial para facer que o seguinte campo de texto ou cela de verificación estea na mesma liña. Se indica só 1, significa que o seguinte campo estará tamén na mesma fila.",
"Dropdown options: list of items separated with commas." => "Opcións despregables: lista de ítems separados por comas.",
"Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Selector de Grupo: use opcións para a alimentación automática do campo: pode usar 1 para o grupo de creación e 2 para o grupo de onde vén a modificación. O grupo por defecto debe de configurarse, ou o primeiro grupo que vén é elixido polo usuario, ou o grupo por defecto é \"Registered\".",
"Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Opcións de acción: etiqueta, enviar, tiki-index.php, páxina:nomedecampo,resaltar=test",
"Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Opcións de enderezo de correo-e:: 0|1|2, onde 0 pon o enderezo en texto simple, 1 pon a codificación hexadecimal da ligazón mailto (é máis difícil para arañas web recoñecelo e enviar correo lixo) e 2 fai o href mailto normal.",
"new sites" => "novos sitios",
"Message Broadcast" => "Difusión da mensaxe",
"Are you sure you want to remove this module?" => "Está seguro de que quere borrar este módulo?",
"database queries used" => "consultas usadas na base de datos",
"{\$atts_cnt} files attached" => "{\$atts_cnt} ficheiros anexados",
"pass" => "contrasinal",
"Page generated in" => "Páxina xerada en",
"sent" => "enviado",
"Homework" => "Deberes",
"Assignments" => "Asignacións",
"Favorites" => "Favoritos",
"Member list" => "Lista de membros",
"Back to Homepage" => "Volver ao inicio",
"Minor" => "Menor",
"Last update from CVS" => "Última actualización desde CVS",
"Translate in" => "Traducir en",
"babelfish it" => "mandar a babelfish",
"Welcome to" => "Benvido a",
"Content Features" => "Características de contido",
"Contact Us (Anonymous)" => "Contactar con nós (Anónimo)",
"Prevent automatic/robot registration" => "Previr rexistro automático/robots",
"Site Logo" => "Logo do sitio",
"Admin Groups Template" => "Modelo para administrar grupos",
"Help on Banning System" => "Axuda respecto ao Sistema de Expulsión",
"Admin banning tpl" => "Modelo para administrar expulsión",
"Create/edit Calendars" => "Crear/editar calendarios",
"Admin Categories tpl" => "Modelo de administrar categorías",
"charts" => "gráficos",
"Admin Charts Template" => "Modelo de administrar charts",
"Chat Administration" => "Administración da Charla",
"Chat Admin" => "Administrar charla",
"Chat Admin tpl" => "Modelo de administrar charla",
"Create/edit channel" => "Crear ou editar canle",
"Half a second" => "Medio segundo",
"second" => "segundo",
"Chat channels" => "Canles de charla ",
"Admin Content Templates Template" => "Modelo de administrar modelos de contido",
"Help on Drawings" => "Axuda en debuxos",
"Admin DSN" => "Administrar DSN",
"tiki-admin_dsn tpl" => "Modelo de tiki-admin_dsn",
"Admin Forums Template" => "Modelo de administrar foros",
"Admin Hotwords Template" => "Modelo de administrar palabras clave",
"Admin Featured Links" => "Administrar ligazóns destacadas",
"Admin Featured Links Template" => "Administrar modelo de ligazóns destacadas",
"Admin Webmail" => "Administrar correo web",
"Admin Mailing Template" => "Modelo de administrar entrada de correo",
"Admin Menu Builder" => "Administrar construtor de menús",
"Admin Menus Template" => "Modelo administrar menús",
"Admin Modules Template" => "Modelo de administrar módulos",
"Assign Module" => "Asignar módulo",
"Edit/Create" => "Editar/Crear",
"subscribed" => "subscrito",
"Admin Newsletters Template" => "Modelo de administrar boletíns",
"Admin Notifications Template" => "Modelo de administrar notificacións",
"Admin Polls Template" => "Modelo de administrar votacións",
"Configure Polls" => "Configurar votacións",
"tiki admin quicktags template" => "modelo tiki de administrar etiquetas rápidas ",
"Score System" => "Sistema de Puntuación",
"security admin" => "Administrar seguridade",
"security admin tpl" => "Modelo de administrar seguridade",
"Admin Shoutbox Words Template" => "Modelo de administrar palabras do taboleiro de anuncios",
"Edit survey questions" => "Editar preguntas da enquisa",
"administer surveys template" => "modelo de administrar enquisas",
"system admin" => "administración de sistema",
"system admin tpl" => "modelo de administración do sistema",
"Admin Topics Template" => "Modelo para administrar temas",
"Admin Tracker" => "Administrar tracker",
"Admin Users Template" => "Modelo de administrar usuarios",
"Again" => "Outra vez",
"Article Types tpl" => "modelo para tipos de artigo",
"Assign permissions to group" => "Asignar permisos ao grupo",
"Edit Article Tpl" => "Modelo de editar artigo ",
"Browsing Gallery" => "Navegando pola Galería",
"Admin Directory tpl" => "Modelo de administrar directorio",
"Admin Directory Categories tpl" => "Modelo de administrar categorías de directorio",
"Admin Directory Related" => "Administrar directorio relacionado",
"directory admin related tpl" => "modelo de administrar categorías relacionadas",
"Admin Directory Sites" => "Administrar sitios de directorio",
"Admin Directory Sites tpl" => "modelo de administrar sitios de directorio",
"Validate Sites" => "Validar Sitios",
"directory validate sites tpl" => "modelo de validar sitios de directorio",
"Edit Article" => "Editar artigo",
"Edit Blog Tpl" => "Modelo de editar blog",
"Show Plugins Help" => "Ver axuda de plugins",
"Show Text Formatting Rules" => "Ver Regras para Formatar texto",
"Program dynamic content for block" => "Programar contido dinámico para o bloque",
"Admin quizzes" => "Administrar cuestionarios",
"Admin Quizzes tpl" => "Modelo de administrar cuestionarios",
"Edit Quiz Questions" => "Editar preguntas do cuestionario",
"Edit Quiz Questions Tpl" => "Modelo de editar preguntas do cuestionario",
"Help on Articles" => "Axuda en artigos",
"Edit Submissions Tpl" => "Modelo de editar colaboracións",
"EditTemplates" => "EditarModelos",
"EditTemplates tpl" => "Modelo de EditarModelos",
"Edit Translations" => "Editar traducións",
"Edit Translations Template" => "Modelo de editar traducións",
"Message queue for" => "Cola de mensaxes para",
"back to forum" => "volver ao foro",
"Reported messages for" => "Mensaxes notificadas para",
"friends tpl" => "modelo de amigos",
"galleries tpl" => "modelo de galerías ",
"tiki-import_phpwiki tpl" => "Modelo de tiki-import_phpwiki",
"hist" => "hist.",
"List Articles Tpl" => "Modelo de listar artigos",
"Admin Cache" => "Administrar caché",
"Admin Cache tpl" => "Modelo de administrar caché",
"Help on Dynamic Content" => "Axuda en contido dinámico",
"List FAQs Tpl" => "Modelo de listar pmfs",
"games tpl" => "modelo de xogos ",
"List Posts Tpl" => "Modelo para listar envíos",
"List Quizzes Tpl" => "Modelo de listar cuestionarios",
"Edit Quiz Stats Tpl" => "Modelo de editar estatísticas do cuestionario",
"List Trackers Tpl" => "Modelo de listar trackers",
"Admin Live Support tpl" => "Modelo de administrar asistencia en liña",
"back to admin" => "volver a administración",
"User Calendar" => "Calendario do usuario",
"User Calendar Doc tpl" => "modelo de Calendario de Usuario",
"User Calendar Doc" => "Documentación de Calendario de Usuario",
"User Calendar Preferences Doc tpl" => "Modelo de Preferencias de Calendario do Usuario",
"my tiki tpl" => "modelo de O meu tiki",
"Subscribe to This Newsletter" => "Subscribirse",
"Stats for quiz" => "Estatísticas para cuestionario",
"Received Articles" => "Artigos recibidos",
"received articles tpl" => "modelo de artigos recibidos",
"Help on Communication Center" => "Axuda sobre Centro de Comunicacións",
"received pages tpl" => "modelo de páxinas recibidas",
"Rename page" => "Renomear a páxina",
"to_version" => "á versión",
"search stats tpl" => "modelo de estatísticas de busca",
"Admin Send Objects tpl" => "Modelo de administrar envío de obxectos",
"sheets tpl" => "modelo de follas de cálculo",
"Stats for survey" => "Estatísticas para a enquisa",
"system logs" => "rexistro do sistema",
"system logs tpl" => "modelo de rexistro do sistema",
"Theme Control Center: categories" => "Centro de Control de Decorados: categorías",
"ThemeControl" => "ControlDeDecorados",
"ThemeControl tpl" => "modelo de ControlDe Decorados",
"ThemeControl Objects" => "Obxectos de ControlDeDecorados ",
"theme control objects tpl" => "modelo de obxectos de control de decorados",
"Theme Control Center: sections" => "Centro de Control de Decorados: seccións",
"theme control sections tpl" => "modelo de seccións de control de decorado",
"File Title" => "Título do ficheiro",
"Image Gallery tpl" => "Modelo de Galería de Imágenes",
"User Assigned Modules" => "Módulos Asignados polo Usuario",
"User Assigned Modules tpl" => "modelo de Módulos asignados polo usuario",
"User Bookmarks tpl" => "modelo de marcadores de usuario",
"UserPreferences tpl" => "Modelo de preferencias de usuario",
"User Tasks tpl" => "modelo de Tarefas de Usuario",
"User Watches tpl" => "Modelo de monitores de usuario",
"View FAQ Tpl" => "Modelo de ver pmf",
"Admin Menus tpl" => "Modelo de administrar menús",
"IRC log" => "log de IRC",
"Edit mail account" => "Editar conta de correo",
"Add new mail account" => "Engadir conta de correo",
"User accounts" => "Contas de usuario",
"View All" => "Visualizar todos",
"Msg" => "Msx",
"Can't parse remote HTML page" => "Non podo procesar unha páxina HTML remota",
"Permission denied you cannot remove pages" => "Permiso denegado: non pode borrar páxinas",
"LDAP Base DN" => "LDAP Base DN",
"LDAP User DN" => "LDAP User DN",
"LDAP User OC" => "LDAP User OC",
"LDAP Group Attribute" => "LDAP Group Attribute",
"LDAP Member Is DN" => "LDAP Member Is DN",
"LDAP Admin User" => "LDAP Admin User",
"LDAP Admin Pwd" => "LDAP Admin Pwd",
"Geourl" => "Geourl",
"meta robots" => "meta robots",
"Zoom" => "Zoom",
"SysLog" => "SysLog",
"Cannot write to this file" => "Non podo escribir neste ficheiro",
"Missing title or body when trying to post a comment" => "Falta o título ou o texto",
"\\n for rows" => "\\n para filas",
"Use this thread to discuss the %s page." => "Use esta liña para discutir a páxina %s.",
"Newsletter subscription information at " => "Información de subscrición a boletín en ",
"Changes" => "Cambios",
"categorize this object" => "categorizar este obxecto",
"Your account request have been stored and will be activated by the admin as soon as possible." => "A súa solicitude de conta foi almacenado e será activado polo administrador o máis axiña posible.",
"New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Novo artigo enviado: {\$mail_title} por {\$mail_user} en {\$mail_date|tiki_short_datetime}",
"New article post at %s" => "Novo artigo enviado en %s",
"Syntax highlighting" => "Resaltado de Sintaxe",
"MyTiki Home" => "Inicio do meu Tiki",
"My Files" => "Os meus ficheiros",
"Mini calendar" => "Calendario",
"FriendsMenu" => "Menú de amigos",
"User list" => "Lista de usuarios",
"Send Pages" => "Enviar páxinas",
"Received pages" => "Páxinas recibidas",
"Admin Posts" => "Administrar mensaxes",
"Submit a New Link" => "Enviar unha nova ligazón",
"Browse directory" => "Explorar directorio",
"Admin Directory" => "Administrar directorio",
"Layer Management" => "Xestión de capas",
"List quizzes" => "Listar cuestionarios",
"ShtMenu" => "ShtMenú",
"List trackers" => "Listar trackers",
"Ephemerides Admin" => "Administrar efemérides",
"Charts Admin" => "Administrar gráficas",
"Debugger console" => "Consola de depuración",
"I forgot my pass" => "Esquecín o meu contrasinal",
"Click to see the ratings" => "Prema para ver as cualificacións",
"Send trackback pings to:" => "Enviar pings de trackback a:",
"(comma separated list of URIs)" => "(lista de URIs separadas por comas)",
"This is" => "Isto é",
"by the" => "pola",
"Tiki community" => "Comunidade Tiki",
"User identity features" => "Características da identidade do usuario",
"Use URI as Home Page" => "Usar URI como páxina de inicio",
"OS" => "Sistema operativo",
"Default charset for sending mail:" => "Conxunto de xogo de caracteres por defecto para enviar correo:",
"Mail end of line:" => "Fin de liña do correo:",
"Disallow access to the site (except for those with permission)" => "Desactivar o acceso ao sitio (agás para aqueles con permiso)",
"Message to display when site is closed" => "Mensaxe para mostrar cando o sitio está pechado",
"Disallow access when load is above the threshold (except for those with permission)" => "Desactivar o acceso cando a carga estea por riba do límite (agás para aqueles con permiso)",
"Max average server load threshold in the last minute" => "Límite máximo de carga media do servidor no último minuto",
"Message to display when server is too busy" => "Mensaxe para mostrar cando o servidor está moi ocupado",
"Use cache for external images" => "Usar caché para as imaxes externas",
"Use gzipped output" => "Usar saída comprimida con gzip",
"output compression is active." => "a compresión de saída está activa.",
"compression is handled by" => "a compresión é manexada por",
"Sender Email" => "Correo remitente",
"Allow anonymous users to \"Contact Us\"" => "Permitir a usuarios anónimos o \"Contactarnos\"",
"contact feature disabled" => "Función de contacto deshabilitada",
"Session lifetime in minutes" => "Tempo de vida da sesión en minutos",
"Proxy Host" => "Servidor Proxy",
"Proxy port" => "Porto Proxy",
"Locations separator" => "Separador de localizacións",
"User registration and login" => "Rexistro e inicio de sesión do usuario",
"Use WebServer authentication for Tiki" => "Usar autenticación do servidor web para o Tiki",
"... but need admin validation" => "... pero precisa a validación de admin",
"Use tracker for more user information" => "Usar o tracker para máis información dos usuarios",
"Use tracker for more group information" => "Usar o tracker para máis información dos grupos",
"Request passcode to register" => "Solicitar código de paso para rexistrarse",
"Php GD library required" => "biblioteca Php GD requirida",
"Validate users by email" => "Validar usuarios por correo",
"Store plaintext passwords" => "Gardar os contrasinais en texto simple",
"Reg users can change password" => "Os usuarios rexistrados poden cambiar de contrasinal",
"Reg users can change language" => "Os usuarios rexistrados poden cambiar de lingua",
"Restrict available languages" => "Restrinxir linguas dispoñibles",
"Available languages:" => "Linguas dispoñibles:",
"Force to use chars and nums in passwords" => "Obrigar a usar letras e números nos contrasinais",
"Minimum password length" => "Lonxitude mínima do contrasinal",
"Password invalid after days" => "Invalidar contrasinal logo de días",
"Remember me feature" => "Características Recordarme",
"Duration:" => "Duración:",
"Remember me name" => "Nome para Recordarme",
"Remember me domain" => "Dominio para Recordarme",
"Remember me path" => "Camiño para Recordarme",
"Protect against CSRF with a confirmation step" => "Protexer contra CSRF cun paso de confirmación",
"Highlight Group" => "Destacar Grupo",
"Create user if not in Tiki?" => "Crear usuario se non estiver no Tiki?",
"Create user if not in Auth?" => "Crear usuario se non estiver en Auth",
"Just use Tiki auth for admin?" => "Usar só a autenticación do Tiki para o administrador?",
"LDAP URL<br />(if set, this will override the Host and Port below)" => "URL de LDAP<br />(se posta, prevalecerá sobre o servidor e o porto que seguen)",
"LDAP Host" => "Servidor LDAP",
"LDAP Port" => "Porto LDAP",
"LDAP Scope" => "Scope LDAP",
"LDAP User Attribute" => "LDAP User Attribute LDAP",
"LDAP Group DN" => "LDAP Grupo DN",
"LDAP Group OC" => "LDAP Grupo OC",
"LDAP Member Attribute" => " LDAP Member Attribute",
"CAS server hostname" => "Nome do servidor CAS",
"CAS server port" => "Porto do servidor CAS",
"CAS server path" => "Ruta do servidor CAS",
"Change CAS preferences" => "Cambiar as preferencias CAS",
"Meta Keywords" => "Meta palabras clave",
"Meta Description" => "Meta descrición",
"Meta Author" => "Meta Autor",
"revisit after" => "revisitar despois",
"Allow Smileys" => "Permitir emoticonas",
"Hotwords in New Windows" => "Palabras clave en novas fiestras",
"Trackers attachments preferences" => "Preferencias de anexos a trackers",
"Trackers attachments" => "Arquivos asociados a trackers",
"To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "Para agregar/editar páxinas wiki facilmente, agregue o módulo quick_edit via \"Módulos\" no menú de aplicación, ou",
"Create a Tag for the Current Wiki" => "Crear unha etiqueta para o wiki actual",
"Restore the Wiki" => "Restaurar o wiki",
"restore" => "recuperar",
"Remove a Tag" => "Quitar unha etiqueta",
"Wiki Comments Settings" => "Configuracións para comentarios do wiki",
"Wiki Administration" => "Administración wiki",
"Wiki Home Page" => "Páxina de Inicio do Wiki",
"Wiki Discussion" => "Discusión Wiki",
"Wiki Link Format" => "Formato de Ligazón Wiki",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Controla o recoñecemento de ligazóns Wiki usando a sintaxe de ligazóns wiki de dúas parénteses <i>((nome páxina))</i>.",
"Wiki Page List Configuration" => "Configuración da listaxe de páxinas wiki",
"Wiki 3D Browser Configuration" => "Configuración do navegador wiki 3D",
"Wiki Features" => "Características do Wiki",
"Wiki History" => "Historial do Wiki",
"Wiki Watch" => "Monitor do Wiki",
"browse the category system" => "percorrer o sistema de categorías",
"Admin Charts" => "Administrar gráficas",
"Add new rule" => "Engadir nova regra",
"EMail notifications" => "Notificacións por correo-e",
"Edit this RSS module:" => "Editar este módulo RSS:",
"Create new RSS module" => "Crear novo módulo RSS",
"Tikiwiki settings" => "Configuracións para o Tikiwiki",
"Create/edit questions for survey" => "Crear/editar preguntas para enquisa",
"Active?" => "Activo?",
"Create Trackers" => "Crear trackers ",
"Create/Edit Trackers" => "Crear/editar trackers",
"Create item" => "Crear ítem",
"Assign to Groups" => "Asignar a grupos",
"Delete this type" => "Borrar este tipo",
"Browse gallery" => "Percorrer galería",
"Upload from disk" => "Cargar desde disco",
"Directory batch" => "Carga de directorio",
"Browsing Image" => "Explorando imaxe",
"Again please" => "Repetir, por favor",
"Admin category relationships" => "Administrar as relacións entre categorías",
"Validate links" => "Validar ligazóns",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "Os ficheiros con nomes rematados en -{\$user} son modificables, outros son só duplicables e serán usados como modelo.",
"Im- Export Languages" => "Importar ou exportar linguas",
"disable" => "desactivar",
"Create a file gallery" => "Crear galería de ficheiros",
"Support tickets" => "Tíckets de asistencia",
"Return to HomePage" => "Regresar ao inicio",
"Stats for this survey Questions " => "Estatísticas para as preguntas desta enquisa",
"Batch upload" => "Carga por lote",
"1 suggestion" => "1 suxestión",
"suggestions" => "suxestións",
"Minor Edit" => "Menor",
"You can not download files" => "Non pode descargar ficheiros",
"cannot be found" => "non se pode atopar",
"Invalid password.  Your current password is required to change administrative information" => "Contrasinal incorrecto. Requírese o seu contrasinal actual para cambiar información administrativa",
"Please wait 2 minutes between posts" => "Por favor, espere dous minutos entre as mensaxes",
"The text in RED is" => "O texto en VERMELLO é",
"Show Categories" => "Mostrar categorías",
"Hide Categories" => "Ocultar categorías",
"Wiki page %s changed" => "A páxina Wiki %s cambiou",
"Blog features" => "Características dos blogs",
"Blog level comments" => "Comentarios para blogs",
"Post level comments" => "Comentarios para artigos",
"Spellchecking" => "Comprobación ortográfica",
"Default ordering for blog listing" => "Ordenación por defecto para listaxe de blogs",
"Blog listing configuration (when listing available blogs)" => "Configuración de listaxe de blog (cando liste blogs dispoñibles)",
"Last modification time" => "Data da última modificación",
"Blog comments settings" => "Configuración de comentarios en blogs",
"Group calendar sticky popup" => "Emerxente pegañento do calendario de grupo",
"Group calendar item view tab" => "Lingüeta de visualización do ítem do calendario de grupo",
"Show Category Path" => "Mostrar o camiño das categorías",
"Show Category Objects" => "Mostrar obxectos da categoría",
"Search may show forbidden results. Much better performance though." => "A busca pode devolver resultados prohibidos, pero xeran moito mellor rendemento.",
"CMS features" => "Características do CMS",
"Use templates" => "Usar modelo",
"Settings for page articles home" => "Opcións para páxina de inicio de artigos",
"Maximum number of articles in home" => "Cantidade máxima de artigos no inicio",
"Article comments settings" => "Configuracións para comentarios de artigos",
"Fields to display on page" => "Campos para mostrar na páxina",
"Expire Date" => "Data de expiración",
"Copyright Management" => "Xestión de dereitos de copia",
"License Page" => "Páxina de licenza",
"Submit Notice" => "Enviar aviso",
"To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "Para agregar/borrar galerías de ficheiros, vaia a \"Galerías de Ficheiros\" no menú de aplicación, ou",
"Uploaded filenames must match regex" => "Os nomes dos ficheiros cargados deben emparellar con esta expresión regular",
"Uploaded filenames cannot match regex" => "Os nomes dos ficheiros cargados non deben emparellar con esta expresión regular",
"File galleries comments settings" => "Configuración dos comentarios das galerías de ficheiros",
"File galleries search indexing" => "Indexado para a busca de galerías de ficheiros",
"Leave command blank to delete handler" => "Deixe a orde en branco para borrar o manexador",
"Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Use %1 onde o nome interno debe ser substituído (exemplo: \"strings %1\" para converter o documento en texto usando a orde strings de unix)",
"Enable auto indexing on file upload or change" => "Activar auto-indexado en caso de carga ou cambio de ficheiro",
"System command" => "Orde de sistema",
"Home Forum" => "Foro inicial",
"Forums features" => "Características dos foros",
"Forum quick jumps" => "Accesos rápidos de foros",
"Ordering for forums in the forum listing" => "Orde dos foros na lista de foros",
"Forum listing configuration" => "Configuración de listaxe de foros",
"Show Babelfish Translation URLs" => "Mostrar os URL de tradución de Babelfish",
"Show Babelfish Translation Logo" => "Mostrar logo de tradución de Babelfish",
"Show Module Controls" => "Mostrar controis de módulo",
"Users can Configure Modules" => "Os usuarios poden configurar os módulos",
"Users can Shade Modules" => "Os usuarios poden sombrear os módulos",
"module decides" => "módulo decide",
"Allow Anonymous Poll Voting" => "Permitir voto anónimo en votacións",
"Performance issues" => "Temas de rendemento",
"Search features" => "Funcións de busca",
"SearchStats" => "Estatística de busca",
"Settings for searching content" => "Configuración para buscar contido",
"Search refresh rate" => "Taxa de actualización de busca",
"this survey stats" => "estatísticas desta enquisa",
"bold" => "grosas",
"italic" => " cursiva ",
"underline" => "subliñado",
"hr" => "hr (liña horizontal de separación)",
"Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./setup.sh\" for example)." => "Apache ten o dereito a escribir no seu sistema de ficheiros, que permite a instalación, borrado ou actualización de paquetes. Cando termine esas operacións, pense en volver eses permisos de novo a un estado seguro (usando ./setup.sh, p/ex)",
"To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./setup.sh open\" to set it up). After installation you need to remove that permission (using \"./setup.sh\")." => "Para instalar, borrar ou actualizar paquetes, necesita darlle ao usuario do apache o dereito a escribir ficheiros na súa árbore web (pode usar \"./setup.sh open\" para deixalo así)). Despois da instalación debe borrar eses permisos (usando \"./setup.sh\").",
"theme" => "decorado ",
"You have {\$unread} unread private messages" => "Ten {\$unread} mensaxes privadas non lidas",
"unread private messages" => "mensaxes privadas sen ler",
"WfMenu" => "WfMenu",
"ForMenu" => "ForMenu",
"DirMenu" => "DirMenu",
"SrvMenu" => "SrvMenu",
"EphMenu" => "EphMenu",
"This module requires parameters trackerId and name set" => "Este módulo requiere cubrir os parámetros Idtracker e nome ",
"you or someone registered this email address at" => "vostede ou alguén rexitrou este enderezo de correo en",
"Your Tiki information registration" => "A súa información de rexistro no Tiki",
"left/right" => "esquerda/dereita",
"Unassign module" => "Inhabilitar módulo",
"home" => "inicio",
"chat" => "charla",
"contact us" => "Póñase en contacto con nós",
"debugger console" => "consola de depuración",
"MyMenu" => "O meu menú",
"User menu" => "Menú do usuario",
"WikiMenu" => "Menú Wiki",
"dump" => "envorcado",
"rankings" => "clasificacións ",
"orphan pages" => "páxinas orfas",
"sandbox" => "caixa de area ",
"received pages" => "páxinas recibidas",
"structures" => "estruturas",
"GalMenu" => "Menú de galerías de imaxes",
"Articles Home" => "Inicio de artigos",
"Send articles" => "Enviar artigos",
"Create/Edit Blog" => "Crear/Editar blog",
"Browse Directory" => "Explorar directorio",
"FileGalMenu" => "MenúGalFicheiro",
"Admin FAQs" => "Administrar PMF",
"Edit mapfiles" => "Editar ficheiros de mapa",
"QuizMenu" => "QuizMenú",
"Admin quiz" => "Administrar cuestionario",
"TrkMenu" => "TrkMenú",
"Admin trackers" => "Administrar os trackers",
"Send newsletters" => "Enviar boletíns",
"Send events" => "Enviar eventos",
"Admin events" => "Administrar eventos",
"Ephemerides" => "Efemérides",
"ChartMenu" => "Menú de gráficos",
"AdmMenu" => "MenúAdm",
"Admin home" => "Inicio de Administración ",
"Backups" => "Copias de seguridade",
"Edit languages" => "Editar linguaxes",
"External wikis" => "Wikis externos",
"Mods Admin" => "Administrar Mods",
"UsrMenu" => "Menú usuario",
"Click here to manage your personal menu" => "Prema aquí para manexar o seu menú persoal",
"Quick edit a Wiki page" => "Edición rápida de páxina wiki",
"Language: " => "Lingua: ",
"Sort posts by:" => "Ordenar artigos por:",
"read more" => "ler más",
"Pass" => "contrasinal",
"System Admin" => "Administrar sistema",
"Misc" => "Misc",
"Displays an miniquiz" => "Amosa un minicuestionario",
"some text" => "algún texto",
"Creates a box with the data" => "Crea unha caixa cos datos",
"creates a title bar" => "crea unha barra de título",
"creates a table" => "crea unha táboa",
"makes a horizontal rule" => "fai unha liña horizontal",
"page|desc" => "páxina|desc",
"displays an image" => "mostra unha imaxe",
"Non cacheable images" => "Imaxes non almacenables en caché",
"height width desc link and align are optional" => " height (altura), width (anchura), desc (descrición), link (ligazón) e align (aliñación) son opcionais",
"Wiki File Attachments" => "Anexos ao Wiki",
"displays rss feed with id=n maximum=m items" => "mostra a fonte rss con id=n e cantidade máxima de ítems=m",
"Will be replaced by the actual value of the dynamic content block with id=n" => "Será substituído polo valor actual do bloque de contido dinámico con id=n",
"\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" imprime unha táboa de contidos para a páxina actual baseada en estruturas (toc) ou encabezados! (maketoc)",
"Click to Navigate" => "Premer para navegar",
"Focus:" => "Foco:",
"Tiki User Registration Request" => "Solicitude de rexistro de usuario Tiki",
"Tiki email notification" => "Notificación de correo do Tiki",
"Your Tiki account information for %s" => "A súa información de conta Tiki para %s",
"Reg users can change theme" => "Os usuarios rexistrados poden cambiar de decoración",
"Create/Edit Newsletters" => "Crear/editar boletíns",
"Tiki Shoutbox" => "Taboleiro de anuncios Tiki",
"Allow sites in this category" => "Permitir sitios nesta categoría",
"Show number of sites in this category" => "Mostrar número de sitios nesta categoría",
"Subcategories" => "Subcategorías",
"Admin related categories" => "Administrar categorías relacionadas",
"Add a Category" => "Agregar categoría",
"in current category" => "na categoría actual",
"Total categories" => "Total de categorías",
"Days online" => "Días en liña",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "Cookies must be allowed to vote" => "Cookies must be allowed to vote",
// "This forum is flat and doesn't allow replies to other replies" => "This forum is flat and doesn't allow replies to other replies",
// "Copyright management" => "Copyright management",
// "Tiki is unable to connect to the database " => "Tiki is unable to connect to the database ",
// "Tiki was unable to retrieve login data from the database " => "Tiki was unable to retrieve login data from the database ",
// "The following error message was returned" => "The following error message was returned",
// "Things to check" => "Things to check",
// "Is your database up and running" => "Is your database up and running",
// "Are your database login credentials correct" => "Are your database login credentials correct",
// "Did you complete the <a href='tiki-install.php' >Tiki Installer" => "Did you complete the <a href='tiki-install.php' >Tiki Installer",
// "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information" => "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information",
// "Uploaded" => "Uploaded",
// "Last editor" => "Last editor",
// "Explorer" => "Explorer",
// "Slideshow" => "Slideshow",
// "Default View" => "Default View",
// "Afghanistan" => "Afghanistan",
// "Aland Islands" => "Aland Islands",
// "Aland_Islands" => "Aland_Islands",
// "Albania" => "Albania",
// "American_Samoa" => "American_Samoa",
// "Andorra" => "Andorra",
// "Anguilla" => "Anguilla",
// "Aruba" => "Aruba",
// "Azerbaijan" => "Azerbaijan",
// "Belize" => "Belize",
// "Benin" => "Benin",
// "Bhutan" => "Bhutan",
// "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
// "Bosnia_and_Herzegovina" => "Bosnia_and_Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "Bouvet_Island" => "Bouvet_Island",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "British_Indian_Ocean_Territory" => "British_Indian_Ocean_Territory",
// "British_Virgin_Islands" => "British_Virgin_Islands",
// "Burkina Faso" => "Burkina Faso",
// "Burkina_Faso" => "Burkina_Faso",
// "Burundi" => "Burundi",
// "Cambodia" => "Cambodia",
// "Cameroon" => "Cameroon",
// "Cape Verde" => "Cape Verde",
// "Cape_Verde" => "Cape_Verde",
// "Catalan Countries" => "Catalan Countries",
// "Catalan_Countries" => "Catalan_Countries",
// "Cayman_Islands" => "Cayman_Islands",
// "Central African Republic" => "Central African Republic",
// "Central_African_Republic" => "Central_African_Republic",
// "Chad" => "Chad",
// "Christmas Island" => "Christmas Island",
// "Christmas_Island" => "Christmas_Island",
// "Cocos Islands" => "Cocos Islands",
// "Cocos_Islands" => "Cocos_Islands",
// "Comoros" => "Comoros",
// "Congo Democratic" => "Congo Democratic",
// "Congo" => "Congo",
// "Congo_Democratic" => "Congo_Democratic",
// "Cook_Islands" => "Cook_Islands",
// "Costa_Rica" => "Costa_Rica",
// "Czech_Republic" => "Czech_Republic",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Dominican_Republic" => "Dominican_Republic",
// "El_Salvador" => "El_Salvador",
// "Equatorial Guinea" => "Equatorial Guinea",
// "Equatorial_Guinea" => "Equatorial_Guinea",
// "Eritrea" => "Eritrea",
// "Ethiopia" => "Ethiopia",
// "Europe" => "Europe",
// "Falkland Islands" => "Falkland Islands",
// "Falkland_Islands" => "Falkland_Islands",
// "Faroe Islands" => "Faroe Islands",
// "Faroe_Islands" => "Faroe_Islands",
// "Federated_States_of_Micronesia" => "Federated_States_of_Micronesia",
// "French Guiana" => "French Guiana",
// "French Southern Territories" => "French Southern Territories",
// "French_Guiana" => "French_Guiana",
// "French_Polynesia" => "French_Polynesia",
// "French_Southern_Territories" => "French_Southern_Territories",
// "Gabon" => "Gabon",
// "Gambia" => "Gambia",
// "Georgia" => "Georgia",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greenland" => "Greenland",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guernsey" => "Guernsey",
// "Guinea Bissau" => "Guinea Bissau",
// "Guinea" => "Guinea",
// "Guinea_Bissau" => "Guinea_Bissau",
// "Guyana" => "Guyana",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Heard_Island_and_McDonald_Islands" => "Heard_Island_and_McDonald_Islands",
// "Hong Kong" => "Hong Kong",
// "Hong_Kong" => "Hong_Kong",
// "Isle of Man" => "Isle of Man",
// "Ivory_Coast" => "Ivory_Coast",
// "Jersey" => "Jersey",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Macao" => "Macao",
// "Macedonia" => "Macedonia",
// "Madagascar" => "Madagascar",
// "Maldives" => "Maldives",
// "Mali" => "Mali",
// "Marshall_Islands" => "Marshall_Islands",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mayotte" => "Mayotte",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Myanmar" => "Myanmar",
// "Namibia" => "Namibia",
// "Netherlands Antilles" => "Netherlands Antilles",
// "Netherlands_Antilles" => "Netherlands_Antilles",
// "New_Caledonia" => "New_Caledonia",
// "New_Zealand" => "New_Zealand",
// "Niger" => "Niger",
// "Norfolk Island" => "Norfolk Island",
// "Norfolk_Island" => "Norfolk_Island",
// "North Korea" => "North Korea",
// "North_Korea" => "North_Korea",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "Northern_Mariana_Islands" => "Northern_Mariana_Islands",
// "Oman" => "Oman",
// "Palau" => "Palau",
// "Palestine" => "Palestine",
// "Papua_New_Guinea" => "Papua_New_Guinea",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Puerto_Rico" => "Puerto_Rico",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Republic_of_Macedonia" => "Republic_of_Macedonia",
// "Reunion" => "Reunion",
// "Russian_Federation" => "Russian_Federation",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "Saint_Helena" => "Saint_Helena",
// "Saint_Kitts_and_Nevis" => "Saint_Kitts_and_Nevis",
// "Saint_Lucia" => "Saint_Lucia",
// "Saint_Pierre_and_Miquelon" => "Saint_Pierre_and_Miquelon",
// "San Marino" => "San Marino",
// "San_Marino" => "San_Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Sao_Tome_and_Principe" => "Sao_Tome_and_Principe",
// "Saudi_Arabia" => "Saudi_Arabia",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "Sierra_Leone" => "Sierra_Leone",
// "Solomon_Islands" => "Solomon_Islands",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "South_Africa" => "South_Africa",
// "South_Georgia_and_South_Sandwich_Islands" => "South_Georgia_and_South_Sandwich_Islands",
// "South_Korea" => "South_Korea",
// "Sri_Lanka" => "Sri_Lanka",
// "St_Vincent_Grenadines" => "St_Vincent_Grenadines",
// "Sudan" => "Sudan",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Svalbard_and_Jan_Mayen" => "Svalbard_and_Jan_Mayen",
// "Swaziland" => "Swaziland",
// "Syria" => "Syria",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Trinidad_Tobago" => "Trinidad_Tobago",
// "Tunisia" => "Tunisia",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Turks_and_Caicos_Islands" => "Turks_and_Caicos_Islands",
// "US Virgin Islands" => "US Virgin Islands",
// "US_Virgin_Islands" => "US_Virgin_Islands",
// "Uganda" => "Uganda",
// "United Nations Organization" => "United Nations Organization",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "United_Arab_Emirates" => "United_Arab_Emirates",
// "United_Kingdom" => "United_Kingdom",
// "United_Kingdom_-_England_and_Wales" => "United_Kingdom_-_England_and_Wales",
// "United_Kingdom_-_Northern_Ireland" => "United_Kingdom_-_Northern_Ireland",
// "United_Kingdom_-_Scotland" => "United_Kingdom_-_Scotland",
// "United_Nations_Organization" => "United_Nations_Organization",
// "United_States" => "United_States",
// "United_States_Minor_Outlying_Islands" => "United_States_Minor_Outlying_Islands",
// "Uzbekistan" => "Uzbekistan",
// "Vatican" => "Vatican",
// "Viet Nam" => "Viet Nam",
// "Viet_Nam" => "Viet_Nam",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Wallis_and_Futuna" => "Wallis_and_Futuna",
// "Western Sahara" => "Western Sahara",
// "Western_Sahara" => "Western_Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "the former Yugoslav Republic of Macedonia" => "the former Yugoslav Republic of Macedonia",
// "the_former_Yugoslav_Republic_of_Macedonia" => "the_former_Yugoslav_Republic_of_Macedonia",
// "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter" => "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter",
// "MySQL Improved (mysqli). Requires MySQL 4.1+" => "MySQL Improved (mysqli). Requires MySQL 4.1+",
// "MySQL classic (mysql)" => "MySQL classic (mysql)",
// "PostgeSQL 7.2+" => "PostgeSQL 7.2+",
// "Oracle" => "Oracle",
// "Sybase" => "Sybase",
// "SQLLite" => "SQLLite",
// "MSSQL" => "MSSQL",
// "Email address not valid, test mail not sent" => "Email address not valid, test mail not sent",
// "Email address empty and \"copy\" checkbox not set, test mail not sent" => "Email address empty and \"copy\" checkbox not set, test mail not sent",
// "Test mail from Tiki installer " => "Test mail from Tiki installer ",
// "Tiki version" => "Tiki version",
// "PHP version" => "PHP version",
// "Server" => "Server",
// "Congratulations!\n\nYour server can send emails.\n\n" => "Congratulations!\n\nYour server can send emails.\n\n",
// "Slovene" => "Slovene",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Fijian" => "Fijian",
// "Galician" => "Galician",
// "newest" => "newest",
// "oldest" => "oldest",
// "on left side" => "on left side",
// "on center" => "on center",
// "on right side" => "on right side",
// "Week" => "Week",
// "Month" => "Month",
// "Quarter" => "Quarter",
// "Semester" => "Semester",
// "Depends user language" => "Depends user language",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
// "Each day" => "Each day",
// "Each week" => "Each week",
// "Each month" => "Each month",
// "utf-8" => "utf-8",
// "iso-8859-1" => "iso-8859-1",
// "CRLF (standard)" => "CRLF (standard)",
// "LF (some Unix MTA)" => "LF (some Unix MTA)",
// "15 minutes" => "15 minutes",
// "30 minutes" => "30 minutes",
// "1 hour" => "1 hour",
// "2 hours" => "2 hours",
// "10 hours" => "10 hours",
// "20 hours" => "20 hours",
// "1 year" => "1 year",
// "Encourage secure (https) login" => "Encourage secure (https) login",
// "Consider we are always in HTTPS, but do not check" => "Consider we are always in HTTPS, but do not check",
// "crypt-md5" => "crypt-md5",
// "crypt-des" => "crypt-des",
// "tikihash (old)" => "tikihash (old)",
// "Shibboleth" => "Shibboleth",
// "OpenID and Tiki" => "OpenID and Tiki",
// "Admins" => "Admins",
// "Never use transition css" => "Never use transition css",
// "Use @version:x.x specified in theme css or none if not specified" => "Use @version:x.x specified in theme css or none if not specified",
// "Use @version:x.x specified in theme css or 1.9 if not specified" => "Use @version:x.x specified in theme css or 1.9 if not specified",
// "Use @version:x.x specified in theme css or 2.0 if not specified" => "Use @version:x.x specified in theme css or 2.0 if not specified",
// "LastModif" => "LastModif",
// "Ascending" => "Ascending",
// "Descending" => "Descending",
// "No forums" => "No forums",
// "\$feature is turned on" => "\$feature is turned on",
// "\$feature is turned off" => "\$feature is turned off",
// "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing" => "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing",
// "\$feature set to nothing" => "\$feature set to nothing",
// "Template %s not registered" => "Template %s not registered",
// "Error line: %d" => "Error line: %d",
// "All Day" => "All Day",
// "(not registered)" => "(not registered)",
// "Please wait %d secondes between posts" => "Please wait %d secondes between posts",
// "A contribution is mandatory" => "A contribution is mandatory",
// "Invalid Email" => "Invalid Email",
// "Your message has been queued for approval, the message will be posted after a moderator approves it" => "Your message has been queued for approval, the message will be posted after a moderator approves it",
// "This forum is locked" => "This forum is locked",
// "This thread is locked" => "This thread is locked",
// "Those comments are locked" => "Those comments are locked",
// "Foo" => "Foo",
// "Sample plugin" => "Sample plugin",
// "Face" => "Face",
// "Font family to use" => "Font family to use",
// "As defined by CSS" => "As defined by CSS",
// "Newsletter subscription information at" => "Newsletter subscription information at",
// "Tiki Link - Insert internal link" => "Tiki Link - Insert internal link",
// "Select a Wiki page to link to" => "Select a Wiki page to link to",
// "Cannot open this file" => "Cannot open this file",
// "This is an approximation based on your server memory limit" => "This is an approximation based on your server memory limit",
// "This is the value of your server's PHP '%s' setting" => "This is the value of your server's PHP '%s' setting",
// "You are alerted by the server " => "You are alerted by the server ",
// "You can check the modifications at : " => "You can check the modifications at : ",
// "You are alerted of a change on " => "You are alerted of a change on ",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "Contributions" => "Contributions",
// "Query point" => "Query point",
// "layer" => "layer",
// "Record" => "Record",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it" => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it",
// "menu" => "menu",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "section edit" => "section edit",
// "This poll is closed" => "This poll is closed",
// "Created by profile installer" => "Created by profile installer",
// "Page updated by profile installer" => "Page updated by profile installer",
// "The passwords do not match" => "The passwords do not match",
// "Feed provided by %s. Click to visit" => "Feed provided by %s. Click to visit",
// "Wiki Comment" => "Wiki Comment",
// "Calendar item" => "Calendar item",
// "Tracker item" => "Tracker item",
// "Simple" => "Simple",
// "Advanced" => "Advanced",
// "_HOMEPAGE_CONTENT_" => "_HOMEPAGE_CONTENT_",
// "<!-- jq smarty plugin inactive: feature_jquery off -->" => "<!-- jq smarty plugin inactive: feature_jquery off -->",
// "Fast Next" => "Fast Next",
// "Fast Prev" => "Fast Prev",
// "First {\$params['itemname']}" => "First {\$params['itemname']}",
// "Last {\$params['itemname']}" => "Last {\$params['itemname']}",
// "Next {\$params['itemname']}" => "Next {\$params['itemname']}",
// "Prev {\$params['itemname']}" => "Prev {\$params['itemname']}",
// "You need either JQuery or MooTools enabled for this feature" => "You need either JQuery or MooTools enabled for this feature",
// "Help page" => "Help page",
// "Admin Feature" => "Admin Feature",
// "phplayers are not available on this site" => "phplayers are not available on this site",
// "Invert Sort" => "Invert Sort",
// "sec" => "sec",
// "Gender" => "Gender",
// "No pageviews yet" => "No pageviews yet",
// "n/a" => "n/a",
// "You have to make %d choice(s) for the question" => "You have to make %d choice(s) for the question",
// "You have to make at least %d choice(s) for the question" => "You have to make at least %d choice(s) for the question",
// "You have to make less than %d choice(s) for the question" => "You have to make less than %d choice(s) for the question",
// "You have to choose at least %d choice(s) for the question" => "You have to choose at least %d choice(s) for the question",
// "Page '%0' cannot be found" => "Page '%0' cannot be found",
// "For the security of your password direct access to the feed is only available via https" => "For the security of your password direct access to the feed is only available via https",
// "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors" => "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors",
// "Help link" => "Help link",
// "Edit Plugin" => "Edit Plugin",
// "Edit Section" => "Edit Section",
// "index" => "index",
// "You are not allowed to upload this type of file" => "You are not allowed to upload this type of file",
// "The file you are trying upload was only partially uploaded" => "The file you are trying upload was only partially uploaded",
// "You must select a file" => "You must select a file",
// "Flash player not available" => "Flash player not available",
// "__WARNING__: Plugin disabled \$plugin" => "__WARNING__: Plugin disabled \$plugin",
// "Upload was not successful. Duplicate file content " => "Upload was not successful. Duplicate file content ",
// "Field is not numeric" => "Field is not numeric",
// "Field is not a link to mp3 in the gallery" => "Field is not a link to mp3 in the gallery",
// "Field is not a link to FLV in the gallery" => "Field is not a link to FLV in the gallery",
// "Field is not a link to FLV or MP3 in the gallery" => "Field is not a link to FLV or MP3 in the gallery",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "drop down with other textfield" => "drop down with other textfield",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "radio buttons" => "radio buttons",
// "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>",
// "ip selector" => "ip selector",
// "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>",
// "page selector" => "page selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "country selector" => "country selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>",
// "static text" => "static text",
// "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "dynamic items list" => "dynamic items list",
// "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "multimedia" => "multimedia",
// "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>",
// "auto-increment" => "auto-increment",
// "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "user subscription" => "user subscription",
// "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>",
// "Google Maps" => "Google Maps",
// "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>",
// "computed field" => "computed field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>",
// "user preference" => "user preference",
// "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "The administrator has not yet validated your account. Please wait" => "The administrator has not yet validated your account. Please wait",
// "You must validate your account first. An email has been sent to you" => "You must validate your account first. An email has been sent to you",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "The user email confirmation can't be sent. Contact the administrator" => "The user email confirmation can't be sent. Contact the administrator",
// "Personal Phone" => "Personal Phone",
// "Personal Mobile" => "Personal Mobile",
// "Personal Fax" => "Personal Fax",
// "Work Phone" => "Work Phone",
// "Work Mobile" => "Work Mobile",
// "Work Fax" => "Work Fax",
// "Company" => "Company",
// "Organization" => "Organization",
// "Department" => "Department",
// "Division" => "Division",
// "Job Title" => "Job Title",
// "Street Address" => "Street Address",
// "City" => "City",
// "Zip Code" => "Zip Code",
// "User-Agent Info" => "User-Agent Info",
// "Displays various information about the client" => "Displays various information about the client",
// "Info required - IP|SVRSW|BROWSER" => "Info required - IP|SVRSW|BROWSER",
// "Anchor Link" => "Anchor Link",
// "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin" => "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin",
// "Anchor link label" => "Anchor link label",
// "The anchor name as defined in the ANAME plugin" => "The anchor name as defined in the ANAME plugin",
// "The name of the wiki page containing the anchor" => "The name of the wiki page containing the anchor",
// "Anchor Name" => "Anchor Name",
// "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin" => "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin",
// "The name of the anchor" => "The name of the anchor",
// "Image Annotation" => "Image Annotation",
// "Autogenerated content. Leave blank initially" => "Autogenerated content. Leave blank initially",
// "Absolute URL to the image or relative path from tikiwiki root" => "Absolute URL to the image or relative path from tikiwiki root",
// "Width" => "Width",
// "Image width" => "Image width",
// "Height" => "Height",
// "Image height" => "Image height",
// "Alignment" => "Alignment",
// "Image alignment. Possible values: left, right, center" => "Image alignment. Possible values: left, right, center",
// "Save changes to annotations" => "Save changes to annotations",
// "Image annotations changed" => "Image annotations changed",
// "Creates an annotation block for an image" => "Creates an annotation block for an image",
// "Displays an image and allow the users to define zones to highlight information on the image" => "Displays an image and allow the users to define zones to highlight information on the image",
// "Includes an article\\'s content within the page" => "Includes an article\\'s content within the page",
// "The article field to display. Default field is Heading" => "The article field to display. Default field is Heading",
// "Article ID" => "Article ID",
// "The article to display. If no value is provided, most recent article will be used" => "The article to display. If no value is provided, most recent article will be used",
// "Includes an article" => "Includes an article",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading" => "Id is optional. If not given, last article is used. Default field is heading",
// "Article List" => "Article List",
// "Includes a list of articles within the page" => "Includes a list of articles within the page",
// "Articles displayed" => "Articles displayed",
// "The amount of articles to display in the list" => "The amount of articles to display in the list",
// "Topics expression" => "Topics expression",
// "Topic ID expression" => "Topic ID expression",
// "Type expression" => "Type expression",
// "Category ID" => "Category ID",
// "The ID of the category to list from" => "The ID of the category to list from",
// "The article language to list" => "The article language to list",
// "Sort order" => "Sort order",
// "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")" => "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")",
// "Quiet" => "Quiet",
// "Whether to not report when there are no articles" => "Whether to not report when there are no articles",
// "Title only" => "Title only",
// "Whether to only show the title of the articles" => "Whether to only show the title of the articles",
// "Show body" => "Show body",
// "Whether to only show the body of the articles or just the heading" => "Whether to only show the body of the articles or just the heading",
// "Starting article" => "Starting article",
// "The article number that the list should start with" => "The article number that the list should start with",
// "Start date" => "Start date",
// "Earliest date to select articles from" => "Earliest date to select articles from",
// "End date" => "End date",
// "Latest date to select articles from" => "Latest date to select articles from",
// "Override Dates" => "Override Dates",
// "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings" => "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings",
// "Container class" => "Container class",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~",
// "Bullets" => "Bullets",
// "Inline" => "Inline",
// "Number" => "Number",
// "Show icon" => "Show icon",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Same as name" => "Same as name",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description" => "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "Shows a file icon" => "Shows a file icon",
// "The wiki page the avatar will link to" => "The wiki page the avatar will link to",
// "Float" => "Float",
// "left|right" => "left|right",
// "Displays a link that allows to go back in the browser history" => "Displays a link that allows to go back in the browser history",
// "Insert back link on wiki page" => "Insert back link on wiki page",
// "List all pages linking to the specified page" => "List all pages linking to the specified page",
// "The page links will point to. Default value is the current page" => "The page links will point to. Default value is the current page",
// "Displayed information" => "Displayed information",
// "Pipe separated list of fields to display. ex: hits|user" => "Pipe separated list of fields to display. ex: hits|user",
// "Excluded pages" => "Excluded pages",
// "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox" => "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox",
// "Include Self" => "Include Self",
// "1|0" => "1|0",
// "No Header" => "No Header",
// "Banner" => "Banner",
// "Insert a banner" => "Insert a banner",
// "Target" => "Target",
// "missing parameter" => "missing parameter",
// "Blog List" => "Blog List",
// "Use BLOGLIST to include posts from a blog" => "Use BLOGLIST to include posts from a blog",
// "Blog ID" => "Blog ID",
// "Numeric value" => "Numeric value",
// "Maximum number of entries to list" => "Maximum number of entries to list",
// "Simple list" => "Simple list",
// "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)" => "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)",
// "Earliest date to select posts from" => "Earliest date to select posts from",
// "Latest date to select posts from" => "Latest date to select posts from",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")",
// "Use BLOGLIST to include posts from a blog. Syntax is" => "Use BLOGLIST to include posts from a blog. Syntax is",
// "where Id is the blog Id and Items is the max number of posts to display" => "where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Box" => "Box",
// "Box title" => "Box title",
// "Displayed above the content" => "Displayed above the content",
// "Background color" => "Background color",
// "As defined by CSS, name or Hex code" => "As defined by CSS, name or Hex code",
// "Box width" => "Box width",
// "In pixels or percentage. Default value is 100%" => "In pixels or percentage. Default value is 100%",
// "Text Alignment" => "Text Alignment",
// "Float Position" => "Float Position",
// "for box with width lesser than 100%, make text wrap around the box" => "for box with width lesser than 100%, make text wrap around the box",
// "CSS Class" => "CSS Class",
// "Apply custom CSS class to the box" => "Apply custom CSS class to the box",
// "Category IDs" => "Category IDs",
// "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page" => "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page",
// "Types" => "Types",
// "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img" => "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img",
// "Sort Order" => "Sort Order",
// "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle" => "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle",
// "Split" => "Split",
// "And" => "And",
// "Category Orphans" => "Category Orphans",
// "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker" => "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker",
// "Category Path" => "Category Path",
// "Separator" => "Separator",
// "String used to separate the categories in the path. Default character is >" => "String used to separate the categories in the path. Default character is >",
// "Display top category" => "Display top category",
// "yes|no, default to no" => "yes|no, default to no",
// "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool" => "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool",
// "Chart caption" => "Chart caption",
// "Sheet ID" => "Sheet ID",
// "Data sheet ID" => "Data sheet ID",
// "Chart Type" => "Chart Type",
// "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic" => "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic",
// "Chart Width" => "Chart Width",
// "Width in pixels" => "Width in pixels",
// "Chart Height" => "Chart Height",
// "Height in pixels" => "Height in pixels",
// "Value series" => "Value series",
// "Required for pie charts" => "Required for pie charts",
// "Independant series" => "Independant series",
// "Required for types other than pie chart" => "Required for types other than pie chart",
// "Dependant series" => "Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors" => "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors",
// "List of colors to use" => "List of colors to use",
// "Styles" => "Styles",
// "List of styles to use" => "List of styles to use",
// "Labels" => "Labels",
// "Labels for the series or values in the legend" => "Labels for the series or values in the legend",
// "Chart as PDF" => "Chart as PDF",
// "Chart as PostScript" => "Chart as PostScript",
// "Caption" => "Caption",
// "Code snippet label" => "Code snippet label",
// "Word Wrap" => "Word Wrap",
// "0|1, Enable word wrapping on the code to avoid breaking the layout" => "0|1, Enable word wrapping on the code to avoid breaking the layout",
// "Colors" => "Colors",
// "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, .." => "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, ..",
// "Line numbers" => "Line numbers",
// "0|1, may not be used with colors" => "0|1, may not be used with colors",
// "Wiki syntax" => "Wiki syntax",
// "0|1, parse wiki syntax within the code snippet" => "0|1, parse wiki syntax within the code snippet",
// "Right to left" => "Right to left",
// "0|1, switch the text display from left to right to right to left" => "0|1, switch the text display from left to right to right to left",
// "Content is HTML" => "Content is HTML",
// "0|1, display the content as is instead of escaping HTML special chars" => "0|1, display the content as is instead of escaping HTML special chars",
// "Includes content from the dynamic content system" => "Includes content from the dynamic content system",
// "Content ID" => "Content ID",
// "Also known as Fortune cookies or Taglines" => "Also known as Fortune cookies or Taglines",
// "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~" => "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~",
// "Countdown" => "Countdown",
// "Displays a countdown from now until the specified date" => "Displays a countdown from now until the specified date",
// "Text to append to the countdown" => "Text to append to the countdown",
// "Target date. Multiple formats accepted" => "Target date. Multiple formats accepted",
// "Locate Time" => "Locate Time",
// "on|off" => "on|off",
// "DBReport" => "DBReport",
// "Run a database report" => "Run a database report",
// "report definition" => "report definition",
// "Full DSN" => "Full DSN",
// "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database" => "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database",
// "Wiki DSN name" => "Wiki DSN name",
// "The name of a DSN connection defined by the Wiki administrator" => "The name of a DSN connection defined by the Wiki administrator",
// "0|1, parse wiki syntax within the report" => "0|1, parse wiki syntax within the report",
// "Debug" => "Debug",
// "0|1, display the parsed report definition" => "0|1, display the parsed report definition",
// "Missing db or dsn parameter" => "Missing db or dsn parameter",
// "You do not have permission to use this DSN" => "You do not have permission to use this DSN",
// "No DSN connection string found" => "No DSN connection string found",
// "Div" => "Div",
// "div|span|pre|b|i|tt|p|blockquote" => "div|span|pre|b|i|tt|p|blockquote",
// "left|right|center|justify" => "left|right|center|justify",
// "left|right, for box with width lesser than 100%, make text wrap around the box" => "left|right, for box with width lesser than 100%, make text wrap around the box",
// "Apply custom CSS class to the div" => "Apply custom CSS class to the div",
// "HTML id" => "HTML id",
// "Sets the div\\'s id attribute, as defined by HTML" => "Sets the div\\'s id attribute, as defined by HTML",
// "Definition List" => "Definition List",
// "One entry per line. Each line is in \"Term: Definition\" format" => "One entry per line. Each line is in \"Term: Definition\" format",
// "Draw" => "Draw",
// "Displays drawings in the wiki page" => "Displays drawings in the wiki page",
// "Name of the drawing to display" => "Name of the drawing to display",
// "Name parameter missing" => "Name parameter missing",
// "Equation" => "Equation",
// "Renders an equation written in LaTeX syntax as an image" => "Renders an equation written in LaTeX syntax as an image",
// "equation" => "equation",
// "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large" => "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "Includes the list of events from a calendar in the page" => "Includes the list of events from a calendar in the page",
// "Calendar ID" => "Calendar ID",
// "Numeric" => "Numeric",
// "Maximum days" => "Maximum days",
// "Maximum Rows" => "Maximum Rows",
// "Datetime" => "Datetime",
// "0|1" => "0|1",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "Fade" => "Fade",
// "Displays a label. On click, the block of content will fade in and fade out" => "Displays a label. On click, the block of content will fade in and fade out",
// "Wiki syntax containing the text to display" => "Wiki syntax containing the text to display",
// "Label to display on first display" => "Label to display on first display",
// "Unspecified label" => "Unspecified label",
// "Fancy List" => "Fancy List",
// "One item per line starting with anything followed by \")\"" => "One item per line starting with anything followed by \")\"",
// "Use div" => "Use div",
// "Use div instead of ol" => "Use div instead of ol",
// "Class" => "Class",
// "CSS class of the fancylist" => "CSS class of the fancylist",
// "Creates a fancy looking list" => "Creates a fancy looking list",
// "num" => "num",
// "item text" => "item text",
// "one item per line" => "one item per line",
// "Fancy Table" => "Fancy Table",
// "One row per line, cells separated by ~|~" => "One row per line, cells separated by ~|~",
// "Heading row" => "Heading row",
// "Heading row of the table, same format as the body section" => "Heading row of the table, same format as the body section",
// "Heading CSS Class" => "Heading CSS Class",
// "CSS Class to apply on the heading row" => "CSS Class to apply on the heading row",
// "Displays a link to an attachment to a wiki page and can display an image attachment. " => "Displays a link to an attachment to a wiki page and can display an image attachment. ",
// "Gallery ID" => "Gallery ID",
// "name_asc" => "name_asc",
// "Shows ID" => "Shows ID",
// "Shows Icon" => "Shows Icon",
// "Shows Name" => "Shows Name",
// "Shows Filename" => "Shows Filename",
// "Shows Size" => "Shows Size",
// "Shows Description" => "Shows Description",
// "Shows Creation Date" => "Shows Creation Date",
// "Shows Hits" => "Shows Hits",
// "Shows Locked by" => "Shows Locked by",
// "Shows Modification Date" => "Shows Modification Date",
// "Shows Author" => "Shows Author",
// "Shows Creator" => "Shows Creator",
// "Shows Parent Gallery Name" => "Shows Parent Gallery Name",
// "Shows Number of Files" => "Shows Number of Files",
// "Shows the slideshow of a gallery" => "Shows the slideshow of a gallery",
// "List files in a file gallery (with a category) or in a category or a file gallery od this category" => "List files in a file gallery (with a category) or in a category or a file gallery od this category",
// "Displays a list of files from the File Gallery" => "Displays a list of files from the File Gallery",
// "Flash video" => "Flash video",
// "Movie URL" => "Movie URL",
// "Complete URL to the movie to include" => "Complete URL to the movie to include",
// "Default width: 425" => "Default width: 425",
// "Default height: 350" => "Default height: 350",
// "Quality" => "Quality",
// "Flash video quality. Default value: high" => "Flash video quality. Default value: high",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Footnote" => "Footnote",
// "Inserts a superscripted footnote number next to text and takes in footnote as parameter" => "Inserts a superscripted footnote number next to text and takes in footnote as parameter",
// "The footnote" => "The footnote",
// "Sameas" => "Sameas",
// "Tag to existing footnote" => "Tag to existing footnote",
// "CheckDuplicate" => "CheckDuplicate",
// "check for duplcate footnotes" => "check for duplcate footnotes",
// "Footnotearea" => "Footnotearea",
// "Inserts a section for collected footnotes within the wiki page" => "Inserts a section for collected footnotes within the wiki page",
// "Download box for a file on ftp server" => "Download box for a file on ftp server",
// "ftp" => "ftp",
// "file name" => "file name",
// "Ftp Server Name" => "Ftp Server Name",
// "Ftp User name" => "Ftp User name",
// "Ftp password" => "Ftp password",
// "Download button label" => "Download button label",
// "missing parameters" => "missing parameters",
// "Connection failed" => "Connection failed",
// "Incorrect param" => "Incorrect param",
// "Gauge" => "Gauge",
// "Displays a graphical gauge" => "Displays a graphical gauge",
// "current value (REQUIRED)" => "current value (REQUIRED)",
// "Maximum Value" => "Maximum Value",
// "Maximum possible value. Default: 100" => "Maximum possible value. Default: 100",
// "Label displayed on the left side of the gauge" => "Label displayed on the left side of the gauge",
// "Color" => "Color",
// "Background Color" => "Background Color",
// "Bar width in pixels" => "Bar width in pixels",
// "Label Width" => "Label Width",
// "Width in pixels allocated to the label" => "Width in pixels allocated to the label",
// "Display Percentage" => "Display Percentage",
// "true|false, if true then a percentage of the maximum is displayed" => "true|false, if true then a percentage of the maximum is displayed",
// "Display Value" => "Display Value",
// "true|false, if the numeric value is displayed" => "true|false, if the numeric value is displayed",
// "Bar height in pixels" => "Bar height in pixels",
// "Google Analytics" => "Google Analytics",
// "Add the tracking code for Google Analytics" => "Add the tracking code for Google Analytics",
// "Account number" => "Account number",
// "The account number for the site" => "The account number for the site",
// "Missing parameter" => "Missing parameter",
// "googledoc" => "googledoc",
// "Leave this empty" => "Leave this empty",
// "Type of Google document" => "Type of Google document",
// "key" => "key",
// "Google doc key - for example pXsHENf1bGGY92X1iEeJJI" => "Google doc key - for example pXsHENf1bGGY92X1iEeJJI",
// "Name of iframe" => "Name of iframe",
// "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large" => "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large",
// "Pixels or %" => "Pixels or %",
// "Margin Height" => "Margin Height",
// "Pixels" => "Pixels",
// "Margin Width" => "Margin Width",
// "Scrolling" => "Scrolling",
// "editLink" => "editLink",
// "Required parameter \"type\" missing" => "Required parameter \"type\" missing",
// "Required parameter \"key\" missing" => "Required parameter \"key\" missing",
// "Displays a Google document" => "Displays a Google document",
// "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition" => "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition",
// "Allowed Groups" => "Allowed Groups",
// "Pipe separated list of groups allowed to view the block. ex: Admins|Developers" => "Pipe separated list of groups allowed to view the block. ex: Admins|Developers",
// "Denied Groups" => "Denied Groups",
// "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers" => "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "HTML" => "HTML",
// "Include literal HTML in a Wiki page" => "Include literal HTML in a Wiki page",
// "0|1, parse wiki syntax within the html code" => "0|1, parse wiki syntax within the html code",
// "Include literal HTML" => "Include literal HTML",
// "Iframe" => "Iframe",
// "Frame title" => "Frame title",
// "iframe" => "iframe",
// "Displays an iframe" => "Displays an iframe",
// " (experimental - possible successor to img in 4.0)" => " (experimental - possible successor to img in 4.0)",
// "File ID" => "File ID",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Image Source" => "Image Source",
// "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required" => "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required",
// "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded" => "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded",
// "Alias: lnk. Location the image should point to" => "Alias: lnk. Location the image should point to",
// "Link Relation" => "Link Relation",
// "\"rel\" attribute to add to the link" => "\"rel\" attribute to add to the link",
// "Link title" => "Link title",
// "Title text" => "Title text",
// "Image alt text" => "Image alt text",
// "Alternate text to display if impossible to load the image" => "Alternate text to display if impossible to load the image",
// "Alias:imalign. Image alignment in the page. (left, right)" => "Alias:imalign. Image alignment in the page. (left, right)",
// "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)" => "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)",
// "Image description to display on the page" => "Image description to display on the page",
// "Image Map" => "Image Map",
// "Name of the image map to use for the image" => "Name of the image map to use for the image",
// "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)" => "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)",
// "CSS Style" => "CSS Style",
// "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)" => "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)",
// "Border options" => "Border options",
// "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options" => "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options",
// "Description options" => "Description options",
// "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)" => "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)",
// "Default configuration" => "Default configuration",
// "Default configuration definitions. (Usually used in configuration rather than on individual images.)" => "Default configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Mandatory configuration" => "Mandatory configuration",
// "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)" => "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content" => "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content",
// "Display an image" => "Display an image",
// "Displays an image" => "Displays an image",
// "Full URL to the image to display" => "Full URL to the image to display",
// "Alternate Text" => "Alternate Text",
// "Height of the image to display" => "Height of the image to display",
// "Width of the image to display" => "Width of the image to display",
// "Link Title" => "Link Title",
// "Image alignment in the page. (left, right, center) Uses HTML IMG tag" => "Image alignment in the page. (left, right, center) Uses HTML IMG tag",
// "Float Alignment" => "Float Alignment",
// "Image alignment in the flow of the document. (left, right, none) Uses CSS float property" => "Image alignment in the flow of the document. (left, right, none) Uses CSS float property",
// "Style to apply to the image" => "Style to apply to the image",
// "Include a page\\'s content" => "Include a page\\'s content",
// "Page Name" => "Page Name",
// "Wiki page name to include" => "Wiki page name to include",
// "When only a portion of the page should be included, specify the marker from which inclusion should start" => "When only a portion of the page should be included, specify the marker from which inclusion should start",
// "When only a portion of the page should be included, specify the marker at which inclusion should end" => "When only a portion of the page should be included, specify the marker at which inclusion should end",
// "Jabber" => "Jabber",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Applet height in pixels" => "Applet height in pixels",
// "'),\n\t\t\t\t'description' => tra('Applet width in pixels" => "'),\n\t\t\t\t'description' => tra('Applet width in pixels",
// "'),\n\t\t\t\t'description' => tra('jabber.org" => "'),\n\t\t\t\t'description' => tra('jabber.org",
// "Default Color" => "Default Color",
// "255,255,255" => "255,255,255",
// "JQuery" => "JQuery",
// "Insert JQuery javascript code. Requires feature_jquery" => "Insert JQuery javascript code. Requires feature_jquery",
// " (experimental - may change in future versions)" => " (experimental - may change in future versions)",
// "JQuery Code" => "JQuery Code",
// "NotOnReady" => "NotOnReady",
// "NoJQuery" => "NoJQuery",
// "Optional markup for when feature_jquery is off" => "Optional markup for when feature_jquery is off",
// "Insert JQuery javascript code" => "Insert JQuery javascript code",
// "jquery code e.g. \$jq(\"img\\" => "jquery code e.g. \$jq(\"img\\",
// "Do not execute on document ready (execute inline)" => "Do not execute on document ready (execute inline)",
// "Javascript" => "Javascript",
// "Insert a javascript file or/and some javascript code" => "Insert a javascript file or/and some javascript code",
// "javascript code" => "javascript code",
// "Javascript filename" => "Javascript filename",
// "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Not Language" => "Not Language",
// "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Page name to display information of. Default value is current page" => "Page name to display information of. Default value is current page",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "Result Offset" => "Result Offset",
// "Result number at which the listing should start" => "Result number at which the listing should start",
// "Result Count" => "Result Count",
// "Amount of results displayed in the list" => "Amount of results displayed in the list",
// "Initial" => "Initial",
// "txt" => "txt",
// "Show Name Only" => "Show Name Only",
// "Structure Head" => "Structure Head",
// "Show Page Alias" => "Show Page Alias",
// "Two letter language code to filter pages listed" => "Two letter language code to filter pages listed",
// "Orphan Language" => "Orphan Language",
// "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed" => "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed",
// "Load Translations" => "Load Translations",
// "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter" => "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter",
// "Exact Match" => "Exact Match",
// "Related to Find" => "Related to Find",
// "Only Orphan Pages" => "Only Orphan Pages",
// "For List Pages" => "For List Pages",
// "List Directory" => "List Directory",
// "Full path to the server-local directory" => "Full path to the server-local directory",
// "URL Prefix" => "URL Prefix",
// ".ext" => ".ext",
// "Limit" => "Limit",
// "Maximum amount of files to display" => "Maximum amount of files to display",
// "Displays a map" => "Displays a map",
// "Map File" => "Map File",
// "Extents" => "Extents",
// "Inline Flash mp3 and flv Player" => "Inline Flash mp3 and flv Player",
// "Mediaplayer" => "Mediaplayer",
// "MP3 URL" => "MP3 URL",
// "Complete URL to the mp3 to include" => "Complete URL to the mp3 to include",
// "FLV URL" => "FLV URL",
// "Complete URL to the flv to include" => "Complete URL to the flv to include",
// "One of" => "One of",
// "Mini Quiz" => "Mini Quiz",
// "Displays a miniquiz" => "Displays a miniquiz",
// "Instructions::Feedback" => "Instructions::Feedback",
// "Tracker ID" => "Tracker ID",
// "Insert Module" => "Insert Module",
// "Module name as known in Tikiwiki" => "Module name as known in Tikiwiki",
// "Decoration" => "Decoration",
// "Flip" => "Flip",
// "Max" => "Max",
// "np" => "np",
// "notitle" => "notitle",
// "Displays a module inlined in page. More parameters can be added, not supported by UI" => "Displays a module inlined in page. More parameters can be added, not supported by UI",
// "Monospace" => "Monospace",
// "Font name as known in browsers" => "Font name as known in browsers",
// "Mouse Over" => "Mouse Over",
// "Create a mouseover feature on some text" => "Create a mouseover feature on some text",
// "Mouseover text if param label exists. Page text if text param exists" => "Mouseover text if param label exists. Page text if text param exists",
// "Text displayed on the page. The body is the mouseover content" => "Text displayed on the page. The body is the mouseover content",
// "Destination link when moused-over text is clicked. Use http:// for external links" => "Destination link when moused-over text is clicked. Use http:// for external links",
// "DEPRECATED" => "DEPRECATED",
// "Text displayed on the mouseover. The body contains the text of the page" => "Text displayed on the mouseover. The body contains the text of the page",
// "Mouse over box width. Default: 400px" => "Mouse over box width. Default: 400px",
// "Mouse over box height. Default: 200px" => "Mouse over box height. Default: 200px",
// "Offset X" => "Offset X",
// "Shifts the overlay to the right by the specified amount of pixels in relation to the cursor. Default: 5px" => "Shifts the overlay to the right by the specified amount of pixels in relation to the cursor. Default: 5px",
// "Offset Y" => "Offset Y",
// "Shifts the overlay to the bottom by the specified amount of pixels in relation to the cursor. Default: 0px" => "Shifts the overlay to the bottom by the specified amount of pixels in relation to the cursor. Default: 0px",
// "Parse Body" => "Parse Body",
// "y|n, parse the body of the plugin as wiki content. (Default to y)" => "y|n, parse the body of the plugin as wiki content. (Default to y)",
// "Color of the inside popup" => "Color of the inside popup",
// "Default: #F5F5F5" => "Default: #F5F5F5",
// "Text popup color" => "Text popup color",
// "#FFFFFF" => "#FFFFFF",
// "Padding" => "Padding",
// "No label specified" => "No label specified",
// "MWTable" => "MWTable",
// "fancy" => "fancy",
// "true|false" => "true|false",
// "wiki_classes" => "wiki_classes",
// "Displays the data using (sort of) MediaWiki syntax" => "Displays the data using (sort of) MediaWiki syntax",
// "Displays a table using MediaWiki syntax" => "Displays a table using MediaWiki syntax",
// "MySpace" => "MySpace",
// "MySpace Page" => "MySpace Page",
// "Displays a SWF myspace mp3 playlist on the wiki page" => "Displays a SWF myspace mp3 playlist on the wiki page",
// "Object Hits" => "Object Hits",
// "Object ID" => "Object ID",
// "Object Type" => "Object Type",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "Search for images uploaded by users" => "Search for images uploaded by users",
// " (deprecated - scheduled to be removed or changed significantly)" => " (deprecated - scheduled to be removed or changed significantly)",
// "Filename or full path to file" => "Filename or full path to file",
// "Plugin Manager" => "Plugin Manager",
// "Multiple values separated with | can be used" => "Multiple values separated with | can be used",
// "Poll ID" => "Poll ID",
// "Profile Installer" => "Profile Installer",
// "Adds controls required to install a profile" => "Adds controls required to install a profile",
// "Domain" => "Domain",
// "Profile repository domain. Default value is profiles.tikiwiki.org" => "Profile repository domain. Default value is profiles.tikiwiki.org",
// "Profile Name" => "Profile Name",
// "Name of the profile" => "Name of the profile",
// "Profile plugin only available to administrators" => "Profile plugin only available to administrators",
// "Profile %0/%1 not found" => "Profile %0/%1 not found",
// "Proposal" => "Proposal",
// "Provides a widget for users to vote on a proposal and view the current decision" => "Provides a widget for users to vote on a proposal and view the current decision",
// "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username" => "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username",
// "Accept proposal" => "Accept proposal",
// "Still undecided" => "Still undecided",
// "Reject proposal" => "Reject proposal",
// "Displays a proposal acceptance widget" => "Displays a proposal acceptance widget",
// "Short description of the proposal to vote on. Will be displayed above the result table" => "Short description of the proposal to vote on. Will be displayed above the result table",
// "Quote" => "Quote",
// "Quoted text" => "Quoted text",
// "Reply to" => "Reply to",
// "Name of the quoted person" => "Name of the quoted person",
// "Random Dynamic Content" => "Random Dynamic Content",
// "Includes random content from the dynamic content system" => "Includes random content from the dynamic content system",
// "Redirect" => "Redirect",
// "Redirect the user to a wiki page or generic URL" => "Redirect the user to a wiki page or generic URL",
// "Wiki page name to redirect to" => "Wiki page name to redirect to",
// "Complete URL, internal or external" => "Complete URL, internal or external",
// "Redirects you to another wiki page" => "Redirects you to another wiki page",
// "Regular Expression" => "Regular Expression",
// "Takes regex expressions and parses the content between REGEX tags and replaces the text" => "Takes regex expressions and parses the content between REGEX tags and replaces the text",
// "Page name containing the regular expression" => "Page name containing the regular expression",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "Remarks Box" => "Remarks Box",
// "Label displayed above the remark" => "Label displayed above the remark",
// "Highlight" => "Highlight",
// "Icon ID" => "Icon ID",
// "RSS Feed" => "RSS Feed",
// "Inserts an RSS feed output" => "Inserts an RSS feed output",
// "IDs" => "IDs",
// "List of feed IDs separated by colons. ex: feedId:feedId2" => "List of feed IDs separated by colons. ex: feedId:feedId2",
// "Amount of results displayed" => "Amount of results displayed",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect" => "RSS Id incorrect",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "SourceForge" => "SourceForge",
// "aid?" => "aid?",
// "adit?" => "adit?",
// "groupid?" => "groupid?",
// "Insert a ShareThis button from www.sharethis.com" => "Insert a ShareThis button from www.sharethis.com",
// "sharethis" => "sharethis",
// "Display a social networking tool" => "Display a social networking tool",
// "Send services" => "Send services",
// "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services" => "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services",
// "First post services shown" => "First post services shown",
// "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget" => "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget",
// "Rotate image" => "Rotate image",
// "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping" => "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping",
// "Button text" => "Button text",
// "Custom link text for the button" => "Custom link text for the button",
// "Header title" => "Header title",
// "Optional header title text for the widget" => "Optional header title text for the widget",
// "Header background" => "Header background",
// "HTML color code (not color name) for the background color for the header if an optional header title is used" => "HTML color code (not color name) for the background color for the header if an optional header title is used",
// "Header text color" => "Header text color",
// "HTML color code (not color name) for the header text if an optional header title is used" => "HTML color code (not color name) for the header text if an optional header title is used",
// "Link text color for services" => "Link text color for services",
// "HTML color code (not color name) for the link text for all send and post services shown in the widget" => "HTML color code (not color name) for the link text for all send and post services shown in the widget",
// "A value of true will cause the widget to show in a pop-up window" => "A value of true will cause the widget to show in a pop-up window",
// "Embedded elements" => "Embedded elements",
// "A value of true will allow embedded elements (like flash) to be seen while iframe is loading" => "A value of true will allow embedded elements (like flash) to be seen while iframe is loading",
// "Sheet" => "Sheet",
// "Displays the content of a spreadsheet in the page" => "Displays the content of a spreadsheet in the page",
// "Internal ID of the TikiSheet" => "Internal ID of the TikiSheet",
// "New sheet in page: " => "New sheet in page: ",
// "Incomplete call to plugin: No target sheet" => "Incomplete call to plugin: No target sheet",
// "Create new sheet" => "Create new sheet",
// "Show Pages" => "Show Pages",
// "Search criteria" => "Search criteria",
// "Maximum amount of results displayed" => "Maximum amount of results displayed",
// "name|desc" => "name|desc",
// "Skype" => "Skype",
// "Clickable Skype link" => "Clickable Skype link",
// "Name or number to call or chat with" => "Name or number to call or chat with",
// "Snarf" => "Snarf",
// "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified" => "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified",
// "Full URL to the page to include" => "Full URL to the page to include",
// "PCRE compliant regular expression" => "PCRE compliant regular expression",
// "Regular Expression Part" => "Regular Expression Part",
// "ex: \$1" => "ex: \$1",
// "Data to sort, one entry per line" => "Data to sort, one entry per line",
// "asc|desc|shuffle" => "asc|desc|shuffle",
// "Join Columns" => "Join Columns",
// "Generate the colspan attribute if columns are missing" => "Generate the colspan attribute if columns are missing",
// "Fixed Size" => "Fixed Size",
// "Generate the width attribute on the columns" => "Generate the width attribute on the columns",
// "Column Size" => "Column Size",
// "Editable" => "Editable",
// "Display edit icon for each section" => "Display edit icon for each section",
// "Custom class" => "Custom class",
// "add a class to customize the design" => "add a class to customize the design",
// "SQL" => "SQL",
// "DNS Name" => "DNS Name",
// "ADODB DNS" => "ADODB DNS",
// "Subscript" => "Subscript",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Subscribe Group" => "Subscribe Group",
// "Group Name" => "Group Name",
// "As known in Tikiwiki" => "As known in Tikiwiki",
// "Subscribe Text" => "Subscribe Text",
// "Subscribe text, containing %s as the placeholder for the group name" => "Subscribe text, containing %s as the placeholder for the group name",
// "Unsubscribe Text" => "Unsubscribe Text",
// "Unsubscribe text, containing %s as the placeholder for the group name" => "Unsubscribe text, containing %s as the placeholder for the group name",
// "Subscribe Action" => "Subscribe Action",
// "Subscribe button label, containing %s as the placeholder for the group name" => "Subscribe button label, containing %s as the placeholder for the group name",
// "Unsubscribe Action" => "Unsubscribe Action",
// "Unsubscribe button label, containing %s as the placeholder for the group name" => "Unsubscribe button label, containing %s as the placeholder for the group name",
// "Subscribe Groups" => "Subscribe Groups",
// "Colon separated list of groups" => "Colon separated list of groups",
// "Superscript" => "Superscript",
// "Displays text in superscript (exponent)" => "Displays text in superscript (exponent)",
// "Displays text in superscript" => "Displays text in superscript",
// "Wiki Page to redirect the user after his vote" => "Wiki Page to redirect the user after his vote",
// "Displays a survey" => "Displays a survey",
// "Tag" => "Tag",
// "Displays the text between an html tag" => "Displays the text between an html tag",
// "Tag Name" => "Tag Name",
// "Any valid HTML tag, span by default" => "Any valid HTML tag, span by default",
// "Equivalent of the style attribute on the HTML tag" => "Equivalent of the style attribute on the HTML tag",
// "Displays text between an html tag" => "Displays text between an html tag",
// "File ID from the file gallery" => "File ID from the file gallery",
// "Image ID from the image gallery" => "Image ID from the image gallery",
// "URL to the image" => "URL to the image",
// "Maximum Size" => "Maximum Size",
// "Maximum width or height for the image" => "Maximum width or height for the image",
// "Floating" => "Floating",
// "Link target of the image" => "Link target of the image",
// "File is not an image" => "File is not an image",
// "Server does not support image manipulation" => "Server does not support image manipulation",
// "No image specified" => "No image specified",
// "Title Search" => "Title Search",
// "Search wiki page titles" => "Search wiki page titles",
// "Search Criteria" => "Search Criteria",
// "Portion of a page name" => "Portion of a page name",
// "hits|user" => "hits|user",
// "Exclude" => "Exclude",
// "Pipe separated list of page names to exclude from results" => "Pipe separated list of page names to exclude from results",
// "Table of Contents (Structure)" => "Table of Contents (Structure)",
// "Displays the table of contents for the current structure\\'s subtree as part of the page content" => "Displays the table of contents for the current structure\\'s subtree as part of the page content",
// "Maximum Depth" => "Maximum Depth",
// "Maximum amount of levels to display. On very large structures, this should be limited" => "Maximum amount of levels to display. On very large structures, this should be limited",
// "By default, structure for the current page will be displayed. Alternate structure may be provided" => "By default, structure for the current page will be displayed. Alternate structure may be provided",
// "asc|desc" => "asc|desc",
// "Show Description" => "Show Description",
// "0|1, show the page description instead of the page name" => "0|1, show the page description instead of the page name",
// "Show Numbering" => "Show Numbering",
// "0|1, display the section numbers or not" => "0|1, display the section numbers or not",
// "plain|fancy" => "plain|fancy",
// "Top Friends" => "Top Friends",
// "List top scoring users" => "List top scoring users",
// "Maximum result count" => "Maximum result count",
// "Translate a string using Tikiwiki translation table" => "Translate a string using Tikiwiki translation table",
// "string" => "string",
// "Translate a string" => "Translate a string",
// "Confirmation message after posting form" => "Confirmation message after posting form",
// "Colon-separated list of field IDs to be displayed. Example: 2:4:5" => "Colon-separated list of field IDs to be displayed. Example: 2:4:5",
// "Label on the submit button" => "Label on the submit button",
// "Show Title" => "Show Title",
// "Show Mandatory" => "Show Mandatory",
// "Embedded" => "Embedded",
// "Url used for the field links" => "Url used for the field links",
// "Values" => "Values",
// "Colon-separated list of values" => "Colon-separated list of values",
// "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or " => "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or ",
// "user|page" => "user|page",
// "itemId" => "itemId",
// "itemId if you want to edit an item" => "itemId if you want to edit an item",
// "Template File" => "Template File",
// "Name of the template used to display the tracker items" => "Name of the template used to display the tracker items",
// "Name of the wiki page containing the template to display the tracker items" => "Name of the wiki page containing the template to display the tracker items",
// "New Status" => "New Status",
// "Default status applied to newly created items" => "Default status applied to newly created items",
// "Width of first column " => "Width of first column ",
// "Specify the width in pixels or percentage of the first column in the tracker form" => "Specify the width in pixels or percentage of the first column in the tracker form",
// "Incorrect fieldId" => "Incorrect fieldId",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Following fields are incorrect" => "Following fields are incorrect",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Filters" => "Filters",
// "Display List" => "Display List",
// "Line" => "Line",
// "Tracker Filter" => "Tracker Filter",
// "notice" => "notice",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Filters the items of a tracker, fields are indicated with numeric ids" => "Filters the items of a tracker, fields are indicated with numeric ids",
// "Wiki text" => "Wiki text",
// "Tracker Item Field" => "Tracker Item Field",
// "Wiki text containing an {ELSE} marker" => "Wiki text containing an {ELSE} marker",
// "Item ID" => "Item ID",
// "Field ID" => "Field ID",
// "Colon separated list of field IDs" => "Colon separated list of field IDs",
// "o|p|c|op|oc|pc|opc" => "o|p|c|op|oc|pc|opc",
// "Test" => "Test",
// "Value to compare against" => "Value to compare against",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)" => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)",
// "Tracker List" => "Tracker List",
// "Notice" => "Notice",
// "Popup" => "Popup",
// "Colon-separated list of fields to display on click. Example: 6:7" => "Colon-separated list of fields to display on click. Example: 6:7",
// "Sticky Popup" => "Sticky Popup",
// "Show Links" => "Show Links",
// "shownbitems" => "shownbitems",
// "Show Initials" => "Show Initials",
// "Show Status" => "Show Status",
// "Show Creation Date" => "Show Creation Date",
// "Show Last Modification" => "Show Last Modification",
// "Show Field Name" => "Show Field Name",
// "Status Filter" => "Status Filter",
// "Which item status to list. o = open, p = pending, c = closed" => "Which item status to list. o = open, p = pending, c = closed",
// "Sort Mode" => "Sort Mode",
// "Filter Field" => "Filter Field",
// "Colon separated list of fields to allow filtering on" => "Colon separated list of fields to allow filtering on",
// "Filter Value" => "Filter Value",
// "Exact Value" => "Exact Value",
// "Checkbox" => "Checkbox",
// "goIfOne" => "goIfOne",
// "More" => "More",
// "More URL" => "More URL",
// "Select automatically the item of the current user or the page" => "Select automatically the item of the current user or the page",
// "View User" => "View User",
// "Item ID separated with " => "Item ID separated with ",
// "List of items Ids" => "List of items Ids",
// "link url" => "link url",
// "Left Deliminator" => "Left Deliminator",
// "Right Deliminator" => "Right Deliminator",
// "If y, value will be truncated" => "If y, value will be truncated",
// "Export Button" => "Export Button",
// "Compute" => "Compute",
// "Sum or average all the values of a field  and displays it at the bottom of the table" => "Sum or average all the values of a field  and displays it at the bottom of the table",
// "fieldId" => "fieldId",
// "incorrect filterfield" => "incorrect filterfield",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields" => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields",
// "Tracker Prefill" => "Tracker Prefill",
// "Tracker page name" => "Tracker page name",
// "Button label" => "Button label",
// "Field 1" => "Field 1",
// "Value 1" => "Value 1",
// "Content of the field" => "Content of the field",
// "Field 2" => "Field 2",
// "Value 2" => "Value 2",
// "Field 3" => "Field 3",
// "Value 3" => "Value 3",
// "Field 4" => "Field 4",
// "Value 4" => "Value 4",
// "Field 5" => "Field 5",
// "Value 5" => "Value 5",
// "Tracker Stats" => "Tracker Stats",
// "Show Percentage" => "Show Percentage",
// "Show Bar" => "Show Bar",
// "Show link to tiki-view_tracker" => "Show link to tiki-view_tracker",
// "Displays some stat of a tracker content, fields are indicated with numeric ids" => "Displays some stat of a tracker content, fields are indicated with numeric ids",
// "incorrect fieldId" => "incorrect fieldId",
// "Tracker Timeline" => "Tracker Timeline",
// "Timeline view of a tracker, can be used to display event schedules or gantt charts" => "Timeline view of a tracker, can be used to display event schedules or gantt charts",
// "Title Field" => "Title Field",
// "Tracker Field ID containing the item title" => "Tracker Field ID containing the item title",
// "Summary Field" => "Summary Field",
// "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused" => "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused",
// "Start Date" => "Start Date",
// "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field",
// "End Date" => "End Date",
// "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field",
// "Element Group" => "Element Group",
// "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row" => "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row",
// "Lower Bound" => "Lower Bound",
// "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Upper Bound" => "Upper Bound",
// "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Primary Scale Unit" => "Primary Scale Unit",
// "hour, day, week, month or year (default to hour)" => "hour, day, week, month or year (default to hour)",
// "Secondary Scale Unit" => "Secondary Scale Unit",
// "hour, day, week, month, year or empty (default to empty)" => "hour, day, week, month, year or empty (default to empty)",
// "Link Group Name" => "Link Group Name",
// "Convert the group name to a link. (y|n)" => "Convert the group name to a link. (y|n)",
// "Page Link Field" => "Page Link Field",
// "Tracker Field ID containing the page name for item details" => "Tracker Field ID containing the page name for item details",
// "Missing parameter: %0" => "Missing parameter: %0",
// "Start date after end date" => "Start date after end date",
// "Translated" => "Translated",
// "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)" => "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)",
// "Two letter language code of the language, ex: fr" => "Two letter language code of the language, ex: fr",
// "Country name, ex: France" => "Country name, ex: France",
// "User Count" => "User Count",
// "Group name" => "Group name",
// "Displays a list of registered users" => "Displays a list of registered users",
// "Login Filter" => "Login Filter",
// "String to use between elements of the list" => "String to use between elements of the list",
// "Maximum" => "Maximum",
// "Result limit" => "Result limit",
// "Layout" => "Layout",
// "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default" => "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default",
// "Navigation" => "Navigation",
// "Displays a navigation box that allows users to select a specific version to display" => "Displays a navigation box that allows users to select a specific version to display",
// "Display the current version name as the title. Note: Do not work when nav=>y" => "Display the current version name as the title. Note: Do not work when nav=>y",
// "Default" => "Default",
// "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'" => "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Show Stats" => "Show Stats",
// "Show Stats After" => "Show Stats After",
// "Show Creator" => "Show Creator",
// "Wanted Pages" => "Wanted Pages",
// "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)" => "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)",
// "Ignore" => "Ignore",
// "Split By" => "Split By",
// "Skip Extension" => "Skip Extension",
// "Collect" => "Collect",
// "Level" => "Level",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored" => "A wildcard pattern of originating pages to be ignored",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated" => "The character, by which ignored patterns are separated",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list" => "Whether to include external wikis in the list",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column" => "Collect either originating or wanted pages in a cell and display them in the second column",
// "Switch-on debug output with details about the items" => "Switch-on debug output with details about the items",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex",
// "A custom filter for wanted pages to be listed (only used when level=>custom)" => "A custom filter for wanted pages to be listed (only used when level=>custom)",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "Lists ''wanted'' wiki pages" => "Lists ''wanted'' wiki pages",
// "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)" => "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)",
// "The character, by which ignored patterns are separated. possible values: characters" => "The character, by which ignored patterns are separated. possible values: characters",
// "Whether to include external wikis in the list. possible values" => "Whether to include external wikis in the list. possible values",
// "Collect either originating or wanted pages in a cell and display them in the second column. possible values" => "Collect either originating or wanted pages in a cell and display them in the second column. possible values",
// "Switch-on debug output with details about the items. possible values" => "Switch-on debug output with details about the items. possible values",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output" => "End of debug output",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Web Service" => "Web Service",
// "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface" => "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface",
// "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter" => "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter",
// "Complete service URL" => "Complete service URL",
// "Service Name" => "Service Name",
// "Registered service name" => "Registered service name",
// "Template Name" => "Template Name",
// "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided" => "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided",
// "Body as Parameter" => "Body as Parameter",
// "Name of the argument to send the body as for services with complex input. Named service required for this to be useful" => "Name of the argument to send the body as for services with complex input. Named service required for this to be useful",
// "Unknown Template" => "Unknown Template",
// "Unknown Service" => "Unknown Service",
// "Missing parameters" => "Missing parameters",
// "Youtube" => "Youtube",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "URL to the Youtube video" => "URL to the Youtube video",
// "quality" => "quality",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Removed version \$version" => "Removed version \$version",
// "rollback version " => "rollback version ",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Plugin " => "Plugin ",
// "Semantic token already exists" => "Semantic token already exists",
// "Invalid semantic token name" => "Invalid semantic token name",
// "Semantic token not found" => "Semantic token not found",
// "Page locked" => "Page locked",
// "Page unlocked" => "Page unlocked",
// "Removed last version" => "Removed last version",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "list topics with links to the articles" => "list topics with links to the articles",
// "Article Topics" => "Article Topics",
// "Categorize %s in %s" => "Categorize %s in %s",
// "List by month" => "List by month",
// "Please wait.." => "Please wait..",
// "Since your last visit.." => "Since your last visit..",
// "new posts" => "new posts",
// "new tracker items" => "new tracker items",
// "updated tracker items" => "updated tracker items",
// "Invalid server key" => "Invalid server key",
// "Cookie not found" => "Cookie not found",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can browse the calendar" => "Can browse the calendar",
// "Can view events details" => "Can view events details",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Can admin categories" => "Can admin categories",
// "Can edit items in categories" => "Can edit items in categories",
// "Can view categories" => "Can view categories",
// "Can view categorized items" => "Can view categorized items",
// "Can search on objects of this category" => "Can search on objects of this category",
// "Can admin charts" => "Can admin charts",
// "Autovalidate suggestions" => "Autovalidate suggestions",
// "Can suggest items" => "Can suggest items",
// "Can view charts" => "Can view charts",
// "Can vote" => "Can vote",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Can use the chat system" => "Can use the chat system",
// "Can admin the cms" => "Can admin the cms",
// "Can approve submissions" => "Can approve submissions",
// "Can admin article topics" => "Can admin article topics",
// "Can admin article types" => "Can admin article types",
// "Can read article headings" => "Can read article headings",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Can edit articles" => "Can edit articles",
// "Can edit submissions" => "Can edit submissions",
// "Can read articles" => "Can read articles",
// "Can remove articles" => "Can remove articles",
// "Can remove submissions" => "Can remove submissions",
// "Can submit articles" => "Can submit articles",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can admin contributions" => "Can admin contributions",
// "Can admin the directory" => "Can admin the directory",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Submited links are valid" => "Submited links are valid",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can validate submited links" => "Can validate submited links",
// "Can use the directory" => "Can use the directory",
// "Can admin drawings" => "Can admin drawings",
// "Can edit drawings" => "Can edit drawings",
// "Can admin faqs" => "Can admin faqs",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can view faqs" => "Can view faqs",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Can admin users" => "Can admin users",
// "Can access site when closed" => "Can access site when closed",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Can ban users or ips" => "Can ban users or ips",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can edit object permissions" => "Can edit object permissions",
// "Can admin rss modules" => "Can admin rss modules",
// "Can clean cache" => "Can clean cache",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can admin cookies" => "Can admin cookies",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit site templates" => "Can edit site templates",
// "Can search" => "Can search",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view referer stats" => "Can view referer stats",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can admin blogs" => "Can admin blogs",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can post to a blog" => "Can post to a blog",
// "Can create a blog" => "Can create a blog",
// "Can read blogs" => "Can read blogs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can create file galleries" => "Can create file galleries",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can list file galleries" => "Can list file galleries",
// "Can upload files" => "Can upload files",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view file galleries" => "Can view file galleries",
// "Can admin forums" => "Can admin forums",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can post in forums" => "Can post in forums",
// "Can start threads in forums" => "Can start threads in forums",
// "Can read forums" => "Can read forums",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can create image galleries" => "Can create image galleries",
// "Can tag objects" => "Can tag objects",
// "Can list image galleries" => "Can list image galleries",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload images" => "Can upload images",
// "Can browse freetags" => "Can browse freetags",
// "Can view image galleries" => "Can view image galleries",
// "Can admin games" => "Can admin games",
// "Can play games" => "Can play games",
// "Can admin newsletters" => "Can admin newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can send newsletters" => "Can send newsletters",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can admin polls" => "Can admin polls",
// "Can view poll results" => "Can view poll results",
// "Can vote polls" => "Can vote polls",
// "Can view poll voters" => "Can view poll voters",
// "Can admin quicktags" => "Can admin quicktags",
// "Can admin quizzes" => "Can admin quizzes",
// "Can take quizzes" => "Can take quizzes",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view user quiz results" => "Can view user quiz results",
// "Can admin sheet" => "Can admin sheet",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can view shoutbox" => "Can view shoutbox",
// "Can admin surveys" => "Can admin surveys",
// "Can take surveys" => "Can take surveys",
// "Can view survey stats" => "Can view survey stats",
// "Can admin trackers" => "Can admin trackers",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can view tracker items comments" => "Can view tracker items comments",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can list trackers" => "Can list trackers",
// "Can change tracker items" => "Can change tracker items",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can watch tracker" => "Can watch tracker",
// "Can export tracker items" => "Can export tracker items",
// "Can admin the wiki" => "Can admin the wiki",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can edit pages" => "Can edit pages",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can create and edit structures" => "Can create and edit structures",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can lock pages" => "Can lock pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can remove" => "Can remove",
// "Can rename pages" => "Can rename pages",
// "Can rollback pages" => "Can rollback pages",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can view page/pages" => "Can view page/pages",
// "Can watch structure" => "Can watch structure",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can view similar wiki pages" => "Can view similar wiki pages",
// "Can admin workflow processes" => "Can admin workflow processes",
// "Can abort a process instance" => "Can abort a process instance",
// "Can declare an instance as exception" => "Can declare an instance as exception",
// "Can send instances after completion" => "Can send instances after completion",
// "Can execute workflow activities" => "Can execute workflow activities",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can configure modules" => "Can configure modules",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the newsreader" => "Can use the newsreader",
// "Can use the notepad" => "Can use the notepad",
// "Can admin public tasks" => "Can admin public tasks",
// "Can use tasks" => "Can use tasks",
// "Can receive tasks from other users" => "Can receive tasks from other users",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can upload personal files" => "Can upload personal files",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can use the messaging system" => "Can use the messaging system",
// "Can admin comments" => "Can admin comments",
// "Can edit all comments" => "Can edit all comments",
// "Can post new comments" => "Can post new comments",
// "Can read comments" => "Can read comments",
// "Can delete comments" => "Can delete comments",
// "Can vote comments" => "Can vote comments",
// "Can admin content templates" => "Can admin content templates",
// "Can edit content templates" => "Can edit content templates",
// "Can use content templates" => "Can use content templates",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can view HTML pages" => "Can view HTML pages",
// "Can list registered users" => "Can list registered users",
// "Admin live support system" => "Admin live support system",
// "Can use live support system" => "Can use live support system",
// "Can create new mapfile" => "Can create new mapfile",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can use webmail" => "Can use webmail",
// "Can use group webmail" => "Can use group webmail",
// "Can administrate group webmail accounts" => "Can administrate group webmail accounts",
// "Can use personal webmail accounts" => "Can use personal webmail accounts",
// "Can administrate personal webmail accounts" => "Can administrate personal webmail accounts",
// "Can view unapproved plugin details" => "Can view unapproved plugin details",
// "Can execute unapproved plugin" => "Can execute unapproved plugin",
// "Can approve plugin execution" => "Can approve plugin execution",
// "Trust all user inputs (no security checks)" => "Trust all user inputs (no security checks)",
// "View page backlinks" => "View page backlinks",
// "Can admin mail notifications" => "Can admin mail notifications",
// "tiki release" => "tiki release",
// "feature version checks" => "feature version checks",
// "tiki needs upgrade" => "tiki needs upgrade",
// "tiki version last check" => "tiki version last check",
// "tiki version check frequency" => "tiki version check frequency",
// "lastUpdatePrefs" => "lastUpdatePrefs",
// "feature print indexed" => "feature print indexed",
// "feature wiki" => "feature wiki",
// "default wiki diff style" => "default wiki diff style",
// "feature backlinks" => "feature backlinks",
// "feature dump" => "feature dump",
// "feature history" => "feature history",
// "feature lastChanges" => "feature lastChanges",
// "feature likePages" => "feature likePages",
// "feature listPages" => "feature listPages",
// "feature listorphanPages" => "feature listorphanPages",
// "feature page title" => "feature page title",
// "feature sandbox" => "feature sandbox",
// "feature warn on edit" => "feature warn on edit",
// "feature wiki 1like redirection" => "feature wiki 1like redirection",
// "feature wiki allowhtml" => "feature wiki allowhtml",
// "feature wiki argvariable" => "feature wiki argvariable",
// "feature wiki attachments" => "feature wiki attachments",
// "feature wiki comments" => "feature wiki comments",
// "feature wiki description" => "feature wiki description",
// "feature wiki discuss" => "feature wiki discuss",
// "feature wiki export" => "feature wiki export",
// "feature wiki structure" => "feature wiki structure",
// "feature wiki import page" => "feature wiki import page",
// "feature wiki footnotes" => "feature wiki footnotes",
// "feature wiki icache" => "feature wiki icache",
// "feature wiki import html" => "feature wiki import html",
// "feature wiki mindmap" => "feature wiki mindmap",
// "feature wiki monosp" => "feature wiki monosp",
// "feature wiki multiprint" => "feature wiki multiprint",
// "feature wiki notepad" => "feature wiki notepad",
// "feature wiki make structure" => "feature wiki make structure",
// "feature wiki open as structure" => "feature wiki open as structure",
// "feature wiki pageid" => "feature wiki pageid",
// "feature wiki paragraph formatting" => "feature wiki paragraph formatting",
// "feature wiki paragraph formatting add br" => "feature wiki paragraph formatting add br",
// "feature wiki pictures" => "feature wiki pictures",
// "feature wiki plurals" => "feature wiki plurals",
// "feature wiki print" => "feature wiki print",
// "feature wiki protect email" => "feature wiki protect email",
// "feature wiki rankings" => "feature wiki rankings",
// "feature wiki ratings" => "feature wiki ratings",
// "feature wiki replace" => "feature wiki replace",
// "feature wiki show hide before" => "feature wiki show hide before",
// "feature wiki tables" => "feature wiki tables",
// "feature wiki templates" => "feature wiki templates",
// "feature wiki undo" => "feature wiki undo",
// "feature wiki userpage" => "feature wiki userpage",
// "feature wiki userpage prefix" => "feature wiki userpage prefix",
// "feature wiki usrlock" => "feature wiki usrlock",
// "feature wiki feedback polls" => "feature wiki feedback polls",
// "feature wiki save draft" => "feature wiki save draft",
// "feature wikiwords" => "feature wikiwords",
// "feature wikiwords usedash" => "feature wikiwords usedash",
// "feature wiki pagealias" => "feature wiki pagealias",
// "mailin autocheck" => "mailin autocheck",
// "mailin autocheckFreq" => "mailin autocheckFreq",
// "mailin autocheckLast" => "mailin autocheckLast",
// "page bar position" => "page bar position",
// "warn on edit time" => "warn on edit time",
// "wikiHomePage" => "wikiHomePage",
// "wikiLicensePage" => "wikiLicensePage",
// "wikiSubmitNotice" => "wikiSubmitNotice",
// "wiki authors style" => "wiki authors style",
// "wiki authors style by page" => "wiki authors style by page",
// "wiki show version" => "wiki show version",
// "wiki bot bar" => "wiki bot bar",
// "wiki cache" => "wiki cache",
// "wiki comments default ordering" => "wiki comments default ordering",
// "wiki comments displayed default" => "wiki comments displayed default",
// "wiki comments per page" => "wiki comments per page",
// "wiki creator admin" => "wiki creator admin",
// "wiki feature copyrights" => "wiki feature copyrights",
// "wiki forum id" => "wiki forum id",
// "wiki left column" => "wiki left column",
// "wiki list backlinks" => "wiki list backlinks",
// "wiki list comment" => "wiki list comment",
// "wiki list comment len" => "wiki list comment len",
// "wiki list description" => "wiki list description",
// "wiki list description len" => "wiki list description len",
// "wiki list creator" => "wiki list creator",
// "wiki list hits" => "wiki list hits",
// "wiki list lastmodif" => "wiki list lastmodif",
// "wiki list lastver" => "wiki list lastver",
// "wiki list links" => "wiki list links",
// "wiki list name" => "wiki list name",
// "wiki list name len" => "wiki list name len",
// "wiki list size" => "wiki list size",
// "wiki list status" => "wiki list status",
// "wiki list user" => "wiki list user",
// "wiki list versions" => "wiki list versions",
// "wiki list language" => "wiki list language",
// "wiki list categories" => "wiki list categories",
// "wiki list categories path" => "wiki list categories path",
// "wiki list id" => "wiki list id",
// "wiki list sortorder" => "wiki list sortorder",
// "wiki list sortdirection" => "wiki list sortdirection",
// "wiki pagealias tokens" => "wiki pagealias tokens",
// "wiki page regex" => "wiki page regex",
// "wiki page separator" => "wiki page separator",
// "wiki page navigation bar" => "wiki page navigation bar",
// "wiki actions bar" => "wiki actions bar",
// "wiki pagename strip" => "wiki pagename strip",
// "wiki right column" => "wiki right column",
// "wiki top bar" => "wiki top bar",
// "wiki topline position" => "wiki topline position",
// "wiki uses slides" => "wiki uses slides",
// "wiki watch author" => "wiki watch author",
// "wiki watch comments" => "wiki watch comments",
// "wiki watch editor" => "wiki watch editor",
// "wiki watch minor" => "wiki watch minor",
// "feature wiki history full" => "feature wiki history full",
// "feature wiki categorize structure" => "feature wiki categorize structure",
// "feature wiki watch structure" => "feature wiki watch structure",
// "feature wikiapproval" => "feature wikiapproval",
// "wikiapproval prefix" => "wikiapproval prefix",
// "wikiapproval hideprefix" => "wikiapproval hideprefix",
// "wikiapproval delete staging" => "wikiapproval delete staging",
// "wikiapproval master group" => "wikiapproval master group",
// "wikiapproval staging category" => "wikiapproval staging category",
// "wikiapproval approved category" => "wikiapproval approved category",
// "wikiapproval outofsync category" => "wikiapproval outofsync category",
// "wikiapproval block editapproved" => "wikiapproval block editapproved",
// "wikiapproval sync categories" => "wikiapproval sync categories",
// "wikiapproval update freetags" => "wikiapproval update freetags",
// "wikiapproval combine freetags" => "wikiapproval combine freetags",
// "wiki edit section" => "wiki edit section",
// "wiki edit section level" => "wiki edit section level",
// "wiki edit plugin" => "wiki edit plugin",
// "wiki validate plugin" => "wiki validate plugin",
// "wiki edit minor" => "wiki edit minor",
// "wikiplugin agentinfo" => "wikiplugin agentinfo",
// "wikiplugin alink" => "wikiplugin alink",
// "wikiplugin aname" => "wikiplugin aname",
// "wikiplugin annotation" => "wikiplugin annotation",
// "wikiplugin article" => "wikiplugin article",
// "wikiplugin articles" => "wikiplugin articles",
// "wikiplugin attach" => "wikiplugin attach",
// "wikiplugin avatar" => "wikiplugin avatar",
// "wikiplugin back" => "wikiplugin back",
// "wikiplugin backlinks" => "wikiplugin backlinks",
// "wikiplugin banner" => "wikiplugin banner",
// "wikiplugin bloglist" => "wikiplugin bloglist",
// "wikiplugin box" => "wikiplugin box",
// "wikiplugin category" => "wikiplugin category",
// "wikiplugin catorphans" => "wikiplugin catorphans",
// "wikiplugin catpath" => "wikiplugin catpath",
// "wikiplugin center" => "wikiplugin center",
// "wikiplugin chart" => "wikiplugin chart",
// "wikiplugin code" => "wikiplugin code",
// "wikiplugin content" => "wikiplugin content",
// "wikiplugin cookie" => "wikiplugin cookie",
// "wikiplugin copyright" => "wikiplugin copyright",
// "wikiplugin countdown" => "wikiplugin countdown",
// "wikiplugin dbreport" => "wikiplugin dbreport",
// "wikiplugin div" => "wikiplugin div",
// "wikiplugin dl" => "wikiplugin dl",
// "wikiplugin draw" => "wikiplugin draw",
// "wikiplugin equation" => "wikiplugin equation",
// "wikiplugin events" => "wikiplugin events",
// "wikiplugin fade" => "wikiplugin fade",
// "wikiplugin fancylist" => "wikiplugin fancylist",
// "wikiplugin fancytable" => "wikiplugin fancytable",
// "wikiplugin file" => "wikiplugin file",
// "wikiplugin files" => "wikiplugin files",
// "wikiplugin flash" => "wikiplugin flash",
// "wikiplugin footnote" => "wikiplugin footnote",
// "wikiplugin footnotearea" => "wikiplugin footnotearea",
// "wikiplugin ftp" => "wikiplugin ftp",
// "wikiplugin gauge" => "wikiplugin gauge",
// "wikiplugin googleanalytics" => "wikiplugin googleanalytics",
// "wikiplugin googledoc" => "wikiplugin googledoc",
// "wikiplugin group" => "wikiplugin group",
// "wikiplugin html" => "wikiplugin html",
// "wikiplugin iframe" => "wikiplugin iframe",
// "wikiplugin img" => "wikiplugin img",
// "wikiplugin image" => "wikiplugin image",
// "wikiplugin include" => "wikiplugin include",
// "wikiplugin jabber" => "wikiplugin jabber",
// "wikiplugin js" => "wikiplugin js",
// "wikiplugin jq" => "wikiplugin jq",
// "wikiplugin lang" => "wikiplugin lang",
// "wikiplugin lastmod" => "wikiplugin lastmod",
// "wikiplugin listpages" => "wikiplugin listpages",
// "wikiplugin lsdir" => "wikiplugin lsdir",
// "wikiplugin map" => "wikiplugin map",
// "wikiplugin mediaplayer" => "wikiplugin mediaplayer",
// "wikiplugin miniquiz" => "wikiplugin miniquiz",
// "wikiplugin module" => "wikiplugin module",
// "wikiplugin mono" => "wikiplugin mono",
// "wikiplugin mouseover" => "wikiplugin mouseover",
// "wikiplugin mwtable" => "wikiplugin mwtable",
// "wikiplugin myspace" => "wikiplugin myspace",
// "wikiplugin objecthits" => "wikiplugin objecthits",
// "wikiplugin picture" => "wikiplugin picture",
// "wikiplugin pluginmanager" => "wikiplugin pluginmanager",
// "wikiplugin poll" => "wikiplugin poll",
// "wikiplugin profile" => "wikiplugin profile",
// "wikiplugin proposal" => "wikiplugin proposal",
// "wikiplugin quote" => "wikiplugin quote",
// "wikiplugin rcontent" => "wikiplugin rcontent",
// "wikiplugin redirect" => "wikiplugin redirect",
// "wikiplugin regex" => "wikiplugin regex",
// "wikiplugin remarksbox" => "wikiplugin remarksbox",
// "wikiplugin rss" => "wikiplugin rss",
// "wikiplugin sf" => "wikiplugin sf",
// "wikiplugin share" => "wikiplugin share",
// "wikiplugin sharethis" => "wikiplugin sharethis",
// "wikiplugin sheet" => "wikiplugin sheet",
// "wikiplugin showpages" => "wikiplugin showpages",
// "wikiplugin skype" => "wikiplugin skype",
// "wikiplugin snarf" => "wikiplugin snarf",
// "wikiplugin sort" => "wikiplugin sort",
// "wikiplugin split" => "wikiplugin split",
// "wikiplugin sql" => "wikiplugin sql",
// "wikiplugin sub" => "wikiplugin sub",
// "wikiplugin subscribegroup" => "wikiplugin subscribegroup",
// "wikiplugin subscribegroups" => "wikiplugin subscribegroups",
// "wikiplugin sup" => "wikiplugin sup",
// "wikiplugin survey" => "wikiplugin survey",
// "wikiplugin tag" => "wikiplugin tag",
// "wikiplugin thumb" => "wikiplugin thumb",
// "wikiplugin titlesearch" => "wikiplugin titlesearch",
// "wikiplugin toc" => "wikiplugin toc",
// "wikiplugin topfriends" => "wikiplugin topfriends",
// "wikiplugin trackerfilter" => "wikiplugin trackerfilter",
// "wikiplugin trackeritemfield" => "wikiplugin trackeritemfield",
// "wikiplugin trackerlist" => "wikiplugin trackerlist",
// "wikiplugin trackertimeline" => "wikiplugin trackertimeline",
// "wikiplugin tracker" => "wikiplugin tracker",
// "wikiplugin trackerprefill" => "wikiplugin trackerprefill",
// "wikiplugin trackerstat" => "wikiplugin trackerstat",
// "wikiplugin translated" => "wikiplugin translated",
// "wikiplugin tr" => "wikiplugin tr",
// "wikiplugin usercount" => "wikiplugin usercount",
// "wikiplugin userlist" => "wikiplugin userlist",
// "wikiplugin versions" => "wikiplugin versions",
// "wikiplugin vote" => "wikiplugin vote",
// "wikiplugin wantedpages" => "wikiplugin wantedpages",
// "wikiplugin webservice" => "wikiplugin webservice",
// "wikiplugin youtube" => "wikiplugin youtube",
// "wikiplugininline agentinfo" => "wikiplugininline agentinfo",
// "wikiplugininline alink" => "wikiplugininline alink",
// "wikiplugininline aname" => "wikiplugininline aname",
// "wikiplugininline annotation" => "wikiplugininline annotation",
// "wikiplugininline article" => "wikiplugininline article",
// "wikiplugininline articles" => "wikiplugininline articles",
// "wikiplugininline attach" => "wikiplugininline attach",
// "wikiplugininline avatar" => "wikiplugininline avatar",
// "wikiplugininline back" => "wikiplugininline back",
// "wikiplugininline backlinks" => "wikiplugininline backlinks",
// "wikiplugininline banner" => "wikiplugininline banner",
// "wikiplugininline bloglist" => "wikiplugininline bloglist",
// "wikiplugininline box" => "wikiplugininline box",
// "wikiplugininline category" => "wikiplugininline category",
// "wikiplugininline catorphans" => "wikiplugininline catorphans",
// "wikiplugininline catpath" => "wikiplugininline catpath",
// "wikiplugininline center" => "wikiplugininline center",
// "wikiplugininline chart" => "wikiplugininline chart",
// "wikiplugininline code" => "wikiplugininline code",
// "wikiplugininline content" => "wikiplugininline content",
// "wikiplugininline cookie" => "wikiplugininline cookie",
// "wikiplugininline copyright" => "wikiplugininline copyright",
// "wikiplugininline countdown" => "wikiplugininline countdown",
// "wikiplugininline dbreport" => "wikiplugininline dbreport",
// "wikiplugininline div" => "wikiplugininline div",
// "wikiplugininline dl" => "wikiplugininline dl",
// "wikiplugininline draw" => "wikiplugininline draw",
// "wikiplugininline equation" => "wikiplugininline equation",
// "wikiplugininline events" => "wikiplugininline events",
// "wikiplugininline fade" => "wikiplugininline fade",
// "wikiplugininline fancylist" => "wikiplugininline fancylist",
// "wikiplugininline fancytable" => "wikiplugininline fancytable",
// "wikiplugininline file" => "wikiplugininline file",
// "wikiplugininline files" => "wikiplugininline files",
// "wikiplugininline flash" => "wikiplugininline flash",
// "wikiplugininline footnote" => "wikiplugininline footnote",
// "wikiplugininline footnotearea" => "wikiplugininline footnotearea",
// "wikiplugininline ftp" => "wikiplugininline ftp",
// "wikiplugininline gauge" => "wikiplugininline gauge",
// "wikiplugininline googleanalytics" => "wikiplugininline googleanalytics",
// "wikiplugininline googledoc" => "wikiplugininline googledoc",
// "wikiplugininline group" => "wikiplugininline group",
// "wikiplugininline html" => "wikiplugininline html",
// "wikiplugininline iframe" => "wikiplugininline iframe",
// "wikiplugininline img" => "wikiplugininline img",
// "wikiplugininline image" => "wikiplugininline image",
// "wikiplugininline include" => "wikiplugininline include",
// "wikiplugininline jabber" => "wikiplugininline jabber",
// "wikiplugininline js" => "wikiplugininline js",
// "wikiplugininline jq" => "wikiplugininline jq",
// "wikiplugininline lang" => "wikiplugininline lang",
// "wikiplugininline lastmod" => "wikiplugininline lastmod",
// "wikiplugininline listpages" => "wikiplugininline listpages",
// "wikiplugininline lsdir" => "wikiplugininline lsdir",
// "wikiplugininline map" => "wikiplugininline map",
// "wikiplugininline mediaplayer" => "wikiplugininline mediaplayer",
// "wikiplugininline miniquiz" => "wikiplugininline miniquiz",
// "wikiplugininline module" => "wikiplugininline module",
// "wikiplugininline mono" => "wikiplugininline mono",
// "wikiplugininline mouseover" => "wikiplugininline mouseover",
// "wikiplugininline mwtable" => "wikiplugininline mwtable",
// "wikiplugininline myspace" => "wikiplugininline myspace",
// "wikiplugininline objecthits" => "wikiplugininline objecthits",
// "wikiplugininline picture" => "wikiplugininline picture",
// "wikiplugininline pluginmanager" => "wikiplugininline pluginmanager",
// "wikiplugininline poll" => "wikiplugininline poll",
// "wikiplugininline profile" => "wikiplugininline profile",
// "wikiplugininline proposal" => "wikiplugininline proposal",
// "wikiplugininline quote" => "wikiplugininline quote",
// "wikiplugininline rcontent" => "wikiplugininline rcontent",
// "wikiplugininline redirect" => "wikiplugininline redirect",
// "wikiplugininline regex" => "wikiplugininline regex",
// "wikiplugininline remarksbox" => "wikiplugininline remarksbox",
// "wikiplugininline rss" => "wikiplugininline rss",
// "wikiplugininline sf" => "wikiplugininline sf",
// "wikiplugininline share" => "wikiplugininline share",
// "wikiplugininline sharethis" => "wikiplugininline sharethis",
// "wikiplugininline sheet" => "wikiplugininline sheet",
// "wikiplugininline showpages" => "wikiplugininline showpages",
// "wikiplugininline skype" => "wikiplugininline skype",
// "wikiplugininline snarf" => "wikiplugininline snarf",
// "wikiplugininline sort" => "wikiplugininline sort",
// "wikiplugininline split" => "wikiplugininline split",
// "wikiplugininline sql" => "wikiplugininline sql",
// "wikiplugininline sub" => "wikiplugininline sub",
// "wikiplugininline subscribegroup" => "wikiplugininline subscribegroup",
// "wikiplugininline subscribegroups" => "wikiplugininline subscribegroups",
// "wikiplugininline sup" => "wikiplugininline sup",
// "wikiplugininline survey" => "wikiplugininline survey",
// "wikiplugininline tag" => "wikiplugininline tag",
// "wikiplugininline thumb" => "wikiplugininline thumb",
// "wikiplugininline titlesearch" => "wikiplugininline titlesearch",
// "wikiplugininline toc" => "wikiplugininline toc",
// "wikiplugininline topfriends" => "wikiplugininline topfriends",
// "wikiplugininline trackerfilter" => "wikiplugininline trackerfilter",
// "wikiplugininline trackeritemfield" => "wikiplugininline trackeritemfield",
// "wikiplugininline trackerlist" => "wikiplugininline trackerlist",
// "wikiplugininline trackertimeline" => "wikiplugininline trackertimeline",
// "wikiplugininline tracker" => "wikiplugininline tracker",
// "wikiplugininline trackerprefill" => "wikiplugininline trackerprefill",
// "wikiplugininline trackerstat" => "wikiplugininline trackerstat",
// "wikiplugininline translated" => "wikiplugininline translated",
// "wikiplugininline tr" => "wikiplugininline tr",
// "wikiplugininline usercount" => "wikiplugininline usercount",
// "wikiplugininline userlist" => "wikiplugininline userlist",
// "wikiplugininline versions" => "wikiplugininline versions",
// "wikiplugininline vote" => "wikiplugininline vote",
// "wikiplugininline wantedpages" => "wikiplugininline wantedpages",
// "wikiplugininline webservice" => "wikiplugininline webservice",
// "wikiplugininline youtube" => "wikiplugininline youtube",
// "webservice consume defaultcache" => "webservice consume defaultcache",
// "feature wysiwyg" => "feature wysiwyg",
// "wysiwyg optional" => "wysiwyg optional",
// "wysiwyg default" => "wysiwyg default",
// "wysiwyg memo" => "wysiwyg memo",
// "wysiwyg wiki parsed" => "wysiwyg wiki parsed",
// "wysiwyg wiki semi parsed" => "wysiwyg wiki semi parsed",
// "wysiwyg toolbar skin" => "wysiwyg toolbar skin",
// "wysiwyg toolbar" => "wysiwyg toolbar",
// "wiki feature 3d" => "wiki feature 3d",
// "wiki 3d width" => "wiki 3d width",
// "wiki 3d height" => "wiki 3d height",
// "wiki 3d navigation depth" => "wiki 3d navigation depth",
// "wiki 3d feed animation interval" => "wiki 3d feed animation interval",
// "wiki 3d existing page color" => "wiki 3d existing page color",
// "wiki 3d missing page color" => "wiki 3d missing page color",
// "feature blogs" => "feature blogs",
// "blog list order" => "blog list order",
// "home blog" => "home blog",
// "feature blog rankings" => "feature blog rankings",
// "feature blog comments" => "feature blog comments",
// "blog comments default ordering" => "blog comments default ordering",
// "blog comments per page" => "blog comments per page",
// "feature blogposts comments" => "feature blogposts comments",
// "blog list user" => "blog list user",
// "blog list title" => "blog list title",
// "blog list title len" => "blog list title len",
// "blog list description" => "blog list description",
// "blog list created" => "blog list created",
// "blog list lastmodif" => "blog list lastmodif",
// "blog list posts" => "blog list posts",
// "blog list visits" => "blog list visits",
// "blog list activity" => "blog list activity",
// "feature blog mandatory category" => "feature blog mandatory category",
// "feature blog heading" => "feature blog heading",
// "feature file galleries" => "feature file galleries",
// "home file gallery" => "home file gallery",
// "fgal use db" => "fgal use db",
// "fgal batch dir" => "fgal batch dir",
// "fgal match regex" => "fgal match regex",
// "fgal nmatch regex" => "fgal nmatch regex",
// "fgal use dir" => "fgal use dir",
// "fgal podcast dir" => "fgal podcast dir",
// "feature file galleries comments" => "feature file galleries comments",
// "file galleries comments default ordering" => "file galleries comments default ordering",
// "file galleries comments per page" => "file galleries comments per page",
// "feature file galleries batch" => "feature file galleries batch",
// "feature file galleries rankings" => "feature file galleries rankings",
// "fgal enable auto indexing" => "fgal enable auto indexing",
// "fgal asynchronous indexing" => "fgal asynchronous indexing",
// "fgal allow duplicates" => "fgal allow duplicates",
// "fgal sort mode" => "fgal sort mode",
// "feature file galleries author" => "feature file galleries author",
// "fgal list id" => "fgal list id",
// "fgal list type" => "fgal list type",
// "fgal list name" => "fgal list name",
// "fgal list description" => "fgal list description",
// "fgal list size" => "fgal list size",
// "fgal list created" => "fgal list created",
// "fgal list lastmodif" => "fgal list lastmodif",
// "fgal list creator" => "fgal list creator",
// "fgal list author" => "fgal list author",
// "fgal list last user" => "fgal list last user",
// "fgal list comment" => "fgal list comment",
// "fgal list files" => "fgal list files",
// "fgal list hits" => "fgal list hits",
// "fgal list lockedby" => "fgal list lockedby",
// "fgal show path" => "fgal show path",
// "fgal show explorer" => "fgal show explorer",
// "fgal show slideshow" => "fgal show slideshow",
// "fgal default view" => "fgal default view",
// "fgal limit hits per file" => "fgal limit hits per file",
// "fgal prevent negative score" => "fgal prevent negative score",
// "feature galleries" => "feature galleries",
// "feature gal batch" => "feature gal batch",
// "feature gal slideshow" => "feature gal slideshow",
// "home gallery" => "home gallery",
// "gal use db" => "gal use db",
// "gal use lib" => "gal use lib",
// "gal match regex" => "gal match regex",
// "gal nmatch regex" => "gal nmatch regex",
// "gal use dir" => "gal use dir",
// "gal batch dir" => "gal batch dir",
// "feature gal rankings" => "feature gal rankings",
// "feature image galleries comments" => "feature image galleries comments",
// "image galleries comments default order" => "image galleries comments default order",
// "image galleries comments per page" => "image galleries comments per page",
// "gal list name" => "gal list name",
// "gal list parent" => "gal list parent",
// "gal list description" => "gal list description",
// "gal list created" => "gal list created",
// "gal list lastmodif" => "gal list lastmodif",
// "gal list user" => "gal list user",
// "gal list imgs" => "gal list imgs",
// "gal list visits" => "gal list visits",
// "feature image gallery mandatory category" => "feature image gallery mandatory category",
// "preset galleries info" => "preset galleries info",
// "gal image mouseover" => "gal image mouseover",
// "ProgressBarPlay" => "ProgressBarPlay",
// "ProgressBarLoad" => "ProgressBarLoad",
// "ProgressBarButton" => "ProgressBarButton",
// "ProgressBar" => "ProgressBar",
// "VolumeOn" => "VolumeOn",
// "VolumeOff" => "VolumeOff",
// "VolumeButton" => "VolumeButton",
// "Button" => "Button",
// "ButtonPressed" => "ButtonPressed",
// "ButtonOver" => "ButtonOver",
// "ButtonInfo" => "ButtonInfo",
// "ButtonInfoPressed" => "ButtonInfoPressed",
// "ButtonInfoOver" => "ButtonInfoOver",
// "ButtonInfoText" => "ButtonInfoText",
// "ID3" => "ID3",
// "PlayTime" => "PlayTime",
// "TotalTime" => "TotalTime",
// "PanelDisplay" => "PanelDisplay",
// "AlertMesg" => "AlertMesg",
// "PreloadDelay" => "PreloadDelay",
// "VideoHeight" => "VideoHeight",
// "VideoLength" => "VideoLength",
// "URLAppend" => "URLAppend",
// "LimitedMsg" => "LimitedMsg",
// "MaxPlay" => "MaxPlay",
// "MultimediaGalerie" => "MultimediaGalerie",
// "MultimediaDefaultLength" => "MultimediaDefaultLength",
// "MultimediaDefaultHeight" => "MultimediaDefaultHeight",
// "feature forums" => "feature forums",
// "home forum" => "home forum",
// "feature forum rankings" => "feature forum rankings",
// "feature forum parse" => "feature forum parse",
// "feature forum topics archiving" => "feature forum topics archiving",
// "feature forum replyempty" => "feature forum replyempty",
// "feature forum quickjump" => "feature forum quickjump",
// "feature forums allow thread titles" => "feature forums allow thread titles",
// "feature forum content search" => "feature forum content search",
// "feature forums name search" => "feature forums name search",
// "forums ordering" => "forums ordering",
// "forum list topics" => "forum list topics",
// "forum list posts" => "forum list posts",
// "forum list ppd" => "forum list ppd",
// "forum list lastpost" => "forum list lastpost",
// "forum list visits" => "forum list visits",
// "forum list desc" => "forum list desc",
// "forum list description len" => "forum list description len",
// "feature forum local search" => "feature forum local search",
// "feature forum local tiki search" => "feature forum local tiki search",
// "forum thread defaults by forum" => "forum thread defaults by forum",
// "forum thread user settings" => "forum thread user settings",
// "forum thread user settings keep" => "forum thread user settings keep",
// "forum comments per page" => "forum comments per page",
// "forum comments no title prefix" => "forum comments no title prefix",
// "forum thread style" => "forum thread style",
// "forum thread sort mode" => "forum thread sort mode",
// "forum match regex" => "forum match regex",
// "feature articles" => "feature articles",
// "feature submissions" => "feature submissions",
// "feature cms rankings" => "feature cms rankings",
// "feature cms print" => "feature cms print",
// "feature cms emails" => "feature cms emails",
// "art list title" => "art list title",
// "art list title len" => "art list title len",
// "art list topic" => "art list topic",
// "art list date" => "art list date",
// "art list author" => "art list author",
// "art list reads" => "art list reads",
// "art list size" => "art list size",
// "art list expire" => "art list expire",
// "art list img" => "art list img",
// "art list type" => "art list type",
// "art list visible" => "art list visible",
// "art view type" => "art view type",
// "art view title" => "art view title",
// "art view topic" => "art view topic",
// "art view date" => "art view date",
// "art view author" => "art view author",
// "art view reads" => "art view reads",
// "art view size" => "art view size",
// "art view img" => "art view img",
// "art list lang" => "art list lang",
// "feature article comments" => "feature article comments",
// "article comments default ordering" => "article comments default ordering",
// "article comments per page" => "article comments per page",
// "article image size x" => "article image size x",
// "article image size y" => "article image size y",
// "feature cms templates" => "feature cms templates",
// "cms bot bar" => "cms bot bar",
// "cms left column" => "cms left column",
// "cms right column" => "cms right column",
// "cms top bar" => "cms top bar",
// "cms spellcheck" => "cms spellcheck",
// "art home title" => "art home title",
// "feature trackers" => "feature trackers",
// "t use db" => "t use db",
// "t use dir" => "t use dir",
// "groupTracker" => "groupTracker",
// "userTracker" => "userTracker",
// "trk with mirror tables" => "trk with mirror tables",
// "feature userlevels" => "feature userlevels",
// "userlevels" => "userlevels",
// "userbreadCrumb" => "userbreadCrumb",
// "user assigned modules" => "user assigned modules",
// "user flip modules" => "user flip modules",
// "user show realnames" => "user show realnames",
// "feature mytiki" => "feature mytiki",
// "feature userPreferences" => "feature userPreferences",
// "feature user bookmarks" => "feature user bookmarks",
// "feature tasks" => "feature tasks",
// "w use db" => "w use db",
// "w use dir" => "w use dir",
// "w displayed default" => "w displayed default",
// "uf use db" => "uf use db",
// "uf use dir" => "uf use dir",
// "userfiles quota" => "userfiles quota",
// "feature usermenu" => "feature usermenu",
// "feature minical" => "feature minical",
// "feature notepad" => "feature notepad",
// "feature userfiles" => "feature userfiles",
// "feature community gender" => "feature community gender",
// "feature community mouseover" => "feature community mouseover",
// "feature community mouseover name" => "feature community mouseover name",
// "feature community mouseover gender" => "feature community mouseover gender",
// "feature community mouseover picture" => "feature community mouseover picture",
// "feature community mouseover friends" => "feature community mouseover friends",
// "feature community mouseover score" => "feature community mouseover score",
// "feature community mouseover country" => "feature community mouseover country",
// "feature community mouseover email" => "feature community mouseover email",
// "feature community mouseover lastlogin" => "feature community mouseover lastlogin",
// "feature community mouseover distance" => "feature community mouseover distance",
// "feature community list name" => "feature community list name",
// "feature community list score" => "feature community list score",
// "feature community list country" => "feature community list country",
// "feature community list distance" => "feature community list distance",
// "feature community friends permission" => "feature community friends permission",
// "feature community friends permission dep" => "feature community friends permission dep",
// "change language" => "change language",
// "change theme" => "change theme",
// "login is email" => "login is email",
// "validateUsers" => "validateUsers",
// "validateEmail" => "validateEmail",
// "forgotPass" => "forgotPass",
// "change password" => "change password",
// "available languages" => "available languages",
// "available styles" => "available styles",
// "lowercase username" => "lowercase username",
// "username pattern" => "username pattern",
// "max username length" => "max username length",
// "min username length" => "min username length",
// "users prefs allowMsgs" => "users prefs allowMsgs",
// "users prefs country" => "users prefs country",
// "users prefs diff versions" => "users prefs diff versions",
// "users prefs display timezone" => "users prefs display timezone",
// "users prefs email is public" => "users prefs email is public",
// "users prefs homePage" => "users prefs homePage",
// "users prefs lat" => "users prefs lat",
// "users prefs lon" => "users prefs lon",
// "users prefs mess archiveAfter" => "users prefs mess archiveAfter",
// "users prefs mess maxRecords" => "users prefs mess maxRecords",
// "users prefs mess sendReadStatus" => "users prefs mess sendReadStatus",
// "users prefs minPrio" => "users prefs minPrio",
// "users prefs mytiki blogs" => "users prefs mytiki blogs",
// "users prefs mytiki articles" => "users prefs mytiki articles",
// "users prefs mytiki gals" => "users prefs mytiki gals",
// "users prefs mytiki items" => "users prefs mytiki items",
// "users prefs mytiki msgs" => "users prefs mytiki msgs",
// "users prefs mytiki pages" => "users prefs mytiki pages",
// "users prefs mytiki tasks" => "users prefs mytiki tasks",
// "users prefs mytiki workflow" => "users prefs mytiki workflow",
// "users prefs mytiki forum topics" => "users prefs mytiki forum topics",
// "users prefs mytiki forum replies" => "users prefs mytiki forum replies",
// "users prefs realName" => "users prefs realName",
// "users prefs gender" => "users prefs gender",
// "users prefs show mouseover user info" => "users prefs show mouseover user info",
// "users prefs tasks maxRecords" => "users prefs tasks maxRecords",
// "users prefs user dbl" => "users prefs user dbl",
// "users prefs user information" => "users prefs user information",
// "users prefs userbreadCrumb" => "users prefs userbreadCrumb",
// "users prefs mailCharset" => "users prefs mailCharset",
// "validateRegistration" => "validateRegistration",
// "feature messages" => "feature messages",
// "messu mailbox size" => "messu mailbox size",
// "messu archive size" => "messu archive size",
// "messu sent size" => "messu sent size",
// "allowmsg by default" => "allowmsg by default",
// "allowmsg is optional" => "allowmsg is optional",
// "feature newsreader" => "feature newsreader",
// "feature freetags" => "feature freetags",
// "freetags browse show cloud" => "freetags browse show cloud",
// "freetags cloud colors" => "freetags cloud colors",
// "freetags preload random search" => "freetags preload random search",
// "freetags browse amount tags in cloud" => "freetags browse amount tags in cloud",
// "freetags browse amount tags suggestion" => "freetags browse amount tags suggestion",
// "freetags normalized valid chars" => "freetags normalized valid chars",
// "freetags lowercase only" => "freetags lowercase only",
// "freetags feature 3d" => "freetags feature 3d",
// "freetags 3d width" => "freetags 3d width",
// "freetags 3d height" => "freetags 3d height",
// "freetags 3d navigation depth" => "freetags 3d navigation depth",
// "freetags 3d feed animation interval" => "freetags 3d feed animation interval",
// "freetags 3d existing page color" => "freetags 3d existing page color",
// "freetags 3d missing page color" => "freetags 3d missing page color",
// "freetags 3d autoload" => "freetags 3d autoload",
// "freetags 3d camera distance" => "freetags 3d camera distance",
// "freetags 3d elastic constant" => "freetags 3d elastic constant",
// "freetags 3d eletrostatic constant" => "freetags 3d eletrostatic constant",
// "freetags 3d fov" => "freetags 3d fov",
// "freetags 3d friction constant" => "freetags 3d friction constant",
// "freetags 3d node charge" => "freetags 3d node charge",
// "freetags 3d node mass" => "freetags 3d node mass",
// "freetags 3d node size" => "freetags 3d node size",
// "freetags 3d spring size" => "freetags 3d spring size",
// "freetags 3d text size" => "freetags 3d text size",
// "freetags 3d adjust camera" => "freetags 3d adjust camera",
// "freetags multilingual" => "freetags multilingual",
// "morelikethis algorithm" => "morelikethis algorithm",
// "morelikethis basic mincommon" => "morelikethis basic mincommon",
// "freetags show middle" => "freetags show middle",
// "feature search stats" => "feature search stats",
// "feature search" => "feature search",
// "feature search fulltext" => "feature search fulltext",
// "feature search show forbidden obj" => "feature search show forbidden obj",
// "feature search show forbidden cat" => "feature search show forbidden cat",
// "feature search show object filter" => "feature search show object filter",
// "feature search show search box" => "feature search show search box",
// "feature search show visit count" => "feature search show visit count",
// "feature search show pertinence" => "feature search show pertinence",
// "feature search show object type" => "feature search show object type",
// "feature search show last modification" => "feature search show last modification",
// "search refresh index mode" => "search refresh index mode",
// "search parsed snippet" => "search parsed snippet",
// "feature webmail" => "feature webmail",
// "webmail max attachment" => "webmail max attachment",
// "webmail view html" => "webmail view html",
// "feature contacts" => "feature contacts",
// "feature faqs" => "feature faqs",
// "feature faq comments" => "feature faq comments",
// "faq comments per page" => "faq comments per page",
// "faq comments default ordering" => "faq comments default ordering",
// "faq prefix" => "faq prefix",
// "feature quizzes" => "feature quizzes",
// "feature polls" => "feature polls",
// "feature poll comments" => "feature poll comments",
// "feature poll anonymous" => "feature poll anonymous",
// "poll comments default ordering" => "poll comments default ordering",
// "poll comments per page" => "poll comments per page",
// "poll list categories" => "poll list categories",
// "poll list objects" => "poll list objects",
// "feature poll revote" => "feature poll revote",
// "feature surveys" => "feature surveys",
// "feature featuredLinks" => "feature featuredLinks",
// "feature directory" => "feature directory",
// "directory columns" => "directory columns",
// "directory links per page" => "directory links per page",
// "directory open links" => "directory open links",
// "directory validate urls" => "directory validate urls",
// "directory cool sites" => "directory cool sites",
// "directory country flag" => "directory country flag",
// "feature calendar" => "feature calendar",
// "feature default calendars" => "feature default calendars",
// "calendar sticky popup" => "calendar sticky popup",
// "default calendars" => "default calendars",
// "calendar view mode" => "calendar view mode",
// "calendar view tab" => "calendar view tab",
// "calendar firstDayofWeek" => "calendar firstDayofWeek",
// "calendar timespan" => "calendar timespan",
// "feature jscalendar" => "feature jscalendar",
// "feature action calendar" => "feature action calendar",
// "calendar start year" => "calendar start year",
// "calendar end year" => "calendar end year",
// "calendar list begins focus" => "calendar list begins focus",
// "server timezone" => "server timezone",
// "long date format" => "long date format",
// "long time format" => "long time format",
// "short date format" => "short date format",
// "short time format" => "short time format",
// "display field order" => "display field order",
// "feature charts" => "feature charts",
// "rss forums" => "rss forums",
// "rss forum" => "rss forum",
// "rss directories" => "rss directories",
// "rss articles" => "rss articles",
// "rss blogs" => "rss blogs",
// "rss image galleries" => "rss image galleries",
// "rss file galleries" => "rss file galleries",
// "rss wiki" => "rss wiki",
// "rss image gallery" => "rss image gallery",
// "rss file gallery" => "rss file gallery",
// "rss blog" => "rss blog",
// "rss tracker" => "rss tracker",
// "rss trackers" => "rss trackers",
// "rss calendar" => "rss calendar",
// "rss mapfiles" => "rss mapfiles",
// "rss cache time" => "rss cache time",
// "max rss forums" => "max rss forums",
// "max rss forum" => "max rss forum",
// "max rss directories" => "max rss directories",
// "max rss articles" => "max rss articles",
// "max rss blogs" => "max rss blogs",
// "max rss image galleries" => "max rss image galleries",
// "max rss file galleries" => "max rss file galleries",
// "max rss wiki" => "max rss wiki",
// "max rss image gallery" => "max rss image gallery",
// "max rss file gallery" => "max rss file gallery",
// "max rss blog" => "max rss blog",
// "max rss mapfiles" => "max rss mapfiles",
// "max rss tracker" => "max rss tracker",
// "max rss trackers" => "max rss trackers",
// "max rss calendar" => "max rss calendar",
// "summary rss blogs" => "summary rss blogs",
// "rssfeed default version" => "rssfeed default version",
// "rssfeed language" => "rssfeed language",
// "rssfeed editor" => "rssfeed editor",
// "rssfeed webmaster" => "rssfeed webmaster",
// "rssfeed creator" => "rssfeed creator",
// "rssfeed css" => "rssfeed css",
// "rssfeed publisher" => "rssfeed publisher",
// "rssfeed img" => "rssfeed img",
// "rss basic auth" => "rss basic auth",
// "feature maps" => "feature maps",
// "map path" => "map path",
// "default map" => "default map",
// "map help" => "map help",
// "map comments" => "map comments",
// "gdaltindex" => "gdaltindex",
// "ogr2ogr" => "ogr2ogr",
// "mapzone" => "mapzone",
// "feature gmap" => "feature gmap",
// "gmap defaultx" => "gmap defaultx",
// "gmap defaulty" => "gmap defaulty",
// "gmap defaultz" => "gmap defaultz",
// "gmap key" => "gmap key",
// "allowRegister" => "allowRegister",
// "eponymousGroups" => "eponymousGroups",
// "useRegisterPasscode" => "useRegisterPasscode",
// "registerPasscode" => "registerPasscode",
// "rememberme" => "rememberme",
// "remembertime" => "remembertime",
// "feature clear passwords" => "feature clear passwords",
// "feature crypt passwords" => "feature crypt passwords",
// "feature challenge" => "feature challenge",
// "min user length" => "min user length",
// "min pass length" => "min pass length",
// "pass chr num" => "pass chr num",
// "pass due" => "pass due",
// "email due" => "email due",
// "unsuccessful logins" => "unsuccessful logins",
// "rnd num reg" => "rnd num reg",
// "generate password" => "generate password",
// "auth method" => "auth method",
// "auth pear" => "auth pear",
// "auth create user tiki" => "auth create user tiki",
// "auth create user auth" => "auth create user auth",
// "auth skip admin" => "auth skip admin",
// "auth ldap url" => "auth ldap url",
// "auth pear host" => "auth pear host",
// "auth pear port" => "auth pear port",
// "auth ldap scope" => "auth ldap scope",
// "auth ldap basedn" => "auth ldap basedn",
// "auth ldap userdn" => "auth ldap userdn",
// "auth ldap userattr" => "auth ldap userattr",
// "auth ldap useroc" => "auth ldap useroc",
// "auth ldap groupdn" => "auth ldap groupdn",
// "auth ldap groupattr" => "auth ldap groupattr",
// "auth ldap groupoc" => "auth ldap groupoc",
// "auth ldap memberattr" => "auth ldap memberattr",
// "auth ldap memberisdn" => "auth ldap memberisdn",
// "auth ldap adminuser" => "auth ldap adminuser",
// "auth ldap adminpass" => "auth ldap adminpass",
// "auth ldap version" => "auth ldap version",
// "auth ldap nameattr" => "auth ldap nameattr",
// "auth ldap countryattr" => "auth ldap countryattr",
// "auth ldap emailattr" => "auth ldap emailattr",
// "https login" => "https login",
// "feature show stay in ssl mode" => "feature show stay in ssl mode",
// "feature switch ssl mode" => "feature switch ssl mode",
// "https port" => "https port",
// "http port" => "http port",
// "login url" => "login url",
// "login scr" => "login scr",
// "register url" => "register url",
// "error url" => "error url",
// "highlight group" => "highlight group",
// "cookie path" => "cookie path",
// "cookie domain" => "cookie domain",
// "cookie name" => "cookie name",
// "user tracker infos" => "user tracker infos",
// "desactive login autocomplete" => "desactive login autocomplete",
// "permission denied login box" => "permission denied login box",
// "permission denied url" => "permission denied url",
// "feature intertiki" => "feature intertiki",
// "feature intertiki server" => "feature intertiki server",
// "feature intertiki slavemode" => "feature intertiki slavemode",
// "interlist" => "interlist",
// "feature intertiki mymaster" => "feature intertiki mymaster",
// "feature intertiki import preferences" => "feature intertiki import preferences",
// "feature intertiki import groups" => "feature intertiki import groups",
// "known hosts" => "known hosts",
// "tiki key" => "tiki key",
// "intertiki logfile" => "intertiki logfile",
// "intertiki errfile" => "intertiki errfile",
// "feature intertiki sharedcookie" => "feature intertiki sharedcookie",
// "search lru length" => "search lru length",
// "search lru purge rate" => "search lru purge rate",
// "search max syllwords" => "search max syllwords",
// "search min wordlength" => "search min wordlength",
// "search refresh rate" => "search refresh rate",
// "search syll age" => "search syll age",
// "feature categories" => "feature categories",
// "feature categoryobjects" => "feature categoryobjects",
// "feature categorypath" => "feature categorypath",
// "feature category reinforce" => "feature category reinforce",
// "feature category use phplayers" => "feature category use phplayers",
// "categorypath excluded" => "categorypath excluded",
// "categories used in tpl" => "categories used in tpl",
// "feature games" => "feature games",
// "feature html pages" => "feature html pages",
// "feature filegals manager" => "feature filegals manager",
// "feature contact" => "feature contact",
// "contact user" => "contact user",
// "contact anon" => "contact anon",
// "mail crlf" => "mail crlf",
// "feature detect language" => "feature detect language",
// "feature homePage if bl missing" => "feature homePage if bl missing",
// "record untranslated" => "record untranslated",
// "feature best language" => "feature best language",
// "feature translation" => "feature translation",
// "feature urgent translation" => "feature urgent translation",
// "lang use db" => "lang use db",
// "language" => "language",
// "feature babelfish" => "feature babelfish",
// "feature babelfish logo" => "feature babelfish logo",
// "quantify changes" => "quantify changes",
// "feature sync language" => "feature sync language",
// "show available translations" => "show available translations",
// "metatag keywords" => "metatag keywords",
// "metatag threadtitle" => "metatag threadtitle",
// "metatag imagetitle" => "metatag imagetitle",
// "metatag freetags" => "metatag freetags",
// "metatag description" => "metatag description",
// "metatag author" => "metatag author",
// "metatag geoposition" => "metatag geoposition",
// "metatag georegion" => "metatag georegion",
// "metatag geoplacename" => "metatag geoplacename",
// "metatag robots" => "metatag robots",
// "metatag revisitafter" => "metatag revisitafter",
// "head extra js" => "head extra js",
// "keep versions" => "keep versions",
// "feature custom home" => "feature custom home",
// "site crumb seper" => "site crumb seper",
// "site nav seper" => "site nav seper",
// "feature sitemycode" => "feature sitemycode",
// "sitemycode" => "sitemycode",
// "sitemycode publish" => "sitemycode publish",
// "feature sitelogo" => "feature sitelogo",
// "sitelogo bgcolor" => "sitelogo bgcolor",
// "sitelogo bgstyle" => "sitelogo bgstyle",
// "sitelogo align" => "sitelogo align",
// "sitelogo title" => "sitelogo title",
// "sitelogo src" => "sitelogo src",
// "sitelogo alt" => "sitelogo alt",
// "feature siteloc" => "feature siteloc",
// "feature sitenav" => "feature sitenav",
// "sitenav" => "sitenav",
// "feature sitead" => "feature sitead",
// "sitead" => "sitead",
// "sitead publish" => "sitead publish",
// "feature breadcrumbs" => "feature breadcrumbs",
// "feature siteloclabel" => "feature siteloclabel",
// "feature sitesearch" => "feature sitesearch",
// "feature site login" => "feature site login",
// "feature sitemenu" => "feature sitemenu",
// "feature topbar version" => "feature topbar version",
// "feature topbar debug" => "feature topbar debug",
// "feature topbar id menu" => "feature topbar id menu",
// "feature topbar custom code" => "feature topbar custom code",
// "feature sitetitle" => "feature sitetitle",
// "feature sitedesc" => "feature sitedesc",
// "feature bot logo" => "feature bot logo",
// "feature endbody code" => "feature endbody code",
// "feature left column" => "feature left column",
// "feature right column" => "feature right column",
// "feature top bar" => "feature top bar",
// "feature bot bar" => "feature bot bar",
// "feature bot bar icons" => "feature bot bar icons",
// "feature bot bar debug" => "feature bot bar debug",
// "feature bot bar rss" => "feature bot bar rss",
// "feature bot bar power by tw" => "feature bot bar power by tw",
// "maxRecords" => "maxRecords",
// "maxArticles" => "maxArticles",
// "maxVersions" => "maxVersions",
// "feature view tpl" => "feature view tpl",
// "slide style" => "slide style",
// "site favicon" => "site favicon",
// "site favicon type" => "site favicon type",
// "style" => "style",
// "style option" => "style option",
// "site style" => "site style",
// "site style option" => "site style option",
// "use context menu icon" => "use context menu icon",
// "use context menu text" => "use context menu text",
// "feature site report" => "feature site report",
// "feature site send link" => "feature site send link",
// "feature layoutshadows" => "feature layoutshadows",
// "main shadow start" => "main shadow start",
// "main shadow end" => "main shadow end",
// "header shadow start" => "header shadow start",
// "header shadow end" => "header shadow end",
// "middle shadow start" => "middle shadow start",
// "middle shadow end" => "middle shadow end",
// "center shadow start" => "center shadow start",
// "center shadow end" => "center shadow end",
// "footer shadow start" => "footer shadow start",
// "footer shadow end" => "footer shadow end",
// "feature mods provider" => "feature mods provider",
// "mods dir" => "mods dir",
// "mods server" => "mods server",
// "feature experimental" => "feature experimental",
// "feature actionlog" => "feature actionlog",
// "feature actionlog bytes" => "feature actionlog bytes",
// "browsertitle" => "browsertitle",
// "tmpDir" => "tmpDir",
// "feature tell a friend" => "feature tell a friend",
// "feature copyright" => "feature copyright",
// "feature multimedia" => "feature multimedia",
// "feature swfobj" => "feature swfobj",
// "feature smileys" => "feature smileys",
// "popupLinks" => "popupLinks",
// "feature autolinks" => "feature autolinks",
// "quicktags over textarea" => "quicktags over textarea",
// "default rows textarea wiki" => "default rows textarea wiki",
// "default rows textarea comment" => "default rows textarea comment",
// "default rows textarea forum" => "default rows textarea forum",
// "default rows textarea forumthread" => "default rows textarea forumthread",
// "feature floating help" => "feature floating help",
// "direct pagination" => "direct pagination",
// "nextprev pagination" => "nextprev pagination",
// "pagination firstlast" => "pagination firstlast",
// "pagination hide if one page" => "pagination hide if one page",
// "pagination icons" => "pagination icons",
// "pagination fastmove links" => "pagination fastmove links",
// "direct pagination max middle links" => "direct pagination max middle links",
// "direct pagination max ending links" => "direct pagination max ending links",
// "anonCanEdit" => "anonCanEdit",
// "cacheimages" => "cacheimages",
// "cachepages" => "cachepages",
// "count admin pvs" => "count admin pvs",
// "default mail charset" => "default mail charset",
// "error reporting adminonly" => "error reporting adminonly",
// "error reporting level" => "error reporting level",
// "smarty notice reporting" => "smarty notice reporting",
// "smarty security" => "smarty security",
// "feature ajax" => "feature ajax",
// "feature ajax autosave" => "feature ajax autosave",
// "feature antibot" => "feature antibot",
// "feature banners" => "feature banners",
// "feature banning" => "feature banning",
// "feature comm" => "feature comm",
// "feature contribution" => "feature contribution",
// "feature contribution display in comment" => "feature contribution display in comment",
// "feature contribution mandatory" => "feature contribution mandatory",
// "feature contribution mandatory blog" => "feature contribution mandatory blog",
// "feature contribution mandatory comment" => "feature contribution mandatory comment",
// "feature contribution mandatory forum" => "feature contribution mandatory forum",
// "feature debug console" => "feature debug console",
// "feature debugger console" => "feature debugger console",
// "feature display my to others" => "feature display my to others",
// "feature drawings" => "feature drawings",
// "feature dynamic content" => "feature dynamic content",
// "feature edit templates" => "feature edit templates",
// "feature editcss" => "feature editcss",
// "feature events" => "feature events",
// "feature friends" => "feature friends",
// "feature fullscreen" => "feature fullscreen",
// "feature help" => "feature help",
// "feature hotwords" => "feature hotwords",
// "feature hotwords nw" => "feature hotwords nw",
// "feature integrator" => "feature integrator",
// "feature live support" => "feature live support",
// "feature mailin" => "feature mailin",
// "feature menusfolderstyle" => "feature menusfolderstyle",
// "feature mobile" => "feature mobile",
// "feature modulecontrols" => "feature modulecontrols",
// "feature morcego" => "feature morcego",
// "feature multilingual" => "feature multilingual",
// "feature multilingual one page" => "feature multilingual one page",
// "feature multilingual structures" => "feature multilingual structures",
// "feature newsletters" => "feature newsletters",
// "feature obzip" => "feature obzip",
// "feature phplayers" => "feature phplayers",
// "feature cssmenus" => "feature cssmenus",
// "feature projects" => "feature projects",
// "feature ranking" => "feature ranking",
// "feature redirect on error" => "feature redirect on error",
// "feature referer highlight" => "feature referer highlight",
// "feature referer stats" => "feature referer stats",
// "feature score" => "feature score",
// "feature sheet" => "feature sheet",
// "feature shoutbox" => "feature shoutbox",
// "feature source" => "feature source",
// "feature stats" => "feature stats",
// "feature tabs" => "feature tabs",
// "feature theme control" => "feature theme control",
// "feature ticketlib" => "feature ticketlib",
// "feature ticketlib2" => "feature ticketlib2",
// "feature top banner" => "feature top banner",
// "feature usability" => "feature usability",
// "feature use quoteplugin" => "feature use quoteplugin",
// "feature user watches" => "feature user watches",
// "feature group watches" => "feature group watches",
// "feature user watches translations" => "feature user watches translations",
// "feature workflow" => "feature workflow",
// "feature xmlrpc" => "feature xmlrpc",
// "helpurl" => "helpurl",
// "layout section" => "layout section",
// "limitedGoGroupHome" => "limitedGoGroupHome",
// "minical reminders" => "minical reminders",
// "modallgroups" => "modallgroups",
// "modseparateanon" => "modseparateanon",
// "php docroot" => "php docroot",
// "proxy host" => "proxy host",
// "proxy port" => "proxy port",
// "ip can be checked" => "ip can be checked",
// "sender email" => "sender email",
// "feature site report email" => "feature site report email",
// "session db" => "session db",
// "session lifetime" => "session lifetime",
// "shoutbox autolink" => "shoutbox autolink",
// "show comzone" => "show comzone",
// "system os" => "system os",
// "tikiIndex" => "tikiIndex",
// "urlIndex" => "urlIndex",
// "useGroupHome" => "useGroupHome",
// "useGroupTheme" => "useGroupTheme",
// "useUrlIndex" => "useUrlIndex",
// "use proxy" => "use proxy",
// "user list order" => "user list order",
// "webserverauth" => "webserverauth",
// "feature purifier" => "feature purifier",
// "feature shadowbox" => "feature shadowbox",
// "log sql" => "log sql",
// "log sql perf min" => "log sql perf min",
// "log mail" => "log mail",
// "log tpl" => "log tpl",
// "case patched" => "case patched",
// "site closed" => "site closed",
// "site closed msg" => "site closed msg",
// "use load threshold" => "use load threshold",
// "load threshold" => "load threshold",
// "site busy msg" => "site busy msg",
// "bot logo code" => "bot logo code",
// "feature blogposts pings" => "feature blogposts pings",
// "feature create webhelp" => "feature create webhelp",
// "feature forums search" => "feature forums search",
// "feature trackbackpings" => "feature trackbackpings",
// "feature wiki ext icon" => "feature wiki ext icon",
// "feature wiki mandatory category" => "feature wiki mandatory category",
// "feature intertiki imported groups" => "feature intertiki imported groups",
// "feature wiki history ip" => "feature wiki history ip",
// "pam create user tiki" => "pam create user tiki",
// "pam service" => "pam service",
// "pam skip admin" => "pam skip admin",
// "shib affiliation" => "shib affiliation",
// "shib create user tiki" => "shib create user tiki",
// "shib group" => "shib group",
// "shib skip admin" => "shib skip admin",
// "shib usegroup" => "shib usegroup",
// "wiki 3d camera distance" => "wiki 3d camera distance",
// "wiki 3d elastic constant" => "wiki 3d elastic constant",
// "wiki 3d eletrostatic constant" => "wiki 3d eletrostatic constant",
// "wiki 3d fov" => "wiki 3d fov",
// "wiki 3d friction constant" => "wiki 3d friction constant",
// "wiki 3d node charge" => "wiki 3d node charge",
// "wiki 3d node mass" => "wiki 3d node mass",
// "wiki 3d node size" => "wiki 3d node size",
// "wiki 3d spring size" => "wiki 3d spring size",
// "wiki 3d text size" => "wiki 3d text size",
// "articles feature copyrights" => "articles feature copyrights",
// "blogues feature copyrights" => "blogues feature copyrights",
// "faqs feature copyrights" => "faqs feature copyrights",
// "feature contributor wiki" => "feature contributor wiki",
// "https login required" => "https login required",
// "maxRowsGalleries" => "maxRowsGalleries",
// "replimaster" => "replimaster",
// "rowImagesGalleries" => "rowImagesGalleries",
// "scaleSizeGalleries" => "scaleSizeGalleries",
// "thumbSizeXGalleries" => "thumbSizeXGalleries",
// "thumbSizeYGalleries" => "thumbSizeYGalleries",
// "wiki 3d adjust camera" => "wiki 3d adjust camera",
// "wiki 3d autoload" => "wiki 3d autoload",
// "feature mootools" => "feature mootools",
// "javascript enabled" => "javascript enabled",
// "feature comments post as anonymous" => "feature comments post as anonymous",
// "feature comments moderation" => "feature comments moderation",
// "feature comments locking" => "feature comments locking",
// "feature template zoom" => "feature template zoom",
// "feature iepngfix" => "feature iepngfix",
// "iepngfix selectors" => "iepngfix selectors",
// "iepngfix elements" => "iepngfix elements",
// "use minified scripts" => "use minified scripts",
// "valid email regex" => "valid email regex",
// "feature jquery" => "feature jquery",
// "jquery effect" => "jquery effect",
// "jquery effect direction" => "jquery effect direction",
// "jquery effect speed" => "jquery effect speed",
// "jquery effect tabs" => "jquery effect tabs",
// "jquery effect tabs direction" => "jquery effect tabs direction",
// "jquery effect tabs speed" => "jquery effect tabs speed",
// "feature jquery ui" => "feature jquery ui",
// "feature jquery tooltips" => "feature jquery tooltips",
// "feature jquery autocomplete" => "feature jquery autocomplete",
// "feature jquery superfish" => "feature jquery superfish",
// "feature jquery reflection" => "feature jquery reflection",
// "feature jquery sheet" => "feature jquery sheet",
// "feature jquery tablesorter" => "feature jquery tablesorter",
// "feature jquery cycle" => "feature jquery cycle",
// "feature sefurl" => "feature sefurl",
// "feature sefurl filter" => "feature sefurl filter",
// "feature sefurl paths" => "feature sefurl paths",
// "feature sefurl title article" => "feature sefurl title article",
// "feature sefurl title blog" => "feature sefurl title blog",
// "feature tikitests" => "feature tikitests",
// "feature magic" => "feature magic",
// "profile sources" => "profile sources",
// "profile channels" => "profile channels",
// "feature minichat" => "feature minichat",
// "feature pear date" => "feature pear date",
// "feature bidi" => "feature bidi",
// "feature lastup" => "feature lastup",
// "transition style ver" => "transition style ver",
// "magic last load" => "magic last load",
// "feature groupalert" => "feature groupalert",
// "lib spellcheck" => "lib spellcheck",
// "wiki spellcheck" => "wiki spellcheck",
// "blog spellcheck" => "blog spellcheck",
// "allowMsgs" => "allowMsgs",
// "diff versions" => "diff versions",
// "display timezone" => "display timezone",
// "email is public" => "email is public",
// "homePage" => "homePage",
// "lat" => "lat",
// "lon" => "lon",
// "mess archiveAfter" => "mess archiveAfter",
// "mess maxRecords" => "mess maxRecords",
// "mess sendReadStatus" => "mess sendReadStatus",
// "minPrio" => "minPrio",
// "mytiki blogs" => "mytiki blogs",
// "mytiki articles" => "mytiki articles",
// "mytiki gals" => "mytiki gals",
// "mytiki items" => "mytiki items",
// "mytiki msgs" => "mytiki msgs",
// "mytiki pages" => "mytiki pages",
// "mytiki tasks" => "mytiki tasks",
// "mytiki workflow" => "mytiki workflow",
// "mytiki forum topics" => "mytiki forum topics",
// "mytiki forum replies" => "mytiki forum replies",
// "realName" => "realName",
// "gender" => "gender",
// "show mouseover user info" => "show mouseover user info",
// "tasks maxRecords" => "tasks maxRecords",
// "user dbl" => "user dbl",
// "user information" => "user information",
// "mailCharset" => "mailCharset",
// "Group Monitor" => "Group Monitor",
// "Watched by categories" => "Watched by categories",
// "Select Categories" => "Select Categories",
// "Select/deselect all categories" => "Select/deselect all categories",
// "top of page" => "top of page",
// "Report this post" => "Report this post",
// "Errors" => "Errors",
// "Comments Locked" => "Comments Locked",
// "Comments are locked" => "Comments are locked",
// "Note" => "Note",
// "Post new message" => "Post new message",
// "required" => "required",
// "Maximum size" => "Maximum size",
// "Enter your name" => "Enter your name",
// "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address" => "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address",
// "Please note that the preview does not keep the attached file which you will have to choose before posting" => "Please note that the preview does not keep the attached file which you will have to choose before posting",
// "Post as Anonymous" => "Post as Anonymous",
// "Your comment will have to be approved by the moderator before it is displayed" => "Your comment will have to be approved by the moderator before it is displayed",
// "Type of contribution" => "Type of contribution",
// "Contributors" => "Contributors",
// "Duplicate File Gallery" => "Duplicate File Gallery",
// "Duplicate categories" => "Duplicate categories",
// "Duplicate perms" => "Duplicate perms",
// "View inserted gallery" => "View inserted gallery",
// "Display Properties" => "Display Properties",
// "required field for podcasts" => "required field for podcasts",
// "any file" => "any file",
// "podcast (audio)" => "podcast (audio)",
// "podcast (video)" => "podcast (video)",
// "This Gallery is Public" => "This Gallery is Public",
// "Users with perms and not only the owner of the gallery can upload in it" => "Users with perms and not only the owner of the gallery can upload in it",
// "The files can be locked at download" => "The files can be locked at download",
// "Maximum number of archives for each file" => "Maximum number of archives for each file",
// "Owner of the gallery" => "Owner of the gallery",
// "Group of users alerted when file gallery is modified" => "Group of users alerted when file gallery is modified",
// "Allows to select each user for small groups" => "Allows to select each user for small groups",
// "Perhaps you were looking for" => "Perhaps you were looking for",
// "Go to Login Page" => "Go to Login Page",
// "Go to" => "Go to",
// "Private Gallery" => "Private Gallery",
// "Archives" => "Archives",
// "Upload New Version" => "Upload New Version",
// "Download and lock" => "Download and lock",
// "Show as a column" => "Show as a column",
// "Show in popup box" => "Show in popup box",
// "Both" => "Both",
// "Show an icon in a column" => "Show an icon in a column",
// "any type" => "any type",
// "all topic" => "all topic",
// "any language" => "any language",
// "not in" => "not in",
// "any category" => "any category",
// "Clear Filter" => "Clear Filter",
// "Show php error messages" => "Show php error messages",
// "Folksonomy Tags" => "Folksonomy Tags",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together" => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together",
// "Tags" => "Tags",
// "Translate tags" => "Translate tags",
// "Images Galleries" => "Images Galleries",
// "RSS Calendars" => "RSS Calendars",
// "You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page" => "You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page",
// "Loading" => "Loading",
// "\\074span class=\"shortcut\"\\076C\\074/span\\076lose" => "\\074span class=\"shortcut\"\\076C\\074/span\\076lose",
// "\\074span class=\"shortcut\"\\076N\\074/span\\076ext" => "\\074span class=\"shortcut\"\\076N\\074/span\\076ext",
// "\\074span class=\"shortcut\"\\076P\\074/span\\076revious" => "\\074span class=\"shortcut\"\\076P\\074/span\\076revious",
// "Show Tree" => "Show Tree",
// "Hide Tree" => "Hide Tree",
// "Are you sure you want to delete the selected files" => "Are you sure you want to delete the selected files",
// "Download the zip" => "Download the zip",
// "Other Sorts" => "Other Sorts",
// "No Additionnal Sort" => "No Additionnal Sort",
// "No information" => "No information",
// "To validate your account and login to the site, please click on the following link" => "To validate your account and login to the site, please click on the following link",
// "The administrator approved your account" => "The administrator approved your account",
// "Confirm your email at %s" => "Confirm your email at %s",
// "Contribution" => "Contribution",
// "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now" => "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now",
// "To login with your username and password, please follow this link" => "To login with your username and password, please follow this link",
// "User Account Activated" => "User Account Activated",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "User Tracker" => "User Tracker",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else" => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above" => "Important: The old password remains active if you don't click the link above",
// "Look at this link" => "Look at this link",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}" => "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}",
// "Download the file at" => "Download the file at",
// "Tracker was modified at" => "Tracker was modified at",
// "Please visit this link before login again" => "Please visit this link before login again",
// "Last attempt" => "Last attempt",
// "Confirm your account at %s" => "Confirm your account at %s",
// "An administrator of the site below has added you as a new user" => "An administrator of the site below has added you as a new user",
// "If you want to confirm your membership in this site, click on the following link to login for the first time" => "If you want to confirm your membership in this site, click on the following link to login for the first time",
// "Your authentication credentials are" => "Your authentication credentials are",
// "Welcome on the site" => "Welcome on the site",
// "Your personal access to" => "Your personal access to",
// "You'll receive email notification once your account is activated" => "You'll receive email notification once your account is activated",
// "Please do not attempt to login until you receive the email notification" => "Please do not attempt to login until you receive the email notification",
// "{\$mail_action} article post" => "{\$mail_action} article post",
// "{\$mail_title} by {\$mail_user} at" => "{\$mail_title} by {\$mail_user} at",
// "New article post" => "New article post",
// "Edited article post" => "Edited article post",
// "Deleted article post" => "Deleted article post",
// "{\$mail_action} article post at" => "{\$mail_action} article post at",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}",
// "View item calendar at" => "View item calendar at",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "A new category was created in" => "A new category was created in",
// "A category was removed in" => "A category was removed in",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Updated by" => "Updated by",
// "Old" => "Old",
// "updated" => "updated",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "An object was added to category" => "An object was added to category",
// "Added by" => "Added by",
// "Object type" => "Object type",
// "An object was removed from category" => "An object was removed from category",
// "A page has been added to your watched sub-structure" => "A page has been added to your watched sub-structure",
// "A page has been removed from your watched sub-structure" => "A page has been removed from your watched sub-structure",
// "A page has been promoted out your watched sub-structure" => "A page has been promoted out your watched sub-structure",
// "A page has been demoted to your watched structure" => "A page has been demoted to your watched structure",
// "Structure modified" => "Structure modified",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted but used to be here" => "The page {\$mail_page} was deleted but used to be here",
// "The old page content follows below" => "The old page content follows below",
// "Wiki page %s created by {\$mail_user}" => "Wiki page %s created by {\$mail_user}",
// "Wiki page %s deleted by {\$mail_user}" => "Wiki page %s deleted by {\$mail_user}",
// "Wiki page %s changed by {\$mail_user}" => "Wiki page %s changed by {\$mail_user}",
// "Wiki page %s was commented on by" => "Wiki page %s was commented on by",
// "an anonymous user" => "an anonymous user",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "Thank you for your registration. You may log in now" => "Thank you for your registration. You may log in now",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Zoom out" => "Zoom out",
// "Zoom in" => "Zoom in",
// "from the mapfile" => "from the mapfile",
// "hits last 7 days" => "hits last 7 days",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences" => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences",
// "ERROR" => "ERROR",
// "is reply to" => "is reply to",
// "Toggle module contents" => "Toggle module contents",
// "toggle" => "toggle",
// "\$tpl_module_title" => "\$tpl_module_title",
// "Admin Drawings" => "Admin Drawings",
// "Content Templates" => "Content Templates",
// "External Wikis" => "External Wikis",
// "Tiki Cache/Sys Admin" => "Tiki Cache/Sys Admin",
// "Syntax Highlighting" => "Syntax Highlighting",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number " => "You forgot your Google ad_client number ",
// "\$module_title" => "\$module_title",
// "More.." => "More..",
// "To configure your Tiki" => "To configure your Tiki",
// "Admin Home" => "Admin Home",
// "from the menu" => "from the menu",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "as the Admin" => "as the Admin",
// "The Tikiwiki Community" => "The Tikiwiki Community",
// "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "Last `\$module_rows` blog comments" => "Last `\$module_rows` blog comments",
// "Last blog comments" => "Last blog comments",
// "on blogpost" => "on blogpost",
// "Add event" => "Add event",
// "\$modcattitle" => "\$modcattitle",
// "Current events" => "Current events",
// "Folksonomy" => "Folksonomy",
// "Tags This Page Has" => "Tags This Page Has",
// "Add tags" => "Add tags",
// "More Like This" => "More Like This",
// "Most popular tags" => "Most popular tags",
// "List everything tagged" => "List everything tagged",
// "My prefered tags" => "My prefered tags",
// "\$type" => "\$type",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "more" => "more",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "No avatar" => "No avatar",
// "You" => "You",
// "Logged in as" => "Logged in as",
// "Switch User" => "Switch User",
// "Switch user" => "Switch user",
// "Login through Shibboleth" => "Login through Shibboleth",
// "Login as" => "Login as",
// "CapsLock is on" => "CapsLock is on",
// "local account" => "local account",
// "OpenID Login" => "OpenID Login",
// "What is OpenID" => "What is OpenID",
// "Send a message" => "Send a message",
// "Random Images" => "Random Images",
// "RSS Feeds" => "RSS Feeds",
// "Calendars" => "Calendars",
// "A leading plus sign indicates that this word must be present in every object returned" => "A leading plus sign indicates that this word must be present in every object returned",
// "A leading minus sign indicates that this word must not be present in any row returned" => "A leading minus sign indicates that this word must not be present in any row returned",
// "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher" => "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher",
// "These two operators are used to change a word's contribution to the relevance value that is assigned to a row" => "These two operators are used to change a word's contribution to the relevance value that is assigned to a row",
// "Parentheses are used to group words into subexpressions" => "Parentheses are used to group words into subexpressions",
// "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator" => "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator",
// "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended" => "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended",
// "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed" => "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed",
// "Advanced search" => "Advanced search",
// "Advanced Search Help" => "Advanced Search Help",
// "Page Relations" => "Page Relations",
// "Are you sure you want to delete this shout" => "Are you sure you want to delete this shout",
// "Delete this shout" => "Delete this shout",
// "Edit this shout" => "Edit this shout",
// "New Tracker Items" => "New Tracker Items",
// "New Calendar Events" => "New Calendar Events",
// "Nothing has changed" => "Nothing has changed",
// "`\$module_params.prefix`" => "`\$module_params.prefix`",
// "Site Language" => "Site Language",
// "Site default" => "Site default",
// "TikiTests Menu" => "TikiTests Menu",
// "List Tests" => "List Tests",
// "Create Test" => "Create Test",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Page translation" => "Page translation",
// "There are no translations of this page" => "There are no translations of this page",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "None match your" => "None match your",
// "Set your preferred languages" => "Set your preferred languages",
// "preferred languages" => "preferred languages",
// "Equivalent translations" => "Equivalent translations",
// "Translations that need improvement" => "Translations that need improvement",
// "update it" => "update it",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "The Next Event" => "The Next Event",
// "No Upcoming Events" => "No Upcoming Events",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "on host" => "on host",
// "Videos on YouTube" => "Videos on YouTube",
// "More Videos" => "More Videos",
// "Changes that need to be reproduced are highlighted below" => "Changes that need to be reproduced are highlighted below",
// "Insert/Edit an internal wiki link" => "Insert/Edit an internal wiki link",
// "Wiki Link insert" => "Wiki Link insert",
// "Please make a selection of text in order to create a link" => "Please make a selection of text in order to create a link",
// "Insert an image" => "Insert an image",
// "Tiki Image - Insert an image" => "Tiki Image - Insert an image",
// "By" => "By",
// "Read more" => "Read more",
// "Do not group by item" => "Do not group by item",
// "Group by item" => "Group by item",
// "Tiki Action Calendar" => "Tiki Action Calendar",
// "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones" => "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones",
// "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users" => "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users",
// "Profiles" => "Profiles",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Look &amp; Feel" => "Look &amp; Feel",
// "i18n" => "i18n",
// "Editing and Plugins" => "Editing and Plugins",
// "Text area" => "Text area",
// "Freetags" => "Freetags",
// "Multimedia" => "Multimedia",
// "Intertiki" => "Intertiki",
// "InterTiki" => "InterTiki",
// "Semantic wiki links" => "Semantic wiki links",
// "Semantic links" => "Semantic links",
// "Webservices" => "Webservices",
// "Sef URL" => "Sef URL",
// "Blogs Listing" => "Blogs Listing",
// "Create a blog" => "Create a blog",
// "Spell checking" => "Spell checking",
// "Requires a separate download" => "Requires a separate download",
// "Custom blog headings" => "Custom blog headings",
// "Blog-level" => "Blog-level",
// "Post-level" => "Post-level",
// "Default number per page" => "Default number per page",
// "Default ordering" => "Default ordering",
// "Blogs Listings" => "Blogs Listings",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Select which items to display when listing blogs" => "Select which items to display when listing blogs",
// "Title length" => "Title length",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "General settings" => "General settings",
// "Default calendars to display" => "Default calendars to display",
// "All calendars" => "All calendars",
// "A subset of available calendars" => "A subset of available calendars",
// "Create calendar" => "Create calendar",
// "Default view mode" => "Default view mode",
// "View list begins" => "View list begins",
// "Focus Date" => "Focus Date",
// "Period beginning" => "Period beginning",
// "First day of the week" => "First day of the week",
// "Split hours in periods of" => "Split hours in periods of",
// "1 minute" => "1 minute",
// "10 minutes" => "10 minutes",
// "Manual selection of time/date" => "Manual selection of time/date",
// "JS calendar" => "JS calendar",
// "Year selection is valid when the JS Calendar <strong>is not</strong> enabled" => "Year selection is valid when the JS Calendar <strong>is not</strong> enabled",
// "First year in the dropdown" => "First year in the dropdown",
// "Enter a year or use +/- N to specify a year relative to the current\n\tyear" => "Enter a year or use +/- N to specify a year relative to the current\n\tyear",
// "Last year in the dropdown" => "Last year in the dropdown",
// "Group calendars" => "Group calendars",
// "Sticky popup" => "Sticky popup",
// "Item view tab" => "Item view tab",
// "Browse categories" => "Browse categories",
// "Administer categories" => "Administer categories",
// "Category path" => "Category path",
// "Exclude these categories" => "Exclude these categories",
// "Separate category IDs with a comma (,)" => "Separate category IDs with a comma (,)",
// "Show category objects" => "Show category objects",
// "Use PHPLayers for category browser" => "Use PHPLayers for category browser",
// "PHPLayers is disabled" => "PHPLayers is disabled",
// "Enable now" => "Enable now",
// "Categories used in templates (TPL)" => "Categories used in templates (TPL)",
// "Will improve performance, but may show forbidden results" => "Will improve performance, but may show forbidden results",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Admin topics" => "Admin topics",
// "Admin types" => "Admin types",
// "Articles Listing" => "Articles Listing",
// "Title of articles home page" => "Title of articles home page",
// "Maximum number of articles on articles home page" => "Maximum number of articles on articles home page",
// "Article properties" => "Article properties",
// "Give only one value (width or height) to keep the image proportions" => "Give only one value (width or height) to keep the image proportions",
// "Specify notification emails when creating articles" => "Specify notification emails when creating articles",
// "Default article image width" => "Default article image width",
// "Default article image height" => "Default article image height",
// "Batch upload (CSV file)" => "Batch upload (CSV file)",
// "File format: title,authorName,heading,body,lang,user" => "File format: title,authorName,heading,body,lang,user",
// "Select which items to display when listing articles" => "Select which items to display when listing articles",
// "Publication date" => "Publication date",
// "Expiration date" => "Expiration date",
// "Users Listing" => "Users Listing",
// "Users can choose to show their gender" => "Users can choose to show their gender",
// "Requires User Preferences feature" => "Requires User Preferences feature",
// "Show user's information on mouseover" => "Show user's information on mouseover",
// "Requires user's information to be public" => "Requires user's information to be public",
// "Real name" => "Real name",
// "Feature is disabled" => "Feature is disabled",
// "Default user preferences" => "Default user preferences",
// "Users Default Preferences" => "Users Default Preferences",
// "Character set for mail" => "Character set for mail",
// "Detect user timezone if browser allows, otherwise site default" => "Detect user timezone if browser allows, otherwise site default",
// "User messages" => "User messages",
// "Notify sender when reading mail" => "Notify sender when reading mail",
// "My forum topics" => "My forum topics",
// "My forum replies" => "My forum replies",
// "Select which items to display when listing users" => "Select which items to display when listing users",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "License page" => "License page",
// "Submit notice" => "Submit notice",
// "Enable copyright management for" => "Enable copyright management for",
// "Show Country Flag" => "Show Country Flag",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site",
// "No tabs" => "No tabs",
// "Apply" => "Apply",
// "Reset" => "Reset",
// "Main" => "Main",
// "Global Features" => "Global Features",
// "More Functionality" => "More Functionality",
// "UI Enhancements" => "UI Enhancements",
// "Experimental" => "Experimental",
// "Programmer" => "Programmer",
// "Main Features" => "Main Features",
// "Site Global Features" => "Site Global Features",
// "Action Log" => "Action Log",
// "Action log setting" => "Action log setting",
// "Internationalization" => "Internationalization",
// "Additional Features" => "Additional Features",
// "Copyright System" => "Copyright System",
// "Copyright system" => "Copyright system",
// "Tell a Friend" => "Tell a Friend",
// "HTML pages" => "HTML pages",
// "Minichat" => "Minichat",
// "Comments Moderation" => "Comments Moderation",
// "Comments Locking" => "Comments Locking",
// "User interface enhancement features" => "User interface enhancement features",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "Fullscreen" => "Fullscreen",
// "Allow users to activate fullscreen mode" => "Allow users to activate fullscreen mode",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
// "Mootools or JQuery" => "Mootools or JQuery",
// "Mootools" => "Mootools",
// "Floating help aka the Big Blue Help Icon" => "Floating help aka the Big Blue Help Icon",
// "Experimental Features" => "Experimental Features",
// "Seem ok" => "Seem ok",
// "Features that may change or might be re-worked in the future" => "Features that may change or might be re-worked in the future",
// "Ajax" => "Ajax",
// "HTML Purifier" => "HTML Purifier",
// "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)" => "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)",
// "JQuery: JavaScript UI effects" => "JQuery: JavaScript UI effects",
// "Mobile" => "Mobile",
// "Morcego 3D browser" => "Morcego 3D browser",
// "Need polish" => "Need polish",
// "Features that need admin help and user patience to work well" => "Features that need admin help and user patience to work well",
// "Mindmap" => "Mindmap",
// "Print Indexed" => "Print Indexed",
// "SEFURL" => "SEFURL",
// "Search engine friendly url" => "Search engine friendly url",
// "Spreadsheet" => "Spreadsheet",
// "Ajax auto-save" => "Ajax auto-save",
// "Malfunctioning" => "Malfunctioning",
// "These features have critical faults - not recommended" => "These features have critical faults - not recommended",
// "Magic Admin Panel" => "Magic Admin Panel",
// "Neglected" => "Neglected",
// "Old features no longer maintained" => "Old features no longer maintained",
// "Friendship" => "Friendship",
// "SWFObject" => "SWFObject",
// "SwfObject" => "SwfObject",
// "Used to embed Flash content in wiki pages, banners etc" => "Used to embed Flash content in wiki pages, banners etc",
// "Action Calendar" => "Action Calendar",
// "Tiki action calendar" => "Tiki action calendar",
// "Redirect On Error" => "Redirect On Error",
// "Display 'MyTiki' in the application menu" => "Display 'MyTiki' in the application menu",
// "User Contacts" => "User Contacts",
// "Group Watches" => "Group Watches",
// "User Levels" => "User Levels",
// "Group Alert" => "Group Alert",
// "Programmer Features" => "Programmer Features",
// "TikiTests" => "TikiTests",
// "requires PHP5 or more" => "requires PHP5 or more",
// "Use Minified Scripts" => "Use Minified Scripts",
// "To create or remove file galleries, select" => "To create or remove file galleries, select",
// "from the application menu" => "from the application menu",
// "Gallery Listing" => "Gallery Listing",
// "Search Indexing" => "Search Indexing",
// "Create a Gallery" => "Create a Gallery",
// "Store in database" => "Store in database",
// "Store in directory" => "Store in directory",
// "The server must be able to read/write the directory" => "The server must be able to read/write the directory",
// "The directory can be outside the web space" => "The directory can be outside the web space",
// "Podcast directory" => "Podcast directory",
// "Required for podcasts" => "Required for podcasts",
// "Default Ordering" => "Default Ordering",
// "Allow download limit per file" => "Allow download limit per file",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "Score is disabled" => "Score is disabled",
// "Yes, even in the same gallery" => "Yes, even in the same gallery",
// "Only in different galleries" => "Only in different galleries",
// "Batch uploading" => "Batch uploading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "The server must be able to read the directory" => "The server must be able to read the directory",
// "Require file author's name for anonymous uploads" => "Require file author's name for anonymous uploads",
// "Upload Regex" => "Upload Regex",
// "Must match" => "Must match",
// "Cannot match" => "Cannot match",
// "Gallery Listings" => "Gallery Listings",
// "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries" => "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries",
// "Select which items to display when listing galleries: " => "Select which items to display when listing galleries: ",
// "Automatically index files on upload or change" => "Automatically index files on upload or change",
// "Handlers" => "Handlers",
// "Add custom handlers to make your files &quot;searchable&quot; content" => "Add custom handlers to make your files &quot;searchable&quot; content",
// "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command" => "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command",
// "To delete a handler, leave the <strong>System Command</strong> field blank" => "To delete a handler, leave the <strong>System Command</strong> field blank",
// "System Command" => "System Command",
// "Forums Listing" => "Forums Listing",
// "Create a forum" => "Create a forum",
// "Topic archiving" => "Topic archiving",
// "Quick jumps" => "Quick jumps",
// "Replies are empty" => "Replies are empty",
// "If disabled, replies will quote the original post" => "If disabled, replies will quote the original post",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "First post of a thread can have an empty body" => "First post of a thread can have an empty body",
// "Will be a thread title" => "Will be a thread title",
// "Threads" => "Threads",
// "Manage thread defaults per-forum" => "Manage thread defaults per-forum",
// "Display thread configuration bar" => "Display thread configuration bar",
// "Allows users to override the defaults" => "Allows users to override the defaults",
// "Keep settings for all forums during the user session" => "Keep settings for all forums during the user session",
// "Default style" => "Default style",
// "Default sort mode" => "Default sort mode",
// "Forum name search" => "Forum name search",
// "When listing forums" => "When listing forums",
// "Forum content search" => "Forum content search",
// "Topic content search" => "Topic content search",
// "Search is disabled" => "Search is disabled",
// "Use Tiki (database-independent) search" => "Use Tiki (database-independent) search",
// "Use database (full-text) search" => "Use database (full-text) search",
// "Select which items to display when listing forums" => "Select which items to display when listing forums",
// "Description length" => "Description length",
// "3D Tag Browser" => "3D Tag Browser",
// "Show tag cloud" => "Show tag cloud",
// "Maximum number of tags in cloud" => "Maximum number of tags in cloud",
// "Show freetags in middle column" => "Show freetags in middle column",
// "Preload freetag random tag" => "Preload freetag random tag",
// "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>" => "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>",
// "Random tag cloud colors" => "Random tag cloud colors",
// "Separate colors with a comma (,)" => "Separate colors with a comma (,)",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Alphanumeric ASCII characters only" => "Alphanumeric ASCII characters only",
// "No accents or special characters" => "No accents or special characters",
// "Accept all charactrs" => "Accept all charactrs",
// "Lowercase tags only" => "Lowercase tags only",
// "Multilingual freetags" => "Multilingual freetags",
// "Multiligual disabled" => "Multiligual disabled",
// "&quot;More Like This&quot; algorithm" => "&quot;More Like This&quot; algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Minimum amount of tags in common" => "Minimum amount of tags in common",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "Morcego 3D browser disabled" => "Morcego 3D browser disabled",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Graph appearance" => "Graph appearance",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Spring (connection) size" => "Spring (connection) size",
// "Node color" => "Node color",
// "Camera settinsg" => "Camera settinsg",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Camera distance" => "Camera distance",
// "Field of view" => "Field of view",
// "Physics engine" => "Physics engine",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below" => "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Pixels Default" => "Pixels Default",
// "Default scale size" => "Default scale size",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Admin Password" => "Admin Password",
// "Release Check" => "Release Check",
// "Reset or upgrade your database" => "Reset or upgrade your database",
// "Check for updates automatically" => "Check for updates automatically",
// "Check frequency" => "Check frequency",
// "TikiWiki will check for updates when you access the main Administration page" => "TikiWiki will check for updates when you access the main Administration page",
// "Check for updates now" => "Check for updates now",
// "Sender email" => "Sender email",
// "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look &amp; Feel</strong></a> section for additional site related customization preferences" => "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look &amp; Feel</strong></a> section for additional site related customization preferences",
// "Use TikiWiki feature as homepage" => "Use TikiWiki feature as homepage",
// "Use different URL as home page" => "Use different URL as home page",
// "Miscellaneous" => "Miscellaneous",
// "Server OS" => "Server OS",
// "Smarty Security" => "Smarty Security",
// "Do not allow php code in smarty templates" => "Do not allow php code in smarty templates",
// "Use PEAR::Date library" => "Use PEAR::Date library",
// "Default charset for sending mail" => "Default charset for sending mail",
// "Mail end of line" => "Mail end of line",
// "Logging and Reporting" => "Logging and Reporting",
// "PHP error reporting level" => "PHP error reporting level",
// "Report all PHP errors except strict" => "Report all PHP errors except strict",
// "Visible to Admin only" => "Visible to Admin only",
// "Include Smarty notices" => "Include Smarty notices",
// "Log mail in Tiki logs" => "Log mail in Tiki logs",
// "Log SQL" => "Log SQL",
// "Log queries using more than" => "Log queries using more than",
// "This may impact performance" => "This may impact performance",
// "Add HTML comment at start and end of each Smarty template (TPL)" => "Add HTML comment at start and end of each Smarty template (TPL)",
// "CSRF Security" => "CSRF Security",
// "Use these options to protect against cross-site request forgeries (CSRF)" => "Use these options to protect against cross-site request forgeries (CSRF)",
// "Require confirmation if possible CSRF detected" => "Require confirmation if possible CSRF detected",
// "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings" => "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings",
// "Site Access" => "Site Access",
// "Close site (except for those with permission)" => "Close site (except for those with permission)",
// "Message to display" => "Message to display",
// "Close site when server load is above the threshold  (except for those with permission)" => "Close site when server load is above the threshold  (except for those with permission)",
// "Maximum average server load threshold in the last minute" => "Maximum average server load threshold in the last minute",
// "Host" => "Host",
// "On permission denied, display login module (for Anonymous)" => "On permission denied, display login module (for Anonymous)",
// "Send to URL" => "Send to URL",
// "Performance" => "Performance",
// "Cache external pages" => "Cache external pages",
// "Cache external images" => "Cache external images",
// "GZip output" => "GZip output",
// "Output compression is active" => "Output compression is active",
// "Compression is handled by" => "Compression is handled by",
// "Session" => "Session",
// "Advanced configuration warning" => "Advanced configuration warning",
// "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects" => "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects",
// "Enabling this feature will immediately log you out when you save this preference" => "Enabling this feature will immediately log you out when you save this preference",
// "Session lifetime" => "Session lifetime",
// "Contact" => "Contact",
// "The \"Contact Us\" feature is disabled" => "The \"Contact Us\" feature is disabled",
// "Allow anonymous visitors to use the \"Contact Us\"" => "Allow anonymous visitors to use the \"Contact Us\"",
// "The default help system may not be complete" => "The default help system may not be complete",
// "You can help with the TikiWiki documentation" => "You can help with the TikiWiki documentation",
// "Show user's real name instead of login (when possible)" => "Show user's real name instead of login (when possible)",
// "Highlight group" => "Highlight group",
// "Show user's contribution on the user information page" => "Show user's contribution on the user information page",
// "Display UserTracker information on the user information page" => "Display UserTracker information on the user information page",
// "Use the format: trackerId, fieldId1, fieldId2, .." => "Use the format: trackerId, fieldId1, fieldId2, ..",
// "Separators" => "Separators",
// "Locations (breadcrumbs)" => "Locations (breadcrumbs)",
// "Examples" => "Examples",
// "Choices" => "Choices",
// "Default timezone" => "Default timezone",
// "Use site default to show times" => "Use site default to show times",
// "Detect user timezone (if browser allows). Otherwise use site default" => "Detect user timezone (if browser allows). Otherwise use site default",
// "Sample" => "Sample",
// "Fields display order" => "Fields display order",
// "Change the <strong>Admin</strong> password" => "Change the <strong>Admin</strong> password",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at " => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at ",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Babelfish links" => "Babelfish links",
// "Customized String Translation" => "Customized String Translation",
// "Default language" => "Default language",
// "Show pages in user's preferred language" => "Show pages in user's preferred language",
// "User preferences are disabled" => "User preferences are disabled",
// "Users can change site language" => "Users can change site language",
// "Restrict supported languages" => "Restrict supported languages",
// "Available languages" => "Available languages",
// "Use Ctrl+Click to select multiple languages" => "Use Ctrl+Click to select multiple languages",
// "Display available translations" => "Display available translations",
// "Changing page language will also change the site language" => "Changing page language will also change the site language",
// "Translation assistant" => "Translation assistant",
// "Urgent translation notifications" => "Urgent translation notifications",
// "Quantify change size" => "Quantify change size",
// "Multilingual structures" => "Multilingual structures",
// "Structures are disabled" => "Structures are disabled",
// "Multilingual One Page feature" => "Multilingual One Page feature",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// "as master" => "as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "Look and Feel" => "Look and Feel",
// "Text Area" => "Text Area",
// "Wysiwyg" => "Wysiwyg",
// "Semantic" => "Semantic",
// "Webservices management" => "Webservices management",
// "CAS" => "CAS",
// "Tiki" => "Tiki",
// "Tiki and OpenID" => "Tiki and OpenID",
// "Validate by email" => "Validate by email",
// "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>",
// "Validate user's email server" => "Validate user's email server",
// "Require validation by Admin" => "Require validation by Admin",
// "Require passcode to register" => "Require passcode to register",
// "Passcode" => "Passcode",
// "Users must enter this code to register" => "Users must enter this code to register",
// "Use CAPTCHA to prevent automatic/robot registrations" => "Use CAPTCHA to prevent automatic/robot registrations",
// "Requires PHP GD library" => "Requires PHP GD library",
// "Include &quot;Generate Password&quot; option on registration form" => "Include &quot;Generate Password&quot; option on registration form",
// "Use tracker to collect more user information" => "Use tracker to collect more user information",
// "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display" => "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display",
// "Use tracker to collect more group information" => "Use tracker to collect more group information",
// "Users can select a group to join at registration" => "Users can select a group to join at registration",
// "By default, new users automatically join the Registered group" => "By default, new users automatically join the Registered group",
// "Re-validate user by email after" => "Re-validate user by email after",
// "Use <strong>-1</strong> for never" => "Use <strong>-1</strong> for never",
// "unsuccessful login attempts" => "unsuccessful login attempts",
// "Create a new group for each user" => "Create a new group for each user",
// "The group will be named identical to the user's username" => "The group will be named identical to the user's username",
// "Disable browser's autocomplete feature for username and password fields" => "Disable browser's autocomplete feature for username and password fields",
// "Confirm that the Admin account has a valid email address or you will not be permitted to login" => "Confirm that the Admin account has a valid email address or you will not be permitted to login",
// "Use HTTPS login" => "Use HTTPS login",
// "Users can choose to stay in SSL mode after an HTTPS login" => "Users can choose to stay in SSL mode after an HTTPS login",
// "Users can switch between secured or standard mode at login" => "Users can switch between secured or standard mode at login",
// "User's choice" => "User's choice",
// "Always" => "Always",
// "Cookie name" => "Cookie name",
// "Use email as username" => "Use email as username",
// "Minimum length" => "Minimum length",
// "Maximum length" => "Maximum length",
// "Force lowercase" => "Force lowercase",
// "Username pattern" => "Username pattern",
// "Store password as plain text" => "Store password as plain text",
// "Store passwords in plain text is activated. You should never set this unless you know what you are doing" => "Store passwords in plain text is activated. You should never set this unless you know what you are doing",
// "Remind/forgot password" => "Remind/forgot password",
// "If passwords </em>are stored<em> as plain text, the password will be emailed to the user" => "If passwords </em>are stored<em> as plain text, the password will be emailed to the user",
// "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user" => "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user",
// "Encryption method" => "Encryption method",
// "Users can change their password" => "Users can change their password",
// "Require characters and numerals" => "Require characters and numerals",
// "Password expires after" => "Password expires after",
// "You must change the Authentication Method to PEAR::Auth for these changes to take effect" => "You must change the Authentication Method to PEAR::Auth for these changes to take effect",
// "Create user if not in Tiki" => "Create user if not in Tiki",
// "Create user if not in Auth" => "Create user if not in Auth",
// "Use Tiki authentication for Admin login" => "Use Tiki authentication for Admin login",
// "Will override the Host and Port settings" => "Will override the Host and Port settings",
// "Search scope" => "Search scope",
// "Subtree" => "Subtree",
// "One level" => "One level",
// "Base object" => "Base object",
// "LDAP version" => "LDAP version",
// "Realname attribute" => "Realname attribute",
// "Country attribute" => "Country attribute",
// "E-mail attribute" => "E-mail attribute",
// "Base DN" => "Base DN",
// "LDAP User" => "LDAP User",
// "User DN" => "User DN",
// "User attribute" => "User attribute",
// "User OC" => "User OC",
// "LDAP Group" => "LDAP Group",
// "Group DN" => "Group DN",
// "Group attribute" => "Group attribute",
// "Group OC" => "Group OC",
// "LDAP Member" => "LDAP Member",
// "Member attribute" => "Member attribute",
// "Member is DN" => "Member is DN",
// "LDAP Admin" => "LDAP Admin",
// "Admin user" => "Admin user",
// "Admin password" => "Admin password",
// "You must change the Authentication Method to PAM for these changes to take effect" => "You must change the Authentication Method to PAM for these changes to take effect",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
// "You must change the Authentication Method to Shibboleth for these changes to take effect" => "You must change the Authentication Method to Shibboleth for these changes to take effect",
// "Valid affiliations" => "Valid affiliations",
// "Separate multiple affiliations with commas" => "Separate multiple affiliations with commas",
// "Create with default group" => "Create with default group",
// "Default group" => "Default group",
// "You must change the Authentication Method to CAS for these changes to take effect" => "You must change the Authentication Method to CAS for these changes to take effect",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/" => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/",
// "CAS Server" => "CAS Server",
// "Hostname" => "Hostname",
// "You must enable PHP CAS first" => "You must enable PHP CAS first",
// "General Layout" => "General Layout",
// "UI Effects" => "UI Effects",
// "The \"users can change theme\" feature will override the theme displayed" => "The \"users can change theme\" feature will override the theme displayed",
// "Theme not saved yet - click \"Apply\"" => "Theme not saved yet - click \"Apply\"",
// "Theme options" => "Theme options",
// "Each group can have its theme" => "Each group can have its theme",
// "Use transition style sheet from version" => "Use transition style sheet from version",
// "View Templates" => "View Templates",
// "Shadow layer" => "Shadow layer",
// "Enable additional general layout layers for shadows, rounded corners or other decorative styling" => "Enable additional general layout layers for shadows, rounded corners or other decorative styling",
// "Main shadow start" => "Main shadow start",
// "Main shadow end" => "Main shadow end",
// "Header shadow start" => "Header shadow start",
// "Header shadow end" => "Header shadow end",
// "Middle shadow start" => "Middle shadow start",
// "Middle shadow end" => "Middle shadow end",
// "Center shadow start" => "Center shadow start",
// "Center shadow end" => "Center shadow end",
// "Footer shadow start" => "Footer shadow start",
// "Footer shadow end" => "Footer shadow end",
// "Custom Site Header" => "Custom Site Header",
// "Activate will only show content for admin. Check Publish to use content for all users" => "Activate will only show content for admin. Check Publish to use content for all users",
// "Site Logo and Title" => "Site Logo and Title",
// "Site logo source (image path)" => "Site logo source (image path)",
// "Site logo background style" => "Site logo background style",
// "Site logo alignment" => "Site logo alignment",
// "Site title" => "Site title",
// "Site subtitle" => "Site subtitle",
// "Site Search Bar" => "Site Search Bar",
// "Site Login Bar" => "Site Login Bar",
// "Top Bar" => "Top Bar",
// "Note: Needs feature PHPLayers on(default), or feature CSS Menu on  " => "Note: Needs feature PHPLayers on(default), or feature CSS Menu on  ",
// "Menu ID" => "Menu ID",
// "Prefix breadcrumbs with 'Location : '" => "Prefix breadcrumbs with 'Location : '",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Left blank to use the default sender email" => "Left blank to use the default sender email",
// "Email this page" => "Email this page",
// "Custom Site Footer" => "Custom Site Footer",
// "Custom End of <body> Code" => "Custom End of <body> Code",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "Bottom bar (RSS)" => "Bottom bar (RSS)",
// "Power by" => "Power by",
// "Pagination links" => "Pagination links",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Max. number of links around the current item" => "Max. number of links around the current item",
// "Max. number of links after the first or before the last item" => "Max. number of links after the first or before the last item",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Hide pagination when there is only one page" => "Hide pagination when there is only one page",
// "Use Icons" => "Use Icons",
// "JQuery plugins and add-ons" => "JQuery plugins and add-ons",
// "Requires jquery feature" => "Requires jquery feature",
// "JQuery Tooltips" => "JQuery Tooltips",
// "JQuery Tooltips: Customisable help tips" => "JQuery Tooltips: Customisable help tips",
// "JQuery Autocomplete" => "JQuery Autocomplete",
// "JQuery Superfish" => "JQuery Superfish",
// "JQuery Superfish (effects on CSS menus)" => "JQuery Superfish (effects on CSS menus)",
// "JQuery Reflection" => "JQuery Reflection",
// "JQuery Reflection (reflection effect on images)" => "JQuery Reflection (reflection effect on images)",
// "JQuery Cycle (slideshow)" => "JQuery Cycle (slideshow)",
// "For future use" => "For future use",
// "JQuery UI" => "JQuery UI",
// "JQuery UI: More JQuery functionality" => "JQuery UI: More JQuery functionality",
// "JQuery Sheet" => "JQuery Sheet",
// "JQuery Spreadsheet" => "JQuery Spreadsheet",
// "JQuery Sortable Tables" => "JQuery Sortable Tables",
// "Standard UI effects" => "Standard UI effects",
// "Effect for modules etc" => "Effect for modules etc",
// "Main JQuery effect" => "Main JQuery effect",
// "Slide" => "Slide",
// "Blind (UI)" => "Blind (UI)",
// "Clip (UI)" => "Clip (UI)",
// "Drop (UI)" => "Drop (UI)",
// "Explode (UI)" => "Explode (UI)",
// "Fold (UI)" => "Fold (UI)",
// "Puff (UI)" => "Puff (UI)",
// "Slide (UI)" => "Slide (UI)",
// "Effect speed" => "Effect speed",
// "Fast" => "Fast",
// "Slow" => "Slow",
// "Effect direction" => "Effect direction",
// "Vertical" => "Vertical",
// "Horizontal" => "Horizontal",
// "Tab UI effects" => "Tab UI effects",
// "Effect for tabs" => "Effect for tabs",
// "JQuery effect for tabs" => "JQuery effect for tabs",
// "Effect speed for tabs" => "Effect speed for tabs",
// "Effect direction for tabs" => "Effect direction for tabs",
// "Other options" => "Other options",
// "Correct PNG images alpha transparency in IE6 (experimental)" => "Correct PNG images alpha transparency in IE6 (experimental)",
// "List of CSS selectors to be fixed, each selector separated by comma" => "List of CSS selectors to be fixed, each selector separated by comma",
// "List of HTMLDomElements to be fixed, each element separated by comma" => "List of HTMLDomElements to be fixed, each element separated by comma",
// "Context Menus (only in file galleries so far)" => "Context Menus (only in file galleries so far)",
// "Use context menus for actions (icons)" => "Use context menus for actions (icons)",
// "Use context menus for actions (text)" => "Use context menus for actions (text)",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Change Preferences" => "Change Preferences",
// "Meta tags" => "Meta tags",
// "Keywords" => "Keywords",
// "Include freetags" => "Include freetags",
// "Use thread title instead" => "Use thread title instead",
// "Use image title instead" => "Use image title instead",
// "Geo URL" => "Geo URL",
// "Meta robots" => "Meta robots",
// "Revisit after" => "Revisit after",
// "&quot;Modules&quot; are the boxes of content in the right &amp; left columns" => "&quot;Modules&quot; are the boxes of content in the right &amp; left columns",
// "Admin &gt; Modules" => "Admin &gt; Modules",
// "from the menu to create and edit modules" => "from the menu to create and edit modules",
// "Show module controls" => "Show module controls",
// "Users can configure modules" => "Users can configure modules",
// "Users can shade modules" => "Users can shade modules",
// "Module decides" => "Module decides",
// "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item" => "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Length" => "Flash Length",
// "Flash Heigth" => "Flash Heigth",
// "Video Length" => "Video Length",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "Anonymous voting" => "Anonymous voting",
// "Allow re-voting" => "Allow re-voting",
// "Show categories" => "Show categories",
// "Categories disabled" => "Categories disabled",
// "Show objects" => "Show objects",
// "Are you sure you want to install the profile" => "Are you sure you want to install the profile",
// "TikiWiki Profiles" => "TikiWiki Profiles",
// "Profile repository" => "Profile repository",
// "Filter the list of profiles" => "Filter the list of profiles",
// "Profile" => "Profile",
// "Repository" => "Repository",
// "installed" => "installed",
// "Repositories" => "Repositories",
// "Repository URLs" => "Repository URLs",
// "Enter multiple repository URLs, one per line" => "Enter multiple repository URLs, one per line",
// "Data Channels" => "Data Channels",
// "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. " => "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. ",
// "More information" => "More information",
// "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS Modules</strong> menu option, or" => "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS Modules</strong> menu option, or",
// "Feed for articles" => "Feed for articles",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Show Author" => "Show Author",
// "Homepage URL" => "Homepage URL",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Feed for image galleries" => "Feed for image galleries",
// "Individual image galleries" => "Individual image galleries",
// "Feed for file galleries" => "Feed for file galleries",
// "Individual file galleries" => "Individual file galleries",
// "Feed for wiki" => "Feed for wiki",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "Calendar events" => "Calendar events",
// "Feed for directory" => "Feed for directory",
// "Map files" => "Map files",
// "Feed for maps" => "Feed for maps",
// "Defaults" => "Defaults",
// "Image Path" => "Image Path",
// "Caching time" => "Caching time",
// "Use <strong>0</strong> for no caching" => "Use <strong>0</strong> for no caching",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public" => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public",
// "can be seen on page" => "can be seen on page",
// "in Admin menu" => "in Admin menu",
// "Search Results" => "Search Results",
// "Search type" => "Search type",
// "Database search" => "Database search",
// "This search uses the MySQL Full-Text feature" => "This search uses the MySQL Full-Text feature",
// "Tiki search" => "Tiki search",
// "This database-independent search is always enabled" => "This database-independent search is always enabled",
// "Specify the Tiki search settings" => "Specify the Tiki search settings",
// "Refresh mode" => "Refresh mode",
// "Use <strong>0</strong> for no refresh" => "Use <strong>0</strong> for no refresh",
// "When the Database search is enabled, you must manually refresh the Tiki search indexes" => "When the Database search is enabled, you must manually refresh the Tiki search indexes",
// "Refresh all search index now" => "Refresh all search index now",
// "Refresh wiki search index now" => "Refresh wiki search index now",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "Parse the results" => "Parse the results",
// "May impact performance" => "May impact performance",
// "Enabling these options will improve performance, but may show forbidden results" => "Enabling these options will improve performance, but may show forbidden results",
// "Select the items to display on the search results page" => "Select the items to display on the search results page",
// "Object filter" => "Object filter",
// "Search box" => "Search box",
// "Select the information to display for each result" => "Select the information to display for each result",
// "Pertinence" => "Pertinence",
// "Last modified date" => "Last modified date",
// "Search engine friendly url Postfilter" => "Search engine friendly url Postfilter",
// "List of Url Parameters that should go in the path" => "List of Url Parameters that should go in the path",
// "Display article title in the sefurl" => "Display article title in the sefurl",
// "Display blog title in the sefurl" => "Display blog title in the sefurl",
// "Known Types" => "Known Types",
// "Token" => "Token",
// "Invert" => "Invert",
// "Show Usage" => "Show Usage",
// "Delete &amp; Unreference" => "Delete &amp; Unreference",
// "Invert Relation" => "Invert Relation",
// "Self" => "Self",
// "New Types" => "New Types",
// "Fix" => "Fix",
// "No occurences found" => "No occurences found",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "Plugins" => "Plugins",
// "Plugin Aliases" => "Plugin Aliases",
// "Anonymous editors must enter anti-bot code (CAPTCHA)" => "Anonymous editors must enter anti-bot code (CAPTCHA)",
// "Protect email against spam" => "Protect email against spam",
// "External link icon" => "External link icon",
// "External links will be identified with" => "External links will be identified with",
// "Use File Galleries to store pictures " => "Use File Galleries to store pictures ",
// "Allow to post comments as Anonymous" => "Allow to post comments as Anonymous",
// "Wiki paragraph formatting" => "Wiki paragraph formatting",
// "...but still create line breaks within paragraphs" => "...but still create line breaks within paragraphs",
// "&lt;return&gt; for rows" => "&lt;return&gt; for rows",
// "Show quicktags above textareas" => "Show quicktags above textareas",
// "If disabled, quicktags will be shown to the left of textareas" => "If disabled, quicktags will be shown to the left of textareas",
// "Open Hotwords in new window" => "Open Hotwords in new window",
// "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting",
// "Plugin disabled" => "Plugin disabled",
// "Default size" => "Default size",
// "Comments " => "Comments ",
// "Forum reply" => "Forum reply",
// "About plugins" => "About plugins",
// "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below" => "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below",
// "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>" => "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>",
// "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below" => "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below",
// "Edit plugin icons" => "Edit plugin icons",
// "Enable edit plugin icons" => "Enable edit plugin icons",
// "(experimental - not comprehensively tested and requires new JQuery feature)" => "(experimental - not comprehensively tested and requires new JQuery feature)",
// "Enable" => "Enable",
// "Disable edit plugin icon (make plugin inline)" => "Disable edit plugin icon (make plugin inline)",
// "About plugin aliases" => "About plugin aliases",
// "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}" => "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}",
// "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}" => "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}",
// "Available Alias" => "Available Alias",
// "Enable Plugins" => "Enable Plugins",
// "General Information" => "General Information",
// "Plugin Name" => "Plugin Name",
// "Base Plugin" => "Base Plugin",
// "Body Label" => "Body Label",
// "Dependencies" => "Dependencies",
// "Validation" => "Validation",
// "Inline (No Plugin Edit UI)" => "Inline (No Plugin Edit UI)",
// "Simple Plugin Arguments" => "Simple Plugin Arguments",
// "Argument" => "Argument",
// "New Argument" => "New Argument",
// "Plugin Parameter Documentation" => "Plugin Parameter Documentation",
// "Safe" => "Safe",
// "Plugin Body" => "Plugin Body",
// "Ignore User Input" => "Ignore User Input",
// "Default Content" => "Default Content",
// "Encoding" => "Encoding",
// "Argument Source (if different)" => "Argument Source (if different)",
// "Default Value" => "Default Value",
// "Composed Plugin Arguments" => "Composed Plugin Arguments",
// "Pattern" => "Pattern",
// "Tracker attachment preferences" => "Tracker attachment preferences",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "Validate choice" => "Validate choice",
// "Tracker attachments" => "Tracker attachments",
// "No records" => "No records",
// "Include a flag by each e-mail to quickly flag/un-flag them" => "Include a flag by each e-mail to quickly flag/un-flag them",
// "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used" => "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used",
// "Lookup" => "Lookup",
// "Test Input" => "Test Input",
// "Response Information" => "Response Information",
// "OIntegrate Version" => "OIntegrate Version",
// "Not supported" => "Not supported",
// "Schema Version" => "Schema Version",
// "Schema Documentation" => "Schema Documentation",
// "Available" => "Available",
// "Not specified, default used" => "Not specified, default used",
// "Content Type" => "Content Type",
// "Not specified" => "Not specified",
// "Returned Data" => "Returned Data",
// "Proposed Templates" => "Proposed Templates",
// "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters" => "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters",
// "Register Service" => "Register Service",
// "Registered Templates" => "Registered Templates",
// "Engine" => "Engine",
// "Output" => "Output",
// "Register Template" => "Register Template",
// "Use the 'Quick Edit' module to easily create or edit wiki pages" => "Use the 'Quick Edit' module to easily create or edit wiki pages",
// "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules" => "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules",
// "Staging &amp; Approval" => "Staging &amp; Approval",
// "Page Listings" => "Page Listings",
// "If the page does not exist, it will be created" => "If the page does not exist, it will be created",
// "Wiki link format" => "Wiki link format",
// "Latin" => "Latin",
// "Select the characters that can be used with Wiki link syntax: ((page name))" => "Select the characters that can be used with Wiki link syntax: ((page name))",
// "Page display" => "Page display",
// "Page ID" => "Page ID",
// "Page version" => "Page version",
// "Page name display stripper" => "Page name display stripper",
// "Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>" => "Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>",
// "Allow override per page" => "Allow override per page",
// "Display show/hide icon displayed before headings" => "Display show/hide icon displayed before headings",
// "Wiki action bar" => "Wiki action bar",
// "Buttons: Save, Preview, Cancel, .." => "Buttons: Save, Preview, Cancel, ..",
// "Page navigation bar location" => "Page navigation bar location",
// "When using the ...page... page break wiki syntax" => "When using the ...page... page break wiki syntax",
// "Wiki top line" => "Wiki top line",
// "Neither" => "Neither",
// "Page description, icons, backlinks, .." => "Page description, icons, backlinks, ..",
// "Wiki buttons" => "Wiki buttons",
// "Buttons: Edit, Source, Remove, .." => "Buttons: Edit, Source, Remove, ..",
// "Save draft" => "Save draft",
// "Requires AJAX" => "Requires AJAX",
// "experimental" => "experimental",
// "Edit section" => "Edit section",
// "Edit section level" => "Edit section level",
// "Allow minor edits" => "Allow minor edits",
// "Minor edits do not flag new content for translation and do not send watch notifications" => "Minor edits do not flag new content for translation and do not send watch notifications",
// "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled" => "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled",
// "Regex search and replace" => "Regex search and replace",
// "Log bytes changes (+/-) in action logs" => "Log bytes changes (+/-) in action logs",
// "Display by default" => "Display by default",
// "Manage attachments" => "Manage attachments",
// "Tag for current wiki" => "Tag for current wiki",
// "Restore wiki to tag" => "Restore wiki to tag",
// "Restore" => "Restore",
// "Remove a tag" => "Remove a tag",
// "WikiWords" => "WikiWords",
// "Maximum number of versions" => "Maximum number of versions",
// "Never delete versions younger than" => "Never delete versions younger than",
// "Display IP address" => "Display IP address",
// "Default diff style" => "Default diff style",
// "HTML diff" => "HTML diff",
// "Side-by-side diff by characters" => "Side-by-side diff by characters",
// "Inline diff" => "Inline diff",
// "Inline diff by characters" => "Inline diff by characters",
// "Full side-by-side diff by characters" => "Full side-by-side diff by characters",
// "Full inline diff" => "Full inline diff",
// "Full inline diff by characters" => "Full inline diff by characters",
// "History includes only page data, description, and change comment" => "History includes only page data, description, and change comment",
// "Forums are disabled" => "Forums are disabled",
// "Forum for discussion" => "Forum for discussion",
// "View source" => "View source",
// "Polls are disabled" => "Polls are disabled",
// "like pages" => "like pages",
// "Make structure from page" => "Make structure from page",
// "Categorize structure pages together" => "Categorize structure pages together",
// "Create webhelp from structure" => "Create webhelp from structure",
// "Import pages" => "Import pages",
// "Slideshows" => "Slideshows",
// "User's page" => "User's page",
// "Users can lock pages" => "Users can lock pages",
// "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page" => "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page",
// "Wiki watch" => "Wiki watch",
// "Watch minor edits" => "Watch minor edits",
// "Use wiki page staging and approval" => "Use wiki page staging and approval",
// "Force bounce of editing of approved pages to staging" => "Force bounce of editing of approved pages to staging",
// "Delete staging pages at approval" => "Delete staging pages at approval",
// "If not in the group, edit is always redirected to the staging page edit" => "If not in the group, edit is always redirected to the staging page edit",
// "Unique page name prefix to indicate staging copy" => "Unique page name prefix to indicate staging copy",
// "Hide page name prefix" => "Hide page name prefix",
// "Staging" => "Staging",
// "Approved" => "Approved",
// "(mandatory for feature to work)" => "(mandatory for feature to work)",
// "Out-of-sync" => "Out-of-sync",
// "Categorize approved pages with categories of staging copy on approval" => "Categorize approved pages with categories of staging copy on approval",
// "Freetags are disabled" => "Freetags are disabled",
// "Replace freetags with that of staging pages, on approval" => "Replace freetags with that of staging pages, on approval",
// "Add new freetags of approved copy (into tags field) when editing staging pages" => "Add new freetags of approved copy (into tags field) when editing staging pages",
// "Orphan page" => "Orphan page",
// "Configuration" => "Configuration",
// "Select which items to display when listing pages" => "Select which items to display when listing pages",
// "Name length" => "Name length",
// "Edit comments" => "Edit comments",
// "Edit Comments length" => "Edit Comments length",
// "Categories path" => "Categories path",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "Wysiwyg Editor is optional" => "Wysiwyg Editor is optional",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Toolbar content" => "Toolbar content",
// "Database Version Problem" => "Database Version Problem",
// "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>" => "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>",
// "The following list of changes has been applied" => "The following list of changes has been applied",
// "disabled" => "disabled",
// "enabled" => "enabled",
// "information" => "information",
// "preference" => "preference",
// "preference name" => "preference name",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Administration features" => "Administration features",
// "Security" => "Security",
// "TikiCache/System" => "TikiCache/System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Edit Languages" => "Edit Languages",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "Look &amp; feel" => "Look &amp; feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "Stats &amp; banners" => "Stats &amp; banners",
// "Report" => "Report",
// "Please select some actions to view" => "Please select some actions to view",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot" => "Group Bar Plot",
// "Accumulated Bar Plot" => "Accumulated Bar Plot",
// "Legend background color" => "Legend background color",
// "Save graphs to image gallery" => "Save graphs to image gallery",
// "contribution" => "contribution",
// "contributor" => "contributor",
// "Edit Action" => "Edit Action",
// "Save Action" => "Save Action",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "recorded" => "recorded",
// "Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki page actions except viewed will always be recorded but can be not reported",
// "Configure" => "Configure",
// "Create Calendar" => "Create Calendar",
// "View Calendars" => "View Calendars",
// "Edit Calendar" => "Edit Calendar",
// "View Calendar" => "View Calendar",
// "Add Event" => "Add Event",
// "Create/Edit Calendars" => "Create/Edit Calendars",
// "Custom URL" => "Custom URL",
// "Start of day" => "Start of day",
// "End of day" => "End of day",
// "Standard Colors" => "Standard Colors",
// "Green" => "Green",
// "Blue" => "Blue",
// "Purple" => "Purple",
// "Orange" => "Orange",
// "Yellow" => "Yellow",
// "Let me select my own colors" => "Let me select my own colors",
// "Custom foreground color" => "Custom foreground color",
// "Ex" => "Ex",
// "Custom background color" => "Custom background color",
// "Default event status" => "Default event status",
// "Show in calendar view" => "Show in calendar view",
// "Group of users alerted when calendar event is modified" => "Group of users alerted when calendar event is modified",
// "Delete events older than" => "Delete events older than",
// "Browse the category system" => "Browse the category system",
// "Current Category ID" => "Current Category ID",
// "Remove from this Category" => "Remove from this Category",
// "Admin charts" => "Admin charts",
// "Use in" => "Use in",
// "No features are configured to use templates" => "No features are configured to use templates",
// "Visible in no sections" => "Visible in no sections",
// "Remove section" => "Remove section",
// "Admin Contributions" => "Admin Contributions",
// "Edit the contribution" => "Edit the contribution",
// "Contributions are mandatory in wiki pages" => "Contributions are mandatory in wiki pages",
// "Contributions are mandatory in forums" => "Contributions are mandatory in forums",
// "Contributions are mandatory in comments" => "Contributions are mandatory in comments",
// "Contributions are mandatory in blogs" => "Contributions are mandatory in blogs",
// "Contributions are displayed in the comment/post" => "Contributions are displayed in the comment/post",
// "Create a new contribution" => "Create a new contribution",
// "List of contributions" => "List of contributions",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}" => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link" => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link",
// "Use Admin DSN to define the database to be used by the SQL plugin" => "Use Admin DSN to define the database to be used by the SQL plugin",
// "Admin External Wikis" => "Admin External Wikis",
// "Enable Features" => "Enable Features",
// "Duplicate forum" => "Duplicate forum",
// "View this forum" => "View this forum",
// "Import forums" => "Import forums",
// "Only allow replies to the first message (flat forum)" => "Only allow replies to the first message (flat forum)",
// "Set topics preferences" => "Set topics preferences",
// "Show topics preferences" => "Show topics preferences",
// "hide topics preferences" => "hide topics preferences",
// "Set thread preferences" => "Set thread preferences",
// "Show threads preferences" => "Show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default style for threads" => "Default style for threads",
// "Duplicate Forum" => "Duplicate Forum",
// "Duplicate" => "Duplicate",
// "List Forums" => "List Forums",
// ".." => "..",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature" => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>" => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>",
// "mn" => "mn",
// "For wiki page, use ((PageName))" => "For wiki page, use ((PageName))",
// "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Use Ctrl+Click to select multiple groups" => "Use Ctrl+Click to select multiple groups",
// "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each" => "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each",
// "section level 0" => "section level 0",
// "section level 1" => "section level 1",
// "section level 2" => "section level 2",
// "section level 3" => "section level 3",
// "sorted section level 0" => "sorted section level 0",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'" => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu" => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format" => "To use a menu in a tiki format",
// "To use menu in a css/suckerfish format" => "To use menu in a css/suckerfish format",
// "To customize the menu's CSS id (#)" => "To customize the menu's CSS id (#)",
// "Folder Icon" => "Folder Icon",
// "Path and filename of closed folder icon" => "Path and filename of closed folder icon",
// "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder" => "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder",
// "In the same directory, include an icon for the opened folder" => "In the same directory, include an icon for the opened folder",
// "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>" => "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>",
// "For example, the default icon is: pics/icons/folder.png" => "For example, the default icon is: pics/icons/folder.png",
// "The name of the \"open folder\" icon is: pics/icons/ofolder.png" => "The name of the \"open folder\" icon is: pics/icons/ofolder.png",
// "Assign/Edit modules" => "Assign/Edit modules",
// "Move Up" => "Move Up",
// "Move Down" => "Move Down",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y" => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y",
// "The" => "The",
// "Display Modules to All Groups" => "Display Modules to All Groups",
// "setting will override your selection of specific groups" => "setting will override your selection of specific groups",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules" => "to make sure users will notice any newly assigned modules",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site" => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site",
// "Use Dynamic Content" => "Use Dynamic Content",
// "Use Wiki Structure" => "Use Wiki Structure",
// "Edit Newsletter" => "Edit Newsletter",
// "You can add several email addresses by separating them with commas" => "You can add several email addresses by separating them with commas",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Create Newsletter" => "Create Newsletter",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Drafts" => "Drafts",
// "Mail notifications" => "Mail notifications",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications",
// "Alert" => "Alert",
// "A user edits an article" => "A user edits an article",
// "A user deletes an article" => "A user deletes an article",
// "A comment in a wiki page is posted or edited" => "A comment in a wiki page is posted or edited",
// "Preload Admin Account" => "Preload Admin Account",
// "User / Group" => "User / Group",
// "Multiple" => "Multiple",
// "Trackers Outbound Emails" => "Trackers Outbound Emails",
// "Forums Outbound Emails" => "Forums Outbound Emails",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "Toggle Quick Options" => "Toggle Quick Options",
// "Add Option" => "Add Option",
// "Leave box empty for deleting an option" => "Leave box empty for deleting an option",
// "Votes older than these days are no more considered" => "Votes older than these days are no more considered",
// "0 for no limit" => "0 for no limit",
// "Span" => "Span",
// "Add poll to pages" => "Add poll to pages",
// "Use Ctrl+Click to select multiple pages" => "Use Ctrl+Click to select multiple pages",
// "Lock the pages" => "Lock the pages",
// "Quicktags category filter" => "Quicktags category filter",
// "Tips" => "Tips",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed" => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed",
// "Edit this RSS Module" => "Edit this RSS Module",
// "Create new RSS Module" => "Create new RSS Module",
// "RSS channels" => "RSS channels",
// "Show Date" => "Show Date",
// "View feed" => "View feed",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>" => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>",
// "TikiWiki settings" => "TikiWiki settings",
// "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors" => "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors",
// "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)" => "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)",
// "Security checks" => "Security checks",
// "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database" => "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments" => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments",
// "See end of table for detailed explanations" => "See end of table for detailed explanations",
// "owner" => "owner",
// "special" => "special",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "r" => "r",
// "w" => "w",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results" => "What to do with these check results",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"" => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content" => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information" => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes" => "Inodes that are not files or directories are not part of tiki. Review these Inodes",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod" => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod",
// "The structure" => "The structure",
// "has just been created" => "has just been created",
// "You will remove structure" => "You will remove structure",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict",
// "The following pages have automatically been categorized with the same categories as the structure" => "The following pages have automatically been categorized with the same categories as the structure",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent",
// "Edit structure" => "Edit structure",
// "View structure" => "View structure",
// "PDF" => "PDF",
// "Xml Zip" => "Xml Zip",
// "Add a New Question" => "Add a New Question",
// "This survey stats" => "This survey stats",
// "Edit Survey Question" => "Edit Survey Question",
// "Add a New Question to this survey" => "Add a New Question to this survey",
// "Multiple choices of thumbnails from a file gallery" => "Multiple choices of thumbnails from a file gallery",
// "Wiki textarea" => "Wiki textarea",
// "Answer is mandatory" => "Answer is mandatory",
// "Number of required answers (for multiple choices)" => "Number of required answers (for multiple choices)",
// "Min" => "Min",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value" => "For a rate, you can give the maximum value",
// "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4" => "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4",
// "Tiki Cache/System Admin" => "Tiki Cache/System Admin",
// "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)" => "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)",
// "Exterminator of cached content" => "Exterminator of cached content",
// "Directory to exterminate" => "Directory to exterminate",
// "Clear all Tiki caches" => "Clear all Tiki caches",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save" => "Directories to save",
// "Full Path to the Zip File" => "Full Path to the Zip File",
// "Generate a zip of those directories" => "Generate a zip of those directories",
// "A zip has been written to {\$zipPath}" => "A zip has been written to {\$zipPath}",
// "Directory is not writeable" => "Directory is not writeable",
// "Advanced feature" => "Advanced feature",
// "Inactive - Click to Activate" => "Inactive - Click to Activate",
// "Active - Click to Deactivate" => "Active - Click to Deactivate",
// "New tracker field" => "New tracker field",
// "Select list items that will be displayed" => "Select list items that will be displayed",
// "Multilingual content" => "Multilingual content",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "Field is hidden" => "Field is hidden",
// "not hidden" => "not hidden",
// "visible to admin only" => "visible to admin only",
// "editable by admin only" => "editable by admin only",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by" => "Visible by",
// "Editable by" => "Editable by",
// "Description text is wiki-parsed" => "Description text is wiki-parsed",
// "Error message" => "Error message",
// "Export fieldId also" => "Export fieldId also",
// "Check the box to re-import in this tracker and change the fields" => "Check the box to re-import in this tracker and change the fields",
// "Uncheck the box to import in another database" => "Uncheck the box to import in another database",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "Create Tracker" => "Create Tracker",
// "Duplicate Tracker" => "Duplicate Tracker",
// "trackers" => "trackers",
// "with" => "with",
// "Create/Edit Tracker" => "Create/Edit Tracker",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Create a group for each item" => "Create a group for each item",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Format if not the default short one" => "Format if not the default short one",
// "Show creation date when viewing tracker item" => "Show creation date when viewing tracker item",
// "Show lastModif date when viewing tracker item" => "Show lastModif date when viewing tracker item",
// "ItemId" => "ItemId",
// "and display last comment user/date" => "and display last comment user/date",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "Do not show empty fields in item view" => "Do not show empty fields in item view",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items",
// "Group of users alerted when tracker is modified" => "Group of users alerted when tracker is modified",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "User Choice" => "User Choice",
// "Only directly included" => "Only directly included",
// "will have all the permissions of the included groups" => "will have all the permissions of the included groups",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)" => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Create Item" => "Create Item",
// "Choose a field .." => "Choose a field ..",
// "Remove from Group" => "Remove from Group",
// "Add to group" => "Add to group",
// "Download CSV export" => "Download CSV export",
// "Assign users to group" => "Assign users to group",
// "Each user in the file must already exist" => "Each user in the file must already exist",
// "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>" => "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>",
// "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login" => "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login",
// "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login" => "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login",
// "Updated users" => "Updated users",
// "More Criteria" => "More Criteria",
// "Group (direct)" => "Group (direct)",
// "ago" => "ago",
// "Need to validate email" => "Need to validate email",
// "Assign to group" => "Assign to group",
// "Edit Included Group" => "Edit Included Group",
// "Edit Group" => "Edit Group",
// "Validate user" => "Validate user",
// "Remove Users and their Userpages" => "Remove Users and their Userpages",
// "Send a wiki page by Email" => "Send a wiki page by Email",
// "Tip: Hold down CTRL to select multiple" => "Tip: Hold down CTRL to select multiple",
// "Template wiki page" => "Template wiki page",
// "Assign user to Groups" => "Assign user to Groups",
// "Use the email as username" => "Use the email as username",
// "Lowercase only" => "Lowercase only",
// "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)" => "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)",
// "Warning: it will mess with slave intertiki sites that use this one as master" => "Warning: it will mess with slave intertiki sites that use this one as master",
// "No password is required" => "No password is required",
// "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth" => "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth",
// "Repeat Password" => "Repeat Password",
// "User must change password at first login" => "User must change password at first login",
// "Send an email to the user in order to allow him to validate his account" => "Send an email to the user in order to allow him to validate his account",
// "Last Login" => "Last Login",
// "You do not have permission to edit this user" => "You do not have permission to edit this user",
// "Overwrite but keep the previous login if the login exists in another case" => "Overwrite but keep the previous login if the login exists in another case",
// "Don't overwrite" => "Don't overwrite",
// "Overwrite groups" => "Overwrite groups",
// "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>" => "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>",
// "Loading.." => "Loading..",
// "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences" => "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "New attachments" => "New attachments",
// "Old attachments" => "Old attachments",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Show Help" => "Show Help",
// "Article type" => "Article type",
// "Actions on this article type" => "Actions on this article type",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Level configuration" => "Level configuration",
// "Assign User {\$assign_user} to Groups" => "Assign User {\$assign_user} to Groups",
// "Assign User to Group" => "Assign User to Group",
// "Convert the last sub directory to a sub gallery" => "Convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Browse File Gallery" => "Browse File Gallery",
// "Please do not use this feature to upload data into the database" => "Please do not use this feature to upload data into the database",
// "available files" => "available files",
// "Select a File Gallery" => "Select a File Gallery",
// "Process files" => "Process files",
// "Use Wysiwyg Editor" => "Use Wysiwyg Editor",
// "Use Normal Editor" => "Use Normal Editor",
// "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. ",
// "Report to Webmaster" => "Report to Webmaster",
// "The TikiWiki Community" => "The TikiWiki Community",
// "TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
// "database queries used in " => "database queries used in ",
// "Last update from SVN" => "Last update from SVN",
// "Watch Only This Category" => "Watch Only This Category",
// "Watch This Category and Their Descendants" => "Watch This Category and Their Descendants",
// "Stop Watching Only This Category" => "Stop Watching Only This Category",
// "Stop Watching This Category and Their Descendants" => "Stop Watching This Category and Their Descendants",
// "Trackers Items" => "Trackers Items",
// "in the current category - and its subcategories: " => "in the current category - and its subcategories: ",
// "Browse related tags" => "Browse related tags",
// "Network of Tags related to" => "Network of Tags related to",
// "With all selected tags" => "With all selected tags",
// "With one selected tag" => "With one selected tag",
// "With last selected tag" => "With last selected tag",
// "More Popular Tags" => "More Popular Tags",
// "Alphabetically" => "Alphabetically",
// "By Size" => "By Size",
// "Cloud" => "Cloud",
// "\$feature_label" => "\$feature_label",
// "results found" => "results found",
// "All Images" => "All Images",
// "You can view this gallery's configured image (first, random, etc.) in your browser using" => "You can view this gallery's configured image (first, random, etc.) in your browser using",
// "You can include the gallery's image in an HTML page using one of these lines" => "You can include the gallery's image in an HTML page using one of these lines",
// "Cyclic" => "Cyclic",
// "Admin Calendar" => "Admin Calendar",
// "Export Calendars" => "Export Calendars",
// "Click to export calendars" => "Click to export calendars",
// "Visible Calendars" => "Visible Calendars",
// "Click to select visible calendars" => "Click to select visible calendars",
// "Export calendars" => "Export calendars",
// "advanced parameters" => "advanced parameters",
// "Edit event" => "Edit event",
// "Delete event" => "Delete event",
// "View event" => "View event",
// "All-Day" => "All-Day",
// "Website" => "Website",
// "View this Week" => "View this Week",
// "View this Day" => "View this Day",
// "o" => "o",
// "Calendar Item" => "Calendar Item",
// "New event" => "New event",
// "Recurrence" => "Recurrence",
// "This event depends on a recurrence rule" => "This event depends on a recurrence rule",
// "This event is not recurrent" => "This event is not recurrent",
// "On a weekly basis" => "On a weekly basis",
// "Each" => "Each",
// "of the week" => "of the week",
// "On a monthly basis" => "On a monthly basis",
// "of the month" => "of the month",
// "On a yearly basis" => "On a yearly basis",
// "There's no such date as" => "There's no such date as",
// "Starting on" => "Starting on",
// "ending by" => "ending by",
// "ending after" => "ending after",
// "events" => "events",
// "Start period" => "Start period",
// "End after" => "End after",
// "occurrences" => "occurrences",
// "End before" => "End before",
// "Event is repeated" => "Event is repeated",
// "every" => "every",
// "of every month" => "of every month",
// "on each" => "on each",
// "Date and time of end" => "Date and time of end",
// "Events cannot end before they start" => "Events cannot end before they start",
// "or new" => "or new",
// "Choose users to alert" => "Choose users to alert",
// "chair" => "chair",
// "default role" => "default role",
// "required participant" => "required participant",
// "optional participant" => "optional participant",
// "non participant" => "non participant",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"" => "If no role is provided, default role will be \"Chair participant\"",
// "Update this event only" => "Update this event only",
// "Update every unchanged events of this recurrence rule" => "Update every unchanged events of this recurrence rule",
// "Update every events of this recurrence rule" => "Update every events of this recurrence rule",
// "Delete Recurrent events" => "Delete Recurrent events",
// "Avanced parameters for iCal export" => "Avanced parameters for iCal export",
// "Calendars to be exported" => "Calendars to be exported",
// "Categories checking is not done in the database search" => "Categories checking is not done in the database search",
// "Perform action with checked" => "Perform action with checked",
// "Your account has been validated" => "Your account has been validated",
// "You have to choose a password to use this account" => "You have to choose a password to use this account",
// "Change your password" => "Change your password",
// "Send another message" => "Send another message",
// "Group View" => "Group View",
// "Publish this contact to groups" => "Publish this contact to groups",
// "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>" => "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>",
// "The following site was added, but may require validation by the admin before appearing on the lists" => "The following site was added, but may require validation by the admin before appearing on the lists",
// "Edit a site" => "Edit a site",
// "Add a site" => "Add a site",
// "Directory Categories" => "Directory Categories",
// "Use Ctrl+Click to select multiple directory categories" => "Use Ctrl+Click to select multiple directory categories",
// "Parent directory category" => "Parent directory category",
// "Allow sites in this directory category" => "Allow sites in this directory category",
// "Show number of sites in this directory category" => "Show number of sites in this directory category",
// "Directory Subcategories" => "Directory Subcategories",
// "Admin related directory categories" => "Admin related directory categories",
// "Directory Category" => "Directory Category",
// "Use Ctrl+Click to select multiple categories" => "Use Ctrl+Click to select multiple categories",
// "Perform action with selected" => "Perform action with selected",
// "Add a Directory Category" => "Add a Directory Category",
// "in current directory category" => "in current directory category",
// "Related directory categories" => "Related directory categories",
// "Total directory categories" => "Total directory categories",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "Emails to be notified (separated with commas)" => "Emails to be notified (separated with commas)",
// "-1 for unlimited" => "-1 for unlimited",
// "Max clicks" => "Max clicks",
// "Or, create a new zone" => "Or, create a new zone",
// "Use Flash" => "Use Flash",
// "Movie Size" => "Movie Size",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "A category is mandatory" => "A category is mandatory",
// "The file will be saved in" => "The file will be saved in",
// "For more information, please see <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki Page Editor" => "For more information, please see <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki Page Editor",
// "More help on editing wiki pages" => "More help on editing wiki pages",
// "Wiki Syntax" => "Wiki Syntax",
// "The syntax system used for creating pages in TikiWiki" => "The syntax system used for creating pages in TikiWiki",
// "Bold text" => "Bold text",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Underlined text" => "Underlined text",
// "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background" => "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background",
// "Deleted text" => "Deleted text",
// "2 dashes" => "2 dashes",
// "Autonumbered Headings" => "Autonumbered Headings",
// "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Horizontal rule" => "Horizontal rule",
// "Text box" => "Text box",
// "Centered text" => "Centered text",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)" => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus (useful in list to continue at the same level)" => "Creates an indentation for each plus (useful in list to continue at the same level)",
// "row" => "row",
// "col" => "col",
// "Monospace font" => "Monospace font",
// "Code sample" => "Code sample",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "to separate pages" => "to separate pages",
// "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text" => "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text",
// "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar" => "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew" => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew",
// "Special characters" => "Special characters",
// "hard space" => "hard space",
// "numeric between ~ for html numeric characters entity" => "numeric between ~ for html numeric characters entity",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines" => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line" => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line",
// "Wiki plugins extend the function of wiki syntax with more specialized commands" => "Wiki plugins extend the function of wiki syntax with more specialized commands",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt",
// "text, bold" => "text, bold",
// "text, italic" => "text, italic",
// "text, underline" => "text, underline",
// "horizontal rule" => "horizontal rule",
// "Add image from File Gallery" => "Add image from File Gallery",
// "quote" => "quote",
// "flash" => "flash",
// "{\$label}" => "{\$label}",
// "Add Image from File Gallery" => "Add Image from File Gallery",
// "Leave Fullscreen Edit" => "Leave Fullscreen Edit",
// "Fullscreen Edit" => "Fullscreen Edit",
// "Upload from disk to change the image" => "Upload from disk to change the image",
// "Save and Go Next" => "Save and Go Next",
// "Im-Export Languages" => "Im-Export Languages",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Edit quiz results" => "Edit quiz results",
// "and its subpages from the structure" => "and its subpages from the structure",
// "The page already exists. The page that has been added to the structure is the existing one" => "The page already exists. The page that has been added to the structure is the existing one",
// "The following pages added have automatically been categorized with the same categories as the structure" => "The following pages added have automatically been categorized with the same categories as the structure",
// "Monitor the Sub-Structure" => "Monitor the Sub-Structure",
// "Stop Monitoring the Sub-Structure" => "Stop Monitoring the Sub-Structure",
// "Move in this structure" => "Move in this structure",
// "Move to another structure" => "Move to another structure",
// "at the beginning" => "at the beginning",
// "at the end" => "at the end",
// "Categorize all pages in structure together" => "Categorize all pages in structure together",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering" => "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering",
// "This would cause you problems (e.g. menus can stop collapsing/expanding)" => "This would cause you problems (e.g. menus can stop collapsing/expanding)",
// "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)" => "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)",
// "Maybe You just want to modify the top of your Tiki site" => "Maybe You just want to modify the top of your Tiki site",
// "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface" => "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface",
// "Save Only in the Theme" => "Save Only in the Theme",
// "Delete the copy in the theme" => "Delete the copy in the theme",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "View Page" => "View Page",
// "View Article" => "View Article",
// "Language of newly translated page" => "Language of newly translated page",
// "Unspecified" => "Unspecified",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"" => "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "Change language for this page" => "Change language for this page",
// "Select from available options.." => "Select from available options..",
// "Change Language" => "Change Language",
// "No language is assigned to this page" => "No language is assigned to this page",
// "Please select a language before performing translation" => "Please select a language before performing translation",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Your edit session will expire in" => "Your edit session will expire in",
// "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits" => "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits",
// "Update '{\$page}'" => "Update '{\$page}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval" => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval",
// "This is a new staging page that has not been approved before" => "This is a new staging page that has not been approved before",
// "The current staging copy may contain changes that have yet to be approved" => "The current staging copy may contain changes that have yet to be approved",
// "View changes since last approval" => "View changes since last approval",
// "You are editing the approved copy of this page" => "You are editing the approved copy of this page",
// "There are currently changes in the staging copy that have yet to be approved" => "There are currently changes in the staging copy that have yet to be approved",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead" => "instead",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Perhaps you are looking for" => "Perhaps you are looking for",
// "Change the style used to display differences to be translated" => "Change the style used to display differences to be translated",
// "Change diff styles" => "Change diff styles",
// "This edit session will expire in {\$edittimeout} minutes" => "This edit session will expire in {\$edittimeout} minutes",
// "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer" => "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer",
// "Switch to WYSIWYG editor" => "Switch to WYSIWYG editor",
// "Switch to normal (wiki) editor" => "Switch to normal (wiki) editor",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Disable" => "Disable",
// "or use" => "or use",
// "AutoSave" => "AutoSave",
// "If you want the saved version instead of the autosaved one" => "If you want the saved version instead of the autosaved one",
// "Regex search " => "Regex search ",
// "Replace to" => "Replace to",
// "Case Insensitivity" => "Case Insensitivity",
// "My Footnotes" => "My Footnotes",
// "Translation request" => "Translation request",
// "Send urgent translation request" => "Send urgent translation request",
// "Edit Comment" => "Edit Comment",
// "Monitor this page" => "Monitor this page",
// "Add another image" => "Add another image",
// "Lock this page" => "Lock this page",
// "List Sheets" => "List Sheets",
// "Graph" => "Graph",
// "Export to file" => "Export to file",
// "Format" => "Format",
// "Autodetect" => "Autodetect",
// "Export Tracker Items" => "Export Tracker Items",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse as Wiki Text" => "Parse as Wiki Text",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "All fields" => "All fields",
// "These fields" => "These fields",
// "Use Ctrl+Click to select multiple fields" => "Use Ctrl+Click to select multiple fields",
// "Dump All Tracker Items" => "Dump All Tracker Items",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "File Archive" => "File Archive",
// "Be careful to set the right permissions on the files you link to" => "Be careful to set the right permissions on the files you link to",
// "Create New File Gallery" => "Create New File Gallery",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Import from a Local SQL File" => "Import from a Local SQL File",
// "Forum Type" => "Forum Type",
// "DB Prefix" => "DB Prefix",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>" => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred" => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into" => "Which Forum Do You Wish to Import this Into",
// "Message queue for forum" => "Message queue for forum",
// "Back to forum" => "Back to forum",
// "Search by name" => "Search by name",
// "Search in content" => "Search in content",
// "Reported messages for forum" => "Reported messages for forum",
// "No records to display" => "No records to display",
// "Perfom action with checked" => "Perfom action with checked",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag" => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag",
// "Until then, they cannot be translated" => "Until then, they cannot be translated",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "Cancel friendship request" => "Cancel friendship request",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "Global default" => "Global default",
// "Google Map Locator" => "Google Map Locator",
// "Save clicked point" => "Save clicked point",
// "Reset view to default" => "Reset view to default",
// "Save current view as default" => "Save current view as default",
// "Center map to saved point" => "Center map to saved point",
// "Reset view to site default" => "Reset view to site default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal Scale" => "Horizontal Scale",
// "Bottom" => "Bottom",
// "Vertical Scale" => "Vertical Scale",
// "Series" => "Series",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "XML Zip" => "XML Zip",
// "Tiki installer" => "Tiki installer",
// "Welcome" => "Welcome",
// "Welcome to the Tiki installation and upgrade script" => "Welcome to the Tiki installation and upgrade script",
// "Use this script to install a new Tiki database or upgrade your existing database to release" => "Use this script to install a new Tiki database or upgrade your existing database to release",
// "For the latest information about this release, please read the" => "For the latest information about this release, please read the",
// "Release Notes" => "Release Notes",
// "For complete documentation, please visit" => "For complete documentation, please visit",
// "For more information about Tiki, please visit" => "For more information about Tiki, please visit",
// "Select your language" => "Select your language",
// "Read the License" => "Read the License",
// "Tiki is software distributed under the LGPL license" => "Tiki is software distributed under the LGPL license",
// " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>" => " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>",
// "Review the System Requirements" => "Review the System Requirements",
// "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements",
// "This installer will perform some basic checks automatically" => "This installer will perform some basic checks automatically",
// "Memory" => "Memory",
// "Success" => "Success",
// "Tiki has not detected your PHP memory_limit" => "Tiki has not detected your PHP memory_limit",
// "This probably means you have no set limit (all is well)" => "This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution" => "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution",
// "Allocating too little memory will cause Tiki to display blank pages" => "Allocating too little memory will cause Tiki to display blank pages",
// "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver" => "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Mail" => "Mail",
// "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages" => "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages",
// "To test your system configuration, Tiki will attempt to send a test message to you" => "To test your system configuration, Tiki will attempt to send a test message to you",
// "Test email" => "Test email",
// "Email address to send test to" => "Email address to send test to",
// "Copy test mail to " => "Copy test mail to ",
// "Send Test Message" => "Send Test Message",
// "Tiki was able to send a test message to" => "Tiki was able to send a test message to",
// "Tiki was not able to send a test message" => "Tiki was not able to send a test message",
// "Review your mail log for details" => "Review your mail log for details",
// "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)" => "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)",
// "If your host requires SMTP authentication, additional configuration may be necessary" => "If your host requires SMTP authentication, additional configuration may be necessary",
// "Image Processing" => "Image Processing",
// "Tiki detected" => "Tiki detected",
// "Tiki was not able to detect the GD library" => "Tiki was not able to detect the GD library",
// "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support" => "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support",
// "Set the Database Connection" => "Set the Database Connection",
// "Tiki requires an active database connection" => "Tiki requires an active database connection",
// "You must create the database and user <em>before</em> completing this page" => "You must create the database and user <em>before</em> completing this page",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "This is normal for a new installation" => "This is normal for a new installation",
// "Tiki found an existing database connection in your local.php file" => "Tiki found an existing database connection in your local.php file",
// "Use Existing Connection" => "Use Existing Connection",
// "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>" => "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>",
// "Database information" => "Database information",
// "Enter your database connection information" => "Enter your database connection information",
// "Database type" => "Database type",
// "Select the type of database to use with Tiki" => "Select the type of database to use with Tiki",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension" => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension",
// "Host name" => "Host name",
// "Enter the host name or IP for your database" => "Enter the host name or IP for your database",
// "Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "For SQLite, enter the path and filename to your database file" => "For SQLite, enter the path and filename to your database file",
// "Database name" => "Database name",
// "Enter the name of the database that Tiki will use" => "Enter the name of the database that Tiki will use",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names",
// "For Oracle" => "For Oracle",
// "Enter your TNS Name here and leave Host empty" => "Enter your TNS Name here and leave Host empty",
// "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field" => "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field",
// "Database user" => "Database user",
// "Enter a database user with administrator permission for the Database" => "Enter a database user with administrator permission for the Database",
// "User name" => "User name",
// "Install &amp; Update Profile" => "Install &amp; Update Profile",
// "Install Profile" => "Install Profile",
// "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page" => "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page",
// "Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database" => "Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database",
// "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>" => "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>",
// "Select the installation profile to use. This profile will populate the database" => "Select the installation profile to use. This profile will populate the database",
// "Profiles can be used to pre-configure your site with specific features and settings" => "Profiles can be used to pre-configure your site with specific features and settings",
// "Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information" => "Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information",
// "Reinstall the database" => "Reinstall the database",
// "This will destroy your current database" => "This will destroy your current database",
// "Create a new database (clean install) with profile" => "Create a new database (clean install) with profile",
// "Bare-bones default install" => "Bare-bones default install",
// "Personal Blog and Profile" => "Personal Blog and Profile",
// "Small Organization Web Presence" => "Small Organization Web Presence",
// "Company Intranet" => "Company Intranet",
// "Collaborative community" => "Collaborative community",
// "See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles" => "See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles",
// "The installer could not connect to the Profiles repository" => "The installer could not connect to the Profiles repository",
// "The default installation profile will be used" => "The default installation profile will be used",
// "Upgrade" => "Upgrade",
// "Automatically upgrade your existing database to v" => "Automatically upgrade your existing database to v",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Review the Upgrade" => "Review the Upgrade",
// "Review the Installation" => "Review the Installation",
// "Upgrade complete" => "Upgrade complete",
// "Installation complete" => "Installation complete",
// "Your database has been configured and Tiki is ready to run" => "Your database has been configured and Tiki is ready to run",
// "If this is your first install, your admin password is <strong>admin</strong>" => "If this is your first install, your admin password is <strong>admin</strong>",
// "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application" => "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application",
// "Upgrade operations executed successfully" => "Upgrade operations executed successfully",
// "Installation operations executed successfully" => "Installation operations executed successfully",
// "SQL queries" => "SQL queries",
// "Database was left unchanged" => "Database was left unchanged",
// "Failed" => "Failed",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages" => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages",
// ".htaccess File" => ".htaccess File",
// "We recommend enabling the <strong>.htaccess</strong> file for your Tiki" => "We recommend enabling the <strong>.htaccess</strong> file for your Tiki",
// "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security" => "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security",
// "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>" => "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>",
// "Complete these fields to configure common, general settings for your site" => "Complete these fields to configure common, general settings for your site",
// "The information you enter here can be changed later" => "The information you enter here can be changed later",
// "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings" => "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings",
// "This will appear in the browser title bar" => "This will appear in the browser title bar",
// "Email sent by your site will use this address" => "Email sent by your site will use this address",
// "Secure Login" => "Secure Login",
// "HTTPS login" => "HTTPS login",
// "Administrator" => "Administrator",
// "Admin email" => "Admin email",
// "This is the email address for your administrator account" => "This is the email address for your administrator account",
// "Enter Your Tiki" => "Enter Your Tiki",
// "The installation is complete" => "The installation is complete",
// "Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>" => "Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>",
// "Installation" => "Installation",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu" => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu",
// "Enter Tiki and Lock Installer" => "Enter Tiki and Lock Installer",
// "Recommended" => "Recommended",
// "Enter Tiki Without Locking Installer" => "Enter Tiki Without Locking Installer",
// "MultiTiki Setup" => "MultiTiki Setup",
// "Default Installation" => "Default Installation",
// "DB OK" => "DB OK",
// "No DB" => "No DB",
// "Adding a new host" => "Adding a new host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Are you upgrading an existing Tiki site" => "Are you upgrading an existing Tiki site",
// "Go directly to the <strong>Install/Upgrade</strong> step" => "Go directly to the <strong>Install/Upgrade</strong> step",
// "Install/Upgrade" => "Install/Upgrade",
// "Restart the installer" => "Restart the installer",
// "Database Connection" => "Database Connection",
// "Reset the Database Connection" => "Reset the Database Connection",
// "Configure the General Settings" => "Configure the General Settings",
// "Tiki Icon" => "Tiki Icon",
// "TikiWiki Project Web Site" => "TikiWiki Project Web Site",
// "Support Forums" => "Support Forums",
// "TikiWiki CMS/Groupware Project" => "TikiWiki CMS/Groupware Project",
// "Powered by TikiWiki" => "Powered by TikiWiki",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Go Back" => "Go Back",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "Last 2 days" => "Last 2 days",
// "Last 3 days" => "Last 3 days",
// "Last 5 days" => "Last 5 days",
// "Last week" => "Last week",
// "Last 2 weeks" => "Last 2 weeks",
// "Last month" => "Last month",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone" => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone",
// "Max Clicks" => "Max Clicks",
// "The cache is used by" => "The cache is used by",
// "Approval" => "Approval",
// "Rejected" => "Rejected",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block" => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block" => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "SlideShow" => "SlideShow",
// "Keep gallery window open" => "Keep gallery window open",
// "Your comment" => "Your comment",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "Flash binary (.swf or .dcr)" => "Flash binary (.swf or .dcr)",
// "users registered" => "users registered",
// "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on" => "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on",
// "Last modification" => "Last modification",
// "Page creator" => "Page creator",
// "Status of the page" => "Status of the page",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl" => "Backl",
// "Page size" => "Page size",
// " {if \$find ne ''}and {/if}starting with" => " {if \$find ne ''}and {/if}starting with",
// "offline" => "offline",
// "Back to admin" => "Back to admin",
// "For security purposes we must periodically validate your email address to allow continued access to this site" => "For security purposes we must periodically validate your email address to allow continued access to this site",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site" => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site",
// "Thank you" => "Thank you",
// "This is an experimental feature" => "This is an experimental feature",
// "Requires" => "Requires",
// "Not Enabled" => "Not Enabled",
// "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/" => "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/",
// "Mods Configuration" => "Mods Configuration",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>" => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>",
// "Tiki \"mods\" are undergoing refurbishment" => "Tiki \"mods\" are undergoing refurbishment",
// "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification" => "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification",
// "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more" => "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)" => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")" => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")",
// "for version" => "for version",
// "all versions" => "all versions",
// "or later" => "or later",
// "No mods found" => "No mods found",
// "licence" => "licence",
// "Mods Install/uninstall" => "Mods Install/uninstall",
// "y" => "y",
// "My Articles" => "My Articles",
// "User Articles" => "User Articles",
// "My User Items" => "My User Items",
// "User Items" => "User Items",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "To display the objects you participate" => "To display the objects you participate",
// "My Infos" => "My Infos",
// "Contacts Preferences" => "Contacts Preferences",
// "My Contacts" => "My Contacts",
// "My Wiki Pages" => "My Wiki Pages",
// "My Galleries" => "My Galleries",
// "My Tracker Items" => "My Tracker Items",
// "My Messages" => "My Messages",
// "My Tasks" => "My Tasks",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Delete errors" => "Delete errors",
// "Not sent" => "Not sent",
// "Removal of your email address failed" => "Removal of your email address failed",
// "Subscription failed" => "Subscription failed",
// "Add a news server" => "Add a news server",
// "Edit news server" => "Edit news server",
// "Object Watches" => "Object Watches",
// "Watching Groups" => "Watching Groups",
// "View Permissions" => "View Permissions",
// "Edit Permissions" => "Edit Permissions",
// "These permissions override any global permissions or category permissions affecting this object" => "These permissions override any global permissions or category permissions affecting this object",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>" => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>",
// "No individual permissions, category permissions apply" => "No individual permissions, category permissions apply",
// "Current permissions for categories that this object belongs to" => "Current permissions for categories that this object belongs to",
// "These permissions do not apply. Special permissions apply" => "These permissions do not apply. Special permissions apply",
// "No category permissions; special permissions apply" => "No category permissions; special permissions apply",
// "and also to all pages of the sub-structure" => "and also to all pages of the sub-structure",
// "Perms Help" => "Perms Help",
// "Your OpenID identity is valid" => "Your OpenID identity is valid",
// "However, no account is associated to the OpenID identifier" => "However, no account is associated to the OpenID identifier",
// "Create a new Tikiwiki account from OpenID" => "Create a new Tikiwiki account from OpenID",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts" => "Your identity gives you access to multiple user accounts",
// "Select account" => "Select account",
// "Make Structure" => "Make Structure",
// "{\$atts|@count} files attached" => "{\$atts|@count} files attached",
// "Updated from" => "Updated from",
// "Used to update" => "Used to update",
// "Update Translation" => "Update Translation",
// "Hide translation history" => "Hide translation history",
// "Show translation history" => "Show translation history",
// "File (only .gif, .jpg and .png images approximately 45px × 45px)" => "File (only .gif, .jpg and .png images approximately 45px × 45px)",
// "Plugin execution was denied" => "Plugin execution was denied",
// "Plugin execution pending approval" => "Plugin execution pending approval",
// "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected" => "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected",
// "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible" => "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible",
// "You are allowed to" => "You are allowed to",
// "View arguments" => "View arguments",
// "Execute the plugin in preview mode (may be dangerous)" => "Execute the plugin in preview mode (may be dangerous)",
// "Approve the plugin for public execution" => "Approve the plugin for public execution",
// "This plugin does not contain any arguments" => "This plugin does not contain any arguments",
// "This plugin's body is empty" => "This plugin's body is empty",
// "Any" => "Any",
// "Items found" => "Items found",
// "Sum" => "Sum",
// "Plugin Approval" => "Plugin Approval",
// "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups" => "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups",
// "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins" => "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins",
// "This page lists the plugins that require validation, the first time they are encountered" => "This page lists the plugins that require validation, the first time they are encountered",
// "Each plugin contains a unique <em>signature</em> that is preserved" => "Each plugin contains a unique <em>signature</em> that is preserved",
// "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list" => "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list",
// "The plugin will automatically be added if it is encountered" => "The plugin will automatically be added if it is encountered",
// "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin" => "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin",
// "For security, you should review each plugin to ensure it is safe to approve" => "For security, you should review each plugin to ensure it is safe to approve",
// "Added By" => "Added By",
// "Signature" => "Signature",
// "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "Approve all pending plugins" => "Approve all pending plugins",
// "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins" => "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins",
// "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe" => "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe",
// "No plugins pending approval" => "No plugins pending approval",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Edit Poll" => "Edit Poll",
// "Find the poll" => "Find the poll",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Vote range displayed" => "Vote range displayed",
// "All votes with no span consideration" => "All votes with no span consideration",
// "All votes with span consideration" => "All votes with span consideration",
// "All votes" => "All votes",
// "List Votes" => "List Votes",
// "Permission denied. You do not have permission to read complete articles" => "Permission denied. You do not have permission to read complete articles",
// "Selected Structures" => "Selected Structures",
// "Add Structure" => "Add Structure",
// "No structures" => "No structures",
// "Add Pages" => "Add Pages",
// "No pages" => "No pages",
// "Add Pages from Structures" => "Add Pages from Structures",
// "Add Structure Pages" => "Add Structure Pages",
// "Selected Pages" => "Selected Pages",
// "No pages selected" => "No pages selected",
// "P/F" => "P/F",
// "Passed" => "Passed",
// "Rank" => "Rank",
// "star" => "star",
// "half star" => "half star",
// "Send a link" => "Send a link",
// "List all articles of this same topic" => "List all articles of this same topic",
// "Received Pages" => "Received Pages",
// "Edit Received Page" => "Edit Received Page",
// "The highlight pages already exist" => "The highlight pages already exist",
// "Please, change the name if you want the page to be uploaded" => "Please, change the name if you want the page to be uploaded",
// "Received Structures" => "Received Structures",
// "Prefix the checked" => "Prefix the checked",
// "Postfix the checked" => "Postfix the checked",
// "Use your email as login" => "Use your email as login",
// "Minimum {\$prefs.min_username_length} characters long" => "Minimum {\$prefs.min_username_length} characters long",
// "Passcode to register" => "Passcode to register",
// "Not your password" => "Not your password",
// "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}" => "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}",
// "Generate a\tpassword" => "Generate a\tpassword",
// "Select your group" => "Select your group",
// "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter" => "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter",
// "Enter your username or email" => "Enter your username or email",
// "Enter your email" => "Enter your email",
// "Request Password Reset" => "Request Password Reset",
// "Back to page" => "Back to page",
// "to version" => "to version",
// "\$name" => "\$name",
// "Faqs" => "Faqs",
// "Blogs Post" => "Blogs Post",
// "Date Search" => "Date Search",
// "All dates" => "All dates",
// "Calendar Items" => "Calendar Items",
// "Please Confirm" => "Please Confirm",
// "octets" => "octets",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "Attached Files" => "Attached Files",
// "To add a file, click here" => "To add a file, click here",
// "Save as Draft" => "Save as Draft",
// "Send a structure" => "Send a structure",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page" => "the approved version of this page",
// "Viewing of changes since last approval is possible only after first approval" => "Viewing of changes since last approval is possible only after first approval",
// "Approve changes" => "Approve changes",
// "Latest changes will be synchronized after approval" => "Latest changes will be synchronized after approval",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time" => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time",
// "Content may be out of date" => "Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages",
// "TOC" => "TOC",
// "page: %0/%1" => "page: %0/%1",
// "Page last modified on %0 by %1" => "Page last modified on %0 by %1",
// "Created by %0" => "Created by %0",
// "Last Modification: %0 by %1" => "Last Modification: %0 by %1",
// "You will not see the latest queries" => "You will not see the latest queries",
// "Clean" => "Clean",
// "Params" => "Params",
// "Most viewed objects" => "Most viewed objects",
// "Most viewed objects in the last 7 days" => "Most viewed objects in the last 7 days",
// "Date of first pageview" => "Date of first pageview",
// "Days since first pageview" => "Days since first pageview",
// "Total replies" => "Total replies",
// "Average number of replies per topic" => "Average number of replies per topic",
// "FAQ Stats" => "FAQ Stats",
// "Usage chart" => "Usage chart",
// "Usage chart image" => "Usage chart image",
// "Daily Usage" => "Daily Usage",
// "Tiki Logs" => "Tiki Logs",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "Send a link to a friend" => "Send a link to a friend",
// "The link was sent to the following addresses" => "The link was sent to the following addresses",
// "Friend's email" => "Friend's email",
// "Separate multiple email addresses with a comma" => "Separate multiple email addresses with a comma",
// "Your name" => "Your name",
// "Your email" => "Your email",
// "I found an interesting page that I thought you would like" => "I found an interesting page that I thought you would like",
// "TikiTests Edit" => "TikiTests Edit",
// "Summary mode" => "Summary mode",
// "Show Page Differences" => "Show Page Differences",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Request" => "Request",
// "Element to compare (Xpath expression)" => "Element to compare (Xpath expression)",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "TikiTests List" => "TikiTests List",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "PECL HTTP extension present" => "PECL HTTP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible" => "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "TikiTests Record Configuration" => "TikiTests Record Configuration",
// "Start Recording Test" => "Start Recording Test",
// "TikiTests Replay Configuration" => "TikiTests Replay Configuration",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "Theme Control Center: Categories" => "Theme Control Center: Categories",
// "Theme Control Center: Sections" => "Theme Control Center: Sections",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "Additional Info" => "Additional Info",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "You locked the file" => "You locked the file",
// "The file is locked by {\$fileInfo.lockedby}" => "The file is locked by {\$fileInfo.lockedby}",
// "Unzip zip files" => "Unzip zip files",
// "Author if not the file creator" => "Author if not the file creator",
// "Maximum amount of downloads" => "Maximum amount of downloads",
// "Add File" => "Add File",
// "Maximum file size is limited to" => "Maximum file size is limited to",
// "No gallery available" => "No gallery available",
// "Uploading file.." => "Uploading file..",
// "No File to Upload.." => "No File to Upload..",
// "The column is disabled" => "The column is disabled",
// "a folder" => "a folder",
// "a URL" => "a URL",
// "User Contacts Preferences" => "User Contacts Preferences",
// "Manage Fields" => "Manage Fields",
// "Default view" => "Default view",
// "(non public)" => "(non public)",
// "System" => "System",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Forum comments" => "Forum comments",
// "Toggle" => "Toggle",
// "Male" => "Male",
// "Female" => "Female",
// "Use Google Map locator" => "Use Google Map locator",
// "Your preferred language" => "Your preferred language",
// "Can you read more languages" => "Can you read more languages",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
// "Select language.." => "Select language..",
// "Displays users' info tooltip on mouseover for every user who allows his information to be public" => "Displays users' info tooltip on mouseover for every user who allows his information to be public",
// "My user items" => "My user items",
// "My level" => "My level",
// "You are not allowed to remove this notification " => "You are not allowed to remove this notification ",
// "Use \"watches\" to monitor wiki pages or other objects" => "Use \"watches\" to monitor wiki pages or other objects",
// "Watch new items by clicking the {icon _id=eye} button on specific pages" => "Watch new items by clicking the {icon _id=eye} button on specific pages",
// "Select event type" => "Select event type",
// "All watched events" => "All watched events",
// "A user edited an article" => "A user edited an article",
// "A user deleted an article" => "A user deleted an article",
// "A user created a wiki page in a language" => "A user created a wiki page in a language",
// "Used space" => "Used space",
// "up to" => "up to",
// "no limit for admin" => "no limit for admin",
// "No articles yet" => "No articles yet",
// "Add an article" => "Add an article",
// "There are no questions in this FAQ" => "There are no questions in this FAQ",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "Group Monitor Topics of this Forum" => "Group Monitor Topics of this Forum",
// "Group Monitor Topics and Threads of this Forum" => "Group Monitor Topics and Threads of this Forum",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Editing posts" => "Editing posts",
// "Forum Lock" => "Forum Lock",
// "Unarchive" => "Unarchive",
// "posts in this forum" => "posts in this forum",
// "Filter Posts" => "Filter Posts",
// "Posts Filtering" => "Posts Filtering",
// "Last post date" => "Last post date",
// "Show archived posts" => "Show archived posts",
// "Containing posts by" => "Containing posts by",
// "Me" => "Me",
// "Posts with no replies" => "Posts with no replies",
// "Archived" => "Archived",
// "Topic List" => "Topic List",
// "The post has been reported and will be reviewed by a moderator" => "The post has been reported and will be reviewed by a moderator",
// "Print this page only" => "Print this page only",
// "Print all pages" => "Print all pages",
// "Stop Monitor" => "Stop Monitor",
// "Tracker Items" => "Tracker Items",
// "Pending" => "Pending",
// "Edit/Delete" => "Edit/Delete",
// "There was an error connecting to your e-mail account" => "There was an error connecting to your e-mail account",
// "Add a new" => "Add a new",
// "Edit this" => "Edit this",
// " mail account" => " mail account",
// "Group (shared mail inbox) or private" => "Group (shared mail inbox) or private",
// "This will be a group mail account" => "This will be a group mail account",
// "This will be a personal mail account" => "This will be a personal mail account",
// "Auto-refresh page time" => "Auto-refresh page time",
// "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission" => "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission",
// "Personal e-mail accounts" => "Personal e-mail accounts",
// "Click to activate" => "Click to activate",
// "This is the active account" => "This is the active account",
// "Group e-mail accounts" => "Group e-mail accounts",
// "Show Unread" => "Show Unread",
// "Show Flagged" => "Show Flagged",
// "Refresh now" => "Refresh now",
// "Group messages" => "Group messages",
// "unFlagged" => "unFlagged",
// "Group Monitor on Structure" => "Group Monitor on Structure",
// "Jump to Content" => "Jump to Content",
// "Cancel Fullscreen" => "Cancel Fullscreen",
// "Latitude" => "Latitude",
// "Longitude" => "Longitude",
// "Remove Image" => "Remove Image",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Word Count" => "Word Count",
// "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator" => "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator",
// "Your vote" => "Your vote",
// "Click to vote for this value" => "Click to vote for this value",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled" => "Google Maps is not enabled",
// "The main text of this page is available in the following languages" => "The main text of this page is available in the following languages",
// "Use this thread to discuss the page" => "Use this thread to discuss the page",
// "Missing or incorrect trackerId parameter for the plugin" => "Missing or incorrect trackerId parameter for the plugin",
// "list" => "list",
// "Reinstall" => "Reinstall",
// "Undecided" => "Undecided",
// "Subscribe to a group" => "Subscribe to a group",
// "Toggle display" => "Toggle display",
// "Preview your changes" => "Preview your changes",
// "Save the page as a partial translation" => "Save the page as a partial translation",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation" => "Save the page as a completed translation",
// "Complete Translation" => "Complete Translation",
// "Save the page, but do not send notifications and do not count it as new content to be translated" => "Save the page, but do not send notifications and do not count it as new content to be translated",
// "Save the page" => "Save the page",
// "Save the page as a draft" => "Save the page as a draft",
// "Save Draft" => "Save Draft",
// "Cancel the edit, you will lose your changes" => "Cancel the edit, you will lose your changes",
// "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>",
// "Separate multiple usernames with a comma (&nbsp;,&nbsp;)" => "Separate multiple usernames with a comma (&nbsp;,&nbsp;)",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "%s set" => "%s set",
// "%s unset" => "%s unset",
// "Administration" => "Administration",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Intertiki settings" => "Intertiki settings",
// "Freetags settings" => "Freetags settings",
// "Look & Feel" => "Look & Feel",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Current version is up to date : <b>%s</b>" => "Current version is up to date : <b>%s</b>",
// "A new %s  major release branch is available" => "A new %s  major release branch is available",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "Click here to delete the category" => "Click here to delete the category",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header" => "The file does not have the required header",
// "moved %d images, %d errors occured" => "moved %d images, %d errors occured",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Test Image" => "Test Image",
// "You cannot have a blank password" => "You cannot have a blank password",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "If you use apache, you need a .htaccess file to have this feature working" => "If you use apache, you need a .htaccess file to have this feature working",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Error opening uploaded file" => "Error opening uploaded file",
// "Invalid email" => "Invalid email",
// "You need to provide a username or an email" => "You need to provide a username or an email",
// "risky" => "risky",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off" => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code" => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code",
// "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html" => "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html",
// "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement" => "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement",
// "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory" => "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory",
// "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts" => "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts",
// "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)" => "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)",
// "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users" => "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users",
// "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users" => "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users",
// "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands" => "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous" => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous",
// "This is a modified File. Cannot check version. Check if it is dangerous" => "This is a modified File. Cannot check version. Check if it is dangerous",
// "This file is from another Tikiwiki version: " => "This file is from another Tikiwiki version: ",
// "Are you sure you want to remove this topic" => "Are you sure you want to remove this topic",
// "Are you sure you want to remove this topic AND all the articles related" => "Are you sure you want to remove this topic AND all the articles related",
// "Tracker does not allow attachments" => "Tracker does not allow attachments",
// "Remove group: " => "Remove group: ",
// "Remove permission: %s on %s" => "Remove permission: %s on %s",
// "The description is mandatory as it is used as mail subject" => "The description is mandatory as it is used as mail subject",
// "Invalid or unknown email" => "Invalid or unknown email",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "User login contains invalid characters" => "User login contains invalid characters",
// "Deleted account %s" => "Deleted account %s",
// "Login contains invalid characters" => "Login contains invalid characters",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s" => "Could not read file %s",
// "Could not write to file %s" => "Could not write to file %s",
// "File %s upload failed" => "File %s upload failed",
// "Upload was successful" => "Upload was successful",
// "File %s removed from Batch directory" => "File %s removed from Batch directory",
// "Impossible to remove file %s from Batch directory" => "Impossible to remove file %s from Batch directory",
// "Incorrect directory chosen for batch upload of files" => "Incorrect directory chosen for batch upload of files",
// "Last modifications to the blog" => "Last modifications to the blog",
// "Nothing tagged yet" => "Nothing tagged yet",
// "You must clear your browser cache" => "You must clear your browser cache",
// "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>" => "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "Mo" => "Mo",
// "Tu" => "Tu",
// "We" => "We",
// "Th" => "Th",
// "Fr" => "Fr",
// "Sa" => "Sa",
// "Su" => "Su",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Invalid username or activation code. Maybe this code has already been used" => "Invalid username or activation code. Maybe this code has already been used",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "Invalid request. Expecting channels array" => "Invalid request. Expecting channels array",
// "Missing channel name" => "Missing channel name",
// "Authentication required" => "Authentication required",
// "One of the requested channels cannot be requested. It does not exist or permission is denied" => "One of the requested channels cannot be requested. It does not exist or permission is denied",
// "One of the install profiles could not be obtained" => "One of the install profiles could not be obtained",
// "Problem. Try to log in again to receive new confirmation instructions" => "Problem. Try to log in again to receive new confirmation instructions",
// "You cannot download this file right now. Your score is low or file limit was reached" => "You cannot download this file right now. Your score is low or file limit was reached",
// "Error : The file %s doesn't exist" => "Error : The file %s doesn't exist",
// "Translation in progress" => "Translation in progress",
// "Page is a staging copy. Translation must begin from the approved copy" => "Page is a staging copy. Translation must begin from the approved copy",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "Can't parse HTML data - no grammar file" => "Can't parse HTML data - no grammar file",
// "Page already exists. Go back and choose a different name" => "Page already exists. Go back and choose a different name",
// "The translation set already contains a page in this language" => "The translation set already contains a page in this language",
// "Remove archive: " => "Remove archive: ",
// "Remove file gallery: " => "Remove file gallery: ",
// "Form error - no import method selected for some reason" => "Form error - no import method selected for some reason",
// "Form error - no server-side filename entered for selected import method" => "Form error - no server-side filename entered for selected import method",
// "Last replied forum topics" => "Last replied forum topics",
// "Not supported yet" => "Not supported yet",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "I have refused your friendship request" => "I have refused your friendship request",
// "I have canceled my friendship request" => "I have canceled my friendship request",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "Invalid source path" => "Invalid source path",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "No valid renderer found. GD or PDFLib required" => "No valid renderer found. GD or PDFLib required",
// "No sheet specified" => "No sheet specified",
// "You must select a renderer" => "You must select a renderer",
// "Invalid Series for current graphic" => "Invalid Series for current graphic",
// "Only the administrator can upload language files" => "Only the administrator can upload language files",
// "Operations executed successfully" => "Operations executed successfully",
// "Page saved (version %d)" => "Page saved (version %d)",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "Delete comments" => "Delete comments",
// "Approved Status" => "Approved Status",
// "Queued" => "Queued",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Remove file: " => "Remove file: ",
// "Warning: Empty file" => "Warning: Empty file",
// "Please re-upload your file" => "Please re-upload your file",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Cannot read the file" => "Cannot read the file",
// "Upload was not successful. Duplicate file content" => "Upload was not successful. Duplicate file content",
// "This gallery does not exist" => "This gallery does not exist",
// "Unable to contact remote server" => "Unable to contact remote server",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Unable to create login" => "Unable to create login",
// "More than %d unsuccessful login attempts have been made" => "More than %d unsuccessful login attempts have been made",
// "An email has been sent to you with the instructions to follow" => "An email has been sent to you with the instructions to follow",
// "Your default nickname is already in use. A new one has to be selected" => "Your default nickname is already in use. A new one has to be selected",
// "The selected account is not associated with your identity" => "The selected account is not associated with your identity",
// "unknown action" => "unknown action",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "Invalid password" => "Invalid password",
// "Account disabled" => "Account disabled",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile" => "An error as occured with the mapfile",
// "Please create a directory named '.\$prefs['map_path'].' to hold your map files" => "Please create a directory named '.\$prefs['map_path'].' to hold your map files",
// "map edit" => "map edit",
// "No page provided" => "No page provided",
// "Page \"%0\" does not exist" => "Page \"%0\" does not exist",
// "Are you sure you want to delete this note" => "Are you sure you want to delete this note",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "Missing object list type argument" => "Missing object list type argument",
// "Index" => "Index",
// "Index (' . \$code . " => "Index (' . \$code . ",
// "You must choose a group" => "You must choose a group",
// "Username cannot contain uppercase letters" => "Username cannot contain uppercase letters",
// "Username must be at least" => "Username must be at least",
// "Username cannot contain more than" => "Username cannot contain more than",
// "characters" => "characters",
// "Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Please enter a valid %s.  No spaces, more than %d characters and contain %s",
// "This is not a valid mail adress" => "This is not a valid mail adress",
// "mail adress" => "mail adress",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password" => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password",
// "The mail can't be sent. Contact the administrator" => "The mail can't be sent. Contact the administrator",
// "An email with a link to reset your password has been sent " => "An email with a link to reset your password has been sent ",
// "to the email" => "to the email",
// "You cannot rename staging pages. Please rename the approved page instead" => "You cannot rename staging pages. Please rename the approved page instead",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "invalid email" => "invalid email",
// "Notice: this variable may not be empty" => "Notice: this variable may not be empty",
// "Notice: invalid variable value" => "Notice: invalid variable value",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Clean the sql logs" => "Clean the sql logs",
// "Report to the webmaster" => "Report to the webmaster",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Batch file processed" => "Batch file processed",
// "Password has been changed" => "Password has been changed",
// "Invalid password. Your current password is required to change administrative information" => "Invalid password. Your current password is required to change administrative information",
// "A new page is created in a language" => "A new page is created in a language",
// "Language watch" => "Language watch",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again" => "You must suggest a question; please try again",
// "Incorrect thread" => "Incorrect thread",
// " The connection failed, so check the server names" => " The connection failed, so check the server names",
// "The connection was OK" => "The connection was OK",
// " But the login failed, so check the Username and Password" => " But the login failed, so check the Username and Password",
// "Plugin modified by editor" => "Plugin modified by editor",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "The TikiTests Replay File has an error" => "The TikiTests Replay File has an error",
// "You are about to delete a TikiTest file, do you want to continue " => "You are about to delete a TikiTest file, do you want to continue ",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// "The page is empty" => "The page is empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Re:" => "Re:",
"ID" => "ID",
"Angola" => "Angola",
"Antigua" => "Antigua",
"Armenia" => "Armenia",
"Australia" => "Australia",
"Austria" => "Austria",
"Bahamas" => "Bahamas",
"Bahrain" => "Bahrain",
"Bangladesh" => "Bangladesh",
"Barbados" => "Barbados",
"Bolivia" => "Bolivia",
"Brunei" => "Brunei",
"Bulgaria" => "Bulgaria",
"Chile" => "Chile",
"China" => "China",
"Colombia" => "Colombia",
"Cuba" => "Cuba",
"Ecuador" => "Ecuador",
"Estonia" => "Estonia",
"Guam" => "Guam",
"Guatemala" => "Guatemala",
"Honduras" => "Honduras",
"India" => "India",
"Indonesia" => "Indonesia",
"Iraq" => "Iraq",
"Israel" => "Israel",
"Kenya" => "Kenya",
"Kiribati" => "Kiribati",
"Kuwait" => "Kuwait",
"Malawi" => "Malawi",
"Malta" => "Malta",
"Mozambique" => "Mozambique",
"Nauru" => "Nauru",
"Nepal" => "Nepal",
"Nicaragua" => "Nicaragua",
"Niue" => "Niue",
"Portugal" => "Portugal",
"Samoa" => "Samoa",
"Somalia" => "Somalia",
"Tonga" => "Tonga",
"Tuvalu" => "Tuvalu",
"Vanuatu" => "Vanuatu",
"Venezuela" => "Venezuela",
"Zambia" => "Zambia",
"tracker" => "tracker",
"Wiki" => "Wiki",
"Blogs" => "Blogs",
"Trackers" => "Trackers",
"blog" => "blog",
"WikiDiff Okay: LCS = %s" => "WikiDiff Okay: LCS = %s",
"Blog" => "Blog",
"Tracker" => "Tracker",
"min" => "min",
"km" => "km",
"pvs" => "pvs",
"wiki" => "wiki",
"arts" => "arts",
"blogs" => "blogs",
"max" => "max",
"Info" => "Info",
"Avatar" => "Avatar",
"Chart" => "Chart",
"Desc" => "Desc",
"URL" => "URL",
"Id" => "Id",
"Top" => "Top",
"id" => "id",
"Total" => "Total",
"d=diff" => "d=diff",
"Ip" => "Ip",
"Diff" => "Diff",
"Normal" => "Normal",
"CC" => "CC",
"BCC" => "BCC",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"Cc" => "Cc",
"phpinfo" => "phpinfo",
"[-]" => "[-]",
"Trackback pings" => "Trackback pings",
"URI" => "URI",
"RSS" => "RSS",
"avatar" => "avatar",
"PHPLayers" => "PHPLayers",
"XMLRPC API" => "XMLRPC API",
"Unix" => "Unix",
"Windows" => "Windows",
"IP" => "IP",
"PEAR::Auth" => "PEAR::Auth",
"PAM" => "PAM",
"LDAP" => "LDAP",
"Robots" => "Robots",
"Editor" => "Editor",
"Similar" => "Similar",
"DSN" => "DSN",
"bytes" => "bytes",
"x" => "x",
"Cat" => "Cat",
"Url" => "Url",
"Perso" => "Perso",
"h" => "h",
"CMS" => "CMS",
"Coms" => "Coms",
"Cacheable" => "Cacheable",
"phpLayersMenus" => "phpLayersMenus",
"Data" => "Data",
"PHP variable" => "PHP variable",
"Tiki variable" => "Tiki variable",
"bcc" => "bcc",
"+" => "+",
"Roles" => "Roles",
"%m/%d" => "%m/%d",
"URL:" => "URL:",
"editor" => "editor",
"%" => "%",
"normal" => "normal",
"idea" => "idea",
"neutral" => "neutral",
"Int" => "Int",
"Manual" => "Manual",
"#" => "#",
"inter" => "inter",
"act" => "act",
"val" => "val",
"ver:" => "ver:",
"If:SetNextact" => "If:SetNextact",
"v" => "v",
"/" => "/",
"Tikiwiki Mods" => "Tikiwiki Mods",
"Plugin" => "Plugin",
"tikiwiki.org" => "tikiwiki.org",
"Mb" => "Mb",
"top" => "top",
"Pos" => "Pos",
"Q" => "Q",
"A" => "A",
"TOP" => "TOP",
"%H:%M %Z" => "%H:%M %Z",
"tiki-mobile.php" => "tiki-mobile.php",
"unicode" => "unicode",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "Esta característica está desactivada",
"Permission denied you cannot view pages" => "Non ten permiso para ver páxinas",
"This script cannot be called directly" => "Este script non pode ser chamado directamente",
"The copyright management feature is not enabled." => "A opción de manexo de dereitos de copia non está activada.",
"No page indicated" => "Non se indica unha páxina",
"You must supply all the information, including title and year." => "Debe dar toda a información, incluíndo título e ano.",
"You do not have permission to use this feature" => "Non ten permiso para usar esta función",
"This feature is for admins only" => "Esta función é só para administradores",
"Type" => "Tipo",
"Name" => "Nome",
"Description" => "Descrición",
"Size" => "Tamaño",
"Created" => "Creada",
"Last Modified" => "Última modificación",
"Creator" => "Creador",
"Author" => "Autor",
"Comment" => "Comentario",
"Files" => "Ficheiros",
"Hits" => "Accesos",
"Locked by" => "Bloqueado por",
"Path" => "Ruta",
"Algeria" => "Alxeria",
"American Samoa" => "Samoa_Americana",
"Argentina" => "Arxentina",
"Belarus" => "Bielorrusia",
"Belgium" => "Bélxica",
"Bermuda" => "Bermudas",
"Brazil" => "Brasil",
"Canada" => "Canadá",
"Cayman Islands" => "Illas_Caimán",
"Cook Islands" => "Illas_Cook",
"Costa Rica" => "Costa_Rica",
"Croatia" => "Croacia",
"Cyprus" => "Chipre",
"Czech Republic" => "República_Checa",
"Denmark" => "Dinamarca",
"Dominican Republic" => "República_Dominicana",
"Egypt" => "Exipto",
"El Salvador" => "O_Salvador",
"Federated States of Micronesia" => "Estados_Federados_de_Micronesia",
"Fiji" => "Fixi",
"Finland" => "Finlandia",
"France" => "Francia",
"French Polynesia" => "Polinesa_Francesa",
"Germany" => "Alemaña",
"Greece" => "Grecia",
"Haiti" => "Haití",
"Hungary" => "Hungría",
"Iceland" => "Islandia",
"Iran" => "Irán",
"Ireland" => "Irlanda",
"Italy" => "Italia",
"Ivory Coast" => "Costa do Marfil",
"Jamaica" => "Xamaica",
"Japan" => "Xapón",
"Jordan" => "Xordania",
"Kazakstan" => "Kazakhistán",
"Latvia" => "Letonia",
"Lebanon" => "Líbano",
"Lithuania" => "Lituania",
"Luxemburg" => "Luxemburgo",
"Malaysia" => "Malaisia",
"Marshall Islands" => "Illas_Marshall",
"Mauritius" => "Mauricio",
"Mexico" => "México",
"Morocco" => "Marrocos",
"Netherlands" => "Holanda",
"New Caledonia" => "Nova_Caledonia",
"New Zealand" => "Nova_Zelandia",
"Nigeria" => "Nixeria",
"None" => "Ningún",
"Norway" => "Noruega",
"Other" => "Outro",
"Pakistan" => "Paquistán",
"Panama" => "Panamá",
"Papua New Guinea" => "Papúa_Nova_Guinea",
"Paraguay" => "Paraguai",
"Peru" => "Perú",
"Poland" => "Polonia",
"Puerto Rico" => "Porto_Rico",
"Quatar" => "Qatar",
"Romania" => "Romanía",
"Russia" => "Rusia",
"Russian Federation" => "Rusia",
"Saudi Arabia" => "Arabia_Saudí",
"Singapore" => "Singapur",
"Slovakia" => "Eslovaquia",
"Slovenia" => "Eslovenia",
"Solomon Islands" => "Illas_Salomón",
"South Africa" => "Sudáfrica",
"South Korea" => "Corea_do_Sur",
"Spain" => "España",
"Sri Lanka" => "Sri_Lanka",
"St Vincent Grenadines" => "San_Vincente_e_as_Granadinas",
"Surinam" => "Suriname",
"Sweden" => "Suecia",
"Switzerland" => "Suíza",
"Taiwan" => "Taiwán",
"Thailand" => "Tailandia",
"Trinidad Tobago" => "Trinidade_e_Tobago",
"Turkey" => "Turquía",
"Ukraine" => "Ucraína",
"United Arab Emirates" => "Emiratos_Árabes_Unidos",
"United Kingdom" => "Reino_Unido",
"United States" => "Estados_Unidos_de_América",
"Uruguay" => "Uruguai",
"Wales" => "Gales",
"Yugoslavia" => "Iugoslavia",
"Zimbabwe" => "Cimbabue",
"Arabic" => "Árabe",
"Catalan" => "Catalán",
"Simplified Chinese" => "Chinés simplificado",
"Chinese" => "Chinés",
"Czech" => "Checoslovaco",
"Danish" => "Danés",
"German" => "Alemán",
"English" => "Inglés",
"English British" => "Inglés británico",
"Spanish" => "Español",
"Greek" => "Grego",
"French" => "Francés",
"Hebrew" => "Hebreo",
"Croatian" => "Croata",
"Italian" => "Italiano",
"Japanese" => "Xaponés",
"Korean" => "Coreano",
"Hungarian" => "Húngaro",
"Dutch" => "Holandés",
"Norwegian" => "Noruegués",
"Polish" => "Polaco",
"Português" => "Portugués",
"Brazilian Portuguese" => "Portugués brasileiro",
"Russian" => "Ruso",
"Pijin Solomon" => "Pinyin Salomón",
"Slovak" => "Eslovaco",
"Serbian" => "Serbio",
"Serbian Latin" => "Serbio latín",
"Swedish" => "Sueco",
"Tuvaluan" => "Tuvaluano",
"Traditional Chinese" => "Chinés tradicional",
"Ukrainian" => "Ucraíno",
"This instance of activity is already complete" => "Este exemplo de actividade xa está completado",
"Fatal error: cannot execute automatic activity \$activityId" => "Erro moi grave: non podo executar a actividade automática \$activityId",
"Fatal error: setting next activity to an unexisting activity" => "Erro moi grave: poñer a seguinte actividade a unha actividade inexistente",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Erro moi grave: nextActivity non se corresponde con ningún candidato en cambio de actividade programada",
"Fatal error: non-deterministic decision for autorouting activity" => "Erro moi grave: decisión non determinista para a actividade de autoencamiñar",
"Fatal error: trying to send an instance to an activity but no transition found" => "Erro moi grave: intentando enviar un exemplar para unha actividade, pero non se atopou transición",
"Cannot add transition only split activities can have more than one outbound transition" => "Non podo engadir transición, só actividades divididas poden ter máis dunha transición saínte",
"Circular reference found some activity has a transition leading to itself" => "Referencia circular encontrada, algunha actividade ten unha transición que leva a si mesma",
"Process does not have a start activity" => "O proceso non ten ningunha actividade inicial",
"Process does not have exactly one end activity" => "O proceso non ten exactamente unha actividade final",
"End activity is not reachable from start activity" => "A actividade final non é alcanzable desde a actividade inicial",
"Activity" => "Actividade",
"is interactive but has no role assigned" => "é interactiva pero non ten rol asignado",
"is non-interactive and non-autorouted but has no role assigned" => "é non interactiva e non autoencamiñada pero non ten perfil asignado",
"is standalone but has transitions" => "é independente pero ten transicións",
"Role" => "Rol",
"is not mapped" => "non está asociada",
"Activity '.\$res['name'].' is standalone and is using the \$instance object" => "A actividade '.\$res['name'].' é independente e usa o obxecto \$instance",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "A actividade '.\$res['name'].' é interactiva, polo que ten que usar o método \$instance->complete()",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "A actividade '.\$res['name'].' é non-interactiva, polo que non debe usar o método \$instance->complete()",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "A actividade '.\$res['name'].' é cambio, polo que debe usar o método \$instance->setNextActivity(\$actname)",
"Process %d has been activated" => "O proceso %d foi activado",
"Process %d has been deactivated" => "O proceso %d foi desactivado",
"Process %s %s imported" => "Proceso %s %s importado",
"Process %s removed" => "O proceso %s foi eliminado",
"Process %s has been updated" => "O proceso %s foi actualizado",
"Process %s has been created" => "O proceso %s foi creado",
"points" => "puntos",
"Disabled" => "Desactivado",
"Plain text" => "Texto sinxelo",
"Link to user information" => "Ligazón a información de usuario",
"User avatar" => "Avatar de usuario",
"Creation date (desc)" => "Data de creación (desc)",
"Last modification date (desc)" => "Data da última modificación (desc)",
"Blog title (asc)" => "Título do blog (asc)",
"Number of posts (desc)" => "Número de artigos (desc)",
"Visits (desc)" => "Visitas (desc)",
"Activity (desc)" => "Actividade (desc)",
"Top bar" => "Barra de encabezado",
"Bottom bar" => "Barra ao pé",
"no cache" => "non cachear",
"minute" => "minuto",
"minutes" => "minutos",
"hour" => "hora",
"hours" => "horas",
"as Creator &amp; Last Editor" => "como creador e último editor",
"Business style" => "Estilo de negocios",
"Collaborative style" => "Estilo colaborativo",
"Page last modified on" => "Última modificación da páxina o",
"no (disabled)" => "non (desactivado)",
"|| for rows" => "|| para filas",
"<return> for rows" => "\\n para filas",
"Only with last version" => "Só coa última versión",
"Any 2 versions" => "Dúas versións calquera",
"complete" => "completo",
"latin" => "latino",
"english" => "inglés",
"Day" => "Día",
"Year" => "Ano",
"Saturday" => "Sábado",
"Sunday" => "Domingo",
"Monday" => "Luns",
"No error reporting" => "Sen informe de erros",
"Report all PHP errors" => "Informar todos os erros de PHP",
"Report all errors except notices" => "Informar todos os erros agás as notificacións",
"Creation Date (desc)" => "Data de creación (desc)",
"Topics (desc)" => "Temas (desc)",
"Threads (desc)" => "Fíos de discusión, (desc)",
"Last post (desc)" => "Último artigo (desc)",
"Name (desc)" => "Nome (desc)",
"Name (asc)" => "Nome (asc)",
"replace current window" => "substituír a fiestra actual",
"new window" => "nova fiestra",
"inline frame" => "marco incrustado",
"5 minutes" => "5 minutos",
"1 day" => "1 día",
"1 week" => "1 semana",
"1 month" => "1 mes",
"Allow secure (https) login" => "Permitir inicio de sesión seguro (https)",
"Require secure (https) login" => "Requirir inicio de sesión seguro (https)",
"Just Tiki" => "Só Tiki",
"Web Server" => "Servidor Web",
"Tiki and PEAR::Auth" => "Tiki e PEAR::Auth",
"Tiki and PAM" => "Tiki e PAM",
"CAS (Central Authentication Service)" => "CAS (Servizo Central de Autenticación)",
"choose a group ..." => "elixa un grupo...",
"Registered" => "Rexistrado",
"Anonymous" => "Anónimo",
"Use database to store files" => "Usar a base de datos para gardar ficheiros",
"Use a directory to store files" => "Usar un directorio para almacenar ficheiros",
"%s enabled" => "%s activado",
"%s disabled" => "%s desactivado",
"Permission denied" => "Permiso denegado",
"The file is not a CSV file or has not a correct syntax" => "O ficheiro non é un ficheiro CSV ou non ten a sintaxe correcta",
"locked" => "bloqueado",
"locked by" => "bloqueado por",
"Administration:" => "Administración:",
"in" => "en",
"continued" => "continuado",
"New Image Uploaded by" => "Nova imaxe cargada por",
"New Subscriptions" => "Nova subscrición",
"New Item in Tracker" => "Novo ítem no tracker",
"by" => "por",
"Image Gallery" => "Galería de imaxes",
"Articles" => "Artigos",
"Forums" => "Foros",
"Directory" => "Directorio",
"File Gallery" => "Galería de ficheiros",
"FAQs" => "PMF",
"Quizzes" => "Cuestionarios",
"Survey" => "Enquisa",
"Newsletter" => "Boletín",
"Charts" => "Gráficos",
"article" => "artigo",
"directory" => "directorio",
"faq" => "pmf",
"file gallery" => "galería de ficheiros",
"forum" => "foro",
"image gallery" => "galería de imaxes",
"newsletter" => "boletín",
"poll" => "votación",
"quiz" => "cuestionario",
"survey" => "enquisa",
"wiki page" => "páxina wiki",
"image" => "imaxe",
"calendar" => "calendario",
"Invalid filename (using filters for filenames)" => "Nome de ficheiro incorrecto (usando filtros para nomes de ficheiro)",
"Cannot upload this file maximum upload size exceeded" => "Non se pode cargar este ficheiro, superouse o tamaño máximo de carga",
"You have mistyped the anti-bot verification code; please try again." => "Tecleou mal o código de verificacion anti-robot; ténteo de novo.",
"Wrong password. Cannot post comment" => "Contrasinal incorrecto. Non pode publicar comentario",
"You have to enter a title and text" => "Debe introducir un título e texto",
"text" => "texto",
"WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::aplicar: conta de liñas non coincide: %s != %s",
"WikiDiff::_check: failed" => "WikiDiff::_comprobación: fallo",
"WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_comprobación: a secuencia de edición non é óptima",
"Line:" => "Liña:",
"Lines:" => "Liñas:",
"Find" => "Buscar",
"find" => "atopar",
"prev" => "ant.",
"Page" => "Páxina",
"next" => "prox.",
"Link" => "Ligazón",
"Page name" => "Nome da páxina",
"Wiki Home" => "Inicio do Wiki",
"Home" => "Inicio",
"previous page" => "páxina anterior",
"next page" => "páxina seguinte",
"posted on" => "anunciado en",
"Continue" => "Continúe",
"By:" => "Por:",
"Read" => "Ler",
"List articles" => "Listar artigos",
"Last post" => "Último artigo",
"Invalid imagename (using filters for filenames)" => "Nome de imaxe incorrecto (usando filtros para nomes de ficheiros)",
"Errors detected" => "Erros detectados",
"Upload was not successful" => "A carga non se realizou con éxito",
"No image yet, sorry." => " Síntoo, sen imaxe aínda ",
"No valid ogr2ogr executable" => "Executable ogr2ogr non válido",
"Could not create \$tdo.mif in data directory" => "Non podo crear \$tdo.mif no directorio de datos",
"Could not create \$tdo.mid in data directory" => "Non podo crear \$tdo.mid no directorio de datos",
"unknown" => "descoñecido",
"User Map Generated in:" => "Mapa de usuario xerado en:",
"Image Map Generated in:" => "Mapa de imaxe xerado en:",
"NONE" => "NINGÚN",
"File %s not found" => "Ficheiro %s non encontrado",
"File %s is not a valid archive" => "O ficheiro %s non é un arquivo válido",
"Impossible to open %s : %s" => "Imposible abrir %s : %s",
"Wiki top pages" => " páxinas Wiki máis populares",
"Most relevant pages" => "Páxinas máis relevantes",
"Relevance" => "Relevancia",
"Wiki last pages" => "últimas páxinas Wiki",
"Modified" => "Modificado",
"Forums last topics" => "Últimos temas nos foros ",
"Topic date" => "Data do tema",
"Forums last posts" => "Últimas mensaxes nos foros",
"Forums most read topics" => "asuntos máis lidos dos foros ",
"Reads" => "Lecturas",
"Forums best topics" => "Mellores asuntos dos foros ",
"Score" => "Puntuación",
"Forums most visited forums" => "Foros máis visitados",
"Visits" => "Visitas",
"Forums with most posts" => "Foros con máis mensaxes",
"Posts" => "Artigos",
"Wiki top galleries" => "galerías do Wiki máis activas",
"Wiki top file galleries" => "galerías de ficheiros Wiki máis activas",
"Wiki top images" => "imaxes Wiki máis visitadas",
"Wiki top files" => "ficheiros Wiki máis visitados",
"Downloads" => "Descargas",
"Wiki last images" => "últimas imaxes Wiki",
"Upload date" => "Data de carga",
"Wiki last files" => "últimos ficheiros Wiki ",
"Wiki top articles" => "principais artigos Wiki ",
"Most visited blogs" => "Blogs máis visitados",
"Most active blogs" => "Blogs máis activos",
"Blogs last posts" => " últimos envíos ao Blogs ",
"Post date" => "Data da mensaxe",
"Wiki top authors" => " autores de Wiki máis activos",
"Pages" => "Páxinas",
"Top article authors" => "autores dos artigos máis activos",
"User already exists" => "O usuario xa existe",
"Wrong registration code" => "Código de rexistro erróneo",
"Invalid username" => "Nome de usuario incorrecto",
"Username is too long" => "O nome do usuario é demasiado longo",
"Username cannot contain whitespace" => "O nome do usuario non pode ter espazos",
"Wrong passcode you need to know the passcode to register in this site" => "Código de paso incorrecto, necesita un código de paso válido para se rexistrar neste sitio",
"Invalid email address. You must enter a valid email address" => " Enderezo de correo incorrecto. Debe introducir un enderezo de correo válido",
"The registration mail can't be sent. Contact the administrator" => "O correo de rexistro non se pode enviar. Póñase en contacto co administrador",
"Login" => "Iniciar sesión",
"See other user's profile" => "Ver perfil doutros usuarios",
"Have your profile seen" => "Ter o seu perfil visto",
"Make friends" => "Facer amigos",
"Receive message" => "Recibir mensaxe",
"Send message" => "Enviar mensaxe",
"Read an article" => "Ler un artículo",
"Publish an article" => "Publicar un artigo",
"Have your article read" => "Ter o seu artigo lido",
"Create new file gallery" => "Crear unha nova galería de ficheiros",
"Upload new file to gallery" => "Cargar un novo ficheiro á galería",
"Download other user's file" => "Descargar un ficheiro doutro usuario",
"Have your file downloaded" => "Ter o seu ficheiro descargado",
"Create a new image gallery" => "Crear unha nova galería de imaxes",
"Upload new image to gallery" => "Cargar unha nova imaxe á galería",
"See other user's gallery" => "Ver a galería doutro usuario",
"See other user's image" => "Ver a imaxe doutro usuario",
"Have your gallery seen by other user" => "Ter a súa galería vista por outro usuario",
"Have your image seen" => "Ter a súa imaxe vista",
"Create new blog" => "Crear novo blog",
"Post in a blog" => "Publicar nun blog",
"Read other user's blog" => "Ler o blog doutro usuario",
"Have your blog read" => "Ter o seu blog lido",
"Create a new wiki page" => "Crear unha nova páxina wiki",
"Edit an existing page" => "Editar unha páxina existente",
"Attach file" => "Anexar ficheiro",
"Unknown" => "Descoñecido",
"Trackeritem" => "ítem de tracker",
"Image" => "Imaxe",
"Article" => "Artigo",
"Directory category" => "Categoría de directorio",
"FAQ" => "PMF",
"Forum" => "Foro",
"Gallery" => "Galería",
"Blog post" => "Artigo de blog",
"Prev" => "Anterior",
"Next" => "Seguinte",
"Edit Template" => "Editar modelo",
"Hide" => "Ocultar",
"help" => "axuda",
"All" => "Todos",
"The text is" => "O texto é",
"character(s) too long - please edit it." => "caracter(es) demasiado longo - por favor, edíteo.",
"Date Selector" => "Selector de data",
"Select All" => "Elixir todo",
"days" => "días",
"day" => "día",
"mins" => "minutos",
"secs" => "segs",
"done" => "listo",
"Text cut here" => "Corte o texto aquí",
"Task" => "Tarefa",
"from" => "desde",
"for" => "para",
"Priority" => "Prioridade",
"Start date:" => "Data inicial:",
"End date:" => "Data final:",
"User information - Click for more info" => "Información de Usuario - Prema para máis información",
"Friend" => "Amigo",
"Last seen on" => "Visto por última vez en",
"(idle for %s seconds)" => "(inactivo durante %s segundos)",
"More info about \$other_user" => "Máis info acerca de \$other_user",
"(idle for \$idletime seconds)" => "(inactivo durante \$idletime segundos)",
"Yes" => "Si",
"No" => "Non",
"Use this tree to copy the structure" => "Use esta árbore para copiar a estrutura",
"created from structure" => "creada desde estrutura",
"Table of contents" => "Táboa de contidos",
"unknown error" => "erro descoñecido",
"You are not logged in" => "Non iniciou a sesión",
"Page cannot be found" => "A páxina non se atopou",
"Permission denied you cannot view this section" => "Permiso denegado para acceder a esta sección",
"An error occured in a database query!" => "Ocorreu un erro nunha consulta á base de datos!",
"Help" => "Axuda",
"You are banned from" => "Está expulsado de",
"img-g" => "gal-imx",
"file-g" => "gal-arq",
"faqs" => "pmfs",
"quizzes" => "cuestionarios",
"forums" => "foros",
"games" => "xogos",
"Click to edit dynamic variable" => "Prema para editar variable dinámica",
"Update variables" => "Actualizar variables",
"Show" => "Mostrar",
"Altering database table failed" => "Alterar a táboa da base de datos fallou",
"%d points" => "%d puntos",
"Removed" => "Eliminado",
"__WARNING__: No such module \$plugin!" => "__ADVERTENCIA__: Non existe o módulo \$plugin!",
"at" => "en",
"new" => "novo",
"Create page:" => "Crear páxina:",
"Unknown language" => "Lingua descoñecida",
"Click here to confirm your action" => "Prema aquí para confirmar a súa acción",
"Sea Surfing (CSRF) detected. Operation blocked." => "Detectado Sea Surfing (CSRF). Operación bloqueada.",
"Rating" => "Cualificación",
"Item Modification" => "Modificación de ítem",
"Item" => "ítem",
"Item creation" => "Creación de ítem",
"Subject" => "Tema",
"Tracker was modified at " => "O tracker foi modificado en ",
"View the tracker item at:" => "Visualiza o ítem de tracker en:",
"text field" => "campo de texto",
"half column" => "media columna",
"size" => "tamaño",
"prepend" => "prefixar",
"append" => "sufixar",
"textarea" => "área de texto",
"checkbox" => "cela de verificación",
"numeric field" => "campo numérico",
"drop down" => "despregable",
"user selector" => "selector do usuario",
"group selector" => "selector de grupo",
"date and time" => "data e hora",
"jscalendar" => "jscalendario",
"action" => "acción",
"header" => "cabeceira",
"category" => "categoría",
"item link" => "ligazón a ítem",
"items list" => "lista de ítems",
"email" => "correo-e",
"system" => "sistema",
"attachment" => "anexo",
"open" => "aberto",
"pending" => "pendente",
"closed" => "pechado",
"Message" => "Mensaxe",
"No extra information for that attached file. " => "Non hai información extra para este ficheiro anexo.",
"child categories" => "subcategorías",
"objects in category" => "obxectos na categoría",
"(AT)" => "(EN)",
"(DOT)" => "(PUNTO)",
"Password should be at least" => "O contrasinal debe ter polo menos",
"characters long" => "caracteres",
"Password must contain both letters and numbers" => "O contrasinal debe ter letras e números",
"State" => "Estado",
"Country" => "País",
"Displays browser client info" => "Mostra as informacións do navegador do cliente",
"Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Crea unha ligazón a unha ancoraxe nunha páxina wiki. Úsese xunto co plugin ANAME, que permite definir a localización e o nome dunha ancoraxe.",
"linktext" => "texto de ligazón",
"Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Crea unha ancoraxe dentro dunha páxina wiki. Úsese xunto co plugin ALINK, que crea ligazóns á posición",
"Location" => "Localización",
"Field" => "Campo",
"Language" => "Lingua",
"Attachment" => "Anexo",
"File" => "Ficheiro",
"Show description" => "Ver descrición",
"No such attachment on this page" => "Non hai tal anexo nesta páxina",
"Displays an attachment or a list of them" => "Mostra un anexo ou unha lista deles",
"Displays the user Avatar" => "Mostra o avatar do usuario",
"username" => "nome do usuario",
"Back" => "Atrás",
"Backlinks" => "Retroligazóns",
"List all pages which link to specific pages" => "Mostra todas as páxinas que ligan con páxinas específicas",
"No pages links to" => "Ningunha páxina ten ligazón a",
"One page links to" => "Unha páxina con ligazón a",
"pages link to" => "páxinas con ligazóns a",
"Zone" => "Zona",
"Items" => "Ítems",
"Insert theme styled box on wiki page" => "Inserir un cadro co estilo da decoración na páxina wiki",
"Category" => "Categoría",
"Insert list of items for the current/given category into wiki page" => "Inserir unha listaxe de ítems para a categoría actual/fornecida na páxina wiki",
"Categories are disabled" => "As categorías están desactivadas",
"Display Tiki objects that have not been categorized" => "Amosa obxectos Tiki que non foron categorizados",
"Objects" => "Obxectos",
"Insert the full category path for each category that this wiki page belongs to" => "Inserir o camiño completo de categoría para cada categoría á que pertence esta páxina wiki",
"Center" => "Centrar",
"Centers the plugin content in the wiki page" => "Centra o contido do plugin na páxina wiki",
"title" => "título",
"Code" => "Código",
"Displays a snippet of code" => "Amosa un fragmento de código",
"code" => "código",
"note: colors and ln are exclusive" => "nota: as cores e ln son exclusivas",
"Dynamic Content" => "Contido dinámico",
"Cookie" => "Cuqui",
"Copyright" => "Dereito de copia",
"Insert copyright notices" => "Insire avisos de dereitos de copia",
"Example" => "Exemplo",
"and" => "e",
"seconds" => "segundos",
"Insert a division block on wiki page" => "Insire un bloque divisor nunha páxina wiki",
"Creates a definition list" => "Crea unha listaxe de definición",
"term" => "termo",
"definition" => "definición",
"one definition per line" => "unha definición por liña",
"drawing not found" => "debuxo non atopado",
"Events" => "Eventos",
"Upcoming events" => "Próximos eventos",
"Label" => "Etiqueta",
"Displays the data using the Tikiwiki odd/even table style" => "Amosa os datos usando o estilo de táboa par/impar de Tikiwiki",
"cells" => "celas",
"heads and cells separated by ~|~" => "cabeceiras e celas separadas por ~|~",
"Title" => "Título",
"sort" => "ordenar",
"Displays a SWF on the wiki page" => "Amosa un SWF na páxina wiki",
"failed" => "fallo",
"description" => "descrición",
"Value" => "Valor",
"Displays a graphical GAUGE" => "Amosa un medidor gráfico",
"type" => "tipo",
"Group" => "Grupo",
"HTML code" => "código HTML",
"name" => "nome",
"Image ID" => "ID de imaxe",
"Image size" => "Tamaño da imaxe",
"Img" => "Imx",
"Include" => "Incluír",
"Start" => "Comezo",
"Stop" => "Deter",
"Include a page" => "Incluír unha páxina",
"Displays the text only if the language matchs" => "Amosa o texto só se a linguaxe coincide",
"Last Modification" => "última modificación",
"List Pages" => "Listar páxinas",
"Sort" => "Ordenar",
"or" => "ou",
"Lists files in a directory" => "Lista de ficheiros nun directorio",
"Filter" => "Filtrar",
"could not be opened because it doesn't exist or permission was denied" => "non se dá aberto porque non existe ou o permiso foi denegado",
"Map" => "Asociar",
"Feature disabled" => "Opción deshabilitada",
"Style" => "Estilo",
"Module Name" => "Nome do módulo",
"Please choose a module" => "Por favor, escolla un módulo",
"to be used as argument" => "para ser usado como argumento",
"Displays a module inlined in page" => "Amosa un módulo integrado na páxina",
"Sorry no such module" => "Síntoo, non existe ese módulo",
"Font" => "Tipo de letra",
"Displays the data using a monospace font" => "Amosa os datos usando un tipo de letra monoespazada",
"Text" => "Texto",
"Sticky" => "Persistente",
"data" => "datos",
"Object" => "Obxecto",
"Days" => "Días",
"Picture" => "Imaxe",
"picture not found" => "imaxe non atopada",
"Information" => "Información",
"Provides a list of plugins on this wiki." => "Fornece unha lista de plugins neste wiki.",
"No version indicated" => "Non se indica unha versión",
"No arguments indicated" => "Non se indican argumentos",
"Poll" => "Votación",
"Displays the output of a poll, fields are indicated with numeric ids." => "Amosar a saída dunha votación, os campos están indicados con id numéricos.",
"missing poll ID for plugin POLL" => "non se atopa ID de votación para o plugin POLL",
"wrote:" => "escribiu:",
"Quote:" => "Cita:",
"Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Cita texto rodeándoo cunha caixa, como o comando [QUOTE] de BBCode",
"one data per line" => "un dato por liña",
"Search" => "Buscar",
"Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Toma unhas expresións regulares e analiza o contido entre as marcas REGEX e substitúe o texto.",
"Icon" => "Icona",
"Date" => "Data",
"Automatically creates a link to the appropriate SourceForge object" => "Crear automaticamente unha ligazón ao obxecto de Sourceforge apropiado",
"Pop-up" => "emerxente",
"Sheet Heading" => "Cabeceira da folla",
"TikiSheet" => "Folla de cálculo tiki",
"Edit Sheet" => "Editar folla",
"List wiki pages" => "Lista de páxinas wiki",
"Display" => "Mostrar",
"Last modified by" => "Última modificación por",
"Action" => "Acción",
"The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "O plugin SNARF substitúese a si mesmo co corpo HTML dunha URL. Poden facerse substitucións arbitrarias de expresión regular neste contido usando regex e regexres, o último úsase como segundo argumento a preg_replace.",
"This data is put in a CODE caption." => "Esta información ponse como unha lenda CODE.",
"Missing url parameter for SNARF plugin." => "Parámetro url ausente para o plugin SNARF.",
"Sorts the plugin content in the wiki page" => "Ordenar o contido do plugin na páxina wiki",
"Order" => "Orde",
"Split a page into rows and columns" => "Dividir unha páxina en filas e columnas",
"First" => "Primeiro",
"Edit" => "editar",
"row1col1" => "fila1col1",
"row1col2" => "fila1col2",
"row2col1" => "fila2col1",
"row2col2" => "fila2col2",
"Run a sql query" => "Executar unha consulta sql",
"sql query" => "consulta sql",
"Missing db param" => "Falta parámetro da db",
"Displays text in subscript." => "Amosar o texto como subíndice.",
"Subscribe" => "Subscribirse",
"Groups" => "Grupos",
"Thumbnail" => "Miniatura",
"Displays the thumbnail for an image" => "Amosar a miniatura para unha imaxe",
"Original" => "Orixinal",
"Search the titles of all pages in this wiki" => "Buscar os títulos de todas as páxinas neste wiki",
"No pages found for title search" => "Non se atoparon páxinas na busca por título",
"One page found for title search" => "Atopouse unha páxina na busca por título",
"pages found for title search" => "páxinas atopadas na busca por título",
"Structure ID" => "ID da estrutura",
"Public" => "Público",
"Translate" => "Traducir",
"Fields" => "Campos",
"Preview" => "previsualizar",
"preview" => "previsualizar",
"View" => "Visualizar",
"Error" => "Erro",
"Displays an input form for tracker submit" => "Amosa un tracker de entrada para enviar ao tracker",
"Fields marked with a * are mandatory." => "Os campos marcados cun * son obrigatorios.",
"Status" => "Estado",
"Displays the output of a tracker content, fields are indicated with numeric ids." => "Amosa a saída do contido dun tracker; os campos indícanse con id numéricos.",
"Template" => "Modelo",
"Mode" => "Modo",
"Error in tracker ID" => "Erro no ID do tracker",
"No field indicated" => "Non se indicou campo",
"Links to a translated content" => "Ligazóns a contido traducido",
"Flag" => "Marca ",
"Displays the number of registered users" => "Amosa o número de usuarios rexistrados",
"User List" => "Lista de usuarios",
"users" => "usuarios",
"Preferences" => "Preferencias",
"User Information" => "Información do usuario",
"Versions" => "Versións",
"Split the text in parts visible only under some conditions" => "Dividir o texto en partes visibles só baixo certas condicións",
"Vote" => "votar",
"Table" => "Táboa",
"External Wiki" => "Wiki externo",
"valid" => "válido",
"width" => "anchura",
"height" => "altura",
"ERROR: Either the subject or body must be non-empty" => "ERRO: o tema ou o corpo non poden quedar baleiros",
"ERROR: No valid users to send the message" => "ERRO: ningún usuario válido para lle enviar a mensaxe",
"Invalid user" => "Usuario incorrecto",
"Message sent to" => "Mensaxe enviada a",
"Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "A carpeta de enviadas está chea. Arquive ou borre algunhas mensaxes enviadas se quere enviar máis mensaxes.",
"User %s can not receive messages, mailbox is full" => "O usuario %s non pode recibir mensaxes, a caixa de correo está chea",
"User %s can not receive messages" => "O usuario %s non pode recibir mensaxes",
"Invalid user: %s" => "Usuario incorrecto: %s",
"Message will be sent to: " => "A mensaxe enviarase a: ",
"Archive is full. Delete some messages from archive first." => "Arquivo cheo. Borre primeiro algunhas mensaxes do arquivo.",
"No more messages" => "Non hai máis mensaxes",
"Tiki Calendar" => "Calendario Tiki",
"Calendar" => "Calendario",
"Please provide an Id" => "Por favor, introduza un Id",
"no object here yet" => "aínda non hai obxectos aquí ",
"Create/Edit" => "Crear/editar",
"Quick Edit a Wiki Page" => "Edición rápida de páxina wiki",
"Post" => "Publicar",
"Changes since" => "Cambios desde",
"new comments" => "comentarios novos",
"wiki pages changed" => "páxinas do wiki modificadas",
"new articles" => " artigos novos ",
"new FAQs" => "novas PMF",
"new blogs" => "blogs novos",
"new blog posts" => "novos artigos no blog",
"new image galleries" => "novas galerías de imaxes",
"new images" => "imaxes novas",
"new file galleries" => "novas galerías de ficheiros",
"new files" => "novos ficheiros",
"new polls" => "votacións novas ",
"new users" => "usuarios novos",
"The task title must have at least 3 characters" => "O título da tarefa debe ter polo menos tres caracteres",
"Invalid username or password" => "Usuario ou contrasinal incorrectos",
"country" => "país",
"Anti-Bot verification code" => "Código de verificación anti-robot",
"Random Image" => "Imaxe ao chou",
"Enter the code you see above" => "Introduza o código que ve arriba",
"List of attached files" => "Lista de ficheiros anexos",
"desc" => "descrición",
"uploaded" => "cargado",
"Download" => "Descargar",
"Delete" => "Borrar",
"Remove" => "Borrar",
"Upload file" => "Cargar ficheiro",
"Attach" => "Anexar",
"Attach a file to this item" => "Anexar un ficheiro a este ítem",
"Version" => "Versión",
"Attachments" => "Anexos",
"more info" => "máis información",
"No attachments for this item" => "Non hai anexos a este ítem",
"debug" => "depurar",
"Fatal error" => "Erro moi grave",
"Created by" => "Creado por",
"on" => "en",
"RSS feed" => "Fonte RSS",
"Edit blog" => "Editar blog",
"Monitor this Blog" => "Monitorizar este blog",
"Stop Monitoring this Blog" => "Deixar de monitorizar este blog",
"Activity=" => "Actividade=",
"Actions" => "Accións",
"Properties" => "Propiedades",
"No records found" => "Non se atoparon rexistros",
"Categorize" => "Categorizar",
"Admin Categories" => "Administrar categorías",
"No categories defined" => "Non se definiron categorías",
"Browse Category" => "Navegar na categoría",
"posts:" => "artigos",
"stars" => "estrelas",
"User Level" => "Nivel de usuario",
"private message" => "mensaxe privada",
"Send eMail to User" => "Enviar correo a usuario",
"user online" => "usuario en liña",
"user offline" => "usuario fóra de liña",
"Reply" => "Responder",
"Approve" => "Aprobar",
"Reject" => "Rexeitar",
"Save to notepad" => "Gardar no caderno de notas",
"Monitor this Topic" => "Monitorizar este tema",
"Stop Monitoring this Topic" => "Deixar de monitorizar este tema",
"Moderator actions" => "Accións do moderador",
"reported:" => "enviado:",
"queued:" => "na cola:",
"Move to topic:" => "Mover ao tema:",
"Move" => "Mover",
"Delete Selected" => "Borrar seleccionados",
"Unlock" => "Desbloquear",
"Lock" => "Bloquear",
"Messages" => "Mensaxes",
"Plain" => "Sinxelo",
"Threaded" => "Fío argumental",
"Headers Only" => "Só cabeceiras",
"Newest first" => "Primeiro os máis novos",
"Oldest first" => "Primeiro os máis vellos",
"Title (desc)" => "Título (desc)",
"Title (asc)" => "Título (asc)",
"Threshold" => "Límite mínimo",
"Set" => "Poñer",
"Replies" => "Respostas",
"below your current threshold" => "por baixo do teu límite actual",
"New Reply" => "Nova resposta",
"Editing reply" => "Editar resposta",
"Reply to the selected post" => "Responder ao artigo seleccionado",
"Editing comment" => "Editando comentario",
"Comment on the selected post" => "Comentar no artigo seleccionado",
"Post new comment" => "Publicar novo comentario",
"Smileys" => "Emoticonas",
"Quicktags" => "Etiquetas rápidas",
"Reply to parent post" => "Responder ao artigo pai",
"Post new reply" => "Publicar unha resposta nova",
"Cancel" => "Cancelar",
"Posting replies" => "Publicar respostas",
"Posting comments" => "Publicar comentarios",
"Use" => "Usar",
"for links" => "para ligazóns",
"HTML tags are not allowed inside posts" => "As etiquetas HTML non están permitidas dentro dos envíos",
"Add Comment" => "Engadir comentario",
"1 comment" => "1 comentario",
"Comments" => "Comentarios",
"Go back" => "Atrás",
"Return to home page" => "Volver ao inicio",
"Copyrights" => "Dereitos de copia",
"Authors" => "Autores",
"Add" => "Engadir",
"Syntax" => "Sintaxe",
"Page generation debugging log" => "Rexistro de depuración de xeración de páxina",
"Features state" => "Estado das características",
"features matched" => "características coincidentes",
"Watchlist" => "Lista de monitores",
"duplicate" => "duplicado",
"There are individual permissions set for this file gallery" => "Hai permisos individuais configurados para esta galería de ficheiros",
"Save" => "Gardar",
"Gallery is visible to non-admin users?" => "Galería visible para usuarios non-administradores?",
"unlimited" => "ilimitado",
"none" => "ningún",
"Parent gallery" => "Galería superior",
"Default sort order" => "Orde por defecto",
"descending" => "descendente",
"ascending" => "ascendente",
"Max description display size" => "Tamaño máximo de visualización da descrición",
"Max Rows per page" => "Cantidade máxima de filas por páxina",
"Listing configuration" => "Configuración de listaxe",
"Please login" => "Por favor, inicie a sesión",
"There are no wiki pages similar to '{\$page}'" => "Non hai páxinas wiki similares a '{\$page}'",
"Create this page" => "Crear esta páxina",
"(page will be orphaned)" => "(a páxina quedará orfa)",
"Close Window" => "Pechar fiestra",
"Active Perms" => "Permisos activos",
"Perms" => "Permisos",
"Replace" => "Substituír",
"List" => "Listar",
"Browse" => "Navegar",
"Name-filename" => "Nome-Nome de ficheiro",
"Filename only" => "Só nome de ficheiro",
"Close" => "Pechar",
"Exact&nbsp;match" => "Correspondencia&nbsp;exacta",
"Number of displayed rows" => "Número de filas mostradas",
"Go" => "Ir",
"in:" => "en:",
"RSS Wiki" => "RSS de Wiki",
"RSS Blogs" => "RSS de blogs",
"RSS Articles" => "RSS Artigos",
"RSS Image Galleries" => "RSS Galerías de Imaxes",
"RSS File Galleries" => "RSS Galerías de Ficheiros",
"RSS Forums" => "RSS Foros",
"RSS Maps" => "RSS Mapas",
"RSS Directories" => "RSS Directorios",
"Perform action with checked:" => "Executar acción cos marcados:",
"Move Selected Files" => "Mover ficheiros seleccionados",
"Assign Permissions" => "Asignar permisos",
"Move to" => "Mover a",
"Assign" => "Asignar",
"Filename" => "Nome de ficheiro",
"Hi {\$mail_user} has sent you this link:" => "Ola {\$mail_user} envioulle esta ligazón:",
"Blog post:" => "Artigo de blog:",
"at:" => "en:",
"Somebody or you tried to subscribe this email address at our site:" => "Alguén ou vostede tentou subscribir este enderezo de correo no noso sitio:",
"To the newsletter:" => "Ao boletín:",
"Description:" => "Descrición:",
"In order to confirm your subscription you must access the following URL:" => "Para confirmar a súa subscrición debe acceder ao seguinte URL:",
"A new message was posted to forum" => "Unha nova mensaxe foi posta no foro",
"New topic:" => "Novo tema:",
"Topic:" => "Tema:",
"You sent a request with the subject:" => "Enviou unha solicitude co tema:",
"Use the subject to indicate the operation to apply:" => "Use o tema para indicar a operación que vai aplicar:",
"GET:WikiName to get a wiki page" => "GET:WikiName para obter unha páxina wiki",
"PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName para actualizar/crear unha páxina wiki (use o corpo para o contido da páxina",
"APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName para agregar datos a unha páxina Wiki (use o corpo para o contido que vai agregar)",
"PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName para agregar contido ao principio",
"Tiki mail-in instructions" => "Instrucións da entrada de correo de Tiki",
"Tiki mail-in auto-reply." => "Auto-resposta da entrada de correo Tiki.",
"Page not found:" => "Páxina non atopada:",
"Hi," => "Ola,",
"A new message was posted to you at {\$mail_machine}" => "Foiche enviada unha nova mensaxe en {\$mail_machine}",
"From" => "Desde",
"New message arrived from %s" => "Nova mensaxe recibida desde %s",
"Hi" => "Ola",
"Enjoy the site!" => "Goce do sitio!",
"has requested an account on" => "solicitou unha conta en",
"To validate that account, please follow the link:" => "Para validar esa conta, siga a ligazón, por favor:",
"best regards" => "da nosa maior consideración",
"your Tikiwiki" => "o seu Tikiwiki",
"User Registration Request" => "Solicitude de rexistro de usuario Tiki",
"You're invited to join my network of friends!" => "Está invitado a unirse ao meu círculo de amigos!",
"The user" => "O usuario",
"registered at your site" => "rexistrouse no seu sitio",
"New user registration" => "Rexistro de novo usuario",
"Bye bye!" => "Ata logo!",
"This email address has been removed to the list of subscriptors of:" => "Este enderezo de correo foi borrado da lista dos subscritores de:",
"Newsletter:" => "Boletín:",
"Bye bye from %s at %s" => "Ata logo desde  %s en %s",
"You can unsubscribe from this newsletter following this link" => "Pode cancelar a subscrición deste boletín seguindo esta ligazón",
"Welcome to our newsletter!" => "Benvido ao noso boletín!",
"This email address has been added to the list of subscriptors of:" => "Este enderezo de correo foi engadido á lista de subscritores de:",
"You can always cancel your subscription using:" => "Pode cancelar a súa subscrición en calquera momento usando:",
"Welcome to %s at %s" => "Benvido a %s en %s",
"Email notification" => "Notificación de correo do Tiki",
"Since this is your registered email address we inform that the password for this account is" => "Xa que este é o seu enderezo de correo-e rexistrado, informámolo de que a clave para esta conta é",
"Your account information for %s" => "A súa información de conta Tiki para %s",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Un novo artigo enviado por {\$mail_user} a {\$mail_site} en {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "Pode editar o envío seguindo esta ligazón:",
"Title:" => "Título:",
"Heading:" => "Encabezado:",
"Body:" => "Corpo:",
"New article submitted at %s" => "Novo artigo enviado a %s",
"User:" => "Usuario:",
"You or someone registered this email address at" => "vostede ou alguén rexitrou este enderezo de correo en",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Se quere ser un usuario rexistrado neste sitio, debe seguir a seguinte ligazón para iniciar a sesión por primeira vez:",
"Your registration confirmation" => "A súa información de rexistro no Tiki",
"You will receive an email with information to login for the first time into this site" => "Recibirá un correo con información para iniciar sesión por primeira vez neste sitio",
"Your account request has been stored and will be activated by the admin as soon as possible." => "A súa solicitude de conta foi almacenado e será activado polo administrador o máis axiña posible.",
"View the article at:" => "Visualizar o artigo en:",
"If you don't want to receive these notifications follow this link:" => "Se non desexa recibir estas notificacións, siga esta ligazón:",
"View the blog at:" => "Visualizar o blog en:",
"New blog post at %s" => "Novo artigo no blog en %s",
"changed" => "modificado",
"created" => "creado",
"Removed by" => "Borrado por",
"New" => "Novo",
"File Gallery %s changed" => "Galería de Ficheiros %s cambiada",
"A file was removed from the file gallery" => "Un ficheiro foi borrado da galería de ficheiros",
"File Name" => "Nome do ficheiro",
"A new file was posted to file gallery" => "Un novo ficheiro foi cargado na galería de ficheiros",
"Posted by" => "Enviado por",
"File Description" => "Descrición do ficheiro",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "O mapa {\$mail_page} foi cambiado por {\$mail_user} en {\$mail_date|tiki_short_datetime}",
"You can view the updated map following this link:" => "Pode ver o mapa actualizado seguindo esta ligazón:",
"You can edit the map following this link:" => "Pode editar o mapa seguindo esta ligazón:",
"The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "A páxina {\$mail_page} foi creada por {\$mail_user} en {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "A páxina {\$mail_page} foi modificada por {\$mail_user} en {\$mail_date|tiki_short_datetime}",
"Comment:" => "Comentario:",
"You can view the page by following this link:" => "Pode visualizar a páxina seguindo esta ligazón:",
"You can view a diff back to the previous version by following this link:" => "Pode ver os cambios con respecto ás versións anteriores seguindo a seguinte ligazón:",
"The changes in this version follow below, followed after by the current full page text." => "Os cambios nesta versión seguen abaixo, seguidos do texto completo actual.",
"-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Liñas: {\$oldd} cambiadas a +Líneas: {\$newd}",
"The new page content follows below." => "O contido novo da páxina segue abaixo.",
"The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "A páxina {\$mail_page} foi comentada por {\$mail_user} en {\$mail_date|tiki_short_datetime}",
"New name" => "Novo nome",
"click on the map to zoom or pan, do not drag" => "prema no mapa para ampliar a panorámica, non arrastre",
"Scale" => "Escala",
"Query" => "Consulta",
"Pan" => "Panorámica",
"Redraw" => "Redebuxar",
"select zoom/pan/query and image size" => "seleccionar zoom/pan/consulta e tamaño da imaxe",
"View the Map Only" => "Ver só o mapa",
"Reset Map" => "Reiniciar o mapa",
"Click on the map or click redraw" => "Prema no mapa ou en redebuxar",
"Last modification date" => "Data da última modificación",
"Overview" => "Resumo",
"Legend" => "Lenda",
"Layer Manager" => "Xestor de Capas",
"Layer" => "Capa",
"On" => "En",
"Download Layer" => "Descargar capa",
"This layer has been set by the maps administrator to not be downloadable" => "Esta capa foi configurada polo administrador de mapas como non descargable",
"you have requested to download the layer:" => "solicitou descargar a capa:",
"Here are the files to download, do not forget to rename them:" => "Aquí están os ficheiros para descargar, non esqueza renomealos:",
"Mapfiles" => "Ficheiros de mapas",
"Mapfile" => "Ficheiro de mapa",
"Available mapfiles" => "Ficheiro de mapa dispoñibles",
"monitor this map" => "monitorizar este mapa",
"Stop Monitoring this Map" => "Deixar de monitorizar este mapa",
"Create a new mapfile" => "Crear un novo ficheiro de mapa",
"Create" => "Crear",
"Mapfile listing" => "Listaxe de ficheiros de mapa",
"Reload" => "Recargar",
"History" => "Historial",
"You can view this map in your browser using" => "Pode ver este mapa no seu navegador usando",
"Zoom out x2" => "Reducir x2",
"Zoom in x2" => "Ampliar x2",
"Mapfile History" => "Historia do ficheiro de mapa",
"of" => "de",
"Compare" => "Comparar",
"Comparing version {\$old.version} with version {\$new.version}" => "Comparar a versión {\$old.version} coa versión {\$new.version}",
"Version:" => "Versión:",
"Current" => "Actual",
"Versions are identical" => "As versións son idénticas",
"Legend:" => "Lenda:",
"v=view" => "v=ver",
"c=compare" => "c=comparar",
"Full side-by-side diff" => "diferenzas lado a lado completo",
"Unified diff" => "diferenzas unificadas",
"Side-by-side view" => "Vista lado a lado",
"User" => "Usuario",
"Older Version" => "Versión máis antiga",
"Directories" => "Directorios",
"back to" => "volver a",
"Upload From Disk:" => "Cargar desde disco:",
"Upload Files" => "Cargar ficheiros",
"Bytes maximum" => "Máximo de bytes",
"Create Directory:" => "Crear directorio:",
"index file (.shp):" => "ficheiro índice (.shp):",
"files to index (regexp):" => "ficheiros para indexar (regexp):",
"Message Archive" => "Arquivo de mensaxe",
"messages" => "mensaxes",
"Archive is full!" => "O arquivo está cheo!",
"Unread" => "Non lidos",
"Flagged" => "Marcado",
"Unflagged" => "Desmarcado",
"Containing" => "Contendo",
"Sender" => "remitente",
"No messages to display" => "Sen mensaxes para mostrar",
"Broadcast message" => "Mensaxe de difusión",
"OK" => "Correcto",
"All users" => "Todos os usuarios",
"Lowest" => "Mínimo",
"Low" => "Baixo",
"High" => "Alto",
"Very High" => "Superior",
"Send" => "Enviar",
"Compose message" => "Escriba unha mensaxe",
"Invalid" => "Incorrecto",
"To" => "Para",
"No messages to download" => "Sen mensaxes para descargar",
"Mailbox is full! Delete or archive some messages if you want to receive more messages." => "A caixa de correo está chea! Borre ou arquive algunhas mensaxes se quere recibir novas mensaxes.",
"Find replied message" => "buscar mensaxe respondida",
"Archive" => "Arquivo",
"Mark as read" => "Marcar como lido",
"Mark as unread" => "Marcar como non lido",
"Mark as flagged" => "Marcar",
"Mark as unflagged" => "Desmarcar",
"Mark" => "marcar",
"Mailbox" => "caixa de correo",
"Compose" => "Compoñer",
"Broadcast" => "Difusión ampla",
"Sent" => "Enviada",
"Auto-archive age for read messages:" => "Tempo de autoarquivado para mensaxes lidas",
"Read message" => "Ler mensaxe",
"Return to mailbox" => "Volver á caixa de correo",
"replyall" => "responder a todos",
"Unflag" => "Desmarcar",
"Flag this message" => "Marcar esta mensaxe",
"Return to archive" => "Volver ao arquivo",
"Return to outbox" => "Volver á caixa de saída",
"Sent Messages" => "Mensaxes enviadas",
"Replied" => "Respondido",
"Not replied" => "Non respondido",
"move to archive" => "mover a arquivo",
"receiver" => "receptor",
"'name' parameter for tikimodule missed" => "falta o parámetro 'name' para tikimodule",
"Move module up" => "Mover módulo arriba",
"Up" => "Subir",
"Move module down" => "Mover módulo abaixo",
"Down" => "Baixar",
"Move module to opposite side" => "Mover módulo para o lado oposto",
"opp side" => "lado oposto",
"Unassign this module" => "Inhabilitar este módulo",
"Are you sure you want to unassign this module?" => "¿Está seguro de que quere inhabilitar este módulo?",
"Admin Menu" => "Administrar menú",
"Live Support" => "Asistencia en liña",
"Banning" => "Expulsión",
"Users" => "Usuarios",
"Cache" => "Caché",
"Modules" => "Módulos",
"Links" => "Ligazóns",
"Hotwords" => "Palabras clave",
"RSS Modules" => "módulos RSS",
"Menus" => "Menús",
"Polls" => "Votacións",
"Mail Notifications" => "Notificacións por correo",
"Search Stats" => "Estatísticas de busca",
"QuickTags" => "Etiquetas rápidas",
"Chat" => "Charla",
"Categories" => "Categorías",
"Banners" => "Pancartas",
"Edit Templates" => "Editar modelos",
"Cookies" => "Cuquis",
"Mail-in" => "Entrada de correo",
"HTML Pages" => "Páxinas HTML",
"Shoutbox" => "Taboleiro de avisos ",
"Shoutbox Words" => "Palabras do taboleiro de avisos",
"Referer Stats" => "Estatísticas de referentes",
"Import PHPWiki Dump" => "Importar envorcado PHPWiki",
"Admin dsn" => "Administrar dsn",
"Security Admin" => "Administrar seguridade",
"Tikiwiki Assistant" => "Asistente Tikiwiki",
"Thank you for installing Tikiwiki" => "Grazas por instalar Tikiwiki",
"Select" => "Seleccionar",
"Admin" => "Administrar",
"Admin Modules" => "Administrar módulos",
"Admin Menus" => "Administrar menús",
"login" => "iniciar sesión",
"Recently visited pages" => "Páxinas recentemente visitadas",
"January" => "Xaneiro",
"February" => "Febreiro",
"March" => "Marzo",
"April" => "Abril",
"May" => "Maio",
"June" => "Xuño",
"July" => "Xullo",
"August" => "Agosto",
"September" => "Setembro",
"October" => "Outubro",
"November" => "Novembro",
"December" => "Decembro",
"Tuesday" => "Martes",
"Wednesday" => "Mércores",
"Thursday" => "Xoves",
"Friday" => "Venres",
"Today" => "Hoxe",
"Received objects" => "Obxectos recibidos",
"Pages:" => "Páxinas:",
"Last `\$module_rows` Sites" => "Últimos `\$module_rows` sitios",
"Last Sites" => "Últimos sitios",
"Directory Stats" => "Estatísticas de directorio",
"Sites" => "Sitios",
"Sites to validate" => "Sitios para validar",
"Searches" => "Buscas",
"Visited links" => "Ligazóns visitadas",
"Top \$module_rows Sites" => "\$module_rows principais sitios",
"Top Sites" => "Sitios máis visitados",
"Featured links" => "Ligazóns destacadas",
"Top `\$module_rows` topics" => "`\$module_rows` principais temas",
"Top topics" => "Temas principais",
"Last `\$module_rows` forum posts" => "Últimos `\$module_rows` artigos no foro",
"Last forum posts" => "Últimos artigos no foro",
"Last `\$module_rows` forum topics" => "Últimos `\$module_rows` temas en foros",
"Last forum topics" => "Últimos temas en foros",
"Most commented forums" => "Foros con máis mensaxes",
"Most read topics" => "Temas máis lidos",
"Most visited forums" => "Foros máis visitados",
"Google Search" => "Buscar en Google",
"Last `\$module_rows` actions" => "Últimas `\$module_rows` accións",
"Last actions" => "Últimas accións",
"Last `\$module_rows` articles" => "Últimos `\$module_rows` artigos",
"Last articles" => "Últimos artigos",
"Last `\$module_rows` blog posts" => "Últimos `\$module_rows` artigos ao blog",
"Last blog posts" => "Últimos artigos nos blogs",
"Last" => "Último",
"Last `\$module_rows` Created blogs" => "Últimos `\$module_rows` blogs creados",
"Last Created blogs" => "Últimos blogs creados",
"Last `\$module_rows` Created FAQs" => "Últimas `\$module_rows` PMF creadas",
"Last Created FAQs" => "Últimas PMF creadas",
"Last `\$module_rows` Created Quizzes" => "Últimos `\$module_rows` cuestionarios creados",
"Last Created Quizzes" => "Últimos cuestionarios",
"Last `\$module_rows` modified file galleries" => "Últimas `\$module_rows` galerías de ficheiros modificadas",
"Last modified file galleries" => "Galerías de ficheiros modificadas recentemente",
"Last `\$module_rows` Files" => "Últimos `\$module_rows` ficheiros",
"Last Files" => "Últimos ficheiros",
"Last `\$module_rows` galleries" => "Últimas `\$module_rows` galerías",
"Last galleries" => "Últimas galerías",
"Last `\$module_rows` Images" => "Últimas `\$module_rows` imaxes",
"Last Images" => "Últimas imaxes",
"Last `\$module_rows` modified events" => "Últimos `\$module_rows` eventos modificados",
"Last modifed events" => "Últimos eventos modificados",
"Last `\$module_rows` changes" => "Últimos `\$module_rows` cambios",
"Last changes" => "Últimas modificacións",
"Last `\$module_rows` Modified Items" => "Últimos `\$module_rows` ítems modificados",
"Last Modified Items" => "Ítems recentemente modificados",
"Last `\$module_rows` Modified blogs" => "Últimos `\$module_rows` blogs modificados",
"Last Modified blogs" => "Blogs recentemente modificados",
"Last `\$module_rows` submissions" => "Últimas `\$module_rows` colaboracións",
"Last submissions" => "Últimas colaboracións",
"Last `\$module_rows` Items" => "Últimos `\$module_rows` ítems",
"Last Items" => "Últimos ítems",
"Last `\$module_rows` visitors" => "Últimos `\$module_rows` visitantes",
"Last Visitors" => "Últimos visitantes",
"Register" => "Rexistrarse",
"Live support" => "Asistencia en liña",
"Open operator console" => "Abrir consola de operador",
"Online users" => "Usuarios en liña",
"We have" => "Temos",
"online users" => "usuarios en liña",
"Logout" => "Finalizar sesión",
"Switch" => "Cambiar",
"Login through CAS" => "Entrada con CAS",
"Login as admin" => "Iniciar sesión como admin",
"Email" => "Correo-e",
"eMail" => "Correo-e",
"Password" => "Contrasinal",
"Remember me" => "Lembrarme",
"week" => "semana",
"month" => "mes",
"year" => "ano",
"Click here to register" => "Prema aquí para rexistrarse",
"Click here if you've forgotten your password" => "Prema aquí se esqueceu o seu contrasinal",
"I forgot my password" => "Esquecín o meu contrasinal",
"Click here to login using the default security protocol" => "Prema aquí para iniciar sesión usando o protocolo por defecto de seguridade",
"Standard" => "Estándar",
"Click here to login using a secure protocol" => "Prema aquí para iniciar sesión usando un protocolo seguro",
"Secure" => "Seguro",
"Stay in ssl Mode" => "Permanecer en modo ssl",
"Tiki Logo" => "Logo Tiki",
"Menu" => "Menú",
"You have" => "Ten",
"New Messages" => "Novas mensaxes",
"New Message" => "Nova mensaxe",
"You have 0 new messages" => "Ten 0 mensaxes novas",
"Waiting Submissions" => "Colaboracións en espera",
"submissions waiting to be examined" => "colaboracións esperando ser examinadas",
"Old articles" => "Artigos antigos",
"Send a message to" => "Enviar unha mensaxe a",
"Random Pages" => "Páxinas ao chou",
"Register as a new user" => "Rexistarse como un novo usuario",
"Your email could not be validated; make sure you email is correct and click register below." => "O seu correo non pode ser validado; asegúrese de que o seu correo é correcto e prema en rexistrarse abaixo.",
"Your registration code:" => "O seu código de rexistro:",
"Username" => "Usuario",
"Passcode to register (not your user password)" => "Código para rexistrarse (non o seu contrasinal de usuario)",
"Registration code" => "Código de rexistro",
"Repeat password" => "Repetir contrasinal",
"Generate a password" => "Xerar un contrasinal",
"Wiki RSS" => "RSS de Wiki ",
"Blogs RSS" => "RSS de blogs ",
"Articles RSS" => "Artigos RSS",
"Image Galleries RSS" => "Galerías de Imaxes RSS",
"Image Galleries" => "Galerías de imaxes",
"File Galleries RSS" => "Galerías de Ficheiros RSS",
"File Galleries" => "Galerías de ficheiros",
"Forums RSS" => "Foros RSS",
"Maps RSS" => "Mapas RSS",
"Maps" => "Mapas",
"Entire Site" => "Sitio completo",
"Wiki Pages" => "Páxinas do wiki",
"Image Gals" => "Gals. de Imaxes",
"Images" => "Imaxes",
"Blog Posts" => "Artigos de blog",
"Search Wiki PageName" => "Buscar nome páxina Wiki",
"Read More" => "Ler máis",
"Since your last visit" => "Desde a súa última visita",
"Since your last visit on" => "Desde a súa última visita en",
"New Images" => "Imaxes novas",
"Wiki Pages Changed" => "Páxinas do wiki modificadas",
"New Files" => "Novos ficheiros",
"New Comments" => "Comentarios novos",
"New Users" => "Usuarios novos",
"click to edit" => "clic para editar",
"Theme" => "Decoración",
"Most Active blogs" => "Blogs máis activos",
"Top `\$module_rows` articles" => "Mellores`\$module_rows` artigos",
"Top articles" => "Artigos máis lidos",
"Top `\$module_rows` File Galleries" => "`\$module_rows` principais galerías de ficheiros",
"Top File Galleries" => "Galerías de ficheiros máis visitadas",
"Top `\$module_rows` files" => "`\$module_rows` principais ficheiros",
"Top files" => "Ficheiros principais",
"Top `\$module_rows` Forum Posters" => "Principais `\$module_rows` participantes en Foros",
"Top Forum Posters" => "Principais participantes en foros",
"Top `\$module_rows` games" => "`\$module_rows` xogos principais",
"Top games" => "Xogos principais",
"Top `\$module_rows` galleries" => "`\$module_rows` Galerías principais ",
"Top galleries" => "Galerías principais",
"Top `\$module_rows` Images" => "`\$module_rows` Imaxes principais",
"Top Images" => "Imaxes principais",
"Top `\$module_rows` Pages" => "`\$module_rows` Páxinas principais",
"Top Pages" => "Páxinas principais",
"Top `\$module_rows` Quizzes" => "`\$module_rows` Cuestionarios principais",
"Top Quizzes" => "Cuestionarios principais",
"Most `\$module_rows` visited blogs" => "`\$module_rows` blogs máis visitados",
"Top `\$module_rows` Visited FAQs" => "`\$module_rows` PMF máis visitadas",
"Top Visited FAQs" => "PMF máis visitadas",
"view" => "visualizar",
"click to view" => "premer para ver",
"My blogs" => "Os meus blogs",
"Bookmarks" => "Marcadores",
"My galleries" => "As miñas galerías",
"My Pages" => "As miñas páxinas",
"User tasks" => "Tarefas de usuario",
"Done" => "listo",
"Del" => "Borrar",
"Public tasks" => "Tarefas públicas",
"select" => "seleccionar",
"User informations" => "Informacións do usuario",
"Group informations" => "Información do grupo",
"Top users" => "Usuarios principais",
"Whats related" => "O que está relacionado",
"online user" => "usuario en liña",
"Last `\$module_rows` wiki comments" => "Últimos `\$module_rows` comentarios wiki",
"Last wiki comments" => "Últimos comentarios wiki",
"on page" => "a páxina",
"Real Name" => "Nome real",
"vote" => "votar",
"Send Newsletter" => "Enviar boletín",
"Structures:" => "Estruturas:",
"show structures" => "mostrar estruturas",
"hide structures" => "ocultar estruturas",
"Manage structures" => "Manexar estruturas",
"Location : " => "Localización: ",
"Find:" => "Atopar:",
"pages" => "páxinas",
"To edit the copyright notices" => "Para editar os avisos de dereitos de copia",
"Click Here" => "Faga clic aquí",
"The content on this page is licensed under the terms of the" => "O contido desta páxina está licenciado baixo os termos do",
"Print" => "Imprimir",
"Email This Post" => "mandar mensaje con este post",
"Permalink" => "Ligazón permanente",
"comment" => "comentario",
"comments" => "comentarios",
"First page" => "Primeira páxina",
"Previous page" => "Páxina anterior",
"page" => "páxina",
"Next page" => "Páxina seguinte",
"Last page" => "Última páxina",
"referenced by" => "referenciado por",
"references" => "referencias",
"View Comments" => "Ver comentarios",
"Blog name" => "Nome do blog",
"Enlarge area height" => "Ampliar a altura da área",
"Reduce area height" => "Reducir a altura da área",
"Calendar View" => "Vista de calendario",
"List View" => "Visualizar lista",
"Tools Calendars" => "Ferramentas de calendarios",
"Check / Uncheck All" => "Marcar / desmarcar todos",
"Refresh" => "Actualizar",
"Tip" => "Consello",
"Cancel Edit" => "Cancelar a edición",
"Change preferences" => "Cambiar preferencias",
"Site Ads and Banners" => "Publicidade e pancartas do sitio",
"Content" => "Contido",
"Activate" => "Activar",
"Publish" => "Publicar",
"General" => "Xeral",
"Features" => "Características",
"Module" => "Módulo",
"Meta Tags" => "meta etiquetas",
"Community" => "Comunidade",
"User files" => "Ficheiros de usuario",
"Webmail" => "Correo web",
"Wysiwyg editor" => "Editor wysiwyg",
"To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "Para agregar/borrar blogs, vaia a \"Crear/Editar blog\" en \"Blogs\" no menú de aplicación, ou ",
"General Settings" => "Configuracións xerais",
"Home Blog (main blog)" => "Blog inicial (blog principal)",
"Rankings" => "Clasificacións",
"Not Installed" => "Non instalado",
"Points" => "Puntos",
"Creation date" => "Data de creación",
"Last modified" => "Última modificación",
"Change settings" => "Cambiar configuración",
"Permissions" => "Permisos",
"Ignore category viewing restrictions" => "Ignorar restricións de visualización de categoría",
"Look under \"Articles\" on the application menu for links to" => "Busque en \"Artigos\" no menú de aplicación para ligazóns a",
"Topic" => "Tema",
"Submissions" => "Colaboracións",
"Import CSV file" => "Importar ficheiro CSV",
"Import" => "Importar",
"Visible" => "visible",
"Number of friends" => "Número de amigos",
"E-mail" => "Correo electrónico",
"Last login" => "Última conexión",
"Distance" => "Distancia",
"default" => "por defecto",
"Number of visited pages to remember" => "Cantidade de páxinas visitadas para recordar",
"Displayed time zone" => "Zona horaria para mostrar",
"User information" => "Información do usuario",
"Private" => "Privado",
"public" => "público",
"Use double-click to edit pages" => "Usar dobre clic para editar páxinas",
"Show user's info on mouseover" => "Mostra a información do usuario ao pasar o punteiro do rato por riba",
"Tasks per page" => "Tarefas por páxina",
"Messages per page" => "Mensaxes por páxina",
"Allow messages from other users" => "Permitir mensaxes doutros usuarios",
"Send me an email for messages with priority equal or greater than" => "Envíeme un correo por mensaxes con prioridade igual ou meirande a",
"Auto-archive read messages after x days" => "Auto-arquivar mensaxes lidas logo de x días",
"never" => "nunca",
"My Tiki" => "O meu Tiki",
"My pages" => "As miñas páxinas",
"My messages" => "As miñas mensaxes",
"My tasks" => "As miñas tarefas",
"My items" => "Os meus ítems",
"My workflow" => "O meu fluxo de traballo",
"Feature" => "Característica",
"To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "Para configurar o seu directorio, busque \"Admin directorio\" baixo \"Directorio\" no menú de aplicación, ou",
"Number of columns per page when listing categories" => "Número de columnas por páxina cando se listan categorías",
"Links per page" => "Ligazóns por páxina",
"Validate URLs" => "Validar os URL",
"enable cool sites" => "activar sitios interesantes",
"Method to open directory links" => "Método para abrir ligazóns do directorio",
"New Window" => "Nova fiestra",
"To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "Para agregar/eliminar PMF, busque \"Admin PMFs\" en \"PMFs\" no menú de aplicación, ou",
"Default number of comments per page" => "Cantidade, por defecto, de comentarios por páxina",
"Comments default ordering" => "Orde por defecto dos comentarios",
"Newsletters" => "Boletíns",
"Multilingual" => "Multilingüe",
"Surveys" => "Enquisas",
"Featured Help" => "Axuda en Ligazóns Destacadas",
"Live support system" => "Sistema de asistencia en liña",
"Contact Us" => "Contactar con nós",
"JsCalendar" => "CalendarioJs",
"PhpLayers Dynamic menus" => "Menús dinámicos PhpLayers",
"Tiki Sheet" => "Folla de cálculo Tiki",
"Drawings" => "Ilustracións",
"Friendship Network" => "Rede de Amizade",
"Games" => "Xogos",
"Administration Features" => "Características da Administración",
"Banning System" => "Sistema de Expulsión",
"Banning system" => "Sistema de expulsión",
"Stats" => "Estatísticas",
"Communications (send/receive objects)" => "Comunicacións (enviar/recibir obxectos)",
"Custom Home" => "Inicio personalizado",
"User Features" => "Características do usuario",
"Mini Calendar" => "Mini calendario",
"User Preferences Screen" => "Pantalla de preferencias do usuario",
"User Notepad" => "Caderno de notas do usuario",
"User Bookmarks" => "Marcadores do usuario",
"User Watches" => "Monitores de usuario",
"User Watches Translations" => "Monitores de traducións do usuario",
"User Menu" => "Menú do Usuario",
"User Tasks" => "Tarefas do usuario",
"User Messages" => "Mensaxes do usuario",
"User Files" => "Ficheiros do usuario",
"Newsreader" => "Novas",
"Integrator" => "Integrador",
"Debugger Console" => "Consola do depurador",
"Workflow" => "Fluxo de traballo",
"Workflow engine" => "Motor de fluxo de traballo",
"If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "Se decide gardar ficheiros nun directorio, debe asegurarse de que o usuario non pode acceder directamente ao directorio.",
"You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "Ten dúas opcións para lograr isto:<br /><ul><li>Usar un directorio fóra do documento raíz, asegurándose de que o seu script php pode ler e escribir nese directorio</li><li>Usar un directorio dentro do documento raíz e usar .htaccess para evitar que os usuarios listen o contido do directorio</li></ul>",
"To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "Para configurar o camiño ao directorio, use camiños similares aos de UNIX, p/ex ficheiros/ ou c:/foo/ficheiros ou /www/ficheiros/",
"Home Gallery (main gallery)" => "Galería inicial (galería principal)",
"Allow same file to be uploaded more than once" => "Permitir que se poida cargar o mesmo ficheiro máis dunha vez",
"Never" => "Nunca",
"MIME Type" => "Tipo MIME",
"Reindex all files for search" => "Reindexar todos os ficheiros para a busca",
"To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "Para engadir/eliminar foros, busque por \"Admin foros\" en \"Foros\" no menú de aplicación, ou",
"Home Forum (main forum)" => "Foro inicial (principal)",
"Accept wiki syntax" => "Aceptar sintaxe wiki",
"Topics" => "Temas",
"Posts per day" => "Artigos por día",
"Browser width" => "Anchura do navegador",
"Browser height" => "Altura do navegador",
"Navigation depth" => "Profundidade da navegación",
"Feed animation interval (milisecs)" => "Intervalo de animación da fonte (milisegs.)",
"To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "Para engadir/eliminar galerías de imaxes, vaia a \"Galerías de Imaxes\" no menú de aplicación, ou",
"You can upload images of a size of " => "Pode cargar imaxes dun tamaño de",
"Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Modifique as variables do php.ini file_uploads, upload_max_filesize, post_max_size e variables da base de datos (max_allowed_packet para mysql) para cambiar este valor",
"Home Gallery" => "Galería Inicial",
"Galleries features" => "Características de galerías",
"Uses Slideshow" => "Usa diapositivas",
"Use database to store images" => "Usar a base de datos para gardar imaxes",
"Use a directory to store images" => "Usar directorio para almacenar imaxes",
"Directory path" => "Ruta do directorio",
"Library to use for processing images" => "Biblioteca para procesar imaxes",
"Uploaded image names must match regex" => "Os nomes das imaxes deben emparellar con esta expresión regular",
"Uploaded image names cannot match regex" => "Os nomes das imaxes non deben emparellar con esta expresión regular",
"Directory Batch Loading" => "Carga en lote de directorio",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "Se activa carga en lote de directorio, debe configurar un directorio lexible desde o servidor web (é preferible fóra do espazo web de páxinas). Logo configure unha forma de cargar imaxes nese directorio, xa sexa por scp, ftp ou outros protocolos",
"Enable directory batch loading" => "Activar a carga en lote de directorio",
"Batch loading directory" => "Directorio de carga en lote",
"Images per row" => "Imaxes por fila",
"Thumbnails size X" => "Tamaño X para miniaturas",
"Thumbnails size Y" => "Tamaño Y para miniaturas",
"pixels" => "píxeles",
"Set features" => "Establecer configuración",
"Exterminator" => "Exterminador",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Eliminar imaxes da galería do sistema, que non se están usando en páxinas wiki, artigos ou artigos do blog",
"All galleries" => "Todas as galerías",
"System Gallery" => "Galería do sistema",
"Gallery listing configuration" => "Configuración da listaxe de galerías",
"Parent" => "Pai",
"Change configuration" => "Cambiar configuración",
"Image galleries comments settings" => "Configuración para os comentarios en galerías de imaxes",
"General Preferences" => "Preferencias xerais",
"Date and Time Formats" => "Formatos de data e hora",
"Site Identity" => "Identidade do sitio",
"Browser title" => "Título (fiestra do navegador)",
"Home Page" => "Páxina Inicial",
"Use group homepages" => "Usar páxinas de inicio de grupo",
"Go to group homepage only if login from default homepage" => "Ir á páxina inicial de grupo só se se identifica desde a páxina de inicio por defecto",
"Custom home" => "Inicio personalizado",
"Unknown/Other" => "Descoñecido/Outro",
"(standard)" => "(estándar)",
"(some Unix MTA)" => "(algún MTA de Unix)",
"Protect against CSRF with a ticket" => "Protexer contra CSRF cun tícket",
"Use proxy" => "Usar proxy",
"Port" => "Porto",
"Tikiwiki.org help" => "Axuda Tikiwiki.org",
"Store session data in database" => "Gardar datos da sesión na base de datos",
"Contact user" => "Contactar usuario",
"Count admin pageviews" => "Contar accesos de admin",
"Temporary directory" => "Directorio temporal",
"Help System" => "Sistema de axuda",
"Help URL" => "URL de axuda",
"Long date format" => "Formato longo para as datas",
"Short date format" => "Formato curto para as datas",
"Long time format" => "Formato longo para as horas",
"Short time format" => "Formato curto para as horas",
"Date and Time Format Help" => "Axuda de formatos de data e hora",
"Change admin password" => "Cambiar o contrasinal de admin",
"New password" => "Novo contrasinal",
"Change password" => "Cambiar contrasinal",
"Detect browser language" => "Detectar a lingua do navegador",
"Use database for translation" => "Usar a base de datos para a tradución",
"Edit or ex/import Languages" => "Editar ou exportar/importar linguas",
"Record untranslated" => "Rexistrar cadeas non traducidas",
"Syntax error" => "Erro de sintaxe",
"port" => "porto",
"Enable/disable Tiki features in " => "Activar/desactivar características do Tiki en ",
", but configure them elsewhere" => ", pero configúreas noutro lado",
"Admin Groups" => "Administrar grupos",
"Admin Users" => "Administrar usuarios",
"Authentication method" => "Método de autenticación",
"Tiki and HTTP Auth" => "Tiki e HTTP Auth",
"Registration" => "Rexistro",
"Users can register" => "Usuarios poden rexistrarse",
"Use challenge/response authentication" => "Usar autenticación por challenge/response ",
"HTTP port" => "porto HTTP",
"HTTPS port" => "port HTTPS",
"Duration" => "Duración",
"PAM service" => "Servizo PAM",
"Currently unused" => "Actualmente non usado",
"CAS server version" => "Versión do servidor CAS",
"Version 1.0" => "Versión 1.0",
"Version 2.0" => "Versión 2.0",
"Users can change theme" => "Os usuarios rexistrados poden cambiar de decoración",
"Restrict available themes" => "Restrinxir decoracións dispoñibles",
"Available styles:" => "Estilos dispoñibles:",
"Slideshows theme" => "Decoración para diapositivas",
"Edit CSS" => "Editar CSS",
"Theme Control" => "Control de decoración",
"Template Viewing" => "Vista de modelos",
"Tiki Template Viewing" => "Vista de modelo de Tiki",
"General Layout options" => "Opcións xerais de deseño",
"logged as" => "iniciou a sesión como",
"Site logo background color" => "Cor de fondo do logo do sitio",
"Site logo title (on mouse over)" => "Título do logo do sitio (aparece cando o rato pasa por riba)",
"Alt. description (e.g. for text browsers)" => "Descrición alt. (p. ex. para navegadores de texto)",
"Site menu bar" => "Barra de menú do sitio",
"Current Version" => "Versión actual",
"Custom code" => "Código personalizable",
"Users can Flip Columns" => "Os usuarios poden cambiar as columnas",
"Left column" => "Columna esquerda",
"always" => "sempre",
"user decides" => "o usuario decide",
"Site Breadcrumbs" => "Ruta de acceso do sitio",
"Site location bar" => "Barra de localización do sitio",
"at top of page" => "ao tope da páxina",
"at top of center column" => "ao tope da columna central",
"Larger font for" => "Fonte máis grande para",
"entire location" => "toda a localización",
"page name" => "nome dz páxina",
"Use page description:" => "Usar descrición de páxina:",
"Right column" => "Columna dereita",
"Maximum number of records in listings" => "Número máximo de rexistros en listaxes",
"Use direct pagination links" => "Usar ligazóns de paxinación directa",
"Warning" => "Coidado",
"Left" => "Esquerda",
"Right" => "Dereita",
"Use Tabs" => "Usar lingüetas",
"Display menus as folders" => "Mostrar menús como carpetas",
"Layout per section" => "Deseño por sección",
"Admin layout per section" => "Administrar deseño por sección",
"Favicon icon file name:" => "Nome do ficheiro da icona Favicon:",
"Favicon icon MIME type:" => "Tipo MIME da icona Favicon:",
"image/png" => "imaxe/png",
"image/bmp" => "imaxe/bmp",
"image/x-icon" => "imaxe/x-icon",
"full path to mapfiles" => "ruta completa aos ficheiros de mapas",
"default mapfile" => "ficheiro de mapa por defecto",
"Wiki Page for Help" => "Páxina Wiki para Axuda",
"Wiki Page for Comments" => "Páxina Wiki para comentarios",
"Full path to gdaltindex" => "Camiño completo a gdaltindex",
"Full path to ogr2ogr" => "Camiño completo a ogr2ogr",
"Map Zone" => "Zona de Mapa",
"Generate User Map" => "Xerar Mapa do Usuario",
"Maximum mailbox size (messages, 0=unlimited)" => "Tamaño máximo da caixa de correo(mensaxes, 0=ilimitado)",
"Maximum mail archive size (messages, 0=unlimited)" => "Tamaño máximo do arquivo de correos(mensaxes, 0=ilimitado)",
"Maximum sent box size (messages, 0=unlimited)" => "Tamaño máximo da carpeta de enviados (mensaxes, 0=ilimitado)",
"geo.position" => "geo.posición",
"geo.region" => "geo.rexión",
"geo.placename" => "geo.nomelugar",
"Display modules to all groups always" => "Mostrar sempre os módulos a todos os grupos",
"Hide anonymous-only modules from registered users" => "Ocultar aos usuarios rexistrados os módulos só para usuarios anónimos",
"To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "Para engadir/eliminar votacións, busque \"Votacións\" en \"Admin\" no menú de aplicación, ou",
"Last update" => "Última actualización",
"Image galleries" => "Galerías de imaxes",
"Feed for forums" => "Fonte para foros",
"Default RDF version" => "Versión por defecto de RDF",
"Specification" => "Especificación",
"Documentation" => "Documentación",
"Webmaster" => "Administrador da web",
"You can see users rank by score in the module users_rank, for that go to" => "Pode ver clasificación de usuarios por puntos no módulo users_rank, para iso vaia a ",
"Admin modules" => "Administrar módulos",
"Expiration" => "Expiración",
"Search stats" => "Estatísticas das buscas",
"random" => "azar",
"Refresh rate" => "Tempo de actualización",
"Minimum length of search word" => "Tamaño mínimo da palabra que se busca",
"Max. number of words containing a syllable" => "Número máximo de palabras que conteñen unha sílaba",
"Max. age in hours of syllable search cache" => "Tempo máximo en horas de busca de sílabas en caché ",
"LRU list purging rate" => "Taxa de limpeza da lista LRU",
"LRU list length" => "Tamaño da lista LRU",
"Referer Search Highlighting" => "Destacar busca",
"Ignore individual object permissions" => "Ignorar os permisos individuais de obxectos",
"hits" => "accesos",
"Open external links in new window" => "Abrir ligazóns externas nunha fiestra nova",
"Dynamic Content System" => "Sistema de contido dinámico",
"Automonospaced text" => "Texto auto-monoespazado",
"Tables syntax" => "Sintaxe de táboas",
"AutoLinks" => "Autoligazóns",
"rows" => "filas",
"Required" => "Requirido",
"Parameters" => "Parámetros",
"To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "Para configurar os seus trackers, busque en \"Administrar trackers\" baixo \"Trackers\" no menú de aplicación, ou",
"dls" => "descargas",
"Storage" => "Almacenamento",
"Change" => "Cambiar",
"Change all to db" => "Cambiar todo para a base de datos",
"Change all to file" => "Cambiar todo para ficheiro",
"Quota (Mb)" => "Cota (Mb)",
"Use database to store userfiles" => "Usar a base de datos para almacenar ficheiros de usuario",
"Use a directory to store userfiles" => "Usar un directorio para almacenar ficheiros de usuario",
"Allow viewing HTML mails?" => "Permitir ver correos en HTML?",
"Maximum size for each attachment" => "Tamaño máximo de cada anexo",
"Unlimited" => "Ilimitado",
"Create New" => "Crear nova",
"Home page" => "Páxina de inicio",
"Complete" => "Completo",
"Individual cache" => "Caché individual",
"Content templates" => "Modelos de contido",
"Warn on edit conflict" => "Advertir en conflitos de edición",
"Undo" => "Desfacer",
"Footnotes" => "Notas ao pé",
"Permission" => "Permiso",
"Allow HTML" => "Permitir HTML",
"Sandbox" => "Caixa de area",
"Dumps" => "Envorcados",
"Generate dump" => "Xerar envorcado",
"Download last dump" => "Descargar último envorcado",
"Pictures" => "Imaxes",
"Remove unused pictures" => "Quitar imaxes non usadas",
"Export" => "Exportar",
"Export Wiki Pages" => "Exportar páxinas wiki",
"Accept dashes and underscores in WikiWords" => "Aceptar guións e subliñado en PalabrasWiki",
"Link plural WikiWords to their singular forms" => "Liga PalabrasWiki en plural coas súas forma en singular",
"Side-by-side diff" => "diferenzas lado a lado",
"Discuss pages on forums" => "Discutir páxinas nos foros",
"Structures" => "Estruturas",
"Open page as structure" => "Abrir páxina como estrutura",
"Import HTML" => "Importar HTML",
"Page creators are admin of their pages" => "Os creadores de páxinas son os seus administradores",
"MultiPrint" => "Multi-impresión",
"Create watch for author on page creation" => "Crear monitor para autor na creación da páxina",
"Enable watch events when I am the editor" => "Activar monitor de eventos cando eu son o editor",
"Enable watches on comments" => "Activar monitores en comentarios",
"List pages" => "Listar páxinas",
"Wiki attachments" => "Anexos ao Wiki",
"Restore defaults" => "Recuperar valores por defecto",
"Contact us" => "Contactar con nós",
"Setting" => "Valor",
"Statistics" => "Estatísticas",
"Weeks" => "Semanas",
"viewed" => "visto",
"Add or edit a rule" => "Engadir ou editar regra",
"Rule title" => "Título da regra",
"Username regex matching" => "Nomes de usuario emparellando con expresión regular",
"IP regex matching" => "IP emparellando expresión regular",
"Banned from sections" => "Expulsado das seccións",
"Rule activated by dates" => "Activación de regras por datas",
"Rule active from" => "Regra activa desde",
"Rule active until" => "Regra activa ata",
"Custom message to the user" => "Mensaxe personalizada para o usuario",
"Rules" => "Regras",
"User/IP" => "Usuario/IP",
"Sections" => "Seccións",
"Admin Calendars" => "Administrar calendarios",
"List of Calendars" => "Lista de Calendarios",
"Loc" => "Loc.",
"Participants" => "Participantes",
"Lang" => "Lingua",
"Prio" => "Prio ",
"Subscription" => "Subscrición",
"Custom Locations" => "Localizacións personalizadas",
"Custom Participants" => "Participantes personalizables ",
"Custom Categories" => "Categorías personalizadas",
"Custom Languages" => "Linguas personalizadas",
"Custom Subscription List" => "Listaxe de subcricion personalizable",
"Custom Priorities" => "Prioridades personalizadas",
"Personal Calendar" => "Calendario persoal",
"Red" => "Vermello",
"Current category" => "Categoría actual",
"Child categories" => "Subcategorías",
"Edit permissions for this category" => "Editar permisos para esta categoría",
"Edit this category:" => "Editar esta categoría:",
"Add new category" => "Engadir nova categoría",
"Perms inherited from closest parent if possible or from global perms" => "Permisos herdados do antecesor máis achegado de ser posible ou de permisos globais",
"Assign permissions automatically" => "Asignar permisos automaticamente",
"recommended for best performance" => "recomendado para mellor rendemento",
"Objects in category" => "Obxectos na categoría",
"No records found." => "Non se atoparon rexistros",
"Add objects to category" => "Engadir obxectos á categoría",
"image gal" => "galería de imaxes",
"file gal" => "galería de ficheiros",
"Admin chart items" => "Administrar ítems de charts",
"Edit Chart" => "Editar chart",
"Add or edit an item" => "Engadir ou editar un ítem",
"Update" => "Actualizar",
"Chart items" => "Ítems de chart",
"No items defined yet" => "Aínda non hai ítems definidos",
"Add or edit a chart" => "Engadir ou editar un chart",
"Active" => "Activo",
"Users can vote for only one item from this chart per period" => "Os usuarios poden votar só por un ítem deste chart por período",
"Prevent users from voting for the same item more than once" => "Previr os usuarios de votar polo mesmo ítem máis dunha vez",
"Users can suggest new items" => "Os usuarios poden suxerir novos ítems",
"Auto validate user suggestions" => "Autovalidar suxestións do usuario",
"Ranking shows" => "Clasificación mostra",
"All items" => "Todos os ítems",
"Top 10 items" => "Os 10 ítems primeiros",
"Top 20 items" => "Os 20 ítems primeiros",
"Top 40 items" => "Os 40 ítems primeiros",
"Top 50 items" => "Os 50 ítems primeiros",
"Top 100 items" => "Os 100 ítems primeiros",
"Top 250 items" => "Os 250 ítems primeiros ",
"Voting system" => "Sistema de votación",
"Vote items" => "Votar ítems",
"Rank 1..5" => "Puntuación 1..5",
"Rank 1..10" => "Puntuación 1..10",
"Ranking frequency" => "Frecuencia de clasificación",
"Realtime" => "Tempo real",
"Each 5 minutes" => "Cada 5 minutos",
"Daily" => "Diario",
"Weekly" => "Semanal",
"Monthly" => "Mensual",
"Show Average" => "Mostrar media",
"Show Votes" => "Mostrar votos",
"Use Cookies for unregistered users" => "Usar cuquis para usuarios non rexistrados",
"Users can vote again after" => "Os usuarios poden votar de novo despois de",
"Anytime" => "En calquera momento",
"Ranks" => "Puntuacións",
"No charts defined yet" => "Aínda non se definiron charts",
"Admin templates" => "Administrar modelos",
"Edit this template:" => "Editar este modelo:",
"Create new template" => "Crear novo modelo",
"Use wysiwyg editor" => "Usar editor wysiwyg",
"Use normal editor" => "Usar editor normal",
"Templates" => "Modelos",
"Settings" => "Configuración",
"Admin cookies" => "Administrar cuquis",
"Create/edit cookies" => "Crear ou editar cuquis",
"Upload Cookies from textfile" => "Cargar cuquis desde un ficheiro de texto",
"Upload from disk:" => "Cargar desde o disco:",
"Upload" => "Cargar",
"Remove all cookies" => "Borrar todas as cuquis",
"cookie" => "Cuqui",
"Admin drawings" => "Administrar ilustracións",
"Available drawings" => "Ilustracións dispoñibles",
"Ver" => "Versión",
"Create/edit dsn" => "Crear/editar dsn",
"Admin external wikis" => "Administrar wikis externos",
"View template" => "Ver modelo",
"tiki admin external wikis template" => "modelo de administrar wikis externos ",
"Edit template" => "Editar modelo",
"Create/Edit External Wiki" => "Crear/Editar Wiki externo",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (usa \$page para ser substituído polo nome de páxina na URL exemplo: http://www.exemplo.com/tiki-index.php?page=\$page)",
"ExtWiki" => "Wikiext",
"Admin Forums" => "Administrar foros",
"Create new forum" => "Crear novo foro",
"List forums" => "Listar foros",
"Edit this Forum:" => "Editar este foro:",
"Create New Forum" => "Crear novo foro",
"There are individual permissions set for this forum" => "Existen permisos individuais definidos para este foro",
"Prevent flooding" => "Previr sobrecarga (flooding)",
"Minimum time between posts" => "Tempo mínimo entre publicacións",
"Section" => "Sección",
"Create new" => "Crear novo",
"Moderator user" => "Usuario noderador",
"Moderator group" => "Grupo moderador",
"Password protected" => "Protexido por contrasinal",
"Topics only" => "Só temas",
"All posts" => "Todos os artigos",
"Forum password" => "Contrasinal de foro",
"Send this forums posts to this email" => "Enviar artigos deste foro a este correo-e",
"Prune unreplied messages after" => "Eliminar mensaxes sen respostas despois de",
"Prune old messages after" => "Eliminar mensaxes antigas despois de",
"Topic list configuration" => "Configuración da listaxe de temas",
"Posts can be rated" => "Os artigos poden ser cualificados",
"Display last post titles" => "Mostra os últimos títulos de enviados",
"no display" => "non mostrar",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Reenviar mensaxes deste foro a este enderezo de correo-e, nun formato que poida ser usado para enviar mensaxes de volta ao enderezo de correo entrante do foro",
"Send mails even when the post is generated by inbound mail" => "Enviar correos mesmo cando o envío é xerado por unha mensaxe entrante",
"Append a reply link to outbound mails" => "Agregar unha ligazón de resposta ás mensaxes saíntes",
"Originating e-mail address for mails from this forum" => "Enderezo orixe de correo-e para correos deste foro",
"Add messages from this email to the forum" => "Engadir as mensaxes desde este correo-e ao foro",
"POP3 server" => "Servidor POP3",
"Use topic smileys" => "Usar emoticonas do tema",
"Show topic summary" => "Mostrar sumario do tema",
"User information display" => "Mostrar información do usuario",
"Online" => "En liña",
"Approval type" => "Tipo de aprobación",
"All posted" => "Todos os enviados",
"Queue anonymous posts" => "Pór en cola os artigos anónimos",
"Queue all posts" => "Pór en cola todos os artigos",
"No attachments" => "Sen anexos",
"Everybody can attach" => "Todos poden anexar",
"Only users with attach permission" => "Só usuarios con permiso para anexar",
"Moderators and admin can attach" => "Os moderadores e administradores poden anexar",
"Store attachments in:" => "Gardar anexos en:",
"Database" => "Base de datos",
"Max attachment size (bytes)" => "Tamaño máximo do anexo (bytes)",
"Default ordering for topics" => "Orde por defecto para temas",
"Date (desc)" => "Data(desc)",
"Date (asc)" => "Data (asc)",
"Score (desc)" => "Puntuación (desc)",
"Replies (desc)" => "Respostas (desc)",
"Reads (desc)" => "Lecturas (desc)",
"Topics per page" => "Temas por páxina",
"Default ordering for threads" => "Orde por defecto para fíos argumentais",
"Age" => "Idade",
"PPD" => "Ppd",
"Admin Hotwords" => "Administrar palabras clave",
"Add Hotword" => "Engadir palabra clave",
"Word" => "Palabra",
"Admin HTML pages" => "Administrar páxinas HTML",
"Edit this page" => "Editar esta páxina",
"View page" => "Ver páxina",
"Edit zone" => "Editar sección",
"Dynamic zones" => "Zonas dinámicas",
"zone" => "zona",
"content" => "contido",
"Mass update" => "Actualización masiva",
"Create new HTML page" => "Crear nova páxina HTML",
"Edit this HTML page:" => "Editar esta páxina HTML:",
"Apply template" => "Aplicar modelo",
"Dynamic" => "Dinámica",
"Static" => "Estática",
"Last Modif" => "última modificación",
"Edit Repository:" => "Editar almacén:",
"Create New Repository" => "Crear novo almacén",
"List Repositories" => "Listar almacéns",
"New Repository" => "Novo almacén",
"View Repository" => "Ver almacén",
"Human readable repository name" => "Nome do almacén en formato lexible",
"Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Camiño ao almacén (sistema de ficheiros local: relativo/absoluto respecto a raíz de web, remoto: prefixado con 'http://')",
"File name of start page" => "Ficheiro da páxina inicial",
"Start page" => "Páxina de inicio",
"CSS file to load when browse this repository" => "Ficheiro CSS para cargar cando se navegue por este almacén",
"CSS file" => "Ficheiro CSS",
"Is repository visible to users" => "É o almacén visible para os usuarios",
"Can files from repository be cached" => "Os ficheiros do repositorio poden ser almacenados na caché",
"Are files from repository can be cached" => "Os ficheiros do almacén poden ser almacenados na caché",
"Clear all cached pages of this repository" => "Borrar todas as páxinas cacheadas deste almacén",
"Clear cache" => "Borrar caché",
"Seconds count 'till cached page will be expired" => "Conta de segundos ata que expire a páxina almacenada na caché",
"Cache expiration" => "Expiración de caché",
"Human readable text description of repository" => "Descrición lexible do almacén",
"Available Repositories" => "Almacéns dispoñibles ",
"CSS File" => "Ficheiro CSS",
"Edit rules" => "Editar regras",
"Edit Rules for Repository:" => "Editar regras para o almacén:",
"Configure Repositories" => "Configurar almacéns",
"Configure this Repository" => "Configurar este almacén",
"View this Repository" => "Ver este almacén",
"New Rule" => "Nova regra",
"Copy Rules" => "Copiar regras",
"view/hide copy rules dialog" => "ver/ocultar diálogo de copia de regras",
"Source repository" => "Almacén de orixe",
"Copy" => "Copiar",
"According this order rules will be applied ('0' or empty = auto)" => "Segundo esta orde as regras serán aplicadas ('0' ou baleiro= auto)",
"Rule order" => "Orde de regras",
"Text to search for" => "Texto para buscar",
"Text to replace" => "Texto para substituír",
"Is this regular expression or simple search/replacer" => "É esta unha expresión regular ou unha simple busca/substitución",
"Regex" => "Expresión regular",
"Is case sensitive (for simple replacer)" => "É sensible a maiúsc/minúsc (para substitución simple)",
"Case sensitive" => "Maiúsc/Minúsc",
"subset of chars: imsxeADSXUu, which is regex modifiers" => "subconxunto de caracteres: imsxeADSXUu, que son modificadores de expresión regular",
"Regex modifiers" => "Modificadores de expresión regular",
"Human readable text description of rule" => "Descrición lexible da regra",
"Check to enable this rule" => "Seleccione para habilitar esta regra",
"Enabled" => "Activado",
"Preview options" => "Opcións de previsualización",
"Apply all rules or just this to generate preview" => "Aplicar todas as regras ou só esta para xerar a previsualización",
"Apply all rules" => "Aplicar todas as regras",
"View source code after rules applied" => "Ver código fonte despois de que as regras sexan aplicadas",
"Code preview" => "Vista previa de Código",
"Generate HTML preview" => "Xerar vista previa HTML",
"HTML preview" => "vista previa HTML",
"Test file from repository to generate preview for (empty = configured start page)" => "Ficheiro de proba do almacén para o cal xerar vista previa (baleiro = páxina inicial configurada)",
"Preview Results" => "Resultados da vista previa",
"Rules List" => "Lista de regras",
"Case" => "Maiúsc./Minúsc.",
"Configure/Options" => "Configurar/Opcións",
"Admin layout" => "Administrar deseño",
"Theme control" => "Control de decoración",
"layout options" => "opcións de deseño",
"Generate positions by hits" => "Ordenar automaticamente por accesos",
"List of featured links" => "Lista de ligazóns destacadas",
"Position" => "Posición",
"Add Featured Link" => "Engadir unha ligazón destacada",
"Edit this Featured Link:" => "Editar esta ligazón destacada:",
"Create new Featured Link" => "Crear unha nova ligazón destacada",
"disables the link" => "deshabilita a ligazón",
"Link type" => "Tipo de ligazón",
"replace current page" => "substituír a páxina actual",
"framed" => "nun marco",
"open new window" => "abrir nova fiestra",
"Mail-in accounts" => "Contas de entrada de correo",
"Account" => "Conta",
"Add new Mail-in account" => "Engada unha nova conta de entrada de correo",
"Edit Mail-in account" => "Editar conta de entrada de correo",
"Account name" => "Nome de conta",
"POP server" => "Servidor POP",
"SMTP server" => "Servidor SMTP",
"SMTP requires authentication" => "SMTP require autenticación",
"article-put" => "poñer-artigo",
"wiki-get" => "recibir-wiki",
"wiki-put" => "poñer-wiki",
"wiki-append" => "concatenar-wiki",
"Article Topic" => "Tema do artigo",
"Admin Topics" => "Administrar temas",
"Article Type" => "Tipo de artigo",
"Admin Types" => "Administrar tipos",
"Allow anonymous acces" => "Permitir usuarios anónimos",
"Allow attachments" => "Permitir archivos anexos",
"Discard to the end from" => "Descartar ata a fin desde",
"Check Mail-in accounts" => "Comprobar contas de correo entrante",
"Check automatically" => "Comprobar automaticamente",
"Frequency" => "Frecuencia",
"List menus" => "Listar menús",
"Edit this menu" => "Editar menú",
"Edit menu options" => "Editar opcións do menú",
"Show Quick Urls" => "Mostrar asURL rápidas",
"Some useful URLs" => "Algunhas URL útiles",
"Hide Quick Urls" => "Ocultar as URL Rápidas",
"option" => "opción",
"separator" => "separador",
"Choose" => "Elixir",
"Home Blog" => "Blog de inicio",
"Home Image Gal" => "Gal de imaxes ppal",
"Home Image Gallery" => "Galería de imaxes principal",
"Home File Gal" => "Gal de ficheiros ppal",
"Home File Gallery" => "Galería de ficheiros principal",
"User preferences" => "Preferencias do usuario",
"User prefs" => "Prefs do usuario",
"List galleries" => "Listar galerías",
"List image galleries" => "Listar galerías de imaxes",
"Upload image" => "Cargar imaxe",
"Gallery Rankings" => "Clasificacións de galerías",
"Browse a gallery" => "Navegar por unha galería",
"Articles home" => "Inicio de artigos",
"All articles" => "Todos os artigos",
"Submit" => "Enviar",
"List Blogs" => "Listar Blogs",
"Create blog" => "Crear blog",
"File galleries" => "Galerías de ficheiros",
"View a forum" => "Ver un foro",
"View a thread" => "Ver un fío",
"View a FAQ" => "Ver un PMF",
"Take a quiz" => "Cubrir o cuestionario",
"Quiz stats" => "Estatísticas de cuestionario",
"Stats for a Quiz" => "Estatísticas do cuestionario",
"Preview menu" => "Previsualizar o menú",
"Menu options" => "Opcións de menú",
"Edit this Menu:" => "Editar este menú:",
"Create new Menu" => "Crear novo menú",
"dynamic collapsed" => "dinámico colapsado",
"dynamic extended" => "dinámico expandido",
"fixed" => "estático",
"Options" => "Opcións",
"Active Permissions" => "Activar permisos",
"Clear Cache" => "Limpar caché",
"User Modules" => "Módulos de usuario",
"Assigned Modules" => "Módulos asignados",
"Left Modules" => "Módulos esquerda",
"Rows" => "Filas",
"Move to Right Column" => "Mover á columna dereita",
"Unassign" => "Inhabilitar",
"Right Modules" => "Módulos da dereita",
"Move to Left Column" => "Mover á columna esquerda",
"Assign new module" => "Asignar novo módulo",
"Edit this assigned module:" => "Editar o módulo asignado:",
"Cache Time" => "Tempo en caché",
"Visibility" => "Visibilidade",
"Displayed now for all eligible users even with personal assigned modules" => "Mostrando agora para todos os usuarios elixibles mesmo con módulos persoais asignados",
"Displayed for the eligible users with no personal assigned modules" => "Mostrado para os usuarios elixibles sen módulos persoais asignados",
"Displayed now, can't be unassigned" => "Mostrado agora, non pode estar desasignado",
"Not displayed until a user chooses it" => "Non mostrado ata que o usuario o elixe",
"Create new user module" => "Crear novo módulo de usuario",
"Edit this user module:" => "Editar este módulo de usuario:",
"Must be wiki parsed" => "Debe ser procesado por wiki",
"Objects that can be included" => "Obxectos que poden incluírse",
"Available polls" => "Votacións dispoñibles",
"Random active poll" => "Votación activa ao chou",
"Random current poll" => "Votación actual ao chou",
"Use Poll" => "Usar votación",
"Random image from" => "Imaxe ao chou de",
"Use Gallery" => "Usar galería",
"Dynamic content blocks" => "Bloques de contido dinámico",
"Use RSS Module" => "Usar módulo RSS",
"Use Menu" => "Usar menú",
"Use phplayermenu" => "Usar menú phplayer",
"Banner zones" => "Zonas de pancartas",
"Use Banner Zone" => "Usar zona de pancartas",
"Admin newsletter subscriptions" => "Administrar suscricións ao boletín",
"List Newsletters" => "Listar boletíns",
"Admin Newsletters" => "Administrar boletíns",
"Send Newsletters" => "Enviar boletíns",
"Add a subscription newsletters" => "Engadir unha subscrición a boletíns",
"Add email:" => "Engadir correo:",
"Add user:" => "Engadir usuario:",
"Group users" => "Usuarios do grupo",
"Group subscription also subscribes included groups" => "Subscrición de grupo tamén subscribe grupos incluídos",
"Don't send confirmation mail" => "Non enviar correo de confirmación",
"The user email will be refreshed at each newsletter sending" => "O correo de usuario será actualizado en cada envío de boletín",
"Subscribe group" => "Subscribir grupo",
"Included group, group users and emails will be refreshed at each newsletter sending" => "Usuarios e correos-e de grupos e grupos incluídos serán actualizados en cada envío de boletín",
"Subscriptions" => "Suscricións",
"Valid" => "Válido",
"Subscribed" => "subscrito",
"Admin newsletters" => "Administrar boletíns",
"There are individual permissions set for this newsletter" => "Existen permisos individuais para este boletín",
"Users can subscribe/unsubscribe to this list" => "Os usuarios poden subscribirse/cancelas a subscrición nesta lista",
"Users can subscribe any email address" => "Os usuarios poden subscribir calquera enderezo de correo-e",
"Add unsubscribe instructions to each newsletter" => "Engadir instrucións de cancelar a subscrición a cada boletín",
"Validate email addresses" => "Validar enderezo de correo-e",
"Editions" => "Edicións",
"Last Sent" => "última enviada",
"Add notification" => "Engadir notificación",
"Event" => "Evento",
"A user registers" => "Un usuario rexistrouse",
"A user submits an article" => "Un usuario envía un artigo",
"Any wiki page is changed" => "Calquera páxina do wiki é cambiada",
"Any wiki page is changed, even minor changes" => "Calquera páxina wiki é cambiada, mesmo cambios menores",
"PHP error" => "erro de PHP",
"Email:" => "Correo:",
"List polls" => "Listar votacións",
"Edit this poll" => "Editar esta votación",
"Preview poll" => "Previsualizar votación",
"Option" => "Opción",
"Poll options" => "Opcións de votación",
"Votes" => "Votos",
"Admin Polls" => "Administrar votacións",
"Set last poll as current" => "Poñer a última votación como actual",
"Close all polls but last" => "Pechar todas as votacións agás a última",
"Activate all polls" => "Activar todas as votacións",
"active" => "activo",
"current" => "actual",
"template" => "modelo",
"object" => "obxecto",
"PublishDate" => "Data de publicación",
"Results" => "Resultados",
"Wiki pages" => "páxinas wiki",
"Admin Quicktags" => "Administrar Etiquetas rápidas",
"Create/Edit QuickTags" => "Crear/Editar etiquetas rápidas",
"Insert (use 'text' for figuring the selection)" => "Inserir (use 'text' para determinar a selección)",
"Path to the tag icon" => "Camiño á icona da etiqueta",
"Admin RSS Modules" => "Administrar módulos RSS",
"This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "Esta páxina é para configurar preferencias de fontes RSS lidas/importados por Tiki. Para xerar/exportar fontes RSS, busque \"Fontes RSS\" no panel de administración, ou",
"Content for the feed" => "Contido da fonte",
"show feed title" => "mostrar título da fonte",
"show publish date" => "mostrar data de publicación",
"PHP settings" => "Configuración de PHP",
"Risk Factor" => "Factor de risco",
"Explanation" => "Explicación",
"Check all tiki files" => "Comprobar todos os ficheiros tiki",
"Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Teña en conta que isto pode demorar moito tempo. Debería comprobar a súa configuración de max_execution_time en php.ini.",
"File checks" => "Comprobación de ficheiros",
"user" => "usuario",
"group" => "grupo",
"sticky" => "persistente",
"Admin Shoutbox Words" => "Administrar palabras do taboleiro de anuncios",
"Add Banned Word" => "Agregar palabra prohibida",
"Are you sure you want to delete this word?" => "Está seguro de que quere borrar esta palabra?",
"Destroy the structure leaving the wiki pages" => "Destruír a estrutura deixando as páxinas wiki",
"Destroy the structure and remove the pages" => "Destruír a estrutura e borrar as páxinas",
"Export Pages" => "Exportar páxinas",
"Dump Tree" => "Envorcar árbore",
"Create WebHelp" => "Crear AxudaWeb",
"View WebHelp" => "Ver axuda web",
"Create new structure" => "Crear nova estrutura",
"Alias" => "Alcume",
"Tree" => "árbore",
"Use single spaces to indent structure levels" => "Usar espazos simples para sangrar niveis de estrutura",
"Create New Structure" => "Crear nova estrutura",
"List surveys" => "Listar enquisas",
"Survey Stats" => "Estatísticas da enquisa",
"Edit this Survey" => "Editar enquisa",
"Admin Surveys" => "Administrar enquisas",
"Question" => "Pregunta",
"One choice" => "Unha opción",
"Multiple choices" => "Múltiples opcións",
"Short text" => "Texto breve",
"Rate (1..5)" => "Cualificar (1..5)",
"Rate (1..10)" => "Cualificar (1..10)",
"Rate" => "Cualificación",
"Options (if apply)" => "Opcións (se for o caso)",
"Questions" => "Preguntas",
"Admin surveys" => "Administrar enquisas",
"List Surveys" => "Listar enquisas",
"Edit this Survey:" => "Editar esta enquisa:",
"Create New Survey" => "Crear nova enquisa",
"There are individual permissions set for this survey" => "Existen permisos individuais establecidos para esta enquisa",
"Open" => "Aberto",
"Empty" => "Baleiro",
"Templates compiler" => "Compilador de modelos",
"Compile" => "Compilar",
"Fix UTF-8 Errors in Tables" => "Arranxar erros UTF-8 en táboas",
"Warning: Make a backup of your Database before using this function!" => "Atención: faga unha copia de seguridade da súa base de datos antes de usar esta función!",
"Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Atención: se tenta converter grandes táboas, aumente o tempo máximo de execución no php.ini!",
"This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "Esta función converte textos codificados en ISO-8859-1 nas súas táboas a UTF-8",
"This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "Isto pode ser necesario se creou contido con tiki &lt; 1.8.4 e opción Default Charset de apache en ISO-8859-1",
"UTF-8 Errors fixed" => "Erros UTF-8 arranxados",
"Investigate" => "Investigar",
"Fix it" => "Arranxar",
"Create a new topic" => "Crear novo tema",
"Topic Name" => "Nome do tema",
"Upload Image" => "Cargar imaxe",
"List of topics" => "Lista de temas",
"Articles (subs)" => "Artigos (colaboracións)",
"topic image" => "imaxe do tópico",
"Deactivate" => "Desactivar",
"Remove with articles" => "Borrar con artigos",
"List Trackers" => "Listar trackers",
"Admin Trackers" => "Administrar os trackers",
"Edit This Tracker" => "Editar tracker ",
"View This Tracker's Items" => "Ver elementos do tracker",
"Edit tracker field" => "Editar campos do tracker",
"Is column visible when listing tracker items?" => "Está visible a columna cando se listan ítems do tracker?",
"Column links to edit/view item?" => "Ligazóns na columna para editar/ver o ítem?",
"Column is searchable?" => "A columna é localizable?",
"Field is mandatory?" => "O campo é obrigatorio?",
"Tracker fields" => "Campos de tracker",
"isMain" => "é principal",
"Tbl vis" => "visible en listaxes",
"Searchable" => "incluír o campo nas buscas",
"Hidden" => "Oculto",
"Mandatory" => "Obrigatorio",
"Import/Export Trackers Fields" => "Importar/exportar campos de trackers ",
"Edit Tracker" => "Editar tracker",
"Import/Export" => "Importar/exportar",
"Found" => "Encontrado",
"There are individual permissions set for this tracker" => "Hai permisos individuais configurados para este tracker",
"No individual permissions. Global permissions apply." => "Non hai permisos individuais, aplican os permisos globais",
"Show status" => "Mostrar estado",
"Default status displayed in list mode" => "Estado por defecto mostrado en modalidade de lista",
"Show status to tracker admin only" => "Mostrar estado só ao administrador do tracker",
"Send copies of all activity in this tracker to this e-mail address" => "Enviar copias de toda actividade neste tracker a este enderezo de correo",
"Use simplified e-mail format" => "Usar formato simplificado de correo",
"New items are created with status" => "Os novos ítems son creados con estado",
"Authoritative status for modified items" => "Estado autorizativo para os ítems modificados",
"No change" => "Sen cambios",
"Item creator can modify his items?" => "O creador do ítem pode modificar os seus ítems?",
"The tracker needs a user field with the option 1" => "O tracker precisa un campo para o usuario coa opción 1",
"Member of the default group of creator can modify items?" => "O membro do grupo por defecto do creador pode modificar os ítems?",
"The tracker needs a group field with the option 1" => "O tracker precisa un campo para o grupo coa opción 1",
"Show creation date when listing tracker items?" => "Mostrar a data de creación cando se listan ítems do tracker?",
"Show lastModif date when listing tracker items?" => "Mostrar a data da última modificación cando se listan ítems do tracker?",
"What field is used for default sort?" => "Que campo se usa para a ordenación por defecto?",
"What is default sort order in list?" => "Cal é a orde por defecto para a listaxe?",
"Tracker items allow ratings?" => "Os ítems do tracker permiten cualificacións?",
"with values" => "con valores",
"and display rating results in listing?" => "e mostrar o resultado das cualificacións na listaxe?",
"Tracker items allow comments?" => "Os ítems do tracker permiten comentarios?",
"and display comments in listing?" => "e mostrar os comentarios na listaxe?",
"Tracker items allow attachments?" => "Os ítems do tracker permiten anexos?",
"and display attachments in listing?" => "e mostrar os anexos na listaxe?",
"Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Opcións para mostrar os anexos (Use números para ordenar os ítems, 0 non se mostrará, e os números negativos mostraranse en emerxentes)",
"Filesize" => "Tamaño do ficheiro",
"Filetype" => "Tipo de ficheiro",
"LongDesc" => "Descrición longa",
"Import/export trackers" => "Importar/exportar trackers",
"Admin groups" => "Administrar grupos",
"Admin users" => "Administrar usuarios",
"Add new group" => "Engadir novo grupo",
"Edit group" => "Editar grupo",
"Members" => "Membros",
"Add a New Group" => "Engadir novo grupo",
"List of existing groups" => "Lista de grupos existentes",
"Includes" => "Inclúe",
"Group Homepage" => "Páxina de inicio de grupo",
"Use wiki page name or full URL" => "Utilice o nome da páxina wiki ou o URL completo",
"Group Information Tracker" => "Tracker de información do grupo",
"choose a group tracker ..." => "elixa un tracker de grupo ...",
"choose a field ..." => "elixa un campo ...",
"Users Information Tracker" => "Tracker de información dos usuarios",
"choose a users tracker ..." => "elixa un tracker de usuarios ...",
"Group tracker item : {\$groupitemid}" => "Ítem de tracker de grupo : {\$groupitemid}",
"Edit Item" => "Editar ítem",
"Group tracker item not found" => "Ítem de tracker de grupo non atopado",
"Members List" => "Lista de membros",
"users in group" => "usuarios no grupo",
"CSV File" => "Ficheiro CSV",
"Add a New User" => "Engadir un novo usuario",
"Rejected users" => "Usuarios rexeitados",
"Reason" => "Razón",
"Edit user" => "Editar usuario",
"Edit Account Settings" => "Editar opcións de conta",
"to groups" => "aos grupos",
"Change user preferences" => "Cambiar preferencias do usuario",
"Manage Group Assignments" => "Xestionar as asignacións de grupo",
"Set Default Groups" => "Poñer grupos por defecto",
"Assign selected to" => "Asignar elixidos a",
"Remove selected from" => "Borrar seleccionado de",
"the following groups:" => "os seguintes grupos:",
"Set the default group of the selected users to" => "Poña o grupo por defecto dos usuarios seleccionados en",
"User tracker item : {\$usersitemid}" => "Ítem do tracker do usuario: {\$usersitemid}",
"Overwrite" => "Sobrescribir",
"Source" => "Fonte",
"Admin Article Types" => "Administrar tipos de artigo",
"List of types" => "Lista de tipos",
"Shows up in the drop down list of article types" => "Móstrase no despregable da lista de tipos de artigo",
"Allow ratings by the author" => "Permite cualificacións polo autor",
"Show before publish date" => "Mostrar antes da data de publicación",
"non-admins can view before the publish date" => "non-administradores poden visualizar antes da data de publicación",
"Show after expire date" => "Mostrar despois da data de expiración",
"non-admins can view after the expire date" => "non-administradores poden visualizar despois da data de expiración",
"Heading only" => "Só encabezado",
"No article body, heading only" => "Sen corpo de artigo, só encabezado",
"Allow comments for this type" => "Permite comentarios para este tipo",
"Comment Can Rate Article" => "Un comentario pode cualificar un artigo",
"Allow comments to include a rating value" => "Permitir que ps  comentarios inclúan un valor de cualificación",
"Show image" => "Mostrar imaxe",
"Show topic or own image" => "Mostrar imaxe do tema ou propia",
"Show avatar" => "Mostrar avatar",
"Show author's avatar" => "Mostrar avatar do autor",
"Show author" => "Mostrar autor",
"Show author name" => "Mostra o nome do autor",
"Show publish date" => "Mostrar data de publicación",
"Show expire date" => "Mostrar data de expiración",
"Show reads" => "Mostrar lecturas",
"Show the number of times the article was read" => "Mostra o número de veces que o artigo foi lido",
"Show size" => "Mostrar tamaño",
"Show the size of the article" => "Mostra o tamaño do artigo",
"Show topline" => "Mostra a liña superior",
"Show a small title over the title" => "Mostra un pequeno título sobre o título",
"Show subtitle" => "Mostra subtítulo",
"Show the subtitle" => "Mostra o subtítulo",
"Show source" => "Mostra fonte",
"Show link to source after article body" => "Mostra a ligazón á fonte despois do corpo do artigo",
"Show Image Caption" => "Mostra o título da imaxe",
"Show a legend under the image" => "Mostra unha lenda debaixo da imaxe",
"Show Language" => "Mostra idioma",
"Show the language" => "Mostra o idioma",
"Creator can edit" => "O creador pode editar",
"The person who submits an article of this type can edit it" => "A persoa que envía un artigo deste tipo pode editalo",
"Show lang" => "Mostrar idioma",
"Review" => "Revisión",
"Classified" => "Clasificado",
"Create a new type" => "Crear un novo tipo",
"Group Information" => "Información do grupo",
"level" => "nivel",
"Create level" => "Crear nivel",
"all permissions in level" => "todos os permisos en nivel",
"Default Group" => "Grupo por defecto",
"Assign Perms to this Group" => "Asignar permisos a este grupo",
"backlinks to" => "retroligazóns a",
"No backlinks to this page" => "Non hai retroligazóns a esta páxina",
"Directory batch upload" => "Carga en lote de directorio",
"Browse Gallery" => "Explorar galería",
"Upload From Disk" => "Cargar desde disco",
"available images" => "imaxes dispoñibles",
"Remove File Extension from Image Name" => "Borre a extensión do ficheiro do nome da imaxe",
"eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "exemplo de \"digicam0001.jpg\" o nome digicam0001 usarase para o campo nome",
"Select a Gallery" => "Seleccione unha galería",
"Process" => "Proceso",
"Edit Post" => "Editar artigo",
"View Blog" => "Visualizar blog",
"Use ...page... to separate pages in a multi-page post" => "Use ...páxina... para separar páxinas nunha publicación multi-páxina",
"Upload image for this post" => "Cargar imaxe para este artigo",
"Trash" => "Lixo",
"Mark entry as private:" => "Marcar entrada como privada:",
"Spellcheck" => "Comprobación ortográfica",
"Save and Exit" => "Gardar e saír",
"Powered by" => "Baseado en",
"Made with" => "Feito con",
"powered by" => "baseado en",
"Execution time" => "Tempo de execución",
"Memory usage" => "Uso de memoria ",
"Server load" => "Carga do servidor",
"Admin Category" => "Administrar categoría",
"Admin the Category System" => "Administrar o sistema de categorías",
"Browse in" => "Navegar en",
"Sheets" => "Follas de cálculo",
"Hide subcategories objects" => "Ocultar obxectos de subcategorías",
"Show subcategories objects" => "Mostrar obxectos de subcategorías",
"Upper level" => "Nivel superior",
"Clear" => "Limpiar",
"List Galleries" => "Listar galerías",
"Edit Gallery" => "Editar galería",
"Rebuild Thumbnails" => "Reconstruír miniaturas",
"Directory Batch" => "Carga de directorio",
"List Gallery" => "Listar galería",
"Monitor this Gallery" => "Monitorizar esta galería",
"Stop Monitoring this Gallery" => "Deixar de monitorizar esta galería",
"Sort Images by" => "Ordenar imaxes por",
"subgallery" => "subgalería",
"Subgallery" => "Subgalería",
"Hit" => "Acceso",
"Original Size" => "Tamaño orixinal",
"rotate right" => "rotar á dereita",
"rotate" => "rotar",
"Details" => "Detalles",
"popup" => "emerxente",
"You can include the image in a tiki page using one of these lines" => "Pode incluír a imaxe nunha páxina tiki usando unha destas liñas",
"Return to Gallery" => "Volver á galería",
"Edit Image" => "Editar imaxe",
"First Image" => "Primeira imaxe",
"Prev Image" => "Imaxe previa",
"Smaller" => "Menor",
"Bigger" => "Maior",
"Popup window" => "Fiestra emerxente",
"Next Image" => "Seguinte imaxe ",
"Slideshow Forward" => "Pase diapositivas adiante",
"Last Image" => "última imaxe",
"Direction" => "Dirección",
"Click to zoom" => "Premer para agrandar",
"Image Name" => "Nome da imaxe",
"Image Scale" => "Escala da imaxe",
"Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/graos decimais)",
"Longitude (WGS84/decimal degrees)" => "Lonxitude (WGS84/graos decimais)",
"Move image" => "Mover imaxe",
"You can view this image in your browser using" => "Pode visualizar esta imaxe no seu navegador usando",
"You can include the image in an HTML page using one of these lines" => "Pode incluír a imaxe nunha páxina HTML usando unha destas liñas",
"Stop Monitoring this Page" => "Deixar de monitorizar esta páxina",
"Monitor this Page" => "Monitorizar esta páxina",
"Group Calendars" => "Calendarios de grupo",
"Organized by" => "Organizado por",
"Tentative" => "Tentativa",
"Confirmed" => "Confirmado",
"Cancelled" => "Cancelado",
"Change Focus" => "Cambiar foco",
"Edit Calendar Item" => "Editar ítem de calendario",
"New Calendar Item" => "Novo ítem de calendario",
"times" => "veces",
"End" => "Fin",
"Calendar import" => "Importar calendario",
"Calendar has been updated" => "O calendario foi actualizado",
"import" => "importar",
"Previous" => "Previo",
"Assign permissions to category" => "Asignar permisos a unha categoría",
"Current permissions for this category" => "Permisos actuais para esta categoría",
"Remove from this Category Only" => "Borrar só desta categoría",
"Remove from this Category &amp; all its Children" => "Borrar desta categoría e de todos os seus fillos",
"Assign permissions" => "Asignar permisos",
"to group" => "ao grupo",
"this category &amp; all its children" => "esta categoría e todos os seus fillos",
"this category only" => "só esta categoría",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "Asignar permisos para <b>todos os fillos</b> é recomendable para un mellor rendemento.",
"Change password enforced" => "Cambio de contrasinal forzoso",
"Old password" => "Contrasinal actual",
"Send a message to us" => "Enviarnos mensaxe",
"Contact us by email" => "Contactarnos por correo",
"Click here to send us an email" => "Prema aquí para enviarnos un correo",
"Contacts" => "Contactos",
"Create/edit contacts" => "Crear/editar contactos",
"First Name" => "Nome",
"Last Name" => "Apelido",
"Nickname" => "Alcume",
"You can browse the generated WebHelp here" => "Pode navegar el AxudaWeb xerado aquí",
"Structure" => "Estutura",
"Top page" => "Páxina principal",
"Tiki Debugger Console" => "Consola do Depurador Tiki",
"Current URL" => "URL actual",
"Command" => "Orde",
"exec" => "executar",
"Type <code>help</code> to get list of available commands" => "Poña <code>help</code> para obter a lista de ordes dispoñibles",
"Add a new site" => "Engadir novo sitio",
"You cannot add sites until Directory Categories are setup." => "Non pode engadir sitios ata que as Categorías de Directorio estean configuradas.",
"Please contact the Site Administrator" => "Por favor contacte co administrador do sitio",
"Site added" => "Sitio engadido",
"Directory Administration" => "Administración de Directorio",
"There are" => "Hai",
"invalid sites" => "sitios incorrectos",
"valid sites" => "sitios válidos",
"Users have visited" => "Os usuarios visitaron",
"sites from the directory" => "sitios desde o directorio",
"Users have searched" => "Os usuarios buscaron",
"times from the directory" => "veces desde o directorio",
"Related" => "Relacionado",
"Validate" => "Validar",
"Admin directory categories" => "Administrar categorías de directorio",
"Add a directory category" => "Engadir unha categoría de directorio",
"Edit this directory category" => "Editar esta categoría de directorio",
"Children type" => "Tipo de fillos",
"Most visited sub-categories" => "Subcategorías máis visitadas",
"Category description" => "Descrición de categoría",
"Random sub-categories" => "Subcategorías ao chou",
"Maximum number of children to show" => "Número máximo de fillos que se van mostrar",
"Editor group" => "Grupo editor",
"cType" => "cTipo",
"allow" => "permitir",
"count" => "conta",
"relate" => "relacionar",
"Parent category" => "Categoría superior",
"Add a related category" => "Engadir unha categoría relacionada",
"Mutual" => "Mutuo",
"Related categories" => "Categorías relacionadas",
"Admin sites" => "Administrar sitios",
"Is valid" => "é válida",
"New Sites" => "Novos sitios",
"Cool Sites" => "Sitios con máis accesos",
"Add a Site" => "Engadir un sitio",
"any" => "calquera",
"in entire directory" => "en todo o directorio",
"Sort by" => "Ordenar por",
"name (desc)" => "nome (desc)",
"name (asc)" => "nome (asc)",
"hits (desc)" => "accesos(desc)",
"hits (asc)" => "accesos (asc)",
"creation date (desc)" => "data de creación (desc)",
"creation date (asc)" => "data de creación (asc)",
"last updated (desc)" => "última actualización (desc)",
"last updated (asc)" => "última actualización (asc)",
"Added" => "Engadida",
"Last updated" => "Última modificación",
"Total links" => "Total de ligazóns",
"Links to validate" => "Ligazóns para validar",
"Searches performed" => "Buscas feitas",
"Total links visited" => "Total de ligazóns visitadas",
"Directory ranking" => "Clasificación de directorios",
"Search results" => "Resultados da busca",
"Validate sites" => "Validar sitios",
"Edit article" => "Editar artigo",
"List Articles" => "Listar artigos",
"View Articles" => "Visualizar artigos",
"Topline" => "LiñaTope",
"Subtitle" => "Subtítulo",
"Author Name" => "Nome do autor",
"Own Image" => "Imaxe propia",
"Article image" => "Imaxe do artigo",
"Use own image" => "Usar imaxe propia",
"Float text around image" => "Texto flotante arredor da imaxe",
"Own image size x" => "Imaxe propia tamaño x",
"Own image size y" => "Imaxe propia tamaño y",
"Image caption" => "Lenda da imaxe",
"Heading" => "Encabezado",
"Body" => "Corpo",
"Publish Date" => "Data de publicación",
"Expiration Date" => "Data de expiración",
"From:" => "Desde:",
"Edit or create banners" => "Editar ou crear pancartas",
"List banners" => "Listar pancartas",
"URL to link the banner" => "URL para ligar a pancarta",
"Client" => "Cliente",
"Max impressions" => "Impresións máximas",
"Show the banner only between these dates" => "Mostrar a pancarta só entre estas datas",
"From date" => "Desde a data",
"To date" => "Ata a data",
"Use dates" => "Usar datas",
"Show the banner only in this hours" => "Mostrar a pancarta só neste horario",
"to" => "a",
"Show the banner only on" => "Mostrar a pancarta só en",
"Mon" => "L",
"Tue" => "M",
"Wed" => "Mc",
"Thu" => "X",
"Fri" => "V",
"Sat" => "S",
"Sun" => "D",
"Select ONE method for the banner" => "Seleccione UN método para a pancarta",
"Use HTML" => "Usar HTML",
"Use image" => "Usar imaxe",
"Image:" => "Imaxe:",
"Current Image" => "Imaxe actual",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Usar a imaxe xerada polo URL (a imaxe será solicitada ao URL indicado para cada impresión)",
"Use text" => "Usar texto",
"Save the Banner" => "Gardar a pancarta",
"Remove Zones (you lose entered info for the banner)" => "Borrar Zonas (perderá a información introducida para a pancarta)",
"Create Blog" => "Crear Blog",
"Current heading" => "Encabezado actual",
"There are individual permissions set for this blog" => "Hai permisos individuais configurados para este blog",
"Number of posts to show" => "Número de artigos para mostrar",
"Allow other user to post in this blog" => "Permitir a outros usuarios publicar neste blog",
"Use titles in blog posts" => "Usar títulos en artigos de blogs",
"Allow search" => "Permitir busca",
"Allow comments" => "Permitir comentarios",
"Show user avatar" => "Mostrar avatar de usuario",
"Blog heading" => "Encabezado do blog",
"Edit Style Sheet" => "Editar folla de estilo",
"Style Sheet" => "Folla de estilo",
"choose a stylesheet" => "escolla unha folla de estilo",
"Try" => "Probar",
"Wiki Help" => "Axuda wiki",
"Colored text" => "Texto en cores",
"Headings" => "Encabezados",
"Show/Hide" => "Mostrar/Ocultar",
"show/hide heading section. + (shown) or - (hidden) by default" => "mostrar/ocultar sección de encabezados. + (mostrar) ou - (ocultar) por defecto",
"Box content" => "Contido da caixa",
"Dynamic variables" => "Variables dinámicas",
"Inserts an editable variable" => "Insire unha variable editable",
"External links" => "Ligazóns externas",
"For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "Para un Wiki externo, use NomeExternoWiki:NomePáxina ou ((Nome Externo Wiki: Nome Páxina))",
"Square Brackets" => "Corchetes",
"Use [[foo] to show [foo]." => "Usar [[foo] para mostrar [foo].",
"Wiki References" => "Referencias Wiki",
"JoinCapitalizedWords or use" => "XuntarPalabrasEnMaiúsculas ou usar",
"page|description" => "páxina|desc",
"for wiki references" => "para referencias no wiki",
"SomeName" => "AlgúnNome",
"prevents referencing" => "impide facer referencia",
"Lists" => "Listas",
"for bullet lists" => "para listas de viñetas",
"for numbered lists" => "para listas numeradas",
"for definiton lists" => "para listas de definicións",
"Tables" => "Táboas",
"Title bar" => "Barra de título",
"creates the editable drawing foo" => "crea o debuxo editable foo",
"Multi-page pages" => "Páxinas multi-páxina",
"Non parsed sections" => "Seccións non procesadas",
"Prevents wiki parsing of the enclosed data." => "Prevén o procesamento wiki dos datos encerrados.",
"Preformated sections" => "Sección preformatadas",
"Block Preformatting" => "Preformato de bloque",
"Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Sangra texto cun número de espazos para convertelo nun bloque monoespazado que segue outras instrucións de formato de Wiki. Será sangrado co mesmo número de espazos que utilizou. Teña en conta que este modo non preserva o espazado exacto e os saltos de liña, use ~pp~...~/pp~ para iso.",
"No description available" => "Sen descrición dispoñible",
"table" => "táboa (sintaxe nova fila = ||)",
"table new" => "nova táboa(sintaxe nova fila = nova liña)",
"external link" => "ligazón externa",
"wiki link'" => "ligazón wiki'",
"heading1" => "encabezado1",
"title bar" => "barra de título",
"box" => "caixa",
"rss feed" => "fonte rss ",
"dynamic content" => "contido dinámico",
"tagline" => "cuqui da sorte ",
"center text" => "centrar texto",
"colored text" => "texto en cores",
"dynamic variable" => "variables dinámicas",
"New wms Metadata" => "Novo metadato wms",
"New Class" => "Nova clase",
"New Projection" => "Nova proxección",
"New Query" => "Nova consulta",
"New Scalebar" => "Nova barra de escala",
"New Layer" => "Nova capa",
"New Label" => "Nova etiqueta",
"New Reference" => "Nova referencia",
"New Legend" => "Nova lenda",
"New Web" => "Nova web",
"New Outputformat" => "Novo formato de saída",
"New Mapfile" => "Novo ficheiro de mapa",
"special chars" => "caracteres especiais",
"special characters" => "caracteres especiais",
"Browse Images" => "Ver imaxe",
"Edit successful!" => "Editado con éxito!",
"The following image was successfully edited" => "A seguinte imaxe foi editada con éxito",
"Image Description" => "Descrición",
"Edit and create Languages" => "Editar e crear linguas",
"Edit and create languages" => "Editar e crear linguas",
"Create Language" => "Crear lingua",
"Shortname" => "Nome curto",
"like" => "como",
"Longname" => "Nome longo",
"Select the language to edit" => "Elixa lingua para editar",
"Add a translation" => "Engadir unha tradución",
"Edit translations" => "Editar traducións",
"Translate recorded" => "Tradución gravada",
"Translation" => "Tradución",
"reset table" => "reiniciar táboa",
"Create New Block" => "Crear novo bloque",
"Return to block listing" => "Volver á lista de bloques",
"Block description: " => "Descrición do bloque: ",
"You are editing block:" => "Está editando o bloque:",
"Publishing date" => "Data de publicación",
"Publishing Date" => "Data de Publicación",
"Edit question options" => "Editar opcións de pregunta",
"List Quizzes" => "Listar cuestionarios",
"Quiz Stats" => "Estatísticas de cuestionarios",
"This Quiz Stats" => "Estatísticas deste cuestionario",
"Edit this Quiz" => "Editar este cuestionario",
"Admin Quizzes" => "Administrar cuestionarios",
"Create/edit options for question" => "Crear/editar opcións para unha pregunta",
"Create/edit quizzes" => "Crear/editar cuestionarios",
"There are individual permissions set for this quiz" => "Existen permisos individuais para este cuestionario",
"Quiz can be repeated" => "O cuestionario pode repetirse",
"Store quiz results" => "Almacena resultados deste cuestionario",
"Immediate feedback" => "Retroalimentación inmediata",
"Show correct answers" => "Mostrar respostas correctas",
"Shuffle questions" => "Remexer preguntas",
"Shuffle answers" => "Remexer respostas",
"Questions per page" => "Preguntas por páxina",
"Quiz is time limited" => "O cuestionario ten un tempo límite",
"Maximum time" => "Tempo máximo",
"Passing Percentage" => "Porcentaxe de realización",
"Quiz" => "Cuestionario",
"canRepeat" => "podeRepetir",
"timeLimit" => "tempoLímite",
"Edit quiz questions" => "Editar preguntas do cuestionario",
"Create/edit questions for quiz" => "Crear/editar preguntas para un cuestionario",
"Question Type" => "Tipo de pregunta",
"Import questions from text" => "Importar preguntas desde o texto",
"Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Instrucións: Escriba ou pegue as súas preguntas de múltiple opción debaixo. Unha liña para a pregunta, logo comezan as opcións de resposta nas liñas subsecuentes. Separe as preguntas adicionais con liñas en branco. Indique as respostas correctas iniciándoas cun carácter \"*\" (sen as comiñas).",
"Input" => "Entrada",
"maxScore" => "Puntuación máxima",
"From Points" => "Desde puntos",
"To Points" => "Ata puntos",
"Answer" => "Resposta",
"Modify Structure" => "Modificar estrutura",
"You will remove" => "Vostede vai borrar",
"and its subpages from the structure, now you have two options:" => "e as súas subpáxinas da estrutura, agora ten dúas opcións:",
"Remove only from structure" => "Borrar só da estrutura",
"Remove from structure and remove page too" => "Borrar da estrutura e borrar tamén a páxina",
"Structure Layout" => "Deseño da estrutura",
"Promote" => "Promover",
"Demote" => "Degradar",
"Current Node" => "Nodo actual",
"Page alias" => "Alcume de páxina",
"Add pages to current node" => "Engadir páxinas a nodo actual",
"After page" => "Despois da páxina",
"Create Page" => "Crear páxina",
"Use pre-existing page" => "Use a páxina preexistente",
"Submit article" => "Enviar artigo",
"List Submissions" => "Listar colaboracións",
"<b>*</b>=optional" => "<b>*</b>=opcional",
"<b>Topline</b>=small line above Title" => "<b>Liña superior</b>=pequena liña sobre o título",
"<b>Subtitle</b>=small line below Title" => "<b>Subtítulo</b>=pequena liña debaixo do título",
"<b>Source</b>=URL to article source" => "<b>Orixe</b>=URL do artigo fonte",
"Edit templates" => "Editar modelos",
"Template listing" => "Lista de modelos",
"Available templates" => "Modelos dispoñibles",
"Edit a topic" => "Editar tema",
"You must specify the object language" => "Debe especificar a lingua do obxecto",
"The object doesn't exist" => "O obxecto non existe",
"The object doesn't have a language" => "O obxecto non ten unha lingua",
"The object has already a translation for this language" => "O obxecto xa ten unha tradución para esta lingua",
"The object is already in the set of translations" => "O obxecto xa está no conxunto de traducións",
"detach" => "separar",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "A Caixa de Area é unha páxina onde pode practicar as súas habilidades de edición; use a vista previa para ver a aparencia da páxina; non se gardarán versións desta páxina.",
"Admin Content Templates" => "Administrar modelos de contido",
"Use rating" => "Usar cualificacións ",
"There is no available poll template." => "Non hai un modelo dispoñible de votación.",
"You should ask an admin to create them." => "Debe pedirlle ao administrador que as cree.",
"an existing poll" => "votación existente",
"votes" => "votos",
"Year:" => "Ano:",
"Authors:" => "Autores:",
"Try to convert HTML to wiki" => "Intentar converter HTML a wiki",
"Import page" => "Importar páxina",
"export all versions" => "exportar todas as versións",
"Upload picture" => "Cargar imaxe",
"License" => "Licenza",
"Important" => "Importante",
"status" => "estado",
"lastModif" => "última modificación",
"Dump" => "Envorcado",
"Admin FAQ" => "Administrar PMF",
"List FAQs" => "Listar PMF",
"View FAQ" => "Ver PMF",
"Edit this FAQ" => "Editar esta PMF",
"New Question" => "Nova pregunta",
"Use a question from another FAQ" => "Usar unha pregunta doutro PMF",
"FAQ questions" => "Preguntas frecuentes",
"Suggested questions" => "Preguntas suxeridas",
"No suggested questions" => "Non hai preguntas suxeridas",
"Upload File" => "Cargar ficheiro",
"View tpl" => "Ver modelo",
"File Galleries tpl" => "Modelo de galerías de ficheiros",
"You can access the file gallery using the following URL" => "Pode acceder á galería usando este URL",
"Admin forums" => "Administrar foros",
"Edit queued message" => "Editar mensaxes en cola",
"make this a thread of" => "transformar isto nun fío de discusión de",
"None, this is a thread message" => "Ningún, esta é unha mensaxe dun fío de discusión",
"summary" => "sumario",
"announce" => "anuncio",
"hot" => "quente",
"no feeling" => "sen emoción",
"frown" => "cello",
"exclaim" => "exclamar",
"mad" => "tolo",
"question" => "pregunta",
"sad" => "triste",
"happy" => "contento",
"wink" => "chisco de ollo",
"Save and Approve" => "Garde e aprobe",
"convert to topic" => "converter a tema",
"List of messages" => "Lista de mensaxes",
"New Topic" => "Novo tema",
"no summary" => "sen sumario",
"No messages queued yet" => "Sen mensaxes aínda na cola",
"Last Post" => "último artigo",
"Configure Forum" => "Configurar foro",
"Reported by" => "Notificado por",
"Pending requests" => "Solicitudes pendentes",
"Request Time" => "Hora da solicitude",
"Accept" => "Aceptado",
"Refuse" => "Rexeitar",
"Waiting requests" => "Solicitudes en espera",
"Your friends" => "Os seus amigos",
"break friendship" => "romper amizade",
"Activity completed" => "Actividade completada",
"Admin process activities" => "Administrar actividades do proceso",
"Add or edit an activity" => "Engadir ou editar unha actividade",
"activity" => "actividade",
"split" => "dividir",
"join" => "unir",
"standalone" => "autónoma",
"interactive" => "interactiva",
"auto routed" => "auto encamiñada",
"Expiration Time" => "Tempo de expiración",
"Years" => "Anos",
"Months" => "Meses",
"Hours" => "Horas",
"Minutes" => "Minutos",
"Add transitions" => "Engadir transicións",
"Add transition from:" => "Engadir transición desde:",
"Add transition to:" => "Engadir transición a:",
"No roles associated to this activity" => "Non hai roles asociados a esta actividade",
"Add Role" => "Engadir rol",
"Add New" => "Engadir novo",
"Process activities" => "Actividades de proceso",
"Routing" => "Encamiñamentos",
"Interactive" => "Interactiva",
"Automatic" => "Automática",
"Auto routed" => "Auto encamiñada",
"route" => "camiño",
"(no roles)" => "(sen roles)",
"No activities defined yet" => "Non hai aínda actividades definidas",
"Process Transitions" => "Procesar transicións",
"List of transitions" => "Lista de transicións",
"Origin" => "Orixe",
"No transitions defined yet" => "Non hai aínda transicións definidas",
"Add a transition" => "Engadir transición",
"Process Graph" => " Grafo de proceso ",
"Galaxia Admin Graph" => "Galaxia Administrar Grafo",
"Galaxia Admin Graph tpl" => "modelo de Galaxia Administrar Grafo",
"Edit Tpl" => "Editar modelo",
"This process is invalid" => "Este proceso é incorrecto",
"Process Graph for" => "Procesar Grafo para",
"No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "Non hai grafo de proceso dispoñible. Ou o proceso aínda contén erros, ou o grafo non está xerado aínda ou <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> non está instalado axeitadamente.",
"List of processes" => "Lista de procesos",
"Inactive" => "Inactivo",
"Active Process" => "Proceso activo",
"Invalid Process" => "Proceso incorrecto",
"Valid Process" => "Proceso válido",
"Activities" => "Actividades",
"New Minor" => "Novo menor",
"New Major" => "Novo maior",
"No processes defined yet" => "Non hai procesos definidos aínda",
"Admin instance" => "Administrar instancia",
"Process:" => "Proceso:",
"Instance" => "Exemplar",
"Workitems" => "ítems de traballo",
"exception" => "excepción",
"completed" => "completada",
"Aborted" => "Abortada",
"Owner" => "Propietario",
"Send all to" => "Enviar todo a ",
"Don't move" => "Non mover",
"Started" => "Iniciada",
"Act status" => "Estado da actividade",
"Ended" => "Terminada",
"Not Defined" => "Non definido",
"Not Interactive" => "Non interactivo",
"Not Ended" => "Non terminada",
"Property" => "Propiedade",
"Add property" => "Engadir propiedade",
"run instance" => "executar exemplar",
"Executed" => "Executado",
"erase" => "borrar",
"Admin processes" => "Administrar procesos",
"Galaxia Admin Processes" => "Galaxia Administrar Procesos",
"Galaxia Admin Processes tpl" => "modelo de Galaxia Administrar Procesos",
"Add or edit a process" => "Engadir ou editar proceso",
"Process Name" => "Nome de proceso",
"is active?" => "está activo?",
"Or upload a process using this form" => "Ou cargue un proceso usando este formulario",
"Admin process roles" => "Administrar roles de proceso",
"Add or edit a role" => "Engadir ou editar un rol",
"Process roles" => "Procesar roles",
"No roles defined yet" => "Non hai aínda roles definidos",
"Map users to roles" => "Asociar usuarios a roles",
"map" => "asociar",
"Map groups to roles" => "Asociar grupos a roles",
"Operation" => "Operación",
"No roles are defined yet so no roles can be mapped" => "Non se definiron aínda roles, polo que non hai roles para asociar",
"List of mappings" => "Listaxe de asociacións",
"No mappings defined yet" => "Non se definiron aínda asociacións",
"Admin process sources" => "Administrar fontes de procesos",
"select source" => "seleccionar fonte",
"Shared code" => "Código compartido",
"Set next user" => "Configurar o seguinte usuario",
"Get property" => "Obter propiedade",
"Set property" => "Configurar propiedade",
"Process form" => "Formulario de proceso",
"Set Next act" => "Configurar seguinte actividade",
"Switch construct" => "Construción \"switch\"",
"Map process roles" => "Asociar roles de proceso",
"Admin Processes" => "Administrar procesos",
"Admin Activities" => "Administrar actividades",
"Admin Roles" => "Administrar roles",
"Edit this Process" => "Editar este proceso",
"Monitor Activities" => "Monitorizar actividades",
"Galaxia Monitor Activities" => "Galaxia Monitorizar Actividades",
"Galaxia Monitor Activities tpl" => "modelo de Galaxia Monitorizar Actividades",
"List of activities" => "Listaxe de actividades",
"Proc" => "Proc.",
"auto" => "auto.",
"int" => "int.",
"routing" => "encamiñamentos",
"Instances" => "Exemplares",
"run" => "executar",
"run activity" => "executar actividade",
"Enter the name of this instance" => "Introduza o nome deste exemplar",
"The name is not valid. Please, enter the name again" => "O nome non é válido, introdúzao de novo",
"Monitor" => "Monitorizar",
"monitor processes" => "monitorizar supervisar procesos",
"monitor activities" => "monitorizar supervisar actividades",
"monitor instances" => "monitorizar exemplares",
"monitor workitems" => "monitorizar ítems de traballo",
"Monitor Instances" => "Monitorizar exemplares",
"Galaxia Monitor Instances" => "Galaxia Monitorizar Exemplares",
"Galaxia Monitor Instances tpl" => "modelo de Galaxia Monitorizar Exemplares",
"List of instances" => "Lista de exemplares",
"Not ended" => "Non terminada",
"No instances created yet" => "Non se crearon aínda exemplares",
"Monitor Processes" => "Monitorizar procesos",
"Galaxia Monitor Processes" => "Galaxia Monitorizar Procesos",
"Galaxia Monitor Processes tpl" => "modelo de Galaxia Monitorizar Procesos",
"processes" => "procesos",
"being run" => "está a executarse",
"Completed" => "Completada",
"Exceptions" => "Excepcións",
"Monitor workitems" => "Monitorizar ítems de traballo",
"List of workitems" => "Listaxe de ítems de traballo",
"instance" => "exemplar",
"My activities" => "As miñas actividades",
"Current Activity" => "Actividade actual",
"Assigned To" => "Asignado a",
"exception instance" => " exemplar de excepción",
"exceptions instance" => "exemplar de excepcións",
"Send Instance" => "Enviar exemplar",
"abort instance" => "abortar exemplar",
"grab instance" => "obter exemplar",
"release instance" => "liberar exemplar",
"No activities found" => "Non se atoparon actividades",
"My instances" => "Os meus exemplares ",
"No instances found" => "Non se atoparon exemplares",
"User Activities" => "Actividades de usuario",
"Galaxia User Activities" => "Galaxia Actividades de Usuario",
"Galaxia User Activities tpl" => "modelo de Galaxia Actividades de Usuario",
"process" => "proceso",
"user processes" => "procesos de usuario",
"user activities" => "actividades de usuario",
"user instances" => "exemplares de usuarios",
"User Instances" => "Exemplares de usuario",
"Galaxia User Instances" => "Galaxia Exemplares de Usuario",
"Galaxia User Instances tpl" => "modelo de Galaxia Exemplares de Usuario",
"Inst Status" => "Estado do exemplar",
"Not defined" => "Non definido",
"No instances defined yet" => "Non hai aínda exemplares definidos",
"User Processes" => "Procesos de usuario",
"Galaxia User Processes" => "Galaxia Procesos de Usuario",
"Galaxia User Processes tpl" => "modelo de Galaxia Procesos de Usuario",
"Browsing Workitem" => "Navegando en ítem de traballo",
"Workitem information" => "Información de ítem de traballo",
"Galleries" => "Galerías",
"Create New Gallery" => "Crear nova galería",
"Create a gallery" => "Crear unha galería",
"Edit this gallery:" => "Editar esta galería:",
"There are individual permissions set for this gallery" => "Hai permisos individuais configurados para esta galería",
"Geographic" => "xeográfico",
"Fields to show during browsing the gallery" => "Campos para mostrar mentres se percorre a galería",
"Creation Date" => "Data de creación",
"XY-Size" => "Tamaño-XY ",
"Gallery Image" => "Imaxe de galería",
"Available scales" => "Escalas dispoñibles",
"Bounding box" => "Caixa delimitadora",
"default scale" => "escala por defecto",
"No scales available" => "Non hai escalas dispoñibles",
"Original image is default scale" => "A imaxe orixinal é a escala por defecto",
"Add scaled images with bounding box of square size" => "Agregar as imaxes escaladas con caixas delimitadoras de tamaño cadrado",
"Other users can upload images to this gallery" => "Outros usuarios poden cargar imaxes nesta galería",
"You can access the gallery using the following URL" => "Pode acceder á galería usando o seguinte URL",
"Available Galleries" => "Galerías dispoñibles",
"Choose a filter" => "Escolla un filtro",
"Imgs" => "Imxs.",
"Make Map" => "Facer mapa",
"Im- Export languages" => "Importar ou Exportar linguas",
"Select the language to Import" => "Elixa a lingua para importar",
"Select the language to Export" => "Elixa a lingua para exportar",
"Import From File" => "Importar desde ficheiro",
"Grab Wiki Tables" => "Obter táboas Wiki",
"Import pages from a Structured Text Dump" => "Importar páxinas desde Envorcado de Texto Estruturado",
"Name of the dump file (it has to be in dump/)" => "Nome do ficheiro de envorcado(ten que estar en dump/)",
"Overwrite existing pages if the name is the same" => "Sobrescribir páxinas se o nome coincide",
"Previously remove existing page versions" => "Borrar versións existentes previamente de páxinas ",
"excerpt" => "extracto",
"Result" => "Resultado",
"body" => "corpo",
"Locked" => "Bloqueado",
"Install" => "Instalar",
"Configure General Settings" => "Configuracións xerais",
"Clear cached version and refresh cache" => "Limpar versión en caché e actualizar",
"configure rules" => "configurar regras",
"Edit Repository" => "Editar almacén",
"Last Changes" => "Últimas modificacións",
"Search by Date" => "Buscar por data",
"LastChanges" => "ÚltimosCambios",
"Rollback" => "Reverter",
"Pages like" => "Páxinas similares",
"No pages found" => "Non se encontraron páxinas",
"Edit New Article" => "Editar novo artigo",
"View Submissions" => "Ver colaboracións",
"ExpireDate" => "Data de Expiración",
"AuthorName" => "Autor",
"Create banner" => "Crear pancarta",
"Method" => "Método",
"Use Dates?" => "Usar datas?",
"Max Impressions" => "Máximo de impresións",
"Impressions" => "Impresións",
"Clicks" => "Clics",
"Create New Blog" => "Crear novo blog",
"Use cache for external pages" => "Usar caché para as páxinas externas",
"Dynamic content system" => "Sistema de contido dinámico",
"Available content blocks" => "Bloques dispoñibles",
"Current ver" => "Versión actual",
"Next ver" => "Próxima versión",
"Future vers" => "Versión futura",
"Program" => "Programar",
"Edit this FAQ:" => "Editar este PMF:",
"Create new FAQ" => "Crear novo PMF",
"Create New FAQ:" => "Crear Novo PMF:",
"Users can suggest questions" => "Os usuarios poden suxerir preguntas",
"Available FAQs" => "PMFs dispoñibles",
"Create a File Gallery" => "Crear galería de ficheiros",
"optional" => "opcional",
"Gallery Images" => "Imaxes de Galería",
"All games are from" => "Todos os xogos son de",
"visit the site for more games and fun" => "visite o sitio para máis xogos e diversión",
"Upload a game" => "Cargar un xogo",
"Upload a new game" => "Cargar un novo xogo",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Miniatura (se o xogo se chama foo.swf a imaxe debe ser foo.swf.gif ou foo.swf.jpg ou foo.swf.png)",
"Edit game" => "Editar xogo",
"Played" => "Xogado",
"If you can't see the game then you need a flash plugin for your browser" => "Se non pode ver o xogo, necesita un plugin de Flash para o seu navegador",
"Edit Blog" => "Editar Blog",
"Blog Title" => "Título do blog",
"Edit New Submission" => "Editar nova colaboración",
"Survey stats" => "Estatísticas de enquisa",
"Take Survey" => "Tomar enquisa",
"Distance (km)" => "Distancia (km)",
"List Movies" => "Lista de filmes",
"Choose a movie" => "Elixa un filme",
"Last mod" => "Última modificación",
"Last author" => "Último autor",
"Last version" => "Última versión",
"unlocked" => "desbloqueada",
"Open client window" => "Abrir a fiestra de cliente",
"Generate HTML" => "Xerar HTML",
"Transcripts" => "Transcricións",
"Online operators" => "Operadores en liña",
"Operator" => "Operador",
"Accepted requests" => "Aceptar solicitudes",
"since" => "desde",
"transcripts" => "transcricións",
"Offline operators" => "Operadores desconectados",
"Add an operator to the system" => "Engadir un operador ao sistema",
"Operators must be tiki users" => "Os operadores deben ser usuarios do tiki",
"Set as Operator" => "Poñer como operador",
"Chat started" => "Charla iniciada",
"Operator:" => "Operador:",
"Live support:User window" => "Asistencia en liña: fiestra do usuario",
"Request live support" => "Solicitar asistencia en liña",
"Request support" => "Solicitar asistencia",
"Open a support ticket instead" => "Abrir un tícket de soporte no seu lugar",
"Your request is being processed" => "O súa solicitude está a ser procesada",
"cancel request and exit" => "cancelar solicitude e saír",
"cancel request and leave a message" => "cancelar solicitude e deixar unha mensaxe",
"Live support:Console" => "Asistencia en liña:Consola",
"be online" => "quedar en liña",
"be offline" => "quedar fóra de liña",
"Support requests" => "Solicitudes de asistencia",
"Requested" => "Solicitude",
"Join" => "Unir",
"Support chat transcripts" => "transcrición de charlas de asistencia",
"operator" => "operador",
"started" => "iniciada",
"reason" => "razón",
"msgs" => "msxs",
"Transcript" => "Transcrición",
"Mail-in feature" => "Característica entrada de correo",
"Prefs" => "Prefs.",
"Remove old events" => "Borrar eventos antigos",
"duration" => "duración",
"Mini Calendar: Preferences" => "Mini Calendario: Preferencias",
"Calendar Interval in daily view" => "Intervalo do calendario na vista diaria",
"Start hour for days" => "Hora de inicio para os días",
"End hour for days" => "Hora final para os días",
"Reminders" => "Recordatorios",
"no reminders" => "sen recordatorios",
"Or enter path or URL" => "Introducir camiño ou URL",
"Add Topic" => "Engadir tema",
"Update remote index" => "Actualizar índice remoto",
"Rebuild local list" => "Reconstruír lista local",
"Republish all" => "Republicar todo",
"Publish all" => "Publicar todo",
"Unpublish all" => "Despublicar todo",
"Attention" => "Atención",
"all types" => "todos os tipos",
"Display only this type" => "Mostrar só este tipo",
"Unpublish" => "Despublicar",
"Republish" => "Republicar",
"Tikiwiki Mods Configuration" => "Configuración Tikiwiki Mods",
"Enable Mods providing" => "Activar prover Mods",
"Mods local directory" => "Directorio local de Mods",
"Mods remote server" => "Servidor remoto de Mods",
"Package Config" => "Configuración de paquete",
"User Pages" => "Páxinas do usuario",
"User Galleries" => "Galerías de usuario",
"Unread Messages" => "Mensaxes non lidas",
"Tasks" => "Tarefas",
"User Blogs" => "Blogs do usuario",
"MyTiki" => "O meu Tiki",
"Notepad" => "Caderno de notas",
"MyFiles" => "OsMeusFicheiros",
"My Watches" => "Os meus monitores",
"Assigned items" => "Ítems asignados",
"Sent editions" => "Edicións enviadas",
"The newsletter was sent to {\$sent} email addresses" => "O boletín foi enviado a {\$sent} enderezos de correo",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Grazas por subscribirse. Axiña recibirá un correo para confirmar a súa subscrición. Non se enviarán boletíns ata que a subscrición sexa confirmada.",
"Your email address was removed from the list of subscriptors." => "O seu enderezo de correo foi eliminado da lista de subscritores.",
"Subscription confirmed!" => "Subscrición confirmada!",
"Subscribe to Newsletter" => "Subscribirse ao boletín",
"Subscribe to this Newsletter" => "Subscribirse",
"Available Newsletters" => "Boletíns dispoñibles",
"Select news group" => "Seleccione un grupo de novas",
"Back to servers" => "Volver a servidores",
"Msgs" => "Msxs",
"News from" => "Grupos de novas desde",
"Back to groups" => "Volver a grupos",
"Save position" => "Gardar posición",
"Reading article from" => "Lendo artigo desde",
"Back to list of articles" => "Volver á lista de artigos",
"Newsgroup" => "Grupo de novas",
"Configure news servers" => "Configurar servidores de grupos de novas",
"Configure Newsreader" => "Configurar lector de grupos de novas",
"configure newsreader server tpl" => "modelo para configurar servidor lector de novas",
"Select a news server to browse" => "Seleccionar un servidor de grupos de novas para explorar",
"server" => "servidor",
"Read the news" => "Ler as noticias",
"News server" => "Servidor de grupos de novas",
"Notes" => "Notas",
"Write a note" => "Escribir unha nota",
"quota" => "cota",
"No notes yet" => "Sen notas aínda",
"Merge selected notes into" => "combinar notas seleccionadas en",
"Reading note:" => "Lendo nota:",
"List notes" => "Listar notas",
"Write note" => "Escribir nota",
"Wiki Create" => "Crear wiki",
"Wiki Overwrite" => "Sobrescribir wiki",
"Assign permissions to " => "Asignar permisos a ",
"Current permissions for this object" => "Permisos actuais para este obxecto",
"No category permissions; global permissions apply" => "Non hai permisos de categoría; aplícanse permisos globais",
"Assign permissions to this object" => "Asignar permisos a este obxecto",
"Published" => "Publicada",
"Orphan Pages" => "Páxinas orfas",
"Browser not supported" => "Navegador non considerado",
"Rename" => "Renomear",
"Slides" => "Diapositivas",
"Discuss" => "Discutir",
"Attach File" => "Anexar ficheiro",
"1 File Attached" => "1 ficheiro anexado",
"Preview of version" => "Previsualización da versión",
"(current)" => "(actual)",
"Rollback to this version" => "Reverter a esta versión",
"Source of version" => "Fonte de versión",
"s=source" => "s=fonte",
"b=rollback" => "b=reverter",
"Pick your avatar" => "Elixir o seu avatar",
"User Preferences" => "Preferencias do usuario",
"Your current avatar" => "O seu avatar actual",
"no avatar" => "sen avatar",
"reset" => "reiniciar",
"Pick avatar from the library" => "Elixa avatar da biblioteca",
"Pick user Avatar" => "Elixir o avatar do usuario",
"Hide all" => "Ocultar todo",
"icons" => "iconas",
"Show all" => "Mostrar todo",
"Avatar Image" => "Imaxe de avatar",
"Upload your own avatar" => "Cargar avatar ou foto",
"View Details" => "Ver detalles",
"Insert" => "Inserir",
"atts" => "atributos",
"List Attachments" => "Listar anexos",
"Average" => "Media",
"View Results" => "Ver Resultados",
"Vote poll" => "Votar encuesta",
"Other Polls" => "Otras encuestas",
"Note: Remember that this is only a preview, and has not yet been saved!" => "Nota: Lembre que isto é só unha previsualización, aínda non foi gardada!",
"on:" => "en:",
"Topic image" => "Imaxe do tema",
"Viewing blog post" => "Leyendo post de blog",
"Return to blog" => "Volver al blog",
"The original document is available at" => "O documento orixinal está dispoñible en",
"Print multiple pages" => "Imprimir múltiples páginas",
"Add Page" => "Engadir páxina",
"Edit quiz" => "Editar cuestionario",
"General Options" => "Opcións xerais",
"Name:" => "Nome:",
"Publication Date" => "Data de publicación",
"at " => "en ",
"Use " => "Usar",
"randomly selected questions." => "preguntas seleccionadas ao chou.",
"Test-time Options" => "Opcións durante o test",
"Limit questions displayed per page to " => "Limitar preguntas mostradas por páxina a ",
"&nbsp question(s)." => "&nbsp pregunta(s).",
"Impose a time limit of " => "Impoña un límite de tempo de",
"Allow students to store partial results and return to quiz." => "Permitir aos estudantes gardar resultados parciais e volver ao cuestionario.",
"Allow students to retake this quiz " => "Permitir aos estudantes retomar este cuestionario",
"Grading and Feedback" => "Cualificación e Resposta",
"Grading method " => "Método de cualificación ",
"Show students their score " => "Mostrar puntuación aos estudantes ",
"Show students the correct answers " => "Mostrar as respostas correctas aos estudantes ",
"Publish statistics " => "Publicar estatísticas ",
"Extra Options" => "Opcións extra",
"Solicit additional questions from students" => "Solicitar preguntas adicionais dos estudantes",
"Link quiz to forum named: " => "Ligar cuestionario a foro chamado: ",
"Prologue:" => "Prólogo:",
"Epilogue:" => "Epílogo:",
"Quiz result stats" => "Estatísticas de resultados de cuestionarios",
"Time" => "Tempo",
"User answers" => "Respostas do usuario",
"Stats for quizzes" => "Estatísticas dos cuestionarios",
"taken" => "tomado",
"Av score" => "Puntuación media",
"Av time" => "Tempo medio",
"Clear Stats" => "Borrar estatísticas",
"time taken" => "tempo empregado",
"Stats for this quiz Questions " => "Estatísticas para as preguntas deste cuestionario ",
"Top 10" => "10 primeiros",
"Top 20" => "20 primeiros",
"Top 50" => "50 primeiros",
"Top 100" => "100 primeiros",
"Received articles" => "Artigos recibidos",
"Edit received article" => "Editar artigo recibido",
"Use Image" => "Usar imaxe",
"Image x size" => "Tamaño x da imaxe",
"Image y size" => "Tamaño y da imaxe",
"Image name" => "Nome da imaxe",
"Accept Article" => "Aceptar artigo",
"Site" => "Sitio",
"Referer stats" => "Estatísticas de referencia",
"A valid email is mandatory to register" => " É obrigatorio un correo válido para rexistrarse",
"Tiki site registered" => "Sitio Tiki rexistrado",
"The following site was added and validation by admin may be needed before appearing on the lists" => "O seguinte sitio foi engadido aínda que o administrador pode requirir unha validación antes de aparecer nas listas",
"You don't have permission to use this feature." => "Non ten permiso para usar esta función.",
"Please register." => "Por favor, rexístrese.",
"Register this site at tikiwiki.org" => "Rexistrar este sitio en tikiwiki.org",
"Read this first!" => "Lea isto primeiro!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "Nesta páxina pode facer que o seu sitio sexa coñecido para tikiwiki.org. Mostrarase nunha lista de sitios tiki coñecidos.",
"Registering is voluntary." => "Rexistrarse é voluntario.",
"Registering does not give you any benefits except one more link to your site." => "Rexistrarse non lle reportará ningún beneficio agás unha ligazón máis ao seu sitio.",
"You don't get any emails, we don't sell the data about your site." => "Non recibirá correos, non venderemos os datos acerca do seu sitio.",
"Registering is just for us to get an overview of Tiki's usage." => "Rexistrarse é só para que nós teñamos unha idea do uso de Tiki.",
"If your site is private or inside your intranet, you should not register!" => "Se o seu sitio é privado ou está dentro dunha intranet, non debería rexistrarse!",
"Information about your site" => "Información acerca do seu sitio",
"Send me my Password" => "Enviar o meu contrasinal",
"Remove page" => "Eliminar páxina",
"Last Version" => "última versión",
"You are about to remove the page" => "Está a piques de eliminar a páxina",
"permanently" => "permanentemente",
"Remove all versions of this page" => "Eliminar todas as versións desta páxina",
"Replicate" => "Replicar",
"Slave" => "Escravo",
"Master" => "Mestre",
"Operations" => "Operacións",
"Operations Log" => "Rexistro de operacións",
"Rollback page" => "Reverter a páxina",
"Searched" => "Buscado",
"Search in" => "Buscar en",
"Simple search" => "Busca simple",
"No pages matched the search criteria" => "Non se encontraron páxinas que encaixen no criterio de busca",
"Send blog post" => "Enviar artigo de blog",
"A link to this post was sent to the following addresses:" => "Unha ligazón a este artigo enviouse aos seguintes enderezos:",
"Send post to this addresses" => "Enviar artigo a este enderezo",
"List of email addresses separated by commas" => "Lista de enderezos de correo separados por comas",
"This newsletter will be sent to {\$subscribers} email addresses." => "Este boletín será enviado a {\$subscribers} enderezos de correo.",
"Prepare a newsletter to be sent" => "Preparar un boletín para envialo",
"Apply content template" => "Aplicar modelo de contido",
"remove" => "eliminar",
"Send objects" => "Enviar obxectos",
"Transmission results" => "Resultados da transmisión",
"Send Wiki Pages" => "Enviar páxinas Wiki",
"Send Articles" => "Enviar artigos",
"Add Article" => "Engadir artigo",
"Send objects to this site" => "Enviar obxectos a este sitio",
"Create a sheet" => "Crear unha folla de cálculo",
"Edit this sheet:" => "Editar esta folla de cálculo:",
"Create New Sheet" => "Crear nova folla de cálculo",
"There are individual permissions set for this sheet" => "Hai permisos individuais configurados para esta folla de cálculo",
"Class Name" => "Nome de Clase",
"Header Rows" => "Filas de cabeceira",
"Footer Rows" => "Filas de pé",
"Create new Sheet" => "Crear nova folla de cálculo",
"You can access the sheet using the following URL" => "Pode acceder á folla de cálculo usando o seguinte URL",
"Available Sheets" => "Follas de cálculo dispoñibles",
"Change shoutbox general settings" => "Cambiar as opcións xerais da do taboleiro de anuncios",
"auto-link urls" => "autoligar urls",
"Post or edit a message" => "Enviar ou editar mensaxe",
"Parent page" => "Páxina superior",
"Child" => "Fillo",
"Last edited by" => "Última edición por",
"based on work by" => "baseado no traballo de",
"Contributors to this page" => "Contribuidores a esta páxina",
"big grin" => "gran sorriso",
"confused" => "confundido",
"cool" => "xebre",
"cry" => "chorar",
"eek" => "Oh!",
"evil" => "malvado",
"lol" => "rag",
"mr green" => "sr. verde",
"razz" => "burlón",
"redface" => "ruborizado",
"rolleyes" => "caviloso",
"smile" => "sorriso",
"surprised" => "sorprendido",
"twisted" => "revirado",
"arrow" => "frecha",
"santa" => "papá noel",
"Site Stats" => "Estatísticas do sitio",
"Total pageviews" => "Total de acccesos",
"Average pageviews per day" => "Media de accesos por día",
"Best day" => "O mellor día",
"Worst day" => "O peor día",
"Wiki Stats" => "Estatísticas do Wiki",
"Size of Wiki Pages" => "Tamaño das páxinas",
"Average page length" => "Tamaño medio das páxinas",
"Average versions per page" => "Media de versións por páxina",
"Visits to wiki pages" => "Visitas a páxinas do wiki",
"Orphan pages" => "Páxinas orfas",
"Average links per page" => "Cantidade media de ligazóns por páxina",
"Image galleries Stats" => "Estatísticas de galerías de imaxes",
"Average images per gallery" => "Media de imaxes por galería",
"Total size of images" => "Tamaño total das imaxes",
"Average image size" => "Tamaño medio da imaxe",
"Visits to image galleries" => "Visitas a galerías de imaxes",
"File galleries Stats" => "Estatísticas de galerías de ficheiros",
"Average files per gallery" => "Media de ficheiros por galería",
"Total size of files" => "Tamaño total de ficheiros",
"Average file size" => "Tamaño medio de ficheiro",
"Visits to file galleries" => "Cantidade de visitas a galerías de ficheiros",
"CMS Stats" => "Estatísticas do CMS",
"Total reads" => "Total de lecturas",
"Average reads per article" => "Media de lecturas por artigo",
"Total articles size" => "Tamaño total dos artigos",
"Average article size" => "Tamaño medio dun artigo",
"Forum Stats" => "Estatísticas de foros",
"Total topics" => "Total de temas",
"Average topics per forums" => "Media de temas por foro",
"Visits to forums" => "Visitas aos foros",
"Blog Stats" => "Estatísticas de blog",
"Weblogs" => "Cantidade de blogs",
"Total posts" => "Total de artigos",
"Average posts per weblog" => "Media de artigos por blog",
"Total size of blog posts" => "Tamaño total dos artigos",
"Average posts size" => "Tamaño medio dun artigo",
"Visits to weblogs" => "Visitas aos blogs",
"Poll Stats" => "Estatísticas de votación",
"Total votes" => "Total de votos",
"Average votes per poll" => "Media de votos por votación",
"Total questions" => "Total de preguntas",
"Average questions per FAQ" => "Media de preguntas por PMF",
"User Stats" => "Estatísticas de usuario",
"User bookmarks" => "Marcadores do usuario",
"Average bookmarks per user" => "Media de marcadores por usuario",
"Average questions per quiz" => "Media de preguntas por cuestionario",
"Quizzes taken" => "Cuestionarios tomados",
"Average quiz score" => "Puntuación media de cuestionario",
"Average time per quiz" => "Media de tempo por cuestionario",
"Stats for surveys" => "Estatísticas de enquisas",
"Last taken" => "Última resposta",
"Time Left" => "Tempo restante",
"Send Answers" => "Enviar respostas",
"Thank you for your submission" => "Grazas polo seu envío",
"Your email was sent" => "O seu correo foi enviado",
"Theme is selected as follows" => "O decorado foi seleccionado como segue",
"If a theme is assigned to the individual object that theme is used." => "Se un decorado está asignado a un obxecto individual, úsase ese decorado.",
"If not then if a theme is assigned to the object's category that theme is used" => "Se non, entón se un decorado é asignado á categoría do obxecto, úsase ese decorado",
"If not then a theme for the section is used" => "Se non, entón úsase un decorado para a sección",
"If none of the above was selected the user theme is used" => "Se nada do anterior foi seleccionado, usarase o decorado do usuario",
"Finally if the user didn't select a theme the default theme is used" => "Finalmente, se o usuario non elixiu decorado ningún, usarase o decorado por defecto",
"Control by Objects" => "Control por Obxectos",
"Control by Sections" => "Control por Seccións",
"Assign themes to categories" => "Asignar decorado a categorías",
"Assigned categories" => "Categorías asignadas",
"Theme Control Center: Objects" => "Centro de Control de Decorados: Obxectos",
"Control by Categories" => "Control por categorías",
"Assign themes to objects" => "Asignar decorados a obxectos",
"Assigned objects" => "Obxectos asignados",
"Assign themes to sections" => "Asignar decorados a seccións",
"Assigned sections" => "Seccións asignadas",
"Edit File:" => "Editar ficheiro:",
"The following file was successfully uploaded" => "O seguinte ficheiro foi cargado con éxito",
"You can download this file using" => "Pode descargar este ficheiro usando",
"You have to create a gallery first!" => "Primeiro debe crear unha galería!",
"Batch Upload Results" => "Resultados da carga en lote",
"Upload successful!" => "Imaxe recibida correctamente!",
"The following image was successfully uploaded" => "A seguinte imaxe recibiuse correctamente",
"Image ID thumb" => "Miniatura da imaxe",
"You can include the image in an Wiki page using" => "Pode incluír a imaxe nunha páxina wiki usando",
"or use filename" => "ou use o nome do ficheiro",
"Now enter the image URL" => "Agora introduza o URL da imaxe",
"or upload a local image from your disk" => "ou cargue unha imaxe desde o seu disco local",
"Batch Upload" => "Carga por lote",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Miniatura (opcional, prevalece sobre a xeración automática de miniaturas)",
"Note: Maximum image size is limited to" => "Nota: o tamaño máximo dunha imaxe está limitado a",
"User assigned modules" => "Módulos asignados polo usuario",
"Assign module" => "Asignar módulo",
"Column" => "Columna",
"Current folder" => "Carpeta actual",
"Folders" => "Carpetas",
"Folder in" => "Abrir carpeta",
"Remove Folder" => "Borrar carpeta",
"Refresh Cache" => "Refrescar caché",
"Admin folders and bookmarks" => "Administrar carpetas e marcadores",
"Send me a message" => "Enviarme unha mensaxe",
"Assign Group" => "Asignar grupo",
"Homepage" => "Inicio",
"Users HomePage" => "Páxina inicial dos usuarios",
"Personal Wiki Page" => "Páxina Wiki Persoal",
"Create page" => "Crear páxina",
"This user is your friend" => "Este usuario é o seu amigo",
"Request friendship from this user" => "Solicitar a amizade deste usuario",
"Toggle options" => "Cambiar opcións",
"Personal Information" => "Información persoal",
"Your personal Wiki Page" => "A súa páxina persoal no Wiki",
"Your personal tracker information" => "O seu tracker de información persoal",
"View extra information" => "Visualizar información extra",
"Is email public? (uses scrambling to prevent spam)" => "É público o correo? (usa cifrado para previr correo lixo)",
"Unavailable - please set your e-mail below" => "Non dispoñible - por favor, configure o seu correo debaixo",
"Does your mail reader need a special charset" => "O seu lector de correo require un xogo de caracteres especial",
"Note author when reading his mail" => "Avisa o autor cando lea o seu correo",
"Account Information" => "Información da conta",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Deixe os campos \"Novo contrasinal\" e \"Confirmar contrasinal\" en branco para conservar o contrasinal actual",
"Email address" => "Enderezo de correo",
"Confirm new password" => "Confirmar o nova contrasinal",
"Current password (required)" => "Contrasinal actual (requirido)",
"Change administrative info" => "Cambiar a información administrativa",
"New task" => "Nova tarefa",
"Task list" => "Lista de tarefas",
"Admin mode off" => "Modo admininistrador desactivado",
"Admin mode on" => "Modo admininistrador activado",
"Task help" => "Axuda de tarefas",
"Empty Trash" => "Baleirar papeleira",
"Received task" => "Tarefa recibida",
"You received this task, please read and execute it" => "Recibiu esta tarefa, por favor léaa e execútea",
"Send task" => "Enviar tarefa",
"You send this task to a other user" => "Pode enviar esta tarefa a outro usuario",
"Shared task" => "Tarefa compartida",
"This task is public to a special group" => "Esta tarefa é pública para un grupo especial",
"Accepted by Task User and Creator" => "Aceptada polo usuario de tarefa e o creador",
"Accepted User and Creator" => "Aceptado (usuario e creador)",
"Task is accepted by user and creator" => "Tarefa aceptada por usuario e creador",
"Not Accepted by One User" => "Non aceptada por un usuario",
"Not Accepted User" => " non aceptado (usuario)",
"Task is rejected by one user" => "A tarefa é rexeitada por un usuario",
"Waiting for Me" => "Esperando por min",
"Task is not accepted by you, read the task and accept or reject it" => "Non aceptou a tarefa, lea a tarefa e acéptea ou rexéitea",
"Waiting for Other User" => "Esperando por outro usuario",
"Task is not accepted/rejected by other user" => "A tarefa non é aceptada/rexeitada por outro usuario",
"Admin Mode" => "Modo administrador",
"Edit task" => "Editar tarefa",
"NOT accept" => "NON acepta",
"Remove from Trash" => "Sacar da papeleira",
"Move into Trash" => "Botar na papeleira",
"Task saved" => "Tarefa gardada",
"Edit Task" => "Editar tarefa",
"View Task" => "Ver tarefa",
"Open a new task" => "Abrir nova tarefa",
"taskId" => "ID da tarefa",
"Task user" => "Usuario da tarefa",
"Only the creator can delete this task" => "Só o creador pode borrar esta tarefa",
"Use start date and time" => "Usar data e hora de inicio",
"Use end date and time" => "Usar data e hora de fin",
"Open / In Process" => "Aberta / en proceso",
"Waiting / Not Started" => "Esperando / non empezada",
"Percentage completed" => "Porcentaxe completada",
"Waiting" => "Esperando",
"Shared for Group" => "Compartida para grupo",
"Accepted by User" => "Aceptada por usuario",
"No / Rejected" => "Non / rexeitada",
"Accepted by Creator" => "Aceptada polo creador",
"This message will be send to users if you are makeing changes of assigned tasks" => "Esta mensaxe será enviada aos usuarios se está facendo cambios a tarefas asignadas",
"Send message with changes" => "Enviar mensaxe con cambios",
"Modified by" => "Modificado por",
"Marked as deleted" => "Marcado como borrado",
"Inform task user by email" => "Informa o usuario da tarefa por correo-e",
"You can only view this task" => "Só pode ver esta tarefa",
"%m/%d/%Y [%H:%M]" => "%d/%m/%Y [%H:%M]",
"No tasks entered" => "Non se introduciron tarefas",
"Select One" => "Seleccione unha",
"Undo Trash" => "Desfacer papeleira",
"Show:" => "Mostrar:",
"Received" => "Recibido/a",
"Submitted" => "Enviado/a",
"Shared" => "Compartido/a",
"All Shared Tasks" => "Todas as tarefas compartidas",
"completed (100%)" => "completada (100%)",
"Public for group" => "Publica para grupo",
"Add Watch" => "Engadir monitor",
"Watches" => "Monitores",
"A user submits a blog post" => "Un usuario presenta unha mensaxe de blog",
"A user posts a forum thread" => "Un usuario presenta un argumento no foro",
"A user posts a forum topic" => "Un usuario anuncia un tema do foro",
"A user edited a wiki page" => "Un usuario editou unha páxina wiki",
"May need to refresh twice to see changes" => "Pode ter que refrescar dúas veces para ver os cambios",
"Add top level bookmarks to menu" => "Engadir marcadores do nivel principal ao menú",
"replace window" => "substituír fiestra",
"User_versions_for" => "Versións do usuario para",
"This page is being edited by" => "Esta páxina está sendo editada por",
"Proceed at your own peril" => "Proceda pola súa conta e risco",
"Insert Row" => "Inserir fila",
"Insert Column" => "Inserir columna",
"Remove Row" => "Borrar fila",
"Remove Column" => "Borrar columna",
"Merge Cells" => "Unir celas",
"Restore Cells" => "Restaurar celas",
"Copy Calculation" => "Copiar cálculo",
"Format Cell" => "Formatar cela",
"Before" => "Antes",
"After" => "Despois",
"expires:" => "expira:",
"Banner stats" => "Estatísticas de pancarta",
"Create new banner" => "Crear nova pancarta",
"Banner Information" => "Información de pancarta",
"Click ratio" => "Taxa de clics",
"Weekdays" => "Días da semana",
"mon" => "l",
"tue" => "m",
"wed" => "mc",
"thu" => "x",
"fri" => "ve",
"sat" => "s",
"sun" => "dom",
"Banner raw data" => "Datos en bruto da pancarta",
"Cached" => "Almacenado na caché",
"This is a cached version of the page." => "Esta é a versión cacheada da páxina.",
"Click here to view the Google cache of the page instead." => "Prema aquí para ver a caché de Google da páxina.",
"Edit Items" => "Editar ítems",
"List Charts" => "Listar charts",
"Last Chart" => "último chart",
"Previous Chart" => "Chart anterior",
"Chart created" => "chart creado",
"Next Chart" => "Seguinte chart",
"Pre" => "Pre.",
"Permanency" => "Permanencia",
"chg" => "cambio",
"Avg" => "Media",
"info/vote" => "info/voto",
"Next chart will be generated on" => "O seguinte chart será xerado en",
"View or vote items not listed in the chart" => "Visualizar o votar ítems que non están listados no chart",
"Select something to vote on" => "Seleccionar algo para votar",
"Item information" => "Información de ítem",
"Dif" => "Dif.",
"Best Position" => "Mellor posición",
"Vote this item" => "Votar este ítem",
"Highest" => "Superior",
"Answers" => "Respostas",
"Add Suggestion" => "Agregar suxestión",
"Forum List" => "Lista de foros",
"Edit Forum" => "Editar foro",
"Summary" => "Resumo",
"Moderator Actions" => "Accións de moderador",
"Move Selected Topics" => "Mover temas seleccionados",
"Unlock Selected Topics" => "Desbloquear temas seleccionados",
"Lock Selected Topics" => "Bloquear temas seleccionados",
"Delete Selected Topics" => "Borrar temas seleccionados",
"Merge" => "Combinar",
"Merge Selected Topics" => "Combinar temas seleccionados",
"Reported Messages:" => "Mensaxes divulgadas:",
"Queued Messages:" => "Mensaxes na cola:",
"Merge into topic" => "Combinar no tema",
"Emot" => "Emot.",
"pts" => "pts.",
"Announce" => "Anuncio",
"Hot" => "Quente",
"No topics yet" => "Sen tema aínda",
"Jump to forum" => "Ir ao foro",
"Last hour" => "Última hora",
"Last 24 hours" => "Últimas 24 horas",
"Last 48 hours" => "Últimas 48 horas",
"prev topic" => "tema ant",
"next topic" => "tema seg",
"Show posts" => "Mostrar mensaxes",
"Insert New Item" => "Inserir ítem",
"Edit Fields" => "Editar campos",
"View inserted item" => "Ver ítem inserido",
"Insert new item" => "Inserir ítem",
"Tracker Item:" => "Ítem de tracker:",
"View Item" => "Visualizar ítem",
"Filter Tracker Items" => "Filtrar ítems de tracker",
"Add a Comment" => "Engadir un comentario",
"Items list" => "Lista de ítems",
"Special Operations" => "Operacións especiais",
"close" => "pechar",
"Show All" => "Mostrar todo",
"Clip" => "clip",
"Back To Mailbox" => "volver á caixa do correo",
"Full Headers" => "ver cabeceiras",
"Normal Headers" => "cabeceiras normais",
"Reply To All" => "responder a todos",
"Forward" => "reenviar",
"Select from address book" => "elixir desde a axenda de enderezos",
"Use HTML mail" => "Usar correo HTML",
"The following addresses are not in your address book" => "Os seguintes enderezos non están na súa axenda de enderezos",
"Add Contacts" => "Engadir contactos",
"Attachment 1" => "Anexo 1",
"Attachment 2" => "Anexo 2",
"Attachment 3" => "Anexo 3",
"Address book" => "Axenda de enderezos",
"page id" => "id de páxina",
"3d browser" => "navegador 3d",
"Show/Hide Left Menus" => "Mostrar/Ocultar menús da esquerda",
"Show/Hide Right Menus" => "Mostrar/Ocultar menús da dereita",
"Number of voices" => "Número de votos",
"Categories:" => "Categorías:",
"Save Minor Edit" => "Menor",
"Compose Message" => "Escriba unha mensaxe",
"Enable/disable Tiki features here, but configure them elsewhere" => "Active/Desactive características de Tiki aquí, pero configúreas noutro lugar",
"General preferences and settings" => "Configuracións e preferencias xerais",
"User registration, login and authentication" => "Rexistro de usuario, inicio de sesión e autenticación",
"Wiki settings" => "Configuracións para o Wiki",
"Wiki Attachments" => "Anexos ao Wiki",
"Article/CMS settings" => "Configuración para o Artigo/CMS",
"Poll comments settings" => "Configuración dos comentarios para votacións",
"Configuration options for all blogs on your site" => "Opcións de configuración para todos os blogs do seu sitio",
"Forums settings" => "Configuración de foros",
"FAQ comments settings" => "Configuración de comentarios do PMF",
"Trackers settings" => "Configuración de trackers",
"RSS feeds" => "Fontes RSS",
"RSS settings" => "Configuración RSS",
"Directory settings" => "Configuración de directorio",
"Maps configuration" => "Configuración de mapas",
"Meta Tags settings" => "Configuración de meta etiquetas ",
"Search settings" => "Configuración de busca",
"Score settings" => "Configuración do sistema de puntuación",
"Community settings" => "Configuración de comunidade",
"Calendar settings" => "Configuración do calendario",
"Help on \$admintitle Config" => "Axuda sobre a configuración de \$admintitle ",
"Category can`t be parent of itself" => "A categoría non pode ser superior a si mesma",
"No chart indicated" => "Non se indicó chart",
"Upload failed" => "Carga errónea",
"You have to provide a hotword and a URL" => "Ten que fornecer unha palabra clave e un URL",
"Detected, Version:" => "Detectado, Versión:",
"Not detected." => "Non detectada.",
"Your admin password has been changed" => "O seu contrasinal de admin foi cambiado",
"All Fields except gdaltindex must be filled" => "Todos os campos agás gdaltindex deben cubrirse",
"No valid gdaltindex executable" => "Executable gdaltindex non válido",
"Tag already exists" => "A etiqueta xa existe",
"Tag not found" => "Etiqueta non atopada",
"Repository name can't be an empty" => "O nome do almacén non pode estar baleiro",
"Requested action is not supported on repository" => "Acción solicitada non está permitida polo almacén",
"No repository" => "Sen almacén",
"Search is mandatory field" => "Buscar é un campo requirido",
"File not found " => "Ficheiro non atopado",
"Requested action in not supported on repository" => "A acción solicitada non está permitida no almacén",
"Non-existent link" => "Ligazón inexistente",
"Mail-in account %s incorrect" => "Conta de correo de entrada %s incorrecta",
"Mail-in account %s saved" => "Conta de correo de entrada %s gardada",
"Frequency should be a positive integer!" => "A frecuencia debe de ser un enteiro positivo!",
"Mail-in accounts set to be checked every %s minutes" => "As contas de correo de entrada están configuradas para verificar cada %s minutos",
"Automatic Mail-in accounts checking disabled" => "Verificación automática de contas de correo de entrada desactivada",
"No menu indicated" => "Non se indica menú",
"No newsletter indicated" => "Non se indica boletín",
"No poll indicated" => "Non se indica votación",
"unsafe" => "inseguro",
"register_globals should be off by default. See the php manual for details." => "register_globals debería estar desactivado por defecto. Vexa o manual de php para os detalles.",
"safe" => "seguro",
"session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid debería estar desactivado por defecto. Vexa o manual de php para os detalles.",
"upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "Probablemente upload_tmp_dir está dentro do seu directorio Tikiwiki. Existe o risco de que alguén poida cargar algúns ficheiros a este directorio e acceder a eles pola vía do navegador",
"cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "Non se puido verificar se upload_tmp_dir é accesible pola vía do navegador. Para estar seguro, debe comprobar a configuración do seu servidor web.",
"setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "Activar a opción xbithack é inseguro. Dependendo do manexo de ficheiros do seu servidor e a súa configuración de tiki, pode ser posible que un atacante suba scripts á súa galería de ficheiros e os execute",
"The Path to store files in the filegallery should be outside the tiki root directory" => "O camiño para gardar ficheiros na galería de ficheiros debería estar fóra da raíz do directorio de tiki",
"The Path to store files in the imagegallery should be outside the tiki root directory" => "O camiño para gardar ficheiros na galería de imaxes debe estar fóra do directorio raíz de tiki",
"File is not readable. Unable to check." => "O ficheiro non é lexible. Non é posible verificalo.",
"You have to provide a word" => "Debe fornecer unha palabra",
"Permission denied you cannot view this page" => "Non ten permiso para visualizar a páxina",
"Permission denied you cannot edit this page" => "Non pode editar esta páxina",
"You must specify a page name, it will be created if it doesn't exist." => "Debe especificar un nome de páxina; será creada se non existe.",
"page not added (Exists)" => "páxina non engadida (existe)",
"No survey indicated" => "Non se indica enquisa",
"You don't have permission to use this feature" => "Non ten permiso para usar esta característica",
"No Errors detected" => "Non se detectaron erros",
"No tracker indicated" => "Non se indica tracker",
"Group already exists" => "O grupo xa existe",
"User doesn't exist" => "O usuario non existe",
"No records were found. Check the file please!" => "Non se atoparon rexistros. Comprobe o ficheiro, por favor!",
"User login is required" => "Inicio de sesión de usuario obrigatorio",
"Password is required" => "O contrasinal é obrigatorio",
"Email is required" => "O correo-e é obrigatorio",
"User is duplicated" => "O usuario está duplicado",
"Created account %s <%s>" => "Creada conta %s <%s>",
"Assigned %s in group %s" => "Asignado %s a grupo %s",
"User %s already exists" => "Usuario %s xa existe",
"New %s created with %s %s." => "Novo %s creado con %s %s.",
"Impossible to create new %s with %s %s." => "Imposible crear un novo %s con %s %s.",
"%s %s successfully deleted." => "%s %s correctamente borrado.",
"%s %s removed from %s %s." => "%s %s eliminado desde %s %s.",
"%s <b>%s</b> successfully deleted." => "%s <b>%s</b> borrado correctamente.",
"%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> asignado a %s <b>%s</b>.",
"%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> borrado de %s <b>%s</b>.",
"group <b>%s</b> set as the default group of user <b>%s</b>." => "grupo <b>%s</b> establecido como grupo por defecto de usuario <b>%s</b>.",
"%s changed from %s to %s" => "%s cambiado de %s a %s",
"Impossible to change %s from %s to %s" => "Imposible cambiar %s de %s a %s",
"%s modified successfully." => "%s modificado con éxito.",
"password" => "contrasinal",
"%s modification failed." => "fallou a modificación de %s.",
"rss feed disabled" => "fonte rss desactivada",
"Tiki RSS feed for articles" => "fonte RSS Tiki para os artigos",
"Last articles." => "Últimos artigos.",
"Unknown group" => "Grupo descoñecido",
"Group doesn't exist" => "O grupo non existe",
"You have to indicate a group" => "Debe indicar un grupo",
"This group is invalid" => "Este grupo é incorrecto",
"Permission denied you cannot view backlinks for this page" => "Permiso denegado, non pode ver retroligazóns cara a esta páxina",
"The page cannot be found" => "Non se atopou a páxina ",
"Image Galleries Admin Panel" => "Panel de administración das galerías de imaxes",
"Could not read image %s." => "Non é posible ler a imaxe %s.",
"Image %s upload failed." => "Fallo ao cargar a imaxe %s.",
"Image %s uploaded successfully." => "Imaxe %s cargada con éxito.",
"Image %s removed from Batch directory." => "Imaxe %s borrada do directorio por lotes.",
"Impossible to remove image %s from Batch directory." => "Imposible borrar imaxe%s do directorio por lotes.",
"Permission denied you cannot use the batch directory loading" => "Permiso denegado, non pode usar a carga de directorio en lotes",
"Incorrect directory chosen for batch upload of images." => "Directorio elixido incorrecto para a carga en lote de imaxes.",
"Please setup that dir on " => "Por favor, configure ese directorio en",
"Please contact the website administrator." => "Por favor, póñase en contacto co administrador do sitio web.",
"Invalid directory name" => "Nome de directorio inválido",
"You can't post in any blog maybe you have to create a blog first" => "Non pode publicar en ningún blog, debería crear primeiro un blog",
"Permission denied you cannot post" => "Non ten permiso para publicar",
"Permission denied you cannot edit this post" => "Non pode editar este artigo",
"Top visited blogs" => "Blogs máis visitados",
"Last posts" => "Últimos artigos",
"Top active blogs" => "Blogs máis activos",
"Tiki RSS feed for blog: " => "fonte RSS Tiki para o blog: ",
"No blogId specified" => "Non se especificou ID de blog",
"Tiki RSS feed for weblogs" => "Fonte RSS Tiki para os blogs",
"Last posts to weblogs." => "Últimos artigos en blogs.",
"Permission denied you cannot access this gallery" => "Non ten permisos para acceder a esta galería",
"No gallery indicated" => "Non se indica a galería",
"Permission denied you can not view this section" => "Permiso denegado, non pode visualizar esta sección",
"Permission denied you cannot remove images from this gallery" => "Non ten permiso para quitar imaxes desta galería",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Permiso denegado, non pode reconstruír miniaturas nesta galería",
"Permission denied you cannot rotate images in this gallery" => "Permiso denegado, non pode rotar imaxes nesta galería",
"No image indicated" => "Non se indica imaxe",
"Permission denied you cannot move images from this gallery" => "Non ten permiso para mover imaxes desta galería",
"Permission denied you cannot view the calendar" => "Permiso denegado, non pode visualizar o calendario",
"event without name" => "evento sen nome",
"Access Denied" => "Acceso denegado",
"First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "Primeiro día da semana: Domingo (o seu ID é 0) - os tradutores necesitan internacionalizar esta cadea!",
"No category indicated" => "Non se indicou a categoría",
"Permission denied; you cannot assign permissions for this category" => "Permiso denegado; non pode asignar permisos para esta categoría",
"You can not use the same password again" => "Non pode usar o mesmo contrasinal outra vez",
"Top authors" => "Principais autores",
"Account validated successfully." => "Conta validada con éxito.",
"ERROR: you must include a subject or a message at least" => "ERRO: debe incluír un asunto ou unha mensaxe polo menos",
"You need to change chmod 'whelp' manually to 777" => "Debe cambiar chmod 'whelp' manualmente a 777",
"This feature has been disabled" => "Esta sección foi desactivada",
"Tiki RSS feed for directory sites" => "Fonte RSS Tiki para sitios de directorio",
"Last sites." => "Últimos sitios.",
"Must enter a name to add a site. " => "Debe introducir un nome para engadir un sitio. ",
"Must enter a url to add a site. " => "Debe introducir un URL para engadir un sitio.",
"URL already added to the directory. Duplicate site? " => "O URL xa fora engadida ao directorio. Quere duplicar o sitio? ",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "Non se pode ser acceder ao URL. URL incorrecto ou sitio fóra de liña, e non se pode engadir ao directorio.",
"Must select a category. " => "Debe escoller unha categoría.",
"Must enter a name to add a site" => "Debe introducir un nome para engadir un sitio",
"Must enter a url to add a site" => "Debe introducir un URL para engadir un sitio",
"URL already added to the directory. Duplicate site?" => "URL xa engadido ao directorio. Quere duplicar o sitio?",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "Non se pode acceder ao URL: URL incorrecto ou sitio fóra de liña e non se pode engadir ao directorio",
"Must select a category" => "Debe escoller unha categoría",
"No site indicated" => "Non se indicou sitio",
"No parent specified" => "Non se especificou superior",
"Last sites of directory \".\$rc[\"name\"].\" ." => "Últimos sitios no directorio \".\$rc[\"name\"].\" .",
"Article not found" => "Artigo non atopado",
"Permission denied you cannot edit this article" => "Non ten permiso para editar este artigo",
"The language can't be changed as its set of translations has already this language" => "Non se pode cambiar a lingua xa que o seu conxunto de traducións xa ten esa lingua",
"You do not have permissions to edit banners" => "Non ten permiso para editar pancartas",
"Banner not found" => "Pancarta non atopada",
"You do not have permission to edit this banner" => "Non ten permiso para editar esta pancarta",
"Permission denied you cannot create or edit blogs" => "Non ten permiso para crear ou editar blogs",
"Permission denied you cannot edit this blog" => "Non ten permiso para editar este blog",
"You do not have permission to write the style sheet" => "Non ten permiso para escribir a folla de estilo",
"Invalid request to edit an image" => "Solicitude incorrecta para editar unha imaxe",
"Permission denied you cannot edit images" => "Non pode editar imaxes",
"Permission denied you can edit images but not in this gallery" => "Permiso denegado: pode editar imaxes, pero non nesta galería",
"Failed to edit the image" => "Erro ao editar a imaxe",
"Permission denied to use this feature" => "Non ten permiso para acceder a esta característica",
"Shortname must be 2 Characters" => "O nome curto debe ser de dous caracteres",
"You must provide a longname" => "Debe fornecer un nome longo",
"Language created" => "Lingua creada",
"No content id indicated" => "Non se indicou un ID de contido",
"No question indicated" => "Non se indica pregunta",
"No quiz indicated" => "Non se indica cuestionario",
"No structure indicated" => "Non se indicou estrutura",
"Invalid structure_id or page_ref_id" => "structure_id ou page_ref_id incorrectas",
"Permission denied you cannot send submissions" => "Non ten permiso para enviar colaboracións",
"Permission denied you cannot edit submissions" => "Non ten permiso para editar colaboracións",
"You have to create a topic first" => "Primeiro ten que crear un tema",
"You do not have permission to do that" => "Non ten permiso para facer iso",
"You do not have permission to read the template" => "Non ten permiso para ler o modelo",
"No topic id specified" => "Non se especificou o id do tema",
"Invalid topic id specified" => "O Id de tema especificado é incorrecto",
"No object indicated" => "Non se indicou obxecto",
"No type indicated" => "Non se indicou tipo",
"page imported" => "páxina importada",
"created from import" => "creada desde importación",
"Can't import remote HTML page" => "Non podo importar páxina HTML remota",
"The SandBox is disabled" => "A caixa de area está desactivada",
"Cannot edit page because it is locked" => "Non se pode editar a páxina porque está bloqueada",
"No questions group indicated" => "Non se indicou grupo de preguntas",
"Permission denied you cannot edit this file" => "Permiso denegado: non pode editar este ficheiro",
"Permission denied you cannot remove files from this gallery" => "Permiso denegado: non pode eliminar ficheiros desta galería",
"Top visited file galleries" => "Galerías máis visitadas",
"Most downloaded files" => "Ficheiros máis descargados",
"Last files" => "Últimos ficheiros",
"Tiki RSS feed for file galleries" => "Fonte RSS Tiki para galerías de ficheiros",
"Last files uploaded to the file galleries." => "Últimos ficheiros cargados nas galerías de ficheiros.",
"No galleryId specified" => "Non se especificou ID de galería",
"Tiki RSS feed for the file gallery: " => "fonte RSS Tiki para a galería de ficheiros: ",
"No forum indicated" => "Non se indicou foro",
"Forum posts" => "Artigos de foros",
"No forumId specified" => "Non se especificou Id de foro",
"Tiki RSS feed for forum: " => "Fonte RSS Tiki para foro:",
"Tiki RSS feed for forums" => "Fonte RSS Tiki para foros",
"Last topics in forums." => "Últimos temas nos foros.",
"Accepted friendship request from %s" => "Aceptada a solicitude de amizade de %s",
"Refused friendship request from %s" => "Rexeitada a solicitude de amizade de %s",
"Broke friendship with %s" => "Romper amizade con %s",
"I have broken our friendship!" => "Rompín a nosa amizade!",
"You must be logged in to use this feature" => "Debe iniciar sesión para usar esta función",
"Friendship request sent to %s" => "Solicitude de amizade enviada a %s",
"You're already friend of %s" => "Xa era amigo de %s",
"I have accepted your friendship request!" => "Aceptei a súa solicitude de amizade!",
"No process indicated" => "Non se indicou proceso",
"Activity name already exists" => "Xa existe ese nome de actividade",
"indicates if the process is active. Invalid processes cant be active" => "indica se o proceso está activo. Os procesos inválidos non poden estar activos",
"No instance indicated" => "Non se indicaron exemplares",
"No activity indicated" => "Non se indicou actividade",
"The process name already exists" => "O nome do proceso xa existe",
"Process already exists" => "O proceso xa existe",
"You cant execute this activity" => "Non pode executar esta actividade",
"You couldn't abort a instance" => "Non pode abortar un exemplar",
"You couldn't exception a instance" => "Non pode facer unha excepción nun exemplar",
"No user indicated" => "Non se indica usuario",
"No title indicated" => "Non se indicou título",
"No comment indicated" => "Non se indicou comentario",
"No date indicated" => "Non se indicou data",
"No item indicated" => "Non se indicou ítem",
"first uploaded image" => "primeira imaxe cargada",
"last uploaded image" => "última imaxe cargada",
"first image" => "primeira imaxe",
"last image" => "última imaxe",
"random image" => "imaxe aleatoria",
"Permission denied you cannot create galleries and so you cant edit them" => "Permiso denegado, non pode crear galerías nin editalas",
"Permission denied you cannot edit this gallery" => "Non ten permiso para editar esta galería",
"Permission denied you cannot remove this gallery" => "Non pode quitar esta galería",
"Permission denied you cannot make the map of this gallery" => "Permiso denegado, non pode facer o mapa para esta galería",
"Top images" => "Principais imaxes",
"Last images" => "Últimas imaxes",
"Tiki RSS feed for image galleries" => "fonte RSS Tiki para galerías de imaxes",
"Last images uploaded to the image galleries." => "Últimas imaxes cargadas ás galerías de imaxes.",
"Tiki RSS feed for the image gallery: " => "Fonte RSS Tiki para a galería de imaxes:",
"overwriting old page" => "sobrescribindo páxina antiga",
"updated from structured text import" => "actualizado desde importación de texto estruturado",
"page created" => "páxina creada",
"created from structured text import" => "creado desde importación de texto estruturado",
"No name indicated for wiki page" => "Non se indicou nome para a páxina wiki",
"No repository given" => "Non se deu almacén",
"Permission denied you cannot view pages like this page" => "Non ten permiso para visualizar páxinas semellantes a esta",
"Permission denied you cannot remove articles" => "Non ten permiso para eliminar artigos",
"Permission denied you cannot remove banners" => "Permiso denegado: non pode eliminar pancartas",
"Permission denied you cannot remove this blog" => "Permiso denegado: non pode quitar este blog",
"Non-existent gallery" => "Galería inexistente",
"Permission denied you can upload files but not to this file gallery" => "Permiso denegado: pode cargar ficheiros, pero non nesta galería",
"Could not upload the file" => "Non podo cargar o ficheiro",
"Could not find the file requested" => "Non podo atopar o ficheiro solicitado",
"File update was successful" => "O ficheiro actualizouse con éxito",
"Permission denied you can't upload files so you can't edit them" => "Permiso denegado: non pode cargar ficheiros, así que non os pode editar",
"The game file must have .swf or .dcr extension" => "O xogo debe ter unha extensión .swf ou .dcr",
"The thumbnail name must be" => "A nome da miniatura debe ser",
"Please supply both files" => "Por favor, forneza ambos os ficheiros",
"You cannot admin blogs" => "Non ten permiso para administrar blogs",
"Permission denied you cannot remove submissions" => "Non ten permiso para eliminar colaboracións",
"Permission denied you cannot approve submissions" => "Non ten permiso para aprobar colaboracións",
"You have to enable cookies to be able to login to this site" => "Ten que activar cuquis para poder iniciar a sesión neste sitio",
"Tiki mail-in auto-reply" => "Resposta automática da entrada de correo Tiki",
"Sorry, you can't use this feature." => "Síntoo, non pode usar esta característica.",
"edit" => "editar",
"You do not have permissions to view the maps" => "Non ten permiso para visualizar os mapas",
"Maps feature is not correctly setup : Maps path is missing." => "A función de Mapas non está correctamente configurada: falta a ruta para os mapas.",
"mapfile name incorrect" => "Nome de ficheiro de mapa incorrecto",
"This mapfile already exists" => "Este mapa xa existe",
"You do not have permission to write to the mapfile" => "Non ten permiso para escribir no ficheiro de mapa",
"You do not have permission to delete the mapfile" => "Non ten permiso para borrar o ficheiro de mapa",
"I could not make a copy" => "Non podo facer unha copia",
"You do not have permission to read the mapfile" => "Non ten permiso para ler o ficheiro de mapa",
"You dont have permission to do that" => "Non ten permiso para facer iso",
"Tiki RSS feed for maps" => "fonte RSS Tiki para mapas",
"List of maps available." => "Lista de mapas dispoñibles.",
"You do not have permissions to view the layers" => "Non tien permisos para visualizar as capas",
"You do not have permissions to delete a file" => "Non ten permisos para borrar un ficheiro",
"File not found" => "Ficheiro non atopado",
"You do not have permissions to create a directory" => "Non ten permiso para crear un directorio",
"The Directory is not empty" => "O directorio non está baleiro",
"You do not have permissions to delete a directory" => "Non ten permisos para borrar un directorio",
"You do not have permissions to create an index file" => "Non ten permisos para crear ficheiros de índice",
"Invalid file name" => "Nome de ficheiro incorrecto",
"Invalid files to index" => "Ficheiros incorrectos para indexar",
"I do not know where is gdaltindex. Set correctly the Map feature" => "Non sei onde está gdaltindex. Configure correctamente a función de Mapas",
"I could not create the index file" => "Non podo crear o ficheiro de índice",
"Must be logged to use this feature" => "Debe iniciar a sesión para usar esa característica",
"Welcome at Hawiki" => "Benvido a Hawiki",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "Este sitio Tikiwiki está preparado para o acceso desde unha gran variedade de dispositivos móbiles, por ex. teléfonos WAP, PDAs, dispositivos i-mode, etc.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "Pode navegar neste sitio co seu dispositivo móbil dirixindo o seu navegador cara ao seguinte URL neste sitio:",
"About" => "Acerca de",
"You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "Debe executar setup.sh :<br />./setup.sh \$APACHEUSER all<br />Usuarios comúns de Apache son www-data, apache ou nobody",
"Your PHP installation does not have zlib enabled." => "A súa instalación de PHP non ten zlib habilitado.",
"You must log in to use this feature" => "Debe iniciar a sesión para usar esta característica",
"You do not have permission to view other users data" => "Non ten permiso para visualizar os datos doutros usuarios",
"You must be logged in to subscribe to newsletters" => "Debe iniciar a sesión para poder subscribirse a boletíns",
"No server indicated" => "Non se indicou servidor",
"Cannot connect to" => "Non podo conectarme a",
"Missing information to read news (server,port,username,password,group) required" => "Falta a información requirida para ler grupos de novas (servidor, porto, usuario, contrasinal, grupo) ",
"Cannot get messages" => "Non podo obter as mensaxes",
"No note indicated" => "Non se indicou nota",
"merged note:" => "nota combinada:",
"File is too big" => "Ficheiro demasiado grande",
"created from notepad" => "creado desde o caderno de notas",
"Page already exists" => "A páxina xa existe",
"Not enough information to display this page" => "Non hai información abonda para mostrar esta páxina",
"Permission denied you cannot browse this page history" => "Non ten permiso para navegar polo historial da páxina",
"No article indicated" => "Non se indica un artigo",
"Article is not published yet" => "O artigo aínda non foi publicado",
"No post indicated" => "Non indica o artigo",
"Blog not found" => "No se atopa o blog",
"No pages indicated" => "Non se indican as páxinas",
"Pageviews" => "Accesos",
"You don't have permission to edit quizzes." => "Non ten permiso para editar cuestionarios.",
"No result indicated" => "Non se indica resultado",
"The passwords don't match" => "Os contrasinais non coinciden",
"empty" => "baleiro",
"Invalid or unknown username" => "Nome de usuario inválido ou descoñecido",
"Unable to send mail. User has not configured email" => "Non se pode enviar correo. O usuario non configurou o seu correo electrónico",
"A password and your IP address reminder email has been sent " => "Envióuselle un correo recordatorio do seu contrasinal e enderezo IP",
"to the registered email address for" => "ao enderezo rexistrada de correo para",
"last version" => "última versión",
"Permission denied you cannot remove versions from this page" => "Non pode eliminar versións desta páxina",
"Permission denied you cannot rename this page" => "Permiso denegado: non pode renomear esta páxina",
"Cannot rename page because the new name begins with reserved prefix" => "Non pode renomear a páxina porque o novo nome comeza cun prefixo reservado",
"Cannot rename page maybe new page already exists" => "Non podo renomear a páxina, talvez a nova páxina xa existe",
"changed '%s' from '%s' to '%s'" => "cambiado '%s' de '%s' a '%s'",
"Non-existent version" => "Versión inexistente",
"Permission denied you cannot rollback this page" => "Non ten permiso para restablecer unha versión anterior da páxina",
"Error Message" => "Mensaxe de erro",
"Tiki RSS Feed Error Message: \$errmsg" => "Fonte RSS Tiki: Mensaxe de Erro: \$errmsg",
"Post recommendation at" => "Enviar recomendación en",
"No newsletters available." => "Non hai boletíns dispoñibles.",
"successfully sent" => "enviada con éxito",
"not sent" => "non enviada",
"Error: " => "Erro: ",
"Page must be defined inside a structure to use this feature" => "A páxina debe estar definida dentro dunha estrutura para usar esa función",
"You cannot take this quiz twice" => "Non pode facer o cuestionario dúas veces",
"Quiz time limit exceeded quiz cannot be computed" => "Superouse o tempo límite",
"You cannot take this survey twice" => "Non responder a enquisa dúas veces",
"Please create a category first" => "Por favor, primeiro cree unha categoría",
"Tracker item:" => "Ítem de tracker:",
"No trackerId specified" => "Non se especificou o ID de tracker",
"No permission to upload zipped file packages" => "Non ten permiso para cargar paquetes de ficheiros comprimidos zip",
"Error processing zipped image package" => "Erro ao procesar paquete de imaxes comprimido zip",
"No permission to upload zipped image packages" => "Sen permiso para cargar paquete de imaxes comprimido zip",
"The uploaded file ist not recognized as a image" => "O ficheiro cargado non é recoñecido como unha imaxe",
"Permission denied you cannot upload images" => "Non ten permiso para cargar imaxes",
"Permission denied you can upload images but not to this gallery" => "Ten permisos para cargar imaxes, pero non a esta galería",
"Cannot get image from URL" => "Non se puido ler imaxe a partir do URL",
"That is not an image (or you have php < 4.0.5)" => "Esta non é unha imaxe (ou ten php < 4.0.5)",
"Usage" => "Uso",
"No url indicated" => "Non se indica url",
"Unknown user" => "Usuario descoñecido",
"You are not logged in and no user indicated" => "Non iniciou a sesión e non hai usuario indicado",
"The user has chosen to make his information private" => "O usuario elixiu facer a súa información privada",
"Email is set to %s" => "Correo está configurado a %s",
"The passwords did not match" => "Os contrasinais non coinciden",
"no" => "non",
"was moved into trash" => "foi movido á papeleira",
"trashed by" => "borrado por",
"open / in process" => "aberta / en proceso",
"Rights by creator" => "Dereitos do autor",
"END" => "FIN",
"Percentage" => "Porcentaxe",
"Task accepted by creator" => "Tarefa aceptada polo creador ",
"Task accepted by task user" => "Tarefa aceptada polo usuario de tarefa",
"Task NOT accepted by creator" => "Tarefa NON aceptada polo creador",
"Task NOT accepted by task user" => "Tarefa NON aceptada polo usuario da tarefa",
"Sorry this task does not exist or you have no rights to view this task" => "Síntoo, esta tarefa non existe ou vostede non ten dereito a vela",
"Task entries:" => "Entradas da tarefa:",
"Changes:" => "Cambios:",
"Info message" => "Mensaxe de información",
"NEW Task" => "NOVA tarefa",
"Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Síntoo, vostede non ten permitido enviar tarefas a outros usuarios, ou o usuario non ten permitido recibilas!",
"Changes on Task" => "Cambios na tarefa",
"You received a new task" => "Vostede recibiu unha nova tarefa",
"The priority is" => "A prioridade é",
"very low" => "moi baixa",
"low" => "baixa",
"high" => "alta",
"very high" => "moi alta",
"You've to start your work at least on" => "Vostede debe empezar o seu traballo ao menos en",
"You've to finish your work on" => "Debe terminar o seu traballo en",
"Login and click the link below" => "Inicie sesión e prema a ligazón seguinte",
"Please read the task and work on it!" => "Por favor, lea a tarefa e traballe nela!",
"Sorry, there was an error while trying to write data into the database" => "Síntoo, houbo un erro intentando escribir datos na base de datos",
"Cannot upload this file not enough quota" => "Non pode cargar este ficheiro, cota insuficiente",
"Non-existent user" => "Usuario inexistente",
"No banner indicated" => "Non se indica unha pancarta",
"No blog indicated" => "Non se indica un blog",
"Permission denied you cannot remove the post" => "Non ten permiso para eliminar este artigo",
"No cache information available" => "Non hai información dispoñible na caché ",
"No faq indicated" => "Non se indica pmf",
"You are not permitted to remove someone else\\'s post!" => "Non ten permitido borrar o artigo de outro!",
"No thread indicated" => "Non se indica un fío",
"A SheetId is required." => "Requírese un Id de folla de cálculo.",
"That tracker don't use extras." => "Este tracker non usa extras.",
"No subject" => "Sen tema",
"Top pages" => "Páxinas principais",
"Last pages" => "Últimas páxinas",
"Tiki RSS feed for the wiki pages" => "Fonte RSS Tiki para as páxinas wiki",
"Last modifications to the Wiki." => "Últimas modificacións para o Wiki.",
"###end###"=>"###end###");
?>
