/***************************************************************************
 *   copyright       : (C) 2003-2023 by Pascal Brachet                     *
 *   https://www.xm1math.net/texmaker/                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   @license GPL-2.0+ <https://spdx.org/licenses/GPL-2.0+.html>           *
 ***************************************************************************/


#include <QtGui>
#include <QRegularExpression>

#include "loghighlighter.h"

LogHighlighter::LogHighlighter(QTextDocument *parent, QColor standard)
    : QSyntaxHighlighter(parent)
{
	ColorStandard = standard;
	ColorFile = QColor("#1cbf73");
	ColorError=QColor("#bc392b");
	ColorWarning=QColor("#2765c0");
}

void LogHighlighter::setColors(QList<QColor> colors)
{
ColorStandard=colors.at(3);
rehighlight();
}

void LogHighlighter::highlightBlock(const QString &text)
{
QRegularExpression rxLatexError("! (.*)");
QRegularExpression rxBadBox("(Over|Under)(full \\\\[hv]box .*)");
QRegularExpression rxWarning("(((! )?(La|pdf)TeX)|Package) .*Warning.*:(.*)");

QTextCharFormat errorFormat;
errorFormat.setFontWeight(QFont::Bold);
errorFormat.setForeground(ColorError);

QTextCharFormat warningFormat;
warningFormat.setFontWeight(QFont::Bold);
warningFormat.setForeground(ColorWarning);

QTextCharFormat fileFormat;
fileFormat.setFontWeight(QFont::Bold);
fileFormat.setForeground(ColorFile);

if (rxLatexError.match(text).hasMatch())
	{
	setFormat(0, text.length(),errorFormat);
	}
else if ((rxBadBox.match(text).hasMatch()) || (rxWarning.match(text).hasMatch()))
	{
	setFormat(0, text.length(),warningFormat);
	}
else if (text.indexOf(".tex",0)!=-1) 
	{
	setFormat(0, text.length(),fileFormat);
	}
else setFormat(0, text.length(),ColorStandard);
}
