// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: types.proto

package services

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "github.com/golang/protobuf/ptypes/timestamp"
import _ "github.com/gravitational/teleport/lib/wrappers"

import time "time"
import github_com_gravitational_teleport "github.com/gravitational/teleport"
import github_com_gravitational_teleport_lib_wrappers "github.com/gravitational/teleport/lib/wrappers"

import github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type KeepAlive struct {
	// ServerName is a server name to keep alive
	ServerName string `protobuf:"bytes,1,opt,name=ServerName,proto3" json:"server_name"`
	// Namespace is a server namespace
	Namespace string `protobuf:"bytes,2,opt,name=Namespace,proto3" json:"namespace"`
	// LeaseID is ID of the lease
	LeaseID int64 `protobuf:"varint,3,opt,name=LeaseID,proto3" json:"lease_id"`
	// Expires is set to update expiry time
	Expires              time.Time `protobuf:"bytes,4,opt,name=Expires,stdtime" json:"expires"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *KeepAlive) Reset()         { *m = KeepAlive{} }
func (m *KeepAlive) String() string { return proto.CompactTextString(m) }
func (*KeepAlive) ProtoMessage()    {}
func (*KeepAlive) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{0}
}
func (m *KeepAlive) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KeepAlive) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KeepAlive.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *KeepAlive) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeepAlive.Merge(dst, src)
}
func (m *KeepAlive) XXX_Size() int {
	return m.Size()
}
func (m *KeepAlive) XXX_DiscardUnknown() {
	xxx_messageInfo_KeepAlive.DiscardUnknown(m)
}

var xxx_messageInfo_KeepAlive proto.InternalMessageInfo

// Metadata is resource metadata
type Metadata struct {
	// Name is an object name
	Name string `protobuf:"bytes,1,opt,name=Name,proto3" json:"name"`
	// Namespace is object namespace. The field should be called "namespace"
	// when it returns in Teleport 2.4.
	Namespace string `protobuf:"bytes,2,opt,name=Namespace,proto3" json:"-"`
	// Description is object description
	Description string `protobuf:"bytes,3,opt,name=Description,proto3" json:"description,omitempty"`
	// Labels is a set of labels
	Labels map[string]string `protobuf:"bytes,5,rep,name=Labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Expires is a global expiry time header can be set on any resource in the system.
	Expires *time.Time `protobuf:"bytes,6,opt,name=Expires,stdtime" json:"expires,omitempty"`
	// ID is a record ID
	ID                   int64    `protobuf:"varint,7,opt,name=ID,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metadata) Reset()         { *m = Metadata{} }
func (m *Metadata) String() string { return proto.CompactTextString(m) }
func (*Metadata) ProtoMessage()    {}
func (*Metadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{1}
}
func (m *Metadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Metadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Metadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Metadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metadata.Merge(dst, src)
}
func (m *Metadata) XXX_Size() int {
	return m.Size()
}
func (m *Metadata) XXX_DiscardUnknown() {
	xxx_messageInfo_Metadata.DiscardUnknown(m)
}

var xxx_messageInfo_Metadata proto.InternalMessageInfo

// Rotation is a status of the rotation of the certificate authority
type Rotation struct {
	// State could be one of "init" or "in_progress".
	State string `protobuf:"bytes,1,opt,name=State,proto3" json:"state,omitempty"`
	// Phase is the current rotation phase.
	Phase string `protobuf:"bytes,2,opt,name=Phase,proto3" json:"phase,omitempty"`
	// Mode sets manual or automatic rotation mode.
	Mode string `protobuf:"bytes,3,opt,name=Mode,proto3" json:"mode,omitempty"`
	// CurrentID is the ID of the rotation operation
	// to differentiate between rotation attempts.
	CurrentID string `protobuf:"bytes,4,opt,name=CurrentID,proto3" json:"current_id"`
	// Started is set to the time when rotation has been started
	// in case if the state of the rotation is "in_progress".
	Started time.Time `protobuf:"bytes,5,opt,name=Started,stdtime" json:"started,omitempty"`
	// GracePeriod is a period during which old and new CA
	// are valid for checking purposes, but only new CA is issuing certificates.
	GracePeriod Duration `protobuf:"varint,6,opt,name=GracePeriod,proto3,casttype=Duration" json:"grace_period,omitempty"`
	// LastRotated specifies the last time of the completed rotation.
	LastRotated time.Time `protobuf:"bytes,7,opt,name=LastRotated,stdtime" json:"last_rotated,omitempty"`
	// Schedule is a rotation schedule - used in
	// automatic mode to switch beetween phases.
	Schedule             RotationSchedule `protobuf:"bytes,8,opt,name=Schedule" json:"schedule,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Rotation) Reset()      { *m = Rotation{} }
func (*Rotation) ProtoMessage() {}
func (*Rotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{2}
}
func (m *Rotation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Rotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Rotation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Rotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Rotation.Merge(dst, src)
}
func (m *Rotation) XXX_Size() int {
	return m.Size()
}
func (m *Rotation) XXX_DiscardUnknown() {
	xxx_messageInfo_Rotation.DiscardUnknown(m)
}

var xxx_messageInfo_Rotation proto.InternalMessageInfo

// RotationSchedule is a rotation schedule setting time switches
// for different phases.
type RotationSchedule struct {
	// UpdateClients specifies time to switch to the "Update clients" phase
	UpdateClients time.Time `protobuf:"bytes,1,opt,name=UpdateClients,stdtime" json:"update_clients,omitempty"`
	// UpdateServers specifies time to switch to the "Update servers" phase.
	UpdateServers time.Time `protobuf:"bytes,2,opt,name=UpdateServers,stdtime" json:"update_servers,omitempty"`
	// Standby specifies time to switch to the "Standby" phase.
	Standby              time.Time `protobuf:"bytes,3,opt,name=Standby,stdtime" json:"standby,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *RotationSchedule) Reset()         { *m = RotationSchedule{} }
func (m *RotationSchedule) String() string { return proto.CompactTextString(m) }
func (*RotationSchedule) ProtoMessage()    {}
func (*RotationSchedule) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{3}
}
func (m *RotationSchedule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RotationSchedule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RotationSchedule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RotationSchedule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RotationSchedule.Merge(dst, src)
}
func (m *RotationSchedule) XXX_Size() int {
	return m.Size()
}
func (m *RotationSchedule) XXX_DiscardUnknown() {
	xxx_messageInfo_RotationSchedule.DiscardUnknown(m)
}

var xxx_messageInfo_RotationSchedule proto.InternalMessageInfo

// ResorceHeader is a shared resource header
// used in cases when only type and name is known
type ResourceHeader struct {
	// Kind is a resource kind
	Kind string `protobuf:"bytes,1,opt,name=Kind,proto3" json:"kind,omitempty"`
	// SubKind is an optional resource sub kind, used in some resources
	SubKind string `protobuf:"bytes,2,opt,name=SubKind,proto3" json:"sub_kind,omitempty"`
	// Version is version
	Version string `protobuf:"bytes,3,opt,name=Version,proto3" json:"version,omitempty"`
	// Metadata is User metadata
	Metadata             Metadata `protobuf:"bytes,4,opt,name=Metadata" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResourceHeader) Reset()         { *m = ResourceHeader{} }
func (m *ResourceHeader) String() string { return proto.CompactTextString(m) }
func (*ResourceHeader) ProtoMessage()    {}
func (*ResourceHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{4}
}
func (m *ResourceHeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceHeader.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ResourceHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceHeader.Merge(dst, src)
}
func (m *ResourceHeader) XXX_Size() int {
	return m.Size()
}
func (m *ResourceHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceHeader.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceHeader proto.InternalMessageInfo

// ServerV2 represents a Node, Proxy or Auth server in a Teleport cluster
type ServerV2 struct {
	// Kind is a resource kind
	Kind string `protobuf:"bytes,1,opt,name=Kind,proto3" json:"kind"`
	// SubKind is an optional resource sub kind, used in some resources
	SubKind string `protobuf:"bytes,2,opt,name=SubKind,proto3" json:"sub_kind,omitempty"`
	// Version is version
	Version string `protobuf:"bytes,3,opt,name=Version,proto3" json:"version"`
	// Metadata is User metadata
	Metadata Metadata `protobuf:"bytes,4,opt,name=Metadata" json:"metadata"`
	// Spec is a server spec
	Spec                 ServerSpecV2 `protobuf:"bytes,5,opt,name=Spec" json:"spec"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ServerV2) Reset()      { *m = ServerV2{} }
func (*ServerV2) ProtoMessage() {}
func (*ServerV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{5}
}
func (m *ServerV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServerV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServerV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ServerV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerV2.Merge(dst, src)
}
func (m *ServerV2) XXX_Size() int {
	return m.Size()
}
func (m *ServerV2) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerV2.DiscardUnknown(m)
}

var xxx_messageInfo_ServerV2 proto.InternalMessageInfo

// ServerSpecV2 is a specification for V2 Server
type ServerSpecV2 struct {
	// Addr is server host:port address
	Addr string `protobuf:"bytes,1,opt,name=Addr,proto3" json:"addr"`
	// PublicAddr is the public address this cluster can be reached at.
	PublicAddr string `protobuf:"bytes,2,opt,name=PublicAddr,proto3" json:"public_addr,omitempty"`
	// Hostname is server hostname
	Hostname string `protobuf:"bytes,3,opt,name=Hostname,proto3" json:"hostname"`
	// CmdLabels is server dynamic labels
	CmdLabels map[string]CommandLabelV2 `protobuf:"bytes,4,rep,name=CmdLabels" json:"cmd_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// Rotation specifies server rotation
	Rotation Rotation `protobuf:"bytes,5,opt,name=Rotation" json:"rotation,omitempty"`
	// UseTunnel indicates that connections to this server should occur over a
	// reverse tunnel.
	UseTunnel            bool     `protobuf:"varint,6,opt,name=UseTunnel,proto3" json:"use_tunnel,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServerSpecV2) Reset()         { *m = ServerSpecV2{} }
func (m *ServerSpecV2) String() string { return proto.CompactTextString(m) }
func (*ServerSpecV2) ProtoMessage()    {}
func (*ServerSpecV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{6}
}
func (m *ServerSpecV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServerSpecV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServerSpecV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ServerSpecV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerSpecV2.Merge(dst, src)
}
func (m *ServerSpecV2) XXX_Size() int {
	return m.Size()
}
func (m *ServerSpecV2) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerSpecV2.DiscardUnknown(m)
}

var xxx_messageInfo_ServerSpecV2 proto.InternalMessageInfo

// CommandLabelV2 is a label that has a value as a result of the
// output generated by running command, e.g. hostname
type CommandLabelV2 struct {
	// Period is a time between command runs
	Period Duration `protobuf:"varint,1,opt,name=Period,proto3,casttype=Duration" json:"period"`
	// Command is a command to run
	Command []string `protobuf:"bytes,2,rep,name=Command" json:"command"`
	// Result captures standard output
	Result               string   `protobuf:"bytes,3,opt,name=Result,proto3" json:"result"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommandLabelV2) Reset()         { *m = CommandLabelV2{} }
func (m *CommandLabelV2) String() string { return proto.CompactTextString(m) }
func (*CommandLabelV2) ProtoMessage()    {}
func (*CommandLabelV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{7}
}
func (m *CommandLabelV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommandLabelV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommandLabelV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *CommandLabelV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommandLabelV2.Merge(dst, src)
}
func (m *CommandLabelV2) XXX_Size() int {
	return m.Size()
}
func (m *CommandLabelV2) XXX_DiscardUnknown() {
	xxx_messageInfo_CommandLabelV2.DiscardUnknown(m)
}

var xxx_messageInfo_CommandLabelV2 proto.InternalMessageInfo

// TLSKeyPair is a TLS key pair
type TLSKeyPair struct {
	// Cert is a PEM encoded TLS cert
	Cert []byte `protobuf:"bytes,1,opt,name=Cert,proto3" json:"cert,omitempty"`
	// Key is a PEM encoded TLS key
	Key                  []byte   `protobuf:"bytes,2,opt,name=Key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TLSKeyPair) Reset()         { *m = TLSKeyPair{} }
func (m *TLSKeyPair) String() string { return proto.CompactTextString(m) }
func (*TLSKeyPair) ProtoMessage()    {}
func (*TLSKeyPair) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{8}
}
func (m *TLSKeyPair) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TLSKeyPair) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TLSKeyPair.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *TLSKeyPair) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TLSKeyPair.Merge(dst, src)
}
func (m *TLSKeyPair) XXX_Size() int {
	return m.Size()
}
func (m *TLSKeyPair) XXX_DiscardUnknown() {
	xxx_messageInfo_TLSKeyPair.DiscardUnknown(m)
}

var xxx_messageInfo_TLSKeyPair proto.InternalMessageInfo

// CertAuthorityV2 is version 2 resource spec for Cert Authority
type CertAuthorityV2 struct {
	// Kind is a resource kind
	Kind string `protobuf:"bytes,1,opt,name=Kind,proto3" json:"kind"`
	// SubKind is an optional resource sub kind, used in some resources
	SubKind string `protobuf:"bytes,2,opt,name=SubKind,proto3" json:"sub_kind,omitempty"`
	// Version is version
	Version string `protobuf:"bytes,3,opt,name=Version,proto3" json:"version"`
	// Metadata is connector metadata
	Metadata Metadata `protobuf:"bytes,4,opt,name=Metadata" json:"metadata"`
	// Spec contains cert authority specification
	Spec                 CertAuthoritySpecV2 `protobuf:"bytes,5,opt,name=Spec" json:"spec"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *CertAuthorityV2) Reset()      { *m = CertAuthorityV2{} }
func (*CertAuthorityV2) ProtoMessage() {}
func (*CertAuthorityV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{9}
}
func (m *CertAuthorityV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CertAuthorityV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CertAuthorityV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *CertAuthorityV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CertAuthorityV2.Merge(dst, src)
}
func (m *CertAuthorityV2) XXX_Size() int {
	return m.Size()
}
func (m *CertAuthorityV2) XXX_DiscardUnknown() {
	xxx_messageInfo_CertAuthorityV2.DiscardUnknown(m)
}

var xxx_messageInfo_CertAuthorityV2 proto.InternalMessageInfo

// CertAuthoritySpecV2 is a host or user certificate authority that
// can check and if it has private key stored as well, sign it too
type CertAuthoritySpecV2 struct {
	// Type is either user or host certificate authority
	Type CertAuthType `protobuf:"bytes,1,opt,name=Type,proto3,casttype=CertAuthType" json:"type"`
	// DELETE IN(2.7.0) this field is deprecated,
	// as resource name matches cluster name after migrations.
	// and this property is enforced by the auth server code.
	// ClusterName identifies cluster name this authority serves,
	// for host authorities that means base hostname of all servers,
	// for user authorities that means organization name
	ClusterName string `protobuf:"bytes,2,opt,name=ClusterName,proto3" json:"cluster_name"`
	// Checkers is a list of SSH public keys that can be used to check
	// certificate signatures
	CheckingKeys [][]byte `protobuf:"bytes,3,rep,name=CheckingKeys" json:"checking_keys"`
	// SigningKeys is a list of private keys used for signing
	SigningKeys [][]byte `protobuf:"bytes,4,rep,name=SigningKeys" json:"signing_keys,omitempty"`
	// Roles is a list of roles assumed by users signed by this CA
	Roles []string `protobuf:"bytes,5,rep,name=Roles" json:"roles,omitempty"`
	// RoleMap specifies role mappings to remote roles
	RoleMap []RoleMapping `protobuf:"bytes,6,rep,name=RoleMap" json:"role_map,omitempty"`
	// TLS is a list of TLS key pairs
	TLSKeyPairs []TLSKeyPair `protobuf:"bytes,7,rep,name=TLSKeyPairs" json:"tls_key_pairs,omitempty"`
	// Rotation is a status of the certificate authority rotation
	Rotation             *Rotation `protobuf:"bytes,8,opt,name=Rotation" json:"rotation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CertAuthoritySpecV2) Reset()         { *m = CertAuthoritySpecV2{} }
func (m *CertAuthoritySpecV2) String() string { return proto.CompactTextString(m) }
func (*CertAuthoritySpecV2) ProtoMessage()    {}
func (*CertAuthoritySpecV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{10}
}
func (m *CertAuthoritySpecV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CertAuthoritySpecV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CertAuthoritySpecV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *CertAuthoritySpecV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CertAuthoritySpecV2.Merge(dst, src)
}
func (m *CertAuthoritySpecV2) XXX_Size() int {
	return m.Size()
}
func (m *CertAuthoritySpecV2) XXX_DiscardUnknown() {
	xxx_messageInfo_CertAuthoritySpecV2.DiscardUnknown(m)
}

var xxx_messageInfo_CertAuthoritySpecV2 proto.InternalMessageInfo

// RoleMappping provides mapping of remote roles to local roles
// for trusted clusters
type RoleMapping struct {
	// Remote specifies remote role name to map from
	Remote string `protobuf:"bytes,1,opt,name=Remote,proto3" json:"remote"`
	// Local specifies local roles to map to
	Local                []string `protobuf:"bytes,2,rep,name=Local" json:"local"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RoleMapping) Reset()         { *m = RoleMapping{} }
func (m *RoleMapping) String() string { return proto.CompactTextString(m) }
func (*RoleMapping) ProtoMessage()    {}
func (*RoleMapping) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{11}
}
func (m *RoleMapping) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RoleMapping) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RoleMapping.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RoleMapping) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleMapping.Merge(dst, src)
}
func (m *RoleMapping) XXX_Size() int {
	return m.Size()
}
func (m *RoleMapping) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleMapping.DiscardUnknown(m)
}

var xxx_messageInfo_RoleMapping proto.InternalMessageInfo

// ProvisionTokenV1 is a provisioning token V1
type ProvisionTokenV1 struct {
	// Roles is a list of roles associated with the token,
	// that will be converted to metadata in the SSH and X509
	// certificates issued to the user of the token
	Roles []github_com_gravitational_teleport.Role `protobuf:"bytes,1,rep,name=Roles,casttype=github.com/gravitational/teleport.Role" json:"roles"`
	// Expires is a global expiry time header can be set on any resource in the system.
	Expires time.Time `protobuf:"bytes,2,opt,name=Expires,stdtime" json:"expires,omitempty"`
	// Token is a token name
	Token                string   `protobuf:"bytes,3,opt,name=Token,proto3" json:"token"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProvisionTokenV1) Reset()      { *m = ProvisionTokenV1{} }
func (*ProvisionTokenV1) ProtoMessage() {}
func (*ProvisionTokenV1) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{12}
}
func (m *ProvisionTokenV1) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProvisionTokenV1) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProvisionTokenV1.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ProvisionTokenV1) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProvisionTokenV1.Merge(dst, src)
}
func (m *ProvisionTokenV1) XXX_Size() int {
	return m.Size()
}
func (m *ProvisionTokenV1) XXX_DiscardUnknown() {
	xxx_messageInfo_ProvisionTokenV1.DiscardUnknown(m)
}

var xxx_messageInfo_ProvisionTokenV1 proto.InternalMessageInfo

// ProvisionTokenV2 specifies provisioning token
type ProvisionTokenV2 struct {
	// Kind is a resource kind
	Kind string `protobuf:"bytes,1,opt,name=Kind,proto3" json:"kind"`
	// SubKind is an optional resource sub kind, used in some resources
	SubKind string `protobuf:"bytes,2,opt,name=SubKind,proto3" json:"sub_kind,omitempty"`
	// Version is version
	Version string `protobuf:"bytes,3,opt,name=Version,proto3" json:"version"`
	// Metadata is User metadata
	Metadata Metadata `protobuf:"bytes,4,opt,name=Metadata" json:"metadata"`
	// Spec is a provisioning token V2 spec
	Spec                 ProvisionTokenSpecV2 `protobuf:"bytes,5,opt,name=Spec" json:"spec"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ProvisionTokenV2) Reset()      { *m = ProvisionTokenV2{} }
func (*ProvisionTokenV2) ProtoMessage() {}
func (*ProvisionTokenV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{13}
}
func (m *ProvisionTokenV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProvisionTokenV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProvisionTokenV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ProvisionTokenV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProvisionTokenV2.Merge(dst, src)
}
func (m *ProvisionTokenV2) XXX_Size() int {
	return m.Size()
}
func (m *ProvisionTokenV2) XXX_DiscardUnknown() {
	xxx_messageInfo_ProvisionTokenV2.DiscardUnknown(m)
}

var xxx_messageInfo_ProvisionTokenV2 proto.InternalMessageInfo

// ProvisionTokenSpecV2 is a specification for V2 token
type ProvisionTokenSpecV2 struct {
	// Roles is a list of roles associated with the token,
	// that will be converted to metadata in the SSH and X509
	// certificates issued to the user of the token
	Roles                []github_com_gravitational_teleport.Role `protobuf:"bytes,1,rep,name=Roles,casttype=github.com/gravitational/teleport.Role" json:"roles"`
	XXX_NoUnkeyedLiteral struct{}                                 `json:"-"`
	XXX_unrecognized     []byte                                   `json:"-"`
	XXX_sizecache        int32                                    `json:"-"`
}

func (m *ProvisionTokenSpecV2) Reset()         { *m = ProvisionTokenSpecV2{} }
func (m *ProvisionTokenSpecV2) String() string { return proto.CompactTextString(m) }
func (*ProvisionTokenSpecV2) ProtoMessage()    {}
func (*ProvisionTokenSpecV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{14}
}
func (m *ProvisionTokenSpecV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProvisionTokenSpecV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProvisionTokenSpecV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ProvisionTokenSpecV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProvisionTokenSpecV2.Merge(dst, src)
}
func (m *ProvisionTokenSpecV2) XXX_Size() int {
	return m.Size()
}
func (m *ProvisionTokenSpecV2) XXX_DiscardUnknown() {
	xxx_messageInfo_ProvisionTokenSpecV2.DiscardUnknown(m)
}

var xxx_messageInfo_ProvisionTokenSpecV2 proto.InternalMessageInfo

// StaticTokensV2 implements the StaticTokens interface.
type StaticTokensV2 struct {
	// Kind is a resource kind
	Kind string `protobuf:"bytes,1,opt,name=Kind,proto3" json:"kind"`
	// SubKind is an optional resource sub kind, used in some resources
	SubKind string `protobuf:"bytes,2,opt,name=SubKind,proto3" json:"sub_kind,omitempty"`
	// Version is version
	Version string `protobuf:"bytes,3,opt,name=Version,proto3" json:"version"`
	// Metadata is User metadata
	Metadata Metadata `protobuf:"bytes,4,opt,name=Metadata" json:"metadata"`
	// Spec is a provisioning token V2 spec
	Spec                 StaticTokensSpecV2 `protobuf:"bytes,5,opt,name=Spec" json:"spec"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StaticTokensV2) Reset()      { *m = StaticTokensV2{} }
func (*StaticTokensV2) ProtoMessage() {}
func (*StaticTokensV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{15}
}
func (m *StaticTokensV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StaticTokensV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StaticTokensV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *StaticTokensV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StaticTokensV2.Merge(dst, src)
}
func (m *StaticTokensV2) XXX_Size() int {
	return m.Size()
}
func (m *StaticTokensV2) XXX_DiscardUnknown() {
	xxx_messageInfo_StaticTokensV2.DiscardUnknown(m)
}

var xxx_messageInfo_StaticTokensV2 proto.InternalMessageInfo

// StaticTokensSpecV2 is the actual data we care about for StaticTokensSpecV2.
type StaticTokensSpecV2 struct {
	// StaticTokens is a list of tokens that can be used to add nodes to the
	// cluster.
	StaticTokens         []ProvisionTokenV1 `protobuf:"bytes,1,rep,name=StaticTokens" json:"static_tokens"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StaticTokensSpecV2) Reset()         { *m = StaticTokensSpecV2{} }
func (m *StaticTokensSpecV2) String() string { return proto.CompactTextString(m) }
func (*StaticTokensSpecV2) ProtoMessage()    {}
func (*StaticTokensSpecV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{16}
}
func (m *StaticTokensSpecV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StaticTokensSpecV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StaticTokensSpecV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *StaticTokensSpecV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StaticTokensSpecV2.Merge(dst, src)
}
func (m *StaticTokensSpecV2) XXX_Size() int {
	return m.Size()
}
func (m *StaticTokensSpecV2) XXX_DiscardUnknown() {
	xxx_messageInfo_StaticTokensSpecV2.DiscardUnknown(m)
}

var xxx_messageInfo_StaticTokensSpecV2 proto.InternalMessageInfo

// ClusterNameV2 implements the ClusterName interface.
type ClusterNameV2 struct {
	// Kind is a resource kind
	Kind string `protobuf:"bytes,1,opt,name=Kind,proto3" json:"kind"`
	// SubKind is an optional resource sub kind, used in some resources
	SubKind string `protobuf:"bytes,2,opt,name=SubKind,proto3" json:"sub_kind,omitempty"`
	// Version is version
	Version string `protobuf:"bytes,3,opt,name=Version,proto3" json:"version"`
	// Metadata is User metadata
	Metadata Metadata `protobuf:"bytes,4,opt,name=Metadata" json:"metadata"`
	// Spec is a cluster name V2 spec
	Spec                 ClusterNameSpecV2 `protobuf:"bytes,5,opt,name=Spec" json:"spec"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ClusterNameV2) Reset()      { *m = ClusterNameV2{} }
func (*ClusterNameV2) ProtoMessage() {}
func (*ClusterNameV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{17}
}
func (m *ClusterNameV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterNameV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterNameV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ClusterNameV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterNameV2.Merge(dst, src)
}
func (m *ClusterNameV2) XXX_Size() int {
	return m.Size()
}
func (m *ClusterNameV2) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterNameV2.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterNameV2 proto.InternalMessageInfo

// ClusterNameSpecV2 is the actual data we care about for ClusterName.
type ClusterNameSpecV2 struct {
	// ClusterName is the name of the cluster. Changing this value once the
	// cluster is setup can and will cause catastrophic problems.
	ClusterName          string   `protobuf:"bytes,1,opt,name=ClusterName,proto3" json:"cluster_name"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterNameSpecV2) Reset()         { *m = ClusterNameSpecV2{} }
func (m *ClusterNameSpecV2) String() string { return proto.CompactTextString(m) }
func (*ClusterNameSpecV2) ProtoMessage()    {}
func (*ClusterNameSpecV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{18}
}
func (m *ClusterNameSpecV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterNameSpecV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterNameSpecV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ClusterNameSpecV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterNameSpecV2.Merge(dst, src)
}
func (m *ClusterNameSpecV2) XXX_Size() int {
	return m.Size()
}
func (m *ClusterNameSpecV2) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterNameSpecV2.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterNameSpecV2 proto.InternalMessageInfo

// ClusterConfigV3 implements the ClusterConfig interface.
type ClusterConfigV3 struct {
	// Kind is a resource kind
	Kind string `protobuf:"bytes,1,opt,name=Kind,proto3" json:"kind"`
	// SubKind is an optional resource sub kind, used in some resources
	SubKind string `protobuf:"bytes,2,opt,name=SubKind,proto3" json:"sub_kind,omitempty"`
	// Version is version
	Version string `protobuf:"bytes,3,opt,name=Version,proto3" json:"version"`
	// Metadata is User metadata
	Metadata Metadata `protobuf:"bytes,4,opt,name=Metadata" json:"metadata"`
	// Spec is a cluster config V3 spec
	Spec                 ClusterConfigSpecV3 `protobuf:"bytes,5,opt,name=Spec" json:"spec"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ClusterConfigV3) Reset()      { *m = ClusterConfigV3{} }
func (*ClusterConfigV3) ProtoMessage() {}
func (*ClusterConfigV3) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{19}
}
func (m *ClusterConfigV3) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterConfigV3) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterConfigV3.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ClusterConfigV3) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfigV3.Merge(dst, src)
}
func (m *ClusterConfigV3) XXX_Size() int {
	return m.Size()
}
func (m *ClusterConfigV3) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfigV3.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfigV3 proto.InternalMessageInfo

// ClusterConfigSpecV3 is the actual data we care about for ClusterConfig.
type ClusterConfigSpecV3 struct {
	// SessionRecording controls where (or if) the session is recorded.
	SessionRecording string `protobuf:"bytes,1,opt,name=SessionRecording,proto3" json:"session_recording"`
	// ClusterID is the unique cluster ID that is set once during the first auth
	// server startup.
	ClusterID string `protobuf:"bytes,2,opt,name=ClusterID,proto3" json:"cluster_id"`
	// ProxyChecksHostKeys is used to control if the proxy will check host keys
	// when in recording mode.
	ProxyChecksHostKeys string `protobuf:"bytes,3,opt,name=ProxyChecksHostKeys,proto3" json:"proxy_checks_host_keys"`
	// Audit is a section with audit config
	Audit AuditConfig `protobuf:"bytes,4,opt,name=Audit" json:"audit"`
	// ClientIdleTimeout sets global cluster default setting for client idle timeouts
	ClientIdleTimeout Duration `protobuf:"varint,5,opt,name=ClientIdleTimeout,proto3,casttype=Duration" json:"client_idle_timeout"`
	// DisconnectExpiredCert provides disconnect expired certificate setting -
	// if true, connections with expired client certificates will get disconnected
	DisconnectExpiredCert Bool `protobuf:"varint,6,opt,name=DisconnectExpiredCert,proto3,casttype=Bool" json:"disconnect_expired_cert"`
	// KeepAliveInterval is the interval the server sends keep-alive messsages
	// to the client at.
	KeepAliveInterval Duration `protobuf:"varint,7,opt,name=KeepAliveInterval,proto3,casttype=Duration" json:"keep_alive_interval"`
	// KeepAliveCountMax is the number of keep-alive messages that can be missed before
	// the server disconnects the connection to the client.
	KeepAliveCountMax int64 `protobuf:"varint,8,opt,name=KeepAliveCountMax,proto3" json:"keep_alive_count_max"`
	// LocalAuth is true if local authentication is enabled.
	LocalAuth            Bool     `protobuf:"varint,9,opt,name=LocalAuth,proto3,casttype=Bool" json:"local_auth"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterConfigSpecV3) Reset()         { *m = ClusterConfigSpecV3{} }
func (m *ClusterConfigSpecV3) String() string { return proto.CompactTextString(m) }
func (*ClusterConfigSpecV3) ProtoMessage()    {}
func (*ClusterConfigSpecV3) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{20}
}
func (m *ClusterConfigSpecV3) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterConfigSpecV3) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterConfigSpecV3.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ClusterConfigSpecV3) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterConfigSpecV3.Merge(dst, src)
}
func (m *ClusterConfigSpecV3) XXX_Size() int {
	return m.Size()
}
func (m *ClusterConfigSpecV3) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterConfigSpecV3.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterConfigSpecV3 proto.InternalMessageInfo

// AuditConfig represents audit log settings in the cluster
type AuditConfig struct {
	// Type is audit backend type
	Type string `protobuf:"bytes,1,opt,name=Type,proto3" json:"type,omitempty"`
	// Region is a region setting for audit sessions used by cloud providers
	Region string `protobuf:"bytes,2,opt,name=Region,proto3" json:"region,omitempty"`
	// AuditSessionsURI is a parameter where to upload sessions
	AuditSessionsURI string `protobuf:"bytes,3,opt,name=AuditSessionsURI,proto3" json:"audit_sessions_uri,omitempty"`
	// AuditEventsURI is a parameter with all supported outputs
	// for audit events
	AuditEventsURI github_com_gravitational_teleport_lib_wrappers.Strings `protobuf:"bytes,4,opt,name=AuditEventsURI,customtype=github.com/gravitational/teleport/lib/wrappers.Strings" json:"audit_events_uri,omitempty"`
	// AuditTableName is a DB table name used for audits
	// Deprecated in favor of AuditEventsURI
	// DELETE IN (3.1.0)
	AuditTableName       string   `protobuf:"bytes,5,opt,name=AuditTableName,proto3" json:"audit_table_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuditConfig) Reset()         { *m = AuditConfig{} }
func (m *AuditConfig) String() string { return proto.CompactTextString(m) }
func (*AuditConfig) ProtoMessage()    {}
func (*AuditConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{21}
}
func (m *AuditConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *AuditConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditConfig.Merge(dst, src)
}
func (m *AuditConfig) XXX_Size() int {
	return m.Size()
}
func (m *AuditConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditConfig.DiscardUnknown(m)
}

var xxx_messageInfo_AuditConfig proto.InternalMessageInfo

// Namespace represents namespace resource specification
type Namespace struct {
	// Kind is a resource kind
	Kind string `protobuf:"bytes,1,opt,name=Kind,proto3" json:"kind"`
	// SubKind is an optional resource sub kind, used in some resources
	SubKind string `protobuf:"bytes,2,opt,name=SubKind,proto3" json:"sub_kind,omitempty"`
	// Version is version
	Version string `protobuf:"bytes,3,opt,name=Version,proto3" json:"version"`
	// Metadata is User metadata
	Metadata Metadata `protobuf:"bytes,4,opt,name=Metadata" json:"metadata"`
	// Spec is a namespace spec
	Spec                 NamespaceSpec `protobuf:"bytes,5,opt,name=Spec" json:"spec"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Namespace) Reset()         { *m = Namespace{} }
func (m *Namespace) String() string { return proto.CompactTextString(m) }
func (*Namespace) ProtoMessage()    {}
func (*Namespace) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{22}
}
func (m *Namespace) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Namespace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Namespace.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Namespace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Namespace.Merge(dst, src)
}
func (m *Namespace) XXX_Size() int {
	return m.Size()
}
func (m *Namespace) XXX_DiscardUnknown() {
	xxx_messageInfo_Namespace.DiscardUnknown(m)
}

var xxx_messageInfo_Namespace proto.InternalMessageInfo

// NamespaceSpec is a namespace specificateion
type NamespaceSpec struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NamespaceSpec) Reset()         { *m = NamespaceSpec{} }
func (m *NamespaceSpec) String() string { return proto.CompactTextString(m) }
func (*NamespaceSpec) ProtoMessage()    {}
func (*NamespaceSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{23}
}
func (m *NamespaceSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NamespaceSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NamespaceSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *NamespaceSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NamespaceSpec.Merge(dst, src)
}
func (m *NamespaceSpec) XXX_Size() int {
	return m.Size()
}
func (m *NamespaceSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_NamespaceSpec.DiscardUnknown(m)
}

var xxx_messageInfo_NamespaceSpec proto.InternalMessageInfo

// RoleV3 represents role resource specification
type RoleV3 struct {
	// Kind is a resource kind
	Kind string `protobuf:"bytes,1,opt,name=Kind,proto3" json:"kind"`
	// SubKind is an optional resource sub kind, used in some resources
	SubKind string `protobuf:"bytes,2,opt,name=SubKind,proto3" json:"sub_kind,omitempty"`
	// Version is version
	Version string `protobuf:"bytes,3,opt,name=Version,proto3" json:"version"`
	// Metadata is User metadata
	Metadata Metadata `protobuf:"bytes,4,opt,name=Metadata" json:"metadata"`
	// Spec is a role specification
	Spec                 RoleSpecV3 `protobuf:"bytes,5,opt,name=Spec" json:"spec"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *RoleV3) Reset()      { *m = RoleV3{} }
func (*RoleV3) ProtoMessage() {}
func (*RoleV3) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{24}
}
func (m *RoleV3) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RoleV3) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RoleV3.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RoleV3) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleV3.Merge(dst, src)
}
func (m *RoleV3) XXX_Size() int {
	return m.Size()
}
func (m *RoleV3) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleV3.DiscardUnknown(m)
}

var xxx_messageInfo_RoleV3 proto.InternalMessageInfo

// RoleSpecV3 is role specification for RoleV3.
type RoleSpecV3 struct {
	// Options is for OpenSSH options like agent forwarding.
	Options RoleOptions `protobuf:"bytes,1,opt,name=Options" json:"options,omitempty"`
	// Allow is the set of conditions evaluated to grant access.
	Allow RoleConditions `protobuf:"bytes,2,opt,name=Allow" json:"allow,omitempty"`
	// Deny is the set of conditions evaluated to deny access. Deny takes priority over allow.
	Deny                 RoleConditions `protobuf:"bytes,3,opt,name=Deny" json:"deny,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RoleSpecV3) Reset()         { *m = RoleSpecV3{} }
func (m *RoleSpecV3) String() string { return proto.CompactTextString(m) }
func (*RoleSpecV3) ProtoMessage()    {}
func (*RoleSpecV3) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{25}
}
func (m *RoleSpecV3) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RoleSpecV3) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RoleSpecV3.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RoleSpecV3) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleSpecV3.Merge(dst, src)
}
func (m *RoleSpecV3) XXX_Size() int {
	return m.Size()
}
func (m *RoleSpecV3) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleSpecV3.DiscardUnknown(m)
}

var xxx_messageInfo_RoleSpecV3 proto.InternalMessageInfo

// RoleOptions is a set of role options
type RoleOptions struct {
	// ForwardAgent is SSH agent forwarding.
	ForwardAgent Bool `protobuf:"varint,1,opt,name=ForwardAgent,proto3,casttype=Bool" json:"forward_agent"`
	// MaxSessionTTL defines how long a SSH session can last for.
	MaxSessionTTL Duration `protobuf:"varint,2,opt,name=MaxSessionTTL,proto3,casttype=Duration" json:"max_session_ttl,omitempty"`
	// PortForwarding defines if the certificate will have "permit-port-forwarding"
	// in the certificate. PortForwarding is "yes" if not set,
	// that's why this is a pointer
	PortForwarding *BoolOption `protobuf:"bytes,3,opt,name=PortForwarding,customtype=BoolOption" json:"port_forwarding,omitempty"`
	// CertificateFormat defines the format of the user certificate to allow
	// compatibility with older versions of OpenSSH.
	CertificateFormat string `protobuf:"bytes,4,opt,name=CertificateFormat,proto3" json:"cert_format"`
	// ClientIdleTimeout sets disconnect clients on idle timeout behavior,
	// if set to 0 means do not disconnect, otherwise is set to the idle
	// duration.
	ClientIdleTimeout Duration `protobuf:"varint,5,opt,name=ClientIdleTimeout,proto3,casttype=Duration" json:"client_idle_timeout,omitempty"`
	// DisconnectExpiredCert sets disconnect clients on expired certificates.
	DisconnectExpiredCert Bool     `protobuf:"varint,6,opt,name=DisconnectExpiredCert,proto3,casttype=Bool" json:"disconnect_expired_cert,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *RoleOptions) Reset()         { *m = RoleOptions{} }
func (m *RoleOptions) String() string { return proto.CompactTextString(m) }
func (*RoleOptions) ProtoMessage()    {}
func (*RoleOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{26}
}
func (m *RoleOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RoleOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RoleOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RoleOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleOptions.Merge(dst, src)
}
func (m *RoleOptions) XXX_Size() int {
	return m.Size()
}
func (m *RoleOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleOptions.DiscardUnknown(m)
}

var xxx_messageInfo_RoleOptions proto.InternalMessageInfo

// RoleConditions is a set of conditions that must all match to be allowed or
// denied access.
type RoleConditions struct {
	// Logins is a list of *nix system logins.
	Logins []string `protobuf:"bytes,1,rep,name=Logins" json:"logins"`
	// Namespaces is a list of namespaces (used to partition a cluster). The
	// field should be called "namespaces" when it returns in Teleport 2.4.
	Namespaces []string `protobuf:"bytes,2,rep,name=Namespaces" json:"-"`
	// NodeLabels is a map of node labels (used to dynamically grant access to nodes).
	NodeLabels Labels `protobuf:"bytes,3,opt,name=NodeLabels,customtype=Labels" json:"node_labels,omitempty"`
	// Rules is a list of rules and their access levels. Rules are a high level
	// construct used for access control.
	Rules []Rule `protobuf:"bytes,4,rep,name=Rules" json:"rules,omitempty"`
	// KubeGroups is a list of kubernetes groups
	KubeGroups           []string `protobuf:"bytes,5,rep,name=KubeGroups" json:"kubernetes_groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RoleConditions) Reset()         { *m = RoleConditions{} }
func (m *RoleConditions) String() string { return proto.CompactTextString(m) }
func (*RoleConditions) ProtoMessage()    {}
func (*RoleConditions) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{27}
}
func (m *RoleConditions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RoleConditions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RoleConditions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RoleConditions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleConditions.Merge(dst, src)
}
func (m *RoleConditions) XXX_Size() int {
	return m.Size()
}
func (m *RoleConditions) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleConditions.DiscardUnknown(m)
}

var xxx_messageInfo_RoleConditions proto.InternalMessageInfo

// Rule represents allow or deny rule that is executed to check
// if user or service have access to resource
type Rule struct {
	// Resources is a list of resources
	Resources []string `protobuf:"bytes,1,rep,name=Resources" json:"resources,omitempty"`
	// Verbs is a list of verbs
	Verbs []string `protobuf:"bytes,2,rep,name=Verbs" json:"verbs,omitempty"`
	// Where specifies optional advanced matcher
	Where string `protobuf:"bytes,3,opt,name=Where,proto3" json:"where,omitempty"`
	// Actions specifies optional actions taken when this rule matches
	Actions              []string `protobuf:"bytes,4,rep,name=Actions" json:"actions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Rule) Reset()         { *m = Rule{} }
func (m *Rule) String() string { return proto.CompactTextString(m) }
func (*Rule) ProtoMessage()    {}
func (*Rule) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{28}
}
func (m *Rule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Rule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Rule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Rule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Rule.Merge(dst, src)
}
func (m *Rule) XXX_Size() int {
	return m.Size()
}
func (m *Rule) XXX_DiscardUnknown() {
	xxx_messageInfo_Rule.DiscardUnknown(m)
}

var xxx_messageInfo_Rule proto.InternalMessageInfo

// BoolValue is a wrapper around bool, used in cases
// whenever bool value can have different default value when missing
type BoolValue struct {
	Value                bool     `protobuf:"varint,1,opt,name=Value,proto3" json:"Value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BoolValue) Reset()         { *m = BoolValue{} }
func (m *BoolValue) String() string { return proto.CompactTextString(m) }
func (*BoolValue) ProtoMessage()    {}
func (*BoolValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{29}
}
func (m *BoolValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BoolValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BoolValue.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *BoolValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoolValue.Merge(dst, src)
}
func (m *BoolValue) XXX_Size() int {
	return m.Size()
}
func (m *BoolValue) XXX_DiscardUnknown() {
	xxx_messageInfo_BoolValue.DiscardUnknown(m)
}

var xxx_messageInfo_BoolValue proto.InternalMessageInfo

// UserV2 is version 2 resource spec of the user
type UserV2 struct {
	// Kind is a resource kind
	Kind string `protobuf:"bytes,1,opt,name=Kind,proto3" json:"kind"`
	// SubKind is an optional resource sub kind, used in some resources
	SubKind string `protobuf:"bytes,2,opt,name=SubKind,proto3" json:"sub_kind,omitempty"`
	// Version is version
	Version string `protobuf:"bytes,3,opt,name=Version,proto3" json:"version"`
	// Metadata is User metadata
	Metadata Metadata `protobuf:"bytes,4,opt,name=Metadata" json:"metadata"`
	// Spec is a user specification
	Spec                 UserSpecV2 `protobuf:"bytes,5,opt,name=Spec" json:"spec"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *UserV2) Reset()      { *m = UserV2{} }
func (*UserV2) ProtoMessage() {}
func (*UserV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{30}
}
func (m *UserV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UserV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UserV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *UserV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserV2.Merge(dst, src)
}
func (m *UserV2) XXX_Size() int {
	return m.Size()
}
func (m *UserV2) XXX_DiscardUnknown() {
	xxx_messageInfo_UserV2.DiscardUnknown(m)
}

var xxx_messageInfo_UserV2 proto.InternalMessageInfo

// UserSpecV2 is a specification for V2 user
type UserSpecV2 struct {
	// OIDCIdentities lists associated OpenID Connect identities
	// that let user log in using externally verified identity
	OIDCIdentities []ExternalIdentity `protobuf:"bytes,1,rep,name=OIDCIdentities" json:"oidc_identities,omitempty"`
	// SAMLIdentities lists associated SAML identities
	// that let user log in using externally verified identity
	SAMLIdentities []ExternalIdentity `protobuf:"bytes,2,rep,name=SAMLIdentities" json:"saml_identities,omitempty"`
	// GithubIdentities list associated Github OAuth2 identities
	// that let user log in using externally verified identity
	GithubIdentities []ExternalIdentity `protobuf:"bytes,3,rep,name=GithubIdentities" json:"github_identities,omitempty"`
	// Roles is a list of roles assigned to user
	Roles []string `protobuf:"bytes,4,rep,name=Roles" json:"roles,omitempty"`
	// Traits are key/value pairs received from an identity provider (through
	// OIDC claims or SAML assertions) or from a system administrator for local
	// accounts. Traits are used to populate role variables.
	Traits github_com_gravitational_teleport_lib_wrappers.Traits `protobuf:"bytes,5,opt,name=Traits,customtype=github.com/gravitational/teleport/lib/wrappers.Traits" json:"traits,omitempty"`
	// Status is a login status of the user
	Status LoginStatus `protobuf:"bytes,6,opt,name=Status" json:"status,omitempty"`
	// Expires if set sets TTL on the user
	Expires time.Time `protobuf:"bytes,7,opt,name=Expires,stdtime" json:"expires"`
	// CreatedBy holds information about agent or person created this user
	CreatedBy            CreatedBy `protobuf:"bytes,8,opt,name=CreatedBy" json:"created_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *UserSpecV2) Reset()         { *m = UserSpecV2{} }
func (m *UserSpecV2) String() string { return proto.CompactTextString(m) }
func (*UserSpecV2) ProtoMessage()    {}
func (*UserSpecV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{31}
}
func (m *UserSpecV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UserSpecV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UserSpecV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *UserSpecV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserSpecV2.Merge(dst, src)
}
func (m *UserSpecV2) XXX_Size() int {
	return m.Size()
}
func (m *UserSpecV2) XXX_DiscardUnknown() {
	xxx_messageInfo_UserSpecV2.DiscardUnknown(m)
}

var xxx_messageInfo_UserSpecV2 proto.InternalMessageInfo

// ExternalIdentity is OpenID Connect/SAML or Github identity that is linked
// to particular user and connector and lets user to log in using external
// credentials, e.g. google
type ExternalIdentity struct {
	// ConnectorID is id of registered OIDC connector, e.g. 'google-example.com'
	ConnectorID string `protobuf:"bytes,1,opt,name=ConnectorID,proto3" json:"connector_id,omitempty"`
	// Username is username supplied by external identity provider
	Username             string   `protobuf:"bytes,2,opt,name=Username,proto3" json:"username,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExternalIdentity) Reset()      { *m = ExternalIdentity{} }
func (*ExternalIdentity) ProtoMessage() {}
func (*ExternalIdentity) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{32}
}
func (m *ExternalIdentity) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExternalIdentity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExternalIdentity.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ExternalIdentity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalIdentity.Merge(dst, src)
}
func (m *ExternalIdentity) XXX_Size() int {
	return m.Size()
}
func (m *ExternalIdentity) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalIdentity.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalIdentity proto.InternalMessageInfo

// LoginStatus is a login status of the user
type LoginStatus struct {
	// IsLocked tells us if user is locked
	IsLocked bool `protobuf:"varint,1,opt,name=IsLocked,proto3" json:"is_locked"`
	// LockedMessage contains the message in case if user is locked
	LockedMessage string `protobuf:"bytes,2,opt,name=LockedMessage,proto3" json:"locked_message,omitempty"`
	// LockedTime contains time when user was locked
	LockedTime time.Time `protobuf:"bytes,3,opt,name=LockedTime,stdtime" json:"locked_time,omitempty"`
	// LockExpires contains time when this lock will expire
	LockExpires          time.Time `protobuf:"bytes,4,opt,name=LockExpires,stdtime" json:"lock_expires,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *LoginStatus) Reset()         { *m = LoginStatus{} }
func (m *LoginStatus) String() string { return proto.CompactTextString(m) }
func (*LoginStatus) ProtoMessage()    {}
func (*LoginStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{33}
}
func (m *LoginStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LoginStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LoginStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *LoginStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoginStatus.Merge(dst, src)
}
func (m *LoginStatus) XXX_Size() int {
	return m.Size()
}
func (m *LoginStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_LoginStatus.DiscardUnknown(m)
}

var xxx_messageInfo_LoginStatus proto.InternalMessageInfo

// CreatedBy holds information about the person or agent who created the user
type CreatedBy struct {
	// Identity if present means that user was automatically created by identity
	Connector *ConnectorRef `protobuf:"bytes,1,opt,name=Connector" json:"connector,omitempty"`
	// Time specifies when user was created
	Time time.Time `protobuf:"bytes,2,opt,name=Time,stdtime" json:"time"`
	// User holds information about user
	User                 UserRef  `protobuf:"bytes,3,opt,name=User" json:"user"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreatedBy) Reset()      { *m = CreatedBy{} }
func (*CreatedBy) ProtoMessage() {}
func (*CreatedBy) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{34}
}
func (m *CreatedBy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreatedBy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreatedBy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *CreatedBy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreatedBy.Merge(dst, src)
}
func (m *CreatedBy) XXX_Size() int {
	return m.Size()
}
func (m *CreatedBy) XXX_DiscardUnknown() {
	xxx_messageInfo_CreatedBy.DiscardUnknown(m)
}

var xxx_messageInfo_CreatedBy proto.InternalMessageInfo

// ConnectorRef holds information about OIDC connector
type ConnectorRef struct {
	// Type is connector type
	Type string `protobuf:"bytes,1,opt,name=Type,proto3" json:"type"`
	// ID is connector ID
	ID string `protobuf:"bytes,2,opt,name=ID,proto3" json:"id"`
	// Identity is external identity of the user
	Identity             string   `protobuf:"bytes,3,opt,name=Identity,proto3" json:"identity"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConnectorRef) Reset()         { *m = ConnectorRef{} }
func (m *ConnectorRef) String() string { return proto.CompactTextString(m) }
func (*ConnectorRef) ProtoMessage()    {}
func (*ConnectorRef) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{35}
}
func (m *ConnectorRef) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConnectorRef) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConnectorRef.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ConnectorRef) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectorRef.Merge(dst, src)
}
func (m *ConnectorRef) XXX_Size() int {
	return m.Size()
}
func (m *ConnectorRef) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectorRef.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectorRef proto.InternalMessageInfo

// UserRef holds references to user
type UserRef struct {
	// Name is name of the user
	Name                 string   `protobuf:"bytes,1,opt,name=Name,proto3" json:"name"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UserRef) Reset()         { *m = UserRef{} }
func (m *UserRef) String() string { return proto.CompactTextString(m) }
func (*UserRef) ProtoMessage()    {}
func (*UserRef) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{36}
}
func (m *UserRef) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UserRef) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UserRef.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *UserRef) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserRef.Merge(dst, src)
}
func (m *UserRef) XXX_Size() int {
	return m.Size()
}
func (m *UserRef) XXX_DiscardUnknown() {
	xxx_messageInfo_UserRef.DiscardUnknown(m)
}

var xxx_messageInfo_UserRef proto.InternalMessageInfo

// ReverseTunnelV2 is version 2 of the resource spec of the reverse tunnel
type ReverseTunnelV2 struct {
	// Kind is a resource kind
	Kind string `protobuf:"bytes,1,opt,name=Kind,proto3" json:"kind"`
	// SubKind is an optional resource sub kind, used in some resources
	SubKind string `protobuf:"bytes,2,opt,name=SubKind,proto3" json:"sub_kind,omitempty"`
	// Version is version
	Version string `protobuf:"bytes,3,opt,name=Version,proto3" json:"version"`
	// Metadata is a resource metadata
	Metadata Metadata `protobuf:"bytes,4,opt,name=Metadata" json:"metadata"`
	// Spec is a reverse tunnel specification
	Spec                 ReverseTunnelSpecV2 `protobuf:"bytes,5,opt,name=Spec" json:"spec"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ReverseTunnelV2) Reset()         { *m = ReverseTunnelV2{} }
func (m *ReverseTunnelV2) String() string { return proto.CompactTextString(m) }
func (*ReverseTunnelV2) ProtoMessage()    {}
func (*ReverseTunnelV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{37}
}
func (m *ReverseTunnelV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReverseTunnelV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReverseTunnelV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ReverseTunnelV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReverseTunnelV2.Merge(dst, src)
}
func (m *ReverseTunnelV2) XXX_Size() int {
	return m.Size()
}
func (m *ReverseTunnelV2) XXX_DiscardUnknown() {
	xxx_messageInfo_ReverseTunnelV2.DiscardUnknown(m)
}

var xxx_messageInfo_ReverseTunnelV2 proto.InternalMessageInfo

// ReverseTunnelSpecV2 is a specification for V2 reverse tunnel
type ReverseTunnelSpecV2 struct {
	// ClusterName is a domain name of remote cluster we are connecting to
	ClusterName string `protobuf:"bytes,1,opt,name=ClusterName,proto3" json:"cluster_name"`
	// DialAddrs is a list of remote address to establish a connection to
	// it's always SSH over TCP
	DialAddrs []string `protobuf:"bytes,2,rep,name=DialAddrs" json:"dial_addrs,omitempty"`
	// Type is the type of reverse tunnel, either proxy or node.
	Type                 TunnelType `protobuf:"bytes,3,opt,name=Type,proto3,casttype=TunnelType" json:"type"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ReverseTunnelSpecV2) Reset()         { *m = ReverseTunnelSpecV2{} }
func (m *ReverseTunnelSpecV2) String() string { return proto.CompactTextString(m) }
func (*ReverseTunnelSpecV2) ProtoMessage()    {}
func (*ReverseTunnelSpecV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{38}
}
func (m *ReverseTunnelSpecV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReverseTunnelSpecV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReverseTunnelSpecV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ReverseTunnelSpecV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReverseTunnelSpecV2.Merge(dst, src)
}
func (m *ReverseTunnelSpecV2) XXX_Size() int {
	return m.Size()
}
func (m *ReverseTunnelSpecV2) XXX_DiscardUnknown() {
	xxx_messageInfo_ReverseTunnelSpecV2.DiscardUnknown(m)
}

var xxx_messageInfo_ReverseTunnelSpecV2 proto.InternalMessageInfo

// TunnelConnectionV2 is version 2 of the resource spec of the tunnel connection
type TunnelConnectionV2 struct {
	// Kind is a resource kind
	Kind string `protobuf:"bytes,1,opt,name=Kind,proto3" json:"kind"`
	// SubKind is an optional resource sub kind, used in some resources
	SubKind string `protobuf:"bytes,2,opt,name=SubKind,proto3" json:"sub_kind,omitempty"`
	// Version is version
	Version string `protobuf:"bytes,3,opt,name=Version,proto3" json:"version"`
	// Metadata is a resource metadata
	Metadata Metadata `protobuf:"bytes,4,opt,name=Metadata" json:"metadata"`
	// Spec is a tunnel specification
	Spec                 TunnelConnectionSpecV2 `protobuf:"bytes,5,opt,name=Spec" json:"spec"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *TunnelConnectionV2) Reset()      { *m = TunnelConnectionV2{} }
func (*TunnelConnectionV2) ProtoMessage() {}
func (*TunnelConnectionV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{39}
}
func (m *TunnelConnectionV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TunnelConnectionV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TunnelConnectionV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *TunnelConnectionV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TunnelConnectionV2.Merge(dst, src)
}
func (m *TunnelConnectionV2) XXX_Size() int {
	return m.Size()
}
func (m *TunnelConnectionV2) XXX_DiscardUnknown() {
	xxx_messageInfo_TunnelConnectionV2.DiscardUnknown(m)
}

var xxx_messageInfo_TunnelConnectionV2 proto.InternalMessageInfo

// TunnelConnectionSpecV2 is a specification for V2 tunnel connection
type TunnelConnectionSpecV2 struct {
	// ClusterName is a name of the cluster
	ClusterName string `protobuf:"bytes,1,opt,name=ClusterName,proto3" json:"cluster_name"`
	// ProxyName is the name of the proxy server
	ProxyName string `protobuf:"bytes,2,opt,name=ProxyName,proto3" json:"proxy_name"`
	// LastHeartbeat is a time of the last heartbeat
	LastHeartbeat time.Time `protobuf:"bytes,3,opt,name=LastHeartbeat,stdtime" json:"last_heartbeat,omitempty"`
	// Type is the type of reverse tunnel, either proxy or node.
	Type                 TunnelType `protobuf:"bytes,4,opt,name=Type,proto3,casttype=TunnelType" json:"type"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *TunnelConnectionSpecV2) Reset()         { *m = TunnelConnectionSpecV2{} }
func (m *TunnelConnectionSpecV2) String() string { return proto.CompactTextString(m) }
func (*TunnelConnectionSpecV2) ProtoMessage()    {}
func (*TunnelConnectionSpecV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_types_d74b24171725e8e9, []int{40}
}
func (m *TunnelConnectionSpecV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TunnelConnectionSpecV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TunnelConnectionSpecV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *TunnelConnectionSpecV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TunnelConnectionSpecV2.Merge(dst, src)
}
func (m *TunnelConnectionSpecV2) XXX_Size() int {
	return m.Size()
}
func (m *TunnelConnectionSpecV2) XXX_DiscardUnknown() {
	xxx_messageInfo_TunnelConnectionSpecV2.DiscardUnknown(m)
}

var xxx_messageInfo_TunnelConnectionSpecV2 proto.InternalMessageInfo

func init() {
	proto.RegisterType((*KeepAlive)(nil), "services.KeepAlive")
	proto.RegisterType((*Metadata)(nil), "services.Metadata")
	proto.RegisterMapType((map[string]string)(nil), "services.Metadata.LabelsEntry")
	proto.RegisterType((*Rotation)(nil), "services.Rotation")
	proto.RegisterType((*RotationSchedule)(nil), "services.RotationSchedule")
	proto.RegisterType((*ResourceHeader)(nil), "services.ResourceHeader")
	proto.RegisterType((*ServerV2)(nil), "services.ServerV2")
	proto.RegisterType((*ServerSpecV2)(nil), "services.ServerSpecV2")
	proto.RegisterMapType((map[string]CommandLabelV2)(nil), "services.ServerSpecV2.CmdLabelsEntry")
	proto.RegisterType((*CommandLabelV2)(nil), "services.CommandLabelV2")
	proto.RegisterType((*TLSKeyPair)(nil), "services.TLSKeyPair")
	proto.RegisterType((*CertAuthorityV2)(nil), "services.CertAuthorityV2")
	proto.RegisterType((*CertAuthoritySpecV2)(nil), "services.CertAuthoritySpecV2")
	proto.RegisterType((*RoleMapping)(nil), "services.RoleMapping")
	proto.RegisterType((*ProvisionTokenV1)(nil), "services.ProvisionTokenV1")
	proto.RegisterType((*ProvisionTokenV2)(nil), "services.ProvisionTokenV2")
	proto.RegisterType((*ProvisionTokenSpecV2)(nil), "services.ProvisionTokenSpecV2")
	proto.RegisterType((*StaticTokensV2)(nil), "services.StaticTokensV2")
	proto.RegisterType((*StaticTokensSpecV2)(nil), "services.StaticTokensSpecV2")
	proto.RegisterType((*ClusterNameV2)(nil), "services.ClusterNameV2")
	proto.RegisterType((*ClusterNameSpecV2)(nil), "services.ClusterNameSpecV2")
	proto.RegisterType((*ClusterConfigV3)(nil), "services.ClusterConfigV3")
	proto.RegisterType((*ClusterConfigSpecV3)(nil), "services.ClusterConfigSpecV3")
	proto.RegisterType((*AuditConfig)(nil), "services.AuditConfig")
	proto.RegisterType((*Namespace)(nil), "services.Namespace")
	proto.RegisterType((*NamespaceSpec)(nil), "services.NamespaceSpec")
	proto.RegisterType((*RoleV3)(nil), "services.RoleV3")
	proto.RegisterType((*RoleSpecV3)(nil), "services.RoleSpecV3")
	proto.RegisterType((*RoleOptions)(nil), "services.RoleOptions")
	proto.RegisterType((*RoleConditions)(nil), "services.RoleConditions")
	proto.RegisterType((*Rule)(nil), "services.Rule")
	proto.RegisterType((*BoolValue)(nil), "services.BoolValue")
	proto.RegisterType((*UserV2)(nil), "services.UserV2")
	proto.RegisterType((*UserSpecV2)(nil), "services.UserSpecV2")
	proto.RegisterType((*ExternalIdentity)(nil), "services.ExternalIdentity")
	proto.RegisterType((*LoginStatus)(nil), "services.LoginStatus")
	proto.RegisterType((*CreatedBy)(nil), "services.CreatedBy")
	proto.RegisterType((*ConnectorRef)(nil), "services.ConnectorRef")
	proto.RegisterType((*UserRef)(nil), "services.UserRef")
	proto.RegisterType((*ReverseTunnelV2)(nil), "services.ReverseTunnelV2")
	proto.RegisterType((*ReverseTunnelSpecV2)(nil), "services.ReverseTunnelSpecV2")
	proto.RegisterType((*TunnelConnectionV2)(nil), "services.TunnelConnectionV2")
	proto.RegisterType((*TunnelConnectionSpecV2)(nil), "services.TunnelConnectionSpecV2")
}
func (m *KeepAlive) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeepAlive) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ServerName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ServerName)))
		i += copy(dAtA[i:], m.ServerName)
	}
	if len(m.Namespace) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Namespace)))
		i += copy(dAtA[i:], m.Namespace)
	}
	if m.LeaseID != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.LeaseID))
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.Expires)))
	n1, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Expires, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Metadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Metadata) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Namespace) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Namespace)))
		i += copy(dAtA[i:], m.Namespace)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if len(m.Labels) > 0 {
		for k, _ := range m.Labels {
			dAtA[i] = 0x2a
			i++
			v := m.Labels[k]
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			i = encodeVarintTypes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.Expires != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTypes(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(*m.Expires)))
		n2, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(*m.Expires, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.ID != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.ID))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Rotation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Rotation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.State) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.State)))
		i += copy(dAtA[i:], m.State)
	}
	if len(m.Phase) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Phase)))
		i += copy(dAtA[i:], m.Phase)
	}
	if len(m.Mode) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Mode)))
		i += copy(dAtA[i:], m.Mode)
	}
	if len(m.CurrentID) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.CurrentID)))
		i += copy(dAtA[i:], m.CurrentID)
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.Started)))
	n3, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Started, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if m.GracePeriod != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.GracePeriod))
	}
	dAtA[i] = 0x3a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.LastRotated)))
	n4, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.LastRotated, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	dAtA[i] = 0x42
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Schedule.Size()))
	n5, err := m.Schedule.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RotationSchedule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RotationSchedule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintTypes(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.UpdateClients)))
	n6, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.UpdateClients, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	dAtA[i] = 0x12
	i++
	i = encodeVarintTypes(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.UpdateServers)))
	n7, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.UpdateServers, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	dAtA[i] = 0x1a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.Standby)))
	n8, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Standby, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ResourceHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceHeader) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.SubKind) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SubKind)))
		i += copy(dAtA[i:], m.SubKind)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Metadata.Size()))
	n9, err := m.Metadata.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ServerV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServerV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.SubKind) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SubKind)))
		i += copy(dAtA[i:], m.SubKind)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Metadata.Size()))
	n10, err := m.Metadata.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	dAtA[i] = 0x2a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Spec.Size()))
	n11, err := m.Spec.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ServerSpecV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServerSpecV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Addr) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Addr)))
		i += copy(dAtA[i:], m.Addr)
	}
	if len(m.PublicAddr) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.PublicAddr)))
		i += copy(dAtA[i:], m.PublicAddr)
	}
	if len(m.Hostname) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Hostname)))
		i += copy(dAtA[i:], m.Hostname)
	}
	if len(m.CmdLabels) > 0 {
		for k, _ := range m.CmdLabels {
			dAtA[i] = 0x22
			i++
			v := m.CmdLabels[k]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovTypes(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovTypes(uint64(len(k))) + msgSize
			i = encodeVarintTypes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintTypes(dAtA, i, uint64((&v).Size()))
			n12, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n12
		}
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Rotation.Size()))
	n13, err := m.Rotation.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n13
	if m.UseTunnel {
		dAtA[i] = 0x30
		i++
		if m.UseTunnel {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CommandLabelV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandLabelV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Period != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Period))
	}
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Result) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Result)))
		i += copy(dAtA[i:], m.Result)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TLSKeyPair) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TLSKeyPair) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Cert) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Cert)))
		i += copy(dAtA[i:], m.Cert)
	}
	if len(m.Key) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CertAuthorityV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CertAuthorityV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.SubKind) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SubKind)))
		i += copy(dAtA[i:], m.SubKind)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Metadata.Size()))
	n14, err := m.Metadata.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n14
	dAtA[i] = 0x2a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Spec.Size()))
	n15, err := m.Spec.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n15
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CertAuthoritySpecV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CertAuthoritySpecV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Type) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if len(m.ClusterName) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ClusterName)))
		i += copy(dAtA[i:], m.ClusterName)
	}
	if len(m.CheckingKeys) > 0 {
		for _, b := range m.CheckingKeys {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	if len(m.SigningKeys) > 0 {
		for _, b := range m.SigningKeys {
			dAtA[i] = 0x22
			i++
			i = encodeVarintTypes(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	if len(m.Roles) > 0 {
		for _, s := range m.Roles {
			dAtA[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.RoleMap) > 0 {
		for _, msg := range m.RoleMap {
			dAtA[i] = 0x32
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.TLSKeyPairs) > 0 {
		for _, msg := range m.TLSKeyPairs {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Rotation != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Rotation.Size()))
		n16, err := m.Rotation.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RoleMapping) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoleMapping) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Remote) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Remote)))
		i += copy(dAtA[i:], m.Remote)
	}
	if len(m.Local) > 0 {
		for _, s := range m.Local {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ProvisionTokenV1) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProvisionTokenV1) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Roles) > 0 {
		for _, s := range m.Roles {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintTypes(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.Expires)))
	n17, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Expires, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n17
	if len(m.Token) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Token)))
		i += copy(dAtA[i:], m.Token)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ProvisionTokenV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProvisionTokenV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.SubKind) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SubKind)))
		i += copy(dAtA[i:], m.SubKind)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Metadata.Size()))
	n18, err := m.Metadata.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	dAtA[i] = 0x2a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Spec.Size()))
	n19, err := m.Spec.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n19
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ProvisionTokenSpecV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProvisionTokenSpecV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Roles) > 0 {
		for _, s := range m.Roles {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StaticTokensV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StaticTokensV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.SubKind) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SubKind)))
		i += copy(dAtA[i:], m.SubKind)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Metadata.Size()))
	n20, err := m.Metadata.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n20
	dAtA[i] = 0x2a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Spec.Size()))
	n21, err := m.Spec.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n21
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StaticTokensSpecV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StaticTokensSpecV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.StaticTokens) > 0 {
		for _, msg := range m.StaticTokens {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ClusterNameV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterNameV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.SubKind) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SubKind)))
		i += copy(dAtA[i:], m.SubKind)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Metadata.Size()))
	n22, err := m.Metadata.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n22
	dAtA[i] = 0x2a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Spec.Size()))
	n23, err := m.Spec.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n23
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ClusterNameSpecV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterNameSpecV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ClusterName)))
		i += copy(dAtA[i:], m.ClusterName)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ClusterConfigV3) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterConfigV3) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.SubKind) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SubKind)))
		i += copy(dAtA[i:], m.SubKind)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Metadata.Size()))
	n24, err := m.Metadata.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n24
	dAtA[i] = 0x2a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Spec.Size()))
	n25, err := m.Spec.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n25
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ClusterConfigSpecV3) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterConfigSpecV3) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionRecording) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SessionRecording)))
		i += copy(dAtA[i:], m.SessionRecording)
	}
	if len(m.ClusterID) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ClusterID)))
		i += copy(dAtA[i:], m.ClusterID)
	}
	if len(m.ProxyChecksHostKeys) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ProxyChecksHostKeys)))
		i += copy(dAtA[i:], m.ProxyChecksHostKeys)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Audit.Size()))
	n26, err := m.Audit.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n26
	if m.ClientIdleTimeout != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.ClientIdleTimeout))
	}
	if m.DisconnectExpiredCert {
		dAtA[i] = 0x30
		i++
		if m.DisconnectExpiredCert {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.KeepAliveInterval != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.KeepAliveInterval))
	}
	if m.KeepAliveCountMax != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.KeepAliveCountMax))
	}
	if m.LocalAuth {
		dAtA[i] = 0x48
		i++
		if m.LocalAuth {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AuditConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Type) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if len(m.Region) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Region)))
		i += copy(dAtA[i:], m.Region)
	}
	if len(m.AuditSessionsURI) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.AuditSessionsURI)))
		i += copy(dAtA[i:], m.AuditSessionsURI)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.AuditEventsURI.Size()))
	n27, err := m.AuditEventsURI.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n27
	if len(m.AuditTableName) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.AuditTableName)))
		i += copy(dAtA[i:], m.AuditTableName)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Namespace) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Namespace) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.SubKind) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SubKind)))
		i += copy(dAtA[i:], m.SubKind)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Metadata.Size()))
	n28, err := m.Metadata.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n28
	dAtA[i] = 0x2a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Spec.Size()))
	n29, err := m.Spec.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n29
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NamespaceSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NamespaceSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RoleV3) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoleV3) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.SubKind) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SubKind)))
		i += copy(dAtA[i:], m.SubKind)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Metadata.Size()))
	n30, err := m.Metadata.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n30
	dAtA[i] = 0x2a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Spec.Size()))
	n31, err := m.Spec.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n31
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RoleSpecV3) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoleSpecV3) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Options.Size()))
	n32, err := m.Options.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n32
	dAtA[i] = 0x12
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Allow.Size()))
	n33, err := m.Allow.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n33
	dAtA[i] = 0x1a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Deny.Size()))
	n34, err := m.Deny.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n34
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RoleOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoleOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ForwardAgent {
		dAtA[i] = 0x8
		i++
		if m.ForwardAgent {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.MaxSessionTTL != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.MaxSessionTTL))
	}
	if m.PortForwarding != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.PortForwarding.Size()))
		n35, err := m.PortForwarding.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n35
	}
	if len(m.CertificateFormat) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.CertificateFormat)))
		i += copy(dAtA[i:], m.CertificateFormat)
	}
	if m.ClientIdleTimeout != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.ClientIdleTimeout))
	}
	if m.DisconnectExpiredCert {
		dAtA[i] = 0x30
		i++
		if m.DisconnectExpiredCert {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RoleConditions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoleConditions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Logins) > 0 {
		for _, s := range m.Logins {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Namespaces) > 0 {
		for _, s := range m.Namespaces {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.NodeLabels.Size()))
	n36, err := m.NodeLabels.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n36
	if len(m.Rules) > 0 {
		for _, msg := range m.Rules {
			dAtA[i] = 0x22
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.KubeGroups) > 0 {
		for _, s := range m.KubeGroups {
			dAtA[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Rule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Rule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Resources) > 0 {
		for _, s := range m.Resources {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Verbs) > 0 {
		for _, s := range m.Verbs {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Where) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Where)))
		i += copy(dAtA[i:], m.Where)
	}
	if len(m.Actions) > 0 {
		for _, s := range m.Actions {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *BoolValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BoolValue) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value {
		dAtA[i] = 0x8
		i++
		if m.Value {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *UserV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UserV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.SubKind) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SubKind)))
		i += copy(dAtA[i:], m.SubKind)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Metadata.Size()))
	n37, err := m.Metadata.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n37
	dAtA[i] = 0x2a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Spec.Size()))
	n38, err := m.Spec.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n38
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *UserSpecV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UserSpecV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.OIDCIdentities) > 0 {
		for _, msg := range m.OIDCIdentities {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.SAMLIdentities) > 0 {
		for _, msg := range m.SAMLIdentities {
			dAtA[i] = 0x12
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.GithubIdentities) > 0 {
		for _, msg := range m.GithubIdentities {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintTypes(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Roles) > 0 {
		for _, s := range m.Roles {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Traits.Size()))
	n39, err := m.Traits.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n39
	dAtA[i] = 0x32
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Status.Size()))
	n40, err := m.Status.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n40
	dAtA[i] = 0x3a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.Expires)))
	n41, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Expires, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n41
	dAtA[i] = 0x42
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.CreatedBy.Size()))
	n42, err := m.CreatedBy.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n42
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ExternalIdentity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExternalIdentity) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ConnectorID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ConnectorID)))
		i += copy(dAtA[i:], m.ConnectorID)
	}
	if len(m.Username) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Username)))
		i += copy(dAtA[i:], m.Username)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LoginStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoginStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.IsLocked {
		dAtA[i] = 0x8
		i++
		if m.IsLocked {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.LockedMessage) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.LockedMessage)))
		i += copy(dAtA[i:], m.LockedMessage)
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.LockedTime)))
	n43, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.LockedTime, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n43
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.LockExpires)))
	n44, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.LockExpires, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n44
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CreatedBy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreatedBy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Connector != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(m.Connector.Size()))
		n45, err := m.Connector.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n45
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintTypes(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.Time)))
	n46, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.Time, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n46
	dAtA[i] = 0x1a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.User.Size()))
	n47, err := m.User.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n47
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ConnectorRef) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectorRef) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Type) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if len(m.ID) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ID)))
		i += copy(dAtA[i:], m.ID)
	}
	if len(m.Identity) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Identity)))
		i += copy(dAtA[i:], m.Identity)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *UserRef) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UserRef) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ReverseTunnelV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReverseTunnelV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.SubKind) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SubKind)))
		i += copy(dAtA[i:], m.SubKind)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Metadata.Size()))
	n48, err := m.Metadata.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n48
	dAtA[i] = 0x2a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Spec.Size()))
	n49, err := m.Spec.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n49
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ReverseTunnelSpecV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReverseTunnelSpecV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ClusterName)))
		i += copy(dAtA[i:], m.ClusterName)
	}
	if len(m.DialAddrs) > 0 {
		for _, s := range m.DialAddrs {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Type) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TunnelConnectionV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TunnelConnectionV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.SubKind) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.SubKind)))
		i += copy(dAtA[i:], m.SubKind)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Metadata.Size()))
	n50, err := m.Metadata.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n50
	dAtA[i] = 0x2a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(m.Spec.Size()))
	n51, err := m.Spec.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n51
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TunnelConnectionSpecV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TunnelConnectionSpecV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ClusterName)))
		i += copy(dAtA[i:], m.ClusterName)
	}
	if len(m.ProxyName) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.ProxyName)))
		i += copy(dAtA[i:], m.ProxyName)
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintTypes(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.LastHeartbeat)))
	n52, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.LastHeartbeat, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n52
	if len(m.Type) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTypes(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintTypes(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *KeepAlive) Size() (n int) {
	var l int
	_ = l
	l = len(m.ServerName)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.LeaseID != 0 {
		n += 1 + sovTypes(uint64(m.LeaseID))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Expires)
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Metadata) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + len(v) + sovTypes(uint64(len(v)))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	if m.Expires != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdTime(*m.Expires)
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.ID != 0 {
		n += 1 + sovTypes(uint64(m.ID))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Rotation) Size() (n int) {
	var l int
	_ = l
	l = len(m.State)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Phase)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Mode)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.CurrentID)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Started)
	n += 1 + l + sovTypes(uint64(l))
	if m.GracePeriod != 0 {
		n += 1 + sovTypes(uint64(m.GracePeriod))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.LastRotated)
	n += 1 + l + sovTypes(uint64(l))
	l = m.Schedule.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RotationSchedule) Size() (n int) {
	var l int
	_ = l
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.UpdateClients)
	n += 1 + l + sovTypes(uint64(l))
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.UpdateServers)
	n += 1 + l + sovTypes(uint64(l))
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Standby)
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResourceHeader) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.SubKind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Metadata.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServerV2) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.SubKind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Metadata.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServerSpecV2) Size() (n int) {
	var l int
	_ = l
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.PublicAddr)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Hostname)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.CmdLabels) > 0 {
		for k, v := range m.CmdLabels {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovTypes(uint64(len(k))) + 1 + l + sovTypes(uint64(l))
			n += mapEntrySize + 1 + sovTypes(uint64(mapEntrySize))
		}
	}
	l = m.Rotation.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.UseTunnel {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandLabelV2) Size() (n int) {
	var l int
	_ = l
	if m.Period != 0 {
		n += 1 + sovTypes(uint64(m.Period))
	}
	if len(m.Command) > 0 {
		for _, s := range m.Command {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = len(m.Result)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TLSKeyPair) Size() (n int) {
	var l int
	_ = l
	l = len(m.Cert)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CertAuthorityV2) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.SubKind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Metadata.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CertAuthoritySpecV2) Size() (n int) {
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.CheckingKeys) > 0 {
		for _, b := range m.CheckingKeys {
			l = len(b)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.SigningKeys) > 0 {
		for _, b := range m.SigningKeys {
			l = len(b)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.Roles) > 0 {
		for _, s := range m.Roles {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.RoleMap) > 0 {
		for _, e := range m.RoleMap {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.TLSKeyPairs) > 0 {
		for _, e := range m.TLSKeyPairs {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if m.Rotation != nil {
		l = m.Rotation.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RoleMapping) Size() (n int) {
	var l int
	_ = l
	l = len(m.Remote)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Local) > 0 {
		for _, s := range m.Local {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProvisionTokenV1) Size() (n int) {
	var l int
	_ = l
	if len(m.Roles) > 0 {
		for _, s := range m.Roles {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Expires)
	n += 1 + l + sovTypes(uint64(l))
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProvisionTokenV2) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.SubKind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Metadata.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProvisionTokenSpecV2) Size() (n int) {
	var l int
	_ = l
	if len(m.Roles) > 0 {
		for _, s := range m.Roles {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StaticTokensV2) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.SubKind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Metadata.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StaticTokensSpecV2) Size() (n int) {
	var l int
	_ = l
	if len(m.StaticTokens) > 0 {
		for _, e := range m.StaticTokens {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClusterNameV2) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.SubKind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Metadata.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClusterNameSpecV2) Size() (n int) {
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClusterConfigV3) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.SubKind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Metadata.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClusterConfigSpecV3) Size() (n int) {
	var l int
	_ = l
	l = len(m.SessionRecording)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.ClusterID)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.ProxyChecksHostKeys)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Audit.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.ClientIdleTimeout != 0 {
		n += 1 + sovTypes(uint64(m.ClientIdleTimeout))
	}
	if m.DisconnectExpiredCert {
		n += 2
	}
	if m.KeepAliveInterval != 0 {
		n += 1 + sovTypes(uint64(m.KeepAliveInterval))
	}
	if m.KeepAliveCountMax != 0 {
		n += 1 + sovTypes(uint64(m.KeepAliveCountMax))
	}
	if m.LocalAuth {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditConfig) Size() (n int) {
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.AuditSessionsURI)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.AuditEventsURI.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = len(m.AuditTableName)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Namespace) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.SubKind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Metadata.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NamespaceSpec) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RoleV3) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.SubKind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Metadata.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RoleSpecV3) Size() (n int) {
	var l int
	_ = l
	l = m.Options.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = m.Allow.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = m.Deny.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RoleOptions) Size() (n int) {
	var l int
	_ = l
	if m.ForwardAgent {
		n += 2
	}
	if m.MaxSessionTTL != 0 {
		n += 1 + sovTypes(uint64(m.MaxSessionTTL))
	}
	if m.PortForwarding != nil {
		l = m.PortForwarding.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.CertificateFormat)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.ClientIdleTimeout != 0 {
		n += 1 + sovTypes(uint64(m.ClientIdleTimeout))
	}
	if m.DisconnectExpiredCert {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RoleConditions) Size() (n int) {
	var l int
	_ = l
	if len(m.Logins) > 0 {
		for _, s := range m.Logins {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.Namespaces) > 0 {
		for _, s := range m.Namespaces {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = m.NodeLabels.Size()
	n += 1 + l + sovTypes(uint64(l))
	if len(m.Rules) > 0 {
		for _, e := range m.Rules {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.KubeGroups) > 0 {
		for _, s := range m.KubeGroups {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Rule) Size() (n int) {
	var l int
	_ = l
	if len(m.Resources) > 0 {
		for _, s := range m.Resources {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.Verbs) > 0 {
		for _, s := range m.Verbs {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = len(m.Where)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.Actions) > 0 {
		for _, s := range m.Actions {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BoolValue) Size() (n int) {
	var l int
	_ = l
	if m.Value {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UserV2) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.SubKind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Metadata.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UserSpecV2) Size() (n int) {
	var l int
	_ = l
	if len(m.OIDCIdentities) > 0 {
		for _, e := range m.OIDCIdentities {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.SAMLIdentities) > 0 {
		for _, e := range m.SAMLIdentities {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.GithubIdentities) > 0 {
		for _, e := range m.GithubIdentities {
			l = e.Size()
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	if len(m.Roles) > 0 {
		for _, s := range m.Roles {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = m.Traits.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = m.Status.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Expires)
	n += 1 + l + sovTypes(uint64(l))
	l = m.CreatedBy.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExternalIdentity) Size() (n int) {
	var l int
	_ = l
	l = len(m.ConnectorID)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LoginStatus) Size() (n int) {
	var l int
	_ = l
	if m.IsLocked {
		n += 2
	}
	l = len(m.LockedMessage)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.LockedTime)
	n += 1 + l + sovTypes(uint64(l))
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.LockExpires)
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CreatedBy) Size() (n int) {
	var l int
	_ = l
	if m.Connector != nil {
		l = m.Connector.Size()
		n += 1 + l + sovTypes(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.Time)
	n += 1 + l + sovTypes(uint64(l))
	l = m.User.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConnectorRef) Size() (n int) {
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Identity)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UserRef) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReverseTunnelV2) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.SubKind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Metadata.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReverseTunnelSpecV2) Size() (n int) {
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if len(m.DialAddrs) > 0 {
		for _, s := range m.DialAddrs {
			l = len(s)
			n += 1 + l + sovTypes(uint64(l))
		}
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TunnelConnectionV2) Size() (n int) {
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.SubKind)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = m.Metadata.Size()
	n += 1 + l + sovTypes(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovTypes(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TunnelConnectionSpecV2) Size() (n int) {
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = len(m.ProxyName)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.LastHeartbeat)
	n += 1 + l + sovTypes(uint64(l))
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovTypes(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovTypes(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTypes(x uint64) (n int) {
	return sovTypes(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *KeepAlive) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeepAlive: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeepAlive: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseID", wireType)
			}
			m.LeaseID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LeaseID |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expires", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Expires, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Metadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Metadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Metadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTypes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTypes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expires", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Expires == nil {
				m.Expires = new(time.Time)
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(m.Expires, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ID |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Rotation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Rotation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Rotation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.State = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Phase", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Phase = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mode = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CurrentID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Started", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Started, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GracePeriod", wireType)
			}
			m.GracePeriod = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GracePeriod |= (Duration(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastRotated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.LastRotated, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schedule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Schedule.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RotationSchedule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RotationSchedule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RotationSchedule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateClients", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.UpdateClients, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateServers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.UpdateServers, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Standby", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Standby, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubKind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubKind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServerV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServerV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubKind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubKind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerSpecV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServerSpecV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServerSpecV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublicAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PublicAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hostname = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CmdLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CmdLabels == nil {
				m.CmdLabels = make(map[string]CommandLabelV2)
			}
			var mapkey string
			mapvalue := &CommandLabelV2{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTypes
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTypes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthTypes
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthTypes
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &CommandLabelV2{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTypes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTypes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.CmdLabels[mapkey] = *mapvalue
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rotation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Rotation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseTunnel", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseTunnel = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandLabelV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandLabelV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandLabelV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Period", wireType)
			}
			m.Period = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Period |= (Duration(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Command = append(m.Command, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Result = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TLSKeyPair) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TLSKeyPair: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TLSKeyPair: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cert", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cert = append(m.Cert[:0], dAtA[iNdEx:postIndex]...)
			if m.Cert == nil {
				m.Cert = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CertAuthorityV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CertAuthorityV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CertAuthorityV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubKind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubKind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CertAuthoritySpecV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CertAuthoritySpecV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CertAuthoritySpecV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = CertAuthType(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckingKeys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CheckingKeys = append(m.CheckingKeys, make([]byte, postIndex-iNdEx))
			copy(m.CheckingKeys[len(m.CheckingKeys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SigningKeys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SigningKeys = append(m.SigningKeys, make([]byte, postIndex-iNdEx))
			copy(m.SigningKeys[len(m.SigningKeys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Roles", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Roles = append(m.Roles, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RoleMap", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RoleMap = append(m.RoleMap, RoleMapping{})
			if err := m.RoleMap[len(m.RoleMap)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TLSKeyPairs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TLSKeyPairs = append(m.TLSKeyPairs, TLSKeyPair{})
			if err := m.TLSKeyPairs[len(m.TLSKeyPairs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rotation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Rotation == nil {
				m.Rotation = &Rotation{}
			}
			if err := m.Rotation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoleMapping) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleMapping: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleMapping: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Remote", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Remote = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Local", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Local = append(m.Local, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProvisionTokenV1) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProvisionTokenV1: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProvisionTokenV1: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Roles", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Roles = append(m.Roles, github_com_gravitational_teleport.Role(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expires", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Expires, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProvisionTokenV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProvisionTokenV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProvisionTokenV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubKind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubKind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProvisionTokenSpecV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProvisionTokenSpecV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProvisionTokenSpecV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Roles", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Roles = append(m.Roles, github_com_gravitational_teleport.Role(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StaticTokensV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StaticTokensV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StaticTokensV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubKind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubKind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StaticTokensSpecV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StaticTokensSpecV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StaticTokensSpecV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StaticTokens", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StaticTokens = append(m.StaticTokens, ProvisionTokenV1{})
			if err := m.StaticTokens[len(m.StaticTokens)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterNameV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterNameV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterNameV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubKind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubKind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterNameSpecV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterNameSpecV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterNameSpecV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterConfigV3) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterConfigV3: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterConfigV3: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubKind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubKind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterConfigSpecV3) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterConfigSpecV3: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterConfigSpecV3: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionRecording", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionRecording = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyChecksHostKeys", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProxyChecksHostKeys = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Audit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Audit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientIdleTimeout", wireType)
			}
			m.ClientIdleTimeout = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ClientIdleTimeout |= (Duration(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisconnectExpiredCert", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisconnectExpiredCert = Bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeepAliveInterval", wireType)
			}
			m.KeepAliveInterval = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeepAliveInterval |= (Duration(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeepAliveCountMax", wireType)
			}
			m.KeepAliveCountMax = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeepAliveCountMax |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalAuth", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LocalAuth = Bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Region = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditSessionsURI", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditSessionsURI = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditEventsURI", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AuditEventsURI.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditTableName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditTableName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Namespace) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Namespace: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Namespace: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubKind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubKind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NamespaceSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NamespaceSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NamespaceSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoleV3) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleV3: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleV3: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubKind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubKind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoleSpecV3) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleSpecV3: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleSpecV3: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Allow", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Allow.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deny", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Deny.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoleOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForwardAgent", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForwardAgent = Bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxSessionTTL", wireType)
			}
			m.MaxSessionTTL = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxSessionTTL |= (Duration(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortForwarding", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PortForwarding == nil {
				m.PortForwarding = &BoolOption{}
			}
			if err := m.PortForwarding.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertificateFormat", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CertificateFormat = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientIdleTimeout", wireType)
			}
			m.ClientIdleTimeout = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ClientIdleTimeout |= (Duration(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisconnectExpiredCert", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisconnectExpiredCert = Bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoleConditions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleConditions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleConditions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Logins", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Logins = append(m.Logins, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespaces", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespaces = append(m.Namespaces, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.NodeLabels.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rules = append(m.Rules, Rule{})
			if err := m.Rules[len(m.Rules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KubeGroups", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KubeGroups = append(m.KubeGroups, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Rule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Rule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Rule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Verbs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Verbs = append(m.Verbs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Where", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Where = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Actions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Actions = append(m.Actions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BoolValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BoolValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BoolValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Value = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UserV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UserV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UserV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubKind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubKind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UserSpecV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UserSpecV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UserSpecV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OIDCIdentities", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OIDCIdentities = append(m.OIDCIdentities, ExternalIdentity{})
			if err := m.OIDCIdentities[len(m.OIDCIdentities)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SAMLIdentities", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SAMLIdentities = append(m.SAMLIdentities, ExternalIdentity{})
			if err := m.SAMLIdentities[len(m.SAMLIdentities)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GithubIdentities", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GithubIdentities = append(m.GithubIdentities, ExternalIdentity{})
			if err := m.GithubIdentities[len(m.GithubIdentities)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Roles", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Roles = append(m.Roles, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Traits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Traits.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expires", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Expires, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedBy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.CreatedBy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExternalIdentity) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExternalIdentity: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExternalIdentity: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectorID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConnectorID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LoginStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LoginStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LoginStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsLocked", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsLocked = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockedMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LockedMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockedTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.LockedTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockExpires", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.LockExpires, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreatedBy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreatedBy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreatedBy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Connector", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Connector == nil {
				m.Connector = &ConnectorRef{}
			}
			if err := m.Connector.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.Time, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.User.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectorRef) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConnectorRef: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConnectorRef: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Identity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Identity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UserRef) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UserRef: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UserRef: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReverseTunnelV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReverseTunnelV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReverseTunnelV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubKind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubKind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReverseTunnelSpecV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReverseTunnelSpecV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReverseTunnelSpecV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DialAddrs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DialAddrs = append(m.DialAddrs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = TunnelType(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TunnelConnectionV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TunnelConnectionV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TunnelConnectionV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubKind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubKind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TunnelConnectionSpecV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TunnelConnectionSpecV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TunnelConnectionSpecV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProxyName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.LastHeartbeat, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTypes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = TunnelType(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTypes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTypes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTypes(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTypes
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTypes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthTypes
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTypes
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTypes(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTypes = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTypes   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("types.proto", fileDescriptor_types_d74b24171725e8e9) }

var fileDescriptor_types_d74b24171725e8e9 = []byte{
	// 3270 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x3a, 0xcd, 0x6f, 0x1b, 0xc7,
	0xf5, 0xe6, 0x97, 0x44, 0x3e, 0x4a, 0xb2, 0x3c, 0x92, 0x65, 0x5a, 0x76, 0xbc, 0x0a, 0xfd, 0x8b,
	0x63, 0xff, 0x7e, 0x8e, 0xf4, 0x8b, 0xdc, 0x18, 0x49, 0x1a, 0x37, 0x11, 0x25, 0x7f, 0x28, 0x96,
	0x63, 0x67, 0x25, 0x2b, 0x08, 0xfa, 0xb1, 0x5d, 0xed, 0x8e, 0xa8, 0x85, 0x96, 0xbb, 0xc4, 0xee,
	0x50, 0x36, 0x6f, 0x01, 0x7a, 0x28, 0xda, 0x00, 0x69, 0x8a, 0x22, 0x68, 0x80, 0xf6, 0xd0, 0x7f,
	0xa0, 0xe7, 0x1e, 0x8a, 0xde, 0x7a, 0xf0, 0x31, 0xe7, 0x20, 0xdd, 0xb4, 0xe9, 0x21, 0x00, 0xff,
	0x04, 0x5f, 0x5a, 0xcc, 0x9b, 0xd9, 0xdd, 0x59, 0x92, 0xb2, 0x98, 0xb4, 0x17, 0xe5, 0x24, 0xea,
	0x7d, 0xcd, 0xbc, 0x37, 0x6f, 0xde, 0xd7, 0x2c, 0x54, 0x59, 0xb7, 0x4d, 0xc3, 0xc5, 0x76, 0xe0,
	0x33, 0x9f, 0x94, 0x43, 0x1a, 0x1c, 0x38, 0x16, 0x0d, 0xe7, 0x67, 0x9b, 0x7e, 0xd3, 0x47, 0xe0,
	0x12, 0xff, 0x25, 0xf0, 0xf3, 0x5a, 0xd3, 0xf7, 0x9b, 0x2e, 0x5d, 0xc2, 0xff, 0x76, 0x3a, 0xbb,
	0x4b, 0xcc, 0x69, 0xd1, 0x90, 0x99, 0xad, 0xb6, 0x24, 0xb8, 0xd1, 0x74, 0xd8, 0x5e, 0x67, 0x67,
	0xd1, 0xf2, 0x5b, 0x4b, 0xcd, 0xc0, 0x3c, 0x70, 0x98, 0xc9, 0x1c, 0xdf, 0x33, 0xdd, 0x25, 0x46,
	0x5d, 0xda, 0xf6, 0x03, 0xb6, 0xe4, 0x3a, 0x3b, 0x4b, 0x8f, 0x02, 0xb3, 0xdd, 0xa6, 0x41, 0x98,
	0xfc, 0x10, 0xec, 0xf5, 0x2f, 0x72, 0x50, 0xb9, 0x4b, 0x69, 0x7b, 0xc5, 0x75, 0x0e, 0x28, 0x59,
	0x02, 0xd8, 0xa4, 0xc1, 0x01, 0x0d, 0xde, 0x31, 0x5b, 0xb4, 0x96, 0x5b, 0xc8, 0x5d, 0xae, 0x34,
	0x4e, 0xf6, 0x22, 0xad, 0x1a, 0x22, 0xd4, 0xf0, 0xcc, 0x16, 0xd5, 0x15, 0x12, 0xf2, 0x7f, 0x50,
	0xe1, 0x7f, 0xc3, 0xb6, 0x69, 0xd1, 0x5a, 0x1e, 0xe9, 0x27, 0x7b, 0x91, 0x56, 0xf1, 0x62, 0xa0,
	0x9e, 0xe2, 0xc9, 0x25, 0x18, 0xdf, 0xa0, 0x66, 0x48, 0xd7, 0xd7, 0x6a, 0x85, 0x85, 0xdc, 0xe5,
	0x42, 0x63, 0xa2, 0x17, 0x69, 0x65, 0x97, 0x83, 0x0c, 0xc7, 0xd6, 0x63, 0x24, 0x59, 0x87, 0xf1,
	0x9b, 0x8f, 0xdb, 0x4e, 0x40, 0xc3, 0x5a, 0x71, 0x21, 0x77, 0xb9, 0xba, 0x3c, 0xbf, 0x28, 0xac,
	0xb0, 0x18, 0x5b, 0x61, 0x71, 0x2b, 0xb6, 0x42, 0x63, 0xe6, 0x49, 0xa4, 0x9d, 0xe8, 0x45, 0xda,
	0x38, 0x15, 0x2c, 0x1f, 0x7f, 0xa9, 0xe5, 0xf4, 0x98, 0xbf, 0xfe, 0xcb, 0x02, 0x94, 0xef, 0x51,
	0x66, 0xda, 0x26, 0x33, 0xc9, 0x79, 0x28, 0x2a, 0x7a, 0x95, 0x7b, 0x91, 0x56, 0x44, 0x85, 0x10,
	0x4a, 0x2e, 0x0e, 0xaa, 0x52, 0xea, 0x45, 0x5a, 0xee, 0x25, 0x55, 0x85, 0xef, 0x43, 0x75, 0x8d,
	0x86, 0x56, 0xe0, 0xb4, 0xb9, 0x91, 0x51, 0x8d, 0x4a, 0xe3, 0x6c, 0x2f, 0xd2, 0x4e, 0xdb, 0x29,
	0xf8, 0xaa, 0xdf, 0x72, 0x18, 0x6d, 0xb5, 0x59, 0x57, 0x57, 0xa9, 0xc9, 0x06, 0x8c, 0x6d, 0x98,
	0x3b, 0xd4, 0x0d, 0x6b, 0xa5, 0x85, 0xc2, 0xe5, 0xea, 0xf2, 0x85, 0xc5, 0xf8, 0xf0, 0x17, 0xe3,
	0x3d, 0x2e, 0x0a, 0x82, 0x9b, 0x1e, 0x0b, 0xba, 0x8d, 0xd9, 0x5e, 0xa4, 0x4d, 0xbb, 0x08, 0x50,
	0x44, 0x4a, 0x19, 0x64, 0x33, 0xb5, 0xd2, 0xd8, 0x91, 0x56, 0x7a, 0xee, 0x49, 0xa4, 0xe5, 0x7a,
	0x91, 0x76, 0x4a, 0x5a, 0x29, 0x95, 0x97, 0xb1, 0x17, 0x59, 0x80, 0xfc, 0xfa, 0x5a, 0x6d, 0x1c,
	0x4f, 0x67, 0xba, 0x17, 0x69, 0x13, 0x8e, 0xad, 0x2c, 0x9d, 0x5f, 0x5f, 0x9b, 0x7f, 0x0d, 0xaa,
	0xca, 0x1e, 0xc9, 0x34, 0x14, 0xf6, 0x69, 0x57, 0x98, 0x54, 0xe7, 0x3f, 0xc9, 0x2c, 0x94, 0x0e,
	0x4c, 0xb7, 0x23, 0x6d, 0xa8, 0x8b, 0x7f, 0x5e, 0xcf, 0xbf, 0x9a, 0xab, 0x7f, 0x52, 0x84, 0xb2,
	0xee, 0x0b, 0xff, 0x24, 0x57, 0xa0, 0xb4, 0xc9, 0x4c, 0x16, 0x9f, 0xc6, 0x4c, 0x2f, 0xd2, 0x4e,
	0x86, 0x1c, 0xa0, 0xac, 0x27, 0x28, 0x38, 0xe9, 0x83, 0x3d, 0x33, 0x8c, 0x4f, 0x05, 0x49, 0xdb,
	0x1c, 0xa0, 0x92, 0x22, 0x05, 0xb9, 0x04, 0xc5, 0x7b, 0xbe, 0x4d, 0xe5, 0xc1, 0x90, 0x5e, 0xa4,
	0x4d, 0xb5, 0x7c, 0x5b, 0x25, 0x44, 0x3c, 0xb9, 0x0a, 0x95, 0xd5, 0x4e, 0x10, 0x50, 0x8f, 0xad,
	0xaf, 0xa1, 0x93, 0x55, 0x1a, 0x53, 0xbd, 0x48, 0x03, 0x4b, 0x00, 0xb9, 0x3b, 0xa6, 0x04, 0xdc,
	0xd4, 0x9b, 0xcc, 0x0c, 0x18, 0xb5, 0x6b, 0xa5, 0x91, 0x4c, 0xcd, 0x1d, 0xf2, 0x54, 0x28, 0x58,
	0xfa, 0x4d, 0x2d, 0x25, 0x91, 0x3b, 0x50, 0xbd, 0x1d, 0x98, 0x16, 0x7d, 0x40, 0x03, 0xc7, 0xb7,
	0xf1, 0x0c, 0x0b, 0x8d, 0x4b, 0xbd, 0x48, 0x9b, 0x6b, 0x72, 0xb0, 0xd1, 0x46, 0x78, 0xca, 0xfd,
	0x34, 0xd2, 0xca, 0x6b, 0x9d, 0x00, 0xad, 0xa7, 0xab, 0xac, 0xe4, 0xa7, 0xfc, 0x48, 0x42, 0x86,
	0xa6, 0xa5, 0x36, 0x9e, 0xde, 0xb3, 0xb7, 0x58, 0x97, 0x5b, 0x9c, 0x73, 0xcd, 0x90, 0x19, 0x81,
	0xe0, 0xeb, 0xdb, 0xa7, 0x2a, 0x92, 0xe8, 0x50, 0xde, 0xb4, 0xf6, 0xa8, 0xdd, 0x71, 0x69, 0xad,
	0x2c, 0xc5, 0x27, 0xbe, 0x1b, 0x1f, 0x69, 0x4c, 0xd1, 0x98, 0x97, 0xe2, 0x49, 0x28, 0x21, 0x8a,
	0xf9, 0x13, 0x39, 0xaf, 0x97, 0x3f, 0xfd, 0x83, 0x76, 0xe2, 0x83, 0x2f, 0x16, 0x4e, 0xd4, 0xff,
	0x94, 0x87, 0xe9, 0x7e, 0x21, 0x64, 0x17, 0x26, 0x1f, 0xb6, 0x6d, 0x93, 0xd1, 0x55, 0xd7, 0xa1,
	0x1e, 0x0b, 0xd1, 0x4f, 0x9e, 0xad, 0xd6, 0xff, 0xc8, 0x75, 0x6b, 0x1d, 0x64, 0x34, 0x2c, 0xc1,
	0xd9, 0xa7, 0x58, 0x56, 0x6c, 0xba, 0x8e, 0x88, 0x6a, 0x21, 0x3a, 0xd9, 0x37, 0x5b, 0x47, 0x04,
	0xc7, 0x43, 0xd6, 0x91, 0x62, 0xa5, 0x0f, 0x79, 0xf6, 0x4e, 0x17, 0x9d, 0x73, 0x74, 0x1f, 0xe2,
	0x2c, 0x43, 0x7c, 0x88, 0x83, 0xeb, 0x5f, 0xe7, 0x60, 0x4a, 0xa7, 0xa1, 0xdf, 0x09, 0x2c, 0x7a,
	0x87, 0x9a, 0x36, 0x0d, 0xf8, 0x0d, 0xb8, 0xeb, 0x78, 0xb6, 0xbc, 0x56, 0x78, 0x03, 0xf6, 0x1d,
	0x4f, 0xbd, 0xc5, 0x88, 0x27, 0xff, 0x0f, 0xe3, 0x9b, 0x9d, 0x1d, 0x24, 0x15, 0xd7, 0x6a, 0x0e,
	0x4f, 0xac, 0xb3, 0x63, 0xf4, 0x91, 0xc7, 0x64, 0x64, 0x09, 0xc6, 0xb7, 0x69, 0x10, 0xa6, 0x71,
	0xef, 0x34, 0xdf, 0xe1, 0x81, 0x00, 0xa9, 0x0c, 0x92, 0x8a, 0xbc, 0x9d, 0xc6, 0x5e, 0x19, 0xc8,
	0xc9, 0x60, 0xc4, 0x4b, 0xbd, 0xa5, 0x25, 0x21, 0xaa, 0xb7, 0xc4, 0x54, 0xf5, 0x9f, 0xe7, 0xa1,
	0x2c, 0x4c, 0xb9, 0xbd, 0xcc, 0x03, 0xb9, 0xa2, 0x23, 0x06, 0x72, 0xbe, 0xe9, 0x6f, 0xad, 0xd9,
	0x0b, 0xfd, 0x9a, 0x55, 0x79, 0x42, 0x91, 0x9a, 0xa5, 0xfa, 0xbc, 0x35, 0x92, 0x3e, 0xd3, 0x52,
	0x9f, 0x72, 0xac, 0x4f, 0xaa, 0x05, 0x79, 0x15, 0x8a, 0x9b, 0x6d, 0x6a, 0xc9, 0x28, 0x32, 0x97,
	0x72, 0x0b, 0xd5, 0x38, 0x6e, 0x7b, 0xb9, 0x31, 0x21, 0x25, 0x14, 0xc3, 0x36, 0xb5, 0x74, 0xe4,
	0x50, 0x6e, 0xcb, 0x67, 0x05, 0x98, 0x50, 0xc9, 0xb9, 0x35, 0x56, 0x6c, 0x3b, 0x50, 0xad, 0x61,
	0xda, 0x76, 0xa0, 0x23, 0x94, 0xbc, 0x06, 0xf0, 0xa0, 0xb3, 0xe3, 0x3a, 0x16, 0xd2, 0xe4, 0xd3,
	0x84, 0xd5, 0x46, 0xa8, 0xc1, 0x49, 0x15, 0x9b, 0x28, 0xc4, 0xe4, 0x32, 0x94, 0xef, 0xf8, 0x21,
	0xe3, 0x39, 0x52, 0xda, 0x05, 0x13, 0xf6, 0x9e, 0x84, 0xe9, 0x09, 0x96, 0x98, 0x50, 0x59, 0x6d,
	0xd9, 0x32, 0xb9, 0x15, 0x31, 0xb9, 0xbd, 0x30, 0x5c, 0xb9, 0xc5, 0x84, 0x4e, 0xe4, 0xb8, 0xf3,
	0x52, 0xd7, 0x59, 0xab, 0x65, 0x1b, 0x03, 0xb9, 0x2e, 0x95, 0xca, 0x9d, 0x29, 0x8e, 0x11, 0xd2,
	0x7c, 0x64, 0x30, 0x04, 0xa5, 0xce, 0x14, 0x48, 0x88, 0xea, 0x4c, 0x49, 0xee, 0xb9, 0x0e, 0x95,
	0x87, 0x21, 0xdd, 0xea, 0x78, 0x1e, 0x75, 0x31, 0xf0, 0x96, 0x1b, 0x35, 0xbe, 0x87, 0x4e, 0x48,
	0x0d, 0x86, 0x50, 0x75, 0x0f, 0x09, 0xe9, 0xfc, 0x36, 0x4c, 0x65, 0xb7, 0x3f, 0x24, 0xfd, 0x2d,
	0xaa, 0xe9, 0xaf, 0xba, 0x5c, 0x4b, 0x37, 0xb9, 0xea, 0xb7, 0x5a, 0xa6, 0x27, 0xd8, 0xb7, 0x97,
	0xd5, 0xc4, 0xf8, 0x61, 0x0e, 0xa6, 0xb2, 0x58, 0xb2, 0x08, 0x63, 0x32, 0x31, 0xe4, 0x30, 0x31,
	0x70, 0x1f, 0x1e, 0x13, 0x29, 0x21, 0x93, 0x08, 0x24, 0x15, 0x77, 0x61, 0x29, 0xa1, 0x96, 0x5f,
	0x28, 0xc4, 0x2e, 0x6c, 0x09, 0x90, 0x1e, 0xe3, 0x48, 0x1d, 0xc6, 0x74, 0x1a, 0x76, 0x5c, 0x26,
	0x0f, 0x14, 0xb8, 0xd8, 0x00, 0x21, 0xba, 0xc4, 0xd4, 0xdf, 0x07, 0xd8, 0xda, 0xd8, 0xbc, 0x4b,
	0xbb, 0x0f, 0x4c, 0x07, 0xe3, 0xc9, 0x2a, 0x0d, 0x18, 0x6e, 0x63, 0x42, 0xc4, 0x13, 0x8b, 0x06,
	0x4c, 0x8d, 0x27, 0x1c, 0x4f, 0x2e, 0x42, 0xe1, 0x2e, 0xed, 0xa2, 0xd6, 0x13, 0x8d, 0x53, 0xbd,
	0x48, 0x9b, 0xdc, 0xa7, 0x4a, 0xdc, 0xd2, 0x39, 0xb6, 0xfe, 0x49, 0x1e, 0x4e, 0x72, 0xea, 0x95,
	0x0e, 0xdb, 0xf3, 0x03, 0x87, 0x75, 0x8f, 0xf3, 0x65, 0x7e, 0x33, 0x73, 0x99, 0x9f, 0x53, 0x0e,
	0x5a, 0xd5, 0x70, 0xa4, 0x3b, 0xfd, 0x8b, 0x22, 0xcc, 0x0c, 0xe1, 0x22, 0x57, 0xa1, 0xb8, 0xd5,
	0x6d, 0xc7, 0x35, 0x12, 0xf7, 0xd1, 0x22, 0x6f, 0x1e, 0x9e, 0x46, 0xda, 0x44, 0x4c, 0xce, 0xf1,
	0x3a, 0x52, 0x91, 0x65, 0xa8, 0xae, 0xba, 0x9d, 0x90, 0xc9, 0xf2, 0x5d, 0xd8, 0x0b, 0xab, 0x38,
	0x4b, 0x80, 0x45, 0xfd, 0xae, 0x12, 0x91, 0x57, 0x60, 0x62, 0x75, 0x8f, 0x5a, 0xfb, 0x8e, 0xd7,
	0xbc, 0x4b, 0xbb, 0x61, 0xad, 0xb0, 0x50, 0x88, 0xcf, 0xcf, 0x92, 0x70, 0x63, 0x9f, 0x76, 0x43,
	0x3d, 0x43, 0x46, 0xde, 0x80, 0xea, 0xa6, 0xd3, 0xf4, 0x62, 0xae, 0x22, 0x72, 0xcd, 0xf3, 0x92,
	0x22, 0x14, 0x60, 0x64, 0x52, 0x0b, 0x61, 0x85, 0x9c, 0x17, 0x74, 0xba, 0xef, 0x52, 0x51, 0x07,
	0xcb, 0x82, 0x2e, 0xe0, 0x00, 0xb5, 0xa0, 0x43, 0x0a, 0x72, 0x17, 0xc6, 0xf9, 0x8f, 0x7b, 0x66,
	0xbb, 0x36, 0x86, 0x71, 0xe5, 0xb4, 0x7a, 0xeb, 0x11, 0xd1, 0x76, 0xbc, 0xa6, 0x7a, 0xf1, 0x5d,
	0x6a, 0xb4, 0xcc, 0xb6, 0xea, 0x1a, 0x92, 0x90, 0xbc, 0x07, 0xd5, 0xd4, 0xb3, 0xc3, 0xda, 0x38,
	0x0a, 0x9c, 0x4d, 0x05, 0xa6, 0xc8, 0x86, 0x26, 0xe5, 0x9d, 0x61, 0x6e, 0xc8, 0x75, 0x31, 0xda,
	0x9c, 0x45, 0x55, 0x48, 0x91, 0x94, 0x09, 0x4e, 0xe5, 0x67, 0x06, 0xa7, 0xdc, 0x51, 0xc1, 0xa9,
	0xae, 0x43, 0x55, 0x51, 0x4c, 0xdc, 0xd8, 0x96, 0x9f, 0x14, 0xca, 0xf2, 0xc6, 0x72, 0x88, 0x2e,
	0x31, 0x44, 0x83, 0xd2, 0x86, 0x6f, 0x99, 0xae, 0xbc, 0xfa, 0x95, 0x5e, 0xa4, 0x95, 0x5c, 0x0e,
	0xd0, 0x05, 0xbc, 0xfe, 0xb7, 0x1c, 0x4c, 0x3f, 0x08, 0xfc, 0x03, 0x87, 0xbb, 0xfe, 0x96, 0xbf,
	0x4f, 0xbd, 0xed, 0x97, 0xc9, 0x7a, 0x7c, 0x0a, 0x39, 0xe4, 0xba, 0xc6, 0xb9, 0xf0, 0x14, 0x9e,
	0x46, 0xda, 0xa5, 0x23, 0xbb, 0x4a, 0xb4, 0x7e, 0x7c, 0x4a, 0x4a, 0x2f, 0x92, 0x1f, 0xbd, 0xb8,
	0x39, 0xa2, 0x17, 0xd1, 0xa0, 0x84, 0x5b, 0x95, 0xd7, 0x18, 0xb5, 0x62, 0x1c, 0xa0, 0x0b, 0xb8,
	0x72, 0x7f, 0x7e, 0x9b, 0x1f, 0xd0, 0xef, 0x18, 0x07, 0x96, 0xb7, 0x32, 0x81, 0x45, 0xe9, 0x12,
	0xb3, 0x2a, 0x8e, 0x14, 0x59, 0x4c, 0x98, 0x1d, 0xc6, 0xf5, 0x5f, 0x3c, 0xfc, 0xfa, 0x6f, 0xf2,
	0x30, 0xc5, 0x1b, 0x35, 0xc7, 0xc2, 0x05, 0xc2, 0xe3, 0x6c, 0xfa, 0x1f, 0x64, 0x4c, 0x7f, 0x5e,
	0xa9, 0x61, 0x14, 0x05, 0x47, 0x32, 0xfc, 0x3e, 0x90, 0x41, 0x1e, 0xf2, 0x10, 0x26, 0x54, 0x28,
	0x5a, 0x3f, 0xd3, 0x4c, 0xf5, 0xdf, 0xd2, 0xc6, 0x69, 0xb9, 0xca, 0x64, 0x88, 0x7c, 0x06, 0xde,
	0x80, 0x50, 0xcf, 0x88, 0xa9, 0xff, 0x3a, 0x0f, 0x93, 0x4a, 0x54, 0x3f, 0xce, 0x27, 0x70, 0x23,
	0x73, 0x02, 0xe7, 0x94, 0xac, 0x9a, 0xea, 0x37, 0xd2, 0x01, 0xdc, 0x86, 0x53, 0x03, 0x2c, 0xfd,
	0x29, 0x32, 0x37, 0x42, 0x8a, 0x14, 0x45, 0x8b, 0xf8, 0x7f, 0xd5, 0xf7, 0x76, 0x9d, 0xe6, 0xf6,
	0xb5, 0xef, 0x62, 0xd1, 0xa2, 0x6a, 0x88, 0xd6, 0xba, 0x76, 0x84, 0x81, 0x7f, 0x55, 0x82, 0x99,
	0x21, 0x5c, 0x64, 0x05, 0xa6, 0x37, 0x69, 0x88, 0x1b, 0xa7, 0x96, 0x1f, 0xd8, 0x8e, 0xd7, 0x94,
	0x76, 0xc2, 0x86, 0x31, 0x14, 0x38, 0x23, 0x88, 0x91, 0xfa, 0x00, 0x39, 0x8e, 0x67, 0x84, 0xe4,
	0xf5, 0x35, 0x69, 0x42, 0x31, 0x9e, 0x91, 0x87, 0x84, 0xe3, 0x99, 0x98, 0x80, 0x6c, 0xc0, 0xcc,
	0x83, 0xc0, 0x7f, 0xdc, 0xc5, 0x0a, 0x25, 0xe4, 0x4d, 0x89, 0x2c, 0x65, 0x38, 0x1f, 0x16, 0x25,
	0x6d, 0x8e, 0x36, 0xb0, 0xa0, 0x09, 0x0d, 0xde, 0xbf, 0x88, 0x9a, 0x66, 0x18, 0x1b, 0x79, 0x1d,
	0x4a, 0x2b, 0x1d, 0xdb, 0x61, 0xd2, 0xc0, 0x4a, 0xbd, 0x81, 0x60, 0xa1, 0x6a, 0x63, 0x52, 0x9a,
	0xa6, 0x64, 0x72, 0xa0, 0x2e, 0x58, 0xc8, 0xbb, 0xdc, 0xe7, 0x1c, 0xea, 0xb1, 0x75, 0xdb, 0xa5,
	0x3c, 0xe3, 0xf9, 0x1d, 0x86, 0xa6, 0x2e, 0x34, 0x2e, 0xf6, 0x22, 0x6d, 0x46, 0x4c, 0x24, 0x0c,
	0xc7, 0x76, 0xa9, 0xc1, 0x04, 0x3a, 0x53, 0xcd, 0x0f, 0x72, 0x93, 0xf7, 0xe1, 0xf4, 0x9a, 0x13,
	0x5a, 0xbe, 0xe7, 0x51, 0x8b, 0x89, 0xd4, 0x68, 0x63, 0x41, 0x2e, 0xfa, 0x16, 0x2e, 0xf6, 0x8c,
	0x9d, 0x10, 0x18, 0x22, 0xa7, 0xda, 0x06, 0xaf, 0xd1, 0x9f, 0x46, 0x5a, 0xb1, 0xe1, 0xfb, 0xae,
	0x3e, 0x5c, 0x02, 0xdf, 0x6d, 0x32, 0xfa, 0x5d, 0xf7, 0x18, 0x0d, 0x0e, 0x4c, 0x57, 0xce, 0xfe,
	0x70, 0xb7, 0xfb, 0x94, 0xb6, 0x0d, 0x93, 0x63, 0x0d, 0x47, 0xa2, 0xb3, 0xbb, 0x1d, 0xe0, 0x26,
	0xb7, 0x14, 0x91, 0xab, 0x7e, 0xc7, 0x63, 0xf7, 0xcc, 0xc7, 0x58, 0x11, 0x15, 0x44, 0x87, 0xa5,
	0x88, 0xb4, 0x38, 0xda, 0x68, 0x99, 0x8f, 0xf5, 0x41, 0x16, 0xf2, 0x3d, 0xa8, 0x60, 0xe5, 0xc2,
	0x2b, 0xdc, 0x5a, 0x05, 0x35, 0xe5, 0x77, 0x08, 0xb0, 0xaa, 0x31, 0xcc, 0x0e, 0xdb, 0x4b, 0x94,
	0x4b, 0x09, 0xeb, 0x9f, 0x16, 0xa0, 0xaa, 0x1c, 0x12, 0xef, 0x5d, 0x94, 0xf2, 0x19, 0x7b, 0x17,
	0x5e, 0x3e, 0xab, 0xbd, 0x0b, 0x16, 0xce, 0x57, 0x79, 0x8d, 0xd5, 0xe4, 0x97, 0x4f, 0xf8, 0x1a,
	0x0e, 0x5e, 0x03, 0x84, 0xa8, 0x83, 0x57, 0x41, 0x43, 0x36, 0x60, 0x1a, 0x17, 0x91, 0x5e, 0x1b,
	0x3e, 0xd4, 0xd7, 0xa5, 0xaf, 0x2d, 0xf4, 0x22, 0xed, 0x3c, 0x3a, 0x84, 0x21, 0xbd, 0x3c, 0x34,
	0x3a, 0x81, 0xa3, 0xc8, 0x18, 0xe0, 0x24, 0xbf, 0xcf, 0xc1, 0x14, 0x02, 0x6f, 0x1e, 0x50, 0x8f,
	0xa1, 0xb0, 0xa2, 0x9c, 0x0e, 0x24, 0xa3, 0xfa, 0x4d, 0x16, 0x38, 0x5e, 0x73, 0x9b, 0xf7, 0x8b,
	0x61, 0xe3, 0x47, 0xdc, 0xf3, 0x3e, 0x8f, 0xb4, 0xeb, 0xdf, 0x6c, 0xf0, 0x2f, 0x85, 0x84, 0xbd,
	0x48, 0x9b, 0x17, 0x5b, 0xa4, 0xb8, 0x60, 0xdf, 0x06, 0xfb, 0xf6, 0x42, 0x6e, 0xc9, 0xdd, 0x6d,
	0x99, 0x3b, 0x2e, 0xc5, 0x98, 0x59, 0x42, 0x55, 0x2f, 0xa4, 0x72, 0x18, 0x47, 0x61, 0xdc, 0x1c,
	0x90, 0x93, 0x70, 0xd5, 0xff, 0x95, 0x53, 0xc6, 0xeb, 0xc7, 0x37, 0x7c, 0xbe, 0x96, 0x09, 0x9f,
	0x67, 0x52, 0xee, 0x44, 0x37, 0x8e, 0x1e, 0x16, 0x38, 0xeb, 0x27, 0x61, 0x32, 0x43, 0x54, 0xff,
	0x59, 0x1e, 0xc6, 0x78, 0x05, 0x75, 0x9c, 0xd3, 0xc9, 0xf5, 0x8c, 0x3d, 0x66, 0xb3, 0xbd, 0xd9,
	0x48, 0x59, 0xe4, 0xeb, 0x1c, 0x40, 0x4a, 0x4c, 0xde, 0x86, 0xf1, 0xfb, 0xf8, 0x5a, 0x12, 0x0f,
	0x7c, 0xfb, 0xfa, 0x3d, 0x89, 0x6c, 0x9c, 0x8d, 0x9b, 0x08, 0x5f, 0x00, 0x54, 0x2b, 0x48, 0x1a,
	0x72, 0x1b, 0x4a, 0x2b, 0xae, 0xeb, 0x3f, 0x1a, 0x1c, 0xc5, 0x70, 0x49, 0xab, 0xbe, 0x67, 0x3b,
	0x42, 0xd8, 0x19, 0x29, 0xec, 0xa4, 0xc9, 0xc9, 0xd5, 0x26, 0x14, 0xf9, 0xc9, 0x1a, 0x14, 0xd7,
	0xa8, 0x17, 0x0f, 0x6e, 0x0f, 0x97, 0x33, 0x27, 0xe5, 0x4c, 0xd9, 0xd4, 0x53, 0x67, 0x1f, 0xc8,
	0x5d, 0xff, 0xb8, 0x28, 0x3a, 0xbb, 0x78, 0x7b, 0x37, 0x60, 0xe2, 0x96, 0x1f, 0x3c, 0x32, 0x03,
	0x7b, 0xa5, 0x49, 0x3d, 0x31, 0x61, 0x29, 0xe3, 0x6c, 0x6e, 0x72, 0x57, 0xc0, 0x0d, 0x93, 0x23,
	0x92, 0x48, 0x97, 0x21, 0x27, 0xf7, 0x61, 0xf2, 0x9e, 0xf9, 0x58, 0x86, 0x92, 0xad, 0xad, 0x0d,
	0xd4, 0xb2, 0xd0, 0xb8, 0xd2, 0x8b, 0xb4, 0xb3, 0x2d, 0xf3, 0x71, 0x1c, 0x81, 0x0c, 0xc6, 0xdc,
	0x43, 0x1e, 0x11, 0xb2, 0xfc, 0xc4, 0x85, 0xa9, 0x07, 0x7e, 0xc0, 0xe4, 0x22, 0x3c, 0x6b, 0x0b,
	0x7d, 0x67, 0x52, 0x7d, 0xf9, 0x36, 0x30, 0x0c, 0x35, 0x96, 0x78, 0x2f, 0xfb, 0x79, 0xa4, 0x01,
	0x07, 0x09, 0x8d, 0xf8, 0xc2, 0x3c, 0xec, 0x18, 0xbb, 0x89, 0x04, 0x35, 0x20, 0x64, 0x65, 0x93,
	0x1b, 0x70, 0x8a, 0x27, 0x21, 0x67, 0xd7, 0xb1, 0x4c, 0x46, 0x6f, 0xf9, 0x41, 0xcb, 0x64, 0xf2,
	0x25, 0x06, 0x5f, 0x1c, 0x79, 0x02, 0xe3, 0x92, 0x5a, 0x26, 0xd3, 0x07, 0x29, 0xc9, 0x0f, 0x0f,
	0xcf, 0xb4, 0x2f, 0xf5, 0x22, 0xed, 0xb9, 0x21, 0x99, 0xf6, 0x10, 0x2b, 0x0c, 0xc9, 0xb9, 0xcd,
	0x67, 0xe7, 0xdc, 0x97, 0x65, 0x1f, 0xff, 0xfc, 0x21, 0x79, 0x37, 0xb3, 0xd0, 0xb3, 0x32, 0x70,
	0xfd, 0xcf, 0x79, 0x98, 0xca, 0xfa, 0x10, 0xef, 0xf7, 0x37, 0xfc, 0xa6, 0xe3, 0xc5, 0x9d, 0x19,
	0xf6, 0xfb, 0x2e, 0x42, 0x74, 0x89, 0x21, 0x2f, 0x00, 0x24, 0xa1, 0x24, 0x94, 0x4d, 0xbf, 0x7c,
	0xab, 0x54, 0x10, 0xe4, 0x27, 0x00, 0xef, 0xf8, 0x36, 0x95, 0x63, 0xd9, 0x82, 0xbc, 0x4e, 0x49,
	0x42, 0x10, 0xa3, 0x46, 0x91, 0x54, 0x5e, 0x94, 0x49, 0x45, 0x3e, 0x2e, 0xf6, 0x22, 0xed, 0xb4,
	0xe7, 0xdb, 0x74, 0x70, 0x22, 0xab, 0x48, 0x24, 0x37, 0xa0, 0xa4, 0x77, 0x5c, 0x1a, 0x4f, 0x7c,
	0xa7, 0x94, 0x7b, 0xd1, 0x71, 0x69, 0x7a, 0xab, 0x82, 0x4e, 0xff, 0x68, 0x87, 0x03, 0xc8, 0x9b,
	0x00, 0x77, 0x3b, 0x3b, 0xf4, 0x76, 0xe0, 0x77, 0xda, 0xf1, 0x28, 0x48, 0xeb, 0x45, 0xda, 0xb9,
	0xfd, 0xce, 0x0e, 0x0d, 0x3c, 0xca, 0x68, 0x68, 0x34, 0x11, 0xa9, 0xae, 0x9f, 0xb2, 0xd4, 0xff,
	0x9a, 0x83, 0x22, 0x17, 0x45, 0x5e, 0x81, 0x4a, 0xfc, 0x0a, 0x12, 0x9b, 0xed, 0x0c, 0x2f, 0x60,
	0x82, 0x18, 0xa8, 0x8e, 0x73, 0x13, 0x4a, 0x72, 0x05, 0x4a, 0xdb, 0x34, 0xd8, 0x89, 0x2d, 0x88,
	0x63, 0xa8, 0x03, 0x0e, 0x50, 0xf7, 0x8a, 0x14, 0x9c, 0xf4, 0xbd, 0x3d, 0x1a, 0xc4, 0x73, 0x70,
	0x24, 0x7d, 0xc4, 0x01, 0x2a, 0x29, 0x52, 0x90, 0x25, 0x18, 0x5f, 0xb1, 0x44, 0x04, 0x2b, 0xa2,
	0x5c, 0xac, 0x7a, 0x4d, 0x6b, 0x20, 0x4c, 0x49, 0xaa, 0xfa, 0xf3, 0x50, 0x49, 0xee, 0x15, 0x99,
	0x85, 0x12, 0xfe, 0x10, 0xd1, 0x40, 0x17, 0xff, 0x60, 0xaa, 0x78, 0x18, 0x1e, 0xef, 0xb7, 0x8f,
	0x43, 0x53, 0x05, 0x57, 0x6c, 0xa4, 0x8e, 0xee, 0xf3, 0x12, 0x40, 0x4a, 0x4c, 0x28, 0x4c, 0xdd,
	0x5f, 0x5f, 0x5b, 0x5d, 0xb7, 0xa9, 0xc7, 0x1c, 0xe6, 0xd0, 0x21, 0xdd, 0xf4, 0xcd, 0xc7, 0x8c,
	0x06, 0x9e, 0xe9, 0x4a, 0x9a, 0x6e, 0xe3, 0x79, 0xb9, 0xc0, 0x59, 0xdf, 0xb1, 0x2d, 0xc3, 0x49,
	0x58, 0xd5, 0x40, 0x95, 0x15, 0xca, 0x97, 0xd9, 0x5c, 0xb9, 0xb7, 0xa1, 0x2c, 0x93, 0x1f, 0x7d,
	0x99, 0xd0, 0x6c, 0xb9, 0x87, 0x2c, 0x93, 0x15, 0x4a, 0xf6, 0x61, 0xfa, 0x36, 0x16, 0x74, 0xca,
	0x42, 0x85, 0x23, 0x17, 0xba, 0x28, 0x17, 0x3a, 0x27, 0x8a, 0xc1, 0xe1, 0x4b, 0x0d, 0x08, 0x4e,
	0x07, 0xb0, 0xc5, 0x23, 0x07, 0xb0, 0x1f, 0xe4, 0x60, 0x6c, 0x2b, 0x30, 0x1d, 0x16, 0xca, 0x93,
	0x3b, 0x24, 0x82, 0xbc, 0x2b, 0x23, 0xc8, 0x2b, 0xdf, 0xb0, 0x2c, 0x15, 0xb2, 0x79, 0xc1, 0xcd,
	0xf0, 0x97, 0x5a, 0x70, 0x0b, 0x1c, 0xb9, 0x0d, 0x63, 0x9b, 0xcc, 0x64, 0x9d, 0xf8, 0x43, 0x07,
	0xa5, 0x24, 0xc0, 0x80, 0x28, 0x90, 0x8d, 0x9a, 0xb4, 0xc5, 0x74, 0x88, 0xff, 0xab, 0x82, 0x04,
	0x85, 0xfa, 0x61, 0xc9, 0xf8, 0x7f, 0xf6, 0x61, 0x09, 0xb9, 0x0f, 0x95, 0xd5, 0x80, 0x9a, 0x8c,
	0xda, 0x8d, 0xae, 0x1c, 0xf9, 0x2a, 0x79, 0x32, 0x41, 0x29, 0xef, 0x5b, 0x02, 0x64, 0xa8, 0x8f,
	0xb9, 0x7a, 0x2a, 0xa3, 0xfe, 0x51, 0x0e, 0xa6, 0xfb, 0x8f, 0x97, 0xbc, 0x01, 0xd5, 0x55, 0x91,
	0x35, 0x7c, 0xde, 0x09, 0xe7, 0xd2, 0x8e, 0xd6, 0x8a, 0xc1, 0x46, 0xe6, 0x0b, 0x0d, 0x95, 0x9c,
	0x2c, 0x43, 0x99, 0x5f, 0x17, 0x2f, 0x7d, 0x0c, 0xc0, 0x68, 0xd0, 0x91, 0x30, 0x75, 0xfa, 0x1c,
	0xd3, 0x29, 0xb7, 0xed, 0x2f, 0x79, 0xa8, 0x2a, 0xe6, 0x25, 0x57, 0xa0, 0xbc, 0x1e, 0x6e, 0xf8,
	0xd6, 0x3e, 0xb5, 0x65, 0xa9, 0x82, 0x5f, 0xfa, 0x38, 0xa1, 0xe1, 0x22, 0x50, 0x4f, 0xd0, 0xa4,
	0x01, 0x93, 0xe2, 0xd7, 0x3d, 0x1a, 0x86, 0x66, 0x33, 0x5e, 0xfd, 0x7c, 0x2f, 0xd2, 0x6a, 0x82,
	0xd8, 0x68, 0x09, 0x8c, 0xb2, 0x87, 0x2c, 0x0b, 0xf9, 0x31, 0x80, 0x00, 0xf0, 0x13, 0x19, 0xe1,
	0xc9, 0x3c, 0xbe, 0x72, 0xa7, 0xe5, 0x02, 0x3c, 0xe9, 0xf7, 0x4d, 0x96, 0x15, 0x81, 0xf8, 0xcd,
	0x84, 0x6f, 0xed, 0x8f, 0xfe, 0x9d, 0x51, 0xfa, 0xcd, 0x84, 0x6f, 0xed, 0x1b, 0xc3, 0x47, 0xd7,
	0xaa, 0xc8, 0xfa, 0x97, 0x39, 0xc5, 0x45, 0xc8, 0xbb, 0x50, 0x49, 0x8e, 0x46, 0x56, 0xb6, 0x73,
	0xea, 0xd3, 0xa0, 0x44, 0xe9, 0x74, 0xb7, 0x71, 0x4e, 0x96, 0x17, 0x33, 0xc9, 0x19, 0x67, 0x3c,
	0x26, 0x06, 0x92, 0xb7, 0xa0, 0x88, 0xb6, 0x39, 0x7a, 0xe2, 0x1e, 0x87, 0xe5, 0x22, 0x37, 0x0a,
	0xee, 0x14, 0x39, 0xc9, 0x35, 0x28, 0xf2, 0x83, 0x97, 0xd6, 0x3d, 0x95, 0x0d, 0xc9, 0x7c, 0x2b,
	0x49, 0x3c, 0xe6, 0x3e, 0xa3, 0x23, 0xb1, 0xe2, 0x21, 0x1e, 0x4c, 0xa8, 0x1b, 0xe7, 0xa9, 0x49,
	0x69, 0xb7, 0xcb, 0xf1, 0x6b, 0x95, 0x6c, 0xb2, 0xe7, 0xf0, 0xd3, 0x22, 0xe1, 0x09, 0x63, 0xbd,
	0x48, 0xcb, 0x3b, 0xb6, 0x9e, 0x5f, 0x5f, 0x23, 0x97, 0xa1, 0x1c, 0xfb, 0xbb, 0xfa, 0xca, 0x2c,
	0x23, 0x59, 0x57, 0x4f, 0xb0, 0xf5, 0x17, 0x61, 0x5c, 0x6e, 0xec, 0xd9, 0x9f, 0x72, 0xd5, 0x3f,
	0xcc, 0xc3, 0x49, 0x9d, 0xf2, 0x1c, 0x26, 0x5f, 0x6e, 0xbf, 0x93, 0xcf, 0x8c, 0x19, 0x0d, 0x0f,
	0x4f, 0xa0, 0xf5, 0x3f, 0xe6, 0x60, 0x66, 0x08, 0xed, 0xb7, 0x99, 0x85, 0x92, 0xeb, 0x50, 0x59,
	0x73, 0x4c, 0x77, 0xc5, 0xb6, 0x83, 0xb8, 0x6c, 0xc2, 0xb9, 0x8e, 0xed, 0x98, 0x2e, 0x7e, 0x4a,
	0x90, 0x29, 0xb5, 0x12, 0x52, 0xf2, 0xbf, 0xd2, 0x35, 0x0a, 0x89, 0x71, 0xe3, 0x87, 0x4c, 0x10,
	0x7b, 0x4a, 0x9f, 0x31, 0xeb, 0xbf, 0xcb, 0x03, 0x11, 0x40, 0xe9, 0x5d, 0x8e, 0x7f, 0xac, 0x9f,
	0x73, 0x1a, 0x99, 0x03, 0x5c, 0x50, 0x9e, 0x1b, 0xfb, 0x94, 0x1c, 0xa9, 0x08, 0xfa, 0x28, 0x0f,
	0x73, 0xc3, 0x19, 0xbf, 0xd5, 0x81, 0x5e, 0x85, 0x0a, 0x0e, 0x41, 0x95, 0x17, 0x63, 0x9c, 0xb4,
	0x8a, 0x89, 0x29, 0xd2, 0xa7, 0x04, 0x64, 0x17, 0x26, 0x37, 0xcc, 0x90, 0xdd, 0xa1, 0x66, 0xc0,
	0x76, 0xa8, 0xc9, 0x46, 0x88, 0xcb, 0xc9, 0xc7, 0x52, 0xf8, 0xad, 0xd9, 0x5e, 0xcc, 0xd9, 0xff,
	0xb1, 0x54, 0x46, 0x6c, 0xe2, 0x2e, 0xc5, 0xa3, 0xdd, 0xa5, 0x31, 0xfb, 0xe4, 0x1f, 0x17, 0x4e,
	0x3c, 0xf9, 0xea, 0x42, 0xee, 0xb3, 0xaf, 0x2e, 0xe4, 0xfe, 0xfe, 0xd5, 0x85, 0xdc, 0xa7, 0xff,
	0xbc, 0x70, 0x62, 0x67, 0x0c, 0xb7, 0x72, 0xed, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x63, 0x1c,
	0xb2, 0x05, 0x6d, 0x2b, 0x00, 0x00,
}
