// +build dynamodb

/*
Copyright 2018 Gravitational, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*/

package dynamoevents

import (
	"fmt"
	"testing"
	"time"

	"github.com/gravitational/teleport/lib/events/test"
	"github.com/gravitational/teleport/lib/utils"

	"github.com/gravitational/trace"
	"github.com/jonboulle/clockwork"
	"github.com/pborman/uuid"
	"gopkg.in/check.v1"
)

func TestDynamoevents(t *testing.T) { check.TestingT(t) }

type DynamoeventsSuite struct {
	log *Log
	test.EventsSuite
}

var _ = check.Suite(&DynamoeventsSuite{})

func (s *DynamoeventsSuite) SetUpSuite(c *check.C) {
	utils.InitLoggerForTests()
	fakeClock := clockwork.NewFakeClock()
	log, err := New(Config{
		Region:    "us-west-1",
		Tablename: fmt.Sprintf("teleport-test-%v", uuid.New()),
		Clock:     fakeClock,
	})
	c.Assert(err, check.IsNil)
	s.log = log
	s.EventsSuite.Log = log
	s.EventsSuite.Clock = fakeClock
	s.EventsSuite.QueryDelay = time.Second
}

func (s *DynamoeventsSuite) SetUpTest(c *check.C) {
	err := s.log.deleteAllItems()
	c.Assert(err, check.IsNil)
}

func (s *DynamoeventsSuite) TestSessionEventsCRUD(c *check.C) {
	s.SessionEventsCRUD(c)
}

func (s *DynamoeventsSuite) TearDownSuite(c *check.C) {
	if s.log != nil {
		if err := s.log.deleteTable(s.log.Tablename, true); err != nil {
			c.Fatalf("Failed to delete table: %#v", trace.DebugReport(err))
		}
	}
}
