/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Tue Jul 14 19:02:34 2020

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_21 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 4301, "epsg", 4301,
        "Tokyo", 1, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-146.414,507.337,68");
    add_proj4text (p, 1,
        "0.507,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 1,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 4,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 5,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4301\"");
    add_srs_wkt (p, 6,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4302, "epsg", 4302,
        "Trinidad 1903", 1, 1,
        "Clarke 1858", "Greenwich",
        "Trinidad_1903", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378293.645208759 +b=6356617.987679838 ");
    add_proj4text (p, 1,
        "+towgs84=-61.702,284.488,472.052,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Trinidad 1903\",DATUM[\"Trinidad_1903\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Clarke 1858\",6378293.64520876,294.260676369261,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7007\"]],AUTHORITY[\"EPSG\",\"6302\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4302\"]]");
    p = add_epsg_def_ex (filter, first, last, 4303, "epsg", 4303,
        "TC(1948)", 1, 1,
        "Helmert 1906", "Greenwich",
        "Trucial_Coast_1948", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=helmert +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"TC(1948)\",DATUM[\"Trucial_Coast_1948\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Helmert 1906\",6378200,298.3,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "20\"]],AUTHORITY[\"EPSG\",\"6303\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4303\"]]");
    p = add_epsg_def_ex (filter, first, last, 4304, "epsg", 4304,
        "Voirol 1875", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Voirol_1875", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-73,-247,");
    add_proj4text (p, 1,
        "227,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Voirol 1875\",DATUM[\"Voirol_1875\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "Clarke 1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6304\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4304\"]]");
    p = add_epsg_def_ex (filter, first, last, 4306, "epsg", 4306,
        "Bern 1938", 1, 1,
        "Bessel 1841", "Greenwich",
        "Bern_1938", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Bern 1938\",DATUM[\"Bern_1938\",SPHEROID[\"Bess");
    add_srs_wkt (p, 1,
        "el 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "004\"]],AUTHORITY[\"EPSG\",\"6306\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 5,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4306\"]]");
    p = add_epsg_def_ex (filter, first, last, 4307, "epsg", 4307,
        "Nord Sahara 1959", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-209.3622,-87.8162,");
    add_proj4text (p, 1,
        "404.6198,0.0046,3.4784,0.5805,-1.4547 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Nord Sahara 1959\",DATUM[\"Nord_Sahara_1959\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6307\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4307\"]]");
    p = add_epsg_def_ex (filter, first, last, 4308, "epsg", 4308,
        "RT38", 1, 1,
        "Bessel 1841", "Greenwich",
        "Stockholm_1938", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RT38\",DATUM[\"Stockholm_1938\",SPHEROID[\"Bess");
    add_srs_wkt (p, 1,
        "el 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "004\"]],AUTHORITY[\"EPSG\",\"6308\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 5,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4308\"]]");
    p = add_epsg_def_ex (filter, first, last, 4309, "epsg", 4309,
        "Yacare", 1, 1,
        "International 1924", "Greenwich",
        "Yacare", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-155,171,37,0,0,0,0 +");
    add_proj4text (p, 1,
        "no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Yacare\",DATUM[\"Yacare\",SPHEROID[\"Internatio");
    add_srs_wkt (p, 1,
        "nal 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"6309\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 4,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 5,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4309\"]]");
    p = add_epsg_def_ex (filter, first, last, 4310, "epsg", 4310,
        "Yoff", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Yoff", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-30,190,8");
    add_proj4text (p, 1,
        "9,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Yoff\",DATUM[\"Yoff\",SPHEROID[\"Clarke 1880 (I");
    add_srs_wkt (p, 1,
        "GN)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "11\"]],AUTHORITY[\"EPSG\",\"6310\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4310\"]]");
    p = add_epsg_def_ex (filter, first, last, 4311, "epsg", 4311,
        "Zanderij", 1, 1,
        "International 1924", "Greenwich",
        "Zanderij", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-265,120,-358,0,0,0,0");
    add_proj4text (p, 1,
        " +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Zanderij\",DATUM[\"Zanderij\",SPHEROID[\"Intern");
    add_srs_wkt (p, 1,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"6311\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 4,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 5,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4311");
    add_srs_wkt (p, 6,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 4312, "epsg", 4312,
        "MGI", 1, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=577.326,90.129,463.");
    add_proj4text (p, 1,
        "919,5.137,1.474,5.297,2.4232 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MGI\",DATUM[\"Militar-Geographische_Institut\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4312\"]]");
    p = add_epsg_def_ex (filter, first, last, 4313, "epsg", 4313,
        "Belge 1972", 1, 1,
        "International 1924", "Greenwich",
        "Reseau_National_Belge_1972", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=-106.8686,52.2978,-10");
    add_proj4text (p, 1,
        "3.7239,0.3366,-0.457,1.8422,-1.2747 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Belge 1972\",DATUM[\"Reseau_National_Belge_1972");
    add_srs_wkt (p, 1,
        "\",SPHEROID[\"International 1924\",6378388,297,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6313\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4313\"]]");
    p = add_epsg_def_ex (filter, first, last, 4314, "epsg", 4314,
        "DHDN", 1, 1,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=598.1,73.7,418.2,0.");
    add_proj4text (p, 1,
        "202,0.045,-2.455,6.7 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY");
    add_srs_wkt (p, 2,
        "[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6314\"]],PRIME");
    add_srs_wkt (p, 3,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"4314\"]]");
    p = add_epsg_def_ex (filter, first, last, 4315, "epsg", 4315,
        "Conakry 1905", 1, 1,
        "Clarke 1880 (IGN)", "Greenwich",
        "Conakry_1905", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-23,259,-");
    add_proj4text (p, 1,
        "9,0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Conakry 1905\",DATUM[\"Conakry_1905\",SPHEROID[");
    add_srs_wkt (p, 1,
        "\"Clarke 1880 (IGN)\",6378249.2,293.466021293627,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6315\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4315\"]]");
    p = add_epsg_def_ex (filter, first, last, 4316, "epsg", 4316,
        "Dealul Piscului 1930", 1, 1,
        "International 1924", "Greenwich",
        "Dealul_Piscului_1930", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +towgs84=103.25,-100.4,-307.19");
    add_proj4text (p, 1,
        ",0,0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Dealul Piscului 1930\",DATUM[\"Dealul_Piscului_");
    add_srs_wkt (p, 1,
        "1930\",SPHEROID[\"International 1924\",6378388,297,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6316\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4316\"]]");
    p = add_epsg_def_ex (filter, first, last, 4317, "epsg", 4317,
        "Pulkovo 1942(58)", 1, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=krass +towgs84=28,-121,-77,0,0,0,0 ");
    add_proj4text (p, 1,
        "+no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPS");
    add_srs_wkt (p, 2,
        "G\",\"7024\"]],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 3,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 4,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 5,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4179\"]]");
    p = add_epsg_def_ex (filter, first, last, 4318, "epsg", 4318,
        "NGN", 1, 1,
        "WGS 84", "Greenwich",
        "National_Geodetic_Network", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=-3.2,-5.7,2.8,0,0,0,");
    add_proj4text (p, 1,
        "0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NGN\",DATUM[\"National_Geodetic_Network\",SPHER");
    add_srs_wkt (p, 1,
        "OID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 2,
        "\"7030\"]],AUTHORITY[\"EPSG\",\"6318\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 4,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 5,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4318\"]]");
    p = add_epsg_def_ex (filter, first, last, 4319, "epsg", 4319,
        "KUDAMS", 1, 1,
        "GRS 1980", "Greenwich",
        "Kuwait_Utility", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=-20.8,11.3,2.4,0,0,0");
    add_proj4text (p, 1,
        ",0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"KUDAMS\",DATUM[\"Kuwait_Utility\",SPHEROID[\"GR");
    add_srs_wkt (p, 1,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 2,
        "\"]],AUTHORITY[\"EPSG\",\"6319\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 3,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 4,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 5,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4319\"]]");
    p = add_epsg_def_ex (filter, first, last, 4322, "epsg", 4322,
        "WGS 72", 1, 1,
        "WGS 72", "Greenwich",
        "World_Geodetic_System_1972", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.554,0.");
    add_proj4text (p, 1,
        "2263 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"WGS 72\",DATUM[\"World_Geodetic_System_1972\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"WGS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 2,
        "043\"]],AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 4,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 5,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4322\"]]");
    p = add_epsg_def_ex (filter, first, last, 4324, "epsg", 4324,
        "WGS 72BE", 1, 1,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0");
    add_proj4text (p, 1,
        ".38 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"WGS 72BE\",DATUM[\"WGS_72_Transit_Broadcast_Eph");
    add_srs_wkt (p, 1,
        "emeris\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7043\"]],AUTHORITY[\"EPSG\",\"6324\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4324\"]]");
    p = add_epsg_def_ex (filter, first, last, 4327, "epsg", 4327,
        "WGS 84 (3D) (deprecated)", 1, 1,
        "WGS 84", "Greenwich",
        "WGS_1984", "none", "degree minute second hemisphere",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +datum=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 84 (3D)\",DATUM[\"World Geodetic System 19");
    add_srs_wkt (p, 1,
        "84\",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUN");
    add_srs_wkt (p, 2,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 3,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 4,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree ");
    add_srs_wkt (p, 5,
        "minute second hemisphere\",0.0174532925199433]],AXIS[\"g");
    add_srs_wkt (p, 6,
        "eodetic longitude (Long)\",east,ORDER[2],ANGLEUNIT[\"deg");
    add_srs_wkt (p, 7,
        "ree minute second hemisphere\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 8,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 9,
        "re\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"World (by count");
    add_srs_wkt (p, 10,
        "ry)\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",4329]]");
    p = add_epsg_def_ex (filter, first, last, 4329, "epsg", 4329,
        "WGS 84", 1, 1,
        "WGS 84", "Greenwich",
        "WGS_1984", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +datum=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"WGS 84\",DATUM[\"World Geodetic System 1984\",");
    add_srs_wkt (p, 1,
        "ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"");
    add_srs_wkt (p, 2,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 3,
        ",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic ");
    add_srs_wkt (p, 4,
        "latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433]],AXIS[\"geodetic longitude (Lon)\",east");
    add_srs_wkt (p, 6,
        ",ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 7,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 8,
        "re\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"World (by count");
    add_srs_wkt (p, 9,
        "ry)\"],BBOX[-90,-180,90,180]],ID[\"EPSG\",4979]]");
    p = add_epsg_def_ex (filter, first, last, 4339, "epsg", 4339,
        "Australian Antarctic", 1, 1,
        "GRS 1980", "Greenwich",
        "Australian_Antarctic_Datum_1998", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Australian Antarctic\",DATUM[\"Australian Anta");
    add_srs_wkt (p, 1,
        "rctic Datum 1998\",ELLIPSOID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 2,
        "7222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 3,
        ",ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoida");
    add_srs_wkt (p, 4,
        "l,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANG");
    add_srs_wkt (p, 5,
        "LEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic l");
    add_srs_wkt (p, 6,
        "ongitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01");
    add_srs_wkt (p, 7,
        "74532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDE");
    add_srs_wkt (p, 8,
        "R[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],A");
    add_srs_wkt (p, 9,
        "REA[\"Antarctica - Australian sector\"],BBOX[-90,45,-60,");
    add_srs_wkt (p, 10,
        "160]],ID[\"EPSG\",4931]]");
    p = add_epsg_def_ex (filter, first, last, 4341, "epsg", 4341,
        "EST97", 1, 1,
        "GRS 1980", "Greenwich",
        "Estonia_1997", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"EST97\",DATUM[\"Estonia 1997\",ELLIPSOID[\"GRS");
    add_srs_wkt (p, 1,
        " 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],");
    add_srs_wkt (p, 2,
        "PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 3,
        "199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat");
    add_srs_wkt (p, 4,
        ")\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANG");
    add_srs_wkt (p, 6,
        "LEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoida");
    add_srs_wkt (p, 7,
        "l height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAG");
    add_srs_wkt (p, 8,
        "E[SCOPE[\"unknown\"],AREA[\"Estonia\"],BBOX[57.52,20.37,");
    add_srs_wkt (p, 9,
        "60,28.2]],ID[\"EPSG\",4935]]");
    p = add_epsg_def_ex (filter, first, last, 4343, "epsg", 4343,
        "CHTRF95", 1, 1,
        "GRS 1980", "Greenwich",
        "Swiss_Terrestrial_Reference_Frame_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"CHTRF95\",DATUM[\"Swiss Terrestrial Reference ");
    add_srs_wkt (p, 1,
        "Frame 1995\",ELLIPSOID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 2,
        "1,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLE");
    add_srs_wkt (p, 3,
        "UNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],A");
    add_srs_wkt (p, 4,
        "XIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433]],AXIS[\"geodetic longitu");
    add_srs_wkt (p, 6,
        "de (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 7,
        "25199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],L");
    add_srs_wkt (p, 8,
        "ENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"");
    add_srs_wkt (p, 9,
        "Europe - Liechtenstein and Switzerland\"],BBOX[45.82,5.9");
    add_srs_wkt (p, 10,
        "6,47.81,10.49]],ID[\"EPSG\",4933]]");
    p = add_epsg_def_ex (filter, first, last, 4345, "epsg", 4345,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ETRS89\",DATUM[\"European Terrestrial Referenc");
    add_srs_wkt (p, 1,
        "e System 1989\",ELLIPSOID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "2101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,AN");
    add_srs_wkt (p, 3,
        "GLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3");
    add_srs_wkt (p, 4,
        "],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEU");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic long");
    add_srs_wkt (p, 6,
        "itude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 7,
        "32925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3");
    add_srs_wkt (p, 8,
        "],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA");
    add_srs_wkt (p, 9,
        "[\"Europe - ETRF by country\"],BBOX[32.88,-16.1,84.17,40");
    add_srs_wkt (p, 10,
        ".18]],ID[\"EPSG\",4937]]");
    p = add_epsg_def_ex (filter, first, last, 4347, "epsg", 4347,
        "GDA94", 1, 1,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"GDA94\",DATUM[\"Geocentric Datum of Australia ");
    add_srs_wkt (p, 1,
        "1994\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENG");
    add_srs_wkt (p, 2,
        "THUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Austral");
    add_srs_wkt (p, 9,
        "ia - GDA\"],BBOX[-60.56,93.41,-8.47,173.35]],ID[\"EPSG\"");
    add_srs_wkt (p, 10,
        ",4939]]");
    p = add_epsg_def_ex (filter, first, last, 4349, "epsg", 4349,
        "Hartebeesthoek94", 1, 1,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Hartebeesthoek94\",DATUM[\"Hartebeesthoek94\",");
    add_srs_wkt (p, 1,
        "ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"");
    add_srs_wkt (p, 2,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 3,
        ",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic ");
    add_srs_wkt (p, 4,
        "latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433]],AXIS[\"geodetic longitude (Lon)\",east");
    add_srs_wkt (p, 6,
        ",ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 7,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 8,
        "re\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Africa - South ");
    add_srs_wkt (p, 9,
        "Africa, Lesotho and Eswatini.\"],BBOX[-50.32,13.33,-22.1");
    add_srs_wkt (p, 10,
        "3,42.85]],ID[\"EPSG\",4941]]");
    p = add_epsg_def_ex (filter, first, last, 4351, "epsg", 4351,
        "IRENET95", 1, 1,
        "GRS 1980", "Greenwich",
        "IRENET95", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IRENET95\",DATUM[\"IRENET95\",ELLIPSOID[\"GRS ");
    add_srs_wkt (p, 1,
        "1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],P");
    add_srs_wkt (p, 2,
        "RIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 3,
        "99433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)");
    add_srs_wkt (p, 4,
        "\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGL");
    add_srs_wkt (p, 6,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal");
    add_srs_wkt (p, 7,
        " height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE");
    add_srs_wkt (p, 8,
        "[SCOPE[\"unknown\"],AREA[\"Europe - Ireland (Republic an");
    add_srs_wkt (p, 9,
        "d Ulster) - onshore\"],BBOX[51.39,-10.56,55.43,-5.34]],I");
    add_srs_wkt (p, 10,
        "D[\"EPSG\",4943]]");
    p = add_epsg_def_ex (filter, first, last, 4353, "epsg", 4353,
        "JGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"JGD2000\",DATUM[\"Japanese Geodetic Datum 2000");
    add_srs_wkt (p, 1,
        "\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUN");
    add_srs_wkt (p, 2,
        "IT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"deg");
    add_srs_wkt (p, 3,
        "ree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geod");
    add_srs_wkt (p, 4,
        "etic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\",");
    add_srs_wkt (p, 6,
        "east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],");
    add_srs_wkt (p, 7,
        "AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"");
    add_srs_wkt (p, 8,
        "metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Japan\"],BBO");
    add_srs_wkt (p, 9,
        "X[17.09,122.38,46.05,157.65]],ID[\"EPSG\",4947]]");
    p = add_epsg_def_ex (filter, first, last, 4355, "epsg", 4355,
        "LKS94", 1, 1,
        "GRS 1980", "Greenwich",
        "Lithuania_1994_ETRS89", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"LKS94\",DATUM[\"Lithuania 1994 (ETRS89)\",ELLI");
    add_srs_wkt (p, 1,
        "PSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"me");
    add_srs_wkt (p, 2,
        "tre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0");
    add_srs_wkt (p, 3,
        ".0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic la");
    add_srs_wkt (p, 4,
        "titude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433]],AXIS[\"geodetic longitude (Lon)\",east,O");
    add_srs_wkt (p, 6,
        "RDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"");
    add_srs_wkt (p, 7,
        "ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 8,
        ",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Lithuania\"],BBOX[5");
    add_srs_wkt (p, 9,
        "3.89,19.02,56.45,26.82]],ID[\"EPSG\",4951]]");
    p = add_epsg_def_ex (filter, first, last, 4357, "epsg", 4357,
        "Moznet", 1, 1,
        "WGS 84", "Greenwich",
        "Moznet_ITRF94", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Moznet\",DATUM[\"Moznet (ITRF94)\",ELLIPSOID[\"");
    add_srs_wkt (p, 1,
        "WGS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]]");
    add_srs_wkt (p, 2,
        ",PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 3,
        "5199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (La");
    add_srs_wkt (p, 4,
        "t)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],AN");
    add_srs_wkt (p, 6,
        "GLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoid");
    add_srs_wkt (p, 7,
        "al height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USA");
    add_srs_wkt (p, 8,
        "GE[SCOPE[\"unknown\"],AREA[\"Mozambique\"],BBOX[-27.71,3");
    add_srs_wkt (p, 9,
        "0.21,-10.09,43.03]],ID[\"EPSG\",4953]]");
    p = add_epsg_def_ex (filter, first, last, 4359, "epsg", 4359,
        "NAD83(CSRS)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(CSRS)\",DATUM[\"NAD83 Canadian Spatial R");
    add_srs_wkt (p, 1,
        "eference System\",ELLIPSOID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal");
    add_srs_wkt (p, 4,
        ",3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGL");
    add_srs_wkt (p, 5,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lo");
    add_srs_wkt (p, 6,
        "ngitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 7,
        "4532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER");
    add_srs_wkt (p, 8,
        "[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AR");
    add_srs_wkt (p, 9,
        "EA[\"Canada\"],BBOX[40.04,-141.01,86.46,-47.74]],ID[\"EP");
    add_srs_wkt (p, 10,
        "SG\",4955]]");
    p = add_epsg_def_ex (filter, first, last, 4361, "epsg", 4361,
        "NAD83(HARN)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(HARN)\",DATUM[\"NAD83 (High Accuracy Ref");
    add_srs_wkt (p, 1,
        "erence Network)\",ELLIPSOID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal");
    add_srs_wkt (p, 4,
        ",3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGL");
    add_srs_wkt (p, 5,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lo");
    add_srs_wkt (p, 6,
        "ngitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 7,
        "4532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER");
    add_srs_wkt (p, 8,
        "[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AR");
    add_srs_wkt (p, 9,
        "EA[\"USA - HARN\"],BBOX[-14.59,144.58,71.4,-64.51]],ID[\"");
    add_srs_wkt (p, 10,
        "EPSG\",4957]]");
    p = add_epsg_def_ex (filter, first, last, 4363, "epsg", 4363,
        "NZGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NZGD2000\",DATUM[\"New Zealand Geodetic Datum ");
    add_srs_wkt (p, 1,
        "2000\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENG");
    add_srs_wkt (p, 2,
        "THUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"New Zea");
    add_srs_wkt (p, 9,
        "land\"],BBOX[-55.95,160.6,-25.88,-171.2]],ID[\"EPSG\",49");
    add_srs_wkt (p, 10,
        "59]]");
    p = add_epsg_def_ex (filter, first, last, 4365, "epsg", 4365,
        "POSGAR 98", 1, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"POSGAR 98\",DATUM[\"Posiciones Geodesicas Arge");
    add_srs_wkt (p, 1,
        "ntinas 1998\",ELLIPSOID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
        "01,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGL");
    add_srs_wkt (p, 3,
        "EUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],");
    add_srs_wkt (p, 4,
        "AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433]],AXIS[\"geodetic longit");
    add_srs_wkt (p, 6,
        "ude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 7,
        "925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],");
    add_srs_wkt (p, 8,
        "LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"");
    add_srs_wkt (p, 9,
        "Argentina\"],BBOX[-58.41,-73.59,-21.78,-52.63]],ID[\"EPS");
    add_srs_wkt (p, 10,
        "G\",4961]]");
    p = add_epsg_def_ex (filter, first, last, 4367, "epsg", 4367,
        "REGVEN", 1, 1,
        "GRS 1980", "Greenwich",
        "Red_Geodesica_Venezolana", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"REGVEN\",DATUM[\"Red Geodesica Venezolana\",EL");
    add_srs_wkt (p, 1,
        "LIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"");
    add_srs_wkt (p, 2,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 3,
        ",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic ");
    add_srs_wkt (p, 4,
        "latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433]],AXIS[\"geodetic longitude (Lon)\",east");
    add_srs_wkt (p, 6,
        ",ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 7,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 8,
        "re\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Venezuela\"],BB");
    add_srs_wkt (p, 9,
        "OX[0.64,-73.38,16.75,-58.95]],ID[\"EPSG\",4963]]");
    p = add_epsg_def_ex (filter, first, last, 4369, "epsg", 4369,
        "RGF93", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_1993", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGF93\",DATUM[\"Reseau Geodesique Francais 199");
    add_srs_wkt (p, 1,
        "3\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHU");
    add_srs_wkt (p, 2,
        "NIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"de");
    add_srs_wkt (p, 3,
        "gree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geo");
    add_srs_wkt (p, 4,
        "detic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\"");
    add_srs_wkt (p, 6,
        ",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[");
    add_srs_wkt (p, 8,
        "\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"France\"],");
    add_srs_wkt (p, 9,
        "BBOX[41.15,-9.86,51.56,10.38]],ID[\"EPSG\",4965]]");
    p = add_epsg_def_ex (filter, first, last, 4371, "epsg", 4371,
        "RGFG95", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_Francais_Guyane_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGFG95\",DATUM[\"Reseau Geodesique Francais Gu");
    add_srs_wkt (p, 1,
        "yane 1995\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 2,
        ",LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEU");
    add_srs_wkt (p, 3,
        "NIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AX");
    add_srs_wkt (p, 4,
        "IS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433]],AXIS[\"geodetic longitud");
    add_srs_wkt (p, 6,
        "e (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 7,
        "5199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LE");
    add_srs_wkt (p, 8,
        "NGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"F");
    add_srs_wkt (p, 9,
        "rench Guiana\"],BBOX[2.11,-54.61,8.88,-49.45]],ID[\"EPSG");
    add_srs_wkt (p, 10,
        "\",4967]]");
    p = add_epsg_def_ex (filter, first, last, 4373, "epsg", 4373,
        "RGR92", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_la_Reunion_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGR92\",DATUM[\"Reseau Geodesique de la Reunio");
    add_srs_wkt (p, 1,
        "n 1992\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LE");
    add_srs_wkt (p, 2,
        "NGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT");
    add_srs_wkt (p, 3,
        "[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[");
    add_srs_wkt (p, 4,
        "\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433]],AXIS[\"geodetic longitude (");
    add_srs_wkt (p, 6,
        "Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 7,
        "9433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGT");
    add_srs_wkt (p, 8,
        "HUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"Reun");
    add_srs_wkt (p, 9,
        "ion\"],BBOX[-24.72,51.83,-18.28,58.24]],ID[\"EPSG\",4971");
    add_srs_wkt (p, 10,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 4375, "epsg", 4375,
        "SIRGAS 1995", 1, 1,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_America_del_Sur_1995", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SIRGAS 1995\",DATUM[\"Sistema de Referencia Ge");
    add_srs_wkt (p, 1,
        "ocentrico para America del Sur 1995\",ELLIPSOID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 4,
        "433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)\"");
    add_srs_wkt (p, 5,
        ",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199433]");
    add_srs_wkt (p, 6,
        "],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGLEU");
    add_srs_wkt (p, 7,
        "NIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal h");
    add_srs_wkt (p, 8,
        "eight (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[S");
    add_srs_wkt (p, 9,
        "COPE[\"unknown\"],AREA[\"South America - SIRGAS 1995 by ");
    add_srs_wkt (p, 10,
        "country\"],BBOX[-59.87,-113.21,16.75,-26]],ID[\"EPSG\",4");
    add_srs_wkt (p, 11,
        "975]]");
    p = add_epsg_def_ex (filter, first, last, 4377, "epsg", 4377,
        "SWEREF99", 1, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SWEREF99\",DATUM[\"SWEREF99\",ELLIPSOID[\"GRS ");
    add_srs_wkt (p, 1,
        "1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],P");
    add_srs_wkt (p, 2,
        "RIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 3,
        "99433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)");
    add_srs_wkt (p, 4,
        "\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGL");
    add_srs_wkt (p, 6,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal");
    add_srs_wkt (p, 7,
        " height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE");
    add_srs_wkt (p, 8,
        "[SCOPE[\"unknown\"],AREA[\"Sweden\"],BBOX[54.96,10.03,69");
    add_srs_wkt (p, 9,
        ".07,24.17]],ID[\"EPSG\",4977]]");
    p = add_epsg_def_ex (filter, first, last, 4379, "epsg", 4379,
        "Yemen NGN96", 1, 1,
        "WGS 84", "Greenwich",
        "Yemen_National_Geodetic_Network_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"Yemen NGN96\",DATUM[\"Yemen National Geodetic ");
    add_srs_wkt (p, 1,
        "Network 1996\",ELLIPSOID[\"WGS 84\",6378137,298.25722356");
    add_srs_wkt (p, 2,
        "3,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLE");
    add_srs_wkt (p, 3,
        "UNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3],A");
    add_srs_wkt (p, 4,
        "XIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433]],AXIS[\"geodetic longitu");
    add_srs_wkt (p, 6,
        "de (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 7,
        "25199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],L");
    add_srs_wkt (p, 8,
        "ENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AREA[\"");
    add_srs_wkt (p, 9,
        "Yemen\"],BBOX[8.95,41.08,19,57.96]],ID[\"EPSG\",4981]]");
    p = add_epsg_def_ex (filter, first, last, 4381, "epsg", 4381,
        "RGNC 1991 (deprecated)", 1, 1,
        "International 1924", "Greenwich",
        "Reseau_Geodesique_Nouvelle_Caledonie_1991", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGNC 1991\",DATUM[\"Reseau Geodesique Nouvelle");
    add_srs_wkt (p, 1,
        " Caledonie 1991\",ELLIPSOID[\"International 1924\",63783");
    add_srs_wkt (p, 2,
        "88,297,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal");
    add_srs_wkt (p, 4,
        ",3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGL");
    add_srs_wkt (p, 5,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lo");
    add_srs_wkt (p, 6,
        "ngitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 7,
        "4532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER");
    add_srs_wkt (p, 8,
        "[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"],AR");
    add_srs_wkt (p, 9,
        "EA[\"New Caledonia\"],BBOX[-26.45,156.25,-14.83,174.28]]");
    add_srs_wkt (p, 10,
        ",ID[\"EPSG\",4969]]");
    p = add_epsg_def_ex (filter, first, last, 4383, "epsg", 4383,
        "RRAF 1991 (deprecated)", 1, 1,
        "WGS 84", "Greenwich",
        "Reseau_de_Reference_des_Antilles_Francaises_1991", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RRAF 1991\",DATUM[\"Reseau de Reference des An");
    add_srs_wkt (p, 1,
        "tilles Francaises 1991\",ELLIPSOID[\"WGS 84\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257223563,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 3,
        "\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellips");
    add_srs_wkt (p, 4,
        "oidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1]");
    add_srs_wkt (p, 5,
        ",ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodet");
    add_srs_wkt (p, 6,
        "ic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",");
    add_srs_wkt (p, 7,
        "0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",up,");
    add_srs_wkt (p, 8,
        "ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown\"");
    add_srs_wkt (p, 9,
        "],AREA[\"Caribbean - French Antilles\"],BBOX[14.08,-63.6");
    add_srs_wkt (p, 10,
        "6,18.54,-57.52]],ID[\"EPSG\",4973]]");
    p = add_epsg_def_ex (filter, first, last, 4386, "epsg", 4386,
        "ISN93", 1, 1,
        "GRS 1980", "Greenwich",
        "Islands_Net_1993", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ISN93\",DATUM[\"Islands Net 1993\",ELLIPSOID[\"");
    add_srs_wkt (p, 1,
        "GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]");
    add_srs_wkt (p, 2,
        "]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 3,
        "925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (");
    add_srs_wkt (p, 4,
        "Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],");
    add_srs_wkt (p, 6,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipso");
    add_srs_wkt (p, 7,
        "idal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],U");
    add_srs_wkt (p, 8,
        "SAGE[SCOPE[\"unknown\"],AREA[\"Iceland\"],BBOX[59.96,-30");
    add_srs_wkt (p, 9,
        ".87,69.59,-5.55]],ID[\"EPSG\",4945]]");
    p = add_epsg_def_ex (filter, first, last, 4388, "epsg", 4388,
        "LKS92", 1, 1,
        "GRS 1980", "Greenwich",
        "Latvia_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"LKS92\",DATUM[\"Latvia 1992\",ELLIPSOID[\"GRS ");
    add_srs_wkt (p, 1,
        "1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",1]]],P");
    add_srs_wkt (p, 2,
        "RIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 3,
        "99433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (Lat)");
    add_srs_wkt (p, 4,
        "\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],ANGL");
    add_srs_wkt (p, 6,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoidal");
    add_srs_wkt (p, 7,
        " height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE");
    add_srs_wkt (p, 8,
        "[SCOPE[\"unknown\"],AREA[\"Latvia\"],BBOX[55.67,19.06,58");
    add_srs_wkt (p, 9,
        ".09,28.24]],ID[\"EPSG\",4949]]");
    p = add_epsg_def_ex (filter, first, last, 4390, "epsg", 4390,
        "Kertau 1968 / Johor Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=2.042583333333333 +lon_0=103.562758333");
    add_proj4text (p, 1,
        "3333 +x_0=0 +y_0=0 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 2,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Johor Grid\",GEOGCS[\"Kertau 1968");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modifie");
    add_srs_wkt (p, 2,
        "d\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6245\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4245\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",2.04258333333333],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",103.562758333333],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"4390\"]]");
    p = add_epsg_def_ex (filter, first, last, 4391, "epsg", 4391,
        "Kertau 1968 / Sembilan and Melaka Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=2.712283333333334 +lon_0=101.941166666");
    add_proj4text (p, 1,
        "6667 +x_0=-242.005 +y_0=-948.547 +a=6377304.063 +b=63561");
    add_proj4text (p, 2,
        "03.038993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Sembilan and Melaka Grid\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Kertau 1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everes");
    add_srs_wkt (p, 2,
        "t 1830 Modified\",6377304.063,300.8017,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7018\"]],AUTHORITY[\"EPSG\",\"6245\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4245\"]],PROJECTION[\"Cassini_Soldner\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",2.71228333333333],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",101.941166666667],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",-242.005],PARAMETER[\"false_northing\",-94");
    add_srs_wkt (p, 10,
        "8.547],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"4391\"]]");
    p = add_epsg_def_ex (filter, first, last, 4392, "epsg", 4392,
        "Kertau 1968 / Pahang Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=3.710972222222222 +lon_0=102.436177777");
    add_proj4text (p, 1,
        "7778 +x_0=0 +y_0=0 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 2,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Pahang Grid\",GEOGCS[\"Kertau 196");
    add_srs_wkt (p, 1,
        "8\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modifi");
    add_srs_wkt (p, 2,
        "ed\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6245\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4245\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",3.71097222222222],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",102.436177777778],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"4392\"]]");
    p = add_epsg_def_ex (filter, first, last, 4393, "epsg", 4393,
        "Kertau 1968 / Selangor Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=3.680344444444444 +lon_0=101.508244444");
    add_proj4text (p, 1,
        "4444 +x_0=-21759.438 +y_0=55960.906 +a=6377304.063 +b=63");
    add_proj4text (p, 2,
        "56103.038993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Selangor Grid\",GEOGCS[\"Kertau 1");
    add_srs_wkt (p, 1,
        "968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modi");
    add_srs_wkt (p, 2,
        "fied\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6245\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4245\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",3.68034444444444],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",101.508244444444],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",-21759.438],PARAMETER[\"false_northing\",55960.906],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 11,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"4393\"]]");
    p = add_epsg_def_ex (filter, first, last, 4394, "epsg", 4394,
        "Kertau 1968 / Terengganu Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=4.946141666666667 +lon_0=102.895208333");
    add_proj4text (p, 1,
        "3333 +x_0=0 +y_0=0 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 2,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Terengganu Grid\",GEOGCS[\"Kertau");
    add_srs_wkt (p, 1,
        " 1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Mo");
    add_srs_wkt (p, 2,
        "dified\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6245\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4245\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",4.94614166666667],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",102.895208333333],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4394\"]]");
    p = add_epsg_def_ex (filter, first, last, 4395, "epsg", 4395,
        "Kertau 1968 / Pinang Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=5.421325 +lon_0=100.3458694444444 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +a=6377304.063 +b=6356103.038993155 +towgs84=-");
    add_proj4text (p, 2,
        "11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Pinang Grid\",GEOGCS[\"Kertau 196");
    add_srs_wkt (p, 1,
        "8\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modifi");
    add_srs_wkt (p, 2,
        "ed\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6245\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4245\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",5.421325],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",100.345869444444],PARAMETER[\"false_easting\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 10,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 11,
        "\",NORTH],AUTHORITY[\"EPSG\",\"4395\"]]");
    p = add_epsg_def_ex (filter, first, last, 4396, "epsg", 4396,
        "Kertau 1968 / Kedah and Perlis Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=5.965147222222223 +lon_0=100.637594444");
    add_proj4text (p, 1,
        "4444 +x_0=0 +y_0=0 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 2,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Kedah and Perlis Grid\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Kertau 1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 Modified\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7018\"]],AUTHORITY[\"EPSG\",\"6245\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4245\"]],PROJECTION[\"Cassini_Soldner\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",5.96514722222222],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",100.637594444444],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4396\"]]");
    p = add_epsg_def_ex (filter, first, last, 4397, "epsg", 4397,
        "Kertau 1968 / Perak Revised Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=4.859380555555555 +lon_0=100.816766666");
    add_proj4text (p, 1,
        "6667 +x_0=0 +y_0=133453.669 +a=6377304.063 +b=6356103.03");
    add_proj4text (p, 2,
        "8993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Perak Revised Grid\",GEOGCS[\"Ker");
    add_srs_wkt (p, 1,
        "tau 1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830");
    add_srs_wkt (p, 2,
        " Modified\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "18\"]],AUTHORITY[\"EPSG\",\"6245\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4245\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",4.85938055555556],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",100.816766666667],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",0],PARAMETER[\"false_northing\",133453.669],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "4397\"]]");
    p = add_epsg_def_ex (filter, first, last, 4398, "epsg", 4398,
        "Kertau 1968 / Kelantan Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=5.893922222222222 +lon_0=102.177291666");
    add_proj4text (p, 1,
        "6667 +x_0=0 +y_0=0 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 2,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Kelantan Grid\",GEOGCS[\"Kertau 1");
    add_srs_wkt (p, 1,
        "968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modi");
    add_srs_wkt (p, 2,
        "fied\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6245\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4245\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",5.89392222222222],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",102.177291666667],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4398\"]]");
    p = add_epsg_def_ex (filter, first, last, 4399, "epsg", 4399,
        "NAD27 / BLM 59N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 59N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",171],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",1640416.67],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4399\"]]");
    p = add_epsg_def_ex (filter, first, last, 4400, "epsg", 4400,
        "NAD27 / BLM 60N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 60N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",177],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",1640416.67],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4400\"]]");
    p = add_epsg_def_ex (filter, first, last, 4401, "epsg", 4401,
        "NAD27 / BLM 1N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 1N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "177],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4401\"]]");
    p = add_epsg_def_ex (filter, first, last, 4402, "epsg", 4402,
        "NAD27 / BLM 2N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 2N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "171],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4402\"]]");
    p = add_epsg_def_ex (filter, first, last, 4403, "epsg", 4403,
        "NAD27 / BLM 3N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-165 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 3N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "165],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4403\"]]");
    p = add_epsg_def_ex (filter, first, last, 4404, "epsg", 4404,
        "NAD27 / BLM 4N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-159 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 4N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "159],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4404\"]]");
    p = add_epsg_def_ex (filter, first, last, 4405, "epsg", 4405,
        "NAD27 / BLM 5N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-153 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 5N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "153],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4405\"]]");
    p = add_epsg_def_ex (filter, first, last, 4406, "epsg", 4406,
        "NAD27 / BLM 6N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-147 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 6N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "147],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4406\"]]");
    p = add_epsg_def_ex (filter, first, last, 4407, "epsg", 4407,
        "NAD27 / BLM 7N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-141 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 7N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "141],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4407\"]]");
    p = add_epsg_def_ex (filter, first, last, 4408, "epsg", 4408,
        "NAD27 / BLM 8N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-135 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 8N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "135],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4408\"]]");
    p = add_epsg_def_ex (filter, first, last, 4409, "epsg", 4409,
        "NAD27 / BLM 9N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-129 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 9N (ftUS)\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "129],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1640416.67],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4409\"]]");
    p = add_epsg_def_ex (filter, first, last, 4410, "epsg", 4410,
        "NAD27 / BLM 10N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-123 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 10N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-123],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",1640416.67],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"4410\"]]");
    p = add_epsg_def_ex (filter, first, last, 4411, "epsg", 4411,
        "NAD27 / BLM 11N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-117 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 11N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-117],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",1640416.67],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"4411\"]]");
    p = add_epsg_def_ex (filter, first, last, 4412, "epsg", 4412,
        "NAD27 / BLM 12N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-111 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 12N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-111],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",1640416.67],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"4412\"]]");
    p = add_epsg_def_ex (filter, first, last, 4413, "epsg", 4413,
        "NAD27 / BLM 13N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-105 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 13N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-105],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",1640416.67],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"4413\"]]");
    p = add_epsg_def_ex (filter, first, last, 4414, "epsg", 4414,
        "NAD83(HARN) / Guam Map Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=13.5 +lon_0=144.75 +k=1 +x_0=100000 +");
    add_proj4text (p, 1,
        "y_0=200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Guam Map Grid\",GEOGCS[\"NAD83(HA");
    add_srs_wkt (p, 1,
        "RN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",13.5],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",144.75],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",100000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4414\"]]");
    p = add_epsg_def_ex (filter, first, last, 4415, "epsg", 4415,
        "Katanga 1955 / Katanga Lambert", 0, 0,
        "Clarke 1866", "Greenwich",
        "Katanga_1955", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-6.5 +lat_2=-11.5 +lat_0=-9 +lon_0=26 +");
    add_proj4text (p, 1,
        "x_0=500000 +y_0=500000 +ellps=clrk66 +towgs84=-103.746,-");
    add_proj4text (p, 2,
        "9.614,-255.95,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Katanga 1955 / Katanga Lambert\",GEOGCS[\"Katan");
    add_srs_wkt (p, 1,
        "ga 1955\",DATUM[\"Katanga_1955\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6695\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4695\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",-9],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",26],PARAMETER[\"standard_parallel_1\",-6.5],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_2\",-11.5],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",500000");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"4415\"]]");
    p = add_epsg_def_ex (filter, first, last, 4417, "epsg", 4417,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 7");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6178\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4178\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",21],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",7500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"4417\"]]");
    p = add_epsg_def_ex (filter, first, last, 4418, "epsg", 4418,
        "NAD27 / BLM 18N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-75 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 18N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",1640416.67],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4418\"]]");
    p = add_epsg_def_ex (filter, first, last, 4419, "epsg", 4419,
        "NAD27 / BLM 19N (ftUS)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-69 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 19N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",1640416.67],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 10,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"4419\"]]");
    p = add_epsg_def_ex (filter, first, last, 4420, "epsg", 4420,
        "NAD83 / BLM 60N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 60N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",177],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4420\"]]");
    p = add_epsg_def_ex (filter, first, last, 4421, "epsg", 4421,
        "NAD83 / BLM 1N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 1N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-177],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4421\"]]");
    p = add_epsg_def_ex (filter, first, last, 4422, "epsg", 4422,
        "NAD83 / BLM 2N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 2N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-171],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4422\"]]");
    p = add_epsg_def_ex (filter, first, last, 4423, "epsg", 4423,
        "NAD83 / BLM 3N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-165 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 3N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-165],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4423\"]]");
    p = add_epsg_def_ex (filter, first, last, 4424, "epsg", 4424,
        "NAD83 / BLM 4N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-159 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 4N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-159],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4424\"]]");
    p = add_epsg_def_ex (filter, first, last, 4425, "epsg", 4425,
        "NAD83 / BLM 5N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-153 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 5N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-153],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4425\"]]");
    p = add_epsg_def_ex (filter, first, last, 4426, "epsg", 4426,
        "NAD83 / BLM 6N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-147 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 6N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-147],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4426\"]]");
    p = add_epsg_def_ex (filter, first, last, 4427, "epsg", 4427,
        "NAD83 / BLM 7N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-141 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 7N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-141],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4427\"]]");
    p = add_epsg_def_ex (filter, first, last, 4428, "epsg", 4428,
        "NAD83 / BLM 8N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-135 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 8N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-135],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4428\"]]");
    p = add_epsg_def_ex (filter, first, last, 4429, "epsg", 4429,
        "NAD83 / BLM 9N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-129 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 9N (ftUS)\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-129],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4429\"]]");
    p = add_epsg_def_ex (filter, first, last, 4430, "epsg", 4430,
        "NAD83 / BLM 10N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-123 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 10N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-123],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"4430\"]]");
    p = add_epsg_def_ex (filter, first, last, 4431, "epsg", 4431,
        "NAD83 / BLM 11N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-117 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 11N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-117],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"4431\"]]");
    p = add_epsg_def_ex (filter, first, last, 4432, "epsg", 4432,
        "NAD83 / BLM 12N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-111 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 12N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-111],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"4432\"]]");
    p = add_epsg_def_ex (filter, first, last, 4433, "epsg", 4433,
        "NAD83 / BLM 13N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-105 +k=0.9996 +x_0=500000.0");
    add_proj4text (p, 1,
        "01016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 13N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-105],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"4433\"]]");
    p = add_epsg_def_ex (filter, first, last, 4434, "epsg", 4434,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 8", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 8");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",\"6178\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4178\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",24],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",8500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"4434\"]]");
    p = add_epsg_def_ex (filter, first, last, 4437, "epsg", 4437,
        "NAD83(NSRS2007) / Puerto Rico and Virgin Is.", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +");
    add_proj4text (p, 2,
        "x_0=200000 +y_0=200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 3,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Puerto Rico and Virgin Is.\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 2,
        "l_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",17.8333333333333],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-66.4333333333333],PARAMETER[\"standard_para");
    add_srs_wkt (p, 10,
        "llel_1\",18.4333333333333],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 11,
        "_2\",18.0333333333333],PARAMETER[\"false_easting\",20000");
    add_srs_wkt (p, 12,
        "0],PARAMETER[\"false_northing\",200000],UNIT[\"metre\",1");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"4437\"]]");
    p = add_epsg_def_ex (filter, first, last, 4438, "epsg", 4438,
        "NAD83 / BLM 18N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-75 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 18N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-75],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4438\"]]");
    p = add_epsg_def_ex (filter, first, last, 4439, "epsg", 4439,
        "NAD83 / BLM 19N (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-69 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / BLM 19N (ftUS)\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-69],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",1640416.67],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"4439\"]]");
    p = add_epsg_def_ex (filter, first, last, 4455, "epsg", 4455,
        "NAD27 / Pennsylvania South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Pennsylvania South\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",39.3333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-77.75],PARAMETER[\"standard");
    add_srs_wkt (p, 9,
        "_parallel_1\",40.9666666666667],PARAMETER[\"standard_par");
    add_srs_wkt (p, 10,
        "allel_2\",39.9333333333333],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 12,
        "y foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"4455\"]]");
    p = add_epsg_def_ex (filter, first, last, 4456, "epsg", 4456,
        "NAD27 / New York Long Island", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=40.5 +lon_0=-74 +x_0=609601.2192024384 +y_0=3");
    add_proj4text (p, 2,
        "0480.06096012192 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York Long Island\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",40.5],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-74],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",41.0333333333333],PARAMETER[\"standard_parallel_2\",40.");
    add_srs_wkt (p, 10,
        "6666666666667],PARAMETER[\"false_easting\",2000000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",100000],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"4456\"]]");
    p = add_epsg_def_ex (filter, first, last, 4457, "epsg", 4457,
        "NAD83 / South Dakota North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666");
    add_proj4text (p, 1,
        "666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_");
    add_proj4text (p, 2,
        "0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / South Dakota North (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",43.8333333333333],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-100],PARAMETER[\"standard_par");
    add_srs_wkt (p, 9,
        "allel_1\",45.6833333333333],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",44.4166666666667],PARAMETER[\"false_easting\",1968");
    add_srs_wkt (p, 11,
        "500],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 12,
        "ot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"4457\"]]");
    p = add_epsg_def_ex (filter, first, last, 4462, "epsg", 4462,
        "WGS 84 / Australian Centre for Remote Sensing Lambert", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-18 +lat_2=-36 +lat_0=-27 +lon_0=132 +x");
    add_proj4text (p, 1,
        "_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Australian Centre for Remote Sensing L");
    add_srs_wkt (p, 1,
        "ambert\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4326\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",-27],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",132],PARAMETER[\"standard_parallel_1\",-1");
    add_srs_wkt (p, 9,
        "8],PARAMETER[\"standard_parallel_2\",-36],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"446");
    add_srs_wkt (p, 13,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 4463, "epsg", 4463,
        "RGSPM06", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Saint_Pierre_et_Miquelon_2006", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RGSPM06\",DATUM[\"Reseau_Geodesique_de_Saint_Pi");
    add_srs_wkt (p, 1,
        "erre_et_Miquelon_2006\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"1038\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4463\"]]");
    p = add_epsg_def_ex (filter, first, last, 4466, "epsg", 4466,
        "RGSPM06", 1, 1,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Saint_Pierre_et_Miquelon_2006", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"RGSPM06\",DATUM[\"Reseau Geodesique de Saint P");
    add_srs_wkt (p, 1,
        "ierre et Miquelon 2006\",ELLIPSOID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 2,
        "298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 3,
        "ch\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[elli");
    add_srs_wkt (p, 4,
        "psoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[");
    add_srs_wkt (p, 5,
        "1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geod");
    add_srs_wkt (p, 6,
        "etic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 7,
        ",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",up");
    add_srs_wkt (p, 8,
        ",ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"unknown");
    add_srs_wkt (p, 9,
        "\"],AREA[\"St Pierre and Miquelon\"],BBOX[43.41,-57.1,47");
    add_srs_wkt (p, 10,
        ".37,-55.9]],ID[\"EPSG\",4466]]");
    p = add_epsg_def_ex (filter, first, last, 4467, "epsg", 4467,
        "RGSPM06 / UTM zone 21N", 0, 0,
        "GRS 1980", "Greenwich",
        "Reseau_Geodesique_de_Saint_Pierre_et_Miquelon_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGSPM06 / UTM zone 21N\",GEOGCS[\"RGSPM06\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Reseau_Geodesique_de_Saint_Pierre_et_Miquelon_2006\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1038\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4463\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-57],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"4467\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

